// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package machinelearning

import (
	"github.com/aws/aws-sdk-go/private/waiter"
)

// WaitUntilBatchPredictionAvailable uses the Amazon Machine Learning API operation
// DescribeBatchPredictions to wait for a condition to be met before returning.
// If the condition is not meet within the max attempt window an error will
// be returned.
func (c *MachineLearning) WaitUntilBatchPredictionAvailable(input *DescribeBatchPredictionsInput) error {
	waiterCfg := waiter.Config{
		Operation:   "DescribeBatchPredictions",
		Delay:       30,
		MaxAttempts: 60,
		Acceptors: []waiter.WaitAcceptor{
			{
				State:    "success",
				Matcher:  "pathAll",
				Argument: "Results[].Status",
				Expected: "COMPLETED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Results[].Status",
				Expected: "FAILED",
			},
		},
	}

	w := waiter.Waiter{
		Client: c,
		Input:  input,
		Config: waiterCfg,
	}
	return w.Wait()
}

// WaitUntilDataSourceAvailable uses the Amazon Machine Learning API operation
// DescribeDataSources to wait for a condition to be met before returning.
// If the condition is not meet within the max attempt window an error will
// be returned.
func (c *MachineLearning) WaitUntilDataSourceAvailable(input *DescribeDataSourcesInput) error {
	waiterCfg := waiter.Config{
		Operation:   "DescribeDataSources",
		Delay:       30,
		MaxAttempts: 60,
		Acceptors: []waiter.WaitAcceptor{
			{
				State:    "success",
				Matcher:  "pathAll",
				Argument: "Results[].Status",
				Expected: "COMPLETED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Results[].Status",
				Expected: "FAILED",
			},
		},
	}

	w := waiter.Waiter{
		Client: c,
		Input:  input,
		Config: waiterCfg,
	}
	return w.Wait()
}

// WaitUntilEvaluationAvailable uses the Amazon Machine Learning API operation
// DescribeEvaluations to wait for a condition to be met before returning.
// If the condition is not meet within the max attempt window an error will
// be returned.
func (c *MachineLearning) WaitUntilEvaluationAvailable(input *DescribeEvaluationsInput) error {
	waiterCfg := waiter.Config{
		Operation:   "DescribeEvaluations",
		Delay:       30,
		MaxAttempts: 60,
		Acceptors: []waiter.WaitAcceptor{
			{
				State:    "success",
				Matcher:  "pathAll",
				Argument: "Results[].Status",
				Expected: "COMPLETED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Results[].Status",
				Expected: "FAILED",
			},
		},
	}

	w := waiter.Waiter{
		Client: c,
		Input:  input,
		Config: waiterCfg,
	}
	return w.Wait()
}

// WaitUntilMLModelAvailable uses the Amazon Machine Learning API operation
// DescribeMLModels to wait for a condition to be met before returning.
// If the condition is not meet within the max attempt window an error will
// be returned.
func (c *MachineLearning) WaitUntilMLModelAvailable(input *DescribeMLModelsInput) error {
	waiterCfg := waiter.Config{
		Operation:   "DescribeMLModels",
		Delay:       30,
		MaxAttempts: 60,
		Acceptors: []waiter.WaitAcceptor{
			{
				State:    "success",
				Matcher:  "pathAll",
				Argument: "Results[].Status",
				Expected: "COMPLETED",
			},
			{
				State:    "failure",
				Matcher:  "pathAny",
				Argument: "Results[].Status",
				Expected: "FAILED",
			},
		},
	}

	w := waiter.Waiter{
		Client: c,
		Input:  input,
		Config: waiterCfg,
	}
	return w.Wait()
}
