// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package pinpoint provides a client for Amazon Pinpoint.
package pinpoint

import (
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the CreateCampaign operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateCampaign for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateCampaign method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateCampaignRequest method.
//    req, resp := client.CreateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateCampaign
func (c *Pinpoint) CreateCampaignRequest(input *CreateCampaignInput) (req *request.Request, output *CreateCampaignOutput) {
	op := &request.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/campaigns",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	output = &CreateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCampaign API operation for Amazon Pinpoint.
//
// Creates or updates a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateCampaign for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateCampaign
func (c *Pinpoint) CreateCampaign(input *CreateCampaignInput) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	err := req.Send()
	return out, err
}

const opCreateImportJob = "CreateImportJob"

// CreateImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateImportJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateImportJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateImportJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateImportJobRequest method.
//    req, resp := client.CreateImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateImportJob
func (c *Pinpoint) CreateImportJobRequest(input *CreateImportJobInput) (req *request.Request, output *CreateImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import",
	}

	if input == nil {
		input = &CreateImportJobInput{}
	}

	output = &CreateImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImportJob API operation for Amazon Pinpoint.
//
// Creates or updates an import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateImportJob for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateImportJob
func (c *Pinpoint) CreateImportJob(input *CreateImportJobInput) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSegment = "CreateSegment"

// CreateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateSegment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSegment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSegment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSegmentRequest method.
//    req, resp := client.CreateSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateSegment
func (c *Pinpoint) CreateSegmentRequest(input *CreateSegmentInput) (req *request.Request, output *CreateSegmentOutput) {
	op := &request.Operation{
		Name:       opCreateSegment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/segments",
	}

	if input == nil {
		input = &CreateSegmentInput{}
	}

	output = &CreateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSegment API operation for Amazon Pinpoint.
//
// Used to create or update a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateSegment for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateSegment
func (c *Pinpoint) CreateSegment(input *CreateSegmentInput) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteApnsChannel = "DeleteApnsChannel"

// DeleteApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsChannel operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteApnsChannel for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteApnsChannel method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteApnsChannelRequest method.
//    req, resp := client.DeleteApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteApnsChannel
func (c *Pinpoint) DeleteApnsChannelRequest(input *DeleteApnsChannelInput) (req *request.Request, output *DeleteApnsChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &DeleteApnsChannelInput{}
	}

	output = &DeleteApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsChannel API operation for Amazon Pinpoint.
//
// Deletes the APNs channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteApnsChannel
func (c *Pinpoint) DeleteApnsChannel(input *DeleteApnsChannelInput) (*DeleteApnsChannelOutput, error) {
	req, out := c.DeleteApnsChannelRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCampaign operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteCampaign for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteCampaign method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteCampaignRequest method.
//    req, resp := client.DeleteCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteCampaign
func (c *Pinpoint) DeleteCampaignRequest(input *DeleteCampaignInput) (req *request.Request, output *DeleteCampaignOutput) {
	op := &request.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	output = &DeleteCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCampaign API operation for Amazon Pinpoint.
//
// Deletes a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteCampaign for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteCampaign
func (c *Pinpoint) DeleteCampaign(input *DeleteCampaignInput) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteGcmChannel = "DeleteGcmChannel"

// DeleteGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGcmChannel operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteGcmChannel for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteGcmChannel method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteGcmChannelRequest method.
//    req, resp := client.DeleteGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteGcmChannel
func (c *Pinpoint) DeleteGcmChannelRequest(input *DeleteGcmChannelInput) (req *request.Request, output *DeleteGcmChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteGcmChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &DeleteGcmChannelInput{}
	}

	output = &DeleteGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGcmChannel API operation for Amazon Pinpoint.
//
// Deletes the GCM channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteGcmChannel
func (c *Pinpoint) DeleteGcmChannel(input *DeleteGcmChannelInput) (*DeleteGcmChannelOutput, error) {
	req, out := c.DeleteGcmChannelRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSegment = "DeleteSegment"

// DeleteSegmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSegment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSegment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSegment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSegmentRequest method.
//    req, resp := client.DeleteSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteSegment
func (c *Pinpoint) DeleteSegmentRequest(input *DeleteSegmentInput) (req *request.Request, output *DeleteSegmentOutput) {
	op := &request.Operation{
		Name:       opDeleteSegment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &DeleteSegmentInput{}
	}

	output = &DeleteSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSegment API operation for Amazon Pinpoint.
//
// Deletes a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteSegment for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteSegment
func (c *Pinpoint) DeleteSegment(input *DeleteSegmentInput) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	err := req.Send()
	return out, err
}

const opGetApnsChannel = "GetApnsChannel"

// GetApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsChannel operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetApnsChannel for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetApnsChannel method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetApnsChannelRequest method.
//    req, resp := client.GetApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetApnsChannel
func (c *Pinpoint) GetApnsChannelRequest(input *GetApnsChannelInput) (req *request.Request, output *GetApnsChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &GetApnsChannelInput{}
	}

	output = &GetApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsChannel API operation for Amazon Pinpoint.
//
// Returns information about the APNs channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetApnsChannel
func (c *Pinpoint) GetApnsChannel(input *GetApnsChannelInput) (*GetApnsChannelOutput, error) {
	req, out := c.GetApnsChannelRequest(input)
	err := req.Send()
	return out, err
}

const opGetApplicationSettings = "GetApplicationSettings"

// GetApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationSettings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetApplicationSettings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetApplicationSettings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetApplicationSettingsRequest method.
//    req, resp := client.GetApplicationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetApplicationSettings
func (c *Pinpoint) GetApplicationSettingsRequest(input *GetApplicationSettingsInput) (req *request.Request, output *GetApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opGetApplicationSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/settings",
	}

	if input == nil {
		input = &GetApplicationSettingsInput{}
	}

	output = &GetApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationSettings API operation for Amazon Pinpoint.
//
// Used to request the settings for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApplicationSettings for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetApplicationSettings
func (c *Pinpoint) GetApplicationSettings(input *GetApplicationSettingsInput) (*GetApplicationSettingsOutput, error) {
	req, out := c.GetApplicationSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opGetCampaign = "GetCampaign"

// GetCampaignRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaign operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCampaign for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCampaign method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCampaignRequest method.
//    req, resp := client.GetCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaign
func (c *Pinpoint) GetCampaignRequest(input *GetCampaignInput) (req *request.Request, output *GetCampaignOutput) {
	op := &request.Operation{
		Name:       opGetCampaign,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &GetCampaignInput{}
	}

	output = &GetCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaign API operation for Amazon Pinpoint.
//
// Returns information about a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaign for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaign
func (c *Pinpoint) GetCampaign(input *GetCampaignInput) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	err := req.Send()
	return out, err
}

const opGetCampaignActivities = "GetCampaignActivities"

// GetCampaignActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignActivities operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCampaignActivities for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCampaignActivities method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCampaignActivitiesRequest method.
//    req, resp := client.GetCampaignActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignActivities
func (c *Pinpoint) GetCampaignActivitiesRequest(input *GetCampaignActivitiesInput) (req *request.Request, output *GetCampaignActivitiesOutput) {
	op := &request.Operation{
		Name:       opGetCampaignActivities,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/activities",
	}

	if input == nil {
		input = &GetCampaignActivitiesInput{}
	}

	output = &GetCampaignActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignActivities API operation for Amazon Pinpoint.
//
// Returns information about the activity performed by a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignActivities for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignActivities
func (c *Pinpoint) GetCampaignActivities(input *GetCampaignActivitiesInput) (*GetCampaignActivitiesOutput, error) {
	req, out := c.GetCampaignActivitiesRequest(input)
	err := req.Send()
	return out, err
}

const opGetCampaignVersion = "GetCampaignVersion"

// GetCampaignVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCampaignVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCampaignVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCampaignVersionRequest method.
//    req, resp := client.GetCampaignVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignVersion
func (c *Pinpoint) GetCampaignVersionRequest(input *GetCampaignVersionInput) (req *request.Request, output *GetCampaignVersionOutput) {
	op := &request.Operation{
		Name:       opGetCampaignVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}",
	}

	if input == nil {
		input = &GetCampaignVersionInput{}
	}

	output = &GetCampaignVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignVersion API operation for Amazon Pinpoint.
//
// Returns information about your campaign versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignVersion for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignVersion
func (c *Pinpoint) GetCampaignVersion(input *GetCampaignVersionInput) (*GetCampaignVersionOutput, error) {
	req, out := c.GetCampaignVersionRequest(input)
	err := req.Send()
	return out, err
}

const opGetCampaignVersions = "GetCampaignVersions"

// GetCampaignVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignVersions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCampaignVersions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCampaignVersions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCampaignVersionsRequest method.
//    req, resp := client.GetCampaignVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignVersions
func (c *Pinpoint) GetCampaignVersionsRequest(input *GetCampaignVersionsInput) (req *request.Request, output *GetCampaignVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCampaignVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/versions",
	}

	if input == nil {
		input = &GetCampaignVersionsInput{}
	}

	output = &GetCampaignVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignVersions API operation for Amazon Pinpoint.
//
// Returns information about your campaign versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignVersions for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignVersions
func (c *Pinpoint) GetCampaignVersions(input *GetCampaignVersionsInput) (*GetCampaignVersionsOutput, error) {
	req, out := c.GetCampaignVersionsRequest(input)
	err := req.Send()
	return out, err
}

const opGetCampaigns = "GetCampaigns"

// GetCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaigns operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCampaigns for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCampaigns method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCampaignsRequest method.
//    req, resp := client.GetCampaignsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaigns
func (c *Pinpoint) GetCampaignsRequest(input *GetCampaignsInput) (req *request.Request, output *GetCampaignsOutput) {
	op := &request.Operation{
		Name:       opGetCampaigns,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns",
	}

	if input == nil {
		input = &GetCampaignsInput{}
	}

	output = &GetCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaigns API operation for Amazon Pinpoint.
//
// Returns information about your campaigns.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaigns for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaigns
func (c *Pinpoint) GetCampaigns(input *GetCampaignsInput) (*GetCampaignsOutput, error) {
	req, out := c.GetCampaignsRequest(input)
	err := req.Send()
	return out, err
}

const opGetEndpoint = "GetEndpoint"

// GetEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetEndpointRequest method.
//    req, resp := client.GetEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetEndpoint
func (c *Pinpoint) GetEndpointRequest(input *GetEndpointInput) (req *request.Request, output *GetEndpointOutput) {
	op := &request.Operation{
		Name:       opGetEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &GetEndpointInput{}
	}

	output = &GetEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEndpoint API operation for Amazon Pinpoint.
//
// Returns information about an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEndpoint for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetEndpoint
func (c *Pinpoint) GetEndpoint(input *GetEndpointInput) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opGetGcmChannel = "GetGcmChannel"

// GetGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetGcmChannel operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetGcmChannel for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetGcmChannel method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetGcmChannelRequest method.
//    req, resp := client.GetGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetGcmChannel
func (c *Pinpoint) GetGcmChannelRequest(input *GetGcmChannelInput) (req *request.Request, output *GetGcmChannelOutput) {
	op := &request.Operation{
		Name:       opGetGcmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &GetGcmChannelInput{}
	}

	output = &GetGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGcmChannel API operation for Amazon Pinpoint.
//
// Returns information about the GCM channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetGcmChannel
func (c *Pinpoint) GetGcmChannel(input *GetGcmChannelInput) (*GetGcmChannelOutput, error) {
	req, out := c.GetGcmChannelRequest(input)
	err := req.Send()
	return out, err
}

const opGetImportJob = "GetImportJob"

// GetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetImportJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetImportJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetImportJobRequest method.
//    req, resp := client.GetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetImportJob
func (c *Pinpoint) GetImportJobRequest(input *GetImportJobInput) (req *request.Request, output *GetImportJobOutput) {
	op := &request.Operation{
		Name:       opGetImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import/{job-id}",
	}

	if input == nil {
		input = &GetImportJobInput{}
	}

	output = &GetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJob API operation for Amazon Pinpoint.
//
// Returns information about an import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetImportJob for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetImportJob
func (c *Pinpoint) GetImportJob(input *GetImportJobInput) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	err := req.Send()
	return out, err
}

const opGetImportJobs = "GetImportJobs"

// GetImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJobs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetImportJobs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetImportJobs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetImportJobsRequest method.
//    req, resp := client.GetImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetImportJobs
func (c *Pinpoint) GetImportJobsRequest(input *GetImportJobsInput) (req *request.Request, output *GetImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import",
	}

	if input == nil {
		input = &GetImportJobsInput{}
	}

	output = &GetImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJobs API operation for Amazon Pinpoint.
//
// Returns information about your import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetImportJobs for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetImportJobs
func (c *Pinpoint) GetImportJobs(input *GetImportJobsInput) (*GetImportJobsOutput, error) {
	req, out := c.GetImportJobsRequest(input)
	err := req.Send()
	return out, err
}

const opGetSegment = "GetSegment"

// GetSegmentRequest generates a "aws/request.Request" representing the
// client's request for the GetSegment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSegment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSegment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSegmentRequest method.
//    req, resp := client.GetSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegment
func (c *Pinpoint) GetSegmentRequest(input *GetSegmentInput) (req *request.Request, output *GetSegmentOutput) {
	op := &request.Operation{
		Name:       opGetSegment,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &GetSegmentInput{}
	}

	output = &GetSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegment API operation for Amazon Pinpoint.
//
// Returns information about a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegment for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegment
func (c *Pinpoint) GetSegment(input *GetSegmentInput) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	err := req.Send()
	return out, err
}

const opGetSegmentImportJobs = "GetSegmentImportJobs"

// GetSegmentImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentImportJobs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSegmentImportJobs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSegmentImportJobs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSegmentImportJobsRequest method.
//    req, resp := client.GetSegmentImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentImportJobs
func (c *Pinpoint) GetSegmentImportJobsRequest(input *GetSegmentImportJobsInput) (req *request.Request, output *GetSegmentImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/jobs/import",
	}

	if input == nil {
		input = &GetSegmentImportJobsInput{}
	}

	output = &GetSegmentImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentImportJobs API operation for Amazon Pinpoint.
//
// Returns a list of import jobs for a specific segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentImportJobs for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentImportJobs
func (c *Pinpoint) GetSegmentImportJobs(input *GetSegmentImportJobsInput) (*GetSegmentImportJobsOutput, error) {
	req, out := c.GetSegmentImportJobsRequest(input)
	err := req.Send()
	return out, err
}

const opGetSegmentVersion = "GetSegmentVersion"

// GetSegmentVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSegmentVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSegmentVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSegmentVersionRequest method.
//    req, resp := client.GetSegmentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentVersion
func (c *Pinpoint) GetSegmentVersionRequest(input *GetSegmentVersionInput) (req *request.Request, output *GetSegmentVersionOutput) {
	op := &request.Operation{
		Name:       opGetSegmentVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}",
	}

	if input == nil {
		input = &GetSegmentVersionInput{}
	}

	output = &GetSegmentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentVersion API operation for Amazon Pinpoint.
//
// Returns information about a segment version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentVersion for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentVersion
func (c *Pinpoint) GetSegmentVersion(input *GetSegmentVersionInput) (*GetSegmentVersionOutput, error) {
	req, out := c.GetSegmentVersionRequest(input)
	err := req.Send()
	return out, err
}

const opGetSegmentVersions = "GetSegmentVersions"

// GetSegmentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentVersions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSegmentVersions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSegmentVersions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSegmentVersionsRequest method.
//    req, resp := client.GetSegmentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentVersions
func (c *Pinpoint) GetSegmentVersionsRequest(input *GetSegmentVersionsInput) (req *request.Request, output *GetSegmentVersionsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions",
	}

	if input == nil {
		input = &GetSegmentVersionsInput{}
	}

	output = &GetSegmentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentVersions API operation for Amazon Pinpoint.
//
// Returns information about your segment versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentVersions for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentVersions
func (c *Pinpoint) GetSegmentVersions(input *GetSegmentVersionsInput) (*GetSegmentVersionsOutput, error) {
	req, out := c.GetSegmentVersionsRequest(input)
	err := req.Send()
	return out, err
}

const opGetSegments = "GetSegments"

// GetSegmentsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegments operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSegments for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSegments method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSegmentsRequest method.
//    req, resp := client.GetSegmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegments
func (c *Pinpoint) GetSegmentsRequest(input *GetSegmentsInput) (req *request.Request, output *GetSegmentsOutput) {
	op := &request.Operation{
		Name:       opGetSegments,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments",
	}

	if input == nil {
		input = &GetSegmentsInput{}
	}

	output = &GetSegmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegments API operation for Amazon Pinpoint.
//
// Used to get information about your segments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegments for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegments
func (c *Pinpoint) GetSegments(input *GetSegmentsInput) (*GetSegmentsOutput, error) {
	req, out := c.GetSegmentsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApnsChannel = "UpdateApnsChannel"

// UpdateApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsChannel operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateApnsChannel for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateApnsChannel method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateApnsChannelRequest method.
//    req, resp := client.UpdateApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateApnsChannel
func (c *Pinpoint) UpdateApnsChannelRequest(input *UpdateApnsChannelInput) (req *request.Request, output *UpdateApnsChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &UpdateApnsChannelInput{}
	}

	output = &UpdateApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsChannel API operation for Amazon Pinpoint.
//
// Use to update the APNs channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateApnsChannel
func (c *Pinpoint) UpdateApnsChannel(input *UpdateApnsChannelInput) (*UpdateApnsChannelOutput, error) {
	req, out := c.UpdateApnsChannelRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApplicationSettings = "UpdateApplicationSettings"

// UpdateApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationSettings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateApplicationSettings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateApplicationSettings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateApplicationSettingsRequest method.
//    req, resp := client.UpdateApplicationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateApplicationSettings
func (c *Pinpoint) UpdateApplicationSettingsRequest(input *UpdateApplicationSettingsInput) (req *request.Request, output *UpdateApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/settings",
	}

	if input == nil {
		input = &UpdateApplicationSettingsInput{}
	}

	output = &UpdateApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplicationSettings API operation for Amazon Pinpoint.
//
// Used to update the settings for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApplicationSettings for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateApplicationSettings
func (c *Pinpoint) UpdateApplicationSettings(input *UpdateApplicationSettingsInput) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateCampaign = "UpdateCampaign"

// UpdateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaign operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateCampaign for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateCampaign method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateCampaignRequest method.
//    req, resp := client.UpdateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateCampaign
func (c *Pinpoint) UpdateCampaignRequest(input *UpdateCampaignInput) (req *request.Request, output *UpdateCampaignOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaign,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &UpdateCampaignInput{}
	}

	output = &UpdateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCampaign API operation for Amazon Pinpoint.
//
// Use to update a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateCampaign for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateCampaign
func (c *Pinpoint) UpdateCampaign(input *UpdateCampaignInput) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateEndpointRequest method.
//    req, resp := client.UpdateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateEndpoint
func (c *Pinpoint) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon Pinpoint.
//
// Use to update an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateEndpoint
func (c *Pinpoint) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateEndpointsBatch = "UpdateEndpointsBatch"

// UpdateEndpointsBatchRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointsBatch operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateEndpointsBatch for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateEndpointsBatch method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateEndpointsBatchRequest method.
//    req, resp := client.UpdateEndpointsBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateEndpointsBatch
func (c *Pinpoint) UpdateEndpointsBatchRequest(input *UpdateEndpointsBatchInput) (req *request.Request, output *UpdateEndpointsBatchOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointsBatch,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints",
	}

	if input == nil {
		input = &UpdateEndpointsBatchInput{}
	}

	output = &UpdateEndpointsBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointsBatch API operation for Amazon Pinpoint.
//
// Use to update your endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEndpointsBatch for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateEndpointsBatch
func (c *Pinpoint) UpdateEndpointsBatch(input *UpdateEndpointsBatchInput) (*UpdateEndpointsBatchOutput, error) {
	req, out := c.UpdateEndpointsBatchRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateGcmChannel = "UpdateGcmChannel"

// UpdateGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGcmChannel operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateGcmChannel for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateGcmChannel method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateGcmChannelRequest method.
//    req, resp := client.UpdateGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateGcmChannel
func (c *Pinpoint) UpdateGcmChannelRequest(input *UpdateGcmChannelInput) (req *request.Request, output *UpdateGcmChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateGcmChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &UpdateGcmChannelInput{}
	}

	output = &UpdateGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGcmChannel API operation for Amazon Pinpoint.
//
// Use to update the GCM channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateGcmChannel
func (c *Pinpoint) UpdateGcmChannel(input *UpdateGcmChannelInput) (*UpdateGcmChannelOutput, error) {
	req, out := c.UpdateGcmChannelRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSegment = "UpdateSegment"

// UpdateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSegment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateSegment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateSegment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateSegmentRequest method.
//    req, resp := client.UpdateSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateSegment
func (c *Pinpoint) UpdateSegmentRequest(input *UpdateSegmentInput) (req *request.Request, output *UpdateSegmentOutput) {
	op := &request.Operation{
		Name:       opUpdateSegment,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &UpdateSegmentInput{}
	}

	output = &UpdateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSegment API operation for Amazon Pinpoint.
//
// Use to update a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateSegment for usage and error information.
//
// Returned Error Codes:
//   * BadRequestException
//   400 response
//
//   * InternalServerErrorException
//   500 response
//
//   * ForbiddenException
//   403 response
//
//   * NotFoundException
//   404 response
//
//   * MethodNotAllowedException
//   405 response
//
//   * TooManyRequestsException
//   429 response
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateSegment
func (c *Pinpoint) UpdateSegment(input *UpdateSegmentInput) (*UpdateSegmentOutput, error) {
	req, out := c.UpdateSegmentRequest(input)
	err := req.Send()
	return out, err
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//APNSChannelRequest
type APNSChannelRequest struct {
	_ struct{} `type:"structure"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The certificate private key.
	PrivateKey *string `type:"string"`
}

// String returns the string representation
func (s APNSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSChannelRequest) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *APNSChannelRequest) SetCertificate(v string) *APNSChannelRequest {
	s.Certificate = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSChannelRequest) SetPrivateKey(v string) *APNSChannelRequest {
	s.PrivateKey = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//APNSChannelResponse
type APNSChannelResponse struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be APNS.
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSChannelResponse) SetApplicationId(v string) *APNSChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSChannelResponse) SetCreationDate(v string) *APNSChannelResponse {
	s.CreationDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSChannelResponse) SetId(v string) *APNSChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSChannelResponse) SetIsArchived(v bool) *APNSChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSChannelResponse) SetLastModifiedBy(v string) *APNSChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSChannelResponse) SetLastModifiedDate(v string) *APNSChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSChannelResponse) SetPlatform(v string) *APNSChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSChannelResponse) SetVersion(v int64) *APNSChannelResponse {
	s.Version = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//ActivitiesResponse
type ActivitiesResponse struct {
	_ struct{} `type:"structure"`

	// List of campaign activities
	Item []*ActivityResponse `type:"list"`
}

// String returns the string representation
func (s ActivitiesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivitiesResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ActivitiesResponse) SetItem(v []*ActivityResponse) *ActivitiesResponse {
	s.Item = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//ActivityResponse
type ActivityResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the campaign applies.
	ApplicationId *string `type:"string"`

	// The ID of the campaign to which the activity applies.
	CampaignId *string `type:"string"`

	// The actual time the activity was marked CANCELLED or COMPLETED. Provided
	// in ISO 8601 format.
	End *string `type:"string"`

	// The unique activity ID.
	Id *string `type:"string"`

	// Indicates whether the activity succeeded.Valid values: SUCCESS, FAIL
	Result *string `type:"string"`

	// The scheduled start time for the activity in ISO 8601 format.
	ScheduledStart *string `type:"string"`

	// The actual start time of the activity in ISO 8601 format.
	Start *string `type:"string"`

	// The state of the activity.Valid values: PENDING, INITIALIZING, RUNNING, PAUSED,
	// CANCELLED, COMPLETED
	State *string `type:"string"`

	// The total number of endpoints to which the campaign successfully delivered
	// messages.
	SuccessfulEndpointCount *int64 `type:"integer"`

	// The total number of endpoints to which the campaign attempts to deliver messages.
	TotalEndpointCount *int64 `type:"integer"`

	// The ID of a variation of the campaign used for A/B testing.
	TreatmentId *string `type:"string"`
}

// String returns the string representation
func (s ActivityResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ActivityResponse) SetApplicationId(v string) *ActivityResponse {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *ActivityResponse) SetCampaignId(v string) *ActivityResponse {
	s.CampaignId = &v
	return s
}

// SetEnd sets the End field's value.
func (s *ActivityResponse) SetEnd(v string) *ActivityResponse {
	s.End = &v
	return s
}

// SetId sets the Id field's value.
func (s *ActivityResponse) SetId(v string) *ActivityResponse {
	s.Id = &v
	return s
}

// SetResult sets the Result field's value.
func (s *ActivityResponse) SetResult(v string) *ActivityResponse {
	s.Result = &v
	return s
}

// SetScheduledStart sets the ScheduledStart field's value.
func (s *ActivityResponse) SetScheduledStart(v string) *ActivityResponse {
	s.ScheduledStart = &v
	return s
}

// SetStart sets the Start field's value.
func (s *ActivityResponse) SetStart(v string) *ActivityResponse {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *ActivityResponse) SetState(v string) *ActivityResponse {
	s.State = &v
	return s
}

// SetSuccessfulEndpointCount sets the SuccessfulEndpointCount field's value.
func (s *ActivityResponse) SetSuccessfulEndpointCount(v int64) *ActivityResponse {
	s.SuccessfulEndpointCount = &v
	return s
}

// SetTotalEndpointCount sets the TotalEndpointCount field's value.
func (s *ActivityResponse) SetTotalEndpointCount(v int64) *ActivityResponse {
	s.TotalEndpointCount = &v
	return s
}

// SetTreatmentId sets the TreatmentId field's value.
func (s *ActivityResponse) SetTreatmentId(v string) *ActivityResponse {
	s.TreatmentId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//ApplicationSettingsResource
type ApplicationSettingsResource struct {
	_ struct{} `type:"structure"`

	// The unique ID for the application.
	ApplicationId *string `type:"string"`

	// The date that the settings were last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The default campaign limits for the app. These limits apply to each campaign
	// for the app, unless the campaign overrides the default with limits of its
	// own.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for the app. Each campaign for this app sends no messages
	// during this time unless the campaign overrides the default with a quiet time
	// of its own.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s ApplicationSettingsResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSettingsResource) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationSettingsResource) SetApplicationId(v string) *ApplicationSettingsResource {
	s.ApplicationId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ApplicationSettingsResource) SetLastModifiedDate(v string) *ApplicationSettingsResource {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *ApplicationSettingsResource) SetLimits(v *CampaignLimits) *ApplicationSettingsResource {
	s.Limits = v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *ApplicationSettingsResource) SetQuietTime(v *QuietTime) *ApplicationSettingsResource {
	s.QuietTime = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//AttributeDimension
type AttributeDimension struct {
	_ struct{} `type:"structure"`

	AttributeType *string `type:"string" enum:"AttributeType"`

	Values []*string `type:"list"`
}

// String returns the string representation
func (s AttributeDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeDimension) GoString() string {
	return s.String()
}

// SetAttributeType sets the AttributeType field's value.
func (s *AttributeDimension) SetAttributeType(v string) *AttributeDimension {
	s.AttributeType = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AttributeDimension) SetValues(v []*string) *AttributeDimension {
	s.Values = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CampaignLimits
type CampaignLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of messages that the campaign can send daily.
	Daily *int64 `type:"integer"`

	// The maximum total number of messages that the campaign can send.
	Total *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignLimits) GoString() string {
	return s.String()
}

// SetDaily sets the Daily field's value.
func (s *CampaignLimits) SetDaily(v int64) *CampaignLimits {
	s.Daily = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *CampaignLimits) SetTotal(v int64) *CampaignLimits {
	s.Total = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CampaignResponse
type CampaignResponse struct {
	_ struct{} `type:"structure"`

	// Treatments that are defined in addition to the default treatment.
	AdditionalTreatments []*TreatmentResource `type:"list"`

	// The ID of the application to which the campaign applies.
	ApplicationId *string `type:"string"`

	// The date the campaign was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The status of the campaign's default treatment. Only present for A/B test
	// campaigns.
	DefaultState *CampaignState `type:"structure"`

	// A description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of end users who will not receive messages from
	// this campaign.
	HoldoutPercent *int64 `type:"integer"`

	// The unique campaign ID.
	Id *string `type:"string"`

	// Indicates whether the campaign is paused. A paused campaign does not send
	// messages unless you resume it by setting IsPaused to false.
	IsPaused *bool `type:"boolean"`

	// The date the campaign was last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The campaign limits settings.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The custom name of the campaign.
	Name *string `type:"string"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The ID of the segment to which the campaign sends messages.
	SegmentId *string `type:"string"`

	// The version of the segment to which the campaign sends messages.
	SegmentVersion *int64 `type:"integer"`

	// The campaign status.An A/B test campaign will have a status of COMPLETED
	// only when all treatments have a status of COMPLETED.
	State *CampaignState `type:"structure"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`

	// The campaign version number.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignResponse) GoString() string {
	return s.String()
}

// SetAdditionalTreatments sets the AdditionalTreatments field's value.
func (s *CampaignResponse) SetAdditionalTreatments(v []*TreatmentResource) *CampaignResponse {
	s.AdditionalTreatments = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CampaignResponse) SetApplicationId(v string) *CampaignResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CampaignResponse) SetCreationDate(v string) *CampaignResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultState sets the DefaultState field's value.
func (s *CampaignResponse) SetDefaultState(v *CampaignState) *CampaignResponse {
	s.DefaultState = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CampaignResponse) SetDescription(v string) *CampaignResponse {
	s.Description = &v
	return s
}

// SetHoldoutPercent sets the HoldoutPercent field's value.
func (s *CampaignResponse) SetHoldoutPercent(v int64) *CampaignResponse {
	s.HoldoutPercent = &v
	return s
}

// SetId sets the Id field's value.
func (s *CampaignResponse) SetId(v string) *CampaignResponse {
	s.Id = &v
	return s
}

// SetIsPaused sets the IsPaused field's value.
func (s *CampaignResponse) SetIsPaused(v bool) *CampaignResponse {
	s.IsPaused = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CampaignResponse) SetLastModifiedDate(v string) *CampaignResponse {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *CampaignResponse) SetLimits(v *CampaignLimits) *CampaignResponse {
	s.Limits = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *CampaignResponse) SetMessageConfiguration(v *MessageConfiguration) *CampaignResponse {
	s.MessageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CampaignResponse) SetName(v string) *CampaignResponse {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CampaignResponse) SetSchedule(v *Schedule) *CampaignResponse {
	s.Schedule = v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *CampaignResponse) SetSegmentId(v string) *CampaignResponse {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *CampaignResponse) SetSegmentVersion(v int64) *CampaignResponse {
	s.SegmentVersion = &v
	return s
}

// SetState sets the State field's value.
func (s *CampaignResponse) SetState(v *CampaignState) *CampaignResponse {
	s.State = v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *CampaignResponse) SetTreatmentDescription(v string) *CampaignResponse {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *CampaignResponse) SetTreatmentName(v string) *CampaignResponse {
	s.TreatmentName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CampaignResponse) SetVersion(v int64) *CampaignResponse {
	s.Version = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CampaignState
type CampaignState struct {
	_ struct{} `type:"structure"`

	CampaignStatus *string `type:"string" enum:"CampaignStatus"`
}

// String returns the string representation
func (s CampaignState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignState) GoString() string {
	return s.String()
}

// SetCampaignStatus sets the CampaignStatus field's value.
func (s *CampaignState) SetCampaignStatus(v string) *CampaignState {
	s.CampaignStatus = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CampaignsResponse
type CampaignsResponse struct {
	_ struct{} `type:"structure"`

	// A list of campaigns.
	Item []*CampaignResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s CampaignsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *CampaignsResponse) SetItem(v []*CampaignResponse) *CampaignsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *CampaignsResponse) SetNextToken(v string) *CampaignsResponse {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateCampaignRequest
type CreateCampaignInput struct {
	_ struct{} `type:"structure" payload:"WriteCampaignRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// WriteCampaignRequest is a required field
	WriteCampaignRequest *WriteCampaignRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WriteCampaignRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCampaignRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateCampaignInput) SetApplicationId(v string) *CreateCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetWriteCampaignRequest sets the WriteCampaignRequest field's value.
func (s *CreateCampaignInput) SetWriteCampaignRequest(v *WriteCampaignRequest) *CreateCampaignInput {
	s.WriteCampaignRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateCampaignResponse
type CreateCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *CreateCampaignOutput) SetCampaignResponse(v *CampaignResponse) *CreateCampaignOutput {
	s.CampaignResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateImportJobRequest
type CreateImportJobInput struct {
	_ struct{} `type:"structure" payload:"ImportJobRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// ImportJobRequest is a required field
	ImportJobRequest *ImportJobRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ImportJobRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportJobRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateImportJobInput) SetApplicationId(v string) *CreateImportJobInput {
	s.ApplicationId = &v
	return s
}

// SetImportJobRequest sets the ImportJobRequest field's value.
func (s *CreateImportJobInput) SetImportJobRequest(v *ImportJobRequest) *CreateImportJobInput {
	s.ImportJobRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateImportJobResponse
type CreateImportJobOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobResponse"`

	// ImportJobResponse is a required field
	ImportJobResponse *ImportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobResponse sets the ImportJobResponse field's value.
func (s *CreateImportJobOutput) SetImportJobResponse(v *ImportJobResponse) *CreateImportJobOutput {
	s.ImportJobResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateSegmentRequest
type CreateSegmentInput struct {
	_ struct{} `type:"structure" payload:"WriteSegmentRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// WriteSegmentRequest is a required field
	WriteSegmentRequest *WriteSegmentRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WriteSegmentRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteSegmentRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateSegmentInput) SetApplicationId(v string) *CreateSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetWriteSegmentRequest sets the WriteSegmentRequest field's value.
func (s *CreateSegmentInput) SetWriteSegmentRequest(v *WriteSegmentRequest) *CreateSegmentInput {
	s.WriteSegmentRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//CreateSegmentResponse
type CreateSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *CreateSegmentOutput) SetSegmentResponse(v *SegmentResponse) *CreateSegmentOutput {
	s.SegmentResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteApnsChannelRequest
type DeleteApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsChannelInput) SetApplicationId(v string) *DeleteApnsChannelInput {
	s.ApplicationId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteApnsChannelResponse
type DeleteApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *DeleteApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *DeleteApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteCampaignRequest
type DeleteCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteCampaignInput) SetApplicationId(v string) *DeleteCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *DeleteCampaignInput) SetCampaignId(v string) *DeleteCampaignInput {
	s.CampaignId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteCampaignResponse
type DeleteCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *DeleteCampaignOutput) SetCampaignResponse(v *CampaignResponse) *DeleteCampaignOutput {
	s.CampaignResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteGcmChannelRequest
type DeleteGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteGcmChannelInput) SetApplicationId(v string) *DeleteGcmChannelInput {
	s.ApplicationId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteGcmChannelResponse
type DeleteGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *DeleteGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *DeleteGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteSegmentRequest
type DeleteSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteSegmentInput) SetApplicationId(v string) *DeleteSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *DeleteSegmentInput) SetSegmentId(v string) *DeleteSegmentInput {
	s.SegmentId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//DeleteSegmentResponse
type DeleteSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *DeleteSegmentOutput) SetSegmentResponse(v *SegmentResponse) *DeleteSegmentOutput {
	s.SegmentResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//EndpointBatchItem
type EndpointBatchItem struct {
	_ struct{} `type:"structure"`

	// The address or token of the endpoint.
	Address *string `type:"string"`

	Attributes map[string][]*string `type:"map"`

	ChannelType *string `type:"string" enum:"ChannelType"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The last time the endpoint was updated. Provided in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// The endpoint status. Can be either ACTIVE or INACTIVE. Will be set to INACTIVE
	// if a delivery fails. Will be set to ACTIVE if the address is updated.
	EndpointStatus *string `type:"string"`

	Id *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	Metrics map[string]*float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL – User receives all messages.NONE – User receives
	// no messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointBatchItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointBatchItem) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointBatchItem) SetAddress(v string) *EndpointBatchItem {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointBatchItem) SetAttributes(v map[string][]*string) *EndpointBatchItem {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointBatchItem) SetChannelType(v string) *EndpointBatchItem {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointBatchItem) SetDemographic(v *EndpointDemographic) *EndpointBatchItem {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointBatchItem) SetEffectiveDate(v string) *EndpointBatchItem {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointBatchItem) SetEndpointStatus(v string) *EndpointBatchItem {
	s.EndpointStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *EndpointBatchItem) SetId(v string) *EndpointBatchItem {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointBatchItem) SetLocation(v *EndpointLocation) *EndpointBatchItem {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointBatchItem) SetMetrics(v map[string]*float64) *EndpointBatchItem {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointBatchItem) SetOptOut(v string) *EndpointBatchItem {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointBatchItem) SetRequestId(v string) *EndpointBatchItem {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointBatchItem) SetUser(v *EndpointUser) *EndpointBatchItem {
	s.User = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//EndpointBatchRequest
type EndpointBatchRequest struct {
	_ struct{} `type:"structure"`

	// List of items to update. Maximum 100 items
	Item []*EndpointBatchItem `type:"list"`
}

// String returns the string representation
func (s EndpointBatchRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointBatchRequest) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *EndpointBatchRequest) SetItem(v []*EndpointBatchItem) *EndpointBatchRequest {
	s.Item = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//EndpointDemographic
type EndpointDemographic struct {
	_ struct{} `type:"structure"`

	// The version of the application associated with the endpoint.
	AppVersion *string `type:"string"`

	// The endpoint locale in the following format: The ISO 639-1 alpha-2 code,
	// followed by an underscore, followed by an ISO 3166-1 alpha-2 value.
	Locale *string `type:"string"`

	// The endpoint make, such as such as Apple or Samsung.
	Make *string `type:"string"`

	// The endpoint model, such as iPhone.
	Model *string `type:"string"`

	// The endpoint model version.
	ModelVersion *string `type:"string"`

	// The endpoint platform, such as ios or android.
	Platform *string `type:"string"`

	// The endpoint platform version.
	PlatformVersion *string `type:"string"`

	// The timezone of the endpoint. Specified as a tz database value, such as Americas/Los_Angeles.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s EndpointDemographic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointDemographic) GoString() string {
	return s.String()
}

// SetAppVersion sets the AppVersion field's value.
func (s *EndpointDemographic) SetAppVersion(v string) *EndpointDemographic {
	s.AppVersion = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *EndpointDemographic) SetLocale(v string) *EndpointDemographic {
	s.Locale = &v
	return s
}

// SetMake sets the Make field's value.
func (s *EndpointDemographic) SetMake(v string) *EndpointDemographic {
	s.Make = &v
	return s
}

// SetModel sets the Model field's value.
func (s *EndpointDemographic) SetModel(v string) *EndpointDemographic {
	s.Model = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *EndpointDemographic) SetModelVersion(v string) *EndpointDemographic {
	s.ModelVersion = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EndpointDemographic) SetPlatform(v string) *EndpointDemographic {
	s.Platform = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EndpointDemographic) SetPlatformVersion(v string) *EndpointDemographic {
	s.PlatformVersion = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *EndpointDemographic) SetTimezone(v string) *EndpointDemographic {
	s.Timezone = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//EndpointLocation
type EndpointLocation struct {
	_ struct{} `type:"structure"`

	// The city where the endpoint is located.
	City *string `type:"string"`

	// Country according to ISO 3166-1 Alpha-2 codes. For example, US.
	Country *string `type:"string"`

	// The latitude of the endpoint location. Rounded to one decimal (Roughly corresponding
	// to a mile).
	Latitude *float64 `type:"double"`

	// The longitude of the endpoint location. Rounded to one decimal (Roughly corresponding
	// to a mile).
	Longitude *float64 `type:"double"`

	// The postal code or zip code of the endpoint.
	PostalCode *string `type:"string"`

	// The region of the endpoint location. For example, corresponds to a state
	// in US.
	Region *string `type:"string"`
}

// String returns the string representation
func (s EndpointLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointLocation) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *EndpointLocation) SetCity(v string) *EndpointLocation {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *EndpointLocation) SetCountry(v string) *EndpointLocation {
	s.Country = &v
	return s
}

// SetLatitude sets the Latitude field's value.
func (s *EndpointLocation) SetLatitude(v float64) *EndpointLocation {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *EndpointLocation) SetLongitude(v float64) *EndpointLocation {
	s.Longitude = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *EndpointLocation) SetPostalCode(v string) *EndpointLocation {
	s.PostalCode = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EndpointLocation) SetRegion(v string) *EndpointLocation {
	s.Region = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//EndpointRequest
type EndpointRequest struct {
	_ struct{} `type:"structure"`

	// The address or token of the endpoint.
	Address *string `type:"string"`

	Attributes map[string][]*string `type:"map"`

	ChannelType *string `type:"string" enum:"ChannelType"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The last time the endpoint was updated. Provided in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// The endpoint status. Can be either ACTIVE or INACTIVE. Will be set to INACTIVE
	// if a delivery fails. Will be set to ACTIVE if the address is updated.
	EndpointStatus *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	Metrics map[string]*float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL – User receives all messages.NONE – User receives
	// no messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointRequest) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointRequest) SetAddress(v string) *EndpointRequest {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointRequest) SetAttributes(v map[string][]*string) *EndpointRequest {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointRequest) SetChannelType(v string) *EndpointRequest {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointRequest) SetDemographic(v *EndpointDemographic) *EndpointRequest {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointRequest) SetEffectiveDate(v string) *EndpointRequest {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointRequest) SetEndpointStatus(v string) *EndpointRequest {
	s.EndpointStatus = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointRequest) SetLocation(v *EndpointLocation) *EndpointRequest {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointRequest) SetMetrics(v map[string]*float64) *EndpointRequest {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointRequest) SetOptOut(v string) *EndpointRequest {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointRequest) SetRequestId(v string) *EndpointRequest {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointRequest) SetUser(v *EndpointUser) *EndpointRequest {
	s.User = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//EndpointResponse
type EndpointResponse struct {
	_ struct{} `type:"structure"`

	// The address or token of the endpoint.
	Address *string `type:"string"`

	// The ID of the application associated with the endpoint.
	ApplicationId *string `type:"string"`

	Attributes map[string][]*string `type:"map"`

	ChannelType *string `type:"string" enum:"ChannelType"`

	// A number from 0 - 99 that represents the cohort the endpoint is assigned
	// to. Endpoints are grouped into cohorts randomly, and each cohort contains
	// approximately 1 percent of the endpoints for an app. Amazon Pinpoint assigns
	// cohorts to the holdout or treatment allocations for a campaign.
	CohortId *string `type:"string"`

	// The last time the endpoint was created. Provided in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The last time the endpoint was updated. Provided in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// The endpoint status. Can be either ACTIVE or INACTIVE. Will be set to INACTIVE
	// if a delivery fails. Will be set to ACTIVE if the address is updated.
	EndpointStatus *string `type:"string"`

	// The unique ID that you assigned to the endpoint. The ID should be a globally
	// unique identifier (GUID) to ensure that it is unique compared to all other
	// endpoints for the application.
	Id *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	Metrics map[string]*float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL – User receives all messages.NONE – User receives
	// no messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// The ShardId of endpoint
	ShardId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointResponse) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointResponse) SetAddress(v string) *EndpointResponse {
	s.Address = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EndpointResponse) SetApplicationId(v string) *EndpointResponse {
	s.ApplicationId = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointResponse) SetAttributes(v map[string][]*string) *EndpointResponse {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointResponse) SetChannelType(v string) *EndpointResponse {
	s.ChannelType = &v
	return s
}

// SetCohortId sets the CohortId field's value.
func (s *EndpointResponse) SetCohortId(v string) *EndpointResponse {
	s.CohortId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *EndpointResponse) SetCreationDate(v string) *EndpointResponse {
	s.CreationDate = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointResponse) SetDemographic(v *EndpointDemographic) *EndpointResponse {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointResponse) SetEffectiveDate(v string) *EndpointResponse {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointResponse) SetEndpointStatus(v string) *EndpointResponse {
	s.EndpointStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *EndpointResponse) SetId(v string) *EndpointResponse {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointResponse) SetLocation(v *EndpointLocation) *EndpointResponse {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointResponse) SetMetrics(v map[string]*float64) *EndpointResponse {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointResponse) SetOptOut(v string) *EndpointResponse {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointResponse) SetRequestId(v string) *EndpointResponse {
	s.RequestId = &v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *EndpointResponse) SetShardId(v string) *EndpointResponse {
	s.ShardId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointResponse) SetUser(v *EndpointUser) *EndpointResponse {
	s.User = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//EndpointUser
type EndpointUser struct {
	_ struct{} `type:"structure"`

	UserAttributes map[string][]*string `type:"map"`

	// The unique ID of the user.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s EndpointUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointUser) GoString() string {
	return s.String()
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *EndpointUser) SetUserAttributes(v map[string][]*string) *EndpointUser {
	s.UserAttributes = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *EndpointUser) SetUserId(v string) *EndpointUser {
	s.UserId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GCMChannelRequest
type GCMChannelRequest struct {
	_ struct{} `type:"structure"`

	// Platform credential API key from Google.
	ApiKey *string `type:"string"`
}

// String returns the string representation
func (s GCMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMChannelRequest) GoString() string {
	return s.String()
}

// SetApiKey sets the ApiKey field's value.
func (s *GCMChannelRequest) SetApiKey(v string) *GCMChannelRequest {
	s.ApiKey = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GCMChannelResponse
type GCMChannelResponse struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The GCM API key from Google.
	Credential *string `type:"string"`

	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be GCM
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s GCMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GCMChannelResponse) SetApplicationId(v string) *GCMChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GCMChannelResponse) SetCreationDate(v string) *GCMChannelResponse {
	s.CreationDate = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *GCMChannelResponse) SetCredential(v string) *GCMChannelResponse {
	s.Credential = &v
	return s
}

// SetId sets the Id field's value.
func (s *GCMChannelResponse) SetId(v string) *GCMChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *GCMChannelResponse) SetIsArchived(v bool) *GCMChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *GCMChannelResponse) SetLastModifiedBy(v string) *GCMChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *GCMChannelResponse) SetLastModifiedDate(v string) *GCMChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *GCMChannelResponse) SetPlatform(v string) *GCMChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GCMChannelResponse) SetVersion(v int64) *GCMChannelResponse {
	s.Version = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetApnsChannelRequest
type GetApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsChannelInput) SetApplicationId(v string) *GetApnsChannelInput {
	s.ApplicationId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetApnsChannelResponse
type GetApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *GetApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *GetApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetApplicationSettingsRequest
type GetApplicationSettingsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApplicationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationSettingsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationSettingsInput) SetApplicationId(v string) *GetApplicationSettingsInput {
	s.ApplicationId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetApplicationSettingsResponse
type GetApplicationSettingsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationSettingsResource"`

	// ApplicationSettingsResource is a required field
	ApplicationSettingsResource *ApplicationSettingsResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationSettingsOutput) GoString() string {
	return s.String()
}

// SetApplicationSettingsResource sets the ApplicationSettingsResource field's value.
func (s *GetApplicationSettingsOutput) SetApplicationSettingsResource(v *ApplicationSettingsResource) *GetApplicationSettingsOutput {
	s.ApplicationSettingsResource = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignActivitiesRequest
type GetCampaignActivitiesInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignActivitiesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignActivitiesInput) SetApplicationId(v string) *GetCampaignActivitiesInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignActivitiesInput) SetCampaignId(v string) *GetCampaignActivitiesInput {
	s.CampaignId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignActivitiesInput) SetPageSize(v string) *GetCampaignActivitiesInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignActivitiesInput) SetToken(v string) *GetCampaignActivitiesInput {
	s.Token = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignActivitiesResponse
type GetCampaignActivitiesOutput struct {
	_ struct{} `type:"structure" payload:"ActivitiesResponse"`

	// ActivitiesResponse is a required field
	ActivitiesResponse *ActivitiesResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignActivitiesOutput) GoString() string {
	return s.String()
}

// SetActivitiesResponse sets the ActivitiesResponse field's value.
func (s *GetCampaignActivitiesOutput) SetActivitiesResponse(v *ActivitiesResponse) *GetCampaignActivitiesOutput {
	s.ActivitiesResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignRequest
type GetCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignInput) SetApplicationId(v string) *GetCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignInput) SetCampaignId(v string) *GetCampaignInput {
	s.CampaignId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignResponse
type GetCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *GetCampaignOutput) SetCampaignResponse(v *CampaignResponse) *GetCampaignOutput {
	s.CampaignResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignVersionRequest
type GetCampaignVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignVersionInput) SetApplicationId(v string) *GetCampaignVersionInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignVersionInput) SetCampaignId(v string) *GetCampaignVersionInput {
	s.CampaignId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetCampaignVersionInput) SetVersion(v string) *GetCampaignVersionInput {
	s.Version = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignVersionResponse
type GetCampaignVersionOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *GetCampaignVersionOutput) SetCampaignResponse(v *CampaignResponse) *GetCampaignVersionOutput {
	s.CampaignResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignVersionsRequest
type GetCampaignVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignVersionsInput) SetApplicationId(v string) *GetCampaignVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignVersionsInput) SetCampaignId(v string) *GetCampaignVersionsInput {
	s.CampaignId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignVersionsInput) SetPageSize(v string) *GetCampaignVersionsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignVersionsInput) SetToken(v string) *GetCampaignVersionsInput {
	s.Token = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignVersionsResponse
type GetCampaignVersionsOutput struct {
	_ struct{} `type:"structure" payload:"CampaignsResponse"`

	// CampaignsResponse is a required field
	CampaignsResponse *CampaignsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionsOutput) GoString() string {
	return s.String()
}

// SetCampaignsResponse sets the CampaignsResponse field's value.
func (s *GetCampaignVersionsOutput) SetCampaignsResponse(v *CampaignsResponse) *GetCampaignVersionsOutput {
	s.CampaignsResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignsRequest
type GetCampaignsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignsInput) SetApplicationId(v string) *GetCampaignsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignsInput) SetPageSize(v string) *GetCampaignsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignsInput) SetToken(v string) *GetCampaignsInput {
	s.Token = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetCampaignsResponse
type GetCampaignsOutput struct {
	_ struct{} `type:"structure" payload:"CampaignsResponse"`

	// CampaignsResponse is a required field
	CampaignsResponse *CampaignsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignsOutput) GoString() string {
	return s.String()
}

// SetCampaignsResponse sets the CampaignsResponse field's value.
func (s *GetCampaignsOutput) SetCampaignsResponse(v *CampaignsResponse) *GetCampaignsOutput {
	s.CampaignsResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetEndpointRequest
type GetEndpointInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEndpointInput) SetApplicationId(v string) *GetEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *GetEndpointInput) SetEndpointId(v string) *GetEndpointInput {
	s.EndpointId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetEndpointResponse
type GetEndpointOutput struct {
	_ struct{} `type:"structure" payload:"EndpointResponse"`

	// EndpointResponse is a required field
	EndpointResponse *EndpointResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointResponse sets the EndpointResponse field's value.
func (s *GetEndpointOutput) SetEndpointResponse(v *EndpointResponse) *GetEndpointOutput {
	s.EndpointResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetGcmChannelRequest
type GetGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetGcmChannelInput) SetApplicationId(v string) *GetGcmChannelInput {
	s.ApplicationId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetGcmChannelResponse
type GetGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *GetGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *GetGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetImportJobRequest
type GetImportJobInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"job-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetImportJobInput) SetApplicationId(v string) *GetImportJobInput {
	s.ApplicationId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetImportJobInput) SetJobId(v string) *GetImportJobInput {
	s.JobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetImportJobResponse
type GetImportJobOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobResponse"`

	// ImportJobResponse is a required field
	ImportJobResponse *ImportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobResponse sets the ImportJobResponse field's value.
func (s *GetImportJobOutput) SetImportJobResponse(v *ImportJobResponse) *GetImportJobOutput {
	s.ImportJobResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetImportJobsRequest
type GetImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetImportJobsInput) SetApplicationId(v string) *GetImportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetImportJobsInput) SetPageSize(v string) *GetImportJobsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetImportJobsInput) SetToken(v string) *GetImportJobsInput {
	s.Token = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetImportJobsResponse
type GetImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobsResponse sets the ImportJobsResponse field's value.
func (s *GetImportJobsOutput) SetImportJobsResponse(v *ImportJobsResponse) *GetImportJobsOutput {
	s.ImportJobsResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentImportJobsRequest
type GetSegmentImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentImportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentImportJobsInput) SetApplicationId(v string) *GetSegmentImportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentImportJobsInput) SetPageSize(v string) *GetSegmentImportJobsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentImportJobsInput) SetSegmentId(v string) *GetSegmentImportJobsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentImportJobsInput) SetToken(v string) *GetSegmentImportJobsInput {
	s.Token = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentImportJobsResponse
type GetSegmentImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobsResponse sets the ImportJobsResponse field's value.
func (s *GetSegmentImportJobsOutput) SetImportJobsResponse(v *ImportJobsResponse) *GetSegmentImportJobsOutput {
	s.ImportJobsResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentRequest
type GetSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentInput) SetApplicationId(v string) *GetSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentInput) SetSegmentId(v string) *GetSegmentInput {
	s.SegmentId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentResponse
type GetSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *GetSegmentOutput) SetSegmentResponse(v *SegmentResponse) *GetSegmentOutput {
	s.SegmentResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentVersionRequest
type GetSegmentVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentVersionInput) SetApplicationId(v string) *GetSegmentVersionInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentVersionInput) SetSegmentId(v string) *GetSegmentVersionInput {
	s.SegmentId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSegmentVersionInput) SetVersion(v string) *GetSegmentVersionInput {
	s.Version = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentVersionResponse
type GetSegmentVersionOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *GetSegmentVersionOutput) SetSegmentResponse(v *SegmentResponse) *GetSegmentVersionOutput {
	s.SegmentResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentVersionsRequest
type GetSegmentVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentVersionsInput) SetApplicationId(v string) *GetSegmentVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentVersionsInput) SetPageSize(v string) *GetSegmentVersionsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentVersionsInput) SetSegmentId(v string) *GetSegmentVersionsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentVersionsInput) SetToken(v string) *GetSegmentVersionsInput {
	s.Token = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentVersionsResponse
type GetSegmentVersionsOutput struct {
	_ struct{} `type:"structure" payload:"SegmentsResponse"`

	// SegmentsResponse is a required field
	SegmentsResponse *SegmentsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionsOutput) GoString() string {
	return s.String()
}

// SetSegmentsResponse sets the SegmentsResponse field's value.
func (s *GetSegmentVersionsOutput) SetSegmentsResponse(v *SegmentsResponse) *GetSegmentVersionsOutput {
	s.SegmentsResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentsRequest
type GetSegmentsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentsInput) SetApplicationId(v string) *GetSegmentsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentsInput) SetPageSize(v string) *GetSegmentsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentsInput) SetToken(v string) *GetSegmentsInput {
	s.Token = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//GetSegmentsResponse
type GetSegmentsOutput struct {
	_ struct{} `type:"structure" payload:"SegmentsResponse"`

	// SegmentsResponse is a required field
	SegmentsResponse *SegmentsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentsOutput) GoString() string {
	return s.String()
}

// SetSegmentsResponse sets the SegmentsResponse field's value.
func (s *GetSegmentsOutput) SetSegmentsResponse(v *SegmentsResponse) *GetSegmentsOutput {
	s.SegmentsResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//ImportJobRequest
type ImportJobRequest struct {
	_ struct{} `type:"structure"`

	// Sets whether the endpoints create a segment when they are imported.
	DefineSegment *bool `type:"boolean"`

	// A unique, custom ID assigned to the IAM role that restricts who can assume
	// the role.
	ExternalId *string `type:"string"`

	Format *string `type:"string" enum:"Format"`

	// Sets whether the endpoints are registered with Amazon Pinpoint when they
	// are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that contains the endpoints to import.
	RoleArn *string `type:"string"`

	// A URL that points to the location within an Amazon S3 bucket that contains
	// the endpoints to import. The location can be a folder or a single file.The
	// URL should follow this format: s3://bucket-name/folder-name/file-nameAmazon
	// Pinpoint will import endpoints from this location and any subfolders it contains.
	S3Url *string `type:"string"`

	// The ID of the segment to update if the import job is meant to update an existing
	// segment.
	SegmentId *string `type:"string"`

	// A custom name for the segment created by the import job. Use if DefineSegment
	// is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobRequest) GoString() string {
	return s.String()
}

// SetDefineSegment sets the DefineSegment field's value.
func (s *ImportJobRequest) SetDefineSegment(v bool) *ImportJobRequest {
	s.DefineSegment = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ImportJobRequest) SetExternalId(v string) *ImportJobRequest {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportJobRequest) SetFormat(v string) *ImportJobRequest {
	s.Format = &v
	return s
}

// SetRegisterEndpoints sets the RegisterEndpoints field's value.
func (s *ImportJobRequest) SetRegisterEndpoints(v bool) *ImportJobRequest {
	s.RegisterEndpoints = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportJobRequest) SetRoleArn(v string) *ImportJobRequest {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportJobRequest) SetS3Url(v string) *ImportJobRequest {
	s.S3Url = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ImportJobRequest) SetSegmentId(v string) *ImportJobRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *ImportJobRequest) SetSegmentName(v string) *ImportJobRequest {
	s.SegmentName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//ImportJobResource
type ImportJobResource struct {
	_ struct{} `type:"structure"`

	// Sets whether the endpoints create a segment when they are imported.
	DefineSegment *bool `type:"boolean"`

	// A unique, custom ID assigned to the IAM role that restricts who can assume
	// the role.
	ExternalId *string `type:"string"`

	Format *string `type:"string" enum:"Format"`

	// Sets whether the endpoints are registered with Amazon Pinpoint when they
	// are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that contains the endpoints to import.
	RoleArn *string `type:"string"`

	// A URL that points to the location within an Amazon S3 bucket that contains
	// the endpoints to import. The location can be a folder or a single file.The
	// URL should follow this format: s3://bucket-name/folder-name/file-nameAmazon
	// Pinpoint will import endpoints from this location and any subfolders it contains.
	S3Url *string `type:"string"`

	// The ID of the segment to update if the import job is meant to update an existing
	// segment.
	SegmentId *string `type:"string"`

	// A custom name for the segment created by the import job. Use if DefineSegment
	// is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobResource) GoString() string {
	return s.String()
}

// SetDefineSegment sets the DefineSegment field's value.
func (s *ImportJobResource) SetDefineSegment(v bool) *ImportJobResource {
	s.DefineSegment = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ImportJobResource) SetExternalId(v string) *ImportJobResource {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportJobResource) SetFormat(v string) *ImportJobResource {
	s.Format = &v
	return s
}

// SetRegisterEndpoints sets the RegisterEndpoints field's value.
func (s *ImportJobResource) SetRegisterEndpoints(v bool) *ImportJobResource {
	s.RegisterEndpoints = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportJobResource) SetRoleArn(v string) *ImportJobResource {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportJobResource) SetS3Url(v string) *ImportJobResource {
	s.S3Url = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ImportJobResource) SetSegmentId(v string) *ImportJobResource {
	s.SegmentId = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *ImportJobResource) SetSegmentName(v string) *ImportJobResource {
	s.SegmentName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//ImportJobResponse
type ImportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application to which the import job applies.
	ApplicationId *string `type:"string"`

	// The number of pieces that have successfully imported as of the time of the
	// request.
	CompletedPieces *int64 `type:"integer"`

	// The date the import job completed in ISO 8601 format.
	CompletionDate *string `type:"string"`

	// The date the import job was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The import job settings.
	Definition *ImportJobResource `type:"structure"`

	// The number of pieces that have failed to import as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	Failures []*string `type:"list"`

	// The unique ID of the import job.
	Id *string `type:"string"`

	JobStatus *string `type:"string" enum:"JobStatus"`

	// The number of endpoints that failed to import; for example, because of syntax
	// errors.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be imported to finish the job. Each
	// piece is an approximately equal portion of the endpoints to import.
	TotalPieces *int64 `type:"integer"`

	// The number of endpoints that were processed by the import job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. Will be Import.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ImportJobResponse) SetApplicationId(v string) *ImportJobResponse {
	s.ApplicationId = &v
	return s
}

// SetCompletedPieces sets the CompletedPieces field's value.
func (s *ImportJobResponse) SetCompletedPieces(v int64) *ImportJobResponse {
	s.CompletedPieces = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *ImportJobResponse) SetCompletionDate(v string) *ImportJobResponse {
	s.CompletionDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ImportJobResponse) SetCreationDate(v string) *ImportJobResponse {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *ImportJobResponse) SetDefinition(v *ImportJobResource) *ImportJobResponse {
	s.Definition = v
	return s
}

// SetFailedPieces sets the FailedPieces field's value.
func (s *ImportJobResponse) SetFailedPieces(v int64) *ImportJobResponse {
	s.FailedPieces = &v
	return s
}

// SetFailures sets the Failures field's value.
func (s *ImportJobResponse) SetFailures(v []*string) *ImportJobResponse {
	s.Failures = v
	return s
}

// SetId sets the Id field's value.
func (s *ImportJobResponse) SetId(v string) *ImportJobResponse {
	s.Id = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ImportJobResponse) SetJobStatus(v string) *ImportJobResponse {
	s.JobStatus = &v
	return s
}

// SetTotalFailures sets the TotalFailures field's value.
func (s *ImportJobResponse) SetTotalFailures(v int64) *ImportJobResponse {
	s.TotalFailures = &v
	return s
}

// SetTotalPieces sets the TotalPieces field's value.
func (s *ImportJobResponse) SetTotalPieces(v int64) *ImportJobResponse {
	s.TotalPieces = &v
	return s
}

// SetTotalProcessed sets the TotalProcessed field's value.
func (s *ImportJobResponse) SetTotalProcessed(v int64) *ImportJobResponse {
	s.TotalProcessed = &v
	return s
}

// SetType sets the Type field's value.
func (s *ImportJobResponse) SetType(v string) *ImportJobResponse {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//ImportJobsResponse
type ImportJobsResponse struct {
	_ struct{} `type:"structure"`

	// A list of import jobs for the application.
	Item []*ImportJobResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ImportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ImportJobsResponse) SetItem(v []*ImportJobResponse) *ImportJobsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ImportJobsResponse) SetNextToken(v string) *ImportJobsResponse {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//Message
type Message struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string" enum:"Action"`

	// The message body. Can include up to 140 characters.
	Body *string `type:"string"`

	// The URL that points to the icon image for the push notification icon, for
	// example, the app icon.
	ImageIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// The JSON payload used for a silent push.
	JsonBody *string `type:"string"`

	// The URL that points to the media resource, for example a .mp4 or .gif file.
	MediaUrl *string `type:"string"`

	// Indicates if the message should display on the users device.Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Message) SetAction(v string) *Message {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v string) *Message {
	s.Body = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *Message) SetImageIconUrl(v string) *Message {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *Message) SetImageUrl(v string) *Message {
	s.ImageUrl = &v
	return s
}

// SetJsonBody sets the JsonBody field's value.
func (s *Message) SetJsonBody(v string) *Message {
	s.JsonBody = &v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *Message) SetMediaUrl(v string) *Message {
	s.MediaUrl = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *Message) SetSilentPush(v bool) *Message {
	s.SilentPush = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Message) SetTitle(v string) *Message {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Message) SetUrl(v string) *Message {
	s.Url = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//MessageBody
type MessageBody struct {
	_ struct{} `type:"structure"`

	Message *string `type:"string"`

	RequestID *string `type:"string"`
}

// String returns the string representation
func (s MessageBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageBody) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *MessageBody) SetMessage(v string) *MessageBody {
	s.Message = &v
	return s
}

// SetRequestID sets the RequestID field's value.
func (s *MessageBody) SetRequestID(v string) *MessageBody {
	s.RequestID = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//MessageConfiguration
type MessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The message that the campaign delivers to APNS channels. Overrides the default
	// message.
	APNSMessage *Message `type:"structure"`

	// The default message for all channels.
	DefaultMessage *Message `type:"structure"`

	// The message that the campaign delivers to GCM channels. Overrides the default
	// message.
	GCMMessage *Message `type:"structure"`
}

// String returns the string representation
func (s MessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageConfiguration) GoString() string {
	return s.String()
}

// SetAPNSMessage sets the APNSMessage field's value.
func (s *MessageConfiguration) SetAPNSMessage(v *Message) *MessageConfiguration {
	s.APNSMessage = v
	return s
}

// SetDefaultMessage sets the DefaultMessage field's value.
func (s *MessageConfiguration) SetDefaultMessage(v *Message) *MessageConfiguration {
	s.DefaultMessage = v
	return s
}

// SetGCMMessage sets the GCMMessage field's value.
func (s *MessageConfiguration) SetGCMMessage(v *Message) *MessageConfiguration {
	s.GCMMessage = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//QuietTime
type QuietTime struct {
	_ struct{} `type:"structure"`

	// The default end time for quiet time in ISO 8601 format.
	End *string `type:"string"`

	// The default start time for quiet time in ISO 8601 format.
	Start *string `type:"string"`
}

// String returns the string representation
func (s QuietTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QuietTime) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *QuietTime) SetEnd(v string) *QuietTime {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *QuietTime) SetStart(v string) *QuietTime {
	s.Start = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//RecencyDimension
type RecencyDimension struct {
	_ struct{} `type:"structure"`

	Duration *string `type:"string" enum:"Duration"`

	RecencyType *string `type:"string" enum:"RecencyType"`
}

// String returns the string representation
func (s RecencyDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecencyDimension) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *RecencyDimension) SetDuration(v string) *RecencyDimension {
	s.Duration = &v
	return s
}

// SetRecencyType sets the RecencyType field's value.
func (s *RecencyDimension) SetRecencyType(v string) *RecencyDimension {
	s.RecencyType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//Schedule
type Schedule struct {
	_ struct{} `type:"structure"`

	// The scheduled time that the campaign ends in ISO 8601 format.
	EndTime *string `type:"string"`

	Frequency *string `type:"string" enum:"Frequency"`

	// Indicates whether the campaign schedule takes effect according to each user's
	// local time.
	IsLocalTime *bool `type:"boolean"`

	// The time during which the campaign sends no messages.
	QuietTime *QuietTime `type:"structure"`

	// The scheduled time that the campaign begins in ISO 8601 format.
	StartTime *string `type:"string"`

	// The starting UTC offset for the schedule if the value for isLocalTime is
	// trueValid values: UTCUTC+01UTC+02UTC+03UTC+03:30UTC+04UTC+04:30UTC+05UTC+05:30UTC+05:45UTC+06UTC+06:30UTC+07UTC+08UTC+09UTC+09:30UTC+10UTC+10:30UTC+11UTC+12UTC+13UTC-02UTC-03UTC-04UTC-05UTC-06UTC-07UTC-08UTC-09UTC-10UTC-11
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Schedule) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *Schedule) SetEndTime(v string) *Schedule {
	s.EndTime = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *Schedule) SetFrequency(v string) *Schedule {
	s.Frequency = &v
	return s
}

// SetIsLocalTime sets the IsLocalTime field's value.
func (s *Schedule) SetIsLocalTime(v bool) *Schedule {
	s.IsLocalTime = &v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *Schedule) SetQuietTime(v *QuietTime) *Schedule {
	s.QuietTime = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Schedule) SetStartTime(v string) *Schedule {
	s.StartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *Schedule) SetTimezone(v string) *Schedule {
	s.Timezone = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//SegmentBehaviors
type SegmentBehaviors struct {
	_ struct{} `type:"structure"`

	// The recency of use.
	Recency *RecencyDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentBehaviors) GoString() string {
	return s.String()
}

// SetRecency sets the Recency field's value.
func (s *SegmentBehaviors) SetRecency(v *RecencyDimension) *SegmentBehaviors {
	s.Recency = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//SegmentDemographics
type SegmentDemographics struct {
	_ struct{} `type:"structure"`

	// The app version criteria for the segment.
	AppVersion *SetDimension `type:"structure"`

	// The device type criteria for the segment.
	DeviceType *SetDimension `type:"structure"`

	// The device make criteria for the segment.
	Make *SetDimension `type:"structure"`

	// The device model criteria for the segment.
	Model *SetDimension `type:"structure"`

	// The device platform criteria for the segment.
	Platform *SetDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentDemographics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentDemographics) GoString() string {
	return s.String()
}

// SetAppVersion sets the AppVersion field's value.
func (s *SegmentDemographics) SetAppVersion(v *SetDimension) *SegmentDemographics {
	s.AppVersion = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *SegmentDemographics) SetDeviceType(v *SetDimension) *SegmentDemographics {
	s.DeviceType = v
	return s
}

// SetMake sets the Make field's value.
func (s *SegmentDemographics) SetMake(v *SetDimension) *SegmentDemographics {
	s.Make = v
	return s
}

// SetModel sets the Model field's value.
func (s *SegmentDemographics) SetModel(v *SetDimension) *SegmentDemographics {
	s.Model = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *SegmentDemographics) SetPlatform(v *SetDimension) *SegmentDemographics {
	s.Platform = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//SegmentDimensions
type SegmentDimensions struct {
	_ struct{} `type:"structure"`

	// Custom segment attributes.
	Attributes map[string]*AttributeDimension `type:"map"`

	// The segment behaviors attributes.
	Behavior *SegmentBehaviors `type:"structure"`

	// The segment demographics attributes.
	Demographic *SegmentDemographics `type:"structure"`

	// The segment location attributes.
	Location *SegmentLocation `type:"structure"`
}

// String returns the string representation
func (s SegmentDimensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentDimensions) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *SegmentDimensions) SetAttributes(v map[string]*AttributeDimension) *SegmentDimensions {
	s.Attributes = v
	return s
}

// SetBehavior sets the Behavior field's value.
func (s *SegmentDimensions) SetBehavior(v *SegmentBehaviors) *SegmentDimensions {
	s.Behavior = v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *SegmentDimensions) SetDemographic(v *SegmentDemographics) *SegmentDimensions {
	s.Demographic = v
	return s
}

// SetLocation sets the Location field's value.
func (s *SegmentDimensions) SetLocation(v *SegmentLocation) *SegmentDimensions {
	s.Location = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//SegmentImportResource
type SegmentImportResource struct {
	_ struct{} `type:"structure"`

	// A unique, custom ID assigned to the IAM role that restricts who can assume
	// the role.
	ExternalId *string `type:"string"`

	Format *string `type:"string" enum:"Format"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the endpoints in Amazon S3.
	RoleArn *string `type:"string"`

	// A URL that points to the Amazon S3 location from which the endpoints for
	// this segment were imported.
	S3Url *string `type:"string"`

	// The number of endpoints that were successfully imported to create this segment.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentImportResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentImportResource) GoString() string {
	return s.String()
}

// SetExternalId sets the ExternalId field's value.
func (s *SegmentImportResource) SetExternalId(v string) *SegmentImportResource {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *SegmentImportResource) SetFormat(v string) *SegmentImportResource {
	s.Format = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SegmentImportResource) SetRoleArn(v string) *SegmentImportResource {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *SegmentImportResource) SetS3Url(v string) *SegmentImportResource {
	s.S3Url = &v
	return s
}

// SetSize sets the Size field's value.
func (s *SegmentImportResource) SetSize(v int64) *SegmentImportResource {
	s.Size = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//SegmentLocation
type SegmentLocation struct {
	_ struct{} `type:"structure"`

	// The country filter according to ISO 3166-1 Alpha-2 codes.
	Country *SetDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentLocation) GoString() string {
	return s.String()
}

// SetCountry sets the Country field's value.
func (s *SegmentLocation) SetCountry(v *SetDimension) *SegmentLocation {
	s.Country = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//SegmentResponse
type SegmentResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the segment applies.
	ApplicationId *string `type:"string"`

	// The date the segment was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The segment dimensions attributes.
	Dimensions *SegmentDimensions `type:"structure"`

	// The unique segment ID.
	Id *string `type:"string"`

	// The import job settings.
	ImportDefinition *SegmentImportResource `type:"structure"`

	// The date the segment was last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The name of segment
	Name *string `type:"string"`

	SegmentType *string `type:"string" enum:"SegmentType"`

	// The segment version number.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SegmentResponse) SetApplicationId(v string) *SegmentResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *SegmentResponse) SetCreationDate(v string) *SegmentResponse {
	s.CreationDate = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *SegmentResponse) SetDimensions(v *SegmentDimensions) *SegmentResponse {
	s.Dimensions = v
	return s
}

// SetId sets the Id field's value.
func (s *SegmentResponse) SetId(v string) *SegmentResponse {
	s.Id = &v
	return s
}

// SetImportDefinition sets the ImportDefinition field's value.
func (s *SegmentResponse) SetImportDefinition(v *SegmentImportResource) *SegmentResponse {
	s.ImportDefinition = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SegmentResponse) SetLastModifiedDate(v string) *SegmentResponse {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SegmentResponse) SetName(v string) *SegmentResponse {
	s.Name = &v
	return s
}

// SetSegmentType sets the SegmentType field's value.
func (s *SegmentResponse) SetSegmentType(v string) *SegmentResponse {
	s.SegmentType = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SegmentResponse) SetVersion(v int64) *SegmentResponse {
	s.Version = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//SegmentsResponse
type SegmentsResponse struct {
	_ struct{} `type:"structure"`

	// The list of segments.
	Item []*SegmentResponse `type:"list"`

	// An identifier used to retrieve the next page of results. The token is null
	// if no additional pages exist.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SegmentsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *SegmentsResponse) SetItem(v []*SegmentResponse) *SegmentsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SegmentsResponse) SetNextToken(v string) *SegmentsResponse {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//SetDimension
type SetDimension struct {
	_ struct{} `type:"structure"`

	DimensionType *string `type:"string" enum:"DimensionType"`

	Values []*string `type:"list"`
}

// String returns the string representation
func (s SetDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDimension) GoString() string {
	return s.String()
}

// SetDimensionType sets the DimensionType field's value.
func (s *SetDimension) SetDimensionType(v string) *SetDimension {
	s.DimensionType = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SetDimension) SetValues(v []*string) *SetDimension {
	s.Values = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//TreatmentResource
type TreatmentResource struct {
	_ struct{} `type:"structure"`

	// The unique treatment ID.
	Id *string `type:"string"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users for this treatment.
	SizePercent *int64 `type:"integer"`

	// The treatment status.
	State *CampaignState `type:"structure"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s TreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TreatmentResource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *TreatmentResource) SetId(v string) *TreatmentResource {
	s.Id = &v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *TreatmentResource) SetMessageConfiguration(v *MessageConfiguration) *TreatmentResource {
	s.MessageConfiguration = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *TreatmentResource) SetSchedule(v *Schedule) *TreatmentResource {
	s.Schedule = v
	return s
}

// SetSizePercent sets the SizePercent field's value.
func (s *TreatmentResource) SetSizePercent(v int64) *TreatmentResource {
	s.SizePercent = &v
	return s
}

// SetState sets the State field's value.
func (s *TreatmentResource) SetState(v *CampaignState) *TreatmentResource {
	s.State = v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *TreatmentResource) SetTreatmentDescription(v string) *TreatmentResource {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *TreatmentResource) SetTreatmentName(v string) *TreatmentResource {
	s.TreatmentName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateApnsChannelRequest
type UpdateApnsChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSChannelRequest"`

	// APNSChannelRequest is a required field
	APNSChannelRequest *APNSChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsChannelInput"}
	if s.APNSChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSChannelRequest sets the APNSChannelRequest field's value.
func (s *UpdateApnsChannelInput) SetAPNSChannelRequest(v *APNSChannelRequest) *UpdateApnsChannelInput {
	s.APNSChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsChannelInput) SetApplicationId(v string) *UpdateApnsChannelInput {
	s.ApplicationId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateApnsChannelResponse
type UpdateApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *UpdateApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *UpdateApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateApplicationSettingsRequest
type UpdateApplicationSettingsInput struct {
	_ struct{} `type:"structure" payload:"WriteApplicationSettingsRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// WriteApplicationSettingsRequest is a required field
	WriteApplicationSettingsRequest *WriteApplicationSettingsRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationSettingsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WriteApplicationSettingsRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteApplicationSettingsRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationSettingsInput) SetApplicationId(v string) *UpdateApplicationSettingsInput {
	s.ApplicationId = &v
	return s
}

// SetWriteApplicationSettingsRequest sets the WriteApplicationSettingsRequest field's value.
func (s *UpdateApplicationSettingsInput) SetWriteApplicationSettingsRequest(v *WriteApplicationSettingsRequest) *UpdateApplicationSettingsInput {
	s.WriteApplicationSettingsRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateApplicationSettingsResponse
type UpdateApplicationSettingsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationSettingsResource"`

	// ApplicationSettingsResource is a required field
	ApplicationSettingsResource *ApplicationSettingsResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationSettingsOutput) GoString() string {
	return s.String()
}

// SetApplicationSettingsResource sets the ApplicationSettingsResource field's value.
func (s *UpdateApplicationSettingsOutput) SetApplicationSettingsResource(v *ApplicationSettingsResource) *UpdateApplicationSettingsOutput {
	s.ApplicationSettingsResource = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateCampaignRequest
type UpdateCampaignInput struct {
	_ struct{} `type:"structure" payload:"WriteCampaignRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	// WriteCampaignRequest is a required field
	WriteCampaignRequest *WriteCampaignRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.WriteCampaignRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCampaignRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateCampaignInput) SetApplicationId(v string) *UpdateCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *UpdateCampaignInput) SetCampaignId(v string) *UpdateCampaignInput {
	s.CampaignId = &v
	return s
}

// SetWriteCampaignRequest sets the WriteCampaignRequest field's value.
func (s *UpdateCampaignInput) SetWriteCampaignRequest(v *WriteCampaignRequest) *UpdateCampaignInput {
	s.WriteCampaignRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateCampaignResponse
type UpdateCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *UpdateCampaignOutput) SetCampaignResponse(v *CampaignResponse) *UpdateCampaignOutput {
	s.CampaignResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateEndpointRequest
type UpdateEndpointInput struct {
	_ struct{} `type:"structure" payload:"EndpointRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`

	// EndpointRequest is a required field
	EndpointRequest *EndpointRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEndpointInput) SetApplicationId(v string) *UpdateEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *UpdateEndpointInput) SetEndpointId(v string) *UpdateEndpointInput {
	s.EndpointId = &v
	return s
}

// SetEndpointRequest sets the EndpointRequest field's value.
func (s *UpdateEndpointInput) SetEndpointRequest(v *EndpointRequest) *UpdateEndpointInput {
	s.EndpointRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateEndpointResponse
type UpdateEndpointOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *UpdateEndpointOutput) SetMessageBody(v *MessageBody) *UpdateEndpointOutput {
	s.MessageBody = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateEndpointsBatchRequest
type UpdateEndpointsBatchInput struct {
	_ struct{} `type:"structure" payload:"EndpointBatchRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointBatchRequest is a required field
	EndpointBatchRequest *EndpointBatchRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointsBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointsBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointsBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointsBatchInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.EndpointBatchRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointBatchRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEndpointsBatchInput) SetApplicationId(v string) *UpdateEndpointsBatchInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointBatchRequest sets the EndpointBatchRequest field's value.
func (s *UpdateEndpointsBatchInput) SetEndpointBatchRequest(v *EndpointBatchRequest) *UpdateEndpointsBatchInput {
	s.EndpointBatchRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateEndpointsBatchResponse
type UpdateEndpointsBatchOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointsBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointsBatchOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *UpdateEndpointsBatchOutput) SetMessageBody(v *MessageBody) *UpdateEndpointsBatchOutput {
	s.MessageBody = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateGcmChannelRequest
type UpdateGcmChannelInput struct {
	_ struct{} `type:"structure" payload:"GCMChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// GCMChannelRequest is a required field
	GCMChannelRequest *GCMChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.GCMChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("GCMChannelRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateGcmChannelInput) SetApplicationId(v string) *UpdateGcmChannelInput {
	s.ApplicationId = &v
	return s
}

// SetGCMChannelRequest sets the GCMChannelRequest field's value.
func (s *UpdateGcmChannelInput) SetGCMChannelRequest(v *GCMChannelRequest) *UpdateGcmChannelInput {
	s.GCMChannelRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateGcmChannelResponse
type UpdateGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *UpdateGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *UpdateGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateSegmentRequest
type UpdateSegmentInput struct {
	_ struct{} `type:"structure" payload:"WriteSegmentRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// WriteSegmentRequest is a required field
	WriteSegmentRequest *WriteSegmentRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.WriteSegmentRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteSegmentRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateSegmentInput) SetApplicationId(v string) *UpdateSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *UpdateSegmentInput) SetSegmentId(v string) *UpdateSegmentInput {
	s.SegmentId = &v
	return s
}

// SetWriteSegmentRequest sets the WriteSegmentRequest field's value.
func (s *UpdateSegmentInput) SetWriteSegmentRequest(v *WriteSegmentRequest) *UpdateSegmentInput {
	s.WriteSegmentRequest = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//UpdateSegmentResponse
type UpdateSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *UpdateSegmentOutput) SetSegmentResponse(v *SegmentResponse) *UpdateSegmentOutput {
	s.SegmentResponse = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//WriteApplicationSettingsRequest
type WriteApplicationSettingsRequest struct {
	_ struct{} `type:"structure"`

	// The default campaign limits for the app. These limits apply to each campaign
	// for the app, unless the campaign overrides the default with limits of its
	// own.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for the app. Each campaign for this app sends no messages
	// during this time unless the campaign overrides the default with a quiet time
	// of its own.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s WriteApplicationSettingsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteApplicationSettingsRequest) GoString() string {
	return s.String()
}

// SetLimits sets the Limits field's value.
func (s *WriteApplicationSettingsRequest) SetLimits(v *CampaignLimits) *WriteApplicationSettingsRequest {
	s.Limits = v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *WriteApplicationSettingsRequest) SetQuietTime(v *QuietTime) *WriteApplicationSettingsRequest {
	s.QuietTime = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//WriteCampaignRequest
type WriteCampaignRequest struct {
	_ struct{} `type:"structure"`

	// Treatments that are defined in addition to the default treatment.
	AdditionalTreatments []*WriteTreatmentResource `type:"list"`

	// A description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of end users who will not receive messages from
	// this campaign.
	HoldoutPercent *int64 `type:"integer"`

	// Indicates whether the campaign is paused. A paused campaign does not send
	// messages unless you resume it by setting IsPaused to false.
	IsPaused *bool `type:"boolean"`

	// The campaign limits settings.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The custom name of the campaign.
	Name *string `type:"string"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The ID of the segment to which the campaign sends messages.
	SegmentId *string `type:"string"`

	// The version of the segment to which the campaign sends messages.
	SegmentVersion *int64 `type:"integer"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteCampaignRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteCampaignRequest) GoString() string {
	return s.String()
}

// SetAdditionalTreatments sets the AdditionalTreatments field's value.
func (s *WriteCampaignRequest) SetAdditionalTreatments(v []*WriteTreatmentResource) *WriteCampaignRequest {
	s.AdditionalTreatments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *WriteCampaignRequest) SetDescription(v string) *WriteCampaignRequest {
	s.Description = &v
	return s
}

// SetHoldoutPercent sets the HoldoutPercent field's value.
func (s *WriteCampaignRequest) SetHoldoutPercent(v int64) *WriteCampaignRequest {
	s.HoldoutPercent = &v
	return s
}

// SetIsPaused sets the IsPaused field's value.
func (s *WriteCampaignRequest) SetIsPaused(v bool) *WriteCampaignRequest {
	s.IsPaused = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *WriteCampaignRequest) SetLimits(v *CampaignLimits) *WriteCampaignRequest {
	s.Limits = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *WriteCampaignRequest) SetMessageConfiguration(v *MessageConfiguration) *WriteCampaignRequest {
	s.MessageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *WriteCampaignRequest) SetName(v string) *WriteCampaignRequest {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *WriteCampaignRequest) SetSchedule(v *Schedule) *WriteCampaignRequest {
	s.Schedule = v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *WriteCampaignRequest) SetSegmentId(v string) *WriteCampaignRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *WriteCampaignRequest) SetSegmentVersion(v int64) *WriteCampaignRequest {
	s.SegmentVersion = &v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *WriteCampaignRequest) SetTreatmentDescription(v string) *WriteCampaignRequest {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *WriteCampaignRequest) SetTreatmentName(v string) *WriteCampaignRequest {
	s.TreatmentName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//WriteSegmentRequest
type WriteSegmentRequest struct {
	_ struct{} `type:"structure"`

	// The segment dimensions attributes.
	Dimensions *SegmentDimensions `type:"structure"`

	// The name of segment
	Name *string `type:"string"`
}

// String returns the string representation
func (s WriteSegmentRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteSegmentRequest) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *WriteSegmentRequest) SetDimensions(v *SegmentDimensions) *WriteSegmentRequest {
	s.Dimensions = v
	return s
}

// SetName sets the Name field's value.
func (s *WriteSegmentRequest) SetName(v string) *WriteSegmentRequest {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI//WriteTreatmentResource
type WriteTreatmentResource struct {
	_ struct{} `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users for this treatment.
	SizePercent *int64 `type:"integer"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteTreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteTreatmentResource) GoString() string {
	return s.String()
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *WriteTreatmentResource) SetMessageConfiguration(v *MessageConfiguration) *WriteTreatmentResource {
	s.MessageConfiguration = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *WriteTreatmentResource) SetSchedule(v *Schedule) *WriteTreatmentResource {
	s.Schedule = v
	return s
}

// SetSizePercent sets the SizePercent field's value.
func (s *WriteTreatmentResource) SetSizePercent(v int64) *WriteTreatmentResource {
	s.SizePercent = &v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *WriteTreatmentResource) SetTreatmentDescription(v string) *WriteTreatmentResource {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *WriteTreatmentResource) SetTreatmentName(v string) *WriteTreatmentResource {
	s.TreatmentName = &v
	return s
}

const (
	// ActionOpenApp is a Action enum value
	ActionOpenApp = "OPEN_APP"

	// ActionDeepLink is a Action enum value
	ActionDeepLink = "DEEP_LINK"

	// ActionUrl is a Action enum value
	ActionUrl = "URL"
)

const (
	// AttributeTypeInclusive is a AttributeType enum value
	AttributeTypeInclusive = "INCLUSIVE"

	// AttributeTypeExclusive is a AttributeType enum value
	AttributeTypeExclusive = "EXCLUSIVE"
)

const (
	// CampaignStatusScheduled is a CampaignStatus enum value
	CampaignStatusScheduled = "SCHEDULED"

	// CampaignStatusExecuting is a CampaignStatus enum value
	CampaignStatusExecuting = "EXECUTING"

	// CampaignStatusPendingNextRun is a CampaignStatus enum value
	CampaignStatusPendingNextRun = "PENDING_NEXT_RUN"

	// CampaignStatusCompleted is a CampaignStatus enum value
	CampaignStatusCompleted = "COMPLETED"

	// CampaignStatusPaused is a CampaignStatus enum value
	CampaignStatusPaused = "PAUSED"
)

const (
	// ChannelTypeApns is a ChannelType enum value
	ChannelTypeApns = "APNS"

	// ChannelTypeGcm is a ChannelType enum value
	ChannelTypeGcm = "GCM"
)

const (
	// DimensionTypeInclusive is a DimensionType enum value
	DimensionTypeInclusive = "INCLUSIVE"

	// DimensionTypeExclusive is a DimensionType enum value
	DimensionTypeExclusive = "EXCLUSIVE"
)

const (
	// DurationHr24 is a Duration enum value
	DurationHr24 = "HR_24"

	// DurationDay7 is a Duration enum value
	DurationDay7 = "DAY_7"

	// DurationDay14 is a Duration enum value
	DurationDay14 = "DAY_14"

	// DurationDay30 is a Duration enum value
	DurationDay30 = "DAY_30"
)

const (
	// FormatCsv is a Format enum value
	FormatCsv = "CSV"

	// FormatJson is a Format enum value
	FormatJson = "JSON"
)

const (
	// FrequencyOnce is a Frequency enum value
	FrequencyOnce = "ONCE"

	// FrequencyHourly is a Frequency enum value
	FrequencyHourly = "HOURLY"

	// FrequencyDaily is a Frequency enum value
	FrequencyDaily = "DAILY"

	// FrequencyWeekly is a Frequency enum value
	FrequencyWeekly = "WEEKLY"

	// FrequencyMonthly is a Frequency enum value
	FrequencyMonthly = "MONTHLY"
)

const (
	// JobStatusCreated is a JobStatus enum value
	JobStatusCreated = "CREATED"

	// JobStatusInitializing is a JobStatus enum value
	JobStatusInitializing = "INITIALIZING"

	// JobStatusProcessing is a JobStatus enum value
	JobStatusProcessing = "PROCESSING"

	// JobStatusCompleting is a JobStatus enum value
	JobStatusCompleting = "COMPLETING"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailing is a JobStatus enum value
	JobStatusFailing = "FAILING"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)

const (
	// RecencyTypeActive is a RecencyType enum value
	RecencyTypeActive = "ACTIVE"

	// RecencyTypeInactive is a RecencyType enum value
	RecencyTypeInactive = "INACTIVE"
)

const (
	// SegmentTypeDimensional is a SegmentType enum value
	SegmentTypeDimensional = "DIMENSIONAL"

	// SegmentTypeImport is a SegmentType enum value
	SegmentTypeImport = "IMPORT"
)
