// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudwatchevents provides a client for Amazon CloudWatch Events.
package cloudwatchevents

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRuleRequest method.
//    req, resp := client.DeleteRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRule
func (c *CloudWatchEvents) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon CloudWatch Events.
//
// Deletes a rule. You must remove all targets from a rule using RemoveTargets
// before you can delete the rule.
//
// Note: When you delete a rule, incoming events might still continue to match
// to the deleted rule. Please allow a short period of time for changes to take
// effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DeleteRule for usage and error information.
//
// Returned Error Codes:
//   * ConcurrentModificationException
//   This exception occurs if there is concurrent modification on rule or target.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRule
func (c *CloudWatchEvents) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRule = "DescribeRule"

// DescribeRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRuleRequest method.
//    req, resp := client.DescribeRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRule
func (c *CloudWatchEvents) DescribeRuleRequest(input *DescribeRuleInput) (req *request.Request, output *DescribeRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuleInput{}
	}

	output = &DescribeRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRule API operation for Amazon CloudWatch Events.
//
// Describes the details of the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DescribeRule for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The rule does not exist.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRule
func (c *CloudWatchEvents) DescribeRule(input *DescribeRuleInput) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	err := req.Send()
	return out, err
}

const opDisableRule = "DisableRule"

// DisableRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisableRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableRuleRequest method.
//    req, resp := client.DisableRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule
func (c *CloudWatchEvents) DisableRuleRequest(input *DisableRuleInput) (req *request.Request, output *DisableRuleOutput) {
	op := &request.Operation{
		Name:       opDisableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableRuleInput{}
	}

	output = &DisableRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableRule API operation for Amazon CloudWatch Events.
//
// Disables a rule. A disabled rule won't match any events, and won't self-trigger
// if it has a schedule expression.
//
// Note: When you disable a rule, incoming events might still continue to match
// to the disabled rule. Please allow a short period of time for changes to
// take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DisableRule for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The rule does not exist.
//
//   * ConcurrentModificationException
//   This exception occurs if there is concurrent modification on rule or target.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule
func (c *CloudWatchEvents) DisableRule(input *DisableRuleInput) (*DisableRuleOutput, error) {
	req, out := c.DisableRuleRequest(input)
	err := req.Send()
	return out, err
}

const opEnableRule = "EnableRule"

// EnableRuleRequest generates a "aws/request.Request" representing the
// client's request for the EnableRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableRuleRequest method.
//    req, resp := client.EnableRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRule
func (c *CloudWatchEvents) EnableRuleRequest(input *EnableRuleInput) (req *request.Request, output *EnableRuleOutput) {
	op := &request.Operation{
		Name:       opEnableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableRuleInput{}
	}

	output = &EnableRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableRule API operation for Amazon CloudWatch Events.
//
// Enables a rule. If the rule does not exist, the operation fails.
//
// Note: When you enable a rule, incoming events might not immediately start
// matching to a newly enabled rule. Please allow a short period of time for
// changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation EnableRule for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The rule does not exist.
//
//   * ConcurrentModificationException
//   This exception occurs if there is concurrent modification on rule or target.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRule
func (c *CloudWatchEvents) EnableRule(input *EnableRuleInput) (*EnableRuleOutput, error) {
	req, out := c.EnableRuleRequest(input)
	err := req.Send()
	return out, err
}

const opListRuleNamesByTarget = "ListRuleNamesByTarget"

// ListRuleNamesByTargetRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleNamesByTarget operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRuleNamesByTarget for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRuleNamesByTarget method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRuleNamesByTargetRequest method.
//    req, resp := client.ListRuleNamesByTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTarget
func (c *CloudWatchEvents) ListRuleNamesByTargetRequest(input *ListRuleNamesByTargetInput) (req *request.Request, output *ListRuleNamesByTargetOutput) {
	op := &request.Operation{
		Name:       opListRuleNamesByTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRuleNamesByTargetInput{}
	}

	output = &ListRuleNamesByTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleNamesByTarget API operation for Amazon CloudWatch Events.
//
// Lists the names of the rules that the given target is put to. You can see
// which of the rules in Amazon CloudWatch Events can invoke a specific target
// in your account. If you have more rules in your account than the given limit,
// the results will be paginated. In that case, use the next token returned
// in the response and repeat ListRulesByTarget until the NextToken in the response
// is returned as null.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListRuleNamesByTarget for usage and error information.
//
// Returned Error Codes:
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTarget
func (c *CloudWatchEvents) ListRuleNamesByTarget(input *ListRuleNamesByTargetInput) (*ListRuleNamesByTargetOutput, error) {
	req, out := c.ListRuleNamesByTargetRequest(input)
	err := req.Send()
	return out, err
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRules for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRules method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRulesRequest method.
//    req, resp := client.ListRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules
func (c *CloudWatchEvents) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for Amazon CloudWatch Events.
//
// Lists the Amazon CloudWatch Events rules in your account. You can either
// list all the rules or you can provide a prefix to match to the rule names.
// If you have more rules in your account than the given limit, the results
// will be paginated. In that case, use the next token returned in the response
// and repeat ListRules until the NextToken in the response is returned as null.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListRules for usage and error information.
//
// Returned Error Codes:
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules
func (c *CloudWatchEvents) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	err := req.Send()
	return out, err
}

const opListTargetsByRule = "ListTargetsByRule"

// ListTargetsByRuleRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsByRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTargetsByRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTargetsByRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTargetsByRuleRequest method.
//    req, resp := client.ListTargetsByRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRule
func (c *CloudWatchEvents) ListTargetsByRuleRequest(input *ListTargetsByRuleInput) (req *request.Request, output *ListTargetsByRuleOutput) {
	op := &request.Operation{
		Name:       opListTargetsByRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTargetsByRuleInput{}
	}

	output = &ListTargetsByRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsByRule API operation for Amazon CloudWatch Events.
//
// Lists of targets assigned to the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListTargetsByRule for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The rule does not exist.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRule
func (c *CloudWatchEvents) ListTargetsByRule(input *ListTargetsByRuleInput) (*ListTargetsByRuleOutput, error) {
	req, out := c.ListTargetsByRuleRequest(input)
	err := req.Send()
	return out, err
}

const opPutEvents = "PutEvents"

// PutEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvents operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutEvents for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutEvents method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutEventsRequest method.
//    req, resp := client.PutEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEvents
func (c *CloudWatchEvents) PutEventsRequest(input *PutEventsInput) (req *request.Request, output *PutEventsOutput) {
	op := &request.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	output = &PutEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvents API operation for Amazon CloudWatch Events.
//
// Sends custom events to Amazon CloudWatch Events so that they can be matched
// to rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutEvents for usage and error information.
//
// Returned Error Codes:
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEvents
func (c *CloudWatchEvents) PutEvents(input *PutEventsInput) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	err := req.Send()
	return out, err
}

const opPutRule = "PutRule"

// PutRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutRuleRequest method.
//    req, resp := client.PutRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRule
func (c *CloudWatchEvents) PutRuleRequest(input *PutRuleInput) (req *request.Request, output *PutRuleOutput) {
	op := &request.Operation{
		Name:       opPutRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRuleInput{}
	}

	output = &PutRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRule API operation for Amazon CloudWatch Events.
//
// Creates or updates a rule. Rules are enabled by default, or based on value
// of the State parameter. You can disable a rule using DisableRule.
//
// Note: When you create or update a rule, incoming events might not immediately
// start matching to new or updated rules. Please allow a short period of time
// for changes to take effect.
//
// A rule must contain at least an EventPattern or ScheduleExpression. Rules
// with EventPatterns are triggered when a matching event is observed. Rules
// with ScheduleExpressions self-trigger based on the given schedule. A rule
// can have both an EventPattern and a ScheduleExpression, in which case the
// rule will trigger on matching events as well as on a schedule.
//
// Note: Most services in AWS treat : or / as the same character in Amazon Resource
// Names (ARNs). However, CloudWatch Events uses an exact match in event patterns
// and rules. Be sure to use the correct ARN characters when creating event
// patterns so that they match the ARN syntax in the event you want to match.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutRule for usage and error information.
//
// Returned Error Codes:
//   * InvalidEventPatternException
//   The event pattern is invalid.
//
//   * LimitExceededException
//   This exception occurs if you try to create more rules or add more targets
//   to a rule than allowed by default.
//
//   * ConcurrentModificationException
//   This exception occurs if there is concurrent modification on rule or target.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRule
func (c *CloudWatchEvents) PutRule(input *PutRuleInput) (*PutRuleOutput, error) {
	req, out := c.PutRuleRequest(input)
	err := req.Send()
	return out, err
}

const opPutTargets = "PutTargets"

// PutTargetsRequest generates a "aws/request.Request" representing the
// client's request for the PutTargets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutTargets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutTargets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutTargetsRequest method.
//    req, resp := client.PutTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargets
func (c *CloudWatchEvents) PutTargetsRequest(input *PutTargetsInput) (req *request.Request, output *PutTargetsOutput) {
	op := &request.Operation{
		Name:       opPutTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutTargetsInput{}
	}

	output = &PutTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutTargets API operation for Amazon CloudWatch Events.
//
// Adds target(s) to a rule. Targets are the resources that can be invoked when
// a rule is triggered. For example, AWS Lambda functions, Amazon Kinesis streams,
// and built-in targets. Updates the target(s) if they are already associated
// with the role. In other words, if there is already a target with the given
// target ID, then the target associated with that ID is updated.
//
// In order to be able to make API calls against the resources you own, Amazon
// CloudWatch Events needs the appropriate permissions. For AWS Lambda and Amazon
// SNS resources, CloudWatch Events relies on resource-based policies. For Amazon
// Kinesis streams, CloudWatch Events relies on IAM roles. For more information,
// see Permissions for Sending Events to Targets (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/EventsTargetPermissions.html)
// in the Amazon CloudWatch Developer Guide.
//
// Input and InputPath are mutually-exclusive and optional parameters of a target.
// When a rule is triggered due to a matched event, if for a target:
//
//    * Neither Input nor InputPath is specified, then the entire event is passed
//    to the target in JSON form.
//    * InputPath is specified in the form of JSONPath (e.g. $.detail), then
//    only the part of the event specified in the path is passed to the target
//    (e.g. only the detail part of the event is passed).
//    * Input is specified in the form of a valid JSON, then the matched event
//    is overridden with this constant.
// Note: When you add targets to a rule, when the associated rule triggers,
// new or updated targets might not be immediately invoked. Please allow a short
// period of time for changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutTargets for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The rule does not exist.
//
//   * ConcurrentModificationException
//   This exception occurs if there is concurrent modification on rule or target.
//
//   * LimitExceededException
//   This exception occurs if you try to create more rules or add more targets
//   to a rule than allowed by default.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargets
func (c *CloudWatchEvents) PutTargets(input *PutTargetsInput) (*PutTargetsOutput, error) {
	req, out := c.PutTargetsRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTargets = "RemoveTargets"

// RemoveTargetsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTargets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTargets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTargets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTargetsRequest method.
//    req, resp := client.RemoveTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets
func (c *CloudWatchEvents) RemoveTargetsRequest(input *RemoveTargetsInput) (req *request.Request, output *RemoveTargetsOutput) {
	op := &request.Operation{
		Name:       opRemoveTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTargetsInput{}
	}

	output = &RemoveTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTargets API operation for Amazon CloudWatch Events.
//
// Removes target(s) from a rule so that when the rule is triggered, those targets
// will no longer be invoked.
//
// Note: When you remove a target, when the associated rule triggers, removed
// targets might still continue to be invoked. Please allow a short period of
// time for changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation RemoveTargets for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The rule does not exist.
//
//   * ConcurrentModificationException
//   This exception occurs if there is concurrent modification on rule or target.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets
func (c *CloudWatchEvents) RemoveTargets(input *RemoveTargetsInput) (*RemoveTargetsOutput, error) {
	req, out := c.RemoveTargetsRequest(input)
	err := req.Send()
	return out, err
}

const opTestEventPattern = "TestEventPattern"

// TestEventPatternRequest generates a "aws/request.Request" representing the
// client's request for the TestEventPattern operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TestEventPattern for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TestEventPattern method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TestEventPatternRequest method.
//    req, resp := client.TestEventPatternRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPattern
func (c *CloudWatchEvents) TestEventPatternRequest(input *TestEventPatternInput) (req *request.Request, output *TestEventPatternOutput) {
	op := &request.Operation{
		Name:       opTestEventPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestEventPatternInput{}
	}

	output = &TestEventPatternOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestEventPattern API operation for Amazon CloudWatch Events.
//
// Tests whether an event pattern matches the provided event.
//
// Note: Most services in AWS treat : or / as the same character in Amazon Resource
// Names (ARNs). However, CloudWatch Events uses an exact match in event patterns
// and rules. Be sure to use the correct ARN characters when creating event
// patterns so that they match the ARN syntax in the event you want to match.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation TestEventPattern for usage and error information.
//
// Returned Error Codes:
//   * InvalidEventPatternException
//   The event pattern is invalid.
//
//   * InternalException
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPattern
func (c *CloudWatchEvents) TestEventPattern(input *TestEventPatternInput) (*TestEventPatternOutput, error) {
	req, out := c.TestEventPatternRequest(input)
	err := req.Send()
	return out, err
}

// Container for the parameters to the DeleteRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRuleRequest
type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule to be deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteRuleInput) SetName(v string) *DeleteRuleInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRuleOutput
type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRuleRequest
type DescribeRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule you want to describe details for.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeRuleInput) SetName(v string) *DescribeRuleInput {
	s.Name = &v
	return s
}

// The result of the DescribeRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRuleResponse
type DescribeRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the rule.
	Arn *string `min:"1" type:"string"`

	// The rule's description.
	Description *string `type:"string"`

	// The event pattern.
	EventPattern *string `type:"string"`

	// The rule's name.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the rule.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// Specifies whether the rule is enabled or disabled.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s DescribeRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeRuleOutput) SetArn(v string) *DescribeRuleOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRuleOutput) SetDescription(v string) *DescribeRuleOutput {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *DescribeRuleOutput) SetEventPattern(v string) *DescribeRuleOutput {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRuleOutput) SetName(v string) *DescribeRuleOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeRuleOutput) SetRoleArn(v string) *DescribeRuleOutput {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *DescribeRuleOutput) SetScheduleExpression(v string) *DescribeRuleOutput {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeRuleOutput) SetState(v string) *DescribeRuleOutput {
	s.State = &v
	return s
}

// Container for the parameters to the DisableRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRuleRequest
type DisableRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule you want to disable.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DisableRuleInput) SetName(v string) *DisableRuleInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRuleOutput
type DisableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRuleOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the EnableRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRuleRequest
type EnableRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule that you want to enable.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *EnableRuleInput) SetName(v string) *EnableRuleInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRuleOutput
type EnableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRuleOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the ListRuleNamesByTarget operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTargetRequest
type ListRuleNamesByTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target resource that you want to list
	// the rules for.
	//
	// TargetArn is a required field
	TargetArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRuleNamesByTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleNamesByTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleNamesByTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleNamesByTargetInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRuleNamesByTargetInput) SetLimit(v int64) *ListRuleNamesByTargetInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleNamesByTargetInput) SetNextToken(v string) *ListRuleNamesByTargetInput {
	s.NextToken = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *ListRuleNamesByTargetInput) SetTargetArn(v string) *ListRuleNamesByTargetInput {
	s.TargetArn = &v
	return s
}

// The result of the ListRuleNamesByTarget operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTargetResponse
type ListRuleNamesByTargetOutput struct {
	_ struct{} `type:"structure"`

	// Indicates that there are additional results to retrieve.
	NextToken *string `min:"1" type:"string"`

	// List of rules names that can invoke the given target.
	RuleNames []*string `type:"list"`
}

// String returns the string representation
func (s ListRuleNamesByTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleNamesByTargetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleNamesByTargetOutput) SetNextToken(v string) *ListRuleNamesByTargetOutput {
	s.NextToken = &v
	return s
}

// SetRuleNames sets the RuleNames field's value.
func (s *ListRuleNamesByTargetOutput) SetRuleNames(v []*string) *ListRuleNamesByTargetOutput {
	s.RuleNames = v
	return s
}

// Container for the parameters to the ListRules operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRulesRequest
type ListRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The prefix matching the rule name.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRulesInput) SetLimit(v int64) *ListRulesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListRulesInput) SetNamePrefix(v string) *ListRulesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesInput) SetNextToken(v string) *ListRulesInput {
	s.NextToken = &v
	return s
}

// The result of the ListRules operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRulesResponse
type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	// Indicates that there are additional results to retrieve.
	NextToken *string `min:"1" type:"string"`

	// List of rules matching the specified criteria.
	Rules []*Rule `type:"list"`
}

// String returns the string representation
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesOutput) SetNextToken(v string) *ListRulesOutput {
	s.NextToken = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListRulesOutput) SetRules(v []*Rule) *ListRulesOutput {
	s.Rules = v
	return s
}

// Container for the parameters to the ListTargetsByRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRuleRequest
type ListTargetsByRuleInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `min:"1" type:"string"`

	// The name of the rule whose targets you want to list.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTargetsByRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsByRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsByRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsByRuleInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTargetsByRuleInput) SetLimit(v int64) *ListTargetsByRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsByRuleInput) SetNextToken(v string) *ListTargetsByRuleInput {
	s.NextToken = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *ListTargetsByRuleInput) SetRule(v string) *ListTargetsByRuleInput {
	s.Rule = &v
	return s
}

// The result of the ListTargetsByRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRuleResponse
type ListTargetsByRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates that there are additional results to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Lists the targets assigned to the rule.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s ListTargetsByRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsByRuleOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsByRuleOutput) SetNextToken(v string) *ListTargetsByRuleOutput {
	s.NextToken = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsByRuleOutput) SetTargets(v []*Target) *ListTargetsByRuleOutput {
	s.Targets = v
	return s
}

// Container for the parameters to the PutEvents operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEventsRequest
type PutEventsInput struct {
	_ struct{} `type:"structure"`

	// The entry that defines an event in your system. You can specify several parameters
	// for the entry such as the source and type of the event, resources associated
	// with the event, and so on.
	//
	// Entries is a required field
	Entries []*PutEventsRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventsInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *PutEventsInput) SetEntries(v []*PutEventsRequestEntry) *PutEventsInput {
	s.Entries = v
	return s
}

// The result of the PutEvents operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEventsResponse
type PutEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of successfully and unsuccessfully ingested events results. If the
	// ingestion was successful, the entry will have the event ID in it. If not,
	// then the ErrorCode and ErrorMessage can be used to identify the problem with
	// the entry.
	Entries []*PutEventsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *PutEventsOutput) SetEntries(v []*PutEventsResultEntry) *PutEventsOutput {
	s.Entries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutEventsOutput) SetFailedEntryCount(v int64) *PutEventsOutput {
	s.FailedEntryCount = &v
	return s
}

// Contains information about the event to be used in PutEvents.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEventsRequestEntry
type PutEventsRequestEntry struct {
	_ struct{} `type:"structure"`

	// In the JSON sense, an object containing fields, which may also contain nested
	// sub-objects. No constraints are imposed on its contents.
	Detail *string `type:"string"`

	// Free-form string used to decide what fields to expect in the event detail.
	DetailType *string `type:"string"`

	// AWS resources, identified by Amazon Resource Name (ARN), which the event
	// primarily concerns. Any number, including zero, may be present.
	Resources []*string `type:"list"`

	// The source of the event.
	Source *string `type:"string"`

	// Timestamp of event, per RFC3339 (https://www.rfc-editor.org/rfc/rfc3339.txt).
	// If no timestamp is provided, the timestamp of the PutEvents call will be
	// used.
	Time *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s PutEventsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsRequestEntry) GoString() string {
	return s.String()
}

// SetDetail sets the Detail field's value.
func (s *PutEventsRequestEntry) SetDetail(v string) *PutEventsRequestEntry {
	s.Detail = &v
	return s
}

// SetDetailType sets the DetailType field's value.
func (s *PutEventsRequestEntry) SetDetailType(v string) *PutEventsRequestEntry {
	s.DetailType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *PutEventsRequestEntry) SetResources(v []*string) *PutEventsRequestEntry {
	s.Resources = v
	return s
}

// SetSource sets the Source field's value.
func (s *PutEventsRequestEntry) SetSource(v string) *PutEventsRequestEntry {
	s.Source = &v
	return s
}

// SetTime sets the Time field's value.
func (s *PutEventsRequestEntry) SetTime(v time.Time) *PutEventsRequestEntry {
	s.Time = &v
	return s
}

// A PutEventsResult contains a list of PutEventsResultEntry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEventsResultEntry
type PutEventsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code representing why the event submission failed on this entry.
	ErrorCode *string `type:"string"`

	// The error message explaining why the event submission failed on this entry.
	ErrorMessage *string `type:"string"`

	// The ID of the event submitted to Amazon CloudWatch Events.
	EventId *string `type:"string"`
}

// String returns the string representation
func (s PutEventsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutEventsResultEntry) SetErrorCode(v string) *PutEventsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutEventsResultEntry) SetErrorMessage(v string) *PutEventsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *PutEventsResultEntry) SetEventId(v string) *PutEventsResultEntry {
	s.EventId = &v
	return s
}

// Container for the parameters to the PutRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRuleRequest
type PutRuleInput struct {
	_ struct{} `type:"structure"`

	// A description of the rule.
	Description *string `type:"string"`

	// The event pattern.
	EventPattern *string `type:"string"`

	// The name of the rule that you are creating or updating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the rule.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// Indicates whether the rule is enabled or disabled.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s PutRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutRuleInput) SetDescription(v string) *PutRuleInput {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *PutRuleInput) SetEventPattern(v string) *PutRuleInput {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutRuleInput) SetName(v string) *PutRuleInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PutRuleInput) SetRoleArn(v string) *PutRuleInput {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *PutRuleInput) SetScheduleExpression(v string) *PutRuleInput {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *PutRuleInput) SetState(v string) *PutRuleInput {
	s.State = &v
	return s
}

// The result of the PutRule operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRuleResponse
type PutRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the rule.
	RuleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRuleOutput) GoString() string {
	return s.String()
}

// SetRuleArn sets the RuleArn field's value.
func (s *PutRuleOutput) SetRuleArn(v string) *PutRuleOutput {
	s.RuleArn = &v
	return s
}

// Container for the parameters to the PutTargets operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargetsRequest
type PutTargetsInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule you want to add targets to.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`

	// List of targets you want to update or add to the rule.
	//
	// Targets is a required field
	Targets []*Target `type:"list" required:"true"`
}

// String returns the string representation
func (s PutTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTargetsInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRule sets the Rule field's value.
func (s *PutTargetsInput) SetRule(v string) *PutTargetsInput {
	s.Rule = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *PutTargetsInput) SetTargets(v []*Target) *PutTargetsInput {
	s.Targets = v
	return s
}

// The result of the PutTargets operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargetsResponse
type PutTargetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of failed target entries.
	FailedEntries []*PutTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s PutTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsOutput) GoString() string {
	return s.String()
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *PutTargetsOutput) SetFailedEntries(v []*PutTargetsResultEntry) *PutTargetsOutput {
	s.FailedEntries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutTargetsOutput) SetFailedEntryCount(v int64) *PutTargetsOutput {
	s.FailedEntryCount = &v
	return s
}

// A PutTargetsResult contains a list of PutTargetsResultEntry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargetsResultEntry
type PutTargetsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code representing why the target submission failed on this entry.
	ErrorCode *string `type:"string"`

	// The error message explaining why the target submission failed on this entry.
	ErrorMessage *string `type:"string"`

	// The ID of the target submitted to Amazon CloudWatch Events.
	TargetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutTargetsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutTargetsResultEntry) SetErrorCode(v string) *PutTargetsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutTargetsResultEntry) SetErrorMessage(v string) *PutTargetsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *PutTargetsResultEntry) SetTargetId(v string) *PutTargetsResultEntry {
	s.TargetId = &v
	return s
}

// Container for the parameters to the RemoveTargets operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargetsRequest
type RemoveTargetsInput struct {
	_ struct{} `type:"structure"`

	// The list of target IDs to remove from the rule.
	//
	// Ids is a required field
	Ids []*string `min:"1" type:"list" required:"true"`

	// The name of the rule you want to remove targets from.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTargetsInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *RemoveTargetsInput) SetIds(v []*string) *RemoveTargetsInput {
	s.Ids = v
	return s
}

// SetRule sets the Rule field's value.
func (s *RemoveTargetsInput) SetRule(v string) *RemoveTargetsInput {
	s.Rule = &v
	return s
}

// The result of the RemoveTargets operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargetsResponse
type RemoveTargetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of failed target entries.
	FailedEntries []*RemoveTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s RemoveTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsOutput) GoString() string {
	return s.String()
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *RemoveTargetsOutput) SetFailedEntries(v []*RemoveTargetsResultEntry) *RemoveTargetsOutput {
	s.FailedEntries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *RemoveTargetsOutput) SetFailedEntryCount(v int64) *RemoveTargetsOutput {
	s.FailedEntryCount = &v
	return s
}

// The ID of the target requested to be removed from the rule by Amazon CloudWatch
// Events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargetsResultEntry
type RemoveTargetsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code representing why the target removal failed on this entry.
	ErrorCode *string `type:"string"`

	// The error message explaining why the target removal failed on this entry.
	ErrorMessage *string `type:"string"`

	// The ID of the target requested to be removed by Amazon CloudWatch Events.
	TargetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RemoveTargetsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *RemoveTargetsResultEntry) SetErrorCode(v string) *RemoveTargetsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *RemoveTargetsResultEntry) SetErrorMessage(v string) *RemoveTargetsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *RemoveTargetsResultEntry) SetTargetId(v string) *RemoveTargetsResultEntry {
	s.TargetId = &v
	return s
}

// Contains information about a rule in Amazon CloudWatch Events. A ListRulesResult
// contains a list of Rules.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/Rule
type Rule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `min:"1" type:"string"`

	// The description of the rule.
	Description *string `type:"string"`

	// The event pattern of the rule.
	EventPattern *string `type:"string"`

	// The rule's name.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) associated with the role that is used for
	// target invocation.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// The rule's state.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Rule) SetArn(v string) *Rule {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Rule) SetDescription(v string) *Rule {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *Rule) SetEventPattern(v string) *Rule {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *Rule) SetName(v string) *Rule {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Rule) SetRoleArn(v string) *Rule {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Rule) SetScheduleExpression(v string) *Rule {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *Rule) SetState(v string) *Rule {
	s.State = &v
	return s
}

// Targets are the resources that can be invoked when a rule is triggered. For
// example, AWS Lambda functions, Amazon Kinesis streams, and built-in targets.
//
// Input and InputPath are mutually-exclusive and optional parameters of a target.
// When a rule is triggered due to a matched event, if for a target:
//
//    * Neither Input nor InputPath is specified, then the entire event is passed
//    to the target in JSON form.
//    * InputPath is specified in the form of JSONPath (e.g. $.detail), then
//    only the part of the event specified in the path is passed to the target
//    (e.g. only the detail part of the event is passed).
//    * Input is specified in the form of a valid JSON, then the matched event
//    is overridden with this constant.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/Target
type Target struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated of the target.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The unique target assignment ID.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Valid JSON text passed to the target. For more information about JSON text,
	// see The JavaScript Object Notation (JSON) Data Interchange Format (http://www.rfc-editor.org/rfc/rfc7159.txt).
	Input *string `type:"string"`

	// The value of the JSONPath that is used for extracting part of the matched
	// event when passing it to the target. For more information about JSON paths,
	// see JSONPath (http://goessner.net/articles/JsonPath/).
	InputPath *string `type:"string"`
}

// String returns the string representation
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *Target) SetArn(v string) *Target {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Target) SetId(v string) *Target {
	s.Id = &v
	return s
}

// SetInput sets the Input field's value.
func (s *Target) SetInput(v string) *Target {
	s.Input = &v
	return s
}

// SetInputPath sets the InputPath field's value.
func (s *Target) SetInputPath(v string) *Target {
	s.InputPath = &v
	return s
}

// Container for the parameters to the TestEventPattern operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPatternRequest
type TestEventPatternInput struct {
	_ struct{} `type:"structure"`

	// The event in the JSON format to test against the event pattern.
	//
	// Event is a required field
	Event *string `type:"string" required:"true"`

	// The event pattern you want to test.
	//
	// EventPattern is a required field
	EventPattern *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestEventPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestEventPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestEventPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestEventPatternInput"}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.EventPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("EventPattern"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvent sets the Event field's value.
func (s *TestEventPatternInput) SetEvent(v string) *TestEventPatternInput {
	s.Event = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *TestEventPatternInput) SetEventPattern(v string) *TestEventPatternInput {
	s.EventPattern = &v
	return s
}

// The result of the TestEventPattern operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPatternResponse
type TestEventPatternOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the event matches the event pattern.
	Result *bool `type:"boolean"`
}

// String returns the string representation
func (s TestEventPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestEventPatternOutput) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *TestEventPatternOutput) SetResult(v bool) *TestEventPatternOutput {
	s.Result = &v
	return s
}

const (
	// RuleStateEnabled is a RuleState enum value
	RuleStateEnabled = "ENABLED"

	// RuleStateDisabled is a RuleState enum value
	RuleStateDisabled = "DISABLED"
)
