/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package componentconfig

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg2_config "k8s.io/kubernetes/pkg/util/config"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.TypeMeta
		var v1 pkg2_config.ConfigurationMap
		var v2 time.Duration
		_, _, _ = v0, v1, v2
	}
}

func (x *KubeProxyConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [20]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(20)
			} else {
				yynn2 = 18
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy25 := *x.IPTablesMasqueradeBit
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeInt(int64(yy25))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy27 := *x.IPTablesMasqueradeBit
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(yy27))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy30 := &x.IPTablesSyncPeriod
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else if z.HasExtensions() && z.EncExt(yy30) {
				} else if !yym31 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy30)
				} else {
					z.EncFallback(yy30)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy32 := &x.IPTablesSyncPeriod
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else if z.HasExtensions() && z.EncExt(yy32) {
				} else if !yym33 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy32)
				} else {
					z.EncFallback(yy32)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym35 := z.EncBinary()
				_ = yym35
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeconfigPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym36 := z.EncBinary()
				_ = yym36
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masqueradeAll"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym39 := z.EncBinary()
				_ = yym39
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("master"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym42 := z.EncBinary()
				_ = yym42
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy44 := *x.OOMScoreAdj
					yym45 := z.EncBinary()
					_ = yym45
					if false {
					} else {
						r.EncodeInt(int64(yy44))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy46 := *x.OOMScoreAdj
					yym47 := z.EncBinary()
					_ = yym47
					if false {
					} else {
						r.EncodeInt(int64(yy46))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym50 := z.EncBinary()
				_ = yym50
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("portRange"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym51 := z.EncBinary()
				_ = yym51
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym53 := z.EncBinary()
				_ = yym53
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceContainer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym54 := z.EncBinary()
				_ = yym54
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy56 := &x.UDPIdleTimeout
				yym57 := z.EncBinary()
				_ = yym57
				if false {
				} else if z.HasExtensions() && z.EncExt(yy56) {
				} else if !yym57 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy56)
				} else {
					z.EncFallback(yy56)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("udpTimeoutMilliseconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy58 := &x.UDPIdleTimeout
				yym59 := z.EncBinary()
				_ = yym59
				if false {
				} else if z.HasExtensions() && z.EncExt(yy58) {
				} else if !yym59 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy58)
				} else {
					z.EncFallback(yy58)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym61 := z.EncBinary()
				_ = yym61
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMax"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym62 := z.EncBinary()
				_ = yym62
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym64 := z.EncBinary()
				_ = yym64
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMaxPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym65 := z.EncBinary()
				_ = yym65
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy67 := &x.ConntrackTCPEstablishedTimeout
				yym68 := z.EncBinary()
				_ = yym68
				if false {
				} else if z.HasExtensions() && z.EncExt(yy67) {
				} else if !yym68 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy67)
				} else {
					z.EncFallback(yy67)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPEstablishedTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy69 := &x.ConntrackTCPEstablishedTimeout
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else if z.HasExtensions() && z.EncExt(yy69) {
				} else if !yym70 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy69)
				} else {
					z.EncFallback(yy69)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeProxyConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym71 := z.DecBinary()
	_ = yym71
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct72 := r.ContainerType()
		if yyct72 == codecSelferValueTypeMap1234 {
			yyl72 := r.ReadMapStart()
			if yyl72 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl72, d)
			}
		} else if yyct72 == codecSelferValueTypeArray1234 {
			yyl72 := r.ReadArrayStart()
			if yyl72 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl72, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys73Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys73Slc
	var yyhl73 bool = l >= 0
	for yyj73 := 0; ; yyj73++ {
		if yyhl73 {
			if yyj73 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys73Slc = r.DecodeBytes(yys73Slc, true, true)
		yys73 := string(yys73Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys73 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "bindAddress":
			if r.TryDecodeAsNil() {
				x.BindAddress = ""
			} else {
				x.BindAddress = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				if x.IPTablesMasqueradeBit != nil {
					x.IPTablesMasqueradeBit = nil
				}
			} else {
				if x.IPTablesMasqueradeBit == nil {
					x.IPTablesMasqueradeBit = new(int32)
				}
				yym82 := z.DecBinary()
				_ = yym82
				if false {
				} else {
					*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
				}
			}
		case "iptablesSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv83 := &x.IPTablesSyncPeriod
				yym84 := z.DecBinary()
				_ = yym84
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv83) {
				} else if !yym84 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv83)
				} else {
					z.DecFallback(yyv83, false)
				}
			}
		case "kubeconfigPath":
			if r.TryDecodeAsNil() {
				x.KubeconfigPath = ""
			} else {
				x.KubeconfigPath = string(r.DecodeString())
			}
		case "masqueradeAll":
			if r.TryDecodeAsNil() {
				x.MasqueradeAll = false
			} else {
				x.MasqueradeAll = bool(r.DecodeBool())
			}
		case "master":
			if r.TryDecodeAsNil() {
				x.Master = ""
			} else {
				x.Master = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				if x.OOMScoreAdj != nil {
					x.OOMScoreAdj = nil
				}
			} else {
				if x.OOMScoreAdj == nil {
					x.OOMScoreAdj = new(int32)
				}
				yym89 := z.DecBinary()
				_ = yym89
				if false {
				} else {
					*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = ProxyMode(r.DecodeString())
			}
		case "portRange":
			if r.TryDecodeAsNil() {
				x.PortRange = ""
			} else {
				x.PortRange = string(r.DecodeString())
			}
		case "resourceContainer":
			if r.TryDecodeAsNil() {
				x.ResourceContainer = ""
			} else {
				x.ResourceContainer = string(r.DecodeString())
			}
		case "udpTimeoutMilliseconds":
			if r.TryDecodeAsNil() {
				x.UDPIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv93 := &x.UDPIdleTimeout
				yym94 := z.DecBinary()
				_ = yym94
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv93) {
				} else if !yym94 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv93)
				} else {
					z.DecFallback(yyv93, false)
				}
			}
		case "conntrackMax":
			if r.TryDecodeAsNil() {
				x.ConntrackMax = 0
			} else {
				x.ConntrackMax = int32(r.DecodeInt(32))
			}
		case "conntrackMaxPerCore":
			if r.TryDecodeAsNil() {
				x.ConntrackMaxPerCore = 0
			} else {
				x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
			}
		case "conntrackTCPEstablishedTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv97 := &x.ConntrackTCPEstablishedTimeout
				yym98 := z.DecBinary()
				_ = yym98
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv97) {
				} else if !yym98 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv97)
				} else {
					z.DecFallback(yyv97, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys73)
		} // end switch yys73
	} // end for yyj73
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj99 int
	var yyb99 bool
	var yyhl99 bool = l >= 0
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BindAddress = ""
	} else {
		x.BindAddress = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.IPTablesMasqueradeBit != nil {
			x.IPTablesMasqueradeBit = nil
		}
	} else {
		if x.IPTablesMasqueradeBit == nil {
			x.IPTablesMasqueradeBit = new(int32)
		}
		yym108 := z.DecBinary()
		_ = yym108
		if false {
		} else {
			*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
		}
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv109 := &x.IPTablesSyncPeriod
		yym110 := z.DecBinary()
		_ = yym110
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv109) {
		} else if !yym110 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv109)
		} else {
			z.DecFallback(yyv109, false)
		}
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeconfigPath = ""
	} else {
		x.KubeconfigPath = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasqueradeAll = false
	} else {
		x.MasqueradeAll = bool(r.DecodeBool())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Master = ""
	} else {
		x.Master = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.OOMScoreAdj != nil {
			x.OOMScoreAdj = nil
		}
	} else {
		if x.OOMScoreAdj == nil {
			x.OOMScoreAdj = new(int32)
		}
		yym115 := z.DecBinary()
		_ = yym115
		if false {
		} else {
			*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
		}
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = ProxyMode(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PortRange = ""
	} else {
		x.PortRange = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceContainer = ""
	} else {
		x.ResourceContainer = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UDPIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv119 := &x.UDPIdleTimeout
		yym120 := z.DecBinary()
		_ = yym120
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv119) {
		} else if !yym120 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv119)
		} else {
			z.DecFallback(yyv119, false)
		}
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMax = 0
	} else {
		x.ConntrackMax = int32(r.DecodeInt(32))
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMaxPerCore = 0
	} else {
		x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv123 := &x.ConntrackTCPEstablishedTimeout
		yym124 := z.DecBinary()
		_ = yym124
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv123) {
		} else if !yym124 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv123)
		} else {
			z.DecFallback(yyv123, false)
		}
	}
	for {
		yyj99++
		if yyhl99 {
			yyb99 = yyj99 > l
		} else {
			yyb99 = r.CheckBreak()
		}
		if yyb99 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj99-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ProxyMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym125 := z.EncBinary()
	_ = yym125
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ProxyMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym126 := z.DecBinary()
	_ = yym126
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x HairpinMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym127 := z.EncBinary()
	_ = yym127
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *HairpinMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym128 := z.DecBinary()
	_ = yym128
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym129 := z.EncBinary()
		_ = yym129
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep130 := !z.EncBinary()
			yy2arr130 := z.EncBasicHandle().StructToArray
			var yyq130 [105]bool
			_, _, _ = yysep130, yyq130, yy2arr130
			const yyr130 bool = false
			yyq130[0] = x.Kind != ""
			yyq130[1] = x.APIVersion != ""
			yyq130[51] = x.CloudProvider != ""
			yyq130[52] = x.CloudConfigFile != ""
			yyq130[53] = x.KubeletCgroups != ""
			yyq130[54] = x.CgroupsPerQOS != false
			yyq130[55] = x.RuntimeCgroups != ""
			yyq130[56] = x.SystemCgroups != ""
			yyq130[57] = x.CgroupRoot != ""
			yyq130[61] = true
			yyq130[62] = x.RktPath != ""
			yyq130[63] = x.RktAPIEndpoint != ""
			yyq130[64] = x.RktStage1Image != ""
			yyq130[85] = true
			yyq130[86] = x.NodeIP != ""
			yyq130[90] = x.EvictionHard != ""
			yyq130[91] = x.EvictionSoft != ""
			yyq130[92] = x.EvictionSoftGracePeriod != ""
			yyq130[93] = true
			yyq130[94] = x.EvictionMaxPodGracePeriod != 0
			yyq130[95] = x.EvictionMinimumReclaim != ""
			yyq130[104] = len(x.AllowedUnsafeSysctls) != 0
			var yynn130 int
			if yyr130 || yy2arr130 {
				r.EncodeArrayStart(105)
			} else {
				yynn130 = 83
				for _, b := range yyq130 {
					if b {
						yynn130++
					}
				}
				r.EncodeMapStart(yynn130)
				yynn130 = 0
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[0] {
					yym132 := z.EncBinary()
					_ = yym132
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym133 := z.EncBinary()
					_ = yym133
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[1] {
					yym135 := z.EncBinary()
					_ = yym135
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym136 := z.EncBinary()
					_ = yym136
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym138 := z.EncBinary()
				_ = yym138
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podManifestPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym139 := z.EncBinary()
				_ = yym139
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy141 := &x.SyncFrequency
				yym142 := z.EncBinary()
				_ = yym142
				if false {
				} else if z.HasExtensions() && z.EncExt(yy141) {
				} else if !yym142 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy141)
				} else {
					z.EncFallback(yy141)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("syncFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy143 := &x.SyncFrequency
				yym144 := z.EncBinary()
				_ = yym144
				if false {
				} else if z.HasExtensions() && z.EncExt(yy143) {
				} else if !yym144 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy143)
				} else {
					z.EncFallback(yy143)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy146 := &x.FileCheckFrequency
				yym147 := z.EncBinary()
				_ = yym147
				if false {
				} else if z.HasExtensions() && z.EncExt(yy146) {
				} else if !yym147 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy146)
				} else {
					z.EncFallback(yy146)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fileCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy148 := &x.FileCheckFrequency
				yym149 := z.EncBinary()
				_ = yym149
				if false {
				} else if z.HasExtensions() && z.EncExt(yy148) {
				} else if !yym149 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy148)
				} else {
					z.EncFallback(yy148)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy151 := &x.HTTPCheckFrequency
				yym152 := z.EncBinary()
				_ = yym152
				if false {
				} else if z.HasExtensions() && z.EncExt(yy151) {
				} else if !yym152 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy151)
				} else {
					z.EncFallback(yy151)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("httpCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy153 := &x.HTTPCheckFrequency
				yym154 := z.EncBinary()
				_ = yym154
				if false {
				} else if z.HasExtensions() && z.EncExt(yy153) {
				} else if !yym154 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy153)
				} else {
					z.EncFallback(yy153)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym156 := z.EncBinary()
				_ = yym156
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym157 := z.EncBinary()
				_ = yym157
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym159 := z.EncBinary()
				_ = yym159
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURLHeader"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym160 := z.EncBinary()
				_ = yym160
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym162 := z.EncBinary()
				_ = yym162
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableServer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym163 := z.EncBinary()
				_ = yym163
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym165 := z.EncBinary()
				_ = yym165
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym166 := z.EncBinary()
				_ = yym166
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym168 := z.EncBinary()
				_ = yym168
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym169 := z.EncBinary()
				_ = yym169
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym171 := z.EncBinary()
				_ = yym171
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("readOnlyPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym172 := z.EncBinary()
				_ = yym172
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym174 := z.EncBinary()
				_ = yym174
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym175 := z.EncBinary()
				_ = yym175
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym177 := z.EncBinary()
				_ = yym177
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsPrivateKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym178 := z.EncBinary()
				_ = yym178
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym180 := z.EncBinary()
				_ = yym180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("certDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym181 := z.EncBinary()
				_ = yym181
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym183 := z.EncBinary()
				_ = yym183
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym184 := z.EncBinary()
				_ = yym184
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym186 := z.EncBinary()
				_ = yym186
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podInfraContainerImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym187 := z.EncBinary()
				_ = yym187
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym189 := z.EncBinary()
				_ = yym189
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym190 := z.EncBinary()
				_ = yym190
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym192 := z.EncBinary()
				_ = yym192
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym193 := z.EncBinary()
				_ = yym193
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym195 := z.EncBinary()
				_ = yym195
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seccompProfileRoot"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym196 := z.EncBinary()
				_ = yym196
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym198 := z.EncBinary()
				_ = yym198
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allowPrivileged"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym199 := z.EncBinary()
				_ = yym199
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym201 := z.EncBinary()
					_ = yym201
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostNetworkSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym202 := z.EncBinary()
					_ = yym202
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym204 := z.EncBinary()
					_ = yym204
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostPIDSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym205 := z.EncBinary()
					_ = yym205
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym207 := z.EncBinary()
					_ = yym207
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostIPCSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym208 := z.EncBinary()
					_ = yym208
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym210 := z.EncBinary()
				_ = yym210
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryPullQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym211 := z.EncBinary()
				_ = yym211
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym213 := z.EncBinary()
				_ = yym213
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym214 := z.EncBinary()
				_ = yym214
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym216 := z.EncBinary()
				_ = yym216
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventRecordQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym217 := z.EncBinary()
				_ = yym217
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym219 := z.EncBinary()
				_ = yym219
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym220 := z.EncBinary()
				_ = yym220
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym222 := z.EncBinary()
				_ = yym222
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDebuggingHandlers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym223 := z.EncBinary()
				_ = yym223
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy225 := &x.MinimumGCAge
				yym226 := z.EncBinary()
				_ = yym226
				if false {
				} else if z.HasExtensions() && z.EncExt(yy225) {
				} else if !yym226 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy225)
				} else {
					z.EncFallback(yy225)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy227 := &x.MinimumGCAge
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else if z.HasExtensions() && z.EncExt(yy227) {
				} else if !yym228 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy227)
				} else {
					z.EncFallback(yy227)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym230 := z.EncBinary()
				_ = yym230
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPerPodContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym231 := z.EncBinary()
				_ = yym231
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym233 := z.EncBinary()
				_ = yym233
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym234 := z.EncBinary()
				_ = yym234
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym236 := z.EncBinary()
				_ = yym236
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cAdvisorPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym237 := z.EncBinary()
				_ = yym237
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym239 := z.EncBinary()
				_ = yym239
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym240 := z.EncBinary()
				_ = yym240
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym242 := z.EncBinary()
				_ = yym242
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym243 := z.EncBinary()
				_ = yym243
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym245 := z.EncBinary()
				_ = yym245
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym246 := z.EncBinary()
				_ = yym246
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym248 := z.EncBinary()
				_ = yym248
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerNode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym249 := z.EncBinary()
				_ = yym249
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym251 := z.EncBinary()
				_ = yym251
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDomain"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym252 := z.EncBinary()
				_ = yym252
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym254 := z.EncBinary()
				_ = yym254
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masterServiceNamespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym255 := z.EncBinary()
				_ = yym255
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym257 := z.EncBinary()
				_ = yym257
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDNS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym258 := z.EncBinary()
				_ = yym258
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy260 := &x.StreamingConnectionIdleTimeout
				yym261 := z.EncBinary()
				_ = yym261
				if false {
				} else if z.HasExtensions() && z.EncExt(yy260) {
				} else if !yym261 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy260)
				} else {
					z.EncFallback(yy260)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("streamingConnectionIdleTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy262 := &x.StreamingConnectionIdleTimeout
				yym263 := z.EncBinary()
				_ = yym263
				if false {
				} else if z.HasExtensions() && z.EncExt(yy262) {
				} else if !yym263 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy262)
				} else {
					z.EncFallback(yy262)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy265 := &x.NodeStatusUpdateFrequency
				yym266 := z.EncBinary()
				_ = yym266
				if false {
				} else if z.HasExtensions() && z.EncExt(yy265) {
				} else if !yym266 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy265)
				} else {
					z.EncFallback(yy265)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStatusUpdateFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy267 := &x.NodeStatusUpdateFrequency
				yym268 := z.EncBinary()
				_ = yym268
				if false {
				} else if z.HasExtensions() && z.EncExt(yy267) {
				} else if !yym268 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy267)
				} else {
					z.EncFallback(yy267)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy270 := &x.ImageMinimumGCAge
				yym271 := z.EncBinary()
				_ = yym271
				if false {
				} else if z.HasExtensions() && z.EncExt(yy270) {
				} else if !yym271 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy270)
				} else {
					z.EncFallback(yy270)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageMinimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy272 := &x.ImageMinimumGCAge
				yym273 := z.EncBinary()
				_ = yym273
				if false {
				} else if z.HasExtensions() && z.EncExt(yy272) {
				} else if !yym273 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy272)
				} else {
					z.EncFallback(yy272)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym275 := z.EncBinary()
				_ = yym275
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCHighThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym276 := z.EncBinary()
				_ = yym276
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym278 := z.EncBinary()
				_ = yym278
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCLowThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym279 := z.EncBinary()
				_ = yym279
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym281 := z.EncBinary()
				_ = yym281
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lowDiskSpaceThresholdMB"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym282 := z.EncBinary()
				_ = yym282
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy284 := &x.VolumeStatsAggPeriod
				yym285 := z.EncBinary()
				_ = yym285
				if false {
				} else if z.HasExtensions() && z.EncExt(yy284) {
				} else if !yym285 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy284)
				} else {
					z.EncFallback(yy284)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeStatsAggPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy286 := &x.VolumeStatsAggPeriod
				yym287 := z.EncBinary()
				_ = yym287
				if false {
				} else if z.HasExtensions() && z.EncExt(yy286) {
				} else if !yym287 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy286)
				} else {
					z.EncFallback(yy286)
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym289 := z.EncBinary()
				_ = yym289
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym290 := z.EncBinary()
				_ = yym290
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym292 := z.EncBinary()
				_ = yym292
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginMTU"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym293 := z.EncBinary()
				_ = yym293
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym295 := z.EncBinary()
				_ = yym295
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym296 := z.EncBinary()
				_ = yym296
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym298 := z.EncBinary()
				_ = yym298
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym299 := z.EncBinary()
				_ = yym299
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[51] {
					yym301 := z.EncBinary()
					_ = yym301
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[51] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym302 := z.EncBinary()
					_ = yym302
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[52] {
					yym304 := z.EncBinary()
					_ = yym304
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[52] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym305 := z.EncBinary()
					_ = yym305
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[53] {
					yym307 := z.EncBinary()
					_ = yym307
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[53] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym308 := z.EncBinary()
					_ = yym308
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[54] {
					yym310 := z.EncBinary()
					_ = yym310
					if false {
					} else {
						r.EncodeBool(bool(x.CgroupsPerQOS))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq130[54] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("CgroupsPerQOS"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym311 := z.EncBinary()
					_ = yym311
					if false {
					} else {
						r.EncodeBool(bool(x.CgroupsPerQOS))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[55] {
					yym313 := z.EncBinary()
					_ = yym313
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[55] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym314 := z.EncBinary()
					_ = yym314
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[56] {
					yym316 := z.EncBinary()
					_ = yym316
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[56] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("systemCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym317 := z.EncBinary()
					_ = yym317
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[57] {
					yym319 := z.EncBinary()
					_ = yym319
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[57] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym320 := z.EncBinary()
					_ = yym320
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym322 := z.EncBinary()
				_ = yym322
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntime"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym323 := z.EncBinary()
				_ = yym323
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym325 := z.EncBinary()
				_ = yym325
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteRuntimeEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym326 := z.EncBinary()
				_ = yym326
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym328 := z.EncBinary()
				_ = yym328
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteImageEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym329 := z.EncBinary()
				_ = yym329
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[61] {
					yy331 := &x.RuntimeRequestTimeout
					yym332 := z.EncBinary()
					_ = yym332
					if false {
					} else if z.HasExtensions() && z.EncExt(yy331) {
					} else if !yym332 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy331)
					} else {
						z.EncFallback(yy331)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq130[61] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeRequestTimeout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy333 := &x.RuntimeRequestTimeout
					yym334 := z.EncBinary()
					_ = yym334
					if false {
					} else if z.HasExtensions() && z.EncExt(yy333) {
					} else if !yym334 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy333)
					} else {
						z.EncFallback(yy333)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[62] {
					yym336 := z.EncBinary()
					_ = yym336
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[62] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym337 := z.EncBinary()
					_ = yym337
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[63] {
					yym339 := z.EncBinary()
					_ = yym339
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[63] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktAPIEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym340 := z.EncBinary()
					_ = yym340
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[64] {
					yym342 := z.EncBinary()
					_ = yym342
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[64] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktStage1Image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym343 := z.EncBinary()
					_ = yym343
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym345 := z.EncBinary()
				_ = yym345
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lockFilePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym346 := z.EncBinary()
				_ = yym346
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym348 := z.EncBinary()
				_ = yym348
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitOnLockContention"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym349 := z.EncBinary()
				_ = yym349
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym351 := z.EncBinary()
				_ = yym351
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCBR0))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCbr0"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym352 := z.EncBinary()
				_ = yym352
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCBR0))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym354 := z.EncBinary()
				_ = yym354
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hairpinMode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym355 := z.EncBinary()
				_ = yym355
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym357 := z.EncBinary()
				_ = yym357
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("babysitDaemons"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym358 := z.EncBinary()
				_ = yym358
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym360 := z.EncBinary()
				_ = yym360
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym361 := z.EncBinary()
				_ = yym361
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym363 := z.EncBinary()
				_ = yym363
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nvidiaGPUs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym364 := z.EncBinary()
				_ = yym364
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym366 := z.EncBinary()
				_ = yym366
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerExecHandlerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym367 := z.EncBinary()
				_ = yym367
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym369 := z.EncBinary()
				_ = yym369
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym370 := z.EncBinary()
				_ = yym370
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym372 := z.EncBinary()
				_ = yym372
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resolvConf"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym373 := z.EncBinary()
				_ = yym373
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym375 := z.EncBinary()
				_ = yym375
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cpuCFSQuota"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym376 := z.EncBinary()
				_ = yym376
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym378 := z.EncBinary()
				_ = yym378
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerized"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym379 := z.EncBinary()
				_ = yym379
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym381 := z.EncBinary()
				_ = yym381
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxOpenFiles"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym382 := z.EncBinary()
				_ = yym382
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym384 := z.EncBinary()
				_ = yym384
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("reconcileCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym385 := z.EncBinary()
				_ = yym385
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym387 := z.EncBinary()
				_ = yym387
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerSchedulable"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym388 := z.EncBinary()
				_ = yym388
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym390 := z.EncBinary()
				_ = yym390
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym391 := z.EncBinary()
				_ = yym391
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym393 := z.EncBinary()
				_ = yym393
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym394 := z.EncBinary()
				_ = yym394
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym396 := z.EncBinary()
				_ = yym396
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym397 := z.EncBinary()
				_ = yym397
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym399 := z.EncBinary()
				_ = yym399
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serializeImagePulls"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym400 := z.EncBinary()
				_ = yym400
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym402 := z.EncBinary()
				_ = yym402
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalFlannelOverlay))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("experimentalFlannelOverlay"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym403 := z.EncBinary()
				_ = yym403
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalFlannelOverlay))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[85] {
					yy405 := &x.OutOfDiskTransitionFrequency
					yym406 := z.EncBinary()
					_ = yym406
					if false {
					} else if z.HasExtensions() && z.EncExt(yy405) {
					} else if !yym406 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy405)
					} else {
						z.EncFallback(yy405)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq130[85] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("outOfDiskTransitionFrequency"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy407 := &x.OutOfDiskTransitionFrequency
					yym408 := z.EncBinary()
					_ = yym408
					if false {
					} else if z.HasExtensions() && z.EncExt(yy407) {
					} else if !yym408 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy407)
					} else {
						z.EncFallback(yy407)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[86] {
					yym410 := z.EncBinary()
					_ = yym410
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[86] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym411 := z.EncBinary()
					_ = yym411
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym413 := z.EncBinary()
					_ = yym413
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeLabels"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym414 := z.EncBinary()
					_ = yym414
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym416 := z.EncBinary()
				_ = yym416
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nonMasqueradeCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym417 := z.EncBinary()
				_ = yym417
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym419 := z.EncBinary()
				_ = yym419
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableCustomMetrics"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym420 := z.EncBinary()
				_ = yym420
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[90] {
					yym422 := z.EncBinary()
					_ = yym422
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[90] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionHard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym423 := z.EncBinary()
					_ = yym423
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[91] {
					yym425 := z.EncBinary()
					_ = yym425
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[91] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoft"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym426 := z.EncBinary()
					_ = yym426
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[92] {
					yym428 := z.EncBinary()
					_ = yym428
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[92] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoftGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym429 := z.EncBinary()
					_ = yym429
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[93] {
					yy431 := &x.EvictionPressureTransitionPeriod
					yym432 := z.EncBinary()
					_ = yym432
					if false {
					} else if z.HasExtensions() && z.EncExt(yy431) {
					} else if !yym432 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy431)
					} else {
						z.EncFallback(yy431)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq130[93] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionPressureTransitionPeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy433 := &x.EvictionPressureTransitionPeriod
					yym434 := z.EncBinary()
					_ = yym434
					if false {
					} else if z.HasExtensions() && z.EncExt(yy433) {
					} else if !yym434 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy433)
					} else {
						z.EncFallback(yy433)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[94] {
					yym436 := z.EncBinary()
					_ = yym436
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq130[94] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMaxPodGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym437 := z.EncBinary()
					_ = yym437
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[95] {
					yym439 := z.EncBinary()
					_ = yym439
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq130[95] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMinimumReclaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym440 := z.EncBinary()
					_ = yym440
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym442 := z.EncBinary()
				_ = yym442
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podsPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym443 := z.EncBinary()
				_ = yym443
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym445 := z.EncBinary()
				_ = yym445
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableControllerAttachDetach"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym446 := z.EncBinary()
				_ = yym446
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym448 := z.EncBinary()
					_ = yym448
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym449 := z.EncBinary()
					_ = yym449
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym451 := z.EncBinary()
					_ = yym451
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym452 := z.EncBinary()
					_ = yym452
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym454 := z.EncBinary()
				_ = yym454
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protectKernelDefaults"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym455 := z.EncBinary()
				_ = yym455
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym457 := z.EncBinary()
				_ = yym457
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("makeIPTablesUtilChains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym458 := z.EncBinary()
				_ = yym458
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym460 := z.EncBinary()
				_ = yym460
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym461 := z.EncBinary()
				_ = yym461
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym463 := z.EncBinary()
				_ = yym463
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesDropBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym464 := z.EncBinary()
				_ = yym464
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq130[104] {
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym466 := z.EncBinary()
						_ = yym466
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq130[104] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalAllowedUnsafeSysctls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym467 := z.EncBinary()
						_ = yym467
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				}
			}
			if yyr130 || yy2arr130 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym468 := z.DecBinary()
	_ = yym468
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct469 := r.ContainerType()
		if yyct469 == codecSelferValueTypeMap1234 {
			yyl469 := r.ReadMapStart()
			if yyl469 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl469, d)
			}
		} else if yyct469 == codecSelferValueTypeArray1234 {
			yyl469 := r.ReadArrayStart()
			if yyl469 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl469, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys470Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys470Slc
	var yyhl470 bool = l >= 0
	for yyj470 := 0; ; yyj470++ {
		if yyhl470 {
			if yyj470 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys470Slc = r.DecodeBytes(yys470Slc, true, true)
		yys470 := string(yys470Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys470 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "podManifestPath":
			if r.TryDecodeAsNil() {
				x.PodManifestPath = ""
			} else {
				x.PodManifestPath = string(r.DecodeString())
			}
		case "syncFrequency":
			if r.TryDecodeAsNil() {
				x.SyncFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv474 := &x.SyncFrequency
				yym475 := z.DecBinary()
				_ = yym475
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv474) {
				} else if !yym475 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv474)
				} else {
					z.DecFallback(yyv474, false)
				}
			}
		case "fileCheckFrequency":
			if r.TryDecodeAsNil() {
				x.FileCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv476 := &x.FileCheckFrequency
				yym477 := z.DecBinary()
				_ = yym477
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv476) {
				} else if !yym477 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv476)
				} else {
					z.DecFallback(yyv476, false)
				}
			}
		case "httpCheckFrequency":
			if r.TryDecodeAsNil() {
				x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv478 := &x.HTTPCheckFrequency
				yym479 := z.DecBinary()
				_ = yym479
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv478) {
				} else if !yym479 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv478)
				} else {
					z.DecFallback(yyv478, false)
				}
			}
		case "manifestURL":
			if r.TryDecodeAsNil() {
				x.ManifestURL = ""
			} else {
				x.ManifestURL = string(r.DecodeString())
			}
		case "manifestURLHeader":
			if r.TryDecodeAsNil() {
				x.ManifestURLHeader = ""
			} else {
				x.ManifestURLHeader = string(r.DecodeString())
			}
		case "enableServer":
			if r.TryDecodeAsNil() {
				x.EnableServer = false
			} else {
				x.EnableServer = bool(r.DecodeBool())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "readOnlyPort":
			if r.TryDecodeAsNil() {
				x.ReadOnlyPort = 0
			} else {
				x.ReadOnlyPort = int32(r.DecodeInt(32))
			}
		case "tlsCertFile":
			if r.TryDecodeAsNil() {
				x.TLSCertFile = ""
			} else {
				x.TLSCertFile = string(r.DecodeString())
			}
		case "tlsPrivateKeyFile":
			if r.TryDecodeAsNil() {
				x.TLSPrivateKeyFile = ""
			} else {
				x.TLSPrivateKeyFile = string(r.DecodeString())
			}
		case "certDirectory":
			if r.TryDecodeAsNil() {
				x.CertDirectory = ""
			} else {
				x.CertDirectory = string(r.DecodeString())
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "podInfraContainerImage":
			if r.TryDecodeAsNil() {
				x.PodInfraContainerImage = ""
			} else {
				x.PodInfraContainerImage = string(r.DecodeString())
			}
		case "dockerEndpoint":
			if r.TryDecodeAsNil() {
				x.DockerEndpoint = ""
			} else {
				x.DockerEndpoint = string(r.DecodeString())
			}
		case "rootDirectory":
			if r.TryDecodeAsNil() {
				x.RootDirectory = ""
			} else {
				x.RootDirectory = string(r.DecodeString())
			}
		case "seccompProfileRoot":
			if r.TryDecodeAsNil() {
				x.SeccompProfileRoot = ""
			} else {
				x.SeccompProfileRoot = string(r.DecodeString())
			}
		case "allowPrivileged":
			if r.TryDecodeAsNil() {
				x.AllowPrivileged = false
			} else {
				x.AllowPrivileged = bool(r.DecodeBool())
			}
		case "hostNetworkSources":
			if r.TryDecodeAsNil() {
				x.HostNetworkSources = nil
			} else {
				yyv495 := &x.HostNetworkSources
				yym496 := z.DecBinary()
				_ = yym496
				if false {
				} else {
					z.F.DecSliceStringX(yyv495, false, d)
				}
			}
		case "hostPIDSources":
			if r.TryDecodeAsNil() {
				x.HostPIDSources = nil
			} else {
				yyv497 := &x.HostPIDSources
				yym498 := z.DecBinary()
				_ = yym498
				if false {
				} else {
					z.F.DecSliceStringX(yyv497, false, d)
				}
			}
		case "hostIPCSources":
			if r.TryDecodeAsNil() {
				x.HostIPCSources = nil
			} else {
				yyv499 := &x.HostIPCSources
				yym500 := z.DecBinary()
				_ = yym500
				if false {
				} else {
					z.F.DecSliceStringX(yyv499, false, d)
				}
			}
		case "registryPullQPS":
			if r.TryDecodeAsNil() {
				x.RegistryPullQPS = 0
			} else {
				x.RegistryPullQPS = int32(r.DecodeInt(32))
			}
		case "registryBurst":
			if r.TryDecodeAsNil() {
				x.RegistryBurst = 0
			} else {
				x.RegistryBurst = int32(r.DecodeInt(32))
			}
		case "eventRecordQPS":
			if r.TryDecodeAsNil() {
				x.EventRecordQPS = 0
			} else {
				x.EventRecordQPS = int32(r.DecodeInt(32))
			}
		case "eventBurst":
			if r.TryDecodeAsNil() {
				x.EventBurst = 0
			} else {
				x.EventBurst = int32(r.DecodeInt(32))
			}
		case "enableDebuggingHandlers":
			if r.TryDecodeAsNil() {
				x.EnableDebuggingHandlers = false
			} else {
				x.EnableDebuggingHandlers = bool(r.DecodeBool())
			}
		case "minimumGCAge":
			if r.TryDecodeAsNil() {
				x.MinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv506 := &x.MinimumGCAge
				yym507 := z.DecBinary()
				_ = yym507
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv506) {
				} else if !yym507 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv506)
				} else {
					z.DecFallback(yyv506, false)
				}
			}
		case "maxPerPodContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxPerPodContainerCount = 0
			} else {
				x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
			}
		case "maxContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxContainerCount = 0
			} else {
				x.MaxContainerCount = int32(r.DecodeInt(32))
			}
		case "cAdvisorPort":
			if r.TryDecodeAsNil() {
				x.CAdvisorPort = 0
			} else {
				x.CAdvisorPort = int32(r.DecodeInt(32))
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				x.OOMScoreAdj = 0
			} else {
				x.OOMScoreAdj = int32(r.DecodeInt(32))
			}
		case "registerNode":
			if r.TryDecodeAsNil() {
				x.RegisterNode = false
			} else {
				x.RegisterNode = bool(r.DecodeBool())
			}
		case "clusterDomain":
			if r.TryDecodeAsNil() {
				x.ClusterDomain = ""
			} else {
				x.ClusterDomain = string(r.DecodeString())
			}
		case "masterServiceNamespace":
			if r.TryDecodeAsNil() {
				x.MasterServiceNamespace = ""
			} else {
				x.MasterServiceNamespace = string(r.DecodeString())
			}
		case "clusterDNS":
			if r.TryDecodeAsNil() {
				x.ClusterDNS = ""
			} else {
				x.ClusterDNS = string(r.DecodeString())
			}
		case "streamingConnectionIdleTimeout":
			if r.TryDecodeAsNil() {
				x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv518 := &x.StreamingConnectionIdleTimeout
				yym519 := z.DecBinary()
				_ = yym519
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv518) {
				} else if !yym519 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv518)
				} else {
					z.DecFallback(yyv518, false)
				}
			}
		case "nodeStatusUpdateFrequency":
			if r.TryDecodeAsNil() {
				x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv520 := &x.NodeStatusUpdateFrequency
				yym521 := z.DecBinary()
				_ = yym521
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv520) {
				} else if !yym521 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv520)
				} else {
					z.DecFallback(yyv520, false)
				}
			}
		case "imageMinimumGCAge":
			if r.TryDecodeAsNil() {
				x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv522 := &x.ImageMinimumGCAge
				yym523 := z.DecBinary()
				_ = yym523
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv522) {
				} else if !yym523 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv522)
				} else {
					z.DecFallback(yyv522, false)
				}
			}
		case "imageGCHighThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCHighThresholdPercent = 0
			} else {
				x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
			}
		case "imageGCLowThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCLowThresholdPercent = 0
			} else {
				x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
			}
		case "lowDiskSpaceThresholdMB":
			if r.TryDecodeAsNil() {
				x.LowDiskSpaceThresholdMB = 0
			} else {
				x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
			}
		case "volumeStatsAggPeriod":
			if r.TryDecodeAsNil() {
				x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv527 := &x.VolumeStatsAggPeriod
				yym528 := z.DecBinary()
				_ = yym528
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv527) {
				} else if !yym528 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv527)
				} else {
					z.DecFallback(yyv527, false)
				}
			}
		case "networkPluginName":
			if r.TryDecodeAsNil() {
				x.NetworkPluginName = ""
			} else {
				x.NetworkPluginName = string(r.DecodeString())
			}
		case "networkPluginMTU":
			if r.TryDecodeAsNil() {
				x.NetworkPluginMTU = 0
			} else {
				x.NetworkPluginMTU = int32(r.DecodeInt(32))
			}
		case "networkPluginDir":
			if r.TryDecodeAsNil() {
				x.NetworkPluginDir = ""
			} else {
				x.NetworkPluginDir = string(r.DecodeString())
			}
		case "volumePluginDir":
			if r.TryDecodeAsNil() {
				x.VolumePluginDir = ""
			} else {
				x.VolumePluginDir = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "kubeletCgroups":
			if r.TryDecodeAsNil() {
				x.KubeletCgroups = ""
			} else {
				x.KubeletCgroups = string(r.DecodeString())
			}
		case "CgroupsPerQOS":
			if r.TryDecodeAsNil() {
				x.CgroupsPerQOS = false
			} else {
				x.CgroupsPerQOS = bool(r.DecodeBool())
			}
		case "runtimeCgroups":
			if r.TryDecodeAsNil() {
				x.RuntimeCgroups = ""
			} else {
				x.RuntimeCgroups = string(r.DecodeString())
			}
		case "systemCgroups":
			if r.TryDecodeAsNil() {
				x.SystemCgroups = ""
			} else {
				x.SystemCgroups = string(r.DecodeString())
			}
		case "cgroupRoot":
			if r.TryDecodeAsNil() {
				x.CgroupRoot = ""
			} else {
				x.CgroupRoot = string(r.DecodeString())
			}
		case "containerRuntime":
			if r.TryDecodeAsNil() {
				x.ContainerRuntime = ""
			} else {
				x.ContainerRuntime = string(r.DecodeString())
			}
		case "remoteRuntimeEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteRuntimeEndpoint = ""
			} else {
				x.RemoteRuntimeEndpoint = string(r.DecodeString())
			}
		case "remoteImageEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteImageEndpoint = ""
			} else {
				x.RemoteImageEndpoint = string(r.DecodeString())
			}
		case "runtimeRequestTimeout":
			if r.TryDecodeAsNil() {
				x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv543 := &x.RuntimeRequestTimeout
				yym544 := z.DecBinary()
				_ = yym544
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv543) {
				} else if !yym544 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv543)
				} else {
					z.DecFallback(yyv543, false)
				}
			}
		case "rktPath":
			if r.TryDecodeAsNil() {
				x.RktPath = ""
			} else {
				x.RktPath = string(r.DecodeString())
			}
		case "rktAPIEndpoint":
			if r.TryDecodeAsNil() {
				x.RktAPIEndpoint = ""
			} else {
				x.RktAPIEndpoint = string(r.DecodeString())
			}
		case "rktStage1Image":
			if r.TryDecodeAsNil() {
				x.RktStage1Image = ""
			} else {
				x.RktStage1Image = string(r.DecodeString())
			}
		case "lockFilePath":
			if r.TryDecodeAsNil() {
				x.LockFilePath = ""
			} else {
				x.LockFilePath = string(r.DecodeString())
			}
		case "exitOnLockContention":
			if r.TryDecodeAsNil() {
				x.ExitOnLockContention = false
			} else {
				x.ExitOnLockContention = bool(r.DecodeBool())
			}
		case "configureCbr0":
			if r.TryDecodeAsNil() {
				x.ConfigureCBR0 = false
			} else {
				x.ConfigureCBR0 = bool(r.DecodeBool())
			}
		case "hairpinMode":
			if r.TryDecodeAsNil() {
				x.HairpinMode = ""
			} else {
				x.HairpinMode = string(r.DecodeString())
			}
		case "babysitDaemons":
			if r.TryDecodeAsNil() {
				x.BabysitDaemons = false
			} else {
				x.BabysitDaemons = bool(r.DecodeBool())
			}
		case "maxPods":
			if r.TryDecodeAsNil() {
				x.MaxPods = 0
			} else {
				x.MaxPods = int32(r.DecodeInt(32))
			}
		case "nvidiaGPUs":
			if r.TryDecodeAsNil() {
				x.NvidiaGPUs = 0
			} else {
				x.NvidiaGPUs = int32(r.DecodeInt(32))
			}
		case "dockerExecHandlerName":
			if r.TryDecodeAsNil() {
				x.DockerExecHandlerName = ""
			} else {
				x.DockerExecHandlerName = string(r.DecodeString())
			}
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "resolvConf":
			if r.TryDecodeAsNil() {
				x.ResolverConfig = ""
			} else {
				x.ResolverConfig = string(r.DecodeString())
			}
		case "cpuCFSQuota":
			if r.TryDecodeAsNil() {
				x.CPUCFSQuota = false
			} else {
				x.CPUCFSQuota = bool(r.DecodeBool())
			}
		case "containerized":
			if r.TryDecodeAsNil() {
				x.Containerized = false
			} else {
				x.Containerized = bool(r.DecodeBool())
			}
		case "maxOpenFiles":
			if r.TryDecodeAsNil() {
				x.MaxOpenFiles = 0
			} else {
				x.MaxOpenFiles = int64(r.DecodeInt(64))
			}
		case "reconcileCIDR":
			if r.TryDecodeAsNil() {
				x.ReconcileCIDR = false
			} else {
				x.ReconcileCIDR = bool(r.DecodeBool())
			}
		case "registerSchedulable":
			if r.TryDecodeAsNil() {
				x.RegisterSchedulable = false
			} else {
				x.RegisterSchedulable = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = int32(r.DecodeInt(32))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "serializeImagePulls":
			if r.TryDecodeAsNil() {
				x.SerializeImagePulls = false
			} else {
				x.SerializeImagePulls = bool(r.DecodeBool())
			}
		case "experimentalFlannelOverlay":
			if r.TryDecodeAsNil() {
				x.ExperimentalFlannelOverlay = false
			} else {
				x.ExperimentalFlannelOverlay = bool(r.DecodeBool())
			}
		case "outOfDiskTransitionFrequency":
			if r.TryDecodeAsNil() {
				x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv568 := &x.OutOfDiskTransitionFrequency
				yym569 := z.DecBinary()
				_ = yym569
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv568) {
				} else if !yym569 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv568)
				} else {
					z.DecFallback(yyv568, false)
				}
			}
		case "nodeIP":
			if r.TryDecodeAsNil() {
				x.NodeIP = ""
			} else {
				x.NodeIP = string(r.DecodeString())
			}
		case "nodeLabels":
			if r.TryDecodeAsNil() {
				x.NodeLabels = nil
			} else {
				yyv571 := &x.NodeLabels
				yym572 := z.DecBinary()
				_ = yym572
				if false {
				} else {
					z.F.DecMapStringStringX(yyv571, false, d)
				}
			}
		case "nonMasqueradeCIDR":
			if r.TryDecodeAsNil() {
				x.NonMasqueradeCIDR = ""
			} else {
				x.NonMasqueradeCIDR = string(r.DecodeString())
			}
		case "enableCustomMetrics":
			if r.TryDecodeAsNil() {
				x.EnableCustomMetrics = false
			} else {
				x.EnableCustomMetrics = bool(r.DecodeBool())
			}
		case "evictionHard":
			if r.TryDecodeAsNil() {
				x.EvictionHard = ""
			} else {
				x.EvictionHard = string(r.DecodeString())
			}
		case "evictionSoft":
			if r.TryDecodeAsNil() {
				x.EvictionSoft = ""
			} else {
				x.EvictionSoft = string(r.DecodeString())
			}
		case "evictionSoftGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionSoftGracePeriod = ""
			} else {
				x.EvictionSoftGracePeriod = string(r.DecodeString())
			}
		case "evictionPressureTransitionPeriod":
			if r.TryDecodeAsNil() {
				x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv578 := &x.EvictionPressureTransitionPeriod
				yym579 := z.DecBinary()
				_ = yym579
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv578) {
				} else if !yym579 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv578)
				} else {
					z.DecFallback(yyv578, false)
				}
			}
		case "evictionMaxPodGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionMaxPodGracePeriod = 0
			} else {
				x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
			}
		case "evictionMinimumReclaim":
			if r.TryDecodeAsNil() {
				x.EvictionMinimumReclaim = ""
			} else {
				x.EvictionMinimumReclaim = string(r.DecodeString())
			}
		case "podsPerCore":
			if r.TryDecodeAsNil() {
				x.PodsPerCore = 0
			} else {
				x.PodsPerCore = int32(r.DecodeInt(32))
			}
		case "enableControllerAttachDetach":
			if r.TryDecodeAsNil() {
				x.EnableControllerAttachDetach = false
			} else {
				x.EnableControllerAttachDetach = bool(r.DecodeBool())
			}
		case "systemReserved":
			if r.TryDecodeAsNil() {
				x.SystemReserved = nil
			} else {
				yyv584 := &x.SystemReserved
				yym585 := z.DecBinary()
				_ = yym585
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv584) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv584), d)
				}
			}
		case "kubeReserved":
			if r.TryDecodeAsNil() {
				x.KubeReserved = nil
			} else {
				yyv586 := &x.KubeReserved
				yym587 := z.DecBinary()
				_ = yym587
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv586) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv586), d)
				}
			}
		case "protectKernelDefaults":
			if r.TryDecodeAsNil() {
				x.ProtectKernelDefaults = false
			} else {
				x.ProtectKernelDefaults = bool(r.DecodeBool())
			}
		case "makeIPTablesUtilChains":
			if r.TryDecodeAsNil() {
				x.MakeIPTablesUtilChains = false
			} else {
				x.MakeIPTablesUtilChains = bool(r.DecodeBool())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				x.IPTablesMasqueradeBit = 0
			} else {
				x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
			}
		case "iptablesDropBit":
			if r.TryDecodeAsNil() {
				x.IPTablesDropBit = 0
			} else {
				x.IPTablesDropBit = int32(r.DecodeInt(32))
			}
		case "experimentalAllowedUnsafeSysctls":
			if r.TryDecodeAsNil() {
				x.AllowedUnsafeSysctls = nil
			} else {
				yyv592 := &x.AllowedUnsafeSysctls
				yym593 := z.DecBinary()
				_ = yym593
				if false {
				} else {
					z.F.DecSliceStringX(yyv592, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys470)
		} // end switch yys470
	} // end for yyj470
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj594 int
	var yyb594 bool
	var yyhl594 bool = l >= 0
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodManifestPath = ""
	} else {
		x.PodManifestPath = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SyncFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv598 := &x.SyncFrequency
		yym599 := z.DecBinary()
		_ = yym599
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv598) {
		} else if !yym599 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv598)
		} else {
			z.DecFallback(yyv598, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FileCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv600 := &x.FileCheckFrequency
		yym601 := z.DecBinary()
		_ = yym601
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv600) {
		} else if !yym601 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv600)
		} else {
			z.DecFallback(yyv600, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv602 := &x.HTTPCheckFrequency
		yym603 := z.DecBinary()
		_ = yym603
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv602) {
		} else if !yym603 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv602)
		} else {
			z.DecFallback(yyv602, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURL = ""
	} else {
		x.ManifestURL = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURLHeader = ""
	} else {
		x.ManifestURLHeader = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableServer = false
	} else {
		x.EnableServer = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyPort = 0
	} else {
		x.ReadOnlyPort = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSCertFile = ""
	} else {
		x.TLSCertFile = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSPrivateKeyFile = ""
	} else {
		x.TLSPrivateKeyFile = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CertDirectory = ""
	} else {
		x.CertDirectory = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodInfraContainerImage = ""
	} else {
		x.PodInfraContainerImage = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerEndpoint = ""
	} else {
		x.DockerEndpoint = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootDirectory = ""
	} else {
		x.RootDirectory = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SeccompProfileRoot = ""
	} else {
		x.SeccompProfileRoot = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowPrivileged = false
	} else {
		x.AllowPrivileged = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetworkSources = nil
	} else {
		yyv619 := &x.HostNetworkSources
		yym620 := z.DecBinary()
		_ = yym620
		if false {
		} else {
			z.F.DecSliceStringX(yyv619, false, d)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPIDSources = nil
	} else {
		yyv621 := &x.HostPIDSources
		yym622 := z.DecBinary()
		_ = yym622
		if false {
		} else {
			z.F.DecSliceStringX(yyv621, false, d)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPCSources = nil
	} else {
		yyv623 := &x.HostIPCSources
		yym624 := z.DecBinary()
		_ = yym624
		if false {
		} else {
			z.F.DecSliceStringX(yyv623, false, d)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryPullQPS = 0
	} else {
		x.RegistryPullQPS = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryBurst = 0
	} else {
		x.RegistryBurst = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventRecordQPS = 0
	} else {
		x.EventRecordQPS = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventBurst = 0
	} else {
		x.EventBurst = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDebuggingHandlers = false
	} else {
		x.EnableDebuggingHandlers = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv630 := &x.MinimumGCAge
		yym631 := z.DecBinary()
		_ = yym631
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv630) {
		} else if !yym631 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv630)
		} else {
			z.DecFallback(yyv630, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPerPodContainerCount = 0
	} else {
		x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxContainerCount = 0
	} else {
		x.MaxContainerCount = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CAdvisorPort = 0
	} else {
		x.CAdvisorPort = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OOMScoreAdj = 0
	} else {
		x.OOMScoreAdj = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterNode = false
	} else {
		x.RegisterNode = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDomain = ""
	} else {
		x.ClusterDomain = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasterServiceNamespace = ""
	} else {
		x.MasterServiceNamespace = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDNS = ""
	} else {
		x.ClusterDNS = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv642 := &x.StreamingConnectionIdleTimeout
		yym643 := z.DecBinary()
		_ = yym643
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv642) {
		} else if !yym643 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv642)
		} else {
			z.DecFallback(yyv642, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv644 := &x.NodeStatusUpdateFrequency
		yym645 := z.DecBinary()
		_ = yym645
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv644) {
		} else if !yym645 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv644)
		} else {
			z.DecFallback(yyv644, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv646 := &x.ImageMinimumGCAge
		yym647 := z.DecBinary()
		_ = yym647
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv646) {
		} else if !yym647 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv646)
		} else {
			z.DecFallback(yyv646, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCHighThresholdPercent = 0
	} else {
		x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCLowThresholdPercent = 0
	} else {
		x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LowDiskSpaceThresholdMB = 0
	} else {
		x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv651 := &x.VolumeStatsAggPeriod
		yym652 := z.DecBinary()
		_ = yym652
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv651) {
		} else if !yym652 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv651)
		} else {
			z.DecFallback(yyv651, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginName = ""
	} else {
		x.NetworkPluginName = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginMTU = 0
	} else {
		x.NetworkPluginMTU = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginDir = ""
	} else {
		x.NetworkPluginDir = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePluginDir = ""
	} else {
		x.VolumePluginDir = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletCgroups = ""
	} else {
		x.KubeletCgroups = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupsPerQOS = false
	} else {
		x.CgroupsPerQOS = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeCgroups = ""
	} else {
		x.RuntimeCgroups = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemCgroups = ""
	} else {
		x.SystemCgroups = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupRoot = ""
	} else {
		x.CgroupRoot = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntime = ""
	} else {
		x.ContainerRuntime = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteRuntimeEndpoint = ""
	} else {
		x.RemoteRuntimeEndpoint = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteImageEndpoint = ""
	} else {
		x.RemoteImageEndpoint = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv667 := &x.RuntimeRequestTimeout
		yym668 := z.DecBinary()
		_ = yym668
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv667) {
		} else if !yym668 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv667)
		} else {
			z.DecFallback(yyv667, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktPath = ""
	} else {
		x.RktPath = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktAPIEndpoint = ""
	} else {
		x.RktAPIEndpoint = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktStage1Image = ""
	} else {
		x.RktStage1Image = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LockFilePath = ""
	} else {
		x.LockFilePath = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitOnLockContention = false
	} else {
		x.ExitOnLockContention = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCBR0 = false
	} else {
		x.ConfigureCBR0 = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HairpinMode = ""
	} else {
		x.HairpinMode = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BabysitDaemons = false
	} else {
		x.BabysitDaemons = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPods = 0
	} else {
		x.MaxPods = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NvidiaGPUs = 0
	} else {
		x.NvidiaGPUs = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerExecHandlerName = ""
	} else {
		x.DockerExecHandlerName = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResolverConfig = ""
	} else {
		x.ResolverConfig = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CPUCFSQuota = false
	} else {
		x.CPUCFSQuota = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containerized = false
	} else {
		x.Containerized = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxOpenFiles = 0
	} else {
		x.MaxOpenFiles = int64(r.DecodeInt(64))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReconcileCIDR = false
	} else {
		x.ReconcileCIDR = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterSchedulable = false
	} else {
		x.RegisterSchedulable = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SerializeImagePulls = false
	} else {
		x.SerializeImagePulls = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalFlannelOverlay = false
	} else {
		x.ExperimentalFlannelOverlay = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv692 := &x.OutOfDiskTransitionFrequency
		yym693 := z.DecBinary()
		_ = yym693
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv692) {
		} else if !yym693 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv692)
		} else {
			z.DecFallback(yyv692, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeIP = ""
	} else {
		x.NodeIP = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeLabels = nil
	} else {
		yyv695 := &x.NodeLabels
		yym696 := z.DecBinary()
		_ = yym696
		if false {
		} else {
			z.F.DecMapStringStringX(yyv695, false, d)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonMasqueradeCIDR = ""
	} else {
		x.NonMasqueradeCIDR = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCustomMetrics = false
	} else {
		x.EnableCustomMetrics = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionHard = ""
	} else {
		x.EvictionHard = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoft = ""
	} else {
		x.EvictionSoft = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoftGracePeriod = ""
	} else {
		x.EvictionSoftGracePeriod = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv702 := &x.EvictionPressureTransitionPeriod
		yym703 := z.DecBinary()
		_ = yym703
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv702) {
		} else if !yym703 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv702)
		} else {
			z.DecFallback(yyv702, false)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMaxPodGracePeriod = 0
	} else {
		x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMinimumReclaim = ""
	} else {
		x.EvictionMinimumReclaim = string(r.DecodeString())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodsPerCore = 0
	} else {
		x.PodsPerCore = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableControllerAttachDetach = false
	} else {
		x.EnableControllerAttachDetach = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemReserved = nil
	} else {
		yyv708 := &x.SystemReserved
		yym709 := z.DecBinary()
		_ = yym709
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv708) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv708), d)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeReserved = nil
	} else {
		yyv710 := &x.KubeReserved
		yym711 := z.DecBinary()
		_ = yym711
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv710) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv710), d)
		}
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProtectKernelDefaults = false
	} else {
		x.ProtectKernelDefaults = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MakeIPTablesUtilChains = false
	} else {
		x.MakeIPTablesUtilChains = bool(r.DecodeBool())
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMasqueradeBit = 0
	} else {
		x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesDropBit = 0
	} else {
		x.IPTablesDropBit = int32(r.DecodeInt(32))
	}
	yyj594++
	if yyhl594 {
		yyb594 = yyj594 > l
	} else {
		yyb594 = r.CheckBreak()
	}
	if yyb594 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedUnsafeSysctls = nil
	} else {
		yyv716 := &x.AllowedUnsafeSysctls
		yym717 := z.DecBinary()
		_ = yym717
		if false {
		} else {
			z.F.DecSliceStringX(yyv716, false, d)
		}
	}
	for {
		yyj594++
		if yyhl594 {
			yyb594 = yyj594 > l
		} else {
			yyb594 = r.CheckBreak()
		}
		if yyb594 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj594-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeSchedulerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym718 := z.EncBinary()
		_ = yym718
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep719 := !z.EncBinary()
			yy2arr719 := z.EncBasicHandle().StructToArray
			var yyq719 [14]bool
			_, _, _ = yysep719, yyq719, yy2arr719
			const yyr719 bool = false
			yyq719[0] = x.Kind != ""
			yyq719[1] = x.APIVersion != ""
			var yynn719 int
			if yyr719 || yy2arr719 {
				r.EncodeArrayStart(14)
			} else {
				yynn719 = 12
				for _, b := range yyq719 {
					if b {
						yynn719++
					}
				}
				r.EncodeMapStart(yynn719)
				yynn719 = 0
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq719[0] {
					yym721 := z.EncBinary()
					_ = yym721
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq719[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym722 := z.EncBinary()
					_ = yym722
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq719[1] {
					yym724 := z.EncBinary()
					_ = yym724
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq719[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym725 := z.EncBinary()
					_ = yym725
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym727 := z.EncBinary()
				_ = yym727
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym728 := z.EncBinary()
				_ = yym728
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym730 := z.EncBinary()
				_ = yym730
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym731 := z.EncBinary()
				_ = yym731
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym733 := z.EncBinary()
				_ = yym733
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("algorithmProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym734 := z.EncBinary()
				_ = yym734
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym736 := z.EncBinary()
				_ = yym736
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("policyConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym737 := z.EncBinary()
				_ = yym737
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym739 := z.EncBinary()
				_ = yym739
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym740 := z.EncBinary()
				_ = yym740
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym742 := z.EncBinary()
				_ = yym742
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym743 := z.EncBinary()
				_ = yym743
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym745 := z.EncBinary()
				_ = yym745
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym746 := z.EncBinary()
				_ = yym746
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym748 := z.EncBinary()
				_ = yym748
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym749 := z.EncBinary()
				_ = yym749
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym751 := z.EncBinary()
				_ = yym751
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("schedulerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym752 := z.EncBinary()
				_ = yym752
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym754 := z.EncBinary()
				_ = yym754
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hardPodAffinitySymmetricWeight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym755 := z.EncBinary()
				_ = yym755
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym757 := z.EncBinary()
				_ = yym757
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("failureDomains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym758 := z.EncBinary()
				_ = yym758
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy760 := &x.LeaderElection
				yy760.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy761 := &x.LeaderElection
				yy761.CodecEncodeSelf(e)
			}
			if yyr719 || yy2arr719 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeSchedulerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym762 := z.DecBinary()
	_ = yym762
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct763 := r.ContainerType()
		if yyct763 == codecSelferValueTypeMap1234 {
			yyl763 := r.ReadMapStart()
			if yyl763 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl763, d)
			}
		} else if yyct763 == codecSelferValueTypeArray1234 {
			yyl763 := r.ReadArrayStart()
			if yyl763 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl763, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys764Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys764Slc
	var yyhl764 bool = l >= 0
	for yyj764 := 0; ; yyj764++ {
		if yyhl764 {
			if yyj764 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys764Slc = r.DecodeBytes(yys764Slc, true, true)
		yys764 := string(yys764Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys764 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "algorithmProvider":
			if r.TryDecodeAsNil() {
				x.AlgorithmProvider = ""
			} else {
				x.AlgorithmProvider = string(r.DecodeString())
			}
		case "policyConfigFile":
			if r.TryDecodeAsNil() {
				x.PolicyConfigFile = ""
			} else {
				x.PolicyConfigFile = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "schedulerName":
			if r.TryDecodeAsNil() {
				x.SchedulerName = ""
			} else {
				x.SchedulerName = string(r.DecodeString())
			}
		case "hardPodAffinitySymmetricWeight":
			if r.TryDecodeAsNil() {
				x.HardPodAffinitySymmetricWeight = 0
			} else {
				x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "failureDomains":
			if r.TryDecodeAsNil() {
				x.FailureDomains = ""
			} else {
				x.FailureDomains = string(r.DecodeString())
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv778 := &x.LeaderElection
				yyv778.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys764)
		} // end switch yys764
	} // end for yyj764
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj779 int
	var yyb779 bool
	var yyhl779 bool = l >= 0
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AlgorithmProvider = ""
	} else {
		x.AlgorithmProvider = string(r.DecodeString())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PolicyConfigFile = ""
	} else {
		x.PolicyConfigFile = string(r.DecodeString())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SchedulerName = ""
	} else {
		x.SchedulerName = string(r.DecodeString())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HardPodAffinitySymmetricWeight = 0
	} else {
		x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureDomains = ""
	} else {
		x.FailureDomains = string(r.DecodeString())
	}
	yyj779++
	if yyhl779 {
		yyb779 = yyj779 > l
	} else {
		yyb779 = r.CheckBreak()
	}
	if yyb779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv793 := &x.LeaderElection
		yyv793.CodecDecodeSelf(d)
	}
	for {
		yyj779++
		if yyhl779 {
			yyb779 = yyj779 > l
		} else {
			yyb779 = r.CheckBreak()
		}
		if yyb779 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj779-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LeaderElectionConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym794 := z.EncBinary()
		_ = yym794
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep795 := !z.EncBinary()
			yy2arr795 := z.EncBasicHandle().StructToArray
			var yyq795 [4]bool
			_, _, _ = yysep795, yyq795, yy2arr795
			const yyr795 bool = false
			var yynn795 int
			if yyr795 || yy2arr795 {
				r.EncodeArrayStart(4)
			} else {
				yynn795 = 4
				for _, b := range yyq795 {
					if b {
						yynn795++
					}
				}
				r.EncodeMapStart(yynn795)
				yynn795 = 0
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym797 := z.EncBinary()
				_ = yym797
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym798 := z.EncBinary()
				_ = yym798
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy800 := &x.LeaseDuration
				yym801 := z.EncBinary()
				_ = yym801
				if false {
				} else if z.HasExtensions() && z.EncExt(yy800) {
				} else if !yym801 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy800)
				} else {
					z.EncFallback(yy800)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaseDuration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy802 := &x.LeaseDuration
				yym803 := z.EncBinary()
				_ = yym803
				if false {
				} else if z.HasExtensions() && z.EncExt(yy802) {
				} else if !yym803 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy802)
				} else {
					z.EncFallback(yy802)
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy805 := &x.RenewDeadline
				yym806 := z.EncBinary()
				_ = yym806
				if false {
				} else if z.HasExtensions() && z.EncExt(yy805) {
				} else if !yym806 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy805)
				} else {
					z.EncFallback(yy805)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("renewDeadline"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy807 := &x.RenewDeadline
				yym808 := z.EncBinary()
				_ = yym808
				if false {
				} else if z.HasExtensions() && z.EncExt(yy807) {
				} else if !yym808 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy807)
				} else {
					z.EncFallback(yy807)
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy810 := &x.RetryPeriod
				yym811 := z.EncBinary()
				_ = yym811
				if false {
				} else if z.HasExtensions() && z.EncExt(yy810) {
				} else if !yym811 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy810)
				} else {
					z.EncFallback(yy810)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("retryPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy812 := &x.RetryPeriod
				yym813 := z.EncBinary()
				_ = yym813
				if false {
				} else if z.HasExtensions() && z.EncExt(yy812) {
				} else if !yym813 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy812)
				} else {
					z.EncFallback(yy812)
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LeaderElectionConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym814 := z.DecBinary()
	_ = yym814
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct815 := r.ContainerType()
		if yyct815 == codecSelferValueTypeMap1234 {
			yyl815 := r.ReadMapStart()
			if yyl815 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl815, d)
			}
		} else if yyct815 == codecSelferValueTypeArray1234 {
			yyl815 := r.ReadArrayStart()
			if yyl815 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl815, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys816Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys816Slc
	var yyhl816 bool = l >= 0
	for yyj816 := 0; ; yyj816++ {
		if yyhl816 {
			if yyj816 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys816Slc = r.DecodeBytes(yys816Slc, true, true)
		yys816 := string(yys816Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys816 {
		case "leaderElect":
			if r.TryDecodeAsNil() {
				x.LeaderElect = false
			} else {
				x.LeaderElect = bool(r.DecodeBool())
			}
		case "leaseDuration":
			if r.TryDecodeAsNil() {
				x.LeaseDuration = pkg1_unversioned.Duration{}
			} else {
				yyv818 := &x.LeaseDuration
				yym819 := z.DecBinary()
				_ = yym819
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv818) {
				} else if !yym819 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv818)
				} else {
					z.DecFallback(yyv818, false)
				}
			}
		case "renewDeadline":
			if r.TryDecodeAsNil() {
				x.RenewDeadline = pkg1_unversioned.Duration{}
			} else {
				yyv820 := &x.RenewDeadline
				yym821 := z.DecBinary()
				_ = yym821
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv820) {
				} else if !yym821 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv820)
				} else {
					z.DecFallback(yyv820, false)
				}
			}
		case "retryPeriod":
			if r.TryDecodeAsNil() {
				x.RetryPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv822 := &x.RetryPeriod
				yym823 := z.DecBinary()
				_ = yym823
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv822) {
				} else if !yym823 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv822)
				} else {
					z.DecFallback(yyv822, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys816)
		} // end switch yys816
	} // end for yyj816
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj824 int
	var yyb824 bool
	var yyhl824 bool = l >= 0
	yyj824++
	if yyhl824 {
		yyb824 = yyj824 > l
	} else {
		yyb824 = r.CheckBreak()
	}
	if yyb824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElect = false
	} else {
		x.LeaderElect = bool(r.DecodeBool())
	}
	yyj824++
	if yyhl824 {
		yyb824 = yyj824 > l
	} else {
		yyb824 = r.CheckBreak()
	}
	if yyb824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaseDuration = pkg1_unversioned.Duration{}
	} else {
		yyv826 := &x.LeaseDuration
		yym827 := z.DecBinary()
		_ = yym827
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv826) {
		} else if !yym827 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv826)
		} else {
			z.DecFallback(yyv826, false)
		}
	}
	yyj824++
	if yyhl824 {
		yyb824 = yyj824 > l
	} else {
		yyb824 = r.CheckBreak()
	}
	if yyb824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RenewDeadline = pkg1_unversioned.Duration{}
	} else {
		yyv828 := &x.RenewDeadline
		yym829 := z.DecBinary()
		_ = yym829
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv828) {
		} else if !yym829 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv828)
		} else {
			z.DecFallback(yyv828, false)
		}
	}
	yyj824++
	if yyhl824 {
		yyb824 = yyj824 > l
	} else {
		yyb824 = r.CheckBreak()
	}
	if yyb824 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RetryPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv830 := &x.RetryPeriod
		yym831 := z.DecBinary()
		_ = yym831
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv830) {
		} else if !yym831 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv830)
		} else {
			z.DecFallback(yyv830, false)
		}
	}
	for {
		yyj824++
		if yyhl824 {
			yyb824 = yyj824 > l
		} else {
			yyb824 = r.CheckBreak()
		}
		if yyb824 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj824-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeControllerManagerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym832 := z.EncBinary()
		_ = yym832
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep833 := !z.EncBinary()
			yy2arr833 := z.EncBasicHandle().StructToArray
			var yyq833 [59]bool
			_, _, _ = yysep833, yyq833, yy2arr833
			const yyr833 bool = false
			yyq833[0] = x.Kind != ""
			yyq833[1] = x.APIVersion != ""
			var yynn833 int
			if yyr833 || yy2arr833 {
				r.EncodeArrayStart(59)
			} else {
				yynn833 = 57
				for _, b := range yyq833 {
					if b {
						yynn833++
					}
				}
				r.EncodeMapStart(yynn833)
				yynn833 = 0
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq833[0] {
					yym835 := z.EncBinary()
					_ = yym835
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq833[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym836 := z.EncBinary()
					_ = yym836
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq833[1] {
					yym838 := z.EncBinary()
					_ = yym838
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq833[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym839 := z.EncBinary()
					_ = yym839
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym841 := z.EncBinary()
				_ = yym841
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym842 := z.EncBinary()
				_ = yym842
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym844 := z.EncBinary()
				_ = yym844
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym845 := z.EncBinary()
				_ = yym845
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym847 := z.EncBinary()
				_ = yym847
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym848 := z.EncBinary()
				_ = yym848
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym850 := z.EncBinary()
				_ = yym850
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym851 := z.EncBinary()
				_ = yym851
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym853 := z.EncBinary()
				_ = yym853
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentEndpointSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym854 := z.EncBinary()
				_ = yym854
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym856 := z.EncBinary()
				_ = yym856
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRSSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym857 := z.EncBinary()
				_ = yym857
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym859 := z.EncBinary()
				_ = yym859
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym860 := z.EncBinary()
				_ = yym860
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym862 := z.EncBinary()
				_ = yym862
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentServiceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym863 := z.EncBinary()
				_ = yym863
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym865 := z.EncBinary()
				_ = yym865
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentResourceQuotaSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym866 := z.EncBinary()
				_ = yym866
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym868 := z.EncBinary()
				_ = yym868
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDeploymentSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym869 := z.EncBinary()
				_ = yym869
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym871 := z.EncBinary()
				_ = yym871
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDaemonSetSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym872 := z.EncBinary()
				_ = yym872
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym874 := z.EncBinary()
				_ = yym874
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentJobSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym875 := z.EncBinary()
				_ = yym875
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym877 := z.EncBinary()
				_ = yym877
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentNamespaceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym878 := z.EncBinary()
				_ = yym878
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym880 := z.EncBinary()
				_ = yym880
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentSATokenSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym881 := z.EncBinary()
				_ = yym881
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym883 := z.EncBinary()
				_ = yym883
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRC"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym884 := z.EncBinary()
				_ = yym884
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym886 := z.EncBinary()
				_ = yym886
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym887 := z.EncBinary()
				_ = yym887
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym889 := z.EncBinary()
				_ = yym889
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForDaemonSet"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym890 := z.EncBinary()
				_ = yym890
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy892 := &x.ServiceSyncPeriod
				yym893 := z.EncBinary()
				_ = yym893
				if false {
				} else if z.HasExtensions() && z.EncExt(yy892) {
				} else if !yym893 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy892)
				} else {
					z.EncFallback(yy892)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy894 := &x.ServiceSyncPeriod
				yym895 := z.EncBinary()
				_ = yym895
				if false {
				} else if z.HasExtensions() && z.EncExt(yy894) {
				} else if !yym895 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy894)
				} else {
					z.EncFallback(yy894)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy897 := &x.NodeSyncPeriod
				yym898 := z.EncBinary()
				_ = yym898
				if false {
				} else if z.HasExtensions() && z.EncExt(yy897) {
				} else if !yym898 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy897)
				} else {
					z.EncFallback(yy897)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy899 := &x.NodeSyncPeriod
				yym900 := z.EncBinary()
				_ = yym900
				if false {
				} else if z.HasExtensions() && z.EncExt(yy899) {
				} else if !yym900 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy899)
				} else {
					z.EncFallback(yy899)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy902 := &x.ResourceQuotaSyncPeriod
				yym903 := z.EncBinary()
				_ = yym903
				if false {
				} else if z.HasExtensions() && z.EncExt(yy902) {
				} else if !yym903 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy902)
				} else {
					z.EncFallback(yy902)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceQuotaSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy904 := &x.ResourceQuotaSyncPeriod
				yym905 := z.EncBinary()
				_ = yym905
				if false {
				} else if z.HasExtensions() && z.EncExt(yy904) {
				} else if !yym905 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy904)
				} else {
					z.EncFallback(yy904)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy907 := &x.NamespaceSyncPeriod
				yym908 := z.EncBinary()
				_ = yym908
				if false {
				} else if z.HasExtensions() && z.EncExt(yy907) {
				} else if !yym908 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy907)
				} else {
					z.EncFallback(yy907)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy909 := &x.NamespaceSyncPeriod
				yym910 := z.EncBinary()
				_ = yym910
				if false {
				} else if z.HasExtensions() && z.EncExt(yy909) {
				} else if !yym910 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy909)
				} else {
					z.EncFallback(yy909)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy912 := &x.PVClaimBinderSyncPeriod
				yym913 := z.EncBinary()
				_ = yym913
				if false {
				} else if z.HasExtensions() && z.EncExt(yy912) {
				} else if !yym913 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy912)
				} else {
					z.EncFallback(yy912)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pvClaimBinderSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy914 := &x.PVClaimBinderSyncPeriod
				yym915 := z.EncBinary()
				_ = yym915
				if false {
				} else if z.HasExtensions() && z.EncExt(yy914) {
				} else if !yym915 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy914)
				} else {
					z.EncFallback(yy914)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy917 := &x.MinResyncPeriod
				yym918 := z.EncBinary()
				_ = yym918
				if false {
				} else if z.HasExtensions() && z.EncExt(yy917) {
				} else if !yym918 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy917)
				} else {
					z.EncFallback(yy917)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minResyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy919 := &x.MinResyncPeriod
				yym920 := z.EncBinary()
				_ = yym920
				if false {
				} else if z.HasExtensions() && z.EncExt(yy919) {
				} else if !yym920 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy919)
				} else {
					z.EncFallback(yy919)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym922 := z.EncBinary()
				_ = yym922
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("terminatedPodGCThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym923 := z.EncBinary()
				_ = yym923
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy925 := &x.HorizontalPodAutoscalerSyncPeriod
				yym926 := z.EncBinary()
				_ = yym926
				if false {
				} else if z.HasExtensions() && z.EncExt(yy925) {
				} else if !yym926 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy925)
				} else {
					z.EncFallback(yy925)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("horizontalPodAutoscalerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy927 := &x.HorizontalPodAutoscalerSyncPeriod
				yym928 := z.EncBinary()
				_ = yym928
				if false {
				} else if z.HasExtensions() && z.EncExt(yy927) {
				} else if !yym928 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy927)
				} else {
					z.EncFallback(yy927)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy930 := &x.DeploymentControllerSyncPeriod
				yym931 := z.EncBinary()
				_ = yym931
				if false {
				} else if z.HasExtensions() && z.EncExt(yy930) {
				} else if !yym931 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy930)
				} else {
					z.EncFallback(yy930)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deploymentControllerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy932 := &x.DeploymentControllerSyncPeriod
				yym933 := z.EncBinary()
				_ = yym933
				if false {
				} else if z.HasExtensions() && z.EncExt(yy932) {
				} else if !yym933 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy932)
				} else {
					z.EncFallback(yy932)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy935 := &x.PodEvictionTimeout
				yym936 := z.EncBinary()
				_ = yym936
				if false {
				} else if z.HasExtensions() && z.EncExt(yy935) {
				} else if !yym936 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy935)
				} else {
					z.EncFallback(yy935)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podEvictionTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy937 := &x.PodEvictionTimeout
				yym938 := z.EncBinary()
				_ = yym938
				if false {
				} else if z.HasExtensions() && z.EncExt(yy937) {
				} else if !yym938 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy937)
				} else {
					z.EncFallback(yy937)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym940 := z.EncBinary()
				_ = yym940
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsQps"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym941 := z.EncBinary()
				_ = yym941
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym943 := z.EncBinary()
				_ = yym943
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym944 := z.EncBinary()
				_ = yym944
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy946 := &x.NodeMonitorGracePeriod
				yym947 := z.EncBinary()
				_ = yym947
				if false {
				} else if z.HasExtensions() && z.EncExt(yy946) {
				} else if !yym947 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy946)
				} else {
					z.EncFallback(yy946)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy948 := &x.NodeMonitorGracePeriod
				yym949 := z.EncBinary()
				_ = yym949
				if false {
				} else if z.HasExtensions() && z.EncExt(yy948) {
				} else if !yym949 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy948)
				} else {
					z.EncFallback(yy948)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym951 := z.EncBinary()
				_ = yym951
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerRetryCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym952 := z.EncBinary()
				_ = yym952
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy954 := &x.NodeStartupGracePeriod
				yym955 := z.EncBinary()
				_ = yym955
				if false {
				} else if z.HasExtensions() && z.EncExt(yy954) {
				} else if !yym955 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy954)
				} else {
					z.EncFallback(yy954)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStartupGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy956 := &x.NodeStartupGracePeriod
				yym957 := z.EncBinary()
				_ = yym957
				if false {
				} else if z.HasExtensions() && z.EncExt(yy956) {
				} else if !yym957 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy956)
				} else {
					z.EncFallback(yy956)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy959 := &x.NodeMonitorPeriod
				yym960 := z.EncBinary()
				_ = yym960
				if false {
				} else if z.HasExtensions() && z.EncExt(yy959) {
				} else if !yym960 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy959)
				} else {
					z.EncFallback(yy959)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy961 := &x.NodeMonitorPeriod
				yym962 := z.EncBinary()
				_ = yym962
				if false {
				} else if z.HasExtensions() && z.EncExt(yy961) {
				} else if !yym962 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy961)
				} else {
					z.EncFallback(yy961)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym964 := z.EncBinary()
				_ = yym964
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym965 := z.EncBinary()
				_ = yym965
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym967 := z.EncBinary()
				_ = yym967
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym968 := z.EncBinary()
				_ = yym968
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym970 := z.EncBinary()
				_ = yym970
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym971 := z.EncBinary()
				_ = yym971
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym973 := z.EncBinary()
				_ = yym973
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("approveAllKubeletCSRsForGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym974 := z.EncBinary()
				_ = yym974
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym976 := z.EncBinary()
				_ = yym976
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym977 := z.EncBinary()
				_ = yym977
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym979 := z.EncBinary()
				_ = yym979
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym980 := z.EncBinary()
				_ = yym980
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym982 := z.EncBinary()
				_ = yym982
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym983 := z.EncBinary()
				_ = yym983
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym985 := z.EncBinary()
				_ = yym985
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym986 := z.EncBinary()
				_ = yym986
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym988 := z.EncBinary()
				_ = yym988
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeCIDRMaskSize"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym989 := z.EncBinary()
				_ = yym989
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym991 := z.EncBinary()
				_ = yym991
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allocateNodeCIDRs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym992 := z.EncBinary()
				_ = yym992
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym994 := z.EncBinary()
				_ = yym994
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCloudRoutes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym995 := z.EncBinary()
				_ = yym995
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym997 := z.EncBinary()
				_ = yym997
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym998 := z.EncBinary()
				_ = yym998
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1000 := z.EncBinary()
				_ = yym1000
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1001 := z.EncBinary()
				_ = yym1001
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1003 := z.EncBinary()
				_ = yym1003
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1004 := z.EncBinary()
				_ = yym1004
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1006 := z.EncBinary()
				_ = yym1006
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1007 := z.EncBinary()
				_ = yym1007
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1009 := &x.LeaderElection
				yy1009.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1010 := &x.LeaderElection
				yy1010.CodecEncodeSelf(e)
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1012 := &x.VolumeConfiguration
				yy1012.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1013 := &x.VolumeConfiguration
				yy1013.CodecEncodeSelf(e)
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1015 := &x.ControllerStartInterval
				yym1016 := z.EncBinary()
				_ = yym1016
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1015) {
				} else if !yym1016 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1015)
				} else {
					z.EncFallback(yy1015)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("controllerStartInterval"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1017 := &x.ControllerStartInterval
				yym1018 := z.EncBinary()
				_ = yym1018
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1017) {
				} else if !yym1018 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1017)
				} else {
					z.EncFallback(yy1017)
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1020 := z.EncBinary()
				_ = yym1020
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableGarbageCollector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1021 := z.EncBinary()
				_ = yym1021
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1023 := z.EncBinary()
				_ = yym1023
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentGCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1024 := z.EncBinary()
				_ = yym1024
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1026 := z.EncBinary()
				_ = yym1026
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1027 := z.EncBinary()
				_ = yym1027
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1029 := z.EncBinary()
				_ = yym1029
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secondaryNodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1030 := z.EncBinary()
				_ = yym1030
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1032 := z.EncBinary()
				_ = yym1032
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("largeClusterSizeThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1033 := z.EncBinary()
				_ = yym1033
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1035 := z.EncBinary()
				_ = yym1035
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("unhealthyZoneThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1036 := z.EncBinary()
				_ = yym1036
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			}
			if yyr833 || yy2arr833 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeControllerManagerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1037 := z.DecBinary()
	_ = yym1037
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1038 := r.ContainerType()
		if yyct1038 == codecSelferValueTypeMap1234 {
			yyl1038 := r.ReadMapStart()
			if yyl1038 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1038, d)
			}
		} else if yyct1038 == codecSelferValueTypeArray1234 {
			yyl1038 := r.ReadArrayStart()
			if yyl1038 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1038, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1039Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1039Slc
	var yyhl1039 bool = l >= 0
	for yyj1039 := 0; ; yyj1039++ {
		if yyhl1039 {
			if yyj1039 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1039Slc = r.DecodeBytes(yys1039Slc, true, true)
		yys1039 := string(yys1039Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1039 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "concurrentEndpointSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentEndpointSyncs = 0
			} else {
				x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRSSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRSSyncs = 0
			} else {
				x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRCSyncs = 0
			} else {
				x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentServiceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentServiceSyncs = 0
			} else {
				x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentResourceQuotaSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentResourceQuotaSyncs = 0
			} else {
				x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDeploymentSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDeploymentSyncs = 0
			} else {
				x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDaemonSetSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDaemonSetSyncs = 0
			} else {
				x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentJobSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentJobSyncs = 0
			} else {
				x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentNamespaceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentNamespaceSyncs = 0
			} else {
				x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentSATokenSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentSATokenSyncs = 0
			} else {
				x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRC":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRC = 0
			} else {
				x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRS":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRS = 0
			} else {
				x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForDaemonSet":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForDaemonSet = 0
			} else {
				x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
			}
		case "serviceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1059 := &x.ServiceSyncPeriod
				yym1060 := z.DecBinary()
				_ = yym1060
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1059) {
				} else if !yym1060 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1059)
				} else {
					z.DecFallback(yyv1059, false)
				}
			}
		case "nodeSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NodeSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1061 := &x.NodeSyncPeriod
				yym1062 := z.DecBinary()
				_ = yym1062
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1061) {
				} else if !yym1062 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1061)
				} else {
					z.DecFallback(yyv1061, false)
				}
			}
		case "resourceQuotaSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1063 := &x.ResourceQuotaSyncPeriod
				yym1064 := z.DecBinary()
				_ = yym1064
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1063) {
				} else if !yym1064 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1063)
				} else {
					z.DecFallback(yyv1063, false)
				}
			}
		case "namespaceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1065 := &x.NamespaceSyncPeriod
				yym1066 := z.DecBinary()
				_ = yym1066
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1065) {
				} else if !yym1066 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1065)
				} else {
					z.DecFallback(yyv1065, false)
				}
			}
		case "pvClaimBinderSyncPeriod":
			if r.TryDecodeAsNil() {
				x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1067 := &x.PVClaimBinderSyncPeriod
				yym1068 := z.DecBinary()
				_ = yym1068
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1067) {
				} else if !yym1068 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1067)
				} else {
					z.DecFallback(yyv1067, false)
				}
			}
		case "minResyncPeriod":
			if r.TryDecodeAsNil() {
				x.MinResyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1069 := &x.MinResyncPeriod
				yym1070 := z.DecBinary()
				_ = yym1070
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1069) {
				} else if !yym1070 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1069)
				} else {
					z.DecFallback(yyv1069, false)
				}
			}
		case "terminatedPodGCThreshold":
			if r.TryDecodeAsNil() {
				x.TerminatedPodGCThreshold = 0
			} else {
				x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
			}
		case "horizontalPodAutoscalerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1072 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1073 := z.DecBinary()
				_ = yym1073
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1072) {
				} else if !yym1073 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1072)
				} else {
					z.DecFallback(yyv1072, false)
				}
			}
		case "deploymentControllerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1074 := &x.DeploymentControllerSyncPeriod
				yym1075 := z.DecBinary()
				_ = yym1075
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1074) {
				} else if !yym1075 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1074)
				} else {
					z.DecFallback(yyv1074, false)
				}
			}
		case "podEvictionTimeout":
			if r.TryDecodeAsNil() {
				x.PodEvictionTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv1076 := &x.PodEvictionTimeout
				yym1077 := z.DecBinary()
				_ = yym1077
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1076) {
				} else if !yym1077 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1076)
				} else {
					z.DecFallback(yyv1076, false)
				}
			}
		case "deletingPodsQps":
			if r.TryDecodeAsNil() {
				x.DeletingPodsQps = 0
			} else {
				x.DeletingPodsQps = float32(r.DecodeFloat(true))
			}
		case "deletingPodsBurst":
			if r.TryDecodeAsNil() {
				x.DeletingPodsBurst = 0
			} else {
				x.DeletingPodsBurst = int32(r.DecodeInt(32))
			}
		case "nodeMonitorGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1080 := &x.NodeMonitorGracePeriod
				yym1081 := z.DecBinary()
				_ = yym1081
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1080) {
				} else if !yym1081 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1080)
				} else {
					z.DecFallback(yyv1080, false)
				}
			}
		case "registerRetryCount":
			if r.TryDecodeAsNil() {
				x.RegisterRetryCount = 0
			} else {
				x.RegisterRetryCount = int32(r.DecodeInt(32))
			}
		case "nodeStartupGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1083 := &x.NodeStartupGracePeriod
				yym1084 := z.DecBinary()
				_ = yym1084
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1083) {
				} else if !yym1084 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1083)
				} else {
					z.DecFallback(yyv1083, false)
				}
			}
		case "nodeMonitorPeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1085 := &x.NodeMonitorPeriod
				yym1086 := z.DecBinary()
				_ = yym1086
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1085) {
				} else if !yym1086 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1085)
				} else {
					z.DecFallback(yyv1085, false)
				}
			}
		case "serviceAccountKeyFile":
			if r.TryDecodeAsNil() {
				x.ServiceAccountKeyFile = ""
			} else {
				x.ServiceAccountKeyFile = string(r.DecodeString())
			}
		case "clusterSigningCertFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningCertFile = ""
			} else {
				x.ClusterSigningCertFile = string(r.DecodeString())
			}
		case "clusterSigningKeyFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningKeyFile = ""
			} else {
				x.ClusterSigningKeyFile = string(r.DecodeString())
			}
		case "approveAllKubeletCSRsForGroup":
			if r.TryDecodeAsNil() {
				x.ApproveAllKubeletCSRsForGroup = ""
			} else {
				x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "serviceCIDR":
			if r.TryDecodeAsNil() {
				x.ServiceCIDR = ""
			} else {
				x.ServiceCIDR = string(r.DecodeString())
			}
		case "nodeCIDRMaskSize":
			if r.TryDecodeAsNil() {
				x.NodeCIDRMaskSize = 0
			} else {
				x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
			}
		case "allocateNodeCIDRs":
			if r.TryDecodeAsNil() {
				x.AllocateNodeCIDRs = false
			} else {
				x.AllocateNodeCIDRs = bool(r.DecodeBool())
			}
		case "configureCloudRoutes":
			if r.TryDecodeAsNil() {
				x.ConfigureCloudRoutes = false
			} else {
				x.ConfigureCloudRoutes = bool(r.DecodeBool())
			}
		case "rootCAFile":
			if r.TryDecodeAsNil() {
				x.RootCAFile = ""
			} else {
				x.RootCAFile = string(r.DecodeString())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv1102 := &x.LeaderElection
				yyv1102.CodecDecodeSelf(d)
			}
		case "volumeConfiguration":
			if r.TryDecodeAsNil() {
				x.VolumeConfiguration = VolumeConfiguration{}
			} else {
				yyv1103 := &x.VolumeConfiguration
				yyv1103.CodecDecodeSelf(d)
			}
		case "controllerStartInterval":
			if r.TryDecodeAsNil() {
				x.ControllerStartInterval = pkg1_unversioned.Duration{}
			} else {
				yyv1104 := &x.ControllerStartInterval
				yym1105 := z.DecBinary()
				_ = yym1105
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1104) {
				} else if !yym1105 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1104)
				} else {
					z.DecFallback(yyv1104, false)
				}
			}
		case "enableGarbageCollector":
			if r.TryDecodeAsNil() {
				x.EnableGarbageCollector = false
			} else {
				x.EnableGarbageCollector = bool(r.DecodeBool())
			}
		case "concurrentGCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentGCSyncs = 0
			} else {
				x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
			}
		case "nodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.NodeEvictionRate = 0
			} else {
				x.NodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "secondaryNodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.SecondaryNodeEvictionRate = 0
			} else {
				x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "largeClusterSizeThreshold":
			if r.TryDecodeAsNil() {
				x.LargeClusterSizeThreshold = 0
			} else {
				x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
			}
		case "unhealthyZoneThreshold":
			if r.TryDecodeAsNil() {
				x.UnhealthyZoneThreshold = 0
			} else {
				x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1039)
		} // end switch yys1039
	} // end for yyj1039
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1112 int
	var yyb1112 bool
	var yyhl1112 bool = l >= 0
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentEndpointSyncs = 0
	} else {
		x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRSSyncs = 0
	} else {
		x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRCSyncs = 0
	} else {
		x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentServiceSyncs = 0
	} else {
		x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentResourceQuotaSyncs = 0
	} else {
		x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDeploymentSyncs = 0
	} else {
		x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDaemonSetSyncs = 0
	} else {
		x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentJobSyncs = 0
	} else {
		x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentNamespaceSyncs = 0
	} else {
		x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentSATokenSyncs = 0
	} else {
		x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRC = 0
	} else {
		x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRS = 0
	} else {
		x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForDaemonSet = 0
	} else {
		x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1132 := &x.ServiceSyncPeriod
		yym1133 := z.DecBinary()
		_ = yym1133
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1132) {
		} else if !yym1133 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1132)
		} else {
			z.DecFallback(yyv1132, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1134 := &x.NodeSyncPeriod
		yym1135 := z.DecBinary()
		_ = yym1135
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1134) {
		} else if !yym1135 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1134)
		} else {
			z.DecFallback(yyv1134, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1136 := &x.ResourceQuotaSyncPeriod
		yym1137 := z.DecBinary()
		_ = yym1137
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1136) {
		} else if !yym1137 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1136)
		} else {
			z.DecFallback(yyv1136, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1138 := &x.NamespaceSyncPeriod
		yym1139 := z.DecBinary()
		_ = yym1139
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1138) {
		} else if !yym1139 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1138)
		} else {
			z.DecFallback(yyv1138, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1140 := &x.PVClaimBinderSyncPeriod
		yym1141 := z.DecBinary()
		_ = yym1141
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1140) {
		} else if !yym1141 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1140)
		} else {
			z.DecFallback(yyv1140, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinResyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1142 := &x.MinResyncPeriod
		yym1143 := z.DecBinary()
		_ = yym1143
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1142) {
		} else if !yym1143 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1142)
		} else {
			z.DecFallback(yyv1142, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminatedPodGCThreshold = 0
	} else {
		x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1145 := &x.HorizontalPodAutoscalerSyncPeriod
		yym1146 := z.DecBinary()
		_ = yym1146
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1145) {
		} else if !yym1146 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1145)
		} else {
			z.DecFallback(yyv1145, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1147 := &x.DeploymentControllerSyncPeriod
		yym1148 := z.DecBinary()
		_ = yym1148
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1147) {
		} else if !yym1148 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1147)
		} else {
			z.DecFallback(yyv1147, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodEvictionTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv1149 := &x.PodEvictionTimeout
		yym1150 := z.DecBinary()
		_ = yym1150
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1149) {
		} else if !yym1150 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1149)
		} else {
			z.DecFallback(yyv1149, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsQps = 0
	} else {
		x.DeletingPodsQps = float32(r.DecodeFloat(true))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsBurst = 0
	} else {
		x.DeletingPodsBurst = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1153 := &x.NodeMonitorGracePeriod
		yym1154 := z.DecBinary()
		_ = yym1154
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1153) {
		} else if !yym1154 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1153)
		} else {
			z.DecFallback(yyv1153, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterRetryCount = 0
	} else {
		x.RegisterRetryCount = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1156 := &x.NodeStartupGracePeriod
		yym1157 := z.DecBinary()
		_ = yym1157
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1156) {
		} else if !yym1157 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1156)
		} else {
			z.DecFallback(yyv1156, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1158 := &x.NodeMonitorPeriod
		yym1159 := z.DecBinary()
		_ = yym1159
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1158) {
		} else if !yym1159 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1158)
		} else {
			z.DecFallback(yyv1158, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountKeyFile = ""
	} else {
		x.ServiceAccountKeyFile = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningCertFile = ""
	} else {
		x.ClusterSigningCertFile = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningKeyFile = ""
	} else {
		x.ClusterSigningKeyFile = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ApproveAllKubeletCSRsForGroup = ""
	} else {
		x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceCIDR = ""
	} else {
		x.ServiceCIDR = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeCIDRMaskSize = 0
	} else {
		x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllocateNodeCIDRs = false
	} else {
		x.AllocateNodeCIDRs = bool(r.DecodeBool())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCloudRoutes = false
	} else {
		x.ConfigureCloudRoutes = bool(r.DecodeBool())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootCAFile = ""
	} else {
		x.RootCAFile = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv1175 := &x.LeaderElection
		yyv1175.CodecDecodeSelf(d)
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeConfiguration = VolumeConfiguration{}
	} else {
		yyv1176 := &x.VolumeConfiguration
		yyv1176.CodecDecodeSelf(d)
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ControllerStartInterval = pkg1_unversioned.Duration{}
	} else {
		yyv1177 := &x.ControllerStartInterval
		yym1178 := z.DecBinary()
		_ = yym1178
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1177) {
		} else if !yym1178 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1177)
		} else {
			z.DecFallback(yyv1177, false)
		}
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableGarbageCollector = false
	} else {
		x.EnableGarbageCollector = bool(r.DecodeBool())
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentGCSyncs = 0
	} else {
		x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeEvictionRate = 0
	} else {
		x.NodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecondaryNodeEvictionRate = 0
	} else {
		x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LargeClusterSizeThreshold = 0
	} else {
		x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
	}
	yyj1112++
	if yyhl1112 {
		yyb1112 = yyj1112 > l
	} else {
		yyb1112 = r.CheckBreak()
	}
	if yyb1112 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnhealthyZoneThreshold = 0
	} else {
		x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
	}
	for {
		yyj1112++
		if yyhl1112 {
			yyb1112 = yyj1112 > l
		} else {
			yyb1112 = r.CheckBreak()
		}
		if yyb1112 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1112-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1185 := z.EncBinary()
		_ = yym1185
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1186 := !z.EncBinary()
			yy2arr1186 := z.EncBasicHandle().StructToArray
			var yyq1186 [4]bool
			_, _, _ = yysep1186, yyq1186, yy2arr1186
			const yyr1186 bool = false
			var yynn1186 int
			if yyr1186 || yy2arr1186 {
				r.EncodeArrayStart(4)
			} else {
				yynn1186 = 4
				for _, b := range yyq1186 {
					if b {
						yynn1186++
					}
				}
				r.EncodeMapStart(yynn1186)
				yynn1186 = 0
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1188 := z.EncBinary()
				_ = yym1188
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableHostPathProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1189 := z.EncBinary()
				_ = yym1189
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1191 := z.EncBinary()
				_ = yym1191
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDynamicProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1192 := z.EncBinary()
				_ = yym1192
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1194 := &x.PersistentVolumeRecyclerConfiguration
				yy1194.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("persitentVolumeRecyclerConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1195 := &x.PersistentVolumeRecyclerConfiguration
				yy1195.CodecEncodeSelf(e)
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1197 := z.EncBinary()
				_ = yym1197
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("flexVolumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1198 := z.EncBinary()
				_ = yym1198
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1199 := z.DecBinary()
	_ = yym1199
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1200 := r.ContainerType()
		if yyct1200 == codecSelferValueTypeMap1234 {
			yyl1200 := r.ReadMapStart()
			if yyl1200 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1200, d)
			}
		} else if yyct1200 == codecSelferValueTypeArray1234 {
			yyl1200 := r.ReadArrayStart()
			if yyl1200 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1200, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1201Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1201Slc
	var yyhl1201 bool = l >= 0
	for yyj1201 := 0; ; yyj1201++ {
		if yyhl1201 {
			if yyj1201 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1201Slc = r.DecodeBytes(yys1201Slc, true, true)
		yys1201 := string(yys1201Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1201 {
		case "enableHostPathProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableHostPathProvisioning = false
			} else {
				x.EnableHostPathProvisioning = bool(r.DecodeBool())
			}
		case "enableDynamicProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableDynamicProvisioning = false
			} else {
				x.EnableDynamicProvisioning = bool(r.DecodeBool())
			}
		case "persitentVolumeRecyclerConfiguration":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
			} else {
				yyv1204 := &x.PersistentVolumeRecyclerConfiguration
				yyv1204.CodecDecodeSelf(d)
			}
		case "flexVolumePluginDir":
			if r.TryDecodeAsNil() {
				x.FlexVolumePluginDir = ""
			} else {
				x.FlexVolumePluginDir = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1201)
		} // end switch yys1201
	} // end for yyj1201
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1206 int
	var yyb1206 bool
	var yyhl1206 bool = l >= 0
	yyj1206++
	if yyhl1206 {
		yyb1206 = yyj1206 > l
	} else {
		yyb1206 = r.CheckBreak()
	}
	if yyb1206 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableHostPathProvisioning = false
	} else {
		x.EnableHostPathProvisioning = bool(r.DecodeBool())
	}
	yyj1206++
	if yyhl1206 {
		yyb1206 = yyj1206 > l
	} else {
		yyb1206 = r.CheckBreak()
	}
	if yyb1206 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDynamicProvisioning = false
	} else {
		x.EnableDynamicProvisioning = bool(r.DecodeBool())
	}
	yyj1206++
	if yyhl1206 {
		yyb1206 = yyj1206 > l
	} else {
		yyb1206 = r.CheckBreak()
	}
	if yyb1206 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
	} else {
		yyv1209 := &x.PersistentVolumeRecyclerConfiguration
		yyv1209.CodecDecodeSelf(d)
	}
	yyj1206++
	if yyhl1206 {
		yyb1206 = yyj1206 > l
	} else {
		yyb1206 = r.CheckBreak()
	}
	if yyb1206 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FlexVolumePluginDir = ""
	} else {
		x.FlexVolumePluginDir = string(r.DecodeString())
	}
	for {
		yyj1206++
		if yyhl1206 {
			yyb1206 = yyj1206 > l
		} else {
			yyb1206 = r.CheckBreak()
		}
		if yyb1206 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1206-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1211 := z.EncBinary()
		_ = yym1211
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1212 := !z.EncBinary()
			yy2arr1212 := z.EncBasicHandle().StructToArray
			var yyq1212 [7]bool
			_, _, _ = yysep1212, yyq1212, yy2arr1212
			const yyr1212 bool = false
			var yynn1212 int
			if yyr1212 || yy2arr1212 {
				r.EncodeArrayStart(7)
			} else {
				yynn1212 = 7
				for _, b := range yyq1212 {
					if b {
						yynn1212++
					}
				}
				r.EncodeMapStart(yynn1212)
				yynn1212 = 0
			}
			if yyr1212 || yy2arr1212 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1214 := z.EncBinary()
				_ = yym1214
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maximumRetry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1215 := z.EncBinary()
				_ = yym1215
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			}
			if yyr1212 || yy2arr1212 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1217 := z.EncBinary()
				_ = yym1217
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1218 := z.EncBinary()
				_ = yym1218
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			}
			if yyr1212 || yy2arr1212 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1220 := z.EncBinary()
				_ = yym1220
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1221 := z.EncBinary()
				_ = yym1221
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			}
			if yyr1212 || yy2arr1212 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1223 := z.EncBinary()
				_ = yym1223
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1224 := z.EncBinary()
				_ = yym1224
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			}
			if yyr1212 || yy2arr1212 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1226 := z.EncBinary()
				_ = yym1226
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1227 := z.EncBinary()
				_ = yym1227
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			}
			if yyr1212 || yy2arr1212 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1229 := z.EncBinary()
				_ = yym1229
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1230 := z.EncBinary()
				_ = yym1230
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			}
			if yyr1212 || yy2arr1212 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1232 := z.EncBinary()
				_ = yym1232
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1233 := z.EncBinary()
				_ = yym1233
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			}
			if yyr1212 || yy2arr1212 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1234 := z.DecBinary()
	_ = yym1234
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1235 := r.ContainerType()
		if yyct1235 == codecSelferValueTypeMap1234 {
			yyl1235 := r.ReadMapStart()
			if yyl1235 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1235, d)
			}
		} else if yyct1235 == codecSelferValueTypeArray1234 {
			yyl1235 := r.ReadArrayStart()
			if yyl1235 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1235, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1236Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1236Slc
	var yyhl1236 bool = l >= 0
	for yyj1236 := 0; ; yyj1236++ {
		if yyhl1236 {
			if yyj1236 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1236Slc = r.DecodeBytes(yys1236Slc, true, true)
		yys1236 := string(yys1236Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1236 {
		case "maximumRetry":
			if r.TryDecodeAsNil() {
				x.MaximumRetry = 0
			} else {
				x.MaximumRetry = int32(r.DecodeInt(32))
			}
		case "minimumTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutNFS = 0
			} else {
				x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathNFS":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathNFS = ""
			} else {
				x.PodTemplateFilePathNFS = string(r.DecodeString())
			}
		case "incrementTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutNFS = 0
			} else {
				x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathHostPath":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathHostPath = ""
			} else {
				x.PodTemplateFilePathHostPath = string(r.DecodeString())
			}
		case "minimumTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutHostPath = 0
			} else {
				x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
			}
		case "incrementTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutHostPath = 0
			} else {
				x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1236)
		} // end switch yys1236
	} // end for yyj1236
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1244 int
	var yyb1244 bool
	var yyhl1244 bool = l >= 0
	yyj1244++
	if yyhl1244 {
		yyb1244 = yyj1244 > l
	} else {
		yyb1244 = r.CheckBreak()
	}
	if yyb1244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaximumRetry = 0
	} else {
		x.MaximumRetry = int32(r.DecodeInt(32))
	}
	yyj1244++
	if yyhl1244 {
		yyb1244 = yyj1244 > l
	} else {
		yyb1244 = r.CheckBreak()
	}
	if yyb1244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutNFS = 0
	} else {
		x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1244++
	if yyhl1244 {
		yyb1244 = yyj1244 > l
	} else {
		yyb1244 = r.CheckBreak()
	}
	if yyb1244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathNFS = ""
	} else {
		x.PodTemplateFilePathNFS = string(r.DecodeString())
	}
	yyj1244++
	if yyhl1244 {
		yyb1244 = yyj1244 > l
	} else {
		yyb1244 = r.CheckBreak()
	}
	if yyb1244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutNFS = 0
	} else {
		x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1244++
	if yyhl1244 {
		yyb1244 = yyj1244 > l
	} else {
		yyb1244 = r.CheckBreak()
	}
	if yyb1244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathHostPath = ""
	} else {
		x.PodTemplateFilePathHostPath = string(r.DecodeString())
	}
	yyj1244++
	if yyhl1244 {
		yyb1244 = yyj1244 > l
	} else {
		yyb1244 = r.CheckBreak()
	}
	if yyb1244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutHostPath = 0
	} else {
		x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
	}
	yyj1244++
	if yyhl1244 {
		yyb1244 = yyj1244 > l
	} else {
		yyb1244 = r.CheckBreak()
	}
	if yyb1244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutHostPath = 0
	} else {
		x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
	}
	for {
		yyj1244++
		if yyhl1244 {
			yyb1244 = yyj1244 > l
		} else {
			yyb1244 = r.CheckBreak()
		}
		if yyb1244 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1244-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encconfig_ConfigurationMap(v pkg2_config.ConfigurationMap, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk1252, yyv1252 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym1253 := z.EncBinary()
		_ = yym1253
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk1252))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		yym1254 := z.EncBinary()
		_ = yym1254
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1252))
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decconfig_ConfigurationMap(v *pkg2_config.ConfigurationMap, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1255 := *v
	yyl1255 := r.ReadMapStart()
	yybh1255 := z.DecBasicHandle()
	if yyv1255 == nil {
		yyrl1255, _ := z.DecInferLen(yyl1255, yybh1255.MaxInitLen, 32)
		yyv1255 = make(map[string]string, yyrl1255)
		*v = yyv1255
	}
	var yymk1255 string
	var yymv1255 string
	var yymg1255 bool
	if yybh1255.MapValueReset {
	}
	if yyl1255 > 0 {
		for yyj1255 := 0; yyj1255 < yyl1255; yyj1255++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1255 = ""
			} else {
				yymk1255 = string(r.DecodeString())
			}

			if yymg1255 {
				yymv1255 = yyv1255[yymk1255]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1255 = ""
			} else {
				yymv1255 = string(r.DecodeString())
			}

			if yyv1255 != nil {
				yyv1255[yymk1255] = yymv1255
			}
		}
	} else if yyl1255 < 0 {
		for yyj1255 := 0; !r.CheckBreak(); yyj1255++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1255 = ""
			} else {
				yymk1255 = string(r.DecodeString())
			}

			if yymg1255 {
				yymv1255 = yyv1255[yymk1255]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1255 = ""
			} else {
				yymv1255 = string(r.DecodeString())
			}

			if yyv1255 != nil {
				yyv1255[yymk1255] = yymv1255
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}
