/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg2_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg5_runtime "k8s.io/kubernetes/pkg/runtime"
	pkg1_types "k8s.io/kubernetes/pkg/types"
	pkg4_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_resource.Quantity
		var v1 pkg2_unversioned.Time
		var v2 pkg5_runtime.RawExtension
		var v3 pkg1_types.UID
		var v4 pkg4_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *ObjectMeta) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [15]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.GenerateName != ""
			yyq2[2] = x.Namespace != ""
			yyq2[3] = x.SelfLink != ""
			yyq2[4] = x.UID != ""
			yyq2[5] = x.ResourceVersion != ""
			yyq2[6] = x.Generation != 0
			yyq2[7] = true
			yyq2[8] = x.DeletionTimestamp != nil
			yyq2[9] = x.DeletionGracePeriodSeconds != nil
			yyq2[10] = len(x.Labels) != 0
			yyq2[11] = len(x.Annotations) != 0
			yyq2[12] = len(x.OwnerReferences) != 0
			yyq2[13] = len(x.Finalizers) != 0
			yyq2[14] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(15)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yy25 := &x.CreationTimestamp
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else if z.HasExtensions() && z.EncExt(yy25) {
					} else if yym26 {
						z.EncBinaryMarshal(yy25)
					} else if !yym26 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy25)
					} else {
						z.EncFallback(yy25)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy27 := &x.CreationTimestamp
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else if z.HasExtensions() && z.EncExt(yy27) {
					} else if yym28 {
						z.EncBinaryMarshal(yy27)
					} else if !yym28 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy27)
					} else {
						z.EncFallback(yy27)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym30 := z.EncBinary()
						_ = yym30
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym30 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym30 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym31 := z.EncBinary()
						_ = yym31
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym31 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym31 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy33 := *x.DeletionGracePeriodSeconds
						yym34 := z.EncBinary()
						_ = yym34
						if false {
						} else {
							r.EncodeInt(int64(yy33))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy35 := *x.DeletionGracePeriodSeconds
						yym36 := z.EncBinary()
						_ = yym36
						if false {
						} else {
							r.EncodeInt(int64(yy35))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym38 := z.EncBinary()
						_ = yym38
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym41 := z.EncBinary()
						_ = yym41
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym42 := z.EncBinary()
						_ = yym42
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							h.encSliceOwnerReference(([]OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							h.encSliceOwnerReference(([]OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym51 := z.EncBinary()
					_ = yym51
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectMeta) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym52 := z.DecBinary()
	_ = yym52
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct53 := r.ContainerType()
		if yyct53 == codecSelferValueTypeMap1234 {
			yyl53 := r.ReadMapStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl53, d)
			}
		} else if yyct53 == codecSelferValueTypeArray1234 {
			yyl53 := r.ReadArrayStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl53, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectMeta) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys54Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys54Slc
	var yyhl54 bool = l >= 0
	for yyj54 := 0; ; yyj54++ {
		if yyhl54 {
			if yyj54 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys54Slc = r.DecodeBytes(yys54Slc, true, true)
		yys54 := string(yys54Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys54 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg1_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv62 := &x.CreationTimestamp
				yym63 := z.DecBinary()
				_ = yym63
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv62) {
				} else if yym63 {
					z.DecBinaryUnmarshal(yyv62)
				} else if !yym63 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv62)
				} else {
					z.DecFallback(yyv62, false)
				}
			}
		case "deletionTimestamp":
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg2_unversioned.Time)
				}
				yym65 := z.DecBinary()
				_ = yym65
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym65 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym65 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym67 := z.DecBinary()
				_ = yym67
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv68 := &x.Labels
				yym69 := z.DecBinary()
				_ = yym69
				if false {
				} else {
					z.F.DecMapStringStringX(yyv68, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv70 := &x.Annotations
				yym71 := z.DecBinary()
				_ = yym71
				if false {
				} else {
					z.F.DecMapStringStringX(yyv70, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv72 := &x.OwnerReferences
				yym73 := z.DecBinary()
				_ = yym73
				if false {
				} else {
					h.decSliceOwnerReference((*[]OwnerReference)(yyv72), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv74 := &x.Finalizers
				yym75 := z.DecBinary()
				_ = yym75
				if false {
				} else {
					z.F.DecSliceStringX(yyv74, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys54)
		} // end switch yys54
	} // end for yyj54
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectMeta) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj77 int
	var yyb77 bool
	var yyhl77 bool = l >= 0
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg1_types.UID(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv85 := &x.CreationTimestamp
		yym86 := z.DecBinary()
		_ = yym86
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv85) {
		} else if yym86 {
			z.DecBinaryUnmarshal(yyv85)
		} else if !yym86 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv85)
		} else {
			z.DecFallback(yyv85, false)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg2_unversioned.Time)
		}
		yym88 := z.DecBinary()
		_ = yym88
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym88 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym88 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym90 := z.DecBinary()
		_ = yym90
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv91 := &x.Labels
		yym92 := z.DecBinary()
		_ = yym92
		if false {
		} else {
			z.F.DecMapStringStringX(yyv91, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv93 := &x.Annotations
		yym94 := z.DecBinary()
		_ = yym94
		if false {
		} else {
			z.F.DecMapStringStringX(yyv93, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv95 := &x.OwnerReferences
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else {
			h.decSliceOwnerReference((*[]OwnerReference)(yyv95), d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv97 := &x.Finalizers
		yym98 := z.DecBinary()
		_ = yym98
		if false {
		} else {
			z.F.DecSliceStringX(yyv97, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	for {
		yyj77++
		if yyhl77 {
			yyb77 = yyj77 > l
		} else {
			yyb77 = r.CheckBreak()
		}
		if yyb77 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj77-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Volume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym100 := z.EncBinary()
		_ = yym100
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep101 := !z.EncBinary()
			yy2arr101 := z.EncBasicHandle().StructToArray
			var yyq101 [23]bool
			_, _, _ = yysep101, yyq101, yy2arr101
			const yyr101 bool = false
			yyq101[1] = x.VolumeSource.HostPath != nil && x.HostPath != nil
			yyq101[2] = x.VolumeSource.EmptyDir != nil && x.EmptyDir != nil
			yyq101[3] = x.VolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq101[4] = x.VolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq101[5] = x.VolumeSource.GitRepo != nil && x.GitRepo != nil
			yyq101[6] = x.VolumeSource.Secret != nil && x.Secret != nil
			yyq101[7] = x.VolumeSource.NFS != nil && x.NFS != nil
			yyq101[8] = x.VolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq101[9] = x.VolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq101[10] = x.VolumeSource.PersistentVolumeClaim != nil && x.PersistentVolumeClaim != nil
			yyq101[11] = x.VolumeSource.RBD != nil && x.RBD != nil
			yyq101[12] = x.VolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq101[13] = x.VolumeSource.Cinder != nil && x.Cinder != nil
			yyq101[14] = x.VolumeSource.CephFS != nil && x.CephFS != nil
			yyq101[15] = x.VolumeSource.Flocker != nil && x.Flocker != nil
			yyq101[16] = x.VolumeSource.DownwardAPI != nil && x.DownwardAPI != nil
			yyq101[17] = x.VolumeSource.FC != nil && x.FC != nil
			yyq101[18] = x.VolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq101[19] = x.VolumeSource.ConfigMap != nil && x.ConfigMap != nil
			yyq101[20] = x.VolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq101[21] = x.VolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq101[22] = x.VolumeSource.AzureDisk != nil && x.AzureDisk != nil
			var yynn101 int
			if yyr101 || yy2arr101 {
				r.EncodeArrayStart(23)
			} else {
				yynn101 = 1
				for _, b := range yyq101 {
					if b {
						yynn101++
					}
				}
				r.EncodeMapStart(yynn101)
				yynn101 = 0
			}
			if yyr101 || yy2arr101 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym103 := z.EncBinary()
				_ = yym103
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym104 := z.EncBinary()
				_ = yym104
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			var yyn105 bool
			if x.VolumeSource.HostPath == nil {
				yyn105 = true
				goto LABEL105
			}
		LABEL105:
			if yyr101 || yy2arr101 {
				if yyn105 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[1] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn105 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn106 bool
			if x.VolumeSource.EmptyDir == nil {
				yyn106 = true
				goto LABEL106
			}
		LABEL106:
			if yyr101 || yy2arr101 {
				if yyn106 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[2] {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn106 {
						r.EncodeNil()
					} else {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn107 bool
			if x.VolumeSource.GCEPersistentDisk == nil {
				yyn107 = true
				goto LABEL107
			}
		LABEL107:
			if yyr101 || yy2arr101 {
				if yyn107 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[3] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn107 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn108 bool
			if x.VolumeSource.AWSElasticBlockStore == nil {
				yyn108 = true
				goto LABEL108
			}
		LABEL108:
			if yyr101 || yy2arr101 {
				if yyn108 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[4] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn108 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn109 bool
			if x.VolumeSource.GitRepo == nil {
				yyn109 = true
				goto LABEL109
			}
		LABEL109:
			if yyr101 || yy2arr101 {
				if yyn109 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[5] {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn109 {
						r.EncodeNil()
					} else {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn110 bool
			if x.VolumeSource.Secret == nil {
				yyn110 = true
				goto LABEL110
			}
		LABEL110:
			if yyr101 || yy2arr101 {
				if yyn110 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[6] {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn110 {
						r.EncodeNil()
					} else {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn111 bool
			if x.VolumeSource.NFS == nil {
				yyn111 = true
				goto LABEL111
			}
		LABEL111:
			if yyr101 || yy2arr101 {
				if yyn111 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[7] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn111 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn112 bool
			if x.VolumeSource.ISCSI == nil {
				yyn112 = true
				goto LABEL112
			}
		LABEL112:
			if yyr101 || yy2arr101 {
				if yyn112 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn112 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn113 bool
			if x.VolumeSource.Glusterfs == nil {
				yyn113 = true
				goto LABEL113
			}
		LABEL113:
			if yyr101 || yy2arr101 {
				if yyn113 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[9] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn113 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn114 bool
			if x.VolumeSource.PersistentVolumeClaim == nil {
				yyn114 = true
				goto LABEL114
			}
		LABEL114:
			if yyr101 || yy2arr101 {
				if yyn114 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[10] {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn114 {
						r.EncodeNil()
					} else {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn115 bool
			if x.VolumeSource.RBD == nil {
				yyn115 = true
				goto LABEL115
			}
		LABEL115:
			if yyr101 || yy2arr101 {
				if yyn115 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[11] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn115 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn116 bool
			if x.VolumeSource.FlexVolume == nil {
				yyn116 = true
				goto LABEL116
			}
		LABEL116:
			if yyr101 || yy2arr101 {
				if yyn116 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn116 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn117 bool
			if x.VolumeSource.Cinder == nil {
				yyn117 = true
				goto LABEL117
			}
		LABEL117:
			if yyr101 || yy2arr101 {
				if yyn117 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[13] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn117 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn118 bool
			if x.VolumeSource.CephFS == nil {
				yyn118 = true
				goto LABEL118
			}
		LABEL118:
			if yyr101 || yy2arr101 {
				if yyn118 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[14] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn118 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn119 bool
			if x.VolumeSource.Flocker == nil {
				yyn119 = true
				goto LABEL119
			}
		LABEL119:
			if yyr101 || yy2arr101 {
				if yyn119 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[15] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn119 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn120 bool
			if x.VolumeSource.DownwardAPI == nil {
				yyn120 = true
				goto LABEL120
			}
		LABEL120:
			if yyr101 || yy2arr101 {
				if yyn120 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[16] {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn120 {
						r.EncodeNil()
					} else {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn121 bool
			if x.VolumeSource.FC == nil {
				yyn121 = true
				goto LABEL121
			}
		LABEL121:
			if yyr101 || yy2arr101 {
				if yyn121 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[17] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn121 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn122 bool
			if x.VolumeSource.AzureFile == nil {
				yyn122 = true
				goto LABEL122
			}
		LABEL122:
			if yyr101 || yy2arr101 {
				if yyn122 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[18] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn122 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn123 bool
			if x.VolumeSource.ConfigMap == nil {
				yyn123 = true
				goto LABEL123
			}
		LABEL123:
			if yyr101 || yy2arr101 {
				if yyn123 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[19] {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn123 {
						r.EncodeNil()
					} else {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn124 bool
			if x.VolumeSource.VsphereVolume == nil {
				yyn124 = true
				goto LABEL124
			}
		LABEL124:
			if yyr101 || yy2arr101 {
				if yyn124 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[20] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn124 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn125 bool
			if x.VolumeSource.Quobyte == nil {
				yyn125 = true
				goto LABEL125
			}
		LABEL125:
			if yyr101 || yy2arr101 {
				if yyn125 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[21] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn125 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn126 bool
			if x.VolumeSource.AzureDisk == nil {
				yyn126 = true
				goto LABEL126
			}
		LABEL126:
			if yyr101 || yy2arr101 {
				if yyn126 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[22] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn126 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr101 || yy2arr101 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Volume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym127 := z.DecBinary()
	_ = yym127
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct128 := r.ContainerType()
		if yyct128 == codecSelferValueTypeMap1234 {
			yyl128 := r.ReadMapStart()
			if yyl128 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl128, d)
			}
		} else if yyct128 == codecSelferValueTypeArray1234 {
			yyl128 := r.ReadArrayStart()
			if yyl128 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl128, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Volume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys129Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys129Slc
	var yyhl129 bool = l >= 0
	for yyj129 := 0; ; yyj129++ {
		if yyhl129 {
			if yyj129 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys129Slc = r.DecodeBytes(yys129Slc, true, true)
		yys129 := string(yys129Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys129 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPath":
			if x.VolumeSource.HostPath == nil {
				x.VolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if x.VolumeSource.EmptyDir == nil {
				x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.VolumeSource.GCEPersistentDisk == nil {
				x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.VolumeSource.AWSElasticBlockStore == nil {
				x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if x.VolumeSource.GitRepo == nil {
				x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if x.VolumeSource.Secret == nil {
				x.VolumeSource.Secret = new(SecretVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.VolumeSource.NFS == nil {
				x.VolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.VolumeSource.ISCSI == nil {
				x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.VolumeSource.Glusterfs == nil {
				x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if x.VolumeSource.PersistentVolumeClaim == nil {
				x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.VolumeSource.RBD == nil {
				x.VolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.VolumeSource.FlexVolume == nil {
				x.VolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.VolumeSource.Cinder == nil {
				x.VolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.VolumeSource.CephFS == nil {
				x.VolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.VolumeSource.Flocker == nil {
				x.VolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if x.VolumeSource.DownwardAPI == nil {
				x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if x.VolumeSource.FC == nil {
				x.VolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.VolumeSource.AzureFile == nil {
				x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if x.VolumeSource.ConfigMap == nil {
				x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.VolumeSource.VsphereVolume == nil {
				x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.VolumeSource.Quobyte == nil {
				x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.VolumeSource.AzureDisk == nil {
				x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys129)
		} // end switch yys129
	} // end for yyj129
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Volume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj153 int
	var yyb153 bool
	var yyhl153 bool = l >= 0
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	if x.VolumeSource.HostPath == nil {
		x.VolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.VolumeSource.EmptyDir == nil {
		x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GCEPersistentDisk == nil {
		x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AWSElasticBlockStore == nil {
		x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GitRepo == nil {
		x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Secret == nil {
		x.VolumeSource.Secret = new(SecretVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	if x.VolumeSource.NFS == nil {
		x.VolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ISCSI == nil {
		x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Glusterfs == nil {
		x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PersistentVolumeClaim == nil {
		x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	if x.VolumeSource.RBD == nil {
		x.VolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FlexVolume == nil {
		x.VolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Cinder == nil {
		x.VolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.VolumeSource.CephFS == nil {
		x.VolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Flocker == nil {
		x.VolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.VolumeSource.DownwardAPI == nil {
		x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FC == nil {
		x.VolumeSource.FC = new(FCVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureFile == nil {
		x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ConfigMap == nil {
		x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	if x.VolumeSource.VsphereVolume == nil {
		x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Quobyte == nil {
		x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureDisk == nil {
		x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	for {
		yyj153++
		if yyhl153 {
			yyb153 = yyj153 > l
		} else {
			yyb153 = r.CheckBreak()
		}
		if yyb153 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj153-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym177 := z.EncBinary()
		_ = yym177
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep178 := !z.EncBinary()
			yy2arr178 := z.EncBasicHandle().StructToArray
			var yyq178 [22]bool
			_, _, _ = yysep178, yyq178, yy2arr178
			const yyr178 bool = false
			yyq178[0] = x.HostPath != nil
			yyq178[1] = x.EmptyDir != nil
			yyq178[2] = x.GCEPersistentDisk != nil
			yyq178[3] = x.AWSElasticBlockStore != nil
			yyq178[4] = x.GitRepo != nil
			yyq178[5] = x.Secret != nil
			yyq178[6] = x.NFS != nil
			yyq178[7] = x.ISCSI != nil
			yyq178[8] = x.Glusterfs != nil
			yyq178[9] = x.PersistentVolumeClaim != nil
			yyq178[10] = x.RBD != nil
			yyq178[11] = x.FlexVolume != nil
			yyq178[12] = x.Cinder != nil
			yyq178[13] = x.CephFS != nil
			yyq178[14] = x.Flocker != nil
			yyq178[15] = x.DownwardAPI != nil
			yyq178[16] = x.FC != nil
			yyq178[17] = x.AzureFile != nil
			yyq178[18] = x.ConfigMap != nil
			yyq178[19] = x.VsphereVolume != nil
			yyq178[20] = x.Quobyte != nil
			yyq178[21] = x.AzureDisk != nil
			var yynn178 int
			if yyr178 || yy2arr178 {
				r.EncodeArrayStart(22)
			} else {
				yynn178 = 0
				for _, b := range yyq178 {
					if b {
						yynn178++
					}
				}
				r.EncodeMapStart(yynn178)
				yynn178 = 0
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[0] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[1] {
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[2] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[3] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[4] {
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[5] {
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[6] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[8] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[9] {
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[10] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[12] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[13] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[14] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[15] {
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[16] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[17] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[18] {
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[19] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[20] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[21] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym201 := z.DecBinary()
	_ = yym201
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct202 := r.ContainerType()
		if yyct202 == codecSelferValueTypeMap1234 {
			yyl202 := r.ReadMapStart()
			if yyl202 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl202, d)
			}
		} else if yyct202 == codecSelferValueTypeArray1234 {
			yyl202 := r.ReadArrayStart()
			if yyl202 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl202, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys203Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys203Slc
	var yyhl203 bool = l >= 0
	for yyj203 := 0; ; yyj203++ {
		if yyhl203 {
			if yyj203 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys203Slc = r.DecodeBytes(yys203Slc, true, true)
		yys203 := string(yys203Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys203 {
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys203)
		} // end switch yys203
	} // end for yyj203
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj226 int
	var yyb226 bool
	var yyhl226 bool = l >= 0
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	for {
		yyj226++
		if yyhl226 {
			yyb226 = yyj226 > l
		} else {
			yyb226 = r.CheckBreak()
		}
		if yyb226 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj226-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym249 := z.EncBinary()
		_ = yym249
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep250 := !z.EncBinary()
			yy2arr250 := z.EncBasicHandle().StructToArray
			var yyq250 [2]bool
			_, _, _ = yysep250, yyq250, yy2arr250
			const yyr250 bool = false
			yyq250[1] = x.ReadOnly != false
			var yynn250 int
			if yyr250 || yy2arr250 {
				r.EncodeArrayStart(2)
			} else {
				yynn250 = 1
				for _, b := range yyq250 {
					if b {
						yynn250++
					}
				}
				r.EncodeMapStart(yynn250)
				yynn250 = 0
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym252 := z.EncBinary()
				_ = yym252
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("claimName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym253 := z.EncBinary()
				_ = yym253
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[1] {
					yym255 := z.EncBinary()
					_ = yym255
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq250[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym256 := z.EncBinary()
					_ = yym256
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym257 := z.DecBinary()
	_ = yym257
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct258 := r.ContainerType()
		if yyct258 == codecSelferValueTypeMap1234 {
			yyl258 := r.ReadMapStart()
			if yyl258 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl258, d)
			}
		} else if yyct258 == codecSelferValueTypeArray1234 {
			yyl258 := r.ReadArrayStart()
			if yyl258 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl258, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys259Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys259Slc
	var yyhl259 bool = l >= 0
	for yyj259 := 0; ; yyj259++ {
		if yyhl259 {
			if yyj259 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys259Slc = r.DecodeBytes(yys259Slc, true, true)
		yys259 := string(yys259Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys259 {
		case "claimName":
			if r.TryDecodeAsNil() {
				x.ClaimName = ""
			} else {
				x.ClaimName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys259)
		} // end switch yys259
	} // end for yyj259
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj262 int
	var yyb262 bool
	var yyhl262 bool = l >= 0
	yyj262++
	if yyhl262 {
		yyb262 = yyj262 > l
	} else {
		yyb262 = r.CheckBreak()
	}
	if yyb262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClaimName = ""
	} else {
		x.ClaimName = string(r.DecodeString())
	}
	yyj262++
	if yyhl262 {
		yyb262 = yyj262 > l
	} else {
		yyb262 = r.CheckBreak()
	}
	if yyb262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj262++
		if yyhl262 {
			yyb262 = yyj262 > l
		} else {
			yyb262 = r.CheckBreak()
		}
		if yyb262 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj262-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym265 := z.EncBinary()
		_ = yym265
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep266 := !z.EncBinary()
			yy2arr266 := z.EncBasicHandle().StructToArray
			var yyq266 [16]bool
			_, _, _ = yysep266, yyq266, yy2arr266
			const yyr266 bool = false
			yyq266[0] = x.GCEPersistentDisk != nil
			yyq266[1] = x.AWSElasticBlockStore != nil
			yyq266[2] = x.HostPath != nil
			yyq266[3] = x.Glusterfs != nil
			yyq266[4] = x.NFS != nil
			yyq266[5] = x.RBD != nil
			yyq266[6] = x.ISCSI != nil
			yyq266[7] = x.Cinder != nil
			yyq266[8] = x.CephFS != nil
			yyq266[9] = x.FC != nil
			yyq266[10] = x.Flocker != nil
			yyq266[11] = x.FlexVolume != nil
			yyq266[12] = x.AzureFile != nil
			yyq266[13] = x.VsphereVolume != nil
			yyq266[14] = x.Quobyte != nil
			yyq266[15] = x.AzureDisk != nil
			var yynn266 int
			if yyr266 || yy2arr266 {
				r.EncodeArrayStart(16)
			} else {
				yynn266 = 0
				for _, b := range yyq266 {
					if b {
						yynn266++
					}
				}
				r.EncodeMapStart(yynn266)
				yynn266 = 0
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[0] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[1] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[2] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[3] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[4] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[5] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[6] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[7] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[8] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[9] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[10] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[12] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[13] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[14] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq266[15] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq266[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr266 || yy2arr266 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym283 := z.DecBinary()
	_ = yym283
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct284 := r.ContainerType()
		if yyct284 == codecSelferValueTypeMap1234 {
			yyl284 := r.ReadMapStart()
			if yyl284 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl284, d)
			}
		} else if yyct284 == codecSelferValueTypeArray1234 {
			yyl284 := r.ReadArrayStart()
			if yyl284 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl284, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys285Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys285Slc
	var yyhl285 bool = l >= 0
	for yyj285 := 0; ; yyj285++ {
		if yyhl285 {
			if yyj285 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys285Slc = r.DecodeBytes(yys285Slc, true, true)
		yys285 := string(yys285Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys285 {
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys285)
		} // end switch yys285
	} // end for yyj285
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj302 int
	var yyb302 bool
	var yyhl302 bool = l >= 0
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj302++
	if yyhl302 {
		yyb302 = yyj302 > l
	} else {
		yyb302 = r.CheckBreak()
	}
	if yyb302 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	for {
		yyj302++
		if yyhl302 {
			yyb302 = yyj302 > l
		} else {
			yyb302 = r.CheckBreak()
		}
		if yyb302 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj302-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym319 := z.EncBinary()
		_ = yym319
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep320 := !z.EncBinary()
			yy2arr320 := z.EncBasicHandle().StructToArray
			var yyq320 [5]bool
			_, _, _ = yysep320, yyq320, yy2arr320
			const yyr320 bool = false
			yyq320[0] = x.Kind != ""
			yyq320[1] = x.APIVersion != ""
			yyq320[2] = true
			yyq320[3] = true
			yyq320[4] = true
			var yynn320 int
			if yyr320 || yy2arr320 {
				r.EncodeArrayStart(5)
			} else {
				yynn320 = 0
				for _, b := range yyq320 {
					if b {
						yynn320++
					}
				}
				r.EncodeMapStart(yynn320)
				yynn320 = 0
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[0] {
					yym322 := z.EncBinary()
					_ = yym322
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq320[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym323 := z.EncBinary()
					_ = yym323
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[1] {
					yym325 := z.EncBinary()
					_ = yym325
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq320[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym326 := z.EncBinary()
					_ = yym326
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[2] {
					yy328 := &x.ObjectMeta
					yy328.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq320[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy329 := &x.ObjectMeta
					yy329.CodecEncodeSelf(e)
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[3] {
					yy331 := &x.Spec
					yy331.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq320[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy332 := &x.Spec
					yy332.CodecEncodeSelf(e)
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[4] {
					yy334 := &x.Status
					yy334.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq320[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy335 := &x.Status
					yy335.CodecEncodeSelf(e)
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym336 := z.DecBinary()
	_ = yym336
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct337 := r.ContainerType()
		if yyct337 == codecSelferValueTypeMap1234 {
			yyl337 := r.ReadMapStart()
			if yyl337 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl337, d)
			}
		} else if yyct337 == codecSelferValueTypeArray1234 {
			yyl337 := r.ReadArrayStart()
			if yyl337 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl337, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys338Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys338Slc
	var yyhl338 bool = l >= 0
	for yyj338 := 0; ; yyj338++ {
		if yyhl338 {
			if yyj338 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys338Slc = r.DecodeBytes(yys338Slc, true, true)
		yys338 := string(yys338Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys338 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv341 := &x.ObjectMeta
				yyv341.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeSpec{}
			} else {
				yyv342 := &x.Spec
				yyv342.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeStatus{}
			} else {
				yyv343 := &x.Status
				yyv343.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys338)
		} // end switch yys338
	} // end for yyj338
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj344 int
	var yyb344 bool
	var yyhl344 bool = l >= 0
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv347 := &x.ObjectMeta
		yyv347.CodecDecodeSelf(d)
	}
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeSpec{}
	} else {
		yyv348 := &x.Spec
		yyv348.CodecDecodeSelf(d)
	}
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeStatus{}
	} else {
		yyv349 := &x.Status
		yyv349.CodecDecodeSelf(d)
	}
	for {
		yyj344++
		if yyhl344 {
			yyb344 = yyj344 > l
		} else {
			yyb344 = r.CheckBreak()
		}
		if yyb344 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj344-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym350 := z.EncBinary()
		_ = yym350
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep351 := !z.EncBinary()
			yy2arr351 := z.EncBasicHandle().StructToArray
			var yyq351 [20]bool
			_, _, _ = yysep351, yyq351, yy2arr351
			const yyr351 bool = false
			yyq351[0] = len(x.Capacity) != 0
			yyq351[1] = x.PersistentVolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq351[2] = x.PersistentVolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq351[3] = x.PersistentVolumeSource.HostPath != nil && x.HostPath != nil
			yyq351[4] = x.PersistentVolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq351[5] = x.PersistentVolumeSource.NFS != nil && x.NFS != nil
			yyq351[6] = x.PersistentVolumeSource.RBD != nil && x.RBD != nil
			yyq351[7] = x.PersistentVolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq351[8] = x.PersistentVolumeSource.Cinder != nil && x.Cinder != nil
			yyq351[9] = x.PersistentVolumeSource.CephFS != nil && x.CephFS != nil
			yyq351[10] = x.PersistentVolumeSource.FC != nil && x.FC != nil
			yyq351[11] = x.PersistentVolumeSource.Flocker != nil && x.Flocker != nil
			yyq351[12] = x.PersistentVolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq351[13] = x.PersistentVolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq351[14] = x.PersistentVolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq351[15] = x.PersistentVolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq351[16] = x.PersistentVolumeSource.AzureDisk != nil && x.AzureDisk != nil
			yyq351[17] = len(x.AccessModes) != 0
			yyq351[18] = x.ClaimRef != nil
			yyq351[19] = x.PersistentVolumeReclaimPolicy != ""
			var yynn351 int
			if yyr351 || yy2arr351 {
				r.EncodeArrayStart(20)
			} else {
				yynn351 = 0
				for _, b := range yyq351 {
					if b {
						yynn351++
					}
				}
				r.EncodeMapStart(yynn351)
				yynn351 = 0
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq351[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			var yyn353 bool
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				yyn353 = true
				goto LABEL353
			}
		LABEL353:
			if yyr351 || yy2arr351 {
				if yyn353 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[1] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn353 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn354 bool
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				yyn354 = true
				goto LABEL354
			}
		LABEL354:
			if yyr351 || yy2arr351 {
				if yyn354 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[2] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn354 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn355 bool
			if x.PersistentVolumeSource.HostPath == nil {
				yyn355 = true
				goto LABEL355
			}
		LABEL355:
			if yyr351 || yy2arr351 {
				if yyn355 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[3] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn355 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn356 bool
			if x.PersistentVolumeSource.Glusterfs == nil {
				yyn356 = true
				goto LABEL356
			}
		LABEL356:
			if yyr351 || yy2arr351 {
				if yyn356 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[4] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn356 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn357 bool
			if x.PersistentVolumeSource.NFS == nil {
				yyn357 = true
				goto LABEL357
			}
		LABEL357:
			if yyr351 || yy2arr351 {
				if yyn357 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[5] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn357 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn358 bool
			if x.PersistentVolumeSource.RBD == nil {
				yyn358 = true
				goto LABEL358
			}
		LABEL358:
			if yyr351 || yy2arr351 {
				if yyn358 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[6] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn358 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn359 bool
			if x.PersistentVolumeSource.ISCSI == nil {
				yyn359 = true
				goto LABEL359
			}
		LABEL359:
			if yyr351 || yy2arr351 {
				if yyn359 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[7] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn359 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn360 bool
			if x.PersistentVolumeSource.Cinder == nil {
				yyn360 = true
				goto LABEL360
			}
		LABEL360:
			if yyr351 || yy2arr351 {
				if yyn360 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[8] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn360 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn361 bool
			if x.PersistentVolumeSource.CephFS == nil {
				yyn361 = true
				goto LABEL361
			}
		LABEL361:
			if yyr351 || yy2arr351 {
				if yyn361 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[9] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn361 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn362 bool
			if x.PersistentVolumeSource.FC == nil {
				yyn362 = true
				goto LABEL362
			}
		LABEL362:
			if yyr351 || yy2arr351 {
				if yyn362 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[10] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn362 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn363 bool
			if x.PersistentVolumeSource.Flocker == nil {
				yyn363 = true
				goto LABEL363
			}
		LABEL363:
			if yyr351 || yy2arr351 {
				if yyn363 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[11] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn363 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn364 bool
			if x.PersistentVolumeSource.FlexVolume == nil {
				yyn364 = true
				goto LABEL364
			}
		LABEL364:
			if yyr351 || yy2arr351 {
				if yyn364 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn364 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn365 bool
			if x.PersistentVolumeSource.AzureFile == nil {
				yyn365 = true
				goto LABEL365
			}
		LABEL365:
			if yyr351 || yy2arr351 {
				if yyn365 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[13] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn365 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn366 bool
			if x.PersistentVolumeSource.VsphereVolume == nil {
				yyn366 = true
				goto LABEL366
			}
		LABEL366:
			if yyr351 || yy2arr351 {
				if yyn366 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[14] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn366 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn367 bool
			if x.PersistentVolumeSource.Quobyte == nil {
				yyn367 = true
				goto LABEL367
			}
		LABEL367:
			if yyr351 || yy2arr351 {
				if yyn367 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[15] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn367 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn368 bool
			if x.PersistentVolumeSource.AzureDisk == nil {
				yyn368 = true
				goto LABEL368
			}
		LABEL368:
			if yyr351 || yy2arr351 {
				if yyn368 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[16] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn368 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[17] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym370 := z.EncBinary()
						_ = yym370
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq351[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym371 := z.EncBinary()
						_ = yym371
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[18] {
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq351[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("claimRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[19] {
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq351[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeReclaimPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym374 := z.DecBinary()
	_ = yym374
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct375 := r.ContainerType()
		if yyct375 == codecSelferValueTypeMap1234 {
			yyl375 := r.ReadMapStart()
			if yyl375 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl375, d)
			}
		} else if yyct375 == codecSelferValueTypeArray1234 {
			yyl375 := r.ReadArrayStart()
			if yyl375 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl375, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys376Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys376Slc
	var yyhl376 bool = l >= 0
	for yyj376 := 0; ; yyj376++ {
		if yyhl376 {
			if yyj376 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys376Slc = r.DecodeBytes(yys376Slc, true, true)
		yys376 := string(yys376Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys376 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv377 := &x.Capacity
				yyv377.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if x.PersistentVolumeSource.HostPath == nil {
				x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.PersistentVolumeSource.Glusterfs == nil {
				x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.PersistentVolumeSource.NFS == nil {
				x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.PersistentVolumeSource.RBD == nil {
				x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.PersistentVolumeSource.ISCSI == nil {
				x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.PersistentVolumeSource.Cinder == nil {
				x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.PersistentVolumeSource.CephFS == nil {
				x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if x.PersistentVolumeSource.FC == nil {
				x.PersistentVolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.PersistentVolumeSource.Flocker == nil {
				x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.PersistentVolumeSource.FlexVolume == nil {
				x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.PersistentVolumeSource.AzureFile == nil {
				x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.PersistentVolumeSource.VsphereVolume == nil {
				x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.PersistentVolumeSource.Quobyte == nil {
				x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.PersistentVolumeSource.AzureDisk == nil {
				x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv394 := &x.AccessModes
				yym395 := z.DecBinary()
				_ = yym395
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv394), d)
				}
			}
		case "claimRef":
			if r.TryDecodeAsNil() {
				if x.ClaimRef != nil {
					x.ClaimRef = nil
				}
			} else {
				if x.ClaimRef == nil {
					x.ClaimRef = new(ObjectReference)
				}
				x.ClaimRef.CodecDecodeSelf(d)
			}
		case "persistentVolumeReclaimPolicy":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeReclaimPolicy = ""
			} else {
				x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys376)
		} // end switch yys376
	} // end for yyj376
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj398 int
	var yyb398 bool
	var yyhl398 bool = l >= 0
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv399 := &x.Capacity
		yyv399.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.GCEPersistentDisk == nil {
		x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
		x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.HostPath == nil {
		x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Glusterfs == nil {
		x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.NFS == nil {
		x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.RBD == nil {
		x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.ISCSI == nil {
		x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Cinder == nil {
		x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.CephFS == nil {
		x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FC == nil {
		x.PersistentVolumeSource.FC = new(FCVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Flocker == nil {
		x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FlexVolume == nil {
		x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureFile == nil {
		x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.VsphereVolume == nil {
		x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Quobyte == nil {
		x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureDisk == nil {
		x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv416 := &x.AccessModes
		yym417 := z.DecBinary()
		_ = yym417
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv416), d)
		}
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ClaimRef != nil {
			x.ClaimRef = nil
		}
	} else {
		if x.ClaimRef == nil {
			x.ClaimRef = new(ObjectReference)
		}
		x.ClaimRef.CodecDecodeSelf(d)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeReclaimPolicy = ""
	} else {
		x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
	}
	for {
		yyj398++
		if yyhl398 {
			yyb398 = yyj398 > l
		} else {
			yyb398 = r.CheckBreak()
		}
		if yyb398 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj398-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeReclaimPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym420 := z.EncBinary()
	_ = yym420
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeReclaimPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym421 := z.DecBinary()
	_ = yym421
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PersistentVolumeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym422 := z.EncBinary()
		_ = yym422
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep423 := !z.EncBinary()
			yy2arr423 := z.EncBasicHandle().StructToArray
			var yyq423 [3]bool
			_, _, _ = yysep423, yyq423, yy2arr423
			const yyr423 bool = false
			yyq423[0] = x.Phase != ""
			yyq423[1] = x.Message != ""
			yyq423[2] = x.Reason != ""
			var yynn423 int
			if yyr423 || yy2arr423 {
				r.EncodeArrayStart(3)
			} else {
				yynn423 = 0
				for _, b := range yyq423 {
					if b {
						yynn423++
					}
				}
				r.EncodeMapStart(yynn423)
				yynn423 = 0
			}
			if yyr423 || yy2arr423 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq423[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq423[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr423 || yy2arr423 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq423[1] {
					yym426 := z.EncBinary()
					_ = yym426
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq423[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym427 := z.EncBinary()
					_ = yym427
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr423 || yy2arr423 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq423[2] {
					yym429 := z.EncBinary()
					_ = yym429
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq423[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym430 := z.EncBinary()
					_ = yym430
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr423 || yy2arr423 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym431 := z.DecBinary()
	_ = yym431
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct432 := r.ContainerType()
		if yyct432 == codecSelferValueTypeMap1234 {
			yyl432 := r.ReadMapStart()
			if yyl432 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl432, d)
			}
		} else if yyct432 == codecSelferValueTypeArray1234 {
			yyl432 := r.ReadArrayStart()
			if yyl432 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl432, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys433Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys433Slc
	var yyhl433 bool = l >= 0
	for yyj433 := 0; ; yyj433++ {
		if yyhl433 {
			if yyj433 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys433Slc = r.DecodeBytes(yys433Slc, true, true)
		yys433 := string(yys433Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys433 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumePhase(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys433)
		} // end switch yys433
	} // end for yyj433
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj437 int
	var yyb437 bool
	var yyhl437 bool = l >= 0
	yyj437++
	if yyhl437 {
		yyb437 = yyj437 > l
	} else {
		yyb437 = r.CheckBreak()
	}
	if yyb437 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumePhase(r.DecodeString())
	}
	yyj437++
	if yyhl437 {
		yyb437 = yyj437 > l
	} else {
		yyb437 = r.CheckBreak()
	}
	if yyb437 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj437++
	if yyhl437 {
		yyb437 = yyj437 > l
	} else {
		yyb437 = r.CheckBreak()
	}
	if yyb437 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	for {
		yyj437++
		if yyhl437 {
			yyb437 = yyj437 > l
		} else {
			yyb437 = r.CheckBreak()
		}
		if yyb437 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj437-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym441 := z.EncBinary()
		_ = yym441
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep442 := !z.EncBinary()
			yy2arr442 := z.EncBasicHandle().StructToArray
			var yyq442 [4]bool
			_, _, _ = yysep442, yyq442, yy2arr442
			const yyr442 bool = false
			yyq442[0] = x.Kind != ""
			yyq442[1] = x.APIVersion != ""
			yyq442[2] = true
			var yynn442 int
			if yyr442 || yy2arr442 {
				r.EncodeArrayStart(4)
			} else {
				yynn442 = 1
				for _, b := range yyq442 {
					if b {
						yynn442++
					}
				}
				r.EncodeMapStart(yynn442)
				yynn442 = 0
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[0] {
					yym444 := z.EncBinary()
					_ = yym444
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq442[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[1] {
					yym447 := z.EncBinary()
					_ = yym447
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq442[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym448 := z.EncBinary()
					_ = yym448
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[2] {
					yy450 := &x.ListMeta
					yym451 := z.EncBinary()
					_ = yym451
					if false {
					} else if z.HasExtensions() && z.EncExt(yy450) {
					} else {
						z.EncFallback(yy450)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq442[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy452 := &x.ListMeta
					yym453 := z.EncBinary()
					_ = yym453
					if false {
					} else if z.HasExtensions() && z.EncExt(yy452) {
					} else {
						z.EncFallback(yy452)
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym455 := z.EncBinary()
					_ = yym455
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym456 := z.EncBinary()
					_ = yym456
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym457 := z.DecBinary()
	_ = yym457
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct458 := r.ContainerType()
		if yyct458 == codecSelferValueTypeMap1234 {
			yyl458 := r.ReadMapStart()
			if yyl458 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl458, d)
			}
		} else if yyct458 == codecSelferValueTypeArray1234 {
			yyl458 := r.ReadArrayStart()
			if yyl458 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl458, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys459Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys459Slc
	var yyhl459 bool = l >= 0
	for yyj459 := 0; ; yyj459++ {
		if yyhl459 {
			if yyj459 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys459Slc = r.DecodeBytes(yys459Slc, true, true)
		yys459 := string(yys459Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys459 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv462 := &x.ListMeta
				yym463 := z.DecBinary()
				_ = yym463
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv462) {
				} else {
					z.DecFallback(yyv462, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv464 := &x.Items
				yym465 := z.DecBinary()
				_ = yym465
				if false {
				} else {
					h.decSlicePersistentVolume((*[]PersistentVolume)(yyv464), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys459)
		} // end switch yys459
	} // end for yyj459
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj466 int
	var yyb466 bool
	var yyhl466 bool = l >= 0
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv469 := &x.ListMeta
		yym470 := z.DecBinary()
		_ = yym470
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv469) {
		} else {
			z.DecFallback(yyv469, false)
		}
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv471 := &x.Items
		yym472 := z.DecBinary()
		_ = yym472
		if false {
		} else {
			h.decSlicePersistentVolume((*[]PersistentVolume)(yyv471), d)
		}
	}
	for {
		yyj466++
		if yyhl466 {
			yyb466 = yyj466 > l
		} else {
			yyb466 = r.CheckBreak()
		}
		if yyb466 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj466-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaim) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym473 := z.EncBinary()
		_ = yym473
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep474 := !z.EncBinary()
			yy2arr474 := z.EncBasicHandle().StructToArray
			var yyq474 [5]bool
			_, _, _ = yysep474, yyq474, yy2arr474
			const yyr474 bool = false
			yyq474[0] = x.Kind != ""
			yyq474[1] = x.APIVersion != ""
			yyq474[2] = true
			yyq474[3] = true
			yyq474[4] = true
			var yynn474 int
			if yyr474 || yy2arr474 {
				r.EncodeArrayStart(5)
			} else {
				yynn474 = 0
				for _, b := range yyq474 {
					if b {
						yynn474++
					}
				}
				r.EncodeMapStart(yynn474)
				yynn474 = 0
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[0] {
					yym476 := z.EncBinary()
					_ = yym476
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq474[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym477 := z.EncBinary()
					_ = yym477
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[1] {
					yym479 := z.EncBinary()
					_ = yym479
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq474[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym480 := z.EncBinary()
					_ = yym480
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[2] {
					yy482 := &x.ObjectMeta
					yy482.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq474[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy483 := &x.ObjectMeta
					yy483.CodecEncodeSelf(e)
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[3] {
					yy485 := &x.Spec
					yy485.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq474[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy486 := &x.Spec
					yy486.CodecEncodeSelf(e)
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[4] {
					yy488 := &x.Status
					yy488.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq474[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy489 := &x.Status
					yy489.CodecEncodeSelf(e)
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaim) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym490 := z.DecBinary()
	_ = yym490
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct491 := r.ContainerType()
		if yyct491 == codecSelferValueTypeMap1234 {
			yyl491 := r.ReadMapStart()
			if yyl491 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl491, d)
			}
		} else if yyct491 == codecSelferValueTypeArray1234 {
			yyl491 := r.ReadArrayStart()
			if yyl491 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl491, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys492Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys492Slc
	var yyhl492 bool = l >= 0
	for yyj492 := 0; ; yyj492++ {
		if yyhl492 {
			if yyj492 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys492Slc = r.DecodeBytes(yys492Slc, true, true)
		yys492 := string(yys492Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys492 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv495 := &x.ObjectMeta
				yyv495.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeClaimSpec{}
			} else {
				yyv496 := &x.Spec
				yyv496.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeClaimStatus{}
			} else {
				yyv497 := &x.Status
				yyv497.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys492)
		} // end switch yys492
	} // end for yyj492
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj498 int
	var yyb498 bool
	var yyhl498 bool = l >= 0
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv501 := &x.ObjectMeta
		yyv501.CodecDecodeSelf(d)
	}
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeClaimSpec{}
	} else {
		yyv502 := &x.Spec
		yyv502.CodecDecodeSelf(d)
	}
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeClaimStatus{}
	} else {
		yyv503 := &x.Status
		yyv503.CodecDecodeSelf(d)
	}
	for {
		yyj498++
		if yyhl498 {
			yyb498 = yyj498 > l
		} else {
			yyb498 = r.CheckBreak()
		}
		if yyb498 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj498-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym504 := z.EncBinary()
		_ = yym504
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep505 := !z.EncBinary()
			yy2arr505 := z.EncBasicHandle().StructToArray
			var yyq505 [4]bool
			_, _, _ = yysep505, yyq505, yy2arr505
			const yyr505 bool = false
			yyq505[0] = x.Kind != ""
			yyq505[1] = x.APIVersion != ""
			yyq505[2] = true
			var yynn505 int
			if yyr505 || yy2arr505 {
				r.EncodeArrayStart(4)
			} else {
				yynn505 = 1
				for _, b := range yyq505 {
					if b {
						yynn505++
					}
				}
				r.EncodeMapStart(yynn505)
				yynn505 = 0
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq505[0] {
					yym507 := z.EncBinary()
					_ = yym507
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq505[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym508 := z.EncBinary()
					_ = yym508
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq505[1] {
					yym510 := z.EncBinary()
					_ = yym510
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq505[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym511 := z.EncBinary()
					_ = yym511
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq505[2] {
					yy513 := &x.ListMeta
					yym514 := z.EncBinary()
					_ = yym514
					if false {
					} else if z.HasExtensions() && z.EncExt(yy513) {
					} else {
						z.EncFallback(yy513)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq505[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy515 := &x.ListMeta
					yym516 := z.EncBinary()
					_ = yym516
					if false {
					} else if z.HasExtensions() && z.EncExt(yy515) {
					} else {
						z.EncFallback(yy515)
					}
				}
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym518 := z.EncBinary()
					_ = yym518
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym519 := z.EncBinary()
					_ = yym519
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym520 := z.DecBinary()
	_ = yym520
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct521 := r.ContainerType()
		if yyct521 == codecSelferValueTypeMap1234 {
			yyl521 := r.ReadMapStart()
			if yyl521 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl521, d)
			}
		} else if yyct521 == codecSelferValueTypeArray1234 {
			yyl521 := r.ReadArrayStart()
			if yyl521 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl521, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys522Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys522Slc
	var yyhl522 bool = l >= 0
	for yyj522 := 0; ; yyj522++ {
		if yyhl522 {
			if yyj522 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys522Slc = r.DecodeBytes(yys522Slc, true, true)
		yys522 := string(yys522Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys522 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv525 := &x.ListMeta
				yym526 := z.DecBinary()
				_ = yym526
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv525) {
				} else {
					z.DecFallback(yyv525, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv527 := &x.Items
				yym528 := z.DecBinary()
				_ = yym528
				if false {
				} else {
					h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv527), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys522)
		} // end switch yys522
	} // end for yyj522
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj529 int
	var yyb529 bool
	var yyhl529 bool = l >= 0
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv532 := &x.ListMeta
		yym533 := z.DecBinary()
		_ = yym533
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv532) {
		} else {
			z.DecFallback(yyv532, false)
		}
	}
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv534 := &x.Items
		yym535 := z.DecBinary()
		_ = yym535
		if false {
		} else {
			h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv534), d)
		}
	}
	for {
		yyj529++
		if yyhl529 {
			yyb529 = yyj529 > l
		} else {
			yyb529 = r.CheckBreak()
		}
		if yyb529 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj529-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym536 := z.EncBinary()
		_ = yym536
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep537 := !z.EncBinary()
			yy2arr537 := z.EncBasicHandle().StructToArray
			var yyq537 [4]bool
			_, _, _ = yysep537, yyq537, yy2arr537
			const yyr537 bool = false
			yyq537[0] = len(x.AccessModes) != 0
			yyq537[1] = x.Selector != nil
			yyq537[2] = true
			yyq537[3] = x.VolumeName != ""
			var yynn537 int
			if yyr537 || yy2arr537 {
				r.EncodeArrayStart(4)
			} else {
				yynn537 = 0
				for _, b := range yyq537 {
					if b {
						yynn537++
					}
				}
				r.EncodeMapStart(yynn537)
				yynn537 = 0
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq537[0] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym539 := z.EncBinary()
						_ = yym539
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq537[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym540 := z.EncBinary()
						_ = yym540
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq537[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym542 := z.EncBinary()
						_ = yym542
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq537[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym543 := z.EncBinary()
						_ = yym543
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq537[2] {
					yy545 := &x.Resources
					yy545.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq537[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy546 := &x.Resources
					yy546.CodecEncodeSelf(e)
				}
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq537[3] {
					yym548 := z.EncBinary()
					_ = yym548
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq537[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym549 := z.EncBinary()
					_ = yym549
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				}
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym550 := z.DecBinary()
	_ = yym550
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct551 := r.ContainerType()
		if yyct551 == codecSelferValueTypeMap1234 {
			yyl551 := r.ReadMapStart()
			if yyl551 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl551, d)
			}
		} else if yyct551 == codecSelferValueTypeArray1234 {
			yyl551 := r.ReadArrayStart()
			if yyl551 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl551, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys552Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys552Slc
	var yyhl552 bool = l >= 0
	for yyj552 := 0; ; yyj552++ {
		if yyhl552 {
			if yyj552 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys552Slc = r.DecodeBytes(yys552Slc, true, true)
		yys552 := string(yys552Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys552 {
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv553 := &x.AccessModes
				yym554 := z.DecBinary()
				_ = yym554
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv553), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg2_unversioned.LabelSelector)
				}
				yym556 := z.DecBinary()
				_ = yym556
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv557 := &x.Resources
				yyv557.CodecDecodeSelf(d)
			}
		case "volumeName":
			if r.TryDecodeAsNil() {
				x.VolumeName = ""
			} else {
				x.VolumeName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys552)
		} // end switch yys552
	} // end for yyj552
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj559 int
	var yyb559 bool
	var yyhl559 bool = l >= 0
	yyj559++
	if yyhl559 {
		yyb559 = yyj559 > l
	} else {
		yyb559 = r.CheckBreak()
	}
	if yyb559 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv560 := &x.AccessModes
		yym561 := z.DecBinary()
		_ = yym561
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv560), d)
		}
	}
	yyj559++
	if yyhl559 {
		yyb559 = yyj559 > l
	} else {
		yyb559 = r.CheckBreak()
	}
	if yyb559 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg2_unversioned.LabelSelector)
		}
		yym563 := z.DecBinary()
		_ = yym563
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj559++
	if yyhl559 {
		yyb559 = yyj559 > l
	} else {
		yyb559 = r.CheckBreak()
	}
	if yyb559 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv564 := &x.Resources
		yyv564.CodecDecodeSelf(d)
	}
	yyj559++
	if yyhl559 {
		yyb559 = yyj559 > l
	} else {
		yyb559 = r.CheckBreak()
	}
	if yyb559 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeName = ""
	} else {
		x.VolumeName = string(r.DecodeString())
	}
	for {
		yyj559++
		if yyhl559 {
			yyb559 = yyj559 > l
		} else {
			yyb559 = r.CheckBreak()
		}
		if yyb559 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj559-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym566 := z.EncBinary()
		_ = yym566
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep567 := !z.EncBinary()
			yy2arr567 := z.EncBasicHandle().StructToArray
			var yyq567 [3]bool
			_, _, _ = yysep567, yyq567, yy2arr567
			const yyr567 bool = false
			yyq567[0] = x.Phase != ""
			yyq567[1] = len(x.AccessModes) != 0
			yyq567[2] = len(x.Capacity) != 0
			var yynn567 int
			if yyr567 || yy2arr567 {
				r.EncodeArrayStart(3)
			} else {
				yynn567 = 0
				for _, b := range yyq567 {
					if b {
						yynn567++
					}
				}
				r.EncodeMapStart(yynn567)
				yynn567 = 0
			}
			if yyr567 || yy2arr567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq567[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq567[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr567 || yy2arr567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq567[1] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym570 := z.EncBinary()
						_ = yym570
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq567[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym571 := z.EncBinary()
						_ = yym571
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr567 || yy2arr567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq567[2] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq567[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr567 || yy2arr567 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym573 := z.DecBinary()
	_ = yym573
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct574 := r.ContainerType()
		if yyct574 == codecSelferValueTypeMap1234 {
			yyl574 := r.ReadMapStart()
			if yyl574 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl574, d)
			}
		} else if yyct574 == codecSelferValueTypeArray1234 {
			yyl574 := r.ReadArrayStart()
			if yyl574 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl574, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys575Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys575Slc
	var yyhl575 bool = l >= 0
	for yyj575 := 0; ; yyj575++ {
		if yyhl575 {
			if yyj575 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys575Slc = r.DecodeBytes(yys575Slc, true, true)
		yys575 := string(yys575Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys575 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv577 := &x.AccessModes
				yym578 := z.DecBinary()
				_ = yym578
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv577), d)
				}
			}
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv579 := &x.Capacity
				yyv579.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys575)
		} // end switch yys575
	} // end for yyj575
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj580 int
	var yyb580 bool
	var yyhl580 bool = l >= 0
	yyj580++
	if yyhl580 {
		yyb580 = yyj580 > l
	} else {
		yyb580 = r.CheckBreak()
	}
	if yyb580 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
	}
	yyj580++
	if yyhl580 {
		yyb580 = yyj580 > l
	} else {
		yyb580 = r.CheckBreak()
	}
	if yyb580 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv582 := &x.AccessModes
		yym583 := z.DecBinary()
		_ = yym583
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv582), d)
		}
	}
	yyj580++
	if yyhl580 {
		yyb580 = yyj580 > l
	} else {
		yyb580 = r.CheckBreak()
	}
	if yyb580 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv584 := &x.Capacity
		yyv584.CodecDecodeSelf(d)
	}
	for {
		yyj580++
		if yyhl580 {
			yyb580 = yyj580 > l
		} else {
			yyb580 = r.CheckBreak()
		}
		if yyb580 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj580-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeAccessMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym585 := z.EncBinary()
	_ = yym585
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeAccessMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym586 := z.DecBinary()
	_ = yym586
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym587 := z.EncBinary()
	_ = yym587
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym588 := z.DecBinary()
	_ = yym588
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumeClaimPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym589 := z.EncBinary()
	_ = yym589
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeClaimPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym590 := z.DecBinary()
	_ = yym590
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPathVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym591 := z.EncBinary()
		_ = yym591
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep592 := !z.EncBinary()
			yy2arr592 := z.EncBasicHandle().StructToArray
			var yyq592 [1]bool
			_, _, _ = yysep592, yyq592, yy2arr592
			const yyr592 bool = false
			var yynn592 int
			if yyr592 || yy2arr592 {
				r.EncodeArrayStart(1)
			} else {
				yynn592 = 1
				for _, b := range yyq592 {
					if b {
						yynn592++
					}
				}
				r.EncodeMapStart(yynn592)
				yynn592 = 0
			}
			if yyr592 || yy2arr592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym594 := z.EncBinary()
				_ = yym594
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym595 := z.EncBinary()
				_ = yym595
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr592 || yy2arr592 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPathVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym596 := z.DecBinary()
	_ = yym596
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct597 := r.ContainerType()
		if yyct597 == codecSelferValueTypeMap1234 {
			yyl597 := r.ReadMapStart()
			if yyl597 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl597, d)
			}
		} else if yyct597 == codecSelferValueTypeArray1234 {
			yyl597 := r.ReadArrayStart()
			if yyl597 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl597, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPathVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys598Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys598Slc
	var yyhl598 bool = l >= 0
	for yyj598 := 0; ; yyj598++ {
		if yyhl598 {
			if yyj598 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys598Slc = r.DecodeBytes(yys598Slc, true, true)
		yys598 := string(yys598Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys598 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys598)
		} // end switch yys598
	} // end for yyj598
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPathVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj600 int
	var yyb600 bool
	var yyhl600 bool = l >= 0
	yyj600++
	if yyhl600 {
		yyb600 = yyj600 > l
	} else {
		yyb600 = r.CheckBreak()
	}
	if yyb600 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	for {
		yyj600++
		if yyhl600 {
			yyb600 = yyj600 > l
		} else {
			yyb600 = r.CheckBreak()
		}
		if yyb600 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj600-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EmptyDirVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym602 := z.EncBinary()
		_ = yym602
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep603 := !z.EncBinary()
			yy2arr603 := z.EncBasicHandle().StructToArray
			var yyq603 [1]bool
			_, _, _ = yysep603, yyq603, yy2arr603
			const yyr603 bool = false
			yyq603[0] = x.Medium != ""
			var yynn603 int
			if yyr603 || yy2arr603 {
				r.EncodeArrayStart(1)
			} else {
				yynn603 = 0
				for _, b := range yyq603 {
					if b {
						yynn603++
					}
				}
				r.EncodeMapStart(yynn603)
				yynn603 = 0
			}
			if yyr603 || yy2arr603 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq603[0] {
					x.Medium.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq603[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("medium"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Medium.CodecEncodeSelf(e)
				}
			}
			if yyr603 || yy2arr603 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EmptyDirVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym605 := z.DecBinary()
	_ = yym605
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct606 := r.ContainerType()
		if yyct606 == codecSelferValueTypeMap1234 {
			yyl606 := r.ReadMapStart()
			if yyl606 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl606, d)
			}
		} else if yyct606 == codecSelferValueTypeArray1234 {
			yyl606 := r.ReadArrayStart()
			if yyl606 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl606, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys607Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys607Slc
	var yyhl607 bool = l >= 0
	for yyj607 := 0; ; yyj607++ {
		if yyhl607 {
			if yyj607 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys607Slc = r.DecodeBytes(yys607Slc, true, true)
		yys607 := string(yys607Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys607 {
		case "medium":
			if r.TryDecodeAsNil() {
				x.Medium = ""
			} else {
				x.Medium = StorageMedium(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys607)
		} // end switch yys607
	} // end for yyj607
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj609 int
	var yyb609 bool
	var yyhl609 bool = l >= 0
	yyj609++
	if yyhl609 {
		yyb609 = yyj609 > l
	} else {
		yyb609 = r.CheckBreak()
	}
	if yyb609 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Medium = ""
	} else {
		x.Medium = StorageMedium(r.DecodeString())
	}
	for {
		yyj609++
		if yyhl609 {
			yyb609 = yyj609 > l
		} else {
			yyb609 = r.CheckBreak()
		}
		if yyb609 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj609-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GlusterfsVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym611 := z.EncBinary()
		_ = yym611
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep612 := !z.EncBinary()
			yy2arr612 := z.EncBasicHandle().StructToArray
			var yyq612 [3]bool
			_, _, _ = yysep612, yyq612, yy2arr612
			const yyr612 bool = false
			yyq612[2] = x.ReadOnly != false
			var yynn612 int
			if yyr612 || yy2arr612 {
				r.EncodeArrayStart(3)
			} else {
				yynn612 = 2
				for _, b := range yyq612 {
					if b {
						yynn612++
					}
				}
				r.EncodeMapStart(yynn612)
				yynn612 = 0
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym614 := z.EncBinary()
				_ = yym614
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("endpoints"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym615 := z.EncBinary()
				_ = yym615
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym617 := z.EncBinary()
				_ = yym617
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym618 := z.EncBinary()
				_ = yym618
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq612[2] {
					yym620 := z.EncBinary()
					_ = yym620
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq612[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym621 := z.EncBinary()
					_ = yym621
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GlusterfsVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym622 := z.DecBinary()
	_ = yym622
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct623 := r.ContainerType()
		if yyct623 == codecSelferValueTypeMap1234 {
			yyl623 := r.ReadMapStart()
			if yyl623 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl623, d)
			}
		} else if yyct623 == codecSelferValueTypeArray1234 {
			yyl623 := r.ReadArrayStart()
			if yyl623 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl623, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys624Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys624Slc
	var yyhl624 bool = l >= 0
	for yyj624 := 0; ; yyj624++ {
		if yyhl624 {
			if yyj624 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys624Slc = r.DecodeBytes(yys624Slc, true, true)
		yys624 := string(yys624Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys624 {
		case "endpoints":
			if r.TryDecodeAsNil() {
				x.EndpointsName = ""
			} else {
				x.EndpointsName = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys624)
		} // end switch yys624
	} // end for yyj624
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj628 int
	var yyb628 bool
	var yyhl628 bool = l >= 0
	yyj628++
	if yyhl628 {
		yyb628 = yyj628 > l
	} else {
		yyb628 = r.CheckBreak()
	}
	if yyb628 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EndpointsName = ""
	} else {
		x.EndpointsName = string(r.DecodeString())
	}
	yyj628++
	if yyhl628 {
		yyb628 = yyj628 > l
	} else {
		yyb628 = r.CheckBreak()
	}
	if yyb628 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj628++
	if yyhl628 {
		yyb628 = yyj628 > l
	} else {
		yyb628 = r.CheckBreak()
	}
	if yyb628 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj628++
		if yyhl628 {
			yyb628 = yyj628 > l
		} else {
			yyb628 = r.CheckBreak()
		}
		if yyb628 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj628-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RBDVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym632 := z.EncBinary()
		_ = yym632
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep633 := !z.EncBinary()
			yy2arr633 := z.EncBasicHandle().StructToArray
			var yyq633 [8]bool
			_, _, _ = yysep633, yyq633, yy2arr633
			const yyr633 bool = false
			yyq633[2] = x.FSType != ""
			yyq633[3] = x.RBDPool != ""
			yyq633[4] = x.RadosUser != ""
			yyq633[5] = x.Keyring != ""
			yyq633[6] = x.SecretRef != nil
			yyq633[7] = x.ReadOnly != false
			var yynn633 int
			if yyr633 || yy2arr633 {
				r.EncodeArrayStart(8)
			} else {
				yynn633 = 2
				for _, b := range yyq633 {
					if b {
						yynn633++
					}
				}
				r.EncodeMapStart(yynn633)
				yynn633 = 0
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym635 := z.EncBinary()
					_ = yym635
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym636 := z.EncBinary()
					_ = yym636
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym638 := z.EncBinary()
				_ = yym638
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym639 := z.EncBinary()
				_ = yym639
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq633[2] {
					yym641 := z.EncBinary()
					_ = yym641
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq633[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym642 := z.EncBinary()
					_ = yym642
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq633[3] {
					yym644 := z.EncBinary()
					_ = yym644
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq633[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("pool"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym645 := z.EncBinary()
					_ = yym645
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				}
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq633[4] {
					yym647 := z.EncBinary()
					_ = yym647
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq633[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym648 := z.EncBinary()
					_ = yym648
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				}
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq633[5] {
					yym650 := z.EncBinary()
					_ = yym650
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq633[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("keyring"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym651 := z.EncBinary()
					_ = yym651
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				}
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq633[6] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq633[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq633[7] {
					yym654 := z.EncBinary()
					_ = yym654
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq633[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym655 := z.EncBinary()
					_ = yym655
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr633 || yy2arr633 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RBDVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym656 := z.DecBinary()
	_ = yym656
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct657 := r.ContainerType()
		if yyct657 == codecSelferValueTypeMap1234 {
			yyl657 := r.ReadMapStart()
			if yyl657 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl657, d)
			}
		} else if yyct657 == codecSelferValueTypeArray1234 {
			yyl657 := r.ReadArrayStart()
			if yyl657 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl657, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RBDVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys658Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys658Slc
	var yyhl658 bool = l >= 0
	for yyj658 := 0; ; yyj658++ {
		if yyhl658 {
			if yyj658 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys658Slc = r.DecodeBytes(yys658Slc, true, true)
		yys658 := string(yys658Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys658 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.CephMonitors = nil
			} else {
				yyv659 := &x.CephMonitors
				yym660 := z.DecBinary()
				_ = yym660
				if false {
				} else {
					z.F.DecSliceStringX(yyv659, false, d)
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.RBDImage = ""
			} else {
				x.RBDImage = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "pool":
			if r.TryDecodeAsNil() {
				x.RBDPool = ""
			} else {
				x.RBDPool = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.RadosUser = ""
			} else {
				x.RadosUser = string(r.DecodeString())
			}
		case "keyring":
			if r.TryDecodeAsNil() {
				x.Keyring = ""
			} else {
				x.Keyring = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys658)
		} // end switch yys658
	} // end for yyj658
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RBDVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj668 int
	var yyb668 bool
	var yyhl668 bool = l >= 0
	yyj668++
	if yyhl668 {
		yyb668 = yyj668 > l
	} else {
		yyb668 = r.CheckBreak()
	}
	if yyb668 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CephMonitors = nil
	} else {
		yyv669 := &x.CephMonitors
		yym670 := z.DecBinary()
		_ = yym670
		if false {
		} else {
			z.F.DecSliceStringX(yyv669, false, d)
		}
	}
	yyj668++
	if yyhl668 {
		yyb668 = yyj668 > l
	} else {
		yyb668 = r.CheckBreak()
	}
	if yyb668 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDImage = ""
	} else {
		x.RBDImage = string(r.DecodeString())
	}
	yyj668++
	if yyhl668 {
		yyb668 = yyj668 > l
	} else {
		yyb668 = r.CheckBreak()
	}
	if yyb668 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj668++
	if yyhl668 {
		yyb668 = yyj668 > l
	} else {
		yyb668 = r.CheckBreak()
	}
	if yyb668 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDPool = ""
	} else {
		x.RBDPool = string(r.DecodeString())
	}
	yyj668++
	if yyhl668 {
		yyb668 = yyj668 > l
	} else {
		yyb668 = r.CheckBreak()
	}
	if yyb668 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RadosUser = ""
	} else {
		x.RadosUser = string(r.DecodeString())
	}
	yyj668++
	if yyhl668 {
		yyb668 = yyj668 > l
	} else {
		yyb668 = r.CheckBreak()
	}
	if yyb668 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Keyring = ""
	} else {
		x.Keyring = string(r.DecodeString())
	}
	yyj668++
	if yyhl668 {
		yyb668 = yyj668 > l
	} else {
		yyb668 = r.CheckBreak()
	}
	if yyb668 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj668++
	if yyhl668 {
		yyb668 = yyj668 > l
	} else {
		yyb668 = r.CheckBreak()
	}
	if yyb668 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj668++
		if yyhl668 {
			yyb668 = yyj668 > l
		} else {
			yyb668 = r.CheckBreak()
		}
		if yyb668 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj668-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CinderVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym678 := z.EncBinary()
		_ = yym678
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep679 := !z.EncBinary()
			yy2arr679 := z.EncBasicHandle().StructToArray
			var yyq679 [3]bool
			_, _, _ = yysep679, yyq679, yy2arr679
			const yyr679 bool = false
			yyq679[1] = x.FSType != ""
			yyq679[2] = x.ReadOnly != false
			var yynn679 int
			if yyr679 || yy2arr679 {
				r.EncodeArrayStart(3)
			} else {
				yynn679 = 1
				for _, b := range yyq679 {
					if b {
						yynn679++
					}
				}
				r.EncodeMapStart(yynn679)
				yynn679 = 0
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym681 := z.EncBinary()
				_ = yym681
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym682 := z.EncBinary()
				_ = yym682
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq679[1] {
					yym684 := z.EncBinary()
					_ = yym684
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq679[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym685 := z.EncBinary()
					_ = yym685
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq679[2] {
					yym687 := z.EncBinary()
					_ = yym687
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq679[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym688 := z.EncBinary()
					_ = yym688
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CinderVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym689 := z.DecBinary()
	_ = yym689
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct690 := r.ContainerType()
		if yyct690 == codecSelferValueTypeMap1234 {
			yyl690 := r.ReadMapStart()
			if yyl690 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl690, d)
			}
		} else if yyct690 == codecSelferValueTypeArray1234 {
			yyl690 := r.ReadArrayStart()
			if yyl690 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl690, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CinderVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys691Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys691Slc
	var yyhl691 bool = l >= 0
	for yyj691 := 0; ; yyj691++ {
		if yyhl691 {
			if yyj691 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys691Slc = r.DecodeBytes(yys691Slc, true, true)
		yys691 := string(yys691Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys691 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys691)
		} // end switch yys691
	} // end for yyj691
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CinderVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj695 int
	var yyb695 bool
	var yyhl695 bool = l >= 0
	yyj695++
	if yyhl695 {
		yyb695 = yyj695 > l
	} else {
		yyb695 = r.CheckBreak()
	}
	if yyb695 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj695++
	if yyhl695 {
		yyb695 = yyj695 > l
	} else {
		yyb695 = r.CheckBreak()
	}
	if yyb695 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj695++
	if yyhl695 {
		yyb695 = yyj695 > l
	} else {
		yyb695 = r.CheckBreak()
	}
	if yyb695 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj695++
		if yyhl695 {
			yyb695 = yyj695 > l
		} else {
			yyb695 = r.CheckBreak()
		}
		if yyb695 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj695-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CephFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym699 := z.EncBinary()
		_ = yym699
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep700 := !z.EncBinary()
			yy2arr700 := z.EncBasicHandle().StructToArray
			var yyq700 [6]bool
			_, _, _ = yysep700, yyq700, yy2arr700
			const yyr700 bool = false
			yyq700[1] = x.Path != ""
			yyq700[2] = x.User != ""
			yyq700[3] = x.SecretFile != ""
			yyq700[4] = x.SecretRef != nil
			yyq700[5] = x.ReadOnly != false
			var yynn700 int
			if yyr700 || yy2arr700 {
				r.EncodeArrayStart(6)
			} else {
				yynn700 = 1
				for _, b := range yyq700 {
					if b {
						yynn700++
					}
				}
				r.EncodeMapStart(yynn700)
				yynn700 = 0
			}
			if yyr700 || yy2arr700 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym702 := z.EncBinary()
					_ = yym702
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym703 := z.EncBinary()
					_ = yym703
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			}
			if yyr700 || yy2arr700 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq700[1] {
					yym705 := z.EncBinary()
					_ = yym705
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq700[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym706 := z.EncBinary()
					_ = yym706
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr700 || yy2arr700 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq700[2] {
					yym708 := z.EncBinary()
					_ = yym708
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq700[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym709 := z.EncBinary()
					_ = yym709
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr700 || yy2arr700 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq700[3] {
					yym711 := z.EncBinary()
					_ = yym711
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq700[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym712 := z.EncBinary()
					_ = yym712
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				}
			}
			if yyr700 || yy2arr700 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq700[4] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq700[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr700 || yy2arr700 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq700[5] {
					yym715 := z.EncBinary()
					_ = yym715
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq700[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym716 := z.EncBinary()
					_ = yym716
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr700 || yy2arr700 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CephFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym717 := z.DecBinary()
	_ = yym717
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct718 := r.ContainerType()
		if yyct718 == codecSelferValueTypeMap1234 {
			yyl718 := r.ReadMapStart()
			if yyl718 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl718, d)
			}
		} else if yyct718 == codecSelferValueTypeArray1234 {
			yyl718 := r.ReadArrayStart()
			if yyl718 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl718, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CephFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys719Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys719Slc
	var yyhl719 bool = l >= 0
	for yyj719 := 0; ; yyj719++ {
		if yyhl719 {
			if yyj719 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys719Slc = r.DecodeBytes(yys719Slc, true, true)
		yys719 := string(yys719Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys719 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.Monitors = nil
			} else {
				yyv720 := &x.Monitors
				yym721 := z.DecBinary()
				_ = yym721
				if false {
				} else {
					z.F.DecSliceStringX(yyv720, false, d)
				}
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "secretFile":
			if r.TryDecodeAsNil() {
				x.SecretFile = ""
			} else {
				x.SecretFile = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys719)
		} // end switch yys719
	} // end for yyj719
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CephFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj727 int
	var yyb727 bool
	var yyhl727 bool = l >= 0
	yyj727++
	if yyhl727 {
		yyb727 = yyj727 > l
	} else {
		yyb727 = r.CheckBreak()
	}
	if yyb727 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Monitors = nil
	} else {
		yyv728 := &x.Monitors
		yym729 := z.DecBinary()
		_ = yym729
		if false {
		} else {
			z.F.DecSliceStringX(yyv728, false, d)
		}
	}
	yyj727++
	if yyhl727 {
		yyb727 = yyj727 > l
	} else {
		yyb727 = r.CheckBreak()
	}
	if yyb727 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj727++
	if yyhl727 {
		yyb727 = yyj727 > l
	} else {
		yyb727 = r.CheckBreak()
	}
	if yyb727 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj727++
	if yyhl727 {
		yyb727 = yyj727 > l
	} else {
		yyb727 = r.CheckBreak()
	}
	if yyb727 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretFile = ""
	} else {
		x.SecretFile = string(r.DecodeString())
	}
	yyj727++
	if yyhl727 {
		yyb727 = yyj727 > l
	} else {
		yyb727 = r.CheckBreak()
	}
	if yyb727 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj727++
	if yyhl727 {
		yyb727 = yyj727 > l
	} else {
		yyb727 = r.CheckBreak()
	}
	if yyb727 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj727++
		if yyhl727 {
			yyb727 = yyj727 > l
		} else {
			yyb727 = r.CheckBreak()
		}
		if yyb727 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj727-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlockerVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym735 := z.EncBinary()
		_ = yym735
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep736 := !z.EncBinary()
			yy2arr736 := z.EncBasicHandle().StructToArray
			var yyq736 [1]bool
			_, _, _ = yysep736, yyq736, yy2arr736
			const yyr736 bool = false
			var yynn736 int
			if yyr736 || yy2arr736 {
				r.EncodeArrayStart(1)
			} else {
				yynn736 = 1
				for _, b := range yyq736 {
					if b {
						yynn736++
					}
				}
				r.EncodeMapStart(yynn736)
				yynn736 = 0
			}
			if yyr736 || yy2arr736 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym738 := z.EncBinary()
				_ = yym738
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("datasetName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym739 := z.EncBinary()
				_ = yym739
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
				}
			}
			if yyr736 || yy2arr736 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlockerVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym740 := z.DecBinary()
	_ = yym740
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct741 := r.ContainerType()
		if yyct741 == codecSelferValueTypeMap1234 {
			yyl741 := r.ReadMapStart()
			if yyl741 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl741, d)
			}
		} else if yyct741 == codecSelferValueTypeArray1234 {
			yyl741 := r.ReadArrayStart()
			if yyl741 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl741, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlockerVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys742Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys742Slc
	var yyhl742 bool = l >= 0
	for yyj742 := 0; ; yyj742++ {
		if yyhl742 {
			if yyj742 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys742Slc = r.DecodeBytes(yys742Slc, true, true)
		yys742 := string(yys742Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys742 {
		case "datasetName":
			if r.TryDecodeAsNil() {
				x.DatasetName = ""
			} else {
				x.DatasetName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys742)
		} // end switch yys742
	} // end for yyj742
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlockerVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj744 int
	var yyb744 bool
	var yyhl744 bool = l >= 0
	yyj744++
	if yyhl744 {
		yyb744 = yyj744 > l
	} else {
		yyb744 = r.CheckBreak()
	}
	if yyb744 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetName = ""
	} else {
		x.DatasetName = string(r.DecodeString())
	}
	for {
		yyj744++
		if yyhl744 {
			yyb744 = yyj744 > l
		} else {
			yyb744 = r.CheckBreak()
		}
		if yyb744 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj744-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x StorageMedium) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym746 := z.EncBinary()
	_ = yym746
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *StorageMedium) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym747 := z.DecBinary()
	_ = yym747
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Protocol) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym748 := z.EncBinary()
	_ = yym748
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Protocol) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym749 := z.DecBinary()
	_ = yym749
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym750 := z.EncBinary()
		_ = yym750
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep751 := !z.EncBinary()
			yy2arr751 := z.EncBasicHandle().StructToArray
			var yyq751 [4]bool
			_, _, _ = yysep751, yyq751, yy2arr751
			const yyr751 bool = false
			yyq751[1] = x.FSType != ""
			yyq751[2] = x.Partition != 0
			yyq751[3] = x.ReadOnly != false
			var yynn751 int
			if yyr751 || yy2arr751 {
				r.EncodeArrayStart(4)
			} else {
				yynn751 = 1
				for _, b := range yyq751 {
					if b {
						yynn751++
					}
				}
				r.EncodeMapStart(yynn751)
				yynn751 = 0
			}
			if yyr751 || yy2arr751 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym753 := z.EncBinary()
				_ = yym753
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym754 := z.EncBinary()
				_ = yym754
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			}
			if yyr751 || yy2arr751 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq751[1] {
					yym756 := z.EncBinary()
					_ = yym756
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq751[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym757 := z.EncBinary()
					_ = yym757
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr751 || yy2arr751 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq751[2] {
					yym759 := z.EncBinary()
					_ = yym759
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq751[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym760 := z.EncBinary()
					_ = yym760
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr751 || yy2arr751 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq751[3] {
					yym762 := z.EncBinary()
					_ = yym762
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq751[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym763 := z.EncBinary()
					_ = yym763
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr751 || yy2arr751 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym764 := z.DecBinary()
	_ = yym764
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct765 := r.ContainerType()
		if yyct765 == codecSelferValueTypeMap1234 {
			yyl765 := r.ReadMapStart()
			if yyl765 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl765, d)
			}
		} else if yyct765 == codecSelferValueTypeArray1234 {
			yyl765 := r.ReadArrayStart()
			if yyl765 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl765, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys766Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys766Slc
	var yyhl766 bool = l >= 0
	for yyj766 := 0; ; yyj766++ {
		if yyhl766 {
			if yyj766 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys766Slc = r.DecodeBytes(yys766Slc, true, true)
		yys766 := string(yys766Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys766 {
		case "pdName":
			if r.TryDecodeAsNil() {
				x.PDName = ""
			} else {
				x.PDName = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys766)
		} // end switch yys766
	} // end for yyj766
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj771 int
	var yyb771 bool
	var yyhl771 bool = l >= 0
	yyj771++
	if yyhl771 {
		yyb771 = yyj771 > l
	} else {
		yyb771 = r.CheckBreak()
	}
	if yyb771 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PDName = ""
	} else {
		x.PDName = string(r.DecodeString())
	}
	yyj771++
	if yyhl771 {
		yyb771 = yyj771 > l
	} else {
		yyb771 = r.CheckBreak()
	}
	if yyb771 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj771++
	if yyhl771 {
		yyb771 = yyj771 > l
	} else {
		yyb771 = r.CheckBreak()
	}
	if yyb771 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj771++
	if yyhl771 {
		yyb771 = yyj771 > l
	} else {
		yyb771 = r.CheckBreak()
	}
	if yyb771 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj771++
		if yyhl771 {
			yyb771 = yyj771 > l
		} else {
			yyb771 = r.CheckBreak()
		}
		if yyb771 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj771-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *QuobyteVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym776 := z.EncBinary()
		_ = yym776
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep777 := !z.EncBinary()
			yy2arr777 := z.EncBasicHandle().StructToArray
			var yyq777 [5]bool
			_, _, _ = yysep777, yyq777, yy2arr777
			const yyr777 bool = false
			yyq777[2] = x.ReadOnly != false
			yyq777[3] = x.User != ""
			yyq777[4] = x.Group != ""
			var yynn777 int
			if yyr777 || yy2arr777 {
				r.EncodeArrayStart(5)
			} else {
				yynn777 = 2
				for _, b := range yyq777 {
					if b {
						yynn777++
					}
				}
				r.EncodeMapStart(yynn777)
				yynn777 = 0
			}
			if yyr777 || yy2arr777 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym779 := z.EncBinary()
				_ = yym779
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym780 := z.EncBinary()
				_ = yym780
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			}
			if yyr777 || yy2arr777 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym782 := z.EncBinary()
				_ = yym782
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volume"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym783 := z.EncBinary()
				_ = yym783
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			}
			if yyr777 || yy2arr777 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq777[2] {
					yym785 := z.EncBinary()
					_ = yym785
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq777[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym786 := z.EncBinary()
					_ = yym786
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr777 || yy2arr777 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq777[3] {
					yym788 := z.EncBinary()
					_ = yym788
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq777[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym789 := z.EncBinary()
					_ = yym789
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr777 || yy2arr777 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq777[4] {
					yym791 := z.EncBinary()
					_ = yym791
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq777[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("group"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym792 := z.EncBinary()
					_ = yym792
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				}
			}
			if yyr777 || yy2arr777 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *QuobyteVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym793 := z.DecBinary()
	_ = yym793
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct794 := r.ContainerType()
		if yyct794 == codecSelferValueTypeMap1234 {
			yyl794 := r.ReadMapStart()
			if yyl794 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl794, d)
			}
		} else if yyct794 == codecSelferValueTypeArray1234 {
			yyl794 := r.ReadArrayStart()
			if yyl794 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl794, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys795Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys795Slc
	var yyhl795 bool = l >= 0
	for yyj795 := 0; ; yyj795++ {
		if yyhl795 {
			if yyj795 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys795Slc = r.DecodeBytes(yys795Slc, true, true)
		yys795 := string(yys795Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys795 {
		case "registry":
			if r.TryDecodeAsNil() {
				x.Registry = ""
			} else {
				x.Registry = string(r.DecodeString())
			}
		case "volume":
			if r.TryDecodeAsNil() {
				x.Volume = ""
			} else {
				x.Volume = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "group":
			if r.TryDecodeAsNil() {
				x.Group = ""
			} else {
				x.Group = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys795)
		} // end switch yys795
	} // end for yyj795
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj801 int
	var yyb801 bool
	var yyhl801 bool = l >= 0
	yyj801++
	if yyhl801 {
		yyb801 = yyj801 > l
	} else {
		yyb801 = r.CheckBreak()
	}
	if yyb801 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Registry = ""
	} else {
		x.Registry = string(r.DecodeString())
	}
	yyj801++
	if yyhl801 {
		yyb801 = yyj801 > l
	} else {
		yyb801 = r.CheckBreak()
	}
	if yyb801 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volume = ""
	} else {
		x.Volume = string(r.DecodeString())
	}
	yyj801++
	if yyhl801 {
		yyb801 = yyj801 > l
	} else {
		yyb801 = r.CheckBreak()
	}
	if yyb801 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj801++
	if yyhl801 {
		yyb801 = yyj801 > l
	} else {
		yyb801 = r.CheckBreak()
	}
	if yyb801 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj801++
	if yyhl801 {
		yyb801 = yyj801 > l
	} else {
		yyb801 = r.CheckBreak()
	}
	if yyb801 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Group = ""
	} else {
		x.Group = string(r.DecodeString())
	}
	for {
		yyj801++
		if yyhl801 {
			yyb801 = yyj801 > l
		} else {
			yyb801 = r.CheckBreak()
		}
		if yyb801 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj801-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlexVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym807 := z.EncBinary()
		_ = yym807
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep808 := !z.EncBinary()
			yy2arr808 := z.EncBasicHandle().StructToArray
			var yyq808 [5]bool
			_, _, _ = yysep808, yyq808, yy2arr808
			const yyr808 bool = false
			yyq808[1] = x.FSType != ""
			yyq808[2] = x.SecretRef != nil
			yyq808[3] = x.ReadOnly != false
			yyq808[4] = len(x.Options) != 0
			var yynn808 int
			if yyr808 || yy2arr808 {
				r.EncodeArrayStart(5)
			} else {
				yynn808 = 1
				for _, b := range yyq808 {
					if b {
						yynn808++
					}
				}
				r.EncodeMapStart(yynn808)
				yynn808 = 0
			}
			if yyr808 || yy2arr808 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym810 := z.EncBinary()
				_ = yym810
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("driver"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym811 := z.EncBinary()
				_ = yym811
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			}
			if yyr808 || yy2arr808 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq808[1] {
					yym813 := z.EncBinary()
					_ = yym813
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq808[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym814 := z.EncBinary()
					_ = yym814
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr808 || yy2arr808 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq808[2] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq808[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr808 || yy2arr808 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq808[3] {
					yym817 := z.EncBinary()
					_ = yym817
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq808[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym818 := z.EncBinary()
					_ = yym818
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr808 || yy2arr808 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq808[4] {
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym820 := z.EncBinary()
						_ = yym820
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq808[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("options"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym821 := z.EncBinary()
						_ = yym821
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				}
			}
			if yyr808 || yy2arr808 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlexVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym822 := z.DecBinary()
	_ = yym822
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct823 := r.ContainerType()
		if yyct823 == codecSelferValueTypeMap1234 {
			yyl823 := r.ReadMapStart()
			if yyl823 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl823, d)
			}
		} else if yyct823 == codecSelferValueTypeArray1234 {
			yyl823 := r.ReadArrayStart()
			if yyl823 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl823, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlexVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys824Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys824Slc
	var yyhl824 bool = l >= 0
	for yyj824 := 0; ; yyj824++ {
		if yyhl824 {
			if yyj824 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys824Slc = r.DecodeBytes(yys824Slc, true, true)
		yys824 := string(yys824Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys824 {
		case "driver":
			if r.TryDecodeAsNil() {
				x.Driver = ""
			} else {
				x.Driver = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "options":
			if r.TryDecodeAsNil() {
				x.Options = nil
			} else {
				yyv829 := &x.Options
				yym830 := z.DecBinary()
				_ = yym830
				if false {
				} else {
					z.F.DecMapStringStringX(yyv829, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys824)
		} // end switch yys824
	} // end for yyj824
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlexVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj831 int
	var yyb831 bool
	var yyhl831 bool = l >= 0
	yyj831++
	if yyhl831 {
		yyb831 = yyj831 > l
	} else {
		yyb831 = r.CheckBreak()
	}
	if yyb831 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Driver = ""
	} else {
		x.Driver = string(r.DecodeString())
	}
	yyj831++
	if yyhl831 {
		yyb831 = yyj831 > l
	} else {
		yyb831 = r.CheckBreak()
	}
	if yyb831 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj831++
	if yyhl831 {
		yyb831 = yyj831 > l
	} else {
		yyb831 = r.CheckBreak()
	}
	if yyb831 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj831++
	if yyhl831 {
		yyb831 = yyj831 > l
	} else {
		yyb831 = r.CheckBreak()
	}
	if yyb831 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj831++
	if yyhl831 {
		yyb831 = yyj831 > l
	} else {
		yyb831 = r.CheckBreak()
	}
	if yyb831 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Options = nil
	} else {
		yyv836 := &x.Options
		yym837 := z.DecBinary()
		_ = yym837
		if false {
		} else {
			z.F.DecMapStringStringX(yyv836, false, d)
		}
	}
	for {
		yyj831++
		if yyhl831 {
			yyb831 = yyj831 > l
		} else {
			yyb831 = r.CheckBreak()
		}
		if yyb831 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj831-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym838 := z.EncBinary()
		_ = yym838
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep839 := !z.EncBinary()
			yy2arr839 := z.EncBasicHandle().StructToArray
			var yyq839 [4]bool
			_, _, _ = yysep839, yyq839, yy2arr839
			const yyr839 bool = false
			yyq839[1] = x.FSType != ""
			yyq839[2] = x.Partition != 0
			yyq839[3] = x.ReadOnly != false
			var yynn839 int
			if yyr839 || yy2arr839 {
				r.EncodeArrayStart(4)
			} else {
				yynn839 = 1
				for _, b := range yyq839 {
					if b {
						yynn839++
					}
				}
				r.EncodeMapStart(yynn839)
				yynn839 = 0
			}
			if yyr839 || yy2arr839 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym841 := z.EncBinary()
				_ = yym841
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym842 := z.EncBinary()
				_ = yym842
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr839 || yy2arr839 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq839[1] {
					yym844 := z.EncBinary()
					_ = yym844
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq839[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym845 := z.EncBinary()
					_ = yym845
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr839 || yy2arr839 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq839[2] {
					yym847 := z.EncBinary()
					_ = yym847
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq839[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym848 := z.EncBinary()
					_ = yym848
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr839 || yy2arr839 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq839[3] {
					yym850 := z.EncBinary()
					_ = yym850
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq839[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym851 := z.EncBinary()
					_ = yym851
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr839 || yy2arr839 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym852 := z.DecBinary()
	_ = yym852
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct853 := r.ContainerType()
		if yyct853 == codecSelferValueTypeMap1234 {
			yyl853 := r.ReadMapStart()
			if yyl853 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl853, d)
			}
		} else if yyct853 == codecSelferValueTypeArray1234 {
			yyl853 := r.ReadArrayStart()
			if yyl853 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl853, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys854Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys854Slc
	var yyhl854 bool = l >= 0
	for yyj854 := 0; ; yyj854++ {
		if yyhl854 {
			if yyj854 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys854Slc = r.DecodeBytes(yys854Slc, true, true)
		yys854 := string(yys854Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys854 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys854)
		} // end switch yys854
	} // end for yyj854
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj859 int
	var yyb859 bool
	var yyhl859 bool = l >= 0
	yyj859++
	if yyhl859 {
		yyb859 = yyj859 > l
	} else {
		yyb859 = r.CheckBreak()
	}
	if yyb859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj859++
	if yyhl859 {
		yyb859 = yyj859 > l
	} else {
		yyb859 = r.CheckBreak()
	}
	if yyb859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj859++
	if yyhl859 {
		yyb859 = yyj859 > l
	} else {
		yyb859 = r.CheckBreak()
	}
	if yyb859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj859++
	if yyhl859 {
		yyb859 = yyj859 > l
	} else {
		yyb859 = r.CheckBreak()
	}
	if yyb859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj859++
		if yyhl859 {
			yyb859 = yyj859 > l
		} else {
			yyb859 = r.CheckBreak()
		}
		if yyb859 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj859-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GitRepoVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym864 := z.EncBinary()
		_ = yym864
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep865 := !z.EncBinary()
			yy2arr865 := z.EncBasicHandle().StructToArray
			var yyq865 [3]bool
			_, _, _ = yysep865, yyq865, yy2arr865
			const yyr865 bool = false
			yyq865[1] = x.Revision != ""
			yyq865[2] = x.Directory != ""
			var yynn865 int
			if yyr865 || yy2arr865 {
				r.EncodeArrayStart(3)
			} else {
				yynn865 = 1
				for _, b := range yyq865 {
					if b {
						yynn865++
					}
				}
				r.EncodeMapStart(yynn865)
				yynn865 = 0
			}
			if yyr865 || yy2arr865 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym867 := z.EncBinary()
				_ = yym867
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("repository"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym868 := z.EncBinary()
				_ = yym868
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			}
			if yyr865 || yy2arr865 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq865[1] {
					yym870 := z.EncBinary()
					_ = yym870
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq865[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym871 := z.EncBinary()
					_ = yym871
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				}
			}
			if yyr865 || yy2arr865 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq865[2] {
					yym873 := z.EncBinary()
					_ = yym873
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq865[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("directory"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym874 := z.EncBinary()
					_ = yym874
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				}
			}
			if yyr865 || yy2arr865 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GitRepoVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym875 := z.DecBinary()
	_ = yym875
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct876 := r.ContainerType()
		if yyct876 == codecSelferValueTypeMap1234 {
			yyl876 := r.ReadMapStart()
			if yyl876 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl876, d)
			}
		} else if yyct876 == codecSelferValueTypeArray1234 {
			yyl876 := r.ReadArrayStart()
			if yyl876 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl876, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys877Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys877Slc
	var yyhl877 bool = l >= 0
	for yyj877 := 0; ; yyj877++ {
		if yyhl877 {
			if yyj877 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys877Slc = r.DecodeBytes(yys877Slc, true, true)
		yys877 := string(yys877Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys877 {
		case "repository":
			if r.TryDecodeAsNil() {
				x.Repository = ""
			} else {
				x.Repository = string(r.DecodeString())
			}
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = ""
			} else {
				x.Revision = string(r.DecodeString())
			}
		case "directory":
			if r.TryDecodeAsNil() {
				x.Directory = ""
			} else {
				x.Directory = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys877)
		} // end switch yys877
	} // end for yyj877
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj881 int
	var yyb881 bool
	var yyhl881 bool = l >= 0
	yyj881++
	if yyhl881 {
		yyb881 = yyj881 > l
	} else {
		yyb881 = r.CheckBreak()
	}
	if yyb881 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Repository = ""
	} else {
		x.Repository = string(r.DecodeString())
	}
	yyj881++
	if yyhl881 {
		yyb881 = yyj881 > l
	} else {
		yyb881 = r.CheckBreak()
	}
	if yyb881 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = ""
	} else {
		x.Revision = string(r.DecodeString())
	}
	yyj881++
	if yyhl881 {
		yyb881 = yyj881 > l
	} else {
		yyb881 = r.CheckBreak()
	}
	if yyb881 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Directory = ""
	} else {
		x.Directory = string(r.DecodeString())
	}
	for {
		yyj881++
		if yyhl881 {
			yyb881 = yyj881 > l
		} else {
			yyb881 = r.CheckBreak()
		}
		if yyb881 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj881-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym885 := z.EncBinary()
		_ = yym885
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep886 := !z.EncBinary()
			yy2arr886 := z.EncBasicHandle().StructToArray
			var yyq886 [3]bool
			_, _, _ = yysep886, yyq886, yy2arr886
			const yyr886 bool = false
			yyq886[0] = x.SecretName != ""
			yyq886[1] = len(x.Items) != 0
			yyq886[2] = x.DefaultMode != nil
			var yynn886 int
			if yyr886 || yy2arr886 {
				r.EncodeArrayStart(3)
			} else {
				yynn886 = 0
				for _, b := range yyq886 {
					if b {
						yynn886++
					}
				}
				r.EncodeMapStart(yynn886)
				yynn886 = 0
			}
			if yyr886 || yy2arr886 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq886[0] {
					yym888 := z.EncBinary()
					_ = yym888
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq886[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym889 := z.EncBinary()
					_ = yym889
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr886 || yy2arr886 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq886[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym891 := z.EncBinary()
						_ = yym891
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq886[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym892 := z.EncBinary()
						_ = yym892
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr886 || yy2arr886 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq886[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy894 := *x.DefaultMode
						yym895 := z.EncBinary()
						_ = yym895
						if false {
						} else {
							r.EncodeInt(int64(yy894))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq886[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy896 := *x.DefaultMode
						yym897 := z.EncBinary()
						_ = yym897
						if false {
						} else {
							r.EncodeInt(int64(yy896))
						}
					}
				}
			}
			if yyr886 || yy2arr886 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym898 := z.DecBinary()
	_ = yym898
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct899 := r.ContainerType()
		if yyct899 == codecSelferValueTypeMap1234 {
			yyl899 := r.ReadMapStart()
			if yyl899 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl899, d)
			}
		} else if yyct899 == codecSelferValueTypeArray1234 {
			yyl899 := r.ReadArrayStart()
			if yyl899 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl899, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys900Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys900Slc
	var yyhl900 bool = l >= 0
	for yyj900 := 0; ; yyj900++ {
		if yyhl900 {
			if yyj900 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys900Slc = r.DecodeBytes(yys900Slc, true, true)
		yys900 := string(yys900Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys900 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv902 := &x.Items
				yym903 := z.DecBinary()
				_ = yym903
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv902), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym905 := z.DecBinary()
				_ = yym905
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys900)
		} // end switch yys900
	} // end for yyj900
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj906 int
	var yyb906 bool
	var yyhl906 bool = l >= 0
	yyj906++
	if yyhl906 {
		yyb906 = yyj906 > l
	} else {
		yyb906 = r.CheckBreak()
	}
	if yyb906 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	yyj906++
	if yyhl906 {
		yyb906 = yyj906 > l
	} else {
		yyb906 = r.CheckBreak()
	}
	if yyb906 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv908 := &x.Items
		yym909 := z.DecBinary()
		_ = yym909
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv908), d)
		}
	}
	yyj906++
	if yyhl906 {
		yyb906 = yyj906 > l
	} else {
		yyb906 = r.CheckBreak()
	}
	if yyb906 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym911 := z.DecBinary()
		_ = yym911
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj906++
		if yyhl906 {
			yyb906 = yyj906 > l
		} else {
			yyb906 = r.CheckBreak()
		}
		if yyb906 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj906-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym912 := z.EncBinary()
		_ = yym912
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep913 := !z.EncBinary()
			yy2arr913 := z.EncBasicHandle().StructToArray
			var yyq913 [3]bool
			_, _, _ = yysep913, yyq913, yy2arr913
			const yyr913 bool = false
			yyq913[2] = x.ReadOnly != false
			var yynn913 int
			if yyr913 || yy2arr913 {
				r.EncodeArrayStart(3)
			} else {
				yynn913 = 2
				for _, b := range yyq913 {
					if b {
						yynn913++
					}
				}
				r.EncodeMapStart(yynn913)
				yynn913 = 0
			}
			if yyr913 || yy2arr913 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym915 := z.EncBinary()
				_ = yym915
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("server"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym916 := z.EncBinary()
				_ = yym916
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			}
			if yyr913 || yy2arr913 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym918 := z.EncBinary()
				_ = yym918
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym919 := z.EncBinary()
				_ = yym919
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr913 || yy2arr913 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq913[2] {
					yym921 := z.EncBinary()
					_ = yym921
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq913[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym922 := z.EncBinary()
					_ = yym922
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr913 || yy2arr913 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym923 := z.DecBinary()
	_ = yym923
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct924 := r.ContainerType()
		if yyct924 == codecSelferValueTypeMap1234 {
			yyl924 := r.ReadMapStart()
			if yyl924 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl924, d)
			}
		} else if yyct924 == codecSelferValueTypeArray1234 {
			yyl924 := r.ReadArrayStart()
			if yyl924 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl924, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys925Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys925Slc
	var yyhl925 bool = l >= 0
	for yyj925 := 0; ; yyj925++ {
		if yyhl925 {
			if yyj925 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys925Slc = r.DecodeBytes(yys925Slc, true, true)
		yys925 := string(yys925Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys925 {
		case "server":
			if r.TryDecodeAsNil() {
				x.Server = ""
			} else {
				x.Server = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys925)
		} // end switch yys925
	} // end for yyj925
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj929 int
	var yyb929 bool
	var yyhl929 bool = l >= 0
	yyj929++
	if yyhl929 {
		yyb929 = yyj929 > l
	} else {
		yyb929 = r.CheckBreak()
	}
	if yyb929 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Server = ""
	} else {
		x.Server = string(r.DecodeString())
	}
	yyj929++
	if yyhl929 {
		yyb929 = yyj929 > l
	} else {
		yyb929 = r.CheckBreak()
	}
	if yyb929 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj929++
	if yyhl929 {
		yyb929 = yyj929 > l
	} else {
		yyb929 = r.CheckBreak()
	}
	if yyb929 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj929++
		if yyhl929 {
			yyb929 = yyj929 > l
		} else {
			yyb929 = r.CheckBreak()
		}
		if yyb929 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj929-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ISCSIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym933 := z.EncBinary()
		_ = yym933
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep934 := !z.EncBinary()
			yy2arr934 := z.EncBasicHandle().StructToArray
			var yyq934 [6]bool
			_, _, _ = yysep934, yyq934, yy2arr934
			const yyr934 bool = false
			yyq934[3] = x.ISCSIInterface != ""
			yyq934[4] = x.FSType != ""
			yyq934[5] = x.ReadOnly != false
			var yynn934 int
			if yyr934 || yy2arr934 {
				r.EncodeArrayStart(6)
			} else {
				yynn934 = 3
				for _, b := range yyq934 {
					if b {
						yynn934++
					}
				}
				r.EncodeMapStart(yynn934)
				yynn934 = 0
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym936 := z.EncBinary()
				_ = yym936
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPortal"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym937 := z.EncBinary()
				_ = yym937
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym939 := z.EncBinary()
				_ = yym939
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iqn"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym940 := z.EncBinary()
				_ = yym940
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym942 := z.EncBinary()
				_ = yym942
				if false {
				} else {
					r.EncodeInt(int64(x.Lun))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym943 := z.EncBinary()
				_ = yym943
				if false {
				} else {
					r.EncodeInt(int64(x.Lun))
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq934[3] {
					yym945 := z.EncBinary()
					_ = yym945
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq934[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsiInterface"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym946 := z.EncBinary()
					_ = yym946
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq934[4] {
					yym948 := z.EncBinary()
					_ = yym948
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq934[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym949 := z.EncBinary()
					_ = yym949
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq934[5] {
					yym951 := z.EncBinary()
					_ = yym951
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq934[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym952 := z.EncBinary()
					_ = yym952
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ISCSIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym953 := z.DecBinary()
	_ = yym953
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct954 := r.ContainerType()
		if yyct954 == codecSelferValueTypeMap1234 {
			yyl954 := r.ReadMapStart()
			if yyl954 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl954, d)
			}
		} else if yyct954 == codecSelferValueTypeArray1234 {
			yyl954 := r.ReadArrayStart()
			if yyl954 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl954, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys955Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys955Slc
	var yyhl955 bool = l >= 0
	for yyj955 := 0; ; yyj955++ {
		if yyhl955 {
			if yyj955 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys955Slc = r.DecodeBytes(yys955Slc, true, true)
		yys955 := string(yys955Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys955 {
		case "targetPortal":
			if r.TryDecodeAsNil() {
				x.TargetPortal = ""
			} else {
				x.TargetPortal = string(r.DecodeString())
			}
		case "iqn":
			if r.TryDecodeAsNil() {
				x.IQN = ""
			} else {
				x.IQN = string(r.DecodeString())
			}
		case "lun":
			if r.TryDecodeAsNil() {
				x.Lun = 0
			} else {
				x.Lun = int32(r.DecodeInt(32))
			}
		case "iscsiInterface":
			if r.TryDecodeAsNil() {
				x.ISCSIInterface = ""
			} else {
				x.ISCSIInterface = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys955)
		} // end switch yys955
	} // end for yyj955
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj962 int
	var yyb962 bool
	var yyhl962 bool = l >= 0
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPortal = ""
	} else {
		x.TargetPortal = string(r.DecodeString())
	}
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IQN = ""
	} else {
		x.IQN = string(r.DecodeString())
	}
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Lun = 0
	} else {
		x.Lun = int32(r.DecodeInt(32))
	}
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ISCSIInterface = ""
	} else {
		x.ISCSIInterface = string(r.DecodeString())
	}
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj962++
		if yyhl962 {
			yyb962 = yyj962 > l
		} else {
			yyb962 = r.CheckBreak()
		}
		if yyb962 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj962-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FCVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym969 := z.EncBinary()
		_ = yym969
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep970 := !z.EncBinary()
			yy2arr970 := z.EncBasicHandle().StructToArray
			var yyq970 [4]bool
			_, _, _ = yysep970, yyq970, yy2arr970
			const yyr970 bool = false
			yyq970[2] = x.FSType != ""
			yyq970[3] = x.ReadOnly != false
			var yynn970 int
			if yyr970 || yy2arr970 {
				r.EncodeArrayStart(4)
			} else {
				yynn970 = 2
				for _, b := range yyq970 {
					if b {
						yynn970++
					}
				}
				r.EncodeMapStart(yynn970)
				yynn970 = 0
			}
			if yyr970 || yy2arr970 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym972 := z.EncBinary()
					_ = yym972
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetWWNs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym973 := z.EncBinary()
					_ = yym973
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			}
			if yyr970 || yy2arr970 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy975 := *x.Lun
					yym976 := z.EncBinary()
					_ = yym976
					if false {
					} else {
						r.EncodeInt(int64(yy975))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy977 := *x.Lun
					yym978 := z.EncBinary()
					_ = yym978
					if false {
					} else {
						r.EncodeInt(int64(yy977))
					}
				}
			}
			if yyr970 || yy2arr970 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq970[2] {
					yym980 := z.EncBinary()
					_ = yym980
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq970[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym981 := z.EncBinary()
					_ = yym981
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr970 || yy2arr970 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq970[3] {
					yym983 := z.EncBinary()
					_ = yym983
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq970[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym984 := z.EncBinary()
					_ = yym984
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr970 || yy2arr970 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FCVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym985 := z.DecBinary()
	_ = yym985
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct986 := r.ContainerType()
		if yyct986 == codecSelferValueTypeMap1234 {
			yyl986 := r.ReadMapStart()
			if yyl986 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl986, d)
			}
		} else if yyct986 == codecSelferValueTypeArray1234 {
			yyl986 := r.ReadArrayStart()
			if yyl986 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl986, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FCVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys987Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys987Slc
	var yyhl987 bool = l >= 0
	for yyj987 := 0; ; yyj987++ {
		if yyhl987 {
			if yyj987 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys987Slc = r.DecodeBytes(yys987Slc, true, true)
		yys987 := string(yys987Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys987 {
		case "targetWWNs":
			if r.TryDecodeAsNil() {
				x.TargetWWNs = nil
			} else {
				yyv988 := &x.TargetWWNs
				yym989 := z.DecBinary()
				_ = yym989
				if false {
				} else {
					z.F.DecSliceStringX(yyv988, false, d)
				}
			}
		case "lun":
			if r.TryDecodeAsNil() {
				if x.Lun != nil {
					x.Lun = nil
				}
			} else {
				if x.Lun == nil {
					x.Lun = new(int32)
				}
				yym991 := z.DecBinary()
				_ = yym991
				if false {
				} else {
					*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys987)
		} // end switch yys987
	} // end for yyj987
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FCVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj994 int
	var yyb994 bool
	var yyhl994 bool = l >= 0
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetWWNs = nil
	} else {
		yyv995 := &x.TargetWWNs
		yym996 := z.DecBinary()
		_ = yym996
		if false {
		} else {
			z.F.DecSliceStringX(yyv995, false, d)
		}
	}
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lun != nil {
			x.Lun = nil
		}
	} else {
		if x.Lun == nil {
			x.Lun = new(int32)
		}
		yym998 := z.DecBinary()
		_ = yym998
		if false {
		} else {
			*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
		}
	}
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj994++
		if yyhl994 {
			yyb994 = yyj994 > l
		} else {
			yyb994 = r.CheckBreak()
		}
		if yyb994 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj994-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AzureFileVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1001 := z.EncBinary()
		_ = yym1001
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1002 := !z.EncBinary()
			yy2arr1002 := z.EncBasicHandle().StructToArray
			var yyq1002 [3]bool
			_, _, _ = yysep1002, yyq1002, yy2arr1002
			const yyr1002 bool = false
			yyq1002[2] = x.ReadOnly != false
			var yynn1002 int
			if yyr1002 || yy2arr1002 {
				r.EncodeArrayStart(3)
			} else {
				yynn1002 = 2
				for _, b := range yyq1002 {
					if b {
						yynn1002++
					}
				}
				r.EncodeMapStart(yynn1002)
				yynn1002 = 0
			}
			if yyr1002 || yy2arr1002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1004 := z.EncBinary()
				_ = yym1004
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1005 := z.EncBinary()
				_ = yym1005
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			}
			if yyr1002 || yy2arr1002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1007 := z.EncBinary()
				_ = yym1007
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("shareName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1008 := z.EncBinary()
				_ = yym1008
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			}
			if yyr1002 || yy2arr1002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1002[2] {
					yym1010 := z.EncBinary()
					_ = yym1010
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1002[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1011 := z.EncBinary()
					_ = yym1011
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr1002 || yy2arr1002 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureFileVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1012 := z.DecBinary()
	_ = yym1012
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1013 := r.ContainerType()
		if yyct1013 == codecSelferValueTypeMap1234 {
			yyl1013 := r.ReadMapStart()
			if yyl1013 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1013, d)
			}
		} else if yyct1013 == codecSelferValueTypeArray1234 {
			yyl1013 := r.ReadArrayStart()
			if yyl1013 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1013, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1014Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1014Slc
	var yyhl1014 bool = l >= 0
	for yyj1014 := 0; ; yyj1014++ {
		if yyhl1014 {
			if yyj1014 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1014Slc = r.DecodeBytes(yys1014Slc, true, true)
		yys1014 := string(yys1014Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1014 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		case "shareName":
			if r.TryDecodeAsNil() {
				x.ShareName = ""
			} else {
				x.ShareName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1014)
		} // end switch yys1014
	} // end for yyj1014
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1018 int
	var yyb1018 bool
	var yyhl1018 bool = l >= 0
	yyj1018++
	if yyhl1018 {
		yyb1018 = yyj1018 > l
	} else {
		yyb1018 = r.CheckBreak()
	}
	if yyb1018 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	yyj1018++
	if yyhl1018 {
		yyb1018 = yyj1018 > l
	} else {
		yyb1018 = r.CheckBreak()
	}
	if yyb1018 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ShareName = ""
	} else {
		x.ShareName = string(r.DecodeString())
	}
	yyj1018++
	if yyhl1018 {
		yyb1018 = yyj1018 > l
	} else {
		yyb1018 = r.CheckBreak()
	}
	if yyb1018 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj1018++
		if yyhl1018 {
			yyb1018 = yyj1018 > l
		} else {
			yyb1018 = r.CheckBreak()
		}
		if yyb1018 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1018-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1022 := z.EncBinary()
		_ = yym1022
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1023 := !z.EncBinary()
			yy2arr1023 := z.EncBasicHandle().StructToArray
			var yyq1023 [2]bool
			_, _, _ = yysep1023, yyq1023, yy2arr1023
			const yyr1023 bool = false
			yyq1023[1] = x.FSType != ""
			var yynn1023 int
			if yyr1023 || yy2arr1023 {
				r.EncodeArrayStart(2)
			} else {
				yynn1023 = 1
				for _, b := range yyq1023 {
					if b {
						yynn1023++
					}
				}
				r.EncodeMapStart(yynn1023)
				yynn1023 = 0
			}
			if yyr1023 || yy2arr1023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1025 := z.EncBinary()
				_ = yym1025
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1026 := z.EncBinary()
				_ = yym1026
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			}
			if yyr1023 || yy2arr1023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1023[1] {
					yym1028 := z.EncBinary()
					_ = yym1028
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1023[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1029 := z.EncBinary()
					_ = yym1029
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr1023 || yy2arr1023 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1030 := z.DecBinary()
	_ = yym1030
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1031 := r.ContainerType()
		if yyct1031 == codecSelferValueTypeMap1234 {
			yyl1031 := r.ReadMapStart()
			if yyl1031 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1031, d)
			}
		} else if yyct1031 == codecSelferValueTypeArray1234 {
			yyl1031 := r.ReadArrayStart()
			if yyl1031 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1031, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1032Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1032Slc
	var yyhl1032 bool = l >= 0
	for yyj1032 := 0; ; yyj1032++ {
		if yyhl1032 {
			if yyj1032 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1032Slc = r.DecodeBytes(yys1032Slc, true, true)
		yys1032 := string(yys1032Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1032 {
		case "volumePath":
			if r.TryDecodeAsNil() {
				x.VolumePath = ""
			} else {
				x.VolumePath = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1032)
		} // end switch yys1032
	} // end for yyj1032
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1035 int
	var yyb1035 bool
	var yyhl1035 bool = l >= 0
	yyj1035++
	if yyhl1035 {
		yyb1035 = yyj1035 > l
	} else {
		yyb1035 = r.CheckBreak()
	}
	if yyb1035 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePath = ""
	} else {
		x.VolumePath = string(r.DecodeString())
	}
	yyj1035++
	if yyhl1035 {
		yyb1035 = yyj1035 > l
	} else {
		yyb1035 = r.CheckBreak()
	}
	if yyb1035 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	for {
		yyj1035++
		if yyhl1035 {
			yyb1035 = yyj1035 > l
		} else {
			yyb1035 = r.CheckBreak()
		}
		if yyb1035 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1035-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x AzureDataDiskCachingMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1038 := z.EncBinary()
	_ = yym1038
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *AzureDataDiskCachingMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1039 := z.DecBinary()
	_ = yym1039
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AzureDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1040 := z.EncBinary()
		_ = yym1040
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1041 := !z.EncBinary()
			yy2arr1041 := z.EncBasicHandle().StructToArray
			var yyq1041 [5]bool
			_, _, _ = yysep1041, yyq1041, yy2arr1041
			const yyr1041 bool = false
			yyq1041[2] = x.CachingMode != nil
			yyq1041[3] = x.FSType != nil
			yyq1041[4] = x.ReadOnly != nil
			var yynn1041 int
			if yyr1041 || yy2arr1041 {
				r.EncodeArrayStart(5)
			} else {
				yynn1041 = 2
				for _, b := range yyq1041 {
					if b {
						yynn1041++
					}
				}
				r.EncodeMapStart(yynn1041)
				yynn1041 = 0
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1043 := z.EncBinary()
				_ = yym1043
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1044 := z.EncBinary()
				_ = yym1044
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1046 := z.EncBinary()
				_ = yym1046
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskURI"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1047 := z.EncBinary()
				_ = yym1047
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1041[2] {
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy1049 := *x.CachingMode
						yy1049.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1041[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cachingMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy1050 := *x.CachingMode
						yy1050.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1041[3] {
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy1052 := *x.FSType
						yym1053 := z.EncBinary()
						_ = yym1053
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1052))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1041[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy1054 := *x.FSType
						yym1055 := z.EncBinary()
						_ = yym1055
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1054))
						}
					}
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1041[4] {
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy1057 := *x.ReadOnly
						yym1058 := z.EncBinary()
						_ = yym1058
						if false {
						} else {
							r.EncodeBool(bool(yy1057))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1041[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy1059 := *x.ReadOnly
						yym1060 := z.EncBinary()
						_ = yym1060
						if false {
						} else {
							r.EncodeBool(bool(yy1059))
						}
					}
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1061 := z.DecBinary()
	_ = yym1061
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1062 := r.ContainerType()
		if yyct1062 == codecSelferValueTypeMap1234 {
			yyl1062 := r.ReadMapStart()
			if yyl1062 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1062, d)
			}
		} else if yyct1062 == codecSelferValueTypeArray1234 {
			yyl1062 := r.ReadArrayStart()
			if yyl1062 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1062, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1063Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1063Slc
	var yyhl1063 bool = l >= 0
	for yyj1063 := 0; ; yyj1063++ {
		if yyhl1063 {
			if yyj1063 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1063Slc = r.DecodeBytes(yys1063Slc, true, true)
		yys1063 := string(yys1063Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1063 {
		case "diskName":
			if r.TryDecodeAsNil() {
				x.DiskName = ""
			} else {
				x.DiskName = string(r.DecodeString())
			}
		case "diskURI":
			if r.TryDecodeAsNil() {
				x.DataDiskURI = ""
			} else {
				x.DataDiskURI = string(r.DecodeString())
			}
		case "cachingMode":
			if r.TryDecodeAsNil() {
				if x.CachingMode != nil {
					x.CachingMode = nil
				}
			} else {
				if x.CachingMode == nil {
					x.CachingMode = new(AzureDataDiskCachingMode)
				}
				x.CachingMode.CodecDecodeSelf(d)
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				if x.FSType != nil {
					x.FSType = nil
				}
			} else {
				if x.FSType == nil {
					x.FSType = new(string)
				}
				yym1068 := z.DecBinary()
				_ = yym1068
				if false {
				} else {
					*((*string)(x.FSType)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				if x.ReadOnly != nil {
					x.ReadOnly = nil
				}
			} else {
				if x.ReadOnly == nil {
					x.ReadOnly = new(bool)
				}
				yym1070 := z.DecBinary()
				_ = yym1070
				if false {
				} else {
					*((*bool)(x.ReadOnly)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1063)
		} // end switch yys1063
	} // end for yyj1063
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1071 int
	var yyb1071 bool
	var yyhl1071 bool = l >= 0
	yyj1071++
	if yyhl1071 {
		yyb1071 = yyj1071 > l
	} else {
		yyb1071 = r.CheckBreak()
	}
	if yyb1071 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DiskName = ""
	} else {
		x.DiskName = string(r.DecodeString())
	}
	yyj1071++
	if yyhl1071 {
		yyb1071 = yyj1071 > l
	} else {
		yyb1071 = r.CheckBreak()
	}
	if yyb1071 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DataDiskURI = ""
	} else {
		x.DataDiskURI = string(r.DecodeString())
	}
	yyj1071++
	if yyhl1071 {
		yyb1071 = yyj1071 > l
	} else {
		yyb1071 = r.CheckBreak()
	}
	if yyb1071 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CachingMode != nil {
			x.CachingMode = nil
		}
	} else {
		if x.CachingMode == nil {
			x.CachingMode = new(AzureDataDiskCachingMode)
		}
		x.CachingMode.CodecDecodeSelf(d)
	}
	yyj1071++
	if yyhl1071 {
		yyb1071 = yyj1071 > l
	} else {
		yyb1071 = r.CheckBreak()
	}
	if yyb1071 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSType != nil {
			x.FSType = nil
		}
	} else {
		if x.FSType == nil {
			x.FSType = new(string)
		}
		yym1076 := z.DecBinary()
		_ = yym1076
		if false {
		} else {
			*((*string)(x.FSType)) = r.DecodeString()
		}
	}
	yyj1071++
	if yyhl1071 {
		yyb1071 = yyj1071 > l
	} else {
		yyb1071 = r.CheckBreak()
	}
	if yyb1071 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadOnly != nil {
			x.ReadOnly = nil
		}
	} else {
		if x.ReadOnly == nil {
			x.ReadOnly = new(bool)
		}
		yym1078 := z.DecBinary()
		_ = yym1078
		if false {
		} else {
			*((*bool)(x.ReadOnly)) = r.DecodeBool()
		}
	}
	for {
		yyj1071++
		if yyhl1071 {
			yyb1071 = yyj1071 > l
		} else {
			yyb1071 = r.CheckBreak()
		}
		if yyb1071 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1071-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1079 := z.EncBinary()
		_ = yym1079
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1080 := !z.EncBinary()
			yy2arr1080 := z.EncBasicHandle().StructToArray
			var yyq1080 [3]bool
			_, _, _ = yysep1080, yyq1080, yy2arr1080
			const yyr1080 bool = false
			yyq1080[0] = x.Name != ""
			yyq1080[1] = len(x.Items) != 0
			yyq1080[2] = x.DefaultMode != nil
			var yynn1080 int
			if yyr1080 || yy2arr1080 {
				r.EncodeArrayStart(3)
			} else {
				yynn1080 = 0
				for _, b := range yyq1080 {
					if b {
						yynn1080++
					}
				}
				r.EncodeMapStart(yynn1080)
				yynn1080 = 0
			}
			if yyr1080 || yy2arr1080 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1080[0] {
					yym1082 := z.EncBinary()
					_ = yym1082
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1080[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1083 := z.EncBinary()
					_ = yym1083
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1080 || yy2arr1080 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1080[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1085 := z.EncBinary()
						_ = yym1085
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1080[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1086 := z.EncBinary()
						_ = yym1086
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr1080 || yy2arr1080 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1080[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1088 := *x.DefaultMode
						yym1089 := z.EncBinary()
						_ = yym1089
						if false {
						} else {
							r.EncodeInt(int64(yy1088))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1080[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1090 := *x.DefaultMode
						yym1091 := z.EncBinary()
						_ = yym1091
						if false {
						} else {
							r.EncodeInt(int64(yy1090))
						}
					}
				}
			}
			if yyr1080 || yy2arr1080 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1092 := z.DecBinary()
	_ = yym1092
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1093 := r.ContainerType()
		if yyct1093 == codecSelferValueTypeMap1234 {
			yyl1093 := r.ReadMapStart()
			if yyl1093 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1093, d)
			}
		} else if yyct1093 == codecSelferValueTypeArray1234 {
			yyl1093 := r.ReadArrayStart()
			if yyl1093 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1093, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1094Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1094Slc
	var yyhl1094 bool = l >= 0
	for yyj1094 := 0; ; yyj1094++ {
		if yyhl1094 {
			if yyj1094 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1094Slc = r.DecodeBytes(yys1094Slc, true, true)
		yys1094 := string(yys1094Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1094 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1096 := &x.Items
				yym1097 := z.DecBinary()
				_ = yym1097
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv1096), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym1099 := z.DecBinary()
				_ = yym1099
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1094)
		} // end switch yys1094
	} // end for yyj1094
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1100 int
	var yyb1100 bool
	var yyhl1100 bool = l >= 0
	yyj1100++
	if yyhl1100 {
		yyb1100 = yyj1100 > l
	} else {
		yyb1100 = r.CheckBreak()
	}
	if yyb1100 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1100++
	if yyhl1100 {
		yyb1100 = yyj1100 > l
	} else {
		yyb1100 = r.CheckBreak()
	}
	if yyb1100 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1102 := &x.Items
		yym1103 := z.DecBinary()
		_ = yym1103
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv1102), d)
		}
	}
	yyj1100++
	if yyhl1100 {
		yyb1100 = yyj1100 > l
	} else {
		yyb1100 = r.CheckBreak()
	}
	if yyb1100 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym1105 := z.DecBinary()
		_ = yym1105
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1100++
		if yyhl1100 {
			yyb1100 = yyj1100 > l
		} else {
			yyb1100 = r.CheckBreak()
		}
		if yyb1100 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1100-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KeyToPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1106 := z.EncBinary()
		_ = yym1106
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1107 := !z.EncBinary()
			yy2arr1107 := z.EncBasicHandle().StructToArray
			var yyq1107 [3]bool
			_, _, _ = yysep1107, yyq1107, yy2arr1107
			const yyr1107 bool = false
			yyq1107[2] = x.Mode != nil
			var yynn1107 int
			if yyr1107 || yy2arr1107 {
				r.EncodeArrayStart(3)
			} else {
				yynn1107 = 2
				for _, b := range yyq1107 {
					if b {
						yynn1107++
					}
				}
				r.EncodeMapStart(yynn1107)
				yynn1107 = 0
			}
			if yyr1107 || yy2arr1107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1109 := z.EncBinary()
				_ = yym1109
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1110 := z.EncBinary()
				_ = yym1110
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1107 || yy2arr1107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1112 := z.EncBinary()
				_ = yym1112
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1113 := z.EncBinary()
				_ = yym1113
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr1107 || yy2arr1107 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1107[2] {
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1115 := *x.Mode
						yym1116 := z.EncBinary()
						_ = yym1116
						if false {
						} else {
							r.EncodeInt(int64(yy1115))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1107[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("mode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1117 := *x.Mode
						yym1118 := z.EncBinary()
						_ = yym1118
						if false {
						} else {
							r.EncodeInt(int64(yy1117))
						}
					}
				}
			}
			if yyr1107 || yy2arr1107 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KeyToPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1119 := z.DecBinary()
	_ = yym1119
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1120 := r.ContainerType()
		if yyct1120 == codecSelferValueTypeMap1234 {
			yyl1120 := r.ReadMapStart()
			if yyl1120 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1120, d)
			}
		} else if yyct1120 == codecSelferValueTypeArray1234 {
			yyl1120 := r.ReadArrayStart()
			if yyl1120 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1120, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KeyToPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1121Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1121Slc
	var yyhl1121 bool = l >= 0
	for yyj1121 := 0; ; yyj1121++ {
		if yyhl1121 {
			if yyj1121 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1121Slc = r.DecodeBytes(yys1121Slc, true, true)
		yys1121 := string(yys1121Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1121 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "mode":
			if r.TryDecodeAsNil() {
				if x.Mode != nil {
					x.Mode = nil
				}
			} else {
				if x.Mode == nil {
					x.Mode = new(int32)
				}
				yym1125 := z.DecBinary()
				_ = yym1125
				if false {
				} else {
					*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1121)
		} // end switch yys1121
	} // end for yyj1121
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KeyToPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1126 int
	var yyb1126 bool
	var yyhl1126 bool = l >= 0
	yyj1126++
	if yyhl1126 {
		yyb1126 = yyj1126 > l
	} else {
		yyb1126 = r.CheckBreak()
	}
	if yyb1126 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1126++
	if yyhl1126 {
		yyb1126 = yyj1126 > l
	} else {
		yyb1126 = r.CheckBreak()
	}
	if yyb1126 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1126++
	if yyhl1126 {
		yyb1126 = yyj1126 > l
	} else {
		yyb1126 = r.CheckBreak()
	}
	if yyb1126 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Mode != nil {
			x.Mode = nil
		}
	} else {
		if x.Mode == nil {
			x.Mode = new(int32)
		}
		yym1130 := z.DecBinary()
		_ = yym1130
		if false {
		} else {
			*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1126++
		if yyhl1126 {
			yyb1126 = yyj1126 > l
		} else {
			yyb1126 = r.CheckBreak()
		}
		if yyb1126 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1126-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1131 := z.EncBinary()
		_ = yym1131
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1132 := !z.EncBinary()
			yy2arr1132 := z.EncBasicHandle().StructToArray
			var yyq1132 [5]bool
			_, _, _ = yysep1132, yyq1132, yy2arr1132
			const yyr1132 bool = false
			yyq1132[0] = x.Name != ""
			yyq1132[1] = x.HostPort != 0
			yyq1132[3] = x.Protocol != ""
			yyq1132[4] = x.HostIP != ""
			var yynn1132 int
			if yyr1132 || yy2arr1132 {
				r.EncodeArrayStart(5)
			} else {
				yynn1132 = 1
				for _, b := range yyq1132 {
					if b {
						yynn1132++
					}
				}
				r.EncodeMapStart(yynn1132)
				yynn1132 = 0
			}
			if yyr1132 || yy2arr1132 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1132[0] {
					yym1134 := z.EncBinary()
					_ = yym1134
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1132[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1135 := z.EncBinary()
					_ = yym1135
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1132 || yy2arr1132 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1132[1] {
					yym1137 := z.EncBinary()
					_ = yym1137
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1132[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1138 := z.EncBinary()
					_ = yym1138
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				}
			}
			if yyr1132 || yy2arr1132 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1140 := z.EncBinary()
				_ = yym1140
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1141 := z.EncBinary()
				_ = yym1141
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			}
			if yyr1132 || yy2arr1132 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1132[3] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1132[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr1132 || yy2arr1132 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1132[4] {
					yym1144 := z.EncBinary()
					_ = yym1144
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1132[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1145 := z.EncBinary()
					_ = yym1145
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr1132 || yy2arr1132 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1146 := z.DecBinary()
	_ = yym1146
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1147 := r.ContainerType()
		if yyct1147 == codecSelferValueTypeMap1234 {
			yyl1147 := r.ReadMapStart()
			if yyl1147 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1147, d)
			}
		} else if yyct1147 == codecSelferValueTypeArray1234 {
			yyl1147 := r.ReadArrayStart()
			if yyl1147 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1147, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1148Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1148Slc
	var yyhl1148 bool = l >= 0
	for yyj1148 := 0; ; yyj1148++ {
		if yyhl1148 {
			if yyj1148 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1148Slc = r.DecodeBytes(yys1148Slc, true, true)
		yys1148 := string(yys1148Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1148 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPort":
			if r.TryDecodeAsNil() {
				x.HostPort = 0
			} else {
				x.HostPort = int32(r.DecodeInt(32))
			}
		case "containerPort":
			if r.TryDecodeAsNil() {
				x.ContainerPort = 0
			} else {
				x.ContainerPort = int32(r.DecodeInt(32))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1148)
		} // end switch yys1148
	} // end for yyj1148
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1154 int
	var yyb1154 bool
	var yyhl1154 bool = l >= 0
	yyj1154++
	if yyhl1154 {
		yyb1154 = yyj1154 > l
	} else {
		yyb1154 = r.CheckBreak()
	}
	if yyb1154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1154++
	if yyhl1154 {
		yyb1154 = yyj1154 > l
	} else {
		yyb1154 = r.CheckBreak()
	}
	if yyb1154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPort = 0
	} else {
		x.HostPort = int32(r.DecodeInt(32))
	}
	yyj1154++
	if yyhl1154 {
		yyb1154 = yyj1154 > l
	} else {
		yyb1154 = r.CheckBreak()
	}
	if yyb1154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerPort = 0
	} else {
		x.ContainerPort = int32(r.DecodeInt(32))
	}
	yyj1154++
	if yyhl1154 {
		yyb1154 = yyj1154 > l
	} else {
		yyb1154 = r.CheckBreak()
	}
	if yyb1154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj1154++
	if yyhl1154 {
		yyb1154 = yyj1154 > l
	} else {
		yyb1154 = r.CheckBreak()
	}
	if yyb1154 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	for {
		yyj1154++
		if yyhl1154 {
			yyb1154 = yyj1154 > l
		} else {
			yyb1154 = r.CheckBreak()
		}
		if yyb1154 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1154-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeMount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1160 := z.EncBinary()
		_ = yym1160
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1161 := !z.EncBinary()
			yy2arr1161 := z.EncBasicHandle().StructToArray
			var yyq1161 [4]bool
			_, _, _ = yysep1161, yyq1161, yy2arr1161
			const yyr1161 bool = false
			yyq1161[1] = x.ReadOnly != false
			yyq1161[3] = x.SubPath != ""
			var yynn1161 int
			if yyr1161 || yy2arr1161 {
				r.EncodeArrayStart(4)
			} else {
				yynn1161 = 2
				for _, b := range yyq1161 {
					if b {
						yynn1161++
					}
				}
				r.EncodeMapStart(yynn1161)
				yynn1161 = 0
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1163 := z.EncBinary()
				_ = yym1163
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1164 := z.EncBinary()
				_ = yym1164
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1161[1] {
					yym1166 := z.EncBinary()
					_ = yym1166
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1161[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1167 := z.EncBinary()
					_ = yym1167
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1169 := z.EncBinary()
				_ = yym1169
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mountPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1170 := z.EncBinary()
				_ = yym1170
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1161[3] {
					yym1172 := z.EncBinary()
					_ = yym1172
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1161[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1173 := z.EncBinary()
					_ = yym1173
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				}
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeMount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1174 := z.DecBinary()
	_ = yym1174
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1175 := r.ContainerType()
		if yyct1175 == codecSelferValueTypeMap1234 {
			yyl1175 := r.ReadMapStart()
			if yyl1175 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1175, d)
			}
		} else if yyct1175 == codecSelferValueTypeArray1234 {
			yyl1175 := r.ReadArrayStart()
			if yyl1175 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1175, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeMount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1176Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1176Slc
	var yyhl1176 bool = l >= 0
	for yyj1176 := 0; ; yyj1176++ {
		if yyhl1176 {
			if yyj1176 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1176Slc = r.DecodeBytes(yys1176Slc, true, true)
		yys1176 := string(yys1176Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1176 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "mountPath":
			if r.TryDecodeAsNil() {
				x.MountPath = ""
			} else {
				x.MountPath = string(r.DecodeString())
			}
		case "subPath":
			if r.TryDecodeAsNil() {
				x.SubPath = ""
			} else {
				x.SubPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1176)
		} // end switch yys1176
	} // end for yyj1176
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeMount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1181 int
	var yyb1181 bool
	var yyhl1181 bool = l >= 0
	yyj1181++
	if yyhl1181 {
		yyb1181 = yyj1181 > l
	} else {
		yyb1181 = r.CheckBreak()
	}
	if yyb1181 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1181++
	if yyhl1181 {
		yyb1181 = yyj1181 > l
	} else {
		yyb1181 = r.CheckBreak()
	}
	if yyb1181 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj1181++
	if yyhl1181 {
		yyb1181 = yyj1181 > l
	} else {
		yyb1181 = r.CheckBreak()
	}
	if yyb1181 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MountPath = ""
	} else {
		x.MountPath = string(r.DecodeString())
	}
	yyj1181++
	if yyhl1181 {
		yyb1181 = yyj1181 > l
	} else {
		yyb1181 = r.CheckBreak()
	}
	if yyb1181 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SubPath = ""
	} else {
		x.SubPath = string(r.DecodeString())
	}
	for {
		yyj1181++
		if yyhl1181 {
			yyb1181 = yyj1181 > l
		} else {
			yyb1181 = r.CheckBreak()
		}
		if yyb1181 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1181-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVar) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1186 := z.EncBinary()
		_ = yym1186
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1187 := !z.EncBinary()
			yy2arr1187 := z.EncBasicHandle().StructToArray
			var yyq1187 [3]bool
			_, _, _ = yysep1187, yyq1187, yy2arr1187
			const yyr1187 bool = false
			yyq1187[1] = x.Value != ""
			yyq1187[2] = x.ValueFrom != nil
			var yynn1187 int
			if yyr1187 || yy2arr1187 {
				r.EncodeArrayStart(3)
			} else {
				yynn1187 = 1
				for _, b := range yyq1187 {
					if b {
						yynn1187++
					}
				}
				r.EncodeMapStart(yynn1187)
				yynn1187 = 0
			}
			if yyr1187 || yy2arr1187 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1189 := z.EncBinary()
				_ = yym1189
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1190 := z.EncBinary()
				_ = yym1190
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1187 || yy2arr1187 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1187[1] {
					yym1192 := z.EncBinary()
					_ = yym1192
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1187[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1193 := z.EncBinary()
					_ = yym1193
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr1187 || yy2arr1187 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1187[2] {
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1187[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("valueFrom"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1187 || yy2arr1187 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVar) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1195 := z.DecBinary()
	_ = yym1195
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1196 := r.ContainerType()
		if yyct1196 == codecSelferValueTypeMap1234 {
			yyl1196 := r.ReadMapStart()
			if yyl1196 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1196, d)
			}
		} else if yyct1196 == codecSelferValueTypeArray1234 {
			yyl1196 := r.ReadArrayStart()
			if yyl1196 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1196, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVar) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1197Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1197Slc
	var yyhl1197 bool = l >= 0
	for yyj1197 := 0; ; yyj1197++ {
		if yyhl1197 {
			if yyj1197 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1197Slc = r.DecodeBytes(yys1197Slc, true, true)
		yys1197 := string(yys1197Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1197 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "valueFrom":
			if r.TryDecodeAsNil() {
				if x.ValueFrom != nil {
					x.ValueFrom = nil
				}
			} else {
				if x.ValueFrom == nil {
					x.ValueFrom = new(EnvVarSource)
				}
				x.ValueFrom.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1197)
		} // end switch yys1197
	} // end for yyj1197
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVar) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1201 int
	var yyb1201 bool
	var yyhl1201 bool = l >= 0
	yyj1201++
	if yyhl1201 {
		yyb1201 = yyj1201 > l
	} else {
		yyb1201 = r.CheckBreak()
	}
	if yyb1201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1201++
	if yyhl1201 {
		yyb1201 = yyj1201 > l
	} else {
		yyb1201 = r.CheckBreak()
	}
	if yyb1201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj1201++
	if yyhl1201 {
		yyb1201 = yyj1201 > l
	} else {
		yyb1201 = r.CheckBreak()
	}
	if yyb1201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ValueFrom != nil {
			x.ValueFrom = nil
		}
	} else {
		if x.ValueFrom == nil {
			x.ValueFrom = new(EnvVarSource)
		}
		x.ValueFrom.CodecDecodeSelf(d)
	}
	for {
		yyj1201++
		if yyhl1201 {
			yyb1201 = yyj1201 > l
		} else {
			yyb1201 = r.CheckBreak()
		}
		if yyb1201 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1201-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVarSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1205 := z.EncBinary()
		_ = yym1205
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1206 := !z.EncBinary()
			yy2arr1206 := z.EncBasicHandle().StructToArray
			var yyq1206 [4]bool
			_, _, _ = yysep1206, yyq1206, yy2arr1206
			const yyr1206 bool = false
			yyq1206[0] = x.FieldRef != nil
			yyq1206[1] = x.ResourceFieldRef != nil
			yyq1206[2] = x.ConfigMapKeyRef != nil
			yyq1206[3] = x.SecretKeyRef != nil
			var yynn1206 int
			if yyr1206 || yy2arr1206 {
				r.EncodeArrayStart(4)
			} else {
				yynn1206 = 0
				for _, b := range yyq1206 {
					if b {
						yynn1206++
					}
				}
				r.EncodeMapStart(yynn1206)
				yynn1206 = 0
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1206[0] {
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1206[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1206[1] {
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1206[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceFieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1206[2] {
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1206[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMapKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1206[3] {
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1206[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1206 || yy2arr1206 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVarSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1211 := z.DecBinary()
	_ = yym1211
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1212 := r.ContainerType()
		if yyct1212 == codecSelferValueTypeMap1234 {
			yyl1212 := r.ReadMapStart()
			if yyl1212 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1212, d)
			}
		} else if yyct1212 == codecSelferValueTypeArray1234 {
			yyl1212 := r.ReadArrayStart()
			if yyl1212 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1212, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVarSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1213Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1213Slc
	var yyhl1213 bool = l >= 0
	for yyj1213 := 0; ; yyj1213++ {
		if yyhl1213 {
			if yyj1213 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1213Slc = r.DecodeBytes(yys1213Slc, true, true)
		yys1213 := string(yys1213Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1213 {
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		case "resourceFieldRef":
			if r.TryDecodeAsNil() {
				if x.ResourceFieldRef != nil {
					x.ResourceFieldRef = nil
				}
			} else {
				if x.ResourceFieldRef == nil {
					x.ResourceFieldRef = new(ResourceFieldSelector)
				}
				x.ResourceFieldRef.CodecDecodeSelf(d)
			}
		case "configMapKeyRef":
			if r.TryDecodeAsNil() {
				if x.ConfigMapKeyRef != nil {
					x.ConfigMapKeyRef = nil
				}
			} else {
				if x.ConfigMapKeyRef == nil {
					x.ConfigMapKeyRef = new(ConfigMapKeySelector)
				}
				x.ConfigMapKeyRef.CodecDecodeSelf(d)
			}
		case "secretKeyRef":
			if r.TryDecodeAsNil() {
				if x.SecretKeyRef != nil {
					x.SecretKeyRef = nil
				}
			} else {
				if x.SecretKeyRef == nil {
					x.SecretKeyRef = new(SecretKeySelector)
				}
				x.SecretKeyRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1213)
		} // end switch yys1213
	} // end for yyj1213
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVarSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1218 int
	var yyb1218 bool
	var yyhl1218 bool = l >= 0
	yyj1218++
	if yyhl1218 {
		yyb1218 = yyj1218 > l
	} else {
		yyb1218 = r.CheckBreak()
	}
	if yyb1218 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	yyj1218++
	if yyhl1218 {
		yyb1218 = yyj1218 > l
	} else {
		yyb1218 = r.CheckBreak()
	}
	if yyb1218 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceFieldRef != nil {
			x.ResourceFieldRef = nil
		}
	} else {
		if x.ResourceFieldRef == nil {
			x.ResourceFieldRef = new(ResourceFieldSelector)
		}
		x.ResourceFieldRef.CodecDecodeSelf(d)
	}
	yyj1218++
	if yyhl1218 {
		yyb1218 = yyj1218 > l
	} else {
		yyb1218 = r.CheckBreak()
	}
	if yyb1218 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMapKeyRef != nil {
			x.ConfigMapKeyRef = nil
		}
	} else {
		if x.ConfigMapKeyRef == nil {
			x.ConfigMapKeyRef = new(ConfigMapKeySelector)
		}
		x.ConfigMapKeyRef.CodecDecodeSelf(d)
	}
	yyj1218++
	if yyhl1218 {
		yyb1218 = yyj1218 > l
	} else {
		yyb1218 = r.CheckBreak()
	}
	if yyb1218 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretKeyRef != nil {
			x.SecretKeyRef = nil
		}
	} else {
		if x.SecretKeyRef == nil {
			x.SecretKeyRef = new(SecretKeySelector)
		}
		x.SecretKeyRef.CodecDecodeSelf(d)
	}
	for {
		yyj1218++
		if yyhl1218 {
			yyb1218 = yyj1218 > l
		} else {
			yyb1218 = r.CheckBreak()
		}
		if yyb1218 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1218-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1223 := z.EncBinary()
		_ = yym1223
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1224 := !z.EncBinary()
			yy2arr1224 := z.EncBasicHandle().StructToArray
			var yyq1224 [2]bool
			_, _, _ = yysep1224, yyq1224, yy2arr1224
			const yyr1224 bool = false
			yyq1224[0] = x.APIVersion != ""
			var yynn1224 int
			if yyr1224 || yy2arr1224 {
				r.EncodeArrayStart(2)
			} else {
				yynn1224 = 1
				for _, b := range yyq1224 {
					if b {
						yynn1224++
					}
				}
				r.EncodeMapStart(yynn1224)
				yynn1224 = 0
			}
			if yyr1224 || yy2arr1224 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1224[0] {
					yym1226 := z.EncBinary()
					_ = yym1226
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1224[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1227 := z.EncBinary()
					_ = yym1227
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1224 || yy2arr1224 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1229 := z.EncBinary()
				_ = yym1229
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1230 := z.EncBinary()
				_ = yym1230
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			}
			if yyr1224 || yy2arr1224 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1231 := z.DecBinary()
	_ = yym1231
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1232 := r.ContainerType()
		if yyct1232 == codecSelferValueTypeMap1234 {
			yyl1232 := r.ReadMapStart()
			if yyl1232 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1232, d)
			}
		} else if yyct1232 == codecSelferValueTypeArray1234 {
			yyl1232 := r.ReadArrayStart()
			if yyl1232 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1232, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1233Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1233Slc
	var yyhl1233 bool = l >= 0
	for yyj1233 := 0; ; yyj1233++ {
		if yyhl1233 {
			if yyj1233 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1233Slc = r.DecodeBytes(yys1233Slc, true, true)
		yys1233 := string(yys1233Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1233 {
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				x.FieldPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1233)
		} // end switch yys1233
	} // end for yyj1233
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1236 int
	var yyb1236 bool
	var yyhl1236 bool = l >= 0
	yyj1236++
	if yyhl1236 {
		yyb1236 = yyj1236 > l
	} else {
		yyb1236 = r.CheckBreak()
	}
	if yyb1236 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1236++
	if yyhl1236 {
		yyb1236 = yyj1236 > l
	} else {
		yyb1236 = r.CheckBreak()
	}
	if yyb1236 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		x.FieldPath = string(r.DecodeString())
	}
	for {
		yyj1236++
		if yyhl1236 {
			yyb1236 = yyj1236 > l
		} else {
			yyb1236 = r.CheckBreak()
		}
		if yyb1236 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1236-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1239 := z.EncBinary()
		_ = yym1239
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1240 := !z.EncBinary()
			yy2arr1240 := z.EncBasicHandle().StructToArray
			var yyq1240 [3]bool
			_, _, _ = yysep1240, yyq1240, yy2arr1240
			const yyr1240 bool = false
			yyq1240[0] = x.ContainerName != ""
			yyq1240[2] = true
			var yynn1240 int
			if yyr1240 || yy2arr1240 {
				r.EncodeArrayStart(3)
			} else {
				yynn1240 = 1
				for _, b := range yyq1240 {
					if b {
						yynn1240++
					}
				}
				r.EncodeMapStart(yynn1240)
				yynn1240 = 0
			}
			if yyr1240 || yy2arr1240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1240[0] {
					yym1242 := z.EncBinary()
					_ = yym1242
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1240[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1243 := z.EncBinary()
					_ = yym1243
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				}
			}
			if yyr1240 || yy2arr1240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1245 := z.EncBinary()
				_ = yym1245
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1246 := z.EncBinary()
				_ = yym1246
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			}
			if yyr1240 || yy2arr1240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1240[2] {
					yy1248 := &x.Divisor
					yym1249 := z.EncBinary()
					_ = yym1249
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1248) {
					} else if !yym1249 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1248)
					} else {
						z.EncFallback(yy1248)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1240[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("divisor"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1250 := &x.Divisor
					yym1251 := z.EncBinary()
					_ = yym1251
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1250) {
					} else if !yym1251 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1250)
					} else {
						z.EncFallback(yy1250)
					}
				}
			}
			if yyr1240 || yy2arr1240 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1252 := z.DecBinary()
	_ = yym1252
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1253 := r.ContainerType()
		if yyct1253 == codecSelferValueTypeMap1234 {
			yyl1253 := r.ReadMapStart()
			if yyl1253 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1253, d)
			}
		} else if yyct1253 == codecSelferValueTypeArray1234 {
			yyl1253 := r.ReadArrayStart()
			if yyl1253 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1253, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1254Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1254Slc
	var yyhl1254 bool = l >= 0
	for yyj1254 := 0; ; yyj1254++ {
		if yyhl1254 {
			if yyj1254 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1254Slc = r.DecodeBytes(yys1254Slc, true, true)
		yys1254 := string(yys1254Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1254 {
		case "containerName":
			if r.TryDecodeAsNil() {
				x.ContainerName = ""
			} else {
				x.ContainerName = string(r.DecodeString())
			}
		case "resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				x.Resource = string(r.DecodeString())
			}
		case "divisor":
			if r.TryDecodeAsNil() {
				x.Divisor = pkg3_resource.Quantity{}
			} else {
				yyv1257 := &x.Divisor
				yym1258 := z.DecBinary()
				_ = yym1258
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1257) {
				} else if !yym1258 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1257)
				} else {
					z.DecFallback(yyv1257, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1254)
		} // end switch yys1254
	} // end for yyj1254
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1259 int
	var yyb1259 bool
	var yyhl1259 bool = l >= 0
	yyj1259++
	if yyhl1259 {
		yyb1259 = yyj1259 > l
	} else {
		yyb1259 = r.CheckBreak()
	}
	if yyb1259 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerName = ""
	} else {
		x.ContainerName = string(r.DecodeString())
	}
	yyj1259++
	if yyhl1259 {
		yyb1259 = yyj1259 > l
	} else {
		yyb1259 = r.CheckBreak()
	}
	if yyb1259 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		x.Resource = string(r.DecodeString())
	}
	yyj1259++
	if yyhl1259 {
		yyb1259 = yyj1259 > l
	} else {
		yyb1259 = r.CheckBreak()
	}
	if yyb1259 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Divisor = pkg3_resource.Quantity{}
	} else {
		yyv1262 := &x.Divisor
		yym1263 := z.DecBinary()
		_ = yym1263
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1262) {
		} else if !yym1263 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1262)
		} else {
			z.DecFallback(yyv1262, false)
		}
	}
	for {
		yyj1259++
		if yyhl1259 {
			yyb1259 = yyj1259 > l
		} else {
			yyb1259 = r.CheckBreak()
		}
		if yyb1259 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1259-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1264 := z.EncBinary()
		_ = yym1264
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1265 := !z.EncBinary()
			yy2arr1265 := z.EncBasicHandle().StructToArray
			var yyq1265 [2]bool
			_, _, _ = yysep1265, yyq1265, yy2arr1265
			const yyr1265 bool = false
			yyq1265[0] = x.Name != ""
			var yynn1265 int
			if yyr1265 || yy2arr1265 {
				r.EncodeArrayStart(2)
			} else {
				yynn1265 = 1
				for _, b := range yyq1265 {
					if b {
						yynn1265++
					}
				}
				r.EncodeMapStart(yynn1265)
				yynn1265 = 0
			}
			if yyr1265 || yy2arr1265 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1265[0] {
					yym1267 := z.EncBinary()
					_ = yym1267
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1265[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1268 := z.EncBinary()
					_ = yym1268
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1265 || yy2arr1265 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1270 := z.EncBinary()
				_ = yym1270
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1271 := z.EncBinary()
				_ = yym1271
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1265 || yy2arr1265 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1272 := z.DecBinary()
	_ = yym1272
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1273 := r.ContainerType()
		if yyct1273 == codecSelferValueTypeMap1234 {
			yyl1273 := r.ReadMapStart()
			if yyl1273 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1273, d)
			}
		} else if yyct1273 == codecSelferValueTypeArray1234 {
			yyl1273 := r.ReadArrayStart()
			if yyl1273 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1273, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1274Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1274Slc
	var yyhl1274 bool = l >= 0
	for yyj1274 := 0; ; yyj1274++ {
		if yyhl1274 {
			if yyj1274 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1274Slc = r.DecodeBytes(yys1274Slc, true, true)
		yys1274 := string(yys1274Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1274 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1274)
		} // end switch yys1274
	} // end for yyj1274
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1277 int
	var yyb1277 bool
	var yyhl1277 bool = l >= 0
	yyj1277++
	if yyhl1277 {
		yyb1277 = yyj1277 > l
	} else {
		yyb1277 = r.CheckBreak()
	}
	if yyb1277 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1277++
	if yyhl1277 {
		yyb1277 = yyj1277 > l
	} else {
		yyb1277 = r.CheckBreak()
	}
	if yyb1277 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	for {
		yyj1277++
		if yyhl1277 {
			yyb1277 = yyj1277 > l
		} else {
			yyb1277 = r.CheckBreak()
		}
		if yyb1277 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1277-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1280 := z.EncBinary()
		_ = yym1280
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1281 := !z.EncBinary()
			yy2arr1281 := z.EncBasicHandle().StructToArray
			var yyq1281 [2]bool
			_, _, _ = yysep1281, yyq1281, yy2arr1281
			const yyr1281 bool = false
			yyq1281[0] = x.Name != ""
			var yynn1281 int
			if yyr1281 || yy2arr1281 {
				r.EncodeArrayStart(2)
			} else {
				yynn1281 = 1
				for _, b := range yyq1281 {
					if b {
						yynn1281++
					}
				}
				r.EncodeMapStart(yynn1281)
				yynn1281 = 0
			}
			if yyr1281 || yy2arr1281 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1281[0] {
					yym1283 := z.EncBinary()
					_ = yym1283
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1281[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1284 := z.EncBinary()
					_ = yym1284
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1281 || yy2arr1281 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1286 := z.EncBinary()
				_ = yym1286
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1287 := z.EncBinary()
				_ = yym1287
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1281 || yy2arr1281 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1288 := z.DecBinary()
	_ = yym1288
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1289 := r.ContainerType()
		if yyct1289 == codecSelferValueTypeMap1234 {
			yyl1289 := r.ReadMapStart()
			if yyl1289 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1289, d)
			}
		} else if yyct1289 == codecSelferValueTypeArray1234 {
			yyl1289 := r.ReadArrayStart()
			if yyl1289 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1289, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1290Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1290Slc
	var yyhl1290 bool = l >= 0
	for yyj1290 := 0; ; yyj1290++ {
		if yyhl1290 {
			if yyj1290 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1290Slc = r.DecodeBytes(yys1290Slc, true, true)
		yys1290 := string(yys1290Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1290 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1290)
		} // end switch yys1290
	} // end for yyj1290
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1293 int
	var yyb1293 bool
	var yyhl1293 bool = l >= 0
	yyj1293++
	if yyhl1293 {
		yyb1293 = yyj1293 > l
	} else {
		yyb1293 = r.CheckBreak()
	}
	if yyb1293 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1293++
	if yyhl1293 {
		yyb1293 = yyj1293 > l
	} else {
		yyb1293 = r.CheckBreak()
	}
	if yyb1293 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	for {
		yyj1293++
		if yyhl1293 {
			yyb1293 = yyj1293 > l
		} else {
			yyb1293 = r.CheckBreak()
		}
		if yyb1293 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1293-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPHeader) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1296 := z.EncBinary()
		_ = yym1296
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1297 := !z.EncBinary()
			yy2arr1297 := z.EncBasicHandle().StructToArray
			var yyq1297 [2]bool
			_, _, _ = yysep1297, yyq1297, yy2arr1297
			const yyr1297 bool = false
			var yynn1297 int
			if yyr1297 || yy2arr1297 {
				r.EncodeArrayStart(2)
			} else {
				yynn1297 = 2
				for _, b := range yyq1297 {
					if b {
						yynn1297++
					}
				}
				r.EncodeMapStart(yynn1297)
				yynn1297 = 0
			}
			if yyr1297 || yy2arr1297 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1299 := z.EncBinary()
				_ = yym1299
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1300 := z.EncBinary()
				_ = yym1300
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1297 || yy2arr1297 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1302 := z.EncBinary()
				_ = yym1302
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1303 := z.EncBinary()
				_ = yym1303
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			}
			if yyr1297 || yy2arr1297 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPHeader) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1304 := z.DecBinary()
	_ = yym1304
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1305 := r.ContainerType()
		if yyct1305 == codecSelferValueTypeMap1234 {
			yyl1305 := r.ReadMapStart()
			if yyl1305 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1305, d)
			}
		} else if yyct1305 == codecSelferValueTypeArray1234 {
			yyl1305 := r.ReadArrayStart()
			if yyl1305 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1305, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPHeader) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1306Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1306Slc
	var yyhl1306 bool = l >= 0
	for yyj1306 := 0; ; yyj1306++ {
		if yyhl1306 {
			if yyj1306 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1306Slc = r.DecodeBytes(yys1306Slc, true, true)
		yys1306 := string(yys1306Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1306 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1306)
		} // end switch yys1306
	} // end for yyj1306
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPHeader) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1309 int
	var yyb1309 bool
	var yyhl1309 bool = l >= 0
	yyj1309++
	if yyhl1309 {
		yyb1309 = yyj1309 > l
	} else {
		yyb1309 = r.CheckBreak()
	}
	if yyb1309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1309++
	if yyhl1309 {
		yyb1309 = yyj1309 > l
	} else {
		yyb1309 = r.CheckBreak()
	}
	if yyb1309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	for {
		yyj1309++
		if yyhl1309 {
			yyb1309 = yyj1309 > l
		} else {
			yyb1309 = r.CheckBreak()
		}
		if yyb1309 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1309-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPGetAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1312 := z.EncBinary()
		_ = yym1312
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1313 := !z.EncBinary()
			yy2arr1313 := z.EncBasicHandle().StructToArray
			var yyq1313 [5]bool
			_, _, _ = yysep1313, yyq1313, yy2arr1313
			const yyr1313 bool = false
			yyq1313[0] = x.Path != ""
			yyq1313[2] = x.Host != ""
			yyq1313[3] = x.Scheme != ""
			yyq1313[4] = len(x.HTTPHeaders) != 0
			var yynn1313 int
			if yyr1313 || yy2arr1313 {
				r.EncodeArrayStart(5)
			} else {
				yynn1313 = 1
				for _, b := range yyq1313 {
					if b {
						yynn1313++
					}
				}
				r.EncodeMapStart(yynn1313)
				yynn1313 = 0
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1313[0] {
					yym1315 := z.EncBinary()
					_ = yym1315
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1313[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1316 := z.EncBinary()
					_ = yym1316
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1318 := &x.Port
				yym1319 := z.EncBinary()
				_ = yym1319
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1318) {
				} else if !yym1319 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1318)
				} else {
					z.EncFallback(yy1318)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1320 := &x.Port
				yym1321 := z.EncBinary()
				_ = yym1321
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1320) {
				} else if !yym1321 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1320)
				} else {
					z.EncFallback(yy1320)
				}
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1313[2] {
					yym1323 := z.EncBinary()
					_ = yym1323
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1313[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1324 := z.EncBinary()
					_ = yym1324
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1313[3] {
					x.Scheme.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1313[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scheme"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Scheme.CodecEncodeSelf(e)
				}
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1313[4] {
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym1327 := z.EncBinary()
						_ = yym1327
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1313[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpHeaders"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym1328 := z.EncBinary()
						_ = yym1328
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				}
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPGetAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1329 := z.DecBinary()
	_ = yym1329
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1330 := r.ContainerType()
		if yyct1330 == codecSelferValueTypeMap1234 {
			yyl1330 := r.ReadMapStart()
			if yyl1330 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1330, d)
			}
		} else if yyct1330 == codecSelferValueTypeArray1234 {
			yyl1330 := r.ReadArrayStart()
			if yyl1330 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1330, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPGetAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1331Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1331Slc
	var yyhl1331 bool = l >= 0
	for yyj1331 := 0; ; yyj1331++ {
		if yyhl1331 {
			if yyj1331 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1331Slc = r.DecodeBytes(yys1331Slc, true, true)
		yys1331 := string(yys1331Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1331 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv1333 := &x.Port
				yym1334 := z.DecBinary()
				_ = yym1334
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1333) {
				} else if !yym1334 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1333)
				} else {
					z.DecFallback(yyv1333, false)
				}
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "scheme":
			if r.TryDecodeAsNil() {
				x.Scheme = ""
			} else {
				x.Scheme = URIScheme(r.DecodeString())
			}
		case "httpHeaders":
			if r.TryDecodeAsNil() {
				x.HTTPHeaders = nil
			} else {
				yyv1337 := &x.HTTPHeaders
				yym1338 := z.DecBinary()
				_ = yym1338
				if false {
				} else {
					h.decSliceHTTPHeader((*[]HTTPHeader)(yyv1337), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1331)
		} // end switch yys1331
	} // end for yyj1331
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPGetAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1339 int
	var yyb1339 bool
	var yyhl1339 bool = l >= 0
	yyj1339++
	if yyhl1339 {
		yyb1339 = yyj1339 > l
	} else {
		yyb1339 = r.CheckBreak()
	}
	if yyb1339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1339++
	if yyhl1339 {
		yyb1339 = yyj1339 > l
	} else {
		yyb1339 = r.CheckBreak()
	}
	if yyb1339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv1341 := &x.Port
		yym1342 := z.DecBinary()
		_ = yym1342
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1341) {
		} else if !yym1342 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1341)
		} else {
			z.DecFallback(yyv1341, false)
		}
	}
	yyj1339++
	if yyhl1339 {
		yyb1339 = yyj1339 > l
	} else {
		yyb1339 = r.CheckBreak()
	}
	if yyb1339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	yyj1339++
	if yyhl1339 {
		yyb1339 = yyj1339 > l
	} else {
		yyb1339 = r.CheckBreak()
	}
	if yyb1339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Scheme = ""
	} else {
		x.Scheme = URIScheme(r.DecodeString())
	}
	yyj1339++
	if yyhl1339 {
		yyb1339 = yyj1339 > l
	} else {
		yyb1339 = r.CheckBreak()
	}
	if yyb1339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPHeaders = nil
	} else {
		yyv1345 := &x.HTTPHeaders
		yym1346 := z.DecBinary()
		_ = yym1346
		if false {
		} else {
			h.decSliceHTTPHeader((*[]HTTPHeader)(yyv1345), d)
		}
	}
	for {
		yyj1339++
		if yyhl1339 {
			yyb1339 = yyj1339 > l
		} else {
			yyb1339 = r.CheckBreak()
		}
		if yyb1339 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1339-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x URIScheme) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1347 := z.EncBinary()
	_ = yym1347
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *URIScheme) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1348 := z.DecBinary()
	_ = yym1348
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *TCPSocketAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1349 := z.EncBinary()
		_ = yym1349
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1350 := !z.EncBinary()
			yy2arr1350 := z.EncBasicHandle().StructToArray
			var yyq1350 [1]bool
			_, _, _ = yysep1350, yyq1350, yy2arr1350
			const yyr1350 bool = false
			var yynn1350 int
			if yyr1350 || yy2arr1350 {
				r.EncodeArrayStart(1)
			} else {
				yynn1350 = 1
				for _, b := range yyq1350 {
					if b {
						yynn1350++
					}
				}
				r.EncodeMapStart(yynn1350)
				yynn1350 = 0
			}
			if yyr1350 || yy2arr1350 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1352 := &x.Port
				yym1353 := z.EncBinary()
				_ = yym1353
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1352) {
				} else if !yym1353 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1352)
				} else {
					z.EncFallback(yy1352)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1354 := &x.Port
				yym1355 := z.EncBinary()
				_ = yym1355
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1354) {
				} else if !yym1355 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1354)
				} else {
					z.EncFallback(yy1354)
				}
			}
			if yyr1350 || yy2arr1350 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TCPSocketAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1356 := z.DecBinary()
	_ = yym1356
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1357 := r.ContainerType()
		if yyct1357 == codecSelferValueTypeMap1234 {
			yyl1357 := r.ReadMapStart()
			if yyl1357 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1357, d)
			}
		} else if yyct1357 == codecSelferValueTypeArray1234 {
			yyl1357 := r.ReadArrayStart()
			if yyl1357 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1357, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TCPSocketAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1358Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1358Slc
	var yyhl1358 bool = l >= 0
	for yyj1358 := 0; ; yyj1358++ {
		if yyhl1358 {
			if yyj1358 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1358Slc = r.DecodeBytes(yys1358Slc, true, true)
		yys1358 := string(yys1358Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1358 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv1359 := &x.Port
				yym1360 := z.DecBinary()
				_ = yym1360
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1359) {
				} else if !yym1360 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1359)
				} else {
					z.DecFallback(yyv1359, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1358)
		} // end switch yys1358
	} // end for yyj1358
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TCPSocketAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1361 int
	var yyb1361 bool
	var yyhl1361 bool = l >= 0
	yyj1361++
	if yyhl1361 {
		yyb1361 = yyj1361 > l
	} else {
		yyb1361 = r.CheckBreak()
	}
	if yyb1361 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv1362 := &x.Port
		yym1363 := z.DecBinary()
		_ = yym1363
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1362) {
		} else if !yym1363 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1362)
		} else {
			z.DecFallback(yyv1362, false)
		}
	}
	for {
		yyj1361++
		if yyhl1361 {
			yyb1361 = yyj1361 > l
		} else {
			yyb1361 = r.CheckBreak()
		}
		if yyb1361 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1361-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExecAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1364 := z.EncBinary()
		_ = yym1364
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1365 := !z.EncBinary()
			yy2arr1365 := z.EncBasicHandle().StructToArray
			var yyq1365 [1]bool
			_, _, _ = yysep1365, yyq1365, yy2arr1365
			const yyr1365 bool = false
			yyq1365[0] = len(x.Command) != 0
			var yynn1365 int
			if yyr1365 || yy2arr1365 {
				r.EncodeArrayStart(1)
			} else {
				yynn1365 = 0
				for _, b := range yyq1365 {
					if b {
						yynn1365++
					}
				}
				r.EncodeMapStart(yynn1365)
				yynn1365 = 0
			}
			if yyr1365 || yy2arr1365 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1365[0] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1367 := z.EncBinary()
						_ = yym1367
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1365[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1368 := z.EncBinary()
						_ = yym1368
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1365 || yy2arr1365 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExecAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1369 := z.DecBinary()
	_ = yym1369
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1370 := r.ContainerType()
		if yyct1370 == codecSelferValueTypeMap1234 {
			yyl1370 := r.ReadMapStart()
			if yyl1370 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1370, d)
			}
		} else if yyct1370 == codecSelferValueTypeArray1234 {
			yyl1370 := r.ReadArrayStart()
			if yyl1370 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1370, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExecAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1371Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1371Slc
	var yyhl1371 bool = l >= 0
	for yyj1371 := 0; ; yyj1371++ {
		if yyhl1371 {
			if yyj1371 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1371Slc = r.DecodeBytes(yys1371Slc, true, true)
		yys1371 := string(yys1371Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1371 {
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1372 := &x.Command
				yym1373 := z.DecBinary()
				_ = yym1373
				if false {
				} else {
					z.F.DecSliceStringX(yyv1372, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1371)
		} // end switch yys1371
	} // end for yyj1371
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExecAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1374 int
	var yyb1374 bool
	var yyhl1374 bool = l >= 0
	yyj1374++
	if yyhl1374 {
		yyb1374 = yyj1374 > l
	} else {
		yyb1374 = r.CheckBreak()
	}
	if yyb1374 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1375 := &x.Command
		yym1376 := z.DecBinary()
		_ = yym1376
		if false {
		} else {
			z.F.DecSliceStringX(yyv1375, false, d)
		}
	}
	for {
		yyj1374++
		if yyhl1374 {
			yyb1374 = yyj1374 > l
		} else {
			yyb1374 = r.CheckBreak()
		}
		if yyb1374 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1374-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Probe) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1377 := z.EncBinary()
		_ = yym1377
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1378 := !z.EncBinary()
			yy2arr1378 := z.EncBasicHandle().StructToArray
			var yyq1378 [8]bool
			_, _, _ = yysep1378, yyq1378, yy2arr1378
			const yyr1378 bool = false
			yyq1378[0] = x.Handler.Exec != nil && x.Exec != nil
			yyq1378[1] = x.Handler.HTTPGet != nil && x.HTTPGet != nil
			yyq1378[2] = x.Handler.TCPSocket != nil && x.TCPSocket != nil
			yyq1378[3] = x.InitialDelaySeconds != 0
			yyq1378[4] = x.TimeoutSeconds != 0
			yyq1378[5] = x.PeriodSeconds != 0
			yyq1378[6] = x.SuccessThreshold != 0
			yyq1378[7] = x.FailureThreshold != 0
			var yynn1378 int
			if yyr1378 || yy2arr1378 {
				r.EncodeArrayStart(8)
			} else {
				yynn1378 = 0
				for _, b := range yyq1378 {
					if b {
						yynn1378++
					}
				}
				r.EncodeMapStart(yynn1378)
				yynn1378 = 0
			}
			var yyn1379 bool
			if x.Handler.Exec == nil {
				yyn1379 = true
				goto LABEL1379
			}
		LABEL1379:
			if yyr1378 || yy2arr1378 {
				if yyn1379 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1378[0] {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1378[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1379 {
						r.EncodeNil()
					} else {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1380 bool
			if x.Handler.HTTPGet == nil {
				yyn1380 = true
				goto LABEL1380
			}
		LABEL1380:
			if yyr1378 || yy2arr1378 {
				if yyn1380 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1378[1] {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1378[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1380 {
						r.EncodeNil()
					} else {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1381 bool
			if x.Handler.TCPSocket == nil {
				yyn1381 = true
				goto LABEL1381
			}
		LABEL1381:
			if yyr1378 || yy2arr1378 {
				if yyn1381 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1378[2] {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1378[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1381 {
						r.EncodeNil()
					} else {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1378[3] {
					yym1383 := z.EncBinary()
					_ = yym1383
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1378[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initialDelaySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1384 := z.EncBinary()
					_ = yym1384
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1378[4] {
					yym1386 := z.EncBinary()
					_ = yym1386
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1378[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1387 := z.EncBinary()
					_ = yym1387
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1378[5] {
					yym1389 := z.EncBinary()
					_ = yym1389
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1378[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("periodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1390 := z.EncBinary()
					_ = yym1390
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1378[6] {
					yym1392 := z.EncBinary()
					_ = yym1392
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1378[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("successThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1393 := z.EncBinary()
					_ = yym1393
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1378[7] {
					yym1395 := z.EncBinary()
					_ = yym1395
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1378[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failureThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1396 := z.EncBinary()
					_ = yym1396
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Probe) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1397 := z.DecBinary()
	_ = yym1397
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1398 := r.ContainerType()
		if yyct1398 == codecSelferValueTypeMap1234 {
			yyl1398 := r.ReadMapStart()
			if yyl1398 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1398, d)
			}
		} else if yyct1398 == codecSelferValueTypeArray1234 {
			yyl1398 := r.ReadArrayStart()
			if yyl1398 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1398, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Probe) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1399Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1399Slc
	var yyhl1399 bool = l >= 0
	for yyj1399 := 0; ; yyj1399++ {
		if yyhl1399 {
			if yyj1399 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1399Slc = r.DecodeBytes(yys1399Slc, true, true)
		yys1399 := string(yys1399Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1399 {
		case "exec":
			if x.Handler.Exec == nil {
				x.Handler.Exec = new(ExecAction)
			}
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if x.Handler.HTTPGet == nil {
				x.Handler.HTTPGet = new(HTTPGetAction)
			}
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if x.Handler.TCPSocket == nil {
				x.Handler.TCPSocket = new(TCPSocketAction)
			}
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		case "initialDelaySeconds":
			if r.TryDecodeAsNil() {
				x.InitialDelaySeconds = 0
			} else {
				x.InitialDelaySeconds = int32(r.DecodeInt(32))
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				x.TimeoutSeconds = 0
			} else {
				x.TimeoutSeconds = int32(r.DecodeInt(32))
			}
		case "periodSeconds":
			if r.TryDecodeAsNil() {
				x.PeriodSeconds = 0
			} else {
				x.PeriodSeconds = int32(r.DecodeInt(32))
			}
		case "successThreshold":
			if r.TryDecodeAsNil() {
				x.SuccessThreshold = 0
			} else {
				x.SuccessThreshold = int32(r.DecodeInt(32))
			}
		case "failureThreshold":
			if r.TryDecodeAsNil() {
				x.FailureThreshold = 0
			} else {
				x.FailureThreshold = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1399)
		} // end switch yys1399
	} // end for yyj1399
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Probe) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1408 int
	var yyb1408 bool
	var yyhl1408 bool = l >= 0
	if x.Handler.Exec == nil {
		x.Handler.Exec = new(ExecAction)
	}
	yyj1408++
	if yyhl1408 {
		yyb1408 = yyj1408 > l
	} else {
		yyb1408 = r.CheckBreak()
	}
	if yyb1408 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	if x.Handler.HTTPGet == nil {
		x.Handler.HTTPGet = new(HTTPGetAction)
	}
	yyj1408++
	if yyhl1408 {
		yyb1408 = yyj1408 > l
	} else {
		yyb1408 = r.CheckBreak()
	}
	if yyb1408 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	if x.Handler.TCPSocket == nil {
		x.Handler.TCPSocket = new(TCPSocketAction)
	}
	yyj1408++
	if yyhl1408 {
		yyb1408 = yyj1408 > l
	} else {
		yyb1408 = r.CheckBreak()
	}
	if yyb1408 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	yyj1408++
	if yyhl1408 {
		yyb1408 = yyj1408 > l
	} else {
		yyb1408 = r.CheckBreak()
	}
	if yyb1408 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitialDelaySeconds = 0
	} else {
		x.InitialDelaySeconds = int32(r.DecodeInt(32))
	}
	yyj1408++
	if yyhl1408 {
		yyb1408 = yyj1408 > l
	} else {
		yyb1408 = r.CheckBreak()
	}
	if yyb1408 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TimeoutSeconds = 0
	} else {
		x.TimeoutSeconds = int32(r.DecodeInt(32))
	}
	yyj1408++
	if yyhl1408 {
		yyb1408 = yyj1408 > l
	} else {
		yyb1408 = r.CheckBreak()
	}
	if yyb1408 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PeriodSeconds = 0
	} else {
		x.PeriodSeconds = int32(r.DecodeInt(32))
	}
	yyj1408++
	if yyhl1408 {
		yyb1408 = yyj1408 > l
	} else {
		yyb1408 = r.CheckBreak()
	}
	if yyb1408 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SuccessThreshold = 0
	} else {
		x.SuccessThreshold = int32(r.DecodeInt(32))
	}
	yyj1408++
	if yyhl1408 {
		yyb1408 = yyj1408 > l
	} else {
		yyb1408 = r.CheckBreak()
	}
	if yyb1408 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureThreshold = 0
	} else {
		x.FailureThreshold = int32(r.DecodeInt(32))
	}
	for {
		yyj1408++
		if yyhl1408 {
			yyb1408 = yyj1408 > l
		} else {
			yyb1408 = r.CheckBreak()
		}
		if yyb1408 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1408-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PullPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1417 := z.EncBinary()
	_ = yym1417
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PullPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1418 := z.DecBinary()
	_ = yym1418
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Capability) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1419 := z.EncBinary()
	_ = yym1419
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Capability) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1420 := z.DecBinary()
	_ = yym1420
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Capabilities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1421 := z.EncBinary()
		_ = yym1421
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1422 := !z.EncBinary()
			yy2arr1422 := z.EncBasicHandle().StructToArray
			var yyq1422 [2]bool
			_, _, _ = yysep1422, yyq1422, yy2arr1422
			const yyr1422 bool = false
			yyq1422[0] = len(x.Add) != 0
			yyq1422[1] = len(x.Drop) != 0
			var yynn1422 int
			if yyr1422 || yy2arr1422 {
				r.EncodeArrayStart(2)
			} else {
				yynn1422 = 0
				for _, b := range yyq1422 {
					if b {
						yynn1422++
					}
				}
				r.EncodeMapStart(yynn1422)
				yynn1422 = 0
			}
			if yyr1422 || yy2arr1422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1422[0] {
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1424 := z.EncBinary()
						_ = yym1424
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1422[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("add"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1425 := z.EncBinary()
						_ = yym1425
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				}
			}
			if yyr1422 || yy2arr1422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1422[1] {
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1427 := z.EncBinary()
						_ = yym1427
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1422[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("drop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1428 := z.EncBinary()
						_ = yym1428
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				}
			}
			if yyr1422 || yy2arr1422 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Capabilities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1429 := z.DecBinary()
	_ = yym1429
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1430 := r.ContainerType()
		if yyct1430 == codecSelferValueTypeMap1234 {
			yyl1430 := r.ReadMapStart()
			if yyl1430 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1430, d)
			}
		} else if yyct1430 == codecSelferValueTypeArray1234 {
			yyl1430 := r.ReadArrayStart()
			if yyl1430 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1430, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Capabilities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1431Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1431Slc
	var yyhl1431 bool = l >= 0
	for yyj1431 := 0; ; yyj1431++ {
		if yyhl1431 {
			if yyj1431 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1431Slc = r.DecodeBytes(yys1431Slc, true, true)
		yys1431 := string(yys1431Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1431 {
		case "add":
			if r.TryDecodeAsNil() {
				x.Add = nil
			} else {
				yyv1432 := &x.Add
				yym1433 := z.DecBinary()
				_ = yym1433
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1432), d)
				}
			}
		case "drop":
			if r.TryDecodeAsNil() {
				x.Drop = nil
			} else {
				yyv1434 := &x.Drop
				yym1435 := z.DecBinary()
				_ = yym1435
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1434), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1431)
		} // end switch yys1431
	} // end for yyj1431
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Capabilities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1436 int
	var yyb1436 bool
	var yyhl1436 bool = l >= 0
	yyj1436++
	if yyhl1436 {
		yyb1436 = yyj1436 > l
	} else {
		yyb1436 = r.CheckBreak()
	}
	if yyb1436 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Add = nil
	} else {
		yyv1437 := &x.Add
		yym1438 := z.DecBinary()
		_ = yym1438
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1437), d)
		}
	}
	yyj1436++
	if yyhl1436 {
		yyb1436 = yyj1436 > l
	} else {
		yyb1436 = r.CheckBreak()
	}
	if yyb1436 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Drop = nil
	} else {
		yyv1439 := &x.Drop
		yym1440 := z.DecBinary()
		_ = yym1440
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1439), d)
		}
	}
	for {
		yyj1436++
		if yyhl1436 {
			yyb1436 = yyj1436 > l
		} else {
			yyb1436 = r.CheckBreak()
		}
		if yyb1436 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1436-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceRequirements) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1441 := z.EncBinary()
		_ = yym1441
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1442 := !z.EncBinary()
			yy2arr1442 := z.EncBasicHandle().StructToArray
			var yyq1442 [2]bool
			_, _, _ = yysep1442, yyq1442, yy2arr1442
			const yyr1442 bool = false
			yyq1442[0] = len(x.Limits) != 0
			yyq1442[1] = len(x.Requests) != 0
			var yynn1442 int
			if yyr1442 || yy2arr1442 {
				r.EncodeArrayStart(2)
			} else {
				yynn1442 = 0
				for _, b := range yyq1442 {
					if b {
						yynn1442++
					}
				}
				r.EncodeMapStart(yynn1442)
				yynn1442 = 0
			}
			if yyr1442 || yy2arr1442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1442[0] {
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1442[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("limits"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1442 || yy2arr1442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1442[1] {
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1442[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requests"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1442 || yy2arr1442 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceRequirements) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1445 := z.DecBinary()
	_ = yym1445
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1446 := r.ContainerType()
		if yyct1446 == codecSelferValueTypeMap1234 {
			yyl1446 := r.ReadMapStart()
			if yyl1446 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1446, d)
			}
		} else if yyct1446 == codecSelferValueTypeArray1234 {
			yyl1446 := r.ReadArrayStart()
			if yyl1446 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1446, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceRequirements) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1447Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1447Slc
	var yyhl1447 bool = l >= 0
	for yyj1447 := 0; ; yyj1447++ {
		if yyhl1447 {
			if yyj1447 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1447Slc = r.DecodeBytes(yys1447Slc, true, true)
		yys1447 := string(yys1447Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1447 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv1448 := &x.Limits
				yyv1448.CodecDecodeSelf(d)
			}
		case "requests":
			if r.TryDecodeAsNil() {
				x.Requests = nil
			} else {
				yyv1449 := &x.Requests
				yyv1449.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1447)
		} // end switch yys1447
	} // end for yyj1447
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceRequirements) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1450 int
	var yyb1450 bool
	var yyhl1450 bool = l >= 0
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv1451 := &x.Limits
		yyv1451.CodecDecodeSelf(d)
	}
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Requests = nil
	} else {
		yyv1452 := &x.Requests
		yyv1452.CodecDecodeSelf(d)
	}
	for {
		yyj1450++
		if yyhl1450 {
			yyb1450 = yyj1450 > l
		} else {
			yyb1450 = r.CheckBreak()
		}
		if yyb1450 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1450-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Container) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1453 := z.EncBinary()
		_ = yym1453
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1454 := !z.EncBinary()
			yy2arr1454 := z.EncBasicHandle().StructToArray
			var yyq1454 [18]bool
			_, _, _ = yysep1454, yyq1454, yy2arr1454
			const yyr1454 bool = false
			yyq1454[1] = x.Image != ""
			yyq1454[2] = len(x.Command) != 0
			yyq1454[3] = len(x.Args) != 0
			yyq1454[4] = x.WorkingDir != ""
			yyq1454[5] = len(x.Ports) != 0
			yyq1454[6] = len(x.Env) != 0
			yyq1454[7] = true
			yyq1454[8] = len(x.VolumeMounts) != 0
			yyq1454[9] = x.LivenessProbe != nil
			yyq1454[10] = x.ReadinessProbe != nil
			yyq1454[11] = x.Lifecycle != nil
			yyq1454[12] = x.TerminationMessagePath != ""
			yyq1454[13] = x.ImagePullPolicy != ""
			yyq1454[14] = x.SecurityContext != nil
			yyq1454[15] = x.Stdin != false
			yyq1454[16] = x.StdinOnce != false
			yyq1454[17] = x.TTY != false
			var yynn1454 int
			if yyr1454 || yy2arr1454 {
				r.EncodeArrayStart(18)
			} else {
				yynn1454 = 1
				for _, b := range yyq1454 {
					if b {
						yynn1454++
					}
				}
				r.EncodeMapStart(yynn1454)
				yynn1454 = 0
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1456 := z.EncBinary()
				_ = yym1456
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1457 := z.EncBinary()
				_ = yym1457
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[1] {
					yym1459 := z.EncBinary()
					_ = yym1459
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1454[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1460 := z.EncBinary()
					_ = yym1460
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Image))
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[2] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1462 := z.EncBinary()
						_ = yym1462
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1463 := z.EncBinary()
						_ = yym1463
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[3] {
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1465 := z.EncBinary()
						_ = yym1465
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("args"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1466 := z.EncBinary()
						_ = yym1466
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[4] {
					yym1468 := z.EncBinary()
					_ = yym1468
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1454[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("workingDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1469 := z.EncBinary()
					_ = yym1469
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[5] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1471 := z.EncBinary()
						_ = yym1471
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1472 := z.EncBinary()
						_ = yym1472
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[6] {
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1474 := z.EncBinary()
						_ = yym1474
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("env"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1475 := z.EncBinary()
						_ = yym1475
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[7] {
					yy1477 := &x.Resources
					yy1477.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1478 := &x.Resources
					yy1478.CodecEncodeSelf(e)
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[8] {
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1480 := z.EncBinary()
						_ = yym1480
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeMounts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1481 := z.EncBinary()
						_ = yym1481
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[9] {
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("livenessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[10] {
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readinessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[11] {
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lifecycle"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[12] {
					yym1486 := z.EncBinary()
					_ = yym1486
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1454[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationMessagePath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1487 := z.EncBinary()
					_ = yym1487
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[13] {
					x.ImagePullPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1454[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.ImagePullPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[14] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1454[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[15] {
					yym1491 := z.EncBinary()
					_ = yym1491
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1454[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1492 := z.EncBinary()
					_ = yym1492
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[16] {
					yym1494 := z.EncBinary()
					_ = yym1494
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1454[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdinOnce"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1495 := z.EncBinary()
					_ = yym1495
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1454[17] {
					yym1497 := z.EncBinary()
					_ = yym1497
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1454[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1498 := z.EncBinary()
					_ = yym1498
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr1454 || yy2arr1454 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Container) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1499 := z.DecBinary()
	_ = yym1499
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1500 := r.ContainerType()
		if yyct1500 == codecSelferValueTypeMap1234 {
			yyl1500 := r.ReadMapStart()
			if yyl1500 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1500, d)
			}
		} else if yyct1500 == codecSelferValueTypeArray1234 {
			yyl1500 := r.ReadArrayStart()
			if yyl1500 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1500, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Container) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1501Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1501Slc
	var yyhl1501 bool = l >= 0
	for yyj1501 := 0; ; yyj1501++ {
		if yyhl1501 {
			if yyj1501 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1501Slc = r.DecodeBytes(yys1501Slc, true, true)
		yys1501 := string(yys1501Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1501 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1504 := &x.Command
				yym1505 := z.DecBinary()
				_ = yym1505
				if false {
				} else {
					z.F.DecSliceStringX(yyv1504, false, d)
				}
			}
		case "args":
			if r.TryDecodeAsNil() {
				x.Args = nil
			} else {
				yyv1506 := &x.Args
				yym1507 := z.DecBinary()
				_ = yym1507
				if false {
				} else {
					z.F.DecSliceStringX(yyv1506, false, d)
				}
			}
		case "workingDir":
			if r.TryDecodeAsNil() {
				x.WorkingDir = ""
			} else {
				x.WorkingDir = string(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1509 := &x.Ports
				yym1510 := z.DecBinary()
				_ = yym1510
				if false {
				} else {
					h.decSliceContainerPort((*[]ContainerPort)(yyv1509), d)
				}
			}
		case "env":
			if r.TryDecodeAsNil() {
				x.Env = nil
			} else {
				yyv1511 := &x.Env
				yym1512 := z.DecBinary()
				_ = yym1512
				if false {
				} else {
					h.decSliceEnvVar((*[]EnvVar)(yyv1511), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv1513 := &x.Resources
				yyv1513.CodecDecodeSelf(d)
			}
		case "volumeMounts":
			if r.TryDecodeAsNil() {
				x.VolumeMounts = nil
			} else {
				yyv1514 := &x.VolumeMounts
				yym1515 := z.DecBinary()
				_ = yym1515
				if false {
				} else {
					h.decSliceVolumeMount((*[]VolumeMount)(yyv1514), d)
				}
			}
		case "livenessProbe":
			if r.TryDecodeAsNil() {
				if x.LivenessProbe != nil {
					x.LivenessProbe = nil
				}
			} else {
				if x.LivenessProbe == nil {
					x.LivenessProbe = new(Probe)
				}
				x.LivenessProbe.CodecDecodeSelf(d)
			}
		case "readinessProbe":
			if r.TryDecodeAsNil() {
				if x.ReadinessProbe != nil {
					x.ReadinessProbe = nil
				}
			} else {
				if x.ReadinessProbe == nil {
					x.ReadinessProbe = new(Probe)
				}
				x.ReadinessProbe.CodecDecodeSelf(d)
			}
		case "lifecycle":
			if r.TryDecodeAsNil() {
				if x.Lifecycle != nil {
					x.Lifecycle = nil
				}
			} else {
				if x.Lifecycle == nil {
					x.Lifecycle = new(Lifecycle)
				}
				x.Lifecycle.CodecDecodeSelf(d)
			}
		case "terminationMessagePath":
			if r.TryDecodeAsNil() {
				x.TerminationMessagePath = ""
			} else {
				x.TerminationMessagePath = string(r.DecodeString())
			}
		case "imagePullPolicy":
			if r.TryDecodeAsNil() {
				x.ImagePullPolicy = ""
			} else {
				x.ImagePullPolicy = PullPolicy(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(SecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdinOnce":
			if r.TryDecodeAsNil() {
				x.StdinOnce = false
			} else {
				x.StdinOnce = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1501)
		} // end switch yys1501
	} // end for yyj1501
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Container) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1525 int
	var yyb1525 bool
	var yyhl1525 bool = l >= 0
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1528 := &x.Command
		yym1529 := z.DecBinary()
		_ = yym1529
		if false {
		} else {
			z.F.DecSliceStringX(yyv1528, false, d)
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Args = nil
	} else {
		yyv1530 := &x.Args
		yym1531 := z.DecBinary()
		_ = yym1531
		if false {
		} else {
			z.F.DecSliceStringX(yyv1530, false, d)
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.WorkingDir = ""
	} else {
		x.WorkingDir = string(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1533 := &x.Ports
		yym1534 := z.DecBinary()
		_ = yym1534
		if false {
		} else {
			h.decSliceContainerPort((*[]ContainerPort)(yyv1533), d)
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Env = nil
	} else {
		yyv1535 := &x.Env
		yym1536 := z.DecBinary()
		_ = yym1536
		if false {
		} else {
			h.decSliceEnvVar((*[]EnvVar)(yyv1535), d)
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv1537 := &x.Resources
		yyv1537.CodecDecodeSelf(d)
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeMounts = nil
	} else {
		yyv1538 := &x.VolumeMounts
		yym1539 := z.DecBinary()
		_ = yym1539
		if false {
		} else {
			h.decSliceVolumeMount((*[]VolumeMount)(yyv1538), d)
		}
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LivenessProbe != nil {
			x.LivenessProbe = nil
		}
	} else {
		if x.LivenessProbe == nil {
			x.LivenessProbe = new(Probe)
		}
		x.LivenessProbe.CodecDecodeSelf(d)
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadinessProbe != nil {
			x.ReadinessProbe = nil
		}
	} else {
		if x.ReadinessProbe == nil {
			x.ReadinessProbe = new(Probe)
		}
		x.ReadinessProbe.CodecDecodeSelf(d)
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lifecycle != nil {
			x.Lifecycle = nil
		}
	} else {
		if x.Lifecycle == nil {
			x.Lifecycle = new(Lifecycle)
		}
		x.Lifecycle.CodecDecodeSelf(d)
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminationMessagePath = ""
	} else {
		x.TerminationMessagePath = string(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullPolicy = ""
	} else {
		x.ImagePullPolicy = PullPolicy(r.DecodeString())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(SecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StdinOnce = false
	} else {
		x.StdinOnce = bool(r.DecodeBool())
	}
	yyj1525++
	if yyhl1525 {
		yyb1525 = yyj1525 > l
	} else {
		yyb1525 = r.CheckBreak()
	}
	if yyb1525 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	for {
		yyj1525++
		if yyhl1525 {
			yyb1525 = yyj1525 > l
		} else {
			yyb1525 = r.CheckBreak()
		}
		if yyb1525 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1525-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Handler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1549 := z.EncBinary()
		_ = yym1549
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1550 := !z.EncBinary()
			yy2arr1550 := z.EncBasicHandle().StructToArray
			var yyq1550 [3]bool
			_, _, _ = yysep1550, yyq1550, yy2arr1550
			const yyr1550 bool = false
			yyq1550[0] = x.Exec != nil
			yyq1550[1] = x.HTTPGet != nil
			yyq1550[2] = x.TCPSocket != nil
			var yynn1550 int
			if yyr1550 || yy2arr1550 {
				r.EncodeArrayStart(3)
			} else {
				yynn1550 = 0
				for _, b := range yyq1550 {
					if b {
						yynn1550++
					}
				}
				r.EncodeMapStart(yynn1550)
				yynn1550 = 0
			}
			if yyr1550 || yy2arr1550 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1550[0] {
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1550[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1550 || yy2arr1550 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1550[1] {
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1550[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1550 || yy2arr1550 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1550[2] {
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1550[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1550 || yy2arr1550 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Handler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1554 := z.DecBinary()
	_ = yym1554
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1555 := r.ContainerType()
		if yyct1555 == codecSelferValueTypeMap1234 {
			yyl1555 := r.ReadMapStart()
			if yyl1555 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1555, d)
			}
		} else if yyct1555 == codecSelferValueTypeArray1234 {
			yyl1555 := r.ReadArrayStart()
			if yyl1555 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1555, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Handler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1556Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1556Slc
	var yyhl1556 bool = l >= 0
	for yyj1556 := 0; ; yyj1556++ {
		if yyhl1556 {
			if yyj1556 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1556Slc = r.DecodeBytes(yys1556Slc, true, true)
		yys1556 := string(yys1556Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1556 {
		case "exec":
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1556)
		} // end switch yys1556
	} // end for yyj1556
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Handler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1560 int
	var yyb1560 bool
	var yyhl1560 bool = l >= 0
	yyj1560++
	if yyhl1560 {
		yyb1560 = yyj1560 > l
	} else {
		yyb1560 = r.CheckBreak()
	}
	if yyb1560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	yyj1560++
	if yyhl1560 {
		yyb1560 = yyj1560 > l
	} else {
		yyb1560 = r.CheckBreak()
	}
	if yyb1560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	yyj1560++
	if yyhl1560 {
		yyb1560 = yyj1560 > l
	} else {
		yyb1560 = r.CheckBreak()
	}
	if yyb1560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	for {
		yyj1560++
		if yyhl1560 {
			yyb1560 = yyj1560 > l
		} else {
			yyb1560 = r.CheckBreak()
		}
		if yyb1560 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1560-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Lifecycle) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1564 := z.EncBinary()
		_ = yym1564
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1565 := !z.EncBinary()
			yy2arr1565 := z.EncBasicHandle().StructToArray
			var yyq1565 [2]bool
			_, _, _ = yysep1565, yyq1565, yy2arr1565
			const yyr1565 bool = false
			yyq1565[0] = x.PostStart != nil
			yyq1565[1] = x.PreStop != nil
			var yynn1565 int
			if yyr1565 || yy2arr1565 {
				r.EncodeArrayStart(2)
			} else {
				yynn1565 = 0
				for _, b := range yyq1565 {
					if b {
						yynn1565++
					}
				}
				r.EncodeMapStart(yynn1565)
				yynn1565 = 0
			}
			if yyr1565 || yy2arr1565 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1565[0] {
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1565[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("postStart"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1565 || yy2arr1565 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1565[1] {
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1565[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preStop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1565 || yy2arr1565 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Lifecycle) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1568 := z.DecBinary()
	_ = yym1568
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1569 := r.ContainerType()
		if yyct1569 == codecSelferValueTypeMap1234 {
			yyl1569 := r.ReadMapStart()
			if yyl1569 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1569, d)
			}
		} else if yyct1569 == codecSelferValueTypeArray1234 {
			yyl1569 := r.ReadArrayStart()
			if yyl1569 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1569, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Lifecycle) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1570Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1570Slc
	var yyhl1570 bool = l >= 0
	for yyj1570 := 0; ; yyj1570++ {
		if yyhl1570 {
			if yyj1570 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1570Slc = r.DecodeBytes(yys1570Slc, true, true)
		yys1570 := string(yys1570Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1570 {
		case "postStart":
			if r.TryDecodeAsNil() {
				if x.PostStart != nil {
					x.PostStart = nil
				}
			} else {
				if x.PostStart == nil {
					x.PostStart = new(Handler)
				}
				x.PostStart.CodecDecodeSelf(d)
			}
		case "preStop":
			if r.TryDecodeAsNil() {
				if x.PreStop != nil {
					x.PreStop = nil
				}
			} else {
				if x.PreStop == nil {
					x.PreStop = new(Handler)
				}
				x.PreStop.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1570)
		} // end switch yys1570
	} // end for yyj1570
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Lifecycle) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1573 int
	var yyb1573 bool
	var yyhl1573 bool = l >= 0
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PostStart != nil {
			x.PostStart = nil
		}
	} else {
		if x.PostStart == nil {
			x.PostStart = new(Handler)
		}
		x.PostStart.CodecDecodeSelf(d)
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PreStop != nil {
			x.PreStop = nil
		}
	} else {
		if x.PreStop == nil {
			x.PreStop = new(Handler)
		}
		x.PreStop.CodecDecodeSelf(d)
	}
	for {
		yyj1573++
		if yyhl1573 {
			yyb1573 = yyj1573 > l
		} else {
			yyb1573 = r.CheckBreak()
		}
		if yyb1573 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1573-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ConditionStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1576 := z.EncBinary()
	_ = yym1576
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ConditionStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1577 := z.DecBinary()
	_ = yym1577
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ContainerStateWaiting) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1578 := z.EncBinary()
		_ = yym1578
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1579 := !z.EncBinary()
			yy2arr1579 := z.EncBasicHandle().StructToArray
			var yyq1579 [2]bool
			_, _, _ = yysep1579, yyq1579, yy2arr1579
			const yyr1579 bool = false
			yyq1579[0] = x.Reason != ""
			yyq1579[1] = x.Message != ""
			var yynn1579 int
			if yyr1579 || yy2arr1579 {
				r.EncodeArrayStart(2)
			} else {
				yynn1579 = 0
				for _, b := range yyq1579 {
					if b {
						yynn1579++
					}
				}
				r.EncodeMapStart(yynn1579)
				yynn1579 = 0
			}
			if yyr1579 || yy2arr1579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1579[0] {
					yym1581 := z.EncBinary()
					_ = yym1581
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1579[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1582 := z.EncBinary()
					_ = yym1582
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1579 || yy2arr1579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1579[1] {
					yym1584 := z.EncBinary()
					_ = yym1584
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1579[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1585 := z.EncBinary()
					_ = yym1585
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1579 || yy2arr1579 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateWaiting) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1586 := z.DecBinary()
	_ = yym1586
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1587 := r.ContainerType()
		if yyct1587 == codecSelferValueTypeMap1234 {
			yyl1587 := r.ReadMapStart()
			if yyl1587 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1587, d)
			}
		} else if yyct1587 == codecSelferValueTypeArray1234 {
			yyl1587 := r.ReadArrayStart()
			if yyl1587 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1587, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateWaiting) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1588Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1588Slc
	var yyhl1588 bool = l >= 0
	for yyj1588 := 0; ; yyj1588++ {
		if yyhl1588 {
			if yyj1588 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1588Slc = r.DecodeBytes(yys1588Slc, true, true)
		yys1588 := string(yys1588Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1588 {
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1588)
		} // end switch yys1588
	} // end for yyj1588
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateWaiting) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1591 int
	var yyb1591 bool
	var yyhl1591 bool = l >= 0
	yyj1591++
	if yyhl1591 {
		yyb1591 = yyj1591 > l
	} else {
		yyb1591 = r.CheckBreak()
	}
	if yyb1591 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1591++
	if yyhl1591 {
		yyb1591 = yyj1591 > l
	} else {
		yyb1591 = r.CheckBreak()
	}
	if yyb1591 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1591++
		if yyhl1591 {
			yyb1591 = yyj1591 > l
		} else {
			yyb1591 = r.CheckBreak()
		}
		if yyb1591 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1591-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateRunning) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1594 := z.EncBinary()
		_ = yym1594
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1595 := !z.EncBinary()
			yy2arr1595 := z.EncBasicHandle().StructToArray
			var yyq1595 [1]bool
			_, _, _ = yysep1595, yyq1595, yy2arr1595
			const yyr1595 bool = false
			yyq1595[0] = true
			var yynn1595 int
			if yyr1595 || yy2arr1595 {
				r.EncodeArrayStart(1)
			} else {
				yynn1595 = 0
				for _, b := range yyq1595 {
					if b {
						yynn1595++
					}
				}
				r.EncodeMapStart(yynn1595)
				yynn1595 = 0
			}
			if yyr1595 || yy2arr1595 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1595[0] {
					yy1597 := &x.StartedAt
					yym1598 := z.EncBinary()
					_ = yym1598
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1597) {
					} else if yym1598 {
						z.EncBinaryMarshal(yy1597)
					} else if !yym1598 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1597)
					} else {
						z.EncFallback(yy1597)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1595[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1599 := &x.StartedAt
					yym1600 := z.EncBinary()
					_ = yym1600
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1599) {
					} else if yym1600 {
						z.EncBinaryMarshal(yy1599)
					} else if !yym1600 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1599)
					} else {
						z.EncFallback(yy1599)
					}
				}
			}
			if yyr1595 || yy2arr1595 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateRunning) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1601 := z.DecBinary()
	_ = yym1601
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1602 := r.ContainerType()
		if yyct1602 == codecSelferValueTypeMap1234 {
			yyl1602 := r.ReadMapStart()
			if yyl1602 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1602, d)
			}
		} else if yyct1602 == codecSelferValueTypeArray1234 {
			yyl1602 := r.ReadArrayStart()
			if yyl1602 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1602, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateRunning) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1603Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1603Slc
	var yyhl1603 bool = l >= 0
	for yyj1603 := 0; ; yyj1603++ {
		if yyhl1603 {
			if yyj1603 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1603Slc = r.DecodeBytes(yys1603Slc, true, true)
		yys1603 := string(yys1603Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1603 {
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1604 := &x.StartedAt
				yym1605 := z.DecBinary()
				_ = yym1605
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1604) {
				} else if yym1605 {
					z.DecBinaryUnmarshal(yyv1604)
				} else if !yym1605 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1604)
				} else {
					z.DecFallback(yyv1604, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1603)
		} // end switch yys1603
	} // end for yyj1603
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateRunning) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1606 int
	var yyb1606 bool
	var yyhl1606 bool = l >= 0
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1607 := &x.StartedAt
		yym1608 := z.DecBinary()
		_ = yym1608
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1607) {
		} else if yym1608 {
			z.DecBinaryUnmarshal(yyv1607)
		} else if !yym1608 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1607)
		} else {
			z.DecFallback(yyv1607, false)
		}
	}
	for {
		yyj1606++
		if yyhl1606 {
			yyb1606 = yyj1606 > l
		} else {
			yyb1606 = r.CheckBreak()
		}
		if yyb1606 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1606-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateTerminated) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1609 := z.EncBinary()
		_ = yym1609
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1610 := !z.EncBinary()
			yy2arr1610 := z.EncBasicHandle().StructToArray
			var yyq1610 [7]bool
			_, _, _ = yysep1610, yyq1610, yy2arr1610
			const yyr1610 bool = false
			yyq1610[1] = x.Signal != 0
			yyq1610[2] = x.Reason != ""
			yyq1610[3] = x.Message != ""
			yyq1610[4] = true
			yyq1610[5] = true
			yyq1610[6] = x.ContainerID != ""
			var yynn1610 int
			if yyr1610 || yy2arr1610 {
				r.EncodeArrayStart(7)
			} else {
				yynn1610 = 1
				for _, b := range yyq1610 {
					if b {
						yynn1610++
					}
				}
				r.EncodeMapStart(yynn1610)
				yynn1610 = 0
			}
			if yyr1610 || yy2arr1610 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1612 := z.EncBinary()
				_ = yym1612
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitCode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1613 := z.EncBinary()
				_ = yym1613
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			}
			if yyr1610 || yy2arr1610 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1610[1] {
					yym1615 := z.EncBinary()
					_ = yym1615
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1610[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("signal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1616 := z.EncBinary()
					_ = yym1616
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				}
			}
			if yyr1610 || yy2arr1610 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1610[2] {
					yym1618 := z.EncBinary()
					_ = yym1618
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1610[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1619 := z.EncBinary()
					_ = yym1619
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1610 || yy2arr1610 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1610[3] {
					yym1621 := z.EncBinary()
					_ = yym1621
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1610[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1622 := z.EncBinary()
					_ = yym1622
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1610 || yy2arr1610 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1610[4] {
					yy1624 := &x.StartedAt
					yym1625 := z.EncBinary()
					_ = yym1625
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1624) {
					} else if yym1625 {
						z.EncBinaryMarshal(yy1624)
					} else if !yym1625 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1624)
					} else {
						z.EncFallback(yy1624)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1610[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1626 := &x.StartedAt
					yym1627 := z.EncBinary()
					_ = yym1627
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1626) {
					} else if yym1627 {
						z.EncBinaryMarshal(yy1626)
					} else if !yym1627 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1626)
					} else {
						z.EncFallback(yy1626)
					}
				}
			}
			if yyr1610 || yy2arr1610 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1610[5] {
					yy1629 := &x.FinishedAt
					yym1630 := z.EncBinary()
					_ = yym1630
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1629) {
					} else if yym1630 {
						z.EncBinaryMarshal(yy1629)
					} else if !yym1630 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1629)
					} else {
						z.EncFallback(yy1629)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1610[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finishedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1631 := &x.FinishedAt
					yym1632 := z.EncBinary()
					_ = yym1632
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1631) {
					} else if yym1632 {
						z.EncBinaryMarshal(yy1631)
					} else if !yym1632 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1631)
					} else {
						z.EncFallback(yy1631)
					}
				}
			}
			if yyr1610 || yy2arr1610 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1610[6] {
					yym1634 := z.EncBinary()
					_ = yym1634
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1610[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1635 := z.EncBinary()
					_ = yym1635
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1610 || yy2arr1610 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateTerminated) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1636 := z.DecBinary()
	_ = yym1636
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1637 := r.ContainerType()
		if yyct1637 == codecSelferValueTypeMap1234 {
			yyl1637 := r.ReadMapStart()
			if yyl1637 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1637, d)
			}
		} else if yyct1637 == codecSelferValueTypeArray1234 {
			yyl1637 := r.ReadArrayStart()
			if yyl1637 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1637, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateTerminated) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1638Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1638Slc
	var yyhl1638 bool = l >= 0
	for yyj1638 := 0; ; yyj1638++ {
		if yyhl1638 {
			if yyj1638 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1638Slc = r.DecodeBytes(yys1638Slc, true, true)
		yys1638 := string(yys1638Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1638 {
		case "exitCode":
			if r.TryDecodeAsNil() {
				x.ExitCode = 0
			} else {
				x.ExitCode = int32(r.DecodeInt(32))
			}
		case "signal":
			if r.TryDecodeAsNil() {
				x.Signal = 0
			} else {
				x.Signal = int32(r.DecodeInt(32))
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1643 := &x.StartedAt
				yym1644 := z.DecBinary()
				_ = yym1644
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1643) {
				} else if yym1644 {
					z.DecBinaryUnmarshal(yyv1643)
				} else if !yym1644 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1643)
				} else {
					z.DecFallback(yyv1643, false)
				}
			}
		case "finishedAt":
			if r.TryDecodeAsNil() {
				x.FinishedAt = pkg2_unversioned.Time{}
			} else {
				yyv1645 := &x.FinishedAt
				yym1646 := z.DecBinary()
				_ = yym1646
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1645) {
				} else if yym1646 {
					z.DecBinaryUnmarshal(yyv1645)
				} else if !yym1646 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1645)
				} else {
					z.DecFallback(yyv1645, false)
				}
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1638)
		} // end switch yys1638
	} // end for yyj1638
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateTerminated) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1648 int
	var yyb1648 bool
	var yyhl1648 bool = l >= 0
	yyj1648++
	if yyhl1648 {
		yyb1648 = yyj1648 > l
	} else {
		yyb1648 = r.CheckBreak()
	}
	if yyb1648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitCode = 0
	} else {
		x.ExitCode = int32(r.DecodeInt(32))
	}
	yyj1648++
	if yyhl1648 {
		yyb1648 = yyj1648 > l
	} else {
		yyb1648 = r.CheckBreak()
	}
	if yyb1648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Signal = 0
	} else {
		x.Signal = int32(r.DecodeInt(32))
	}
	yyj1648++
	if yyhl1648 {
		yyb1648 = yyj1648 > l
	} else {
		yyb1648 = r.CheckBreak()
	}
	if yyb1648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1648++
	if yyhl1648 {
		yyb1648 = yyj1648 > l
	} else {
		yyb1648 = r.CheckBreak()
	}
	if yyb1648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj1648++
	if yyhl1648 {
		yyb1648 = yyj1648 > l
	} else {
		yyb1648 = r.CheckBreak()
	}
	if yyb1648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1653 := &x.StartedAt
		yym1654 := z.DecBinary()
		_ = yym1654
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1653) {
		} else if yym1654 {
			z.DecBinaryUnmarshal(yyv1653)
		} else if !yym1654 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1653)
		} else {
			z.DecFallback(yyv1653, false)
		}
	}
	yyj1648++
	if yyhl1648 {
		yyb1648 = yyj1648 > l
	} else {
		yyb1648 = r.CheckBreak()
	}
	if yyb1648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FinishedAt = pkg2_unversioned.Time{}
	} else {
		yyv1655 := &x.FinishedAt
		yym1656 := z.DecBinary()
		_ = yym1656
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1655) {
		} else if yym1656 {
			z.DecBinaryUnmarshal(yyv1655)
		} else if !yym1656 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1655)
		} else {
			z.DecFallback(yyv1655, false)
		}
	}
	yyj1648++
	if yyhl1648 {
		yyb1648 = yyj1648 > l
	} else {
		yyb1648 = r.CheckBreak()
	}
	if yyb1648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1648++
		if yyhl1648 {
			yyb1648 = yyj1648 > l
		} else {
			yyb1648 = r.CheckBreak()
		}
		if yyb1648 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1648-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerState) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1658 := z.EncBinary()
		_ = yym1658
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1659 := !z.EncBinary()
			yy2arr1659 := z.EncBasicHandle().StructToArray
			var yyq1659 [3]bool
			_, _, _ = yysep1659, yyq1659, yy2arr1659
			const yyr1659 bool = false
			yyq1659[0] = x.Waiting != nil
			yyq1659[1] = x.Running != nil
			yyq1659[2] = x.Terminated != nil
			var yynn1659 int
			if yyr1659 || yy2arr1659 {
				r.EncodeArrayStart(3)
			} else {
				yynn1659 = 0
				for _, b := range yyq1659 {
					if b {
						yynn1659++
					}
				}
				r.EncodeMapStart(yynn1659)
				yynn1659 = 0
			}
			if yyr1659 || yy2arr1659 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1659[0] {
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1659[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("waiting"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1659 || yy2arr1659 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1659[1] {
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1659[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("running"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1659 || yy2arr1659 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1659[2] {
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1659[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminated"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1659 || yy2arr1659 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerState) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1663 := z.DecBinary()
	_ = yym1663
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1664 := r.ContainerType()
		if yyct1664 == codecSelferValueTypeMap1234 {
			yyl1664 := r.ReadMapStart()
			if yyl1664 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1664, d)
			}
		} else if yyct1664 == codecSelferValueTypeArray1234 {
			yyl1664 := r.ReadArrayStart()
			if yyl1664 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1664, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerState) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1665Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1665Slc
	var yyhl1665 bool = l >= 0
	for yyj1665 := 0; ; yyj1665++ {
		if yyhl1665 {
			if yyj1665 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1665Slc = r.DecodeBytes(yys1665Slc, true, true)
		yys1665 := string(yys1665Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1665 {
		case "waiting":
			if r.TryDecodeAsNil() {
				if x.Waiting != nil {
					x.Waiting = nil
				}
			} else {
				if x.Waiting == nil {
					x.Waiting = new(ContainerStateWaiting)
				}
				x.Waiting.CodecDecodeSelf(d)
			}
		case "running":
			if r.TryDecodeAsNil() {
				if x.Running != nil {
					x.Running = nil
				}
			} else {
				if x.Running == nil {
					x.Running = new(ContainerStateRunning)
				}
				x.Running.CodecDecodeSelf(d)
			}
		case "terminated":
			if r.TryDecodeAsNil() {
				if x.Terminated != nil {
					x.Terminated = nil
				}
			} else {
				if x.Terminated == nil {
					x.Terminated = new(ContainerStateTerminated)
				}
				x.Terminated.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1665)
		} // end switch yys1665
	} // end for yyj1665
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerState) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1669 int
	var yyb1669 bool
	var yyhl1669 bool = l >= 0
	yyj1669++
	if yyhl1669 {
		yyb1669 = yyj1669 > l
	} else {
		yyb1669 = r.CheckBreak()
	}
	if yyb1669 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Waiting != nil {
			x.Waiting = nil
		}
	} else {
		if x.Waiting == nil {
			x.Waiting = new(ContainerStateWaiting)
		}
		x.Waiting.CodecDecodeSelf(d)
	}
	yyj1669++
	if yyhl1669 {
		yyb1669 = yyj1669 > l
	} else {
		yyb1669 = r.CheckBreak()
	}
	if yyb1669 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Running != nil {
			x.Running = nil
		}
	} else {
		if x.Running == nil {
			x.Running = new(ContainerStateRunning)
		}
		x.Running.CodecDecodeSelf(d)
	}
	yyj1669++
	if yyhl1669 {
		yyb1669 = yyj1669 > l
	} else {
		yyb1669 = r.CheckBreak()
	}
	if yyb1669 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Terminated != nil {
			x.Terminated = nil
		}
	} else {
		if x.Terminated == nil {
			x.Terminated = new(ContainerStateTerminated)
		}
		x.Terminated.CodecDecodeSelf(d)
	}
	for {
		yyj1669++
		if yyhl1669 {
			yyb1669 = yyj1669 > l
		} else {
			yyb1669 = r.CheckBreak()
		}
		if yyb1669 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1669-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1673 := z.EncBinary()
		_ = yym1673
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1674 := !z.EncBinary()
			yy2arr1674 := z.EncBasicHandle().StructToArray
			var yyq1674 [8]bool
			_, _, _ = yysep1674, yyq1674, yy2arr1674
			const yyr1674 bool = false
			yyq1674[1] = true
			yyq1674[2] = true
			yyq1674[7] = x.ContainerID != ""
			var yynn1674 int
			if yyr1674 || yy2arr1674 {
				r.EncodeArrayStart(8)
			} else {
				yynn1674 = 5
				for _, b := range yyq1674 {
					if b {
						yynn1674++
					}
				}
				r.EncodeMapStart(yynn1674)
				yynn1674 = 0
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1676 := z.EncBinary()
				_ = yym1676
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1677 := z.EncBinary()
				_ = yym1677
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1674[1] {
					yy1679 := &x.State
					yy1679.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1674[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("state"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1680 := &x.State
					yy1680.CodecEncodeSelf(e)
				}
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1674[2] {
					yy1682 := &x.LastTerminationState
					yy1682.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1674[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastState"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1683 := &x.LastTerminationState
					yy1683.CodecEncodeSelf(e)
				}
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1685 := z.EncBinary()
				_ = yym1685
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ready"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1686 := z.EncBinary()
				_ = yym1686
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1688 := z.EncBinary()
				_ = yym1688
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("restartCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1689 := z.EncBinary()
				_ = yym1689
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1691 := z.EncBinary()
				_ = yym1691
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1692 := z.EncBinary()
				_ = yym1692
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1694 := z.EncBinary()
				_ = yym1694
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1695 := z.EncBinary()
				_ = yym1695
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1674[7] {
					yym1697 := z.EncBinary()
					_ = yym1697
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1674[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1698 := z.EncBinary()
					_ = yym1698
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1674 || yy2arr1674 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1699 := z.DecBinary()
	_ = yym1699
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1700 := r.ContainerType()
		if yyct1700 == codecSelferValueTypeMap1234 {
			yyl1700 := r.ReadMapStart()
			if yyl1700 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1700, d)
			}
		} else if yyct1700 == codecSelferValueTypeArray1234 {
			yyl1700 := r.ReadArrayStart()
			if yyl1700 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1700, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1701Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1701Slc
	var yyhl1701 bool = l >= 0
	for yyj1701 := 0; ; yyj1701++ {
		if yyhl1701 {
			if yyj1701 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1701Slc = r.DecodeBytes(yys1701Slc, true, true)
		yys1701 := string(yys1701Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1701 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "state":
			if r.TryDecodeAsNil() {
				x.State = ContainerState{}
			} else {
				yyv1703 := &x.State
				yyv1703.CodecDecodeSelf(d)
			}
		case "lastState":
			if r.TryDecodeAsNil() {
				x.LastTerminationState = ContainerState{}
			} else {
				yyv1704 := &x.LastTerminationState
				yyv1704.CodecDecodeSelf(d)
			}
		case "ready":
			if r.TryDecodeAsNil() {
				x.Ready = false
			} else {
				x.Ready = bool(r.DecodeBool())
			}
		case "restartCount":
			if r.TryDecodeAsNil() {
				x.RestartCount = 0
			} else {
				x.RestartCount = int32(r.DecodeInt(32))
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "imageID":
			if r.TryDecodeAsNil() {
				x.ImageID = ""
			} else {
				x.ImageID = string(r.DecodeString())
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1701)
		} // end switch yys1701
	} // end for yyj1701
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1710 int
	var yyb1710 bool
	var yyhl1710 bool = l >= 0
	yyj1710++
	if yyhl1710 {
		yyb1710 = yyj1710 > l
	} else {
		yyb1710 = r.CheckBreak()
	}
	if yyb1710 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1710++
	if yyhl1710 {
		yyb1710 = yyj1710 > l
	} else {
		yyb1710 = r.CheckBreak()
	}
	if yyb1710 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.State = ContainerState{}
	} else {
		yyv1712 := &x.State
		yyv1712.CodecDecodeSelf(d)
	}
	yyj1710++
	if yyhl1710 {
		yyb1710 = yyj1710 > l
	} else {
		yyb1710 = r.CheckBreak()
	}
	if yyb1710 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTerminationState = ContainerState{}
	} else {
		yyv1713 := &x.LastTerminationState
		yyv1713.CodecDecodeSelf(d)
	}
	yyj1710++
	if yyhl1710 {
		yyb1710 = yyj1710 > l
	} else {
		yyb1710 = r.CheckBreak()
	}
	if yyb1710 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ready = false
	} else {
		x.Ready = bool(r.DecodeBool())
	}
	yyj1710++
	if yyhl1710 {
		yyb1710 = yyj1710 > l
	} else {
		yyb1710 = r.CheckBreak()
	}
	if yyb1710 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartCount = 0
	} else {
		x.RestartCount = int32(r.DecodeInt(32))
	}
	yyj1710++
	if yyhl1710 {
		yyb1710 = yyj1710 > l
	} else {
		yyb1710 = r.CheckBreak()
	}
	if yyb1710 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1710++
	if yyhl1710 {
		yyb1710 = yyj1710 > l
	} else {
		yyb1710 = r.CheckBreak()
	}
	if yyb1710 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageID = ""
	} else {
		x.ImageID = string(r.DecodeString())
	}
	yyj1710++
	if yyhl1710 {
		yyb1710 = yyj1710 > l
	} else {
		yyb1710 = r.CheckBreak()
	}
	if yyb1710 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1710++
		if yyhl1710 {
			yyb1710 = yyj1710 > l
		} else {
			yyb1710 = r.CheckBreak()
		}
		if yyb1710 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1710-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PodPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1719 := z.EncBinary()
	_ = yym1719
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1720 := z.DecBinary()
	_ = yym1720
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PodConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1721 := z.EncBinary()
	_ = yym1721
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1722 := z.DecBinary()
	_ = yym1722
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1723 := z.EncBinary()
		_ = yym1723
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1724 := !z.EncBinary()
			yy2arr1724 := z.EncBasicHandle().StructToArray
			var yyq1724 [6]bool
			_, _, _ = yysep1724, yyq1724, yy2arr1724
			const yyr1724 bool = false
			yyq1724[2] = true
			yyq1724[3] = true
			yyq1724[4] = x.Reason != ""
			yyq1724[5] = x.Message != ""
			var yynn1724 int
			if yyr1724 || yy2arr1724 {
				r.EncodeArrayStart(6)
			} else {
				yynn1724 = 2
				for _, b := range yyq1724 {
					if b {
						yynn1724++
					}
				}
				r.EncodeMapStart(yynn1724)
				yynn1724 = 0
			}
			if yyr1724 || yy2arr1724 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr1724 || yy2arr1724 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr1724 || yy2arr1724 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1724[2] {
					yy1728 := &x.LastProbeTime
					yym1729 := z.EncBinary()
					_ = yym1729
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1728) {
					} else if yym1729 {
						z.EncBinaryMarshal(yy1728)
					} else if !yym1729 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1728)
					} else {
						z.EncFallback(yy1728)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1724[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1730 := &x.LastProbeTime
					yym1731 := z.EncBinary()
					_ = yym1731
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1730) {
					} else if yym1731 {
						z.EncBinaryMarshal(yy1730)
					} else if !yym1731 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1730)
					} else {
						z.EncFallback(yy1730)
					}
				}
			}
			if yyr1724 || yy2arr1724 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1724[3] {
					yy1733 := &x.LastTransitionTime
					yym1734 := z.EncBinary()
					_ = yym1734
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1733) {
					} else if yym1734 {
						z.EncBinaryMarshal(yy1733)
					} else if !yym1734 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1733)
					} else {
						z.EncFallback(yy1733)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1724[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1735 := &x.LastTransitionTime
					yym1736 := z.EncBinary()
					_ = yym1736
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1735) {
					} else if yym1736 {
						z.EncBinaryMarshal(yy1735)
					} else if !yym1736 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1735)
					} else {
						z.EncFallback(yy1735)
					}
				}
			}
			if yyr1724 || yy2arr1724 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1724[4] {
					yym1738 := z.EncBinary()
					_ = yym1738
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1724[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1739 := z.EncBinary()
					_ = yym1739
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1724 || yy2arr1724 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1724[5] {
					yym1741 := z.EncBinary()
					_ = yym1741
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1724[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1742 := z.EncBinary()
					_ = yym1742
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1724 || yy2arr1724 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1743 := z.DecBinary()
	_ = yym1743
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1744 := r.ContainerType()
		if yyct1744 == codecSelferValueTypeMap1234 {
			yyl1744 := r.ReadMapStart()
			if yyl1744 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1744, d)
			}
		} else if yyct1744 == codecSelferValueTypeArray1234 {
			yyl1744 := r.ReadArrayStart()
			if yyl1744 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1744, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1745Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1745Slc
	var yyhl1745 bool = l >= 0
	for yyj1745 := 0; ; yyj1745++ {
		if yyhl1745 {
			if yyj1745 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1745Slc = r.DecodeBytes(yys1745Slc, true, true)
		yys1745 := string(yys1745Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1745 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = PodConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg2_unversioned.Time{}
			} else {
				yyv1748 := &x.LastProbeTime
				yym1749 := z.DecBinary()
				_ = yym1749
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1748) {
				} else if yym1749 {
					z.DecBinaryUnmarshal(yyv1748)
				} else if !yym1749 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1748)
				} else {
					z.DecFallback(yyv1748, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv1750 := &x.LastTransitionTime
				yym1751 := z.DecBinary()
				_ = yym1751
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1750) {
				} else if yym1751 {
					z.DecBinaryUnmarshal(yyv1750)
				} else if !yym1751 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1750)
				} else {
					z.DecFallback(yyv1750, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1745)
		} // end switch yys1745
	} // end for yyj1745
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1754 int
	var yyb1754 bool
	var yyhl1754 bool = l >= 0
	yyj1754++
	if yyhl1754 {
		yyb1754 = yyj1754 > l
	} else {
		yyb1754 = r.CheckBreak()
	}
	if yyb1754 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = PodConditionType(r.DecodeString())
	}
	yyj1754++
	if yyhl1754 {
		yyb1754 = yyj1754 > l
	} else {
		yyb1754 = r.CheckBreak()
	}
	if yyb1754 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj1754++
	if yyhl1754 {
		yyb1754 = yyj1754 > l
	} else {
		yyb1754 = r.CheckBreak()
	}
	if yyb1754 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg2_unversioned.Time{}
	} else {
		yyv1757 := &x.LastProbeTime
		yym1758 := z.DecBinary()
		_ = yym1758
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1757) {
		} else if yym1758 {
			z.DecBinaryUnmarshal(yyv1757)
		} else if !yym1758 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1757)
		} else {
			z.DecFallback(yyv1757, false)
		}
	}
	yyj1754++
	if yyhl1754 {
		yyb1754 = yyj1754 > l
	} else {
		yyb1754 = r.CheckBreak()
	}
	if yyb1754 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv1759 := &x.LastTransitionTime
		yym1760 := z.DecBinary()
		_ = yym1760
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1759) {
		} else if yym1760 {
			z.DecBinaryUnmarshal(yyv1759)
		} else if !yym1760 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1759)
		} else {
			z.DecFallback(yyv1759, false)
		}
	}
	yyj1754++
	if yyhl1754 {
		yyb1754 = yyj1754 > l
	} else {
		yyb1754 = r.CheckBreak()
	}
	if yyb1754 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1754++
	if yyhl1754 {
		yyb1754 = yyj1754 > l
	} else {
		yyb1754 = r.CheckBreak()
	}
	if yyb1754 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1754++
		if yyhl1754 {
			yyb1754 = yyj1754 > l
		} else {
			yyb1754 = r.CheckBreak()
		}
		if yyb1754 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1754-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RestartPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1763 := z.EncBinary()
	_ = yym1763
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RestartPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1764 := z.DecBinary()
	_ = yym1764
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x DNSPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1765 := z.EncBinary()
	_ = yym1765
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DNSPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1766 := z.DecBinary()
	_ = yym1766
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1767 := z.EncBinary()
		_ = yym1767
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1768 := !z.EncBinary()
			yy2arr1768 := z.EncBasicHandle().StructToArray
			var yyq1768 [1]bool
			_, _, _ = yysep1768, yyq1768, yy2arr1768
			const yyr1768 bool = false
			var yynn1768 int
			if yyr1768 || yy2arr1768 {
				r.EncodeArrayStart(1)
			} else {
				yynn1768 = 1
				for _, b := range yyq1768 {
					if b {
						yynn1768++
					}
				}
				r.EncodeMapStart(yynn1768)
				yynn1768 = 0
			}
			if yyr1768 || yy2arr1768 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym1770 := z.EncBinary()
					_ = yym1770
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSelectorTerms"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym1771 := z.EncBinary()
					_ = yym1771
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			}
			if yyr1768 || yy2arr1768 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1772 := z.DecBinary()
	_ = yym1772
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1773 := r.ContainerType()
		if yyct1773 == codecSelferValueTypeMap1234 {
			yyl1773 := r.ReadMapStart()
			if yyl1773 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1773, d)
			}
		} else if yyct1773 == codecSelferValueTypeArray1234 {
			yyl1773 := r.ReadArrayStart()
			if yyl1773 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1773, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1774Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1774Slc
	var yyhl1774 bool = l >= 0
	for yyj1774 := 0; ; yyj1774++ {
		if yyhl1774 {
			if yyj1774 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1774Slc = r.DecodeBytes(yys1774Slc, true, true)
		yys1774 := string(yys1774Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1774 {
		case "nodeSelectorTerms":
			if r.TryDecodeAsNil() {
				x.NodeSelectorTerms = nil
			} else {
				yyv1775 := &x.NodeSelectorTerms
				yym1776 := z.DecBinary()
				_ = yym1776
				if false {
				} else {
					h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv1775), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1774)
		} // end switch yys1774
	} // end for yyj1774
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1777 int
	var yyb1777 bool
	var yyhl1777 bool = l >= 0
	yyj1777++
	if yyhl1777 {
		yyb1777 = yyj1777 > l
	} else {
		yyb1777 = r.CheckBreak()
	}
	if yyb1777 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelectorTerms = nil
	} else {
		yyv1778 := &x.NodeSelectorTerms
		yym1779 := z.DecBinary()
		_ = yym1779
		if false {
		} else {
			h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv1778), d)
		}
	}
	for {
		yyj1777++
		if yyhl1777 {
			yyb1777 = yyj1777 > l
		} else {
			yyb1777 = r.CheckBreak()
		}
		if yyb1777 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1777-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1780 := z.EncBinary()
		_ = yym1780
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1781 := !z.EncBinary()
			yy2arr1781 := z.EncBasicHandle().StructToArray
			var yyq1781 [1]bool
			_, _, _ = yysep1781, yyq1781, yy2arr1781
			const yyr1781 bool = false
			var yynn1781 int
			if yyr1781 || yy2arr1781 {
				r.EncodeArrayStart(1)
			} else {
				yynn1781 = 1
				for _, b := range yyq1781 {
					if b {
						yynn1781++
					}
				}
				r.EncodeMapStart(yynn1781)
				yynn1781 = 0
			}
			if yyr1781 || yy2arr1781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym1783 := z.EncBinary()
					_ = yym1783
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym1784 := z.EncBinary()
					_ = yym1784
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			}
			if yyr1781 || yy2arr1781 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1785 := z.DecBinary()
	_ = yym1785
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1786 := r.ContainerType()
		if yyct1786 == codecSelferValueTypeMap1234 {
			yyl1786 := r.ReadMapStart()
			if yyl1786 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1786, d)
			}
		} else if yyct1786 == codecSelferValueTypeArray1234 {
			yyl1786 := r.ReadArrayStart()
			if yyl1786 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1786, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1787Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1787Slc
	var yyhl1787 bool = l >= 0
	for yyj1787 := 0; ; yyj1787++ {
		if yyhl1787 {
			if yyj1787 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1787Slc = r.DecodeBytes(yys1787Slc, true, true)
		yys1787 := string(yys1787Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1787 {
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv1788 := &x.MatchExpressions
				yym1789 := z.DecBinary()
				_ = yym1789
				if false {
				} else {
					h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv1788), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1787)
		} // end switch yys1787
	} // end for yyj1787
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1790 int
	var yyb1790 bool
	var yyhl1790 bool = l >= 0
	yyj1790++
	if yyhl1790 {
		yyb1790 = yyj1790 > l
	} else {
		yyb1790 = r.CheckBreak()
	}
	if yyb1790 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv1791 := &x.MatchExpressions
		yym1792 := z.DecBinary()
		_ = yym1792
		if false {
		} else {
			h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv1791), d)
		}
	}
	for {
		yyj1790++
		if yyhl1790 {
			yyb1790 = yyj1790 > l
		} else {
			yyb1790 = r.CheckBreak()
		}
		if yyb1790 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1790-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1793 := z.EncBinary()
		_ = yym1793
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1794 := !z.EncBinary()
			yy2arr1794 := z.EncBasicHandle().StructToArray
			var yyq1794 [3]bool
			_, _, _ = yysep1794, yyq1794, yy2arr1794
			const yyr1794 bool = false
			yyq1794[2] = len(x.Values) != 0
			var yynn1794 int
			if yyr1794 || yy2arr1794 {
				r.EncodeArrayStart(3)
			} else {
				yynn1794 = 2
				for _, b := range yyq1794 {
					if b {
						yynn1794++
					}
				}
				r.EncodeMapStart(yynn1794)
				yynn1794 = 0
			}
			if yyr1794 || yy2arr1794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1796 := z.EncBinary()
				_ = yym1796
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1797 := z.EncBinary()
				_ = yym1797
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1794 || yy2arr1794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr1794 || yy2arr1794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1794[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1800 := z.EncBinary()
						_ = yym1800
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1794[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1801 := z.EncBinary()
						_ = yym1801
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr1794 || yy2arr1794 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1802 := z.DecBinary()
	_ = yym1802
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1803 := r.ContainerType()
		if yyct1803 == codecSelferValueTypeMap1234 {
			yyl1803 := r.ReadMapStart()
			if yyl1803 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1803, d)
			}
		} else if yyct1803 == codecSelferValueTypeArray1234 {
			yyl1803 := r.ReadArrayStart()
			if yyl1803 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1803, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1804Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1804Slc
	var yyhl1804 bool = l >= 0
	for yyj1804 := 0; ; yyj1804++ {
		if yyhl1804 {
			if yyj1804 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1804Slc = r.DecodeBytes(yys1804Slc, true, true)
		yys1804 := string(yys1804Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1804 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = NodeSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv1807 := &x.Values
				yym1808 := z.DecBinary()
				_ = yym1808
				if false {
				} else {
					z.F.DecSliceStringX(yyv1807, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1804)
		} // end switch yys1804
	} // end for yyj1804
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1809 int
	var yyb1809 bool
	var yyhl1809 bool = l >= 0
	yyj1809++
	if yyhl1809 {
		yyb1809 = yyj1809 > l
	} else {
		yyb1809 = r.CheckBreak()
	}
	if yyb1809 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1809++
	if yyhl1809 {
		yyb1809 = yyj1809 > l
	} else {
		yyb1809 = r.CheckBreak()
	}
	if yyb1809 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = NodeSelectorOperator(r.DecodeString())
	}
	yyj1809++
	if yyhl1809 {
		yyb1809 = yyj1809 > l
	} else {
		yyb1809 = r.CheckBreak()
	}
	if yyb1809 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv1812 := &x.Values
		yym1813 := z.DecBinary()
		_ = yym1813
		if false {
		} else {
			z.F.DecSliceStringX(yyv1812, false, d)
		}
	}
	for {
		yyj1809++
		if yyhl1809 {
			yyb1809 = yyj1809 > l
		} else {
			yyb1809 = r.CheckBreak()
		}
		if yyb1809 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1809-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1814 := z.EncBinary()
	_ = yym1814
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1815 := z.DecBinary()
	_ = yym1815
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Affinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1816 := z.EncBinary()
		_ = yym1816
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1817 := !z.EncBinary()
			yy2arr1817 := z.EncBasicHandle().StructToArray
			var yyq1817 [3]bool
			_, _, _ = yysep1817, yyq1817, yy2arr1817
			const yyr1817 bool = false
			yyq1817[0] = x.NodeAffinity != nil
			yyq1817[1] = x.PodAffinity != nil
			yyq1817[2] = x.PodAntiAffinity != nil
			var yynn1817 int
			if yyr1817 || yy2arr1817 {
				r.EncodeArrayStart(3)
			} else {
				yynn1817 = 0
				for _, b := range yyq1817 {
					if b {
						yynn1817++
					}
				}
				r.EncodeMapStart(yynn1817)
				yynn1817 = 0
			}
			if yyr1817 || yy2arr1817 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1817[0] {
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1817[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1817 || yy2arr1817 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1817[1] {
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1817[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1817 || yy2arr1817 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1817[2] {
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1817[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAntiAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1817 || yy2arr1817 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Affinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1821 := z.DecBinary()
	_ = yym1821
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1822 := r.ContainerType()
		if yyct1822 == codecSelferValueTypeMap1234 {
			yyl1822 := r.ReadMapStart()
			if yyl1822 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1822, d)
			}
		} else if yyct1822 == codecSelferValueTypeArray1234 {
			yyl1822 := r.ReadArrayStart()
			if yyl1822 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1822, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Affinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1823Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1823Slc
	var yyhl1823 bool = l >= 0
	for yyj1823 := 0; ; yyj1823++ {
		if yyhl1823 {
			if yyj1823 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1823Slc = r.DecodeBytes(yys1823Slc, true, true)
		yys1823 := string(yys1823Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1823 {
		case "nodeAffinity":
			if r.TryDecodeAsNil() {
				if x.NodeAffinity != nil {
					x.NodeAffinity = nil
				}
			} else {
				if x.NodeAffinity == nil {
					x.NodeAffinity = new(NodeAffinity)
				}
				x.NodeAffinity.CodecDecodeSelf(d)
			}
		case "podAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAffinity != nil {
					x.PodAffinity = nil
				}
			} else {
				if x.PodAffinity == nil {
					x.PodAffinity = new(PodAffinity)
				}
				x.PodAffinity.CodecDecodeSelf(d)
			}
		case "podAntiAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAntiAffinity != nil {
					x.PodAntiAffinity = nil
				}
			} else {
				if x.PodAntiAffinity == nil {
					x.PodAntiAffinity = new(PodAntiAffinity)
				}
				x.PodAntiAffinity.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1823)
		} // end switch yys1823
	} // end for yyj1823
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Affinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1827 int
	var yyb1827 bool
	var yyhl1827 bool = l >= 0
	yyj1827++
	if yyhl1827 {
		yyb1827 = yyj1827 > l
	} else {
		yyb1827 = r.CheckBreak()
	}
	if yyb1827 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeAffinity != nil {
			x.NodeAffinity = nil
		}
	} else {
		if x.NodeAffinity == nil {
			x.NodeAffinity = new(NodeAffinity)
		}
		x.NodeAffinity.CodecDecodeSelf(d)
	}
	yyj1827++
	if yyhl1827 {
		yyb1827 = yyj1827 > l
	} else {
		yyb1827 = r.CheckBreak()
	}
	if yyb1827 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAffinity != nil {
			x.PodAffinity = nil
		}
	} else {
		if x.PodAffinity == nil {
			x.PodAffinity = new(PodAffinity)
		}
		x.PodAffinity.CodecDecodeSelf(d)
	}
	yyj1827++
	if yyhl1827 {
		yyb1827 = yyj1827 > l
	} else {
		yyb1827 = r.CheckBreak()
	}
	if yyb1827 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAntiAffinity != nil {
			x.PodAntiAffinity = nil
		}
	} else {
		if x.PodAntiAffinity == nil {
			x.PodAntiAffinity = new(PodAntiAffinity)
		}
		x.PodAntiAffinity.CodecDecodeSelf(d)
	}
	for {
		yyj1827++
		if yyhl1827 {
			yyb1827 = yyj1827 > l
		} else {
			yyb1827 = r.CheckBreak()
		}
		if yyb1827 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1827-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1831 := z.EncBinary()
		_ = yym1831
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1832 := !z.EncBinary()
			yy2arr1832 := z.EncBasicHandle().StructToArray
			var yyq1832 [2]bool
			_, _, _ = yysep1832, yyq1832, yy2arr1832
			const yyr1832 bool = false
			yyq1832[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq1832[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1832 int
			if yyr1832 || yy2arr1832 {
				r.EncodeArrayStart(2)
			} else {
				yynn1832 = 0
				for _, b := range yyq1832 {
					if b {
						yynn1832++
					}
				}
				r.EncodeMapStart(yynn1832)
				yynn1832 = 0
			}
			if yyr1832 || yy2arr1832 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1832[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1834 := z.EncBinary()
						_ = yym1834
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1832[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1835 := z.EncBinary()
						_ = yym1835
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1832 || yy2arr1832 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1832[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1837 := z.EncBinary()
						_ = yym1837
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1832[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1838 := z.EncBinary()
						_ = yym1838
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1832 || yy2arr1832 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1839 := z.DecBinary()
	_ = yym1839
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1840 := r.ContainerType()
		if yyct1840 == codecSelferValueTypeMap1234 {
			yyl1840 := r.ReadMapStart()
			if yyl1840 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1840, d)
			}
		} else if yyct1840 == codecSelferValueTypeArray1234 {
			yyl1840 := r.ReadArrayStart()
			if yyl1840 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1840, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1841Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1841Slc
	var yyhl1841 bool = l >= 0
	for yyj1841 := 0; ; yyj1841++ {
		if yyhl1841 {
			if yyj1841 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1841Slc = r.DecodeBytes(yys1841Slc, true, true)
		yys1841 := string(yys1841Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1841 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1842 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym1843 := z.DecBinary()
				_ = yym1843
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1842), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1844 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1845 := z.DecBinary()
				_ = yym1845
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1844), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1841)
		} // end switch yys1841
	} // end for yyj1841
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1846 int
	var yyb1846 bool
	var yyhl1846 bool = l >= 0
	yyj1846++
	if yyhl1846 {
		yyb1846 = yyj1846 > l
	} else {
		yyb1846 = r.CheckBreak()
	}
	if yyb1846 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1847 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym1848 := z.DecBinary()
		_ = yym1848
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1847), d)
		}
	}
	yyj1846++
	if yyhl1846 {
		yyb1846 = yyj1846 > l
	} else {
		yyb1846 = r.CheckBreak()
	}
	if yyb1846 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1849 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1850 := z.DecBinary()
		_ = yym1850
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1849), d)
		}
	}
	for {
		yyj1846++
		if yyhl1846 {
			yyb1846 = yyj1846 > l
		} else {
			yyb1846 = r.CheckBreak()
		}
		if yyb1846 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1846-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAntiAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1851 := z.EncBinary()
		_ = yym1851
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1852 := !z.EncBinary()
			yy2arr1852 := z.EncBasicHandle().StructToArray
			var yyq1852 [2]bool
			_, _, _ = yysep1852, yyq1852, yy2arr1852
			const yyr1852 bool = false
			yyq1852[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq1852[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1852 int
			if yyr1852 || yy2arr1852 {
				r.EncodeArrayStart(2)
			} else {
				yynn1852 = 0
				for _, b := range yyq1852 {
					if b {
						yynn1852++
					}
				}
				r.EncodeMapStart(yynn1852)
				yynn1852 = 0
			}
			if yyr1852 || yy2arr1852 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1852[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1854 := z.EncBinary()
						_ = yym1854
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1852[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1855 := z.EncBinary()
						_ = yym1855
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1852 || yy2arr1852 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1852[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1857 := z.EncBinary()
						_ = yym1857
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1852[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1858 := z.EncBinary()
						_ = yym1858
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1852 || yy2arr1852 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAntiAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1859 := z.DecBinary()
	_ = yym1859
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1860 := r.ContainerType()
		if yyct1860 == codecSelferValueTypeMap1234 {
			yyl1860 := r.ReadMapStart()
			if yyl1860 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1860, d)
			}
		} else if yyct1860 == codecSelferValueTypeArray1234 {
			yyl1860 := r.ReadArrayStart()
			if yyl1860 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1860, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAntiAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1861Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1861Slc
	var yyhl1861 bool = l >= 0
	for yyj1861 := 0; ; yyj1861++ {
		if yyhl1861 {
			if yyj1861 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1861Slc = r.DecodeBytes(yys1861Slc, true, true)
		yys1861 := string(yys1861Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1861 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1862 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym1863 := z.DecBinary()
				_ = yym1863
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1862), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1864 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1865 := z.DecBinary()
				_ = yym1865
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1864), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1861)
		} // end switch yys1861
	} // end for yyj1861
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAntiAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1866 int
	var yyb1866 bool
	var yyhl1866 bool = l >= 0
	yyj1866++
	if yyhl1866 {
		yyb1866 = yyj1866 > l
	} else {
		yyb1866 = r.CheckBreak()
	}
	if yyb1866 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1867 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym1868 := z.DecBinary()
		_ = yym1868
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1867), d)
		}
	}
	yyj1866++
	if yyhl1866 {
		yyb1866 = yyj1866 > l
	} else {
		yyb1866 = r.CheckBreak()
	}
	if yyb1866 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1869 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1870 := z.DecBinary()
		_ = yym1870
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1869), d)
		}
	}
	for {
		yyj1866++
		if yyhl1866 {
			yyb1866 = yyj1866 > l
		} else {
			yyb1866 = r.CheckBreak()
		}
		if yyb1866 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1866-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *WeightedPodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1871 := z.EncBinary()
		_ = yym1871
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1872 := !z.EncBinary()
			yy2arr1872 := z.EncBasicHandle().StructToArray
			var yyq1872 [2]bool
			_, _, _ = yysep1872, yyq1872, yy2arr1872
			const yyr1872 bool = false
			var yynn1872 int
			if yyr1872 || yy2arr1872 {
				r.EncodeArrayStart(2)
			} else {
				yynn1872 = 2
				for _, b := range yyq1872 {
					if b {
						yynn1872++
					}
				}
				r.EncodeMapStart(yynn1872)
				yynn1872 = 0
			}
			if yyr1872 || yy2arr1872 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1874 := z.EncBinary()
				_ = yym1874
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1875 := z.EncBinary()
				_ = yym1875
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr1872 || yy2arr1872 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1877 := &x.PodAffinityTerm
				yy1877.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podAffinityTerm"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1878 := &x.PodAffinityTerm
				yy1878.CodecEncodeSelf(e)
			}
			if yyr1872 || yy2arr1872 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *WeightedPodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1879 := z.DecBinary()
	_ = yym1879
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1880 := r.ContainerType()
		if yyct1880 == codecSelferValueTypeMap1234 {
			yyl1880 := r.ReadMapStart()
			if yyl1880 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1880, d)
			}
		} else if yyct1880 == codecSelferValueTypeArray1234 {
			yyl1880 := r.ReadArrayStart()
			if yyl1880 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1880, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1881Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1881Slc
	var yyhl1881 bool = l >= 0
	for yyj1881 := 0; ; yyj1881++ {
		if yyhl1881 {
			if yyj1881 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1881Slc = r.DecodeBytes(yys1881Slc, true, true)
		yys1881 := string(yys1881Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1881 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				x.Weight = int32(r.DecodeInt(32))
			}
		case "podAffinityTerm":
			if r.TryDecodeAsNil() {
				x.PodAffinityTerm = PodAffinityTerm{}
			} else {
				yyv1883 := &x.PodAffinityTerm
				yyv1883.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1881)
		} // end switch yys1881
	} // end for yyj1881
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1884 int
	var yyb1884 bool
	var yyhl1884 bool = l >= 0
	yyj1884++
	if yyhl1884 {
		yyb1884 = yyj1884 > l
	} else {
		yyb1884 = r.CheckBreak()
	}
	if yyb1884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		x.Weight = int32(r.DecodeInt(32))
	}
	yyj1884++
	if yyhl1884 {
		yyb1884 = yyj1884 > l
	} else {
		yyb1884 = r.CheckBreak()
	}
	if yyb1884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodAffinityTerm = PodAffinityTerm{}
	} else {
		yyv1886 := &x.PodAffinityTerm
		yyv1886.CodecDecodeSelf(d)
	}
	for {
		yyj1884++
		if yyhl1884 {
			yyb1884 = yyj1884 > l
		} else {
			yyb1884 = r.CheckBreak()
		}
		if yyb1884 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1884-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1887 := z.EncBinary()
		_ = yym1887
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1888 := !z.EncBinary()
			yy2arr1888 := z.EncBasicHandle().StructToArray
			var yyq1888 [3]bool
			_, _, _ = yysep1888, yyq1888, yy2arr1888
			const yyr1888 bool = false
			yyq1888[0] = x.LabelSelector != nil
			yyq1888[2] = x.TopologyKey != ""
			var yynn1888 int
			if yyr1888 || yy2arr1888 {
				r.EncodeArrayStart(3)
			} else {
				yynn1888 = 1
				for _, b := range yyq1888 {
					if b {
						yynn1888++
					}
				}
				r.EncodeMapStart(yynn1888)
				yynn1888 = 0
			}
			if yyr1888 || yy2arr1888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1888[0] {
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym1890 := z.EncBinary()
						_ = yym1890
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1888[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labelSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym1891 := z.EncBinary()
						_ = yym1891
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				}
			}
			if yyr1888 || yy2arr1888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Namespaces == nil {
					r.EncodeNil()
				} else {
					yym1893 := z.EncBinary()
					_ = yym1893
					if false {
					} else {
						z.F.EncSliceStringV(x.Namespaces, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaces"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Namespaces == nil {
					r.EncodeNil()
				} else {
					yym1894 := z.EncBinary()
					_ = yym1894
					if false {
					} else {
						z.F.EncSliceStringV(x.Namespaces, false, e)
					}
				}
			}
			if yyr1888 || yy2arr1888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1888[2] {
					yym1896 := z.EncBinary()
					_ = yym1896
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1888[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("topologyKey"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1897 := z.EncBinary()
					_ = yym1897
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				}
			}
			if yyr1888 || yy2arr1888 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1898 := z.DecBinary()
	_ = yym1898
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1899 := r.ContainerType()
		if yyct1899 == codecSelferValueTypeMap1234 {
			yyl1899 := r.ReadMapStart()
			if yyl1899 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1899, d)
			}
		} else if yyct1899 == codecSelferValueTypeArray1234 {
			yyl1899 := r.ReadArrayStart()
			if yyl1899 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1899, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1900Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1900Slc
	var yyhl1900 bool = l >= 0
	for yyj1900 := 0; ; yyj1900++ {
		if yyhl1900 {
			if yyj1900 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1900Slc = r.DecodeBytes(yys1900Slc, true, true)
		yys1900 := string(yys1900Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1900 {
		case "labelSelector":
			if r.TryDecodeAsNil() {
				if x.LabelSelector != nil {
					x.LabelSelector = nil
				}
			} else {
				if x.LabelSelector == nil {
					x.LabelSelector = new(pkg2_unversioned.LabelSelector)
				}
				yym1902 := z.DecBinary()
				_ = yym1902
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
				} else {
					z.DecFallback(x.LabelSelector, false)
				}
			}
		case "namespaces":
			if r.TryDecodeAsNil() {
				x.Namespaces = nil
			} else {
				yyv1903 := &x.Namespaces
				yym1904 := z.DecBinary()
				_ = yym1904
				if false {
				} else {
					z.F.DecSliceStringX(yyv1903, false, d)
				}
			}
		case "topologyKey":
			if r.TryDecodeAsNil() {
				x.TopologyKey = ""
			} else {
				x.TopologyKey = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1900)
		} // end switch yys1900
	} // end for yyj1900
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1906 int
	var yyb1906 bool
	var yyhl1906 bool = l >= 0
	yyj1906++
	if yyhl1906 {
		yyb1906 = yyj1906 > l
	} else {
		yyb1906 = r.CheckBreak()
	}
	if yyb1906 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LabelSelector != nil {
			x.LabelSelector = nil
		}
	} else {
		if x.LabelSelector == nil {
			x.LabelSelector = new(pkg2_unversioned.LabelSelector)
		}
		yym1908 := z.DecBinary()
		_ = yym1908
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
		} else {
			z.DecFallback(x.LabelSelector, false)
		}
	}
	yyj1906++
	if yyhl1906 {
		yyb1906 = yyj1906 > l
	} else {
		yyb1906 = r.CheckBreak()
	}
	if yyb1906 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespaces = nil
	} else {
		yyv1909 := &x.Namespaces
		yym1910 := z.DecBinary()
		_ = yym1910
		if false {
		} else {
			z.F.DecSliceStringX(yyv1909, false, d)
		}
	}
	yyj1906++
	if yyhl1906 {
		yyb1906 = yyj1906 > l
	} else {
		yyb1906 = r.CheckBreak()
	}
	if yyb1906 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TopologyKey = ""
	} else {
		x.TopologyKey = string(r.DecodeString())
	}
	for {
		yyj1906++
		if yyhl1906 {
			yyb1906 = yyj1906 > l
		} else {
			yyb1906 = r.CheckBreak()
		}
		if yyb1906 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1906-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1912 := z.EncBinary()
		_ = yym1912
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1913 := !z.EncBinary()
			yy2arr1913 := z.EncBasicHandle().StructToArray
			var yyq1913 [2]bool
			_, _, _ = yysep1913, yyq1913, yy2arr1913
			const yyr1913 bool = false
			yyq1913[0] = x.RequiredDuringSchedulingIgnoredDuringExecution != nil
			yyq1913[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1913 int
			if yyr1913 || yy2arr1913 {
				r.EncodeArrayStart(2)
			} else {
				yynn1913 = 0
				for _, b := range yyq1913 {
					if b {
						yynn1913++
					}
				}
				r.EncodeMapStart(yynn1913)
				yynn1913 = 0
			}
			if yyr1913 || yy2arr1913 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1913[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1913[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1913 || yy2arr1913 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1913[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1916 := z.EncBinary()
						_ = yym1916
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1913[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1917 := z.EncBinary()
						_ = yym1917
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1913 || yy2arr1913 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1918 := z.DecBinary()
	_ = yym1918
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1919 := r.ContainerType()
		if yyct1919 == codecSelferValueTypeMap1234 {
			yyl1919 := r.ReadMapStart()
			if yyl1919 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1919, d)
			}
		} else if yyct1919 == codecSelferValueTypeArray1234 {
			yyl1919 := r.ReadArrayStart()
			if yyl1919 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1919, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1920Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1920Slc
	var yyhl1920 bool = l >= 0
	for yyj1920 := 0; ; yyj1920++ {
		if yyhl1920 {
			if yyj1920 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1920Slc = r.DecodeBytes(yys1920Slc, true, true)
		yys1920 := string(yys1920Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1920 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = nil
				}
			} else {
				if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
				}
				x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1922 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1923 := z.DecBinary()
				_ = yym1923
				if false {
				} else {
					h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv1922), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1920)
		} // end switch yys1920
	} // end for yyj1920
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1924 int
	var yyb1924 bool
	var yyhl1924 bool = l >= 0
	yyj1924++
	if yyhl1924 {
		yyb1924 = yyj1924 > l
	} else {
		yyb1924 = r.CheckBreak()
	}
	if yyb1924 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = nil
		}
	} else {
		if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
		}
		x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
	}
	yyj1924++
	if yyhl1924 {
		yyb1924 = yyj1924 > l
	} else {
		yyb1924 = r.CheckBreak()
	}
	if yyb1924 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1926 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1927 := z.DecBinary()
		_ = yym1927
		if false {
		} else {
			h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv1926), d)
		}
	}
	for {
		yyj1924++
		if yyhl1924 {
			yyb1924 = yyj1924 > l
		} else {
			yyb1924 = r.CheckBreak()
		}
		if yyb1924 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1924-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferredSchedulingTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1928 := z.EncBinary()
		_ = yym1928
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1929 := !z.EncBinary()
			yy2arr1929 := z.EncBasicHandle().StructToArray
			var yyq1929 [2]bool
			_, _, _ = yysep1929, yyq1929, yy2arr1929
			const yyr1929 bool = false
			var yynn1929 int
			if yyr1929 || yy2arr1929 {
				r.EncodeArrayStart(2)
			} else {
				yynn1929 = 2
				for _, b := range yyq1929 {
					if b {
						yynn1929++
					}
				}
				r.EncodeMapStart(yynn1929)
				yynn1929 = 0
			}
			if yyr1929 || yy2arr1929 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1931 := z.EncBinary()
				_ = yym1931
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1932 := z.EncBinary()
				_ = yym1932
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr1929 || yy2arr1929 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1934 := &x.Preference
				yy1934.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("preference"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1935 := &x.Preference
				yy1935.CodecEncodeSelf(e)
			}
			if yyr1929 || yy2arr1929 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PreferredSchedulingTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1936 := z.DecBinary()
	_ = yym1936
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1937 := r.ContainerType()
		if yyct1937 == codecSelferValueTypeMap1234 {
			yyl1937 := r.ReadMapStart()
			if yyl1937 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1937, d)
			}
		} else if yyct1937 == codecSelferValueTypeArray1234 {
			yyl1937 := r.ReadArrayStart()
			if yyl1937 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1937, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1938Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1938Slc
	var yyhl1938 bool = l >= 0
	for yyj1938 := 0; ; yyj1938++ {
		if yyhl1938 {
			if yyj1938 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1938Slc = r.DecodeBytes(yys1938Slc, true, true)
		yys1938 := string(yys1938Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1938 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				x.Weight = int32(r.DecodeInt(32))
			}
		case "preference":
			if r.TryDecodeAsNil() {
				x.Preference = NodeSelectorTerm{}
			} else {
				yyv1940 := &x.Preference
				yyv1940.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1938)
		} // end switch yys1938
	} // end for yyj1938
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1941 int
	var yyb1941 bool
	var yyhl1941 bool = l >= 0
	yyj1941++
	if yyhl1941 {
		yyb1941 = yyj1941 > l
	} else {
		yyb1941 = r.CheckBreak()
	}
	if yyb1941 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		x.Weight = int32(r.DecodeInt(32))
	}
	yyj1941++
	if yyhl1941 {
		yyb1941 = yyj1941 > l
	} else {
		yyb1941 = r.CheckBreak()
	}
	if yyb1941 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Preference = NodeSelectorTerm{}
	} else {
		yyv1943 := &x.Preference
		yyv1943.CodecDecodeSelf(d)
	}
	for {
		yyj1941++
		if yyhl1941 {
			yyb1941 = yyj1941 > l
		} else {
			yyb1941 = r.CheckBreak()
		}
		if yyb1941 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1941-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Taint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1944 := z.EncBinary()
		_ = yym1944
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1945 := !z.EncBinary()
			yy2arr1945 := z.EncBasicHandle().StructToArray
			var yyq1945 [3]bool
			_, _, _ = yysep1945, yyq1945, yy2arr1945
			const yyr1945 bool = false
			yyq1945[1] = x.Value != ""
			var yynn1945 int
			if yyr1945 || yy2arr1945 {
				r.EncodeArrayStart(3)
			} else {
				yynn1945 = 2
				for _, b := range yyq1945 {
					if b {
						yynn1945++
					}
				}
				r.EncodeMapStart(yynn1945)
				yynn1945 = 0
			}
			if yyr1945 || yy2arr1945 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1947 := z.EncBinary()
				_ = yym1947
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1948 := z.EncBinary()
				_ = yym1948
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1945 || yy2arr1945 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1945[1] {
					yym1950 := z.EncBinary()
					_ = yym1950
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1945[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1951 := z.EncBinary()
					_ = yym1951
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr1945 || yy2arr1945 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Effect.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("effect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Effect.CodecEncodeSelf(e)
			}
			if yyr1945 || yy2arr1945 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Taint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1953 := z.DecBinary()
	_ = yym1953
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1954 := r.ContainerType()
		if yyct1954 == codecSelferValueTypeMap1234 {
			yyl1954 := r.ReadMapStart()
			if yyl1954 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1954, d)
			}
		} else if yyct1954 == codecSelferValueTypeArray1234 {
			yyl1954 := r.ReadArrayStart()
			if yyl1954 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1954, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Taint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1955Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1955Slc
	var yyhl1955 bool = l >= 0
	for yyj1955 := 0; ; yyj1955++ {
		if yyhl1955 {
			if yyj1955 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1955Slc = r.DecodeBytes(yys1955Slc, true, true)
		yys1955 := string(yys1955Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1955 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				x.Effect = TaintEffect(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1955)
		} // end switch yys1955
	} // end for yyj1955
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Taint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1959 int
	var yyb1959 bool
	var yyhl1959 bool = l >= 0
	yyj1959++
	if yyhl1959 {
		yyb1959 = yyj1959 > l
	} else {
		yyb1959 = r.CheckBreak()
	}
	if yyb1959 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1959++
	if yyhl1959 {
		yyb1959 = yyj1959 > l
	} else {
		yyb1959 = r.CheckBreak()
	}
	if yyb1959 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj1959++
	if yyhl1959 {
		yyb1959 = yyj1959 > l
	} else {
		yyb1959 = r.CheckBreak()
	}
	if yyb1959 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		x.Effect = TaintEffect(r.DecodeString())
	}
	for {
		yyj1959++
		if yyhl1959 {
			yyb1959 = yyj1959 > l
		} else {
			yyb1959 = r.CheckBreak()
		}
		if yyb1959 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1959-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TaintEffect) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1963 := z.EncBinary()
	_ = yym1963
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TaintEffect) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1964 := z.DecBinary()
	_ = yym1964
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Toleration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1965 := z.EncBinary()
		_ = yym1965
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1966 := !z.EncBinary()
			yy2arr1966 := z.EncBasicHandle().StructToArray
			var yyq1966 [4]bool
			_, _, _ = yysep1966, yyq1966, yy2arr1966
			const yyr1966 bool = false
			yyq1966[0] = x.Key != ""
			yyq1966[1] = x.Operator != ""
			yyq1966[2] = x.Value != ""
			yyq1966[3] = x.Effect != ""
			var yynn1966 int
			if yyr1966 || yy2arr1966 {
				r.EncodeArrayStart(4)
			} else {
				yynn1966 = 0
				for _, b := range yyq1966 {
					if b {
						yynn1966++
					}
				}
				r.EncodeMapStart(yynn1966)
				yynn1966 = 0
			}
			if yyr1966 || yy2arr1966 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1966[0] {
					yym1968 := z.EncBinary()
					_ = yym1968
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1966[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("key"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1969 := z.EncBinary()
					_ = yym1969
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				}
			}
			if yyr1966 || yy2arr1966 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1966[1] {
					x.Operator.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1966[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("operator"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Operator.CodecEncodeSelf(e)
				}
			}
			if yyr1966 || yy2arr1966 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1966[2] {
					yym1972 := z.EncBinary()
					_ = yym1972
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1966[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1973 := z.EncBinary()
					_ = yym1973
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr1966 || yy2arr1966 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1966[3] {
					x.Effect.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1966[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("effect"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Effect.CodecEncodeSelf(e)
				}
			}
			if yyr1966 || yy2arr1966 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Toleration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1975 := z.DecBinary()
	_ = yym1975
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1976 := r.ContainerType()
		if yyct1976 == codecSelferValueTypeMap1234 {
			yyl1976 := r.ReadMapStart()
			if yyl1976 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1976, d)
			}
		} else if yyct1976 == codecSelferValueTypeArray1234 {
			yyl1976 := r.ReadArrayStart()
			if yyl1976 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1976, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Toleration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1977Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1977Slc
	var yyhl1977 bool = l >= 0
	for yyj1977 := 0; ; yyj1977++ {
		if yyhl1977 {
			if yyj1977 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1977Slc = r.DecodeBytes(yys1977Slc, true, true)
		yys1977 := string(yys1977Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1977 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = TolerationOperator(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				x.Effect = TaintEffect(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1977)
		} // end switch yys1977
	} // end for yyj1977
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Toleration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1982 int
	var yyb1982 bool
	var yyhl1982 bool = l >= 0
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = TolerationOperator(r.DecodeString())
	}
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj1982++
	if yyhl1982 {
		yyb1982 = yyj1982 > l
	} else {
		yyb1982 = r.CheckBreak()
	}
	if yyb1982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		x.Effect = TaintEffect(r.DecodeString())
	}
	for {
		yyj1982++
		if yyhl1982 {
			yyb1982 = yyj1982 > l
		} else {
			yyb1982 = r.CheckBreak()
		}
		if yyb1982 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1982-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TolerationOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1987 := z.EncBinary()
	_ = yym1987
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TolerationOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1988 := z.DecBinary()
	_ = yym1988
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1989 := z.EncBinary()
		_ = yym1989
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1990 := !z.EncBinary()
			yy2arr1990 := z.EncBasicHandle().StructToArray
			var yyq1990 [17]bool
			_, _, _ = yysep1990, yyq1990, yy2arr1990
			const yyr1990 bool = false
			yyq1990[0] = len(x.Volumes) != 0
			yyq1990[2] = x.RestartPolicy != ""
			yyq1990[3] = x.TerminationGracePeriodSeconds != nil
			yyq1990[4] = x.ActiveDeadlineSeconds != nil
			yyq1990[5] = x.DNSPolicy != ""
			yyq1990[6] = len(x.NodeSelector) != 0
			yyq1990[7] = x.ServiceAccountName != ""
			yyq1990[8] = x.DeprecatedServiceAccount != ""
			yyq1990[9] = x.NodeName != ""
			yyq1990[10] = x.HostNetwork != false
			yyq1990[11] = x.HostPID != false
			yyq1990[12] = x.HostIPC != false
			yyq1990[13] = x.SecurityContext != nil
			yyq1990[14] = len(x.ImagePullSecrets) != 0
			yyq1990[15] = x.Hostname != ""
			yyq1990[16] = x.Subdomain != ""
			var yynn1990 int
			if yyr1990 || yy2arr1990 {
				r.EncodeArrayStart(17)
			} else {
				yynn1990 = 1
				for _, b := range yyq1990 {
					if b {
						yynn1990++
					}
				}
				r.EncodeMapStart(yynn1990)
				yynn1990 = 0
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[0] {
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1992 := z.EncBinary()
						_ = yym1992
						if false {
						} else {
							h.encSliceVolume(([]Volume)(x.Volumes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1993 := z.EncBinary()
						_ = yym1993
						if false {
						} else {
							h.encSliceVolume(([]Volume)(x.Volumes), e)
						}
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym1995 := z.EncBinary()
					_ = yym1995
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym1996 := z.EncBinary()
					_ = yym1996
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[2] {
					x.RestartPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("restartPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.RestartPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[3] {
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy1999 := *x.TerminationGracePeriodSeconds
						yym2000 := z.EncBinary()
						_ = yym2000
						if false {
						} else {
							r.EncodeInt(int64(yy1999))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy2001 := *x.TerminationGracePeriodSeconds
						yym2002 := z.EncBinary()
						_ = yym2002
						if false {
						} else {
							r.EncodeInt(int64(yy2001))
						}
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[4] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy2004 := *x.ActiveDeadlineSeconds
						yym2005 := z.EncBinary()
						_ = yym2005
						if false {
						} else {
							r.EncodeInt(int64(yy2004))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy2006 := *x.ActiveDeadlineSeconds
						yym2007 := z.EncBinary()
						_ = yym2007
						if false {
						} else {
							r.EncodeInt(int64(yy2006))
						}
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[5] {
					x.DNSPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("dnsPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.DNSPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[6] {
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym2010 := z.EncBinary()
						_ = yym2010
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym2011 := z.EncBinary()
						_ = yym2011
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[7] {
					yym2013 := z.EncBinary()
					_ = yym2013
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("serviceAccountName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2014 := z.EncBinary()
					_ = yym2014
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[8] {
					yym2016 := z.EncBinary()
					_ = yym2016
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DeprecatedServiceAccount))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("serviceAccount"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2017 := z.EncBinary()
					_ = yym2017
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DeprecatedServiceAccount))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[9] {
					yym2019 := z.EncBinary()
					_ = yym2019
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2020 := z.EncBinary()
					_ = yym2020
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[10] {
					yym2022 := z.EncBinary()
					_ = yym2022
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1990[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2023 := z.EncBinary()
					_ = yym2023
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[11] {
					yym2025 := z.EncBinary()
					_ = yym2025
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1990[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2026 := z.EncBinary()
					_ = yym2026
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[12] {
					yym2028 := z.EncBinary()
					_ = yym2028
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1990[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2029 := z.EncBinary()
					_ = yym2029
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[13] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[14] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2032 := z.EncBinary()
						_ = yym2032
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1990[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2033 := z.EncBinary()
						_ = yym2033
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[15] {
					yym2035 := z.EncBinary()
					_ = yym2035
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2036 := z.EncBinary()
					_ = yym2036
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1990[16] {
					yym2038 := z.EncBinary()
					_ = yym2038
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1990[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subdomain"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2039 := z.EncBinary()
					_ = yym2039
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				}
			}
			if yyr1990 || yy2arr1990 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2040 := z.DecBinary()
	_ = yym2040
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2041 := r.ContainerType()
		if yyct2041 == codecSelferValueTypeMap1234 {
			yyl2041 := r.ReadMapStart()
			if yyl2041 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2041, d)
			}
		} else if yyct2041 == codecSelferValueTypeArray1234 {
			yyl2041 := r.ReadArrayStart()
			if yyl2041 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2041, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2042Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2042Slc
	var yyhl2042 bool = l >= 0
	for yyj2042 := 0; ; yyj2042++ {
		if yyhl2042 {
			if yyj2042 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2042Slc = r.DecodeBytes(yys2042Slc, true, true)
		yys2042 := string(yys2042Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2042 {
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv2043 := &x.Volumes
				yym2044 := z.DecBinary()
				_ = yym2044
				if false {
				} else {
					h.decSliceVolume((*[]Volume)(yyv2043), d)
				}
			}
		case "containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv2045 := &x.Containers
				yym2046 := z.DecBinary()
				_ = yym2046
				if false {
				} else {
					h.decSliceContainer((*[]Container)(yyv2045), d)
				}
			}
		case "restartPolicy":
			if r.TryDecodeAsNil() {
				x.RestartPolicy = ""
			} else {
				x.RestartPolicy = RestartPolicy(r.DecodeString())
			}
		case "terminationGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.TerminationGracePeriodSeconds != nil {
					x.TerminationGracePeriodSeconds = nil
				}
			} else {
				if x.TerminationGracePeriodSeconds == nil {
					x.TerminationGracePeriodSeconds = new(int64)
				}
				yym2049 := z.DecBinary()
				_ = yym2049
				if false {
				} else {
					*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym2051 := z.DecBinary()
				_ = yym2051
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "dnsPolicy":
			if r.TryDecodeAsNil() {
				x.DNSPolicy = ""
			} else {
				x.DNSPolicy = DNSPolicy(r.DecodeString())
			}
		case "nodeSelector":
			if r.TryDecodeAsNil() {
				x.NodeSelector = nil
			} else {
				yyv2053 := &x.NodeSelector
				yym2054 := z.DecBinary()
				_ = yym2054
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2053, false, d)
				}
			}
		case "serviceAccountName":
			if r.TryDecodeAsNil() {
				x.ServiceAccountName = ""
			} else {
				x.ServiceAccountName = string(r.DecodeString())
			}
		case "serviceAccount":
			if r.TryDecodeAsNil() {
				x.DeprecatedServiceAccount = ""
			} else {
				x.DeprecatedServiceAccount = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				x.NodeName = ""
			} else {
				x.NodeName = string(r.DecodeString())
			}
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(PodSecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2062 := &x.ImagePullSecrets
				yym2063 := z.DecBinary()
				_ = yym2063
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2062), d)
				}
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		case "subdomain":
			if r.TryDecodeAsNil() {
				x.Subdomain = ""
			} else {
				x.Subdomain = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2042)
		} // end switch yys2042
	} // end for yyj2042
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2066 int
	var yyb2066 bool
	var yyhl2066 bool = l >= 0
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv2067 := &x.Volumes
		yym2068 := z.DecBinary()
		_ = yym2068
		if false {
		} else {
			h.decSliceVolume((*[]Volume)(yyv2067), d)
		}
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv2069 := &x.Containers
		yym2070 := z.DecBinary()
		_ = yym2070
		if false {
		} else {
			h.decSliceContainer((*[]Container)(yyv2069), d)
		}
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartPolicy = ""
	} else {
		x.RestartPolicy = RestartPolicy(r.DecodeString())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TerminationGracePeriodSeconds != nil {
			x.TerminationGracePeriodSeconds = nil
		}
	} else {
		if x.TerminationGracePeriodSeconds == nil {
			x.TerminationGracePeriodSeconds = new(int64)
		}
		yym2073 := z.DecBinary()
		_ = yym2073
		if false {
		} else {
			*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym2075 := z.DecBinary()
		_ = yym2075
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DNSPolicy = ""
	} else {
		x.DNSPolicy = DNSPolicy(r.DecodeString())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelector = nil
	} else {
		yyv2077 := &x.NodeSelector
		yym2078 := z.DecBinary()
		_ = yym2078
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2077, false, d)
		}
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountName = ""
	} else {
		x.ServiceAccountName = string(r.DecodeString())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeprecatedServiceAccount = ""
	} else {
		x.DeprecatedServiceAccount = string(r.DecodeString())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeName = ""
	} else {
		x.NodeName = string(r.DecodeString())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(PodSecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2086 := &x.ImagePullSecrets
		yym2087 := z.DecBinary()
		_ = yym2087
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2086), d)
		}
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	yyj2066++
	if yyhl2066 {
		yyb2066 = yyj2066 > l
	} else {
		yyb2066 = r.CheckBreak()
	}
	if yyb2066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subdomain = ""
	} else {
		x.Subdomain = string(r.DecodeString())
	}
	for {
		yyj2066++
		if yyhl2066 {
			yyb2066 = yyj2066 > l
		} else {
			yyb2066 = r.CheckBreak()
		}
		if yyb2066 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2066-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityContext) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2090 := z.EncBinary()
		_ = yym2090
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2091 := !z.EncBinary()
			yy2arr2091 := z.EncBasicHandle().StructToArray
			var yyq2091 [5]bool
			_, _, _ = yysep2091, yyq2091, yy2arr2091
			const yyr2091 bool = false
			yyq2091[0] = x.SELinuxOptions != nil
			yyq2091[1] = x.RunAsUser != nil
			yyq2091[2] = x.RunAsNonRoot != nil
			yyq2091[3] = len(x.SupplementalGroups) != 0
			yyq2091[4] = x.FSGroup != nil
			var yynn2091 int
			if yyr2091 || yy2arr2091 {
				r.EncodeArrayStart(5)
			} else {
				yynn2091 = 0
				for _, b := range yyq2091 {
					if b {
						yynn2091++
					}
				}
				r.EncodeMapStart(yynn2091)
				yynn2091 = 0
			}
			if yyr2091 || yy2arr2091 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2091[0] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2091[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2091 || yy2arr2091 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2091[1] {
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy2094 := *x.RunAsUser
						yym2095 := z.EncBinary()
						_ = yym2095
						if false {
						} else {
							r.EncodeInt(int64(yy2094))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2091[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy2096 := *x.RunAsUser
						yym2097 := z.EncBinary()
						_ = yym2097
						if false {
						} else {
							r.EncodeInt(int64(yy2096))
						}
					}
				}
			}
			if yyr2091 || yy2arr2091 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2091[2] {
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy2099 := *x.RunAsNonRoot
						yym2100 := z.EncBinary()
						_ = yym2100
						if false {
						} else {
							r.EncodeBool(bool(yy2099))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2091[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsNonRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy2101 := *x.RunAsNonRoot
						yym2102 := z.EncBinary()
						_ = yym2102
						if false {
						} else {
							r.EncodeBool(bool(yy2101))
						}
					}
				}
			}
			if yyr2091 || yy2arr2091 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2091[3] {
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym2104 := z.EncBinary()
						_ = yym2104
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2091[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym2105 := z.EncBinary()
						_ = yym2105
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				}
			}
			if yyr2091 || yy2arr2091 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2091[4] {
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy2107 := *x.FSGroup
						yym2108 := z.EncBinary()
						_ = yym2108
						if false {
						} else {
							r.EncodeInt(int64(yy2107))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2091[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy2109 := *x.FSGroup
						yym2110 := z.EncBinary()
						_ = yym2110
						if false {
						} else {
							r.EncodeInt(int64(yy2109))
						}
					}
				}
			}
			if yyr2091 || yy2arr2091 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityContext) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2111 := z.DecBinary()
	_ = yym2111
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2112 := r.ContainerType()
		if yyct2112 == codecSelferValueTypeMap1234 {
			yyl2112 := r.ReadMapStart()
			if yyl2112 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2112, d)
			}
		} else if yyct2112 == codecSelferValueTypeArray1234 {
			yyl2112 := r.ReadArrayStart()
			if yyl2112 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2112, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityContext) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2113Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2113Slc
	var yyhl2113 bool = l >= 0
	for yyj2113 := 0; ; yyj2113++ {
		if yyhl2113 {
			if yyj2113 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2113Slc = r.DecodeBytes(yys2113Slc, true, true)
		yys2113 := string(yys2113Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2113 {
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				if x.RunAsUser != nil {
					x.RunAsUser = nil
				}
			} else {
				if x.RunAsUser == nil {
					x.RunAsUser = new(int64)
				}
				yym2116 := z.DecBinary()
				_ = yym2116
				if false {
				} else {
					*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
				}
			}
		case "runAsNonRoot":
			if r.TryDecodeAsNil() {
				if x.RunAsNonRoot != nil {
					x.RunAsNonRoot = nil
				}
			} else {
				if x.RunAsNonRoot == nil {
					x.RunAsNonRoot = new(bool)
				}
				yym2118 := z.DecBinary()
				_ = yym2118
				if false {
				} else {
					*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
				}
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = nil
			} else {
				yyv2119 := &x.SupplementalGroups
				yym2120 := z.DecBinary()
				_ = yym2120
				if false {
				} else {
					z.F.DecSliceInt64X(yyv2119, false, d)
				}
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				if x.FSGroup != nil {
					x.FSGroup = nil
				}
			} else {
				if x.FSGroup == nil {
					x.FSGroup = new(int64)
				}
				yym2122 := z.DecBinary()
				_ = yym2122
				if false {
				} else {
					*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2113)
		} // end switch yys2113
	} // end for yyj2113
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityContext) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2123 int
	var yyb2123 bool
	var yyhl2123 bool = l >= 0
	yyj2123++
	if yyhl2123 {
		yyb2123 = yyj2123 > l
	} else {
		yyb2123 = r.CheckBreak()
	}
	if yyb2123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	yyj2123++
	if yyhl2123 {
		yyb2123 = yyj2123 > l
	} else {
		yyb2123 = r.CheckBreak()
	}
	if yyb2123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsUser != nil {
			x.RunAsUser = nil
		}
	} else {
		if x.RunAsUser == nil {
			x.RunAsUser = new(int64)
		}
		yym2126 := z.DecBinary()
		_ = yym2126
		if false {
		} else {
			*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
		}
	}
	yyj2123++
	if yyhl2123 {
		yyb2123 = yyj2123 > l
	} else {
		yyb2123 = r.CheckBreak()
	}
	if yyb2123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsNonRoot != nil {
			x.RunAsNonRoot = nil
		}
	} else {
		if x.RunAsNonRoot == nil {
			x.RunAsNonRoot = new(bool)
		}
		yym2128 := z.DecBinary()
		_ = yym2128
		if false {
		} else {
			*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
		}
	}
	yyj2123++
	if yyhl2123 {
		yyb2123 = yyj2123 > l
	} else {
		yyb2123 = r.CheckBreak()
	}
	if yyb2123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = nil
	} else {
		yyv2129 := &x.SupplementalGroups
		yym2130 := z.DecBinary()
		_ = yym2130
		if false {
		} else {
			z.F.DecSliceInt64X(yyv2129, false, d)
		}
	}
	yyj2123++
	if yyhl2123 {
		yyb2123 = yyj2123 > l
	} else {
		yyb2123 = r.CheckBreak()
	}
	if yyb2123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSGroup != nil {
			x.FSGroup = nil
		}
	} else {
		if x.FSGroup == nil {
			x.FSGroup = new(int64)
		}
		yym2132 := z.DecBinary()
		_ = yym2132
		if false {
		} else {
			*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2123++
		if yyhl2123 {
			yyb2123 = yyj2123 > l
		} else {
			yyb2123 = r.CheckBreak()
		}
		if yyb2123 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2123-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2133 := z.EncBinary()
		_ = yym2133
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2134 := !z.EncBinary()
			yy2arr2134 := z.EncBasicHandle().StructToArray
			var yyq2134 [8]bool
			_, _, _ = yysep2134, yyq2134, yy2arr2134
			const yyr2134 bool = false
			yyq2134[0] = x.Phase != ""
			yyq2134[1] = len(x.Conditions) != 0
			yyq2134[2] = x.Message != ""
			yyq2134[3] = x.Reason != ""
			yyq2134[4] = x.HostIP != ""
			yyq2134[5] = x.PodIP != ""
			yyq2134[6] = x.StartTime != nil
			yyq2134[7] = len(x.ContainerStatuses) != 0
			var yynn2134 int
			if yyr2134 || yy2arr2134 {
				r.EncodeArrayStart(8)
			} else {
				yynn2134 = 0
				for _, b := range yyq2134 {
					if b {
						yynn2134++
					}
				}
				r.EncodeMapStart(yynn2134)
				yynn2134 = 0
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2134[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2134[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2134[1] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2137 := z.EncBinary()
						_ = yym2137
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2134[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2138 := z.EncBinary()
						_ = yym2138
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2134[2] {
					yym2140 := z.EncBinary()
					_ = yym2140
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2134[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2141 := z.EncBinary()
					_ = yym2141
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2134[3] {
					yym2143 := z.EncBinary()
					_ = yym2143
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2134[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2144 := z.EncBinary()
					_ = yym2144
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2134[4] {
					yym2146 := z.EncBinary()
					_ = yym2146
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2134[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2147 := z.EncBinary()
					_ = yym2147
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2134[5] {
					yym2149 := z.EncBinary()
					_ = yym2149
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2134[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2150 := z.EncBinary()
					_ = yym2150
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				}
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2134[6] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym2152 := z.EncBinary()
						_ = yym2152
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym2152 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym2152 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2134[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym2153 := z.EncBinary()
						_ = yym2153
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym2153 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym2153 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2134[7] {
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym2155 := z.EncBinary()
						_ = yym2155
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2134[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerStatuses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym2156 := z.EncBinary()
						_ = yym2156
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				}
			}
			if yyr2134 || yy2arr2134 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2157 := z.DecBinary()
	_ = yym2157
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2158 := r.ContainerType()
		if yyct2158 == codecSelferValueTypeMap1234 {
			yyl2158 := r.ReadMapStart()
			if yyl2158 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2158, d)
			}
		} else if yyct2158 == codecSelferValueTypeArray1234 {
			yyl2158 := r.ReadArrayStart()
			if yyl2158 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2158, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2159Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2159Slc
	var yyhl2159 bool = l >= 0
	for yyj2159 := 0; ; yyj2159++ {
		if yyhl2159 {
			if yyj2159 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2159Slc = r.DecodeBytes(yys2159Slc, true, true)
		yys2159 := string(yys2159Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2159 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PodPhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2161 := &x.Conditions
				yym2162 := z.DecBinary()
				_ = yym2162
				if false {
				} else {
					h.decSlicePodCondition((*[]PodCondition)(yyv2161), d)
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		case "podIP":
			if r.TryDecodeAsNil() {
				x.PodIP = ""
			} else {
				x.PodIP = string(r.DecodeString())
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg2_unversioned.Time)
				}
				yym2168 := z.DecBinary()
				_ = yym2168
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym2168 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym2168 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "containerStatuses":
			if r.TryDecodeAsNil() {
				x.ContainerStatuses = nil
			} else {
				yyv2169 := &x.ContainerStatuses
				yym2170 := z.DecBinary()
				_ = yym2170
				if false {
				} else {
					h.decSliceContainerStatus((*[]ContainerStatus)(yyv2169), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2159)
		} // end switch yys2159
	} // end for yyj2159
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2171 int
	var yyb2171 bool
	var yyhl2171 bool = l >= 0
	yyj2171++
	if yyhl2171 {
		yyb2171 = yyj2171 > l
	} else {
		yyb2171 = r.CheckBreak()
	}
	if yyb2171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PodPhase(r.DecodeString())
	}
	yyj2171++
	if yyhl2171 {
		yyb2171 = yyj2171 > l
	} else {
		yyb2171 = r.CheckBreak()
	}
	if yyb2171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv2173 := &x.Conditions
		yym2174 := z.DecBinary()
		_ = yym2174
		if false {
		} else {
			h.decSlicePodCondition((*[]PodCondition)(yyv2173), d)
		}
	}
	yyj2171++
	if yyhl2171 {
		yyb2171 = yyj2171 > l
	} else {
		yyb2171 = r.CheckBreak()
	}
	if yyb2171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj2171++
	if yyhl2171 {
		yyb2171 = yyj2171 > l
	} else {
		yyb2171 = r.CheckBreak()
	}
	if yyb2171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj2171++
	if yyhl2171 {
		yyb2171 = yyj2171 > l
	} else {
		yyb2171 = r.CheckBreak()
	}
	if yyb2171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	yyj2171++
	if yyhl2171 {
		yyb2171 = yyj2171 > l
	} else {
		yyb2171 = r.CheckBreak()
	}
	if yyb2171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodIP = ""
	} else {
		x.PodIP = string(r.DecodeString())
	}
	yyj2171++
	if yyhl2171 {
		yyb2171 = yyj2171 > l
	} else {
		yyb2171 = r.CheckBreak()
	}
	if yyb2171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg2_unversioned.Time)
		}
		yym2180 := z.DecBinary()
		_ = yym2180
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym2180 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym2180 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj2171++
	if yyhl2171 {
		yyb2171 = yyj2171 > l
	} else {
		yyb2171 = r.CheckBreak()
	}
	if yyb2171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerStatuses = nil
	} else {
		yyv2181 := &x.ContainerStatuses
		yym2182 := z.DecBinary()
		_ = yym2182
		if false {
		} else {
			h.decSliceContainerStatus((*[]ContainerStatus)(yyv2181), d)
		}
	}
	for {
		yyj2171++
		if yyhl2171 {
			yyb2171 = yyj2171 > l
		} else {
			yyb2171 = r.CheckBreak()
		}
		if yyb2171 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2171-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatusResult) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2183 := z.EncBinary()
		_ = yym2183
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2184 := !z.EncBinary()
			yy2arr2184 := z.EncBasicHandle().StructToArray
			var yyq2184 [4]bool
			_, _, _ = yysep2184, yyq2184, yy2arr2184
			const yyr2184 bool = false
			yyq2184[0] = x.Kind != ""
			yyq2184[1] = x.APIVersion != ""
			yyq2184[2] = true
			yyq2184[3] = true
			var yynn2184 int
			if yyr2184 || yy2arr2184 {
				r.EncodeArrayStart(4)
			} else {
				yynn2184 = 0
				for _, b := range yyq2184 {
					if b {
						yynn2184++
					}
				}
				r.EncodeMapStart(yynn2184)
				yynn2184 = 0
			}
			if yyr2184 || yy2arr2184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2184[0] {
					yym2186 := z.EncBinary()
					_ = yym2186
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2184[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2187 := z.EncBinary()
					_ = yym2187
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2184 || yy2arr2184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2184[1] {
					yym2189 := z.EncBinary()
					_ = yym2189
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2184[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2190 := z.EncBinary()
					_ = yym2190
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2184 || yy2arr2184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2184[2] {
					yy2192 := &x.ObjectMeta
					yy2192.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2184[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2193 := &x.ObjectMeta
					yy2193.CodecEncodeSelf(e)
				}
			}
			if yyr2184 || yy2arr2184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2184[3] {
					yy2195 := &x.Status
					yy2195.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2184[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2196 := &x.Status
					yy2196.CodecEncodeSelf(e)
				}
			}
			if yyr2184 || yy2arr2184 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatusResult) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2197 := z.DecBinary()
	_ = yym2197
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2198 := r.ContainerType()
		if yyct2198 == codecSelferValueTypeMap1234 {
			yyl2198 := r.ReadMapStart()
			if yyl2198 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2198, d)
			}
		} else if yyct2198 == codecSelferValueTypeArray1234 {
			yyl2198 := r.ReadArrayStart()
			if yyl2198 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2198, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatusResult) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2199Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2199Slc
	var yyhl2199 bool = l >= 0
	for yyj2199 := 0; ; yyj2199++ {
		if yyhl2199 {
			if yyj2199 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2199Slc = r.DecodeBytes(yys2199Slc, true, true)
		yys2199 := string(yys2199Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2199 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2202 := &x.ObjectMeta
				yyv2202.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv2203 := &x.Status
				yyv2203.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2199)
		} // end switch yys2199
	} // end for yyj2199
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatusResult) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2204 int
	var yyb2204 bool
	var yyhl2204 bool = l >= 0
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2207 := &x.ObjectMeta
		yyv2207.CodecDecodeSelf(d)
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv2208 := &x.Status
		yyv2208.CodecDecodeSelf(d)
	}
	for {
		yyj2204++
		if yyhl2204 {
			yyb2204 = yyj2204 > l
		} else {
			yyb2204 = r.CheckBreak()
		}
		if yyb2204 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2204-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Pod) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2209 := z.EncBinary()
		_ = yym2209
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2210 := !z.EncBinary()
			yy2arr2210 := z.EncBasicHandle().StructToArray
			var yyq2210 [5]bool
			_, _, _ = yysep2210, yyq2210, yy2arr2210
			const yyr2210 bool = false
			yyq2210[0] = x.Kind != ""
			yyq2210[1] = x.APIVersion != ""
			yyq2210[2] = true
			yyq2210[3] = true
			yyq2210[4] = true
			var yynn2210 int
			if yyr2210 || yy2arr2210 {
				r.EncodeArrayStart(5)
			} else {
				yynn2210 = 0
				for _, b := range yyq2210 {
					if b {
						yynn2210++
					}
				}
				r.EncodeMapStart(yynn2210)
				yynn2210 = 0
			}
			if yyr2210 || yy2arr2210 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2210[0] {
					yym2212 := z.EncBinary()
					_ = yym2212
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2210[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2213 := z.EncBinary()
					_ = yym2213
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2210 || yy2arr2210 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2210[1] {
					yym2215 := z.EncBinary()
					_ = yym2215
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2210[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2216 := z.EncBinary()
					_ = yym2216
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2210 || yy2arr2210 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2210[2] {
					yy2218 := &x.ObjectMeta
					yy2218.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2210[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2219 := &x.ObjectMeta
					yy2219.CodecEncodeSelf(e)
				}
			}
			if yyr2210 || yy2arr2210 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2210[3] {
					yy2221 := &x.Spec
					yy2221.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2210[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2222 := &x.Spec
					yy2222.CodecEncodeSelf(e)
				}
			}
			if yyr2210 || yy2arr2210 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2210[4] {
					yy2224 := &x.Status
					yy2224.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2210[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2225 := &x.Status
					yy2225.CodecEncodeSelf(e)
				}
			}
			if yyr2210 || yy2arr2210 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Pod) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2226 := z.DecBinary()
	_ = yym2226
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2227 := r.ContainerType()
		if yyct2227 == codecSelferValueTypeMap1234 {
			yyl2227 := r.ReadMapStart()
			if yyl2227 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2227, d)
			}
		} else if yyct2227 == codecSelferValueTypeArray1234 {
			yyl2227 := r.ReadArrayStart()
			if yyl2227 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2227, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Pod) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2228Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2228Slc
	var yyhl2228 bool = l >= 0
	for yyj2228 := 0; ; yyj2228++ {
		if yyhl2228 {
			if yyj2228 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2228Slc = r.DecodeBytes(yys2228Slc, true, true)
		yys2228 := string(yys2228Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2228 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2231 := &x.ObjectMeta
				yyv2231.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv2232 := &x.Spec
				yyv2232.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv2233 := &x.Status
				yyv2233.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2228)
		} // end switch yys2228
	} // end for yyj2228
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Pod) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2234 int
	var yyb2234 bool
	var yyhl2234 bool = l >= 0
	yyj2234++
	if yyhl2234 {
		yyb2234 = yyj2234 > l
	} else {
		yyb2234 = r.CheckBreak()
	}
	if yyb2234 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2234++
	if yyhl2234 {
		yyb2234 = yyj2234 > l
	} else {
		yyb2234 = r.CheckBreak()
	}
	if yyb2234 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2234++
	if yyhl2234 {
		yyb2234 = yyj2234 > l
	} else {
		yyb2234 = r.CheckBreak()
	}
	if yyb2234 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2237 := &x.ObjectMeta
		yyv2237.CodecDecodeSelf(d)
	}
	yyj2234++
	if yyhl2234 {
		yyb2234 = yyj2234 > l
	} else {
		yyb2234 = r.CheckBreak()
	}
	if yyb2234 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv2238 := &x.Spec
		yyv2238.CodecDecodeSelf(d)
	}
	yyj2234++
	if yyhl2234 {
		yyb2234 = yyj2234 > l
	} else {
		yyb2234 = r.CheckBreak()
	}
	if yyb2234 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv2239 := &x.Status
		yyv2239.CodecDecodeSelf(d)
	}
	for {
		yyj2234++
		if yyhl2234 {
			yyb2234 = yyj2234 > l
		} else {
			yyb2234 = r.CheckBreak()
		}
		if yyb2234 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2234-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2240 := z.EncBinary()
		_ = yym2240
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2241 := !z.EncBinary()
			yy2arr2241 := z.EncBasicHandle().StructToArray
			var yyq2241 [4]bool
			_, _, _ = yysep2241, yyq2241, yy2arr2241
			const yyr2241 bool = false
			yyq2241[0] = x.Kind != ""
			yyq2241[1] = x.APIVersion != ""
			yyq2241[2] = true
			var yynn2241 int
			if yyr2241 || yy2arr2241 {
				r.EncodeArrayStart(4)
			} else {
				yynn2241 = 1
				for _, b := range yyq2241 {
					if b {
						yynn2241++
					}
				}
				r.EncodeMapStart(yynn2241)
				yynn2241 = 0
			}
			if yyr2241 || yy2arr2241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2241[0] {
					yym2243 := z.EncBinary()
					_ = yym2243
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2241[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2244 := z.EncBinary()
					_ = yym2244
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2241 || yy2arr2241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2241[1] {
					yym2246 := z.EncBinary()
					_ = yym2246
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2241[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2247 := z.EncBinary()
					_ = yym2247
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2241 || yy2arr2241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2241[2] {
					yy2249 := &x.ListMeta
					yym2250 := z.EncBinary()
					_ = yym2250
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2249) {
					} else {
						z.EncFallback(yy2249)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2241[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2251 := &x.ListMeta
					yym2252 := z.EncBinary()
					_ = yym2252
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2251) {
					} else {
						z.EncFallback(yy2251)
					}
				}
			}
			if yyr2241 || yy2arr2241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2254 := z.EncBinary()
					_ = yym2254
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2255 := z.EncBinary()
					_ = yym2255
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			}
			if yyr2241 || yy2arr2241 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2256 := z.DecBinary()
	_ = yym2256
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2257 := r.ContainerType()
		if yyct2257 == codecSelferValueTypeMap1234 {
			yyl2257 := r.ReadMapStart()
			if yyl2257 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2257, d)
			}
		} else if yyct2257 == codecSelferValueTypeArray1234 {
			yyl2257 := r.ReadArrayStart()
			if yyl2257 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2257, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2258Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2258Slc
	var yyhl2258 bool = l >= 0
	for yyj2258 := 0; ; yyj2258++ {
		if yyhl2258 {
			if yyj2258 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2258Slc = r.DecodeBytes(yys2258Slc, true, true)
		yys2258 := string(yys2258Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2258 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2261 := &x.ListMeta
				yym2262 := z.DecBinary()
				_ = yym2262
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2261) {
				} else {
					z.DecFallback(yyv2261, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2263 := &x.Items
				yym2264 := z.DecBinary()
				_ = yym2264
				if false {
				} else {
					h.decSlicePod((*[]Pod)(yyv2263), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2258)
		} // end switch yys2258
	} // end for yyj2258
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2265 int
	var yyb2265 bool
	var yyhl2265 bool = l >= 0
	yyj2265++
	if yyhl2265 {
		yyb2265 = yyj2265 > l
	} else {
		yyb2265 = r.CheckBreak()
	}
	if yyb2265 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2265++
	if yyhl2265 {
		yyb2265 = yyj2265 > l
	} else {
		yyb2265 = r.CheckBreak()
	}
	if yyb2265 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2265++
	if yyhl2265 {
		yyb2265 = yyj2265 > l
	} else {
		yyb2265 = r.CheckBreak()
	}
	if yyb2265 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2268 := &x.ListMeta
		yym2269 := z.DecBinary()
		_ = yym2269
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2268) {
		} else {
			z.DecFallback(yyv2268, false)
		}
	}
	yyj2265++
	if yyhl2265 {
		yyb2265 = yyj2265 > l
	} else {
		yyb2265 = r.CheckBreak()
	}
	if yyb2265 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2270 := &x.Items
		yym2271 := z.DecBinary()
		_ = yym2271
		if false {
		} else {
			h.decSlicePod((*[]Pod)(yyv2270), d)
		}
	}
	for {
		yyj2265++
		if yyhl2265 {
			yyb2265 = yyj2265 > l
		} else {
			yyb2265 = r.CheckBreak()
		}
		if yyb2265 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2265-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2272 := z.EncBinary()
		_ = yym2272
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2273 := !z.EncBinary()
			yy2arr2273 := z.EncBasicHandle().StructToArray
			var yyq2273 [2]bool
			_, _, _ = yysep2273, yyq2273, yy2arr2273
			const yyr2273 bool = false
			yyq2273[0] = true
			yyq2273[1] = true
			var yynn2273 int
			if yyr2273 || yy2arr2273 {
				r.EncodeArrayStart(2)
			} else {
				yynn2273 = 0
				for _, b := range yyq2273 {
					if b {
						yynn2273++
					}
				}
				r.EncodeMapStart(yynn2273)
				yynn2273 = 0
			}
			if yyr2273 || yy2arr2273 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2273[0] {
					yy2275 := &x.ObjectMeta
					yy2275.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2273[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2276 := &x.ObjectMeta
					yy2276.CodecEncodeSelf(e)
				}
			}
			if yyr2273 || yy2arr2273 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2273[1] {
					yy2278 := &x.Spec
					yy2278.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2273[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2279 := &x.Spec
					yy2279.CodecEncodeSelf(e)
				}
			}
			if yyr2273 || yy2arr2273 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2280 := z.DecBinary()
	_ = yym2280
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2281 := r.ContainerType()
		if yyct2281 == codecSelferValueTypeMap1234 {
			yyl2281 := r.ReadMapStart()
			if yyl2281 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2281, d)
			}
		} else if yyct2281 == codecSelferValueTypeArray1234 {
			yyl2281 := r.ReadArrayStart()
			if yyl2281 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2281, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2282Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2282Slc
	var yyhl2282 bool = l >= 0
	for yyj2282 := 0; ; yyj2282++ {
		if yyhl2282 {
			if yyj2282 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2282Slc = r.DecodeBytes(yys2282Slc, true, true)
		yys2282 := string(yys2282Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2282 {
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2283 := &x.ObjectMeta
				yyv2283.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv2284 := &x.Spec
				yyv2284.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2282)
		} // end switch yys2282
	} // end for yyj2282
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2285 int
	var yyb2285 bool
	var yyhl2285 bool = l >= 0
	yyj2285++
	if yyhl2285 {
		yyb2285 = yyj2285 > l
	} else {
		yyb2285 = r.CheckBreak()
	}
	if yyb2285 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2286 := &x.ObjectMeta
		yyv2286.CodecDecodeSelf(d)
	}
	yyj2285++
	if yyhl2285 {
		yyb2285 = yyj2285 > l
	} else {
		yyb2285 = r.CheckBreak()
	}
	if yyb2285 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv2287 := &x.Spec
		yyv2287.CodecDecodeSelf(d)
	}
	for {
		yyj2285++
		if yyhl2285 {
			yyb2285 = yyj2285 > l
		} else {
			yyb2285 = r.CheckBreak()
		}
		if yyb2285 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2285-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplate) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2288 := z.EncBinary()
		_ = yym2288
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2289 := !z.EncBinary()
			yy2arr2289 := z.EncBasicHandle().StructToArray
			var yyq2289 [4]bool
			_, _, _ = yysep2289, yyq2289, yy2arr2289
			const yyr2289 bool = false
			yyq2289[0] = x.Kind != ""
			yyq2289[1] = x.APIVersion != ""
			yyq2289[2] = true
			yyq2289[3] = true
			var yynn2289 int
			if yyr2289 || yy2arr2289 {
				r.EncodeArrayStart(4)
			} else {
				yynn2289 = 0
				for _, b := range yyq2289 {
					if b {
						yynn2289++
					}
				}
				r.EncodeMapStart(yynn2289)
				yynn2289 = 0
			}
			if yyr2289 || yy2arr2289 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2289[0] {
					yym2291 := z.EncBinary()
					_ = yym2291
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2289[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2292 := z.EncBinary()
					_ = yym2292
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2289 || yy2arr2289 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2289[1] {
					yym2294 := z.EncBinary()
					_ = yym2294
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2289[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2295 := z.EncBinary()
					_ = yym2295
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2289 || yy2arr2289 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2289[2] {
					yy2297 := &x.ObjectMeta
					yy2297.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2289[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2298 := &x.ObjectMeta
					yy2298.CodecEncodeSelf(e)
				}
			}
			if yyr2289 || yy2arr2289 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2289[3] {
					yy2300 := &x.Template
					yy2300.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2289[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2301 := &x.Template
					yy2301.CodecEncodeSelf(e)
				}
			}
			if yyr2289 || yy2arr2289 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplate) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2302 := z.DecBinary()
	_ = yym2302
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2303 := r.ContainerType()
		if yyct2303 == codecSelferValueTypeMap1234 {
			yyl2303 := r.ReadMapStart()
			if yyl2303 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2303, d)
			}
		} else if yyct2303 == codecSelferValueTypeArray1234 {
			yyl2303 := r.ReadArrayStart()
			if yyl2303 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2303, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplate) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2304Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2304Slc
	var yyhl2304 bool = l >= 0
	for yyj2304 := 0; ; yyj2304++ {
		if yyhl2304 {
			if yyj2304 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2304Slc = r.DecodeBytes(yys2304Slc, true, true)
		yys2304 := string(yys2304Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2304 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2307 := &x.ObjectMeta
				yyv2307.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = PodTemplateSpec{}
			} else {
				yyv2308 := &x.Template
				yyv2308.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2304)
		} // end switch yys2304
	} // end for yyj2304
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplate) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2309 int
	var yyb2309 bool
	var yyhl2309 bool = l >= 0
	yyj2309++
	if yyhl2309 {
		yyb2309 = yyj2309 > l
	} else {
		yyb2309 = r.CheckBreak()
	}
	if yyb2309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2309++
	if yyhl2309 {
		yyb2309 = yyj2309 > l
	} else {
		yyb2309 = r.CheckBreak()
	}
	if yyb2309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2309++
	if yyhl2309 {
		yyb2309 = yyj2309 > l
	} else {
		yyb2309 = r.CheckBreak()
	}
	if yyb2309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2312 := &x.ObjectMeta
		yyv2312.CodecDecodeSelf(d)
	}
	yyj2309++
	if yyhl2309 {
		yyb2309 = yyj2309 > l
	} else {
		yyb2309 = r.CheckBreak()
	}
	if yyb2309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = PodTemplateSpec{}
	} else {
		yyv2313 := &x.Template
		yyv2313.CodecDecodeSelf(d)
	}
	for {
		yyj2309++
		if yyhl2309 {
			yyb2309 = yyj2309 > l
		} else {
			yyb2309 = r.CheckBreak()
		}
		if yyb2309 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2309-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2314 := z.EncBinary()
		_ = yym2314
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2315 := !z.EncBinary()
			yy2arr2315 := z.EncBasicHandle().StructToArray
			var yyq2315 [4]bool
			_, _, _ = yysep2315, yyq2315, yy2arr2315
			const yyr2315 bool = false
			yyq2315[0] = x.Kind != ""
			yyq2315[1] = x.APIVersion != ""
			yyq2315[2] = true
			var yynn2315 int
			if yyr2315 || yy2arr2315 {
				r.EncodeArrayStart(4)
			} else {
				yynn2315 = 1
				for _, b := range yyq2315 {
					if b {
						yynn2315++
					}
				}
				r.EncodeMapStart(yynn2315)
				yynn2315 = 0
			}
			if yyr2315 || yy2arr2315 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2315[0] {
					yym2317 := z.EncBinary()
					_ = yym2317
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2315[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2318 := z.EncBinary()
					_ = yym2318
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2315 || yy2arr2315 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2315[1] {
					yym2320 := z.EncBinary()
					_ = yym2320
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2315[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2321 := z.EncBinary()
					_ = yym2321
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2315 || yy2arr2315 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2315[2] {
					yy2323 := &x.ListMeta
					yym2324 := z.EncBinary()
					_ = yym2324
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2323) {
					} else {
						z.EncFallback(yy2323)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2315[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2325 := &x.ListMeta
					yym2326 := z.EncBinary()
					_ = yym2326
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2325) {
					} else {
						z.EncFallback(yy2325)
					}
				}
			}
			if yyr2315 || yy2arr2315 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2328 := z.EncBinary()
					_ = yym2328
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2329 := z.EncBinary()
					_ = yym2329
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			}
			if yyr2315 || yy2arr2315 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2330 := z.DecBinary()
	_ = yym2330
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2331 := r.ContainerType()
		if yyct2331 == codecSelferValueTypeMap1234 {
			yyl2331 := r.ReadMapStart()
			if yyl2331 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2331, d)
			}
		} else if yyct2331 == codecSelferValueTypeArray1234 {
			yyl2331 := r.ReadArrayStart()
			if yyl2331 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2331, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2332Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2332Slc
	var yyhl2332 bool = l >= 0
	for yyj2332 := 0; ; yyj2332++ {
		if yyhl2332 {
			if yyj2332 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2332Slc = r.DecodeBytes(yys2332Slc, true, true)
		yys2332 := string(yys2332Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2332 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2335 := &x.ListMeta
				yym2336 := z.DecBinary()
				_ = yym2336
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2335) {
				} else {
					z.DecFallback(yyv2335, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2337 := &x.Items
				yym2338 := z.DecBinary()
				_ = yym2338
				if false {
				} else {
					h.decSlicePodTemplate((*[]PodTemplate)(yyv2337), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2332)
		} // end switch yys2332
	} // end for yyj2332
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2339 int
	var yyb2339 bool
	var yyhl2339 bool = l >= 0
	yyj2339++
	if yyhl2339 {
		yyb2339 = yyj2339 > l
	} else {
		yyb2339 = r.CheckBreak()
	}
	if yyb2339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2339++
	if yyhl2339 {
		yyb2339 = yyj2339 > l
	} else {
		yyb2339 = r.CheckBreak()
	}
	if yyb2339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2339++
	if yyhl2339 {
		yyb2339 = yyj2339 > l
	} else {
		yyb2339 = r.CheckBreak()
	}
	if yyb2339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2342 := &x.ListMeta
		yym2343 := z.DecBinary()
		_ = yym2343
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2342) {
		} else {
			z.DecFallback(yyv2342, false)
		}
	}
	yyj2339++
	if yyhl2339 {
		yyb2339 = yyj2339 > l
	} else {
		yyb2339 = r.CheckBreak()
	}
	if yyb2339 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2344 := &x.Items
		yym2345 := z.DecBinary()
		_ = yym2345
		if false {
		} else {
			h.decSlicePodTemplate((*[]PodTemplate)(yyv2344), d)
		}
	}
	for {
		yyj2339++
		if yyhl2339 {
			yyb2339 = yyj2339 > l
		} else {
			yyb2339 = r.CheckBreak()
		}
		if yyb2339 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2339-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2346 := z.EncBinary()
		_ = yym2346
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2347 := !z.EncBinary()
			yy2arr2347 := z.EncBasicHandle().StructToArray
			var yyq2347 [3]bool
			_, _, _ = yysep2347, yyq2347, yy2arr2347
			const yyr2347 bool = false
			yyq2347[0] = x.Replicas != nil
			yyq2347[1] = len(x.Selector) != 0
			yyq2347[2] = x.Template != nil
			var yynn2347 int
			if yyr2347 || yy2arr2347 {
				r.EncodeArrayStart(3)
			} else {
				yynn2347 = 0
				for _, b := range yyq2347 {
					if b {
						yynn2347++
					}
				}
				r.EncodeMapStart(yynn2347)
				yynn2347 = 0
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy2349 := *x.Replicas
						yym2350 := z.EncBinary()
						_ = yym2350
						if false {
						} else {
							r.EncodeInt(int64(yy2349))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy2351 := *x.Replicas
						yym2352 := z.EncBinary()
						_ = yym2352
						if false {
						} else {
							r.EncodeInt(int64(yy2351))
						}
					}
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym2354 := z.EncBinary()
						_ = yym2354
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym2355 := z.EncBinary()
						_ = yym2355
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2347[2] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2347[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2347 || yy2arr2347 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2357 := z.DecBinary()
	_ = yym2357
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2358 := r.ContainerType()
		if yyct2358 == codecSelferValueTypeMap1234 {
			yyl2358 := r.ReadMapStart()
			if yyl2358 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2358, d)
			}
		} else if yyct2358 == codecSelferValueTypeArray1234 {
			yyl2358 := r.ReadArrayStart()
			if yyl2358 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2358, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2359Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2359Slc
	var yyhl2359 bool = l >= 0
	for yyj2359 := 0; ; yyj2359++ {
		if yyhl2359 {
			if yyj2359 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2359Slc = r.DecodeBytes(yys2359Slc, true, true)
		yys2359 := string(yys2359Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2359 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym2361 := z.DecBinary()
				_ = yym2361
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv2362 := &x.Selector
				yym2363 := z.DecBinary()
				_ = yym2363
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2362, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2359)
		} // end switch yys2359
	} // end for yyj2359
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2365 int
	var yyb2365 bool
	var yyhl2365 bool = l >= 0
	yyj2365++
	if yyhl2365 {
		yyb2365 = yyj2365 > l
	} else {
		yyb2365 = r.CheckBreak()
	}
	if yyb2365 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym2367 := z.DecBinary()
		_ = yym2367
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj2365++
	if yyhl2365 {
		yyb2365 = yyj2365 > l
	} else {
		yyb2365 = r.CheckBreak()
	}
	if yyb2365 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv2368 := &x.Selector
		yym2369 := z.DecBinary()
		_ = yym2369
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2368, false, d)
		}
	}
	yyj2365++
	if yyhl2365 {
		yyb2365 = yyj2365 > l
	} else {
		yyb2365 = r.CheckBreak()
	}
	if yyb2365 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj2365++
		if yyhl2365 {
			yyb2365 = yyj2365 > l
		} else {
			yyb2365 = r.CheckBreak()
		}
		if yyb2365 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2365-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2371 := z.EncBinary()
		_ = yym2371
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2372 := !z.EncBinary()
			yy2arr2372 := z.EncBasicHandle().StructToArray
			var yyq2372 [4]bool
			_, _, _ = yysep2372, yyq2372, yy2arr2372
			const yyr2372 bool = false
			yyq2372[1] = x.FullyLabeledReplicas != 0
			yyq2372[2] = x.ReadyReplicas != 0
			yyq2372[3] = x.ObservedGeneration != 0
			var yynn2372 int
			if yyr2372 || yy2arr2372 {
				r.EncodeArrayStart(4)
			} else {
				yynn2372 = 1
				for _, b := range yyq2372 {
					if b {
						yynn2372++
					}
				}
				r.EncodeMapStart(yynn2372)
				yynn2372 = 0
			}
			if yyr2372 || yy2arr2372 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2374 := z.EncBinary()
				_ = yym2374
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2375 := z.EncBinary()
				_ = yym2375
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr2372 || yy2arr2372 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2372[1] {
					yym2377 := z.EncBinary()
					_ = yym2377
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2372[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2378 := z.EncBinary()
					_ = yym2378
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr2372 || yy2arr2372 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2372[2] {
					yym2380 := z.EncBinary()
					_ = yym2380
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2372[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2381 := z.EncBinary()
					_ = yym2381
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr2372 || yy2arr2372 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2372[3] {
					yym2383 := z.EncBinary()
					_ = yym2383
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2372[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2384 := z.EncBinary()
					_ = yym2384
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr2372 || yy2arr2372 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2385 := z.DecBinary()
	_ = yym2385
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2386 := r.ContainerType()
		if yyct2386 == codecSelferValueTypeMap1234 {
			yyl2386 := r.ReadMapStart()
			if yyl2386 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2386, d)
			}
		} else if yyct2386 == codecSelferValueTypeArray1234 {
			yyl2386 := r.ReadArrayStart()
			if yyl2386 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2386, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2387Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2387Slc
	var yyhl2387 bool = l >= 0
	for yyj2387 := 0; ; yyj2387++ {
		if yyhl2387 {
			if yyj2387 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2387Slc = r.DecodeBytes(yys2387Slc, true, true)
		yys2387 := string(yys2387Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2387 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				x.FullyLabeledReplicas = int32(r.DecodeInt(32))
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				x.ReadyReplicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2387)
		} // end switch yys2387
	} // end for yyj2387
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2392 int
	var yyb2392 bool
	var yyhl2392 bool = l >= 0
	yyj2392++
	if yyhl2392 {
		yyb2392 = yyj2392 > l
	} else {
		yyb2392 = r.CheckBreak()
	}
	if yyb2392 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj2392++
	if yyhl2392 {
		yyb2392 = yyj2392 > l
	} else {
		yyb2392 = r.CheckBreak()
	}
	if yyb2392 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		x.FullyLabeledReplicas = int32(r.DecodeInt(32))
	}
	yyj2392++
	if yyhl2392 {
		yyb2392 = yyj2392 > l
	} else {
		yyb2392 = r.CheckBreak()
	}
	if yyb2392 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		x.ReadyReplicas = int32(r.DecodeInt(32))
	}
	yyj2392++
	if yyhl2392 {
		yyb2392 = yyj2392 > l
	} else {
		yyb2392 = r.CheckBreak()
	}
	if yyb2392 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	for {
		yyj2392++
		if yyhl2392 {
			yyb2392 = yyj2392 > l
		} else {
			yyb2392 = r.CheckBreak()
		}
		if yyb2392 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2392-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationController) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2397 := z.EncBinary()
		_ = yym2397
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2398 := !z.EncBinary()
			yy2arr2398 := z.EncBasicHandle().StructToArray
			var yyq2398 [5]bool
			_, _, _ = yysep2398, yyq2398, yy2arr2398
			const yyr2398 bool = false
			yyq2398[0] = x.Kind != ""
			yyq2398[1] = x.APIVersion != ""
			yyq2398[2] = true
			yyq2398[3] = true
			yyq2398[4] = true
			var yynn2398 int
			if yyr2398 || yy2arr2398 {
				r.EncodeArrayStart(5)
			} else {
				yynn2398 = 0
				for _, b := range yyq2398 {
					if b {
						yynn2398++
					}
				}
				r.EncodeMapStart(yynn2398)
				yynn2398 = 0
			}
			if yyr2398 || yy2arr2398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2398[0] {
					yym2400 := z.EncBinary()
					_ = yym2400
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2398[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2401 := z.EncBinary()
					_ = yym2401
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2398 || yy2arr2398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2398[1] {
					yym2403 := z.EncBinary()
					_ = yym2403
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2398[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2404 := z.EncBinary()
					_ = yym2404
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2398 || yy2arr2398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2398[2] {
					yy2406 := &x.ObjectMeta
					yy2406.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2398[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2407 := &x.ObjectMeta
					yy2407.CodecEncodeSelf(e)
				}
			}
			if yyr2398 || yy2arr2398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2398[3] {
					yy2409 := &x.Spec
					yy2409.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2398[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2410 := &x.Spec
					yy2410.CodecEncodeSelf(e)
				}
			}
			if yyr2398 || yy2arr2398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2398[4] {
					yy2412 := &x.Status
					yy2412.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2398[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2413 := &x.Status
					yy2413.CodecEncodeSelf(e)
				}
			}
			if yyr2398 || yy2arr2398 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationController) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2414 := z.DecBinary()
	_ = yym2414
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2415 := r.ContainerType()
		if yyct2415 == codecSelferValueTypeMap1234 {
			yyl2415 := r.ReadMapStart()
			if yyl2415 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2415, d)
			}
		} else if yyct2415 == codecSelferValueTypeArray1234 {
			yyl2415 := r.ReadArrayStart()
			if yyl2415 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2415, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationController) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2416Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2416Slc
	var yyhl2416 bool = l >= 0
	for yyj2416 := 0; ; yyj2416++ {
		if yyhl2416 {
			if yyj2416 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2416Slc = r.DecodeBytes(yys2416Slc, true, true)
		yys2416 := string(yys2416Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2416 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2419 := &x.ObjectMeta
				yyv2419.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicationControllerSpec{}
			} else {
				yyv2420 := &x.Spec
				yyv2420.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicationControllerStatus{}
			} else {
				yyv2421 := &x.Status
				yyv2421.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2416)
		} // end switch yys2416
	} // end for yyj2416
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationController) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2422 int
	var yyb2422 bool
	var yyhl2422 bool = l >= 0
	yyj2422++
	if yyhl2422 {
		yyb2422 = yyj2422 > l
	} else {
		yyb2422 = r.CheckBreak()
	}
	if yyb2422 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2422++
	if yyhl2422 {
		yyb2422 = yyj2422 > l
	} else {
		yyb2422 = r.CheckBreak()
	}
	if yyb2422 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2422++
	if yyhl2422 {
		yyb2422 = yyj2422 > l
	} else {
		yyb2422 = r.CheckBreak()
	}
	if yyb2422 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2425 := &x.ObjectMeta
		yyv2425.CodecDecodeSelf(d)
	}
	yyj2422++
	if yyhl2422 {
		yyb2422 = yyj2422 > l
	} else {
		yyb2422 = r.CheckBreak()
	}
	if yyb2422 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicationControllerSpec{}
	} else {
		yyv2426 := &x.Spec
		yyv2426.CodecDecodeSelf(d)
	}
	yyj2422++
	if yyhl2422 {
		yyb2422 = yyj2422 > l
	} else {
		yyb2422 = r.CheckBreak()
	}
	if yyb2422 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicationControllerStatus{}
	} else {
		yyv2427 := &x.Status
		yyv2427.CodecDecodeSelf(d)
	}
	for {
		yyj2422++
		if yyhl2422 {
			yyb2422 = yyj2422 > l
		} else {
			yyb2422 = r.CheckBreak()
		}
		if yyb2422 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2422-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2428 := z.EncBinary()
		_ = yym2428
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2429 := !z.EncBinary()
			yy2arr2429 := z.EncBasicHandle().StructToArray
			var yyq2429 [4]bool
			_, _, _ = yysep2429, yyq2429, yy2arr2429
			const yyr2429 bool = false
			yyq2429[0] = x.Kind != ""
			yyq2429[1] = x.APIVersion != ""
			yyq2429[2] = true
			var yynn2429 int
			if yyr2429 || yy2arr2429 {
				r.EncodeArrayStart(4)
			} else {
				yynn2429 = 1
				for _, b := range yyq2429 {
					if b {
						yynn2429++
					}
				}
				r.EncodeMapStart(yynn2429)
				yynn2429 = 0
			}
			if yyr2429 || yy2arr2429 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2429[0] {
					yym2431 := z.EncBinary()
					_ = yym2431
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2429[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2432 := z.EncBinary()
					_ = yym2432
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2429 || yy2arr2429 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2429[1] {
					yym2434 := z.EncBinary()
					_ = yym2434
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2429[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2435 := z.EncBinary()
					_ = yym2435
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2429 || yy2arr2429 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2429[2] {
					yy2437 := &x.ListMeta
					yym2438 := z.EncBinary()
					_ = yym2438
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2437) {
					} else {
						z.EncFallback(yy2437)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2429[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2439 := &x.ListMeta
					yym2440 := z.EncBinary()
					_ = yym2440
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2439) {
					} else {
						z.EncFallback(yy2439)
					}
				}
			}
			if yyr2429 || yy2arr2429 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2442 := z.EncBinary()
					_ = yym2442
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2443 := z.EncBinary()
					_ = yym2443
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			}
			if yyr2429 || yy2arr2429 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2444 := z.DecBinary()
	_ = yym2444
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2445 := r.ContainerType()
		if yyct2445 == codecSelferValueTypeMap1234 {
			yyl2445 := r.ReadMapStart()
			if yyl2445 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2445, d)
			}
		} else if yyct2445 == codecSelferValueTypeArray1234 {
			yyl2445 := r.ReadArrayStart()
			if yyl2445 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2445, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2446Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2446Slc
	var yyhl2446 bool = l >= 0
	for yyj2446 := 0; ; yyj2446++ {
		if yyhl2446 {
			if yyj2446 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2446Slc = r.DecodeBytes(yys2446Slc, true, true)
		yys2446 := string(yys2446Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2446 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2449 := &x.ListMeta
				yym2450 := z.DecBinary()
				_ = yym2450
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2449) {
				} else {
					z.DecFallback(yyv2449, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2451 := &x.Items
				yym2452 := z.DecBinary()
				_ = yym2452
				if false {
				} else {
					h.decSliceReplicationController((*[]ReplicationController)(yyv2451), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2446)
		} // end switch yys2446
	} // end for yyj2446
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2453 int
	var yyb2453 bool
	var yyhl2453 bool = l >= 0
	yyj2453++
	if yyhl2453 {
		yyb2453 = yyj2453 > l
	} else {
		yyb2453 = r.CheckBreak()
	}
	if yyb2453 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2453++
	if yyhl2453 {
		yyb2453 = yyj2453 > l
	} else {
		yyb2453 = r.CheckBreak()
	}
	if yyb2453 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2453++
	if yyhl2453 {
		yyb2453 = yyj2453 > l
	} else {
		yyb2453 = r.CheckBreak()
	}
	if yyb2453 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2456 := &x.ListMeta
		yym2457 := z.DecBinary()
		_ = yym2457
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2456) {
		} else {
			z.DecFallback(yyv2456, false)
		}
	}
	yyj2453++
	if yyhl2453 {
		yyb2453 = yyj2453 > l
	} else {
		yyb2453 = r.CheckBreak()
	}
	if yyb2453 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2458 := &x.Items
		yym2459 := z.DecBinary()
		_ = yym2459
		if false {
		} else {
			h.decSliceReplicationController((*[]ReplicationController)(yyv2458), d)
		}
	}
	for {
		yyj2453++
		if yyhl2453 {
			yyb2453 = yyj2453 > l
		} else {
			yyb2453 = r.CheckBreak()
		}
		if yyb2453 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2453-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ServiceAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2460 := z.EncBinary()
	_ = yym2460
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2461 := z.DecBinary()
	_ = yym2461
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ServiceType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2462 := z.EncBinary()
	_ = yym2462
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2463 := z.DecBinary()
	_ = yym2463
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ServiceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2464 := z.EncBinary()
		_ = yym2464
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2465 := !z.EncBinary()
			yy2arr2465 := z.EncBasicHandle().StructToArray
			var yyq2465 [1]bool
			_, _, _ = yysep2465, yyq2465, yy2arr2465
			const yyr2465 bool = false
			yyq2465[0] = true
			var yynn2465 int
			if yyr2465 || yy2arr2465 {
				r.EncodeArrayStart(1)
			} else {
				yynn2465 = 0
				for _, b := range yyq2465 {
					if b {
						yynn2465++
					}
				}
				r.EncodeMapStart(yynn2465)
				yynn2465 = 0
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2465[0] {
					yy2467 := &x.LoadBalancer
					yy2467.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2465[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2468 := &x.LoadBalancer
					yy2468.CodecEncodeSelf(e)
				}
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2469 := z.DecBinary()
	_ = yym2469
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2470 := r.ContainerType()
		if yyct2470 == codecSelferValueTypeMap1234 {
			yyl2470 := r.ReadMapStart()
			if yyl2470 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2470, d)
			}
		} else if yyct2470 == codecSelferValueTypeArray1234 {
			yyl2470 := r.ReadArrayStart()
			if yyl2470 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2470, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2471Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2471Slc
	var yyhl2471 bool = l >= 0
	for yyj2471 := 0; ; yyj2471++ {
		if yyhl2471 {
			if yyj2471 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2471Slc = r.DecodeBytes(yys2471Slc, true, true)
		yys2471 := string(yys2471Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2471 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = LoadBalancerStatus{}
			} else {
				yyv2472 := &x.LoadBalancer
				yyv2472.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2471)
		} // end switch yys2471
	} // end for yyj2471
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2473 int
	var yyb2473 bool
	var yyhl2473 bool = l >= 0
	yyj2473++
	if yyhl2473 {
		yyb2473 = yyj2473 > l
	} else {
		yyb2473 = r.CheckBreak()
	}
	if yyb2473 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = LoadBalancerStatus{}
	} else {
		yyv2474 := &x.LoadBalancer
		yyv2474.CodecDecodeSelf(d)
	}
	for {
		yyj2473++
		if yyhl2473 {
			yyb2473 = yyj2473 > l
		} else {
			yyb2473 = r.CheckBreak()
		}
		if yyb2473 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2473-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2475 := z.EncBinary()
		_ = yym2475
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2476 := !z.EncBinary()
			yy2arr2476 := z.EncBasicHandle().StructToArray
			var yyq2476 [1]bool
			_, _, _ = yysep2476, yyq2476, yy2arr2476
			const yyr2476 bool = false
			yyq2476[0] = len(x.Ingress) != 0
			var yynn2476 int
			if yyr2476 || yy2arr2476 {
				r.EncodeArrayStart(1)
			} else {
				yynn2476 = 0
				for _, b := range yyq2476 {
					if b {
						yynn2476++
					}
				}
				r.EncodeMapStart(yynn2476)
				yynn2476 = 0
			}
			if yyr2476 || yy2arr2476 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2476[0] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym2478 := z.EncBinary()
						_ = yym2478
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2476[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym2479 := z.EncBinary()
						_ = yym2479
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				}
			}
			if yyr2476 || yy2arr2476 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2480 := z.DecBinary()
	_ = yym2480
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2481 := r.ContainerType()
		if yyct2481 == codecSelferValueTypeMap1234 {
			yyl2481 := r.ReadMapStart()
			if yyl2481 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2481, d)
			}
		} else if yyct2481 == codecSelferValueTypeArray1234 {
			yyl2481 := r.ReadArrayStart()
			if yyl2481 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2481, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2482Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2482Slc
	var yyhl2482 bool = l >= 0
	for yyj2482 := 0; ; yyj2482++ {
		if yyhl2482 {
			if yyj2482 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2482Slc = r.DecodeBytes(yys2482Slc, true, true)
		yys2482 := string(yys2482Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2482 {
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv2483 := &x.Ingress
				yym2484 := z.DecBinary()
				_ = yym2484
				if false {
				} else {
					h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv2483), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2482)
		} // end switch yys2482
	} // end for yyj2482
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2485 int
	var yyb2485 bool
	var yyhl2485 bool = l >= 0
	yyj2485++
	if yyhl2485 {
		yyb2485 = yyj2485 > l
	} else {
		yyb2485 = r.CheckBreak()
	}
	if yyb2485 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv2486 := &x.Ingress
		yym2487 := z.DecBinary()
		_ = yym2487
		if false {
		} else {
			h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv2486), d)
		}
	}
	for {
		yyj2485++
		if yyhl2485 {
			yyb2485 = yyj2485 > l
		} else {
			yyb2485 = r.CheckBreak()
		}
		if yyb2485 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2485-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerIngress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2488 := z.EncBinary()
		_ = yym2488
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2489 := !z.EncBinary()
			yy2arr2489 := z.EncBasicHandle().StructToArray
			var yyq2489 [2]bool
			_, _, _ = yysep2489, yyq2489, yy2arr2489
			const yyr2489 bool = false
			yyq2489[0] = x.IP != ""
			yyq2489[1] = x.Hostname != ""
			var yynn2489 int
			if yyr2489 || yy2arr2489 {
				r.EncodeArrayStart(2)
			} else {
				yynn2489 = 0
				for _, b := range yyq2489 {
					if b {
						yynn2489++
					}
				}
				r.EncodeMapStart(yynn2489)
				yynn2489 = 0
			}
			if yyr2489 || yy2arr2489 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2489[0] {
					yym2491 := z.EncBinary()
					_ = yym2491
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2489[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ip"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2492 := z.EncBinary()
					_ = yym2492
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				}
			}
			if yyr2489 || yy2arr2489 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2489[1] {
					yym2494 := z.EncBinary()
					_ = yym2494
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2489[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2495 := z.EncBinary()
					_ = yym2495
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2489 || yy2arr2489 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerIngress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2496 := z.DecBinary()
	_ = yym2496
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2497 := r.ContainerType()
		if yyct2497 == codecSelferValueTypeMap1234 {
			yyl2497 := r.ReadMapStart()
			if yyl2497 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2497, d)
			}
		} else if yyct2497 == codecSelferValueTypeArray1234 {
			yyl2497 := r.ReadArrayStart()
			if yyl2497 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2497, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerIngress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2498Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2498Slc
	var yyhl2498 bool = l >= 0
	for yyj2498 := 0; ; yyj2498++ {
		if yyhl2498 {
			if yyj2498 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2498Slc = r.DecodeBytes(yys2498Slc, true, true)
		yys2498 := string(yys2498Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2498 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2498)
		} // end switch yys2498
	} // end for yyj2498
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerIngress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2501 int
	var yyb2501 bool
	var yyhl2501 bool = l >= 0
	yyj2501++
	if yyhl2501 {
		yyb2501 = yyj2501 > l
	} else {
		yyb2501 = r.CheckBreak()
	}
	if yyb2501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2501++
	if yyhl2501 {
		yyb2501 = yyj2501 > l
	} else {
		yyb2501 = r.CheckBreak()
	}
	if yyb2501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	for {
		yyj2501++
		if yyhl2501 {
			yyb2501 = yyj2501 > l
		} else {
			yyb2501 = r.CheckBreak()
		}
		if yyb2501 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2501-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2504 := z.EncBinary()
		_ = yym2504
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2505 := !z.EncBinary()
			yy2arr2505 := z.EncBasicHandle().StructToArray
			var yyq2505 [10]bool
			_, _, _ = yysep2505, yyq2505, yy2arr2505
			const yyr2505 bool = false
			yyq2505[1] = len(x.Selector) != 0
			yyq2505[2] = x.ClusterIP != ""
			yyq2505[3] = x.Type != ""
			yyq2505[4] = len(x.ExternalIPs) != 0
			yyq2505[5] = len(x.DeprecatedPublicIPs) != 0
			yyq2505[6] = x.SessionAffinity != ""
			yyq2505[7] = x.LoadBalancerIP != ""
			yyq2505[8] = len(x.LoadBalancerSourceRanges) != 0
			yyq2505[9] = x.ExternalName != ""
			var yynn2505 int
			if yyr2505 || yy2arr2505 {
				r.EncodeArrayStart(10)
			} else {
				yynn2505 = 1
				for _, b := range yyq2505 {
					if b {
						yynn2505++
					}
				}
				r.EncodeMapStart(yynn2505)
				yynn2505 = 0
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2507 := z.EncBinary()
					_ = yym2507
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2508 := z.EncBinary()
					_ = yym2508
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym2510 := z.EncBinary()
						_ = yym2510
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2505[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym2511 := z.EncBinary()
						_ = yym2511
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[2] {
					yym2513 := z.EncBinary()
					_ = yym2513
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2505[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2514 := z.EncBinary()
					_ = yym2514
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[3] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2505[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[4] {
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym2517 := z.EncBinary()
						_ = yym2517
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2505[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym2518 := z.EncBinary()
						_ = yym2518
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[5] {
					if x.DeprecatedPublicIPs == nil {
						r.EncodeNil()
					} else {
						yym2520 := z.EncBinary()
						_ = yym2520
						if false {
						} else {
							z.F.EncSliceStringV(x.DeprecatedPublicIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2505[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deprecatedPublicIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeprecatedPublicIPs == nil {
						r.EncodeNil()
					} else {
						yym2521 := z.EncBinary()
						_ = yym2521
						if false {
						} else {
							z.F.EncSliceStringV(x.DeprecatedPublicIPs, false, e)
						}
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[6] {
					x.SessionAffinity.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2505[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sessionAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.SessionAffinity.CodecEncodeSelf(e)
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[7] {
					yym2524 := z.EncBinary()
					_ = yym2524
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2505[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2525 := z.EncBinary()
					_ = yym2525
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[8] {
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym2527 := z.EncBinary()
						_ = yym2527
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2505[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerSourceRanges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym2528 := z.EncBinary()
						_ = yym2528
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[9] {
					yym2530 := z.EncBinary()
					_ = yym2530
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2505[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2531 := z.EncBinary()
					_ = yym2531
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2532 := z.DecBinary()
	_ = yym2532
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2533 := r.ContainerType()
		if yyct2533 == codecSelferValueTypeMap1234 {
			yyl2533 := r.ReadMapStart()
			if yyl2533 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2533, d)
			}
		} else if yyct2533 == codecSelferValueTypeArray1234 {
			yyl2533 := r.ReadArrayStart()
			if yyl2533 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2533, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2534Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2534Slc
	var yyhl2534 bool = l >= 0
	for yyj2534 := 0; ; yyj2534++ {
		if yyhl2534 {
			if yyj2534 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2534Slc = r.DecodeBytes(yys2534Slc, true, true)
		yys2534 := string(yys2534Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2534 {
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2535 := &x.Ports
				yym2536 := z.DecBinary()
				_ = yym2536
				if false {
				} else {
					h.decSliceServicePort((*[]ServicePort)(yyv2535), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv2537 := &x.Selector
				yym2538 := z.DecBinary()
				_ = yym2538
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2537, false, d)
				}
			}
		case "clusterIP":
			if r.TryDecodeAsNil() {
				x.ClusterIP = ""
			} else {
				x.ClusterIP = string(r.DecodeString())
			}
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ServiceType(r.DecodeString())
			}
		case "externalIPs":
			if r.TryDecodeAsNil() {
				x.ExternalIPs = nil
			} else {
				yyv2541 := &x.ExternalIPs
				yym2542 := z.DecBinary()
				_ = yym2542
				if false {
				} else {
					z.F.DecSliceStringX(yyv2541, false, d)
				}
			}
		case "deprecatedPublicIPs":
			if r.TryDecodeAsNil() {
				x.DeprecatedPublicIPs = nil
			} else {
				yyv2543 := &x.DeprecatedPublicIPs
				yym2544 := z.DecBinary()
				_ = yym2544
				if false {
				} else {
					z.F.DecSliceStringX(yyv2543, false, d)
				}
			}
		case "sessionAffinity":
			if r.TryDecodeAsNil() {
				x.SessionAffinity = ""
			} else {
				x.SessionAffinity = ServiceAffinity(r.DecodeString())
			}
		case "loadBalancerIP":
			if r.TryDecodeAsNil() {
				x.LoadBalancerIP = ""
			} else {
				x.LoadBalancerIP = string(r.DecodeString())
			}
		case "loadBalancerSourceRanges":
			if r.TryDecodeAsNil() {
				x.LoadBalancerSourceRanges = nil
			} else {
				yyv2547 := &x.LoadBalancerSourceRanges
				yym2548 := z.DecBinary()
				_ = yym2548
				if false {
				} else {
					z.F.DecSliceStringX(yyv2547, false, d)
				}
			}
		case "externalName":
			if r.TryDecodeAsNil() {
				x.ExternalName = ""
			} else {
				x.ExternalName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2534)
		} // end switch yys2534
	} // end for yyj2534
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2550 int
	var yyb2550 bool
	var yyhl2550 bool = l >= 0
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2551 := &x.Ports
		yym2552 := z.DecBinary()
		_ = yym2552
		if false {
		} else {
			h.decSliceServicePort((*[]ServicePort)(yyv2551), d)
		}
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv2553 := &x.Selector
		yym2554 := z.DecBinary()
		_ = yym2554
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2553, false, d)
		}
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterIP = ""
	} else {
		x.ClusterIP = string(r.DecodeString())
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ServiceType(r.DecodeString())
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalIPs = nil
	} else {
		yyv2557 := &x.ExternalIPs
		yym2558 := z.DecBinary()
		_ = yym2558
		if false {
		} else {
			z.F.DecSliceStringX(yyv2557, false, d)
		}
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeprecatedPublicIPs = nil
	} else {
		yyv2559 := &x.DeprecatedPublicIPs
		yym2560 := z.DecBinary()
		_ = yym2560
		if false {
		} else {
			z.F.DecSliceStringX(yyv2559, false, d)
		}
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SessionAffinity = ""
	} else {
		x.SessionAffinity = ServiceAffinity(r.DecodeString())
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerIP = ""
	} else {
		x.LoadBalancerIP = string(r.DecodeString())
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerSourceRanges = nil
	} else {
		yyv2563 := &x.LoadBalancerSourceRanges
		yym2564 := z.DecBinary()
		_ = yym2564
		if false {
		} else {
			z.F.DecSliceStringX(yyv2563, false, d)
		}
	}
	yyj2550++
	if yyhl2550 {
		yyb2550 = yyj2550 > l
	} else {
		yyb2550 = r.CheckBreak()
	}
	if yyb2550 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalName = ""
	} else {
		x.ExternalName = string(r.DecodeString())
	}
	for {
		yyj2550++
		if yyhl2550 {
			yyb2550 = yyj2550 > l
		} else {
			yyb2550 = r.CheckBreak()
		}
		if yyb2550 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2550-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServicePort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2566 := z.EncBinary()
		_ = yym2566
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2567 := !z.EncBinary()
			yy2arr2567 := z.EncBasicHandle().StructToArray
			var yyq2567 [5]bool
			_, _, _ = yysep2567, yyq2567, yy2arr2567
			const yyr2567 bool = false
			yyq2567[0] = x.Name != ""
			yyq2567[1] = x.Protocol != ""
			yyq2567[3] = true
			yyq2567[4] = x.NodePort != 0
			var yynn2567 int
			if yyr2567 || yy2arr2567 {
				r.EncodeArrayStart(5)
			} else {
				yynn2567 = 1
				for _, b := range yyq2567 {
					if b {
						yynn2567++
					}
				}
				r.EncodeMapStart(yynn2567)
				yynn2567 = 0
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2567[0] {
					yym2569 := z.EncBinary()
					_ = yym2569
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2567[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2570 := z.EncBinary()
					_ = yym2570
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2567[1] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2567[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2573 := z.EncBinary()
				_ = yym2573
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2574 := z.EncBinary()
				_ = yym2574
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2567[3] {
					yy2576 := &x.TargetPort
					yym2577 := z.EncBinary()
					_ = yym2577
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2576) {
					} else if !yym2577 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2576)
					} else {
						z.EncFallback(yy2576)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2567[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2578 := &x.TargetPort
					yym2579 := z.EncBinary()
					_ = yym2579
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2578) {
					} else if !yym2579 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2578)
					} else {
						z.EncFallback(yy2578)
					}
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2567[4] {
					yym2581 := z.EncBinary()
					_ = yym2581
					if false {
					} else {
						r.EncodeInt(int64(x.NodePort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2567[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodePort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2582 := z.EncBinary()
					_ = yym2582
					if false {
					} else {
						r.EncodeInt(int64(x.NodePort))
					}
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServicePort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2583 := z.DecBinary()
	_ = yym2583
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2584 := r.ContainerType()
		if yyct2584 == codecSelferValueTypeMap1234 {
			yyl2584 := r.ReadMapStart()
			if yyl2584 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2584, d)
			}
		} else if yyct2584 == codecSelferValueTypeArray1234 {
			yyl2584 := r.ReadArrayStart()
			if yyl2584 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2584, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServicePort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2585Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2585Slc
	var yyhl2585 bool = l >= 0
	for yyj2585 := 0; ; yyj2585++ {
		if yyhl2585 {
			if yyj2585 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2585Slc = r.DecodeBytes(yys2585Slc, true, true)
		yys2585 := string(yys2585Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2585 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "targetPort":
			if r.TryDecodeAsNil() {
				x.TargetPort = pkg4_intstr.IntOrString{}
			} else {
				yyv2589 := &x.TargetPort
				yym2590 := z.DecBinary()
				_ = yym2590
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2589) {
				} else if !yym2590 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2589)
				} else {
					z.DecFallback(yyv2589, false)
				}
			}
		case "nodePort":
			if r.TryDecodeAsNil() {
				x.NodePort = 0
			} else {
				x.NodePort = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2585)
		} // end switch yys2585
	} // end for yyj2585
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServicePort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2592 int
	var yyb2592 bool
	var yyhl2592 bool = l >= 0
	yyj2592++
	if yyhl2592 {
		yyb2592 = yyj2592 > l
	} else {
		yyb2592 = r.CheckBreak()
	}
	if yyb2592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2592++
	if yyhl2592 {
		yyb2592 = yyj2592 > l
	} else {
		yyb2592 = r.CheckBreak()
	}
	if yyb2592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj2592++
	if yyhl2592 {
		yyb2592 = yyj2592 > l
	} else {
		yyb2592 = r.CheckBreak()
	}
	if yyb2592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2592++
	if yyhl2592 {
		yyb2592 = yyj2592 > l
	} else {
		yyb2592 = r.CheckBreak()
	}
	if yyb2592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPort = pkg4_intstr.IntOrString{}
	} else {
		yyv2596 := &x.TargetPort
		yym2597 := z.DecBinary()
		_ = yym2597
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2596) {
		} else if !yym2597 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2596)
		} else {
			z.DecFallback(yyv2596, false)
		}
	}
	yyj2592++
	if yyhl2592 {
		yyb2592 = yyj2592 > l
	} else {
		yyb2592 = r.CheckBreak()
	}
	if yyb2592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodePort = 0
	} else {
		x.NodePort = int32(r.DecodeInt(32))
	}
	for {
		yyj2592++
		if yyhl2592 {
			yyb2592 = yyj2592 > l
		} else {
			yyb2592 = r.CheckBreak()
		}
		if yyb2592 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2592-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Service) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2599 := z.EncBinary()
		_ = yym2599
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2600 := !z.EncBinary()
			yy2arr2600 := z.EncBasicHandle().StructToArray
			var yyq2600 [5]bool
			_, _, _ = yysep2600, yyq2600, yy2arr2600
			const yyr2600 bool = false
			yyq2600[0] = x.Kind != ""
			yyq2600[1] = x.APIVersion != ""
			yyq2600[2] = true
			yyq2600[3] = true
			yyq2600[4] = true
			var yynn2600 int
			if yyr2600 || yy2arr2600 {
				r.EncodeArrayStart(5)
			} else {
				yynn2600 = 0
				for _, b := range yyq2600 {
					if b {
						yynn2600++
					}
				}
				r.EncodeMapStart(yynn2600)
				yynn2600 = 0
			}
			if yyr2600 || yy2arr2600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2600[0] {
					yym2602 := z.EncBinary()
					_ = yym2602
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2600[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2603 := z.EncBinary()
					_ = yym2603
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2600 || yy2arr2600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2600[1] {
					yym2605 := z.EncBinary()
					_ = yym2605
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2600[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2606 := z.EncBinary()
					_ = yym2606
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2600 || yy2arr2600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2600[2] {
					yy2608 := &x.ObjectMeta
					yy2608.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2600[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2609 := &x.ObjectMeta
					yy2609.CodecEncodeSelf(e)
				}
			}
			if yyr2600 || yy2arr2600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2600[3] {
					yy2611 := &x.Spec
					yy2611.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2600[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2612 := &x.Spec
					yy2612.CodecEncodeSelf(e)
				}
			}
			if yyr2600 || yy2arr2600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2600[4] {
					yy2614 := &x.Status
					yy2614.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2600[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2615 := &x.Status
					yy2615.CodecEncodeSelf(e)
				}
			}
			if yyr2600 || yy2arr2600 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Service) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2616 := z.DecBinary()
	_ = yym2616
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2617 := r.ContainerType()
		if yyct2617 == codecSelferValueTypeMap1234 {
			yyl2617 := r.ReadMapStart()
			if yyl2617 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2617, d)
			}
		} else if yyct2617 == codecSelferValueTypeArray1234 {
			yyl2617 := r.ReadArrayStart()
			if yyl2617 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2617, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Service) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2618Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2618Slc
	var yyhl2618 bool = l >= 0
	for yyj2618 := 0; ; yyj2618++ {
		if yyhl2618 {
			if yyj2618 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2618Slc = r.DecodeBytes(yys2618Slc, true, true)
		yys2618 := string(yys2618Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2618 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2621 := &x.ObjectMeta
				yyv2621.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ServiceSpec{}
			} else {
				yyv2622 := &x.Spec
				yyv2622.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ServiceStatus{}
			} else {
				yyv2623 := &x.Status
				yyv2623.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2618)
		} // end switch yys2618
	} // end for yyj2618
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Service) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2624 int
	var yyb2624 bool
	var yyhl2624 bool = l >= 0
	yyj2624++
	if yyhl2624 {
		yyb2624 = yyj2624 > l
	} else {
		yyb2624 = r.CheckBreak()
	}
	if yyb2624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2624++
	if yyhl2624 {
		yyb2624 = yyj2624 > l
	} else {
		yyb2624 = r.CheckBreak()
	}
	if yyb2624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2624++
	if yyhl2624 {
		yyb2624 = yyj2624 > l
	} else {
		yyb2624 = r.CheckBreak()
	}
	if yyb2624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2627 := &x.ObjectMeta
		yyv2627.CodecDecodeSelf(d)
	}
	yyj2624++
	if yyhl2624 {
		yyb2624 = yyj2624 > l
	} else {
		yyb2624 = r.CheckBreak()
	}
	if yyb2624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ServiceSpec{}
	} else {
		yyv2628 := &x.Spec
		yyv2628.CodecDecodeSelf(d)
	}
	yyj2624++
	if yyhl2624 {
		yyb2624 = yyj2624 > l
	} else {
		yyb2624 = r.CheckBreak()
	}
	if yyb2624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ServiceStatus{}
	} else {
		yyv2629 := &x.Status
		yyv2629.CodecDecodeSelf(d)
	}
	for {
		yyj2624++
		if yyhl2624 {
			yyb2624 = yyj2624 > l
		} else {
			yyb2624 = r.CheckBreak()
		}
		if yyb2624 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2624-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2630 := z.EncBinary()
		_ = yym2630
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2631 := !z.EncBinary()
			yy2arr2631 := z.EncBasicHandle().StructToArray
			var yyq2631 [4]bool
			_, _, _ = yysep2631, yyq2631, yy2arr2631
			const yyr2631 bool = false
			yyq2631[0] = x.Kind != ""
			yyq2631[1] = x.APIVersion != ""
			yyq2631[2] = true
			var yynn2631 int
			if yyr2631 || yy2arr2631 {
				r.EncodeArrayStart(4)
			} else {
				yynn2631 = 1
				for _, b := range yyq2631 {
					if b {
						yynn2631++
					}
				}
				r.EncodeMapStart(yynn2631)
				yynn2631 = 0
			}
			if yyr2631 || yy2arr2631 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2631[0] {
					yym2633 := z.EncBinary()
					_ = yym2633
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2631[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2634 := z.EncBinary()
					_ = yym2634
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2631 || yy2arr2631 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2631[1] {
					yym2636 := z.EncBinary()
					_ = yym2636
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2631[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2637 := z.EncBinary()
					_ = yym2637
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2631 || yy2arr2631 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2631[2] {
					yy2639 := &x.ListMeta
					yym2640 := z.EncBinary()
					_ = yym2640
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2639) {
					} else {
						z.EncFallback(yy2639)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2631[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2641 := &x.ListMeta
					yym2642 := z.EncBinary()
					_ = yym2642
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2641) {
					} else {
						z.EncFallback(yy2641)
					}
				}
			}
			if yyr2631 || yy2arr2631 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2644 := z.EncBinary()
					_ = yym2644
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2645 := z.EncBinary()
					_ = yym2645
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			}
			if yyr2631 || yy2arr2631 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2646 := z.DecBinary()
	_ = yym2646
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2647 := r.ContainerType()
		if yyct2647 == codecSelferValueTypeMap1234 {
			yyl2647 := r.ReadMapStart()
			if yyl2647 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2647, d)
			}
		} else if yyct2647 == codecSelferValueTypeArray1234 {
			yyl2647 := r.ReadArrayStart()
			if yyl2647 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2647, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2648Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2648Slc
	var yyhl2648 bool = l >= 0
	for yyj2648 := 0; ; yyj2648++ {
		if yyhl2648 {
			if yyj2648 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2648Slc = r.DecodeBytes(yys2648Slc, true, true)
		yys2648 := string(yys2648Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2648 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2651 := &x.ListMeta
				yym2652 := z.DecBinary()
				_ = yym2652
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2651) {
				} else {
					z.DecFallback(yyv2651, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2653 := &x.Items
				yym2654 := z.DecBinary()
				_ = yym2654
				if false {
				} else {
					h.decSliceService((*[]Service)(yyv2653), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2648)
		} // end switch yys2648
	} // end for yyj2648
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2655 int
	var yyb2655 bool
	var yyhl2655 bool = l >= 0
	yyj2655++
	if yyhl2655 {
		yyb2655 = yyj2655 > l
	} else {
		yyb2655 = r.CheckBreak()
	}
	if yyb2655 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2655++
	if yyhl2655 {
		yyb2655 = yyj2655 > l
	} else {
		yyb2655 = r.CheckBreak()
	}
	if yyb2655 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2655++
	if yyhl2655 {
		yyb2655 = yyj2655 > l
	} else {
		yyb2655 = r.CheckBreak()
	}
	if yyb2655 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2658 := &x.ListMeta
		yym2659 := z.DecBinary()
		_ = yym2659
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2658) {
		} else {
			z.DecFallback(yyv2658, false)
		}
	}
	yyj2655++
	if yyhl2655 {
		yyb2655 = yyj2655 > l
	} else {
		yyb2655 = r.CheckBreak()
	}
	if yyb2655 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2660 := &x.Items
		yym2661 := z.DecBinary()
		_ = yym2661
		if false {
		} else {
			h.decSliceService((*[]Service)(yyv2660), d)
		}
	}
	for {
		yyj2655++
		if yyhl2655 {
			yyb2655 = yyj2655 > l
		} else {
			yyb2655 = r.CheckBreak()
		}
		if yyb2655 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2655-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2662 := z.EncBinary()
		_ = yym2662
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2663 := !z.EncBinary()
			yy2arr2663 := z.EncBasicHandle().StructToArray
			var yyq2663 [5]bool
			_, _, _ = yysep2663, yyq2663, yy2arr2663
			const yyr2663 bool = false
			yyq2663[0] = x.Kind != ""
			yyq2663[1] = x.APIVersion != ""
			yyq2663[2] = true
			yyq2663[3] = len(x.Secrets) != 0
			yyq2663[4] = len(x.ImagePullSecrets) != 0
			var yynn2663 int
			if yyr2663 || yy2arr2663 {
				r.EncodeArrayStart(5)
			} else {
				yynn2663 = 0
				for _, b := range yyq2663 {
					if b {
						yynn2663++
					}
				}
				r.EncodeMapStart(yynn2663)
				yynn2663 = 0
			}
			if yyr2663 || yy2arr2663 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2663[0] {
					yym2665 := z.EncBinary()
					_ = yym2665
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2663[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2666 := z.EncBinary()
					_ = yym2666
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2663 || yy2arr2663 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2663[1] {
					yym2668 := z.EncBinary()
					_ = yym2668
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2663[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2669 := z.EncBinary()
					_ = yym2669
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2663 || yy2arr2663 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2663[2] {
					yy2671 := &x.ObjectMeta
					yy2671.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2663[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2672 := &x.ObjectMeta
					yy2672.CodecEncodeSelf(e)
				}
			}
			if yyr2663 || yy2arr2663 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2663[3] {
					if x.Secrets == nil {
						r.EncodeNil()
					} else {
						yym2674 := z.EncBinary()
						_ = yym2674
						if false {
						} else {
							h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2663[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secrets == nil {
						r.EncodeNil()
					} else {
						yym2675 := z.EncBinary()
						_ = yym2675
						if false {
						} else {
							h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
						}
					}
				}
			}
			if yyr2663 || yy2arr2663 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2663[4] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2677 := z.EncBinary()
						_ = yym2677
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2663[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2678 := z.EncBinary()
						_ = yym2678
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2663 || yy2arr2663 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2679 := z.DecBinary()
	_ = yym2679
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2680 := r.ContainerType()
		if yyct2680 == codecSelferValueTypeMap1234 {
			yyl2680 := r.ReadMapStart()
			if yyl2680 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2680, d)
			}
		} else if yyct2680 == codecSelferValueTypeArray1234 {
			yyl2680 := r.ReadArrayStart()
			if yyl2680 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2680, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2681Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2681Slc
	var yyhl2681 bool = l >= 0
	for yyj2681 := 0; ; yyj2681++ {
		if yyhl2681 {
			if yyj2681 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2681Slc = r.DecodeBytes(yys2681Slc, true, true)
		yys2681 := string(yys2681Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2681 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2684 := &x.ObjectMeta
				yyv2684.CodecDecodeSelf(d)
			}
		case "secrets":
			if r.TryDecodeAsNil() {
				x.Secrets = nil
			} else {
				yyv2685 := &x.Secrets
				yym2686 := z.DecBinary()
				_ = yym2686
				if false {
				} else {
					h.decSliceObjectReference((*[]ObjectReference)(yyv2685), d)
				}
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2687 := &x.ImagePullSecrets
				yym2688 := z.DecBinary()
				_ = yym2688
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2687), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2681)
		} // end switch yys2681
	} // end for yyj2681
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2689 int
	var yyb2689 bool
	var yyhl2689 bool = l >= 0
	yyj2689++
	if yyhl2689 {
		yyb2689 = yyj2689 > l
	} else {
		yyb2689 = r.CheckBreak()
	}
	if yyb2689 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2689++
	if yyhl2689 {
		yyb2689 = yyj2689 > l
	} else {
		yyb2689 = r.CheckBreak()
	}
	if yyb2689 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2689++
	if yyhl2689 {
		yyb2689 = yyj2689 > l
	} else {
		yyb2689 = r.CheckBreak()
	}
	if yyb2689 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2692 := &x.ObjectMeta
		yyv2692.CodecDecodeSelf(d)
	}
	yyj2689++
	if yyhl2689 {
		yyb2689 = yyj2689 > l
	} else {
		yyb2689 = r.CheckBreak()
	}
	if yyb2689 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Secrets = nil
	} else {
		yyv2693 := &x.Secrets
		yym2694 := z.DecBinary()
		_ = yym2694
		if false {
		} else {
			h.decSliceObjectReference((*[]ObjectReference)(yyv2693), d)
		}
	}
	yyj2689++
	if yyhl2689 {
		yyb2689 = yyj2689 > l
	} else {
		yyb2689 = r.CheckBreak()
	}
	if yyb2689 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2695 := &x.ImagePullSecrets
		yym2696 := z.DecBinary()
		_ = yym2696
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2695), d)
		}
	}
	for {
		yyj2689++
		if yyhl2689 {
			yyb2689 = yyj2689 > l
		} else {
			yyb2689 = r.CheckBreak()
		}
		if yyb2689 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2689-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccountList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2697 := z.EncBinary()
		_ = yym2697
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2698 := !z.EncBinary()
			yy2arr2698 := z.EncBasicHandle().StructToArray
			var yyq2698 [4]bool
			_, _, _ = yysep2698, yyq2698, yy2arr2698
			const yyr2698 bool = false
			yyq2698[0] = x.Kind != ""
			yyq2698[1] = x.APIVersion != ""
			yyq2698[2] = true
			var yynn2698 int
			if yyr2698 || yy2arr2698 {
				r.EncodeArrayStart(4)
			} else {
				yynn2698 = 1
				for _, b := range yyq2698 {
					if b {
						yynn2698++
					}
				}
				r.EncodeMapStart(yynn2698)
				yynn2698 = 0
			}
			if yyr2698 || yy2arr2698 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2698[0] {
					yym2700 := z.EncBinary()
					_ = yym2700
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2698[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2701 := z.EncBinary()
					_ = yym2701
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2698 || yy2arr2698 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2698[1] {
					yym2703 := z.EncBinary()
					_ = yym2703
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2698[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2704 := z.EncBinary()
					_ = yym2704
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2698 || yy2arr2698 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2698[2] {
					yy2706 := &x.ListMeta
					yym2707 := z.EncBinary()
					_ = yym2707
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2706) {
					} else {
						z.EncFallback(yy2706)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2698[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2708 := &x.ListMeta
					yym2709 := z.EncBinary()
					_ = yym2709
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2708) {
					} else {
						z.EncFallback(yy2708)
					}
				}
			}
			if yyr2698 || yy2arr2698 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2711 := z.EncBinary()
					_ = yym2711
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2712 := z.EncBinary()
					_ = yym2712
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			}
			if yyr2698 || yy2arr2698 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccountList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2713 := z.DecBinary()
	_ = yym2713
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2714 := r.ContainerType()
		if yyct2714 == codecSelferValueTypeMap1234 {
			yyl2714 := r.ReadMapStart()
			if yyl2714 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2714, d)
			}
		} else if yyct2714 == codecSelferValueTypeArray1234 {
			yyl2714 := r.ReadArrayStart()
			if yyl2714 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2714, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccountList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2715Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2715Slc
	var yyhl2715 bool = l >= 0
	for yyj2715 := 0; ; yyj2715++ {
		if yyhl2715 {
			if yyj2715 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2715Slc = r.DecodeBytes(yys2715Slc, true, true)
		yys2715 := string(yys2715Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2715 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2718 := &x.ListMeta
				yym2719 := z.DecBinary()
				_ = yym2719
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2718) {
				} else {
					z.DecFallback(yyv2718, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2720 := &x.Items
				yym2721 := z.DecBinary()
				_ = yym2721
				if false {
				} else {
					h.decSliceServiceAccount((*[]ServiceAccount)(yyv2720), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2715)
		} // end switch yys2715
	} // end for yyj2715
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccountList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2722 int
	var yyb2722 bool
	var yyhl2722 bool = l >= 0
	yyj2722++
	if yyhl2722 {
		yyb2722 = yyj2722 > l
	} else {
		yyb2722 = r.CheckBreak()
	}
	if yyb2722 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2722++
	if yyhl2722 {
		yyb2722 = yyj2722 > l
	} else {
		yyb2722 = r.CheckBreak()
	}
	if yyb2722 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2722++
	if yyhl2722 {
		yyb2722 = yyj2722 > l
	} else {
		yyb2722 = r.CheckBreak()
	}
	if yyb2722 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2725 := &x.ListMeta
		yym2726 := z.DecBinary()
		_ = yym2726
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2725) {
		} else {
			z.DecFallback(yyv2725, false)
		}
	}
	yyj2722++
	if yyhl2722 {
		yyb2722 = yyj2722 > l
	} else {
		yyb2722 = r.CheckBreak()
	}
	if yyb2722 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2727 := &x.Items
		yym2728 := z.DecBinary()
		_ = yym2728
		if false {
		} else {
			h.decSliceServiceAccount((*[]ServiceAccount)(yyv2727), d)
		}
	}
	for {
		yyj2722++
		if yyhl2722 {
			yyb2722 = yyj2722 > l
		} else {
			yyb2722 = r.CheckBreak()
		}
		if yyb2722 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2722-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Endpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2729 := z.EncBinary()
		_ = yym2729
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2730 := !z.EncBinary()
			yy2arr2730 := z.EncBasicHandle().StructToArray
			var yyq2730 [4]bool
			_, _, _ = yysep2730, yyq2730, yy2arr2730
			const yyr2730 bool = false
			yyq2730[0] = x.Kind != ""
			yyq2730[1] = x.APIVersion != ""
			yyq2730[2] = true
			var yynn2730 int
			if yyr2730 || yy2arr2730 {
				r.EncodeArrayStart(4)
			} else {
				yynn2730 = 1
				for _, b := range yyq2730 {
					if b {
						yynn2730++
					}
				}
				r.EncodeMapStart(yynn2730)
				yynn2730 = 0
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2730[0] {
					yym2732 := z.EncBinary()
					_ = yym2732
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2730[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2733 := z.EncBinary()
					_ = yym2733
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2730[1] {
					yym2735 := z.EncBinary()
					_ = yym2735
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2730[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2736 := z.EncBinary()
					_ = yym2736
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2730[2] {
					yy2738 := &x.ObjectMeta
					yy2738.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2730[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2739 := &x.ObjectMeta
					yy2739.CodecEncodeSelf(e)
				}
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2741 := z.EncBinary()
					_ = yym2741
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("subsets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2742 := z.EncBinary()
					_ = yym2742
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Endpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2743 := z.DecBinary()
	_ = yym2743
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2744 := r.ContainerType()
		if yyct2744 == codecSelferValueTypeMap1234 {
			yyl2744 := r.ReadMapStart()
			if yyl2744 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2744, d)
			}
		} else if yyct2744 == codecSelferValueTypeArray1234 {
			yyl2744 := r.ReadArrayStart()
			if yyl2744 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2744, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Endpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2745Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2745Slc
	var yyhl2745 bool = l >= 0
	for yyj2745 := 0; ; yyj2745++ {
		if yyhl2745 {
			if yyj2745 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2745Slc = r.DecodeBytes(yys2745Slc, true, true)
		yys2745 := string(yys2745Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2745 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2748 := &x.ObjectMeta
				yyv2748.CodecDecodeSelf(d)
			}
		case "subsets":
			if r.TryDecodeAsNil() {
				x.Subsets = nil
			} else {
				yyv2749 := &x.Subsets
				yym2750 := z.DecBinary()
				_ = yym2750
				if false {
				} else {
					h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2749), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2745)
		} // end switch yys2745
	} // end for yyj2745
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Endpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2751 int
	var yyb2751 bool
	var yyhl2751 bool = l >= 0
	yyj2751++
	if yyhl2751 {
		yyb2751 = yyj2751 > l
	} else {
		yyb2751 = r.CheckBreak()
	}
	if yyb2751 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2751++
	if yyhl2751 {
		yyb2751 = yyj2751 > l
	} else {
		yyb2751 = r.CheckBreak()
	}
	if yyb2751 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2751++
	if yyhl2751 {
		yyb2751 = yyj2751 > l
	} else {
		yyb2751 = r.CheckBreak()
	}
	if yyb2751 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2754 := &x.ObjectMeta
		yyv2754.CodecDecodeSelf(d)
	}
	yyj2751++
	if yyhl2751 {
		yyb2751 = yyj2751 > l
	} else {
		yyb2751 = r.CheckBreak()
	}
	if yyb2751 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subsets = nil
	} else {
		yyv2755 := &x.Subsets
		yym2756 := z.DecBinary()
		_ = yym2756
		if false {
		} else {
			h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2755), d)
		}
	}
	for {
		yyj2751++
		if yyhl2751 {
			yyb2751 = yyj2751 > l
		} else {
			yyb2751 = r.CheckBreak()
		}
		if yyb2751 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2751-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointSubset) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2757 := z.EncBinary()
		_ = yym2757
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2758 := !z.EncBinary()
			yy2arr2758 := z.EncBasicHandle().StructToArray
			var yyq2758 [3]bool
			_, _, _ = yysep2758, yyq2758, yy2arr2758
			const yyr2758 bool = false
			yyq2758[0] = len(x.Addresses) != 0
			yyq2758[1] = len(x.NotReadyAddresses) != 0
			yyq2758[2] = len(x.Ports) != 0
			var yynn2758 int
			if yyr2758 || yy2arr2758 {
				r.EncodeArrayStart(3)
			} else {
				yynn2758 = 0
				for _, b := range yyq2758 {
					if b {
						yynn2758++
					}
				}
				r.EncodeMapStart(yynn2758)
				yynn2758 = 0
			}
			if yyr2758 || yy2arr2758 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2758[0] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2760 := z.EncBinary()
						_ = yym2760
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2758[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2761 := z.EncBinary()
						_ = yym2761
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr2758 || yy2arr2758 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2758[1] {
					if x.NotReadyAddresses == nil {
						r.EncodeNil()
					} else {
						yym2763 := z.EncBinary()
						_ = yym2763
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2758[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("notReadyAddresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NotReadyAddresses == nil {
						r.EncodeNil()
					} else {
						yym2764 := z.EncBinary()
						_ = yym2764
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
						}
					}
				}
			}
			if yyr2758 || yy2arr2758 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2758[2] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym2766 := z.EncBinary()
						_ = yym2766
						if false {
						} else {
							h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2758[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym2767 := z.EncBinary()
						_ = yym2767
						if false {
						} else {
							h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr2758 || yy2arr2758 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointSubset) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2768 := z.DecBinary()
	_ = yym2768
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2769 := r.ContainerType()
		if yyct2769 == codecSelferValueTypeMap1234 {
			yyl2769 := r.ReadMapStart()
			if yyl2769 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2769, d)
			}
		} else if yyct2769 == codecSelferValueTypeArray1234 {
			yyl2769 := r.ReadArrayStart()
			if yyl2769 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2769, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointSubset) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2770Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2770Slc
	var yyhl2770 bool = l >= 0
	for yyj2770 := 0; ; yyj2770++ {
		if yyhl2770 {
			if yyj2770 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2770Slc = r.DecodeBytes(yys2770Slc, true, true)
		yys2770 := string(yys2770Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2770 {
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv2771 := &x.Addresses
				yym2772 := z.DecBinary()
				_ = yym2772
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2771), d)
				}
			}
		case "notReadyAddresses":
			if r.TryDecodeAsNil() {
				x.NotReadyAddresses = nil
			} else {
				yyv2773 := &x.NotReadyAddresses
				yym2774 := z.DecBinary()
				_ = yym2774
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2773), d)
				}
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2775 := &x.Ports
				yym2776 := z.DecBinary()
				_ = yym2776
				if false {
				} else {
					h.decSliceEndpointPort((*[]EndpointPort)(yyv2775), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2770)
		} // end switch yys2770
	} // end for yyj2770
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointSubset) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2777 int
	var yyb2777 bool
	var yyhl2777 bool = l >= 0
	yyj2777++
	if yyhl2777 {
		yyb2777 = yyj2777 > l
	} else {
		yyb2777 = r.CheckBreak()
	}
	if yyb2777 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv2778 := &x.Addresses
		yym2779 := z.DecBinary()
		_ = yym2779
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2778), d)
		}
	}
	yyj2777++
	if yyhl2777 {
		yyb2777 = yyj2777 > l
	} else {
		yyb2777 = r.CheckBreak()
	}
	if yyb2777 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NotReadyAddresses = nil
	} else {
		yyv2780 := &x.NotReadyAddresses
		yym2781 := z.DecBinary()
		_ = yym2781
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2780), d)
		}
	}
	yyj2777++
	if yyhl2777 {
		yyb2777 = yyj2777 > l
	} else {
		yyb2777 = r.CheckBreak()
	}
	if yyb2777 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2782 := &x.Ports
		yym2783 := z.DecBinary()
		_ = yym2783
		if false {
		} else {
			h.decSliceEndpointPort((*[]EndpointPort)(yyv2782), d)
		}
	}
	for {
		yyj2777++
		if yyhl2777 {
			yyb2777 = yyj2777 > l
		} else {
			yyb2777 = r.CheckBreak()
		}
		if yyb2777 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2777-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2784 := z.EncBinary()
		_ = yym2784
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2785 := !z.EncBinary()
			yy2arr2785 := z.EncBasicHandle().StructToArray
			var yyq2785 [4]bool
			_, _, _ = yysep2785, yyq2785, yy2arr2785
			const yyr2785 bool = false
			yyq2785[1] = x.Hostname != ""
			yyq2785[2] = x.NodeName != nil
			yyq2785[3] = x.TargetRef != nil
			var yynn2785 int
			if yyr2785 || yy2arr2785 {
				r.EncodeArrayStart(4)
			} else {
				yynn2785 = 1
				for _, b := range yyq2785 {
					if b {
						yynn2785++
					}
				}
				r.EncodeMapStart(yynn2785)
				yynn2785 = 0
			}
			if yyr2785 || yy2arr2785 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2787 := z.EncBinary()
				_ = yym2787
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ip"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2788 := z.EncBinary()
				_ = yym2788
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			}
			if yyr2785 || yy2arr2785 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2785[1] {
					yym2790 := z.EncBinary()
					_ = yym2790
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2785[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2791 := z.EncBinary()
					_ = yym2791
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2785 || yy2arr2785 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2785[2] {
					if x.NodeName == nil {
						r.EncodeNil()
					} else {
						yy2793 := *x.NodeName
						yym2794 := z.EncBinary()
						_ = yym2794
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy2793))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2785[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeName == nil {
						r.EncodeNil()
					} else {
						yy2795 := *x.NodeName
						yym2796 := z.EncBinary()
						_ = yym2796
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy2795))
						}
					}
				}
			}
			if yyr2785 || yy2arr2785 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2785[3] {
					if x.TargetRef == nil {
						r.EncodeNil()
					} else {
						x.TargetRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2785[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TargetRef == nil {
						r.EncodeNil()
					} else {
						x.TargetRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2785 || yy2arr2785 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2798 := z.DecBinary()
	_ = yym2798
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2799 := r.ContainerType()
		if yyct2799 == codecSelferValueTypeMap1234 {
			yyl2799 := r.ReadMapStart()
			if yyl2799 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2799, d)
			}
		} else if yyct2799 == codecSelferValueTypeArray1234 {
			yyl2799 := r.ReadArrayStart()
			if yyl2799 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2799, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2800Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2800Slc
	var yyhl2800 bool = l >= 0
	for yyj2800 := 0; ; yyj2800++ {
		if yyhl2800 {
			if yyj2800 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2800Slc = r.DecodeBytes(yys2800Slc, true, true)
		yys2800 := string(yys2800Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2800 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				if x.NodeName != nil {
					x.NodeName = nil
				}
			} else {
				if x.NodeName == nil {
					x.NodeName = new(string)
				}
				yym2804 := z.DecBinary()
				_ = yym2804
				if false {
				} else {
					*((*string)(x.NodeName)) = r.DecodeString()
				}
			}
		case "targetRef":
			if r.TryDecodeAsNil() {
				if x.TargetRef != nil {
					x.TargetRef = nil
				}
			} else {
				if x.TargetRef == nil {
					x.TargetRef = new(ObjectReference)
				}
				x.TargetRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2800)
		} // end switch yys2800
	} // end for yyj2800
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2806 int
	var yyb2806 bool
	var yyhl2806 bool = l >= 0
	yyj2806++
	if yyhl2806 {
		yyb2806 = yyj2806 > l
	} else {
		yyb2806 = r.CheckBreak()
	}
	if yyb2806 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2806++
	if yyhl2806 {
		yyb2806 = yyj2806 > l
	} else {
		yyb2806 = r.CheckBreak()
	}
	if yyb2806 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	yyj2806++
	if yyhl2806 {
		yyb2806 = yyj2806 > l
	} else {
		yyb2806 = r.CheckBreak()
	}
	if yyb2806 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeName != nil {
			x.NodeName = nil
		}
	} else {
		if x.NodeName == nil {
			x.NodeName = new(string)
		}
		yym2810 := z.DecBinary()
		_ = yym2810
		if false {
		} else {
			*((*string)(x.NodeName)) = r.DecodeString()
		}
	}
	yyj2806++
	if yyhl2806 {
		yyb2806 = yyj2806 > l
	} else {
		yyb2806 = r.CheckBreak()
	}
	if yyb2806 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TargetRef != nil {
			x.TargetRef = nil
		}
	} else {
		if x.TargetRef == nil {
			x.TargetRef = new(ObjectReference)
		}
		x.TargetRef.CodecDecodeSelf(d)
	}
	for {
		yyj2806++
		if yyhl2806 {
			yyb2806 = yyj2806 > l
		} else {
			yyb2806 = r.CheckBreak()
		}
		if yyb2806 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2806-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2812 := z.EncBinary()
		_ = yym2812
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2813 := !z.EncBinary()
			yy2arr2813 := z.EncBasicHandle().StructToArray
			var yyq2813 [3]bool
			_, _, _ = yysep2813, yyq2813, yy2arr2813
			const yyr2813 bool = false
			yyq2813[0] = x.Name != ""
			yyq2813[2] = x.Protocol != ""
			var yynn2813 int
			if yyr2813 || yy2arr2813 {
				r.EncodeArrayStart(3)
			} else {
				yynn2813 = 1
				for _, b := range yyq2813 {
					if b {
						yynn2813++
					}
				}
				r.EncodeMapStart(yynn2813)
				yynn2813 = 0
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2813[0] {
					yym2815 := z.EncBinary()
					_ = yym2815
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2813[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2816 := z.EncBinary()
					_ = yym2816
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2818 := z.EncBinary()
				_ = yym2818
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2819 := z.EncBinary()
				_ = yym2819
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2813[2] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2813[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2821 := z.DecBinary()
	_ = yym2821
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2822 := r.ContainerType()
		if yyct2822 == codecSelferValueTypeMap1234 {
			yyl2822 := r.ReadMapStart()
			if yyl2822 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2822, d)
			}
		} else if yyct2822 == codecSelferValueTypeArray1234 {
			yyl2822 := r.ReadArrayStart()
			if yyl2822 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2822, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2823Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2823Slc
	var yyhl2823 bool = l >= 0
	for yyj2823 := 0; ; yyj2823++ {
		if yyhl2823 {
			if yyj2823 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2823Slc = r.DecodeBytes(yys2823Slc, true, true)
		yys2823 := string(yys2823Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2823 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2823)
		} // end switch yys2823
	} // end for yyj2823
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2827 int
	var yyb2827 bool
	var yyhl2827 bool = l >= 0
	yyj2827++
	if yyhl2827 {
		yyb2827 = yyj2827 > l
	} else {
		yyb2827 = r.CheckBreak()
	}
	if yyb2827 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2827++
	if yyhl2827 {
		yyb2827 = yyj2827 > l
	} else {
		yyb2827 = r.CheckBreak()
	}
	if yyb2827 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2827++
	if yyhl2827 {
		yyb2827 = yyj2827 > l
	} else {
		yyb2827 = r.CheckBreak()
	}
	if yyb2827 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	for {
		yyj2827++
		if yyhl2827 {
			yyb2827 = yyj2827 > l
		} else {
			yyb2827 = r.CheckBreak()
		}
		if yyb2827 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2827-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointsList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2831 := z.EncBinary()
		_ = yym2831
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2832 := !z.EncBinary()
			yy2arr2832 := z.EncBasicHandle().StructToArray
			var yyq2832 [4]bool
			_, _, _ = yysep2832, yyq2832, yy2arr2832
			const yyr2832 bool = false
			yyq2832[0] = x.Kind != ""
			yyq2832[1] = x.APIVersion != ""
			yyq2832[2] = true
			var yynn2832 int
			if yyr2832 || yy2arr2832 {
				r.EncodeArrayStart(4)
			} else {
				yynn2832 = 1
				for _, b := range yyq2832 {
					if b {
						yynn2832++
					}
				}
				r.EncodeMapStart(yynn2832)
				yynn2832 = 0
			}
			if yyr2832 || yy2arr2832 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2832[0] {
					yym2834 := z.EncBinary()
					_ = yym2834
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2832[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2835 := z.EncBinary()
					_ = yym2835
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2832 || yy2arr2832 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2832[1] {
					yym2837 := z.EncBinary()
					_ = yym2837
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2832[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2838 := z.EncBinary()
					_ = yym2838
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2832 || yy2arr2832 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2832[2] {
					yy2840 := &x.ListMeta
					yym2841 := z.EncBinary()
					_ = yym2841
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2840) {
					} else {
						z.EncFallback(yy2840)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2832[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2842 := &x.ListMeta
					yym2843 := z.EncBinary()
					_ = yym2843
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2842) {
					} else {
						z.EncFallback(yy2842)
					}
				}
			}
			if yyr2832 || yy2arr2832 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2845 := z.EncBinary()
					_ = yym2845
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2846 := z.EncBinary()
					_ = yym2846
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			}
			if yyr2832 || yy2arr2832 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointsList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2847 := z.DecBinary()
	_ = yym2847
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2848 := r.ContainerType()
		if yyct2848 == codecSelferValueTypeMap1234 {
			yyl2848 := r.ReadMapStart()
			if yyl2848 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2848, d)
			}
		} else if yyct2848 == codecSelferValueTypeArray1234 {
			yyl2848 := r.ReadArrayStart()
			if yyl2848 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2848, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointsList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2849Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2849Slc
	var yyhl2849 bool = l >= 0
	for yyj2849 := 0; ; yyj2849++ {
		if yyhl2849 {
			if yyj2849 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2849Slc = r.DecodeBytes(yys2849Slc, true, true)
		yys2849 := string(yys2849Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2849 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2852 := &x.ListMeta
				yym2853 := z.DecBinary()
				_ = yym2853
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2852) {
				} else {
					z.DecFallback(yyv2852, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2854 := &x.Items
				yym2855 := z.DecBinary()
				_ = yym2855
				if false {
				} else {
					h.decSliceEndpoints((*[]Endpoints)(yyv2854), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2849)
		} // end switch yys2849
	} // end for yyj2849
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointsList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2856 int
	var yyb2856 bool
	var yyhl2856 bool = l >= 0
	yyj2856++
	if yyhl2856 {
		yyb2856 = yyj2856 > l
	} else {
		yyb2856 = r.CheckBreak()
	}
	if yyb2856 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2856++
	if yyhl2856 {
		yyb2856 = yyj2856 > l
	} else {
		yyb2856 = r.CheckBreak()
	}
	if yyb2856 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2856++
	if yyhl2856 {
		yyb2856 = yyj2856 > l
	} else {
		yyb2856 = r.CheckBreak()
	}
	if yyb2856 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2859 := &x.ListMeta
		yym2860 := z.DecBinary()
		_ = yym2860
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2859) {
		} else {
			z.DecFallback(yyv2859, false)
		}
	}
	yyj2856++
	if yyhl2856 {
		yyb2856 = yyj2856 > l
	} else {
		yyb2856 = r.CheckBreak()
	}
	if yyb2856 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2861 := &x.Items
		yym2862 := z.DecBinary()
		_ = yym2862
		if false {
		} else {
			h.decSliceEndpoints((*[]Endpoints)(yyv2861), d)
		}
	}
	for {
		yyj2856++
		if yyhl2856 {
			yyb2856 = yyj2856 > l
		} else {
			yyb2856 = r.CheckBreak()
		}
		if yyb2856 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2856-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2863 := z.EncBinary()
		_ = yym2863
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2864 := !z.EncBinary()
			yy2arr2864 := z.EncBasicHandle().StructToArray
			var yyq2864 [4]bool
			_, _, _ = yysep2864, yyq2864, yy2arr2864
			const yyr2864 bool = false
			yyq2864[0] = x.PodCIDR != ""
			yyq2864[1] = x.ExternalID != ""
			yyq2864[2] = x.ProviderID != ""
			yyq2864[3] = x.Unschedulable != false
			var yynn2864 int
			if yyr2864 || yy2arr2864 {
				r.EncodeArrayStart(4)
			} else {
				yynn2864 = 0
				for _, b := range yyq2864 {
					if b {
						yynn2864++
					}
				}
				r.EncodeMapStart(yynn2864)
				yynn2864 = 0
			}
			if yyr2864 || yy2arr2864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2864[0] {
					yym2866 := z.EncBinary()
					_ = yym2866
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2864[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2867 := z.EncBinary()
					_ = yym2867
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				}
			}
			if yyr2864 || yy2arr2864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2864[1] {
					yym2869 := z.EncBinary()
					_ = yym2869
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2864[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2870 := z.EncBinary()
					_ = yym2870
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				}
			}
			if yyr2864 || yy2arr2864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2864[2] {
					yym2872 := z.EncBinary()
					_ = yym2872
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2864[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("providerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2873 := z.EncBinary()
					_ = yym2873
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				}
			}
			if yyr2864 || yy2arr2864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2864[3] {
					yym2875 := z.EncBinary()
					_ = yym2875
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2864[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unschedulable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2876 := z.EncBinary()
					_ = yym2876
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				}
			}
			if yyr2864 || yy2arr2864 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2877 := z.DecBinary()
	_ = yym2877
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2878 := r.ContainerType()
		if yyct2878 == codecSelferValueTypeMap1234 {
			yyl2878 := r.ReadMapStart()
			if yyl2878 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2878, d)
			}
		} else if yyct2878 == codecSelferValueTypeArray1234 {
			yyl2878 := r.ReadArrayStart()
			if yyl2878 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2878, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2879Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2879Slc
	var yyhl2879 bool = l >= 0
	for yyj2879 := 0; ; yyj2879++ {
		if yyhl2879 {
			if yyj2879 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2879Slc = r.DecodeBytes(yys2879Slc, true, true)
		yys2879 := string(yys2879Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2879 {
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "externalID":
			if r.TryDecodeAsNil() {
				x.ExternalID = ""
			} else {
				x.ExternalID = string(r.DecodeString())
			}
		case "providerID":
			if r.TryDecodeAsNil() {
				x.ProviderID = ""
			} else {
				x.ProviderID = string(r.DecodeString())
			}
		case "unschedulable":
			if r.TryDecodeAsNil() {
				x.Unschedulable = false
			} else {
				x.Unschedulable = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2879)
		} // end switch yys2879
	} // end for yyj2879
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2884 int
	var yyb2884 bool
	var yyhl2884 bool = l >= 0
	yyj2884++
	if yyhl2884 {
		yyb2884 = yyj2884 > l
	} else {
		yyb2884 = r.CheckBreak()
	}
	if yyb2884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj2884++
	if yyhl2884 {
		yyb2884 = yyj2884 > l
	} else {
		yyb2884 = r.CheckBreak()
	}
	if yyb2884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalID = ""
	} else {
		x.ExternalID = string(r.DecodeString())
	}
	yyj2884++
	if yyhl2884 {
		yyb2884 = yyj2884 > l
	} else {
		yyb2884 = r.CheckBreak()
	}
	if yyb2884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProviderID = ""
	} else {
		x.ProviderID = string(r.DecodeString())
	}
	yyj2884++
	if yyhl2884 {
		yyb2884 = yyj2884 > l
	} else {
		yyb2884 = r.CheckBreak()
	}
	if yyb2884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Unschedulable = false
	} else {
		x.Unschedulable = bool(r.DecodeBool())
	}
	for {
		yyj2884++
		if yyhl2884 {
			yyb2884 = yyj2884 > l
		} else {
			yyb2884 = r.CheckBreak()
		}
		if yyb2884 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2884-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonEndpoint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2889 := z.EncBinary()
		_ = yym2889
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2890 := !z.EncBinary()
			yy2arr2890 := z.EncBasicHandle().StructToArray
			var yyq2890 [1]bool
			_, _, _ = yysep2890, yyq2890, yy2arr2890
			const yyr2890 bool = false
			var yynn2890 int
			if yyr2890 || yy2arr2890 {
				r.EncodeArrayStart(1)
			} else {
				yynn2890 = 1
				for _, b := range yyq2890 {
					if b {
						yynn2890++
					}
				}
				r.EncodeMapStart(yynn2890)
				yynn2890 = 0
			}
			if yyr2890 || yy2arr2890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2892 := z.EncBinary()
				_ = yym2892
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2893 := z.EncBinary()
				_ = yym2893
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2890 || yy2arr2890 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonEndpoint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2894 := z.DecBinary()
	_ = yym2894
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2895 := r.ContainerType()
		if yyct2895 == codecSelferValueTypeMap1234 {
			yyl2895 := r.ReadMapStart()
			if yyl2895 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2895, d)
			}
		} else if yyct2895 == codecSelferValueTypeArray1234 {
			yyl2895 := r.ReadArrayStart()
			if yyl2895 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2895, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonEndpoint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2896Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2896Slc
	var yyhl2896 bool = l >= 0
	for yyj2896 := 0; ; yyj2896++ {
		if yyhl2896 {
			if yyj2896 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2896Slc = r.DecodeBytes(yys2896Slc, true, true)
		yys2896 := string(yys2896Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2896 {
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2896)
		} // end switch yys2896
	} // end for yyj2896
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonEndpoint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2898 int
	var yyb2898 bool
	var yyhl2898 bool = l >= 0
	yyj2898++
	if yyhl2898 {
		yyb2898 = yyj2898 > l
	} else {
		yyb2898 = r.CheckBreak()
	}
	if yyb2898 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	for {
		yyj2898++
		if yyhl2898 {
			yyb2898 = yyj2898 > l
		} else {
			yyb2898 = r.CheckBreak()
		}
		if yyb2898 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2898-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeDaemonEndpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2900 := z.EncBinary()
		_ = yym2900
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2901 := !z.EncBinary()
			yy2arr2901 := z.EncBasicHandle().StructToArray
			var yyq2901 [1]bool
			_, _, _ = yysep2901, yyq2901, yy2arr2901
			const yyr2901 bool = false
			yyq2901[0] = true
			var yynn2901 int
			if yyr2901 || yy2arr2901 {
				r.EncodeArrayStart(1)
			} else {
				yynn2901 = 0
				for _, b := range yyq2901 {
					if b {
						yynn2901++
					}
				}
				r.EncodeMapStart(yynn2901)
				yynn2901 = 0
			}
			if yyr2901 || yy2arr2901 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2901[0] {
					yy2903 := &x.KubeletEndpoint
					yy2903.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2901[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2904 := &x.KubeletEndpoint
					yy2904.CodecEncodeSelf(e)
				}
			}
			if yyr2901 || yy2arr2901 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeDaemonEndpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2905 := z.DecBinary()
	_ = yym2905
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2906 := r.ContainerType()
		if yyct2906 == codecSelferValueTypeMap1234 {
			yyl2906 := r.ReadMapStart()
			if yyl2906 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2906, d)
			}
		} else if yyct2906 == codecSelferValueTypeArray1234 {
			yyl2906 := r.ReadArrayStart()
			if yyl2906 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2906, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2907Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2907Slc
	var yyhl2907 bool = l >= 0
	for yyj2907 := 0; ; yyj2907++ {
		if yyhl2907 {
			if yyj2907 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2907Slc = r.DecodeBytes(yys2907Slc, true, true)
		yys2907 := string(yys2907Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2907 {
		case "kubeletEndpoint":
			if r.TryDecodeAsNil() {
				x.KubeletEndpoint = DaemonEndpoint{}
			} else {
				yyv2908 := &x.KubeletEndpoint
				yyv2908.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2907)
		} // end switch yys2907
	} // end for yyj2907
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2909 int
	var yyb2909 bool
	var yyhl2909 bool = l >= 0
	yyj2909++
	if yyhl2909 {
		yyb2909 = yyj2909 > l
	} else {
		yyb2909 = r.CheckBreak()
	}
	if yyb2909 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletEndpoint = DaemonEndpoint{}
	} else {
		yyv2910 := &x.KubeletEndpoint
		yyv2910.CodecDecodeSelf(d)
	}
	for {
		yyj2909++
		if yyhl2909 {
			yyb2909 = yyj2909 > l
		} else {
			yyb2909 = r.CheckBreak()
		}
		if yyb2909 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2909-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSystemInfo) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2911 := z.EncBinary()
		_ = yym2911
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2912 := !z.EncBinary()
			yy2arr2912 := z.EncBasicHandle().StructToArray
			var yyq2912 [10]bool
			_, _, _ = yysep2912, yyq2912, yy2arr2912
			const yyr2912 bool = false
			var yynn2912 int
			if yyr2912 || yy2arr2912 {
				r.EncodeArrayStart(10)
			} else {
				yynn2912 = 10
				for _, b := range yyq2912 {
					if b {
						yynn2912++
					}
				}
				r.EncodeMapStart(yynn2912)
				yynn2912 = 0
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2914 := z.EncBinary()
				_ = yym2914
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("machineID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2915 := z.EncBinary()
				_ = yym2915
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2917 := z.EncBinary()
				_ = yym2917
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemUUID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2918 := z.EncBinary()
				_ = yym2918
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2920 := z.EncBinary()
				_ = yym2920
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bootID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2921 := z.EncBinary()
				_ = yym2921
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2923 := z.EncBinary()
				_ = yym2923
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kernelVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2924 := z.EncBinary()
				_ = yym2924
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2926 := z.EncBinary()
				_ = yym2926
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("osImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2927 := z.EncBinary()
				_ = yym2927
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2929 := z.EncBinary()
				_ = yym2929
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntimeVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2930 := z.EncBinary()
				_ = yym2930
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2932 := z.EncBinary()
				_ = yym2932
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeletVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2933 := z.EncBinary()
				_ = yym2933
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2935 := z.EncBinary()
				_ = yym2935
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeProxyVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2936 := z.EncBinary()
				_ = yym2936
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2938 := z.EncBinary()
				_ = yym2938
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OperatingSystem))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operatingSystem"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2939 := z.EncBinary()
				_ = yym2939
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OperatingSystem))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2941 := z.EncBinary()
				_ = yym2941
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Architecture))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("architecture"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2942 := z.EncBinary()
				_ = yym2942
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Architecture))
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSystemInfo) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2943 := z.DecBinary()
	_ = yym2943
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2944 := r.ContainerType()
		if yyct2944 == codecSelferValueTypeMap1234 {
			yyl2944 := r.ReadMapStart()
			if yyl2944 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2944, d)
			}
		} else if yyct2944 == codecSelferValueTypeArray1234 {
			yyl2944 := r.ReadArrayStart()
			if yyl2944 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2944, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSystemInfo) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2945Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2945Slc
	var yyhl2945 bool = l >= 0
	for yyj2945 := 0; ; yyj2945++ {
		if yyhl2945 {
			if yyj2945 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2945Slc = r.DecodeBytes(yys2945Slc, true, true)
		yys2945 := string(yys2945Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2945 {
		case "machineID":
			if r.TryDecodeAsNil() {
				x.MachineID = ""
			} else {
				x.MachineID = string(r.DecodeString())
			}
		case "systemUUID":
			if r.TryDecodeAsNil() {
				x.SystemUUID = ""
			} else {
				x.SystemUUID = string(r.DecodeString())
			}
		case "bootID":
			if r.TryDecodeAsNil() {
				x.BootID = ""
			} else {
				x.BootID = string(r.DecodeString())
			}
		case "kernelVersion":
			if r.TryDecodeAsNil() {
				x.KernelVersion = ""
			} else {
				x.KernelVersion = string(r.DecodeString())
			}
		case "osImage":
			if r.TryDecodeAsNil() {
				x.OSImage = ""
			} else {
				x.OSImage = string(r.DecodeString())
			}
		case "containerRuntimeVersion":
			if r.TryDecodeAsNil() {
				x.ContainerRuntimeVersion = ""
			} else {
				x.ContainerRuntimeVersion = string(r.DecodeString())
			}
		case "kubeletVersion":
			if r.TryDecodeAsNil() {
				x.KubeletVersion = ""
			} else {
				x.KubeletVersion = string(r.DecodeString())
			}
		case "kubeProxyVersion":
			if r.TryDecodeAsNil() {
				x.KubeProxyVersion = ""
			} else {
				x.KubeProxyVersion = string(r.DecodeString())
			}
		case "operatingSystem":
			if r.TryDecodeAsNil() {
				x.OperatingSystem = ""
			} else {
				x.OperatingSystem = string(r.DecodeString())
			}
		case "architecture":
			if r.TryDecodeAsNil() {
				x.Architecture = ""
			} else {
				x.Architecture = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2945)
		} // end switch yys2945
	} // end for yyj2945
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSystemInfo) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2956 int
	var yyb2956 bool
	var yyhl2956 bool = l >= 0
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MachineID = ""
	} else {
		x.MachineID = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemUUID = ""
	} else {
		x.SystemUUID = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BootID = ""
	} else {
		x.BootID = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KernelVersion = ""
	} else {
		x.KernelVersion = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OSImage = ""
	} else {
		x.OSImage = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntimeVersion = ""
	} else {
		x.ContainerRuntimeVersion = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletVersion = ""
	} else {
		x.KubeletVersion = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeProxyVersion = ""
	} else {
		x.KubeProxyVersion = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OperatingSystem = ""
	} else {
		x.OperatingSystem = string(r.DecodeString())
	}
	yyj2956++
	if yyhl2956 {
		yyb2956 = yyj2956 > l
	} else {
		yyb2956 = r.CheckBreak()
	}
	if yyb2956 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Architecture = ""
	} else {
		x.Architecture = string(r.DecodeString())
	}
	for {
		yyj2956++
		if yyhl2956 {
			yyb2956 = yyj2956 > l
		} else {
			yyb2956 = r.CheckBreak()
		}
		if yyb2956 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2956-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2967 := z.EncBinary()
		_ = yym2967
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2968 := !z.EncBinary()
			yy2arr2968 := z.EncBasicHandle().StructToArray
			var yyq2968 [10]bool
			_, _, _ = yysep2968, yyq2968, yy2arr2968
			const yyr2968 bool = false
			yyq2968[0] = len(x.Capacity) != 0
			yyq2968[1] = len(x.Allocatable) != 0
			yyq2968[2] = x.Phase != ""
			yyq2968[3] = len(x.Conditions) != 0
			yyq2968[4] = len(x.Addresses) != 0
			yyq2968[5] = true
			yyq2968[6] = true
			yyq2968[7] = len(x.Images) != 0
			yyq2968[8] = len(x.VolumesInUse) != 0
			yyq2968[9] = len(x.VolumesAttached) != 0
			var yynn2968 int
			if yyr2968 || yy2arr2968 {
				r.EncodeArrayStart(10)
			} else {
				yynn2968 = 0
				for _, b := range yyq2968 {
					if b {
						yynn2968++
					}
				}
				r.EncodeMapStart(yynn2968)
				yynn2968 = 0
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[1] {
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allocatable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[2] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2968[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[3] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2973 := z.EncBinary()
						_ = yym2973
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2974 := z.EncBinary()
						_ = yym2974
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[4] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2976 := z.EncBinary()
						_ = yym2976
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2977 := z.EncBinary()
						_ = yym2977
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[5] {
					yy2979 := &x.DaemonEndpoints
					yy2979.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("daemonEndpoints"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2980 := &x.DaemonEndpoints
					yy2980.CodecEncodeSelf(e)
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[6] {
					yy2982 := &x.NodeInfo
					yy2982.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeInfo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2983 := &x.NodeInfo
					yy2983.CodecEncodeSelf(e)
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[7] {
					if x.Images == nil {
						r.EncodeNil()
					} else {
						yym2985 := z.EncBinary()
						_ = yym2985
						if false {
						} else {
							h.encSliceContainerImage(([]ContainerImage)(x.Images), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("images"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Images == nil {
						r.EncodeNil()
					} else {
						yym2986 := z.EncBinary()
						_ = yym2986
						if false {
						} else {
							h.encSliceContainerImage(([]ContainerImage)(x.Images), e)
						}
					}
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[8] {
					if x.VolumesInUse == nil {
						r.EncodeNil()
					} else {
						yym2988 := z.EncBinary()
						_ = yym2988
						if false {
						} else {
							h.encSliceUniqueVolumeName(([]UniqueVolumeName)(x.VolumesInUse), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumesInUse"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumesInUse == nil {
						r.EncodeNil()
					} else {
						yym2989 := z.EncBinary()
						_ = yym2989
						if false {
						} else {
							h.encSliceUniqueVolumeName(([]UniqueVolumeName)(x.VolumesInUse), e)
						}
					}
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2968[9] {
					if x.VolumesAttached == nil {
						r.EncodeNil()
					} else {
						yym2991 := z.EncBinary()
						_ = yym2991
						if false {
						} else {
							h.encSliceAttachedVolume(([]AttachedVolume)(x.VolumesAttached), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2968[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumesAttached"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumesAttached == nil {
						r.EncodeNil()
					} else {
						yym2992 := z.EncBinary()
						_ = yym2992
						if false {
						} else {
							h.encSliceAttachedVolume(([]AttachedVolume)(x.VolumesAttached), e)
						}
					}
				}
			}
			if yyr2968 || yy2arr2968 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2993 := z.DecBinary()
	_ = yym2993
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2994 := r.ContainerType()
		if yyct2994 == codecSelferValueTypeMap1234 {
			yyl2994 := r.ReadMapStart()
			if yyl2994 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2994, d)
			}
		} else if yyct2994 == codecSelferValueTypeArray1234 {
			yyl2994 := r.ReadArrayStart()
			if yyl2994 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2994, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2995Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2995Slc
	var yyhl2995 bool = l >= 0
	for yyj2995 := 0; ; yyj2995++ {
		if yyhl2995 {
			if yyj2995 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2995Slc = r.DecodeBytes(yys2995Slc, true, true)
		yys2995 := string(yys2995Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2995 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv2996 := &x.Capacity
				yyv2996.CodecDecodeSelf(d)
			}
		case "allocatable":
			if r.TryDecodeAsNil() {
				x.Allocatable = nil
			} else {
				yyv2997 := &x.Allocatable
				yyv2997.CodecDecodeSelf(d)
			}
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = NodePhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2999 := &x.Conditions
				yym3000 := z.DecBinary()
				_ = yym3000
				if false {
				} else {
					h.decSliceNodeCondition((*[]NodeCondition)(yyv2999), d)
				}
			}
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv3001 := &x.Addresses
				yym3002 := z.DecBinary()
				_ = yym3002
				if false {
				} else {
					h.decSliceNodeAddress((*[]NodeAddress)(yyv3001), d)
				}
			}
		case "daemonEndpoints":
			if r.TryDecodeAsNil() {
				x.DaemonEndpoints = NodeDaemonEndpoints{}
			} else {
				yyv3003 := &x.DaemonEndpoints
				yyv3003.CodecDecodeSelf(d)
			}
		case "nodeInfo":
			if r.TryDecodeAsNil() {
				x.NodeInfo = NodeSystemInfo{}
			} else {
				yyv3004 := &x.NodeInfo
				yyv3004.CodecDecodeSelf(d)
			}
		case "images":
			if r.TryDecodeAsNil() {
				x.Images = nil
			} else {
				yyv3005 := &x.Images
				yym3006 := z.DecBinary()
				_ = yym3006
				if false {
				} else {
					h.decSliceContainerImage((*[]ContainerImage)(yyv3005), d)
				}
			}
		case "volumesInUse":
			if r.TryDecodeAsNil() {
				x.VolumesInUse = nil
			} else {
				yyv3007 := &x.VolumesInUse
				yym3008 := z.DecBinary()
				_ = yym3008
				if false {
				} else {
					h.decSliceUniqueVolumeName((*[]UniqueVolumeName)(yyv3007), d)
				}
			}
		case "volumesAttached":
			if r.TryDecodeAsNil() {
				x.VolumesAttached = nil
			} else {
				yyv3009 := &x.VolumesAttached
				yym3010 := z.DecBinary()
				_ = yym3010
				if false {
				} else {
					h.decSliceAttachedVolume((*[]AttachedVolume)(yyv3009), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2995)
		} // end switch yys2995
	} // end for yyj2995
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3011 int
	var yyb3011 bool
	var yyhl3011 bool = l >= 0
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv3012 := &x.Capacity
		yyv3012.CodecDecodeSelf(d)
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allocatable = nil
	} else {
		yyv3013 := &x.Allocatable
		yyv3013.CodecDecodeSelf(d)
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = NodePhase(r.DecodeString())
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv3015 := &x.Conditions
		yym3016 := z.DecBinary()
		_ = yym3016
		if false {
		} else {
			h.decSliceNodeCondition((*[]NodeCondition)(yyv3015), d)
		}
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv3017 := &x.Addresses
		yym3018 := z.DecBinary()
		_ = yym3018
		if false {
		} else {
			h.decSliceNodeAddress((*[]NodeAddress)(yyv3017), d)
		}
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DaemonEndpoints = NodeDaemonEndpoints{}
	} else {
		yyv3019 := &x.DaemonEndpoints
		yyv3019.CodecDecodeSelf(d)
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeInfo = NodeSystemInfo{}
	} else {
		yyv3020 := &x.NodeInfo
		yyv3020.CodecDecodeSelf(d)
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Images = nil
	} else {
		yyv3021 := &x.Images
		yym3022 := z.DecBinary()
		_ = yym3022
		if false {
		} else {
			h.decSliceContainerImage((*[]ContainerImage)(yyv3021), d)
		}
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumesInUse = nil
	} else {
		yyv3023 := &x.VolumesInUse
		yym3024 := z.DecBinary()
		_ = yym3024
		if false {
		} else {
			h.decSliceUniqueVolumeName((*[]UniqueVolumeName)(yyv3023), d)
		}
	}
	yyj3011++
	if yyhl3011 {
		yyb3011 = yyj3011 > l
	} else {
		yyb3011 = r.CheckBreak()
	}
	if yyb3011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumesAttached = nil
	} else {
		yyv3025 := &x.VolumesAttached
		yym3026 := z.DecBinary()
		_ = yym3026
		if false {
		} else {
			h.decSliceAttachedVolume((*[]AttachedVolume)(yyv3025), d)
		}
	}
	for {
		yyj3011++
		if yyhl3011 {
			yyb3011 = yyj3011 > l
		} else {
			yyb3011 = r.CheckBreak()
		}
		if yyb3011 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3011-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x UniqueVolumeName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3027 := z.EncBinary()
	_ = yym3027
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *UniqueVolumeName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3028 := z.DecBinary()
	_ = yym3028
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AttachedVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3029 := z.EncBinary()
		_ = yym3029
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3030 := !z.EncBinary()
			yy2arr3030 := z.EncBasicHandle().StructToArray
			var yyq3030 [2]bool
			_, _, _ = yysep3030, yyq3030, yy2arr3030
			const yyr3030 bool = false
			var yynn3030 int
			if yyr3030 || yy2arr3030 {
				r.EncodeArrayStart(2)
			} else {
				yynn3030 = 2
				for _, b := range yyq3030 {
					if b {
						yynn3030++
					}
				}
				r.EncodeMapStart(yynn3030)
				yynn3030 = 0
			}
			if yyr3030 || yy2arr3030 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Name.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Name.CodecEncodeSelf(e)
			}
			if yyr3030 || yy2arr3030 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3033 := z.EncBinary()
				_ = yym3033
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DevicePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("devicePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3034 := z.EncBinary()
				_ = yym3034
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DevicePath))
				}
			}
			if yyr3030 || yy2arr3030 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AttachedVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3035 := z.DecBinary()
	_ = yym3035
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3036 := r.ContainerType()
		if yyct3036 == codecSelferValueTypeMap1234 {
			yyl3036 := r.ReadMapStart()
			if yyl3036 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3036, d)
			}
		} else if yyct3036 == codecSelferValueTypeArray1234 {
			yyl3036 := r.ReadArrayStart()
			if yyl3036 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3036, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AttachedVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3037Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3037Slc
	var yyhl3037 bool = l >= 0
	for yyj3037 := 0; ; yyj3037++ {
		if yyhl3037 {
			if yyj3037 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3037Slc = r.DecodeBytes(yys3037Slc, true, true)
		yys3037 := string(yys3037Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3037 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = UniqueVolumeName(r.DecodeString())
			}
		case "devicePath":
			if r.TryDecodeAsNil() {
				x.DevicePath = ""
			} else {
				x.DevicePath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3037)
		} // end switch yys3037
	} // end for yyj3037
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AttachedVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3040 int
	var yyb3040 bool
	var yyhl3040 bool = l >= 0
	yyj3040++
	if yyhl3040 {
		yyb3040 = yyj3040 > l
	} else {
		yyb3040 = r.CheckBreak()
	}
	if yyb3040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = UniqueVolumeName(r.DecodeString())
	}
	yyj3040++
	if yyhl3040 {
		yyb3040 = yyj3040 > l
	} else {
		yyb3040 = r.CheckBreak()
	}
	if yyb3040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DevicePath = ""
	} else {
		x.DevicePath = string(r.DecodeString())
	}
	for {
		yyj3040++
		if yyhl3040 {
			yyb3040 = yyj3040 > l
		} else {
			yyb3040 = r.CheckBreak()
		}
		if yyb3040 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3040-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AvoidPods) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3043 := z.EncBinary()
		_ = yym3043
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3044 := !z.EncBinary()
			yy2arr3044 := z.EncBasicHandle().StructToArray
			var yyq3044 [1]bool
			_, _, _ = yysep3044, yyq3044, yy2arr3044
			const yyr3044 bool = false
			yyq3044[0] = len(x.PreferAvoidPods) != 0
			var yynn3044 int
			if yyr3044 || yy2arr3044 {
				r.EncodeArrayStart(1)
			} else {
				yynn3044 = 0
				for _, b := range yyq3044 {
					if b {
						yynn3044++
					}
				}
				r.EncodeMapStart(yynn3044)
				yynn3044 = 0
			}
			if yyr3044 || yy2arr3044 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3044[0] {
					if x.PreferAvoidPods == nil {
						r.EncodeNil()
					} else {
						yym3046 := z.EncBinary()
						_ = yym3046
						if false {
						} else {
							h.encSlicePreferAvoidPodsEntry(([]PreferAvoidPodsEntry)(x.PreferAvoidPods), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3044[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferAvoidPods"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferAvoidPods == nil {
						r.EncodeNil()
					} else {
						yym3047 := z.EncBinary()
						_ = yym3047
						if false {
						} else {
							h.encSlicePreferAvoidPodsEntry(([]PreferAvoidPodsEntry)(x.PreferAvoidPods), e)
						}
					}
				}
			}
			if yyr3044 || yy2arr3044 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AvoidPods) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3048 := z.DecBinary()
	_ = yym3048
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3049 := r.ContainerType()
		if yyct3049 == codecSelferValueTypeMap1234 {
			yyl3049 := r.ReadMapStart()
			if yyl3049 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3049, d)
			}
		} else if yyct3049 == codecSelferValueTypeArray1234 {
			yyl3049 := r.ReadArrayStart()
			if yyl3049 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3049, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AvoidPods) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3050Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3050Slc
	var yyhl3050 bool = l >= 0
	for yyj3050 := 0; ; yyj3050++ {
		if yyhl3050 {
			if yyj3050 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3050Slc = r.DecodeBytes(yys3050Slc, true, true)
		yys3050 := string(yys3050Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3050 {
		case "preferAvoidPods":
			if r.TryDecodeAsNil() {
				x.PreferAvoidPods = nil
			} else {
				yyv3051 := &x.PreferAvoidPods
				yym3052 := z.DecBinary()
				_ = yym3052
				if false {
				} else {
					h.decSlicePreferAvoidPodsEntry((*[]PreferAvoidPodsEntry)(yyv3051), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3050)
		} // end switch yys3050
	} // end for yyj3050
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AvoidPods) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3053 int
	var yyb3053 bool
	var yyhl3053 bool = l >= 0
	yyj3053++
	if yyhl3053 {
		yyb3053 = yyj3053 > l
	} else {
		yyb3053 = r.CheckBreak()
	}
	if yyb3053 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferAvoidPods = nil
	} else {
		yyv3054 := &x.PreferAvoidPods
		yym3055 := z.DecBinary()
		_ = yym3055
		if false {
		} else {
			h.decSlicePreferAvoidPodsEntry((*[]PreferAvoidPodsEntry)(yyv3054), d)
		}
	}
	for {
		yyj3053++
		if yyhl3053 {
			yyb3053 = yyj3053 > l
		} else {
			yyb3053 = r.CheckBreak()
		}
		if yyb3053 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3053-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferAvoidPodsEntry) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3056 := z.EncBinary()
		_ = yym3056
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3057 := !z.EncBinary()
			yy2arr3057 := z.EncBasicHandle().StructToArray
			var yyq3057 [4]bool
			_, _, _ = yysep3057, yyq3057, yy2arr3057
			const yyr3057 bool = false
			yyq3057[1] = true
			yyq3057[2] = x.Reason != ""
			yyq3057[3] = x.Message != ""
			var yynn3057 int
			if yyr3057 || yy2arr3057 {
				r.EncodeArrayStart(4)
			} else {
				yynn3057 = 1
				for _, b := range yyq3057 {
					if b {
						yynn3057++
					}
				}
				r.EncodeMapStart(yynn3057)
				yynn3057 = 0
			}
			if yyr3057 || yy2arr3057 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy3059 := &x.PodSignature
				yy3059.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podSignature"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy3060 := &x.PodSignature
				yy3060.CodecEncodeSelf(e)
			}
			if yyr3057 || yy2arr3057 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3057[1] {
					yy3062 := &x.EvictionTime
					yym3063 := z.EncBinary()
					_ = yym3063
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3062) {
					} else if yym3063 {
						z.EncBinaryMarshal(yy3062)
					} else if !yym3063 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3062)
					} else {
						z.EncFallback(yy3062)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3057[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3064 := &x.EvictionTime
					yym3065 := z.EncBinary()
					_ = yym3065
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3064) {
					} else if yym3065 {
						z.EncBinaryMarshal(yy3064)
					} else if !yym3065 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3064)
					} else {
						z.EncFallback(yy3064)
					}
				}
			}
			if yyr3057 || yy2arr3057 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3057[2] {
					yym3067 := z.EncBinary()
					_ = yym3067
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3057[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3068 := z.EncBinary()
					_ = yym3068
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr3057 || yy2arr3057 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3057[3] {
					yym3070 := z.EncBinary()
					_ = yym3070
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3057[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3071 := z.EncBinary()
					_ = yym3071
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr3057 || yy2arr3057 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PreferAvoidPodsEntry) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3072 := z.DecBinary()
	_ = yym3072
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3073 := r.ContainerType()
		if yyct3073 == codecSelferValueTypeMap1234 {
			yyl3073 := r.ReadMapStart()
			if yyl3073 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3073, d)
			}
		} else if yyct3073 == codecSelferValueTypeArray1234 {
			yyl3073 := r.ReadArrayStart()
			if yyl3073 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3073, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PreferAvoidPodsEntry) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3074Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3074Slc
	var yyhl3074 bool = l >= 0
	for yyj3074 := 0; ; yyj3074++ {
		if yyhl3074 {
			if yyj3074 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3074Slc = r.DecodeBytes(yys3074Slc, true, true)
		yys3074 := string(yys3074Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3074 {
		case "podSignature":
			if r.TryDecodeAsNil() {
				x.PodSignature = PodSignature{}
			} else {
				yyv3075 := &x.PodSignature
				yyv3075.CodecDecodeSelf(d)
			}
		case "evictionTime":
			if r.TryDecodeAsNil() {
				x.EvictionTime = pkg2_unversioned.Time{}
			} else {
				yyv3076 := &x.EvictionTime
				yym3077 := z.DecBinary()
				_ = yym3077
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3076) {
				} else if yym3077 {
					z.DecBinaryUnmarshal(yyv3076)
				} else if !yym3077 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3076)
				} else {
					z.DecFallback(yyv3076, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3074)
		} // end switch yys3074
	} // end for yyj3074
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PreferAvoidPodsEntry) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3080 int
	var yyb3080 bool
	var yyhl3080 bool = l >= 0
	yyj3080++
	if yyhl3080 {
		yyb3080 = yyj3080 > l
	} else {
		yyb3080 = r.CheckBreak()
	}
	if yyb3080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodSignature = PodSignature{}
	} else {
		yyv3081 := &x.PodSignature
		yyv3081.CodecDecodeSelf(d)
	}
	yyj3080++
	if yyhl3080 {
		yyb3080 = yyj3080 > l
	} else {
		yyb3080 = r.CheckBreak()
	}
	if yyb3080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionTime = pkg2_unversioned.Time{}
	} else {
		yyv3082 := &x.EvictionTime
		yym3083 := z.DecBinary()
		_ = yym3083
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3082) {
		} else if yym3083 {
			z.DecBinaryUnmarshal(yyv3082)
		} else if !yym3083 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3082)
		} else {
			z.DecFallback(yyv3082, false)
		}
	}
	yyj3080++
	if yyhl3080 {
		yyb3080 = yyj3080 > l
	} else {
		yyb3080 = r.CheckBreak()
	}
	if yyb3080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj3080++
	if yyhl3080 {
		yyb3080 = yyj3080 > l
	} else {
		yyb3080 = r.CheckBreak()
	}
	if yyb3080 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj3080++
		if yyhl3080 {
			yyb3080 = yyj3080 > l
		} else {
			yyb3080 = r.CheckBreak()
		}
		if yyb3080 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3080-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSignature) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3086 := z.EncBinary()
		_ = yym3086
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3087 := !z.EncBinary()
			yy2arr3087 := z.EncBasicHandle().StructToArray
			var yyq3087 [1]bool
			_, _, _ = yysep3087, yyq3087, yy2arr3087
			const yyr3087 bool = false
			yyq3087[0] = x.PodController != nil
			var yynn3087 int
			if yyr3087 || yy2arr3087 {
				r.EncodeArrayStart(1)
			} else {
				yynn3087 = 0
				for _, b := range yyq3087 {
					if b {
						yynn3087++
					}
				}
				r.EncodeMapStart(yynn3087)
				yynn3087 = 0
			}
			if yyr3087 || yy2arr3087 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3087[0] {
					if x.PodController == nil {
						r.EncodeNil()
					} else {
						x.PodController.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3087[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podController"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodController == nil {
						r.EncodeNil()
					} else {
						x.PodController.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3087 || yy2arr3087 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSignature) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3089 := z.DecBinary()
	_ = yym3089
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3090 := r.ContainerType()
		if yyct3090 == codecSelferValueTypeMap1234 {
			yyl3090 := r.ReadMapStart()
			if yyl3090 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3090, d)
			}
		} else if yyct3090 == codecSelferValueTypeArray1234 {
			yyl3090 := r.ReadArrayStart()
			if yyl3090 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3090, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSignature) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3091Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3091Slc
	var yyhl3091 bool = l >= 0
	for yyj3091 := 0; ; yyj3091++ {
		if yyhl3091 {
			if yyj3091 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3091Slc = r.DecodeBytes(yys3091Slc, true, true)
		yys3091 := string(yys3091Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3091 {
		case "podController":
			if r.TryDecodeAsNil() {
				if x.PodController != nil {
					x.PodController = nil
				}
			} else {
				if x.PodController == nil {
					x.PodController = new(OwnerReference)
				}
				x.PodController.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3091)
		} // end switch yys3091
	} // end for yyj3091
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSignature) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3093 int
	var yyb3093 bool
	var yyhl3093 bool = l >= 0
	yyj3093++
	if yyhl3093 {
		yyb3093 = yyj3093 > l
	} else {
		yyb3093 = r.CheckBreak()
	}
	if yyb3093 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodController != nil {
			x.PodController = nil
		}
	} else {
		if x.PodController == nil {
			x.PodController = new(OwnerReference)
		}
		x.PodController.CodecDecodeSelf(d)
	}
	for {
		yyj3093++
		if yyhl3093 {
			yyb3093 = yyj3093 > l
		} else {
			yyb3093 = r.CheckBreak()
		}
		if yyb3093 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3093-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerImage) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3095 := z.EncBinary()
		_ = yym3095
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3096 := !z.EncBinary()
			yy2arr3096 := z.EncBasicHandle().StructToArray
			var yyq3096 [2]bool
			_, _, _ = yysep3096, yyq3096, yy2arr3096
			const yyr3096 bool = false
			yyq3096[1] = x.SizeBytes != 0
			var yynn3096 int
			if yyr3096 || yy2arr3096 {
				r.EncodeArrayStart(2)
			} else {
				yynn3096 = 1
				for _, b := range yyq3096 {
					if b {
						yynn3096++
					}
				}
				r.EncodeMapStart(yynn3096)
				yynn3096 = 0
			}
			if yyr3096 || yy2arr3096 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Names == nil {
					r.EncodeNil()
				} else {
					yym3098 := z.EncBinary()
					_ = yym3098
					if false {
					} else {
						z.F.EncSliceStringV(x.Names, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("names"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Names == nil {
					r.EncodeNil()
				} else {
					yym3099 := z.EncBinary()
					_ = yym3099
					if false {
					} else {
						z.F.EncSliceStringV(x.Names, false, e)
					}
				}
			}
			if yyr3096 || yy2arr3096 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3096[1] {
					yym3101 := z.EncBinary()
					_ = yym3101
					if false {
					} else {
						r.EncodeInt(int64(x.SizeBytes))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq3096[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sizeBytes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3102 := z.EncBinary()
					_ = yym3102
					if false {
					} else {
						r.EncodeInt(int64(x.SizeBytes))
					}
				}
			}
			if yyr3096 || yy2arr3096 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerImage) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3103 := z.DecBinary()
	_ = yym3103
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3104 := r.ContainerType()
		if yyct3104 == codecSelferValueTypeMap1234 {
			yyl3104 := r.ReadMapStart()
			if yyl3104 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3104, d)
			}
		} else if yyct3104 == codecSelferValueTypeArray1234 {
			yyl3104 := r.ReadArrayStart()
			if yyl3104 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3104, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerImage) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3105Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3105Slc
	var yyhl3105 bool = l >= 0
	for yyj3105 := 0; ; yyj3105++ {
		if yyhl3105 {
			if yyj3105 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3105Slc = r.DecodeBytes(yys3105Slc, true, true)
		yys3105 := string(yys3105Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3105 {
		case "names":
			if r.TryDecodeAsNil() {
				x.Names = nil
			} else {
				yyv3106 := &x.Names
				yym3107 := z.DecBinary()
				_ = yym3107
				if false {
				} else {
					z.F.DecSliceStringX(yyv3106, false, d)
				}
			}
		case "sizeBytes":
			if r.TryDecodeAsNil() {
				x.SizeBytes = 0
			} else {
				x.SizeBytes = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys3105)
		} // end switch yys3105
	} // end for yyj3105
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerImage) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3109 int
	var yyb3109 bool
	var yyhl3109 bool = l >= 0
	yyj3109++
	if yyhl3109 {
		yyb3109 = yyj3109 > l
	} else {
		yyb3109 = r.CheckBreak()
	}
	if yyb3109 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Names = nil
	} else {
		yyv3110 := &x.Names
		yym3111 := z.DecBinary()
		_ = yym3111
		if false {
		} else {
			z.F.DecSliceStringX(yyv3110, false, d)
		}
	}
	yyj3109++
	if yyhl3109 {
		yyb3109 = yyj3109 > l
	} else {
		yyb3109 = r.CheckBreak()
	}
	if yyb3109 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SizeBytes = 0
	} else {
		x.SizeBytes = int64(r.DecodeInt(64))
	}
	for {
		yyj3109++
		if yyhl3109 {
			yyb3109 = yyj3109 > l
		} else {
			yyb3109 = r.CheckBreak()
		}
		if yyb3109 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3109-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3113 := z.EncBinary()
	_ = yym3113
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3114 := z.DecBinary()
	_ = yym3114
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x NodeConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3115 := z.EncBinary()
	_ = yym3115
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3116 := z.DecBinary()
	_ = yym3116
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3117 := z.EncBinary()
		_ = yym3117
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3118 := !z.EncBinary()
			yy2arr3118 := z.EncBasicHandle().StructToArray
			var yyq3118 [6]bool
			_, _, _ = yysep3118, yyq3118, yy2arr3118
			const yyr3118 bool = false
			yyq3118[2] = true
			yyq3118[3] = true
			yyq3118[4] = x.Reason != ""
			yyq3118[5] = x.Message != ""
			var yynn3118 int
			if yyr3118 || yy2arr3118 {
				r.EncodeArrayStart(6)
			} else {
				yynn3118 = 2
				for _, b := range yyq3118 {
					if b {
						yynn3118++
					}
				}
				r.EncodeMapStart(yynn3118)
				yynn3118 = 0
			}
			if yyr3118 || yy2arr3118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr3118 || yy2arr3118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr3118 || yy2arr3118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3118[2] {
					yy3122 := &x.LastHeartbeatTime
					yym3123 := z.EncBinary()
					_ = yym3123
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3122) {
					} else if yym3123 {
						z.EncBinaryMarshal(yy3122)
					} else if !yym3123 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3122)
					} else {
						z.EncFallback(yy3122)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3118[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastHeartbeatTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3124 := &x.LastHeartbeatTime
					yym3125 := z.EncBinary()
					_ = yym3125
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3124) {
					} else if yym3125 {
						z.EncBinaryMarshal(yy3124)
					} else if !yym3125 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3124)
					} else {
						z.EncFallback(yy3124)
					}
				}
			}
			if yyr3118 || yy2arr3118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3118[3] {
					yy3127 := &x.LastTransitionTime
					yym3128 := z.EncBinary()
					_ = yym3128
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3127) {
					} else if yym3128 {
						z.EncBinaryMarshal(yy3127)
					} else if !yym3128 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3127)
					} else {
						z.EncFallback(yy3127)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3118[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3129 := &x.LastTransitionTime
					yym3130 := z.EncBinary()
					_ = yym3130
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3129) {
					} else if yym3130 {
						z.EncBinaryMarshal(yy3129)
					} else if !yym3130 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3129)
					} else {
						z.EncFallback(yy3129)
					}
				}
			}
			if yyr3118 || yy2arr3118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3118[4] {
					yym3132 := z.EncBinary()
					_ = yym3132
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3118[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3133 := z.EncBinary()
					_ = yym3133
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr3118 || yy2arr3118 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3118[5] {
					yym3135 := z.EncBinary()
					_ = yym3135
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3118[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3136 := z.EncBinary()
					_ = yym3136
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr3118 || yy2arr3118 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3137 := z.DecBinary()
	_ = yym3137
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3138 := r.ContainerType()
		if yyct3138 == codecSelferValueTypeMap1234 {
			yyl3138 := r.ReadMapStart()
			if yyl3138 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3138, d)
			}
		} else if yyct3138 == codecSelferValueTypeArray1234 {
			yyl3138 := r.ReadArrayStart()
			if yyl3138 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3138, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3139Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3139Slc
	var yyhl3139 bool = l >= 0
	for yyj3139 := 0; ; yyj3139++ {
		if yyhl3139 {
			if yyj3139 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3139Slc = r.DecodeBytes(yys3139Slc, true, true)
		yys3139 := string(yys3139Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3139 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = NodeConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastHeartbeatTime":
			if r.TryDecodeAsNil() {
				x.LastHeartbeatTime = pkg2_unversioned.Time{}
			} else {
				yyv3142 := &x.LastHeartbeatTime
				yym3143 := z.DecBinary()
				_ = yym3143
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3142) {
				} else if yym3143 {
					z.DecBinaryUnmarshal(yyv3142)
				} else if !yym3143 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3142)
				} else {
					z.DecFallback(yyv3142, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv3144 := &x.LastTransitionTime
				yym3145 := z.DecBinary()
				_ = yym3145
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3144) {
				} else if yym3145 {
					z.DecBinaryUnmarshal(yyv3144)
				} else if !yym3145 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3144)
				} else {
					z.DecFallback(yyv3144, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3139)
		} // end switch yys3139
	} // end for yyj3139
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3148 int
	var yyb3148 bool
	var yyhl3148 bool = l >= 0
	yyj3148++
	if yyhl3148 {
		yyb3148 = yyj3148 > l
	} else {
		yyb3148 = r.CheckBreak()
	}
	if yyb3148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = NodeConditionType(r.DecodeString())
	}
	yyj3148++
	if yyhl3148 {
		yyb3148 = yyj3148 > l
	} else {
		yyb3148 = r.CheckBreak()
	}
	if yyb3148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj3148++
	if yyhl3148 {
		yyb3148 = yyj3148 > l
	} else {
		yyb3148 = r.CheckBreak()
	}
	if yyb3148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastHeartbeatTime = pkg2_unversioned.Time{}
	} else {
		yyv3151 := &x.LastHeartbeatTime
		yym3152 := z.DecBinary()
		_ = yym3152
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3151) {
		} else if yym3152 {
			z.DecBinaryUnmarshal(yyv3151)
		} else if !yym3152 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3151)
		} else {
			z.DecFallback(yyv3151, false)
		}
	}
	yyj3148++
	if yyhl3148 {
		yyb3148 = yyj3148 > l
	} else {
		yyb3148 = r.CheckBreak()
	}
	if yyb3148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv3153 := &x.LastTransitionTime
		yym3154 := z.DecBinary()
		_ = yym3154
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3153) {
		} else if yym3154 {
			z.DecBinaryUnmarshal(yyv3153)
		} else if !yym3154 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3153)
		} else {
			z.DecFallback(yyv3153, false)
		}
	}
	yyj3148++
	if yyhl3148 {
		yyb3148 = yyj3148 > l
	} else {
		yyb3148 = r.CheckBreak()
	}
	if yyb3148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj3148++
	if yyhl3148 {
		yyb3148 = yyj3148 > l
	} else {
		yyb3148 = r.CheckBreak()
	}
	if yyb3148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj3148++
		if yyhl3148 {
			yyb3148 = yyj3148 > l
		} else {
			yyb3148 = r.CheckBreak()
		}
		if yyb3148 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3148-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeAddressType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3157 := z.EncBinary()
	_ = yym3157
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeAddressType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3158 := z.DecBinary()
	_ = yym3158
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3159 := z.EncBinary()
		_ = yym3159
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3160 := !z.EncBinary()
			yy2arr3160 := z.EncBasicHandle().StructToArray
			var yyq3160 [2]bool
			_, _, _ = yysep3160, yyq3160, yy2arr3160
			const yyr3160 bool = false
			var yynn3160 int
			if yyr3160 || yy2arr3160 {
				r.EncodeArrayStart(2)
			} else {
				yynn3160 = 2
				for _, b := range yyq3160 {
					if b {
						yynn3160++
					}
				}
				r.EncodeMapStart(yynn3160)
				yynn3160 = 0
			}
			if yyr3160 || yy2arr3160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr3160 || yy2arr3160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3163 := z.EncBinary()
				_ = yym3163
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3164 := z.EncBinary()
				_ = yym3164
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr3160 || yy2arr3160 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3165 := z.DecBinary()
	_ = yym3165
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3166 := r.ContainerType()
		if yyct3166 == codecSelferValueTypeMap1234 {
			yyl3166 := r.ReadMapStart()
			if yyl3166 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3166, d)
			}
		} else if yyct3166 == codecSelferValueTypeArray1234 {
			yyl3166 := r.ReadArrayStart()
			if yyl3166 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3166, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3167Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3167Slc
	var yyhl3167 bool = l >= 0
	for yyj3167 := 0; ; yyj3167++ {
		if yyhl3167 {
			if yyj3167 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3167Slc = r.DecodeBytes(yys3167Slc, true, true)
		yys3167 := string(yys3167Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3167 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = NodeAddressType(r.DecodeString())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3167)
		} // end switch yys3167
	} // end for yyj3167
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3170 int
	var yyb3170 bool
	var yyhl3170 bool = l >= 0
	yyj3170++
	if yyhl3170 {
		yyb3170 = yyj3170 > l
	} else {
		yyb3170 = r.CheckBreak()
	}
	if yyb3170 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = NodeAddressType(r.DecodeString())
	}
	yyj3170++
	if yyhl3170 {
		yyb3170 = yyj3170 > l
	} else {
		yyb3170 = r.CheckBreak()
	}
	if yyb3170 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	for {
		yyj3170++
		if yyhl3170 {
			yyb3170 = yyj3170 > l
		} else {
			yyb3170 = r.CheckBreak()
		}
		if yyb3170 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3170-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ResourceName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3173 := z.EncBinary()
	_ = yym3173
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ResourceName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3174 := z.DecBinary()
	_ = yym3174
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3175 := z.EncBinary()
		_ = yym3175
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			h.encResourceList((ResourceList)(x), e)
		}
	}
}

func (x *ResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3176 := z.DecBinary()
	_ = yym3176
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		h.decResourceList((*ResourceList)(x), d)
	}
}

func (x *Node) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3177 := z.EncBinary()
		_ = yym3177
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3178 := !z.EncBinary()
			yy2arr3178 := z.EncBasicHandle().StructToArray
			var yyq3178 [5]bool
			_, _, _ = yysep3178, yyq3178, yy2arr3178
			const yyr3178 bool = false
			yyq3178[0] = x.Kind != ""
			yyq3178[1] = x.APIVersion != ""
			yyq3178[2] = true
			yyq3178[3] = true
			yyq3178[4] = true
			var yynn3178 int
			if yyr3178 || yy2arr3178 {
				r.EncodeArrayStart(5)
			} else {
				yynn3178 = 0
				for _, b := range yyq3178 {
					if b {
						yynn3178++
					}
				}
				r.EncodeMapStart(yynn3178)
				yynn3178 = 0
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[0] {
					yym3180 := z.EncBinary()
					_ = yym3180
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3178[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3181 := z.EncBinary()
					_ = yym3181
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[1] {
					yym3183 := z.EncBinary()
					_ = yym3183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3178[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3184 := z.EncBinary()
					_ = yym3184
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[2] {
					yy3186 := &x.ObjectMeta
					yy3186.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3178[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3187 := &x.ObjectMeta
					yy3187.CodecEncodeSelf(e)
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[3] {
					yy3189 := &x.Spec
					yy3189.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3178[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3190 := &x.Spec
					yy3190.CodecEncodeSelf(e)
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3178[4] {
					yy3192 := &x.Status
					yy3192.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3178[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3193 := &x.Status
					yy3193.CodecEncodeSelf(e)
				}
			}
			if yyr3178 || yy2arr3178 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Node) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3194 := z.DecBinary()
	_ = yym3194
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3195 := r.ContainerType()
		if yyct3195 == codecSelferValueTypeMap1234 {
			yyl3195 := r.ReadMapStart()
			if yyl3195 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3195, d)
			}
		} else if yyct3195 == codecSelferValueTypeArray1234 {
			yyl3195 := r.ReadArrayStart()
			if yyl3195 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3195, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Node) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3196Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3196Slc
	var yyhl3196 bool = l >= 0
	for yyj3196 := 0; ; yyj3196++ {
		if yyhl3196 {
			if yyj3196 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3196Slc = r.DecodeBytes(yys3196Slc, true, true)
		yys3196 := string(yys3196Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3196 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv3199 := &x.ObjectMeta
				yyv3199.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NodeSpec{}
			} else {
				yyv3200 := &x.Spec
				yyv3200.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = NodeStatus{}
			} else {
				yyv3201 := &x.Status
				yyv3201.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3196)
		} // end switch yys3196
	} // end for yyj3196
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Node) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3202 int
	var yyb3202 bool
	var yyhl3202 bool = l >= 0
	yyj3202++
	if yyhl3202 {
		yyb3202 = yyj3202 > l
	} else {
		yyb3202 = r.CheckBreak()
	}
	if yyb3202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj3202++
	if yyhl3202 {
		yyb3202 = yyj3202 > l
	} else {
		yyb3202 = r.CheckBreak()
	}
	if yyb3202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj3202++
	if yyhl3202 {
		yyb3202 = yyj3202 > l
	} else {
		yyb3202 = r.CheckBreak()
	}
	if yyb3202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		retur