// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package healthiface provides an interface to enable mocking the AWS Health APIs and Notifications service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package healthiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/health"
)

// HealthAPI provides an interface to enable mocking the
// health.Health service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Health APIs and Notifications.
//    func myFunc(svc healthiface.HealthAPI) bool {
//        // Make svc.DescribeAffectedEntities request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := health.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockHealthClient struct {
//        healthiface.HealthAPI
//    }
//    func (m *mockHealthClient) DescribeAffectedEntities(input *health.DescribeAffectedEntitiesInput) (*health.DescribeAffectedEntitiesOutput, error) {
//        // mock response/functionality
//    }
//
//    TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockHealthClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type HealthAPI interface {
	DescribeAffectedEntitiesRequest(*health.DescribeAffectedEntitiesInput) (*request.Request, *health.DescribeAffectedEntitiesOutput)

	DescribeAffectedEntities(*health.DescribeAffectedEntitiesInput) (*health.DescribeAffectedEntitiesOutput, error)

	DescribeAffectedEntitiesPages(*health.DescribeAffectedEntitiesInput, func(*health.DescribeAffectedEntitiesOutput, bool) bool) error

	DescribeEntityAggregatesRequest(*health.DescribeEntityAggregatesInput) (*request.Request, *health.DescribeEntityAggregatesOutput)

	DescribeEntityAggregates(*health.DescribeEntityAggregatesInput) (*health.DescribeEntityAggregatesOutput, error)

	DescribeEventAggregatesRequest(*health.DescribeEventAggregatesInput) (*request.Request, *health.DescribeEventAggregatesOutput)

	DescribeEventAggregates(*health.DescribeEventAggregatesInput) (*health.DescribeEventAggregatesOutput, error)

	DescribeEventAggregatesPages(*health.DescribeEventAggregatesInput, func(*health.DescribeEventAggregatesOutput, bool) bool) error

	DescribeEventDetailsRequest(*health.DescribeEventDetailsInput) (*request.Request, *health.DescribeEventDetailsOutput)

	DescribeEventDetails(*health.DescribeEventDetailsInput) (*health.DescribeEventDetailsOutput, error)

	DescribeEventTypesRequest(*health.DescribeEventTypesInput) (*request.Request, *health.DescribeEventTypesOutput)

	DescribeEventTypes(*health.DescribeEventTypesInput) (*health.DescribeEventTypesOutput, error)

	DescribeEventTypesPages(*health.DescribeEventTypesInput, func(*health.DescribeEventTypesOutput, bool) bool) error

	DescribeEventsRequest(*health.DescribeEventsInput) (*request.Request, *health.DescribeEventsOutput)

	DescribeEvents(*health.DescribeEventsInput) (*health.DescribeEventsOutput, error)

	DescribeEventsPages(*health.DescribeEventsInput, func(*health.DescribeEventsOutput, bool) bool) error
}

var _ HealthAPI = (*health.Health)(nil)
