// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package codebuild

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/client/metadata"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

// AWS CodeBuild is a fully-managed build service in the cloud. AWS CodeBuild
// compiles your source code, runs unit tests, and produces artifacts that are
// ready to deploy. AWS CodeBuild eliminates the need to provision, manage,
// and scale your own build servers. It provides prepackaged build environments
// for the most popular programming languages and build tools such as Apach
// Maven, Gradle, and more. You can also fully customize build environments
// in AWS CodeBuild to use your own build tools. AWS CodeBuild scales automatically
// to meet peak build requests, and you pay only for the build time you consume.
// For more information about AWS CodeBuild, see the AWS CodeBuild User Guide.
//
// AWS CodeBuild supports these operations:
//
//    * BatchGetProjects: Gets information about one or more build projects.
//    A build project defines how AWS CodeBuild will run a build. This includes
//    information such as where to get the source code to build, the build environment
//    to use, the build commands to run, and where to store the build output.
//    A build environment represents a combination of operating system, programming
//    language runtime, and tools that AWS CodeBuild will use to run a build.
//    Also, you can add tags to build projects to help manage your resources
//    and costs.
//
//    * CreateProject: Creates a build project.
//
//    * DeleteProject: Deletes a build project.
//
//    * ListProjects: Gets a list of build project names, with each build project
//    name representing a single build project.
//
//    * UpdateProject: Changes the settings of an existing build project.
//
//    * BatchGetBuilds: Gets information about one or more builds.
//
//    * ListBuilds: Gets a list of build IDs, with each build ID representing
//    a single build.
//
//    * ListBuildsForProject: Gets a list of build IDs for the specified build
//    project, with each build ID representing a single build.
//
//    * StartBuild: Starts running a build.
//
//    * StopBuild: Attempts to stop running a build.
//
//    * ListCuratedEnvironmentImages: Gets information about Docker images that
//    are managed by AWS CodeBuild.
// The service client's operations are safe to be used concurrently.
// It is not safe to mutate any of the client's properties though.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06
type CodeBuild struct {
	*client.Client
}

// Used for custom client initialization logic
var initClient func(*client.Client)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// Service information constants
const (
	ServiceName = "codebuild" // Service endpoint prefix API calls made to.
	EndpointsID = ServiceName // Service ID for Regions and Endpoints metadata.
)

// New creates a new instance of the CodeBuild client with a session.
// If additional configuration is needed for the client instance use the optional
// aws.Config parameter to add your extra config.
//
// Example:
//     // Create a CodeBuild client from just a session.
//     svc := codebuild.New(mySession)
//
//     // Create a CodeBuild client with additional configuration
//     svc := codebuild.New(mySession, aws.NewConfig().WithRegion("us-west-2"))
func New(p client.ConfigProvider, cfgs ...*aws.Config) *CodeBuild {
	c := p.ClientConfig(EndpointsID, cfgs...)
	return newClient(*c.Config, c.Handlers, c.Endpoint, c.SigningRegion, c.SigningName)
}

// newClient creates, initializes and returns a new service client instance.
func newClient(cfg aws.Config, handlers request.Handlers, endpoint, signingRegion, signingName string) *CodeBuild {
	svc := &CodeBuild{
		Client: client.New(
			cfg,
			metadata.ClientInfo{
				ServiceName:   ServiceName,
				SigningName:   signingName,
				SigningRegion: signingRegion,
				Endpoint:      endpoint,
				APIVersion:    "2016-10-06",
				JSONVersion:   "1.1",
				TargetPrefix:  "CodeBuild_20161006",
			},
			handlers,
		),
	}

	// Handlers
	svc.Handlers.Sign.PushBackNamed(v4.SignRequestHandler)
	svc.Handlers.Build.PushBackNamed(jsonrpc.BuildHandler)
	svc.Handlers.Unmarshal.PushBackNamed(jsonrpc.UnmarshalHandler)
	svc.Handlers.UnmarshalMeta.PushBackNamed(jsonrpc.UnmarshalMetaHandler)
	svc.Handlers.UnmarshalError.PushBackNamed(jsonrpc.UnmarshalErrorHandler)

	// Run custom client initialization if present
	if initClient != nil {
		initClient(svc.Client)
	}

	return svc
}

// newRequest creates a new request for a CodeBuild operation and runs any
// custom request initialization.
func (c *CodeBuild) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
