// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package snowballiface provides an interface to enable mocking the Amazon Import/Export Snowball service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package snowballiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/snowball"
)

// SnowballAPI provides an interface to enable mocking the
// snowball.Snowball service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Import/Export Snowball.
//    func myFunc(svc snowballiface.SnowballAPI) bool {
//        // Make svc.CancelCluster request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := snowball.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockSnowballClient struct {
//        snowballiface.SnowballAPI
//    }
//    func (m *mockSnowballClient) CancelCluster(input *snowball.CancelClusterInput) (*snowball.CancelClusterOutput, error) {
//        // mock response/functionality
//    }
//
//    TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockSnowballClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SnowballAPI interface {
	CancelClusterRequest(*snowball.CancelClusterInput) (*request.Request, *snowball.CancelClusterOutput)

	CancelCluster(*snowball.CancelClusterInput) (*snowball.CancelClusterOutput, error)

	CancelJobRequest(*snowball.CancelJobInput) (*request.Request, *snowball.CancelJobOutput)

	CancelJob(*snowball.CancelJobInput) (*snowball.CancelJobOutput, error)

	CreateAddressRequest(*snowball.CreateAddressInput) (*request.Request, *snowball.CreateAddressOutput)

	CreateAddress(*snowball.CreateAddressInput) (*snowball.CreateAddressOutput, error)

	CreateClusterRequest(*snowball.CreateClusterInput) (*request.Request, *snowball.CreateClusterOutput)

	CreateCluster(*snowball.CreateClusterInput) (*snowball.CreateClusterOutput, error)

	CreateJobRequest(*snowball.CreateJobInput) (*request.Request, *snowball.CreateJobOutput)

	CreateJob(*snowball.CreateJobInput) (*snowball.CreateJobOutput, error)

	DescribeAddressRequest(*snowball.DescribeAddressInput) (*request.Request, *snowball.DescribeAddressOutput)

	DescribeAddress(*snowball.DescribeAddressInput) (*snowball.DescribeAddressOutput, error)

	DescribeAddressesRequest(*snowball.DescribeAddressesInput) (*request.Request, *snowball.DescribeAddressesOutput)

	DescribeAddresses(*snowball.DescribeAddressesInput) (*snowball.DescribeAddressesOutput, error)

	DescribeAddressesPages(*snowball.DescribeAddressesInput, func(*snowball.DescribeAddressesOutput, bool) bool) error

	DescribeClusterRequest(*snowball.DescribeClusterInput) (*request.Request, *snowball.DescribeClusterOutput)

	DescribeCluster(*snowball.DescribeClusterInput) (*snowball.DescribeClusterOutput, error)

	DescribeJobRequest(*snowball.DescribeJobInput) (*request.Request, *snowball.DescribeJobOutput)

	DescribeJob(*snowball.DescribeJobInput) (*snowball.DescribeJobOutput, error)

	GetJobManifestRequest(*snowball.GetJobManifestInput) (*request.Request, *snowball.GetJobManifestOutput)

	GetJobManifest(*snowball.GetJobManifestInput) (*snowball.GetJobManifestOutput, error)

	GetJobUnlockCodeRequest(*snowball.GetJobUnlockCodeInput) (*request.Request, *snowball.GetJobUnlockCodeOutput)

	GetJobUnlockCode(*snowball.GetJobUnlockCodeInput) (*snowball.GetJobUnlockCodeOutput, error)

	GetSnowballUsageRequest(*snowball.GetSnowballUsageInput) (*request.Request, *snowball.GetSnowballUsageOutput)

	GetSnowballUsage(*snowball.GetSnowballUsageInput) (*snowball.GetSnowballUsageOutput, error)

	ListClusterJobsRequest(*snowball.ListClusterJobsInput) (*request.Request, *snowball.ListClusterJobsOutput)

	ListClusterJobs(*snowball.ListClusterJobsInput) (*snowball.ListClusterJobsOutput, error)

	ListClustersRequest(*snowball.ListClustersInput) (*request.Request, *snowball.ListClustersOutput)

	ListClusters(*snowball.ListClustersInput) (*snowball.ListClustersOutput, error)

	ListJobsRequest(*snowball.ListJobsInput) (*request.Request, *snowball.ListJobsOutput)

	ListJobs(*snowball.ListJobsInput) (*snowball.ListJobsOutput, error)

	ListJobsPages(*snowball.ListJobsInput, func(*snowball.ListJobsOutput, bool) bool) error

	UpdateClusterRequest(*snowball.UpdateClusterInput) (*request.Request, *snowball.UpdateClusterOutput)

	UpdateCluster(*snowball.UpdateClusterInput) (*snowball.UpdateClusterOutput, error)

	UpdateJobRequest(*snowball.UpdateJobInput) (*request.Request, *snowball.UpdateJobOutput)

	UpdateJob(*snowball.UpdateJobInput) (*snowball.UpdateJobOutput, error)
}

var _ SnowballAPI = (*snowball.Snowball)(nil)
