// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package s3_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleS3_AbortMultipartUpload() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.AbortMultipartUploadInput{
		Bucket:       aws.String("BucketName"),        // Required
		Key:          aws.String("ObjectKey"),         // Required
		UploadId:     aws.String("MultipartUploadId"), // Required
		RequestPayer: aws.String("RequestPayer"),
	}
	resp, err := svc.AbortMultipartUpload(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_CompleteMultipartUpload() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.CompleteMultipartUploadInput{
		Bucket:   aws.String("BucketName"),        // Required
		Key:      aws.String("ObjectKey"),         // Required
		UploadId: aws.String("MultipartUploadId"), // Required
		MultipartUpload: &s3.CompletedMultipartUpload{
			Parts: []*s3.CompletedPart{
				{ // Required
					ETag:       aws.String("ETag"),
					PartNumber: aws.Int64(1),
				},
				// More values...
			},
		},
		RequestPayer: aws.String("RequestPayer"),
	}
	resp, err := svc.CompleteMultipartUpload(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_CopyObject() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.CopyObjectInput{
		Bucket:                         aws.String("BucketName"), // Required
		CopySource:                     aws.String("CopySource"), // Required
		Key:                            aws.String("ObjectKey"),  // Required
		ACL:                            aws.String("ObjectCannedACL"),
		CacheControl:                   aws.String("CacheControl"),
		ContentDisposition:             aws.String("ContentDisposition"),
		ContentEncoding:                aws.String("ContentEncoding"),
		ContentLanguage:                aws.String("ContentLanguage"),
		ContentType:                    aws.String("ContentType"),
		CopySourceIfMatch:              aws.String("CopySourceIfMatch"),
		CopySourceIfModifiedSince:      aws.Time(time.Now()),
		CopySourceIfNoneMatch:          aws.String("CopySourceIfNoneMatch"),
		CopySourceIfUnmodifiedSince:    aws.Time(time.Now()),
		CopySourceSSECustomerAlgorithm: aws.String("CopySourceSSECustomerAlgorithm"),
		CopySourceSSECustomerKey:       aws.String("CopySourceSSECustomerKey"),
		CopySourceSSECustomerKeyMD5:    aws.String("CopySourceSSECustomerKeyMD5"),
		Expires:                        aws.Time(time.Now()),
		GrantFullControl:               aws.String("GrantFullControl"),
		GrantRead:                      aws.String("GrantRead"),
		GrantReadACP:                   aws.String("GrantReadACP"),
		GrantWriteACP:                  aws.String("GrantWriteACP"),
		Metadata: map[string]*string{
			"Key": aws.String("MetadataValue"), // Required
			// More values...
		},
		MetadataDirective:       aws.String("MetadataDirective"),
		RequestPayer:            aws.String("RequestPayer"),
		SSECustomerAlgorithm:    aws.String("SSECustomerAlgorithm"),
		SSECustomerKey:          aws.String("SSECustomerKey"),
		SSECustomerKeyMD5:       aws.String("SSECustomerKeyMD5"),
		SSEKMSKeyId:             aws.String("SSEKMSKeyId"),
		ServerSideEncryption:    aws.String("ServerSideEncryption"),
		StorageClass:            aws.String("StorageClass"),
		Tagging:                 aws.String("TaggingHeader"),
		TaggingDirective:        aws.String("TaggingDirective"),
		WebsiteRedirectLocation: aws.String("WebsiteRedirectLocation"),
	}
	resp, err := svc.CopyObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_CreateBucket() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.CreateBucketInput{
		Bucket: aws.String("BucketName"), // Required
		ACL:    aws.String("BucketCannedACL"),
		CreateBucketConfiguration: &s3.CreateBucketConfiguration{
			LocationConstraint: aws.String("BucketLocationConstraint"),
		},
		GrantFullControl: aws.String("GrantFullControl"),
		GrantRead:        aws.String("GrantRead"),
		GrantReadACP:     aws.String("GrantReadACP"),
		GrantWrite:       aws.String("GrantWrite"),
		GrantWriteACP:    aws.String("GrantWriteACP"),
	}
	resp, err := svc.CreateBucket(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_CreateMultipartUpload() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.CreateMultipartUploadInput{
		Bucket:             aws.String("BucketName"), // Required
		Key:                aws.String("ObjectKey"),  // Required
		ACL:                aws.String("ObjectCannedACL"),
		CacheControl:       aws.String("CacheControl"),
		ContentDisposition: aws.String("ContentDisposition"),
		ContentEncoding:    aws.String("ContentEncoding"),
		ContentLanguage:    aws.String("ContentLanguage"),
		ContentType:        aws.String("ContentType"),
		Expires:            aws.Time(time.Now()),
		GrantFullControl:   aws.String("GrantFullControl"),
		GrantRead:          aws.String("GrantRead"),
		GrantReadACP:       aws.String("GrantReadACP"),
		GrantWriteACP:      aws.String("GrantWriteACP"),
		Metadata: map[string]*string{
			"Key": aws.String("MetadataValue"), // Required
			// More values...
		},
		RequestPayer:            aws.String("RequestPayer"),
		SSECustomerAlgorithm:    aws.String("SSECustomerAlgorithm"),
		SSECustomerKey:          aws.String("SSECustomerKey"),
		SSECustomerKeyMD5:       aws.String("SSECustomerKeyMD5"),
		SSEKMSKeyId:             aws.String("SSEKMSKeyId"),
		ServerSideEncryption:    aws.String("ServerSideEncryption"),
		StorageClass:            aws.String("StorageClass"),
		WebsiteRedirectLocation: aws.String("WebsiteRedirectLocation"),
	}
	resp, err := svc.CreateMultipartUpload(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucket() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.DeleteBucket(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketAnalyticsConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketAnalyticsConfigurationInput{
		Bucket: aws.String("BucketName"),  // Required
		Id:     aws.String("AnalyticsId"), // Required
	}
	resp, err := svc.DeleteBucketAnalyticsConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketCors() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketCorsInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.DeleteBucketCors(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketInventoryConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketInventoryConfigurationInput{
		Bucket: aws.String("BucketName"),  // Required
		Id:     aws.String("InventoryId"), // Required
	}
	resp, err := svc.DeleteBucketInventoryConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketLifecycle() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketLifecycleInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.DeleteBucketLifecycle(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketMetricsConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketMetricsConfigurationInput{
		Bucket: aws.String("BucketName"), // Required
		Id:     aws.String("MetricsId"),  // Required
	}
	resp, err := svc.DeleteBucketMetricsConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketPolicy() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketPolicyInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.DeleteBucketPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketReplication() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketReplicationInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.DeleteBucketReplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketTagging() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketTaggingInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.DeleteBucketTagging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteBucketWebsite() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteBucketWebsiteInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.DeleteBucketWebsite(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteObject() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteObjectInput{
		Bucket:       aws.String("BucketName"), // Required
		Key:          aws.String("ObjectKey"),  // Required
		MFA:          aws.String("MFA"),
		RequestPayer: aws.String("RequestPayer"),
		VersionId:    aws.String("ObjectVersionId"),
	}
	resp, err := svc.DeleteObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteObjectTagging() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteObjectTaggingInput{
		Bucket:    aws.String("BucketName"), // Required
		Key:       aws.String("ObjectKey"),  // Required
		VersionId: aws.String("ObjectVersionId"),
	}
	resp, err := svc.DeleteObjectTagging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_DeleteObjects() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.DeleteObjectsInput{
		Bucket: aws.String("BucketName"), // Required
		Delete: &s3.Delete{ // Required
			Objects: []*s3.ObjectIdentifier{ // Required
				{ // Required
					Key:       aws.String("ObjectKey"), // Required
					VersionId: aws.String("ObjectVersionId"),
				},
				// More values...
			},
			Quiet: aws.Bool(true),
		},
		MFA:          aws.String("MFA"),
		RequestPayer: aws.String("RequestPayer"),
	}
	resp, err := svc.DeleteObjects(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketAccelerateConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketAccelerateConfigurationInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketAccelerateConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketAcl() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketAclInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketAcl(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketAnalyticsConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketAnalyticsConfigurationInput{
		Bucket: aws.String("BucketName"),  // Required
		Id:     aws.String("AnalyticsId"), // Required
	}
	resp, err := svc.GetBucketAnalyticsConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketCors() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketCorsInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketCors(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketInventoryConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketInventoryConfigurationInput{
		Bucket: aws.String("BucketName"),  // Required
		Id:     aws.String("InventoryId"), // Required
	}
	resp, err := svc.GetBucketInventoryConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketLifecycle() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketLifecycleInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketLifecycle(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketLifecycleConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketLifecycleConfigurationInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketLifecycleConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketLocation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketLocationInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketLocation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketLogging() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketLoggingInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketLogging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketMetricsConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketMetricsConfigurationInput{
		Bucket: aws.String("BucketName"), // Required
		Id:     aws.String("MetricsId"),  // Required
	}
	resp, err := svc.GetBucketMetricsConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketNotification() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketNotificationConfigurationRequest{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketNotification(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketNotificationConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketNotificationConfigurationRequest{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketNotificationConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketPolicy() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketPolicyInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketReplication() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketReplicationInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketReplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketRequestPayment() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketRequestPaymentInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketRequestPayment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketTagging() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketTaggingInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketTagging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketVersioning() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketVersioningInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketVersioning(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetBucketWebsite() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetBucketWebsiteInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.GetBucketWebsite(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetObject() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetObjectInput{
		Bucket:                     aws.String("BucketName"), // Required
		Key:                        aws.String("ObjectKey"),  // Required
		IfMatch:                    aws.String("IfMatch"),
		IfModifiedSince:            aws.Time(time.Now()),
		IfNoneMatch:                aws.String("IfNoneMatch"),
		IfUnmodifiedSince:          aws.Time(time.Now()),
		PartNumber:                 aws.Int64(1),
		Range:                      aws.String("Range"),
		RequestPayer:               aws.String("RequestPayer"),
		ResponseCacheControl:       aws.String("ResponseCacheControl"),
		ResponseContentDisposition: aws.String("ResponseContentDisposition"),
		ResponseContentEncoding:    aws.String("ResponseContentEncoding"),
		ResponseContentLanguage:    aws.String("ResponseContentLanguage"),
		ResponseContentType:        aws.String("ResponseContentType"),
		ResponseExpires:            aws.Time(time.Now()),
		SSECustomerAlgorithm:       aws.String("SSECustomerAlgorithm"),
		SSECustomerKey:             aws.String("SSECustomerKey"),
		SSECustomerKeyMD5:          aws.String("SSECustomerKeyMD5"),
		VersionId:                  aws.String("ObjectVersionId"),
	}
	resp, err := svc.GetObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetObjectAcl() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetObjectAclInput{
		Bucket:       aws.String("BucketName"), // Required
		Key:          aws.String("ObjectKey"),  // Required
		RequestPayer: aws.String("RequestPayer"),
		VersionId:    aws.String("ObjectVersionId"),
	}
	resp, err := svc.GetObjectAcl(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetObjectTagging() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetObjectTaggingInput{
		Bucket:    aws.String("BucketName"), // Required
		Key:       aws.String("ObjectKey"),  // Required
		VersionId: aws.String("ObjectVersionId"),
	}
	resp, err := svc.GetObjectTagging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_GetObjectTorrent() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.GetObjectTorrentInput{
		Bucket:       aws.String("BucketName"), // Required
		Key:          aws.String("ObjectKey"),  // Required
		RequestPayer: aws.String("RequestPayer"),
	}
	resp, err := svc.GetObjectTorrent(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_HeadBucket() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.HeadBucketInput{
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.HeadBucket(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_HeadObject() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.HeadObjectInput{
		Bucket:               aws.String("BucketName"), // Required
		Key:                  aws.String("ObjectKey"),  // Required
		IfMatch:              aws.String("IfMatch"),
		IfModifiedSince:      aws.Time(time.Now()),
		IfNoneMatch:          aws.String("IfNoneMatch"),
		IfUnmodifiedSince:    aws.Time(time.Now()),
		PartNumber:           aws.Int64(1),
		Range:                aws.String("Range"),
		RequestPayer:         aws.String("RequestPayer"),
		SSECustomerAlgorithm: aws.String("SSECustomerAlgorithm"),
		SSECustomerKey:       aws.String("SSECustomerKey"),
		SSECustomerKeyMD5:    aws.String("SSECustomerKeyMD5"),
		VersionId:            aws.String("ObjectVersionId"),
	}
	resp, err := svc.HeadObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListBucketAnalyticsConfigurations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.ListBucketAnalyticsConfigurationsInput{
		Bucket:            aws.String("BucketName"), // Required
		ContinuationToken: aws.String("Token"),
	}
	resp, err := svc.ListBucketAnalyticsConfigurations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListBucketInventoryConfigurations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.ListBucketInventoryConfigurationsInput{
		Bucket:            aws.String("BucketName"), // Required
		ContinuationToken: aws.String("Token"),
	}
	resp, err := svc.ListBucketInventoryConfigurations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListBucketMetricsConfigurations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.ListBucketMetricsConfigurationsInput{
		Bucket:            aws.String("BucketName"), // Required
		ContinuationToken: aws.String("Token"),
	}
	resp, err := svc.ListBucketMetricsConfigurations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListBuckets() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	var params *s3.ListBucketsInput
	resp, err := svc.ListBuckets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListMultipartUploads() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.ListMultipartUploadsInput{
		Bucket:         aws.String("BucketName"), // Required
		Delimiter:      aws.String("Delimiter"),
		EncodingType:   aws.String("EncodingType"),
		KeyMarker:      aws.String("KeyMarker"),
		MaxUploads:     aws.Int64(1),
		Prefix:         aws.String("Prefix"),
		UploadIdMarker: aws.String("UploadIdMarker"),
	}
	resp, err := svc.ListMultipartUploads(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListObjectVersions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.ListObjectVersionsInput{
		Bucket:          aws.String("BucketName"), // Required
		Delimiter:       aws.String("Delimiter"),
		EncodingType:    aws.String("EncodingType"),
		KeyMarker:       aws.String("KeyMarker"),
		MaxKeys:         aws.Int64(1),
		Prefix:          aws.String("Prefix"),
		VersionIdMarker: aws.String("VersionIdMarker"),
	}
	resp, err := svc.ListObjectVersions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListObjects() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.ListObjectsInput{
		Bucket:       aws.String("BucketName"), // Required
		Delimiter:    aws.String("Delimiter"),
		EncodingType: aws.String("EncodingType"),
		Marker:       aws.String("Marker"),
		MaxKeys:      aws.Int64(1),
		Prefix:       aws.String("Prefix"),
		RequestPayer: aws.String("RequestPayer"),
	}
	resp, err := svc.ListObjects(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListObjectsV2() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.ListObjectsV2Input{
		Bucket:            aws.String("BucketName"), // Required
		ContinuationToken: aws.String("Token"),
		Delimiter:         aws.String("Delimiter"),
		EncodingType:      aws.String("EncodingType"),
		FetchOwner:        aws.Bool(true),
		MaxKeys:           aws.Int64(1),
		Prefix:            aws.String("Prefix"),
		RequestPayer:      aws.String("RequestPayer"),
		StartAfter:        aws.String("StartAfter"),
	}
	resp, err := svc.ListObjectsV2(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_ListParts() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.ListPartsInput{
		Bucket:           aws.String("BucketName"),        // Required
		Key:              aws.String("ObjectKey"),         // Required
		UploadId:         aws.String("MultipartUploadId"), // Required
		MaxParts:         aws.Int64(1),
		PartNumberMarker: aws.Int64(1),
		RequestPayer:     aws.String("RequestPayer"),
	}
	resp, err := svc.ListParts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketAccelerateConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketAccelerateConfigurationInput{
		AccelerateConfiguration: &s3.AccelerateConfiguration{ // Required
			Status: aws.String("BucketAccelerateStatus"),
		},
		Bucket: aws.String("BucketName"), // Required
	}
	resp, err := svc.PutBucketAccelerateConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketAcl() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketAclInput{
		Bucket: aws.String("BucketName"), // Required
		ACL:    aws.String("BucketCannedACL"),
		AccessControlPolicy: &s3.AccessControlPolicy{
			Grants: []*s3.Grant{
				{ // Required
					Grantee: &s3.Grantee{
						Type:         aws.String("Type"), // Required
						DisplayName:  aws.String("DisplayName"),
						EmailAddress: aws.String("EmailAddress"),
						ID:           aws.String("ID"),
						URI:          aws.String("URI"),
					},
					Permission: aws.String("Permission"),
				},
				// More values...
			},
			Owner: &s3.Owner{
				DisplayName: aws.String("DisplayName"),
				ID:          aws.String("ID"),
			},
		},
		GrantFullControl: aws.String("GrantFullControl"),
		GrantRead:        aws.String("GrantRead"),
		GrantReadACP:     aws.String("GrantReadACP"),
		GrantWrite:       aws.String("GrantWrite"),
		GrantWriteACP:    aws.String("GrantWriteACP"),
	}
	resp, err := svc.PutBucketAcl(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketAnalyticsConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketAnalyticsConfigurationInput{
		AnalyticsConfiguration: &s3.AnalyticsConfiguration{ // Required
			Id: aws.String("AnalyticsId"), // Required
			StorageClassAnalysis: &s3.StorageClassAnalysis{ // Required
				DataExport: &s3.StorageClassAnalysisDataExport{
					Destination: &s3.AnalyticsExportDestination{ // Required
						S3BucketDestination: &s3.AnalyticsS3BucketDestination{ // Required
							Bucket:          aws.String("BucketName"),                  // Required
							Format:          aws.String("AnalyticsS3ExportFileFormat"), // Required
							BucketAccountId: aws.String("AccountId"),
							Prefix:          aws.String("Prefix"),
						},
					},
					OutputSchemaVersion: aws.String("StorageClassAnalysisSchemaVersion"), // Required
				},
			},
			Filter: &s3.AnalyticsFilter{
				And: &s3.AnalyticsAndOperator{
					Prefix: aws.String("Prefix"),
					Tags: []*s3.Tag{
						{ // Required
							Key:   aws.String("ObjectKey"), // Required
							Value: aws.String("Value"),     // Required
						},
						// More values...
					},
				},
				Prefix: aws.String("Prefix"),
				Tag: &s3.Tag{
					Key:   aws.String("ObjectKey"), // Required
					Value: aws.String("Value"),     // Required
				},
			},
		},
		Bucket: aws.String("BucketName"),  // Required
		Id:     aws.String("AnalyticsId"), // Required
	}
	resp, err := svc.PutBucketAnalyticsConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketCors() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketCorsInput{
		Bucket: aws.String("BucketName"), // Required
		CORSConfiguration: &s3.CORSConfiguration{ // Required
			CORSRules: []*s3.CORSRule{ // Required
				{ // Required
					AllowedMethods: []*string{ // Required
						aws.String("AllowedMethod"), // Required
						// More values...
					},
					AllowedOrigins: []*string{ // Required
						aws.String("AllowedOrigin"), // Required
						// More values...
					},
					AllowedHeaders: []*string{
						aws.String("AllowedHeader"), // Required
						// More values...
					},
					ExposeHeaders: []*string{
						aws.String("ExposeHeader"), // Required
						// More values...
					},
					MaxAgeSeconds: aws.Int64(1),
				},
				// More values...
			},
		},
	}
	resp, err := svc.PutBucketCors(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketInventoryConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketInventoryConfigurationInput{
		Bucket: aws.String("BucketName"),  // Required
		Id:     aws.String("InventoryId"), // Required
		InventoryConfiguration: &s3.InventoryConfiguration{ // Required
			Destination: &s3.InventoryDestination{ // Required
				S3BucketDestination: &s3.InventoryS3BucketDestination{ // Required
					Bucket:    aws.String("BucketName"),      // Required
					Format:    aws.String("InventoryFormat"), // Required
					AccountId: aws.String("AccountId"),
					Prefix:    aws.String("Prefix"),
				},
			},
			Id: aws.String("InventoryId"), // Required
			IncludedObjectVersions: aws.String("InventoryIncludedObjectVersions"), // Required
			IsEnabled:              aws.Bool(true),                                // Required
			Schedule: &s3.InventorySchedule{ // Required
				Frequency: aws.String("InventoryFrequency"), // Required
			},
			Filter: &s3.InventoryFilter{
				Prefix: aws.String("Prefix"), // Required
			},
			OptionalFields: []*string{
				aws.String("InventoryOptionalField"), // Required
				// More values...
			},
		},
	}
	resp, err := svc.PutBucketInventoryConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketLifecycle() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketLifecycleInput{
		Bucket: aws.String("BucketName"), // Required
		LifecycleConfiguration: &s3.LifecycleConfiguration{
			Rules: []*s3.Rule{ // Required
				{ // Required
					Prefix: aws.String("Prefix"),           // Required
					Status: aws.String("ExpirationStatus"), // Required
					AbortIncompleteMultipartUpload: &s3.AbortIncompleteMultipartUpload{
						DaysAfterInitiation: aws.Int64(1),
					},
					Expiration: &s3.LifecycleExpiration{
						Date: aws.Time(time.Now()),
						Days: aws.Int64(1),
						ExpiredObjectDeleteMarker: aws.Bool(true),
					},
					ID: aws.String("ID"),
					NoncurrentVersionExpiration: &s3.NoncurrentVersionExpiration{
						NoncurrentDays: aws.Int64(1),
					},
					NoncurrentVersionTransition: &s3.NoncurrentVersionTransition{
						NoncurrentDays: aws.Int64(1),
						StorageClass:   aws.String("TransitionStorageClass"),
					},
					Transition: &s3.Transition{
						Date:         aws.Time(time.Now()),
						Days:         aws.Int64(1),
						StorageClass: aws.String("TransitionStorageClass"),
					},
				},
				// More values...
			},
		},
	}
	resp, err := svc.PutBucketLifecycle(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketLifecycleConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketLifecycleConfigurationInput{
		Bucket: aws.String("BucketName"), // Required
		LifecycleConfiguration: &s3.BucketLifecycleConfiguration{
			Rules: []*s3.LifecycleRule{ // Required
				{ // Required
					Status: aws.String("ExpirationStatus"), // Required
					AbortIncompleteMultipartUpload: &s3.AbortIncompleteMultipartUpload{
						DaysAfterInitiation: aws.Int64(1),
					},
					Expiration: &s3.LifecycleExpiration{
						Date: aws.Time(time.Now()),
						Days: aws.Int64(1),
						ExpiredObjectDeleteMarker: aws.Bool(true),
					},
					Filter: &s3.LifecycleRuleFilter{
						And: &s3.LifecycleRuleAndOperator{
							Prefix: aws.String("Prefix"),
							Tags: []*s3.Tag{
								{ // Required
									Key:   aws.String("ObjectKey"), // Required
									Value: aws.String("Value"),     // Required
								},
								// More values...
							},
						},
						Prefix: aws.String("Prefix"),
						Tag: &s3.Tag{
							Key:   aws.String("ObjectKey"), // Required
							Value: aws.String("Value"),     // Required
						},
					},
					ID: aws.String("ID"),
					NoncurrentVersionExpiration: &s3.NoncurrentVersionExpiration{
						NoncurrentDays: aws.Int64(1),
					},
					NoncurrentVersionTransitions: []*s3.NoncurrentVersionTransition{
						{ // Required
							NoncurrentDays: aws.Int64(1),
							StorageClass:   aws.String("TransitionStorageClass"),
						},
						// More values...
					},
					Prefix: aws.String("Prefix"),
					Transitions: []*s3.Transition{
						{ // Required
							Date:         aws.Time(time.Now()),
							Days:         aws.Int64(1),
							StorageClass: aws.String("TransitionStorageClass"),
						},
						// More values...
					},
				},
				// More values...
			},
		},
	}
	resp, err := svc.PutBucketLifecycleConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketLogging() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketLoggingInput{
		Bucket: aws.String("BucketName"), // Required
		BucketLoggingStatus: &s3.BucketLoggingStatus{ // Required
			LoggingEnabled: &s3.LoggingEnabled{
				TargetBucket: aws.String("TargetBucket"),
				TargetGrants: []*s3.TargetGrant{
					{ // Required
						Grantee: &s3.Grantee{
							Type:         aws.String("Type"), // Required
							DisplayName:  aws.String("DisplayName"),
							EmailAddress: aws.String("EmailAddress"),
							ID:           aws.String("ID"),
							URI:          aws.String("URI"),
						},
						Permission: aws.String("BucketLogsPermission"),
					},
					// More values...
				},
				TargetPrefix: aws.String("TargetPrefix"),
			},
		},
	}
	resp, err := svc.PutBucketLogging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketMetricsConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketMetricsConfigurationInput{
		Bucket: aws.String("BucketName"), // Required
		Id:     aws.String("MetricsId"),  // Required
		MetricsConfiguration: &s3.MetricsConfiguration{ // Required
			Id: aws.String("MetricsId"), // Required
			Filter: &s3.MetricsFilter{
				And: &s3.MetricsAndOperator{
					Prefix: aws.String("Prefix"),
					Tags: []*s3.Tag{
						{ // Required
							Key:   aws.String("ObjectKey"), // Required
							Value: aws.String("Value"),     // Required
						},
						// More values...
					},
				},
				Prefix: aws.String("Prefix"),
				Tag: &s3.Tag{
					Key:   aws.String("ObjectKey"), // Required
					Value: aws.String("Value"),     // Required
				},
			},
		},
	}
	resp, err := svc.PutBucketMetricsConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketNotification() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketNotificationInput{
		Bucket: aws.String("BucketName"), // Required
		NotificationConfiguration: &s3.NotificationConfigurationDeprecated{ // Required
			CloudFunctionConfiguration: &s3.CloudFunctionConfiguration{
				CloudFunction: aws.String("CloudFunction"),
				Event:         aws.String("Event"),
				Events: []*string{
					aws.String("Event"), // Required
					// More values...
				},
				Id:             aws.String("NotificationId"),
				InvocationRole: aws.String("CloudFunctionInvocationRole"),
			},
			QueueConfiguration: &s3.QueueConfigurationDeprecated{
				Event: aws.String("Event"),
				Events: []*string{
					aws.String("Event"), // Required
					// More values...
				},
				Id:    aws.String("NotificationId"),
				Queue: aws.String("QueueArn"),
			},
			TopicConfiguration: &s3.TopicConfigurationDeprecated{
				Event: aws.String("Event"),
				Events: []*string{
					aws.String("Event"), // Required
					// More values...
				},
				Id:    aws.String("NotificationId"),
				Topic: aws.String("TopicArn"),
			},
		},
	}
	resp, err := svc.PutBucketNotification(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketNotificationConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketNotificationConfigurationInput{
		Bucket: aws.String("BucketName"), // Required
		NotificationConfiguration: &s3.NotificationConfiguration{ // Required
			LambdaFunctionConfigurations: []*s3.LambdaFunctionConfiguration{
				{ // Required
					Events: []*string{ // Required
						aws.String("Event"), // Required
						// More values...
					},
					LambdaFunctionArn: aws.String("LambdaFunctionArn"), // Required
					Filter: &s3.NotificationConfigurationFilter{
						Key: &s3.KeyFilter{
							FilterRules: []*s3.FilterRule{
								{ // Required
									Name:  aws.String("FilterRuleName"),
									Value: aws.String("FilterRuleValue"),
								},
								// More values...
							},
						},
					},
					Id: aws.String("NotificationId"),
				},
				// More values...
			},
			QueueConfigurations: []*s3.QueueConfiguration{
				{ // Required
					Events: []*string{ // Required
						aws.String("Event"), // Required
						// More values...
					},
					QueueArn: aws.String("QueueArn"), // Required
					Filter: &s3.NotificationConfigurationFilter{
						Key: &s3.KeyFilter{
							FilterRules: []*s3.FilterRule{
								{ // Required
									Name:  aws.String("FilterRuleName"),
									Value: aws.String("FilterRuleValue"),
								},
								// More values...
							},
						},
					},
					Id: aws.String("NotificationId"),
				},
				// More values...
			},
			TopicConfigurations: []*s3.TopicConfiguration{
				{ // Required
					Events: []*string{ // Required
						aws.String("Event"), // Required
						// More values...
					},
					TopicArn: aws.String("TopicArn"), // Required
					Filter: &s3.NotificationConfigurationFilter{
						Key: &s3.KeyFilter{
							FilterRules: []*s3.FilterRule{
								{ // Required
									Name:  aws.String("FilterRuleName"),
									Value: aws.String("FilterRuleValue"),
								},
								// More values...
							},
						},
					},
					Id: aws.String("NotificationId"),
				},
				// More values...
			},
		},
	}
	resp, err := svc.PutBucketNotificationConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketPolicy() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketPolicyInput{
		Bucket: aws.String("BucketName"), // Required
		Policy: aws.String("Policy"),     // Required
	}
	resp, err := svc.PutBucketPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketReplication() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketReplicationInput{
		Bucket: aws.String("BucketName"), // Required
		ReplicationConfiguration: &s3.ReplicationConfiguration{ // Required
			Role: aws.String("Role"), // Required
			Rules: []*s3.ReplicationRule{ // Required
				{ // Required
					Destination: &s3.Destination{ // Required
						Bucket:       aws.String("BucketName"), // Required
						StorageClass: aws.String("StorageClass"),
					},
					Prefix: aws.String("Prefix"),                // Required
					Status: aws.String("ReplicationRuleStatus"), // Required
					ID:     aws.String("ID"),
				},
				// More values...
			},
		},
	}
	resp, err := svc.PutBucketReplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketRequestPayment() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketRequestPaymentInput{
		Bucket: aws.String("BucketName"), // Required
		RequestPaymentConfiguration: &s3.RequestPaymentConfiguration{ // Required
			Payer: aws.String("Payer"), // Required
		},
	}
	resp, err := svc.PutBucketRequestPayment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketTagging() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketTaggingInput{
		Bucket: aws.String("BucketName"), // Required
		Tagging: &s3.Tagging{ // Required
			TagSet: []*s3.Tag{ // Required
				{ // Required
					Key:   aws.String("ObjectKey"), // Required
					Value: aws.String("Value"),     // Required
				},
				// More values...
			},
		},
	}
	resp, err := svc.PutBucketTagging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketVersioning() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketVersioningInput{
		Bucket: aws.String("BucketName"), // Required
		VersioningConfiguration: &s3.VersioningConfiguration{ // Required
			MFADelete: aws.String("MFADelete"),
			Status:    aws.String("BucketVersioningStatus"),
		},
		MFA: aws.String("MFA"),
	}
	resp, err := svc.PutBucketVersioning(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutBucketWebsite() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutBucketWebsiteInput{
		Bucket: aws.String("BucketName"), // Required
		WebsiteConfiguration: &s3.WebsiteConfiguration{ // Required
			ErrorDocument: &s3.ErrorDocument{
				Key: aws.String("ObjectKey"), // Required
			},
			IndexDocument: &s3.IndexDocument{
				Suffix: aws.String("Suffix"), // Required
			},
			RedirectAllRequestsTo: &s3.RedirectAllRequestsTo{
				HostName: aws.String("HostName"), // Required
				Protocol: aws.String("Protocol"),
			},
			RoutingRules: []*s3.RoutingRule{
				{ // Required
					Redirect: &s3.Redirect{ // Required
						HostName:             aws.String("HostName"),
						HttpRedirectCode:     aws.String("HttpRedirectCode"),
						Protocol:             aws.String("Protocol"),
						ReplaceKeyPrefixWith: aws.String("ReplaceKeyPrefixWith"),
						ReplaceKeyWith:       aws.String("ReplaceKeyWith"),
					},
					Condition: &s3.Condition{
						HttpErrorCodeReturnedEquals: aws.String("HttpErrorCodeReturnedEquals"),
						KeyPrefixEquals:             aws.String("KeyPrefixEquals"),
					},
				},
				// More values...
			},
		},
	}
	resp, err := svc.PutBucketWebsite(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutObject() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutObjectInput{
		Bucket:             aws.String("BucketName"), // Required
		Key:                aws.String("ObjectKey"),  // Required
		ACL:                aws.String("ObjectCannedACL"),
		Body:               bytes.NewReader([]byte("PAYLOAD")),
		CacheControl:       aws.String("CacheControl"),
		ContentDisposition: aws.String("ContentDisposition"),
		ContentEncoding:    aws.String("ContentEncoding"),
		ContentLanguage:    aws.String("ContentLanguage"),
		ContentLength:      aws.Int64(1),
		ContentType:        aws.String("ContentType"),
		Expires:            aws.Time(time.Now()),
		GrantFullControl:   aws.String("GrantFullControl"),
		GrantRead:          aws.String("GrantRead"),
		GrantReadACP:       aws.String("GrantReadACP"),
		GrantWriteACP:      aws.String("GrantWriteACP"),
		Metadata: map[string]*string{
			"Key": aws.String("MetadataValue"), // Required
			// More values...
		},
		RequestPayer:            aws.String("RequestPayer"),
		SSECustomerAlgorithm:    aws.String("SSECustomerAlgorithm"),
		SSECustomerKey:          aws.String("SSECustomerKey"),
		SSECustomerKeyMD5:       aws.String("SSECustomerKeyMD5"),
		SSEKMSKeyId:             aws.String("SSEKMSKeyId"),
		ServerSideEncryption:    aws.String("ServerSideEncryption"),
		StorageClass:            aws.String("StorageClass"),
		Tagging:                 aws.String("TaggingHeader"),
		WebsiteRedirectLocation: aws.String("WebsiteRedirectLocation"),
	}
	resp, err := svc.PutObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutObjectAcl() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutObjectAclInput{
		Bucket: aws.String("BucketName"), // Required
		Key:    aws.String("ObjectKey"),  // Required
		ACL:    aws.String("ObjectCannedACL"),
		AccessControlPolicy: &s3.AccessControlPolicy{
			Grants: []*s3.Grant{
				{ // Required
					Grantee: &s3.Grantee{
						Type:         aws.String("Type"), // Required
						DisplayName:  aws.String("DisplayName"),
						EmailAddress: aws.String("EmailAddress"),
						ID:           aws.String("ID"),
						URI:          aws.String("URI"),
					},
					Permission: aws.String("Permission"),
				},
				// More values...
			},
			Owner: &s3.Owner{
				DisplayName: aws.String("DisplayName"),
				ID:          aws.String("ID"),
			},
		},
		GrantFullControl: aws.String("GrantFullControl"),
		GrantRead:        aws.String("GrantRead"),
		GrantReadACP:     aws.String("GrantReadACP"),
		GrantWrite:       aws.String("GrantWrite"),
		GrantWriteACP:    aws.String("GrantWriteACP"),
		RequestPayer:     aws.String("RequestPayer"),
		VersionId:        aws.String("ObjectVersionId"),
	}
	resp, err := svc.PutObjectAcl(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_PutObjectTagging() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.PutObjectTaggingInput{
		Bucket: aws.String("BucketName"), // Required
		Key:    aws.String("ObjectKey"),  // Required
		Tagging: &s3.Tagging{ // Required
			TagSet: []*s3.Tag{ // Required
				{ // Required
					Key:   aws.String("ObjectKey"), // Required
					Value: aws.String("Value"),     // Required
				},
				// More values...
			},
		},
		VersionId: aws.String("ObjectVersionId"),
	}
	resp, err := svc.PutObjectTagging(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_RestoreObject() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.RestoreObjectInput{
		Bucket:       aws.String("BucketName"), // Required
		Key:          aws.String("ObjectKey"),  // Required
		RequestPayer: aws.String("RequestPayer"),
		RestoreRequest: &s3.RestoreRequest{
			Days: aws.Int64(1), // Required
			GlacierJobParameters: &s3.GlacierJobParameters{
				Tier: aws.String("Tier"), // Required
			},
		},
		VersionId: aws.String("ObjectVersionId"),
	}
	resp, err := svc.RestoreObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_UploadPart() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.UploadPartInput{
		Bucket:               aws.String("BucketName"),        // Required
		Key:                  aws.String("ObjectKey"),         // Required
		PartNumber:           aws.Int64(1),                    // Required
		UploadId:             aws.String("MultipartUploadId"), // Required
		Body:                 bytes.NewReader([]byte("PAYLOAD")),
		ContentLength:        aws.Int64(1),
		RequestPayer:         aws.String("RequestPayer"),
		SSECustomerAlgorithm: aws.String("SSECustomerAlgorithm"),
		SSECustomerKey:       aws.String("SSECustomerKey"),
		SSECustomerKeyMD5:    aws.String("SSECustomerKeyMD5"),
	}
	resp, err := svc.UploadPart(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleS3_UploadPartCopy() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := s3.New(sess)

	params := &s3.UploadPartCopyInput{
		Bucket:                         aws.String("BucketName"),        // Required
		CopySource:                     aws.String("CopySource"),        // Required
		Key:                            aws.String("ObjectKey"),         // Required
		PartNumber:                     aws.Int64(1),                    // Required
		UploadId:                       aws.String("MultipartUploadId"), // Required
		CopySourceIfMatch:              aws.String("CopySourceIfMatch"),
		CopySourceIfModifiedSince:      aws.Time(time.Now()),
		CopySourceIfNoneMatch:          aws.String("CopySourceIfNoneMatch"),
		CopySourceIfUnmodifiedSince:    aws.Time(time.Now()),
		CopySourceRange:                aws.String("CopySourceRange"),
		CopySourceSSECustomerAlgorithm: aws.String("CopySourceSSECustomerAlgorithm"),
		CopySourceSSECustomerKey:       aws.String("CopySourceSSECustomerKey"),
		CopySourceSSECustomerKeyMD5:    aws.String("CopySourceSSECustomerKeyMD5"),
		RequestPayer:                   aws.String("RequestPayer"),
		SSECustomerAlgorithm:           aws.String("SSECustomerAlgorithm"),
		SSECustomerKey:                 aws.String("SSECustomerKey"),
		SSECustomerKeyMD5:              aws.String("SSECustomerKeyMD5"),
	}
	resp, err := svc.UploadPartCopy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
