/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul 30 16:39:33 EDT 2016 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_notw_c.native -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -sign 1 -n 128 -name n1bv_128 -include n1b.h */

/*
 * This function contains 1082 FP additions, 642 FP multiplications,
 * (or, 440 additions, 0 multiplications, 642 fused multiply/add),
 * 295 stack variables, 31 constants, and 256 memory accesses
 */
#include "n1b.h"

static void n1bv_128(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP903989293, +0.903989293123443331586200297230537048710132025);
     DVK(KP941544065, +0.941544065183020778412509402599502357185589796);
     DVK(KP357805721, +0.357805721314524104672487743774474392487532769);
     DVK(KP472964775, +0.472964775891319928124438237972992463904131113);
     DVK(KP857728610, +0.857728610000272069902269984284770137042490799);
     DVK(KP970031253, +0.970031253194543992603984207286100251456865962);
     DVK(KP250486960, +0.250486960191305461595702160124721208578685568);
     DVK(KP998795456, +0.998795456205172392714771604759100694443203615);
     DVK(KP740951125, +0.740951125354959091175616897495162729728955309);
     DVK(KP599376933, +0.599376933681923766271389869014404232837890546);
     DVK(KP906347169, +0.906347169019147157946142717268914412664134293);
     DVK(KP049126849, +0.049126849769467254105343321271313617079695752);
     DVK(KP989176509, +0.989176509964780973451673738016243063983689533);
     DVK(KP803207531, +0.803207531480644909806676512963141923879569427);
     DVK(KP741650546, +0.741650546272035369581266691172079863842265220);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP148335987, +0.148335987538347428753676511486911367000625355);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DVK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DVK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DVK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  const R *xi;
	  R *xo;
	  xi = ii;
	  xo = io;
	  for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs), MAKE_VOLATILE_STRIDE(256, is), MAKE_VOLATILE_STRIDE(256, os)) {
	       V T6a, T5J, T6b, T5K, T6B, T6C, T6J, T6A, T6o, T6j, T6r, T68, T6d, T5O, T5R;
	       V T6e, T6D, T6K;
	       {
		    V Tad, TcZ, T6Z, T8T, T4U, Tr, Tfq, TgG, Ted, Tgf, Td0, Tcc, T9k, T84, Tb6;
		    V Tbt, Td8, TdK, TeK, Tgq, TeV, Tgt, T7q, T94, T3p, T5X, T7B, T97, T2G, T5U;
		    V TbD, Tc0, Tdf, TdN, Tf5, Tgx, Tfg, TgA, T7J, T9b, T4E, T64, T7U, T9e, T3V;
		    V T61, Td2, Td3, T85, T72, T4V, TI, Tcd, Tas, TgH, Tek, Tgg, Tft, T86, T75;
		    V T4W, TZ, TaI, Tcf, Tdo, TdG, Tgi, Tet, Tgj, Teq, T8X, T7a, T5M, T1B, T8W;
		    V T7d, T5N, T1s, TaX, Tcg, Tdr, TdH, Tgl, TeC, Tgm, Tez, T90, T7h, T5P, T2c;
		    V T8Z, T7k, T5Q, T23, T3Y, T49, TdL, Tdb, Tbu, Tbl, Tgu, TeR, Tgr, TeY, Tf6;
		    V TbG, T5V, T3s, T5Y, T3f, T95, T7E, T98, T7x, T4g, T4f, T4q, TbH, T41, TbI;
		    V T44, T4h, T4j, T4k, Tf9, TbN;
		    {
			 V Tu, TF, Ty, TL, TW, Tah, Tx, Tag, Tee, Tz, TM, TN, Teh, Tan, TP;
			 V TQ;
			 {
			      V TeG, T2A, Tbq, TeT, Tbp, TeH, T3m, T2x, Td6, T7o, T2q, T3l, T7z, Tbr, T2D;
			      V T82, T83;
			      {
				   V Ta7, T3, Ta8, T4O, Taa, Tab, Ta, T4P, Te, Tc6, Th, Tc7, Tl, Tc9, Tca;
				   V To;
				   {
					V T1, T2, T4M, T4N;
					T1 = LD(&(xi[0]), ivs, &(xi[0]));
					T2 = LD(&(xi[WS(is, 64)]), ivs, &(xi[0]));
					T4M = LD(&(xi[WS(is, 32)]), ivs, &(xi[0]));
					T4N = LD(&(xi[WS(is, 96)]), ivs, &(xi[0]));
					{
					     V T4, T5, T7, T8;
					     T4 = LD(&(xi[WS(is, 16)]), ivs, &(xi[0]));
					     T5 = LD(&(xi[WS(is, 80)]), ivs, &(xi[0]));
					     T7 = LD(&(xi[WS(is, 112)]), ivs, &(xi[0]));
					     T8 = LD(&(xi[WS(is, 48)]), ivs, &(xi[0]));
					     {
						  V Tc, T6, T9, Td, Tf, Tg;
						  Tc = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
						  Ta7 = VADD(T1, T2);
						  T3 = VSUB(T1, T2);
						  Ta8 = VADD(T4M, T4N);
						  T4O = VSUB(T4M, T4N);
						  Taa = VADD(T4, T5);
						  T6 = VSUB(T4, T5);
						  Tab = VADD(T7, T8);
						  T9 = VSUB(T7, T8);
						  Td = LD(&(xi[WS(is, 72)]), ivs, &(xi[0]));
						  Tf = LD(&(xi[WS(is, 40)]), ivs, &(xi[0]));
						  Tg = LD(&(xi[WS(is, 104)]), ivs, &(xi[0]));
						  {
						       V Tj, Tk, Tm, Tn;
						       Tj = LD(&(xi[WS(is, 120)]), ivs, &(xi[0]));
						       Tk = LD(&(xi[WS(is, 56)]), ivs, &(xi[0]));
						       Tm = LD(&(xi[WS(is, 88)]), ivs, &(xi[0]));
						       Tn = LD(&(xi[WS(is, 24)]), ivs, &(xi[0]));
						       Ta = VADD(T6, T9);
						       T4P = VSUB(T6, T9);
						       Te = VSUB(Tc, Td);
						       Tc6 = VADD(Tc, Td);
						       Th = VSUB(Tf, Tg);
						       Tc7 = VADD(Tf, Tg);
						       Tl = VSUB(Tj, Tk);
						       Tc9 = VADD(Tj, Tk);
						       Tca = VADD(Tn, Tm);
						       To = VSUB(Tm, Tn);
						  }
					     }
					}
				   }
				   {
					V T6X, Tb, Te9, Ta9, Tc8, Tea, T4R, Ti, Tfo, Tac, Tp, T4S, Tcb, Teb, T4Q;
					T6X = VFNMS(LDK(KP707106781), Ta, T3);
					Tb = VFMA(LDK(KP707106781), Ta, T3);
					Te9 = VSUB(Ta7, Ta8);
					Ta9 = VADD(Ta7, Ta8);
					Tc8 = VADD(Tc6, Tc7);
					Tea = VSUB(Tc6, Tc7);
					T4R = VFMA(LDK(KP414213562), Te, Th);
					Ti = VFNMS(LDK(KP414213562), Th, Te);
					Tfo = VSUB(Taa, Tab);
					Tac = VADD(Taa, Tab);
					Tp = VFNMS(LDK(KP414213562), To, Tl);
					T4S = VFMA(LDK(KP414213562), Tl, To);
					Tcb = VADD(Tc9, Tca);
					Teb = VSUB(Tc9, Tca);
					T4Q = VFMA(LDK(KP707106781), T4P, T4O);
					T82 = VFNMS(LDK(KP707106781), T4P, T4O);
					{
					     V T4T, T6Y, Tq, Tfp, Tec;
					     T4T = VSUB(T4R, T4S);
					     T6Y = VADD(T4R, T4S);
					     T83 = VSUB(Ti, Tp);
					     Tq = VADD(Ti, Tp);
					     Tfp = VSUB(Tea, Teb);
					     Tec = VADD(Tea, Teb);
					     Tad = VSUB(Ta9, Tac);
					     TcZ = VADD(Ta9, Tac);
					     T6Z = VFMA(LDK(KP923879532), T6Y, T6X);
					     T8T = VFNMS(LDK(KP923879532), T6Y, T6X);
					     T4U = VFMA(LDK(KP923879532), T4T, T4Q);
					     T6a = VFNMS(LDK(KP923879532), T4T, T4Q);
					     Tr = VFMA(LDK(KP923879532), Tq, Tb);
					     T5J = VFNMS(LDK(KP923879532), Tq, Tb);
					     Tfq = VFMA(LDK(KP707106781), Tfp, Tfo);
					     TgG = VFNMS(LDK(KP707106781), Tfp, Tfo);
					     Ted = VFMA(LDK(KP707106781), Tec, Te9);
					     Tgf = VFNMS(LDK(KP707106781), Tec, Te9);
					     Td0 = VADD(Tc8, Tcb);
					     Tcc = VSUB(Tc8, Tcb);
					}
				   }
			      }
			      {
				   V T2i, T3j, Tb2, T2B, Tb5, T3k, T2p, T2C;
				   {
					V T2m, Tb0, Tb1, Tb3, T2l, T2n;
					{
					     V T2g, T2h, T3h, T3i, T2j, T2k;
					     T2g = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
					     T2h = LD(&(xi[WS(is, 65)]), ivs, &(xi[WS(is, 1)]));
					     T3h = LD(&(xi[WS(is, 33)]), ivs, &(xi[WS(is, 1)]));
					     T3i = LD(&(xi[WS(is, 97)]), ivs, &(xi[WS(is, 1)]));
					     T2j = LD(&(xi[WS(is, 17)]), ivs, &(xi[WS(is, 1)]));
					     T2k = LD(&(xi[WS(is, 81)]), ivs, &(xi[WS(is, 1)]));
					     T2m = LD(&(xi[WS(is, 113)]), ivs, &(xi[WS(is, 1)]));
					     T9k = VFMA(LDK(KP923879532), T83, T82);
					     T84 = VFNMS(LDK(KP923879532), T83, T82);
					     T2i = VSUB(T2g, T2h);
					     Tb0 = VADD(T2g, T2h);
					     T3j = VSUB(T3h, T3i);
					     Tb1 = VADD(T3h, T3i);
					     Tb3 = VADD(T2j, T2k);
					     T2l = VSUB(T2j, T2k);
					     T2n = LD(&(xi[WS(is, 49)]), ivs, &(xi[WS(is, 1)]));
					}
					{
					     V T2r, T2s, T2u, T2v;
					     T2r = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
					     T2s = LD(&(xi[WS(is, 73)]), ivs, &(xi[WS(is, 1)]));
					     T2u = LD(&(xi[WS(is, 41)]), ivs, &(xi[WS(is, 1)]));
					     T2v = LD(&(xi[WS(is, 105)]), ivs, &(xi[WS(is, 1)]));
					     TeG = VSUB(Tb0, Tb1);
					     Tb2 = VADD(Tb0, Tb1);
					     {
						  V T2y, T2z, Tb4, T2o, Tbn, T2t, Tbo, T2w;
						  T2y = LD(&(xi[WS(is, 121)]), ivs, &(xi[WS(is, 1)]));
						  T2z = LD(&(xi[WS(is, 57)]), ivs, &(xi[WS(is, 1)]));
						  Tb4 = VADD(T2m, T2n);
						  T2o = VSUB(T2m, T2n);
						  Tbn = VADD(T2r, T2s);
						  T2t = VSUB(T2r, T2s);
						  Tbo = VADD(T2u, T2v);
						  T2w = VSUB(T2u, T2v);
						  T2B = LD(&(xi[WS(is, 25)]), ivs, &(xi[WS(is, 1)]));
						  T2A = VSUB(T2y, T2z);
						  Tbq = VADD(T2y, T2z);
						  TeT = VSUB(Tb3, Tb4);
						  Tb5 = VADD(Tb3, Tb4);
						  T3k = VSUB(T2l, T2o);
						  T2p = VADD(T2l, T2o);
						  Tbp = VADD(Tbn, Tbo);
						  TeH = VSUB(Tbn, Tbo);
						  T3m = VFMA(LDK(KP414213562), T2t, T2w);
						  T2x = VFNMS(LDK(KP414213562), T2w, T2t);
						  T2C = LD(&(xi[WS(is, 89)]), ivs, &(xi[WS(is, 1)]));
					     }
					}
				   }
				   Td6 = VADD(Tb2, Tb5);
				   Tb6 = VSUB(Tb2, Tb5);
				   T7o = VFNMS(LDK(KP707106781), T2p, T2i);
				   T2q = VFMA(LDK(KP707106781), T2p, T2i);
				   T3l = VFMA(LDK(KP707106781), T3k, T3j);
				   T7z = VFNMS(LDK(KP707106781), T3k, T3j);
				   Tbr = VADD(T2B, T2C);
				   T2D = VSUB(T2B, T2C);
			      }
			      {
				   V Tf1, Tfe, Tf2, TbZ, T3M, T4B, Tdd, T3F, T7H, T4A, T7S, TbW, Tf3, T4C, T3T;
				   {
					V T3x, T4y, Tbz, T3Q, TbC, T4z, T3E, T3R, T3P, TbU, TbV, T3S;
					{
					     V T3y, T3z, T3B, T3C;
					     {
						  V T3v, T3w, T4w, T4x;
						  T3v = LD(&(xi[WS(is, 127)]), ivs, &(xi[WS(is, 1)]));
						  T3w = LD(&(xi[WS(is, 63)]), ivs, &(xi[WS(is, 1)]));
						  T4w = LD(&(xi[WS(is, 95)]), ivs, &(xi[WS(is, 1)]));
						  T4x = LD(&(xi[WS(is, 31)]), ivs, &(xi[WS(is, 1)]));
						  T3y = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
						  {
						       V Tbs, TeI, T3n, T2E, Tbx;
						       Tbs = VADD(Tbq, Tbr);
						       TeI = VSUB(Tbq, Tbr);
						       T3n = VFNMS(LDK(KP414213562), T2A, T2D);
						       T2E = VFMA(LDK(KP414213562), T2D, T2A);
						       T3x = VSUB(T3v, T3w);
						       Tbx = VADD(T3v, T3w);
						       {
							    V Tby, Td7, TeJ, TeU;
							    T4y = VSUB(T4w, T4x);
							    Tby = VADD(T4x, T4w);
							    Td7 = VADD(Tbp, Tbs);
							    Tbt = VSUB(Tbp, Tbs);
							    TeJ = VADD(TeH, TeI);
							    TeU = VSUB(TeH, TeI);
							    {
								 V T7p, T3o, T7A, T2F;
								 T7p = VSUB(T3m, T3n);
								 T3o = VADD(T3m, T3n);
								 T7A = VSUB(T2x, T2E);
								 T2F = VADD(T2x, T2E);
								 Tbz = VADD(Tbx, Tby);
								 Tf1 = VSUB(Tbx, Tby);
								 Td8 = VADD(Td6, Td7);
								 TdK = VSUB(Td6, Td7);
								 TeK = VFMA(LDK(KP707106781), TeJ, TeG);
								 Tgq = VFNMS(LDK(KP707106781), TeJ, TeG);
								 TeV = VFMA(LDK(KP707106781), TeU, TeT);
								 Tgt = VFNMS(LDK(KP707106781), TeU, TeT);
								 T7q = VFMA(LDK(KP923879532), T7p, T7o);
								 T94 = VFNMS(LDK(KP923879532), T7p, T7o);
								 T3p = VFMA(LDK(KP923879532), T3o, T3l);
								 T5X = VFNMS(LDK(KP923879532), T3o, T3l);
								 T7B = VFNMS(LDK(KP923879532), T7A, T7z);
								 T97 = VFMA(LDK(KP923879532), T7A, T7z);
								 T2G = VFMA(LDK(KP923879532), T2F, T2q);
								 T5U = VFNMS(LDK(KP923879532), T2F, T2q);
								 T3z = LD(&(xi[WS(is, 79)]), ivs, &(xi[WS(is, 1)]));
							    }
						       }
						  }
						  T3B = LD(&(xi[WS(is, 111)]), ivs, &(xi[WS(is, 1)]));
						  T3C = LD(&(xi[WS(is, 47)]), ivs, &(xi[WS(is, 1)]));
					     }
					     {
						  V T3G, T3H, T3J, T3K;
						  T3G = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
						  T3H = LD(&(xi[WS(is, 71)]), ivs, &(xi[WS(is, 1)]));
						  T3J = LD(&(xi[WS(is, 103)]), ivs, &(xi[WS(is, 1)]));
						  T3K = LD(&(xi[WS(is, 39)]), ivs, &(xi[WS(is, 1)]));
						  {
						       V T3N, T3A, TbA, T3D, TbB, T3I, TbX, T3L, TbY, T3O;
						       T3N = LD(&(xi[WS(is, 119)]), ivs, &(xi[WS(is, 1)]));
						       T3A = VSUB(T3y, T3z);
						       TbA = VADD(T3y, T3z);
						       T3D = VSUB(T3B, T3C);
						       TbB = VADD(T3B, T3C);
						       T3I = VSUB(T3G, T3H);
						       TbX = VADD(T3G, T3H);
						       T3L = VSUB(T3J, T3K);
						       TbY = VADD(T3K, T3J);
						       T3O = LD(&(xi[WS(is, 55)]), ivs, &(xi[WS(is, 1)]));
						       T3Q = LD(&(xi[WS(is, 87)]), ivs, &(xi[WS(is, 1)]));
						       Tfe = VSUB(TbB, TbA);
						       TbC = VADD(TbA, TbB);
						       T4z = VSUB(T3D, T3A);
						       T3E = VADD(T3A, T3D);
						       T3R = LD(&(xi[WS(is, 23)]), ivs, &(xi[WS(is, 1)]));
						       Tf2 = VSUB(TbX, TbY);
						       TbZ = VADD(TbX, TbY);
						       T3M = VFMA(LDK(KP414213562), T3L, T3I);
						       T4B = VFNMS(LDK(KP414213562), T3I, T3L);
						       T3P = VSUB(T3N, T3O);
						       TbU = VADD(T3N, T3O);
						  }
					     }
					}
					Tdd = VADD(Tbz, TbC);
					TbD = VSUB(Tbz, TbC);
					TbV = VADD(T3R, T3Q);
					T3S = VSUB(T3Q, T3R);
					T3F = VFMA(LDK(KP707106781), T3E, T3x);
					T7H = VFNMS(LDK(KP707106781), T3E, T3x);
					T4A = VFMA(LDK(KP707106781), T4z, T4y);
					T7S = VFNMS(LDK(KP707106781), T4z, T4y);
					TbW = VADD(TbU, TbV);
					Tf3 = VSUB(TbU, TbV);
					T4C = VFMA(LDK(KP414213562), T3P, T3S);
					T3T = VFNMS(LDK(KP414213562), T3S, T3P);
				   }
				   {
					V TD, Tae, TE, TJ, TK, TU, TV;
					{
					     V Ts, Tt, Tde, Tf4, Tff;
					     Ts = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
					     Tt = LD(&(xi[WS(is, 68)]), ivs, &(xi[0]));
					     TD = LD(&(xi[WS(is, 36)]), ivs, &(xi[0]));
					     Tde = VADD(TbZ, TbW);
					     Tc0 = VSUB(TbW, TbZ);
					     Tf4 = VADD(Tf2, Tf3);
					     Tff = VSUB(Tf3, Tf2);
					     {
						  V T7I, T4D, T7T, T3U;
						  T7I = VSUB(T4C, T4B);
						  T4D = VADD(T4B, T4C);
						  T7T = VSUB(T3T, T3M);
						  T3U = VADD(T3M, T3T);
						  Tae = VADD(Ts, Tt);
						  Tu = VSUB(Ts, Tt);
						  Tdf = VADD(Tdd, Tde);
						  TdN = VSUB(Tdd, Tde);
						  Tf5 = VFMA(LDK(KP707106781), Tf4, Tf1);
						  Tgx = VFNMS(LDK(KP707106781), Tf4, Tf1);
						  Tfg = VFMA(LDK(KP707106781), Tff, Tfe);
						  TgA = VFNMS(LDK(KP707106781), Tff, Tfe);
						  T7J = VFMA(LDK(KP923879532), T7I, T7H);
						  T9b = VFNMS(LDK(KP923879532), T7I, T7H);
						  T4E = VFMA(LDK(KP923879532), T4D, T4A);
						  T64 = VFNMS(LDK(KP923879532), T4D, T4A);
						  T7U = VFNMS(LDK(KP923879532), T7T, T7S);
						  T9e = VFMA(LDK(KP923879532), T7T, T7S);
						  T3V = VFMA(LDK(KP923879532), T3U, T3F);
						  T61 = VFNMS(LDK(KP923879532), T3U, T3F);
						  TE = LD(&(xi[WS(is, 100)]), ivs, &(xi[0]));
					     }
					}
					TJ = LD(&(xi[WS(is, 124)]), ivs, &(xi[0]));
					TK = LD(&(xi[WS(is, 60)]), ivs, &(xi[0]));
					TU = LD(&(xi[WS(is, 92)]), ivs, &(xi[0]));
					TV = LD(&(xi[WS(is, 28)]), ivs, &(xi[0]));
					{
					     V Tal, Tam, Tv, Tw, Taf;
					     Tv = LD(&(xi[WS(is, 20)]), ivs, &(xi[0]));
					     Tw = LD(&(xi[WS(is, 84)]), ivs, &(xi[0]));
					     Taf = VADD(TD, TE);
					     TF = VSUB(TD, TE);
					     Ty = LD(&(xi[WS(is, 116)]), ivs, &(xi[0]));
					     TL = VSUB(TJ, TK);
					     Tal = VADD(TJ, TK);
					     TW = VSUB(TU, TV);
					     Tam = VADD(TV, TU);
					     Tah = VADD(Tv, Tw);
					     Tx = VSUB(Tv, Tw);
					     Tag = VADD(Tae, Taf);
					     Tee = VSUB(Tae, Taf);
					     Tz = LD(&(xi[WS(is, 52)]), ivs, &(xi[0]));
					     TM = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
					     TN = LD(&(xi[WS(is, 76)]), ivs, &(xi[0]));
					     Teh = VSUB(Tal, Tam);
					     Tan = VADD(Tal, Tam);
					     TP = LD(&(xi[WS(is, 108)]), ivs, &(xi[0]));
					     TQ = LD(&(xi[WS(is, 44)]), ivs, &(xi[0]));
					}
				   }
			      }
			 }
			 {
			      V Tev, TeA, Tdp, TaP, Tew, TaV, T1U, T29, T7f, T1N, T28, T7i, Tex, TaS, T21;
			      V T2a;
			      {
				   V Tem, Ter, Ten, TaD, T1j, T1y, TaA, Tdm, T1c, T78, T7b, T1x, TaG, Teo, T1z;
				   V T1q;
				   {
					V T14, T1v, Taw, Taz, T1b, T1w, T1n, T1o, T1m, TaE, TaF, T1p;
					{
					     V Tau, Tav, T15, T16, T18, T19;
					     {
						  V T12, Tai, TA, Tao, TO, T13;
						  T12 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
						  Tai = VADD(Ty, Tz);
						  TA = VSUB(Ty, Tz);
						  Tao = VADD(TM, TN);
						  TO = VSUB(TM, TN);
						  T13 = LD(&(xi[WS(is, 66)]), ivs, &(xi[0]));
						  {
						       V T1t, Tap, TR, Taj, Tef, TG, TB, T1u;
						       T1t = LD(&(xi[WS(is, 34)]), ivs, &(xi[0]));
						       Tap = VADD(TP, TQ);
						       TR = VSUB(TP, TQ);
						       Taj = VADD(Tah, Tai);
						       Tef = VSUB(Tah, Tai);
						       TG = VSUB(Tx, TA);
						       TB = VADD(Tx, TA);
						       Tau = VADD(T12, T13);
						       T14 = VSUB(T12, T13);
						       T1u = LD(&(xi[WS(is, 98)]), ivs, &(xi[0]));
						       {
							    V Taq, Tei, TX, TS, Tak;
							    Taq = VADD(Tao, Tap);
							    Tei = VSUB(Tap, Tao);
							    TX = VSUB(TR, TO);
							    TS = VADD(TO, TR);
							    Tak = VSUB(Tag, Taj);
							    Td2 = VADD(Tag, Taj);
							    {
								 V Teg, Tfr, T71, TH;
								 Teg = VFNMS(LDK(KP414213562), Tef, Tee);
								 Tfr = VFMA(LDK(KP414213562), Tee, Tef);
								 T71 = VFNMS(LDK(KP707106781), TG, TF);
								 TH = VFMA(LDK(KP707106781), TG, TF);
								 {
								      V T70, TC, Tar, Tej, Tfs;
								      T70 = VFNMS(LDK(KP707106781), TB, Tu);
								      TC = VFMA(LDK(KP707106781), TB, Tu);
								      Tar = VSUB(Tan, Taq);
								      Td3 = VADD(Tan, Taq);
								      Tej = VFNMS(LDK(KP414213562), Tei, Teh);
								      Tfs = VFMA(LDK(KP414213562), Teh, Tei);
								      {
									   V T74, TY, T73, TT;
									   T74 = VFNMS(LDK(KP707106781), TX, TW);
									   TY = VFMA(LDK(KP707106781), TX, TW);
									   T73 = VFNMS(LDK(KP707106781), TS, TL);
									   TT = VFMA(LDK(KP707106781), TS, TL);
									   T85 = VFNMS(LDK(KP668178637), T70, T71);
									   T72 = VFMA(LDK(KP668178637), T71, T70);
									   T4V = VFMA(LDK(KP198912367), TC, TH);
									   TI = VFNMS(LDK(KP198912367), TH, TC);
									   Tcd = VSUB(Tak, Tar);
									   Tas = VADD(Tak, Tar);
									   TgH = VSUB(Teg, Tej);
									   Tek = VADD(Teg, Tej);
									   Tgg = VADD(Tfr, Tfs);
									   Tft = VSUB(Tfr, Tfs);
									   T86 = VFNMS(LDK(KP668178637), T73, T74);
									   T75 = VFMA(LDK(KP668178637), T74, T73);
									   T4W = VFMA(LDK(KP198912367), TT, TY);
									   TZ = VFNMS(LDK(KP198912367), TY, TT);
									   Tav = VADD(T1t, T1u);
									   T1v = VSUB(T1t, T1u);
								      }
								 }
							    }
						       }
						  }
					     }
					     T15 = LD(&(xi[WS(is, 18)]), ivs, &(xi[0]));
					     T16 = LD(&(xi[WS(is, 82)]), ivs, &(xi[0]));
					     T18 = LD(&(xi[WS(is, 114)]), ivs, &(xi[0]));
					     T19 = LD(&(xi[WS(is, 50)]), ivs, &(xi[0]));
					     {
						  V T1d, T1e, T1g, T1h, Tax, T17, Tay, T1a;
						  T1d = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
						  Taw = VADD(Tau, Tav);
						  Tem = VSUB(Tau, Tav);
						  T1e = LD(&(xi[WS(is, 74)]), ivs, &(xi[0]));
						  T1g = LD(&(xi[WS(is, 42)]), ivs, &(xi[0]));
						  T1h = LD(&(xi[WS(is, 106)]), ivs, &(xi[0]));
						  Tax = VADD(T15, T16);
						  T17 = VSUB(T15, T16);
						  Tay = VADD(T18, T19);
						  T1a = VSUB(T18, T19);
						  {
						       V T1k, T1f, TaB, T1i, TaC, T1l;
						       T1k = LD(&(xi[WS(is, 122)]), ivs, &(xi[0]));
						       T1f = VSUB(T1d, T1e);
						       TaB = VADD(T1d, T1e);
						       T1i = VSUB(T1g, T1h);
						       TaC = VADD(T1g, T1h);
						       T1l = LD(&(xi[WS(is, 58)]), ivs, &(xi[0]));
						       Taz = VADD(Tax, Tay);
						       Ter = VSUB(Tax, Tay);
						       T1b = VADD(T17, T1a);
						       T1w = VSUB(T17, T1a);
						       T1n = LD(&(xi[WS(is, 26)]), ivs, &(xi[0]));
						       T1o = LD(&(xi[WS(is, 90)]), ivs, &(xi[0]));
						       Ten = VSUB(TaB, TaC);
						       TaD = VADD(TaB, TaC);
						       T1j = VFNMS(LDK(KP414213562), T1i, T1f);
						       T1y = VFMA(LDK(KP414213562), T1f, T1i);
						       T1m = VSUB(T1k, T1l);
						       TaE = VADD(T1k, T1l);
						  }
					     }
					}
					TaA = VSUB(Taw, Taz);
					Tdm = VADD(Taw, Taz);
					TaF = VADD(T1n, T1o);
					T1p = VSUB(T1n, T1o);
					T1c = VFMA(LDK(KP707106781), T1b, T14);
					T78 = VFNMS(LDK(KP707106781), T1b, T14);
					T7b = VFNMS(LDK(KP707106781), T1w, T1v);
					T1x = VFMA(LDK(KP707106781), T1w, T1v);
					TaG = VADD(TaE, TaF);
					Teo = VSUB(TaE, TaF);
					T1z = VFNMS(LDK(KP414213562), T1m, T1p);
					T1q = VFMA(LDK(KP414213562), T1p, T1m);
				   }
				   {
					V T1F, T26, T1Q, TaT, TaL, TaO, T27, T1M, T1Y, T1Z, TaU, T1T, TaQ, T1X, T20;
					V TaR;
					{
					     V T24, TaJ, T25, T1G, T1H, T1J, T1K, T1D, T1E;
					     T1D = LD(&(xi[WS(is, 126)]), ivs, &(xi[0]));
					     T1E = LD(&(xi[WS(is, 62)]), ivs, &(xi[0]));
					     T24 = LD(&(xi[WS(is, 94)]), ivs, &(xi[0]));
					     {
						  V TaH, Tdn, Tes, Tep;
						  TaH = VSUB(TaD, TaG);
						  Tdn = VADD(TaD, TaG);
						  Tes = VSUB(Ten, Teo);
						  Tep = VADD(Ten, Teo);
						  {
						       V T79, T1A, T7c, T1r;
						       T79 = VSUB(T1y, T1z);
						       T1A = VADD(T1y, T1z);
						       T7c = VSUB(T1j, T1q);
						       T1r = VADD(T1j, T1q);
						       TaJ = VADD(T1D, T1E);
						       T1F = VSUB(T1D, T1E);
						       TaI = VFNMS(LDK(KP414213562), TaH, TaA);
						       Tcf = VFMA(LDK(KP414213562), TaA, TaH);
						       Tdo = VADD(Tdm, Tdn);
						       TdG = VSUB(Tdm, Tdn);
						       Tgi = VFNMS(LDK(KP707106781), Tes, Ter);
						       Tet = VFMA(LDK(KP707106781), Tes, Ter);
						       Tgj = VFNMS(LDK(KP707106781), Tep, Tem);
						       Teq = VFMA(LDK(KP707106781), Tep, Tem);
						       T8X = VFNMS(LDK(KP923879532), T79, T78);
						       T7a = VFMA(LDK(KP923879532), T79, T78);
						       T5M = VFNMS(LDK(KP923879532), T1A, T1x);
						       T1B = VFMA(LDK(KP923879532), T1A, T1x);
						       T8W = VFMA(LDK(KP923879532), T7c, T7b);
						       T7d = VFNMS(LDK(KP923879532), T7c, T7b);
						       T5N = VFNMS(LDK(KP923879532), T1r, T1c);
						       T1s = VFMA(LDK(KP923879532), T1r, T1c);
						       T25 = LD(&(xi[WS(is, 30)]), ivs, &(xi[0]));
						  }
					     }
					     T1G = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
					     T1H = LD(&(xi[WS(is, 78)]), ivs, &(xi[0]));
					     T1J = LD(&(xi[WS(is, 110)]), ivs, &(xi[0]));
					     T1K = LD(&(xi[WS(is, 46)]), ivs, &(xi[0]));
					     {
						  V T1R, T1I, TaM, T1L, TaN, T1S, T1O, T1P, TaK, T1V, T1W;
						  T1O = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
						  T1P = LD(&(xi[WS(is, 70)]), ivs, &(xi[0]));
						  T26 = VSUB(T24, T25);
						  TaK = VADD(T25, T24);
						  T1R = LD(&(xi[WS(is, 102)]), ivs, &(xi[0]));
						  T1I = VSUB(T1G, T1H);
						  TaM = VADD(T1G, T1H);
						  T1L = VSUB(T1J, T1K);
						  TaN = VADD(T1J, T1K);
						  T1Q = VSUB(T1O, T1P);
						  TaT = VADD(T1O, T1P);
						  Tev = VSUB(TaJ, TaK);
						  TaL = VADD(TaJ, TaK);
						  T1S = LD(&(xi[WS(is, 38)]), ivs, &(xi[0]));
						  T1V = LD(&(xi[WS(is, 118)]), ivs, &(xi[0]));
						  T1W = LD(&(xi[WS(is, 54)]), ivs, &(xi[0]));
						  TeA = VSUB(TaN, TaM);
						  TaO = VADD(TaM, TaN);
						  T27 = VSUB(T1L, T1I);
						  T1M = VADD(T1I, T1L);
						  T1Y = LD(&(xi[WS(is, 86)]), ivs, &(xi[0]));
						  T1Z = LD(&(xi[WS(is, 22)]), ivs, &(xi[0]));
						  TaU = VADD(T1S, T1R);
						  T1T = VSUB(T1R, T1S);
						  TaQ = VADD(T1V, T1W);
						  T1X = VSUB(T1V, T1W);
					     }
					}
					Tdp = VADD(TaL, TaO);
					TaP = VSUB(TaL, TaO);
					T20 = VSUB(T1Y, T1Z);
					TaR = VADD(T1Z, T1Y);
					Tew = VSUB(TaT, TaU);
					TaV = VADD(TaT, TaU);
					T1U = VFMA(LDK(KP414213562), T1T, T1Q);
					T29 = VFNMS(LDK(KP414213562), T1Q, T1T);
					T7f = VFNMS(LDK(KP707106781), T1M, T1F);
					T1N = VFMA(LDK(KP707106781), T1M, T1F);
					T28 = VFMA(LDK(KP707106781), T27, T26);
					T7i = VFNMS(LDK(KP707106781), T27, T26);
					Tex = VSUB(TaQ, TaR);
					TaS = VADD(TaQ, TaR);
					T21 = VFNMS(LDK(KP414213562), T20, T1X);
					T2a = VFMA(LDK(KP414213562), T1X, T20);
				   }
			      }
			      {
				   V T2J, T2U, T30, T3b, TeL, Tb9, TeO, Tbg, T2M, Tba, T2P, Tbb, T34, Tbh, T33;
				   V T35;
				   {
					V T2H, T2I, T2S, T2T, T2Y, T2Z, T39, T3a;
					T2H = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
					{
					     V Tdq, TaW, Tey, TeB;
					     Tdq = VADD(TaV, TaS);
					     TaW = VSUB(TaS, TaV);
					     Tey = VADD(Tew, Tex);
					     TeB = VSUB(Tex, Tew);
					     {
						  V T2b, T7g, T22, T7j;
						  T2b = VADD(T29, T2a);
						  T7g = VSUB(T2a, T29);
						  T22 = VADD(T1U, T21);
						  T7j = VSUB(T21, T1U);
						  TaX = VFNMS(LDK(KP414213562), TaW, TaP);
						  Tcg = VFMA(LDK(KP414213562), TaP, TaW);
						  Tdr = VADD(Tdp, Tdq);
						  TdH = VSUB(Tdp, Tdq);
						  Tgl = VFNMS(LDK(KP707106781), TeB, TeA);
						  TeC = VFMA(LDK(KP707106781), TeB, TeA);
						  Tgm = VFNMS(LDK(KP707106781), Tey, Tev);
						  Tez = VFMA(LDK(KP707106781), Tey, Tev);
						  T90 = VFNMS(LDK(KP923879532), T7g, T7f);
						  T7h = VFMA(LDK(KP923879532), T7g, T7f);
						  T5P = VFNMS(LDK(KP923879532), T2b, T28);
						  T2c = VFMA(LDK(KP923879532), T2b, T28);
						  T8Z = VFMA(LDK(KP923879532), T7j, T7i);
						  T7k = VFNMS(LDK(KP923879532), T7j, T7i);
						  T5Q = VFNMS(LDK(KP923879532), T22, T1N);
						  T23 = VFMA(LDK(KP923879532), T22, T1N);
						  T2I = LD(&(xi[WS(is, 69)]), ivs, &(xi[WS(is, 1)]));
					     }
					}
					T2S = LD(&(xi[WS(is, 37)]), ivs, &(xi[WS(is, 1)]));
					T2T = LD(&(xi[WS(is, 101)]), ivs, &(xi[WS(is, 1)]));
					T2Y = LD(&(xi[WS(is, 125)]), ivs, &(xi[WS(is, 1)]));
					T2Z = LD(&(xi[WS(is, 61)]), ivs, &(xi[WS(is, 1)]));
					T39 = LD(&(xi[WS(is, 29)]), ivs, &(xi[WS(is, 1)]));
					T3a = LD(&(xi[WS(is, 93)]), ivs, &(xi[WS(is, 1)]));
					{
					     V T2K, Tbe, Tbf, T2L, T2N, T2O, Tb7, Tb8, T31, T32;
					     T2K = LD(&(xi[WS(is, 21)]), ivs, &(xi[WS(is, 1)]));
					     T2J = VSUB(T2H, T2I);
					     Tb7 = VADD(T2H, T2I);
					     T2U = VSUB(T2S, T2T);
					     Tb8 = VADD(T2S, T2T);
					     T30 = VSUB(T2Y, T2Z);
					     Tbe = VADD(T2Y, T2Z);
					     T3b = VSUB(T39, T3a);
					     Tbf = VADD(T39, T3a);
					     T2L = LD(&(xi[WS(is, 85)]), ivs, &(xi[WS(is, 1)]));
					     T2N = LD(&(xi[WS(is, 117)]), ivs, &(xi[WS(is, 1)]));
					     T2O = LD(&(xi[WS(is, 53)]), ivs, &(xi[WS(is, 1)]));
					     TeL = VSUB(Tb7, Tb8);
					     Tb9 = VADD(Tb7, Tb8);
					     T31 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
					     T32 = LD(&(xi[WS(is, 77)]), ivs, &(xi[WS(is, 1)]));
					     TeO = VSUB(Tbe, Tbf);
					     Tbg = VADD(Tbe, Tbf);
					     T2M = VSUB(T2K, T2L);
					     Tba = VADD(T2K, T2L);
					     T2P = VSUB(T2N, T2O);
					     Tbb = VADD(T2N, T2O);
					     T34 = LD(&(xi[WS(is, 109)]), ivs, &(xi[WS(is, 1)]));
					     Tbh = VADD(T31, T32);
					     T33 = VSUB(T31, T32);
					     T35 = LD(&(xi[WS(is, 45)]), ivs, &(xi[WS(is, 1)]));
					}
				   }
				   {
					V T4d, T4e, T4o, T4p;
					{
					     V T2X, T3q, T7t, T7C, T3r, T3e, T7D, T7w;
					     {
						  V T47, TbE, Tbd, Td9, TeW, TeN, T7s, T2W, T7r, T2R, TeP, Tbj, T37, T3c, T48;
						  {
						       V T3W, T3X, TeM, Tbc, T2Q, T2V, Tbi, T36;
						       T3W = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
						       T3X = LD(&(xi[WS(is, 67)]), ivs, &(xi[WS(is, 1)]));
						       TeM = VSUB(Tba, Tbb);
						       Tbc = VADD(Tba, Tbb);
						       T2Q = VADD(T2M, T2P);
						       T2V = VSUB(T2M, T2P);
						       T47 = LD(&(xi[WS(is, 99)]), ivs, &(xi[WS(is, 1)]));
						       Tbi = VADD(T34, T35);
						       T36 = VSUB(T34, T35);
						       TbE = VADD(T3W, T3X);
						       T3Y = VSUB(T3W, T3X);
						       Tbd = VSUB(Tb9, Tbc);
						       Td9 = VADD(Tb9, Tbc);
						       TeW = VFMA(LDK(KP414213562), TeL, TeM);
						       TeN = VFNMS(LDK(KP414213562), TeM, TeL);
						       T7s = VFNMS(LDK(KP707106781), T2V, T2U);
						       T2W = VFMA(LDK(KP707106781), T2V, T2U);
						       T7r = VFNMS(LDK(KP707106781), T2Q, T2J);
						       T2R = VFMA(LDK(KP707106781), T2Q, T2J);
						       TeP = VSUB(Tbh, Tbi);
						       Tbj = VADD(Tbh, Tbi);
						       T37 = VADD(T33, T36);
						       T3c = VSUB(T33, T36);
						       T48 = LD(&(xi[WS(is, 35)]), ivs, &(xi[WS(is, 1)]));
						  }
						  T2X = VFNMS(LDK(KP198912367), T2W, T2R);
						  T3q = VFMA(LDK(KP198912367), T2R, T2W);
						  T7t = VFMA(LDK(KP668178637), T7s, T7r);
						  T7C = VFNMS(LDK(KP668178637), T7r, T7s);
						  {
						       V Tbk, Tda, TeX, TeQ;
						       Tbk = VSUB(Tbg, Tbj);
						       Tda = VADD(Tbg, Tbj);
						       TeX = VFNMS(LDK(KP414213562), TeO, TeP);
						       TeQ = VFMA(LDK(KP414213562), TeP, TeO);
						       {
							    V T7v, T3d, T7u, T38, TbF;
							    T7v = VFNMS(LDK(KP707106781), T3c, T3b);
							    T3d = VFMA(LDK(KP707106781), T3c, T3b);
							    T7u = VFNMS(LDK(KP707106781), T37, T30);
							    T38 = VFMA(LDK(KP707106781), T37, T30);
							    T49 = VSUB(T47, T48);
							    TbF = VADD(T48, T47);
							    TdL = VSUB(Td9, Tda);
							    Tdb = VADD(Td9, Tda);
							    Tbu = VSUB(Tbd, Tbk);
							    Tbl = VADD(Tbd, Tbk);
							    Tgu = VSUB(TeN, TeQ);
							    TeR = VADD(TeN, TeQ);
							    Tgr = VSUB(TeW, TeX);
							    TeY = VADD(TeW, TeX);
							    T3r = VFNMS(LDK(KP198912367), T38, T3d);
							    T3e = VFMA(LDK(KP198912367), T3d, T38);
							    T7D = VFMA(LDK(KP668178637), T7u, T7v);
							    T7w = VFNMS(LDK(KP668178637), T7v, T7u);
							    Tf6 = VSUB(TbE, TbF);
							    TbG = VADD(TbE, TbF);
						       }
						  }
					     }
					     T4d = LD(&(xi[WS(is, 123)]), ivs, &(xi[WS(is, 1)]));
					     T5V = VSUB(T3q, T3r);
					     T3s = VADD(T3q, T3r);
					     T5Y = VSUB(T2X, T3e);
					     T3f = VADD(T2X, T3e);
					     T95 = VSUB(T7D, T7C);
					     T7E = VADD(T7C, T7D);
					     T98 = VSUB(T7t, T7w);
					     T7x = VADD(T7t, T7w);
					     T4e = LD(&(xi[WS(is, 59)]), ivs, &(xi[WS(is, 1)]));
					     T4o = LD(&(xi[WS(is, 91)]), ivs, &(xi[WS(is, 1)]));
					     T4p = LD(&(xi[WS(is, 27)]), ivs, &(xi[WS(is, 1)]));
					}
					{
					     V T3Z, T40, T42, T43, TbL, TbM;
					     T3Z = LD(&(xi[WS(is, 19)]), ivs, &(xi[WS(is, 1)]));
					     T40 = LD(&(xi[WS(is, 83)]), ivs, &(xi[WS(is, 1)]));
					     T42 = LD(&(xi[WS(is, 115)]), ivs, &(xi[WS(is, 1)]));
					     T43 = LD(&(xi[WS(is, 51)]), ivs, &(xi[WS(is, 1)]));
					     T4g = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
					     T4f = VSUB(T4d, T4e);
					     TbL = VADD(T4d, T4e);
					     T4q = VSUB(T4o, T4p);
					     TbM = VADD(T4p, T4o);
					     TbH = VADD(T3Z, T40);
					     T41 = VSUB(T3Z, T40);
					     TbI = VADD(T42, T43);
					     T44 = VSUB(T42, T43);
					     T4h = LD(&(xi[WS(is, 75)]), ivs, &(xi[WS(is, 1)]));
					     T4j = LD(&(xi[WS(is, 107)]), ivs, &(xi[WS(is, 1)]));
					     T4k = LD(&(xi[WS(is, 43)]), ivs, &(xi[WS(is, 1)]));
					     Tf9 = VSUB(TbL, TbM);
					     TbN = VADD(TbL, TbM);
					}
				   }
			      }
			 }
		    }
		    {
			 V TgB, Tgy, T62, T4H, T65, T4u, T9c, T7X, T9f, T7Q, Tg0, Tga, TfF, TeF, TfT;
			 V TfU, TfP, Tg7, TfI, Tfy, Tfz, Tf0, TfA, Tfl, Tg1, TfS;
			 {
			      V Tc1, TbS, Tfc, Tfj, TdX, Te5, TdZ, TdR, Te7, Te3, TdU, Te4;
			      {
				   V TdF, TdS, Tdx, Td5, TdO, TdE, TdC, Tdt, Tdk;
				   {
					V Tdc, TdA, T4F, T4c, T7V, T7M, T4G, T4t, T7W, T7P, TdB, Tdj;
					{
					     V Td1, Tdg, TbK, Tf8, Tfh, T4b, T7L, T46, T7K, TbQ, Tfa, T4r, T4m, Td4;
					     TdF = VSUB(TcZ, Td0);
					     Td1 = VADD(TcZ, Td0);
					     {
						  V TbJ, Tf7, T4a, T45;
						  TbJ = VADD(TbH, TbI);
						  Tf7 = VSUB(TbI, TbH);
						  T4a = VSUB(T44, T41);
						  T45 = VADD(T41, T44);
						  {
						       V TbO, T4i, TbP, T4l;
						       TbO = VADD(T4g, T4h);
						       T4i = VSUB(T4g, T4h);
						       TbP = VADD(T4j, T4k);
						       T4l = VSUB(T4j, T4k);
						       Tdg = VADD(TbG, TbJ);
						       TbK = VSUB(TbG, TbJ);
						       Tf8 = VFMA(LDK(KP414213562), Tf7, Tf6);
						       Tfh = VFNMS(LDK(KP414213562), Tf6, Tf7);
						       T4b = VFMA(LDK(KP707106781), T4a, T49);
						       T7L = VFNMS(LDK(KP707106781), T4a, T49);
						       T46 = VFMA(LDK(KP707106781), T45, T3Y);
						       T7K = VFNMS(LDK(KP707106781), T45, T3Y);
						       TbQ = VADD(TbO, TbP);
						       Tfa = VSUB(TbP, TbO);
						       T4r = VSUB(T4l, T4i);
						       T4m = VADD(T4i, T4l);
						       Td4 = VADD(Td2, Td3);
						       TdS = VSUB(Td2, Td3);
						  }
					     }
					     Tdc = VSUB(Td8, Tdb);
					     TdA = VADD(Td8, Tdb);
					     T4F = VFNMS(LDK(KP198912367), T46, T4b);
					     T4c = VFMA(LDK(KP198912367), T4b, T46);
					     T7V = VFMA(LDK(KP668178637), T7K, T7L);
					     T7M = VFNMS(LDK(KP668178637), T7L, T7K);
					     {
						  V Tdh, TbR, Tfb, Tfi;
						  Tdh = VADD(TbN, TbQ);
						  TbR = VSUB(TbN, TbQ);
						  Tfb = VFNMS(LDK(KP414213562), Tfa, Tf9);
						  Tfi = VFMA(LDK(KP414213562), Tf9, Tfa);
						  {
						       V T4s, T7O, T4n, T7N, Tdi;
						       T4s = VFMA(LDK(KP707106781), T4r, T4q);
						       T7O = VFNMS(LDK(KP707106781), T4r, T4q);
						       T4n = VFMA(LDK(KP707106781), T4m, T4f);
						       T7N = VFNMS(LDK(KP707106781), T4m, T4f);
						       Tdx = VADD(Td1, Td4);
						       Td5 = VSUB(Td1, Td4);
						       TdO = VSUB(Tdh, Tdg);
						       Tdi = VADD(Tdg, Tdh);
						       Tc1 = VSUB(TbR, TbK);
						       TbS = VADD(TbK, TbR);
						       TgB = VSUB(Tfb, Tf8);
						       Tfc = VADD(Tf8, Tfb);
						       Tgy = VSUB(Tfi, Tfh);
						       Tfj = VADD(Tfh, Tfi);
						       T4G = VFMA(LDK(KP198912367), T4n, T4s);
						       T4t = VFNMS(LDK(KP198912367), T4s, T4n);
						       T7W = VFNMS(LDK(KP668178637), T7N, T7O);
						       T7P = VFMA(LDK(KP668178637), T7O, T7N);
						       TdB = VADD(Tdf, Tdi);
						       Tdj = VSUB(Tdf, Tdi);
						  }
					     }
					}
					T62 = VSUB(T4G, T4F);
					T4H = VADD(T4F, T4G);
					T65 = VSUB(T4t, T4c);
					T4u = VADD(T4c, T4t);
					T9c = VSUB(T7V, T7W);
					T7X = VADD(T7V, T7W);
					T9f = VSUB(T7P, T7M);
					T7Q = VADD(T7M, T7P);
					TdE = VADD(TdA, TdB);
					TdC = VSUB(TdA, TdB);
					Tdt = VSUB(Tdc, Tdj);
					Tdk = VADD(Tdc, Tdj);
				   }
				   {
					V TdT, Tdl, Tdv, TdJ, Te1, Te2, TdQ, Tdz, TdD, Tdu, Tdw;
					{
					     V TdI, TdM, TdV, TdW, TdP, Tds, Tdy;
					     TdI = VADD(TdG, TdH);
					     TdT = VSUB(TdG, TdH);
					     TdM = VFNMS(LDK(KP414213562), TdL, TdK);
					     TdV = VFMA(LDK(KP414213562), TdK, TdL);
					     TdW = VFMA(LDK(KP414213562), TdN, TdO);
					     TdP = VFNMS(LDK(KP414213562), TdO, TdN);
					     Tdl = VFNMS(LDK(KP707106781), Tdk, Td5);
					     Tdv = VFMA(LDK(KP707106781), Tdk, Td5);
					     Tds = VSUB(Tdo, Tdr);
					     Tdy = VADD(Tdo, Tdr);
					     TdJ = VFMA(LDK(KP707106781), TdI, TdF);
					     Te1 = VFNMS(LDK(KP707106781), TdI, TdF);
					     TdX = VSUB(TdV, TdW);
					     Te2 = VADD(TdV, TdW);
					     Te5 = VSUB(TdM, TdP);
					     TdQ = VADD(TdM, TdP);
					     Tdz = VSUB(Tdx, Tdy);
					     TdD = VADD(Tdx, Tdy);
					     Tdu = VFNMS(LDK(KP707106781), Tdt, Tds);
					     Tdw = VFMA(LDK(KP707106781), Tdt, Tds);
					}
					TdZ = VFMA(LDK(KP923879532), TdQ, TdJ);
					TdR = VFNMS(LDK(KP923879532), TdQ, TdJ);
					Te7 = VFMA(LDK(KP923879532), Te2, Te1);
					Te3 = VFNMS(LDK(KP923879532), Te2, Te1);
					ST(&(xo[0]), VADD(TdD, TdE), ovs, &(xo[0]));
					ST(&(xo[WS(os, 64)]), VSUB(TdD, TdE), ovs, &(xo[0]));
					ST(&(xo[WS(os, 32)]), VFMAI(TdC, Tdz), ovs, &(xo[0]));
					ST(&(xo[WS(os, 96)]), VFNMSI(TdC, Tdz), ovs, &(xo[0]));
					ST(&(xo[WS(os, 112)]), VFNMSI(Tdw, Tdv), ovs, &(xo[0]));
					ST(&(xo[WS(os, 16)]), VFMAI(Tdw, Tdv), ovs, &(xo[0]));
					ST(&(xo[WS(os, 80)]), VFMAI(Tdu, Tdl), ovs, &(xo[0]));
					ST(&(xo[WS(os, 48)]), VFNMSI(Tdu, Tdl), ovs, &(xo[0]));
					TdU = VFMA(LDK(KP707106781), TdT, TdS);
					Te4 = VFNMS(LDK(KP707106781), TdT, TdS);
				   }
			      }
			      {
				   V Tcx, TcJ, TcI, Tcy, TcA, Tbm, Tcp, TaZ, Tcs, Tci, Tbv, TcB, TcD, TbT, Tc2;
				   V TcE, Tat, TaY;
				   Tcx = VFNMS(LDK(KP707106781), Tas, Tad);
				   Tat = VFMA(LDK(KP707106781), Tas, Tad);
				   TaY = VADD(TaI, TaX);
				   TcJ = VSUB(TaI, TaX);
				   {
					V Tce, Tch, Te8, Te6, TdY, Te0;
					TcI = VFNMS(LDK(KP707106781), Tcd, Tcc);
					Tce = VFMA(LDK(KP707106781), Tcd, Tcc);
					Tch = VSUB(Tcf, Tcg);
					Tcy = VADD(Tcf, Tcg);
					Te8 = VFNMS(LDK(KP923879532), Te5, Te4);
					Te6 = VFMA(LDK(KP923879532), Te5, Te4);
					TdY = VFNMS(LDK(KP923879532), TdX, TdU);
					Te0 = VFMA(LDK(KP923879532), TdX, TdU);
					TcA = VFNMS(LDK(KP707106781), Tbl, Tb6);
					Tbm = VFMA(LDK(KP707106781), Tbl, Tb6);
					Tcp = VFNMS(LDK(KP923879532), TaY, Tat);
					TaZ = VFMA(LDK(KP923879532), TaY, Tat);
					Tcs = VFNMS(LDK(KP923879532), Tch, Tce);
					Tci = VFMA(LDK(KP923879532), Tch, Tce);
					ST(&(xo[WS(os, 88)]), VFNMSI(Te6, Te3), ovs, &(xo[0]));
					ST(&(xo[WS(os, 40)]), VFMAI(Te6, Te3), ovs, &(xo[0]));
					ST(&(xo[WS(os, 104)]), VFMAI(Te8, Te7), ovs, &(xo[0]));
					ST(&(xo[WS(os, 24)]), VFNMSI(Te8, Te7), ovs, &(xo[0]));
					ST(&(xo[WS(os, 8)]), VFMAI(Te0, TdZ), ovs, &(xo[0]));
					ST(&(xo[WS(os, 120)]), VFNMSI(Te0, TdZ), ovs, &(xo[0]));
					ST(&(xo[WS(os, 72)]), VFMAI(TdY, TdR), ovs, &(xo[0]));
					ST(&(xo[WS(os, 56)]), VFNMSI(TdY, TdR), ovs, &(xo[0]));
					Tbv = VFMA(LDK(KP707106781), Tbu, Tbt);
					TcB = VFNMS(LDK(KP707106781), Tbu, Tbt);
					TcD = VFNMS(LDK(KP707106781), TbS, TbD);
					TbT = VFMA(LDK(KP707106781), TbS, TbD);
					Tc2 = VFMA(LDK(KP707106781), Tc1, Tc0);
					TcE = VFNMS(LDK(KP707106781), Tc1, Tc0);
				   }
				   {
					V TcR, Tcz, TcU, TcK, Tcq, Tcl, Tct, Tc4;
					{
					     V Tcj, Tbw, Tck, Tc3;
					     Tcj = VFMA(LDK(KP198912367), Tbm, Tbv);
					     Tbw = VFNMS(LDK(KP198912367), Tbv, Tbm);
					     Tck = VFMA(LDK(KP198912367), TbT, Tc2);
					     Tc3 = VFNMS(LDK(KP198912367), Tc2, TbT);
					     TcR = VFNMS(LDK(KP923879532), Tcy, Tcx);
					     Tcz = VFMA(LDK(KP923879532), Tcy, Tcx);
					     TcU = VFMA(LDK(KP923879532), TcJ, TcI);
					     TcK = VFNMS(LDK(KP923879532), TcJ, TcI);
					     Tcq = VADD(Tcj, Tck);
					     Tcl = VSUB(Tcj, Tck);
					     Tct = VSUB(Tbw, Tc3);
					     Tc4 = VADD(Tbw, Tc3);
					}
					{
					     V TfN, Tel, TfY, Tfu, Tfv, Tfw, TcT, TcX, TcQ, TcO, TcW, TcY, TcP, TcH, TfZ;
					     V TeE;
					     {
						  V Teu, TcS, TcN, TcV, TcG, TeD;
						  TfN = VFNMS(LDK(KP923879532), Tek, Ted);
						  Tel = VFMA(LDK(KP923879532), Tek, Ted);
						  {
						       V TcL, TcC, Tcr, Tcv;
						       TcL = VFNMS(LDK(KP668178637), TcA, TcB);
						       TcC = VFMA(LDK(KP668178637), TcB, TcA);
						       Tcr = VFNMS(LDK(KP980785280), Tcq, Tcp);
						       Tcv = VFMA(LDK(KP980785280), Tcq, Tcp);
						       {
							    V Tco, Tcm, Tcu, Tcw;
							    Tco = VFMA(LDK(KP980785280), Tcl, Tci);
							    Tcm = VFNMS(LDK(KP980785280), Tcl, Tci);
							    Tcu = VFMA(LDK(KP980785280), Tct, Tcs);
							    Tcw = VFNMS(LDK(KP980785280), Tct, Tcs);
							    {
								 V Tcn, Tc5, TcM, TcF;
								 Tcn = VFMA(LDK(KP980785280), Tc4, TaZ);
								 Tc5 = VFNMS(LDK(KP980785280), Tc4, TaZ);
								 TcM = VFNMS(LDK(KP668178637), TcD, TcE);
								 TcF = VFMA(LDK(KP668178637), TcE, TcD);
								 TfY = VFNMS(LDK(KP923879532), Tft, Tfq);
								 Tfu = VFMA(LDK(KP923879532), Tft, Tfq);
								 Tfv = VFMA(LDK(KP198912367), Teq, Tet);
								 Teu = VFNMS(LDK(KP198912367), Tet, Teq);
								 ST(&(xo[WS(os, 92)]), VFNMSI(Tcu, Tcr), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 36)]), VFMAI(Tcu, Tcr), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 100)]), VFMAI(Tcw, Tcv), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 28)]), VFNMSI(Tcw, Tcv), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 4)]), VFMAI(Tco, Tcn), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 124)]), VFNMSI(Tco, Tcn), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 68)]), VFMAI(Tcm, Tc5), ovs, &(xo[0]));
								 ST(&(xo[WS(os, 60)]), VFNMSI(Tcm, Tc5), ovs, &(xo[0]));
								 TcS = VADD(TcL, TcM);
								 TcN = VSUB(TcL, TcM);
								 TcV = VSUB(TcC, TcF);
								 TcG = VADD(TcC, TcF);
								 TeD = VFNMS(LDK(KP198912367), TeC, Tez);
								 Tfw = VFMA(LDK(KP198912367), Tez, TeC);
							    }
						       }
						  }
						  TcT = VFMA(LDK(KP831469612), TcS, TcR);
						  TcX = VFNMS(LDK(KP831469612), TcS, TcR);
						  TcQ = VFMA(LDK(KP831469612), TcN, TcK);
						  TcO = VFNMS(LDK(KP831469612), TcN, TcK);
						  TcW = VFNMS(LDK(KP831469612), TcV, TcU);
						  TcY = VFMA(LDK(KP831469612), TcV, TcU);
						  TcP = VFMA(LDK(KP831469612), TcG, Tcz);
						  TcH = VFNMS(LDK(KP831469612), TcG, Tcz);
						  TfZ = VSUB(Teu, TeD);
						  TeE = VADD(Teu, TeD);
					     }
					     {
						  V TfQ, TeS, TfO, Tfx, TeZ, TfR, Tfd, Tfk;
						  TfQ = VFNMS(LDK(KP923879532), TeR, TeK);
						  TeS = VFMA(LDK(KP923879532), TeR, TeK);
						  ST(&(xo[WS(os, 84)]), VFMAI(TcW, TcT), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 44)]), VFNMSI(TcW, TcT), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 108)]), VFNMSI(TcY, TcX), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 20)]), VFMAI(TcY, TcX), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 116)]), VFMAI(TcQ, TcP), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 12)]), VFNMSI(TcQ, TcP), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 52)]), VFMAI(TcO, TcH), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 76)]), VFNMSI(TcO, TcH), ovs, &(xo[0]));
						  Tg0 = VFNMS(LDK(KP980785280), TfZ, TfY);
						  Tga = VFMA(LDK(KP980785280), TfZ, TfY);
						  TfF = VFNMS(LDK(KP980785280), TeE, Tel);
						  TeF = VFMA(LDK(KP980785280), TeE, Tel);
						  TfO = VADD(Tfv, Tfw);
						  Tfx = VSUB(Tfv, Tfw);
						  TeZ = VFMA(LDK(KP923879532), TeY, TeV);
						  TfR = VFNMS(LDK(KP923879532), TeY, TeV);
						  TfT = VFNMS(LDK(KP923879532), Tfc, Tf5);
						  Tfd = VFMA(LDK(KP923879532), Tfc, Tf5);
						  Tfk = VFMA(LDK(KP923879532), Tfj, Tfg);
						  TfU = VFNMS(LDK(KP923879532), Tfj, Tfg);
						  TfP = VFMA(LDK(KP980785280), TfO, TfN);
						  Tg7 = VFNMS(LDK(KP980785280), TfO, TfN);
						  TfI = VFNMS(LDK(KP980785280), Tfx, Tfu);
						  Tfy = VFMA(LDK(KP980785280), Tfx, Tfu);
						  Tfz = VFMA(LDK(KP098491403), TeS, TeZ);
						  Tf0 = VFNMS(LDK(KP098491403), TeZ, TeS);
						  TfA = VFMA(LDK(KP098491403), Tfd, Tfk);
						  Tfl = VFNMS(LDK(KP098491403), Tfk, Tfd);
						  Tg1 = VFNMS(LDK(KP820678790), TfQ, TfR);
						  TfS = VFMA(LDK(KP820678790), TfR, TfQ);
					     }
					}
				   }
			      }
			 }
			 {
			      V T8x, T8y, T8F, T8w, T8k, T8f, T8n, T80, T9l, T76, T87, T8U, T89, T7e, T7l;
			      V T8a;
			      {
				   V The, Tho, TgT, Tgp, Th7, Th8, Thf, Th6, Th3, Thl, TgW, TgM, TgU, TgP, TgX;
				   V TgE;
				   {
					V Th1, TgI, TgJ, TgK;
					{
					     V Tgh, Thc, Tgk, TfG, TfB, TfJ, Tfm, Tg2, TfV, Tgn, TfL, TfH;
					     Th1 = VFMA(LDK(KP923879532), Tgg, Tgf);
					     Tgh = VFNMS(LDK(KP923879532), Tgg, Tgf);
					     Thc = VFNMS(LDK(KP923879532), TgH, TgG);
					     TgI = VFMA(LDK(KP923879532), TgH, TgG);
					     TgJ = VFMA(LDK(KP668178637), Tgi, Tgj);
					     Tgk = VFNMS(LDK(KP668178637), Tgj, Tgi);
					     TfG = VADD(Tfz, TfA);
					     TfB = VSUB(Tfz, TfA);
					     TfJ = VSUB(Tf0, Tfl);
					     Tfm = VADD(Tf0, Tfl);
					     Tg2 = VFNMS(LDK(KP820678790), TfT, TfU);
					     TfV = VFMA(LDK(KP820678790), TfU, TfT);
					     Tgn = VFNMS(LDK(KP668178637), Tgm, Tgl);
					     TgK = VFMA(LDK(KP668178637), Tgl, Tgm);
					     TfL = VFMA(LDK(KP995184726), TfG, TfF);
					     TfH = VFNMS(LDK(KP995184726), TfG, TfF);
					     {
						  V TfE, TfC, TfM, TfK;
						  TfE = VFMA(LDK(KP995184726), TfB, Tfy);
						  TfC = VFNMS(LDK(KP995184726), TfB, Tfy);
						  TfM = VFNMS(LDK(KP995184726), TfJ, TfI);
						  TfK = VFMA(LDK(KP995184726), TfJ, TfI);
						  {
						       V TfD, Tfn, Tg8, Tg3;
						       TfD = VFMA(LDK(KP995184726), Tfm, TeF);
						       Tfn = VFNMS(LDK(KP995184726), Tfm, TeF);
						       Tg8 = VADD(Tg1, Tg2);
						       Tg3 = VSUB(Tg1, Tg2);
						       {
							    V Tgb, TfW, Thd, Tgo;
							    Tgb = VSUB(TfS, TfV);
							    TfW = VADD(TfS, TfV);
							    Thd = VSUB(Tgk, Tgn);
							    Tgo = VADD(Tgk, Tgn);
							    ST(&(xo[WS(os, 98)]), VFMAI(TfM, TfL), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 30)]), VFNMSI(TfM, TfL), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 94)]), VFNMSI(TfK, TfH), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 34)]), VFMAI(TfK, TfH), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 2)]), VFMAI(TfE, TfD), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 126)]), VFNMSI(TfE, TfD), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 66)]), VFMAI(TfC, Tfn), ovs, &(xo[0]));
							    ST(&(xo[WS(os, 62)]), VFNMSI(TfC, Tfn), ovs, &(xo[0]));
							    {
								 V Tgd, Tg9, Tg6, Tg4;
								 Tgd = VFNMS(LDK(KP773010453), Tg8, Tg7);
								 Tg9 = VFMA(LDK(KP773010453), Tg8, Tg7);
								 Tg6 = VFMA(LDK(KP773010453), Tg3, Tg0);
								 Tg4 = VFNMS(LDK(KP773010453), Tg3, Tg0);
								 {
								      V Tge, Tgc, Tg5, TfX;
								      Tge = VFMA(LDK(KP773010453), Tgb, Tga);
								      Tgc = VFNMS(LDK(KP773010453), Tgb, Tga);
								      Tg5 = VFMA(LDK(KP773010453), TfW, TfP);
								      TfX = VFNMS(LDK(KP773010453), TfW, TfP);
								      The = VFMA(LDK(KP831469612), Thd, Thc);
								      Tho = VFNMS(LDK(KP831469612), Thd, Thc);
								      TgT = VFMA(LDK(KP831469612), Tgo, Tgh);
								      Tgp = VFNMS(LDK(KP831469612), Tgo, Tgh);
								      ST(&(xo[WS(os, 110)]), VFNMSI(Tge, Tgd), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 18)]), VFMAI(Tge, Tgd), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 82)]), VFMAI(Tgc, Tg9), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 46)]), VFNMSI(Tgc, Tg9), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 114)]), VFMAI(Tg6, Tg5), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 14)]), VFNMSI(Tg6, Tg5), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 50)]), VFMAI(Tg4, TfX), ovs, &(xo[0]));
								      ST(&(xo[WS(os, 78)]), VFNMSI(Tg4, TfX), ovs, &(xo[0]));
								 }
							    }
						       }
						  }
					     }
					}
					{
					     V Th4, Tgs, Tgv, Th5, Tgz, TgC, Th2, TgL;
					     Th4 = VFMA(LDK(KP923879532), Tgr, Tgq);
					     Tgs = VFNMS(LDK(KP923879532), Tgr, Tgq);
					     Tgv = VFMA(LDK(KP923879532), Tgu, Tgt);
					     Th5 = VFNMS(LDK(KP923879532), Tgu, Tgt);
					     Th7 = VFMA(LDK(KP923879532), Tgy, Tgx);
					     Tgz = VFNMS(LDK(KP923879532), Tgy, Tgx);
					     TgC = VFMA(LDK(KP923879532), TgB, TgA);
					     Th8 = VFNMS(LDK(KP923879532), TgB, TgA);
					     Th2 = VADD(TgJ, TgK);
					     TgL = VSUB(TgJ, TgK);
					     {
						  V TgN, Tgw, TgO, TgD;
						  TgN = VFMA(LDK(KP534511135), Tgs, Tgv);
						  Tgw = VFNMS(LDK(KP534511135), Tgv, Tgs);
						  TgO = VFMA(LDK(KP534511135), Tgz, TgC);
						  TgD = VFNMS(LDK(KP534511135), TgC, Tgz);
						  Thf = VFNMS(LDK(KP303346683), Th4, Th5);
						  Th6 = VFMA(LDK(KP303346683), Th5, Th4);
						  Th3 = VFMA(LDK(KP831469612), Th2, Th1);
						  Thl = VFNMS(LDK(KP831469612), Th2, Th1);
						  TgW = VFNMS(LDK(KP831469612), TgL, TgI);
						  TgM = VFMA(LDK(KP831469612), TgL, TgI);
						  TgU = VADD(TgN, TgO);
						  TgP = VSUB(TgN, TgO);
						  TgX = VSUB(Tgw, TgD);
						  TgE = VADD(Tgw, TgD);
					     }
					}
				   }
				   {
					V T8u, T8v, T7R, T8d, T7G, Thm, Thh, Thp, Tha, T7Y, Thr, Thn;
					{
					     V T7y, T7F, TgZ, TgV;
					     T8u = VFNMS(LDK(KP831469612), T7x, T7q);
					     T7y = VFMA(LDK(KP831469612), T7x, T7q);
					     T7F = VFMA(LDK(KP831469612), T7E, T7B);
					     T8v = VFNMS(LDK(KP831469612), T7E, T7B);
					     T8x = VFNMS(LDK(KP831469612), T7Q, T7J);
					     T7R = VFMA(LDK(KP831469612), T7Q, T7J);
					     TgZ = VFMA(LDK(KP881921264), TgU, TgT);
					     TgV = VFNMS(LDK(KP881921264), TgU, TgT);
					     {
						  V TgS, TgQ, Th0, TgY;
						  TgS = VFMA(LDK(KP881921264), TgP, TgM);
						  TgQ = VFNMS(LDK(KP881921264), TgP, TgM);
						  Th0 = VFNMS(LDK(KP881921264), TgX, TgW);
						  TgY = VFMA(LDK(KP881921264), TgX, TgW);
						  {
						       V TgR, TgF, Thg, Th9;
						       TgR = VFMA(LDK(KP881921264), TgE, Tgp);
						       TgF = VFNMS(LDK(KP881921264), TgE, Tgp);
						       Thg = VFNMS(LDK(KP303346683), Th7, Th8);
						       Th9 = VFMA(LDK(KP303346683), Th8, Th7);
						       T8d = VFNMS(LDK(KP148335987), T7y, T7F);
						       T7G = VFMA(LDK(KP148335987), T7F, T7y);
						       ST(&(xo[WS(os, 106)]), VFMAI(Th0, TgZ), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 22)]), VFNMSI(Th0, TgZ), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 86)]), VFNMSI(TgY, TgV), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 42)]), VFMAI(TgY, TgV), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 10)]), VFMAI(TgS, TgR), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 118)]), VFNMSI(TgS, TgR), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 74)]), VFMAI(TgQ, TgF), ovs, &(xo[0]));
						       ST(&(xo[WS(os, 54)]), VFNMSI(TgQ, TgF), ovs, &(xo[0]));
						       Thm = VADD(Thf, Thg);
						       Thh = VSUB(Thf, Thg);
						       Thp = VSUB(Th6, Th9);
						       Tha = VADD(Th6, Th9);
						       T7Y = VFMA(LDK(KP831469612), T7X, T7U);
						       T8y = VFNMS(LDK(KP831469612), T7X, T7U);
						  }
					     }
					}
					Thr = VFNMS(LDK(KP956940335), Thm, Thl);
					Thn = VFMA(LDK(KP956940335), Thm, Thl);
					{
					     V Thk, Thi, Ths, Thq;
					     Thk = VFMA(LDK(KP956940335), Thh, The);
					     Thi = VFNMS(LDK(KP956940335), Thh, The);
					     Ths = VFMA(LDK(KP956940335), Thp, Tho);
					     Thq = VFNMS(LDK(KP956940335), Thp, Tho);
					     {
						  V Thj, Thb, T8e, T7Z;
						  Thj = VFMA(LDK(KP956940335), Tha, Th3);
						  Thb = VFNMS(LDK(KP956940335), Tha, Th3);
						  T8e = VFNMS(LDK(KP148335987), T7R, T7Y);
						  T7Z = VFMA(LDK(KP148335987), T7Y, T7R);
						  T8F = VFMA(LDK(KP741650546), T8u, T8v);
						  T8w = VFNMS(LDK(KP741650546), T8v, T8u);
						  ST(&(xo[WS(os, 102)]), VFNMSI(Ths, Thr), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 26)]), VFMAI(Ths, Thr), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 90)]), VFMAI(Thq, Thn), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 38)]), VFNMSI(Thq, Thn), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 122)]), VFMAI(Thk, Thj), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 6)]), VFNMSI(Thk, Thj), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 58)]), VFMAI(Thi, Thb), ovs, &(xo[0]));
						  ST(&(xo[WS(os, 70)]), VFNMSI(Thi, Thb), ovs, &(xo[0]));
						  T8k = VADD(T8d, T8e);
						  T8f = VSUB(T8d, T8e);
						  T8n = VSUB(T7G, T7Z);
						  T80 = VADD(T7G, T7Z);
					     }
					}
					T9l = VSUB(T72, T75);
					T76 = VADD(T72, T75);
					T87 = VSUB(T85, T86);
					T8U = VADD(T85, T86);
					T89 = VFNMS(LDK(KP303346683), T7a, T7d);
					T7e = VFMA(LDK(KP303346683), T7d, T7a);
					T7l = VFMA(LDK(KP303346683), T7k, T7h);
					T8a = VFNMS(LDK(KP303346683), T7h, T7k);
				   }
			      }
			      {
				   V T11, T5h, T5a, T55, T5d, T4K, T5C, T5x, T5F, T5q, T4X, T4Z, T1C, T2d, T50;
				   {
					V T5k, T3g, T3t, T5l, T5n, T4v, T4I, T5o, T8G, T8z;
					T5k = VFNMS(LDK(KP980785280), T3f, T2G);
					T3g = VFMA(LDK(KP980785280), T3f, T2G);
					T8G = VFMA(LDK(KP741650546), T8x, T8y);
					T8z = VFNMS(LDK(KP741650546), T8y, T8x);
					{
					     V T8r, T77, T8C, T88;
					     T8r = VFNMS(LDK(KP831469612), T76, T6Z);
					     T77 = VFMA(LDK(KP831469612), T76, T6Z);
					     T8C = VFNMS(LDK(KP831469612), T87, T84);
					     T88 = VFMA(LDK(KP831469612), T87, T84);
					     {
						  V T8D, T7m, T8s, T8b;
						  T8D = VSUB(T7e, T7l);
						  T7m = VADD(T7e, T7l);
						  T8s = VADD(T89, T8a);
						  T8b = VSUB(T89, T8a);
						  {
						       V T8M, T8H, T8P, T8A;
						       T8M = VADD(T8F, T8G);
						       T8H = VSUB(T8F, T8G);
						       T8P = VSUB(T8w, T8z);
						       T8A = VADD(T8w, T8z);
						       {
							    V T8E, T8O, T8j, T7n;
							    T8E = VFMA(LDK(KP956940335), T8D, T8C);
							    T8O = VFNMS(LDK(KP956940335), T8D, T8C);
							    T8j = VFNMS(LDK(KP956940335), T7m, T77);
							    T7n = VFMA(LDK(KP956940335), T7m, T77);
							    {
								 V T8t, T8L, T8m, T8c;
								 T8t = VFNMS(LDK(KP956940335), T8s, T8r);
								 T8L = VFMA(LDK(KP956940335), T8s, T8r);
								 T8m = VFNMS(LDK(KP956940335), T8b, T88);
								 T8c = VFMA(LDK(KP956940335), T8b, T88);
								 {
								      V T8K, T8I, T8S, T8Q;
								      T8K = VFMA(LDK(KP803207531), T8H, T8E);
								      T8I = VFNMS(LDK(KP803207531), T8H, T8E);
								      T8S = VFNMS(LDK(KP803207531), T8P, T8O);
								      T8Q = VFMA(LDK(KP803207531), T8P, T8O);
								      {
									   V T8p, T8l, T8h, T81;
									   T8p = VFNMS(LDK(KP989176509), T8k, T8j);
									   T8l = VFMA(LDK(KP989176509), T8k, T8j);
									   T8h = VFMA(LDK(KP989176509), T80, T7n);
									   T81 = VFNMS(LDK(KP989176509), T80, T7n);
									   {
										V T8J, T8B, T8R, T8N;
										T8J = VFMA(LDK(KP803207531), T8A, T8t);
										T8B = VFNMS(LDK(KP803207531), T8A, T8t);
										T8R = VFMA(LDK(KP803207531), T8M, T8L);
										T8N = VFNMS(LDK(KP803207531), T8M, T8L);
										{
										     V T8q, T8o, T8i, T8g;
										     T8q = VFMA(LDK(KP989176509), T8n, T8m);
										     T8o = VFNMS(LDK(KP989176509), T8n, T8m);
										     T8i = VFMA(LDK(KP989176509), T8f, T8c);
										     T8g = VFNMS(LDK(KP989176509), T8f, T8c);
										     ST(&(xo[WS(os, 13)]), VFMAI(T8K, T8J), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 115)]), VFNMSI(T8K, T8J), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 77)]), VFMAI(T8I, T8B), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 51)]), VFNMSI(T8I, T8B), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 109)]), VFMAI(T8S, T8R), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 19)]), VFNMSI(T8S, T8R), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 83)]), VFNMSI(T8Q, T8N), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 45)]), VFMAI(T8Q, T8N), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 99)]), VFNMSI(T8q, T8p), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 29)]), VFMAI(T8q, T8p), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 93)]), VFMAI(T8o, T8l), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 35)]), VFNMSI(T8o, T8l), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 125)]), VFMAI(T8i, T8h), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 3)]), VFNMSI(T8i, T8h), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 61)]), VFMAI(T8g, T81), ovs, &(xo[WS(os, 1)]));
										     ST(&(xo[WS(os, 67)]), VFNMSI(T8g, T81), ovs, &(xo[WS(os, 1)]));
										     T3t = VFMA(LDK(KP980785280), T3s, T3p);
										     T5l = VFNMS(LDK(KP980785280), T3s, T3p);
										}
									   }
								      }
								 }
							    }
						       }
						  }
					     }
					}
					T5n = VFNMS(LDK(KP980785280), T4u, T3V);
					T4v = VFMA(LDK(KP980785280), T4u, T3V);
					T4I = VFMA(LDK(KP980785280), T4H, T4E);
					T5o = VFNMS(LDK(KP980785280), T4H, T4E);
					{
					     V T53, T3u, T54, T4J, T5v, T5m, T5w, T5p, T10;
					     T6b = VSUB(TI, TZ);
					     T10 = VADD(TI, TZ);
					     T53 = VFMA(LDK(KP049126849), T3g, T3t);
					     T3u = VFNMS(LDK(KP049126849), T3t, T3g);
					     T54 = VFMA(LDK(KP049126849), T4v, T4I);
					     T4J = VFNMS(LDK(KP049126849), T4I, T4v);
					     T5v = VFNMS(LDK(KP906347169), T5k, T5l);
					     T5m = VFMA(LDK(KP906347169), T5l, T5k);
					     T5w = VFNMS(LDK(KP906347169), T5n, T5o);
					     T5p = VFMA(LDK(KP906347169), T5o, T5n);
					     T11 = VFMA(LDK(KP980785280), T10, Tr);
					     T5h = VFNMS(LDK(KP980785280), T10, Tr);
					     T5a = VADD(T53, T54);
					     T55 = VSUB(T53, T54);
					     T5d = VSUB(T3u, T4J);
					     T4K = VADD(T3u, T4J);
					     T5C = VADD(T5v, T5w);
					     T5x = VSUB(T5v, T5w);
					     T5F = VSUB(T5m, T5p);
					     T5q = VADD(T5m, T5p);
					     T4X = VSUB(T4V, T4W);
					     T5K = VADD(T4V, T4W);
					}
					T4Z = VFMA(LDK(KP098491403), T1s, T1B);
					T1C = VFNMS(LDK(KP098491403), T1B, T1s);
					T2d = VFNMS(LDK(KP098491403), T2c, T23);
					T50 = VFMA(LDK(KP098491403), T23, T2c);
				   }
				   {
					V T9y, T9t, T9B, T9i, T9n, T9o, T9F, T8V, T9Q, T9m, T9R, T92, Ta0, T9V, Ta3;
					V T9O;
					{
					     V T9I, T9J, T9L, T9d, T5s, T4Y, T5t, T2e, T5i, T51, T9r, T9a, T9g, T9M, T96;
					     V T99;
					     T9I = VFMA(LDK(KP831469612), T95, T94);
					     T96 = VFNMS(LDK(KP831469612), T95, T94);
					     T99 = VFNMS(LDK(KP831469612), T98, T97);
					     T9J = VFMA(LDK(KP831469612), T98, T97);
					     T9L = VFMA(LDK(KP831469612), T9c, T9b);
					     T9d = VFNMS(LDK(KP831469612), T9c, T9b);
					     T5s = VFNMS(LDK(KP980785280), T4X, T4U);
					     T4Y = VFMA(LDK(KP980785280), T4X, T4U);
					     T5t = VSUB(T1C, T2d);
					     T2e = VADD(T1C, T2d);
					     T5i = VADD(T4Z, T50);
					     T51 = VSUB(T4Z, T50);
					     T9r = VFNMS(LDK(KP599376933), T96, T99);
					     T9a = VFMA(LDK(KP599376933), T99, T96);
					     T9g = VFNMS(LDK(KP831469612), T9f, T9e);
					     T9M = VFMA(LDK(KP831469612), T9f, T9e);
					     {
						  V T5u, T5E, T8Y, T91;
						  T5u = VFNMS(LDK(KP995184726), T5t, T5s);
						  T5E = VFMA(LDK(KP995184726), T5t, T5s);
						  {
						       V T59, T2f, T5j, T5B;
						       T59 = VFNMS(LDK(KP995184726), T2e, T11);
						       T2f = VFMA(LDK(KP995184726), T2e, T11);
						       T5j = VFMA(LDK(KP995184726), T5i, T5h);
						       T5B = VFNMS(LDK(KP995184726), T5i, T5h);
						       {
							    V T5c, T52, T9s, T9h;
							    T5c = VFNMS(LDK(KP995184726), T51, T4Y);
							    T52 = VFMA(LDK(KP995184726), T51, T4Y);
							    T9s = VFNMS(LDK(KP599376933), T9d, T9g);
							    T9h = VFMA(LDK(KP599376933), T9g, T9d);
							    {
								 V T5A, T5y, T5I, T5G;
								 T5A = VFMA(LDK(KP740951125), T5x, T5u);
								 T5y = VFNMS(LDK(KP740951125), T5x, T5u);
								 T5I = VFMA(LDK(KP740951125), T5F, T5E);
								 T5G = VFNMS(LDK(KP740951125), T5F, T5E);
								 {
								      V T5f, T5b, T57, T4L;
								      T5f = VFMA(LDK(KP998795456), T5a, T59);
								      T5b = VFNMS(LDK(KP998795456), T5a, T59);
								      T57 = VFMA(LDK(KP998795456), T4K, T2f);
								      T4L = VFNMS(LDK(KP998795456), T4K, T2f);
								      {
									   V T5z, T5r, T5H, T5D;
									   T5z = VFMA(LDK(KP740951125), T5q, T5j);
									   T5r = VFNMS(LDK(KP740951125), T5q, T5j);
									   T5H = VFNMS(LDK(KP740951125), T5C, T5B);
									   T5D = VFMA(LDK(KP740951125), T5C, T5B);
									   {
										V T5g, T5e, T58, T56;
										T5g = VFNMS(LDK(KP998795456), T5d, T5c);
										T5e = VFMA(LDK(KP998795456), T5d, T5c);
										T58 = VFMA(LDK(KP998795456), T55, T52);
										T56 = VFNMS(LDK(KP998795456), T55, T52);
										T9y = VADD(T9r, T9s);
										T9t = VSUB(T9r, T9s);
										T9B = VSUB(T9a, T9h);
										T9i = VADD(T9a, T9h);
										ST(&(xo[WS(os, 113)]), VFMAI(T5A, T5z), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 15)]), VFNMSI(T5A, T5z), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 49)]), VFMAI(T5y, T5r), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 79)]), VFNMSI(T5y, T5r), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 111)]), VFNMSI(T5I, T5H), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 17)]), VFMAI(T5I, T5H), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 81)]), VFMAI(T5G, T5D), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 47)]), VFNMSI(T5G, T5D), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 97)]), VFMAI(T5g, T5f), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 31)]), VFNMSI(T5g, T5f), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 95)]), VFNMSI(T5e, T5b), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 33)]), VFMAI(T5e, T5b), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 1)]), VFMAI(T58, T57), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 127)]), VFNMSI(T58, T57), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 65)]), VFMAI(T56, T4L), ovs, &(xo[WS(os, 1)]));
										ST(&(xo[WS(os, 63)]), VFNMSI(T56, T4L), ovs, &(xo[WS(os, 1)]));
									   }
								      }
								 }
							    }
						       }
						  }
						  T9n = VFNMS(LDK(KP534511135), T8W, T8X);
						  T8Y = VFMA(LDK(KP534511135), T8X, T8W);
						  T91 = VFMA(LDK(KP534511135), T90, T8Z);
						  T9o = VFNMS(LDK(KP534511135), T8Z, T90);
						  {
						       V T9T, T9K, T9U, T9N;
						       T9T = VFMA(LDK(KP250486960), T9I, T9J);
						       T9K = VFNMS(LDK(KP250486960), T9J, T9I);
						       T9U = VFMA(LDK(KP250486960), T9L, T9M);
						       T9N = VFNMS(LDK(KP250486960), T9M, T9L);
						       T9F = VFNMS(LDK(KP831469612), T8U, T8T);
						       T8V = VFMA(LDK(KP831469612), T8U, T8T);
						       T9Q = VFMA(LDK(KP831469612), T9l, T9k);
						       T9m = VFNMS(LDK(KP831469612), T9l, T9k);
						       T9R = VSUB(T8Y, T91);
						       T92 = VADD(T8Y, T91);
						       Ta0 = VADD(T9T, T9U);
						       T9V = VSUB(T9T, T9U);
						       Ta3 = VSUB(T9K, T9N);
						       T9O = VADD(T9K, T9N);
						  }
					     }
					}
					{
					     V T6y, T6z, T63, T9Y, T9W, Ta6, Ta4, T9D, T9z, T9v, T9j, T6h, T60, T9H, T9Z;
					     V T9A, T9q, T66, T9X, T9P;
					     {
						  V T5W, T9S, Ta2, T9x, T93, T5Z, T9G, T9p;
						  T6y = VFMA(LDK(KP980785280), T5V, T5U);
						  T5W = VFNMS(LDK(KP980785280), T5V, T5U);
						  T9S = VFMA(LDK(KP881921264), T9R, T9Q);
						  Ta2 = VFNMS(LDK(KP881921264), T9R, T9Q);
						  T9x = VFNMS(LDK(KP881921264), T92, T8V);
						  T93 = VFMA(LDK(KP881921264), T92, T8V);
						  T5Z = VFMA(LDK(KP980785280), T5Y, T5X);
						  T6z = VFNMS(LDK(KP980785280), T5Y, T5X);
						  T6B = VFMA(LDK(KP980785280), T62, T61);
						  T63 = VFNMS(LDK(KP980785280), T62, T61);
						  T9G = VADD(T9n, T9o);
						  T9p = VSUB(T9n, T9o);
						  T9Y = VFMA(LDK(KP970031253), T9V, T9S);
						  T9W = VFNMS(LDK(KP970031253), T9V, T9S);
						  Ta6 = VFNMS(LDK(KP970031253), Ta3, Ta2);
						  Ta4 = VFMA(LDK(KP970031253), Ta3, Ta2);
						  T9D = VFNMS(LDK(KP857728610), T9y, T9x);
						  T9z = VFMA(LDK(KP857728610), T9y, T9x);
						  T9v = VFMA(LDK(KP857728610), T9i, T93);
						  T9j = VFNMS(LDK(KP857728610), T9i, T93);
						  T6h = VFMA(LDK(KP472964775), T5W, T5Z);
						  T60 = VFNMS(LDK(KP472964775), T5Z, T5W);
						  T9H = VFMA(LDK(KP881921264), T9G, T9F);
						  T9Z = VFNMS(LDK(KP881921264), T9G, T9F);
						  T9A = VFMA(LDK(KP881921264), T9p, T9m);
						  T9q = VFNMS(LDK(KP881921264), T9p, T9m);
						  T66 = VFMA(LDK(KP980785280), T65, T64);
						  T6C = VFNMS(LDK(KP980785280), T65, T64);
					     }
					     T9X = VFMA(LDK(KP970031253), T9O, T9H);
					     T9P = VFNMS(LDK(KP970031253), T9O, T9H);
					     {
						  V Ta5, Ta1, T9E, T9C;
						  Ta5 = VFMA(LDK(KP970031253), Ta0, T9Z);
						  Ta1 = VFNMS(LDK(KP970031253), Ta0, T9Z);
						  T9E = VFMA(LDK(KP857728610), T9B, T9A);
						  T9C = VFNMS(LDK(KP857728610), T9B, T9A);
						  {
						       V T9w, T9u, T6i, T67;
						       T9w = VFMA(LDK(KP857728610), T9t, T9q);
						       T9u = VFNMS(LDK(KP857728610), T9t, T9q);
						       T6i = VFMA(LDK(KP472964775), T63, T66);
						       T67 = VFNMS(LDK(KP472964775), T66, T63);
						       T6J = VFNMS(LDK(KP357805721), T6y, T6z);
						       T6A = VFMA(LDK(KP357805721), T6z, T6y);
						       ST(&(xo[WS(os, 5)]), VFMAI(T9Y, T9X), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 123)]), VFNMSI(T9Y, T9X), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 69)]), VFMAI(T9W, T9P), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 59)]), VFNMSI(T9W, T9P), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 101)]), VFMAI(Ta6, Ta5), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 27)]), VFNMSI(Ta6, Ta5), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 91)]), VFNMSI(Ta4, Ta1), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 37)]), VFMAI(Ta4, Ta1), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 107)]), VFNMSI(T9E, T9D), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 21)]), VFMAI(T9E, T9D), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 85)]), VFMAI(T9C, T9z), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 43)]), VFNMSI(T9C, T9z), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 117)]), VFMAI(T9w, T9v), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 11)]), VFNMSI(T9w, T9v), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 53)]), VFMAI(T9u, T9j), ovs, &(xo[WS(os, 1)]));
						       ST(&(xo[WS(os, 75)]), VFNMSI(T9u, T9j), ovs, &(xo[WS(os, 1)]));
						       T6o = VADD(T6h, T6i);
						       T6j = VSUB(T6h, T6i);
						       T6r = VSUB(T60, T67);
						       T68 = VADD(T60, T67);
						  }
					     }
					     T6d = VFMA(LDK(KP820678790), T5M, T5N);
					     T5O = VFNMS(LDK(KP820678790), T5N, T5M);
					     T5R = VFNMS(LDK(KP820678790), T5Q, T5P);
					     T6e = VFMA(LDK(KP820678790), T5P, T5Q);
					}
				   }
			      }
			 }
		    }
	       }
	       T6D = VFMA(LDK(KP357805721), T6C, T6B);
	       T6K = VFNMS(LDK(KP357805721), T6B, T6C);
	       {
		    V T5L, T6v, T6c, T6G;
		    T5L = VFNMS(LDK(KP980785280), T5K, T5J);
		    T6v = VFMA(LDK(KP980785280), T5K, T5J);
		    T6c = VFMA(LDK(KP980785280), T6b, T6a);
		    T6G = VFNMS(LDK(KP980785280), T6b, T6a);
		    {
			 V T5S, T6H, T6f, T6w;
			 T5S = VADD(T5O, T5R);
			 T6H = VSUB(T5O, T5R);
			 T6f = VSUB(T6d, T6e);
			 T6w = VADD(T6d, T6e);
			 {
			      V T6L, T6Q, T6E, T6T;
			      T6L = VSUB(T6J, T6K);
			      T6Q = VADD(T6J, T6K);
			      T6E = VADD(T6A, T6D);
			      T6T = VSUB(T6A, T6D);
			      {
				   V T6S, T6I, T5T, T6n;
				   T6S = VFNMS(LDK(KP773010453), T6H, T6G);
				   T6I = VFMA(LDK(KP773010453), T6H, T6G);
				   T5T = VFNMS(LDK(KP773010453), T5S, T5L);
				   T6n = VFMA(LDK(KP773010453), T5S, T5L);
				   {
					V T6P, T6x, T6g, T6q;
					T6P = VFNMS(LDK(KP773010453), T6w, T6v);
					T6x = VFMA(LDK(KP773010453), T6w, T6v);
					T6g = VFMA(LDK(KP773010453), T6f, T6c);
					T6q = VFNMS(LDK(KP773010453), T6f, T6c);
					{
					     V T6M, T6O, T6U, T6W;
					     T6M = VFNMS(LDK(KP941544065), T6L, T6I);
					     T6O = VFMA(LDK(KP941544065), T6L, T6I);
					     T6U = VFNMS(LDK(KP941544065), T6T, T6S);
					     T6W = VFMA(LDK(KP941544065), T6T, T6S);
					     {
						  V T6p, T6t, T69, T6l;
						  T6p = VFNMS(LDK(KP903989293), T6o, T6n);
						  T6t = VFMA(LDK(KP903989293), T6o, T6n);
						  T69 = VFNMS(LDK(KP903989293), T68, T5T);
						  T6l = VFMA(LDK(KP903989293), T68, T5T);
						  {
						       V T6F, T6N, T6R, T6V;
						       T6F = VFNMS(LDK(KP941544065), T6E, T6x);
						       T6N = VFMA(LDK(KP941544065), T6E, T6x);
						       T6R = VFMA(LDK(KP941544065), T6Q, T6P);
						       T6V = VFNMS(LDK(KP941544065), T6Q, T6P);
						       {
							    V T6s, T6u, T6k, T6m;
							    T6s = VFMA(LDK(KP903989293), T6r, T6q);
							    T6u = VFNMS(LDK(KP903989293), T6r, T6q);
							    T6k = VFNMS(LDK(KP903989293), T6j, T6g);
							    T6m = VFMA(LDK(KP903989293), T6j, T6g);
							    ST(&(xo[WS(os, 121)]), VFMAI(T6O, T6N), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 7)]), VFNMSI(T6O, T6N), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 57)]), VFMAI(T6M, T6F), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 71)]), VFNMSI(T6M, T6F), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 103)]), VFNMSI(T6W, T6V), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 25)]), VFMAI(T6W, T6V), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 89)]), VFMAI(T6U, T6R), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 39)]), VFNMSI(T6U, T6R), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 105)]), VFMAI(T6u, T6t), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 23)]), VFNMSI(T6u, T6t), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 87)]), VFNMSI(T6s, T6p), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 41)]), VFMAI(T6s, T6p), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 9)]), VFMAI(T6m, T6l), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 119)]), VFNMSI(T6m, T6l), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 73)]), VFMAI(T6k, T69), ovs, &(xo[WS(os, 1)]));
							    ST(&(xo[WS(os, 55)]), VFNMSI(T6k, T69), ovs, &(xo[WS(os, 1)]));
						       }
						  }
					     }
					}
				   }
			      }
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 128, XSIMD_STRING("n1bv_128"), {440, 0, 642, 0}, &GENUS, 0, 0, 0, 0 };

void XSIMD(codelet_n1bv_128) (planner *p) {
     X(kdft_register) (p, n1bv_128, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_notw_c.native -simd -compact -variables 4 -pipeline-latency 8 -sign 1 -n 128 -name n1bv_128 -include n1b.h */

/*
 * This function contains 1082 FP additions, 330 FP multiplications,
 * (or, 938 additions, 186 multiplications, 144 fused multiply/add),
 * 194 stack variables, 31 constants, and 256 memory accesses
 */
#include "n1b.h"

static void n1bv_128(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP146730474, +0.146730474455361751658850129646717819706215317);
     DVK(KP989176509, +0.989176509964780973451673738016243063983689533);
     DVK(KP595699304, +0.595699304492433343467036528829969889511926338);
     DVK(KP803207531, +0.803207531480644909806676512963141923879569427);
     DVK(KP049067674, +0.049067674327418014254954976942682658314745363);
     DVK(KP998795456, +0.998795456205172392714771604759100694443203615);
     DVK(KP671558954, +0.671558954847018400625376850427421803228750632);
     DVK(KP740951125, +0.740951125354959091175616897495162729728955309);
     DVK(KP514102744, +0.514102744193221726593693838968815772608049120);
     DVK(KP857728610, +0.857728610000272069902269984284770137042490799);
     DVK(KP242980179, +0.242980179903263889948274162077471118320990783);
     DVK(KP970031253, +0.970031253194543992603984207286100251456865962);
     DVK(KP427555093, +0.427555093430282094320966856888798534304578629);
     DVK(KP903989293, +0.903989293123443331586200297230537048710132025);
     DVK(KP336889853, +0.336889853392220050689253212619147570477766780);
     DVK(KP941544065, +0.941544065183020778412509402599502357185589796);
     DVK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  const R *xi;
	  R *xo;
	  xi = ii;
	  xo = io;
	  for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs), MAKE_VOLATILE_STRIDE(256, is), MAKE_VOLATILE_STRIDE(256, os)) {
	       V T49, T6e, Tev, TgK, TfA, TgL, T4U, T5J, T7R, T9o, Tah, TdG, Tcw, TdB, T84;
	       V T8T, Tfk, Tfo, T1G, T64, Tgs, Th6, T2p, T62, T7t, T9c, Tce, Tdm, T7i, T9e;
	       V Tc8, Tdp, TgF, TgG, T4q, T4V, TeC, Tfx, T4H, T4W, T7X, T86, Tcr, TdH, T7U;
	       V T85, Taw, TdC, Tf3, Tf7, Tr, T5X, Tgl, Th3, T1a, T5V, T7a, T95, TbD, Tdf;
	       V T6Z, T97, Tbx, Tdi, Tgy, Tgz, TgA, TaN, Tdv, TeK, Tfu, T2W, T5M, T35, T5N;
	       V T7F, T8X, TaI, Tdu, T7C, T8W, TgB, TgC, TgD, Tb4, Tdy, TeR, Tfv, T3x, T5P;
	       V T3G, T5Q, T7M, T90, TaZ, Tdx, T7J, T8Z, Tbm, Tdg, TbG, Tdj, Tgo, Th4, Tf0;
	       V Tf8, T76, T98, T7d, T94, T10, T5Y, T1d, T5U, TbX, Tdn, Tch, Tdq, Tgv, Th7;
	       V Tfh, Tfp, T7p, T9f, T7w, T9b, T2f, T65, T2s, T61;
	       {
		    V T47, Ta8, T4O, Ta7, T44, Tcu, T4P, Tct, Taa, Tab, T3P, Tac, T4R, Tad, Tae;
		    V T3W, Taf, T4S;
		    {
			 V T45, T46, T4M, T4N;
			 T45 = LD(&(xi[WS(is, 32)]), ivs, &(xi[0]));
			 T46 = LD(&(xi[WS(is, 96)]), ivs, &(xi[0]));
			 T47 = VSUB(T45, T46);
			 Ta8 = VADD(T45, T46);
			 T4M = LD(&(xi[0]), ivs, &(xi[0]));
			 T4N = LD(&(xi[WS(is, 64)]), ivs, &(xi[0]));
			 T4O = VSUB(T4M, T4N);
			 Ta7 = VADD(T4M, T4N);
		    }
		    {
			 V T3Y, T3Z, T40, T41, T42, T43;
			 T3Y = LD(&(xi[WS(is, 16)]), ivs, &(xi[0]));
			 T3Z = LD(&(xi[WS(is, 80)]), ivs, &(xi[0]));
			 T40 = VSUB(T3Y, T3Z);
			 T41 = LD(&(xi[WS(is, 112)]), ivs, &(xi[0]));
			 T42 = LD(&(xi[WS(is, 48)]), ivs, &(xi[0]));
			 T43 = VSUB(T41, T42);
			 T44 = VMUL(LDK(KP707106781), VSUB(T40, T43));
			 Tcu = VADD(T41, T42);
			 T4P = VMUL(LDK(KP707106781), VADD(T40, T43));
			 Tct = VADD(T3Y, T3Z);
		    }
		    {
			 V T3L, T3O, T3S, T3V;
			 {
			      V T3J, T3K, T3M, T3N;
			      T3J = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
			      T3K = LD(&(xi[WS(is, 72)]), ivs, &(xi[0]));
			      T3L = VSUB(T3J, T3K);
			      Taa = VADD(T3J, T3K);
			      T3M = LD(&(xi[WS(is, 40)]), ivs, &(xi[0]));
			      T3N = LD(&(xi[WS(is, 104)]), ivs, &(xi[0]));
			      T3O = VSUB(T3M, T3N);
			      Tab = VADD(T3M, T3N);
			 }
			 T3P = VFNMS(LDK(KP382683432), T3O, VMUL(LDK(KP923879532), T3L));
			 Tac = VSUB(Taa, Tab);
			 T4R = VFMA(LDK(KP382683432), T3L, VMUL(LDK(KP923879532), T3O));
			 {
			      V T3Q, T3R, T3T, T3U;
			      T3Q = LD(&(xi[WS(is, 120)]), ivs, &(xi[0]));
			      T3R = LD(&(xi[WS(is, 56)]), ivs, &(xi[0]));
			      T3S = VSUB(T3Q, T3R);
			      Tad = VADD(T3Q, T3R);
			      T3T = LD(&(xi[WS(is, 24)]), ivs, &(xi[0]));
			      T3U = LD(&(xi[WS(is, 88)]), ivs, &(xi[0]));
			      T3V = VSUB(T3T, T3U);
			      Tae = VADD(T3T, T3U);
			 }
			 T3W = VFMA(LDK(KP923879532), T3S, VMUL(LDK(KP382683432), T3V));
			 Taf = VSUB(Tad, Tae);
			 T4S = VFNMS(LDK(KP382683432), T3S, VMUL(LDK(KP923879532), T3V));
		    }
		    {
			 V T3X, T48, Tet, Teu;
			 T3X = VSUB(T3P, T3W);
			 T48 = VSUB(T44, T47);
			 T49 = VSUB(T3X, T48);
			 T6e = VADD(T48, T3X);
			 Tet = VADD(Ta7, Ta8);
			 Teu = VADD(Tct, Tcu);
			 Tev = VSUB(Tet, Teu);
			 TgK = VADD(Tet, Teu);
		    }
		    {
			 V Tfy, Tfz, T4Q, T4T;
			 Tfy = VADD(Taa, Tab);
			 Tfz = VADD(Tad, Tae);
			 TfA = VSUB(Tfy, Tfz);
			 TgL = VADD(Tfy, Tfz);
			 T4Q = VSUB(T4O, T4P);
			 T4T = VSUB(T4R, T4S);
			 T4U = VSUB(T4Q, T4T);
			 T5J = VADD(T4Q, T4T);
		    }
		    {
			 V T7P, T7Q, Ta9, Tag;
			 T7P = VADD(T4R, T4S);
			 T7Q = VADD(T47, T44);
			 T7R = VSUB(T7P, T7Q);
			 T9o = VADD(T7Q, T7P);
			 Ta9 = VSUB(Ta7, Ta8);
			 Tag = VMUL(LDK(KP707106781), VADD(Tac, Taf));
			 Tah = VSUB(Ta9, Tag);
			 TdG = VADD(Ta9, Tag);
		    }
		    {
			 V Tcs, Tcv, T82, T83;
			 Tcs = VMUL(LDK(KP707106781), VSUB(Tac, Taf));
			 Tcv = VSUB(Tct, Tcu);
			 Tcw = VSUB(Tcs, Tcv);
			 TdB = VADD(Tcv, Tcs);
			 T82 = VADD(T4O, T4P);
			 T83 = VADD(T3P, T3W);
			 T84 = VSUB(T82, T83);
			 T8T = VADD(T82, T83);
		    }
	       }
	       {
		    V Tca, Tcb, T1i, Tfm, T2n, Tc5, Tc6, T1p, Tfn, T2k, T1x, Tfi, T2h, Tc0, T1E;
		    V Tfj, T2i, Tc3, T1l, T1o, Tcc, Tcd;
		    {
			 V T1g, T1h, T2l, T2m;
			 T1g = LD(&(xi[WS(is, 127)]), ivs, &(xi[WS(is, 1)]));
			 T1h = LD(&(xi[WS(is, 63)]), ivs, &(xi[WS(is, 1)]));
			 Tca = VADD(T1g, T1h);
			 T2l = LD(&(xi[WS(is, 31)]), ivs, &(xi[WS(is, 1)]));
			 T2m = LD(&(xi[WS(is, 95)]), ivs, &(xi[WS(is, 1)]));
			 Tcb = VADD(T2l, T2m);
			 T1i = VSUB(T1g, T1h);
			 Tfm = VADD(Tca, Tcb);
			 T2n = VSUB(T2l, T2m);
		    }
		    {
			 V T1j, T1k, T1m, T1n;
			 T1j = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
			 T1k = LD(&(xi[WS(is, 79)]), ivs, &(xi[WS(is, 1)]));
			 T1l = VSUB(T1j, T1k);
			 Tc5 = VADD(T1j, T1k);
			 T1m = LD(&(xi[WS(is, 111)]), ivs, &(xi[WS(is, 1)]));
			 T1n = LD(&(xi[WS(is, 47)]), ivs, &(xi[WS(is, 1)]));
			 T1o = VSUB(T1m, T1n);
			 Tc6 = VADD(T1m, T1n);
		    }
		    T1p = VMUL(LDK(KP707106781), VADD(T1l, T1o));
		    Tfn = VADD(Tc5, Tc6);
		    T2k = VMUL(LDK(KP707106781), VSUB(T1l, T1o));
		    {
			 V T1t, TbY, T1w, TbZ;
			 {
			      V T1r, T1s, T1u, T1v;
			      T1r = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
			      T1s = LD(&(xi[WS(is, 71)]), ivs, &(xi[WS(is, 1)]));
			      T1t = VSUB(T1r, T1s);
			      TbY = VADD(T1r, T1s);
			      T1u = LD(&(xi[WS(is, 39)]), ivs, &(xi[WS(is, 1)]));
			      T1v = LD(&(xi[WS(is, 103)]), ivs, &(xi[WS(is, 1)]));
			      T1w = VSUB(T1u, T1v);
			      TbZ = VADD(T1u, T1v);
			 }
			 T1x = VFMA(LDK(KP382683432), T1t, VMUL(LDK(KP923879532), T1w));
			 Tfi = VADD(TbY, TbZ);
			 T2h = VFNMS(LDK(KP382683432), T1w, VMUL(LDK(KP923879532), T1t));
			 Tc0 = VSUB(TbY, TbZ);
		    }
		    {
			 V T1A, Tc2, T1D, Tc1;
			 {
			      V T1y, T1z, T1B, T1C;
			      T1y = LD(&(xi[WS(is, 23)]), ivs, &(xi[WS(is, 1)]));
			      T1z = LD(&(xi[WS(is, 87)]), ivs, &(xi[WS(is, 1)]));
			      T1A = VSUB(T1y, T1z);
			      Tc2 = VADD(T1y, T1z);
			      T1B = LD(&(xi[WS(is, 119)]), ivs, &(xi[WS(is, 1)]));
			      T1C = LD(&(xi[WS(is, 55)]), ivs, &(xi[WS(is, 1)]));
			      T1D = VSUB(T1B, T1C);
			      Tc1 = VADD(T1B, T1C);
			 }
			 T1E = VFNMS(LDK(KP382683432), T1D, VMUL(LDK(KP923879532), T1A));
			 Tfj = VADD(Tc1, Tc2);
			 T2i = VFMA(LDK(KP923879532), T1D, VMUL(LDK(KP382683432), T1A));
			 Tc3 = VSUB(Tc1, Tc2);
		    }
		    Tfk = VSUB(Tfi, Tfj);
		    Tfo = VSUB(Tfm, Tfn);
		    {
			 V T1q, T1F, Tgq, Tgr;
			 T1q = VSUB(T1i, T1p);
			 T1F = VSUB(T1x, T1E);
			 T1G = VSUB(T1q, T1F);
			 T64 = VADD(T1q, T1F);
			 Tgq = VADD(Tfm, Tfn);
			 Tgr = VADD(Tfi, Tfj);
			 Tgs = VSUB(Tgq, Tgr);
			 Th6 = VADD(Tgq, Tgr);
		    }
		    {
			 V T2j, T2o, T7r, T7s;
			 T2j = VSUB(T2h, T2i);
			 T2o = VSUB(T2k, T2n);
			 T2p = VSUB(T2j, T2o);
			 T62 = VADD(T2o, T2j);
			 T7r = VADD(T1x, T1E);
			 T7s = VADD(T2n, T2k);
			 T7t = VSUB(T7r, T7s);
			 T9c = VADD(T7s, T7r);
		    }
		    Tcc = VSUB(Tca, Tcb);
		    Tcd = VMUL(LDK(KP707106781), VADD(Tc0, Tc3));
		    Tce = VSUB(Tcc, Tcd);
		    Tdm = VADD(Tcc, Tcd);
		    {
			 V T7g, T7h, Tc4, Tc7;
			 T7g = VADD(T1i, T1p);
			 T7h = VADD(T2h, T2i);
			 T7i = VSUB(T7g, T7h);
			 T9e = VADD(T7g, T7h);
			 Tc4 = VMUL(LDK(KP707106781), VSUB(Tc0, Tc3));
			 Tc7 = VSUB(Tc5, Tc6);
			 Tc8 = VSUB(Tc4, Tc7);
			 Tdp = VADD(Tc7, Tc4);
		    }
	       }
	       {
		    V T4c, Tew, T4o, Tak, T4A, Tez, T4E, Tau, T4j, Tex, T4l, Tan, T4x, TeA, T4F;
		    V Tar, Tcp, Tcq;
		    {
			 V T4a, T4b, Tai, T4m, T4n, Taj;
			 T4a = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
			 T4b = LD(&(xi[WS(is, 68)]), ivs, &(xi[0]));
			 Tai = VADD(T4a, T4b);
			 T4m = LD(&(xi[WS(is, 36)]), ivs, &(xi[0]));
			 T4n = LD(&(xi[WS(is, 100)]), ivs, &(xi[0]));
			 Taj = VADD(T4m, T4n);
			 T4c = VSUB(T4a, T4b);
			 Tew = VADD(Tai, Taj);
			 T4o = VSUB(T4m, T4n);
			 Tak = VSUB(Tai, Taj);
		    }
		    {
			 V T4y, T4z, Tat, T4C, T4D, Tas;
			 T4y = LD(&(xi[WS(is, 28)]), ivs, &(xi[0]));
			 T4z = LD(&(xi[WS(is, 92)]), ivs, &(xi[0]));
			 Tat = VADD(T4y, T4z);
			 T4C = LD(&(xi[WS(is, 124)]), ivs, &(xi[0]));
			 T4D = LD(&(xi[WS(is, 60)]), ivs, &(xi[0]));
			 Tas = VADD(T4C, T4D);
			 T4A = VSUB(T4y, T4z);
			 Tez = VADD(Tas, Tat);
			 T4E = VSUB(T4C, T4D);
			 Tau = VSUB(Tas, Tat);
		    }
		    {
			 V T4f, Tal, T4i, Tam;
			 {
			      V T4d, T4e, T4g, T4h;
			      T4d = LD(&(xi[WS(is, 20)]), ivs, &(xi[0]));
			      T4e = LD(&(xi[WS(is, 84)]), ivs, &(xi[0]));
			      T4f = VSUB(T4d, T4e);
			      Tal = VADD(T4d, T4e);
			      T4g = LD(&(xi[WS(is, 116)]), ivs, &(xi[0]));
			      T4h = LD(&(xi[WS(is, 52)]), ivs, &(xi[0]));
			      T4i = VSUB(T4g, T4h);
			      Tam = VADD(T4g, T4h);
			 }
			 T4j = VMUL(LDK(KP707106781), VADD(T4f, T4i));
			 Tex = VADD(Tal, Tam);
			 T4l = VMUL(LDK(KP707106781), VSUB(T4f, T4i));
			 Tan = VSUB(Tal, Tam);
		    }
		    {
			 V T4t, Tap, T4w, Taq;
			 {
			      V T4r, T4s, T4u, T4v;
			      T4r = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
			      T4s = LD(&(xi[WS(is, 76)]), ivs, &(xi[0]));
			      T4t = VSUB(T4r, T4s);
			      Tap = VADD(T4r, T4s);
			      T4u = LD(&(xi[WS(is, 108)]), ivs, &(xi[0]));
			      T4v = LD(&(xi[WS(is, 44)]), ivs, &(xi[0]));
			      T4w = VSUB(T4u, T4v);
			      Taq = VADD(T4u, T4v);
			 }
			 T4x = VMUL(LDK(KP707106781), VSUB(T4t, T4w));
			 TeA = VADD(Tap, Taq);
			 T4F = VMUL(LDK(KP707106781), VADD(T4t, T4w));
			 Tar = VSUB(Tap, Taq);
		    }
		    TgF = VADD(Tew, Tex);
		    TgG = VADD(Tez, TeA);
		    {
			 V T4k, T4p, Tey, TeB;
			 T4k = VSUB(T4c, T4j);
			 T4p = VSUB(T4l, T4o);
			 T4q = VFNMS(LDK(KP555570233), T4p, VMUL(LDK(KP831469612), T4k));
			 T4V = VFMA(LDK(KP831469612), T4p, VMUL(LDK(KP555570233), T4k));
			 Tey = VSUB(Tew, Tex);
			 TeB = VSUB(Tez, TeA);
			 TeC = VMUL(LDK(KP707106781), VADD(Tey, TeB));
			 Tfx = VMUL(LDK(KP707106781), VSUB(Tey, TeB));
		    }
		    {
			 V T4B, T4G, T7V, T7W;
			 T4B = VSUB(T4x, T4A);
			 T4G = VSUB(T4E, T4F);
			 T4H = VFMA(LDK(KP555570233), T4B, VMUL(LDK(KP831469612), T4G));
			 T4W = VFNMS(LDK(KP555570233), T4G, VMUL(LDK(KP831469612), T4B));
			 T7V = VADD(T4A, T4x);
			 T7W = VADD(T4E, T4F);
			 T7X = VFMA(LDK(KP195090322), T7V, VMUL(LDK(KP980785280), T7W));
			 T86 = VFNMS(LDK(KP195090322), T7W, VMUL(LDK(KP980785280), T7V));
		    }
		    Tcp = VFNMS(LDK(KP382683432), Tan, VMUL(LDK(KP923879532), Tak));
		    Tcq = VFMA(LDK(KP923879532), Tau, VMUL(LDK(KP382683432), Tar));
		    Tcr = VSUB(Tcp, Tcq);
		    TdH = VADD(Tcp, Tcq);
		    {
			 V T7S, T7T, Tao, Tav;
			 T7S = VADD(T4c, T4j);
			 T7T = VADD(T4o, T4l);
			 T7U = VFNMS(LDK(KP195090322), T7T, VMUL(LDK(KP980785280), T7S));
			 T85 = VFMA(LDK(KP980785280), T7T, VMUL(LDK(KP195090322), T7S));
			 Tao = VFMA(LDK(KP382683432), Tak, VMUL(LDK(KP923879532), Tan));
			 Tav = VFNMS(LDK(KP382683432), Tau, VMUL(LDK(KP923879532), Tar));
			 Taw = VSUB(Tao, Tav);
			 TdC = VADD(Tao, Tav);
		    }
	       }
	       {
		    V Tbz, TbA, T3, Tf5, T18, Tbu, Tbv, Ta, Tf6, T15, Ti, Tf1, T12, Tbp, Tp;
		    V Tf2, T13, Tbs, T6, T9, TbB, TbC;
		    {
			 V T1, T2, T16, T17;
			 T1 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
			 T2 = LD(&(xi[WS(is, 65)]), ivs, &(xi[WS(is, 1)]));
			 Tbz = VADD(T1, T2);
			 T16 = LD(&(xi[WS(is, 33)]), ivs, &(xi[WS(is, 1)]));
			 T17 = LD(&(xi[WS(is, 97)]), ivs, &(xi[WS(is, 1)]));
			 TbA = VADD(T16, T17);
			 T3 = VSUB(T1, T2);
			 Tf5 = VADD(Tbz, TbA);
			 T18 = VSUB(T16, T17);
		    }
		    {
			 V T4, T5, T7, T8;
			 T4 = LD(&(xi[WS(is, 17)]), ivs, &(xi[WS(is, 1)]));
			 T5 = LD(&(xi[WS(is, 81)]), ivs, &(xi[WS(is, 1)]));
			 T6 = VSUB(T4, T5);
			 Tbu = VADD(T4, T5);
			 T7 = LD(&(xi[WS(is, 113)]), ivs, &(xi[WS(is, 1)]));
			 T8 = LD(&(xi[WS(is, 49)]), ivs, &(xi[WS(is, 1)]));
			 T9 = VSUB(T7, T8);
			 Tbv = VADD(T7, T8);
		    }
		    Ta = VMUL(LDK(KP707106781), VADD(T6, T9));
		    Tf6 = VADD(Tbu, Tbv);
		    T15 = VMUL(LDK(KP707106781), VSUB(T6, T9));
		    {
			 V Te, Tbn, Th, Tbo;
			 {
			      V Tc, Td, Tf, Tg;
			      Tc = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
			      Td = LD(&(xi[WS(is, 73)]), ivs, &(xi[WS(is, 1)]));
			      Te = VSUB(Tc, Td);
			      Tbn = VADD(Tc, Td);
			      Tf = LD(&(xi[WS(is, 41)]), ivs, &(xi[WS(is, 1)]));
			      Tg = LD(&(xi[WS(is, 105)]), ivs, &(xi[WS(is, 1)]));
			      Th = VSUB(Tf, Tg);
			      Tbo = VADD(Tf, Tg);
			 }
			 Ti = VFMA(LDK(KP382683432), Te, VMUL(LDK(KP923879532), Th));
			 Tf1 = VADD(Tbn, Tbo);
			 T12 = VFNMS(LDK(KP382683432), Th, VMUL(LDK(KP923879532), Te));
			 Tbp = VSUB(Tbn, Tbo);
		    }
		    {
			 V Tl, Tbr, To, Tbq;
			 {
			      V Tj, Tk, Tm, Tn;
			      Tj = LD(&(xi[WS(is, 25)]), ivs, &(xi[WS(is, 1)]));
			      Tk = LD(&(xi[WS(is, 89)]), ivs, &(xi[WS(is, 1)]));
			      Tl = VSUB(Tj, Tk);
			      Tbr = VADD(Tj, Tk);
			      Tm = LD(&(xi[WS(is, 121)]), ivs, &(xi[WS(is, 1)]));
			      Tn = LD(&(xi[WS(is, 57)]), ivs, &(xi[WS(is, 1)]));
			      To = VSUB(Tm, Tn);
			      Tbq = VADD(Tm, Tn);
			 }
			 Tp = VFNMS(LDK(KP382683432), To, VMUL(LDK(KP923879532), Tl));
			 Tf2 = VADD(Tbq, Tbr);
			 T13 = VFMA(LDK(KP923879532), To, VMUL(LDK(KP382683432), Tl));
			 Tbs = VSUB(Tbq, Tbr);
		    }
		    Tf3 = VSUB(Tf1, Tf2);
		    Tf7 = VSUB(Tf5, Tf6);
		    {
			 V Tb, Tq, Tgj, Tgk;
			 Tb = VSUB(T3, Ta);
			 Tq = VSUB(Ti, Tp);
			 Tr = VSUB(Tb, Tq);
			 T5X = VADD(Tb, Tq);
			 Tgj = VADD(Tf5, Tf6);
			 Tgk = VADD(Tf1, Tf2);
			 Tgl = VSUB(Tgj, Tgk);
			 Th3 = VADD(Tgj, Tgk);
		    }
		    {
			 V T14, T19, T78, T79;
			 T14 = VSUB(T12, T13);
			 T19 = VSUB(T15, T18);
			 T1a = VSUB(T14, T19);
			 T5V = VADD(T19, T14);
			 T78 = VADD(Ti, Tp);
			 T79 = VADD(T18, T15);
			 T7a = VSUB(T78, T79);
			 T95 = VADD(T79, T78);
		    }
		    TbB = VSUB(Tbz, TbA);
		    TbC = VMUL(LDK(KP707106781), VADD(Tbp, Tbs));
		    TbD = VSUB(TbB, TbC);
		    Tdf = VADD(TbB, TbC);
		    {
			 V T6X, T6Y, Tbt, Tbw;
			 T6X = VADD(T3, Ta);
			 T6Y = VADD(T12, T13);
			 T6Z = VSUB(T6X, T6Y);
			 T97 = VADD(T6X, T6Y);
			 Tbt = VMUL(LDK(KP707106781), VSUB(Tbp, Tbs));
			 Tbw = VSUB(Tbu, Tbv);
			 Tbx = VSUB(Tbt, Tbw);
			 Tdi = VADD(Tbw, Tbt);
		    }
	       }
	       {
		    V TaK, TaJ, T2U, TeE, T2Z, TaF, TaG, T2R, TeF, T30, T2C, TeH, T32, TaA, T2J;
		    V TeI, T33, TaD, T2N, T2Q, TaL, TaM;
		    {
			 V T2S, T2T, T2X, T2Y;
			 T2S = LD(&(xi[WS(is, 34)]), ivs, &(xi[0]));
			 T2T = LD(&(xi[WS(is, 98)]), ivs, &(xi[0]));
			 TaK = VADD(T2S, T2T);
			 T2X = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
			 T2Y = LD(&(xi[WS(is, 66)]), ivs, &(xi[0]));
			 TaJ = VADD(T2X, T2Y);
			 T2U = VSUB(T2S, T2T);
			 TeE = VADD(TaJ, TaK);
			 T2Z = VSUB(T2X, T2Y);
		    }
		    {
			 V T2L, T2M, T2O, T2P;
			 T2L = LD(&(xi[WS(is, 18)]), ivs, &(xi[0]));
			 T2M = LD(&(xi[WS(is, 82)]), ivs, &(xi[0]));
			 T2N = VSUB(T2L, T2M);
			 TaF = VADD(T2L, T2M);
			 T2O = LD(&(xi[WS(is, 114)]), ivs, &(xi[0]));
			 T2P = LD(&(xi[WS(is, 50)]), ivs, &(xi[0]));
			 T2Q = VSUB(T2O, T2P);
			 TaG = VADD(T2O, T2P);
		    }
		    T2R = VMUL(LDK(KP707106781), VSUB(T2N, T2Q));
		    TeF = VADD(TaF, TaG);
		    T30 = VMUL(LDK(KP707106781), VADD(T2N, T2Q));
		    {
			 V T2y, Tay, T2B, Taz;
			 {
			      V T2w, T2x, T2z, T2A;
			      T2w = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
			      T2x = LD(&(xi[WS(is, 74)]), ivs, &(xi[0]));
			      T2y = VSUB(T2w, T2x);
			      Tay = VADD(T2w, T2x);
			      T2z = LD(&(xi[WS(is, 42)]), ivs, &(xi[0]));
			      T2A = LD(&(xi[WS(is, 106)]), ivs, &(xi[0]));
			      T2B = VSUB(T2z, T2A);
			      Taz = VADD(T2z, T2A);
			 }
			 T2C = VFNMS(LDK(KP382683432), T2B, VMUL(LDK(KP923879532), T2y));
			 TeH = VADD(Tay, Taz);
			 T32 = VFMA(LDK(KP382683432), T2y, VMUL(LDK(KP923879532), T2B));
			 TaA = VSUB(Tay, Taz);
		    }
		    {
			 V T2F, TaB, T2I, TaC;
			 {
			      V T2D, T2E, T2G, T2H;
			      T2D = LD(&(xi[WS(is, 122)]), ivs, &(xi[0]));
			      T2E = LD(&(xi[WS(is, 58)]), ivs, &(xi[0]));
			      T2F = VSUB(T2D, T2E);
			      TaB = VADD(T2D, T2E);
			      T2G = LD(&(xi[WS(is, 26)]), ivs, &(xi[0]));
			      T2H = LD(&(xi[WS(is, 90)]), ivs, &(xi[0]));
			      T2I = VSUB(T2G, T2H);
			      TaC = VADD(T2G, T2H);
			 }
			 T2J = VFMA(LDK(KP923879532), T2F, VMUL(LDK(KP382683432), T2I));
			 TeI = VADD(TaB, TaC);
			 T33 = VFNMS(LDK(KP382683432), T2F, VMUL(LDK(KP923879532), T2I));
			 TaD = VSUB(TaB, TaC);
		    }
		    Tgy = VADD(TeE, TeF);
		    Tgz = VADD(TeH, TeI);
		    TgA = VSUB(Tgy, Tgz);
		    TaL = VSUB(TaJ, TaK);
		    TaM = VMUL(LDK(KP707106781), VADD(TaA, TaD));
		    TaN = VSUB(TaL, TaM);
		    Tdv = VADD(TaL, TaM);
		    {
			 V TeG, TeJ, T2K, T2V;
			 TeG = VSUB(TeE, TeF);
			 TeJ = VSUB(TeH, TeI);
			 TeK = VFMA(LDK(KP382683432), TeG, VMUL(LDK(KP923879532), TeJ));
			 Tfu = VFNMS(LDK(KP382683432), TeJ, VMUL(LDK(KP923879532), TeG));
			 T2K = VSUB(T2C, T2J);
			 T2V = VSUB(T2R, T2U);
			 T2W = VSUB(T2K, T2V);
			 T5M = VADD(T2V, T2K);
		    }
		    {
			 V T31, T34, T7D, T7E;
			 T31 = VSUB(T2Z, T30);
			 T34 = VSUB(T32, T33);
			 T35 = VSUB(T31, T34);
			 T5N = VADD(T31, T34);
			 T7D = VADD(T32, T33);
			 T7E = VADD(T2U, T2R);
			 T7F = VSUB(T7D, T7E);
			 T8X = VADD(T7E, T7D);
		    }
		    {
			 V TaE, TaH, T7A, T7B;
			 TaE = VMUL(LDK(KP707106781), VSUB(TaA, TaD));
			 TaH = VSUB(TaF, TaG);
			 TaI = VSUB(TaE, TaH);
			 Tdu = VADD(TaH, TaE);
			 T7A = VADD(T2Z, T30);
			 T7B = VADD(T2C, T2J);
			 T7C = VSUB(T7A, T7B);
			 T8W = VADD(T7A, T7B);
		    }
	       }
	       {
		    V Tb1, Tb0, T3v, TeO, T3A, TaW, TaX, T3s, TeP, T3B, T3d, TeL, T3D, TaR, T3k;
		    V TeM, T3E, TaU, T3o, T3r, Tb2, Tb3;
		    {
			 V T3t, T3u, T3y, T3z;
			 T3t = LD(&(xi[WS(is, 30)]), ivs, &(xi[0]));
			 T3u = LD(&(xi[WS(is, 94)]), ivs, &(xi[0]));
			 Tb1 = VADD(T3t, T3u);
			 T3y = LD(&(xi[WS(is, 126)]), ivs, &(xi[0]));
			 T3z = LD(&(xi[WS(is, 62)]), ivs, &(xi[0]));
			 Tb0 = VADD(T3y, T3z);
			 T3v = VSUB(T3t, T3u);
			 TeO = VADD(Tb0, Tb1);
			 T3A = VSUB(T3y, T3z);
		    }
		    {
			 V T3m, T3n, T3p, T3q;
			 T3m = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
			 T3n = LD(&(xi[WS(is, 78)]), ivs, &(xi[0]));
			 T3o = VSUB(T3m, T3n);
			 TaW = VADD(T3m, T3n);
			 T3p = LD(&(xi[WS(is, 110)]), ivs, &(xi[0]));
			 T3q = LD(&(xi[WS(is, 46)]), ivs, &(xi[0]));
			 T3r = VSUB(T3p, T3q);
			 TaX = VADD(T3p, T3q);
		    }
		    T3s = VMUL(LDK(KP707106781), VSUB(T3o, T3r));
		    TeP = VADD(TaW, TaX);
		    T3B = VMUL(LDK(KP707106781), VADD(T3o, T3r));
		    {
			 V T39, TaP, T3c, TaQ;
			 {
			      V T37, T38, T3a, T3b;
			      T37 = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
			      T38 = LD(&(xi[WS(is, 70)]), ivs, &(xi[0]));
			      T39 = VSUB(T37, T38);
			      TaP = VADD(T37, T38);
			      T3a = LD(&(xi[WS(is, 38)]), ivs, &(xi[0]));
			      T3b = LD(&(xi[WS(is, 102)]), ivs, &(xi[0]));
			      T3c = VSUB(T3a, T3b);
			      TaQ = VADD(T3a, T3b);
			 }
			 T3d = VFNMS(LDK(KP382683432), T3c, VMUL(LDK(KP923879532), T39));
			 TeL = VADD(TaP, TaQ);
			 T3D = VFMA(LDK(KP382683432), T39, VMUL(LDK(KP923879532), T3c));
			 TaR = VSUB(TaP, TaQ);
		    }
		    {
			 V T3g, TaS, T3j, TaT;
			 {
			      V T3e, T3f, T3h, T3i;
			      T3e = LD(&(xi[WS(is, 118)]), ivs, &(xi[0]));
			      T3f = LD(&(xi[WS(is, 54)]), ivs, &(xi[0]));
			      T3g = VSUB(T3e, T3f);
			      TaS = VADD(T3e, T3f);
			      T3h = LD(&(xi[WS(is, 22)]), ivs, &(xi[0]));
			      T3i = LD(&(xi[WS(is, 86)]), ivs, &(xi[0]));
			      T3j = VSUB(T3h, T3i);
			      TaT = VADD(T3h, T3i);
			 }
			 T3k = VFMA(LDK(KP923879532), T3g, VMUL(LDK(KP382683432), T3j));
			 TeM = VADD(TaS, TaT);
			 T3E = VFNMS(LDK(KP382683432), T3g, VMUL(LDK(KP923879532), T3j));
			 TaU = VSUB(TaS, TaT);
		    }
		    TgB = VADD(TeO, TeP);
		    TgC = VADD(TeL, TeM);
		    TgD = VSUB(TgB, TgC);
		    Tb2 = VSUB(Tb0, Tb1);
		    Tb3 = VMUL(LDK(KP707106781), VADD(TaR, TaU));
		    Tb4 = VSUB(Tb2, Tb3);
		    Tdy = VADD(Tb2, Tb3);
		    {
			 V TeN, TeQ, T3l, T3w;
			 TeN = VSUB(TeL, TeM);
			 TeQ = VSUB(TeO, TeP);
			 TeR = VFNMS(LDK(KP382683432), TeQ, VMUL(LDK(KP923879532), TeN));
			 Tfv = VFMA(LDK(KP923879532), TeQ, VMUL(LDK(KP382683432), TeN));
			 T3l = VSUB(T3d, T3k);
			 T3w = VSUB(T3s, T3v);
			 T3x = VSUB(T3l, T3w);
			 T5P = VADD(T3w, T3l);
		    }
		    {
			 V T3C, T3F, T7K, T7L;
			 T3C = VSUB(T3A, T3B);
			 T3F = VSUB(T3D, T3E);
			 T3G = VSUB(T3C, T3F);
			 T5Q = VADD(T3C, T3F);
			 T7K = VADD(T3A, T3B);
			 T7L = VADD(T3d, T3k);
			 T7M = VSUB(T7K, T7L);
			 T90 = VADD(T7K, T7L);
		    }
		    {
			 V TaV, TaY, T7H, T7I;
			 TaV = VMUL(LDK(KP707106781), VSUB(TaR, TaU));
			 TaY = VSUB(TaW, TaX);
			 TaZ = VSUB(TaV, TaY);
			 Tdx = VADD(TaY, TaV);
			 T7H = VADD(T3D, T3E);
			 T7I = VADD(T3v, T3s);
			 T7J = VSUB(T7H, T7I);
			 T8Z = VADD(T7I, T7H);
		    }
	       }
	       {
		    V TB, TeU, TF, Tba, TS, TeX, TW, Tbh, Ty, TeV, TG, Tbd, TP, TeY, TX;
		    V Tbk;
		    {
			 V Tz, TA, Tb9, TD, TE, Tb8;
			 Tz = LD(&(xi[WS(is, 37)]), ivs, &(xi[WS(is, 1)]));
			 TA = LD(&(xi[WS(is, 101)]), ivs, &(xi[WS(is, 1)]));
			 Tb9 = VADD(Tz, TA);
			 TD = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
			 TE = LD(&(xi[WS(is, 69)]), ivs, &(xi[WS(is, 1)]));
			 Tb8 = VADD(TD, TE);
			 TB = VSUB(Tz, TA);
			 TeU = VADD(Tb8, Tb9);
			 TF = VSUB(TD, TE);
			 Tba = VSUB(Tb8, Tb9);
		    }
		    {
			 V TQ, TR, Tbg, TU, TV, Tbf;
			 TQ = LD(&(xi[WS(is, 29)]), ivs, &(xi[WS(is, 1)]));
			 TR = LD(&(xi[WS(is, 93)]), ivs, &(xi[WS(is, 1)]));
			 Tbg = VADD(TQ, TR);
			 TU = LD(&(xi[WS(is, 125)]), ivs, &(xi[WS(is, 1)]));
			 TV = LD(&(xi[WS(is, 61)]), ivs, &(xi[WS(is, 1)]));
			 Tbf = VADD(TU, TV);
			 TS = VSUB(TQ, TR);
			 TeX = VADD(Tbf, Tbg);
			 TW = VSUB(TU, TV);
			 Tbh = VSUB(Tbf, Tbg);
		    }
		    {
			 V Tu, Tbb, Tx, Tbc;
			 {
			      V Ts, Tt, Tv, Tw;
			      Ts = LD(&(xi[WS(is, 21)]), ivs, &(xi[WS(is, 1)]));
			      Tt = LD(&(xi[WS(is, 85)]), ivs, &(xi[WS(is, 1)]));
			      Tu = VSUB(Ts, Tt);
			      Tbb = VADD(Ts, Tt);
			      Tv = LD(&(xi[WS(is, 117)]), ivs, &(xi[WS(is, 1)]));
			      Tw = LD(&(xi[WS(is, 53)]), ivs, &(xi[WS(is, 1)]));
			      Tx = VSUB(Tv, Tw);
			      Tbc = VADD(Tv, Tw);
			 }
			 Ty = VMUL(LDK(KP707106781), VSUB(Tu, Tx));
			 TeV = VADD(Tbb, Tbc);
			 TG = VMUL(LDK(KP707106781), VADD(Tu, Tx));
			 Tbd = VSUB(Tbb, Tbc);
		    }
		    {
			 V TL, Tbi, TO, Tbj;
			 {
			      V TJ, TK, TM, TN;
			      TJ = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
			      TK = LD(&(xi[WS(is, 77)]), ivs, &(xi[WS(is, 1)]));
			      TL = VSUB(TJ, TK);
			      Tbi = VADD(TJ, TK);
			      TM = LD(&(xi[WS(is, 109)]), ivs, &(xi[WS(is, 1)]));
			      TN = LD(&(xi[WS(is, 45)]), ivs, &(xi[WS(is, 1)]));
			      TO = VSUB(TM, TN);
			      Tbj = VADD(TM, TN);
			 }
			 TP = VMUL(LDK(KP707106781), VSUB(TL, TO));
			 TeY = VADD(Tbi, Tbj);
			 TX = VMUL(LDK(KP707106781), VADD(TL, TO));
			 Tbk = VSUB(Tbi, Tbj);
		    }
		    {
			 V Tbe, Tbl, TeW, TeZ;
			 Tbe = VFNMS(LDK(KP382683432), Tbd, VMUL(LDK(KP923879532), Tba));
			 Tbl = VFMA(LDK(KP923879532), Tbh, VMUL(LDK(KP382683432), Tbk));
			 Tbm = VSUB(Tbe, Tbl);
			 Tdg = VADD(Tbe, Tbl);
			 {
			      V TbE, TbF, Tgm, Tgn;
			      TbE = VFMA(LDK(KP382683432), Tba, VMUL(LDK(KP923879532), Tbd));
			      TbF = VFNMS(LDK(KP382683432), Tbh, VMUL(LDK(KP923879532), Tbk));
			      TbG = VSUB(TbE, TbF);
			      Tdj = VADD(TbE, TbF);
			      Tgm = VADD(TeU, TeV);
			      Tgn = VADD(TeX, TeY);
			      Tgo = VSUB(Tgm, Tgn);
			      Th4 = VADD(Tgm, Tgn);
			 }
			 TeW = VSUB(TeU, TeV);
			 TeZ = VSUB(TeX, TeY);
			 Tf0 = VMUL(LDK(KP707106781), VSUB(TeW, TeZ));
			 Tf8 = VMUL(LDK(KP707106781), VADD(TeW, TeZ));
			 {
			      V T72, T7b, T75, T7c;
			      {
				   V T70, T71, T73, T74;
				   T70 = VADD(TB, Ty);
				   T71 = VADD(TF, TG);
				   T72 = VFMA(LDK(KP980785280), T70, VMUL(LDK(KP195090322), T71));
				   T7b = VFNMS(LDK(KP195090322), T70, VMUL(LDK(KP980785280), T71));
				   T73 = VADD(TS, TP);
				   T74 = VADD(TW, TX);
				   T75 = VFNMS(LDK(KP195090322), T74, VMUL(LDK(KP980785280), T73));
				   T7c = VFMA(LDK(KP195090322), T73, VMUL(LDK(KP980785280), T74));
			      }
			      T76 = VSUB(T72, T75);
			      T98 = VADD(T7b, T7c);
			      T7d = VSUB(T7b, T7c);
			      T94 = VADD(T72, T75);
			 }
			 {
			      V TI, T1b, TZ, T1c;
			      {
				   V TC, TH, TT, TY;
				   TC = VSUB(Ty, TB);
				   TH = VSUB(TF, TG);
				   TI = VFMA(LDK(KP831469612), TC, VMUL(LDK(KP555570233), TH));
				   T1b = VFNMS(LDK(KP555570233), TC, VMUL(LDK(KP831469612), TH));
				   TT = VSUB(TP, TS);
				   TY = VSUB(TW, TX);
				   TZ = VFNMS(LDK(KP555570233), TY, VMUL(LDK(KP831469612), TT));
				   T1c = VFMA(LDK(KP555570233), TT, VMUL(LDK(KP831469612), TY));
			      }
			      T10 = VSUB(TI, TZ);
			      T5Y = VADD(T1b, T1c);
			      T1d = VSUB(T1b, T1c);
			      T5U = VADD(TI, TZ);
			 }
		    }
	       }
	       {
		    V T1Q, Tfb, T1U, TbL, T27, Tfe, T2b, TbS, T1N, Tfc, T1V, TbO, T24, Tff, T2c;
		    V TbV;
		    {
			 V T1O, T1P, TbK, T1S, T1T, TbJ;
			 T1O = LD(&(xi[WS(is, 35)]), ivs, &(xi[WS(is, 1)]));
			 T1P = LD(&(xi[WS(is, 99)]), ivs, &(xi[WS(is, 1)]));
			 TbK = VADD(T1O, T1P);
			 T1S = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
			 T1T = LD(&(xi[WS(is, 67)]), ivs, &(xi[WS(is, 1)]));
			 TbJ = VADD(T1S, T1T);
			 T1Q = VSUB(T1O, T1P);
			 Tfb = VADD(TbJ, TbK);
			 T1U = VSUB(T1S, T1T);
			 TbL = VSUB(TbJ, TbK);
		    }
		    {
			 V T25, T26, TbR, T29, T2a, TbQ;
			 T25 = LD(&(xi[WS(is, 27)]), ivs, &(xi[WS(is, 1)]));
			 T26 = LD(&(xi[WS(is, 91)]), ivs, &(xi[WS(is, 1)]));
			 TbR = VADD(T25, T26);
			 T29 = LD(&(xi[WS(is, 123)]), ivs, &(xi[WS(is, 1)]));
			 T2a = LD(&(xi[WS(is, 59)]), ivs, &(xi[WS(is, 1)]));
			 TbQ = VADD(T29, T2a);
			 T27 = VSUB(T25, T26);
			 Tfe = VADD(TbQ, TbR);
			 T2b = VSUB(T29, T2a);
			 TbS = VSUB(TbQ, TbR);
		    }
		    {
			 V T1J, TbM, T1M, TbN;
			 {
			      V T1H, T1I, T1K, T1L;
			      T1H = LD(&(xi[WS(is, 19)]), ivs, &(xi[WS(is, 1)]));
			      T1I = LD(&(xi[WS(is, 83)]), ivs, &(xi[WS(is, 1)]));
			      T1J = VSUB(T1H, T1I);
			      TbM = VADD(T1H, T1I);
			      T1K = LD(&(xi[WS(is, 115)]), ivs, &(xi[WS(is, 1)]));
			      T1L = LD(&(xi[WS(is, 51)]), ivs, &(xi[WS(is, 1)]));
			      T1M = VSUB(T1K, T1L);
			      TbN = VADD(T1K, T1L);
			 }
			 T1N = VMUL(LDK(KP707106781), VSUB(T1J, T1M));
			 Tfc = VADD(TbM, TbN);
			 T1V = VMUL(LDK(KP707106781), VADD(T1J, T1M));
			 TbO = VSUB(TbM, TbN);
		    }
		    {
			 V T20, TbT, T23, TbU;
			 {
			      V T1Y, T1Z, T21, T22;
			      T1Y = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
			      T1Z = LD(&(xi[WS(is, 75)]), ivs, &(xi[WS(is, 1)]));
			      T20 = VSUB(T1Y, T1Z);
			      TbT = VADD(T1Y, T1Z);
			      T21 = LD(&(xi[WS(is, 107)]), ivs, &(xi[WS(is, 1)]));
			      T22 = LD(&(xi[WS(is, 43)]), ivs, &(xi[WS(is, 1)]));
			      T23 = VSUB(T21, T22);
			      TbU = VADD(T21, T22);
			 }
			 T24 = VMUL(LDK(KP707106781), VSUB(T20, T23));
			 Tff = VADD(TbT, TbU);
			 T2c = VMUL(LDK(KP707106781), VADD(T20, T23));
			 TbV = VSUB(TbT, TbU);
		    }
		    {
			 V TbP, TbW, Tfd, Tfg;
			 TbP = VFNMS(LDK(KP382683432), TbO, VMUL(LDK(KP923879532), TbL));
			 TbW = VFMA(LDK(KP923879532), TbS, VMUL(LDK(KP382683432), TbV));
			 TbX = VSUB(TbP, TbW);
			 Tdn = VADD(TbP, TbW);
			 {
			      V Tcf, Tcg, Tgt, Tgu;
			      Tcf = VFMA(LDK(KP382683432), TbL, VMUL(LDK(KP923879532), TbO));
			      Tcg = VFNMS(LDK(KP382683432), TbS, VMUL(LDK(KP923879532), TbV));
			      Tch = VSUB(Tcf, Tcg);
			      Tdq = VADD(Tcf, Tcg);
			      Tgt = VADD(Tfb, Tfc);
			      Tgu = VADD(Tfe, Tff);
			      Tgv = VSUB(Tgt, Tgu);
			      Th7 = VADD(Tgt, Tgu);
			 }
			 Tfd = VSUB(Tfb, Tfc);
			 Tfg = VSUB(Tfe, Tff);
			 Tfh = VMUL(LDK(KP707106781), VSUB(Tfd, Tfg));
			 Tfp = VMUL(LDK(KP707106781), VADD(Tfd, Tfg));
			 {
			      V T7l, T7u, T7o, T7v;
			      {
				   V T7j, T7k, T7m, T7n;
				   T7j = VADD(T1Q, T1N);
				   T7k = VADD(T1U, T1V);
				   T7l = VFMA(LDK(KP980785280), T7j, VMUL(LDK(KP195090322), T7k));
				   T7u = VFNMS(LDK(KP195090322), T7j, VMUL(LDK(KP980785280), T7k));
				   T7m = VADD(T27, T24);
				   T7n = VADD(T2b, T2c);
				   T7o = VFNMS(LDK(KP195090322), T7n, VMUL(LDK(KP980785280), T7m));
				   T7v = VFMA(LDK(KP195090322), T7m, VMUL(LDK(KP980785280), T7n));
			      }
			      T7p = VSUB(T7l, T7o);
			      T9f = VADD(T7u, T7v);
			      T7w = VSUB(T7u, T7v);
			      T9b = VADD(T7l, T7o);
			 }
			 {
			      V T1X, T2q, T2e, T2r;
			      {
				   V T1R, T1W, T28, T2d;
				   T1R = VSUB(T1N, T1Q);
				   T1W = VSUB(T1U, T1V);
				   T1X = VFMA(LDK(KP831469612), T1R, VMUL(LDK(KP555570233), T1W));
				   T2q = VFNMS(LDK(KP555570233), T1R, VMUL(LDK(KP831469612), T1W));
				   T28 = VSUB(T24, T27);
				   T2d = VSUB(T2b, T2c);
				   T2e = VFNMS(LDK(KP555570233), T2d, VMUL(LDK(KP831469612), T28));
				   T2r = VFMA(LDK(KP555570233), T28, VMUL(LDK(KP831469612), T2d));
			      }
			      T2f = VSUB(T1X, T2e);
			      T65 = VADD(T2q, T2r);
			      T2s = VSUB(T2q, T2r);
			      T61 = VADD(T1X, T2e);
			 }
		    }
	       }
	       {
		    V Tgx, TgW, TgR, TgZ, TgI, TgY, TgO, TgV;
		    {
			 V Tgp, Tgw, TgP, TgQ;
			 Tgp = VFNMS(LDK(KP382683432), Tgo, VMUL(LDK(KP923879532), Tgl));
			 Tgw = VFMA(LDK(KP923879532), Tgs, VMUL(LDK(KP382683432), Tgv));
			 Tgx = VSUB(Tgp, Tgw);
			 TgW = VADD(Tgp, Tgw);
			 TgP = VFMA(LDK(KP382683432), Tgl, VMUL(LDK(KP923879532), Tgo));
			 TgQ = VFNMS(LDK(KP382683432), Tgs, VMUL(LDK(KP923879532), Tgv));
			 TgR = VSUB(TgP, TgQ);
			 TgZ = VADD(TgP, TgQ);
		    }
		    {
			 V TgE, TgH, TgM, TgN;
			 TgE = VMUL(LDK(KP707106781), VSUB(TgA, TgD));
			 TgH = VSUB(TgF, TgG);
			 TgI = VSUB(TgE, TgH);
			 TgY = VADD(TgH, TgE);
			 TgM = VSUB(TgK, TgL);
			 TgN = VMUL(LDK(KP707106781), VADD(TgA, TgD));
			 TgO = VSUB(TgM, TgN);
			 TgV = VADD(TgM, TgN);
		    }
		    {
			 V TgJ, TgS, Th1, Th2;
			 TgJ = VBYI(VSUB(Tgx, TgI));
			 TgS = VSUB(TgO, TgR);
			 ST(&(xo[WS(os, 40)]), VADD(TgJ, TgS), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 88)]), VSUB(TgS, TgJ), ovs, &(xo[0]));
			 Th1 = VSUB(TgV, TgW);
			 Th2 = VBYI(VSUB(TgZ, TgY));
			 ST(&(xo[WS(os, 72)]), VSUB(Th1, Th2), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 56)]), VADD(Th1, Th2), ovs, &(xo[0]));
		    }
		    {
			 V TgT, TgU, TgX, Th0;
			 TgT = VBYI(VADD(TgI, Tgx));
			 TgU = VADD(TgO, TgR);
			 ST(&(xo[WS(os, 24)]), VADD(TgT, TgU), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 104)]), VSUB(TgU, TgT), ovs, &(xo[0]));
			 TgX = VADD(TgV, TgW);
			 Th0 = VBYI(VADD(TgY, TgZ));
			 ST(&(xo[WS(os, 120)]), VSUB(TgX, Th0), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 8)]), VADD(TgX, Th0), ovs, &(xo[0]));
		    }
	       }
	       {
		    V Th9, Thh, Thq, Ths, Thc, Thm, Thg, Thl, Thn, Thr;
		    {
			 V Th5, Th8, Tho, Thp;
			 Th5 = VSUB(Th3, Th4);
			 Th8 = VSUB(Th6, Th7);
			 Th9 = VMUL(LDK(KP707106781), VSUB(Th5, Th8));
			 Thh = VMUL(LDK(KP707106781), VADD(Th5, Th8));
			 Tho = VADD(Th3, Th4);
			 Thp = VADD(Th6, Th7);
			 Thq = VBYI(VSUB(Tho, Thp));
			 Ths = VADD(Tho, Thp);
		    }
		    {
			 V Tha, Thb, The, Thf;
			 Tha = VADD(Tgy, Tgz);
			 Thb = VADD(TgB, TgC);
			 Thc = VSUB(Tha, Thb);
			 Thm = VADD(Tha, Thb);
			 The = VADD(TgK, TgL);
			 Thf = VADD(TgF, TgG);
			 Thg = VSUB(The, Thf);
			 Thl = VADD(The, Thf);
		    }
		    Thn = VSUB(Thl, Thm);
		    ST(&(xo[WS(os, 96)]), VSUB(Thn, Thq), ovs, &(xo[0]));
		    ST(&(xo[WS(os, 32)]), VADD(Thn, Thq), ovs, &(xo[0]));
		    Thr = VADD(Thl, Thm);
		    ST(&(xo[WS(os, 64)]), VSUB(Thr, Ths), ovs, &(xo[0]));
		    ST(&(xo[0]), VADD(Thr, Ths), ovs, &(xo[0]));
		    {
			 V Thd, Thi, Thj, Thk;
			 Thd = VBYI(VSUB(Th9, Thc));
			 Thi = VSUB(Thg, Thh);
			 ST(&(xo[WS(os, 48)]), VADD(Thd, Thi), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 80)]), VSUB(Thi, Thd), ovs, &(xo[0]));
			 Thj = VBYI(VADD(Thc, Th9));
			 Thk = VADD(Thg, Thh);
			 ST(&(xo[WS(os, 16)]), VADD(Thj, Thk), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 112)]), VSUB(Thk, Thj), ovs, &(xo[0]));
		    }
	       }
	       {
		    V TeT, TfM, TfC, TfK, Tfs, TfN, TfF, TfJ;
		    {
			 V TeD, TeS, Tfw, TfB;
			 TeD = VSUB(Tev, TeC);
			 TeS = VSUB(TeK, TeR);
			 TeT = VSUB(TeD, TeS);
			 TfM = VADD(TeD, TeS);
			 Tfw = VSUB(Tfu, Tfv);
			 TfB = VSUB(Tfx, TfA);
			 TfC = VSUB(Tfw, TfB);
			 TfK = VADD(TfB, Tfw);
			 {
			      V Tfa, TfD, Tfr, TfE;
			      {
				   V Tf4, Tf9, Tfl, Tfq;
				   Tf4 = VSUB(Tf0, Tf3);
				   Tf9 = VSUB(Tf7, Tf8);
				   Tfa = VFMA(LDK(KP831469612), Tf4, VMUL(LDK(KP555570233), Tf9));
				   TfD = VFNMS(LDK(KP555570233), Tf4, VMUL(LDK(KP831469612), Tf9));
				   Tfl = VSUB(Tfh, Tfk);
				   Tfq = VSUB(Tfo, Tfp);
				   Tfr = VFNMS(LDK(KP555570233), Tfq, VMUL(LDK(KP831469612), Tfl));
				   TfE = VFMA(LDK(KP555570233), Tfl, VMUL(LDK(KP831469612), Tfq));
			      }
			      Tfs = VSUB(Tfa, Tfr);
			      TfN = VADD(TfD, TfE);
			      TfF = VSUB(TfD, TfE);
			      TfJ = VADD(Tfa, Tfr);
			 }
		    }
		    {
			 V Tft, TfG, TfP, TfQ;
			 Tft = VADD(TeT, Tfs);
			 TfG = VBYI(VADD(TfC, TfF));
			 ST(&(xo[WS(os, 108)]), VSUB(Tft, TfG), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 20)]), VADD(Tft, TfG), ovs, &(xo[0]));
			 TfP = VBYI(VADD(TfK, TfJ));
			 TfQ = VADD(TfM, TfN);
			 ST(&(xo[WS(os, 12)]), VADD(TfP, TfQ), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 116)]), VSUB(TfQ, TfP), ovs, &(xo[0]));
		    }
		    {
			 V TfH, TfI, TfL, TfO;
			 TfH = VSUB(TeT, Tfs);
			 TfI = VBYI(VSUB(TfF, TfC));
			 ST(&(xo[WS(os, 84)]), VSUB(TfH, TfI), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 44)]), VADD(TfH, TfI), ovs, &(xo[0]));
			 TfL = VBYI(VSUB(TfJ, TfK));
			 TfO = VSUB(TfM, TfN);
			 ST(&(xo[WS(os, 52)]), VADD(TfL, TfO), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 76)]), VSUB(TfO, TfL), ovs, &(xo[0]));
		    }
	       }
	       {
		    V TfT, Tge, Tg4, Tgc, Tg0, Tgf, Tg7, Tgb;
		    {
			 V TfR, TfS, Tg2, Tg3;
			 TfR = VADD(Tev, TeC);
			 TfS = VADD(Tfu, Tfv);
			 TfT = VSUB(TfR, TfS);
			 Tge = VADD(TfR, TfS);
			 Tg2 = VADD(TeK, TeR);
			 Tg3 = VADD(TfA, Tfx);
			 Tg4 = VSUB(Tg2, Tg3);
			 Tgc = VADD(Tg3, Tg2);
			 {
			      V TfW, Tg5, TfZ, Tg6;
			      {
				   V TfU, TfV, TfX, TfY;
				   TfU = VADD(Tf3, Tf0);
				   TfV = VADD(Tf7, Tf8);
				   TfW = VFMA(LDK(KP980785280), TfU, VMUL(LDK(KP195090322), TfV));
				   Tg5 = VFNMS(LDK(KP195090322), TfU, VMUL(LDK(KP980785280), TfV));
				   TfX = VADD(Tfk, Tfh);
				   TfY = VADD(Tfo, Tfp);
				   TfZ = VFNMS(LDK(KP195090322), TfY, VMUL(LDK(KP980785280), TfX));
				   Tg6 = VFMA(LDK(KP195090322), TfX, VMUL(LDK(KP980785280), TfY));
			      }
			      Tg0 = VSUB(TfW, TfZ);
			      Tgf = VADD(Tg5, Tg6);
			      Tg7 = VSUB(Tg5, Tg6);
			      Tgb = VADD(TfW, TfZ);
			 }
		    }
		    {
			 V Tg1, Tg8, Tgh, Tgi;
			 Tg1 = VADD(TfT, Tg0);
			 Tg8 = VBYI(VADD(Tg4, Tg7));
			 ST(&(xo[WS(os, 100)]), VSUB(Tg1, Tg8), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 28)]), VADD(Tg1, Tg8), ovs, &(xo[0]));
			 Tgh = VBYI(VADD(Tgc, Tgb));
			 Tgi = VADD(Tge, Tgf);
			 ST(&(xo[WS(os, 4)]), VADD(Tgh, Tgi), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 124)]), VSUB(Tgi, Tgh), ovs, &(xo[0]));
		    }
		    {
			 V Tg9, Tga, Tgd, Tgg;
			 Tg9 = VSUB(TfT, Tg0);
			 Tga = VBYI(VSUB(Tg7, Tg4));
			 ST(&(xo[WS(os, 92)]), VSUB(Tg9, Tga), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 36)]), VADD(Tg9, Tga), ovs, &(xo[0]));
			 Tgd = VBYI(VSUB(Tgb, Tgc));
			 Tgg = VSUB(Tge, Tgf);
			 ST(&(xo[WS(os, 60)]), VADD(Tgd, Tgg), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 68)]), VSUB(Tgg, Tgd), ovs, &(xo[0]));
		    }
	       }
	       {
		    V Tb7, Td8, TcI, Td0, Tcy, Tda, TcG, TcP, Tck, TcJ, TcB, TcF, TcW, Tdb, Td3;
		    V Td7;
		    {
			 V Tax, TcZ, Tb6, TcY, TaO, Tb5;
			 Tax = VSUB(Tah, Taw);
			 TcZ = VADD(Tcw, Tcr);
			 TaO = VFMA(LDK(KP831469612), TaI, VMUL(LDK(KP555570233), TaN));
			 Tb5 = VFNMS(LDK(KP555570233), Tb4, VMUL(LDK(KP831469612), TaZ));
			 Tb6 = VSUB(TaO, Tb5);
			 TcY = VADD(TaO, Tb5);
			 Tb7 = VSUB(Tax, Tb6);
			 Td8 = VADD(TcZ, TcY);
			 TcI = VADD(Tax, Tb6);
			 Td0 = VSUB(TcY, TcZ);
		    }
		    {
			 V Tcx, TcN, Tco, TcO, Tcm, Tcn;
			 Tcx = VSUB(Tcr, Tcw);
			 TcN = VADD(Tah, Taw);
			 Tcm = VFNMS(LDK(KP555570233), TaI, VMUL(LDK(KP831469612), TaN));
			 Tcn = VFMA(LDK(KP555570233), TaZ, VMUL(LDK(KP831469612), Tb4));
			 Tco = VSUB(Tcm, Tcn);
			 TcO = VADD(Tcm, Tcn);
			 Tcy = VSUB(Tco, Tcx);
			 Tda = VADD(TcN, TcO);
			 TcG = VADD(Tcx, Tco);
			 TcP = VSUB(TcN, TcO);
		    }
		    {
			 V TbI, Tcz, Tcj, TcA;
			 {
			      V Tby, TbH, Tc9, Tci;
			      Tby = VSUB(Tbm, Tbx);
			      TbH = VSUB(TbD, TbG);
			      TbI = VFMA(LDK(KP881921264), Tby, VMUL(LDK(KP471396736), TbH));
			      Tcz = VFNMS(LDK(KP471396736), Tby, VMUL(LDK(KP881921264), TbH));
			      Tc9 = VSUB(TbX, Tc8);
			      Tci = VSUB(Tce, Tch);
			      Tcj = VFNMS(LDK(KP471396736), Tci, VMUL(LDK(KP881921264), Tc9));
			      TcA = VFMA(LDK(KP471396736), Tc9, VMUL(LDK(KP881921264), Tci));
			 }
			 Tck = VSUB(TbI, Tcj);
			 TcJ = VADD(Tcz, TcA);
			 TcB = VSUB(Tcz, TcA);
			 TcF = VADD(TbI, Tcj);
		    }
		    {
			 V TcS, Td1, TcV, Td2;
			 {
			      V TcQ, TcR, TcT, TcU;
			      TcQ = VADD(Tbx, Tbm);
			      TcR = VADD(TbD, TbG);
			      TcS = VFMA(LDK(KP956940335), TcQ, VMUL(LDK(KP290284677), TcR));
			      Td1 = VFNMS(LDK(KP290284677), TcQ, VMUL(LDK(KP956940335), TcR));
			      TcT = VADD(Tc8, TbX);
			      TcU = VADD(Tce, Tch);
			      TcV = VFNMS(LDK(KP290284677), TcU, VMUL(LDK(KP956940335), TcT));
			      Td2 = VFMA(LDK(KP290284677), TcT, VMUL(LDK(KP956940335), TcU));
			 }
			 TcW = VSUB(TcS, TcV);
			 Tdb = VADD(Td1, Td2);
			 Td3 = VSUB(Td1, Td2);
			 Td7 = VADD(TcS, TcV);
		    }
		    {
			 V Tcl, TcC, Td9, Tdc;
			 Tcl = VADD(Tb7, Tck);
			 TcC = VBYI(VADD(Tcy, TcB));
			 ST(&(xo[WS(os, 106)]), VSUB(Tcl, TcC), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 22)]), VADD(Tcl, TcC), ovs, &(xo[0]));
			 Td9 = VBYI(VSUB(Td7, Td8));
			 Tdc = VSUB(Tda, Tdb);
			 ST(&(xo[WS(os, 58)]), VADD(Td9, Tdc), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 70)]), VSUB(Tdc, Td9), ovs, &(xo[0]));
		    }
		    {
			 V Tdd, Tde, TcD, TcE;
			 Tdd = VBYI(VADD(Td8, Td7));
			 Tde = VADD(Tda, Tdb);
			 ST(&(xo[WS(os, 6)]), VADD(Tdd, Tde), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 122)]), VSUB(Tde, Tdd), ovs, &(xo[0]));
			 TcD = VSUB(Tb7, Tck);
			 TcE = VBYI(VSUB(TcB, Tcy));
			 ST(&(xo[WS(os, 86)]), VSUB(TcD, TcE), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 42)]), VADD(TcD, TcE), ovs, &(xo[0]));
		    }
		    {
			 V TcH, TcK, TcX, Td4;
			 TcH = VBYI(VSUB(TcF, TcG));
			 TcK = VSUB(TcI, TcJ);
			 ST(&(xo[WS(os, 54)]), VADD(TcH, TcK), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 74)]), VSUB(TcK, TcH), ovs, &(xo[0]));
			 TcX = VADD(TcP, TcW);
			 Td4 = VBYI(VADD(Td0, Td3));
			 ST(&(xo[WS(os, 102)]), VSUB(TcX, Td4), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 26)]), VADD(TcX, Td4), ovs, &(xo[0]));
		    }
		    {
			 V Td5, Td6, TcL, TcM;
			 Td5 = VSUB(TcP, TcW);
			 Td6 = VBYI(VSUB(Td3, Td0));
			 ST(&(xo[WS(os, 90)]), VSUB(Td5, Td6), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 38)]), VADD(Td5, Td6), ovs, &(xo[0]));
			 TcL = VBYI(VADD(TcG, TcF));
			 TcM = VADD(TcI, TcJ);
			 ST(&(xo[WS(os, 10)]), VADD(TcL, TcM), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 118)]), VSUB(TcM, TcL), ovs, &(xo[0]));
		    }
	       }
	       {
		    V TdE, Tel, TdW, Tee, TdM, Teo, TdT, Tea, Tdt, TdX, TdP, TdU, Te7, Tep, Teh;
		    V Tem;
		    {
			 V TdD, Tec, TdA, Ted, Tdw, Tdz;
			 TdD = VADD(TdB, TdC);
			 Tec = VSUB(TdG, TdH);
			 Tdw = VFMA(LDK(KP980785280), Tdu, VMUL(LDK(KP195090322), Tdv));
			 Tdz = VFNMS(LDK(KP195090322), Tdy, VMUL(LDK(KP980785280), Tdx));
			 TdA = VADD(Tdw, Tdz);
			 Ted = VSUB(Tdw, Tdz);
			 TdE = VSUB(TdA, TdD);
			 Tel = VADD(Tec, Ted);
			 TdW = VADD(TdD, TdA);
			 Tee = VSUB(Tec, Ted);
		    }
		    {
			 V TdI, Te9, TdL, Te8, TdJ, TdK;
			 TdI = VADD(TdG, TdH);
			 Te9 = VSUB(TdC, TdB);
			 TdJ = VFNMS(LDK(KP195090322), Tdu, VMUL(LDK(KP980785280), Tdv));
			 TdK = VFMA(LDK(KP195090322), Tdx, VMUL(LDK(KP980785280), Tdy));
			 TdL = VADD(TdJ, TdK);
			 Te8 = VSUB(TdJ, TdK);
			 TdM = VSUB(TdI, TdL);
			 Teo = VADD(Te9, Te8);
			 TdT = VADD(TdI, TdL);
			 Tea = VSUB(Te8, Te9);
		    }
		    {
			 V Tdl, TdN, Tds, TdO;
			 {
			      V Tdh, Tdk, Tdo, Tdr;
			      Tdh = VADD(Tdf, Tdg);
			      Tdk = VADD(Tdi, Tdj);
			      Tdl = VFNMS(LDK(KP098017140), Tdk, VMUL(LDK(KP995184726), Tdh));
			      TdN = VFMA(LDK(KP098017140), Tdh, VMUL(LDK(KP995184726), Tdk));
			      Tdo = VADD(Tdm, Tdn);
			      Tdr = VADD(Tdp, Tdq);
			      Tds = VFMA(LDK(KP995184726), Tdo, VMUL(LDK(KP098017140), Tdr));
			      TdO = VFNMS(LDK(KP098017140), Tdo, VMUL(LDK(KP995184726), Tdr));
			 }
			 Tdt = VSUB(Tdl, Tds);
			 TdX = VADD(TdN, TdO);
			 TdP = VSUB(TdN, TdO);
			 TdU = VADD(Tdl, Tds);
		    }
		    {
			 V Te3, Tef, Te6, Teg;
			 {
			      V Te1, Te2, Te4, Te5;
			      Te1 = VSUB(Tdf, Tdg);
			      Te2 = VSUB(Tdj, Tdi);
			      Te3 = VFNMS(LDK(KP634393284), Te2, VMUL(LDK(KP773010453), Te1));
			      Tef = VFMA(LDK(KP634393284), Te1, VMUL(LDK(KP773010453), Te2));
			      Te4 = VSUB(Tdm, Tdn);
			      Te5 = VSUB(Tdq, Tdp);
			      Te6 = VFMA(LDK(KP773010453), Te4, VMUL(LDK(KP634393284), Te5));
			      Teg = VFNMS(LDK(KP634393284), Te4, VMUL(LDK(KP773010453), Te5));
			 }
			 Te7 = VSUB(Te3, Te6);
			 Tep = VADD(Tef, Teg);
			 Teh = VSUB(Tef, Teg);
			 Tem = VADD(Te3, Te6);
		    }
		    {
			 V TdF, TdQ, Ten, Teq;
			 TdF = VBYI(VSUB(Tdt, TdE));
			 TdQ = VSUB(TdM, TdP);
			 ST(&(xo[WS(os, 34)]), VADD(TdF, TdQ), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 94)]), VSUB(TdQ, TdF), ovs, &(xo[0]));
			 Ten = VADD(Tel, Tem);
			 Teq = VBYI(VADD(Teo, Tep));
			 ST(&(xo[WS(os, 114)]), VSUB(Ten, Teq), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 14)]), VADD(Ten, Teq), ovs, &(xo[0]));
		    }
		    {
			 V Ter, Tes, TdR, TdS;
			 Ter = VSUB(Tel, Tem);
			 Tes = VBYI(VSUB(Tep, Teo));
			 ST(&(xo[WS(os, 78)]), VSUB(Ter, Tes), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 50)]), VADD(Ter, Tes), ovs, &(xo[0]));
			 TdR = VBYI(VADD(TdE, Tdt));
			 TdS = VADD(TdM, TdP);
			 ST(&(xo[WS(os, 30)]), VADD(TdR, TdS), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 98)]), VSUB(TdS, TdR), ovs, &(xo[0]));
		    }
		    {
			 V TdV, TdY, Teb, Tei;
			 TdV = VADD(TdT, TdU);
			 TdY = VBYI(VADD(TdW, TdX));
			 ST(&(xo[WS(os, 126)]), VSUB(TdV, TdY), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 2)]), VADD(TdV, TdY), ovs, &(xo[0]));
			 Teb = VBYI(VSUB(Te7, Tea));
			 Tei = VSUB(Tee, Teh);
			 ST(&(xo[WS(os, 46)]), VADD(Teb, Tei), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 82)]), VSUB(Tei, Teb), ovs, &(xo[0]));
		    }
		    {
			 V Tej, Tek, TdZ, Te0;
			 Tej = VBYI(VADD(Tea, Te7));
			 Tek = VADD(Tee, Teh);
			 ST(&(xo[WS(os, 18)]), VADD(Tej, Tek), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 110)]), VSUB(Tek, Tej), ovs, &(xo[0]));
			 TdZ = VSUB(TdT, TdU);
			 Te0 = VBYI(VSUB(TdX, TdW));
			 ST(&(xo[WS(os, 66)]), VSUB(TdZ, Te0), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 62)]), VADD(TdZ, Te0), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T7z, T8n, T8f, T8k, T8x, T8P, T8H, T8M, T80, T8L, T8O, T8c, T8j, T8A, T8E;
		    V T8m;
		    {
			 V T7f, T8d, T7y, T8e;
			 {
			      V T77, T7e, T7q, T7x;
			      T77 = VADD(T6Z, T76);
			      T7e = VADD(T7a, T7d);
			      T7f = VFNMS(LDK(KP336889853), T7e, VMUL(LDK(KP941544065), T77));
			      T8d = VFMA(LDK(KP336889853), T77, VMUL(LDK(KP941544065), T7e));
			      T7q = VADD(T7i, T7p);
			      T7x = VADD(T7t, T7w);
			      T7y = VFMA(LDK(KP941544065), T7q, VMUL(LDK(KP336889853), T7x));
			      T8e = VFNMS(LDK(KP336889853), T7q, VMUL(LDK(KP941544065), T7x));
			 }
			 T7z = VSUB(T7f, T7y);
			 T8n = VADD(T8d, T8e);
			 T8f = VSUB(T8d, T8e);
			 T8k = VADD(T7f, T7y);
		    }
		    {
			 V T8t, T8F, T8w, T8G;
			 {
			      V T8r, T8s, T8u, T8v;
			      T8r = VSUB(T6Z, T76);
			      T8s = VSUB(T7d, T7a);
			      T8t = VFNMS(LDK(KP427555093), T8s, VMUL(LDK(KP903989293), T8r));
			      T8F = VFMA(LDK(KP427555093), T8r, VMUL(LDK(KP903989293), T8s));
			      T8u = VSUB(T7i, T7p);
			      T8v = VSUB(T7w, T7t);
			      T8w = VFMA(LDK(KP903989293), T8u, VMUL(LDK(KP427555093), T8v));
			      T8G = VFNMS(LDK(KP427555093), T8u, VMUL(LDK(KP903989293), T8v));
			 }
			 T8x = VSUB(T8t, T8w);
			 T8P = VADD(T8F, T8G);
			 T8H = VSUB(T8F, T8G);
			 T8M = VADD(T8t, T8w);
		    }
		    {
			 V T7Z, T8z, T88, T8C, T7O, T8D, T8b, T8y, T7Y, T87;
			 T7Y = VSUB(T7U, T7X);
			 T7Z = VADD(T7R, T7Y);
			 T8z = VSUB(T7Y, T7R);
			 T87 = VSUB(T85, T86);
			 T88 = VADD(T84, T87);
			 T8C = VSUB(T84, T87);
			 {
			      V T7G, T7N, T89, T8a;
			      T7G = VFMA(LDK(KP634393284), T7C, VMUL(LDK(KP773010453), T7F));
			      T7N = VFNMS(LDK(KP634393284), T7M, VMUL(LDK(KP773010453), T7J));
			      T7O = VADD(T7G, T7N);
			      T8D = VSUB(T7G, T7N);
			      T89 = VFNMS(LDK(KP634393284), T7F, VMUL(LDK(KP773010453), T7C));
			      T8a = VFMA(LDK(KP773010453), T7M, VMUL(LDK(KP634393284), T7J));
			      T8b = VADD(T89, T8a);
			      T8y = VSUB(T89, T8a);
			 }
			 T80 = VSUB(T7O, T7Z);
			 T8L = VADD(T8C, T8D);
			 T8O = VADD(T8z, T8y);
			 T8c = VSUB(T88, T8b);
			 T8j = VADD(T88, T8b);
			 T8A = VSUB(T8y, T8z);
			 T8E = VSUB(T8C, T8D);
			 T8m = VADD(T7Z, T7O);
		    }
		    {
			 V T81, T8g, T8N, T8Q;
			 T81 = VBYI(VSUB(T7z, T80));
			 T8g = VSUB(T8c, T8f);
			 ST(&(xo[WS(os, 39)]), VADD(T81, T8g), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 89)]), VSUB(T8g, T81), ovs, &(xo[WS(os, 1)]));
			 T8N = VADD(T8L, T8M);
			 T8Q = VBYI(VADD(T8O, T8P));
			 ST(&(xo[WS(os, 119)]), VSUB(T8N, T8Q), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 9)]), VADD(T8N, T8Q), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T8R, T8S, T8h, T8i;
			 T8R = VSUB(T8L, T8M);
			 T8S = VBYI(VSUB(T8P, T8O));
			 ST(&(xo[WS(os, 73)]), VSUB(T8R, T8S), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 55)]), VADD(T8R, T8S), ovs, &(xo[WS(os, 1)]));
			 T8h = VBYI(VADD(T80, T7z));
			 T8i = VADD(T8c, T8f);
			 ST(&(xo[WS(os, 25)]), VADD(T8h, T8i), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 103)]), VSUB(T8i, T8h), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T8l, T8o, T8B, T8I;
			 T8l = VADD(T8j, T8k);
			 T8o = VBYI(VADD(T8m, T8n));
			 ST(&(xo[WS(os, 121)]), VSUB(T8l, T8o), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 7)]), VADD(T8l, T8o), ovs, &(xo[WS(os, 1)]));
			 T8B = VBYI(VSUB(T8x, T8A));
			 T8I = VSUB(T8E, T8H);
			 ST(&(xo[WS(os, 41)]), VADD(T8B, T8I), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 87)]), VSUB(T8I, T8B), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T8J, T8K, T8p, T8q;
			 T8J = VBYI(VADD(T8A, T8x));
			 T8K = VADD(T8E, T8H);
			 ST(&(xo[WS(os, 23)]), VADD(T8J, T8K), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 105)]), VSUB(T8K, T8J), ovs, &(xo[WS(os, 1)]));
			 T8p = VSUB(T8j, T8k);
			 T8q = VBYI(VSUB(T8n, T8m));
			 ST(&(xo[WS(os, 71)]), VSUB(T8p, T8q), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 57)]), VADD(T8p, T8q), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T2v, T5d, T55, T5a, T5n, T5F, T5x, T5C, T4K, T5B, T5E, T52, T59, T5q, T5u;
		    V T5c;
		    {
			 V T1f, T53, T2u, T54;
			 {
			      V T11, T1e, T2g, T2t;
			      T11 = VADD(Tr, T10);
			      T1e = VADD(T1a, T1d);
			      T1f = VFNMS(LDK(KP242980179), T1e, VMUL(LDK(KP970031253), T11));
			      T53 = VFMA(LDK(KP242980179), T11, VMUL(LDK(KP970031253), T1e));
			      T2g = VADD(T1G, T2f);
			      T2t = VADD(T2p, T2s);
			      T2u = VFMA(LDK(KP970031253), T2g, VMUL(LDK(KP242980179), T2t));
			      T54 = VFNMS(LDK(KP242980179), T2g, VMUL(LDK(KP970031253), T2t));
			 }
			 T2v = VSUB(T1f, T2u);
			 T5d = VADD(T53, T54);
			 T55 = VSUB(T53, T54);
			 T5a = VADD(T1f, T2u);
		    }
		    {
			 V T5j, T5v, T5m, T5w;
			 {
			      V T5h, T5i, T5k, T5l;
			      T5h = VSUB(Tr, T10);
			      T5i = VSUB(T1d, T1a);
			      T5j = VFNMS(LDK(KP514102744), T5i, VMUL(LDK(KP857728610), T5h));
			      T5v = VFMA(LDK(KP514102744), T5h, VMUL(LDK(KP857728610), T5i));
			      T5k = VSUB(T1G, T2f);
			      T5l = VSUB(T2s, T2p);
			      T5m = VFMA(LDK(KP857728610), T5k, VMUL(LDK(KP514102744), T5l));
			      T5w = VFNMS(LDK(KP514102744), T5k, VMUL(LDK(KP857728610), T5l));
			 }
			 T5n = VSUB(T5j, T5m);
			 T5F = VADD(T5v, T5w);
			 T5x = VSUB(T5v, T5w);
			 T5C = VADD(T5j, T5m);
		    }
		    {
			 V T4J, T5p, T4Y, T5s, T3I, T5t, T51, T5o, T4I, T4X;
			 T4I = VSUB(T4q, T4H);
			 T4J = VADD(T49, T4I);
			 T5p = VSUB(T4I, T49);
			 T4X = VSUB(T4V, T4W);
			 T4Y = VADD(T4U, T4X);
			 T5s = VSUB(T4U, T4X);
			 {
			      V T36, T3H, T4Z, T50;
			      T36 = VFMA(LDK(KP881921264), T2W, VMUL(LDK(KP471396736), T35));
			      T3H = VFNMS(LDK(KP471396736), T3G, VMUL(LDK(KP881921264), T3x));
			      T3I = VADD(T36, T3H);
			      T5t = VSUB(T36, T3H);
			      T4Z = VFNMS(LDK(KP471396736), T2W, VMUL(LDK(KP881921264), T35));
			      T50 = VFMA(LDK(KP471396736), T3x, VMUL(LDK(KP881921264), T3G));
			      T51 = VADD(T4Z, T50);
			      T5o = VSUB(T4Z, T50);
			 }
			 T4K = VSUB(T3I, T4J);
			 T5B = VADD(T5s, T5t);
			 T5E = VADD(T5p, T5o);
			 T52 = VSUB(T4Y, T51);
			 T59 = VADD(T4Y, T51);
			 T5q = VSUB(T5o, T5p);
			 T5u = VSUB(T5s, T5t);
			 T5c = VADD(T4J, T3I);
		    }
		    {
			 V T4L, T56, T5D, T5G;
			 T4L = VBYI(VSUB(T2v, T4K));
			 T56 = VSUB(T52, T55);
			 ST(&(xo[WS(os, 37)]), VADD(T4L, T56), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 91)]), VSUB(T56, T4L), ovs, &(xo[WS(os, 1)]));
			 T5D = VADD(T5B, T5C);
			 T5G = VBYI(VADD(T5E, T5F));
			 ST(&(xo[WS(os, 117)]), VSUB(T5D, T5G), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 11)]), VADD(T5D, T5G), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T5H, T5I, T57, T58;
			 T5H = VSUB(T5B, T5C);
			 T5I = VBYI(VSUB(T5F, T5E));
			 ST(&(xo[WS(os, 75)]), VSUB(T5H, T5I), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 53)]), VADD(T5H, T5I), ovs, &(xo[WS(os, 1)]));
			 T57 = VBYI(VADD(T4K, T2v));
			 T58 = VADD(T52, T55);
			 ST(&(xo[WS(os, 27)]), VADD(T57, T58), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 101)]), VSUB(T58, T57), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T5b, T5e, T5r, T5y;
			 T5b = VADD(T59, T5a);
			 T5e = VBYI(VADD(T5c, T5d));
			 ST(&(xo[WS(os, 123)]), VSUB(T5b, T5e), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 5)]), VADD(T5b, T5e), ovs, &(xo[WS(os, 1)]));
			 T5r = VBYI(VSUB(T5n, T5q));
			 T5y = VSUB(T5u, T5x);
			 ST(&(xo[WS(os, 43)]), VADD(T5r, T5y), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 85)]), VSUB(T5y, T5r), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T5z, T5A, T5f, T5g;
			 T5z = VBYI(VADD(T5q, T5n));
			 T5A = VADD(T5u, T5x);
			 ST(&(xo[WS(os, 21)]), VADD(T5z, T5A), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 107)]), VSUB(T5A, T5z), ovs, &(xo[WS(os, 1)]));
			 T5f = VSUB(T59, T5a);
			 T5g = VBYI(VSUB(T5d, T5c));
			 ST(&(xo[WS(os, 69)]), VSUB(T5f, T5g), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 59)]), VADD(T5f, T5g), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T9i, T9B, T9t, T9x, T9O, Ta3, T9V, T9Z, T93, Ta0, Ta2, T9q, T9y, T9H, T9S;
		    V T9A;
		    {
			 V T9a, T9r, T9h, T9s;
			 {
			      V T96, T99, T9d, T9g;
			      T96 = VSUB(T94, T95);
			      T99 = VSUB(T97, T98);
			      T9a = VFMA(LDK(KP740951125), T96, VMUL(LDK(KP671558954), T99));
			      T9r = VFNMS(LDK(KP671558954), T96, VMUL(LDK(KP740951125), T99));
			      T9d = VSUB(T9b, T9c);
			      T9g = VSUB(T9e, T9f);
			      T9h = VFNMS(LDK(KP671558954), T9g, VMUL(LDK(KP740951125), T9d));
			      T9s = VFMA(LDK(KP671558954), T9d, VMUL(LDK(KP740951125), T9g));
			 }
			 T9i = VSUB(T9a, T9h);
			 T9B = VADD(T9r, T9s);
			 T9t = VSUB(T9r, T9s);
			 T9x = VADD(T9a, T9h);
		    }
		    {
			 V T9K, T9T, T9N, T9U;
			 {
			      V T9I, T9J, T9L, T9M;
			      T9I = VADD(T95, T94);
			      T9J = VADD(T97, T98);
			      T9K = VFMA(LDK(KP998795456), T9I, VMUL(LDK(KP049067674), T9J));
			      T9T = VFNMS(LDK(KP049067674), T9I, VMUL(LDK(KP998795456), T9J));
			      T9L = VADD(T9c, T9b);
			      T9M = VADD(T9e, T9f);
			      T9N = VFNMS(LDK(KP049067674), T9M, VMUL(LDK(KP998795456), T9L));
			      T9U = VFMA(LDK(KP049067674), T9L, VMUL(LDK(KP998795456), T9M));
			 }
			 T9O = VSUB(T9K, T9N);
			 Ta3 = VADD(T9T, T9U);
			 T9V = VSUB(T9T, T9U);
			 T9Z = VADD(T9K, T9N);
		    }
		    {
			 V T8V, T9F, T9p, T9R, T92, T9Q, T9m, T9G, T8U, T9n;
			 T8U = VADD(T7U, T7X);
			 T8V = VSUB(T8T, T8U);
			 T9F = VADD(T8T, T8U);
			 T9n = VADD(T85, T86);
			 T9p = VSUB(T9n, T9o);
			 T9R = VADD(T9o, T9n);
			 {
			      V T8Y, T91, T9k, T9l;
			      T8Y = VFMA(LDK(KP098017140), T8W, VMUL(LDK(KP995184726), T8X));
			      T91 = VFNMS(LDK(KP098017140), T90, VMUL(LDK(KP995184726), T8Z));
			      T92 = VSUB(T8Y, T91);
			      T9Q = VADD(T8Y, T91);
			      T9k = VFNMS(LDK(KP098017140), T8X, VMUL(LDK(KP995184726), T8W));
			      T9l = VFMA(LDK(KP995184726), T90, VMUL(LDK(KP098017140), T8Z));
			      T9m = VSUB(T9k, T9l);
			      T9G = VADD(T9k, T9l);
			 }
			 T93 = VSUB(T8V, T92);
			 Ta0 = VADD(T9R, T9Q);
			 Ta2 = VADD(T9F, T9G);
			 T9q = VSUB(T9m, T9p);
			 T9y = VADD(T9p, T9m);
			 T9H = VSUB(T9F, T9G);
			 T9S = VSUB(T9Q, T9R);
			 T9A = VADD(T8V, T92);
		    }
		    {
			 V T9j, T9u, Ta1, Ta4;
			 T9j = VADD(T93, T9i);
			 T9u = VBYI(VADD(T9q, T9t));
			 ST(&(xo[WS(os, 111)]), VSUB(T9j, T9u), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 17)]), VADD(T9j, T9u), ovs, &(xo[WS(os, 1)]));
			 Ta1 = VBYI(VSUB(T9Z, Ta0));
			 Ta4 = VSUB(Ta2, Ta3);
			 ST(&(xo[WS(os, 63)]), VADD(Ta1, Ta4), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 65)]), VSUB(Ta4, Ta1), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V Ta5, Ta6, T9v, T9w;
			 Ta5 = VBYI(VADD(Ta0, T9Z));
			 Ta6 = VADD(Ta2, Ta3);
			 ST(&(xo[WS(os, 1)]), VADD(Ta5, Ta6), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 127)]), VSUB(Ta6, Ta5), ovs, &(xo[WS(os, 1)]));
			 T9v = VSUB(T93, T9i);
			 T9w = VBYI(VSUB(T9t, T9q));
			 ST(&(xo[WS(os, 81)]), VSUB(T9v, T9w), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 47)]), VADD(T9v, T9w), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T9z, T9C, T9P, T9W;
			 T9z = VBYI(VSUB(T9x, T9y));
			 T9C = VSUB(T9A, T9B);
			 ST(&(xo[WS(os, 49)]), VADD(T9z, T9C), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 79)]), VSUB(T9C, T9z), ovs, &(xo[WS(os, 1)]));
			 T9P = VADD(T9H, T9O);
			 T9W = VBYI(VADD(T9S, T9V));
			 ST(&(xo[WS(os, 97)]), VSUB(T9P, T9W), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 31)]), VADD(T9P, T9W), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T9X, T9Y, T9D, T9E;
			 T9X = VSUB(T9H, T9O);
			 T9Y = VBYI(VSUB(T9V, T9S));
			 ST(&(xo[WS(os, 95)]), VSUB(T9X, T9Y), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 33)]), VADD(T9X, T9Y), ovs, &(xo[WS(os, 1)]));
			 T9D = VBYI(VADD(T9y, T9x));
			 T9E = VADD(T9A, T9B);
			 ST(&(xo[WS(os, 15)]), VADD(T9D, T9E), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 113)]), VSUB(T9E, T9D), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T68, T6r, T6j, T6n, T6E, T6T, T6L, T6P, T5T, T6Q, T6S, T6g, T6o, T6x, T6I;
		    V T6q;
		    {
			 V T60, T6h, T67, T6i;
			 {
			      V T5W, T5Z, T63, T66;
			      T5W = VSUB(T5U, T5V);
			      T5Z = VSUB(T5X, T5Y);
			      T60 = VFMA(LDK(KP803207531), T5W, VMUL(LDK(KP595699304), T5Z));
			      T6h = VFNMS(LDK(KP595699304), T5W, VMUL(LDK(KP803207531), T5Z));
			      T63 = VSUB(T61, T62);
			      T66 = VSUB(T64, T65);
			      T67 = VFNMS(LDK(KP595699304), T66, VMUL(LDK(KP803207531), T63));
			      T6i = VFMA(LDK(KP595699304), T63, VMUL(LDK(KP803207531), T66));
			 }
			 T68 = VSUB(T60, T67);
			 T6r = VADD(T6h, T6i);
			 T6j = VSUB(T6h, T6i);
			 T6n = VADD(T60, T67);
		    }
		    {
			 V T6A, T6J, T6D, T6K;
			 {
			      V T6y, T6z, T6B, T6C;
			      T6y = VADD(T5V, T5U);
			      T6z = VADD(T5X, T5Y);
			      T6A = VFMA(LDK(KP989176509), T6y, VMUL(LDK(KP146730474), T6z));
			      T6J = VFNMS(LDK(KP146730474), T6y, VMUL(LDK(KP989176509), T6z));
			      T6B = VADD(T62, T61);
			      T6C = VADD(T64, T65);
			      T6D = VFNMS(LDK(KP146730474), T6C, VMUL(LDK(KP989176509), T6B));
			      T6K = VFMA(LDK(KP146730474), T6B, VMUL(LDK(KP989176509), T6C));
			 }
			 T6E = VSUB(T6A, T6D);
			 T6T = VADD(T6J, T6K);
			 T6L = VSUB(T6J, T6K);
			 T6P = VADD(T6A, T6D);
		    }
		    {
			 V T5L, T6v, T6f, T6H, T5S, T6G, T6c, T6w, T5K, T6d;
			 T5K = VADD(T4q, T4H);
			 T5L = VSUB(T5J, T5K);
			 T6v = VADD(T5J, T5K);
			 T6d = VADD(T4V, T4W);
			 T6f = VSUB(T6d, T6e);
			 T6H = VADD(T6e, T6d);
			 {
			      V T5O, T5R, T6a, T6b;
			      T5O = VFMA(LDK(KP956940335), T5M, VMUL(LDK(KP290284677), T5N));
			      T5R = VFNMS(LDK(KP290284677), T5Q, VMUL(LDK(KP956940335), T5P));
			      T5S = VSUB(T5O, T5R);
			      T6G = VADD(T5O, T5R);
			      T6a = VFNMS(LDK(KP290284677), T5M, VMUL(LDK(KP956940335), T5N));
			      T6b = VFMA(LDK(KP290284677), T5P, VMUL(LDK(KP956940335), T5Q));
			      T6c = VSUB(T6a, T6b);
			      T6w = VADD(T6a, T6b);
			 }
			 T5T = VSUB(T5L, T5S);
			 T6Q = VADD(T6H, T6G);
			 T6S = VADD(T6v, T6w);
			 T6g = VSUB(T6c, T6f);
			 T6o = VADD(T6f, T6c);
			 T6x = VSUB(T6v, T6w);
			 T6I = VSUB(T6G, T6H);
			 T6q = VADD(T5L, T5S);
		    }
		    {
			 V T69, T6k, T6R, T6U;
			 T69 = VADD(T5T, T68);
			 T6k = VBYI(VADD(T6g, T6j));
			 ST(&(xo[WS(os, 109)]), VSUB(T69, T6k), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 19)]), VADD(T69, T6k), ovs, &(xo[WS(os, 1)]));
			 T6R = VBYI(VSUB(T6P, T6Q));
			 T6U = VSUB(T6S, T6T);
			 ST(&(xo[WS(os, 61)]), VADD(T6R, T6U), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 67)]), VSUB(T6U, T6R), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T6V, T6W, T6l, T6m;
			 T6V = VBYI(VADD(T6Q, T6P));
			 T6W = VADD(T6S, T6T);
			 ST(&(xo[WS(os, 3)]), VADD(T6V, T6W), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 125)]), VSUB(T6W, T6V), ovs, &(xo[WS(os, 1)]));
			 T6l = VSUB(T5T, T68);
			 T6m = VBYI(VSUB(T6j, T6g));
			 ST(&(xo[WS(os, 83)]), VSUB(T6l, T6m), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 45)]), VADD(T6l, T6m), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T6p, T6s, T6F, T6M;
			 T6p = VBYI(VSUB(T6n, T6o));
			 T6s = VSUB(T6q, T6r);
			 ST(&(xo[WS(os, 51)]), VADD(T6p, T6s), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 77)]), VSUB(T6s, T6p), ovs, &(xo[WS(os, 1)]));
			 T6F = VADD(T6x, T6E);
			 T6M = VBYI(VADD(T6I, T6L));
			 ST(&(xo[WS(os, 99)]), VSUB(T6F, T6M), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 29)]), VADD(T6F, T6M), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T6N, T6O, T6t, T6u;
			 T6N = VSUB(T6x, T6E);
			 T6O = VBYI(VSUB(T6L, T6I));
			 ST(&(xo[WS(os, 93)]), VSUB(T6N, T6O), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 35)]), VADD(T6N, T6O), ovs, &(xo[WS(os, 1)]));
			 T6t = VBYI(VADD(T6o, T6n));
			 T6u = VADD(T6q, T6r);
			 ST(&(xo[WS(os, 13)]), VADD(T6t, T6u), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 115)]), VSUB(T6u, T6t), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 128, XSIMD_STRING("n1bv_128"), {938, 186, 144, 0}, &GENUS, 0, 0, 0, 0 };

void XSIMD(codelet_n1bv_128) (planner *p) {
     X(kdft_register) (p, n1bv_128, &desc);
}

#endif				/* HAVE_FMA */
