;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                     ;;;
;;;                      JUNTA DE ANDALUCÍA                             ;;;
;;;                      Copyright (c) 2007                             ;;;
;;;                      All Rights Reserved.                           ;;;
;;;                                                                     ;;;
;;;  Distribution policy.                                               ;;;
;;;                                                                     ;;;
;;;  Free for any use.                                                  ;;;
;;;                                                                     ;;;
;;;  All the work is based on the Festvox Toolkit, provided by:         ;;;
;;;    - Carnegie Mellon University (http://www.festvox.org)            ;;;
;;;                                                                     ;;;
;;;  The copyright below belongs to the original Festvox project; it    ;;;
;;;  therefore applies to the present work.                             ;;;
;;;                                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                     ;;;
;;;  Standard Spanish female voice                                      ;;;
;;;                                                                     ;;;
;;;  Contractor: Consejería de Innovación, Ciencia y Empresa            ;;;
;;;              de la Junta de Andalucía                               ;;;
;;;                                                                     ;;;
;;;  Developed by: MP Sistemas and                                      ;;;
;;;                Intelligent Dialogue Systems S.L. (INDISYS)          ;;;
;;;                                                                     ;;;
;;;  Authors:   Del Solar, Carmen <c.delsolar@indisys.es>               ;;;
;;;             González, Jesús   <j.gonzalez@indisys.es>               ;;;
;;;             Manchón, Pilar    <p.manchon@indisys.es>                ;;;
;;;             Martín, Antonio   <amam@mpsistemas.es>                  ;;;
;;;             Martínez, Diego   <d.martinez@indisys.es>               ;;;
;;;             Pérez, Guillermo  <g.perez@indisys.es>                  ;;;
;;;             Varela, Víctor    <vmvr@mpsistemas.es>                  ;;;
;;;                                                                     ;;;
;;;  Voice Talent:  Silvia Fernández                                    ;;;
;;;                                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                     ;;;
;;;                     Carnegie Mellon University                      ;;;
;;;                  and Alan W Black and Kevin Lenzo                   ;;;
;;;                      Copyright (c) 1998-2000                        ;;;
;;;                        All Rights Reserved.                         ;;;
;;;                                                                     ;;;
;;; Permission is hereby granted, free of charge, to use and distribute ;;;
;;; this software and its documentation without restriction, including  ;;;
;;; without limitation the rights to use, copy, modify, merge, publish, ;;;
;;; distribute, sublicense, and/or sell copies of this work, and to     ;;;
;;; permit persons to whom this work is furnished to do so, subject to  ;;;
;;; the following conditions:                                           ;;;
;;;  1. The code must retain the above copyright notice, this list of   ;;;
;;;     conditions and the following disclaimer.                        ;;;
;;;  2. Any modifications must be clearly marked as such.               ;;;
;;;  3. Original authors' names are not deleted.                        ;;;
;;;  4. The authors' names are not used to endorse or promote products  ;;;
;;;     derived from this software without specific prior written       ;;;
;;;     permission.                                                     ;;;
;;;                                                                     ;;;
;;; CARNEGIE MELLON UNIVERSITY AND THE CONTRIBUTORS TO THIS WORK        ;;;
;;; DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     ;;;
;;; ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  ;;;
;;; SHALL CARNEGIE MELLON UNIVERSITY NOR THE CONTRIBUTORS BE LIABLE     ;;;
;;; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   ;;;
;;; WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  ;;;
;;; AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         ;;;
;;; ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      ;;;
;;; THIS SOFTWARE.                                                      ;;;
;;;                                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Duration models autotrained by festvox
;; dur.S50.tree
(set! JuntaDeAndalucia_es_sf_durtreeZ::phone_durs '
;((# 0.2 0.1)
((# 0.1 0.03)
 (hh 0.12 0.018028)
 (dh 0.04 0.013333)
 (v 0.035 0)
 (z 0.100909 0.04592)
 (zh 0.053333 0.011547)
 (sh 0.14 0.034351)
 (ax 0.084565 0.016508)
 (g 0.054644 0.026496)
 (G 0.046677 0.010591)
 (ch 0.112619 0.025591)
 (th 0.088747 0.022467)
 (x 0.098632 0.032392)
 (rr 0.077428 0.031749)
 (D 0.049948 0.010812)
 (l 0.069622 0.048015)
 (u1 0.089608 0.023566)
 (B 0.045526 0.010719)
 (a1 0.07989 0.027613)
 (ll 0.065625 0.072751)
 (n 0.066313 0.032435)
 (p 0.084606 0.050181)
 (e 0.06651 0.027805)
 (ny 0.092353 0.017988)
 (e1 0.076036 0.044356)
 (a 0.082285 0.053682)
 (i1 0.078268 0.0235)
 (b 0.060996 0.034172)
 (d 0.051222 0.029051)
 (u 0.072572 0.026523)
 (t 0.066724 0.02478)
 (f 0.086095 0.025328)
 (o1 0.080226 0.031165)
 (s 0.08758 0.033673)
 (o 0.08708 0.055023)
 (r 0.041232 0.033442)
 (k 0.080686 0.029758)
 (i 0.066889 0.026272)
 (m 0.069276 0.030569))
; (# 0.201734 0.086575))
)


(set! JuntaDeAndalucia_es_sf_durtreeZ::zdur_tree '
((name is #)
 ((p.R:SylStructure.parent.parent.pbreak is BB)
  ((0.0 2.0))
  ((0.0 0.0)))
((p.name is #)
 ((name is p)
  ((R:SylStructure.parent.parent.gpos is content)
   ((1.39884 0.717445))
   ((2.61382 1.79139)))
  ((name is k)
   ((n.ph_vfront is 3) ((1.69871 1.3414)) ((2.01716 1.85824)))
   ((n.name is a)
    ((1.09705 2.1486))
    ((name is n)
     ((1.70522 3.54519))
     ((name is a)
      ((1.4803 2.50904))
      ((syl_final is 0)
       ((ph_cvox is -)
        ((n.name is n)
         ((2.36871 3.2419))
         ((name is s)
          ((1.17319 2.92863))
          ((R:SylStructure.parent.R:Syllable.p.syl_break is 0)
           ((n.ph_vlng is 0)
;Aumentamos
;duración de la primera
;"e" en expuesto.
            ((name is e) ((1.44334 3)) ((2.27583 3.18023)))
;            ((name is e) ((1.44334 2.47847)) ((2.27583 3.18023)))
            ((2.61976 1.89063)))
           ((2.86471 3.13562)))))
        ((n.name is e)
         ((1.55258 3.39688))
         ((n.ph_vfront is 3) ((2.0191 2.7294)) ((2.28983 3.05406)))))
       ((1.84157 3.39766))))))))
 ((n.name is #)
  ((ph_cvox is -)
   ((name is s)
    ((R:SylStructure.parent.syl_break is 3)
     ((0.58662 0.450509))
     ((p.ph_vfront is 3) ((0.515255 0.599253)) ((0.728458 1.16377))))
    ((name is e)
     ((0.922663 1.17562))
     ((R:SylStructure.parent.syl_break is 3)
;Reducimos duración de la "a"
;en "hola".
      ((ph_vrnd is -) ((1.60747 0.80228)) ((0.870095 1.15112)))
;      ((ph_vrnd is -) ((1.60747 1.90228)) ((0.870095 1.15112)))
      ((p.ph_vheight is 1)
;Reducimos duración de la
;segunda "o" en "escritorio"
       ((2.99258 0.7303))
;       ((2.99258 2.7303))
       ((R:SylStructure.parent.R:Syllable.p.stress is 0)
        ((1.86405 1.63672))
        ((p.ph_cvox is -)
         ((ph_vrnd is -) ((2.31061 1.95605)) ((1.27895 1.92404)))
;Reducimos duración de la "o"
;en "vídeo".
         ((name is a) ((2.7139 1.06957)) ((2.03165 0.74827)))))))))
;         ((name is a) ((2.7139 2.06957)) ((2.03165 2.34827)))))))))
   ((R:SylStructure.parent.syl_break is 3)
    ((1.53518 1.68237))
    ((name is n)
     ((1.0228 2.97299))
     ((p.ph_vfront is 2) ((2.9852 3.82722)) ((2.99345 4.44501))))))
  ((R:SylStructure.parent.syl_break is 4)
   ((name is e)
    ((0.680561 1.65554))
    ((ph_cvox is -)
     ((p.name is i)
      ((0.638805 0.123419))
      ((ph_vrnd is -)
       ((p.ph_vfront is 1)
        ((0.909162 0.923869))
        ((n.ph_vlng is 0)
         ((R:SylStructure.parent.R:Syllable.p.stress is 0)
          ((0.565983 0.457851))
          ((0.556052 0.744016)))
         ((p.ph_vheight is -)
          ((n.ph_vfront is 1)
           ((0.599244 0.462317))
           ((p.ph_cvox is -)
            ((0.510034 0.00360417))
            ((0.66554 0.294298))))
          ((0.631069 0.512345)))))
       ((name is o) ((0.301772 0.840077)) ((0.855244 1.31929)))))
     ((p.name is i1)
      ((0.932388 0.640859))
      ((n.ph_vfront is 1)
       ((n.name is e) ((0.436998 -0.0540583)) ((0.351757 -0.286597)))
       ((n.ph_vfront is 2)
        ((p.ph_vheight is 2)
         ((0.686381 -0.137549))
         ((0.891959 -0.0114558)))
        ((p.ph_vheight is 2)
         ((1.47766 0.484771))
         ((p.name is a1) ((0.672887 0.278239)) ((0.764481 0.12472)))))))))
   ((p.ph_cvox is -)
    ((p.name is a1)
     ((ph_cvox is -)
      ((R:SylStructure.parent.R:Syllable.p.stress is 0)
       ((1.12996 0.565797))
       ((R:SylStructure.parent.R:Syllable.p.syl_break is 1)
        ((0.791921 -0.0496421))
        ((n.ph_vfront is 1) ((0.761858 0.128319)) ((0.54615 0.311899)))))
      ((name is D)
       ((n.name is o) ((0.977966 0.283332)) ((0.832922 0.223189)))
       ((n.ph_vlng is 0)
        ((n.name is s)
         ((0.23905 -0.135957))
         ((R:SylStructure.parent.R:Syllable.p.syl_break is 0)
          ((R:SylStructure.parent.syl_break is 1)
           ((name is r) ((0.474043 0.160165)) ((0.518462 0.206787)))
           ((0.531257 0.335826)))
          ((0.480857 0.0449325))))
        ((n.name is a)
         ((0.381315 -0.245906))
         ((name is r) ((0.193306 -0.180657)) ((0.362095 -0.088539)))))))
     ((p.name is i1)
      ((ph_cvox is -)
       ((R:SylStructure.parent.R:Syllable.p.stress is 0)
        ((0.594485 -0.295124))
        ((name is a)
         ((0.314431 -0.182933))
         ((n.ph_vfront is 1)
          ((0.535685 -0.0730543))
          ((0.654803 0.0770699)))))
       ((name is n)
        ((0.440129 -0.0351034))
        ((name is D)
         ((0.985799 0.736319))
         ((n.ph_vfront is 3)
          ((1.04439 0.692962))
          ((syl_final is 0)
           ((0.649662 0.119847))
           ((0.827109 0.409921)))))))
      ((name is t)
       ((n.name is i1)
        ((0.881236 0.721517))
        ((p.ph_vfront is 1)
         ((R:SylStructure.parent.syl_break is 0)
          ((0.597866 0.242262))
          ((0.627125 0.407963)))
         ((n.name is a)
          ((0.576405 -0.359077))
          ((R:SylStructure.parent.R:Syllable.p.syl_break is 1)
           ((0.688037 0.219334))
           ((n.name is r)
            ((0.534117 0.216276))
            ((p.ph_vfront is 3)
             ((0.399749 -0.285264))
             ((R:SylStructure.parent.syl_break is 1)
              ((n.ph_vfront is 3)
               ((0.569224 -0.184872))
               ((n.ph_vfront is 1)
                ((0.540024 -0.0462897))
                ((0.635882 -0.0172609))))
              ((n.ph_vfront is 1)
               ((2.12276 0.15173))
               ((0.539403 -0.0343417))))))))))
       ((n.name is r)
        ((p.name is i)
         ((name is e1) ((0.302174 -0.460992)) ((0.736284 -0.446908)))
         ((name is o1)
          ((0.595849 0.409437))
          ((syl_final is 0)
           ((name is p)
            ((0.314138 -0.22117))
            ((p.name is p)
             ((R:SylStructure.parent.syl_break is 0)
              ((0.389673 -0.164638))
              ((0.328768 0.050415)))
             ((R:SylStructure.parent.syl_break is 1)
              ((name is a1)
               ((0.498863 0.0218678))
               ((0.524881 -0.00375797)))
              ((R:SylStructure.parent.R:Syllable.p.syl_break is 1)
               ((p.ph_vheight is -)
                ((0.666718 0.178621))
                ((0.513893 0.0337938)))
               ((0.742348 0.323571))))))
           ((R:SylStructure.parent.parent.gpos is content)
            ((name is e)
             ((0.405559 -0.283797))
             ((R:SylStructure.parent.R:Syllable.p.syl_break is 0)
              ((0.430262 -0.0525111))
              ((0.609543 -0.0237046))))
            ((0.452537 -0.00289731))))))
        ((R:SylStructure.parent.syl_break is 3)
         ((ph_cvox is -) ((0.587134 0.508943)) ((0.63599 0.125144)))
         ((n.name is p)
          ((name is s)
           ((p.ph_vheight is 2)
            ((0.310101 -1.13986))
            ((0.313107 -1.25122)))
           ((R:SylStructure.parent.R:Syllable.p.syl_break is 1)
            ((p.name is s)
             ((0.303864 -0.512478))
             ((p.ph_vheight is 2)
              ((0.39092 -0.403791))
              ((0.52373 -0.320796))))
            ((0.488879 -0.243219))))
          ((n.name is n)
           ((p.name is i)
            ((ph_vrnd is -)
             ((0.311974 -0.875948))
             ((syl_final is 0)
              ((0.291692 -1.04774))
              ((0.321289 -1.21861))))
            ((name is u)
             ((0.776816 0.084626))
             ((name is e)
              ((p.ph_vheight is -)
               ((R:SylStructure.parent.syl_break is 0)
                ((0.557097 -0.172256))
                ((0.622928 -0.473895)))
               ((R:SylStructure.parent.parent.gpos is content)
                ((0.423916 -0.610429))
                ((0.365111 -0.91746))))
              ((name is o1)
               ((0.576263 -0.00984))
               ((ph_cvox is -)
                ((syl_final is 0)
                 ((ph_vrnd is -)
                  ((p.ph_vfront is 3)
                   ((0.404137 -0.419853))
                   ((p.ph_vheight is -)
                    ((R:SylStructure.parent.R:Syllable.p.syl_break
                      is
                      0)
                     ((0.534066 -0.167007))
                     ((1.21741 -0.035395)))
                    ((1.40309 -0.26234))))
                  ((R:SylStructure.parent.R:Syllable.p.syl_break is 1)
                   ((R:SylStructure.parent.syl_break is 0)
                    ((0.276575 -0.370802))
                    ((0.232531 -0.359175)))
                   ((0.314785 -0.276304))))
                 ((R:SylStructure.parent.R:Syllable.p.syl_break is 0)
                  ((0.528855 -0.589188))
                  ((0.539975 -0.197346))))
                ((0.588546 -0.0429144)))))))
           ((n.name is k)
            ((name is s)
             ((p.ph_vheight is 2)
              ((0.305146 -1.07695))
              ((0.364399 -0.922714)))
             ((ph_cvox is -)
              ((syl_final is 0)
               ((0.295271 -0.711914))
               ((name is i)
                ((0.371904 -0.626539))
                ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                 ((p.ph_vheight is -)
                  ((0.499854 -0.320443))
                  ((0.50405 -0.504793)))
                 ((0.287497 -0.517609)))))
              ((R:SylStructure.parent.R:Syllable.p.syl_break is 0)
               ((0.514477 -0.00819528))
               ((p.name is e)
                ((0.309511 -0.262987))
                ((0.420376 -0.182703))))))
            ((n.name is l)
             ((name is e)
              ((p.ph_vheight is -)
               ((0.46845 -0.648784))
               ((0.296416 -1.06993)))
              ((name is n)
               ((0.291888 -0.953903))
               ((name is a)
                ((syl_final is 0)
                 ((0.235562 -0.409485))
                 ((0.30547 -0.597531)))
                ((p.ph_vheight is 2)
                 ((0.523983 -0.0689181))
                 ((syl_final is 0)
                  ((R:SylStructure.parent.R:Syllable.p.syl_break is 0)
                   ((0.377412 -0.400918))
                   ((0.418738 -0.0808343)))
                  ((ph_vrnd is -)
                   ((0.569515 -0.305343))
                   ((0.358209 -0.500865))))))))
             ((n.name is a)
              ((name is s)
               ((p.name is a)
                ((0.32413 0.53147))
                ((0.382793 0.126046)))
               ((p.name is th)
                ((0.624296 -1.13859))
                ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                 ((syl_final is 0)
                  ((name is m)
                   ((0.34735 -0.300174))
                   ((p.name is a)
                    ((R:SylStructure.parent.R:Syllable.p.syl_break
                      is
                      0)
                     ((R:SylStructure.parent.syl_break is 0)
                      ((0.410129 -0.750226))
                      ((0.105477 -0.627771)))
                     ((0.270503 -0.523912)))
                    ((name is r)
                     ((0.25091 -0.365767))
                     ((ph_cvox is -)
                      ((name is k)
                       ((0.285027 -0.484522))
                       ((0.557341 -0.571809)))
                      ((p.name is i)
                       ((0.39504 -0.363326))
                       ((name is l)
                        ((0.171973 -0.459461))
                        ((name is ll)
                         ((0.162498 -0.461727))
                         ((0.326219 -0.537266)))))))))
                  ((R:SylStructure.parent.parent.gpos is content)
                   ((p.ph_vheight is -)
                    ((0.579997 -0.183013))
                    ((0.685874 -0.189769)))
                   ((0.45359 -0.411793))))
                 ((syl_final is 0)
                  ((name is r)
                   ((1.14718 -0.089956))
                   ((p.ph_vfront is 1)
                    ((0.486501 -0.244553))
                    ((p.name is o1)
                     ((0.549603 -0.249793))
                     ((0.812733 -0.350237)))))
                  ((0.501799 -0.466178))))))
              ((n.name is s)
               ((p.ph_vheight is -)
                ((name is u)
                 ((0.539513 0.23293))
                 ((ph_vrnd is -)
                  ((name is e)
                   ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                    ((0.468633 -0.382557))
                    ((0.480461 -0.0888884)))
                   ((syl_final is 0)
                    ((0.546447 -0.0287167))
                    ((0.36633 -0.121827))))
                  ((R:SylStructure.parent.syl_break is 0)
                   ((0.237808 -0.51297))
                   ((0.204142 -0.329796)))))
                ((name is e1)
                 ((0.634324 -0.0465193))
                 ((p.name is a)
                  ((0.613465 -0.854263))
                  ((name is n)
                   ((0.330936 -0.78999))
                   ((syl_final is 0)
                    ((p.name is e)
                     ((0.590339 -0.949148))
                     ((R:SylStructure.parent.syl_break is 0)
                      ((0.550535 -0.596734))
                      ((0.32921 -0.583404))))
                    ((R:SylStructure.parent.R:Syllable.p.syl_break
                      is
                      1)
                     ((0.637543 -0.337209))
                     ((0.617532 -0.575983))))))))
               ((n.name is m)
                ((name is r)
                 ((0.536128 0.194904))
                 ((name is a)
                  ((0.194412 -0.369039))
                  ((p.name is e)
                   ((0.798375 -0.345848))
                   ((ph_cvox is -)
                    ((p.ph_vheight is -)
                     ((p.name is t)
                      ((0.702893 -0.619531))
                      ((R:SylStructure.parent.R:Syllable.p.syl_break
                        is
                        1)
                       ((0.397489 -0.505884))
                       ((0.482486 -0.364778))))
                     ((0.54436 -0.618202)))
                    ((0.285214 -0.453057))))))
                ((name is D)
                 ((p.ph_vheight is 2)
                  ((p.name is e1)
                   ((0.753507 -0.956792))
                   ((0.719305 -0.598129)))
                  ((p.name is i)
                   ((0.872636 0.145197))
                   ((0.626621 -0.333768))))
                 ((name is f)
                  ((n.ph_vfront is 1)
                   ((0.775971 -0.192786))
                   ((1.09421 0.600377)))
                  ((n.name is rr)
                   ((R:SylStructure.parent.R:Syllable.p.syl_break is 1)
                    ((0.692562 0.0393187))
                    ((0.874221 0.19726)))
                   ((p.name is s)
                    ((name is p)
                     ((0.265581 -0.0218484))
                     ((name is d)
                      ((0.244991 -0.471653))
                      ((ph_cvox is -)
                       ((n.name is e)
                        ((0.477002 -0.554844))
                        ((name is e)
                         ((0.709628 -0.0524532))
                         ((ph_vrnd is -)
                          ((R:SylStructure.parent.syl_break is 0)
                           ((name is k)
                            ((0.388153 -0.328547))
                            ((syl_final is 0)
                             ((0.572909 -0.61898))
                             ((0.557376 -0.37506))))
                           ((n.ph_vlng is 0)
                            ((0.435031 -0.130999))
                            ((0.571758 -0.312657))))
                          ((R:SylStructure.parent.parent.gpos
                            is
                            content)
                           ((0.46174 -0.0539035))
                           ((0.420004 -0.317427))))))
                       ((name is b)
                        ((0.38743 -0.424749))
                        ((0.677129 0.214978))))))
                    ((n.name is u)
                     ((R:SylStructure.parent.R:Syllable.p.syl_break
                       is
                       1)
                      ((R:SylStructure.parent.syl_break is 0)
                       ((ph_cvox is -)
                        ((0.542205 -0.000613163))
                        ((0.613434 0.143706)))
                       ((0.842729 0.293317)))
                      ((p.ph_vfront is 1)
                       ((0.76225 -0.0915512))
                       ((R:SylStructure.parent.syl_break is 0)
                        ((0.486609 -0.331779))
                        ((0.490534 -0.181284)))))
                     ((name is d)
                      ((p.ph_vheight is 2)
                       ((R:SylStructure.parent.parent.gpos is content)
                        ((n.name is e)
                         ((0.224477 -0.104137))
                         ((0.323578 -0.124148)))
                        ((0.331981 -0.000309073)))
                       ((p.name is a)
                        ((R:SylStructure.parent.parent.gpos is content)
                         ((0.255614 -0.0902549))
                         ((0.339398 0.0178846)))
                        ((0.537129 0.147507))))
                      ((n.name is d)
                       ((name is s)
                        ((p.name is e)
                         ((0.425572 -0.596323))
                         ((0.471495 -0.44165)))
                        ((ph_cvox is -)
                         ((name is e)
                          ((0.524542 0.0837718))
                          ((p.ph_vheight is -)
                           ((R:SylStructure.parent.R:Syllable.p.stress
                             is
                             0)
                            ((0.435824 -0.0818721))
                            ((0.309977 -0.214893)))
                           ((0.399381 -0.277698))))
                         ((name is n)
                          ((p.ph_vheight is 2)
                           ((R:SylStructure.parent.syl_break is 0)
                            ((0.541586 0.204209))
                            ((0.791869 0.275536)))
                           ((0.599461 0.140992)))
                          ((R:SylStructure.parent.R:Syllable.p.syl_break
                            is
                            0)
                           ((0.54327 0.212264))
                           ((0.337232 -0.0636174))))))
                       ((name is s)
                        ((n.ph_vlng is l)
                         ((n.name is e1)
                          ((0.402777 0.674653))
                          ((p.name is o)
                           ((R:SylStructure.parent.syl_break is 0)
                            ((0.307848 0.0529693))
                            ((0.411417 0.179393)))
                           ((R:SylStructure.parent.syl_break is 0)
                            ((R:SylStructure.parent.R:Syllable.p.syl_break
                              is
                              0)
                             ((0.48249 0.490331))
                             ((0.426989 0.338382)))
                            ((p.ph_vfront is 1)
                             ((R:SylStructure.parent.R:Syllable.p.stress
                               is
                               0)
                              ((0.320359 0.17086))
                              ((0.343863 0.281991)))
                             ((n.name is e)
                              ((0.327184 0.256868))
                              ((0.50491 0.392043)))))))
                         ((n.name is t)
                          ((p.name is e)
                           ((0.333961 -1.11015))
                           ((p.ph_vheight is 2)
;expuesto ->alargamos
;la "s" (soluciona el pico de la palabra "este"
                            ((0.345527 -0.197564))
;                            ((0.345527 -0.897564))

                            ((0.421296 -0.720601))))
                          ((R:SylStructure.parent.syl_break is 0)
                           ((0.401669 0.0533069))
                           ((0.458224 -0.540821)))))
                        ((n.name is t)
                         ((name is n)
                          ((R:SylStructure.parent.R:Syllable.p.syl_break
                            is
                            0)
                           ((p.ph_vfront is 1)
                            ((0.55506 0.200333))
                            ((0.488165 0.25804)))
                           ((p.ph_vfront is 1)
                            ((0.461482 0.0275286))
                            ((0.533996 0.131461))))
                          ((p.name is a)
                           ((0.515085 0.122828))
                           ((p.ph_vheight is 1)
                            ((0.421072 -0.168712))
                            ((R:SylStructure.parent.syl_break is 0)
                             ((p.name is e)
                              ((0.430367 0.015296))
                              ((p.ph_vheight is -)
                               ((0.327793 -0.106608))
                               ((0.531994 -0.054758))))
                             ((0.502643 0.0499645))))))
                         ((n.name is ll)
                          ((1.23474 0.397762))
                          ((name is n)
                           ((n.ph_vfront is 1)
                            ((n.name is i)
                             ((0.504233 -0.236205))
                             ((syl_final is 0)
                              ((p.ph_vfront is 3)
                               ((0.168143 -0.639756))
                               ((0.269839 -0.531123)))
                              ((0.264835 -0.442885))))
                            ((R:SylStructure.parent.syl_break is 0)
                             ((p.name is o)
                              ((0.333584 -0.451559))
                              ((p.name is e)
                               ((0.315291 -0.396031))
                               ((p.ph_vheight is 1)
                                ((0.376997 -0.312178))
                                ((0.328582 -0.208295)))))
                             ((R:SylStructure.parent.R:Syllable.p.syl_break
                               is
                               1)
                              ((0.752288 0.0479682))
                              ((0.373832 -0.311147)))))
                           ((p.name is e1)
                            ((n.name is e)
                             ((name is r)
                              ((0.251903 -0.317176))
                              ((0.497236 -0.154181)))
                             ((n.name is o)
                              ((0.96836 0.0639111))
                              ((0.940511 0.206978))))
                            ((syl_final is 0)
                             ((name is i)
                              ((p.name is th)
                               ((n.name is o1)
                                ((R:SylStructure.parent.syl_break is 0)
                                 ((0.341164 -0.559804))
                                 ((0.356736 -0.376409)))
                                ((0.485352 -0.947358)))
                               ((p.name is k)
                                ((0.822699 -0.438172))
                                ((0.860856 -0.244651))))
                              ((name is u)
                               ((p.name is p)
                                ((0.68069 -0.129054))
;Alargar la "u" en
;"expuesto"                     ((0.68069 -0.729054))
                                ((0.874438 -0.386172)))
                               ((p.ph_vheight is -)
                                ((name is l)
                                 ((0.396422 -0.369614))
                                 ((name is r)
                                  ((n.name is e)
                                   ((0.512247 0.0781689))
                                   ((p.name is t)
                                    ((n.ph_vfront is 3)
                                     ((0.271537 -0.208502))
                                     ((0.220092 -0.304931)))
                                    ((R:SylStructure.parent.R:Syllable.p.syl_break
                                      is
                                      0)
                                     ((0.42753 -0.123399))
                                     ((0.279182 -0.0646067)))))
                                  ((n.name is i)
                                   ((0.672797 -0.0207969))
                                   ((0.912625 0.365517)))))
                                ((name is k)
                                 ((p.name is i)
                                  ((0.723516 0.186542))
                                  ((n.name is o)
                                   ((p.name is e)
                                    ((0.348852 -0.219078))
                                    ((R:SylStructure.parent.syl_break
                                      is
                                      0)
                                     ((0.434274 -0.414139))
                                     ((0.368995 -0.370488))))
                                   ((n.name is e)
                                    ((0.380439 -0.196868))
                                    ((n.ph_vfront is 1)
                                     ((0.52395 0.0643187))
                                     ((0.377622 -0.17863))))))
                                 ((R:SylStructure.parent.R:Syllable.p.syl_break
                                   is
                                   0)
                                  ((n.name is o1)
                                   ((0.595242 -0.0554636))
                                   ((n.name is i1)
                                    ((p.name is a)
                                     ((0.485034 -0.159782))
                                     ((p.ph_vfront is 1)
                                      ((0.552505 -0.229571))
                                      ((0.394064 -0.27504))))
                                    ((p.name is u)
                                     ((0.501731 -0.175104))
                                     ((p.name is o1)
                                      ((0.48857 -0.188077))
                                      ((n.name is e)
                                       ((p.ph_vheight is 2)
                                        ((name is l)
                                         ((0.210136 -0.467125))
                                         ((0.46344 -0.589764)))
                                        ((0.538532 -0.30292)))
                                       ((name is B)
                                        ((0.497785 -0.469802))
                                        ((name is l)
                                         ((p.name is a)
                                          ((0.109188 -0.377227))
                                          ((0.242631 -0.418276)))
                                         ((ph_cvox is -)
                                          ((p.ph_vheight is 1)
                                           ((0.635612 -0.62753))
                                           ((n.name is i)
                                            ((0.501426 -0.3283))
                                            ((0.551843 -0.196271))))
                                          ((R:SylStructure.parent.syl_break
                                            is
                                            0)
                                           ((p.name is i)
                                            ((0.499946 -0.210417))
                                            ((n.name is i)
                                             ((0.277201 -0.229012))
                                             ((name is r)
                                              ((0.181889 -0.497339))
                                              ((p.name is a)
                                               ((0.278271 -0.395153))
                                               ((0.447332 -0.336777))))))
                                           ((p.ph_vfront is 1)
                                            ((0.366595 -0.137099))
                                            ((0.421937 -0.262277))))))))))))
                                  ((name is l)
                                   ((0.198069 -0.326619))
                                   ((p.ph_vheight is 1)
                                    ((0.441639 -0.0161065))
                                    ((name is b)
                                     ((0.396146 -0.0997825))
                                     ((n.name is o)
                                      ((0.256401 -0.307126))
                                      ((n.name is e)
                                       ((p.name is e)
                                        ((0.703762 -0.174171))
                                        ((0.386231 -0.378942)))
                                       ((ph_cvox is -)
                                        ((p.name is a)
                                         ((0.709528 -0.180612))
                                         ((0.626934 -0.262482)))
                                        ((0.470016 -0.0466575)))))))))))))
                             ((name is k)
                              ((0.277719 -0.789844))
                              ((p.ph_vheight is 1)
                               ((n.name is D)
                                ((0.270853 -0.758068))
                                ((name is e1)
                                 ((0.31734 -0.340261))
                                 ((0.930707 0.00464439))))
                               ((ph_vrnd is -)
                                ((name is i)
                                 ((0.676863 0.101498))
                                 ((n.name is B)
                                  ((0.473952 -0.408446))
                                  ((name is a)
                                   ((p.ph_vheight is -)
                                    ((0.348686 -0.191064))
                                    ((p.name is e)
                                     ((0.421516 -0.424086))
                                     ((0.462488 -0.431251))))
                                   ((ph_cvox is -)
                                    ((p.name is t)
                                     ((n.ph_vfront is 1)
                                      ((0.587021 -0.367964))
                                      ((0.901614 -0.0397077)))
                                     ((R:SylStructure.parent.R:Syllable.p.syl_break
                                       is
                                       1)
                                      ((R:SylStructure.parent.syl_break
                                        is
                                        0)
                                       ((0.710832 -0.102013))
                                       ((0.629926 -0.207853)))
                                      ((n.name is D)
                                       ((0.600927 -0.0408735))
                                       ((0.905886 0.214364)))))
                                    ((p.name is a)
                                     ((0.377388 -0.12456))
                                     ((n.ph_vlng is 0)
                                      ((R:SylStructure.parent.syl_break
                                        is
                                        0)
                                       ((0.346089 -0.246833))
                                       ((0.340697 -0.145793)))
                                      ((0.218473 -0.267926))))))))
                                ((name is o)
                                 ((0.504375 -0.15633))
                                 ((0.822134 0.426659)))))))))))))))))))))))))))))))
    ((p.name is n)
     ((n.ph_vlng is 0)
      ((name is t)
       ((0.392799 -0.554436))
       ((name is e)
        ((R:SylStructure.parent.R:Syllable.p.syl_break is 1)
         ((0.410382 0.0455957))
         ((0.511796 0.24822)))
        ((name is i)
         ((1.64374 0.184911))
         ((name is o1)
          ((0.432972 0.0148772))
          ((name is a1)
           ((0.561565 -0.00167476))
           ((ph_vrnd is -)
            ((R:SylStructure.parent.parent.gpos is content)
             ((R:SylStructure.parent.syl_break is 0)
              ((syl_final is 0)
               ((0.39199 -0.247533))
               ((R:SylStructure.parent.R:Syllable.p.syl_break is 0)
                ((0.630857 -0.00366841))
                ((0.610679 -0.117724))))
              ((0.525734 -0.00554525)))
             ((0.197286 -0.194457)))
            ((R:SylStructure.parent.syl_break is 1)
             ((0.437423 -0.250483))
             ((0.487279 -0.111084)))))))))
      ((name is s)
       ((0.436899 0.174667))
       ((syl_final is 0)
        ((name is l)
         ((0.443288 -0.10267))
         ((n.name is e)
          ((R:SylStructure.parent.R:Syllable.p.stress is 0)
           ((0.493902 -0.702316))
           ((name is d) ((0.252447 -0.638716)) ((0.529747 -0.573313))))
          ((n.name is a)
           ((0.461804 -0.707107))
           ((n.name is i)
            ((name is d)
             ((0.189884 -0.697411))
             ((name is th)
              ((0.713848 -0.498714))
              ((0.689817 -0.590063))))
            ((name is t)
             ((n.ph_vfront is 3)
              ((0.560645 -0.468485))
              ((0.408842 -0.615758)))
             ((ph_cvox is -)
              ((n.name is o)
               ((0.545105 -0.288585))
               ((n.ph_vfront is 1)
                ((0.688619 -0.306037))
                ((0.813874 -0.253904))))
              ((n.ph_vfront is 3)
               ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                ((0.345269 -0.488186))
                ((0.268075 -0.578473)))
               ((0.741588 -0.29528)))))))))
        ((n.ph_vfront is 1) ((0.601214 -0.40166)) ((0.79706 0.193496))))))
     ((n.name is k)
      ((syl_final is 0)
       ((0.36047 -0.610383))
       ((R:SylStructure.parent.R:Syllable.p.syl_break is 1)
        ((name is e) ((0.370306 -0.55592)) ((0.294289 -0.382019)))
        ((p.name is l)
         ((0.327523 -0.370479))
         ((R:SylStructure.parent.syl_break is 0)
          ((0.564061 -0.0190114))
          ((0.34398 -0.234355))))))
      ((name is s)
       ((R:SylStructure.parent.syl_break is 0)
        ((0.675369 0.741276))
        ((0.420428 0.544104)))
       ((name is i)
        ((n.name is a1)
         ((0.907164 1.41307))
         ((n.name is th)
          ((0.65376 0.689365))
          ((p.name is m)
           ((0.497048 -0.275811))
           ((n.name is o)
            ((0.498402 -0.163535))
            ((n.name is e1)
             ((0.71573 -0.0948717))
             ((R:SylStructure.parent.syl_break is 1)
              ((0.921383 0.527776))
              ((p.name is d)
               ((0.547167 0.300802))
               ((syl_final is 0)
                ((0.876095 0.217966))
                ((0.556263 0.0553962))))))))))
        ((R:SylStructure.parent.syl_break is 3)
         ((0.6393 0.648181))
         ((n.name is l)
          ((p.name is r)
           ((0.479349 0.0239807))
           ((p.name is d)
            ((syl_final is 0)
             ((0.538469 -0.371323))
             ((0.348407 -0.57896)))
            ((p.name is m)
             ((0.290814 -0.489947))
             ((R:SylStructure.parent.syl_break is 0)
              ((0.411541 -0.154629))
              ((0.341094 -0.272769))))))
          ((n.name is r)
           ((p.name is m)
            ((0.495162 -0.0118814))
            ((name is o1)
             ((0.570266 0.477085))
             ((name is a1)
              ((0.680965 0.282062))
              ((R:SylStructure.parent.syl_break is 0)
               ((syl_final is 0)
                ((0.528045 0.247406))
                ((0.730788 0.206307)))
               ((0.640411 0.102844))))))
           ((name is i1)
            ((n.ph_vlng is 0)
             ((syl_final is 0)
              ((1.05739 0.26931))
              ((p.name is l)
               ((0.785433 0.180086))
               ((0.742763 -0.0177867))))
             ((0.863862 0.584803)))
            ((n.name is a)
             ((name is l)
              ((0.27039 -0.0499794))
              ((syl_final is 0)
               ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                ((0.423557 -0.363773))
                ((0.50362 -0.296371)))
               ((name is e)
                ((0.609181 -0.359632))
                ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                 ((0.680612 -0.122885))
                 ((0.494257 -0.26544))))))
             ((name is t)
              ((p.name is r)
               ((0.843105 0.656112))
               ((0.98759 0.382292)))
              ((n.name is ll)
               ((0.499053 0.45544))
               ((name is r)
                ((n.ph_vfront is 1)
                 ((0.2833 -0.497243))
                 ((0.421915 -0.258439)))
                ((name is a)
                 ((p.name is D)
                  ((0.439327 -0.00151004))
                  ((R:SylStructure.parent.syl_break is 0)
                   ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                    ((R:SylStructure.parent.R:Syllable.p.syl_break
                      is
                      0)
                     ((0.379698 -0.0773294))
                     ((n.name is m)
                      ((0.166278 -0.22038))
                      ((0.277592 -0.145511))))
                    ((0.396171 0.0412612)))
                   ((n.ph_vfront is 1)
                    ((0.371879 -0.32465))
                    ((n.name is s)
                     ((R:SylStructure.parent.R:Syllable.p.syl_break
                       is
                       1)
                      ((0.208049 -0.277281))
                      ((0.248123 -0.243952)))
                     ((p.name is r)
                      ((0.283357 -0.232573))
                      ((R:SylStructure.parent.R:Syllable.p.syl_break
                        is
                        0)
                       ((0.27202 -0.120709))
                       ((0.255247 -0.211831))))))))
                 ((name is o)
                  ((p.name is m)
                   ((R:SylStructure.parent.syl_break is 0)
                    ((0.51507 0.316944))
                    ((0.260536 -0.17704)))
                   ((p.name is r)
                    ((R:SylStructure.parent.syl_break is 0)
                     ((0.22948 -0.310416))
                     ((0.277581 -0.362698)))
                    ((R:SylStructure.parent.syl_break is 0)
                     ((0.533489 -0.00409192))
                     ((R:SylStructure.parent.R:Syllable.p.syl_break
                       is
                       1)
                      ((0.186342 -0.277491))
                      ((n.name is s)
                       ((0.204661 -0.192388))
                       ((p.name is D)
                        ((0.536147 -0.167842))
                        ((0.472422 -0.142169))))))))
                  ((p.name is m)
                   ((syl_final is 0)
                    ((n.ph_vfront is 1)
                     ((0.382711 -0.483366))
                     ((name is e1)
                      ((0.181529 -0.301141))
                      ((0.467123 -0.16015))))
                    ((name is a1)
                     ((0.396423 -0.231962))
                     ((R:SylStructure.parent.R:Syllable.p.syl_break
                       is
                       1)
                      ((0.531416 -0.124668))
                      ((0.711417 0.164806)))))
                   ((n.name is m)
                    ((name is e)
                     ((0.372996 -0.24492))
                     ((0.600763 -0.26375)))
                    ((n.name is e)
                     ((R:SylStructure.parent.R:Syllable.p.syl_break
                       is
                       1)
                      ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                       ((0.436454 -0.103705))
                       ((0.699879 0.140821)))
                      ((p.name is r)
                       ((0.496614 -0.171669))
                       ((0.711164 -0.28375))))
                     ((R:SylStructure.parent.R:Syllable.p.stress is 0)
                      ((n.name is i)
                       ((0.588497 -0.118462))
                       ((syl_final is 0)
                        ((n.name is a1)
                         ((0.536097 -0.0989615))
                         ((p.name is d)
                          ((0.45636 0.281067))
                          ((n.name is s)
                           ((0.49697 -0.0252153))
                           ((n.name is n)
                            ((p.name is r)
                             ((0.315102 -0.00122786))
                             ((0.608633 0.0805376)))
                            ((ph_cvox is -)
                             ((ph_vrnd is -)
                              ((R:SylStructure.parent.R:Syllable.p.syl_break
                                is
                                0)
                               ((1.10996 0.321772))
                               ((0.711659 0.24147)))
                              ((0.584702 0.149826)))
                             ((name is m)
                              ((0.471826 0.205092))
                              ((0.523717 0.0242412))))))))
                        ((n.name is n)
                         ((0.55005 -0.287254))
                         ((p.name is l)
                          ((0.370716 -0.149138))
                          ((R:SylStructure.parent.R:Syllable.p.syl_break
                            is
                            1)
                           ((p.name is d)
                            ((n.name is s)
                             ((0.405196 0.164051))
                             ((0.484262 -0.00671113)))
                            ((name is e)
                             ((0.546879 -0.191315))
                             ((0.526076 0.00257683))))
                           ((n.name is D)
                            ((0.381504 -0.0831661))
                            ((name is e)
                             ((0.665559 0.333171))
                             ((p.name is r)
                              ((0.492555 0.181321))
                              ((0.610771 0.256832))))))))))
                      ((n.ph_vlng is 0)
                       ((p.name is d)
                        ((0.478843 -0.014483))
                        ((ph_vrnd is -)
                         ((R:SylStructure.parent.R:Syllable.p.syl_break
                           is
                           0)
                          ((n.name is s)
                           ((0.549671 0.232719))
                           ((0.585989 0.10304)))
                          ((0.593948 0.248177)))
                         ((0.514615 -0.0324916))))
                       ((R:SylStructure.parent.R:Syllable.p.syl_break
                         is
                         1)
                        ((n.name is o)
                         ((0.622267 0.299752))
                         ((ph_cvox is -)
                          ((1.2156 0.549827))
                          ((0.782407 0.430019))))
                        ((0.776385 0.118865))))))))))))))))))))))))))
)
)


(provide 'Indisys_MP_es_sf_durtreeZ_dur)


