#  Copyright 2011 Sybren A. Stüvel <sybren@stuvel.eu>
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      https://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

"""ASN.1 definitions.

Not all ASN.1-handling code use these definitions, but when it does, they should be here.
"""

from pyasn1.type import univ, namedtype, tag


class PubKeyHeader(univ.Sequence):
    componentType = namedtype.NamedTypes(
            namedtype.NamedType('oid', univ.ObjectIdentifier()),
            namedtype.NamedType('parameters', univ.Null()),
    )


class OpenSSLPubKey(univ.Sequence):
    componentType = namedtype.NamedTypes(
            namedtype.NamedType('header', PubKeyHeader()),

            # This little hack (the implicit tag) allows us to get a Bit String as Octet String
            namedtype.NamedType('key', univ.OctetString().subtype(
                    implicitTag=tag.Tag(tagClass=0, tagFormat=0, tagId=3))),
    )


class AsnPubKey(univ.Sequence):
    """ASN.1 contents of DER encoded public key:

    RSAPublicKey ::= SEQUENCE {
         modulus           INTEGER,  -- n
         publicExponent    INTEGER,  -- e
    """

    componentType = namedtype.NamedTypes(
            namedtype.NamedType('modulus', univ.Integer()),
            namedtype.NamedType('publicExponent', univ.Integer()),
    )
