/*
 * @file src/include/gpl-boiler.h
 * @brief GPL boilerplate for usage messages
 */

/*
 * Copyright 2011 Oracle.  All rights reserved.
 *
 * This file is part of fedfs-utils.
 *
 * fedfs-utils is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 as
 * published by the Free Software Foundation.
 *
 * fedfs-utils is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License version 2.0 for more details.
 *
 * You should have received a copy of the GNU General Public License
 * version 2.0 along with fedfs-utils.  If not, see:
 *
 *	http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */

#ifndef _GPL_BOILER_H_
#define _GPL_BOILER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/**
 * GPLv2 boilerplate for usage messages
 */
static const char *fedfs_gpl_boilerplate =
		"\nCopyright 2010, 2011 Oracle.  All rights reserved.\n\n"
		"License GPLv2: "
		"<http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt>\n"
		"This is free software.  "
			"You are free to change and redistribute it.\n"
		"There is NO WARRANTY, to the extent permitted by law.\n";

#endif	/* !_GPL_BOILER_H_ */
