#ifndef ROSE_AMDGPUINSTRUCTIONENUM_H
#define ROSE_AMDGPUINSTRUCTIONENUM_H
enum AMDGPURegisterClass{
	amdgpu_regclass_hwr,
	amdgpu_regclass_pc,
	amdgpu_regclass_ttmp_sgpr,
	amdgpu_regclass_sgpr,
	amdgpu_regclass_sgpr_vec2,
	amdgpu_regclass_sgpr_vec4,
	amdgpu_regclass_sgpr_vec8,
	amdgpu_regclass_sgpr_vec16,
	amdgpu_regclass_vgpr,
	amdgpu_regclass_vgpr_vec2,
	amdgpu_regclass_vgpr_vec4,
	amdgpu_regclass_vgpr_vec8,
	amdgpu_regclass_vgpr_vec16
};
enum AMDGPUHardwareRegister{
	amdgpu_address_mode_32,
	amdgpu_exec,
	amdgpu_expcnt,
	amdgpu_export_icount,
	amdgpu_flat_scratch,
	amdgpu_gpr_alloc,
	amdgpu_ib_sts,
	amdgpu_lds_alloc,
	amdgpu_lds_gds_constant_message_count,
	amdgpu_lgkmcnt,
	amdgpu_m0,
	amdgpu_mode,
	amdgpu_pops_exiting_wave_id,
	amdgpu_private_base,
	amdgpu_private_limit,
	amdgpu_shared_base,
	amdgpu_shared_limit,
	amdgpu_status,
	amdgpu_tba,
	amdgpu_tid,
	amdgpu_tma,
	amdgpu_trap_base_address,
	amdgpu_trap_memory_address,
	amdgpu_vcc,
	amdgpu_vectory_memory_icount,
	amdgpu_vmcnt,
	amdgpu_xnack_mask,
	amdgpu_pc
};
enum AMDGPUScalarGeneralPurposeRegister{
	amdgpu_sgpr0,
	amdgpu_sgpr1,
	amdgpu_sgpr2,
	amdgpu_sgpr3,
	amdgpu_sgpr4,
	amdgpu_sgpr5,
	amdgpu_sgpr6,
	amdgpu_sgpr7,
	amdgpu_sgpr8,
	amdgpu_sgpr9,
	amdgpu_sgpr10,
	amdgpu_sgpr11,
	amdgpu_sgpr12,
	amdgpu_sgpr13,
	amdgpu_sgpr14,
	amdgpu_sgpr15,
	amdgpu_sgpr16,
	amdgpu_sgpr17,
	amdgpu_sgpr18,
	amdgpu_sgpr19,
	amdgpu_sgpr20,
	amdgpu_sgpr21,
	amdgpu_sgpr22,
	amdgpu_sgpr23,
	amdgpu_sgpr24,
	amdgpu_sgpr25,
	amdgpu_sgpr26,
	amdgpu_sgpr27,
	amdgpu_sgpr28,
	amdgpu_sgpr29,
	amdgpu_sgpr30,
	amdgpu_sgpr31,
	amdgpu_sgpr32,
	amdgpu_sgpr33,
	amdgpu_sgpr34,
	amdgpu_sgpr35,
	amdgpu_sgpr36,
	amdgpu_sgpr37,
	amdgpu_sgpr38,
	amdgpu_sgpr39,
	amdgpu_sgpr40,
	amdgpu_sgpr41,
	amdgpu_sgpr42,
	amdgpu_sgpr43,
	amdgpu_sgpr44,
	amdgpu_sgpr45,
	amdgpu_sgpr46,
	amdgpu_sgpr47,
	amdgpu_sgpr48,
	amdgpu_sgpr49,
	amdgpu_sgpr50,
	amdgpu_sgpr51,
	amdgpu_sgpr52,
	amdgpu_sgpr53,
	amdgpu_sgpr54,
	amdgpu_sgpr55,
	amdgpu_sgpr56,
	amdgpu_sgpr57,
	amdgpu_sgpr58,
	amdgpu_sgpr59,
	amdgpu_sgpr60,
	amdgpu_sgpr61,
	amdgpu_sgpr62,
	amdgpu_sgpr63,
	amdgpu_sgpr64,
	amdgpu_sgpr65,
	amdgpu_sgpr66,
	amdgpu_sgpr67,
	amdgpu_sgpr68,
	amdgpu_sgpr69,
	amdgpu_sgpr70,
	amdgpu_sgpr71,
	amdgpu_sgpr72,
	amdgpu_sgpr73,
	amdgpu_sgpr74,
	amdgpu_sgpr75,
	amdgpu_sgpr76,
	amdgpu_sgpr77,
	amdgpu_sgpr78,
	amdgpu_sgpr79,
	amdgpu_sgpr80,
	amdgpu_sgpr81,
	amdgpu_sgpr82,
	amdgpu_sgpr83,
	amdgpu_sgpr84,
	amdgpu_sgpr85,
	amdgpu_sgpr86,
	amdgpu_sgpr87,
	amdgpu_sgpr88,
	amdgpu_sgpr89,
	amdgpu_sgpr90,
	amdgpu_sgpr91,
	amdgpu_sgpr92,
	amdgpu_sgpr93,
	amdgpu_sgpr94,
	amdgpu_sgpr95,
	amdgpu_sgpr96,
	amdgpu_sgpr97,
	amdgpu_sgpr98,
	amdgpu_sgpr99,
	amdgpu_sgpr100,
	amdgpu_sgpr101,
	amdgpu_sgpr102,
	amdgpu_sgpr103
};
enum AMDGPUScalarGeneralPurposeRegisterVector2{
	amdgpu_sgpr_vec2_0,
	amdgpu_sgpr_vec2_2,
	amdgpu_sgpr_vec2_4,
	amdgpu_sgpr_vec2_6,
	amdgpu_sgpr_vec2_8,
	amdgpu_sgpr_vec2_10,
	amdgpu_sgpr_vec2_12,
	amdgpu_sgpr_vec2_14,
	amdgpu_sgpr_vec2_16,
	amdgpu_sgpr_vec2_18,
	amdgpu_sgpr_vec2_20,
	amdgpu_sgpr_vec2_22,
	amdgpu_sgpr_vec2_24,
	amdgpu_sgpr_vec2_26,
	amdgpu_sgpr_vec2_28,
	amdgpu_sgpr_vec2_30,
	amdgpu_sgpr_vec2_32,
	amdgpu_sgpr_vec2_34,
	amdgpu_sgpr_vec2_36,
	amdgpu_sgpr_vec2_38,
	amdgpu_sgpr_vec2_40,
	amdgpu_sgpr_vec2_42,
	amdgpu_sgpr_vec2_44,
	amdgpu_sgpr_vec2_46,
	amdgpu_sgpr_vec2_48,
	amdgpu_sgpr_vec2_50,
	amdgpu_sgpr_vec2_52,
	amdgpu_sgpr_vec2_54,
	amdgpu_sgpr_vec2_56,
	amdgpu_sgpr_vec2_58,
	amdgpu_sgpr_vec2_60,
	amdgpu_sgpr_vec2_62,
	amdgpu_sgpr_vec2_64,
	amdgpu_sgpr_vec2_66,
	amdgpu_sgpr_vec2_68,
	amdgpu_sgpr_vec2_70,
	amdgpu_sgpr_vec2_72,
	amdgpu_sgpr_vec2_74,
	amdgpu_sgpr_vec2_76,
	amdgpu_sgpr_vec2_78,
	amdgpu_sgpr_vec2_80,
	amdgpu_sgpr_vec2_82,
	amdgpu_sgpr_vec2_84,
	amdgpu_sgpr_vec2_86,
	amdgpu_sgpr_vec2_88,
	amdgpu_sgpr_vec2_90,
	amdgpu_sgpr_vec2_92,
	amdgpu_sgpr_vec2_94,
	amdgpu_sgpr_vec2_96,
	amdgpu_sgpr_vec2_98,
	amdgpu_sgpr_vec2_100,
	amdgpu_sgpr_vec2_102
};
enum AMDGPUScalarGeneralPurposeRegisterVector4{
	amdgpu_sgpr_vec4_0,
	amdgpu_sgpr_vec4_4,
	amdgpu_sgpr_vec4_8,
	amdgpu_sgpr_vec4_12,
	amdgpu_sgpr_vec4_16,
	amdgpu_sgpr_vec4_20,
	amdgpu_sgpr_vec4_24,
	amdgpu_sgpr_vec4_28,
	amdgpu_sgpr_vec4_32,
	amdgpu_sgpr_vec4_36,
	amdgpu_sgpr_vec4_40,
	amdgpu_sgpr_vec4_44,
	amdgpu_sgpr_vec4_48,
	amdgpu_sgpr_vec4_52,
	amdgpu_sgpr_vec4_56,
	amdgpu_sgpr_vec4_60,
	amdgpu_sgpr_vec4_64,
	amdgpu_sgpr_vec4_68,
	amdgpu_sgpr_vec4_72,
	amdgpu_sgpr_vec4_76,
	amdgpu_sgpr_vec4_80,
	amdgpu_sgpr_vec4_84,
	amdgpu_sgpr_vec4_88,
	amdgpu_sgpr_vec4_92,
	amdgpu_sgpr_vec4_96,
	amdgpu_sgpr_vec4_100
};
enum AMDGPUScalarGeneralPurposeRegisterVector8{
	amdgpu_sgpr_vec8_0,
	amdgpu_sgpr_vec8_8,
	amdgpu_sgpr_vec8_16,
	amdgpu_sgpr_vec8_24,
	amdgpu_sgpr_vec8_32,
	amdgpu_sgpr_vec8_40,
	amdgpu_sgpr_vec8_48,
	amdgpu_sgpr_vec8_56,
	amdgpu_sgpr_vec8_64,
	amdgpu_sgpr_vec8_72,
	amdgpu_sgpr_vec8_80,
	amdgpu_sgpr_vec8_88,
	amdgpu_sgpr_vec8_96
};
enum AMDGPUVectorGeneralPurposeRegister{
	amdgpu_vgpr0,
	amdgpu_vgpr1,
	amdgpu_vgpr2,
	amdgpu_vgpr3,
	amdgpu_vgpr4,
	amdgpu_vgpr5,
	amdgpu_vgpr6,
	amdgpu_vgpr7,
	amdgpu_vgpr8,
	amdgpu_vgpr9,
	amdgpu_vgpr10,
	amdgpu_vgpr11,
	amdgpu_vgpr12,
	amdgpu_vgpr13,
	amdgpu_vgpr14,
	amdgpu_vgpr15,
	amdgpu_vgpr16,
	amdgpu_vgpr17,
	amdgpu_vgpr18,
	amdgpu_vgpr19,
	amdgpu_vgpr20,
	amdgpu_vgpr21,
	amdgpu_vgpr22,
	amdgpu_vgpr23,
	amdgpu_vgpr24,
	amdgpu_vgpr25,
	amdgpu_vgpr26,
	amdgpu_vgpr27,
	amdgpu_vgpr28,
	amdgpu_vgpr29,
	amdgpu_vgpr30,
	amdgpu_vgpr31,
	amdgpu_vgpr32,
	amdgpu_vgpr33,
	amdgpu_vgpr34,
	amdgpu_vgpr35,
	amdgpu_vgpr36,
	amdgpu_vgpr37,
	amdgpu_vgpr38,
	amdgpu_vgpr39,
	amdgpu_vgpr40,
	amdgpu_vgpr41,
	amdgpu_vgpr42,
	amdgpu_vgpr43,
	amdgpu_vgpr44,
	amdgpu_vgpr45,
	amdgpu_vgpr46,
	amdgpu_vgpr47,
	amdgpu_vgpr48,
	amdgpu_vgpr49,
	amdgpu_vgpr50,
	amdgpu_vgpr51,
	amdgpu_vgpr52,
	amdgpu_vgpr53,
	amdgpu_vgpr54,
	amdgpu_vgpr55,
	amdgpu_vgpr56,
	amdgpu_vgpr57,
	amdgpu_vgpr58,
	amdgpu_vgpr59,
	amdgpu_vgpr60,
	amdgpu_vgpr61,
	amdgpu_vgpr62,
	amdgpu_vgpr63,
	amdgpu_vgpr64,
	amdgpu_vgpr65,
	amdgpu_vgpr66,
	amdgpu_vgpr67,
	amdgpu_vgpr68,
	amdgpu_vgpr69,
	amdgpu_vgpr70,
	amdgpu_vgpr71,
	amdgpu_vgpr72,
	amdgpu_vgpr73,
	amdgpu_vgpr74,
	amdgpu_vgpr75,
	amdgpu_vgpr76,
	amdgpu_vgpr77,
	amdgpu_vgpr78,
	amdgpu_vgpr79,
	amdgpu_vgpr80,
	amdgpu_vgpr81,
	amdgpu_vgpr82,
	amdgpu_vgpr83,
	amdgpu_vgpr84,
	amdgpu_vgpr85,
	amdgpu_vgpr86,
	amdgpu_vgpr87,
	amdgpu_vgpr88,
	amdgpu_vgpr89,
	amdgpu_vgpr90,
	amdgpu_vgpr91,
	amdgpu_vgpr92,
	amdgpu_vgpr93,
	amdgpu_vgpr94,
	amdgpu_vgpr95,
	amdgpu_vgpr96,
	amdgpu_vgpr97,
	amdgpu_vgpr98,
	amdgpu_vgpr99,
	amdgpu_vgpr100,
	amdgpu_vgpr101,
	amdgpu_vgpr102,
	amdgpu_vgpr103,
	amdgpu_vgpr104,
	amdgpu_vgpr105,
	amdgpu_vgpr106,
	amdgpu_vgpr107,
	amdgpu_vgpr108,
	amdgpu_vgpr109,
	amdgpu_vgpr110,
	amdgpu_vgpr111,
	amdgpu_vgpr112,
	amdgpu_vgpr113,
	amdgpu_vgpr114,
	amdgpu_vgpr115,
	amdgpu_vgpr116,
	amdgpu_vgpr117,
	amdgpu_vgpr118,
	amdgpu_vgpr119,
	amdgpu_vgpr120,
	amdgpu_vgpr121,
	amdgpu_vgpr122,
	amdgpu_vgpr123,
	amdgpu_vgpr124,
	amdgpu_vgpr125,
	amdgpu_vgpr126,
	amdgpu_vgpr127,
	amdgpu_vgpr128,
	amdgpu_vgpr129,
	amdgpu_vgpr130,
	amdgpu_vgpr131,
	amdgpu_vgpr132,
	amdgpu_vgpr133,
	amdgpu_vgpr134,
	amdgpu_vgpr135,
	amdgpu_vgpr136,
	amdgpu_vgpr137,
	amdgpu_vgpr138,
	amdgpu_vgpr139,
	amdgpu_vgpr140,
	amdgpu_vgpr141,
	amdgpu_vgpr142,
	amdgpu_vgpr143,
	amdgpu_vgpr144,
	amdgpu_vgpr145,
	amdgpu_vgpr146,
	amdgpu_vgpr147,
	amdgpu_vgpr148,
	amdgpu_vgpr149,
	amdgpu_vgpr150,
	amdgpu_vgpr151,
	amdgpu_vgpr152,
	amdgpu_vgpr153,
	amdgpu_vgpr154,
	amdgpu_vgpr155,
	amdgpu_vgpr156,
	amdgpu_vgpr157,
	amdgpu_vgpr158,
	amdgpu_vgpr159,
	amdgpu_vgpr160,
	amdgpu_vgpr161,
	amdgpu_vgpr162,
	amdgpu_vgpr163,
	amdgpu_vgpr164,
	amdgpu_vgpr165,
	amdgpu_vgpr166,
	amdgpu_vgpr167,
	amdgpu_vgpr168,
	amdgpu_vgpr169,
	amdgpu_vgpr170,
	amdgpu_vgpr171,
	amdgpu_vgpr172,
	amdgpu_vgpr173,
	amdgpu_vgpr174,
	amdgpu_vgpr175,
	amdgpu_vgpr176,
	amdgpu_vgpr177,
	amdgpu_vgpr178,
	amdgpu_vgpr179,
	amdgpu_vgpr180,
	amdgpu_vgpr181,
	amdgpu_vgpr182,
	amdgpu_vgpr183,
	amdgpu_vgpr184,
	amdgpu_vgpr185,
	amdgpu_vgpr186,
	amdgpu_vgpr187,
	amdgpu_vgpr188,
	amdgpu_vgpr189,
	amdgpu_vgpr190,
	amdgpu_vgpr191,
	amdgpu_vgpr192,
	amdgpu_vgpr193,
	amdgpu_vgpr194,
	amdgpu_vgpr195,
	amdgpu_vgpr196,
	amdgpu_vgpr197,
	amdgpu_vgpr198,
	amdgpu_vgpr199,
	amdgpu_vgpr200,
	amdgpu_vgpr201,
	amdgpu_vgpr202,
	amdgpu_vgpr203,
	amdgpu_vgpr204,
	amdgpu_vgpr205,
	amdgpu_vgpr206,
	amdgpu_vgpr207,
	amdgpu_vgpr208,
	amdgpu_vgpr209,
	amdgpu_vgpr210,
	amdgpu_vgpr211,
	amdgpu_vgpr212,
	amdgpu_vgpr213,
	amdgpu_vgpr214,
	amdgpu_vgpr215,
	amdgpu_vgpr216,
	amdgpu_vgpr217,
	amdgpu_vgpr218,
	amdgpu_vgpr219,
	amdgpu_vgpr220,
	amdgpu_vgpr221,
	amdgpu_vgpr222,
	amdgpu_vgpr223,
	amdgpu_vgpr224,
	amdgpu_vgpr225,
	amdgpu_vgpr226,
	amdgpu_vgpr227,
	amdgpu_vgpr228,
	amdgpu_vgpr229,
	amdgpu_vgpr230,
	amdgpu_vgpr231,
	amdgpu_vgpr232,
	amdgpu_vgpr233,
	amdgpu_vgpr234,
	amdgpu_vgpr235,
	amdgpu_vgpr236,
	amdgpu_vgpr237,
	amdgpu_vgpr238,
	amdgpu_vgpr239,
	amdgpu_vgpr240,
	amdgpu_vgpr241,
	amdgpu_vgpr242,
	amdgpu_vgpr243,
	amdgpu_vgpr244,
	amdgpu_vgpr245,
	amdgpu_vgpr246,
	amdgpu_vgpr247,
	amdgpu_vgpr248,
	amdgpu_vgpr249,
	amdgpu_vgpr250,
	amdgpu_vgpr251,
	amdgpu_vgpr252,
	amdgpu_vgpr253,
	amdgpu_vgpr254,
	amdgpu_vgpr255
};
enum AMDGPUVectorGeneralPurposeRegisterVector2{
	amdgpu_vgpr_vec2_0,
	amdgpu_vgpr_vec2_1,
	amdgpu_vgpr_vec2_2,
	amdgpu_vgpr_vec2_3,
	amdgpu_vgpr_vec2_4,
	amdgpu_vgpr_vec2_5,
	amdgpu_vgpr_vec2_6,
	amdgpu_vgpr_vec2_7,
	amdgpu_vgpr_vec2_8,
	amdgpu_vgpr_vec2_9,
	amdgpu_vgpr_vec2_10,
	amdgpu_vgpr_vec2_11,
	amdgpu_vgpr_vec2_12,
	amdgpu_vgpr_vec2_13,
	amdgpu_vgpr_vec2_14,
	amdgpu_vgpr_vec2_15,
	amdgpu_vgpr_vec2_16,
	amdgpu_vgpr_vec2_17,
	amdgpu_vgpr_vec2_18,
	amdgpu_vgpr_vec2_19,
	amdgpu_vgpr_vec2_20,
	amdgpu_vgpr_vec2_21,
	amdgpu_vgpr_vec2_22,
	amdgpu_vgpr_vec2_23,
	amdgpu_vgpr_vec2_24,
	amdgpu_vgpr_vec2_25,
	amdgpu_vgpr_vec2_26,
	amdgpu_vgpr_vec2_27,
	amdgpu_vgpr_vec2_28,
	amdgpu_vgpr_vec2_29,
	amdgpu_vgpr_vec2_30,
	amdgpu_vgpr_vec2_31,
	amdgpu_vgpr_vec2_32,
	amdgpu_vgpr_vec2_33,
	amdgpu_vgpr_vec2_34,
	amdgpu_vgpr_vec2_35,
	amdgpu_vgpr_vec2_36,
	amdgpu_vgpr_vec2_37,
	amdgpu_vgpr_vec2_38,
	amdgpu_vgpr_vec2_39,
	amdgpu_vgpr_vec2_40,
	amdgpu_vgpr_vec2_41,
	amdgpu_vgpr_vec2_42,
	amdgpu_vgpr_vec2_43,
	amdgpu_vgpr_vec2_44,
	amdgpu_vgpr_vec2_45,
	amdgpu_vgpr_vec2_46,
	amdgpu_vgpr_vec2_47,
	amdgpu_vgpr_vec2_48,
	amdgpu_vgpr_vec2_49,
	amdgpu_vgpr_vec2_50,
	amdgpu_vgpr_vec2_51,
	amdgpu_vgpr_vec2_52,
	amdgpu_vgpr_vec2_53,
	amdgpu_vgpr_vec2_54,
	amdgpu_vgpr_vec2_55,
	amdgpu_vgpr_vec2_56,
	amdgpu_vgpr_vec2_57,
	amdgpu_vgpr_vec2_58,
	amdgpu_vgpr_vec2_59,
	amdgpu_vgpr_vec2_60,
	amdgpu_vgpr_vec2_61,
	amdgpu_vgpr_vec2_62,
	amdgpu_vgpr_vec2_63,
	amdgpu_vgpr_vec2_64,
	amdgpu_vgpr_vec2_65,
	amdgpu_vgpr_vec2_66,
	amdgpu_vgpr_vec2_67,
	amdgpu_vgpr_vec2_68,
	amdgpu_vgpr_vec2_69,
	amdgpu_vgpr_vec2_70,
	amdgpu_vgpr_vec2_71,
	amdgpu_vgpr_vec2_72,
	amdgpu_vgpr_vec2_73,
	amdgpu_vgpr_vec2_74,
	amdgpu_vgpr_vec2_75,
	amdgpu_vgpr_vec2_76,
	amdgpu_vgpr_vec2_77,
	amdgpu_vgpr_vec2_78,
	amdgpu_vgpr_vec2_79,
	amdgpu_vgpr_vec2_80,
	amdgpu_vgpr_vec2_81,
	amdgpu_vgpr_vec2_82,
	amdgpu_vgpr_vec2_83,
	amdgpu_vgpr_vec2_84,
	amdgpu_vgpr_vec2_85,
	amdgpu_vgpr_vec2_86,
	amdgpu_vgpr_vec2_87,
	amdgpu_vgpr_vec2_88,
	amdgpu_vgpr_vec2_89,
	amdgpu_vgpr_vec2_90,
	amdgpu_vgpr_vec2_91,
	amdgpu_vgpr_vec2_92,
	amdgpu_vgpr_vec2_93,
	amdgpu_vgpr_vec2_94,
	amdgpu_vgpr_vec2_95,
	amdgpu_vgpr_vec2_96,
	amdgpu_vgpr_vec2_97,
	amdgpu_vgpr_vec2_98,
	amdgpu_vgpr_vec2_99,
	amdgpu_vgpr_vec2_100,
	amdgpu_vgpr_vec2_101,
	amdgpu_vgpr_vec2_102,
	amdgpu_vgpr_vec2_103,
	amdgpu_vgpr_vec2_104,
	amdgpu_vgpr_vec2_105,
	amdgpu_vgpr_vec2_106,
	amdgpu_vgpr_vec2_107,
	amdgpu_vgpr_vec2_108,
	amdgpu_vgpr_vec2_109,
	amdgpu_vgpr_vec2_110,
	amdgpu_vgpr_vec2_111,
	amdgpu_vgpr_vec2_112,
	amdgpu_vgpr_vec2_113,
	amdgpu_vgpr_vec2_114,
	amdgpu_vgpr_vec2_115,
	amdgpu_vgpr_vec2_116,
	amdgpu_vgpr_vec2_117,
	amdgpu_vgpr_vec2_118,
	amdgpu_vgpr_vec2_119,
	amdgpu_vgpr_vec2_120,
	amdgpu_vgpr_vec2_121,
	amdgpu_vgpr_vec2_122,
	amdgpu_vgpr_vec2_123,
	amdgpu_vgpr_vec2_124,
	amdgpu_vgpr_vec2_125,
	amdgpu_vgpr_vec2_126,
	amdgpu_vgpr_vec2_127,
	amdgpu_vgpr_vec2_128,
	amdgpu_vgpr_vec2_129,
	amdgpu_vgpr_vec2_130,
	amdgpu_vgpr_vec2_131,
	amdgpu_vgpr_vec2_132,
	amdgpu_vgpr_vec2_133,
	amdgpu_vgpr_vec2_134,
	amdgpu_vgpr_vec2_135,
	amdgpu_vgpr_vec2_136,
	amdgpu_vgpr_vec2_137,
	amdgpu_vgpr_vec2_138,
	amdgpu_vgpr_vec2_139,
	amdgpu_vgpr_vec2_140,
	amdgpu_vgpr_vec2_141,
	amdgpu_vgpr_vec2_142,
	amdgpu_vgpr_vec2_143,
	amdgpu_vgpr_vec2_144,
	amdgpu_vgpr_vec2_145,
	amdgpu_vgpr_vec2_146,
	amdgpu_vgpr_vec2_147,
	amdgpu_vgpr_vec2_148,
	amdgpu_vgpr_vec2_149,
	amdgpu_vgpr_vec2_150,
	amdgpu_vgpr_vec2_151,
	amdgpu_vgpr_vec2_152,
	amdgpu_vgpr_vec2_153,
	amdgpu_vgpr_vec2_154,
	amdgpu_vgpr_vec2_155,
	amdgpu_vgpr_vec2_156,
	amdgpu_vgpr_vec2_157,
	amdgpu_vgpr_vec2_158,
	amdgpu_vgpr_vec2_159,
	amdgpu_vgpr_vec2_160,
	amdgpu_vgpr_vec2_161,
	amdgpu_vgpr_vec2_162,
	amdgpu_vgpr_vec2_163,
	amdgpu_vgpr_vec2_164,
	amdgpu_vgpr_vec2_165,
	amdgpu_vgpr_vec2_166,
	amdgpu_vgpr_vec2_167,
	amdgpu_vgpr_vec2_168,
	amdgpu_vgpr_vec2_169,
	amdgpu_vgpr_vec2_170,
	amdgpu_vgpr_vec2_171,
	amdgpu_vgpr_vec2_172,
	amdgpu_vgpr_vec2_173,
	amdgpu_vgpr_vec2_174,
	amdgpu_vgpr_vec2_175,
	amdgpu_vgpr_vec2_176,
	amdgpu_vgpr_vec2_177,
	amdgpu_vgpr_vec2_178,
	amdgpu_vgpr_vec2_179,
	amdgpu_vgpr_vec2_180,
	amdgpu_vgpr_vec2_181,
	amdgpu_vgpr_vec2_182,
	amdgpu_vgpr_vec2_183,
	amdgpu_vgpr_vec2_184,
	amdgpu_vgpr_vec2_185,
	amdgpu_vgpr_vec2_186,
	amdgpu_vgpr_vec2_187,
	amdgpu_vgpr_vec2_188,
	amdgpu_vgpr_vec2_189,
	amdgpu_vgpr_vec2_190,
	amdgpu_vgpr_vec2_191,
	amdgpu_vgpr_vec2_192,
	amdgpu_vgpr_vec2_193,
	amdgpu_vgpr_vec2_194,
	amdgpu_vgpr_vec2_195,
	amdgpu_vgpr_vec2_196,
	amdgpu_vgpr_vec2_197,
	amdgpu_vgpr_vec2_198,
	amdgpu_vgpr_vec2_199,
	amdgpu_vgpr_vec2_200,
	amdgpu_vgpr_vec2_201,
	amdgpu_vgpr_vec2_202,
	amdgpu_vgpr_vec2_203,
	amdgpu_vgpr_vec2_204,
	amdgpu_vgpr_vec2_205,
	amdgpu_vgpr_vec2_206,
	amdgpu_vgpr_vec2_207,
	amdgpu_vgpr_vec2_208,
	amdgpu_vgpr_vec2_209,
	amdgpu_vgpr_vec2_210,
	amdgpu_vgpr_vec2_211,
	amdgpu_vgpr_vec2_212,
	amdgpu_vgpr_vec2_213,
	amdgpu_vgpr_vec2_214,
	amdgpu_vgpr_vec2_215,
	amdgpu_vgpr_vec2_216,
	amdgpu_vgpr_vec2_217,
	amdgpu_vgpr_vec2_218,
	amdgpu_vgpr_vec2_219,
	amdgpu_vgpr_vec2_220,
	amdgpu_vgpr_vec2_221,
	amdgpu_vgpr_vec2_222,
	amdgpu_vgpr_vec2_223,
	amdgpu_vgpr_vec2_224,
	amdgpu_vgpr_vec2_225,
	amdgpu_vgpr_vec2_226,
	amdgpu_vgpr_vec2_227,
	amdgpu_vgpr_vec2_228,
	amdgpu_vgpr_vec2_229,
	amdgpu_vgpr_vec2_230,
	amdgpu_vgpr_vec2_231,
	amdgpu_vgpr_vec2_232,
	amdgpu_vgpr_vec2_233,
	amdgpu_vgpr_vec2_234,
	amdgpu_vgpr_vec2_235,
	amdgpu_vgpr_vec2_236,
	amdgpu_vgpr_vec2_237,
	amdgpu_vgpr_vec2_238,
	amdgpu_vgpr_vec2_239,
	amdgpu_vgpr_vec2_240,
	amdgpu_vgpr_vec2_241,
	amdgpu_vgpr_vec2_242,
	amdgpu_vgpr_vec2_243,
	amdgpu_vgpr_vec2_244,
	amdgpu_vgpr_vec2_245,
	amdgpu_vgpr_vec2_246,
	amdgpu_vgpr_vec2_247,
	amdgpu_vgpr_vec2_248,
	amdgpu_vgpr_vec2_249,
	amdgpu_vgpr_vec2_250,
	amdgpu_vgpr_vec2_251,
	amdgpu_vgpr_vec2_252,
	amdgpu_vgpr_vec2_253,
	amdgpu_vgpr_vec2_254
};
enum AMDGPUVectorGeneralPurposeRegisterVector4{
	amdgpu_vgpr_vec4_0,
	amdgpu_vgpr_vec4_1,
	amdgpu_vgpr_vec4_2,
	amdgpu_vgpr_vec4_3,
	amdgpu_vgpr_vec4_4,
	amdgpu_vgpr_vec4_5,
	amdgpu_vgpr_vec4_6,
	amdgpu_vgpr_vec4_7,
	amdgpu_vgpr_vec4_8,
	amdgpu_vgpr_vec4_9,
	amdgpu_vgpr_vec4_10,
	amdgpu_vgpr_vec4_11,
	amdgpu_vgpr_vec4_12,
	amdgpu_vgpr_vec4_13,
	amdgpu_vgpr_vec4_14,
	amdgpu_vgpr_vec4_15,
	amdgpu_vgpr_vec4_16,
	amdgpu_vgpr_vec4_17,
	amdgpu_vgpr_vec4_18,
	amdgpu_vgpr_vec4_19,
	amdgpu_vgpr_vec4_20,
	amdgpu_vgpr_vec4_21,
	amdgpu_vgpr_vec4_22,
	amdgpu_vgpr_vec4_23,
	amdgpu_vgpr_vec4_24,
	amdgpu_vgpr_vec4_25,
	amdgpu_vgpr_vec4_26,
	amdgpu_vgpr_vec4_27,
	amdgpu_vgpr_vec4_28,
	amdgpu_vgpr_vec4_29,
	amdgpu_vgpr_vec4_30,
	amdgpu_vgpr_vec4_31,
	amdgpu_vgpr_vec4_32,
	amdgpu_vgpr_vec4_33,
	amdgpu_vgpr_vec4_34,
	amdgpu_vgpr_vec4_35,
	amdgpu_vgpr_vec4_36,
	amdgpu_vgpr_vec4_37,
	amdgpu_vgpr_vec4_38,
	amdgpu_vgpr_vec4_39,
	amdgpu_vgpr_vec4_40,
	amdgpu_vgpr_vec4_41,
	amdgpu_vgpr_vec4_42,
	amdgpu_vgpr_vec4_43,
	amdgpu_vgpr_vec4_44,
	amdgpu_vgpr_vec4_45,
	amdgpu_vgpr_vec4_46,
	amdgpu_vgpr_vec4_47,
	amdgpu_vgpr_vec4_48,
	amdgpu_vgpr_vec4_49,
	amdgpu_vgpr_vec4_50,
	amdgpu_vgpr_vec4_51,
	amdgpu_vgpr_vec4_52,
	amdgpu_vgpr_vec4_53,
	amdgpu_vgpr_vec4_54,
	amdgpu_vgpr_vec4_55,
	amdgpu_vgpr_vec4_56,
	amdgpu_vgpr_vec4_57,
	amdgpu_vgpr_vec4_58,
	amdgpu_vgpr_vec4_59,
	amdgpu_vgpr_vec4_60,
	amdgpu_vgpr_vec4_61,
	amdgpu_vgpr_vec4_62,
	amdgpu_vgpr_vec4_63,
	amdgpu_vgpr_vec4_64,
	amdgpu_vgpr_vec4_65,
	amdgpu_vgpr_vec4_66,
	amdgpu_vgpr_vec4_67,
	amdgpu_vgpr_vec4_68,
	amdgpu_vgpr_vec4_69,
	amdgpu_vgpr_vec4_70,
	amdgpu_vgpr_vec4_71,
	amdgpu_vgpr_vec4_72,
	amdgpu_vgpr_vec4_73,
	amdgpu_vgpr_vec4_74,
	amdgpu_vgpr_vec4_75,
	amdgpu_vgpr_vec4_76,
	amdgpu_vgpr_vec4_77,
	amdgpu_vgpr_vec4_78,
	amdgpu_vgpr_vec4_79,
	amdgpu_vgpr_vec4_80,
	amdgpu_vgpr_vec4_81,
	amdgpu_vgpr_vec4_82,
	amdgpu_vgpr_vec4_83,
	amdgpu_vgpr_vec4_84,
	amdgpu_vgpr_vec4_85,
	amdgpu_vgpr_vec4_86,
	amdgpu_vgpr_vec4_87,
	amdgpu_vgpr_vec4_88,
	amdgpu_vgpr_vec4_89,
	amdgpu_vgpr_vec4_90,
	amdgpu_vgpr_vec4_91,
	amdgpu_vgpr_vec4_92,
	amdgpu_vgpr_vec4_93,
	amdgpu_vgpr_vec4_94,
	amdgpu_vgpr_vec4_95,
	amdgpu_vgpr_vec4_96,
	amdgpu_vgpr_vec4_97,
	amdgpu_vgpr_vec4_98,
	amdgpu_vgpr_vec4_99,
	amdgpu_vgpr_vec4_100,
	amdgpu_vgpr_vec4_101,
	amdgpu_vgpr_vec4_102,
	amdgpu_vgpr_vec4_103,
	amdgpu_vgpr_vec4_104,
	amdgpu_vgpr_vec4_105,
	amdgpu_vgpr_vec4_106,
	amdgpu_vgpr_vec4_107,
	amdgpu_vgpr_vec4_108,
	amdgpu_vgpr_vec4_109,
	amdgpu_vgpr_vec4_110,
	amdgpu_vgpr_vec4_111,
	amdgpu_vgpr_vec4_112,
	amdgpu_vgpr_vec4_113,
	amdgpu_vgpr_vec4_114,
	amdgpu_vgpr_vec4_115,
	amdgpu_vgpr_vec4_116,
	amdgpu_vgpr_vec4_117,
	amdgpu_vgpr_vec4_118,
	amdgpu_vgpr_vec4_119,
	amdgpu_vgpr_vec4_120,
	amdgpu_vgpr_vec4_121,
	amdgpu_vgpr_vec4_122,
	amdgpu_vgpr_vec4_123,
	amdgpu_vgpr_vec4_124,
	amdgpu_vgpr_vec4_125,
	amdgpu_vgpr_vec4_126,
	amdgpu_vgpr_vec4_127,
	amdgpu_vgpr_vec4_128,
	amdgpu_vgpr_vec4_129,
	amdgpu_vgpr_vec4_130,
	amdgpu_vgpr_vec4_131,
	amdgpu_vgpr_vec4_132,
	amdgpu_vgpr_vec4_133,
	amdgpu_vgpr_vec4_134,
	amdgpu_vgpr_vec4_135,
	amdgpu_vgpr_vec4_136,
	amdgpu_vgpr_vec4_137,
	amdgpu_vgpr_vec4_138,
	amdgpu_vgpr_vec4_139,
	amdgpu_vgpr_vec4_140,
	amdgpu_vgpr_vec4_141,
	amdgpu_vgpr_vec4_142,
	amdgpu_vgpr_vec4_143,
	amdgpu_vgpr_vec4_144,
	amdgpu_vgpr_vec4_145,
	amdgpu_vgpr_vec4_146,
	amdgpu_vgpr_vec4_147,
	amdgpu_vgpr_vec4_148,
	amdgpu_vgpr_vec4_149,
	amdgpu_vgpr_vec4_150,
	amdgpu_vgpr_vec4_151,
	amdgpu_vgpr_vec4_152,
	amdgpu_vgpr_vec4_153,
	amdgpu_vgpr_vec4_154,
	amdgpu_vgpr_vec4_155,
	amdgpu_vgpr_vec4_156,
	amdgpu_vgpr_vec4_157,
	amdgpu_vgpr_vec4_158,
	amdgpu_vgpr_vec4_159,
	amdgpu_vgpr_vec4_160,
	amdgpu_vgpr_vec4_161,
	amdgpu_vgpr_vec4_162,
	amdgpu_vgpr_vec4_163,
	amdgpu_vgpr_vec4_164,
	amdgpu_vgpr_vec4_165,
	amdgpu_vgpr_vec4_166,
	amdgpu_vgpr_vec4_167,
	amdgpu_vgpr_vec4_168,
	amdgpu_vgpr_vec4_169,
	amdgpu_vgpr_vec4_170,
	amdgpu_vgpr_vec4_171,
	amdgpu_vgpr_vec4_172,
	amdgpu_vgpr_vec4_173,
	amdgpu_vgpr_vec4_174,
	amdgpu_vgpr_vec4_175,
	amdgpu_vgpr_vec4_176,
	amdgpu_vgpr_vec4_177,
	amdgpu_vgpr_vec4_178,
	amdgpu_vgpr_vec4_179,
	amdgpu_vgpr_vec4_180,
	amdgpu_vgpr_vec4_181,
	amdgpu_vgpr_vec4_182,
	amdgpu_vgpr_vec4_183,
	amdgpu_vgpr_vec4_184,
	amdgpu_vgpr_vec4_185,
	amdgpu_vgpr_vec4_186,
	amdgpu_vgpr_vec4_187,
	amdgpu_vgpr_vec4_188,
	amdgpu_vgpr_vec4_189,
	amdgpu_vgpr_vec4_190,
	amdgpu_vgpr_vec4_191,
	amdgpu_vgpr_vec4_192,
	amdgpu_vgpr_vec4_193,
	amdgpu_vgpr_vec4_194,
	amdgpu_vgpr_vec4_195,
	amdgpu_vgpr_vec4_196,
	amdgpu_vgpr_vec4_197,
	amdgpu_vgpr_vec4_198,
	amdgpu_vgpr_vec4_199,
	amdgpu_vgpr_vec4_200,
	amdgpu_vgpr_vec4_201,
	amdgpu_vgpr_vec4_202,
	amdgpu_vgpr_vec4_203,
	amdgpu_vgpr_vec4_204,
	amdgpu_vgpr_vec4_205,
	amdgpu_vgpr_vec4_206,
	amdgpu_vgpr_vec4_207,
	amdgpu_vgpr_vec4_208,
	amdgpu_vgpr_vec4_209,
	amdgpu_vgpr_vec4_210,
	amdgpu_vgpr_vec4_211,
	amdgpu_vgpr_vec4_212,
	amdgpu_vgpr_vec4_213,
	amdgpu_vgpr_vec4_214,
	amdgpu_vgpr_vec4_215,
	amdgpu_vgpr_vec4_216,
	amdgpu_vgpr_vec4_217,
	amdgpu_vgpr_vec4_218,
	amdgpu_vgpr_vec4_219,
	amdgpu_vgpr_vec4_220,
	amdgpu_vgpr_vec4_221,
	amdgpu_vgpr_vec4_222,
	amdgpu_vgpr_vec4_223,
	amdgpu_vgpr_vec4_224,
	amdgpu_vgpr_vec4_225,
	amdgpu_vgpr_vec4_226,
	amdgpu_vgpr_vec4_227,
	amdgpu_vgpr_vec4_228,
	amdgpu_vgpr_vec4_229,
	amdgpu_vgpr_vec4_230,
	amdgpu_vgpr_vec4_231,
	amdgpu_vgpr_vec4_232,
	amdgpu_vgpr_vec4_233,
	amdgpu_vgpr_vec4_234,
	amdgpu_vgpr_vec4_235,
	amdgpu_vgpr_vec4_236,
	amdgpu_vgpr_vec4_237,
	amdgpu_vgpr_vec4_238,
	amdgpu_vgpr_vec4_239,
	amdgpu_vgpr_vec4_240,
	amdgpu_vgpr_vec4_241,
	amdgpu_vgpr_vec4_242,
	amdgpu_vgpr_vec4_243,
	amdgpu_vgpr_vec4_244,
	amdgpu_vgpr_vec4_245,
	amdgpu_vgpr_vec4_246,
	amdgpu_vgpr_vec4_247,
	amdgpu_vgpr_vec4_248,
	amdgpu_vgpr_vec4_249,
	amdgpu_vgpr_vec4_250,
	amdgpu_vgpr_vec4_251,
	amdgpu_vgpr_vec4_252
};
enum AMDGPUVectorGeneralPurposeRegisterVector8{
	amdgpu_vgpr_vec8_0,
	amdgpu_vgpr_vec8_1,
	amdgpu_vgpr_vec8_2,
	amdgpu_vgpr_vec8_3,
	amdgpu_vgpr_vec8_4,
	amdgpu_vgpr_vec8_5,
	amdgpu_vgpr_vec8_6,
	amdgpu_vgpr_vec8_7,
	amdgpu_vgpr_vec8_8,
	amdgpu_vgpr_vec8_9,
	amdgpu_vgpr_vec8_10,
	amdgpu_vgpr_vec8_11,
	amdgpu_vgpr_vec8_12,
	amdgpu_vgpr_vec8_13,
	amdgpu_vgpr_vec8_14,
	amdgpu_vgpr_vec8_15,
	amdgpu_vgpr_vec8_16,
	amdgpu_vgpr_vec8_17,
	amdgpu_vgpr_vec8_18,
	amdgpu_vgpr_vec8_19,
	amdgpu_vgpr_vec8_20,
	amdgpu_vgpr_vec8_21,
	amdgpu_vgpr_vec8_22,
	amdgpu_vgpr_vec8_23,
	amdgpu_vgpr_vec8_24,
	amdgpu_vgpr_vec8_25,
	amdgpu_vgpr_vec8_26,
	amdgpu_vgpr_vec8_27,
	amdgpu_vgpr_vec8_28,
	amdgpu_vgpr_vec8_29,
	amdgpu_vgpr_vec8_30,
	amdgpu_vgpr_vec8_31,
	amdgpu_vgpr_vec8_32,
	amdgpu_vgpr_vec8_33,
	amdgpu_vgpr_vec8_34,
	amdgpu_vgpr_vec8_35,
	amdgpu_vgpr_vec8_36,
	amdgpu_vgpr_vec8_37,
	amdgpu_vgpr_vec8_38,
	amdgpu_vgpr_vec8_39,
	amdgpu_vgpr_vec8_40,
	amdgpu_vgpr_vec8_41,
	amdgpu_vgpr_vec8_42,
	amdgpu_vgpr_vec8_43,
	amdgpu_vgpr_vec8_44,
	amdgpu_vgpr_vec8_45,
	amdgpu_vgpr_vec8_46,
	amdgpu_vgpr_vec8_47,
	amdgpu_vgpr_vec8_48,
	amdgpu_vgpr_vec8_49,
	amdgpu_vgpr_vec8_50,
	amdgpu_vgpr_vec8_51,
	amdgpu_vgpr_vec8_52,
	amdgpu_vgpr_vec8_53,
	amdgpu_vgpr_vec8_54,
	amdgpu_vgpr_vec8_55,
	amdgpu_vgpr_vec8_56,
	amdgpu_vgpr_vec8_57,
	amdgpu_vgpr_vec8_58,
	amdgpu_vgpr_vec8_59,
	amdgpu_vgpr_vec8_60,
	amdgpu_vgpr_vec8_61,
	amdgpu_vgpr_vec8_62,
	amdgpu_vgpr_vec8_63,
	amdgpu_vgpr_vec8_64,
	amdgpu_vgpr_vec8_65,
	amdgpu_vgpr_vec8_66,
	amdgpu_vgpr_vec8_67,
	amdgpu_vgpr_vec8_68,
	amdgpu_vgpr_vec8_69,
	amdgpu_vgpr_vec8_70,
	amdgpu_vgpr_vec8_71,
	amdgpu_vgpr_vec8_72,
	amdgpu_vgpr_vec8_73,
	amdgpu_vgpr_vec8_74,
	amdgpu_vgpr_vec8_75,
	amdgpu_vgpr_vec8_76,
	amdgpu_vgpr_vec8_77,
	amdgpu_vgpr_vec8_78,
	amdgpu_vgpr_vec8_79,
	amdgpu_vgpr_vec8_80,
	amdgpu_vgpr_vec8_81,
	amdgpu_vgpr_vec8_82,
	amdgpu_vgpr_vec8_83,
	amdgpu_vgpr_vec8_84,
	amdgpu_vgpr_vec8_85,
	amdgpu_vgpr_vec8_86,
	amdgpu_vgpr_vec8_87,
	amdgpu_vgpr_vec8_88,
	amdgpu_vgpr_vec8_89,
	amdgpu_vgpr_vec8_90,
	amdgpu_vgpr_vec8_91,
	amdgpu_vgpr_vec8_92,
	amdgpu_vgpr_vec8_93,
	amdgpu_vgpr_vec8_94,
	amdgpu_vgpr_vec8_95,
	amdgpu_vgpr_vec8_96,
	amdgpu_vgpr_vec8_97,
	amdgpu_vgpr_vec8_98,
	amdgpu_vgpr_vec8_99,
	amdgpu_vgpr_vec8_100,
	amdgpu_vgpr_vec8_101,
	amdgpu_vgpr_vec8_102,
	amdgpu_vgpr_vec8_103,
	amdgpu_vgpr_vec8_104,
	amdgpu_vgpr_vec8_105,
	amdgpu_vgpr_vec8_106,
	amdgpu_vgpr_vec8_107,
	amdgpu_vgpr_vec8_108,
	amdgpu_vgpr_vec8_109,
	amdgpu_vgpr_vec8_110,
	amdgpu_vgpr_vec8_111,
	amdgpu_vgpr_vec8_112,
	amdgpu_vgpr_vec8_113,
	amdgpu_vgpr_vec8_114,
	amdgpu_vgpr_vec8_115,
	amdgpu_vgpr_vec8_116,
	amdgpu_vgpr_vec8_117,
	amdgpu_vgpr_vec8_118,
	amdgpu_vgpr_vec8_119,
	amdgpu_vgpr_vec8_120,
	amdgpu_vgpr_vec8_121,
	amdgpu_vgpr_vec8_122,
	amdgpu_vgpr_vec8_123,
	amdgpu_vgpr_vec8_124,
	amdgpu_vgpr_vec8_125,
	amdgpu_vgpr_vec8_126,
	amdgpu_vgpr_vec8_127,
	amdgpu_vgpr_vec8_128,
	amdgpu_vgpr_vec8_129,
	amdgpu_vgpr_vec8_130,
	amdgpu_vgpr_vec8_131,
	amdgpu_vgpr_vec8_132,
	amdgpu_vgpr_vec8_133,
	amdgpu_vgpr_vec8_134,
	amdgpu_vgpr_vec8_135,
	amdgpu_vgpr_vec8_136,
	amdgpu_vgpr_vec8_137,
	amdgpu_vgpr_vec8_138,
	amdgpu_vgpr_vec8_139,
	amdgpu_vgpr_vec8_140,
	amdgpu_vgpr_vec8_141,
	amdgpu_vgpr_vec8_142,
	amdgpu_vgpr_vec8_143,
	amdgpu_vgpr_vec8_144,
	amdgpu_vgpr_vec8_145,
	amdgpu_vgpr_vec8_146,
	amdgpu_vgpr_vec8_147,
	amdgpu_vgpr_vec8_148,
	amdgpu_vgpr_vec8_149,
	amdgpu_vgpr_vec8_150,
	amdgpu_vgpr_vec8_151,
	amdgpu_vgpr_vec8_152,
	amdgpu_vgpr_vec8_153,
	amdgpu_vgpr_vec8_154,
	amdgpu_vgpr_vec8_155,
	amdgpu_vgpr_vec8_156,
	amdgpu_vgpr_vec8_157,
	amdgpu_vgpr_vec8_158,
	amdgpu_vgpr_vec8_159,
	amdgpu_vgpr_vec8_160,
	amdgpu_vgpr_vec8_161,
	amdgpu_vgpr_vec8_162,
	amdgpu_vgpr_vec8_163,
	amdgpu_vgpr_vec8_164,
	amdgpu_vgpr_vec8_165,
	amdgpu_vgpr_vec8_166,
	amdgpu_vgpr_vec8_167,
	amdgpu_vgpr_vec8_168,
	amdgpu_vgpr_vec8_169,
	amdgpu_vgpr_vec8_170,
	amdgpu_vgpr_vec8_171,
	amdgpu_vgpr_vec8_172,
	amdgpu_vgpr_vec8_173,
	amdgpu_vgpr_vec8_174,
	amdgpu_vgpr_vec8_175,
	amdgpu_vgpr_vec8_176,
	amdgpu_vgpr_vec8_177,
	amdgpu_vgpr_vec8_178,
	amdgpu_vgpr_vec8_179,
	amdgpu_vgpr_vec8_180,
	amdgpu_vgpr_vec8_181,
	amdgpu_vgpr_vec8_182,
	amdgpu_vgpr_vec8_183,
	amdgpu_vgpr_vec8_184,
	amdgpu_vgpr_vec8_185,
	amdgpu_vgpr_vec8_186,
	amdgpu_vgpr_vec8_187,
	amdgpu_vgpr_vec8_188,
	amdgpu_vgpr_vec8_189,
	amdgpu_vgpr_vec8_190,
	amdgpu_vgpr_vec8_191,
	amdgpu_vgpr_vec8_192,
	amdgpu_vgpr_vec8_193,
	amdgpu_vgpr_vec8_194,
	amdgpu_vgpr_vec8_195,
	amdgpu_vgpr_vec8_196,
	amdgpu_vgpr_vec8_197,
	amdgpu_vgpr_vec8_198,
	amdgpu_vgpr_vec8_199,
	amdgpu_vgpr_vec8_200,
	amdgpu_vgpr_vec8_201,
	amdgpu_vgpr_vec8_202,
	amdgpu_vgpr_vec8_203,
	amdgpu_vgpr_vec8_204,
	amdgpu_vgpr_vec8_205,
	amdgpu_vgpr_vec8_206,
	amdgpu_vgpr_vec8_207,
	amdgpu_vgpr_vec8_208,
	amdgpu_vgpr_vec8_209,
	amdgpu_vgpr_vec8_210,
	amdgpu_vgpr_vec8_211,
	amdgpu_vgpr_vec8_212,
	amdgpu_vgpr_vec8_213,
	amdgpu_vgpr_vec8_214,
	amdgpu_vgpr_vec8_215,
	amdgpu_vgpr_vec8_216,
	amdgpu_vgpr_vec8_217,
	amdgpu_vgpr_vec8_218,
	amdgpu_vgpr_vec8_219,
	amdgpu_vgpr_vec8_220,
	amdgpu_vgpr_vec8_221,
	amdgpu_vgpr_vec8_222,
	amdgpu_vgpr_vec8_223,
	amdgpu_vgpr_vec8_224,
	amdgpu_vgpr_vec8_225,
	amdgpu_vgpr_vec8_226,
	amdgpu_vgpr_vec8_227,
	amdgpu_vgpr_vec8_228,
	amdgpu_vgpr_vec8_229,
	amdgpu_vgpr_vec8_230,
	amdgpu_vgpr_vec8_231,
	amdgpu_vgpr_vec8_232,
	amdgpu_vgpr_vec8_233,
	amdgpu_vgpr_vec8_234,
	amdgpu_vgpr_vec8_235,
	amdgpu_vgpr_vec8_236,
	amdgpu_vgpr_vec8_237,
	amdgpu_vgpr_vec8_238,
	amdgpu_vgpr_vec8_239,
	amdgpu_vgpr_vec8_240,
	amdgpu_vgpr_vec8_241,
	amdgpu_vgpr_vec8_242,
	amdgpu_vgpr_vec8_243,
	amdgpu_vgpr_vec8_244,
	amdgpu_vgpr_vec8_245,
	amdgpu_vgpr_vec8_246,
	amdgpu_vgpr_vec8_247,
	amdgpu_vgpr_vec8_248
};
enum AmdgpuVegaInstructionKind{
	rose_amdgpu_op_INVALID		=0,
	rose_amdgpu_op_s_cmp_ge_eq_i32,
	rose_amdgpu_op_s_cmp_ge_eq_u32,
	rose_amdgpu_op_s_cmp_lg_i32,
	rose_amdgpu_op_s_cmp_lg_u32,
	rose_amdgpu_op_s_cmp_gt_i32,
	rose_amdgpu_op_s_cmp_gt_u32,
	rose_amdgpu_op_s_cmp_ge_i32,
	rose_amdgpu_op_s_cmp_ge_u32,
	rose_amdgpu_op_s_cmp_lt_i32,
	rose_amdgpu_op_s_cmp_lt_u32,
	rose_amdgpu_op_s_cmp_le_i32,
	rose_amdgpu_op_s_cmp_le_u32,
	rose_amdgpu_op_s_bitcmp0_b32,
	rose_amdgpu_op_s_bitcmp1_b32,
	rose_amdgpu_op_s_bitcmp0_b64,
	rose_amdgpu_op_s_bitcmp1_b64,
	rose_amdgpu_op_s_setvkip,
	rose_amdgpu_op_s_set_gpr_idx_on,
	rose_amdgpu_op_s_cmp_eq_u64,
	rose_amdgpu_op_s_cmp_lg_u64,
	rose_amdgpu_op_s_nop,
	rose_amdgpu_op_s_endpgm,
	rose_amdgpu_op_s_branch,
	rose_amdgpu_op_s_wakeup,
	rose_amdgpu_op_s_cbranch_scc0,
	rose_amdgpu_op_s_cbranch_scc1,
	rose_amdgpu_op_s_cbranch_vccz,
	rose_amdgpu_op_s_cbranch_vccnz,
	rose_amdgpu_op_s_cbranch_execz,
	rose_amdgpu_op_s_cbranch_execnz,
	rose_amdgpu_op_s_barrier,
	rose_amdgpu_op_s_setkill,
	rose_amdgpu_op_s_waitcnt,
	rose_amdgpu_op_s_sethalt,
	rose_amdgpu_op_s_sleep,
	rose_amdgpu_op_s_setprio,
	rose_amdgpu_op_s_sendmsg,
	rose_amdgpu_op_s_sendmsghalt,
	rose_amdgpu_op_s_trap,
	rose_amdgpu_op_s_icache_inv,
	rose_amdgpu_op_s_incperflevel,
	rose_amdgpu_op_s_decperflevel,
	rose_amdgpu_op_s_ttracedata,
	rose_amdgpu_op_s_cbranch_cdbgsys,
	rose_amdgpu_op_s_cbranch_cdbguser,
	rose_amdgpu_op_s_cbranch_cdbgsys_and_user,
	rose_amdgpu_op_s_endpgm_saved,
	rose_amdgpu_op_s_set_gpr_idx_off,
	rose_amdgpu_op_s_set_gpr_idx_mode,
	rose_amdgpu_op_s_endpgm_ordered_ps_done,
	rose_amdgpu_op_buffer_load_format_x,
	rose_amdgpu_op_buffer_load_format_xy,
	rose_amdgpu_op_buffer_load_format_xyz,
	rose_amdgpu_op_buffer_load_format_xyzw,
	rose_amdgpu_op_buffer_store_format_x,
	rose_amdgpu_op_buffer_store_format_xy,
	rose_amdgpu_op_buffer_store_format_xyz,
	rose_amdgpu_op_buffer_store_format_xyzw,
	rose_amdgpu_op_buffer_load_dword,
	rose_amdgpu_op_buffer_load_dwordx2,
	rose_amdgpu_op_buffer_load_dwordx3,
	rose_amdgpu_op_buffer_load_dwordx4,
	rose_amdgpu_op_tbuffer_load_format_x,
	rose_amdgpu_op_tbuffer_load_format_xy,
	rose_amdgpu_op_tbuffer_load_format_xyz,
	rose_amdgpu_op_tbuffer_load_format_xyzw,
	rose_amdgpu_op_tbuffer_store_format_x,
	rose_amdgpu_op_tbuffer_store_format_xy,
	rose_amdgpu_op_tbuffer_store_format_xyz,
	rose_amdgpu_op_tbuffer_store_format_xyzw,
	rose_amdgpu_op_v_cndmask_b32,
	rose_amdgpu_op_v_add_f32,
	rose_amdgpu_op_v_sub_f32,
	rose_amdgpu_op_v_subrev_f32,
	rose_amdgpu_op_v_mul_legacy_f32,
	rose_amdgpu_op_v_mul_f32,
	rose_amdgpu_op_v_mul_i32_i24,
	rose_amdgpu_op_v_mul_hi_i32_i24,
	rose_amdgpu_op_v_mul_u32_u24,
	rose_amdgpu_op_v_mul_hi_u32_u24,
	rose_amdgpu_op_v_min_f32,
	rose_amdgpu_op_v_max_f32,
	rose_amdgpu_op_v_min_i32,
	rose_amdgpu_op_v_max_i32,
	rose_amdgpu_op_v_min_u32,
	rose_amdgpu_op_v_max_u32,
	rose_amdgpu_op_v_lshrrev_b32,
	rose_amdgpu_op_v_ashrrev_i32,
	rose_amdgpu_op_v_lshlrev_b32,
	rose_amdgpu_op_v_add_b32,
	rose_amdgpu_op_v_or_b32,
	rose_amdgpu_op_v_xor_b32,
	rose_amdgpu_op_v_mac_b32,
	rose_amdgpu_op_v_madmk_f32,
	rose_amdgpu_op_v_madak_f32,
	rose_amdgpu_op_v_add_co_u32,
	rose_amdgpu_op_v_sub_co_u32,
	rose_amdgpu_op_v_subrev_co_u32,
	rose_amdgpu_op_v_addc_co_u32,
	rose_amdgpu_op_v_subb_co_u32,
	rose_amdgpu_op_v_subbrev_co_u32,
	rose_amdgpu_op_v_add_f16,
	rose_amdgpu_op_v_sub_f16,
	rose_amdgpu_op_v_subrev_f16,
	rose_amdgpu_op_v_mul_f16,
	rose_amdgpu_op_v_mac_f16,
	rose_amdgpu_op_v_madmk_f16,
	rose_amdgpu_op_v_madak_f16,
	rose_amdgpu_op_v_add_u16,
	rose_amdgpu_op_v_sub_u16,
	rose_amdgpu_op_v_subrev_u16,
	rose_amdgpu_op_v_mul_lo_u16,
	rose_amdgpu_op_v_lshlrev_b16,
	rose_amdgpu_op_v_lshrrev_b16,
	rose_amdgpu_op_v_ashrrev_i16,
	rose_amdgpu_op_v_max_f16,
	rose_amdgpu_op_v_min_f16,
	rose_amdgpu_op_v_max_u16,
	rose_amdgpu_op_v_max_i16,
	rose_amdgpu_op_v_min_u16,
	rose_amdgpu_op_v_min_i16,
	rose_amdgpu_op_v_ldexp_f16,
	rose_amdgpu_op_v_add_u32,
	rose_amdgpu_op_v_sub_u32,
	rose_amdgpu_op_v_subrev_u32,
	rose_amdgpu_op_ds_add_u32,
	rose_amdgpu_op_v_mad_legacy_f32,
	rose_amdgpu_op_v_mad_f32,
	rose_amdgpu_op_v_lshlrev_b64,
	rose_amdgpu_op_v_pack_b32_f16,
	rose_amdgpu_op_s_add_u32,
	rose_amdgpu_op_s_sub_u32,
	rose_amdgpu_op_s_add_i32,
	rose_amdgpu_op_s_sub_i32,
	rose_amdgpu_op_s_addc_u32,
	rose_amdgpu_op_s_subb_u32,
	rose_amdgpu_op_s_min_i32,
	rose_amdgpu_op_s_min_u32,
	rose_amdgpu_op_s_max_i32,
	rose_amdgpu_op_s_max_u32,
	rose_amdgpu_op_s_cslect_b32,
	rose_amdgpu_op_s_cslect_b64,
	rose_amdgpu_op_s_and_b32,
	rose_amdgpu_op_s_and_b64,
	rose_amdgpu_op_s_or_b32,
	rose_amdgpu_op_s_or_b64,
	rose_amdgpu_op_s_xor_b32,
	rose_amdgpu_op_s_xor_b64,
	rose_amdgpu_op_s_andn2_b32,
	rose_amdgpu_op_s_andn2_b64,
	rose_amdgpu_op_s_orn2_b32,
	rose_amdgpu_op_s_orn2_b64,
	rose_amdgpu_op_s_nand_b32,
	rose_amdgpu_op_s_nand_b64,
	rose_amdgpu_op_s_nor_b32,
	rose_amdgpu_op_s_nor_b64,
	rose_amdgpu_op_s_xnor_b32,
	rose_amdgpu_op_s_xnor_b64,
	rose_amdgpu_op_s_lshl_b32,
	rose_amdgpu_op_s_lshl_b64,
	rose_amdgpu_op_s_lshr_b32,
	rose_amdgpu_op_s_lshr_b64,
	rose_amdgpu_op_s_ashr_i32,
	rose_amdgpu_op_s_ashr_i64,
	rose_amdgpu_op_s_bfm_b32,
	rose_amdgpu_op_s_bfm_b64,
	rose_amdgpu_op_s_mul_i32,
	rose_amdgpu_op_s_bfe_u32,
	rose_amdgpu_op_s_bfe_i32,
	rose_amdgpu_op_s_bfe_u64,
	rose_amdgpu_op_s_bfe_i64,
	rose_amdgpu_op_s_cbranch_g_fork,
	rose_amdgpu_op_s_absdiff_i32,
	rose_amdgpu_op_s_rfe_restore_b64,
	rose_amdgpu_op_s_mul_hi_u32,
	rose_amdgpu_op_s_mul_hi_i32,
	rose_amdgpu_op_s_lshl1_add_u32,
	rose_amdgpu_op_s_lshsl2_add_u32,
	rose_amdgpu_op_s_lshl3_add_u32,
	rose_amdgpu_op_s_lshl4_add_u32,
	rose_amdgpu_op_s_pack_ll_b32_b16,
	rose_amdgpu_op_s_pack_lh_b32_b16,
	rose_amdgpu_op_s_pack_hh_b32_B16,
	rose_amdgpu_op_v_cmp_class_f32,
	rose_amdgpu_op_v_cmp_neq_f16,
	rose_amdgpu_op_v_cmp_lt_u32,
	rose_amdgpu_op_v_cmp_eq_u32,
	rose_amdgpu_op_v_cmp_le_u32,
	rose_amdgpu_op_v_cmp_gt_u32,
	rose_amdgpu_op_v_cmp_ne_u32,
	rose_amdgpu_op_v_cmp_ge_u32,
	rose_amdgpu_op_v_cmp_lt_u64,
	rose_amdgpu_op_v_cmp_eq_u64,
	rose_amdgpu_op_v_cmp_le_u64,
	rose_amdgpu_op_v_cmp_gt_u64,
	rose_amdgpu_op_v_cmp_ne_u64,
	rose_amdgpu_op_v_cmp_ge_u64,
	rose_amdgpu_op_v_interp_p1_f32,
	rose_amdgpu_op_v_interp_p2_f32,
	rose_amdgpu_op_v_interp_mov_f32,
	rose_amdgpu_op_s_load_dword,
	rose_amdgpu_op_s_load_dwordx2,
	rose_amdgpu_op_s_load_dwordx4,
	rose_amdgpu_op_s_load_dwordx8,
	rose_amdgpu_op_s_load_dwordx16,
	rose_amdgpu_op_s_scratch_load_dword,
	rose_amdgpu_op_s_scratch_load_dwordx2,
	rose_amdgpu_op_s_scratch_load_dwordx4,
	rose_amdgpu_op_s_buffer_load_dword,
	rose_amdgpu_op_s_buffer_load_dwordx2,
	rose_amdgpu_op_s_buffer_load_dwordx4,
	rose_amdgpu_op_s_buffer_load_dwordx8,
	rose_amdgpu_op_s_buffer_load_dwordx16,
	rose_amdgpu_op_s_store_dword,
	rose_amdgpu_op_s_store_dwordx2,
	rose_amdgpu_op_s_store_dwordx4,
	rose_amdgpu_op_s_scratch_store_dword,
	rose_amdgpu_op_s_scratch_store_dwordx2,
	rose_amdgpu_op_s_scratch_store_dwordx4,
	rose_amdgpu_op_s_buffer_store_dword,
	rose_amdgpu_op_s_buffer_store_dwordx2,
	rose_amdgpu_op_s_buffer_store_dwordx4,
	rose_amdgpu_op_s_dcache_inv,
	rose_amdgpu_op_s_dcache_wb,
	rose_amdgpu_op_s_dcache_inv_vol,
	rose_amdgpu_op_s_dcache_wb_vol,
	rose_amdgpu_op_s_dcache_memtime,
	rose_amdgpu_op_s_dcache_memrealtime,
	rose_amdgpu_op_s_mov_b32,
	rose_amdgpu_op_s_mov_b64,
	rose_amdgpu_op_s_cmov_b32,
	rose_amdgpu_op_s_cmov_b64,
	rose_amdgpu_op_s_not_b32,
	rose_amdgpu_op_s_not_b64,
	rose_amdgpu_op_s_wqm_b32,
	rose_amdgpu_op_s_wqm_b64,
	rose_amdgpu_op_s_brev_b32,
	rose_amdgpu_op_s_brev_b64,
	rose_amdgpu_op_s_bcnt0_i32_b32,
	rose_amdgpu_op_s_bcnt0_i32_b64,
	rose_amdgpu_op_s_bcnt1_i32_b32,
	rose_amdgpu_op_s_bcnt1_i32_b64,
	rose_amdgpu_op_s_ff0_i32_b32,
	rose_amdgpu_op_s_ff0_i32_b64,
	rose_amdgpu_op_s_ff1_i32_b32,
	rose_amdgpu_op_s_ff1_i32_b64,
	rose_amdgpu_op_s_flbit_i32_b32,
	rose_amdgpu_op_s_flbit_i32_b64,
	rose_amdgpu_op_s_fltbit_i32,
	rose_amdgpu_op_s_fltbit_i32_i64,
	rose_amdgpu_op_s_sext_i32_i8,
	rose_amdgpu_op_s_sext_i32_i16,
	rose_amdgpu_op_s_bitset0_b32,
	rose_amdgpu_op_s_bitset0_b64,
	rose_amdgpu_op_s_bitset1_b32,
	rose_amdgpu_op_s_bitset1_b64,
	rose_amdgpu_op_s_getpc_b64,
	rose_amdgpu_op_s_setpc_b64,
	rose_amdgpu_op_s_swappc_b64,
	rose_amdgpu_op_s_rfe_b64,
	rose_amdgpu_op_s_and_saveexec_b64,
	rose_amdgpu_op_s_or_savexec_b64,
	rose_amdgpu_op_s_xor_savexec_b64,
	rose_amdgpu_op_s_andn2_savexec_b64,
	rose_amdgpu_op_s_orn2_savexec_b64,
	rose_amdgpu_op_s_nand_savexec_b64,
	rose_amdgpu_op_s_nor_savexec_b64,
	rose_amdgpu_op_s_xnor_savexec_b64,
	rose_amdgpu_op_s_quadmask_b32,
	rose_amdgpu_op_s_quadmask_b64,
	rose_amdgpu_op_s_movrels_b32,
	rose_amdgpu_op_s_movrels_b64,
	rose_amdgpu_op_s_movreld_b32,
	rose_amdgpu_op_s_movreld_b64,
	rose_amdgpu_op_s_cbranch_join,
	rose_amdgpu_op_s_invalid_1,
	rose_amdgpu_op_s_abs_i32,
	rose_amdgpu_op_s_invalid_2,
	rose_amdgpu_op_s_set_gpr_idx_idx,
	rose_amdgpu_op_s_andn1_saveexec_b64,
	rose_amdgpu_op_s_orn1_saveexec_b64,
	rose_amdgpu_op_s_andn1_wrexec_b64,
	rose_amdgpu_op_s_andn2_wrexec_b64,
	rose_amdgpu_op_s_bitreplicate_b64_b32,
	rose_amdgpu_op_flat_load_ubyte,
	rose_amdgpu_op_flat_load_dword,
	rose_amdgpu_op_flat_store_dword,
	rose_amdgpu_op_s_movk_i32,
	rose_amdgpu_op_s_cmovk_i32,
	rose_amdgpu_op_s_cmpk_eq_i32,
	rose_amdgpu_op_s_cmpk_lg_i32,
	rose_amdgpu_op_s_cmpk_gt_i32,
	rose_amdgpu_op_s_cmpk_ge_i32,
	rose_amdgpu_op_s_cmpk_lt_i32,
	rose_amdgpu_op_s_cmpk_le_i32,
	rose_amdgpu_op_s_cmpk_eq_u32,
	rose_amdgpu_op_s_cmpk_lg_u32,
	rose_amdgpu_op_s_cmpk_gt_u32,
	rose_amdgpu_op_s_cmpk_ge_u32,
	rose_amdgpu_op_s_cmpk_lt_u32,
	rose_amdgpu_op_s_cmpk_le_u32,
	rose_amdgpu_op_s_addk_i32,
	rose_amdgpu_op_s_mulk_i32,
	rose_amdgpu_op_s_cbranch_i_fork,
	rose_amdgpu_op_s_getreg_b32,
	rose_amdgpu_op_s_setreg_b32,
	rose_amdgpu_op_s_setreg_imm32_b32,
	rose_amdgpu_op_s_call_b64,
	rose_amdgpu_op_v_nop,
	rose_amdgpu_op_v_mov_b32,
	rose_amdgpu_op_v_readfirstlane_b32,
	rose_amdgpu_op_v_cvt_i32_f64,
	rose_amdgpu_op_v_cvt_f64_i32,
	rose_amdgpu_op_v_cvt_f32_i32,
	rose_amdgpu_op_v_cvt_f32_u32,
	rose_amdgpu_op_v_cvt_u32_f32,
	rose_amdgpu_op_v_cvt_i32_f32,
	rose_amdgpu_op_v_cvt_f16_f32,
	rose_amdgpu_op_v_cvt_f32_f16,
	rose_amdgpu_op_v_cvt_rpi_i32_f32,
	rose_amdgpu_op_v_cvt_flr_i32_f32,
	rose_amdgpu_op_v_cvt_off_f32_i4,
	rose_amdgpu_op_v_pk_mad_i16
};
#endif