#========================================================================================
# FindLibIberty.cmake
#
# Find LibIberty include dirs and libraries
#
#		----------------------------------------
#
# Use this module by invoking find_package with the form::
#
#  find_package(LibIberty
#    [REQUIRED]             # Fail with error if LibIberty is not found
#  )
#
# This module reads hints about search locations from variables::
#
#	LibIberty_ROOT_DIR      - Base directory the of LibIberty installation
#	LibIberty_LIBRARYDIR    - Hint directory that contains the LibIberty library files
#   IBERTY_LIBRARIES        - Alias for LibIberty_LIBRARIES (backwards compatibility only)
#
# and saves search results persistently in CMake cache entries::
#
#	LibIberty_FOUND         - True if headers and requested libraries were found
#   IBERTY_FOUND            - Alias for LibIberty_FOUND (backwards compatibility only)
#	LibIberty_LIBRARY_DIRS  - Link directories for LibIberty libraries
#	LibIberty_LIBRARIES     - LibIberty library files
#   IBERTY_LIBRARIES        - Alias for LibIberty_LIBRARIES (backwards compatibility only)
#
#========================================================================================

if(LibIberty_FOUND)
  return()
endif()

# Keep the semantics of IBERTY_LIBRARIES for backward compatibility
# NB: If both are specified, LibIberty_LIBRARIES is ignored
if(NOT "${IBERTY_LIBRARIES}" STREQUAL "")
  set(LibIberty_LIBRARIES ${IBERTY_LIBRARIES})
endif()

include(DyninstSystemPaths)

# Non-standard subdirectories to search
set(_path_suffixes libiberty iberty)

# iberty_pic is for Debian <= wheezy
find_library(LibIberty_LIBRARIES
             NAMES iberty_pic iberty
             HINTS ${LibIberty_ROOT_DIR}
                   ${LibIberty_LIBRARYDIR}
                   ${IBERTY_LIBRARIES}
             PATHS ${DYNINST_SYSTEM_LIBRARY_PATHS}
             PATH_SUFFIXES ${_path_suffixes})

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(LibIberty
                                  FOUND_VAR
                                  LibIberty_FOUND
                                  REQUIRED_VARS
                                  LibIberty_LIBRARIES)

# For backwards compatibility only
set(IBERTY_FOUND ${LibIberty_FOUND})

if(LibIberty_FOUND)
  foreach(l in ${LibIberty_LIBRARIES})
    get_filename_component(_dir ${l} DIRECTORY)
    list(APPEND LibIberty_LIBRARY_DIRS ${_dir})
  endforeach()
  
  # For backwards compatibility only
  set(IBERTY_LIBRARIES ${LibIberty_LIBRARIES})
endif()
