%global commit	3c668744f2242e453fdcd6dca36d3e1d82d0367a

Name:		driverctl
Version:	0.95
Release:	1%{?dist}
Summary:	Device driver control utility

Group:		System Environment/Kernel
License:	LGPLv2
URL:		https://gitlab.com/driverctl/driverctl
BuildArch:	noarch

# rpm doesn't grok the gitlab url but spectool understands this monster
Source0:	https://gitlab.com/OWNER/%{name}/repository/archive.tar.gz?ref=%{version}#/%{name}-%{version}-%{commit}.tar.gz

# for udev macros
BuildRequires: systemd
Requires(post,postun): %{_sbindir}/udevadm
Requires: coreutils udev

%description
driverctl is a tool for manipulating and inspecting the system
device driver choices.

Devices are normally assigned to their sole designated kernel driver
by default. However in some situations it may be desireable to
override that default, for example to try an older driver to
work around a regression in a driver or to try an experimental alternative
driver. Another common use-case is pass-through drivers and driver
stubs to allow userspace to drive the device, such as in case of
virtualization.

driverctl integrates with udev to support overriding
driver selection for both cold- and hotplugged devices from the
moment of discovery, but can also change already assigned drivers,
assuming they are not in use by the system. The driver overrides
created by driverctl are persistent across system reboots
by default.

%prep
%setup -q -n %{name}-%{version}-%{commit}

%install
%make_install

%files
%license COPYING
%doc README TODO
%{_sbindir}/driverctl
%{_udevrulesdir}/*.rules
%{_udevrulesdir}/../vfio_name
%dir %{_sysconfdir}/driverctl.d
%{_datadir}/bash-completion/
%{_mandir}/man8/driverctl.8*

%post
%udev_rules_update

%postun
%udev_rules_update

%changelog

* Thu Sep 29 2016 Panu Matilainen <pmatilai@redhat.com>
- update URLs to new group-based location

* Fri Sep 16 2016 Panu Matilainen <pmatilai@redhat.com>
- use a relative path from udevdir because macros are Better, Faster... meh

* Tue Sep 13 2016 Panu Matilainen <pmatilai@redhat.com>
- use fedorable source url which spectool actually understands

* Tue Sep 13 2016 Panu Matilainen <pmatilai@redhat.com>
- create + use a gitlab-compatible archive with commit-hash and all

* Tue Sep 13 2016 Panu Matilainen <pmatilai@redhat.com>
- use a macro for udevadm location

* Tue Sep 13 2016 Panu Matilainen <pmatilai@redhat.com>
- move bash completions to newer standard in %%{_datadir}/bash-completion

* Tue Sep 6 2016 Panu Matilainen <pmatilai@redhat.com>
- copy-paste proper description from README

* Tue Sep 6 2016 Panu Matilainen <pmatilai@redhat.com>
- use %%make_install macro, as if it made any difference...

* Tue Sep 6 2016 Panu Matilainen <pmatilai@redhat.com>
- require /usr/sbin/udevadm for %%post and %%postun, its been moving
  around from package to package...

* Fri Sep 2 2016 Panu Matilainen <pmatilai@redhat.com>
- shut up %%setup macro
- fixup license tag for fedora correctness

* Fri Sep 2 2016 Panu Matilainen <pmatilai@redhat.com>
- update URLs for new home at gitlab

* Thu Sep 1 2016 Panu Matilainen <pmatilai@redhat.com>
- it's bash_completion.d, not with dash (nice rhyme, no?)

* Tue Aug 30 2016 Panu Matilainen <pmatilai@redhat.com>
- add missing dependencies on coreutils and udev

* Fri Dec 4 2015 Panu Matilainen <pmatilai@redhat.com>
- add a todo file

* Thu Dec 3 2015 Panu Matilainen <pmatilai@redhat.com>
- add a brief README with source repository, system reqs + contact address

* Thu Dec 3 2015 Panu Matilainen <pmatilai@redhat.com>
- add a proper license (LGPL v2.1 to match systemd)
- adjust spec which said GPLv2 out of habit

* Thu Nov 12 2015 Panu Matilainen <pmatilai@redhat.com>
- add an url to the source

* Thu Nov 12 2015 Panu Matilainen <pmatilai@redhat.com>
- add a man page

* Thu Nov 12 2015 Panu Matilainen <pmatilai@redhat.com>
- buildrequire systemd for the udev macros

* Wed Nov 11 2015 Panu Matilainen <pmatilai@redhat.com>
- add bash completion from Aaron Conole

* Tue Nov 10 2015 Panu Matilainen <pmatilai@redhat.com>
- make kludgery to get a srpm build target with autogenerated
  version and foo

