// Copyright (c) Microsoft Corporation.  All Rights Reserved.  See License.txt in the project root for license information.

namespace Microsoft.FSharp.Core

module internal SR =
#if FX_RESHAPED_REFLECTION
    open System.Reflection
    type private TypeInThisAssembly (_dummy:obj) = class end
    // can't use typeof here.  Because intrinsics are not yet defined.
    let private resources = new System.Resources.ResourceManager("FSCore", TypeInThisAssembly(null).GetType().GetTypeInfo().Assembly)
#else
    let private resources = new System.Resources.ResourceManager("FSCore", System.Reflection.Assembly.GetExecutingAssembly())
#endif

    let matchCasesIncomplete = "matchCasesIncomplete"
    let resetNotSupported = "resetNotSupported"
    let indexOutOfBounds = "indexOutOfBounds"
    let listsHadDifferentLengths = "listsHadDifferentLengths"
    let inputListWasEmpty = "inputListWasEmpty"
    let enumerationNotStarted = "enumerationNotStarted"
    let setContainsNoElements = "setContainsNoElements"
    let enumerationAlreadyFinished = "enumerationAlreadyFinished"
    let findElementNotFound = "findElementNotFound"
    let findIndexElementNotFound = "findIndexElementNotFound"
    let pickElementNotFound = "pickElementNotFound"            
    let notEnoughElements = "notEnoughElements"
    let inputMustBeNonNegative = "inputMustBeNonNegative"
    let inputMustBePositive = "inputMustBePositive"
    let enumerationPastIntMaxValue = "enumerationPastIntMaxValue"
    let inputSequenceEmpty = "inputSequenceEmpty"
    let inputSequenceTooLong = "inputSequenceTooLong"
    let mapCannotBeMutated = "mapCannotBeMutated"
    let notComparable = "notComparable"
    let outOfRange = "outOfRange"
    let arraysHadDifferentLengths = "arraysHadDifferentLengths"
    let arrayWasEmpty = "arrayWasEmpty"
    let nonZeroBasedDisallowed = "nonZeroBasedDisallowed"
    let mismatchIAREnd = "mismatchIAREnd"
    let mismatchIARCancel = "mismatchIARCancel"
    let syncContextNull = "syncContextNull"
    let mailboxScanTimedOut = "mailboxScanTimedOut"
    let mailboxReceiveTimedOut = "mailboxReceiveTimedOut"
    let mailboxProcessorAlreadyStarted = "mailboxProcessorAlreadyStarted"
    let mailboxProcessorPostAndReplyTimedOut = "mailboxProcessorPostAndReplyTimedOut"
    let mailboxProcessorPostAndAsyncReplyTimedOut = "mailboxProcessorPostAndAsyncReplyTimedOut"
    let cannotMutate = "cannotMutate"
    let notAPermutation = "notAPermutation"
    let failedReadEnoughBytes = "failedReadEnoughBytes"
    let addressOpNotFirstClass = "addressOpNotFirstClass"
    let genericCompareFail1 = "genericCompareFail1"
    let notUsedForHashing = "notUsedForHashing"
    let badFormatString = "badFormatString"
    let dyInvDivByIntCoerce = "dyInvDivByIntCoerce"
    let dyInvOpAddCoerce = "dyInvOpAddCoerce"
    let dyInvOpAddOverload = "dyInvOpAddOverload"
    let dyInvOpMultCoerce = "dyInvOpMultCoerce"
    let dyInvOpMultOverload = "dyInvOpMultOverload"
    let keyNotFound = "keyNotFound"
    let stepCannotBeZero = "stepCannotBeZero"
    let startCannotBeNaN = "startCannotBeNaN"
    let stepCannotBeNaN = "stepCannotBeNaN"
    let endCannotBeNaN = "endCannotBeNaN"
    let checkInit = "checkInit"
    let checkStaticInit = "checkStaticInit"
    let noNegateMinValue = "noNegateMinValue"
    let delegateExpected = "delegateExpected"
    let invalidTupleTypes = "invalidTupleTypes"
    let notATupleType = "notATupleType"
    let notAFunctionType = "notAFunctionType"
    let tupleIndexOutOfRange = "tupleIndexOutOfRange"
    let objIsNullAndNoType = "objIsNullAndNoType"
    let privateUnionType = "privateUnionType"
    let notAUnionType = "notAUnionType"
    let privateExceptionType = "privateExceptionType"
    let notAnExceptionType = "notAnExceptionType"
    let privateRecordType = "privateRecordType"
    let notARecordType = "notARecordType"
    let nullsNotAllowedInArray = "nullsNotAllowedInArray"
    let objIsNotARecord = "objIsNotARecord"
    let keyNotFoundAlt = "keyNotFoundAlt"
    let firstClassUsesOfSplice = "firstClassUsesOfSplice"
    let printfNotAFunType = "printfNotAFunType"
    let printfMissingFormatSpecifier = "printfMissingFormatSpecifier"
    let printfHashFormatSpecifierIllegal = "printfHashFormatSpecifierIllegal"
    let printfPrecisonSpecifierIllegal = "printfPrecisonSpecifierIllegal"
    let printfWidthSpecifierIllegal = "printfWidthSpecifierIllegal"
    let printfSpecifierAfterIllegal = "printfSpecifierAfterIllegal"
    let printfBadFormatSpecifier = "printfBadFormatSpecifier"
    let printfBadIntegerForDynamicFomatter = "printfBadIntegerForDynamicFomatter"
    let printfExpectedWidth = "printfExpectedWidth"
    let printfExpectedPrecision = "printfExpectedPrecision"
    let printfBadFloatValue = "printfBadFloatValue"
    let multipleCompilationMappings = "multipleCompilationMappings"
    let constructorForUnionCaseNotFound = "constructorForUnionCaseNotFound"
    let moveNextNotCalledOrFinished = "moveNextNotCalledOrFinished"
    let thisValueCannotBeMutated = "thisValueCannotBeMutated"
    let optionValueWasNone = "optionValueWasNone"
    // quotations.fs start with Q
    let QmissingRecordField = "QmissingRecordField"
    let QmissingUnionCase = "QmissingUnionCase"
    let QinvalidCaseIndex = "QinvalidCaseIndex"
    let QexpectedTwoTypes = "QexpectedTwoTypes"
    let QexpectedOneType = "QexpectedOneType"
    let QunrecognizedMethodCall = "QunrecognizedMethodCall"
    let QunexpectedHole = "QunexpectedHole"
    let QtmmExpectedFunction = "QtmmExpectedFunction"
    let QtmmInvalidParam = "QtmmInvalidParam"
    let QtmmFunctionArgTypeMismatch = "QtmmFunctionArgTypeMismatch"
    let QtmmVarTypeNotMatchRHS = "QtmmVarTypeNotMatchRHS"
    let QtmmTuple = "QtmmTuple"
    let QtmmExprNotMatchTuple = "QtmmExprNotMatchTuple"
    let QtmmIncorrectArgForRecord = "QtmmIncorrectArgForRecord"
    let QtmmIncorrectArgForUnion = "QtmmIncorrectArgForUnion"
    let QtmmExprTypeMismatch = "QtmmExprTypeMismatch"
    let QtmmTrueAndFalseMustMatch = "QtmmTrueAndFalseMustMatch"
    let QtmmCondMustBeBool = "QtmmCondMustBeBool"
    let QtmmInitArray = "QtmmInitArray"
    let QtmmBadFieldType = "QtmmBadFieldType"
    let QtmmLowerUpperBoundMustBeInt = "QtmmLowerUpperBoundMustBeInt"
    let QtmmLoopBodyMustBeLambdaTakingInteger = "QtmmLoopBodyMustBeLambdaTakingInteger"
    let QtmmGuardMustBeBool = "QtmmGuardMustBeBool"
    let QtmmBodyMustBeUnit = "QtmmBodyMustBeUnit"
    let QtmmFunTypeNotMatchDelegate = "QtmmFunTypeNotMatchDelegate"
    let QtmmRaw = "QtmmRaw"
    let QtmmExprHasWrongType = "QtmmExprHasWrongType"
    let QincorrectNumArgs = "QincorrectNumArgs"
    let QincorrectType = "QincorrectType"
    let QincorrectInstanceType = "QincorrectInstanceType"
    let QinvalidFuncType = "QinvalidFuncType"
    let QtupleLengthsDiffer = "QtupleLengthsDiffer"
    let QtupleAccessOutOfRange = "QtupleAccessOutOfRange"
    let QincompatibleRecordLength = "QincompatibleRecordLength"
    let QunionNeedsDiffNumArgs = "QunionNeedsDiffNumArgs"
    let QstaticWithReceiverObject = "QstaticWithReceiverObject"
    let QnonStaticNoReceiverObject = "QnonStaticNoReceiverObject"
    let QwritingGetOnly = "QwritingGetOnly"
    let QreadingSetOnly = "QreadingSetOnly"
    let QparentCannotBeNull = "QparentCannotBeNull"
    let QfailedToBindProperty = "QfailedToBindProperty"
    let QfailedToBindField = "QfailedToBindField"
    let QfailedToBindConstructor = "QfailedToBindConstructor"
    let QfailedToBindTypeInAssembly = "QfailedToBindTypeInAssembly"
    let QwrongNumOfTypeArgs = "QwrongNumOfTypeArgs"
    let QillFormedAppOrLet = "QillFormedAppOrLet"
    let QcannotTakeAddress = "QcannotTakeAddress"
    let QcannotBindToMethod = "QcannotBindToMethod"
    let QcannotBindProperty = "QcannotBindProperty"
    let QcannotBindFunction = "QcannotBindFunction"
    let QfailedToBindAssembly = "QfailedToBindAssembly"
    let QtypeArgumentOutOfRange = "QtypeArgumentOutOfRange"
    let controlContinuationInvokedMultipleTimes = "controlContinuationInvokedMultipleTimes"
    let invalidRecordTypeConstructorNotDefined = "invalidRecordTypeConstructorNotDefined"
    let invalidTupleTypeConstructorNotDefined = "invalidTupleTypeConstructorNotDefined"
    let thenByError = "thenByError"
    let failDueToUnsupportedInputTypeInSumByOrAverageBy = "failDueToUnsupportedInputTypeInSumByOrAverageBy"
    let unsupportedIfThenElse = "unsupportedIfThenElse"
    let unsupportedQueryConstruct = "unsupportedQueryConstruct"
    let unsupportedQueryConstructKind = "unsupportedQueryConstructKind"
    let unsupportedQueryCall = "unsupportedQueryCall"
    let unsupportedQueryProperty = "unsupportedQueryProperty"
    
    let GetString(name:System.String) : System.String = 
        resources.GetString(name, System.Globalization.CultureInfo.CurrentUICulture)
