# .NET Standard 2.0 vs. 1.6

[Overview](netstandard2.0.md) | [Previous](netstandard1.6_diff.md)

***.NET Standard 2.0 is work in progress***

```diff
 namespace System {
+    public class AccessViolationException : SystemException {
+        public AccessViolationException();
+        protected AccessViolationException(SerializationInfo info, StreamingContext context);
+        public AccessViolationException(string message);
+        public AccessViolationException(string message, Exception innerException);
+    }
     public static class Activator {
+        public static object CreateInstance(Type type, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture);
+        public static object CreateInstance(Type type, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public static object CreateInstance(Type type, object[] args, object[] activationAttributes);
     }
     public class AggregateException : Exception {
+        protected AggregateException(SerializationInfo info, StreamingContext context);
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public static class AppContext {
-        public static string TargetFrameworkName { get; }
-        public static object GetData(string name);
     }
+    public sealed class AppDomain : MarshalByRefObject {
+        public string BaseDirectory { get; }
+        public static AppDomain CurrentDomain { get; }
+        public string DynamicDirectory { get; }
+        public string FriendlyName { get; }
+        public int Id { get; }
+        public bool IsFullyTrusted { get; }
+        public bool IsHomogenous { get; }
+        public static bool MonitoringIsEnabled { get; set; }
+        public long MonitoringSurvivedMemorySize { get; }
+        public static long MonitoringSurvivedProcessMemorySize { get; }
+        public long MonitoringTotalAllocatedMemorySize { get; }
+        public TimeSpan MonitoringTotalProcessorTime { get; }
+        public string RelativeSearchPath { get; }
+        public bool ShadowCopyFiles { get; }
+        public void AppendPrivatePath(string path);
+        public string ApplyPolicy(string assemblyName);
+        public void ClearPrivatePath();
+        public void ClearShadowCopyPath();
+        public static AppDomain CreateDomain(string friendlyName);
+        public int ExecuteAssembly(string assemblyFile);
+        public int ExecuteAssembly(string assemblyFile, string[] args);
+        public int ExecuteAssembly(string assemblyFile, string[] args, byte[] hashValue, AssemblyHashAlgorithm hashAlgorithm);
+        public int ExecuteAssemblyByName(AssemblyName assemblyName, params string[] args);
+        public int ExecuteAssemblyByName(string assemblyName);
+        public int ExecuteAssemblyByName(string assemblyName, params string[] args);
+        public Assembly[] GetAssemblies();
+        public static int GetCurrentThreadId();
+        public object GetData(string name);
+        public new Type GetType();
+        public override object InitializeLifetimeService();
+        public Nullable<bool> IsCompatibilitySwitchSet(string value);
+        public bool IsDefaultAppDomain();
+        public bool IsFinalizingForUnload();
+        public Assembly Load(AssemblyName assemblyRef);
+        public Assembly Load(byte[] rawAssembly);
+        public Assembly Load(byte[] rawAssembly, byte[] rawSymbolStore);
+        public Assembly Load(string assemblyString);
+        public Assembly[] ReflectionOnlyGetAssemblies();
+        public void SetCachePath(string path);
+        public void SetData(string name, object data);
+        public void SetDynamicBase(string path);
+        public void SetPrincipalPolicy(PrincipalPolicy policy);
+        public void SetShadowCopyFiles();
+        public void SetShadowCopyPath(string path);
+        public void SetThreadPrincipal(IPrincipal principal);
+        public override string ToString();
+        public static void Unload(AppDomain domain);
+        public event AssemblyLoadEventHandler AssemblyLoad;
+        public event ResolveEventHandler AssemblyResolve;
+        public event EventHandler DomainUnload;
+        public event EventHandler<FirstChanceExceptionEventArgs> FirstChanceException;
+        public event EventHandler ProcessExit;
+        public event ResolveEventHandler ReflectionOnlyAssemblyResolve;
+        public event ResolveEventHandler ResourceResolve;
+        public event ResolveEventHandler TypeResolve;
+        public event UnhandledExceptionEventHandler UnhandledException;
+    }
+    public class AppDomainUnloadedException : SystemException {
+        public AppDomainUnloadedException();
+        protected AppDomainUnloadedException(SerializationInfo info, StreamingContext context);
+        public AppDomainUnloadedException(string message);
+        public AppDomainUnloadedException(string message, Exception innerException);
+    }
+    public class ApplicationException : Exception {
+        public ApplicationException();
+        protected ApplicationException(SerializationInfo info, StreamingContext context);
+        public ApplicationException(string message);
+        public ApplicationException(string message, Exception innerException);
+    }
+    public sealed class ApplicationId {
+        public ApplicationId(byte[] publicKeyToken, string name, Version version, string processorArchitecture, string culture);
+        public string Culture { get; }
+        public string Name { get; }
+        public string ProcessorArchitecture { get; }
+        public byte[] PublicKeyToken { get; }
+        public Version Version { get; }
+        public ApplicationId Copy();
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public sealed class ApplicationIdentity : ISerializable {
+        public ApplicationIdentity(string applicationIdentityFullName);
+        public string CodeBase { get; }
+        public string FullName { get; }
+        public override string ToString();
+    }
-    public class ArgumentException : Exception {
+    public class ArgumentException : SystemException, ISerializable {
+        protected ArgumentException(SerializationInfo info, StreamingContext context);
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public class ArgumentNullException : ArgumentException {
+        protected ArgumentNullException(SerializationInfo info, StreamingContext context);
     }
-    public class ArgumentOutOfRangeException : ArgumentException {
+    public class ArgumentOutOfRangeException : ArgumentException, ISerializable {
+        protected ArgumentOutOfRangeException(SerializationInfo info, StreamingContext context);
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
-    public class ArithmeticException : Exception {
+    public class ArithmeticException : SystemException {
+        protected ArithmeticException(SerializationInfo info, StreamingContext context);
     }
-    public abstract class Array : ICollection, IEnumerable, IList, IStructuralComparable, IStructuralEquatable {
+    public abstract class Array : ICloneable, ICollection, IEnumerable, IList, IStructuralComparable, IStructuralEquatable {
+        public bool IsFixedSize { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public long LongLength { get; }
+        public object SyncRoot { get; }
+        public static ReadOnlyCollection<T> AsReadOnly<T>(T[] array);
+        public static TOutput[] ConvertAll<TInput, TOutput>(TInput[] array, Converter<TInput, TOutput> converter);
+        public static void Copy(Array sourceArray, Array destinationArray, long length);
+        public static void Copy(Array sourceArray, long sourceIndex, Array destinationArray, long destinationIndex, long length);
+        public void CopyTo(Array array, long index);
+        public static Array CreateInstance(Type elementType, int length1, int length2);
+        public static Array CreateInstance(Type elementType, int length1, int length2, int length3);
+        public static Array CreateInstance(Type elementType, params long[] lengths);
+        public static void ForEach<T>(T[] array, Action<T> action);
+        public long GetLongLength(int dimension);
+        public object GetValue(int index1, int index2);
+        public object GetValue(int index1, int index2, int index3);
+        public object GetValue(long index);
+        public object GetValue(long index1, long index2);
+        public object GetValue(long index1, long index2, long index3);
+        public object GetValue(params long[] indices);
+        public void SetValue(object value, int index1, int index2);
+        public void SetValue(object value, int index1, int index2, int index3);
+        public void SetValue(object value, long index);
+        public void SetValue(object value, long index1, long index2);
+        public void SetValue(object value, long index1, long index2, long index3);
+        public void SetValue(object value, params long[] indices);
     }
-    public class ArrayTypeMismatchException : Exception {
+    public class ArrayTypeMismatchException : SystemException {
+        protected ArrayTypeMismatchException(SerializationInfo info, StreamingContext context);
     }
+    public class AssemblyLoadEventArgs : EventArgs {
+        public AssemblyLoadEventArgs(Assembly loadedAssembly);
+        public Assembly LoadedAssembly { get; }
+    }
+    public delegate void AssemblyLoadEventHandler(object sender, AssemblyLoadEventArgs args); {
+        public AssemblyLoadEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, AssemblyLoadEventArgs args, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, AssemblyLoadEventArgs args);
+    }
     public abstract class Attribute {
+        public virtual object TypeId { get; }
+        public static Attribute GetCustomAttribute(Assembly element, Type attributeType);
+        public static Attribute GetCustomAttribute(Assembly element, Type attributeType, bool inherit);
+        public static Attribute GetCustomAttribute(MemberInfo element, Type attributeType);
+        public static Attribute GetCustomAttribute(MemberInfo element, Type attributeType, bool inherit);
+        public static Attribute GetCustomAttribute(Module element, Type attributeType);
+        public static Attribute GetCustomAttribute(Module element, Type attributeType, bool inherit);
+        public static Attribute GetCustomAttribute(ParameterInfo element, Type attributeType);
+        public static Attribute GetCustomAttribute(ParameterInfo element, Type attributeType, bool inherit);
+        public static Attribute[] GetCustomAttributes(Assembly element);
+        public static Attribute[] GetCustomAttributes(Assembly element, bool inherit);
+        public static Attribute[] GetCustomAttributes(Assembly element, Type attributeType);
+        public static Attribute[] GetCustomAttributes(Assembly element, Type attributeType, bool inherit);
+        public static Attribute[] GetCustomAttributes(MemberInfo element);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, bool inherit);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type, bool inherit);
+        public static Attribute[] GetCustomAttributes(Module element);
+        public static Attribute[] GetCustomAttributes(Module element, bool inherit);
+        public static Attribute[] GetCustomAttributes(Module element, Type attributeType);
+        public static Attribute[] GetCustomAttributes(Module element, Type attributeType, bool inherit);
+        public static Attribute[] GetCustomAttributes(ParameterInfo element);
+        public static Attribute[] GetCustomAttributes(ParameterInfo element, bool inherit);
+        public static Attribute[] GetCustomAttributes(ParameterInfo element, Type attributeType);
+        public static Attribute[] GetCustomAttributes(ParameterInfo element, Type attributeType, bool inherit);
+        public virtual bool IsDefaultAttribute();
+        public static bool IsDefined(Assembly element, Type attributeType);
+        public static bool IsDefined(Assembly element, Type attributeType, bool inherit);
+        public static bool IsDefined(MemberInfo element, Type attributeType);
+        public static bool IsDefined(MemberInfo element, Type attributeType, bool inherit);
+        public static bool IsDefined(Module element, Type attributeType);
+        public static bool IsDefined(Module element, Type attributeType, bool inherit);
+        public static bool IsDefined(ParameterInfo element, Type attributeType);
+        public static bool IsDefined(ParameterInfo element, Type attributeType, bool inherit);
+        public virtual bool Match(object obj);
     }
-    public class BadImageFormatException : Exception {
+    public class BadImageFormatException : SystemException {
+        protected BadImageFormatException(SerializationInfo info, StreamingContext context);
+        public string FusionLog { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public enum Base64FormattingOptions {
+        InsertLineBreaks = 1,
+        None = 0,
+    }
     public struct Boolean : IComparable, IComparable<bool>, IConvertible, IEquatable<bool> {
+        public int CompareTo(object obj);
+        public TypeCode GetTypeCode();
+        public string ToString(IFormatProvider provider);
     }
     public struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
+    public class CannotUnloadAppDomainException : SystemException {
+        public CannotUnloadAppDomainException();
+        protected CannotUnloadAppDomainException(SerializationInfo info, StreamingContext context);
+        public CannotUnloadAppDomainException(string message);
+        public CannotUnloadAppDomainException(string message, Exception innerException);
+    }
     public struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char> {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
+        public static UnicodeCategory GetUnicodeCategory(char c);
+        public static UnicodeCategory GetUnicodeCategory(string s, int index);
+        public static char ToLower(char c, CultureInfo culture);
+        public string ToString(IFormatProvider provider);
+        public static char ToUpper(char c, CultureInfo culture);
     }
+    public sealed class CharEnumerator : ICloneable, IDisposable, IEnumerator, IEnumerator<char> {
+        public char Current { get; }
+        public object Clone();
+        public void Dispose();
+        public bool MoveNext();
+        public void Reset();
+    }
     public static class Console {
+        public static Stream OpenStandardError(int bufferSize);
+        public static Stream OpenStandardInput(int bufferSize);
+        public static Stream OpenStandardOutput(int bufferSize);
     }
     public enum ConsoleKey {
+        Applications = 93,
+        Attention = 246,
+        BrowserBack = 166,
+        BrowserFavorites = 171,
+        BrowserForward = 167,
+        BrowserHome = 172,
+        BrowserRefresh = 168,
+        BrowserSearch = 170,
+        BrowserStop = 169,
+        CrSel = 247,
+        EraseEndOfFile = 249,
+        ExSel = 248,
+        LaunchApp1 = 182,
+        LaunchApp2 = 183,
+        LaunchMail = 180,
+        LaunchMediaSelect = 181,
+        LeftWindows = 91,
+        MediaNext = 176,
+        MediaPlay = 179,
+        MediaPrevious = 177,
+        MediaStop = 178,
+        NoName = 252,
+        Oem102 = 226,
+        Pa1 = 253,
+        Packet = 231,
+        Play = 250,
+        Process = 229,
+        RightWindows = 92,
+        VolumeDown = 174,
+        VolumeMute = 173,
+        VolumeUp = 175,
+        Zoom = 251,
     }
+    public abstract class ContextBoundObject : MarshalByRefObject {
+        protected ContextBoundObject();
+    }
+    public class ContextMarshalException : SystemException {
+        public ContextMarshalException();
+        protected ContextMarshalException(SerializationInfo info, StreamingContext context);
+        public ContextMarshalException(string message);
+        public ContextMarshalException(string message, Exception inner);
+    }
+    public class ContextStaticAttribute : Attribute {
+        public ContextStaticAttribute();
+    }
     public static class Convert {
+        public static readonly object DBNull;
+        public static object ChangeType(object value, TypeCode typeCode);
+        public static bool IsDBNull(object value);
+        public static int ToBase64CharArray(byte[] inArray, int offsetIn, int length, char[] outArray, int offsetOut, Base64FormattingOptions options);
+        public static string ToBase64String(byte[] inArray, Base64FormattingOptions options);
+        public static string ToBase64String(byte[] inArray, int offset, int length, Base64FormattingOptions options);
+        public static bool ToBoolean(char value);
+        public static bool ToBoolean(DateTime value);
+        public static byte ToByte(DateTime value);
+        public static char ToChar(bool value);
+        public static char ToChar(char value);
+        public static char ToChar(DateTime value);
+        public static char ToChar(decimal value);
+        public static char ToChar(double value);
+        public static char ToChar(float value);
+        public static DateTime ToDateTime(bool value);
+        public static DateTime ToDateTime(byte value);
+        public static DateTime ToDateTime(char value);
+        public static DateTime ToDateTime(DateTime value);
+        public static DateTime ToDateTime(decimal value);
+        public static DateTime ToDateTime(double value);
+        public static DateTime ToDateTime(short value);
+        public static DateTime ToDateTime(int value);
+        public static DateTime ToDateTime(long value);
+        public static DateTime ToDateTime(sbyte value);
+        public static DateTime ToDateTime(float value);
+        public static DateTime ToDateTime(ushort value);
+        public static DateTime ToDateTime(uint value);
+        public static DateTime ToDateTime(ulong value);
+        public static decimal ToDecimal(char value);
+        public static decimal ToDecimal(DateTime value);
+        public static double ToDouble(char value);
+        public static double ToDouble(DateTime value);
+        public static short ToInt16(DateTime value);
+        public static int ToInt32(DateTime value);
+        public static long ToInt64(DateTime value);
+        public static sbyte ToSByte(DateTime value);
+        public static float ToSingle(char value);
+        public static float ToSingle(DateTime value);
+        public static string ToString(string value);
+        public static string ToString(string value, IFormatProvider provider);
+        public static ushort ToUInt16(DateTime value);
+        public static uint ToUInt32(DateTime value);
+        public static ulong ToUInt64(DateTime value);
     }
+    public delegate TOutput Converter<in TInput, out TOutput>(TInput input); {
+        public Converter(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(TInput input, AsyncCallback callback, object @object);
+        public virtual TOutput EndInvoke(IAsyncResult result);
+        public virtual TOutput Invoke(TInput input);
+    }
-    public sealed class DataMisalignedException : Exception {
+    public sealed class DataMisalignedException : SystemException {
     }
-    public struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable {
+    public struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable {
+        public DateTime(int year, int month, int day, Calendar calendar);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, Calendar calendar);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar, DateTimeKind kind);
+        public int CompareTo(object value);
+        public static DateTime FromOADate(double d);
+        public TypeCode GetTypeCode();
+        public string ToLongDateString();
+        public string ToLongTimeString();
+        public double ToOADate();
+        public string ToShortDateString();
+        public string ToShortTimeString();
     }
-    public struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IEquatable<DateTimeOffset>, IFormattable {
+    public struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable {
+        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar, TimeSpan offset);
     }
+    public sealed class DBNull : IConvertible, ISerializable {
+        public static readonly DBNull Value;
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        public TypeCode GetTypeCode();
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+    }
-    public struct Decimal : IComparable, IComparable<decimal>, IConvertible, IEquatable<decimal>, IFormattable {
+    public struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable {
+        public int CompareTo(object value);
+        public static decimal FromOACurrency(long cy);
+        public TypeCode GetTypeCode();
+        public static decimal Round(decimal d);
+        public static decimal Round(decimal d, int decimals);
+        public static decimal Round(decimal d, int decimals, MidpointRounding mode);
+        public static decimal Round(decimal d, MidpointRounding mode);
+        public static long ToOACurrency(decimal value);
     }
-    public abstract class Delegate {
+    public abstract class Delegate : ICloneable, ISerializable {
+        protected Delegate(object target, string method);
+        protected Delegate(Type target, string method);
+        public MethodInfo Method { get; }
+        public virtual object Clone();
+        protected virtual Delegate CombineImpl(Delegate d);
+        public static Delegate CreateDelegate(Type type, MethodInfo method);
+        public static Delegate CreateDelegate(Type type, MethodInfo method, bool throwOnBindFailure);
+        public static Delegate CreateDelegate(Type type, object firstArgument, MethodInfo method);
+        public static Delegate CreateDelegate(Type type, object firstArgument, MethodInfo method, bool throwOnBindFailure);
+        public static Delegate CreateDelegate(Type type, object target, string method);
+        public static Delegate CreateDelegate(Type type, object target, string method, bool ignoreCase);
+        public static Delegate CreateDelegate(Type type, object target, string method, bool ignoreCase, bool throwOnBindFailure);
+        public static Delegate CreateDelegate(Type type, Type target, string method);
+        public static Delegate CreateDelegate(Type type, Type target, string method, bool ignoreCase);
+        public static Delegate CreateDelegate(Type type, Type target, string method, bool ignoreCase, bool throwOnBindFailure);
+        protected virtual object DynamicInvokeImpl(object[] args);
+        protected virtual MethodInfo GetMethodImpl();
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        protected virtual Delegate RemoveImpl(Delegate d);
     }
     public class DivideByZeroException : ArithmeticException {
+        protected DivideByZeroException(SerializationInfo info, StreamingContext context);
     }
     public class DllNotFoundException : TypeLoadException {
+        protected DllNotFoundException(SerializationInfo info, StreamingContext context);
     }
     public struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
+    public class DuplicateWaitObjectException : ArgumentException {
+        public DuplicateWaitObjectException();
+        protected DuplicateWaitObjectException(SerializationInfo info, StreamingContext context);
+        public DuplicateWaitObjectException(string parameterName);
+        public DuplicateWaitObjectException(string message, Exception innerException);
+        public DuplicateWaitObjectException(string parameterName, string message);
+    }
+    public class EntryPointNotFoundException : TypeLoadException {
+        public EntryPointNotFoundException();
+        protected EntryPointNotFoundException(SerializationInfo info, StreamingContext context);
+        public EntryPointNotFoundException(string message);
+        public EntryPointNotFoundException(string message, Exception inner);
+    }
     public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
+        public TypeCode GetTypeCode();
+        public static object ToObject(Type enumType, byte value);
+        public static object ToObject(Type enumType, short value);
+        public static object ToObject(Type enumType, int value);
+        public static object ToObject(Type enumType, long value);
+        public static object ToObject(Type enumType, sbyte value);
+        public static object ToObject(Type enumType, ushort value);
+        public static object ToObject(Type enumType, uint value);
+        public static object ToObject(Type enumType, ulong value);
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format, IFormatProvider provider);
     }
     public static class Environment {
+        public enum SpecialFolder {
+            AdminTools = 48,
+            ApplicationData = 26,
+            CDBurning = 59,
+            CommonAdminTools = 47,
+            CommonApplicationData = 35,
+            CommonDesktopDirectory = 25,
+            CommonDocuments = 46,
+            CommonMusic = 53,
+            CommonOemLinks = 58,
+            CommonPictures = 54,
+            CommonProgramFiles = 43,
+            CommonProgramFilesX86 = 44,
+            CommonPrograms = 23,
+            CommonStartMenu = 22,
+            CommonStartup = 24,
+            CommonTemplates = 45,
+            CommonVideos = 55,
+            Cookies = 33,
+            Desktop = 0,
+            DesktopDirectory = 16,
+            Favorites = 6,
+            Fonts = 20,
+            History = 34,
+            InternetCache = 32,
+            LocalApplicationData = 28,
+            LocalizedResources = 57,
+            MyComputer = 17,
+            MyDocuments = 5,
+            MyMusic = 13,
+            MyPictures = 39,
+            MyVideos = 14,
+            NetworkShortcuts = 19,
+            Personal = 5,
+            PrinterShortcuts = 27,
+            ProgramFiles = 38,
+            ProgramFilesX86 = 42,
+            Programs = 2,
+            Recent = 8,
+            Resources = 56,
+            SendTo = 9,
+            StartMenu = 11,
+            Startup = 7,
+            System = 37,
+            SystemX86 = 41,
+            Templates = 21,
+            UserProfile = 40,
+            Windows = 36,
+        }
+        public enum SpecialFolderOption {
+            Create = 32768,
+            DoNotVerify = 16384,
+            None = 0,
+        }
+        public static string CommandLine { get; }
+        public static string CurrentDirectory { get; set; }
+        public static int ExitCode { get; set; }
+        public static bool Is64BitOperatingSystem { get; }
+        public static bool Is64BitProcess { get; }
+        public static OperatingSystem OSVersion { get; }
+        public static string SystemDirectory { get; }
+        public static int SystemPageSize { get; }
+        public static string UserDomainName { get; }
+        public static bool UserInteractive { get; }
+        public static string UserName { get; }
+        public static Version Version { get; }
+        public static long WorkingSet { get; }
+        public static string GetEnvironmentVariable(string variable, EnvironmentVariableTarget target);
+        public static IDictionary GetEnvironmentVariables(EnvironmentVariableTarget target);
+        public static string GetFolderPath(Environment.SpecialFolder folder);
+        public static string GetFolderPath(Environment.SpecialFolder folder, Environment.SpecialFolderOption option);
+        public static string[] GetLogicalDrives();
+        public static void SetEnvironmentVariable(string variable, string value, EnvironmentVariableTarget target);
     }
+    public enum EnvironmentVariableTarget {
+        Machine = 2,
+        Process = 0,
+        User = 1,
+    }
-    public class Exception {
+    public class Exception : ISerializable {
+        protected Exception(SerializationInfo info, StreamingContext context);
+        public MethodBase TargetSite { get; }
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public new Type GetType();
+        protected event EventHandler<SafeSerializationEventArgs> SerializeObjectState;
     }
+    public sealed class ExecutionEngineException : SystemException {
+        public ExecutionEngineException();
+        public ExecutionEngineException(string message);
+        public ExecutionEngineException(string message, Exception innerException);
+    }
     public class FieldAccessException : MemberAccessException {
+        protected FieldAccessException(SerializationInfo info, StreamingContext context);
     }
+    public class FileStyleUriParser : UriParser {
+        public FileStyleUriParser();
+    }
-    public class FormatException : Exception {
+    public class FormatException : SystemException {
+        protected FormatException(SerializationInfo info, StreamingContext context);
     }
+    public class FtpStyleUriParser : UriParser {
+        public FtpStyleUriParser();
+    }
     public static class GC {
+        public static void CancelFullGCNotification();
+        public static void Collect(int generation, GCCollectionMode mode, bool blocking, bool compacting);
+        public static void EndNoGCRegion();
+        public static int GetGeneration(WeakReference wo);
+        public static void RegisterForFullGCNotification(int maxGenerationThreshold, int largeObjectHeapThreshold);
+        public static bool TryStartNoGCRegion(long totalSize);
+        public static bool TryStartNoGCRegion(long totalSize, bool disallowFullBlockingGC);
+        public static bool TryStartNoGCRegion(long totalSize, long lohSize);
+        public static bool TryStartNoGCRegion(long totalSize, long lohSize, bool disallowFullBlockingGC);
+        public static GCNotificationStatus WaitForFullGCApproach();
+        public static GCNotificationStatus WaitForFullGCApproach(int millisecondsTimeout);
+        public static GCNotificationStatus WaitForFullGCComplete();
+        public static GCNotificationStatus WaitForFullGCComplete(int millisecondsTimeout);
     }
+    public enum GCNotificationStatus {
+        Canceled = 2,
+        Failed = 1,
+        NotApplicable = 4,
+        Succeeded = 0,
+        Timeout = 3,
+    }
+    public class GenericUriParser : UriParser {
+        public GenericUriParser(GenericUriParserOptions options);
+    }
+    public enum GenericUriParserOptions {
+        AllowEmptyAuthority = 2,
+        Default = 0,
+        DontCompressPath = 128,
+        DontConvertPathBackslashes = 64,
+        DontUnescapePathDotsAndSlashes = 256,
+        GenericAuthority = 1,
+        Idn = 512,
+        IriParsing = 1024,
+        NoFragment = 32,
+        NoPort = 8,
+        NoQuery = 16,
+        NoUserInfo = 4,
+    }
+    public class GopherStyleUriParser : UriParser {
+        public GopherStyleUriParser();
+    }
     public struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable {
+        public int CompareTo(object value);
+        public string ToString(string format, IFormatProvider provider);
     }
+    public class HttpStyleUriParser : UriParser {
+        public HttpStyleUriParser();
+    }
+    public interface ICloneable {
+        object Clone();
+    }
-    public sealed class IndexOutOfRangeException : Exception {
+    public sealed class IndexOutOfRangeException : SystemException {
     }
-    public sealed class InsufficientExecutionStackException : Exception {
+    public sealed class InsufficientExecutionStackException : SystemException {
     }
+    public sealed class InsufficientMemoryException : OutOfMemoryException {
+        public InsufficientMemoryException();
+        public InsufficientMemoryException(string message);
+        public InsufficientMemoryException(string message, Exception innerException);
+    }
     public struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
     public struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
     public struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
-    public struct IntPtr {
+    public struct IntPtr : ISerializable {
     }
-    public class InvalidCastException : Exception {
+    public class InvalidCastException : SystemException {
+        protected InvalidCastException(SerializationInfo info, StreamingContext context);
     }
-    public class InvalidOperationException : Exception {
+    public class InvalidOperationException : SystemException {
+        protected InvalidOperationException(SerializationInfo info, StreamingContext context);
     }
-    public sealed class InvalidProgramException : Exception {
+    public sealed class InvalidProgramException : SystemException {
     }
     public class InvalidTimeZoneException : Exception {
+        protected InvalidTimeZoneException(SerializationInfo info, StreamingContext context);
     }
+    public interface IServiceProvider {
+        object GetService(Type serviceType);
+    }
+    public class LdapStyleUriParser : UriParser {
+        public LdapStyleUriParser();
+    }
+    public enum LoaderOptimization {
+        DisallowBindings = 4,
+        DomainMask = 3,
+        MultiDomain = 2,
+        MultiDomainHost = 3,
+        NotSpecified = 0,
+        SingleDomain = 1,
+    }
+    public sealed class LoaderOptimizationAttribute : Attribute {
+        public LoaderOptimizationAttribute(byte value);
+        public LoaderOptimizationAttribute(LoaderOptimization value);
+        public LoaderOptimization Value { get; }
+    }
+    public sealed class LocalDataStoreSlot
+    public abstract class MarshalByRefObject {
+        protected MarshalByRefObject();
+        public object GetLifetimeService();
+        public virtual object InitializeLifetimeService();
+        protected MarshalByRefObject MemberwiseClone(bool cloneIdentity);
+    }
     public static class Math {
+        public static long BigMul(int a, int b);
+        public static int DivRem(int a, int b, out int result);
+        public static long DivRem(long a, long b, out long result);
     }
-    public class MemberAccessException : Exception {
+    public class MemberAccessException : SystemException {
+        protected MemberAccessException(SerializationInfo info, StreamingContext context);
     }
     public class MethodAccessException : MemberAccessException {
+        protected MethodAccessException(SerializationInfo info, StreamingContext context);
     }
-    public class MissingFieldException : MissingMemberException {
+    public class MissingFieldException : MissingMemberException, ISerializable {
+        protected MissingFieldException(SerializationInfo info, StreamingContext context);
+        public MissingFieldException(string className, string fieldName);
     }
-    public class MissingMemberException : MemberAccessException {
+    public class MissingMemberException : MemberAccessException, ISerializable {
+        protected string ClassName;
+        protected string MemberName;
+        protected byte[] Signature;
+        protected MissingMemberException(SerializationInfo info, StreamingContext context);
+        public MissingMemberException(string className, string memberName);
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
-    public class MissingMethodException : MissingMemberException {
+    public class MissingMethodException : MissingMemberException, ISerializable {
+        protected MissingMethodException(SerializationInfo info, StreamingContext context);
+        public MissingMethodException(string className, string methodName);
     }
+    public struct ModuleHandle {
+        public static readonly ModuleHandle EmptyHandle;
+        public int MDStreamVersion { get; }
+        public bool Equals(ModuleHandle handle);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public RuntimeFieldHandle GetRuntimeFieldHandleFromMetadataToken(int fieldToken);
+        public RuntimeMethodHandle GetRuntimeMethodHandleFromMetadataToken(int methodToken);
+        public RuntimeTypeHandle GetRuntimeTypeHandleFromMetadataToken(int typeToken);
+        public static bool operator ==(ModuleHandle left, ModuleHandle right);
+        public static bool operator !=(ModuleHandle left, ModuleHandle right);
+        public RuntimeFieldHandle ResolveFieldHandle(int fieldToken);
+        public RuntimeFieldHandle ResolveFieldHandle(int fieldToken, RuntimeTypeHandle[] typeInstantiationContext, RuntimeTypeHandle[] methodInstantiationContext);
+        public RuntimeMethodHandle ResolveMethodHandle(int methodToken);
+        public RuntimeMethodHandle ResolveMethodHandle(int methodToken, RuntimeTypeHandle[] typeInstantiationContext, RuntimeTypeHandle[] methodInstantiationContext);
+        public RuntimeTypeHandle ResolveTypeHandle(int typeToken);
+        public RuntimeTypeHandle ResolveTypeHandle(int typeToken, RuntimeTypeHandle[] typeInstantiationContext, RuntimeTypeHandle[] methodInstantiationContext);
+    }
     public abstract class MulticastDelegate : Delegate {
+        protected MulticastDelegate(object target, string method);
+        protected MulticastDelegate(Type target, string method);
+        protected sealed override Delegate CombineImpl(Delegate follow);
+        protected override MethodInfo GetMethodImpl();
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        protected sealed override Delegate RemoveImpl(Delegate value);
     }
+    public sealed class MulticastNotSupportedException : SystemException {
+        public MulticastNotSupportedException();
+        public MulticastNotSupportedException(string message);
+        public MulticastNotSupportedException(string message, Exception inner);
+    }
+    public class NetPipeStyleUriParser : UriParser {
+        public NetPipeStyleUriParser();
+    }
+    public class NetTcpStyleUriParser : UriParser {
+        public NetTcpStyleUriParser();
+    }
+    public class NewsStyleUriParser : UriParser {
+        public NewsStyleUriParser();
+    }
+    public sealed class NonSerializedAttribute : Attribute {
+        public NonSerializedAttribute();
+    }
+    public class NotFiniteNumberException : ArithmeticException {
+        public NotFiniteNumberException();
+        public NotFiniteNumberException(double offendingNumber);
+        protected NotFiniteNumberException(SerializationInfo info, StreamingContext context);
+        public NotFiniteNumberException(string message);
+        public NotFiniteNumberException(string message, double offendingNumber);
+        public NotFiniteNumberException(string message, double offendingNumber, Exception innerException);
+        public NotFiniteNumberException(string message, Exception innerException);
+        public double OffendingNumber { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
-    public class NotImplementedException : Exception {
+    public class NotImplementedException : SystemException {
+        protected NotImplementedException(SerializationInfo info, StreamingContext context);
     }
-    public class NotSupportedException : Exception {
+    public class NotSupportedException : SystemException {
+        protected NotSupportedException(SerializationInfo info, StreamingContext context);
     }
-    public class NullReferenceException : Exception {
+    public class NullReferenceException : SystemException {
+        protected NullReferenceException(SerializationInfo info, StreamingContext context);
     }
     public class ObjectDisposedException : InvalidOperationException {
+        protected ObjectDisposedException(SerializationInfo info, StreamingContext context);
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public sealed class OperatingSystem : ICloneable, ISerializable {
+        public OperatingSystem(PlatformID platform, Version version);
+        public PlatformID Platform { get; }
+        public string ServicePack { get; }
+        public Version Version { get; }
+        public string VersionString { get; }
+        public object Clone();
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        public override string ToString();
+    }
-    public class OperationCanceledException : Exception {
+    public class OperationCanceledException : SystemException {
+        protected OperationCanceledException(SerializationInfo info, StreamingContext context);
     }
-    public class OutOfMemoryException : Exception {
+    public class OutOfMemoryException : SystemException {
+        protected OutOfMemoryException(SerializationInfo info, StreamingContext context);
     }
     public class OverflowException : ArithmeticException {
+        protected OverflowException(SerializationInfo info, StreamingContext context);
     }
+    public enum PlatformID {
+        MacOSX = 6,
+        Unix = 4,
+        Win32NT = 2,
+        Win32S = 0,
+        Win32Windows = 1,
+        WinCE = 3,
+        Xbox = 5,
+    }
     public class PlatformNotSupportedException : NotSupportedException {
+        protected PlatformNotSupportedException(SerializationInfo info, StreamingContext context);
     }
-    public class RankException : Exception {
+    public class RankException : SystemException {
+        protected RankException(SerializationInfo info, StreamingContext context);
     }
+    public class ResolveEventArgs : EventArgs {
+        public ResolveEventArgs(string name);
+        public ResolveEventArgs(string name, Assembly requestingAssembly);
+        public string Name { get; }
+        public Assembly RequestingAssembly { get; }
+    }
+    public delegate Assembly ResolveEventHandler(object sender, ResolveEventArgs args); {
+        public ResolveEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ResolveEventArgs args, AsyncCallback callback, object @object);
+        public virtual Assembly EndInvoke(IAsyncResult result);
+        public virtual Assembly Invoke(object sender, ResolveEventArgs args);
+    }
-    public struct RuntimeFieldHandle {
+    public struct RuntimeFieldHandle : ISerializable {
+        public IntPtr Value { get; }
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
     }
-    public struct RuntimeMethodHandle {
+    public struct RuntimeMethodHandle : ISerializable {
+        public IntPtr Value { get; }
+        public IntPtr GetFunctionPointer();
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
     }
-    public struct RuntimeTypeHandle {
+    public struct RuntimeTypeHandle : ISerializable {
+        public IntPtr Value { get; }
+        public ModuleHandle GetModuleHandle();
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable {
+        public int CompareTo(object obj);
+        public TypeCode GetTypeCode();
     }
+    public sealed class SerializableAttribute : Attribute {
+        public SerializableAttribute();
+    }
     public struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
+    public sealed class StackOverflowException : SystemException {
+        public StackOverflowException();
+        public StackOverflowException(string message);
+        public StackOverflowException(string message, Exception innerException);
+    }
-    public sealed class String : IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
+    public sealed class String : ICloneable, IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
+        public unsafe String(sbyte* value);
+        public unsafe String(sbyte* value, int startIndex, int length);
+        public unsafe String(sbyte* value, int startIndex, int length, Encoding enc);
+        public object Clone();
+        public static int Compare(string strA, int indexA, string strB, int indexB, int length, bool ignoreCase);
+        public static int Compare(string strA, int indexA, string strB, int indexB, int length, bool ignoreCase, CultureInfo culture);
+        public static int Compare(string strA, int indexA, string strB, int indexB, int length, CultureInfo culture, CompareOptions options);
+        public static int Compare(string strA, string strB, bool ignoreCase, CultureInfo culture);
+        public static int Compare(string strA, string strB, CultureInfo culture, CompareOptions options);
+        public int CompareTo(object value);
+        public static string Copy(string str);
+        public bool EndsWith(string value, bool ignoreCase, CultureInfo culture);
+        public CharEnumerator GetEnumerator();
+        public TypeCode GetTypeCode();
+        public static string Intern(string str);
+        public static string IsInterned(string str);
+        public bool IsNormalized();
+        public bool IsNormalized(NormalizationForm normalizationForm);
+        public string Normalize();
+        public string Normalize(NormalizationForm normalizationForm);
+        public bool StartsWith(string value, bool ignoreCase, CultureInfo culture);
+        public string ToLower(CultureInfo culture);
+        public string ToString(IFormatProvider provider);
+        public string ToUpper(CultureInfo culture);
     }
     public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
+        public static StringComparer InvariantCulture { get; }
+        public static StringComparer InvariantCultureIgnoreCase { get; }
+        public int Compare(object x, object y);
+        public static StringComparer Create(CultureInfo culture, bool ignoreCase);
+        public new bool Equals(object x, object y);
+        public int GetHashCode(object obj);
     }
     public enum StringComparison {
+        InvariantCulture = 2,
+        InvariantCultureIgnoreCase = 3,
     }
+    public class SystemException : Exception {
+        public SystemException();
+        protected SystemException(SerializationInfo info, StreamingContext context);
+        public SystemException(string message);
+        public SystemException(string message, Exception innerException);
+    }
-    public class TimeoutException : Exception {
+    public class TimeoutException : SystemException {
+        protected TimeoutException(SerializationInfo info, StreamingContext context);
     }
     public struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable {
+        public int CompareTo(object value);
     }
+    public abstract class TimeZone {
+        protected TimeZone();
+        public static TimeZone CurrentTimeZone { get; }
+        public abstract string DaylightName { get; }
+        public abstract string StandardName { get; }
+        public abstract DaylightTime GetDaylightChanges(int year);
+        public abstract TimeSpan GetUtcOffset(DateTime time);
+        public virtual bool IsDaylightSavingTime(DateTime time);
+        public static bool IsDaylightSavingTime(DateTime time, DaylightTime daylightTimes);
+        public virtual DateTime ToLocalTime(DateTime time);
+        public virtual DateTime ToUniversalTime(DateTime time);
+    }
-    public sealed class TimeZoneInfo : IEquatable<TimeZoneInfo> {
+    public sealed class TimeZoneInfo : IDeserializationCallback, IEquatable<TimeZoneInfo>, ISerializable {
+        public sealed class AdjustmentRule : IDeserializationCallback, IEquatable<TimeZoneInfo.AdjustmentRule>, ISerializable {
+            public DateTime DateEnd { get; }
+            public DateTime DateStart { get; }
+            public TimeSpan DaylightDelta { get; }
+            public TimeZoneInfo.TransitionTime DaylightTransitionEnd { get; }
+            public TimeZoneInfo.TransitionTime DaylightTransitionStart { get; }
+            public static TimeZoneInfo.AdjustmentRule CreateAdjustmentRule(DateTime dateStart, DateTime dateEnd, TimeSpan daylightDelta, TimeZoneInfo.TransitionTime daylightTransitionStart, TimeZoneInfo.TransitionTime daylightTransitionEnd);
+            public bool Equals(TimeZoneInfo.AdjustmentRule other);
+            public override int GetHashCode();
+        }
+        public struct TransitionTime : IDeserializationCallback, IEquatable<TimeZoneInfo.TransitionTime>, ISerializable {
+            public int Day { get; }
+            public DayOfWeek DayOfWeek { get; }
+            public bool IsFixedDateRule { get; }
+            public int Month { get; }
+            public DateTime TimeOfDay { get; }
+            public int Week { get; }
+            public static TimeZoneInfo.TransitionTime CreateFixedDateRule(DateTime timeOfDay, int month, int day);
+            public static TimeZoneInfo.TransitionTime CreateFloatingDateRule(DateTime timeOfDay, int month, int week, DayOfWeek dayOfWeek);
+            public override bool Equals(object obj);
+            public bool Equals(TimeZoneInfo.TransitionTime other);
+            public override int GetHashCode();
+            public static bool operator ==(TimeZoneInfo.TransitionTime t1, TimeZoneInfo.TransitionTime t2);
+            public static bool operator !=(TimeZoneInfo.TransitionTime t1, TimeZoneInfo.TransitionTime t2);
+        }
+        public static void ClearCachedData();
+        public static DateTime ConvertTimeBySystemTimeZoneId(DateTime dateTime, string destinationTimeZoneId);
+        public static DateTime ConvertTimeBySystemTimeZoneId(DateTime dateTime, string sourceTimeZoneId, string destinationTimeZoneId);
+        public static DateTimeOffset ConvertTimeBySystemTimeZoneId(DateTimeOffset dateTimeOffset, string destinationTimeZoneId);
+        public static DateTime ConvertTimeFromUtc(DateTime dateTime, TimeZoneInfo destinationTimeZone);
+        public static DateTime ConvertTimeToUtc(DateTime dateTime);
+        public static DateTime ConvertTimeToUtc(DateTime dateTime, TimeZoneInfo sourceTimeZone);
+        public static TimeZoneInfo CreateCustomTimeZone(string id, TimeSpan baseUtcOffset, string displayName, string standardDisplayName);
+        public static TimeZoneInfo CreateCustomTimeZone(string id, TimeSpan baseUtcOffset, string displayName, string standardDisplayName, string daylightDisplayName, TimeZoneInfo.AdjustmentRule[] adjustmentRules);
+        public static TimeZoneInfo CreateCustomTimeZone(string id, TimeSpan baseUtcOffset, string displayName, string standardDisplayName, string daylightDisplayName, TimeZoneInfo.AdjustmentRule[] adjustmentRules, bool disableDaylightSavingTime);
+        public override bool Equals(object obj);
+        public static TimeZoneInfo FromSerializedString(string source);
+        public TimeZoneInfo.AdjustmentRule[] GetAdjustmentRules();
+        public bool HasSameRules(TimeZoneInfo other);
+        public string ToSerializedString();
     }
+    public class TimeZoneNotFoundException : Exception {
+        public TimeZoneNotFoundException();
+        protected TimeZoneNotFoundException(SerializationInfo info, StreamingContext context);
+        public TimeZoneNotFoundException(string message);
+        public TimeZoneNotFoundException(string message, Exception innerException);
+    }
-    public abstract class Type {
+    public abstract class Type : MemberInfo, IReflect {
+        public static readonly MemberFilter FilterAttribute;
+        public static readonly MemberFilter FilterName;
+        public static readonly MemberFilter FilterNameIgnoreCase;
+        protected Type();
+        public abstract Assembly Assembly { get; }
+        public TypeAttributes Attributes { get; }
+        public abstract Type BaseType { get; }
+        public virtual bool ContainsGenericParameters { get; }
+        public virtual MethodBase DeclaringMethod { get; }
-        public abstract Type DeclaringType { get; }
+        public override Type DeclaringType { get; }
+        public static Binder DefaultBinder { get; }
+        public virtual GenericParameterAttributes GenericParameterAttributes { get; }
-        public abstract int GenericParameterPosition { get; }
+        public virtual int GenericParameterPosition { get; }
-        public abstract Type[] GenericTypeArguments { get; }
+        public virtual Type[] GenericTypeArguments { get; }
+        public abstract Guid GUID { get; }
+        public bool IsAbstract { get; }
+        public bool IsAnsiClass { get; }
-        public virtual bool IsArray { get; }
+        public bool IsArray { get; }
+        public bool IsAutoClass { get; }
+        public bool IsAutoLayout { get; }
-        public virtual bool IsByRef { get; }
+        public bool IsByRef { get; }
+        public bool IsClass { get; }
+        public bool IsCOMObject { get; }
-        public abstract bool IsConstructedGenericType { get; }
+        public virtual bool IsConstructedGenericType { get; }
+        public bool IsContextful { get; }
+        public virtual bool IsEnum { get; }
+        public bool IsExplicitLayout { get; }
-        public abstract bool IsGenericParameter { get; }
+        public virtual bool IsGenericParameter { get; }
+        public virtual bool IsGenericType { get; }
+        public virtual bool IsGenericTypeDefinition { get; }
+        public bool IsImport { get; }
+        public bool IsInterface { get; }
+        public bool IsLayoutSequential { get; }
+        public bool IsMarshalByRef { get; }
+        public bool IsNestedAssembly { get; }
+        public bool IsNestedFamANDAssem { get; }
+        public bool IsNestedFamily { get; }
+        public bool IsNestedFamORAssem { get; }
+        public bool IsNestedPrivate { get; }
+        public bool IsNestedPublic { get; }
+        public bool IsNotPublic { get; }
-        public virtual bool IsPointer { get; }
+        public bool IsPointer { get; }
+        public bool IsPrimitive { get; }
+        public bool IsPublic { get; }
+        public bool IsSealed { get; }
+        public virtual bool IsSecurityCritical { get; }
+        public virtual bool IsSecuritySafeCritical { get; }
+        public virtual bool IsSecurityTransparent { get; }
+        public virtual bool IsSerializable { get; }
+        public bool IsSpecialName { get; }
+        public bool IsUnicodeClass { get; }
+        public bool IsValueType { get; }
+        public bool IsVisible { get; }
+        public override MemberTypes MemberType { get; }
+        public abstract new Module Module { get; }
-        public abstract string Name { get; }
+        public override Type ReflectedType { get; }
+        public virtual StructLayoutAttribute StructLayoutAttribute { get; }
+        public ConstructorInfo TypeInitializer { get; }
+        public abstract Type UnderlyingSystemType { get; }
-        public bool Equals(Type o);
+        public virtual bool Equals(Type o);
+        public virtual Type[] FindInterfaces(TypeFilter filter, object filterCriteria);
+        public virtual MemberInfo[] FindMembers(MemberTypes memberType, BindingFlags bindingAttr, MemberFilter filter, object filterCriteria);
-        public abstract int GetArrayRank();
+        public virtual int GetArrayRank();
+        protected abstract TypeAttributes GetAttributeFlagsImpl();
+        public ConstructorInfo GetConstructor(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public ConstructorInfo GetConstructor(BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
+        public ConstructorInfo GetConstructor(Type[] types);
+        protected abstract ConstructorInfo GetConstructorImpl(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public ConstructorInfo[] GetConstructors();
+        public abstract ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
+        public virtual MemberInfo[] GetDefaultMembers();
+        public virtual string GetEnumName(object value);
+        public virtual string[] GetEnumNames();
+        public virtual Type GetEnumUnderlyingType();
+        public virtual Array GetEnumValues();
+        public EventInfo GetEvent(string name);
+        public abstract EventInfo GetEvent(string name, BindingFlags bindingAttr);
+        public virtual EventInfo[] GetEvents();
+        public abstract EventInfo[] GetEvents(BindingFlags bindingAttr);
+        public FieldInfo GetField(string name);
+        public abstract FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public FieldInfo[] GetFields();
+        public abstract FieldInfo[] GetFields(BindingFlags bindingAttr);
+        public virtual Type[] GetGenericArguments();
+        public virtual Type[] GetGenericParameterConstraints();
-        public abstract Type GetGenericTypeDefinition();
+        public virtual Type GetGenericTypeDefinition();
+        public Type GetInterface(string name);
+        public abstract Type GetInterface(string name, bool ignoreCase);
+        public virtual InterfaceMapping GetInterfaceMap(Type interfaceType);
+        public abstract Type[] GetInterfaces();
+        public MemberInfo[] GetMember(string name);
+        public virtual MemberInfo[] GetMember(string name, BindingFlags bindingAttr);
+        public virtual MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
+        public MemberInfo[] GetMembers();
+        public abstract MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        public MethodInfo GetMethod(string name);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo GetMethod(string name, Type[] types);
+        public MethodInfo GetMethod(string name, Type[] types, ParameterModifier[] modifiers);
+        protected abstract MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo[] GetMethods();
+        public abstract MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        public Type GetNestedType(string name);
+        public abstract Type GetNestedType(string name, BindingFlags bindingAttr);
+        public Type[] GetNestedTypes();
+        public abstract Type[] GetNestedTypes(BindingFlags bindingAttr);
+        public PropertyInfo[] GetProperties();
+        public abstract PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        public PropertyInfo GetProperty(string name);
+        public PropertyInfo GetProperty(string name, BindingFlags bindingAttr);
+        public PropertyInfo GetProperty(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        public PropertyInfo GetProperty(string name, Type returnType);
+        public PropertyInfo GetProperty(string name, Type returnType, Type[] types);
+        public PropertyInfo GetProperty(string name, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        public PropertyInfo GetProperty(string name, Type[] types);
+        protected abstract PropertyInfo GetPropertyImpl(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        public new Type GetType();
+        public static Type GetType(string typeName, Func<AssemblyName, Assembly> assemblyResolver, Func<Assembly, string, bool, Type> typeResolver);
+        public static Type GetType(string typeName, Func<AssemblyName, Assembly> assemblyResolver, Func<Assembly, string, bool, Type> typeResolver, bool throwOnError);
+        public static Type GetType(string typeName, Func<AssemblyName, Assembly> assemblyResolver, Func<Assembly, string, bool, Type> typeResolver, bool throwOnError, bool ignoreCase);
+        public static Type[] GetTypeArray(object[] args);
+        protected virtual TypeCode GetTypeCodeImpl();
+        public static Type GetTypeFromCLSID(Guid clsid);
+        public static Type GetTypeFromCLSID(Guid clsid, bool throwOnError);
+        public static Type GetTypeFromCLSID(Guid clsid, string server);
+        public static Type GetTypeFromCLSID(Guid clsid, string server, bool throwOnError);
+        public static Type GetTypeFromProgID(string progID);
+        public static Type GetTypeFromProgID(string progID, bool throwOnError);
+        public static Type GetTypeFromProgID(string progID, string server);
+        public static Type GetTypeFromProgID(string progID, string server, bool throwOnError);
+        public static RuntimeTypeHandle GetTypeHandle(object o);
+        protected abstract bool HasElementTypeImpl();
+        public object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args);
+        public object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, CultureInfo culture);
+        public abstract object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
+        protected abstract bool IsArrayImpl();
+        public virtual bool IsAssignableFrom(Type c);
+        protected abstract bool IsByRefImpl();
+        protected abstract bool IsCOMObjectImpl();
+        protected virtual bool IsContextfulImpl();
+        public virtual bool IsEnumDefined(object value);
+        public virtual bool IsEquivalentTo(Type other);
+        public virtual bool IsInstanceOfType(object o);
+        protected virtual bool IsMarshalByRefImpl();
+        protected abstract bool IsPointerImpl();
+        protected abstract bool IsPrimitiveImpl();
+        public virtual bool IsSubclassOf(Type c);
+        protected virtual bool IsValueTypeImpl();
-        public abstract Type MakeArrayType();
+        public virtual Type MakeArrayType();
-        public abstract Type MakeArrayType(int rank);
+        public virtual Type MakeArrayType(int rank);
-        public abstract Type MakeByRefType();
+        public virtual Type MakeByRefType();
-        public abstract Type MakeGenericType(params Type[] typeArguments);
+        public virtual Type MakeGenericType(params Type[] typeArguments);
-        public abstract Type MakePointerType();
+        public virtual Type MakePointerType();
+        public static bool operator ==(Type left, Type right);
+        public static bool operator !=(Type left, Type right);
+        public static Type ReflectionOnlyGetType(string typeName, bool throwIfNotFound, bool ignoreCase);
     }
     public class TypeAccessException : TypeLoadException {
+        protected TypeAccessException(SerializationInfo info, StreamingContext context);
     }
     public enum TypeCode {
+        DBNull = 2,
     }
-    public sealed class TypeInitializationException : Exception {
+    public sealed class TypeInitializationException : SystemException {
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
-    public class TypeLoadException : Exception {
+    public class TypeLoadException : SystemException, ISerializable {
+        protected TypeLoadException(SerializationInfo info, StreamingContext context);
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public class TypeUnloadedException : SystemException {
+        public TypeUnloadedException();
+        protected TypeUnloadedException(SerializationInfo info, StreamingContext context);
+        public TypeUnloadedException(string message);
+        public TypeUnloadedException(string message, Exception innerException);
+    }
     public struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
     public struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
     public struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable {
+        public int CompareTo(object value);
+        public TypeCode GetTypeCode();
     }
-    public struct UIntPtr {
+    public struct UIntPtr : ISerializable {
     }
-    public class UnauthorizedAccessException : Exception {
+    public class UnauthorizedAccessException : SystemException {
+        protected UnauthorizedAccessException(SerializationInfo info, StreamingContext context);
     }
+    public class UnhandledExceptionEventArgs : EventArgs {
+        public UnhandledExceptionEventArgs(object exception, bool isTerminating);
+        public object ExceptionObject { get; }
+        public bool IsTerminating { get; }
+    }
+    public delegate void UnhandledExceptionEventHandler(object sender, UnhandledExceptionEventArgs e); {
+        public UnhandledExceptionEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, UnhandledExceptionEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, UnhandledExceptionEventArgs e);
+    }
-    public class Uri {
+    public class Uri : ISerializable {
+        public static readonly string SchemeDelimiter;
+        public static readonly string UriSchemeFile;
+        public static readonly string UriSchemeFtp;
+        public static readonly string UriSchemeGopher;
+        public static readonly string UriSchemeHttp;
+        public static readonly string UriSchemeHttps;
+        public static readonly string UriSchemeMailto;
+        public static readonly string UriSchemeNetPipe;
+        public static readonly string UriSchemeNetTcp;
+        public static readonly string UriSchemeNews;
+        public static readonly string UriSchemeNntp;
+        protected Uri(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public Uri(string uriString, bool dontEscape);
+        public Uri(Uri baseUri, string relativeUri, bool dontEscape);
+        protected virtual void Canonicalize();
+        protected virtual void CheckSecurity();
+        protected virtual void Escape();
+        protected static string EscapeString(string str);
+        public static int FromHex(char digit);
+        public string GetLeftPart(UriPartial part);
+        protected void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public static string HexEscape(char character);
+        public static char HexUnescape(string pattern, ref int index);
+        protected virtual bool IsBadFileSystemCharacter(char character);
+        protected static bool IsExcludedCharacter(char character);
+        public static bool IsHexDigit(char character);
+        public static bool IsHexEncoding(string pattern, int index);
+        protected virtual bool IsReservedCharacter(char character);
+        public string MakeRelative(Uri toUri);
+        protected virtual void Parse();
+        protected virtual string Unescape(string path);
     }
-    public class UriFormatException : FormatException {
+    public class UriFormatException : FormatException, ISerializable {
+        protected UriFormatException(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
+    public abstract class UriParser {
+        protected UriParser();
+        protected virtual string GetComponents(Uri uri, UriComponents components, UriFormat format);
+        protected virtual void InitializeAndValidate(Uri uri, out UriFormatException parsingError);
+        protected virtual bool IsBaseOf(Uri baseUri, Uri relativeUri);
+        public static bool IsKnownScheme(string schemeName);
+        protected virtual bool IsWellFormedOriginalString(Uri uri);
+        protected virtual UriParser OnNewUri();
+        protected virtual void OnRegister(string schemeName, int defaultPort);
+        public static void Register(UriParser uriParser, string schemeName, int defaultPort);
+        protected virtual string Resolve(Uri baseUri, Uri relativeUri, out UriFormatException parsingError);
+    }
+    public enum UriPartial {
+        Authority = 1,
+        Path = 2,
+        Query = 3,
+        Scheme = 0,
+    }
+    public class UriTypeConverter : TypeConverter {
+        public UriTypeConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override bool IsValid(ITypeDescriptorContext context, object value);
+    }
-    public sealed class Version : IComparable, IComparable<Version>, IEquatable<Version> {
+    public sealed class Version : ICloneable, IComparable, IComparable<Version>, IEquatable<Version> {
+        public Version();
+        public object Clone();
+        public int CompareTo(object version);
     }
-    public class WeakReference {
+    public class WeakReference : ISerializable {
+        protected WeakReference(SerializationInfo info, StreamingContext context);
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
     }
-    public sealed class WeakReference<T> where T : class {
+    public sealed class WeakReference<T> : ISerializable where T : class {
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
     }
 }
 namespace System.CodeDom.Compiler {
+    public class IndentedTextWriter : TextWriter {
+        public const string DefaultTabString = "    ";
+        public IndentedTextWriter(TextWriter writer);
+        public IndentedTextWriter(TextWriter writer, string tabString);
+        public override Encoding Encoding { get; }
+        public int Indent { get; set; }
+        public TextWriter InnerWriter { get; }
+        public override string NewLine { get; set; }
+        public override void Close();
+        public override void Flush();
+        protected virtual void OutputTabs();
+        public override void Write(bool value);
+        public override void Write(char value);
+        public override void Write(char[] buffer);
+        public override void Write(char[] buffer, int index, int count);
+        public override void Write(double value);
+        public override void Write(int value);
+        public override void Write(long value);
+        public override void Write(object value);
+        public override void Write(float value);
+        public override void Write(string s);
+        public override void Write(string format, object arg0);
+        public override void Write(string format, object arg0, object arg1);
+        public override void Write(string format, params object[] arg);
+        public override void WriteLine();
+        public override void WriteLine(bool value);
+        public override void WriteLine(char value);
+        public override void WriteLine(char[] buffer);
+        public override void WriteLine(char[] buffer, int index, int count);
+        public override void WriteLine(double value);
+        public override void WriteLine(int value);
+        public override void WriteLine(long value);
+        public override void WriteLine(object value);
+        public override void WriteLine(float value);
+        public override void WriteLine(string s);
+        public override void WriteLine(string format, object arg0);
+        public override void WriteLine(string format, object arg0, object arg1);
+        public override void WriteLine(string format, params object[] arg);
+        public override void WriteLine(uint value);
+        public void WriteLineNoTabs(string s);
+    }
 }
 namespace System.Collections {
+    public class ArrayList : ICloneable, ICollection, IEnumerable, IList {
+        public ArrayList();
+        public ArrayList(ICollection c);
+        public ArrayList(int capacity);
+        public virtual int Capacity { get; set; }
+        public virtual int Count { get; }
+        public virtual bool IsFixedSize { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual object this[int index] { get; set; }
+        public virtual object SyncRoot { get; }
+        public static ArrayList Adapter(IList list);
+        public virtual int Add(object value);
+        public virtual void AddRange(ICollection c);
+        public virtual int BinarySearch(int index, int count, object value, IComparer comparer);
+        public virtual int BinarySearch(object value);
+        public virtual int BinarySearch(object value, IComparer comparer);
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object item);
+        public virtual void CopyTo(Array array);
+        public virtual void CopyTo(Array array, int arrayIndex);
+        public virtual void CopyTo(int index, Array array, int arrayIndex, int count);
+        public static ArrayList FixedSize(ArrayList list);
+        public static IList FixedSize(IList list);
+        public virtual IEnumerator GetEnumerator();
+        public virtual IEnumerator GetEnumerator(int index, int count);
+        public virtual ArrayList GetRange(int index, int count);
+        public virtual int IndexOf(object value);
+        public virtual int IndexOf(object value, int startIndex);
+        public virtual int IndexOf(object value, int startIndex, int count);
+        public virtual void Insert(int index, object value);
+        public virtual void InsertRange(int index, ICollection c);
+        public virtual int LastIndexOf(object value);
+        public virtual int LastIndexOf(object value, int startIndex);
+        public virtual int LastIndexOf(object value, int startIndex, int count);
+        public static ArrayList ReadOnly(ArrayList list);
+        public static IList ReadOnly(IList list);
+        public virtual void Remove(object obj);
+        public virtual void RemoveAt(int index);
+        public virtual void RemoveRange(int index, int count);
+        public static ArrayList Repeat(object value, int count);
+        public virtual void Reverse();
+        public virtual void Reverse(int index, int count);
+        public virtual void SetRange(int index, ICollection c);
+        public virtual void Sort();
+        public virtual void Sort(IComparer comparer);
+        public virtual void Sort(int index, int count, IComparer comparer);
+        public static ArrayList Synchronized(ArrayList list);
+        public static IList Synchronized(IList list);
+        public virtual object[] ToArray();
+        public virtual Array ToArray(Type type);
+        public virtual void TrimToSize();
+    }
-    public sealed class BitArray : ICollection, IEnumerable {
+    public sealed class BitArray : ICloneable, ICollection, IEnumerable {
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public object Clone();
+        public void CopyTo(Array array, int index);
     }
+    public class CaseInsensitiveComparer : IComparer {
+        public CaseInsensitiveComparer();
+        public CaseInsensitiveComparer(CultureInfo culture);
+        public static CaseInsensitiveComparer Default { get; }
+        public static CaseInsensitiveComparer DefaultInvariant { get; }
+        public int Compare(object a, object b);
+    }
+    public class CaseInsensitiveHashCodeProvider : IHashCodeProvider {
+        public CaseInsensitiveHashCodeProvider();
+        public CaseInsensitiveHashCodeProvider(CultureInfo culture);
+        public static CaseInsensitiveHashCodeProvider Default { get; }
+        public static CaseInsensitiveHashCodeProvider DefaultInvariant { get; }
+        public int GetHashCode(object obj);
+    }
+    public abstract class CollectionBase : ICollection, IEnumerable, IList {
+        protected CollectionBase();
+        protected CollectionBase(int capacity);
+        public int Capacity { get; set; }
+        public int Count { get; }
+        protected ArrayList InnerList { get; }
+        protected IList List { get; }
+        public void Clear();
+        public IEnumerator GetEnumerator();
+        protected virtual void OnClear();
+        protected virtual void OnClearComplete();
+        protected virtual void OnInsert(int index, object value);
+        protected virtual void OnInsertComplete(int index, object value);
+        protected virtual void OnRemove(int index, object value);
+        protected virtual void OnRemoveComplete(int index, object value);
+        protected virtual void OnSet(int index, object oldValue, object newValue);
+        protected virtual void OnSetComplete(int index, object oldValue, object newValue);
+        protected virtual void OnValidate(object value);
+        public void RemoveAt(int index);
+    }
+    public sealed class Comparer : IComparer, ISerializable {
+        public static readonly Comparer Default;
+        public static readonly Comparer DefaultInvariant;
+        public Comparer(CultureInfo culture);
+        public int Compare(object a, object b);
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public abstract class DictionaryBase : ICollection, IDictionary, IEnumerable {
+        protected DictionaryBase();
+        public int Count { get; }
+        protected IDictionary Dictionary { get; }
+        protected Hashtable InnerHashtable { get; }
+        public void Clear();
+        public void CopyTo(Array array, int index);
+        public IDictionaryEnumerator GetEnumerator();
+        protected virtual void OnClear();
+        protected virtual void OnClearComplete();
+        protected virtual object OnGet(object key, object currentValue);
+        protected virtual void OnInsert(object key, object value);
+        protected virtual void OnInsertComplete(object key, object value);
+        protected virtual void OnRemove(object key, object value);
+        protected virtual void OnRemoveComplete(object key, object value);
+        protected virtual void OnSet(object key, object oldValue, object newValue);
+        protected virtual void OnSetComplete(object key, object oldValue, object newValue);
+        protected virtual void OnValidate(object key, object value);
+    }
+    public class Hashtable : ICloneable, ICollection, IDeserializationCallback, IDictionary, IEnumerable, ISerializable {
+        public Hashtable();
+        public Hashtable(IDictionary d);
+        public Hashtable(IDictionary d, IEqualityComparer equalityComparer);
+        public Hashtable(IDictionary d, IHashCodeProvider hcp, IComparer comparer);
+        public Hashtable(IDictionary d, float loadFactor);
+        public Hashtable(IDictionary d, float loadFactor, IEqualityComparer equalityComparer);
+        public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, IComparer comparer);
+        public Hashtable(IEqualityComparer equalityComparer);
+        public Hashtable(IHashCodeProvider hcp, IComparer comparer);
+        public Hashtable(int capacity);
+        public Hashtable(int capacity, IEqualityComparer equalityComparer);
+        public Hashtable(int capacity, IHashCodeProvider hcp, IComparer comparer);
+        public Hashtable(int capacity, float loadFactor);
+        public Hashtable(int capacity, float loadFactor, IEqualityComparer equalityComparer);
+        public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, IComparer comparer);
+        protected Hashtable(SerializationInfo info, StreamingContext context);
+        protected IComparer comparer { get; set; }
+        public virtual int Count { get; }
+        protected IEqualityComparer EqualityComparer { get; }
+        protected IHashCodeProvider hcp { get; set; }
+        public virtual bool IsFixedSize { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual object this[object key] { get; set; }
+        public virtual ICollection Keys { get; }
+        public virtual object SyncRoot { get; }
+        public virtual ICollection Values { get; }
+        public virtual void Add(object key, object value);
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object key);
+        public virtual bool ContainsKey(object key);
+        public virtual bool ContainsValue(object value);
+        public virtual void CopyTo(Array array, int arrayIndex);
+        public virtual IDictionaryEnumerator GetEnumerator();
+        protected virtual int GetHash(object key);
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        protected virtual bool KeyEquals(object item, object key);
+        public virtual void OnDeserialization(object sender);
+        public virtual void Remove(object key);
+        public static Hashtable Synchronized(Hashtable table);
+    }
+    public interface IHashCodeProvider {
+        int GetHashCode(object obj);
+    }
+    public class Queue : ICloneable, ICollection, IEnumerable {
+        public Queue();
+        public Queue(ICollection col);
+        public Queue(int capacity);
+        public Queue(int capacity, float growFactor);
+        public virtual int Count { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual object SyncRoot { get; }
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object obj);
+        public virtual void CopyTo(Array array, int index);
+        public virtual object Dequeue();
+        public virtual void Enqueue(object obj);
+        public virtual IEnumerator GetEnumerator();
+        public virtual object Peek();
+        public static Queue Synchronized(Queue queue);
+        public virtual object[] ToArray();
+        public virtual void TrimToSize();
+    }
+    public abstract class ReadOnlyCollectionBase : ICollection, IEnumerable {
+        protected ReadOnlyCollectionBase();
+        public virtual int Count { get; }
+        protected ArrayList InnerList { get; }
+        public virtual IEnumerator GetEnumerator();
+    }
+    public class SortedList : ICloneable, ICollection, IDictionary, IEnumerable {
+        public SortedList();
+        public SortedList(IComparer comparer);
+        public SortedList(IComparer comparer, int capacity);
+        public SortedList(IDictionary d);
+        public SortedList(IDictionary d, IComparer comparer);
+        public SortedList(int initialCapacity);
+        public virtual int Capacity { get; set; }
+        public virtual int Count { get; }
+        public virtual bool IsFixedSize { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual object this[object key] { get; set; }
+        public virtual ICollection Keys { get; }
+        public virtual object SyncRoot { get; }
+        public virtual ICollection Values { get; }
+        public virtual void Add(object key, object value);
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object key);
+        public virtual bool ContainsKey(object key);
+        public virtual bool ContainsValue(object value);
+        public virtual void CopyTo(Array array, int arrayIndex);
+        public virtual object GetByIndex(int index);
+        public virtual IDictionaryEnumerator GetEnumerator();
+        public virtual object GetKey(int index);
+        public virtual IList GetKeyList();
+        public virtual IList GetValueList();
+        public virtual int IndexOfKey(object key);
+        public virtual int IndexOfValue(object value);
+        public virtual void Remove(object key);
+        public virtual void RemoveAt(int index);
+        public virtual void SetByIndex(int index, object value);
+        public static SortedList Synchronized(SortedList list);
+        public virtual void TrimToSize();
+    }
+    public class Stack : ICloneable, ICollection, IEnumerable {
+        public Stack();
+        public Stack(ICollection col);
+        public Stack(int initialCapacity);
+        public virtual int Count { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual object SyncRoot { get; }
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object obj);
+        public virtual void CopyTo(Array array, int index);
+        public virtual IEnumerator GetEnumerator();
+        public virtual object Peek();
+        public virtual object Pop();
+        public virtual void Push(object obj);
+        public static Stack Synchronized(Stack stack);
+        public virtual object[] ToArray();
+    }
 }
 namespace System.Collections.Generic {
-    public class Dictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
+    public class Dictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDeserializationCallback, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue>, ISerializable {
+        protected Dictionary(SerializationInfo info, StreamingContext context);
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public virtual void OnDeserialization(object sender);
     }
-    public class HashSet<T> : ICollection<T>, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISet<T> {
+    public class HashSet<T> : ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISerializable, ISet<T> {
+        protected HashSet(SerializationInfo info, StreamingContext context);
+        public static IEqualityComparer<HashSet<T>> CreateSetComparer();
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public virtual void OnDeserialization(object sender);
     }
-    public class KeyNotFoundException : Exception {
+    public class KeyNotFoundException : SystemException, ISerializable {
+        protected KeyNotFoundException(SerializationInfo info, StreamingContext context);
     }
-    public class LinkedList<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
+    public class LinkedList<T> : ICollection, ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISerializable {
-        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T> {
+        public struct Enumerator : IDeserializationCallback, IDisposable, IEnumerator, IEnumerator<T>, ISerializable {
         }
+        protected LinkedList(SerializationInfo info, StreamingContext context);
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public virtual void OnDeserialization(object sender);
     }
     public class List<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+        public List<TOutput> ConvertAll<TOutput>(Converter<T, TOutput> converter);
     }
-    public class SortedSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISet<T> {
+    public class SortedSet<T> : ICollection, ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISerializable, ISet<T> {
-        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T> {
+        public struct Enumerator : IDeserializationCallback, IDisposable, IEnumerator, IEnumerator<T>, ISerializable {
         }
+        protected SortedSet(SerializationInfo info, StreamingContext context);
+        public static IEqualityComparer<SortedSet<T>> CreateSetComparer();
+        public static IEqualityComparer<SortedSet<T>> CreateSetComparer(IEqualityComparer<T> memberEqualityComparer);
+        protected virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        protected virtual void OnDeserialization(object sender);
     }
 }
 namespace System.Collections.ObjectModel {
     public class ObservableCollection<T> : Collection<T>, INotifyCollectionChanged, INotifyPropertyChanged {
+        public ObservableCollection(List<T> list);
     }
 }
 namespace System.Collections.Specialized {
+    public struct BitVector32 {
+        public struct Section {
+            public short Mask { get; }
+            public short Offset { get; }
+            public override bool Equals(object o);
+            public bool Equals(BitVector32.Section obj);
+            public override int GetHashCode();
+            public static bool operator ==(BitVector32.Section a, BitVector32.Section b);
+            public static bool operator !=(BitVector32.Section a, BitVector32.Section b);
+            public override string ToString();
+            public static string ToString(BitVector32.Section value);
+        }
+        public BitVector32(BitVector32 value);
+        public BitVector32(int data);
+        public int Data { get; }
+        public bool this[int bit] { get; set; }
+        public int this[BitVector32.Section section] { get; set; }
+        public static int CreateMask();
+        public static int CreateMask(int previous);
+        public static BitVector32.Section CreateSection(short maxValue);
+        public static BitVector32.Section CreateSection(short maxValue, BitVector32.Section previous);
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public override string ToString();
+        public static string ToString(BitVector32 value);
+    }
+    public class CollectionsUtil {
+        public CollectionsUtil();
+        public static Hashtable CreateCaseInsensitiveHashtable();
+        public static Hashtable CreateCaseInsensitiveHashtable(IDictionary d);
+        public static Hashtable CreateCaseInsensitiveHashtable(int capacity);
+        public static SortedList CreateCaseInsensitiveSortedList();
+    }
+    public class HybridDictionary : ICollection, IDictionary, IEnumerable {
+        public HybridDictionary();
+        public HybridDictionary(bool caseInsensitive);
+        public HybridDictionary(int initialSize);
+        public HybridDictionary(int initialSize, bool caseInsensitive);
+        public int Count { get; }
+        public bool IsFixedSize { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object this[object key] { get; set; }
+        public ICollection Keys { get; }
+        public object SyncRoot { get; }
+        public ICollection Values { get; }
+        public void Add(object key, object value);
+        public void Clear();
+        public bool Contains(object key);
+        public void CopyTo(Array array, int index);
+        public IDictionaryEnumerator GetEnumerator();
+        public void Remove(object key);
+    }
+    public interface IOrderedDictionary : ICollection, IDictionary, IEnumerable {
+        object this[int index] { get; set; }
+        new IDictionaryEnumerator GetEnumerator();
+        void Insert(int index, object key, object value);
+        void RemoveAt(int index);
+    }
+    public class ListDictionary : ICollection, IDictionary, IEnumerable {
+        public ListDictionary();
+        public ListDictionary(IComparer comparer);
+        public int Count { get; }
+        public bool IsFixedSize { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object this[object key] { get; set; }
+        public ICollection Keys { get; }
+        public object SyncRoot { get; }
+        public ICollection Values { get; }
+        public void Add(object key, object value);
+        public void Clear();
+        public bool Contains(object key);
+        public void CopyTo(Array array, int index);
+        public IDictionaryEnumerator GetEnumerator();
+        public void Remove(object key);
+    }
+    public abstract class NameObjectCollectionBase : ICollection, IDeserializationCallback, IEnumerable, ISerializable {
+        public class KeysCollection : ICollection, IEnumerable {
+            public int Count { get; }
+            public string this[int index] { get; }
+            public virtual string Get(int index);
+            public IEnumerator GetEnumerator();
+        }
+        protected NameObjectCollectionBase();
+        protected NameObjectCollectionBase(IEqualityComparer equalityComparer);
+        protected NameObjectCollectionBase(IHashCodeProvider hashProvider, IComparer comparer);
+        protected NameObjectCollectionBase(int capacity);
+        protected NameObjectCollectionBase(int capacity, IEqualityComparer equalityComparer);
+        protected NameObjectCollectionBase(int capacity, IHashCodeProvider hashProvider, IComparer comparer);
+        protected NameObjectCollectionBase(SerializationInfo info, StreamingContext context);
+        public virtual int Count { get; }
+        protected bool IsReadOnly { get; set; }
+        public virtual NameObjectCollectionBase.KeysCollection Keys { get; }
+        protected void BaseAdd(string name, object value);
+        protected void BaseClear();
+        protected object BaseGet(int index);
+        protected object BaseGet(string name);
+        protected string[] BaseGetAllKeys();
+        protected object[] BaseGetAllValues();
+        protected object[] BaseGetAllValues(Type type);
+        protected string BaseGetKey(int index);
+        protected bool BaseHasKeys();
+        protected void BaseRemove(string name);
+        protected void BaseRemoveAt(int index);
+        protected void BaseSet(int index, object value);
+        protected void BaseSet(string name, object value);
+        public virtual IEnumerator GetEnumerator();
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public virtual void OnDeserialization(object sender);
+    }
+    public class NameValueCollection : NameObjectCollectionBase {
+        public NameValueCollection();
+        public NameValueCollection(IEqualityComparer equalityComparer);
+        public NameValueCollection(IHashCodeProvider hashProvider, IComparer comparer);
+        public NameValueCollection(int capacity);
+        public NameValueCollection(int capacity, IEqualityComparer equalityComparer);
+        public NameValueCollection(int capacity, IHashCodeProvider hashProvider, IComparer comparer);
+        public NameValueCollection(int capacity, NameValueCollection col);
+        public NameValueCollection(NameValueCollection col);
+        protected NameValueCollection(SerializationInfo info, StreamingContext context);
+        public virtual string[] AllKeys { get; }
+        public string this[int index] { get; }
+        public string this[string name] { get; set; }
+        public void Add(NameValueCollection c);
+        public virtual void Add(string name, string value);
+        public virtual void Clear();
+        public void CopyTo(Array dest, int index);
+        public virtual string Get(int index);
+        public virtual string Get(string name);
+        public virtual string GetKey(int index);
+        public virtual string[] GetValues(int index);
+        public virtual string[] GetValues(string name);
+        public bool HasKeys();
+        protected void InvalidateCachedArrays();
+        public virtual void Remove(string name);
+        public virtual void Set(string name, string value);
+    }
+    public class OrderedDictionary : ICollection, IDeserializationCallback, IDictionary, IEnumerable, IOrderedDictionary, ISerializable {
+        public OrderedDictionary();
+        public OrderedDictionary(IEqualityComparer comparer);
+        public OrderedDictionary(int capacity);
+        public OrderedDictionary(int capacity, IEqualityComparer comparer);
+        protected OrderedDictionary(SerializationInfo info, StreamingContext context);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public object this[int index] { get; set; }
+        public object this[object key] { get; set; }
+        public ICollection Keys { get; }
+        public ICollection Values { get; }
+        public void Add(object key, object value);
+        public OrderedDictionary AsReadOnly();
+        public void Clear();
+        public bool Contains(object key);
+        public void CopyTo(Array array, int index);
+        public virtual IDictionaryEnumerator GetEnumerator();
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public void Insert(int index, object key, object value);
+        protected virtual void OnDeserialization(object sender);
+        public void Remove(object key);
+        public void RemoveAt(int index);
+    }
+    public class StringCollection : ICollection, IEnumerable, IList {
+        public StringCollection();
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public string this[int index] { get; set; }
+        public object SyncRoot { get; }
+        public int Add(string value);
+        public void AddRange(string[] value);
+        public void Clear();
+        public bool Contains(string value);
+        public void CopyTo(string[] array, int index);
+        public StringEnumerator GetEnumerator();
+        public int IndexOf(string value);
+        public void Insert(int index, string value);
+        public void Remove(string value);
+        public void RemoveAt(int index);
+    }
+    public class StringDictionary : IEnumerable {
+        public StringDictionary();
+        public virtual int Count { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual string this[string key] { get; set; }
+        public virtual ICollection Keys { get; }
+        public virtual object SyncRoot { get; }
+        public virtual ICollection Values { get; }
+        public virtual void Add(string key, string value);
+        public virtual void Clear();
+        public virtual bool ContainsKey(string key);
+        public virtual bool ContainsValue(string value);
+        public virtual void CopyTo(Array array, int index);
+        public virtual IEnumerator GetEnumerator();
+        public virtual void Remove(string key);
+    }
+    public class StringEnumerator {
+        public string Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
 }
 namespace System.ComponentModel {
+    public class AddingNewEventArgs : EventArgs {
+        public AddingNewEventArgs();
+        public AddingNewEventArgs(object newObject);
+        public object NewObject { get; set; }
+    }
+    public delegate void AddingNewEventHandler(object sender, AddingNewEventArgs e); {
+        public AddingNewEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, AddingNewEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, AddingNewEventArgs e);
+    }
+    public sealed class AmbientValueAttribute : Attribute {
+        public AmbientValueAttribute(bool value);
+        public AmbientValueAttribute(byte value);
+        public AmbientValueAttribute(char value);
+        public AmbientValueAttribute(double value);
+        public AmbientValueAttribute(short value);
+        public AmbientValueAttribute(int value);
+        public AmbientValueAttribute(long value);
+        public AmbientValueAttribute(object value);
+        public AmbientValueAttribute(float value);
+        public AmbientValueAttribute(string value);
+        public AmbientValueAttribute(Type type, string value);
+        public object Value { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public class ArrayConverter : CollectionConverter {
+        public ArrayConverter();
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
+    }
+    public class AsyncCompletedEventArgs : EventArgs {
+        public AsyncCompletedEventArgs(Exception error, bool cancelled, object userState);
+        public bool Cancelled { get; }
+        public Exception Error { get; }
+        public object UserState { get; }
+        protected void RaiseExceptionIfNecessary();
+    }
+    public delegate void AsyncCompletedEventHandler(object sender, AsyncCompletedEventArgs e); {
+        public AsyncCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, AsyncCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, AsyncCompletedEventArgs e);
+    }
+    public sealed class AsyncOperation {
+        public SynchronizationContext SynchronizationContext { get; }
+        public object UserSuppliedState { get; }
+        public void OperationCompleted();
+        public void Post(SendOrPostCallback d, object arg);
+        public void PostOperationCompleted(SendOrPostCallback d, object arg);
+    }
+    public static class AsyncOperationManager {
+        public static SynchronizationContext SynchronizationContext { get; set; }
+        public static AsyncOperation CreateOperation(object userSuppliedState);
+    }
+    public class AttributeCollection : ICollection, IEnumerable {
+        public static readonly AttributeCollection Empty;
+        protected AttributeCollection();
+        public AttributeCollection(params Attribute[] attributes);
+        protected virtual Attribute[] Attributes { get; }
+        public int Count { get; }
+        public virtual Attribute this[int index] { get; }
+        public virtual Attribute this[Type attributeType] { get; }
+        public bool Contains(Attribute attribute);
+        public bool Contains(Attribute[] attributes);
+        public void CopyTo(Array array, int index);
+        public static AttributeCollection FromExisting(AttributeCollection existing, params Attribute[] newAttributes);
+        protected Attribute GetDefaultAttribute(Type attributeType);
+        public IEnumerator GetEnumerator();
+        public bool Matches(Attribute attribute);
+        public bool Matches(Attribute[] attributes);
+    }
+    public class AttributeProviderAttribute : Attribute {
+        public AttributeProviderAttribute(string typeName);
+        public AttributeProviderAttribute(string typeName, string propertyName);
+        public AttributeProviderAttribute(Type type);
+        public string PropertyName { get; }
+        public string TypeName { get; }
+    }
+    public class BackgroundWorker : Component {
+        public BackgroundWorker();
+        public bool CancellationPending { get; }
+        public bool IsBusy { get; }
+        public bool WorkerReportsProgress { get; set; }
+        public bool WorkerSupportsCancellation { get; set; }
+        public void CancelAsync();
+        protected virtual void OnDoWork(DoWorkEventArgs e);
+        protected virtual void OnProgressChanged(ProgressChangedEventArgs e);
+        protected virtual void OnRunWorkerCompleted(RunWorkerCompletedEventArgs e);
+        public void ReportProgress(int percentProgress);
+        public void ReportProgress(int percentProgress, object userState);
+        public void RunWorkerAsync();
+        public void RunWorkerAsync(object argument);
+        public event DoWorkEventHandler DoWork;
+        public event ProgressChangedEventHandler ProgressChanged;
+        public event RunWorkerCompletedEventHandler RunWorkerCompleted;
+    }
+    public abstract class BaseNumberConverter : TypeConverter {
+        protected BaseNumberConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type t);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public sealed class BindableAttribute : Attribute {
+        public static readonly BindableAttribute Default;
+        public static readonly BindableAttribute No;
+        public static readonly BindableAttribute Yes;
+        public BindableAttribute(BindableSupport flags);
+        public BindableAttribute(BindableSupport flags, BindingDirection direction);
+        public BindableAttribute(bool bindable);
+        public BindableAttribute(bool bindable, BindingDirection direction);
+        public bool Bindable { get; }
+        public BindingDirection Direction { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public enum BindableSupport {
+        Default = 2,
+        No = 0,
+        Yes = 1,
+    }
+    public enum BindingDirection {
+        OneWay = 0,
+        TwoWay = 1,
+    }
+    public class BindingList<T> : Collection<T>, IBindingList, ICancelAddNew, ICollection, IEnumerable, IList, IRaiseItemChangedEvents {
+        public BindingList();
+        public BindingList(IList<T> list);
+        public bool AllowEdit { get; set; }
+        public bool AllowNew { get; set; }
+        public bool AllowRemove { get; set; }
+        protected virtual bool IsSortedCore { get; }
+        public bool RaiseListChangedEvents { get; set; }
+        protected virtual ListSortDirection SortDirectionCore { get; }
+        protected virtual PropertyDescriptor SortPropertyCore { get; }
+        protected virtual bool SupportsChangeNotificationCore { get; }
+        protected virtual bool SupportsSearchingCore { get; }
+        protected virtual bool SupportsSortingCore { get; }
+        public T AddNew();
+        protected virtual object AddNewCore();
+        protected virtual void ApplySortCore(PropertyDescriptor prop, ListSortDirection direction);
+        public virtual void CancelNew(int itemIndex);
+        protected override void ClearItems();
+        public virtual void EndNew(int itemIndex);
+        protected virtual int FindCore(PropertyDescriptor prop, object key);
+        protected override void InsertItem(int index, T item);
+        protected virtual void OnAddingNew(AddingNewEventArgs e);
+        protected virtual void OnListChanged(ListChangedEventArgs e);
+        protected override void RemoveItem(int index);
+        protected virtual void RemoveSortCore();
+        public void ResetBindings();
+        public void ResetItem(int position);
+        protected override void SetItem(int index, T item);
+        public event AddingNewEventHandler AddingNew;
+        public event ListChangedEventHandler ListChanged;
+    }
+    public class BooleanConverter : TypeConverter {
+        public BooleanConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+    }
+    public sealed class BrowsableAttribute : Attribute {
+        public static readonly BrowsableAttribute Default;
+        public static readonly BrowsableAttribute No;
+        public static readonly BrowsableAttribute Yes;
+        public BrowsableAttribute(bool browsable);
+        public bool Browsable { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class ByteConverter : BaseNumberConverter {
+        public ByteConverter();
+    }
+    public class CancelEventArgs : EventArgs {
+        public CancelEventArgs();
+        public CancelEventArgs(bool cancel);
+        public bool Cancel { get; set; }
+    }
+    public delegate void CancelEventHandler(object sender, CancelEventArgs e); {
+        public CancelEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, CancelEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, CancelEventArgs e);
+    }
+    public class CategoryAttribute : Attribute {
+        public CategoryAttribute();
+        public CategoryAttribute(string category);
+        public static CategoryAttribute Action { get; }
+        public static CategoryAttribute Appearance { get; }
+        public static CategoryAttribute Asynchronous { get; }
+        public static CategoryAttribute Behavior { get; }
+        public string Category { get; }
+        public static CategoryAttribute Data { get; }
+        public static CategoryAttribute Default { get; }
+        public static CategoryAttribute Design { get; }
+        public static CategoryAttribute DragDrop { get; }
+        public static CategoryAttribute Focus { get; }
+        public static CategoryAttribute Format { get; }
+        public static CategoryAttribute Key { get; }
+        public static CategoryAttribute Layout { get; }
+        public static CategoryAttribute Mouse { get; }
+        public static CategoryAttribute WindowStyle { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        protected virtual string GetLocalizedString(string value);
+        public override bool IsDefaultAttribute();
+    }
+    public class CharConverter : TypeConverter {
+        public CharConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public enum CollectionChangeAction {
+        Add = 1,
+        Refresh = 3,
+        Remove = 2,
+    }
+    public class CollectionChangeEventArgs : EventArgs {
+        public CollectionChangeEventArgs(CollectionChangeAction action, object element);
+        public virtual CollectionChangeAction Action { get; }
+        public virtual object Element { get; }
+    }
+    public delegate void CollectionChangeEventHandler(object sender, CollectionChangeEventArgs e); {
+        public CollectionChangeEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, CollectionChangeEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, CollectionChangeEventArgs e);
+    }
+    public class CollectionConverter : TypeConverter {
+        public CollectionConverter();
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
+    }
+    public sealed class ComplexBindingPropertiesAttribute : Attribute {
+        public static readonly ComplexBindingPropertiesAttribute Default;
+        public ComplexBindingPropertiesAttribute();
+        public ComplexBindingPropertiesAttribute(string dataSource);
+        public ComplexBindingPropertiesAttribute(string dataSource, string dataMember);
+        public string DataMember { get; }
+        public string DataSource { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public class Component : MarshalByRefObject, IComponent, IDisposable {
+        public Component();
+        protected virtual bool CanRaiseEvents { get; }
+        public IContainer Container { get; }
+        protected bool DesignMode { get; }
+        protected EventHandlerList Events { get; }
+        public virtual ISite Site { get; set; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        ~Component();
+        protected virtual object GetService(Type service);
+        public override string ToString();
+        public event EventHandler Disposed;
+    }
+    public class ComponentCollection : ReadOnlyCollectionBase {
+        public ComponentCollection(IComponent[] components);
+        public virtual IComponent this[int index] { get; }
+        public virtual IComponent this[string name] { get; }
+        public void CopyTo(IComponent[] array, int index);
+    }
+    public class ComponentConverter : ReferenceConverter {
+        public ComponentConverter(Type type);
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
+    }
+    public abstract class ComponentEditor {
+        protected ComponentEditor();
+        public abstract bool EditComponent(ITypeDescriptorContext context, object component);
+        public bool EditComponent(object component);
+    }
+    public class ComponentResourceManager : ResourceManager {
+        public ComponentResourceManager();
+        public ComponentResourceManager(Type t);
+        public void ApplyResources(object value, string objectName);
+        public virtual void ApplyResources(object value, string objectName, CultureInfo culture);
+    }
+    public class Container : IContainer, IDisposable {
+        public Container();
+        public virtual ComponentCollection Components { get; }
+        public virtual void Add(IComponent component);
+        public virtual void Add(IComponent component, string name);
+        protected virtual ISite CreateSite(IComponent component, string name);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        ~Container();
+        protected virtual object GetService(Type service);
+        public virtual void Remove(IComponent component);
+        protected void RemoveWithoutUnsiting(IComponent component);
+        protected virtual void ValidateName(IComponent component, string name);
+    }
+    public abstract class ContainerFilterService {
+        protected ContainerFilterService();
+        public virtual ComponentCollection FilterComponents(ComponentCollection components);
+    }
+    public class CultureInfoConverter : TypeConverter {
+        public CultureInfoConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        protected virtual string GetCultureName(CultureInfo culture);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+    }
+    public abstract class CustomTypeDescriptor : ICustomTypeDescriptor {
+        protected CustomTypeDescriptor();
+        protected CustomTypeDescriptor(ICustomTypeDescriptor parent);
+        public virtual AttributeCollection GetAttributes();
+        public virtual string GetClassName();
+        public virtual string GetComponentName();
+        public virtual TypeConverter GetConverter();
+        public virtual EventDescriptor GetDefaultEvent();
+        public virtual PropertyDescriptor GetDefaultProperty();
+        public virtual object GetEditor(Type editorBaseType);
+        public virtual EventDescriptorCollection GetEvents();
+        public virtual EventDescriptorCollection GetEvents(Attribute[] attributes);
+        public virtual PropertyDescriptorCollection GetProperties();
+        public virtual PropertyDescriptorCollection GetProperties(Attribute[] attributes);
+        public virtual object GetPropertyOwner(PropertyDescriptor pd);
+    }
+    public sealed class DataObjectAttribute : Attribute {
+        public static readonly DataObjectAttribute DataObject;
+        public static readonly DataObjectAttribute Default;
+        public static readonly DataObjectAttribute NonDataObject;
+        public DataObjectAttribute();
+        public DataObjectAttribute(bool isDataObject);
+        public bool IsDataObject { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public sealed class DataObjectFieldAttribute : Attribute {
+        public DataObjectFieldAttribute(bool primaryKey);
+        public DataObjectFieldAttribute(bool primaryKey, bool isIdentity);
+        public DataObjectFieldAttribute(bool primaryKey, bool isIdentity, bool isNullable);
+        public DataObjectFieldAttribute(bool primaryKey, bool isIdentity, bool isNullable, int length);
+        public bool IsIdentity { get; }
+        public bool IsNullable { get; }
+        public int Length { get; }
+        public bool PrimaryKey { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public sealed class DataObjectMethodAttribute : Attribute {
+        public DataObjectMethodAttribute(DataObjectMethodType methodType);
+        public DataObjectMethodAttribute(DataObjectMethodType methodType, bool isDefault);
+        public bool IsDefault { get; }
+        public DataObjectMethodType MethodType { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool Match(object obj);
+    }
+    public enum DataObjectMethodType {
+        Delete = 4,
+        Fill = 0,
+        Insert = 3,
+        Select = 1,
+        Update = 2,
+    }
+    public class DateTimeConverter : TypeConverter {
+        public DateTimeConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public class DateTimeOffsetConverter : TypeConverter {
+        public DateTimeOffsetConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public class DecimalConverter : BaseNumberConverter {
+        public DecimalConverter();
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public sealed class DefaultBindingPropertyAttribute : Attribute {
+        public static readonly DefaultBindingPropertyAttribute Default;
+        public DefaultBindingPropertyAttribute();
+        public DefaultBindingPropertyAttribute(string name);
+        public string Name { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public sealed class DefaultEventAttribute : Attribute {
+        public static readonly DefaultEventAttribute Default;
+        public DefaultEventAttribute(string name);
+        public string Name { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public sealed class DefaultPropertyAttribute : Attribute {
+        public static readonly DefaultPropertyAttribute Default;
+        public DefaultPropertyAttribute(string name);
+        public string Name { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
     public class DefaultValueAttribute : Attribute {
+        protected void SetValue(object value);
     }
+    public class DescriptionAttribute : Attribute {
+        public static readonly DescriptionAttribute Default;
+        public DescriptionAttribute();
+        public DescriptionAttribute(string description);
+        public virtual string Description { get; }
+        protected string DescriptionValue { get; set; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public sealed class DesignerAttribute : Attribute {
+        public DesignerAttribute(string designerTypeName);
+        public DesignerAttribute(string designerTypeName, string designerBaseTypeName);
+        public DesignerAttribute(string designerTypeName, Type designerBaseType);
+        public DesignerAttribute(Type designerType);
+        public DesignerAttribute(Type designerType, Type designerBaseType);
+        public string DesignerBaseTypeName { get; }
+        public string DesignerTypeName { get; }
+        public override object TypeId { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public sealed class DesignerCategoryAttribute : Attribute {
+        public static readonly DesignerCategoryAttribute Component;
+        public static readonly DesignerCategoryAttribute Default;
+        public static readonly DesignerCategoryAttribute Form;
+        public static readonly DesignerCategoryAttribute Generic;
+        public DesignerCategoryAttribute();
+        public DesignerCategoryAttribute(string category);
+        public string Category { get; }
+        public override object TypeId { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public enum DesignerSerializationVisibility {
+        Content = 2,
+        Hidden = 0,
+        Visible = 1,
+    }
+    public sealed class DesignerSerializationVisibilityAttribute : Attribute {
+        public static readonly DesignerSerializationVisibilityAttribute Content;
+        public static readonly DesignerSerializationVisibilityAttribute Default;
+        public static readonly DesignerSerializationVisibilityAttribute Hidden;
+        public static readonly DesignerSerializationVisibilityAttribute Visible;
+        public DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility visibility);
+        public DesignerSerializationVisibility Visibility { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public sealed class DesignOnlyAttribute : Attribute {
+        public static readonly DesignOnlyAttribute Default;
+        public static readonly DesignOnlyAttribute No;
+        public static readonly DesignOnlyAttribute Yes;
+        public DesignOnlyAttribute(bool isDesignOnly);
+        public bool IsDesignOnly { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public sealed class DesignTimeVisibleAttribute : Attribute {
+        public static readonly DesignTimeVisibleAttribute Default;
+        public static readonly DesignTimeVisibleAttribute No;
+        public static readonly DesignTimeVisibleAttribute Yes;
+        public DesignTimeVisibleAttribute();
+        public DesignTimeVisibleAttribute(bool visible);
+        public bool Visible { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class DisplayNameAttribute : Attribute {
+        public static readonly DisplayNameAttribute Default;
+        public DisplayNameAttribute();
+        public DisplayNameAttribute(string displayName);
+        public virtual string DisplayName { get; }
+        protected string DisplayNameValue { get; set; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class DoubleConverter : BaseNumberConverter {
+        public DoubleConverter();
+    }
+    public class DoWorkEventArgs : CancelEventArgs {
+        public DoWorkEventArgs(object argument);
+        public object Argument { get; }
+        public object Result { get; set; }
+    }
+    public delegate void DoWorkEventHandler(object sender, DoWorkEventArgs e); {
+        public DoWorkEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DoWorkEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DoWorkEventArgs e);
+    }
+    public sealed class EditorAttribute : Attribute {
+        public EditorAttribute();
+        public EditorAttribute(string typeName, string baseTypeName);
+        public EditorAttribute(string typeName, Type baseType);
+        public EditorAttribute(Type type, Type baseType);
+        public string EditorBaseTypeName { get; }
+        public string EditorTypeName { get; }
+        public override object TypeId { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
     public sealed class EditorBrowsableAttribute : Attribute {
+        public EditorBrowsableAttribute();
     }
+    public class EnumConverter : TypeConverter {
+        public EnumConverter(Type type);
+        protected virtual IComparer Comparer { get; }
+        protected Type EnumType { get; }
+        protected TypeConverter.StandardValuesCollection Values { get; set; }
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+        public override bool IsValid(ITypeDescriptorContext context, object value);
+    }
+    public abstract class EventDescriptor : MemberDescriptor {
+        protected EventDescriptor(MemberDescriptor descr);
+        protected EventDescriptor(MemberDescriptor descr, Attribute[] attrs);
+        protected EventDescriptor(string name, Attribute[] attrs);
+        public abstract Type ComponentType { get; }
+        public abstract Type EventType { get; }
+        public abstract bool IsMulticast { get; }
+        public abstract void AddEventHandler(object component, Delegate value);
+        public abstract void RemoveEventHandler(object component, Delegate value);
+    }
+    public class EventDescriptorCollection : ICollection, IEnumerable, IList {
+        public static readonly EventDescriptorCollection Empty;
+        public EventDescriptorCollection(EventDescriptor[] events);
+        public EventDescriptorCollection(EventDescriptor[] events, bool readOnly);
+        public int Count { get; }
+        public virtual EventDescriptor this[int index] { get; }
+        public virtual EventDescriptor this[string name] { get; }
+        public int Add(EventDescriptor value);
+        public void Clear();
+        public bool Contains(EventDescriptor value);
+        public virtual EventDescriptor Find(string name, bool ignoreCase);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(EventDescriptor value);
+        public void Insert(int index, EventDescriptor value);
+        protected void InternalSort(IComparer sorter);
+        protected void InternalSort(string[] names);
+        public void Remove(EventDescriptor value);
+        public void RemoveAt(int index);
+        public virtual EventDescriptorCollection Sort();
+        public virtual EventDescriptorCollection Sort(IComparer comparer);
+        public virtual EventDescriptorCollection Sort(string[] names);
+        public virtual EventDescriptorCollection Sort(string[] names, IComparer comparer);
+    }
+    public sealed class EventHandlerList : IDisposable {
+        public EventHandlerList();
+        public Delegate this[object key] { get; set; }
+        public void AddHandler(object key, Delegate value);
+        public void AddHandlers(EventHandlerList listToAddFrom);
+        public void Dispose();
+        public void RemoveHandler(object key, Delegate value);
+    }
+    public class ExpandableObjectConverter : TypeConverter {
+        public ExpandableObjectConverter();
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
+    }
+    public sealed class ExtenderProvidedPropertyAttribute : Attribute {
+        public ExtenderProvidedPropertyAttribute();
+        public PropertyDescriptor ExtenderProperty { get; }
+        public IExtenderProvider Provider { get; }
+        public Type ReceiverType { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class GuidConverter : TypeConverter {
+        public GuidConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public class HandledEventArgs : EventArgs {
+        public HandledEventArgs();
+        public HandledEventArgs(bool defaultHandledValue);
+        public bool Handled { get; set; }
+    }
+    public delegate void HandledEventHandler(object sender, HandledEventArgs e); {
+        public HandledEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, HandledEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, HandledEventArgs e);
+    }
+    public interface IBindingList : ICollection, IEnumerable, IList {
+        bool AllowEdit { get; }
+        bool AllowNew { get; }
+        bool AllowRemove { get; }
+        bool IsSorted { get; }
+        ListSortDirection SortDirection { get; }
+        PropertyDescriptor SortProperty { get; }
+        bool SupportsChangeNotification { get; }
+        bool SupportsSearching { get; }
+        bool SupportsSorting { get; }
+        void AddIndex(PropertyDescriptor property);
+        object AddNew();
+        void ApplySort(PropertyDescriptor property, ListSortDirection direction);
+        int Find(PropertyDescriptor property, object key);
+        void RemoveIndex(PropertyDescriptor property);
+        void RemoveSort();
+        event ListChangedEventHandler ListChanged;
+    }
+    public interface IBindingListView : IBindingList, ICollection, IEnumerable, IList {
+        string Filter { get; set; }
+        ListSortDescriptionCollection SortDescriptions { get; }
+        bool SupportsAdvancedSorting { get; }
+        bool SupportsFiltering { get; }
+        void ApplySort(ListSortDescriptionCollection sorts);
+        void RemoveFilter();
+    }
+    public interface ICancelAddNew {
+        void CancelNew(int itemIndex);
+        void EndNew(int itemIndex);
+    }
+    public interface IChangeTracking {
+        bool IsChanged { get; }
+        void AcceptChanges();
+    }
+    public interface IComNativeDescriptorHandler {
+        AttributeCollection GetAttributes(object component);
+        string GetClassName(object component);
+        TypeConverter GetConverter(object component);
+        EventDescriptor GetDefaultEvent(object component);
+        PropertyDescriptor GetDefaultProperty(object component);
+        object GetEditor(object component, Type baseEditorType);
+        EventDescriptorCollection GetEvents(object component);
+        EventDescriptorCollection GetEvents(object component, Attribute[] attributes);
+        string GetName(object component);
+        PropertyDescriptorCollection GetProperties(object component, Attribute[] attributes);
+        object GetPropertyValue(object component, int dispid, ref bool success);
+        object GetPropertyValue(object component, string propertyName, ref bool success);
+    }
+    public interface IComponent : IDisposable {
+        ISite Site { get; set; }
+        event EventHandler Disposed;
+    }
+    public interface IContainer : IDisposable {
+        ComponentCollection Components { get; }
+        void Add(IComponent component);
+        void Add(IComponent component, string name);
+        void Remove(IComponent component);
+    }
+    public interface ICustomTypeDescriptor {
+        AttributeCollection GetAttributes();
+        string GetClassName();
+        string GetComponentName();
+        TypeConverter GetConverter();
+        EventDescriptor GetDefaultEvent();
+        PropertyDescriptor GetDefaultProperty();
+        object GetEditor(Type editorBaseType);
+        EventDescriptorCollection GetEvents();
+        EventDescriptorCollection GetEvents(Attribute[] attributes);
+        PropertyDescriptorCollection GetProperties();
+        PropertyDescriptorCollection GetProperties(Attribute[] attributes);
+        object GetPropertyOwner(PropertyDescriptor pd);
+    }
+    public interface IDataErrorInfo {
+        string Error { get; }
+        string this[string columnName] { get; }
+    }
+    public interface IEditableObject {
+        void BeginEdit();
+        void CancelEdit();
+        void EndEdit();
+    }
+    public interface IExtenderProvider {
+        bool CanExtend(object extendee);
+    }
+    public interface IIntellisenseBuilder {
+        string Name { get; }
+        bool Show(string language, string value, ref string newValue);
+    }
+    public interface IListSource {
+        bool ContainsListCollection { get; }
+        IList GetList();
+    }
+    public sealed class ImmutableObjectAttribute : Attribute {
+        public static readonly ImmutableObjectAttribute Default;
+        public static readonly ImmutableObjectAttribute No;
+        public static readonly ImmutableObjectAttribute Yes;
+        public ImmutableObjectAttribute(bool immutable);
+        public bool Immutable { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public interface INestedContainer : IContainer, IDisposable {
+        IComponent Owner { get; }
+    }
+    public interface INestedSite : IServiceProvider, ISite {
+        string FullName { get; }
+    }
+    public sealed class InheritanceAttribute : Attribute {
+        public static readonly InheritanceAttribute Default;
+        public static readonly InheritanceAttribute Inherited;
+        public static readonly InheritanceAttribute InheritedReadOnly;
+        public static readonly InheritanceAttribute NotInherited;
+        public InheritanceAttribute();
+        public InheritanceAttribute(InheritanceLevel inheritanceLevel);
+        public InheritanceLevel InheritanceLevel { get; }
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+        public override string ToString();
+    }
+    public enum InheritanceLevel {
+        Inherited = 1,
+        InheritedReadOnly = 2,
+        NotInherited = 3,
+    }
+    public sealed class InitializationEventAttribute : Attribute {
+        public InitializationEventAttribute(string eventName);
+        public string EventName { get; }
+    }
+    public class InstallerTypeAttribute : Attribute {
+        public InstallerTypeAttribute(string typeName);
+        public InstallerTypeAttribute(Type installerType);
+        public virtual Type InstallerType { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public abstract class InstanceCreationEditor {
+        protected InstanceCreationEditor();
+        public virtual string Text { get; }
+        public abstract object CreateInstance(ITypeDescriptorContext context, Type instanceType);
+    }
+    public class Int16Converter : BaseNumberConverter {
+        public Int16Converter();
+    }
+    public class Int32Converter : BaseNumberConverter {
+        public Int32Converter();
+    }
+    public class Int64Converter : BaseNumberConverter {
+        public Int64Converter();
+    }
+    public class InvalidAsynchronousStateException : ArgumentException {
+        public InvalidAsynchronousStateException();
+        protected InvalidAsynchronousStateException(SerializationInfo info, StreamingContext context);
+        public InvalidAsynchronousStateException(string message);
+        public InvalidAsynchronousStateException(string message, Exception innerException);
+    }
+    public class InvalidEnumArgumentException : ArgumentException {
+        public InvalidEnumArgumentException();
+        protected InvalidEnumArgumentException(SerializationInfo info, StreamingContext context);
+        public InvalidEnumArgumentException(string message);
+        public InvalidEnumArgumentException(string message, Exception innerException);
+        public InvalidEnumArgumentException(string argumentName, int invalidValue, Type enumClass);
+    }
+    public interface IRaiseItemChangedEvents {
+        bool RaisesItemChangedEvents { get; }
+    }
+    public interface IRevertibleChangeTracking : IChangeTracking {
+        void RejectChanges();
+    }
+    public interface ISite : IServiceProvider {
+        IComponent Component { get; }
+        IContainer Container { get; }
+        bool DesignMode { get; }
+        string Name { get; set; }
+    }
+    public interface ISupportInitialize {
+        void BeginInit();
+        void EndInit();
+    }
+    public interface ISupportInitializeNotification : ISupportInitialize {
+        bool IsInitialized { get; }
+        event EventHandler Initialized;
+    }
+    public interface ISynchronizeInvoke {
+        bool InvokeRequired { get; }
+        IAsyncResult BeginInvoke(Delegate method, object[] args);
+        object EndInvoke(IAsyncResult result);
+        object Invoke(Delegate method, object[] args);
+    }
+    public interface ITypeDescriptorContext : IServiceProvider {
+        IContainer Container { get; }
+        object Instance { get; }
+        PropertyDescriptor PropertyDescriptor { get; }
+        void OnComponentChanged();
+        bool OnComponentChanging();
+    }
+    public interface ITypedList {
+        PropertyDescriptorCollection GetItemProperties(PropertyDescriptor[] listAccessors);
+        string GetListName(PropertyDescriptor[] listAccessors);
+    }
+    public abstract class License : IDisposable {
+        protected License();
+        public abstract string LicenseKey { get; }
+        public abstract void Dispose();
+    }
+    public class LicenseContext : IServiceProvider {
+        public LicenseContext();
+        public virtual LicenseUsageMode UsageMode { get; }
+        public virtual string GetSavedLicenseKey(Type type, Assembly resourceAssembly);
+        public virtual object GetService(Type type);
+        public virtual void SetSavedLicenseKey(Type type, string key);
+    }
+    public class LicenseException : SystemException {
+        protected LicenseException(SerializationInfo info, StreamingContext context);
+        public LicenseException(Type type);
+        public LicenseException(Type type, object instance);
+        public LicenseException(Type type, object instance, string message);
+        public LicenseException(Type type, object instance, string message, Exception innerException);
+        public Type LicensedType { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public sealed class LicenseManager {
+        public static LicenseContext CurrentContext { get; set; }
+        public static LicenseUsageMode UsageMode { get; }
+        public static object CreateWithContext(Type type, LicenseContext creationContext);
+        public static object CreateWithContext(Type type, LicenseContext creationContext, object[] args);
+        public static bool IsLicensed(Type type);
+        public static bool IsValid(Type type);
+        public static bool IsValid(Type type, object instance, out License license);
+        public static void LockContext(object contextUser);
+        public static void UnlockContext(object contextUser);
+        public static void Validate(Type type);
+        public static License Validate(Type type, object instance);
+    }
+    public abstract class LicenseProvider {
+        protected LicenseProvider();
+        public abstract License GetLicense(LicenseContext context, Type type, object instance, bool allowExceptions);
+    }
+    public sealed class LicenseProviderAttribute : Attribute {
+        public static readonly LicenseProviderAttribute Default;
+        public LicenseProviderAttribute();
+        public LicenseProviderAttribute(string typeName);
+        public LicenseProviderAttribute(Type type);
+        public Type LicenseProvider { get; }
+        public override object TypeId { get; }
+        public override bool Equals(object value);
+        public override int GetHashCode();
+    }
+    public enum LicenseUsageMode {
+        Designtime = 1,
+        Runtime = 0,
+    }
+    public class LicFileLicenseProvider : LicenseProvider {
+        public LicFileLicenseProvider();
+        protected virtual string GetKey(Type type);
+        public override License GetLicense(LicenseContext context, Type type, object instance, bool allowExceptions);
+        protected virtual bool IsKeyValid(string key, Type type);
+    }
+    public sealed class ListBindableAttribute : Attribute {
+        public static readonly ListBindableAttribute Default;
+        public static readonly ListBindableAttribute No;
+        public static readonly ListBindableAttribute Yes;
+        public ListBindableAttribute(BindableSupport flags);
+        public ListBindableAttribute(bool listBindable);
+        public bool ListBindable { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class ListChangedEventArgs : EventArgs {
+        public ListChangedEventArgs(ListChangedType listChangedType, int newIndex);
+        public ListChangedEventArgs(ListChangedType listChangedType, int newIndex, int oldIndex);
+        public ListChangedEventArgs(ListChangedType listChangedType, int newIndex, PropertyDescriptor propDesc);
+        public ListChangedEventArgs(ListChangedType listChangedType, PropertyDescriptor propDesc);
+        public ListChangedType ListChangedType { get; }
+        public int NewIndex { get; }
+        public int OldIndex { get; }
+        public PropertyDescriptor PropertyDescriptor { get; }
+    }
+    public delegate void ListChangedEventHandler(object sender, ListChangedEventArgs e); {
+        public ListChangedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ListChangedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ListChangedEventArgs e);
+    }
+    public enum ListChangedType {
+        ItemAdded = 1,
+        ItemChanged = 4,
+        ItemDeleted = 2,
+        ItemMoved = 3,
+        PropertyDescriptorAdded = 5,
+        PropertyDescriptorChanged = 7,
+        PropertyDescriptorDeleted = 6,
+        Reset = 0,
+    }
+    public class ListSortDescription {
+        public ListSortDescription(PropertyDescriptor property, ListSortDirection direction);
+        public PropertyDescriptor PropertyDescriptor { get; set; }
+        public ListSortDirection SortDirection { get; set; }
+    }
+    public class ListSortDescriptionCollection : ICollection, IEnumerable, IList {
+        public ListSortDescriptionCollection();
+        public ListSortDescriptionCollection(ListSortDescription[] sorts);
+        public int Count { get; }
+        public ListSortDescription this[int index] { get; set; }
+        public bool Contains(object value);
+        public void CopyTo(Array array, int index);
+        public int IndexOf(object value);
+    }
+    public enum ListSortDirection {
+        Ascending = 0,
+        Descending = 1,
+    }
+    public sealed class LocalizableAttribute : Attribute {
+        public static readonly LocalizableAttribute Default;
+        public static readonly LocalizableAttribute No;
+        public static readonly LocalizableAttribute Yes;
+        public LocalizableAttribute(bool isLocalizable);
+        public bool IsLocalizable { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public sealed class LookupBindingPropertiesAttribute : Attribute {
+        public static readonly LookupBindingPropertiesAttribute Default;
+        public LookupBindingPropertiesAttribute();
+        public LookupBindingPropertiesAttribute(string dataSource, string displayMember, string valueMember, string lookupMember);
+        public string DataSource { get; }
+        public string DisplayMember { get; }
+        public string LookupMember { get; }
+        public string ValueMember { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public class MarshalByValueComponent : IComponent, IDisposable, IServiceProvider {
+        public MarshalByValueComponent();
+        public virtual IContainer Container { get; }
+        public virtual bool DesignMode { get; }
+        protected EventHandlerList Events { get; }
+        public virtual ISite Site { get; set; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        ~MarshalByValueComponent();
+        public virtual object GetService(Type service);
+        public override string ToString();
+        public event EventHandler Disposed;
+    }
+    public class MaskedTextProvider : ICloneable {
+        public MaskedTextProvider(string mask);
+        public MaskedTextProvider(string mask, bool restrictToAscii);
+        public MaskedTextProvider(string mask, char passwordChar, bool allowPromptAsInput);
+        public MaskedTextProvider(string mask, CultureInfo culture);
+        public MaskedTextProvider(string mask, CultureInfo culture, bool restrictToAscii);
+        public MaskedTextProvider(string mask, CultureInfo culture, bool allowPromptAsInput, char promptChar, char passwordChar, bool restrictToAscii);
+        public MaskedTextProvider(string mask, CultureInfo culture, char passwordChar, bool allowPromptAsInput);
+        public bool AllowPromptAsInput { get; }
+        public bool AsciiOnly { get; }
+        public int AssignedEditPositionCount { get; }
+        public int AvailableEditPositionCount { get; }
+        public CultureInfo Culture { get; }
+        public static char DefaultPasswordChar { get; }
+        public int EditPositionCount { get; }
+        public IEnumerator EditPositions { get; }
+        public bool IncludeLiterals { get; set; }
+        public bool IncludePrompt { get; set; }
+        public static int InvalidIndex { get; }
+        public bool IsPassword { get; set; }
+        public char this[int index] { get; }
+        public int LastAssignedPosition { get; }
+        public int Length { get; }
+        public string Mask { get; }
+        public bool MaskCompleted { get; }
+        public bool MaskFull { get; }
+        public char PasswordChar { get; set; }
+        public char PromptChar { get; set; }
+        public bool ResetOnPrompt { get; set; }
+        public bool ResetOnSpace { get; set; }
+        public bool SkipLiterals { get; set; }
+        public bool Add(char input);
+        public bool Add(char input, out int testPosition, out MaskedTextResultHint resultHint);
+        public bool Add(string input);
+        public bool Add(string input, out int testPosition, out MaskedTextResultHint resultHint);
+        public void Clear();
+        public void Clear(out MaskedTextResultHint resultHint);
+        public object Clone();
+        public int FindAssignedEditPositionFrom(int position, bool direction);
+        public int FindAssignedEditPositionInRange(int startPosition, int endPosition, bool direction);
+        public int FindEditPositionFrom(int position, bool direction);
+        public int FindEditPositionInRange(int startPosition, int endPosition, bool direction);
+        public int FindNonEditPositionFrom(int position, bool direction);
+        public int FindNonEditPositionInRange(int startPosition, int endPosition, bool direction);
+        public int FindUnassignedEditPositionFrom(int position, bool direction);
+        public int FindUnassignedEditPositionInRange(int startPosition, int endPosition, bool direction);
+        public static bool GetOperationResultFromHint(MaskedTextResultHint hint);
+        public bool InsertAt(char input, int position);
+        public bool InsertAt(char input, int position, out int testPosition, out MaskedTextResultHint resultHint);
+        public bool InsertAt(string input, int position);
+        public bool InsertAt(string input, int position, out int testPosition, out MaskedTextResultHint resultHint);
+        public bool IsAvailablePosition(int position);
+        public bool IsEditPosition(int position);
+        public static bool IsValidInputChar(char c);
+        public static bool IsValidMaskChar(char c);
+        public static bool IsValidPasswordChar(char c);
+        public bool Remove();
+        public bool Remove(out int testPosition, out MaskedTextResultHint resultHint);
+        public bool RemoveAt(int position);
+        public bool RemoveAt(int startPosition, int endPosition);
+        public bool RemoveAt(int startPosition, int endPosition, out int testPosition, out MaskedTextResultHint resultHint);
+        public bool Replace(char input, int position);
+        public bool Replace(char input, int startPosition, int endPosition, out int testPosition, out MaskedTextResultHint resultHint);
+        public bool Replace(char input, int position, out int testPosition, out MaskedTextResultHint resultHint);
+        public bool Replace(string input, int position);
+        public bool Replace(string input, int startPosition, int endPosition, out int testPosition, out MaskedTextResultHint resultHint);
+        public bool Replace(string input, int position, out int testPosition, out MaskedTextResultHint resultHint);
+        public bool Set(string input);
+        public bool Set(string input, out int testPosition, out MaskedTextResultHint resultHint);
+        public string ToDisplayString();
+        public override string ToString();
+        public string ToString(bool ignorePasswordChar);
+        public string ToString(bool includePrompt, bool includeLiterals);
+        public string ToString(bool ignorePasswordChar, bool includePrompt, bool includeLiterals, int startPosition, int length);
+        public string ToString(bool includePrompt, bool includeLiterals, int startPosition, int length);
+        public string ToString(bool ignorePasswordChar, int startPosition, int length);
+        public string ToString(int startPosition, int length);
+        public bool VerifyChar(char input, int position, out MaskedTextResultHint hint);
+        public bool VerifyEscapeChar(char input, int position);
+        public bool VerifyString(string input);
+        public bool VerifyString(string input, out int testPosition, out MaskedTextResultHint resultHint);
+    }
+    public enum MaskedTextResultHint {
+        AlphanumericCharacterExpected = -2,
+        AsciiCharacterExpected = -1,
+        CharacterEscaped = 1,
+        DigitExpected = -3,
+        InvalidInput = -51,
+        LetterExpected = -4,
+        NoEffect = 2,
+        NonEditPosition = -54,
+        PositionOutOfRange = -55,
+        PromptCharNotAllowed = -52,
+        SideEffect = 3,
+        SignedDigitExpected = -5,
+        Success = 4,
+        UnavailableEditPosition = -53,
+        Unknown = 0,
+    }
+    public abstract class MemberDescriptor {
+        protected MemberDescriptor(MemberDescriptor descr);
+        protected MemberDescriptor(MemberDescriptor oldMemberDescriptor, Attribute[] newAttributes);
+        protected MemberDescriptor(string name);
+        protected MemberDescriptor(string name, Attribute[] attributes);
+        protected virtual Attribute[] AttributeArray { get; set; }
+        public virtual AttributeCollection Attributes { get; }
+        public virtual string Category { get; }
+        public virtual string Description { get; }
+        public virtual bool DesignTimeOnly { get; }
+        public virtual string DisplayName { get; }
+        public virtual bool IsBrowsable { get; }
+        public virtual string Name { get; }
+        protected virtual int NameHashCode { get; }
+        protected virtual AttributeCollection CreateAttributeCollection();
+        public override bool Equals(object obj);
+        protected virtual void FillAttributes(IList attributeList);
+        protected static MethodInfo FindMethod(Type componentClass, string name, Type[] args, Type returnType);
+        protected static MethodInfo FindMethod(Type componentClass, string name, Type[] args, Type returnType, bool publicOnly);
+        public override int GetHashCode();
+        protected virtual object GetInvocationTarget(Type type, object instance);
+        protected static object GetInvokee(Type componentClass, object component);
+        protected static ISite GetSite(object component);
+    }
+    public sealed class MergablePropertyAttribute : Attribute {
+        public static readonly MergablePropertyAttribute Default;
+        public static readonly MergablePropertyAttribute No;
+        public static readonly MergablePropertyAttribute Yes;
+        public MergablePropertyAttribute(bool allowMerge);
+        public bool AllowMerge { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class MultilineStringConverter : TypeConverter {
+        public MultilineStringConverter();
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
+    }
+    public class NestedContainer : Container, IContainer, IDisposable, INestedContainer {
+        public NestedContainer(IComponent owner);
+        public IComponent Owner { get; }
+        protected virtual string OwnerName { get; }
+        protected override ISite CreateSite(IComponent component, string name);
+        protected override void Dispose(bool disposing);
+        protected override object GetService(Type service);
+    }
+    public sealed class NotifyParentPropertyAttribute : Attribute {
+        public static readonly NotifyParentPropertyAttribute Default;
+        public static readonly NotifyParentPropertyAttribute No;
+        public static readonly NotifyParentPropertyAttribute Yes;
+        public NotifyParentPropertyAttribute(bool notifyParent);
+        public bool NotifyParent { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class NullableConverter : TypeConverter {
+        public NullableConverter(Type type);
+        public Type NullableType { get; }
+        public Type UnderlyingType { get; }
+        public TypeConverter UnderlyingTypeConverter { get; }
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
+        public override bool GetCreateInstanceSupported(ITypeDescriptorContext context);
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+        public override bool IsValid(ITypeDescriptorContext context, object value);
+    }
+    public sealed class ParenthesizePropertyNameAttribute : Attribute {
+        public static readonly ParenthesizePropertyNameAttribute Default;
+        public ParenthesizePropertyNameAttribute();
+        public ParenthesizePropertyNameAttribute(bool needParenthesis);
+        public bool NeedParenthesis { get; }
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public sealed class PasswordPropertyTextAttribute : Attribute {
+        public static readonly PasswordPropertyTextAttribute Default;
+        public static readonly PasswordPropertyTextAttribute No;
+        public static readonly PasswordPropertyTextAttribute Yes;
+        public PasswordPropertyTextAttribute();
+        public PasswordPropertyTextAttribute(bool password);
+        public bool Password { get; }
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class ProgressChangedEventArgs : EventArgs {
+        public ProgressChangedEventArgs(int progressPercentage, object userState);
+        public int ProgressPercentage { get; }
+        public object UserState { get; }
+    }
+    public delegate void ProgressChangedEventHandler(object sender, ProgressChangedEventArgs e); {
+        public ProgressChangedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ProgressChangedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ProgressChangedEventArgs e);
+    }
+    public abstract class PropertyDescriptor : MemberDescriptor {
+        protected PropertyDescriptor(MemberDescriptor descr);
+        protected PropertyDescriptor(MemberDescriptor descr, Attribute[] attrs);
+        protected PropertyDescriptor(string name, Attribute[] attrs);
+        public abstract Type ComponentType { get; }
+        public virtual TypeConverter Converter { get; }
+        public virtual bool IsLocalizable { get; }
+        public abstract bool IsReadOnly { get; }
+        public abstract Type PropertyType { get; }
+        public DesignerSerializationVisibility SerializationVisibility { get; }
+        public virtual bool SupportsChangeEvents { get; }
+        public virtual void AddValueChanged(object component, EventHandler handler);
+        public abstract bool CanResetValue(object component);
+        protected object CreateInstance(Type type);
+        public override bool Equals(object obj);
+        protected override void FillAttributes(IList attributeList);
+        public PropertyDescriptorCollection GetChildProperties();
+        public PropertyDescriptorCollection GetChildProperties(Attribute[] filter);
+        public PropertyDescriptorCollection GetChildProperties(object instance);
+        public virtual PropertyDescriptorCollection GetChildProperties(object instance, Attribute[] filter);
+        public virtual object GetEditor(Type editorBaseType);
+        public override int GetHashCode();
+        protected override object GetInvocationTarget(Type type, object instance);
+        protected Type GetTypeFromName(string typeName);
+        public abstract object GetValue(object component);
+        protected internal EventHandler GetValueChangedHandler(object component);
+        protected virtual void OnValueChanged(object component, EventArgs e);
+        public virtual void RemoveValueChanged(object component, EventHandler handler);
+        public abstract void ResetValue(object component);
+        public abstract void SetValue(object component, object value);
+        public abstract bool ShouldSerializeValue(object component);
+    }
+    public class PropertyDescriptorCollection : ICollection, IDictionary, IEnumerable, IList {
+        public static readonly PropertyDescriptorCollection Empty;
+        public PropertyDescriptorCollection(PropertyDescriptor[] properties);
+        public PropertyDescriptorCollection(PropertyDescriptor[] properties, bool readOnly);
+        public int Count { get; }
+        public virtual PropertyDescriptor this[int index] { get; }
+        public virtual PropertyDescriptor this[string name] { get; }
+        public int Add(PropertyDescriptor value);
+        public void Clear();
+        public bool Contains(PropertyDescriptor value);
+        public void CopyTo(Array array, int index);
+        public virtual PropertyDescriptor Find(string name, bool ignoreCase);
+        public virtual IEnumerator GetEnumerator();
+        public int IndexOf(PropertyDescriptor value);
+        public void Insert(int index, PropertyDescriptor value);
+        protected void InternalSort(IComparer sorter);
+        protected void InternalSort(string[] names);
+        public void Remove(PropertyDescriptor value);
+        public void RemoveAt(int index);
+        public virtual PropertyDescriptorCollection Sort();
+        public virtual PropertyDescriptorCollection Sort(IComparer comparer);
+        public virtual PropertyDescriptorCollection Sort(string[] names);
+        public virtual PropertyDescriptorCollection Sort(string[] names, IComparer comparer);
+    }
+    public class PropertyTabAttribute : Attribute {
+        public PropertyTabAttribute();
+        public PropertyTabAttribute(string tabClassName);
+        public PropertyTabAttribute(string tabClassName, PropertyTabScope tabScope);
+        public PropertyTabAttribute(Type tabClass);
+        public PropertyTabAttribute(Type tabClass, PropertyTabScope tabScope);
+        public Type[] TabClasses { get; }
+        protected string[] TabClassNames { get; }
+        public PropertyTabScope[] TabScopes { get; }
+        public override bool Equals(object other);
+        public bool Equals(PropertyTabAttribute other);
+        public override int GetHashCode();
+        protected void InitializeArrays(string[] tabClassNames, PropertyTabScope[] tabScopes);
+        protected void InitializeArrays(Type[] tabClasses, PropertyTabScope[] tabScopes);
+    }
+    public enum PropertyTabScope {
+        Component = 3,
+        Document = 2,
+        Global = 1,
+        Static = 0,
+    }
+    public sealed class ProvidePropertyAttribute : Attribute {
+        public ProvidePropertyAttribute(string propertyName, string receiverTypeName);
+        public ProvidePropertyAttribute(string propertyName, Type receiverType);
+        public string PropertyName { get; }
+        public string ReceiverTypeName { get; }
+        public override object TypeId { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public sealed class ReadOnlyAttribute : Attribute {
+        public static readonly ReadOnlyAttribute Default;
+        public static readonly ReadOnlyAttribute No;
+        public static readonly ReadOnlyAttribute Yes;
+        public ReadOnlyAttribute(bool isReadOnly);
+        public bool IsReadOnly { get; }
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class RecommendedAsConfigurableAttribute : Attribute {
+        public static readonly RecommendedAsConfigurableAttribute Default;
+        public static readonly RecommendedAsConfigurableAttribute No;
+        public static readonly RecommendedAsConfigurableAttribute Yes;
+        public RecommendedAsConfigurableAttribute(bool recommendedAsConfigurable);
+        public bool RecommendedAsConfigurable { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class ReferenceConverter : TypeConverter {
+        public ReferenceConverter(Type type);
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+        protected virtual bool IsValueAllowed(ITypeDescriptorContext context, object value);
+    }
+    public class RefreshEventArgs : EventArgs {
+        public RefreshEventArgs(object componentChanged);
+        public RefreshEventArgs(Type typeChanged);
+        public object ComponentChanged { get; }
+        public Type TypeChanged { get; }
+    }
+    public delegate void RefreshEventHandler(RefreshEventArgs e); {
+        public RefreshEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(RefreshEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(RefreshEventArgs e);
+    }
+    public enum RefreshProperties {
+        All = 1,
+        None = 0,
+        Repaint = 2,
+    }
+    public sealed class RefreshPropertiesAttribute : Attribute {
+        public static readonly RefreshPropertiesAttribute All;
+        public static readonly RefreshPropertiesAttribute Default;
+        public static readonly RefreshPropertiesAttribute Repaint;
+        public RefreshPropertiesAttribute(RefreshProperties refresh);
+        public RefreshProperties RefreshProperties { get; }
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class RunInstallerAttribute : Attribute {
+        public static readonly RunInstallerAttribute Default;
+        public static readonly RunInstallerAttribute No;
+        public static readonly RunInstallerAttribute Yes;
+        public RunInstallerAttribute(bool runInstaller);
+        public bool RunInstaller { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public class RunWorkerCompletedEventArgs : AsyncCompletedEventArgs {
+        public RunWorkerCompletedEventArgs(object result, Exception error, bool cancelled);
+        public object Result { get; }
+        public new object UserState { get; }
+    }
+    public delegate void RunWorkerCompletedEventHandler(object sender, RunWorkerCompletedEventArgs e); {
+        public RunWorkerCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, RunWorkerCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, RunWorkerCompletedEventArgs e);
+    }
+    public class SByteConverter : BaseNumberConverter {
+        public SByteConverter();
+    }
+    public sealed class SettingsBindableAttribute : Attribute {
+        public static readonly SettingsBindableAttribute No;
+        public static readonly SettingsBindableAttribute Yes;
+        public SettingsBindableAttribute(bool bindable);
+        public bool Bindable { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public class SingleConverter : BaseNumberConverter {
+        public SingleConverter();
+    }
+    public class StringConverter : TypeConverter {
+        public StringConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+    }
+    public static class SyntaxCheck {
+        public static bool CheckMachineName(string value);
+        public static bool CheckPath(string value);
+        public static bool CheckRootedPath(string value);
+    }
+    public class TimeSpanConverter : TypeConverter {
+        public TimeSpanConverter();
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public class ToolboxItemAttribute : Attribute {
+        public static readonly ToolboxItemAttribute Default;
+        public static readonly ToolboxItemAttribute None;
+        public ToolboxItemAttribute(bool defaultType);
+        public ToolboxItemAttribute(string toolboxItemTypeName);
+        public ToolboxItemAttribute(Type toolboxItemType);
+        public Type ToolboxItemType { get; }
+        public string ToolboxItemTypeName { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public sealed class ToolboxItemFilterAttribute : Attribute {
+        public ToolboxItemFilterAttribute(string filterString);
+        public ToolboxItemFilterAttribute(string filterString, ToolboxItemFilterType filterType);
+        public string FilterString { get; }
+        public ToolboxItemFilterType FilterType { get; }
+        public override object TypeId { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool Match(object obj);
+        public override string ToString();
+    }
+    public enum ToolboxItemFilterType {
+        Allow = 0,
+        Custom = 1,
+        Prevent = 2,
+        Require = 3,
+    }
+    public class TypeConverter {
+        protected abstract class SimplePropertyDescriptor : PropertyDescriptor {
+            protected SimplePropertyDescriptor(Type componentType, string name, Type propertyType);
+            protected SimplePropertyDescriptor(Type componentType, string name, Type propertyType, Attribute[] attributes);
+            public override Type ComponentType { get; }
+            public override bool IsReadOnly { get; }
+            public override Type PropertyType { get; }
+            public override bool CanResetValue(object component);
+            public override void ResetValue(object component);
+            public override bool ShouldSerializeValue(object component);
+        }
+        public class StandardValuesCollection : ICollection, IEnumerable {
+            public StandardValuesCollection(ICollection values);
+            public int Count { get; }
+            public object this[int index] { get; }
+            public void CopyTo(Array array, int index);
+            public IEnumerator GetEnumerator();
+        }
+        public TypeConverter();
+        public virtual bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public bool CanConvertFrom(Type sourceType);
+        public virtual bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public bool CanConvertTo(Type destinationType);
+        public virtual object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public object ConvertFrom(object value);
+        public object ConvertFromInvariantString(ITypeDescriptorContext context, string text);
+        public object ConvertFromInvariantString(string text);
+        public object ConvertFromString(ITypeDescriptorContext context, CultureInfo culture, string text);
+        public object ConvertFromString(ITypeDescriptorContext context, string text);
+        public object ConvertFromString(string text);
+        public virtual object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public object ConvertTo(object value, Type destinationType);
+        public string ConvertToInvariantString(ITypeDescriptorContext context, object value);
+        public string ConvertToInvariantString(object value);
+        public string ConvertToString(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public string ConvertToString(ITypeDescriptorContext context, object value);
+        public string ConvertToString(object value);
+        public object CreateInstance(IDictionary propertyValues);
+        public virtual object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
+        protected Exception GetConvertFromException(object value);
+        protected Exception GetConvertToException(object value, Type destinationType);
+        public bool GetCreateInstanceSupported();
+        public virtual bool GetCreateInstanceSupported(ITypeDescriptorContext context);
+        public PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value);
+        public virtual PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        public PropertyDescriptorCollection GetProperties(object value);
+        public bool GetPropertiesSupported();
+        public virtual bool GetPropertiesSupported(ITypeDescriptorContext context);
+        public ICollection GetStandardValues();
+        public virtual TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public bool GetStandardValuesExclusive();
+        public virtual bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public bool GetStandardValuesSupported();
+        public virtual bool GetStandardValuesSupported(ITypeDescriptorContext context);
+        public virtual bool IsValid(ITypeDescriptorContext context, object value);
+        public bool IsValid(object value);
+        protected PropertyDescriptorCollection SortProperties(PropertyDescriptorCollection props, string[] names);
+    }
+    public sealed class TypeConverterAttribute : Attribute {
+        public static readonly TypeConverterAttribute Default;
+        public TypeConverterAttribute();
+        public TypeConverterAttribute(string typeName);
+        public TypeConverterAttribute(Type type);
+        public string ConverterTypeName { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public abstract class TypeDescriptionProvider {
+        protected TypeDescriptionProvider();
+        protected TypeDescriptionProvider(TypeDescriptionProvider parent);
+        public virtual object CreateInstance(IServiceProvider provider, Type objectType, Type[] argTypes, object[] args);
+        public virtual IDictionary GetCache(object instance);
+        public virtual ICustomTypeDescriptor GetExtendedTypeDescriptor(object instance);
+        protected internal virtual IExtenderProvider[] GetExtenderProviders(object instance);
+        public virtual string GetFullComponentName(object component);
+        public Type GetReflectionType(object instance);
+        public Type GetReflectionType(Type objectType);
+        public virtual Type GetReflectionType(Type objectType, object instance);
+        public virtual Type GetRuntimeType(Type reflectionType);
+        public ICustomTypeDescriptor GetTypeDescriptor(object instance);
+        public ICustomTypeDescriptor GetTypeDescriptor(Type objectType);
+        public virtual ICustomTypeDescriptor GetTypeDescriptor(Type objectType, object instance);
+        public virtual bool IsSupportedType(Type type);
+    }
+    public sealed class TypeDescriptionProviderAttribute : Attribute {
+        public TypeDescriptionProviderAttribute(string typeName);
+        public TypeDescriptionProviderAttribute(Type type);
+        public string TypeName { get; }
+    }
+    public sealed class TypeDescriptor {
+        public static IComNativeDescriptorHandler ComNativeDescriptorHandler { get; set; }
+        public static Type ComObjectType { get; }
+        public static Type InterfaceType { get; }
+        public static TypeDescriptionProvider AddAttributes(object instance, params Attribute[] attributes);
+        public static TypeDescriptionProvider AddAttributes(Type type, params Attribute[] attributes);
+        public static void AddEditorTable(Type editorBaseType, Hashtable table);
+        public static void AddProvider(TypeDescriptionProvider provider, object instance);
+        public static void AddProvider(TypeDescriptionProvider provider, Type type);
+        public static void AddProviderTransparent(TypeDescriptionProvider provider, object instance);
+        public static void AddProviderTransparent(TypeDescriptionProvider provider, Type type);
+        public static void CreateAssociation(object primary, object secondary);
+        public static IDesigner CreateDesigner(IComponent component, Type designerBaseType);
+        public static EventDescriptor CreateEvent(Type componentType, EventDescriptor oldEventDescriptor, params Attribute[] attributes);
+        public static EventDescriptor CreateEvent(Type componentType, string name, Type type, params Attribute[] attributes);
+        public static object CreateInstance(IServiceProvider provider, Type objectType, Type[] argTypes, object[] args);
+        public static PropertyDescriptor CreateProperty(Type componentType, PropertyDescriptor oldPropertyDescriptor, params Attribute[] attributes);
+        public static PropertyDescriptor CreateProperty(Type componentType, string name, Type type, params Attribute[] attributes);
+        public static object GetAssociation(Type type, object primary);
+        public static AttributeCollection GetAttributes(object component);
+        public static AttributeCollection GetAttributes(object component, bool noCustomTypeDesc);
+        public static AttributeCollection GetAttributes(Type componentType);
+        public static string GetClassName(object component);
+        public static string GetClassName(object component, bool noCustomTypeDesc);
+        public static string GetClassName(Type componentType);
+        public static string GetComponentName(object component);
+        public static string GetComponentName(object component, bool noCustomTypeDesc);
+        public static TypeConverter GetConverter(object component);
+        public static TypeConverter GetConverter(object component, bool noCustomTypeDesc);
+        public static TypeConverter GetConverter(Type type);
+        public static EventDescriptor GetDefaultEvent(object component);
+        public static EventDescriptor GetDefaultEvent(object component, bool noCustomTypeDesc);
+        public static EventDescriptor GetDefaultEvent(Type componentType);
+        public static PropertyDescriptor GetDefaultProperty(object component);
+        public static PropertyDescriptor GetDefaultProperty(object component, bool noCustomTypeDesc);
+        public static PropertyDescriptor GetDefaultProperty(Type componentType);
+        public static object GetEditor(object component, Type editorBaseType);
+        public static object GetEditor(object component, Type editorBaseType, bool noCustomTypeDesc);
+        public static object GetEditor(Type type, Type editorBaseType);
+        public static EventDescriptorCollection GetEvents(object component);
+        public static EventDescriptorCollection GetEvents(object component, Attribute[] attributes);
+        public static EventDescriptorCollection GetEvents(object component, Attribute[] attributes, bool noCustomTypeDesc);
+        public static EventDescriptorCollection GetEvents(object component, bool noCustomTypeDesc);
+        public static EventDescriptorCollection GetEvents(Type componentType);
+        public static EventDescriptorCollection GetEvents(Type componentType, Attribute[] attributes);
+        public static string GetFullComponentName(object component);
+        public static PropertyDescriptorCollection GetProperties(object component);
+        public static PropertyDescriptorCollection GetProperties(object component, Attribute[] attributes);
+        public static PropertyDescriptorCollection GetProperties(object component, Attribute[] attributes, bool noCustomTypeDesc);
+        public static PropertyDescriptorCollection GetProperties(object component, bool noCustomTypeDesc);
+        public static PropertyDescriptorCollection GetProperties(Type componentType);
+        public static PropertyDescriptorCollection GetProperties(Type componentType, Attribute[] attributes);
+        public static TypeDescriptionProvider GetProvider(object instance);
+        public static TypeDescriptionProvider GetProvider(Type type);
+        public static Type GetReflectionType(object instance);
+        public static Type GetReflectionType(Type type);
+        public static void Refresh(Assembly assembly);
+        public static void Refresh(Module module);
+        public static void Refresh(object component);
+        public static void Refresh(Type type);
+        public static void RemoveAssociation(object primary, object secondary);
+        public static void RemoveAssociations(object primary);
+        public static void RemoveProvider(TypeDescriptionProvider provider, object instance);
+        public static void RemoveProvider(TypeDescriptionProvider provider, Type type);
+        public static void RemoveProviderTransparent(TypeDescriptionProvider provider, object instance);
+        public static void RemoveProviderTransparent(TypeDescriptionProvider provider, Type type);
+        public static void SortDescriptorArray(IList infos);
+        public static event RefreshEventHandler Refreshed;
+    }
+    public abstract class TypeListConverter : TypeConverter {
+        protected TypeListConverter(Type[] types);
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+    }
+    public class UInt16Converter : BaseNumberConverter {
+        public UInt16Converter();
+    }
+    public class UInt32Converter : BaseNumberConverter {
+        public UInt32Converter();
+    }
+    public class UInt64Converter : BaseNumberConverter {
+        public UInt64Converter();
+    }
+    public class WarningException : SystemException {
+        public WarningException();
+        protected WarningException(SerializationInfo info, StreamingContext context);
+        public WarningException(string message);
+        public WarningException(string message, Exception innerException);
+        public WarningException(string message, string helpUrl);
+        public WarningException(string message, string helpUrl, string helpTopic);
+        public string HelpTopic { get; }
+        public string HelpUrl { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
-    public class Win32Exception : Exception {
+    public class Win32Exception : ExternalException, ISerializable {
+        protected Win32Exception(SerializationInfo info, StreamingContext context);
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
 }
+namespace System.ComponentModel.Design {
+    public class ActiveDesignerEventArgs : EventArgs {
+        public ActiveDesignerEventArgs(IDesignerHost oldDesigner, IDesignerHost newDesigner);
+        public IDesignerHost NewDesigner { get; }
+        public IDesignerHost OldDesigner { get; }
+    }
+    public delegate void ActiveDesignerEventHandler(object sender, ActiveDesignerEventArgs e); {
+        public ActiveDesignerEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ActiveDesignerEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ActiveDesignerEventArgs e);
+    }
+    public class CheckoutException : ExternalException {
+        public static readonly CheckoutException Canceled;
+        public CheckoutException();
+        protected CheckoutException(SerializationInfo info, StreamingContext context);
+        public CheckoutException(string message);
+        public CheckoutException(string message, Exception innerException);
+        public CheckoutException(string message, int errorCode);
+    }
+    public class CommandID {
+        public CommandID(Guid menuGroup, int commandID);
+        public virtual Guid Guid { get; }
+        public virtual int ID { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public sealed class ComponentChangedEventArgs : EventArgs {
+        public ComponentChangedEventArgs(object component, MemberDescriptor member, object oldValue, object newValue);
+        public object Component { get; }
+        public MemberDescriptor Member { get; }
+        public object NewValue { get; }
+        public object OldValue { get; }
+    }
+    public delegate void ComponentChangedEventHandler(object sender, ComponentChangedEventArgs e); {
+        public ComponentChangedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ComponentChangedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ComponentChangedEventArgs e);
+    }
+    public sealed class ComponentChangingEventArgs : EventArgs {
+        public ComponentChangingEventArgs(object component, MemberDescriptor member);
+        public object Component { get; }
+        public MemberDescriptor Member { get; }
+    }
+    public delegate void ComponentChangingEventHandler(object sender, ComponentChangingEventArgs e); {
+        public ComponentChangingEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ComponentChangingEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ComponentChangingEventArgs e);
+    }
+    public class ComponentEventArgs : EventArgs {
+        public ComponentEventArgs(IComponent component);
+        public virtual IComponent Component { get; }
+    }
+    public delegate void ComponentEventHandler(object sender, ComponentEventArgs e); {
+        public ComponentEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ComponentEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ComponentEventArgs e);
+    }
+    public class ComponentRenameEventArgs : EventArgs {
+        public ComponentRenameEventArgs(object component, string oldName, string newName);
+        public object Component { get; }
+        public virtual string NewName { get; }
+        public virtual string OldName { get; }
+    }
+    public delegate void ComponentRenameEventHandler(object sender, ComponentRenameEventArgs e); {
+        public ComponentRenameEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ComponentRenameEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ComponentRenameEventArgs e);
+    }
+    public class DesignerCollection : ICollection, IEnumerable {
+        public DesignerCollection(IDesignerHost[] designers);
+        public DesignerCollection(IList designers);
+        public int Count { get; }
+        public virtual IDesignerHost this[int index] { get; }
+        public IEnumerator GetEnumerator();
+    }
+    public class DesignerEventArgs : EventArgs {
+        public DesignerEventArgs(IDesignerHost host);
+        public IDesignerHost Designer { get; }
+    }
+    public delegate void DesignerEventHandler(object sender, DesignerEventArgs e); {
+        public DesignerEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DesignerEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DesignerEventArgs e);
+    }
+    public abstract class DesignerOptionService : IDesignerOptionService {
+        public sealed class DesignerOptionCollection : ICollection, IEnumerable, IList {
+            public int Count { get; }
+            public DesignerOptionService.DesignerOptionCollection this[int index] { get; }
+            public DesignerOptionService.DesignerOptionCollection this[string name] { get; }
+            public string Name { get; }
+            public DesignerOptionService.DesignerOptionCollection Parent { get; }
+            public PropertyDescriptorCollection Properties { get; }
+            public void CopyTo(Array array, int index);
+            public IEnumerator GetEnumerator();
+            public int IndexOf(DesignerOptionService.DesignerOptionCollection value);
+            public bool ShowDialog();
+        }
+        protected DesignerOptionService();
+        public DesignerOptionService.DesignerOptionCollection Options { get; }
+        protected DesignerOptionService.DesignerOptionCollection CreateOptionCollection(DesignerOptionService.DesignerOptionCollection parent, string name, object value);
+        protected virtual void PopulateOptionCollection(DesignerOptionService.DesignerOptionCollection options);
+        protected virtual bool ShowDialog(DesignerOptionService.DesignerOptionCollection options, object optionObject);
+    }
+    public abstract class DesignerTransaction : IDisposable {
+        protected DesignerTransaction();
+        protected DesignerTransaction(string description);
+        public bool Canceled { get; }
+        public bool Committed { get; }
+        public string Description { get; }
+        public void Cancel();
+        public void Commit();
+        protected virtual void Dispose(bool disposing);
+        ~DesignerTransaction();
+        protected abstract void OnCancel();
+        protected abstract void OnCommit();
+    }
+    public class DesignerTransactionCloseEventArgs : EventArgs {
+        public DesignerTransactionCloseEventArgs(bool commit);
+        public DesignerTransactionCloseEventArgs(bool commit, bool lastTransaction);
+        public bool LastTransaction { get; }
+        public bool TransactionCommitted { get; }
+    }
+    public delegate void DesignerTransactionCloseEventHandler(object sender, DesignerTransactionCloseEventArgs e); {
+        public DesignerTransactionCloseEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DesignerTransactionCloseEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DesignerTransactionCloseEventArgs e);
+    }
+    public class DesignerVerb : MenuCommand {
+        public DesignerVerb(string text, EventHandler handler);
+        public DesignerVerb(string text, EventHandler handler, CommandID startCommandID);
+        public string Description { get; set; }
+        public string Text { get; }
+        public override string ToString();
+    }
+    public class DesignerVerbCollection : CollectionBase {
+        public DesignerVerbCollection();
+        public DesignerVerbCollection(DesignerVerb[] value);
+        public DesignerVerb this[int index] { get; set; }
+        public int Add(DesignerVerb value);
+        public void AddRange(DesignerVerbCollection value);
+        public void AddRange(DesignerVerb[] value);
+        public bool Contains(DesignerVerb value);
+        public void CopyTo(DesignerVerb[] array, int index);
+        public int IndexOf(DesignerVerb value);
+        public void Insert(int index, DesignerVerb value);
+        protected override void OnClear();
+        protected override void OnInsert(int index, object value);
+        protected override void OnRemove(int index, object value);
+        protected override void OnSet(int index, object oldValue, object newValue);
+        protected override void OnValidate(object value);
+        public void Remove(DesignerVerb value);
+    }
+    public class DesigntimeLicenseContext : LicenseContext {
+        public DesigntimeLicenseContext();
+        public override LicenseUsageMode UsageMode { get; }
+        public override string GetSavedLicenseKey(Type type, Assembly resourceAssembly);
+        public override void SetSavedLicenseKey(Type type, string key);
+    }
+    public class DesigntimeLicenseContextSerializer {
+        public static void Serialize(Stream o, string cryptoKey, DesigntimeLicenseContext context);
+    }
+    public enum HelpContextType {
+        Ambient = 0,
+        Selection = 2,
+        ToolWindowSelection = 3,
+        Window = 1,
+    }
+    public sealed class HelpKeywordAttribute : Attribute {
+        public static readonly HelpKeywordAttribute Default;
+        public HelpKeywordAttribute();
+        public HelpKeywordAttribute(string keyword);
+        public HelpKeywordAttribute(Type t);
+        public string HelpKeyword { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override bool IsDefaultAttribute();
+    }
+    public enum HelpKeywordType {
+        F1Keyword = 0,
+        FilterKeyword = 2,
+        GeneralKeyword = 1,
+    }
+    public interface IComponentChangeService {
+        void OnComponentChanged(object component, MemberDescriptor member, object oldValue, object newValue);
+        void OnComponentChanging(object component, MemberDescriptor member);
+        event ComponentEventHandler ComponentAdded;
+        event ComponentEventHandler ComponentAdding;
+        event ComponentChangedEventHandler ComponentChanged;
+        event ComponentChangingEventHandler ComponentChanging;
+        event ComponentEventHandler ComponentRemoved;
+        event ComponentEventHandler ComponentRemoving;
+        event ComponentRenameEventHandler ComponentRename;
+    }
+    public interface IComponentDiscoveryService {
+        ICollection GetComponentTypes(IDesignerHost designerHost, Type baseType);
+    }
+    public interface IComponentInitializer {
+        void InitializeExistingComponent(IDictionary defaultValues);
+        void InitializeNewComponent(IDictionary defaultValues);
+    }
+    public interface IDesigner : IDisposable {
+        IComponent Component { get; }
+        DesignerVerbCollection Verbs { get; }
+        void DoDefaultAction();
+        void Initialize(IComponent component);
+    }
+    public interface IDesignerEventService {
+        IDesignerHost ActiveDesigner { get; }
+        DesignerCollection Designers { get; }
+        event ActiveDesignerEventHandler ActiveDesignerChanged;
+        event DesignerEventHandler DesignerCreated;
+        event DesignerEventHandler DesignerDisposed;
+        event EventHandler SelectionChanged;
+    }
+    public interface IDesignerFilter {
+        void PostFilterAttributes(IDictionary attributes);
+        void PostFilterEvents(IDictionary events);
+        void PostFilterProperties(IDictionary properties);
+        void PreFilterAttributes(IDictionary attributes);
+        void PreFilterEvents(IDictionary events);
+        void PreFilterProperties(IDictionary properties);
+    }
+    public interface IDesignerHost : IServiceContainer, IServiceProvider {
+        IContainer Container { get; }
+        bool InTransaction { get; }
+        bool Loading { get; }
+        IComponent RootComponent { get; }
+        string RootComponentClassName { get; }
+        string TransactionDescription { get; }
+        void Activate();
+        IComponent CreateComponent(Type componentClass);
+        IComponent CreateComponent(Type componentClass, string name);
+        DesignerTransaction CreateTransaction();
+        DesignerTransaction CreateTransaction(string description);
+        void DestroyComponent(IComponent component);
+        IDesigner GetDesigner(IComponent component);
+        Type GetType(string typeName);
+        event EventHandler Activated;
+        event EventHandler Deactivated;
+        event EventHandler LoadComplete;
+        event DesignerTransactionCloseEventHandler TransactionClosed;
+        event DesignerTransactionCloseEventHandler TransactionClosing;
+        event EventHandler TransactionOpened;
+        event EventHandler TransactionOpening;
+    }
+    public interface IDesignerHostTransactionState {
+        bool IsClosingTransaction { get; }
+    }
+    public interface IDesignerOptionService {
+        object GetOptionValue(string pageName, string valueName);
+        void SetOptionValue(string pageName, string valueName, object value);
+    }
+    public interface IDictionaryService {
+        object GetKey(object value);
+        object GetValue(object key);
+        void SetValue(object key, object value);
+    }
+    public interface IEventBindingService {
+        string CreateUniqueMethodName(IComponent component, EventDescriptor e);
+        ICollection GetCompatibleMethods(EventDescriptor e);
+        EventDescriptor GetEvent(PropertyDescriptor property);
+        PropertyDescriptorCollection GetEventProperties(EventDescriptorCollection events);
+        PropertyDescriptor GetEventProperty(EventDescriptor e);
+        bool ShowCode();
+        bool ShowCode(IComponent component, EventDescriptor e);
+        bool ShowCode(int lineNumber);
+    }
+    public interface IExtenderListService {
+        IExtenderProvider[] GetExtenderProviders();
+    }
+    public interface IExtenderProviderService {
+        void AddExtenderProvider(IExtenderProvider provider);
+        void RemoveExtenderProvider(IExtenderProvider provider);
+    }
+    public interface IHelpService {
+        void AddContextAttribute(string name, string value, HelpKeywordType keywordType);
+        void ClearContextAttributes();
+        IHelpService CreateLocalContext(HelpContextType contextType);
+        void RemoveContextAttribute(string name, string value);
+        void RemoveLocalContext(IHelpService localContext);
+        void ShowHelpFromKeyword(string helpKeyword);
+        void ShowHelpFromUrl(string helpUrl);
+    }
+    public interface IInheritanceService {
+        void AddInheritedComponents(IComponent component, IContainer container);
+        InheritanceAttribute GetInheritanceAttribute(IComponent component);
+    }
+    public interface IMenuCommandService {
+        DesignerVerbCollection Verbs { get; }
+        void AddCommand(MenuCommand command);
+        void AddVerb(DesignerVerb verb);
+        MenuCommand FindCommand(CommandID commandID);
+        bool GlobalInvoke(CommandID commandID);
+        void RemoveCommand(MenuCommand command);
+        void RemoveVerb(DesignerVerb verb);
+        void ShowContextMenu(CommandID menuID, int x, int y);
+    }
+    public interface IReferenceService {
+        IComponent GetComponent(object reference);
+        string GetName(object reference);
+        object GetReference(string name);
+        object[] GetReferences();
+        object[] GetReferences(Type baseType);
+    }
+    public interface IResourceService {
+        IResourceReader GetResourceReader(CultureInfo info);
+        IResourceWriter GetResourceWriter(CultureInfo info);
+    }
+    public interface IRootDesigner : IDesigner, IDisposable {
+        ViewTechnology[] SupportedTechnologies { get; }
+        object GetView(ViewTechnology technology);
+    }
+    public interface ISelectionService {
+        object PrimarySelection { get; }
+        int SelectionCount { get; }
+        bool GetComponentSelected(object component);
+        ICollection GetSelectedComponents();
+        void SetSelectedComponents(ICollection components);
+        void SetSelectedComponents(ICollection components, SelectionTypes selectionType);
+        event EventHandler SelectionChanged;
+        event EventHandler SelectionChanging;
+    }
+    public interface IServiceContainer : IServiceProvider {
+        void AddService(Type serviceType, object serviceInstance);
+        void AddService(Type serviceType, object serviceInstance, bool promote);
+        void AddService(Type serviceType, ServiceCreatorCallback callback);
+        void AddService(Type serviceType, ServiceCreatorCallback callback, bool promote);
+        void RemoveService(Type serviceType);
+        void RemoveService(Type serviceType, bool promote);
+    }
+    public interface ITreeDesigner : IDesigner, IDisposable {
+        ICollection Children { get; }
+        IDesigner Parent { get; }
+    }
+    public interface ITypeDescriptorFilterService {
+        bool FilterAttributes(IComponent component, IDictionary attributes);
+        bool FilterEvents(IComponent component, IDictionary events);
+        bool FilterProperties(IComponent component, IDictionary properties);
+    }
+    public interface ITypeDiscoveryService {
+        ICollection GetTypes(Type baseType, bool excludeGlobalTypes);
+    }
+    public interface ITypeResolutionService {
+        Assembly GetAssembly(AssemblyName name);
+        Assembly GetAssembly(AssemblyName name, bool throwOnError);
+        string GetPathOfAssembly(AssemblyName name);
+        Type GetType(string name);
+        Type GetType(string name, bool throwOnError);
+        Type GetType(string name, bool throwOnError, bool ignoreCase);
+        void ReferenceAssembly(AssemblyName name);
+    }
+    public class MenuCommand {
+        public MenuCommand(EventHandler handler, CommandID command);
+        public virtual bool Checked { get; set; }
+        public virtual CommandID CommandID { get; }
+        public virtual bool Enabled { get; set; }
+        public virtual int OleStatus { get; }
+        public virtual IDictionary Properties { get; }
+        public virtual bool Supported { get; set; }
+        public virtual bool Visible { get; set; }
+        public virtual void Invoke();
+        public virtual void Invoke(object arg);
+        protected virtual void OnCommandChanged(EventArgs e);
+        public override string ToString();
+        public event EventHandler CommandChanged;
+    }
+    public enum SelectionTypes {
+        Add = 64,
+        Auto = 1,
+        Click = 16,
+        MouseDown = 4,
+        MouseUp = 8,
+        Normal = 1,
+        Primary = 16,
+        Remove = 128,
+        Replace = 2,
+        Toggle = 32,
+        Valid = 31,
+    }
+    public class ServiceContainer : IDisposable, IServiceContainer, IServiceProvider {
+        public ServiceContainer();
+        public ServiceContainer(IServiceProvider parentProvider);
+        protected virtual Type[] DefaultServices { get; }
+        public void AddService(Type serviceType, object serviceInstance);
+        public virtual void AddService(Type serviceType, object serviceInstance, bool promote);
+        public void AddService(Type serviceType, ServiceCreatorCallback callback);
+        public virtual void AddService(Type serviceType, ServiceCreatorCallback callback, bool promote);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual object GetService(Type serviceType);
+        public void RemoveService(Type serviceType);
+        public virtual void RemoveService(Type serviceType, bool promote);
+    }
+    public delegate object ServiceCreatorCallback(IServiceContainer container, Type serviceType); {
+        public ServiceCreatorCallback(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(IServiceContainer container, Type serviceType, AsyncCallback callback, object @object);
+        public virtual object EndInvoke(IAsyncResult result);
+        public virtual object Invoke(IServiceContainer container, Type serviceType);
+    }
+    public class StandardCommands {
+        public static readonly CommandID AlignBottom;
+        public static readonly CommandID AlignHorizontalCenters;
+        public static readonly CommandID AlignLeft;
+        public static readonly CommandID AlignRight;
+        public static readonly CommandID AlignToGrid;
+        public static readonly CommandID AlignTop;
+        public static readonly CommandID AlignVerticalCenters;
+        public static readonly CommandID ArrangeBottom;
+        public static readonly CommandID ArrangeIcons;
+        public static readonly CommandID ArrangeRight;
+        public static readonly CommandID BringForward;
+        public static readonly CommandID BringToFront;
+        public static readonly CommandID CenterHorizontally;
+        public static readonly CommandID CenterVertically;
+        public static readonly CommandID Copy;
+        public static readonly CommandID Cut;
+        public static readonly CommandID Delete;
+        public static readonly CommandID DocumentOutline;
+        public static readonly CommandID F1Help;
+        public static readonly CommandID Group;
+        public static readonly CommandID HorizSpaceConcatenate;
+        public static readonly CommandID HorizSpaceDecrease;
+        public static readonly CommandID HorizSpaceIncrease;
+        public static readonly CommandID HorizSpaceMakeEqual;
+        public static readonly CommandID LineupIcons;
+        public static readonly CommandID LockControls;
+        public static readonly CommandID MultiLevelRedo;
+        public static readonly CommandID MultiLevelUndo;
+        public static readonly CommandID Paste;
+        public static readonly CommandID Properties;
+        public static readonly CommandID PropertiesWindow;
+        public static readonly CommandID Redo;
+        public static readonly CommandID Replace;
+        public static readonly CommandID SelectAll;
+        public static readonly CommandID SendBackward;
+        public static readonly CommandID SendToBack;
+        public static readonly CommandID ShowGrid;
+        public static readonly CommandID ShowLargeIcons;
+        public static readonly CommandID SizeToControl;
+        public static readonly CommandID SizeToControlHeight;
+        public static readonly CommandID SizeToControlWidth;
+        public static readonly CommandID SizeToFit;
+        public static readonly CommandID SizeToGrid;
+        public static readonly CommandID SnapToGrid;
+        public static readonly CommandID TabOrder;
+        public static readonly CommandID Undo;
+        public static readonly CommandID Ungroup;
+        public static readonly CommandID VerbFirst;
+        public static readonly CommandID VerbLast;
+        public static readonly CommandID VertSpaceConcatenate;
+        public static readonly CommandID VertSpaceDecrease;
+        public static readonly CommandID VertSpaceIncrease;
+        public static readonly CommandID VertSpaceMakeEqual;
+        public static readonly CommandID ViewCode;
+        public static readonly CommandID ViewGrid;
+        public StandardCommands();
+    }
+    public class StandardToolWindows {
+        public static readonly Guid ObjectBrowser;
+        public static readonly Guid OutputWindow;
+        public static readonly Guid ProjectExplorer;
+        public static readonly Guid PropertyBrowser;
+        public static readonly Guid RelatedLinks;
+        public static readonly Guid ServerExplorer;
+        public static readonly Guid TaskList;
+        public static readonly Guid Toolbox;
+        public StandardToolWindows();
+    }
+    public abstract class TypeDescriptionProviderService {
+        protected TypeDescriptionProviderService();
+        public abstract TypeDescriptionProvider GetProvider(object instance);
+        public abstract TypeDescriptionProvider GetProvider(Type type);
+    }
+    public enum ViewTechnology {
+        Default = 2,
+        Passthrough = 0,
+        WindowsForms = 1,
+    }
+}
+namespace System.ComponentModel.Design.Serialization {
+    public abstract class ComponentSerializationService {
+        protected ComponentSerializationService();
+        public abstract SerializationStore CreateStore();
+        public abstract ICollection Deserialize(SerializationStore store);
+        public abstract ICollection Deserialize(SerializationStore store, IContainer container);
+        public void DeserializeTo(SerializationStore store, IContainer container);
+        public void DeserializeTo(SerializationStore store, IContainer container, bool validateRecycledTypes);
+        public abstract void DeserializeTo(SerializationStore store, IContainer container, bool validateRecycledTypes, bool applyDefaults);
+        public abstract SerializationStore LoadStore(Stream stream);
+        public abstract void Serialize(SerializationStore store, object value);
+        public abstract void SerializeAbsolute(SerializationStore store, object value);
+        public abstract void SerializeMember(SerializationStore store, object owningObject, MemberDescriptor member);
+        public abstract void SerializeMemberAbsolute(SerializationStore store, object owningObject, MemberDescriptor member);
+    }
+    public sealed class ContextStack {
+        public ContextStack();
+        public object Current { get; }
+        public object this[int level] { get; }
+        public object this[Type type] { get; }
+        public void Append(object context);
+        public object Pop();
+        public void Push(object context);
+    }
+    public sealed class DefaultSerializationProviderAttribute : Attribute {
+        public DefaultSerializationProviderAttribute(string providerTypeName);
+        public DefaultSerializationProviderAttribute(Type providerType);
+        public string ProviderTypeName { get; }
+    }
+    public abstract class DesignerLoader {
+        protected DesignerLoader();
+        public virtual bool Loading { get; }
+        public abstract void BeginLoad(IDesignerLoaderHost host);
+        public abstract void Dispose();
+        public virtual void Flush();
+    }
+    public sealed class DesignerSerializerAttribute : Attribute {
+        public DesignerSerializerAttribute(string serializerTypeName, string baseSerializerTypeName);
+        public DesignerSerializerAttribute(string serializerTypeName, Type baseSerializerType);
+        public DesignerSerializerAttribute(Type serializerType, Type baseSerializerType);
+        public string SerializerBaseTypeName { get; }
+        public string SerializerTypeName { get; }
+        public override object TypeId { get; }
+    }
+    public interface IDesignerLoaderHost : IDesignerHost, IServiceContainer, IServiceProvider {
+        void EndLoad(string baseClassName, bool successful, ICollection errorCollection);
+        void Reload();
+    }
+    public interface IDesignerLoaderHost2 : IDesignerHost, IDesignerLoaderHost, IServiceContainer, IServiceProvider {
+        bool CanReloadWithErrors { get; set; }
+        bool IgnoreErrorsDuringReload { get; set; }
+    }
+    public interface IDesignerLoaderService {
+        void AddLoadDependency();
+        void DependentLoadComplete(bool successful, ICollection errorCollection);
+        bool Reload();
+    }
+    public interface IDesignerSerializationManager : IServiceProvider {
+        ContextStack Context { get; }
+        PropertyDescriptorCollection Properties { get; }
+        void AddSerializationProvider(IDesignerSerializationProvider provider);
+        object CreateInstance(Type type, ICollection arguments, string name, bool addToContainer);
+        object GetInstance(string name);
+        string GetName(object value);
+        object GetSerializer(Type objectType, Type serializerType);
+        Type GetType(string typeName);
+        void RemoveSerializationProvider(IDesignerSerializationProvider provider);
+        void ReportError(object errorInformation);
+        void SetName(object instance, string name);
+        event ResolveNameEventHandler ResolveName;
+        event EventHandler SerializationComplete;
+    }
+    public interface IDesignerSerializationProvider {
+        object GetSerializer(IDesignerSerializationManager manager, object currentSerializer, Type objectType, Type serializerType);
+    }
+    public interface IDesignerSerializationService {
+        ICollection Deserialize(object serializationData);
+        object Serialize(ICollection objects);
+    }
+    public interface INameCreationService {
+        string CreateName(IContainer container, Type dataType);
+        bool IsValidName(string name);
+        void ValidateName(string name);
+    }
+    public sealed class InstanceDescriptor {
+        public InstanceDescriptor(MemberInfo member, ICollection arguments);
+        public InstanceDescriptor(MemberInfo member, ICollection arguments, bool isComplete);
+        public ICollection Arguments { get; }
+        public bool IsComplete { get; }
+        public MemberInfo MemberInfo { get; }
+        public object Invoke();
+    }
+    public struct MemberRelationship {
+        public static readonly MemberRelationship Empty;
+        public MemberRelationship(object owner, MemberDescriptor member);
+        public bool IsEmpty { get; }
+        public MemberDescriptor Member { get; }
+        public object Owner { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(MemberRelationship left, MemberRelationship right);
+        public static bool operator !=(MemberRelationship left, MemberRelationship right);
+    }
+    public abstract class MemberRelationshipService {
+        protected MemberRelationshipService();
+        public MemberRelationship this[MemberRelationship source] { get; set; }
+        public MemberRelationship this[object sourceOwner, MemberDescriptor sourceMember] { get; set; }
+        protected virtual MemberRelationship GetRelationship(MemberRelationship source);
+        protected virtual void SetRelationship(MemberRelationship source, MemberRelationship relationship);
+        public abstract bool SupportsRelationship(MemberRelationship source, MemberRelationship relationship);
+    }
+    public class ResolveNameEventArgs : EventArgs {
+        public ResolveNameEventArgs(string name);
+        public string Name { get; }
+        public object Value { get; set; }
+    }
+    public delegate void ResolveNameEventHandler(object sender, ResolveNameEventArgs e); {
+        public ResolveNameEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ResolveNameEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ResolveNameEventArgs e);
+    }
+    public sealed class RootDesignerSerializerAttribute : Attribute {
+        public RootDesignerSerializerAttribute(string serializerTypeName, string baseSerializerTypeName, bool reloadable);
+        public RootDesignerSerializerAttribute(string serializerTypeName, Type baseSerializerType, bool reloadable);
+        public RootDesignerSerializerAttribute(Type serializerType, Type baseSerializerType, bool reloadable);
+        public bool Reloadable { get; }
+        public string SerializerBaseTypeName { get; }
+        public string SerializerTypeName { get; }
+        public override object TypeId { get; }
+    }
+    public abstract class SerializationStore : IDisposable {
+        protected SerializationStore();
+        public abstract ICollection Errors { get; }
+        public abstract void Close();
+        protected virtual void Dispose(bool disposing);
+        public abstract void Save(Stream stream);
+    }
+}
+namespace System.Configuration.Assemblies {
+    public enum AssemblyHashAlgorithm {
+        MD5 = 32771,
+        None = 0,
+        SHA1 = 32772,
+        SHA256 = 32780,
+        SHA384 = 32781,
+        SHA512 = 32782,
+    }
+    public enum AssemblyVersionCompatibility {
+        SameDomain = 3,
+        SameMachine = 1,
+        SameProcess = 2,
+    }
+}
+namespace System.Data {
+    public enum AcceptRejectRule {
+        Cascade = 1,
+        None = 0,
+    }
+    public enum CommandBehavior {
+        CloseConnection = 32,
+        Default = 0,
+        KeyInfo = 4,
+        SchemaOnly = 2,
+        SequentialAccess = 16,
+        SingleResult = 1,
+        SingleRow = 8,
+    }
+    public enum CommandType {
+        StoredProcedure = 4,
+        TableDirect = 512,
+        Text = 1,
+    }
+    public enum ConflictOption {
+        CompareAllSearchableValues = 1,
+        CompareRowVersion = 2,
+        OverwriteChanges = 3,
+    }
+    public enum ConnectionState {
+        Broken = 16,
+        Closed = 0,
+        Connecting = 2,
+        Executing = 4,
+        Fetching = 8,
+        Open = 1,
+    }
+    public abstract class Constraint {
+        protected Constraint();
+        public virtual string ConstraintName { get; set; }
+        public PropertyCollection ExtendedProperties { get; }
+        public abstract DataTable Table { get; }
+        protected virtual DataSet _DataSet { get; }
+        protected void CheckStateForProperty();
+        protected internal void SetDataSet(DataSet dataSet);
+        public override string ToString();
+    }
+    public sealed class ConstraintCollection : InternalDataCollectionBase {
+        public Constraint this[int index] { get; }
+        public Constraint this[string name] { get; }
+        public void Add(Constraint constraint);
+        public Constraint Add(string name, DataColumn column, bool primaryKey);
+        public Constraint Add(string name, DataColumn primaryKeyColumn, DataColumn foreignKeyColumn);
+        public Constraint Add(string name, DataColumn[] columns, bool primaryKey);
+        public Constraint Add(string name, DataColumn[] primaryKeyColumns, DataColumn[] foreignKeyColumns);
+        public void AddRange(Constraint[] constraints);
+        public bool CanRemove(Constraint constraint);
+        public void Clear();
+        public bool Contains(string name);
+        public void CopyTo(Constraint[] array, int index);
+        public int IndexOf(Constraint constraint);
+        public int IndexOf(string constraintName);
+        public void Remove(Constraint constraint);
+        public void Remove(string name);
+        public void RemoveAt(int index);
+        public event CollectionChangeEventHandler CollectionChanged;
+    }
+    public class ConstraintException : DataException {
+        public ConstraintException();
+        protected ConstraintException(SerializationInfo info, StreamingContext context);
+        public ConstraintException(string s);
+        public ConstraintException(string message, Exception innerException);
+    }
+    public class DataColumn : MarshalByValueComponent {
+        public DataColumn();
+        public DataColumn(string columnName);
+        public DataColumn(string columnName, Type dataType);
+        public DataColumn(string columnName, Type dataType, string expr);
+        public DataColumn(string columnName, Type dataType, string expr, MappingType type);
+        public bool AllowDBNull { get; set; }
+        public bool AutoIncrement { get; set; }
+        public long AutoIncrementSeed { get; set; }
+        public long AutoIncrementStep { get; set; }
+        public string Caption { get; set; }
+        public virtual MappingType ColumnMapping { get; set; }
+        public string ColumnName { get; set; }
+        public Type DataType { get; set; }
+        public DataSetDateTime DateTimeMode { get; set; }
+        public object DefaultValue { get; set; }
+        public string Expression { get; set; }
+        public PropertyCollection ExtendedProperties { get; }
+        public int MaxLength { get; set; }
+        public string Namespace { get; set; }
+        public int Ordinal { get; }
+        public string Prefix { get; set; }
+        public bool ReadOnly { get; set; }
+        public DataTable Table { get; }
+        public bool Unique { get; set; }
+        protected internal void CheckNotAllowNull();
+        protected void CheckUnique();
+        protected virtual void OnPropertyChanging(PropertyChangedEventArgs pcevent);
+        protected internal void RaisePropertyChanging(string name);
+        public void SetOrdinal(int ordinal);
+        public override string ToString();
+    }
+    public class DataColumnChangeEventArgs : EventArgs {
+        public DataColumnChangeEventArgs(DataRow row, DataColumn column, object value);
+        public DataColumn Column { get; }
+        public object ProposedValue { get; set; }
+        public DataRow Row { get; }
+    }
+    public delegate void DataColumnChangeEventHandler(object sender, DataColumnChangeEventArgs e); {
+        public DataColumnChangeEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DataColumnChangeEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DataColumnChangeEventArgs e);
+    }
+    public sealed class DataColumnCollection : InternalDataCollectionBase {
+        public DataColumn this[int index] { get; }
+        public DataColumn this[string name] { get; }
+        public DataColumn Add();
+        public void Add(DataColumn column);
+        public DataColumn Add(string columnName);
+        public DataColumn Add(string columnName, Type type);
+        public DataColumn Add(string columnName, Type type, string expression);
+        public void AddRange(DataColumn[] columns);
+        public bool CanRemove(DataColumn column);
+        public void Clear();
+        public bool Contains(string name);
+        public void CopyTo(DataColumn[] array, int index);
+        public int IndexOf(DataColumn column);
+        public int IndexOf(string columnName);
+        public void Remove(DataColumn column);
+        public void Remove(string name);
+        public void RemoveAt(int index);
+        public event CollectionChangeEventHandler CollectionChanged;
+    }
+    public class DataException : SystemException {
+        public DataException();
+        protected DataException(SerializationInfo info, StreamingContext context);
+        public DataException(string s);
+        public DataException(string s, Exception innerException);
+    }
+    public class DataRelation {
+        public DataRelation(string relationName, DataColumn parentColumn, DataColumn childColumn);
+        public DataRelation(string relationName, DataColumn parentColumn, DataColumn childColumn, bool createConstraints);
+        public DataRelation(string relationName, DataColumn[] parentColumns, DataColumn[] childColumns);
+        public DataRelation(string relationName, DataColumn[] parentColumns, DataColumn[] childColumns, bool createConstraints);
+        public DataRelation(string relationName, string parentTableName, string parentTableNamespace, string childTableName, string childTableNamespace, string[] parentColumnNames, string[] childColumnNames, bool nested);
+        public DataRelation(string relationName, string parentTableName, string childTableName, string[] parentColumnNames, string[] childColumnNames, bool nested);
+        public virtual DataColumn[] ChildColumns { get; }
+        public virtual ForeignKeyConstraint ChildKeyConstraint { get; }
+        public virtual DataTable ChildTable { get; }
+        public virtual DataSet DataSet { get; }
+        public PropertyCollection ExtendedProperties { get; }
+        public virtual bool Nested { get; set; }
+        public virtual DataColumn[] ParentColumns { get; }
+        public virtual UniqueConstraint ParentKeyConstraint { get; }
+        public virtual DataTable ParentTable { get; }
+        public virtual string RelationName { get; set; }
+        protected void CheckStateForProperty();
+        protected internal void OnPropertyChanging(PropertyChangedEventArgs pcevent);
+        protected internal void RaisePropertyChanging(string name);
+        public override string ToString();
+    }
+    public abstract class DataRelationCollection : InternalDataCollectionBase {
+        protected DataRelationCollection();
+        public abstract DataRelation this[int index] { get; }
+        public abstract DataRelation this[string name] { get; }
+        public virtual DataRelation Add(DataColumn parentColumn, DataColumn childColumn);
+        public virtual DataRelation Add(DataColumn[] parentColumns, DataColumn[] childColumns);
+        public void Add(DataRelation relation);
+        public virtual DataRelation Add(string name, DataColumn parentColumn, DataColumn childColumn);
+        public virtual DataRelation Add(string name, DataColumn parentColumn, DataColumn childColumn, bool createConstraints);
+        public virtual DataRelation Add(string name, DataColumn[] parentColumns, DataColumn[] childColumns);
+        public virtual DataRelation Add(string name, DataColumn[] parentColumns, DataColumn[] childColumns, bool createConstraints);
+        protected virtual void AddCore(DataRelation relation);
+        public virtual void AddRange(DataRelation[] relations);
+        public virtual bool CanRemove(DataRelation relation);
+        public virtual void Clear();
+        public virtual bool Contains(string name);
+        public void CopyTo(DataRelation[] array, int index);
+        protected abstract DataSet GetDataSet();
+        public virtual int IndexOf(DataRelation relation);
+        public virtual int IndexOf(string relationName);
+        protected virtual void OnCollectionChanged(CollectionChangeEventArgs ccevent);
+        protected virtual void OnCollectionChanging(CollectionChangeEventArgs ccevent);
+        public void Remove(DataRelation relation);
+        public void Remove(string name);
+        public void RemoveAt(int index);
+        protected virtual void RemoveCore(DataRelation relation);
+        public event CollectionChangeEventHandler CollectionChanged;
+    }
+    public class DataRow {
+        protected internal DataRow(DataRowBuilder builder);
+        public bool HasErrors { get; }
+        public object[] ItemArray { get; set; }
+        public object this[DataColumn column, DataRowVersion version] { get; }
+        public object this[DataColumn column] { get; set; }
+        public object this[int columnIndex, DataRowVersion version] { get; }
+        public object this[int columnIndex] { get; set; }
+        public object this[string columnName, DataRowVersion version] { get; }
+        public object this[string columnName] { get; set; }
+        public string RowError { get; set; }
+        public DataRowState RowState { get; }
+        public DataTable Table { get; }
+        public void AcceptChanges();
+        public void BeginEdit();
+        public void CancelEdit();
+        public void ClearErrors();
+        public void Delete();
+        public void EndEdit();
+        public DataRow[] GetChildRows(DataRelation relation);
+        public DataRow[] GetChildRows(DataRelation relation, DataRowVersion version);
+        public DataRow[] GetChildRows(string relationName);
+        public DataRow[] GetChildRows(string relationName, DataRowVersion version);
+        public string GetColumnError(DataColumn column);
+        public string GetColumnError(int columnIndex);
+        public string GetColumnError(string columnName);
+        public DataColumn[] GetColumnsInError();
+        public DataRow GetParentRow(DataRelation relation);
+        public DataRow GetParentRow(DataRelation relation, DataRowVersion version);
+        public DataRow GetParentRow(string relationName);
+        public DataRow GetParentRow(string relationName, DataRowVersion version);
+        public DataRow[] GetParentRows(DataRelation relation);
+        public DataRow[] GetParentRows(DataRelation relation, DataRowVersion version);
+        public DataRow[] GetParentRows(string relationName);
+        public DataRow[] GetParentRows(string relationName, DataRowVersion version);
+        public bool HasVersion(DataRowVersion version);
+        public bool IsNull(DataColumn column);
+        public bool IsNull(DataColumn column, DataRowVersion version);
+        public bool IsNull(int columnIndex);
+        public bool IsNull(string columnName);
+        public void RejectChanges();
+        public void SetAdded();
+        public void SetColumnError(DataColumn column, string error);
+        public void SetColumnError(int columnIndex, string error);
+        public void SetColumnError(string columnName, string error);
+        public void SetModified();
+        protected void SetNull(DataColumn column);
+        public void SetParentRow(DataRow parentRow);
+        public void SetParentRow(DataRow parentRow, DataRelation relation);
+    }
+    public enum DataRowAction {
+        Add = 16,
+        Change = 2,
+        ChangeCurrentAndOriginal = 64,
+        ChangeOriginal = 32,
+        Commit = 8,
+        Delete = 1,
+        Nothing = 0,
+        Rollback = 4,
+    }
+    public sealed class DataRowBuilder
+    public class DataRowChangeEventArgs : EventArgs {
+        public DataRowChangeEventArgs(DataRow row, DataRowAction action);
+        public DataRowAction Action { get; }
+        public DataRow Row { get; }
+    }
+    public delegate void DataRowChangeEventHandler(object sender, DataRowChangeEventArgs e); {
+        public DataRowChangeEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DataRowChangeEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DataRowChangeEventArgs e);
+    }
+    public sealed class DataRowCollection : InternalDataCollectionBase {
+        public override int Count { get; }
+        public DataRow this[int index] { get; }
+        public void Add(DataRow row);
+        public DataRow Add(params object[] values);
+        public void Clear();
+        public bool Contains(object key);
+        public bool Contains(object[] keys);
+        public override void CopyTo(Array ar, int index);
+        public void CopyTo(DataRow[] array, int index);
+        public DataRow Find(object key);
+        public DataRow Find(object[] keys);
+        public override IEnumerator GetEnumerator();
+        public int IndexOf(DataRow row);
+        public void InsertAt(DataRow row, int pos);
+        public void Remove(DataRow row);
+        public void RemoveAt(int index);
+    }
+    public enum DataRowState {
+        Added = 4,
+        Deleted = 8,
+        Detached = 1,
+        Modified = 16,
+        Unchanged = 2,
+    }
+    public enum DataRowVersion {
+        Current = 512,
+        Default = 1536,
+        Original = 256,
+        Proposed = 1024,
+    }
+    public class DataRowView : ICustomTypeDescriptor, IDataErrorInfo, IEditableObject, INotifyPropertyChanged {
+        public DataView DataView { get; }
+        public bool IsEdit { get; }
+        public bool IsNew { get; }
+        public object this[int ndx] { get; set; }
+        public object this[string property] { get; set; }
+        public DataRow Row { get; }
+        public DataRowVersion RowVersion { get; }
+        public void BeginEdit();
+        public void CancelEdit();
+        public DataView CreateChildView(DataRelation relation);
+        public DataView CreateChildView(DataRelation relation, bool followParent);
+        public DataView CreateChildView(string relationName);
+        public DataView CreateChildView(string relationName, bool followParent);
+        public void Delete();
+        public void EndEdit();
+        public override bool Equals(object other);
+        public override int GetHashCode();
+        public event PropertyChangedEventHandler PropertyChanged;
+    }
+    public class DataSet : MarshalByValueComponent, IListSource, ISerializable, ISupportInitialize, ISupportInitializeNotification, IXmlSerializable {
+        public DataSet();
+        protected DataSet(SerializationInfo info, StreamingContext context);
+        protected DataSet(SerializationInfo info, StreamingContext context, bool ConstructSchema);
+        public DataSet(string dataSetName);
+        public bool CaseSensitive { get; set; }
+        public string DataSetName { get; set; }
+        public DataViewManager DefaultViewManager { get; }
+        public bool EnforceConstraints { get; set; }
+        public PropertyCollection ExtendedProperties { get; }
+        public bool HasErrors { get; }
+        public bool IsInitialized { get; }
+        public CultureInfo Locale { get; set; }
+        public string Namespace { get; set; }
+        public string Prefix { get; set; }
+        public DataRelationCollection Relations { get; }
+        public SerializationFormat RemotingFormat { get; set; }
+        public virtual SchemaSerializationMode SchemaSerializationMode { get; set; }
+        public override ISite Site { get; set; }
+        public DataTableCollection Tables { get; }
+        public void AcceptChanges();
+        public void BeginInit();
+        public void Clear();
+        public virtual DataSet Clone();
+        public DataSet Copy();
+        public DataTableReader CreateDataReader();
+        public DataTableReader CreateDataReader(params DataTable[] dataTables);
+        protected SchemaSerializationMode DetermineSchemaSerializationMode(SerializationInfo info, StreamingContext context);
+        protected SchemaSerializationMode DetermineSchemaSerializationMode(XmlReader reader);
+        public void EndInit();
+        public DataSet GetChanges();
+        public DataSet GetChanges(DataRowState rowStates);
+        public static XmlSchemaComplexType GetDataSetSchema(XmlSchemaSet schemaSet);
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        protected virtual XmlSchema GetSchemaSerializable();
+        protected void GetSerializationData(SerializationInfo info, StreamingContext context);
+        public string GetXml();
+        public string GetXmlSchema();
+        public bool HasChanges();
+        public bool HasChanges(DataRowState rowStates);
+        public void InferXmlSchema(Stream stream, string[] nsArray);
+        public void InferXmlSchema(string fileName, string[] nsArray);
+        public void InferXmlSchema(TextReader reader, string[] nsArray);
+        public void InferXmlSchema(XmlReader reader, string[] nsArray);
+        protected virtual void InitializeDerivedDataSet();
+        protected bool IsBinarySerialized(SerializationInfo info, StreamingContext context);
+        public void Load(IDataReader reader, LoadOption loadOption, params DataTable[] tables);
+        public virtual void Load(IDataReader reader, LoadOption loadOption, FillErrorEventHandler errorHandler, params DataTable[] tables);
+        public void Load(IDataReader reader, LoadOption loadOption, params string[] tables);
+        public void Merge(DataRow[] rows);
+        public void Merge(DataRow[] rows, bool preserveChanges, MissingSchemaAction missingSchemaAction);
+        public void Merge(DataSet dataSet);
+        public void Merge(DataSet dataSet, bool preserveChanges);
+        public void Merge(DataSet dataSet, bool preserveChanges, MissingSchemaAction missingSchemaAction);
+        public void Merge(DataTable table);
+        public void Merge(DataTable table, bool preserveChanges, MissingSchemaAction missingSchemaAction);
+        protected virtual void OnPropertyChanging(PropertyChangedEventArgs pcevent);
+        protected virtual void OnRemoveRelation(DataRelation relation);
+        protected internal virtual void OnRemoveTable(DataTable table);
+        protected internal void RaisePropertyChanging(string name);
+        public XmlReadMode ReadXml(Stream stream);
+        public XmlReadMode ReadXml(Stream stream, XmlReadMode mode);
+        public XmlReadMode ReadXml(string fileName);
+        public XmlReadMode ReadXml(string fileName, XmlReadMode mode);
+        public XmlReadMode ReadXml(TextReader reader);
+        public XmlReadMode ReadXml(TextReader reader, XmlReadMode mode);
+        public XmlReadMode ReadXml(XmlReader reader);
+        public XmlReadMode ReadXml(XmlReader reader, XmlReadMode mode);
+        public void ReadXmlSchema(Stream stream);
+        public void ReadXmlSchema(string fileName);
+        public void ReadXmlSchema(TextReader reader);
+        public void ReadXmlSchema(XmlReader reader);
+        protected virtual void ReadXmlSerializable(XmlReader reader);
+        public virtual void RejectChanges();
+        public virtual void Reset();
+        protected virtual bool ShouldSerializeRelations();
+        protected virtual bool ShouldSerializeTables();
+        public void WriteXml(Stream stream);
+        public void WriteXml(Stream stream, XmlWriteMode mode);
+        public void WriteXml(string fileName);
+        public void WriteXml(string fileName, XmlWriteMode mode);
+        public void WriteXml(TextWriter writer);
+        public void WriteXml(TextWriter writer, XmlWriteMode mode);
+        public void WriteXml(XmlWriter writer);
+        public void WriteXml(XmlWriter writer, XmlWriteMode mode);
+        public void WriteXmlSchema(Stream stream);
+        public void WriteXmlSchema(Stream stream, Converter<Type, string> multipleTargetConverter);
+        public void WriteXmlSchema(string fileName);
+        public void WriteXmlSchema(string fileName, Converter<Type, string> multipleTargetConverter);
+        public void WriteXmlSchema(TextWriter writer);
+        public void WriteXmlSchema(TextWriter writer, Converter<Type, string> multipleTargetConverter);
+        public void WriteXmlSchema(XmlWriter writer);
+        public void WriteXmlSchema(XmlWriter writer, Converter<Type, string> multipleTargetConverter);
+        public event EventHandler Initialized;
+        public event MergeFailedEventHandler MergeFailed;
+    }
+    public enum DataSetDateTime {
+        Local = 1,
+        Unspecified = 2,
+        UnspecifiedLocal = 3,
+        Utc = 4,
+    }
+    public class DataSysDescriptionAttribute : DescriptionAttribute {
+        public DataSysDescriptionAttribute(string description);
+        public override string Description { get; }
+    }
+    public class DataTable : MarshalByValueComponent, IListSource, ISerializable, ISupportInitialize, ISupportInitializeNotification, IXmlSerializable {
+        protected internal bool fInitInProgress;
+        public DataTable();
+        protected DataTable(SerializationInfo info, StreamingContext context);
+        public DataTable(string tableName);
+        public DataTable(string tableName, string tableNamespace);
+        public bool CaseSensitive { get; set; }
+        public DataRelationCollection ChildRelations { get; }
+        public DataColumnCollection Columns { get; }
+        public ConstraintCollection Constraints { get; }
+        public DataSet DataSet { get; }
+        public DataView DefaultView { get; }
+        public string DisplayExpression { get; set; }
+        public PropertyCollection ExtendedProperties { get; }
+        public bool HasErrors { get; }
+        public bool IsInitialized { get; }
+        public CultureInfo Locale { get; set; }
+        public int MinimumCapacity { get; set; }
+        public string Namespace { get; set; }
+        public DataRelationCollection ParentRelations { get; }
+        public string Prefix { get; set; }
+        public DataColumn[] PrimaryKey { get; set; }
+        public SerializationFormat RemotingFormat { get; set; }
+        public DataRowCollection Rows { get; }
+        public override ISite Site { get; set; }
+        public string TableName { get; set; }
+        public void AcceptChanges();
+        public virtual void BeginInit();
+        public void BeginLoadData();
+        public void Clear();
+        public virtual DataTable Clone();
+        public object Compute(string expression, string filter);
+        public DataTable Copy();
+        public DataTableReader CreateDataReader();
+        protected virtual DataTable CreateInstance();
+        public virtual void EndInit();
+        public void EndLoadData();
+        public DataTable GetChanges();
+        public DataTable GetChanges(DataRowState rowStates);
+        public static XmlSchemaComplexType GetDataTableSchema(XmlSchemaSet schemaSet);
+        public DataRow[] GetErrors();
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        protected virtual Type GetRowType();
+        protected virtual XmlSchema GetSchema();
+        public void ImportRow(DataRow row);
+        public void Load(IDataReader reader);
+        public void Load(IDataReader reader, LoadOption loadOption);
+        public virtual void Load(IDataReader reader, LoadOption loadOption, FillErrorEventHandler errorHandler);
+        public DataRow LoadDataRow(object[] values, bool fAcceptChanges);
+        public DataRow LoadDataRow(object[] values, LoadOption loadOption);
+        public void Merge(DataTable table);
+        public void Merge(DataTable table, bool preserveChanges);
+        public void Merge(DataTable table, bool preserveChanges, MissingSchemaAction missingSchemaAction);
+        public DataRow NewRow();
+        protected internal DataRow[] NewRowArray(int size);
+        protected virtual DataRow NewRowFromBuilder(DataRowBuilder builder);
+        protected internal virtual void OnColumnChanged(DataColumnChangeEventArgs e);
+        protected internal virtual void OnColumnChanging(DataColumnChangeEventArgs e);
+        protected virtual void OnPropertyChanging(PropertyChangedEventArgs pcevent);
+        protected virtual void OnRemoveColumn(DataColumn column);
+        protected virtual void OnRowChanged(DataRowChangeEventArgs e);
+        protected virtual void OnRowChanging(DataRowChangeEventArgs e);
+        protected virtual void OnRowDeleted(DataRowChangeEventArgs e);
+        protected virtual void OnRowDeleting(DataRowChangeEventArgs e);
+        protected virtual void OnTableCleared(DataTableClearEventArgs e);
+        protected virtual void OnTableClearing(DataTableClearEventArgs e);
+        protected virtual void OnTableNewRow(DataTableNewRowEventArgs e);
+        public XmlReadMode ReadXml(Stream stream);
+        public XmlReadMode ReadXml(string fileName);
+        public XmlReadMode ReadXml(TextReader reader);
+        public XmlReadMode ReadXml(XmlReader reader);
+        public void ReadXmlSchema(Stream stream);
+        public void ReadXmlSchema(string fileName);
+        public void ReadXmlSchema(TextReader reader);
+        public void ReadXmlSchema(XmlReader reader);
+        protected virtual void ReadXmlSerializable(XmlReader reader);
+        public void RejectChanges();
+        public virtual void Reset();
+        public DataRow[] Select();
+        public DataRow[] Select(string filterExpression);
+        public DataRow[] Select(string filterExpression, string sort);
+        public DataRow[] Select(string filterExpression, string sort, DataViewRowState recordStates);
+        public override string ToString();
+        public void WriteXml(Stream stream);
+        public void WriteXml(Stream stream, bool writeHierarchy);
+        public void WriteXml(Stream stream, XmlWriteMode mode);
+        public void WriteXml(Stream stream, XmlWriteMode mode, bool writeHierarchy);
+        public void WriteXml(string fileName);
+        public void WriteXml(string fileName, bool writeHierarchy);
+        public void WriteXml(string fileName, XmlWriteMode mode);
+        public void WriteXml(string fileName, XmlWriteMode mode, bool writeHierarchy);
+        public void WriteXml(TextWriter writer);
+        public void WriteXml(TextWriter writer, bool writeHierarchy);
+        public void WriteXml(TextWriter writer, XmlWriteMode mode);
+        public void WriteXml(TextWriter writer, XmlWriteMode mode, bool writeHierarchy);
+        public void WriteXml(XmlWriter writer);
+        public void WriteXml(XmlWriter writer, bool writeHierarchy);
+        public void WriteXml(XmlWriter writer, XmlWriteMode mode);
+        public void WriteXml(XmlWriter writer, XmlWriteMode mode, bool writeHierarchy);
+        public void WriteXmlSchema(Stream stream);
+        public void WriteXmlSchema(Stream stream, bool writeHierarchy);
+        public void WriteXmlSchema(string fileName);
+        public void WriteXmlSchema(string fileName, bool writeHierarchy);
+        public void WriteXmlSchema(TextWriter writer);
+        public void WriteXmlSchema(TextWriter writer, bool writeHierarchy);
+        public void WriteXmlSchema(XmlWriter writer);
+        public void WriteXmlSchema(XmlWriter writer, bool writeHierarchy);
+        public event DataColumnChangeEventHandler ColumnChanged;
+        public event DataColumnChangeEventHandler ColumnChanging;
+        public event EventHandler Initialized;
+        public event DataRowChangeEventHandler RowChanged;
+        public event DataRowChangeEventHandler RowChanging;
+        public event DataRowChangeEventHandler RowDeleted;
+        public event DataRowChangeEventHandler RowDeleting;
+        public event DataTableClearEventHandler TableCleared;
+        public event DataTableClearEventHandler TableClearing;
+        public event DataTableNewRowEventHandler TableNewRow;
+    }
+    public sealed class DataTableClearEventArgs : EventArgs {
+        public DataTableClearEventArgs(DataTable dataTable);
+        public DataTable Table { get; }
+        public string TableName { get; }
+        public string TableNamespace { get; }
+    }
+    public delegate void DataTableClearEventHandler(object sender, DataTableClearEventArgs e); {
+        public DataTableClearEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DataTableClearEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DataTableClearEventArgs e);
+    }
+    public sealed class DataTableCollection : InternalDataCollectionBase {
+        public DataTable this[int index] { get; }
+        public DataTable this[string name, string tableNamespace] { get; }
+        public DataTable this[string name] { get; }
+        public DataTable Add();
+        public void Add(DataTable table);
+        public DataTable Add(string name);
+        public DataTable Add(string name, string tableNamespace);
+        public void AddRange(DataTable[] tables);
+        public bool CanRemove(DataTable table);
+        public void Clear();
+        public bool Contains(string name);
+        public bool Contains(string name, string tableNamespace);
+        public void CopyTo(DataTable[] array, int index);
+        public int IndexOf(DataTable table);
+        public int IndexOf(string tableName);
+        public int IndexOf(string tableName, string tableNamespace);
+        public void Remove(DataTable table);
+        public void Remove(string name);
+        public void Remove(string name, string tableNamespace);
+        public void RemoveAt(int index);
+        public event CollectionChangeEventHandler CollectionChanged;
+        public event CollectionChangeEventHandler CollectionChanging;
+    }
+    public sealed class DataTableNewRowEventArgs : EventArgs {
+        public DataTableNewRowEventArgs(DataRow dataRow);
+        public DataRow Row { get; }
+    }
+    public delegate void DataTableNewRowEventHandler(object sender, DataTableNewRowEventArgs e); {
+        public DataTableNewRowEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DataTableNewRowEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DataTableNewRowEventArgs e);
+    }
+    public sealed class DataTableReader : DbDataReader {
+        public DataTableReader(DataTable dataTable);
+        public DataTableReader(DataTable[] dataTables);
+        public override int Depth { get; }
+        public override int FieldCount { get; }
+        public override bool HasRows { get; }
+        public override bool IsClosed { get; }
+        public override object this[int ordinal] { get; }
+        public override object this[string name] { get; }
+        public override int RecordsAffected { get; }
+        public override void Close();
+        public override bool GetBoolean(int ordinal);
+        public override byte GetByte(int ordinal);
+        public override long GetBytes(int ordinal, long dataIndex, byte[] buffer, int bufferIndex, int length);
+        public override char GetChar(int ordinal);
+        public override long GetChars(int ordinal, long dataIndex, char[] buffer, int bufferIndex, int length);
+        public override string GetDataTypeName(int ordinal);
+        public override DateTime GetDateTime(int ordinal);
+        public override decimal GetDecimal(int ordinal);
+        public override double GetDouble(int ordinal);
+        public override IEnumerator GetEnumerator();
+        public override Type GetFieldType(int ordinal);
+        public override float GetFloat(int ordinal);
+        public override Guid GetGuid(int ordinal);
+        public override short GetInt16(int ordinal);
+        public override int GetInt32(int ordinal);
+        public override long GetInt64(int ordinal);
+        public override string GetName(int ordinal);
+        public override int GetOrdinal(string name);
+        public override Type GetProviderSpecificFieldType(int ordinal);
+        public override object GetProviderSpecificValue(int ordinal);
+        public override int GetProviderSpecificValues(object[] values);
+        public override DataTable GetSchemaTable();
+        public override string GetString(int ordinal);
+        public override object GetValue(int ordinal);
+        public override int GetValues(object[] values);
+        public override bool IsDBNull(int ordinal);
+        public override bool NextResult();
+        public override bool Read();
+    }
+    public class DataView : MarshalByValueComponent, IBindingList, IBindingListView, ICollection, IEnumerable, IList, ISupportInitialize, ISupportInitializeNotification, ITypedList {
+        public DataView();
+        public DataView(DataTable table);
+        public DataView(DataTable table, string RowFilter, string Sort, DataViewRowState RowState);
+        public bool AllowDelete { get; set; }
+        public bool AllowEdit { get; set; }
+        public bool AllowNew { get; set; }
+        public bool ApplyDefaultSort { get; set; }
+        public int Count { get; }
+        public DataViewManager DataViewManager { get; }
+        public bool IsInitialized { get; }
+        protected bool IsOpen { get; }
+        public DataRowView this[int recordIndex] { get; }
+        public virtual string RowFilter { get; set; }
+        public DataViewRowState RowStateFilter { get; set; }
+        public string Sort { get; set; }
+        public DataTable Table { get; set; }
+        public virtual DataRowView AddNew();
+        public void BeginInit();
+        protected void Close();
+        protected virtual void ColumnCollectionChanged(object sender, CollectionChangeEventArgs e);
+        public void CopyTo(Array array, int index);
+        public void Delete(int index);
+        protected override void Dispose(bool disposing);
+        public void EndInit();
+        public virtual bool Equals(DataView view);
+        public int Find(object key);
+        public int Find(object[] key);
+        public DataRowView[] FindRows(object key);
+        public DataRowView[] FindRows(object[] key);
+        public IEnumerator GetEnumerator();
+        protected virtual void IndexListChanged(object sender, ListChangedEventArgs e);
+        protected virtual void OnListChanged(ListChangedEventArgs e);
+        protected void Open();
+        protected void Reset();
+        public DataTable ToTable();
+        public DataTable ToTable(bool distinct, params string[] columnNames);
+        public DataTable ToTable(string tableName);
+        public DataTable ToTable(string tableName, bool distinct, params string[] columnNames);
+        protected void UpdateIndex();
+        protected virtual void UpdateIndex(bool force);
+        public event EventHandler Initialized;
+        public event ListChangedEventHandler ListChanged;
+    }
+    public class DataViewManager : MarshalByValueComponent, IBindingList, ICollection, IEnumerable, IList, ITypedList {
+        public DataViewManager();
+        public DataViewManager(DataSet dataSet);
+        public DataSet DataSet { get; set; }
+        public string DataViewSettingCollectionString { get; set; }
+        public DataViewSettingCollection DataViewSettings { get; }
+        public DataView CreateDataView(DataTable table);
+        protected virtual void OnListChanged(ListChangedEventArgs e);
+        protected virtual void RelationCollectionChanged(object sender, CollectionChangeEventArgs e);
+        protected virtual void TableCollectionChanged(object sender, CollectionChangeEventArgs e);
+        public event ListChangedEventHandler ListChanged;
+    }
+    public enum DataViewRowState {
+        Added = 4,
+        CurrentRows = 22,
+        Deleted = 8,
+        ModifiedCurrent = 16,
+        ModifiedOriginal = 32,
+        None = 0,
+        OriginalRows = 42,
+        Unchanged = 2,
+    }
+    public class DataViewSetting {
+        public bool ApplyDefaultSort { get; set; }
+        public DataViewManager DataViewManager { get; }
+        public string RowFilter { get; set; }
+        public DataViewRowState RowStateFilter { get; set; }
+        public string Sort { get; set; }
+        public DataTable Table { get; }
+    }
+    public class DataViewSettingCollection : ICollection, IEnumerable {
+        public virtual int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public virtual DataViewSetting this[DataTable table] { get; set; }
+        public virtual DataViewSetting this[int index] { get; set; }
+        public virtual DataViewSetting this[string tableName] { get; }
+        public object SyncRoot { get; }
+        public void CopyTo(Array ar, int index);
+        public void CopyTo(DataViewSetting[] ar, int index);
+        public IEnumerator GetEnumerator();
+    }
+    public sealed class DBConcurrencyException : SystemException {
+        public DBConcurrencyException();
+        public DBConcurrencyException(string message);
+        public DBConcurrencyException(string message, Exception inner);
+        public DBConcurrencyException(string message, Exception inner, DataRow[] dataRows);
+        public DataRow Row { get; set; }
+        public int RowCount { get; }
+        public void CopyToRows(DataRow[] array);
+        public void CopyToRows(DataRow[] array, int arrayIndex);
+        public override void GetObjectData(SerializationInfo si, StreamingContext context);
+    }
+    public enum DbType {
+        AnsiString = 0,
+        AnsiStringFixedLength = 22,
+        Binary = 1,
+        Boolean = 3,
+        Byte = 2,
+        Currency = 4,
+        Date = 5,
+        DateTime = 6,
+        DateTime2 = 26,
+        DateTimeOffset = 27,
+        Decimal = 7,
+        Double = 8,
+        Guid = 9,
+        Int16 = 10,
+        Int32 = 11,
+        Int64 = 12,
+        Object = 13,
+        SByte = 14,
+        Single = 15,
+        String = 16,
+        StringFixedLength = 23,
+        Time = 17,
+        UInt16 = 18,
+        UInt32 = 19,
+        UInt64 = 20,
+        VarNumeric = 21,
+        Xml = 25,
+    }
+    public class DeletedRowInaccessibleException : DataException {
+        public DeletedRowInaccessibleException();
+        protected DeletedRowInaccessibleException(SerializationInfo info, StreamingContext context);
+        public DeletedRowInaccessibleException(string s);
+        public DeletedRowInaccessibleException(string message, Exception innerException);
+    }
+    public class DuplicateNameException : DataException {
+        public DuplicateNameException();
+        protected DuplicateNameException(SerializationInfo info, StreamingContext context);
+        public DuplicateNameException(string s);
+        public DuplicateNameException(string message, Exception innerException);
+    }
+    public class EvaluateException : InvalidExpressionException {
+        public EvaluateException();
+        protected EvaluateException(SerializationInfo info, StreamingContext context);
+        public EvaluateException(string s);
+        public EvaluateException(string message, Exception innerException);
+    }
+    public class FillErrorEventArgs : EventArgs {
+        public FillErrorEventArgs(DataTable dataTable, object[] values);
+        public bool Continue { get; set; }
+        public DataTable DataTable { get; }
+        public Exception Errors { get; set; }
+        public object[] Values { get; }
+    }
+    public delegate void FillErrorEventHandler(object sender, FillErrorEventArgs e); {
+        public FillErrorEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, FillErrorEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, FillErrorEventArgs e);
+    }
+    public class ForeignKeyConstraint : Constraint {
+        public ForeignKeyConstraint(DataColumn parentColumn, DataColumn childColumn);
+        public ForeignKeyConstraint(DataColumn[] parentColumns, DataColumn[] childColumns);
+        public ForeignKeyConstraint(string constraintName, DataColumn parentColumn, DataColumn childColumn);
+        public ForeignKeyConstraint(string constraintName, DataColumn[] parentColumns, DataColumn[] childColumns);
+        public ForeignKeyConstraint(string constraintName, string parentTableName, string parentTableNamespace, string[] parentColumnNames, string[] childColumnNames, AcceptRejectRule acceptRejectRule, Rule deleteRule, Rule updateRule);
+        public ForeignKeyConstraint(string constraintName, string parentTableName, string[] parentColumnNames, string[] childColumnNames, AcceptRejectRule acceptRejectRule, Rule deleteRule, Rule updateRule);
+        public virtual AcceptRejectRule AcceptRejectRule { get; set; }
+        public virtual DataColumn[] Columns { get; }
+        public virtual Rule DeleteRule { get; set; }
+        public virtual DataColumn[] RelatedColumns { get; }
+        public virtual DataTable RelatedTable { get; }
+        public override DataTable Table { get; }
+        public virtual Rule UpdateRule { get; set; }
+        public override bool Equals(object key);
+        public override int GetHashCode();
+    }
+    public interface IColumnMapping {
+        string DataSetColumn { get; set; }
+        string SourceColumn { get; set; }
+    }
+    public interface IColumnMappingCollection : ICollection, IEnumerable, IList {
+        object this[string index] { get; set; }
+        IColumnMapping Add(string sourceColumnName, string dataSetColumnName);
+        bool Contains(string sourceColumnName);
+        IColumnMapping GetByDataSetColumn(string dataSetColumnName);
+        int IndexOf(string sourceColumnName);
+        void RemoveAt(string sourceColumnName);
+    }
+    public interface IDataAdapter {
+        MissingMappingAction MissingMappingAction { get; set; }
+        MissingSchemaAction MissingSchemaAction { get; set; }
+        ITableMappingCollection TableMappings { get; }
+        int Fill(DataSet dataSet);
+        DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType);
+        IDataParameter[] GetFillParameters();
+        int Update(DataSet dataSet);
+    }
+    public interface IDataParameter {
+        DbType DbType { get; set; }
+        ParameterDirection Direction { get; set; }
+        bool IsNullable { get; }
+        string ParameterName { get; set; }
+        string SourceColumn { get; set; }
+        DataRowVersion SourceVersion { get; set; }
+        object Value { get; set; }
+    }
+    public interface IDataParameterCollection : ICollection, IEnumerable, IList {
+        object this[string parameterName] { get; set; }
+        bool Contains(string parameterName);
+        int IndexOf(string parameterName);
+        void RemoveAt(string parameterName);
+    }
+    public interface IDataReader : IDataRecord, IDisposable {
+        int Depth { get; }
+        bool IsClosed { get; }
+        int RecordsAffected { get; }
+        void Close();
+        DataTable GetSchemaTable();
+        bool NextResult();
+        bool Read();
+    }
+    public interface IDataRecord {
+        int FieldCount { get; }
+        object this[int i] { get; }
+        object this[string name] { get; }
+        bool GetBoolean(int i);
+        byte GetByte(int i);
+        long GetBytes(int i, long fieldOffset, byte[] buffer, int bufferoffset, int length);
+        char GetChar(int i);
+        long GetChars(int i, long fieldoffset, char[] buffer, int bufferoffset, int length);
+        IDataReader GetData(int i);
+        string GetDataTypeName(int i);
+        DateTime GetDateTime(int i);
+        decimal GetDecimal(int i);
+        double GetDouble(int i);
+        Type GetFieldType(int i);
+        float GetFloat(int i);
+        Guid GetGuid(int i);
+        short GetInt16(int i);
+        int GetInt32(int i);
+        long GetInt64(int i);
+        string GetName(int i);
+        int GetOrdinal(string name);
+        string GetString(int i);
+        object GetValue(int i);
+        int GetValues(object[] values);
+        bool IsDBNull(int i);
+    }
+    public interface IDbCommand : IDisposable {
+        string CommandText { get; set; }
+        int CommandTimeout { get; set; }
+        CommandType CommandType { get; set; }
+        IDbConnection Connection { get; set; }
+        IDataParameterCollection Parameters { get; }
+        IDbTransaction Transaction { get; set; }
+        UpdateRowSource UpdatedRowSource { get; set; }
+        void Cancel();
+        IDbDataParameter CreateParameter();
+        int ExecuteNonQuery();
+        IDataReader ExecuteReader();
+        IDataReader ExecuteReader(CommandBehavior behavior);
+        object ExecuteScalar();
+        void Prepare();
+    }
+    public interface IDbConnection : IDisposable {
+        string ConnectionString { get; set; }
+        int ConnectionTimeout { get; }
+        string Database { get; }
+        ConnectionState State { get; }
+        IDbTransaction BeginTransaction();
+        IDbTransaction BeginTransaction(IsolationLevel il);
+        void ChangeDatabase(string databaseName);
+        void Close();
+        IDbCommand CreateCommand();
+        void Open();
+    }
+    public interface IDbDataAdapter : IDataAdapter {
+        IDbCommand DeleteCommand { get; set; }
+        IDbCommand InsertCommand { get; set; }
+        IDbCommand SelectCommand { get; set; }
+        IDbCommand UpdateCommand { get; set; }
+    }
+    public interface IDbDataParameter : IDataParameter {
+        byte Precision { get; set; }
+        byte Scale { get; set; }
+        int Size { get; set; }
+    }
+    public interface IDbTransaction : IDisposable {
+        IDbConnection Connection { get; }
+        IsolationLevel IsolationLevel { get; }
+        void Commit();
+        void Rollback();
+    }
+    public class InRowChangingEventException : DataException {
+        public InRowChangingEventException();
+        protected InRowChangingEventException(SerializationInfo info, StreamingContext context);
+        public InRowChangingEventException(string s);
+        public InRowChangingEventException(string message, Exception innerException);
+    }
+    public class InternalDataCollectionBase : ICollection, IEnumerable {
+        public InternalDataCollectionBase();
+        public virtual int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        protected virtual ArrayList List { get; }
+        public object SyncRoot { get; }
+        public virtual void CopyTo(Array ar, int index);
+        public virtual IEnumerator GetEnumerator();
+    }
+    public class InvalidConstraintException : DataException {
+        public InvalidConstraintException();
+        protected InvalidConstraintException(SerializationInfo info, StreamingContext context);
+        public InvalidConstraintException(string s);
+        public InvalidConstraintException(string message, Exception innerException);
+    }
+    public class InvalidExpressionException : DataException {
+        public InvalidExpressionException();
+        protected InvalidExpressionException(SerializationInfo info, StreamingContext context);
+        public InvalidExpressionException(string s);
+        public InvalidExpressionException(string message, Exception innerException);
+    }
+    public enum IsolationLevel {
+        Chaos = 16,
+        ReadCommitted = 4096,
+        ReadUncommitted = 256,
+        RepeatableRead = 65536,
+        Serializable = 1048576,
+        Snapshot = 16777216,
+        Unspecified = -1,
+    }
+    public interface ITableMapping {
+        IColumnMappingCollection ColumnMappings { get; }
+        string DataSetTable { get; set; }
+        string SourceTable { get; set; }
+    }
+    public interface ITableMappingCollection : ICollection, IEnumerable, IList {
+        object this[string index] { get; set; }
+        ITableMapping Add(string sourceTableName, string dataSetTableName);
+        bool Contains(string sourceTableName);
+        ITableMapping GetByDataSetTable(string dataSetTableName);
+        int IndexOf(string sourceTableName);
+        void RemoveAt(string sourceTableName);
+    }
+    public enum KeyRestrictionBehavior {
+        AllowOnly = 0,
+        PreventUsage = 1,
+    }
+    public enum LoadOption {
+        OverwriteChanges = 1,
+        PreserveChanges = 2,
+        Upsert = 3,
+    }
+    public enum MappingType {
+        Attribute = 2,
+        Element = 1,
+        Hidden = 4,
+        SimpleContent = 3,
+    }
+    public class MergeFailedEventArgs : EventArgs {
+        public MergeFailedEventArgs(DataTable table, string conflict);
+        public string Conflict { get; }
+        public DataTable Table { get; }
+    }
+    public delegate void MergeFailedEventHandler(object sender, MergeFailedEventArgs e); {
+        public MergeFailedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, MergeFailedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, MergeFailedEventArgs e);
+    }
+    public enum MissingMappingAction {
+        Error = 3,
+        Ignore = 2,
+        Passthrough = 1,
+    }
+    public class MissingPrimaryKeyException : DataException {
+        public MissingPrimaryKeyException();
+        protected MissingPrimaryKeyException(SerializationInfo info, StreamingContext context);
+        public MissingPrimaryKeyException(string s);
+        public MissingPrimaryKeyException(string message, Exception innerException);
+    }
+    public enum MissingSchemaAction {
+        Add = 1,
+        AddWithKey = 4,
+        Error = 3,
+        Ignore = 2,
+    }
+    public class NoNullAllowedException : DataException {
+        public NoNullAllowedException();
+        protected NoNullAllowedException(SerializationInfo info, StreamingContext context);
+        public NoNullAllowedException(string s);
+        public NoNullAllowedException(string message, Exception innerException);
+    }
+    public enum ParameterDirection {
+        Input = 1,
+        InputOutput = 3,
+        Output = 2,
+        ReturnValue = 6,
+    }
+    public class PropertyCollection : Hashtable {
+        public PropertyCollection();
+        protected PropertyCollection(SerializationInfo info, StreamingContext context);
+        public override object Clone();
+    }
+    public class ReadOnlyException : DataException {
+        public ReadOnlyException();
+        protected ReadOnlyException(SerializationInfo info, StreamingContext context);
+        public ReadOnlyException(string s);
+        public ReadOnlyException(string message, Exception innerException);
+    }
+    public class RowNotInTableException : DataException {
+        public RowNotInTableException();
+        protected RowNotInTableException(SerializationInfo info, StreamingContext context);
+        public RowNotInTableException(string s);
+        public RowNotInTableException(string message, Exception innerException);
+    }
+    public enum Rule {
+        Cascade = 1,
+        None = 0,
+        SetDefault = 3,
+        SetNull = 2,
+    }
+    public enum SchemaSerializationMode {
+        ExcludeSchema = 2,
+        IncludeSchema = 1,
+    }
+    public enum SchemaType {
+        Mapped = 2,
+        Source = 1,
+    }
+    public enum SerializationFormat {
+        Binary = 1,
+        Xml = 0,
+    }
+    public enum SqlDbType {
+        BigInt = 0,
+        Binary = 1,
+        Bit = 2,
+        Char = 3,
+        Date = 31,
+        DateTime = 4,
+        DateTime2 = 33,
+        DateTimeOffset = 34,
+        Decimal = 5,
+        Float = 6,
+        Image = 7,
+        Int = 8,
+        Money = 9,
+        NChar = 10,
+        NText = 11,
+        NVarChar = 12,
+        Real = 13,
+        SmallDateTime = 15,
+        SmallInt = 16,
+        SmallMoney = 17,
+        Structured = 30,
+        Text = 18,
+        Time = 32,
+        Timestamp = 19,
+        TinyInt = 20,
+        Udt = 29,
+        UniqueIdentifier = 14,
+        VarBinary = 21,
+        VarChar = 22,
+        Variant = 23,
+        Xml = 25,
+    }
+    public sealed class StateChangeEventArgs : EventArgs {
+        public StateChangeEventArgs(ConnectionState originalState, ConnectionState currentState);
+        public ConnectionState CurrentState { get; }
+        public ConnectionState OriginalState { get; }
+    }
+    public delegate void StateChangeEventHandler(object sender, StateChangeEventArgs e); {
+        public StateChangeEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, StateChangeEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, StateChangeEventArgs e);
+    }
+    public sealed class StatementCompletedEventArgs : EventArgs {
+        public StatementCompletedEventArgs(int recordCount);
+        public int RecordCount { get; }
+    }
+    public delegate void StatementCompletedEventHandler(object sender, StatementCompletedEventArgs e); {
+        public StatementCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, StatementCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, StatementCompletedEventArgs e);
+    }
+    public enum StatementType {
+        Batch = 4,
+        Delete = 3,
+        Insert = 1,
+        Select = 0,
+        Update = 2,
+    }
+    public class StrongTypingException : DataException {
+        public StrongTypingException();
+        protected StrongTypingException(SerializationInfo info, StreamingContext context);
+        public StrongTypingException(string message);
+        public StrongTypingException(string s, Exception innerException);
+    }
+    public class SyntaxErrorException : InvalidExpressionException {
+        public SyntaxErrorException();
+        protected SyntaxErrorException(SerializationInfo info, StreamingContext context);
+        public SyntaxErrorException(string s);
+        public SyntaxErrorException(string message, Exception innerException);
+    }
+    public class UniqueConstraint : Constraint {
+        public UniqueConstraint(DataColumn column);
+        public UniqueConstraint(DataColumn column, bool isPrimaryKey);
+        public UniqueConstraint(DataColumn[] columns);
+        public UniqueConstraint(DataColumn[] columns, bool isPrimaryKey);
+        public UniqueConstraint(string name, DataColumn column);
+        public UniqueConstraint(string name, DataColumn column, bool isPrimaryKey);
+        public UniqueConstraint(string name, DataColumn[] columns);
+        public UniqueConstraint(string name, DataColumn[] columns, bool isPrimaryKey);
+        public UniqueConstraint(string name, string[] columnNames, bool isPrimaryKey);
+        public virtual DataColumn[] Columns { get; }
+        public bool IsPrimaryKey { get; }
+        public override DataTable Table { get; }
+        public override bool Equals(object key2);
+        public override int GetHashCode();
+    }
+    public enum UpdateRowSource {
+        Both = 3,
+        FirstReturnedRecord = 2,
+        None = 0,
+        OutputParameters = 1,
+    }
+    public enum UpdateStatus {
+        Continue = 0,
+        ErrorsOccurred = 1,
+        SkipAllRemainingRows = 3,
+        SkipCurrentRow = 2,
+    }
+    public class VersionNotFoundException : DataException {
+        public VersionNotFoundException();
+        protected VersionNotFoundException(SerializationInfo info, StreamingContext context);
+        public VersionNotFoundException(string s);
+        public VersionNotFoundException(string message, Exception innerException);
+    }
+    public enum XmlReadMode {
+        Auto = 0,
+        DiffGram = 4,
+        Fragment = 5,
+        IgnoreSchema = 2,
+        InferSchema = 3,
+        InferTypedSchema = 6,
+        ReadSchema = 1,
+    }
+    public enum XmlWriteMode {
+        DiffGram = 2,
+        IgnoreSchema = 1,
+        WriteSchema = 0,
+    }
+}
+namespace System.Data.Common {
+    public enum CatalogLocation {
+        End = 2,
+        Start = 1,
+    }
+    public class DataAdapter : Component, IDataAdapter {
+        protected DataAdapter();
+        protected DataAdapter(DataAdapter from);
+        public bool AcceptChangesDuringFill { get; set; }
+        public bool AcceptChangesDuringUpdate { get; set; }
+        public bool ContinueUpdateOnError { get; set; }
+        public LoadOption FillLoadOption { get; set; }
+        public MissingMappingAction MissingMappingAction { get; set; }
+        public MissingSchemaAction MissingSchemaAction { get; set; }
+        public virtual bool ReturnProviderSpecificTypes { get; set; }
+        public DataTableMappingCollection TableMappings { get; }
+        protected virtual DataAdapter CloneInternals();
+        protected virtual DataTableMappingCollection CreateTableMappings();
+        protected override void Dispose(bool disposing);
+        public virtual int Fill(DataSet dataSet);
+        protected virtual int Fill(DataSet dataSet, string srcTable, IDataReader dataReader, int startRecord, int maxRecords);
+        protected virtual int Fill(DataTable dataTable, IDataReader dataReader);
+        protected virtual int Fill(DataTable[] dataTables, IDataReader dataReader, int startRecord, int maxRecords);
+        public virtual DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType);
+        protected virtual DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType, string srcTable, IDataReader dataReader);
+        protected virtual DataTable FillSchema(DataTable dataTable, SchemaType schemaType, IDataReader dataReader);
+        public virtual IDataParameter[] GetFillParameters();
+        protected bool HasTableMappings();
+        protected virtual void OnFillError(FillErrorEventArgs value);
+        public void ResetFillLoadOption();
+        public virtual bool ShouldSerializeAcceptChangesDuringFill();
+        public virtual bool ShouldSerializeFillLoadOption();
+        protected virtual bool ShouldSerializeTableMappings();
+        public virtual int Update(DataSet dataSet);
+        public event FillErrorEventHandler FillError;
+    }
+    public sealed class DataColumnMapping : MarshalByRefObject, ICloneable, IColumnMapping {
+        public DataColumnMapping();
+        public DataColumnMapping(string sourceColumn, string dataSetColumn);
+        public string DataSetColumn { get; set; }
+        public string SourceColumn { get; set; }
+        public DataColumn GetDataColumnBySchemaAction(DataTable dataTable, Type dataType, MissingSchemaAction schemaAction);
+        public static DataColumn GetDataColumnBySchemaAction(string sourceColumn, string dataSetColumn, DataTable dataTable, Type dataType, MissingSchemaAction schemaAction);
+        public override string ToString();
+    }
+    public sealed class DataColumnMappingCollection : MarshalByRefObject, ICollection, IColumnMappingCollection, IEnumerable, IList {
+        public DataColumnMappingCollection();
+        public int Count { get; }
+        public DataColumnMapping this[int index] { get; set; }
+        public DataColumnMapping this[string sourceColumn] { get; set; }
+        public int Add(object value);
+        public DataColumnMapping Add(string sourceColumn, string dataSetColumn);
+        public void AddRange(Array values);
+        public void AddRange(DataColumnMapping[] values);
+        public void Clear();
+        public bool Contains(object value);
+        public bool Contains(string value);
+        public void CopyTo(Array array, int index);
+        public void CopyTo(DataColumnMapping[] array, int index);
+        public DataColumnMapping GetByDataSetColumn(string value);
+        public static DataColumnMapping GetColumnMappingBySchemaAction(DataColumnMappingCollection columnMappings, string sourceColumn, MissingMappingAction mappingAction);
+        public static DataColumn GetDataColumn(DataColumnMappingCollection columnMappings, string sourceColumn, Type dataType, DataTable dataTable, MissingMappingAction mappingAction, MissingSchemaAction schemaAction);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(object value);
+        public int IndexOf(string sourceColumn);
+        public int IndexOfDataSetColumn(string dataSetColumn);
+        public void Insert(int index, DataColumnMapping value);
+        public void Insert(int index, object value);
+        public void Remove(DataColumnMapping value);
+        public void Remove(object value);
+        public void RemoveAt(int index);
+        public void RemoveAt(string sourceColumn);
+    }
+    public sealed class DataTableMapping : MarshalByRefObject, ICloneable, ITableMapping {
+        public DataTableMapping();
+        public DataTableMapping(string sourceTable, string dataSetTable);
+        public DataTableMapping(string sourceTable, string dataSetTable, DataColumnMapping[] columnMappings);
+        public DataColumnMappingCollection ColumnMappings { get; }
+        public string DataSetTable { get; set; }
+        public string SourceTable { get; set; }
+        public DataColumnMapping GetColumnMappingBySchemaAction(string sourceColumn, MissingMappingAction mappingAction);
+        public DataColumn GetDataColumn(string sourceColumn, Type dataType, DataTable dataTable, MissingMappingAction mappingAction, MissingSchemaAction schemaAction);
+        public DataTable GetDataTableBySchemaAction(DataSet dataSet, MissingSchemaAction schemaAction);
+        public override string ToString();
+    }
+    public sealed class DataTableMappingCollection : MarshalByRefObject, ICollection, IEnumerable, IList, ITableMappingCollection {
+        public DataTableMappingCollection();
+        public int Count { get; }
+        public DataTableMapping this[int index] { get; set; }
+        public DataTableMapping this[string sourceTable] { get; set; }
+        public int Add(object value);
+        public DataTableMapping Add(string sourceTable, string dataSetTable);
+        public void AddRange(Array values);
+        public void AddRange(DataTableMapping[] values);
+        public void Clear();
+        public bool Contains(object value);
+        public bool Contains(string value);
+        public void CopyTo(Array array, int index);
+        public void CopyTo(DataTableMapping[] array, int index);
+        public DataTableMapping GetByDataSetTable(string dataSetTable);
+        public IEnumerator GetEnumerator();
+        public static DataTableMapping GetTableMappingBySchemaAction(DataTableMappingCollection tableMappings, string sourceTable, string dataSetTable, MissingMappingAction mappingAction);
+        public int IndexOf(object value);
+        public int IndexOf(string sourceTable);
+        public int IndexOfDataSetTable(string dataSetTable);
+        public void Insert(int index, DataTableMapping value);
+        public void Insert(int index, object value);
+        public void Remove(DataTableMapping value);
+        public void Remove(object value);
+        public void RemoveAt(int index);
+        public void RemoveAt(string sourceTable);
+    }
+    public abstract class DbCommand : Component, IDbCommand, IDisposable {
+        protected DbCommand();
+        public abstract string CommandText { get; set; }
+        public abstract int CommandTimeout { get; set; }
+        public abstract CommandType CommandType { get; set; }
+        public DbConnection Connection { get; set; }
+        protected abstract DbConnection DbConnection { get; set; }
+        protected abstract DbParameterCollection DbParameterCollection { get; }
+        protected abstract DbTransaction DbTransaction { get; set; }
+        public abstract bool DesignTimeVisible { get; set; }
+        public DbParameterCollection Parameters { get; }
+        public DbTransaction Transaction { get; set; }
+        public abstract UpdateRowSource UpdatedRowSource { get; set; }
+        public abstract void Cancel();
+        protected abstract DbParameter CreateDbParameter();
+        public DbParameter CreateParameter();
+        protected abstract DbDataReader ExecuteDbDataReader(CommandBehavior behavior);
+        protected virtual Task<DbDataReader> ExecuteDbDataReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
+        public abstract int ExecuteNonQuery();
+        public Task<int> ExecuteNonQueryAsync();
+        public virtual Task<int> ExecuteNonQueryAsync(CancellationToken cancellationToken);
+        public DbDataReader ExecuteReader();
+        public DbDataReader ExecuteReader(CommandBehavior behavior);
+        public Task<DbDataReader> ExecuteReaderAsync();
+        public Task<DbDataReader> ExecuteReaderAsync(CancellationToken cancellationToken);
+        public Task<DbDataReader> ExecuteReaderAsync(CommandBehavior behavior);
+        public Task<DbDataReader> ExecuteReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
+        public abstract object ExecuteScalar();
+        public Task<object> ExecuteScalarAsync();
+        public virtual Task<object> ExecuteScalarAsync(CancellationToken cancellationToken);
+        public abstract void Prepare();
+    }
+    public abstract class DbCommandBuilder : Component {
+        protected DbCommandBuilder();
+        public virtual CatalogLocation CatalogLocation { get; set; }
+        public virtual string CatalogSeparator { get; set; }
+        public virtual ConflictOption ConflictOption { get; set; }
+        public DbDataAdapter DataAdapter { get; set; }
+        public virtual string QuotePrefix { get; set; }
+        public virtual string QuoteSuffix { get; set; }
+        public virtual string SchemaSeparator { get; set; }
+        public bool SetAllValues { get; set; }
+        protected abstract void ApplyParameterInfo(DbParameter parameter, DataRow row, StatementType statementType, bool whereClause);
+        protected override void Dispose(bool disposing);
+        public DbCommand GetDeleteCommand();
+        public DbCommand GetDeleteCommand(bool useColumnsForParameterNames);
+        public DbCommand GetInsertCommand();
+        public DbCommand GetInsertCommand(bool useColumnsForParameterNames);
+        protected abstract string GetParameterName(int parameterOrdinal);
+        protected abstract string GetParameterName(string parameterName);
+        protected abstract string GetParameterPlaceholder(int parameterOrdinal);
+        protected virtual DataTable GetSchemaTable(DbCommand sourceCommand);
+        public DbCommand GetUpdateCommand();
+        public DbCommand GetUpdateCommand(bool useColumnsForParameterNames);
+        protected virtual DbCommand InitializeCommand(DbCommand command);
+        public virtual string QuoteIdentifier(string unquotedIdentifier);
+        public virtual void RefreshSchema();
+        protected void RowUpdatingHandler(RowUpdatingEventArgs rowUpdatingEvent);
+        protected abstract void SetRowUpdatingHandler(DbDataAdapter adapter);
+        public virtual string UnquoteIdentifier(string quotedIdentifier);
+    }
+    public abstract class DbConnection : Component, IDbConnection, IDisposable {
+        protected DbConnection();
+        public abstract string ConnectionString { get; set; }
+        public virtual int ConnectionTimeout { get; }
+        public abstract string Database { get; }
+        public abstract string DataSource { get; }
+        protected virtual DbProviderFactory DbProviderFactory { get; }
+        public abstract string ServerVersion { get; }
+        public abstract ConnectionState State { get; }
+        protected abstract DbTransaction BeginDbTransaction(IsolationLevel isolationLevel);
+        public DbTransaction BeginTransaction();
+        public DbTransaction BeginTransaction(IsolationLevel isolationLevel);
+        public abstract void ChangeDatabase(string databaseName);
+        public abstract void Close();
+        public DbCommand CreateCommand();
+        protected abstract DbCommand CreateDbCommand();
+        public virtual DataTable GetSchema();
+        public virtual DataTable GetSchema(string collectionName);
+        public virtual DataTable GetSchema(string collectionName, string[] restrictionValues);
+        protected virtual void OnStateChange(StateChangeEventArgs stateChange);
+        public abstract void Open();
+        public Task OpenAsync();
+        public virtual Task OpenAsync(CancellationToken cancellationToken);
+        public virtual event StateChangeEventHandler StateChange;
+    }
+    public class DbConnectionStringBuilder : ICollection, ICustomTypeDescriptor, IDictionary, IEnumerable {
+        public DbConnectionStringBuilder();
+        public DbConnectionStringBuilder(bool useOdbcRules);
+        public bool BrowsableConnectionString { get; set; }
+        public string ConnectionString { get; set; }
+        public virtual int Count { get; }
+        public virtual bool IsFixedSize { get; }
+        public bool IsReadOnly { get; }
+        public virtual object this[string keyword] { get; set; }
+        public virtual ICollection Keys { get; }
+        public virtual ICollection Values { get; }
+        public void Add(string keyword, object value);
+        public static void AppendKeyValuePair(StringBuilder builder, string keyword, string value);
+        public static void AppendKeyValuePair(StringBuilder builder, string keyword, string value, bool useOdbcRules);
+        public virtual void Clear();
+        protected internal void ClearPropertyDescriptors();
+        public virtual bool ContainsKey(string keyword);
+        public virtual bool EquivalentTo(DbConnectionStringBuilder connectionStringBuilder);
+        protected virtual void GetProperties(Hashtable propertyDescriptors);
+        public virtual bool Remove(string keyword);
+        public virtual bool ShouldSerialize(string keyword);
+        public override string ToString();
+        public virtual bool TryGetValue(string keyword, out object value);
+    }
+    public abstract class DbDataAdapter : DataAdapter, ICloneable, IDataAdapter, IDbDataAdapter {
+        public const string DefaultSourceTableName = "Table";
+        protected DbDataAdapter();
+        protected DbDataAdapter(DbDataAdapter adapter);
+        public DbCommand DeleteCommand { get; set; }
+        protected internal CommandBehavior FillCommandBehavior { get; set; }
+        public DbCommand InsertCommand { get; set; }
+        public DbCommand SelectCommand { get; set; }
+        public virtual int UpdateBatchSize { get; set; }
+        public DbCommand UpdateCommand { get; set; }
+        protected virtual int AddToBatch(IDbCommand command);
+        protected virtual void ClearBatch();
+        protected virtual RowUpdatedEventArgs CreateRowUpdatedEvent(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
+        protected virtual RowUpdatingEventArgs CreateRowUpdatingEvent(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
+        protected override void Dispose(bool disposing);
+        protected virtual int ExecuteBatch();
+        public override int Fill(DataSet dataSet);
+        public int Fill(DataSet dataSet, int startRecord, int maxRecords, string srcTable);
+        protected virtual int Fill(DataSet dataSet, int startRecord, int maxRecords, string srcTable, IDbCommand command, CommandBehavior behavior);
+        public int Fill(DataSet dataSet, string srcTable);
+        public int Fill(DataTable dataTable);
+        protected virtual int Fill(DataTable dataTable, IDbCommand command, CommandBehavior behavior);
+        protected virtual int Fill(DataTable[] dataTables, int startRecord, int maxRecords, IDbCommand command, CommandBehavior behavior);
+        public int Fill(int startRecord, int maxRecords, params DataTable[] dataTables);
+        public override DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType);
+        protected virtual DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType, IDbCommand command, string srcTable, CommandBehavior behavior);
+        public DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType, string srcTable);
+        public DataTable FillSchema(DataTable dataTable, SchemaType schemaType);
+        protected virtual DataTable FillSchema(DataTable dataTable, SchemaType schemaType, IDbCommand command, CommandBehavior behavior);
+        protected virtual IDataParameter GetBatchedParameter(int commandIdentifier, int parameterIndex);
+        protected virtual bool GetBatchedRecordsAffected(int commandIdentifier, out int recordsAffected, out Exception error);
+        public override IDataParameter[] GetFillParameters();
+        protected virtual void InitializeBatching();
+        protected virtual void OnRowUpdated(RowUpdatedEventArgs value);
+        protected virtual void OnRowUpdating(RowUpdatingEventArgs value);
+        protected virtual void TerminateBatching();
+        public int Update(DataRow[] dataRows);
+        protected virtual int Update(DataRow[] dataRows, DataTableMapping tableMapping);
+        public override int Update(DataSet dataSet);
+        public int Update(DataSet dataSet, string srcTable);
+        public int Update(DataTable dataTable);
+    }
+    public abstract class DbDataReader : MarshalByRefObject, IDataReader, IDataRecord, IDisposable, IEnumerable {
+        protected DbDataReader();
+        public abstract int Depth { get; }
+        public abstract int FieldCount { get; }
+        public abstract bool HasRows { get; }
+        public abstract bool IsClosed { get; }
+        public abstract object this[int ordinal] { get; }
+        public abstract object this[string name] { get; }
+        public abstract int RecordsAffected { get; }
+        public virtual int VisibleFieldCount { get; }
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract bool GetBoolean(int ordinal);
+        public abstract byte GetByte(int ordinal);
+        public abstract long GetBytes(int ordinal, long dataOffset, byte[] buffer, int bufferOffset, int length);
+        public abstract char GetChar(int ordinal);
+        public abstract long GetChars(int ordinal, long dataOffset, char[] buffer, int bufferOffset, int length);
+        public DbDataReader GetData(int ordinal);
+        public abstract string GetDataTypeName(int ordinal);
+        public abstract DateTime GetDateTime(int ordinal);
+        protected virtual DbDataReader GetDbDataReader(int ordinal);
+        public abstract decimal GetDecimal(int ordinal);
+        public abstract double GetDouble(int ordinal);
+        public abstract IEnumerator GetEnumerator();
+        public abstract Type GetFieldType(int ordinal);
+        public virtual T GetFieldValue<T>(int ordinal);
+        public Task<T> GetFieldValueAsync<T>(int ordinal);
+        public virtual Task<T> GetFieldValueAsync<T>(int ordinal, CancellationToken cancellationToken);
+        public abstract float GetFloat(int ordinal);
+        public abstract Guid GetGuid(int ordinal);
+        public abstract short GetInt16(int ordinal);
+        public abstract int GetInt32(int ordinal);
+        public abstract long GetInt64(int ordinal);
+        public abstract string GetName(int ordinal);
+        public abstract int GetOrdinal(string name);
+        public virtual Type GetProviderSpecificFieldType(int ordinal);
+        public virtual object GetProviderSpecificValue(int ordinal);
+        public virtual int GetProviderSpecificValues(object[] values);
+        public virtual DataTable GetSchemaTable();
+        public virtual Stream GetStream(int ordinal);
+        public abstract string GetString(int ordinal);
+        public virtual TextReader GetTextReader(int ordinal);
+        public abstract object GetValue(int ordinal);
+        public abstract int GetValues(object[] values);
+        public abstract bool IsDBNull(int ordinal);
+        public Task<bool> IsDBNullAsync(int ordinal);
+        public virtual Task<bool> IsDBNullAsync(int ordinal, CancellationToken cancellationToken);
+        public abstract bool NextResult();
+        public Task<bool> NextResultAsync();
+        public virtual Task<bool> NextResultAsync(CancellationToken cancellationToken);
+        public abstract bool Read();
+        public Task<bool> ReadAsync();
+        public virtual Task<bool> ReadAsync(CancellationToken cancellationToken);
+    }
+    public abstract class DbDataRecord : ICustomTypeDescriptor, IDataRecord {
+        protected DbDataRecord();
+        public abstract int FieldCount { get; }
+        public abstract object this[int i] { get; }
+        public abstract object this[string name] { get; }
+        public abstract bool GetBoolean(int i);
+        public abstract byte GetByte(int i);
+        public abstract long GetBytes(int i, long dataIndex, byte[] buffer, int bufferIndex, int length);
+        public abstract char GetChar(int i);
+        public abstract long GetChars(int i, long dataIndex, char[] buffer, int bufferIndex, int length);
+        public IDataReader GetData(int i);
+        public abstract string GetDataTypeName(int i);
+        public abstract DateTime GetDateTime(int i);
+        protected virtual DbDataReader GetDbDataReader(int i);
+        public abstract decimal GetDecimal(int i);
+        public abstract double GetDouble(int i);
+        public abstract Type GetFieldType(int i);
+        public abstract float GetFloat(int i);
+        public abstract Guid GetGuid(int i);
+        public abstract short GetInt16(int i);
+        public abstract int GetInt32(int i);
+        public abstract long GetInt64(int i);
+        public abstract string GetName(int i);
+        public abstract int GetOrdinal(string name);
+        public abstract string GetString(int i);
+        public abstract object GetValue(int i);
+        public abstract int GetValues(object[] values);
+        public abstract bool IsDBNull(int i);
+    }
+    public abstract class DbDataSourceEnumerator {
+        protected DbDataSourceEnumerator();
+        public abstract DataTable GetDataSources();
+    }
+    public class DbEnumerator : IEnumerator {
+        public DbEnumerator(DbDataReader reader);
+        public DbEnumerator(DbDataReader reader, bool closeReader);
+        public DbEnumerator(IDataReader reader);
+        public DbEnumerator(IDataReader reader, bool closeReader);
+        public object Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public abstract class DbException : ExternalException {
+        protected DbException();
+        protected DbException(SerializationInfo info, StreamingContext context);
+        protected DbException(string message);
+        protected DbException(string message, Exception innerException);
+        protected DbException(string message, int errorCode);
+    }
+    public static class DbMetaDataCollectionNames {
+        public static readonly string DataSourceInformation;
+        public static readonly string DataTypes;
+        public static readonly string MetaDataCollections;
+        public static readonly string ReservedWords;
+        public static readonly string Restrictions;
+    }
+    public static class DbMetaDataColumnNames {
+        public static readonly string CollectionName;
+        public static readonly string ColumnSize;
+        public static readonly string CompositeIdentifierSeparatorPattern;
+        public static readonly string CreateFormat;
+        public static readonly string CreateParameters;
+        public static readonly string DataSourceProductName;
+        public static readonly string DataSourceProductVersion;
+        public static readonly string DataSourceProductVersionNormalized;
+        public static readonly string DataType;
+        public static readonly string GroupByBehavior;
+        public static readonly string IdentifierCase;
+        public static readonly string IdentifierPattern;
+        public static readonly string IsAutoIncrementable;
+        public static readonly string IsBestMatch;
+        public static readonly string IsCaseSensitive;
+        public static readonly string IsConcurrencyType;
+        public static readonly string IsFixedLength;
+        public static readonly string IsFixedPrecisionScale;
+        public static readonly string IsLiteralSupported;
+        public static readonly string IsLong;
+        public static readonly string IsNullable;
+        public static readonly string IsSearchable;
+        public static readonly string IsSearchableWithLike;
+        public static readonly string IsUnsigned;
+        public static readonly string LiteralPrefix;
+        public static readonly string LiteralSuffix;
+        public static readonly string MaximumScale;
+        public static readonly string MinimumScale;
+        public static readonly string NumberOfIdentifierParts;
+        public static readonly string NumberOfRestrictions;
+        public static readonly string OrderByColumnsInSelect;
+        public static readonly string ParameterMarkerFormat;
+        public static readonly string ParameterMarkerPattern;
+        public static readonly string ParameterNameMaxLength;
+        public static readonly string ParameterNamePattern;
+        public static readonly string ProviderDbType;
+        public static readonly string QuotedIdentifierCase;
+        public static readonly string QuotedIdentifierPattern;
+        public static readonly string ReservedWord;
+        public static readonly string StatementSeparatorPattern;
+        public static readonly string StringLiteralPattern;
+        public static readonly string SupportedJoinOperators;
+        public static readonly string TypeName;
+    }
+    public abstract class DbParameter : MarshalByRefObject, IDataParameter, IDbDataParameter {
+        protected DbParameter();
+        public abstract DbType DbType { get; set; }
+        public abstract ParameterDirection Direction { get; set; }
+        public abstract bool IsNullable { get; set; }
+        public abstract string ParameterName { get; set; }
+        public virtual byte Precision { get; set; }
+        public virtual byte Scale { get; set; }
+        public abstract int Size { get; set; }
+        public abstract string SourceColumn { get; set; }
+        public abstract bool SourceColumnNullMapping { get; set; }
+        public virtual DataRowVersion SourceVersion { get; set; }
+        public abstract object Value { get; set; }
+        public abstract void ResetDbType();
+    }
+    public abstract class DbParameterCollection : MarshalByRefObject, ICollection, IDataParameterCollection, IEnumerable, IList {
+        protected DbParameterCollection();
+        public abstract int Count { get; }
+        public virtual bool IsFixedSize { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual bool IsSynchronized { get; }
+        public DbParameter this[int index] { get; set; }
+        public DbParameter this[string parameterName] { get; set; }
+        public abstract object SyncRoot { get; }
+        public abstract int Add(object value);
+        public abstract void AddRange(Array values);
+        public abstract void Clear();
+        public abstract bool Contains(object value);
+        public abstract bool Contains(string value);
+        public abstract void CopyTo(Array array, int index);
+        public abstract IEnumerator GetEnumerator();
+        protected abstract DbParameter GetParameter(int index);
+        protected abstract DbParameter GetParameter(string parameterName);
+        public abstract int IndexOf(object value);
+        public abstract int IndexOf(string parameterName);
+        public abstract void Insert(int index, object value);
+        public abstract void Remove(object value);
+        public abstract void RemoveAt(int index);
+        public abstract void RemoveAt(string parameterName);
+        protected abstract void SetParameter(int index, DbParameter value);
+        protected abstract void SetParameter(string parameterName, DbParameter value);
+    }
+    public abstract class DbProviderFactory {
+        protected DbProviderFactory();
+        public virtual bool CanCreateDataSourceEnumerator { get; }
+        public virtual DbCommand CreateCommand();
+        public virtual DbCommandBuilder CreateCommandBuilder();
+        public virtual DbConnection CreateConnection();
+        public virtual DbConnectionStringBuilder CreateConnectionStringBuilder();
+        public virtual DbDataAdapter CreateDataAdapter();
+        public virtual DbDataSourceEnumerator CreateDataSourceEnumerator();
+        public virtual DbParameter CreateParameter();
+    }
+    public sealed class DbProviderSpecificTypePropertyAttribute : Attribute {
+        public DbProviderSpecificTypePropertyAttribute(bool isProviderSpecificTypeProperty);
+        public bool IsProviderSpecificTypeProperty { get; }
+    }
+    public abstract class DbTransaction : MarshalByRefObject, IDbTransaction, IDisposable {
+        protected DbTransaction();
+        public DbConnection Connection { get; }
+        protected abstract DbConnection DbConnection { get; }
+        public abstract IsolationLevel IsolationLevel { get; }
+        public abstract void Commit();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract void Rollback();
+    }
+    public enum GroupByBehavior {
+        ExactMatch = 4,
+        MustContainAll = 3,
+        NotSupported = 1,
+        Unknown = 0,
+        Unrelated = 2,
+    }
+    public enum IdentifierCase {
+        Insensitive = 1,
+        Sensitive = 2,
+        Unknown = 0,
+    }
+    public class RowUpdatedEventArgs : EventArgs {
+        public RowUpdatedEventArgs(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
+        public IDbCommand Command { get; }
+        public Exception Errors { get; set; }
+        public int RecordsAffected { get; }
+        public DataRow Row { get; }
+        public int RowCount { get; }
+        public StatementType StatementType { get; }
+        public UpdateStatus Status { get; set; }
+        public DataTableMapping TableMapping { get; }
+        public void CopyToRows(DataRow[] array);
+        public void CopyToRows(DataRow[] array, int arrayIndex);
+    }
+    public class RowUpdatingEventArgs : EventArgs {
+        public RowUpdatingEventArgs(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
+        protected virtual IDbCommand BaseCommand { get; set; }
+        public IDbCommand Command { get; set; }
+        public Exception Errors { get; set; }
+        public DataRow Row { get; }
+        public StatementType StatementType { get; }
+        public UpdateStatus Status { get; set; }
+        public DataTableMapping TableMapping { get; }
+    }
+    public static class SchemaTableColumn {
+        public static readonly string AllowDBNull;
+        public static readonly string BaseColumnName;
+        public static readonly string BaseSchemaName;
+        public static readonly string BaseTableName;
+        public static readonly string ColumnName;
+        public static readonly string ColumnOrdinal;
+        public static readonly string ColumnSize;
+        public static readonly string DataType;
+        public static readonly string IsAliased;
+        public static readonly string IsExpression;
+        public static readonly string IsKey;
+        public static readonly string IsLong;
+        public static readonly string IsUnique;
+        public static readonly string NonVersionedProviderType;
+        public static readonly string NumericPrecision;
+        public static readonly string NumericScale;
+        public static readonly string ProviderType;
+    }
+    public static class SchemaTableOptionalColumn {
+        public static readonly string AutoIncrementSeed;
+        public static readonly string AutoIncrementStep;
+        public static readonly string BaseCatalogName;
+        public static readonly string BaseColumnNamespace;
+        public static readonly string BaseServerName;
+        public static readonly string BaseTableNamespace;
+        public static readonly string ColumnMapping;
+        public static readonly string DefaultValue;
+        public static readonly string Expression;
+        public static readonly string IsAutoIncrement;
+        public static readonly string IsHidden;
+        public static readonly string IsReadOnly;
+        public static readonly string IsRowVersion;
+        public static readonly string ProviderSpecificDataType;
+    }
+    public enum SupportedJoinOperators {
+        FullOuter = 8,
+        Inner = 1,
+        LeftOuter = 2,
+        None = 0,
+        RightOuter = 4,
+    }
+}
+namespace System.Data.SqlTypes {
+    public interface INullable {
+        bool IsNull { get; }
+    }
+    public sealed class SqlAlreadyFilledException : SqlTypeException {
+        public SqlAlreadyFilledException();
+        public SqlAlreadyFilledException(string message);
+        public SqlAlreadyFilledException(string message, Exception e);
+    }
+    public struct SqlBinary : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlBinary Null;
+        public SqlBinary(byte[] value);
+        public bool IsNull { get; }
+        public byte this[int index] { get; }
+        public int Length { get; }
+        public byte[] Value { get; }
+        public static SqlBinary Add(SqlBinary x, SqlBinary y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlBinary value);
+        public static SqlBinary Concat(SqlBinary x, SqlBinary y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlBinary x, SqlBinary y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlBinary x, SqlBinary y);
+        public static SqlBoolean GreaterThanOrEqual(SqlBinary x, SqlBinary y);
+        public static SqlBoolean LessThan(SqlBinary x, SqlBinary y);
+        public static SqlBoolean LessThanOrEqual(SqlBinary x, SqlBinary y);
+        public static SqlBoolean NotEquals(SqlBinary x, SqlBinary y);
+        public static SqlBinary operator +(SqlBinary x, SqlBinary y);
+        public static SqlBoolean operator ==(SqlBinary x, SqlBinary y);
+        public static explicit operator byte[] (SqlBinary x);
+        public static explicit operator SqlBinary (SqlGuid x);
+        public static SqlBoolean operator >(SqlBinary x, SqlBinary y);
+        public static SqlBoolean operator >=(SqlBinary x, SqlBinary y);
+        public static implicit operator SqlBinary (byte[] x);
+        public static SqlBoolean operator !=(SqlBinary x, SqlBinary y);
+        public static SqlBoolean operator <(SqlBinary x, SqlBinary y);
+        public static SqlBoolean operator <=(SqlBinary x, SqlBinary y);
+        public SqlGuid ToSqlGuid();
+        public override string ToString();
+    }
+    public struct SqlBoolean : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlBoolean False;
+        public static readonly SqlBoolean Null;
+        public static readonly SqlBoolean One;
+        public static readonly SqlBoolean True;
+        public static readonly SqlBoolean Zero;
+        public SqlBoolean(bool value);
+        public SqlBoolean(int value);
+        public byte ByteValue { get; }
+        public bool IsFalse { get; }
+        public bool IsNull { get; }
+        public bool IsTrue { get; }
+        public bool Value { get; }
+        public static SqlBoolean And(SqlBoolean x, SqlBoolean y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlBoolean value);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlBoolean x, SqlBoolean y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean GreaterThanOrEquals(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean LessThan(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean LessThanOrEquals(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean NotEquals(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean OnesComplement(SqlBoolean x);
+        public static SqlBoolean operator &(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator |(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator ==(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator ^(SqlBoolean x, SqlBoolean y);
+        public static explicit operator bool (SqlBoolean x);
+        public static explicit operator SqlBoolean (SqlByte x);
+        public static explicit operator SqlBoolean (SqlDecimal x);
+        public static explicit operator SqlBoolean (SqlDouble x);
+        public static explicit operator SqlBoolean (SqlInt16 x);
+        public static explicit operator SqlBoolean (SqlInt32 x);
+        public static explicit operator SqlBoolean (SqlInt64 x);
+        public static explicit operator SqlBoolean (SqlMoney x);
+        public static explicit operator SqlBoolean (SqlSingle x);
+        public static explicit operator SqlBoolean (SqlString x);
+        public static bool operator false(SqlBoolean x);
+        public static SqlBoolean operator >(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator >=(SqlBoolean x, SqlBoolean y);
+        public static implicit operator SqlBoolean (bool x);
+        public static SqlBoolean operator !=(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator <(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator <=(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean operator !(SqlBoolean x);
+        public static SqlBoolean operator ~(SqlBoolean x);
+        public static bool operator true(SqlBoolean x);
+        public static SqlBoolean Or(SqlBoolean x, SqlBoolean y);
+        public static SqlBoolean Parse(string s);
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlBoolean Xor(SqlBoolean x, SqlBoolean y);
+    }
+    public struct SqlByte : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlByte MaxValue;
+        public static readonly SqlByte MinValue;
+        public static readonly SqlByte Null;
+        public static readonly SqlByte Zero;
+        public SqlByte(byte value);
+        public bool IsNull { get; }
+        public byte Value { get; }
+        public static SqlByte Add(SqlByte x, SqlByte y);
+        public static SqlByte BitwiseAnd(SqlByte x, SqlByte y);
+        public static SqlByte BitwiseOr(SqlByte x, SqlByte y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlByte value);
+        public static SqlByte Divide(SqlByte x, SqlByte y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlByte x, SqlByte y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlByte x, SqlByte y);
+        public static SqlBoolean GreaterThanOrEqual(SqlByte x, SqlByte y);
+        public static SqlBoolean LessThan(SqlByte x, SqlByte y);
+        public static SqlBoolean LessThanOrEqual(SqlByte x, SqlByte y);
+        public static SqlByte Mod(SqlByte x, SqlByte y);
+        public static SqlByte Modulus(SqlByte x, SqlByte y);
+        public static SqlByte Multiply(SqlByte x, SqlByte y);
+        public static SqlBoolean NotEquals(SqlByte x, SqlByte y);
+        public static SqlByte OnesComplement(SqlByte x);
+        public static SqlByte operator +(SqlByte x, SqlByte y);
+        public static SqlByte operator &(SqlByte x, SqlByte y);
+        public static SqlByte operator |(SqlByte x, SqlByte y);
+        public static SqlByte operator /(SqlByte x, SqlByte y);
+        public static SqlBoolean operator ==(SqlByte x, SqlByte y);
+        public static SqlByte operator ^(SqlByte x, SqlByte y);
+        public static explicit operator SqlByte (SqlBoolean x);
+        public static explicit operator byte (SqlByte x);
+        public static explicit operator SqlByte (SqlDecimal x);
+        public static explicit operator SqlByte (SqlDouble x);
+        public static explicit operator SqlByte (SqlInt16 x);
+        public static explicit operator SqlByte (SqlInt32 x);
+        public static explicit operator SqlByte (SqlInt64 x);
+        public static explicit operator SqlByte (SqlMoney x);
+        public static explicit operator SqlByte (SqlSingle x);
+        public static explicit operator SqlByte (SqlString x);
+        public static SqlBoolean operator >(SqlByte x, SqlByte y);
+        public static SqlBoolean operator >=(SqlByte x, SqlByte y);
+        public static implicit operator SqlByte (byte x);
+        public static SqlBoolean operator !=(SqlByte x, SqlByte y);
+        public static SqlBoolean operator <(SqlByte x, SqlByte y);
+        public static SqlBoolean operator <=(SqlByte x, SqlByte y);
+        public static SqlByte operator %(SqlByte x, SqlByte y);
+        public static SqlByte operator *(SqlByte x, SqlByte y);
+        public static SqlByte operator ~(SqlByte x);
+        public static SqlByte operator -(SqlByte x, SqlByte y);
+        public static SqlByte Parse(string s);
+        public static SqlByte Subtract(SqlByte x, SqlByte y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlByte Xor(SqlByte x, SqlByte y);
+    }
+    public sealed class SqlBytes : INullable, ISerializable, IXmlSerializable {
+        public SqlBytes();
+        public SqlBytes(byte[] buffer);
+        public SqlBytes(SqlBinary value);
+        public SqlBytes(Stream s);
+        public byte[] Buffer { get; }
+        public bool IsNull { get; }
+        public byte this[long offset] { get; set; }
+        public long Length { get; }
+        public long MaxLength { get; }
+        public static SqlBytes Null { get; }
+        public StorageState Storage { get; }
+        public Stream Stream { get; set; }
+        public byte[] Value { get; }
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static explicit operator SqlBytes (SqlBinary value);
+        public static explicit operator SqlBinary (SqlBytes value);
+        public long Read(long offset, byte[] buffer, int offsetInBuffer, int count);
+        public void SetLength(long value);
+        public void SetNull();
+        public SqlBinary ToSqlBinary();
+        public void Write(long offset, byte[] buffer, int offsetInBuffer, int count);
+    }
+    public sealed class SqlChars : INullable, ISerializable, IXmlSerializable {
+        public SqlChars();
+        public SqlChars(char[] buffer);
+        public SqlChars(SqlString value);
+        public char[] Buffer { get; }
+        public bool IsNull { get; }
+        public char this[long offset] { get; set; }
+        public long Length { get; }
+        public long MaxLength { get; }
+        public static SqlChars Null { get; }
+        public StorageState Storage { get; }
+        public char[] Value { get; }
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static explicit operator SqlString (SqlChars value);
+        public static explicit operator SqlChars (SqlString value);
+        public long Read(long offset, char[] buffer, int offsetInBuffer, int count);
+        public void SetLength(long value);
+        public void SetNull();
+        public SqlString ToSqlString();
+        public void Write(long offset, char[] buffer, int offsetInBuffer, int count);
+    }
+    public enum SqlCompareOptions {
+        BinarySort = 32768,
+        BinarySort2 = 16384,
+        IgnoreCase = 1,
+        IgnoreKanaType = 8,
+        IgnoreNonSpace = 2,
+        IgnoreWidth = 16,
+        None = 0,
+    }
+    public struct SqlDateTime : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlDateTime MaxValue;
+        public static readonly SqlDateTime MinValue;
+        public static readonly SqlDateTime Null;
+        public static readonly int SQLTicksPerHour;
+        public static readonly int SQLTicksPerMinute;
+        public static readonly int SQLTicksPerSecond;
+        public SqlDateTime(DateTime value);
+        public SqlDateTime(int dayTicks, int timeTicks);
+        public SqlDateTime(int year, int month, int day);
+        public SqlDateTime(int year, int month, int day, int hour, int minute, int second);
+        public SqlDateTime(int year, int month, int day, int hour, int minute, int second, double millisecond);
+        public SqlDateTime(int year, int month, int day, int hour, int minute, int second, int bilisecond);
+        public int DayTicks { get; }
+        public bool IsNull { get; }
+        public int TimeTicks { get; }
+        public DateTime Value { get; }
+        public static SqlDateTime Add(SqlDateTime x, TimeSpan t);
+        public int CompareTo(object value);
+        public int CompareTo(SqlDateTime value);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlDateTime x, SqlDateTime y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean GreaterThanOrEqual(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean LessThan(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean LessThanOrEqual(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean NotEquals(SqlDateTime x, SqlDateTime y);
+        public static SqlDateTime operator +(SqlDateTime x, TimeSpan t);
+        public static SqlBoolean operator ==(SqlDateTime x, SqlDateTime y);
+        public static explicit operator DateTime (SqlDateTime x);
+        public static explicit operator SqlDateTime (SqlString x);
+        public static SqlBoolean operator >(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean operator >=(SqlDateTime x, SqlDateTime y);
+        public static implicit operator SqlDateTime (DateTime value);
+        public static SqlBoolean operator !=(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean operator <(SqlDateTime x, SqlDateTime y);
+        public static SqlBoolean operator <=(SqlDateTime x, SqlDateTime y);
+        public static SqlDateTime operator -(SqlDateTime x, TimeSpan t);
+        public static SqlDateTime Parse(string s);
+        public static SqlDateTime Subtract(SqlDateTime x, TimeSpan t);
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    public struct SqlDecimal : IComparable, INullable, IXmlSerializable {
+        public static readonly byte MaxPrecision;
+        public static readonly byte MaxScale;
+        public static readonly SqlDecimal MaxValue;
+        public static readonly SqlDecimal MinValue;
+        public static readonly SqlDecimal Null;
+        public SqlDecimal(byte bPrecision, byte bScale, bool fPositive, int data1, int data2, int data3, int data4);
+        public SqlDecimal(byte bPrecision, byte bScale, bool fPositive, int[] bits);
+        public SqlDecimal(decimal value);
+        public SqlDecimal(double dVal);
+        public SqlDecimal(int value);
+        public SqlDecimal(long value);
+        public byte[] BinData { get; }
+        public int[] Data { get; }
+        public bool IsNull { get; }
+        public bool IsPositive { get; }
+        public byte Precision { get; }
+        public byte Scale { get; }
+        public decimal Value { get; }
+        public static SqlDecimal Abs(SqlDecimal n);
+        public static SqlDecimal Add(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal AdjustScale(SqlDecimal n, int digits, bool fRound);
+        public static SqlDecimal Ceiling(SqlDecimal n);
+        public int CompareTo(object value);
+        public int CompareTo(SqlDecimal value);
+        public static SqlDecimal ConvertToPrecScale(SqlDecimal n, int precision, int scale);
+        public static SqlDecimal Divide(SqlDecimal x, SqlDecimal y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal Floor(SqlDecimal n);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean GreaterThanOrEqual(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean LessThan(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean LessThanOrEqual(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal Multiply(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean NotEquals(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator +(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator /(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean operator ==(SqlDecimal x, SqlDecimal y);
+        public static explicit operator SqlDecimal (double x);
+        public static explicit operator SqlDecimal (SqlBoolean x);
+        public static explicit operator decimal (SqlDecimal x);
+        public static explicit operator SqlDecimal (SqlDouble x);
+        public static explicit operator SqlDecimal (SqlSingle x);
+        public static explicit operator SqlDecimal (SqlString x);
+        public static SqlBoolean operator >(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean operator >=(SqlDecimal x, SqlDecimal y);
+        public static implicit operator SqlDecimal (decimal x);
+        public static implicit operator SqlDecimal (long x);
+        public static implicit operator SqlDecimal (SqlByte x);
+        public static implicit operator SqlDecimal (SqlInt16 x);
+        public static implicit operator SqlDecimal (SqlInt32 x);
+        public static implicit operator SqlDecimal (SqlInt64 x);
+        public static implicit operator SqlDecimal (SqlMoney x);
+        public static SqlBoolean operator !=(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean operator <(SqlDecimal x, SqlDecimal y);
+        public static SqlBoolean operator <=(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator *(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator -(SqlDecimal x, SqlDecimal y);
+        public static SqlDecimal operator -(SqlDecimal x);
+        public static SqlDecimal Parse(string s);
+        public static SqlDecimal Power(SqlDecimal n, double exp);
+        public static SqlDecimal Round(SqlDecimal n, int position);
+        public static SqlInt32 Sign(SqlDecimal n);
+        public static SqlDecimal Subtract(SqlDecimal x, SqlDecimal y);
+        public double ToDouble();
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlDecimal Truncate(SqlDecimal n, int position);
+    }
+    public struct SqlDouble : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlDouble MaxValue;
+        public static readonly SqlDouble MinValue;
+        public static readonly SqlDouble Null;
+        public static readonly SqlDouble Zero;
+        public SqlDouble(double value);
+        public bool IsNull { get; }
+        public double Value { get; }
+        public static SqlDouble Add(SqlDouble x, SqlDouble y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlDouble value);
+        public static SqlDouble Divide(SqlDouble x, SqlDouble y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlDouble x, SqlDouble y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlDouble x, SqlDouble y);
+        public static SqlBoolean GreaterThanOrEqual(SqlDouble x, SqlDouble y);
+        public static SqlBoolean LessThan(SqlDouble x, SqlDouble y);
+        public static SqlBoolean LessThanOrEqual(SqlDouble x, SqlDouble y);
+        public static SqlDouble Multiply(SqlDouble x, SqlDouble y);
+        public static SqlBoolean NotEquals(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator +(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator /(SqlDouble x, SqlDouble y);
+        public static SqlBoolean operator ==(SqlDouble x, SqlDouble y);
+        public static explicit operator SqlDouble (SqlBoolean x);
+        public static explicit operator double (SqlDouble x);
+        public static explicit operator SqlDouble (SqlString x);
+        public static SqlBoolean operator >(SqlDouble x, SqlDouble y);
+        public static SqlBoolean operator >=(SqlDouble x, SqlDouble y);
+        public static implicit operator SqlDouble (double x);
+        public static implicit operator SqlDouble (SqlByte x);
+        public static implicit operator SqlDouble (SqlDecimal x);
+        public static implicit operator SqlDouble (SqlInt16 x);
+        public static implicit operator SqlDouble (SqlInt32 x);
+        public static implicit operator SqlDouble (SqlInt64 x);
+        public static implicit operator SqlDouble (SqlMoney x);
+        public static implicit operator SqlDouble (SqlSingle x);
+        public static SqlBoolean operator !=(SqlDouble x, SqlDouble y);
+        public static SqlBoolean operator <(SqlDouble x, SqlDouble y);
+        public static SqlBoolean operator <=(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator *(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator -(SqlDouble x, SqlDouble y);
+        public static SqlDouble operator -(SqlDouble x);
+        public static SqlDouble Parse(string s);
+        public static SqlDouble Subtract(SqlDouble x, SqlDouble y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    public struct SqlGuid : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlGuid Null;
+        public SqlGuid(byte[] value);
+        public SqlGuid(Guid g);
+        public SqlGuid(int a, short b, short c, byte d, byte e, byte f, byte g, byte h, byte i, byte j, byte k);
+        public SqlGuid(string s);
+        public bool IsNull { get; }
+        public Guid Value { get; }
+        public int CompareTo(object value);
+        public int CompareTo(SqlGuid value);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlGuid x, SqlGuid y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlGuid x, SqlGuid y);
+        public static SqlBoolean GreaterThanOrEqual(SqlGuid x, SqlGuid y);
+        public static SqlBoolean LessThan(SqlGuid x, SqlGuid y);
+        public static SqlBoolean LessThanOrEqual(SqlGuid x, SqlGuid y);
+        public static SqlBoolean NotEquals(SqlGuid x, SqlGuid y);
+        public static SqlBoolean operator ==(SqlGuid x, SqlGuid y);
+        public static explicit operator SqlGuid (SqlBinary x);
+        public static explicit operator Guid (SqlGuid x);
+        public static explicit operator SqlGuid (SqlString x);
+        public static SqlBoolean operator >(SqlGuid x, SqlGuid y);
+        public static SqlBoolean operator >=(SqlGuid x, SqlGuid y);
+        public static implicit operator SqlGuid (Guid x);
+        public static SqlBoolean operator !=(SqlGuid x, SqlGuid y);
+        public static SqlBoolean operator <(SqlGuid x, SqlGuid y);
+        public static SqlBoolean operator <=(SqlGuid x, SqlGuid y);
+        public static SqlGuid Parse(string s);
+        public byte[] ToByteArray();
+        public SqlBinary ToSqlBinary();
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    public struct SqlInt16 : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlInt16 MaxValue;
+        public static readonly SqlInt16 MinValue;
+        public static readonly SqlInt16 Null;
+        public static readonly SqlInt16 Zero;
+        public SqlInt16(short value);
+        public bool IsNull { get; }
+        public short Value { get; }
+        public static SqlInt16 Add(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 BitwiseAnd(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 BitwiseOr(SqlInt16 x, SqlInt16 y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlInt16 value);
+        public static SqlInt16 Divide(SqlInt16 x, SqlInt16 y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlInt16 x, SqlInt16 y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean GreaterThanOrEqual(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean LessThan(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean LessThanOrEqual(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 Mod(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 Modulus(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 Multiply(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean NotEquals(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 OnesComplement(SqlInt16 x);
+        public static SqlInt16 operator +(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator &(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator |(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator /(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean operator ==(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator ^(SqlInt16 x, SqlInt16 y);
+        public static explicit operator SqlInt16 (SqlBoolean x);
+        public static explicit operator SqlInt16 (SqlDecimal x);
+        public static explicit operator SqlInt16 (SqlDouble x);
+        public static explicit operator short (SqlInt16 x);
+        public static explicit operator SqlInt16 (SqlInt32 x);
+        public static explicit operator SqlInt16 (SqlInt64 x);
+        public static explicit operator SqlInt16 (SqlMoney x);
+        public static explicit operator SqlInt16 (SqlSingle x);
+        public static explicit operator SqlInt16 (SqlString x);
+        public static SqlBoolean operator >(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean operator >=(SqlInt16 x, SqlInt16 y);
+        public static implicit operator SqlInt16 (short x);
+        public static implicit operator SqlInt16 (SqlByte x);
+        public static SqlBoolean operator !=(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean operator <(SqlInt16 x, SqlInt16 y);
+        public static SqlBoolean operator <=(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator %(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator *(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator ~(SqlInt16 x);
+        public static SqlInt16 operator -(SqlInt16 x, SqlInt16 y);
+        public static SqlInt16 operator -(SqlInt16 x);
+        public static SqlInt16 Parse(string s);
+        public static SqlInt16 Subtract(SqlInt16 x, SqlInt16 y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlInt16 Xor(SqlInt16 x, SqlInt16 y);
+    }
+    public struct SqlInt32 : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlInt32 MaxValue;
+        public static readonly SqlInt32 MinValue;
+        public static readonly SqlInt32 Null;
+        public static readonly SqlInt32 Zero;
+        public SqlInt32(int value);
+        public bool IsNull { get; }
+        public int Value { get; }
+        public static SqlInt32 Add(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 BitwiseAnd(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 BitwiseOr(SqlInt32 x, SqlInt32 y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlInt32 value);
+        public static SqlInt32 Divide(SqlInt32 x, SqlInt32 y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlInt32 x, SqlInt32 y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean GreaterThanOrEqual(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean LessThan(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean LessThanOrEqual(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 Mod(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 Modulus(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 Multiply(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean NotEquals(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 OnesComplement(SqlInt32 x);
+        public static SqlInt32 operator +(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator &(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator |(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator /(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean operator ==(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator ^(SqlInt32 x, SqlInt32 y);
+        public static explicit operator SqlInt32 (SqlBoolean x);
+        public static explicit operator SqlInt32 (SqlDecimal x);
+        public static explicit operator SqlInt32 (SqlDouble x);
+        public static explicit operator int (SqlInt32 x);
+        public static explicit operator SqlInt32 (SqlInt64 x);
+        public static explicit operator SqlInt32 (SqlMoney x);
+        public static explicit operator SqlInt32 (SqlSingle x);
+        public static explicit operator SqlInt32 (SqlString x);
+        public static SqlBoolean operator >(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean operator >=(SqlInt32 x, SqlInt32 y);
+        public static implicit operator SqlInt32 (int x);
+        public static implicit operator SqlInt32 (SqlByte x);
+        public static implicit operator SqlInt32 (SqlInt16 x);
+        public static SqlBoolean operator !=(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean operator <(SqlInt32 x, SqlInt32 y);
+        public static SqlBoolean operator <=(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator %(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator *(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator ~(SqlInt32 x);
+        public static SqlInt32 operator -(SqlInt32 x, SqlInt32 y);
+        public static SqlInt32 operator -(SqlInt32 x);
+        public static SqlInt32 Parse(string s);
+        public static SqlInt32 Subtract(SqlInt32 x, SqlInt32 y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlInt32 Xor(SqlInt32 x, SqlInt32 y);
+    }
+    public struct SqlInt64 : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlInt64 MaxValue;
+        public static readonly SqlInt64 MinValue;
+        public static readonly SqlInt64 Null;
+        public static readonly SqlInt64 Zero;
+        public SqlInt64(long value);
+        public bool IsNull { get; }
+        public long Value { get; }
+        public static SqlInt64 Add(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 BitwiseAnd(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 BitwiseOr(SqlInt64 x, SqlInt64 y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlInt64 value);
+        public static SqlInt64 Divide(SqlInt64 x, SqlInt64 y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlInt64 x, SqlInt64 y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean GreaterThanOrEqual(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean LessThan(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean LessThanOrEqual(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 Mod(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 Modulus(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 Multiply(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean NotEquals(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 OnesComplement(SqlInt64 x);
+        public static SqlInt64 operator +(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator &(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator |(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator /(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean operator ==(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator ^(SqlInt64 x, SqlInt64 y);
+        public static explicit operator SqlInt64 (SqlBoolean x);
+        public static explicit operator SqlInt64 (SqlDecimal x);
+        public static explicit operator SqlInt64 (SqlDouble x);
+        public static explicit operator long (SqlInt64 x);
+        public static explicit operator SqlInt64 (SqlMoney x);
+        public static explicit operator SqlInt64 (SqlSingle x);
+        public static explicit operator SqlInt64 (SqlString x);
+        public static SqlBoolean operator >(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean operator >=(SqlInt64 x, SqlInt64 y);
+        public static implicit operator SqlInt64 (long x);
+        public static implicit operator SqlInt64 (SqlByte x);
+        public static implicit operator SqlInt64 (SqlInt16 x);
+        public static implicit operator SqlInt64 (SqlInt32 x);
+        public static SqlBoolean operator !=(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean operator <(SqlInt64 x, SqlInt64 y);
+        public static SqlBoolean operator <=(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator %(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator *(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator ~(SqlInt64 x);
+        public static SqlInt64 operator -(SqlInt64 x, SqlInt64 y);
+        public static SqlInt64 operator -(SqlInt64 x);
+        public static SqlInt64 Parse(string s);
+        public static SqlInt64 Subtract(SqlInt64 x, SqlInt64 y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+        public static SqlInt64 Xor(SqlInt64 x, SqlInt64 y);
+    }
+    public struct SqlMoney : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlMoney MaxValue;
+        public static readonly SqlMoney MinValue;
+        public static readonly SqlMoney Null;
+        public static readonly SqlMoney Zero;
+        public SqlMoney(decimal value);
+        public SqlMoney(double value);
+        public SqlMoney(int value);
+        public SqlMoney(long value);
+        public bool IsNull { get; }
+        public decimal Value { get; }
+        public static SqlMoney Add(SqlMoney x, SqlMoney y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlMoney value);
+        public static SqlMoney Divide(SqlMoney x, SqlMoney y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlMoney x, SqlMoney y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlMoney x, SqlMoney y);
+        public static SqlBoolean GreaterThanOrEqual(SqlMoney x, SqlMoney y);
+        public static SqlBoolean LessThan(SqlMoney x, SqlMoney y);
+        public static SqlBoolean LessThanOrEqual(SqlMoney x, SqlMoney y);
+        public static SqlMoney Multiply(SqlMoney x, SqlMoney y);
+        public static SqlBoolean NotEquals(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator +(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator /(SqlMoney x, SqlMoney y);
+        public static SqlBoolean operator ==(SqlMoney x, SqlMoney y);
+        public static explicit operator SqlMoney (double x);
+        public static explicit operator SqlMoney (SqlBoolean x);
+        public static explicit operator SqlMoney (SqlDecimal x);
+        public static explicit operator SqlMoney (SqlDouble x);
+        public static explicit operator decimal (SqlMoney x);
+        public static explicit operator SqlMoney (SqlSingle x);
+        public static explicit operator SqlMoney (SqlString x);
+        public static SqlBoolean operator >(SqlMoney x, SqlMoney y);
+        public static SqlBoolean operator >=(SqlMoney x, SqlMoney y);
+        public static implicit operator SqlMoney (decimal x);
+        public static implicit operator SqlMoney (long x);
+        public static implicit operator SqlMoney (SqlByte x);
+        public static implicit operator SqlMoney (SqlInt16 x);
+        public static implicit operator SqlMoney (SqlInt32 x);
+        public static implicit operator SqlMoney (SqlInt64 x);
+        public static SqlBoolean operator !=(SqlMoney x, SqlMoney y);
+        public static SqlBoolean operator <(SqlMoney x, SqlMoney y);
+        public static SqlBoolean operator <=(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator *(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator -(SqlMoney x, SqlMoney y);
+        public static SqlMoney operator -(SqlMoney x);
+        public static SqlMoney Parse(string s);
+        public static SqlMoney Subtract(SqlMoney x, SqlMoney y);
+        public decimal ToDecimal();
+        public double ToDouble();
+        public int ToInt32();
+        public long ToInt64();
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlSingle ToSqlSingle();
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    public sealed class SqlNotFilledException : SqlTypeException {
+        public SqlNotFilledException();
+        public SqlNotFilledException(string message);
+        public SqlNotFilledException(string message, Exception e);
+    }
+    public sealed class SqlNullValueException : SqlTypeException {
+        public SqlNullValueException();
+        public SqlNullValueException(string message);
+        public SqlNullValueException(string message, Exception e);
+    }
+    public struct SqlSingle : IComparable, INullable, IXmlSerializable {
+        public static readonly SqlSingle MaxValue;
+        public static readonly SqlSingle MinValue;
+        public static readonly SqlSingle Null;
+        public static readonly SqlSingle Zero;
+        public SqlSingle(double value);
+        public SqlSingle(float value);
+        public bool IsNull { get; }
+        public float Value { get; }
+        public static SqlSingle Add(SqlSingle x, SqlSingle y);
+        public int CompareTo(object value);
+        public int CompareTo(SqlSingle value);
+        public static SqlSingle Divide(SqlSingle x, SqlSingle y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlSingle x, SqlSingle y);
+        public override int GetHashCode();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlSingle x, SqlSingle y);
+        public static SqlBoolean GreaterThanOrEqual(SqlSingle x, SqlSingle y);
+        public static SqlBoolean LessThan(SqlSingle x, SqlSingle y);
+        public static SqlBoolean LessThanOrEqual(SqlSingle x, SqlSingle y);
+        public static SqlSingle Multiply(SqlSingle x, SqlSingle y);
+        public static SqlBoolean NotEquals(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator +(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator /(SqlSingle x, SqlSingle y);
+        public static SqlBoolean operator ==(SqlSingle x, SqlSingle y);
+        public static explicit operator SqlSingle (SqlBoolean x);
+        public static explicit operator SqlSingle (SqlDouble x);
+        public static explicit operator float (SqlSingle x);
+        public static explicit operator SqlSingle (SqlString x);
+        public static SqlBoolean operator >(SqlSingle x, SqlSingle y);
+        public static SqlBoolean operator >=(SqlSingle x, SqlSingle y);
+        public static implicit operator SqlSingle (float x);
+        public static implicit operator SqlSingle (SqlByte x);
+        public static implicit operator SqlSingle (SqlDecimal x);
+        public static implicit operator SqlSingle (SqlInt16 x);
+        public static implicit operator SqlSingle (SqlInt32 x);
+        public static implicit operator SqlSingle (SqlInt64 x);
+        public static implicit operator SqlSingle (SqlMoney x);
+        public static SqlBoolean operator !=(SqlSingle x, SqlSingle y);
+        public static SqlBoolean operator <(SqlSingle x, SqlSingle y);
+        public static SqlBoolean operator <=(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator *(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator -(SqlSingle x, SqlSingle y);
+        public static SqlSingle operator -(SqlSingle x);
+        public static SqlSingle Parse(string s);
+        public static SqlSingle Subtract(SqlSingle x, SqlSingle y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlString ToSqlString();
+        public override string ToString();
+    }
+    public struct SqlString : IComparable, INullable, IXmlSerializable {
+        public static readonly int BinarySort;
+        public static readonly int BinarySort2;
+        public static readonly int IgnoreCase;
+        public static readonly int IgnoreKanaType;
+        public static readonly int IgnoreNonSpace;
+        public static readonly int IgnoreWidth;
+        public static readonly SqlString Null;
+        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data);
+        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, bool fUnicode);
+        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, int index, int count);
+        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, int index, int count, bool fUnicode);
+        public SqlString(string data);
+        public SqlString(string data, int lcid);
+        public SqlString(string data, int lcid, SqlCompareOptions compareOptions);
+        public CompareInfo CompareInfo { get; }
+        public CultureInfo CultureInfo { get; }
+        public bool IsNull { get; }
+        public int LCID { get; }
+        public SqlCompareOptions SqlCompareOptions { get; }
+        public string Value { get; }
+        public static SqlString Add(SqlString x, SqlString y);
+        public SqlString Clone();
+        public static CompareOptions CompareOptionsFromSqlCompareOptions(SqlCompareOptions compareOptions);
+        public int CompareTo(object value);
+        public int CompareTo(SqlString value);
+        public static SqlString Concat(SqlString x, SqlString y);
+        public override bool Equals(object value);
+        public static SqlBoolean Equals(SqlString x, SqlString y);
+        public override int GetHashCode();
+        public byte[] GetNonUnicodeBytes();
+        public byte[] GetUnicodeBytes();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+        public static SqlBoolean GreaterThan(SqlString x, SqlString y);
+        public static SqlBoolean GreaterThanOrEqual(SqlString x, SqlString y);
+        public static SqlBoolean LessThan(SqlString x, SqlString y);
+        public static SqlBoolean LessThanOrEqual(SqlString x, SqlString y);
+        public static SqlBoolean NotEquals(SqlString x, SqlString y);
+        public static SqlString operator +(SqlString x, SqlString y);
+        public static SqlBoolean operator ==(SqlString x, SqlString y);
+        public static explicit operator SqlString (SqlBoolean x);
+        public static explicit operator SqlString (SqlByte x);
+        public static explicit operator SqlString (SqlDateTime x);
+        public static explicit operator SqlString (SqlDecimal x);
+        public static explicit operator SqlString (SqlDouble x);
+        public static explicit operator SqlString (SqlGuid x);
+        public static explicit operator SqlString (SqlInt16 x);
+        public static explicit operator SqlString (SqlInt32 x);
+        public static explicit operator SqlString (SqlInt64 x);
+        public static explicit operator SqlString (SqlMoney x);
+        public static explicit operator SqlString (SqlSingle x);
+        public static explicit operator string (SqlString x);
+        public static SqlBoolean operator >(SqlString x, SqlString y);
+        public static SqlBoolean operator >=(SqlString x, SqlString y);
+        public static implicit operator SqlString (string x);
+        public static SqlBoolean operator !=(SqlString x, SqlString y);
+        public static SqlBoolean operator <(SqlString x, SqlString y);
+        public static SqlBoolean operator <=(SqlString x, SqlString y);
+        public SqlBoolean ToSqlBoolean();
+        public SqlByte ToSqlByte();
+        public SqlDateTime ToSqlDateTime();
+        public SqlDecimal ToSqlDecimal();
+        public SqlDouble ToSqlDouble();
+        public SqlGuid ToSqlGuid();
+        public SqlInt16 ToSqlInt16();
+        public SqlInt32 ToSqlInt32();
+        public SqlInt64 ToSqlInt64();
+        public SqlMoney ToSqlMoney();
+        public SqlSingle ToSqlSingle();
+        public override string ToString();
+    }
+    public sealed class SqlTruncateException : SqlTypeException {
+        public SqlTruncateException();
+        public SqlTruncateException(string message);
+        public SqlTruncateException(string message, Exception e);
+    }
+    public class SqlTypeException : SystemException {
+        public SqlTypeException();
+        protected SqlTypeException(SerializationInfo si, StreamingContext sc);
+        public SqlTypeException(string message);
+        public SqlTypeException(string message, Exception e);
+    }
+    public sealed class SqlXml : INullable, IXmlSerializable {
+        public SqlXml();
+        public SqlXml(Stream value);
+        public SqlXml(XmlReader value);
+        public bool IsNull { get; }
+        public static SqlXml Null { get; }
+        public string Value { get; }
+        public XmlReader CreateReader();
+        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
+    }
+    public enum StorageState {
+        Buffer = 0,
+        Stream = 1,
+        UnmanagedBuffer = 2,
+    }
+}
 namespace System.Diagnostics {
+    public class BooleanSwitch : Switch {
+        public BooleanSwitch(string displayName, string description);
+        public BooleanSwitch(string displayName, string description, string defaultSwitchValue);
+        public bool Enabled { get; set; }
+        protected override void OnValueChanged();
+    }
+    public class CorrelationManager {
+        public Guid ActivityId { get; set; }
+        public Stack LogicalOperationStack { get; }
+        public void StartLogicalOperation();
+        public void StartLogicalOperation(object operationId);
+        public void StopLogicalOperation();
+    }
+    public class DataReceivedEventArgs : EventArgs {
+        public string Data { get; }
+    }
+    public delegate void DataReceivedEventHandler(object sender, DataReceivedEventArgs e); {
+        public DataReceivedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DataReceivedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DataReceivedEventArgs e);
+    }
     public static class Debug {
+        public static bool AutoFlush { get; set; }
+        public static int IndentLevel { get; set; }
+        public static int IndentSize { get; set; }
+        public static TraceListenerCollection Listeners { get; }
+        public static void Close();
+        public static void Flush();
+        public static void Indent();
+        public static void Print(string message);
+        public static void Print(string format, params object[] args);
+        public static void Unindent();
     }
     public sealed class DebuggableAttribute : Attribute {
+        public DebuggableAttribute(bool isJITTrackingEnabled, bool isJITOptimizerDisabled);
+        public DebuggableAttribute.DebuggingModes DebuggingFlags { get; }
+        public bool IsJITOptimizerDisabled { get; }
+        public bool IsJITTrackingEnabled { get; }
     }
     public static class Debugger {
+        public static readonly string DefaultCategory;
+        public static bool IsLogging();
+        public static void Log(int level, string category, string message);
+        public static void NotifyOfCrossThreadDependency();
     }
+    public sealed class DebuggerStepperBoundaryAttribute : Attribute {
+        public DebuggerStepperBoundaryAttribute();
+    }
+    public sealed class DebuggerVisualizerAttribute : Attribute {
+        public DebuggerVisualizerAttribute(string visualizerTypeName);
+        public DebuggerVisualizerAttribute(string visualizerTypeName, string visualizerObjectSourceTypeName);
+        public DebuggerVisualizerAttribute(string visualizerTypeName, Type visualizerObjectSource);
+        public DebuggerVisualizerAttribute(Type visualizer);
+        public DebuggerVisualizerAttribute(Type visualizer, string visualizerObjectSourceTypeName);
+        public DebuggerVisualizerAttribute(Type visualizer, Type visualizerObjectSource);
+        public string Description { get; set; }
+        public Type Target { get; set; }
+        public string TargetTypeName { get; set; }
+        public string VisualizerObjectSourceTypeName { get; }
+        public string VisualizerTypeName { get; }
+    }
+    public class DefaultTraceListener : TraceListener {
+        public DefaultTraceListener();
+        public bool AssertUiEnabled { get; set; }
+        public string LogFileName { get; set; }
+        public override void Fail(string message);
+        public override void Fail(string message, string detailMessage);
+        public override void Write(string message);
+        public override void WriteLine(string message);
+    }
+    public class DelimitedListTraceListener : TextWriterTraceListener {
+        public DelimitedListTraceListener(Stream stream);
+        public DelimitedListTraceListener(Stream stream, string name);
+        public DelimitedListTraceListener(string fileName);
+        public DelimitedListTraceListener(string fileName, string name);
+        public DelimitedListTraceListener(TextWriter writer);
+        public DelimitedListTraceListener(TextWriter writer, string name);
+        public string Delimiter { get; set; }
+        protected internal override string[] GetSupportedAttributes();
+        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, object data);
+        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, params object[] data);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string message);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
+    }
+    public sealed class FileVersionInfo {
+        public string Comments { get; }
+        public string CompanyName { get; }
+        public int FileBuildPart { get; }
+        public string FileDescription { get; }
+        public int FileMajorPart { get; }
+        public int FileMinorPart { get; }
+        public string FileName { get; }
+        public int FilePrivatePart { get; }
+        public string FileVersion { get; }
+        public string InternalName { get; }
+        public bool IsDebug { get; }
+        public bool IsPatched { get; }
+        public bool IsPreRelease { get; }
+        public bool IsPrivateBuild { get; }
+        public bool IsSpecialBuild { get; }
+        public string Language { get; }
+        public string LegalCopyright { get; }
+        public string LegalTrademarks { get; }
+        public string OriginalFilename { get; }
+        public string PrivateBuild { get; }
+        public int ProductBuildPart { get; }
+        public int ProductMajorPart { get; }
+        public int ProductMinorPart { get; }
+        public string ProductName { get; }
+        public int ProductPrivatePart { get; }
+        public string ProductVersion { get; }
+        public string SpecialBuild { get; }
+        public static FileVersionInfo GetVersionInfo(string fileName);
+        public override string ToString();
+    }
+    public class MonitoringDescriptionAttribute : DescriptionAttribute {
+        public MonitoringDescriptionAttribute(string description);
+        public override string Description { get; }
+    }
+    public class Process : Component {
+        public Process();
+        public int BasePriority { get; }
+        public bool EnableRaisingEvents { get; set; }
+        public int ExitCode { get; }
+        public DateTime ExitTime { get; }
+        public IntPtr Handle { get; }
+        public int HandleCount { get; }
+        public bool HasExited { get; }
+        public int Id { get; }
+        public string MachineName { get; }
+        public ProcessModule MainModule { get; }
+        public IntPtr MainWindowHandle { get; }
+        public string MainWindowTitle { get; }
+        public IntPtr MaxWorkingSet { get; set; }
+        public IntPtr MinWorkingSet { get; set; }
+        public ProcessModuleCollection Modules { get; }
+        public int NonpagedSystemMemorySize { get; }
+        public long NonpagedSystemMemorySize64 { get; }
+        public int PagedMemorySize { get; }
+        public long PagedMemorySize64 { get; }
+        public int PagedSystemMemorySize { get; }
+        public long PagedSystemMemorySize64 { get; }
+        public int PeakPagedMemorySize { get; }
+        public long PeakPagedMemorySize64 { get; }
+        public int PeakVirtualMemorySize { get; }
+        public long PeakVirtualMemorySize64 { get; }
+        public int PeakWorkingSet { get; }
+        public long PeakWorkingSet64 { get; }
+        public bool PriorityBoostEnabled { get; set; }
+        public ProcessPriorityClass PriorityClass { get; set; }
+        public int PrivateMemorySize { get; }
+        public long PrivateMemorySize64 { get; }
+        public TimeSpan PrivilegedProcessorTime { get; }
+        public string ProcessName { get; }
+        public IntPtr ProcessorAffinity { get; set; }
+        public bool Responding { get; }
+        public SafeProcessHandle SafeHandle { get; }
+        public int SessionId { get; }
+        public StreamReader StandardError { get; }
+        public StreamWriter StandardInput { get; }
+        public StreamReader StandardOutput { get; }
+        public ProcessStartInfo StartInfo { get; set; }
+        public DateTime StartTime { get; }
+        public ISynchronizeInvoke SynchronizingObject { get; set; }
+        public ProcessThreadCollection Threads { get; }
+        public TimeSpan TotalProcessorTime { get; }
+        public TimeSpan UserProcessorTime { get; }
+        public int VirtualMemorySize { get; }
+        public long VirtualMemorySize64 { get; }
+        public int WorkingSet { get; }
+        public long WorkingSet64 { get; }
+        public void BeginErrorReadLine();
+        public void BeginOutputReadLine();
+        public void CancelErrorRead();
+        public void CancelOutputRead();
+        public void Close();
+        public bool CloseMainWindow();
+        protected override void Dispose(bool disposing);
+        public static void EnterDebugMode();
+        public static Process GetCurrentProcess();
+        public static Process GetProcessById(int processId);
+        public static Process GetProcessById(int processId, string machineName);
+        public static Process[] GetProcesses();
+        public static Process[] GetProcesses(string machineName);
+        public static Process[] GetProcessesByName(string processName);
+        public static Process[] GetProcessesByName(string processName, string machineName);
+        public void Kill();
+        public static void LeaveDebugMode();
+        protected void OnExited();
+        public void Refresh();
+        public bool Start();
+        public static Process Start(ProcessStartInfo startInfo);
+        public static Process Start(string fileName);
+        public static Process Start(string fileName, string arguments);
+        public static Process Start(string fileName, string userName, SecureString password, string domain);
+        public static Process Start(string fileName, string arguments, string userName, SecureString password, string domain);
+        public override string ToString();
+        public void WaitForExit();
+        public bool WaitForExit(int milliseconds);
+        public bool WaitForInputIdle();
+        public bool WaitForInputIdle(int milliseconds);
+        public event DataReceivedEventHandler ErrorDataReceived;
+        public event EventHandler Exited;
+        public event DataReceivedEventHandler OutputDataReceived;
+    }
+    public class ProcessModule : Component {
+        public IntPtr BaseAddress { get; }
+        public IntPtr EntryPointAddress { get; }
+        public string FileName { get; }
+        public FileVersionInfo FileVersionInfo { get; }
+        public int ModuleMemorySize { get; }
+        public string ModuleName { get; }
+        public override string ToString();
+    }
+    public class ProcessModuleCollection : ReadOnlyCollectionBase {
+        protected ProcessModuleCollection();
+        public ProcessModuleCollection(ProcessModule[] processModules);
+        public ProcessModule this[int index] { get; }
+        public bool Contains(ProcessModule module);
+        public void CopyTo(ProcessModule[] array, int index);
+        public int IndexOf(ProcessModule module);
+    }
+    public enum ProcessPriorityClass {
+        AboveNormal = 32768,
+        BelowNormal = 16384,
+        High = 128,
+        Idle = 64,
+        Normal = 32,
+        RealTime = 256,
+    }
+    public sealed class ProcessStartInfo {
+        public ProcessStartInfo();
+        public ProcessStartInfo(string fileName);
+        public ProcessStartInfo(string fileName, string arguments);
+        public string Arguments { get; set; }
+        public bool CreateNoWindow { get; set; }
+        public string Domain { get; set; }
+        public IDictionary<string, string> Environment { get; }
+        public StringDictionary EnvironmentVariables { get; }
+        public bool ErrorDialog { get; set; }
+        public IntPtr ErrorDialogParentHandle { get; set; }
+        public string FileName { get; set; }
+        public bool LoadUserProfile { get; set; }
+        public SecureString Password { get; set; }
+        public string PasswordInClearText { get; set; }
+        public bool RedirectStandardError { get; set; }
+        public bool RedirectStandardInput { get; set; }
+        public bool RedirectStandardOutput { get; set; }
+        public Encoding StandardErrorEncoding { get; set; }
+        public Encoding StandardOutputEncoding { get; set; }
+        public string UserName { get; set; }
+        public bool UseShellExecute { get; set; }
+        public string Verb { get; set; }
+        public string[] Verbs { get; }
+        public ProcessWindowStyle WindowStyle { get; set; }
+        public string WorkingDirectory { get; set; }
+    }
+    public class ProcessThread : Component {
+        public int BasePriority { get; }
+        public int CurrentPriority { get; }
+        public int Id { get; }
+        public int IdealProcessor { set; }
+        public bool PriorityBoostEnabled { get; set; }
+        public ThreadPriorityLevel PriorityLevel { get; set; }
+        public TimeSpan PrivilegedProcessorTime { get; }
+        public IntPtr ProcessorAffinity { set; }
+        public IntPtr StartAddress { get; }
+        public DateTime StartTime { get; }
+        public ThreadState ThreadState { get; }
+        public TimeSpan TotalProcessorTime { get; }
+        public TimeSpan UserProcessorTime { get; }
+        public ThreadWaitReason WaitReason { get; }
+        public void ResetIdealProcessor();
+    }
+    public class ProcessThreadCollection : ReadOnlyCollectionBase {
+        protected ProcessThreadCollection();
+        public ProcessThreadCollection(ProcessThread[] processThreads);
+        public ProcessThread this[int index] { get; }
+        public int Add(ProcessThread thread);
+        public bool Contains(ProcessThread thread);
+        public void CopyTo(ProcessThread[] array, int index);
+        public int IndexOf(ProcessThread thread);
+        public void Insert(int index, ProcessThread thread);
+        public void Remove(ProcessThread thread);
+    }
+    public enum ProcessWindowStyle {
+        Hidden = 1,
+        Maximized = 3,
+        Minimized = 2,
+        Normal = 0,
+    }
+    public class SourceFilter : TraceFilter {
+        public SourceFilter(string source);
+        public string Source { get; set; }
+        public override bool ShouldTrace(TraceEventCache cache, string source, TraceEventType eventType, int id, string formatOrMessage, object[] args, object data1, object[] data);
+    }
+    public enum SourceLevels {
+        ActivityTracing = 65280,
+        All = -1,
+        Critical = 1,
+        Error = 3,
+        Information = 15,
+        Off = 0,
+        Verbose = 31,
+        Warning = 7,
+    }
+    public class SourceSwitch : Switch {
+        public SourceSwitch(string name);
+        public SourceSwitch(string displayName, string defaultSwitchValue);
+        public SourceLevels Level { get; set; }
+        protected override void OnValueChanged();
+        public bool ShouldTrace(TraceEventType eventType);
+    }
+    public class StackFrame {
+        public const int OFFSET_UNKNOWN = -1;
+        public StackFrame();
+        public StackFrame(bool fNeedFileInfo);
+        public StackFrame(int skipFrames);
+        public StackFrame(int skipFrames, bool fNeedFileInfo);
+        public StackFrame(string fileName, int lineNumber);
+        public StackFrame(string fileName, int lineNumber, int colNumber);
+        public virtual int GetFileColumnNumber();
+        public virtual int GetFileLineNumber();
+        public virtual string GetFileName();
+        public virtual int GetILOffset();
+        public virtual MethodBase GetMethod();
+        public virtual int GetNativeOffset();
+        public override string ToString();
+    }
+    public class StackTrace {
+        public const int METHODS_TO_SKIP = 0;
+        public StackTrace();
+        public StackTrace(bool fNeedFileInfo);
+        public StackTrace(Exception e);
+        public StackTrace(Exception e, bool fNeedFileInfo);
+        public StackTrace(Exception e, int skipFrames);
+        public StackTrace(Exception e, int skipFrames, bool fNeedFileInfo);
+        public StackTrace(int skipFrames);
+        public StackTrace(int skipFrames, bool fNeedFileInfo);
+        public StackTrace(StackFrame frame);
+        public virtual int FrameCount { get; }
+        public virtual StackFrame GetFrame(int index);
+        public virtual StackFrame[] GetFrames();
+        public override string ToString();
+    }
+    public abstract class Switch {
+        protected Switch(string displayName, string description);
+        protected Switch(string displayName, string description, string defaultSwitchValue);
+        public StringDictionary Attributes { get; }
+        public string Description { get; }
+        public string DisplayName { get; }
+        protected int SwitchSetting { get; set; }
+        protected string Value { get; set; }
+        protected internal virtual string[] GetSupportedAttributes();
+        protected virtual void OnSwitchSettingChanged();
+        protected virtual void OnValueChanged();
+    }
+    public sealed class SwitchAttribute : Attribute {
+        public SwitchAttribute(string switchName, Type switchType);
+        public string SwitchDescription { get; set; }
+        public string SwitchName { get; set; }
+        public Type SwitchType { get; set; }
+        public static SwitchAttribute[] GetAll(Assembly assembly);
+    }
+    public sealed class SwitchLevelAttribute : Attribute {
+        public SwitchLevelAttribute(Type switchLevelType);
+        public Type SwitchLevelType { get; set; }
+    }
+    public class TextWriterTraceListener : TraceListener {
+        public TextWriterTraceListener();
+        public TextWriterTraceListener(Stream stream);
+        public TextWriterTraceListener(Stream stream, string name);
+        public TextWriterTraceListener(string fileName);
+        public TextWriterTraceListener(string fileName, string name);
+        public TextWriterTraceListener(TextWriter writer);
+        public TextWriterTraceListener(TextWriter writer, string name);
+        public TextWriter Writer { get; set; }
+        public override void Close();
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override void Write(string message);
+        public override void WriteLine(string message);
+    }
+    public enum ThreadPriorityLevel {
+        AboveNormal = 1,
+        BelowNormal = -1,
+        Highest = 2,
+        Idle = -15,
+        Lowest = -2,
+        Normal = 0,
+        TimeCritical = 15,
+    }
+    public enum ThreadState {
+        Initialized = 0,
+        Ready = 1,
+        Running = 2,
+        Standby = 3,
+        Terminated = 4,
+        Transition = 6,
+        Unknown = 7,
+        Wait = 5,
+    }
+    public enum ThreadWaitReason {
+        EventPairHigh = 7,
+        EventPairLow = 8,
+        ExecutionDelay = 4,
+        Executive = 0,
+        FreePage = 1,
+        LpcReceive = 9,
+        LpcReply = 10,
+        PageIn = 2,
+        PageOut = 12,
+        Suspended = 5,
+        SystemAllocation = 3,
+        Unknown = 13,
+        UserRequest = 6,
+        VirtualMemory = 11,
+    }
+    public sealed class Trace {
+        public static bool AutoFlush { get; set; }
+        public static CorrelationManager CorrelationManager { get; }
+        public static int IndentLevel { get; set; }
+        public static int IndentSize { get; set; }
+        public static TraceListenerCollection Listeners { get; }
+        public static bool UseGlobalLock { get; set; }
+        public static void Assert(bool condition);
+        public static void Assert(bool condition, string message);
+        public static void Assert(bool condition, string message, string detailMessage);
+        public static void Close();
+        public static void Fail(string message);
+        public static void Fail(string message, string detailMessage);
+        public static void Flush();
+        public static void Indent();
+        public static void Refresh();
+        public static void TraceError(string message);
+        public static void TraceError(string format, params object[] args);
+        public static void TraceInformation(string message);
+        public static void TraceInformation(string format, params object[] args);
+        public static void TraceWarning(string message);
+        public static void TraceWarning(string format, params object[] args);
+        public static void Unindent();
+        public static void Write(object value);
+        public static void Write(object value, string category);
+        public static void Write(string message);
+        public static void Write(string message, string category);
+        public static void WriteIf(bool condition, object value);
+        public static void WriteIf(bool condition, object value, string category);
+        public static void WriteIf(bool condition, string message);
+        public static void WriteIf(bool condition, string message, string category);
+        public static void WriteLine(object value);
+        public static void WriteLine(object value, string category);
+        public static void WriteLine(string message);
+        public static void WriteLine(string message, string category);
+        public static void WriteLineIf(bool condition, object value);
+        public static void WriteLineIf(bool condition, object value, string category);
+        public static void WriteLineIf(bool condition, string message);
+        public static void WriteLineIf(bool condition, string message, string category);
+    }
+    public class TraceEventCache {
+        public TraceEventCache();
+        public string Callstack { get; }
+        public DateTime DateTime { get; }
+        public Stack LogicalOperationStack { get; }
+        public int ProcessId { get; }
+        public string ThreadId { get; }
+        public long Timestamp { get; }
+    }
+    public enum TraceEventType {
+        Critical = 1,
+        Error = 2,
+        Information = 8,
+        Resume = 2048,
+        Start = 256,
+        Stop = 512,
+        Suspend = 1024,
+        Transfer = 4096,
+        Verbose = 16,
+        Warning = 4,
+    }
+    public abstract class TraceFilter {
+        protected TraceFilter();
+        public abstract bool ShouldTrace(TraceEventCache cache, string source, TraceEventType eventType, int id, string formatOrMessage, object[] args, object data1, object[] data);
+    }
+    public enum TraceLevel {
+        Error = 1,
+        Info = 3,
+        Off = 0,
+        Verbose = 4,
+        Warning = 2,
+    }
+    public abstract class TraceListener : MarshalByRefObject, IDisposable {
+        protected TraceListener();
+        protected TraceListener(string name);
+        public StringDictionary Attributes { get; }
+        public TraceFilter Filter { get; set; }
+        public int IndentLevel { get; set; }
+        public int IndentSize { get; set; }
+        public virtual bool IsThreadSafe { get; }
+        public virtual string Name { get; set; }
+        protected bool NeedIndent { get; set; }
+        public TraceOptions TraceOutputOptions { get; set; }
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual void Fail(string message);
+        public virtual void Fail(string message, string detailMessage);
+        public virtual void Flush();
+        protected internal virtual string[] GetSupportedAttributes();
+        public virtual void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, object data);
+        public virtual void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, params object[] data);
+        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id);
+        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string message);
+        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
+        public virtual void TraceTransfer(TraceEventCache eventCache, string source, int id, string message, Guid relatedActivityId);
+        public virtual void Write(object o);
+        public virtual void Write(object o, string category);
+        public abstract void Write(string message);
+        public virtual void Write(string message, string category);
+        protected virtual void WriteIndent();
+        public virtual void WriteLine(object o);
+        public virtual void WriteLine(object o, string category);
+        public abstract void WriteLine(string message);
+        public virtual void WriteLine(string message, string category);
+    }
+    public class TraceListenerCollection : ICollection, IEnumerable, IList {
+        public int Count { get; }
+        public TraceListener this[int i] { get; set; }
+        public TraceListener this[string name] { get; }
+        public int Add(TraceListener listener);
+        public void AddRange(TraceListenerCollection value);
+        public void AddRange(TraceListener[] value);
+        public void Clear();
+        public bool Contains(TraceListener listener);
+        public void CopyTo(TraceListener[] listeners, int index);
+        public IEnumerator GetEnumerator();
+        public int IndexOf(TraceListener listener);
+        public void Insert(int index, TraceListener listener);
+        public void Remove(string name);
+        public void Remove(TraceListener listener);
+        public void RemoveAt(int index);
+    }
+    public enum TraceOptions {
+        Callstack = 32,
+        DateTime = 2,
+        LogicalOperationStack = 1,
+        None = 0,
+        ProcessId = 8,
+        ThreadId = 16,
+        Timestamp = 4,
+    }
+    public class TraceSource {
+        public TraceSource(string name);
+        public TraceSource(string name, SourceLevels defaultLevel);
+        public StringDictionary Attributes { get; }
+        public TraceListenerCollection Listeners { get; }
+        public string Name { get; }
+        public SourceSwitch Switch { get; set; }
+        public void Close();
+        public void Flush();
+        protected internal virtual string[] GetSupportedAttributes();
+        public void TraceData(TraceEventType eventType, int id, object data);
+        public void TraceData(TraceEventType eventType, int id, params object[] data);
+        public void TraceEvent(TraceEventType eventType, int id);
+        public void TraceEvent(TraceEventType eventType, int id, string message);
+        public void TraceEvent(TraceEventType eventType, int id, string format, params object[] args);
+        public void TraceInformation(string message);
+        public void TraceInformation(string format, params object[] args);
+        public void TraceTransfer(int id, string message, Guid relatedActivityId);
+    }
+    public class TraceSwitch : Switch {
+        public TraceSwitch(string displayName, string description);
+        public TraceSwitch(string displayName, string description, string defaultSwitchValue);
+        public TraceLevel Level { get; set; }
+        public bool TraceError { get; }
+        public bool TraceInfo { get; }
+        public bool TraceVerbose { get; }
+        public bool TraceWarning { get; }
+        protected override void OnSwitchSettingChanged();
+        protected override void OnValueChanged();
+    }
 }
 namespace System.Diagnostics.CodeAnalysis {
+    public sealed class ExcludeFromCodeCoverageAttribute : Attribute {
+        public ExcludeFromCodeCoverageAttribute();
+    }
 }
+namespace System.Diagnostics.Contracts {
+    public static class Contract {
+        public static void Assert(bool condition);
+        public static void Assert(bool condition, string userMessage);
+        public static void Assume(bool condition);
+        public static void Assume(bool condition, string userMessage);
+        public static void EndContractBlock();
+        public static void Ensures(bool condition);
+        public static void Ensures(bool condition, string userMessage);
+        public static void EnsuresOnThrow<TException>(bool condition) where TException : Exception;
+        public static void EnsuresOnThrow<TException>(bool condition, string userMessage) where TException : Exception;
+        public static bool Exists<T>(IEnumerable<T> collection, Predicate<T> predicate);
+        public static bool Exists(int fromInclusive, int toExclusive, Predicate<int> predicate);
+        public static bool ForAll<T>(IEnumerable<T> collection, Predicate<T> predicate);
+        public static bool ForAll(int fromInclusive, int toExclusive, Predicate<int> predicate);
+        public static void Invariant(bool condition);
+        public static void Invariant(bool condition, string userMessage);
+        public static T OldValue<T>(T value);
+        public static void Requires<TException>(bool condition) where TException : Exception;
+        public static void Requires<TException>(bool condition, string userMessage) where TException : Exception;
+        public static void Requires(bool condition);
+        public static void Requires(bool condition, string userMessage);
+        public static T Result<T>();
+        public static T ValueAtReturn<T>(out T value);
+        public static event EventHandler<ContractFailedEventArgs> ContractFailed;
+    }
+    public sealed class ContractAbbreviatorAttribute : Attribute {
+        public ContractAbbreviatorAttribute();
+    }
+    public sealed class ContractArgumentValidatorAttribute : Attribute {
+        public ContractArgumentValidatorAttribute();
+    }
+    public sealed class ContractClassAttribute : Attribute {
+        public ContractClassAttribute(Type typeContainingContracts);
+        public Type TypeContainingContracts { get; }
+    }
+    public sealed class ContractClassForAttribute : Attribute {
+        public ContractClassForAttribute(Type typeContractsAreFor);
+        public Type TypeContractsAreFor { get; }
+    }
+    public sealed class ContractFailedEventArgs : EventArgs {
+        public ContractFailedEventArgs(ContractFailureKind failureKind, string message, string condition, Exception originalException);
+        public string Condition { get; }
+        public ContractFailureKind FailureKind { get; }
+        public bool Handled { get; }
+        public string Message { get; }
+        public Exception OriginalException { get; }
+        public bool Unwind { get; }
+        public void SetHandled();
+        public void SetUnwind();
+    }
+    public enum ContractFailureKind {
+        Assert = 4,
+        Assume = 5,
+        Invariant = 3,
+        Postcondition = 1,
+        PostconditionOnException = 2,
+        Precondition = 0,
+    }
+    public sealed class ContractInvariantMethodAttribute : Attribute {
+        public ContractInvariantMethodAttribute();
+    }
+    public sealed class ContractOptionAttribute : Attribute {
+        public ContractOptionAttribute(string category, string setting, bool enabled);
+        public ContractOptionAttribute(string category, string setting, string value);
+        public string Category { get; }
+        public bool Enabled { get; }
+        public string Setting { get; }
+        public string Value { get; }
+    }
+    public sealed class ContractPublicPropertyNameAttribute : Attribute {
+        public ContractPublicPropertyNameAttribute(string name);
+        public string Name { get; }
+    }
+    public sealed class ContractReferenceAssemblyAttribute : Attribute {
+        public ContractReferenceAssemblyAttribute();
+    }
+    public sealed class ContractRuntimeIgnoredAttribute : Attribute {
+        public ContractRuntimeIgnoredAttribute();
+    }
+    public sealed class ContractVerificationAttribute : Attribute {
+        public ContractVerificationAttribute(bool value);
+        public bool Value { get; }
+    }
+    public sealed class PureAttribute : Attribute {
+        public PureAttribute();
+    }
+}
+namespace System.Diagnostics.Contracts.Internal {
+    public static class ContractHelper {
+        public static string RaiseContractFailedEvent(ContractFailureKind failureKind, string userMessage, string conditionText, Exception innerException);
+        public static void TriggerFailure(ContractFailureKind kind, string displayMessage, string userMessage, string conditionText, Exception innerException);
+    }
+}
+namespace System.Diagnostics.SymbolStore {
+    public interface ISymbolBinder {
+        ISymbolReader GetReader(int importer, string filename, string searchPath);
+    }
+    public interface ISymbolBinder1 {
+        ISymbolReader GetReader(IntPtr importer, string filename, string searchPath);
+    }
+    public interface ISymbolDocument {
+        Guid CheckSumAlgorithmId { get; }
+        Guid DocumentType { get; }
+        bool HasEmbeddedSource { get; }
+        Guid Language { get; }
+        Guid LanguageVendor { get; }
+        int SourceLength { get; }
+        string URL { get; }
+        int FindClosestLine(int line);
+        byte[] GetCheckSum();
+        byte[] GetSourceRange(int startLine, int startColumn, int endLine, int endColumn);
+    }
+    public interface ISymbolDocumentWriter {
+        void SetCheckSum(Guid algorithmId, byte[] checkSum);
+        void SetSource(byte[] source);
+    }
+    public interface ISymbolMethod {
+        ISymbolScope RootScope { get; }
+        int SequencePointCount { get; }
+        SymbolToken Token { get; }
+        ISymbolNamespace GetNamespace();
+        int GetOffset(ISymbolDocument document, int line, int column);
+        ISymbolVariable[] GetParameters();
+        int[] GetRanges(ISymbolDocument document, int line, int column);
+        ISymbolScope GetScope(int offset);
+        void GetSequencePoints(int[] offsets, ISymbolDocument[] documents, int[] lines, int[] columns, int[] endLines, int[] endColumns);
+        bool GetSourceStartEnd(ISymbolDocument[] docs, int[] lines, int[] columns);
+    }
+    public interface ISymbolNamespace {
+        string Name { get; }
+        ISymbolNamespace[] GetNamespaces();
+        ISymbolVariable[] GetVariables();
+    }
+    public interface ISymbolReader {
+        SymbolToken UserEntryPoint { get; }
+        ISymbolDocument GetDocument(string url, Guid language, Guid languageVendor, Guid documentType);
+        ISymbolDocument[] GetDocuments();
+        ISymbolVariable[] GetGlobalVariables();
+        ISymbolMethod GetMethod(SymbolToken method);
+        ISymbolMethod GetMethod(SymbolToken method, int version);
+        ISymbolMethod GetMethodFromDocumentPosition(ISymbolDocument document, int line, int column);
+        ISymbolNamespace[] GetNamespaces();
+        byte[] GetSymAttribute(SymbolToken parent, string name);
+        ISymbolVariable[] GetVariables(SymbolToken parent);
+    }
+    public interface ISymbolScope {
+        int EndOffset { get; }
+        ISymbolMethod Method { get; }
+        ISymbolScope Parent { get; }
+        int StartOffset { get; }
+        ISymbolScope[] GetChildren();
+        ISymbolVariable[] GetLocals();
+        ISymbolNamespace[] GetNamespaces();
+    }
+    public interface ISymbolVariable {
+        int AddressField1 { get; }
+        int AddressField2 { get; }
+        int AddressField3 { get; }
+        SymAddressKind AddressKind { get; }
+        object Attributes { get; }
+        int EndOffset { get; }
+        string Name { get; }
+        int StartOffset { get; }
+        byte[] GetSignature();
+    }
+    public interface ISymbolWriter {
+        void Close();
+        void CloseMethod();
+        void CloseNamespace();
+        void CloseScope(int endOffset);
+        ISymbolDocumentWriter DefineDocument(string url, Guid language, Guid languageVendor, Guid documentType);
+        void DefineField(SymbolToken parent, string name, FieldAttributes attributes, byte[] signature, SymAddressKind addrKind, int addr1, int addr2, int addr3);
+        void DefineGlobalVariable(string name, FieldAttributes attributes, byte[] signature, SymAddressKind addrKind, int addr1, int addr2, int addr3);
+        void DefineLocalVariable(string name, FieldAttributes attributes, byte[] signature, SymAddressKind addrKind, int addr1, int addr2, int addr3, int startOffset, int endOffset);
+        void DefineParameter(string name, ParameterAttributes attributes, int sequence, SymAddressKind addrKind, int addr1, int addr2, int addr3);
+        void DefineSequencePoints(ISymbolDocumentWriter document, int[] offsets, int[] lines, int[] columns, int[] endLines, int[] endColumns);
+        void Initialize(IntPtr emitter, string filename, bool fFullBuild);
+        void OpenMethod(SymbolToken method);
+        void OpenNamespace(string name);
+        int OpenScope(int startOffset);
+        void SetMethodSourceRange(ISymbolDocumentWriter startDoc, int startLine, int startColumn, ISymbolDocumentWriter endDoc, int endLine, int endColumn);
+        void SetScopeRange(int scopeID, int startOffset, int endOffset);
+        void SetSymAttribute(SymbolToken parent, string name, byte[] data);
+        void SetUnderlyingWriter(IntPtr underlyingWriter);
+        void SetUserEntryPoint(SymbolToken entryMethod);
+        void UsingNamespace(string fullName);
+    }
+    public enum SymAddressKind {
+        BitField = 9,
+        ILOffset = 1,
+        NativeOffset = 5,
+        NativeRegister = 3,
+        NativeRegisterRegister = 6,
+        NativeRegisterRelative = 4,
+        NativeRegisterStack = 7,
+        NativeRVA = 2,
+        NativeSectionOffset = 10,
+        NativeStackRegister = 8,
+    }
+    public struct SymbolToken {
+        public SymbolToken(int val);
+        public override bool Equals(object obj);
+        public bool Equals(SymbolToken obj);
+        public override int GetHashCode();
+        public int GetToken();
+        public static bool operator ==(SymbolToken a, SymbolToken b);
+        public static bool operator !=(SymbolToken a, SymbolToken b);
+    }
+    public class SymDocumentType {
+        public static readonly Guid Text;
+        public SymDocumentType();
+    }
+    public class SymLanguageType {
+        public static readonly Guid Basic;
+        public static readonly Guid C;
+        public static readonly Guid Cobol;
+        public static readonly Guid CPlusPlus;
+        public static readonly Guid CSharp;
+        public static readonly Guid ILAssembly;
+        public static readonly Guid Java;
+        public static readonly Guid JScript;
+        public static readonly Guid MCPlusPlus;
+        public static readonly Guid Pascal;
+        public static readonly Guid SMC;
+        public SymLanguageType();
+    }
+    public class SymLanguageVendor {
+        public static readonly Guid Microsoft;
+        public SymLanguageVendor();
+    }
+}
 namespace System.Diagnostics.Tracing {
-    public class EventCounter {
-        public EventCounter(string name, EventSource eventSource);
-        public void WriteMetric(float value);
-    }
     public enum EventKeywords : long {
+        MicrosoftTelemetry = (long)562949953421312,
     }
     public class EventSource : IDisposable {
-        public event EventHandler<EventCommandEventArgs> EventCommandExecuted;
     }
     public class EventSourceException : Exception {
+        protected EventSourceException(SerializationInfo info, StreamingContext context);
     }
 }
+namespace System.Drawing {
+    public struct Color {
+        public static readonly Color Empty;
+        public byte A { get; }
+        public static Color AliceBlue { get; }
+        public static Color AntiqueWhite { get; }
+        public static Color Aqua { get; }
+        public static Color Aquamarine { get; }
+        public static Color Azure { get; }
+        public byte B { get; }
+        public static Color Beige { get; }
+        public static Color Bisque { get; }
+        public static Color Black { get; }
+        public static Color BlanchedAlmond { get; }
+        public static Color Blue { get; }
+        public static Color BlueViolet { get; }
+        public static Color Brown { get; }
+        public static Color BurlyWood { get; }
+        public static Color CadetBlue { get; }
+        public static Color Chartreuse { get; }
+        public static Color Chocolate { get; }
+        public static Color Coral { get; }
+        public static Color CornflowerBlue { get; }
+        public static Color Cornsilk { get; }
+        public static Color Crimson { get; }
+        public static Color Cyan { get; }
+        public static Color DarkBlue { get; }
+        public static Color DarkCyan { get; }
+        public static Color DarkGoldenrod { get; }
+        public static Color DarkGray { get; }
+        public static Color DarkGreen { get; }
+        public static Color DarkKhaki { get; }
+        public static Color DarkMagenta { get; }
+        public static Color DarkOliveGreen { get; }
+        public static Color DarkOrange { get; }
+        public static Color DarkOrchid { get; }
+        public static Color DarkRed { get; }
+        public static Color DarkSalmon { get; }
+        public static Color DarkSeaGreen { get; }
+        public static Color DarkSlateBlue { get; }
+        public static Color DarkSlateGray { get; }
+        public static Color DarkTurquoise { get; }
+        public static Color DarkViolet { get; }
+        public static Color DeepPink { get; }
+        public static Color DeepSkyBlue { get; }
+        public static Color DimGray { get; }
+        public static Color DodgerBlue { get; }
+        public static Color Firebrick { get; }
+        public static Color FloralWhite { get; }
+        public static Color ForestGreen { get; }
+        public static Color Fuchsia { get; }
+        public byte G { get; }
+        public static Color Gainsboro { get; }
+        public static Color GhostWhite { get; }
+        public static Color Gold { get; }
+        public static Color Goldenrod { get; }
+        public static Color Gray { get; }
+        public static Color Green { get; }
+        public static Color GreenYellow { get; }
+        public static Color Honeydew { get; }
+        public static Color HotPink { get; }
+        public static Color IndianRed { get; }
+        public static Color Indigo { get; }
+        public bool IsEmpty { get; }
+        public bool IsKnownColor { get; }
+        public bool IsNamedColor { get; }
+        public bool IsSystemColor { get; }
+        public static Color Ivory { get; }
+        public static Color Khaki { get; }
+        public static Color Lavender { get; }
+        public static Color LavenderBlush { get; }
+        public static Color LawnGreen { get; }
+        public static Color LemonChiffon { get; }
+        public static Color LightBlue { get; }
+        public static Color LightCoral { get; }
+        public static Color LightCyan { get; }
+        public static Color LightGoldenrodYellow { get; }
+        public static Color LightGray { get; }
+        public static Color LightGreen { get; }
+        public static Color LightPink { get; }
+        public static Color LightSalmon { get; }
+        public static Color LightSeaGreen { get; }
+        public static Color LightSkyBlue { get; }
+        public static Color LightSlateGray { get; }
+        public static Color LightSteelBlue { get; }
+        public static Color LightYellow { get; }
+        public static Color Lime { get; }
+        public static Color LimeGreen { get; }
+        public static Color Linen { get; }
+        public static Color Magenta { get; }
+        public static Color Maroon { get; }
+        public static Color MediumAquamarine { get; }
+        public static Color MediumBlue { get; }
+        public static Color MediumOrchid { get; }
+        public static Color MediumPurple { get; }
+        public static Color MediumSeaGreen { get; }
+        public static Color MediumSlateBlue { get; }
+        public static Color MediumSpringGreen { get; }
+        public static Color MediumTurquoise { get; }
+        public static Color MediumVioletRed { get; }
+        public static Color MidnightBlue { get; }
+        public static Color MintCream { get; }
+        public static Color MistyRose { get; }
+        public static Color Moccasin { get; }
+        public string Name { get; }
+        public static Color NavajoWhite { get; }
+        public static Color Navy { get; }
+        public static Color OldLace { get; }
+        public static Color Olive { get; }
+        public static Color OliveDrab { get; }
+        public static Color Orange { get; }
+        public static Color OrangeRed { get; }
+        public static Color Orchid { get; }
+        public static Color PaleGoldenrod { get; }
+        public static Color PaleGreen { get; }
+        public static Color PaleTurquoise { get; }
+        public static Color PaleVioletRed { get; }
+        public static Color PapayaWhip { get; }
+        public static Color PeachPuff { get; }
+        public static Color Peru { get; }
+        public static Color Pink { get; }
+        public static Color Plum { get; }
+        public static Color PowderBlue { get; }
+        public static Color Purple { get; }
+        public byte R { get; }
+        public static Color Red { get; }
+        public static Color RosyBrown { get; }
+        public static Color RoyalBlue { get; }
+        public static Color SaddleBrown { get; }
+        public static Color Salmon { get; }
+        public static Color SandyBrown { get; }
+        public static Color SeaGreen { get; }
+        public static Color SeaShell { get; }
+        public static Color Sienna { get; }
+        public static Color Silver { get; }
+        public static Color SkyBlue { get; }
+        public static Color SlateBlue { get; }
+        public static Color SlateGray { get; }
+        public static Color Snow { get; }
+        public static Color SpringGreen { get; }
+        public static Color SteelBlue { get; }
+        public static Color Tan { get; }
+        public static Color Teal { get; }
+        public static Color Thistle { get; }
+        public static Color Tomato { get; }
+        public static Color Transparent { get; }
+        public static Color Turquoise { get; }
+        public static Color Violet { get; }
+        public static Color Wheat { get; }
+        public static Color White { get; }
+        public static Color WhiteSmoke { get; }
+        public static Color Yellow { get; }
+        public static Color YellowGreen { get; }
+        public override bool Equals(object obj);
+        public static Color FromArgb(int argb);
+        public static Color FromArgb(int alpha, Color baseColor);
+        public static Color FromArgb(int red, int green, int blue);
+        public static Color FromArgb(int alpha, int red, int green, int blue);
+        public static Color FromKnownColor(KnownColor color);
+        public static Color FromName(string name);
+        public float GetBrightness();
+        public override int GetHashCode();
+        public float GetHue();
+        public float GetSaturation();
+        public static bool operator ==(Color left, Color right);
+        public static bool operator !=(Color left, Color right);
+        public int ToArgb();
+        public KnownColor ToKnownColor();
+        public override string ToString();
+    }
+    public enum KnownColor {
+        ActiveBorder = 1,
+        ActiveCaption = 2,
+        ActiveCaptionText = 3,
+        AliceBlue = 28,
+        AntiqueWhite = 29,
+        AppWorkspace = 4,
+        Aqua = 30,
+        Aquamarine = 31,
+        Azure = 32,
+        Beige = 33,
+        Bisque = 34,
+        Black = 35,
+        BlanchedAlmond = 36,
+        Blue = 37,
+        BlueViolet = 38,
+        Brown = 39,
+        BurlyWood = 40,
+        ButtonFace = 168,
+        ButtonHighlight = 169,
+        ButtonShadow = 170,
+        CadetBlue = 41,
+        Chartreuse = 42,
+        Chocolate = 43,
+        Control = 5,
+        ControlDark = 6,
+        ControlDarkDark = 7,
+        ControlLight = 8,
+        ControlLightLight = 9,
+        ControlText = 10,
+        Coral = 44,
+        CornflowerBlue = 45,
+        Cornsilk = 46,
+        Crimson = 47,
+        Cyan = 48,
+        DarkBlue = 49,
+        DarkCyan = 50,
+        DarkGoldenrod = 51,
+        DarkGray = 52,
+        DarkGreen = 53,
+        DarkKhaki = 54,
+        DarkMagenta = 55,
+        DarkOliveGreen = 56,
+        DarkOrange = 57,
+        DarkOrchid = 58,
+        DarkRed = 59,
+        DarkSalmon = 60,
+        DarkSeaGreen = 61,
+        DarkSlateBlue = 62,
+        DarkSlateGray = 63,
+        DarkTurquoise = 64,
+        DarkViolet = 65,
+        DeepPink = 66,
+        DeepSkyBlue = 67,
+        Desktop = 11,
+        DimGray = 68,
+        DodgerBlue = 69,
+        Firebrick = 70,
+        FloralWhite = 71,
+        ForestGreen = 72,
+        Fuchsia = 73,
+        Gainsboro = 74,
+        GhostWhite = 75,
+        Gold = 76,
+        Goldenrod = 77,
+        GradientActiveCaption = 171,
+        GradientInactiveCaption = 172,
+        Gray = 78,
+        GrayText = 12,
+        Green = 79,
+        GreenYellow = 80,
+        Highlight = 13,
+        HighlightText = 14,
+        Honeydew = 81,
+        HotPink = 82,
+        HotTrack = 15,
+        InactiveBorder = 16,
+        InactiveCaption = 17,
+        InactiveCaptionText = 18,
+        IndianRed = 83,
+        Indigo = 84,
+        Info = 19,
+        InfoText = 20,
+        Ivory = 85,
+        Khaki = 86,
+        Lavender = 87,
+        LavenderBlush = 88,
+        LawnGreen = 89,
+        LemonChiffon = 90,
+        LightBlue = 91,
+        LightCoral = 92,
+        LightCyan = 93,
+        LightGoldenrodYellow = 94,
+        LightGray = 95,
+        LightGreen = 96,
+        LightPink = 97,
+        LightSalmon = 98,
+        LightSeaGreen = 99,
+        LightSkyBlue = 100,
+        LightSlateGray = 101,
+        LightSteelBlue = 102,
+        LightYellow = 103,
+        Lime = 104,
+        LimeGreen = 105,
+        Linen = 106,
+        Magenta = 107,
+        Maroon = 108,
+        MediumAquamarine = 109,
+        MediumBlue = 110,
+        MediumOrchid = 111,
+        MediumPurple = 112,
+        MediumSeaGreen = 113,
+        MediumSlateBlue = 114,
+        MediumSpringGreen = 115,
+        MediumTurquoise = 116,
+        MediumVioletRed = 117,
+        Menu = 21,
+        MenuBar = 173,
+        MenuHighlight = 174,
+        MenuText = 22,
+        MidnightBlue = 118,
+        MintCream = 119,
+        MistyRose = 120,
+        Moccasin = 121,
+        NavajoWhite = 122,
+        Navy = 123,
+        OldLace = 124,
+        Olive = 125,
+        OliveDrab = 126,
+        Orange = 127,
+        OrangeRed = 128,
+        Orchid = 129,
+        PaleGoldenrod = 130,
+        PaleGreen = 131,
+        PaleTurquoise = 132,
+        PaleVioletRed = 133,
+        PapayaWhip = 134,
+        PeachPuff = 135,
+        Peru = 136,
+        Pink = 137,
+        Plum = 138,
+        PowderBlue = 139,
+        Purple = 140,
+        Red = 141,
+        RosyBrown = 142,
+        RoyalBlue = 143,
+        SaddleBrown = 144,
+        Salmon = 145,
+        SandyBrown = 146,
+        ScrollBar = 23,
+        SeaGreen = 147,
+        SeaShell = 148,
+        Sienna = 149,
+        Silver = 150,
+        SkyBlue = 151,
+        SlateBlue = 152,
+        SlateGray = 153,
+        Snow = 154,
+        SpringGreen = 155,
+        SteelBlue = 156,
+        Tan = 157,
+        Teal = 158,
+        Thistle = 159,
+        Tomato = 160,
+        Transparent = 27,
+        Turquoise = 161,
+        Violet = 162,
+        Wheat = 163,
+        White = 164,
+        WhiteSmoke = 165,
+        Window = 24,
+        WindowFrame = 25,
+        WindowText = 26,
+        Yellow = 166,
+        YellowGreen = 167,
+    }
+    public struct Point {
+        public static readonly Point Empty;
+        public Point(int dw);
+        public Point(int x, int y);
+        public Point(Size sz);
+        public bool IsEmpty { get; }
+        public int X { get; set; }
+        public int Y { get; set; }
+        public static Point Add(Point pt, Size sz);
+        public static Point Ceiling(PointF value);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public void Offset(int dx, int dy);
+        public void Offset(Point p);
+        public static Point operator +(Point pt, Size sz);
+        public static bool operator ==(Point left, Point right);
+        public static explicit operator Size (Point p);
+        public static implicit operator PointF (Point p);
+        public static bool operator !=(Point left, Point right);
+        public static Point operator -(Point pt, Size sz);
+        public static Point Round(PointF value);
+        public static Point Subtract(Point pt, Size sz);
+        public override string ToString();
+        public static Point Truncate(PointF value);
+    }
+    public struct PointF {
+        public static readonly PointF Empty;
+        public PointF(float x, float y);
+        public bool IsEmpty { get; }
+        public float X { get; set; }
+        public float Y { get; set; }
+        public static PointF Add(PointF pt, Size sz);
+        public static PointF Add(PointF pt, SizeF sz);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static PointF operator +(PointF pt, Size sz);
+        public static PointF operator +(PointF pt, SizeF sz);
+        public static bool operator ==(PointF left, PointF right);
+        public static bool operator !=(PointF left, PointF right);
+        public static PointF operator -(PointF pt, Size sz);
+        public static PointF operator -(PointF pt, SizeF sz);
+        public static PointF Subtract(PointF pt, Size sz);
+        public static PointF Subtract(PointF pt, SizeF sz);
+        public override string ToString();
+    }
+    public struct Rectangle {
+        public static readonly Rectangle Empty;
+        public Rectangle(int x, int y, int width, int height);
+        public Rectangle(Point location, Size size);
+        public int Bottom { get; }
+        public int Height { get; set; }
+        public bool IsEmpty { get; }
+        public int Left { get; }
+        public Point Location { get; set; }
+        public int Right { get; }
+        public Size Size { get; set; }
+        public int Top { get; }
+        public int Width { get; set; }
+        public int X { get; set; }
+        public int Y { get; set; }
+        public static Rectangle Ceiling(RectangleF value);
+        public bool Contains(int x, int y);
+        public bool Contains(Point pt);
+        public bool Contains(Rectangle rect);
+        public override bool Equals(object obj);
+        public static Rectangle FromLTRB(int left, int top, int right, int bottom);
+        public override int GetHashCode();
+        public void Inflate(int width, int height);
+        public static Rectangle Inflate(Rectangle rect, int x, int y);
+        public void Inflate(Size size);
+        public void Intersect(Rectangle rect);
+        public static Rectangle Intersect(Rectangle a, Rectangle b);
+        public bool IntersectsWith(Rectangle rect);
+        public void Offset(int x, int y);
+        public void Offset(Point pos);
+        public static bool operator ==(Rectangle left, Rectangle right);
+        public static bool operator !=(Rectangle left, Rectangle right);
+        public static Rectangle Round(RectangleF value);
+        public override string ToString();
+        public static Rectangle Truncate(RectangleF value);
+        public static Rectangle Union(Rectangle a, Rectangle b);
+    }
+    public struct RectangleF {
+        public static readonly RectangleF Empty;
+        public RectangleF(PointF location, SizeF size);
+        public RectangleF(float x, float y, float width, float height);
+        public float Bottom { get; }
+        public float Height { get; set; }
+        public bool IsEmpty { get; }
+        public float Left { get; }
+        public PointF Location { get; set; }
+        public float Right { get; }
+        public SizeF Size { get; set; }
+        public float Top { get; }
+        public float Width { get; set; }
+        public float X { get; set; }
+        public float Y { get; set; }
+        public bool Contains(PointF pt);
+        public bool Contains(RectangleF rect);
+        public bool Contains(float x, float y);
+        public override bool Equals(object obj);
+        public static RectangleF FromLTRB(float left, float top, float right, float bottom);
+        public override int GetHashCode();
+        public static RectangleF Inflate(RectangleF rect, float x, float y);
+        public void Inflate(float x, float y);
+        public void Inflate(SizeF size);
+        public void Intersect(RectangleF rect);
+        public static RectangleF Intersect(RectangleF a, RectangleF b);
+        public bool IntersectsWith(RectangleF rect);
+        public void Offset(PointF pos);
+        public void Offset(float x, float y);
+        public static bool operator ==(RectangleF left, RectangleF right);
+        public static implicit operator RectangleF (Rectangle r);
+        public static bool operator !=(RectangleF left, RectangleF right);
+        public override string ToString();
+        public static RectangleF Union(RectangleF a, RectangleF b);
+    }
+    public struct Size {
+        public static readonly Size Empty;
+        public Size(int width, int height);
+        public Size(Point pt);
+        public int Height { get; set; }
+        public bool IsEmpty { get; }
+        public int Width { get; set; }
+        public static Size Add(Size sz1, Size sz2);
+        public static Size Ceiling(SizeF value);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static Size operator +(Size sz1, Size sz2);
+        public static bool operator ==(Size sz1, Size sz2);
+        public static explicit operator Point (Size size);
+        public static implicit operator SizeF (Size p);
+        public static bool operator !=(Size sz1, Size sz2);
+        public static Size operator -(Size sz1, Size sz2);
+        public static Size Round(SizeF value);
+        public static Size Subtract(Size sz1, Size sz2);
+        public override string ToString();
+        public static Size Truncate(SizeF value);
+    }
+    public struct SizeF {
+        public static readonly SizeF Empty;
+        public SizeF(PointF pt);
+        public SizeF(float width, float height);
+        public SizeF(SizeF size);
+        public float Height { get; set; }
+        public bool IsEmpty { get; }
+        public float Width { get; set; }
+        public static SizeF Add(SizeF sz1, SizeF sz2);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static SizeF operator +(SizeF sz1, SizeF sz2);
+        public static bool operator ==(SizeF sz1, SizeF sz2);
+        public static explicit operator PointF (SizeF size);
+        public static bool operator !=(SizeF sz1, SizeF sz2);
+        public static SizeF operator -(SizeF sz1, SizeF sz2);
+        public static SizeF Subtract(SizeF sz1, SizeF sz2);
+        public PointF ToPointF();
+        public Size ToSize();
+        public override string ToString();
+    }
+}
+namespace System.Dynamic {
+    public abstract class BinaryOperationBinder : DynamicMetaObjectBinder {
+        protected BinaryOperationBinder(ExpressionType operation);
+        public ExpressionType Operation { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackBinaryOperation(DynamicMetaObject target, DynamicMetaObject arg);
+        public abstract DynamicMetaObject FallbackBinaryOperation(DynamicMetaObject target, DynamicMetaObject arg, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class BindingRestrictions {
+        public static readonly BindingRestrictions Empty;
+        public static BindingRestrictions Combine(IList<DynamicMetaObject> contributingObjects);
+        public static BindingRestrictions GetExpressionRestriction(Expression expression);
+        public static BindingRestrictions GetInstanceRestriction(Expression expression, object instance);
+        public static BindingRestrictions GetTypeRestriction(Expression expression, Type type);
+        public BindingRestrictions Merge(BindingRestrictions restrictions);
+        public Expression ToExpression();
+    }
+    public sealed class CallInfo {
+        public CallInfo(int argCount, IEnumerable<string> argNames);
+        public CallInfo(int argCount, params string[] argNames);
+        public int ArgumentCount { get; }
+        public ReadOnlyCollection<string> ArgumentNames { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public abstract class ConvertBinder : DynamicMetaObjectBinder {
+        protected ConvertBinder(Type type, bool @explicit);
+        public bool Explicit { get; }
+        public sealed override Type ReturnType { get; }
+        public Type Type { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackConvert(DynamicMetaObject target);
+        public abstract DynamicMetaObject FallbackConvert(DynamicMetaObject target, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class CreateInstanceBinder : DynamicMetaObjectBinder {
+        protected CreateInstanceBinder(CallInfo callInfo);
+        public CallInfo CallInfo { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackCreateInstance(DynamicMetaObject target, DynamicMetaObject[] args);
+        public abstract DynamicMetaObject FallbackCreateInstance(DynamicMetaObject target, DynamicMetaObject[] args, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class DeleteIndexBinder : DynamicMetaObjectBinder {
+        protected DeleteIndexBinder(CallInfo callInfo);
+        public CallInfo CallInfo { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackDeleteIndex(DynamicMetaObject target, DynamicMetaObject[] indexes);
+        public abstract DynamicMetaObject FallbackDeleteIndex(DynamicMetaObject target, DynamicMetaObject[] indexes, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class DeleteMemberBinder : DynamicMetaObjectBinder {
+        protected DeleteMemberBinder(string name, bool ignoreCase);
+        public bool IgnoreCase { get; }
+        public string Name { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackDeleteMember(DynamicMetaObject target);
+        public abstract DynamicMetaObject FallbackDeleteMember(DynamicMetaObject target, DynamicMetaObject errorSuggestion);
+    }
+    public class DynamicMetaObject {
+        public static readonly DynamicMetaObject[] EmptyMetaObjects;
+        public DynamicMetaObject(Expression expression, BindingRestrictions restrictions);
+        public DynamicMetaObject(Expression expression, BindingRestrictions restrictions, object value);
+        public Expression Expression { get; }
+        public bool HasValue { get; }
+        public Type LimitType { get; }
+        public BindingRestrictions Restrictions { get; }
+        public Type RuntimeType { get; }
+        public object Value { get; }
+        public virtual DynamicMetaObject BindBinaryOperation(BinaryOperationBinder binder, DynamicMetaObject arg);
+        public virtual DynamicMetaObject BindConvert(ConvertBinder binder);
+        public virtual DynamicMetaObject BindCreateInstance(CreateInstanceBinder binder, DynamicMetaObject[] args);
+        public virtual DynamicMetaObject BindDeleteIndex(DeleteIndexBinder binder, DynamicMetaObject[] indexes);
+        public virtual DynamicMetaObject BindDeleteMember(DeleteMemberBinder binder);
+        public virtual DynamicMetaObject BindGetIndex(GetIndexBinder binder, DynamicMetaObject[] indexes);
+        public virtual DynamicMetaObject BindGetMember(GetMemberBinder binder);
+        public virtual DynamicMetaObject BindInvoke(InvokeBinder binder, DynamicMetaObject[] args);
+        public virtual DynamicMetaObject BindInvokeMember(InvokeMemberBinder binder, DynamicMetaObject[] args);
+        public virtual DynamicMetaObject BindSetIndex(SetIndexBinder binder, DynamicMetaObject[] indexes, DynamicMetaObject value);
+        public virtual DynamicMetaObject BindSetMember(SetMemberBinder binder, DynamicMetaObject value);
+        public virtual DynamicMetaObject BindUnaryOperation(UnaryOperationBinder binder);
+        public static DynamicMetaObject Create(object value, Expression expression);
+        public virtual IEnumerable<string> GetDynamicMemberNames();
+    }
+    public abstract class DynamicMetaObjectBinder : CallSiteBinder {
+        protected DynamicMetaObjectBinder();
+        public virtual Type ReturnType { get; }
+        public abstract DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public sealed override Expression Bind(object[] args, ReadOnlyCollection<ParameterExpression> parameters, LabelTarget returnLabel);
+        public DynamicMetaObject Defer(DynamicMetaObject target, params DynamicMetaObject[] args);
+        public DynamicMetaObject Defer(params DynamicMetaObject[] args);
+        public Expression GetUpdateExpression(Type type);
+    }
+    public class DynamicObject : IDynamicMetaObjectProvider {
+        protected DynamicObject();
+        public virtual IEnumerable<string> GetDynamicMemberNames();
+        public virtual DynamicMetaObject GetMetaObject(Expression parameter);
+        public virtual bool TryBinaryOperation(BinaryOperationBinder binder, object arg, out object result);
+        public virtual bool TryConvert(ConvertBinder binder, out object result);
+        public virtual bool TryCreateInstance(CreateInstanceBinder binder, object[] args, out object result);
+        public virtual bool TryDeleteIndex(DeleteIndexBinder binder, object[] indexes);
+        public virtual bool TryDeleteMember(DeleteMemberBinder binder);
+        public virtual bool TryGetIndex(GetIndexBinder binder, object[] indexes, out object result);
+        public virtual bool TryGetMember(GetMemberBinder binder, out object result);
+        public virtual bool TryInvoke(InvokeBinder binder, object[] args, out object result);
+        public virtual bool TryInvokeMember(InvokeMemberBinder binder, object[] args, out object result);
+        public virtual bool TrySetIndex(SetIndexBinder binder, object[] indexes, object value);
+        public virtual bool TrySetMember(SetMemberBinder binder, object value);
+        public virtual bool TryUnaryOperation(UnaryOperationBinder binder, out object result);
+    }
+    public sealed class ExpandoObject : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IDynamicMetaObjectProvider, IEnumerable, IEnumerable<KeyValuePair<string, object>>, INotifyPropertyChanged {
+        public ExpandoObject();
+    }
+    public abstract class GetIndexBinder : DynamicMetaObjectBinder {
+        protected GetIndexBinder(CallInfo callInfo);
+        public CallInfo CallInfo { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackGetIndex(DynamicMetaObject target, DynamicMetaObject[] indexes);
+        public abstract DynamicMetaObject FallbackGetIndex(DynamicMetaObject target, DynamicMetaObject[] indexes, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class GetMemberBinder : DynamicMetaObjectBinder {
+        protected GetMemberBinder(string name, bool ignoreCase);
+        public bool IgnoreCase { get; }
+        public string Name { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackGetMember(DynamicMetaObject target);
+        public abstract DynamicMetaObject FallbackGetMember(DynamicMetaObject target, DynamicMetaObject errorSuggestion);
+    }
+    public interface IDynamicMetaObjectProvider {
+        DynamicMetaObject GetMetaObject(Expression parameter);
+    }
+    public interface IInvokeOnGetBinder {
+        bool InvokeOnGet { get; }
+    }
+    public abstract class InvokeBinder : DynamicMetaObjectBinder {
+        protected InvokeBinder(CallInfo callInfo);
+        public CallInfo CallInfo { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackInvoke(DynamicMetaObject target, DynamicMetaObject[] args);
+        public abstract DynamicMetaObject FallbackInvoke(DynamicMetaObject target, DynamicMetaObject[] args, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class InvokeMemberBinder : DynamicMetaObjectBinder {
+        protected InvokeMemberBinder(string name, bool ignoreCase, CallInfo callInfo);
+        public CallInfo CallInfo { get; }
+        public bool IgnoreCase { get; }
+        public string Name { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public abstract DynamicMetaObject FallbackInvoke(DynamicMetaObject target, DynamicMetaObject[] args, DynamicMetaObject errorSuggestion);
+        public DynamicMetaObject FallbackInvokeMember(DynamicMetaObject target, DynamicMetaObject[] args);
+        public abstract DynamicMetaObject FallbackInvokeMember(DynamicMetaObject target, DynamicMetaObject[] args, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class SetIndexBinder : DynamicMetaObjectBinder {
+        protected SetIndexBinder(CallInfo callInfo);
+        public CallInfo CallInfo { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackSetIndex(DynamicMetaObject target, DynamicMetaObject[] indexes, DynamicMetaObject value);
+        public abstract DynamicMetaObject FallbackSetIndex(DynamicMetaObject target, DynamicMetaObject[] indexes, DynamicMetaObject value, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class SetMemberBinder : DynamicMetaObjectBinder {
+        protected SetMemberBinder(string name, bool ignoreCase);
+        public bool IgnoreCase { get; }
+        public string Name { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackSetMember(DynamicMetaObject target, DynamicMetaObject value);
+        public abstract DynamicMetaObject FallbackSetMember(DynamicMetaObject target, DynamicMetaObject value, DynamicMetaObject errorSuggestion);
+    }
+    public abstract class UnaryOperationBinder : DynamicMetaObjectBinder {
+        protected UnaryOperationBinder(ExpressionType operation);
+        public ExpressionType Operation { get; }
+        public sealed override Type ReturnType { get; }
+        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
+        public DynamicMetaObject FallbackUnaryOperation(DynamicMetaObject target);
+        public abstract DynamicMetaObject FallbackUnaryOperation(DynamicMetaObject target, DynamicMetaObject errorSuggestion);
+    }
+}
 namespace System.Globalization {
-    public abstract class Calendar {
+    public abstract class Calendar : ICloneable {
+        public virtual CalendarAlgorithmType AlgorithmType { get; }
+        protected virtual int DaysInYearBeforeMinSupportedYear { get; }
+        public virtual object Clone();
+        public virtual int GetLeapMonth(int year);
+        public static Calendar ReadOnly(Calendar calendar);
     }
+    public enum CalendarAlgorithmType {
+        LunarCalendar = 2,
+        LunisolarCalendar = 3,
+        SolarCalendar = 1,
+        Unknown = 0,
+    }
     public static class CharUnicodeInfo {
+        public static int GetDecimalDigitValue(char ch);
+        public static int GetDecimalDigitValue(string s, int index);
+        public static int GetDigitValue(char ch);
+        public static int GetDigitValue(string s, int index);
     }
     public class ChineseLunisolarCalendar : EastAsianLunisolarCalendar {
+        public const int ChineseEra = 1;
+        protected override int DaysInYearBeforeMinSupportedYear { get; }
     }
-    public class CompareInfo {
+    public class CompareInfo : IDeserializationCallback {
+        public int LCID { get; }
+        public SortVersion Version { get; }
+        public static CompareInfo GetCompareInfo(int culture);
+        public static CompareInfo GetCompareInfo(int culture, Assembly assembly);
+        public static CompareInfo GetCompareInfo(string name, Assembly assembly);
+        public virtual SortKey GetSortKey(string source);
+        public virtual SortKey GetSortKey(string source, CompareOptions options);
+        public virtual int IndexOf(string source, char value, int startIndex);
+        public virtual int IndexOf(string source, string value, int startIndex);
+        public static bool IsSortable(char ch);
+        public static bool IsSortable(string text);
+        public virtual int LastIndexOf(string source, char value, int startIndex);
+        public virtual int LastIndexOf(string source, string value, int startIndex);
     }
-    public class CultureInfo : IFormatProvider {
+    public class CultureInfo : ICloneable, IFormatProvider {
+        public CultureInfo(int culture);
+        public CultureInfo(int culture, bool useUserOverride);
+        public CultureInfo(string name, bool useUserOverride);
+        public CultureTypes CultureTypes { get; }
+        public string IetfLanguageTag { get; }
+        public static CultureInfo InstalledUICulture { get; }
+        public virtual int KeyboardLayoutId { get; }
+        public virtual int LCID { get; }
+        public virtual string ThreeLetterISOLanguageName { get; }
+        public virtual string ThreeLetterWindowsLanguageName { get; }
+        public bool UseUserOverride { get; }
+        public void ClearCachedData();
+        public static CultureInfo CreateSpecificCulture(string name);
+        public CultureInfo GetConsoleFallbackUICulture();
+        public static CultureInfo GetCultureInfo(int culture);
+        public static CultureInfo GetCultureInfo(string name);
+        public static CultureInfo GetCultureInfo(string name, string altName);
+        public static CultureInfo GetCultureInfoByIetfLanguageTag(string name);
+        public static CultureInfo[] GetCultures(CultureTypes types);
     }
-    public class CultureNotFoundException : ArgumentException {
+    public class CultureNotFoundException : ArgumentException, ISerializable {
+        protected CultureNotFoundException(SerializationInfo info, StreamingContext context);
+        public CultureNotFoundException(string message, int invalidCultureId, Exception innerException);
+        public CultureNotFoundException(string paramName, int invalidCultureId, string message);
+        public virtual Nullable<int> InvalidCultureId { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public enum CultureTypes {
+        AllCultures = 7,
+        FrameworkCultures = 64,
+        InstalledWin32Cultures = 4,
+        NeutralCultures = 1,
+        ReplacementCultures = 16,
+        SpecificCultures = 2,
+        UserCustomCulture = 8,
+        WindowsOnlyCultures = 32,
+    }
-    public sealed class DateTimeFormatInfo : IFormatProvider {
+    public sealed class DateTimeFormatInfo : ICloneable, IFormatProvider {
+        public string DateSeparator { get; set; }
+        public string NativeCalendarName { get; }
+        public string TimeSeparator { get; set; }
+        public string[] GetAllDateTimePatterns();
+        public string[] GetAllDateTimePatterns(char format);
+        public string GetShortestDayName(DayOfWeek dayOfWeek);
+        public void SetAllDateTimePatterns(string[] patterns, char format);
     }
+    public class DaylightTime {
+        public DaylightTime(DateTime start, DateTime end, TimeSpan delta);
+        public TimeSpan Delta { get; }
+        public DateTime End { get; }
+        public DateTime Start { get; }
+    }
+    public enum DigitShapes {
+        Context = 0,
+        NativeNational = 2,
+        None = 1,
+    }
     public abstract class EastAsianLunisolarCalendar : Calendar {
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class GregorianCalendar : Calendar {
+        public const int ADEra = 1;
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class HebrewCalendar : Calendar {
+        public static readonly int HebrewEra;
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class HijriCalendar : Calendar {
+        public static readonly int HijriEra;
+        public override CalendarAlgorithmType AlgorithmType { get; }
+        protected override int DaysInYearBeforeMinSupportedYear { get; }
     }
+    public sealed class IdnMapping {
+        public IdnMapping();
+        public bool AllowUnassigned { get; set; }
+        public bool UseStd3AsciiRules { get; set; }
+        public override bool Equals(object obj);
+        public string GetAscii(string unicode);
+        public string GetAscii(string unicode, int index);
+        public string GetAscii(string unicode, int index, int count);
+        public override int GetHashCode();
+        public string GetUnicode(string ascii);
+        public string GetUnicode(string ascii, int index);
+        public string GetUnicode(string ascii, int index, int count);
+    }
     public class JapaneseCalendar : Calendar {
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class JapaneseLunisolarCalendar : EastAsianLunisolarCalendar {
+        public const int JapaneseEra = 1;
+        protected override int DaysInYearBeforeMinSupportedYear { get; }
     }
     public class JulianCalendar : Calendar {
+        public static readonly int JulianEra;
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class KoreanCalendar : Calendar {
+        public const int KoreanEra = 1;
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class KoreanLunisolarCalendar : EastAsianLunisolarCalendar {
+        public const int GregorianEra = 1;
+        protected override int DaysInYearBeforeMinSupportedYear { get; }
     }
-    public sealed class NumberFormatInfo : IFormatProvider {
+    public sealed class NumberFormatInfo : ICloneable, IFormatProvider {
+        public DigitShapes DigitSubstitution { get; set; }
+        public string[] NativeDigits { get; set; }
     }
     public class PersianCalendar : Calendar {
+        public static readonly int PersianEra;
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class RegionInfo {
+        public RegionInfo(int culture);
+        public virtual string CurrencyEnglishName { get; }
+        public virtual string CurrencyNativeName { get; }
+        public virtual int GeoId { get; }
+        public virtual string ThreeLetterISORegionName { get; }
+        public virtual string ThreeLetterWindowsRegionName { get; }
     }
+    public class SortKey {
+        public virtual byte[] KeyData { get; }
+        public virtual string OriginalString { get; }
+        public static int Compare(SortKey sortkey1, SortKey sortkey2);
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public sealed class SortVersion : IEquatable<SortVersion> {
+        public SortVersion(int fullVersion, Guid sortId);
+        public int FullVersion { get; }
+        public Guid SortId { get; }
+        public override bool Equals(object obj);
+        public bool Equals(SortVersion other);
+        public override int GetHashCode();
+        public static bool operator ==(SortVersion left, SortVersion right);
+        public static bool operator !=(SortVersion left, SortVersion right);
+    }
     public class StringInfo {
+        public string SubstringByTextElements(int startingTextElement);
+        public string SubstringByTextElements(int startingTextElement, int lengthInTextElements);
     }
     public class TaiwanCalendar : Calendar {
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class TaiwanLunisolarCalendar : EastAsianLunisolarCalendar {
+        protected override int DaysInYearBeforeMinSupportedYear { get; }
     }
-    public class TextInfo {
+    public class TextInfo : ICloneable, IDeserializationCallback {
+        public virtual int ANSICodePage { get; }
+        public virtual int EBCDICCodePage { get; }
+        public int LCID { get; }
+        public virtual int MacCodePage { get; }
+        public virtual int OEMCodePage { get; }
+        public virtual object Clone();
+        public static TextInfo ReadOnly(TextInfo textInfo);
+        public string ToTitleCase(string str);
     }
     public class ThaiBuddhistCalendar : Calendar {
+        public const int ThaiBuddhistEra = 1;
+        public override CalendarAlgorithmType AlgorithmType { get; }
     }
     public class UmAlQuraCalendar : Calendar {
+        public const int UmAlQuraEra = 1;
+        public override CalendarAlgorithmType AlgorithmType { get; }
+        protected override int DaysInYearBeforeMinSupportedYear { get; }
     }
 }
 namespace System.IO {
     public class BinaryReader : IDisposable {
+        public virtual void Close();
     }
     public class BinaryWriter : IDisposable {
+        public virtual void Close();
     }
     public sealed class BufferedStream : Stream {
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
     }
     public static class Directory {
+        public static string[] GetLogicalDrives();
     }
     public class DirectoryNotFoundException : IOException {
+        protected DirectoryNotFoundException(SerializationInfo info, StreamingContext context);
     }
+    public sealed class DriveInfo : ISerializable {
+        public DriveInfo(string driveName);
+        public long AvailableFreeSpace { get; }
+        public string DriveFormat { get; }
+        public DriveType DriveType { get; }
+        public bool IsReady { get; }
+        public string Name { get; }
+        public DirectoryInfo RootDirectory { get; }
+        public long TotalFreeSpace { get; }
+        public long TotalSize { get; }
+        public string VolumeLabel { get; set; }
+        public static DriveInfo[] GetDrives();
+        public override string ToString();
+    }
+    public class DriveNotFoundException : IOException {
+        public DriveNotFoundException();
+        protected DriveNotFoundException(SerializationInfo info, StreamingContext context);
+        public DriveNotFoundException(string message);
+        public DriveNotFoundException(string message, Exception innerException);
+    }
+    public enum DriveType {
+        CDRom = 5,
+        Fixed = 3,
+        Network = 4,
+        NoRootDirectory = 1,
+        Ram = 6,
+        Removable = 2,
+        Unknown = 0,
+    }
     public class EndOfStreamException : IOException {
+        protected EndOfStreamException(SerializationInfo info, StreamingContext context);
     }
+    public class ErrorEventArgs : EventArgs {
+        public ErrorEventArgs(Exception exception);
+        public virtual Exception GetException();
+    }
+    public delegate void ErrorEventHandler(object sender, ErrorEventArgs e); {
+        public ErrorEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ErrorEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ErrorEventArgs e);
+    }
     public static class File {
+        public static void Decrypt(string path);
+        public static void Encrypt(string path);
+        public static void Replace(string sourceFileName, string destinationFileName, string destinationBackupFileName);
+        public static void Replace(string sourceFileName, string destinationFileName, string destinationBackupFileName, bool ignoreMetadataErrors);
+        public static void WriteAllLines(string path, string[] contents);
+        public static void WriteAllLines(string path, string[] contents, Encoding encoding);
     }
     public sealed class FileInfo : FileSystemInfo {
+        public void Decrypt();
+        public void Encrypt();
+        public FileInfo Replace(string destinationFileName, string destinationBackupFileName);
+        public FileInfo Replace(string destinationFileName, string destinationBackupFileName, bool ignoreMetadataErrors);
     }
     public class FileLoadException : IOException {
+        protected FileLoadException(SerializationInfo info, StreamingContext context);
+        public string FusionLog { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public class FileNotFoundException : IOException {
+        protected FileNotFoundException(SerializationInfo info, StreamingContext context);
+        public string FusionLog { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public class FileStream : Stream {
+        public FileStream(IntPtr handle, FileAccess access);
+        public FileStream(IntPtr handle, FileAccess access, bool ownsHandle);
+        public FileStream(IntPtr handle, FileAccess access, bool ownsHandle, int bufferSize);
+        public FileStream(IntPtr handle, FileAccess access, bool ownsHandle, int bufferSize, bool isAsync);
+        public virtual IntPtr Handle { get; }
+        public override IAsyncResult BeginRead(byte[] array, int offset, int numBytes, AsyncCallback userCallback, object stateObject);
+        public override IAsyncResult BeginWrite(byte[] array, int offset, int numBytes, AsyncCallback userCallback, object stateObject);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public virtual void Lock(long position, long length);
+        public virtual void Unlock(long position, long length);
     }
+    public class FileSystemEventArgs : EventArgs {
+        public FileSystemEventArgs(WatcherChangeTypes changeType, string directory, string name);
+        public WatcherChangeTypes ChangeType { get; }
+        public string FullPath { get; }
+        public string Name { get; }
+    }
+    public delegate void FileSystemEventHandler(object sender, FileSystemEventArgs e); {
+        public FileSystemEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, FileSystemEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, FileSystemEventArgs e);
+    }
-    public abstract class FileSystemInfo {
+    public abstract class FileSystemInfo : MarshalByRefObject, ISerializable {
+        protected FileSystemInfo(SerializationInfo info, StreamingContext context);
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public class FileSystemWatcher : Component, ISupportInitialize {
+        public FileSystemWatcher();
+        public FileSystemWatcher(string path);
+        public FileSystemWatcher(string path, string filter);
+        public bool EnableRaisingEvents { get; set; }
+        public string Filter { get; set; }
+        public bool IncludeSubdirectories { get; set; }
+        public int InternalBufferSize { get; set; }
+        public NotifyFilters NotifyFilter { get; set; }
+        public string Path { get; set; }
+        public override ISite Site { get; set; }
+        public ISynchronizeInvoke SynchronizingObject { get; set; }
+        public void BeginInit();
+        protected override void Dispose(bool disposing);
+        public void EndInit();
+        protected void OnChanged(FileSystemEventArgs e);
+        protected void OnCreated(FileSystemEventArgs e);
+        protected void OnDeleted(FileSystemEventArgs e);
+        protected void OnError(ErrorEventArgs e);
+        protected void OnRenamed(RenamedEventArgs e);
+        public WaitForChangedResult WaitForChanged(WatcherChangeTypes changeType);
+        public WaitForChangedResult WaitForChanged(WatcherChangeTypes changeType, int timeout);
+        public event FileSystemEventHandler Changed;
+        public event FileSystemEventHandler Created;
+        public event FileSystemEventHandler Deleted;
+        public event ErrorEventHandler Error;
+        public event RenamedEventHandler Renamed;
+    }
+    public class InternalBufferOverflowException : SystemException {
+        public InternalBufferOverflowException();
+        protected InternalBufferOverflowException(SerializationInfo info, StreamingContext context);
+        public InternalBufferOverflowException(string message);
+        public InternalBufferOverflowException(string message, Exception inner);
+    }
-    public sealed class InvalidDataException : Exception {
+    public sealed class InvalidDataException : SystemException {
     }
-    public class IOException : Exception {
+    public class IOException : SystemException {
+        protected IOException(SerializationInfo info, StreamingContext context);
     }
     public class MemoryStream : Stream {
+        public virtual byte[] GetBuffer();
     }
+    public enum NotifyFilters {
+        Attributes = 4,
+        CreationTime = 64,
+        DirectoryName = 2,
+        FileName = 1,
+        LastAccess = 32,
+        LastWrite = 16,
+        Security = 256,
+        Size = 8,
+    }
     public static class Path {
+        public static readonly char[] InvalidPathChars;
+        public static string Combine(string path1, string path2, string path3, string path4);
     }
     public class PathTooLongException : IOException {
+        protected PathTooLongException(SerializationInfo info, StreamingContext context);
     }
+    public class RenamedEventArgs : FileSystemEventArgs {
+        public RenamedEventArgs(WatcherChangeTypes changeType, string directory, string name, string oldName);
+        public string OldFullPath { get; }
+        public string OldName { get; }
+    }
+    public delegate void RenamedEventHandler(object sender, RenamedEventArgs e); {
+        public RenamedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, RenamedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, RenamedEventArgs e);
+    }
-    public abstract class Stream : IDisposable {
+    public abstract class Stream : MarshalByRefObject, IDisposable {
+        public virtual IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public virtual IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public virtual void Close();
+        protected virtual WaitHandle CreateWaitHandle();
+        public virtual int EndRead(IAsyncResult asyncResult);
+        public virtual void EndWrite(IAsyncResult asyncResult);
+        protected virtual void ObjectInvariant();
+        public static Stream Synchronized(Stream stream);
     }
     public class StreamReader : TextReader {
+        public StreamReader(string path);
+        public StreamReader(string path, bool detectEncodingFromByteOrderMarks);
+        public StreamReader(string path, Encoding encoding);
+        public StreamReader(string path, Encoding encoding, bool detectEncodingFromByteOrderMarks);
+        public StreamReader(string path, Encoding encoding, bool detectEncodingFromByteOrderMarks, int bufferSize);
+        public override void Close();
     }
     public class StreamWriter : TextWriter {
+        public StreamWriter(string path);
+        public StreamWriter(string path, bool append);
+        public StreamWriter(string path, bool append, Encoding encoding);
+        public StreamWriter(string path, bool append, Encoding encoding, int bufferSize);
+        public override void Close();
     }
     public class StringReader : TextReader {
+        public override void Close();
     }
     public class StringWriter : TextWriter {
+        public override void Close();
     }
-    public abstract class TextReader : IDisposable {
+    public abstract class TextReader : MarshalByRefObject, IDisposable {
+        public virtual void Close();
+        public static TextReader Synchronized(TextReader reader);
     }
-    public abstract class TextWriter : IDisposable {
+    public abstract class TextWriter : MarshalByRefObject, IDisposable {
+        public virtual void Close();
+        public static TextWriter Synchronized(TextWriter writer);
-        public abstract void Write(char value);
+        public virtual void Write(char value);
     }
+    public class UnmanagedMemoryAccessor : IDisposable {
+        protected UnmanagedMemoryAccessor();
+        public UnmanagedMemoryAccessor(SafeBuffer buffer, long offset, long capacity);
+        public UnmanagedMemoryAccessor(SafeBuffer buffer, long offset, long capacity, FileAccess access);
+        public bool CanRead { get; }
+        public bool CanWrite { get; }
+        public long Capacity { get; }
+        protected bool IsOpen { get; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected void Initialize(SafeBuffer buffer, long offset, long capacity, FileAccess access);
+        public void Read<T>(long position, out T structure) where T : struct;
+        public int ReadArray<T>(long position, T[] array, int offset, int count) where T : struct;
+        public bool ReadBoolean(long position);
+        public byte ReadByte(long position);
+        public char ReadChar(long position);
+        public decimal ReadDecimal(long position);
+        public double ReadDouble(long position);
+        public short ReadInt16(long position);
+        public int ReadInt32(long position);
+        public long ReadInt64(long position);
+        public sbyte ReadSByte(long position);
+        public float ReadSingle(long position);
+        public ushort ReadUInt16(long position);
+        public uint ReadUInt32(long position);
+        public ulong ReadUInt64(long position);
+        public void Write<T>(long position, ref T structure) where T : struct;
+        public void Write(long position, bool value);
+        public void Write(long position, byte value);
+        public void Write(long position, char value);
+        public void Write(long position, decimal value);
+        public void Write(long position, double value);
+        public void Write(long position, short value);
+        public void Write(long position, int value);
+        public void Write(long position, long value);
+        public void Write(long position, sbyte value);
+        public void Write(long position, float value);
+        public void Write(long position, ushort value);
+        public void Write(long position, uint value);
+        public void Write(long position, ulong value);
+        public void WriteArray<T>(long position, T[] array, int offset, int count) where T : struct;
+    }
+    public class UnmanagedMemoryStream : Stream {
+        protected UnmanagedMemoryStream();
+        public unsafe UnmanagedMemoryStream(byte* pointer, long length);
+        public unsafe UnmanagedMemoryStream(byte* pointer, long length, long capacity, FileAccess access);
+        public UnmanagedMemoryStream(SafeBuffer buffer, long offset, long length);
+        public UnmanagedMemoryStream(SafeBuffer buffer, long offset, long length, FileAccess access);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public long Capacity { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public unsafe byte* PositionPointer { get; set; }
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        protected unsafe void Initialize(byte* pointer, long length, long capacity, FileAccess access);
+        protected void Initialize(SafeBuffer buffer, long offset, long length, FileAccess access);
+        public override int Read(byte[] buffer, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin loc);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override void WriteByte(byte value);
+    }
+    public struct WaitForChangedResult {
+        public WatcherChangeTypes ChangeType { get; set; }
+        public string Name { get; set; }
+        public string OldName { get; set; }
+        public bool TimedOut { get; set; }
+    }
+    public enum WatcherChangeTypes {
+        All = 15,
+        Changed = 4,
+        Created = 1,
+        Deleted = 2,
+        Renamed = 8,
+    }
 }
 namespace System.IO.Compression {
     public class DeflateStream : Stream {
+        public override IAsyncResult BeginRead(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginWrite(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
-        public override Task<int> ReadAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
-        public override Task WriteAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
     }
     public class GZipStream : Stream {
+        public override IAsyncResult BeginRead(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginWrite(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
-        public override Task<int> ReadAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
-        public override Task WriteAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
     }
 }
+namespace System.IO.IsolatedStorage {
+    public interface INormalizeForIsolatedStorage {
+        object Normalize();
+    }
+    public abstract class IsolatedStorage : MarshalByRefObject {
+        public object ApplicationIdentity { get; }
+        public object AssemblyIdentity { get; }
+        public virtual long AvailableFreeSpace { get; }
+        public virtual ulong CurrentSize { get; }
+        public object DomainIdentity { get; }
+        public virtual ulong MaximumSize { get; }
+        public virtual long Quota { get; }
+        public IsolatedStorageScope Scope { get; }
+        protected virtual char SeparatorExternal { get; }
+        protected virtual char SeparatorInternal { get; }
+        public virtual long UsedSize { get; }
+        public virtual bool IncreaseQuotaTo(long newQuotaSize);
+        protected void InitStore(IsolatedStorageScope scope, Type appEvidenceType);
+        protected void InitStore(IsolatedStorageScope scope, Type domainEvidenceType, Type assemblyEvidenceType);
+        public abstract void Remove();
+    }
+    public class IsolatedStorageException : Exception {
+        public IsolatedStorageException();
+        protected IsolatedStorageException(SerializationInfo info, StreamingContext context);
+        public IsolatedStorageException(string message);
+        public IsolatedStorageException(string message, Exception inner);
+    }
+    public sealed class IsolatedStorageFile : IsolatedStorage, IDisposable {
+        public override long AvailableFreeSpace { get; }
+        public override ulong CurrentSize { get; }
+        public static bool IsEnabled { get; }
+        public override ulong MaximumSize { get; }
+        public override long Quota { get; }
+        public override long UsedSize { get; }
+        public void Close();
+        public void CopyFile(string sourceFileName, string destinationFileName);
+        public void CopyFile(string sourceFileName, string destinationFileName, bool overwrite);
+        public void CreateDirectory(string dir);
+        public IsolatedStorageFileStream CreateFile(string path);
+        public void DeleteDirectory(string dir);
+        public void DeleteFile(string file);
+        public bool DirectoryExists(string path);
+        public void Dispose();
+        public bool FileExists(string path);
+        public DateTimeOffset GetCreationTime(string path);
+        public string[] GetDirectoryNames();
+        public string[] GetDirectoryNames(string searchPattern);
+        public static IEnumerator GetEnumerator(IsolatedStorageScope scope);
+        public string[] GetFileNames();
+        public string[] GetFileNames(string searchPattern);
+        public DateTimeOffset GetLastAccessTime(string path);
+        public DateTimeOffset GetLastWriteTime(string path);
+        public static IsolatedStorageFile GetMachineStoreForApplication();
+        public static IsolatedStorageFile GetMachineStoreForAssembly();
+        public static IsolatedStorageFile GetMachineStoreForDomain();
+        public static IsolatedStorageFile GetStore(IsolatedStorageScope scope, object applicationIdentity);
+        public static IsolatedStorageFile GetStore(IsolatedStorageScope scope, object domainIdentity, object assemblyIdentity);
+        public static IsolatedStorageFile GetStore(IsolatedStorageScope scope, Type applicationEvidenceType);
+        public static IsolatedStorageFile GetStore(IsolatedStorageScope scope, Type domainEvidenceType, Type assemblyEvidenceType);
+        public static IsolatedStorageFile GetUserStoreForApplication();
+        public static IsolatedStorageFile GetUserStoreForAssembly();
+        public static IsolatedStorageFile GetUserStoreForDomain();
+        public static IsolatedStorageFile GetUserStoreForSite();
+        public override bool IncreaseQuotaTo(long newQuotaSize);
+        public void MoveDirectory(string sourceDirectoryName, string destinationDirectoryName);
+        public void MoveFile(string sourceFileName, string destinationFileName);
+        public IsolatedStorageFileStream OpenFile(string path, FileMode mode);
+        public IsolatedStorageFileStream OpenFile(string path, FileMode mode, FileAccess access);
+        public IsolatedStorageFileStream OpenFile(string path, FileMode mode, FileAccess access, FileShare share);
+        public override void Remove();
+        public static void Remove(IsolatedStorageScope scope);
+    }
+    public class IsolatedStorageFileStream : FileStream {
+        public IsolatedStorageFileStream(string path, FileMode mode);
+        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access);
+        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, FileShare share);
+        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize);
+        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, IsolatedStorageFile isf);
+        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, FileShare share, IsolatedStorageFile isf);
+        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, IsolatedStorageFile isf);
+        public IsolatedStorageFileStream(string path, FileMode mode, IsolatedStorageFile isf);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public override IntPtr Handle { get; }
+        public override bool IsAsync { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public override SafeFileHandle SafeFileHandle { get; }
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int numBytes, AsyncCallback userCallback, object stateObject);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int numBytes, AsyncCallback userCallback, object stateObject);
+        protected override void Dispose(bool disposing);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        public override void Flush(bool flushToDisk);
+        public override void Lock(long position, long length);
+        public override int Read(byte[] buffer, int offset, int count);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Unlock(long position, long length);
+        public override void Write(byte[] buffer, int offset, int count);
+        public override void WriteByte(byte value);
+    }
+    public enum IsolatedStorageScope {
+        Application = 32,
+        Assembly = 4,
+        Domain = 2,
+        Machine = 16,
+        None = 0,
+        Roaming = 8,
+        User = 1,
+    }
+}
+namespace System.IO.MemoryMappedFiles {
+    public class MemoryMappedFile : IDisposable {
+        public SafeMemoryMappedFileHandle SafeMemoryMappedFileHandle { get; }
+        public static MemoryMappedFile CreateFromFile(FileStream fileStream, string mapName, long capacity, MemoryMappedFileAccess access, HandleInheritability inheritability, bool leaveOpen);
+        public static MemoryMappedFile CreateFromFile(string path);
+        public static MemoryMappedFile CreateFromFile(string path, FileMode mode);
+        public static MemoryMappedFile CreateFromFile(string path, FileMode mode, string mapName);
+        public static MemoryMappedFile CreateFromFile(string path, FileMode mode, string mapName, long capacity);
+        public static MemoryMappedFile CreateFromFile(string path, FileMode mode, string mapName, long capacity, MemoryMappedFileAccess access);
+        public static MemoryMappedFile CreateNew(string mapName, long capacity);
+        public static MemoryMappedFile CreateNew(string mapName, long capacity, MemoryMappedFileAccess access);
+        public static MemoryMappedFile CreateNew(string mapName, long capacity, MemoryMappedFileAccess access, MemoryMappedFileOptions options, HandleInheritability inheritability);
+        public static MemoryMappedFile CreateOrOpen(string mapName, long capacity);
+        public static MemoryMappedFile CreateOrOpen(string mapName, long capacity, MemoryMappedFileAccess access);
+        public static MemoryMappedFile CreateOrOpen(string mapName, long capacity, MemoryMappedFileAccess access, MemoryMappedFileOptions options, HandleInheritability inheritability);
+        public MemoryMappedViewAccessor CreateViewAccessor();
+        public MemoryMappedViewAccessor CreateViewAccessor(long offset, long size);
+        public MemoryMappedViewAccessor CreateViewAccessor(long offset, long size, MemoryMappedFileAccess access);
+        public MemoryMappedViewStream CreateViewStream();
+        public MemoryMappedViewStream CreateViewStream(long offset, long size);
+        public MemoryMappedViewStream CreateViewStream(long offset, long size, MemoryMappedFileAccess access);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public static MemoryMappedFile OpenExisting(string mapName);
+        public static MemoryMappedFile OpenExisting(string mapName, MemoryMappedFileRights desiredAccessRights);
+        public static MemoryMappedFile OpenExisting(string mapName, MemoryMappedFileRights desiredAccessRights, HandleInheritability inheritability);
+    }
+    public enum MemoryMappedFileAccess {
+        CopyOnWrite = 3,
+        Read = 1,
+        ReadExecute = 4,
+        ReadWrite = 0,
+        ReadWriteExecute = 5,
+        Write = 2,
+    }
+    public enum MemoryMappedFileOptions {
+        DelayAllocatePages = 67108864,
+        None = 0,
+    }
+    public enum MemoryMappedFileRights {
+        AccessSystemSecurity = 16777216,
+        ChangePermissions = 262144,
+        CopyOnWrite = 1,
+        Delete = 65536,
+        Execute = 8,
+        FullControl = 983055,
+        Read = 4,
+        ReadExecute = 12,
+        ReadPermissions = 131072,
+        ReadWrite = 6,
+        ReadWriteExecute = 14,
+        TakeOwnership = 524288,
+        Write = 2,
+    }
+    public sealed class MemoryMappedViewAccessor : UnmanagedMemoryAccessor {
+        public long PointerOffset { get; }
+        public SafeMemoryMappedViewHandle SafeMemoryMappedViewHandle { get; }
+        public void Flush();
+    }
+    public sealed class MemoryMappedViewStream : UnmanagedMemoryStream {
+        public long PointerOffset { get; }
+        public SafeMemoryMappedViewHandle SafeMemoryMappedViewHandle { get; }
+        public override void Flush();
+        public override void SetLength(long value);
+    }
+}
+namespace System.IO.Pipes {
+    public sealed class AnonymousPipeClientStream : PipeStream {
+        public AnonymousPipeClientStream(PipeDirection direction, SafePipeHandle safePipeHandle);
+        public AnonymousPipeClientStream(PipeDirection direction, string pipeHandleAsString);
+        public AnonymousPipeClientStream(string pipeHandleAsString);
+        public override PipeTransmissionMode ReadMode { set; }
+        public override PipeTransmissionMode TransmissionMode { get; }
+    }
+    public sealed class AnonymousPipeServerStream : PipeStream {
+        public AnonymousPipeServerStream();
+        public AnonymousPipeServerStream(PipeDirection direction);
+        public AnonymousPipeServerStream(PipeDirection direction, HandleInheritability inheritability);
+        public AnonymousPipeServerStream(PipeDirection direction, HandleInheritability inheritability, int bufferSize);
+        public AnonymousPipeServerStream(PipeDirection direction, SafePipeHandle serverSafePipeHandle, SafePipeHandle clientSafePipeHandle);
+        public SafePipeHandle ClientSafePipeHandle { get; }
+        public override PipeTransmissionMode ReadMode { set; }
+        public override PipeTransmissionMode TransmissionMode { get; }
+        public void DisposeLocalCopyOfClientHandle();
+        public string GetClientHandleAsString();
+    }
+    public sealed class NamedPipeClientStream : PipeStream {
+        public NamedPipeClientStream(PipeDirection direction, bool isAsync, bool isConnected, SafePipeHandle safePipeHandle);
+        public NamedPipeClientStream(string pipeName);
+        public NamedPipeClientStream(string serverName, string pipeName);
+        public NamedPipeClientStream(string serverName, string pipeName, PipeAccessRights desiredAccessRights, PipeOptions options, TokenImpersonationLevel impersonationLevel, HandleInheritability inheritability);
+        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction);
+        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction, PipeOptions options);
+        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction, PipeOptions options, TokenImpersonationLevel impersonationLevel);
+        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction, PipeOptions options, TokenImpersonationLevel impersonationLevel, HandleInheritability inheritability);
+        public int NumberOfServerInstances { get; }
+        public void Connect();
+        public void Connect(int timeout);
+        public Task ConnectAsync();
+        public Task ConnectAsync(CancellationToken cancellationToken);
+        public Task ConnectAsync(int timeout);
+        public Task ConnectAsync(int timeout, CancellationToken cancellationToken);
+    }
+    public sealed class NamedPipeServerStream : PipeStream {
+        public const int MaxAllowedServerInstances = -1;
+        public NamedPipeServerStream(PipeDirection direction, bool isAsync, bool isConnected, SafePipeHandle safePipeHandle);
+        public NamedPipeServerStream(string pipeName);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode, PipeOptions options);
+        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode, PipeOptions options, int inBufferSize, int outBufferSize);
+        public IAsyncResult BeginWaitForConnection(AsyncCallback callback, object state);
+        public void Disconnect();
+        public void EndWaitForConnection(IAsyncResult asyncResult);
+        public string GetImpersonationUserName();
+        public void RunAsClient(PipeStreamImpersonationWorker impersonationWorker);
+        public void WaitForConnection();
+        public Task WaitForConnectionAsync();
+        public Task WaitForConnectionAsync(CancellationToken cancellationToken);
+    }
+    public enum PipeAccessRights {
+        AccessSystemSecurity = 16777216,
+        ChangePermissions = 262144,
+        CreateNewInstance = 4,
+        Delete = 65536,
+        FullControl = 2032031,
+        Read = 131209,
+        ReadAttributes = 128,
+        ReadData = 1,
+        ReadExtendedAttributes = 8,
+        ReadPermissions = 131072,
+        ReadWrite = 131483,
+        Synchronize = 1048576,
+        TakeOwnership = 524288,
+        Write = 274,
+        WriteAttributes = 256,
+        WriteData = 2,
+        WriteExtendedAttributes = 16,
+    }
+    public enum PipeDirection {
+        In = 1,
+        InOut = 3,
+        Out = 2,
+    }
+    public enum PipeOptions {
+        Asynchronous = 1073741824,
+        None = 0,
+        WriteThrough = -2147483648,
+    }
+    public abstract class PipeStream : Stream {
+        protected PipeStream(PipeDirection direction, int bufferSize);
+        protected PipeStream(PipeDirection direction, PipeTransmissionMode transmissionMode, int outBufferSize);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public virtual int InBufferSize { get; }
+        public bool IsAsync { get; }
+        public bool IsConnected { get; protected set; }
+        protected bool IsHandleExposed { get; }
+        public bool IsMessageComplete { get; }
+        public override long Length { get; }
+        public virtual int OutBufferSize { get; }
+        public override long Position { get; set; }
+        public virtual PipeTransmissionMode ReadMode { get; set; }
+        public SafePipeHandle SafePipeHandle { get; }
+        public virtual PipeTransmissionMode TransmissionMode { get; }
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        protected internal virtual void CheckPipePropertyOperations();
+        protected internal void CheckReadOperations();
+        protected internal void CheckWriteOperations();
+        protected override void Dispose(bool disposing);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        protected void InitializeHandle(SafePipeHandle handle, bool isExposed, bool isAsync);
+        public override int Read(byte[] buffer, int offset, int count);
+        public override int ReadByte();
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public void WaitForPipeDrain();
+        public override void Write(byte[] buffer, int offset, int count);
+        public override void WriteByte(byte value);
+    }
+    public delegate void PipeStreamImpersonationWorker(); {
+        public PipeStreamImpersonationWorker(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke();
+    }
+    public enum PipeTransmissionMode {
+        Byte = 0,
+        Message = 1,
+    }
+}
 namespace System.Linq {
     public static class Enumerable {
-        public static IEnumerable<TSource> Append<TSource>(this IEnumerable<TSource> source, TSource element);
-        public static IEnumerable<TSource> Prepend<TSource>(this IEnumerable<TSource> source, TSource element);
     }
+    public abstract class EnumerableExecutor {
+        protected EnumerableExecutor();
+    }
+    public class EnumerableExecutor<T> : EnumerableExecutor {
+        public EnumerableExecutor(Expression expression);
+    }
+    public abstract class EnumerableQuery {
+        protected EnumerableQuery();
+    }
+    public class EnumerableQuery<T> : EnumerableQuery, IEnumerable, IEnumerable<T>, IOrderedQueryable, IOrderedQueryable<T>, IQueryable, IQueryable<T>, IQueryProvider {
+        public EnumerableQuery(Expression expression);
+        public EnumerableQuery(IEnumerable<T> enumerable);
+        public override string ToString();
+    }
+    public class OrderedParallelQuery<TSource> : ParallelQuery<TSource> {
+        public override IEnumerator<TSource> GetEnumerator();
+    }
+    public static class ParallelEnumerable {
+        public static TSource Aggregate<TSource>(this ParallelQuery<TSource> source, Func<TSource, TSource, TSource> func);
+        public static TAccumulate Aggregate<TSource, TAccumulate>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func);
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func, Func<TAccumulate, TResult> resultSelector);
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> updateAccumulatorFunc, Func<TAccumulate, TAccumulate, TAccumulate> combineAccumulatorsFunc, Func<TAccumulate, TResult> resultSelector);
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, Func<TAccumulate> seedFactory, Func<TAccumulate, TSource, TAccumulate> updateAccumulatorFunc, Func<TAccumulate, TAccumulate, TAccumulate> combineAccumulatorsFunc, Func<TAccumulate, TResult> resultSelector);
+        public static bool All<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static bool Any<TSource>(this ParallelQuery<TSource> source);
+        public static bool Any<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static IEnumerable<TSource> AsEnumerable<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TSource> AsOrdered<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery AsOrdered(this ParallelQuery source);
+        public static ParallelQuery<TSource> AsParallel<TSource>(this Partitioner<TSource> source);
+        public static ParallelQuery<TSource> AsParallel<TSource>(this IEnumerable<TSource> source);
+        public static ParallelQuery AsParallel(this IEnumerable source);
+        public static IEnumerable<TSource> AsSequential<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TSource> AsUnordered<TSource>(this ParallelQuery<TSource> source);
+        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
+        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
+        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
+        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static float Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
+        public static decimal Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, decimal> selector);
+        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<float> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static Nullable<decimal> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<decimal>> selector);
+        public static double Average(this ParallelQuery<int> source);
+        public static double Average(this ParallelQuery<long> source);
+        public static double Average(this ParallelQuery<double> source);
+        public static Nullable<double> Average(this ParallelQuery<Nullable<int>> source);
+        public static Nullable<double> Average(this ParallelQuery<Nullable<long>> source);
+        public static float Average(this ParallelQuery<float> source);
+        public static decimal Average(this ParallelQuery<decimal> source);
+        public static Nullable<double> Average(this ParallelQuery<Nullable<double>> source);
+        public static Nullable<float> Average(this ParallelQuery<Nullable<float>> source);
+        public static Nullable<decimal> Average(this ParallelQuery<Nullable<decimal>> source);
+        public static ParallelQuery<TResult> Cast<TResult>(this ParallelQuery source);
+        public static ParallelQuery<TSource> Concat<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static ParallelQuery<TSource> Concat<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static bool Contains<TSource>(this ParallelQuery<TSource> source, TSource value);
+        public static bool Contains<TSource>(this ParallelQuery<TSource> source, TSource value, IEqualityComparer<TSource> comparer);
+        public static int Count<TSource>(this ParallelQuery<TSource> source);
+        public static int Count<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> DefaultIfEmpty<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TSource> DefaultIfEmpty<TSource>(this ParallelQuery<TSource> source, TSource defaultValue);
+        public static ParallelQuery<TSource> Distinct<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TSource> Distinct<TSource>(this ParallelQuery<TSource> source, IEqualityComparer<TSource> comparer);
+        public static TSource ElementAt<TSource>(this ParallelQuery<TSource> source, int index);
+        public static TSource ElementAtOrDefault<TSource>(this ParallelQuery<TSource> source, int index);
+        public static ParallelQuery<TResult> Empty<TResult>();
+        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
+        public static TSource First<TSource>(this ParallelQuery<TSource> source);
+        public static TSource First<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static TSource FirstOrDefault<TSource>(this ParallelQuery<TSource> source);
+        public static TSource FirstOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static void ForAll<TSource>(this ParallelQuery<TSource> source, Action<TSource> action);
+        public static ParallelQuery<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static ParallelQuery<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector);
+        public static ParallelQuery<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TElement, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector);
+        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TElement, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector);
+        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector);
+        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector);
+        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector);
+        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer);
+        public static TSource Last<TSource>(this ParallelQuery<TSource> source);
+        public static TSource Last<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static TSource LastOrDefault<TSource>(this ParallelQuery<TSource> source);
+        public static TSource LastOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static long LongCount<TSource>(this ParallelQuery<TSource> source);
+        public static long LongCount<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static TSource Max<TSource>(this ParallelQuery<TSource> source);
+        public static int Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
+        public static long Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
+        public static double Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
+        public static Nullable<int> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static float Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
+        public static decimal Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, decimal> selector);
+        public static Nullable<double> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<float> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static Nullable<decimal> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<decimal>> selector);
+        public static TResult Max<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
+        public static int Max(this ParallelQuery<int> source);
+        public static long Max(this ParallelQuery<long> source);
+        public static double Max(this ParallelQuery<double> source);
+        public static Nullable<int> Max(this ParallelQuery<Nullable<int>> source);
+        public static Nullable<long> Max(this ParallelQuery<Nullable<long>> source);
+        public static float Max(this ParallelQuery<float> source);
+        public static decimal Max(this ParallelQuery<decimal> source);
+        public static Nullable<double> Max(this ParallelQuery<Nullable<double>> source);
+        public static Nullable<float> Max(this ParallelQuery<Nullable<float>> source);
+        public static Nullable<decimal> Max(this ParallelQuery<Nullable<decimal>> source);
+        public static TSource Min<TSource>(this ParallelQuery<TSource> source);
+        public static int Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
+        public static long Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
+        public static double Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
+        public static Nullable<int> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static float Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
+        public static decimal Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, decimal> selector);
+        public static Nullable<double> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<float> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static Nullable<decimal> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<decimal>> selector);
+        public static TResult Min<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
+        public static int Min(this ParallelQuery<int> source);
+        public static long Min(this ParallelQuery<long> source);
+        public static double Min(this ParallelQuery<double> source);
+        public static Nullable<int> Min(this ParallelQuery<Nullable<int>> source);
+        public static Nullable<long> Min(this ParallelQuery<Nullable<long>> source);
+        public static float Min(this ParallelQuery<float> source);
+        public static decimal Min(this ParallelQuery<decimal> source);
+        public static Nullable<double> Min(this ParallelQuery<Nullable<double>> source);
+        public static Nullable<float> Min(this ParallelQuery<Nullable<float>> source);
+        public static Nullable<decimal> Min(this ParallelQuery<Nullable<decimal>> source);
+        public static ParallelQuery<TResult> OfType<TResult>(this ParallelQuery source);
+        public static OrderedParallelQuery<TSource> OrderBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static OrderedParallelQuery<TSource> OrderBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static OrderedParallelQuery<TSource> OrderByDescending<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static OrderedParallelQuery<TSource> OrderByDescending<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static ParallelQuery<int> Range(int start, int count);
+        public static ParallelQuery<TResult> Repeat<TResult>(TResult element, int count);
+        public static ParallelQuery<TSource> Reverse<TSource>(this ParallelQuery<TSource> source);
+        public static ParallelQuery<TResult> Select<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
+        public static ParallelQuery<TResult> Select<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, TResult> selector);
+        public static ParallelQuery<TResult> SelectMany<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, IEnumerable<TResult>> selector);
+        public static ParallelQuery<TResult> SelectMany<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, IEnumerable<TResult>> selector);
+        public static ParallelQuery<TResult> SelectMany<TSource, TCollection, TResult>(this ParallelQuery<TSource> source, Func<TSource, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
+        public static ParallelQuery<TResult> SelectMany<TSource, TCollection, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
+        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
+        public static TSource Single<TSource>(this ParallelQuery<TSource> source);
+        public static TSource Single<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static TSource SingleOrDefault<TSource>(this ParallelQuery<TSource> source);
+        public static TSource SingleOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> Skip<TSource>(this ParallelQuery<TSource> source, int count);
+        public static ParallelQuery<TSource> SkipWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> SkipWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
+        public static int Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
+        public static long Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
+        public static double Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
+        public static Nullable<int> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
+        public static Nullable<long> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
+        public static float Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
+        public static decimal Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, decimal> selector);
+        public static Nullable<double> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
+        public static Nullable<float> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
+        public static Nullable<decimal> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<decimal>> selector);
+        public static int Sum(this ParallelQuery<int> source);
+        public static long Sum(this ParallelQuery<long> source);
+        public static double Sum(this ParallelQuery<double> source);
+        public static Nullable<int> Sum(this ParallelQuery<Nullable<int>> source);
+        public static Nullable<long> Sum(this ParallelQuery<Nullable<long>> source);
+        public static float Sum(this ParallelQuery<float> source);
+        public static decimal Sum(this ParallelQuery<decimal> source);
+        public static Nullable<double> Sum(this ParallelQuery<Nullable<double>> source);
+        public static Nullable<float> Sum(this ParallelQuery<Nullable<float>> source);
+        public static Nullable<decimal> Sum(this ParallelQuery<Nullable<decimal>> source);
+        public static ParallelQuery<TSource> Take<TSource>(this ParallelQuery<TSource> source, int count);
+        public static ParallelQuery<TSource> TakeWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> TakeWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
+        public static OrderedParallelQuery<TSource> ThenBy<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static OrderedParallelQuery<TSource> ThenBy<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static OrderedParallelQuery<TSource> ThenByDescending<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static OrderedParallelQuery<TSource> ThenByDescending<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
+        public static TSource[] ToArray<TSource>(this ParallelQuery<TSource> source);
+        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static List<TSource> ToList<TSource>(this ParallelQuery<TSource> source);
+        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
+        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
+        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
+        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
+        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
+        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
+        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
+        public static ParallelQuery<TSource> Where<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
+        public static ParallelQuery<TSource> Where<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
+        public static ParallelQuery<TSource> WithCancellation<TSource>(this ParallelQuery<TSource> source, CancellationToken cancellationToken);
+        public static ParallelQuery<TSource> WithDegreeOfParallelism<TSource>(this ParallelQuery<TSource> source, int degreeOfParallelism);
+        public static ParallelQuery<TSource> WithExecutionMode<TSource>(this ParallelQuery<TSource> source, ParallelExecutionMode executionMode);
+        public static ParallelQuery<TSource> WithMergeOptions<TSource>(this ParallelQuery<TSource> source, ParallelMergeOptions mergeOptions);
+        public static ParallelQuery<TResult> Zip<TFirst, TSecond, TResult>(this ParallelQuery<TFirst> first, IEnumerable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector);
+        public static ParallelQuery<TResult> Zip<TFirst, TSecond, TResult>(this ParallelQuery<TFirst> first, ParallelQuery<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector);
+    }
+    public enum ParallelExecutionMode {
+        Default = 0,
+        ForceParallelism = 1,
+    }
+    public enum ParallelMergeOptions {
+        AutoBuffered = 2,
+        Default = 0,
+        FullyBuffered = 3,
+        NotBuffered = 1,
+    }
+    public class ParallelQuery : IEnumerable
+    public class ParallelQuery<TSource> : ParallelQuery, IEnumerable, IEnumerable<TSource> {
+        public virtual IEnumerator<TSource> GetEnumerator();
+    }
+    public static class Queryable {
+        public static TSource Aggregate<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, TSource, TSource>> func);
+        public static TAccumulate Aggregate<TSource, TAccumulate>(this IQueryable<TSource> source, TAccumulate seed, Expression<Func<TAccumulate, TSource, TAccumulate>> func);
+        public static TResult Aggregate<TSource, TAccumulate, TResult>(this IQueryable<TSource> source, TAccumulate seed, Expression<Func<TAccumulate, TSource, TAccumulate>> func, Expression<Func<TAccumulate, TResult>> selector);
+        public static bool All<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static bool Any<TSource>(this IQueryable<TSource> source);
+        public static bool Any<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TElement> AsQueryable<TElement>(this IEnumerable<TElement> source);
+        public static IQueryable AsQueryable(this IEnumerable source);
+        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int>> selector);
+        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, long>> selector);
+        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, double>> selector);
+        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<int>>> selector);
+        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<long>>> selector);
+        public static float Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, float>> selector);
+        public static decimal Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, decimal>> selector);
+        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<double>>> selector);
+        public static Nullable<float> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<float>>> selector);
+        public static Nullable<decimal> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<decimal>>> selector);
+        public static double Average(this IQueryable<int> source);
+        public static double Average(this IQueryable<long> source);
+        public static double Average(this IQueryable<double> source);
+        public static Nullable<double> Average(this IQueryable<Nullable<int>> source);
+        public static Nullable<double> Average(this IQueryable<Nullable<long>> source);
+        public static float Average(this IQueryable<float> source);
+        public static decimal Average(this IQueryable<decimal> source);
+        public static Nullable<double> Average(this IQueryable<Nullable<double>> source);
+        public static Nullable<float> Average(this IQueryable<Nullable<float>> source);
+        public static Nullable<decimal> Average(this IQueryable<Nullable<decimal>> source);
+        public static IQueryable<TResult> Cast<TResult>(this IQueryable source);
+        public static IQueryable<TSource> Concat<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static bool Contains<TSource>(this IQueryable<TSource> source, TSource item);
+        public static bool Contains<TSource>(this IQueryable<TSource> source, TSource item, IEqualityComparer<TSource> comparer);
+        public static int Count<TSource>(this IQueryable<TSource> source);
+        public static int Count<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> DefaultIfEmpty<TSource>(this IQueryable<TSource> source);
+        public static IQueryable<TSource> DefaultIfEmpty<TSource>(this IQueryable<TSource> source, TSource defaultValue);
+        public static IQueryable<TSource> Distinct<TSource>(this IQueryable<TSource> source);
+        public static IQueryable<TSource> Distinct<TSource>(this IQueryable<TSource> source, IEqualityComparer<TSource> comparer);
+        public static TSource ElementAt<TSource>(this IQueryable<TSource> source, int index);
+        public static TSource ElementAtOrDefault<TSource>(this IQueryable<TSource> source, int index);
+        public static IQueryable<TSource> Except<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static IQueryable<TSource> Except<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
+        public static TSource First<TSource>(this IQueryable<TSource> source);
+        public static TSource First<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static TSource FirstOrDefault<TSource>(this IQueryable<TSource> source);
+        public static TSource FirstOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IQueryable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector);
+        public static IQueryable<TResult> GroupBy<TSource, TKey, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TKey, IEnumerable<TSource>, TResult>> resultSelector);
+        public static IQueryable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<TResult> GroupBy<TSource, TKey, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TKey, IEnumerable<TSource>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, Expression<Func<TKey, IEnumerable<TElement>, TResult>> resultSelector);
+        public static IQueryable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, Expression<Func<TKey, IEnumerable<TElement>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, IEnumerable<TInner>, TResult>> resultSelector);
+        public static IQueryable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, IEnumerable<TInner>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
+        public static IQueryable<TSource> Intersect<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static IQueryable<TSource> Intersect<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
+        public static IQueryable<TResult> Join<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, TInner, TResult>> resultSelector);
+        public static IQueryable<TResult> Join<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, TInner, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
+        public static TSource Last<TSource>(this IQueryable<TSource> source);
+        public static TSource Last<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static TSource LastOrDefault<TSource>(this IQueryable<TSource> source);
+        public static TSource LastOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static long LongCount<TSource>(this IQueryable<TSource> source);
+        public static long LongCount<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static TSource Max<TSource>(this IQueryable<TSource> source);
+        public static TResult Max<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
+        public static TSource Min<TSource>(this IQueryable<TSource> source);
+        public static TResult Min<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
+        public static IQueryable<TResult> OfType<TResult>(this IQueryable source);
+        public static IOrderedQueryable<TSource> OrderBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IOrderedQueryable<TSource> OrderBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
+        public static IOrderedQueryable<TSource> OrderByDescending<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IOrderedQueryable<TSource> OrderByDescending<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
+        public static IQueryable<TSource> Reverse<TSource>(this IQueryable<TSource> source);
+        public static IQueryable<TResult> Select<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
+        public static IQueryable<TResult> Select<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, TResult>> selector);
+        public static IQueryable<TResult> SelectMany<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, IEnumerable<TResult>>> selector);
+        public static IQueryable<TResult> SelectMany<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, IEnumerable<TResult>>> selector);
+        public static IQueryable<TResult> SelectMany<TSource, TCollection, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, IEnumerable<TCollection>>> collectionSelector, Expression<Func<TSource, TCollection, TResult>> resultSelector);
+        public static IQueryable<TResult> SelectMany<TSource, TCollection, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, IEnumerable<TCollection>>> collectionSelector, Expression<Func<TSource, TCollection, TResult>> resultSelector);
+        public static bool SequenceEqual<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static bool SequenceEqual<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
+        public static TSource Single<TSource>(this IQueryable<TSource> source);
+        public static TSource Single<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static TSource SingleOrDefault<TSource>(this IQueryable<TSource> source);
+        public static TSource SingleOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> Skip<TSource>(this IQueryable<TSource> source, int count);
+        public static IQueryable<TSource> SkipWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> SkipWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
+        public static int Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int>> selector);
+        public static long Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, long>> selector);
+        public static double Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, double>> selector);
+        public static Nullable<int> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<int>>> selector);
+        public static Nullable<long> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<long>>> selector);
+        public static float Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, float>> selector);
+        public static decimal Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, decimal>> selector);
+        public static Nullable<double> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<double>>> selector);
+        public static Nullable<float> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<float>>> selector);
+        public static Nullable<decimal> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<decimal>>> selector);
+        public static int Sum(this IQueryable<int> source);
+        public static long Sum(this IQueryable<long> source);
+        public static double Sum(this IQueryable<double> source);
+        public static Nullable<int> Sum(this IQueryable<Nullable<int>> source);
+        public static Nullable<long> Sum(this IQueryable<Nullable<long>> source);
+        public static float Sum(this IQueryable<float> source);
+        public static decimal Sum(this IQueryable<decimal> source);
+        public static Nullable<double> Sum(this IQueryable<Nullable<double>> source);
+        public static Nullable<float> Sum(this IQueryable<Nullable<float>> source);
+        public static Nullable<decimal> Sum(this IQueryable<Nullable<decimal>> source);
+        public static IQueryable<TSource> Take<TSource>(this IQueryable<TSource> source, int count);
+        public static IQueryable<TSource> TakeWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> TakeWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
+        public static IOrderedQueryable<TSource> ThenBy<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IOrderedQueryable<TSource> ThenBy<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
+        public static IOrderedQueryable<TSource> ThenByDescending<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
+        public static IOrderedQueryable<TSource> ThenByDescending<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
+        public static IQueryable<TSource> Union<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
+        public static IQueryable<TSource> Union<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
+        public static IQueryable<TSource> Where<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
+        public static IQueryable<TSource> Where<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
+        public static IQueryable<TResult> Zip<TFirst, TSecond, TResult>(this IQueryable<TFirst> source1, IEnumerable<TSecond> source2, Expression<Func<TFirst, TSecond, TResult>> resultSelector);
+    }
 }
 namespace System.Linq.Expressions {
+    public class DynamicExpression : Expression, IArgumentProvider, IDynamicExpression {
+        public ReadOnlyCollection<Expression> Arguments { get; }
+        public CallSiteBinder Binder { get; }
+        public Type DelegateType { get; }
+        public sealed override ExpressionType NodeType { get; }
+        public override Type Type { get; }
+        protected internal override Expression Accept(ExpressionVisitor visitor);
+        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0);
+        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1);
+        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1, Expression arg2);
+        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
+        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, params Expression[] arguments);
+        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, IEnumerable<Expression> arguments);
+        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0);
+        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1);
+        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1, Expression arg2);
+        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
+        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, params Expression[] arguments);
+        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, IEnumerable<Expression> arguments);
+        public DynamicExpression Update(IEnumerable<Expression> arguments);
+    }
+    public abstract class DynamicExpressionVisitor : ExpressionVisitor {
+        protected DynamicExpressionVisitor();
+        protected internal override Expression VisitDynamic(DynamicExpression node);
+    }
     public abstract class Expression {
+        protected Expression(ExpressionType nodeType, Type type);
+        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0);
+        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1);
+        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1, Expression arg2);
+        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
+        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, params Expression[] arguments);
+        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, IEnumerable<Expression> arguments);
+        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0);
+        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1);
+        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1, Expression arg2);
+        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
+        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, params Expression[] arguments);
+        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, IEnumerable<Expression> arguments);
     }
     public sealed class Expression<TDelegate> : LambdaExpression {
-        public new TDelegate Compile(bool preferInterpretation);
+        public new TDelegate Compile(DebugInfoGenerator debugInfoGenerator);
     }
     public abstract class ExpressionVisitor {
+        protected internal virtual Expression VisitDynamic(DynamicExpression node);
     }
     public abstract class LambdaExpression : Expression {
-        public Delegate Compile(bool preferInterpretation);
+        public Delegate Compile(DebugInfoGenerator debugInfoGenerator);
     }
     public abstract class MemberBinding {
+        protected MemberBinding(MemberBindingType type, MemberInfo member);
     }
 }
 namespace System.Net {
+    public class AuthenticationManager {
+        public static ICredentialPolicy CredentialPolicy { get; set; }
+        public static StringDictionary CustomTargetNameDictionary { get; }
+        public static IEnumerator RegisteredModules { get; }
+        public static Authorization Authenticate(string challenge, WebRequest request, ICredentials credentials);
+        public static Authorization PreAuthenticate(WebRequest request, ICredentials credentials);
+        public static void Register(IAuthenticationModule authenticationModule);
+        public static void Unregister(IAuthenticationModule authenticationModule);
+        public static void Unregister(string authenticationScheme);
+    }
+    public delegate AuthenticationSchemes AuthenticationSchemeSelector(HttpListenerRequest httpRequest); {
+        public AuthenticationSchemeSelector(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(HttpListenerRequest httpRequest, AsyncCallback callback, object @object);
+        public virtual AuthenticationSchemes EndInvoke(IAsyncResult result);
+        public virtual AuthenticationSchemes Invoke(HttpListenerRequest httpRequest);
+    }
+    public class Authorization {
+        public Authorization(string token);
+        public Authorization(string token, bool finished);
+        public Authorization(string token, bool finished, string connectionGroupId);
+        public bool Complete { get; }
+        public string ConnectionGroupId { get; }
+        public string Message { get; }
+        public bool MutuallyAuthenticated { get; set; }
+        public string[] ProtectionRealm { get; set; }
+    }
+    public delegate IPEndPoint BindIPEndPoint(ServicePoint servicePoint, IPEndPoint remoteEndPoint, int retryCount); {
+        public BindIPEndPoint(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(ServicePoint servicePoint, IPEndPoint remoteEndPoint, int retryCount, AsyncCallback callback, object @object);
+        public virtual IPEndPoint EndInvoke(IAsyncResult result);
+        public virtual IPEndPoint Invoke(ServicePoint servicePoint, IPEndPoint remoteEndPoint, int retryCount);
+    }
     public class CookieCollection : ICollection, IEnumerable {
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public Cookie this[int index] { get; }
+        public object SyncRoot { get; }
+        public void CopyTo(Array array, int index);
+        public void CopyTo(Cookie[] array, int index);
     }
     public class CookieContainer {
+        public CookieContainer(int capacity);
+        public CookieContainer(int capacity, int perDomainCapacity, int maxCookieSize);
+        public void Add(Cookie cookie);
+        public void Add(CookieCollection cookies);
     }
-    public class CookieException : FormatException {
+    public class CookieException : FormatException, ISerializable {
+        protected CookieException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
+    public static class Dns {
+        public static IAsyncResult BeginGetHostAddresses(string hostNameOrAddress, AsyncCallback requestCallback, object state);
+        public static IAsyncResult BeginGetHostByName(string hostName, AsyncCallback requestCallback, object stateObject);
+        public static IAsyncResult BeginGetHostEntry(IPAddress address, AsyncCallback requestCallback, object stateObject);
+        public static IAsyncResult BeginGetHostEntry(string hostNameOrAddress, AsyncCallback requestCallback, object stateObject);
+        public static IAsyncResult BeginResolve(string hostName, AsyncCallback requestCallback, object stateObject);
+        public static IPAddress[] EndGetHostAddresses(IAsyncResult asyncResult);
+        public static IPHostEntry EndGetHostByName(IAsyncResult asyncResult);
+        public static IPHostEntry EndGetHostEntry(IAsyncResult asyncResult);
+        public static IPHostEntry EndResolve(IAsyncResult asyncResult);
+        public static IPAddress[] GetHostAddresses(string hostNameOrAddress);
+        public static Task<IPAddress[]> GetHostAddressesAsync(string hostNameOrAddress);
+        public static IPHostEntry GetHostByAddress(IPAddress address);
+        public static IPHostEntry GetHostByAddress(string address);
+        public static IPHostEntry GetHostByName(string hostName);
+        public static IPHostEntry GetHostEntry(IPAddress address);
+        public static IPHostEntry GetHostEntry(string hostNameOrAddress);
+        public static Task<IPHostEntry> GetHostEntryAsync(IPAddress address);
+        public static Task<IPHostEntry> GetHostEntryAsync(string hostNameOrAddress);
+        public static string GetHostName();
+        public static IPHostEntry Resolve(string hostName);
+    }
+    public class DownloadDataCompletedEventArgs : AsyncCompletedEventArgs {
+        public byte[] Result { get; }
+    }
+    public delegate void DownloadDataCompletedEventHandler(object sender, DownloadDataCompletedEventArgs e); {
+        public DownloadDataCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DownloadDataCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DownloadDataCompletedEventArgs e);
+    }
+    public class DownloadProgressChangedEventArgs : ProgressChangedEventArgs {
+        public long BytesReceived { get; }
+        public long TotalBytesToReceive { get; }
+    }
+    public delegate void DownloadProgressChangedEventHandler(object sender, DownloadProgressChangedEventArgs e); {
+        public DownloadProgressChangedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DownloadProgressChangedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DownloadProgressChangedEventArgs e);
+    }
+    public class DownloadStringCompletedEventArgs : AsyncCompletedEventArgs {
+        public string Result { get; }
+    }
+    public delegate void DownloadStringCompletedEventHandler(object sender, DownloadStringCompletedEventArgs e); {
+        public DownloadStringCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, DownloadStringCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, DownloadStringCompletedEventArgs e);
+    }
+    public class EndpointPermission {
+        public string Hostname { get; }
+        public int Port { get; }
+        public TransportType Transport { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public class FileWebRequest : WebRequest, ISerializable {
+        protected FileWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override string ConnectionGroupName { get; set; }
+        public override long ContentLength { get; set; }
+        public override string ContentType { get; set; }
+        public override ICredentials Credentials { get; set; }
+        public override WebHeaderCollection Headers { get; }
+        public override string Method { get; set; }
+        public override bool PreAuthenticate { get; set; }
+        public override IWebProxy Proxy { get; set; }
+        public override Uri RequestUri { get; }
+        public override int Timeout { get; set; }
+        public override bool UseDefaultCredentials { get; set; }
+        public override void Abort();
+        public override IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
+        public override IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
+        public override Stream EndGetRequestStream(IAsyncResult asyncResult);
+        public override WebResponse EndGetResponse(IAsyncResult asyncResult);
+        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override Stream GetRequestStream();
+        public override WebResponse GetResponse();
+    }
+    public class FileWebResponse : WebResponse, ISerializable {
+        protected FileWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override long ContentLength { get; }
+        public override string ContentType { get; }
+        public override WebHeaderCollection Headers { get; }
+        public override Uri ResponseUri { get; }
+        public override bool SupportsHeaders { get; }
+        public override void Close();
+        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override Stream GetResponseStream();
+    }
+    public enum FtpStatusCode {
+        AccountNeeded = 532,
+        ActionAbortedLocalProcessingError = 451,
+        ActionAbortedUnknownPageType = 551,
+        ActionNotTakenFilenameNotAllowed = 553,
+        ActionNotTakenFileUnavailable = 550,
+        ActionNotTakenFileUnavailableOrBusy = 450,
+        ActionNotTakenInsufficientSpace = 452,
+        ArgumentSyntaxError = 501,
+        BadCommandSequence = 503,
+        CantOpenData = 425,
+        ClosingControl = 221,
+        ClosingData = 226,
+        CommandExtraneous = 202,
+        CommandNotImplemented = 502,
+        CommandOK = 200,
+        CommandSyntaxError = 500,
+        ConnectionClosed = 426,
+        DataAlreadyOpen = 125,
+        DirectoryStatus = 212,
+        EnteringPassive = 227,
+        FileActionAborted = 552,
+        FileActionOK = 250,
+        FileCommandPending = 350,
+        FileStatus = 213,
+        LoggedInProceed = 230,
+        NeedLoginAccount = 332,
+        NotLoggedIn = 530,
+        OpeningData = 150,
+        PathnameCreated = 257,
+        RestartMarker = 110,
+        SendPasswordCommand = 331,
+        SendUserCommand = 220,
+        ServerWantsSecureSession = 234,
+        ServiceNotAvailable = 421,
+        ServiceTemporarilyNotAvailable = 120,
+        SystemType = 215,
+        Undefined = 0,
+    }
+    public sealed class FtpWebRequest : WebRequest {
+        public X509CertificateCollection ClientCertificates { get; set; }
+        public override string ConnectionGroupName { get; set; }
+        public override long ContentLength { get; set; }
+        public long ContentOffset { get; set; }
+        public override string ContentType { get; set; }
+        public override ICredentials Credentials { get; set; }
+        public static new RequestCachePolicy DefaultCachePolicy { get; set; }
+        public bool EnableSsl { get; set; }
+        public override WebHeaderCollection Headers { get; set; }
+        public bool KeepAlive { get; set; }
+        public override string Method { get; set; }
+        public override bool PreAuthenticate { get; set; }
+        public override IWebProxy Proxy { get; set; }
+        public int ReadWriteTimeout { get; set; }
+        public string RenameTo { get; set; }
+        public override Uri RequestUri { get; }
+        public ServicePoint ServicePoint { get; }
+        public override int Timeout { get; set; }
+        public bool UseBinary { get; set; }
+        public override bool UseDefaultCredentials { get; set; }
+        public bool UsePassive { get; set; }
+        public override void Abort();
+        public override IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
+        public override IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
+        public override Stream EndGetRequestStream(IAsyncResult asyncResult);
+        public override WebResponse EndGetResponse(IAsyncResult asyncResult);
+        public override Stream GetRequestStream();
+        public override WebResponse GetResponse();
+    }
+    public class FtpWebResponse : WebResponse, IDisposable {
+        public string BannerMessage { get; }
+        public override long ContentLength { get; }
+        public string ExitMessage { get; }
+        public override WebHeaderCollection Headers { get; }
+        public DateTime LastModified { get; }
+        public override Uri ResponseUri { get; }
+        public FtpStatusCode StatusCode { get; }
+        public string StatusDescription { get; }
+        public override bool SupportsHeaders { get; }
+        public string WelcomeMessage { get; }
+        public override void Close();
+        public override Stream GetResponseStream();
+    }
+    public class GlobalProxySelection {
+        public GlobalProxySelection();
+        public static IWebProxy Select { get; set; }
+        public static IWebProxy GetEmptyWebProxy();
+    }
+    public delegate void HttpContinueDelegate(int StatusCode, WebHeaderCollection httpHeaders); {
+        public HttpContinueDelegate(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(int StatusCode, WebHeaderCollection httpHeaders, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(int StatusCode, WebHeaderCollection httpHeaders);
+    }
+    public sealed class HttpListener : IDisposable {
+        public delegate ExtendedProtectionPolicy ExtendedProtectionSelector(HttpListenerRequest request); {
+            public ExtendedProtectionSelector(object @object, IntPtr method);
+            public virtual IAsyncResult BeginInvoke(HttpListenerRequest request, AsyncCallback callback, object @object);
+            public virtual ExtendedProtectionPolicy EndInvoke(IAsyncResult result);
+            public virtual ExtendedProtectionPolicy Invoke(HttpListenerRequest request);
+        }
+        public HttpListener();
+        public AuthenticationSchemes AuthenticationSchemes { get; set; }
+        public AuthenticationSchemeSelector AuthenticationSchemeSelectorDelegate { get; set; }
+        public ServiceNameCollection DefaultServiceNames { get; }
+        public ExtendedProtectionPolicy ExtendedProtectionPolicy { get; set; }
+        public HttpListener.ExtendedProtectionSelector ExtendedProtectionSelectorDelegate { get; set; }
+        public bool IgnoreWriteExceptions { get; set; }
+        public bool IsListening { get; }
+        public static bool IsSupported { get; }
+        public HttpListenerPrefixCollection Prefixes { get; }
+        public string Realm { get; set; }
+        public HttpListenerTimeoutManager TimeoutManager { get; }
+        public bool UnsafeConnectionNtlmAuthentication { get; set; }
+        public void Abort();
+        public IAsyncResult BeginGetContext(AsyncCallback callback, object state);
+        public void Close();
+        public HttpListenerContext EndGetContext(IAsyncResult asyncResult);
+        public HttpListenerContext GetContext();
+        public Task<HttpListenerContext> GetContextAsync();
+        public void Start();
+        public void Stop();
+    }
+    public class HttpListenerBasicIdentity : GenericIdentity {
+        public HttpListenerBasicIdentity(string username, string password);
+        public virtual string Password { get; }
+    }
+    public sealed class HttpListenerContext {
+        public HttpListenerRequest Request { get; }
+        public HttpListenerResponse Response { get; }
+        public IPrincipal User { get; }
+        public Task<HttpListenerWebSocketContext> AcceptWebSocketAsync(string subProtocol);
+        public Task<HttpListenerWebSocketContext> AcceptWebSocketAsync(string subProtocol, int receiveBufferSize, TimeSpan keepAliveInterval);
+        public Task<HttpListenerWebSocketContext> AcceptWebSocketAsync(string subProtocol, int receiveBufferSize, TimeSpan keepAliveInterval, ArraySegment<byte> internalBuffer);
+        public Task<HttpListenerWebSocketContext> AcceptWebSocketAsync(string subProtocol, TimeSpan keepAliveInterval);
+    }
+    public class HttpListenerException : Win32Exception {
+        public HttpListenerException();
+        public HttpListenerException(int errorCode);
+        public HttpListenerException(int errorCode, string message);
+        protected HttpListenerException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override int ErrorCode { get; }
+    }
+    public class HttpListenerPrefixCollection : ICollection<string>, IEnumerable, IEnumerable<string> {
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public void Add(string uriPrefix);
+        public void Clear();
+        public bool Contains(string uriPrefix);
+        public void CopyTo(Array array, int offset);
+        public void CopyTo(string[] array, int offset);
+        public IEnumerator<string> GetEnumerator();
+        public bool Remove(string uriPrefix);
+    }
+    public sealed class HttpListenerRequest {
+        public string[] AcceptTypes { get; }
+        public int ClientCertificateError { get; }
+        public Encoding ContentEncoding { get; }
+        public long ContentLength64 { get; }
+        public string ContentType { get; }
+        public CookieCollection Cookies { get; }
+        public bool HasEntityBody { get; }
+        public NameValueCollection Headers { get; }
+        public string HttpMethod { get; }
+        public Stream InputStream { get; }
+        public bool IsAuthenticated { get; }
+        public bool IsLocal { get; }
+        public bool IsSecureConnection { get; }
+        public bool IsWebSocketRequest { get; }
+        public bool KeepAlive { get; }
+        public IPEndPoint LocalEndPoint { get; }
+        public Version ProtocolVersion { get; }
+        public NameValueCollection QueryString { get; }
+        public string RawUrl { get; }
+        public IPEndPoint RemoteEndPoint { get; }
+        public Guid RequestTraceIdentifier { get; }
+        public string ServiceName { get; }
+        public TransportContext TransportContext { get; }
+        public Uri Url { get; }
+        public Uri UrlReferrer { get; }
+        public string UserAgent { get; }
+        public string UserHostAddress { get; }
+        public string UserHostName { get; }
+        public string[] UserLanguages { get; }
+        public IAsyncResult BeginGetClientCertificate(AsyncCallback requestCallback, object state);
+        public X509Certificate2 EndGetClientCertificate(IAsyncResult asyncResult);
+        public X509Certificate2 GetClientCertificate();
+        public Task<X509Certificate2> GetClientCertificateAsync();
+    }
+    public sealed class HttpListenerResponse : IDisposable {
+        public Encoding ContentEncoding { get; set; }
+        public long ContentLength64 { get; set; }
+        public string ContentType { get; set; }
+        public CookieCollection Cookies { get; set; }
+        public WebHeaderCollection Headers { get; set; }
+        public bool KeepAlive { get; set; }
+        public Stream OutputStream { get; }
+        public Version ProtocolVersion { get; set; }
+        public string RedirectLocation { get; set; }
+        public bool SendChunked { get; set; }
+        public int StatusCode { get; set; }
+        public string StatusDescription { get; set; }
+        public void Abort();
+        public void AddHeader(string name, string value);
+        public void AppendCookie(Cookie cookie);
+        public void AppendHeader(string name, string value);
+        public void Close();
+        public void Close(byte[] responseEntity, bool willBlock);
+        public void CopyFrom(HttpListenerResponse templateResponse);
+        public void Redirect(string url);
+        public void SetCookie(Cookie cookie);
+    }
+    public class HttpListenerTimeoutManager {
+        public TimeSpan DrainEntityBody { get; set; }
+        public TimeSpan EntityBody { get; set; }
+        public TimeSpan HeaderWait { get; set; }
+        public TimeSpan IdleConnection { get; set; }
+        public long MinSendBytesPerSecond { get; set; }
+        public TimeSpan RequestQueue { get; set; }
+    }
+    public enum HttpRequestHeader {
+        Accept = 20,
+        AcceptCharset = 21,
+        AcceptEncoding = 22,
+        AcceptLanguage = 23,
+        Allow = 10,
+        Authorization = 24,
+        CacheControl = 0,
+        Connection = 1,
+        ContentEncoding = 13,
+        ContentLanguage = 14,
+        ContentLength = 11,
+        ContentLocation = 15,
+        ContentMd5 = 16,
+        ContentRange = 17,
+        ContentType = 12,
+        Cookie = 25,
+        Date = 2,
+        Expect = 26,
+        Expires = 18,
+        From = 27,
+        Host = 28,
+        IfMatch = 29,
+        IfModifiedSince = 30,
+        IfNoneMatch = 31,
+        IfRange = 32,
+        IfUnmodifiedSince = 33,
+        KeepAlive = 3,
+        LastModified = 19,
+        MaxForwards = 34,
+        Pragma = 4,
+        ProxyAuthorization = 35,
+        Range = 37,
+        Referer = 36,
+        Te = 38,
+        Trailer = 5,
+        TransferEncoding = 6,
+        Translate = 39,
+        Upgrade = 7,
+        UserAgent = 40,
+        Via = 8,
+        Warning = 9,
+    }
+    public enum HttpResponseHeader {
+        AcceptRanges = 20,
+        Age = 21,
+        Allow = 10,
+        CacheControl = 0,
+        Connection = 1,
+        ContentEncoding = 13,
+        ContentLanguage = 14,
+        ContentLength = 11,
+        ContentLocation = 15,
+        ContentMd5 = 16,
+        ContentRange = 17,
+        ContentType = 12,
+        Date = 2,
+        ETag = 22,
+        Expires = 18,
+        KeepAlive = 3,
+        LastModified = 19,
+        Location = 23,
+        Pragma = 4,
+        ProxyAuthenticate = 24,
+        RetryAfter = 25,
+        Server = 26,
+        SetCookie = 27,
+        Trailer = 5,
+        TransferEncoding = 6,
+        Upgrade = 7,
+        Vary = 28,
+        Via = 8,
+        Warning = 9,
+        WwwAuthenticate = 29,
+    }
+    public class HttpVersion {
+        public static readonly Version Version10;
+        public static readonly Version Version11;
+        public HttpVersion();
+    }
+    public class HttpWebRequest : WebRequest, ISerializable {
+        protected HttpWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public string Accept { get; set; }
+        public Uri Address { get; }
+        public virtual bool AllowAutoRedirect { get; set; }
+        public virtual bool AllowReadStreamBuffering { get; set; }
+        public virtual bool AllowWriteStreamBuffering { get; set; }
+        public DecompressionMethods AutomaticDecompression { get; set; }
+        public X509CertificateCollection ClientCertificates { get; set; }
+        public string Connection { get; set; }
+        public override string ConnectionGroupName { get; set; }
+        public override long ContentLength { get; set; }
+        public override string ContentType { get; set; }
+        public HttpContinueDelegate ContinueDelegate { get; set; }
+        public int ContinueTimeout { get; set; }
+        public virtual CookieContainer CookieContainer { get; set; }
+        public override ICredentials Credentials { get; set; }
+        public DateTime Date { get; set; }
+        public static new RequestCachePolicy DefaultCachePolicy { get; set; }
+        public static int DefaultMaximumErrorResponseLength { get; set; }
+        public static int DefaultMaximumResponseHeadersLength { get; set; }
+        public string Expect { get; set; }
+        public virtual bool HaveResponse { get; }
+        public override WebHeaderCollection Headers { get; set; }
+        public string Host { get; set; }
+        public DateTime IfModifiedSince { get; set; }
+        public bool KeepAlive { get; set; }
+        public int MaximumAutomaticRedirections { get; set; }
+        public int MaximumResponseHeadersLength { get; set; }
+        public string MediaType { get; set; }
+        public override string Method { get; set; }
+        public bool Pipelined { get; set; }
+        public override bool PreAuthenticate { get; set; }
+        public Version ProtocolVersion { get; set; }
+        public override IWebProxy Proxy { get; set; }
+        public int ReadWriteTimeout { get; set; }
+        public string Referer { get; set; }
+        public override Uri RequestUri { get; }
+        public bool SendChunked { get; set; }
+        public RemoteCertificateValidationCallback ServerCertificateValidationCallback { get; set; }
+        public ServicePoint ServicePoint { get; }
+        public virtual bool SupportsCookieContainer { get; }
+        public override int Timeout { get; set; }
+        public string TransferEncoding { get; set; }
+        public bool UnsafeAuthenticatedConnectionSharing { get; set; }
+        public override bool UseDefaultCredentials { get; set; }
+        public string UserAgent { get; set; }
+        public override void Abort();
+        public void AddRange(int range);
+        public void AddRange(int from, int to);
+        public void AddRange(long range);
+        public void AddRange(long from, long to);
+        public void AddRange(string rangeSpecifier, int range);
+        public void AddRange(string rangeSpecifier, int from, int to);
+        public void AddRange(string rangeSpecifier, long range);
+        public void AddRange(string rangeSpecifier, long from, long to);
+        public override IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
+        public override IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
+        public override Stream EndGetRequestStream(IAsyncResult asyncResult);
+        public Stream EndGetRequestStream(IAsyncResult asyncResult, out TransportContext context);
+        public override WebResponse EndGetResponse(IAsyncResult asyncResult);
+        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override Stream GetRequestStream();
+        public Stream GetRequestStream(out TransportContext context);
+        public override WebResponse GetResponse();
+    }
+    public class HttpWebResponse : WebResponse, ISerializable {
+        protected HttpWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public string CharacterSet { get; }
+        public string ContentEncoding { get; }
+        public override long ContentLength { get; }
+        public override string ContentType { get; }
+        public virtual CookieCollection Cookies { get; set; }
+        public override WebHeaderCollection Headers { get; }
+        public override bool IsMutuallyAuthenticated { get; }
+        public DateTime LastModified { get; }
+        public virtual string Method { get; }
+        public Version ProtocolVersion { get; }
+        public override Uri ResponseUri { get; }
+        public string Server { get; }
+        public virtual HttpStatusCode StatusCode { get; }
+        public virtual string StatusDescription { get; }
+        public override bool SupportsHeaders { get; }
+        public override void Close();
+        protected override void Dispose(bool disposing);
+        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public string GetResponseHeader(string headerName);
+        public override Stream GetResponseStream();
+    }
+    public interface IAuthenticationModule {
+        string AuthenticationType { get; }
+        bool CanPreAuthenticate { get; }
+        Authorization Authenticate(string challenge, WebRequest request, ICredentials credentials);
+        Authorization PreAuthenticate(WebRequest request, ICredentials credentials);
+    }
+    public interface ICertificatePolicy {
+        bool CheckValidationResult(ServicePoint srvPoint, X509Certificate certificate, WebRequest request, int certificateProblem);
+    }
+    public interface ICredentialPolicy {
+        bool ShouldSendCredential(Uri challengeUri, WebRequest request, NetworkCredential credential, IAuthenticationModule authenticationModule);
+    }
     public class IPAddress {
+        public long Address { get; set; }
     }
+    public class IPHostEntry {
+        public IPHostEntry();
+        public IPAddress[] AddressList { get; set; }
+        public string[] Aliases { get; set; }
+        public string HostName { get; set; }
+    }
+    public interface IWebProxyScript {
+        void Close();
+        bool Load(Uri scriptLocation, string script, Type helperType);
+        string Run(string url, string host);
+    }
+    public interface IWebRequestCreate {
+        WebRequest Create(Uri uri);
+    }
+    public enum NetworkAccess {
+        Accept = 128,
+        Connect = 64,
+    }
     public class NetworkCredential : ICredentials, ICredentialsByHost {
+        public NetworkCredential(string userName, SecureString password);
+        public NetworkCredential(string userName, SecureString password, string domain);
+        public SecureString SecurePassword { get; set; }
     }
+    public class OpenReadCompletedEventArgs : AsyncCompletedEventArgs {
+        public Stream Result { get; }
+    }
+    public delegate void OpenReadCompletedEventHandler(object sender, OpenReadCompletedEventArgs e); {
+        public OpenReadCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, OpenReadCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, OpenReadCompletedEventArgs e);
+    }
+    public class OpenWriteCompletedEventArgs : AsyncCompletedEventArgs {
+        public Stream Result { get; }
+    }
+    public delegate void OpenWriteCompletedEventHandler(object sender, OpenWriteCompletedEventArgs e); {
+        public OpenWriteCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, OpenWriteCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, OpenWriteCompletedEventArgs e);
+    }
+    public class ProtocolViolationException : InvalidOperationException, ISerializable {
+        public ProtocolViolationException();
+        protected ProtocolViolationException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public ProtocolViolationException(string message);
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+    }
+    public enum SecurityProtocolType {
+        Ssl3 = 48,
+        Tls = 192,
+        Tls11 = 768,
+        Tls12 = 3072,
+    }
+    public class ServicePoint {
+        public Uri Address { get; }
+        public BindIPEndPoint BindIPEndPointDelegate { get; set; }
+        public X509Certificate Certificate { get; }
+        public X509Certificate ClientCertificate { get; }
+        public int ConnectionLeaseTimeout { get; set; }
+        public int ConnectionLimit { get; set; }
+        public string ConnectionName { get; }
+        public int CurrentConnections { get; }
+        public bool Expect100Continue { get; set; }
+        public DateTime IdleSince { get; }
+        public int MaxIdleTime { get; set; }
+        public virtual Version ProtocolVersion { get; }
+        public int ReceiveBufferSize { get; set; }
+        public bool SupportsPipelining { get; }
+        public bool UseNagleAlgorithm { get; set; }
+        public bool CloseConnectionGroup(string connectionGroupName);
+        public void SetTcpKeepAlive(bool enabled, int keepAliveTime, int keepAliveInterval);
+    }
+    public class ServicePointManager {
+        public const int DefaultNonPersistentConnectionLimit = 4;
+        public const int DefaultPersistentConnectionLimit = 2;
+        public static ICertificatePolicy CertificatePolicy { get; set; }
+        public static bool CheckCertificateRevocationList { get; set; }
+        public static int DefaultConnectionLimit { get; set; }
+        public static int DnsRefreshTimeout { get; set; }
+        public static bool EnableDnsRoundRobin { get; set; }
+        public static EncryptionPolicy EncryptionPolicy { get; }
+        public static bool Expect100Continue { get; set; }
+        public static int MaxServicePointIdleTime { get; set; }
+        public static int MaxServicePoints { get; set; }
+        public static bool ReusePort { get; set; }
+        public static SecurityProtocolType SecurityProtocol { get; set; }
+        public static RemoteCertificateValidationCallback ServerCertificateValidationCallback { get; set; }
+        public static bool UseNagleAlgorithm { get; set; }
+        public static ServicePoint FindServicePoint(string uriString, IWebProxy proxy);
+        public static ServicePoint FindServicePoint(Uri address);
+        public static ServicePoint FindServicePoint(Uri address, IWebProxy proxy);
+        public static void SetTcpKeepAlive(bool enabled, int keepAliveTime, int keepAliveInterval);
+    }
     public abstract class TransportContext {
+        public virtual IEnumerable<TokenBinding> GetTlsTokenBindings();
     }
+    public enum TransportType {
+        All = 3,
+        Connectionless = 1,
+        ConnectionOriented = 2,
+        Tcp = 2,
+        Udp = 1,
+    }
+    public class UploadDataCompletedEventArgs : AsyncCompletedEventArgs {
+        public byte[] Result { get; }
+    }
+    public delegate void UploadDataCompletedEventHandler(object sender, UploadDataCompletedEventArgs e); {
+        public UploadDataCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, UploadDataCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, UploadDataCompletedEventArgs e);
+    }
+    public class UploadFileCompletedEventArgs : AsyncCompletedEventArgs {
+        public byte[] Result { get; }
+    }
+    public delegate void UploadFileCompletedEventHandler(object sender, UploadFileCompletedEventArgs e); {
+        public UploadFileCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, UploadFileCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, UploadFileCompletedEventArgs e);
+    }
+    public class UploadProgressChangedEventArgs : ProgressChangedEventArgs {
+        public long BytesReceived { get; }
+        public long BytesSent { get; }
+        public long TotalBytesToReceive { get; }
+        public long TotalBytesToSend { get; }
+    }
+    public delegate void UploadProgressChangedEventHandler(object sender, UploadProgressChangedEventArgs e); {
+        public UploadProgressChangedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, UploadProgressChangedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, UploadProgressChangedEventArgs e);
+    }
+    public class UploadStringCompletedEventArgs : AsyncCompletedEventArgs {
+        public string Result { get; }
+    }
+    public delegate void UploadStringCompletedEventHandler(object sender, UploadStringCompletedEventArgs e); {
+        public UploadStringCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, UploadStringCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, UploadStringCompletedEventArgs e);
+    }
+    public class UploadValuesCompletedEventArgs : AsyncCompletedEventArgs {
+        public byte[] Result { get; }
+    }
+    public delegate void UploadValuesCompletedEventHandler(object sender, UploadValuesCompletedEventArgs e); {
+        public UploadValuesCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, UploadValuesCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, UploadValuesCompletedEventArgs e);
+    }
+    public class WebClient : Component {
+        public WebClient();
+        public string BaseAddress { get; set; }
+        public RequestCachePolicy CachePolicy { get; set; }
+        public ICredentials Credentials { get; set; }
+        public Encoding Encoding { get; set; }
+        public WebHeaderCollection Headers { get; set; }
+        public bool IsBusy { get; }
+        public IWebProxy Proxy { get; set; }
+        public NameValueCollection QueryString { get; set; }
+        public WebHeaderCollection ResponseHeaders { get; }
+        public bool UseDefaultCredentials { get; set; }
+        public void CancelAsync();
+        public byte[] DownloadData(string address);
+        public byte[] DownloadData(Uri address);
+        public void DownloadDataAsync(Uri address);
+        public void DownloadDataAsync(Uri address, object userToken);
+        public Task<byte[]> DownloadDataTaskAsync(string address);
+        public Task<byte[]> DownloadDataTaskAsync(Uri address);
+        public void DownloadFile(string address, string fileName);
+        public void DownloadFile(Uri address, string fileName);
+        public void DownloadFileAsync(Uri address, string fileName);
+        public void DownloadFileAsync(Uri address, string fileName, object userToken);
+        public Task DownloadFileTaskAsync(string address, string fileName);
+        public Task DownloadFileTaskAsync(Uri address, string fileName);
+        public string DownloadString(string address);
+        public string DownloadString(Uri address);
+        public void DownloadStringAsync(Uri address);
+        public void DownloadStringAsync(Uri address, object userToken);
+        public Task<string> DownloadStringTaskAsync(string address);
+        public Task<string> DownloadStringTaskAsync(Uri address);
+        protected virtual WebRequest GetWebRequest(Uri address);
+        protected virtual WebResponse GetWebResponse(WebRequest request);
+        protected virtual WebResponse GetWebResponse(WebRequest request, IAsyncResult result);
+        protected virtual void OnDownloadDataCompleted(DownloadDataCompletedEventArgs e);
+        protected virtual void OnDownloadFileCompleted(AsyncCompletedEventArgs e);
+        protected virtual void OnDownloadProgressChanged(DownloadProgressChangedEventArgs e);
+        protected virtual void OnDownloadStringCompleted(DownloadStringCompletedEventArgs e);
+        protected virtual void OnOpenReadCompleted(OpenReadCompletedEventArgs e);
+        protected virtual void OnOpenWriteCompleted(OpenWriteCompletedEventArgs e);
+        protected virtual void OnUploadDataCompleted(UploadDataCompletedEventArgs e);
+        protected virtual void OnUploadFileCompleted(UploadFileCompletedEventArgs e);
+        protected virtual void OnUploadProgressChanged(UploadProgressChangedEventArgs e);
+        protected virtual void OnUploadStringCompleted(UploadStringCompletedEventArgs e);
+        protected virtual void OnUploadValuesCompleted(UploadValuesCompletedEventArgs e);
+        public Stream OpenRead(string address);
+        public Stream OpenRead(Uri address);
+        public void OpenReadAsync(Uri address);
+        public void OpenReadAsync(Uri address, object userToken);
+        public Task<Stream> OpenReadTaskAsync(string address);
+        public Task<Stream> OpenReadTaskAsync(Uri address);
+        public Stream OpenWrite(string address);
+        public Stream OpenWrite(string address, string method);
+        public Stream OpenWrite(Uri address);
+        public Stream OpenWrite(Uri address, string method);
+        public void OpenWriteAsync(Uri address);
+        public void OpenWriteAsync(Uri address, string method);
+        public void OpenWriteAsync(Uri address, string method, object userToken);
+        public Task<Stream> OpenWriteTaskAsync(string address);
+        public Task<Stream> OpenWriteTaskAsync(string address, string method);
+        public Task<Stream> OpenWriteTaskAsync(Uri address);
+        public Task<Stream> OpenWriteTaskAsync(Uri address, string method);
+        public byte[] UploadData(string address, byte[] data);
+        public byte[] UploadData(string address, string method, byte[] data);
+        public byte[] UploadData(Uri address, byte[] data);
+        public byte[] UploadData(Uri address, string method, byte[] data);
+        public void UploadDataAsync(Uri address, byte[] data);
+        public void UploadDataAsync(Uri address, string method, byte[] data);
+        public void UploadDataAsync(Uri address, string method, byte[] data, object userToken);
+        public Task<byte[]> UploadDataTaskAsync(string address, byte[] data);
+        public Task<byte[]> UploadDataTaskAsync(string address, string method, byte[] data);
+        public Task<byte[]> UploadDataTaskAsync(Uri address, byte[] data);
+        public Task<byte[]> UploadDataTaskAsync(Uri address, string method, byte[] data);
+        public byte[] UploadFile(string address, string fileName);
+        public byte[] UploadFile(string address, string method, string fileName);
+        public byte[] UploadFile(Uri address, string fileName);
+        public byte[] UploadFile(Uri address, string method, string fileName);
+        public void UploadFileAsync(Uri address, string fileName);
+        public void UploadFileAsync(Uri address, string method, string fileName);
+        public void UploadFileAsync(Uri address, string method, string fileName, object userToken);
+        public Task<byte[]> UploadFileTaskAsync(string address, string fileName);
+        public Task<byte[]> UploadFileTaskAsync(string address, string method, string fileName);
+        public Task<byte[]> UploadFileTaskAsync(Uri address, string fileName);
+        public Task<byte[]> UploadFileTaskAsync(Uri address, string method, string fileName);
+        public string UploadString(string address, string data);
+        public string UploadString(string address, string method, string data);
+        public string UploadString(Uri address, string data);
+        public string UploadString(Uri address, string method, string data);
+        public void UploadStringAsync(Uri address, string data);
+        public void UploadStringAsync(Uri address, string method, string data);
+        public void UploadStringAsync(Uri address, string method, string data, object userToken);
+        public Task<string> UploadStringTaskAsync(string address, string data);
+        public Task<string> UploadStringTaskAsync(string address, string method, string data);
+        public Task<string> UploadStringTaskAsync(Uri address, string data);
+        public Task<string> UploadStringTaskAsync(Uri address, string method, string data);
+        public byte[] UploadValues(string address, NameValueCollection data);
+        public byte[] UploadValues(string address, string method, NameValueCollection data);
+        public byte[] UploadValues(Uri address, NameValueCollection data);
+        public byte[] UploadValues(Uri address, string method, NameValueCollection data);
+        public void UploadValuesAsync(Uri address, NameValueCollection data);
+        public void UploadValuesAsync(Uri address, string method, NameValueCollection data);
+        public void UploadValuesAsync(Uri address, string method, NameValueCollection data, object userToken);
+        public Task<byte[]> UploadValuesTaskAsync(string address, NameValueCollection data);
+        public Task<byte[]> UploadValuesTaskAsync(string address, string method, NameValueCollection data);
+        public Task<byte[]> UploadValuesTaskAsync(Uri address, NameValueCollection data);
+        public Task<byte[]> UploadValuesTaskAsync(Uri address, string method, NameValueCollection data);
+        public event DownloadDataCompletedEventHandler DownloadDataCompleted;
+        public event AsyncCompletedEventHandler DownloadFileCompleted;
+        public event DownloadProgressChangedEventHandler DownloadProgressChanged;
+        public event DownloadStringCompletedEventHandler DownloadStringCompleted;
+        public event OpenReadCompletedEventHandler OpenReadCompleted;
+        public event OpenWriteCompletedEventHandler OpenWriteCompleted;
+        public event UploadDataCompletedEventHandler UploadDataCompleted;
+        public event UploadFileCompletedEventHandler UploadFileCompleted;
+        public event UploadProgressChangedEventHandler UploadProgressChanged;
+        public event UploadStringCompletedEventHandler UploadStringCompleted;
+        public event UploadValuesCompletedEventHandler UploadValuesCompleted;
+    }
+    public class WebException : InvalidOperationException, ISerializable {
+        public WebException();
+        protected WebException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public WebException(string message);
+        public WebException(string message, Exception innerException);
+        public WebException(string message, Exception innerException, WebExceptionStatus status, WebResponse response);
+        public WebException(string message, WebExceptionStatus status);
+        public WebResponse Response { get; }
+        public WebExceptionStatus Status { get; }
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+    }
+    public enum WebExceptionStatus {
+        CacheEntryNotFound = 18,
+        ConnectFailure = 2,
+        ConnectionClosed = 8,
+        KeepAliveFailure = 12,
+        MessageLengthLimitExceeded = 17,
+        NameResolutionFailure = 1,
+        Pending = 13,
+        PipelineFailure = 5,
+        ProtocolError = 7,
+        ProxyNameResolutionFailure = 15,
+        ReceiveFailure = 3,
+        RequestCanceled = 6,
+        RequestProhibitedByCachePolicy = 19,
+        RequestProhibitedByProxy = 20,
+        SecureChannelFailure = 10,
+        SendFailure = 4,
+        ServerProtocolViolation = 11,
+        Success = 0,
+        Timeout = 14,
+        TrustFailure = 9,
+        UnknownError = 16,
+    }
+    public class WebHeaderCollection : NameValueCollection, ISerializable {
+        public WebHeaderCollection();
+        protected WebHeaderCollection(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override string[] AllKeys { get; }
+        public override int Count { get; }
+        public string this[HttpRequestHeader header] { get; set; }
+        public string this[HttpResponseHeader header] { get; set; }
+        public override NameObjectCollectionBase.KeysCollection Keys { get; }
+        public void Add(HttpRequestHeader header, string value);
+        public void Add(HttpResponseHeader header, string value);
+        public void Add(string header);
+        public override void Add(string name, string value);
+        protected void AddWithoutValidate(string headerName, string headerValue);
+        public override void Clear();
+        public override string Get(int index);
+        public override string Get(string name);
+        public override IEnumerator GetEnumerator();
+        public override string GetKey(int index);
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override string[] GetValues(int index);
+        public override string[] GetValues(string header);
+        public static bool IsRestricted(string headerName);
+        public static bool IsRestricted(string headerName, bool response);
+        public override void OnDeserialization(object sender);
+        public void Remove(HttpRequestHeader header);
+        public void Remove(HttpResponseHeader header);
+        public override void Remove(string name);
+        public void Set(HttpRequestHeader header, string value);
+        public void Set(HttpResponseHeader header, string value);
+        public override void Set(string name, string value);
+        public byte[] ToByteArray();
+        public override string ToString();
+    }
+    public class WebProxy : ISerializable, IWebProxy {
+        public WebProxy();
+        protected WebProxy(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public WebProxy(string Address);
+        public WebProxy(string Address, bool BypassOnLocal);
+        public WebProxy(string Address, bool BypassOnLocal, string[] BypassList);
+        public WebProxy(string Address, bool BypassOnLocal, string[] BypassList, ICredentials Credentials);
+        public WebProxy(string Host, int Port);
+        public WebProxy(Uri Address);
+        public WebProxy(Uri Address, bool BypassOnLocal);
+        public WebProxy(Uri Address, bool BypassOnLocal, string[] BypassList);
+        public WebProxy(Uri Address, bool BypassOnLocal, string[] BypassList, ICredentials Credentials);
+        public Uri Address { get; set; }
+        public ArrayList BypassArrayList { get; }
+        public string[] BypassList { get; set; }
+        public bool BypassProxyOnLocal { get; set; }
+        public ICredentials Credentials { get; set; }
+        public bool UseDefaultCredentials { get; set; }
+        public static WebProxy GetDefaultProxy();
+        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public Uri GetProxy(Uri destination);
+        public bool IsBypassed(Uri host);
+    }
+    public abstract class WebRequest : MarshalByRefObject, ISerializable {
+        protected WebRequest();
+        protected WebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public AuthenticationLevel AuthenticationLevel { get; set; }
+        public virtual RequestCachePolicy CachePolicy { get; set; }
+        public virtual string ConnectionGroupName { get; set; }
+        public virtual long ContentLength { get; set; }
+        public virtual string ContentType { get; set; }
+        public virtual ICredentials Credentials { get; set; }
+        public static RequestCachePolicy DefaultCachePolicy { get; set; }
+        public static IWebProxy DefaultWebProxy { get; set; }
+        public virtual WebHeaderCollection Headers { get; set; }
+        public TokenImpersonationLevel ImpersonationLevel { get; set; }
+        public virtual string Method { get; set; }
+        public virtual bool PreAuthenticate { get; set; }
+        public virtual IWebProxy Proxy { get; set; }
+        public virtual Uri RequestUri { get; }
+        public virtual int Timeout { get; set; }
+        public virtual bool UseDefaultCredentials { get; set; }
+        public virtual void Abort();
+        public virtual IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
+        public virtual IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
+        public static WebRequest Create(string requestUriString);
+        public static WebRequest Create(Uri requestUri);
+        public static WebRequest CreateDefault(Uri requestUri);
+        public static HttpWebRequest CreateHttp(string requestUriString);
+        public static HttpWebRequest CreateHttp(Uri requestUri);
+        public virtual Stream EndGetRequestStream(IAsyncResult asyncResult);
+        public virtual WebResponse EndGetResponse(IAsyncResult asyncResult);
+        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public virtual Stream GetRequestStream();
+        public virtual Task<Stream> GetRequestStreamAsync();
+        public virtual WebResponse GetResponse();
+        public virtual Task<WebResponse> GetResponseAsync();
+        public static IWebProxy GetSystemWebProxy();
+        public static bool RegisterPrefix(string prefix, IWebRequestCreate creator);
+    }
+    public static class WebRequestMethods {
+        public static class File {
+            public const string DownloadFile = "GET";
+            public const string UploadFile = "PUT";
+        }
+        public static class Ftp {
+            public const string AppendFile = "APPE";
+            public const string DeleteFile = "DELE";
+            public const string DownloadFile = "RETR";
+            public const string GetDateTimestamp = "MDTM";
+            public const string GetFileSize = "SIZE";
+            public const string ListDirectory = "NLST";
+            public const string ListDirectoryDetails = "LIST";
+            public const string MakeDirectory = "MKD";
+            public const string PrintWorkingDirectory = "PWD";
+            public const string RemoveDirectory = "RMD";
+            public const string Rename = "RENAME";
+            public const string UploadFile = "STOR";
+            public const string UploadFileWithUniqueName = "STOU";
+        }
+        public static class Http {
+            public const string Connect = "CONNECT";
+            public const string Get = "GET";
+            public const string Head = "HEAD";
+            public const string MkCol = "MKCOL";
+            public const string Post = "POST";
+            public const string Put = "PUT";
+        }
+    }
+    public abstract class WebResponse : MarshalByRefObject, IDisposable, ISerializable {
+        protected WebResponse();
+        protected WebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public virtual long ContentLength { get; set; }
+        public virtual string ContentType { get; set; }
+        public virtual WebHeaderCollection Headers { get; }
+        public virtual bool IsFromCache { get; }
+        public virtual bool IsMutuallyAuthenticated { get; }
+        public virtual Uri ResponseUri { get; }
+        public virtual bool SupportsHeaders { get; }
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public virtual Stream GetResponseStream();
+    }
     public static class WebUtility {
+        public static void HtmlDecode(string value, TextWriter output);
+        public static void HtmlEncode(string value, TextWriter output);
     }
 }
+namespace System.Net.Cache {
+    public enum HttpCacheAgeControl {
+        MaxAge = 2,
+        MaxAgeAndMaxStale = 6,
+        MaxAgeAndMinFresh = 3,
+        MaxStale = 4,
+        MinFresh = 1,
+        None = 0,
+    }
+    public enum HttpRequestCacheLevel {
+        BypassCache = 1,
+        CacheIfAvailable = 3,
+        CacheOnly = 2,
+        CacheOrNextCacheOnly = 7,
+        Default = 0,
+        NoCacheNoStore = 6,
+        Refresh = 8,
+        Reload = 5,
+        Revalidate = 4,
+    }
+    public class HttpRequestCachePolicy : RequestCachePolicy {
+        public HttpRequestCachePolicy();
+        public HttpRequestCachePolicy(DateTime cacheSyncDate);
+        public HttpRequestCachePolicy(HttpCacheAgeControl cacheAgeControl, TimeSpan ageOrFreshOrStale);
+        public HttpRequestCachePolicy(HttpCacheAgeControl cacheAgeControl, TimeSpan maxAge, TimeSpan freshOrStale);
+        public HttpRequestCachePolicy(HttpCacheAgeControl cacheAgeControl, TimeSpan maxAge, TimeSpan freshOrStale, DateTime cacheSyncDate);
+        public HttpRequestCachePolicy(HttpRequestCacheLevel level);
+        public DateTime CacheSyncDate { get; }
+        public new HttpRequestCacheLevel Level { get; }
+        public TimeSpan MaxAge { get; }
+        public TimeSpan MaxStale { get; }
+        public TimeSpan MinFresh { get; }
+        public override string ToString();
+    }
+    public enum RequestCacheLevel {
+        BypassCache = 1,
+        CacheIfAvailable = 3,
+        CacheOnly = 2,
+        Default = 0,
+        NoCacheNoStore = 6,
+        Reload = 5,
+        Revalidate = 4,
+    }
+    public class RequestCachePolicy {
+        public RequestCachePolicy();
+        public RequestCachePolicy(RequestCacheLevel level);
+        public RequestCacheLevel Level { get; }
+        public override string ToString();
+    }
+}
 namespace System.Net.Http {
     public class HttpClientHandler : HttpMessageHandler {
-        public bool CheckCertificateRevocationList { get; set; }
-        public X509CertificateCollection ClientCertificates { get; }
-        public ICredentials DefaultProxyCredentials { get; set; }
-        public int MaxConnectionsPerServer { get; set; }
-        public int MaxResponseHeadersLength { get; set; }
-        public IDictionary<string, object> Properties { get; }
-        public Func<HttpRequestMessage, X509Certificate2, X509Chain, SslPolicyErrors, bool> ServerCertificateCustomValidationCallback { get; set; }
-        public SslProtocols SslProtocols { get; set; }
     }
 }
 namespace System.Net.Http.Headers {
-    public class AuthenticationHeaderValue {
+    public class AuthenticationHeaderValue : ICloneable {
     }
-    public class CacheControlHeaderValue {
+    public class CacheControlHeaderValue : ICloneable {
     }
-    public class ContentDispositionHeaderValue {
+    public class ContentDispositionHeaderValue : ICloneable {
     }
-    public class ContentRangeHeaderValue {
+    public class ContentRangeHeaderValue : ICloneable {
     }
-    public class EntityTagHeaderValue {
+    public class EntityTagHeaderValue : ICloneable {
     }
-    public class MediaTypeHeaderValue {
+    public class MediaTypeHeaderValue : ICloneable {
     }
-    public sealed class MediaTypeWithQualityHeaderValue : MediaTypeHeaderValue {
+    public sealed class MediaTypeWithQualityHeaderValue : MediaTypeHeaderValue, ICloneable {
     }
-    public class NameValueHeaderValue {
+    public class NameValueHeaderValue : ICloneable {
     }
-    public class NameValueWithParametersHeaderValue : NameValueHeaderValue {
+    public class NameValueWithParametersHeaderValue : NameValueHeaderValue, ICloneable {
     }
-    public class ProductHeaderValue {
+    public class ProductHeaderValue : ICloneable {
     }
-    public class ProductInfoHeaderValue {
+    public class ProductInfoHeaderValue : ICloneable {
     }
-    public class RangeConditionHeaderValue {
+    public class RangeConditionHeaderValue : ICloneable {
     }
-    public class RangeHeaderValue {
+    public class RangeHeaderValue : ICloneable {
     }
-    public class RangeItemHeaderValue {
+    public class RangeItemHeaderValue : ICloneable {
     }
-    public class RetryConditionHeaderValue {
+    public class RetryConditionHeaderValue : ICloneable {
     }
-    public class StringWithQualityHeaderValue {
+    public class StringWithQualityHeaderValue : ICloneable {
     }
-    public class TransferCodingHeaderValue {
+    public class TransferCodingHeaderValue : ICloneable {
     }
-    public sealed class TransferCodingWithQualityHeaderValue : TransferCodingHeaderValue {
+    public sealed class TransferCodingWithQualityHeaderValue : TransferCodingHeaderValue, ICloneable {
     }
-    public class ViaHeaderValue {
+    public class ViaHeaderValue : ICloneable {
     }
-    public class WarningHeaderValue {
+    public class WarningHeaderValue : ICloneable {
     }
 }
+namespace System.Net.Mail {
+    public class AlternateView : AttachmentBase {
+        public AlternateView(Stream contentStream);
+        public AlternateView(Stream contentStream, ContentType contentType);
+        public AlternateView(Stream contentStream, string mediaType);
+        public AlternateView(string fileName);
+        public AlternateView(string fileName, ContentType contentType);
+        public AlternateView(string fileName, string mediaType);
+        public Uri BaseUri { get; set; }
+        public LinkedResourceCollection LinkedResources { get; }
+        public static AlternateView CreateAlternateViewFromString(string content);
+        public static AlternateView CreateAlternateViewFromString(string content, ContentType contentType);
+        public static AlternateView CreateAlternateViewFromString(string content, Encoding contentEncoding, string mediaType);
+        protected override void Dispose(bool disposing);
+    }
+    public sealed class AlternateViewCollection : Collection<AlternateView>, IDisposable {
+        public void Dispose();
+    }
+    public class Attachment : AttachmentBase {
+        public Attachment(Stream contentStream, ContentType contentType);
+        public Attachment(Stream contentStream, string name);
+        public Attachment(Stream contentStream, string name, string mediaType);
+        public Attachment(string fileName);
+        public Attachment(string fileName, ContentType contentType);
+        public Attachment(string fileName, string mediaType);
+        public ContentDisposition ContentDisposition { get; }
+        public string Name { get; set; }
+        public Encoding NameEncoding { get; set; }
+        public static Attachment CreateAttachmentFromString(string content, ContentType contentType);
+        public static Attachment CreateAttachmentFromString(string content, string name);
+        public static Attachment CreateAttachmentFromString(string content, string name, Encoding contentEncoding, string mediaType);
+    }
+    public abstract class AttachmentBase : IDisposable {
+        protected AttachmentBase(Stream contentStream);
+        protected AttachmentBase(Stream contentStream, ContentType contentType);
+        protected AttachmentBase(Stream contentStream, string mediaType);
+        protected AttachmentBase(string fileName);
+        protected AttachmentBase(string fileName, ContentType contentType);
+        protected AttachmentBase(string fileName, string mediaType);
+        public string ContentId { get; set; }
+        public Stream ContentStream { get; }
+        public ContentType ContentType { get; set; }
+        public TransferEncoding TransferEncoding { get; set; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+    }
+    public sealed class AttachmentCollection : Collection<Attachment>, IDisposable {
+        public void Dispose();
+    }
+    public enum DeliveryNotificationOptions {
+        Delay = 4,
+        Never = 134217728,
+        None = 0,
+        OnFailure = 2,
+        OnSuccess = 1,
+    }
+    public class LinkedResource : AttachmentBase {
+        public LinkedResource(Stream contentStream);
+        public LinkedResource(Stream contentStream, ContentType contentType);
+        public LinkedResource(Stream contentStream, string mediaType);
+        public LinkedResource(string fileName);
+        public LinkedResource(string fileName, ContentType contentType);
+        public LinkedResource(string fileName, string mediaType);
+        public Uri ContentLink { get; set; }
+        public static LinkedResource CreateLinkedResourceFromString(string content);
+        public static LinkedResource CreateLinkedResourceFromString(string content, ContentType contentType);
+        public static LinkedResource CreateLinkedResourceFromString(string content, Encoding contentEncoding, string mediaType);
+    }
+    public sealed class LinkedResourceCollection : Collection<LinkedResource>, IDisposable {
+        public void Dispose();
+    }
+    public class MailAddress {
+        public MailAddress(string address);
+        public MailAddress(string address, string displayName);
+        public MailAddress(string address, string displayName, Encoding displayNameEncoding);
+        public string Address { get; }
+        public string DisplayName { get; }
+        public string Host { get; }
+        public string User { get; }
+        public override bool Equals(object value);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public class MailAddressCollection : Collection<MailAddress> {
+        public MailAddressCollection();
+        public void Add(string addresses);
+        protected override void InsertItem(int index, MailAddress item);
+        protected override void SetItem(int index, MailAddress item);
+        public override string ToString();
+    }
+    public class MailMessage : IDisposable {
+        public MailMessage();
+        public MailMessage(MailAddress from, MailAddress to);
+        public MailMessage(string from, string to);
+        public MailMessage(string from, string to, string subject, string body);
+        public AlternateViewCollection AlternateViews { get; }
+        public AttachmentCollection Attachments { get; }
+        public MailAddressCollection Bcc { get; }
+        public string Body { get; set; }
+        public Encoding BodyEncoding { get; set; }
+        public TransferEncoding BodyTransferEncoding { get; set; }
+        public MailAddressCollection CC { get; }
+        public DeliveryNotificationOptions DeliveryNotificationOptions { get; set; }
+        public MailAddress From { get; set; }
+        public NameValueCollection Headers { get; }
+        public Encoding HeadersEncoding { get; set; }
+        public bool IsBodyHtml { get; set; }
+        public MailPriority Priority { get; set; }
+        public MailAddress ReplyTo { get; set; }
+        public MailAddressCollection ReplyToList { get; }
+        public MailAddress Sender { get; set; }
+        public string Subject { get; set; }
+        public Encoding SubjectEncoding { get; set; }
+        public MailAddressCollection To { get; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+    }
+    public enum MailPriority {
+        High = 2,
+        Low = 1,
+        Normal = 0,
+    }
+    public delegate void SendCompletedEventHandler(object sender, AsyncCompletedEventArgs e); {
+        public SendCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, AsyncCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, AsyncCompletedEventArgs e);
+    }
+    public enum SmtpAccess {
+        Connect = 1,
+        ConnectToUnrestrictedPort = 2,
+        None = 0,
+    }
+    public class SmtpClient : IDisposable {
+        public SmtpClient();
+        public SmtpClient(string host);
+        public SmtpClient(string host, int port);
+        public X509CertificateCollection ClientCertificates { get; }
+        public ICredentialsByHost Credentials { get; set; }
+        public SmtpDeliveryFormat DeliveryFormat { get; set; }
+        public SmtpDeliveryMethod DeliveryMethod { get; set; }
+        public bool EnableSsl { get; set; }
+        public string Host { get; set; }
+        public string PickupDirectoryLocation { get; set; }
+        public int Port { get; set; }
+        public string TargetName { get; set; }
+        public int Timeout { get; set; }
+        public bool UseDefaultCredentials { get; set; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected void OnSendCompleted(AsyncCompletedEventArgs e);
+        public void Send(MailMessage message);
+        public void Send(string from, string recipients, string subject, string body);
+        public void SendAsync(MailMessage message, object userToken);
+        public void SendAsync(string from, string recipients, string subject, string body, object userToken);
+        public void SendAsyncCancel();
+        public Task SendMailAsync(MailMessage message);
+        public Task SendMailAsync(string from, string recipients, string subject, string body);
+        public event SendCompletedEventHandler SendCompleted;
+    }
+    public enum SmtpDeliveryFormat {
+        International = 1,
+        SevenBit = 0,
+    }
+    public enum SmtpDeliveryMethod {
+        Network = 0,
+        PickupDirectoryFromIis = 2,
+        SpecifiedPickupDirectory = 1,
+    }
+    public class SmtpException : Exception, ISerializable {
+        public SmtpException();
+        protected SmtpException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public SmtpException(SmtpStatusCode statusCode);
+        public SmtpException(SmtpStatusCode statusCode, string message);
+        public SmtpException(string message);
+        public SmtpException(string message, Exception innerException);
+        public SmtpStatusCode StatusCode { get; set; }
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+    }
+    public class SmtpFailedRecipientException : SmtpException, ISerializable {
+        public SmtpFailedRecipientException();
+        protected SmtpFailedRecipientException(SerializationInfo info, StreamingContext context);
+        public SmtpFailedRecipientException(SmtpStatusCode statusCode, string failedRecipient);
+        public SmtpFailedRecipientException(SmtpStatusCode statusCode, string failedRecipient, string serverResponse);
+        public SmtpFailedRecipientException(string message);
+        public SmtpFailedRecipientException(string message, Exception innerException);
+        public SmtpFailedRecipientException(string message, string failedRecipient, Exception innerException);
+        public string FailedRecipient { get; }
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+    }
+    public class SmtpFailedRecipientsException : SmtpFailedRecipientException, ISerializable {
+        public SmtpFailedRecipientsException();
+        protected SmtpFailedRecipientsException(SerializationInfo info, StreamingContext context);
+        public SmtpFailedRecipientsException(string message);
+        public SmtpFailedRecipientsException(string message, Exception innerException);
+        public SmtpFailedRecipientsException(string message, SmtpFailedRecipientException[] innerExceptions);
+        public SmtpFailedRecipientException[] InnerExceptions { get; }
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+    }
+    public enum SmtpStatusCode {
+        BadCommandSequence = 503,
+        CannotVerifyUserWillAttemptDelivery = 252,
+        ClientNotPermitted = 454,
+        CommandNotImplemented = 502,
+        CommandParameterNotImplemented = 504,
+        CommandUnrecognized = 500,
+        ExceededStorageAllocation = 552,
+        GeneralFailure = -1,
+        HelpMessage = 214,
+        InsufficientStorage = 452,
+        LocalErrorInProcessing = 451,
+        MailboxBusy = 450,
+        MailboxNameNotAllowed = 553,
+        MailboxUnavailable = 550,
+        MustIssueStartTlsFirst = 530,
+        Ok = 250,
+        ServiceClosingTransmissionChannel = 221,
+        ServiceNotAvailable = 421,
+        ServiceReady = 220,
+        StartMailInput = 354,
+        SyntaxError = 501,
+        SystemStatus = 211,
+        TransactionFailed = 554,
+        UserNotLocalTryAlternatePath = 551,
+        UserNotLocalWillForward = 251,
+    }
+}
+namespace System.Net.Mime {
+    public class ContentDisposition {
+        public ContentDisposition();
+        public ContentDisposition(string disposition);
+        public DateTime CreationDate { get; set; }
+        public string DispositionType { get; set; }
+        public string FileName { get; set; }
+        public bool Inline { get; set; }
+        public DateTime ModificationDate { get; set; }
+        public StringDictionary Parameters { get; }
+        public DateTime ReadDate { get; set; }
+        public long Size { get; set; }
+        public override bool Equals(object rparam);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public class ContentType {
+        public ContentType();
+        public ContentType(string contentType);
+        public string Boundary { get; set; }
+        public string CharSet { get; set; }
+        public string MediaType { get; set; }
+        public string Name { get; set; }
+        public StringDictionary Parameters { get; }
+        public override bool Equals(object rparam);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public static class DispositionTypeNames {
+        public const string Attachment = "attachment";
+        public const string Inline = "inline";
+    }
+    public static class MediaTypeNames {
+        public static class Application {
+            public const string Octet = "application/octet-stream";
+            public const string Pdf = "application/pdf";
+            public const string Rtf = "application/rtf";
+            public const string Soap = "application/soap+xml";
+            public const string Zip = "application/zip";
+        }
+        public static class Image {
+            public const string Gif = "image/gif";
+            public const string Jpeg = "image/jpeg";
+            public const string Tiff = "image/tiff";
+        }
+        public static class Text {
+            public const string Html = "text/html";
+            public const string Plain = "text/plain";
+            public const string RichText = "text/richtext";
+            public const string Xml = "text/xml";
+        }
+    }
+    public enum TransferEncoding {
+        Base64 = 1,
+        EightBit = 3,
+        QuotedPrintable = 0,
+        SevenBit = 2,
+        Unknown = -1,
+    }
+}
 namespace System.Net.NetworkInformation {
+    public enum DuplicateAddressDetectionState {
+        Deprecated = 3,
+        Duplicate = 2,
+        Invalid = 0,
+        Preferred = 4,
+        Tentative = 1,
+    }
+    public abstract class GatewayIPAddressInformation {
+        protected GatewayIPAddressInformation();
+        public abstract IPAddress Address { get; }
+    }
+    public class GatewayIPAddressInformationCollection : ICollection<GatewayIPAddressInformation>, IEnumerable, IEnumerable<GatewayIPAddressInformation> {
+        protected internal GatewayIPAddressInformationCollection();
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual GatewayIPAddressInformation this[int index] { get; }
+        public virtual void Add(GatewayIPAddressInformation address);
+        public virtual void Clear();
+        public virtual bool Contains(GatewayIPAddressInformation address);
+        public virtual void CopyTo(GatewayIPAddressInformation[] array, int offset);
+        public virtual IEnumerator<GatewayIPAddressInformation> GetEnumerator();
+        public virtual bool Remove(GatewayIPAddressInformation address);
+    }
+    public abstract class IcmpV4Statistics {
+        protected IcmpV4Statistics();
+        public abstract long AddressMaskRepliesReceived { get; }
+        public abstract long AddressMaskRepliesSent { get; }
+        public abstract long AddressMaskRequestsReceived { get; }
+        public abstract long AddressMaskRequestsSent { get; }
+        public abstract long DestinationUnreachableMessagesReceived { get; }
+        public abstract long DestinationUnreachableMessagesSent { get; }
+        public abstract long EchoRepliesReceived { get; }
+        public abstract long EchoRepliesSent { get; }
+        public abstract long EchoRequestsReceived { get; }
+        public abstract long EchoRequestsSent { get; }
+        public abstract long ErrorsReceived { get; }
+        public abstract long ErrorsSent { get; }
+        public abstract long MessagesReceived { get; }
+        public abstract long MessagesSent { get; }
+        public abstract long ParameterProblemsReceived { get; }
+        public abstract long ParameterProblemsSent { get; }
+        public abstract long RedirectsReceived { get; }
+        public abstract long RedirectsSent { get; }
+        public abstract long SourceQuenchesReceived { get; }
+        public abstract long SourceQuenchesSent { get; }
+        public abstract long TimeExceededMessagesReceived { get; }
+        public abstract long TimeExceededMessagesSent { get; }
+        public abstract long TimestampRepliesReceived { get; }
+        public abstract long TimestampRepliesSent { get; }
+        public abstract long TimestampRequestsReceived { get; }
+        public abstract long TimestampRequestsSent { get; }
+    }
+    public abstract class IcmpV6Statistics {
+        protected IcmpV6Statistics();
+        public abstract long DestinationUnreachableMessagesReceived { get; }
+        public abstract long DestinationUnreachableMessagesSent { get; }
+        public abstract long EchoRepliesReceived { get; }
+        public abstract long EchoRepliesSent { get; }
+        public abstract long EchoRequestsReceived { get; }
+        public abstract long EchoRequestsSent { get; }
+        public abstract long ErrorsReceived { get; }
+        public abstract long ErrorsSent { get; }
+        public abstract long MembershipQueriesReceived { get; }
+        public abstract long MembershipQueriesSent { get; }
+        public abstract long MembershipReductionsReceived { get; }
+        public abstract long MembershipReductionsSent { get; }
+        public abstract long MembershipReportsReceived { get; }
+        public abstract long MembershipReportsSent { get; }
+        public abstract long MessagesReceived { get; }
+        public abstract long MessagesSent { get; }
+        public abstract long NeighborAdvertisementsReceived { get; }
+        public abstract long NeighborAdvertisementsSent { get; }
+        public abstract long NeighborSolicitsReceived { get; }
+        public abstract long NeighborSolicitsSent { get; }
+        public abstract long PacketTooBigMessagesReceived { get; }
+        public abstract long PacketTooBigMessagesSent { get; }
+        public abstract long ParameterProblemsReceived { get; }
+        public abstract long ParameterProblemsSent { get; }
+        public abstract long RedirectsReceived { get; }
+        public abstract long RedirectsSent { get; }
+        public abstract long RouterAdvertisementsReceived { get; }
+        public abstract long RouterAdvertisementsSent { get; }
+        public abstract long RouterSolicitsReceived { get; }
+        public abstract long RouterSolicitsSent { get; }
+        public abstract long TimeExceededMessagesReceived { get; }
+        public abstract long TimeExceededMessagesSent { get; }
+    }
+    public abstract class IPAddressInformation {
+        protected IPAddressInformation();
+        public abstract IPAddress Address { get; }
+        public abstract bool IsDnsEligible { get; }
+        public abstract bool IsTransient { get; }
+    }
+    public class IPAddressInformationCollection : ICollection<IPAddressInformation>, IEnumerable, IEnumerable<IPAddressInformation> {
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual IPAddressInformation this[int index] { get; }
+        public virtual void Add(IPAddressInformation address);
+        public virtual void Clear();
+        public virtual bool Contains(IPAddressInformation address);
+        public virtual void CopyTo(IPAddressInformation[] array, int offset);
+        public virtual IEnumerator<IPAddressInformation> GetEnumerator();
+        public virtual bool Remove(IPAddressInformation address);
+    }
+    public abstract class IPGlobalProperties {
+        protected IPGlobalProperties();
+        public abstract string DhcpScopeName { get; }
+        public abstract string DomainName { get; }
+        public abstract string HostName { get; }
+        public abstract bool IsWinsProxy { get; }
+        public abstract NetBiosNodeType NodeType { get; }
+        public virtual IAsyncResult BeginGetUnicastAddresses(AsyncCallback callback, object state);
+        public virtual UnicastIPAddressInformationCollection EndGetUnicastAddresses(IAsyncResult asyncResult);
+        public abstract TcpConnectionInformation[] GetActiveTcpConnections();
+        public abstract IPEndPoint[] GetActiveTcpListeners();
+        public abstract IPEndPoint[] GetActiveUdpListeners();
+        public abstract IcmpV4Statistics GetIcmpV4Statistics();
+        public abstract IcmpV6Statistics GetIcmpV6Statistics();
+        public static IPGlobalProperties GetIPGlobalProperties();
+        public abstract IPGlobalStatistics GetIPv4GlobalStatistics();
+        public abstract IPGlobalStatistics GetIPv6GlobalStatistics();
+        public abstract TcpStatistics GetTcpIPv4Statistics();
+        public abstract TcpStatistics GetTcpIPv6Statistics();
+        public abstract UdpStatistics GetUdpIPv4Statistics();
+        public abstract UdpStatistics GetUdpIPv6Statistics();
+        public virtual UnicastIPAddressInformationCollection GetUnicastAddresses();
+        public virtual Task<UnicastIPAddressInformationCollection> GetUnicastAddressesAsync();
+    }
+    public abstract class IPGlobalStatistics {
+        protected IPGlobalStatistics();
+        public abstract int DefaultTtl { get; }
+        public abstract bool ForwardingEnabled { get; }
+        public abstract int NumberOfInterfaces { get; }
+        public abstract int NumberOfIPAddresses { get; }
+        public abstract int NumberOfRoutes { get; }
+        public abstract long OutputPacketRequests { get; }
+        public abstract long OutputPacketRoutingDiscards { get; }
+        public abstract long OutputPacketsDiscarded { get; }
+        public abstract long OutputPacketsWithNoRoute { get; }
+        public abstract long PacketFragmentFailures { get; }
+        public abstract long PacketReassembliesRequired { get; }
+        public abstract long PacketReassemblyFailures { get; }
+        public abstract long PacketReassemblyTimeout { get; }
+        public abstract long PacketsFragmented { get; }
+        public abstract long PacketsReassembled { get; }
+        public abstract long ReceivedPackets { get; }
+        public abstract long ReceivedPacketsDelivered { get; }
+        public abstract long ReceivedPacketsDiscarded { get; }
+        public abstract long ReceivedPacketsForwarded { get; }
+        public abstract long ReceivedPacketsWithAddressErrors { get; }
+        public abstract long ReceivedPacketsWithHeadersErrors { get; }
+        public abstract long ReceivedPacketsWithUnknownProtocol { get; }
+    }
+    public abstract class IPInterfaceProperties {
+        protected IPInterfaceProperties();
+        public abstract IPAddressInformationCollection AnycastAddresses { get; }
+        public abstract IPAddressCollection DhcpServerAddresses { get; }
+        public abstract IPAddressCollection DnsAddresses { get; }
+        public abstract string DnsSuffix { get; }
+        public abstract GatewayIPAddressInformationCollection GatewayAddresses { get; }
+        public abstract bool IsDnsEnabled { get; }
+        public abstract bool IsDynamicDnsEnabled { get; }
+        public abstract MulticastIPAddressInformationCollection MulticastAddresses { get; }
+        public abstract UnicastIPAddressInformationCollection UnicastAddresses { get; }
+        public abstract IPAddressCollection WinsServersAddresses { get; }
+        public abstract IPv4InterfaceProperties GetIPv4Properties();
+        public abstract IPv6InterfaceProperties GetIPv6Properties();
+    }
+    public abstract class IPInterfaceStatistics {
+        protected IPInterfaceStatistics();
+        public abstract long BytesReceived { get; }
+        public abstract long BytesSent { get; }
+        public abstract long IncomingPacketsDiscarded { get; }
+        public abstract long IncomingPacketsWithErrors { get; }
+        public abstract long IncomingUnknownProtocolPackets { get; }
+        public abstract long NonUnicastPacketsReceived { get; }
+        public abstract long NonUnicastPacketsSent { get; }
+        public abstract long OutgoingPacketsDiscarded { get; }
+        public abstract long OutgoingPacketsWithErrors { get; }
+        public abstract long OutputQueueLength { get; }
+        public abstract long UnicastPacketsReceived { get; }
+        public abstract long UnicastPacketsSent { get; }
+    }
+    public enum IPStatus {
+        BadDestination = 11018,
+        BadHeader = 11042,
+        BadOption = 11007,
+        BadRoute = 11012,
+        DestinationHostUnreachable = 11003,
+        DestinationNetworkUnreachable = 11002,
+        DestinationPortUnreachable = 11005,
+        DestinationProhibited = 11004,
+        DestinationProtocolUnreachable = 11004,
+        DestinationScopeMismatch = 11045,
+        DestinationUnreachable = 11040,
+        HardwareError = 11008,
+        IcmpError = 11044,
+        NoResources = 11006,
+        PacketTooBig = 11009,
+        ParameterProblem = 11015,
+        SourceQuench = 11016,
+        Success = 0,
+        TimedOut = 11010,
+        TimeExceeded = 11041,
+        TtlExpired = 11013,
+        TtlReassemblyTimeExceeded = 11014,
+        Unknown = -1,
+        UnrecognizedNextHeader = 11043,
+    }
+    public abstract class IPv4InterfaceProperties {
+        protected IPv4InterfaceProperties();
+        public abstract int Index { get; }
+        public abstract bool IsAutomaticPrivateAddressingActive { get; }
+        public abstract bool IsAutomaticPrivateAddressingEnabled { get; }
+        public abstract bool IsDhcpEnabled { get; }
+        public abstract bool IsForwardingEnabled { get; }
+        public abstract int Mtu { get; }
+        public abstract bool UsesWins { get; }
+    }
+    public abstract class IPv4InterfaceStatistics {
+        protected IPv4InterfaceStatistics();
+        public abstract long BytesReceived { get; }
+        public abstract long BytesSent { get; }
+        public abstract long IncomingPacketsDiscarded { get; }
+        public abstract long IncomingPacketsWithErrors { get; }
+        public abstract long IncomingUnknownProtocolPackets { get; }
+        public abstract long NonUnicastPacketsReceived { get; }
+        public abstract long NonUnicastPacketsSent { get; }
+        public abstract long OutgoingPacketsDiscarded { get; }
+        public abstract long OutgoingPacketsWithErrors { get; }
+        public abstract long OutputQueueLength { get; }
+        public abstract long UnicastPacketsReceived { get; }
+        public abstract long UnicastPacketsSent { get; }
+    }
+    public abstract class IPv6InterfaceProperties {
+        protected IPv6InterfaceProperties();
+        public abstract int Index { get; }
+        public abstract int Mtu { get; }
+        public virtual long GetScopeId(ScopeLevel scopeLevel);
+    }
+    public abstract class MulticastIPAddressInformation : IPAddressInformation {
+        protected MulticastIPAddressInformation();
+        public abstract long AddressPreferredLifetime { get; }
+        public abstract long AddressValidLifetime { get; }
+        public abstract long DhcpLeaseLifetime { get; }
+        public abstract DuplicateAddressDetectionState DuplicateAddressDetectionState { get; }
+        public abstract PrefixOrigin PrefixOrigin { get; }
+        public abstract SuffixOrigin SuffixOrigin { get; }
+    }
+    public class MulticastIPAddressInformationCollection : ICollection<MulticastIPAddressInformation>, IEnumerable, IEnumerable<MulticastIPAddressInformation> {
+        protected internal MulticastIPAddressInformationCollection();
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual MulticastIPAddressInformation this[int index] { get; }
+        public virtual void Add(MulticastIPAddressInformation address);
+        public virtual void Clear();
+        public virtual bool Contains(MulticastIPAddressInformation address);
+        public virtual void CopyTo(MulticastIPAddressInformation[] array, int offset);
+        public virtual IEnumerator<MulticastIPAddressInformation> GetEnumerator();
+        public virtual bool Remove(MulticastIPAddressInformation address);
+    }
+    public enum NetBiosNodeType {
+        Broadcast = 1,
+        Hybrid = 8,
+        Mixed = 4,
+        Peer2Peer = 2,
+        Unknown = 0,
+    }
+    public delegate void NetworkAddressChangedEventHandler(object sender, EventArgs e); {
+        public NetworkAddressChangedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, EventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, EventArgs e);
+    }
+    public delegate void NetworkAvailabilityChangedEventHandler(object sender, NetworkAvailabilityEventArgs e); {
+        public NetworkAvailabilityChangedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, NetworkAvailabilityEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, NetworkAvailabilityEventArgs e);
+    }
+    public class NetworkAvailabilityEventArgs : EventArgs {
+        public bool IsAvailable { get; }
+    }
+    public static class NetworkChange {
+        public static event NetworkAddressChangedEventHandler NetworkAddressChanged;
+        public static event NetworkAvailabilityChangedEventHandler NetworkAvailabilityChanged;
+    }
+    public enum NetworkInformationAccess {
+        None = 0,
+        Ping = 4,
+        Read = 1,
+    }
+    public class NetworkInformationException : Win32Exception {
+        public NetworkInformationException();
+        public NetworkInformationException(int errorCode);
+        protected NetworkInformationException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override int ErrorCode { get; }
+    }
+    public abstract class NetworkInterface {
+        protected NetworkInterface();
+        public virtual string Description { get; }
+        public virtual string Id { get; }
+        public static int IPv6LoopbackInterfaceIndex { get; }
+        public virtual bool IsReceiveOnly { get; }
+        public static int LoopbackInterfaceIndex { get; }
+        public virtual string Name { get; }
+        public virtual NetworkInterfaceType NetworkInterfaceType { get; }
+        public virtual OperationalStatus OperationalStatus { get; }
+        public virtual long Speed { get; }
+        public virtual bool SupportsMulticast { get; }
+        public static NetworkInterface[] GetAllNetworkInterfaces();
+        public virtual IPInterfaceProperties GetIPProperties();
+        public virtual IPInterfaceStatistics GetIPStatistics();
+        public virtual IPv4InterfaceStatistics GetIPv4Statistics();
+        public static bool GetIsNetworkAvailable();
+        public virtual PhysicalAddress GetPhysicalAddress();
+        public virtual bool Supports(NetworkInterfaceComponent networkInterfaceComponent);
+    }
+    public enum NetworkInterfaceComponent {
+        IPv4 = 0,
+        IPv6 = 1,
+    }
+    public enum NetworkInterfaceType {
+        AsymmetricDsl = 94,
+        Atm = 37,
+        BasicIsdn = 20,
+        Ethernet = 6,
+        Ethernet3Megabit = 26,
+        FastEthernetFx = 69,
+        FastEthernetT = 62,
+        Fddi = 15,
+        GenericModem = 48,
+        GigabitEthernet = 117,
+        HighPerformanceSerialBus = 144,
+        IPOverAtm = 114,
+        Isdn = 63,
+        Loopback = 24,
+        MultiRateSymmetricDsl = 143,
+        Ppp = 23,
+        PrimaryIsdn = 21,
+        RateAdaptDsl = 95,
+        Slip = 28,
+        SymmetricDsl = 96,
+        TokenRing = 9,
+        Tunnel = 131,
+        Unknown = 1,
+        VeryHighSpeedDsl = 97,
+        Wireless80211 = 71,
+        Wman = 237,
+        Wwanpp = 243,
+        Wwanpp2 = 244,
+    }
+    public enum OperationalStatus {
+        Dormant = 5,
+        Down = 2,
+        LowerLayerDown = 7,
+        NotPresent = 6,
+        Testing = 3,
+        Unknown = 4,
+        Up = 1,
+    }
+    public class PhysicalAddress {
+        public static readonly PhysicalAddress None;
+        public PhysicalAddress(byte[] address);
+        public override bool Equals(object comparand);
+        public byte[] GetAddressBytes();
+        public override int GetHashCode();
+        public static PhysicalAddress Parse(string address);
+        public override string ToString();
+    }
+    public class Ping : Component {
+        public Ping();
+        protected override void Dispose(bool disposing);
+        protected void OnPingCompleted(PingCompletedEventArgs e);
+        public PingReply Send(IPAddress address);
+        public PingReply Send(IPAddress address, int timeout);
+        public PingReply Send(IPAddress address, int timeout, byte[] buffer);
+        public PingReply Send(IPAddress address, int timeout, byte[] buffer, PingOptions options);
+        public PingReply Send(string hostNameOrAddress);
+        public PingReply Send(string hostNameOrAddress, int timeout);
+        public PingReply Send(string hostNameOrAddress, int timeout, byte[] buffer);
+        public PingReply Send(string hostNameOrAddress, int timeout, byte[] buffer, PingOptions options);
+        public void SendAsync(IPAddress address, int timeout, byte[] buffer, object userToken);
+        public void SendAsync(IPAddress address, int timeout, byte[] buffer, PingOptions options, object userToken);
+        public void SendAsync(IPAddress address, int timeout, object userToken);
+        public void SendAsync(IPAddress address, object userToken);
+        public void SendAsync(string hostNameOrAddress, int timeout, byte[] buffer, object userToken);
+        public void SendAsync(string hostNameOrAddress, int timeout, byte[] buffer, PingOptions options, object userToken);
+        public void SendAsync(string hostNameOrAddress, int timeout, object userToken);
+        public void SendAsync(string hostNameOrAddress, object userToken);
+        public void SendAsyncCancel();
+        public Task<PingReply> SendPingAsync(IPAddress address);
+        public Task<PingReply> SendPingAsync(IPAddress address, int timeout);
+        public Task<PingReply> SendPingAsync(IPAddress address, int timeout, byte[] buffer);
+        public Task<PingReply> SendPingAsync(IPAddress address, int timeout, byte[] buffer, PingOptions options);
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress);
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress, int timeout);
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress, int timeout, byte[] buffer);
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress, int timeout, byte[] buffer, PingOptions options);
+        public event PingCompletedEventHandler PingCompleted;
+    }
+    public class PingCompletedEventArgs : AsyncCompletedEventArgs {
+        public PingReply Reply { get; }
+    }
+    public delegate void PingCompletedEventHandler(object sender, PingCompletedEventArgs e); {
+        public PingCompletedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, PingCompletedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, PingCompletedEventArgs e);
+    }
+    public class PingException : InvalidOperationException {
+        protected PingException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public PingException(string message);
+        public PingException(string message, Exception innerException);
+    }
+    public class PingOptions {
+        public PingOptions();
+        public PingOptions(int ttl, bool dontFragment);
+        public bool DontFragment { get; set; }
+        public int Ttl { get; set; }
+    }
+    public class PingReply {
+        public IPAddress Address { get; }
+        public byte[] Buffer { get; }
+        public PingOptions Options { get; }
+        public long RoundtripTime { get; }
+        public IPStatus Status { get; }
+    }
+    public enum PrefixOrigin {
+        Dhcp = 3,
+        Manual = 1,
+        Other = 0,
+        RouterAdvertisement = 4,
+        WellKnown = 2,
+    }
+    public enum ScopeLevel {
+        Admin = 4,
+        Global = 14,
+        Interface = 1,
+        Link = 2,
+        None = 0,
+        Organization = 8,
+        Site = 5,
+        Subnet = 3,
+    }
+    public enum SuffixOrigin {
+        LinkLayerAddress = 4,
+        Manual = 1,
+        OriginDhcp = 3,
+        Other = 0,
+        Random = 5,
+        WellKnown = 2,
+    }
+    public abstract class TcpConnectionInformation {
+        protected TcpConnectionInformation();
+        public abstract IPEndPoint LocalEndPoint { get; }
+        public abstract IPEndPoint RemoteEndPoint { get; }
+        public abstract TcpState State { get; }
+    }
+    public enum TcpState {
+        Closed = 1,
+        CloseWait = 8,
+        Closing = 9,
+        DeleteTcb = 12,
+        Established = 5,
+        FinWait1 = 6,
+        FinWait2 = 7,
+        LastAck = 10,
+        Listen = 2,
+        SynReceived = 4,
+        SynSent = 3,
+        TimeWait = 11,
+        Unknown = 0,
+    }
+    public abstract class TcpStatistics {
+        protected TcpStatistics();
+        public abstract long ConnectionsAccepted { get; }
+        public abstract long ConnectionsInitiated { get; }
+        public abstract long CumulativeConnections { get; }
+        public abstract long CurrentConnections { get; }
+        public abstract long ErrorsReceived { get; }
+        public abstract long FailedConnectionAttempts { get; }
+        public abstract long MaximumConnections { get; }
+        public abstract long MaximumTransmissionTimeout { get; }
+        public abstract long MinimumTransmissionTimeout { get; }
+        public abstract long ResetConnections { get; }
+        public abstract long ResetsSent { get; }
+        public abstract long SegmentsReceived { get; }
+        public abstract long SegmentsResent { get; }
+        public abstract long SegmentsSent { get; }
+    }
+    public abstract class UdpStatistics {
+        protected UdpStatistics();
+        public abstract long DatagramsReceived { get; }
+        public abstract long DatagramsSent { get; }
+        public abstract long IncomingDatagramsDiscarded { get; }
+        public abstract long IncomingDatagramsWithErrors { get; }
+        public abstract int UdpListeners { get; }
+    }
+    public abstract class UnicastIPAddressInformation : IPAddressInformation {
+        protected UnicastIPAddressInformation();
+        public abstract long AddressPreferredLifetime { get; }
+        public abstract long AddressValidLifetime { get; }
+        public abstract long DhcpLeaseLifetime { get; }
+        public abstract DuplicateAddressDetectionState DuplicateAddressDetectionState { get; }
+        public abstract IPAddress IPv4Mask { get; }
+        public virtual int PrefixLength { get; }
+        public abstract PrefixOrigin PrefixOrigin { get; }
+        public abstract SuffixOrigin SuffixOrigin { get; }
+    }
+    public class UnicastIPAddressInformationCollection : ICollection<UnicastIPAddressInformation>, IEnumerable, IEnumerable<UnicastIPAddressInformation> {
+        protected internal UnicastIPAddressInformationCollection();
+        public virtual int Count { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual UnicastIPAddressInformation this[int index] { get; }
+        public virtual void Add(UnicastIPAddressInformation address);
+        public virtual void Clear();
+        public virtual bool Contains(UnicastIPAddressInformation address);
+        public virtual void CopyTo(UnicastIPAddressInformation[] array, int offset);
+        public virtual IEnumerator<UnicastIPAddressInformation> GetEnumerator();
+        public virtual bool Remove(UnicastIPAddressInformation address);
+    }
 }
 namespace System.Net.Security {
+    public abstract class AuthenticatedStream : Stream {
+        protected AuthenticatedStream(Stream innerStream, bool leaveInnerStreamOpen);
+        protected Stream InnerStream { get; }
+        public abstract bool IsAuthenticated { get; }
+        public abstract bool IsEncrypted { get; }
+        public abstract bool IsMutuallyAuthenticated { get; }
+        public abstract bool IsServer { get; }
+        public abstract bool IsSigned { get; }
+        public bool LeaveInnerStreamOpen { get; }
+        protected override void Dispose(bool disposing);
+    }
+    public enum EncryptionPolicy {
+        AllowNoEncryption = 1,
+        NoEncryption = 2,
+        RequireEncryption = 0,
+    }
+    public delegate X509Certificate LocalCertificateSelectionCallback(object sender, string targetHost, X509CertificateCollection localCertificates, X509Certificate remoteCertificate, string[] acceptableIssuers); {
+        public LocalCertificateSelectionCallback(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, string targetHost, X509CertificateCollection localCertificates, X509Certificate remoteCertificate, string[] acceptableIssuers, AsyncCallback callback, object @object);
+        public virtual X509Certificate EndInvoke(IAsyncResult result);
+        public virtual X509Certificate Invoke(object sender, string targetHost, X509CertificateCollection localCertificates, X509Certificate remoteCertificate, string[] acceptableIssuers);
+    }
+    public class NegotiateStream : AuthenticatedStream {
+        public NegotiateStream(Stream innerStream);
+        public NegotiateStream(Stream innerStream, bool leaveInnerStreamOpen);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanTimeout { get; }
+        public override bool CanWrite { get; }
+        public virtual TokenImpersonationLevel ImpersonationLevel { get; }
+        public override bool IsAuthenticated { get; }
+        public override bool IsEncrypted { get; }
+        public override bool IsMutuallyAuthenticated { get; }
+        public override bool IsServer { get; }
+        public override bool IsSigned { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public override int ReadTimeout { get; set; }
+        public virtual IIdentity RemoteIdentity { get; }
+        public override int WriteTimeout { get; set; }
+        public virtual void AuthenticateAsClient();
+        public virtual void AuthenticateAsClient(NetworkCredential credential, ChannelBinding binding, string targetName);
+        public virtual void AuthenticateAsClient(NetworkCredential credential, ChannelBinding binding, string targetName, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel allowedImpersonationLevel);
+        public virtual void AuthenticateAsClient(NetworkCredential credential, string targetName);
+        public virtual void AuthenticateAsClient(NetworkCredential credential, string targetName, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel allowedImpersonationLevel);
+        public virtual Task AuthenticateAsClientAsync();
+        public virtual Task AuthenticateAsClientAsync(NetworkCredential credential, ChannelBinding binding, string targetName);
+        public virtual Task AuthenticateAsClientAsync(NetworkCredential credential, ChannelBinding binding, string targetName, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel allowedImpersonationLevel);
+        public virtual Task AuthenticateAsClientAsync(NetworkCredential credential, string targetName);
+        public virtual Task AuthenticateAsClientAsync(NetworkCredential credential, string targetName, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel allowedImpersonationLevel);
+        public virtual void AuthenticateAsServer();
+        public virtual void AuthenticateAsServer(ExtendedProtectionPolicy policy);
+        public virtual void AuthenticateAsServer(NetworkCredential credential, ExtendedProtectionPolicy policy, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel requiredImpersonationLevel);
+        public virtual void AuthenticateAsServer(NetworkCredential credential, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel requiredImpersonationLevel);
+        public virtual Task AuthenticateAsServerAsync();
+        public virtual Task AuthenticateAsServerAsync(ExtendedProtectionPolicy policy);
+        public virtual Task AuthenticateAsServerAsync(NetworkCredential credential, ExtendedProtectionPolicy policy, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel requiredImpersonationLevel);
+        public virtual Task AuthenticateAsServerAsync(NetworkCredential credential, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel requiredImpersonationLevel);
+        public virtual IAsyncResult BeginAuthenticateAsClient(AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsClient(NetworkCredential credential, ChannelBinding binding, string targetName, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsClient(NetworkCredential credential, ChannelBinding binding, string targetName, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel allowedImpersonationLevel, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsClient(NetworkCredential credential, string targetName, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsClient(NetworkCredential credential, string targetName, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel allowedImpersonationLevel, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsServer(AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsServer(ExtendedProtectionPolicy policy, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsServer(NetworkCredential credential, ExtendedProtectionPolicy policy, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel requiredImpersonationLevel, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsServer(NetworkCredential credential, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel requiredImpersonationLevel, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        protected override void Dispose(bool disposing);
+        public virtual void EndAuthenticateAsClient(IAsyncResult asyncResult);
+        public virtual void EndAuthenticateAsServer(IAsyncResult asyncResult);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        public override int Read(byte[] buffer, int offset, int count);
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+    }
+    public enum ProtectionLevel {
+        EncryptAndSign = 2,
+        None = 0,
+        Sign = 1,
+    }
+    public delegate bool RemoteCertificateValidationCallback(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors); {
+        public RemoteCertificateValidationCallback(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors, AsyncCallback callback, object @object);
+        public virtual bool EndInvoke(IAsyncResult result);
+        public virtual bool Invoke(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors);
+    }
+    public class SslStream : AuthenticatedStream {
+        public SslStream(Stream innerStream);
+        public SslStream(Stream innerStream, bool leaveInnerStreamOpen);
+        public SslStream(Stream innerStream, bool leaveInnerStreamOpen, RemoteCertificateValidationCallback userCertificateValidationCallback);
+        public SslStream(Stream innerStream, bool leaveInnerStreamOpen, RemoteCertificateValidationCallback userCertificateValidationCallback, LocalCertificateSelectionCallback userCertificateSelectionCallback);
+        public SslStream(Stream innerStream, bool leaveInnerStreamOpen, RemoteCertificateValidationCallback userCertificateValidationCallback, LocalCertificateSelectionCallback userCertificateSelectionCallback, EncryptionPolicy encryptionPolicy);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanTimeout { get; }
+        public override bool CanWrite { get; }
+        public virtual bool CheckCertRevocationStatus { get; }
+        public virtual CipherAlgorithmType CipherAlgorithm { get; }
+        public virtual int CipherStrength { get; }
+        public virtual HashAlgorithmType HashAlgorithm { get; }
+        public virtual int HashStrength { get; }
+        public override bool IsAuthenticated { get; }
+        public override bool IsEncrypted { get; }
+        public override bool IsMutuallyAuthenticated { get; }
+        public override bool IsServer { get; }
+        public override bool IsSigned { get; }
+        public virtual ExchangeAlgorithmType KeyExchangeAlgorithm { get; }
+        public virtual int KeyExchangeStrength { get; }
+        public override long Length { get; }
+        public virtual X509Certificate LocalCertificate { get; }
+        public override long Position { get; set; }
+        public override int ReadTimeout { get; set; }
+        public virtual X509Certificate RemoteCertificate { get; }
+        public virtual SslProtocols SslProtocol { get; }
+        public TransportContext TransportContext { get; }
+        public override int WriteTimeout { get; set; }
+        public virtual void AuthenticateAsClient(string targetHost);
+        public virtual void AuthenticateAsClient(string targetHost, X509CertificateCollection clientCertificates, SslProtocols enabledSslProtocols, bool checkCertificateRevocation);
+        public virtual Task AuthenticateAsClientAsync(string targetHost);
+        public virtual Task AuthenticateAsClientAsync(string targetHost, X509CertificateCollection clientCertificates, SslProtocols enabledSslProtocols, bool checkCertificateRevocation);
+        public virtual void AuthenticateAsServer(X509Certificate serverCertificate);
+        public virtual void AuthenticateAsServer(X509Certificate serverCertificate, bool clientCertificateRequired, SslProtocols enabledSslProtocols, bool checkCertificateRevocation);
+        public virtual Task AuthenticateAsServerAsync(X509Certificate serverCertificate);
+        public virtual Task AuthenticateAsServerAsync(X509Certificate serverCertificate, bool clientCertificateRequired, SslProtocols enabledSslProtocols, bool checkCertificateRevocation);
+        public virtual IAsyncResult BeginAuthenticateAsClient(string targetHost, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsClient(string targetHost, X509CertificateCollection clientCertificates, SslProtocols enabledSslProtocols, bool checkCertificateRevocation, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsServer(X509Certificate serverCertificate, AsyncCallback asyncCallback, object asyncState);
+        public virtual IAsyncResult BeginAuthenticateAsServer(X509Certificate serverCertificate, bool clientCertificateRequired, SslProtocols enabledSslProtocols, bool checkCertificateRevocation, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        protected override void Dispose(bool disposing);
+        public virtual void EndAuthenticateAsClient(IAsyncResult asyncResult);
+        public virtual void EndAuthenticateAsServer(IAsyncResult asyncResult);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        public override int Read(byte[] buffer, int offset, int count);
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public void Write(byte[] buffer);
+        public override void Write(byte[] buffer, int offset, int count);
+    }
 }
 namespace System.Net.Sockets {
     public enum AddressFamily {
+        Max = 29,
     }
     public class NetworkStream : Stream {
+        public NetworkStream(Socket socket, FileAccess access);
+        public NetworkStream(Socket socket, FileAccess access, bool ownsSocket);
+        protected bool Readable { get; set; }
+        protected Socket Socket { get; }
+        protected bool Writeable { get; set; }
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int size, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int size, AsyncCallback callback, object state);
+        public void Close(int timeout);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
-        public override Task<int> ReadAsync(byte[] buffer, int offset, int size, CancellationToken cancellationToken);
-        public override Task WriteAsync(byte[] buffer, int offset, int size, CancellationToken cancellationToken);
     }
+    public enum ProtocolFamily {
+        AppleTalk = 16,
+        Atm = 22,
+        Banyan = 21,
+        Ccitt = 10,
+        Chaos = 5,
+        Cluster = 24,
+        DataKit = 9,
+        DataLink = 13,
+        DecNet = 12,
+        Ecma = 8,
+        FireFox = 19,
+        HyperChannel = 15,
+        Ieee12844 = 25,
+        ImpLink = 3,
+        InterNetwork = 2,
+        InterNetworkV6 = 23,
+        Ipx = 6,
+        Irda = 26,
+        Iso = 7,
+        Lat = 14,
+        Max = 29,
+        NetBios = 17,
+        NetworkDesigners = 28,
+        NS = 6,
+        Osi = 7,
+        Pup = 4,
+        Sna = 11,
+        Unix = 1,
+        Unknown = -1,
+        Unspecified = 0,
+        VoiceView = 18,
+    }
     public class Socket : IDisposable {
+        public Socket(SocketInformation socketInformation);
+        public IntPtr Handle { get; }
+        public static bool SupportsIPv4 { get; }
+        public static bool SupportsIPv6 { get; }
+        public bool UseOnlyOverlappedIO { get; set; }
+        public IAsyncResult BeginAccept(AsyncCallback callback, object state);
+        public IAsyncResult BeginAccept(int receiveSize, AsyncCallback callback, object state);
+        public IAsyncResult BeginAccept(Socket acceptSocket, int receiveSize, AsyncCallback callback, object state);
+        public IAsyncResult BeginConnect(EndPoint remoteEP, AsyncCallback callback, object state);
+        public IAsyncResult BeginConnect(IPAddress address, int port, AsyncCallback requestCallback, object state);
+        public IAsyncResult BeginConnect(IPAddress[] addresses, int port, AsyncCallback requestCallback, object state);
+        public IAsyncResult BeginConnect(string host, int port, AsyncCallback requestCallback, object state);
+        public IAsyncResult BeginDisconnect(bool reuseSocket, AsyncCallback callback, object state);
+        public IAsyncResult BeginReceive(byte[] buffer, int offset, int size, SocketFlags socketFlags, AsyncCallback callback, object state);
+        public IAsyncResult BeginReceive(byte[] buffer, int offset, int size, SocketFlags socketFlags, out SocketError errorCode, AsyncCallback callback, object state);
+        public IAsyncResult BeginReceive(IList<ArraySegment<byte>> buffers, SocketFlags socketFlags, AsyncCallback callback, object state);
+        public IAsyncResult BeginReceive(IList<ArraySegment<byte>> buffers, SocketFlags socketFlags, out SocketError errorCode, AsyncCallback callback, object state);
+        public IAsyncResult BeginReceiveFrom(byte[] buffer, int offset, int size, SocketFlags socketFlags, ref EndPoint remoteEP, AsyncCallback callback, object state);
+        public IAsyncResult BeginReceiveMessageFrom(byte[] buffer, int offset, int size, SocketFlags socketFlags, ref EndPoint remoteEP, AsyncCallback callback, object state);
+        public IAsyncResult BeginSend(byte[] buffer, int offset, int size, SocketFlags socketFlags, AsyncCallback callback, object state);
+        public IAsyncResult BeginSend(byte[] buffer, int offset, int size, SocketFlags socketFlags, out SocketError errorCode, AsyncCallback callback, object state);
+        public IAsyncResult BeginSend(IList<ArraySegment<byte>> buffers, SocketFlags socketFlags, AsyncCallback callback, object state);
+        public IAsyncResult BeginSend(IList<ArraySegment<byte>> buffers, SocketFlags socketFlags, out SocketError errorCode, AsyncCallback callback, object state);
+        public IAsyncResult BeginSendFile(string fileName, AsyncCallback callback, object state);
+        public IAsyncResult BeginSendFile(string fileName, byte[] preBuffer, byte[] postBuffer, TransmitFileOptions flags, AsyncCallback callback, object state);
+        public IAsyncResult BeginSendTo(byte[] buffer, int offset, int size, SocketFlags socketFlags, EndPoint remoteEP, AsyncCallback callback, object state);
+        public void Close();
+        public void Close(int timeout);
+        public void Disconnect(bool reuseSocket);
+        public bool DisconnectAsync(SocketAsyncEventArgs e);
+        public SocketInformation DuplicateAndClose(int targetProcessId);
+        public Socket EndAccept(out byte[] buffer, IAsyncResult asyncResult);
+        public Socket EndAccept(out byte[] buffer, out int bytesTransferred, IAsyncResult asyncResult);
+        public Socket EndAccept(IAsyncResult asyncResult);
+        public void EndConnect(IAsyncResult asyncResult);
+        public void EndDisconnect(IAsyncResult asyncResult);
+        public int EndReceive(IAsyncResult asyncResult);
+        public int EndReceive(IAsyncResult asyncResult, out SocketError errorCode);
+        public int EndReceiveFrom(IAsyncResult asyncResult, ref EndPoint endPoint);
+        public int EndReceiveMessageFrom(IAsyncResult asyncResult, ref SocketFlags socketFlags, ref EndPoint endPoint, out IPPacketInformation ipPacketInformation);
+        public int EndSend(IAsyncResult asyncResult);
+        public int EndSend(IAsyncResult asyncResult, out SocketError errorCode);
+        public void EndSendFile(IAsyncResult asyncResult);
+        public int EndSendTo(IAsyncResult asyncResult);
+        public void SendFile(string fileName);
+        public void SendFile(string fileName, byte[] preBuffer, byte[] postBuffer, TransmitFileOptions flags);
+        public void SetIPProtectionLevel(IPProtectionLevel level);
     }
     public class SocketAsyncEventArgs : EventArgs, IDisposable {
+        public bool DisconnectReuseSocket { get; set; }
+        public TransmitFileOptions SendPacketsFlags { get; set; }
     }
-    public class SocketException : Exception {
+    public class SocketException : Win32Exception {
+        protected SocketException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public override int ErrorCode { get; }
     }
     public enum SocketFlags {
+        MaxIOVectorLength = 16,
     }
+    public struct SocketInformation {
+        public SocketInformationOptions Options { get; set; }
+        public byte[] ProtocolInformation { get; set; }
+    }
+    public enum SocketInformationOptions {
+        Connected = 2,
+        Listening = 4,
+        NonBlocking = 1,
+        UseOnlyOverlappedIO = 8,
+    }
-    public struct SocketReceiveFromResult {
-        public int ReceivedBytes;
-        public EndPoint RemoteEndPoint;
-    }
-    public struct SocketReceiveMessageFromResult {
-        public IPPacketInformation PacketInformation;
-        public int ReceivedBytes;
-        public EndPoint RemoteEndPoint;
-        public SocketFlags SocketFlags;
-    }
-    public static class SocketTaskExtensions {
-        public static Task<Socket> AcceptAsync(this Socket socket);
-        public static Task<Socket> AcceptAsync(this Socket socket, Socket acceptSocket);
-        public static Task ConnectAsync(this Socket socket, EndPoint remoteEP);
-        public static Task ConnectAsync(this Socket socket, IPAddress address, int port);
-        public static Task ConnectAsync(this Socket socket, IPAddress[] addresses, int port);
-        public static Task ConnectAsync(this Socket socket, string host, int port);
-        public static Task<int> ReceiveAsync(this Socket socket, ArraySegment<byte> buffer, SocketFlags socketFlags);
-        public static Task<int> ReceiveAsync(this Socket socket, IList<ArraySegment<byte>> buffers, SocketFlags socketFlags);
-        public static Task<SocketReceiveFromResult> ReceiveFromAsync(this Socket socket, ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEndPoint);
-        public static Task<SocketReceiveMessageFromResult> ReceiveMessageFromAsync(this Socket socket, ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEndPoint);
-        public static Task<int> SendAsync(this Socket socket, ArraySegment<byte> buffer, SocketFlags socketFlags);
-        public static Task<int> SendAsync(this Socket socket, IList<ArraySegment<byte>> buffers, SocketFlags socketFlags);
-        public static Task<int> SendToAsync(this Socket socket, ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEP);
-    }
     public class TcpClient : IDisposable {
+        public TcpClient(IPEndPoint localEP);
+        public TcpClient(string hostname, int port);
+        public IAsyncResult BeginConnect(IPAddress address, int port, AsyncCallback requestCallback, object state);
+        public IAsyncResult BeginConnect(IPAddress[] addresses, int port, AsyncCallback requestCallback, object state);
+        public IAsyncResult BeginConnect(string host, int port, AsyncCallback requestCallback, object state);
+        public void Close();
+        public void Connect(IPAddress address, int port);
+        public void Connect(IPAddress[] ipAddresses, int port);
+        public void Connect(IPEndPoint remoteEP);
+        public void Connect(string hostname, int port);
+        public void EndConnect(IAsyncResult asyncResult);
     }
     public class TcpListener {
+        public TcpListener(int port);
+        public Socket AcceptSocket();
+        public TcpClient AcceptTcpClient();
+        public void AllowNatTraversal(bool allowed);
+        public IAsyncResult BeginAcceptSocket(AsyncCallback callback, object state);
+        public IAsyncResult BeginAcceptTcpClient(AsyncCallback callback, object state);
+        public static TcpListener Create(int port);
+        public Socket EndAcceptSocket(IAsyncResult asyncResult);
+        public TcpClient EndAcceptTcpClient(IAsyncResult asyncResult);
     }
+    public enum TransmitFileOptions {
+        Disconnect = 1,
+        ReuseSocket = 2,
+        UseDefaultWorkerThread = 0,
+        UseKernelApc = 32,
+        UseSystemThread = 16,
+        WriteBehind = 4,
+    }
     public class UdpClient : IDisposable {
+        public UdpClient(string hostname, int port);
+        public void AllowNatTraversal(bool allowed);
+        public IAsyncResult BeginReceive(AsyncCallback requestCallback, object state);
+        public IAsyncResult BeginSend(byte[] datagram, int bytes, AsyncCallback requestCallback, object state);
+        public IAsyncResult BeginSend(byte[] datagram, int bytes, IPEndPoint endPoint, AsyncCallback requestCallback, object state);
+        public IAsyncResult BeginSend(byte[] datagram, int bytes, string hostname, int port, AsyncCallback requestCallback, object state);
+        public void Close();
+        public void Connect(IPAddress addr, int port);
+        public void Connect(IPEndPoint endPoint);
+        public void Connect(string hostname, int port);
+        public byte[] EndReceive(IAsyncResult asyncResult, ref IPEndPoint remoteEP);
+        public int EndSend(IAsyncResult asyncResult);
+        public byte[] Receive(ref IPEndPoint remoteEP);
+        public int Send(byte[] dgram, int bytes);
+        public int Send(byte[] dgram, int bytes, IPEndPoint endPoint);
+        public int Send(byte[] dgram, int bytes, string hostname, int port);
+        public Task<int> SendAsync(byte[] datagram, int bytes);
     }
 }
+namespace System.Net.WebSockets {
+    public sealed class ClientWebSocket : WebSocket {
+        public ClientWebSocket();
+        public override Nullable<WebSocketCloseStatus> CloseStatus { get; }
+        public override string CloseStatusDescription { get; }
+        public ClientWebSocketOptions Options { get; }
+        public override WebSocketState State { get; }
+        public override string SubProtocol { get; }
+        public override void Abort();
+        public override Task CloseAsync(WebSocketCloseStatus closeStatus, string statusDescription, CancellationToken cancellationToken);
+        public override Task CloseOutputAsync(WebSocketCloseStatus closeStatus, string statusDescription, CancellationToken cancellationToken);
+        public Task ConnectAsync(Uri uri, CancellationToken cancellationToken);
+        public override void Dispose();
+        public override Task<WebSocketReceiveResult> ReceiveAsync(ArraySegment<byte> buffer, CancellationToken cancellationToken);
+        public override Task SendAsync(ArraySegment<byte> buffer, WebSocketMessageType messageType, bool endOfMessage, CancellationToken cancellationToken);
+    }
+    public sealed class ClientWebSocketOptions {
+        public X509CertificateCollection ClientCertificates { get; set; }
+        public CookieContainer Cookies { get; set; }
+        public ICredentials Credentials { get; set; }
+        public TimeSpan KeepAliveInterval { get; set; }
+        public IWebProxy Proxy { get; set; }
+        public bool UseDefaultCredentials { get; set; }
+        public void AddSubProtocol(string subProtocol);
+        public void SetBuffer(int receiveBufferSize, int sendBufferSize);
+        public void SetBuffer(int receiveBufferSize, int sendBufferSize, ArraySegment<byte> buffer);
+        public void SetRequestHeader(string headerName, string headerValue);
+    }
+    public class HttpListenerWebSocketContext : WebSocketContext {
+        public override CookieCollection CookieCollection { get; }
+        public override NameValueCollection Headers { get; }
+        public override bool IsAuthenticated { get; }
+        public override bool IsLocal { get; }
+        public override bool IsSecureConnection { get; }
+        public override string Origin { get; }
+        public override Uri RequestUri { get; }
+        public override string SecWebSocketKey { get; }
+        public override IEnumerable<string> SecWebSocketProtocols { get; }
+        public override string SecWebSocketVersion { get; }
+        public override IPrincipal User { get; }
+        public override WebSocket WebSocket { get; }
+    }
+    public abstract class WebSocket : IDisposable {
+        protected WebSocket();
+        public abstract Nullable<WebSocketCloseStatus> CloseStatus { get; }
+        public abstract string CloseStatusDescription { get; }
+        public static TimeSpan DefaultKeepAliveInterval { get; }
+        public abstract WebSocketState State { get; }
+        public abstract string SubProtocol { get; }
+        public abstract void Abort();
+        public abstract Task CloseAsync(WebSocketCloseStatus closeStatus, string statusDescription, CancellationToken cancellationToken);
+        public abstract Task CloseOutputAsync(WebSocketCloseStatus closeStatus, string statusDescription, CancellationToken cancellationToken);
+        public static ArraySegment<byte> CreateClientBuffer(int receiveBufferSize, int sendBufferSize);
+        public static WebSocket CreateClientWebSocket(Stream innerStream, string subProtocol, int receiveBufferSize, int sendBufferSize, TimeSpan keepAliveInterval, bool useZeroMaskingKey, ArraySegment<byte> internalBuffer);
+        public static ArraySegment<byte> CreateServerBuffer(int receiveBufferSize);
+        public abstract void Dispose();
+        public static bool IsApplicationTargeting45();
+        protected static bool IsStateTerminal(WebSocketState state);
+        public abstract Task<WebSocketReceiveResult> ReceiveAsync(ArraySegment<byte> buffer, CancellationToken cancellationToken);
+        public static void RegisterPrefixes();
+        public abstract Task SendAsync(ArraySegment<byte> buffer, WebSocketMessageType messageType, bool endOfMessage, CancellationToken cancellationToken);
+        protected static void ThrowOnInvalidState(WebSocketState state, params WebSocketState[] validStates);
+    }
+    public enum WebSocketCloseStatus {
+        Empty = 1005,
+        EndpointUnavailable = 1001,
+        InternalServerError = 1011,
+        InvalidMessageType = 1003,
+        InvalidPayloadData = 1007,
+        MandatoryExtension = 1010,
+        MessageTooBig = 1009,
+        NormalClosure = 1000,
+        PolicyViolation = 1008,
+        ProtocolError = 1002,
+    }
+    public abstract class WebSocketContext {
+        protected WebSocketContext();
+        public abstract CookieCollection CookieCollection { get; }
+        public abstract NameValueCollection Headers { get; }
+        public abstract bool IsAuthenticated { get; }
+        public abstract bool IsLocal { get; }
+        public abstract bool IsSecureConnection { get; }
+        public abstract string Origin { get; }
+        public abstract Uri RequestUri { get; }
+        public abstract string SecWebSocketKey { get; }
+        public abstract IEnumerable<string> SecWebSocketProtocols { get; }
+        public abstract string SecWebSocketVersion { get; }
+        public abstract IPrincipal User { get; }
+        public abstract WebSocket WebSocket { get; }
+    }
+    public enum WebSocketError {
+        ConnectionClosedPrematurely = 8,
+        Faulted = 2,
+        HeaderError = 7,
+        InvalidMessageType = 1,
+        InvalidState = 9,
+        NativeError = 3,
+        NotAWebSocket = 4,
+        Success = 0,
+        UnsupportedProtocol = 6,
+        UnsupportedVersion = 5,
+    }
+    public sealed class WebSocketException : Win32Exception {
+        public WebSocketException();
+        public WebSocketException(int nativeError);
+        public WebSocketException(int nativeError, Exception innerException);
+        public WebSocketException(int nativeError, string message);
+        public WebSocketException(string message);
+        public WebSocketException(string message, Exception innerException);
+        public WebSocketException(WebSocketError error);
+        public WebSocketException(WebSocketError error, Exception innerException);
+        public WebSocketException(WebSocketError error, int nativeError);
+        public WebSocketException(WebSocketError error, int nativeError, Exception innerException);
+        public WebSocketException(WebSocketError error, int nativeError, string message);
+        public WebSocketException(WebSocketError error, int nativeError, string message, Exception innerException);
+        public WebSocketException(WebSocketError error, string message);
+        public WebSocketException(WebSocketError error, string message, Exception innerException);
+        public override int ErrorCode { get; }
+        public WebSocketError WebSocketErrorCode { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public enum WebSocketMessageType {
+        Binary = 1,
+        Close = 2,
+        Text = 0,
+    }
+    public class WebSocketReceiveResult {
+        public WebSocketReceiveResult(int count, WebSocketMessageType messageType, bool endOfMessage);
+        public WebSocketReceiveResult(int count, WebSocketMessageType messageType, bool endOfMessage, Nullable<WebSocketCloseStatus> closeStatus, string closeStatusDescription);
+        public Nullable<WebSocketCloseStatus> CloseStatus { get; }
+        public string CloseStatusDescription { get; }
+        public int Count { get; }
+        public bool EndOfMessage { get; }
+        public WebSocketMessageType MessageType { get; }
+    }
+    public enum WebSocketState {
+        Aborted = 6,
+        Closed = 5,
+        CloseReceived = 4,
+        CloseSent = 3,
+        Connecting = 1,
+        None = 0,
+        Open = 2,
+    }
+}
 namespace System.Numerics {
     public struct BigInteger : IComparable, IComparable<BigInteger>, IEquatable<BigInteger>, IFormattable {
+        public int CompareTo(object obj);
     }
+    public struct Matrix3x2 : IEquatable<Matrix3x2> {
+        public float M11;
+        public float M12;
+        public float M21;
+        public float M22;
+        public float M31;
+        public float M32;
+        public Matrix3x2(float m11, float m12, float m21, float m22, float m31, float m32);
+        public static Matrix3x2 Identity { get; }
+        public bool IsIdentity { get; }
+        public Vector2 Translation { get; set; }
+        public static Matrix3x2 Add(Matrix3x2 value1, Matrix3x2 value2);
+        public static Matrix3x2 CreateRotation(float radians);
+        public static Matrix3x2 CreateRotation(float radians, Vector2 centerPoint);
+        public static Matrix3x2 CreateScale(float scale);
+        public static Matrix3x2 CreateScale(float xScale, float yScale);
+        public static Matrix3x2 CreateScale(float xScale, float yScale, Vector2 centerPoint);
+        public static Matrix3x2 CreateScale(float scale, Vector2 centerPoint);
+        public static Matrix3x2 CreateScale(Vector2 scales);
+        public static Matrix3x2 CreateScale(Vector2 scales, Vector2 centerPoint);
+        public static Matrix3x2 CreateSkew(float radiansX, float radiansY);
+        public static Matrix3x2 CreateSkew(float radiansX, float radiansY, Vector2 centerPoint);
+        public static Matrix3x2 CreateTranslation(float xPosition, float yPosition);
+        public static Matrix3x2 CreateTranslation(Vector2 position);
+        public bool Equals(Matrix3x2 other);
+        public override bool Equals(object obj);
+        public float GetDeterminant();
+        public override int GetHashCode();
+        public static bool Invert(Matrix3x2 matrix, out Matrix3x2 result);
+        public static Matrix3x2 Lerp(Matrix3x2 matrix1, Matrix3x2 matrix2, float amount);
+        public static Matrix3x2 Multiply(Matrix3x2 value1, Matrix3x2 value2);
+        public static Matrix3x2 Multiply(Matrix3x2 value1, float value2);
+        public static Matrix3x2 Negate(Matrix3x2 value);
+        public static Matrix3x2 operator +(Matrix3x2 value1, Matrix3x2 value2);
+        public static bool operator ==(Matrix3x2 value1, Matrix3x2 value2);
+        public static bool operator !=(Matrix3x2 value1, Matrix3x2 value2);
+        public static Matrix3x2 operator *(Matrix3x2 value1, Matrix3x2 value2);
+        public static Matrix3x2 operator *(Matrix3x2 value1, float value2);
+        public static Matrix3x2 operator -(Matrix3x2 value1, Matrix3x2 value2);
+        public static Matrix3x2 operator -(Matrix3x2 value);
+        public static Matrix3x2 Subtract(Matrix3x2 value1, Matrix3x2 value2);
+        public override string ToString();
+    }
+    public struct Matrix4x4 : IEquatable<Matrix4x4> {
+        public float M11;
+        public float M12;
+        public float M13;
+        public float M14;
+        public float M21;
+        public float M22;
+        public float M23;
+        public float M24;
+        public float M31;
+        public float M32;
+        public float M33;
+        public float M34;
+        public float M41;
+        public float M42;
+        public float M43;
+        public float M44;
+        public Matrix4x4(Matrix3x2 value);
+        public Matrix4x4(float m11, float m12, float m13, float m14, float m21, float m22, float m23, float m24, float m31, float m32, float m33, float m34, float m41, float m42, float m43, float m44);
+        public static Matrix4x4 Identity { get; }
+        public bool IsIdentity { get; }
+        public Vector3 Translation { get; set; }
+        public static Matrix4x4 Add(Matrix4x4 value1, Matrix4x4 value2);
+        public static Matrix4x4 CreateBillboard(Vector3 objectPosition, Vector3 cameraPosition, Vector3 cameraUpVector, Vector3 cameraForwardVector);
+        public static Matrix4x4 CreateConstrainedBillboard(Vector3 objectPosition, Vector3 cameraPosition, Vector3 rotateAxis, Vector3 cameraForwardVector, Vector3 objectForwardVector);
+        public static Matrix4x4 CreateFromAxisAngle(Vector3 axis, float angle);
+        public static Matrix4x4 CreateFromQuaternion(Quaternion quaternion);
+        public static Matrix4x4 CreateFromYawPitchRoll(float yaw, float pitch, float roll);
+        public static Matrix4x4 CreateLookAt(Vector3 cameraPosition, Vector3 cameraTarget, Vector3 cameraUpVector);
+        public static Matrix4x4 CreateOrthographic(float width, float height, float zNearPlane, float zFarPlane);
+        public static Matrix4x4 CreateOrthographicOffCenter(float left, float right, float bottom, float top, float zNearPlane, float zFarPlane);
+        public static Matrix4x4 CreatePerspective(float width, float height, float nearPlaneDistance, float farPlaneDistance);
+        public static Matrix4x4 CreatePerspectiveFieldOfView(float fieldOfView, float aspectRatio, float nearPlaneDistance, float farPlaneDistance);
+        public static Matrix4x4 CreatePerspectiveOffCenter(float left, float right, float bottom, float top, float nearPlaneDistance, float farPlaneDistance);
+        public static Matrix4x4 CreateReflection(Plane value);
+        public static Matrix4x4 CreateRotationX(float radians);
+        public static Matrix4x4 CreateRotationX(float radians, Vector3 centerPoint);
+        public static Matrix4x4 CreateRotationY(float radians);
+        public static Matrix4x4 CreateRotationY(float radians, Vector3 centerPoint);
+        public static Matrix4x4 CreateRotationZ(float radians);
+        public static Matrix4x4 CreateRotationZ(float radians, Vector3 centerPoint);
+        public static Matrix4x4 CreateScale(float scale);
+        public static Matrix4x4 CreateScale(float xScale, float yScale, float zScale);
+        public static Matrix4x4 CreateScale(float xScale, float yScale, float zScale, Vector3 centerPoint);
+        public static Matrix4x4 CreateScale(float scale, Vector3 centerPoint);
+        public static Matrix4x4 CreateScale(Vector3 scales);
+        public static Matrix4x4 CreateScale(Vector3 scales, Vector3 centerPoint);
+        public static Matrix4x4 CreateShadow(Vector3 lightDirection, Plane plane);
+        public static Matrix4x4 CreateTranslation(float xPosition, float yPosition, float zPosition);
+        public static Matrix4x4 CreateTranslation(Vector3 position);
+        public static Matrix4x4 CreateWorld(Vector3 position, Vector3 forward, Vector3 up);
+        public static bool Decompose(Matrix4x4 matrix, out Vector3 scale, out Quaternion rotation, out Vector3 translation);
+        public bool Equals(Matrix4x4 other);
+        public override bool Equals(object obj);
+        public float GetDeterminant();
+        public override int GetHashCode();
+        public static bool Invert(Matrix4x4 matrix, out Matrix4x4 result);
+        public static Matrix4x4 Lerp(Matrix4x4 matrix1, Matrix4x4 matrix2, float amount);
+        public static Matrix4x4 Multiply(Matrix4x4 value1, Matrix4x4 value2);
+        public static Matrix4x4 Multiply(Matrix4x4 value1, float value2);
+        public static Matrix4x4 Negate(Matrix4x4 value);
+        public static Matrix4x4 operator +(Matrix4x4 value1, Matrix4x4 value2);
+        public static bool operator ==(Matrix4x4 value1, Matrix4x4 value2);
+        public static bool operator !=(Matrix4x4 value1, Matrix4x4 value2);
+        public static Matrix4x4 operator *(Matrix4x4 value1, Matrix4x4 value2);
+        public static Matrix4x4 operator *(Matrix4x4 value1, float value2);
+        public static Matrix4x4 operator -(Matrix4x4 value1, Matrix4x4 value2);
+        public static Matrix4x4 operator -(Matrix4x4 value);
+        public static Matrix4x4 Subtract(Matrix4x4 value1, Matrix4x4 value2);
+        public override string ToString();
+        public static Matrix4x4 Transform(Matrix4x4 value, Quaternion rotation);
+        public static Matrix4x4 Transpose(Matrix4x4 matrix);
+    }
+    public struct Plane : IEquatable<Plane> {
+        public float D;
+        public Vector3 Normal;
+        public Plane(float x, float y, float z, float d);
+        public Plane(Vector3 normal, float d);
+        public Plane(Vector4 value);
+        public static Plane CreateFromVertices(Vector3 point1, Vector3 point2, Vector3 point3);
+        public static float Dot(Plane plane, Vector4 value);
+        public static float DotCoordinate(Plane plane, Vector3 value);
+        public static float DotNormal(Plane plane, Vector3 value);
+        public override bool Equals(object obj);
+        public bool Equals(Plane other);
+        public override int GetHashCode();
+        public static Plane Normalize(Plane value);
+        public static bool operator ==(Plane value1, Plane value2);
+        public static bool operator !=(Plane value1, Plane value2);
+        public override string ToString();
+        public static Plane Transform(Plane plane, Matrix4x4 matrix);
+        public static Plane Transform(Plane plane, Quaternion rotation);
+    }
+    public struct Quaternion : IEquatable<Quaternion> {
+        public float W;
+        public float X;
+        public float Y;
+        public float Z;
+        public Quaternion(float x, float y, float z, float w);
+        public Quaternion(Vector3 vectorPart, float scalarPart);
+        public static Quaternion Identity { get; }
+        public bool IsIdentity { get; }
+        public static Quaternion Add(Quaternion value1, Quaternion value2);
+        public static Quaternion Concatenate(Quaternion value1, Quaternion value2);
+        public static Quaternion Conjugate(Quaternion value);
+        public static Quaternion CreateFromAxisAngle(Vector3 axis, float angle);
+        public static Quaternion CreateFromRotationMatrix(Matrix4x4 matrix);
+        public static Quaternion CreateFromYawPitchRoll(float yaw, float pitch, float roll);
+        public static Quaternion Divide(Quaternion value1, Quaternion value2);
+        public static float Dot(Quaternion quaternion1, Quaternion quaternion2);
+        public override bool Equals(object obj);
+        public bool Equals(Quaternion other);
+        public override int GetHashCode();
+        public static Quaternion Inverse(Quaternion value);
+        public float Length();
+        public float LengthSquared();
+        public static Quaternion Lerp(Quaternion quaternion1, Quaternion quaternion2, float amount);
+        public static Quaternion Multiply(Quaternion value1, Quaternion value2);
+        public static Quaternion Multiply(Quaternion value1, float value2);
+        public static Quaternion Negate(Quaternion value);
+        public static Quaternion Normalize(Quaternion value);
+        public static Quaternion operator +(Quaternion value1, Quaternion value2);
+        public static Quaternion operator /(Quaternion value1, Quaternion value2);
+        public static bool operator ==(Quaternion value1, Quaternion value2);
+        public static bool operator !=(Quaternion value1, Quaternion value2);
+        public static Quaternion operator *(Quaternion value1, Quaternion value2);
+        public static Quaternion operator *(Quaternion value1, float value2);
+        public static Quaternion operator -(Quaternion value1, Quaternion value2);
+        public static Quaternion operator -(Quaternion value);
+        public static Quaternion Slerp(Quaternion quaternion1, Quaternion quaternion2, float amount);
+        public static Quaternion Subtract(Quaternion value1, Quaternion value2);
+        public override string ToString();
+    }
+    public struct Vector2 : IEquatable<Vector2>, IFormattable {
+        public float X;
+        public float Y;
+        public Vector2(float value);
+        public Vector2(float x, float y);
+        public static Vector2 One { get; }
+        public static Vector2 UnitX { get; }
+        public static Vector2 UnitY { get; }
+        public static Vector2 Zero { get; }
+        public static Vector2 Abs(Vector2 value);
+        public static Vector2 Add(Vector2 left, Vector2 right);
+        public static Vector2 Clamp(Vector2 value1, Vector2 min, Vector2 max);
+        public void CopyTo(float[] array);
+        public void CopyTo(float[] array, int index);
+        public static float Distance(Vector2 value1, Vector2 value2);
+        public static float DistanceSquared(Vector2 value1, Vector2 value2);
+        public static Vector2 Divide(Vector2 left, float divisor);
+        public static Vector2 Divide(Vector2 left, Vector2 right);
+        public static float Dot(Vector2 value1, Vector2 value2);
+        public override bool Equals(object obj);
+        public bool Equals(Vector2 other);
+        public override int GetHashCode();
+        public float Length();
+        public float LengthSquared();
+        public static Vector2 Lerp(Vector2 value1, Vector2 value2, float amount);
+        public static Vector2 Max(Vector2 value1, Vector2 value2);
+        public static Vector2 Min(Vector2 value1, Vector2 value2);
+        public static Vector2 Multiply(float left, Vector2 right);
+        public static Vector2 Multiply(Vector2 left, float right);
+        public static Vector2 Multiply(Vector2 left, Vector2 right);
+        public static Vector2 Negate(Vector2 value);
+        public static Vector2 Normalize(Vector2 value);
+        public static Vector2 operator +(Vector2 left, Vector2 right);
+        public static Vector2 operator /(Vector2 value1, float value2);
+        public static Vector2 operator /(Vector2 left, Vector2 right);
+        public static bool operator ==(Vector2 left, Vector2 right);
+        public static bool operator !=(Vector2 left, Vector2 right);
+        public static Vector2 operator *(float left, Vector2 right);
+        public static Vector2 operator *(Vector2 left, float right);
+        public static Vector2 operator *(Vector2 left, Vector2 right);
+        public static Vector2 operator -(Vector2 left, Vector2 right);
+        public static Vector2 operator -(Vector2 value);
+        public static Vector2 Reflect(Vector2 vector, Vector2 normal);
+        public static Vector2 SquareRoot(Vector2 value);
+        public static Vector2 Subtract(Vector2 left, Vector2 right);
+        public override string ToString();
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider formatProvider);
+        public static Vector2 Transform(Vector2 position, Matrix3x2 matrix);
+        public static Vector2 Transform(Vector2 position, Matrix4x4 matrix);
+        public static Vector2 Transform(Vector2 value, Quaternion rotation);
+        public static Vector2 TransformNormal(Vector2 normal, Matrix3x2 matrix);
+        public static Vector2 TransformNormal(Vector2 normal, Matrix4x4 matrix);
+    }
+    public struct Vector3 : IEquatable<Vector3>, IFormattable {
+        public float X;
+        public float Y;
+        public float Z;
+        public Vector3(float value);
+        public Vector3(float x, float y, float z);
+        public Vector3(Vector2 value, float z);
+        public static Vector3 One { get; }
+        public static Vector3 UnitX { get; }
+        public static Vector3 UnitY { get; }
+        public static Vector3 UnitZ { get; }
+        public static Vector3 Zero { get; }
+        public static Vector3 Abs(Vector3 value);
+        public static Vector3 Add(Vector3 left, Vector3 right);
+        public static Vector3 Clamp(Vector3 value1, Vector3 min, Vector3 max);
+        public void CopyTo(float[] array);
+        public void CopyTo(float[] array, int index);
+        public static Vector3 Cross(Vector3 vector1, Vector3 vector2);
+        public static float Distance(Vector3 value1, Vector3 value2);
+        public static float DistanceSquared(Vector3 value1, Vector3 value2);
+        public static Vector3 Divide(Vector3 left, float divisor);
+        public static Vector3 Divide(Vector3 left, Vector3 right);
+        public static float Dot(Vector3 vector1, Vector3 vector2);
+        public override bool Equals(object obj);
+        public bool Equals(Vector3 other);
+        public override int GetHashCode();
+        public float Length();
+        public float LengthSquared();
+        public static Vector3 Lerp(Vector3 value1, Vector3 value2, float amount);
+        public static Vector3 Max(Vector3 value1, Vector3 value2);
+        public static Vector3 Min(Vector3 value1, Vector3 value2);
+        public static Vector3 Multiply(float left, Vector3 right);
+        public static Vector3 Multiply(Vector3 left, float right);
+        public static Vector3 Multiply(Vector3 left, Vector3 right);
+        public static Vector3 Negate(Vector3 value);
+        public static Vector3 Normalize(Vector3 value);
+        public static Vector3 operator +(Vector3 left, Vector3 right);
+        public static Vector3 operator /(Vector3 value1, float value2);
+        public static Vector3 operator /(Vector3 left, Vector3 right);
+        public static bool operator ==(Vector3 left, Vector3 right);
+        public static bool operator !=(Vector3 left, Vector3 right);
+        public static Vector3 operator *(float left, Vector3 right);
+        public static Vector3 operator *(Vector3 left, float right);
+        public static Vector3 operator *(Vector3 left, Vector3 right);
+        public static Vector3 operator -(Vector3 left, Vector3 right);
+        public static Vector3 operator -(Vector3 value);
+        public static Vector3 Reflect(Vector3 vector, Vector3 normal);
+        public static Vector3 SquareRoot(Vector3 value);
+        public static Vector3 Subtract(Vector3 left, Vector3 right);
+        public override string ToString();
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider formatProvider);
+        public static Vector3 Transform(Vector3 position, Matrix4x4 matrix);
+        public static Vector3 Transform(Vector3 value, Quaternion rotation);
+        public static Vector3 TransformNormal(Vector3 normal, Matrix4x4 matrix);
+    }
+    public struct Vector4 : IEquatable<Vector4>, IFormattable {
+        public float W;
+        public float X;
+        public float Y;
+        public float Z;
+        public Vector4(float value);
+        public Vector4(float x, float y, float z, float w);
+        public Vector4(Vector2 value, float z, float w);
+        public Vector4(Vector3 value, float w);
+        public static Vector4 One { get; }
+        public static Vector4 UnitW { get; }
+        public static Vector4 UnitX { get; }
+        public static Vector4 UnitY { get; }
+        public static Vector4 UnitZ { get; }
+        public static Vector4 Zero { get; }
+        public static Vector4 Abs(Vector4 value);
+        public static Vector4 Add(Vector4 left, Vector4 right);
+        public static Vector4 Clamp(Vector4 value1, Vector4 min, Vector4 max);
+        public void CopyTo(float[] array);
+        public void CopyTo(float[] array, int index);
+        public static float Distance(Vector4 value1, Vector4 value2);
+        public static float DistanceSquared(Vector4 value1, Vector4 value2);
+        public static Vector4 Divide(Vector4 left, float divisor);
+        public static Vector4 Divide(Vector4 left, Vector4 right);
+        public static float Dot(Vector4 vector1, Vector4 vector2);
+        public override bool Equals(object obj);
+        public bool Equals(Vector4 other);
+        public override int GetHashCode();
+        public float Length();
+        public float LengthSquared();
+        public static Vector4 Lerp(Vector4 value1, Vector4 value2, float amount);
+        public static Vector4 Max(Vector4 value1, Vector4 value2);
+        public static Vector4 Min(Vector4 value1, Vector4 value2);
+        public static Vector4 Multiply(float left, Vector4 right);
+        public static Vector4 Multiply(Vector4 left, float right);
+        public static Vector4 Multiply(Vector4 left, Vector4 right);
+        public static Vector4 Negate(Vector4 value);
+        public static Vector4 Normalize(Vector4 vector);
+        public static Vector4 operator +(Vector4 left, Vector4 right);
+        public static Vector4 operator /(Vector4 value1, float value2);
+        public static Vector4 operator /(Vector4 left, Vector4 right);
+        public static bool operator ==(Vector4 left, Vector4 right);
+        public static bool operator !=(Vector4 left, Vector4 right);
+        public static Vector4 operator *(float left, Vector4 right);
+        public static Vector4 operator *(Vector4 left, float right);
+        public static Vector4 operator *(Vector4 left, Vector4 right);
+        public static Vector4 operator -(Vector4 left, Vector4 right);
+        public static Vector4 operator -(Vector4 value);
+        public static Vector4 SquareRoot(Vector4 value);
+        public static Vector4 Subtract(Vector4 left, Vector4 right);
+        public override string ToString();
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider formatProvider);
+        public static Vector4 Transform(Vector2 position, Matrix4x4 matrix);
+        public static Vector4 Transform(Vector2 value, Quaternion rotation);
+        public static Vector4 Transform(Vector3 position, Matrix4x4 matrix);
+        public static Vector4 Transform(Vector3 value, Quaternion rotation);
+        public static Vector4 Transform(Vector4 vector, Matrix4x4 matrix);
+        public static Vector4 Transform(Vector4 value, Quaternion rotation);
+    }
 }
 namespace System.Reflection {
-    public sealed class AmbiguousMatchException : Exception {
+    public sealed class AmbiguousMatchException : SystemException {
     }
-    public abstract class Assembly : ICustomAttributeProvider {
+    public abstract class Assembly : ICustomAttributeProvider, ISerializable {
+        protected Assembly();
-        public abstract IEnumerable<TypeInfo> DefinedTypes { get; }
+        public virtual IEnumerable<TypeInfo> DefinedTypes { get; }
+        public virtual string EscapedCodeBase { get; }
+        public virtual bool GlobalAssemblyCache { get; }
+        public virtual long HostContext { get; }
+        public bool IsFullyTrusted { get; }
-        public abstract IEnumerable<Module> Modules { get; }
+        public virtual IEnumerable<Module> Modules { get; }
+        public virtual bool ReflectionOnly { get; }
+        public virtual SecurityRuleSet SecurityRuleSet { get; }
+        public virtual object CreateInstance(string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public static Assembly GetAssembly(Type type);
+        public static Assembly GetCallingAssembly();
+        public virtual object[] GetCustomAttributes(bool inherit);
+        public virtual object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public virtual IList<CustomAttributeData> GetCustomAttributesData();
+        public static Assembly GetExecutingAssembly();
+        public virtual FileStream GetFile(string name);
+        public virtual FileStream[] GetFiles();
+        public virtual FileStream[] GetFiles(bool getResourceModules);
+        public Module[] GetLoadedModules();
+        public virtual Module[] GetLoadedModules(bool getResourceModules);
+        public virtual Stream GetManifestResourceStream(Type type, string name);
+        public virtual Module GetModule(string name);
+        public Module[] GetModules();
+        public virtual Module[] GetModules(bool getResourceModules);
+        public virtual AssemblyName GetName(bool copiedName);
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public virtual Assembly GetSatelliteAssembly(CultureInfo culture);
+        public virtual Assembly GetSatelliteAssembly(CultureInfo culture, Version version);
+        public virtual bool IsDefined(Type attributeType, bool inherit);
+        public static Assembly Load(byte[] rawAssembly);
+        public static Assembly Load(byte[] rawAssembly, byte[] rawSymbolStore);
+        public static Assembly Load(string assemblyString);
+        public static Assembly LoadFile(string path);
+        public static Assembly LoadFrom(string assemblyFile);
+        public static Assembly LoadFrom(string assemblyFile, byte[] hashValue, AssemblyHashAlgorithm hashAlgorithm);
+        public Module LoadModule(string moduleName, byte[] rawModule);
+        public virtual Module LoadModule(string moduleName, byte[] rawModule, byte[] rawSymbolStore);
+        public static Assembly LoadWithPartialName(string partialName);
+        public static bool operator ==(Assembly left, Assembly right);
+        public static bool operator !=(Assembly left, Assembly right);
+        public static Assembly ReflectionOnlyLoad(byte[] rawAssembly);
+        public static Assembly ReflectionOnlyLoad(string assemblyString);
+        public static Assembly ReflectionOnlyLoadFrom(string assemblyFile);
+        public static Assembly UnsafeLoadFrom(string assemblyFile);
+        public virtual event ModuleResolveEventHandler ModuleResolve;
     }
+    public sealed class AssemblyAlgorithmIdAttribute : Attribute {
+        public AssemblyAlgorithmIdAttribute(AssemblyHashAlgorithm algorithmId);
+        public AssemblyAlgorithmIdAttribute(uint algorithmId);
+        public uint AlgorithmId { get; }
+    }
     public sealed class AssemblyFlagsAttribute : Attribute {
+        public AssemblyFlagsAttribute(int assemblyFlags);
+        public AssemblyFlagsAttribute(uint flags);
+        public uint Flags { get; }
     }
-    public sealed class AssemblyName {
+    public sealed class AssemblyName : ICloneable, IDeserializationCallback, ISerializable {
+        public string CodeBase { get; set; }
+        public CultureInfo CultureInfo { get; set; }
+        public string EscapedCodeBase { get; }
+        public AssemblyHashAlgorithm HashAlgorithm { get; set; }
+        public StrongNameKeyPair KeyPair { get; set; }
+        public AssemblyVersionCompatibility VersionCompatibility { get; set; }
+        public object Clone();
+        public static AssemblyName GetAssemblyName(string assemblyFile);
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        public void OnDeserialization(object sender);
+        public static bool ReferenceMatchesDefinition(AssemblyName reference, AssemblyName definition);
     }
     public enum AssemblyNameFlags {
+        EnableJITcompileOptimizer = 16384,
+        EnableJITcompileTracking = 32768,
     }
+    public class AssemblyNameProxy : MarshalByRefObject {
+        public AssemblyNameProxy();
+        public AssemblyName GetAssemblyName(string assemblyFile);
+    }
+    public abstract class Binder {
+        protected Binder();
+        public abstract FieldInfo BindToField(BindingFlags bindingAttr, FieldInfo[] match, object value, CultureInfo culture);
+        public abstract MethodBase BindToMethod(BindingFlags bindingAttr, MethodBase[] match, ref object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] names, out object state);
+        public abstract object ChangeType(object value, Type type, CultureInfo culture);
+        public abstract void ReorderArgumentArray(ref object[] args, object state);
+        public abstract MethodBase SelectMethod(BindingFlags bindingAttr, MethodBase[] match, Type[] types, ParameterModifier[] modifiers);
+        public abstract PropertyInfo SelectProperty(BindingFlags bindingAttr, PropertyInfo[] match, Type returnType, Type[] indexes, ParameterModifier[] modifiers);
+    }
     public enum BindingFlags {
+        ExactBinding = 65536,
+        IgnoreReturn = 16777216,
+        OptionalParamBinding = 262144,
+        PutDispProperty = 16384,
+        PutRefDispProperty = 32768,
+        SuppressChangeType = 131072,
     }
     public abstract class ConstructorInfo : MethodBase {
+        protected ConstructorInfo();
+        public abstract object Invoke(BindingFlags invokeAttr, Binder binder, object[] parameters, CultureInfo culture);
-        public virtual object Invoke(object[] parameters);
+        public object Invoke(object[] parameters);
+        public static bool operator ==(ConstructorInfo left, ConstructorInfo right);
+        public static bool operator !=(ConstructorInfo left, ConstructorInfo right);
     }
     public class CustomAttributeData {
+        protected CustomAttributeData();
-        public virtual Type AttributeType { get; }
+        public Type AttributeType { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public override string ToString();
     }
+    public class CustomAttributeFormatException : FormatException {
+        public CustomAttributeFormatException();
+        protected CustomAttributeFormatException(SerializationInfo info, StreamingContext context);
+        public CustomAttributeFormatException(string message);
+        public CustomAttributeFormatException(string message, Exception inner);
+    }
     public struct CustomAttributeNamedArgument {
+        public CustomAttributeNamedArgument(MemberInfo memberInfo, CustomAttributeTypedArgument typedArgument);
+        public CustomAttributeNamedArgument(MemberInfo memberInfo, object value);
+        public MemberInfo MemberInfo { get; }
     }
     public struct CustomAttributeTypedArgument {
+        public CustomAttributeTypedArgument(object value);
+        public CustomAttributeTypedArgument(Type argumentType, object value);
     }
     public enum EventAttributes {
+        ReservedMask = 1024,
     }
     public abstract class EventInfo : MemberInfo {
+        protected EventInfo();
+        public MethodInfo[] GetOtherMethods();
+        public virtual MethodInfo[] GetOtherMethods(bool nonPublic);
+        public static bool operator ==(EventInfo left, EventInfo right);
+        public static bool operator !=(EventInfo left, EventInfo right);
     }
+    public class ExceptionHandlingClause {
+        protected ExceptionHandlingClause();
+        public virtual Type CatchType { get; }
+        public virtual int FilterOffset { get; }
+        public virtual ExceptionHandlingClauseOptions Flags { get; }
+        public virtual int HandlerLength { get; }
+        public virtual int HandlerOffset { get; }
+        public virtual int TryLength { get; }
+        public virtual int TryOffset { get; }
+        public override string ToString();
+    }
+    public enum ExceptionHandlingClauseOptions {
+        Clause = 0,
+        Fault = 4,
+        Filter = 1,
+        Finally = 2,
+    }
     public enum FieldAttributes {
+        ReservedMask = 38144,
     }
     public abstract class FieldInfo : MemberInfo {
+        protected FieldInfo();
+        public abstract RuntimeFieldHandle FieldHandle { get; }
+        public bool IsNotSerialized { get; }
+        public bool IsPinvokeImpl { get; }
+        public virtual bool IsSecurityCritical { get; }
+        public virtual bool IsSecuritySafeCritical { get; }
+        public virtual bool IsSecurityTransparent { get; }
+        public static bool operator ==(FieldInfo left, FieldInfo right);
+        public static bool operator !=(FieldInfo left, FieldInfo right);
-        public virtual void SetValue(object obj, object value);
+        public void SetValue(object obj, object value);
+        public abstract void SetValue(object obj, object value, BindingFlags invokeAttr, Binder binder, CultureInfo culture);
     }
+    public enum ImageFileMachine {
+        AMD64 = 34404,
+        ARM = 452,
+        I386 = 332,
+        IA64 = 512,
+    }
-    public class InvalidFilterCriteriaException : Exception {
+    public class InvalidFilterCriteriaException : ApplicationException {
+        protected InvalidFilterCriteriaException(SerializationInfo info, StreamingContext context);
     }
+    public interface IReflect {
+        Type UnderlyingSystemType { get; }
+        FieldInfo GetField(string name, BindingFlags bindingAttr);
+        FieldInfo[] GetFields(BindingFlags bindingAttr);
+        MemberInfo[] GetMember(string name, BindingFlags bindingAttr);
+        MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        MethodInfo GetMethod(string name, BindingFlags bindingAttr);
+        MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
+        MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        PropertyInfo GetProperty(string name, BindingFlags bindingAttr);
+        PropertyInfo GetProperty(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
+    }
     public abstract class MemberInfo : ICustomAttributeProvider {
+        protected MemberInfo();
+        public abstract Type ReflectedType { get; }
+        public abstract object[] GetCustomAttributes(bool inherit);
+        public abstract object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public virtual IList<CustomAttributeData> GetCustomAttributesData();
+        public abstract bool IsDefined(Type attributeType, bool inherit);
+        public static bool operator ==(MemberInfo left, MemberInfo right);
+        public static bool operator !=(MemberInfo left, MemberInfo right);
     }
     public enum MethodAttributes {
+        ReservedMask = 53248,
     }
     public abstract class MethodBase : MemberInfo {
+        protected MethodBase();
+        public virtual bool IsSecurityCritical { get; }
+        public virtual bool IsSecuritySafeCritical { get; }
+        public virtual bool IsSecurityTransparent { get; }
+        public abstract RuntimeMethodHandle MethodHandle { get; }
-        public abstract MethodImplAttributes MethodImplementationFlags { get; }
+        public virtual MethodImplAttributes MethodImplementationFlags { get; }
+        public static MethodBase GetCurrentMethod();
+        public virtual MethodBody GetMethodBody();
+        public abstract object Invoke(object obj, BindingFlags invokeAttr, Binder binder, object[] parameters, CultureInfo culture);
-        public virtual object Invoke(object obj, object[] parameters);
+        public object Invoke(object obj, object[] parameters);
+        public static bool operator ==(MethodBase left, MethodBase right);
+        public static bool operator !=(MethodBase left, MethodBase right);
     }
+    public class MethodBody {
+        protected MethodBody();
+        public virtual IList<ExceptionHandlingClause> ExceptionHandlingClauses { get; }
+        public virtual bool InitLocals { get; }
+        public virtual int LocalSignatureMetadataToken { get; }
+        public virtual IList<LocalVariableInfo> LocalVariables { get; }
+        public virtual int MaxStackSize { get; }
+        public virtual byte[] GetILAsByteArray();
+    }
     public enum MethodImplAttributes {
+        MaxMethodImplVal = 65535,
     }
     public abstract class MethodInfo : MethodBase {
+        protected MethodInfo();
+        public static bool operator ==(MethodInfo left, MethodInfo right);
+        public static bool operator !=(MethodInfo left, MethodInfo right);
     }
-    public sealed class Missing {
+    public sealed class Missing : ISerializable {
     }
-    public abstract class Module : ICustomAttributeProvider {
+    public abstract class Module : ICustomAttributeProvider, ISerializable {
+        protected Module();
+        public virtual int MDStreamVersion { get; }
+        public virtual int MetadataToken { get; }
+        public ModuleHandle ModuleHandle { get; }
+        public virtual object[] GetCustomAttributes(bool inherit);
+        public virtual object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public virtual IList<CustomAttributeData> GetCustomAttributesData();
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        protected virtual MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public virtual void GetPEKind(out PortableExecutableKinds peKind, out ImageFileMachine machine);
+        public virtual X509Certificate GetSignerCertificate();
+        public virtual bool IsDefined(Type attributeType, bool inherit);
+        public virtual bool IsResource();
+        public static bool operator ==(Module left, Module right);
+        public static bool operator !=(Module left, Module right);
+        public FieldInfo ResolveField(int metadataToken);
+        public virtual FieldInfo ResolveField(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        public MemberInfo ResolveMember(int metadataToken);
+        public virtual MemberInfo ResolveMember(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        public MethodBase ResolveMethod(int metadataToken);
+        public virtual MethodBase ResolveMethod(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        public virtual byte[] ResolveSignature(int metadataToken);
+        public virtual string ResolveString(int metadataToken);
+        public Type ResolveType(int metadataToken);
+        public virtual Type ResolveType(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
     }
+    public delegate Module ModuleResolveEventHandler(object sender, ResolveEventArgs e); {
+        public ModuleResolveEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ResolveEventArgs e, AsyncCallback callback, object @object);
+        public virtual Module EndInvoke(IAsyncResult result);
+        public virtual Module Invoke(object sender, ResolveEventArgs e);
+    }
+    public sealed class ObfuscateAssemblyAttribute : Attribute {
+        public ObfuscateAssemblyAttribute(bool assemblyIsPrivate);
+        public bool AssemblyIsPrivate { get; }
+        public bool StripAfterObfuscation { get; set; }
+    }
+    public sealed class ObfuscationAttribute : Attribute {
+        public ObfuscationAttribute();
+        public bool ApplyToMembers { get; set; }
+        public bool Exclude { get; set; }
+        public string Feature { get; set; }
+        public bool StripAfterObfuscation { get; set; }
+    }
     public enum ParameterAttributes {
+        Reserved3 = 16384,
+        Reserved4 = 32768,
+        ReservedMask = 61440,
     }
-    public class ParameterInfo : ICustomAttributeProvider {
+    public class ParameterInfo : ICustomAttributeProvider, IObjectReference {
+        protected ParameterAttributes AttrsImpl;
+        protected Type ClassImpl;
+        protected object DefaultValueImpl;
+        protected MemberInfo MemberImpl;
+        protected string NameImpl;
+        protected int PositionImpl;
+        protected ParameterInfo();
+        public bool IsLcid { get; }
+        public virtual int MetadataToken { get; }
+        public virtual object[] GetCustomAttributes(bool inherit);
+        public virtual object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public virtual IList<CustomAttributeData> GetCustomAttributesData();
+        public object GetRealObject(StreamingContext context);
+        public virtual bool IsDefined(Type attributeType, bool inherit);
+        public override string ToString();
     }
+    public sealed class Pointer : ISerializable {
+        public unsafe static object Box(void* ptr, Type type);
+        public unsafe static void* Unbox(object ptr);
+    }
+    public enum PortableExecutableKinds {
+        ILOnly = 1,
+        NotAPortableExecutableImage = 0,
+        PE32Plus = 4,
+        Preferred32Bit = 16,
+        Required32Bit = 2,
+        Unmanaged32Bit = 8,
+    }
     public enum PropertyAttributes {
+        Reserved2 = 8192,
+        Reserved3 = 16384,
+        Reserved4 = 32768,
+        ReservedMask = 62464,
     }
     public abstract class PropertyInfo : MemberInfo {
+        protected PropertyInfo();
+        public abstract object GetValue(object obj, BindingFlags invokeAttr, Binder binder, object[] index, CultureInfo culture);
+        public static bool operator ==(PropertyInfo left, PropertyInfo right);
+        public static bool operator !=(PropertyInfo left, PropertyInfo right);
+        public abstract void SetValue(object obj, object value, BindingFlags invokeAttr, Binder binder, object[] index, CultureInfo culture);
     }
-    public sealed class ReflectionTypeLoadException : Exception {
+    public sealed class ReflectionTypeLoadException : SystemException, ISerializable {
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public enum ResourceAttributes {
+        Private = 2,
+        Public = 1,
+    }
+    public class StrongNameKeyPair : IDeserializationCallback, ISerializable {
+        public StrongNameKeyPair(byte[] keyPairArray);
+        public StrongNameKeyPair(FileStream keyPairFile);
+        protected StrongNameKeyPair(SerializationInfo info, StreamingContext context);
+        public StrongNameKeyPair(string keyPairContainer);
+        public byte[] PublicKey { get; }
+    }
-    public class TargetException : Exception {
+    public class TargetException : ApplicationException {
+        protected TargetException(SerializationInfo info, StreamingContext context);
     }
-    public sealed class TargetInvocationException : Exception {
+    public sealed class TargetInvocationException : ApplicationException {
     }
-    public sealed class TargetParameterCountException : Exception {
+    public sealed class TargetParameterCountException : ApplicationException {
     }
     public enum TypeAttributes {
+        ReservedMask = 264192,
     }
+    public class TypeDelegator : TypeInfo {
+        protected Type typeImpl;
+        protected TypeDelegator();
+        public TypeDelegator(Type delegatingType);
+        public override Assembly Assembly { get; }
+        public override string AssemblyQualifiedName { get; }
+        public override Type BaseType { get; }
+        public override string FullName { get; }
+        public override Guid GUID { get; }
+        public override bool IsConstructedGenericType { get; }
+        public override int MetadataToken { get; }
+        public override Module Module { get; }
+        public override string Name { get; }
+        public override string Namespace { get; }
+        public override RuntimeTypeHandle TypeHandle { get; }
+        public override Type UnderlyingSystemType { get; }
+        protected override TypeAttributes GetAttributeFlagsImpl();
+        protected override ConstructorInfo GetConstructorImpl(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override Type GetElementType();
+        public override EventInfo GetEvent(string name, BindingFlags bindingAttr);
+        public override EventInfo[] GetEvents();
+        public override EventInfo[] GetEvents(BindingFlags bindingAttr);
+        public override FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public override FieldInfo[] GetFields(BindingFlags bindingAttr);
+        public override Type GetInterface(string name, bool ignoreCase);
+        public override InterfaceMapping GetInterfaceMap(Type interfaceType);
+        public override Type[] GetInterfaces();
+        public override MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
+        public override MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        protected override MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public override MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        public override Type GetNestedType(string name, BindingFlags bindingAttr);
+        public override Type[] GetNestedTypes(BindingFlags bindingAttr);
+        public override PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        protected override PropertyInfo GetPropertyImpl(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        protected override bool HasElementTypeImpl();
+        public override object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
+        protected override bool IsArrayImpl();
+        public override bool IsAssignableFrom(TypeInfo typeInfo);
+        protected override bool IsByRefImpl();
+        protected override bool IsCOMObjectImpl();
+        public override bool IsDefined(Type attributeType, bool inherit);
+        protected override bool IsPointerImpl();
+        protected override bool IsPrimitiveImpl();
+        protected override bool IsValueTypeImpl();
+    }
-    public abstract class TypeInfo : MemberInfo, IReflectableType {
+    public abstract class TypeInfo : Type, IReflectableType {
-        public abstract Assembly Assembly { get; }
-        public abstract string AssemblyQualifiedName { get; }
-        public abstract TypeAttributes Attributes { get; }
-        public abstract Type BaseType { get; }
-        public abstract bool ContainsGenericParameters { get; }
-        public abstract MethodBase DeclaringMethod { get; }
-        public abstract string FullName { get; }
-        public abstract GenericParameterAttributes GenericParameterAttributes { get; }
-        public abstract int GenericParameterPosition { get; }
-        public abstract Type[] GenericTypeArguments { get; }
-        public abstract Guid GUID { get; }
-        public bool HasElementType { get; }
-        public bool IsAbstract { get; }
-        public bool IsAnsiClass { get; }
-        public bool IsArray { get; }
-        public bool IsAutoClass { get; }
-        public bool IsAutoLayout { get; }
-        public bool IsByRef { get; }
-        public bool IsClass { get; }
-        public virtual bool IsCOMObject { get; }
-        public abstract bool IsEnum { get; }
-        public bool IsExplicitLayout { get; }
-        public abstract bool IsGenericParameter { get; }
-        public abstract bool IsGenericType { get; }
-        public abstract bool IsGenericTypeDefinition { get; }
-        public bool IsImport { get; }
-        public bool IsInterface { get; }
-        public bool IsLayoutSequential { get; }
-        public bool IsMarshalByRef { get; }
-        public bool IsNested { get; }
-        public bool IsNestedAssembly { get; }
-        public bool IsNestedFamANDAssem { get; }
-        public bool IsNestedFamily { get; }
-        public bool IsNestedFamORAssem { get; }
-        public bool IsNestedPrivate { get; }
-        public bool IsNestedPublic { get; }
-        public bool IsNotPublic { get; }
-        public bool IsPointer { get; }
-        public virtual bool IsPrimitive { get; }
-        public bool IsPublic { get; }
-        public bool IsSealed { get; }
-        public abstract bool IsSerializable { get; }
-        public bool IsSpecialName { get; }
-        public bool IsUnicodeClass { get; }
-        public virtual bool IsValueType { get; }
-        public bool IsVisible { get; }
-        public override MemberTypes MemberType { get; }
-        public abstract string Namespace { get; }
-        public virtual StructLayoutAttribute StructLayoutAttribute { get; }
-        public ConstructorInfo TypeInitializer { get; }
-        public virtual Type UnderlyingSystemType { get; }
-        public virtual Type[] FindInterfaces(TypeFilter filter, object filterCriteria);
-        public virtual MemberInfo[] FindMembers(MemberTypes memberType, BindingFlags bindingAttr, MemberFilter filter, object filterCriteria);
-        public abstract int GetArrayRank();
-        public ConstructorInfo GetConstructor(Type[] types);
-        public ConstructorInfo[] GetConstructors();
-        public virtual ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
-        public virtual MemberInfo[] GetDefaultMembers();
-        public abstract Type GetElementType();
-        public virtual string GetEnumName(object value);
-        public virtual string[] GetEnumNames();
-        public virtual Type GetEnumUnderlyingType();
-        public virtual Array GetEnumValues();
-        public EventInfo GetEvent(string name);
-        public virtual EventInfo GetEvent(string name, BindingFlags bindingAttr);
-        public virtual EventInfo[] GetEvents();
-        public virtual EventInfo[] GetEvents(BindingFlags bindingAttr);
-        public FieldInfo GetField(string name);
-        public virtual FieldInfo GetField(string name, BindingFlags bindingAttr);
-        public FieldInfo[] GetFields();
-        public virtual FieldInfo[] GetFields(BindingFlags bindingAttr);
-        public virtual Type[] GetGenericArguments();
-        public abstract Type[] GetGenericParameterConstraints();
-        public abstract Type GetGenericTypeDefinition();
-        public Type GetInterface(string name);
-        public virtual Type GetInterface(string name, bool ignoreCase);
-        public virtual Type[] GetInterfaces();
-        public MemberInfo[] GetMember(string name);
-        public virtual MemberInfo[] GetMember(string name, BindingFlags bindingAttr);
-        public virtual MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
-        public MemberInfo[] GetMembers();
-        public virtual MemberInfo[] GetMembers(BindingFlags bindingAttr);
-        public MethodInfo GetMethod(string name);
-        public MethodInfo GetMethod(string name, BindingFlags bindingAttr);
-        public MethodInfo GetMethod(string name, Type[] types);
-        public MethodInfo GetMethod(string name, Type[] types, ParameterModifier[] modifiers);
-        public MethodInfo[] GetMethods();
-        public virtual MethodInfo[] GetMethods(BindingFlags bindingAttr);
-        public Type GetNestedType(string name);
-        public virtual Type GetNestedType(string name, BindingFlags bindingAttr);
-        public Type[] GetNestedTypes();
-        public virtual Type[] GetNestedTypes(BindingFlags bindingAttr);
-        public PropertyInfo[] GetProperties();
-        public virtual PropertyInfo[] GetProperties(BindingFlags bindingAttr);
-        public PropertyInfo GetProperty(string name);
-        public PropertyInfo GetProperty(string name, BindingFlags bindingAttr);
-        public PropertyInfo GetProperty(string name, Type returnType);
-        public PropertyInfo GetProperty(string name, Type returnType, Type[] types);
-        public PropertyInfo GetProperty(string name, Type returnType, Type[] types, ParameterModifier[] modifiers);
-        public PropertyInfo GetProperty(string name, Type[] types);
-        public virtual bool IsAssignableFrom(Type c);
-        public virtual bool IsEnumDefined(object value);
-        public virtual bool IsEquivalentTo(Type other);
-        public virtual bool IsInstanceOfType(object o);
-        public virtual bool IsSubclassOf(Type c);
-        public abstract Type MakeArrayType();
-        public abstract Type MakeArrayType(int rank);
-        public abstract Type MakeByRefType();
-        public abstract Type MakeGenericType(params Type[] typeArguments);
-        public abstract Type MakePointerType();
     }
 }
 namespace System.Reflection.Emit {
     public enum FlowControl {
+        Phi = 6,
     }
     public enum OpCodeType {
+        Annotation = 0,
     }
     public enum OperandType {
+        InlinePhi = 6,
     }
 }
 namespace System.Resources {
+    public interface IResourceReader : IDisposable, IEnumerable {
+        void Close();
+        new IDictionaryEnumerator GetEnumerator();
+    }
+    public interface IResourceWriter : IDisposable {
+        void AddResource(string name, byte[] value);
+        void AddResource(string name, object value);
+        void AddResource(string name, string value);
+        void Close();
+        void Generate();
+    }
-    public class MissingManifestResourceException : Exception {
+    public class MissingManifestResourceException : SystemException {
+        protected MissingManifestResourceException(SerializationInfo info, StreamingContext context);
     }
+    public class MissingSatelliteAssemblyException : SystemException {
+        public MissingSatelliteAssemblyException();
+        protected MissingSatelliteAssemblyException(SerializationInfo info, StreamingContext context);
+        public MissingSatelliteAssemblyException(string message);
+        public MissingSatelliteAssemblyException(string message, Exception inner);
+        public MissingSatelliteAssemblyException(string message, string cultureName);
+        public string CultureName { get; }
+    }
     public sealed class NeutralResourcesLanguageAttribute : Attribute {
+        public NeutralResourcesLanguageAttribute(string cultureName, UltimateResourceFallbackLocation location);
+        public UltimateResourceFallbackLocation Location { get; }
     }
     public class ResourceManager {
+        public static readonly int HeaderVersionNumber;
+        public static readonly int MagicNumber;
+        protected Assembly MainAssembly;
+        protected ResourceManager();
+        public ResourceManager(string baseName, Assembly assembly, Type usingResourceSet);
+        public virtual string BaseName { get; }
+        protected UltimateResourceFallbackLocation FallbackLocation { get; set; }
+        public virtual bool IgnoreCase { get; set; }
+        public virtual Type ResourceSetType { get; }
+        public static ResourceManager CreateFileBasedResourceManager(string baseName, string resourceDir, Type usingResourceSet);
+        protected static CultureInfo GetNeutralResourcesLanguage(Assembly a);
+        public virtual object GetObject(string name);
+        public virtual object GetObject(string name, CultureInfo culture);
+        protected virtual string GetResourceFileName(CultureInfo culture);
+        public virtual ResourceSet GetResourceSet(CultureInfo culture, bool createIfNotExists, bool tryParents);
+        protected static Version GetSatelliteContractVersion(Assembly a);
+        public UnmanagedMemoryStream GetStream(string name);
+        public UnmanagedMemoryStream GetStream(string name, CultureInfo culture);
-        public string GetString(string name);
+        public virtual string GetString(string name);
+        protected virtual ResourceSet InternalGetResourceSet(CultureInfo culture, bool createIfNotExists, bool tryParents);
+        public virtual void ReleaseAllResources();
     }
+    public sealed class ResourceReader : IDisposable, IEnumerable, IResourceReader {
+        public ResourceReader(Stream stream);
+        public ResourceReader(string fileName);
+        public void Close();
+        public void Dispose();
+        public IDictionaryEnumerator GetEnumerator();
+        public void GetResourceData(string resourceName, out string resourceType, out byte[] resourceData);
+    }
+    public class ResourceSet : IDisposable, IEnumerable {
+        protected ResourceSet();
+        public ResourceSet(IResourceReader reader);
+        public ResourceSet(Stream stream);
+        public ResourceSet(string fileName);
+        public virtual void Close();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual Type GetDefaultReader();
+        public virtual Type GetDefaultWriter();
+        public virtual IDictionaryEnumerator GetEnumerator();
+        public virtual object GetObject(string name);
+        public virtual object GetObject(string name, bool ignoreCase);
+        public virtual string GetString(string name);
+        public virtual string GetString(string name, bool ignoreCase);
+        protected virtual void ReadResources();
+    }
+    public sealed class ResourceWriter : IDisposable, IResourceWriter {
+        public ResourceWriter(Stream stream);
+        public ResourceWriter(string fileName);
+        public Func<Type, string> TypeNameConverter { get; set; }
+        public void AddResource(string name, byte[] value);
+        public void AddResource(string name, object value);
+        public void AddResource(string name, Stream value);
+        public void AddResource(string name, Stream value, bool closeAfterWrite);
+        public void AddResource(string name, string value);
+        public void AddResourceData(string name, string typeName, byte[] serializedData);
+        public void Close();
+        public void Dispose();
+        public void Generate();
+    }
+    public enum UltimateResourceFallbackLocation {
+        MainAssembly = 0,
+        Satellite = 1,
+    }
 }
 namespace System.Runtime {
+    public sealed class AssemblyTargetedPatchBandAttribute : Attribute {
+        public AssemblyTargetedPatchBandAttribute(string targetedPatchBand);
+        public string TargetedPatchBand { get; }
+    }
     public enum GCLatencyMode {
+        NoGCRegion = 4,
     }
+    public sealed class MemoryFailPoint : CriticalFinalizerObject, IDisposable {
+        public MemoryFailPoint(int sizeInMegabytes);
+        public void Dispose();
+    }
+    public sealed class TargetedPatchingOptOutAttribute : Attribute {
+        public TargetedPatchingOptOutAttribute(string reason);
+        public string Reason { get; }
+    }
 }
 namespace System.Runtime.CompilerServices {
+    public class CallConvCdecl {
+        public CallConvCdecl();
+    }
+    public class CallConvFastcall {
+        public CallConvFastcall();
+    }
+    public class CallConvStdcall {
+        public CallConvStdcall();
+    }
+    public class CallConvThiscall {
+        public CallConvThiscall();
+    }
+    public class CallSite {
+        public CallSiteBinder Binder { get; }
+        public static CallSite Create(Type delegateType, CallSiteBinder binder);
+    }
+    public class CallSite<T> : CallSite where T : class {
+        public T Target;
+        public T Update { get; }
+        public static CallSite<T> Create(CallSiteBinder binder);
+    }
+    public abstract class CallSiteBinder {
+        protected CallSiteBinder();
+        public static LabelTarget UpdateLabel { get; }
+        public abstract Expression Bind(object[] args, ReadOnlyCollection<ParameterExpression> parameters, LabelTarget returnLabel);
+        public virtual T BindDelegate<T>(CallSite<T> site, object[] args) where T : class;
+        protected void CacheTarget<T>(T target) where T : class;
+    }
+    public static class CallSiteHelpers {
+        public static bool IsInternalFrame(MethodBase mb);
+    }
+    public enum CompilationRelaxations {
+        NoStringInterning = 8,
+    }
     public class CompilationRelaxationsAttribute : Attribute {
+        public CompilationRelaxationsAttribute(CompilationRelaxations relaxations);
     }
+    public class CompilerGlobalScopeAttribute : Attribute {
+        public CompilerGlobalScopeAttribute();
+    }
+    public static class CompilerMarshalOverride
+    public static class ContractHelper {
+        public static string RaiseContractFailedEvent(ContractFailureKind failureKind, string userMessage, string conditionText, Exception innerException);
+        public static void TriggerFailure(ContractFailureKind kind, string displayMessage, string userMessage, string conditionText, Exception innerException);
+    }
+    public abstract class DebugInfoGenerator {
+        protected DebugInfoGenerator();
+        public static DebugInfoGenerator CreatePdbGenerator();
+        public abstract void MarkSequencePoint(LambdaExpression method, int ilOffset, DebugInfoExpression sequencePoint);
+    }
+    public sealed class DefaultDependencyAttribute : Attribute {
+        public DefaultDependencyAttribute(LoadHint loadHintArgument);
+        public LoadHint LoadHint { get; }
+    }
+    public sealed class DependencyAttribute : Attribute {
+        public DependencyAttribute(string dependentAssemblyArgument, LoadHint loadHintArgument);
+        public string DependentAssembly { get; }
+        public LoadHint LoadHint { get; }
+    }
+    public class DiscardableAttribute : Attribute {
+        public DiscardableAttribute();
+    }
+    public sealed class DynamicAttribute : Attribute {
+        public DynamicAttribute();
+        public DynamicAttribute(bool[] transformFlags);
+        public IList<bool> TransformFlags { get; }
+    }
+    public sealed class FixedAddressValueTypeAttribute : Attribute {
+        public FixedAddressValueTypeAttribute();
+    }
+    public sealed class HasCopySemanticsAttribute : Attribute {
+        public HasCopySemanticsAttribute();
+    }
     public sealed class InternalsVisibleToAttribute : Attribute {
+        public bool AllInternalsVisible { get; set; }
     }
+    public interface IRuntimeVariables {
+        int Count { get; }
+        object this[int index] { get; set; }
+    }
+    public static class IsBoxed
+    public static class IsByValue
+    public static class IsCopyConstructed
+    public static class IsExplicitlyDereferenced
+    public static class IsImplicitlyDereferenced
+    public static class IsJitIntrinsic
+    public static class IsLong
+    public static class IsPinned
+    public static class IsSignUnspecifiedByte
+    public static class IsUdtReturn
+    public sealed class IUnknownConstantAttribute : CustomConstantAttribute {
+        public IUnknownConstantAttribute();
+        public override object Value { get; }
+    }
+    public enum LoadHint {
+        Always = 1,
+        Default = 0,
+        Sometimes = 2,
+    }
+    public enum MethodCodeType {
+        IL = 0,
+        Native = 1,
+        OPTIL = 2,
+        Runtime = 3,
+    }
     public sealed class MethodImplAttribute : Attribute {
+        public MethodCodeType MethodCodeType;
+        public MethodImplAttribute();
+        public MethodImplAttribute(short value);
     }
     public enum MethodImplOptions {
+        ForwardRef = 16,
+        InternalCall = 4096,
+        Synchronized = 32,
+        Unmanaged = 4,
     }
+    public sealed class NativeCppClassAttribute : Attribute {
+        public NativeCppClassAttribute();
+    }
+    public sealed class ReadOnlyCollectionBuilder<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T> {
+        public ReadOnlyCollectionBuilder();
+        public ReadOnlyCollectionBuilder(IEnumerable<T> collection);
+        public ReadOnlyCollectionBuilder(int capacity);
+        public int Capacity { get; set; }
+        public int Count { get; }
+        public T this[int index] { get; set; }
+        public void Add(T item);
+        public void Clear();
+        public bool Contains(T item);
+        public void CopyTo(T[] array, int arrayIndex);
+        public IEnumerator<T> GetEnumerator();
+        public int IndexOf(T item);
+        public void Insert(int index, T item);
+        public bool Remove(T item);
+        public void RemoveAt(int index);
+        public void Reverse();
+        public void Reverse(int index, int count);
+        public T[] ToArray();
+        public ReadOnlyCollection<T> ToReadOnlyCollection();
+    }
+    public sealed class RequiredAttributeAttribute : Attribute {
+        public RequiredAttributeAttribute(Type requiredContract);
+        public Type RequiredContract { get; }
+    }
+    public class RuleCache<T> where T : class
     public static class RuntimeHelpers {
+        public delegate void CleanupCode(object userData, bool exceptionThrown); {
+            public CleanupCode(object @object, IntPtr method);
+            public virtual IAsyncResult BeginInvoke(object userData, bool exceptionThrown, AsyncCallback callback, object @object);
+            public virtual void EndInvoke(IAsyncResult result);
+            public virtual void Invoke(object userData, bool exceptionThrown);
+        }
+        public delegate void TryCode(object userData); {
+            public TryCode(object @object, IntPtr method);
+            public virtual IAsyncResult BeginInvoke(object userData, AsyncCallback callback, object @object);
+            public virtual void EndInvoke(IAsyncResult result);
+            public virtual void Invoke(object userData);
+        }
+        public static new bool Equals(object o1, object o2);
+        public static void ExecuteCodeWithGuaranteedCleanup(RuntimeHelpers.TryCode code, RuntimeHelpers.CleanupCode backoutCode, object userData);
+        public static void PrepareConstrainedRegions();
+        public static void PrepareConstrainedRegionsNoOP();
+        public static void PrepareContractedDelegate(Delegate d);
+        public static void PrepareDelegate(Delegate d);
+        public static void PrepareMethod(RuntimeMethodHandle method);
+        public static void PrepareMethod(RuntimeMethodHandle method, RuntimeTypeHandle[] instantiation);
+        public static void ProbeForSufficientStack();
+        public static void RunModuleConstructor(ModuleHandle module);
     }
+    public sealed class RuntimeWrappedException : Exception {
+        public object WrappedException { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public sealed class ScopelessEnumAttribute : Attribute {
+        public ScopelessEnumAttribute();
+    }
+    public sealed class SpecialNameAttribute : Attribute {
+        public SpecialNameAttribute();
+    }
+    public sealed class StringFreezingAttribute : Attribute {
+        public StringFreezingAttribute();
+    }
+    public sealed class SuppressIldasmAttribute : Attribute {
+        public SuppressIldasmAttribute();
+    }
 }
+namespace System.Runtime.ConstrainedExecution {
+    public enum Cer {
+        MayFail = 1,
+        None = 0,
+        Success = 2,
+    }
+    public enum Consistency {
+        MayCorruptAppDomain = 1,
+        MayCorruptInstance = 2,
+        MayCorruptProcess = 0,
+        WillNotCorruptState = 3,
+    }
+    public abstract class CriticalFinalizerObject {
+        protected CriticalFinalizerObject();
+        ~CriticalFinalizerObject();
+    }
+    public sealed class PrePrepareMethodAttribute : Attribute {
+        public PrePrepareMethodAttribute();
+    }
+    public sealed class ReliabilityContractAttribute : Attribute {
+        public ReliabilityContractAttribute(Consistency consistencyGuarantee, Cer cer);
+        public Cer Cer { get; }
+        public Consistency ConsistencyGuarantee { get; }
+    }
+}
 namespace System.Runtime.ExceptionServices {
+    public class FirstChanceExceptionEventArgs : EventArgs {
+        public FirstChanceExceptionEventArgs(Exception exception);
+        public Exception Exception { get; }
+    }
+    public sealed class HandleProcessCorruptedStateExceptionsAttribute : Attribute {
+        public HandleProcessCorruptedStateExceptionsAttribute();
+    }
 }
 namespace System.Runtime.InteropServices {
+    public sealed class AllowReversePInvokeCallsAttribute : Attribute {
+        public AllowReversePInvokeCallsAttribute();
+    }
-    public enum Architecture {
-        Arm = 2,
-        Arm64 = 3,
-        X64 = 1,
-        X86 = 0,
-    }
     public enum CallingConvention {
+        FastCall = 5,
     }
     public enum CharSet {
+        Auto = 4,
+        None = 1,
     }
+    public sealed class ComAliasNameAttribute : Attribute {
+        public ComAliasNameAttribute(string alias);
+        public string Value { get; }
+    }
     public class ComAwareEventInfo : EventInfo {
+        public override Type ReflectedType { get; }
+        public override MethodInfo GetAddMethod(bool nonPublic);
+        public override object[] GetCustomAttributes(bool inherit);
+        public override object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override MethodInfo GetRaiseMethod(bool nonPublic);
+        public override MethodInfo GetRemoveMethod(bool nonPublic);
+        public override bool IsDefined(Type attributeType, bool inherit);
     }
+    public sealed class ComCompatibleVersionAttribute : Attribute {
+        public ComCompatibleVersionAttribute(int major, int minor, int build, int revision);
+        public int BuildNumber { get; }
+        public int MajorVersion { get; }
+        public int MinorVersion { get; }
+        public int RevisionNumber { get; }
+    }
+    public sealed class ComConversionLossAttribute : Attribute {
+        public ComConversionLossAttribute();
+    }
-    public class COMException : Exception {
+    public class COMException : ExternalException {
+        protected COMException(SerializationInfo info, StreamingContext context);
+        public override string ToString();
     }
+    public sealed class ComRegisterFunctionAttribute : Attribute {
+        public ComRegisterFunctionAttribute();
+    }
+    public sealed class ComUnregisterFunctionAttribute : Attribute {
+        public ComUnregisterFunctionAttribute();
+    }
-    public abstract class CriticalHandle : IDisposable {
+    public abstract class CriticalHandle : CriticalFinalizerObject, IDisposable {
+        public void Close();
     }
+    public class ExternalException : SystemException {
+        public ExternalException();
+        protected ExternalException(SerializationInfo info, StreamingContext context);
+        public ExternalException(string message);
+        public ExternalException(string message, Exception inner);
+        public ExternalException(string message, int errorCode);
+        public virtual int ErrorCode { get; }
+        public override string ToString();
+    }
+    public struct HandleRef {
+        public HandleRef(object wrapper, IntPtr handle);
+        public IntPtr Handle { get; }
+        public object Wrapper { get; }
+        public static explicit operator IntPtr (HandleRef value);
+        public static IntPtr ToIntPtr(HandleRef value);
+    }
+    public interface ICustomFactory {
+        MarshalByRefObject CreateInstance(Type serverType);
+    }
+    public interface ICustomMarshaler {
+        void CleanUpManagedData(object ManagedObj);
+        void CleanUpNativeData(IntPtr pNativeData);
+        int GetNativeDataSize();
+        IntPtr MarshalManagedToNative(object ManagedObj);
+        object MarshalNativeToManaged(IntPtr pNativeData);
+    }
-    public class InvalidComObjectException : Exception {
+    public class InvalidComObjectException : SystemException {
+        protected InvalidComObjectException(SerializationInfo info, StreamingContext context);
     }
-    public class InvalidOleVariantTypeException : Exception {
+    public class InvalidOleVariantTypeException : SystemException {
+        protected InvalidOleVariantTypeException(SerializationInfo info, StreamingContext context);
     }
+    public sealed class LCIDConversionAttribute : Attribute {
+        public LCIDConversionAttribute(int lcid);
+        public int Value { get; }
+    }
     public static class Marshal {
+        public static object BindToMoniker(string monikerName);
+        public static void ChangeWrapperHandleStrength(object otp, bool fIsWeak);
+        public static void Prelink(MethodInfo m);
+        public static void PrelinkAll(Type c);
+        public static string PtrToStringAuto(IntPtr ptr);
+        public static string PtrToStringAuto(IntPtr ptr, int len);
+        public static IntPtr SecureStringToBSTR(SecureString s);
+        public static IntPtr SecureStringToCoTaskMemAnsi(SecureString s);
+        public static IntPtr SecureStringToCoTaskMemUnicode(SecureString s);
+        public static IntPtr SecureStringToGlobalAllocAnsi(SecureString s);
+        public static IntPtr SecureStringToGlobalAllocUnicode(SecureString s);
+        public static IntPtr StringToCoTaskMemAuto(string s);
+        public static IntPtr StringToHGlobalAuto(string s);
     }
-    public class MarshalDirectiveException : Exception {
+    public class MarshalDirectiveException : SystemException {
+        protected MarshalDirectiveException(SerializationInfo info, StreamingContext context);
     }
-    public struct OSPlatform : IEquatable<OSPlatform> {
-        public static OSPlatform Linux { get; }
-        public static OSPlatform OSX { get; }
-        public static OSPlatform Windows { get; }
-        public static OSPlatform Create(string osPlatform);
-        public override bool Equals(object obj);
-        public bool Equals(OSPlatform other);
-        public override int GetHashCode();
-        public static bool operator ==(OSPlatform left, OSPlatform right);
-        public static bool operator !=(OSPlatform left, OSPlatform right);
-        public override string ToString();
-    }
+    public sealed class PrimaryInteropAssemblyAttribute : Attribute {
+        public PrimaryInteropAssemblyAttribute(int major, int minor);
+        public int MajorVersion { get; }
+        public int MinorVersion { get; }
+    }
+    public sealed class ProgIdAttribute : Attribute {
+        public ProgIdAttribute(string progId);
+        public string Value { get; }
+    }
+    public static class RuntimeEnvironment {
+        public static string SystemConfigurationFile { get; }
+        public static bool FromGlobalAccessCache(Assembly a);
+        public static string GetRuntimeDirectory();
+        public static IntPtr GetRuntimeInterfaceAsIntPtr(Guid clsid, Guid riid);
+        public static object GetRuntimeInterfaceAsObject(Guid clsid, Guid riid);
+        public static string GetSystemVersion();
+    }
-    public static class RuntimeInformation {
-        public static string FrameworkDescription { get; }
-        public static Architecture OSArchitecture { get; }
-        public static string OSDescription { get; }
-        public static Architecture ProcessArchitecture { get; }
-        public static bool IsOSPlatform(OSPlatform osPlatform);
-    }
-    public class SafeArrayRankMismatchException : Exception {
+    public class SafeArrayRankMismatchException : SystemException {
+        protected SafeArrayRankMismatchException(SerializationInfo info, StreamingContext context);
     }
-    public class SafeArrayTypeMismatchException : Exception {
+    public class SafeArrayTypeMismatchException : SystemException {
+        protected SafeArrayTypeMismatchException(SerializationInfo info, StreamingContext context);
     }
-    public abstract class SafeBuffer : SafeHandle {
+    public abstract class SafeBuffer : SafeHandleZeroOrMinusOneIsInvalid {
-        public override bool IsInvalid { get; }
     }
-    public abstract class SafeHandle : IDisposable {
+    public abstract class SafeHandle : CriticalFinalizerObject, IDisposable {
+        public void Close();
     }
-    public class SEHException : Exception {
+    public class SEHException : ExternalException {
+        protected SEHException(SerializationInfo info, StreamingContext context);
     }
     public sealed class StructLayoutAttribute : Attribute {
+        public StructLayoutAttribute(short layoutKind);
     }
     public enum UnmanagedType {
+        CustomMarshaler = 44,
     }
 }
 namespace System.Runtime.InteropServices.ComTypes {
+    public interface IDataObject {
+        int DAdvise(ref FORMATETC pFormatetc, ADVF advf, IAdviseSink adviseSink, out int connection);
+        void DUnadvise(int connection);
+        int EnumDAdvise(out IEnumSTATDATA enumAdvise);
+        IEnumFORMATETC EnumFormatEtc(DATADIR direction);
+        int GetCanonicalFormatEtc(ref FORMATETC formatIn, out FORMATETC formatOut);
+        void GetData(ref FORMATETC format, out STGMEDIUM medium);
+        void GetDataHere(ref FORMATETC format, ref STGMEDIUM medium);
+        int QueryGetData(ref FORMATETC format);
+        void SetData(ref FORMATETC formatIn, ref STGMEDIUM medium, bool release);
+    }
+    public interface IEnumSTATDATA {
+        void Clone(out IEnumSTATDATA newEnum);
+        int Next(int celt, STATDATA[] rgelt, int[] pceltFetched);
+        int Reset();
+        int Skip(int celt);
+    }
 }
+namespace System.Runtime.Remoting.Messaging {
+    public class Header {
+        public string HeaderNamespace;
+        public bool MustUnderstand;
+        public string Name;
+        public object Value;
+        public Header(string _Name, object _Value);
+        public Header(string _Name, object _Value, bool _MustUnderstand);
+        public Header(string _Name, object _Value, bool _MustUnderstand, string _HeaderNamespace);
+    }
+    public delegate object HeaderHandler(Header[] headers); {
+        public HeaderHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(Header[] headers, AsyncCallback callback, object @object);
+        public virtual object EndInvoke(IAsyncResult result);
+        public virtual object Invoke(Header[] headers);
+    }
+    public interface IMessage {
+        IDictionary Properties { get; }
+    }
+    public interface IMethodCallMessage : IMessage, IMethodMessage {
+        int InArgCount { get; }
+        object[] InArgs { get; }
+        object GetInArg(int argNum);
+        string GetInArgName(int index);
+    }
+    public interface IMethodMessage : IMessage {
+        int ArgCount { get; }
+        object[] Args { get; }
+        bool HasVarArgs { get; }
+        LogicalCallContext LogicalCallContext { get; }
+        MethodBase MethodBase { get; }
+        string MethodName { get; }
+        object MethodSignature { get; }
+        string TypeName { get; }
+        string Uri { get; }
+        object GetArg(int argNum);
+        string GetArgName(int index);
+    }
+    public interface IRemotingFormatter : IFormatter {
+        object Deserialize(Stream serializationStream, HeaderHandler handler);
+        void Serialize(Stream serializationStream, object graph, Header[] headers);
+    }
+    public sealed class LogicalCallContext : ICloneable, ISerializable {
+        public bool HasInfo { get; }
+        public object Clone();
+        public void FreeNamedDataSlot(string name);
+        public object GetData(string name);
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        public void SetData(string name, object data);
+    }
+}
+namespace System.Runtime.Serialization {
+    public sealed class CollectionDataContractAttribute : Attribute {
+        public CollectionDataContractAttribute();
+        public bool IsItemNameSetExplicitly { get; }
+        public bool IsKeyNameSetExplicitly { get; }
+        public bool IsNameSetExplicitly { get; }
+        public bool IsNamespaceSetExplicitly { get; }
+        public bool IsReference { get; set; }
+        public bool IsReferenceSetExplicitly { get; }
+        public bool IsValueNameSetExplicitly { get; }
+        public string ItemName { get; set; }
+        public string KeyName { get; set; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public string ValueName { get; set; }
+    }
+    public sealed class ContractNamespaceAttribute : Attribute {
+        public ContractNamespaceAttribute(string contractNamespace);
+        public string ClrNamespace { get; set; }
+        public string ContractNamespace { get; }
+    }
+    public sealed class DataContractAttribute : Attribute {
+        public DataContractAttribute();
+        public bool IsNameSetExplicitly { get; }
+        public bool IsNamespaceSetExplicitly { get; }
+        public bool IsReference { get; set; }
+        public bool IsReferenceSetExplicitly { get; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+    }
+    public abstract class DataContractResolver {
+        protected DataContractResolver();
+        public abstract Type ResolveName(string typeName, string typeNamespace, Type declaredType, DataContractResolver knownTypeResolver);
+        public abstract bool TryResolveType(Type type, Type declaredType, DataContractResolver knownTypeResolver, out XmlDictionaryString typeName, out XmlDictionaryString typeNamespace);
+    }
+    public sealed class DataContractSerializer : XmlObjectSerializer {
+        public DataContractSerializer(Type type);
+        public DataContractSerializer(Type type, DataContractSerializerSettings settings);
+        public DataContractSerializer(Type type, IEnumerable<Type> knownTypes);
+        public DataContractSerializer(Type type, string rootName, string rootNamespace);
+        public DataContractSerializer(Type type, string rootName, string rootNamespace, IEnumerable<Type> knownTypes);
+        public DataContractSerializer(Type type, XmlDictionaryString rootName, XmlDictionaryString rootNamespace);
+        public DataContractSerializer(Type type, XmlDictionaryString rootName, XmlDictionaryString rootNamespace, IEnumerable<Type> knownTypes);
+        public DataContractResolver DataContractResolver { get; }
+        public bool IgnoreExtensionDataObject { get; }
+        public ReadOnlyCollection<Type> KnownTypes { get; }
+        public int MaxItemsInObjectGraph { get; }
+        public bool PreserveObjectReferences { get; }
+        public bool SerializeReadOnlyTypes { get; }
+        public override bool IsStartObject(XmlDictionaryReader reader);
+        public override bool IsStartObject(XmlReader reader);
+        public override object ReadObject(XmlDictionaryReader reader, bool verifyObjectName);
+        public object ReadObject(XmlDictionaryReader reader, bool verifyObjectName, DataContractResolver dataContractResolver);
+        public override object ReadObject(XmlReader reader);
+        public override object ReadObject(XmlReader reader, bool verifyObjectName);
+        public override void WriteEndObject(XmlDictionaryWriter writer);
+        public override void WriteEndObject(XmlWriter writer);
+        public void WriteObject(XmlDictionaryWriter writer, object graph, DataContractResolver dataContractResolver);
+        public override void WriteObject(XmlWriter writer, object graph);
+        public override void WriteObjectContent(XmlDictionaryWriter writer, object graph);
+        public override void WriteObjectContent(XmlWriter writer, object graph);
+        public override void WriteStartObject(XmlDictionaryWriter writer, object graph);
+        public override void WriteStartObject(XmlWriter writer, object graph);
+    }
+    public class DataContractSerializerSettings {
+        public DataContractSerializerSettings();
+        public DataContractResolver DataContractResolver { get; set; }
+        public bool IgnoreExtensionDataObject { get; set; }
+        public IEnumerable<Type> KnownTypes { get; set; }
+        public int MaxItemsInObjectGraph { get; set; }
+        public bool PreserveObjectReferences { get; set; }
+        public XmlDictionaryString RootName { get; set; }
+        public XmlDictionaryString RootNamespace { get; set; }
+        public bool SerializeReadOnlyTypes { get; set; }
+    }
+    public sealed class DataMemberAttribute : Attribute {
+        public DataMemberAttribute();
+        public bool EmitDefaultValue { get; set; }
+        public bool IsNameSetExplicitly { get; }
+        public bool IsRequired { get; set; }
+        public string Name { get; set; }
+        public int Order { get; set; }
+    }
+    public class DateTimeFormat {
+        public DateTimeFormat(string formatString);
+        public DateTimeFormat(string formatString, IFormatProvider formatProvider);
+        public DateTimeStyles DateTimeStyles { get; set; }
+        public IFormatProvider FormatProvider { get; }
+        public string FormatString { get; }
+    }
+    public enum EmitTypeInformation {
+        Always = 1,
+        AsNeeded = 0,
+        Never = 2,
+    }
+    public sealed class EnumMemberAttribute : Attribute {
+        public EnumMemberAttribute();
+        public bool IsValueSetExplicitly { get; }
+        public string Value { get; set; }
+    }
+    public class ExportOptions {
+        public ExportOptions();
+        public Collection<Type> KnownTypes { get; }
+    }
+    public sealed class ExtensionDataObject
+    public abstract class Formatter : IFormatter {
+        protected ObjectIDGenerator m_idGenerator;
+        protected Queue m_objectQueue;
+        protected Formatter();
+        public abstract SerializationBinder Binder { get; set; }
+        public abstract StreamingContext Context { get; set; }
+        public abstract ISurrogateSelector SurrogateSelector { get; set; }
+        public abstract object Deserialize(Stream serializationStream);
+        protected virtual object GetNext(out long objID);
+        protected virtual long Schedule(object obj);
+        public abstract void Serialize(Stream serializationStream, object graph);
+        protected abstract void WriteArray(object obj, string name, Type memberType);
+        protected abstract void WriteBoolean(bool val, string name);
+        protected abstract void WriteByte(byte val, string name);
+        protected abstract void WriteChar(char val, string name);
+        protected abstract void WriteDateTime(DateTime val, string name);
+        protected abstract void WriteDecimal(decimal val, string name);
+        protected abstract void WriteDouble(double val, string name);
+        protected abstract void WriteInt16(short val, string name);
+        protected abstract void WriteInt32(int val, string name);
+        protected abstract void WriteInt64(long val, string name);
+        protected virtual void WriteMember(string memberName, object data);
+        protected abstract void WriteObjectRef(object obj, string name, Type memberType);
+        protected abstract void WriteSByte(sbyte val, string name);
+        protected abstract void WriteSingle(float val, string name);
+        protected abstract void WriteTimeSpan(TimeSpan val, string name);
+        protected abstract void WriteUInt16(ushort val, string name);
+        protected abstract void WriteUInt32(uint val, string name);
+        protected abstract void WriteUInt64(ulong val, string name);
+        protected abstract void WriteValueType(object obj, string name, Type memberType);
+    }
+    public class FormatterConverter : IFormatterConverter {
+        public FormatterConverter();
+        public object Convert(object value, Type type);
+        public object Convert(object value, TypeCode typeCode);
+        public bool ToBoolean(object value);
+        public byte ToByte(object value);
+        public char ToChar(object value);
+        public DateTime ToDateTime(object value);
+        public decimal ToDecimal(object value);
+        public double ToDouble(object value);
+        public short ToInt16(object value);
+        public int ToInt32(object value);
+        public long ToInt64(object value);
+        public sbyte ToSByte(object value);
+        public float ToSingle(object value);
+        public string ToString(object value);
+        public ushort ToUInt16(object value);
+        public uint ToUInt32(object value);
+        public ulong ToUInt64(object value);
+    }
+    public static class FormatterServices {
+        public static void CheckTypeSecurity(Type t, TypeFilterLevel securityLevel);
+        public static object[] GetObjectData(object obj, MemberInfo[] members);
+        public static object GetSafeUninitializedObject(Type type);
+        public static MemberInfo[] GetSerializableMembers(Type type);
+        public static MemberInfo[] GetSerializableMembers(Type type, StreamingContext context);
+        public static ISerializationSurrogate GetSurrogateForCyclicalReference(ISerializationSurrogate innerSurrogate);
+        public static Type GetTypeFromAssembly(Assembly assem, string name);
+        public static object GetUninitializedObject(Type type);
+        public static object PopulateObjectMembers(object obj, MemberInfo[] members, object[] data);
+    }
+    public interface IDeserializationCallback {
+        void OnDeserialization(object sender);
+    }
+    public interface IExtensibleDataObject {
+        ExtensionDataObject ExtensionData { get; set; }
+    }
+    public interface IFormatter {
+        SerializationBinder Binder { get; set; }
+        StreamingContext Context { get; set; }
+        ISurrogateSelector SurrogateSelector { get; set; }
+        object Deserialize(Stream serializationStream);
+        void Serialize(Stream serializationStream, object graph);
+    }
+    public interface IFormatterConverter {
+        object Convert(object value, Type type);
+        object Convert(object value, TypeCode typeCode);
+        bool ToBoolean(object value);
+        byte ToByte(object value);
+        char ToChar(object value);
+        DateTime ToDateTime(object value);
+        decimal ToDecimal(object value);
+        double ToDouble(object value);
+        short ToInt16(object value);
+        int ToInt32(object value);
+        long ToInt64(object value);
+        sbyte ToSByte(object value);
+        float ToSingle(object value);
+        string ToString(object value);
+        ushort ToUInt16(object value);
+        uint ToUInt32(object value);
+        ulong ToUInt64(object value);
+    }
+    public sealed class IgnoreDataMemberAttribute : Attribute {
+        public IgnoreDataMemberAttribute();
+    }
+    public class InvalidDataContractException : Exception {
+        public InvalidDataContractException();
+        protected InvalidDataContractException(SerializationInfo info, StreamingContext context);
+        public InvalidDataContractException(string message);
+        public InvalidDataContractException(string message, Exception innerException);
+    }
+    public interface IObjectReference {
+        object GetRealObject(StreamingContext context);
+    }
+    public interface ISafeSerializationData {
+        void CompleteDeserialization(object deserialized);
+    }
+    public interface ISerializable {
+        void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public interface ISerializationSurrogate {
+        void GetObjectData(object obj, SerializationInfo info, StreamingContext context);
+        object SetObjectData(object obj, SerializationInfo info, StreamingContext context, ISurrogateSelector selector);
+    }
+    public interface ISurrogateSelector {
+        void ChainSelector(ISurrogateSelector selector);
+        ISurrogateSelector GetNextSelector();
+        ISerializationSurrogate GetSurrogate(Type type, StreamingContext context, out ISurrogateSelector selector);
+    }
+    public sealed class KnownTypeAttribute : Attribute {
+        public KnownTypeAttribute(string methodName);
+        public KnownTypeAttribute(Type type);
+        public string MethodName { get; }
+        public Type Type { get; }
+    }
+    public class ObjectIDGenerator {
+        public ObjectIDGenerator();
+        public virtual long GetId(object obj, out bool firstTime);
+        public virtual long HasId(object obj, out bool firstTime);
+    }
+    public class ObjectManager {
+        public ObjectManager(ISurrogateSelector selector, StreamingContext context);
+        public virtual void DoFixups();
+        public virtual object GetObject(long objectID);
+        public virtual void RaiseDeserializationEvent();
+        public void RaiseOnDeserializingEvent(object obj);
+        public virtual void RecordArrayElementFixup(long arrayToBeFixed, int index, long objectRequired);
+        public virtual void RecordArrayElementFixup(long arrayToBeFixed, int[] indices, long objectRequired);
+        public virtual void RecordDelayedFixup(long objectToBeFixed, string memberName, long objectRequired);
+        public virtual void RecordFixup(long objectToBeFixed, MemberInfo member, long objectRequired);
+        public virtual void RegisterObject(object obj, long objectID);
+        public void RegisterObject(object obj, long objectID, SerializationInfo info);
+        public void RegisterObject(object obj, long objectID, SerializationInfo info, long idOfContainingObj, MemberInfo member);
+        public void RegisterObject(object obj, long objectID, SerializationInfo info, long idOfContainingObj, MemberInfo member, int[] arrayIndex);
+    }
+    public sealed class OnDeserializedAttribute : Attribute {
+        public OnDeserializedAttribute();
+    }
+    public sealed class OnDeserializingAttribute : Attribute {
+        public OnDeserializingAttribute();
+    }
+    public sealed class OnSerializedAttribute : Attribute {
+        public OnSerializedAttribute();
+    }
+    public sealed class OnSerializingAttribute : Attribute {
+        public OnSerializingAttribute();
+    }
+    public sealed class OptionalFieldAttribute : Attribute {
+        public OptionalFieldAttribute();
+        public int VersionAdded { get; set; }
+    }
+    public sealed class SafeSerializationEventArgs : EventArgs {
+        public StreamingContext StreamingContext { get; }
+        public void AddSerializedState(ISafeSerializationData serializedState);
+    }
+    public abstract class SerializationBinder {
+        protected SerializationBinder();
+        public virtual void BindToName(Type serializedType, out string assemblyName, out string typeName);
+        public abstract Type BindToType(string assemblyName, string typeName);
+    }
+    public struct SerializationEntry {
+        public string Name { get; }
+        public Type ObjectType { get; }
+        public object Value { get; }
+    }
+    public class SerializationException : SystemException {
+        public SerializationException();
+        protected SerializationException(SerializationInfo info, StreamingContext context);
+        public SerializationException(string message);
+        public SerializationException(string message, Exception innerException);
+    }
+    public sealed class SerializationInfo {
+        public SerializationInfo(Type type, IFormatterConverter converter);
+        public SerializationInfo(Type type, IFormatterConverter converter, bool requireSameTokenInPartialTrust);
+        public string AssemblyName { get; set; }
+        public string FullTypeName { get; set; }
+        public bool IsAssemblyNameSetExplicit { get; }
+        public bool IsFullTypeNameSetExplicit { get; }
+        public int MemberCount { get; }
+        public Type ObjectType { get; }
+        public void AddValue(string name, bool value);
+        public void AddValue(string name, byte value);
+        public void AddValue(string name, char value);
+        public void AddValue(string name, DateTime value);
+        public void AddValue(string name, decimal value);
+        public void AddValue(string name, double value);
+        public void AddValue(string name, short value);
+        public void AddValue(string name, int value);
+        public void AddValue(string name, long value);
+        public void AddValue(string name, object value);
+        public void AddValue(string name, object value, Type type);
+        public void AddValue(string name, sbyte value);
+        public void AddValue(string name, float value);
+        public void AddValue(string name, ushort value);
+        public void AddValue(string name, uint value);
+        public void AddValue(string name, ulong value);
+        public bool GetBoolean(string name);
+        public byte GetByte(string name);
+        public char GetChar(string name);
+        public DateTime GetDateTime(string name);
+        public decimal GetDecimal(string name);
+        public double GetDouble(string name);
+        public SerializationInfoEnumerator GetEnumerator();
+        public short GetInt16(string name);
+        public int GetInt32(string name);
+        public long GetInt64(string name);
+        public sbyte GetSByte(string name);
+        public float GetSingle(string name);
+        public string GetString(string name);
+        public ushort GetUInt16(string name);
+        public uint GetUInt32(string name);
+        public ulong GetUInt64(string name);
+        public object GetValue(string name, Type type);
+        public void SetType(Type type);
+    }
+    public sealed class SerializationInfoEnumerator : IEnumerator {
+        public SerializationEntry Current { get; }
+        public string Name { get; }
+        public Type ObjectType { get; }
+        public object Value { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public sealed class SerializationObjectManager {
+        public SerializationObjectManager(StreamingContext context);
+        public void RaiseOnSerializedEvent();
+        public void RegisterObject(object obj);
+    }
+    public struct StreamingContext {
+        public StreamingContext(StreamingContextStates state);
+        public StreamingContext(StreamingContextStates state, object additional);
+        public object Context { get; }
+        public StreamingContextStates State { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+    }
+    public enum StreamingContextStates {
+        All = 255,
+        Clone = 64,
+        CrossAppDomain = 128,
+        CrossMachine = 2,
+        CrossProcess = 1,
+        File = 4,
+        Other = 32,
+        Persistence = 8,
+        Remoting = 16,
+    }
+    public class SurrogateSelector : ISurrogateSelector {
+        public SurrogateSelector();
+        public virtual void AddSurrogate(Type type, StreamingContext context, ISerializationSurrogate surrogate);
+        public virtual void ChainSelector(ISurrogateSelector selector);
+        public virtual ISurrogateSelector GetNextSelector();
+        public virtual ISerializationSurrogate GetSurrogate(Type type, StreamingContext context, out ISurrogateSelector selector);
+        public virtual void RemoveSurrogate(Type type, StreamingContext context);
+    }
+    public abstract class XmlObjectSerializer {
+        protected XmlObjectSerializer();
+        public abstract bool IsStartObject(XmlDictionaryReader reader);
+        public virtual bool IsStartObject(XmlReader reader);
+        public virtual object ReadObject(Stream stream);
+        public virtual object ReadObject(XmlDictionaryReader reader);
+        public abstract object ReadObject(XmlDictionaryReader reader, bool verifyObjectName);
+        public virtual object ReadObject(XmlReader reader);
+        public virtual object ReadObject(XmlReader reader, bool verifyObjectName);
+        public abstract void WriteEndObject(XmlDictionaryWriter writer);
+        public virtual void WriteEndObject(XmlWriter writer);
+        public virtual void WriteObject(Stream stream, object graph);
+        public virtual void WriteObject(XmlDictionaryWriter writer, object graph);
+        public virtual void WriteObject(XmlWriter writer, object graph);
+        public abstract void WriteObjectContent(XmlDictionaryWriter writer, object graph);
+        public virtual void WriteObjectContent(XmlWriter writer, object graph);
+        public abstract void WriteStartObject(XmlDictionaryWriter writer, object graph);
+        public virtual void WriteStartObject(XmlWriter writer, object graph);
+    }
+    public static class XmlSerializableServices {
+        public static void AddDefaultSchema(XmlSchemaSet schemas, XmlQualifiedName typeQName);
+        public static XmlNode[] ReadNodes(XmlReader xmlReader);
+        public static void WriteNodes(XmlWriter xmlWriter, XmlNode[] nodes);
+    }
+    public static class XPathQueryGenerator {
+        public static string CreateFromDataContractSerializer(Type type, MemberInfo[] pathToMember, StringBuilder rootElementXpath, out XmlNamespaceManager namespaces);
+        public static string CreateFromDataContractSerializer(Type type, MemberInfo[] pathToMember, out XmlNamespaceManager namespaces);
+    }
+    public class XsdDataContractExporter {
+        public XsdDataContractExporter();
+        public XsdDataContractExporter(XmlSchemaSet schemas);
+        public ExportOptions Options { get; set; }
+        public XmlSchemaSet Schemas { get; }
+        public bool CanExport(ICollection<Type> types);
+        public bool CanExport(ICollection<Assembly> assemblies);
+        public bool CanExport(Type type);
+        public void Export(ICollection<Type> types);
+        public void Export(ICollection<Assembly> assemblies);
+        public void Export(Type type);
+        public XmlQualifiedName GetRootElementName(Type type);
+        public XmlSchemaType GetSchemaType(Type type);
+        public XmlQualifiedName GetSchemaTypeName(Type type);
+    }
+}
+namespace System.Runtime.Serialization.Formatters {
+    public enum FormatterAssemblyStyle {
+        Full = 1,
+        Simple = 0,
+    }
+    public enum FormatterTypeStyle {
+        TypesAlways = 1,
+        TypesWhenNeeded = 0,
+        XsdString = 2,
+    }
+    public enum TypeFilterLevel {
+        Full = 3,
+        Low = 2,
+    }
+}
+namespace System.Runtime.Serialization.Formatters.Binary {
+    public sealed class BinaryFormatter : IFormatter, IRemotingFormatter {
+        public BinaryFormatter();
+        public BinaryFormatter(ISurrogateSelector selector, StreamingContext context);
+        public FormatterAssemblyStyle AssemblyFormat { get; set; }
+        public SerializationBinder Binder { get; set; }
+        public StreamingContext Context { get; set; }
+        public TypeFilterLevel FilterLevel { get; set; }
+        public ISurrogateSelector SurrogateSelector { get; set; }
+        public FormatterTypeStyle TypeFormat { get; set; }
+        public object Deserialize(Stream serializationStream);
+        public object Deserialize(Stream serializationStream, HeaderHandler handler);
+        public object DeserializeMethodResponse(Stream serializationStream, HeaderHandler handler, IMethodCallMessage methodCallMessage);
+        public void Serialize(Stream serializationStream, object graph);
+        public void Serialize(Stream serializationStream, object graph, Header[] headers);
+        public object UnsafeDeserialize(Stream serializationStream, HeaderHandler handler);
+        public object UnsafeDeserializeMethodResponse(Stream serializationStream, HeaderHandler handler, IMethodCallMessage methodCallMessage);
+    }
+}
+namespace System.Runtime.Serialization.Json {
+    public sealed class DataContractJsonSerializer : XmlObjectSerializer {
+        public DataContractJsonSerializer(Type type);
+        public DataContractJsonSerializer(Type type, DataContractJsonSerializerSettings settings);
+        public DataContractJsonSerializer(Type type, IEnumerable<Type> knownTypes);
+        public DataContractJsonSerializer(Type type, string rootName);
+        public DataContractJsonSerializer(Type type, string rootName, IEnumerable<Type> knownTypes);
+        public DataContractJsonSerializer(Type type, XmlDictionaryString rootName);
+        public DataContractJsonSerializer(Type type, XmlDictionaryString rootName, IEnumerable<Type> knownTypes);
+        public DateTimeFormat DateTimeFormat { get; }
+        public EmitTypeInformation EmitTypeInformation { get; }
+        public bool IgnoreExtensionDataObject { get; }
+        public ReadOnlyCollection<Type> KnownTypes { get; }
+        public int MaxItemsInObjectGraph { get; }
+        public bool SerializeReadOnlyTypes { get; }
+        public bool UseSimpleDictionaryFormat { get; }
+        public override bool IsStartObject(XmlDictionaryReader reader);
+        public override bool IsStartObject(XmlReader reader);
+        public override object ReadObject(Stream stream);
+        public override object ReadObject(XmlDictionaryReader reader);
+        public override object ReadObject(XmlDictionaryReader reader, bool verifyObjectName);
+        public override object ReadObject(XmlReader reader);
+        public override object ReadObject(XmlReader reader, bool verifyObjectName);
+        public override void WriteEndObject(XmlDictionaryWriter writer);
+        public override void WriteEndObject(XmlWriter writer);
+        public override void WriteObject(Stream stream, object graph);
+        public override void WriteObject(XmlDictionaryWriter writer, object graph);
+        public override void WriteObject(XmlWriter writer, object graph);
+        public override void WriteObjectContent(XmlDictionaryWriter writer, object graph);
+        public override void WriteObjectContent(XmlWriter writer, object graph);
+        public override void WriteStartObject(XmlDictionaryWriter writer, object graph);
+        public override void WriteStartObject(XmlWriter writer, object graph);
+    }
+    public class DataContractJsonSerializerSettings {
+        public DataContractJsonSerializerSettings();
+        public DateTimeFormat DateTimeFormat { get; set; }
+        public EmitTypeInformation EmitTypeInformation { get; set; }
+        public bool IgnoreExtensionDataObject { get; set; }
+        public IEnumerable<Type> KnownTypes { get; set; }
+        public int MaxItemsInObjectGraph { get; set; }
+        public string RootName { get; set; }
+        public bool SerializeReadOnlyTypes { get; set; }
+        public bool UseSimpleDictionaryFormat { get; set; }
+    }
+    public interface IXmlJsonReaderInitializer {
+        void SetInput(byte[] buffer, int offset, int count, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+        void SetInput(Stream stream, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+    }
+    public interface IXmlJsonWriterInitializer {
+        void SetOutput(Stream stream, Encoding encoding, bool ownsStream);
+    }
+    public static class JsonReaderWriterFactory {
+        public static XmlDictionaryReader CreateJsonReader(byte[] buffer, int offset, int count, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateJsonReader(byte[] buffer, int offset, int count, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateJsonReader(byte[] buffer, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateJsonReader(Stream stream, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateJsonReader(Stream stream, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryWriter CreateJsonWriter(Stream stream);
+        public static XmlDictionaryWriter CreateJsonWriter(Stream stream, Encoding encoding);
+        public static XmlDictionaryWriter CreateJsonWriter(Stream stream, Encoding encoding, bool ownsStream);
+        public static XmlDictionaryWriter CreateJsonWriter(Stream stream, Encoding encoding, bool ownsStream, bool indent);
+        public static XmlDictionaryWriter CreateJsonWriter(Stream stream, Encoding encoding, bool ownsStream, bool indent, string indentChars);
+    }
+}
 namespace System.Runtime.Versioning {
+    public sealed class ComponentGuaranteesAttribute : Attribute {
+        public ComponentGuaranteesAttribute(ComponentGuaranteesOptions guarantees);
+        public ComponentGuaranteesOptions Guarantees { get; }
+    }
+    public enum ComponentGuaranteesOptions {
+        Exchange = 1,
+        None = 0,
+        SideBySide = 4,
+        Stable = 2,
+    }
+    public sealed class ResourceConsumptionAttribute : Attribute {
+        public ResourceConsumptionAttribute(ResourceScope resourceScope);
+        public ResourceConsumptionAttribute(ResourceScope resourceScope, ResourceScope consumptionScope);
+        public ResourceScope ConsumptionScope { get; }
+        public ResourceScope ResourceScope { get; }
+    }
+    public sealed class ResourceExposureAttribute : Attribute {
+        public ResourceExposureAttribute(ResourceScope exposureLevel);
+        public ResourceScope ResourceExposureLevel { get; }
+    }
+    public enum ResourceScope {
+        AppDomain = 4,
+        Assembly = 32,
+        Library = 8,
+        Machine = 1,
+        None = 0,
+        Private = 16,
+        Process = 2,
+    }
+    public static class VersioningHelper {
+        public static string MakeVersionSafeName(string name, ResourceScope from, ResourceScope to);
+        public static string MakeVersionSafeName(string name, ResourceScope from, ResourceScope to, Type type);
+    }
 }
 namespace System.Security {
     public sealed class AllowPartiallyTrustedCallersAttribute : Attribute {
+        public PartialTrustVisibilityLevel PartialTrustVisibilityLevel { get; set; }
     }
+    public interface IPermission : ISecurityEncodable {
+        IPermission Copy();
+        void Demand();
+        IPermission Intersect(IPermission target);
+        bool IsSubsetOf(IPermission target);
+        IPermission Union(IPermission target);
+    }
+    public interface ISecurityEncodable {
+        void FromXml(SecurityElement e);
+        SecurityElement ToXml();
+    }
+    public enum PartialTrustVisibilityLevel {
+        NotVisibleByDefault = 1,
+        VisibleToAllHosts = 0,
+    }
+    public sealed class SecureString : IDisposable {
+        public SecureString();
+        public unsafe SecureString(char* value, int length);
+        public int Length { get; }
+        public void AppendChar(char c);
+        public void Clear();
+        public SecureString Copy();
+        public void Dispose();
+        public void InsertAt(int index, char c);
+        public bool IsReadOnly();
+        public void MakeReadOnly();
+        public void RemoveAt(int index);
+        public void SetAt(int index, char c);
+    }
     public sealed class SecurityCriticalAttribute : Attribute {
+        public SecurityCriticalAttribute(SecurityCriticalScope scope);
+        public SecurityCriticalScope Scope { get; }
     }
+    public enum SecurityCriticalScope {
+        Everything = 1,
+        Explicit = 0,
+    }
+    public sealed class SecurityElement {
+        public SecurityElement(string tag);
+        public SecurityElement(string tag, string text);
+        public Hashtable Attributes { get; set; }
+        public ArrayList Children { get; set; }
+        public string Tag { get; set; }
+        public string Text { get; set; }
+        public void AddAttribute(string name, string value);
+        public void AddChild(SecurityElement child);
+        public string Attribute(string name);
+        public SecurityElement Copy();
+        public bool Equal(SecurityElement other);
+        public static string Escape(string str);
+        public static SecurityElement FromString(string xml);
+        public static bool IsValidAttributeName(string name);
+        public static bool IsValidAttributeValue(string value);
+        public static bool IsValidTag(string tag);
+        public static bool IsValidText(string text);
+        public SecurityElement SearchForChildByTag(string tag);
+        public string SearchForTextOfTag(string tag);
+        public override string ToString();
+    }
-    public class SecurityException : Exception {
+    public class SecurityException : SystemException {
+        protected SecurityException(SerializationInfo info, StreamingContext context);
+        public SecurityException(string message, Type type);
+        public SecurityException(string message, Type type, string state);
+        public object Demanded { get; set; }
+        public object DenySetInstance { get; set; }
+        public AssemblyName FailedAssemblyInfo { get; set; }
+        public string GrantedSet { get; set; }
+        public MethodInfo Method { get; set; }
+        public string PermissionState { get; set; }
+        public Type PermissionType { get; set; }
+        public object PermitOnlySetInstance { get; set; }
+        public string RefusedSet { get; set; }
+        public string Url { get; set; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public sealed class SecurityRulesAttribute : Attribute {
+        public SecurityRulesAttribute(SecurityRuleSet ruleSet);
+        public SecurityRuleSet RuleSet { get; }
+        public bool SkipVerificationInFullTrust { get; set; }
+    }
+    public enum SecurityRuleSet : byte {
+        Level1 = (byte)1,
+        Level2 = (byte)2,
+        None = (byte)0,
+    }
+    public sealed class SecurityTreatAsSafeAttribute : Attribute {
+        public SecurityTreatAsSafeAttribute();
+    }
+    public sealed class SuppressUnmanagedCodeSecurityAttribute : Attribute {
+        public SuppressUnmanagedCodeSecurityAttribute();
+    }
+    public sealed class UnverifiableCodeAttribute : Attribute {
+        public UnverifiableCodeAttribute();
+    }
-    public class VerificationException : Exception {
+    public class VerificationException : SystemException {
+        protected VerificationException(SerializationInfo info, StreamingContext context);
     }
 }
 namespace System.Security.Authentication {
+    public class AuthenticationException : SystemException {
+        public AuthenticationException();
+        protected AuthenticationException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public AuthenticationException(string message);
+        public AuthenticationException(string message, Exception innerException);
+    }
+    public class InvalidCredentialException : AuthenticationException {
+        public InvalidCredentialException();
+        protected InvalidCredentialException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        public InvalidCredentialException(string message);
+        public InvalidCredentialException(string message, Exception innerException);
+    }
     public enum SslProtocols {
+        Default = 240,
     }
 }
 namespace System.Security.Authentication.ExtendedProtection {
-    public abstract class ChannelBinding : SafeHandle {
+    public abstract class ChannelBinding : SafeHandleZeroOrMinusOneIsInvalid {
     }
+    public class ExtendedProtectionPolicy : ISerializable {
+        public ExtendedProtectionPolicy(PolicyEnforcement policyEnforcement);
+        public ExtendedProtectionPolicy(PolicyEnforcement policyEnforcement, ChannelBinding customChannelBinding);
+        public ExtendedProtectionPolicy(PolicyEnforcement policyEnforcement, ProtectionScenario protectionScenario, ICollection customServiceNames);
+        public ExtendedProtectionPolicy(PolicyEnforcement policyEnforcement, ProtectionScenario protectionScenario, ServiceNameCollection customServiceNames);
+        protected ExtendedProtectionPolicy(SerializationInfo info, StreamingContext context);
+        public ChannelBinding CustomChannelBinding { get; }
+        public ServiceNameCollection CustomServiceNames { get; }
+        public static bool OSSupportsExtendedProtection { get; }
+        public PolicyEnforcement PolicyEnforcement { get; }
+        public ProtectionScenario ProtectionScenario { get; }
+        public override string ToString();
+    }
+    public class ExtendedProtectionPolicyTypeConverter : TypeConverter {
+        public ExtendedProtectionPolicyTypeConverter();
+        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+    }
+    public enum PolicyEnforcement {
+        Always = 2,
+        Never = 0,
+        WhenSupported = 1,
+    }
+    public enum ProtectionScenario {
+        TransportSelected = 0,
+        TrustedProxy = 1,
+    }
+    public class ServiceNameCollection : ReadOnlyCollectionBase {
+        public ServiceNameCollection(ICollection items);
+        public bool Contains(string searchServiceName);
+        public ServiceNameCollection Merge(IEnumerable serviceNames);
+        public ServiceNameCollection Merge(string serviceName);
+    }
+    public class TokenBinding {
+        public TokenBindingType BindingType { get; }
+        public byte[] GetRawTokenBindingId();
+    }
+    public enum TokenBindingType {
+        Provided = 0,
+        Referred = 1,
+    }
 }
+namespace System.Security.Claims {
+    public class Claim {
+        public Claim(BinaryReader reader);
+        public Claim(BinaryReader reader, ClaimsIdentity subject);
+        protected Claim(Claim other);
+        protected Claim(Claim other, ClaimsIdentity subject);
+        public Claim(string type, string value);
+        public Claim(string type, string value, string valueType);
+        public Claim(string type, string value, string valueType, string issuer);
+        public Claim(string type, string value, string valueType, string issuer, string originalIssuer);
+        public Claim(string type, string value, string valueType, string issuer, string originalIssuer, ClaimsIdentity subject);
+        protected virtual byte[] CustomSerializationData { get; }
+        public string Issuer { get; }
+        public string OriginalIssuer { get; }
+        public IDictionary<string, string> Properties { get; }
+        public ClaimsIdentity Subject { get; }
+        public string Type { get; }
+        public string Value { get; }
+        public string ValueType { get; }
+        public virtual Claim Clone();
+        public virtual Claim Clone(ClaimsIdentity identity);
+        public override string ToString();
+        public virtual void WriteTo(BinaryWriter writer);
+        protected virtual void WriteTo(BinaryWriter writer, byte[] userData);
+    }
+    public class ClaimsIdentity : IIdentity {
+        public const string DefaultIssuer = "LOCAL AUTHORITY";
+        public const string DefaultNameClaimType = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name";
+        public const string DefaultRoleClaimType = "http://schemas.microsoft.com/ws/2008/06/identity/claims/role";
+        public ClaimsIdentity();
+        public ClaimsIdentity(BinaryReader reader);
+        protected ClaimsIdentity(ClaimsIdentity other);
+        public ClaimsIdentity(IEnumerable<Claim> claims);
+        public ClaimsIdentity(IEnumerable<Claim> claims, string authenticationType);
+        public ClaimsIdentity(IEnumerable<Claim> claims, string authenticationType, string nameType, string roleType);
+        public ClaimsIdentity(IIdentity identity);
+        public ClaimsIdentity(IIdentity identity, IEnumerable<Claim> claims);
+        public ClaimsIdentity(IIdentity identity, IEnumerable<Claim> claims, string authenticationType, string nameType, string roleType);
+        protected ClaimsIdentity(SerializationInfo info);
+        protected ClaimsIdentity(SerializationInfo info, StreamingContext context);
+        public ClaimsIdentity(string authenticationType);
+        public ClaimsIdentity(string authenticationType, string nameType, string roleType);
+        public ClaimsIdentity Actor { get; set; }
+        public virtual string AuthenticationType { get; }
+        public object BootstrapContext { get; set; }
+        public virtual IEnumerable<Claim> Claims { get; }
+        protected virtual byte[] CustomSerializationData { get; }
+        public virtual bool IsAuthenticated { get; }
+        public string Label { get; set; }
+        public virtual string Name { get; }
+        public string NameClaimType { get; }
+        public string RoleClaimType { get; }
+        public virtual void AddClaim(Claim claim);
+        public virtual void AddClaims(IEnumerable<Claim> claims);
+        public virtual ClaimsIdentity Clone();
+        protected virtual Claim CreateClaim(BinaryReader reader);
+        public virtual IEnumerable<Claim> FindAll(Predicate<Claim> match);
+        public virtual IEnumerable<Claim> FindAll(string type);
+        public virtual Claim FindFirst(Predicate<Claim> match);
+        public virtual Claim FindFirst(string type);
+        protected virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public virtual bool HasClaim(Predicate<Claim> match);
+        public virtual bool HasClaim(string type, string value);
+        public virtual void RemoveClaim(Claim claim);
+        public virtual bool TryRemoveClaim(Claim claim);
+        public virtual void WriteTo(BinaryWriter writer);
+        protected virtual void WriteTo(BinaryWriter writer, byte[] userData);
+    }
+    public class ClaimsPrincipal : IPrincipal {
+        public ClaimsPrincipal();
+        public ClaimsPrincipal(BinaryReader reader);
+        public ClaimsPrincipal(IEnumerable<ClaimsIdentity> identities);
+        public ClaimsPrincipal(IIdentity identity);
+        public ClaimsPrincipal(IPrincipal principal);
+        protected ClaimsPrincipal(SerializationInfo info, StreamingContext context);
+        public virtual IEnumerable<Claim> Claims { get; }
+        public static Func<ClaimsPrincipal> ClaimsPrincipalSelector { get; set; }
+        public static ClaimsPrincipal Current { get; }
+        protected virtual byte[] CustomSerializationData { get; }
+        public virtual IEnumerable<ClaimsIdentity> Identities { get; }
+        public virtual IIdentity Identity { get; }
+        public static Func<IEnumerable<ClaimsIdentity>, ClaimsIdentity> PrimaryIdentitySelector { get; set; }
+        public virtual void AddIdentities(IEnumerable<ClaimsIdentity> identities);
+        public virtual void AddIdentity(ClaimsIdentity identity);
+        public virtual ClaimsPrincipal Clone();
+        protected virtual ClaimsIdentity CreateClaimsIdentity(BinaryReader reader);
+        public virtual IEnumerable<Claim> FindAll(Predicate<Claim> match);
+        public virtual IEnumerable<Claim> FindAll(string type);
+        public virtual Claim FindFirst(Predicate<Claim> match);
+        public virtual Claim FindFirst(string type);
+        protected virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        public virtual bool HasClaim(Predicate<Claim> match);
+        public virtual bool HasClaim(string type, string value);
+        public virtual bool IsInRole(string role);
+        public virtual void WriteTo(BinaryWriter writer);
+        protected virtual void WriteTo(BinaryWriter writer, byte[] userData);
+    }
+    public static class ClaimTypes {
+        public const string Actor = "http://schemas.xmlsoap.org/ws/2009/09/identity/claims/actor";
+        public const string Anonymous = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/anonymous";
+        public const string Authentication = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/authentication";
+        public const string AuthenticationInstant = "http://schemas.microsoft.com/ws/2008/06/identity/claims/authenticationinstant";
+        public const string AuthenticationMethod = "http://schemas.microsoft.com/ws/2008/06/identity/claims/authenticationmethod";
+        public const string AuthorizationDecision = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/authorizationdecision";
+        public const string CookiePath = "http://schemas.microsoft.com/ws/2008/06/identity/claims/cookiepath";
+        public const string Country = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country";
+        public const string DateOfBirth = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth";
+        public const string DenyOnlyPrimaryGroupSid = "http://schemas.microsoft.com/ws/2008/06/identity/claims/denyonlyprimarygroupsid";
+        public const string DenyOnlyPrimarySid = "http://schemas.microsoft.com/ws/2008/06/identity/claims/denyonlyprimarysid";
+        public const string DenyOnlySid = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/denyonlysid";
+        public const string DenyOnlyWindowsDeviceGroup = "http://schemas.microsoft.com/ws/2008/06/identity/claims/denyonlywindowsdevicegroup";
+        public const string Dns = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dns";
+        public const string Dsa = "http://schemas.microsoft.com/ws/2008/06/identity/claims/dsa";
+        public const string Email = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress";
+        public const string Expiration = "http://schemas.microsoft.com/ws/2008/06/identity/claims/expiration";
+        public const string Expired = "http://schemas.microsoft.com/ws/2008/06/identity/claims/expired";
+        public const string Gender = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender";
+        public const string GivenName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname";
+        public const string GroupSid = "http://schemas.microsoft.com/ws/2008/06/identity/claims/groupsid";
+        public const string Hash = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/hash";
+        public const string HomePhone = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/homephone";
+        public const string IsPersistent = "http://schemas.microsoft.com/ws/2008/06/identity/claims/ispersistent";
+        public const string Locality = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/locality";
+        public const string MobilePhone = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/mobilephone";
+        public const string Name = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name";
+        public const string NameIdentifier = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier";
+        public const string OtherPhone = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/otherphone";
+        public const string PostalCode = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/postalcode";
+        public const string PrimaryGroupSid = "http://schemas.microsoft.com/ws/2008/06/identity/claims/primarygroupsid";
+        public const string PrimarySid = "http://schemas.microsoft.com/ws/2008/06/identity/claims/primarysid";
+        public const string Role = "http://schemas.microsoft.com/ws/2008/06/identity/claims/role";
+        public const string Rsa = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/rsa";
+        public const string SerialNumber = "http://schemas.microsoft.com/ws/2008/06/identity/claims/serialnumber";
+        public const string Sid = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/sid";
+        public const string Spn = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/spn";
+        public const string StateOrProvince = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/stateorprovince";
+        public const string StreetAddress = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/streetaddress";
+        public const string Surname = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname";
+        public const string System = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/system";
+        public const string Thumbprint = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/thumbprint";
+        public const string Upn = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/upn";
+        public const string Uri = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/uri";
+        public const string UserData = "http://schemas.microsoft.com/ws/2008/06/identity/claims/userdata";
+        public const string Version = "http://schemas.microsoft.com/ws/2008/06/identity/claims/version";
+        public const string Webpage = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage";
+        public const string WindowsAccountName = "http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsaccountname";
+        public const string WindowsDeviceClaim = "http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsdeviceclaim";
+        public const string WindowsDeviceGroup = "http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsdevicegroup";
+        public const string WindowsFqbnVersion = "http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsfqbnversion";
+        public const string WindowsSubAuthority = "http://schemas.microsoft.com/ws/2008/06/identity/claims/windowssubauthority";
+        public const string WindowsUserClaim = "http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsuserclaim";
+        public const string X500DistinguishedName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/x500distinguishedname";
+    }
+    public static class ClaimValueTypes {
+        public const string Base64Binary = "http://www.w3.org/2001/XMLSchema#base64Binary";
+        public const string Base64Octet = "http://www.w3.org/2001/XMLSchema#base64Octet";
+        public const string Boolean = "http://www.w3.org/2001/XMLSchema#boolean";
+        public const string Date = "http://www.w3.org/2001/XMLSchema#date";
+        public const string DateTime = "http://www.w3.org/2001/XMLSchema#dateTime";
+        public const string DaytimeDuration = "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration";
+        public const string DnsName = "http://schemas.xmlsoap.org/claims/dns";
+        public const string Double = "http://www.w3.org/2001/XMLSchema#double";
+        public const string DsaKeyValue = "http://www.w3.org/2000/09/xmldsig#DSAKeyValue";
+        public const string Email = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress";
+        public const string Fqbn = "http://www.w3.org/2001/XMLSchema#fqbn";
+        public const string HexBinary = "http://www.w3.org/2001/XMLSchema#hexBinary";
+        public const string Integer = "http://www.w3.org/2001/XMLSchema#integer";
+        public const string Integer32 = "http://www.w3.org/2001/XMLSchema#integer32";
+        public const string Integer64 = "http://www.w3.org/2001/XMLSchema#integer64";
+        public const string KeyInfo = "http://www.w3.org/2000/09/xmldsig#KeyInfo";
+        public const string Rfc822Name = "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name";
+        public const string Rsa = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/rsa";
+        public const string RsaKeyValue = "http://www.w3.org/2000/09/xmldsig#RSAKeyValue";
+        public const string Sid = "http://www.w3.org/2001/XMLSchema#sid";
+        public const string String = "http://www.w3.org/2001/XMLSchema#string";
+        public const string Time = "http://www.w3.org/2001/XMLSchema#time";
+        public const string UInteger32 = "http://www.w3.org/2001/XMLSchema#uinteger32";
+        public const string UInteger64 = "http://www.w3.org/2001/XMLSchema#uinteger64";
+        public const string UpnName = "http://schemas.xmlsoap.org/claims/UPN";
+        public const string X500Name = "urn:oasis:names:tc:xacml:1.0:data-type:x500Name";
+        public const string YearMonthDuration = "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration";
+    }
+}
 namespace System.Security.Cryptography {
     public abstract class Aes : SymmetricAlgorithm {
-        public override KeySizes[] LegalBlockSizes { get; }
-        public override KeySizes[] LegalKeySizes { get; }
-        public static Aes Create();
+        public static new Aes Create();
+        public static new Aes Create(string algorithmName);
     }
+    public sealed class AesCryptoServiceProvider : Aes {
+        public AesCryptoServiceProvider();
+        public override byte[] Key { get; set; }
+        public override int KeySize { get; set; }
+        public override ICryptoTransform CreateDecryptor();
+        public override ICryptoTransform CreateDecryptor(byte[] key, byte[] iv);
+        public override ICryptoTransform CreateEncryptor();
+        public override ICryptoTransform CreateEncryptor(byte[] key, byte[] iv);
+        public override void GenerateIV();
+        public override void GenerateKey();
+    }
+    public sealed class AesManaged : Aes {
+        public AesManaged();
+        public override int FeedbackSize { get; set; }
+        public override byte[] IV { get; set; }
+        public override byte[] Key { get; set; }
+        public override int KeySize { get; set; }
+        public override CipherMode Mode { get; set; }
+        public override PaddingMode Padding { get; set; }
+        public override ICryptoTransform CreateDecryptor();
+        public override ICryptoTransform CreateDecryptor(byte[] key, byte[] iv);
+        public override ICryptoTransform CreateEncryptor();
+        public override ICryptoTransform CreateEncryptor(byte[] key, byte[] iv);
+        public override void GenerateIV();
+        public override void GenerateKey();
+    }
     public sealed class AsnEncodedDataCollection : ICollection, IEnumerable {
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
     }
     public abstract class AsymmetricAlgorithm : IDisposable {
+        public virtual string KeyExchangeAlgorithm { get; }
+        public virtual string SignatureAlgorithm { get; }
+        public void Clear();
+        public static AsymmetricAlgorithm Create();
+        public static AsymmetricAlgorithm Create(string algName);
+        public virtual void FromXmlString(string xmlString);
+        public virtual string ToXmlString(bool includePrivateParameters);
     }
+    public abstract class AsymmetricKeyExchangeDeformatter {
+        protected AsymmetricKeyExchangeDeformatter();
+        public abstract string Parameters { get; set; }
+        public abstract byte[] DecryptKeyExchange(byte[] rgb);
+        public abstract void SetKey(AsymmetricAlgorithm key);
+    }
+    public abstract class AsymmetricKeyExchangeFormatter {
+        protected AsymmetricKeyExchangeFormatter();
+        public abstract string Parameters { get; }
+        public abstract byte[] CreateKeyExchange(byte[] data);
+        public abstract byte[] CreateKeyExchange(byte[] data, Type symAlgType);
+        public abstract void SetKey(AsymmetricAlgorithm key);
+    }
+    public abstract class AsymmetricSignatureDeformatter {
+        protected AsymmetricSignatureDeformatter();
+        public abstract void SetHashAlgorithm(string strName);
+        public abstract void SetKey(AsymmetricAlgorithm key);
+        public abstract bool VerifySignature(byte[] rgbHash, byte[] rgbSignature);
+        public virtual bool VerifySignature(HashAlgorithm hash, byte[] rgbSignature);
+    }
+    public abstract class AsymmetricSignatureFormatter {
+        protected AsymmetricSignatureFormatter();
+        public abstract byte[] CreateSignature(byte[] rgbHash);
+        public virtual byte[] CreateSignature(HashAlgorithm hash);
+        public abstract void SetHashAlgorithm(string strName);
+        public abstract void SetKey(AsymmetricAlgorithm key);
+    }
     public enum CipherMode {
+        CFB = 4,
+        OFB = 3,
     }
+    public sealed class CngAlgorithm : IEquatable<CngAlgorithm> {
+        public CngAlgorithm(string algorithm);
+        public string Algorithm { get; }
+        public static CngAlgorithm ECDiffieHellmanP256 { get; }
+        public static CngAlgorithm ECDiffieHellmanP384 { get; }
+        public static CngAlgorithm ECDiffieHellmanP521 { get; }
+        public static CngAlgorithm ECDsaP256 { get; }
+        public static CngAlgorithm ECDsaP384 { get; }
+        public static CngAlgorithm ECDsaP521 { get; }
+        public static CngAlgorithm MD5 { get; }
+        public static CngAlgorithm Rsa { get; }
+        public static CngAlgorithm Sha1 { get; }
+        public static CngAlgorithm Sha256 { get; }
+        public static CngAlgorithm Sha384 { get; }
+        public static CngAlgorithm Sha512 { get; }
+        public bool Equals(CngAlgorithm other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(CngAlgorithm left, CngAlgorithm right);
+        public static bool operator !=(CngAlgorithm left, CngAlgorithm right);
+        public override string ToString();
+    }
+    public sealed class CngAlgorithmGroup : IEquatable<CngAlgorithmGroup> {
+        public CngAlgorithmGroup(string algorithmGroup);
+        public string AlgorithmGroup { get; }
+        public static CngAlgorithmGroup DiffieHellman { get; }
+        public static CngAlgorithmGroup Dsa { get; }
+        public static CngAlgorithmGroup ECDiffieHellman { get; }
+        public static CngAlgorithmGroup ECDsa { get; }
+        public static CngAlgorithmGroup Rsa { get; }
+        public bool Equals(CngAlgorithmGroup other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(CngAlgorithmGroup left, CngAlgorithmGroup right);
+        public static bool operator !=(CngAlgorithmGroup left, CngAlgorithmGroup right);
+        public override string ToString();
+    }
+    public enum CngExportPolicies {
+        AllowArchiving = 4,
+        AllowExport = 1,
+        AllowPlaintextArchiving = 8,
+        AllowPlaintextExport = 2,
+        None = 0,
+    }
+    public sealed class CngKey : IDisposable {
+        public CngAlgorithm Algorithm { get; }
+        public CngAlgorithmGroup AlgorithmGroup { get; }
+        public CngExportPolicies ExportPolicy { get; }
+        public SafeNCryptKeyHandle Handle { get; }
+        public bool IsEphemeral { get; }
+        public bool IsMachineKey { get; }
+        public string KeyName { get; }
+        public int KeySize { get; }
+        public CngKeyUsages KeyUsage { get; }
+        public IntPtr ParentWindowHandle { get; set; }
+        public CngProvider Provider { get; }
+        public SafeNCryptProviderHandle ProviderHandle { get; }
+        public CngUIPolicy UIPolicy { get; }
+        public string UniqueName { get; }
+        public static CngKey Create(CngAlgorithm algorithm);
+        public static CngKey Create(CngAlgorithm algorithm, string keyName);
+        public static CngKey Create(CngAlgorithm algorithm, string keyName, CngKeyCreationParameters creationParameters);
+        public void Delete();
+        public void Dispose();
+        public static bool Exists(string keyName);
+        public static bool Exists(string keyName, CngProvider provider);
+        public static bool Exists(string keyName, CngProvider provider, CngKeyOpenOptions options);
+        public byte[] Export(CngKeyBlobFormat format);
+        public CngProperty GetProperty(string name, CngPropertyOptions options);
+        public bool HasProperty(string name, CngPropertyOptions options);
+        public static CngKey Import(byte[] keyBlob, CngKeyBlobFormat format);
+        public static CngKey Import(byte[] keyBlob, CngKeyBlobFormat format, CngProvider provider);
+        public static CngKey Open(SafeNCryptKeyHandle keyHandle, CngKeyHandleOpenOptions keyHandleOpenOptions);
+        public static CngKey Open(string keyName);
+        public static CngKey Open(string keyName, CngProvider provider);
+        public static CngKey Open(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        public void SetProperty(CngProperty property);
+    }
+    public sealed class CngKeyBlobFormat : IEquatable<CngKeyBlobFormat> {
+        public CngKeyBlobFormat(string format);
+        public static CngKeyBlobFormat EccPrivateBlob { get; }
+        public static CngKeyBlobFormat EccPublicBlob { get; }
+        public string Format { get; }
+        public static CngKeyBlobFormat GenericPrivateBlob { get; }
+        public static CngKeyBlobFormat GenericPublicBlob { get; }
+        public static CngKeyBlobFormat OpaqueTransportBlob { get; }
+        public static CngKeyBlobFormat Pkcs8PrivateBlob { get; }
+        public bool Equals(CngKeyBlobFormat other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(CngKeyBlobFormat left, CngKeyBlobFormat right);
+        public static bool operator !=(CngKeyBlobFormat left, CngKeyBlobFormat right);
+        public override string ToString();
+    }
+    public enum CngKeyCreationOptions {
+        MachineKey = 32,
+        None = 0,
+        OverwriteExistingKey = 128,
+    }
+    public sealed class CngKeyCreationParameters {
+        public CngKeyCreationParameters();
+        public Nullable<CngExportPolicies> ExportPolicy { get; set; }
+        public CngKeyCreationOptions KeyCreationOptions { get; set; }
+        public Nullable<CngKeyUsages> KeyUsage { get; set; }
+        public CngPropertyCollection Parameters { get; }
+        public IntPtr ParentWindowHandle { get; set; }
+        public CngProvider Provider { get; set; }
+        public CngUIPolicy UIPolicy { get; set; }
+    }
+    public enum CngKeyHandleOpenOptions {
+        EphemeralKey = 1,
+        None = 0,
+    }
+    public enum CngKeyOpenOptions {
+        MachineKey = 32,
+        None = 0,
+        Silent = 64,
+        UserKey = 0,
+    }
+    public enum CngKeyUsages {
+        AllUsages = 16777215,
+        Decryption = 1,
+        KeyAgreement = 4,
+        None = 0,
+        Signing = 2,
+    }
+    public struct CngProperty : IEquatable<CngProperty> {
+        public CngProperty(string name, byte[] value, CngPropertyOptions options);
+        public string Name { get; }
+        public CngPropertyOptions Options { get; }
+        public bool Equals(CngProperty other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public byte[] GetValue();
+        public static bool operator ==(CngProperty left, CngProperty right);
+        public static bool operator !=(CngProperty left, CngProperty right);
+    }
+    public sealed class CngPropertyCollection : Collection<CngProperty> {
+        public CngPropertyCollection();
+    }
+    public enum CngPropertyOptions {
+        CustomProperty = 1073741824,
+        None = 0,
+        Persist = -2147483648,
+    }
+    public sealed class CngProvider : IEquatable<CngProvider> {
+        public CngProvider(string provider);
+        public static CngProvider MicrosoftSmartCardKeyStorageProvider { get; }
+        public static CngProvider MicrosoftSoftwareKeyStorageProvider { get; }
+        public string Provider { get; }
+        public bool Equals(CngProvider other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(CngProvider left, CngProvider right);
+        public static bool operator !=(CngProvider left, CngProvider right);
+        public override string ToString();
+    }
+    public sealed class CngUIPolicy {
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel);
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel, string friendlyName);
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel, string friendlyName, string description);
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel, string friendlyName, string description, string useContext);
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel, string friendlyName, string description, string useContext, string creationTitle);
+        public string CreationTitle { get; }
+        public string Description { get; }
+        public string FriendlyName { get; }
+        public CngUIProtectionLevels ProtectionLevel { get; }
+        public string UseContext { get; }
+    }
+    public enum CngUIProtectionLevels {
+        ForceHighProtection = 2,
+        None = 0,
+        ProtectKey = 1,
+    }
+    public class CryptoConfig {
+        public CryptoConfig();
+        public static bool AllowOnlyFipsAlgorithms { get; }
+        public static void AddAlgorithm(Type algorithm, params string[] names);
+        public static void AddOID(string oid, params string[] names);
+        public static object CreateFromName(string name);
+        public static object CreateFromName(string name, params object[] args);
+        public static byte[] EncodeOID(string str);
+        public static string MapNameToOID(string name);
+    }
-    public class CryptographicException : Exception {
+    public class CryptographicException : SystemException {
+        protected CryptographicException(SerializationInfo info, StreamingContext context);
     }
+    public class CryptographicUnexpectedOperationException : CryptographicException {
+        public CryptographicUnexpectedOperationException();
+        protected CryptographicUnexpectedOperationException(SerializationInfo info, StreamingContext context);
+        public CryptographicUnexpectedOperationException(string message);
+        public CryptographicUnexpectedOperationException(string message, Exception inner);
+        public CryptographicUnexpectedOperationException(string format, string insert);
+    }
     public class CryptoStream : Stream, IDisposable {
+        public void Clear();
     }
+    public sealed class CspKeyContainerInfo {
+        public CspKeyContainerInfo(CspParameters parameters);
+        public bool Accessible { get; }
+        public bool Exportable { get; }
+        public bool HardwareDevice { get; }
+        public string KeyContainerName { get; }
+        public KeyNumber KeyNumber { get; }
+        public bool MachineKeyStore { get; }
+        public bool Protected { get; }
+        public string ProviderName { get; }
+        public int ProviderType { get; }
+        public bool RandomlyGenerated { get; }
+        public bool Removable { get; }
+        public string UniqueKeyContainerName { get; }
+    }
+    public sealed class CspParameters {
+        public string KeyContainerName;
+        public int KeyNumber;
+        public string ProviderName;
+        public int ProviderType;
+        public CspParameters();
+        public CspParameters(int dwTypeIn);
+        public CspParameters(int dwTypeIn, string strProviderNameIn);
+        public CspParameters(int dwTypeIn, string strProviderNameIn, string strContainerNameIn);
+        public CspProviderFlags Flags { get; set; }
+        public SecureString KeyPassword { get; set; }
+        public IntPtr ParentWindowHandle { get; set; }
+    }
+    public enum CspProviderFlags {
+        CreateEphemeralKey = 128,
+        NoFlags = 0,
+        NoPrompt = 64,
+        UseArchivableKey = 16,
+        UseDefaultKeyContainer = 2,
+        UseExistingKey = 8,
+        UseMachineKeyStore = 1,
+        UseNonExportableKey = 4,
+        UseUserProtectedKey = 32,
+    }
+    public abstract class DES : SymmetricAlgorithm {
+        protected DES();
+        public override byte[] Key { get; set; }
+        public static new DES Create();
+        public static new DES Create(string algName);
+        public static bool IsSemiWeakKey(byte[] rgbKey);
+        public static bool IsWeakKey(byte[] rgbKey);
+    }
+    public sealed class DESCryptoServiceProvider : DES {
+        public DESCryptoServiceProvider();
+        public override ICryptoTransform CreateDecryptor(byte[] rgbKey, byte[] rgbIV);
+        public override ICryptoTransform CreateEncryptor(byte[] rgbKey, byte[] rgbIV);
+        public override void GenerateIV();
+        public override void GenerateKey();
+    }
+    public abstract class DSA : AsymmetricAlgorithm {
+        protected DSA();
+        public static new DSA Create();
+        public static new DSA Create(string algName);
+        public abstract byte[] CreateSignature(byte[] rgbHash);
+        public abstract DSAParameters ExportParameters(bool includePrivateParameters);
+        public override void FromXmlString(string xmlString);
+        public abstract void ImportParameters(DSAParameters parameters);
+        public override string ToXmlString(bool includePrivateParameters);
+        public abstract bool VerifySignature(byte[] rgbHash, byte[] rgbSignature);
+    }
+    public sealed class DSACryptoServiceProvider : DSA, ICspAsymmetricAlgorithm {
+        public DSACryptoServiceProvider();
+        public DSACryptoServiceProvider(CspParameters parameters);
+        public DSACryptoServiceProvider(int dwKeySize);
+        public DSACryptoServiceProvider(int dwKeySize, CspParameters parameters);
+        public CspKeyContainerInfo CspKeyContainerInfo { get; }
+        public override string KeyExchangeAlgorithm { get; }
+        public override int KeySize { get; }
+        public bool PersistKeyInCsp { get; set; }
+        public bool PublicOnly { get; }
+        public override string SignatureAlgorithm { get; }
+        public static bool UseMachineKeyStore { get; set; }
+        public override byte[] CreateSignature(byte[] rgbHash);
+        public byte[] ExportCspBlob(bool includePrivateParameters);
+        public override DSAParameters ExportParameters(bool includePrivateParameters);
+        public void ImportCspBlob(byte[] keyBlob);
+        public override void ImportParameters(DSAParameters parameters);
+        public byte[] SignData(byte[] buffer);
+        public byte[] SignData(byte[] buffer, int offset, int count);
+        public byte[] SignData(Stream inputStream);
+        public byte[] SignHash(byte[] rgbHash, string str);
+        public bool VerifyData(byte[] rgbData, byte[] rgbSignature);
+        public bool VerifyHash(byte[] rgbHash, string str, byte[] rgbSignature);
+        public override bool VerifySignature(byte[] rgbHash, byte[] rgbSignature);
+    }
+    public struct DSAParameters {
+        public int Counter;
+        public byte[] G;
+        public byte[] J;
+        public byte[] P;
+        public byte[] Q;
+        public byte[] Seed;
+        public byte[] X;
+        public byte[] Y;
+    }
+    public class DSASignatureDeformatter : AsymmetricSignatureDeformatter {
+        public DSASignatureDeformatter();
+        public DSASignatureDeformatter(AsymmetricAlgorithm key);
+        public override void SetHashAlgorithm(string strName);
+        public override void SetKey(AsymmetricAlgorithm key);
+        public override bool VerifySignature(byte[] rgbHash, byte[] rgbSignature);
+    }
+    public class DSASignatureFormatter : AsymmetricSignatureFormatter {
+        public DSASignatureFormatter();
+        public DSASignatureFormatter(AsymmetricAlgorithm key);
+        public override byte[] CreateSignature(byte[] rgbHash);
+        public override void SetHashAlgorithm(string strName);
+        public override void SetKey(AsymmetricAlgorithm key);
+    }
-    public struct ECCurve {
-        public enum ECCurveType {
-            Characteristic2 = 4,
-            Implicit = 0,
-            Named = 5,
-            PrimeMontgomery = 3,
-            PrimeShortWeierstrass = 1,
-            PrimeTwistedEdwards = 2,
-        }
-        public static class NamedCurves {
-            public static ECCurve brainpoolP160r1 { get; }
-            public static ECCurve brainpoolP160t1 { get; }
-            public static ECCurve brainpoolP192r1 { get; }
-            public static ECCurve brainpoolP192t1 { get; }
-            public static ECCurve brainpoolP224r1 { get; }
-            public static ECCurve brainpoolP224t1 { get; }
-            public static ECCurve brainpoolP256r1 { get; }
-            public static ECCurve brainpoolP256t1 { get; }
-            public static ECCurve brainpoolP320r1 { get; }
-            public static ECCurve brainpoolP320t1 { get; }
-            public static ECCurve brainpoolP384r1 { get; }
-            public static ECCurve brainpoolP384t1 { get; }
-            public static ECCurve brainpoolP512r1 { get; }
-            public static ECCurve brainpoolP512t1 { get; }
-            public static ECCurve nistP256 { get; }
-            public static ECCurve nistP384 { get; }
-            public static ECCurve nistP521 { get; }
-        }
-        public byte[] A;
-        public byte[] B;
-        public byte[] Cofactor;
-        public ECCurve.ECCurveType CurveType;
-        public ECPoint G;
-        public Nullable<HashAlgorithmName> Hash;
-        public byte[] Order;
-        public byte[] Polynomial;
-        public byte[] Prime;
-        public byte[] Seed;
-        public bool IsCharacteristic2 { get; }
-        public bool IsExplicit { get; }
-        public bool IsNamed { get; }
-        public bool IsPrime { get; }
-        public Oid Oid { get; }
-        public static ECCurve CreateFromFriendlyName(string oidFriendlyName);
-        public static ECCurve CreateFromOid(Oid curveOid);
-        public static ECCurve CreateFromValue(string oidValue);
-        public void Validate();
-    }
+    public abstract class ECDiffieHellmanPublicKey : IDisposable {
+        protected ECDiffieHellmanPublicKey(byte[] keyBlob);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual byte[] ToByteArray();
+        public abstract string ToXmlString();
+    }
     public abstract class ECDsa : AsymmetricAlgorithm {
+        public override string KeyExchangeAlgorithm { get; }
+        public override string SignatureAlgorithm { get; }
-        public static ECDsa Create();
+        public static new ECDsa Create();
-        public static ECDsa Create(ECCurve curve);
-        public static ECDsa Create(ECParameters parameters);
+        public static new ECDsa Create(string algorithm);
-        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);
-        public virtual ECParameters ExportParameters(bool includePrivateParameters);
-        public virtual void GenerateKey(ECCurve curve);
-        protected abstract byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected virtual byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected abstract byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        protected virtual byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
-        public virtual void ImportParameters(ECParameters parameters);
     }
-    public struct ECParameters {
-        public ECCurve Curve;
-        public byte[] D;
-        public ECPoint Q;
-        public void Validate();
-    }
-    public struct ECPoint {
-        public byte[] X;
-        public byte[] Y;
-    }
+    public class FromBase64Transform : ICryptoTransform, IDisposable {
+        public FromBase64Transform();
+        public FromBase64Transform(FromBase64TransformMode whitespaces);
+        public virtual bool CanReuseTransform { get; }
+        public bool CanTransformMultipleBlocks { get; }
+        public int InputBlockSize { get; }
+        public int OutputBlockSize { get; }
+        public void Clear();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        ~FromBase64Transform();
+        public int TransformBlock(byte[] inputBuffer, int inputOffset, int inputCount, byte[] outputBuffer, int outputOffset);
+        public byte[] TransformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount);
+    }
+    public enum FromBase64TransformMode {
+        DoNotIgnoreWhiteSpaces = 1,
+        IgnoreWhiteSpaces = 0,
+    }
-    public abstract class HashAlgorithm : IDisposable {
+    public abstract class HashAlgorithm : ICryptoTransform, IDisposable {
+        protected int HashSizeValue;
+        protected internal byte[] HashValue;
+        protected int State;
+        public virtual bool CanReuseTransform { get; }
+        public virtual bool CanTransformMultipleBlocks { get; }
+        public virtual byte[] Hash { get; }
+        public virtual int InputBlockSize { get; }
+        public virtual int OutputBlockSize { get; }
+        public void Clear();
+        public static HashAlgorithm Create();
+        public static HashAlgorithm Create(string hashName);
+        public int TransformBlock(byte[] inputBuffer, int inputOffset, int inputCount, byte[] outputBuffer, int outputOffset);
+        public byte[] TransformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount);
     }
     public abstract class HMAC : KeyedHashAlgorithm {
+        protected int BlockSizeValue { get; set; }
+        public static new HMAC Create();
+        public static new HMAC Create(string algorithmName);
     }
     public class HMACMD5 : HMAC {
-        public override int HashSize { get; }
-        public override byte[] Key { get; set; }
-        protected override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ib, int cb);
-        protected override byte[] HashFinal();
-        public override void Initialize();
     }
     public class HMACSHA1 : HMAC {
+        public HMACSHA1(byte[] key, bool useManagedSha1);
-        public override int HashSize { get; }
-        public override byte[] Key { get; set; }
-        protected override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ib, int cb);
-        protected override byte[] HashFinal();
-        public override void Initialize();
     }
     public class HMACSHA256 : HMAC {
-        public override int HashSize { get; }
-        public override byte[] Key { get; set; }
-        protected override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ib, int cb);
-        protected override byte[] HashFinal();
-        public override void Initialize();
     }
     public class HMACSHA384 : HMAC {
-        public override int HashSize { get; }
-        public override byte[] Key { get; set; }
+        public bool ProduceLegacyHmacValues { get; set; }
-        protected override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ib, int cb);
-        protected override byte[] HashFinal();
-        public override void Initialize();
     }
     public class HMACSHA512 : HMAC {
-        public override int HashSize { get; }
-        public override byte[] Key { get; set; }
+        public bool ProduceLegacyHmacValues { get; set; }
-        protected override void Dispose(bool disposing);
-        protected override void HashCore(byte[] rgb, int ib, int cb);
-        protected override byte[] HashFinal();
-        public override void Initialize();
     }
+    public interface ICspAsymmetricAlgorithm {
+        CspKeyContainerInfo CspKeyContainerInfo { get; }
+        byte[] ExportCspBlob(bool includePrivateParameters);
+        void ImportCspBlob(byte[] rawData);
+    }
-    public sealed class IncrementalHash : IDisposable {
-        public HashAlgorithmName AlgorithmName { get; }
-        public void AppendData(byte[] data);
-        public void AppendData(byte[] data, int offset, int count);
-        public static IncrementalHash CreateHash(HashAlgorithmName hashAlgorithm);
-        public static IncrementalHash CreateHMAC(HashAlgorithmName hashAlgorithm, byte[] key);
-        public void Dispose();
-        public byte[] GetHashAndReset();
-    }
     public abstract class KeyedHashAlgorithm : HashAlgorithm {
+        protected byte[] KeyValue;
+        public static new KeyedHashAlgorithm Create();
+        public static new KeyedHashAlgorithm Create(string algName);
     }
+    public enum KeyNumber {
+        Exchange = 1,
+        Signature = 2,
+    }
+    public abstract class MaskGenerationMethod {
+        protected MaskGenerationMethod();
+        public abstract byte[] GenerateMask(byte[] rgbSeed, int cbReturn);
+    }
     public abstract class MD5 : HashAlgorithm {
-        public static MD5 Create();
+        public static new MD5 Create();
+        public static new MD5 Create(string algName);
     }
+    public sealed class MD5CryptoServiceProvider : MD5 {
+        public MD5CryptoServiceProvider();
+        public override void Initialize();
+    }
     public sealed class Oid {
+        public Oid();
     }
     public sealed class OidCollection : ICollection, IEnumerable {
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
     }
     public enum PaddingMode {
+        ANSIX923 = 4,
+        ISO10126 = 5,
     }
+    public class PasswordDeriveBytes : DeriveBytes {
+        public PasswordDeriveBytes(byte[] password, byte[] salt);
+        public PasswordDeriveBytes(byte[] password, byte[] salt, CspParameters cspParams);
+        public PasswordDeriveBytes(byte[] password, byte[] salt, string hashName, int iterations);
+        public PasswordDeriveBytes(byte[] password, byte[] salt, string hashName, int iterations, CspParameters cspParams);
+        public PasswordDeriveBytes(string strPassword, byte[] rgbSalt);
+        public PasswordDeriveBytes(string strPassword, byte[] rgbSalt, CspParameters cspParams);
+        public PasswordDeriveBytes(string strPassword, byte[] rgbSalt, string strHashName, int iterations);
+        public PasswordDeriveBytes(string strPassword, byte[] rgbSalt, string strHashName, int iterations, CspParameters cspParams);
+        public string HashName { get; set; }
+        public int IterationCount { get; set; }
+        public byte[] Salt { get; set; }
+        public byte[] CryptDeriveKey(string algname, string alghashname, int keySize, byte[] rgbIV);
+        protected override void Dispose(bool disposing);
+        public override byte[] GetBytes(int cb);
+        public override void Reset();
+    }
+    public class PKCS1MaskGenerationMethod : MaskGenerationMethod {
+        public PKCS1MaskGenerationMethod();
+        public string HashName { get; set; }
+        public override byte[] GenerateMask(byte[] rgbSeed, int cbReturn);
+    }
     public abstract class RandomNumberGenerator : IDisposable {
+        public static RandomNumberGenerator Create(string rngName);
+        public virtual void GetBytes(byte[] data, int offset, int count);
+        public virtual void GetNonZeroBytes(byte[] data);
     }
+    public abstract class RC2 : SymmetricAlgorithm {
+        protected int EffectiveKeySizeValue;
+        protected RC2();
+        public virtual int EffectiveKeySize { get; set; }
+        public override int KeySize { get; set; }
+        public static new RC2 Create();
+        public static new RC2 Create(string AlgName);
+    }
+    public sealed class RC2CryptoServiceProvider : RC2 {
+        public RC2CryptoServiceProvider();
+        public override int EffectiveKeySize { get; set; }
+        public bool UseSalt { get; set; }
+        public override ICryptoTransform CreateDecryptor(byte[] rgbKey, byte[] rgbIV);
+        public override ICryptoTransform CreateEncryptor(byte[] rgbKey, byte[] rgbIV);
+        public override void GenerateIV();
+        public override void GenerateKey();
+    }
     public class Rfc2898DeriveBytes : DeriveBytes {
+        public byte[] CryptDeriveKey(string algname, string alghashname, int keySize, byte[] rgbIV);
     }
+    public abstract class Rijndael : SymmetricAlgorithm {
+        protected Rijndael();
+        public static new Rijndael Create();
+        public static new Rijndael Create(string algName);
+    }
+    public sealed class RijndaelManaged : Rijndael {
+        public RijndaelManaged();
+        public override ICryptoTransform CreateDecryptor(byte[] rgbKey, byte[] rgbIV);
+        public override ICryptoTransform CreateEncryptor(byte[] rgbKey, byte[] rgbIV);
+        public override void GenerateIV();
+        public override void GenerateKey();
+    }
+    public sealed class RNGCryptoServiceProvider : RandomNumberGenerator {
+        public RNGCryptoServiceProvider();
+        public RNGCryptoServiceProvider(byte[] rgb);
+        public RNGCryptoServiceProvider(CspParameters cspParams);
+        public RNGCryptoServiceProvider(string str);
+        public override void GetBytes(byte[] data);
+        public override void GetNonZeroBytes(byte[] data);
+    }
     public abstract class RSA : AsymmetricAlgorithm {
+        public override string KeyExchangeAlgorithm { get; }
+        public override string SignatureAlgorithm { get; }
-        public static RSA Create();
+        public static new RSA Create();
+        public static new RSA Create(string algName);
-        public abstract byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
+        public virtual byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
+        public virtual byte[] DecryptValue(byte[] rgb);
-        public abstract byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
+        public virtual byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
+        public virtual byte[] EncryptValue(byte[] rgb);
+        public override void FromXmlString(string xmlString);
-        protected abstract byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected virtual byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
-        protected abstract byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        protected virtual byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
-        public abstract byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public virtual byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public override string ToXmlString(bool includePrivateParameters);
-        public abstract bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public virtual bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
     }
+    public sealed class RSACng : RSA {
+        public RSACng();
+        public RSACng(CngKey key);
+        public RSACng(int keySize);
+        public CngKey Key { get; }
+        public override byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
+        public override byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
+        public override RSAParameters ExportParameters(bool includePrivateParameters);
+        public override void ImportParameters(RSAParameters parameters);
+        public override byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public override bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+    }
+    public sealed class RSACryptoServiceProvider : RSA, ICspAsymmetricAlgorithm {
+        public RSACryptoServiceProvider();
+        public RSACryptoServiceProvider(CspParameters parameters);
+        public RSACryptoServiceProvider(int dwKeySize);
+        public RSACryptoServiceProvider(int dwKeySize, CspParameters parameters);
+        public CspKeyContainerInfo CspKeyContainerInfo { get; }
+        public override string KeyExchangeAlgorithm { get; }
+        public override int KeySize { get; }
+        public bool PersistKeyInCsp { get; set; }
+        public bool PublicOnly { get; }
+        public override string SignatureAlgorithm { get; }
+        public static bool UseMachineKeyStore { get; set; }
+        public byte[] Decrypt(byte[] rgb, bool fOAEP);
+        public override byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
+        public override byte[] DecryptValue(byte[] rgb);
+        public byte[] Encrypt(byte[] rgb, bool fOAEP);
+        public override byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
+        public override byte[] EncryptValue(byte[] rgb);
+        public byte[] ExportCspBlob(bool includePrivateParameters);
+        public override RSAParameters ExportParameters(bool includePrivateParameters);
+        public void ImportCspBlob(byte[] keyBlob);
+        public override void ImportParameters(RSAParameters parameters);
+        public byte[] SignData(byte[] buffer, int offset, int count, object halg);
+        public byte[] SignData(byte[] buffer, object halg);
+        public byte[] SignData(Stream inputStream, object halg);
+        public override byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public byte[] SignHash(byte[] rgbHash, string str);
+        public bool VerifyData(byte[] buffer, object halg, byte[] signature);
+        public override bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public bool VerifyHash(byte[] rgbHash, string str, byte[] rgbSignature);
+    }
+    public class RSAOAEPKeyExchangeDeformatter : AsymmetricKeyExchangeDeformatter {
+        public RSAOAEPKeyExchangeDeformatter();
+        public RSAOAEPKeyExchangeDeformatter(AsymmetricAlgorithm key);
+        public override string Parameters { get; set; }
+        public override byte[] DecryptKeyExchange(byte[] rgbData);
+        public override void SetKey(AsymmetricAlgorithm key);
+    }
+    public class RSAOAEPKeyExchangeFormatter : AsymmetricKeyExchangeFormatter {
+        public RSAOAEPKeyExchangeFormatter();
+        public RSAOAEPKeyExchangeFormatter(AsymmetricAlgorithm key);
+        public byte[] Parameter { get; set; }
+        public override string Parameters { get; }
+        public RandomNumberGenerator Rng { get; set; }
+        public override byte[] CreateKeyExchange(byte[] rgbData);
+        public override byte[] CreateKeyExchange(byte[] rgbData, Type symAlgType);
+        public override void SetKey(AsymmetricAlgorithm key);
+    }
+    public class RSAPKCS1KeyExchangeDeformatter : AsymmetricKeyExchangeDeformatter {
+        public RSAPKCS1KeyExchangeDeformatter();
+        public RSAPKCS1KeyExchangeDeformatter(AsymmetricAlgorithm key);
+        public override string Parameters { get; set; }
+        public RandomNumberGenerator RNG { get; set; }
+        public override byte[] DecryptKeyExchange(byte[] rgbIn);
+        public override void SetKey(AsymmetricAlgorithm key);
+    }
+    public class RSAPKCS1KeyExchangeFormatter : AsymmetricKeyExchangeFormatter {
+        public RSAPKCS1KeyExchangeFormatter();
+        public RSAPKCS1KeyExchangeFormatter(AsymmetricAlgorithm key);
+        public override string Parameters { get; }
+        public RandomNumberGenerator Rng { get; set; }
+        public override byte[] CreateKeyExchange(byte[] rgbData);
+        public override byte[] CreateKeyExchange(byte[] rgbData, Type symAlgType);
+        public override void SetKey(AsymmetricAlgorithm key);
+    }
+    public class RSAPKCS1SignatureDeformatter : AsymmetricSignatureDeformatter {
+        public RSAPKCS1SignatureDeformatter();
+        public RSAPKCS1SignatureDeformatter(AsymmetricAlgorithm key);
+        public override void SetHashAlgorithm(string strName);
+        public override void SetKey(AsymmetricAlgorithm key);
+        public override bool VerifySignature(byte[] rgbHash, byte[] rgbSignature);
+    }
+    public class RSAPKCS1SignatureFormatter : AsymmetricSignatureFormatter {
+        public RSAPKCS1SignatureFormatter();
+        public RSAPKCS1SignatureFormatter(AsymmetricAlgorithm key);
+        public override byte[] CreateSignature(byte[] rgbHash);
+        public override void SetHashAlgorithm(string strName);
+        public override void SetKey(AsymmetricAlgorithm key);
+    }
     public abstract class SHA1 : HashAlgorithm {
-        public static SHA1 Create();
+        public static new SHA1 Create();
+        public static new SHA1 Create(string hashName);
     }
+    public sealed class SHA1CryptoServiceProvider : SHA1 {
+        public SHA1CryptoServiceProvider();
+        public override void Initialize();
+    }
+    public sealed class SHA1Managed : SHA1 {
+        public SHA1Managed();
+        public override void Initialize();
+    }
     public abstract class SHA256 : HashAlgorithm {
-        public static SHA256 Create();
+        public static new SHA256 Create();
+        public static new SHA256 Create(string hashName);
     }
+    public sealed class SHA256Managed : SHA256 {
+        public SHA256Managed();
+        public override void Initialize();
+    }
     public abstract class SHA384 : HashAlgorithm {
-        public static SHA384 Create();
+        public static new SHA384 Create();
+        public static new SHA384 Create(string hashName);
     }
+    public sealed class SHA384Managed : SHA384 {
+        public SHA384Managed();
+        public override void Initialize();
+    }
     public abstract class SHA512 : HashAlgorithm {
-        public static SHA512 Create();
+        public static new SHA512 Create();
+        public static new SHA512 Create(string hashName);
     }
+    public sealed class SHA512Managed : SHA512 {
+        public SHA512Managed();
+        public override void Initialize();
+    }
+    public class SignatureDescription {
+        public SignatureDescription();
+        public SignatureDescription(SecurityElement el);
+        public string DeformatterAlgorithm { get; set; }
+        public string DigestAlgorithm { get; set; }
+        public string FormatterAlgorithm { get; set; }
+        public string KeyAlgorithm { get; set; }
+        public virtual AsymmetricSignatureDeformatter CreateDeformatter(AsymmetricAlgorithm key);
+        public virtual HashAlgorithm CreateDigest();
+        public virtual AsymmetricSignatureFormatter CreateFormatter(AsymmetricAlgorithm key);
+    }
     public abstract class SymmetricAlgorithm : IDisposable {
+        protected int FeedbackSizeValue;
+        public virtual int FeedbackSize { get; set; }
+        public void Clear();
+        public static SymmetricAlgorithm Create();
+        public static SymmetricAlgorithm Create(string algName);
+        public bool ValidKeySize(int bitLength);
     }
+    public class ToBase64Transform : ICryptoTransform, IDisposable {
+        public ToBase64Transform();
+        public virtual bool CanReuseTransform { get; }
+        public bool CanTransformMultipleBlocks { get; }
+        public int InputBlockSize { get; }
+        public int OutputBlockSize { get; }
+        public void Clear();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        ~ToBase64Transform();
+        public int TransformBlock(byte[] inputBuffer, int inputOffset, int inputCount, byte[] outputBuffer, int outputOffset);
+        public byte[] TransformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount);
+    }
     public abstract class TripleDES : SymmetricAlgorithm {
-        public override KeySizes[] LegalBlockSizes { get; }
-        public override KeySizes[] LegalKeySizes { get; }
-        public static TripleDES Create();
+        public static new TripleDES Create();
+        public static new TripleDES Create(string str);
     }
+    public sealed class TripleDESCryptoServiceProvider : TripleDES {
+        public TripleDESCryptoServiceProvider();
+        public override ICryptoTransform CreateDecryptor(byte[] rgbKey, byte[] rgbIV);
+        public override ICryptoTransform CreateEncryptor(byte[] rgbKey, byte[] rgbIV);
+        public override void GenerateIV();
+        public override void GenerateKey();
+    }
 }
 namespace System.Security.Cryptography.X509Certificates {
     public sealed class PublicKey {
+        public AsymmetricAlgorithm Key { get; }
     }
-    public class X509Certificate : IDisposable {
+    public class X509Certificate : IDeserializationCallback, IDisposable, ISerializable {
+        public X509Certificate(byte[] rawData, SecureString password);
+        public X509Certificate(byte[] rawData, SecureString password, X509KeyStorageFlags keyStorageFlags);
+        public X509Certificate(SerializationInfo info, StreamingContext context);
+        public X509Certificate(string fileName, SecureString password);
+        public X509Certificate(string fileName, SecureString password, X509KeyStorageFlags keyStorageFlags);
+        public X509Certificate(X509Certificate cert);
+        public static X509Certificate CreateFromCertFile(string filename);
+        public static X509Certificate CreateFromSignedFile(string filename);
+        public virtual byte[] Export(X509ContentType contentType, SecureString password);
+        protected static string FormatDate(DateTime date);
+        public virtual string GetCertHashString();
+        public virtual string GetEffectiveDateString();
+        public virtual string GetExpirationDateString();
+        public virtual string GetIssuerName();
+        public virtual string GetName();
+        public virtual string GetPublicKeyString();
+        public virtual byte[] GetRawCertData();
+        public virtual string GetRawCertDataString();
+        public virtual string GetSerialNumberString();
+        public virtual void Import(byte[] rawData);
+        public virtual void Import(byte[] rawData, SecureString password, X509KeyStorageFlags keyStorageFlags);
+        public virtual void Import(byte[] rawData, string password, X509KeyStorageFlags keyStorageFlags);
+        public virtual void Import(string fileName);
+        public virtual void Import(string fileName, SecureString password, X509KeyStorageFlags keyStorageFlags);
+        public virtual void Import(string fileName, string password, X509KeyStorageFlags keyStorageFlags);
+        public virtual void Reset();
     }
     public class X509Certificate2 : X509Certificate {
+        public X509Certificate2(byte[] rawData, SecureString password);
+        public X509Certificate2(byte[] rawData, SecureString password, X509KeyStorageFlags keyStorageFlags);
+        protected X509Certificate2(SerializationInfo info, StreamingContext context);
+        public X509Certificate2(string fileName, SecureString password);
+        public X509Certificate2(string fileName, SecureString password, X509KeyStorageFlags keyStorageFlags);
+        public X509Certificate2(X509Certificate certificate);
+        public AsymmetricAlgorithm PrivateKey { get; set; }
+        public override void Import(byte[] rawData);
+        public override void Import(byte[] rawData, SecureString password, X509KeyStorageFlags keyStorageFlags);
+        public override void Import(byte[] rawData, string password, X509KeyStorageFlags keyStorageFlags);
+        public override void Import(string fileName);
+        public override void Import(string fileName, SecureString password, X509KeyStorageFlags keyStorageFlags);
+        public override void Import(string fileName, string password, X509KeyStorageFlags keyStorageFlags);
+        public override void Reset();
+        public bool Verify();
     }
-    public class X509CertificateCollection : ICollection, IEnumerable, IList {
+    public class X509CertificateCollection : CollectionBase {
-        public int Count { get; }
-        public void Clear();
-        public X509CertificateCollection.X509CertificateEnumerator GetEnumerator();
+        public new X509CertificateCollection.X509CertificateEnumerator GetEnumerator();
-        public void RemoveAt(int index);
     }
     public class X509Chain : IDisposable {
+        public X509Chain(bool useMachineContext);
+        public X509Chain(IntPtr chainContext);
+        public IntPtr ChainContext { get; }
+        public static X509Chain Create();
+        public void Reset();
     }
     public sealed class X509ChainElementCollection : ICollection, IEnumerable {
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
     }
     public sealed class X509ExtensionCollection : ICollection, IEnumerable {
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
     }
+    public enum X509IncludeOption {
+        EndCertOnly = 2,
+        ExcludeRoot = 1,
+        None = 0,
+        WholeChain = 3,
+    }
     public sealed class X509Store : IDisposable {
+        public X509Store(IntPtr storeHandle);
+        public X509Store(StoreLocation storeLocation);
+        public X509Store(StoreName storeName);
+        public X509Store(string storeName);
+        public IntPtr StoreHandle { get; }
+        public void AddRange(X509Certificate2Collection certificates);
+        public void Close();
+        public void RemoveRange(X509Certificate2Collection certificates);
     }
 }
+namespace System.Security.Permissions {
+    public abstract class CodeAccessSecurityAttribute : SecurityAttribute {
+        protected CodeAccessSecurityAttribute(SecurityAction action);
+    }
+    public enum SecurityAction {
+        Assert = 3,
+        Demand = 2,
+        Deny = 4,
+        InheritanceDemand = 7,
+        LinkDemand = 6,
+        PermitOnly = 5,
+        RequestMinimum = 8,
+        RequestOptional = 9,
+        RequestRefuse = 10,
+    }
+    public abstract class SecurityAttribute : Attribute {
+        protected SecurityAttribute(SecurityAction action);
+        public SecurityAction Action { get; set; }
+        public bool Unrestricted { get; set; }
+        public abstract IPermission CreatePermission();
+    }
+    public sealed class SecurityPermissionAttribute : CodeAccessSecurityAttribute {
+        public SecurityPermissionAttribute(SecurityAction action);
+        public bool Assertion { get; set; }
+        public bool BindingRedirects { get; set; }
+        public bool ControlAppDomain { get; set; }
+        public bool ControlDomainPolicy { get; set; }
+        public bool ControlEvidence { get; set; }
+        public bool ControlPolicy { get; set; }
+        public bool ControlPrincipal { get; set; }
+        public bool ControlThread { get; set; }
+        public bool Execution { get; set; }
+        public SecurityPermissionFlag Flags { get; set; }
+        public bool Infrastructure { get; set; }
+        public bool RemotingConfiguration { get; set; }
+        public bool SerializationFormatter { get; set; }
+        public bool SkipVerification { get; set; }
+        public bool UnmanagedCode { get; set; }
+        public override IPermission CreatePermission();
+    }
+    public enum SecurityPermissionFlag {
+        AllFlags = 16383,
+        Assertion = 1,
+        BindingRedirects = 8192,
+        ControlAppDomain = 1024,
+        ControlDomainPolicy = 256,
+        ControlEvidence = 32,
+        ControlPolicy = 64,
+        ControlPrincipal = 512,
+        ControlThread = 16,
+        Execution = 8,
+        Infrastructure = 4096,
+        NoFlags = 0,
+        RemotingConfiguration = 2048,
+        SerializationFormatter = 128,
+        SkipVerification = 4,
+        UnmanagedCode = 2,
+    }
+}
+namespace System.Security.Principal {
+    public class GenericIdentity : ClaimsIdentity {
+        protected GenericIdentity(GenericIdentity identity);
+        public GenericIdentity(string name);
+        public GenericIdentity(string name, string type);
+        public override string AuthenticationType { get; }
+        public override IEnumerable<Claim> Claims { get; }
+        public override bool IsAuthenticated { get; }
+        public override string Name { get; }
+        public override ClaimsIdentity Clone();
+    }
+    public class GenericPrincipal : ClaimsPrincipal {
+        public GenericPrincipal(IIdentity identity, string[] roles);
+        public override IIdentity Identity { get; }
+        public override bool IsInRole(string role);
+    }
+    public interface IIdentity {
+        string AuthenticationType { get; }
+        bool IsAuthenticated { get; }
+        string Name { get; }
+    }
+    public interface IPrincipal {
+        IIdentity Identity { get; }
+        bool IsInRole(string role);
+    }
+    public enum PrincipalPolicy {
+        NoPrincipal = 1,
+        UnauthenticatedPrincipal = 0,
+        WindowsPrincipal = 2,
+    }
+    public enum TokenImpersonationLevel {
+        Anonymous = 1,
+        Delegation = 4,
+        Identification = 2,
+        Impersonation = 3,
+        None = 0,
+    }
+}
 namespace System.Text {
     public abstract class Decoder {
+        public unsafe virtual void Convert(byte* bytes, int byteCount, char* chars, int charCount, bool flush, out int bytesUsed, out int charsUsed, out bool completed);
+        public unsafe virtual int GetCharCount(byte* bytes, int count, bool flush);
+        public unsafe virtual int GetChars(byte* bytes, int byteCount, char* chars, int charCount, bool flush);
     }
+    public sealed class DecoderExceptionFallbackBuffer : DecoderFallbackBuffer {
+        public DecoderExceptionFallbackBuffer();
+        public override int Remaining { get; }
+        public override bool Fallback(byte[] bytesUnknown, int index);
+        public override char GetNextChar();
+        public override bool MovePrevious();
+    }
+    public sealed class DecoderReplacementFallbackBuffer : DecoderFallbackBuffer {
+        public DecoderReplacementFallbackBuffer(DecoderReplacementFallback fallback);
+        public override int Remaining { get; }
+        public override bool Fallback(byte[] bytesUnknown, int index);
+        public override char GetNextChar();
+        public override bool MovePrevious();
+        public override void Reset();
+    }
     public abstract class Encoder {
+        public unsafe virtual void Convert(char* chars, int charCount, byte* bytes, int byteCount, bool flush, out int charsUsed, out int bytesUsed, out bool completed);
+        public unsafe virtual int GetByteCount(char* chars, int count, bool flush);
+        public unsafe virtual int GetBytes(char* chars, int charCount, byte* bytes, int byteCount, bool flush);
     }
+    public sealed class EncoderExceptionFallbackBuffer : EncoderFallbackBuffer {
+        public EncoderExceptionFallbackBuffer();
+        public override int Remaining { get; }
+        public override bool Fallback(char charUnknownHigh, char charUnknownLow, int index);
+        public override bool Fallback(char charUnknown, int index);
+        public override char GetNextChar();
+        public override bool MovePrevious();
+    }
+    public sealed class EncoderReplacementFallbackBuffer : EncoderFallbackBuffer {
+        public EncoderReplacementFallbackBuffer(EncoderReplacementFallback fallback);
+        public override int Remaining { get; }
+        public override bool Fallback(char charUnknownHigh, char charUnknownLow, int index);
+        public override bool Fallback(char charUnknown, int index);
+        public override char GetNextChar();
+        public override bool MovePrevious();
+        public override void Reset();
+    }
-    public abstract class Encoding {
+    public abstract class Encoding : ICloneable {
+        public virtual string BodyName { get; }
-        public DecoderFallback DecoderFallback { get; }
+        public DecoderFallback DecoderFallback { get; set; }
+        public static Encoding Default { get; }
-        public EncoderFallback EncoderFallback { get; }
+        public EncoderFallback EncoderFallback { get; set; }
+        public virtual string HeaderName { get; }
+        public virtual bool IsBrowserDisplay { get; }
+        public virtual bool IsBrowserSave { get; }
+        public virtual bool IsMailNewsDisplay { get; }
+        public virtual bool IsMailNewsSave { get; }
+        public bool IsReadOnly { get; }
+        public virtual int WindowsCodePage { get; }
+        public static EncodingInfo[] GetEncodings();
+        public bool IsAlwaysNormalized();
+        public virtual bool IsAlwaysNormalized(NormalizationForm form);
     }
+    public sealed class EncodingInfo {
+        public int CodePage { get; }
+        public string DisplayName { get; }
+        public string Name { get; }
+        public override bool Equals(object value);
+        public Encoding GetEncoding();
+        public override int GetHashCode();
+    }
+    public enum NormalizationForm {
+        FormC = 1,
+        FormD = 2,
+        FormKC = 5,
+        FormKD = 6,
+    }
-    public sealed class StringBuilder {
+    public sealed class StringBuilder : ISerializable {
     }
     public class UnicodeEncoding : Encoding {
+        public const int CharSize = 2;
+        public unsafe override int GetByteCount(char* chars, int count);
+        public unsafe override int GetBytes(char* chars, int charCount, byte* bytes, int byteCount);
+        public unsafe override int GetCharCount(byte* bytes, int count);
+        public unsafe override int GetChars(byte* bytes, int byteCount, char* chars, int charCount);
     }
 }
 namespace System.Text.RegularExpressions {
     public class CaptureCollection : ICollection, IEnumerable {
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public void CopyTo(Array array, int arrayIndex);
     }
     public class Group : Capture {
+        public static Group Synchronized(Group inner);
     }
     public class GroupCollection : ICollection, IEnumerable {
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public void CopyTo(Array array, int arrayIndex);
     }
     public class Match : Group {
+        public static Match Synchronized(Match inner);
     }
     public class MatchCollection : ICollection, IEnumerable {
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public object SyncRoot { get; }
+        public void CopyTo(Array array, int arrayIndex);
     }
-    public class Regex {
+    public class Regex : ISerializable {
+        protected internal Hashtable capnames;
+        protected internal Hashtable caps;
+        protected Regex(SerializationInfo info, StreamingContext context);
-        protected IDictionary CapNames { get; set; }
-        protected IDictionary Caps { get; set; }
+        protected bool UseOptionC();
+        protected bool UseOptionR();
     }
-    public class RegexMatchTimeoutException : TimeoutException {
+    public class RegexMatchTimeoutException : TimeoutException, ISerializable {
+        protected RegexMatchTimeoutException(SerializationInfo info, StreamingContext context);
     }
 }
 namespace System.Threading {
-    public class AbandonedMutexException : Exception {
+    public class AbandonedMutexException : SystemException {
+        protected AbandonedMutexException(SerializationInfo info, StreamingContext context);
     }
+    public enum ApartmentState {
+        MTA = 1,
+        STA = 0,
+        Unknown = 2,
+    }
+    public struct AsyncFlowControl : IDisposable {
+        public void Dispose();
+        public bool Equals(AsyncFlowControl obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(AsyncFlowControl a, AsyncFlowControl b);
+        public static bool operator !=(AsyncFlowControl a, AsyncFlowControl b);
+        public void Undo();
+    }
     public class BarrierPostPhaseException : Exception {
+        protected BarrierPostPhaseException(SerializationInfo info, StreamingContext context);
     }
+    public sealed class CompressedStack : ISerializable {
+        public static CompressedStack Capture();
+        public CompressedStack CreateCopy();
+        public static CompressedStack GetCompressedStack();
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        public static void Run(CompressedStack compressedStack, ContextCallback callback, object state);
+    }
-    public sealed class ExecutionContext {
+    public sealed class ExecutionContext : IDisposable, ISerializable {
+        public ExecutionContext CreateCopy();
+        public void Dispose();
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        public static bool IsFlowSuppressed();
+        public static void RestoreFlow();
+        public static AsyncFlowControl SuppressFlow();
     }
+    public class HostExecutionContext : IDisposable {
+        public HostExecutionContext();
+        public HostExecutionContext(object state);
+        protected internal object State { get; set; }
+        public virtual HostExecutionContext CreateCopy();
+        public void Dispose();
+        public virtual void Dispose(bool disposing);
+    }
+    public class HostExecutionContextManager {
+        public HostExecutionContextManager();
+        public virtual HostExecutionContext Capture();
+        public virtual void Revert(object previousState);
+        public virtual object SetHostExecutionContext(HostExecutionContext hostExecutionContext);
+    }
+    public unsafe delegate void IOCompletionCallback(uint errorCode, uint numBytes, NativeOverlapped* pOVERLAP); {
+        public IOCompletionCallback(object @object, IntPtr method);
+        public unsafe virtual IAsyncResult BeginInvoke(uint errorCode, uint numBytes, NativeOverlapped* pOVERLAP, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public unsafe virtual void Invoke(uint errorCode, uint numBytes, NativeOverlapped* pOVERLAP);
+    }
+    public struct LockCookie {
+        public bool Equals(LockCookie obj);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(LockCookie a, LockCookie b);
+        public static bool operator !=(LockCookie a, LockCookie b);
+    }
     public class LockRecursionException : Exception {
+        protected LockRecursionException(SerializationInfo info, StreamingContext context);
     }
     public static class Monitor {
+        public static bool Wait(object obj, int millisecondsTimeout, bool exitContext);
+        public static bool Wait(object obj, TimeSpan timeout, bool exitContext);
     }
+    public struct NativeOverlapped {
+        public IntPtr EventHandle;
+        public IntPtr InternalHigh;
+        public IntPtr InternalLow;
+        public int OffsetHigh;
+        public int OffsetLow;
+    }
+    public class Overlapped {
+        public Overlapped();
+        public Overlapped(int offsetLo, int offsetHi, int hEvent, IAsyncResult ar);
+        public Overlapped(int offsetLo, int offsetHi, IntPtr hEvent, IAsyncResult ar);
+        public IAsyncResult AsyncResult { get; set; }
+        public int EventHandle { get; set; }
+        public IntPtr EventHandleIntPtr { get; set; }
+        public int OffsetHigh { get; set; }
+        public int OffsetLow { get; set; }
+        public unsafe static void Free(NativeOverlapped* nativeOverlappedPtr);
+        public unsafe NativeOverlapped* Pack(IOCompletionCallback iocb);
+        public unsafe NativeOverlapped* Pack(IOCompletionCallback iocb, object userData);
+        public unsafe static Overlapped Unpack(NativeOverlapped* nativeOverlappedPtr);
+        public unsafe NativeOverlapped* UnsafePack(IOCompletionCallback iocb);
+        public unsafe NativeOverlapped* UnsafePack(IOCompletionCallback iocb, object userData);
+    }
+    public delegate void ParameterizedThreadStart(object obj); {
+        public ParameterizedThreadStart(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object obj, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object obj);
+    }
+    public sealed class ReaderWriterLock : CriticalFinalizerObject {
+        public ReaderWriterLock();
+        public bool IsReaderLockHeld { get; }
+        public bool IsWriterLockHeld { get; }
+        public int WriterSeqNum { get; }
+        public void AcquireReaderLock(int millisecondsTimeout);
+        public void AcquireReaderLock(TimeSpan timeout);
+        public void AcquireWriterLock(int millisecondsTimeout);
+        public void AcquireWriterLock(TimeSpan timeout);
+        public bool AnyWritersSince(int seqNum);
+        public void DowngradeFromWriterLock(ref LockCookie lockCookie);
+        public LockCookie ReleaseLock();
+        public void ReleaseReaderLock();
+        public void ReleaseWriterLock();
+        public void RestoreLock(ref LockCookie lockCookie);
+        public LockCookie UpgradeToWriterLock(int millisecondsTimeout);
+        public LockCookie UpgradeToWriterLock(TimeSpan timeout);
+    }
+    public sealed class RegisteredWaitHandle : MarshalByRefObject {
+        public bool Unregister(WaitHandle waitObject);
+    }
-    public class SemaphoreFullException : Exception {
+    public class SemaphoreFullException : SystemException {
+        protected SemaphoreFullException(SerializationInfo info, StreamingContext context);
     }
     public class SynchronizationContext {
+        public bool IsWaitNotificationRequired();
+        protected void SetWaitNotificationRequired();
+        public virtual int Wait(IntPtr[] waitHandles, bool waitAll, int millisecondsTimeout);
+        protected static int WaitHelper(IntPtr[] waitHandles, bool waitAll, int millisecondsTimeout);
     }
-    public class SynchronizationLockException : Exception {
+    public class SynchronizationLockException : SystemException {
+        protected SynchronizationLockException(SerializationInfo info, StreamingContext context);
     }
+    public sealed class Thread : CriticalFinalizerObject {
+        public Thread(ParameterizedThreadStart start);
+        public Thread(ParameterizedThreadStart start, int maxStackSize);
+        public Thread(ThreadStart start);
+        public Thread(ThreadStart start, int maxStackSize);
+        public ApartmentState ApartmentState { get; set; }
+        public CultureInfo CurrentCulture { get; set; }
+        public static IPrincipal CurrentPrincipal { get; set; }
+        public static Thread CurrentThread { get; }
+        public CultureInfo CurrentUICulture { get; set; }
+        public ExecutionContext ExecutionContext { get; }
+        public bool IsAlive { get; }
+        public bool IsBackground { get; set; }
+        public bool IsThreadPoolThread { get; }
+        public int ManagedThreadId { get; }
+        public string Name { get; set; }
+        public ThreadPriority Priority { get; set; }
+        public ThreadState ThreadState { get; }
+        public void Abort();
+        public void Abort(object stateInfo);
+        public static LocalDataStoreSlot AllocateDataSlot();
+        public static LocalDataStoreSlot AllocateNamedDataSlot(string name);
+        public static void BeginCriticalRegion();
+        public static void BeginThreadAffinity();
+        public void DisableComObjectEagerCleanup();
+        public static void EndCriticalRegion();
+        public static void EndThreadAffinity();
+        public static void FreeNamedDataSlot(string name);
+        public ApartmentState GetApartmentState();
+        public CompressedStack GetCompressedStack();
+        public static object GetData(LocalDataStoreSlot slot);
+        public static AppDomain GetDomain();
+        public static int GetDomainID();
+        public override int GetHashCode();
+        public static LocalDataStoreSlot GetNamedDataSlot(string name);
+        public void Interrupt();
+        public void Join();
+        public bool Join(int millisecondsTimeout);
+        public bool Join(TimeSpan timeout);
+        public static void MemoryBarrier();
+        public static void ResetAbort();
+        public void Resume();
+        public void SetApartmentState(ApartmentState state);
+        public void SetCompressedStack(CompressedStack stack);
+        public static void SetData(LocalDataStoreSlot slot, object data);
+        public static void Sleep(int millisecondsTimeout);
+        public static void Sleep(TimeSpan timeout);
+        public static void SpinWait(int iterations);
+        public void Start();
+        public void Start(object parameter);
+        public void Suspend();
+        public bool TrySetApartmentState(ApartmentState state);
+        public static byte VolatileRead(ref byte address);
+        public static double VolatileRead(ref double address);
+        public static short VolatileRead(ref short address);
+        public static int VolatileRead(ref int address);
+        public static long VolatileRead(ref long address);
+        public static IntPtr VolatileRead(ref IntPtr address);
+        public static object VolatileRead(ref object address);
+        public static sbyte VolatileRead(ref sbyte address);
+        public static float VolatileRead(ref float address);
+        public static ushort VolatileRead(ref ushort address);
+        public static uint VolatileRead(ref uint address);
+        public static ulong VolatileRead(ref ulong address);
+        public static UIntPtr VolatileRead(ref UIntPtr address);
+        public static void VolatileWrite(ref byte address, byte value);
+        public static void VolatileWrite(ref double address, double value);
+        public static void VolatileWrite(ref short address, short value);
+        public static void VolatileWrite(ref int address, int value);
+        public static void VolatileWrite(ref long address, long value);
+        public static void VolatileWrite(ref IntPtr address, IntPtr value);
+        public static void VolatileWrite(ref object address, object value);
+        public static void VolatileWrite(ref sbyte address, sbyte value);
+        public static void VolatileWrite(ref float address, float value);
+        public static void VolatileWrite(ref ushort address, ushort value);
+        public static void VolatileWrite(ref uint address, uint value);
+        public static void VolatileWrite(ref ulong address, ulong value);
+        public static void VolatileWrite(ref UIntPtr address, UIntPtr value);
+        public static bool Yield();
+    }
+    public sealed class ThreadAbortException : SystemException {
+        public object ExceptionState { get; }
+    }
+    public class ThreadExceptionEventArgs : EventArgs {
+        public ThreadExceptionEventArgs(Exception t);
+        public Exception Exception { get; }
+    }
+    public delegate void ThreadExceptionEventHandler(object sender, ThreadExceptionEventArgs e); {
+        public ThreadExceptionEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ThreadExceptionEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ThreadExceptionEventArgs e);
+    }
+    public class ThreadInterruptedException : SystemException {
+        public ThreadInterruptedException();
+        protected ThreadInterruptedException(SerializationInfo info, StreamingContext context);
+        public ThreadInterruptedException(string message);
+        public ThreadInterruptedException(string message, Exception innerException);
+    }
+    public static class ThreadPool {
+        public static bool BindHandle(IntPtr osHandle);
+        public static bool BindHandle(SafeHandle osHandle);
+        public static void GetAvailableThreads(out int workerThreads, out int completionPortThreads);
+        public static void GetMaxThreads(out int workerThreads, out int completionPortThreads);
+        public static void GetMinThreads(out int workerThreads, out int completionPortThreads);
+        public static bool QueueUserWorkItem(WaitCallback callBack);
+        public static bool QueueUserWorkItem(WaitCallback callBack, object state);
+        public static RegisteredWaitHandle RegisterWaitForSingleObject(WaitHandle waitObject, WaitOrTimerCallback callBack, object state, int millisecondsTimeOutInterval, bool executeOnlyOnce);
+        public static RegisteredWaitHandle RegisterWaitForSingleObject(WaitHandle waitObject, WaitOrTimerCallback callBack, object state, long millisecondsTimeOutInterval, bool executeOnlyOnce);
+        public static RegisteredWaitHandle RegisterWaitForSingleObject(WaitHandle waitObject, WaitOrTimerCallback callBack, object state, TimeSpan timeout, bool executeOnlyOnce);
+        public static RegisteredWaitHandle RegisterWaitForSingleObject(WaitHandle waitObject, WaitOrTimerCallback callBack, object state, uint millisecondsTimeOutInterval, bool executeOnlyOnce);
+        public static bool SetMaxThreads(int workerThreads, int completionPortThreads);
+        public static bool SetMinThreads(int workerThreads, int completionPortThreads);
+        public unsafe static bool UnsafeQueueNativeOverlapped(NativeOverlapped* overlapped);
+        public static bool UnsafeQueueUserWorkItem(WaitCallback callBack, object state);
+        public static RegisteredWaitHandle UnsafeRegisterWaitForSingleObject(WaitHandle waitObject, WaitOrTimerCallback callBack, object state, int millisecondsTimeOutInterval, bool executeOnlyOnce);
+        public static RegisteredWaitHandle UnsafeRegisterWaitForSingleObject(WaitHandle waitObject, WaitOrTimerCallback callBack, object state, long millisecondsTimeOutInterval, bool executeOnlyOnce);
+        public static RegisteredWaitHandle UnsafeRegisterWaitForSingleObject(WaitHandle waitObject, WaitOrTimerCallback callBack, object state, TimeSpan timeout, bool executeOnlyOnce);
+        public static RegisteredWaitHandle UnsafeRegisterWaitForSingleObject(WaitHandle waitObject, WaitOrTimerCallback callBack, object state, uint millisecondsTimeOutInterval, bool executeOnlyOnce);
+    }
+    public enum ThreadPriority {
+        AboveNormal = 3,
+        BelowNormal = 1,
+        Highest = 4,
+        Lowest = 0,
+        Normal = 2,
+    }
+    public delegate void ThreadStart(); {
+        public ThreadStart(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke();
+    }
+    public sealed class ThreadStartException : SystemException
+    public enum ThreadState {
+        Aborted = 256,
+        AbortRequested = 128,
+        Background = 4,
+        Running = 0,
+        Stopped = 16,
+        StopRequested = 1,
+        Suspended = 64,
+        SuspendRequested = 2,
+        Unstarted = 8,
+        WaitSleepJoin = 32,
+    }
+    public class ThreadStateException : SystemException {
+        public ThreadStateException();
+        protected ThreadStateException(SerializationInfo info, StreamingContext context);
+        public ThreadStateException(string message);
+        public ThreadStateException(string message, Exception innerException);
+    }
-    public sealed class Timer : IDisposable {
+    public sealed class Timer : MarshalByRefObject, IDisposable {
+        public Timer(TimerCallback callback);
+        public Timer(TimerCallback callback, object state, long dueTime, long period);
+        public Timer(TimerCallback callback, object state, uint dueTime, uint period);
+        public bool Change(long dueTime, long period);
+        public bool Change(uint dueTime, uint period);
+        public bool Dispose(WaitHandle notifyObject);
     }
+    public delegate void WaitCallback(object state); {
+        public WaitCallback(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object state, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object state);
+    }
-    public abstract class WaitHandle : IDisposable {
+    public abstract class WaitHandle : MarshalByRefObject, IDisposable {
+        public virtual IntPtr Handle { get; set; }
+        public SafeWaitHandle SafeWaitHandle { get; set; }
+        public virtual void Close();
+        public static bool SignalAndWait(WaitHandle toSignal, WaitHandle toWaitOn);
+        public static bool SignalAndWait(WaitHandle toSignal, WaitHandle toWaitOn, int millisecondsTimeout, bool exitContext);
+        public static bool SignalAndWait(WaitHandle toSignal, WaitHandle toWaitOn, TimeSpan timeout, bool exitContext);
+        public static bool WaitAll(WaitHandle[] waitHandles, int millisecondsTimeout, bool exitContext);
+        public static bool WaitAll(WaitHandle[] waitHandles, TimeSpan timeout, bool exitContext);
+        public static int WaitAny(WaitHandle[] waitHandles, int millisecondsTimeout, bool exitContext);
+        public static int WaitAny(WaitHandle[] waitHandles, TimeSpan timeout, bool exitContext);
+        public virtual bool WaitOne(int millisecondsTimeout, bool exitContext);
+        public virtual bool WaitOne(TimeSpan timeout, bool exitContext);
     }
-    public class WaitHandleCannotBeOpenedException : Exception {
+    public class WaitHandleCannotBeOpenedException : ApplicationException {
+        protected WaitHandleCannotBeOpenedException(SerializationInfo info, StreamingContext context);
     }
+    public delegate void WaitOrTimerCallback(object state, bool timedOut); {
+        public WaitOrTimerCallback(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object state, bool timedOut, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object state, bool timedOut);
+    }
 }
 namespace System.Threading.Tasks {
+    public static class Parallel {
+        public static ParallelLoopResult For<TLocal>(int fromInclusive, int toExclusive, Func<TLocal> localInit, Func<int, ParallelLoopState, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult For<TLocal>(long fromInclusive, long toExclusive, Func<TLocal> localInit, Func<long, ParallelLoopState, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult For<TLocal>(int fromInclusive, int toExclusive, ParallelOptions parallelOptions, Func<TLocal> localInit, Func<int, ParallelLoopState, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult For<TLocal>(long fromInclusive, long toExclusive, ParallelOptions parallelOptions, Func<TLocal> localInit, Func<long, ParallelLoopState, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult For(int fromInclusive, int toExclusive, Action<int> body);
+        public static ParallelLoopResult For(int fromInclusive, int toExclusive, Action<int, ParallelLoopState> body);
+        public static ParallelLoopResult For(int fromInclusive, int toExclusive, ParallelOptions parallelOptions, Action<int> body);
+        public static ParallelLoopResult For(int fromInclusive, int toExclusive, ParallelOptions parallelOptions, Action<int, ParallelLoopState> body);
+        public static ParallelLoopResult For(long fromInclusive, long toExclusive, Action<long> body);
+        public static ParallelLoopResult For(long fromInclusive, long toExclusive, Action<long, ParallelLoopState> body);
+        public static ParallelLoopResult For(long fromInclusive, long toExclusive, ParallelOptions parallelOptions, Action<long> body);
+        public static ParallelLoopResult For(long fromInclusive, long toExclusive, ParallelOptions parallelOptions, Action<long, ParallelLoopState> body);
+        public static ParallelLoopResult ForEach<TSource>(Partitioner<TSource> source, Action<TSource> body);
+        public static ParallelLoopResult ForEach<TSource>(IEnumerable<TSource> source, Action<TSource> body);
+        public static ParallelLoopResult ForEach<TSource>(Partitioner<TSource> source, ParallelOptions parallelOptions, Action<TSource> body);
+        public static ParallelLoopResult ForEach<TSource>(IEnumerable<TSource> source, ParallelOptions parallelOptions, Action<TSource> body);
+        public static ParallelLoopResult ForEach<TSource>(Partitioner<TSource> source, Action<TSource, ParallelLoopState> body);
+        public static ParallelLoopResult ForEach<TSource>(IEnumerable<TSource> source, Action<TSource, ParallelLoopState> body);
+        public static ParallelLoopResult ForEach<TSource>(IEnumerable<TSource> source, Action<TSource, ParallelLoopState, long> body);
+        public static ParallelLoopResult ForEach<TSource>(OrderablePartitioner<TSource> source, Action<TSource, ParallelLoopState, long> body);
+        public static ParallelLoopResult ForEach<TSource>(Partitioner<TSource> source, ParallelOptions parallelOptions, Action<TSource, ParallelLoopState> body);
+        public static ParallelLoopResult ForEach<TSource>(IEnumerable<TSource> source, ParallelOptions parallelOptions, Action<TSource, ParallelLoopState> body);
+        public static ParallelLoopResult ForEach<TSource>(IEnumerable<TSource> source, ParallelOptions parallelOptions, Action<TSource, ParallelLoopState, long> body);
+        public static ParallelLoopResult ForEach<TSource>(OrderablePartitioner<TSource> source, ParallelOptions parallelOptions, Action<TSource, ParallelLoopState, long> body);
+        public static ParallelLoopResult ForEach<TSource, TLocal>(Partitioner<TSource> source, Func<TLocal> localInit, Func<TSource, ParallelLoopState, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult ForEach<TSource, TLocal>(IEnumerable<TSource> source, Func<TLocal> localInit, Func<TSource, ParallelLoopState, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult ForEach<TSource, TLocal>(IEnumerable<TSource> source, Func<TLocal> localInit, Func<TSource, ParallelLoopState, long, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult ForEach<TSource, TLocal>(OrderablePartitioner<TSource> source, Func<TLocal> localInit, Func<TSource, ParallelLoopState, long, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult ForEach<TSource, TLocal>(Partitioner<TSource> source, ParallelOptions parallelOptions, Func<TLocal> localInit, Func<TSource, ParallelLoopState, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult ForEach<TSource, TLocal>(IEnumerable<TSource> source, ParallelOptions parallelOptions, Func<TLocal> localInit, Func<TSource, ParallelLoopState, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult ForEach<TSource, TLocal>(IEnumerable<TSource> source, ParallelOptions parallelOptions, Func<TLocal> localInit, Func<TSource, ParallelLoopState, long, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static ParallelLoopResult ForEach<TSource, TLocal>(OrderablePartitioner<TSource> source, ParallelOptions parallelOptions, Func<TLocal> localInit, Func<TSource, ParallelLoopState, long, TLocal, TLocal> body, Action<TLocal> localFinally);
+        public static void Invoke(params Action[] actions);
+        public static void Invoke(ParallelOptions parallelOptions, params Action[] actions);
+    }
+    public struct ParallelLoopResult {
+        public bool IsCompleted { get; }
+        public Nullable<long> LowestBreakIteration { get; }
+    }
+    public class ParallelLoopState {
+        public bool IsExceptional { get; }
+        public bool IsStopped { get; }
+        public Nullable<long> LowestBreakIteration { get; }
+        public bool ShouldExitCurrentIteration { get; }
+        public void Break();
+        public void Stop();
+    }
+    public class ParallelOptions {
+        public ParallelOptions();
+        public CancellationToken CancellationToken { get; set; }
+        public int MaxDegreeOfParallelism { get; set; }
+        public TaskScheduler TaskScheduler { get; set; }
+    }
-    public class Task : IAsyncResult {
+    public class Task : IAsyncResult, IDisposable {
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
     }
     public class TaskCanceledException : OperationCanceledException {
+        protected TaskCanceledException(SerializationInfo info, StreamingContext context);
     }
     public class TaskSchedulerException : Exception {
+        protected TaskSchedulerException(SerializationInfo info, StreamingContext context);
     }
 }
+namespace System.Timers {
+    public class ElapsedEventArgs : EventArgs {
+        public DateTime SignalTime { get; }
+    }
+    public delegate void ElapsedEventHandler(object sender, ElapsedEventArgs e); {
+        public ElapsedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ElapsedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ElapsedEventArgs e);
+    }
+    public class Timer : Component, ISupportInitialize {
+        public Timer();
+        public Timer(double interval);
+        public bool AutoReset { get; set; }
+        public bool Enabled { get; set; }
+        public double Interval { get; set; }
+        public override ISite Site { get; set; }
+        public ISynchronizeInvoke SynchronizingObject { get; set; }
+        public void BeginInit();
+        public void Close();
+        protected override void Dispose(bool disposing);
+        public void EndInit();
+        public void Start();
+        public void Stop();
+        public event ElapsedEventHandler Elapsed;
+    }
+    public class TimersDescriptionAttribute : DescriptionAttribute {
+        public TimersDescriptionAttribute(string description);
+        public override string Description { get; }
+    }
+}
+namespace System.Web {
+    public sealed class HttpUtility {
+        public HttpUtility();
+        public static string HtmlAttributeEncode(string s);
+        public static void HtmlAttributeEncode(string s, TextWriter output);
+        public static string HtmlDecode(string s);
+        public static void HtmlDecode(string s, TextWriter output);
+        public static string HtmlEncode(object value);
+        public static string HtmlEncode(string s);
+        public static void HtmlEncode(string s, TextWriter output);
+        public static string JavaScriptStringEncode(string value);
+        public static string JavaScriptStringEncode(string value, bool addDoubleQuotes);
+        public static NameValueCollection ParseQueryString(string query);
+        public static NameValueCollection ParseQueryString(string query, Encoding encoding);
+        public static string UrlDecode(byte[] bytes, Encoding e);
+        public static string UrlDecode(byte[] bytes, int offset, int count, Encoding e);
+        public static string UrlDecode(string str);
+        public static string UrlDecode(string str, Encoding e);
+        public static byte[] UrlDecodeToBytes(byte[] bytes);
+        public static byte[] UrlDecodeToBytes(byte[] bytes, int offset, int count);
+        public static byte[] UrlDecodeToBytes(string str);
+        public static byte[] UrlDecodeToBytes(string str, Encoding e);
+        public static string UrlEncode(byte[] bytes);
+        public static string UrlEncode(byte[] bytes, int offset, int count);
+        public static string UrlEncode(string str);
+        public static string UrlEncode(string str, Encoding e);
+        public static byte[] UrlEncodeToBytes(byte[] bytes);
+        public static byte[] UrlEncodeToBytes(byte[] bytes, int offset, int count);
+        public static byte[] UrlEncodeToBytes(string str);
+        public static byte[] UrlEncodeToBytes(string str, Encoding e);
+        public static string UrlEncodeUnicode(string str);
+        public static byte[] UrlEncodeUnicodeToBytes(string str);
+        public static string UrlPathEncode(string str);
+    }
+}
 namespace System.Xml {
     public enum DtdProcessing {
+        Parse = 2,
     }
+    public enum EntityHandling {
+        ExpandCharEntities = 2,
+        ExpandEntities = 1,
+    }
+    public enum Formatting {
+        Indented = 1,
+        None = 0,
+    }
+    public interface IFragmentCapableXmlDictionaryWriter {
+        bool CanFragment { get; }
+        void EndFragment();
+        void StartFragment(Stream stream, bool generateSelfContainedTextFragment);
+        void WriteFragment(byte[] buffer, int offset, int count);
+    }
+    public interface IHasXmlNode {
+        XmlNode GetNode();
+    }
+    public interface IStreamProvider {
+        Stream GetStream();
+        void ReleaseStream(Stream stream);
+    }
+    public interface IXmlBinaryReaderInitializer {
+        void SetInput(byte[] buffer, int offset, int count, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas, XmlBinaryReaderSession session, OnXmlDictionaryReaderClose onClose);
+        void SetInput(Stream stream, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas, XmlBinaryReaderSession session, OnXmlDictionaryReaderClose onClose);
+    }
+    public interface IXmlBinaryWriterInitializer {
+        void SetOutput(Stream stream, IXmlDictionary dictionary, XmlBinaryWriterSession session, bool ownsStream);
+    }
+    public interface IXmlDictionary {
+        bool TryLookup(int key, out XmlDictionaryString result);
+        bool TryLookup(string value, out XmlDictionaryString result);
+        bool TryLookup(XmlDictionaryString value, out XmlDictionaryString result);
+    }
+    public interface IXmlMtomReaderInitializer {
+        void SetInput(byte[] buffer, int offset, int count, Encoding[] encodings, string contentType, XmlDictionaryReaderQuotas quotas, int maxBufferSize, OnXmlDictionaryReaderClose onClose);
+        void SetInput(Stream stream, Encoding[] encodings, string contentType, XmlDictionaryReaderQuotas quotas, int maxBufferSize, OnXmlDictionaryReaderClose onClose);
+    }
+    public interface IXmlMtomWriterInitializer {
+        void SetOutput(Stream stream, Encoding encoding, int maxSizeInBytes, string startInfo, string boundary, string startUri, bool writeMessageHeaders, bool ownsStream);
+    }
+    public interface IXmlTextReaderInitializer {
+        void SetInput(byte[] buffer, int offset, int count, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+        void SetInput(Stream stream, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+    }
+    public interface IXmlTextWriterInitializer {
+        void SetOutput(Stream stream, Encoding encoding, bool ownsStream);
+    }
+    public delegate void OnXmlDictionaryReaderClose(XmlDictionaryReader reader); {
+        public OnXmlDictionaryReaderClose(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(XmlDictionaryReader reader, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(XmlDictionaryReader reader);
+    }
+    public class UniqueId {
+        public UniqueId();
+        public UniqueId(byte[] guid);
+        public UniqueId(byte[] guid, int offset);
+        public UniqueId(char[] chars, int offset, int count);
+        public UniqueId(Guid guid);
+        public UniqueId(string value);
+        public int CharArrayLength { get; }
+        public bool IsGuid { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(UniqueId id1, UniqueId id2);
+        public static bool operator !=(UniqueId id1, UniqueId id2);
+        public int ToCharArray(char[] chars, int offset);
+        public override string ToString();
+        public bool TryGetGuid(byte[] buffer, int offset);
+        public bool TryGetGuid(out Guid guid);
+    }
+    public enum ValidationType {
+        Auto = 1,
+        DTD = 2,
+        None = 0,
+        Schema = 4,
+        XDR = 3,
+    }
+    public enum WhitespaceHandling {
+        All = 0,
+        None = 2,
+        Significant = 1,
+    }
+    public class XmlAttribute : XmlNode {
+        protected internal XmlAttribute(string prefix, string localName, string namespaceURI, XmlDocument doc);
+        public override string BaseURI { get; }
+        public override string InnerText { set; }
+        public override string InnerXml { set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override string NamespaceURI { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlDocument OwnerDocument { get; }
+        public virtual XmlElement OwnerElement { get; }
+        public override XmlNode ParentNode { get; }
+        public override string Prefix { get; set; }
+        public override IXmlSchemaInfo SchemaInfo { get; }
+        public virtual bool Specified { get; }
+        public override string Value { get; set; }
+        public override XmlNode AppendChild(XmlNode newChild);
+        public override XmlNode CloneNode(bool deep);
+        public override XmlNode InsertAfter(XmlNode newChild, XmlNode refChild);
+        public override XmlNode InsertBefore(XmlNode newChild, XmlNode refChild);
+        public override XmlNode PrependChild(XmlNode newChild);
+        public override XmlNode RemoveChild(XmlNode oldChild);
+        public override XmlNode ReplaceChild(XmlNode newChild, XmlNode oldChild);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public sealed class XmlAttributeCollection : XmlNamedNodeMap, ICollection, IEnumerable {
+        public XmlAttribute this[int i] { get; }
+        public XmlAttribute this[string localName, string namespaceURI] { get; }
+        public XmlAttribute this[string name] { get; }
+        public XmlAttribute Append(XmlAttribute node);
+        public void CopyTo(XmlAttribute[] array, int index);
+        public XmlAttribute InsertAfter(XmlAttribute newNode, XmlAttribute refNode);
+        public XmlAttribute InsertBefore(XmlAttribute newNode, XmlAttribute refNode);
+        public XmlAttribute Prepend(XmlAttribute node);
+        public XmlAttribute Remove(XmlAttribute node);
+        public void RemoveAll();
+        public XmlAttribute RemoveAt(int i);
+        public override XmlNode SetNamedItem(XmlNode node);
+    }
+    public class XmlBinaryReaderSession : IXmlDictionary {
+        public XmlBinaryReaderSession();
+        public XmlDictionaryString Add(int id, string value);
+        public void Clear();
+        public bool TryLookup(int key, out XmlDictionaryString result);
+        public bool TryLookup(string value, out XmlDictionaryString result);
+        public bool TryLookup(XmlDictionaryString value, out XmlDictionaryString result);
+    }
+    public class XmlBinaryWriterSession {
+        public XmlBinaryWriterSession();
+        public void Reset();
+        public virtual bool TryAdd(XmlDictionaryString value, out int key);
+    }
+    public class XmlCDataSection : XmlCharacterData {
+        protected internal XmlCDataSection(string data, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode PreviousText { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public abstract class XmlCharacterData : XmlLinkedNode {
+        protected internal XmlCharacterData(string data, XmlDocument doc);
+        public virtual string Data { get; set; }
+        public override string InnerText { get; set; }
+        public virtual int Length { get; }
+        public override string Value { get; set; }
+        public virtual void AppendData(string strData);
+        public virtual void DeleteData(int offset, int count);
+        public virtual void InsertData(int offset, string strData);
+        public virtual void ReplaceData(int offset, int count, string strData);
+        public virtual string Substring(int offset, int count);
+    }
+    public class XmlComment : XmlCharacterData {
+        protected internal XmlComment(string comment, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
-    public static class XmlConvert {
+    public class XmlConvert {
+        public XmlConvert();
+        public static bool IsNCNameChar(char ch);
+        public static bool IsPublicIdChar(char ch);
+        public static bool IsStartNCNameChar(char ch);
+        public static bool IsWhitespaceChar(char ch);
+        public static bool IsXmlChar(char ch);
+        public static bool IsXmlSurrogatePair(char lowChar, char highChar);
+        public static DateTime ToDateTime(string s);
+        public static DateTime ToDateTime(string s, string format);
+        public static DateTime ToDateTime(string s, string[] formats);
+        public static string ToString(DateTime value);
+        public static string ToString(DateTime value, string format);
+        public static string VerifyTOKEN(string token);
     }
+    public class XmlDeclaration : XmlLinkedNode {
+        protected internal XmlDeclaration(string version, string encoding, string standalone, XmlDocument doc);
+        public string Encoding { get; set; }
+        public override string InnerText { get; set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public string Standalone { get; set; }
+        public override string Value { get; set; }
+        public string Version { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlDictionary : IXmlDictionary {
+        public XmlDictionary();
+        public XmlDictionary(int capacity);
+        public static IXmlDictionary Empty { get; }
+        public virtual XmlDictionaryString Add(string value);
+        public virtual bool TryLookup(int key, out XmlDictionaryString result);
+        public virtual bool TryLookup(string value, out XmlDictionaryString result);
+        public virtual bool TryLookup(XmlDictionaryString value, out XmlDictionaryString result);
+    }
+    public abstract class XmlDictionaryReader : XmlReader {
+        protected XmlDictionaryReader();
+        public virtual bool CanCanonicalize { get; }
+        public virtual XmlDictionaryReaderQuotas Quotas { get; }
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, int offset, int count, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, int offset, int count, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas, XmlBinaryReaderSession session);
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, int offset, int count, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas, XmlBinaryReaderSession session, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, int offset, int count, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateBinaryReader(byte[] buffer, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateBinaryReader(Stream stream, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateBinaryReader(Stream stream, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas, XmlBinaryReaderSession session);
+        public static XmlDictionaryReader CreateBinaryReader(Stream stream, IXmlDictionary dictionary, XmlDictionaryReaderQuotas quotas, XmlBinaryReaderSession session, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateBinaryReader(Stream stream, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateDictionaryReader(XmlReader reader);
+        public static XmlDictionaryReader CreateMtomReader(byte[] buffer, int offset, int count, Encoding encoding, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateMtomReader(byte[] buffer, int offset, int count, Encoding[] encodings, string contentType, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateMtomReader(byte[] buffer, int offset, int count, Encoding[] encodings, string contentType, XmlDictionaryReaderQuotas quotas, int maxBufferSize, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateMtomReader(byte[] buffer, int offset, int count, Encoding[] encodings, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateMtomReader(Stream stream, Encoding encoding, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateMtomReader(Stream stream, Encoding[] encodings, string contentType, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateMtomReader(Stream stream, Encoding[] encodings, string contentType, XmlDictionaryReaderQuotas quotas, int maxBufferSize, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateMtomReader(Stream stream, Encoding[] encodings, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateTextReader(byte[] buffer, int offset, int count, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateTextReader(byte[] buffer, int offset, int count, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateTextReader(byte[] buffer, XmlDictionaryReaderQuotas quotas);
+        public static XmlDictionaryReader CreateTextReader(Stream stream, Encoding encoding, XmlDictionaryReaderQuotas quotas, OnXmlDictionaryReaderClose onClose);
+        public static XmlDictionaryReader CreateTextReader(Stream stream, XmlDictionaryReaderQuotas quotas);
+        public virtual void EndCanonicalization();
+        public virtual string GetAttribute(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void GetNonAtomizedNames(out string localName, out string namespaceUri);
+        public virtual int IndexOfLocalName(string[] localNames, string namespaceUri);
+        public virtual int IndexOfLocalName(XmlDictionaryString[] localNames, XmlDictionaryString namespaceUri);
+        public virtual bool IsLocalName(string localName);
+        public virtual bool IsLocalName(XmlDictionaryString localName);
+        public virtual bool IsNamespaceUri(string namespaceUri);
+        public virtual bool IsNamespaceUri(XmlDictionaryString namespaceUri);
+        public virtual bool IsStartArray(out Type type);
+        public virtual bool IsStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        protected bool IsTextNode(XmlNodeType nodeType);
+        public virtual void MoveToStartElement();
+        public virtual void MoveToStartElement(string name);
+        public virtual void MoveToStartElement(string localName, string namespaceUri);
+        public virtual void MoveToStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual int ReadArray(string localName, string namespaceUri, bool[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, DateTime[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, decimal[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, double[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, Guid[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, short[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, int[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, long[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, float[] array, int offset, int count);
+        public virtual int ReadArray(string localName, string namespaceUri, TimeSpan[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, bool[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, DateTime[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, decimal[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, double[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, Guid[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, short[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, int[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, long[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, float[] array, int offset, int count);
+        public virtual int ReadArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri, TimeSpan[] array, int offset, int count);
+        public virtual bool[] ReadBooleanArray(string localName, string namespaceUri);
+        public virtual bool[] ReadBooleanArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public override object ReadContentAs(Type type, IXmlNamespaceResolver namespaceResolver);
+        public virtual byte[] ReadContentAsBase64();
+        public virtual byte[] ReadContentAsBinHex();
+        protected byte[] ReadContentAsBinHex(int maxByteArrayContentLength);
+        public virtual int ReadContentAsChars(char[] chars, int offset, int count);
+        public override decimal ReadContentAsDecimal();
+        public override float ReadContentAsFloat();
+        public virtual Guid ReadContentAsGuid();
+        public virtual void ReadContentAsQualifiedName(out string localName, out string namespaceUri);
+        public override string ReadContentAsString();
+        protected string ReadContentAsString(int maxStringContentLength);
+        public virtual string ReadContentAsString(string[] strings, out int index);
+        public virtual string ReadContentAsString(XmlDictionaryString[] strings, out int index);
+        public virtual TimeSpan ReadContentAsTimeSpan();
+        public virtual UniqueId ReadContentAsUniqueId();
+        public virtual DateTime[] ReadDateTimeArray(string localName, string namespaceUri);
+        public virtual DateTime[] ReadDateTimeArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual decimal[] ReadDecimalArray(string localName, string namespaceUri);
+        public virtual decimal[] ReadDecimalArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual double[] ReadDoubleArray(string localName, string namespaceUri);
+        public virtual double[] ReadDoubleArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual byte[] ReadElementContentAsBase64();
+        public virtual byte[] ReadElementContentAsBinHex();
+        public override bool ReadElementContentAsBoolean();
+        public override DateTime ReadElementContentAsDateTime();
+        public override decimal ReadElementContentAsDecimal();
+        public override double ReadElementContentAsDouble();
+        public override float ReadElementContentAsFloat();
+        public virtual Guid ReadElementContentAsGuid();
+        public override int ReadElementContentAsInt();
+        public override long ReadElementContentAsLong();
+        public override string ReadElementContentAsString();
+        public virtual TimeSpan ReadElementContentAsTimeSpan();
+        public virtual UniqueId ReadElementContentAsUniqueId();
+        public virtual void ReadFullStartElement();
+        public virtual void ReadFullStartElement(string name);
+        public virtual void ReadFullStartElement(string localName, string namespaceUri);
+        public virtual void ReadFullStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual Guid[] ReadGuidArray(string localName, string namespaceUri);
+        public virtual Guid[] ReadGuidArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual short[] ReadInt16Array(string localName, string namespaceUri);
+        public virtual short[] ReadInt16Array(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual int[] ReadInt32Array(string localName, string namespaceUri);
+        public virtual int[] ReadInt32Array(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual long[] ReadInt64Array(string localName, string namespaceUri);
+        public virtual long[] ReadInt64Array(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual float[] ReadSingleArray(string localName, string namespaceUri);
+        public virtual float[] ReadSingleArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void ReadStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public override string ReadString();
+        protected string ReadString(int maxStringContentLength);
+        public virtual TimeSpan[] ReadTimeSpanArray(string localName, string namespaceUri);
+        public virtual TimeSpan[] ReadTimeSpanArray(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual int ReadValueAsBase64(byte[] buffer, int offset, int count);
+        public virtual void StartCanonicalization(Stream stream, bool includeComments, string[] inclusivePrefixes);
+        public virtual bool TryGetArrayLength(out int count);
+        public virtual bool TryGetBase64ContentLength(out int length);
+        public virtual bool TryGetLocalNameAsDictionaryString(out XmlDictionaryString localName);
+        public virtual bool TryGetNamespaceUriAsDictionaryString(out XmlDictionaryString namespaceUri);
+        public virtual bool TryGetValueAsDictionaryString(out XmlDictionaryString value);
+    }
+    public sealed class XmlDictionaryReaderQuotas {
+        public XmlDictionaryReaderQuotas();
+        public static XmlDictionaryReaderQuotas Max { get; }
+        public int MaxArrayLength { get; set; }
+        public int MaxBytesPerRead { get; set; }
+        public int MaxDepth { get; set; }
+        public int MaxNameTableCharCount { get; set; }
+        public int MaxStringContentLength { get; set; }
+        public XmlDictionaryReaderQuotaTypes ModifiedQuotas { get; }
+        public void CopyTo(XmlDictionaryReaderQuotas quotas);
+    }
+    public enum XmlDictionaryReaderQuotaTypes {
+        MaxArrayLength = 4,
+        MaxBytesPerRead = 8,
+        MaxDepth = 1,
+        MaxNameTableCharCount = 16,
+        MaxStringContentLength = 2,
+    }
+    public class XmlDictionaryString {
+        public XmlDictionaryString(IXmlDictionary dictionary, string value, int key);
+        public IXmlDictionary Dictionary { get; }
+        public static XmlDictionaryString Empty { get; }
+        public int Key { get; }
+        public string Value { get; }
+        public override string ToString();
+    }
+    public abstract class XmlDictionaryWriter : XmlWriter {
+        protected XmlDictionaryWriter();
+        public virtual bool CanCanonicalize { get; }
+        public static XmlDictionaryWriter CreateBinaryWriter(Stream stream);
+        public static XmlDictionaryWriter CreateBinaryWriter(Stream stream, IXmlDictionary dictionary);
+        public static XmlDictionaryWriter CreateBinaryWriter(Stream stream, IXmlDictionary dictionary, XmlBinaryWriterSession session);
+        public static XmlDictionaryWriter CreateBinaryWriter(Stream stream, IXmlDictionary dictionary, XmlBinaryWriterSession session, bool ownsStream);
+        public static XmlDictionaryWriter CreateDictionaryWriter(XmlWriter writer);
+        public static XmlDictionaryWriter CreateMtomWriter(Stream stream, Encoding encoding, int maxSizeInBytes, string startInfo);
+        public static XmlDictionaryWriter CreateMtomWriter(Stream stream, Encoding encoding, int maxSizeInBytes, string startInfo, string boundary, string startUri, bool writeMessageHeaders, bool ownsStream);
+        public static XmlDictionaryWriter CreateTextWriter(Stream stream);
+        public static XmlDictionaryWriter CreateTextWriter(Stream stream, Encoding encoding);
+        public static XmlDictionaryWriter CreateTextWriter(Stream stream, Encoding encoding, bool ownsStream);
+        public virtual void EndCanonicalization();
+        public virtual void StartCanonicalization(Stream stream, bool includeComments, string[] inclusivePrefixes);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, bool[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, DateTime[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, decimal[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, double[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, Guid[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, short[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, int[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, long[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, float[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, string localName, string namespaceUri, TimeSpan[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, bool[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, DateTime[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, decimal[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, double[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, Guid[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, short[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, int[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, long[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, float[] array, int offset, int count);
+        public virtual void WriteArray(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, TimeSpan[] array, int offset, int count);
+        public void WriteAttributeString(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, string value);
+        public void WriteAttributeString(XmlDictionaryString localName, XmlDictionaryString namespaceUri, string value);
+        public override Task WriteBase64Async(byte[] buffer, int index, int count);
+        public void WriteElementString(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri, string value);
+        public void WriteElementString(XmlDictionaryString localName, XmlDictionaryString namespaceUri, string value);
+        public virtual void WriteNode(XmlDictionaryReader reader, bool defattr);
+        public override void WriteNode(XmlReader reader, bool defattr);
+        public virtual void WriteQualifiedName(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void WriteStartAttribute(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public void WriteStartAttribute(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void WriteStartElement(string prefix, XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public void WriteStartElement(XmlDictionaryString localName, XmlDictionaryString namespaceUri);
+        public virtual void WriteString(XmlDictionaryString value);
+        protected virtual void WriteTextNode(XmlDictionaryReader reader, bool isAttribute);
+        public virtual void WriteValue(Guid value);
+        public virtual void WriteValue(IStreamProvider value);
+        public virtual void WriteValue(TimeSpan value);
+        public virtual void WriteValue(UniqueId value);
+        public virtual void WriteValue(XmlDictionaryString value);
+        public virtual Task WriteValueAsync(IStreamProvider value);
+        public virtual void WriteXmlAttribute(string localName, string value);
+        public virtual void WriteXmlAttribute(XmlDictionaryString localName, XmlDictionaryString value);
+        public virtual void WriteXmlnsAttribute(string prefix, string namespaceUri);
+        public virtual void WriteXmlnsAttribute(string prefix, XmlDictionaryString namespaceUri);
+    }
+    public class XmlDocument : XmlNode {
+        public XmlDocument();
+        protected internal XmlDocument(XmlImplementation imp);
+        public XmlDocument(XmlNameTable nt);
+        public override string BaseURI { get; }
+        public XmlElement DocumentElement { get; }
+        public virtual XmlDocumentType DocumentType { get; }
+        public XmlImplementation Implementation { get; }
+        public override string InnerText { set; }
+        public override string InnerXml { get; set; }
+        public override bool IsReadOnly { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public XmlNameTable NameTable { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlDocument OwnerDocument { get; }
+        public override XmlNode ParentNode { get; }
+        public bool PreserveWhitespace { get; set; }
+        public override IXmlSchemaInfo SchemaInfo { get; }
+        public XmlSchemaSet Schemas { get; set; }
+        public virtual XmlResolver XmlResolver { set; }
+        public override XmlNode CloneNode(bool deep);
+        public XmlAttribute CreateAttribute(string name);
+        public XmlAttribute CreateAttribute(string qualifiedName, string namespaceURI);
+        public virtual XmlAttribute CreateAttribute(string prefix, string localName, string namespaceURI);
+        public virtual XmlCDataSection CreateCDataSection(string data);
+        public virtual XmlComment CreateComment(string data);
+        protected internal virtual XmlAttribute CreateDefaultAttribute(string prefix, string localName, string namespaceURI);
+        public virtual XmlDocumentFragment CreateDocumentFragment();
+        public virtual XmlDocumentType CreateDocumentType(string name, string publicId, string systemId, string internalSubset);
+        public XmlElement CreateElement(string name);
+        public XmlElement CreateElement(string qualifiedName, string namespaceURI);
+        public virtual XmlElement CreateElement(string prefix, string localName, string namespaceURI);
+        public virtual XmlEntityReference CreateEntityReference(string name);
+        public override XPathNavigator CreateNavigator();
+        protected internal virtual XPathNavigator CreateNavigator(XmlNode node);
+        public virtual XmlNode CreateNode(string nodeTypeString, string name, string namespaceURI);
+        public virtual XmlNode CreateNode(XmlNodeType type, string name, string namespaceURI);
+        public virtual XmlNode CreateNode(XmlNodeType type, string prefix, string name, string namespaceURI);
+        public virtual XmlProcessingInstruction CreateProcessingInstruction(string target, string data);
+        public virtual XmlSignificantWhitespace CreateSignificantWhitespace(string text);
+        public virtual XmlText CreateTextNode(string text);
+        public virtual XmlWhitespace CreateWhitespace(string text);
+        public virtual XmlDeclaration CreateXmlDeclaration(string version, string encoding, string standalone);
+        public virtual XmlElement GetElementById(string elementId);
+        public virtual XmlNodeList GetElementsByTagName(string name);
+        public virtual XmlNodeList GetElementsByTagName(string localName, string namespaceURI);
+        public virtual XmlNode ImportNode(XmlNode node, bool deep);
+        public virtual void Load(Stream inStream);
+        public virtual void Load(string filename);
+        public virtual void Load(TextReader txtReader);
+        public virtual void Load(XmlReader reader);
+        public virtual void LoadXml(string xml);
+        public virtual XmlNode ReadNode(XmlReader reader);
+        public virtual void Save(Stream outStream);
+        public virtual void Save(string filename);
+        public virtual void Save(TextWriter writer);
+        public virtual void Save(XmlWriter w);
+        public void Validate(ValidationEventHandler validationEventHandler);
+        public void Validate(ValidationEventHandler validationEventHandler, XmlNode nodeToValidate);
+        public override void WriteContentTo(XmlWriter xw);
+        public override void WriteTo(XmlWriter w);
+        public event XmlNodeChangedEventHandler NodeChanged;
+        public event XmlNodeChangedEventHandler NodeChanging;
+        public event XmlNodeChangedEventHandler NodeInserted;
+        public event XmlNodeChangedEventHandler NodeInserting;
+        public event XmlNodeChangedEventHandler NodeRemoved;
+        public event XmlNodeChangedEventHandler NodeRemoving;
+    }
+    public class XmlDocumentFragment : XmlNode {
+        protected internal XmlDocumentFragment(XmlDocument ownerDocument);
+        public override string InnerXml { get; set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlDocument OwnerDocument { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlDocumentType : XmlLinkedNode {
+        protected internal XmlDocumentType(string name, string publicId, string systemId, string internalSubset, XmlDocument doc);
+        public XmlNamedNodeMap Entities { get; }
+        public string InternalSubset { get; }
+        public override bool IsReadOnly { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public XmlNamedNodeMap Notations { get; }
+        public string PublicId { get; }
+        public string SystemId { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlElement : XmlLinkedNode {
+        protected internal XmlElement(string prefix, string localName, string namespaceURI, XmlDocument doc);
+        public override XmlAttributeCollection Attributes { get; }
+        public virtual bool HasAttributes { get; }
+        public override string InnerText { get; set; }
+        public override string InnerXml { get; set; }
+        public bool IsEmpty { get; set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override string NamespaceURI { get; }
+        public override XmlNode NextSibling { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlDocument OwnerDocument { get; }
+        public override XmlNode ParentNode { get; }
+        public override string Prefix { get; set; }
+        public override IXmlSchemaInfo SchemaInfo { get; }
+        public override XmlNode CloneNode(bool deep);
+        public virtual string GetAttribute(string name);
+        public virtual string GetAttribute(string localName, string namespaceURI);
+        public virtual XmlAttribute GetAttributeNode(string name);
+        public virtual XmlAttribute GetAttributeNode(string localName, string namespaceURI);
+        public virtual XmlNodeList GetElementsByTagName(string name);
+        public virtual XmlNodeList GetElementsByTagName(string localName, string namespaceURI);
+        public virtual bool HasAttribute(string name);
+        public virtual bool HasAttribute(string localName, string namespaceURI);
+        public override void RemoveAll();
+        public virtual void RemoveAllAttributes();
+        public virtual void RemoveAttribute(string name);
+        public virtual void RemoveAttribute(string localName, string namespaceURI);
+        public virtual XmlNode RemoveAttributeAt(int i);
+        public virtual XmlAttribute RemoveAttributeNode(string localName, string namespaceURI);
+        public virtual XmlAttribute RemoveAttributeNode(XmlAttribute oldAttr);
+        public virtual void SetAttribute(string name, string value);
+        public virtual string SetAttribute(string localName, string namespaceURI, string value);
+        public virtual XmlAttribute SetAttributeNode(string localName, string namespaceURI);
+        public virtual XmlAttribute SetAttributeNode(XmlAttribute newAttr);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlEntity : XmlNode {
+        public override string BaseURI { get; }
+        public override string InnerText { get; set; }
+        public override string InnerXml { get; set; }
+        public override bool IsReadOnly { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public string NotationName { get; }
+        public override string OuterXml { get; }
+        public string PublicId { get; }
+        public string SystemId { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlEntityReference : XmlLinkedNode {
+        protected internal XmlEntityReference(string name, XmlDocument doc);
+        public override string BaseURI { get; }
+        public override bool IsReadOnly { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
-    public class XmlException : Exception {
+    public class XmlException : SystemException {
+        protected XmlException(SerializationInfo info, StreamingContext context);
+        public string SourceUri { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public class XmlImplementation {
+        public XmlImplementation();
+        public XmlImplementation(XmlNameTable nt);
+        public virtual XmlDocument CreateDocument();
+        public bool HasFeature(string strFeature, string strVersion);
+    }
+    public abstract class XmlLinkedNode : XmlNode {
+        public override XmlNode NextSibling { get; }
+        public override XmlNode PreviousSibling { get; }
+    }
+    public class XmlNamedNodeMap : IEnumerable {
+        public virtual int Count { get; }
+        public virtual IEnumerator GetEnumerator();
+        public virtual XmlNode GetNamedItem(string name);
+        public virtual XmlNode GetNamedItem(string localName, string namespaceURI);
+        public virtual XmlNode Item(int index);
+        public virtual XmlNode RemoveNamedItem(string name);
+        public virtual XmlNode RemoveNamedItem(string localName, string namespaceURI);
+        public virtual XmlNode SetNamedItem(XmlNode node);
+    }
+    public abstract class XmlNode : ICloneable, IEnumerable, IXPathNavigable {
+        public virtual XmlAttributeCollection Attributes { get; }
+        public virtual string BaseURI { get; }
+        public virtual XmlNodeList ChildNodes { get; }
+        public virtual XmlNode FirstChild { get; }
+        public virtual bool HasChildNodes { get; }
+        public virtual string InnerText { get; set; }
+        public virtual string InnerXml { get; set; }
+        public virtual bool IsReadOnly { get; }
+        public virtual XmlElement this[string localname, string ns] { get; }
+        public virtual XmlElement this[string name] { get; }
+        public virtual XmlNode LastChild { get; }
+        public abstract string LocalName { get; }
+        public abstract string Name { get; }
+        public virtual string NamespaceURI { get; }
+        public virtual XmlNode NextSibling { get; }
+        public abstract XmlNodeType NodeType { get; }
+        public virtual string OuterXml { get; }
+        public virtual XmlDocument OwnerDocument { get; }
+        public virtual XmlNode ParentNode { get; }
+        public virtual string Prefix { get; set; }
+        public virtual XmlNode PreviousSibling { get; }
+        public virtual XmlNode PreviousText { get; }
+        public virtual IXmlSchemaInfo SchemaInfo { get; }
+        public virtual string Value { get; set; }
+        public virtual XmlNode AppendChild(XmlNode newChild);
+        public virtual XmlNode Clone();
+        public abstract XmlNode CloneNode(bool deep);
+        public virtual XPathNavigator CreateNavigator();
+        public IEnumerator GetEnumerator();
+        public virtual string GetNamespaceOfPrefix(string prefix);
+        public virtual string GetPrefixOfNamespace(string namespaceURI);
+        public virtual XmlNode InsertAfter(XmlNode newChild, XmlNode refChild);
+        public virtual XmlNode InsertBefore(XmlNode newChild, XmlNode refChild);
+        public virtual void Normalize();
+        public virtual XmlNode PrependChild(XmlNode newChild);
+        public virtual void RemoveAll();
+        public virtual XmlNode RemoveChild(XmlNode oldChild);
+        public virtual XmlNode ReplaceChild(XmlNode newChild, XmlNode oldChild);
+        public XmlNodeList SelectNodes(string xpath);
+        public XmlNodeList SelectNodes(string xpath, XmlNamespaceManager nsmgr);
+        public XmlNode SelectSingleNode(string xpath);
+        public XmlNode SelectSingleNode(string xpath, XmlNamespaceManager nsmgr);
+        public virtual bool Supports(string feature, string version);
+        public abstract void WriteContentTo(XmlWriter w);
+        public abstract void WriteTo(XmlWriter w);
+    }
+    public enum XmlNodeChangedAction {
+        Change = 2,
+        Insert = 0,
+        Remove = 1,
+    }
+    public class XmlNodeChangedEventArgs : EventArgs {
+        public XmlNodeChangedEventArgs(XmlNode node, XmlNode oldParent, XmlNode newParent, string oldValue, string newValue, XmlNodeChangedAction action);
+        public XmlNodeChangedAction Action { get; }
+        public XmlNode NewParent { get; }
+        public string NewValue { get; }
+        public XmlNode Node { get; }
+        public XmlNode OldParent { get; }
+        public string OldValue { get; }
+    }
+    public delegate void XmlNodeChangedEventHandler(object sender, XmlNodeChangedEventArgs e); {
+        public XmlNodeChangedEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, XmlNodeChangedEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, XmlNodeChangedEventArgs e);
+    }
+    public abstract class XmlNodeList : IDisposable, IEnumerable {
+        protected XmlNodeList();
+        public abstract int Count { get; }
+        public virtual XmlNode this[int i] { get; }
+        public abstract IEnumerator GetEnumerator();
+        public abstract XmlNode Item(int index);
+        protected virtual void PrivateDisposeNodeList();
+    }
+    public enum XmlNodeOrder {
+        After = 1,
+        Before = 0,
+        Same = 2,
+        Unknown = 3,
+    }
+    public class XmlNodeReader : XmlReader, IXmlNamespaceResolver {
+        public XmlNodeReader(XmlNode node);
+        public override int AttributeCount { get; }
+        public override string BaseURI { get; }
+        public override bool CanReadBinaryContent { get; }
+        public override bool CanResolveEntity { get; }
+        public override int Depth { get; }
+        public override bool EOF { get; }
+        public override bool HasAttributes { get; }
+        public override bool HasValue { get; }
+        public override bool IsDefault { get; }
+        public override bool IsEmptyElement { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override string NamespaceURI { get; }
+        public override XmlNameTable NameTable { get; }
+        public override XmlNodeType NodeType { get; }
+        public override string Prefix { get; }
+        public override ReadState ReadState { get; }
+        public override IXmlSchemaInfo SchemaInfo { get; }
+        public override string Value { get; }
+        public override string XmlLang { get; }
+        public override XmlSpace XmlSpace { get; }
+        public override void Close();
+        public override string GetAttribute(int attributeIndex);
+        public override string GetAttribute(string name);
+        public override string GetAttribute(string name, string namespaceURI);
+        public override string LookupNamespace(string prefix);
+        public override void MoveToAttribute(int attributeIndex);
+        public override bool MoveToAttribute(string name);
+        public override bool MoveToAttribute(string name, string namespaceURI);
+        public override bool MoveToElement();
+        public override bool MoveToFirstAttribute();
+        public override bool MoveToNextAttribute();
+        public override bool Read();
+        public override bool ReadAttributeValue();
+        public override int ReadContentAsBase64(byte[] buffer, int index, int count);
+        public override int ReadContentAsBinHex(byte[] buffer, int index, int count);
+        public override int ReadElementContentAsBase64(byte[] buffer, int index, int count);
+        public override int ReadElementContentAsBinHex(byte[] buffer, int index, int count);
+        public override string ReadString();
+        public override void ResolveEntity();
+        public override void Skip();
+    }
+    public class XmlNotation : XmlNode {
+        public override string InnerXml { get; set; }
+        public override bool IsReadOnly { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override string OuterXml { get; }
+        public string PublicId { get; }
+        public string SystemId { get; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public enum XmlOutputMethod {
+        AutoDetect = 3,
+        Html = 1,
+        Text = 2,
+        Xml = 0,
+    }
+    public class XmlProcessingInstruction : XmlLinkedNode {
+        protected internal XmlProcessingInstruction(string target, string data, XmlDocument doc);
+        public string Data { get; set; }
+        public override string InnerText { get; set; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public string Target { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
     public abstract class XmlReader : IDisposable {
+        public virtual char QuoteChar { get; }
+        public virtual IXmlSchemaInfo SchemaInfo { get; }
+        public virtual void Close();
+        public static XmlReader Create(Stream input, XmlReaderSettings settings, string baseUri);
+        public static XmlReader Create(string inputUri, XmlReaderSettings settings, XmlParserContext inputContext);
+        public static XmlReader Create(TextReader input, XmlReaderSettings settings, string baseUri);
+        public virtual DateTime ReadContentAsDateTime();
+        public virtual DateTime ReadElementContentAsDateTime();
+        public virtual DateTime ReadElementContentAsDateTime(string localName, string namespaceURI);
+        public virtual string ReadElementString();
+        public virtual string ReadElementString(string name);
+        public virtual string ReadElementString(string localname, string ns);
+        public virtual string ReadString();
     }
     public sealed class XmlReaderSettings {
+        public bool ProhibitDtd { get; set; }
+        public XmlSchemaSet Schemas { get; set; }
+        public XmlSchemaValidationFlags ValidationFlags { get; set; }
+        public ValidationType ValidationType { get; set; }
+        public XmlResolver XmlResolver { set; }
+        public event ValidationEventHandler ValidationEventHandler;
     }
+    public abstract class XmlResolver {
+        protected XmlResolver();
+        public virtual ICredentials Credentials { set; }
+        public abstract object GetEntity(Uri absoluteUri, string role, Type ofObjectToReturn);
+        public virtual Task<object> GetEntityAsync(Uri absoluteUri, string role, Type ofObjectToReturn);
+        public virtual Uri ResolveUri(Uri baseUri, string relativeUri);
+        public virtual bool SupportsType(Uri absoluteUri, Type type);
+    }
+    public class XmlSecureResolver : XmlResolver {
+        public XmlSecureResolver(XmlResolver resolver, string securityUrl);
+        public override ICredentials Credentials { set; }
+        public override object GetEntity(Uri absoluteUri, string role, Type ofObjectToReturn);
+        public override Task<object> GetEntityAsync(Uri absoluteUri, string role, Type ofObjectToReturn);
+        public override Uri ResolveUri(Uri baseUri, string relativeUri);
+    }
+    public class XmlSignificantWhitespace : XmlCharacterData {
+        protected internal XmlSignificantWhitespace(string strData, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode PreviousText { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlText : XmlCharacterData {
+        protected internal XmlText(string strData, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode PreviousText { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public virtual XmlText SplitText(int offset);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
+    public class XmlTextReader : XmlReader, IXmlLineInfo, IXmlNamespaceResolver {
+        protected XmlTextReader();
+        public XmlTextReader(Stream input);
+        public XmlTextReader(Stream input, XmlNameTable nt);
+        public XmlTextReader(Stream xmlFragment, XmlNodeType fragType, XmlParserContext context);
+        public XmlTextReader(string url);
+        public XmlTextReader(string url, Stream input);
+        public XmlTextReader(string url, Stream input, XmlNameTable nt);
+        public XmlTextReader(string url, TextReader input);
+        public XmlTextReader(string url, TextReader input, XmlNameTable nt);
+        public XmlTextReader(string url, XmlNameTable nt);
+        public XmlTextReader(string xmlFragment, XmlNodeType fragType, XmlParserContext context);
+        public XmlTextReader(TextReader input);
+        public XmlTextReader(TextReader input, XmlNameTable nt);
+        protected XmlTextReader(XmlNameTable nt);
+        public override int AttributeCount { get; }
+        public override string BaseURI { get; }
+        public override bool CanReadBinaryContent { get; }
+        public override bool CanReadValueChunk { get; }
+        public override bool CanResolveEntity { get; }
+        public override int Depth { get; }
+        public DtdProcessing DtdProcessing { get; set; }
+        public Encoding Encoding { get; }
+        public EntityHandling EntityHandling { get; set; }
+        public override bool EOF { get; }
+        public override bool HasValue { get; }
+        public override bool IsDefault { get; }
+        public override bool IsEmptyElement { get; }
+        public int LineNumber { get; }
+        public int LinePosition { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public bool Namespaces { get; set; }
+        public override string NamespaceURI { get; }
+        public override XmlNameTable NameTable { get; }
+        public override XmlNodeType NodeType { get; }
+        public bool Normalization { get; set; }
+        public override string Prefix { get; }
+        public bool ProhibitDtd { get; set; }
+        public override char QuoteChar { get; }
+        public override ReadState ReadState { get; }
+        public override string Value { get; }
+        public WhitespaceHandling WhitespaceHandling { get; set; }
+        public override string XmlLang { get; }
+        public XmlResolver XmlResolver { set; }
+        public override XmlSpace XmlSpace { get; }
+        public override void Close();
+        public override string GetAttribute(int i);
+        public override string GetAttribute(string name);
+        public override string GetAttribute(string localName, string namespaceURI);
+        public IDictionary<string, string> GetNamespacesInScope(XmlNamespaceScope scope);
+        public TextReader GetRemainder();
+        public bool HasLineInfo();
+        public override string LookupNamespace(string prefix);
+        public override void MoveToAttribute(int i);
+        public override bool MoveToAttribute(string name);
+        public override bool MoveToAttribute(string localName, string namespaceURI);
+        public override bool MoveToElement();
+        public override bool MoveToFirstAttribute();
+        public override bool MoveToNextAttribute();
+        public override bool Read();
+        public override bool ReadAttributeValue();
+        public int ReadBase64(byte[] array, int offset, int len);
+        public int ReadBinHex(byte[] array, int offset, int len);
+        public int ReadChars(char[] buffer, int index, int count);
+        public override int ReadContentAsBase64(byte[] buffer, int index, int count);
+        public override int ReadContentAsBinHex(byte[] buffer, int index, int count);
+        public override int ReadElementContentAsBase64(byte[] buffer, int index, int count);
+        public override int ReadElementContentAsBinHex(byte[] buffer, int index, int count);
+        public override string ReadString();
+        public void ResetState();
+        public override void ResolveEntity();
+        public override void Skip();
+    }
+    public class XmlTextWriter : XmlWriter {
+        public XmlTextWriter(Stream w, Encoding encoding);
+        public XmlTextWriter(string filename, Encoding encoding);
+        public XmlTextWriter(TextWriter w);
+        public Stream BaseStream { get; }
+        public Formatting Formatting { get; set; }
+        public int Indentation { get; set; }
+        public char IndentChar { get; set; }
+        public bool Namespaces { get; set; }
+        public char QuoteChar { get; set; }
+        public override WriteState WriteState { get; }
+        public override string XmlLang { get; }
+        public override XmlSpace XmlSpace { get; }
+        public override void Close();
+        public override void Flush();
+        public override string LookupPrefix(string ns);
+        public override void WriteBase64(byte[] buffer, int index, int count);
+        public override void WriteBinHex(byte[] buffer, int index, int count);
+        public override void WriteCData(string text);
+        public override void WriteCharEntity(char ch);
+        public override void WriteChars(char[] buffer, int index, int count);
+        public override void WriteComment(string text);
+        public override void WriteDocType(string name, string pubid, string sysid, string subset);
+        public override void WriteEndAttribute();
+        public override void WriteEndDocument();
+        public override void WriteEndElement();
+        public override void WriteEntityRef(string name);
+        public override void WriteFullEndElement();
+        public override void WriteName(string name);
+        public override void WriteNmToken(string name);
+        public override void WriteProcessingInstruction(string name, string text);
+        public override void WriteQualifiedName(string localName, string ns);
+        public override void WriteRaw(char[] buffer, int index, int count);
+        public override void WriteRaw(string data);
+        public override void WriteStartAttribute(string prefix, string localName, string ns);
+        public override void WriteStartDocument();
+        public override void WriteStartDocument(bool standalone);
+        public override void WriteStartElement(string prefix, string localName, string ns);
+        public override void WriteString(string text);
+        public override void WriteSurrogateCharEntity(char lowChar, char highChar);
+        public override void WriteWhitespace(string ws);
+    }
+    public enum XmlTokenizedType {
+        CDATA = 0,
+        ENTITIES = 5,
+        ENTITY = 4,
+        ENUMERATION = 9,
+        ID = 1,
+        IDREF = 2,
+        IDREFS = 3,
+        NCName = 11,
+        NMTOKEN = 6,
+        NMTOKENS = 7,
+        None = 12,
+        NOTATION = 8,
+        QName = 10,
+    }
+    public class XmlUrlResolver : XmlResolver {
+        public XmlUrlResolver();
+        public RequestCachePolicy CachePolicy { set; }
+        public override ICredentials Credentials { set; }
+        public IWebProxy Proxy { set; }
+        public override object GetEntity(Uri absoluteUri, string role, Type ofObjectToReturn);
+        public override Task<object> GetEntityAsync(Uri absoluteUri, string role, Type ofObjectToReturn);
+        public override Uri ResolveUri(Uri baseUri, string relativeUri);
+    }
+    public class XmlValidatingReader : XmlReader, IXmlLineInfo, IXmlNamespaceResolver {
+        public XmlValidatingReader(Stream xmlFragment, XmlNodeType fragType, XmlParserContext context);
+        public XmlValidatingReader(string xmlFragment, XmlNodeType fragType, XmlParserContext context);
+        public XmlValidatingReader(XmlReader reader);
+        public override int AttributeCount { get; }
+        public override string BaseURI { get; }
+        public override bool CanReadBinaryContent { get; }
+        public override bool CanResolveEntity { get; }
+        public override int Depth { get; }
+        public Encoding Encoding { get; }
+        public EntityHandling EntityHandling { get; set; }
+        public override bool EOF { get; }
+        public override bool HasValue { get; }
+        public override bool IsDefault { get; }
+        public override bool IsEmptyElement { get; }
+        public int LineNumber { get; }
+        public int LinePosition { get; }
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public bool Namespaces { get; set; }
+        public override string NamespaceURI { get; }
+        public override XmlNameTable NameTable { get; }
+        public override XmlNodeType NodeType { get; }
+        public override string Prefix { get; }
+        public override char QuoteChar { get; }
+        public XmlReader Reader { get; }
+        public override ReadState ReadState { get; }
+        public XmlSchemaCollection Schemas { get; }
+        public object SchemaType { get; }
+        public ValidationType ValidationType { get; set; }
+        public override string Value { get; }
+        public override string XmlLang { get; }
+        public XmlResolver XmlResolver { set; }
+        public override XmlSpace XmlSpace { get; }
+        public override void Close();
+        public override string GetAttribute(int i);
+        public override string GetAttribute(string name);
+        public override string GetAttribute(string localName, string namespaceURI);
+        public bool HasLineInfo();
+        public override string LookupNamespace(string prefix);
+        public override void MoveToAttribute(int i);
+        public override bool MoveToAttribute(string name);
+        public override bool MoveToAttribute(string localName, string namespaceURI);
+        public override bool MoveToElement();
+        public override bool MoveToFirstAttribute();
+        public override bool MoveToNextAttribute();
+        public override bool Read();
+        public override bool ReadAttributeValue();
+        public override int ReadContentAsBase64(byte[] buffer, int index, int count);
+        public override int ReadContentAsBinHex(byte[] buffer, int index, int count);
+        public override int ReadElementContentAsBase64(byte[] buffer, int index, int count);
+        public override int ReadElementContentAsBinHex(byte[] buffer, int index, int count);
+        public override string ReadString();
+        public object ReadTypedValue();
+        public override void ResolveEntity();
+        public event ValidationEventHandler ValidationEventHandler;
+    }
+    public class XmlWhitespace : XmlCharacterData {
+        protected internal XmlWhitespace(string strData, XmlDocument doc);
+        public override string LocalName { get; }
+        public override string Name { get; }
+        public override XmlNodeType NodeType { get; }
+        public override XmlNode ParentNode { get; }
+        public override XmlNode PreviousText { get; }
+        public override string Value { get; set; }
+        public override XmlNode CloneNode(bool deep);
+        public override void WriteContentTo(XmlWriter w);
+        public override void WriteTo(XmlWriter w);
+    }
     public abstract class XmlWriter : IDisposable {
+        public virtual void Close();
+        public static XmlWriter Create(string outputFileName);
+        public static XmlWriter Create(string outputFileName, XmlWriterSettings settings);
+        public virtual void WriteNode(XPathNavigator navigator, bool defattr);
+        public virtual Task WriteNodeAsync(XPathNavigator navigator, bool defattr);
+        public virtual void WriteValue(DateTime value);
     }
     public sealed class XmlWriterSettings {
+        public bool DoNotEscapeUriAttributes { get; set; }
+        public XmlOutputMethod OutputMethod { get; }
     }
 }
 namespace System.Xml.Linq {
     public class XDocument : XContainer {
+        public void Save(string fileName);
+        public void Save(string fileName, SaveOptions options);
     }
     public class XElement : XContainer, IXmlSerializable {
+        public void Save(string fileName);
+        public void Save(string fileName, SaveOptions options);
     }
-    public sealed class XName : IEquatable<XName> {
+    public sealed class XName : IEquatable<XName>, ISerializable {
     }
     public class XStreamingElement {
+        public void Save(string fileName);
+        public void Save(string fileName, SaveOptions options);
     }
 }
+namespace System.Xml.Resolvers {
+    public enum XmlKnownDtds {
+        All = 65535,
+        None = 0,
+        Rss091 = 2,
+        Xhtml10 = 1,
+    }
+    public class XmlPreloadedResolver : XmlResolver {
+        public XmlPreloadedResolver();
+        public XmlPreloadedResolver(XmlKnownDtds preloadedDtds);
+        public XmlPreloadedResolver(XmlResolver fallbackResolver);
+        public XmlPreloadedResolver(XmlResolver fallbackResolver, XmlKnownDtds preloadedDtds);
+        public XmlPreloadedResolver(XmlResolver fallbackResolver, XmlKnownDtds preloadedDtds, IEqualityComparer<Uri> uriComparer);
+        public override ICredentials Credentials { set; }
+        public IEnumerable<Uri> PreloadedUris { get; }
+        public void Add(Uri uri, byte[] value);
+        public void Add(Uri uri, byte[] value, int offset, int count);
+        public void Add(Uri uri, Stream value);
+        public void Add(Uri uri, string value);
+        public override object GetEntity(Uri absoluteUri, string role, Type ofObjectToReturn);
+        public override Task<object> GetEntityAsync(Uri absoluteUri, string role, Type ofObjectToReturn);
+        public void Remove(Uri uri);
+        public override Uri ResolveUri(Uri baseUri, string relativeUri);
+        public override bool SupportsType(Uri absoluteUri, Type type);
+    }
+}
 namespace System.Xml.Schema {
+    public static class Extensions {
+        public static IXmlSchemaInfo GetSchemaInfo(this XAttribute source);
+        public static IXmlSchemaInfo GetSchemaInfo(this XElement source);
+        public static void Validate(this XAttribute source, XmlSchemaObject partialValidationType, XmlSchemaSet schemas, ValidationEventHandler validationEventHandler);
+        public static void Validate(this XAttribute source, XmlSchemaObject partialValidationType, XmlSchemaSet schemas, ValidationEventHandler validationEventHandler, bool addSchemaInfo);
+        public static void Validate(this XDocument source, XmlSchemaSet schemas, ValidationEventHandler validationEventHandler);
+        public static void Validate(this XDocument source, XmlSchemaSet schemas, ValidationEventHandler validationEventHandler, bool addSchemaInfo);
+        public static void Validate(this XElement source, XmlSchemaObject partialValidationType, XmlSchemaSet schemas, ValidationEventHandler validationEventHandler);
+        public static void Validate(this XElement source, XmlSchemaObject partialValidationType, XmlSchemaSet schemas, ValidationEventHandler validationEventHandler, bool addSchemaInfo);
+    }
+    public interface IXmlSchemaInfo {
+        bool IsDefault { get; }
+        bool IsNil { get; }
+        XmlSchemaSimpleType MemberType { get; }
+        XmlSchemaAttribute SchemaAttribute { get; }
+        XmlSchemaElement SchemaElement { get; }
+        XmlSchemaType SchemaType { get; }
+        XmlSchemaValidity Validity { get; }
+    }
+    public class ValidationEventArgs : EventArgs {
+        public XmlSchemaException Exception { get; }
+        public string Message { get; }
+        public XmlSeverityType Severity { get; }
+    }
+    public delegate void ValidationEventHandler(object sender, ValidationEventArgs e); {
+        public ValidationEventHandler(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(object sender, ValidationEventArgs e, AsyncCallback callback, object @object);
+        public virtual void EndInvoke(IAsyncResult result);
+        public virtual void Invoke(object sender, ValidationEventArgs e);
+    }
+    public sealed class XmlAtomicValue : XPathItem, ICloneable {
+        public override bool IsNode { get; }
+        public override object TypedValue { get; }
+        public override string Value { get; }
+        public override bool ValueAsBoolean { get; }
+        public override DateTime ValueAsDateTime { get; }
+        public override double ValueAsDouble { get; }
+        public override int ValueAsInt { get; }
+        public override long ValueAsLong { get; }
+        public override Type ValueType { get; }
+        public override XmlSchemaType XmlType { get; }
+        public XmlAtomicValue Clone();
+        public override string ToString();
+        public override object ValueAs(Type type, IXmlNamespaceResolver nsResolver);
+    }
-    public class XmlSchema {
+    public class XmlSchema : XmlSchemaObject {
+        public const string InstanceNamespace = "http://www.w3.org/2001/XMLSchema-instance";
+        public const string Namespace = "http://www.w3.org/2001/XMLSchema";
+        public XmlSchema();
+        public XmlSchemaForm AttributeFormDefault { get; set; }
+        public XmlSchemaObjectTable AttributeGroups { get; }
+        public XmlSchemaObjectTable Attributes { get; }
+        public XmlSchemaDerivationMethod BlockDefault { get; set; }
+        public XmlSchemaForm ElementFormDefault { get; set; }
+        public XmlSchemaObjectTable Elements { get; }
+        public XmlSchemaDerivationMethod FinalDefault { get; set; }
+        public XmlSchemaObjectTable Groups { get; }
+        public string Id { get; set; }
+        public XmlSchemaObjectCollection Includes { get; }
+        public bool IsCompiled { get; }
+        public XmlSchemaObjectCollection Items { get; }
+        public XmlSchemaObjectTable Notations { get; }
+        public XmlSchemaObjectTable SchemaTypes { get; }
+        public string TargetNamespace { get; set; }
+        public XmlAttribute[] UnhandledAttributes { get; set; }
+        public string Version { get; set; }
+        public void Compile(ValidationEventHandler validationEventHandler);
+        public void Compile(ValidationEventHandler validationEventHandler, XmlResolver resolver);
+        public static XmlSchema Read(Stream stream, ValidationEventHandler validationEventHandler);
+        public static XmlSchema Read(TextReader reader, ValidationEventHandler validationEventHandler);
+        public static XmlSchema Read(XmlReader reader, ValidationEventHandler validationEventHandler);
+        public void Write(Stream stream);
+        public void Write(Stream stream, XmlNamespaceManager namespaceManager);
+        public void Write(TextWriter writer);
+        public void Write(TextWriter writer, XmlNamespaceManager namespaceManager);
+        public void Write(XmlWriter writer);
+        public void Write(XmlWriter writer, XmlNamespaceManager namespaceManager);
     }
+    public class XmlSchemaAll : XmlSchemaGroupBase {
+        public XmlSchemaAll();
+        public override XmlSchemaObjectCollection Items { get; }
+    }
+    public class XmlSchemaAnnotated : XmlSchemaObject {
+        public XmlSchemaAnnotated();
+        public XmlSchemaAnnotation Annotation { get; set; }
+        public string Id { get; set; }
+        public XmlAttribute[] UnhandledAttributes { get; set; }
+    }
+    public class XmlSchemaAnnotation : XmlSchemaObject {
+        public XmlSchemaAnnotation();
+        public string Id { get; set; }
+        public XmlSchemaObjectCollection Items { get; }
+        public XmlAttribute[] UnhandledAttributes { get; set; }
+    }
+    public class XmlSchemaAny : XmlSchemaParticle {
+        public XmlSchemaAny();
+        public string Namespace { get; set; }
+        public XmlSchemaContentProcessing ProcessContents { get; set; }
+    }
+    public class XmlSchemaAnyAttribute : XmlSchemaAnnotated {
+        public XmlSchemaAnyAttribute();
+        public string Namespace { get; set; }
+        public XmlSchemaContentProcessing ProcessContents { get; set; }
+    }
+    public class XmlSchemaAppInfo : XmlSchemaObject {
+        public XmlSchemaAppInfo();
+        public XmlNode[] Markup { get; set; }
+        public string Source { get; set; }
+    }
+    public class XmlSchemaAttribute : XmlSchemaAnnotated {
+        public XmlSchemaAttribute();
+        public XmlSchemaSimpleType AttributeSchemaType { get; }
+        public object AttributeType { get; }
+        public string DefaultValue { get; set; }
+        public string FixedValue { get; set; }
+        public XmlSchemaForm Form { get; set; }
+        public string Name { get; set; }
+        public XmlQualifiedName QualifiedName { get; }
+        public XmlQualifiedName RefName { get; set; }
+        public XmlSchemaSimpleType SchemaType { get; set; }
+        public XmlQualifiedName SchemaTypeName { get; set; }
+        public XmlSchemaUse Use { get; set; }
+    }
+    public class XmlSchemaAttributeGroup : XmlSchemaAnnotated {
+        public XmlSchemaAttributeGroup();
+        public XmlSchemaAnyAttribute AnyAttribute { get; set; }
+        public XmlSchemaObjectCollection Attributes { get; }
+        public string Name { get; set; }
+        public XmlQualifiedName QualifiedName { get; }
+        public XmlSchemaAttributeGroup RedefinedAttributeGroup { get; }
+    }
+    public class XmlSchemaAttributeGroupRef : XmlSchemaAnnotated {
+        public XmlSchemaAttributeGroupRef();
+        public XmlQualifiedName RefName { get; set; }
+    }
+    public class XmlSchemaChoice : XmlSchemaGroupBase {
+        public XmlSchemaChoice();
+        public override XmlSchemaObjectCollection Items { get; }
+    }
+    public sealed class XmlSchemaCollection : ICollection, IEnumerable {
+        public XmlSchemaCollection();
+        public XmlSchemaCollection(XmlNameTable nametable);
+        public int Count { get; }
+        public XmlSchema this[string ns] { get; }
+        public XmlNameTable NameTable { get; }
+        public XmlSchema Add(string ns, string uri);
+        public XmlSchema Add(string ns, XmlReader reader);
+        public XmlSchema Add(string ns, XmlReader reader, XmlResolver resolver);
+        public XmlSchema Add(XmlSchema schema);
+        public XmlSchema Add(XmlSchema schema, XmlResolver resolver);
+        public void Add(XmlSchemaCollection schema);
+        public bool Contains(string ns);
+        public bool Contains(XmlSchema schema);
+        public void CopyTo(XmlSchema[] array, int index);
+        public XmlSchemaCollectionEnumerator GetEnumerator();
+        public event ValidationEventHandler ValidationEventHandler;
+    }
+    public sealed class XmlSchemaCollectionEnumerator : IEnumerator {
+        public XmlSchema Current { get; }
+        public bool MoveNext();
+    }
+    public sealed class XmlSchemaCompilationSettings {
+        public XmlSchemaCompilationSettings();
+        public bool EnableUpaCheck { get; set; }
+    }
+    public class XmlSchemaComplexContent : XmlSchemaContentModel {
+        public XmlSchemaComplexContent();
+        public override XmlSchemaContent Content { get; set; }
+        public bool IsMixed { get; set; }
+    }
+    public class XmlSchemaComplexContentExtension : XmlSchemaContent {
+        public XmlSchemaComplexContentExtension();
+        public XmlSchemaAnyAttribute AnyAttribute { get; set; }
+        public XmlSchemaObjectCollection Attributes { get; }
+        public XmlQualifiedName BaseTypeName { get; set; }
+        public XmlSchemaParticle Particle { get; set; }
+    }
+    public class XmlSchemaComplexContentRestriction : XmlSchemaContent {
+        public XmlSchemaComplexContentRestriction();
+        public XmlSchemaAnyAttribute AnyAttribute { get; set; }
+        public XmlSchemaObjectCollection Attributes { get; }
+        public XmlQualifiedName BaseTypeName { get; set; }
+        public XmlSchemaParticle Particle { get; set; }
+    }
+    public class XmlSchemaComplexType : XmlSchemaType {
+        public XmlSchemaComplexType();
+        public XmlSchemaAnyAttribute AnyAttribute { get; set; }
+        public XmlSchemaObjectCollection Attributes { get; }
+        public XmlSchemaObjectTable AttributeUses { get; }
+        public XmlSchemaAnyAttribute AttributeWildcard { get; }
+        public XmlSchemaDerivationMethod Block { get; set; }
+        public XmlSchemaDerivationMethod BlockResolved { get; }
+        public XmlSchemaContentModel ContentModel { get; set; }
+        public XmlSchemaContentType ContentType { get; }
+        public XmlSchemaParticle ContentTypeParticle { get; }
+        public bool IsAbstract { get; set; }
+        public override bool IsMixed { get; set; }
+        public XmlSchemaParticle Particle { get; set; }
+    }
+    public abstract class XmlSchemaContent : XmlSchemaAnnotated {
+        protected XmlSchemaContent();
+    }
+    public abstract class XmlSchemaContentModel : XmlSchemaAnnotated {
+        protected XmlSchemaContentModel();
+        public abstract XmlSchemaContent Content { get; set; }
+    }
+    public enum XmlSchemaContentProcessing {
+        Lax = 2,
+        None = 0,
+        Skip = 1,
+        Strict = 3,
+    }
+    public enum XmlSchemaContentType {
+        ElementOnly = 2,
+        Empty = 1,
+        Mixed = 3,
+        TextOnly = 0,
+    }
+    public abstract class XmlSchemaDatatype {
+        protected XmlSchemaDatatype();
+        public abstract XmlTokenizedType TokenizedType { get; }
+        public virtual XmlTypeCode TypeCode { get; }
+        public abstract Type ValueType { get; }
+        public virtual XmlSchemaDatatypeVariety Variety { get; }
+        public virtual object ChangeType(object value, Type targetType);
+        public virtual object ChangeType(object value, Type targetType, IXmlNamespaceResolver namespaceResolver);
+        public virtual bool IsDerivedFrom(XmlSchemaDatatype datatype);
+        public abstract object ParseValue(string s, XmlNameTable nameTable, IXmlNamespaceResolver nsmgr);
+    }
+    public enum XmlSchemaDatatypeVariety {
+        Atomic = 0,
+        List = 1,
+        Union = 2,
+    }
+    public enum XmlSchemaDerivationMethod {
+        All = 255,
+        Empty = 0,
+        Extension = 2,
+        List = 8,
+        None = 256,
+        Restriction = 4,
+        Substitution = 1,
+        Union = 16,
+    }
+    public class XmlSchemaDocumentation : XmlSchemaObject {
+        public XmlSchemaDocumentation();
+        public string Language { get; set; }
+        public XmlNode[] Markup { get; set; }
+        public string Source { get; set; }
+    }
+    public class XmlSchemaElement : XmlSchemaParticle {
+        public XmlSchemaElement();
+        public XmlSchemaDerivationMethod Block { get; set; }
+        public XmlSchemaDerivationMethod BlockResolved { get; }
+        public XmlSchemaObjectCollection Constraints { get; }
+        public string DefaultValue { get; set; }
+        public XmlSchemaType ElementSchemaType { get; }
+        public object ElementType { get; }
+        public XmlSchemaDerivationMethod Final { get; set; }
+        public XmlSchemaDerivationMethod FinalResolved { get; }
+        public string FixedValue { get; set; }
+        public XmlSchemaForm Form { get; set; }
+        public bool IsAbstract { get; set; }
+        public bool IsNillable { get; set; }
+        public string Name { get; set; }
+        public XmlQualifiedName QualifiedName { get; }
+        public XmlQualifiedName RefName { get; set; }
+        public XmlSchemaType SchemaType { get; set; }
+        public XmlQualifiedName SchemaTypeName { get; set; }
+        public XmlQualifiedName SubstitutionGroup { get; set; }
+    }
+    public class XmlSchemaEnumerationFacet : XmlSchemaFacet {
+        public XmlSchemaEnumerationFacet();
+    }
+    public class XmlSchemaException : SystemException {
+        public XmlSchemaException();
+        protected XmlSchemaException(SerializationInfo info, StreamingContext context);
+        public XmlSchemaException(string message);
+        public XmlSchemaException(string message, Exception innerException);
+        public XmlSchemaException(string message, Exception innerException, int lineNumber, int linePosition);
+        public int LineNumber { get; }
+        public int LinePosition { get; }
+        public override string Message { get; }
+        public XmlSchemaObject SourceSchemaObject { get; }
+        public string SourceUri { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public abstract class XmlSchemaExternal : XmlSchemaObject {
+        protected XmlSchemaExternal();
+        public string Id { get; set; }
+        public XmlSchema Schema { get; set; }
+        public string SchemaLocation { get; set; }
+        public XmlAttribute[] UnhandledAttributes { get; set; }
+    }
+    public abstract class XmlSchemaFacet : XmlSchemaAnnotated {
+        protected XmlSchemaFacet();
+        public virtual bool IsFixed { get; set; }
+        public string Value { get; set; }
+    }
+    public class XmlSchemaFractionDigitsFacet : XmlSchemaNumericFacet {
+        public XmlSchemaFractionDigitsFacet();
+    }
+    public class XmlSchemaGroup : XmlSchemaAnnotated {
+        public XmlSchemaGroup();
+        public string Name { get; set; }
+        public XmlSchemaGroupBase Particle { get; set; }
+        public XmlQualifiedName QualifiedName { get; }
+    }
+    public abstract class XmlSchemaGroupBase : XmlSchemaParticle {
+        protected XmlSchemaGroupBase();
+        public abstract XmlSchemaObjectCollection Items { get; }
+    }
+    public class XmlSchemaGroupRef : XmlSchemaParticle {
+        public XmlSchemaGroupRef();
+        public XmlSchemaGroupBase Particle { get; }
+        public XmlQualifiedName RefName { get; set; }
+    }
+    public class XmlSchemaIdentityConstraint : XmlSchemaAnnotated {
+        public XmlSchemaIdentityConstraint();
+        public XmlSchemaObjectCollection Fields { get; }
+        public string Name { get; set; }
+        public XmlQualifiedName QualifiedName { get; }
+        public XmlSchemaXPath Selector { get; set; }
+    }
+    public class XmlSchemaImport : XmlSchemaExternal {
+        public XmlSchemaImport();
+        public XmlSchemaAnnotation Annotation { get; set; }
+        public string Namespace { get; set; }
+    }
+    public class XmlSchemaInclude : XmlSchemaExternal {
+        public XmlSchemaInclude();
+        public XmlSchemaAnnotation Annotation { get; set; }
+    }
+    public sealed class XmlSchemaInference {
+        public enum InferenceOption {
+            Relaxed = 1,
+            Restricted = 0,
+        }
+        public XmlSchemaInference();
+        public XmlSchemaInference.InferenceOption Occurrence { get; set; }
+        public XmlSchemaInference.InferenceOption TypeInference { get; set; }
+        public XmlSchemaSet InferSchema(XmlReader instanceDocument);
+        public XmlSchemaSet InferSchema(XmlReader instanceDocument, XmlSchemaSet schemas);
+    }
+    public class XmlSchemaInferenceException : XmlSchemaException {
+        public XmlSchemaInferenceException();
+        protected XmlSchemaInferenceException(SerializationInfo info, StreamingContext context);
+        public XmlSchemaInferenceException(string message);
+        public XmlSchemaInferenceException(string message, Exception innerException);
+        public XmlSchemaInferenceException(string message, Exception innerException, int lineNumber, int linePosition);
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public class XmlSchemaInfo : IXmlSchemaInfo {
+        public XmlSchemaInfo();
+        public XmlSchemaContentType ContentType { get; set; }
+        public bool IsDefault { get; set; }
+        public bool IsNil { get; set; }
+        public XmlSchemaSimpleType MemberType { get; set; }
+        public XmlSchemaAttribute SchemaAttribute { get; set; }
+        public XmlSchemaElement SchemaElement { get; set; }
+        public XmlSchemaType SchemaType { get; set; }
+        public XmlSchemaValidity Validity { get; set; }
+    }
+    public class XmlSchemaKey : XmlSchemaIdentityConstraint {
+        public XmlSchemaKey();
+    }
+    public class XmlSchemaKeyref : XmlSchemaIdentityConstraint {
+        public XmlSchemaKeyref();
+        public XmlQualifiedName Refer { get; set; }
+    }
+    public class XmlSchemaLengthFacet : XmlSchemaNumericFacet {
+        public XmlSchemaLengthFacet();
+    }
+    public class XmlSchemaMaxExclusiveFacet : XmlSchemaFacet {
+        public XmlSchemaMaxExclusiveFacet();
+    }
+    public class XmlSchemaMaxInclusiveFacet : XmlSchemaFacet {
+        public XmlSchemaMaxInclusiveFacet();
+    }
+    public class XmlSchemaMaxLengthFacet : XmlSchemaNumericFacet {
+        public XmlSchemaMaxLengthFacet();
+    }
+    public class XmlSchemaMinExclusiveFacet : XmlSchemaFacet {
+        public XmlSchemaMinExclusiveFacet();
+    }
+    public class XmlSchemaMinInclusiveFacet : XmlSchemaFacet {
+        public XmlSchemaMinInclusiveFacet();
+    }
+    public class XmlSchemaMinLengthFacet : XmlSchemaNumericFacet {
+        public XmlSchemaMinLengthFacet();
+    }
+    public class XmlSchemaNotation : XmlSchemaAnnotated {
+        public XmlSchemaNotation();
+        public string Name { get; set; }
+        public string Public { get; set; }
+        public string System { get; set; }
+    }
+    public abstract class XmlSchemaNumericFacet : XmlSchemaFacet {
+        protected XmlSchemaNumericFacet();
+    }
+    public abstract class XmlSchemaObject {
+        protected XmlSchemaObject();
+        public int LineNumber { get; set; }
+        public int LinePosition { get; set; }
+        public XmlSerializerNamespaces Namespaces { get; set; }
+        public XmlSchemaObject Parent { get; set; }
+        public string SourceUri { get; set; }
+    }
+    public class XmlSchemaObjectCollection : CollectionBase {
+        public XmlSchemaObjectCollection();
+        public XmlSchemaObjectCollection(XmlSchemaObject parent);
+        public virtual XmlSchemaObject this[int index] { get; set; }
+        public int Add(XmlSchemaObject item);
+        public bool Contains(XmlSchemaObject item);
+        public void CopyTo(XmlSchemaObject[] array, int index);
+        public new XmlSchemaObjectEnumerator GetEnumerator();
+        public int IndexOf(XmlSchemaObject item);
+        public void Insert(int index, XmlSchemaObject item);
+        protected override void OnClear();
+        protected override void OnInsert(int index, object item);
+        protected override void OnRemove(int index, object item);
+        protected override void OnSet(int index, object oldValue, object newValue);
+        public void Remove(XmlSchemaObject item);
+    }
+    public class XmlSchemaObjectEnumerator : IEnumerator {
+        public XmlSchemaObject Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public class XmlSchemaObjectTable {
+        public int Count { get; }
+        public XmlSchemaObject this[XmlQualifiedName name] { get; }
+        public ICollection Names { get; }
+        public ICollection Values { get; }
+        public bool Contains(XmlQualifiedName name);
+        public IDictionaryEnumerator GetEnumerator();
+    }
+    public abstract class XmlSchemaParticle : XmlSchemaAnnotated {
+        protected XmlSchemaParticle();
+        public decimal MaxOccurs { get; set; }
+        public string MaxOccursString { get; set; }
+        public decimal MinOccurs { get; set; }
+        public string MinOccursString { get; set; }
+    }
+    public class XmlSchemaPatternFacet : XmlSchemaFacet {
+        public XmlSchemaPatternFacet();
+    }
+    public class XmlSchemaRedefine : XmlSchemaExternal {
+        public XmlSchemaRedefine();
+        public XmlSchemaObjectTable AttributeGroups { get; }
+        public XmlSchemaObjectTable Groups { get; }
+        public XmlSchemaObjectCollection Items { get; }
+        public XmlSchemaObjectTable SchemaTypes { get; }
+    }
+    public class XmlSchemaSequence : XmlSchemaGroupBase {
+        public XmlSchemaSequence();
+        public override XmlSchemaObjectCollection Items { get; }
+    }
+    public class XmlSchemaSet {
+        public XmlSchemaSet();
+        public XmlSchemaSet(XmlNameTable nameTable);
+        public XmlSchemaCompilationSettings CompilationSettings { get; set; }
+        public int Count { get; }
+        public XmlSchemaObjectTable GlobalAttributes { get; }
+        public XmlSchemaObjectTable GlobalElements { get; }
+        public XmlSchemaObjectTable GlobalTypes { get; }
+        public bool IsCompiled { get; }
+        public XmlNameTable NameTable { get; }
+        public XmlResolver XmlResolver { set; }
+        public XmlSchema Add(string targetNamespace, string schemaUri);
+        public XmlSchema Add(string targetNamespace, XmlReader schemaDocument);
+        public XmlSchema Add(XmlSchema schema);
+        public void Add(XmlSchemaSet schemas);
+        public void Compile();
+        public bool Contains(string targetNamespace);
+        public bool Contains(XmlSchema schema);
+        public void CopyTo(XmlSchema[] schemas, int index);
+        public XmlSchema Remove(XmlSchema schema);
+        public bool RemoveRecursive(XmlSchema schemaToRemove);
+        public XmlSchema Reprocess(XmlSchema schema);
+        public ICollection Schemas();
+        public ICollection Schemas(string targetNamespace);
+        public event ValidationEventHandler ValidationEventHandler;
+    }
+    public class XmlSchemaSimpleContent : XmlSchemaContentModel {
+        public XmlSchemaSimpleContent();
+        public override XmlSchemaContent Content { get; set; }
+    }
+    public class XmlSchemaSimpleContentExtension : XmlSchemaContent {
+        public XmlSchemaSimpleContentExtension();
+        public XmlSchemaAnyAttribute AnyAttribute { get; set; }
+        public XmlSchemaObjectCollection Attributes { get; }
+        public XmlQualifiedName BaseTypeName { get; set; }
+    }
+    public class XmlSchemaSimpleContentRestriction : XmlSchemaContent {
+        public XmlSchemaSimpleContentRestriction();
+        public XmlSchemaAnyAttribute AnyAttribute { get; set; }
+        public XmlSchemaObjectCollection Attributes { get; }
+        public XmlSchemaSimpleType BaseType { get; set; }
+        public XmlQualifiedName BaseTypeName { get; set; }
+        public XmlSchemaObjectCollection Facets { get; }
+    }
+    public class XmlSchemaSimpleType : XmlSchemaType {
+        public XmlSchemaSimpleType();
+        public XmlSchemaSimpleTypeContent Content { get; set; }
+    }
+    public abstract class XmlSchemaSimpleTypeContent : XmlSchemaAnnotated {
+        protected XmlSchemaSimpleTypeContent();
+    }
+    public class XmlSchemaSimpleTypeList : XmlSchemaSimpleTypeContent {
+        public XmlSchemaSimpleTypeList();
+        public XmlSchemaSimpleType BaseItemType { get; set; }
+        public XmlSchemaSimpleType ItemType { get; set; }
+        public XmlQualifiedName ItemTypeName { get; set; }
+    }
+    public class XmlSchemaSimpleTypeRestriction : XmlSchemaSimpleTypeContent {
+        public XmlSchemaSimpleTypeRestriction();
+        public XmlSchemaSimpleType BaseType { get; set; }
+        public XmlQualifiedName BaseTypeName { get; set; }
+        public XmlSchemaObjectCollection Facets { get; }
+    }
+    public class XmlSchemaSimpleTypeUnion : XmlSchemaSimpleTypeContent {
+        public XmlSchemaSimpleTypeUnion();
+        public XmlSchemaSimpleType[] BaseMemberTypes { get; }
+        public XmlSchemaObjectCollection BaseTypes { get; }
+        public XmlQualifiedName[] MemberTypes { get; set; }
+    }
+    public class XmlSchemaTotalDigitsFacet : XmlSchemaNumericFacet {
+        public XmlSchemaTotalDigitsFacet();
+    }
+    public class XmlSchemaType : XmlSchemaAnnotated {
+        public XmlSchemaType();
+        public object BaseSchemaType { get; }
+        public XmlSchemaType BaseXmlSchemaType { get; }
+        public XmlSchemaDatatype Datatype { get; }
+        public XmlSchemaDerivationMethod DerivedBy { get; }
+        public XmlSchemaDerivationMethod Final { get; set; }
+        public XmlSchemaDerivationMethod FinalResolved { get; }
+        public virtual bool IsMixed { get; set; }
+        public string Name { get; set; }
+        public XmlQualifiedName QualifiedName { get; }
+        public XmlTypeCode TypeCode { get; }
+        public static XmlSchemaComplexType GetBuiltInComplexType(XmlQualifiedName qualifiedName);
+        public static XmlSchemaComplexType GetBuiltInComplexType(XmlTypeCode typeCode);
+        public static XmlSchemaSimpleType GetBuiltInSimpleType(XmlQualifiedName qualifiedName);
+        public static XmlSchemaSimpleType GetBuiltInSimpleType(XmlTypeCode typeCode);
+        public static bool IsDerivedFrom(XmlSchemaType derivedType, XmlSchemaType baseType, XmlSchemaDerivationMethod except);
+    }
+    public class XmlSchemaUnique : XmlSchemaIdentityConstraint {
+        public XmlSchemaUnique();
+    }
+    public enum XmlSchemaUse {
+        None = 0,
+        Optional = 1,
+        Prohibited = 2,
+        Required = 3,
+    }
+    public class XmlSchemaValidationException : XmlSchemaException {
+        public XmlSchemaValidationException();
+        protected XmlSchemaValidationException(SerializationInfo info, StreamingContext context);
+        public XmlSchemaValidationException(string message);
+        public XmlSchemaValidationException(string message, Exception innerException);
+        public XmlSchemaValidationException(string message, Exception innerException, int lineNumber, int linePosition);
+        public object SourceObject { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        protected internal void SetSourceObject(object sourceObject);
+    }
+    public enum XmlSchemaValidationFlags {
+        AllowXmlAttributes = 16,
+        None = 0,
+        ProcessIdentityConstraints = 8,
+        ProcessInlineSchema = 1,
+        ProcessSchemaLocation = 2,
+        ReportValidationWarnings = 4,
+    }
+    public sealed class XmlSchemaValidator {
+        public XmlSchemaValidator(XmlNameTable nameTable, XmlSchemaSet schemas, IXmlNamespaceResolver namespaceResolver, XmlSchemaValidationFlags validationFlags);
+        public IXmlLineInfo LineInfoProvider { get; set; }
+        public Uri SourceUri { get; set; }
+        public object ValidationEventSender { get; set; }
+        public XmlResolver XmlResolver { set; }
+        public void AddSchema(XmlSchema schema);
+        public void EndValidation();
+        public XmlSchemaAttribute[] GetExpectedAttributes();
+        public XmlSchemaParticle[] GetExpectedParticles();
+        public void GetUnspecifiedDefaultAttributes(ArrayList defaultAttributes);
+        public void Initialize();
+        public void Initialize(XmlSchemaObject partialValidationType);
+        public void SkipToEndElement(XmlSchemaInfo schemaInfo);
+        public object ValidateAttribute(string localName, string namespaceUri, string attributeValue, XmlSchemaInfo schemaInfo);
+        public object ValidateAttribute(string localName, string namespaceUri, XmlValueGetter attributeValue, XmlSchemaInfo schemaInfo);
+        public void ValidateElement(string localName, string namespaceUri, XmlSchemaInfo schemaInfo);
+        public void ValidateElement(string localName, string namespaceUri, XmlSchemaInfo schemaInfo, string xsiType, string xsiNil, string xsiSchemaLocation, string xsiNoNamespaceSchemaLocation);
+        public object ValidateEndElement(XmlSchemaInfo schemaInfo);
+        public object ValidateEndElement(XmlSchemaInfo schemaInfo, object typedValue);
+        public void ValidateEndOfAttributes(XmlSchemaInfo schemaInfo);
+        public void ValidateText(string elementValue);
+        public void ValidateText(XmlValueGetter elementValue);
+        public void ValidateWhitespace(string elementValue);
+        public void ValidateWhitespace(XmlValueGetter elementValue);
+        public event ValidationEventHandler ValidationEventHandler;
+    }
+    public enum XmlSchemaValidity {
+        Invalid = 2,
+        NotKnown = 0,
+        Valid = 1,
+    }
+    public class XmlSchemaWhiteSpaceFacet : XmlSchemaFacet {
+        public XmlSchemaWhiteSpaceFacet();
+    }
+    public class XmlSchemaXPath : XmlSchemaAnnotated {
+        public XmlSchemaXPath();
+        public string XPath { get; set; }
+    }
+    public enum XmlSeverityType {
+        Error = 0,
+        Warning = 1,
+    }
+    public enum XmlTypeCode {
+        AnyAtomicType = 10,
+        AnyUri = 28,
+        Attribute = 5,
+        Base64Binary = 27,
+        Boolean = 13,
+        Byte = 46,
+        Comment = 8,
+        Date = 20,
+        DateTime = 18,
+        DayTimeDuration = 54,
+        Decimal = 14,
+        Document = 3,
+        Double = 16,
+        Duration = 17,
+        Element = 4,
+        Entity = 39,
+        Float = 15,
+        GDay = 24,
+        GMonth = 25,
+        GMonthDay = 23,
+        GYear = 22,
+        GYearMonth = 21,
+        HexBinary = 26,
+        Id = 37,
+        Idref = 38,
+        Int = 44,
+        Integer = 40,
+        Item = 1,
+        Language = 33,
+        Long = 43,
+        Name = 35,
+        Namespace = 6,
+        NCName = 36,
+        NegativeInteger = 42,
+        NmToken = 34,
+        Node = 2,
+        None = 0,
+        NonNegativeInteger = 47,
+        NonPositiveInteger = 41,
+        NormalizedString = 31,
+        Notation = 30,
+        PositiveInteger = 52,
+        ProcessingInstruction = 7,
+        QName = 29,
+        Short = 45,
+        String = 12,
+        Text = 9,
+        Time = 19,
+        Token = 32,
+        UnsignedByte = 51,
+        UnsignedInt = 49,
+        UnsignedLong = 48,
+        UnsignedShort = 50,
+        UntypedAtomic = 11,
+        YearMonthDuration = 53,
+    }
+    public delegate object XmlValueGetter(); {
+        public XmlValueGetter(object @object, IntPtr method);
+        public virtual IAsyncResult BeginInvoke(AsyncCallback callback, object @object);
+        public virtual object EndInvoke(IAsyncResult result);
+        public virtual object Invoke();
+    }
 }
 namespace System.Xml.Serialization {
+    public enum CodeGenerationOptions {
+        EnableDataBinding = 16,
+        GenerateNewAsync = 2,
+        GenerateOldAsync = 4,
+        GenerateOrder = 8,
+        GenerateProperties = 1,
+        None = 0,
+    }
+    public class CodeIdentifier {
+        public CodeIdentifier();
+        public static string MakeCamel(string identifier);
+        public static string MakePascal(string identifier);
+        public static string MakeValid(string identifier);
+    }
+    public class CodeIdentifiers {
+        public CodeIdentifiers();
+        public CodeIdentifiers(bool caseSensitive);
+        public bool UseCamelCasing { get; set; }
+        public void Add(string identifier, object value);
+        public void AddReserved(string identifier);
+        public string AddUnique(string identifier, object value);
+        public void Clear();
+        public bool IsInUse(string identifier);
+        public string MakeRightCase(string identifier);
+        public string MakeUnique(string identifier);
+        public void Remove(string identifier);
+        public void RemoveReserved(string identifier);
+        public object ToArray(Type type);
+    }
+    public class ImportContext {
+        public ImportContext(CodeIdentifiers identifiers, bool shareTypes);
+        public bool ShareTypes { get; }
+        public CodeIdentifiers TypeIdentifiers { get; }
+        public StringCollection Warnings { get; }
+    }
+    public interface IXmlTextParser {
+        bool Normalized { get; set; }
+        WhitespaceHandling WhitespaceHandling { get; set; }
+    }
+    public class SoapAttributeAttribute : Attribute {
+        public SoapAttributeAttribute();
+        public SoapAttributeAttribute(string attributeName);
+        public string AttributeName { get; set; }
+        public string DataType { get; set; }
+        public string Namespace { get; set; }
+    }
+    public class SoapAttributeOverrides {
+        public SoapAttributeOverrides();
+        public SoapAttributes this[Type type, string member] { get; }
+        public SoapAttributes this[Type type] { get; }
+        public void Add(Type type, SoapAttributes attributes);
+        public void Add(Type type, string member, SoapAttributes attributes);
+    }
+    public class SoapAttributes {
+        public SoapAttributes();
+        public SoapAttributes(ICustomAttributeProvider provider);
+        public SoapAttributeAttribute SoapAttribute { get; set; }
+        public object SoapDefaultValue { get; set; }
+        public SoapElementAttribute SoapElement { get; set; }
+        public SoapEnumAttribute SoapEnum { get; set; }
+        public bool SoapIgnore { get; set; }
+        public SoapTypeAttribute SoapType { get; set; }
+    }
+    public class SoapElementAttribute : Attribute {
+        public SoapElementAttribute();
+        public SoapElementAttribute(string elementName);
+        public string DataType { get; set; }
+        public string ElementName { get; set; }
+        public bool IsNullable { get; set; }
+    }
+    public class SoapEnumAttribute : Attribute {
+        public SoapEnumAttribute();
+        public SoapEnumAttribute(string name);
+        public string Name { get; set; }
+    }
+    public class SoapIgnoreAttribute : Attribute {
+        public SoapIgnoreAttribute();
+    }
+    public class SoapIncludeAttribute : Attribute {
+        public SoapIncludeAttribute(Type type);
+        public Type Type { get; set; }
+    }
+    public class SoapReflectionImporter {
+        public SoapReflectionImporter();
+        public SoapReflectionImporter(SoapAttributeOverrides attributeOverrides);
+        public SoapReflectionImporter(SoapAttributeOverrides attributeOverrides, string defaultNamespace);
+        public SoapReflectionImporter(string defaultNamespace);
+        public XmlMembersMapping ImportMembersMapping(string elementName, string ns, XmlReflectionMember[] members);
+        public XmlMembersMapping ImportMembersMapping(string elementName, string ns, XmlReflectionMember[] members, bool hasWrapperElement, bool writeAccessors);
+        public XmlMembersMapping ImportMembersMapping(string elementName, string ns, XmlReflectionMember[] members, bool hasWrapperElement, bool writeAccessors, bool validate);
+        public XmlMembersMapping ImportMembersMapping(string elementName, string ns, XmlReflectionMember[] members, bool hasWrapperElement, bool writeAccessors, bool validate, XmlMappingAccess access);
+        public XmlTypeMapping ImportTypeMapping(Type type);
+        public XmlTypeMapping ImportTypeMapping(Type type, string defaultNamespace);
+        public void IncludeType(Type type);
+        public void IncludeTypes(ICustomAttributeProvider provider);
+    }
+    public class SoapSchemaMember {
+        public SoapSchemaMember();
+        public string MemberName { get; set; }
+        public XmlQualifiedName MemberType { get; set; }
+    }
+    public class SoapTypeAttribute : Attribute {
+        public SoapTypeAttribute();
+        public SoapTypeAttribute(string typeName);
+        public SoapTypeAttribute(string typeName, string ns);
+        public bool IncludeInSchema { get; set; }
+        public string Namespace { get; set; }
+        public string TypeName { get; set; }
+    }
+    public class UnreferencedObjectEventArgs : EventArgs {
+        public UnreferencedObjectEventArgs(object o, string id);
+        public string UnreferencedId { get; }
+        public object UnreferencedObject { get; }
+    }
+    