﻿using System.ComponentModel.Composition;
using Microsoft.VisualStudio.Text.Editor;

namespace Microsoft.CodeAnalysis.Editor.UnitTests
{
    // In 15.6 the editor (QuickInfo in particular) took a dependency on 
    // IObscuringTipManager, which is only exported in VS editor layer.
    // This is tracked by the editor bug https://devdiv.visualstudio.com/DevDiv/_workitems?id=544569.
    // Meantime a workaround is to export dummy IObscuringTipManager.
    [Export(typeof(IObscuringTipManager))]
    internal class TestObscuringTipManager : IObscuringTipManager
    {
        public void PushTip(ITextView view, IObscuringTip tip)
        {
        }

        public void RemoveTip(ITextView view, IObscuringTip tip)
        {
        }
    }
}
