// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;
using System.IO;

// DIRECTIONS:
//    This file isn't very robust and makes several assumptions
//    You can execute it by calling "csi .\GenerateTests.csx"
//
//    csi can be found under the <repo-root>\tools\net46\roslyn directory
//    It must be run such from the directory that contains the csx script
//
//    New tests can be generated from the template by adding an entry to the
//    appropriate Inputs array below.
//
//    You can support a new Isa by creating a new array and adding a new
//    "ProcessInputs" call at the bottom of the script.

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] SseInputs = new []
{
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Add",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "AddScalar",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "And",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "AndNot",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(~BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(~BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareEqual",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareEqualScalar",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareEqualOrderedScalar",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareEqualUnorderedScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThan",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanOrderedScalar",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanUnorderedScalar",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanOrEqual",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanOrEqualScalar",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanOrEqualOrderedScalar",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanOrEqualUnorderedScalar",["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThan",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanScalar",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanOrderedScalar",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanUnorderedScalar",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanOrEqual",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanOrEqualScalar",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanOrEqualOrderedScalar",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanOrEqualUnorderedScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotEqual",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotEqualScalar",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotEqualOrderedScalar",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotEqualUnorderedScalar",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotGreaterThan",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotGreaterThanScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotGreaterThanOrEqual",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotGreaterThanOrEqualScalar",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotLessThan",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotLessThanScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotLessThanOrEqual",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotLessThanOrEqualScalar",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareOrdered",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((!float.IsNaN(left[i]) && !float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareOrderedScalar",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareUnordered",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((float.IsNaN(left[i]) || float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareUnorderedScalar",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Divide",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] / right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "DivideScalar",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Max",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(Math.Max(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MaxScalar",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Min",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(Math.Min(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MinScalar",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Multiply",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] * right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MultiplyScalar",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Or",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Subtract",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "SubtractScalar",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Xor",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())", ["NextValueOp2"] = "(float)(random.NextDouble())", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse2Inputs = new []
{
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "(byte)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "(short)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "(int)(left[0] + right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                   ["ValidateFirstResult"] = "(long)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "(sbyte)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                         ["ValidateFirstResult"] = "(ushort)(left[0] + right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                              ["ValidateFirstResult"] = "(uint)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                             ["ValidateFirstResult"] = "(ulong)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "Sse2Verify.AddSaturate(left[0], right[0], result[0])",                                                                               ["ValidateRemainingResults"] = "Sse2Verify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "Sse2Verify.AddSaturate(left[0], right[0], result[0])",                                                                               ["ValidateRemainingResults"] = "Sse2Verify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "Sse2Verify.AddSaturate(left[0], right[0], result[0])",                                                                               ["ValidateRemainingResults"] = "Sse2Verify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(ushort.MinValue,ushort.MaxValue))",["NextValueOp2"] = "(ushort)(random.Next(ushort.MinValue,ushort.MaxValue))",            ["ValidateFirstResult"] = "Sse2Verify.AddSaturate(left[0], right[0], result[0])",                                                                               ["ValidateRemainingResults"] = "Sse2Verify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddScalar",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "(byte)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "(short)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "(int)(left[0] & right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                   ["ValidateFirstResult"] = "(long)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "(sbyte)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                         ["ValidateFirstResult"] = "(ushort)(left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                              ["ValidateFirstResult"] = "(uint)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                             ["ValidateFirstResult"] = "(ulong)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "(~BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(~BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "(byte)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(byte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "(short)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(short)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "(int)(~left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(int)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                   ["ValidateFirstResult"] = "(long)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(long)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "(sbyte)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(sbyte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                         ["ValidateFirstResult"] = "(ushort)(~left[0] & right[0]) != result[0]",                                                                                         ["ValidateRemainingResults"] = "(ushort)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                              ["ValidateFirstResult"] = "(uint)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(uint)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                             ["ValidateFirstResult"] = "(ulong)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ulong)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Average",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "(byte)((left[0] + right[0] + 1) >> 1) != result[0]",                                                                               ["ValidateRemainingResults"] = "(byte)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Average",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(ushort.MinValue,ushort.MaxValue))",["NextValueOp2"] = "(ushort)(random.Next(ushort.MinValue,ushort.MaxValue))",            ["ValidateFirstResult"] = "(ushort)((left[0] + right[0] + 1) >> 1) != result[0]",                                                                               ["ValidateRemainingResults"] = "(ushort)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((byte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((byte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((short)(-1)) : 0)",                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((int)(-1)) : 0)",                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                         ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ushort)(-1)) : 0)",                                                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ushort)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                              ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((uint)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((short)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((int)(-1)) : 0)",                                                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThanOrEqual",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((short)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((int)(-1)) : 0)",                                                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThanOrEqual",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotEqual",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotGreaterThan",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotGreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotLessThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotLessThanOrEqual",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareOrdered",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((!double.IsNaN(left[0]) && !double.IsNaN(right[0])) ? -1 : 0)",                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((!double.IsNaN(left[i]) && !double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareUnordered",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((double.IsNaN(left[0]) || double.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((double.IsNaN(left[i]) || double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Divide",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] / right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "DivideScalar",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("ExtractScalarTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, int.MaxValue))",                                                                                                         ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, int.MaxValue))",                                                                                                        ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, int.MaxValue))",                                                                                                         ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, int.MaxValue))",                                                                                                        ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                               ["Data"] = "(short)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)0",                                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                              ["Data"] = "(ushort)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)0",                                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                               ["Data"] = "(short)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)0",                                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                              ["Data"] = "(ushort)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)0",                                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "Math.Max(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Max(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "Math.Max(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Max(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MaxScalar",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MinValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MinValue))",                             ["ValidateFirstResult"] = "Math.Min(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Min(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MinValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MinValue))",              ["ValidateFirstResult"] = "Math.Min(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Min(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MinScalar",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Multiply",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] * right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyScalar",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "(byte)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "(short)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "(int)(left[0] | right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                   ["ValidateFirstResult"] = "(long)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "(sbyte)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                         ["ValidateFirstResult"] = "(ushort)(left[0] | right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                              ["ValidateFirstResult"] = "(uint)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                             ["ValidateFirstResult"] = "(ulong)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] | right[i]) != result[i]"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(Random.Next(byte.MinValue, byte.MaxValue))",                                                                                             ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(Random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                                                          ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(Random.Next(short.MinValue, short.MaxValue))",                                                                                          ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(Random.Next(ushort.MinValue, ushort.MaxValue))",                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(Random.Next(int.MinValue, int.MaxValue))",                                                                                                ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(Random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(Random.Next(int.MinValue, int.MaxValue))",                                                                                               ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(Random.Next(0, int.MaxValue))",                                                                                                         ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ScalarUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SetAllVector128",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "Random.NextDouble()",                                                                                                                           ["ValidateFirstResult"] = "result[0] != firstOp",                                                                                                               ["ValidateRemainingResults"] = "result[i] != firstOp"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                       ["ValidateFirstResult"] = "(short)(firstOp[0] << 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                     ["ValidateFirstResult"] = "(ushort)(firstOp[0] << 1) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(ushort)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                           ["ValidateFirstResult"] = "(int)(firstOp[0] << 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "(uint)(firstOp[0] << 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(uint)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "(long)(firstOp[0] << 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(long)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                         ["ValidateFirstResult"] = "(ulong)(firstOp[0] << 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(ulong)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                       ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                     ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                           ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)8",                                                                                                                                      ["ValidateFirstResult"] = "result[0] != 0",                                                                                                                     ["ValidateRemainingResults"] =  "result[i] != 8"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                        ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)8",                                                                                                                                       ["ValidateFirstResult"] = "result[0] != 0",                                                                                                                     ["ValidateRemainingResults"] =  "result[i] != 8"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)8",                                                                                                                                      ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)8",                                                                                                                                     ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)8",                                                                                                                                        ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)8",                                                                                                                                       ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)8",                                                                                                                                       ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)8",                                                                                                                                      ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                       ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                           ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                       ["ValidateFirstResult"] = "(short)(firstOp[0] >> 15) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 15) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                           ["ValidateFirstResult"] = "(int)(firstOp[0] >> 31) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 31) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                       ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                     ["ValidateFirstResult"] = "(ushort)(firstOp[0] >> 1) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(ushort)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                           ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "(uint)(firstOp[0] >> 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(uint)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "(long)(firstOp[0] >> 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(long)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                         ["ValidateFirstResult"] = "(ulong)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(ulong)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                       ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                     ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                           ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)8",                                                                                                                                      ["ValidateFirstResult"] = "result[0] != 8",                                                                                                                     ["ValidateRemainingResults"] = "(i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                        ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)8",                                                                                                                                       ["ValidateFirstResult"] = "result[0] != 8",                                                                                                                     ["ValidateRemainingResults"] = "(i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)8",                                                                                                                                      ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] = "(i == 7 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)8",                                                                                                                                     ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] = "(i == 7 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)8",                                                                                                                                        ["ValidateFirstResult"] = "result[0] != 134217728",                                                                                                             ["ValidateRemainingResults"] = "(i == 3 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)8",                                                                                                                                       ["ValidateFirstResult"] = "result[0] != 134217728",                                                                                                             ["ValidateRemainingResults"] = "(i == 3 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)8",                                                                                                                                       ["ValidateFirstResult"] = "result[0] != 576460752303423488L",                                                                                                   ["ValidateRemainingResults"] = "(result[i] != 0)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)8",                                                                                                                                      ["ValidateFirstResult"] = "result[0] != 576460752303423488UL",                                                                                                  ["ValidateRemainingResults"] = "(result[i] != 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "(byte)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "(short)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "(int)(left[0] - right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                   ["ValidateFirstResult"] = "(long)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "(sbyte)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                         ["ValidateFirstResult"] = "(ushort)(left[0] - right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                              ["ValidateFirstResult"] = "(uint)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                             ["ValidateFirstResult"] = "(ulong)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "Sse2Verify.SubtractSaturate(left[0], right[0], result[0])",                                                                          ["ValidateRemainingResults"] = "Sse2Verify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "Sse2Verify.SubtractSaturate(left[0], right[0], result[0])",                                                                          ["ValidateRemainingResults"] = "Sse2Verify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "Sse2Verify.SubtractSaturate(left[0], right[0], result[0])",                                                                          ["ValidateRemainingResults"] = "Sse2Verify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(ushort.MinValue,ushort.MaxValue))",["NextValueOp2"] = "(ushort)(random.Next(ushort.MinValue,ushort.MaxValue))",            ["ValidateFirstResult"] = "Sse2Verify.SubtractSaturate(left[0], right[0], result[0])",                                                                          ["ValidateRemainingResults"] = "Sse2Verify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractScalar",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                     ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                             ["ValidateFirstResult"] = "(byte)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",              ["ValidateFirstResult"] = "(short)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                    ["ValidateFirstResult"] = "(int)(left[0] ^ right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                   ["ValidateFirstResult"] = "(long)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",              ["ValidateFirstResult"] = "(sbyte)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                         ["ValidateFirstResult"] = "(ushort)(left[0] ^ right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                              ["ValidateFirstResult"] = "(uint)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                             ["ValidateFirstResult"] = "(ulong)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] ^ right[i]) != result[i]"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse3Inputs = new []
{
    ("AlternatingBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "AddSubtract",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())", ["NextValueOp2"] = "(double)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i] - right[i])",       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i + 1]) != BitConverter.DoubleToInt64Bits(left[i + 1] + right[i + 1])"}),
    ("AlternatingBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse" , ["Method"] = "AddSubtract",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",  ["NextValueOp2"] = "(float)(random.NextDouble())",  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i] - right[i])",       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i + 1]) != BitConverter.SingleToInt32Bits(left[i + 1] + right[i + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())", ["NextValueOp2"] = "(double)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i1]) != BitConverter.DoubleToInt64Bits(left[i3] + left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i2]) != BitConverter.DoubleToInt64Bits(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse",  ["Method"] = "HorizontalAdd",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",  ["NextValueOp2"] = "(float)(random.NextDouble())",  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i1]) != BitConverter.SingleToInt32Bits(left[i3] + left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i2]) != BitConverter.SingleToInt32Bits(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())", ["NextValueOp2"] = "(double)(random.NextDouble())", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i1]) != BitConverter.DoubleToInt64Bits(left[i3] - left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i2]) != BitConverter.DoubleToInt64Bits(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse",  ["Method"] = "HorizontalSubtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",  ["NextValueOp2"] = "(float)(random.NextDouble())",  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i1]) != BitConverter.SingleToInt32Bits(left[i3] - left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i2]) != BitConverter.SingleToInt32Bits(right[i3] - right[i3 + 1])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Ssse3Inputs = new []
{
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue + 1, sbyte.MaxValue))",                                                                            ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])",                                                                      ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue + 1, short.MaxValue))",                                                                            ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])",                                                                      ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue + 1, int.MaxValue))",                                                                                  ["ValidateFirstResult"] = "result[0] != Math.Abs(firstOp[0])",                                                                      ["ValidateRemainingResults"] = "result[i] != Math.Abs(firstOp[i])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",     ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["ValidateFirstResult"] = "result[i1] != (short)(left[i3] + left[i3 + 1])",                                                         ["ValidateRemainingResults"] = "result[i2] != (short)(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",           ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["ValidateFirstResult"] = "result[i1] != (int)(left[i3] + left[i3 + 1])",                                                           ["ValidateRemainingResults"] = "result[i2] != (int)(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAddSaturate",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",     ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["ValidateFirstResult"] = "result[i1] != Math.Clamp((left[i3] + left[i3 + 1]), short.MinValue, short.MaxValue)",                    ["ValidateRemainingResults"] = "result[i2] != Math.Clamp((right[i3] + right[i3 + 1]), short.MinValue, short.MaxValue)"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",     ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["ValidateFirstResult"] = "result[i1] != (short)(left[i3] - left[i3 + 1])",                                                         ["ValidateRemainingResults"] = "result[i2] != (short)(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",           ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["ValidateFirstResult"] = "result[i1] != (int)(left[i3] - left[i3 + 1])",                                                           ["ValidateRemainingResults"] = "result[i2] != (int)(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtractSaturate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",     ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["ValidateFirstResult"] = "result[i1] != Math.Clamp((left[i3] - left[i3 + 1]), short.MinValue, short.MaxValue)",                    ["ValidateRemainingResults"] = "result[i2] != Math.Clamp((right[i3] - right[i3 + 1]), short.MinValue, short.MaxValue)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddAdjacent",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                    ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), short.MinValue, short.MaxValue)", ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), short.MinValue, short.MaxValue)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyHighRoundScale",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",     ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["ValidateFirstResult"] = "result[0] != (short)((((left[0] * right[0]) >> 14) + 1) >> 1)",                                          ["ValidateRemainingResults"] = "result[i] != (short)((((left[i] * right[i]) >> 14) + 1) >> 1)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",     ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? 0 : left[right[0] & 0x0F])",                                              ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? 0 : left[right[i] & 0x0F])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue + 1, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (sbyte)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                         ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (sbyte)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue + 1, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (short)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                         ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (short)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue + 1, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (int)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                           ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (int)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse41Inputs = new []
{
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp3"] = "(byte)(((i % 2) == 0) ? 128 : 1)",      ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                                  ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                        ["NextValueOp3"] = "(double)(((i % 2) == 0) ? -0.0 : 1.0)", ["ValidateFirstResult"] = "((BitConverter.DoubleToInt64Bits(thirdOp[0]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[0]) != BitConverter.DoubleToInt64Bits(result[0]) : BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.DoubleToInt64Bits(thirdOp[i]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[i]) != BitConverter.DoubleToInt64Bits(result[i]) : BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp3"] = "(sbyte)(((i % 2) == 0) ? -128 : 1)",    ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                                  ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                         ["NextValueOp3"] = "(float)(((i % 2) == 0) ? -0.0 : 1.0)",  ["ValidateFirstResult"] = "((BitConverter.SingleToInt32Bits(thirdOp[0]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[0]) != BitConverter.SingleToInt32Bits(result[0]) : BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.SingleToInt32Bits(thirdOp[i]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[i]) != BitConverter.SingleToInt32Bits(result[i]) : BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Ceiling",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Ceiling",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CeilingScalar",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                                                    ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(right[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "CeilingScalar",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(right[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                            ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                         ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1]))"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                                    ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                                   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                         ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                                   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Floor",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Floor",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "FloorScalar",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                                                    ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "FloorScalar",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["Data"] = "(byte)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)0",                                                                                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["Data"] = "(sbyte)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)0",                                                                                                                                                                                    ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["Data"] = "(int)2",   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)0",                                                                                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["Data"] = "(uint)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)0",                                                                                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["Data"] = "(long)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)0",                                                                                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["Data"] = "(ulong)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)0",                                                                                                                                                                                    ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["Data"] = "(float)2", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)0",                                                                                                                                                                                    ["ValidateFirstResult"] = "(i == 0 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((float)2) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((float)0))"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["Data"] = "(byte)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)0",                                                                                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["Data"] = "(sbyte)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)0",                                                                                                                                                                                    ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["Data"] = "(int)2",   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)0",                                                                                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["Data"] = "(uint)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)0",                                                                                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["Data"] = "(long)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)0",                                                                                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["Data"] = "(ulong)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)0",                                                                                                                                                                                    ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["Data"] = "(float)2", ["Imm"] = "217", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "(i == 2 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i]) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((float)0))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                             ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                        ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                             ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                             ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                        ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                             ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[0])) * right[0]), 0)",                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[i])) * right[i]), 0)"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "PackUnsignedSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "result[i1] != ((left[i3 - inner] > 0xFFFF) ? 0xFFFF : ((left[i3 - inner] < 0) ? 0 : BitConverter.ToUInt16(BitConverter.GetBytes(left[i3 - inner]), 0)))",                                                                                            ["ValidateRemainingResults"] = "result[i2] != ((right[i3 - inner] > 0xFFFF) ? 0xFFFF : ((right[i3 - inner] < 0) ? 0 : BitConverter.ToUInt16(BitConverter.GetBytes(right[i3 - inner]), 0)))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundCurrentDirection",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundCurrentDirection",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                                                    ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNearestInteger",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNearestInteger",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                                                    ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(right[0], MidpointRounding.AwayFromZero))",                                                                                                                   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(right[0], MidpointRounding.AwayFromZero))",                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNegativeInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNegativeInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                                                    ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToPositiveInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToPositiveInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                                                    ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(right[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(right[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToZero",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((firstOp[0] > 0) ? Math.Floor(firstOp[0]) : Math.Ceiling(firstOp[0]))",                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((firstOp[i] > 0) ? Math.Floor(firstOp[i]) : Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToZero",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                                ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((firstOp[0] > 0) ? MathF.Floor(firstOp[0]) : MathF.Ceiling(firstOp[0]))",                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((firstOp[i] > 0) ? MathF.Floor(firstOp[i]) : MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToZeroScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                                                    ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((right[0] > 0) ? Math.Floor(right[0]) : Math.Ceiling(right[0]))",                                                                                                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToZeroScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((right[0] > 0) ? MathF.Floor(right[0]) : MathF.Ceiling(right[0]))",                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("BooleanUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllOnes",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                                                     ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(~value[i] & byte.MaxValue) == 0"}),
    ("BooleanUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllOnes",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                                                                                                        ["ValidateFirstResult"] = "(~value[i] & -1) == 0"}),
    ("BooleanUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllOnes",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                                                                                              ["ValidateFirstResult"] = "(~value[i] & -1) == 0"}),
    ("BooleanUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllOnes",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                                                                                             ["ValidateFirstResult"] = "(~value[i] & -1) == 0"}),
    ("BooleanUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllOnes",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                                                                                                        ["ValidateFirstResult"] = "(~value[i] & -1) == 0"}),
    ("BooleanUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllOnes",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                   ["ValidateFirstResult"] = "(~value[i] & ushort.MaxValue) == 0"}),
    ("BooleanUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllOnes",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(~value[i] & uint.MaxValue) == 0"}),
    ("BooleanUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllOnes",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(~value[i] & ulong.MaxValue) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllZeros",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                            ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllZeros",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllZeros",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllZeros",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                  ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllZeros",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllZeros",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                        ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllZeros",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestAllZeros",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                            ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                            ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                  ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                        ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                            ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestMixOnesZeros",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                            ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestMixOnesZeros",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestMixOnesZeros",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestMixOnesZeros",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                  ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestMixOnesZeros",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestMixOnesZeros",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                        ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestMixOnesZeros",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestMixOnesZeros",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                            ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                            ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                  ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                        ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                            ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                            ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                   ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                  ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                        ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                            ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Sse42Inputs = new []
{
    ("SimpleBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse42", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))", ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((long)(-1)) : 0)", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((long)(-1)) : 0)"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] AvxInputs = new []
{
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Add",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Add",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AddSubtract",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "((i % 2 != 0) && (BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i]))) || ((i % 2 == 0) && (BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AddSubtract",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "((i % 2 != 0) && (BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i]))) || ((i % 2 == 0) && (BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "And",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "And",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AndNot",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "((~BitConverter.DoubleToInt64Bits(left[0])) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                               ["ValidateRemainingResults"] = "((~BitConverter.DoubleToInt64Bits(left[i])) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AndNot",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "((~BitConverter.SingleToInt32Bits(left[0])) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                               ["ValidateRemainingResults"] = "((~BitConverter.SingleToInt32Bits(left[i])) & BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "BlendVariable",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())", ["NextValueOp3"] = "(double)(((i % 2) == 0) ? -0.0 : 1.0)", ["ValidateFirstResult"] = "((BitConverter.DoubleToInt64Bits(thirdOp[0]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[0]) != BitConverter.DoubleToInt64Bits(result[0]) : BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.DoubleToInt64Bits(thirdOp[i]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[i]) != BitConverter.DoubleToInt64Bits(result[i]) : BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "BlendVariable",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",  ["NextValueOp3"] = "(float)(((i % 2) == 0) ? -0.0 : 1.0)",  ["ValidateFirstResult"] = "((BitConverter.SingleToInt32Bits(thirdOp[0]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[0]) != BitConverter.SingleToInt32Bits(result[0]) : BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.SingleToInt32Bits(thirdOp[i]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[i]) != BitConverter.SingleToInt32Bits(result[i]) : BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Ceiling",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Ceiling",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Divide",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] / right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Divide",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] / right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateEvenIndexed",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "(i % 2 == 0) ? (BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])) : (BitConverter.DoubleToInt64Bits(firstOp[i - 1]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateEvenIndexed",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "(i % 2 == 0) ? (BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(firstOp[i - 1]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateOddIndexed",     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "(i % 2 == 0) ? (BitConverter.SingleToInt32Bits(firstOp[i + 1]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Byte",                                                                                                            ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "SByte",                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                              ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Byte",                                                                                                            ["Imm"] = "20",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "(result[0] != firstOp[20])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "SByte",                                                                                                           ["Imm"] = "20",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                              ["ValidateFirstResult"] = "(result[0] != firstOp[20])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Byte",                                                                                                            ["Imm"] = "52",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "(result[0] != firstOp[20])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "SByte",                                                                                                           ["Imm"] = "52",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                              ["ValidateFirstResult"] = "(result[0] != firstOp[20])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int16",                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                              ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt16",                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                            ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int16",                                                                                                           ["Imm"] = "11",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                              ["ValidateFirstResult"] = "(result[0] != firstOp[11])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt16",                                                                                                          ["Imm"] = "11",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                            ["ValidateFirstResult"] = "(result[0] != firstOp[11])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int16",                                                                                                           ["Imm"] = "27",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                              ["ValidateFirstResult"] = "(result[0] != firstOp[11])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt16",                                                                                                          ["Imm"] = "27",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                            ["ValidateFirstResult"] = "(result[0] != firstOp[11])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int32",                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                  ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt32",                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int32",                                                                                                           ["Imm"] = "6",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                  ["ValidateFirstResult"] = "(result[0] != firstOp[6])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt32",                                                                                                          ["Imm"] = "6",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "(result[0] != firstOp[6])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int32",                                                                                                           ["Imm"] = "22",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                  ["ValidateFirstResult"] = "(result[0] != firstOp[6])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt32",                                                                                                          ["Imm"] = "22",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "(result[0] != firstOp[6])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int64",                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt64",                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int64",                                                                                                           ["Imm"] = "3",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "(result[0] != firstOp[3])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt64",                                                                                                          ["Imm"] = "3",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "(result[0] != firstOp[3])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int64",                                                                                                           ["Imm"] = "19",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "(result[0] != firstOp[3])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Extract",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt64",                                                                                                          ["Imm"] = "19",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "(result[0] != firstOp[3])"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                                                                                 ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                                                                       ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                                                                                 ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse", ["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                            ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "ExtendToVector256",       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (RetElementCount / 2)) ? firstOp[i] : 0)"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                           ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                              ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                              ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                            ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[4])",                                                                                                                                                            ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i + 4]))"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[2])",                                                                                                                                                            ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i + 2]))"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Byte",                                                                                    ["Data"] = "(byte)2",  ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Byte",                                                                                    ["Data"] = "(byte)2",  ["Imm"] = "20",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 20 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "SByte",                                                                                   ["Data"] = "(sbyte)2", ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "SByte",                                                                                   ["Data"] = "(sbyte)2", ["Imm"] = "20",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 20 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Byte",                                                                                    ["Data"] = "(byte)2",  ["Imm"] = "52",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 20 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "SByte",                                                                                   ["Data"] = "(sbyte)2", ["Imm"] = "52",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 20 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int16",                                                                                   ["Data"] = "(short)2", ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int16",                                                                                   ["Data"] = "(short)2", ["Imm"] = "11",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 11 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt16",                                                                                  ["Data"] = "(ushort)2",["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)0",                                                                                                                                                            ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt16",                                                                                  ["Data"] = "(ushort)2",["Imm"] = "11",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)0",                                                                                                                                                            ["ValidateFirstResult"] = "(i == 11 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int16",                                                                                   ["Data"] = "(short)2", ["Imm"] = "27",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 11 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt16",                                                                                  ["Data"] = "(ushort)2",["Imm"] = "27",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)0",                                                                                                                                                            ["ValidateFirstResult"] = "(i == 11 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int32",                                                                                   ["Data"] = "(int)2",   ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)0",                                                                                                                                                               ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int32",                                                                                   ["Data"] = "(int)2",   ["Imm"] = "6",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)0",                                                                                                                                                               ["ValidateFirstResult"] = "(i == 6 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt32",                                                                                  ["Data"] = "(uint)2",  ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt32",                                                                                  ["Data"] = "(uint)2",  ["Imm"] = "6",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 6 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int32",                                                                                   ["Data"] = "(int)2",   ["Imm"] = "22",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)0",                                                                                                                                                               ["ValidateFirstResult"] = "(i == 6 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt32",                                                                                  ["Data"] = "(uint)2",  ["Imm"] = "22",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 6 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int64",                                                                                   ["Data"] = "(long)2",  ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int64",                                                                                   ["Data"] = "(long)2",  ["Imm"] = "3",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 3 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt64",                                                                                  ["Data"] = "(ulong)2", ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 1 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt64",                                                                                  ["Data"] = "(ulong)2", ["Imm"] = "3",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 3 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int64",                                                                                   ["Data"] = "(long)2",  ["Imm"] = "19",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)0",                                                                                                                                                              ["ValidateFirstResult"] = "(i == 3 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Insert",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt64",                                                                                  ["Data"] = "(ulong)2", ["Imm"] = "19",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)0",                                                                                                                                                             ["ValidateFirstResult"] = "(i == 3 ? result[i] != 2 : result[i] != 0)"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                              ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                    ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",               ["NextValueOp2"] = "(sbyte)(random.Next(0,sbyte.MaxValue))",                                                   ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",               ["NextValueOp2"] = "(short)(random.Next(0,short.MaxValue))",                                                   ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0,ushort.MaxValue))",                                                 ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                   ["NextValueOp2"] = "(int)(random.Next(0,int.MaxValue))",                                                       ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0,int.MaxValue))",                                                      ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(long)(random.Next(0,int.MaxValue))",                                                      ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0,int.MaxValue))",                                                     ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                          ["NextValueOp2"] = "(float)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 3 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(right[i - 4]) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i]))"}),
    ("InsertLoadTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                         ["NextValueOp2"] = "(double)(random.NextDouble())",                                                            ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "(i > 1 ? BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[i - 2]) : BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Floor",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Floor",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                                                                                 ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                                                                       ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                                                                                 ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                            ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                 ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("GenericUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "GetLowerHalf",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != ((i < (Op1ElementCount / 2)) ? firstOp[i] : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Max",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Max",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Max(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Min",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Min",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Min(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Multiply",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] * right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Multiply",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] * right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Or",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Or",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[4]) != BitConverter.SingleToInt32Bits(firstOp[5])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[1])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[2]) != BitConverter.DoubleToInt64Bits(firstOp[2]) || BitConverter.DoubleToInt64Bits(result[2]) != BitConverter.DoubleToInt64Bits(firstOp[2])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse", ["Method"] = "Permute",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                          ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[2])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[1]) != BitConverter.SingleToInt32Bits(firstOp[0]) || BitConverter.SingleToInt32Bits(result[2]) != BitConverter.SingleToInt32Bits(firstOp[0])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "Permute",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                          ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[1]) != BitConverter.DoubleToInt64Bits(firstOp[1])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "BitConverter.Int32BitsToSingle(1)",                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i > 3 ? (BitConverter.SingleToInt32Bits(left[5]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "BitConverter.Int64BitsToDouble(1)",                                                         ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i > 1 ? (BitConverter.DoubleToInt64Bits(left[2]) != BitConverter.DoubleToInt64Bits(result[i])) : (BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundCurrentDirection",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundCurrentDirection",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNearestInteger",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNearestInteger",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNegativeInfinity", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNegativeInfinity", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToPositiveInfinity", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToPositiveInfinity", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToZero",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((firstOp[0] > 0) ? Math.Floor(firstOp[0]) : Math.Ceiling(firstOp[0]))",                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((firstOp[i] > 0) ? Math.Floor(firstOp[i]) : Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToZero",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((firstOp[0] > 0) ? MathF.Floor(firstOp[0]) : MathF.Ceiling(firstOp[0]))",                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((firstOp[i] > 0) ? MathF.Floor(firstOp[i]) : MathF.Ceiling(firstOp[i]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Shuffle",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                             ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[1])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[7]) != BitConverter.SingleToInt32Bits(right[4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Shuffle",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                             ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[1])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[3]) != BitConverter.DoubleToInt64Bits(right[2])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Subtract",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Subtract",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                     ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                      ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                            ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                           ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                      ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                 ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                      ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                     ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                     ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                      ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                            ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                           ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                      ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                 ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                      ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                     ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                     ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                      ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                            ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",      ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                           ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))", ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                      ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",            ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                 ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                      ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                     ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Xor",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                        ["NextValueOp2"] = "(double)(random.NextDouble())",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Xor",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                         ["NextValueOp2"] = "(float)(random.NextDouble())",                                                              ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Avx2Inputs = new []
{
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "(byte)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "(short)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "(int)(left[0] + right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                ["ValidateFirstResult"] = "(long)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "(ushort)(left[0] + right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "(uint)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "(ulong)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "(byte)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "(short)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "(int)(left[0] & right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                ["ValidateFirstResult"] = "(long)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "(ushort)(left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "(uint)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "(ulong)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "(byte)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(byte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "(short)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(short)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "(int)(~left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(int)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                ["ValidateFirstResult"] = "(long)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(long)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "(sbyte)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(sbyte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "(ushort)(~left[0] & right[0]) != result[0]",                                              ["ValidateRemainingResults"] = "(ushort)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "(uint)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(uint)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "(ulong)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ulong)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Average",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "(byte)((left[0] + right[0] + 1) >> 1) != result[0]",                                      ["ValidateRemainingResults"] = "(byte)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Average",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(short.MinValue, short.MaxValue))", ["NextValueOp2"] = "(ushort)(random.Next(short.MinValue, short.MaxValue))",                                                          ["ValidateFirstResult"] = "(ushort)((left[0] + right[0] + 1) >> 1) != result[0]",                                    ["ValidateRemainingResults"] = "(ushort)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Byte",                   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp3"] = "(byte)(((i % 2) == 0) ? 128 : 1)",   ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",       ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "SByte",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp3"] = "(sbyte)(((i % 2) == 0) ? -128 : 1)", ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",       ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse",  ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                              ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                             ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse",  ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(float)(random.NextDouble())",                                                                                                                                                               ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("GenericUnOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(double)(random.NextDouble())",                                                                                                                                                              ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((byte)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((byte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((short)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((int)(-1)) : 0)",                         ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((long)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((sbyte)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ushort)(-1)) : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ushort)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((uint)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ulong)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((short)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((int)(-1)) : 0)",                          ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((long)(-1)) : 0)",                         ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((sbyte)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("ExtractVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                           ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("ExtractVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                           ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("ExtractStoreTest.template",    new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("InsertVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                              ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",               ["NextValueOp2"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",                                                                        ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",               ["NextValueOp2"] = "(short)(random.Next(0, short.MaxValue))",                                                                        ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                   ["NextValueOp2"] = "(int)(random.Next(0, int.MaxValue))",                                                                            ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(long)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("InsertVector128Test.template",new Dictionary<string, string>{["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("InsertLoadTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                              ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertLoadTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(0, sbyte.MaxValue))",               ["NextValueOp2"] = "(sbyte)(random.Next(0,sbyte.MaxValue))",                                                                         ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertLoadTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",               ["NextValueOp2"] = "(short)(random.Next(0,short.MaxValue))",                                                                         ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertLoadTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0,ushort.MaxValue))",                                                                       ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertLoadTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                   ["NextValueOp2"] = "(int)(random.Next(0,int.MaxValue))",                                                                             ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertLoadTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0,int.MaxValue))",                                                                            ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertLoadTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(long)(random.Next(0,int.MaxValue))",                                                                            ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("InsertLoadTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0,int.MaxValue))",                                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(byte.MinValue, byte.MaxValue))",     ["NextValueOp2"] = "(byte)(random.Next(byte.MinValue, byte.MaxValue))",                                                              ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(byte.MinValue, byte.MaxValue))",     ["NextValueOp2"] = "(byte)(random.Next(byte.MinValue, byte.MaxValue))",                                                              ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "(byte)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "(short)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "(int)(left[0] | right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                ["ValidateFirstResult"] = "(long)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "(ushort)(left[0] | right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "(uint)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "(ulong)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] | right[i]) != result[i]"}),
    ("ImmBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                   ["NextValueOp2"] = "(int)(random.Next(0, int.MaxValue))",                                                                            ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 3 ? (result[i] != left[i - 4]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 3 ? (result[i] != left[i - 4]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(long)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 1 ? (result[i] != left[i - 2]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 1 ? (result[i] != left[i - 2]) : (result[i] != right[i])"}),    
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "(short)(firstOp[0] << 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                  ["ValidateFirstResult"] = "(ushort)(firstOp[0] << 1) != result[0]",                                                  ["ValidateRemainingResults"] = "(ushort)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(int)(firstOp[0] << 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(uint)(firstOp[0] << 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(uint)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(long)(firstOp[0] << 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(long)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "(ulong)(firstOp[0] << 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(ulong)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)8",                                                                                                                                                                                   ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "(i == 16 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                            ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)8",                                                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "(i == 16 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)8",                                                                                                                                                                                   ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)8",                                                                                                                                                                                  ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)8",                                                                                                                                                                                     ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)8",                                                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)8",                                                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)8",                                                                                                                                                                                   ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "(short)(firstOp[0] >> 15) != result[0]",                                                  ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 15) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(int)(firstOp[0] >> 31) != result[0]",                                                    ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 31) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                  ["ValidateFirstResult"] = "(ushort)(firstOp[0] >> 1) != result[0]",                                                  ["ValidateRemainingResults"] = "(ushort)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(uint)(firstOp[0] >> 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(uint)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "(long)(firstOp[0] >> 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(long)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "(ulong)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(ulong)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(0, short.MaxValue))",                                                                                                                                                    ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(0, int.MaxValue))",                                                                                                                                                        ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(0, int.MaxValue))",                                                                                                                                                       ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                                                                                                      ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)8",                                                                                                                                                                                   ["ValidateFirstResult"] = "result[0] != 8",                                                                          ["ValidateRemainingResults"] = "(i == 31 || i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                            ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)8",                                                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != 8",                                                                          ["ValidateRemainingResults"] = "(i == 31 || i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)8",                                                                                                                                                                                   ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "(i == 7 || i == 15 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)8",                                                                                                                                                                                  ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "(i == 7 || i == 15 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)8",                                                                                                                                                                                     ["ValidateFirstResult"] = "result[0] != 134217728",                                                                  ["ValidateRemainingResults"] = "(i == 3 || i == 7 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)8",                                                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != 134217728",                                                                  ["ValidateRemainingResults"] = "(i == 3 || i == 7 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)8",                                                                                                                                                                                    ["ValidateFirstResult"] = "result[0] != 576460752303423488L",                                                        ["ValidateRemainingResults"] = "(i == 2 ? result[i] != 576460752303423488L : result[i] != 0)"}),
    ("ImmUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)8",                                                                                                                                                                                   ["ValidateFirstResult"] = "result[0] != 576460752303423488UL",                                                       ["ValidateRemainingResults"] = "(i == 2 ? result[i] != 576460752303423488UL : result[i] != 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "(byte)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "(short)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "(int)(left[0] - right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                ["ValidateFirstResult"] = "(long)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "(ushort)(left[0] - right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "(uint)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "(ulong)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)(random.Next(0, byte.MaxValue))",                 ["NextValueOp2"] = "(byte)(random.Next(0, byte.MaxValue))",                                                                          ["ValidateFirstResult"] = "(byte)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)(random.Next(short.MinValue, short.MaxValue))",  ["NextValueOp2"] = "(short)(random.Next(short.MinValue, short.MaxValue))",                                                           ["ValidateFirstResult"] = "(short)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)(random.Next(int.MinValue, int.MaxValue))",        ["NextValueOp2"] = "(int)(random.Next(int.MinValue, int.MaxValue))",                                                                 ["ValidateFirstResult"] = "(int)(left[0] ^ right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)(random.Next(int.MinValue, int.MaxValue))",       ["NextValueOp2"] = "(long)(random.Next(int.MinValue, int.MaxValue))",                                                                ["ValidateFirstResult"] = "(long)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",  ["NextValueOp2"] = "(sbyte)(random.Next(sbyte.MinValue, sbyte.MaxValue))",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)(random.Next(0, ushort.MaxValue))",             ["NextValueOp2"] = "(ushort)(random.Next(0, ushort.MaxValue))",                                                                      ["ValidateFirstResult"] = "(ushort)(left[0] ^ right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)(random.Next(0, int.MaxValue))",                  ["NextValueOp2"] = "(uint)(random.Next(0, int.MaxValue))",                                                                           ["ValidateFirstResult"] = "(uint)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)(random.Next(0, int.MaxValue))",                 ["NextValueOp2"] = "(ulong)(random.Next(0, int.MaxValue))",                                                                          ["ValidateFirstResult"] = "(ulong)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] ^ right[i]) != result[i]"}),
};

private static void ProcessInputs(string isa, (string templateFileName, Dictionary<string, string> templateData)[] inputs)
{
    var testListFileName = Path.Combine("..", isa, $"Program.{isa}.cs");

    using (var testListFile = new StreamWriter(testListFileName, append: false))
    {
        testListFile.WriteLine(@"// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.X86
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {");

        foreach (var input in inputs)
        {
            ProcessInput(testListFile, input);
        }

        testListFile.WriteLine(@"            };
        }
    }
}");
    }
}

private static bool isImmTemplate(string name)
{
    return name == "ImmUnOpTest.template" || name == "InsertScalarTest.template" ||
           name == "ExtractScalarTest.template" || name == "InsertVector128Test.template" ||
           name == "ExtractVector128Test.template" || name == "InsertLoadTest.template" ||
           name == "ExtractStoreTest.template" || name == "ImmBinOpTest.template";
}

private static void ProcessInput(StreamWriter testListFile, (string templateFileName, Dictionary<string, string> templateData) input)

{
    var testName = $"{input.templateData["Method"]}.{input.templateData["RetBaseType"]}";

    var suffix = "";

    if (isImmTemplate(input.templateFileName))
    {
        testName += $".{input.templateData["Imm"]}";
        suffix += $"{input.templateData["Imm"]}";
    }

    if (input.templateFileName == "InsertLoadTest.template")
    {
        testName += ".Load";
        suffix += "Load";
    }
    else if (input.templateFileName == "ExtractStoreTest.template")
    {
        testName += ".Store";
        suffix += "Store";
    }

    // Ex: ["Add.Single"] = AddSingle
    testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["RetBaseType"]}{suffix},");


    var testFileName = Path.Combine("..", input.templateData["Isa"], $"{testName}.cs");
    var template = File.ReadAllText(input.templateFileName);

    foreach (var kvp in input.templateData)
    {
        template = template.Replace($"{{{kvp.Key}}}", kvp.Value);
    }

    File.WriteAllText(testFileName, template);
}

ProcessInputs("Sse", SseInputs);
ProcessInputs("Sse2", Sse2Inputs);
ProcessInputs("Sse3", Sse3Inputs);
ProcessInputs("Ssse3", Ssse3Inputs);
ProcessInputs("Sse41", Sse41Inputs);
ProcessInputs("Sse42", Sse42Inputs);
ProcessInputs("Avx", AvxInputs);
ProcessInputs("Avx2", Avx2Inputs);
