// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

#pragma warning disable 0184


using System;
using System.Runtime.InteropServices;

internal class Program
{
    private static void Eval(int testCase, bool b1, bool b2)
    {
        if (b1 != b2) throw new Exception(string.Format("case {0:000} failed: v1 {1} v2 {2}", testCase, b1, b2));
    }

    private static void TestCase0001()
    {
        {
            ImplementOneInterface v = default(ImplementOneInterface);
            IEmpty o = v; ;
            Eval(0001, o is ImplementOneInterface, true);
            Eval(0002, o is ImplementOneInterface[], false);
            Eval(0003, o is ImplementOneInterface?, true);
            Eval(0004, o is ImplementOneInterface?[], false);
            Eval(0005, o is ImplementTwoInterface, false);
            Eval(0006, o is ImplementTwoInterface[], false);
            Eval(0007, o is ImplementTwoInterface?, false);
            Eval(0008, o is ImplementTwoInterface?[], false);
            Eval(0009, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0010, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0011, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0012, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0013, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0014, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0015, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0016, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0017, o is ImplementAllInterface<int>, false);
            Eval(0018, o is ImplementAllInterface<int>[], false);
            Eval(0019, o is ImplementAllInterface<int>?, false);
            Eval(0020, o is ImplementAllInterface<int>?[], false);
            Eval(0021, o is char, false);
            Eval(0022, o is char[], false);
            Eval(0023, o is char?, false);
            Eval(0024, o is char?[], false);
            Eval(0025, o is bool, false);
            Eval(0026, o is bool[], false);
            Eval(0027, o is bool?, false);
            Eval(0028, o is bool?[], false);
            Eval(0029, o is byte, false);
            Eval(0030, o is byte[], false);
            Eval(0031, o is byte?, false);
            Eval(0032, o is byte?[], false);
            Eval(0033, o is sbyte, false);
            Eval(0034, o is sbyte[], false);
            Eval(0035, o is sbyte?, false);
            Eval(0036, o is sbyte?[], false);
            Eval(0037, o is short, false);
            Eval(0038, o is short[], false);
            Eval(0039, o is short?, false);
            Eval(0040, o is short?[], false);
            Eval(0041, o is ushort, false);
            Eval(0042, o is ushort[], false);
            Eval(0043, o is ushort?, false);
            Eval(0044, o is ushort?[], false);
            Eval(0045, o is int, false);
            Eval(0046, o is int[], false);
            Eval(0047, o is int?, false);
            Eval(0048, o is int?[], false);
            Eval(0049, o is uint, false);
            Eval(0050, o is uint[], false);
            Eval(0051, o is uint?, false);
            Eval(0052, o is uint?[], false);
            Eval(0053, o is long, false);
            Eval(0054, o is long[], false);
            Eval(0055, o is long?, false);
            Eval(0056, o is long?[], false);
            Eval(0057, o is ulong, false);
            Eval(0058, o is ulong[], false);
            Eval(0059, o is ulong?, false);
            Eval(0060, o is ulong?[], false);
            Eval(0061, o is float, false);
            Eval(0062, o is float[], false);
            Eval(0063, o is float?, false);
            Eval(0064, o is float?[], false);
            Eval(0065, o is double, false);
            Eval(0066, o is double[], false);
            Eval(0067, o is double?, false);
            Eval(0068, o is double?[], false);
            Eval(0069, o is decimal, false);
            Eval(0070, o is decimal[], false);
            Eval(0071, o is decimal?, false);
            Eval(0072, o is decimal?[], false);
            Eval(0073, o is object, true);
            Eval(0074, o is object[], false);
            Eval(0075, o is string, false);
            Eval(0076, o is string[], false);
            Eval(0077, o is ValueType, true);
            Eval(0078, o is ValueType[], false);
            Eval(0079, o is Array, false);
            Eval(0080, o is Array[], false);
            Eval(0081, o is Enum, false);
            Eval(0082, o is Enum[], false);
            Eval(0083, o is Delegate, false);
            Eval(0084, o is Delegate[], false);
            Eval(0085, o is MulticastDelegate, false);
            Eval(0086, o is MulticastDelegate[], false);
            Eval(0087, o is IEmpty, true);
            Eval(0088, o is IEmpty[], false);
            Eval(0089, o is INotEmpty, false);
            Eval(0090, o is INotEmpty[], false);
            Eval(0091, o is IEmptyGen<int>, false);
            Eval(0092, o is IEmptyGen<int>[], false);
            Eval(0093, o is INotEmptyGen<int>, false);
            Eval(0094, o is INotEmptyGen<int>[], false);
            Eval(0095, o is SimpleDelegate, false);
            Eval(0096, o is SimpleDelegate[], false);
            Eval(0097, o is GenericDelegate<int>, false);
            Eval(0098, o is GenericDelegate<int>[], false);
            Eval(0099, o is EmptyClass, false);
            Eval(0100, o is EmptyClass[], false);
            Eval(0101, o is NotEmptyClass, false);
            Eval(0102, o is NotEmptyClass[], false);
            Eval(0103, o is EmptyClassGen<int>, false);
            Eval(0104, o is EmptyClassGen<int>[], false);
            Eval(0105, o is NotEmptyClassGen<Guid>, false);
            Eval(0106, o is NotEmptyClassGen<Guid>[], false);
            Eval(0107, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0108, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0109, o is NestedClass, false);
            Eval(0110, o is NestedClass[], false);
            Eval(0111, o is NestedClassGen<Decimal>, false);
            Eval(0112, o is NestedClassGen<Decimal>[], false);
            Eval(0113, o is ImplementOneInterfaceC, false);
            Eval(0114, o is ImplementOneInterfaceC[], false);
            Eval(0115, o is ImplementTwoInterfaceC, false);
            Eval(0116, o is ImplementTwoInterfaceC[], false);
            Eval(0117, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0118, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0119, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0120, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0121, o is ImplementAllInterfaceC<int>, false);
            Eval(0122, o is ImplementAllInterfaceC<int>[], false);
            Eval(0123, o is SealedClass, false);
            Eval(0124, o is SealedClass[], false);
        }
        {
            ImplementOneInterface? v = default(ImplementOneInterface);
            IEmpty o = v; ;
            Eval(0125, o is ImplementOneInterface, true);
            Eval(0126, o is ImplementOneInterface[], false);
            Eval(0127, o is ImplementOneInterface?, true);
            Eval(0128, o is ImplementOneInterface?[], false);
            Eval(0129, o is ImplementTwoInterface, false);
            Eval(0130, o is ImplementTwoInterface[], false);
            Eval(0131, o is ImplementTwoInterface?, false);
            Eval(0132, o is ImplementTwoInterface?[], false);
            Eval(0133, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0134, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0135, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0136, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0137, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0138, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0139, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0140, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0141, o is ImplementAllInterface<int>, false);
            Eval(0142, o is ImplementAllInterface<int>[], false);
            Eval(0143, o is ImplementAllInterface<int>?, false);
            Eval(0144, o is ImplementAllInterface<int>?[], false);
            Eval(0145, o is char, false);
            Eval(0146, o is char[], false);
            Eval(0147, o is char?, false);
            Eval(0148, o is char?[], false);
            Eval(0149, o is bool, false);
            Eval(0150, o is bool[], false);
            Eval(0151, o is bool?, false);
            Eval(0152, o is bool?[], false);
            Eval(0153, o is byte, false);
            Eval(0154, o is byte[], false);
            Eval(0155, o is byte?, false);
            Eval(0156, o is byte?[], false);
            Eval(0157, o is sbyte, false);
            Eval(0158, o is sbyte[], false);
            Eval(0159, o is sbyte?, false);
            Eval(0160, o is sbyte?[], false);
            Eval(0161, o is short, false);
            Eval(0162, o is short[], false);
            Eval(0163, o is short?, false);
            Eval(0164, o is short?[], false);
            Eval(0165, o is ushort, false);
            Eval(0166, o is ushort[], false);
            Eval(0167, o is ushort?, false);
            Eval(0168, o is ushort?[], false);
            Eval(0169, o is int, false);
            Eval(0170, o is int[], false);
            Eval(0171, o is int?, false);
            Eval(0172, o is int?[], false);
            Eval(0173, o is uint, false);
            Eval(0174, o is uint[], false);
            Eval(0175, o is uint?, false);
            Eval(0176, o is uint?[], false);
            Eval(0177, o is long, false);
            Eval(0178, o is long[], false);
            Eval(0179, o is long?, false);
            Eval(0180, o is long?[], false);
            Eval(0181, o is ulong, false);
            Eval(0182, o is ulong[], false);
            Eval(0183, o is ulong?, false);
            Eval(0184, o is ulong?[], false);
            Eval(0185, o is float, false);
            Eval(0186, o is float[], false);
            Eval(0187, o is float?, false);
            Eval(0188, o is float?[], false);
            Eval(0189, o is double, false);
            Eval(0190, o is double[], false);
            Eval(0191, o is double?, false);
            Eval(0192, o is double?[], false);
            Eval(0193, o is decimal, false);
            Eval(0194, o is decimal[], false);
            Eval(0195, o is decimal?, false);
            Eval(0196, o is decimal?[], false);
            Eval(0197, o is object, true);
            Eval(0198, o is object[], false);
            Eval(0199, o is string, false);
            Eval(0200, o is string[], false);
            Eval(0201, o is ValueType, true);
            Eval(0202, o is ValueType[], false);
            Eval(0203, o is Array, false);
            Eval(0204, o is Array[], false);
            Eval(0205, o is Enum, false);
            Eval(0206, o is Enum[], false);
            Eval(0207, o is Delegate, false);
            Eval(0208, o is Delegate[], false);
            Eval(0209, o is MulticastDelegate, false);
            Eval(0210, o is MulticastDelegate[], false);
            Eval(0211, o is IEmpty, true);
            Eval(0212, o is IEmpty[], false);
            Eval(0213, o is INotEmpty, false);
            Eval(0214, o is INotEmpty[], false);
            Eval(0215, o is IEmptyGen<int>, false);
            Eval(0216, o is IEmptyGen<int>[], false);
            Eval(0217, o is INotEmptyGen<int>, false);
            Eval(0218, o is INotEmptyGen<int>[], false);
            Eval(0219, o is SimpleDelegate, false);
            Eval(0220, o is SimpleDelegate[], false);
            Eval(0221, o is GenericDelegate<int>, false);
            Eval(0222, o is GenericDelegate<int>[], false);
            Eval(0223, o is EmptyClass, false);
            Eval(0224, o is EmptyClass[], false);
            Eval(0225, o is NotEmptyClass, false);
            Eval(0226, o is NotEmptyClass[], false);
            Eval(0227, o is EmptyClassGen<int>, false);
            Eval(0228, o is EmptyClassGen<int>[], false);
            Eval(0229, o is NotEmptyClassGen<Guid>, false);
            Eval(0230, o is NotEmptyClassGen<Guid>[], false);
            Eval(0231, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0232, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0233, o is NestedClass, false);
            Eval(0234, o is NestedClass[], false);
            Eval(0235, o is NestedClassGen<Decimal>, false);
            Eval(0236, o is NestedClassGen<Decimal>[], false);
            Eval(0237, o is ImplementOneInterfaceC, false);
            Eval(0238, o is ImplementOneInterfaceC[], false);
            Eval(0239, o is ImplementTwoInterfaceC, false);
            Eval(0240, o is ImplementTwoInterfaceC[], false);
            Eval(0241, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0242, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0243, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0244, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0245, o is ImplementAllInterfaceC<int>, false);
            Eval(0246, o is ImplementAllInterfaceC<int>[], false);
            Eval(0247, o is SealedClass, false);
            Eval(0248, o is SealedClass[], false);
        }
        {
            ImplementOneInterface? v = default(ImplementOneInterface?);
            IEmpty o = v; ;
            Eval(0249, o is ImplementOneInterface, false);
            Eval(0250, o is ImplementOneInterface[], false);
            Eval(0251, o is ImplementOneInterface?, false);
            Eval(0252, o is ImplementOneInterface?[], false);
            Eval(0253, o is ImplementTwoInterface, false);
            Eval(0254, o is ImplementTwoInterface[], false);
            Eval(0255, o is ImplementTwoInterface?, false);
            Eval(0256, o is ImplementTwoInterface?[], false);
            Eval(0257, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0258, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0259, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0260, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0261, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0262, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0263, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0264, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0265, o is ImplementAllInterface<int>, false);
            Eval(0266, o is ImplementAllInterface<int>[], false);
            Eval(0267, o is ImplementAllInterface<int>?, false);
            Eval(0268, o is ImplementAllInterface<int>?[], false);
            Eval(0269, o is char, false);
            Eval(0270, o is char[], false);
            Eval(0271, o is char?, false);
            Eval(0272, o is char?[], false);
            Eval(0273, o is bool, false);
            Eval(0274, o is bool[], false);
            Eval(0275, o is bool?, false);
            Eval(0276, o is bool?[], false);
            Eval(0277, o is byte, false);
            Eval(0278, o is byte[], false);
            Eval(0279, o is byte?, false);
            Eval(0280, o is byte?[], false);
            Eval(0281, o is sbyte, false);
            Eval(0282, o is sbyte[], false);
            Eval(0283, o is sbyte?, false);
            Eval(0284, o is sbyte?[], false);
            Eval(0285, o is short, false);
            Eval(0286, o is short[], false);
            Eval(0287, o is short?, false);
            Eval(0288, o is short?[], false);
            Eval(0289, o is ushort, false);
            Eval(0290, o is ushort[], false);
            Eval(0291, o is ushort?, false);
            Eval(0292, o is ushort?[], false);
            Eval(0293, o is int, false);
            Eval(0294, o is int[], false);
            Eval(0295, o is int?, false);
            Eval(0296, o is int?[], false);
            Eval(0297, o is uint, false);
            Eval(0298, o is uint[], false);
            Eval(0299, o is uint?, false);
            Eval(0300, o is uint?[], false);
            Eval(0301, o is long, false);
            Eval(0302, o is long[], false);
            Eval(0303, o is long?, false);
            Eval(0304, o is long?[], false);
            Eval(0305, o is ulong, false);
            Eval(0306, o is ulong[], false);
            Eval(0307, o is ulong?, false);
            Eval(0308, o is ulong?[], false);
            Eval(0309, o is float, false);
            Eval(0310, o is float[], false);
            Eval(0311, o is float?, false);
            Eval(0312, o is float?[], false);
            Eval(0313, o is double, false);
            Eval(0314, o is double[], false);
            Eval(0315, o is double?, false);
            Eval(0316, o is double?[], false);
            Eval(0317, o is decimal, false);
            Eval(0318, o is decimal[], false);
            Eval(0319, o is decimal?, false);
            Eval(0320, o is decimal?[], false);
            Eval(0321, o is object, false);
            Eval(0322, o is object[], false);
            Eval(0323, o is string, false);
            Eval(0324, o is string[], false);
            Eval(0325, o is ValueType, false);
            Eval(0326, o is ValueType[], false);
            Eval(0327, o is Array, false);
            Eval(0328, o is Array[], false);
            Eval(0329, o is Enum, false);
            Eval(0330, o is Enum[], false);
            Eval(0331, o is Delegate, false);
            Eval(0332, o is Delegate[], false);
            Eval(0333, o is MulticastDelegate, false);
            Eval(0334, o is MulticastDelegate[], false);
            Eval(0335, o is IEmpty, false);
            Eval(0336, o is IEmpty[], false);
            Eval(0337, o is INotEmpty, false);
            Eval(0338, o is INotEmpty[], false);
            Eval(0339, o is IEmptyGen<int>, false);
            Eval(0340, o is IEmptyGen<int>[], false);
            Eval(0341, o is INotEmptyGen<int>, false);
            Eval(0342, o is INotEmptyGen<int>[], false);
            Eval(0343, o is SimpleDelegate, false);
            Eval(0344, o is SimpleDelegate[], false);
            Eval(0345, o is GenericDelegate<int>, false);
            Eval(0346, o is GenericDelegate<int>[], false);
            Eval(0347, o is EmptyClass, false);
            Eval(0348, o is EmptyClass[], false);
            Eval(0349, o is NotEmptyClass, false);
            Eval(0350, o is NotEmptyClass[], false);
            Eval(0351, o is EmptyClassGen<int>, false);
            Eval(0352, o is EmptyClassGen<int>[], false);
            Eval(0353, o is NotEmptyClassGen<Guid>, false);
            Eval(0354, o is NotEmptyClassGen<Guid>[], false);
            Eval(0355, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0356, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0357, o is NestedClass, false);
            Eval(0358, o is NestedClass[], false);
            Eval(0359, o is NestedClassGen<Decimal>, false);
            Eval(0360, o is NestedClassGen<Decimal>[], false);
            Eval(0361, o is ImplementOneInterfaceC, false);
            Eval(0362, o is ImplementOneInterfaceC[], false);
            Eval(0363, o is ImplementTwoInterfaceC, false);
            Eval(0364, o is ImplementTwoInterfaceC[], false);
            Eval(0365, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0366, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0367, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0368, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0369, o is ImplementAllInterfaceC<int>, false);
            Eval(0370, o is ImplementAllInterfaceC<int>[], false);
            Eval(0371, o is SealedClass, false);
            Eval(0372, o is SealedClass[], false);
        }
    }  // end of test case 0001
    private static void TestCase0002()
    {
        {
            ImplementTwoInterface v = default(ImplementTwoInterface);
            IEmpty o = v; ;
            Eval(0373, o is ImplementOneInterface, false);
            Eval(0374, o is ImplementOneInterface[], false);
            Eval(0375, o is ImplementOneInterface?, false);
            Eval(0376, o is ImplementOneInterface?[], false);
            Eval(0377, o is ImplementTwoInterface, true);
            Eval(0378, o is ImplementTwoInterface[], false);
            Eval(0379, o is ImplementTwoInterface?, true);
            Eval(0380, o is ImplementTwoInterface?[], false);
            Eval(0381, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0382, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0383, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0384, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0385, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0386, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0387, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0388, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0389, o is ImplementAllInterface<int>, false);
            Eval(0390, o is ImplementAllInterface<int>[], false);
            Eval(0391, o is ImplementAllInterface<int>?, false);
            Eval(0392, o is ImplementAllInterface<int>?[], false);
            Eval(0393, o is char, false);
            Eval(0394, o is char[], false);
            Eval(0395, o is char?, false);
            Eval(0396, o is char?[], false);
            Eval(0397, o is bool, false);
            Eval(0398, o is bool[], false);
            Eval(0399, o is bool?, false);
            Eval(0400, o is bool?[], false);
            Eval(0401, o is byte, false);
            Eval(0402, o is byte[], false);
            Eval(0403, o is byte?, false);
            Eval(0404, o is byte?[], false);
            Eval(0405, o is sbyte, false);
            Eval(0406, o is sbyte[], false);
            Eval(0407, o is sbyte?, false);
            Eval(0408, o is sbyte?[], false);
            Eval(0409, o is short, false);
            Eval(0410, o is short[], false);
            Eval(0411, o is short?, false);
            Eval(0412, o is short?[], false);
            Eval(0413, o is ushort, false);
            Eval(0414, o is ushort[], false);
            Eval(0415, o is ushort?, false);
            Eval(0416, o is ushort?[], false);
            Eval(0417, o is int, false);
            Eval(0418, o is int[], false);
            Eval(0419, o is int?, false);
            Eval(0420, o is int?[], false);
            Eval(0421, o is uint, false);
            Eval(0422, o is uint[], false);
            Eval(0423, o is uint?, false);
            Eval(0424, o is uint?[], false);
            Eval(0425, o is long, false);
            Eval(0426, o is long[], false);
            Eval(0427, o is long?, false);
            Eval(0428, o is long?[], false);
            Eval(0429, o is ulong, false);
            Eval(0430, o is ulong[], false);
            Eval(0431, o is ulong?, false);
            Eval(0432, o is ulong?[], false);
            Eval(0433, o is float, false);
            Eval(0434, o is float[], false);
            Eval(0435, o is float?, false);
            Eval(0436, o is float?[], false);
            Eval(0437, o is double, false);
            Eval(0438, o is double[], false);
            Eval(0439, o is double?, false);
            Eval(0440, o is double?[], false);
            Eval(0441, o is decimal, false);
            Eval(0442, o is decimal[], false);
            Eval(0443, o is decimal?, false);
            Eval(0444, o is decimal?[], false);
            Eval(0445, o is object, true);
            Eval(0446, o is object[], false);
            Eval(0447, o is string, false);
            Eval(0448, o is string[], false);
            Eval(0449, o is ValueType, true);
            Eval(0450, o is ValueType[], false);
            Eval(0451, o is Array, false);
            Eval(0452, o is Array[], false);
            Eval(0453, o is Enum, false);
            Eval(0454, o is Enum[], false);
            Eval(0455, o is Delegate, false);
            Eval(0456, o is Delegate[], false);
            Eval(0457, o is MulticastDelegate, false);
            Eval(0458, o is MulticastDelegate[], false);
            Eval(0459, o is IEmpty, true);
            Eval(0460, o is IEmpty[], false);
            Eval(0461, o is INotEmpty, true);
            Eval(0462, o is INotEmpty[], false);
            Eval(0463, o is IEmptyGen<int>, false);
            Eval(0464, o is IEmptyGen<int>[], false);
            Eval(0465, o is INotEmptyGen<int>, false);
            Eval(0466, o is INotEmptyGen<int>[], false);
            Eval(0467, o is SimpleDelegate, false);
            Eval(0468, o is SimpleDelegate[], false);
            Eval(0469, o is GenericDelegate<int>, false);
            Eval(0470, o is GenericDelegate<int>[], false);
            Eval(0471, o is EmptyClass, false);
            Eval(0472, o is EmptyClass[], false);
            Eval(0473, o is NotEmptyClass, false);
            Eval(0474, o is NotEmptyClass[], false);
            Eval(0475, o is EmptyClassGen<int>, false);
            Eval(0476, o is EmptyClassGen<int>[], false);
            Eval(0477, o is NotEmptyClassGen<Guid>, false);
            Eval(0478, o is NotEmptyClassGen<Guid>[], false);
            Eval(0479, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0480, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0481, o is NestedClass, false);
            Eval(0482, o is NestedClass[], false);
            Eval(0483, o is NestedClassGen<Decimal>, false);
            Eval(0484, o is NestedClassGen<Decimal>[], false);
            Eval(0485, o is ImplementOneInterfaceC, false);
            Eval(0486, o is ImplementOneInterfaceC[], false);
            Eval(0487, o is ImplementTwoInterfaceC, false);
            Eval(0488, o is ImplementTwoInterfaceC[], false);
            Eval(0489, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0490, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0491, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0492, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0493, o is ImplementAllInterfaceC<int>, false);
            Eval(0494, o is ImplementAllInterfaceC<int>[], false);
            Eval(0495, o is SealedClass, false);
            Eval(0496, o is SealedClass[], false);
        }
        {
            ImplementTwoInterface? v = default(ImplementTwoInterface);
            IEmpty o = v; ;
            Eval(0497, o is ImplementOneInterface, false);
            Eval(0498, o is ImplementOneInterface[], false);
            Eval(0499, o is ImplementOneInterface?, false);
            Eval(0500, o is ImplementOneInterface?[], false);
            Eval(0501, o is ImplementTwoInterface, true);
            Eval(0502, o is ImplementTwoInterface[], false);
            Eval(0503, o is ImplementTwoInterface?, true);
            Eval(0504, o is ImplementTwoInterface?[], false);
            Eval(0505, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0506, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0507, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0508, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0509, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0510, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0511, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0512, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0513, o is ImplementAllInterface<int>, false);
            Eval(0514, o is ImplementAllInterface<int>[], false);
            Eval(0515, o is ImplementAllInterface<int>?, false);
            Eval(0516, o is ImplementAllInterface<int>?[], false);
            Eval(0517, o is char, false);
            Eval(0518, o is char[], false);
            Eval(0519, o is char?, false);
            Eval(0520, o is char?[], false);
            Eval(0521, o is bool, false);
            Eval(0522, o is bool[], false);
            Eval(0523, o is bool?, false);
            Eval(0524, o is bool?[], false);
            Eval(0525, o is byte, false);
            Eval(0526, o is byte[], false);
            Eval(0527, o is byte?, false);
            Eval(0528, o is byte?[], false);
            Eval(0529, o is sbyte, false);
            Eval(0530, o is sbyte[], false);
            Eval(0531, o is sbyte?, false);
            Eval(0532, o is sbyte?[], false);
            Eval(0533, o is short, false);
            Eval(0534, o is short[], false);
            Eval(0535, o is short?, false);
            Eval(0536, o is short?[], false);
            Eval(0537, o is ushort, false);
            Eval(0538, o is ushort[], false);
            Eval(0539, o is ushort?, false);
            Eval(0540, o is ushort?[], false);
            Eval(0541, o is int, false);
            Eval(0542, o is int[], false);
            Eval(0543, o is int?, false);
            Eval(0544, o is int?[], false);
            Eval(0545, o is uint, false);
            Eval(0546, o is uint[], false);
            Eval(0547, o is uint?, false);
            Eval(0548, o is uint?[], false);
            Eval(0549, o is long, false);
            Eval(0550, o is long[], false);
            Eval(0551, o is long?, false);
            Eval(0552, o is long?[], false);
            Eval(0553, o is ulong, false);
            Eval(0554, o is ulong[], false);
            Eval(0555, o is ulong?, false);
            Eval(0556, o is ulong?[], false);
            Eval(0557, o is float, false);
            Eval(0558, o is float[], false);
            Eval(0559, o is float?, false);
            Eval(0560, o is float?[], false);
            Eval(0561, o is double, false);
            Eval(0562, o is double[], false);
            Eval(0563, o is double?, false);
            Eval(0564, o is double?[], false);
            Eval(0565, o is decimal, false);
            Eval(0566, o is decimal[], false);
            Eval(0567, o is decimal?, false);
            Eval(0568, o is decimal?[], false);
            Eval(0569, o is object, true);
            Eval(0570, o is object[], false);
            Eval(0571, o is string, false);
            Eval(0572, o is string[], false);
            Eval(0573, o is ValueType, true);
            Eval(0574, o is ValueType[], false);
            Eval(0575, o is Array, false);
            Eval(0576, o is Array[], false);
            Eval(0577, o is Enum, false);
            Eval(0578, o is Enum[], false);
            Eval(0579, o is Delegate, false);
            Eval(0580, o is Delegate[], false);
            Eval(0581, o is MulticastDelegate, false);
            Eval(0582, o is MulticastDelegate[], false);
            Eval(0583, o is IEmpty, true);
            Eval(0584, o is IEmpty[], false);
            Eval(0585, o is INotEmpty, true);
            Eval(0586, o is INotEmpty[], false);
            Eval(0587, o is IEmptyGen<int>, false);
            Eval(0588, o is IEmptyGen<int>[], false);
            Eval(0589, o is INotEmptyGen<int>, false);
            Eval(0590, o is INotEmptyGen<int>[], false);
            Eval(0591, o is SimpleDelegate, false);
            Eval(0592, o is SimpleDelegate[], false);
            Eval(0593, o is GenericDelegate<int>, false);
            Eval(0594, o is GenericDelegate<int>[], false);
            Eval(0595, o is EmptyClass, false);
            Eval(0596, o is EmptyClass[], false);
            Eval(0597, o is NotEmptyClass, false);
            Eval(0598, o is NotEmptyClass[], false);
            Eval(0599, o is EmptyClassGen<int>, false);
            Eval(0600, o is EmptyClassGen<int>[], false);
            Eval(0601, o is NotEmptyClassGen<Guid>, false);
            Eval(0602, o is NotEmptyClassGen<Guid>[], false);
            Eval(0603, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0604, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0605, o is NestedClass, false);
            Eval(0606, o is NestedClass[], false);
            Eval(0607, o is NestedClassGen<Decimal>, false);
            Eval(0608, o is NestedClassGen<Decimal>[], false);
            Eval(0609, o is ImplementOneInterfaceC, false);
            Eval(0610, o is ImplementOneInterfaceC[], false);
            Eval(0611, o is ImplementTwoInterfaceC, false);
            Eval(0612, o is ImplementTwoInterfaceC[], false);
            Eval(0613, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0614, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0615, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0616, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0617, o is ImplementAllInterfaceC<int>, false);
            Eval(0618, o is ImplementAllInterfaceC<int>[], false);
            Eval(0619, o is SealedClass, false);
            Eval(0620, o is SealedClass[], false);
        }
        {
            ImplementTwoInterface? v = default(ImplementTwoInterface?);
            IEmpty o = v; ;
            Eval(0621, o is ImplementOneInterface, false);
            Eval(0622, o is ImplementOneInterface[], false);
            Eval(0623, o is ImplementOneInterface?, false);
            Eval(0624, o is ImplementOneInterface?[], false);
            Eval(0625, o is ImplementTwoInterface, false);
            Eval(0626, o is ImplementTwoInterface[], false);
            Eval(0627, o is ImplementTwoInterface?, false);
            Eval(0628, o is ImplementTwoInterface?[], false);
            Eval(0629, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(0630, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0631, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(0632, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0633, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0634, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0635, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0636, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0637, o is ImplementAllInterface<int>, false);
            Eval(0638, o is ImplementAllInterface<int>[], false);
            Eval(0639, o is ImplementAllInterface<int>?, false);
            Eval(0640, o is ImplementAllInterface<int>?[], false);
            Eval(0641, o is char, false);
            Eval(0642, o is char[], false);
            Eval(0643, o is char?, false);
            Eval(0644, o is char?[], false);
            Eval(0645, o is bool, false);
            Eval(0646, o is bool[], false);
            Eval(0647, o is bool?, false);
            Eval(0648, o is bool?[], false);
            Eval(0649, o is byte, false);
            Eval(0650, o is byte[], false);
            Eval(0651, o is byte?, false);
            Eval(0652, o is byte?[], false);
            Eval(0653, o is sbyte, false);
            Eval(0654, o is sbyte[], false);
            Eval(0655, o is sbyte?, false);
            Eval(0656, o is sbyte?[], false);
            Eval(0657, o is short, false);
            Eval(0658, o is short[], false);
            Eval(0659, o is short?, false);
            Eval(0660, o is short?[], false);
            Eval(0661, o is ushort, false);
            Eval(0662, o is ushort[], false);
            Eval(0663, o is ushort?, false);
            Eval(0664, o is ushort?[], false);
            Eval(0665, o is int, false);
            Eval(0666, o is int[], false);
            Eval(0667, o is int?, false);
            Eval(0668, o is int?[], false);
            Eval(0669, o is uint, false);
            Eval(0670, o is uint[], false);
            Eval(0671, o is uint?, false);
            Eval(0672, o is uint?[], false);
            Eval(0673, o is long, false);
            Eval(0674, o is long[], false);
            Eval(0675, o is long?, false);
            Eval(0676, o is long?[], false);
            Eval(0677, o is ulong, false);
            Eval(0678, o is ulong[], false);
            Eval(0679, o is ulong?, false);
            Eval(0680, o is ulong?[], false);
            Eval(0681, o is float, false);
            Eval(0682, o is float[], false);
            Eval(0683, o is float?, false);
            Eval(0684, o is float?[], false);
            Eval(0685, o is double, false);
            Eval(0686, o is double[], false);
            Eval(0687, o is double?, false);
            Eval(0688, o is double?[], false);
            Eval(0689, o is decimal, false);
            Eval(0690, o is decimal[], false);
            Eval(0691, o is decimal?, false);
            Eval(0692, o is decimal?[], false);
            Eval(0693, o is object, false);
            Eval(0694, o is object[], false);
            Eval(0695, o is string, false);
            Eval(0696, o is string[], false);
            Eval(0697, o is ValueType, false);
            Eval(0698, o is ValueType[], false);
            Eval(0699, o is Array, false);
            Eval(0700, o is Array[], false);
            Eval(0701, o is Enum, false);
            Eval(0702, o is Enum[], false);
            Eval(0703, o is Delegate, false);
            Eval(0704, o is Delegate[], false);
            Eval(0705, o is MulticastDelegate, false);
            Eval(0706, o is MulticastDelegate[], false);
            Eval(0707, o is IEmpty, false);
            Eval(0708, o is IEmpty[], false);
            Eval(0709, o is INotEmpty, false);
            Eval(0710, o is INotEmpty[], false);
            Eval(0711, o is IEmptyGen<int>, false);
            Eval(0712, o is IEmptyGen<int>[], false);
            Eval(0713, o is INotEmptyGen<int>, false);
            Eval(0714, o is INotEmptyGen<int>[], false);
            Eval(0715, o is SimpleDelegate, false);
            Eval(0716, o is SimpleDelegate[], false);
            Eval(0717, o is GenericDelegate<int>, false);
            Eval(0718, o is GenericDelegate<int>[], false);
            Eval(0719, o is EmptyClass, false);
            Eval(0720, o is EmptyClass[], false);
            Eval(0721, o is NotEmptyClass, false);
            Eval(0722, o is NotEmptyClass[], false);
            Eval(0723, o is EmptyClassGen<int>, false);
            Eval(0724, o is EmptyClassGen<int>[], false);
            Eval(0725, o is NotEmptyClassGen<Guid>, false);
            Eval(0726, o is NotEmptyClassGen<Guid>[], false);
            Eval(0727, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0728, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0729, o is NestedClass, false);
            Eval(0730, o is NestedClass[], false);
            Eval(0731, o is NestedClassGen<Decimal>, false);
            Eval(0732, o is NestedClassGen<Decimal>[], false);
            Eval(0733, o is ImplementOneInterfaceC, false);
            Eval(0734, o is ImplementOneInterfaceC[], false);
            Eval(0735, o is ImplementTwoInterfaceC, false);
            Eval(0736, o is ImplementTwoInterfaceC[], false);
            Eval(0737, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0738, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0739, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0740, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0741, o is ImplementAllInterfaceC<int>, false);
            Eval(0742, o is ImplementAllInterfaceC<int>[], false);
            Eval(0743, o is SealedClass, false);
            Eval(0744, o is SealedClass[], false);
        }
    }  // end of test case 0002
    private static void TestCase0003()
    {
        {
            ImplementOneInterfaceGen<EmptyStructGen<int>> v = default(ImplementOneInterfaceGen<EmptyStructGen<int>>);
            IEmptyGen<EmptyStructGen<int>> o = v; ;
            Eval(0745, o is ImplementOneInterface, false);
            Eval(0746, o is ImplementOneInterface[], false);
            Eval(0747, o is ImplementOneInterface?, false);
            Eval(0748, o is ImplementOneInterface?[], false);
            Eval(0749, o is ImplementTwoInterface, false);
            Eval(0750, o is ImplementTwoInterface[], false);
            Eval(0751, o is ImplementTwoInterface?, false);
            Eval(0752, o is ImplementTwoInterface?[], false);
            Eval(0753, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, true);
            Eval(0754, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0755, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, true);
            Eval(0756, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0757, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0758, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0759, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0760, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0761, o is ImplementAllInterface<int>, false);
            Eval(0762, o is ImplementAllInterface<int>[], false);
            Eval(0763, o is ImplementAllInterface<int>?, false);
            Eval(0764, o is ImplementAllInterface<int>?[], false);
            Eval(0765, o is char, false);
            Eval(0766, o is char[], false);
            Eval(0767, o is char?, false);
            Eval(0768, o is char?[], false);
            Eval(0769, o is bool, false);
            Eval(0770, o is bool[], false);
            Eval(0771, o is bool?, false);
            Eval(0772, o is bool?[], false);
            Eval(0773, o is byte, false);
            Eval(0774, o is byte[], false);
            Eval(0775, o is byte?, false);
            Eval(0776, o is byte?[], false);
            Eval(0777, o is sbyte, false);
            Eval(0778, o is sbyte[], false);
            Eval(0779, o is sbyte?, false);
            Eval(0780, o is sbyte?[], false);
            Eval(0781, o is short, false);
            Eval(0782, o is short[], false);
            Eval(0783, o is short?, false);
            Eval(0784, o is short?[], false);
            Eval(0785, o is ushort, false);
            Eval(0786, o is ushort[], false);
            Eval(0787, o is ushort?, false);
            Eval(0788, o is ushort?[], false);
            Eval(0789, o is int, false);
            Eval(0790, o is int[], false);
            Eval(0791, o is int?, false);
            Eval(0792, o is int?[], false);
            Eval(0793, o is uint, false);
            Eval(0794, o is uint[], false);
            Eval(0795, o is uint?, false);
            Eval(0796, o is uint?[], false);
            Eval(0797, o is long, false);
            Eval(0798, o is long[], false);
            Eval(0799, o is long?, false);
            Eval(0800, o is long?[], false);
            Eval(0801, o is ulong, false);
            Eval(0802, o is ulong[], false);
            Eval(0803, o is ulong?, false);
            Eval(0804, o is ulong?[], false);
            Eval(0805, o is float, false);
            Eval(0806, o is float[], false);
            Eval(0807, o is float?, false);
            Eval(0808, o is float?[], false);
            Eval(0809, o is double, false);
            Eval(0810, o is double[], false);
            Eval(0811, o is double?, false);
            Eval(0812, o is double?[], false);
            Eval(0813, o is decimal, false);
            Eval(0814, o is decimal[], false);
            Eval(0815, o is decimal?, false);
            Eval(0816, o is decimal?[], false);
            Eval(0817, o is object, true);
            Eval(0818, o is object[], false);
            Eval(0819, o is string, false);
            Eval(0820, o is string[], false);
            Eval(0821, o is ValueType, true);
            Eval(0822, o is ValueType[], false);
            Eval(0823, o is Array, false);
            Eval(0824, o is Array[], false);
            Eval(0825, o is Enum, false);
            Eval(0826, o is Enum[], false);
            Eval(0827, o is Delegate, false);
            Eval(0828, o is Delegate[], false);
            Eval(0829, o is MulticastDelegate, false);
            Eval(0830, o is MulticastDelegate[], false);
            Eval(0831, o is IEmpty, false);
            Eval(0832, o is IEmpty[], false);
            Eval(0833, o is INotEmpty, false);
            Eval(0834, o is INotEmpty[], false);
            Eval(0835, o is IEmptyGen<int>, false);
            Eval(0836, o is IEmptyGen<int>[], false);
            Eval(0837, o is INotEmptyGen<int>, false);
            Eval(0838, o is INotEmptyGen<int>[], false);
            Eval(0839, o is SimpleDelegate, false);
            Eval(0840, o is SimpleDelegate[], false);
            Eval(0841, o is GenericDelegate<int>, false);
            Eval(0842, o is GenericDelegate<int>[], false);
            Eval(0843, o is EmptyClass, false);
            Eval(0844, o is EmptyClass[], false);
            Eval(0845, o is NotEmptyClass, false);
            Eval(0846, o is NotEmptyClass[], false);
            Eval(0847, o is EmptyClassGen<int>, false);
            Eval(0848, o is EmptyClassGen<int>[], false);
            Eval(0849, o is NotEmptyClassGen<Guid>, false);
            Eval(0850, o is NotEmptyClassGen<Guid>[], false);
            Eval(0851, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0852, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0853, o is NestedClass, false);
            Eval(0854, o is NestedClass[], false);
            Eval(0855, o is NestedClassGen<Decimal>, false);
            Eval(0856, o is NestedClassGen<Decimal>[], false);
            Eval(0857, o is ImplementOneInterfaceC, false);
            Eval(0858, o is ImplementOneInterfaceC[], false);
            Eval(0859, o is ImplementTwoInterfaceC, false);
            Eval(0860, o is ImplementTwoInterfaceC[], false);
            Eval(0861, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0862, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0863, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0864, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0865, o is ImplementAllInterfaceC<int>, false);
            Eval(0866, o is ImplementAllInterfaceC<int>[], false);
            Eval(0867, o is SealedClass, false);
            Eval(0868, o is SealedClass[], false);
        }
        {
            ImplementOneInterfaceGen<EmptyStructGen<int>>? v = default(ImplementOneInterfaceGen<EmptyStructGen<int>>);
            IEmptyGen<EmptyStructGen<int>> o = v; ;
            Eval(0869, o is ImplementOneInterface, false);
            Eval(0870, o is ImplementOneInterface[], false);
            Eval(0871, o is ImplementOneInterface?, false);
            Eval(0872, o is ImplementOneInterface?[], false);
            Eval(0873, o is ImplementTwoInterface, false);
            Eval(0874, o is ImplementTwoInterface[], false);
            Eval(0875, o is ImplementTwoInterface?, false);
            Eval(0876, o is ImplementTwoInterface?[], false);
            Eval(0877, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, true);
            Eval(0878, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(0879, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, true);
            Eval(0880, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(0881, o is ImplementTwoInterfaceGen<int>, false);
            Eval(0882, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(0883, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(0884, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(0885, o is ImplementAllInterface<int>, false);
            Eval(0886, o is ImplementAllInterface<int>[], false);
            Eval(0887, o is ImplementAllInterface<int>?, false);
            Eval(0888, o is ImplementAllInterface<int>?[], false);
            Eval(0889, o is char, false);
            Eval(0890, o is char[], false);
            Eval(0891, o is char?, false);
            Eval(0892, o is char?[], false);
            Eval(0893, o is bool, false);
            Eval(0894, o is bool[], false);
            Eval(0895, o is bool?, false);
            Eval(0896, o is bool?[], false);
            Eval(0897, o is byte, false);
            Eval(0898, o is byte[], false);
            Eval(0899, o is byte?, false);
            Eval(0900, o is byte?[], false);
            Eval(0901, o is sbyte, false);
            Eval(0902, o is sbyte[], false);
            Eval(0903, o is sbyte?, false);
            Eval(0904, o is sbyte?[], false);
            Eval(0905, o is short, false);
            Eval(0906, o is short[], false);
            Eval(0907, o is short?, false);
            Eval(0908, o is short?[], false);
            Eval(0909, o is ushort, false);
            Eval(0910, o is ushort[], false);
            Eval(0911, o is ushort?, false);
            Eval(0912, o is ushort?[], false);
            Eval(0913, o is int, false);
            Eval(0914, o is int[], false);
            Eval(0915, o is int?, false);
            Eval(0916, o is int?[], false);
            Eval(0917, o is uint, false);
            Eval(0918, o is uint[], false);
            Eval(0919, o is uint?, false);
            Eval(0920, o is uint?[], false);
            Eval(0921, o is long, false);
            Eval(0922, o is long[], false);
            Eval(0923, o is long?, false);
            Eval(0924, o is long?[], false);
            Eval(0925, o is ulong, false);
            Eval(0926, o is ulong[], false);
            Eval(0927, o is ulong?, false);
            Eval(0928, o is ulong?[], false);
            Eval(0929, o is float, false);
            Eval(0930, o is float[], false);
            Eval(0931, o is float?, false);
            Eval(0932, o is float?[], false);
            Eval(0933, o is double, false);
            Eval(0934, o is double[], false);
            Eval(0935, o is double?, false);
            Eval(0936, o is double?[], false);
            Eval(0937, o is decimal, false);
            Eval(0938, o is decimal[], false);
            Eval(0939, o is decimal?, false);
            Eval(0940, o is decimal?[], false);
            Eval(0941, o is object, true);
            Eval(0942, o is object[], false);
            Eval(0943, o is string, false);
            Eval(0944, o is string[], false);
            Eval(0945, o is ValueType, true);
            Eval(0946, o is ValueType[], false);
            Eval(0947, o is Array, false);
            Eval(0948, o is Array[], false);
            Eval(0949, o is Enum, false);
            Eval(0950, o is Enum[], false);
            Eval(0951, o is Delegate, false);
            Eval(0952, o is Delegate[], false);
            Eval(0953, o is MulticastDelegate, false);
            Eval(0954, o is MulticastDelegate[], false);
            Eval(0955, o is IEmpty, false);
            Eval(0956, o is IEmpty[], false);
            Eval(0957, o is INotEmpty, false);
            Eval(0958, o is INotEmpty[], false);
            Eval(0959, o is IEmptyGen<int>, false);
            Eval(0960, o is IEmptyGen<int>[], false);
            Eval(0961, o is INotEmptyGen<int>, false);
            Eval(0962, o is INotEmptyGen<int>[], false);
            Eval(0963, o is SimpleDelegate, false);
            Eval(0964, o is SimpleDelegate[], false);
            Eval(0965, o is GenericDelegate<int>, false);
            Eval(0966, o is GenericDelegate<int>[], false);
            Eval(0967, o is EmptyClass, false);
            Eval(0968, o is EmptyClass[], false);
            Eval(0969, o is NotEmptyClass, false);
            Eval(0970, o is NotEmptyClass[], false);
            Eval(0971, o is EmptyClassGen<int>, false);
            Eval(0972, o is EmptyClassGen<int>[], false);
            Eval(0973, o is NotEmptyClassGen<Guid>, false);
            Eval(0974, o is NotEmptyClassGen<Guid>[], false);
            Eval(0975, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(0976, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(0977, o is NestedClass, false);
            Eval(0978, o is NestedClass[], false);
            Eval(0979, o is NestedClassGen<Decimal>, false);
            Eval(0980, o is NestedClassGen<Decimal>[], false);
            Eval(0981, o is ImplementOneInterfaceC, false);
            Eval(0982, o is ImplementOneInterfaceC[], false);
            Eval(0983, o is ImplementTwoInterfaceC, false);
            Eval(0984, o is ImplementTwoInterfaceC[], false);
            Eval(0985, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(0986, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(0987, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(0988, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(0989, o is ImplementAllInterfaceC<int>, false);
            Eval(0990, o is ImplementAllInterfaceC<int>[], false);
            Eval(0991, o is SealedClass, false);
            Eval(0992, o is SealedClass[], false);
        }
        {
            ImplementOneInterfaceGen<EmptyStructGen<int>>? v = default(ImplementOneInterfaceGen<EmptyStructGen<int>>?);
            IEmptyGen<EmptyStructGen<int>> o = v; ;
            Eval(0993, o is ImplementOneInterface, false);
            Eval(0994, o is ImplementOneInterface[], false);
            Eval(0995, o is ImplementOneInterface?, false);
            Eval(0996, o is ImplementOneInterface?[], false);
            Eval(0997, o is ImplementTwoInterface, false);
            Eval(0998, o is ImplementTwoInterface[], false);
            Eval(0999, o is ImplementTwoInterface?, false);
            Eval(1000, o is ImplementTwoInterface?[], false);
            Eval(1001, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1002, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1003, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1004, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1005, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1006, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1007, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1008, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1009, o is ImplementAllInterface<int>, false);
            Eval(1010, o is ImplementAllInterface<int>[], false);
            Eval(1011, o is ImplementAllInterface<int>?, false);
            Eval(1012, o is ImplementAllInterface<int>?[], false);
            Eval(1013, o is char, false);
            Eval(1014, o is char[], false);
            Eval(1015, o is char?, false);
            Eval(1016, o is char?[], false);
            Eval(1017, o is bool, false);
            Eval(1018, o is bool[], false);
            Eval(1019, o is bool?, false);
            Eval(1020, o is bool?[], false);
            Eval(1021, o is byte, false);
            Eval(1022, o is byte[], false);
            Eval(1023, o is byte?, false);
            Eval(1024, o is byte?[], false);
            Eval(1025, o is sbyte, false);
            Eval(1026, o is sbyte[], false);
            Eval(1027, o is sbyte?, false);
            Eval(1028, o is sbyte?[], false);
            Eval(1029, o is short, false);
            Eval(1030, o is short[], false);
            Eval(1031, o is short?, false);
            Eval(1032, o is short?[], false);
            Eval(1033, o is ushort, false);
            Eval(1034, o is ushort[], false);
            Eval(1035, o is ushort?, false);
            Eval(1036, o is ushort?[], false);
            Eval(1037, o is int, false);
            Eval(1038, o is int[], false);
            Eval(1039, o is int?, false);
            Eval(1040, o is int?[], false);
            Eval(1041, o is uint, false);
            Eval(1042, o is uint[], false);
            Eval(1043, o is uint?, false);
            Eval(1044, o is uint?[], false);
            Eval(1045, o is long, false);
            Eval(1046, o is long[], false);
            Eval(1047, o is long?, false);
            Eval(1048, o is long?[], false);
            Eval(1049, o is ulong, false);
            Eval(1050, o is ulong[], false);
            Eval(1051, o is ulong?, false);
            Eval(1052, o is ulong?[], false);
            Eval(1053, o is float, false);
            Eval(1054, o is float[], false);
            Eval(1055, o is float?, false);
            Eval(1056, o is float?[], false);
            Eval(1057, o is double, false);
            Eval(1058, o is double[], false);
            Eval(1059, o is double?, false);
            Eval(1060, o is double?[], false);
            Eval(1061, o is decimal, false);
            Eval(1062, o is decimal[], false);
            Eval(1063, o is decimal?, false);
            Eval(1064, o is decimal?[], false);
            Eval(1065, o is object, false);
            Eval(1066, o is object[], false);
            Eval(1067, o is string, false);
            Eval(1068, o is string[], false);
            Eval(1069, o is ValueType, false);
            Eval(1070, o is ValueType[], false);
            Eval(1071, o is Array, false);
            Eval(1072, o is Array[], false);
            Eval(1073, o is Enum, false);
            Eval(1074, o is Enum[], false);
            Eval(1075, o is Delegate, false);
            Eval(1076, o is Delegate[], false);
            Eval(1077, o is MulticastDelegate, false);
            Eval(1078, o is MulticastDelegate[], false);
            Eval(1079, o is IEmpty, false);
            Eval(1080, o is IEmpty[], false);
            Eval(1081, o is INotEmpty, false);
            Eval(1082, o is INotEmpty[], false);
            Eval(1083, o is IEmptyGen<int>, false);
            Eval(1084, o is IEmptyGen<int>[], false);
            Eval(1085, o is INotEmptyGen<int>, false);
            Eval(1086, o is INotEmptyGen<int>[], false);
            Eval(1087, o is SimpleDelegate, false);
            Eval(1088, o is SimpleDelegate[], false);
            Eval(1089, o is GenericDelegate<int>, false);
            Eval(1090, o is GenericDelegate<int>[], false);
            Eval(1091, o is EmptyClass, false);
            Eval(1092, o is EmptyClass[], false);
            Eval(1093, o is NotEmptyClass, false);
            Eval(1094, o is NotEmptyClass[], false);
            Eval(1095, o is EmptyClassGen<int>, false);
            Eval(1096, o is EmptyClassGen<int>[], false);
            Eval(1097, o is NotEmptyClassGen<Guid>, false);
            Eval(1098, o is NotEmptyClassGen<Guid>[], false);
            Eval(1099, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1100, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1101, o is NestedClass, false);
            Eval(1102, o is NestedClass[], false);
            Eval(1103, o is NestedClassGen<Decimal>, false);
            Eval(1104, o is NestedClassGen<Decimal>[], false);
            Eval(1105, o is ImplementOneInterfaceC, false);
            Eval(1106, o is ImplementOneInterfaceC[], false);
            Eval(1107, o is ImplementTwoInterfaceC, false);
            Eval(1108, o is ImplementTwoInterfaceC[], false);
            Eval(1109, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1110, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1111, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1112, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1113, o is ImplementAllInterfaceC<int>, false);
            Eval(1114, o is ImplementAllInterfaceC<int>[], false);
            Eval(1115, o is SealedClass, false);
            Eval(1116, o is SealedClass[], false);
        }
    }  // end of test case 0003
    private static void TestCase0004()
    {
        {
            ImplementTwoInterfaceGen<int> v = default(ImplementTwoInterfaceGen<int>);
            IEmptyGen<int> o = v; ;
            Eval(1117, o is ImplementOneInterface, false);
            Eval(1118, o is ImplementOneInterface[], false);
            Eval(1119, o is ImplementOneInterface?, false);
            Eval(1120, o is ImplementOneInterface?[], false);
            Eval(1121, o is ImplementTwoInterface, false);
            Eval(1122, o is ImplementTwoInterface[], false);
            Eval(1123, o is ImplementTwoInterface?, false);
            Eval(1124, o is ImplementTwoInterface?[], false);
            Eval(1125, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1126, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1127, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1128, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1129, o is ImplementTwoInterfaceGen<int>, true);
            Eval(1130, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1131, o is ImplementTwoInterfaceGen<int>?, true);
            Eval(1132, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1133, o is ImplementAllInterface<int>, false);
            Eval(1134, o is ImplementAllInterface<int>[], false);
            Eval(1135, o is ImplementAllInterface<int>?, false);
            Eval(1136, o is ImplementAllInterface<int>?[], false);
            Eval(1137, o is char, false);
            Eval(1138, o is char[], false);
            Eval(1139, o is char?, false);
            Eval(1140, o is char?[], false);
            Eval(1141, o is bool, false);
            Eval(1142, o is bool[], false);
            Eval(1143, o is bool?, false);
            Eval(1144, o is bool?[], false);
            Eval(1145, o is byte, false);
            Eval(1146, o is byte[], false);
            Eval(1147, o is byte?, false);
            Eval(1148, o is byte?[], false);
            Eval(1149, o is sbyte, false);
            Eval(1150, o is sbyte[], false);
            Eval(1151, o is sbyte?, false);
            Eval(1152, o is sbyte?[], false);
            Eval(1153, o is short, false);
            Eval(1154, o is short[], false);
            Eval(1155, o is short?, false);
            Eval(1156, o is short?[], false);
            Eval(1157, o is ushort, false);
            Eval(1158, o is ushort[], false);
            Eval(1159, o is ushort?, false);
            Eval(1160, o is ushort?[], false);
            Eval(1161, o is int, false);
            Eval(1162, o is int[], false);
            Eval(1163, o is int?, false);
            Eval(1164, o is int?[], false);
            Eval(1165, o is uint, false);
            Eval(1166, o is uint[], false);
            Eval(1167, o is uint?, false);
            Eval(1168, o is uint?[], false);
            Eval(1169, o is long, false);
            Eval(1170, o is long[], false);
            Eval(1171, o is long?, false);
            Eval(1172, o is long?[], false);
            Eval(1173, o is ulong, false);
            Eval(1174, o is ulong[], false);
            Eval(1175, o is ulong?, false);
            Eval(1176, o is ulong?[], false);
            Eval(1177, o is float, false);
            Eval(1178, o is float[], false);
            Eval(1179, o is float?, false);
            Eval(1180, o is float?[], false);
            Eval(1181, o is double, false);
            Eval(1182, o is double[], false);
            Eval(1183, o is double?, false);
            Eval(1184, o is double?[], false);
            Eval(1185, o is decimal, false);
            Eval(1186, o is decimal[], false);
            Eval(1187, o is decimal?, false);
            Eval(1188, o is decimal?[], false);
            Eval(1189, o is object, true);
            Eval(1190, o is object[], false);
            Eval(1191, o is string, false);
            Eval(1192, o is string[], false);
            Eval(1193, o is ValueType, true);
            Eval(1194, o is ValueType[], false);
            Eval(1195, o is Array, false);
            Eval(1196, o is Array[], false);
            Eval(1197, o is Enum, false);
            Eval(1198, o is Enum[], false);
            Eval(1199, o is Delegate, false);
            Eval(1200, o is Delegate[], false);
            Eval(1201, o is MulticastDelegate, false);
            Eval(1202, o is MulticastDelegate[], false);
            Eval(1203, o is IEmpty, false);
            Eval(1204, o is IEmpty[], false);
            Eval(1205, o is INotEmpty, false);
            Eval(1206, o is INotEmpty[], false);
            Eval(1207, o is IEmptyGen<int>, true);
            Eval(1208, o is IEmptyGen<int>[], false);
            Eval(1209, o is INotEmptyGen<int>, true);
            Eval(1210, o is INotEmptyGen<int>[], false);
            Eval(1211, o is SimpleDelegate, false);
            Eval(1212, o is SimpleDelegate[], false);
            Eval(1213, o is GenericDelegate<int>, false);
            Eval(1214, o is GenericDelegate<int>[], false);
            Eval(1215, o is EmptyClass, false);
            Eval(1216, o is EmptyClass[], false);
            Eval(1217, o is NotEmptyClass, false);
            Eval(1218, o is NotEmptyClass[], false);
            Eval(1219, o is EmptyClassGen<int>, false);
            Eval(1220, o is EmptyClassGen<int>[], false);
            Eval(1221, o is NotEmptyClassGen<Guid>, false);
            Eval(1222, o is NotEmptyClassGen<Guid>[], false);
            Eval(1223, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1224, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1225, o is NestedClass, false);
            Eval(1226, o is NestedClass[], false);
            Eval(1227, o is NestedClassGen<Decimal>, false);
            Eval(1228, o is NestedClassGen<Decimal>[], false);
            Eval(1229, o is ImplementOneInterfaceC, false);
            Eval(1230, o is ImplementOneInterfaceC[], false);
            Eval(1231, o is ImplementTwoInterfaceC, false);
            Eval(1232, o is ImplementTwoInterfaceC[], false);
            Eval(1233, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1234, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1235, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1236, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1237, o is ImplementAllInterfaceC<int>, false);
            Eval(1238, o is ImplementAllInterfaceC<int>[], false);
            Eval(1239, o is SealedClass, false);
            Eval(1240, o is SealedClass[], false);
        }
        {
            ImplementTwoInterfaceGen<int>? v = default(ImplementTwoInterfaceGen<int>);
            IEmptyGen<int> o = v; ;
            Eval(1241, o is ImplementOneInterface, false);
            Eval(1242, o is ImplementOneInterface[], false);
            Eval(1243, o is ImplementOneInterface?, false);
            Eval(1244, o is ImplementOneInterface?[], false);
            Eval(1245, o is ImplementTwoInterface, false);
            Eval(1246, o is ImplementTwoInterface[], false);
            Eval(1247, o is ImplementTwoInterface?, false);
            Eval(1248, o is ImplementTwoInterface?[], false);
            Eval(1249, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1250, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1251, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1252, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1253, o is ImplementTwoInterfaceGen<int>, true);
            Eval(1254, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1255, o is ImplementTwoInterfaceGen<int>?, true);
            Eval(1256, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1257, o is ImplementAllInterface<int>, false);
            Eval(1258, o is ImplementAllInterface<int>[], false);
            Eval(1259, o is ImplementAllInterface<int>?, false);
            Eval(1260, o is ImplementAllInterface<int>?[], false);
            Eval(1261, o is char, false);
            Eval(1262, o is char[], false);
            Eval(1263, o is char?, false);
            Eval(1264, o is char?[], false);
            Eval(1265, o is bool, false);
            Eval(1266, o is bool[], false);
            Eval(1267, o is bool?, false);
            Eval(1268, o is bool?[], false);
            Eval(1269, o is byte, false);
            Eval(1270, o is byte[], false);
            Eval(1271, o is byte?, false);
            Eval(1272, o is byte?[], false);
            Eval(1273, o is sbyte, false);
            Eval(1274, o is sbyte[], false);
            Eval(1275, o is sbyte?, false);
            Eval(1276, o is sbyte?[], false);
            Eval(1277, o is short, false);
            Eval(1278, o is short[], false);
            Eval(1279, o is short?, false);
            Eval(1280, o is short?[], false);
            Eval(1281, o is ushort, false);
            Eval(1282, o is ushort[], false);
            Eval(1283, o is ushort?, false);
            Eval(1284, o is ushort?[], false);
            Eval(1285, o is int, false);
            Eval(1286, o is int[], false);
            Eval(1287, o is int?, false);
            Eval(1288, o is int?[], false);
            Eval(1289, o is uint, false);
            Eval(1290, o is uint[], false);
            Eval(1291, o is uint?, false);
            Eval(1292, o is uint?[], false);
            Eval(1293, o is long, false);
            Eval(1294, o is long[], false);
            Eval(1295, o is long?, false);
            Eval(1296, o is long?[], false);
            Eval(1297, o is ulong, false);
            Eval(1298, o is ulong[], false);
            Eval(1299, o is ulong?, false);
            Eval(1300, o is ulong?[], false);
            Eval(1301, o is float, false);
            Eval(1302, o is float[], false);
            Eval(1303, o is float?, false);
            Eval(1304, o is float?[], false);
            Eval(1305, o is double, false);
            Eval(1306, o is double[], false);
            Eval(1307, o is double?, false);
            Eval(1308, o is double?[], false);
            Eval(1309, o is decimal, false);
            Eval(1310, o is decimal[], false);
            Eval(1311, o is decimal?, false);
            Eval(1312, o is decimal?[], false);
            Eval(1313, o is object, true);
            Eval(1314, o is object[], false);
            Eval(1315, o is string, false);
            Eval(1316, o is string[], false);
            Eval(1317, o is ValueType, true);
            Eval(1318, o is ValueType[], false);
            Eval(1319, o is Array, false);
            Eval(1320, o is Array[], false);
            Eval(1321, o is Enum, false);
            Eval(1322, o is Enum[], false);
            Eval(1323, o is Delegate, false);
            Eval(1324, o is Delegate[], false);
            Eval(1325, o is MulticastDelegate, false);
            Eval(1326, o is MulticastDelegate[], false);
            Eval(1327, o is IEmpty, false);
            Eval(1328, o is IEmpty[], false);
            Eval(1329, o is INotEmpty, false);
            Eval(1330, o is INotEmpty[], false);
            Eval(1331, o is IEmptyGen<int>, true);
            Eval(1332, o is IEmptyGen<int>[], false);
            Eval(1333, o is INotEmptyGen<int>, true);
            Eval(1334, o is INotEmptyGen<int>[], false);
            Eval(1335, o is SimpleDelegate, false);
            Eval(1336, o is SimpleDelegate[], false);
            Eval(1337, o is GenericDelegate<int>, false);
            Eval(1338, o is GenericDelegate<int>[], false);
            Eval(1339, o is EmptyClass, false);
            Eval(1340, o is EmptyClass[], false);
            Eval(1341, o is NotEmptyClass, false);
            Eval(1342, o is NotEmptyClass[], false);
            Eval(1343, o is EmptyClassGen<int>, false);
            Eval(1344, o is EmptyClassGen<int>[], false);
            Eval(1345, o is NotEmptyClassGen<Guid>, false);
            Eval(1346, o is NotEmptyClassGen<Guid>[], false);
            Eval(1347, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1348, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1349, o is NestedClass, false);
            Eval(1350, o is NestedClass[], false);
            Eval(1351, o is NestedClassGen<Decimal>, false);
            Eval(1352, o is NestedClassGen<Decimal>[], false);
            Eval(1353, o is ImplementOneInterfaceC, false);
            Eval(1354, o is ImplementOneInterfaceC[], false);
            Eval(1355, o is ImplementTwoInterfaceC, false);
            Eval(1356, o is ImplementTwoInterfaceC[], false);
            Eval(1357, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1358, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1359, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1360, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1361, o is ImplementAllInterfaceC<int>, false);
            Eval(1362, o is ImplementAllInterfaceC<int>[], false);
            Eval(1363, o is SealedClass, false);
            Eval(1364, o is SealedClass[], false);
        }
        {
            ImplementTwoInterfaceGen<int>? v = default(ImplementTwoInterfaceGen<int>?);
            IEmptyGen<int> o = v; ;
            Eval(1365, o is ImplementOneInterface, false);
            Eval(1366, o is ImplementOneInterface[], false);
            Eval(1367, o is ImplementOneInterface?, false);
            Eval(1368, o is ImplementOneInterface?[], false);
            Eval(1369, o is ImplementTwoInterface, false);
            Eval(1370, o is ImplementTwoInterface[], false);
            Eval(1371, o is ImplementTwoInterface?, false);
            Eval(1372, o is ImplementTwoInterface?[], false);
            Eval(1373, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1374, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1375, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1376, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1377, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1378, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1379, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1380, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1381, o is ImplementAllInterface<int>, false);
            Eval(1382, o is ImplementAllInterface<int>[], false);
            Eval(1383, o is ImplementAllInterface<int>?, false);
            Eval(1384, o is ImplementAllInterface<int>?[], false);
            Eval(1385, o is char, false);
            Eval(1386, o is char[], false);
            Eval(1387, o is char?, false);
            Eval(1388, o is char?[], false);
            Eval(1389, o is bool, false);
            Eval(1390, o is bool[], false);
            Eval(1391, o is bool?, false);
            Eval(1392, o is bool?[], false);
            Eval(1393, o is byte, false);
            Eval(1394, o is byte[], false);
            Eval(1395, o is byte?, false);
            Eval(1396, o is byte?[], false);
            Eval(1397, o is sbyte, false);
            Eval(1398, o is sbyte[], false);
            Eval(1399, o is sbyte?, false);
            Eval(1400, o is sbyte?[], false);
            Eval(1401, o is short, false);
            Eval(1402, o is short[], false);
            Eval(1403, o is short?, false);
            Eval(1404, o is short?[], false);
            Eval(1405, o is ushort, false);
            Eval(1406, o is ushort[], false);
            Eval(1407, o is ushort?, false);
            Eval(1408, o is ushort?[], false);
            Eval(1409, o is int, false);
            Eval(1410, o is int[], false);
            Eval(1411, o is int?, false);
            Eval(1412, o is int?[], false);
            Eval(1413, o is uint, false);
            Eval(1414, o is uint[], false);
            Eval(1415, o is uint?, false);
            Eval(1416, o is uint?[], false);
            Eval(1417, o is long, false);
            Eval(1418, o is long[], false);
            Eval(1419, o is long?, false);
            Eval(1420, o is long?[], false);
            Eval(1421, o is ulong, false);
            Eval(1422, o is ulong[], false);
            Eval(1423, o is ulong?, false);
            Eval(1424, o is ulong?[], false);
            Eval(1425, o is float, false);
            Eval(1426, o is float[], false);
            Eval(1427, o is float?, false);
            Eval(1428, o is float?[], false);
            Eval(1429, o is double, false);
            Eval(1430, o is double[], false);
            Eval(1431, o is double?, false);
            Eval(1432, o is double?[], false);
            Eval(1433, o is decimal, false);
            Eval(1434, o is decimal[], false);
            Eval(1435, o is decimal?, false);
            Eval(1436, o is decimal?[], false);
            Eval(1437, o is object, false);
            Eval(1438, o is object[], false);
            Eval(1439, o is string, false);
            Eval(1440, o is string[], false);
            Eval(1441, o is ValueType, false);
            Eval(1442, o is ValueType[], false);
            Eval(1443, o is Array, false);
            Eval(1444, o is Array[], false);
            Eval(1445, o is Enum, false);
            Eval(1446, o is Enum[], false);
            Eval(1447, o is Delegate, false);
            Eval(1448, o is Delegate[], false);
            Eval(1449, o is MulticastDelegate, false);
            Eval(1450, o is MulticastDelegate[], false);
            Eval(1451, o is IEmpty, false);
            Eval(1452, o is IEmpty[], false);
            Eval(1453, o is INotEmpty, false);
            Eval(1454, o is INotEmpty[], false);
            Eval(1455, o is IEmptyGen<int>, false);
            Eval(1456, o is IEmptyGen<int>[], false);
            Eval(1457, o is INotEmptyGen<int>, false);
            Eval(1458, o is INotEmptyGen<int>[], false);
            Eval(1459, o is SimpleDelegate, false);
            Eval(1460, o is SimpleDelegate[], false);
            Eval(1461, o is GenericDelegate<int>, false);
            Eval(1462, o is GenericDelegate<int>[], false);
            Eval(1463, o is EmptyClass, false);
            Eval(1464, o is EmptyClass[], false);
            Eval(1465, o is NotEmptyClass, false);
            Eval(1466, o is NotEmptyClass[], false);
            Eval(1467, o is EmptyClassGen<int>, false);
            Eval(1468, o is EmptyClassGen<int>[], false);
            Eval(1469, o is NotEmptyClassGen<Guid>, false);
            Eval(1470, o is NotEmptyClassGen<Guid>[], false);
            Eval(1471, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1472, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1473, o is NestedClass, false);
            Eval(1474, o is NestedClass[], false);
            Eval(1475, o is NestedClassGen<Decimal>, false);
            Eval(1476, o is NestedClassGen<Decimal>[], false);
            Eval(1477, o is ImplementOneInterfaceC, false);
            Eval(1478, o is ImplementOneInterfaceC[], false);
            Eval(1479, o is ImplementTwoInterfaceC, false);
            Eval(1480, o is ImplementTwoInterfaceC[], false);
            Eval(1481, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1482, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1483, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1484, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1485, o is ImplementAllInterfaceC<int>, false);
            Eval(1486, o is ImplementAllInterfaceC<int>[], false);
            Eval(1487, o is SealedClass, false);
            Eval(1488, o is SealedClass[], false);
        }
    }  // end of test case 0004
    private static void TestCase0005()
    {
        {
            ImplementAllInterface<int> v = default(ImplementAllInterface<int>);
            IEmpty o = v; ;
            Eval(1489, o is ImplementOneInterface, false);
            Eval(1490, o is ImplementOneInterface[], false);
            Eval(1491, o is ImplementOneInterface?, false);
            Eval(1492, o is ImplementOneInterface?[], false);
            Eval(1493, o is ImplementTwoInterface, false);
            Eval(1494, o is ImplementTwoInterface[], false);
            Eval(1495, o is ImplementTwoInterface?, false);
            Eval(1496, o is ImplementTwoInterface?[], false);
            Eval(1497, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1498, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1499, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1500, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1501, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1502, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1503, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1504, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1505, o is ImplementAllInterface<int>, true);
            Eval(1506, o is ImplementAllInterface<int>[], false);
            Eval(1507, o is ImplementAllInterface<int>?, true);
            Eval(1508, o is ImplementAllInterface<int>?[], false);
            Eval(1509, o is char, false);
            Eval(1510, o is char[], false);
            Eval(1511, o is char?, false);
            Eval(1512, o is char?[], false);
            Eval(1513, o is bool, false);
            Eval(1514, o is bool[], false);
            Eval(1515, o is bool?, false);
            Eval(1516, o is bool?[], false);
            Eval(1517, o is byte, false);
            Eval(1518, o is byte[], false);
            Eval(1519, o is byte?, false);
            Eval(1520, o is byte?[], false);
            Eval(1521, o is sbyte, false);
            Eval(1522, o is sbyte[], false);
            Eval(1523, o is sbyte?, false);
            Eval(1524, o is sbyte?[], false);
            Eval(1525, o is short, false);
            Eval(1526, o is short[], false);
            Eval(1527, o is short?, false);
            Eval(1528, o is short?[], false);
            Eval(1529, o is ushort, false);
            Eval(1530, o is ushort[], false);
            Eval(1531, o is ushort?, false);
            Eval(1532, o is ushort?[], false);
            Eval(1533, o is int, false);
            Eval(1534, o is int[], false);
            Eval(1535, o is int?, false);
            Eval(1536, o is int?[], false);
            Eval(1537, o is uint, false);
            Eval(1538, o is uint[], false);
            Eval(1539, o is uint?, false);
            Eval(1540, o is uint?[], false);
            Eval(1541, o is long, false);
            Eval(1542, o is long[], false);
            Eval(1543, o is long?, false);
            Eval(1544, o is long?[], false);
            Eval(1545, o is ulong, false);
            Eval(1546, o is ulong[], false);
            Eval(1547, o is ulong?, false);
            Eval(1548, o is ulong?[], false);
            Eval(1549, o is float, false);
            Eval(1550, o is float[], false);
            Eval(1551, o is float?, false);
            Eval(1552, o is float?[], false);
            Eval(1553, o is double, false);
            Eval(1554, o is double[], false);
            Eval(1555, o is double?, false);
            Eval(1556, o is double?[], false);
            Eval(1557, o is decimal, false);
            Eval(1558, o is decimal[], false);
            Eval(1559, o is decimal?, false);
            Eval(1560, o is decimal?[], false);
            Eval(1561, o is object, true);
            Eval(1562, o is object[], false);
            Eval(1563, o is string, false);
            Eval(1564, o is string[], false);
            Eval(1565, o is ValueType, true);
            Eval(1566, o is ValueType[], false);
            Eval(1567, o is Array, false);
            Eval(1568, o is Array[], false);
            Eval(1569, o is Enum, false);
            Eval(1570, o is Enum[], false);
            Eval(1571, o is Delegate, false);
            Eval(1572, o is Delegate[], false);
            Eval(1573, o is MulticastDelegate, false);
            Eval(1574, o is MulticastDelegate[], false);
            Eval(1575, o is IEmpty, true);
            Eval(1576, o is IEmpty[], false);
            Eval(1577, o is INotEmpty, true);
            Eval(1578, o is INotEmpty[], false);
            Eval(1579, o is IEmptyGen<int>, true);
            Eval(1580, o is IEmptyGen<int>[], false);
            Eval(1581, o is INotEmptyGen<int>, true);
            Eval(1582, o is INotEmptyGen<int>[], false);
            Eval(1583, o is SimpleDelegate, false);
            Eval(1584, o is SimpleDelegate[], false);
            Eval(1585, o is GenericDelegate<int>, false);
            Eval(1586, o is GenericDelegate<int>[], false);
            Eval(1587, o is EmptyClass, false);
            Eval(1588, o is EmptyClass[], false);
            Eval(1589, o is NotEmptyClass, false);
            Eval(1590, o is NotEmptyClass[], false);
            Eval(1591, o is EmptyClassGen<int>, false);
            Eval(1592, o is EmptyClassGen<int>[], false);
            Eval(1593, o is NotEmptyClassGen<Guid>, false);
            Eval(1594, o is NotEmptyClassGen<Guid>[], false);
            Eval(1595, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1596, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1597, o is NestedClass, false);
            Eval(1598, o is NestedClass[], false);
            Eval(1599, o is NestedClassGen<Decimal>, false);
            Eval(1600, o is NestedClassGen<Decimal>[], false);
            Eval(1601, o is ImplementOneInterfaceC, false);
            Eval(1602, o is ImplementOneInterfaceC[], false);
            Eval(1603, o is ImplementTwoInterfaceC, false);
            Eval(1604, o is ImplementTwoInterfaceC[], false);
            Eval(1605, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1606, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1607, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1608, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1609, o is ImplementAllInterfaceC<int>, false);
            Eval(1610, o is ImplementAllInterfaceC<int>[], false);
            Eval(1611, o is SealedClass, false);
            Eval(1612, o is SealedClass[], false);
        }
        {
            ImplementAllInterface<int>? v = default(ImplementAllInterface<int>);
            IEmpty o = v; ;
            Eval(1613, o is ImplementOneInterface, false);
            Eval(1614, o is ImplementOneInterface[], false);
            Eval(1615, o is ImplementOneInterface?, false);
            Eval(1616, o is ImplementOneInterface?[], false);
            Eval(1617, o is ImplementTwoInterface, false);
            Eval(1618, o is ImplementTwoInterface[], false);
            Eval(1619, o is ImplementTwoInterface?, false);
            Eval(1620, o is ImplementTwoInterface?[], false);
            Eval(1621, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1622, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1623, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1624, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1625, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1626, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1627, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1628, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1629, o is ImplementAllInterface<int>, true);
            Eval(1630, o is ImplementAllInterface<int>[], false);
            Eval(1631, o is ImplementAllInterface<int>?, true);
            Eval(1632, o is ImplementAllInterface<int>?[], false);
            Eval(1633, o is char, false);
            Eval(1634, o is char[], false);
            Eval(1635, o is char?, false);
            Eval(1636, o is char?[], false);
            Eval(1637, o is bool, false);
            Eval(1638, o is bool[], false);
            Eval(1639, o is bool?, false);
            Eval(1640, o is bool?[], false);
            Eval(1641, o is byte, false);
            Eval(1642, o is byte[], false);
            Eval(1643, o is byte?, false);
            Eval(1644, o is byte?[], false);
            Eval(1645, o is sbyte, false);
            Eval(1646, o is sbyte[], false);
            Eval(1647, o is sbyte?, false);
            Eval(1648, o is sbyte?[], false);
            Eval(1649, o is short, false);
            Eval(1650, o is short[], false);
            Eval(1651, o is short?, false);
            Eval(1652, o is short?[], false);
            Eval(1653, o is ushort, false);
            Eval(1654, o is ushort[], false);
            Eval(1655, o is ushort?, false);
            Eval(1656, o is ushort?[], false);
            Eval(1657, o is int, false);
            Eval(1658, o is int[], false);
            Eval(1659, o is int?, false);
            Eval(1660, o is int?[], false);
            Eval(1661, o is uint, false);
            Eval(1662, o is uint[], false);
            Eval(1663, o is uint?, false);
            Eval(1664, o is uint?[], false);
            Eval(1665, o is long, false);
            Eval(1666, o is long[], false);
            Eval(1667, o is long?, false);
            Eval(1668, o is long?[], false);
            Eval(1669, o is ulong, false);
            Eval(1670, o is ulong[], false);
            Eval(1671, o is ulong?, false);
            Eval(1672, o is ulong?[], false);
            Eval(1673, o is float, false);
            Eval(1674, o is float[], false);
            Eval(1675, o is float?, false);
            Eval(1676, o is float?[], false);
            Eval(1677, o is double, false);
            Eval(1678, o is double[], false);
            Eval(1679, o is double?, false);
            Eval(1680, o is double?[], false);
            Eval(1681, o is decimal, false);
            Eval(1682, o is decimal[], false);
            Eval(1683, o is decimal?, false);
            Eval(1684, o is decimal?[], false);
            Eval(1685, o is object, true);
            Eval(1686, o is object[], false);
            Eval(1687, o is string, false);
            Eval(1688, o is string[], false);
            Eval(1689, o is ValueType, true);
            Eval(1690, o is ValueType[], false);
            Eval(1691, o is Array, false);
            Eval(1692, o is Array[], false);
            Eval(1693, o is Enum, false);
            Eval(1694, o is Enum[], false);
            Eval(1695, o is Delegate, false);
            Eval(1696, o is Delegate[], false);
            Eval(1697, o is MulticastDelegate, false);
            Eval(1698, o is MulticastDelegate[], false);
            Eval(1699, o is IEmpty, true);
            Eval(1700, o is IEmpty[], false);
            Eval(1701, o is INotEmpty, true);
            Eval(1702, o is INotEmpty[], false);
            Eval(1703, o is IEmptyGen<int>, true);
            Eval(1704, o is IEmptyGen<int>[], false);
            Eval(1705, o is INotEmptyGen<int>, true);
            Eval(1706, o is INotEmptyGen<int>[], false);
            Eval(1707, o is SimpleDelegate, false);
            Eval(1708, o is SimpleDelegate[], false);
            Eval(1709, o is GenericDelegate<int>, false);
            Eval(1710, o is GenericDelegate<int>[], false);
            Eval(1711, o is EmptyClass, false);
            Eval(1712, o is EmptyClass[], false);
            Eval(1713, o is NotEmptyClass, false);
            Eval(1714, o is NotEmptyClass[], false);
            Eval(1715, o is EmptyClassGen<int>, false);
            Eval(1716, o is EmptyClassGen<int>[], false);
            Eval(1717, o is NotEmptyClassGen<Guid>, false);
            Eval(1718, o is NotEmptyClassGen<Guid>[], false);
            Eval(1719, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1720, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1721, o is NestedClass, false);
            Eval(1722, o is NestedClass[], false);
            Eval(1723, o is NestedClassGen<Decimal>, false);
            Eval(1724, o is NestedClassGen<Decimal>[], false);
            Eval(1725, o is ImplementOneInterfaceC, false);
            Eval(1726, o is ImplementOneInterfaceC[], false);
            Eval(1727, o is ImplementTwoInterfaceC, false);
            Eval(1728, o is ImplementTwoInterfaceC[], false);
            Eval(1729, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1730, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1731, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1732, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1733, o is ImplementAllInterfaceC<int>, false);
            Eval(1734, o is ImplementAllInterfaceC<int>[], false);
            Eval(1735, o is SealedClass, false);
            Eval(1736, o is SealedClass[], false);
        }
        {
            ImplementAllInterface<int>? v = default(ImplementAllInterface<int>?);
            IEmpty o = v; ;
            Eval(1737, o is ImplementOneInterface, false);
            Eval(1738, o is ImplementOneInterface[], false);
            Eval(1739, o is ImplementOneInterface?, false);
            Eval(1740, o is ImplementOneInterface?[], false);
            Eval(1741, o is ImplementTwoInterface, false);
            Eval(1742, o is ImplementTwoInterface[], false);
            Eval(1743, o is ImplementTwoInterface?, false);
            Eval(1744, o is ImplementTwoInterface?[], false);
            Eval(1745, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1746, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1747, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1748, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1749, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1750, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1751, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1752, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1753, o is ImplementAllInterface<int>, false);
            Eval(1754, o is ImplementAllInterface<int>[], false);
            Eval(1755, o is ImplementAllInterface<int>?, false);
            Eval(1756, o is ImplementAllInterface<int>?[], false);
            Eval(1757, o is char, false);
            Eval(1758, o is char[], false);
            Eval(1759, o is char?, false);
            Eval(1760, o is char?[], false);
            Eval(1761, o is bool, false);
            Eval(1762, o is bool[], false);
            Eval(1763, o is bool?, false);
            Eval(1764, o is bool?[], false);
            Eval(1765, o is byte, false);
            Eval(1766, o is byte[], false);
            Eval(1767, o is byte?, false);
            Eval(1768, o is byte?[], false);
            Eval(1769, o is sbyte, false);
            Eval(1770, o is sbyte[], false);
            Eval(1771, o is sbyte?, false);
            Eval(1772, o is sbyte?[], false);
            Eval(1773, o is short, false);
            Eval(1774, o is short[], false);
            Eval(1775, o is short?, false);
            Eval(1776, o is short?[], false);
            Eval(1777, o is ushort, false);
            Eval(1778, o is ushort[], false);
            Eval(1779, o is ushort?, false);
            Eval(1780, o is ushort?[], false);
            Eval(1781, o is int, false);
            Eval(1782, o is int[], false);
            Eval(1783, o is int?, false);
            Eval(1784, o is int?[], false);
            Eval(1785, o is uint, false);
            Eval(1786, o is uint[], false);
            Eval(1787, o is uint?, false);
            Eval(1788, o is uint?[], false);
            Eval(1789, o is long, false);
            Eval(1790, o is long[], false);
            Eval(1791, o is long?, false);
            Eval(1792, o is long?[], false);
            Eval(1793, o is ulong, false);
            Eval(1794, o is ulong[], false);
            Eval(1795, o is ulong?, false);
            Eval(1796, o is ulong?[], false);
            Eval(1797, o is float, false);
            Eval(1798, o is float[], false);
            Eval(1799, o is float?, false);
            Eval(1800, o is float?[], false);
            Eval(1801, o is double, false);
            Eval(1802, o is double[], false);
            Eval(1803, o is double?, false);
            Eval(1804, o is double?[], false);
            Eval(1805, o is decimal, false);
            Eval(1806, o is decimal[], false);
            Eval(1807, o is decimal?, false);
            Eval(1808, o is decimal?[], false);
            Eval(1809, o is object, false);
            Eval(1810, o is object[], false);
            Eval(1811, o is string, false);
            Eval(1812, o is string[], false);
            Eval(1813, o is ValueType, false);
            Eval(1814, o is ValueType[], false);
            Eval(1815, o is Array, false);
            Eval(1816, o is Array[], false);
            Eval(1817, o is Enum, false);
            Eval(1818, o is Enum[], false);
            Eval(1819, o is Delegate, false);
            Eval(1820, o is Delegate[], false);
            Eval(1821, o is MulticastDelegate, false);
            Eval(1822, o is MulticastDelegate[], false);
            Eval(1823, o is IEmpty, false);
            Eval(1824, o is IEmpty[], false);
            Eval(1825, o is INotEmpty, false);
            Eval(1826, o is INotEmpty[], false);
            Eval(1827, o is IEmptyGen<int>, false);
            Eval(1828, o is IEmptyGen<int>[], false);
            Eval(1829, o is INotEmptyGen<int>, false);
            Eval(1830, o is INotEmptyGen<int>[], false);
            Eval(1831, o is SimpleDelegate, false);
            Eval(1832, o is SimpleDelegate[], false);
            Eval(1833, o is GenericDelegate<int>, false);
            Eval(1834, o is GenericDelegate<int>[], false);
            Eval(1835, o is EmptyClass, false);
            Eval(1836, o is EmptyClass[], false);
            Eval(1837, o is NotEmptyClass, false);
            Eval(1838, o is NotEmptyClass[], false);
            Eval(1839, o is EmptyClassGen<int>, false);
            Eval(1840, o is EmptyClassGen<int>[], false);
            Eval(1841, o is NotEmptyClassGen<Guid>, false);
            Eval(1842, o is NotEmptyClassGen<Guid>[], false);
            Eval(1843, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1844, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1845, o is NestedClass, false);
            Eval(1846, o is NestedClass[], false);
            Eval(1847, o is NestedClassGen<Decimal>, false);
            Eval(1848, o is NestedClassGen<Decimal>[], false);
            Eval(1849, o is ImplementOneInterfaceC, false);
            Eval(1850, o is ImplementOneInterfaceC[], false);
            Eval(1851, o is ImplementTwoInterfaceC, false);
            Eval(1852, o is ImplementTwoInterfaceC[], false);
            Eval(1853, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1854, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1855, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1856, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1857, o is ImplementAllInterfaceC<int>, false);
            Eval(1858, o is ImplementAllInterfaceC<int>[], false);
            Eval(1859, o is SealedClass, false);
            Eval(1860, o is SealedClass[], false);
        }
    }  // end of test case 0005
    private static void TestCase0006()
    {
        {
            char v = default(char);
            IComparable o = v; ;
            Eval(1861, o is ImplementOneInterface, false);
            Eval(1862, o is ImplementOneInterface[], false);
            Eval(1863, o is ImplementOneInterface?, false);
            Eval(1864, o is ImplementOneInterface?[], false);
            Eval(1865, o is ImplementTwoInterface, false);
            Eval(1866, o is ImplementTwoInterface[], false);
            Eval(1867, o is ImplementTwoInterface?, false);
            Eval(1868, o is ImplementTwoInterface?[], false);
            Eval(1869, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1870, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1871, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1872, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1873, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1874, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1875, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(1876, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(1877, o is ImplementAllInterface<int>, false);
            Eval(1878, o is ImplementAllInterface<int>[], false);
            Eval(1879, o is ImplementAllInterface<int>?, false);
            Eval(1880, o is ImplementAllInterface<int>?[], false);
            Eval(1881, o is char, true);
            Eval(1882, o is char[], false);
            Eval(1883, o is char?, true);
            Eval(1884, o is char?[], false);
            Eval(1885, o is bool, false);
            Eval(1886, o is bool[], false);
            Eval(1887, o is bool?, false);
            Eval(1888, o is bool?[], false);
            Eval(1889, o is byte, false);
            Eval(1890, o is byte[], false);
            Eval(1891, o is byte?, false);
            Eval(1892, o is byte?[], false);
            Eval(1893, o is sbyte, false);
            Eval(1894, o is sbyte[], false);
            Eval(1895, o is sbyte?, false);
            Eval(1896, o is sbyte?[], false);
            Eval(1897, o is short, false);
            Eval(1898, o is short[], false);
            Eval(1899, o is short?, false);
            Eval(1900, o is short?[], false);
            Eval(1901, o is ushort, false);
            Eval(1902, o is ushort[], false);
            Eval(1903, o is ushort?, false);
            Eval(1904, o is ushort?[], false);
            Eval(1905, o is int, false);
            Eval(1906, o is int[], false);
            Eval(1907, o is int?, false);
            Eval(1908, o is int?[], false);
            Eval(1909, o is uint, false);
            Eval(1910, o is uint[], false);
            Eval(1911, o is uint?, false);
            Eval(1912, o is uint?[], false);
            Eval(1913, o is long, false);
            Eval(1914, o is long[], false);
            Eval(1915, o is long?, false);
            Eval(1916, o is long?[], false);
            Eval(1917, o is ulong, false);
            Eval(1918, o is ulong[], false);
            Eval(1919, o is ulong?, false);
            Eval(1920, o is ulong?[], false);
            Eval(1921, o is float, false);
            Eval(1922, o is float[], false);
            Eval(1923, o is float?, false);
            Eval(1924, o is float?[], false);
            Eval(1925, o is double, false);
            Eval(1926, o is double[], false);
            Eval(1927, o is double?, false);
            Eval(1928, o is double?[], false);
            Eval(1929, o is decimal, false);
            Eval(1930, o is decimal[], false);
            Eval(1931, o is decimal?, false);
            Eval(1932, o is decimal?[], false);
            Eval(1933, o is object, true);
            Eval(1934, o is object[], false);
            Eval(1935, o is string, false);
            Eval(1936, o is string[], false);
            Eval(1937, o is ValueType, true);
            Eval(1938, o is ValueType[], false);
            Eval(1939, o is Array, false);
            Eval(1940, o is Array[], false);
            Eval(1941, o is Enum, false);
            Eval(1942, o is Enum[], false);
            Eval(1943, o is Delegate, false);
            Eval(1944, o is Delegate[], false);
            Eval(1945, o is MulticastDelegate, false);
            Eval(1946, o is MulticastDelegate[], false);
            Eval(1947, o is IEmpty, false);
            Eval(1948, o is IEmpty[], false);
            Eval(1949, o is INotEmpty, false);
            Eval(1950, o is INotEmpty[], false);
            Eval(1951, o is IEmptyGen<int>, false);
            Eval(1952, o is IEmptyGen<int>[], false);
            Eval(1953, o is INotEmptyGen<int>, false);
            Eval(1954, o is INotEmptyGen<int>[], false);
            Eval(1955, o is SimpleDelegate, false);
            Eval(1956, o is SimpleDelegate[], false);
            Eval(1957, o is GenericDelegate<int>, false);
            Eval(1958, o is GenericDelegate<int>[], false);
            Eval(1959, o is EmptyClass, false);
            Eval(1960, o is EmptyClass[], false);
            Eval(1961, o is NotEmptyClass, false);
            Eval(1962, o is NotEmptyClass[], false);
            Eval(1963, o is EmptyClassGen<int>, false);
            Eval(1964, o is EmptyClassGen<int>[], false);
            Eval(1965, o is NotEmptyClassGen<Guid>, false);
            Eval(1966, o is NotEmptyClassGen<Guid>[], false);
            Eval(1967, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(1968, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(1969, o is NestedClass, false);
            Eval(1970, o is NestedClass[], false);
            Eval(1971, o is NestedClassGen<Decimal>, false);
            Eval(1972, o is NestedClassGen<Decimal>[], false);
            Eval(1973, o is ImplementOneInterfaceC, false);
            Eval(1974, o is ImplementOneInterfaceC[], false);
            Eval(1975, o is ImplementTwoInterfaceC, false);
            Eval(1976, o is ImplementTwoInterfaceC[], false);
            Eval(1977, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(1978, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(1979, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(1980, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(1981, o is ImplementAllInterfaceC<int>, false);
            Eval(1982, o is ImplementAllInterfaceC<int>[], false);
            Eval(1983, o is SealedClass, false);
            Eval(1984, o is SealedClass[], false);
        }
        {
            char? v = default(char);
            IComparable o = v; ;
            Eval(1985, o is ImplementOneInterface, false);
            Eval(1986, o is ImplementOneInterface[], false);
            Eval(1987, o is ImplementOneInterface?, false);
            Eval(1988, o is ImplementOneInterface?[], false);
            Eval(1989, o is ImplementTwoInterface, false);
            Eval(1990, o is ImplementTwoInterface[], false);
            Eval(1991, o is ImplementTwoInterface?, false);
            Eval(1992, o is ImplementTwoInterface?[], false);
            Eval(1993, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(1994, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(1995, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(1996, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(1997, o is ImplementTwoInterfaceGen<int>, false);
            Eval(1998, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(1999, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2000, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2001, o is ImplementAllInterface<int>, false);
            Eval(2002, o is ImplementAllInterface<int>[], false);
            Eval(2003, o is ImplementAllInterface<int>?, false);
            Eval(2004, o is ImplementAllInterface<int>?[], false);
            Eval(2005, o is char, true);
            Eval(2006, o is char[], false);
            Eval(2007, o is char?, true);
            Eval(2008, o is char?[], false);
            Eval(2009, o is bool, false);
            Eval(2010, o is bool[], false);
            Eval(2011, o is bool?, false);
            Eval(2012, o is bool?[], false);
            Eval(2013, o is byte, false);
            Eval(2014, o is byte[], false);
            Eval(2015, o is byte?, false);
            Eval(2016, o is byte?[], false);
            Eval(2017, o is sbyte, false);
            Eval(2018, o is sbyte[], false);
            Eval(2019, o is sbyte?, false);
            Eval(2020, o is sbyte?[], false);
            Eval(2021, o is short, false);
            Eval(2022, o is short[], false);
            Eval(2023, o is short?, false);
            Eval(2024, o is short?[], false);
            Eval(2025, o is ushort, false);
            Eval(2026, o is ushort[], false);
            Eval(2027, o is ushort?, false);
            Eval(2028, o is ushort?[], false);
            Eval(2029, o is int, false);
            Eval(2030, o is int[], false);
            Eval(2031, o is int?, false);
            Eval(2032, o is int?[], false);
            Eval(2033, o is uint, false);
            Eval(2034, o is uint[], false);
            Eval(2035, o is uint?, false);
            Eval(2036, o is uint?[], false);
            Eval(2037, o is long, false);
            Eval(2038, o is long[], false);
            Eval(2039, o is long?, false);
            Eval(2040, o is long?[], false);
            Eval(2041, o is ulong, false);
            Eval(2042, o is ulong[], false);
            Eval(2043, o is ulong?, false);
            Eval(2044, o is ulong?[], false);
            Eval(2045, o is float, false);
            Eval(2046, o is float[], false);
            Eval(2047, o is float?, false);
            Eval(2048, o is float?[], false);
            Eval(2049, o is double, false);
            Eval(2050, o is double[], false);
            Eval(2051, o is double?, false);
            Eval(2052, o is double?[], false);
            Eval(2053, o is decimal, false);
            Eval(2054, o is decimal[], false);
            Eval(2055, o is decimal?, false);
            Eval(2056, o is decimal?[], false);
            Eval(2057, o is object, true);
            Eval(2058, o is object[], false);
            Eval(2059, o is string, false);
            Eval(2060, o is string[], false);
            Eval(2061, o is ValueType, true);
            Eval(2062, o is ValueType[], false);
            Eval(2063, o is Array, false);
            Eval(2064, o is Array[], false);
            Eval(2065, o is Enum, false);
            Eval(2066, o is Enum[], false);
            Eval(2067, o is Delegate, false);
            Eval(2068, o is Delegate[], false);
            Eval(2069, o is MulticastDelegate, false);
            Eval(2070, o is MulticastDelegate[], false);
            Eval(2071, o is IEmpty, false);
            Eval(2072, o is IEmpty[], false);
            Eval(2073, o is INotEmpty, false);
            Eval(2074, o is INotEmpty[], false);
            Eval(2075, o is IEmptyGen<int>, false);
            Eval(2076, o is IEmptyGen<int>[], false);
            Eval(2077, o is INotEmptyGen<int>, false);
            Eval(2078, o is INotEmptyGen<int>[], false);
            Eval(2079, o is SimpleDelegate, false);
            Eval(2080, o is SimpleDelegate[], false);
            Eval(2081, o is GenericDelegate<int>, false);
            Eval(2082, o is GenericDelegate<int>[], false);
            Eval(2083, o is EmptyClass, false);
            Eval(2084, o is EmptyClass[], false);
            Eval(2085, o is NotEmptyClass, false);
            Eval(2086, o is NotEmptyClass[], false);
            Eval(2087, o is EmptyClassGen<int>, false);
            Eval(2088, o is EmptyClassGen<int>[], false);
            Eval(2089, o is NotEmptyClassGen<Guid>, false);
            Eval(2090, o is NotEmptyClassGen<Guid>[], false);
            Eval(2091, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2092, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2093, o is NestedClass, false);
            Eval(2094, o is NestedClass[], false);
            Eval(2095, o is NestedClassGen<Decimal>, false);
            Eval(2096, o is NestedClassGen<Decimal>[], false);
            Eval(2097, o is ImplementOneInterfaceC, false);
            Eval(2098, o is ImplementOneInterfaceC[], false);
            Eval(2099, o is ImplementTwoInterfaceC, false);
            Eval(2100, o is ImplementTwoInterfaceC[], false);
            Eval(2101, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2102, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2103, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2104, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2105, o is ImplementAllInterfaceC<int>, false);
            Eval(2106, o is ImplementAllInterfaceC<int>[], false);
            Eval(2107, o is SealedClass, false);
            Eval(2108, o is SealedClass[], false);
        }
        {
            char? v = default(char?);
            IComparable o = v; ;
            Eval(2109, o is ImplementOneInterface, false);
            Eval(2110, o is ImplementOneInterface[], false);
            Eval(2111, o is ImplementOneInterface?, false);
            Eval(2112, o is ImplementOneInterface?[], false);
            Eval(2113, o is ImplementTwoInterface, false);
            Eval(2114, o is ImplementTwoInterface[], false);
            Eval(2115, o is ImplementTwoInterface?, false);
            Eval(2116, o is ImplementTwoInterface?[], false);
            Eval(2117, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2118, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2119, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2120, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2121, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2122, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2123, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2124, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2125, o is ImplementAllInterface<int>, false);
            Eval(2126, o is ImplementAllInterface<int>[], false);
            Eval(2127, o is ImplementAllInterface<int>?, false);
            Eval(2128, o is ImplementAllInterface<int>?[], false);
            Eval(2129, o is char, false);
            Eval(2130, o is char[], false);
            Eval(2131, o is char?, false);
            Eval(2132, o is char?[], false);
            Eval(2133, o is bool, false);
            Eval(2134, o is bool[], false);
            Eval(2135, o is bool?, false);
            Eval(2136, o is bool?[], false);
            Eval(2137, o is byte, false);
            Eval(2138, o is byte[], false);
            Eval(2139, o is byte?, false);
            Eval(2140, o is byte?[], false);
            Eval(2141, o is sbyte, false);
            Eval(2142, o is sbyte[], false);
            Eval(2143, o is sbyte?, false);
            Eval(2144, o is sbyte?[], false);
            Eval(2145, o is short, false);
            Eval(2146, o is short[], false);
            Eval(2147, o is short?, false);
            Eval(2148, o is short?[], false);
            Eval(2149, o is ushort, false);
            Eval(2150, o is ushort[], false);
            Eval(2151, o is ushort?, false);
            Eval(2152, o is ushort?[], false);
            Eval(2153, o is int, false);
            Eval(2154, o is int[], false);
            Eval(2155, o is int?, false);
            Eval(2156, o is int?[], false);
            Eval(2157, o is uint, false);
            Eval(2158, o is uint[], false);
            Eval(2159, o is uint?, false);
            Eval(2160, o is uint?[], false);
            Eval(2161, o is long, false);
            Eval(2162, o is long[], false);
            Eval(2163, o is long?, false);
            Eval(2164, o is long?[], false);
            Eval(2165, o is ulong, false);
            Eval(2166, o is ulong[], false);
            Eval(2167, o is ulong?, false);
            Eval(2168, o is ulong?[], false);
            Eval(2169, o is float, false);
            Eval(2170, o is float[], false);
            Eval(2171, o is float?, false);
            Eval(2172, o is float?[], false);
            Eval(2173, o is double, false);
            Eval(2174, o is double[], false);
            Eval(2175, o is double?, false);
            Eval(2176, o is double?[], false);
            Eval(2177, o is decimal, false);
            Eval(2178, o is decimal[], false);
            Eval(2179, o is decimal?, false);
            Eval(2180, o is decimal?[], false);
            Eval(2181, o is object, false);
            Eval(2182, o is object[], false);
            Eval(2183, o is string, false);
            Eval(2184, o is string[], false);
            Eval(2185, o is ValueType, false);
            Eval(2186, o is ValueType[], false);
            Eval(2187, o is Array, false);
            Eval(2188, o is Array[], false);
            Eval(2189, o is Enum, false);
            Eval(2190, o is Enum[], false);
            Eval(2191, o is Delegate, false);
            Eval(2192, o is Delegate[], false);
            Eval(2193, o is MulticastDelegate, false);
            Eval(2194, o is MulticastDelegate[], false);
            Eval(2195, o is IEmpty, false);
            Eval(2196, o is IEmpty[], false);
            Eval(2197, o is INotEmpty, false);
            Eval(2198, o is INotEmpty[], false);
            Eval(2199, o is IEmptyGen<int>, false);
            Eval(2200, o is IEmptyGen<int>[], false);
            Eval(2201, o is INotEmptyGen<int>, false);
            Eval(2202, o is INotEmptyGen<int>[], false);
            Eval(2203, o is SimpleDelegate, false);
            Eval(2204, o is SimpleDelegate[], false);
            Eval(2205, o is GenericDelegate<int>, false);
            Eval(2206, o is GenericDelegate<int>[], false);
            Eval(2207, o is EmptyClass, false);
            Eval(2208, o is EmptyClass[], false);
            Eval(2209, o is NotEmptyClass, false);
            Eval(2210, o is NotEmptyClass[], false);
            Eval(2211, o is EmptyClassGen<int>, false);
            Eval(2212, o is EmptyClassGen<int>[], false);
            Eval(2213, o is NotEmptyClassGen<Guid>, false);
            Eval(2214, o is NotEmptyClassGen<Guid>[], false);
            Eval(2215, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2216, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2217, o is NestedClass, false);
            Eval(2218, o is NestedClass[], false);
            Eval(2219, o is NestedClassGen<Decimal>, false);
            Eval(2220, o is NestedClassGen<Decimal>[], false);
            Eval(2221, o is ImplementOneInterfaceC, false);
            Eval(2222, o is ImplementOneInterfaceC[], false);
            Eval(2223, o is ImplementTwoInterfaceC, false);
            Eval(2224, o is ImplementTwoInterfaceC[], false);
            Eval(2225, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2226, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2227, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2228, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2229, o is ImplementAllInterfaceC<int>, false);
            Eval(2230, o is ImplementAllInterfaceC<int>[], false);
            Eval(2231, o is SealedClass, false);
            Eval(2232, o is SealedClass[], false);
        }
    }  // end of test case 0006
    private static void TestCase0007()
    {
        {
            bool v = default(bool);
            IComparable o = v; ;
            Eval(2233, o is ImplementOneInterface, false);
            Eval(2234, o is ImplementOneInterface[], false);
            Eval(2235, o is ImplementOneInterface?, false);
            Eval(2236, o is ImplementOneInterface?[], false);
            Eval(2237, o is ImplementTwoInterface, false);
            Eval(2238, o is ImplementTwoInterface[], false);
            Eval(2239, o is ImplementTwoInterface?, false);
            Eval(2240, o is ImplementTwoInterface?[], false);
            Eval(2241, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2242, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2243, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2244, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2245, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2246, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2247, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2248, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2249, o is ImplementAllInterface<int>, false);
            Eval(2250, o is ImplementAllInterface<int>[], false);
            Eval(2251, o is ImplementAllInterface<int>?, false);
            Eval(2252, o is ImplementAllInterface<int>?[], false);
            Eval(2253, o is char, false);
            Eval(2254, o is char[], false);
            Eval(2255, o is char?, false);
            Eval(2256, o is char?[], false);
            Eval(2257, o is bool, true);
            Eval(2258, o is bool[], false);
            Eval(2259, o is bool?, true);
            Eval(2260, o is bool?[], false);
            Eval(2261, o is byte, false);
            Eval(2262, o is byte[], false);
            Eval(2263, o is byte?, false);
            Eval(2264, o is byte?[], false);
            Eval(2265, o is sbyte, false);
            Eval(2266, o is sbyte[], false);
            Eval(2267, o is sbyte?, false);
            Eval(2268, o is sbyte?[], false);
            Eval(2269, o is short, false);
            Eval(2270, o is short[], false);
            Eval(2271, o is short?, false);
            Eval(2272, o is short?[], false);
            Eval(2273, o is ushort, false);
            Eval(2274, o is ushort[], false);
            Eval(2275, o is ushort?, false);
            Eval(2276, o is ushort?[], false);
            Eval(2277, o is int, false);
            Eval(2278, o is int[], false);
            Eval(2279, o is int?, false);
            Eval(2280, o is int?[], false);
            Eval(2281, o is uint, false);
            Eval(2282, o is uint[], false);
            Eval(2283, o is uint?, false);
            Eval(2284, o is uint?[], false);
            Eval(2285, o is long, false);
            Eval(2286, o is long[], false);
            Eval(2287, o is long?, false);
            Eval(2288, o is long?[], false);
            Eval(2289, o is ulong, false);
            Eval(2290, o is ulong[], false);
            Eval(2291, o is ulong?, false);
            Eval(2292, o is ulong?[], false);
            Eval(2293, o is float, false);
            Eval(2294, o is float[], false);
            Eval(2295, o is float?, false);
            Eval(2296, o is float?[], false);
            Eval(2297, o is double, false);
            Eval(2298, o is double[], false);
            Eval(2299, o is double?, false);
            Eval(2300, o is double?[], false);
            Eval(2301, o is decimal, false);
            Eval(2302, o is decimal[], false);
            Eval(2303, o is decimal?, false);
            Eval(2304, o is decimal?[], false);
            Eval(2305, o is object, true);
            Eval(2306, o is object[], false);
            Eval(2307, o is string, false);
            Eval(2308, o is string[], false);
            Eval(2309, o is ValueType, true);
            Eval(2310, o is ValueType[], false);
            Eval(2311, o is Array, false);
            Eval(2312, o is Array[], false);
            Eval(2313, o is Enum, false);
            Eval(2314, o is Enum[], false);
            Eval(2315, o is Delegate, false);
            Eval(2316, o is Delegate[], false);
            Eval(2317, o is MulticastDelegate, false);
            Eval(2318, o is MulticastDelegate[], false);
            Eval(2319, o is IEmpty, false);
            Eval(2320, o is IEmpty[], false);
            Eval(2321, o is INotEmpty, false);
            Eval(2322, o is INotEmpty[], false);
            Eval(2323, o is IEmptyGen<int>, false);
            Eval(2324, o is IEmptyGen<int>[], false);
            Eval(2325, o is INotEmptyGen<int>, false);
            Eval(2326, o is INotEmptyGen<int>[], false);
            Eval(2327, o is SimpleDelegate, false);
            Eval(2328, o is SimpleDelegate[], false);
            Eval(2329, o is GenericDelegate<int>, false);
            Eval(2330, o is GenericDelegate<int>[], false);
            Eval(2331, o is EmptyClass, false);
            Eval(2332, o is EmptyClass[], false);
            Eval(2333, o is NotEmptyClass, false);
            Eval(2334, o is NotEmptyClass[], false);
            Eval(2335, o is EmptyClassGen<int>, false);
            Eval(2336, o is EmptyClassGen<int>[], false);
            Eval(2337, o is NotEmptyClassGen<Guid>, false);
            Eval(2338, o is NotEmptyClassGen<Guid>[], false);
            Eval(2339, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2340, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2341, o is NestedClass, false);
            Eval(2342, o is NestedClass[], false);
            Eval(2343, o is NestedClassGen<Decimal>, false);
            Eval(2344, o is NestedClassGen<Decimal>[], false);
            Eval(2345, o is ImplementOneInterfaceC, false);
            Eval(2346, o is ImplementOneInterfaceC[], false);
            Eval(2347, o is ImplementTwoInterfaceC, false);
            Eval(2348, o is ImplementTwoInterfaceC[], false);
            Eval(2349, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2350, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2351, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2352, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2353, o is ImplementAllInterfaceC<int>, false);
            Eval(2354, o is ImplementAllInterfaceC<int>[], false);
            Eval(2355, o is SealedClass, false);
            Eval(2356, o is SealedClass[], false);
        }
        {
            bool? v = default(bool);
            IComparable o = v; ;
            Eval(2357, o is ImplementOneInterface, false);
            Eval(2358, o is ImplementOneInterface[], false);
            Eval(2359, o is ImplementOneInterface?, false);
            Eval(2360, o is ImplementOneInterface?[], false);
            Eval(2361, o is ImplementTwoInterface, false);
            Eval(2362, o is ImplementTwoInterface[], false);
            Eval(2363, o is ImplementTwoInterface?, false);
            Eval(2364, o is ImplementTwoInterface?[], false);
            Eval(2365, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2366, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2367, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2368, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2369, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2370, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2371, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2372, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2373, o is ImplementAllInterface<int>, false);
            Eval(2374, o is ImplementAllInterface<int>[], false);
            Eval(2375, o is ImplementAllInterface<int>?, false);
            Eval(2376, o is ImplementAllInterface<int>?[], false);
            Eval(2377, o is char, false);
            Eval(2378, o is char[], false);
            Eval(2379, o is char?, false);
            Eval(2380, o is char?[], false);
            Eval(2381, o is bool, true);
            Eval(2382, o is bool[], false);
            Eval(2383, o is bool?, true);
            Eval(2384, o is bool?[], false);
            Eval(2385, o is byte, false);
            Eval(2386, o is byte[], false);
            Eval(2387, o is byte?, false);
            Eval(2388, o is byte?[], false);
            Eval(2389, o is sbyte, false);
            Eval(2390, o is sbyte[], false);
            Eval(2391, o is sbyte?, false);
            Eval(2392, o is sbyte?[], false);
            Eval(2393, o is short, false);
            Eval(2394, o is short[], false);
            Eval(2395, o is short?, false);
            Eval(2396, o is short?[], false);
            Eval(2397, o is ushort, false);
            Eval(2398, o is ushort[], false);
            Eval(2399, o is ushort?, false);
            Eval(2400, o is ushort?[], false);
            Eval(2401, o is int, false);
            Eval(2402, o is int[], false);
            Eval(2403, o is int?, false);
            Eval(2404, o is int?[], false);
            Eval(2405, o is uint, false);
            Eval(2406, o is uint[], false);
            Eval(2407, o is uint?, false);
            Eval(2408, o is uint?[], false);
            Eval(2409, o is long, false);
            Eval(2410, o is long[], false);
            Eval(2411, o is long?, false);
            Eval(2412, o is long?[], false);
            Eval(2413, o is ulong, false);
            Eval(2414, o is ulong[], false);
            Eval(2415, o is ulong?, false);
            Eval(2416, o is ulong?[], false);
            Eval(2417, o is float, false);
            Eval(2418, o is float[], false);
            Eval(2419, o is float?, false);
            Eval(2420, o is float?[], false);
            Eval(2421, o is double, false);
            Eval(2422, o is double[], false);
            Eval(2423, o is double?, false);
            Eval(2424, o is double?[], false);
            Eval(2425, o is decimal, false);
            Eval(2426, o is decimal[], false);
            Eval(2427, o is decimal?, false);
            Eval(2428, o is decimal?[], false);
            Eval(2429, o is object, true);
            Eval(2430, o is object[], false);
            Eval(2431, o is string, false);
            Eval(2432, o is string[], false);
            Eval(2433, o is ValueType, true);
            Eval(2434, o is ValueType[], false);
            Eval(2435, o is Array, false);
            Eval(2436, o is Array[], false);
            Eval(2437, o is Enum, false);
            Eval(2438, o is Enum[], false);
            Eval(2439, o is Delegate, false);
            Eval(2440, o is Delegate[], false);
            Eval(2441, o is MulticastDelegate, false);
            Eval(2442, o is MulticastDelegate[], false);
            Eval(2443, o is IEmpty, false);
            Eval(2444, o is IEmpty[], false);
            Eval(2445, o is INotEmpty, false);
            Eval(2446, o is INotEmpty[], false);
            Eval(2447, o is IEmptyGen<int>, false);
            Eval(2448, o is IEmptyGen<int>[], false);
            Eval(2449, o is INotEmptyGen<int>, false);
            Eval(2450, o is INotEmptyGen<int>[], false);
            Eval(2451, o is SimpleDelegate, false);
            Eval(2452, o is SimpleDelegate[], false);
            Eval(2453, o is GenericDelegate<int>, false);
            Eval(2454, o is GenericDelegate<int>[], false);
            Eval(2455, o is EmptyClass, false);
            Eval(2456, o is EmptyClass[], false);
            Eval(2457, o is NotEmptyClass, false);
            Eval(2458, o is NotEmptyClass[], false);
            Eval(2459, o is EmptyClassGen<int>, false);
            Eval(2460, o is EmptyClassGen<int>[], false);
            Eval(2461, o is NotEmptyClassGen<Guid>, false);
            Eval(2462, o is NotEmptyClassGen<Guid>[], false);
            Eval(2463, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2464, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2465, o is NestedClass, false);
            Eval(2466, o is NestedClass[], false);
            Eval(2467, o is NestedClassGen<Decimal>, false);
            Eval(2468, o is NestedClassGen<Decimal>[], false);
            Eval(2469, o is ImplementOneInterfaceC, false);
            Eval(2470, o is ImplementOneInterfaceC[], false);
            Eval(2471, o is ImplementTwoInterfaceC, false);
            Eval(2472, o is ImplementTwoInterfaceC[], false);
            Eval(2473, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2474, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2475, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2476, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2477, o is ImplementAllInterfaceC<int>, false);
            Eval(2478, o is ImplementAllInterfaceC<int>[], false);
            Eval(2479, o is SealedClass, false);
            Eval(2480, o is SealedClass[], false);
        }
        {
            bool? v = default(bool?);
            IComparable o = v; ;
            Eval(2481, o is ImplementOneInterface, false);
            Eval(2482, o is ImplementOneInterface[], false);
            Eval(2483, o is ImplementOneInterface?, false);
            Eval(2484, o is ImplementOneInterface?[], false);
            Eval(2485, o is ImplementTwoInterface, false);
            Eval(2486, o is ImplementTwoInterface[], false);
            Eval(2487, o is ImplementTwoInterface?, false);
            Eval(2488, o is ImplementTwoInterface?[], false);
            Eval(2489, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2490, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2491, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2492, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2493, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2494, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2495, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2496, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2497, o is ImplementAllInterface<int>, false);
            Eval(2498, o is ImplementAllInterface<int>[], false);
            Eval(2499, o is ImplementAllInterface<int>?, false);
            Eval(2500, o is ImplementAllInterface<int>?[], false);
            Eval(2501, o is char, false);
            Eval(2502, o is char[], false);
            Eval(2503, o is char?, false);
            Eval(2504, o is char?[], false);
            Eval(2505, o is bool, false);
            Eval(2506, o is bool[], false);
            Eval(2507, o is bool?, false);
            Eval(2508, o is bool?[], false);
            Eval(2509, o is byte, false);
            Eval(2510, o is byte[], false);
            Eval(2511, o is byte?, false);
            Eval(2512, o is byte?[], false);
            Eval(2513, o is sbyte, false);
            Eval(2514, o is sbyte[], false);
            Eval(2515, o is sbyte?, false);
            Eval(2516, o is sbyte?[], false);
            Eval(2517, o is short, false);
            Eval(2518, o is short[], false);
            Eval(2519, o is short?, false);
            Eval(2520, o is short?[], false);
            Eval(2521, o is ushort, false);
            Eval(2522, o is ushort[], false);
            Eval(2523, o is ushort?, false);
            Eval(2524, o is ushort?[], false);
            Eval(2525, o is int, false);
            Eval(2526, o is int[], false);
            Eval(2527, o is int?, false);
            Eval(2528, o is int?[], false);
            Eval(2529, o is uint, false);
            Eval(2530, o is uint[], false);
            Eval(2531, o is uint?, false);
            Eval(2532, o is uint?[], false);
            Eval(2533, o is long, false);
            Eval(2534, o is long[], false);
            Eval(2535, o is long?, false);
            Eval(2536, o is long?[], false);
            Eval(2537, o is ulong, false);
            Eval(2538, o is ulong[], false);
            Eval(2539, o is ulong?, false);
            Eval(2540, o is ulong?[], false);
            Eval(2541, o is float, false);
            Eval(2542, o is float[], false);
            Eval(2543, o is float?, false);
            Eval(2544, o is float?[], false);
            Eval(2545, o is double, false);
            Eval(2546, o is double[], false);
            Eval(2547, o is double?, false);
            Eval(2548, o is double?[], false);
            Eval(2549, o is decimal, false);
            Eval(2550, o is decimal[], false);
            Eval(2551, o is decimal?, false);
            Eval(2552, o is decimal?[], false);
            Eval(2553, o is object, false);
            Eval(2554, o is object[], false);
            Eval(2555, o is string, false);
            Eval(2556, o is string[], false);
            Eval(2557, o is ValueType, false);
            Eval(2558, o is ValueType[], false);
            Eval(2559, o is Array, false);
            Eval(2560, o is Array[], false);
            Eval(2561, o is Enum, false);
            Eval(2562, o is Enum[], false);
            Eval(2563, o is Delegate, false);
            Eval(2564, o is Delegate[], false);
            Eval(2565, o is MulticastDelegate, false);
            Eval(2566, o is MulticastDelegate[], false);
            Eval(2567, o is IEmpty, false);
            Eval(2568, o is IEmpty[], false);
            Eval(2569, o is INotEmpty, false);
            Eval(2570, o is INotEmpty[], false);
            Eval(2571, o is IEmptyGen<int>, false);
            Eval(2572, o is IEmptyGen<int>[], false);
            Eval(2573, o is INotEmptyGen<int>, false);
            Eval(2574, o is INotEmptyGen<int>[], false);
            Eval(2575, o is SimpleDelegate, false);
            Eval(2576, o is SimpleDelegate[], false);
            Eval(2577, o is GenericDelegate<int>, false);
            Eval(2578, o is GenericDelegate<int>[], false);
            Eval(2579, o is EmptyClass, false);
            Eval(2580, o is EmptyClass[], false);
            Eval(2581, o is NotEmptyClass, false);
            Eval(2582, o is NotEmptyClass[], false);
            Eval(2583, o is EmptyClassGen<int>, false);
            Eval(2584, o is EmptyClassGen<int>[], false);
            Eval(2585, o is NotEmptyClassGen<Guid>, false);
            Eval(2586, o is NotEmptyClassGen<Guid>[], false);
            Eval(2587, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2588, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2589, o is NestedClass, false);
            Eval(2590, o is NestedClass[], false);
            Eval(2591, o is NestedClassGen<Decimal>, false);
            Eval(2592, o is NestedClassGen<Decimal>[], false);
            Eval(2593, o is ImplementOneInterfaceC, false);
            Eval(2594, o is ImplementOneInterfaceC[], false);
            Eval(2595, o is ImplementTwoInterfaceC, false);
            Eval(2596, o is ImplementTwoInterfaceC[], false);
            Eval(2597, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2598, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2599, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2600, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2601, o is ImplementAllInterfaceC<int>, false);
            Eval(2602, o is ImplementAllInterfaceC<int>[], false);
            Eval(2603, o is SealedClass, false);
            Eval(2604, o is SealedClass[], false);
        }
    }  // end of test case 0007
    private static void TestCase0008()
    {
        {
            byte v = default(byte);
            IComparable o = v; ;
            Eval(2605, o is ImplementOneInterface, false);
            Eval(2606, o is ImplementOneInterface[], false);
            Eval(2607, o is ImplementOneInterface?, false);
            Eval(2608, o is ImplementOneInterface?[], false);
            Eval(2609, o is ImplementTwoInterface, false);
            Eval(2610, o is ImplementTwoInterface[], false);
            Eval(2611, o is ImplementTwoInterface?, false);
            Eval(2612, o is ImplementTwoInterface?[], false);
            Eval(2613, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2614, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2615, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2616, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2617, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2618, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2619, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2620, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2621, o is ImplementAllInterface<int>, false);
            Eval(2622, o is ImplementAllInterface<int>[], false);
            Eval(2623, o is ImplementAllInterface<int>?, false);
            Eval(2624, o is ImplementAllInterface<int>?[], false);
            Eval(2625, o is char, false);
            Eval(2626, o is char[], false);
            Eval(2627, o is char?, false);
            Eval(2628, o is char?[], false);
            Eval(2629, o is bool, false);
            Eval(2630, o is bool[], false);
            Eval(2631, o is bool?, false);
            Eval(2632, o is bool?[], false);
            Eval(2633, o is byte, true);
            Eval(2634, o is byte[], false);
            Eval(2635, o is byte?, true);
            Eval(2636, o is byte?[], false);
            Eval(2637, o is sbyte, false);
            Eval(2638, o is sbyte[], false);
            Eval(2639, o is sbyte?, false);
            Eval(2640, o is sbyte?[], false);
            Eval(2641, o is short, false);
            Eval(2642, o is short[], false);
            Eval(2643, o is short?, false);
            Eval(2644, o is short?[], false);
            Eval(2645, o is ushort, false);
            Eval(2646, o is ushort[], false);
            Eval(2647, o is ushort?, false);
            Eval(2648, o is ushort?[], false);
            Eval(2649, o is int, false);
            Eval(2650, o is int[], false);
            Eval(2651, o is int?, false);
            Eval(2652, o is int?[], false);
            Eval(2653, o is uint, false);
            Eval(2654, o is uint[], false);
            Eval(2655, o is uint?, false);
            Eval(2656, o is uint?[], false);
            Eval(2657, o is long, false);
            Eval(2658, o is long[], false);
            Eval(2659, o is long?, false);
            Eval(2660, o is long?[], false);
            Eval(2661, o is ulong, false);
            Eval(2662, o is ulong[], false);
            Eval(2663, o is ulong?, false);
            Eval(2664, o is ulong?[], false);
            Eval(2665, o is float, false);
            Eval(2666, o is float[], false);
            Eval(2667, o is float?, false);
            Eval(2668, o is float?[], false);
            Eval(2669, o is double, false);
            Eval(2670, o is double[], false);
            Eval(2671, o is double?, false);
            Eval(2672, o is double?[], false);
            Eval(2673, o is decimal, false);
            Eval(2674, o is decimal[], false);
            Eval(2675, o is decimal?, false);
            Eval(2676, o is decimal?[], false);
            Eval(2677, o is object, true);
            Eval(2678, o is object[], false);
            Eval(2679, o is string, false);
            Eval(2680, o is string[], false);
            Eval(2681, o is ValueType, true);
            Eval(2682, o is ValueType[], false);
            Eval(2683, o is Array, false);
            Eval(2684, o is Array[], false);
            Eval(2685, o is Enum, false);
            Eval(2686, o is Enum[], false);
            Eval(2687, o is Delegate, false);
            Eval(2688, o is Delegate[], false);
            Eval(2689, o is MulticastDelegate, false);
            Eval(2690, o is MulticastDelegate[], false);
            Eval(2691, o is IEmpty, false);
            Eval(2692, o is IEmpty[], false);
            Eval(2693, o is INotEmpty, false);
            Eval(2694, o is INotEmpty[], false);
            Eval(2695, o is IEmptyGen<int>, false);
            Eval(2696, o is IEmptyGen<int>[], false);
            Eval(2697, o is INotEmptyGen<int>, false);
            Eval(2698, o is INotEmptyGen<int>[], false);
            Eval(2699, o is SimpleDelegate, false);
            Eval(2700, o is SimpleDelegate[], false);
            Eval(2701, o is GenericDelegate<int>, false);
            Eval(2702, o is GenericDelegate<int>[], false);
            Eval(2703, o is EmptyClass, false);
            Eval(2704, o is EmptyClass[], false);
            Eval(2705, o is NotEmptyClass, false);
            Eval(2706, o is NotEmptyClass[], false);
            Eval(2707, o is EmptyClassGen<int>, false);
            Eval(2708, o is EmptyClassGen<int>[], false);
            Eval(2709, o is NotEmptyClassGen<Guid>, false);
            Eval(2710, o is NotEmptyClassGen<Guid>[], false);
            Eval(2711, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2712, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2713, o is NestedClass, false);
            Eval(2714, o is NestedClass[], false);
            Eval(2715, o is NestedClassGen<Decimal>, false);
            Eval(2716, o is NestedClassGen<Decimal>[], false);
            Eval(2717, o is ImplementOneInterfaceC, false);
            Eval(2718, o is ImplementOneInterfaceC[], false);
            Eval(2719, o is ImplementTwoInterfaceC, false);
            Eval(2720, o is ImplementTwoInterfaceC[], false);
            Eval(2721, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2722, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2723, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2724, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2725, o is ImplementAllInterfaceC<int>, false);
            Eval(2726, o is ImplementAllInterfaceC<int>[], false);
            Eval(2727, o is SealedClass, false);
            Eval(2728, o is SealedClass[], false);
        }
        {
            byte? v = default(byte);
            IComparable o = v; ;
            Eval(2729, o is ImplementOneInterface, false);
            Eval(2730, o is ImplementOneInterface[], false);
            Eval(2731, o is ImplementOneInterface?, false);
            Eval(2732, o is ImplementOneInterface?[], false);
            Eval(2733, o is ImplementTwoInterface, false);
            Eval(2734, o is ImplementTwoInterface[], false);
            Eval(2735, o is ImplementTwoInterface?, false);
            Eval(2736, o is ImplementTwoInterface?[], false);
            Eval(2737, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2738, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2739, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2740, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2741, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2742, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2743, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2744, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2745, o is ImplementAllInterface<int>, false);
            Eval(2746, o is ImplementAllInterface<int>[], false);
            Eval(2747, o is ImplementAllInterface<int>?, false);
            Eval(2748, o is ImplementAllInterface<int>?[], false);
            Eval(2749, o is char, false);
            Eval(2750, o is char[], false);
            Eval(2751, o is char?, false);
            Eval(2752, o is char?[], false);
            Eval(2753, o is bool, false);
            Eval(2754, o is bool[], false);
            Eval(2755, o is bool?, false);
            Eval(2756, o is bool?[], false);
            Eval(2757, o is byte, true);
            Eval(2758, o is byte[], false);
            Eval(2759, o is byte?, true);
            Eval(2760, o is byte?[], false);
            Eval(2761, o is sbyte, false);
            Eval(2762, o is sbyte[], false);
            Eval(2763, o is sbyte?, false);
            Eval(2764, o is sbyte?[], false);
            Eval(2765, o is short, false);
            Eval(2766, o is short[], false);
            Eval(2767, o is short?, false);
            Eval(2768, o is short?[], false);
            Eval(2769, o is ushort, false);
            Eval(2770, o is ushort[], false);
            Eval(2771, o is ushort?, false);
            Eval(2772, o is ushort?[], false);
            Eval(2773, o is int, false);
            Eval(2774, o is int[], false);
            Eval(2775, o is int?, false);
            Eval(2776, o is int?[], false);
            Eval(2777, o is uint, false);
            Eval(2778, o is uint[], false);
            Eval(2779, o is uint?, false);
            Eval(2780, o is uint?[], false);
            Eval(2781, o is long, false);
            Eval(2782, o is long[], false);
            Eval(2783, o is long?, false);
            Eval(2784, o is long?[], false);
            Eval(2785, o is ulong, false);
            Eval(2786, o is ulong[], false);
            Eval(2787, o is ulong?, false);
            Eval(2788, o is ulong?[], false);
            Eval(2789, o is float, false);
            Eval(2790, o is float[], false);
            Eval(2791, o is float?, false);
            Eval(2792, o is float?[], false);
            Eval(2793, o is double, false);
            Eval(2794, o is double[], false);
            Eval(2795, o is double?, false);
            Eval(2796, o is double?[], false);
            Eval(2797, o is decimal, false);
            Eval(2798, o is decimal[], false);
            Eval(2799, o is decimal?, false);
            Eval(2800, o is decimal?[], false);
            Eval(2801, o is object, true);
            Eval(2802, o is object[], false);
            Eval(2803, o is string, false);
            Eval(2804, o is string[], false);
            Eval(2805, o is ValueType, true);
            Eval(2806, o is ValueType[], false);
            Eval(2807, o is Array, false);
            Eval(2808, o is Array[], false);
            Eval(2809, o is Enum, false);
            Eval(2810, o is Enum[], false);
            Eval(2811, o is Delegate, false);
            Eval(2812, o is Delegate[], false);
            Eval(2813, o is MulticastDelegate, false);
            Eval(2814, o is MulticastDelegate[], false);
            Eval(2815, o is IEmpty, false);
            Eval(2816, o is IEmpty[], false);
            Eval(2817, o is INotEmpty, false);
            Eval(2818, o is INotEmpty[], false);
            Eval(2819, o is IEmptyGen<int>, false);
            Eval(2820, o is IEmptyGen<int>[], false);
            Eval(2821, o is INotEmptyGen<int>, false);
            Eval(2822, o is INotEmptyGen<int>[], false);
            Eval(2823, o is SimpleDelegate, false);
            Eval(2824, o is SimpleDelegate[], false);
            Eval(2825, o is GenericDelegate<int>, false);
            Eval(2826, o is GenericDelegate<int>[], false);
            Eval(2827, o is EmptyClass, false);
            Eval(2828, o is EmptyClass[], false);
            Eval(2829, o is NotEmptyClass, false);
            Eval(2830, o is NotEmptyClass[], false);
            Eval(2831, o is EmptyClassGen<int>, false);
            Eval(2832, o is EmptyClassGen<int>[], false);
            Eval(2833, o is NotEmptyClassGen<Guid>, false);
            Eval(2834, o is NotEmptyClassGen<Guid>[], false);
            Eval(2835, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2836, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2837, o is NestedClass, false);
            Eval(2838, o is NestedClass[], false);
            Eval(2839, o is NestedClassGen<Decimal>, false);
            Eval(2840, o is NestedClassGen<Decimal>[], false);
            Eval(2841, o is ImplementOneInterfaceC, false);
            Eval(2842, o is ImplementOneInterfaceC[], false);
            Eval(2843, o is ImplementTwoInterfaceC, false);
            Eval(2844, o is ImplementTwoInterfaceC[], false);
            Eval(2845, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2846, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2847, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2848, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2849, o is ImplementAllInterfaceC<int>, false);
            Eval(2850, o is ImplementAllInterfaceC<int>[], false);
            Eval(2851, o is SealedClass, false);
            Eval(2852, o is SealedClass[], false);
        }
        {
            byte? v = default(byte?);
            IComparable o = v; ;
            Eval(2853, o is ImplementOneInterface, false);
            Eval(2854, o is ImplementOneInterface[], false);
            Eval(2855, o is ImplementOneInterface?, false);
            Eval(2856, o is ImplementOneInterface?[], false);
            Eval(2857, o is ImplementTwoInterface, false);
            Eval(2858, o is ImplementTwoInterface[], false);
            Eval(2859, o is ImplementTwoInterface?, false);
            Eval(2860, o is ImplementTwoInterface?[], false);
            Eval(2861, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2862, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2863, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2864, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2865, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2866, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2867, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2868, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2869, o is ImplementAllInterface<int>, false);
            Eval(2870, o is ImplementAllInterface<int>[], false);
            Eval(2871, o is ImplementAllInterface<int>?, false);
            Eval(2872, o is ImplementAllInterface<int>?[], false);
            Eval(2873, o is char, false);
            Eval(2874, o is char[], false);
            Eval(2875, o is char?, false);
            Eval(2876, o is char?[], false);
            Eval(2877, o is bool, false);
            Eval(2878, o is bool[], false);
            Eval(2879, o is bool?, false);
            Eval(2880, o is bool?[], false);
            Eval(2881, o is byte, false);
            Eval(2882, o is byte[], false);
            Eval(2883, o is byte?, false);
            Eval(2884, o is byte?[], false);
            Eval(2885, o is sbyte, false);
            Eval(2886, o is sbyte[], false);
            Eval(2887, o is sbyte?, false);
            Eval(2888, o is sbyte?[], false);
            Eval(2889, o is short, false);
            Eval(2890, o is short[], false);
            Eval(2891, o is short?, false);
            Eval(2892, o is short?[], false);
            Eval(2893, o is ushort, false);
            Eval(2894, o is ushort[], false);
            Eval(2895, o is ushort?, false);
            Eval(2896, o is ushort?[], false);
            Eval(2897, o is int, false);
            Eval(2898, o is int[], false);
            Eval(2899, o is int?, false);
            Eval(2900, o is int?[], false);
            Eval(2901, o is uint, false);
            Eval(2902, o is uint[], false);
            Eval(2903, o is uint?, false);
            Eval(2904, o is uint?[], false);
            Eval(2905, o is long, false);
            Eval(2906, o is long[], false);
            Eval(2907, o is long?, false);
            Eval(2908, o is long?[], false);
            Eval(2909, o is ulong, false);
            Eval(2910, o is ulong[], false);
            Eval(2911, o is ulong?, false);
            Eval(2912, o is ulong?[], false);
            Eval(2913, o is float, false);
            Eval(2914, o is float[], false);
            Eval(2915, o is float?, false);
            Eval(2916, o is float?[], false);
            Eval(2917, o is double, false);
            Eval(2918, o is double[], false);
            Eval(2919, o is double?, false);
            Eval(2920, o is double?[], false);
            Eval(2921, o is decimal, false);
            Eval(2922, o is decimal[], false);
            Eval(2923, o is decimal?, false);
            Eval(2924, o is decimal?[], false);
            Eval(2925, o is object, false);
            Eval(2926, o is object[], false);
            Eval(2927, o is string, false);
            Eval(2928, o is string[], false);
            Eval(2929, o is ValueType, false);
            Eval(2930, o is ValueType[], false);
            Eval(2931, o is Array, false);
            Eval(2932, o is Array[], false);
            Eval(2933, o is Enum, false);
            Eval(2934, o is Enum[], false);
            Eval(2935, o is Delegate, false);
            Eval(2936, o is Delegate[], false);
            Eval(2937, o is MulticastDelegate, false);
            Eval(2938, o is MulticastDelegate[], false);
            Eval(2939, o is IEmpty, false);
            Eval(2940, o is IEmpty[], false);
            Eval(2941, o is INotEmpty, false);
            Eval(2942, o is INotEmpty[], false);
            Eval(2943, o is IEmptyGen<int>, false);
            Eval(2944, o is IEmptyGen<int>[], false);
            Eval(2945, o is INotEmptyGen<int>, false);
            Eval(2946, o is INotEmptyGen<int>[], false);
            Eval(2947, o is SimpleDelegate, false);
            Eval(2948, o is SimpleDelegate[], false);
            Eval(2949, o is GenericDelegate<int>, false);
            Eval(2950, o is GenericDelegate<int>[], false);
            Eval(2951, o is EmptyClass, false);
            Eval(2952, o is EmptyClass[], false);
            Eval(2953, o is NotEmptyClass, false);
            Eval(2954, o is NotEmptyClass[], false);
            Eval(2955, o is EmptyClassGen<int>, false);
            Eval(2956, o is EmptyClassGen<int>[], false);
            Eval(2957, o is NotEmptyClassGen<Guid>, false);
            Eval(2958, o is NotEmptyClassGen<Guid>[], false);
            Eval(2959, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(2960, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(2961, o is NestedClass, false);
            Eval(2962, o is NestedClass[], false);
            Eval(2963, o is NestedClassGen<Decimal>, false);
            Eval(2964, o is NestedClassGen<Decimal>[], false);
            Eval(2965, o is ImplementOneInterfaceC, false);
            Eval(2966, o is ImplementOneInterfaceC[], false);
            Eval(2967, o is ImplementTwoInterfaceC, false);
            Eval(2968, o is ImplementTwoInterfaceC[], false);
            Eval(2969, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(2970, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(2971, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(2972, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(2973, o is ImplementAllInterfaceC<int>, false);
            Eval(2974, o is ImplementAllInterfaceC<int>[], false);
            Eval(2975, o is SealedClass, false);
            Eval(2976, o is SealedClass[], false);
        }
    }  // end of test case 0008
    private static void TestCase0009()
    {
        {
            sbyte v = default(sbyte);
            IComparable o = v; ;
            Eval(2977, o is ImplementOneInterface, false);
            Eval(2978, o is ImplementOneInterface[], false);
            Eval(2979, o is ImplementOneInterface?, false);
            Eval(2980, o is ImplementOneInterface?[], false);
            Eval(2981, o is ImplementTwoInterface, false);
            Eval(2982, o is ImplementTwoInterface[], false);
            Eval(2983, o is ImplementTwoInterface?, false);
            Eval(2984, o is ImplementTwoInterface?[], false);
            Eval(2985, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(2986, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(2987, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(2988, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(2989, o is ImplementTwoInterfaceGen<int>, false);
            Eval(2990, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(2991, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(2992, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(2993, o is ImplementAllInterface<int>, false);
            Eval(2994, o is ImplementAllInterface<int>[], false);
            Eval(2995, o is ImplementAllInterface<int>?, false);
            Eval(2996, o is ImplementAllInterface<int>?[], false);
            Eval(2997, o is char, false);
            Eval(2998, o is char[], false);
            Eval(2999, o is char?, false);
            Eval(3000, o is char?[], false);
            Eval(3001, o is bool, false);
            Eval(3002, o is bool[], false);
            Eval(3003, o is bool?, false);
            Eval(3004, o is bool?[], false);
            Eval(3005, o is byte, false);
            Eval(3006, o is byte[], false);
            Eval(3007, o is byte?, false);
            Eval(3008, o is byte?[], false);
            Eval(3009, o is sbyte, true);
            Eval(3010, o is sbyte[], false);
            Eval(3011, o is sbyte?, true);
            Eval(3012, o is sbyte?[], false);
            Eval(3013, o is short, false);
            Eval(3014, o is short[], false);
            Eval(3015, o is short?, false);
            Eval(3016, o is short?[], false);
            Eval(3017, o is ushort, false);
            Eval(3018, o is ushort[], false);
            Eval(3019, o is ushort?, false);
            Eval(3020, o is ushort?[], false);
            Eval(3021, o is int, false);
            Eval(3022, o is int[], false);
            Eval(3023, o is int?, false);
            Eval(3024, o is int?[], false);
            Eval(3025, o is uint, false);
            Eval(3026, o is uint[], false);
            Eval(3027, o is uint?, false);
            Eval(3028, o is uint?[], false);
            Eval(3029, o is long, false);
            Eval(3030, o is long[], false);
            Eval(3031, o is long?, false);
            Eval(3032, o is long?[], false);
            Eval(3033, o is ulong, false);
            Eval(3034, o is ulong[], false);
            Eval(3035, o is ulong?, false);
            Eval(3036, o is ulong?[], false);
            Eval(3037, o is float, false);
            Eval(3038, o is float[], false);
            Eval(3039, o is float?, false);
            Eval(3040, o is float?[], false);
            Eval(3041, o is double, false);
            Eval(3042, o is double[], false);
            Eval(3043, o is double?, false);
            Eval(3044, o is double?[], false);
            Eval(3045, o is decimal, false);
            Eval(3046, o is decimal[], false);
            Eval(3047, o is decimal?, false);
            Eval(3048, o is decimal?[], false);
            Eval(3049, o is object, true);
            Eval(3050, o is object[], false);
            Eval(3051, o is string, false);
            Eval(3052, o is string[], false);
            Eval(3053, o is ValueType, true);
            Eval(3054, o is ValueType[], false);
            Eval(3055, o is Array, false);
            Eval(3056, o is Array[], false);
            Eval(3057, o is Enum, false);
            Eval(3058, o is Enum[], false);
            Eval(3059, o is Delegate, false);
            Eval(3060, o is Delegate[], false);
            Eval(3061, o is MulticastDelegate, false);
            Eval(3062, o is MulticastDelegate[], false);
            Eval(3063, o is IEmpty, false);
            Eval(3064, o is IEmpty[], false);
            Eval(3065, o is INotEmpty, false);
            Eval(3066, o is INotEmpty[], false);
            Eval(3067, o is IEmptyGen<int>, false);
            Eval(3068, o is IEmptyGen<int>[], false);
            Eval(3069, o is INotEmptyGen<int>, false);
            Eval(3070, o is INotEmptyGen<int>[], false);
            Eval(3071, o is SimpleDelegate, false);
            Eval(3072, o is SimpleDelegate[], false);
            Eval(3073, o is GenericDelegate<int>, false);
            Eval(3074, o is GenericDelegate<int>[], false);
            Eval(3075, o is EmptyClass, false);
            Eval(3076, o is EmptyClass[], false);
            Eval(3077, o is NotEmptyClass, false);
            Eval(3078, o is NotEmptyClass[], false);
            Eval(3079, o is EmptyClassGen<int>, false);
            Eval(3080, o is EmptyClassGen<int>[], false);
            Eval(3081, o is NotEmptyClassGen<Guid>, false);
            Eval(3082, o is NotEmptyClassGen<Guid>[], false);
            Eval(3083, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3084, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3085, o is NestedClass, false);
            Eval(3086, o is NestedClass[], false);
            Eval(3087, o is NestedClassGen<Decimal>, false);
            Eval(3088, o is NestedClassGen<Decimal>[], false);
            Eval(3089, o is ImplementOneInterfaceC, false);
            Eval(3090, o is ImplementOneInterfaceC[], false);
            Eval(3091, o is ImplementTwoInterfaceC, false);
            Eval(3092, o is ImplementTwoInterfaceC[], false);
            Eval(3093, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3094, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3095, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3096, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3097, o is ImplementAllInterfaceC<int>, false);
            Eval(3098, o is ImplementAllInterfaceC<int>[], false);
            Eval(3099, o is SealedClass, false);
            Eval(3100, o is SealedClass[], false);
        }
        {
            sbyte? v = default(sbyte);
            IComparable o = v; ;
            Eval(3101, o is ImplementOneInterface, false);
            Eval(3102, o is ImplementOneInterface[], false);
            Eval(3103, o is ImplementOneInterface?, false);
            Eval(3104, o is ImplementOneInterface?[], false);
            Eval(3105, o is ImplementTwoInterface, false);
            Eval(3106, o is ImplementTwoInterface[], false);
            Eval(3107, o is ImplementTwoInterface?, false);
            Eval(3108, o is ImplementTwoInterface?[], false);
            Eval(3109, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3110, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3111, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3112, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3113, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3114, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3115, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3116, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3117, o is ImplementAllInterface<int>, false);
            Eval(3118, o is ImplementAllInterface<int>[], false);
            Eval(3119, o is ImplementAllInterface<int>?, false);
            Eval(3120, o is ImplementAllInterface<int>?[], false);
            Eval(3121, o is char, false);
            Eval(3122, o is char[], false);
            Eval(3123, o is char?, false);
            Eval(3124, o is char?[], false);
            Eval(3125, o is bool, false);
            Eval(3126, o is bool[], false);
            Eval(3127, o is bool?, false);
            Eval(3128, o is bool?[], false);
            Eval(3129, o is byte, false);
            Eval(3130, o is byte[], false);
            Eval(3131, o is byte?, false);
            Eval(3132, o is byte?[], false);
            Eval(3133, o is sbyte, true);
            Eval(3134, o is sbyte[], false);
            Eval(3135, o is sbyte?, true);
            Eval(3136, o is sbyte?[], false);
            Eval(3137, o is short, false);
            Eval(3138, o is short[], false);
            Eval(3139, o is short?, false);
            Eval(3140, o is short?[], false);
            Eval(3141, o is ushort, false);
            Eval(3142, o is ushort[], false);
            Eval(3143, o is ushort?, false);
            Eval(3144, o is ushort?[], false);
            Eval(3145, o is int, false);
            Eval(3146, o is int[], false);
            Eval(3147, o is int?, false);
            Eval(3148, o is int?[], false);
            Eval(3149, o is uint, false);
            Eval(3150, o is uint[], false);
            Eval(3151, o is uint?, false);
            Eval(3152, o is uint?[], false);
            Eval(3153, o is long, false);
            Eval(3154, o is long[], false);
            Eval(3155, o is long?, false);
            Eval(3156, o is long?[], false);
            Eval(3157, o is ulong, false);
            Eval(3158, o is ulong[], false);
            Eval(3159, o is ulong?, false);
            Eval(3160, o is ulong?[], false);
            Eval(3161, o is float, false);
            Eval(3162, o is float[], false);
            Eval(3163, o is float?, false);
            Eval(3164, o is float?[], false);
            Eval(3165, o is double, false);
            Eval(3166, o is double[], false);
            Eval(3167, o is double?, false);
            Eval(3168, o is double?[], false);
            Eval(3169, o is decimal, false);
            Eval(3170, o is decimal[], false);
            Eval(3171, o is decimal?, false);
            Eval(3172, o is decimal?[], false);
            Eval(3173, o is object, true);
            Eval(3174, o is object[], false);
            Eval(3175, o is string, false);
            Eval(3176, o is string[], false);
            Eval(3177, o is ValueType, true);
            Eval(3178, o is ValueType[], false);
            Eval(3179, o is Array, false);
            Eval(3180, o is Array[], false);
            Eval(3181, o is Enum, false);
            Eval(3182, o is Enum[], false);
            Eval(3183, o is Delegate, false);
            Eval(3184, o is Delegate[], false);
            Eval(3185, o is MulticastDelegate, false);
            Eval(3186, o is MulticastDelegate[], false);
            Eval(3187, o is IEmpty, false);
            Eval(3188, o is IEmpty[], false);
            Eval(3189, o is INotEmpty, false);
            Eval(3190, o is INotEmpty[], false);
            Eval(3191, o is IEmptyGen<int>, false);
            Eval(3192, o is IEmptyGen<int>[], false);
            Eval(3193, o is INotEmptyGen<int>, false);
            Eval(3194, o is INotEmptyGen<int>[], false);
            Eval(3195, o is SimpleDelegate, false);
            Eval(3196, o is SimpleDelegate[], false);
            Eval(3197, o is GenericDelegate<int>, false);
            Eval(3198, o is GenericDelegate<int>[], false);
            Eval(3199, o is EmptyClass, false);
            Eval(3200, o is EmptyClass[], false);
            Eval(3201, o is NotEmptyClass, false);
            Eval(3202, o is NotEmptyClass[], false);
            Eval(3203, o is EmptyClassGen<int>, false);
            Eval(3204, o is EmptyClassGen<int>[], false);
            Eval(3205, o is NotEmptyClassGen<Guid>, false);
            Eval(3206, o is NotEmptyClassGen<Guid>[], false);
            Eval(3207, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3208, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3209, o is NestedClass, false);
            Eval(3210, o is NestedClass[], false);
            Eval(3211, o is NestedClassGen<Decimal>, false);
            Eval(3212, o is NestedClassGen<Decimal>[], false);
            Eval(3213, o is ImplementOneInterfaceC, false);
            Eval(3214, o is ImplementOneInterfaceC[], false);
            Eval(3215, o is ImplementTwoInterfaceC, false);
            Eval(3216, o is ImplementTwoInterfaceC[], false);
            Eval(3217, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3218, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3219, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3220, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3221, o is ImplementAllInterfaceC<int>, false);
            Eval(3222, o is ImplementAllInterfaceC<int>[], false);
            Eval(3223, o is SealedClass, false);
            Eval(3224, o is SealedClass[], false);
        }
        {
            sbyte? v = default(sbyte?);
            IComparable o = v; ;
            Eval(3225, o is ImplementOneInterface, false);
            Eval(3226, o is ImplementOneInterface[], false);
            Eval(3227, o is ImplementOneInterface?, false);
            Eval(3228, o is ImplementOneInterface?[], false);
            Eval(3229, o is ImplementTwoInterface, false);
            Eval(3230, o is ImplementTwoInterface[], false);
            Eval(3231, o is ImplementTwoInterface?, false);
            Eval(3232, o is ImplementTwoInterface?[], false);
            Eval(3233, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3234, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3235, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3236, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3237, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3238, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3239, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3240, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3241, o is ImplementAllInterface<int>, false);
            Eval(3242, o is ImplementAllInterface<int>[], false);
            Eval(3243, o is ImplementAllInterface<int>?, false);
            Eval(3244, o is ImplementAllInterface<int>?[], false);
            Eval(3245, o is char, false);
            Eval(3246, o is char[], false);
            Eval(3247, o is char?, false);
            Eval(3248, o is char?[], false);
            Eval(3249, o is bool, false);
            Eval(3250, o is bool[], false);
            Eval(3251, o is bool?, false);
            Eval(3252, o is bool?[], false);
            Eval(3253, o is byte, false);
            Eval(3254, o is byte[], false);
            Eval(3255, o is byte?, false);
            Eval(3256, o is byte?[], false);
            Eval(3257, o is sbyte, false);
            Eval(3258, o is sbyte[], false);
            Eval(3259, o is sbyte?, false);
            Eval(3260, o is sbyte?[], false);
            Eval(3261, o is short, false);
            Eval(3262, o is short[], false);
            Eval(3263, o is short?, false);
            Eval(3264, o is short?[], false);
            Eval(3265, o is ushort, false);
            Eval(3266, o is ushort[], false);
            Eval(3267, o is ushort?, false);
            Eval(3268, o is ushort?[], false);
            Eval(3269, o is int, false);
            Eval(3270, o is int[], false);
            Eval(3271, o is int?, false);
            Eval(3272, o is int?[], false);
            Eval(3273, o is uint, false);
            Eval(3274, o is uint[], false);
            Eval(3275, o is uint?, false);
            Eval(3276, o is uint?[], false);
            Eval(3277, o is long, false);
            Eval(3278, o is long[], false);
            Eval(3279, o is long?, false);
            Eval(3280, o is long?[], false);
            Eval(3281, o is ulong, false);
            Eval(3282, o is ulong[], false);
            Eval(3283, o is ulong?, false);
            Eval(3284, o is ulong?[], false);
            Eval(3285, o is float, false);
            Eval(3286, o is float[], false);
            Eval(3287, o is float?, false);
            Eval(3288, o is float?[], false);
            Eval(3289, o is double, false);
            Eval(3290, o is double[], false);
            Eval(3291, o is double?, false);
            Eval(3292, o is double?[], false);
            Eval(3293, o is decimal, false);
            Eval(3294, o is decimal[], false);
            Eval(3295, o is decimal?, false);
            Eval(3296, o is decimal?[], false);
            Eval(3297, o is object, false);
            Eval(3298, o is object[], false);
            Eval(3299, o is string, false);
            Eval(3300, o is string[], false);
            Eval(3301, o is ValueType, false);
            Eval(3302, o is ValueType[], false);
            Eval(3303, o is Array, false);
            Eval(3304, o is Array[], false);
            Eval(3305, o is Enum, false);
            Eval(3306, o is Enum[], false);
            Eval(3307, o is Delegate, false);
            Eval(3308, o is Delegate[], false);
            Eval(3309, o is MulticastDelegate, false);
            Eval(3310, o is MulticastDelegate[], false);
            Eval(3311, o is IEmpty, false);
            Eval(3312, o is IEmpty[], false);
            Eval(3313, o is INotEmpty, false);
            Eval(3314, o is INotEmpty[], false);
            Eval(3315, o is IEmptyGen<int>, false);
            Eval(3316, o is IEmptyGen<int>[], false);
            Eval(3317, o is INotEmptyGen<int>, false);
            Eval(3318, o is INotEmptyGen<int>[], false);
            Eval(3319, o is SimpleDelegate, false);
            Eval(3320, o is SimpleDelegate[], false);
            Eval(3321, o is GenericDelegate<int>, false);
            Eval(3322, o is GenericDelegate<int>[], false);
            Eval(3323, o is EmptyClass, false);
            Eval(3324, o is EmptyClass[], false);
            Eval(3325, o is NotEmptyClass, false);
            Eval(3326, o is NotEmptyClass[], false);
            Eval(3327, o is EmptyClassGen<int>, false);
            Eval(3328, o is EmptyClassGen<int>[], false);
            Eval(3329, o is NotEmptyClassGen<Guid>, false);
            Eval(3330, o is NotEmptyClassGen<Guid>[], false);
            Eval(3331, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3332, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3333, o is NestedClass, false);
            Eval(3334, o is NestedClass[], false);
            Eval(3335, o is NestedClassGen<Decimal>, false);
            Eval(3336, o is NestedClassGen<Decimal>[], false);
            Eval(3337, o is ImplementOneInterfaceC, false);
            Eval(3338, o is ImplementOneInterfaceC[], false);
            Eval(3339, o is ImplementTwoInterfaceC, false);
            Eval(3340, o is ImplementTwoInterfaceC[], false);
            Eval(3341, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3342, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3343, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3344, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3345, o is ImplementAllInterfaceC<int>, false);
            Eval(3346, o is ImplementAllInterfaceC<int>[], false);
            Eval(3347, o is SealedClass, false);
            Eval(3348, o is SealedClass[], false);
        }
    }  // end of test case 0009
    private static void TestCase0010()
    {
        {
            short v = default(short);
            IComparable o = v; ;
            Eval(3349, o is ImplementOneInterface, false);
            Eval(3350, o is ImplementOneInterface[], false);
            Eval(3351, o is ImplementOneInterface?, false);
            Eval(3352, o is ImplementOneInterface?[], false);
            Eval(3353, o is ImplementTwoInterface, false);
            Eval(3354, o is ImplementTwoInterface[], false);
            Eval(3355, o is ImplementTwoInterface?, false);
            Eval(3356, o is ImplementTwoInterface?[], false);
            Eval(3357, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3358, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3359, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3360, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3361, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3362, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3363, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3364, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3365, o is ImplementAllInterface<int>, false);
            Eval(3366, o is ImplementAllInterface<int>[], false);
            Eval(3367, o is ImplementAllInterface<int>?, false);
            Eval(3368, o is ImplementAllInterface<int>?[], false);
            Eval(3369, o is char, false);
            Eval(3370, o is char[], false);
            Eval(3371, o is char?, false);
            Eval(3372, o is char?[], false);
            Eval(3373, o is bool, false);
            Eval(3374, o is bool[], false);
            Eval(3375, o is bool?, false);
            Eval(3376, o is bool?[], false);
            Eval(3377, o is byte, false);
            Eval(3378, o is byte[], false);
            Eval(3379, o is byte?, false);
            Eval(3380, o is byte?[], false);
            Eval(3381, o is sbyte, false);
            Eval(3382, o is sbyte[], false);
            Eval(3383, o is sbyte?, false);
            Eval(3384, o is sbyte?[], false);
            Eval(3385, o is short, true);
            Eval(3386, o is short[], false);
            Eval(3387, o is short?, true);
            Eval(3388, o is short?[], false);
            Eval(3389, o is ushort, false);
            Eval(3390, o is ushort[], false);
            Eval(3391, o is ushort?, false);
            Eval(3392, o is ushort?[], false);
            Eval(3393, o is int, false);
            Eval(3394, o is int[], false);
            Eval(3395, o is int?, false);
            Eval(3396, o is int?[], false);
            Eval(3397, o is uint, false);
            Eval(3398, o is uint[], false);
            Eval(3399, o is uint?, false);
            Eval(3400, o is uint?[], false);
            Eval(3401, o is long, false);
            Eval(3402, o is long[], false);
            Eval(3403, o is long?, false);
            Eval(3404, o is long?[], false);
            Eval(3405, o is ulong, false);
            Eval(3406, o is ulong[], false);
            Eval(3407, o is ulong?, false);
            Eval(3408, o is ulong?[], false);
            Eval(3409, o is float, false);
            Eval(3410, o is float[], false);
            Eval(3411, o is float?, false);
            Eval(3412, o is float?[], false);
            Eval(3413, o is double, false);
            Eval(3414, o is double[], false);
            Eval(3415, o is double?, false);
            Eval(3416, o is double?[], false);
            Eval(3417, o is decimal, false);
            Eval(3418, o is decimal[], false);
            Eval(3419, o is decimal?, false);
            Eval(3420, o is decimal?[], false);
            Eval(3421, o is object, true);
            Eval(3422, o is object[], false);
            Eval(3423, o is string, false);
            Eval(3424, o is string[], false);
            Eval(3425, o is ValueType, true);
            Eval(3426, o is ValueType[], false);
            Eval(3427, o is Array, false);
            Eval(3428, o is Array[], false);
            Eval(3429, o is Enum, false);
            Eval(3430, o is Enum[], false);
            Eval(3431, o is Delegate, false);
            Eval(3432, o is Delegate[], false);
            Eval(3433, o is MulticastDelegate, false);
            Eval(3434, o is MulticastDelegate[], false);
            Eval(3435, o is IEmpty, false);
            Eval(3436, o is IEmpty[], false);
            Eval(3437, o is INotEmpty, false);
            Eval(3438, o is INotEmpty[], false);
            Eval(3439, o is IEmptyGen<int>, false);
            Eval(3440, o is IEmptyGen<int>[], false);
            Eval(3441, o is INotEmptyGen<int>, false);
            Eval(3442, o is INotEmptyGen<int>[], false);
            Eval(3443, o is SimpleDelegate, false);
            Eval(3444, o is SimpleDelegate[], false);
            Eval(3445, o is GenericDelegate<int>, false);
            Eval(3446, o is GenericDelegate<int>[], false);
            Eval(3447, o is EmptyClass, false);
            Eval(3448, o is EmptyClass[], false);
            Eval(3449, o is NotEmptyClass, false);
            Eval(3450, o is NotEmptyClass[], false);
            Eval(3451, o is EmptyClassGen<int>, false);
            Eval(3452, o is EmptyClassGen<int>[], false);
            Eval(3453, o is NotEmptyClassGen<Guid>, false);
            Eval(3454, o is NotEmptyClassGen<Guid>[], false);
            Eval(3455, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3456, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3457, o is NestedClass, false);
            Eval(3458, o is NestedClass[], false);
            Eval(3459, o is NestedClassGen<Decimal>, false);
            Eval(3460, o is NestedClassGen<Decimal>[], false);
            Eval(3461, o is ImplementOneInterfaceC, false);
            Eval(3462, o is ImplementOneInterfaceC[], false);
            Eval(3463, o is ImplementTwoInterfaceC, false);
            Eval(3464, o is ImplementTwoInterfaceC[], false);
            Eval(3465, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3466, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3467, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3468, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3469, o is ImplementAllInterfaceC<int>, false);
            Eval(3470, o is ImplementAllInterfaceC<int>[], false);
            Eval(3471, o is SealedClass, false);
            Eval(3472, o is SealedClass[], false);
        }
        {
            short? v = default(short);
            IComparable o = v; ;
            Eval(3473, o is ImplementOneInterface, false);
            Eval(3474, o is ImplementOneInterface[], false);
            Eval(3475, o is ImplementOneInterface?, false);
            Eval(3476, o is ImplementOneInterface?[], false);
            Eval(3477, o is ImplementTwoInterface, false);
            Eval(3478, o is ImplementTwoInterface[], false);
            Eval(3479, o is ImplementTwoInterface?, false);
            Eval(3480, o is ImplementTwoInterface?[], false);
            Eval(3481, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3482, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3483, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3484, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3485, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3486, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3487, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3488, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3489, o is ImplementAllInterface<int>, false);
            Eval(3490, o is ImplementAllInterface<int>[], false);
            Eval(3491, o is ImplementAllInterface<int>?, false);
            Eval(3492, o is ImplementAllInterface<int>?[], false);
            Eval(3493, o is char, false);
            Eval(3494, o is char[], false);
            Eval(3495, o is char?, false);
            Eval(3496, o is char?[], false);
            Eval(3497, o is bool, false);
            Eval(3498, o is bool[], false);
            Eval(3499, o is bool?, false);
            Eval(3500, o is bool?[], false);
            Eval(3501, o is byte, false);
            Eval(3502, o is byte[], false);
            Eval(3503, o is byte?, false);
            Eval(3504, o is byte?[], false);
            Eval(3505, o is sbyte, false);
            Eval(3506, o is sbyte[], false);
            Eval(3507, o is sbyte?, false);
            Eval(3508, o is sbyte?[], false);
            Eval(3509, o is short, true);
            Eval(3510, o is short[], false);
            Eval(3511, o is short?, true);
            Eval(3512, o is short?[], false);
            Eval(3513, o is ushort, false);
            Eval(3514, o is ushort[], false);
            Eval(3515, o is ushort?, false);
            Eval(3516, o is ushort?[], false);
            Eval(3517, o is int, false);
            Eval(3518, o is int[], false);
            Eval(3519, o is int?, false);
            Eval(3520, o is int?[], false);
            Eval(3521, o is uint, false);
            Eval(3522, o is uint[], false);
            Eval(3523, o is uint?, false);
            Eval(3524, o is uint?[], false);
            Eval(3525, o is long, false);
            Eval(3526, o is long[], false);
            Eval(3527, o is long?, false);
            Eval(3528, o is long?[], false);
            Eval(3529, o is ulong, false);
            Eval(3530, o is ulong[], false);
            Eval(3531, o is ulong?, false);
            Eval(3532, o is ulong?[], false);
            Eval(3533, o is float, false);
            Eval(3534, o is float[], false);
            Eval(3535, o is float?, false);
            Eval(3536, o is float?[], false);
            Eval(3537, o is double, false);
            Eval(3538, o is double[], false);
            Eval(3539, o is double?, false);
            Eval(3540, o is double?[], false);
            Eval(3541, o is decimal, false);
            Eval(3542, o is decimal[], false);
            Eval(3543, o is decimal?, false);
            Eval(3544, o is decimal?[], false);
            Eval(3545, o is object, true);
            Eval(3546, o is object[], false);
            Eval(3547, o is string, false);
            Eval(3548, o is string[], false);
            Eval(3549, o is ValueType, true);
            Eval(3550, o is ValueType[], false);
            Eval(3551, o is Array, false);
            Eval(3552, o is Array[], false);
            Eval(3553, o is Enum, false);
            Eval(3554, o is Enum[], false);
            Eval(3555, o is Delegate, false);
            Eval(3556, o is Delegate[], false);
            Eval(3557, o is MulticastDelegate, false);
            Eval(3558, o is MulticastDelegate[], false);
            Eval(3559, o is IEmpty, false);
            Eval(3560, o is IEmpty[], false);
            Eval(3561, o is INotEmpty, false);
            Eval(3562, o is INotEmpty[], false);
            Eval(3563, o is IEmptyGen<int>, false);
            Eval(3564, o is IEmptyGen<int>[], false);
            Eval(3565, o is INotEmptyGen<int>, false);
            Eval(3566, o is INotEmptyGen<int>[], false);
            Eval(3567, o is SimpleDelegate, false);
            Eval(3568, o is SimpleDelegate[], false);
            Eval(3569, o is GenericDelegate<int>, false);
            Eval(3570, o is GenericDelegate<int>[], false);
            Eval(3571, o is EmptyClass, false);
            Eval(3572, o is EmptyClass[], false);
            Eval(3573, o is NotEmptyClass, false);
            Eval(3574, o is NotEmptyClass[], false);
            Eval(3575, o is EmptyClassGen<int>, false);
            Eval(3576, o is EmptyClassGen<int>[], false);
            Eval(3577, o is NotEmptyClassGen<Guid>, false);
            Eval(3578, o is NotEmptyClassGen<Guid>[], false);
            Eval(3579, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3580, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3581, o is NestedClass, false);
            Eval(3582, o is NestedClass[], false);
            Eval(3583, o is NestedClassGen<Decimal>, false);
            Eval(3584, o is NestedClassGen<Decimal>[], false);
            Eval(3585, o is ImplementOneInterfaceC, false);
            Eval(3586, o is ImplementOneInterfaceC[], false);
            Eval(3587, o is ImplementTwoInterfaceC, false);
            Eval(3588, o is ImplementTwoInterfaceC[], false);
            Eval(3589, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3590, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3591, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3592, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3593, o is ImplementAllInterfaceC<int>, false);
            Eval(3594, o is ImplementAllInterfaceC<int>[], false);
            Eval(3595, o is SealedClass, false);
            Eval(3596, o is SealedClass[], false);
        }
        {
            short? v = default(short?);
            IComparable o = v; ;
            Eval(3597, o is ImplementOneInterface, false);
            Eval(3598, o is ImplementOneInterface[], false);
            Eval(3599, o is ImplementOneInterface?, false);
            Eval(3600, o is ImplementOneInterface?[], false);
            Eval(3601, o is ImplementTwoInterface, false);
            Eval(3602, o is ImplementTwoInterface[], false);
            Eval(3603, o is ImplementTwoInterface?, false);
            Eval(3604, o is ImplementTwoInterface?[], false);
            Eval(3605, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3606, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3607, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3608, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3609, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3610, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3611, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3612, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3613, o is ImplementAllInterface<int>, false);
            Eval(3614, o is ImplementAllInterface<int>[], false);
            Eval(3615, o is ImplementAllInterface<int>?, false);
            Eval(3616, o is ImplementAllInterface<int>?[], false);
            Eval(3617, o is char, false);
            Eval(3618, o is char[], false);
            Eval(3619, o is char?, false);
            Eval(3620, o is char?[], false);
            Eval(3621, o is bool, false);
            Eval(3622, o is bool[], false);
            Eval(3623, o is bool?, false);
            Eval(3624, o is bool?[], false);
            Eval(3625, o is byte, false);
            Eval(3626, o is byte[], false);
            Eval(3627, o is byte?, false);
            Eval(3628, o is byte?[], false);
            Eval(3629, o is sbyte, false);
            Eval(3630, o is sbyte[], false);
            Eval(3631, o is sbyte?, false);
            Eval(3632, o is sbyte?[], false);
            Eval(3633, o is short, false);
            Eval(3634, o is short[], false);
            Eval(3635, o is short?, false);
            Eval(3636, o is short?[], false);
            Eval(3637, o is ushort, false);
            Eval(3638, o is ushort[], false);
            Eval(3639, o is ushort?, false);
            Eval(3640, o is ushort?[], false);
            Eval(3641, o is int, false);
            Eval(3642, o is int[], false);
            Eval(3643, o is int?, false);
            Eval(3644, o is int?[], false);
            Eval(3645, o is uint, false);
            Eval(3646, o is uint[], false);
            Eval(3647, o is uint?, false);
            Eval(3648, o is uint?[], false);
            Eval(3649, o is long, false);
            Eval(3650, o is long[], false);
            Eval(3651, o is long?, false);
            Eval(3652, o is long?[], false);
            Eval(3653, o is ulong, false);
            Eval(3654, o is ulong[], false);
            Eval(3655, o is ulong?, false);
            Eval(3656, o is ulong?[], false);
            Eval(3657, o is float, false);
            Eval(3658, o is float[], false);
            Eval(3659, o is float?, false);
            Eval(3660, o is float?[], false);
            Eval(3661, o is double, false);
            Eval(3662, o is double[], false);
            Eval(3663, o is double?, false);
            Eval(3664, o is double?[], false);
            Eval(3665, o is decimal, false);
            Eval(3666, o is decimal[], false);
            Eval(3667, o is decimal?, false);
            Eval(3668, o is decimal?[], false);
            Eval(3669, o is object, false);
            Eval(3670, o is object[], false);
            Eval(3671, o is string, false);
            Eval(3672, o is string[], false);
            Eval(3673, o is ValueType, false);
            Eval(3674, o is ValueType[], false);
            Eval(3675, o is Array, false);
            Eval(3676, o is Array[], false);
            Eval(3677, o is Enum, false);
            Eval(3678, o is Enum[], false);
            Eval(3679, o is Delegate, false);
            Eval(3680, o is Delegate[], false);
            Eval(3681, o is MulticastDelegate, false);
            Eval(3682, o is MulticastDelegate[], false);
            Eval(3683, o is IEmpty, false);
            Eval(3684, o is IEmpty[], false);
            Eval(3685, o is INotEmpty, false);
            Eval(3686, o is INotEmpty[], false);
            Eval(3687, o is IEmptyGen<int>, false);
            Eval(3688, o is IEmptyGen<int>[], false);
            Eval(3689, o is INotEmptyGen<int>, false);
            Eval(3690, o is INotEmptyGen<int>[], false);
            Eval(3691, o is SimpleDelegate, false);
            Eval(3692, o is SimpleDelegate[], false);
            Eval(3693, o is GenericDelegate<int>, false);
            Eval(3694, o is GenericDelegate<int>[], false);
            Eval(3695, o is EmptyClass, false);
            Eval(3696, o is EmptyClass[], false);
            Eval(3697, o is NotEmptyClass, false);
            Eval(3698, o is NotEmptyClass[], false);
            Eval(3699, o is EmptyClassGen<int>, false);
            Eval(3700, o is EmptyClassGen<int>[], false);
            Eval(3701, o is NotEmptyClassGen<Guid>, false);
            Eval(3702, o is NotEmptyClassGen<Guid>[], false);
            Eval(3703, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3704, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3705, o is NestedClass, false);
            Eval(3706, o is NestedClass[], false);
            Eval(3707, o is NestedClassGen<Decimal>, false);
            Eval(3708, o is NestedClassGen<Decimal>[], false);
            Eval(3709, o is ImplementOneInterfaceC, false);
            Eval(3710, o is ImplementOneInterfaceC[], false);
            Eval(3711, o is ImplementTwoInterfaceC, false);
            Eval(3712, o is ImplementTwoInterfaceC[], false);
            Eval(3713, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3714, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3715, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3716, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3717, o is ImplementAllInterfaceC<int>, false);
            Eval(3718, o is ImplementAllInterfaceC<int>[], false);
            Eval(3719, o is SealedClass, false);
            Eval(3720, o is SealedClass[], false);
        }
    }  // end of test case 0010
    private static void TestCase0011()
    {
        {
            ushort v = default(ushort);
            IComparable o = v; ;
            Eval(3721, o is ImplementOneInterface, false);
            Eval(3722, o is ImplementOneInterface[], false);
            Eval(3723, o is ImplementOneInterface?, false);
            Eval(3724, o is ImplementOneInterface?[], false);
            Eval(3725, o is ImplementTwoInterface, false);
            Eval(3726, o is ImplementTwoInterface[], false);
            Eval(3727, o is ImplementTwoInterface?, false);
            Eval(3728, o is ImplementTwoInterface?[], false);
            Eval(3729, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3730, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3731, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3732, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3733, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3734, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3735, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3736, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3737, o is ImplementAllInterface<int>, false);
            Eval(3738, o is ImplementAllInterface<int>[], false);
            Eval(3739, o is ImplementAllInterface<int>?, false);
            Eval(3740, o is ImplementAllInterface<int>?[], false);
            Eval(3741, o is char, false);
            Eval(3742, o is char[], false);
            Eval(3743, o is char?, false);
            Eval(3744, o is char?[], false);
            Eval(3745, o is bool, false);
            Eval(3746, o is bool[], false);
            Eval(3747, o is bool?, false);
            Eval(3748, o is bool?[], false);
            Eval(3749, o is byte, false);
            Eval(3750, o is byte[], false);
            Eval(3751, o is byte?, false);
            Eval(3752, o is byte?[], false);
            Eval(3753, o is sbyte, false);
            Eval(3754, o is sbyte[], false);
            Eval(3755, o is sbyte?, false);
            Eval(3756, o is sbyte?[], false);
            Eval(3757, o is short, false);
            Eval(3758, o is short[], false);
            Eval(3759, o is short?, false);
            Eval(3760, o is short?[], false);
            Eval(3761, o is ushort, true);
            Eval(3762, o is ushort[], false);
            Eval(3763, o is ushort?, true);
            Eval(3764, o is ushort?[], false);
            Eval(3765, o is int, false);
            Eval(3766, o is int[], false);
            Eval(3767, o is int?, false);
            Eval(3768, o is int?[], false);
            Eval(3769, o is uint, false);
            Eval(3770, o is uint[], false);
            Eval(3771, o is uint?, false);
            Eval(3772, o is uint?[], false);
            Eval(3773, o is long, false);
            Eval(3774, o is long[], false);
            Eval(3775, o is long?, false);
            Eval(3776, o is long?[], false);
            Eval(3777, o is ulong, false);
            Eval(3778, o is ulong[], false);
            Eval(3779, o is ulong?, false);
            Eval(3780, o is ulong?[], false);
            Eval(3781, o is float, false);
            Eval(3782, o is float[], false);
            Eval(3783, o is float?, false);
            Eval(3784, o is float?[], false);
            Eval(3785, o is double, false);
            Eval(3786, o is double[], false);
            Eval(3787, o is double?, false);
            Eval(3788, o is double?[], false);
            Eval(3789, o is decimal, false);
            Eval(3790, o is decimal[], false);
            Eval(3791, o is decimal?, false);
            Eval(3792, o is decimal?[], false);
            Eval(3793, o is object, true);
            Eval(3794, o is object[], false);
            Eval(3795, o is string, false);
            Eval(3796, o is string[], false);
            Eval(3797, o is ValueType, true);
            Eval(3798, o is ValueType[], false);
            Eval(3799, o is Array, false);
            Eval(3800, o is Array[], false);
            Eval(3801, o is Enum, false);
            Eval(3802, o is Enum[], false);
            Eval(3803, o is Delegate, false);
            Eval(3804, o is Delegate[], false);
            Eval(3805, o is MulticastDelegate, false);
            Eval(3806, o is MulticastDelegate[], false);
            Eval(3807, o is IEmpty, false);
            Eval(3808, o is IEmpty[], false);
            Eval(3809, o is INotEmpty, false);
            Eval(3810, o is INotEmpty[], false);
            Eval(3811, o is IEmptyGen<int>, false);
            Eval(3812, o is IEmptyGen<int>[], false);
            Eval(3813, o is INotEmptyGen<int>, false);
            Eval(3814, o is INotEmptyGen<int>[], false);
            Eval(3815, o is SimpleDelegate, false);
            Eval(3816, o is SimpleDelegate[], false);
            Eval(3817, o is GenericDelegate<int>, false);
            Eval(3818, o is GenericDelegate<int>[], false);
            Eval(3819, o is EmptyClass, false);
            Eval(3820, o is EmptyClass[], false);
            Eval(3821, o is NotEmptyClass, false);
            Eval(3822, o is NotEmptyClass[], false);
            Eval(3823, o is EmptyClassGen<int>, false);
            Eval(3824, o is EmptyClassGen<int>[], false);
            Eval(3825, o is NotEmptyClassGen<Guid>, false);
            Eval(3826, o is NotEmptyClassGen<Guid>[], false);
            Eval(3827, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3828, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3829, o is NestedClass, false);
            Eval(3830, o is NestedClass[], false);
            Eval(3831, o is NestedClassGen<Decimal>, false);
            Eval(3832, o is NestedClassGen<Decimal>[], false);
            Eval(3833, o is ImplementOneInterfaceC, false);
            Eval(3834, o is ImplementOneInterfaceC[], false);
            Eval(3835, o is ImplementTwoInterfaceC, false);
            Eval(3836, o is ImplementTwoInterfaceC[], false);
            Eval(3837, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3838, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3839, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3840, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3841, o is ImplementAllInterfaceC<int>, false);
            Eval(3842, o is ImplementAllInterfaceC<int>[], false);
            Eval(3843, o is SealedClass, false);
            Eval(3844, o is SealedClass[], false);
        }
        {
            ushort? v = default(ushort);
            IComparable o = v; ;
            Eval(3845, o is ImplementOneInterface, false);
            Eval(3846, o is ImplementOneInterface[], false);
            Eval(3847, o is ImplementOneInterface?, false);
            Eval(3848, o is ImplementOneInterface?[], false);
            Eval(3849, o is ImplementTwoInterface, false);
            Eval(3850, o is ImplementTwoInterface[], false);
            Eval(3851, o is ImplementTwoInterface?, false);
            Eval(3852, o is ImplementTwoInterface?[], false);
            Eval(3853, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3854, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3855, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3856, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3857, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3858, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3859, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3860, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3861, o is ImplementAllInterface<int>, false);
            Eval(3862, o is ImplementAllInterface<int>[], false);
            Eval(3863, o is ImplementAllInterface<int>?, false);
            Eval(3864, o is ImplementAllInterface<int>?[], false);
            Eval(3865, o is char, false);
            Eval(3866, o is char[], false);
            Eval(3867, o is char?, false);
            Eval(3868, o is char?[], false);
            Eval(3869, o is bool, false);
            Eval(3870, o is bool[], false);
            Eval(3871, o is bool?, false);
            Eval(3872, o is bool?[], false);
            Eval(3873, o is byte, false);
            Eval(3874, o is byte[], false);
            Eval(3875, o is byte?, false);
            Eval(3876, o is byte?[], false);
            Eval(3877, o is sbyte, false);
            Eval(3878, o is sbyte[], false);
            Eval(3879, o is sbyte?, false);
            Eval(3880, o is sbyte?[], false);
            Eval(3881, o is short, false);
            Eval(3882, o is short[], false);
            Eval(3883, o is short?, false);
            Eval(3884, o is short?[], false);
            Eval(3885, o is ushort, true);
            Eval(3886, o is ushort[], false);
            Eval(3887, o is ushort?, true);
            Eval(3888, o is ushort?[], false);
            Eval(3889, o is int, false);
            Eval(3890, o is int[], false);
            Eval(3891, o is int?, false);
            Eval(3892, o is int?[], false);
            Eval(3893, o is uint, false);
            Eval(3894, o is uint[], false);
            Eval(3895, o is uint?, false);
            Eval(3896, o is uint?[], false);
            Eval(3897, o is long, false);
            Eval(3898, o is long[], false);
            Eval(3899, o is long?, false);
            Eval(3900, o is long?[], false);
            Eval(3901, o is ulong, false);
            Eval(3902, o is ulong[], false);
            Eval(3903, o is ulong?, false);
            Eval(3904, o is ulong?[], false);
            Eval(3905, o is float, false);
            Eval(3906, o is float[], false);
            Eval(3907, o is float?, false);
            Eval(3908, o is float?[], false);
            Eval(3909, o is double, false);
            Eval(3910, o is double[], false);
            Eval(3911, o is double?, false);
            Eval(3912, o is double?[], false);
            Eval(3913, o is decimal, false);
            Eval(3914, o is decimal[], false);
            Eval(3915, o is decimal?, false);
            Eval(3916, o is decimal?[], false);
            Eval(3917, o is object, true);
            Eval(3918, o is object[], false);
            Eval(3919, o is string, false);
            Eval(3920, o is string[], false);
            Eval(3921, o is ValueType, true);
            Eval(3922, o is ValueType[], false);
            Eval(3923, o is Array, false);
            Eval(3924, o is Array[], false);
            Eval(3925, o is Enum, false);
            Eval(3926, o is Enum[], false);
            Eval(3927, o is Delegate, false);
            Eval(3928, o is Delegate[], false);
            Eval(3929, o is MulticastDelegate, false);
            Eval(3930, o is MulticastDelegate[], false);
            Eval(3931, o is IEmpty, false);
            Eval(3932, o is IEmpty[], false);
            Eval(3933, o is INotEmpty, false);
            Eval(3934, o is INotEmpty[], false);
            Eval(3935, o is IEmptyGen<int>, false);
            Eval(3936, o is IEmptyGen<int>[], false);
            Eval(3937, o is INotEmptyGen<int>, false);
            Eval(3938, o is INotEmptyGen<int>[], false);
            Eval(3939, o is SimpleDelegate, false);
            Eval(3940, o is SimpleDelegate[], false);
            Eval(3941, o is GenericDelegate<int>, false);
            Eval(3942, o is GenericDelegate<int>[], false);
            Eval(3943, o is EmptyClass, false);
            Eval(3944, o is EmptyClass[], false);
            Eval(3945, o is NotEmptyClass, false);
            Eval(3946, o is NotEmptyClass[], false);
            Eval(3947, o is EmptyClassGen<int>, false);
            Eval(3948, o is EmptyClassGen<int>[], false);
            Eval(3949, o is NotEmptyClassGen<Guid>, false);
            Eval(3950, o is NotEmptyClassGen<Guid>[], false);
            Eval(3951, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(3952, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(3953, o is NestedClass, false);
            Eval(3954, o is NestedClass[], false);
            Eval(3955, o is NestedClassGen<Decimal>, false);
            Eval(3956, o is NestedClassGen<Decimal>[], false);
            Eval(3957, o is ImplementOneInterfaceC, false);
            Eval(3958, o is ImplementOneInterfaceC[], false);
            Eval(3959, o is ImplementTwoInterfaceC, false);
            Eval(3960, o is ImplementTwoInterfaceC[], false);
            Eval(3961, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(3962, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(3963, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(3964, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(3965, o is ImplementAllInterfaceC<int>, false);
            Eval(3966, o is ImplementAllInterfaceC<int>[], false);
            Eval(3967, o is SealedClass, false);
            Eval(3968, o is SealedClass[], false);
        }
        {
            ushort? v = default(ushort?);
            IComparable o = v; ;
            Eval(3969, o is ImplementOneInterface, false);
            Eval(3970, o is ImplementOneInterface[], false);
            Eval(3971, o is ImplementOneInterface?, false);
            Eval(3972, o is ImplementOneInterface?[], false);
            Eval(3973, o is ImplementTwoInterface, false);
            Eval(3974, o is ImplementTwoInterface[], false);
            Eval(3975, o is ImplementTwoInterface?, false);
            Eval(3976, o is ImplementTwoInterface?[], false);
            Eval(3977, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(3978, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(3979, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(3980, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(3981, o is ImplementTwoInterfaceGen<int>, false);
            Eval(3982, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(3983, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(3984, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(3985, o is ImplementAllInterface<int>, false);
            Eval(3986, o is ImplementAllInterface<int>[], false);
            Eval(3987, o is ImplementAllInterface<int>?, false);
            Eval(3988, o is ImplementAllInterface<int>?[], false);
            Eval(3989, o is char, false);
            Eval(3990, o is char[], false);
            Eval(3991, o is char?, false);
            Eval(3992, o is char?[], false);
            Eval(3993, o is bool, false);
            Eval(3994, o is bool[], false);
            Eval(3995, o is bool?, false);
            Eval(3996, o is bool?[], false);
            Eval(3997, o is byte, false);
            Eval(3998, o is byte[], false);
            Eval(3999, o is byte?, false);
            Eval(4000, o is byte?[], false);
            Eval(4001, o is sbyte, false);
            Eval(4002, o is sbyte[], false);
            Eval(4003, o is sbyte?, false);
            Eval(4004, o is sbyte?[], false);
            Eval(4005, o is short, false);
            Eval(4006, o is short[], false);
            Eval(4007, o is short?, false);
            Eval(4008, o is short?[], false);
            Eval(4009, o is ushort, false);
            Eval(4010, o is ushort[], false);
            Eval(4011, o is ushort?, false);
            Eval(4012, o is ushort?[], false);
            Eval(4013, o is int, false);
            Eval(4014, o is int[], false);
            Eval(4015, o is int?, false);
            Eval(4016, o is int?[], false);
            Eval(4017, o is uint, false);
            Eval(4018, o is uint[], false);
            Eval(4019, o is uint?, false);
            Eval(4020, o is uint?[], false);
            Eval(4021, o is long, false);
            Eval(4022, o is long[], false);
            Eval(4023, o is long?, false);
            Eval(4024, o is long?[], false);
            Eval(4025, o is ulong, false);
            Eval(4026, o is ulong[], false);
            Eval(4027, o is ulong?, false);
            Eval(4028, o is ulong?[], false);
            Eval(4029, o is float, false);
            Eval(4030, o is float[], false);
            Eval(4031, o is float?, false);
            Eval(4032, o is float?[], false);
            Eval(4033, o is double, false);
            Eval(4034, o is double[], false);
            Eval(4035, o is double?, false);
            Eval(4036, o is double?[], false);
            Eval(4037, o is decimal, false);
            Eval(4038, o is decimal[], false);
            Eval(4039, o is decimal?, false);
            Eval(4040, o is decimal?[], false);
            Eval(4041, o is object, false);
            Eval(4042, o is object[], false);
            Eval(4043, o is string, false);
            Eval(4044, o is string[], false);
            Eval(4045, o is ValueType, false);
            Eval(4046, o is ValueType[], false);
            Eval(4047, o is Array, false);
            Eval(4048, o is Array[], false);
            Eval(4049, o is Enum, false);
            Eval(4050, o is Enum[], false);
            Eval(4051, o is Delegate, false);
            Eval(4052, o is Delegate[], false);
            Eval(4053, o is MulticastDelegate, false);
            Eval(4054, o is MulticastDelegate[], false);
            Eval(4055, o is IEmpty, false);
            Eval(4056, o is IEmpty[], false);
            Eval(4057, o is INotEmpty, false);
            Eval(4058, o is INotEmpty[], false);
            Eval(4059, o is IEmptyGen<int>, false);
            Eval(4060, o is IEmptyGen<int>[], false);
            Eval(4061, o is INotEmptyGen<int>, false);
            Eval(4062, o is INotEmptyGen<int>[], false);
            Eval(4063, o is SimpleDelegate, false);
            Eval(4064, o is SimpleDelegate[], false);
            Eval(4065, o is GenericDelegate<int>, false);
            Eval(4066, o is GenericDelegate<int>[], false);
            Eval(4067, o is EmptyClass, false);
            Eval(4068, o is EmptyClass[], false);
            Eval(4069, o is NotEmptyClass, false);
            Eval(4070, o is NotEmptyClass[], false);
            Eval(4071, o is EmptyClassGen<int>, false);
            Eval(4072, o is EmptyClassGen<int>[], false);
            Eval(4073, o is NotEmptyClassGen<Guid>, false);
            Eval(4074, o is NotEmptyClassGen<Guid>[], false);
            Eval(4075, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4076, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4077, o is NestedClass, false);
            Eval(4078, o is NestedClass[], false);
            Eval(4079, o is NestedClassGen<Decimal>, false);
            Eval(4080, o is NestedClassGen<Decimal>[], false);
            Eval(4081, o is ImplementOneInterfaceC, false);
            Eval(4082, o is ImplementOneInterfaceC[], false);
            Eval(4083, o is ImplementTwoInterfaceC, false);
            Eval(4084, o is ImplementTwoInterfaceC[], false);
            Eval(4085, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4086, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4087, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4088, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4089, o is ImplementAllInterfaceC<int>, false);
            Eval(4090, o is ImplementAllInterfaceC<int>[], false);
            Eval(4091, o is SealedClass, false);
            Eval(4092, o is SealedClass[], false);
        }
    }  // end of test case 0011
    private static void TestCase0012()
    {
        {
            int v = default(int);
            IComparable o = v; ;
            Eval(4093, o is ImplementOneInterface, false);
            Eval(4094, o is ImplementOneInterface[], false);
            Eval(4095, o is ImplementOneInterface?, false);
            Eval(4096, o is ImplementOneInterface?[], false);
            Eval(4097, o is ImplementTwoInterface, false);
            Eval(4098, o is ImplementTwoInterface[], false);
            Eval(4099, o is ImplementTwoInterface?, false);
            Eval(4100, o is ImplementTwoInterface?[], false);
            Eval(4101, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4102, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4103, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4104, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4105, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4106, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4107, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4108, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4109, o is ImplementAllInterface<int>, false);
            Eval(4110, o is ImplementAllInterface<int>[], false);
            Eval(4111, o is ImplementAllInterface<int>?, false);
            Eval(4112, o is ImplementAllInterface<int>?[], false);
            Eval(4113, o is char, false);
            Eval(4114, o is char[], false);
            Eval(4115, o is char?, false);
            Eval(4116, o is char?[], false);
            Eval(4117, o is bool, false);
            Eval(4118, o is bool[], false);
            Eval(4119, o is bool?, false);
            Eval(4120, o is bool?[], false);
            Eval(4121, o is byte, false);
            Eval(4122, o is byte[], false);
            Eval(4123, o is byte?, false);
            Eval(4124, o is byte?[], false);
            Eval(4125, o is sbyte, false);
            Eval(4126, o is sbyte[], false);
            Eval(4127, o is sbyte?, false);
            Eval(4128, o is sbyte?[], false);
            Eval(4129, o is short, false);
            Eval(4130, o is short[], false);
            Eval(4131, o is short?, false);
            Eval(4132, o is short?[], false);
            Eval(4133, o is ushort, false);
            Eval(4134, o is ushort[], false);
            Eval(4135, o is ushort?, false);
            Eval(4136, o is ushort?[], false);
            Eval(4137, o is int, true);
            Eval(4138, o is int[], false);
            Eval(4139, o is int?, true);
            Eval(4140, o is int?[], false);
            Eval(4141, o is uint, false);
            Eval(4142, o is uint[], false);
            Eval(4143, o is uint?, false);
            Eval(4144, o is uint?[], false);
            Eval(4145, o is long, false);
            Eval(4146, o is long[], false);
            Eval(4147, o is long?, false);
            Eval(4148, o is long?[], false);
            Eval(4149, o is ulong, false);
            Eval(4150, o is ulong[], false);
            Eval(4151, o is ulong?, false);
            Eval(4152, o is ulong?[], false);
            Eval(4153, o is float, false);
            Eval(4154, o is float[], false);
            Eval(4155, o is float?, false);
            Eval(4156, o is float?[], false);
            Eval(4157, o is double, false);
            Eval(4158, o is double[], false);
            Eval(4159, o is double?, false);
            Eval(4160, o is double?[], false);
            Eval(4161, o is decimal, false);
            Eval(4162, o is decimal[], false);
            Eval(4163, o is decimal?, false);
            Eval(4164, o is decimal?[], false);
            Eval(4165, o is object, true);
            Eval(4166, o is object[], false);
            Eval(4167, o is string, false);
            Eval(4168, o is string[], false);
            Eval(4169, o is ValueType, true);
            Eval(4170, o is ValueType[], false);
            Eval(4171, o is Array, false);
            Eval(4172, o is Array[], false);
            Eval(4173, o is Enum, false);
            Eval(4174, o is Enum[], false);
            Eval(4175, o is Delegate, false);
            Eval(4176, o is Delegate[], false);
            Eval(4177, o is MulticastDelegate, false);
            Eval(4178, o is MulticastDelegate[], false);
            Eval(4179, o is IEmpty, false);
            Eval(4180, o is IEmpty[], false);
            Eval(4181, o is INotEmpty, false);
            Eval(4182, o is INotEmpty[], false);
            Eval(4183, o is IEmptyGen<int>, false);
            Eval(4184, o is IEmptyGen<int>[], false);
            Eval(4185, o is INotEmptyGen<int>, false);
            Eval(4186, o is INotEmptyGen<int>[], false);
            Eval(4187, o is SimpleDelegate, false);
            Eval(4188, o is SimpleDelegate[], false);
            Eval(4189, o is GenericDelegate<int>, false);
            Eval(4190, o is GenericDelegate<int>[], false);
            Eval(4191, o is EmptyClass, false);
            Eval(4192, o is EmptyClass[], false);
            Eval(4193, o is NotEmptyClass, false);
            Eval(4194, o is NotEmptyClass[], false);
            Eval(4195, o is EmptyClassGen<int>, false);
            Eval(4196, o is EmptyClassGen<int>[], false);
            Eval(4197, o is NotEmptyClassGen<Guid>, false);
            Eval(4198, o is NotEmptyClassGen<Guid>[], false);
            Eval(4199, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4200, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4201, o is NestedClass, false);
            Eval(4202, o is NestedClass[], false);
            Eval(4203, o is NestedClassGen<Decimal>, false);
            Eval(4204, o is NestedClassGen<Decimal>[], false);
            Eval(4205, o is ImplementOneInterfaceC, false);
            Eval(4206, o is ImplementOneInterfaceC[], false);
            Eval(4207, o is ImplementTwoInterfaceC, false);
            Eval(4208, o is ImplementTwoInterfaceC[], false);
            Eval(4209, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4210, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4211, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4212, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4213, o is ImplementAllInterfaceC<int>, false);
            Eval(4214, o is ImplementAllInterfaceC<int>[], false);
            Eval(4215, o is SealedClass, false);
            Eval(4216, o is SealedClass[], false);
        }
        {
            int? v = default(int);
            IComparable o = v; ;
            Eval(4217, o is ImplementOneInterface, false);
            Eval(4218, o is ImplementOneInterface[], false);
            Eval(4219, o is ImplementOneInterface?, false);
            Eval(4220, o is ImplementOneInterface?[], false);
            Eval(4221, o is ImplementTwoInterface, false);
            Eval(4222, o is ImplementTwoInterface[], false);
            Eval(4223, o is ImplementTwoInterface?, false);
            Eval(4224, o is ImplementTwoInterface?[], false);
            Eval(4225, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4226, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4227, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4228, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4229, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4230, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4231, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4232, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4233, o is ImplementAllInterface<int>, false);
            Eval(4234, o is ImplementAllInterface<int>[], false);
            Eval(4235, o is ImplementAllInterface<int>?, false);
            Eval(4236, o is ImplementAllInterface<int>?[], false);
            Eval(4237, o is char, false);
            Eval(4238, o is char[], false);
            Eval(4239, o is char?, false);
            Eval(4240, o is char?[], false);
            Eval(4241, o is bool, false);
            Eval(4242, o is bool[], false);
            Eval(4243, o is bool?, false);
            Eval(4244, o is bool?[], false);
            Eval(4245, o is byte, false);
            Eval(4246, o is byte[], false);
            Eval(4247, o is byte?, false);
            Eval(4248, o is byte?[], false);
            Eval(4249, o is sbyte, false);
            Eval(4250, o is sbyte[], false);
            Eval(4251, o is sbyte?, false);
            Eval(4252, o is sbyte?[], false);
            Eval(4253, o is short, false);
            Eval(4254, o is short[], false);
            Eval(4255, o is short?, false);
            Eval(4256, o is short?[], false);
            Eval(4257, o is ushort, false);
            Eval(4258, o is ushort[], false);
            Eval(4259, o is ushort?, false);
            Eval(4260, o is ushort?[], false);
            Eval(4261, o is int, true);
            Eval(4262, o is int[], false);
            Eval(4263, o is int?, true);
            Eval(4264, o is int?[], false);
            Eval(4265, o is uint, false);
            Eval(4266, o is uint[], false);
            Eval(4267, o is uint?, false);
            Eval(4268, o is uint?[], false);
            Eval(4269, o is long, false);
            Eval(4270, o is long[], false);
            Eval(4271, o is long?, false);
            Eval(4272, o is long?[], false);
            Eval(4273, o is ulong, false);
            Eval(4274, o is ulong[], false);
            Eval(4275, o is ulong?, false);
            Eval(4276, o is ulong?[], false);
            Eval(4277, o is float, false);
            Eval(4278, o is float[], false);
            Eval(4279, o is float?, false);
            Eval(4280, o is float?[], false);
            Eval(4281, o is double, false);
            Eval(4282, o is double[], false);
            Eval(4283, o is double?, false);
            Eval(4284, o is double?[], false);
            Eval(4285, o is decimal, false);
            Eval(4286, o is decimal[], false);
            Eval(4287, o is decimal?, false);
            Eval(4288, o is decimal?[], false);
            Eval(4289, o is object, true);
            Eval(4290, o is object[], false);
            Eval(4291, o is string, false);
            Eval(4292, o is string[], false);
            Eval(4293, o is ValueType, true);
            Eval(4294, o is ValueType[], false);
            Eval(4295, o is Array, false);
            Eval(4296, o is Array[], false);
            Eval(4297, o is Enum, false);
            Eval(4298, o is Enum[], false);
            Eval(4299, o is Delegate, false);
            Eval(4300, o is Delegate[], false);
            Eval(4301, o is MulticastDelegate, false);
            Eval(4302, o is MulticastDelegate[], false);
            Eval(4303, o is IEmpty, false);
            Eval(4304, o is IEmpty[], false);
            Eval(4305, o is INotEmpty, false);
            Eval(4306, o is INotEmpty[], false);
            Eval(4307, o is IEmptyGen<int>, false);
            Eval(4308, o is IEmptyGen<int>[], false);
            Eval(4309, o is INotEmptyGen<int>, false);
            Eval(4310, o is INotEmptyGen<int>[], false);
            Eval(4311, o is SimpleDelegate, false);
            Eval(4312, o is SimpleDelegate[], false);
            Eval(4313, o is GenericDelegate<int>, false);
            Eval(4314, o is GenericDelegate<int>[], false);
            Eval(4315, o is EmptyClass, false);
            Eval(4316, o is EmptyClass[], false);
            Eval(4317, o is NotEmptyClass, false);
            Eval(4318, o is NotEmptyClass[], false);
            Eval(4319, o is EmptyClassGen<int>, false);
            Eval(4320, o is EmptyClassGen<int>[], false);
            Eval(4321, o is NotEmptyClassGen<Guid>, false);
            Eval(4322, o is NotEmptyClassGen<Guid>[], false);
            Eval(4323, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4324, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4325, o is NestedClass, false);
            Eval(4326, o is NestedClass[], false);
            Eval(4327, o is NestedClassGen<Decimal>, false);
            Eval(4328, o is NestedClassGen<Decimal>[], false);
            Eval(4329, o is ImplementOneInterfaceC, false);
            Eval(4330, o is ImplementOneInterfaceC[], false);
            Eval(4331, o is ImplementTwoInterfaceC, false);
            Eval(4332, o is ImplementTwoInterfaceC[], false);
            Eval(4333, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4334, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4335, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4336, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4337, o is ImplementAllInterfaceC<int>, false);
            Eval(4338, o is ImplementAllInterfaceC<int>[], false);
            Eval(4339, o is SealedClass, false);
            Eval(4340, o is SealedClass[], false);
        }
        {
            int? v = default(int?);
            IComparable o = v; ;
            Eval(4341, o is ImplementOneInterface, false);
            Eval(4342, o is ImplementOneInterface[], false);
            Eval(4343, o is ImplementOneInterface?, false);
            Eval(4344, o is ImplementOneInterface?[], false);
            Eval(4345, o is ImplementTwoInterface, false);
            Eval(4346, o is ImplementTwoInterface[], false);
            Eval(4347, o is ImplementTwoInterface?, false);
            Eval(4348, o is ImplementTwoInterface?[], false);
            Eval(4349, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4350, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4351, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4352, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4353, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4354, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4355, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4356, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4357, o is ImplementAllInterface<int>, false);
            Eval(4358, o is ImplementAllInterface<int>[], false);
            Eval(4359, o is ImplementAllInterface<int>?, false);
            Eval(4360, o is ImplementAllInterface<int>?[], false);
            Eval(4361, o is char, false);
            Eval(4362, o is char[], false);
            Eval(4363, o is char?, false);
            Eval(4364, o is char?[], false);
            Eval(4365, o is bool, false);
            Eval(4366, o is bool[], false);
            Eval(4367, o is bool?, false);
            Eval(4368, o is bool?[], false);
            Eval(4369, o is byte, false);
            Eval(4370, o is byte[], false);
            Eval(4371, o is byte?, false);
            Eval(4372, o is byte?[], false);
            Eval(4373, o is sbyte, false);
            Eval(4374, o is sbyte[], false);
            Eval(4375, o is sbyte?, false);
            Eval(4376, o is sbyte?[], false);
            Eval(4377, o is short, false);
            Eval(4378, o is short[], false);
            Eval(4379, o is short?, false);
            Eval(4380, o is short?[], false);
            Eval(4381, o is ushort, false);
            Eval(4382, o is ushort[], false);
            Eval(4383, o is ushort?, false);
            Eval(4384, o is ushort?[], false);
            Eval(4385, o is int, false);
            Eval(4386, o is int[], false);
            Eval(4387, o is int?, false);
            Eval(4388, o is int?[], false);
            Eval(4389, o is uint, false);
            Eval(4390, o is uint[], false);
            Eval(4391, o is uint?, false);
            Eval(4392, o is uint?[], false);
            Eval(4393, o is long, false);
            Eval(4394, o is long[], false);
            Eval(4395, o is long?, false);
            Eval(4396, o is long?[], false);
            Eval(4397, o is ulong, false);
            Eval(4398, o is ulong[], false);
            Eval(4399, o is ulong?, false);
            Eval(4400, o is ulong?[], false);
            Eval(4401, o is float, false);
            Eval(4402, o is float[], false);
            Eval(4403, o is float?, false);
            Eval(4404, o is float?[], false);
            Eval(4405, o is double, false);
            Eval(4406, o is double[], false);
            Eval(4407, o is double?, false);
            Eval(4408, o is double?[], false);
            Eval(4409, o is decimal, false);
            Eval(4410, o is decimal[], false);
            Eval(4411, o is decimal?, false);
            Eval(4412, o is decimal?[], false);
            Eval(4413, o is object, false);
            Eval(4414, o is object[], false);
            Eval(4415, o is string, false);
            Eval(4416, o is string[], false);
            Eval(4417, o is ValueType, false);
            Eval(4418, o is ValueType[], false);
            Eval(4419, o is Array, false);
            Eval(4420, o is Array[], false);
            Eval(4421, o is Enum, false);
            Eval(4422, o is Enum[], false);
            Eval(4423, o is Delegate, false);
            Eval(4424, o is Delegate[], false);
            Eval(4425, o is MulticastDelegate, false);
            Eval(4426, o is MulticastDelegate[], false);
            Eval(4427, o is IEmpty, false);
            Eval(4428, o is IEmpty[], false);
            Eval(4429, o is INotEmpty, false);
            Eval(4430, o is INotEmpty[], false);
            Eval(4431, o is IEmptyGen<int>, false);
            Eval(4432, o is IEmptyGen<int>[], false);
            Eval(4433, o is INotEmptyGen<int>, false);
            Eval(4434, o is INotEmptyGen<int>[], false);
            Eval(4435, o is SimpleDelegate, false);
            Eval(4436, o is SimpleDelegate[], false);
            Eval(4437, o is GenericDelegate<int>, false);
            Eval(4438, o is GenericDelegate<int>[], false);
            Eval(4439, o is EmptyClass, false);
            Eval(4440, o is EmptyClass[], false);
            Eval(4441, o is NotEmptyClass, false);
            Eval(4442, o is NotEmptyClass[], false);
            Eval(4443, o is EmptyClassGen<int>, false);
            Eval(4444, o is EmptyClassGen<int>[], false);
            Eval(4445, o is NotEmptyClassGen<Guid>, false);
            Eval(4446, o is NotEmptyClassGen<Guid>[], false);
            Eval(4447, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4448, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4449, o is NestedClass, false);
            Eval(4450, o is NestedClass[], false);
            Eval(4451, o is NestedClassGen<Decimal>, false);
            Eval(4452, o is NestedClassGen<Decimal>[], false);
            Eval(4453, o is ImplementOneInterfaceC, false);
            Eval(4454, o is ImplementOneInterfaceC[], false);
            Eval(4455, o is ImplementTwoInterfaceC, false);
            Eval(4456, o is ImplementTwoInterfaceC[], false);
            Eval(4457, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4458, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4459, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4460, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4461, o is ImplementAllInterfaceC<int>, false);
            Eval(4462, o is ImplementAllInterfaceC<int>[], false);
            Eval(4463, o is SealedClass, false);
            Eval(4464, o is SealedClass[], false);
        }
    }  // end of test case 0012
    private static void TestCase0013()
    {
        {
            uint v = default(uint);
            IComparable o = v; ;
            Eval(4465, o is ImplementOneInterface, false);
            Eval(4466, o is ImplementOneInterface[], false);
            Eval(4467, o is ImplementOneInterface?, false);
            Eval(4468, o is ImplementOneInterface?[], false);
            Eval(4469, o is ImplementTwoInterface, false);
            Eval(4470, o is ImplementTwoInterface[], false);
            Eval(4471, o is ImplementTwoInterface?, false);
            Eval(4472, o is ImplementTwoInterface?[], false);
            Eval(4473, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4474, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4475, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4476, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4477, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4478, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4479, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4480, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4481, o is ImplementAllInterface<int>, false);
            Eval(4482, o is ImplementAllInterface<int>[], false);
            Eval(4483, o is ImplementAllInterface<int>?, false);
            Eval(4484, o is ImplementAllInterface<int>?[], false);
            Eval(4485, o is char, false);
            Eval(4486, o is char[], false);
            Eval(4487, o is char?, false);
            Eval(4488, o is char?[], false);
            Eval(4489, o is bool, false);
            Eval(4490, o is bool[], false);
            Eval(4491, o is bool?, false);
            Eval(4492, o is bool?[], false);
            Eval(4493, o is byte, false);
            Eval(4494, o is byte[], false);
            Eval(4495, o is byte?, false);
            Eval(4496, o is byte?[], false);
            Eval(4497, o is sbyte, false);
            Eval(4498, o is sbyte[], false);
            Eval(4499, o is sbyte?, false);
            Eval(4500, o is sbyte?[], false);
            Eval(4501, o is short, false);
            Eval(4502, o is short[], false);
            Eval(4503, o is short?, false);
            Eval(4504, o is short?[], false);
            Eval(4505, o is ushort, false);
            Eval(4506, o is ushort[], false);
            Eval(4507, o is ushort?, false);
            Eval(4508, o is ushort?[], false);
            Eval(4509, o is int, false);
            Eval(4510, o is int[], false);
            Eval(4511, o is int?, false);
            Eval(4512, o is int?[], false);
            Eval(4513, o is uint, true);
            Eval(4514, o is uint[], false);
            Eval(4515, o is uint?, true);
            Eval(4516, o is uint?[], false);
            Eval(4517, o is long, false);
            Eval(4518, o is long[], false);
            Eval(4519, o is long?, false);
            Eval(4520, o is long?[], false);
            Eval(4521, o is ulong, false);
            Eval(4522, o is ulong[], false);
            Eval(4523, o is ulong?, false);
            Eval(4524, o is ulong?[], false);
            Eval(4525, o is float, false);
            Eval(4526, o is float[], false);
            Eval(4527, o is float?, false);
            Eval(4528, o is float?[], false);
            Eval(4529, o is double, false);
            Eval(4530, o is double[], false);
            Eval(4531, o is double?, false);
            Eval(4532, o is double?[], false);
            Eval(4533, o is decimal, false);
            Eval(4534, o is decimal[], false);
            Eval(4535, o is decimal?, false);
            Eval(4536, o is decimal?[], false);
            Eval(4537, o is object, true);
            Eval(4538, o is object[], false);
            Eval(4539, o is string, false);
            Eval(4540, o is string[], false);
            Eval(4541, o is ValueType, true);
            Eval(4542, o is ValueType[], false);
            Eval(4543, o is Array, false);
            Eval(4544, o is Array[], false);
            Eval(4545, o is Enum, false);
            Eval(4546, o is Enum[], false);
            Eval(4547, o is Delegate, false);
            Eval(4548, o is Delegate[], false);
            Eval(4549, o is MulticastDelegate, false);
            Eval(4550, o is MulticastDelegate[], false);
            Eval(4551, o is IEmpty, false);
            Eval(4552, o is IEmpty[], false);
            Eval(4553, o is INotEmpty, false);
            Eval(4554, o is INotEmpty[], false);
            Eval(4555, o is IEmptyGen<int>, false);
            Eval(4556, o is IEmptyGen<int>[], false);
            Eval(4557, o is INotEmptyGen<int>, false);
            Eval(4558, o is INotEmptyGen<int>[], false);
            Eval(4559, o is SimpleDelegate, false);
            Eval(4560, o is SimpleDelegate[], false);
            Eval(4561, o is GenericDelegate<int>, false);
            Eval(4562, o is GenericDelegate<int>[], false);
            Eval(4563, o is EmptyClass, false);
            Eval(4564, o is EmptyClass[], false);
            Eval(4565, o is NotEmptyClass, false);
            Eval(4566, o is NotEmptyClass[], false);
            Eval(4567, o is EmptyClassGen<int>, false);
            Eval(4568, o is EmptyClassGen<int>[], false);
            Eval(4569, o is NotEmptyClassGen<Guid>, false);
            Eval(4570, o is NotEmptyClassGen<Guid>[], false);
            Eval(4571, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4572, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4573, o is NestedClass, false);
            Eval(4574, o is NestedClass[], false);
            Eval(4575, o is NestedClassGen<Decimal>, false);
            Eval(4576, o is NestedClassGen<Decimal>[], false);
            Eval(4577, o is ImplementOneInterfaceC, false);
            Eval(4578, o is ImplementOneInterfaceC[], false);
            Eval(4579, o is ImplementTwoInterfaceC, false);
            Eval(4580, o is ImplementTwoInterfaceC[], false);
            Eval(4581, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4582, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4583, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4584, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4585, o is ImplementAllInterfaceC<int>, false);
            Eval(4586, o is ImplementAllInterfaceC<int>[], false);
            Eval(4587, o is SealedClass, false);
            Eval(4588, o is SealedClass[], false);
        }
        {
            uint? v = default(uint);
            IComparable o = v; ;
            Eval(4589, o is ImplementOneInterface, false);
            Eval(4590, o is ImplementOneInterface[], false);
            Eval(4591, o is ImplementOneInterface?, false);
            Eval(4592, o is ImplementOneInterface?[], false);
            Eval(4593, o is ImplementTwoInterface, false);
            Eval(4594, o is ImplementTwoInterface[], false);
            Eval(4595, o is ImplementTwoInterface?, false);
            Eval(4596, o is ImplementTwoInterface?[], false);
            Eval(4597, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4598, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4599, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4600, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4601, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4602, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4603, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4604, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4605, o is ImplementAllInterface<int>, false);
            Eval(4606, o is ImplementAllInterface<int>[], false);
            Eval(4607, o is ImplementAllInterface<int>?, false);
            Eval(4608, o is ImplementAllInterface<int>?[], false);
            Eval(4609, o is char, false);
            Eval(4610, o is char[], false);
            Eval(4611, o is char?, false);
            Eval(4612, o is char?[], false);
            Eval(4613, o is bool, false);
            Eval(4614, o is bool[], false);
            Eval(4615, o is bool?, false);
            Eval(4616, o is bool?[], false);
            Eval(4617, o is byte, false);
            Eval(4618, o is byte[], false);
            Eval(4619, o is byte?, false);
            Eval(4620, o is byte?[], false);
            Eval(4621, o is sbyte, false);
            Eval(4622, o is sbyte[], false);
            Eval(4623, o is sbyte?, false);
            Eval(4624, o is sbyte?[], false);
            Eval(4625, o is short, false);
            Eval(4626, o is short[], false);
            Eval(4627, o is short?, false);
            Eval(4628, o is short?[], false);
            Eval(4629, o is ushort, false);
            Eval(4630, o is ushort[], false);
            Eval(4631, o is ushort?, false);
            Eval(4632, o is ushort?[], false);
            Eval(4633, o is int, false);
            Eval(4634, o is int[], false);
            Eval(4635, o is int?, false);
            Eval(4636, o is int?[], false);
            Eval(4637, o is uint, true);
            Eval(4638, o is uint[], false);
            Eval(4639, o is uint?, true);
            Eval(4640, o is uint?[], false);
            Eval(4641, o is long, false);
            Eval(4642, o is long[], false);
            Eval(4643, o is long?, false);
            Eval(4644, o is long?[], false);
            Eval(4645, o is ulong, false);
            Eval(4646, o is ulong[], false);
            Eval(4647, o is ulong?, false);
            Eval(4648, o is ulong?[], false);
            Eval(4649, o is float, false);
            Eval(4650, o is float[], false);
            Eval(4651, o is float?, false);
            Eval(4652, o is float?[], false);
            Eval(4653, o is double, false);
            Eval(4654, o is double[], false);
            Eval(4655, o is double?, false);
            Eval(4656, o is double?[], false);
            Eval(4657, o is decimal, false);
            Eval(4658, o is decimal[], false);
            Eval(4659, o is decimal?, false);
            Eval(4660, o is decimal?[], false);
            Eval(4661, o is object, true);
            Eval(4662, o is object[], false);
            Eval(4663, o is string, false);
            Eval(4664, o is string[], false);
            Eval(4665, o is ValueType, true);
            Eval(4666, o is ValueType[], false);
            Eval(4667, o is Array, false);
            Eval(4668, o is Array[], false);
            Eval(4669, o is Enum, false);
            Eval(4670, o is Enum[], false);
            Eval(4671, o is Delegate, false);
            Eval(4672, o is Delegate[], false);
            Eval(4673, o is MulticastDelegate, false);
            Eval(4674, o is MulticastDelegate[], false);
            Eval(4675, o is IEmpty, false);
            Eval(4676, o is IEmpty[], false);
            Eval(4677, o is INotEmpty, false);
            Eval(4678, o is INotEmpty[], false);
            Eval(4679, o is IEmptyGen<int>, false);
            Eval(4680, o is IEmptyGen<int>[], false);
            Eval(4681, o is INotEmptyGen<int>, false);
            Eval(4682, o is INotEmptyGen<int>[], false);
            Eval(4683, o is SimpleDelegate, false);
            Eval(4684, o is SimpleDelegate[], false);
            Eval(4685, o is GenericDelegate<int>, false);
            Eval(4686, o is GenericDelegate<int>[], false);
            Eval(4687, o is EmptyClass, false);
            Eval(4688, o is EmptyClass[], false);
            Eval(4689, o is NotEmptyClass, false);
            Eval(4690, o is NotEmptyClass[], false);
            Eval(4691, o is EmptyClassGen<int>, false);
            Eval(4692, o is EmptyClassGen<int>[], false);
            Eval(4693, o is NotEmptyClassGen<Guid>, false);
            Eval(4694, o is NotEmptyClassGen<Guid>[], false);
            Eval(4695, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4696, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4697, o is NestedClass, false);
            Eval(4698, o is NestedClass[], false);
            Eval(4699, o is NestedClassGen<Decimal>, false);
            Eval(4700, o is NestedClassGen<Decimal>[], false);
            Eval(4701, o is ImplementOneInterfaceC, false);
            Eval(4702, o is ImplementOneInterfaceC[], false);
            Eval(4703, o is ImplementTwoInterfaceC, false);
            Eval(4704, o is ImplementTwoInterfaceC[], false);
            Eval(4705, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4706, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4707, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4708, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4709, o is ImplementAllInterfaceC<int>, false);
            Eval(4710, o is ImplementAllInterfaceC<int>[], false);
            Eval(4711, o is SealedClass, false);
            Eval(4712, o is SealedClass[], false);
        }
        {
            uint? v = default(uint?);
            IComparable o = v; ;
            Eval(4713, o is ImplementOneInterface, false);
            Eval(4714, o is ImplementOneInterface[], false);
            Eval(4715, o is ImplementOneInterface?, false);
            Eval(4716, o is ImplementOneInterface?[], false);
            Eval(4717, o is ImplementTwoInterface, false);
            Eval(4718, o is ImplementTwoInterface[], false);
            Eval(4719, o is ImplementTwoInterface?, false);
            Eval(4720, o is ImplementTwoInterface?[], false);
            Eval(4721, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4722, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4723, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4724, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4725, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4726, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4727, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4728, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4729, o is ImplementAllInterface<int>, false);
            Eval(4730, o is ImplementAllInterface<int>[], false);
            Eval(4731, o is ImplementAllInterface<int>?, false);
            Eval(4732, o is ImplementAllInterface<int>?[], false);
            Eval(4733, o is char, false);
            Eval(4734, o is char[], false);
            Eval(4735, o is char?, false);
            Eval(4736, o is char?[], false);
            Eval(4737, o is bool, false);
            Eval(4738, o is bool[], false);
            Eval(4739, o is bool?, false);
            Eval(4740, o is bool?[], false);
            Eval(4741, o is byte, false);
            Eval(4742, o is byte[], false);
            Eval(4743, o is byte?, false);
            Eval(4744, o is byte?[], false);
            Eval(4745, o is sbyte, false);
            Eval(4746, o is sbyte[], false);
            Eval(4747, o is sbyte?, false);
            Eval(4748, o is sbyte?[], false);
            Eval(4749, o is short, false);
            Eval(4750, o is short[], false);
            Eval(4751, o is short?, false);
            Eval(4752, o is short?[], false);
            Eval(4753, o is ushort, false);
            Eval(4754, o is ushort[], false);
            Eval(4755, o is ushort?, false);
            Eval(4756, o is ushort?[], false);
            Eval(4757, o is int, false);
            Eval(4758, o is int[], false);
            Eval(4759, o is int?, false);
            Eval(4760, o is int?[], false);
            Eval(4761, o is uint, false);
            Eval(4762, o is uint[], false);
            Eval(4763, o is uint?, false);
            Eval(4764, o is uint?[], false);
            Eval(4765, o is long, false);
            Eval(4766, o is long[], false);
            Eval(4767, o is long?, false);
            Eval(4768, o is long?[], false);
            Eval(4769, o is ulong, false);
            Eval(4770, o is ulong[], false);
            Eval(4771, o is ulong?, false);
            Eval(4772, o is ulong?[], false);
            Eval(4773, o is float, false);
            Eval(4774, o is float[], false);
            Eval(4775, o is float?, false);
            Eval(4776, o is float?[], false);
            Eval(4777, o is double, false);
            Eval(4778, o is double[], false);
            Eval(4779, o is double?, false);
            Eval(4780, o is double?[], false);
            Eval(4781, o is decimal, false);
            Eval(4782, o is decimal[], false);
            Eval(4783, o is decimal?, false);
            Eval(4784, o is decimal?[], false);
            Eval(4785, o is object, false);
            Eval(4786, o is object[], false);
            Eval(4787, o is string, false);
            Eval(4788, o is string[], false);
            Eval(4789, o is ValueType, false);
            Eval(4790, o is ValueType[], false);
            Eval(4791, o is Array, false);
            Eval(4792, o is Array[], false);
            Eval(4793, o is Enum, false);
            Eval(4794, o is Enum[], false);
            Eval(4795, o is Delegate, false);
            Eval(4796, o is Delegate[], false);
            Eval(4797, o is MulticastDelegate, false);
            Eval(4798, o is MulticastDelegate[], false);
            Eval(4799, o is IEmpty, false);
            Eval(4800, o is IEmpty[], false);
            Eval(4801, o is INotEmpty, false);
            Eval(4802, o is INotEmpty[], false);
            Eval(4803, o is IEmptyGen<int>, false);
            Eval(4804, o is IEmptyGen<int>[], false);
            Eval(4805, o is INotEmptyGen<int>, false);
            Eval(4806, o is INotEmptyGen<int>[], false);
            Eval(4807, o is SimpleDelegate, false);
            Eval(4808, o is SimpleDelegate[], false);
            Eval(4809, o is GenericDelegate<int>, false);
            Eval(4810, o is GenericDelegate<int>[], false);
            Eval(4811, o is EmptyClass, false);
            Eval(4812, o is EmptyClass[], false);
            Eval(4813, o is NotEmptyClass, false);
            Eval(4814, o is NotEmptyClass[], false);
            Eval(4815, o is EmptyClassGen<int>, false);
            Eval(4816, o is EmptyClassGen<int>[], false);
            Eval(4817, o is NotEmptyClassGen<Guid>, false);
            Eval(4818, o is NotEmptyClassGen<Guid>[], false);
            Eval(4819, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4820, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4821, o is NestedClass, false);
            Eval(4822, o is NestedClass[], false);
            Eval(4823, o is NestedClassGen<Decimal>, false);
            Eval(4824, o is NestedClassGen<Decimal>[], false);
            Eval(4825, o is ImplementOneInterfaceC, false);
            Eval(4826, o is ImplementOneInterfaceC[], false);
            Eval(4827, o is ImplementTwoInterfaceC, false);
            Eval(4828, o is ImplementTwoInterfaceC[], false);
            Eval(4829, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4830, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4831, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4832, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4833, o is ImplementAllInterfaceC<int>, false);
            Eval(4834, o is ImplementAllInterfaceC<int>[], false);
            Eval(4835, o is SealedClass, false);
            Eval(4836, o is SealedClass[], false);
        }
    }  // end of test case 0013
    private static void TestCase0014()
    {
        {
            long v = default(long);
            IComparable o = v; ;
            Eval(4837, o is ImplementOneInterface, false);
            Eval(4838, o is ImplementOneInterface[], false);
            Eval(4839, o is ImplementOneInterface?, false);
            Eval(4840, o is ImplementOneInterface?[], false);
            Eval(4841, o is ImplementTwoInterface, false);
            Eval(4842, o is ImplementTwoInterface[], false);
            Eval(4843, o is ImplementTwoInterface?, false);
            Eval(4844, o is ImplementTwoInterface?[], false);
            Eval(4845, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4846, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4847, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4848, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4849, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4850, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4851, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4852, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4853, o is ImplementAllInterface<int>, false);
            Eval(4854, o is ImplementAllInterface<int>[], false);
            Eval(4855, o is ImplementAllInterface<int>?, false);
            Eval(4856, o is ImplementAllInterface<int>?[], false);
            Eval(4857, o is char, false);
            Eval(4858, o is char[], false);
            Eval(4859, o is char?, false);
            Eval(4860, o is char?[], false);
            Eval(4861, o is bool, false);
            Eval(4862, o is bool[], false);
            Eval(4863, o is bool?, false);
            Eval(4864, o is bool?[], false);
            Eval(4865, o is byte, false);
            Eval(4866, o is byte[], false);
            Eval(4867, o is byte?, false);
            Eval(4868, o is byte?[], false);
            Eval(4869, o is sbyte, false);
            Eval(4870, o is sbyte[], false);
            Eval(4871, o is sbyte?, false);
            Eval(4872, o is sbyte?[], false);
            Eval(4873, o is short, false);
            Eval(4874, o is short[], false);
            Eval(4875, o is short?, false);
            Eval(4876, o is short?[], false);
            Eval(4877, o is ushort, false);
            Eval(4878, o is ushort[], false);
            Eval(4879, o is ushort?, false);
            Eval(4880, o is ushort?[], false);
            Eval(4881, o is int, false);
            Eval(4882, o is int[], false);
            Eval(4883, o is int?, false);
            Eval(4884, o is int?[], false);
            Eval(4885, o is uint, false);
            Eval(4886, o is uint[], false);
            Eval(4887, o is uint?, false);
            Eval(4888, o is uint?[], false);
            Eval(4889, o is long, true);
            Eval(4890, o is long[], false);
            Eval(4891, o is long?, true);
            Eval(4892, o is long?[], false);
            Eval(4893, o is ulong, false);
            Eval(4894, o is ulong[], false);
            Eval(4895, o is ulong?, false);
            Eval(4896, o is ulong?[], false);
            Eval(4897, o is float, false);
            Eval(4898, o is float[], false);
            Eval(4899, o is float?, false);
            Eval(4900, o is float?[], false);
            Eval(4901, o is double, false);
            Eval(4902, o is double[], false);
            Eval(4903, o is double?, false);
            Eval(4904, o is double?[], false);
            Eval(4905, o is decimal, false);
            Eval(4906, o is decimal[], false);
            Eval(4907, o is decimal?, false);
            Eval(4908, o is decimal?[], false);
            Eval(4909, o is object, true);
            Eval(4910, o is object[], false);
            Eval(4911, o is string, false);
            Eval(4912, o is string[], false);
            Eval(4913, o is ValueType, true);
            Eval(4914, o is ValueType[], false);
            Eval(4915, o is Array, false);
            Eval(4916, o is Array[], false);
            Eval(4917, o is Enum, false);
            Eval(4918, o is Enum[], false);
            Eval(4919, o is Delegate, false);
            Eval(4920, o is Delegate[], false);
            Eval(4921, o is MulticastDelegate, false);
            Eval(4922, o is MulticastDelegate[], false);
            Eval(4923, o is IEmpty, false);
            Eval(4924, o is IEmpty[], false);
            Eval(4925, o is INotEmpty, false);
            Eval(4926, o is INotEmpty[], false);
            Eval(4927, o is IEmptyGen<int>, false);
            Eval(4928, o is IEmptyGen<int>[], false);
            Eval(4929, o is INotEmptyGen<int>, false);
            Eval(4930, o is INotEmptyGen<int>[], false);
            Eval(4931, o is SimpleDelegate, false);
            Eval(4932, o is SimpleDelegate[], false);
            Eval(4933, o is GenericDelegate<int>, false);
            Eval(4934, o is GenericDelegate<int>[], false);
            Eval(4935, o is EmptyClass, false);
            Eval(4936, o is EmptyClass[], false);
            Eval(4937, o is NotEmptyClass, false);
            Eval(4938, o is NotEmptyClass[], false);
            Eval(4939, o is EmptyClassGen<int>, false);
            Eval(4940, o is EmptyClassGen<int>[], false);
            Eval(4941, o is NotEmptyClassGen<Guid>, false);
            Eval(4942, o is NotEmptyClassGen<Guid>[], false);
            Eval(4943, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(4944, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(4945, o is NestedClass, false);
            Eval(4946, o is NestedClass[], false);
            Eval(4947, o is NestedClassGen<Decimal>, false);
            Eval(4948, o is NestedClassGen<Decimal>[], false);
            Eval(4949, o is ImplementOneInterfaceC, false);
            Eval(4950, o is ImplementOneInterfaceC[], false);
            Eval(4951, o is ImplementTwoInterfaceC, false);
            Eval(4952, o is ImplementTwoInterfaceC[], false);
            Eval(4953, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(4954, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(4955, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(4956, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(4957, o is ImplementAllInterfaceC<int>, false);
            Eval(4958, o is ImplementAllInterfaceC<int>[], false);
            Eval(4959, o is SealedClass, false);
            Eval(4960, o is SealedClass[], false);
        }
        {
            long? v = default(long);
            IComparable o = v; ;
            Eval(4961, o is ImplementOneInterface, false);
            Eval(4962, o is ImplementOneInterface[], false);
            Eval(4963, o is ImplementOneInterface?, false);
            Eval(4964, o is ImplementOneInterface?[], false);
            Eval(4965, o is ImplementTwoInterface, false);
            Eval(4966, o is ImplementTwoInterface[], false);
            Eval(4967, o is ImplementTwoInterface?, false);
            Eval(4968, o is ImplementTwoInterface?[], false);
            Eval(4969, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(4970, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(4971, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(4972, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(4973, o is ImplementTwoInterfaceGen<int>, false);
            Eval(4974, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(4975, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(4976, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(4977, o is ImplementAllInterface<int>, false);
            Eval(4978, o is ImplementAllInterface<int>[], false);
            Eval(4979, o is ImplementAllInterface<int>?, false);
            Eval(4980, o is ImplementAllInterface<int>?[], false);
            Eval(4981, o is char, false);
            Eval(4982, o is char[], false);
            Eval(4983, o is char?, false);
            Eval(4984, o is char?[], false);
            Eval(4985, o is bool, false);
            Eval(4986, o is bool[], false);
            Eval(4987, o is bool?, false);
            Eval(4988, o is bool?[], false);
            Eval(4989, o is byte, false);
            Eval(4990, o is byte[], false);
            Eval(4991, o is byte?, false);
            Eval(4992, o is byte?[], false);
            Eval(4993, o is sbyte, false);
            Eval(4994, o is sbyte[], false);
            Eval(4995, o is sbyte?, false);
            Eval(4996, o is sbyte?[], false);
            Eval(4997, o is short, false);
            Eval(4998, o is short[], false);
            Eval(4999, o is short?, false);
            Eval(5000, o is short?[], false);
            Eval(5001, o is ushort, false);
            Eval(5002, o is ushort[], false);
            Eval(5003, o is ushort?, false);
            Eval(5004, o is ushort?[], false);
            Eval(5005, o is int, false);
            Eval(5006, o is int[], false);
            Eval(5007, o is int?, false);
            Eval(5008, o is int?[], false);
            Eval(5009, o is uint, false);
            Eval(5010, o is uint[], false);
            Eval(5011, o is uint?, false);
            Eval(5012, o is uint?[], false);
            Eval(5013, o is long, true);
            Eval(5014, o is long[], false);
            Eval(5015, o is long?, true);
            Eval(5016, o is long?[], false);
            Eval(5017, o is ulong, false);
            Eval(5018, o is ulong[], false);
            Eval(5019, o is ulong?, false);
            Eval(5020, o is ulong?[], false);
            Eval(5021, o is float, false);
            Eval(5022, o is float[], false);
            Eval(5023, o is float?, false);
            Eval(5024, o is float?[], false);
            Eval(5025, o is double, false);
            Eval(5026, o is double[], false);
            Eval(5027, o is double?, false);
            Eval(5028, o is double?[], false);
            Eval(5029, o is decimal, false);
            Eval(5030, o is decimal[], false);
            Eval(5031, o is decimal?, false);
            Eval(5032, o is decimal?[], false);
            Eval(5033, o is object, true);
            Eval(5034, o is object[], false);
            Eval(5035, o is string, false);
            Eval(5036, o is string[], false);
            Eval(5037, o is ValueType, true);
            Eval(5038, o is ValueType[], false);
            Eval(5039, o is Array, false);
            Eval(5040, o is Array[], false);
            Eval(5041, o is Enum, false);
            Eval(5042, o is Enum[], false);
            Eval(5043, o is Delegate, false);
            Eval(5044, o is Delegate[], false);
            Eval(5045, o is MulticastDelegate, false);
            Eval(5046, o is MulticastDelegate[], false);
            Eval(5047, o is IEmpty, false);
            Eval(5048, o is IEmpty[], false);
            Eval(5049, o is INotEmpty, false);
            Eval(5050, o is INotEmpty[], false);
            Eval(5051, o is IEmptyGen<int>, false);
            Eval(5052, o is IEmptyGen<int>[], false);
            Eval(5053, o is INotEmptyGen<int>, false);
            Eval(5054, o is INotEmptyGen<int>[], false);
            Eval(5055, o is SimpleDelegate, false);
            Eval(5056, o is SimpleDelegate[], false);
            Eval(5057, o is GenericDelegate<int>, false);
            Eval(5058, o is GenericDelegate<int>[], false);
            Eval(5059, o is EmptyClass, false);
            Eval(5060, o is EmptyClass[], false);
            Eval(5061, o is NotEmptyClass, false);
            Eval(5062, o is NotEmptyClass[], false);
            Eval(5063, o is EmptyClassGen<int>, false);
            Eval(5064, o is EmptyClassGen<int>[], false);
            Eval(5065, o is NotEmptyClassGen<Guid>, false);
            Eval(5066, o is NotEmptyClassGen<Guid>[], false);
            Eval(5067, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(5068, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(5069, o is NestedClass, false);
            Eval(5070, o is NestedClass[], false);
            Eval(5071, o is NestedClassGen<Decimal>, false);
            Eval(5072, o is NestedClassGen<Decimal>[], false);
            Eval(5073, o is ImplementOneInterfaceC, false);
            Eval(5074, o is ImplementOneInterfaceC[], false);
            Eval(5075, o is ImplementTwoInterfaceC, false);
            Eval(5076, o is ImplementTwoInterfaceC[], false);
            Eval(5077, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(5078, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(5079, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(5080, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(5081, o is ImplementAllInterfaceC<int>, false);
            Eval(5082, o is ImplementAllInterfaceC<int>[], false);
            Eval(5083, o is SealedClass, false);
            Eval(5084, o is SealedClass[], false);
        }
        {
            long? v = default(long?);
            IComparable o = v; ;
            Eval(5085, o is ImplementOneInterface, false);
            Eval(5086, o is ImplementOneInterface[], false);
            Eval(5087, o is ImplementOneInterface?, false);
            Eval(5088, o is ImplementOneInterface?[], false);
            Eval(5089, o is ImplementTwoInterface, false);
            Eval(5090, o is ImplementTwoInterface[], false);
            Eval(5091, o is ImplementTwoInterface?, false);
            Eval(5092, o is ImplementTwoInterface?[], false);
            Eval(5093, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5094, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5095, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5096, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5097, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5098, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5099, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5100, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5101, o is ImplementAllInterface<int>, false);
            Eval(5102, o is ImplementAllInterface<int>[], false);
            Eval(5103, o is ImplementAllInterface<int>?, false);
            Eval(5104, o is ImplementAllInterface<int>?[], false);
            Eval(5105, o is char, false);
            Eval(5106, o is char[], false);
            Eval(5107, o is char?, false);
            Eval(5108, o is char?[], false);
            Eval(5109, o is bool, false);
            Eval(5110, o is bool[], false);
            Eval(5111, o is bool?, false);
            Eval(5112, o is bool?[], false);
            Eval(5113, o is byte, false);
            Eval(5114, o is byte[], false);
            Eval(5115, o is byte?, false);
            Eval(5116, o is byte?[], false);
            Eval(5117, o is sbyte, false);
            Eval(5118, o is sbyte[], false);
            Eval(5119, o is sbyte?, false);
            Eval(5120, o is sbyte?[], false);
            Eval(5121, o is short, false);
            Eval(5122, o is short[], false);
            Eval(5123, o is short?, false);
            Eval(5124, o is short?[], false);
            Eval(5125, o is ushort, false);
            Eval(5126, o is ushort[], false);
            Eval(5127, o is ushort?, false);
            Eval(5128, o is ushort?[], false);
            Eval(5129, o is int, false);
            Eval(5130, o is int[], false);
            Eval(5131, o is int?, false);
            Eval(5132, o is int?[], false);
            Eval(5133, o is uint, false);
            Eval(5134, o is uint[], false);
            Eval(5135, o is uint?, false);
            Eval(5136, o is uint?[], false);
            Eval(5137, o is long, false);
            Eval(5138, o is long[], false);
            Eval(5139, o is long?, false);
            Eval(5140, o is long?[], false);
            Eval(5141, o is ulong, false);
            Eval(5142, o is ulong[], false);
            Eval(5143, o is ulong?, false);
            Eval(5144, o is ulong?[], false);
            Eval(5145, o is float, false);
            Eval(5146, o is float[], false);
            Eval(5147, o is float?, false);
            Eval(5148, o is float?[], false);
            Eval(5149, o is double, false);
            Eval(5150, o is double[], false);
            Eval(5151, o is double?, false);
            Eval(5152, o is double?[], false);
            Eval(5153, o is decimal, false);
            Eval(5154, o is decimal[], false);
            Eval(5155, o is decimal?, false);
            Eval(5156, o is decimal?[], false);
            Eval(5157, o is object, false);
            Eval(5158, o is object[], false);
            Eval(5159, o is string, false);
            Eval(5160, o is string[], false);
            Eval(5161, o is ValueType, false);
            Eval(5162, o is ValueType[], false);
            Eval(5163, o is Array, false);
            Eval(5164, o is Array[], false);
            Eval(5165, o is Enum, false);
            Eval(5166, o is Enum[], false);
            Eval(5167, o is Delegate, false);
            Eval(5168, o is Delegate[], false);
            Eval(5169, o is MulticastDelegate, false);
            Eval(5170, o is MulticastDelegate[], false);
            Eval(5171, o is IEmpty, false);
            Eval(5172, o is IEmpty[], false);
            Eval(5173, o is INotEmpty, false);
            Eval(5174, o is INotEmpty[], false);
            Eval(5175, o is IEmptyGen<int>, false);
            Eval(5176, o is IEmptyGen<int>[], false);
            Eval(5177, o is INotEmptyGen<int>, false);
            Eval(5178, o is INotEmptyGen<int>[], false);
            Eval(5179, o is SimpleDelegate, false);
            Eval(5180, o is SimpleDelegate[], false);
            Eval(5181, o is GenericDelegate<int>, false);
            Eval(5182, o is GenericDelegate<int>[], false);
            Eval(5183, o is EmptyClass, false);
            Eval(5184, o is EmptyClass[], false);
            Eval(5185, o is NotEmptyClass, false);
            Eval(5186, o is NotEmptyClass[], false);
            Eval(5187, o is EmptyClassGen<int>, false);
            Eval(5188, o is EmptyClassGen<int>[], false);
            Eval(5189, o is NotEmptyClassGen<Guid>, false);
            Eval(5190, o is NotEmptyClassGen<Guid>[], false);
            Eval(5191, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(5192, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(5193, o is NestedClass, false);
            Eval(5194, o is NestedClass[], false);
            Eval(5195, o is NestedClassGen<Decimal>, false);
            Eval(5196, o is NestedClassGen<Decimal>[], false);
            Eval(5197, o is ImplementOneInterfaceC, false);
            Eval(5198, o is ImplementOneInterfaceC[], false);
            Eval(5199, o is ImplementTwoInterfaceC, false);
            Eval(5200, o is ImplementTwoInterfaceC[], false);
            Eval(5201, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(5202, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(5203, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(5204, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(5205, o is ImplementAllInterfaceC<int>, false);
            Eval(5206, o is ImplementAllInterfaceC<int>[], false);
            Eval(5207, o is SealedClass, false);
            Eval(5208, o is SealedClass[], false);
        }
    }  // end of test case 0014
    private static void TestCase0015()
    {
        {
            ulong v = default(ulong);
            IComparable o = v; ;
            Eval(5209, o is ImplementOneInterface, false);
            Eval(5210, o is ImplementOneInterface[], false);
            Eval(5211, o is ImplementOneInterface?, false);
            Eval(5212, o is ImplementOneInterface?[], false);
            Eval(5213, o is ImplementTwoInterface, false);
            Eval(5214, o is ImplementTwoInterface[], false);
            Eval(5215, o is ImplementTwoInterface?, false);
            Eval(5216, o is ImplementTwoInterface?[], false);
            Eval(5217, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5218, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5219, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5220, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5221, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5222, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5223, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5224, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5225, o is ImplementAllInterface<int>, false);
            Eval(5226, o is ImplementAllInterface<int>[], false);
            Eval(5227, o is ImplementAllInterface<int>?, false);
            Eval(5228, o is ImplementAllInterface<int>?[], false);
            Eval(5229, o is char, false);
            Eval(5230, o is char[], false);
            Eval(5231, o is char?, false);
            Eval(5232, o is char?[], false);
            Eval(5233, o is bool, false);
            Eval(5234, o is bool[], false);
            Eval(5235, o is bool?, false);
            Eval(5236, o is bool?[], false);
            Eval(5237, o is byte, false);
            Eval(5238, o is byte[], false);
            Eval(5239, o is byte?, false);
            Eval(5240, o is byte?[], false);
            Eval(5241, o is sbyte, false);
            Eval(5242, o is sbyte[], false);
            Eval(5243, o is sbyte?, false);
            Eval(5244, o is sbyte?[], false);
            Eval(5245, o is short, false);
            Eval(5246, o is short[], false);
            Eval(5247, o is short?, false);
            Eval(5248, o is short?[], false);
            Eval(5249, o is ushort, false);
            Eval(5250, o is ushort[], false);
            Eval(5251, o is ushort?, false);
            Eval(5252, o is ushort?[], false);
            Eval(5253, o is int, false);
            Eval(5254, o is int[], false);
            Eval(5255, o is int?, false);
            Eval(5256, o is int?[], false);
            Eval(5257, o is uint, false);
            Eval(5258, o is uint[], false);
            Eval(5259, o is uint?, false);
            Eval(5260, o is uint?[], false);
            Eval(5261, o is long, false);
            Eval(5262, o is long[], false);
            Eval(5263, o is long?, false);
            Eval(5264, o is long?[], false);
            Eval(5265, o is ulong, true);
            Eval(5266, o is ulong[], false);
            Eval(5267, o is ulong?, true);
            Eval(5268, o is ulong?[], false);
            Eval(5269, o is float, false);
            Eval(5270, o is float[], false);
            Eval(5271, o is float?, false);
            Eval(5272, o is float?[], false);
            Eval(5273, o is double, false);
            Eval(5274, o is double[], false);
            Eval(5275, o is double?, false);
            Eval(5276, o is double?[], false);
            Eval(5277, o is decimal, false);
            Eval(5278, o is decimal[], false);
            Eval(5279, o is decimal?, false);
            Eval(5280, o is decimal?[], false);
            Eval(5281, o is object, true);
            Eval(5282, o is object[], false);
            Eval(5283, o is string, false);
            Eval(5284, o is string[], false);
            Eval(5285, o is ValueType, true);
            Eval(5286, o is ValueType[], false);
            Eval(5287, o is Array, false);
            Eval(5288, o is Array[], false);
            Eval(5289, o is Enum, false);
            Eval(5290, o is Enum[], false);
            Eval(5291, o is Delegate, false);
            Eval(5292, o is Delegate[], false);
            Eval(5293, o is MulticastDelegate, false);
            Eval(5294, o is MulticastDelegate[], false);
            Eval(5295, o is IEmpty, false);
            Eval(5296, o is IEmpty[], false);
            Eval(5297, o is INotEmpty, false);
            Eval(5298, o is INotEmpty[], false);
            Eval(5299, o is IEmptyGen<int>, false);
            Eval(5300, o is IEmptyGen<int>[], false);
            Eval(5301, o is INotEmptyGen<int>, false);
            Eval(5302, o is INotEmptyGen<int>[], false);
            Eval(5303, o is SimpleDelegate, false);
            Eval(5304, o is SimpleDelegate[], false);
            Eval(5305, o is GenericDelegate<int>, false);
            Eval(5306, o is GenericDelegate<int>[], false);
            Eval(5307, o is EmptyClass, false);
            Eval(5308, o is EmptyClass[], false);
            Eval(5309, o is NotEmptyClass, false);
            Eval(5310, o is NotEmptyClass[], false);
            Eval(5311, o is EmptyClassGen<int>, false);
            Eval(5312, o is EmptyClassGen<int>[], false);
            Eval(5313, o is NotEmptyClassGen<Guid>, false);
            Eval(5314, o is NotEmptyClassGen<Guid>[], false);
            Eval(5315, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(5316, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(5317, o is NestedClass, false);
            Eval(5318, o is NestedClass[], false);
            Eval(5319, o is NestedClassGen<Decimal>, false);
            Eval(5320, o is NestedClassGen<Decimal>[], false);
            Eval(5321, o is ImplementOneInterfaceC, false);
            Eval(5322, o is ImplementOneInterfaceC[], false);
            Eval(5323, o is ImplementTwoInterfaceC, false);
            Eval(5324, o is ImplementTwoInterfaceC[], false);
            Eval(5325, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(5326, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(5327, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(5328, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(5329, o is ImplementAllInterfaceC<int>, false);
            Eval(5330, o is ImplementAllInterfaceC<int>[], false);
            Eval(5331, o is SealedClass, false);
            Eval(5332, o is SealedClass[], false);
        }
        {
            ulong? v = default(ulong);
            IComparable o = v; ;
            Eval(5333, o is ImplementOneInterface, false);
            Eval(5334, o is ImplementOneInterface[], false);
            Eval(5335, o is ImplementOneInterface?, false);
            Eval(5336, o is ImplementOneInterface?[], false);
            Eval(5337, o is ImplementTwoInterface, false);
            Eval(5338, o is ImplementTwoInterface[], false);
            Eval(5339, o is ImplementTwoInterface?, false);
            Eval(5340, o is ImplementTwoInterface?[], false);
            Eval(5341, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5342, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5343, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5344, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5345, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5346, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5347, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5348, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5349, o is ImplementAllInterface<int>, false);
            Eval(5350, o is ImplementAllInterface<int>[], false);
            Eval(5351, o is ImplementAllInterface<int>?, false);
            Eval(5352, o is ImplementAllInterface<int>?[], false);
            Eval(5353, o is char, false);
            Eval(5354, o is char[], false);
            Eval(5355, o is char?, false);
            Eval(5356, o is char?[], false);
            Eval(5357, o is bool, false);
            Eval(5358, o is bool[], false);
            Eval(5359, o is bool?, false);
            Eval(5360, o is bool?[], false);
            Eval(5361, o is byte, false);
            Eval(5362, o is byte[], false);
            Eval(5363, o is byte?, false);
            Eval(5364, o is byte?[], false);
            Eval(5365, o is sbyte, false);
            Eval(5366, o is sbyte[], false);
            Eval(5367, o is sbyte?, false);
            Eval(5368, o is sbyte?[], false);
            Eval(5369, o is short, false);
            Eval(5370, o is short[], false);
            Eval(5371, o is short?, false);
            Eval(5372, o is short?[], false);
            Eval(5373, o is ushort, false);
            Eval(5374, o is ushort[], false);
            Eval(5375, o is ushort?, false);
            Eval(5376, o is ushort?[], false);
            Eval(5377, o is int, false);
            Eval(5378, o is int[], false);
            Eval(5379, o is int?, false);
            Eval(5380, o is int?[], false);
            Eval(5381, o is uint, false);
            Eval(5382, o is uint[], false);
            Eval(5383, o is uint?, false);
            Eval(5384, o is uint?[], false);
            Eval(5385, o is long, false);
            Eval(5386, o is long[], false);
            Eval(5387, o is long?, false);
            Eval(5388, o is long?[], false);
            Eval(5389, o is ulong, true);
            Eval(5390, o is ulong[], false);
            Eval(5391, o is ulong?, true);
            Eval(5392, o is ulong?[], false);
            Eval(5393, o is float, false);
            Eval(5394, o is float[], false);
            Eval(5395, o is float?, false);
            Eval(5396, o is float?[], false);
            Eval(5397, o is double, false);
            Eval(5398, o is double[], false);
            Eval(5399, o is double?, false);
            Eval(5400, o is double?[], false);
            Eval(5401, o is decimal, false);
            Eval(5402, o is decimal[], false);
            Eval(5403, o is decimal?, false);
            Eval(5404, o is decimal?[], false);
            Eval(5405, o is object, true);
            Eval(5406, o is object[], false);
            Eval(5407, o is string, false);
            Eval(5408, o is string[], false);
            Eval(5409, o is ValueType, true);
            Eval(5410, o is ValueType[], false);
            Eval(5411, o is Array, false);
            Eval(5412, o is Array[], false);
            Eval(5413, o is Enum, false);
            Eval(5414, o is Enum[], false);
            Eval(5415, o is Delegate, false);
            Eval(5416, o is Delegate[], false);
            Eval(5417, o is MulticastDelegate, false);
            Eval(5418, o is MulticastDelegate[], false);
            Eval(5419, o is IEmpty, false);
            Eval(5420, o is IEmpty[], false);
            Eval(5421, o is INotEmpty, false);
            Eval(5422, o is INotEmpty[], false);
            Eval(5423, o is IEmptyGen<int>, false);
            Eval(5424, o is IEmptyGen<int>[], false);
            Eval(5425, o is INotEmptyGen<int>, false);
            Eval(5426, o is INotEmptyGen<int>[], false);
            Eval(5427, o is SimpleDelegate, false);
            Eval(5428, o is SimpleDelegate[], false);
            Eval(5429, o is GenericDelegate<int>, false);
            Eval(5430, o is GenericDelegate<int>[], false);
            Eval(5431, o is EmptyClass, false);
            Eval(5432, o is EmptyClass[], false);
            Eval(5433, o is NotEmptyClass, false);
            Eval(5434, o is NotEmptyClass[], false);
            Eval(5435, o is EmptyClassGen<int>, false);
            Eval(5436, o is EmptyClassGen<int>[], false);
            Eval(5437, o is NotEmptyClassGen<Guid>, false);
            Eval(5438, o is NotEmptyClassGen<Guid>[], false);
            Eval(5439, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(5440, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(5441, o is NestedClass, false);
            Eval(5442, o is NestedClass[], false);
            Eval(5443, o is NestedClassGen<Decimal>, false);
            Eval(5444, o is NestedClassGen<Decimal>[], false);
            Eval(5445, o is ImplementOneInterfaceC, false);
            Eval(5446, o is ImplementOneInterfaceC[], false);
            Eval(5447, o is ImplementTwoInterfaceC, false);
            Eval(5448, o is ImplementTwoInterfaceC[], false);
            Eval(5449, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(5450, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(5451, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(5452, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(5453, o is ImplementAllInterfaceC<int>, false);
            Eval(5454, o is ImplementAllInterfaceC<int>[], false);
            Eval(5455, o is SealedClass, false);
            Eval(5456, o is SealedClass[], false);
        }
        {
            ulong? v = default(ulong?);
            IComparable o = v; ;
            Eval(5457, o is ImplementOneInterface, false);
            Eval(5458, o is ImplementOneInterface[], false);
            Eval(5459, o is ImplementOneInterface?, false);
            Eval(5460, o is ImplementOneInterface?[], false);
            Eval(5461, o is ImplementTwoInterface, false);
            Eval(5462, o is ImplementTwoInterface[], false);
            Eval(5463, o is ImplementTwoInterface?, false);
            Eval(5464, o is ImplementTwoInterface?[], false);
            Eval(5465, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5466, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5467, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5468, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5469, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5470, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5471, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5472, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5473, o is ImplementAllInterface<int>, false);
            Eval(5474, o is ImplementAllInterface<int>[], false);
            Eval(5475, o is ImplementAllInterface<int>?, false);
            Eval(5476, o is ImplementAllInterface<int>?[], false);
            Eval(5477, o is char, false);
            Eval(5478, o is char[], false);
            Eval(5479, o is char?, false);
            Eval(5480, o is char?[], false);
            Eval(5481, o is bool, false);
            Eval(5482, o is bool[], false);
            Eval(5483, o is bool?, false);
            Eval(5484, o is bool?[], false);
            Eval(5485, o is byte, false);
            Eval(5486, o is byte[], false);
            Eval(5487, o is byte?, false);
            Eval(5488, o is byte?[], false);
            Eval(5489, o is sbyte, false);
            Eval(5490, o is sbyte[], false);
            Eval(5491, o is sbyte?, false);
            Eval(5492, o is sbyte?[], false);
            Eval(5493, o is short, false);
            Eval(5494, o is short[], false);
            Eval(5495, o is short?, false);
            Eval(5496, o is short?[], false);
            Eval(5497, o is ushort, false);
            Eval(5498, o is ushort[], false);
            Eval(5499, o is ushort?, false);
            Eval(5500, o is ushort?[], false);
            Eval(5501, o is int, false);
            Eval(5502, o is int[], false);
            Eval(5503, o is int?, false);
            Eval(5504, o is int?[], false);
            Eval(5505, o is uint, false);
            Eval(5506, o is uint[], false);
            Eval(5507, o is uint?, false);
            Eval(5508, o is uint?[], false);
            Eval(5509, o is long, false);
            Eval(5510, o is long[], false);
            Eval(5511, o is long?, false);
            Eval(5512, o is long?[], false);
            Eval(5513, o is ulong, false);
            Eval(5514, o is ulong[], false);
            Eval(5515, o is ulong?, false);
            Eval(5516, o is ulong?[], false);
            Eval(5517, o is float, false);
            Eval(5518, o is float[], false);
            Eval(5519, o is float?, false);
            Eval(5520, o is float?[], false);
            Eval(5521, o is double, false);
            Eval(5522, o is double[], false);
            Eval(5523, o is double?, false);
            Eval(5524, o is double?[], false);
            Eval(5525, o is decimal, false);
            Eval(5526, o is decimal[], false);
            Eval(5527, o is decimal?, false);
            Eval(5528, o is decimal?[], false);
            Eval(5529, o is object, false);
            Eval(5530, o is object[], false);
            Eval(5531, o is string, false);
            Eval(5532, o is string[], false);
            Eval(5533, o is ValueType, false);
            Eval(5534, o is ValueType[], false);
            Eval(5535, o is Array, false);
            Eval(5536, o is Array[], false);
            Eval(5537, o is Enum, false);
            Eval(5538, o is Enum[], false);
            Eval(5539, o is Delegate, false);
            Eval(5540, o is Delegate[], false);
            Eval(5541, o is MulticastDelegate, false);
            Eval(5542, o is MulticastDelegate[], false);
            Eval(5543, o is IEmpty, false);
            Eval(5544, o is IEmpty[], false);
            Eval(5545, o is INotEmpty, false);
            Eval(5546, o is INotEmpty[], false);
            Eval(5547, o is IEmptyGen<int>, false);
            Eval(5548, o is IEmptyGen<int>[], false);
            Eval(5549, o is INotEmptyGen<int>, false);
            Eval(5550, o is INotEmptyGen<int>[], false);
            Eval(5551, o is SimpleDelegate, false);
            Eval(5552, o is SimpleDelegate[], false);
            Eval(5553, o is GenericDelegate<int>, false);
            Eval(5554, o is GenericDelegate<int>[], false);
            Eval(5555, o is EmptyClass, false);
            Eval(5556, o is EmptyClass[], false);
            Eval(5557, o is NotEmptyClass, false);
            Eval(5558, o is NotEmptyClass[], false);
            Eval(5559, o is EmptyClassGen<int>, false);
            Eval(5560, o is EmptyClassGen<int>[], false);
            Eval(5561, o is NotEmptyClassGen<Guid>, false);
            Eval(5562, o is NotEmptyClassGen<Guid>[], false);
            Eval(5563, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(5564, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(5565, o is NestedClass, false);
            Eval(5566, o is NestedClass[], false);
            Eval(5567, o is NestedClassGen<Decimal>, false);
            Eval(5568, o is NestedClassGen<Decimal>[], false);
            Eval(5569, o is ImplementOneInterfaceC, false);
            Eval(5570, o is ImplementOneInterfaceC[], false);
            Eval(5571, o is ImplementTwoInterfaceC, false);
            Eval(5572, o is ImplementTwoInterfaceC[], false);
            Eval(5573, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(5574, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(5575, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(5576, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(5577, o is ImplementAllInterfaceC<int>, false);
            Eval(5578, o is ImplementAllInterfaceC<int>[], false);
            Eval(5579, o is SealedClass, false);
            Eval(5580, o is SealedClass[], false);
        }
    }  // end of test case 0015
    private static void TestCase0016()
    {
        {
            float v = default(float);
            IComparable o = v; ;
            Eval(5581, o is ImplementOneInterface, false);
            Eval(5582, o is ImplementOneInterface[], false);
            Eval(5583, o is ImplementOneInterface?, false);
            Eval(5584, o is ImplementOneInterface?[], false);
            Eval(5585, o is ImplementTwoInterface, false);
            Eval(5586, o is ImplementTwoInterface[], false);
            Eval(5587, o is ImplementTwoInterface?, false);
            Eval(5588, o is ImplementTwoInterface?[], false);
            Eval(5589, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5590, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5591, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5592, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5593, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5594, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5595, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5596, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5597, o is ImplementAllInterface<int>, false);
            Eval(5598, o is ImplementAllInterface<int>[], false);
            Eval(5599, o is ImplementAllInterface<int>?, false);
            Eval(5600, o is ImplementAllInterface<int>?[], false);
            Eval(5601, o is char, false);
            Eval(5602, o is char[], false);
            Eval(5603, o is char?, false);
            Eval(5604, o is char?[], false);
            Eval(5605, o is bool, false);
            Eval(5606, o is bool[], false);
            Eval(5607, o is bool?, false);
            Eval(5608, o is bool?[], false);
            Eval(5609, o is byte, false);
            Eval(5610, o is byte[], false);
            Eval(5611, o is byte?, false);
            Eval(5612, o is byte?[], false);
            Eval(5613, o is sbyte, false);
            Eval(5614, o is sbyte[], false);
            Eval(5615, o is sbyte?, false);
            Eval(5616, o is sbyte?[], false);
            Eval(5617, o is short, false);
            Eval(5618, o is short[], false);
            Eval(5619, o is short?, false);
            Eval(5620, o is short?[], false);
            Eval(5621, o is ushort, false);
            Eval(5622, o is ushort[], false);
            Eval(5623, o is ushort?, false);
            Eval(5624, o is ushort?[], false);
            Eval(5625, o is int, false);
            Eval(5626, o is int[], false);
            Eval(5627, o is int?, false);
            Eval(5628, o is int?[], false);
            Eval(5629, o is uint, false);
            Eval(5630, o is uint[], false);
            Eval(5631, o is uint?, false);
            Eval(5632, o is uint?[], false);
            Eval(5633, o is long, false);
            Eval(5634, o is long[], false);
            Eval(5635, o is long?, false);
            Eval(5636, o is long?[], false);
            Eval(5637, o is ulong, false);
            Eval(5638, o is ulong[], false);
            Eval(5639, o is ulong?, false);
            Eval(5640, o is ulong?[], false);
            Eval(5641, o is float, true);
            Eval(5642, o is float[], false);
            Eval(5643, o is float?, true);
            Eval(5644, o is float?[], false);
            Eval(5645, o is double, false);
            Eval(5646, o is double[], false);
            Eval(5647, o is double?, false);
            Eval(5648, o is double?[], false);
            Eval(5649, o is decimal, false);
            Eval(5650, o is decimal[], false);
            Eval(5651, o is decimal?, false);
            Eval(5652, o is decimal?[], false);
            Eval(5653, o is object, true);
            Eval(5654, o is object[], false);
            Eval(5655, o is string, false);
            Eval(5656, o is string[], false);
            Eval(5657, o is ValueType, true);
            Eval(5658, o is ValueType[], false);
            Eval(5659, o is Array, false);
            Eval(5660, o is Array[], false);
            Eval(5661, o is Enum, false);
            Eval(5662, o is Enum[], false);
            Eval(5663, o is Delegate, false);
            Eval(5664, o is Delegate[], false);
            Eval(5665, o is MulticastDelegate, false);
            Eval(5666, o is MulticastDelegate[], false);
            Eval(5667, o is IEmpty, false);
            Eval(5668, o is IEmpty[], false);
            Eval(5669, o is INotEmpty, false);
            Eval(5670, o is INotEmpty[], false);
            Eval(5671, o is IEmptyGen<int>, false);
            Eval(5672, o is IEmptyGen<int>[], false);
            Eval(5673, o is INotEmptyGen<int>, false);
            Eval(5674, o is INotEmptyGen<int>[], false);
            Eval(5675, o is SimpleDelegate, false);
            Eval(5676, o is SimpleDelegate[], false);
            Eval(5677, o is GenericDelegate<int>, false);
            Eval(5678, o is GenericDelegate<int>[], false);
            Eval(5679, o is EmptyClass, false);
            Eval(5680, o is EmptyClass[], false);
            Eval(5681, o is NotEmptyClass, false);
            Eval(5682, o is NotEmptyClass[], false);
            Eval(5683, o is EmptyClassGen<int>, false);
            Eval(5684, o is EmptyClassGen<int>[], false);
            Eval(5685, o is NotEmptyClassGen<Guid>, false);
            Eval(5686, o is NotEmptyClassGen<Guid>[], false);
            Eval(5687, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(5688, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(5689, o is NestedClass, false);
            Eval(5690, o is NestedClass[], false);
            Eval(5691, o is NestedClassGen<Decimal>, false);
            Eval(5692, o is NestedClassGen<Decimal>[], false);
            Eval(5693, o is ImplementOneInterfaceC, false);
            Eval(5694, o is ImplementOneInterfaceC[], false);
            Eval(5695, o is ImplementTwoInterfaceC, false);
            Eval(5696, o is ImplementTwoInterfaceC[], false);
            Eval(5697, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(5698, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(5699, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(5700, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(5701, o is ImplementAllInterfaceC<int>, false);
            Eval(5702, o is ImplementAllInterfaceC<int>[], false);
            Eval(5703, o is SealedClass, false);
            Eval(5704, o is SealedClass[], false);
        }
        {
            float? v = default(float);
            IComparable o = v; ;
            Eval(5705, o is ImplementOneInterface, false);
            Eval(5706, o is ImplementOneInterface[], false);
            Eval(5707, o is ImplementOneInterface?, false);
            Eval(5708, o is ImplementOneInterface?[], false);
            Eval(5709, o is ImplementTwoInterface, false);
            Eval(5710, o is ImplementTwoInterface[], false);
            Eval(5711, o is ImplementTwoInterface?, false);
            Eval(5712, o is ImplementTwoInterface?[], false);
            Eval(5713, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5714, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5715, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5716, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5717, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5718, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5719, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5720, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5721, o is ImplementAllInterface<int>, false);
            Eval(5722, o is ImplementAllInterface<int>[], false);
            Eval(5723, o is ImplementAllInterface<int>?, false);
            Eval(5724, o is ImplementAllInterface<int>?[], false);
            Eval(5725, o is char, false);
            Eval(5726, o is char[], false);
            Eval(5727, o is char?, false);
            Eval(5728, o is char?[], false);
            Eval(5729, o is bool, false);
            Eval(5730, o is bool[], false);
            Eval(5731, o is bool?, false);
            Eval(5732, o is bool?[], false);
            Eval(5733, o is byte, false);
            Eval(5734, o is byte[], false);
            Eval(5735, o is byte?, false);
            Eval(5736, o is byte?[], false);
            Eval(5737, o is sbyte, false);
            Eval(5738, o is sbyte[], false);
            Eval(5739, o is sbyte?, false);
            Eval(5740, o is sbyte?[], false);
            Eval(5741, o is short, false);
            Eval(5742, o is short[], false);
            Eval(5743, o is short?, false);
            Eval(5744, o is short?[], false);
            Eval(5745, o is ushort, false);
            Eval(5746, o is ushort[], false);
            Eval(5747, o is ushort?, false);
            Eval(5748, o is ushort?[], false);
            Eval(5749, o is int, false);
            Eval(5750, o is int[], false);
            Eval(5751, o is int?, false);
            Eval(5752, o is int?[], false);
            Eval(5753, o is uint, false);
            Eval(5754, o is uint[], false);
            Eval(5755, o is uint?, false);
            Eval(5756, o is uint?[], false);
            Eval(5757, o is long, false);
            Eval(5758, o is long[], false);
            Eval(5759, o is long?, false);
            Eval(5760, o is long?[], false);
            Eval(5761, o is ulong, false);
            Eval(5762, o is ulong[], false);
            Eval(5763, o is ulong?, false);
            Eval(5764, o is ulong?[], false);
            Eval(5765, o is float, true);
            Eval(5766, o is float[], false);
            Eval(5767, o is float?, true);
            Eval(5768, o is float?[], false);
            Eval(5769, o is double, false);
            Eval(5770, o is double[], false);
            Eval(5771, o is double?, false);
            Eval(5772, o is double?[], false);
            Eval(5773, o is decimal, false);
            Eval(5774, o is decimal[], false);
            Eval(5775, o is decimal?, false);
            Eval(5776, o is decimal?[], false);
            Eval(5777, o is object, true);
            Eval(5778, o is object[], false);
            Eval(5779, o is string, false);
            Eval(5780, o is string[], false);
            Eval(5781, o is ValueType, true);
            Eval(5782, o is ValueType[], false);
            Eval(5783, o is Array, false);
            Eval(5784, o is Array[], false);
            Eval(5785, o is Enum, false);
            Eval(5786, o is Enum[], false);
            Eval(5787, o is Delegate, false);
            Eval(5788, o is Delegate[], false);
            Eval(5789, o is MulticastDelegate, false);
            Eval(5790, o is MulticastDelegate[], false);
            Eval(5791, o is IEmpty, false);
            Eval(5792, o is IEmpty[], false);
            Eval(5793, o is INotEmpty, false);
            Eval(5794, o is INotEmpty[], false);
            Eval(5795, o is IEmptyGen<int>, false);
            Eval(5796, o is IEmptyGen<int>[], false);
            Eval(5797, o is INotEmptyGen<int>, false);
            Eval(5798, o is INotEmptyGen<int>[], false);
            Eval(5799, o is SimpleDelegate, false);
            Eval(5800, o is SimpleDelegate[], false);
            Eval(5801, o is GenericDelegate<int>, false);
            Eval(5802, o is GenericDelegate<int>[], false);
            Eval(5803, o is EmptyClass, false);
            Eval(5804, o is EmptyClass[], false);
            Eval(5805, o is NotEmptyClass, false);
            Eval(5806, o is NotEmptyClass[], false);
            Eval(5807, o is EmptyClassGen<int>, false);
            Eval(5808, o is EmptyClassGen<int>[], false);
            Eval(5809, o is NotEmptyClassGen<Guid>, false);
            Eval(5810, o is NotEmptyClassGen<Guid>[], false);
            Eval(5811, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(5812, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(5813, o is NestedClass, false);
            Eval(5814, o is NestedClass[], false);
            Eval(5815, o is NestedClassGen<Decimal>, false);
            Eval(5816, o is NestedClassGen<Decimal>[], false);
            Eval(5817, o is ImplementOneInterfaceC, false);
            Eval(5818, o is ImplementOneInterfaceC[], false);
            Eval(5819, o is ImplementTwoInterfaceC, false);
            Eval(5820, o is ImplementTwoInterfaceC[], false);
            Eval(5821, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(5822, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(5823, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(5824, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(5825, o is ImplementAllInterfaceC<int>, false);
            Eval(5826, o is ImplementAllInterfaceC<int>[], false);
            Eval(5827, o is SealedClass, false);
            Eval(5828, o is SealedClass[], false);
        }
        {
            float? v = default(float?);
            IComparable o = v; ;
            Eval(5829, o is ImplementOneInterface, false);
            Eval(5830, o is ImplementOneInterface[], false);
            Eval(5831, o is ImplementOneInterface?, false);
            Eval(5832, o is ImplementOneInterface?[], false);
            Eval(5833, o is ImplementTwoInterface, false);
            Eval(5834, o is ImplementTwoInterface[], false);
            Eval(5835, o is ImplementTwoInterface?, false);
            Eval(5836, o is ImplementTwoInterface?[], false);
            Eval(5837, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5838, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5839, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5840, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5841, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5842, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5843, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5844, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5845, o is ImplementAllInterface<int>, false);
            Eval(5846, o is ImplementAllInterface<int>[], false);
            Eval(5847, o is ImplementAllInterface<int>?, false);
            Eval(5848, o is ImplementAllInterface<int>?[], false);
            Eval(5849, o is char, false);
            Eval(5850, o is char[], false);
            Eval(5851, o is char?, false);
            Eval(5852, o is char?[], false);
            Eval(5853, o is bool, false);
            Eval(5854, o is bool[], false);
            Eval(5855, o is bool?, false);
            Eval(5856, o is bool?[], false);
            Eval(5857, o is byte, false);
            Eval(5858, o is byte[], false);
            Eval(5859, o is byte?, false);
            Eval(5860, o is byte?[], false);
            Eval(5861, o is sbyte, false);
            Eval(5862, o is sbyte[], false);
            Eval(5863, o is sbyte?, false);
            Eval(5864, o is sbyte?[], false);
            Eval(5865, o is short, false);
            Eval(5866, o is short[], false);
            Eval(5867, o is short?, false);
            Eval(5868, o is short?[], false);
            Eval(5869, o is ushort, false);
            Eval(5870, o is ushort[], false);
            Eval(5871, o is ushort?, false);
            Eval(5872, o is ushort?[], false);
            Eval(5873, o is int, false);
            Eval(5874, o is int[], false);
            Eval(5875, o is int?, false);
            Eval(5876, o is int?[], false);
            Eval(5877, o is uint, false);
            Eval(5878, o is uint[], false);
            Eval(5879, o is uint?, false);
            Eval(5880, o is uint?[], false);
            Eval(5881, o is long, false);
            Eval(5882, o is long[], false);
            Eval(5883, o is long?, false);
            Eval(5884, o is long?[], false);
            Eval(5885, o is ulong, false);
            Eval(5886, o is ulong[], false);
            Eval(5887, o is ulong?, false);
            Eval(5888, o is ulong?[], false);
            Eval(5889, o is float, false);
            Eval(5890, o is float[], false);
            Eval(5891, o is float?, false);
            Eval(5892, o is float?[], false);
            Eval(5893, o is double, false);
            Eval(5894, o is double[], false);
            Eval(5895, o is double?, false);
            Eval(5896, o is double?[], false);
            Eval(5897, o is decimal, false);
            Eval(5898, o is decimal[], false);
            Eval(5899, o is decimal?, false);
            Eval(5900, o is decimal?[], false);
            Eval(5901, o is object, false);
            Eval(5902, o is object[], false);
            Eval(5903, o is string, false);
            Eval(5904, o is string[], false);
            Eval(5905, o is ValueType, false);
            Eval(5906, o is ValueType[], false);
            Eval(5907, o is Array, false);
            Eval(5908, o is Array[], false);
            Eval(5909, o is Enum, false);
            Eval(5910, o is Enum[], false);
            Eval(5911, o is Delegate, false);
            Eval(5912, o is Delegate[], false);
            Eval(5913, o is MulticastDelegate, false);
            Eval(5914, o is MulticastDelegate[], false);
            Eval(5915, o is IEmpty, false);
            Eval(5916, o is IEmpty[], false);
            Eval(5917, o is INotEmpty, false);
            Eval(5918, o is INotEmpty[], false);
            Eval(5919, o is IEmptyGen<int>, false);
            Eval(5920, o is IEmptyGen<int>[], false);
            Eval(5921, o is INotEmptyGen<int>, false);
            Eval(5922, o is INotEmptyGen<int>[], false);
            Eval(5923, o is SimpleDelegate, false);
            Eval(5924, o is SimpleDelegate[], false);
            Eval(5925, o is GenericDelegate<int>, false);
            Eval(5926, o is GenericDelegate<int>[], false);
            Eval(5927, o is EmptyClass, false);
            Eval(5928, o is EmptyClass[], false);
            Eval(5929, o is NotEmptyClass, false);
            Eval(5930, o is NotEmptyClass[], false);
            Eval(5931, o is EmptyClassGen<int>, false);
            Eval(5932, o is EmptyClassGen<int>[], false);
            Eval(5933, o is NotEmptyClassGen<Guid>, false);
            Eval(5934, o is NotEmptyClassGen<Guid>[], false);
            Eval(5935, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(5936, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(5937, o is NestedClass, false);
            Eval(5938, o is NestedClass[], false);
            Eval(5939, o is NestedClassGen<Decimal>, false);
            Eval(5940, o is NestedClassGen<Decimal>[], false);
            Eval(5941, o is ImplementOneInterfaceC, false);
            Eval(5942, o is ImplementOneInterfaceC[], false);
            Eval(5943, o is ImplementTwoInterfaceC, false);
            Eval(5944, o is ImplementTwoInterfaceC[], false);
            Eval(5945, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(5946, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(5947, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(5948, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(5949, o is ImplementAllInterfaceC<int>, false);
            Eval(5950, o is ImplementAllInterfaceC<int>[], false);
            Eval(5951, o is SealedClass, false);
            Eval(5952, o is SealedClass[], false);
        }
    }  // end of test case 0016
    private static void TestCase0017()
    {
        {
            double v = default(double);
            IComparable o = v; ;
            Eval(5953, o is ImplementOneInterface, false);
            Eval(5954, o is ImplementOneInterface[], false);
            Eval(5955, o is ImplementOneInterface?, false);
            Eval(5956, o is ImplementOneInterface?[], false);
            Eval(5957, o is ImplementTwoInterface, false);
            Eval(5958, o is ImplementTwoInterface[], false);
            Eval(5959, o is ImplementTwoInterface?, false);
            Eval(5960, o is ImplementTwoInterface?[], false);
            Eval(5961, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(5962, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(5963, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(5964, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(5965, o is ImplementTwoInterfaceGen<int>, false);
            Eval(5966, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(5967, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(5968, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(5969, o is ImplementAllInterface<int>, false);
            Eval(5970, o is ImplementAllInterface<int>[], false);
            Eval(5971, o is ImplementAllInterface<int>?, false);
            Eval(5972, o is ImplementAllInterface<int>?[], false);
            Eval(5973, o is char, false);
            Eval(5974, o is char[], false);
            Eval(5975, o is char?, false);
            Eval(5976, o is char?[], false);
            Eval(5977, o is bool, false);
            Eval(5978, o is bool[], false);
            Eval(5979, o is bool?, false);
            Eval(5980, o is bool?[], false);
            Eval(5981, o is byte, false);
            Eval(5982, o is byte[], false);
            Eval(5983, o is byte?, false);
            Eval(5984, o is byte?[], false);
            Eval(5985, o is sbyte, false);
            Eval(5986, o is sbyte[], false);
            Eval(5987, o is sbyte?, false);
            Eval(5988, o is sbyte?[], false);
            Eval(5989, o is short, false);
            Eval(5990, o is short[], false);
            Eval(5991, o is short?, false);
            Eval(5992, o is short?[], false);
            Eval(5993, o is ushort, false);
            Eval(5994, o is ushort[], false);
            Eval(5995, o is ushort?, false);
            Eval(5996, o is ushort?[], false);
            Eval(5997, o is int, false);
            Eval(5998, o is int[], false);
            Eval(5999, o is int?, false);
            Eval(6000, o is int?[], false);
            Eval(6001, o is uint, false);
            Eval(6002, o is uint[], false);
            Eval(6003, o is uint?, false);
            Eval(6004, o is uint?[], false);
            Eval(6005, o is long, false);
            Eval(6006, o is long[], false);
            Eval(6007, o is long?, false);
            Eval(6008, o is long?[], false);
            Eval(6009, o is ulong, false);
            Eval(6010, o is ulong[], false);
            Eval(6011, o is ulong?, false);
            Eval(6012, o is ulong?[], false);
            Eval(6013, o is float, false);
            Eval(6014, o is float[], false);
            Eval(6015, o is float?, false);
            Eval(6016, o is float?[], false);
            Eval(6017, o is double, true);
            Eval(6018, o is double[], false);
            Eval(6019, o is double?, true);
            Eval(6020, o is double?[], false);
            Eval(6021, o is decimal, false);
            Eval(6022, o is decimal[], false);
            Eval(6023, o is decimal?, false);
            Eval(6024, o is decimal?[], false);
            Eval(6025, o is object, true);
            Eval(6026, o is object[], false);
            Eval(6027, o is string, false);
            Eval(6028, o is string[], false);
            Eval(6029, o is ValueType, true);
            Eval(6030, o is ValueType[], false);
            Eval(6031, o is Array, false);
            Eval(6032, o is Array[], false);
            Eval(6033, o is Enum, false);
            Eval(6034, o is Enum[], false);
            Eval(6035, o is Delegate, false);
            Eval(6036, o is Delegate[], false);
            Eval(6037, o is MulticastDelegate, false);
            Eval(6038, o is MulticastDelegate[], false);
            Eval(6039, o is IEmpty, false);
            Eval(6040, o is IEmpty[], false);
            Eval(6041, o is INotEmpty, false);
            Eval(6042, o is INotEmpty[], false);
            Eval(6043, o is IEmptyGen<int>, false);
            Eval(6044, o is IEmptyGen<int>[], false);
            Eval(6045, o is INotEmptyGen<int>, false);
            Eval(6046, o is INotEmptyGen<int>[], false);
            Eval(6047, o is SimpleDelegate, false);
            Eval(6048, o is SimpleDelegate[], false);
            Eval(6049, o is GenericDelegate<int>, false);
            Eval(6050, o is GenericDelegate<int>[], false);
            Eval(6051, o is EmptyClass, false);
            Eval(6052, o is EmptyClass[], false);
            Eval(6053, o is NotEmptyClass, false);
            Eval(6054, o is NotEmptyClass[], false);
            Eval(6055, o is EmptyClassGen<int>, false);
            Eval(6056, o is EmptyClassGen<int>[], false);
            Eval(6057, o is NotEmptyClassGen<Guid>, false);
            Eval(6058, o is NotEmptyClassGen<Guid>[], false);
            Eval(6059, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6060, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6061, o is NestedClass, false);
            Eval(6062, o is NestedClass[], false);
            Eval(6063, o is NestedClassGen<Decimal>, false);
            Eval(6064, o is NestedClassGen<Decimal>[], false);
            Eval(6065, o is ImplementOneInterfaceC, false);
            Eval(6066, o is ImplementOneInterfaceC[], false);
            Eval(6067, o is ImplementTwoInterfaceC, false);
            Eval(6068, o is ImplementTwoInterfaceC[], false);
            Eval(6069, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6070, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6071, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6072, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6073, o is ImplementAllInterfaceC<int>, false);
            Eval(6074, o is ImplementAllInterfaceC<int>[], false);
            Eval(6075, o is SealedClass, false);
            Eval(6076, o is SealedClass[], false);
        }
        {
            double? v = default(double);
            IComparable o = v; ;
            Eval(6077, o is ImplementOneInterface, false);
            Eval(6078, o is ImplementOneInterface[], false);
            Eval(6079, o is ImplementOneInterface?, false);
            Eval(6080, o is ImplementOneInterface?[], false);
            Eval(6081, o is ImplementTwoInterface, false);
            Eval(6082, o is ImplementTwoInterface[], false);
            Eval(6083, o is ImplementTwoInterface?, false);
            Eval(6084, o is ImplementTwoInterface?[], false);
            Eval(6085, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6086, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6087, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6088, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6089, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6090, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6091, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6092, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6093, o is ImplementAllInterface<int>, false);
            Eval(6094, o is ImplementAllInterface<int>[], false);
            Eval(6095, o is ImplementAllInterface<int>?, false);
            Eval(6096, o is ImplementAllInterface<int>?[], false);
            Eval(6097, o is char, false);
            Eval(6098, o is char[], false);
            Eval(6099, o is char?, false);
            Eval(6100, o is char?[], false);
            Eval(6101, o is bool, false);
            Eval(6102, o is bool[], false);
            Eval(6103, o is bool?, false);
            Eval(6104, o is bool?[], false);
            Eval(6105, o is byte, false);
            Eval(6106, o is byte[], false);
            Eval(6107, o is byte?, false);
            Eval(6108, o is byte?[], false);
            Eval(6109, o is sbyte, false);
            Eval(6110, o is sbyte[], false);
            Eval(6111, o is sbyte?, false);
            Eval(6112, o is sbyte?[], false);
            Eval(6113, o is short, false);
            Eval(6114, o is short[], false);
            Eval(6115, o is short?, false);
            Eval(6116, o is short?[], false);
            Eval(6117, o is ushort, false);
            Eval(6118, o is ushort[], false);
            Eval(6119, o is ushort?, false);
            Eval(6120, o is ushort?[], false);
            Eval(6121, o is int, false);
            Eval(6122, o is int[], false);
            Eval(6123, o is int?, false);
            Eval(6124, o is int?[], false);
            Eval(6125, o is uint, false);
            Eval(6126, o is uint[], false);
            Eval(6127, o is uint?, false);
            Eval(6128, o is uint?[], false);
            Eval(6129, o is long, false);
            Eval(6130, o is long[], false);
            Eval(6131, o is long?, false);
            Eval(6132, o is long?[], false);
            Eval(6133, o is ulong, false);
            Eval(6134, o is ulong[], false);
            Eval(6135, o is ulong?, false);
            Eval(6136, o is ulong?[], false);
            Eval(6137, o is float, false);
            Eval(6138, o is float[], false);
            Eval(6139, o is float?, false);
            Eval(6140, o is float?[], false);
            Eval(6141, o is double, true);
            Eval(6142, o is double[], false);
            Eval(6143, o is double?, true);
            Eval(6144, o is double?[], false);
            Eval(6145, o is decimal, false);
            Eval(6146, o is decimal[], false);
            Eval(6147, o is decimal?, false);
            Eval(6148, o is decimal?[], false);
            Eval(6149, o is object, true);
            Eval(6150, o is object[], false);
            Eval(6151, o is string, false);
            Eval(6152, o is string[], false);
            Eval(6153, o is ValueType, true);
            Eval(6154, o is ValueType[], false);
            Eval(6155, o is Array, false);
            Eval(6156, o is Array[], false);
            Eval(6157, o is Enum, false);
            Eval(6158, o is Enum[], false);
            Eval(6159, o is Delegate, false);
            Eval(6160, o is Delegate[], false);
            Eval(6161, o is MulticastDelegate, false);
            Eval(6162, o is MulticastDelegate[], false);
            Eval(6163, o is IEmpty, false);
            Eval(6164, o is IEmpty[], false);
            Eval(6165, o is INotEmpty, false);
            Eval(6166, o is INotEmpty[], false);
            Eval(6167, o is IEmptyGen<int>, false);
            Eval(6168, o is IEmptyGen<int>[], false);
            Eval(6169, o is INotEmptyGen<int>, false);
            Eval(6170, o is INotEmptyGen<int>[], false);
            Eval(6171, o is SimpleDelegate, false);
            Eval(6172, o is SimpleDelegate[], false);
            Eval(6173, o is GenericDelegate<int>, false);
            Eval(6174, o is GenericDelegate<int>[], false);
            Eval(6175, o is EmptyClass, false);
            Eval(6176, o is EmptyClass[], false);
            Eval(6177, o is NotEmptyClass, false);
            Eval(6178, o is NotEmptyClass[], false);
            Eval(6179, o is EmptyClassGen<int>, false);
            Eval(6180, o is EmptyClassGen<int>[], false);
            Eval(6181, o is NotEmptyClassGen<Guid>, false);
            Eval(6182, o is NotEmptyClassGen<Guid>[], false);
            Eval(6183, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6184, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6185, o is NestedClass, false);
            Eval(6186, o is NestedClass[], false);
            Eval(6187, o is NestedClassGen<Decimal>, false);
            Eval(6188, o is NestedClassGen<Decimal>[], false);
            Eval(6189, o is ImplementOneInterfaceC, false);
            Eval(6190, o is ImplementOneInterfaceC[], false);
            Eval(6191, o is ImplementTwoInterfaceC, false);
            Eval(6192, o is ImplementTwoInterfaceC[], false);
            Eval(6193, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6194, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6195, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6196, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6197, o is ImplementAllInterfaceC<int>, false);
            Eval(6198, o is ImplementAllInterfaceC<int>[], false);
            Eval(6199, o is SealedClass, false);
            Eval(6200, o is SealedClass[], false);
        }
        {
            double? v = default(double?);
            IComparable o = v; ;
            Eval(6201, o is ImplementOneInterface, false);
            Eval(6202, o is ImplementOneInterface[], false);
            Eval(6203, o is ImplementOneInterface?, false);
            Eval(6204, o is ImplementOneInterface?[], false);
            Eval(6205, o is ImplementTwoInterface, false);
            Eval(6206, o is ImplementTwoInterface[], false);
            Eval(6207, o is ImplementTwoInterface?, false);
            Eval(6208, o is ImplementTwoInterface?[], false);
            Eval(6209, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6210, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6211, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6212, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6213, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6214, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6215, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6216, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6217, o is ImplementAllInterface<int>, false);
            Eval(6218, o is ImplementAllInterface<int>[], false);
            Eval(6219, o is ImplementAllInterface<int>?, false);
            Eval(6220, o is ImplementAllInterface<int>?[], false);
            Eval(6221, o is char, false);
            Eval(6222, o is char[], false);
            Eval(6223, o is char?, false);
            Eval(6224, o is char?[], false);
            Eval(6225, o is bool, false);
            Eval(6226, o is bool[], false);
            Eval(6227, o is bool?, false);
            Eval(6228, o is bool?[], false);
            Eval(6229, o is byte, false);
            Eval(6230, o is byte[], false);
            Eval(6231, o is byte?, false);
            Eval(6232, o is byte?[], false);
            Eval(6233, o is sbyte, false);
            Eval(6234, o is sbyte[], false);
            Eval(6235, o is sbyte?, false);
            Eval(6236, o is sbyte?[], false);
            Eval(6237, o is short, false);
            Eval(6238, o is short[], false);
            Eval(6239, o is short?, false);
            Eval(6240, o is short?[], false);
            Eval(6241, o is ushort, false);
            Eval(6242, o is ushort[], false);
            Eval(6243, o is ushort?, false);
            Eval(6244, o is ushort?[], false);
            Eval(6245, o is int, false);
            Eval(6246, o is int[], false);
            Eval(6247, o is int?, false);
            Eval(6248, o is int?[], false);
            Eval(6249, o is uint, false);
            Eval(6250, o is uint[], false);
            Eval(6251, o is uint?, false);
            Eval(6252, o is uint?[], false);
            Eval(6253, o is long, false);
            Eval(6254, o is long[], false);
            Eval(6255, o is long?, false);
            Eval(6256, o is long?[], false);
            Eval(6257, o is ulong, false);
            Eval(6258, o is ulong[], false);
            Eval(6259, o is ulong?, false);
            Eval(6260, o is ulong?[], false);
            Eval(6261, o is float, false);
            Eval(6262, o is float[], false);
            Eval(6263, o is float?, false);
            Eval(6264, o is float?[], false);
            Eval(6265, o is double, false);
            Eval(6266, o is double[], false);
            Eval(6267, o is double?, false);
            Eval(6268, o is double?[], false);
            Eval(6269, o is decimal, false);
            Eval(6270, o is decimal[], false);
            Eval(6271, o is decimal?, false);
            Eval(6272, o is decimal?[], false);
            Eval(6273, o is object, false);
            Eval(6274, o is object[], false);
            Eval(6275, o is string, false);
            Eval(6276, o is string[], false);
            Eval(6277, o is ValueType, false);
            Eval(6278, o is ValueType[], false);
            Eval(6279, o is Array, false);
            Eval(6280, o is Array[], false);
            Eval(6281, o is Enum, false);
            Eval(6282, o is Enum[], false);
            Eval(6283, o is Delegate, false);
            Eval(6284, o is Delegate[], false);
            Eval(6285, o is MulticastDelegate, false);
            Eval(6286, o is MulticastDelegate[], false);
            Eval(6287, o is IEmpty, false);
            Eval(6288, o is IEmpty[], false);
            Eval(6289, o is INotEmpty, false);
            Eval(6290, o is INotEmpty[], false);
            Eval(6291, o is IEmptyGen<int>, false);
            Eval(6292, o is IEmptyGen<int>[], false);
            Eval(6293, o is INotEmptyGen<int>, false);
            Eval(6294, o is INotEmptyGen<int>[], false);
            Eval(6295, o is SimpleDelegate, false);
            Eval(6296, o is SimpleDelegate[], false);
            Eval(6297, o is GenericDelegate<int>, false);
            Eval(6298, o is GenericDelegate<int>[], false);
            Eval(6299, o is EmptyClass, false);
            Eval(6300, o is EmptyClass[], false);
            Eval(6301, o is NotEmptyClass, false);
            Eval(6302, o is NotEmptyClass[], false);
            Eval(6303, o is EmptyClassGen<int>, false);
            Eval(6304, o is EmptyClassGen<int>[], false);
            Eval(6305, o is NotEmptyClassGen<Guid>, false);
            Eval(6306, o is NotEmptyClassGen<Guid>[], false);
            Eval(6307, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6308, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6309, o is NestedClass, false);
            Eval(6310, o is NestedClass[], false);
            Eval(6311, o is NestedClassGen<Decimal>, false);
            Eval(6312, o is NestedClassGen<Decimal>[], false);
            Eval(6313, o is ImplementOneInterfaceC, false);
            Eval(6314, o is ImplementOneInterfaceC[], false);
            Eval(6315, o is ImplementTwoInterfaceC, false);
            Eval(6316, o is ImplementTwoInterfaceC[], false);
            Eval(6317, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6318, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6319, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6320, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6321, o is ImplementAllInterfaceC<int>, false);
            Eval(6322, o is ImplementAllInterfaceC<int>[], false);
            Eval(6323, o is SealedClass, false);
            Eval(6324, o is SealedClass[], false);
        }
    }  // end of test case 0017
    private static void TestCase0018()
    {
        {
            decimal v = default(decimal);
            IComparable o = v; ;
            Eval(6325, o is ImplementOneInterface, false);
            Eval(6326, o is ImplementOneInterface[], false);
            Eval(6327, o is ImplementOneInterface?, false);
            Eval(6328, o is ImplementOneInterface?[], false);
            Eval(6329, o is ImplementTwoInterface, false);
            Eval(6330, o is ImplementTwoInterface[], false);
            Eval(6331, o is ImplementTwoInterface?, false);
            Eval(6332, o is ImplementTwoInterface?[], false);
            Eval(6333, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6334, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6335, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6336, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6337, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6338, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6339, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6340, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6341, o is ImplementAllInterface<int>, false);
            Eval(6342, o is ImplementAllInterface<int>[], false);
            Eval(6343, o is ImplementAllInterface<int>?, false);
            Eval(6344, o is ImplementAllInterface<int>?[], false);
            Eval(6345, o is char, false);
            Eval(6346, o is char[], false);
            Eval(6347, o is char?, false);
            Eval(6348, o is char?[], false);
            Eval(6349, o is bool, false);
            Eval(6350, o is bool[], false);
            Eval(6351, o is bool?, false);
            Eval(6352, o is bool?[], false);
            Eval(6353, o is byte, false);
            Eval(6354, o is byte[], false);
            Eval(6355, o is byte?, false);
            Eval(6356, o is byte?[], false);
            Eval(6357, o is sbyte, false);
            Eval(6358, o is sbyte[], false);
            Eval(6359, o is sbyte?, false);
            Eval(6360, o is sbyte?[], false);
            Eval(6361, o is short, false);
            Eval(6362, o is short[], false);
            Eval(6363, o is short?, false);
            Eval(6364, o is short?[], false);
            Eval(6365, o is ushort, false);
            Eval(6366, o is ushort[], false);
            Eval(6367, o is ushort?, false);
            Eval(6368, o is ushort?[], false);
            Eval(6369, o is int, false);
            Eval(6370, o is int[], false);
            Eval(6371, o is int?, false);
            Eval(6372, o is int?[], false);
            Eval(6373, o is uint, false);
            Eval(6374, o is uint[], false);
            Eval(6375, o is uint?, false);
            Eval(6376, o is uint?[], false);
            Eval(6377, o is long, false);
            Eval(6378, o is long[], false);
            Eval(6379, o is long?, false);
            Eval(6380, o is long?[], false);
            Eval(6381, o is ulong, false);
            Eval(6382, o is ulong[], false);
            Eval(6383, o is ulong?, false);
            Eval(6384, o is ulong?[], false);
            Eval(6385, o is float, false);
            Eval(6386, o is float[], false);
            Eval(6387, o is float?, false);
            Eval(6388, o is float?[], false);
            Eval(6389, o is double, false);
            Eval(6390, o is double[], false);
            Eval(6391, o is double?, false);
            Eval(6392, o is double?[], false);
            Eval(6393, o is decimal, true);
            Eval(6394, o is decimal[], false);
            Eval(6395, o is decimal?, true);
            Eval(6396, o is decimal?[], false);
            Eval(6397, o is object, true);
            Eval(6398, o is object[], false);
            Eval(6399, o is string, false);
            Eval(6400, o is string[], false);
            Eval(6401, o is ValueType, true);
            Eval(6402, o is ValueType[], false);
            Eval(6403, o is Array, false);
            Eval(6404, o is Array[], false);
            Eval(6405, o is Enum, false);
            Eval(6406, o is Enum[], false);
            Eval(6407, o is Delegate, false);
            Eval(6408, o is Delegate[], false);
            Eval(6409, o is MulticastDelegate, false);
            Eval(6410, o is MulticastDelegate[], false);
            Eval(6411, o is IEmpty, false);
            Eval(6412, o is IEmpty[], false);
            Eval(6413, o is INotEmpty, false);
            Eval(6414, o is INotEmpty[], false);
            Eval(6415, o is IEmptyGen<int>, false);
            Eval(6416, o is IEmptyGen<int>[], false);
            Eval(6417, o is INotEmptyGen<int>, false);
            Eval(6418, o is INotEmptyGen<int>[], false);
            Eval(6419, o is SimpleDelegate, false);
            Eval(6420, o is SimpleDelegate[], false);
            Eval(6421, o is GenericDelegate<int>, false);
            Eval(6422, o is GenericDelegate<int>[], false);
            Eval(6423, o is EmptyClass, false);
            Eval(6424, o is EmptyClass[], false);
            Eval(6425, o is NotEmptyClass, false);
            Eval(6426, o is NotEmptyClass[], false);
            Eval(6427, o is EmptyClassGen<int>, false);
            Eval(6428, o is EmptyClassGen<int>[], false);
            Eval(6429, o is NotEmptyClassGen<Guid>, false);
            Eval(6430, o is NotEmptyClassGen<Guid>[], false);
            Eval(6431, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6432, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6433, o is NestedClass, false);
            Eval(6434, o is NestedClass[], false);
            Eval(6435, o is NestedClassGen<Decimal>, false);
            Eval(6436, o is NestedClassGen<Decimal>[], false);
            Eval(6437, o is ImplementOneInterfaceC, false);
            Eval(6438, o is ImplementOneInterfaceC[], false);
            Eval(6439, o is ImplementTwoInterfaceC, false);
            Eval(6440, o is ImplementTwoInterfaceC[], false);
            Eval(6441, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6442, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6443, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6444, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6445, o is ImplementAllInterfaceC<int>, false);
            Eval(6446, o is ImplementAllInterfaceC<int>[], false);
            Eval(6447, o is SealedClass, false);
            Eval(6448, o is SealedClass[], false);
        }
        {
            decimal? v = default(decimal);
            IComparable o = v; ;
            Eval(6449, o is ImplementOneInterface, false);
            Eval(6450, o is ImplementOneInterface[], false);
            Eval(6451, o is ImplementOneInterface?, false);
            Eval(6452, o is ImplementOneInterface?[], false);
            Eval(6453, o is ImplementTwoInterface, false);
            Eval(6454, o is ImplementTwoInterface[], false);
            Eval(6455, o is ImplementTwoInterface?, false);
            Eval(6456, o is ImplementTwoInterface?[], false);
            Eval(6457, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6458, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6459, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6460, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6461, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6462, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6463, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6464, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6465, o is ImplementAllInterface<int>, false);
            Eval(6466, o is ImplementAllInterface<int>[], false);
            Eval(6467, o is ImplementAllInterface<int>?, false);
            Eval(6468, o is ImplementAllInterface<int>?[], false);
            Eval(6469, o is char, false);
            Eval(6470, o is char[], false);
            Eval(6471, o is char?, false);
            Eval(6472, o is char?[], false);
            Eval(6473, o is bool, false);
            Eval(6474, o is bool[], false);
            Eval(6475, o is bool?, false);
            Eval(6476, o is bool?[], false);
            Eval(6477, o is byte, false);
            Eval(6478, o is byte[], false);
            Eval(6479, o is byte?, false);
            Eval(6480, o is byte?[], false);
            Eval(6481, o is sbyte, false);
            Eval(6482, o is sbyte[], false);
            Eval(6483, o is sbyte?, false);
            Eval(6484, o is sbyte?[], false);
            Eval(6485, o is short, false);
            Eval(6486, o is short[], false);
            Eval(6487, o is short?, false);
            Eval(6488, o is short?[], false);
            Eval(6489, o is ushort, false);
            Eval(6490, o is ushort[], false);
            Eval(6491, o is ushort?, false);
            Eval(6492, o is ushort?[], false);
            Eval(6493, o is int, false);
            Eval(6494, o is int[], false);
            Eval(6495, o is int?, false);
            Eval(6496, o is int?[], false);
            Eval(6497, o is uint, false);
            Eval(6498, o is uint[], false);
            Eval(6499, o is uint?, false);
            Eval(6500, o is uint?[], false);
            Eval(6501, o is long, false);
            Eval(6502, o is long[], false);
            Eval(6503, o is long?, false);
            Eval(6504, o is long?[], false);
            Eval(6505, o is ulong, false);
            Eval(6506, o is ulong[], false);
            Eval(6507, o is ulong?, false);
            Eval(6508, o is ulong?[], false);
            Eval(6509, o is float, false);
            Eval(6510, o is float[], false);
            Eval(6511, o is float?, false);
            Eval(6512, o is float?[], false);
            Eval(6513, o is double, false);
            Eval(6514, o is double[], false);
            Eval(6515, o is double?, false);
            Eval(6516, o is double?[], false);
            Eval(6517, o is decimal, true);
            Eval(6518, o is decimal[], false);
            Eval(6519, o is decimal?, true);
            Eval(6520, o is decimal?[], false);
            Eval(6521, o is object, true);
            Eval(6522, o is object[], false);
            Eval(6523, o is string, false);
            Eval(6524, o is string[], false);
            Eval(6525, o is ValueType, true);
            Eval(6526, o is ValueType[], false);
            Eval(6527, o is Array, false);
            Eval(6528, o is Array[], false);
            Eval(6529, o is Enum, false);
            Eval(6530, o is Enum[], false);
            Eval(6531, o is Delegate, false);
            Eval(6532, o is Delegate[], false);
            Eval(6533, o is MulticastDelegate, false);
            Eval(6534, o is MulticastDelegate[], false);
            Eval(6535, o is IEmpty, false);
            Eval(6536, o is IEmpty[], false);
            Eval(6537, o is INotEmpty, false);
            Eval(6538, o is INotEmpty[], false);
            Eval(6539, o is IEmptyGen<int>, false);
            Eval(6540, o is IEmptyGen<int>[], false);
            Eval(6541, o is INotEmptyGen<int>, false);
            Eval(6542, o is INotEmptyGen<int>[], false);
            Eval(6543, o is SimpleDelegate, false);
            Eval(6544, o is SimpleDelegate[], false);
            Eval(6545, o is GenericDelegate<int>, false);
            Eval(6546, o is GenericDelegate<int>[], false);
            Eval(6547, o is EmptyClass, false);
            Eval(6548, o is EmptyClass[], false);
            Eval(6549, o is NotEmptyClass, false);
            Eval(6550, o is NotEmptyClass[], false);
            Eval(6551, o is EmptyClassGen<int>, false);
            Eval(6552, o is EmptyClassGen<int>[], false);
            Eval(6553, o is NotEmptyClassGen<Guid>, false);
            Eval(6554, o is NotEmptyClassGen<Guid>[], false);
            Eval(6555, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6556, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6557, o is NestedClass, false);
            Eval(6558, o is NestedClass[], false);
            Eval(6559, o is NestedClassGen<Decimal>, false);
            Eval(6560, o is NestedClassGen<Decimal>[], false);
            Eval(6561, o is ImplementOneInterfaceC, false);
            Eval(6562, o is ImplementOneInterfaceC[], false);
            Eval(6563, o is ImplementTwoInterfaceC, false);
            Eval(6564, o is ImplementTwoInterfaceC[], false);
            Eval(6565, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6566, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6567, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6568, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6569, o is ImplementAllInterfaceC<int>, false);
            Eval(6570, o is ImplementAllInterfaceC<int>[], false);
            Eval(6571, o is SealedClass, false);
            Eval(6572, o is SealedClass[], false);
        }
        {
            decimal? v = default(decimal?);
            IComparable o = v; ;
            Eval(6573, o is ImplementOneInterface, false);
            Eval(6574, o is ImplementOneInterface[], false);
            Eval(6575, o is ImplementOneInterface?, false);
            Eval(6576, o is ImplementOneInterface?[], false);
            Eval(6577, o is ImplementTwoInterface, false);
            Eval(6578, o is ImplementTwoInterface[], false);
            Eval(6579, o is ImplementTwoInterface?, false);
            Eval(6580, o is ImplementTwoInterface?[], false);
            Eval(6581, o is ImplementOneInterfaceGen<EmptyStructGen<int>>, false);
            Eval(6582, o is ImplementOneInterfaceGen<EmptyStructGen<int>>[], false);
            Eval(6583, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?, false);
            Eval(6584, o is ImplementOneInterfaceGen<EmptyStructGen<int>>?[], false);
            Eval(6585, o is ImplementTwoInterfaceGen<int>, false);
            Eval(6586, o is ImplementTwoInterfaceGen<int>[], false);
            Eval(6587, o is ImplementTwoInterfaceGen<int>?, false);
            Eval(6588, o is ImplementTwoInterfaceGen<int>?[], false);
            Eval(6589, o is ImplementAllInterface<int>, false);
            Eval(6590, o is ImplementAllInterface<int>[], false);
            Eval(6591, o is ImplementAllInterface<int>?, false);
            Eval(6592, o is ImplementAllInterface<int>?[], false);
            Eval(6593, o is char, false);
            Eval(6594, o is char[], false);
            Eval(6595, o is char?, false);
            Eval(6596, o is char?[], false);
            Eval(6597, o is bool, false);
            Eval(6598, o is bool[], false);
            Eval(6599, o is bool?, false);
            Eval(6600, o is bool?[], false);
            Eval(6601, o is byte, false);
            Eval(6602, o is byte[], false);
            Eval(6603, o is byte?, false);
            Eval(6604, o is byte?[], false);
            Eval(6605, o is sbyte, false);
            Eval(6606, o is sbyte[], false);
            Eval(6607, o is sbyte?, false);
            Eval(6608, o is sbyte?[], false);
            Eval(6609, o is short, false);
            Eval(6610, o is short[], false);
            Eval(6611, o is short?, false);
            Eval(6612, o is short?[], false);
            Eval(6613, o is ushort, false);
            Eval(6614, o is ushort[], false);
            Eval(6615, o is ushort?, false);
            Eval(6616, o is ushort?[], false);
            Eval(6617, o is int, false);
            Eval(6618, o is int[], false);
            Eval(6619, o is int?, false);
            Eval(6620, o is int?[], false);
            Eval(6621, o is uint, false);
            Eval(6622, o is uint[], false);
            Eval(6623, o is uint?, false);
            Eval(6624, o is uint?[], false);
            Eval(6625, o is long, false);
            Eval(6626, o is long[], false);
            Eval(6627, o is long?, false);
            Eval(6628, o is long?[], false);
            Eval(6629, o is ulong, false);
            Eval(6630, o is ulong[], false);
            Eval(6631, o is ulong?, false);
            Eval(6632, o is ulong?[], false);
            Eval(6633, o is float, false);
            Eval(6634, o is float[], false);
            Eval(6635, o is float?, false);
            Eval(6636, o is float?[], false);
            Eval(6637, o is double, false);
            Eval(6638, o is double[], false);
            Eval(6639, o is double?, false);
            Eval(6640, o is double?[], false);
            Eval(6641, o is decimal, false);
            Eval(6642, o is decimal[], false);
            Eval(6643, o is decimal?, false);
            Eval(6644, o is decimal?[], false);
            Eval(6645, o is object, false);
            Eval(6646, o is object[], false);
            Eval(6647, o is string, false);
            Eval(6648, o is string[], false);
            Eval(6649, o is ValueType, false);
            Eval(6650, o is ValueType[], false);
            Eval(6651, o is Array, false);
            Eval(6652, o is Array[], false);
            Eval(6653, o is Enum, false);
            Eval(6654, o is Enum[], false);
            Eval(6655, o is Delegate, false);
            Eval(6656, o is Delegate[], false);
            Eval(6657, o is MulticastDelegate, false);
            Eval(6658, o is MulticastDelegate[], false);
            Eval(6659, o is IEmpty, false);
            Eval(6660, o is IEmpty[], false);
            Eval(6661, o is INotEmpty, false);
            Eval(6662, o is INotEmpty[], false);
            Eval(6663, o is IEmptyGen<int>, false);
            Eval(6664, o is IEmptyGen<int>[], false);
            Eval(6665, o is INotEmptyGen<int>, false);
            Eval(6666, o is INotEmptyGen<int>[], false);
            Eval(6667, o is SimpleDelegate, false);
            Eval(6668, o is SimpleDelegate[], false);
            Eval(6669, o is GenericDelegate<int>, false);
            Eval(6670, o is GenericDelegate<int>[], false);
            Eval(6671, o is EmptyClass, false);
            Eval(6672, o is EmptyClass[], false);
            Eval(6673, o is NotEmptyClass, false);
            Eval(6674, o is NotEmptyClass[], false);
            Eval(6675, o is EmptyClassGen<int>, false);
            Eval(6676, o is EmptyClassGen<int>[], false);
            Eval(6677, o is NotEmptyClassGen<Guid>, false);
            Eval(6678, o is NotEmptyClassGen<Guid>[], false);
            Eval(6679, o is NotEmptyClassConstrainedGen<object>, false);
            Eval(6680, o is NotEmptyClassConstrainedGen<object>[], false);
            Eval(6681, o is NestedClass, false);
            Eval(6682, o is NestedClass[], false);
            Eval(6683, o is NestedClassGen<Decimal>, false);
            Eval(6684, o is NestedClassGen<Decimal>[], false);
            Eval(6685, o is ImplementOneInterfaceC, false);
            Eval(6686, o is ImplementOneInterfaceC[], false);
            Eval(6687, o is ImplementTwoInterfaceC, false);
            Eval(6688, o is ImplementTwoInterfaceC[], false);
            Eval(6689, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>, false);
            Eval(6690, o is ImplementOneInterfaceGenC<EmptyStructGen<int>>[], false);
            Eval(6691, o is ImplementTwoInterfaceGenC<int>, false);
            Eval(6692, o is ImplementTwoInterfaceGenC<int>[], false);
            Eval(6693, o is ImplementAllInterfaceC<int>, false);
            Eval(6694, o is ImplementAllInterfaceC<int>[], false);
            Eval(6695, o is SealedClass, false);
            Eval(6696, o is SealedClass[], false);
        }
    }  // end of test case 0018

    private static int Main()
    {
        try
        {
            TestCase0001();
            TestCase0002();
            TestCase0003();
            TestCase0004();
            TestCase0005();
            TestCase0006();
            TestCase0007();
            TestCase0008();
            TestCase0009();
            TestCase0010();
            TestCase0011();
            TestCase0012();
            TestCase0013();
            TestCase0014();
            TestCase0015();
            TestCase0016();
            TestCase0017();
            TestCase0018();
        }
        catch (Exception e)
        {
            System.Console.WriteLine(e.Message);
            Console.WriteLine("Test FAILED");
            return 666;
        }
        Console.WriteLine("Test SUCCESS");
        return 100;
    }
}
