// generated by go run gen.go; DO NOT EDIT

package publicsuffix

const version = "publicsuffix.org's effective_tld_names.dat, hg revision 45cfff9c781f (2013-04-23)"

const (
	nodesBitsChildren   = 9
	nodesBitsICANN      = 1
	nodesBitsTextOffset = 15
	nodesBitsTextLength = 6

	childrenBitsWildcard = 1
	childrenBitsNodeType = 2
	childrenBitsHi       = 14
	childrenBitsLo       = 14
)

const (
	nodeTypeNormal     = 0
	nodeTypeException  = 1
	nodeTypeParentOnly = 2
)

// numTLD is the number of top level domains.
const numTLD = 310

// Text is the combined text of all labels.
const text = "bernrtarantokyotangoceanographichisokananporovnoceanographiquebe" +
	"catanzarowfarmsteadrobakrehamnaturbruksgymnaturhistorisches3-us-" +
	"west-2beskidyn-o-saurlandebuildingjerstadotsurugashimanxjeonname" +
	"rikawauebetainaboxfordeatnuernbergjesdalivornohtawaramotoineppul" +
	"messinatsukigatakasakiiyamanobeeldengeluidyndns-at-workinggroupo" +
	"wiatargindianapolis-a-bloggerbielawalesundyndns-blogdns3-website" +
	"-ap-northeast-1biellaakesvuemieleccebieszczadygeyachiyodabievat-" +
	"band-campobassobetsuldalvdalaskanittedalaheadjudygarlandyndns-fr" +
	"eemasonryonagoyabifukagawallonieruchomoscienceandindustrynatuurw" +
	"etenschappenaumburgjovikashiharabihorologyonaguniversityumenaust" +
	"dalosangeles3-website-ap-southeast-1bilbaogakievenassisibenikiho" +
	"kumakogenebakkeshibechambagricultureklambulancertificationavalot" +
	"eneindianmarketplacebillustrationavigationavuotnakanojosoyrovigo" +
	"palanakanotoddenawrastelecomoldebiolsztynsettlers3-website-ap-so" +
	"utheast-2birdartdecodynaliascoli-picenogiessenglandyndns-homeftp" +
	"access3-website-eu-west-1birkenesoddtangenoamishirasatodabirthpl" +
	"acebjarkoyoriikashiwarabjerkreimperiabjugnayoromutashinainfoggia" +
	"bmdyndns-ipaleosloppadovanylveniceboltarnobrzegyptianpachigasaki" +
	"ds3-website-sa-east-1bolzanordlandyndns-mailouvrebomloabaths3-we" +
	"bsite-us-east-1bonnikkoebenhavnikolaevenessebyglandyndns-office-" +
	"on-the-webhopocznorfolkebiblebtimnetzgorzeleccoloradoplateaukraa" +
	"nghkemerovoldavvenjargalsadoes-itarumizusawabostonakijinsekikoge" +
	"novarabotanicalgardeninomiyakonojournalismolenskashiwazakinsuran" +
	"cebotanicgardenirasakintelligencebotanycateringebunkyonanaoshima" +
	"bariakesennumalvikasukabeiarndyndns-pics3-website-us-gov-west-1b" +
	"ozentsujiiebrandywinevalleyukuhashimoichinosekigaharabrasiljan-m" +
	"ayenishiawakurabremangerbresciabrindisiellakasamatsudolls3-websi" +
	"te-us-west-1bristolgamvikasumigaurawa-mazowszexeterbritish-libra" +
	"ryazannakadomari-elasticbeanstalkasuyanagawabritishcolumbialowie" +
	"zagannefrankfurtatarstanishiazainuyamanouchikuhokuryugasakitashi" +
	"obarabroadcastleasinglassassinational-library-scotlandes3-websit" +
	"e-us-west-2broke-itateshinanomachildrensgardenishigoshikiminokam" +
	"oenairguardyndns-remoteginankokubunjis-a-bulls-fanishiharabroker" +
	"bronnoysundyndns-serverbaniabrumunddalowiczest-a-la-maisondre-la" +
	"ndyndns-webetsuikikugawabrunelblagdenesnaaseralingenkainanaejrie" +
	"tis-a-candidatebrusselsakuragawabruxellesjamalborkangerbryanskle" +
	"ppgliwicebrynewjerseyurihonjostrodabvbalatinabearalvahkijogaszko" +
	"la-speziaustrheimatunduhrennesoygardeniwaizumiotsukuibigawaustev" +
	"ollimanowarudasnesoddenmarkhangelskjaknoluoktaikicks-assedicaser" +
	"taishinomakikuchikumagayagawatchandclockarlsoyekaterinburgdynias" +
	"kvollezajskariyamegurobihirosakikamijimaostalbansnasabaerobatica" +
	"sadelamonedagroks-theaternopilawakkanaibetsubamericanartanddesig" +
	"nieznodawaraholtalendoftheinternethnologyeongnamegawakuyabukibic" +
	"huozudmurtiamusementakkofuelverumbone-burg12bwhalinglogowildlife" +
	"djelenia-gorabzgradyndns-wikimobetsurutaharacivilaviationishinoo" +
	"motegotembaixadacivilisationishinoshimacivilizationishiokoppegar" +
	"dcivilwarmiasakuchinotsuchiurakawaclintonoshonaip6boneat-urlewis" +
	"millerhcloudfrontariobanazawaeroportalabamagasakishimabarahkkera" +
	"vjudaicaarborteaches-yogasawaragusartsaritsynarviikamogawagrinet" +
	"cmwegrowestfalenarvik-uralsk12000cntaxis-a-bruinsfanishitosashim" +
	"izunaminamiawajikis-a-cubicle-slaveroyrviknakaniikawatanaguracol" +
	"umbusantiquesakyotanabellunordkappspotenzachpomorskienishiwakis-" +
	"a-democratgorycomputerhistoryofscience-fictionissedalutskazoolog" +
	"ycongresodelalengua3consuladoomdnsaliascolipicenonoichikawamisat" +
	"obishimagnitkagaminord-aurdaltoadigeiseiroudaegubalestrandaberga" +
	"moarekepnorddalindasiauthordalandivtasvuodnaharimaniwakurate164c" +
	"onsultanthropologyconsultingvolluxembourgminakamichigangwonisshi" +
	"ngotsukisofukushimarburgqchattanooganordreisa-hockeynutazulsando" +
	"yusuharacontemporaryartgalleryggetmyipanamaconventjeldsundcooper" +
	"aunitelevisioniyodogawacopenhagentsalangenlsalatjomelhusdecorati" +
	"veartsaltdaluzernrwritesthisblogspotowncorporationcorvettexashor" +
	"okanaiecosenzakopanewyorkshireggiocalabriacostumediaphonefosshnc" +
	"ountysfjordcqhabororoskolegnicambridgeorgiacranbrookuwanamizuhob" +
	"by-sitextileborkdalvivcheltenham-radio-openair-surveillancecremo" +
	"nagatorockartuzycrewroclawwwcrimeacrotoneculturalcentercuneocxn-" +
	"-3e0b707ecymrussiafieldfigueresalvadordalillehammerfest-le-patro" +
	"ndheiminamifuranofilateliafilminamiiserniafineartsalzburgrimstad" +
	"finlandfinnoyfirenzefirminamiizukamishihoronobeokamikoaniihamata" +
	"makawajimashikedafitjarchitecturennebudejjuedischesapeakebayfjal" +
	"erdalflekkefjordflesbergenflightoyakokamiokamikitayamatotakadafl" +
	"ogisticsamegawafloraflorencefloridaflorokunohealthruhereggioemil" +
	"iafndfolldalfor-better-thanawafor-ourfor-somedicaltanissettaitog" +
	"itsulikes-piefor-thedmarkchristiansburgroks-thisayamanashichikas" +
	"hukujukuriyamaritimodalenforceforgotdnsamnangerforli-cesena-forl" +
	"icesenaforlikescandynathomebuiltoyokawaforsandasuolodingenfortmi" +
	"ssoulan-udell-ogliastrakhanamigawafortworthachijorpelandforumina" +
	"mimakis-a-designerfosnesanfranciscolonialwilliamsburgrongafother" +
	"fredrikstadaokagakinkobeardudinkakegawalbrzychampionshiparachuti" +
	"ngrossetouchijiwadepotaruis-a-doctorskenfreiburgroundhandlingroz" +
	"nyfreightoyonakagyokutomaritimekeepingrparaglidingruenoharafribo" +
	"urgsmolajollanbibaidarfrognfrolandfrom-akunemurorankoshigayachim" +
	"atainaikawababia-gorakkestadultoyonezawafrom-alfrom-arqldfrom-az" +
	"hytomyrfrom-cahcesuolocalhistorybnikahokutoeigersundfrom-collect" +
	"ionfrom-ctoyonofrom-dchelyabinskodjeffersongfest-a-la-masionishi" +
	"katakasugais-a-celticsfanishikatsuragis-a-chefauskedsmokorsettle" +
	"mentateyamafrom-dellogliastraderfrom-flakstadtoyookanrafrom-gaus" +
	"dalfrom-higashiagatsumagoizumizakirafrom-iafrom-idfrom-ilfrom-in" +
	"cheonfrom-ksangouvicenzaporizhzheguris-a-financialadvisor-aurdal" +
	"from-kyotobetsuwanouchikushinonsennanburyatiafrom-lahppiacenzama" +
	"microlightoyosatomobeneventochiokinoshimalselvendrellfrom-mannos" +
	"hirooshikamaishimodatefrom-mdfrom-medio-campidano-mediocampidano" +
	"mediofrom-midoringerikefrom-mnfrom-mochizukirkenesanjournalistav" +
	"ernfrom-msannanfrom-mtoyotaris-a-geekgunmarnardalfrom-ncherkasyd" +
	"neyusuissembokumamotoyamatsumaebashikaois-a-conservativefsnillfj" +
	"ordyroyuulvikaszubytomakomaibarafrom-ndfrom-nefrom-nhachinohekin" +
	"annestadfrom-njessheiminamiminowafrom-nminamiogunionfrom-nvdonsk" +
	"habarovskhakassiafrom-nyfrom-ohdafrom-oketogonohejis-a-greenfrom" +
	"-orlandfrom-pacifichernigovernmentatsunostrolekanazawafrom-prdfr" +
	"om-rissagaeroclubindallaspeziamallamadridvrdnsdojobojis-a-guruns" +
	"akatakatsukis-a-hard-workerfrom-schlesischesannohemnesantabarbar" +
	"afrom-sdfrom-tnfrom-txn--45brj9chernihivanovosibirskydivingloppe" +
	"nzaogashimadachicagobiernoelectronicoalstahaugesundfrom-utsiracu" +
	"sagamiharafrom-vadsoftwaremarkerfrom-vtoyotomiyazakis-a-hunterfr" +
	"om-wafrom-wielunnerfrom-wvenneslaskerfrom-wyfrosinonefrostargard" +
	"froyaitaiwanair-traffic-controlleyfstarostwodzislawfujiiderafuji" +
	"kawaguchikonefujiminohkurafujinomiyadafujiokayamansionsantacruzh" +
	"gorodfujisatoshoofujisawafujishiroishidakabiratoridelmenhorstalo" +
	"wa-wolawafujiyoshidafukayabeauxartsandcraftsantafederationfukuch" +
	"iyamadafukudominichernivtsiemenswedenishikawazukanagawafukuis-a-" +
	"knightoyotsukaidofukumitsukefukuokazakirovogradoyfukuroishigakir" +
	"yufuefukihabikinokawaircraftoyourafukusakisarazunzenfukuyamagata" +
	"jimidsundfunabashiriuchinadafunagatajirittogurafunahashikamiamak" +
	"usatsumasendaisenfundaciofuoiskujitawarafuosskoczowfurniturepbod" +
	"yndns-at-homednsanukis-a-landscaperugiafurubiraquariuminamisanri" +
	"kubetsurgeonshalloffameiwamatsunofurudonostiafurukawaharafusognd" +
	"alfussaikishiwadafutabayamaguchinomigawafuttsunanjohanamakinohar" +
	"afylkesbiblfyresdalhakubanhakuis-a-lawyerhakusandnessjoenhaldenh" +
	"alsaintlouis-a-anarchistoiretinazawahammarfeastafricapebretonami" +
	"bungotakadahamurakamigoris-a-liberalhangglidinguovdageaidnuoroms" +
	"koguchikuzenhannanmokuizumodellingushikamifuranotairesaotomeldal" +
	"hannoverhallancashirehanyuzenhapmirkutskharkivguernseyhappoumuen" +
	"chenhareidsbergbauernurembergwangjurharstadharvestcelebrationhas" +
	"amarahasaminami-alpschoenbrunnhasudahasvikharkoveronamsskoganeis" +
	"-a-libertarianhatogayakagehatoyamazakitahiroshimarugame-hostre-t" +
	"otenkawahatsukaichiharahattfjelldalhawaiijimarumorimachidahayash" +
	"imamotobusheyhazuminobusenetozsdehemsedalhigashihiroshimanehigas" +
	"hiizumozakitakatakamoriokamakurazakitakyushuaiahigashikagawahiga" +
	"shikagurasoedahigashikawakitaaikitamidtre-gauldalhigashikurumedi" +
	"zinhistorischesapporohigashimatsushimarylandhigashimatsuyamakita" +
	"akitadaitoigawahigashimurayamalatvuopmifunehigashinarusells-for-" +
	"lessaratoverranhigashinehigashiomihachimanchesterhigashiosakasay" +
	"amamotorcycleikangerhigashishirakawamatakanabedzin-addrammenviro" +
	"nmentalconservationhigashisumiyoshikawaminamiaikitamotosumidatla" +
	"ntichiryuoharuovatmpalermomanposts-and-telecommunicationsakurais" +
	"-a-cpaderbornishimerakerhigashitsunotteroyhigashiurausukitanakag" +
	"usukumodenakamuratakanezawahigashiyamatokoriyamanakakogawahigash" +
	"iyodogawahigashiyoshinogaris-a-linux-useranishiaritabashiibahcca" +
	"vuotnagaokakyotambadajozoraumaizurubtsovskjervoystre-slidrettran" +
	"amsosnowiechitachinakagawawindmillucernehiraizumisatohmarylhurst" +
	"athelleirfjordhirakatashinagawahiranairlinedre-eikerimo-i-ranaci" +
	"onhirarahiratsukagawahirayakumodernhistorichousesarpsborgxn--54b" +
	"7fta0cchernovtsykkylveneziahitachiomiyaginowaniigatakahamantovak" +
	"sdalhitachiotagoogleapisa-geekhersoniikappulawyhitoyoshimihamada" +
	"hitradingzjetozawahjartdalhjelmelandholeckobierzycehomelinuxn--5" +
	"5qx5dhomeunixn--90a3academykolaivano-frankivskiervaapsteiermarkh" +
	"melnitskiyamasoyhongooglecodespotranbyhonjyoichiropractichitoset" +
	"ogakushimotoganewportlligatewayuzawahornindalhortendofinternetra" +
	"ni-andria-barletta-trani-andriahoteledatabaseballangenhoyangerho" +
	"ylandetroitraniandriabarlettatraniandriahuissier-justicehumaniti" +
	"esarufutsunomiyawakasaikaitakoelnhurdalhurumajis-a-llamasfjorden" +
	"hyugawaraissmarterthanyouthachiojiyaizuwakamatsubushikusakadogaw" +
	"aiwatarailwayiwateiwatsukiyonojfkhvestbyjgorajpnkoperviklabuysho" +
	"usesavannahgakoryolbia-tempio-olbiatempioolbialystokkekosaigawak" +
	"osakaerodromeconferencechirebungoonomichinomiyakeisenbahnkoseis-" +
	"a-personaltrainerkoshimizumakis-a-photographeroykoshunantokamach" +
	"ippubetsubetsugarustkanzakiyosumitakaginozawaonsenkostromahabmer" +
	"kosugekotohiradomurakotourakouhokutamakis-a-playerkounosumypetsa" +
	"yokkaichirurgiens-dentisteshikagamiishikarikaturindalkouyamasuda" +
	"kouzushimateramoduminamiuonumatsusakahogis-a-republicanadakozaga" +
	"wakozakis-a-rockstarachowicekrageroticarbonia-iglesias-carboniai" +
	"glesiascarboniakrakowkrasnoyarskmsaves-the-whalessandria-trani-b" +
	"arletta-andriatranibarlettaandriakristiansandefjordkristiansundk" +
	"rodsheradkrokstadelvantaakryminamiyamashirokawanabellevuedavvesi" +
	"idazaifudaigobodoesntexisteingeekokonoekumatorinokumejimatsumoto" +
	"fukekumenanyokaichibaikaliszczytnord-odalkunisakis-a-socialistat" +
	"ionkunitachiaraisaijoshkar-olangevagsoykunitomigusukukis-a-soxfa" +
	"nkunneppuwajimakunstsammlungkunstunddesignkurekurgankurobelgorod" +
	"oykurogimimatakasagorgekuroisognekuromatsunairportland-4-salerno" +
	"gatagajoetsuruokadenagahamaroyerotikafjordkurotakikawasakis-a-st" +
	"udentranoykurskolobrzegersundkushirogawakustanairtraffichocolate" +
	"lemarkatowicekusunndalkutchandakutnokuzbassnoasaitamatsukuris-a-" +
	"teacherkassykuzumakis-a-techietis-a-nascarfankvafjordkvalsundkva" +
	"msterdamberkeleykvanangenkvinesdalkvinnheradkviteseidskogkvitsoy" +
	"kwkyowariasahikawakyuragithubalsanagochihayaakasakawagoebinorils" +
	"karpaczeladzgoravocataniaustraliaurskog-holandiscoveryokamikawan" +
	"ehonbetsurugildeskalmykiasmatartcentertainmentamayukibestadgcagl" +
	"iaridagawassamukawatarikuzentakatairaosteroykengerdalto-adigeelv" +
	"inckareliaomoriguchiharamlierneuest-mon-blogueurmishimatsuuramis" +
	"sileitungsenmisugitokashikis-an-actormitakeharamitourisminanomit" +
	"oyoakemiuramiyazumiyotamanomjondalenmombetsurgutrentomskomaganem" +
	"oneyagawamonmouthachirogatakahashimamakitagawamonticellondonetsk" +
	"omakis-a-painteractivegarsheiheijis-a-musicianmontrealestatecoun" +
	"cilmonza-brianzamonza-e-della-brianzamonzabrianzamonzaebrianzamo" +
	"nzaedellabrianzamordoviamoriyamatsuzakis-an-actressasayamamoriyo" +
	"shiokamisunagawamoroyamatta-varjjatrevisolaquilapyatigorskomatsu" +
	"shimassa-carrara-massacarraramassabuzenmoscowmoseushistorymosjoe" +
	"nmoskeneschokoladenmosreggio-calabriamosschoolkuszlgmosvikomforb" +
	"allooninggfarmerseinebinagisodegaurautomotivelandivttasvuotnakai" +
	"wamizawaustinnasushiobarastronomyokohamamatsudaejeonbukarmoyokos" +
	"ukaratsuginamikatagamilitaryokote12muenstermugis-an-anarchistori" +
	"calsocietysnesaseboknowsitallmuikamitondabayashiogamagoriziamuko" +
	"chikuseihigashichichibuskerudinewmexicoldwarszawashingtondchofun" +
	"atoristanore-og-uvdalukowloclawekatsushikabelaugustowadagestange" +
	"mologicaliforniamulhousells-itriesteamurskiptveterinairecreation" +
	"munakatanemuncieszynmuosattemurmanskomitamamuramurotorcraftroand" +
	"inosaureshinomusashimurayamamusashinodesashibetsukumiyamazonawsc" +
	"hweizhevskommunalforbundmuseetrogstadmuseumverenigingmutsuzawamy" +
	"photoshimamytis-a-bookkeepermincommunitysvardopartis-an-engineer" +
	"pasadenakasatsunais-an-entertainerpassenger-associationpaviapesc" +
	"arapharmaciensciencecentersciencehistorypharmacyberlevagangaviik" +
	"arugaulardalphiladelphiaareadmyblogsitephilatelyphoenixn--aropor" +
	"t-byaotsuzakanonjis-byklebesbydgoszczecincinnationalfirearmsaska" +
	"tchewanphotographyogoris-certifiedogawarabikomaezakirunosegawapi" +
	"lotscientisteigenpippupiszminnesotaketakashimatsushigepittsburgh" +
	"ofermobarapkommuneplanetariumisakis-a-therapistoiaplantationplan" +
	"tscrapper-siteplazaplchonangokasejnynysafetychyllestadplorenskog" +
	"podhaleksvikomonopodlasiedlcepodzonepoltavaresearchaeologicalpom" +
	"orzeszowpordenoneporsangerporsangujolsterporsgrunnanpoznanpreser" +
	"vationpresidioprincipesaro-urbino-pesarourbinopesaromantelekommu" +
	"nikationprivneprochowiceproductionproferraraprojectromsolognepro" +
	"mocionpruszkowprzeworskogpsienakatombetsurnadalptzparliamentroms" +
	"akakinokis-an-artistavangerpvtrusteepwpzwqslattumisasaguris-an-a" +
	"ccountantransportrapaniizashellaskimitsubatamiastarnbergsherbroo" +
	"kegawashimojis-goneshimokawashimokitayamashimonitayanagis-into-a" +
	"nimeeresassaris-a-nursells-for-usgardenshimonosekikawashimosuwal" +
	"kis-into-carsatxn--9dbhblg6dielddanuorriminingshimotsukeshimotsu" +
	"mashingulenshinichinanshinjoyoitakaokamchatkameokameyamashinashi" +
	"kiyosatohnoshowashinjukumanoshinkamigotoyohashimotokorozawashins" +
	"hinotsusakis-into-cartoonsaudashinshiroshintokushimashintomikasa" +
	"harashinyoshitomiokaneyamazoeshiojirishirifujiedashioyanaizushir" +
	"ahamatonbetsusonoshirakoenigshiranukaniepceshiraois-into-gamesav" +
	"erdeshiraokanmakiyosemiteshiratakahagis-leetravellinoshishikuis-" +
	"lostfoldshisokndalshisuifuettertdasnetzshitaramashizukuishimofus" +
	"aitokonamegatakatoris-not-certifieducatorahimeshimageandsoundand" +
	"visionshizuokannamihokkaidoshibuyahabaghdadsigdalsimbirskomvuxn-" +
	"-andy-irasimple-urlsirdalsldslgslupskovestfoldsnzsolundsomasvuot" +
	"nakayamasomnakhodkamitsuesoosopotularssonsor-odalsor-varangersor" +
	"foldsorreisahayakawakamiichikaiseiyokoshibahikariwanumatakayamas" +
	"ortlandsorumisawasouthcarolinaklodzkodairasouthwesterniiminamias" +
	"higarasowaspace-to-renturystykanumazuryspbalsfjordlugolekalugans" +
	"karuizawavoues3-ap-northeast-1spjelkavikonantanangerspydebergsqu" +
	"arendalenvikingatlantakazakis-savedunetnedalsrvestneseoullensake" +
	"rsteinkjerusalembetsukubahcavuotnagaivuotnagakutechnologystjohns" +
	"tjordalshalsenstockholmestrandstor-elvdalstordalstorenburgstorfj" +
	"ordstpetersburgstuff-4-salevangerstuttgartuvarggatverdalsuzukano" +
	"yaltaijis-slickhmelnytskyiversaillesauheradsvalbardurhamburgsvei" +
	"osvelvikongsbergsvizzeraswidnicarrierswiebodzinderoyswinoujscien" +
	"ceandhistorysxn--asky-iravestre-slidreamhosterservebbscrappingve" +
	"stre-totenris-uberleetrdvestvagoyvevelstadvibo-valentiavibovalen" +
	"tiavideovinnicartoonarteducationalchikugojomedecinemamurogawatch" +
	"-and-clockongsvingervinnytsiavirginiavirtualvirtuelviterbolognag" +
	"asakikonaioirasecngvladikavkazanvladimirumasakitaurayasudavladiv" +
	"ostokaizukarasjohkamiminerserveftparmavlogvolgogradvolkenkunders" +
	"eaportvologdanskoninohembygdsforbundvolyngdalvoronezhitomirvosse" +
	"vangenvrnvyatkarasjokonskowolansavonakatsugawaxn--bdddj-mrabdxn-" +
	"-bearalvhki-y4axn--berlevg-jxaxn--bhcavuotna-s4axn--bhccavuotna-" +
	"k7axn--bidr-5nachikatsuuraxn--bievt-0qaxn--bjarky-fyaroslavlaand" +
	"erenxn--bjddar-ptakinouexn--blt-elaborxn--bmlo-grajewolominamata" +
	"ketomisatokuyamaxn--bod-2napleservegame-servercellillesandiegorl" +
	"icexn--brnny-wuaccident-investigationjukudoyamaceratabusebastopo" +
	"logyeongbukonyvelomzaporizhzhiaxn--brnnysund-m8accident-preventi" +
	"onlinebraskaunbieidsvollxn--brum-voagatxn--btsfjord-9zaxn--ciqpn" +
	"xn--clchc0ea0b2g2a9gcdxn--comunicaes-v6a2oxn--correios-e-telecom" +
	"unicaes-ghc29axn--czrw28bambleangaviikagoshimallorcadaques3-ap-s" +
	"outheast-2xn--davvenjrga-y4axn--dnna-grandrapidserviceseminexn--" +
	"drbak-wuaxn--dyry-iraxn--eveni-0qa01gaxn--finny-yuaxn--fiqs8sett" +
	"surreyxn--fiqz9sevastopolelxn--fjord-lraxn--fl-ziaxn--flor-jraxn" +
	"--fpcrj9c3dxn--frde-granexn--frna-woarais-very-badaddjamisongdal" +
	"enxn--frya-hraxn--fzc2c9e2choseikakudamatsuedtirollagrarboretumi" +
	"namidaitomanmobileirvikatsuyamashikokuchuostrowiecfarsundyndns-w" +
	"orkshoppdaluccargodonnagasuketrzynishiizunazukis-a-catererxn--ge" +
	"crj9choshibukawaxn--ggaviika-8ya47hadanotogawaxn--gildeskl-g0axn" +
	"--givuotna-8yasakaiminatonsbergxn--gjvik-wuaxn--gls-elachoyodont" +
	"existmein-the-bandaiwafunewspaperxn--gmq050is-very-evillagematsu" +
	"barakawachinaganoharaokinawashirosatobamagazinewhampshireggio-em" +
	"iliaxn--gmqw5axn--h-2familyngenxn--h1aeghadselfiparisor-fronxn--" +
	"h2brj9chtraeumtgeradefenseljejuifcharterxn--hbmer-xqaxn--hcesuol" +
	"o-7ya35barcelonagaravennagareyamalopolskanlandnepropetrovskaruma" +
	"intenancebizenakamagayahikobayashijonawatehimejiheyakutiaxn--her" +
	"y-iraxn--hgebostad-g3axn--hmmrfeasta-s4achungbukautokeinostrowwl" +
	"kpalmspringsakerxn--hnefoss-q1axn--hobl-iraxn--holtlen-hxaxn--hp" +
	"mir-xqaxn--hyanger-q1axn--hylandet-54axn--indery-fyasugis-very-g" +
	"ooddaxn--io0a7is-very-nicexn--j1amhaebaruminamitanexn--j6w193gxn" +
	"--jlster-byasuokarasuyamashikizunokunimilanoxn--jrpeland-54axn--" +
	"karmy-yuaxn--kfjord-iuaxn--klbu-woaxn--koluokta-7ya57hagaxn--kpr" +
	"w13dxn--kpry57dxn--krager-gyatominamibosojaworznoxn--kranghke-b0" +
	"axn--krdsherad-m8axn--krehamn-dxaxn--krjohka-hwab49jevnakershusc" +
	"ulturexn--ksnes-uuaxn--kvfjord-nxaxn--kvitsy-fyatsukaratexn--kvn" +
	"angen-k0axn--l-1fareastcoastaldefencexn--laheadju-7yatsushiroxn-" +
	"-langevg-jxaxn--lcvr32dxn--ldingen-q1axn--leagaviika-52barreaudn" +
	"edalnationalheritagembroideryokozemergencyclopedicasinordre-land" +
	"nipropetrovskasaokaminokawanishiaizubangepilepsyzranzanativeamer" +
	"icanantiques3-eu-west-1xn--lesund-huaxn--lgbbat1ad8jewelryxn--lg" +
	"rd-poachungnamdalseidfjordxn--lhppi-xqaxn--linds-pratottoris-ver" +
	"y-sweetreexn--lns-qlarvikooris-a-patsfanxn--loabt-0qaxn--lrdal-s" +
	"raxn--lrenskog-54axn--lt-liachuvashiaxn--lten-granvindafjordxn--" +
	"lury-iraxn--mely-iraxn--merker-kuaxn--mgb2ddeshacknetrysilkomoro" +
	"tsukamisatohoboldlygoingnowhere-for-moregontrailroadxn--mgb9awbf" +
	"etsundxn--mgba3a4f16axn--mgba3a4franarashinoharaxn--mgbaam7a8hag" +
	"ebostadxn--mgbayh7gpaduaxn--mgbbh1a71exn--mgbc0a9azcgxn--mgberp4" +
	"a5d4a87gxn--mgberp4a5d4arxn--mgbqly7c0a67fbciminamiechizenishino" +
	"miyashironoxn--mgbqly7cvafranziskanerimarinexn--mgbtf8flandersha" +
	"kotankzxn--mjndalen-64axn--mk0axis-with-thebandovre-eikerxn--mla" +
	"tvuopmi-s4axn--mli-tlavagiskexn--mlselv-iuaxn--moreke-juaxn--mos" +
	"jen-eyawaraxn--mot-tlavangenxn--mre-og-romsdal-qqbarrel-of-knowl" +
	"edgeologyomitanobiraxn--msy-ula0haibarakitahatakahatakaishimogos" +
	"enxn--mtta-vrjjat-k7afgretajimakanegasakisosakitagatakaharunjarg" +
	"axn--muost-0qaxn--mxtq1misconfusedxn--nmesjevuemie-tcbajddarchae" +
	"ologyxn--nnx388axn--nodessakuhokksundxn--nry-yla5gxn--nttery-bya" +
	"esellsyourhomeiparochesterxn--nvuotna-hwaxn--o3cw4hakatanohataka" +
	"matsukawaxn--od0algxn--od0aq3barrell-of-knowledgeometre-experts-" +
	"comptables3-fips-us-gov-west-1xn--ogbpf8flatangerxn--oppegrd-ixa" +
	"xn--ostery-fyawatahamaxn--osyro-wuaxn--p1aisesakiwakunigamiharus" +
	"livinghistoryxn--pgbs0dhakodatexn--porsgu-sta26fhskazunoxn--rady" +
	"-iraxn--rdal-poaxn--rde-ulaxn--rdy-0nabarisleofmandalxn--rennesy" +
	"-v1axn--rhkkervju-01afhvalerxn--rholt-mragoworse-thandsondriodej" +
	"aneiroxn--risa-5naritakurashikisshikiyokawaraxn--risr-iraxn--rla" +
	"nd-uuaxn--rlingen-mxaxn--rmskog-byaxn--rros-gratangenxn--rskog-u" +
	"uaxn--rst-0naroyxn--rsta-francaiseharaxn--ryken-vuaxn--ryrvik-by" +
	"axn--s-1farmequipmentxn--s9brj9circuscountryestateofdelawarezzoo" +
	"logicaluroyuzhno-sakhalinskazimierz-dolnyxn--sandnessjen-ogbasel" +
	"burgjemnes3-sa-east-1xn--sandy-yuaxn--seral-lraxn--sgne-grazxn--" +
	"skierv-utazaskoyabenord-fronxn--skjervy-v1axn--skjk-soaxn--sknit" +
	"-yqaxn--sknland-fxaxn--slat-5narusawaxn--slt-elabourxn--smla-hra" +
	"xn--smna-graxn--snase-nraxn--sndre-land-0cbgxn--snes-poaxn--snsa" +
	"-roaxn--sr-aurdal-l8axn--sr-fron-q1axn--sr-odal-q1axn--sr-varang" +
	"er-ggbashkiriaxn--srfold-byaxn--srreisa-q1axn--srum-graxn--stfol" +
	"d-9xaxn--stjrdal-s1axn--stjrdalshalsen-sqbatochigifuchukotkakami" +
	"gaharaxn--stre-toten-zcbatsfjordpalacevje-og-hornnessetagayaselj" +
	"ordrangedalinzaishobarakpetroleumeloyalistavropolkowicexhibition" +
	"aturalhistorymuseumcenterxn--tjme-hraxn--tn0agrigentomologyeongg" +
	"iehtavuoatnaamesjevuemielnoboribetsuitachikawakayamagadanconagaw" +
	"akembuchikujobsharis-foundationxn--tnsberg-q1axn--trany-yuaxn--t" +
	"rgstad-r1axn--trna-woaxn--troms-zuaxn--tysvr-vraxn--uc0atvedestr" +
	"andxn--uc0ay4axn--unjrga-rtakizawaxn--vads-jraxn--vard-jraxn--ve" +
	"grshei-c0axn--vestvgy-ixa6oxn--vg-yiabeppuboleslawiecastresistan" +
	"cexpressexchangets-itambovaroyonabarullensvangjerdrumemorialipet" +
	"skashibatakarazukaminoyamatsuriitatebayashichinohelsinkitakamiiz" +
	"umisanoksnes3-us-gov-west-1xn--vgan-qoaxn--vgsy-qoa0jewishartren" +
	"tinoxn--vler-qoaxn--vre-eiker-k8axn--vrggt-xqadxn--vry-yla5gxn--" +
	"wcvs22dxn--wgbh1citydalusterxn--wgbl6axn--xkc2al3hye2axn--xkc2dl" +
	"3a5ee0hakonexn--yer-znarutokigawaxn--yfro4i67oxn--ygarden-p1axn-" +
	"-ygbi2ammxn--aurskog-hland-jnbaltimore-og-romsdalindesnes3-ap-so" +
	"utheast-1xn--ystre-slidre-ujberlincolnaturalsciencesnaturelles3-" +
	"us-west-1xn--zf0ao64axn--zf0avxn--avery-yuasakegawaxxxn--b-5gaxz"

// nodes is the list of nodes. Each node is represented as a uint32, which
// encodes the node's children, wildcard bit and node type (as an index into
// the children array), ICANN bit and text.
//
// In the //-comment after each node's data, the nodes indexes of the children
// are formatted as (n0x1234-n0x1256), with * denoting the wildcard bit. The
// nodeType is printed as + for normal, ! for exception, and o for parent-only
// nodes that have children but don't match a domain label in their own right.
// An I denotes an ICANN domain.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 9 bits] children index
//	[ 1 bits] ICANN bit
//	[15 bits] text index
//	[ 6 bits] text length
var nodes = [...]uint32{
	0x01a06c42, // n0x0000 c0x0006 (n0x0136-n0x013c)  + I ac
	0x01e01442, // n0x0001 c0x0007 (n0x013c-n0x013d)  + I ad
	0x022138c2, // n0x0002 c0x0008 (n0x013d-n0x0144)  + I ae
	0x02628d84, // n0x0003 c0x0009 (n0x0144-n0x019d)  + I aero
	0x02a41442, // n0x0004 c0x000a (n0x019d-n0x01a2)  + I af
	0x02e082c2, // n0x0005 c0x000b (n0x01a2-n0x01a7)  + I ag
	0x032032c2, // n0x0006 c0x000c (n0x01a7-n0x01ab)  + I ai
	0x03603982, // n0x0007 c0x000d (n0x01ab-n0x01b1)  + I al
	0x002016c2, // n0x0008 c0x0000 (---------------)  + I am
	0x03a00202, // n0x0009 c0x000e (n0x01b1-n0x01b5)  + I an
	0x03e0aa02, // n0x000a c0x000f (n0x01b5-n0x01bb)  + I ao
	0x00271b82, // n0x000b c0x0000 (---------------)  + I aq
	0x04200182, // n0x000c c0x0010 (n0x01bb-n0x01c5)* o I ar
	0x04aae044, // n0x000d c0x0012 (n0x01c6-n0x01cc)  o I arpa
	0x04e02c02, // n0x000e c0x0013 (n0x01cc-n0x01cd)  + I as
	0x00237484, // n0x000f c0x0000 (---------------)  + I asia
	0x05201042, // n0x0010 c0x0014 (n0x01cd-n0x01d4)  + I at
	0x05a02482, // n0x0011 c0x0016 (n0x01d5-n0x01e7)  o I au
	0x06a030c2, // n0x0012 c0x001a (n0x01f7-n0x01f8)  + I aw
	0x00231902, // n0x0013 c0x0000 (---------------)  + I ax
	0x06e16d42, // n0x0014 c0x001b (n0x01f8-n0x0204)  + I az
	0x07201542, // n0x0015 c0x001c (n0x0204-n0x020e)  + I ba
	0x0763efc2, // n0x0016 c0x001d (n0x020e-n0x0216)  + I bb
	0x016f4c82, // n0x0017 c0x0005 (---------------)* o I bd
	0x07a00002, // n0x0018 c0x001e (n0x0216-n0x0218)  + I be
	0x07f1ff82, // n0x0019 c0x001f (n0x0218-n0x0219)  + I bf
	0x0833aa82, // n0x001a c0x0020 (n0x0219-n0x023d)  + I bg
	0x08614242, // n0x001b c0x0021 (n0x023d-n0x0242)  + I bh
	0x08a05742, // n0x001c c0x0022 (n0x0242-n0x0247)  + I bi
	0x08f0c243, // n0x001d c0x0023 (n0x0247-n0x024e)  + I biz
	0x092100c2, // n0x001e c0x0024 (n0x024e-n0x0252)  + I bj
	0x09611002, // n0x001f c0x0025 (n0x0252-n0x0257)  + I bm
	0x01652802, // n0x0020 c0x0005 (---------------)* o I bn
	0x09a033c2, // n0x0021 c0x0026 (n0x0257-n0x0260)  + I bo
	0x09e01882, // n0x0022 c0x0027 (n0x0260-n0x02a5)  + I br
	0x0a605ec2, // n0x0023 c0x0029 (n0x02a6-n0x02ab)  + I bs
	0x0aa14742, // n0x0024 c0x002a (n0x02ab-n0x02b0)  + I bt
	0x0ae2bb02, // n0x0025 c0x002b (n0x02b0-n0x02b2)  + I bw
	0x0b213b02, // n0x0026 c0x002c (n0x02b2-n0x02b6)  + I by
	0x0b62c342, // n0x0027 c0x002d (n0x02b6-n0x02bb)  + I bz
	0x0ba01002, // n0x0028 c0x002e (n0x02bb-n0x02cc)  + I ca
	0x00201003, // n0x0029 c0x0000 (---------------)  + I cat
	0x0be06842, // n0x002a c0x002f (n0x02cc-n0x02d0)  + I cc
	0x0c2fc502, // n0x002b c0x0030 (n0x02d0-n0x02d1)  + I cd
	0x0c703c42, // n0x002c c0x0031 (n0x02d1-n0x02d2)  + I cf
	0x00217202, // n0x002d c0x0000 (---------------)  + I cg
	0x0ca007c2, // n0x002e c0x0032 (n0x02d2-n0x02d3)  + I ch
	0x0ce08a02, // n0x002f c0x0033 (n0x02d3-n0x02e2)  + I ci
	0x0d226c42, // n0x0030 c0x0034 (n0x02e2-n0x02e3)* o I ck
	0x0d6278c2, // n0x0031 c0x0035 (n0x02e3-n0x02e7)  + I cl
	0x0da31002, // n0x0032 c0x0036 (n0x02e7-n0x02e8)  + I cm
	0x0de31842, // n0x0033 c0x0037 (n0x02e8-n0x0314)  + I cn
	0x0e20d642, // n0x0034 c0x0038 (n0x0314-n0x0321)  + I co
	0x0e60d643, // n0x0035 c0x0039 (n0x0321-n0x03d5)  + I com
	0x0023ae84, // n0x0036 c0x0000 (---------------)  + I coop
	0x0ee34182, // n0x0037 c0x003b (n0x03e9-n0x03f0)  + I cr
	0x0f20b742, // n0x0038 c0x003c (n0x03f0-n0x03f6)  + I cu
	0x0f717442, // n0x0039 c0x003d (n0x03f6-n0x03f7)  + I cv
	0x0fb2bbc2, // n0x003a c0x003e (n0x03f7-n0x03fb)  + I cw
	0x0fe40f02, // n0x003b c0x003f (n0x03fb-n0x03fd)  + I cx
	0x01641242, // n0x003c c0x0005 (---------------)* o I cy
	0x10206a42, // n0x003d c0x0040 (n0x03fd-n0x03fe)  + I cz
	0x10602602, // n0x003e c0x0041 (n0x03fe-n0x0406)  + I de
	0x00207b02, // n0x003f c0x0000 (---------------)  + I dj
	0x10a33742, // n0x0040 c0x0042 (n0x0406-n0x0407)  + I dk
	0x10e2b142, // n0x0041 c0x0043 (n0x0407-n0x040c)  + I dm
	0x11202a02, // n0x0042 c0x0044 (n0x040c-n0x0416)  + I do
	0x11668b02, // n0x0043 c0x0045 (n0x0416-n0x041e)  + I dz
	0x11a00fc2, // n0x0044 c0x0046 (n0x041e-n0x042a)  + I ec
	0x002df843, // n0x0045 c0x0000 (---------------)  + I edu
	0x11e04782, // n0x0046 c0x0047 (n0x042a-n0x0434)  + I ee
	0x12211b42, // n0x0047 c0x0048 (n0x0434-n0x043d)  + I eg
	0x01600042, // n0x0048 c0x0005 (---------------)* o I er
	0x12601e42, // n0x0049 c0x0049 (n0x043d-n0x0442)  + I es
	0x01603242, // n0x004a c0x0005 (---------------)* o I et
	0x0020f402, // n0x004b c0x0000 (---------------)  + I eu
	0x12e0bc82, // n0x004c c0x004b (n0x0443-n0x0446)  + I fi
	0x0163e182, // n0x004d c0x0005 (---------------)* o I fj
	0x016977c2, // n0x004e c0x0005 (---------------)* o I fk
	0x00330b82, // n0x004f c0x0000 (---------------)  + I fm
	0x00203482, // n0x0050 c0x0000 (---------------)  + I fo
	0x13207f82, // n0x0051 c0x004c (n0x0446-n0x045e)  + I fr
	0x00202bc2, // n0x0052 c0x0000 (---------------)  + I ga
	0x00205cc2, // n0x0053 c0x0000 (---------------)  + I gd
	0x13604902, // n0x0054 c0x004d (n0x045e-n0x0465)  + I ge
	0x00253ac2, // n0x0055 c0x0000 (---------------)  + I gf
	0x13a04e42, // n0x0056 c0x004e (n0x0465-n0x046a)  + I gg
	0x13e15042, // n0x0057 c0x004f (n0x046a-n0x046f)  + I gh
	0x14205182, // n0x0058 c0x0050 (n0x046f-n0x0475)  + I gi
	0x0020eb82, // n0x0059 c0x0000 (---------------)  + I gl
	0x00238a02, // n0x005a c0x0000 (---------------)  + I gm
	0x14610a02, // n0x005b c0x0051 (n0x0475-n0x047b)  o I gn
	0x00218d43, // n0x005c c0x0000 (---------------)  + I gov
	0x14acdfc2, // n0x005d c0x0052 (n0x047b-n0x0481)  + I gp
	0x002395c2, // n0x005e c0x0000 (---------------)  + I gq
	0x14e00642, // n0x005f c0x0053 (n0x0481-n0x0487)  + I gr
	0x0023c7c2, // n0x0060 c0x0000 (---------------)  + I gs
	0x152bfd42, // n0x0061 c0x0054 (n0x0487-n0x048e)  + I gt
	0x01609b42, // n0x0062 c0x0005 (---------------)* o I gu
	0x00238dc2, // n0x0063 c0x0000 (---------------)  + I gw
	0x156019c2, // n0x0064 c0x0055 (n0x048e-n0x0491)  + I gy
	0x15a15082, // n0x0065 c0x0056 (n0x0491-n0x04a7)  + I hk
	0x0028ad42, // n0x0066 c0x0000 (---------------)  + I hm
	0x15e2a882, // n0x0067 c0x0057 (n0x04a7-n0x04ad)  + I hn
	0x162255c2, // n0x0068 c0x0058 (n0x04ad-n0x04b1)  + I hr
	0x16603b82, // n0x0069 c0x0059 (n0x04b1-n0x04c2)  + I ht
	0x16a2b002, // n0x006a c0x005a (n0x04c2-n0x04e2)  + I hu
	0x16e02282, // n0x006b c0x005b (n0x04e2-n0x04ec)  + I id
	0x17205782, // n0x006c c0x005c (n0x04ec-n0x04ee)  + I ie
	0x17602702, // n0x006d c0x005d (n0x04ee-n0x04ef)* o I il
	0x17e02cc2, // n0x006e c0x005f (n0x04f0-n0x04f6)  + I im
	0x186027c2, // n0x006f c0x0061 (n0x04f8-n0x0505)  + I in
	0x18a10e04, // n0x0070 c0x0062 (n0x0505-n0x050f)  + I info
	0x18e17543, // n0x0071 c0x0063 (n0x050f-n0x0510)  + I int
	0x1920bdc2, // n0x0072 c0x0064 (n0x0510-n0x0512)  + I io
	0x19600e82, // n0x0073 c0x0065 (n0x0512-n0x0518)  + I iq
	0x19a0e282, // n0x0074 c0x0066 (n0x0518-n0x0521)  + I ir
	0x19e00842, // n0x0075 c0x0067 (n0x0521-n0x0527)  + I is
	0x1a205f42, // n0x0076 c0x0068 (n0x0527-n0x063d)  + I it
	0x1a602882, // n0x0077 c0x0069 (n0x063d-n0x0642)  + I je
	0x01740782, // n0x0078 c0x0005 (---------------)* o I jm
	0x1aa094c2, // n0x0079 c0x006a (n0x0642-n0x064a)  + I jo
	0x003422c4, // n0x007a c0x0000 (---------------)  + I jobs
	0x1ae97b42, // n0x007b c0x006b (n0x064a-n0x068a)  + I jp
	0x01606582, // n0x007c c0x0005 (---------------)* o I ke
	0x28a5c902, // n0x007d c0x00a2 (n0x0d20-n0x0d26)  + I kg
	0x01626682, // n0x007e c0x0005 (---------------)* o I kh
	0x28e02242, // n0x007f c0x00a3 (n0x0d26-n0x0d2d)  + I ki
	0x292a07c2, // n0x0080 c0x00a4 (n0x0d2d-n0x0d3e)  + I km
	0x29626942, // n0x0081 c0x00a5 (n0x0d3e-n0x0d42)  + I kn
	0x29b0e002, // n0x0082 c0x00a6 (n0x0d42-n0x0d48)  o I kp
	0x29e015c2, // n0x0083 c0x00a7 (n0x0d48-n0x0d66)  + I kr
	0x016ad002, // n0x0084 c0x0005 (---------------)* o I kw
	0x2a200302, // n0x0085 c0x00a8 (n0x0d66-n0x0d6b)  + I ky
	0x2a724142, // n0x0086 c0x00a9 (n0x0d6b-n0x0d71)  + I kz
	0x2aa02542, // n0x0087 c0x00aa (n0x0d71-n0x0d7a)  + I la
	0x2ae0a982, // n0x0088 c0x00ab (n0x0d7a-n0x0d7f)  o I lb
	0x2b240c02, // n0x0089 c0x00ac (n0x0d7f-n0x0d85)  + I lc
	0x002039c2, // n0x008a c0x0000 (---------------)  + I li
	0x2b614542, // n0x008b c0x00ad (n0x0d85-n0x0d93)  + I lk
	0x2bb00942, // n0x008c c0x00ae (n0x0d93-n0x0d98)  o I lr
	0x2be0d8c2, // n0x008d c0x00af (n0x0d98-n0x0d9a)  + I ls
	0x2c20b7c2, // n0x008e c0x00b0 (n0x0d9a-n0x0d9b)  + I lt
	0x00204982, // n0x008f c0x0000 (---------------)  + I lu
	0x2c6075c2, // n0x0090 c0x00b1 (n0x0d9b-n0x0da4)  + I lv
	0x2ca53602, // n0x0091 c0x00b2 (n0x0da4-n0x0dad)  + I ly
	0x2ce02d02, // n0x0092 c0x00b3 (n0x0dad-n0x0db3)  + I ma
	0x2d2d8982, // n0x0093 c0x00b4 (n0x0db3-n0x0db5)  + I mc
	0x00211042, // n0x0094 c0x0000 (---------------)  + I md
	0x2d602f82, // n0x0095 c0x00b5 (n0x0db5-n0x0dbd)  + I me
	0x2db1e982, // n0x0096 c0x00b6 (n0x0dbd-n0x0dc5)  + I mg
	0x002ed9c2, // n0x0097 c0x0000 (---------------)  + I mh
	0x0022f003, // n0x0098 c0x0000 (---------------)  + I mil
	0x2df246c2, // n0x0099 c0x00b7 (n0x0dc5-n0x0dcc)  + I mk
	0x2e212cc2, // n0x009a c0x00b8 (n0x0dcc-n0x0dd3)  + I ml
	0x01641bc2, // n0x009b c0x0005 (---------------)* o I mm
	0x2e601702, // n0x009c c0x00b9 (n0x0dd3-n0x0dd7)  + I mn
	0x2ea03d42, // n0x009d c0x00ba (n0x0dd7-n0x0ddc)  + I mo
	0x00303304, // n0x009e c0x0000 (---------------)  + I mobi
	0x002071c2, // n0x009f c0x0000 (---------------)  + I mp
	0x00307982, // n0x00a0 c0x0000 (---------------)  + I mq
	0x2ee412c2, // n0x00a1 c0x00bb (n0x0ddc-n0x0dde)  + I mr
	0x00201342, // n0x00a2 c0x0000 (---------------)  + I ms
	0x0165c502, // n0x00a3 c0x0005 (---------------)* o I mt
	0x2f210bc2, // n0x00a4 c0x00bc (n0x0dde-n0x0de5)  + I mu
	0x2f6c4946, // n0x00a5 c0x00bd (n0x0de5-n0x1009)  + I museum
	0x2fa1b542, // n0x00a6 c0x00be (n0x1009-n0x1017)  + I mv
	0x2fe31042, // n0x00a7 c0x00bf (n0x1017-n0x1022)  + I mw
	0x30329482, // n0x00a8 c0x00c0 (n0x1022-n0x1028)  + I mx
	0x3063a882, // n0x00a9 c0x00c1 (n0x1028-n0x102f)  + I my
	0x30afa482, // n0x00aa c0x00c2 (n0x102f-n0x1030)* o I mz
	0x30e00982, // n0x00ab c0x00c3 (n0x1030-n0x1041)  + I na
	0x31202f04, // n0x00ac c0x00c4 (n0x1041-n0x1043)  + I name
	0x31e08ac2, // n0x00ad c0x00c7 (n0x1045-n0x1046)  + I nc
	0x00203e82, // n0x00ae c0x0000 (---------------)  + I ne
	0x32214843, // n0x00af c0x00c8 (n0x1046-n0x1070)  + I net
	0x32610e42, // n0x00b0 c0x00c9 (n0x1070-n0x107a)  + I nf
	0x32a00442, // n0x00b1 c0x00ca (n0x107a-n0x1080)  o I ng
	0x01607802, // n0x00b2 c0x0005 (---------------)* o I ni
	0x32e3ba42, // n0x00b3 c0x00cb (n0x1080-n0x1083)  + I nl
	0x332005c2, // n0x00b4 c0x00cc (n0x1083-n0x1359)  + I no
	0x01600a02, // n0x00b5 c0x0005 (---------------)* o I np
	0x3b6000c2, // n0x00b6 c0x00ed (n0x1381-n0x1388)  + I nr
	0x3ba03642, // n0x00b7 c0x00ee (n0x1388-n0x138b)  + I nu
	0x3be01102, // n0x00b8 c0x00ef (n0x138b-n0x138c)* o I nz
	0x3c608902, // n0x00b9 c0x00f1 (n0x138d-n0x1397)* o I om
	0x3ca3e983, // n0x00ba c0x00f2 (n0x1397-n0x13cc)  + I org
	0x3d20d002, // n0x00bb c0x00f4 (n0x13ce-n0x13d9)  + I pa
	0x3d609242, // n0x00bc c0x00f5 (n0x13d9-n0x13e0)  + I pe
	0x3db2d942, // n0x00bd c0x00f6 (n0x13e0-n0x13e3)  + I pf
	0x01624042, // n0x00be c0x0005 (---------------)* o I pg
	0x3de00702, // n0x00bf c0x00f7 (n0x13e3-n0x13eb)  + I ph
	0x3e2cc282, // n0x00c0 c0x00f8 (n0x13eb-n0x13f9)  + I pk
	0x3e60c3c2, // n0x00c1 c0x00f9 (n0x13f9-n0x14a4)  + I pl
	0x002787c2, // n0x00c2 c0x0000 (---------------)  + I pm
	0x3ee371c2, // n0x00c3 c0x00fb (n0x14ad-n0x14b2)  + I pn
	0x00285744, // n0x00c4 c0x0000 (---------------)  + I post
	0x3f261ec2, // n0x00c5 c0x00fc (n0x14b2-n0x14bf)  + I pr
	0x3f6d1383, // n0x00c6 c0x00fd (n0x14bf-n0x14c6)  + I pro
	0x3fa33842, // n0x00c7 c0x00fe (n0x14c6-n0x14cd)  + I ps
	0x3fe11c02, // n0x00c8 c0x00ff (n0x14cd-n0x14d6)  + I pt
	0x402d3902, // n0x00c9 c0x0100 (n0x14d6-n0x14dc)  + I pw
	0x406b8c02, // n0x00ca c0x0101 (n0x14dc-n0x14e3)  + I py
	0x40af6942, // n0x00cb c0x0102 (n0x14e3-n0x14eb)  + I qa
	0x40e01602, // n0x00cc c0x0103 (n0x14eb-n0x14ef)  + I re
	0x41200ac2, // n0x00cd c0x0104 (n0x14ef-n0x14fb)  + I ro
	0x41602902, // n0x00ce c0x0105 (n0x14fb-n0x1501)  + I rs
	0x41a018c2, // n0x00cf c0x0106 (n0x1501-n0x1586)  + I ru
	0x41e08f82, // n0x00d0 c0x0107 (n0x1586-n0x158f)  + I rw
	0x42202442, // n0x00d1 c0x0108 (n0x158f-n0x1597)  + I sa
	0x4263c6c2, // n0x00d2 c0x0109 (n0x1597-n0x159c)  + I sb
	0x42a01d82, // n0x00d3 c0x010a (n0x159c-n0x15a1)  + I sc
	0x42e03902, // n0x00d4 c0x010b (n0x15a1-n0x15a9)  + I sd
	0x4320da42, // n0x00d5 c0x010c (n0x15a9-n0x15d2)  + I se
	0x43601982, // n0x00d6 c0x010d (n0x15d2-n0x15d9)  + I sg
	0x43a02c42, // n0x00d7 c0x010e (n0x15d9-n0x15de)  + I sh
	0x002040c2, // n0x00d8 c0x0000 (---------------)  + I si
	0x43e02202, // n0x00d9 c0x010f (n0x15de-n0x15df)  + I sk
	0x442113c2, // n0x00da c0x0110 (n0x15df-n0x15e4)  + I sl
	0x00216a02, // n0x00db c0x0000 (---------------)  + I sm
	0x44622982, // n0x00dc c0x0111 (n0x15e4-n0x15eb)  + I sn
	0x44a00882, // n0x00dd c0x0112 (n0x15eb-n0x15ee)  + I so
	0x002ba542, // n0x00de c0x0000 (---------------)  + I sr
	0x44e01382, // n0x00df c0x0113 (n0x15ee-n0x15fa)  + I st
	0x00202ac2, // n0x00e0 c0x0000 (---------------)  + I su
	0x01606602, // n0x00e1 c0x0005 (---------------)* o I sv
	0x452ed302, // n0x00e2 c0x0114 (n0x15fa-n0x15fb)  + I sx
	0x45630a82, // n0x00e3 c0x0115 (n0x15fb-n0x1601)  + I sy
	0x45a069c2, // n0x00e4 c0x0116 (n0x1601-n0x1604)  + I sz
	0x00227742, // n0x00e5 c0x0000 (---------------)  + I tc
	0x45e09fc2, // n0x00e6 c0x0117 (n0x1604-n0x1605)  + I td
	0x0020d543, // n0x00e7 c0x0000 (---------------)  + I tel
	0x00231282, // n0x00e8 c0x0000 (---------------)  + I tf
	0x00234242, // n0x00e9 c0x0000 (---------------)  + I tg
	0x462061c2, // n0x00ea c0x0118 (n0x1605-n0x160c)  + I th
	0x4663ac42, // n0x00eb c0x0119 (n0x160c-n0x161b)  + I tj
	0x002362c2, // n0x00ec c0x0000 (---------------)  + I tk
	0x46a0db02, // n0x00ed c0x011a (n0x161b-n0x161c)  + I tl
	0x46e3a842, // n0x00ee c0x011b (n0x161c-n0x1624)  + I tm
	0x47203602, // n0x00ef c0x011c (n0x1624-n0x1638)  + I tn
	0x47600282, // n0x00f0 c0x011d (n0x1638-n0x163e)  + I to
	0x47a08d82, // n0x00f1 c0x011e (n0x163e-n0x1640)* o I tr
	0x002ddac6, // n0x00f2 c0x0000 (---------------)  + I travel
	0x48207882, // n0x00f3 c0x0120 (n0x1641-n0x1652)  + I tt
	0x48681802, // n0x00f4 c0x0121 (n0x1652-n0x1656)  + I tv
	0x48a4b942, // n0x00f5 c0x0122 (n0x1656-n0x1664)  + I tw
	0x48e148c2, // n0x00f6 c0x0123 (n0x1664-n0x1670)  o I tz
	0x492201c2, // n0x00f7 c0x0124 (n0x1670-n0x16be)  + I ua
	0x49602b82, // n0x00f8 c0x0125 (n0x16be-n0x16c6)  + I ug
	0x49a01902, // n0x00f9 c0x0126 (n0x16c6-n0x16d1)* o I uk
	0x4a201f42, // n0x00fa c0x0128 (n0x16d2-n0x1711)  + I us
	0x5861c8c2, // n0x00fb c0x0161 (n0x17b8-n0x17be)  + I uy
	0x58a3c302, // n0x00fc c0x0162 (n0x17be-n0x17c2)  + I uz
	0x00206f02, // n0x00fd c0x0000 (---------------)  + I va
	0x58e3f542, // n0x00fe c0x0163 (n0x17c2-n0x17c8)  + I vc
	0x59209c42, // n0x00ff c0x0164 (n0x17c8-n0x17d2)  + I ve
	0x00278b42, // n0x0100 c0x0000 (---------------)  + I vg
	0x59609542, // n0x0101 c0x0165 (n0x17d2-n0x17d7)  + I vi
	0x59a00b42, // n0x0102 c0x0166 (n0x17d7-n0x17e3)  + I vn
	0x00206642, // n0x0103 c0x0000 (---------------)  + I vu
	0x00201242, // n0x0104 c0x0000 (---------------)  + I wf
	0x59e1ba82, // n0x0105 c0x0167 (n0x17e3-n0x17ea)  + I ws
	0x00240f4c, // n0x0106 c0x0000 (---------------)  + I xn--3e0b707e
	0x0026454b, // n0x0107 c0x0000 (---------------)  + I xn--45brj9c
	0x0028ce4e, // n0x0108 c0x0000 (---------------)  + I xn--54b7fta0cc
	0x0029030a, // n0x0109 c0x0000 (---------------)  + I xn--90a3ac
	0x002fc016, // n0x010a c0x0000 (---------------)  + I xn--clchc0ea0b2g2a9gcd
	0x002ffcca, // n0x010b c0x0000 (---------------)  + I xn--fiqs8s
	0x0030018a, // n0x010c c0x0000 (---------------)  + I xn--fiqz9s
	0x00300f8d, // n0x010d c0x0000 (---------------)  + I xn--fpcrj9c3d
	0x0030238d, // n0x010e c0x0000 (---------------)  + I xn--fzc2c9e2c
	0x00304e8b, // n0x010f c0x0000 (---------------)  + I xn--gecrj9c
	0x00309f0b, // n0x0110 c0x0000 (---------------)  + I xn--h2brj9c
	0x00310689, // n0x0111 c0x0000 (---------------)  + I xn--j1amh
	0x00310ccb, // n0x0112 c0x0000 (---------------)  + I xn--j6w193g
	0x00312e4b, // n0x0113 c0x0000 (---------------)  + I xn--kprw13d
	0x0031310b, // n0x0114 c0x0000 (---------------)  + I xn--kpry57d
	0x0031a94f, // n0x0115 c0x0000 (---------------)  + I xn--lgbbat1ad8j
	0x0031e88c, // n0x0116 c0x0000 (---------------)  + I xn--mgb2ddes
	0x0031fd0c, // n0x0117 c0x0000 (---------------)  + I xn--mgb9awbf
	0x0032018f, // n0x0118 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0032054e, // n0x0119 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x00320c0e, // n0x011a c0x0000 (---------------)  + I xn--mgbaam7a8h
	0x003211ce, // n0x011b c0x0000 (---------------)  + I xn--mgbayh7gpa
	0x0032160e, // n0x011c c0x0000 (---------------)  + I xn--mgbbh1a71e
	0x0032198f, // n0x011d c0x0000 (---------------)  + I xn--mgbc0a9azcg
	0x00321d53, // n0x011e c0x0000 (---------------)  + I xn--mgberp4a5d4a87g
	0x00322211, // n0x011f c0x0000 (---------------)  + I xn--mgberp4a5d4ar
	0x00322653, // n0x0120 c0x0000 (---------------)  + I xn--mgbqly7c0a67fbc
	0x003232d0, // n0x0121 c0x0000 (---------------)  + I xn--mgbqly7cvafr
	0x00323b0c, // n0x0122 c0x0000 (---------------)  + I xn--mgbtf8fl
	0x0032a14b, // n0x0123 c0x0000 (---------------)  + I xn--nnx388a
	0x0032a408, // n0x0124 c0x0000 (---------------)  + I xn--node
	0x0032ba4a, // n0x0125 c0x0000 (---------------)  + I xn--o3cw4h
	0x0032d78c, // n0x0126 c0x0000 (---------------)  + I xn--ogbpf8fl
	0x0032e8c8, // n0x0127 c0x0000 (---------------)  + I xn--p1ai
	0x0032f34b, // n0x0128 c0x0000 (---------------)  + I xn--pgbs0dh
	0x0033554b, // n0x0129 c0x0000 (---------------)  + I xn--s9brj9c
	0x0034a1ca, // n0x012a c0x0000 (---------------)  + I xn--wgbh1c
	0x0034a70a, // n0x012b c0x0000 (---------------)  + I xn--wgbl6a
	0x0034a990, // n0x012c c0x0000 (---------------)  + I xn--xkc2al3hye2a
	0x0034ad91, // n0x012d c0x0000 (---------------)  + I xn--xkc2dl3a5ee0h
	0x0034b84d, // n0x012e c0x0000 (---------------)  + I xn--yfro4i67o
	0x0034bf4d, // n0x012f c0x0000 (---------------)  + I xn--ygbi2ammx
	0x0034ecc3, // n0x0130 c0x0000 (---------------)  + I xxx
	0x0161a042, // n0x0131 c0x0005 (---------------)* o I ye
	0x00252042, // n0x0132 c0x0000 (---------------)  + I yt
	0x01601142, // n0x0133 c0x0005 (---------------)* o I za
	0x016cb642, // n0x0134 c0x0005 (---------------)* o I zm
	0x016d39c2, // n0x0135 c0x0005 (---------------)* o I zw
	0x0020d643, // n0x0136 c0x0000 (---------------)  + I com
	0x002df843, // n0x0137 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0138 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0139 c0x0000 (---------------)  + I mil
	0x00214843, // n0x013a c0x0000 (---------------)  + I net
	0x0023e983, // n0x013b c0x0000 (---------------)  + I org
	0x00216583, // n0x013c c0x0000 (---------------)  + I nom
	0x00206c42, // n0x013d c0x0000 (---------------)  + I ac
	0x0020d642, // n0x013e c0x0000 (---------------)  + I co
	0x00218d43, // n0x013f c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0140 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0141 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0142 c0x0000 (---------------)  + I org
	0x00201d83, // n0x0143 c0x0000 (---------------)  + I sch
	0x002f93d6, // n0x0144 c0x0000 (---------------)  + I accident-investigation
	0x002fabd3, // n0x0145 c0x0000 (---------------)  + I accident-prevention
	0x00228d89, // n0x0146 c0x0000 (---------------)  + I aerobatic
	0x00262248, // n0x0147 c0x0000 (---------------)  + I aeroclub
	0x00299109, // n0x0148 c0x0000 (---------------)  + I aerodrome
	0x0023b746, // n0x0149 c0x0000 (---------------)  + I agents
	0x0023fad0, // n0x014a c0x0000 (---------------)  + I air-surveillance
	0x00268313, // n0x014b c0x0000 (---------------)  + I air-traffic-control
	0x0026e508, // n0x014c c0x0000 (---------------)  + I aircraft
	0x0028b907, // n0x014d c0x0000 (---------------)  + I airline
	0x002a7ac7, // n0x014e c0x0000 (---------------)  + I airport
	0x002a9b8a, // n0x014f c0x0000 (---------------)  + I airtraffic
	0x0020b989, // n0x0150 c0x0000 (---------------)  + I ambulance
	0x0022b2c9, // n0x0151 c0x0000 (---------------)  + I amusement
	0x002c6b0b, // n0x0152 c0x0000 (---------------)  + I association
	0x00237546, // n0x0153 c0x0000 (---------------)  + I author
	0x002bafca, // n0x0154 c0x0000 (---------------)  + I ballooning
	0x00220e86, // n0x0155 c0x0000 (---------------)  + I broker
	0x00230183, // n0x0156 c0x0000 (---------------)  + I caa
	0x00304345, // n0x0157 c0x0000 (---------------)  + I cargo
	0x002179c8, // n0x0158 c0x0000 (---------------)  + I catering
	0x0020bb4d, // n0x0159 c0x0000 (---------------)  + I certification
	0x0024db0c, // n0x015a c0x0000 (---------------)  + I championship
	0x0030a847, // n0x015b c0x0000 (---------------)  + I charter
	0x0022cb0d, // n0x015c c0x0000 (---------------)  + I civilaviation
	0x00262344, // n0x015d c0x0000 (---------------)  + I club
	0x0029934a, // n0x015e c0x0000 (---------------)  + I conference
	0x00237fca, // n0x015f c0x0000 (---------------)  + I consultant
	0x0023848a, // n0x0160 c0x0000 (---------------)  + I consulting
	0x00268607, // n0x0161 c0x0000 (---------------)  + I control
	0x002b5f07, // n0x0162 c0x0000 (---------------)  + I council
	0x00240404, // n0x0163 c0x0000 (---------------)  + I crew
	0x00229ec6, // n0x0164 c0x0000 (---------------)  + I design
	0x002afe84, // n0x0165 c0x0000 (---------------)  + I dgca
	0x002df848, // n0x0166 c0x0000 (---------------)  + I educator
	0x00318849, // n0x0167 c0x0000 (---------------)  + I emergency
	0x002c5e06, // n0x0168 c0x0000 (---------------)  + I engine
	0x002c5e08, // n0x0169 c0x0000 (---------------)  + I engineer
	0x002af84d, // n0x016a c0x0000 (---------------)  + I entertainment
	0x00335309, // n0x016b c0x0000 (---------------)  + I equipment
	0x00346208, // n0x016c c0x0000 (---------------)  + I exchange
	0x00346047, // n0x016d c0x0000 (---------------)  + I express
	0x0026bc0a, // n0x016e c0x0000 (---------------)  + I federation
	0x00245686, // n0x016f c0x0000 (---------------)  + I flight
	0x0024f087, // n0x0170 c0x0000 (---------------)  + I freight
	0x0022b604, // n0x0171 c0x0000 (---------------)  + I fuel
	0x0024fac7, // n0x0172 c0x0000 (---------------)  + I gliding
	0x0026160a, // n0x0173 c0x0000 (---------------)  + I government
	0x0024ebce, // n0x0174 c0x0000 (---------------)  + I groundhandling
	0x00204e85, // n0x0175 c0x0000 (---------------)  + I group
	0x0027690b, // n0x0176 c0x0000 (---------------)  + I hanggliding
	0x0024a5c9, // n0x0177 c0x0000 (---------------)  + I homebuilt
	0x00216e49, // n0x0178 c0x0000 (---------------)  + I insurance
	0x00216807, // n0x0179 c0x0000 (---------------)  + I journal
	0x0025bd0a, // n0x017a c0x0000 (---------------)  + I journalist
	0x0021e387, // n0x017b c0x0000 (---------------)  + I leasing
	0x00245fc9, // n0x017c c0x0000 (---------------)  + I logistics
	0x003089c8, // n0x017d c0x0000 (---------------)  + I magazine
	0x0030bf8b, // n0x017e c0x0000 (---------------)  + I maintenance
	0x0020c24b, // n0x017f c0x0000 (---------------)  + I marketplace
	0x0023dbc5, // n0x0180 c0x0000 (---------------)  + I media
	0x0025900a, // n0x0181 c0x0000 (---------------)  + I microlight
	0x00277649, // n0x0182 c0x0000 (---------------)  + I modelling
	0x0020c80a, // n0x0183 c0x0000 (---------------)  + I navigation
	0x0024ddcb, // n0x0184 c0x0000 (---------------)  + I parachuting
	0x0024f9cb, // n0x0185 c0x0000 (---------------)  + I paragliding
	0x002c6895, // n0x0186 c0x0000 (---------------)  + I passenger-association
	0x002caf85, // n0x0187 c0x0000 (---------------)  + I pilot
	0x003460c5, // n0x0188 c0x0000 (---------------)  + I press
	0x002d160a, // n0x0189 c0x0000 (---------------)  + I production
	0x002c1d8a, // n0x018a c0x0000 (---------------)  + I recreation
	0x00270e87, // n0x018b c0x0000 (---------------)  + I repbody
	0x0021a643, // n0x018c c0x0000 (---------------)  + I res
	0x002ceac8, // n0x018d c0x0000 (---------------)  + I research
	0x002c2c4a, // n0x018e c0x0000 (---------------)  + I rotorcraft
	0x002cd986, // n0x018f c0x0000 (---------------)  + I safety
	0x002cb0c9, // n0x0190 c0x0000 (---------------)  + I scientist
	0x002febc8, // n0x0191 c0x0000 (---------------)  + I services
	0x002d92c4, // n0x0192 c0x0000 (---------------)  + I show
	0x00264c89, // n0x0193 c0x0000 (---------------)  + I skydiving
	0x00266488, // n0x0194 c0x0000 (---------------)  + I software
	0x002a8f87, // n0x0195 c0x0000 (---------------)  + I student
	0x002318c4, // n0x0196 c0x0000 (---------------)  + I taxi
	0x00255686, // n0x0197 c0x0000 (---------------)  + I trader
	0x0028f087, // n0x0198 c0x0000 (---------------)  + I trading
	0x0029a287, // n0x0199 c0x0000 (---------------)  + I trainer
	0x0025fbc5, // n0x019a c0x0000 (---------------)  + I union
	0x00204ccc, // n0x019b c0x0000 (---------------)  + I workinggroup
	0x00303fc5, // n0x019c c0x0000 (---------------)  + I works
	0x0020d643, // n0x019d c0x0000 (---------------)  + I com
	0x002df843, // n0x019e c0x0000 (---------------)  + I edu
	0x00218d43, // n0x019f c0x0000 (---------------)  + I gov
	0x00214843, // n0x01a0 c0x0000 (---------------)  + I net
	0x0023e983, // n0x01a1 c0x0000 (---------------)  + I org
	0x0020d642, // n0x01a2 c0x0000 (---------------)  + I co
	0x0020d643, // n0x01a3 c0x0000 (---------------)  + I com
	0x00214843, // n0x01a4 c0x0000 (---------------)  + I net
	0x00216583, // n0x01a5 c0x0000 (---------------)  + I nom
	0x0023e983, // n0x01a6 c0x0000 (---------------)  + I org
	0x0020d643, // n0x01a7 c0x0000 (---------------)  + I com
	0x00214843, // n0x01a8 c0x0000 (---------------)  + I net
	0x00213e43, // n0x01a9 c0x0000 (---------------)  + I off
	0x0023e983, // n0x01aa c0x0000 (---------------)  + I org
	0x0020d643, // n0x01ab c0x0000 (---------------)  + I com
	0x002df843, // n0x01ac c0x0000 (---------------)  + I edu
	0x00218d43, // n0x01ad c0x0000 (---------------)  + I gov
	0x0022f003, // n0x01ae c0x0000 (---------------)  + I mil
	0x00214843, // n0x01af c0x0000 (---------------)  + I net
	0x0023e983, // n0x01b0 c0x0000 (---------------)  + I org
	0x0020d643, // n0x01b1 c0x0000 (---------------)  + I com
	0x002df843, // n0x01b2 c0x0000 (---------------)  + I edu
	0x00214843, // n0x01b3 c0x0000 (---------------)  + I net
	0x0023e983, // n0x01b4 c0x0000 (---------------)  + I org
	0x0020d642, // n0x01b5 c0x0000 (---------------)  + I co
	0x00207902, // n0x01b6 c0x0000 (---------------)  + I ed
	0x002386c2, // n0x01b7 c0x0000 (---------------)  + I gv
	0x00205f42, // n0x01b8 c0x0000 (---------------)  + I it
	0x00200602, // n0x01b9 c0x0000 (---------------)  + I og
	0x00270f02, // n0x01ba c0x0000 (---------------)  + I pb
	0x0460d643, // n0x01bb c0x0011 (n0x01c5-n0x01c6)  o I com
	0x00635053, // n0x01bc c0x0001 (---------------)  ! I congresodelalengua3
	0x006df844, // n0x01bd c0x0001 (---------------)  ! I educ
	0x00665493, // n0x01be c0x0001 (---------------)  ! I gobiernoelectronico
	0x006992c5, // n0x01bf c0x0001 (---------------)  ! I mecon
	0x0068bf06, // n0x01c0 c0x0001 (---------------)  ! I nacion
	0x00611783, // n0x01c1 c0x0001 (---------------)  ! I nic
	0x006d1f49, // n0x01c2 c0x0001 (---------------)  ! I promocion
	0x00675686, // n0x01c3 c0x0001 (---------------)  ! I retina
	0x00629ac3, // n0x01c4 c0x0001 (---------------)  ! I uba
	0x0003c708, // n0x01c5 c0x0000 (---------------)  +   blogspot
	0x00237ec4, // n0x01c6 c0x0000 (---------------)  + I e164
	0x00283c07, // n0x01c7 c0x0000 (---------------)  + I in-addr
	0x0022ebc3, // n0x01c8 c0x0000 (---------------)  + I ip6
	0x002db884, // n0x01c9 c0x0000 (---------------)  + I iris
	0x00224543, // n0x01ca c0x0000 (---------------)  + I uri
	0x00216883, // n0x01cb c0x0000 (---------------)  + I urn
	0x00218d43, // n0x01cc c0x0000 (---------------)  + I gov
	0x00206c42, // n0x01cd c0x0000 (---------------)  + I ac
	0x0010c243, // n0x01ce c0x0000 (---------------)  +   biz
	0x0560d642, // n0x01cf c0x0015 (n0x01d4-n0x01d5)  + I co
	0x002386c2, // n0x01d0 c0x0000 (---------------)  + I gv
	0x00010e04, // n0x01d1 c0x0000 (---------------)  +   info
	0x00200a82, // n0x01d2 c0x0000 (---------------)  + I or
	0x000d1204, // n0x01d3 c0x0000 (---------------)  +   priv
	0x0003c708, // n0x01d4 c0x0000 (---------------)  +   blogspot
	0x00291d03, // n0x01d5 c0x0000 (---------------)  + I act
	0x00226343, // n0x01d6 c0x0000 (---------------)  + I asn
	0x05e0d643, // n0x01d7 c0x0017 (n0x01e7-n0x01e8)  + I com
	0x00299344, // n0x01d8 c0x0000 (---------------)  + I conf
	0x062df843, // n0x01d9 c0x0018 (n0x01e8-n0x01f0)  + I edu
	0x06618d43, // n0x01da c0x0019 (n0x01f0-n0x01f7)  + I gov
	0x00202282, // n0x01db c0x0000 (---------------)  + I id
	0x00210e04, // n0x01dc c0x0000 (---------------)  + I info
	0x00214843, // n0x01dd c0x0000 (---------------)  + I net
	0x0026c783, // n0x01de c0x0000 (---------------)  + I nsw
	0x00200242, // n0x01df c0x0000 (---------------)  + I nt
	0x0023e983, // n0x01e0 c0x0000 (---------------)  + I org
	0x00219002, // n0x01e1 c0x0000 (---------------)  + I oz
	0x00251d83, // n0x01e2 c0x0000 (---------------)  + I qld
	0x00202442, // n0x01e3 c0x0000 (---------------)  + I sa
	0x00210c43, // n0x01e4 c0x0000 (---------------)  + I tas
	0x00257443, // n0x01e5 c0x0000 (---------------)  + I vic
	0x00203102, // n0x01e6 c0x0000 (---------------)  + I wa
	0x0003c708, // n0x01e7 c0x0000 (---------------)  +   blogspot
	0x00291d03, // n0x01e8 c0x0000 (---------------)  + I act
	0x0026c783, // n0x01e9 c0x0000 (---------------)  + I nsw
	0x00200242, // n0x01ea c0x0000 (---------------)  + I nt
	0x00251d83, // n0x01eb c0x0000 (---------------)  + I qld
	0x00202442, // n0x01ec c0x0000 (---------------)  + I sa
	0x00210c43, // n0x01ed c0x0000 (---------------)  + I tas
	0x00257443, // n0x01ee c0x0000 (---------------)  + I vic
	0x00203102, // n0x01ef c0x0000 (---------------)  + I wa
	0x00291d03, // n0x01f0 c0x0000 (---------------)  + I act
	0x00200242, // n0x01f1 c0x0000 (---------------)  + I nt
	0x00251d83, // n0x01f2 c0x0000 (---------------)  + I qld
	0x00202442, // n0x01f3 c0x0000 (---------------)  + I sa
	0x00210c43, // n0x01f4 c0x0000 (---------------)  + I tas
	0x00257443, // n0x01f5 c0x0000 (---------------)  + I vic
	0x00203102, // n0x01f6 c0x0000 (---------------)  + I wa
	0x0020d643, // n0x01f7 c0x0000 (---------------)  + I com
	0x0030c243, // n0x01f8 c0x0000 (---------------)  + I biz
	0x0020d643, // n0x01f9 c0x0000 (---------------)  + I com
	0x002df843, // n0x01fa c0x0000 (---------------)  + I edu
	0x00218d43, // n0x01fb c0x0000 (---------------)  + I gov
	0x00210e04, // n0x01fc c0x0000 (---------------)  + I info
	0x00217543, // n0x01fd c0x0000 (---------------)  + I int
	0x0022f003, // n0x01fe c0x0000 (---------------)  + I mil
	0x00202f04, // n0x01ff c0x0000 (---------------)  + I name
	0x00214843, // n0x0200 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0201 c0x0000 (---------------)  + I org
	0x00203f02, // n0x0202 c0x0000 (---------------)  + I pp
	0x002d1383, // n0x0203 c0x0000 (---------------)  + I pro
	0x0020d642, // n0x0204 c0x0000 (---------------)  + I co
	0x0020d643, // n0x0205 c0x0000 (---------------)  + I com
	0x002df843, // n0x0206 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0207 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0208 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0209 c0x0000 (---------------)  + I net
	0x0023e983, // n0x020a c0x0000 (---------------)  + I org
	0x00202902, // n0x020b c0x0000 (---------------)  + I rs
	0x002fb304, // n0x020c c0x0000 (---------------)  + I unbi
	0x00262f44, // n0x020d c0x0000 (---------------)  + I unsa
	0x0030c243, // n0x020e c0x0000 (---------------)  + I biz
	0x0020d643, // n0x020f c0x0000 (---------------)  + I com
	0x002df843, // n0x0210 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0211 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x0212 c0x0000 (---------------)  + I info
	0x00214843, // n0x0213 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0214 c0x0000 (---------------)  + I org
	0x002e9c05, // n0x0215 c0x0000 (---------------)  + I store
	0x00206c42, // n0x0216 c0x0000 (---------------)  + I ac
	0x0003c708, // n0x0217 c0x0000 (---------------)  +   blogspot
	0x00218d43, // n0x0218 c0x0000 (---------------)  + I gov
	0x00231781, // n0x0219 c0x0000 (---------------)  + I 0
	0x00206381, // n0x021a c0x0000 (---------------)  + I 1
	0x00202141, // n0x021b c0x0000 (---------------)  + I 2
	0x00201ec1, // n0x021c c0x0000 (---------------)  + I 3
	0x00237f81, // n0x021d c0x0000 (---------------)  + I 4
	0x00264681, // n0x021e c0x0000 (---------------)  + I 5
	0x0022ec41, // n0x021f c0x0000 (---------------)  + I 6
	0x00241141, // n0x0220 c0x0000 (---------------)  + I 7
	0x002fab81, // n0x0221 c0x0000 (---------------)  + I 8
	0x00264781, // n0x0222 c0x0000 (---------------)  + I 9
	0x00200181, // n0x0223 c0x0000 (---------------)  + I a
	0x00200001, // n0x0224 c0x0000 (---------------)  + I b
	0x00200501, // n0x0225 c0x0000 (---------------)  + I c
	0x00201481, // n0x0226 c0x0000 (---------------)  + I d
	0x00200041, // n0x0227 c0x0000 (---------------)  + I e
	0x00201281, // n0x0228 c0x0000 (---------------)  + I f
	0x00200481, // n0x0229 c0x0000 (---------------)  + I g
	0x00200741, // n0x022a c0x0000 (---------------)  + I h
	0x00200781, // n0x022b c0x0000 (---------------)  + I i
	0x00202881, // n0x022c c0x0000 (---------------)  + I j
	0x00200301, // n0x022d c0x0000 (---------------)  + I k
	0x00202541, // n0x022e c0x0000 (---------------)  + I l
	0x00201341, // n0x022f c0x0000 (---------------)  + I m
	0x002000c1, // n0x0230 c0x0000 (---------------)  + I n
	0x002002c1, // n0x0231 c0x0000 (---------------)  + I o
	0x00200701, // n0x0232 c0x0000 (---------------)  + I p
	0x00200ec1, // n0x0233 c0x0000 (---------------)  + I q
	0x00200081, // n0x0234 c0x0000 (---------------)  + I r
	0x00200881, // n0x0235 c0x0000 (---------------)  + I s
	0x00200141, // n0x0236 c0x0000 (---------------)  + I t
	0x00200f01, // n0x0237 c0x0000 (---------------)  + I u
	0x00200b41, // n0x0238 c0x0000 (---------------)  + I v
	0x00201241, // n0x0239 c0x0000 (---------------)  + I w
	0x00202dc1, // n0x023a c0x0000 (---------------)  + I x
	0x00200341, // n0x023b c0x0000 (---------------)  + I y
	0x00201141, // n0x023c c0x0000 (---------------)  + I z
	0x0020d643, // n0x023d c0x0000 (---------------)  + I com
	0x002df843, // n0x023e c0x0000 (---------------)  + I edu
	0x00218d43, // n0x023f c0x0000 (---------------)  + I gov
	0x00214843, // n0x0240 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0241 c0x0000 (---------------)  + I org
	0x0020d642, // n0x0242 c0x0000 (---------------)  + I co
	0x0020d643, // n0x0243 c0x0000 (---------------)  + I com
	0x002df843, // n0x0244 c0x0000 (---------------)  + I edu
	0x00200a82, // n0x0245 c0x0000 (---------------)  + I or
	0x0023e983, // n0x0246 c0x0000 (---------------)  + I org
	0x00004a46, // n0x0247 c0x0000 (---------------)  +   dyndns
	0x0004730a, // n0x0248 c0x0000 (---------------)  +   for-better
	0x0011f808, // n0x0249 c0x0000 (---------------)  +   for-more
	0x00047948, // n0x024a c0x0000 (---------------)  +   for-some
	0x00048347, // n0x024b c0x0000 (---------------)  +   for-the
	0x00109ac6, // n0x024c c0x0000 (---------------)  +   selfip
	0x000141c6, // n0x024d c0x0000 (---------------)  +   webhop
	0x002072c4, // n0x024e c0x0000 (---------------)  + I asso
	0x00317dc7, // n0x024f c0x0000 (---------------)  + I barreau
	0x0003c708, // n0x0250 c0x0000 (---------------)  +   blogspot
	0x00257384, // n0x0251 c0x0000 (---------------)  + I gouv
	0x0020d643, // n0x0252 c0x0000 (---------------)  + I com
	0x002df843, // n0x0253 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0254 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0255 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0256 c0x0000 (---------------)  + I org
	0x0020d643, // n0x0257 c0x0000 (---------------)  + I com
	0x002df843, // n0x0258 c0x0000 (---------------)  + I edu
	0x00265483, // n0x0259 c0x0000 (---------------)  + I gob
	0x00218d43, // n0x025a c0x0000 (---------------)  + I gov
	0x00217543, // n0x025b c0x0000 (---------------)  + I int
	0x0022f003, // n0x025c c0x0000 (---------------)  + I mil
	0x00214843, // n0x025d c0x0000 (---------------)  + I net
	0x0023e983, // n0x025e c0x0000 (---------------)  + I org
	0x00281802, // n0x025f c0x0000 (---------------)  + I tv
	0x002c48c3, // n0x0260 c0x0000 (---------------)  + I adm
	0x00257c83, // n0x0261 c0x0000 (---------------)  + I adv
	0x0020b643, // n0x0262 c0x0000 (---------------)  + I agr
	0x002016c2, // n0x0263 c0x0000 (---------------)  + I am
	0x00251d03, // n0x0264 c0x0000 (---------------)  + I arq
	0x0020e343, // n0x0265 c0x0000 (---------------)  + I art
	0x0020fd03, // n0x0266 c0x0000 (---------------)  + I ato
	0x00200001, // n0x0267 c0x0000 (---------------)  + I b
	0x0020d803, // n0x0268 c0x0000 (---------------)  + I bio
	0x00205584, // n0x0269 c0x0000 (---------------)  + I blog
	0x00211003, // n0x026a c0x0000 (---------------)  + I bmd
	0x00322ac3, // n0x026b c0x0000 (---------------)  + I cim
	0x002f1403, // n0x026c c0x0000 (---------------)  + I cng
	0x00231843, // n0x026d c0x0000 (---------------)  + I cnt
	0x0a20d643, // n0x026e c0x0028 (n0x02a5-n0x02a6)  + I com
	0x0023ae84, // n0x026f c0x0000 (---------------)  + I coop
	0x002f13c3, // n0x0270 c0x0000 (---------------)  + I ecn
	0x0020d603, // n0x0271 c0x0000 (---------------)  + I eco
	0x002df843, // n0x0272 c0x0000 (---------------)  + I edu
	0x0023a303, // n0x0273 c0x0000 (---------------)  + I emp
	0x00204883, // n0x0274 c0x0000 (---------------)  + I eng
	0x00291703, // n0x0275 c0x0000 (---------------)  + I esp
	0x00230f83, // n0x0276 c0x0000 (---------------)  + I etc
	0x00222fc3, // n0x0277 c0x0000 (---------------)  + I eti
	0x00201283, // n0x0278 c0x0000 (---------------)  + I far
	0x00245f84, // n0x0279 c0x0000 (---------------)  + I flog
	0x00330b82, // n0x027a c0x0000 (---------------)  + I fm
	0x00247083, // n0x027b c0x0000 (---------------)  + I fnd
	0x0024ce83, // n0x027c c0x0000 (---------------)  + I fot
	0x00268883, // n0x027d c0x0000 (---------------)  + I fst
	0x0022ba43, // n0x027e c0x0000 (---------------)  + I g12
	0x002bb203, // n0x027f c0x0000 (---------------)  + I ggf
	0x00218d43, // n0x0280 c0x0000 (---------------)  + I gov
	0x002e0c83, // n0x0281 c0x0000 (---------------)  + I imb
	0x002051c3, // n0x0282 c0x0000 (---------------)  + I ind
	0x00210e03, // n0x0283 c0x0000 (---------------)  + I inf
	0x0023e1c3, // n0x0284 c0x0000 (---------------)  + I jor
	0x00294c43, // n0x0285 c0x0000 (---------------)  + I jus
	0x0023e603, // n0x0286 c0x0000 (---------------)  + I leg
	0x00300603, // n0x0287 c0x0000 (---------------)  + I lel
	0x0021abc3, // n0x0288 c0x0000 (---------------)  + I mat
	0x0023dbc3, // n0x0289 c0x0000 (---------------)  + I med
	0x0022f003, // n0x028a c0x0000 (---------------)  + I mil
	0x0022b303, // n0x028b c0x0000 (---------------)  + I mus
	0x00214843, // n0x028c c0x0000 (---------------)  + I net
	0x00216583, // n0x028d c0x0000 (---------------)  + I nom
	0x0020d203, // n0x028e c0x0000 (---------------)  + I not
	0x00268683, // n0x028f c0x0000 (---------------)  + I ntr
	0x0023b403, // n0x0290 c0x0000 (---------------)  + I odo
	0x0023e983, // n0x0291 c0x0000 (---------------)  + I org
	0x00224003, // n0x0292 c0x0000 (---------------)  + I ppg
	0x002d1383, // n0x0293 c0x0000 (---------------)  + I pro
	0x0027a483, // n0x0294 c0x0000 (---------------)  + I psc
	0x002d2643, // n0x0295 c0x0000 (---------------)  + I psi
	0x002d3a43, // n0x0296 c0x0000 (---------------)  + I qsl
	0x0023f845, // n0x0297 c0x0000 (---------------)  + I radio
	0x002c1d83, // n0x0298 c0x0000 (---------------)  + I rec
	0x002e1703, // n0x0299 c0x0000 (---------------)  + I slg
	0x002e7b03, // n0x029a c0x0000 (---------------)  + I srv
	0x002318c4, // n0x029b c0x0000 (---------------)  + I taxi
	0x00335c03, // n0x029c c0x0000 (---------------)  + I teo
	0x00285443, // n0x029d c0x0000 (---------------)  + I tmp
	0x002ee543, // n0x029e c0x0000 (---------------)  + I trd
	0x002017c3, // n0x029f c0x0000 (---------------)  + I tur
	0x00281802, // n0x02a0 c0x0000 (---------------)  + I tv
	0x0023cd43, // n0x02a1 c0x0000 (---------------)  + I vet
	0x002f2984, // n0x02a2 c0x0000 (---------------)  + I vlog
	0x0022c644, // n0x02a3 c0x0000 (---------------)  + I wiki
	0x002bac43, // n0x02a4 c0x0000 (---------------)  + I zlg
	0x0003c708, // n0x02a5 c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x02a6 c0x0000 (---------------)  + I com
	0x002df843, // n0x02a7 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x02a8 c0x0000 (---------------)  + I gov
	0x00214843, // n0x02a9 c0x0000 (---------------)  + I net
	0x0023e983, // n0x02aa c0x0000 (---------------)  + I org
	0x0020d643, // n0x02ab c0x0000 (---------------)  + I com
	0x002df843, // n0x02ac c0x0000 (---------------)  + I edu
	0x00218d43, // n0x02ad c0x0000 (---------------)  + I gov
	0x00214843, // n0x02ae c0x0000 (---------------)  + I net
	0x0023e983, // n0x02af c0x0000 (---------------)  + I org
	0x0020d642, // n0x02b0 c0x0000 (---------------)  + I co
	0x0023e983, // n0x02b1 c0x0000 (---------------)  + I org
	0x0020d643, // n0x02b2 c0x0000 (---------------)  + I com
	0x00218d43, // n0x02b3 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x02b4 c0x0000 (---------------)  + I mil
	0x00213e42, // n0x02b5 c0x0000 (---------------)  + I of
	0x0020d643, // n0x02b6 c0x0000 (---------------)  + I com
	0x002df843, // n0x02b7 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x02b8 c0x0000 (---------------)  + I gov
	0x00214843, // n0x02b9 c0x0000 (---------------)  + I net
	0x0023e983, // n0x02ba c0x0000 (---------------)  + I org
	0x00203382, // n0x02bb c0x0000 (---------------)  + I ab
	0x00321b02, // n0x02bc c0x0000 (---------------)  + I bc
	0x0003c708, // n0x02bd c0x0000 (---------------)  +   blogspot
	0x0000d642, // n0x02be c0x0000 (---------------)  +   co
	0x002afec2, // n0x02bf c0x0000 (---------------)  + I gc
	0x00209382, // n0x02c0 c0x0000 (---------------)  + I mb
	0x00203742, // n0x02c1 c0x0000 (---------------)  + I nb
	0x00210e42, // n0x02c2 c0x0000 (---------------)  + I nf
	0x0023ba42, // n0x02c3 c0x0000 (---------------)  + I nl
	0x00204b42, // n0x02c4 c0x0000 (---------------)  + I ns
	0x00200242, // n0x02c5 c0x0000 (---------------)  + I nt
	0x00203642, // n0x02c6 c0x0000 (---------------)  + I nu
	0x00202e82, // n0x02c7 c0x0000 (---------------)  + I on
	0x00209242, // n0x02c8 c0x0000 (---------------)  + I pe
	0x00239602, // n0x02c9 c0x0000 (---------------)  + I qc
	0x00202202, // n0x02ca c0x0000 (---------------)  + I sk
	0x0028d3c2, // n0x02cb c0x0000 (---------------)  + I yk
	0x0000ef49, // n0x02cc c0x0000 (---------------)  +   ftpaccess
	0x000f88cb, // n0x02cd c0x0000 (---------------)  +   game-server
	0x000c4f88, // n0x02ce c0x0000 (---------------)  +   myphotos
	0x000edd49, // n0x02cf c0x0000 (---------------)  +   scrapping
	0x00218d43, // n0x02d0 c0x0000 (---------------)  + I gov
	0x0003c708, // n0x02d1 c0x0000 (---------------)  +   blogspot
	0x0003c708, // n0x02d2 c0x0000 (---------------)  +   blogspot
	0x00206c42, // n0x02d3 c0x0000 (---------------)  + I ac
	0x002072c4, // n0x02d4 c0x0000 (---------------)  + I asso
	0x0020d642, // n0x02d5 c0x0000 (---------------)  + I co
	0x0020d643, // n0x02d6 c0x0000 (---------------)  + I com
	0x00207902, // n0x02d7 c0x0000 (---------------)  + I ed
	0x002df843, // n0x02d8 c0x0000 (---------------)  + I edu
	0x00200482, // n0x02d9 c0x0000 (---------------)  + I go
	0x00257384, // n0x02da c0x0000 (---------------)  + I gouv
	0x00217543, // n0x02db c0x0000 (---------------)  + I int
	0x00211042, // n0x02dc c0x0000 (---------------)  + I md
	0x00214843, // n0x02dd c0x0000 (---------------)  + I net
	0x00200a82, // n0x02de c0x0000 (---------------)  + I or
	0x0023e983, // n0x02df c0x0000 (---------------)  + I org
	0x003460c6, // n0x02e0 c0x0000 (---------------)  + I presse
	0x002c8d8f, // n0x02e1 c0x0000 (---------------)  + I xn--aroport-bya
	0x00640643, // n0x02e2 c0x0001 (---------------)  ! I www
	0x0020d642, // n0x02e3 c0x0000 (---------------)  + I co
	0x00265483, // n0x02e4 c0x0000 (---------------)  + I gob
	0x00218d43, // n0x02e5 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x02e6 c0x0000 (---------------)  + I mil
	0x00218d43, // n0x02e7 c0x0000 (---------------)  + I gov
	0x00206c42, // n0x02e8 c0x0000 (---------------)  + I ac
	0x00207a02, // n0x02e9 c0x0000 (---------------)  + I ah
	0x002100c2, // n0x02ea c0x0000 (---------------)  + I bj
	0x0020d643, // n0x02eb c0x0000 (---------------)  + I com
	0x0023e2c2, // n0x02ec c0x0000 (---------------)  + I cq
	0x002df843, // n0x02ed c0x0000 (---------------)  + I edu
	0x0023e182, // n0x02ee c0x0000 (---------------)  + I fj
	0x00205cc2, // n0x02ef c0x0000 (---------------)  + I gd
	0x00218d43, // n0x02f0 c0x0000 (---------------)  + I gov
	0x0023c7c2, // n0x02f1 c0x0000 (---------------)  + I gs
	0x0028ce02, // n0x02f2 c0x0000 (---------------)  + I gx
	0x0028f202, // n0x02f3 c0x0000 (---------------)  + I gz
	0x00201682, // n0x02f4 c0x0000 (---------------)  + I ha
	0x002d7582, // n0x02f5 c0x0000 (---------------)  + I hb
	0x00201e02, // n0x02f6 c0x0000 (---------------)  + I he
	0x00200742, // n0x02f7 c0x0000 (---------------)  + I hi
	0x00215082, // n0x02f8 c0x0000 (---------------)  + I hk
	0x00263882, // n0x02f9 c0x0000 (---------------)  + I hl
	0x0022a882, // n0x02fa c0x0000 (---------------)  + I hn
	0x00311082, // n0x02fb c0x0000 (---------------)  + I jl
	0x00228202, // n0x02fc c0x0000 (---------------)  + I js
	0x002f56c2, // n0x02fd c0x0000 (---------------)  + I jx
	0x00291082, // n0x02fe c0x0000 (---------------)  + I ln
	0x0022f003, // n0x02ff c0x0000 (---------------)  + I mil
	0x00203d42, // n0x0300 c0x0000 (---------------)  + I mo
	0x00214843, // n0x0301 c0x0000 (---------------)  + I net
	0x0020c202, // n0x0302 c0x0000 (---------------)  + I nm
	0x00202d82, // n0x0303 c0x0000 (---------------)  + I nx
	0x0023e983, // n0x0304 c0x0000 (---------------)  + I org
	0x0023e302, // n0x0305 c0x0000 (---------------)  + I qh
	0x00201d82, // n0x0306 c0x0000 (---------------)  + I sc
	0x00203902, // n0x0307 c0x0000 (---------------)  + I sd
	0x00202c42, // n0x0308 c0x0000 (---------------)  + I sh
	0x00222982, // n0x0309 c0x0000 (---------------)  + I sn
	0x002ed302, // n0x030a c0x0000 (---------------)  + I sx
	0x0023ac42, // n0x030b c0x0000 (---------------)  + I tj
	0x0024b942, // n0x030c c0x0000 (---------------)  + I tw
	0x00202dc2, // n0x030d c0x0000 (---------------)  + I xj
	0x0028feca, // n0x030e c0x0000 (---------------)  + I xn--55qx5d
	0x0031014a, // n0x030f c0x0000 (---------------)  + I xn--io0a7i
	0x0032c24a, // n0x0310 c0x0000 (---------------)  + I xn--od0alg
	0x0034ef82, // n0x0311 c0x0000 (---------------)  + I xz
	0x00202302, // n0x0312 c0x0000 (---------------)  + I yn
	0x0028f242, // n0x0313 c0x0000 (---------------)  + I zj
	0x00230884, // n0x0314 c0x0000 (---------------)  + I arts
	0x0020d643, // n0x0315 c0x0000 (---------------)  + I com
	0x002df843, // n0x0316 c0x0000 (---------------)  + I edu
	0x00243504, // n0x0317 c0x0000 (---------------)  + I firm
	0x00218d43, // n0x0318 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x0319 c0x0000 (---------------)  + I info
	0x00217543, // n0x031a c0x0000 (---------------)  + I int
	0x0022f003, // n0x031b c0x0000 (---------------)  + I mil
	0x00214843, // n0x031c c0x0000 (---------------)  + I net
	0x00216583, // n0x031d c0x0000 (---------------)  + I nom
	0x0023e983, // n0x031e c0x0000 (---------------)  + I org
	0x002c1d83, // n0x031f c0x0000 (---------------)  + I rec
	0x00205e43, // n0x0320 c0x0000 (---------------)  + I web
	0x0eac3d89, // n0x0321 c0x003a (n0x03d5-n0x03e9)  o I amazonaws
	0x000337c7, // n0x0322 c0x0000 (---------------)  +   appspot
	0x00000182, // n0x0323 c0x0000 (---------------)  +   ar
	0x0000320a, // n0x0324 c0x0000 (---------------)  +   betainabox
	0x00005c07, // n0x0325 c0x0000 (---------------)  +   blogdns
	0x0003c708, // n0x0326 c0x0000 (---------------)  +   blogspot
	0x00001882, // n0x0327 c0x0000 (---------------)  +   br
	0x00099547, // n0x0328 c0x0000 (---------------)  +   cechire
	0x00031842, // n0x0329 c0x0000 (---------------)  +   cn
	0x00091648, // n0x032a c0x0000 (---------------)  +   codespot
	0x00002602, // n0x032b c0x0000 (---------------)  +   de
	0x000357c8, // n0x032c c0x0000 (---------------)  +   dnsalias
	0x00062ac7, // n0x032d c0x0000 (---------------)  +   dnsdojo
	0x000a33cb, // n0x032e c0x0000 (---------------)  +   doesntexist
	0x00106f09, // n0x032f c0x0000 (---------------)  +   dontexist
	0x000356c7, // n0x0330 c0x0000 (---------------)  +   doomdns
	0x000ed8cc, // n0x0331 c0x0000 (---------------)  +   dreamhosters
	0x000022ca, // n0x0332 c0x0000 (---------------)  +   dyn-o-saur
	0x0000e508, // n0x0333 c0x0000 (---------------)  +   dynalias
	0x00070fce, // n0x0334 c0x0000 (---------------)  +   dyndns-at-home
	0x00004a4e, // n0x0335 c0x0000 (---------------)  +   dyndns-at-work
	0x00005a4b, // n0x0336 c0x0000 (---------------)  +   dyndns-blog
	0x00007dcb, // n0x0337 c0x0000 (---------------)  +   dyndns-free
	0x0000ec8b, // n0x0338 c0x0000 (---------------)  +   dyndns-home
	0x00011089, // n0x0339 c0x0000 (---------------)  +   dyndns-ip
	0x0001284b, // n0x033a c0x0000 (---------------)  +   dyndns-mail
	0x00013c8d, // n0x033b c0x0000 (---------------)  +   dyndns-office
	0x0001874b, // n0x033c c0x0000 (---------------)  +   dyndns-pics
	0x0002028d, // n0x033d c0x0000 (---------------)  +   dyndns-remote
	0x0002128d, // n0x033e c0x0000 (---------------)  +   dyndns-server
	0x0002204a, // n0x033f c0x0000 (---------------)  +   dyndns-web
	0x0002c48b, // n0x0340 c0x0000 (---------------)  +   dyndns-wiki
	0x00103e0b, // n0x0341 c0x0000 (---------------)  +   dyndns-work
	0x0001c450, // n0x0342 c0x0000 (---------------)  +   elasticbeanstalk
	0x00021acf, // n0x0343 c0x0000 (---------------)  +   est-a-la-maison
	0x00053b4f, // n0x0344 c0x0000 (---------------)  +   est-a-la-masion
	0x00041d0d, // n0x0345 c0x0000 (---------------)  +   est-le-patron
	0x000b1810, // n0x0346 c0x0000 (---------------)  +   est-mon-blogueur
	0x0000f402, // n0x0347 c0x0000 (---------------)  +   eu
	0x00050887, // n0x0348 c0x0000 (---------------)  +   from-ak
	0x00051a07, // n0x0349 c0x0000 (---------------)  +   from-al
	0x00051bc7, // n0x034a c0x0000 (---------------)  +   from-ar
	0x000521c7, // n0x034b c0x0000 (---------------)  +   from-ca
	0x000530c7, // n0x034c c0x0000 (---------------)  +   from-ct
	0x000533c7, // n0x034d c0x0000 (---------------)  +   from-dc
	0x000552c7, // n0x034e c0x0000 (---------------)  +   from-de
	0x00055807, // n0x034f c0x0000 (---------------)  +   from-fl
	0x00055dc7, // n0x0350 c0x0000 (---------------)  +   from-ga
	0x000560c7, // n0x0351 c0x0000 (---------------)  +   from-hi
	0x00056907, // n0x0352 c0x0000 (---------------)  +   from-ia
	0x00056ac7, // n0x0353 c0x0000 (---------------)  +   from-id
	0x00056c87, // n0x0354 c0x0000 (---------------)  +   from-il
	0x00056e47, // n0x0355 c0x0000 (---------------)  +   from-in
	0x00057147, // n0x0356 c0x0000 (---------------)  +   from-ks
	0x00058007, // n0x0357 c0x0000 (---------------)  +   from-ky
	0x00059d47, // n0x0358 c0x0000 (---------------)  +   from-ma
	0x0005a587, // n0x0359 c0x0000 (---------------)  +   from-md
	0x0005b147, // n0x035a c0x0000 (---------------)  +   from-mi
	0x0005b5c7, // n0x035b c0x0000 (---------------)  +   from-mn
	0x0005b787, // n0x035c c0x0000 (---------------)  +   from-mo
	0x0005c0c7, // n0x035d c0x0000 (---------------)  +   from-ms
	0x0005c3c7, // n0x035e c0x0000 (---------------)  +   from-mt
	0x0005cc47, // n0x035f c0x0000 (---------------)  +   from-nc
	0x0005e807, // n0x0360 c0x0000 (---------------)  +   from-nd
	0x0005e9c7, // n0x0361 c0x0000 (---------------)  +   from-ne
	0x0005eb87, // n0x0362 c0x0000 (---------------)  +   from-nh
	0x0005f207, // n0x0363 c0x0000 (---------------)  +   from-nj
	0x0005f847, // n0x0364 c0x0000 (---------------)  +   from-nm
	0x0005fd07, // n0x0365 c0x0000 (---------------)  +   from-nv
	0x00060607, // n0x0366 c0x0000 (---------------)  +   from-oh
	0x00060847, // n0x0367 c0x0000 (---------------)  +   from-ok
	0x00060f07, // n0x0368 c0x0000 (---------------)  +   from-or
	0x000611c7, // n0x0369 c0x0000 (---------------)  +   from-pa
	0x00061d87, // n0x036a c0x0000 (---------------)  +   from-pr
	0x00061f87, // n0x036b c0x0000 (---------------)  +   from-ri
	0x000636c7, // n0x036c c0x0000 (---------------)  +   from-sc
	0x00064047, // n0x036d c0x0000 (---------------)  +   from-sd
	0x00064207, // n0x036e c0x0000 (---------------)  +   from-tn
	0x000643c7, // n0x036f c0x0000 (---------------)  +   from-tx
	0x00065cc7, // n0x0370 c0x0000 (---------------)  +   from-ut
	0x00066287, // n0x0371 c0x0000 (---------------)  +   from-va
	0x00066807, // n0x0372 c0x0000 (---------------)  +   from-vt
	0x00066f87, // n0x0373 c0x0000 (---------------)  +   from-wa
	0x00067147, // n0x0374 c0x0000 (---------------)  +   from-wi
	0x000674c7, // n0x0375 c0x0000 (---------------)  +   from-wv
	0x00067947, // n0x0376 c0x0000 (---------------)  +   from-wy
	0x00079382, // n0x0377 c0x0000 (---------------)  +   gb
	0x0003a7c7, // n0x0378 c0x0000 (---------------)  +   getmyip
	0x0008e38a, // n0x0379 c0x0000 (---------------)  +   googleapis
	0x000914ca, // n0x037a c0x0000 (---------------)  +   googlecode
	0x00049846, // n0x037b c0x0000 (---------------)  +   gotdns
	0x00000642, // n0x037c c0x0000 (---------------)  +   gr
	0x0003ef4a, // n0x037d c0x0000 (---------------)  +   hobby-site
	0x0008fcc9, // n0x037e c0x0000 (---------------)  +   homelinux
	0x00090148, // n0x037f c0x0000 (---------------)  +   homeunix
	0x0002b002, // n0x0380 c0x0000 (---------------)  +   hu
	0x00062709, // n0x0381 c0x0000 (---------------)  +   iamallama
	0x0007528e, // n0x0382 c0x0000 (---------------)  +   is-a-anarchist
	0x0000544c, // n0x0383 c0x0000 (---------------)  +   is-a-blogger
	0x000c534f, // n0x0384 c0x0000 (---------------)  +   is-a-bookkeeper
	0x0002090e, // n0x0385 c0x0000 (---------------)  +   is-a-bulls-fan
	0x00104b8c, // n0x0386 c0x0000 (---------------)  +   is-a-caterer
	0x00054949, // n0x0387 c0x0000 (---------------)  +   is-a-chef
	0x0005d9d1, // n0x0388 c0x0000 (---------------)  +   is-a-conservative
	0x00085f88, // n0x0389 c0x0000 (---------------)  +   is-a-cpa
	0x00032452, // n0x038a c0x0000 (---------------)  +   is-a-cubicle-slave
	0x00033f4d, // n0x038b c0x0000 (---------------)  +   is-a-democrat
	0x0004c14d, // n0x038c c0x0000 (---------------)  +   is-a-designer
	0x0004e64b, // n0x038d c0x0000 (---------------)  +   is-a-doctor
	0x00057915, // n0x038e c0x0000 (---------------)  +   is-a-financialadvisor
	0x0005c709, // n0x038f c0x0000 (---------------)  +   is-a-geek
	0x00060c8a, // n0x0390 c0x0000 (---------------)  +   is-a-green
	0x00062d49, // n0x0391 c0x0000 (---------------)  +   is-a-guru
	0x000632d0, // n0x0392 c0x0000 (---------------)  +   is-a-hard-worker
	0x00066ccb, // n0x0393 c0x0000 (---------------)  +   is-a-hunter
	0x0007150f, // n0x0394 c0x0000 (---------------)  +   is-a-landscaper
	0x0007478b, // n0x0395 c0x0000 (---------------)  +   is-a-lawyer
	0x0007660c, // n0x0396 c0x0000 (---------------)  +   is-a-liberal
	0x0007af90, // n0x0397 c0x0000 (---------------)  +   is-a-libertarian
	0x00095b8a, // n0x0398 c0x0000 (---------------)  +   is-a-llama
	0x000b584d, // n0x0399 c0x0000 (---------------)  +   is-a-musician
	0x000ab7ce, // n0x039a c0x0000 (---------------)  +   is-a-nascarfan
	0x000d634a, // n0x039b c0x0000 (---------------)  +   is-a-nurse
	0x000b510c, // n0x039c c0x0000 (---------------)  +   is-a-painter
	0x00099f54, // n0x039d c0x0000 (---------------)  +   is-a-personaltrainer
	0x0009a751, // n0x039e c0x0000 (---------------)  +   is-a-photographer
	0x0009c9cb, // n0x039f c0x0000 (---------------)  +   is-a-player
	0x0009ea0f, // n0x03a0 c0x0000 (---------------)  +   is-a-republican
	0x0009f1cd, // n0x03a1 c0x0000 (---------------)  +   is-a-rockstar
	0x000a4c0e, // n0x03a2 c0x0000 (---------------)  +   is-a-socialist
	0x000a8e4c, // n0x03a3 c0x0000 (---------------)  +   is-a-student
	0x000aaecc, // n0x03a4 c0x0000 (---------------)  +   is-a-teacher
	0x000ab4cb, // n0x03a5 c0x0000 (---------------)  +   is-a-techie
	0x000cc84e, // n0x03a6 c0x0000 (---------------)  +   is-a-therapist
	0x000d3e50, // n0x03a7 c0x0000 (---------------)  +   is-an-accountant
	0x000b268b, // n0x03a8 c0x0000 (---------------)  +   is-an-actor
	0x000b798d, // n0x03a9 c0x0000 (---------------)  +   is-an-actress
	0x000bdb8f, // n0x03aa c0x0000 (---------------)  +   is-an-anarchist
	0x000d320c, // n0x03ab c0x0000 (---------------)  +   is-an-artist
	0x000c5c8e, // n0x03ac c0x0000 (---------------)  +   is-an-engineer
	0x000c6451, // n0x03ad c0x0000 (---------------)  +   is-an-entertainer
	0x000ca58c, // n0x03ae c0x0000 (---------------)  +   is-certified
	0x000d5307, // n0x03af c0x0000 (---------------)  +   is-gone
	0x000d5dcd, // n0x03b0 c0x0000 (---------------)  +   is-into-anime
	0x000d704c, // n0x03b1 c0x0000 (---------------)  +   is-into-cars
	0x000da290, // n0x03b2 c0x0000 (---------------)  +   is-into-cartoons
	0x000dcc4d, // n0x03b3 c0x0000 (---------------)  +   is-into-games
	0x000dd947, // n0x03b4 c0x0000 (---------------)  +   is-leet
	0x000df4d0, // n0x03b5 c0x0000 (---------------)  +   is-not-certified
	0x000eb1c8, // n0x03b6 c0x0000 (---------------)  +   is-slick
	0x000ee2cb, // n0x03b7 c0x0000 (---------------)  +   is-uberleet
	0x0012480f, // n0x03b8 c0x0000 (---------------)  +   is-with-theband
	0x0008e588, // n0x03b9 c0x0000 (---------------)  +   isa-geek
	0x00039a8d, // n0x03ba c0x0000 (---------------)  +   isa-hockeynut
	0x00096250, // n0x03bb c0x0000 (---------------)  +   issmarterthanyou
	0x00097b43, // n0x03bc c0x0000 (---------------)  +   jpn
	0x000015c2, // n0x03bd c0x0000 (---------------)  +   kr
	0x00048109, // n0x03be c0x0000 (---------------)  +   likes-pie
	0x0004a28a, // n0x03bf c0x0000 (---------------)  +   likescandy
	0x0002ed08, // n0x03c0 c0x0000 (---------------)  +   neat-url
	0x000005c2, // n0x03c1 c0x0000 (---------------)  +   no
	0x0003af0a, // n0x03c2 c0x0000 (---------------)  +   operaunite
	0x00039602, // n0x03c3 c0x0000 (---------------)  +   qc
	0x0002f147, // n0x03c4 c0x0000 (---------------)  +   rhcloud
	0x000018c2, // n0x03c5 c0x0000 (---------------)  +   ru
	0x00002442, // n0x03c6 c0x0000 (---------------)  +   sa
	0x000a0850, // n0x03c7 c0x0000 (---------------)  +   saves-the-whales
	0x0000da42, // n0x03c8 c0x0000 (---------------)  +   se
	0x00109ac6, // n0x03c9 c0x0000 (---------------)  +   selfip
	0x00081d8e, // n0x03ca c0x0000 (---------------)  +   sells-for-less
	0x000d654b, // n0x03cb c0x0000 (---------------)  +   sells-for-u
	0x000edb88, // n0x03cc c0x0000 (---------------)  +   servebbs
	0x000e124a, // n0x03cd c0x0000 (---------------)  +   simple-url
	0x000e528d, // n0x03ce c0x0000 (---------------)  +   space-to-rent
	0x0003034c, // n0x03cf c0x0000 (---------------)  +   teaches-yoga
	0x00001902, // n0x03d0 c0x0000 (---------------)  +   uk
	0x00001f42, // n0x03d1 c0x0000 (---------------)  +   us
	0x0001c8c2, // n0x03d2 c0x0000 (---------------)  +   uy
	0x0003c48e, // n0x03d3 c0x0000 (---------------)  +   writesthisblog
	0x00001142, // n0x03d4 c0x0000 (---------------)  +   za
	0x00022703, // n0x03d5 c0x0000 (---------------)  +   elb
	0x00001e82, // n0x03d6 c0x0000 (---------------)  +   s3
	0x000e6351, // n0x03d7 c0x0000 (---------------)  +   s3-ap-northeast-1
	0x0014ce11, // n0x03d8 c0x0000 (---------------)  +   s3-ap-southeast-1
	0x000fde51, // n0x03d9 c0x0000 (---------------)  +   s3-ap-southeast-2
	0x0011a2cc, // n0x03da c0x0000 (---------------)  +   s3-eu-west-1
	0x0012d255, // n0x03db c0x0000 (---------------)  +   s3-fips-us-gov-west-1
	0x0013724c, // n0x03dc c0x0000 (---------------)  +   s3-sa-east-1
	0x001482d0, // n0x03dd c0x0000 (---------------)  +   s3-us-gov-west-1
	0x0014df4c, // n0x03de c0x0000 (---------------)  +   s3-us-west-1
	0x00001e8c, // n0x03df c0x0000 (---------------)  +   s3-us-west-2
	0x00005d99, // n0x03e0 c0x0000 (---------------)  +   s3-website-ap-northeast-1
	0x0000a2d9, // n0x03e1 c0x0000 (---------------)  +   s3-website-ap-southeast-1
	0x0000dc19, // n0x03e2 c0x0000 (---------------)  +   s3-website-ap-southeast-2
	0x0000f154, // n0x03e3 c0x0000 (---------------)  +   s3-website-eu-west-1
	0x00012054, // n0x03e4 c0x0000 (---------------)  +   s3-website-sa-east-1
	0x00012ed4, // n0x03e5 c0x0000 (---------------)  +   s3-website-us-east-1
	0x000189d8, // n0x03e6 c0x0000 (---------------)  +   s3-website-us-gov-west-1
	0x0001ae14, // n0x03e7 c0x0000 (---------------)  +   s3-website-us-west-1
	0x0001edd4, // n0x03e8 c0x0000 (---------------)  +   s3-website-us-west-2
	0x00206c42, // n0x03e9 c0x0000 (---------------)  + I ac
	0x0020d642, // n0x03ea c0x0000 (---------------)  + I co
	0x00207902, // n0x03eb c0x0000 (---------------)  + I ed
	0x0020bc82, // n0x03ec c0x0000 (---------------)  + I fi
	0x00200482, // n0x03ed c0x0000 (---------------)  + I go
	0x00200a82, // n0x03ee c0x0000 (---------------)  + I or
	0x00202442, // n0x03ef c0x0000 (---------------)  + I sa
	0x0020d643, // n0x03f0 c0x0000 (---------------)  + I com
	0x002df843, // n0x03f1 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x03f2 c0x0000 (---------------)  + I gov
	0x00210e03, // n0x03f3 c0x0000 (---------------)  + I inf
	0x00214843, // n0x03f4 c0x0000 (---------------)  + I net
	0x0023e983, // n0x03f5 c0x0000 (---------------)  + I org
	0x0003c708, // n0x03f6 c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x03f7 c0x0000 (---------------)  + I com
	0x002df843, // n0x03f8 c0x0000 (---------------)  + I edu
	0x00214843, // n0x03f9 c0x0000 (---------------)  + I net
	0x0023e983, // n0x03fa c0x0000 (---------------)  + I org
	0x00012e03, // n0x03fb c0x0000 (---------------)  +   ath
	0x00218d43, // n0x03fc c0x0000 (---------------)  + I gov
	0x0003c708, // n0x03fd c0x0000 (---------------)  +   blogspot
	0x0003c708, // n0x03fe c0x0000 (---------------)  +   blogspot
	0x0000d643, // n0x03ff c0x0000 (---------------)  +   com
	0x000de60f, // n0x0400 c0x0000 (---------------)  +   fuettertdasnetz
	0x000a35ca, // n0x0401 c0x0000 (---------------)  +   isteingeek
	0x00107087, // n0x0402 c0x0000 (---------------)  +   istmein
	0x000146ca, // n0x0403 c0x0000 (---------------)  +   lebtimnetz
	0x000b208a, // n0x0404 c0x0000 (---------------)  +   leitungsen
	0x0010a20d, // n0x0405 c0x0000 (---------------)  +   traeumtgerade
	0x0003c708, // n0x0406 c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x0407 c0x0000 (---------------)  + I com
	0x002df843, // n0x0408 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0409 c0x0000 (---------------)  + I gov
	0x00214843, // n0x040a c0x0000 (---------------)  + I net
	0x0023e983, // n0x040b c0x0000 (---------------)  + I org
	0x0020e343, // n0x040c c0x0000 (---------------)  + I art
	0x0020d643, // n0x040d c0x0000 (---------------)  + I com
	0x002df843, // n0x040e c0x0000 (---------------)  + I edu
	0x00265483, // n0x040f c0x0000 (---------------)  + I gob
	0x00218d43, // n0x0410 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0411 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0412 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0413 c0x0000 (---------------)  + I org
	0x002e1643, // n0x0414 c0x0000 (---------------)  + I sld
	0x00205e43, // n0x0415 c0x0000 (---------------)  + I web
	0x0020e343, // n0x0416 c0x0000 (---------------)  + I art
	0x002072c4, // n0x0417 c0x0000 (---------------)  + I asso
	0x0020d643, // n0x0418 c0x0000 (---------------)  + I com
	0x002df843, // n0x0419 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x041a c0x0000 (---------------)  + I gov
	0x00214843, // n0x041b c0x0000 (---------------)  + I net
	0x0023e983, // n0x041c c0x0000 (---------------)  + I org
	0x00205383, // n0x041d c0x0000 (---------------)  + I pol
	0x0020d643, // n0x041e c0x0000 (---------------)  + I com
	0x002df843, // n0x041f c0x0000 (---------------)  + I edu
	0x00242a83, // n0x0420 c0x0000 (---------------)  + I fin
	0x00265483, // n0x0421 c0x0000 (---------------)  + I gob
	0x00218d43, // n0x0422 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x0423 c0x0000 (---------------)  + I info
	0x002316c3, // n0x0424 c0x0000 (---------------)  + I k12
	0x0023dbc3, // n0x0425 c0x0000 (---------------)  + I med
	0x0022f003, // n0x0426 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0427 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0428 c0x0000 (---------------)  + I org
	0x002d1383, // n0x0429 c0x0000 (---------------)  + I pro
	0x0022eb83, // n0x042a c0x0000 (---------------)  + I aip
	0x0020d643, // n0x042b c0x0000 (---------------)  + I com
	0x002df843, // n0x042c c0x0000 (---------------)  + I edu
	0x00241483, // n0x042d c0x0000 (---------------)  + I fie
	0x00218d43, // n0x042e c0x0000 (---------------)  + I gov
	0x0021bec3, // n0x042f c0x0000 (---------------)  + I lib
	0x0023dbc3, // n0x0430 c0x0000 (---------------)  + I med
	0x0023e983, // n0x0431 c0x0000 (---------------)  + I org
	0x002d0383, // n0x0432 c0x0000 (---------------)  + I pri
	0x002102c4, // n0x0433 c0x0000 (---------------)  + I riik
	0x0020d643, // n0x0434 c0x0000 (---------------)  + I com
	0x002df843, // n0x0435 c0x0000 (---------------)  + I edu
	0x00290203, // n0x0436 c0x0000 (---------------)  + I eun
	0x00218d43, // n0x0437 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0438 c0x0000 (---------------)  + I mil
	0x00202f04, // n0x0439 c0x0000 (---------------)  + I name
	0x00214843, // n0x043a c0x0000 (---------------)  + I net
	0x0023e983, // n0x043b c0x0000 (---------------)  + I org
	0x002089c3, // n0x043c c0x0000 (---------------)  + I sci
	0x12a0d643, // n0x043d c0x004a (n0x0442-n0x0443)  + I com
	0x002df843, // n0x043e c0x0000 (---------------)  + I edu
	0x00265483, // n0x043f c0x0000 (---------------)  + I gob
	0x00216583, // n0x0440 c0x0000 (---------------)  + I nom
	0x0023e983, // n0x0441 c0x0000 (---------------)  + I org
	0x0003c708, // n0x0442 c0x0000 (---------------)  +   blogspot
	0x00237705, // n0x0443 c0x0000 (---------------)  + I aland
	0x0003c708, // n0x0444 c0x0000 (---------------)  +   blogspot
	0x0000aec3, // n0x0445 c0x0000 (---------------)  +   iki
	0x0022f708, // n0x0446 c0x0000 (---------------)  + I aeroport
	0x00226d47, // n0x0447 c0x0000 (---------------)  + I assedic
	0x002072c4, // n0x0448 c0x0000 (---------------)  + I asso
	0x002ae3c6, // n0x0449 c0x0000 (---------------)  + I avocat
	0x002e6206, // n0x044a c0x0000 (---------------)  + I avoues
	0x0003c708, // n0x044b c0x0000 (---------------)  +   blogspot
	0x002f9403, // n0x044c c0x0000 (---------------)  + I cci
	0x0020b509, // n0x044d c0x0000 (---------------)  + I chambagri
	0x0029d195, // n0x044e c0x0000 (---------------)  + I chirurgiens-dentistes
	0x0020d643, // n0x044f c0x0000 (---------------)  + I com
	0x0032ce12, // n0x0450 c0x0000 (---------------)  + I experts-comptables
	0x0032cbcf, // n0x0451 c0x0000 (---------------)  + I geometre-expert
	0x00257384, // n0x0452 c0x0000 (---------------)  + I gouv
	0x00328585, // n0x0453 c0x0000 (---------------)  + I greta
	0x00294a10, // n0x0454 c0x0000 (---------------)  + I huissier-justice
	0x002efac7, // n0x0455 c0x0000 (---------------)  + I medecin
	0x00216583, // n0x0456 c0x0000 (---------------)  + I nom
	0x00277b88, // n0x0457 c0x0000 (---------------)  + I notaires
	0x002c70ca, // n0x0458 c0x0000 (---------------)  + I pharmacien
	0x0022f804, // n0x0459 c0x0000 (---------------)  + I port
	0x00261ec3, // n0x045a c0x0000 (---------------)  + I prd
	0x003460c6, // n0x045b c0x0000 (---------------)  + I presse
	0x0023a842, // n0x045c c0x0000 (---------------)  + I tm
	0x002c1b4b, // n0x045d c0x0000 (---------------)  + I veterinaire
	0x0020d643, // n0x045e c0x0000 (---------------)  + I com
	0x002df843, // n0x045f c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0460 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0461 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0462 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0463 c0x0000 (---------------)  + I org
	0x002d36c3, // n0x0464 c0x0000 (---------------)  + I pvt
	0x0020d642, // n0x0465 c0x0000 (---------------)  + I co
	0x00218d43, // n0x0466 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0467 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0468 c0x0000 (---------------)  + I org
	0x00201d83, // n0x0469 c0x0000 (---------------)  + I sch
	0x0020d643, // n0x046a c0x0000 (---------------)  + I com
	0x002df843, // n0x046b c0x0000 (---------------)  + I edu
	0x00218d43, // n0x046c c0x0000 (---------------)  + I gov
	0x0022f003, // n0x046d c0x0000 (---------------)  + I mil
	0x0023e983, // n0x046e c0x0000 (---------------)  + I org
	0x0020d643, // n0x046f c0x0000 (---------------)  + I com
	0x002df843, // n0x0470 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0471 c0x0000 (---------------)  + I gov
	0x0023c1c3, // n0x0472 c0x0000 (---------------)  + I ltd
	0x00249483, // n0x0473 c0x0000 (---------------)  + I mod
	0x0023e983, // n0x0474 c0x0000 (---------------)  + I org
	0x00206c42, // n0x0475 c0x0000 (---------------)  + I ac
	0x0020d643, // n0x0476 c0x0000 (---------------)  + I com
	0x002df843, // n0x0477 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0478 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0479 c0x0000 (---------------)  + I net
	0x0023e983, // n0x047a c0x0000 (---------------)  + I org
	0x002072c4, // n0x047b c0x0000 (---------------)  + I asso
	0x0020d643, // n0x047c c0x0000 (---------------)  + I com
	0x002df843, // n0x047d c0x0000 (---------------)  + I edu
	0x00303304, // n0x047e c0x0000 (---------------)  + I mobi
	0x00214843, // n0x047f c0x0000 (---------------)  + I net
	0x0023e983, // n0x0480 c0x0000 (---------------)  + I org
	0x0003c708, // n0x0481 c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x0482 c0x0000 (---------------)  + I com
	0x002df843, // n0x0483 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0484 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0485 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0486 c0x0000 (---------------)  + I org
	0x0020d643, // n0x0487 c0x0000 (---------------)  + I com
	0x002df843, // n0x0488 c0x0000 (---------------)  + I edu
	0x00265483, // n0x0489 c0x0000 (---------------)  + I gob
	0x002051c3, // n0x048a c0x0000 (---------------)  + I ind
	0x0022f003, // n0x048b c0x0000 (---------------)  + I mil
	0x00214843, // n0x048c c0x0000 (---------------)  + I net
	0x0023e983, // n0x048d c0x0000 (---------------)  + I org
	0x0020d642, // n0x048e c0x0000 (---------------)  + I co
	0x0020d643, // n0x048f c0x0000 (---------------)  + I com
	0x00214843, // n0x0490 c0x0000 (---------------)  + I net
	0x0003c708, // n0x0491 c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x0492 c0x0000 (---------------)  + I com
	0x002df843, // n0x0493 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0494 c0x0000 (---------------)  + I gov
	0x002629c3, // n0x0495 c0x0000 (---------------)  + I idv
	0x00214843, // n0x0496 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0497 c0x0000 (---------------)  + I org
	0x0028feca, // n0x0498 c0x0000 (---------------)  + I xn--55qx5d
	0x002fbdc9, // n0x0499 c0x0000 (---------------)  + I xn--ciqpn
	0x0030784b, // n0x049a c0x0000 (---------------)  + I xn--gmq050i
	0x0030910a, // n0x049b c0x0000 (---------------)  + I xn--gmqw5a
	0x0031014a, // n0x049c c0x0000 (---------------)  + I xn--io0a7i
	0x0031730b, // n0x049d c0x0000 (---------------)  + I xn--lcvr32d
	0x003245ca, // n0x049e c0x0000 (---------------)  + I xn--mk0axi
	0x0032938a, // n0x049f c0x0000 (---------------)  + I xn--mxtq1m
	0x0032c24a, // n0x04a0 c0x0000 (---------------)  + I xn--od0alg
	0x0032c4cb, // n0x04a1 c0x0000 (---------------)  + I xn--od0aq3b
	0x00340949, // n0x04a2 c0x0000 (---------------)  + I xn--tn0ag
	0x00343c0a, // n0x04a3 c0x0000 (---------------)  + I xn--uc0atv
	0x003440cb, // n0x04a4 c0x0000 (---------------)  + I xn--uc0ay4a
	0x00349f0b, // n0x04a5 c0x0000 (---------------)  + I xn--wcvs22d
	0x0034e54a, // n0x04a6 c0x0000 (---------------)  + I xn--zf0avx
	0x0020d643, // n0x04a7 c0x0000 (---------------)  + I com
	0x002df843, // n0x04a8 c0x0000 (---------------)  + I edu
	0x00265483, // n0x04a9 c0x0000 (---------------)  + I gob
	0x0022f003, // n0x04aa c0x0000 (---------------)  + I mil
	0x00214843, // n0x04ab c0x0000 (---------------)  + I net
	0x0023e983, // n0x04ac c0x0000 (---------------)  + I org
	0x0020d643, // n0x04ad c0x0000 (---------------)  + I com
	0x00250884, // n0x04ae c0x0000 (---------------)  + I from
	0x00215942, // n0x04af c0x0000 (---------------)  + I iz
	0x00202f04, // n0x04b0 c0x0000 (---------------)  + I name
	0x00251685, // n0x04b1 c0x0000 (---------------)  + I adult
	0x0020e343, // n0x04b2 c0x0000 (---------------)  + I art
	0x002072c4, // n0x04b3 c0x0000 (---------------)  + I asso
	0x0020d643, // n0x04b4 c0x0000 (---------------)  + I com
	0x0023ae84, // n0x04b5 c0x0000 (---------------)  + I coop
	0x002df843, // n0x04b6 c0x0000 (---------------)  + I edu
	0x00243504, // n0x04b7 c0x0000 (---------------)  + I firm
	0x00257384, // n0x04b8 c0x0000 (---------------)  + I gouv
	0x00210e04, // n0x04b9 c0x0000 (---------------)  + I info
	0x0023dbc3, // n0x04ba c0x0000 (---------------)  + I med
	0x00214843, // n0x04bb c0x0000 (---------------)  + I net
	0x0023e983, // n0x04bc c0x0000 (---------------)  + I org
	0x0029a085, // n0x04bd c0x0000 (---------------)  + I perso
	0x00205383, // n0x04be c0x0000 (---------------)  + I pol
	0x002d1383, // n0x04bf c0x0000 (---------------)  + I pro
	0x00259c43, // n0x04c0 c0x0000 (---------------)  + I rel
	0x003040c4, // n0x04c1 c0x0000 (---------------)  + I shop
	0x00231744, // n0x04c2 c0x0000 (---------------)  + I 2000
	0x00302cc5, // n0x04c3 c0x0000 (---------------)  + I agrar
	0x0003c708, // n0x04c4 c0x0000 (---------------)  +   blogspot
	0x00211884, // n0x04c5 c0x0000 (---------------)  + I bolt
	0x00318c46, // n0x04c6 c0x0000 (---------------)  + I casino
	0x0034a404, // n0x04c7 c0x0000 (---------------)  + I city
	0x0020d642, // n0x04c8 c0x0000 (---------------)  + I co
	0x0029f807, // n0x04c9 c0x0000 (---------------)  + I erotica
	0x002a8787, // n0x04ca c0x0000 (---------------)  + I erotika
	0x00242684, // n0x04cb c0x0000 (---------------)  + I film
	0x0024be05, // n0x04cc c0x0000 (---------------)  + I forum
	0x002dce45, // n0x04cd c0x0000 (---------------)  + I games
	0x002937c5, // n0x04ce c0x0000 (---------------)  + I hotel
	0x00210e04, // n0x04cf c0x0000 (---------------)  + I info
	0x002e7308, // n0x04d0 c0x0000 (---------------)  + I ingatlan
	0x00224e06, // n0x04d1 c0x0000 (---------------)  + I jogasz
	0x002fa288, // n0x04d2 c0x0000 (---------------)  + I konyvelo
	0x0021aa45, // n0x04d3 c0x0000 (---------------)  + I lakas
	0x0023dbc5, // n0x04d4 c0x0000 (---------------)  + I media
	0x00307604, // n0x04d5 c0x0000 (---------------)  + I news
	0x0023e983, // n0x04d6 c0x0000 (---------------)  + I org
	0x002d1204, // n0x04d7 c0x0000 (---------------)  + I priv
	0x0020b886, // n0x04d8 c0x0000 (---------------)  + I reklam
	0x003461c3, // n0x04d9 c0x0000 (---------------)  + I sex
	0x003040c4, // n0x04da c0x0000 (---------------)  + I shop
	0x002d4305, // n0x04db c0x0000 (---------------)  + I sport
	0x00248084, // n0x04dc c0x0000 (---------------)  + I suli
	0x0021bac4, // n0x04dd c0x0000 (---------------)  + I szex
	0x0023a842, // n0x04de c0x0000 (---------------)  + I tm
	0x0027d6c6, // n0x04df c0x0000 (---------------)  + I tozsde
	0x003381c6, // n0x04e0 c0x0000 (---------------)  + I utazas
	0x002ef0c5, // n0x04e1 c0x0000 (---------------)  + I video
	0x00206c42, // n0x04e2 c0x0000 (---------------)  + I ac
	0x0030c243, // n0x04e3 c0x0000 (---------------)  + I biz
	0x0020d642, // n0x04e4 c0x0000 (---------------)  + I co
	0x00200482, // n0x04e5 c0x0000 (---------------)  + I go
	0x0022f003, // n0x04e6 c0x0000 (---------------)  + I mil
	0x0023a882, // n0x04e7 c0x0000 (---------------)  + I my
	0x00214843, // n0x04e8 c0x0000 (---------------)  + I net
	0x00200a82, // n0x04e9 c0x0000 (---------------)  + I or
	0x00201d83, // n0x04ea c0x0000 (---------------)  + I sch
	0x00205e43, // n0x04eb c0x0000 (---------------)  + I web
	0x0003c708, // n0x04ec c0x0000 (---------------)  +   blogspot
	0x00218d43, // n0x04ed c0x0000 (---------------)  + I gov
	0x17a0d642, // n0x04ee c0x005e (n0x04ef-n0x04f0)  o I co
	0x0003c708, // n0x04ef c0x0000 (---------------)  +   blogspot
	0x00206c42, // n0x04f0 c0x0000 (---------------)  + I ac
	0x1820d642, // n0x04f1 c0x0060 (n0x04f6-n0x04f8)  + I co
	0x00218d43, // n0x04f2 c0x0000 (---------------)  + I gov
	0x00214843, // n0x04f3 c0x0000 (---------------)  + I net
	0x00211783, // n0x04f4 c0x0000 (---------------)  + I nic
	0x0023e983, // n0x04f5 c0x0000 (---------------)  + I org
	0x0023c1c3, // n0x04f6 c0x0000 (---------------)  + I ltd
	0x002cd4c3, // n0x04f7 c0x0000 (---------------)  + I plc
	0x00206c42, // n0x04f8 c0x0000 (---------------)  + I ac
	0x0003c708, // n0x04f9 c0x0000 (---------------)  +   blogspot
	0x0020d642, // n0x04fa c0x0000 (---------------)  + I co
	0x002df843, // n0x04fb c0x0000 (---------------)  + I edu
	0x00243504, // n0x04fc c0x0000 (---------------)  + I firm
	0x0020b183, // n0x04fd c0x0000 (---------------)  + I gen
	0x00218d43, // n0x04fe c0x0000 (---------------)  + I gov
	0x002051c3, // n0x04ff c0x0000 (---------------)  + I ind
	0x0022f003, // n0x0500 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0501 c0x0000 (---------------)  + I net
	0x00211783, // n0x0502 c0x0000 (---------------)  + I nic
	0x0023e983, // n0x0503 c0x0000 (---------------)  + I org
	0x0021a643, // n0x0504 c0x0000 (---------------)  + I res
	0x00126c53, // n0x0505 c0x0000 (---------------)  +   barrel-of-knowledge
	0x0012c754, // n0x0506 c0x0000 (---------------)  +   barrell-of-knowledge
	0x00004a46, // n0x0507 c0x0000 (---------------)  +   dyndns
	0x00047787, // n0x0508 c0x0000 (---------------)  +   for-our
	0x00029309, // n0x0509 c0x0000 (---------------)  +   groks-the
	0x0004898a, // n0x050a c0x0000 (---------------)  +   groks-this
	0x0011f6cd, // n0x050b c0x0000 (---------------)  +   here-for-more
	0x000be4ca, // n0x050c c0x0000 (---------------)  +   knowsitall
	0x00109ac6, // n0x050d c0x0000 (---------------)  +   selfip
	0x000141c6, // n0x050e c0x0000 (---------------)  +   webhop
	0x0020f402, // n0x050f c0x0000 (---------------)  + I eu
	0x0020d643, // n0x0510 c0x0000 (---------------)  + I com
	0x000ad5c6, // n0x0511 c0x0000 (---------------)  +   github
	0x0020d643, // n0x0512 c0x0000 (---------------)  + I com
	0x002df843, // n0x0513 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0514 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0515 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0516 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0517 c0x0000 (---------------)  + I org
	0x00206c42, // n0x0518 c0x0000 (---------------)  + I ac
	0x0020d642, // n0x0519 c0x0000 (---------------)  + I co
	0x00218d43, // n0x051a c0x0000 (---------------)  + I gov
	0x00202282, // n0x051b c0x0000 (---------------)  + I id
	0x00214843, // n0x051c c0x0000 (---------------)  + I net
	0x0023e983, // n0x051d c0x0000 (---------------)  + I org
	0x00201d83, // n0x051e c0x0000 (---------------)  + I sch
	0x0032018f, // n0x051f c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0032054e, // n0x0520 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x0020d643, // n0x0521 c0x0000 (---------------)  + I com
	0x002df843, // n0x0522 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0523 c0x0000 (---------------)  + I gov
	0x00217543, // n0x0524 c0x0000 (---------------)  + I int
	0x00214843, // n0x0525 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0526 c0x0000 (---------------)  + I org
	0x002082c2, // n0x0527 c0x0000 (---------------)  + I ag
	0x00340b09, // n0x0528 c0x0000 (---------------)  + I agrigento
	0x00203982, // n0x0529 c0x0000 (---------------)  + I al
	0x002a0b4b, // n0x052a c0x0000 (---------------)  + I alessandria
	0x002b0cca, // n0x052b c0x0000 (---------------)  + I alto-adige
	0x002366c9, // n0x052c c0x0000 (---------------)  + I altoadige
	0x00200202, // n0x052d c0x0000 (---------------)  + I an
	0x00341dc6, // n0x052e c0x0000 (---------------)  + I ancona
	0x002930d5, // n0x052f c0x0000 (---------------)  + I andria-barletta-trani
	0x002a0c95, // n0x0530 c0x0000 (---------------)  + I andria-trani-barletta
	0x002943d3, // n0x0531 c0x0000 (---------------)  + I andriabarlettatrani
	0x002a1213, // n0x0532 c0x0000 (---------------)  + I andriatranibarletta
	0x0020aa02, // n0x0533 c0x0000 (---------------)  + I ao
	0x002289c5, // n0x0534 c0x0000 (---------------)  + I aosta
	0x002b0905, // n0x0535 c0x0000 (---------------)  + I aoste
	0x002006c2, // n0x0536 c0x0000 (---------------)  + I ap
	0x00271b82, // n0x0537 c0x0000 (---------------)  + I aq
	0x002b8a86, // n0x0538 c0x0000 (---------------)  + I aquila
	0x00200182, // n0x0539 c0x0000 (---------------)  + I ar
	0x00335e46, // n0x053a c0x0000 (---------------)  + I arezzo
	0x0020e68d, // n0x053b c0x0000 (---------------)  + I ascoli-piceno
	0x0023594c, // n0x053c c0x0000 (---------------)  + I ascolipiceno
	0x0021c4c4, // n0x053d c0x0000 (---------------)  + I asti
	0x00201042, // n0x053e c0x0000 (---------------)  + I at
	0x0020be82, // n0x053f c0x0000 (---------------)  + I av
	0x002ddb48, // n0x0540 c0x0000 (---------------)  + I avellino
	0x00201542, // n0x0541 c0x0000 (---------------)  + I ba
	0x002ad706, // n0x0542 c0x0000 (---------------)  + I balsan
	0x00218004, // n0x0543 c0x0000 (---------------)  + I bari
	0x00293295, // n0x0544 c0x0000 (---------------)  + I barletta-trani-andria
	0x00294553, // n0x0545 c0x0000 (---------------)  + I barlettatraniandria
	0x00233547, // n0x0546 c0x0000 (---------------)  + I belluno
	0x002594c9, // n0x0547 c0x0000 (---------------)  + I benevento
	0x00236ec7, // n0x0548 c0x0000 (---------------)  + I bergamo
	0x0033aa82, // n0x0549 c0x0000 (---------------)  + I bg
	0x00205742, // n0x054a c0x0000 (---------------)  + I bi
	0x002063c6, // n0x054b c0x0000 (---------------)  + I biella
	0x00205582, // n0x054c c0x0000 (---------------)  + I bl
	0x0003c708, // n0x054d c0x0000 (---------------)  +   blogspot
	0x00252802, // n0x054e c0x0000 (---------------)  + I bn
	0x002033c2, // n0x054f c0x0000 (---------------)  + I bo
	0x002f0e07, // n0x0550 c0x0000 (---------------)  + I bologna
	0x00212547, // n0x0551 c0x0000 (---------------)  + I bolzano
	0x00218fc5, // n0x0552 c0x0000 (---------------)  + I bozen
	0x00201882, // n0x0553 c0x0000 (---------------)  + I br
	0x0021a607, // n0x0554 c0x0000 (---------------)  + I brescia
	0x0021a7c8, // n0x0555 c0x0000 (---------------)  + I brindisi
	0x00205ec2, // n0x0556 c0x0000 (---------------)  + I bs
	0x00214742, // n0x0557 c0x0000 (---------------)  + I bt
	0x0022c342, // n0x0558 c0x0000 (---------------)  + I bz
	0x00201002, // n0x0559 c0x0000 (---------------)  + I ca
	0x002aff08, // n0x055a c0x0000 (---------------)  + I cagliari
	0x00247bcd, // n0x055b c0x0000 (---------------)  + I caltanissetta
	0x0025aa0f, // n0x055c c0x0000 (---------------)  + I campidano-medio
	0x0025adce, // n0x055d c0x0000 (---------------)  + I campidanomedio
	0x0020714a, // n0x055e c0x0000 (---------------)  + I campobasso
	0x0029f951, // n0x055f c0x0000 (---------------)  + I carbonia-iglesias
	0x0029fdd0, // n0x0560 c0x0000 (---------------)  + I carboniaiglesias
	0x002b924d, // n0x0561 c0x0000 (---------------)  + I carrara-massa
	0x002b958c, // n0x0562 c0x0000 (---------------)  + I carraramassa
	0x00226ec7, // n0x0563 c0x0000 (---------------)  + I caserta
	0x002ae487, // n0x0564 c0x0000 (---------------)  + I catania
	0x00201009, // n0x0565 c0x0000 (---------------)  + I catanzaro
	0x0021c5c2, // n0x0566 c0x0000 (---------------)  + I cb
	0x00200502, // n0x0567 c0x0000 (---------------)  + I ce
	0x00249d4c, // n0x0568 c0x0000 (---------------)  + I cesena-forli
	0x0024a04b, // n0x0569 c0x0000 (---------------)  + I cesenaforli
	0x002007c2, // n0x056a c0x0000 (---------------)  + I ch
	0x002ab686, // n0x056b c0x0000 (---------------)  + I chieti
	0x00208a02, // n0x056c c0x0000 (---------------)  + I ci
	0x002278c2, // n0x056d c0x0000 (---------------)  + I cl
	0x00231842, // n0x056e c0x0000 (---------------)  + I cn
	0x0020d642, // n0x056f c0x0000 (---------------)  + I co
	0x0020d644, // n0x0570 c0x0000 (---------------)  + I como
	0x0023d1c7, // n0x0571 c0x0000 (---------------)  + I cosenza
	0x00234182, // n0x0572 c0x0000 (---------------)  + I cr
	0x0023fec7, // n0x0573 c0x0000 (---------------)  + I cremona
	0x00240887, // n0x0574 c0x0000 (---------------)  + I crotone
	0x00218982, // n0x0575 c0x0000 (---------------)  + I cs
	0x00234a42, // n0x0576 c0x0000 (---------------)  + I ct
	0x00240dc5, // n0x0577 c0x0000 (---------------)  + I cuneo
	0x00206a42, // n0x0578 c0x0000 (---------------)  + I cz
	0x0024b24e, // n0x0579 c0x0000 (---------------)  + I dell-ogliastra
	0x0025540d, // n0x057a c0x0000 (---------------)  + I dellogliastra
	0x002df843, // n0x057b c0x0000 (---------------)  + I edu
	0x00204882, // n0x057c c0x0000 (---------------)  + I en
	0x00258804, // n0x057d c0x0000 (---------------)  + I enna
	0x0030a802, // n0x057e c0x0000 (---------------)  + I fc
	0x0022bf82, // n0x057f c0x0000 (---------------)  + I fe
	0x002cc045, // n0x0580 c0x0000 (---------------)  + I fermo
	0x002d1947, // n0x0581 c0x0000 (---------------)  + I ferrara
	0x00328542, // n0x0582 c0x0000 (---------------)  + I fg
	0x0020bc82, // n0x0583 c0x0000 (---------------)  + I fi
	0x00243347, // n0x0584 c0x0000 (---------------)  + I firenze
	0x00246508, // n0x0585 c0x0000 (---------------)  + I florence
	0x00330b82, // n0x0586 c0x0000 (---------------)  + I fm
	0x00210e86, // n0x0587 c0x0000 (---------------)  + I foggia
	0x00249bcc, // n0x0588 c0x0000 (---------------)  + I forli-cesena
	0x00249f0b, // n0x0589 c0x0000 (---------------)  + I forlicesena
	0x00207f82, // n0x058a c0x0000 (---------------)  + I fr
	0x00267b09, // n0x058b c0x0000 (---------------)  + I frosinone
	0x00204902, // n0x058c c0x0000 (---------------)  + I ge
	0x0020f9c5, // n0x058d c0x0000 (---------------)  + I genoa
	0x00215f86, // n0x058e c0x0000 (---------------)  + I genova
	0x00200482, // n0x058f c0x0000 (---------------)  + I go
	0x002bed47, // n0x0590 c0x0000 (---------------)  + I gorizia
	0x00218d43, // n0x0591 c0x0000 (---------------)  + I gov
	0x00200642, // n0x0592 c0x0000 (---------------)  + I gr
	0x0024e048, // n0x0593 c0x0000 (---------------)  + I grosseto
	0x0029fb91, // n0x0594 c0x0000 (---------------)  + I iglesias-carbonia
	0x0029ffd0, // n0x0595 c0x0000 (---------------)  + I iglesiascarbonia
	0x00202cc2, // n0x0596 c0x0000 (---------------)  + I im
	0x00210787, // n0x0597 c0x0000 (---------------)  + I imperia
	0x00200842, // n0x0598 c0x0000 (---------------)  + I is
	0x002428c7, // n0x0599 c0x0000 (---------------)  + I isernia
	0x002015c2, // n0x059a c0x0000 (---------------)  + I kr
	0x00225009, // n0x059b c0x0000 (---------------)  + I la-spezia
	0x002b8a47, // n0x059c c0x0000 (---------------)  + I laquila
	0x00262588, // n0x059d c0x0000 (---------------)  + I laspezia
	0x002249c6, // n0x059e c0x0000 (---------------)  + I latina
	0x00240c02, // n0x059f c0x0000 (---------------)  + I lc
	0x00205902, // n0x05a0 c0x0000 (---------------)  + I le
	0x002067c5, // n0x05a1 c0x0000 (---------------)  + I lecce
	0x00214a85, // n0x05a2 c0x0000 (---------------)  + I lecco
	0x002039c2, // n0x05a3 c0x0000 (---------------)  + I li
	0x002039c7, // n0x05a4 c0x0000 (---------------)  + I livorno
	0x002055c2, // n0x05a5 c0x0000 (---------------)  + I lo
	0x0024ac84, // n0x05a6 c0x0000 (---------------)  + I lodi
	0x0020b7c2, // n0x05a7 c0x0000 (---------------)  + I lt
	0x00204982, // n0x05a8 c0x0000 (---------------)  + I lu
	0x00304285, // n0x05a9 c0x0000 (---------------)  + I lucca
	0x002f9b48, // n0x05aa c0x0000 (---------------)  + I macerata
	0x0028de07, // n0x05ab c0x0000 (---------------)  + I mantova
	0x002b90cd, // n0x05ac c0x0000 (---------------)  + I massa-carrara
	0x002b944c, // n0x05ad c0x0000 (---------------)  + I massacarrara
	0x0029e206, // n0x05ae c0x0000 (---------------)  + I matera
	0x00209382, // n0x05af c0x0000 (---------------)  + I mb
	0x002d8982, // n0x05b0 c0x0000 (---------------)  + I mc
	0x00202f82, // n0x05b1 c0x0000 (---------------)  + I me
	0x0025a88f, // n0x05b2 c0x0000 (---------------)  + I medio-campidano
	0x0025ac8e, // n0x05b3 c0x0000 (---------------)  + I mediocampidano
	0x00204007, // n0x05b4 c0x0000 (---------------)  + I messina
	0x00206702, // n0x05b5 c0x0000 (---------------)  + I mi
	0x00311985, // n0x05b6 c0x0000 (---------------)  + I milan
	0x00311986, // n0x05b7 c0x0000 (---------------)  + I milano
	0x00201702, // n0x05b8 c0x0000 (---------------)  + I mn
	0x00203d42, // n0x05b9 c0x0000 (---------------)  + I mo
	0x00287146, // n0x05ba c0x0000 (---------------)  + I modena
	0x002b60c5, // n0x05bb c0x0000 (---------------)  + I monza
	0x002b60cd, // n0x05bc c0x0000 (---------------)  + I monza-brianza
	0x002b6415, // n0x05bd c0x0000 (---------------)  + I monza-e-della-brianza
	0x002b694c, // n0x05be c0x0000 (---------------)  + I monzabrianza
	0x002b6c4d, // n0x05bf c0x0000 (---------------)  + I monzaebrianza
	0x002b6f92, // n0x05c0 c0x0000 (---------------)  + I monzaedellabrianza
	0x00201342, // n0x05c1 c0x0000 (---------------)  + I ms
	0x0025c502, // n0x05c2 c0x0000 (---------------)  + I mt
	0x00200982, // n0x05c3 c0x0000 (---------------)  + I na
	0x002f8646, // n0x05c4 c0x0000 (---------------)  + I naples
	0x00205306, // n0x05c5 c0x0000 (---------------)  + I napoli
	0x002005c2, // n0x05c6 c0x0000 (---------------)  + I no
	0x00216006, // n0x05c7 c0x0000 (---------------)  + I novara
	0x00203642, // n0x05c8 c0x0000 (---------------)  + I nu
	0x00276e45, // n0x05c9 c0x0000 (---------------)  + I nuoro
	0x00200602, // n0x05ca c0x0000 (---------------)  + I og
	0x0024b389, // n0x05cb c0x0000 (---------------)  + I ogliastra
	0x0029844c, // n0x05cc c0x0000 (---------------)  + I olbia-tempio
	0x0029878b, // n0x05cd c0x0000 (---------------)  + I olbiatempio
	0x00200a82, // n0x05ce c0x0000 (---------------)  + I or
	0x002c0088, // n0x05cf c0x0000 (---------------)  + I oristano
	0x00200382, // n0x05d0 c0x0000 (---------------)  + I ot
	0x0020d002, // n0x05d1 c0x0000 (---------------)  + I pa
	0x002114c6, // n0x05d2 c0x0000 (---------------)  + I padova
	0x003214c5, // n0x05d3 c0x0000 (---------------)  + I padua
	0x002854c7, // n0x05d4 c0x0000 (---------------)  + I palermo
	0x002f2845, // n0x05d5 c0x0000 (---------------)  + I parma
	0x002c6dc5, // n0x05d6 c0x0000 (---------------)  + I pavia
	0x002dca02, // n0x05d7 c0x0000 (---------------)  + I pc
	0x003041c2, // n0x05d8 c0x0000 (---------------)  + I pd
	0x00209242, // n0x05d9 c0x0000 (---------------)  + I pe
	0x00271807, // n0x05da c0x0000 (---------------)  + I perugia
	0x002d050d, // n0x05db c0x0000 (---------------)  + I pesaro-urbino
	0x002d088c, // n0x05dc c0x0000 (---------------)  + I pesarourbino
	0x002c6f07, // n0x05dd c0x0000 (---------------)  + I pescara
	0x00224042, // n0x05de c0x0000 (---------------)  + I pg
	0x0020e842, // n0x05df c0x0000 (---------------)  + I pi
	0x00258d88, // n0x05e0 c0x0000 (---------------)  + I piacenza
	0x0028e544, // n0x05e1 c0x0000 (---------------)  + I pisa
	0x002ccac7, // n0x05e2 c0x0000 (---------------)  + I pistoia
	0x002371c2, // n0x05e3 c0x0000 (---------------)  + I pn
	0x00200a42, // n0x05e4 c0x0000 (---------------)  + I po
	0x002cf209, // n0x05e5 c0x0000 (---------------)  + I pordenone
	0x002338c7, // n0x05e6 c0x0000 (---------------)  + I potenza
	0x00261ec2, // n0x05e7 c0x0000 (---------------)  + I pr
	0x0031bc45, // n0x05e8 c0x0000 (---------------)  + I prato
	0x00211c02, // n0x05e9 c0x0000 (---------------)  + I pt
	0x00203f42, // n0x05ea c0x0000 (---------------)  + I pu
	0x002d36c2, // n0x05eb c0x0000 (---------------)  + I pv
	0x002d3982, // n0x05ec c0x0000 (---------------)  + I pz
	0x002001c2, // n0x05ed c0x0000 (---------------)  + I ra
	0x00230746, // n0x05ee c0x0000 (---------------)  + I ragusa
	0x0030b487, // n0x05ef c0x0000 (---------------)  + I ravenna
	0x00240d82, // n0x05f0 c0x0000 (---------------)  + I rc
	0x00201602, // n0x05f1 c0x0000 (---------------)  + I re
	0x002ba58f, // n0x05f2 c0x0000 (---------------)  + I reggio-calabria
	0x00308dcd, // n0x05f3 c0x0000 (---------------)  + I reggio-emilia
	0x0023d70e, // n0x05f4 c0x0000 (---------------)  + I reggiocalabria
	0x00246d8c, // n0x05f5 c0x0000 (---------------)  + I reggioemilia
	0x00203802, // n0x05f6 c0x0000 (---------------)  + I rg
	0x00201d02, // n0x05f7 c0x0000 (---------------)  + I ri
	0x00222f45, // n0x05f8 c0x0000 (---------------)  + I rieti
	0x002d7986, // n0x05f9 c0x0000 (---------------)  + I rimini
	0x00201302, // n0x05fa c0x0000 (---------------)  + I rm
	0x00200082, // n0x05fb c0x0000 (---------------)  + I rn
	0x00200ac2, // n0x05fc c0x0000 (---------------)  + I ro
	0x0029bd84, // n0x05fd c0x0000 (---------------)  + I roma
	0x00299244, // n0x05fe c0x0000 (---------------)  + I rome
	0x0020ce86, // n0x05ff c0x0000 (---------------)  + I rovigo
	0x00202442, // n0x0600 c0x0000 (---------------)  + I sa
	0x002a7e47, // n0x0601 c0x0000 (---------------)  + I salerno
	0x002d61c7, // n0x0602 c0x0000 (---------------)  + I sassari
	0x002f47c6, // n0x0603 c0x0000 (---------------)  + I savona
	0x002040c2, // n0x0604 c0x0000 (---------------)  + I si
	0x002d2685, // n0x0605 c0x0000 (---------------)  + I siena
	0x00265e88, // n0x0606 c0x0000 (---------------)  + I siracusa
	0x00200882, // n0x0607 c0x0000 (---------------)  + I so
	0x00331d87, // n0x0608 c0x0000 (---------------)  + I sondrio
	0x002250c2, // n0x0609 c0x0000 (---------------)  + I sp
	0x002ba542, // n0x060a c0x0000 (---------------)  + I sr
	0x00204082, // n0x060b c0x0000 (---------------)  + I ss
	0x00302a49, // n0x060c c0x0000 (---------------)  + I suedtirol
	0x00206602, // n0x060d c0x0000 (---------------)  + I sv
	0x00200142, // n0x060e c0x0000 (---------------)  + I ta
	0x00200147, // n0x060f c0x0000 (---------------)  + I taranto
	0x002013c2, // n0x0610 c0x0000 (---------------)  + I te
	0x002985cc, // n0x0611 c0x0000 (---------------)  + I tempio-olbia
	0x002988cb, // n0x0612 c0x0000 (---------------)  + I tempioolbia
	0x0029e286, // n0x0613 c0x0000 (---------------)  + I teramo
	0x002e4c85, // n0x0614 c0x0000 (---------------)  + I terni
	0x00203602, // n0x0615 c0x0000 (---------------)  + I tn
	0x00200282, // n0x0616 c0x0000 (---------------)  + I to
	0x002a3ac6, // n0x0617 c0x0000 (---------------)  + I torino
	0x0020c382, // n0x0618 c0x0000 (---------------)  + I tp
	0x00208d82, // n0x0619 c0x0000 (---------------)  + I tr
	0x00292f55, // n0x061a c0x0000 (---------------)  + I trani-andria-barletta
	0x002a0e55, // n0x061b c0x0000 (---------------)  + I trani-barletta-andria
	0x00294293, // n0x061c c0x0000 (---------------)  + I traniandriabarletta
	0x002a1393, // n0x061d c0x0000 (---------------)  + I tranibarlettaandria
	0x002d4407, // n0x061e c0x0000 (---------------)  + I trapani
	0x00348f08, // n0x061f c0x0000 (---------------)  + I trentino
	0x002b3bc6, // n0x0620 c0x0000 (---------------)  + I trento
	0x002b8887, // n0x0621 c0x0000 (---------------)  + I treviso
	0x002c1747, // n0x0622 c0x0000 (---------------)  + I trieste
	0x00202a82, // n0x0623 c0x0000 (---------------)  + I ts
	0x0029db45, // n0x0624 c0x0000 (---------------)  + I turin
	0x00281802, // n0x0625 c0x0000 (---------------)  + I tv
	0x00207b82, // n0x0626 c0x0000 (---------------)  + I ud
	0x002bf6c5, // n0x0627 c0x0000 (---------------)  + I udine
	0x002d06cd, // n0x0628 c0x0000 (---------------)  + I urbino-pesaro
	0x002d0a0c, // n0x0629 c0x0000 (---------------)  + I urbinopesaro
	0x00206f02, // n0x062a c0x0000 (---------------)  + I va
	0x002cea46, // n0x062b c0x0000 (---------------)  + I varese
	0x00224902, // n0x062c c0x0000 (---------------)  + I vb
	0x0023f542, // n0x062d c0x0000 (---------------)  + I vc
	0x00209c42, // n0x062e c0x0000 (---------------)  + I ve
	0x0028d507, // n0x062f c0x0000 (---------------)  + I venezia
	0x00211706, // n0x0630 c0x0000 (---------------)  + I venice
	0x00221508, // n0x0631 c0x0000 (---------------)  + I verbania
	0x002f8ac8, // n0x0632 c0x0000 (---------------)  + I vercelli
	0x0027abc6, // n0x0633 c0x0000 (---------------)  + I verona
	0x00209542, // n0x0634 c0x0000 (---------------)  + I vi
	0x002eea8d, // n0x0635 c0x0000 (---------------)  + I vibo-valentia
	0x002eedcc, // n0x0636 c0x0000 (---------------)  + I vibovalentia
	0x00257447, // n0x0637 c0x0000 (---------------)  + I vicenza
	0x002f0cc7, // n0x0638 c0x0000 (---------------)  + I viterbo
	0x00212b82, // n0x0639 c0x0000 (---------------)  + I vr
	0x00260182, // n0x063a c0x0000 (---------------)  + I vs
	0x00237882, // n0x063b c0x0000 (---------------)  + I vt
	0x00215382, // n0x063c c0x0000 (---------------)  + I vv
	0x0020d642, // n0x063d c0x0000 (---------------)  + I co
	0x00218d43, // n0x063e c0x0000 (---------------)  + I gov
	0x00214843, // n0x063f c0x0000 (---------------)  + I net
	0x0023e983, // n0x0640 c0x0000 (---------------)  + I org
	0x00201d83, // n0x0641 c0x0000 (---------------)  + I sch
	0x0020d643, // n0x0642 c0x0000 (---------------)  + I com
	0x002df843, // n0x0643 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0644 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0645 c0x0000 (---------------)  + I mil
	0x00202f04, // n0x0646 c0x0000 (---------------)  + I name
	0x00214843, // n0x0647 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0648 c0x0000 (---------------)  + I org
	0x00201d83, // n0x0649 c0x0000 (---------------)  + I sch
	0x00206c42, // n0x064a c0x0000 (---------------)  + I ac
	0x00201442, // n0x064b c0x0000 (---------------)  + I ad
	0x1b27c385, // n0x064c c0x006c (n0x068a-n0x06bf)  + I aichi
	0x1b61de05, // n0x064d c0x006d (n0x06bf-n0x06db)  + I akita
	0x1bab1246, // n0x064e c0x006e (n0x06db-n0x06f1)  + I aomori
	0x0003c708, // n0x064f c0x0000 (---------------)  +   blogspot
	0x1bea4405, // n0x0650 c0x006f (n0x06f1-n0x072b)  + I chiba
	0x0020d642, // n0x0651 c0x0000 (---------------)  + I co
	0x00207902, // n0x0652 c0x0000 (---------------)  + I ed
	0x1c30ca45, // n0x0653 c0x0070 (n0x072b-n0x0741)  + I ehime
	0x1c66cdc5, // n0x0654 c0x0071 (n0x0741-n0x0750)  + I fukui
	0x1ca6d707, // n0x0655 c0x0072 (n0x0750-n0x078f)  + I fukuoka
	0x1ce39289, // n0x0656 c0x0073 (n0x078f-n0x07c2)  + I fukushima
	0x1d33dc04, // n0x0657 c0x0074 (n0x07c2-n0x07e8)  + I gifu
	0x00200482, // n0x0658 c0x0000 (---------------)  + I go
	0x00200642, // n0x0659 c0x0000 (---------------)  + I gr
	0x1d65c945, // n0x065a c0x0075 (n0x07e8-n0x080c)  + I gunma
	0x1da7ba09, // n0x065b c0x0076 (n0x080c-n0x0825)  + I hiroshima
	0x1dee04c8, // n0x065c c0x0077 (n0x0825-n0x08b3)  + I hokkaido
	0x1e2ca405, // n0x065d c0x0078 (n0x08b3-n0x08e1)  + I hyogo
	0x1e727887, // n0x065e c0x0079 (n0x08e1-n0x0914)  + I ibaraki
	0x1ea6c948, // n0x065f c0x007a (n0x0914-n0x0927)  + I ishikawa
	0x1ee97345, // n0x0660 c0x007b (n0x0927-n0x094a)  + I iwate
	0x1f208506, // n0x0661 c0x007c (n0x094a-n0x0959)  + I kagawa
	0x1f6fd949, // n0x0662 c0x007d (n0x0959-n0x096d)  + I kagoshima
	0x1fa6cbc8, // n0x0663 c0x007e (n0x096d-n0x098b)  + I kanagawa
	0x1fea8c88, // n0x0664 c0x007f (n0x098b-n0x098c)* o I kawasaki
	0x2027e88a, // n0x0665 c0x0080 (n0x098c-n0x098d)* o I kitakyushu
	0x2064d504, // n0x0666 c0x0081 (n0x098d-n0x098e)* o I kobe
	0x20abef85, // n0x0667 c0x0082 (n0x098e-n0x09ad)  + I kochi
	0x20e5d348, // n0x0668 c0x0083 (n0x09ad-n0x09c7)  + I kumamoto
	0x21258145, // n0x0669 c0x0084 (n0x09c7-n0x09e6)  + I kyoto
	0x00216382, // n0x066a c0x0000 (---------------)  + I lg
	0x21606703, // n0x066b c0x0085 (n0x09e6-n0x0a04)  + I mie
	0x21a8d8c6, // n0x066c c0x0086 (n0x0a04-n0x0a25)  + I miyagi
	0x21e66b08, // n0x066d c0x0087 (n0x0a25-n0x0a40)  + I miyazaki
	0x223082c6, // n0x066e c0x0088 (n0x0a40-n0x0a8b)  + I nagano
	0x226f0f48, // n0x066f c0x0089 (n0x0a8b-n0x0aa1)  + I nagasaki
	0x22a08286, // n0x0670 c0x008a (n0x0aa1-n0x0aa2)* o I nagoya
	0x22f208c4, // n0x0671 c0x008b (n0x0aa2-n0x0ac8)  + I nara
	0x00203e82, // n0x0672 c0x0000 (---------------)  + I ne
	0x2328db47, // n0x0673 c0x008c (n0x0ac8-n0x0aea)  + I niigata
	0x236d8744, // n0x0674 c0x008d (n0x0aea-n0x0afd)  + I oita
	0x23a69a87, // n0x0675 c0x008e (n0x0afd-n0x0b17)  + I okayama
	0x23f08547, // n0x0676 c0x008f (n0x0b17-n0x0b41)  + I okinawa
	0x00200a82, // n0x0677 c0x0000 (---------------)  + I or
	0x24282e05, // n0x0678 c0x0090 (n0x0b41-n0x0b73)  + I osaka
	0x24662184, // n0x0679 c0x0091 (n0x0b73-n0x0b8d)  + I saga
	0x24aaab87, // n0x067a c0x0092 (n0x0b8d-n0x0bd2)  + I saitama
	0x24e80387, // n0x067b c0x0093 (n0x0bd2-n0x0bd3)* o I sapporo
	0x25270206, // n0x067c c0x0094 (n0x0bd3-n0x0bd4)* o I sendai
	0x25650d45, // n0x067d c0x0095 (n0x0bd4-n0x0beb)  + I shiga
	0x25a7dd07, // n0x067e c0x0096 (n0x0beb-n0x0c02)  + I shimane
	0x25ee0188, // n0x067f c0x0097 (n0x0c02-n0x0c26)  + I shizuoka
	0x2633dac7, // n0x0680 c0x0098 (n0x0c26-n0x0c45)  + I tochigi
	0x266daac9, // n0x0681 c0x0099 (n0x0c45-n0x0c56)  + I tokushima
	0x26a00285, // n0x0682 c0x009a (n0x0c56-n0x0c8f)  + I tokyo
	0x26f1bd07, // n0x0683 c0x009b (n0x0c8f-n0x0c9c)  + I tottori
	0x2725d4c6, // n0x0684 c0x009c (n0x0c9c-n0x0cb4)  + I toyama
	0x27741b08, // n0x0685 c0x009d (n0x0cb4-n0x0cd1)  + I wakayama
	0x27a6ee08, // n0x0686 c0x009e (n0x0cd1-n0x0cf3)  + I yamagata
	0x27e735c9, // n0x0687 c0x009f (n0x0cf3-n0x0d03)  + I yamaguchi
	0x28248c49, // n0x0688 c0x00a0 (n0x0d03-n0x0d1f)  + I yamanashi
	0x286bc808, // n0x0689 c0x00a1 (n0x0d1f-n0x0d20)* o I yokohama
	0x002a5385, // n0x068a c0x0000 (---------------)  + I aisai
	0x00204603, // n0x068b c0x0000 (---------------)  + I ama
	0x0025bc84, // n0x068c c0x0000 (---------------)  + I anjo
	0x00304605, // n0x068d c0x0000 (---------------)  + I asuke
	0x002850c6, // n0x068e c0x0000 (---------------)  + I chiryu
	0x0028a285, // n0x068f c0x0000 (---------------)  + I chita
	0x00272e44, // n0x0690 c0x0000 (---------------)  + I fuso
	0x002bec48, // n0x0691 c0x0000 (---------------)  + I gamagori
	0x002aa685, // n0x0692 c0x0000 (---------------)  + I handa
	0x0027d344, // n0x0693 c0x0000 (---------------)  + I hazu
	0x0025eec7, // n0x0694 c0x0000 (---------------)  + I hekinan
	0x00286a8a, // n0x0695 c0x0000 (---------------)  + I higashiura
	0x0029994a, // n0x0696 c0x0000 (---------------)  + I ichinomiya
	0x00275747, // n0x0697 c0x0000 (---------------)  + I inazawa
	0x0021d7c7, // n0x0698 c0x0000 (---------------)  + I inuyama
	0x00332787, // n0x0699 c0x0000 (---------------)  + I isshiki
	0x00237cc7, // n0x069a c0x0000 (---------------)  + I iwakura
	0x002dc8c5, // n0x069b c0x0000 (---------------)  + I kanie
	0x00228286, // n0x069c c0x0000 (---------------)  + I kariya
	0x00254107, // n0x069d c0x0000 (---------------)  + I kasugai
	0x00256804, // n0x069e c0x0000 (---------------)  + I kira
	0x0029b646, // n0x069f c0x0000 (---------------)  + I kiyosu
	0x002b4fc6, // n0x06a0 c0x0000 (---------------)  + I komaki
	0x002e69c5, // n0x06a1 c0x0000 (---------------)  + I konan
	0x00324004, // n0x06a2 c0x0000 (---------------)  + I kota
	0x0028ee06, // n0x06a3 c0x0000 (---------------)  + I mihama
	0x00284707, // n0x06a4 c0x0000 (---------------)  + I miyoshi
	0x002e8a48, // n0x06a5 c0x0000 (---------------)  + I nagakute
	0x0022dc86, // n0x06a6 c0x0000 (---------------)  + I nishio
	0x00238e87, // n0x06a7 c0x0000 (---------------)  + I nisshin
	0x0027d183, // n0x06a8 c0x0000 (---------------)  + I obu
	0x00277046, // n0x06a9 c0x0000 (---------------)  + I oguchi
	0x00285245, // n0x06aa c0x0000 (---------------)  + I oharu
	0x0026d807, // n0x06ab c0x0000 (---------------)  + I okazaki
	0x002ad10a, // n0x06ac c0x0000 (---------------)  + I owariasahi
	0x0024e144, // n0x06ad c0x0000 (---------------)  + I seto
	0x00254688, // n0x06ae c0x0000 (---------------)  + I shikatsu
	0x002da789, // n0x06af c0x0000 (---------------)  + I shinshiro
	0x002de9c7, // n0x06b0 c0x0000 (---------------)  + I shitara
	0x0022c986, // n0x06b1 c0x0000 (---------------)  + I tahara
	0x0028dc88, // n0x06b2 c0x0000 (---------------)  + I takahama
	0x00235fc9, // n0x06b3 c0x0000 (---------------)  + I tobishima
	0x00252a44, // n0x06b4 c0x0000 (---------------)  + I toei
	0x00260a44, // n0x06b5 c0x0000 (---------------)  + I togo
	0x002f2085, // n0x06b6 c0x0000 (---------------)  + I tokai
	0x002df088, // n0x06b7 c0x0000 (---------------)  + I tokoname
	0x002b2fc7, // n0x06b8 c0x0000 (---------------)  + I toyoake
	0x002d9989, // n0x06b9 c0x0000 (---------------)  + I toyohashi
	0x0024a7c8, // n0x06ba c0x0000 (---------------)  + I toyokawa
	0x00251786, // n0x06bb c0x0000 (---------------)  + I toyone
	0x0025c546, // n0x06bc c0x0000 (---------------)  + I toyota
	0x00280788, // n0x06bd c0x0000 (---------------)  + I tsushima
	0x003136c6, // n0x06be c0x0000 (---------------)  + I yatomi
	0x0021de05, // n0x06bf c0x0000 (---------------)  + I akita
	0x002702c6, // n0x06c0 c0x0000 (---------------)  + I daisen
	0x0026a148, // n0x06c1 c0x0000 (---------------)  + I fujisato
	0x002ef9c6, // n0x06c2 c0x0000 (---------------)  + I gojome
	0x002b440b, // n0x06c3 c0x0000 (---------------)  + I hachirogata
	0x00278d86, // n0x06c4 c0x0000 (---------------)  + I happou
	0x00281acd, // n0x06c5 c0x0000 (---------------)  + I higashinaruse
	0x00224605, // n0x06c6 c0x0000 (---------------)  + I honjo
	0x00291986, // n0x06c7 c0x0000 (---------------)  + I honjyo
	0x00203045, // n0x06c8 c0x0000 (---------------)  + I ikawa
	0x00243c09, // n0x06c9 c0x0000 (---------------)  + I kamikoani
	0x00245947, // n0x06ca c0x0000 (---------------)  + I kamioka
	0x002bd388, // n0x06cb c0x0000 (---------------)  + I katagami
	0x0032fc86, // n0x06cc c0x0000 (---------------)  + I kazuno
	0x00280f09, // n0x06cd c0x0000 (---------------)  + I kitaakita
	0x00298fc6, // n0x06ce c0x0000 (---------------)  + I kosaka
	0x002ad085, // n0x06cf c0x0000 (---------------)  + I kyowa
	0x00235ec6, // n0x06d0 c0x0000 (---------------)  + I misato
	0x00310b46, // n0x06d1 c0x0000 (---------------)  + I mitane
	0x002b7e89, // n0x06d2 c0x0000 (---------------)  + I moriyoshi
	0x00252846, // n0x06d3 c0x0000 (---------------)  + I nikaho
	0x00259f47, // n0x06d4 c0x0000 (---------------)  + I noshiro
	0x0025a445, // n0x06d5 c0x0000 (---------------)  + I odate
	0x0020aa43, // n0x06d6 c0x0000 (---------------)  + I oga
	0x002a7fc5, // n0x06d7 c0x0000 (---------------)  + I ogata
	0x0025d207, // n0x06d8 c0x0000 (---------------)  + I semboku
	0x002bd6c6, // n0x06d9 c0x0000 (---------------)  + I yokote
	0x00224509, // n0x06da c0x0000 (---------------)  + I yurihonjo
	0x002b1246, // n0x06db c0x0000 (---------------)  + I aomori
	0x00260ac6, // n0x06dc c0x0000 (---------------)  + I gonohe
	0x0025ed09, // n0x06dd c0x0000 (---------------)  + I hachinohe
	0x0026fcc9, // n0x06de c0x0000 (---------------)  + I hashikami
	0x0028b7c7, // n0x06df c0x0000 (---------------)  + I hiranai
	0x00228608, // n0x06e0 c0x0000 (---------------)  + I hirosaki
	0x002d5bc9, // n0x06e1 c0x0000 (---------------)  + I itayanagi
	0x0026dcc8, // n0x06e2 c0x0000 (---------------)  + I kuroishi
	0x002e42c6, // n0x06e3 c0x0000 (---------------)  + I misawa
	0x002c4d45, // n0x06e4 c0x0000 (---------------)  + I mutsu
	0x0021c18a, // n0x06e5 c0x0000 (---------------)  + I nakadomari
	0x00260b46, // n0x06e6 c0x0000 (---------------)  + I noheji
	0x002f1286, // n0x06e7 c0x0000 (---------------)  + I oirase
	0x0028da85, // n0x06e8 c0x0000 (---------------)  + I owani
	0x00246988, // n0x06e9 c0x0000 (---------------)  + I rokunohe
	0x00263ac7, // n0x06ea c0x0000 (---------------)  + I sannohe
	0x00347a0a, // n0x06eb c0x0000 (---------------)  + I shichinohe
	0x00238f46, // n0x06ec c0x0000 (---------------)  + I shingo
	0x0022b4c5, // n0x06ed c0x0000 (---------------)  + I takko
	0x002c0c86, // n0x06ee c0x0000 (---------------)  + I towada
	0x0029b2c7, // n0x06ef c0x0000 (---------------)  + I tsugaru
	0x0022c847, // n0x06f0 c0x0000 (---------------)  + I tsuruta
	0x002caa05, // n0x06f1 c0x0000 (---------------)  + I abiko
	0x002ad245, // n0x06f2 c0x0000 (---------------)  + I asahi
	0x002cd546, // n0x06f3 c0x0000 (---------------)  + I chonan
	0x00302686, // n0x06f4 c0x0000 (---------------)  + I chosei
	0x00305106, // n0x06f5 c0x0000 (---------------)  + I choshi
	0x0022afc4, // n0x06f6 c0x0000 (---------------)  + I chuo
	0x0026f249, // n0x06f7 c0x0000 (---------------)  + I funabashi
	0x00273a06, // n0x06f8 c0x0000 (---------------)  + I futtsu
	0x0024b60a, // n0x06f9 c0x0000 (---------------)  + I hanamigawa
	0x0027c3c8, // n0x06fa c0x0000 (---------------)  + I ichihara
	0x00235cc8, // n0x06fb c0x0000 (---------------)  + I ichikawa
	0x0029994a, // n0x06fc c0x0000 (---------------)  + I ichinomiya
	0x0033f2c5, // n0x06fd c0x0000 (---------------)  + I inzai
	0x00284645, // n0x06fe c0x0000 (---------------)  + I isumi
	0x0030c3c8, // n0x06ff c0x0000 (---------------)  + I kamagaya
	0x00230c88, // n0x0700 c0x0000 (---------------)  + I kamogawa
	0x00210387, // n0x0701 c0x0000 (---------------)  + I kashiwa
	0x002df386, // n0x0702 c0x0000 (---------------)  + I katori
	0x002f6488, // n0x0703 c0x0000 (---------------)  + I katsuura
	0x002d4847, // n0x0704 c0x0000 (---------------)  + I kimitsu
	0x0026ea08, // n0x0705 c0x0000 (---------------)  + I kisarazu
	0x0029f086, // n0x0706 c0x0000 (---------------)  + I kozaki
	0x00249088, // n0x0707 c0x0000 (---------------)  + I kujukuri
	0x00217cc6, // n0x0708 c0x0000 (---------------)  + I kyonan
	0x0021abc7, // n0x0709 c0x0000 (---------------)  + I matsudo
	0x0025b286, // n0x070a c0x0000 (---------------)  + I midori
	0x0028ee06, // n0x070b c0x0000 (---------------)  + I mihama
	0x003137ca, // n0x070c c0x0000 (---------------)  + I minamiboso
	0x002cc106, // n0x070d c0x0000 (---------------)  + I mobara
	0x002c4d49, // n0x070e c0x0000 (---------------)  + I mutsuzawa
	0x0030b386, // n0x070f c0x0000 (---------------)  + I nagara
	0x0030b5ca, // n0x0710 c0x0000 (---------------)  + I nagareyama
	0x003208c9, // n0x0711 c0x0000 (---------------)  + I narashino
	0x00332406, // n0x0712 c0x0000 (---------------)  + I narita
	0x0022a104, // n0x0713 c0x0000 (---------------)  + I noda
	0x0020fa8d, // n0x0714 c0x0000 (---------------)  + I oamishirasato
	0x00273847, // n0x0715 c0x0000 (---------------)  + I omigawa
	0x002f98c6, // n0x0716 c0x0000 (---------------)  + I onjuku
	0x002a8b45, // n0x0717 c0x0000 (---------------)  + I otaki
	0x00299045, // n0x0718 c0x0000 (---------------)  + I sakae
	0x00223586, // n0x0719 c0x0000 (---------------)  + I sakura
	0x002dee09, // n0x071a c0x0000 (---------------)  + I shimofusa
	0x002dc447, // n0x071b c0x0000 (---------------)  + I shirako
	0x0026a746, // n0x071c c0x0000 (---------------)  + I shiroi
	0x002de486, // n0x071d c0x0000 (---------------)  + I shisui
	0x002bb6c9, // n0x071e c0x0000 (---------------)  + I sodegaura
	0x00328a44, // n0x071f c0x0000 (---------------)  + I sosa
	0x00295684, // n0x0720 c0x0000 (---------------)  + I tako
	0x002550c8, // n0x0721 c0x0000 (---------------)  + I tateyama
	0x00292286, // n0x0722 c0x0000 (---------------)  + I togane
	0x002d9188, // n0x0723 c0x0000 (---------------)  + I tohnosho
	0x002f8088, // n0x0724 c0x0000 (---------------)  + I tomisato
	0x002f1c47, // n0x0725 c0x0000 (---------------)  + I urayasu
	0x00250e89, // n0x0726 c0x0000 (---------------)  + I yachimata
	0x00206c07, // n0x0727 c0x0000 (---------------)  + I yachiyo
	0x002a42ca, // n0x0728 c0x0000 (---------------)  + I yokaichiba
	0x002e388f, // n0x0729 c0x0000 (---------------)  + I yokoshibahikari
	0x0026d1ca, // n0x072a c0x0000 (---------------)  + I yotsukaido
	0x00222d45, // n0x072b c0x0000 (---------------)  + I ainan
	0x0022eac5, // n0x072c c0x0000 (---------------)  + I honai
	0x00253fc5, // n0x072d c0x0000 (---------------)  + I ikata
	0x00217f47, // n0x072e c0x0000 (---------------)  + I imabari
	0x00206d03, // n0x072f c0x0000 (---------------)  + I iyo
	0x00228808, // n0x0730 c0x0000 (---------------)  + I kamijima
	0x0020af06, // n0x0731 c0x0000 (---------------)  + I kihoku
	0x0020b009, // n0x0732 c0x0000 (---------------)  + I kumakogen
	0x002f1a46, // n0x0733 c0x0000 (---------------)  + I masaki
	0x00272687, // n0x0734 c0x0000 (---------------)  + I matsuno
	0x00280cc9, // n0x0735 c0x0000 (---------------)  + I matsuyama
	0x002bd288, // n0x0736 c0x0000 (---------------)  + I namikata
	0x00243dc7, // n0x0737 c0x0000 (---------------)  + I niihama
	0x0022b083, // n0x0738 c0x0000 (---------------)  + I ozu
	0x002a5405, // n0x0739 c0x0000 (---------------)  + I saijo
	0x002e37c5, // n0x073a c0x0000 (---------------)  + I seiyo
	0x003037cb, // n0x073b c0x0000 (---------------)  + I shikokuchuo
	0x00258204, // n0x073c c0x0000 (---------------)  + I tobe
	0x002da544, // n0x073d c0x0000 (---------------)  + I toon
	0x00269146, // n0x073e c0x0000 (---------------)  + I uchiko
	0x002a6207, // n0x073f c0x0000 (---------------)  + I uwajima
	0x0032e30a, // n0x0740 c0x0000 (---------------)  + I yawatahama
	0x00322cc7, // n0x0741 c0x0000 (---------------)  + I echizen
	0x002b56c7, // n0x0742 c0x0000 (---------------)  + I eiheiji
	0x0026cdc5, // n0x0743 c0x0000 (---------------)  + I fukui
	0x00244305, // n0x0744 c0x0000 (---------------)  + I ikeda
	0x00303589, // n0x0745 c0x0000 (---------------)  + I katsuyama
	0x0028ee06, // n0x0746 c0x0000 (---------------)  + I mihama
	0x00322b4d, // n0x0747 c0x0000 (---------------)  + I minamiechizen
	0x00308905, // n0x0748 c0x0000 (---------------)  + I obama
	0x00280503, // n0x0749 c0x0000 (---------------)  + I ohi
	0x00216743, // n0x074a c0x0000 (---------------)  + I ono
	0x00228cc5, // n0x074b c0x0000 (---------------)  + I sabae
	0x00306385, // n0x074c c0x0000 (---------------)  + I sakai
	0x0028dc88, // n0x074d c0x0000 (---------------)  + I takahama
	0x00202a87, // n0x074e c0x0000 (---------------)  + I tsuruga
	0x00295406, // n0x074f c0x0000 (---------------)  + I wakasa
	0x00287786, // n0x0750 c0x0000 (---------------)  + I ashiya
	0x002b9885, // n0x0751 c0x0000 (---------------)  + I buzen
	0x002ef887, // n0x0752 c0x0000 (---------------)  + I chikugo
	0x0021da47, // n0x0753 c0x0000 (---------------)  + I chikuho
	0x00342187, // n0x0754 c0x0000 (---------------)  + I chikujo
	0x0025850a, // n0x0755 c0x0000 (---------------)  + I chikushino
	0x00277108, // n0x0756 c0x0000 (---------------)  + I chikuzen
	0x0022afc4, // n0x0757 c0x0000 (---------------)  + I chuo
	0x002a3047, // n0x0758 c0x0000 (---------------)  + I dazaifu
	0x0026be87, // n0x0759 c0x0000 (---------------)  + I fukuchi
	0x0032bc86, // n0x075a c0x0000 (---------------)  + I hakata
	0x00256207, // n0x075b c0x0000 (---------------)  + I higashi
	0x002a29c8, // n0x075c c0x0000 (---------------)  + I hirokawa
	0x00248b48, // n0x075d c0x0000 (---------------)  + I hisayama
	0x00243706, // n0x075e c0x0000 (---------------)  + I iizuka
	0x00204108, // n0x075f c0x0000 (---------------)  + I inatsuki
	0x002528c4, // n0x0760 c0x0000 (---------------)  + I kaho
	0x00254106, // n0x0761 c0x0000 (---------------)  + I kasuga
	0x0021c806, // n0x0762 c0x0000 (---------------)  + I kasuya
	0x003329c6, // n0x0763 c0x0000 (---------------)  + I kawara
	0x00299bc6, // n0x0764 c0x0000 (---------------)  + I keisen
	0x0027ae04, // n0x0765 c0x0000 (---------------)  + I koga
	0x00237d86, // n0x0766 c0x0000 (---------------)  + I kurate
	0x002a7086, // n0x0767 c0x0000 (---------------)  + I kurogi
	0x0027fe06, // n0x0768 c0x0000 (---------------)  + I kurume
	0x00232146, // n0x0769 c0x0000 (---------------)  + I minami
	0x00216606, // n0x076a c0x0000 (---------------)  + I miyako
	0x002a2806, // n0x076b c0x0000 (---------------)  + I miyama
	0x00295308, // n0x076c c0x0000 (---------------)  + I miyawaka
	0x0029a588, // n0x076d c0x0000 (---------------)  + I mizumaki
	0x002c2008, // n0x076e c0x0000 (---------------)  + I munakata
	0x0028a488, // n0x076f c0x0000 (---------------)  + I nakagawa
	0x0030c346, // n0x0770 c0x0000 (---------------)  + I nakama
	0x0021a0c5, // n0x0771 c0x0000 (---------------)  + I nishi
	0x002a7f86, // n0x0772 c0x0000 (---------------)  + I nogata
	0x002ca485, // n0x0773 c0x0000 (---------------)  + I ogori
	0x0024d307, // n0x0774 c0x0000 (---------------)  + I okagaki
	0x0024a885, // n0x0775 c0x0000 (---------------)  + I okawa
	0x002597c3, // n0x0776 c0x0000 (---------------)  + I oki
	0x00210b85, // n0x0777 c0x0000 (---------------)  + I omuta
	0x0024cd84, // n0x0778 c0x0000 (---------------)  + I onga
	0x00216745, // n0x0779 c0x0000 (---------------)  + I onojo
	0x00203d83, // n0x077a c0x0000 (---------------)  + I oto
	0x00298e07, // n0x077b c0x0000 (---------------)  + I saigawa
	0x002d3c88, // n0x077c c0x0000 (---------------)  + I sasaguri
	0x002d8086, // n0x077d c0x0000 (---------------)  + I shingu
	0x002db10d, // n0x077e c0x0000 (---------------)  + I shinyoshitomi
	0x0022ea86, // n0x077f c0x0000 (---------------)  + I shonai
	0x0027f245, // n0x0780 c0x0000 (---------------)  + I soeda
	0x002e2583, // n0x0781 c0x0000 (---------------)  + I sue
	0x002a51c9, // n0x0782 c0x0000 (---------------)  + I tachiarai
	0x002b4a06, // n0x0783 c0x0000 (---------------)  + I tagawa
	0x0027e2c6, // n0x0784 c0x0000 (---------------)  + I takata
	0x0031f244, // n0x0785 c0x0000 (---------------)  + I toho
	0x0026d147, // n0x0786 c0x0000 (---------------)  + I toyotsu
	0x00222306, // n0x0787 c0x0000 (---------------)  + I tsuiki
	0x0026e185, // n0x0788 c0x0000 (---------------)  + I ukiha
	0x002158c3, // n0x0789 c0x0000 (---------------)  + I umi
	0x0025d0c4, // n0x078a c0x0000 (---------------)  + I usui
	0x0026c046, // n0x078b c0x0000 (---------------)  + I yamada
	0x00228384, // n0x078c c0x0000 (---------------)  + I yame
	0x0021c908, // n0x078d c0x0000 (---------------)  + I yanagawa
	0x00219689, // n0x078e c0x0000 (---------------)  + I yukuhashi
	0x00319809, // n0x078f c0x0000 (---------------)  + I aizubange
	0x0028aaca, // n0x0790 c0x0000 (---------------)  + I aizumisato
	0x002968cd, // n0x0791 c0x0000 (---------------)  + I aizuwakamatsu
	0x002adb87, // n0x0792 c0x0000 (---------------)  + I asakawa
	0x00307386, // n0x0793 c0x0000 (---------------)  + I bandai
	0x002232c4, // n0x0794 c0x0000 (---------------)  + I date
	0x00239289, // n0x0795 c0x0000 (---------------)  + I fukushima
	0x00272848, // n0x0796 c0x0000 (---------------)  + I furudono
	0x00273446, // n0x0797 c0x0000 (---------------)  + I futaba
	0x00247606, // n0x0798 c0x0000 (---------------)  + I hanawa
	0x00256207, // n0x0799 c0x0000 (---------------)  + I higashi
	0x002dd686, // n0x079a c0x0000 (---------------)  + I hirata
	0x00323146, // n0x079b c0x0000 (---------------)  + I hirono
	0x00347786, // n0x079c c0x0000 (---------------)  + I iitate
	0x003085ca, // n0x079d c0x0000 (---------------)  + I inawashiro
	0x0026c948, // n0x079e c0x0000 (---------------)  + I ishikawa
	0x00233e45, // n0x079f c0x0000 (---------------)  + I iwaki
	0x00256649, // n0x07a0 c0x0000 (---------------)  + I izumizaki
	0x0029d74a, // n0x07a1 c0x0000 (---------------)  + I kagamiishi
	0x002db488, // n0x07a2 c0x0000 (---------------)  + I kaneyama
	0x00283808, // n0x07a3 c0x0000 (---------------)  + I kawamata
	0x0027e248, // n0x07a4 c0x0000 (---------------)  + I kitakata
	0x0021de4c, // n0x07a5 c0x0000 (---------------)  + I kitashiobara
	0x0031c605, // n0x07a6 c0x0000 (---------------)  + I koori
	0x00287a08, // n0x07a7 c0x0000 (---------------)  + I koriyama
	0x00311886, // n0x07a8 c0x0000 (---------------)  + I kunimi
	0x0032ee46, // n0x07a9 c0x0000 (---------------)  + I miharu
	0x002b1c07, // n0x07aa c0x0000 (---------------)  + I mishima
	0x00322bc5, // n0x07ab c0x0000 (---------------)  + I namie
	0x002cd605, // n0x07ac c0x0000 (---------------)  + I nango
	0x003196c9, // n0x07ad c0x0000 (---------------)  + I nishiaizu
	0x0021fb47, // n0x07ae c0x0000 (---------------)  + I nishigo
	0x0020afc5, // n0x07af c0x0000 (---------------)  + I okuma
	0x0022cfc7, // n0x07b0 c0x0000 (---------------)  + I omotego
	0x00216743, // n0x07b1 c0x0000 (---------------)  + I ono
	0x002b3505, // n0x07b2 c0x0000 (---------------)  + I otama
	0x002461c8, // n0x07b3 c0x0000 (---------------)  + I samegawa
	0x00327e07, // n0x07b4 c0x0000 (---------------)  + I shimogo
	0x002836c9, // n0x07b5 c0x0000 (---------------)  + I shirakawa
	0x002d92c5, // n0x07b6 c0x0000 (---------------)  + I showa
	0x002e1dc4, // n0x07b7 c0x0000 (---------------)  + I soma
	0x0028c348, // n0x07b8 c0x0000 (---------------)  + I sukagawa
	0x00227007, // n0x07b9 c0x0000 (---------------)  + I taishin
	0x00243f88, // n0x07ba c0x0000 (---------------)  + I tamakawa
	0x00232d48, // n0x07bb c0x0000 (---------------)  + I tanagura
	0x0020bfc5, // n0x07bc c0x0000 (---------------)  + I tenei
	0x0022adc6, // n0x07bd c0x0000 (---------------)  + I yabuki
	0x00245c86, // n0x07be c0x0000 (---------------)  + I yamato
	0x00347589, // n0x07bf c0x0000 (---------------)  + I yamatsuri
	0x002dbd47, // n0x07c0 c0x0000 (---------------)  + I yanaizu
	0x00296046, // n0x07c1 c0x0000 (---------------)  + I yugawa
	0x00211cc7, // n0x07c2 c0x0000 (---------------)  + I anpachi
	0x00209283, // n0x07c3 c0x0000 (---------------)  + I ena
	0x0033dc04, // n0x07c4 c0x0000 (---------------)  + I gifu
	0x002205c5, // n0x07c5 c0x0000 (---------------)  + I ginan
	0x00304404, // n0x07c6 c0x0000 (---------------)  + I godo
	0x002cf804, // n0x07c7 c0x0000 (---------------)  + I gujo
	0x002b4747, // n0x07c8 c0x0000 (---------------)  + I hashima
	0x00200747, // n0x07c9 c0x0000 (---------------)  + I hichiso
	0x0026a904, // n0x07ca c0x0000 (---------------)  + I hida
	0x00283510, // n0x07cb c0x0000 (---------------)  + I higashishirakawa
	0x00225d07, // n0x07cc c0x0000 (---------------)  + I ibigawa
	0x00244305, // n0x07cd c0x0000 (---------------)  + I ikeda
	0x0033de8c, // n0x07ce c0x0000 (---------------)  + I kakamigahara
	0x00207784, // n0x07cf c0x0000 (---------------)  + I kani
	0x002daf08, // n0x07d0 c0x0000 (---------------)  + I kasahara
	0x0021aac9, // n0x07d1 c0x0000 (---------------)  + I kasamatsu
	0x00203086, // n0x07d2 c0x0000 (---------------)  + I kawaue
	0x00328b48, // n0x07d3 c0x0000 (---------------)  + I kitagata
	0x0021fe44, // n0x07d4 c0x0000 (---------------)  + I mino
	0x0021fe48, // n0x07d5 c0x0000 (---------------)  + I minokamo
	0x002b2946, // n0x07d6 c0x0000 (---------------)  + I mitake
	0x00231fc8, // n0x07d7 c0x0000 (---------------)  + I mizunami
	0x00284cc6, // n0x07d8 c0x0000 (---------------)  + I motosu
	0x002f48cb, // n0x07d9 c0x0000 (---------------)  + I nakatsugawa
	0x0020aa45, // n0x07da c0x0000 (---------------)  + I ogaki
	0x0029e848, // n0x07db c0x0000 (---------------)  + I sakahogi
	0x00215e04, // n0x07dc c0x0000 (---------------)  + I seki
	0x00219aca, // n0x07dd c0x0000 (---------------)  + I sekigahara
	0x002836c9, // n0x07de c0x0000 (---------------)  + I shirakawa
	0x0026ef86, // n0x07df c0x0000 (---------------)  + I tajimi
	0x002e3dc8, // n0x07e0 c0x0000 (---------------)  + I takayama
	0x0024e545, // n0x07e1 c0x0000 (---------------)  + I tarui
	0x0034b644, // n0x07e2 c0x0000 (---------------)  + I toki
	0x002dae06, // n0x07e3 c0x0000 (---------------)  + I tomika
	0x002583c8, // n0x07e4 c0x0000 (---------------)  + I wanouchi
	0x0026ee08, // n0x07e5 c0x0000 (---------------)  + I yamagata
	0x002c90c6, // n0x07e6 c0x0000 (---------------)  + I yaotsu
	0x00210ac4, // n0x07e7 c0x0000 (---------------)  + I yoro
	0x0021c106, // n0x07e8 c0x0000 (---------------)  + I annaka
	0x00206c87, // n0x07e9 c0x0000 (---------------)  + I chiyoda
	0x00269987, // n0x07ea c0x0000 (---------------)  + I fujioka
	0x0025620f, // n0x07eb c0x0000 (---------------)  + I higashiagatsuma
	0x0032ea87, // n0x07ec c0x0000 (---------------)  + I isesaki
	0x003324c7, // n0x07ed c0x0000 (---------------)  + I itakura
	0x002e0305, // n0x07ee c0x0000 (---------------)  + I kanna
	0x00255c85, // n0x07ef c0x0000 (---------------)  + I kanra
	0x0028b489, // n0x07f0 c0x0000 (---------------)  + I katashina
	0x002511c6, // n0x07f1 c0x0000 (---------------)  + I kawaba
	0x0026df45, // n0x07f2 c0x0000 (---------------)  + I kiryu
	0x0026ffc7, // n0x07f3 c0x0000 (---------------)  + I kusatsu
	0x0025d708, // n0x07f4 c0x0000 (---------------)  + I maebashi
	0x00272545, // n0x07f5 c0x0000 (---------------)  + I meiwa
	0x0025b286, // n0x07f6 c0x0000 (---------------)  + I midori
	0x00238a48, // n0x07f7 c0x0000 (---------------)  + I minakami
	0x003082ca, // n0x07f8 c0x0000 (---------------)  + I naganohara
	0x0020cbc8, // n0x07f9 c0x0000 (---------------)  + I nakanojo
	0x002773c7, // n0x07fa c0x0000 (---------------)  + I nanmoku
	0x002e3cc6, // n0x07fb c0x0000 (---------------)  + I numata
	0x00256606, // n0x07fc c0x0000 (---------------)  + I oizumi
	0x00214c03, // n0x07fd c0x0000 (---------------)  + I ora
	0x00200383, // n0x07fe c0x0000 (---------------)  + I ota
	0x003051c9, // n0x07ff c0x0000 (---------------)  + I shibukawa
	0x002d5a49, // n0x0800 c0x0000 (---------------)  + I shimonita
	0x002da9c6, // n0x0801 c0x0000 (---------------)  + I shinto
	0x002d92c5, // n0x0802 c0x0000 (---------------)  + I showa
	0x00204388, // n0x0803 c0x0000 (---------------)  + I takasaki
	0x002e3dc8, // n0x0804 c0x0000 (---------------)  + I takayama
	0x002c29c8, // n0x0805 c0x0000 (---------------)  + I tamamura
	0x0034780b, // n0x0806 c0x0000 (---------------)  + I tatebayashi
	0x002db347, // n0x0807 c0x0000 (---------------)  + I tomioka
	0x00297549, // n0x0808 c0x0000 (---------------)  + I tsukiyono
	0x00256488, // n0x0809 c0x0000 (---------------)  + I tsumagoi
	0x0024fcc4, // n0x080a c0x0000 (---------------)  + I ueno
	0x002b7f88, // n0x080b c0x0000 (---------------)  + I yoshioka
	0x0027a189, // n0x080c c0x0000 (---------------)  + I asaminami
	0x00307445, // n0x080d c0x0000 (---------------)  + I daiwa
	0x00328607, // n0x080e c0x0000 (---------------)  + I etajima
	0x0033dc85, // n0x080f c0x0000 (---------------)  + I fuchu
	0x0026ed08, // n0x0810 c0x0000 (---------------)  + I fukuyama
	0x0027c20b, // n0x0811 c0x0000 (---------------)  + I hatsukaichi
	0x0027da50, // n0x0812 c0x0000 (---------------)  + I higashihiroshima
	0x00291405, // n0x0813 c0x0000 (---------------)  + I hongo
	0x00215d4c, // n0x0814 c0x0000 (---------------)  + I jinsekikogen
	0x002955c5, // n0x0815 c0x0000 (---------------)  + I kaita
	0x00225c83, // n0x0816 c0x0000 (---------------)  + I kui
	0x002d9586, // n0x0817 c0x0000 (---------------)  + I kumano
	0x002a6a84, // n0x0818 c0x0000 (---------------)  + I kure
	0x00266106, // n0x0819 c0x0000 (---------------)  + I mihara
	0x00284707, // n0x081a c0x0000 (---------------)  + I miyoshi
	0x0020cbc4, // n0x081b c0x0000 (---------------)  + I naka
	0x00299848, // n0x081c c0x0000 (---------------)  + I onomichi
	0x002286cd, // n0x081d c0x0000 (---------------)  + I osakikamijima
	0x002cb805, // n0x081e c0x0000 (---------------)  + I otake
	0x00262fc4, // n0x081f c0x0000 (---------------)  + I saka
	0x00222a84, // n0x0820 c0x0000 (---------------)  + I sera
	0x00288989, // n0x0821 c0x0000 (---------------)  + I seranishi
	0x002d82c8, // n0x0822 c0x0000 (---------------)  + I shinichi
	0x0033f407, // n0x0823 c0x0000 (---------------)  + I shobara
	0x002b29c8, // n0x0824 c0x0000 (---------------)  + I takehara
	0x0026f308, // n0x0825 c0x0000 (---------------)  + I abashiri
	0x0026aa45, // n0x0826 c0x0000 (---------------)  + I abira
	0x00229947, // n0x0827 c0x0000 (---------------)  + I aibetsu
	0x0026a9c7, // n0x0828 c0x0000 (---------------)  + I akabira
	0x0020b2c7, // n0x0829 c0x0000 (---------------)  + I akkeshi
	0x002ad249, // n0x082a c0x0000 (---------------)  + I asahikawa
	0x002c3a09, // n0x082b c0x0000 (---------------)  + I ashibetsu
	0x0023cec6, // n0x082c c0x0000 (---------------)  + I ashoro
	0x002b9786, // n0x082d c0x0000 (---------------)  + I assabu
	0x00256446, // n0x082e c0x0000 (---------------)  + I atsuma
	0x00250385, // n0x082f c0x0000 (---------------)  + I bibai
	0x002fb384, // n0x0830 c0x0000 (---------------)  + I biei
	0x00208406, // n0x0831 c0x0000 (---------------)  + I bifuka
	0x00209806, // n0x0832 c0x0000 (---------------)  + I bihoro
	0x0026aa88, // n0x0833 c0x0000 (---------------)  + I biratori
	0x0029af8b, // n0x0834 c0x0000 (---------------)  + I chippubetsu
	0x00291e07, // n0x0835 c0x0000 (---------------)  + I chitose
	0x002232c4, // n0x0836 c0x0000 (---------------)  + I date
	0x00222246, // n0x0837 c0x0000 (---------------)  + I ebetsu
	0x002e8387, // n0x0838 c0x0000 (---------------)  + I embetsu
	0x00225905, // n0x0839 c0x0000 (---------------)  + I eniwa
	0x0028bc85, // n0x083a c0x0000 (---------------)  + I erimo
	0x0024c584, // n0x083b c0x0000 (---------------)  + I esan
	0x002c3986, // n0x083c c0x0000 (---------------)  + I esashi
	0x00208488, // n0x083d c0x0000 (---------------)  + I fukagawa
	0x00239289, // n0x083e c0x0000 (---------------)  + I fukushima
	0x002422c6, // n0x083f c0x0000 (---------------)  + I furano
	0x002719c8, // n0x0840 c0x0000 (---------------)  + I furubira
	0x0023e346, // n0x0841 c0x0000 (---------------)  + I haboro
	0x0032f5c8, // n0x0842 c0x0000 (---------------)  + I hakodate
	0x002dc04c, // n0x0843 c0x0000 (---------------)  + I hamatonbetsu
	0x0026a906, // n0x0844 c0x0000 (---------------)  + I hidaka
	0x0027ef0d, // n0x0845 c0x0000 (---------------)  + I higashikagura
	0x0027f38b, // n0x0846 c0x0000 (---------------)  + I higashikawa
	0x0025a005, // n0x0847 c0x0000 (---------------)  + I hiroo
	0x0021db87, // n0x0848 c0x0000 (---------------)  + I hokuryu
	0x00252946, // n0x0849 c0x0000 (---------------)  + I hokuto
	0x002af048, // n0x084a c0x0000 (---------------)  + I honbetsu
	0x0023cf49, // n0x084b c0x0000 (---------------)  + I horokanai
	0x002439c8, // n0x084c c0x0000 (---------------)  + I horonobe
	0x00244305, // n0x084d c0x0000 (---------------)  + I ikeda
	0x00328707, // n0x084e c0x0000 (---------------)  + I imakane
	0x0029d8c8, // n0x084f c0x0000 (---------------)  + I ishikari
	0x002bbfc9, // n0x0850 c0x0000 (---------------)  + I iwamizawa
	0x00268206, // n0x0851 c0x0000 (---------------)  + I iwanai
	0x0027798a, // n0x0852 c0x0000 (---------------)  + I kamifurano
	0x002aedc8, // n0x0853 c0x0000 (---------------)  + I kamikawa
	0x0024380b, // n0x0854 c0x0000 (---------------)  + I kamishihoro
	0x002b810c, // n0x0855 c0x0000 (---------------)  + I kamisunagawa
	0x0021ff48, // n0x0856 c0x0000 (---------------)  + I kamoenai
	0x0026b586, // n0x0857 c0x0000 (---------------)  + I kayabe
	0x00342048, // n0x0858 c0x0000 (---------------)  + I kembuchi
	0x002f10c7, // n0x0859 c0x0000 (---------------)  + I kikonai
	0x0022c6c9, // n0x085a c0x0000 (---------------)  + I kimobetsu
	0x0027b90d, // n0x085b c0x0000 (---------------)  + I kitahiroshima
	0x0027f7c6, // n0x085c c0x0000 (---------------)  + I kitami
	0x002d9008, // n0x085d c0x0000 (---------------)  + I kiyosato
	0x0029a449, // n0x085e c0x0000 (---------------)  + I koshimizu
	0x002a6048, // n0x085f c0x0000 (---------------)  + I kunneppu
	0x00249188, // n0x0860 c0x0000 (---------------)  + I kuriyama
	0x002a784c, // n0x0861 c0x0000 (---------------)  + I kuromatsunai
	0x002a9747, // n0x0862 c0x0000 (---------------)  + I kushiro
	0x002aa587, // n0x0863 c0x0000 (---------------)  + I kutchan
	0x002ad085, // n0x0864 c0x0000 (---------------)  + I kyowa
	0x00244207, // n0x0865 c0x0000 (---------------)  + I mashike
	0x0025d5c8, // n0x0866 c0x0000 (---------------)  + I matsumae
	0x002dae86, // n0x0867 c0x0000 (---------------)  + I mikasa
	0x0024214c, // n0x0868 c0x0000 (---------------)  + I minamifurano
	0x002b3908, // n0x0869 c0x0000 (---------------)  + I mombetsu
	0x002b9b48, // n0x086a c0x0000 (---------------)  + I moseushi
	0x002b0346, // n0x086b c0x0000 (---------------)  + I mukawa
	0x00250b07, // n0x086c c0x0000 (---------------)  + I muroran
	0x0023d0c4, // n0x086d c0x0000 (---------------)  + I naie
	0x0028a488, // n0x086e c0x0000 (---------------)  + I nakagawa
	0x002c618c, // n0x086f c0x0000 (---------------)  + I nakasatsunai
	0x002d274c, // n0x0870 c0x0000 (---------------)  + I nakatombetsu
	0x00222dc5, // n0x0871 c0x0000 (---------------)  + I nanae
	0x00200987, // n0x0872 c0x0000 (---------------)  + I nanporo
	0x00210a46, // n0x0873 c0x0000 (---------------)  + I nayoro
	0x00250a86, // n0x0874 c0x0000 (---------------)  + I nemuro
	0x0028e8c8, // n0x0875 c0x0000 (---------------)  + I niikappu
	0x0020ae84, // n0x0876 c0x0000 (---------------)  + I niki
	0x0022dc8b, // n0x0877 c0x0000 (---------------)  + I nishiokoppe
	0x0034164b, // n0x0878 c0x0000 (---------------)  + I noboribetsu
	0x002e3cc6, // n0x0879 c0x0000 (---------------)  + I numata
	0x00228547, // n0x087a c0x0000 (---------------)  + I obihiro
	0x003273c5, // n0x087b c0x0000 (---------------)  + I obira
	0x00260985, // n0x087c c0x0000 (---------------)  + I oketo
	0x0022ddc6, // n0x087d c0x0000 (---------------)  + I okoppe
	0x0024e505, // n0x087e c0x0000 (---------------)  + I otaru
	0x002581c5, // n0x087f c0x0000 (---------------)  + I otobe
	0x002a3f47, // n0x0880 c0x0000 (---------------)  + I otofuke
	0x00203d89, // n0x0881 c0x0000 (---------------)  + I otoineppu
	0x00278e84, // n0x0882 c0x0000 (---------------)  + I oumu
	0x00289585, // n0x0883 c0x0000 (---------------)  + I ozora
	0x002cb445, // n0x0884 c0x0000 (---------------)  + I pippu
	0x00250c08, // n0x0885 c0x0000 (---------------)  + I rankoshi
	0x00299685, // n0x0886 c0x0000 (---------------)  + I rebun
	0x00271f89, // n0x0887 c0x0000 (---------------)  + I rikubetsu
	0x002db8c7, // n0x0888 c0x0000 (---------------)  + I rishiri
	0x002db8cb, // n0x0889 c0x0000 (---------------)  + I rishirifuji
	0x002d0c06, // n0x088a c0x0000 (---------------)  + I saroma
	0x00295049, // n0x088b c0x0000 (---------------)  + I sarufutsu
	0x00323f48, // n0x088c c0x0000 (---------------)  + I shakotan
	0x00342385, // n0x088d c0x0000 (---------------)  + I shari
	0x0020b3c8, // n0x088e c0x0000 (---------------)  + I shibecha
	0x002c3a48, // n0x088f c0x0000 (---------------)  + I shibetsu
	0x002c0947, // n0x0890 c0x0000 (---------------)  + I shikabe
	0x0025d847, // n0x0891 c0x0000 (---------------)  + I shikaoi
	0x002b47c9, // n0x0892 c0x0000 (---------------)  + I shimamaki
	0x00231f07, // n0x0893 c0x0000 (---------------)  + I shimizu
	0x002d54c9, // n0x0894 c0x0000 (---------------)  + I shimokawa
	0x002d9ecc, // n0x0895 c0x0000 (---------------)  + I shinshinotsu
	0x002da9c8, // n0x0896 c0x0000 (---------------)  + I shintoku
	0x002dc709, // n0x0897 c0x0000 (---------------)  + I shiranuka
	0x002dcac7, // n0x0898 c0x0000 (---------------)  + I shiraoi
	0x0026f3c9, // n0x0899 c0x0000 (---------------)  + I shiriuchi
	0x00207347, // n0x089a c0x0000 (---------------)  + I sobetsu
	0x002b8208, // n0x089b c0x0000 (---------------)  + I sunagawa
	0x00226b05, // n0x089c c0x0000 (---------------)  + I taiki
	0x00254086, // n0x089d c0x0000 (---------------)  + I takasu
	0x002a8b88, // n0x089e c0x0000 (---------------)  + I takikawa
	0x002f7408, // n0x089f c0x0000 (---------------)  + I takinoue
	0x0029d609, // n0x08a0 c0x0000 (---------------)  + I teshikaga
	0x00258207, // n0x08a1 c0x0000 (---------------)  + I tobetsu
	0x0028acc5, // n0x08a2 c0x0000 (---------------)  + I tohma
	0x0025e4c9, // n0x08a3 c0x0000 (---------------)  + I tomakomai
	0x0024f546, // n0x08a4 c0x0000 (---------------)  + I tomari
	0x002457c4, // n0x08a5 c0x0000 (---------------)  + I toya
	0x002457c6, // n0x08a6 c0x0000 (---------------)  + I toyako
	0x00266988, // n0x08a7 c0x0000 (---------------)  + I toyotomi
	0x0026e6c7, // n0x08a8 c0x0000 (---------------)  + I toyoura
	0x0029b188, // n0x08a9 c0x0000 (---------------)  + I tsubetsu
	0x002041c9, // n0x08aa c0x0000 (---------------)  + I tsukigata
	0x0022e6c7, // n0x08ab c0x0000 (---------------)  + I urakawa
	0x00286c46, // n0x08ac c0x0000 (---------------)  + I urausu
	0x0021dc44, // n0x08ad c0x0000 (---------------)  + I uryu
	0x00210c09, // n0x08ae c0x0000 (---------------)  + I utashinai
	0x002297c8, // n0x08af c0x0000 (---------------)  + I wakkanai
	0x002b0207, // n0x08b0 c0x0000 (---------------)  + I wassamu
	0x0028c646, // n0x08b1 c0x0000 (---------------)  + I yakumo
	0x00291a86, // n0x08b2 c0x0000 (---------------)  + I yoichi
	0x002f1204, // n0x08b3 c0x0000 (---------------)  + I aioi
	0x002cb986, // n0x08b4 c0x0000 (---------------)  + I akashi
	0x0020b0c3, // n0x08b5 c0x0000 (---------------)  + I ako
	0x0022fa09, // n0x08b6 c0x0000 (---------------)  + I amagasaki
	0x0020aa06, // n0x08b7 c0x0000 (---------------)  + I aogaki
	0x002a73c5, // n0x08b8 c0x0000 (---------------)  + I asago
	0x00287786, // n0x08b9 c0x0000 (---------------)  + I ashiya
	0x002322c5, // n0x08ba c0x0000 (---------------)  + I awaji
	0x0026e888, // n0x08bb c0x0000 (---------------)  + I fukusaki
	0x0021fc87, // n0x08bc c0x0000 (---------------)  + I goshiki
	0x00237b06, // n0x08bd c0x0000 (---------------)  + I harima
	0x0030ca86, // n0x08be c0x0000 (---------------)  + I himeji
	0x00235cc8, // n0x08bf c0x0000 (---------------)  + I ichikawa
	0x0028b607, // n0x08c0 c0x0000 (---------------)  + I inagawa
	0x0027f805, // n0x08c1 c0x0000 (---------------)  + I itami
	0x00287c88, // n0x08c2 c0x0000 (---------------)  + I kakogawa
	0x00276448, // n0x08c3 c0x0000 (---------------)  + I kamigori
	0x002aedc8, // n0x08c4 c0x0000 (---------------)  + I kamikawa
	0x00295485, // n0x08c5 c0x0000 (---------------)  + I kasai
	0x00254106, // n0x08c6 c0x0000 (---------------)  + I kasuga
	0x003195c9, // n0x08c7 c0x0000 (---------------)  + I kawanishi
	0x00245b04, // n0x08c8 c0x0000 (---------------)  + I miki
	0x0023214b, // n0x08c9 c0x0000 (---------------)  + I minamiawaji
	0x00322e4b, // n0x08ca c0x0000 (---------------)  + I nishinomiya
	0x00233d49, // n0x08cb c0x0000 (---------------)  + I nishiwaki
	0x00216743, // n0x08cc c0x0000 (---------------)  + I ono
	0x0024aa85, // n0x08cd c0x0000 (---------------)  + I sanda
	0x0025c246, // n0x08ce c0x0000 (---------------)  + I sannan
	0x002b7c88, // n0x08cf c0x0000 (---------------)  + I sasayama
	0x0029cf84, // n0x08d0 c0x0000 (---------------)  + I sayo
	0x002d8086, // n0x08d1 c0x0000 (---------------)  + I shingu
	0x00258649, // n0x08d2 c0x0000 (---------------)  + I shinonsen
	0x002de205, // n0x08d3 c0x0000 (---------------)  + I shiso
	0x002a3e86, // n0x08d4 c0x0000 (---------------)  + I sumoto
	0x00227006, // n0x08d5 c0x0000 (---------------)  + I taishi
	0x00204384, // n0x08d6 c0x0000 (---------------)  + I taka
	0x0034720a, // n0x08d7 c0x0000 (---------------)  + I takarazuka
	0x002a7308, // n0x08d8 c0x0000 (---------------)  + I takasago
	0x002f7406, // n0x08d9 c0x0000 (---------------)  + I takino
	0x00289385, // n0x08da c0x0000 (---------------)  + I tamba
	0x00261847, // n0x08db c0x0000 (---------------)  + I tatsuno
	0x00255b47, // n0x08dc c0x0000 (---------------)  + I toyooka
	0x0022adc4, // n0x08dd c0x0000 (---------------)  + I yabu
	0x00323087, // n0x08de c0x0000 (---------------)  + I yashiro
	0x0024a844, // n0x08df c0x0000 (---------------)  + I yoka
	0x0024a846, // n0x08e0 c0x0000 (---------------)  + I yokawa
	0x0020fac3, // n0x08e1 c0x0000 (---------------)  + I ami
	0x002ad245, // n0x08e2 c0x0000 (---------------)  + I asahi
	0x00324ac5, // n0x08e3 c0x0000 (---------------)  + I bando
	0x002bf008, // n0x08e4 c0x0000 (---------------)  + I chikusei
	0x002a3205, // n0x08e5 c0x0000 (---------------)  + I daigo
	0x0026a649, // n0x08e6 c0x0000 (---------------)  + I fujishiro
	0x0028a2c7, // n0x08e7 c0x0000 (---------------)  + I hitachi
	0x0028a2cb, // n0x08e8 c0x0000 (---------------)  + I hitachinaka
	0x0028d6cc, // n0x08e9 c0x0000 (---------------)  + I hitachiomiya
	0x0028e10a, // n0x08ea c0x0000 (---------------)  + I hitachiota
	0x00327887, // n0x08eb c0x0000 (---------------)  + I ibaraki
	0x00203303, // n0x08ec c0x0000 (---------------)  + I ina
	0x002d8e88, // n0x08ed c0x0000 (---------------)  + I inashiki
	0x00295645, // n0x08ee c0x0000 (---------------)  + I itako
	0x002725c5, // n0x08ef c0x0000 (---------------)  + I iwama
	0x0020cd44, // n0x08f0 c0x0000 (---------------)  + I joso
	0x002b8106, // n0x08f1 c0x0000 (---------------)  + I kamisu
	0x0021aac6, // n0x08f2 c0x0000 (---------------)  + I kasama
	0x002cb9c7, // n0x08f3 c0x0000 (---------------)  + I kashima
	0x0021b60b, // n0x08f4 c0x0000 (---------------)  + I kasumigaura
	0x0027ae04, // n0x08f5 c0x0000 (---------------)  + I koga
	0x002e0444, // n0x08f6 c0x0000 (---------------)  + I miho
	0x002b2bc4, // n0x08f7 c0x0000 (---------------)  + I mito
	0x002b7606, // n0x08f8 c0x0000 (---------------)  + I moriya
	0x0020cbc4, // n0x08f9 c0x0000 (---------------)  + I naka
	0x002df188, // n0x08fa c0x0000 (---------------)  + I namegata
	0x003018c5, // n0x08fb c0x0000 (---------------)  + I oarai
	0x00230d45, // n0x08fc c0x0000 (---------------)  + I ogawa
	0x002c2907, // n0x08fd c0x0000 (---------------)  + I omitama
	0x0021dc89, // n0x08fe c0x0000 (---------------)  + I ryugasaki
	0x00306385, // n0x08ff c0x0000 (---------------)  + I sakai
	0x0022358a, // n0x0900 c0x0000 (---------------)  + I sakuragawa
	0x0025a349, // n0x0901 c0x0000 (---------------)  + I shimodate
	0x002d7e0a, // n0x0902 c0x0000 (---------------)  + I shimotsuma
	0x00308709, // n0x0903 c0x0000 (---------------)  + I shirosato
	0x002e5184, // n0x0904 c0x0000 (---------------)  + I sowa
	0x002de545, // n0x0905 c0x0000 (---------------)  + I suifu
	0x002dd788, // n0x0906 c0x0000 (---------------)  + I takahagi
	0x002aac4b, // n0x0907 c0x0000 (---------------)  + I tamatsukuri
	0x002f2085, // n0x0908 c0x0000 (---------------)  + I tokai
	0x002593c6, // n0x0909 c0x0000 (---------------)  + I tomobe
	0x00240944, // n0x090a c0x0000 (---------------)  + I tone
	0x0026ab86, // n0x090b c0x0000 (---------------)  + I toride
	0x0022e549, // n0x090c c0x0000 (---------------)  + I tsuchiura
	0x002e8487, // n0x090d c0x0000 (---------------)  + I tsukuba
	0x002b1408, // n0x090e c0x0000 (---------------)  + I uchihara
	0x00296c46, // n0x090f c0x0000 (---------------)  + I ushiku
	0x00206c07, // n0x0910 c0x0000 (---------------)  + I yachiyo
	0x0026ee08, // n0x0911 c0x0000 (---------------)  + I yamagata
	0x00326146, // n0x0912 c0x0000 (---------------)  + I yawara
	0x002afc44, // n0x0913 c0x0000 (---------------)  + I yuki
	0x0023ed87, // n0x0914 c0x0000 (---------------)  + I anamizu
	0x00274685, // n0x0915 c0x0000 (---------------)  + I hakui
	0x00274a47, // n0x0916 c0x0000 (---------------)  + I hakusan
	0x00208504, // n0x0917 c0x0000 (---------------)  + I kaga
	0x002528c6, // n0x0918 c0x0000 (---------------)  + I kahoku
	0x00261b88, // n0x0919 c0x0000 (---------------)  + I kanazawa
	0x0027f548, // n0x091a c0x0000 (---------------)  + I kawakita
	0x002b8e47, // n0x091b c0x0000 (---------------)  + I komatsu
	0x0020d108, // n0x091c c0x0000 (---------------)  + I nakanoto
	0x00217d85, // n0x091d c0x0000 (---------------)  + I nanao
	0x00216584, // n0x091e c0x0000 (---------------)  + I nomi
	0x00235bc8, // n0x091f c0x0000 (---------------)  + I nonoichi
	0x0020d204, // n0x0920 c0x0000 (---------------)  + I noto
	0x00253f45, // n0x0921 c0x0000 (---------------)  + I shika
	0x002eae04, // n0x0922 c0x0000 (---------------)  + I suzu
	0x002d4947, // n0x0923 c0x0000 (---------------)  + I tsubata
	0x002af187, // n0x0924 c0x0000 (---------------)  + I tsurugi
	0x0026f508, // n0x0925 c0x0000 (---------------)  + I uchinada
	0x00244106, // n0x0926 c0x0000 (---------------)  + I wajima
	0x002a3185, // n0x0927 c0x0000 (---------------)  + I fudai
	0x0026a448, // n0x0928 c0x0000 (---------------)  + I fujisawa
	0x00273cc8, // n0x0929 c0x0000 (---------------)  + I hanamaki
	0x0028aa09, // n0x092a c0x0000 (---------------)  + I hiraizumi
	0x00323146, // n0x092b c0x0000 (---------------)  + I hirono
	0x00347a88, // n0x092c c0x0000 (---------------)  + I ichinohe
	0x0021994a, // n0x092d c0x0000 (---------------)  + I ichinoseki
	0x00225988, // n0x092e c0x0000 (---------------)  + I iwaizumi
	0x00297345, // n0x092f c0x0000 (---------------)  + I iwate
	0x00262c06, // n0x0930 c0x0000 (---------------)  + I joboji
	0x0025a208, // n0x0931 c0x0000 (---------------)  + I kamaishi
	0x003287ca, // n0x0932 c0x0000 (---------------)  + I kanegasaki
	0x0030be87, // n0x0933 c0x0000 (---------------)  + I karumai
	0x0026e445, // n0x0934 c0x0000 (---------------)  + I kawai
	0x00347d88, // n0x0935 c0x0000 (---------------)  + I kitakami
	0x00270784, // n0x0936 c0x0000 (---------------)  + I kuji
	0x00246a06, // n0x0937 c0x0000 (---------------)  + I kunohe
	0x002ab308, // n0x0938 c0x0000 (---------------)  + I kuzumaki
	0x00216606, // n0x0939 c0x0000 (---------------)  + I miyako
	0x00215908, // n0x093a c0x0000 (---------------)  + I mizusawa
	0x0027e4c7, // n0x093b c0x0000 (---------------)  + I morioka
	0x002f3446, // n0x093c c0x0000 (---------------)  + I ninohe
	0x0022a104, // n0x093d c0x0000 (---------------)  + I noda
	0x002bff07, // n0x093e c0x0000 (---------------)  + I ofunato
	0x0029ac44, // n0x093f c0x0000 (---------------)  + I oshu
	0x0022e507, // n0x0940 c0x0000 (---------------)  + I otsuchi
	0x002b054d, // n0x0941 c0x0000 (---------------)  + I rikuzentakata
	0x00210405, // n0x0942 c0x0000 (---------------)  + I shiwa
	0x002dec0b, // n0x0943 c0x0000 (---------------)  + I shizukuishi
	0x0029b746, // n0x0944 c0x0000 (---------------)  + I sumita
	0x00344688, // n0x0945 c0x0000 (---------------)  + I takizawa
	0x0032bd88, // n0x0946 c0x0000 (---------------)  + I tanohata
	0x0022e984, // n0x0947 c0x0000 (---------------)  + I tono
	0x002e0806, // n0x0948 c0x0000 (---------------)  + I yahaba
	0x0026c046, // n0x0949 c0x0000 (---------------)  + I yamada
	0x00227587, // n0x094a c0x0000 (---------------)  + I ayagawa
	0x0027ebcd, // n0x094b c0x0000 (---------------)  + I higashikagawa
	0x002c92c7, // n0x094c c0x0000 (---------------)  + I kanonji
	0x0029c188, // n0x094d c0x0000 (---------------)  + I kotohira
	0x00259e85, // n0x094e c0x0000 (---------------)  + I manno
	0x0027bbc8, // n0x094f c0x0000 (---------------)  + I marugame
	0x002b2f46, // n0x0950 c0x0000 (---------------)  + I mitoyo
	0x00217e08, // n0x0951 c0x0000 (---------------)  + I naoshima
	0x002713c6, // n0x0952 c0x0000 (---------------)  + I sanuki
	0x00202987, // n0x0953 c0x0000 (---------------)  + I tadotsu
	0x0032bf09, // n0x0954 c0x0000 (---------------)  + I takamatsu
	0x0022e987, // n0x0955 c0x0000 (---------------)  + I tonosho
	0x00273708, // n0x0956 c0x0000 (---------------)  + I uchinomi
	0x00239d45, // n0x0957 c0x0000 (---------------)  + I utazu
	0x00219048, // n0x0958 c0x0000 (---------------)  + I zentsuji
	0x002509c5, // n0x0959 c0x0000 (---------------)  + I akune
	0x00258f45, // n0x095a c0x0000 (---------------)  + I amami
	0x00259745, // n0x095b c0x0000 (---------------)  + I hioki
	0x0022d543, // n0x095c c0x0000 (---------------)  + I isa
	0x00270344, // n0x095d c0x0000 (---------------)  + I isen
	0x00225a45, // n0x095e c0x0000 (---------------)  + I izumi
	0x002fd949, // n0x095f c0x0000 (---------------)  + I kagoshima
	0x002eaf06, // n0x0960 c0x0000 (---------------)  + I kanoya
	0x002a2ac8, // n0x0961 c0x0000 (---------------)  + I kawanabe
	0x0024d445, // n0x0962 c0x0000 (---------------)  + I kinko
	0x0029dd47, // n0x0963 c0x0000 (---------------)  + I kouyama
	0x0027e68a, // n0x0964 c0x0000 (---------------)  + I makurazaki
	0x002a3dc9, // n0x0965 c0x0000 (---------------)  + I matsumoto
	0x00310a4a, // n0x0966 c0x0000 (---------------)  + I minamitane
	0x002c2088, // n0x0967 c0x0000 (---------------)  + I nakatane
	0x0022ce0c, // n0x0968 c0x0000 (---------------)  + I nishinoomote
	0x0027004d, // n0x0969 c0x0000 (---------------)  + I satsumasendai
	0x002e2643, // n0x096a c0x0000 (---------------)  + I soo
	0x00215808, // n0x096b c0x0000 (---------------)  + I tarumizu
	0x0025d085, // n0x096c c0x0000 (---------------)  + I yusui
	0x00251146, // n0x096d c0x0000 (---------------)  + I aikawa
	0x002bd106, // n0x096e c0x0000 (---------------)  + I atsugi
	0x0033ee45, // n0x096f c0x0000 (---------------)  + I ayase
	0x00211dc9, // n0x0970 c0x0000 (---------------)  + I chigasaki
	0x002bb505, // n0x0971 c0x0000 (---------------)  + I ebina
	0x0026a448, // n0x0972 c0x0000 (---------------)  + I fujisawa
	0x00305886, // n0x0973 c0x0000 (---------------)  + I hadano
	0x0034b186, // n0x0974 c0x0000 (---------------)  + I hakone
	0x0028c209, // n0x0975 c0x0000 (---------------)  + I hiratsuka
	0x003347c7, // n0x0976 c0x0000 (---------------)  + I isehara
	0x002e3706, // n0x0977 c0x0000 (---------------)  + I kaisei
	0x0027e608, // n0x0978 c0x0000 (---------------)  + I kamakura
	0x003328c8, // n0x0979 c0x0000 (---------------)  + I kiyokawa
	0x002bca07, // n0x097a c0x0000 (---------------)  + I matsuda
	0x002e4e0e, // n0x097b c0x0000 (---------------)  + I minamiashigara
	0x002b3185, // n0x097c c0x0000 (---------------)  + I miura
	0x002bbec5, // n0x097d c0x0000 (---------------)  + I nakai
	0x00216508, // n0x097e c0x0000 (---------------)  + I ninomiya
	0x0022a147, // n0x097f c0x0000 (---------------)  + I odawara
	0x00203e02, // n0x0980 c0x0000 (---------------)  + I oi
	0x002a7684, // n0x0981 c0x0000 (---------------)  + I oiso
	0x0026600a, // n0x0982 c0x0000 (---------------)  + I sagamihara
	0x002b02c8, // n0x0983 c0x0000 (---------------)  + I samukawa
	0x00225bc6, // n0x0984 c0x0000 (---------------)  + I tsukui
	0x00280e08, // n0x0985 c0x0000 (---------------)  + I yamakita
	0x00245c86, // n0x0986 c0x0000 (---------------)  + I yamato
	0x002bcec8, // n0x0987 c0x0000 (---------------)  + I yokosuka
	0x00296048, // n0x0988 c0x0000 (---------------)  + I yugawara
	0x00258f04, // n0x0989 c0x0000 (---------------)  + I zama
	0x0029e0c5, // n0x098a c0x0000 (---------------)  + I zushi
	0x0074a404, // n0x098b c0x0001 (---------------)  ! I city
	0x0074a404, // n0x098c c0x0001 (---------------)  ! I city
	0x0074a404, // n0x098d c0x0001 (---------------)  ! I city
	0x002044c3, // n0x098e c0x0000 (---------------)  + I aki
	0x00236886, // n0x098f c0x0000 (---------------)  + I geisei
	0x0026a906, // n0x0990 c0x0000 (---------------)  + I hidaka
	0x0028660c, // n0x0991 c0x0000 (---------------)  + I higashitsuno
	0x00216543, // n0x0992 c0x0000 (---------------)  + I ino
	0x00236306, // n0x0993 c0x0000 (---------------)  + I kagami
	0x00228804, // n0x0994 c0x0000 (---------------)  + I kami
	0x002b4988, // n0x0995 c0x0000 (---------------)  + I kitagawa
	0x002bef85, // n0x0996 c0x0000 (---------------)  + I kochi
	0x00266106, // n0x0997 c0x0000 (---------------)  + I mihara
	0x0025d448, // n0x0998 c0x0000 (---------------)  + I motoyama
	0x002c2bc6, // n0x0999 c0x0000 (---------------)  + I muroto
	0x00237a86, // n0x099a c0x0000 (---------------)  + I nahari
	0x00287248, // n0x099b c0x0000 (---------------)  + I nakamura
	0x00220647, // n0x099c c0x0000 (---------------)  + I nankoku
	0x00231cc9, // n0x099d c0x0000 (---------------)  + I nishitosa
	0x0023b34a, // n0x099e c0x0000 (---------------)  + I niyodogawa
	0x002596c4, // n0x099f c0x0000 (---------------)  + I ochi
	0x0024a885, // n0x09a0 c0x0000 (---------------)  + I okawa
	0x002d9945, // n0x09a1 c0x0000 (---------------)  + I otoyo
	0x00239086, // n0x09a2 c0x0000 (---------------)  + I otsuki
	0x002adbc6, // n0x09a3 c0x0000 (---------------)  + I sakawa
	0x00287046, // n0x09a4 c0x0000 (---------------)  + I sukumo
	0x002da146, // n0x09a5 c0x0000 (---------------)  + I susaki
	0x00231e04, // n0x09a6 c0x0000 (---------------)  + I tosa
	0x00231e0b, // n0x09a7 c0x0000 (---------------)  + I tosashimizu
	0x0024a7c4, // n0x09a8 c0x0000 (---------------)  + I toyo
	0x002618c5, // n0x09a9 c0x0000 (---------------)  + I tsuno
	0x00295a85, // n0x09aa c0x0000 (---------------)  + I umaji
	0x002f1d06, // n0x09ab c0x0000 (---------------)  + I yasuda
	0x0023a008, // n0x09ac c0x0000 (---------------)  + I yusuhara
	0x0026ff07, // n0x09ad c0x0000 (---------------)  + I amakusa
	0x00308484, // n0x09ae c0x0000 (---------------)  + I arao
	0x002080c3, // n0x09af c0x0000 (---------------)  + I aso
	0x00306dc5, // n0x09b0 c0x0000 (---------------)  + I choyo
	0x0024f407, // n0x09b1 c0x0000 (---------------)  + I gyokuto
	0x0028ebc9, // n0x09b2 c0x0000 (---------------)  + I hitoyoshi
	0x0026fe0b, // n0x09b3 c0x0000 (---------------)  + I kamiamakusa
	0x002cb9c7, // n0x09b4 c0x0000 (---------------)  + I kashima
	0x00227287, // n0x09b5 c0x0000 (---------------)  + I kikuchi
	0x00298d84, // n0x09b6 c0x0000 (---------------)  + I kosa
	0x0025d348, // n0x09b7 c0x0000 (---------------)  + I kumamoto
	0x003115c7, // n0x09b8 c0x0000 (---------------)  + I mashiki
	0x00281946, // n0x09b9 c0x0000 (---------------)  + I mifune
	0x002f7e08, // n0x09ba c0x0000 (---------------)  + I minamata
	0x0025f9cb, // n0x09bb c0x0000 (---------------)  + I minamioguni
	0x00304546, // n0x09bc c0x0000 (---------------)  + I nagasu
	0x00220c49, // n0x09bd c0x0000 (---------------)  + I nishihara
	0x0025fb45, // n0x09be c0x0000 (---------------)  + I oguni
	0x0022b083, // n0x09bf c0x0000 (---------------)  + I ozu
	0x002a3e86, // n0x09c0 c0x0000 (---------------)  + I sumoto
	0x0027e3c8, // n0x09c1 c0x0000 (---------------)  + I takamori
	0x00204243, // n0x09c2 c0x0000 (---------------)  + I uki
	0x0024f503, // n0x09c3 c0x0000 (---------------)  + I uto
	0x0026ee06, // n0x09c4 c0x0000 (---------------)  + I yamaga
	0x00245c86, // n0x09c5 c0x0000 (---------------)  + I yamato
	0x00316cca, // n0x09c6 c0x0000 (---------------)  + I yatsushiro
	0x0026b5c5, // n0x09c7 c0x0000 (---------------)  + I ayabe
	0x0026be8b, // n0x09c8 c0x0000 (---------------)  + I fukuchiyama
	0x002876cb, // n0x09c9 c0x0000 (---------------)  + I higashiyama
	0x00268dc3, // n0x09ca c0x0000 (---------------)  + I ide
	0x00203e43, // n0x09cb c0x0000 (---------------)  + I ine
	0x002d8684, // n0x09cc c0x0000 (---------------)  + I joyo
	0x002d8ac7, // n0x09cd c0x0000 (---------------)  + I kameoka
	0x0021ff44, // n0x09ce c0x0000 (---------------)  + I kamo
	0x0021de44, // n0x09cf c0x0000 (---------------)  + I kita
	0x00311704, // n0x09d0 c0x0000 (---------------)  + I kizu
	0x002c3c48, // n0x09d1 c0x0000 (---------------)  + I kumiyama
	0x002892c8, // n0x09d2 c0x0000 (---------------)  + I kyotamba
	0x00233389, // n0x09d3 c0x0000 (---------------)  + I kyotanabe
	0x00200308, // n0x09d4 c0x0000 (---------------)  + I kyotango
	0x00289707, // n0x09d5 c0x0000 (---------------)  + I maizuru
	0x00232146, // n0x09d6 c0x0000 (---------------)  + I minami
	0x002a270f, // n0x09d7 c0x0000 (---------------)  + I minamiyamashiro
	0x002b32c6, // n0x09d8 c0x0000 (---------------)  + I miyazu
	0x002bef04, // n0x09d9 c0x0000 (---------------)  + I muko
	0x0028910a, // n0x09da c0x0000 (---------------)  + I nagaokakyo
	0x0024f307, // n0x09db c0x0000 (---------------)  + I nakagyo
	0x002e6a46, // n0x09dc c0x0000 (---------------)  + I nantan
	0x0027b749, // n0x09dd c0x0000 (---------------)  + I oyamazaki
	0x00233305, // n0x09de c0x0000 (---------------)  + I sakyo
	0x00302745, // n0x09df c0x0000 (---------------)  + I seika
	0x00233446, // n0x09e0 c0x0000 (---------------)  + I tanabe
	0x00219183, // n0x09e1 c0x0000 (---------------)  + I uji
	0x002707c9, // n0x09e2 c0x0000 (---------------)  + I ujitawara
	0x0026cac6, // n0x09e3 c0x0000 (---------------)  + I wazuka
	0x002d8d09, // n0x09e4 c0x0000 (---------------)  + I yamashina
	0x0032e306, // n0x09e5 c0x0000 (---------------)  + I yawata
	0x002ad245, // n0x09e6 c0x0000 (---------------)  + I asahi
	0x00224a85, // n0x09e7 c0x0000 (---------------)  + I inabe
	0x00236903, // n0x09e8 c0x0000 (---------------)  + I ise
	0x002d8c08, // n0x09e9 c0x0000 (---------------)  + I kameyama
	0x002adc47, // n0x09ea c0x0000 (---------------)  + I kawagoe
	0x0020af04, // n0x09eb c0x0000 (---------------)  + I kiho
	0x003289c8, // n0x09ec c0x0000 (---------------)  + I kisosaki
	0x0032ebc4, // n0x09ed c0x0000 (---------------)  + I kiwa
	0x002ce2c6, // n0x09ee c0x0000 (---------------)  + I komono
	0x002d9586, // n0x09ef c0x0000 (---------------)  + I kumano
	0x0023ecc6, // n0x09f0 c0x0000 (---------------)  + I kuwana
	0x0029e709, // n0x09f1 c0x0000 (---------------)  + I matsusaka
	0x00272545, // n0x09f2 c0x0000 (---------------)  + I meiwa
	0x0028ee06, // n0x09f3 c0x0000 (---------------)  + I mihama
	0x00242749, // n0x09f4 c0x0000 (---------------)  + I minamiise
	0x002b2306, // n0x09f5 c0x0000 (---------------)  + I misugi
	0x002a2806, // n0x09f6 c0x0000 (---------------)  + I miyama
	0x00330906, // n0x09f7 c0x0000 (---------------)  + I nabari
	0x00202c45, // n0x09f8 c0x0000 (---------------)  + I shima
	0x002eae06, // n0x09f9 c0x0000 (---------------)  + I suzuka
	0x00202984, // n0x09fa c0x0000 (---------------)  + I tado
	0x00226b05, // n0x09fb c0x0000 (---------------)  + I taiki
	0x002a8b84, // n0x09fc c0x0000 (---------------)  + I taki
	0x0029c886, // n0x09fd c0x0000 (---------------)  + I tamaki
	0x003088c4, // n0x09fe c0x0000 (---------------)  + I toba
	0x00202a83, // n0x09ff c0x0000 (---------------)  + I tsu
	0x00272905, // n0x0a00 c0x0000 (---------------)  + I udono
	0x002c3148, // n0x0a01 c0x0000 (---------------)  + I ureshino
	0x00297087, // n0x0a02 c0x0000 (---------------)  + I watarai
	0x0029d009, // n0x0a03 c0x0000 (---------------)  + I yokkaichi
	0x00272b48, // n0x0a04 c0x0000 (---------------)  + I furukawa
	0x00280551, // n0x0a05 c0x0000 (---------------)  + I higashimatsushima
	0x0022708a, // n0x0a06 c0x0000 (---------------)  + I ishinomaki
	0x002e3c07, // n0x0a07 c0x0000 (---------------)  + I iwanuma
	0x00302806, // n0x0a08 c0x0000 (---------------)  + I kakuda
	0x00228804, // n0x0a09 c0x0000 (---------------)  + I kami
	0x002a8c88, // n0x0a0a c0x0000 (---------------)  + I kawasaki
	0x00218149, // n0x0a0b c0x0000 (---------------)  + I kesennuma
	0x0027cac8, // n0x0a0c c0x0000 (---------------)  + I marumori
	0x0028070a, // n0x0a0d c0x0000 (---------------)  + I matsushima
	0x00271d4d, // n0x0a0e c0x0000 (---------------)  + I minamisanriku
	0x00235ec6, // n0x0a0f c0x0000 (---------------)  + I misato
	0x00287346, // n0x0a10 c0x0000 (---------------)  + I murata
	0x002bffc6, // n0x0a11 c0x0000 (---------------)  + I natori
	0x002ca887, // n0x0a12 c0x0000 (---------------)  + I ogawara
	0x0029c245, // n0x0a13 c0x0000 (---------------)  + I ohira
	0x00341e87, // n0x0a14 c0x0000 (---------------)  + I onagawa
	0x002286c5, // n0x0a15 c0x0000 (---------------)  + I osaki
	0x002dba04, // n0x0a16 c0x0000 (---------------)  + I rifu
	0x002fed86, // n0x0a17 c0x0000 (---------------)  + I semine
	0x003470c7, // n0x0a18 c0x0000 (---------------)  + I shibata
	0x00248dcd, // n0x0a19 c0x0000 (---------------)  + I shichikashuku
	0x0025a147, // n0x0a1a c0x0000 (---------------)  + I shikama
	0x002beb48, // n0x0a1b c0x0000 (---------------)  + I shiogama
	0x0026a749, // n0x0a1c c0x0000 (---------------)  + I shiroishi
	0x002a8086, // n0x0a1d c0x0000 (---------------)  + I tagajo
	0x00268185, // n0x0a1e c0x0000 (---------------)  + I taiwa
	0x00277e04, // n0x0a1f c0x0000 (---------------)  + I tome
	0x00266a86, // n0x0a20 c0x0000 (---------------)  + I tomiya
	0x0022acc6, // n0x0a21 c0x0000 (---------------)  + I wakuya
	0x002b0446, // n0x0a22 c0x0000 (---------------)  + I watari
	0x00282fc8, // n0x0a23 c0x0000 (---------------)  + I yamamoto
	0x00265043, // n0x0a24 c0x0000 (---------------)  + I zao
	0x00227583, // n0x0a25 c0x0000 (---------------)  + I aya
	0x002addc5, // n0x0a26 c0x0000 (---------------)  + I ebino
	0x002cd6c6, // n0x0a27 c0x0000 (---------------)  + I gokase
	0x00296005, // n0x0a28 c0x0000 (---------------)  + I hyuga
	0x00296e48, // n0x0a29 c0x0000 (---------------)  + I kadogawa
	0x002848ca, // n0x0a2a c0x0000 (---------------)  + I kawaminami
	0x00224d84, // n0x0a2b c0x0000 (---------------)  + I kijo
	0x002b4988, // n0x0a2c c0x0000 (---------------)  + I kitagawa
	0x0027e248, // n0x0a2d c0x0000 (---------------)  + I kitakata
	0x002f1b47, // n0x0a2e c0x0000 (---------------)  + I kitaura
	0x0030c649, // n0x0a2f c0x0000 (---------------)  + I kobayashi
	0x002a59c8, // n0x0a30 c0x0000 (---------------)  + I kunitomi
	0x00239307, // n0x0a31 c0x0000 (---------------)  + I kushima
	0x002a7206, // n0x0a32 c0x0000 (---------------)  + I mimata
	0x0021660a, // n0x0a33 c0x0000 (---------------)  + I miyakonojo
	0x00266b08, // n0x0a34 c0x0000 (---------------)  + I miyazaki
	0x0031ef09, // n0x0a35 c0x0000 (---------------)  + I morotsuka
	0x002d8388, // n0x0a36 c0x0000 (---------------)  + I nichinan
	0x00286309, // n0x0a37 c0x0000 (---------------)  + I nishimera
	0x00243ac7, // n0x0a38 c0x0000 (---------------)  + I nobeoka
	0x002defc5, // n0x0a39 c0x0000 (---------------)  + I saito
	0x00288d86, // n0x0a3a c0x0000 (---------------)  + I shiiba
	0x002dad08, // n0x0a3b c0x0000 (---------------)  + I shintomi
	0x00328cc8, // n0x0a3c c0x0000 (---------------)  + I takaharu
	0x00283988, // n0x0a3d c0x0000 (---------------)  + I takanabe
	0x002e7508, // n0x0a3e c0x0000 (---------------)  + I takazaki
	0x002618c5, // n0x0a3f c0x0000 (---------------)  + I tsuno
	0x00206c44, // n0x0a40 c0x0000 (---------------)  + I achi
	0x00307e08, // n0x0a41 c0x0000 (---------------)  + I agematsu
	0x00200944, // n0x0a42 c0x0000 (---------------)  + I anan
	0x00308504, // n0x0a43 c0x0000 (---------------)  + I aoki
	0x002ad245, // n0x0a44 c0x0000 (---------------)  + I asahi
	0x0027d387, // n0x0a45 c0x0000 (---------------)  + I azumino
	0x0021da49, // n0x0a46 c0x0000 (---------------)  + I chikuhoku
	0x00227387, // n0x0a47 c0x0000 (---------------)  + I chikuma
	0x00219985, // n0x0a48 c0x0000 (---------------)  + I chino
	0x00269346, // n0x0a49 c0x0000 (---------------)  + I fujimi
	0x002744c6, // n0x0a4a c0x0000 (---------------)  + I hakuba
	0x00209704, // n0x0a4b c0x0000 (---------------)  + I hara
	0x0028c546, // n0x0a4c c0x0000 (---------------)  + I hiraya
	0x002a2fc4, // n0x0a4d c0x0000 (---------------)  + I iida
	0x0027c9c6, // n0x0a4e c0x0000 (---------------)  + I iijima
	0x00204546, // n0x0a4f c0x0000 (---------------)  + I iiyama
	0x00304946, // n0x0a50 c0x0000 (---------------)  + I iizuna
	0x00244305, // n0x0a51 c0x0000 (---------------)  + I ikeda
	0x00296d07, // n0x0a52 c0x0000 (---------------)  + I ikusaka
	0x00203303, // n0x0a53 c0x0000 (---------------)  + I ina
	0x002e6009, // n0x0a54 c0x0000 (---------------)  + I karuizawa
	0x002e3408, // n0x0a55 c0x0000 (---------------)  + I kawakami
	0x00239184, // n0x0a56 c0x0000 (---------------)  + I kiso
	0x0023918d, // n0x0a57 c0x0000 (---------------)  + I kisofukushima
	0x0027f648, // n0x0a58 c0x0000 (---------------)  + I kitaaiki
	0x002b3dc8, // n0x0a59 c0x0000 (---------------)  + I komagane
	0x0031ee86, // n0x0a5a c0x0000 (---------------)  + I komoro
	0x0032c009, // n0x0a5b c0x0000 (---------------)  + I matsukawa
	0x002a3dc9, // n0x0a5c c0x0000 (---------------)  + I matsumoto
	0x0022e245, // n0x0a5d c0x0000 (---------------)  + I miasa
	0x002849ca, // n0x0a5e c0x0000 (---------------)  + I minamiaiki
	0x0024bf0a, // n0x0a5f c0x0000 (---------------)  + I minamimaki
	0x0025f54c, // n0x0a60 c0x0000 (---------------)  + I minamiminowa
	0x0025f6c6, // n0x0a61 c0x0000 (---------------)  + I minowa
	0x00269806, // n0x0a62 c0x0000 (---------------)  + I miyada
	0x002b3446, // n0x0a63 c0x0000 (---------------)  + I miyota
	0x0025b8c9, // n0x0a64 c0x0000 (---------------)  + I mochizuki
	0x003082c6, // n0x0a65 c0x0000 (---------------)  + I nagano
	0x0021c986, // n0x0a66 c0x0000 (---------------)  + I nagawa
	0x002bb5c6, // n0x0a67 c0x0000 (---------------)  + I nagiso
	0x0028a488, // n0x0a68 c0x0000 (---------------)  + I nakagawa
	0x0020cbc6, // n0x0a69 c0x0000 (---------------)  + I nakano
	0x0029b9cb, // n0x0a6a c0x0000 (---------------)  + I nozawaonsen
	0x0027d505, // n0x0a6b c0x0000 (---------------)  + I obuse
	0x00230d45, // n0x0a6c c0x0000 (---------------)  + I ogawa
	0x00269a85, // n0x0a6d c0x0000 (---------------)  + I okaya
	0x0021f706, // n0x0a6e c0x0000 (---------------)  + I omachi
	0x002165c3, // n0x0a6f c0x0000 (---------------)  + I omi
	0x0023ec46, // n0x0a70 c0x0000 (---------------)  + I ookuwa
	0x0025a0c7, // n0x0a71 c0x0000 (---------------)  + I ooshika
	0x002a8b45, // n0x0a72 c0x0000 (---------------)  + I otaki
	0x0025c605, // n0x0a73 c0x0000 (---------------)  + I otari
	0x00299045, // n0x0a74 c0x0000 (---------------)  + I sakae
	0x002d2fc6, // n0x0a75 c0x0000 (---------------)  + I sakaki
	0x00223584, // n0x0a76 c0x0000 (---------------)  + I saku
	0x0032a646, // n0x0a77 c0x0000 (---------------)  + I sakuho
	0x002d6d89, // n0x0a78 c0x0000 (---------------)  + I shimosuwa
	0x0021f58c, // n0x0a79 c0x0000 (---------------)  + I shinanomachi
	0x002db748, // n0x0a7a c0x0000 (---------------)  + I shiojiri
	0x00258344, // n0x0a7b c0x0000 (---------------)  + I suwa
	0x002c91c6, // n0x0a7c c0x0000 (---------------)  + I suzaka
	0x0029b846, // n0x0a7d c0x0000 (---------------)  + I takagi
	0x0027e3c8, // n0x0a7e c0x0000 (---------------)  + I takamori
	0x002e3dc8, // n0x0a7f c0x0000 (---------------)  + I takayama
	0x0021f489, // n0x0a80 c0x0000 (---------------)  + I tateshina
	0x00261847, // n0x0a81 c0x0000 (---------------)  + I tatsuno
	0x00291fc9, // n0x0a82 c0x0000 (---------------)  + I togakushi
	0x0026fa46, // n0x0a83 c0x0000 (---------------)  + I togura
	0x00266a84, // n0x0a84 c0x0000 (---------------)  + I tomi
	0x002a2dc4, // n0x0a85 c0x0000 (---------------)  + I ueda
	0x00273344, // n0x0a86 c0x0000 (---------------)  + I wada
	0x0026ee08, // n0x0a87 c0x0000 (---------------)  + I yamagata
	0x0021d88a, // n0x0a88 c0x0000 (---------------)  + I yamanouchi
	0x00306306, // n0x0a89 c0x0000 (---------------)  + I yasaka
	0x00311287, // n0x0a8a c0x0000 (---------------)  + I yasuoka
	0x0024e287, // n0x0a8b c0x0000 (---------------)  + I chijiwa
	0x00295145, // n0x0a8c c0x0000 (---------------)  + I futsu
	0x002d9904, // n0x0a8d c0x0000 (---------------)  + I goto
	0x0027a146, // n0x0a8e c0x0000 (---------------)  + I hasami
	0x0029c286, // n0x0a8f c0x0000 (---------------)  + I hirado
	0x0020aec3, // n0x0a90 c0x0000 (---------------)  + I iki
	0x002e3247, // n0x0a91 c0x0000 (---------------)  + I isahaya
	0x00232c48, // n0x0a92 c0x0000 (---------------)  + I kawatana
	0x0022e38a, // n0x0a93 c0x0000 (---------------)  + I kuchinotsu
	0x002b1d48, // n0x0a94 c0x0000 (---------------)  + I matsuura
	0x002f0f48, // n0x0a95 c0x0000 (---------------)  + I nagasaki
	0x00308905, // n0x0a96 c0x0000 (---------------)  + I obama
	0x0029c3c5, // n0x0a97 c0x0000 (---------------)  + I omura
	0x00291f05, // n0x0a98 c0x0000 (---------------)  + I oseto
	0x00295506, // n0x0a99 c0x0000 (---------------)  + I saikai
	0x002be346, // n0x0a9a c0x0000 (---------------)  + I sasebo
	0x002bf145, // n0x0a9b c0x0000 (---------------)  + I seihi
	0x0022fc49, // n0x0a9c c0x0000 (---------------)  + I shimabara
	0x002d970c, // n0x0a9d c0x0000 (---------------)  + I shinkamigoto
	0x00247f47, // n0x0a9e c0x0000 (---------------)  + I togitsu
	0x00280788, // n0x0a9f c0x0000 (---------------)  + I tsushima
	0x0026ebc5, // n0x0aa0 c0x0000 (---------------)  + I unzen
	0x0074a404, // n0x0aa1 c0x0001 (---------------)  ! I city
	0x00239f04, // n0x0aa2 c0x0000 (---------------)  + I ando
	0x00327f44, // n0x0aa3 c0x0000 (---------------)  + I gose
	0x002577c6, // n0x0aa4 c0x0000 (---------------)  + I heguri
	0x0028824e, // n0x0aa5 c0x0000 (---------------)  + I higashiyoshino
	0x002c7f87, // n0x0aa6 c0x0000 (---------------)  + I ikaruga
	0x002caa85, // n0x0aa7 c0x0000 (---------------)  + I ikoma
	0x00245a8c, // n0x0aa8 c0x0000 (---------------)  + I kamikitayama
	0x002dd287, // n0x0aa9 c0x0000 (---------------)  + I kanmaki
	0x00347047, // n0x0aaa c0x0000 (---------------)  + I kashiba
	0x002095c9, // n0x0aab c0x0000 (---------------)  + I kashihara
	0x00254749, // n0x0aac c0x0000 (---------------)  + I katsuragi
	0x0026e445, // n0x0aad c0x0000 (---------------)  + I kawai
	0x002e3408, // n0x0aae c0x0000 (---------------)  + I kawakami
	0x003195c9, // n0x0aaf c0x0000 (---------------)  + I kawanishi
	0x00298345, // n0x0ab0 c0x0000 (---------------)  + I koryo
	0x002a8a88, // n0x0ab1 c0x0000 (---------------)  + I kurotaki
	0x002e24c6, // n0x0ab2 c0x0000 (---------------)  + I mitsue
	0x00299ac6, // n0x0ab3 c0x0000 (---------------)  + I miyake
	0x003208c4, // n0x0ab4 c0x0000 (---------------)  + I nara
	0x002cad88, // n0x0ab5 c0x0000 (---------------)  + I nosegawa
	0x00262cc3, // n0x0ab6 c0x0000 (---------------)  + I oji
	0x00236a44, // n0x0ab7 c0x0000 (---------------)  + I ouda
	0x00306e45, // n0x0ab8 c0x0000 (---------------)  + I oyodo
	0x00285e07, // n0x0ab9 c0x0000 (---------------)  + I sakurai
	0x002572c5, // n0x0aba c0x0000 (---------------)  + I sango
	0x00219809, // n0x0abb c0x0000 (---------------)  + I shimoichi
	0x002d570d, // n0x0abc c0x0000 (---------------)  + I shimokitayama
	0x002d8586, // n0x0abd c0x0000 (---------------)  + I shinjo
	0x0028e844, // n0x0abe c0x0000 (---------------)  + I soni
	0x002df308, // n0x0abf c0x0000 (---------------)  + I takatori
	0x00203bca, // n0x0ac0 c0x0000 (---------------)  + I tawaramoto
	0x0027c047, // n0x0ac1 c0x0000 (---------------)  + I tenkawa
	0x002ee1c5, // n0x0ac2 c0x0000 (---------------)  + I tenri
	0x002262c3, // n0x0ac3 c0x0000 (---------------)  + I uda
	0x0028788e, // n0x0ac4 c0x0000 (---------------)  + I yamatokoriyama
	0x00245c8c, // n0x0ac5 c0x0000 (---------------)  + I yamatotakada
	0x002db587, // n0x0ac6 c0x0000 (---------------)  + I yamazoe
	0x00288407, // n0x0ac7 c0x0000 (---------------)  + I yoshino
	0x00208543, // n0x0ac8 c0x0000 (---------------)  + I aga
	0x00308305, // n0x0ac9 c0x0000 (---------------)  + I agano
	0x00327f45, // n0x0aca c0x0000 (---------------)  + I gosen
	0x002811c8, // n0x0acb c0x0000 (---------------)  + I itoigawa
	0x0027e089, // n0x0acc c0x0000 (---------------)  + I izumozaki
	0x002a8186, // n0x0acd c0x0000 (---------------)  + I joetsu
	0x0021ff44, // n0x0ace c0x0000 (---------------)  + I kamo
	0x002e3b46, // n0x0acf c0x0000 (---------------)  + I kariwa
	0x00216bcb, // n0x0ad0 c0x0000 (---------------)  + I kashiwazaki
	0x0029e48c, // n0x0ad1 c0x0000 (---------------)  + I minamiuonuma
	0x0026d547, // n0x0ad2 c0x0000 (---------------)  + I mitsuke
	0x002be745, // n0x0ad3 c0x0000 (---------------)  + I muika
	0x00276348, // n0x0ad4 c0x0000 (---------------)  + I murakami
	0x002bc7c5, // n0x0ad5 c0x0000 (---------------)  + I myoko
	0x00289107, // n0x0ad6 c0x0000 (---------------)  + I nagaoka
	0x0028db47, // n0x0ad7 c0x0000 (---------------)  + I niigata
	0x002967c5, // n0x0ad8 c0x0000 (---------------)  + I ojiya
	0x002165c3, // n0x0ad9 c0x0000 (---------------)  + I omi
	0x00215604, // n0x0ada c0x0000 (---------------)  + I sado
	0x0025bc45, // n0x0adb c0x0000 (---------------)  + I sanjo
	0x00236945, // n0x0adc c0x0000 (---------------)  + I seiro
	0x00236946, // n0x0add c0x0000 (---------------)  + I seirou
	0x002d6b88, // n0x0ade c0x0000 (---------------)  + I sekikawa
	0x003470c7, // n0x0adf c0x0000 (---------------)  + I shibata
	0x002bd406, // n0x0ae0 c0x0000 (---------------)  + I tagami
	0x00251046, // n0x0ae1 c0x0000 (---------------)  + I tainai
	0x00259686, // n0x0ae2 c0x0000 (---------------)  + I tochio
	0x0029ae09, // n0x0ae3 c0x0000 (---------------)  + I tokamachi
	0x00229a47, // n0x0ae4 c0x0000 (---------------)  + I tsubame
	0x00273ac6, // n0x0ae5 c0x0000 (---------------)  + I tsunan
	0x0029e606, // n0x0ae6 c0x0000 (---------------)  + I uonuma
	0x0030c546, // n0x0ae7 c0x0000 (---------------)  + I yahiko
	0x002d8705, // n0x0ae8 c0x0000 (---------------)  + I yoita
	0x00292786, // n0x0ae9 c0x0000 (---------------)  + I yuzawa
	0x00345945, // n0x0aea c0x0000 (---------------)  + I beppu
	0x00299708, // n0x0aeb c0x0000 (---------------)  + I bungoono
	0x0027600b, // n0x0aec c0x0000 (---------------)  + I bungotakada
	0x00279f46, // n0x0aed c0x0000 (---------------)  + I hasama
	0x0024e2c4, // n0x0aee c0x0000 (---------------)  + I hiji
	0x002dfa89, // n0x0aef c0x0000 (---------------)  + I himeshima
	0x0028a2c4, // n0x0af0 c0x0000 (---------------)  + I hita
	0x002e2448, // n0x0af1 c0x0000 (---------------)  + I kamitsue
	0x002a3807, // n0x0af2 c0x0000 (---------------)  + I kokonoe
	0x00249084, // n0x0af3 c0x0000 (---------------)  + I kuju
	0x002a4a48, // n0x0af4 c0x0000 (---------------)  + I kunisaki
	0x002aa344, // n0x0af5 c0x0000 (---------------)  + I kusu
	0x002d8744, // n0x0af6 c0x0000 (---------------)  + I oita
	0x00273145, // n0x0af7 c0x0000 (---------------)  + I saiki
	0x002cb846, // n0x0af8 c0x0000 (---------------)  + I taketa
	0x002c3b87, // n0x0af9 c0x0000 (---------------)  + I tsukumi
	0x002159c3, // n0x0afa c0x0000 (---------------)  + I usa
	0x00286d05, // n0x0afb c0x0000 (---------------)  + I usuki
	0x0026e004, // n0x0afc c0x0000 (---------------)  + I yufu
	0x002bbf06, // n0x0afd c0x0000 (---------------)  + I akaiwa
	0x0022e2c8, // n0x0afe c0x0000 (---------------)  + I asakuchi
	0x0030c245, // n0x0aff c0x0000 (---------------)  + I bizen
	0x0027ce89, // n0x0b00 c0x0000 (---------------)  + I hayashima
	0x0025e6c5, // n0x0b01 c0x0000 (---------------)  + I ibara
	0x00236308, // n0x0b02 c0x0000 (---------------)  + I kagamino
	0x00319307, // n0x0b03 c0x0000 (---------------)  + I kasaoka
	0x0022aec8, // n0x0b04 c0x0000 (---------------)  + I kibichuo
	0x002a4107, // n0x0b05 c0x0000 (---------------)  + I kumenan
	0x00332589, // n0x0b06 c0x0000 (---------------)  + I kurashiki
	0x00237c06, // n0x0b07 c0x0000 (---------------)  + I maniwa
	0x002cc706, // n0x0b08 c0x0000 (---------------)  + I misaki
	0x002bb5c4, // n0x0b09 c0x0000 (---------------)  + I nagi
	0x002e4d45, // n0x0b0a c0x0000 (---------------)  + I niimi
	0x0021a0cc, // n0x0b0b c0x0000 (---------------)  + I nishiawakura
	0x00269a87, // n0x0b0c c0x0000 (---------------)  + I okayama
	0x0026a247, // n0x0b0d c0x0000 (---------------)  + I satosho
	0x0024e148, // n0x0b0e c0x0000 (---------------)  + I setouchi
	0x002d8586, // n0x0b0f c0x0000 (---------------)  + I shinjo
	0x0026a344, // n0x0b10 c0x0000 (---------------)  + I shoo
	0x003139c4, // n0x0b11 c0x0000 (---------------)  + I soja
	0x002b4649, // n0x0b12 c0x0000 (---------------)  + I takahashi
	0x002b3546, // n0x0b13 c0x0000 (---------------)  + I tamano
	0x00280d47, // n0x0b14 c0x0000 (---------------)  + I tsuyama
	0x00341fc4, // n0x0b15 c0x0000 (---------------)  + I wake
	0x0027b506, // n0x0b16 c0x0000 (---------------)  + I yakage
	0x00209b05, // n0x0b17 c0x0000 (---------------)  + I aguni
	0x0028d9c7, // n0x0b18 c0x0000 (---------------)  + I ginowan
	0x0029b946, // n0x0b19 c0x0000 (---------------)  + I ginoza
	0x00277849, // n0x0b1a c0x0000 (---------------)  + I gushikami
	0x00310887, // n0x0b1b c0x0000 (---------------)  + I haebaru
	0x00256207, // n0x0b1c c0x0000 (---------------)  + I higashi
	0x0028c086, // n0x0b1d c0x0000 (---------------)  + I hirara
	0x0030cbc5, // n0x0b1e c0x0000 (---------------)  + I iheya
	0x0026ddc8, // n0x0b1f c0x0000 (---------------)  + I ishigaki
	0x0026c948, // n0x0b20 c0x0000 (---------------)  + I ishikawa
	0x00303186, // n0x0b21 c0x0000 (---------------)  + I itoman
	0x0030c285, // n0x0b22 c0x0000 (---------------)  + I izena
	0x002a83c6, // n0x0b23 c0x0000 (---------------)  + I kadena
	0x00204d83, // n0x0b24 c0x0000 (---------------)  + I kin
	0x00281049, // n0x0b25 c0x0000 (---------------)  + I kitadaito
	0x00286dce, // n0x0b26 c0x0000 (---------------)  + I kitanakagusuku
	0x002a3c48, // n0x0b27 c0x0000 (---------------)  + I kumejima
	0x0032ecc8, // n0x0b28 c0x0000 (---------------)  + I kunigami
	0x00302f8b, // n0x0b29 c0x0000 (---------------)  + I minamidaito
	0x0027d0c6, // n0x0b2a c0x0000 (---------------)  + I motobu
	0x00208284, // n0x0b2b c0x0000 (---------------)  + I nago
	0x00237a84, // n0x0b2c c0x0000 (---------------)  + I naha
	0x00286eca, // n0x0b2d c0x0000 (---------------)  + I nakagusuku
	0x00215c47, // n0x0b2e c0x0000 (---------------)  + I nakijin
	0x00273b85, // n0x0b2f c0x0000 (---------------)  + I nanjo
	0x00220c49, // n0x0b30 c0x0000 (---------------)  + I nishihara
	0x002a7145, // n0x0b31 c0x0000 (---------------)  + I ogimi
	0x00308547, // n0x0b32 c0x0000 (---------------)  + I okinawa
	0x00202e84, // n0x0b33 c0x0000 (---------------)  + I onna
	0x002d5187, // n0x0b34 c0x0000 (---------------)  + I shimoji
	0x002f7f88, // n0x0b35 c0x0000 (---------------)  + I taketomi
	0x002dea86, // n0x0b36 c0x0000 (---------------)  + I tarama
	0x002b2489, // n0x0b37 c0x0000 (---------------)  + I tokashiki
	0x002a5aca, // n0x0b38 c0x0000 (---------------)  + I tomigusuku
	0x00215bc6, // n0x0b39 c0x0000 (---------------)  + I tonaki
	0x0027f186, // n0x0b3a c0x0000 (---------------)  + I urasoe
	0x00295a05, // n0x0b3b c0x0000 (---------------)  + I uruma
	0x0032af85, // n0x0b3c c0x0000 (---------------)  + I yaese
	0x00327207, // n0x0b3d c0x0000 (---------------)  + I yomitan
	0x00346748, // n0x0b3e c0x0000 (---------------)  + I yonabaru
	0x00209a48, // n0x0b3f c0x0000 (---------------)  + I yonaguni
	0x00258f06, // n0x0b40 c0x0000 (---------------)  + I zamami
	0x00338405, // n0x0b41 c0x0000 (---------------)  + I abeno
	0x002ad94e, // n0x0b42 c0x0000 (---------------)  + I chihayaakasaka
	0x0022afc4, // n0x0b43 c0x0000 (---------------)  + I chuo
	0x00281145, // n0x0b44 c0x0000 (---------------)  + I daito
	0x00268cc9, // n0x0b45 c0x0000 (---------------)  + I fujiidera
	0x0026e248, // n0x0b46 c0x0000 (---------------)  + I habikino
	0x00277306, // n0x0b47 c0x0000 (---------------)  + I hannan
	0x00282c4c, // n0x0b48 c0x0000 (---------------)  + I higashiosaka
	0x002844d0, // n0x0b49 c0x0000 (---------------)  + I higashisumiyoshi
	0x00287e8f, // n0x0b4a c0x0000 (---------------)  + I higashiyodogawa
	0x0028b388, // n0x0b4b c0x0000 (---------------)  + I hirakata
	0x00327887, // n0x0b4c c0x0000 (---------------)  + I ibaraki
	0x00244305, // n0x0b4d c0x0000 (---------------)  + I ikeda
	0x00225a45, // n0x0b4e c0x0000 (---------------)  + I izumi
	0x00225a49, // n0x0b4f c0x0000 (---------------)  + I izumiotsu
	0x00347f89, // n0x0b50 c0x0000 (---------------)  + I izumisano
	0x0021c206, // n0x0b51 c0x0000 (---------------)  + I kadoma
	0x002f2107, // n0x0b52 c0x0000 (---------------)  + I kaizuka
	0x00200905, // n0x0b53 c0x0000 (---------------)  + I kanan
	0x00210389, // n0x0b54 c0x0000 (---------------)  + I kashiwara
	0x0032bd06, // n0x0b55 c0x0000 (---------------)  + I katano
	0x0030810d, // n0x0b56 c0x0000 (---------------)  + I kawachinagano
	0x00273209, // n0x0b57 c0x0000 (---------------)  + I kishiwada
	0x0021de44, // n0x0b58 c0x0000 (---------------)  + I kita
	0x002a39c8, // n0x0b59 c0x0000 (---------------)  + I kumatori
	0x00307ec9, // n0x0b5a c0x0000 (---------------)  + I matsubara
	0x003064c6, // n0x0b5b c0x0000 (---------------)  + I minato
	0x00269445, // n0x0b5c c0x0000 (---------------)  + I minoh
	0x002cc706, // n0x0b5d c0x0000 (---------------)  + I misaki
	0x002b12c9, // n0x0b5e c0x0000 (---------------)  + I moriguchi
	0x002b4048, // n0x0b5f c0x0000 (---------------)  + I neyagawa
	0x0021a0c5, // n0x0b60 c0x0000 (---------------)  + I nishi
	0x00219a44, // n0x0b61 c0x0000 (---------------)  + I nose
	0x00282e0b, // n0x0b62 c0x0000 (---------------)  + I osakasayama
	0x00306385, // n0x0b63 c0x0000 (---------------)  + I sakai
	0x00248bc6, // n0x0b64 c0x0000 (---------------)  + I sayama
	0x002587c6, // n0x0b65 c0x0000 (---------------)  + I sennan
	0x002fff06, // n0x0b66 c0x0000 (---------------)  + I settsu
	0x0030c7cb, // n0x0b67 c0x0000 (---------------)  + I shijonawate
	0x0027cf89, // n0x0b68 c0x0000 (---------------)  + I shimamoto
	0x00341885, // n0x0b69 c0x0000 (---------------)  + I suita
	0x0024d207, // n0x0b6a c0x0000 (---------------)  + I tadaoka
	0x00227006, // n0x0b6b c0x0000 (---------------)  + I taishi
	0x0026f886, // n0x0b6c c0x0000 (---------------)  + I tajiri
	0x00327cc8, // n0x0b6d c0x0000 (---------------)  + I takaishi
	0x002630c9, // n0x0b6e c0x0000 (---------------)  + I takatsuki
	0x002be90c, // n0x0b6f c0x0000 (---------------)  + I tondabayashi
	0x0024f208, // n0x0b70 c0x0000 (---------------)  + I toyonaka
	0x00253246, // n0x0b71 c0x0000 (---------------)  + I toyono
	0x002c90c3, // n0x0b72 c0x0000 (---------------)  + I yao
	0x00218046, // n0x0b73 c0x0000 (---------------)  + I ariake
	0x00288bc5, // n0x0b74 c0x0000 (---------------)  + I arita
	0x0026c1c8, // n0x0b75 c0x0000 (---------------)  + I fukudomi
	0x00222c46, // n0x0b76 c0x0000 (---------------)  + I genkai
	0x00243e88, // n0x0b77 c0x0000 (---------------)  + I hamatama
	0x00322d45, // n0x0b78 c0x0000 (---------------)  + I hizen
	0x00323945, // n0x0b79 c0x0000 (---------------)  + I imari
	0x002f2448, // n0x0b7a c0x0000 (---------------)  + I kamimine
	0x0029b507, // n0x0b7b c0x0000 (---------------)  + I kanzaki
	0x002bd047, // n0x0b7c c0x0000 (---------------)  + I karatsu
	0x002cb9c7, // n0x0b7d c0x0000 (---------------)  + I kashima
	0x00328b48, // n0x0b7e c0x0000 (---------------)  + I kitagata
	0x003279c8, // n0x0b7f c0x0000 (---------------)  + I kitahata
	0x002911c6, // n0x0b80 c0x0000 (---------------)  + I kiyama
	0x0029c6c7, // n0x0b81 c0x0000 (---------------)  + I kouhoku
	0x002ad487, // n0x0b82 c0x0000 (---------------)  + I kyuragi
	0x00288a8a, // n0x0b83 c0x0000 (---------------)  + I nishiarita
	0x0020e983, // n0x0b84 c0x0000 (---------------)  + I ogi
	0x0021f706, // n0x0b85 c0x0000 (---------------)  + I omachi
	0x0021d9c5, // n0x0b86 c0x0000 (---------------)  + I ouchi
	0x00262184, // n0x0b87 c0x0000 (---------------)  + I saga
	0x0026a749, // n0x0b88 c0x0000 (---------------)  + I shiroishi
	0x00332504, // n0x0b89 c0x0000 (---------------)  + I taku
	0x00200144, // n0x0b8a c0x0000 (---------------)  + I tara
	0x00284d44, // n0x0b8b c0x0000 (---------------)  + I tosu
	0x0028840b, // n0x0b8c c0x0000 (---------------)  + I yoshinogari
	0x00308047, // n0x0b8d c0x0000 (---------------)  + I arakawa
	0x002adb85, // n0x0b8e c0x0000 (---------------)  + I asaka
	0x002bf3c8, // n0x0b8f c0x0000 (---------------)  + I chichibu
	0x00269346, // n0x0b90 c0x0000 (---------------)  + I fujimi
	0x00269348, // n0x0b91 c0x0000 (---------------)  + I fujimino
	0x0026b506, // n0x0b92 c0x0000 (---------------)  + I fukaya
	0x00278005, // n0x0b93 c0x0000 (---------------)  + I hanno
	0x00278545, // n0x0b94 c0x0000 (---------------)  + I hanyu
	0x0027a786, // n0x0b95 c0x0000 (---------------)  + I hasuda
	0x0027b388, // n0x0b96 c0x0000 (---------------)  + I hatogaya
	0x0027b688, // n0x0b97 c0x0000 (---------------)  + I hatoyama
	0x0026a906, // n0x0b98 c0x0000 (---------------)  + I hidaka
	0x002bf20f, // n0x0b99 c0x0000 (---------------)  + I higashichichibu
	0x00280b10, // n0x0b9a c0x0000 (---------------)  + I higashimatsuyama
	0x00224605, // n0x0b9b c0x0000 (---------------)  + I honjo
	0x00203303, // n0x0b9c c0x0000 (---------------)  + I ina
	0x002f1985, // n0x0b9d c0x0000 (---------------)  + I iruma
	0x00297488, // n0x0b9e c0x0000 (---------------)  + I iwatsuki
	0x00347e89, // n0x0b9f c0x0000 (---------------)  + I kamiizumi
	0x002aedc8, // n0x0ba0 c0x0000 (---------------)  + I kamikawa
	0x0031f0c8, // n0x0ba1 c0x0000 (---------------)  + I kamisato
	0x00218448, // n0x0ba2 c0x0000 (---------------)  + I kasukabe
	0x002adc47, // n0x0ba3 c0x0000 (---------------)  + I kawagoe
	0x00269009, // n0x0ba4 c0x0000 (---------------)  + I kawaguchi
	0x00244088, // n0x0ba5 c0x0000 (---------------)  + I kawajima
	0x00234e04, // n0x0ba6 c0x0000 (---------------)  + I kazo
	0x00284bc8, // n0x0ba7 c0x0000 (---------------)  + I kitamoto
	0x00250cc9, // n0x0ba8 c0x0000 (---------------)  + I koshigaya
	0x0029cc87, // n0x0ba9 c0x0000 (---------------)  + I kounosu
	0x002a5cc4, // n0x0baa c0x0000 (---------------)  + I kuki
	0x00227448, // n0x0bab c0x0000 (---------------)  + I kumagaya
	0x00296aca, // n0x0bac c0x0000 (---------------)  + I matsubushi
	0x002b2dc6, // n0x0bad c0x0000 (---------------)  + I minano
	0x00235ec6, // n0x0bae c0x0000 (---------------)  + I misato
	0x00323009, // n0x0baf c0x0000 (---------------)  + I miyashiro
	0x00284707, // n0x0bb0 c0x0000 (---------------)  + I miyoshi
	0x002b8408, // n0x0bb1 c0x0000 (---------------)  + I moroyama
	0x00240008, // n0x0bb2 c0x0000 (---------------)  + I nagatoro
	0x0022ab48, // n0x0bb3 c0x0000 (---------------)  + I namegawa
	0x002d4545, // n0x0bb4 c0x0000 (---------------)  + I niiza
	0x00239845, // n0x0bb5 c0x0000 (---------------)  + I ogano
	0x00230d45, // n0x0bb6 c0x0000 (---------------)  + I ogawa
	0x00327f05, // n0x0bb7 c0x0000 (---------------)  + I ogose
	0x002d4fc7, // n0x0bb8 c0x0000 (---------------)  + I okegawa
	0x002165c5, // n0x0bb9 c0x0000 (---------------)  + I omiya
	0x002a8b45, // n0x0bba c0x0000 (---------------)  + I otaki
	0x00319c46, // n0x0bbb c0x0000 (---------------)  + I ranzan
	0x002aed07, // n0x0bbc c0x0000 (---------------)  + I ryokami
	0x002aab87, // n0x0bbd c0x0000 (---------------)  + I saitama
	0x00296dc6, // n0x0bbe c0x0000 (---------------)  + I sakado
	0x002c25c5, // n0x0bbf c0x0000 (---------------)  + I satte
	0x00248bc6, // n0x0bc0 c0x0000 (---------------)  + I sayama
	0x0021fd05, // n0x0bc1 c0x0000 (---------------)  + I shiki
	0x002dd108, // n0x0bc2 c0x0000 (---------------)  + I shiraoka
	0x00200884, // n0x0bc3 c0x0000 (---------------)  + I soka
	0x002b2386, // n0x0bc4 c0x0000 (---------------)  + I sugito
	0x0020fd44, // n0x0bc5 c0x0000 (---------------)  + I toda
	0x0034b648, // n0x0bc6 c0x0000 (---------------)  + I tokigawa
	0x002d9c4a, // n0x0bc7 c0x0000 (---------------)  + I tokorozawa
	0x00202a8c, // n0x0bc8 c0x0000 (---------------)  + I tsurugashima
	0x0021b805, // n0x0bc9 c0x0000 (---------------)  + I urawa
	0x002ca946, // n0x0bca c0x0000 (---------------)  + I warabi
	0x002beac6, // n0x0bcb c0x0000 (---------------)  + I yashio
	0x00318706, // n0x0bcc c0x0000 (---------------)  + I yokoze
	0x002532c4, // n0x0bcd c0x0000 (---------------)  + I yono
	0x00210245, // n0x0bce c0x0000 (---------------)  + I yorii
	0x0026b347, // n0x0bcf c0x0000 (---------------)  + I yoshida
	0x00284789, // n0x0bd0 c0x0000 (---------------)  + I yoshikawa
	0x0028ecc7, // n0x0bd1 c0x0000 (---------------)  + I yoshimi
	0x0074a404, // n0x0bd2 c0x0001 (---------------)  ! I city
	0x0074a404, // n0x0bd3 c0x0001 (---------------)  ! I city
	0x0033f385, // n0x0bd4 c0x0000 (---------------)  + I aisho
	0x00236f84, // n0x0bd5 c0x0000 (---------------)  + I gamo
	0x0028260a, // n0x0bd6 c0x0000 (---------------)  + I higashiomi
	0x002691c6, // n0x0bd7 c0x0000 (---------------)  + I hikone
	0x002458c4, // n0x0bd8 c0x0000 (---------------)  + I koka
	0x002e69c5, // n0x0bd9 c0x0000 (---------------)  + I konan
	0x00299e45, // n0x0bda c0x0000 (---------------)  + I kosei
	0x0029c184, // n0x0bdb c0x0000 (---------------)  + I koto
	0x0026ffc7, // n0x0bdc c0x0000 (---------------)  + I kusatsu
	0x0025e647, // n0x0bdd c0x0000 (---------------)  + I maibara
	0x002b7608, // n0x0bde c0x0000 (---------------)  + I moriyama
	0x002a84c8, // n0x0bdf c0x0000 (---------------)  + I nagahama
	0x0021d5c9, // n0x0be0 c0x0000 (---------------)  + I nishiazai
	0x00305988, // n0x0be1 c0x0000 (---------------)  + I notogawa
	0x002827cb, // n0x0be2 c0x0000 (---------------)  + I omihachiman
	0x00202a44, // n0x0be3 c0x0000 (---------------)  + I otsu
	0x0026f985, // n0x0be4 c0x0000 (---------------)  + I ritto
	0x00285185, // n0x0be5 c0x0000 (---------------)  + I ryuoh
	0x002cb949, // n0x0be6 c0x0000 (---------------)  + I takashima
	0x002630c9, // n0x0be7 c0x0000 (---------------)  + I takatsuki
	0x002df988, // n0x0be8 c0x0000 (---------------)  + I torahime
	0x00259248, // n0x0be9 c0x0000 (---------------)  + I toyosato
	0x002f1d04, // n0x0bea c0x0000 (---------------)  + I yasu
	0x0029b885, // n0x0beb c0x0000 (---------------)  + I akagi
	0x00204603, // n0x0bec c0x0000 (---------------)  + I ama
	0x00239045, // n0x0bed c0x0000 (---------------)  + I gotsu
	0x0028ee86, // n0x0bee c0x0000 (---------------)  + I hamada
	0x0027decc, // n0x0bef c0x0000 (---------------)  + I higashiizumo
	0x00235d46, // n0x0bf0 c0x0000 (---------------)  + I hikawa
	0x0021fd46, // n0x0bf1 c0x0000 (---------------)  + I hikimi
	0x00277585, // n0x0bf2 c0x0000 (---------------)  + I izumo
	0x002d3048, // n0x0bf3 c0x0000 (---------------)  + I kakinoki
	0x0029de86, // n0x0bf4 c0x0000 (---------------)  + I masuda
	0x00302986, // n0x0bf5 c0x0000 (---------------)  + I matsue
	0x00235ec6, // n0x0bf6 c0x0000 (---------------)  + I misato
	0x0022d6cc, // n0x0bf7 c0x0000 (---------------)  + I nishinoshima
	0x00260744, // n0x0bf8 c0x0000 (---------------)  + I ohda
	0x002597ca, // n0x0bf9 c0x0000 (---------------)  + I okinoshima
	0x002774c8, // n0x0bfa c0x0000 (---------------)  + I okuizumo
	0x0027dd07, // n0x0bfb c0x0000 (---------------)  + I shimane
	0x002afb46, // n0x0bfc c0x0000 (---------------)  + I tamayu
	0x00258307, // n0x0bfd c0x0000 (---------------)  + I tsuwano
	0x002cfbc5, // n0x0bfe c0x0000 (---------------)  + I unnan
	0x0028c646, // n0x0bff c0x0000 (---------------)  + I yakumo
	0x0030fc86, // n0x0c00 c0x0000 (---------------)  + I yasugi
	0x00315b87, // n0x0c01 c0x0000 (---------------)  + I yatsuka
	0x00296184, // n0x0c02 c0x0000 (---------------)  + I arai
	0x002d4a45, // n0x0c03 c0x0000 (---------------)  + I atami
	0x00268cc4, // n0x0c04 c0x0000 (---------------)  + I fuji
	0x002dba87, // n0x0c05 c0x0000 (---------------)  + I fujieda
	0x00268f08, // n0x0c06 c0x0000 (---------------)  + I fujikawa
	0x0026968a, // n0x0c07 c0x0000 (---------------)  + I fujinomiya
	0x0026dc47, // n0x0c08 c0x0000 (---------------)  + I fukuroi
	0x0022d107, // n0x0c09 c0x0000 (---------------)  + I gotemba
	0x00327807, // n0x0c0a c0x0000 (---------------)  + I haibara
	0x002bc909, // n0x0c0b c0x0000 (---------------)  + I hamamatsu
	0x0027deca, // n0x0c0c c0x0000 (---------------)  + I higashiizu
	0x00231dc3, // n0x0c0d c0x0000 (---------------)  + I ito
	0x00297045, // n0x0c0e c0x0000 (---------------)  + I iwata
	0x00215943, // n0x0c0f c0x0000 (---------------)  + I izu
	0x00311749, // n0x0c10 c0x0000 (---------------)  + I izunokuni
	0x0024d7c8, // n0x0c11 c0x0000 (---------------)  + I kakegawa
	0x002e0307, // n0x0c12 c0x0000 (---------------)  + I kannami
	0x002aeec9, // n0x0c13 c0x0000 (---------------)  + I kawanehon
	0x0026ca46, // n0x0c14 c0x0000 (---------------)  + I kawazu
	0x00222408, // n0x0c15 c0x0000 (---------------)  + I kikugawa
	0x00298d85, // n0x0c16 c0x0000 (---------------)  + I kosai
	0x00273dca, // n0x0c17 c0x0000 (---------------)  + I makinohara
	0x002b7789, // n0x0c18 c0x0000 (---------------)  + I matsuzaki
	0x002435c9, // n0x0c19 c0x0000 (---------------)  + I minamiizu
	0x002b1c07, // n0x0c1a c0x0000 (---------------)  + I mishima
	0x0027cbc9, // n0x0c1b c0x0000 (---------------)  + I morimachi
	0x00304848, // n0x0c1c c0x0000 (---------------)  + I nishiizu
	0x002e57c6, // n0x0c1d c0x0000 (---------------)  + I numazu
	0x002cab08, // n0x0c1e c0x0000 (---------------)  + I omaezaki
	0x00265187, // n0x0c1f c0x0000 (---------------)  + I shimada
	0x00231f07, // n0x0c20 c0x0000 (---------------)  + I shimizu
	0x0025a347, // n0x0c21 c0x0000 (---------------)  + I shimoda
	0x002e0188, // n0x0c22 c0x0000 (---------------)  + I shizuoka
	0x002dc2c6, // n0x0c23 c0x0000 (---------------)  + I susono
	0x00296885, // n0x0c24 c0x0000 (---------------)  + I yaizu
	0x0026b347, // n0x0c25 c0x0000 (---------------)  + I yoshida
	0x0027ec88, // n0x0c26 c0x0000 (---------------)  + I ashikaga
	0x0033da44, // n0x0c27 c0x0000 (---------------)  + I bato
	0x00312d44, // n0x0c28 c0x0000 (---------------)  + I haga
	0x002e3607, // n0x0c29 c0x0000 (---------------)  + I ichikai
	0x003074c7, // n0x0c2a c0x0000 (---------------)  + I iwafune
	0x0031944a, // n0x0c2b c0x0000 (---------------)  + I kaminokawa
	0x002e5746, // n0x0c2c c0x0000 (---------------)  + I kanuma
	0x003113ca, // n0x0c2d c0x0000 (---------------)  + I karasuyama
	0x002a75c7, // n0x0c2e c0x0000 (---------------)  + I kuroiso
	0x00303747, // n0x0c2f c0x0000 (---------------)  + I mashiko
	0x00275f84, // n0x0c30 c0x0000 (---------------)  + I mibu
	0x002d5584, // n0x0c31 c0x0000 (---------------)  + I moka
	0x002204c6, // n0x0c32 c0x0000 (---------------)  + I motegi
	0x002bc344, // n0x0c33 c0x0000 (---------------)  + I nasu
	0x002bc34c, // n0x0c34 c0x0000 (---------------)  + I nasushiobara
	0x00213485, // n0x0c35 c0x0000 (---------------)  + I nikko
	0x00253ec9, // n0x0c36 c0x0000 (---------------)  + I nishikata
	0x0020e944, // n0x0c37 c0x0000 (---------------)  + I nogi
	0x0029c245, // n0x0c38 c0x0000 (---------------)  + I ohira
	0x00203b48, // n0x0c39 c0x0000 (---------------)  + I ohtawara
	0x0025d505, // n0x0c3a c0x0000 (---------------)  + I oyama
	0x00223586, // n0x0c3b c0x0000 (---------------)  + I sakura
	0x003480c4, // n0x0c3c c0x0000 (---------------)  + I sano
	0x002d7b8a, // n0x0c3d c0x0000 (---------------)  + I shimotsuke
	0x002dbc46, // n0x0c3e c0x0000 (---------------)  + I shioya
	0x0028744a, // n0x0c3f c0x0000 (---------------)  + I takanezawa
	0x0033dac7, // n0x0c40 c0x0000 (---------------)  + I tochigi
	0x0029b2c5, // n0x0c41 c0x0000 (---------------)  + I tsuga
	0x00219185, // n0x0c42 c0x0000 (---------------)  + I ujiie
	0x0029518a, // n0x0c43 c0x0000 (---------------)  + I utsunomiya
	0x002680c5, // n0x0c44 c0x0000 (---------------)  + I yaita
	0x00225a06, // n0x0c45 c0x0000 (---------------)  + I aizumi
	0x00200944, // n0x0c46 c0x0000 (---------------)  + I anan
	0x002a43c6, // n0x0c47 c0x0000 (---------------)  + I ichiba
	0x003272c5, // n0x0c48 c0x0000 (---------------)  + I itano
	0x00222d06, // n0x0c49 c0x0000 (---------------)  + I kainan
	0x002b8e4c, // n0x0c4a c0x0000 (---------------)  + I komatsushima
	0x002cbb0a, // n0x0c4b c0x0000 (---------------)  + I matsushige
	0x0024c004, // n0x0c4c c0x0000 (---------------)  + I mima
	0x00232146, // n0x0c4d c0x0000 (---------------)  + I minami
	0x00284707, // n0x0c4e c0x0000 (---------------)  + I miyoshi
	0x002bdac4, // n0x0c4f c0x0000 (---------------)  + I mugi
	0x0028a488, // n0x0c50 c0x0000 (---------------)  + I nakagawa
	0x0034b546, // n0x0c51 c0x0000 (---------------)  + I naruto
	0x002ad7c9, // n0x0c52 c0x0000 (---------------)  + I sanagochi
	0x002ddd49, // n0x0c53 c0x0000 (---------------)  + I shishikui
	0x002daac9, // n0x0c54 c0x0000 (---------------)  + I tokushima
	0x00232306, // n0x0c55 c0x0000 (---------------)  + I wajiki
	0x00265286, // n0x0c56 c0x0000 (---------------)  + I adachi
	0x002cac47, // n0x0c57 c0x0000 (---------------)  + I akiruno
	0x0022fb88, // n0x0c58 c0x0000 (---------------)  + I akishima
	0x00265089, // n0x0c59 c0x0000 (---------------)  + I aogashima
	0x00308047, // n0x0c5a c0x0000 (---------------)  + I arakawa
	0x00217c06, // n0x0c5b c0x0000 (---------------)  + I bunkyo
	0x00206c87, // n0x0c5c c0x0000 (---------------)  + I chiyoda
	0x002bfe85, // n0x0c5d c0x0000 (---------------)  + I chofu
	0x0022afc4, // n0x0c5e c0x0000 (---------------)  + I chuo
	0x002ca807, // n0x0c5f c0x0000 (---------------)  + I edogawa
	0x0033dc85, // n0x0c60 c0x0000 (---------------)  + I fuchu
	0x00273085, // n0x0c61 c0x0000 (---------------)  + I fussa
	0x0024ba87, // n0x0c62 c0x0000 (---------------)  + I hachijo
	0x00296688, // n0x0c63 c0x0000 (---------------)  + I hachioji
	0x002762c6, // n0x0c64 c0x0000 (---------------)  + I hamura
	0x0027fc4d, // n0x0c65 c0x0000 (---------------)  + I higashikurume
	0x002813cf, // n0x0c66 c0x0000 (---------------)  + I higashimurayama
	0x002876cd, // n0x0c67 c0x0000 (---------------)  + I higashiyamato
	0x002199c4, // n0x0c68 c0x0000 (---------------)  + I hino
	0x002c3846, // n0x0c69 c0x0000 (---------------)  + I hinode
	0x00320a08, // n0x0c6a c0x0000 (---------------)  + I hinohara
	0x002bb585, // n0x0c6b c0x0000 (---------------)  + I inagi
	0x00288c48, // n0x0c6c c0x0000 (---------------)  + I itabashi
	0x002c080a, // n0x0c6d c0x0000 (---------------)  + I katsushika
	0x0021de44, // n0x0c6e c0x0000 (---------------)  + I kita
	0x002dd3c6, // n0x0c6f c0x0000 (---------------)  + I kiyose
	0x002e48c7, // n0x0c70 c0x0000 (---------------)  + I kodaira
	0x0027ae07, // n0x0c71 c0x0000 (---------------)  + I koganei
	0x00220709, // n0x0c72 c0x0000 (---------------)  + I kokubunji
	0x002caac5, // n0x0c73 c0x0000 (---------------)  + I komae
	0x0029c184, // n0x0c74 c0x0000 (---------------)  + I koto
	0x0029e00a, // n0x0c75 c0x0000 (---------------)  + I kouzushima
	0x002a50c9, // n0x0c76 c0x0000 (---------------)  + I kunitachi
	0x0027ccc7, // n0x0c77 c0x0000 (---------------)  + I machida
	0x00228406, // n0x0c78 c0x0000 (---------------)  + I meguro
	0x003064c6, // n0x0c79 c0x0000 (---------------)  + I minato
	0x0029b7c6, // n0x0c7a c0x0000 (---------------)  + I mitaka
	0x0023ee46, // n0x0c7b c0x0000 (---------------)  + I mizuho
	0x002c334f, // n0x0c7c c0x0000 (---------------)  + I musashimurayama
	0x002c3709, // n0x0c7d c0x0000 (---------------)  + I musashino
	0x0020cbc6, // n0x0c7e c0x0000 (---------------)  + I nakano
	0x00323886, // n0x0c7f c0x0000 (---------------)  + I nerima
	0x00230589, // n0x0c80 c0x0000 (---------------)  + I ogasawara
	0x0029c7c7, // n0x0c81 c0x0000 (---------------)  + I okutama
	0x0020ee83, // n0x0c82 c0x0000 (---------------)  + I ome
	0x00217e86, // n0x0c83 c0x0000 (---------------)  + I oshima
	0x00200383, // n0x0c84 c0x0000 (---------------)  + I ota
	0x0033ed08, // n0x0c85 c0x0000 (---------------)  + I setagaya
	0x002e06c7, // n0x0c86 c0x0000 (---------------)  + I shibuya
	0x0028b589, // n0x0c87 c0x0000 (---------------)  + I shinagawa
	0x002d9408, // n0x0c88 c0x0000 (---------------)  + I shinjuku
	0x002bd188, // n0x0c89 c0x0000 (---------------)  + I suginami
	0x00284dc6, // n0x0c8a c0x0000 (---------------)  + I sumida
	0x00341949, // n0x0c8b c0x0000 (---------------)  + I tachikawa
	0x00247e85, // n0x0c8c c0x0000 (---------------)  + I taito
	0x00243f84, // n0x0c8d c0x0000 (---------------)  + I tama
	0x002c50c7, // n0x0c8e c0x0000 (---------------)  + I toshima
	0x0025b945, // n0x0c8f c0x0000 (---------------)  + I chizu
	0x002199c4, // n0x0c90 c0x0000 (---------------)  + I hino
	0x00272c48, // n0x0c91 c0x0000 (---------------)  + I kawahara
	0x0020b104, // n0x0c92 c0x0000 (---------------)  + I koge
	0x0029c507, // n0x0c93 c0x0000 (---------------)  + I kotoura
	0x002d3c06, // n0x0c94 c0x0000 (---------------)  + I misasa
	0x00258885, // n0x0c95 c0x0000 (---------------)  + I nanbu
	0x002d8388, // n0x0c96 c0x0000 (---------------)  + I nichinan
	0x0030638b, // n0x0c97 c0x0000 (---------------)  + I sakaiminato
	0x0031bd07, // n0x0c98 c0x0000 (---------------)  + I tottori
	0x00295406, // n0x0c99 c0x0000 (---------------)  + I wakasa
	0x002b3344, // n0x0c9a c0x0000 (---------------)  + I yazu
	0x00208206, // n0x0c9b c0x0000 (---------------)  + I yonago
	0x002ad245, // n0x0c9c c0x0000 (---------------)  + I asahi
	0x0033dc85, // n0x0c9d c0x0000 (---------------)  + I fuchu
	0x0026d449, // n0x0c9e c0x0000 (---------------)  + I fukumitsu
	0x0026fbc9, // n0x0c9f c0x0000 (---------------)  + I funahashi
	0x00231f44, // n0x0ca0 c0x0000 (---------------)  + I himi
	0x00231f85, // n0x0ca1 c0x0000 (---------------)  + I imizu
	0x00232185, // n0x0ca2 c0x0000 (---------------)  + I inami
	0x00273c46, // n0x0ca3 c0x0000 (---------------)  + I johana
	0x002e3508, // n0x0ca4 c0x0000 (---------------)  + I kamiichi
	0x002a6d06, // n0x0ca5 c0x0000 (---------------)  + I kurobe
	0x00232a8b, // n0x0ca6 c0x0000 (---------------)  + I nakaniikawa
	0x00202f0a, // n0x0ca7 c0x0000 (---------------)  + I namerikawa
	0x0029ad45, // n0x0ca8 c0x0000 (---------------)  + I nanto
	0x002785c6, // n0x0ca9 c0x0000 (---------------)  + I nyuzen
	0x00338385, // n0x0caa c0x0000 (---------------)  + I oyabe
	0x002b0805, // n0x0cab c0x0000 (---------------)  + I taira
	0x002d87c7, // n0x0cac c0x0000 (---------------)  + I takaoka
	0x002550c8, // n0x0cad c0x0000 (---------------)  + I tateyama
	0x0027b404, // n0x0cae c0x0000 (---------------)  + I toga
	0x00275e86, // n0x0caf c0x0000 (---------------)  + I tonami
	0x0025d4c6, // n0x0cb0 c0x0000 (---------------)  + I toyama
	0x00304a07, // n0x0cb1 c0x0000 (---------------)  + I unazuki
	0x0022b044, // n0x0cb2 c0x0000 (---------------)  + I uozu
	0x0026c046, // n0x0cb3 c0x0000 (---------------)  + I yamada
	0x002b0045, // n0x0cb4 c0x0000 (---------------)  + I arida
	0x002b0049, // n0x0cb5 c0x0000 (---------------)  + I aridagawa
	0x002a32c4, // n0x0cb6 c0x0000 (---------------)  + I gobo
	0x002d9a89, // n0x0cb7 c0x0000 (---------------)  + I hashimoto
	0x0026a906, // n0x0cb8 c0x0000 (---------------)  + I hidaka
	0x002a9808, // n0x0cb9 c0x0000 (---------------)  + I hirogawa
	0x00232185, // n0x0cba c0x0000 (---------------)  + I inami
	0x0024e385, // n0x0cbb c0x0000 (---------------)  + I iwade
	0x00222d06, // n0x0cbc c0x0000 (---------------)  + I kainan
	0x002be809, // n0x0cbd c0x0000 (---------------)  + I kamitonda
	0x00254749, // n0x0cbe c0x0000 (---------------)  + I katsuragi
	0x0021fdc6, // n0x0cbf c0x0000 (---------------)  + I kimino
	0x0026e348, // n0x0cc0 c0x0000 (---------------)  + I kinokawa
	0x00245b88, // n0x0cc1 c0x0000 (---------------)  + I kitayama
	0x00338344, // n0x0cc2 c0x0000 (---------------)  + I koya
	0x0029ee84, // n0x0cc3 c0x0000 (---------------)  + I koza
	0x0029ee88, // n0x0cc4 c0x0000 (---------------)  + I kozagawa
	0x002f99c8, // n0x0cc5 c0x0000 (---------------)  + I kudoyama
	0x002920c9, // n0x0cc6 c0x0000 (---------------)  + I kushimoto
	0x0028ee06, // n0x0cc7 c0x0000 (---------------)  + I mihama
	0x00235ec6, // n0x0cc8 c0x0000 (---------------)  + I misato
	0x002f634d, // n0x0cc9 c0x0000 (---------------)  + I nachikatsuura
	0x002d8086, // n0x0cca c0x0000 (---------------)  + I shingu
	0x002dbf09, // n0x0ccb c0x0000 (---------------)  + I shirahama
	0x002eb0c5, // n0x0ccc c0x0000 (---------------)  + I taiji
	0x00233446, // n0x0ccd c0x0000 (---------------)  + I tanabe
	0x00341b08, // n0x0cce c0x0000 (---------------)  + I wakayama
	0x0034ea05, // n0x0ccf c0x0000 (---------------)  + I yuasa
	0x002ad4c4, // n0x0cd0 c0x0000 (---------------)  + I yura
	0x002ad245, // n0x0cd1 c0x0000 (---------------)  + I asahi
	0x0026f708, // n0x0cd2 c0x0000 (---------------)  + I funagata
	0x002823c9, // n0x0cd3 c0x0000 (---------------)  + I higashine
	0x00268d84, // n0x0cd4 c0x0000 (---------------)  + I iide
	0x002528c6, // n0x0cd5 c0x0000 (---------------)  + I kahoku
	0x0034740a, // n0x0cd6 c0x0000 (---------------)  + I kaminoyama
	0x002db488, // n0x0cd7 c0x0000 (---------------)  + I kaneyama
	0x003195c9, // n0x0cd8 c0x0000 (---------------)  + I kawanishi
	0x002efcca, // n0x0cd9 c0x0000 (---------------)  + I mamurogawa
	0x002aee46, // n0x0cda c0x0000 (---------------)  + I mikawa
	0x00281588, // n0x0cdb c0x0000 (---------------)  + I murayama
	0x002e8805, // n0x0cdc c0x0000 (---------------)  + I nagai
	0x002e2008, // n0x0cdd c0x0000 (---------------)  + I nakayama
	0x002a4205, // n0x0cde c0x0000 (---------------)  + I nanyo
	0x0026c909, // n0x0cdf c0x0000 (---------------)  + I nishikawa
	0x0022f509, // n0x0ce0 c0x0000 (---------------)  + I obanazawa
	0x00213582, // n0x0ce1 c0x0000 (---------------)  + I oe
	0x0025fb45, // n0x0ce2 c0x0000 (---------------)  + I oguni
	0x00269506, // n0x0ce3 c0x0000 (---------------)  + I ohkura
	0x0026a847, // n0x0ce4 c0x0000 (---------------)  + I oishida
	0x00262185, // n0x0ce5 c0x0000 (---------------)  + I sagae
	0x00262fc6, // n0x0ce6 c0x0000 (---------------)  + I sakata
	0x0034eac8, // n0x0ce7 c0x0000 (---------------)  + I sakegawa
	0x002d8586, // n0x0ce8 c0x0000 (---------------)  + I shinjo
	0x002dd649, // n0x0ce9 c0x0000 (---------------)  + I shirataka
	0x0022ea86, // n0x0cea c0x0000 (---------------)  + I shonai
	0x00327b48, // n0x0ceb c0x0000 (---------------)  + I takahata
	0x00292c05, // n0x0cec c0x0000 (---------------)  + I tendo
	0x0028f306, // n0x0ced c0x0000 (---------------)  + I tozawa
	0x002a8248, // n0x0cee c0x0000 (---------------)  + I tsuruoka
	0x0026ee08, // n0x0cef c0x0000 (---------------)  + I yamagata
	0x002045c8, // n0x0cf0 c0x0000 (---------------)  + I yamanobe
	0x00251808, // n0x0cf1 c0x0000 (---------------)  + I yonezawa
	0x00292784, // n0x0cf2 c0x0000 (---------------)  + I yuza
	0x0022ae03, // n0x0cf3 c0x0000 (---------------)  + I abu
	0x002dd884, // n0x0cf4 c0x0000 (---------------)  + I hagi
	0x0029d946, // n0x0cf5 c0x0000 (---------------)  + I hikari
	0x002bfec4, // n0x0cf6 c0x0000 (---------------)  + I hofu
	0x0032ec07, // n0x0cf7 c0x0000 (---------------)  + I iwakuni
	0x00302889, // n0x0cf8 c0x0000 (---------------)  + I kudamatsu
	0x002b2bc5, // n0x0cf9 c0x0000 (---------------)  + I mitou
	0x00240006, // n0x0cfa c0x0000 (---------------)  + I nagato
	0x00217e86, // n0x0cfb c0x0000 (---------------)  + I oshima
	0x002d69cb, // n0x0cfc c0x0000 (---------------)  + I shimonoseki
	0x0029ac86, // n0x0cfd c0x0000 (---------------)  + I shunan
	0x002f9cc6, // n0x0cfe c0x0000 (---------------)  + I tabuse
	0x002f8208, // n0x0cff c0x0000 (---------------)  + I tokuyama
	0x0025c546, // n0x0d00 c0x0000 (---------------)  + I toyota
	0x00272043, // n0x0d01 c0x0000 (---------------)  + I ube
	0x0025e183, // n0x0d02 c0x0000 (---------------)  + I yuu
	0x0022afc4, // n0x0d03 c0x0000 (---------------)  + I chuo
	0x002e0645, // n0x0d04 c0x0000 (---------------)  + I doshi
	0x0026e087, // n0x0d05 c0x0000 (---------------)  + I fuefuki
	0x00268f08, // n0x0d06 c0x0000 (---------------)  + I fujikawa
	0x00268f0f, // n0x0d07 c0x0000 (---------------)  + I fujikawaguchiko
	0x0026b24b, // n0x0d08 c0x0000 (---------------)  + I fujiyoshida
	0x002e3308, // n0x0d09 c0x0000 (---------------)  + I hayakawa
	0x00252946, // n0x0d0a c0x0000 (---------------)  + I hokuto
	0x00235cce, // n0x0d0b c0x0000 (---------------)  + I ichikawamisato
	0x00222d03, // n0x0d0c c0x0000 (---------------)  + I kai
	0x0022b584, // n0x0d0d c0x0000 (---------------)  + I kofu
	0x0029ac05, // n0x0d0e c0x0000 (---------------)  + I koshu
	0x0029c006, // n0x0d0f c0x0000 (---------------)  + I kosuge
	0x0027a24b, // n0x0d10 c0x0000 (---------------)  + I minami-alps
	0x0027d446, // n0x0d11 c0x0000 (---------------)  + I minobu
	0x00238ac9, // n0x0d12 c0x0000 (---------------)  + I nakamichi
	0x00258885, // n0x0d13 c0x0000 (---------------)  + I nanbu
	0x00339748, // n0x0d14 c0x0000 (---------------)  + I narusawa
	0x00217388, // n0x0d15 c0x0000 (---------------)  + I nirasaki
	0x0025460c, // n0x0d16 c0x0000 (---------------)  + I nishikatsura
	0x00288446, // n0x0d17 c0x0000 (---------------)  + I oshino
	0x00239086, // n0x0d18 c0x0000 (---------------)  + I otsuki
	0x002d92c5, // n0x0d19 c0x0000 (---------------)  + I showa
	0x002734c8, // n0x0d1a c0x0000 (---------------)  + I tabayama
	0x00202a85, // n0x0d1b c0x0000 (---------------)  + I tsuru
	0x0024fcc8, // n0x0d1c c0x0000 (---------------)  + I uenohara
	0x00287b0a, // n0x0d1d c0x0000 (---------------)  + I yamanakako
	0x00248c49, // n0x0d1e c0x0000 (---------------)  + I yamanashi
	0x0074a404, // n0x0d1f c0x0001 (---------------)  ! I city
	0x0020d643, // n0x0d20 c0x0000 (---------------)  + I com
	0x002df843, // n0x0d21 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d22 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0d23 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0d24 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d25 c0x0000 (---------------)  + I org
	0x0030c243, // n0x0d26 c0x0000 (---------------)  + I biz
	0x0020d643, // n0x0d27 c0x0000 (---------------)  + I com
	0x002df843, // n0x0d28 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d29 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x0d2a c0x0000 (---------------)  + I info
	0x00214843, // n0x0d2b c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d2c c0x0000 (---------------)  + I org
	0x002072c3, // n0x0d2d c0x0000 (---------------)  + I ass
	0x002072c4, // n0x0d2e c0x0000 (---------------)  + I asso
	0x0020d643, // n0x0d2f c0x0000 (---------------)  + I com
	0x0023ae84, // n0x0d30 c0x0000 (---------------)  + I coop
	0x002df843, // n0x0d31 c0x0000 (---------------)  + I edu
	0x00257384, // n0x0d32 c0x0000 (---------------)  + I gouv
	0x00218d43, // n0x0d33 c0x0000 (---------------)  + I gov
	0x002efac7, // n0x0d34 c0x0000 (---------------)  + I medecin
	0x0022f003, // n0x0d35 c0x0000 (---------------)  + I mil
	0x00216583, // n0x0d36 c0x0000 (---------------)  + I nom
	0x00277b88, // n0x0d37 c0x0000 (---------------)  + I notaires
	0x0023e983, // n0x0d38 c0x0000 (---------------)  + I org
	0x002c70cb, // n0x0d39 c0x0000 (---------------)  + I pharmaciens
	0x00261ec3, // n0x0d3a c0x0000 (---------------)  + I prd
	0x003460c6, // n0x0d3b c0x0000 (---------------)  + I presse
	0x0023a842, // n0x0d3c c0x0000 (---------------)  + I tm
	0x002c1b4b, // n0x0d3d c0x0000 (---------------)  + I veterinaire
	0x002df843, // n0x0d3e c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d3f c0x0000 (---------------)  + I gov
	0x00214843, // n0x0d40 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d41 c0x0000 (---------------)  + I org
	0x0020d643, // n0x0d42 c0x0000 (---------------)  + I com
	0x002df843, // n0x0d43 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d44 c0x0000 (---------------)  + I gov
	0x0023e983, // n0x0d45 c0x0000 (---------------)  + I org
	0x00270e83, // n0x0d46 c0x0000 (---------------)  + I rep
	0x0020c683, // n0x0d47 c0x0000 (---------------)  + I tra
	0x00206c42, // n0x0d48 c0x0000 (---------------)  + I ac
	0x0003c708, // n0x0d49 c0x0000 (---------------)  +   blogspot
	0x00233085, // n0x0d4a c0x0000 (---------------)  + I busan
	0x0030da08, // n0x0d4b c0x0000 (---------------)  + I chungbuk
	0x0031b188, // n0x0d4c c0x0000 (---------------)  + I chungnam
	0x0020d642, // n0x0d4d c0x0000 (---------------)  + I co
	0x00236ac5, // n0x0d4e c0x0000 (---------------)  + I daegu
	0x002bcb47, // n0x0d4f c0x0000 (---------------)  + I daejeon
	0x00201e42, // n0x0d50 c0x0000 (---------------)  + I es
	0x00238d07, // n0x0d51 c0x0000 (---------------)  + I gangwon
	0x00200482, // n0x0d52 c0x0000 (---------------)  + I go
	0x00279707, // n0x0d53 c0x0000 (---------------)  + I gwangju
	0x002fa089, // n0x0d54 c0x0000 (---------------)  + I gyeongbuk
	0x00340e48, // n0x0d55 c0x0000 (---------------)  + I gyeonggi
	0x0022a9c9, // n0x0d56 c0x0000 (---------------)  + I gyeongnam
	0x00212e82, // n0x0d57 c0x0000 (---------------)  + I hs
	0x00256f87, // n0x0d58 c0x0000 (---------------)  + I incheon
	0x0030a6c4, // n0x0d59 c0x0000 (---------------)  + I jeju
	0x002bcc07, // n0x0d5a c0x0000 (---------------)  + I jeonbuk
	0x00202e07, // n0x0d5b c0x0000 (---------------)  + I jeonnam
	0x0025c902, // n0x0d5c c0x0000 (---------------)  + I kg
	0x0022f003, // n0x0d5d c0x0000 (---------------)  + I mil
	0x00201342, // n0x0d5e c0x0000 (---------------)  + I ms
	0x00203e82, // n0x0d5f c0x0000 (---------------)  + I ne
	0x00200a82, // n0x0d60 c0x0000 (---------------)  + I or
	0x00209242, // n0x0d61 c0x0000 (---------------)  + I pe
	0x00201602, // n0x0d62 c0x0000 (---------------)  + I re
	0x00201d82, // n0x0d63 c0x0000 (---------------)  + I sc
	0x002e7d05, // n0x0d64 c0x0000 (---------------)  + I seoul
	0x00239e45, // n0x0d65 c0x0000 (---------------)  + I ulsan
	0x0020d643, // n0x0d66 c0x0000 (---------------)  + I com
	0x002df843, // n0x0d67 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d68 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0d69 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d6a c0x0000 (---------------)  + I org
	0x0020d643, // n0x0d6b c0x0000 (---------------)  + I com
	0x002df843, // n0x0d6c c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d6d c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0d6e c0x0000 (---------------)  + I mil
	0x00214843, // n0x0d6f c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d70 c0x0000 (---------------)  + I org
	0x00000501, // n0x0d71 c0x0000 (---------------)  +   c
	0x0020d643, // n0x0d72 c0x0000 (---------------)  + I com
	0x002df843, // n0x0d73 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d74 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x0d75 c0x0000 (---------------)  + I info
	0x00217543, // n0x0d76 c0x0000 (---------------)  + I int
	0x00214843, // n0x0d77 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d78 c0x0000 (---------------)  + I org
	0x00210803, // n0x0d79 c0x0000 (---------------)  + I per
	0x0020d643, // n0x0d7a c0x0000 (---------------)  + I com
	0x002df843, // n0x0d7b c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d7c c0x0000 (---------------)  + I gov
	0x00214843, // n0x0d7d c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d7e c0x0000 (---------------)  + I org
	0x0020d642, // n0x0d7f c0x0000 (---------------)  + I co
	0x0020d643, // n0x0d80 c0x0000 (---------------)  + I com
	0x002df843, // n0x0d81 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d82 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0d83 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d84 c0x0000 (---------------)  + I org
	0x002aaa04, // n0x0d85 c0x0000 (---------------)  + I assn
	0x0020d643, // n0x0d86 c0x0000 (---------------)  + I com
	0x002df843, // n0x0d87 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d88 c0x0000 (---------------)  + I gov
	0x0024f943, // n0x0d89 c0x0000 (---------------)  + I grp
	0x002937c5, // n0x0d8a c0x0000 (---------------)  + I hotel
	0x00217543, // n0x0d8b c0x0000 (---------------)  + I int
	0x0023c1c3, // n0x0d8c c0x0000 (---------------)  + I ltd
	0x00214843, // n0x0d8d c0x0000 (---------------)  + I net
	0x00200443, // n0x0d8e c0x0000 (---------------)  + I ngo
	0x0023e983, // n0x0d8f c0x0000 (---------------)  + I org
	0x00201d83, // n0x0d90 c0x0000 (---------------)  + I sch
	0x002a4d43, // n0x0d91 c0x0000 (---------------)  + I soc
	0x00205e43, // n0x0d92 c0x0000 (---------------)  + I web
	0x0020d643, // n0x0d93 c0x0000 (---------------)  + I com
	0x002df843, // n0x0d94 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d95 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0d96 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0d97 c0x0000 (---------------)  + I org
	0x0020d642, // n0x0d98 c0x0000 (---------------)  + I co
	0x0023e983, // n0x0d99 c0x0000 (---------------)  + I org
	0x00218d43, // n0x0d9a c0x0000 (---------------)  + I gov
	0x00226343, // n0x0d9b c0x0000 (---------------)  + I asn
	0x0020d643, // n0x0d9c c0x0000 (---------------)  + I com
	0x00299344, // n0x0d9d c0x0000 (---------------)  + I conf
	0x002df843, // n0x0d9e c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0d9f c0x0000 (---------------)  + I gov
	0x00202282, // n0x0da0 c0x0000 (---------------)  + I id
	0x0022f003, // n0x0da1 c0x0000 (---------------)  + I mil
	0x00214843, // n0x0da2 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0da3 c0x0000 (---------------)  + I org
	0x0020d643, // n0x0da4 c0x0000 (---------------)  + I com
	0x002df843, // n0x0da5 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0da6 c0x0000 (---------------)  + I gov
	0x00202282, // n0x0da7 c0x0000 (---------------)  + I id
	0x0023dbc3, // n0x0da8 c0x0000 (---------------)  + I med
	0x00214843, // n0x0da9 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0daa c0x0000 (---------------)  + I org
	0x002cd4c3, // n0x0dab c0x0000 (---------------)  + I plc
	0x00201d83, // n0x0dac c0x0000 (---------------)  + I sch
	0x00206c42, // n0x0dad c0x0000 (---------------)  + I ac
	0x0020d642, // n0x0dae c0x0000 (---------------)  + I co
	0x00218d43, // n0x0daf c0x0000 (---------------)  + I gov
	0x00214843, // n0x0db0 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0db1 c0x0000 (---------------)  + I org
	0x003460c5, // n0x0db2 c0x0000 (---------------)  + I press
	0x002072c4, // n0x0db3 c0x0000 (---------------)  + I asso
	0x0023a842, // n0x0db4 c0x0000 (---------------)  + I tm
	0x00206c42, // n0x0db5 c0x0000 (---------------)  + I ac
	0x0020d642, // n0x0db6 c0x0000 (---------------)  + I co
	0x002df843, // n0x0db7 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0db8 c0x0000 (---------------)  + I gov
	0x00230a03, // n0x0db9 c0x0000 (---------------)  + I its
	0x00214843, // n0x0dba c0x0000 (---------------)  + I net
	0x0023e983, // n0x0dbb c0x0000 (---------------)  + I org
	0x002d1204, // n0x0dbc c0x0000 (---------------)  + I priv
	0x0020d643, // n0x0dbd c0x0000 (---------------)  + I com
	0x002df843, // n0x0dbe c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0dbf c0x0000 (---------------)  + I gov
	0x0022f003, // n0x0dc0 c0x0000 (---------------)  + I mil
	0x00216583, // n0x0dc1 c0x0000 (---------------)  + I nom
	0x0023e983, // n0x0dc2 c0x0000 (---------------)  + I org
	0x00261ec3, // n0x0dc3 c0x0000 (---------------)  + I prd
	0x0023a842, // n0x0dc4 c0x0000 (---------------)  + I tm
	0x0020d643, // n0x0dc5 c0x0000 (---------------)  + I com
	0x002df843, // n0x0dc6 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0dc7 c0x0000 (---------------)  + I gov
	0x00210e03, // n0x0dc8 c0x0000 (---------------)  + I inf
	0x00202f04, // n0x0dc9 c0x0000 (---------------)  + I name
	0x00214843, // n0x0dca c0x0000 (---------------)  + I net
	0x0023e983, // n0x0dcb c0x0000 (---------------)  + I org
	0x0020d643, // n0x0dcc c0x0000 (---------------)  + I com
	0x002df843, // n0x0dcd c0x0000 (---------------)  + I edu
	0x00257384, // n0x0dce c0x0000 (---------------)  + I gouv
	0x00218d43, // n0x0dcf c0x0000 (---------------)  + I gov
	0x00214843, // n0x0dd0 c0x0000 (---------------)  + I net
	0x0023e983, // n0x0dd1 c0x0000 (---------------)  + I org
	0x003460c6, // n0x0dd2 c0x0000 (---------------)  + I presse
	0x002df843, // n0x0dd3 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0dd4 c0x0000 (---------------)  + I gov
	0x00017943, // n0x0dd5 c0x0000 (---------------)  +   nyc
	0x0023e983, // n0x0dd6 c0x0000 (---------------)  + I org
	0x0020d643, // n0x0dd7 c0x0000 (---------------)  + I com
	0x002df843, // n0x0dd8 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x0dd9 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0dda c0x0000 (---------------)  + I net
	0x0023e983, // n0x0ddb c0x0000 (---------------)  + I org
	0x0003c708, // n0x0ddc c0x0000 (---------------)  +   blogspot
	0x00218d43, // n0x0ddd c0x0000 (---------------)  + I gov
	0x00206c42, // n0x0dde c0x0000 (---------------)  + I ac
	0x0020d642, // n0x0ddf c0x0000 (---------------)  + I co
	0x0020d643, // n0x0de0 c0x0000 (---------------)  + I com
	0x00218d43, // n0x0de1 c0x0000 (---------------)  + I gov
	0x00214843, // n0x0de2 c0x0000 (---------------)  + I net
	0x00200a82, // n0x0de3 c0x0000 (---------------)  + I or
	0x0023e983, // n0x0de4 c0x0000 (---------------)  + I org
	0x00290507, // n0x0de5 c0x0000 (---------------)  + I academy
	0x0020b64b, // n0x0de6 c0x0000 (---------------)  + I agriculture
	0x002200c3, // n0x0de7 c0x0000 (---------------)  + I air
	0x002200c8, // n0x0de8 c0x0000 (---------------)  + I airguard
	0x0022f907, // n0x0de9 c0x0000 (---------------)  + I alabama
	0x00207686, // n0x0dea c0x0000 (---------------)  + I alaska
	0x002ac185, // n0x0deb c0x0000 (---------------)  + I amber
	0x0020b989, // n0x0dec c0x0000 (---------------)  + I ambulance
	0x00229b48, // n0x0ded c0x0000 (---------------)  + I american
	0x00229b49, // n0x0dee c0x0000 (---------------)  + I americana
	0x00319f10, // n0x0def c0x0000 (---------------)  + I americanantiques
	0x00229b4b, // n0x0df0 c0x0000 (---------------)  + I americanart
	0x002abfc9, // n0x0df1 c0x0000 (---------------)  + I amsterdam
	0x00202583, // n0x0df2 c0x0000 (---------------)  + I and
	0x0021d0c9, // n0x0df3 c0x0000 (---------------)  + I annefrank
	0x00238186, // n0x0df4 c0x0000 (---------------)  + I anthro
	0x0023818c, // n0x0df5 c0x0000 (---------------)  + I anthropology
	0x00233148, // n0x0df6 c0x0000 (---------------)  + I antiques
	0x00271b88, // n0x0df7 c0x0000 (---------------)  + I aquarium
	0x00302d89, // n0x0df8 c0x0000 (---------------)  + I arboretum
	0x002cebce, // n0x0df9 c0x0000 (---------------)  + I archaeological
	0x00329e8b, // n0x0dfa c0x0000 (---------------)  + I archaeology
	0x0024454c, // n0x0dfb c0x0000 (---------------)  + I architecture
	0x0020e343, // n0x0dfc c0x0000 (---------------)  + I art
	0x00229d4c, // n0x0dfd c0x0000 (---------------)  + I artanddesign
	0x002af749, // n0x0dfe c0x0000 (---------------)  + I artcenter
	0x0020e347, // n0x0dff c0x0000 (---------------)  + I artdeco
	0x002ef50c, // n0x0e00 c0x0000 (---------------)  + I arteducation
	0x0023a50a, // n0x0e01 c0x0000 (---------------)  + I artgallery
	0x00230884, // n0x0e02 c0x0000 (---------------)  + I arts
	0x0026b7cd, // n0x0e03 c0x0000 (---------------)  + I artsandcrafts
	0x002af608, // n0x0e04 c0x0000 (---------------)  + I asmatart
	0x0021e58d, // n0x0e05 c0x0000 (---------------)  + I assassination
	0x0020ac86, // n0x0e06 c0x0000 (---------------)  + I assisi
	0x002c6b0b, // n0x0e07 c0x0000 (---------------)  + I association
	0x002bc609, // n0x0e08 c0x0000 (---------------)  + I astronomy
	0x002e73c7, // n0x0e09 c0x0000 (---------------)  + I atlanta
	0x002bc1c6, // n0x0e0a c0x0000 (---------------)  + I austin
	0x002ae609, // n0x0e0b c0x0000 (---------------)  + I australia
	0x002bb8ca, // n0x0e0c c0x0000 (---------------)  + I automotive
	0x0022cc48, // n0x0e0d c0x0000 (---------------)  + I aviation
	0x00231904, // n0x0e0e c0x0000 (---------------)  + I axis
	0x00289447, // n0x0e0f c0x0000 (---------------)  + I badajoz
	0x002e0907, // n0x0e10 c0x0000 (---------------)  + I baghdad
	0x00299d44, // n0x0e11 c0x0000 (---------------)  + I bahn
	0x00236c04, // n0x0e12 c0x0000 (---------------)  + I bale
	0x0034c749, // n0x0e13 c0x0000 (---------------)  + I baltimore
	0x0030b1c9, // n0x0e14 c0x0000 (---------------)  + I barcelona
	0x00293a48, // n0x0e15 c0x0000 (---------------)  + I baseball
	0x00336ec5, // n0x0e16 c0x0000 (---------------)  + I basel
	0x00212dc5, // n0x0e17 c0x0000 (---------------)  + I baths
	0x002793c6, // n0x0e18 c0x0000 (---------------)  + I bauern
	0x0026b689, // n0x0e19 c0x0000 (---------------)  + I beauxarts
	0x0020474d, // n0x0e1a c0x0000 (---------------)  + I beeldengeluid
	0x002a2c48, // n0x0e1b c0x0000 (---------------)  + I bellevue
	0x002792c7, // n0x0e1c c0x0000 (---------------)  + I bergbau
	0x002ac208, // n0x0e1d c0x0000 (---------------)  + I berkeley
	0x0034d706, // n0x0e1e c0x0000 (---------------)  + I berlin
	0x00200004, // n0x0e1f c0x0000 (---------------)  + I bern
	0x00214605, // n0x0e20 c0x0000 (---------------)  + I bible
	0x0020a906, // n0x0e21 c0x0000 (---------------)  + I bilbao
	0x0020c504, // n0x0e22 c0x0000 (---------------)  + I bill
	0x0020e247, // n0x0e23 c0x0000 (---------------)  + I birdart
	0x0020fe4a, // n0x0e24 c0x0000 (---------------)  + I birthplace
	0x002133c4, // n0x0e25 c0x0000 (---------------)  + I bonn
	0x00215b06, // n0x0e26 c0x0000 (---------------)  + I boston
	0x00216189, // n0x0e27 c0x0000 (---------------)  + I botanical
	0x0021618f, // n0x0e28 c0x0000 (---------------)  + I botanicalgarden
	0x0021708d, // n0x0e29 c0x0000 (---------------)  + I botanicgarden
	0x00217846, // n0x0e2a c0x0000 (---------------)  + I botany
	0x002192d0, // n0x0e2b c0x0000 (---------------)  + I brandywinevalley
	0x00219d46, // n0x0e2c c0x0000 (---------------)  + I brasil
	0x0021b307, // n0x0e2d c0x0000 (---------------)  + I bristol
	0x0021bcc7, // n0x0e2e c0x0000 (---------------)  + I british
	0x0021cb0f, // n0x0e2f c0x0000 (---------------)  + I britishcolumbia
	0x0021e149, // n0x0e30 c0x0000 (---------------)  + I broadcast
	0x00222606, // n0x0e31 c0x0000 (---------------)  + I brunel
	0x002233c7, // n0x0e32 c0x0000 (---------------)  + I brussel
	0x002233c8, // n0x0e33 c0x0000 (---------------)  + I brussels
	0x00223809, // n0x0e34 c0x0000 (---------------)  + I bruxelles
	0x00202688, // n0x0e35 c0x0000 (---------------)  + I building
	0x002cbec7, // n0x0e36 c0x0000 (---------------)  + I burghof
	0x00233083, // n0x0e37 c0x0000 (---------------)  + I bus
	0x0027d1c6, // n0x0e38 c0x0000 (---------------)  + I bushey
	0x002fdc88, // n0x0e39 c0x0000 (---------------)  + I cadaques
	0x002c118a, // n0x0e3a c0x0000 (---------------)  + I california
	0x0023e749, // n0x0e3b c0x0000 (---------------)  + I cambridge
	0x00223183, // n0x0e3c c0x0000 (---------------)  + I can
	0x0029ed06, // n0x0e3d c0x0000 (---------------)  + I canada
	0x00275cca, // n0x0e3e c0x0000 (---------------)  + I capebreton
	0x002ec787, // n0x0e3f c0x0000 (---------------)  + I carrier
	0x002ef34a, // n0x0e40 c0x0000 (---------------)  + I cartoonart
	0x00228f8e, // n0x0e41 c0x0000 (---------------)  + I casadelamoneda
	0x0021e286, // n0x0e42 c0x0000 (---------------)  + I castle
	0x00345d07, // n0x0e43 c0x0000 (---------------)  + I castres
	0x002543c6, // n0x0e44 c0x0000 (---------------)  + I celtic
	0x00240c46, // n0x0e45 c0x0000 (---------------)  + I center
	0x0023964b, // n0x0e46 c0x0000 (---------------)  + I chattanooga
	0x0023f58a, // n0x0e47 c0x0000 (---------------)  + I cheltenham
	0x00244bcd, // n0x0e48 c0x0000 (---------------)  + I chesapeakebay
	0x00265347, // n0x0e49 c0x0000 (---------------)  + I chicago
	0x0021f7c8, // n0x0e4a c0x0000 (---------------)  + I children
	0x0021f7c9, // n0x0e4b c0x0000 (---------------)  + I childrens
	0x0021f7cf, // n0x0e4c c0x0000 (---------------)  + I childrensgarden
	0x00291b4c, // n0x0e4d c0x0000 (---------------)  + I chiropractic
	0x002a9dc9, // n0x0e4e c0x0000 (---------------)  + I chocolate
	0x0024864e, // n0x0e4f c0x0000 (---------------)  + I christiansburg
	0x002c998a, // n0x0e50 c0x0000 (---------------)  + I cincinnati
	0x002efbc6, // n0x0e51 c0x0000 (---------------)  + I cinema
	0x003357c6, // n0x0e52 c0x0000 (---------------)  + I circus
	0x0022d40c, // n0x0e53 c0x0000 (---------------)  + I civilisation
	0x0022d9cc, // n0x0e54 c0x0000 (---------------)  + I civilization
	0x0022e048, // n0x0e55 c0x0000 (---------------)  + I civilwar
	0x0022e887, // n0x0e56 c0x0000 (---------------)  + I clinton
	0x002278c5, // n0x0e57 c0x0000 (---------------)  + I clock
	0x002658c4, // n0x0e58 c0x0000 (---------------)  + I coal
	0x003165ce, // n0x0e59 c0x0000 (---------------)  + I coastaldefence
	0x0020e484, // n0x0e5a c0x0000 (---------------)  + I cody
	0x002bf947, // n0x0e5b c0x0000 (---------------)  + I coldwar
	0x00252e4a, // n0x0e5c c0x0000 (---------------)  + I collection
	0x0024c854, // n0x0e5d c0x0000 (---------------)  + I colonialwilliamsburg
	0x00214b4f, // n0x0e5e c0x0000 (---------------)  + I coloradoplateau
	0x0021ccc8, // n0x0e5f c0x0000 (---------------)  + I columbia
	0x00232f48, // n0x0e60 c0x0000 (---------------)  + I columbus
	0x00285acd, // n0x0e61 c0x0000 (---------------)  + I communication
	0x00285ace, // n0x0e62 c0x0000 (---------------)  + I communications
	0x002c57c9, // n0x0e63 c0x0000 (---------------)  + I community
	0x00234388, // n0x0e64 c0x0000 (---------------)  + I computer
	0x0023438f, // n0x0e65 c0x0000 (---------------)  + I computerhistory
	0x0023a20c, // n0x0e66 c0x0000 (---------------)  + I contemporary
	0x0023a20f, // n0x0e67 c0x0000 (---------------)  + I contemporaryart
	0x0023aac7, // n0x0e68 c0x0000 (---------------)  + I convent
	0x0023b5ca, // n0x0e69 c0x0000 (---------------)  + I copenhagen
	0x0023c9cb, // n0x0e6a c0x0000 (---------------)  + I corporation
	0x0023cc88, // n0x0e6b c0x0000 (---------------)  + I corvette
	0x0023da87, // n0x0e6c c0x0000 (---------------)  + I costume
	0x0033594d, // n0x0e6d c0x0000 (---------------)  + I countryestate
	0x0023dfc6, // n0x0e6e c0x0000 (---------------)  + I county
	0x0026b986, // n0x0e6f c0x0000 (---------------)  + I crafts
	0x0023eac9, // n0x0e70 c0x0000 (---------------)  + I cranbrook
	0x002c1e08, // n0x0e71 c0x0000 (---------------)  + I creation
	0x00240a48, // n0x0e72 c0x0000 (---------------)  + I cultural
	0x00240a4e, // n0x0e73 c0x0000 (---------------)  + I culturalcenter
	0x0020b747, // n0x0e74 c0x0000 (---------------)  + I culture
	0x002c7b85, // n0x0e75 c0x0000 (---------------)  + I cyber
	0x00241245, // n0x0e76 c0x0000 (---------------)  + I cymru
	0x00203944, // n0x0e77 c0x0000 (---------------)  + I dali
	0x002624c6, // n0x0e78 c0x0000 (---------------)  + I dallas
	0x00293948, // n0x0e79 c0x0000 (---------------)  + I database
	0x00283d03, // n0x0e7a c0x0000 (---------------)  + I ddr
	0x0023be0e, // n0x0e7b c0x0000 (---------------)  + I decorativearts
	0x00335d08, // n0x0e7c c0x0000 (---------------)  + I delaware
	0x0026ac8b, // n0x0e7d c0x0000 (---------------)  + I delmenhorst
	0x00226507, // n0x0e7e c0x0000 (---------------)  + I denmark
	0x0024e445, // n0x0e7f c0x0000 (---------------)  + I depot
	0x00229ec6, // n0x0e80 c0x0000 (---------------)  + I design
	0x00294107, // n0x0e81 c0x0000 (---------------)  + I detroit
	0x002c2fc8, // n0x0e82 c0x0000 (---------------)  + I dinosaur
	0x002aeb49, // n0x0e83 c0x0000 (---------------)  + I discovery
	0x0021ad05, // n0x0e84 c0x0000 (---------------)  + I dolls
	0x00272948, // n0x0e85 c0x0000 (---------------)  + I donostia
	0x002ebc86, // n0x0e86 c0x0000 (---------------)  + I durham
	0x00275aca, // n0x0e87 c0x0000 (---------------)  + I eastafrica
	0x003164c9, // n0x0e88 c0x0000 (---------------)  + I eastcoast
	0x002ef5c9, // n0x0e89 c0x0000 (---------------)  + I education
	0x002ef5cb, // n0x0e8a c0x0000 (---------------)  + I educational
	0x00211b48, // n0x0e8b c0x0000 (---------------)  + I egyptian
	0x00299c09, // n0x0e8c c0x0000 (---------------)  + I eisenbahn
	0x00336f86, // n0x0e8d c0x0000 (---------------)  + I elburg
	0x00259aca, // n0x0e8e c0x0000 (---------------)  + I elvendrell
	0x003184ca, // n0x0e8f c0x0000 (---------------)  + I embroidery
	0x0031898c, // n0x0e90 c0x0000 (---------------)  + I encyclopedic
	0x0020eb07, // n0x0e91 c0x0000 (---------------)  + I england
	0x00340c4a, // n0x0e92 c0x0000 (---------------)  + I entomology
	0x00283e8b, // n0x0e93 c0x0000 (---------------)  + I environment
	0x00283e99, // n0x0e94 c0x0000 (---------------)  + I environmentalconservation
	0x00319a08, // n0x0e95 c0x0000 (---------------)  + I epilepsy
	0x00346145, // n0x0e96 c0x0000 (---------------)  + I essex
	0x002b5d86, // n0x0e97 c0x0000 (---------------)  + I estate
	0x0022a809, // n0x0e98 c0x0000 (---------------)  + I ethnology
	0x0021bb46, // n0x0e99 c0x0000 (---------------)  + I exeter
	0x0033fd8a, // n0x0e9a c0x0000 (---------------)  + I exhibition
	0x00309546, // n0x0e9b c0x0000 (---------------)  + I family
	0x00201284, // n0x0e9c c0x0000 (---------------)  + I farm
	0x0033520d, // n0x0e9d c0x0000 (---------------)  + I farmequipment
	0x002bb287, // n0x0e9e c0x0000 (---------------)  + I farmers
	0x00201289, // n0x0e9f c0x0000 (---------------)  + I farmstead
	0x00241485, // n0x0ea0 c0x0000 (---------------)  + I field
	0x002415c8, // n0x0ea1 c0x0000 (---------------)  + I figueres
	0x00242449, // n0x0ea2 c0x0000 (---------------)  + I filatelia
	0x00242684, // n0x0ea3 c0x0000 (---------------)  + I film
	0x00242a87, // n0x0ea4 c0x0000 (---------------)  + I fineart
	0x00242a88, // n0x0ea5 c0x0000 (---------------)  + I finearts
	0x00243007, // n0x0ea6 c0x0000 (---------------)  + I finland
	0x00323d88, // n0x0ea7 c0x0000 (---------------)  + I flanders
	0x00246707, // n0x0ea8 c0x0000 (---------------)  + I florida
	0x00249645, // n0x0ea9 c0x0000 (---------------)  + I force
	0x0024ae8c, // n0x0eaa c0x0000 (---------------)  + I fortmissoula
	0x0024b889, // n0x0eab c0x0000 (---------------)  + I fortworth
	0x0034254a, // n0x0eac c0x0000 (---------------)  + I foundation
	0x00334649, // n0x0ead c0x0000 (---------------)  + I francaise
	0x0021d1c9, // n0x0eae c0x0000 (---------------)  + I frankfurt
	0x0032364c, // n0x0eaf c0x0000 (---------------)  + I franziskaner
	0x00207f8b, // n0x0eb0 c0x0000 (---------------)  + I freemasonry
	0x0024ea08, // n0x0eb1 c0x0000 (---------------)  + I freiburg
	0x0024fec8, // n0x0eb2 c0x0000 (---------------)  + I fribourg
	0x00250584, // n0x0eb3 c0x0000 (---------------)  + I frog
	0x00270448, // n0x0eb4 c0x0000 (---------------)  + I fundacio
	0x00270cc9, // n0x0eb5 c0x0000 (---------------)  + I furniture
	0x0023a5c7, // n0x0eb6 c0x0000 (---------------)  + I gallery
	0x002163c6, // n0x0eb7 c0x0000 (---------------)  + I garden
	0x00292607, // n0x0eb8 c0x0000 (---------------)  + I gateway
	0x002b0ec9, // n0x0eb9 c0x0000 (---------------)  + I geelvinck
	0x002c0f8b, // n0x0eba c0x0000 (---------------)  + I gemological
	0x00327087, // n0x0ebb c0x0000 (---------------)  + I geology
	0x0023e907, // n0x0ebc c0x0000 (---------------)  + I georgia
	0x0020e9c7, // n0x0ebd c0x0000 (---------------)  + I giessen
	0x0021e504, // n0x0ebe c0x0000 (---------------)  + I glas
	0x0021e505, // n0x0ebf c0x0000 (---------------)  + I glass
	0x002a7485, // n0x0ec0 c0x0000 (---------------)  + I gorge
	0x002fe94b, // n0x0ec1 c0x0000 (---------------)  + I grandrapids
	0x00337e04, // n0x0ec2 c0x0000 (---------------)  + I graz
	0x00278b88, // n0x0ec3 c0x0000 (---------------)  + I guernsey
	0x0027234a, // n0x0ec4 c0x0000 (---------------)  + I halloffame
	0x002ebd47, // n0x0ec5 c0x0000 (---------------)  + I hamburg
	0x00331c87, // n0x0ec6 c0x0000 (---------------)  + I handson
	0x00279ad2, // n0x0ec7 c0x0000 (---------------)  + I harvestcelebration
	0x0027c8c6, // n0x0ec8 c0x0000 (---------------)  + I hawaii
	0x00246b06, // n0x0ec9 c0x0000 (---------------)  + I health
	0x0022534e, // n0x0eca c0x0000 (---------------)  + I heimatunduhren
	0x002d46c6, // n0x0ecb c0x0000 (---------------)  + I hellas
	0x00347c08, // n0x0ecc c0x0000 (---------------)  + I helsinki
	0x002f354f, // n0x0ecd c0x0000 (---------------)  + I hembygdsforbund
	0x00318308, // n0x0ece c0x0000 (---------------)  + I heritage
	0x00275508, // n0x0ecf c0x0000 (---------------)  + I histoire
	0x002bde4a, // n0x0ed0 c0x0000 (---------------)  + I historical
	0x002bde51, // n0x0ed1 c0x0000 (---------------)  + I historicalsociety
	0x0028c8ce, // n0x0ed2 c0x0000 (---------------)  + I historichouses
	0x00201bca, // n0x0ed3 c0x0000 (---------------)  + I historisch
	0x00201bcc, // n0x0ed4 c0x0000 (---------------)  + I historisches
	0x00234587, // n0x0ed5 c0x0000 (---------------)  + I history
	0x00234590, // n0x0ed6 c0x0000 (---------------)  + I historyofscience
	0x00209888, // n0x0ed7 c0x0000 (---------------)  + I horology
	0x0028cac5, // n0x0ed8 c0x0000 (---------------)  + I house
	0x00294e0a, // n0x0ed9 c0x0000 (---------------)  + I humanities
	0x0020c54c, // n0x0eda c0x0000 (---------------)  + I illustration
	0x002dfc0d, // n0x0edb c0x0000 (---------------)  + I imageandsound
	0x002051c6, // n0x0edc c0x0000 (---------------)  + I indian
	0x002051c7, // n0x0edd c0x0000 (---------------)  + I indiana
	0x002051cc, // n0x0ede c0x0000 (---------------)  + I indianapolis
	0x0020c0cc, // n0x0edf c0x0000 (---------------)  + I indianmarket
	0x0021754c, // n0x0ee0 c0x0000 (---------------)  + I intelligence
	0x002b52cb, // n0x0ee1 c0x0000 (---------------)  + I interactive
	0x00271b04, // n0x0ee2 c0x0000 (---------------)  + I iraq
	0x00283f44, // n0x0ee3 c0x0000 (---------------)  + I iron
	0x00330a49, // n0x0ee4 c0x0000 (---------------)  + I isleofman
	0x00301d47, // n0x0ee5 c0x0000 (---------------)  + I jamison
	0x00253889, // n0x0ee6 c0x0000 (---------------)  + I jefferson
	0x002e81c9, // n0x0ee7 c0x0000 (---------------)  + I jerusalem
	0x0031acc7, // n0x0ee8 c0x0000 (---------------)  + I jewelry
	0x00348d06, // n0x0ee9 c0x0000 (---------------)  + I jewish
	0x00348d09, // n0x0eea c0x0000 (---------------)  + I jewishart
	0x00297783, // n0x0eeb c0x0000 (---------------)  + I jfk
	0x0021680a, // n0x0eec c0x0000 (---------------)  + I journalism
	0x00230047, // n0x0eed c0x0000 (---------------)  + I judaica
	0x00207b4b, // n0x0eee c0x0000 (---------------)  + I judygarland
	0x00244a4a, // n0x0eef c0x0000 (---------------)  + I juedisches
	0x0030a744, // n0x0ef0 c0x0000 (---------------)  + I juif
	0x00315cc6, // n0x0ef1 c0x0000 (---------------)  + I karate
	0x0029d9c9, // n0x0ef2 c0x0000 (---------------)  + I karikatur
	0x00211f84, // n0x0ef3 c0x0000 (---------------)  + I kids
	0x0021354a, // n0x0ef4 c0x0000 (---------------)  + I koebenhavn
	0x00295705, // n0x0ef5 c0x0000 (---------------)  + I koeln
	0x002a63c5, // n0x0ef6 c0x0000 (---------------)  + I kunst
	0x002a63cd, // n0x0ef7 c0x0000 (---------------)  + I kunstsammlung
	0x002a670e, // n0x0ef8 c0x0000 (---------------)  + I kunstunddesign
	0x002f7845, // n0x0ef9 c0x0000 (---------------)  + I labor
	0x00339b86, // n0x0efa c0x0000 (---------------)  + I labour
	0x00250187, // n0x0efb c0x0000 (---------------)  + I lajolla
	0x002782ca, // n0x0efc c0x0000 (---------------)  + I lancashire
	0x0021ec86, // n0x0efd c0x0000 (---------------)  + I landes
	0x002f4704, // n0x0efe c0x0000 (---------------)  + I lans
	0x002e2887, // n0x0eff c0x0000 (---------------)  + I larsson
	0x0022eecb, // n0x0f00 c0x0000 (---------------)  + I lewismiller
	0x0034d7c7, // n0x0f01 c0x0000 (---------------)  + I lincoln
	0x0033f284, // n0x0f02 c0x0000 (---------------)  + I linz
	0x0032f006, // n0x0f03 c0x0000 (---------------)  + I living
	0x0032f00d, // n0x0f04 c0x0000 (---------------)  + I livinghistory
	0x0025250c, // n0x0f05 c0x0000 (---------------)  + I localhistory
	0x002b4d86, // n0x0f06 c0x0000 (---------------)  + I london
	0x0020a08a, // n0x0f07 c0x0000 (---------------)  + I losangeles
	0x00212ac6, // n0x0f08 c0x0000 (---------------)  + I louvre
	0x0033f888, // n0x0f09 c0x0000 (---------------)  + I loyalist
	0x0028a847, // n0x0f0a c0x0000 (---------------)  + I lucerne
	0x002387ca, // n0x0f0b c0x0000 (---------------)  + I luxembourg
	0x0023c2c6, // n0x0f0c c0x0000 (---------------)  + I luzern
	0x002628c3, // n0x0f0d c0x0000 (---------------)  + I mad
	0x002628c6, // n0x0f0e c0x0000 (---------------)  + I madrid
	0x002fdb08, // n0x0f0f c0x0000 (---------------)  + I mallorca
	0x002829ca, // n0x0f10 c0x0000 (---------------)  + I manchester
	0x00269bc7, // n0x0f11 c0x0000 (---------------)  + I mansion
	0x00269bc8, // n0x0f12 c0x0000 (---------------)  + I mansions
	0x00202d04, // n0x0f13 c0x0000 (---------------)  + I manx
	0x00239447, // n0x0f14 c0x0000 (---------------)  + I marburg
	0x0024f5c8, // n0x0f15 c0x0000 (---------------)  + I maritime
	0x00249308, // n0x0f16 c0x0000 (---------------)  + I maritimo
	0x00280908, // n0x0f17 c0x0000 (---------------)  + I maryland
	0x0028ad8a, // n0x0f18 c0x0000 (---------------)  + I marylhurst
	0x0023dbc5, // n0x0f19 c0x0000 (---------------)  + I media
	0x00247ac7, // n0x0f1a c0x0000 (---------------)  + I medical
	0x0027ff13, // n0x0f1b c0x0000 (---------------)  + I medizinhistorisches
	0x002d6086, // n0x0f1c c0x0000 (---------------)  + I meeres
	0x00346d08, // n0x0f1d c0x0000 (---------------)  + I memorial
	0x002dcec9, // n0x0f1e c0x0000 (---------------)  + I mesaverde
	0x00238bc8, // n0x0f1f c0x0000 (---------------)  + I michigan
	0x00284e4b, // n0x0f20 c0x0000 (---------------)  + I midatlantic
	0x002bd508, // n0x0f21 c0x0000 (---------------)  + I military
	0x0022f004, // n0x0f22 c0x0000 (---------------)  + I mill
	0x002f2546, // n0x0f23 c0x0000 (---------------)  + I miners
	0x002d7a06, // n0x0f24 c0x0000 (---------------)  + I mining
	0x002cb689, // n0x0f25 c0x0000 (---------------)  + I minnesota
	0x002b1f47, // n0x0f26 c0x0000 (---------------)  + I missile
	0x0024af88, // n0x0f27 c0x0000 (---------------)  + I missoula
	0x0028c746, // n0x0f28 c0x0000 (---------------)  + I modern
	0x00285604, // n0x0f29 c0x0000 (---------------)  + I moma
	0x002b3fc5, // n0x0f2a c0x0000 (---------------)  + I money
	0x002b4248, // n0x0f2b c0x0000 (---------------)  + I monmouth
	0x002b4b8a, // n0x0f2c c0x0000 (---------------)  + I monticello
	0x002b5b88, // n0x0f2d c0x0000 (---------------)  + I montreal
	0x002b99c6, // n0x0f2e c0x0000 (---------------)  + I moscow
	0x002830ca, // n0x0f2f c0x0000 (---------------)  + I motorcycle
	0x00278f08, // n0x0f30 c0x0000 (---------------)  + I muenchen
	0x002bd8c8, // n0x0f31 c0x0000 (---------------)  + I muenster
	0x002c1408, // n0x0f32 c0x0000 (---------------)  + I mulhouse
	0x002c2286, // n0x0f33 c0x0000 (---------------)  + I muncie
	0x002c4606, // n0x0f34 c0x0000 (---------------)  + I museet
	0x0034034c, // n0x0f35 c0x0000 (---------------)  + I museumcenter
	0x002c4950, // n0x0f36 c0x0000 (---------------)  + I museumvereniging
	0x002b5985, // n0x0f37 c0x0000 (---------------)  + I music
	0x0021e748, // n0x0f38 c0x0000 (---------------)  + I national
	0x002c9b10, // n0x0f39 c0x0000 (---------------)  + I nationalfirearms
	0x00318110, // n0x0f3a c0x0000 (---------------)  + I nationalheritage
	0x00319d8e, // n0x0f3b c0x0000 (---------------)  + I nativeamerican
	0x0033ffce, // n0x0f3c c0x0000 (---------------)  + I naturalhistory
	0x0033ffd4, // n0x0f3d c0x0000 (---------------)  + I naturalhistorymuseum
	0x0034d94f, // n0x0f3e c0x0000 (---------------)  + I naturalsciences
	0x0034dd06, // n0x0f3f c0x0000 (---------------)  + I nature
	0x00201a91, // n0x0f40 c0x0000 (---------------)  + I naturhistorisches
	0x00208e53, // n0x0f41 c0x0000 (---------------)  + I natuurwetenschappen
	0x002092c8, // n0x0f42 c0x0000 (---------------)  + I naumburg
	0x0020be45, // n0x0f43 c0x0000 (---------------)  + I naval
	0x002fb108, // n0x0f44 c0x0000 (---------------)  + I nebraska
	0x002b1745, // n0x0f45 c0x0000 (---------------)  + I neues
	0x00308b4c, // n0x0f46 c0x0000 (---------------)  + I newhampshire
	0x00224309, // n0x0f47 c0x0000 (---------------)  + I newjersey
	0x002bf789, // n0x0f48 c0x0000 (---------------)  + I newmexico
	0x00292387, // n0x0f49 c0x0000 (---------------)  + I newport
	0x00307609, // n0x0f4a c0x0000 (---------------)  + I newspaper
	0x0023d487, // n0x0f4b c0x0000 (---------------)  + I newyork
	0x002dc946, // n0x0f4c c0x0000 (---------------)  + I niepce
	0x00214407, // n0x0f4d c0x0000 (---------------)  + I norfolk
	0x00206105, // n0x0f4e c0x0000 (---------------)  + I north
	0x0023c403, // n0x0f4f c0x0000 (---------------)  + I nrw
	0x00203649, // n0x0f50 c0x0000 (---------------)  + I nuernberg
	0x00279509, // n0x0f51 c0x0000 (---------------)  + I nuremberg
	0x00217943, // n0x0f52 c0x0000 (---------------)  + I nyc
	0x002cd884, // n0x0f53 c0x0000 (---------------)  + I nyny
	0x002004cd, // n0x0f54 c0x0000 (---------------)  + I oceanographic
	0x00200bcf, // n0x0f55 c0x0000 (---------------)  + I oceanographique
	0x0029bdc5, // n0x0f56 c0x0000 (---------------)  + I omaha
	0x002fb006, // n0x0f57 c0x0000 (---------------)  + I online
	0x0022f387, // n0x0f58 c0x0000 (---------------)  + I ontario
	0x0023f9c7, // n0x0f59 c0x0000 (---------------)  + I openair
	0x0031f946, // n0x0f5a c0x0000 (---------------)  + I oregon
	0x0031f94b, // n0x0f5b c0x0000 (---------------)  + I oregontrail
	0x0028e2c5, // n0x0f5c c0x0000 (---------------)  + I otago
	0x00203406, // n0x0f5d c0x0000 (---------------)  + I oxford
	0x00261307, // n0x0f5e c0x0000 (---------------)  + I pacific
	0x00286109, // n0x0f5f c0x0000 (---------------)  + I paderborn
	0x0033e806, // n0x0f60 c0x0000 (---------------)  + I palace
	0x00211285, // n0x0f61 c0x0000 (---------------)  + I paleo
	0x0030e04b, // n0x0f62 c0x0000 (---------------)  + I palmsprings
	0x0023a946, // n0x0f63 c0x0000 (---------------)  + I panama
	0x00309c05, // n0x0f64 c0x0000 (---------------)  + I paris
	0x002c6008, // n0x0f65 c0x0000 (---------------)  + I pasadena
	0x002c7a08, // n0x0f66 c0x0000 (---------------)  + I pharmacy
	0x002c830c, // n0x0f67 c0x0000 (---------------)  + I philadelphia
	0x002c8310, // n0x0f68 c0x0000 (---------------)  + I philadelphiaarea
	0x002c89c9, // n0x0f69 c0x0000 (---------------)  + I philately
	0x002c8c07, // n0x0f6a c0x0000 (---------------)  + I phoenix
	0x002ca1cb, // n0x0f6b c0x0000 (---------------)  + I photography
	0x002caf86, // n0x0f6c c0x0000 (---------------)  + I pilots
	0x002cbd8a, // n0x0f6d c0x0000 (---------------)  + I pittsburgh
	0x002cc48b, // n0x0f6e c0x0000 (---------------)  + I planetarium
	0x002ccc8a, // n0x0f6f c0x0000 (---------------)  + I plantation
	0x002ccf06, // n0x0f70 c0x0000 (---------------)  + I plants
	0x002cd385, // n0x0f71 c0x0000 (---------------)  + I plaza
	0x0022f806, // n0x0f72 c0x0000 (---------------)  + I portal
	0x002a7b88, // n0x0f73 c0x0000 (---------------)  + I portland
	0x0029244a, // n0x0f74 c0x0000 (---------------)  + I portlligat
	0x0028575c, // n0x0f75 c0x0000 (---------------)  + I posts-and-telecommunications
	0x002cfe8c, // n0x0f76 c0x0000 (---------------)  + I preservation
	0x002d0188, // n0x0f77 c0x0000 (---------------)  + I presidio
	0x003460c5, // n0x0f78 c0x0000 (---------------)  + I press
	0x002d1b07, // n0x0f79 c0x0000 (---------------)  + I project
	0x0029ebc6, // n0x0f7a c0x0000 (---------------)  + I public
	0x00345a05, // n0x0f7b c0x0000 (---------------)  + I pubol
	0x00200ec6, // n0x0f7c c0x0000 (---------------)  + I quebec
	0x0031fb08, // n0x0f7d c0x0000 (---------------)  + I railroad
	0x00297187, // n0x0f7e c0x0000 (---------------)  + I railway
	0x002ceac8, // n0x0f7f c0x0000 (---------------)  + I research
	0x00345e0a, // n0x0f80 c0x0000 (---------------)  + I resistance
	0x00331e8c, // n0x0f81 c0x0000 (---------------)  + I riodejaneiro
	0x0032b449, // n0x0f82 c0x0000 (---------------)  + I rochester
	0x00240187, // n0x0f83 c0x0000 (---------------)  + I rockart
	0x0029bd84, // n0x0f84 c0x0000 (---------------)  + I roma
	0x00241306, // n0x0f85 c0x0000 (---------------)  + I russia
	0x0027508a, // n0x0f86 c0x0000 (---------------)  + I saintlouis
	0x002e82c5, // n0x0f87 c0x0000 (---------------)  + I salem
	0x0024178c, // n0x0f88 c0x0000 (---------------)  + I salvadordali
	0x00242c48, // n0x0f89 c0x0000 (---------------)  + I salzburg
	0x002f8d88, // n0x0f8a c0x0000 (---------------)  + I sandiego
	0x0024c5cc, // n0x0f8b c0x0000 (---------------)  + I sanfrancisco
	0x00263d4c, // n0x0f8c c0x0000 (---------------)  + I santabarbara
	0x00269d89, // n0x0f8d c0x0000 (---------------)  + I santacruz
	0x0026bac7, // n0x0f8e c0x0000 (---------------)  + I santafe
	0x002c9ecc, // n0x0f8f c0x0000 (---------------)  + I saskatchewan
	0x002d7304, // n0x0f90 c0x0000 (---------------)  + I satx
	0x002980ca, // n0x0f91 c0x0000 (---------------)  + I savannahga
	0x0026380c, // n0x0f92 c0x0000 (---------------)  + I schlesisches
	0x0027a4cb, // n0x0f93 c0x0000 (---------------)  + I schoenbrunn
	0x002ba20b, // n0x0f94 c0x0000 (---------------)  + I schokoladen
	0x002baa06, // n0x0f95 c0x0000 (---------------)  + I school
	0x002c3f87, // n0x0f96 c0x0000 (---------------)  + I schweiz
	0x002089c7, // n0x0f97 c0x0000 (---------------)  + I science
	0x002347cf, // n0x0f98 c0x0000 (---------------)  + I science-fiction
	0x002eced1, // n0x0f99 c0x0000 (---------------)  + I scienceandhistory
	0x002089d2, // n0x0f9a c0x0000 (---------------)  + I scienceandindustry
	0x002c734d, // n0x0f9b c0x0000 (---------------)  + I sciencecenter
	0x002c734e, // n0x0f9c c0x0000 (---------------)  + I sciencecenters
	0x002c768e, // n0x0f9d c0x0000 (---------------)  + I sciencehistory
	0x0034db08, // n0x0f9e c0x0000 (---------------)  + I sciences
	0x0034db12, // n0x0f9f c0x0000 (---------------)  + I sciencesnaturelles
	0x0021eb88, // n0x0fa0 c0x0000 (---------------)  + I scotland
	0x002f2fc7, // n0x0fa1 c0x0000 (---------------)  + I seaport
	0x00254e8a, // n0x0fa2 c0x0000 (---------------)  + I settlement
	0x0020da48, // n0x0fa3 c0x0000 (---------------)  + I settlers
	0x002d4685, // n0x0fa4 c0x0000 (---------------)  + I shell
	0x002d4e0a, // n0x0fa5 c0x0000 (---------------)  + I sherbrooke
	0x0020ad87, // n0x0fa6 c0x0000 (---------------)  + I sibenik
	0x0031edc4, // n0x0fa7 c0x0000 (---------------)  + I silk
	0x00202203, // n0x0fa8 c0x0000 (---------------)  + I ski
	0x0023e545, // n0x0fa9 c0x0000 (---------------)  + I skole
	0x002be0c7, // n0x0faa c0x0000 (---------------)  + I society
	0x002d1d87, // n0x0fab c0x0000 (---------------)  + I sologne
	0x002dfe0e, // n0x0fac c0x0000 (---------------)  + I soundandvision
	0x002e444d, // n0x0fad c0x0000 (---------------)  + I southcarolina
	0x002e4a89, // n0x0fae c0x0000 (---------------)  + I southwest
	0x002e5285, // n0x0faf c0x0000 (---------------)  + I space
	0x002e6d03, // n0x0fb0 c0x0000 (---------------)  + I spy
	0x002e6f46, // n0x0fb1 c0x0000 (---------------)  + I square
	0x00255a45, // n0x0fb2 c0x0000 (---------------)  + I stadt
	0x00228a48, // n0x0fb3 c0x0000 (---------------)  + I stalbans
	0x002d4bc9, // n0x0fb4 c0x0000 (---------------)  + I starnberg
	0x002b5dc5, // n0x0fb5 c0x0000 (---------------)  + I state
	0x00335b4f, // n0x0fb6 c0x0000 (---------------)  + I stateofdelaware
	0x002a4f07, // n0x0fb7 c0x0000 (---------------)  + I station
	0x002c1845, // n0x0fb8 c0x0000 (---------------)  + I steam
	0x00290d4a, // n0x0fb9 c0x0000 (---------------)  + I steiermark
	0x002e8e46, // n0x0fba c0x0000 (---------------)  + I stjohn
	0x002e9389, // n0x0fbb c0x0000 (---------------)  + I stockholm
	0x002ea0cc, // n0x0fbc c0x0000 (---------------)  + I stpetersburg
	0x002ea849, // n0x0fbd c0x0000 (---------------)  + I stuttgart
	0x0025d106, // n0x0fbe c0x0000 (---------------)  + I suisse
	0x0027214c, // n0x0fbf c0x0000 (---------------)  + I surgeonshall
	0x00300006, // n0x0fc0 c0x0000 (---------------)  + I surrey
	0x002ec408, // n0x0fc1 c0x0000 (---------------)  + I svizzera
	0x0026c7c6, // n0x0fc2 c0x0000 (---------------)  + I sweden
	0x0025cf46, // n0x0fc3 c0x0000 (---------------)  + I sydney
	0x00324084, // n0x0fc4 c0x0000 (---------------)  + I tank
	0x00230fc3, // n0x0fc5 c0x0000 (---------------)  + I tcm
	0x002e8bca, // n0x0fc6 c0x0000 (---------------)  + I technology
	0x002d0dd1, // n0x0fc7 c0x0000 (---------------)  + I telekommunikation
	0x0023b10a, // n0x0fc8 c0x0000 (---------------)  + I television
	0x0023ce05, // n0x0fc9 c0x0000 (---------------)  + I texas
	0x0023f147, // n0x0fca c0x0000 (---------------)  + I textile
	0x00229487, // n0x0fcb c0x0000 (---------------)  + I theater
	0x0024f6c4, // n0x0fcc c0x0000 (---------------)  + I time
	0x0024f6cb, // n0x0fcd c0x0000 (---------------)  + I timekeeping
	0x002f9f08, // n0x0fce c0x0000 (---------------)  + I topology
	0x002a3ac6, // n0x0fcf c0x0000 (---------------)  + I torino
	0x0024e1c5, // n0x0fd0 c0x0000 (---------------)  + I touch
	0x0023c8c4, // n0x0fd1 c0x0000 (---------------)  + I town
	0x002d4209, // n0x0fd2 c0x0000 (---------------)  + I transport
	0x0031c184, // n0x0fd3 c0x0000 (---------------)  + I tree
	0x002686c7, // n0x0fd4 c0x0000 (---------------)  + I trolley
	0x002d3745, // n0x0fd5 c0x0000 (---------------)  + I trust
	0x002d3747, // n0x0fd6 c0x0000 (---------------)  + I trustee
	0x00225585, // n0x0fd7 c0x0000 (---------------)  + I uhren
	0x00203f83, // n0x0fd8 c0x0000 (---------------)  + I ulm
	0x002f2e88, // n0x0fd9 c0x0000 (---------------)  + I undersea
	0x00209b8a, // n0x0fda c0x0000 (---------------)  + I university
	0x002159c3, // n0x0fdb c0x0000 (---------------)  + I usa
	0x002330ca, // n0x0fdc c0x0000 (---------------)  + I usantiques
	0x00230806, // n0x0fdd c0x0000 (---------------)  + I usarts
	0x003358cf, // n0x0fde c0x0000 (---------------)  + I uscountryestate
	0x00314f49, // n0x0fdf c0x0000 (---------------)  + I usculture
	0x0023bd90, // n0x0fe0 c0x0000 (---------------)  + I usdecorativearts
	0x002d67c8, // n0x0fe1 c0x0000 (---------------)  + I usgarden
	0x002b9c49, // n0x0fe2 c0x0000 (---------------)  + I ushistory
	0x0027ea07, // n0x0fe3 c0x0000 (---------------)  + I ushuaia
	0x0032ef8f, // n0x0fe4 c0x0000 (---------------)  + I uslivinghistory
	0x0022c944, // n0x0fe5 c0x0000 (---------------)  + I utah
	0x00257404, // n0x0fe6 c0x0000 (---------------)  + I uvic
	0x00219546, // n0x0fe7 c0x0000 (---------------)  + I valley
	0x002a24c6, // n0x0fe8 c0x0000 (---------------)  + I vantaa
	0x002eb68a, // n0x0fe9 c0x0000 (---------------)  + I versailles
	0x002e7246, // n0x0fea c0x0000 (---------------)  + I viking
	0x00307d07, // n0x0feb c0x0000 (---------------)  + I village
	0x002f0748, // n0x0fec c0x0000 (---------------)  + I virginia
	0x002f0947, // n0x0fed c0x0000 (---------------)  + I virtual
	0x002f0b07, // n0x0fee c0x0000 (---------------)  + I virtuel
	0x002f6e8a, // n0x0fef c0x0000 (---------------)  + I vlaanderen
	0x002f2ccb, // n0x0ff0 c0x0000 (---------------)  + I volkenkunde
	0x00205885, // n0x0ff1 c0x0000 (---------------)  + I wales
	0x00208608, // n0x0ff2 c0x0000 (---------------)  + I wallonie
	0x00203c43, // n0x0ff3 c0x0000 (---------------)  + I war
	0x002bfbcc, // n0x0ff4 c0x0000 (---------------)  + I washingtondc
	0x002efecf, // n0x0ff5 c0x0000 (---------------)  + I watch-and-clock
	0x002276cd, // n0x0ff6 c0x0000 (---------------)  + I watchandclock
	0x002e4bc7, // n0x0ff7 c0x0000 (---------------)  + I western
	0x002311c9, // n0x0ff8 c0x0000 (---------------)  + I westfalen
	0x0022bb47, // n0x0ff9 c0x0000 (---------------)  + I whaling
	0x0022be08, // n0x0ffa c0x0000 (---------------)  + I wildlife
	0x0024ca4c, // n0x0ffb c0x0000 (---------------)  + I williamsburg
	0x0028a688, // n0x0ffc c0x0000 (---------------)  + I windmill
	0x00303fc8, // n0x0ffd c0x0000 (---------------)  + I workshop
	0x002d73ce, // n0x0ffe c0x0000 (---------------)  + I xn--9dbhblg6di
	0x002fc594, // n0x0fff c0x0000 (---------------)  + I xn--comunicaes-v6a2o
	0x002fcaa4, // n0x1000 c0x0000 (---------------)  + I xn--correios-e-telecomunicaes-ghc29a
	0x003097ca, // n0x1001 c0x0000 (---------------)  + I xn--h1aegh
	0x0031c28b, // n0x1002 c0x0000 (---------------)  + I xn--lns-qla
	0x0023d544, // n0x1003 c0x0000 (---------------)  + I york
	0x0023d549, // n0x1004 c0x0000 (---------------)  + I yorkshire
	0x002dd448, // n0x1005 c0x0000 (---------------)  + I yosemite
	0x00296585, // n0x1006 c0x0000 (---------------)  + I youth
	0x00335f4a, // n0x1007 c0x0000 (---------------)  + I zoological
	0x00234e87, // n0x1008 c0x0000 (---------------)  + I zoology
	0x00228d84, // n0x1009 c0x0000 (---------------)  + I aero
	0x0030c243, // n0x100a c0x0000 (---------------)  + I biz
	0x0020d643, // n0x100b c0x0000 (---------------)  + I com
	0x0023ae84, // n0x100c c0x0000 (---------------)  + I coop
	0x002df843, // n0x100d c0x0000 (---------------)  + I edu
	0x00218d43, // n0x100e c0x0000 (---------------)  + I gov
	0x00210e04, // n0x100f c0x0000 (---------------)  + I info
	0x00217543, // n0x1010 c0x0000 (---------------)  + I int
	0x0022f003, // n0x1011 c0x0000 (---------------)  + I mil
	0x002c4946, // n0x1012 c0x0000 (---------------)  + I museum
	0x00202f04, // n0x1013 c0x0000 (---------------)  + I name
	0x00214843, // n0x1014 c0x0000 (---------------)  + I net
	0x0023e983, // n0x1015 c0x0000 (---------------)  + I org
	0x002d1383, // n0x1016 c0x0000 (---------------)  + I pro
	0x00206c42, // n0x1017 c0x0000 (---------------)  + I ac
	0x0030c243, // n0x1018 c0x0000 (---------------)  + I biz
	0x0020d642, // n0x1019 c0x0000 (---------------)  + I co
	0x0020d643, // n0x101a c0x0000 (---------------)  + I com
	0x0023ae84, // n0x101b c0x0000 (---------------)  + I coop
	0x002df843, // n0x101c c0x0000 (---------------)  + I edu
	0x00218d43, // n0x101d c0x0000 (---------------)  + I gov
	0x00217543, // n0x101e c0x0000 (---------------)  + I int
	0x002c4946, // n0x101f c0x0000 (---------------)  + I museum
	0x00214843, // n0x1020 c0x0000 (---------------)  + I net
	0x0023e983, // n0x1021 c0x0000 (---------------)  + I org
	0x0003c708, // n0x1022 c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x1023 c0x0000 (---------------)  + I com
	0x002df843, // n0x1024 c0x0000 (---------------)  + I edu
	0x00265483, // n0x1025 c0x0000 (---------------)  + I gob
	0x00214843, // n0x1026 c0x0000 (---------------)  + I net
	0x0023e983, // n0x1027 c0x0000 (---------------)  + I org
	0x0020d643, // n0x1028 c0x0000 (---------------)  + I com
	0x002df843, // n0x1029 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x102a c0x0000 (---------------)  + I gov
	0x0022f003, // n0x102b c0x0000 (---------------)  + I mil
	0x00202f04, // n0x102c c0x0000 (---------------)  + I name
	0x00214843, // n0x102d c0x0000 (---------------)  + I net
	0x0023e983, // n0x102e c0x0000 (---------------)  + I org
	0x00693848, // n0x102f c0x0001 (---------------)  ! I teledata
	0x00201002, // n0x1030 c0x0000 (---------------)  + I ca
	0x00206842, // n0x1031 c0x0000 (---------------)  + I cc
	0x0020d642, // n0x1032 c0x0000 (---------------)  + I co
	0x0020d643, // n0x1033 c0x0000 (---------------)  + I com
	0x00201482, // n0x1034 c0x0000 (---------------)  + I dr
	0x002027c2, // n0x1035 c0x0000 (---------------)  + I in
	0x00210e04, // n0x1036 c0x0000 (---------------)  + I info
	0x00303304, // n0x1037 c0x0000 (---------------)  + I mobi
	0x00329482, // n0x1038 c0x0000 (---------------)  + I mx
	0x00202f04, // n0x1039 c0x0000 (---------------)  + I name
	0x00200a82, // n0x103a c0x0000 (---------------)  + I or
	0x0023e983, // n0x103b c0x0000 (---------------)  + I org
	0x002d1383, // n0x103c c0x0000 (---------------)  + I pro
	0x002baa06, // n0x103d c0x0000 (---------------)  + I school
	0x00281802, // n0x103e c0x0000 (---------------)  + I tv
	0x00201f42, // n0x103f c0x0000 (---------------)  + I us
	0x0021ba82, // n0x1040 c0x0000 (---------------)  + I ws
	0x31646d03, // n0x1041 c0x00c5 (n0x1043-n0x1044)  o I her
	0x31a00803, // n0x1042 c0x00c6 (n0x1044-n0x1045)  o I his
	0x00049786, // n0x1043 c0x0000 (---------------)  +   forgot
	0x00049786, // n0x1044 c0x0000 (---------------)  +   forgot
	0x002072c4, // n0x1045 c0x0000 (---------------)  + I asso
	0x00006f4c, // n0x1046 c0x0000 (---------------)  +   at-band-camp
	0x00005c07, // n0x1047 c0x0000 (---------------)  +   blogdns
	0x0001f2c8, // n0x1048 c0x0000 (---------------)  +   broke-it
	0x00097e8a, // n0x1049 c0x0000 (---------------)  +   buyshouses
	0x0002f1ca, // n0x104a c0x0000 (---------------)  +   cloudfront
	0x000357c8, // n0x104b c0x0000 (---------------)  +   dnsalias
	0x00062ac7, // n0x104c c0x0000 (---------------)  +   dnsdojo
	0x00015687, // n0x104d c0x0000 (---------------)  +   does-it
	0x00106f09, // n0x104e c0x0000 (---------------)  +   dontexist
	0x0000e508, // n0x104f c0x0000 (---------------)  +   dynalias
	0x0004a489, // n0x1050 c0x0000 (---------------)  +   dynathome
	0x00092c4d, // n0x1051 c0x0000 (---------------)  +   endofinternet
	0x00051e47, // n0x1052 c0x0000 (---------------)  +   from-az
	0x00052d07, // n0x1053 c0x0000 (---------------)  +   from-co
	0x00058b47, // n0x1054 c0x0000 (---------------)  +   from-la
	0x00060447, // n0x1055 c0x0000 (---------------)  +   from-ny
	0x00079382, // n0x1056 c0x0000 (---------------)  +   gb
	0x00146387, // n0x1057 c0x0000 (---------------)  +   gets-it
	0x0003f74c, // n0x1058 c0x0000 (---------------)  +   ham-radio-op
	0x0000ee47, // n0x1059 c0x0000 (---------------)  +   homeftp
	0x0012b286, // n0x105a c0x0000 (---------------)  +   homeip
	0x0008fcc9, // n0x105b c0x0000 (---------------)  +   homelinux
	0x00090148, // n0x105c c0x0000 (---------------)  +   homeunix
	0x0002b002, // n0x105d c0x0000 (---------------)  +   hu
	0x001071cb, // n0x105e c0x0000 (---------------)  +   in-the-band
	0x00054949, // n0x105f c0x0000 (---------------)  +   is-a-chef
	0x0005c709, // n0x1060 c0x0000 (---------------)  +   is-a-geek
	0x0008e588, // n0x1061 c0x0000 (---------------)  +   isa-geek
	0x00097b42, // n0x1062 c0x0000 (---------------)  +   jp
	0x00026bc9, // n0x1063 c0x0000 (---------------)  +   kicks-ass
	0x00013e4d, // n0x1064 c0x0000 (---------------)  +   office-on-the
	0x000ce747, // n0x1065 c0x0000 (---------------)  +   podzone
	0x000cd04d, // n0x1066 c0x0000 (---------------)  +   scrapper-site
	0x0000da42, // n0x1067 c0x0000 (---------------)  +   se
	0x00109ac6, // n0x1068 c0x0000 (---------------)  +   selfip
	0x000c1588, // n0x1069 c0x0000 (---------------)  +   sells-it
	0x000edb88, // n0x106a c0x0000 (---------------)  +   servebbs
	0x000f2688, // n0x106b c0x0000 (---------------)  +   serveftp
	0x00046c08, // n0x106c c0x0000 (---------------)  +   thruhere
	0x00001902, // n0x106d c0x0000 (---------------)  +   uk
	0x000141c6, // n0x106e c0x0000 (---------------)  +   webhop
	0x00001142, // n0x106f c0x0000 (---------------)  +   za
	0x00230884, // n0x1070 c0x0000 (---------------)  + I arts
	0x0020d643, // n0x1071 c0x0000 (---------------)  + I com
	0x00243504, // n0x1072 c0x0000 (---------------)  + I firm
	0x00210e04, // n0x1073 c0x0000 (---------------)  + I info
	0x00214843, // n0x1074 c0x0000 (---------------)  + I net
	0x0024cec5, // n0x1075 c0x0000 (---------------)  + I other
	0x00210803, // n0x1076 c0x0000 (---------------)  + I per
	0x002c1d83, // n0x1077 c0x0000 (---------------)  + I rec
	0x002e9c05, // n0x1078 c0x0000 (---------------)  + I store
	0x00205e43, // n0x1079 c0x0000 (---------------)  + I web
	0x00206c42, // n0x107a c0x0000 (---------------)  + I ac
	0x0020d643, // n0x107b c0x0000 (---------------)  + I com
	0x002df843, // n0x107c c0x0000 (---------------)  + I edu
	0x00218d43, // n0x107d c0x0000 (---------------)  + I gov
	0x00214843, // n0x107e c0x0000 (---------------)  + I net
	0x0023e983, // n0x107f c0x0000 (---------------)  + I org
	0x0003c708, // n0x1080 c0x0000 (---------------)  +   blogspot
	0x002248c2, // n0x1081 c0x0000 (---------------)  + I bv
	0x0000d642, // n0x1082 c0x0000 (---------------)  +   co
	0x33606502, // n0x1083 c0x00cd (n0x1359-n0x135a)  + I aa
	0x002301c8, // n0x1084 c0x0000 (---------------)  + I aarborte
	0x00222e86, // n0x1085 c0x0000 (---------------)  + I aejrie
	0x002a8906, // n0x1086 c0x0000 (---------------)  + I afjord
	0x00222807, // n0x1087 c0x0000 (---------------)  + I agdenes
	0x33a07a02, // n0x1088 c0x00ce (n0x135a-n0x135b)  + I ah
	0x33f14dc8, // n0x1089 c0x00cf (n0x135b-n0x135c)  o I akershus
	0x0022690a, // n0x108a c0x0000 (---------------)  + I aknoluokta
	0x00201588, // n0x108b c0x0000 (---------------)  + I akrehamn
	0x00203982, // n0x108c c0x0000 (---------------)  + I al
	0x00207989, // n0x108d c0x0000 (---------------)  + I alaheadju
	0x002058c7, // n0x108e c0x0000 (---------------)  + I alesund
	0x00216346, // n0x108f c0x0000 (---------------)  + I algard
	0x00265949, // n0x1090 c0x0000 (---------------)  + I alstahaug
	0x00247c04, // n0x1091 c0x0000 (---------------)  + I alta
	0x00207586, // n0x1092 c0x0000 (---------------)  + I alvdal
	0x002b15c4, // n0x1093 c0x0000 (---------------)  + I amli
	0x00203d04, // n0x1094 c0x0000 (---------------)  + I amot
	0x0024aac9, // n0x1095 c0x0000 (---------------)  + I andasuolo
	0x00202586, // n0x1096 c0x0000 (---------------)  + I andebu
	0x00239f05, // n0x1097 c0x0000 (---------------)  + I andoy
	0x0025cb05, // n0x1098 c0x0000 (---------------)  + I ardal
	0x002665c7, // n0x1099 c0x0000 (---------------)  + I aremark
	0x002e7007, // n0x109a c0x0000 (---------------)  + I arendal
	0x0025ca44, // n0x109b c0x0000 (---------------)  + I arna
	0x00222a46, // n0x109c c0x0000 (---------------)  + I aseral
	0x00267805, // n0x109d c0x0000 (---------------)  + I asker
	0x002d47c5, // n0x109e c0x0000 (---------------)  + I askim
	0x003382c5, // n0x109f c0x0000 (---------------)  + I askoy
	0x00227f87, // n0x10a0 c0x0000 (---------------)  + I askvoll
	0x00226345, // n0x10a1 c0x0000 (---------------)  + I asnes
	0x00317f09, // n0x10a2 c0x0000 (---------------)  + I audnedaln
	0x00214e85, // n0x10a3 c0x0000 (---------------)  + I aukra
	0x002c3104, // n0x10a4 c0x0000 (---------------)  + I aure
	0x00202487, // n0x10a5 c0x0000 (---------------)  + I aurland
	0x002ae80e, // n0x10a6 c0x0000 (---------------)  + I aurskog-holand
	0x00225e89, // n0x10a7 c0x0000 (---------------)  + I austevoll
	0x00225209, // n0x10a8 c0x0000 (---------------)  + I austrheim
	0x00232806, // n0x10a9 c0x0000 (---------------)  + I averoy
	0x00301bc8, // n0x10aa c0x0000 (---------------)  + I badaddja
	0x002e85cb, // n0x10ab c0x0000 (---------------)  + I bahcavuotna
	0x00288e8c, // n0x10ac c0x0000 (---------------)  + I bahccavuotna
	0x00250406, // n0x10ad c0x0000 (---------------)  + I baidar
	0x00329d47, // n0x10ae c0x0000 (---------------)  + I bajddar
	0x00224945, // n0x10af c0x0000 (---------------)  + I balat
	0x00236c0a, // n0x10b0 c0x0000 (---------------)  + I balestrand
	0x00293b49, // n0x10b1 c0x0000 (---------------)  + I ballangen
	0x002e5a49, // n0x10b2 c0x0000 (---------------)  + I balsfjord
	0x002fd606, // n0x10b3 c0x0000 (---------------)  + I bamble
	0x002ebbc5, // n0x10b4 c0x0000 (---------------)  + I bardu
	0x00310945, // n0x10b5 c0x0000 (---------------)  + I barum
	0x0033e5c9, // n0x10b6 c0x0000 (---------------)  + I batsfjord
	0x00224b4b, // n0x10b7 c0x0000 (---------------)  + I bearalvahki
	0x0024d586, // n0x10b8 c0x0000 (---------------)  + I beardu
	0x002185c6, // n0x10b9 c0x0000 (---------------)  + I beiarn
	0x00203784, // n0x10ba c0x0000 (---------------)  + I berg
	0x00245506, // n0x10bb c0x0000 (---------------)  + I bergen
	0x002c7c08, // n0x10bc c0x0000 (---------------)  + I berlevag
	0x00206e46, // n0x10bd c0x0000 (---------------)  + I bievat
	0x00262406, // n0x10be c0x0000 (---------------)  + I bindal
	0x0020f648, // n0x10bf c0x0000 (---------------)  + I birkenes
	0x002100c7, // n0x10c0 c0x0000 (---------------)  + I bjarkoy
	0x002105c9, // n0x10c1 c0x0000 (---------------)  + I bjerkreim
	0x00210945, // n0x10c2 c0x0000 (---------------)  + I bjugn
	0x0003c708, // n0x10c3 c0x0000 (---------------)  +   blogspot
	0x002a3344, // n0x10c4 c0x0000 (---------------)  + I bodo
	0x002be444, // n0x10c5 c0x0000 (---------------)  + I bokn
	0x00212c45, // n0x10c6 c0x0000 (---------------)  + I bomlo
	0x0021a3c9, // n0x10c7 c0x0000 (---------------)  + I bremanger
	0x00221007, // n0x10c8 c0x0000 (---------------)  + I bronnoy
	0x0022100b, // n0x10c9 c0x0000 (---------------)  + I bronnoysund
	0x0022170a, // n0x10ca c0x0000 (---------------)  + I brumunddal
	0x00224245, // n0x10cb c0x0000 (---------------)  + I bryne
	0x34202682, // n0x10cc c0x00d0 (n0x135c-n0x135d)  + I bu
	0x00244907, // n0x10cd c0x0000 (---------------)  + I budejju
	0x346bf548, // n0x10ce c0x00d1 (n0x135d-n0x135e)  o I buskerud
	0x00213b07, // n0x10cf c0x0000 (---------------)  + I bygland
	0x002c9505, // n0x10d0 c0x0000 (---------------)  + I bykle
	0x0025230a, // n0x10d1 c0x0000 (---------------)  + I cahcesuolo
	0x0000d642, // n0x10d2 c0x0000 (---------------)  +   co
	0x0021530b, // n0x10d3 c0x0000 (---------------)  + I davvenjarga
	0x002a2e4a, // n0x10d4 c0x0000 (---------------)  + I davvesiida
	0x00203546, // n0x10d5 c0x0000 (---------------)  + I deatnu
	0x0024e443, // n0x10d6 c0x0000 (---------------)  + I dep
	0x002d76cd, // n0x10d7 c0x0000 (---------------)  + I dielddanuorri
	0x0023780c, // n0x10d8 c0x0000 (---------------)  + I divtasvuodna
	0x002bbc0d, // n0x10d9 c0x0000 (---------------)  + I divttasvuotna
	0x00304485, // n0x10da c0x0000 (---------------)  + I donna
	0x00324b85, // n0x10db c0x0000 (---------------)  + I dovre
	0x00283d47, // n0x10dc c0x0000 (---------------)  + I drammen
	0x0033f089, // n0x10dd c0x0000 (---------------)  + I drangedal
	0x00201486, // n0x10de c0x0000 (---------------)  + I drobak
	0x0025e085, // n0x10df c0x0000 (---------------)  + I dyroy
	0x002a9548, // n0x10e0 c0x0000 (---------------)  + I egersund
	0x002791c3, // n0x10e1 c0x0000 (---------------)  + I eid
	0x0031b488, // n0x10e2 c0x0000 (---------------)  + I eidfjord
	0x002791c8, // n0x10e3 c0x0000 (---------------)  + I eidsberg
	0x002acc87, // n0x10e4 c0x0000 (---------------)  + I eidskog
	0x002fb408, // n0x10e5 c0x0000 (---------------)  + I eidsvoll
	0x00252ac9, // n0x10e6 c0x0000 (---------------)  + I eigersund
	0x0022b687, // n0x10e7 c0x0000 (---------------)  + I elverum
	0x0020b1c7, // n0x10e8 c0x0000 (---------------)  + I enebakk
	0x002b0b48, // n0x10e9 c0x0000 (---------------)  + I engerdal
	0x002e7944, // n0x10ea c0x0000 (---------------)  + I etne
	0x002e7947, // n0x10eb c0x0000 (---------------)  + I etnedal
	0x0020ab88, // n0x10ec c0x0000 (---------------)  + I evenassi
	0x00213906, // n0x10ed c0x0000 (---------------)  + I evenes
	0x0033e94f, // n0x10ee c0x0000 (---------------)  + I evje-og-hornnes
	0x00303c87, // n0x10ef c0x0000 (---------------)  + I farsund
	0x00254b46, // n0x10f0 c0x0000 (---------------)  + I fauske
	0x0022bf85, // n0x10f1 c0x0000 (---------------)  + I fedje
	0x002cda03, // n0x10f2 c0x0000 (---------------)  + I fet
	0x0031ffc7, // n0x10f3 c0x0000 (---------------)  + I fetsund
	0x0032fbc3, // n0x10f4 c0x0000 (---------------)  + I fhs
	0x002431c6, // n0x10f5 c0x0000 (---------------)  + I finnoy
	0x00244446, // n0x10f6 c0x0000 (---------------)  + I fitjar
	0x00244f06, // n0x10f7 c0x0000 (---------------)  + I fjaler
	0x0027c6c5, // n0x10f8 c0x0000 (---------------)  + I fjell
	0x00255943, // n0x10f9 c0x0000 (---------------)  + I fla
	0x00255948, // n0x10fa c0x0000 (---------------)  + I flakstad
	0x0032da09, // n0x10fb c0x0000 (---------------)  + I flatanger
	0x0024514b, // n0x10fc c0x0000 (---------------)  + I flekkefjord
	0x00245408, // n0x10fd c0x0000 (---------------)  + I flesberg
	0x002463c5, // n0x10fe c0x0000 (---------------)  + I flora
	0x002468c5, // n0x10ff c0x0000 (---------------)  + I floro
	0x34b30b82, // n0x1100 c0x00d2 (n0x135e-n0x135f)  + I fm
	0x002144c9, // n0x1101 c0x0000 (---------------)  + I folkebibl
	0x00247147, // n0x1102 c0x0000 (---------------)  + I folldal
	0x00203485, // n0x1103 c0x0000 (---------------)  + I forde
	0x0024a9c7, // n0x1104 c0x0000 (---------------)  + I forsand
	0x0024c486, // n0x1105 c0x0000 (---------------)  + I fosnes
	0x00320805, // n0x1106 c0x0000 (---------------)  + I frana
	0x0024d00b, // n0x1107 c0x0000 (---------------)  + I fredrikstad
	0x0024ea04, // n0x1108 c0x0000 (---------------)  + I frei
	0x00250585, // n0x1109 c0x0000 (---------------)  + I frogn
	0x002506c7, // n0x110a c0x0000 (---------------)  + I froland
	0x00267d46, // n0x110b c0x0000 (---------------)  + I frosta
	0x00268005, // n0x110c c0x0000 (---------------)  + I froya
	0x00270647, // n0x110d c0x0000 (---------------)  + I fuoisku
	0x00270a07, // n0x110e c0x0000 (---------------)  + I fuossko
	0x002def44, // n0x110f c0x0000 (---------------)  + I fusa
	0x0027404a, // n0x1110 c0x0000 (---------------)  + I fylkesbibl
	0x002742c8, // n0x1111 c0x0000 (---------------)  + I fyresdal
	0x002e8889, // n0x1112 c0x0000 (---------------)  + I gaivuotna
	0x00215545, // n0x1113 c0x0000 (---------------)  + I galsa
	0x0021b4c6, // n0x1114 c0x0000 (---------------)  + I gamvik
	0x002c7dca, // n0x1115 c0x0000 (---------------)  + I gangaviika
	0x002c80c6, // n0x1116 c0x0000 (---------------)  + I gaular
	0x00255f07, // n0x1117 c0x0000 (---------------)  + I gausdal
	0x00340fcd, // n0x1118 c0x0000 (---------------)  + I giehtavuoatna
	0x002af2c9, // n0x1119 c0x0000 (---------------)  + I gildeskal
	0x00325605, // n0x111a c0x0000 (---------------)  + I giske
	0x003370c7, // n0x111b c0x0000 (---------------)  + I gjemnes
	0x00346b48, // n0x111c c0x0000 (---------------)  + I gjerdrum
	0x00202848, // n0x111d c0x0000 (---------------)  + I gjerstad
	0x00203847, // n0x111e c0x0000 (---------------)  + I gjesdal
	0x00209486, // n0x111f c0x0000 (---------------)  + I gjovik
	0x00264e87, // n0x1120 c0x0000 (---------------)  + I gloppen
	0x002e5d03, // n0x1121 c0x0000 (---------------)  + I gol
	0x002fe944, // n0x1122 c0x0000 (---------------)  + I gran
	0x00301505, // n0x1123 c0x0000 (---------------)  + I grane
	0x0031db87, // n0x1124 c0x0000 (---------------)  + I granvin
	0x00333b09, // n0x1125 c0x0000 (---------------)  + I gratangen
	0x00242e08, // n0x1126 c0x0000 (---------------)  + I grimstad
	0x0024cd05, // n0x1127 c0x0000 (---------------)  + I grong
	0x0024fc44, // n0x1128 c0x0000 (---------------)  + I grue
	0x002d8185, // n0x1129 c0x0000 (---------------)  + I gulen
	0x00276b8d, // n0x112a c0x0000 (---------------)  + I guovdageaidnu
	0x00201682, // n0x112b c0x0000 (---------------)  + I ha
	0x0029be86, // n0x112c c0x0000 (---------------)  + I habmer
	0x00309a06, // n0x112d c0x0000 (---------------)  + I hadsel
	0x00320f4a, // n0x112e c0x0000 (---------------)  + I hagebostad
	0x00274e46, // n0x112f c0x0000 (---------------)  + I halden
	0x00274fc5, // n0x1130 c0x0000 (---------------)  + I halsa
	0x002a85c5, // n0x1131 c0x0000 (---------------)  + I hamar
	0x002a85c7, // n0x1132 c0x0000 (---------------)  + I hamaroy
	0x0027590c, // n0x1133 c0x0000 (---------------)  + I hammarfeasta
	0x00241b4a, // n0x1134 c0x0000 (---------------)  + I hammerfest
	0x00278746, // n0x1135 c0x0000 (---------------)  + I hapmir
	0x002b1505, // n0x1136 c0x0000 (---------------)  + I haram
	0x00279106, // n0x1137 c0x0000 (---------------)  + I hareid
	0x00279907, // n0x1138 c0x0000 (---------------)  + I harstad
	0x0027a906, // n0x1139 c0x0000 (---------------)  + I hasvik
	0x0027c5cc, // n0x113a c0x0000 (---------------)  + I hattfjelldal
	0x00265a89, // n0x113b c0x0000 (---------------)  + I haugesund
	0x34e48487, // n0x113c c0x00d3 (n0x135f-n0x1362)  o I hedmark
	0x00263c05, // n0x113d c0x0000 (---------------)  + I hemne
	0x00263c06, // n0x113e c0x0000 (---------------)  + I hemnes
	0x0027d848, // n0x113f c0x0000 (---------------)  + I hemsedal
	0x002a2105, // n0x1140 c0x0000 (---------------)  + I herad
	0x0028f005, // n0x1141 c0x0000 (---------------)  + I hitra
	0x0028f488, // n0x1142 c0x0000 (---------------)  + I hjartdal
	0x0028f68a, // n0x1143 c0x0000 (---------------)  + I hjelmeland
	0x35263882, // n0x1144 c0x00d4 (n0x1362-n0x1363)  + I hl
	0x3568ad42, // n0x1145 c0x00d5 (n0x1363-n0x1364)  + I hm
	0x0031f2c5, // n0x1146 c0x0000 (---------------)  + I hobol
	0x002bfec3, // n0x1147 c0x0000 (---------------)  + I hof
	0x0032a748, // n0x1148 c0x0000 (---------------)  + I hokksund
	0x0022a303, // n0x1149 c0x0000 (---------------)  + I hol
	0x0028f904, // n0x114a c0x0000 (---------------)  + I hole
	0x002e94cb, // n0x114b c0x0000 (---------------)  + I holmestrand
	0x0022a308, // n0x114c c0x0000 (---------------)  + I holtalen
	0x0023dd48, // n0x114d c0x0000 (---------------)  + I honefoss
	0x35a37609, // n0x114e c0x00d6 (n0x1364-n0x1365)  o I hordaland
	0x00292909, // n0x114f c0x0000 (---------------)  + I hornindal
	0x00292b46, // n0x1150 c0x0000 (---------------)  + I horten
	0x00293d88, // n0x1151 c0x0000 (---------------)  + I hoyanger
	0x00293f89, // n0x1152 c0x0000 (---------------)  + I hoylandet
	0x00295846, // n0x1153 c0x0000 (---------------)  + I hurdal
	0x002959c5, // n0x1154 c0x0000 (---------------)  + I hurum
	0x00331586, // n0x1155 c0x0000 (---------------)  + I hvaler
	0x002cdb49, // n0x1156 c0x0000 (---------------)  + I hyllestad
	0x002afd07, // n0x1157 c0x0000 (---------------)  + I ibestad
	0x00289dc6, // n0x1158 c0x0000 (---------------)  + I idrett
	0x002ecb47, // n0x1159 c0x0000 (---------------)  + I inderoy
	0x002bba87, // n0x115a c0x0000 (---------------)  + I iveland
	0x00278b04, // n0x115b c0x0000 (---------------)  + I ivgu
	0x35e19ec9, // n0x115c c0x00d7 (n0x1365-n0x1366)  + I jan-mayen
	0x0025f388, // n0x115d c0x0000 (---------------)  + I jessheim
	0x00314cc8, // n0x115e c0x0000 (---------------)  + I jevnaker
	0x002cf887, // n0x115f c0x0000 (---------------)  + I jolster
	0x002b3706, // n0x1160 c0x0000 (---------------)  + I jondal
	0x0024bbc9, // n0x1161 c0x0000 (---------------)  + I jorpeland
	0x002a88c7, // n0x1162 c0x0000 (---------------)  + I kafjord
	0x002f224a, // n0x1163 c0x0000 (---------------)  + I karasjohka
	0x002f4348, // n0x1164 c0x0000 (---------------)  + I karasjok
	0x002279c7, // n0x1165 c0x0000 (---------------)  + I karlsoy
	0x002bcd86, // n0x1166 c0x0000 (---------------)  + I karmoy
	0x0030dbca, // n0x1167 c0x0000 (---------------)  + I kautokeino
	0x0025ba88, // n0x1168 c0x0000 (---------------)  + I kirkenes
	0x00297dc5, // n0x1169 c0x0000 (---------------)  + I klabu
	0x00223f45, // n0x116a c0x0000 (---------------)  + I klepp
	0x002cc2c7, // n0x116b c0x0000 (---------------)  + I kommune
	0x002ec1c9, // n0x116c c0x0000 (---------------)  + I kongsberg
	0x002f024b, // n0x116d c0x0000 (---------------)  + I kongsvinger
	0x00297c08, // n0x116e c0x0000 (---------------)  + I kopervik
	0x00214f09, // n0x116f c0x0000 (---------------)  + I kraanghke
	0x0029f707, // n0x1170 c0x0000 (---------------)  + I kragero
	0x002a184c, // n0x1171 c0x0000 (---------------)  + I kristiansand
	0x002a1ccc, // n0x1172 c0x0000 (---------------)  + I kristiansund
	0x002a1fca, // n0x1173 c0x0000 (---------------)  + I krodsherad
	0x002a224c, // n0x1174 c0x0000 (---------------)  + I krokstadelva
	0x002abb48, // n0x1175 c0x0000 (---------------)  + I kvafjord
	0x002abd48, // n0x1176 c0x0000 (---------------)  + I kvalsund
	0x002abf44, // n0x1177 c0x0000 (---------------)  + I kvam
	0x002ac409, // n0x1178 c0x0000 (---------------)  + I kvanangen
	0x002ac649, // n0x1179 c0x0000 (---------------)  + I kvinesdal
	0x002ac88a, // n0x117a c0x0000 (---------------)  + I kvinnherad
	0x002acb09, // n0x117b c0x0000 (---------------)  + I kviteseid
	0x002ace47, // n0x117c c0x0000 (---------------)  + I kvitsoy
	0x002064cc, // n0x117d c0x0000 (---------------)  + I laakesvuemie
	0x00258c86, // n0x117e c0x0000 (---------------)  + I lahppi
	0x002a5708, // n0x117f c0x0000 (---------------)  + I langevag
	0x002c8186, // n0x1180 c0x0000 (---------------)  + I lardal
	0x0031c4c6, // n0x1181 c0x0000 (---------------)  + I larvik
	0x00325507, // n0x1182 c0x0000 (---------------)  + I lavagis
	0x00326508, // n0x1183 c0x0000 (---------------)  + I lavangen
	0x002fd70b, // n0x1184 c0x0000 (---------------)  + I leangaviika
	0x002c95c7, // n0x1185 c0x0000 (---------------)  + I lebesby
	0x002832c9, // n0x1186 c0x0000 (---------------)  + I leikanger
	0x0028b149, // n0x1187 c0x0000 (---------------)  + I leirfjord
	0x00303407, // n0x1188 c0x0000 (---------------)  + I leirvik
	0x00261b04, // n0x1189 c0x0000 (---------------)  + I leka
	0x002ce147, // n0x118a c0x0000 (---------------)  + I leksvik
	0x002e7186, // n0x118b c0x0000 (---------------)  + I lenvik
	0x00244fc6, // n0x118c c0x0000 (---------------)  + I lerdal
	0x00223985, // n0x118d c0x0000 (---------------)  + I lesja
	0x002ea648, // n0x118e c0x0000 (---------------)  + I levanger
	0x002b1644, // n0x118f c0x0000 (---------------)  + I lier
	0x002b1646, // n0x1190 c0x0000 (---------------)  + I lierne
	0x00241a0b, // n0x1191 c0x0000 (---------------)  + I lillehammer
	0x002f8c49, // n0x1192 c0x0000 (---------------)  + I lillesand
	0x00237386, // n0x1193 c0x0000 (---------------)  + I lindas
	0x0034cc09, // n0x1194 c0x0000 (---------------)  + I lindesnes
	0x00212d06, // n0x1195 c0x0000 (---------------)  + I loabat
	0x0024ac88, // n0x1196 c0x0000 (---------------)  + I lodingen
	0x002f7d83, // n0x1197 c0x0000 (---------------)  + I lom
	0x00211405, // n0x1198 c0x0000 (---------------)  + I loppa
	0x002cddc9, // n0x1199 c0x0000 (---------------)  + I lorenskog
	0x0020bf45, // n0x119a c0x0000 (---------------)  + I loten
	0x002e1cc4, // n0x119b c0x0000 (---------------)  + I lund
	0x00267346, // n0x119c c0x0000 (---------------)  + I lunner
	0x00336185, // n0x119d c0x0000 (---------------)  + I luroy
	0x0034a586, // n0x119e c0x0000 (---------------)  + I luster
	0x002f3987, // n0x119f c0x0000 (---------------)  + I lyngdal
	0x00309646, // n0x11a0 c0x0000 (---------------)  + I lyngen
	0x0028170b, // n0x11a1 c0x0000 (---------------)  + I malatvuopmi
	0x002599c7, // n0x11a2 c0x0000 (---------------)  + I malselv
	0x00218306, // n0x11a3 c0x0000 (---------------)  + I malvik
	0x00330bc6, // n0x11a4 c0x0000 (---------------)  + I mandal
	0x00266686, // n0x11a5 c0x0000 (---------------)  + I marker
	0x0025ca09, // n0x11a6 c0x0000 (---------------)  + I marnardal
	0x00295d8a, // n0x11a7 c0x0000 (---------------)  + I masfjorden
	0x002912c5, // n0x11a8 c0x0000 (---------------)  + I masoy
	0x002b858d, // n0x11a9 c0x0000 (---------------)  + I matta-varjjat
	0x0028f786, // n0x11aa c0x0000 (---------------)  + I meland
	0x00277e86, // n0x11ab c0x0000 (---------------)  + I meldal
	0x0023bc86, // n0x11ac c0x0000 (---------------)  + I melhus
	0x0033f805, // n0x11ad c0x0000 (---------------)  + I meloy
	0x00286447, // n0x11ae c0x0000 (---------------)  + I meraker
	0x0026f087, // n0x11af c0x0000 (---------------)  + I midsund
	0x0027f8ce, // n0x11b0 c0x0000 (---------------)  + I midtre-gauldal
	0x0022f003, // n0x11b1 c0x0000 (---------------)  + I mil
	0x002b36c9, // n0x11b2 c0x0000 (---------------)  + I mjondalen
	0x0028bd49, // n0x11b3 c0x0000 (---------------)  + I mo-i-rana
	0x00237007, // n0x11b4 c0x0000 (---------------)  + I moareke
	0x00249487, // n0x11b5 c0x0000 (---------------)  + I modalen
	0x0029e385, // n0x11b6 c0x0000 (---------------)  + I modum
	0x0020d6c5, // n0x11b7 c0x0000 (---------------)  + I molde
	0x3634c88f, // n0x11b8 c0x00d8 (n0x1366-n0x1368)  o I more-og-romsdal
	0x002b9e87, // n0x11b9 c0x0000 (---------------)  + I mosjoen
	0x002ba048, // n0x11ba c0x0000 (---------------)  + I moskenes
	0x002ba944, // n0x11bb c0x0000 (---------------)  + I moss
	0x002bad06, // n0x11bc c0x0000 (---------------)  + I mosvik
	0x366412c2, // n0x11bd c0x00d9 (n0x1368-n0x1369)  + I mr
	0x002c2506, // n0x11be c0x0000 (---------------)  + I muosat
	0x002c4946, // n0x11bf c0x0000 (---------------)  + I museum
	0x0034128e, // n0x11c0 c0x0000 (---------------)  + I naamesjevuemie
	0x0031b2ca, // n0x11c1 c0x0000 (---------------)  + I namdalseid
	0x00289fc6, // n0x11c2 c0x0000 (---------------)  + I namsos
	0x0027acca, // n0x11c3 c0x0000 (---------------)  + I namsskogan
	0x0025efc9, // n0x11c4 c0x0000 (---------------)  + I nannestad
	0x003342c5, // n0x11c5 c0x0000 (---------------)  + I naroy
	0x00230b08, // n0x11c6 c0x0000 (---------------)  + I narviika
	0x002313c6, // n0x11c7 c0x0000 (---------------)  + I narvik
	0x00209ec8, // n0x11c8 c0x0000 (---------------)  + I naustdal
	0x0020ca48, // n0x11c9 c0x0000 (---------------)  + I navuotna
	0x0028ba4b, // n0x11ca c0x0000 (---------------)  + I nedre-eiker
	0x00222905, // n0x11cb c0x0000 (---------------)  + I nesna
	0x002263c8, // n0x11cc c0x0000 (---------------)  + I nesodden
	0x0020f78c, // n0x11cd c0x0000 (---------------)  + I nesoddtangen
	0x002139c7, // n0x11ce c0x0000 (---------------)  + I nesseby
	0x0033ec46, // n0x11cf c0x0000 (---------------)  + I nesset
	0x00234b48, // n0x11d0 c0x0000 (---------------)  + I nissedal
	0x00207808, // n0x11d1 c0x0000 (---------------)  + I nittedal
	0x36a3ba42, // n0x11d2 c0x00da (n0x1369-n0x136a)  + I nl
	0x0023648b, // n0x11d3 c0x0000 (---------------)  + I nord-aurdal
	0x003384c9, // n0x11d4 c0x0000 (---------------)  + I nord-fron
	0x002a4809, // n0x11d5 c0x0000 (---------------)  + I nord-odal
	0x00237207, // n0x11d6 c0x0000 (---------------)  + I norddal
	0x00233688, // n0x11d7 c0x0000 (---------------)  + I nordkapp
	0x36e12688, // n0x11d8 c0x00db (n0x136a-n0x136e)  o I nordland
	0x00318d4b, // n0x11d9 c0x0000 (---------------)  + I nordre-land
	0x00239909, // n0x11da c0x0000 (---------------)  + I nordreisa
	0x002c020d, // n0x11db c0x0000 (---------------)  + I nore-og-uvdal
	0x0020d208, // n0x11dc c0x0000 (---------------)  + I notodden
	0x00286888, // n0x11dd c0x0000 (---------------)  + I notteroy
	0x37200242, // n0x11de c0x00dc (n0x136e-n0x136f)  + I nt
	0x00310044, // n0x11df c0x0000 (---------------)  + I odda
	0x37613e42, // n0x11e0 c0x00dd (n0x136f-n0x1370)  + I of
	0x00348186, // n0x11e1 c0x0000 (---------------)  + I oksnes
	0x37a053c2, // n0x11e2 c0x00de (n0x1370-n0x1371)  + I ol
	0x002e1e0a, // n0x11e3 c0x0000 (---------------)  + I omasvuotna
	0x00304146, // n0x11e4 c0x0000 (---------------)  + I oppdal
	0x0022de48, // n0x11e5 c0x0000 (---------------)  + I oppegard
	0x00223bc8, // n0x11e6 c0x0000 (---------------)  + I orkanger
	0x0023f346, // n0x11e7 c0x0000 (---------------)  + I orkdal
	0x00261046, // n0x11e8 c0x0000 (---------------)  + I orland
	0x002d24c6, // n0x11e9 c0x0000 (---------------)  + I orskog
	0x0026ae45, // n0x11ea c0x0000 (---------------)  + I orsta
	0x0023d204, // n0x11eb c0x0000 (---------------)  + I osen
	0x37e11384, // n0x11ec c0x00df (n0x1371-n0x1372)  + I oslo
	0x0020cd86, // n0x11ed c0x0000 (---------------)  + I osoyro
	0x002b0947, // n0x11ee c0x0000 (---------------)  + I osteroy
	0x382de047, // n0x11ef c0x00e0 (n0x1372-n0x1373)  o I ostfold
	0x0027be4b, // n0x11f0 c0x0000 (---------------)  + I ostre-toten
	0x00278109, // n0x11f1 c0x0000 (---------------)  + I overhalla
	0x00324bca, // n0x11f2 c0x0000 (---------------)  + I ovre-eiker
	0x002a8704, // n0x11f3 c0x0000 (---------------)  + I oyer
	0x00225788, // n0x11f4 c0x0000 (---------------)  + I oygarden
	0x00289b8d, // n0x11f5 c0x0000 (---------------)  + I oystre-slidre
	0x002cf449, // n0x11f6 c0x0000 (---------------)  + I porsanger
	0x002cf688, // n0x11f7 c0x0000 (---------------)  + I porsangu
	0x002cfa49, // n0x11f8 c0x0000 (---------------)  + I porsgrunn
	0x002d1204, // n0x11f9 c0x0000 (---------------)  + I priv
	0x002556c4, // n0x11fa c0x0000 (---------------)  + I rade
	0x0026db05, // n0x11fb c0x0000 (---------------)  + I radoy
	0x0022fe0b, // n0x11fc c0x0000 (---------------)  + I rahkkeravju
	0x0022a286, // n0x11fd c0x0000 (---------------)  + I raholt
	0x002a5345, // n0x11fe c0x0000 (---------------)  + I raisa
	0x002514c9, // n0x11ff c0x0000 (---------------)  + I rakkestad
	0x00222b08, // n0x1200 c0x0000 (---------------)  + I ralingen
	0x00289f44, // n0x1201 c0x0000 (---------------)  + I rana
	0x00236d89, // n0x1202 c0x0000 (---------------)  + I randaberg
	0x00289645, // n0x1203 c0x0000 (---------------)  + I rauma
	0x002e7048, // n0x1204 c0x0000 (---------------)  + I rendalen
	0x002447c7, // n0x1205 c0x0000 (---------------)  + I rennebu
	0x00225608, // n0x1206 c0x0000 (---------------)  + I rennesoy
	0x0029dbc6, // n0x1207 c0x0000 (---------------)  + I rindal
	0x00217ac7, // n0x1208 c0x0000 (---------------)  + I ringebu
	0x0025b389, // n0x1209 c0x0000 (---------------)  + I ringerike
	0x0030e1c9, // n0x120a c0x0000 (---------------)  + I ringsaker
	0x00309c85, // n0x120b c0x0000 (---------------)  + I risor
	0x002620c5, // n0x120c c0x0000 (---------------)  + I rissa
	0x38602502, // n0x120d c0x00e1 (n0x1373-n0x1374)  + I rl
	0x002c2ec4, // n0x120e c0x0000 (---------------)  + I roan
	0x002a6f45, // n0x120f c0x0000 (---------------)  + I rodoy
	0x00302bc6, // n0x1210 c0x0000 (---------------)  + I rollag
	0x002d2f05, // n0x1211 c0x0000 (---------------)  + I romsa
	0x00276f07, // n0x1212 c0x0000 (---------------)  + I romskog
	0x0023e445, // n0x1213 c0x0000 (---------------)  + I roros
	0x00267d84, // n0x1214 c0x0000 (---------------)  + I rost
	0x002b0a46, // n0x1215 c0x0000 (---------------)  + I royken
	0x002328c7, // n0x1216 c0x0000 (---------------)  + I royrvik
	0x00285306, // n0x1217 c0x0000 (---------------)  + I ruovat
	0x0023a705, // n0x1218 c0x0000 (---------------)  + I rygge
	0x0023b888, // n0x1219 c0x0000 (---------------)  + I salangen
	0x0023bac5, // n0x121a c0x0000 (---------------)  + I salat
	0x0023c147, // n0x121b c0x0000 (---------------)  + I saltdal
	0x00249989, // n0x121c c0x0000 (---------------)  + I samnanger
	0x002a1a4a, // n0x121d c0x0000 (---------------)  + I sandefjord
	0x00274b47, // n0x121e c0x0000 (---------------)  + I sandnes
	0x00274b4c, // n0x121f c0x0000 (---------------)  + I sandnessjoen
	0x00239ec6, // n0x1220 c0x0000 (---------------)  + I sandoy
	0x0028cc09, // n0x1221 c0x0000 (---------------)  + I sarpsborg
	0x002da645, // n0x1222 c0x0000 (---------------)  + I sauda
	0x002eb8c8, // n0x1223 c0x0000 (---------------)  + I sauherad
	0x002234c3, // n0x1224 c0x0000 (---------------)  + I sel
	0x00336f45, // n0x1225 c0x0000 (---------------)  + I selbu
	0x0030a605, // n0x1226 c0x0000 (---------------)  + I selje
	0x0033ef07, // n0x1227 c0x0000 (---------------)  + I seljord
	0x38a31c02, // n0x1228 c0x00e2 (n0x1374-n0x1375)  + I sf
	0x0021a947, // n0x1229 c0x0000 (---------------)  + I siellak
	0x002e0ac6, // n0x122a c0x0000 (---------------)  + I sigdal
	0x00219e06, // n0x122b c0x0000 (---------------)  + I siljan
	0x002e14c6, // n0x122c c0x0000 (---------------)  + I sirdal
	0x00207746, // n0x122d c0x0000 (---------------)  + I skanit
	0x0030b988, // n0x122e c0x0000 (---------------)  + I skanland
	0x002fb245, // n0x122f c0x0000 (---------------)  + I skaun
	0x00254c07, // n0x1230 c0x0000 (---------------)  + I skedsmo
	0x00254c0d, // n0x1231 c0x0000 (---------------)  + I skedsmokorset
	0x00202203, // n0x1232 c0x0000 (---------------)  + I ski
	0x00233c45, // n0x1233 c0x0000 (---------------)  + I skien
	0x00290b07, // n0x1234 c0x0000 (---------------)  + I skierva
	0x002c1a08, // n0x1235 c0x0000 (---------------)  + I skiptvet
	0x00226845, // n0x1236 c0x0000 (---------------)  + I skjak
	0x00289a08, // n0x1237 c0x0000 (---------------)  + I skjervoy
	0x00253786, // n0x1238 c0x0000 (---------------)  + I skodje
	0x002d3a87, // n0x1239 c0x0000 (---------------)  + I slattum
	0x002500c5, // n0x123a c0x0000 (---------------)  + I smola
	0x00222986, // n0x123b c0x0000 (---------------)  + I snaase
	0x00228c05, // n0x123c c0x0000 (---------------)  + I snasa
	0x0025de4a, // n0x123d c0x0000 (---------------)  + I snillfjord
	0x002aaa86, // n0x123e c0x0000 (---------------)  + I snoasa
	0x00272ec7, // n0x123f c0x0000 (---------------)  + I sogndal
	0x002a7705, // n0x1240 c0x0000 (---------------)  + I sogne
	0x002de2c7, // n0x1241 c0x0000 (---------------)  + I sokndal
	0x002b89c4, // n0x1242 c0x0000 (---------------)  + I sola
	0x002e1c46, // n0x1243 c0x0000 (---------------)  + I solund
	0x002e2205, // n0x1244 c0x0000 (---------------)  + I somna
	0x00221dcb, // n0x1245 c0x0000 (---------------)  + I sondre-land
	0x00301e49, // n0x1246 c0x0000 (---------------)  + I songdalen
	0x00257d8a, // n0x1247 c0x0000 (---------------)  + I sor-aurdal
	0x00309d08, // n0x1248 c0x0000 (---------------)  + I sor-fron
	0x002e2a48, // n0x1249 c0x0000 (---------------)  + I sor-odal
	0x002e2c4c, // n0x124a c0x0000 (---------------)  + I sor-varanger
	0x002e2f47, // n0x124b c0x0000 (---------------)  + I sorfold
	0x002e3108, // n0x124c c0x0000 (---------------)  + I sorreisa
	0x002e3fc8, // n0x124d c0x0000 (---------------)  + I sortland
	0x002e41c5, // n0x124e c0x0000 (---------------)  + I sorum
	0x002e678a, // n0x124f c0x0000 (---------------)  + I spjelkavik
	0x002e6d09, // n0x1250 c0x0000 (---------------)  + I spydeberg
	0x38e01382, // n0x1251 c0x00e3 (n0x1375-n0x1376)  + I st
	0x002c0e86, // n0x1252 c0x0000 (---------------)  + I stange
	0x0028af84, // n0x1253 c0x0000 (---------------)  + I stat
	0x0028af89, // n0x1254 c0x0000 (---------------)  + I stathelle
	0x002d3489, // n0x1255 c0x0000 (---------------)  + I stavanger
	0x0025bf07, // n0x1256 c0x0000 (---------------)  + I stavern
	0x002cb287, // n0x1257 c0x0000 (---------------)  + I steigen
	0x002e8049, // n0x1258 c0x0000 (---------------)  + I steinkjer
	0x002e8fc8, // n0x1259 c0x0000 (---------------)  + I stjordal
	0x002e8fcf, // n0x125a c0x0000 (---------------)  + I stjordalshalsen
	0x00298c06, // n0x125b c0x0000 (---------------)  + I stokke
	0x002e978b, // n0x125c c0x0000 (---------------)  + I stor-elvdal
	0x002e9a45, // n0x125d c0x0000 (---------------)  + I stord
	0x002e9a47, // n0x125e c0x0000 (---------------)  + I stordal
	0x002e9e89, // n0x125f c0x0000 (---------------)  + I storfjord
	0x00236d06, // n0x1260 c0x0000 (---------------)  + I strand
	0x00236d07, // n0x1261 c0x0000 (---------------)  + I stranda
	0x00208d45, // n0x1262 c0x0000 (---------------)  + I stryn
	0x002355c4, // n0x1263 c0x0000 (---------------)  + I sula
	0x00207486, // n0x1264 c0x0000 (---------------)  + I suldal
	0x00205984, // n0x1265 c0x0000 (---------------)  + I sund
	0x002aa3c7, // n0x1266 c0x0000 (---------------)  + I sunndal
	0x002d29c8, // n0x1267 c0x0000 (---------------)  + I surnadal
	0x392ebac8, // n0x1268 c0x00e4 (n0x1376-n0x1377)  + I svalbard
	0x002ebf05, // n0x1269 c0x0000 (---------------)  + I sveio
	0x002ec047, // n0x126a c0x0000 (---------------)  + I svelvik
	0x0028d389, // n0x126b c0x0000 (---------------)  + I sykkylven
	0x00232d44, // n0x126c c0x0000 (---------------)  + I tana
	0x002e6b08, // n0x126d c0x0000 (---------------)  + I tananger
	0x396a9f88, // n0x126e c0x00e5 (n0x1377-n0x1379)  o I telemark
	0x0024f6c4, // n0x126f c0x0000 (---------------)  + I time
	0x00238608, // n0x1270 c0x0000 (---------------)  + I tingvoll
	0x002bc284, // n0x1271 c0x0000 (---------------)  + I tinn
	0x0023ac49, // n0x1272 c0x0000 (---------------)  + I tjeldsund
	0x0023bbc5, // n0x1273 c0x0000 (---------------)  + I tjome
	0x39a3a842, // n0x1274 c0x00e6 (n0x1379-n0x137a)  + I tm
	0x00298c45, // n0x1275 c0x0000 (---------------)  + I tokke
	0x0021b405, // n0x1276 c0x0000 (---------------)  + I tolga
	0x003065c8, // n0x1277 c0x0000 (---------------)  + I tonsberg
	0x0024e847, // n0x1278 c0x0000 (---------------)  + I torsken
	0x39e08d82, // n0x1279 c0x00e7 (n0x137a-n0x137b)  + I tr
	0x00289f05, // n0x127a c0x0000 (---------------)  + I trana
	0x00291806, // n0x127b c0x0000 (---------------)  + I tranby
	0x002a9106, // n0x127c c0x0000 (---------------)  + I tranoy
	0x002c2e88, // n0x127d c0x0000 (---------------)  + I troandin
	0x002c4748, // n0x127e c0x0000 (---------------)  + I trogstad
	0x002d2ec6, // n0x127f c0x0000 (---------------)  + I tromsa
	0x002d1c86, // n0x1280 c0x0000 (---------------)  + I tromso
	0x00241f49, // n0x1281 c0x0000 (---------------)  + I trondheim
	0x0031ed06, // n0x1282 c0x0000 (---------------)  + I trysil
	0x00343e0b, // n0x1283 c0x0000 (---------------)  + I tvedestrand
	0x0034a485, // n0x1284 c0x0000 (---------------)  + I tydal
	0x0020d986, // n0x1285 c0x0000 (---------------)  + I tynset
	0x0023e0c8, // n0x1286 c0x0000 (---------------)  + I tysfjord
	0x002be206, // n0x1287 c0x0000 (---------------)  + I tysnes
	0x002c5986, // n0x1288 c0x0000 (---------------)  + I tysvar
	0x002e7dca, // n0x1289 c0x0000 (---------------)  + I ullensaker
	0x0034690a, // n0x128a c0x0000 (---------------)  + I ullensvang
	0x0025e205, // n0x128b c0x0000 (---------------)  + I ulvik
	0x00328e87, // n0x128c c0x0000 (---------------)  + I unjarga
	0x00265e06, // n0x128d c0x0000 (---------------)  + I utsira
	0x3a206f02, // n0x128e c0x00e8 (n0x137b-n0x137c)  + I va
	0x00290c47, // n0x128f c0x0000 (---------------)  + I vaapste
	0x002663c5, // n0x1290 c0x0000 (---------------)  + I vadso
	0x002c7d44, // n0x1291 c0x0000 (---------------)  + I vaga
	0x002c7d45, // n0x1292 c0x0000 (---------------)  + I vagan
	0x002a5846, // n0x1293 c0x0000 (---------------)  + I vagsoy
	0x0028df47, // n0x1294 c0x0000 (---------------)  + I vaksdal
	0x00219545, // n0x1295 c0x0000 (---------------)  + I valle
	0x002d3544, // n0x1296 c0x0000 (---------------)  + I vang
	0x002115c8, // n0x1297 c0x0000 (---------------)  + I vanylven
	0x002c5a45, // n0x1298 c0x0000 (---------------)  + I vardo
	0x002eaac7, // n0x1299 c0x0000 (---------------)  + I varggat
	0x00346645, // n0x129a c0x0000 (---------------)  + I varoy
	0x0025dd85, // n0x129b c0x0000 (---------------)  + I vefsn
	0x002b5504, // n0x129c c0x0000 (---------------)  + I vega
	0x002b5509, // n0x129d c0x0000 (---------------)  + I vegarshei
	0x00267648, // n0x129e c0x0000 (---------------)  + I vennesla
	0x002eac86, // n0x129f c0x0000 (---------------)  + I verdal
	0x00282246, // n0x12a0 c0x0000 (---------------)  + I verran
	0x00297886, // n0x12a1 c0x0000 (---------------)  + I vestby
	0x3a6e1988, // n0x12a2 c0x00e9 (n0x137c-n0x137d)  o I vestfold
	0x002e7b87, // n0x12a3 c0x0000 (---------------)  + I vestnes
	0x002ed64d, // n0x12a4 c0x0000 (---------------)  + I vestre-slidre
	0x002edf8c, // n0x12a5 c0x0000 (---------------)  + I vestre-toten
	0x002ee609, // n0x12a6 c0x0000 (---------------)  + I vestvagoy
	0x002ee849, // n0x12a7 c0x0000 (---------------)  + I vevelstad
	0x3ab15602, // n0x12a8 c0x00ea (n0x137d-n0x137e)  + I vf
	0x00348ac3, // n0x12a9 c0x0000 (---------------)  + I vgs
	0x00209543, // n0x12aa c0x0000 (---------------)  + I vik
	0x002329c5, // n0x12ab c0x0000 (---------------)  + I vikna
	0x0031dc8a, // n0x12ac c0x0000 (---------------)  + I vindafjord
	0x002fb846, // n0x12ad c0x0000 (---------------)  + I voagat
	0x00215245, // n0x12ae c0x0000 (---------------)  + I volda
	0x002f3ec4, // n0x12af c0x0000 (---------------)  + I voss
	0x002f3ecb, // n0x12b0 c0x0000 (---------------)  + I vossevangen
	0x002e0f4c, // n0x12b1 c0x0000 (---------------)  + I xn--andy-ira
	0x002ed34c, // n0x12b2 c0x0000 (---------------)  + I xn--asky-ira
	0x0034c255, // n0x12b3 c0x0000 (---------------)  + I xn--aurskog-hland-jnb
	0x0034e78d, // n0x12b4 c0x0000 (---------------)  + I xn--avery-yua
	0x002f4b8f, // n0x12b5 c0x0000 (---------------)  + I xn--bdddj-mrabd
	0x002f4f52, // n0x12b6 c0x0000 (---------------)  + I xn--bearalvhki-y4a
	0x002f53cf, // n0x12b7 c0x0000 (---------------)  + I xn--berlevg-jxa
	0x002f5792, // n0x12b8 c0x0000 (---------------)  + I xn--bhcavuotna-s4a
	0x002f5c13, // n0x12b9 c0x0000 (---------------)  + I xn--bhccavuotna-k7a
	0x002f60cd, // n0x12ba c0x0000 (---------------)  + I xn--bidr-5nac
	0x002f668d, // n0x12bb c0x0000 (---------------)  + I xn--bievt-0qa
	0x002f69ce, // n0x12bc c0x0000 (---------------)  + I xn--bjarky-fya
	0x002f710e, // n0x12bd c0x0000 (---------------)  + I xn--bjddar-pta
	0x002f760c, // n0x12be c0x0000 (---------------)  + I xn--blt-elab
	0x002f798c, // n0x12bf c0x0000 (---------------)  + I xn--bmlo-gra
	0x002f840b, // n0x12c0 c0x0000 (---------------)  + I xn--bod-2na
	0x002f90ce, // n0x12c1 c0x0000 (---------------)  + I xn--brnny-wuac
	0x002fa7d2, // n0x12c2 c0x0000 (---------------)  + I xn--brnnysund-m8ac
	0x002fb60c, // n0x12c3 c0x0000 (---------------)  + I xn--brum-voa
	0x002fb9d0, // n0x12c4 c0x0000 (---------------)  + I xn--btsfjord-9za
	0x002fe292, // n0x12c5 c0x0000 (---------------)  + I xn--davvenjrga-y4a
	0x002fe70c, // n0x12c6 c0x0000 (---------------)  + I xn--dnna-gra
	0x002fef0d, // n0x12c7 c0x0000 (---------------)  + I xn--drbak-wua
	0x002ff24c, // n0x12c8 c0x0000 (---------------)  + I xn--dyry-ira
	0x002ff551, // n0x12c9 c0x0000 (---------------)  + I xn--eveni-0qa01ga
	0x002ff98d, // n0x12ca c0x0000 (---------------)  + I xn--finny-yua
	0x003006cd, // n0x12cb c0x0000 (---------------)  + I xn--fjord-lra
	0x00300a0a, // n0x12cc c0x0000 (---------------)  + I xn--fl-zia
	0x00300c8c, // n0x12cd c0x0000 (---------------)  + I xn--flor-jra
	0x003012cc, // n0x12ce c0x0000 (---------------)  + I xn--frde-gra
	0x0030164c, // n0x12cf c0x0000 (---------------)  + I xn--frna-woa
	0x0030208c, // n0x12d0 c0x0000 (---------------)  + I xn--frya-hra
	0x00305413, // n0x12d1 c0x0000 (---------------)  + I xn--ggaviika-8ya47h
	0x00305b90, // n0x12d2 c0x0000 (---------------)  + I xn--gildeskl-g0a
	0x00305f90, // n0x12d3 c0x0000 (---------------)  + I xn--givuotna-8ya
	0x003067cd, // n0x12d4 c0x0000 (---------------)  + I xn--gjvik-wua
	0x00306b0c, // n0x12d5 c0x0000 (---------------)  + I xn--gls-elac
	0x00309389, // n0x12d6 c0x0000 (---------------)  + I xn--h-2fa
	0x0030aa0d, // n0x12d7 c0x0000 (---------------)  + I xn--hbmer-xqa
	0x0030ad53, // n0x12d8 c0x0000 (---------------)  + I xn--hcesuolo-7ya35b
	0x0030d151, // n0x12d9 c0x0000 (---------------)  + I xn--hgebostad-g3a
	0x0030d593, // n0x12da c0x0000 (---------------)  + I xn--hmmrfeasta-s4ac
	0x0030e40f, // n0x12db c0x0000 (---------------)  + I xn--hnefoss-q1a
	0x0030e7cc, // n0x12dc c0x0000 (---------------)  + I xn--hobl-ira
	0x0030eacf, // n0x12dd c0x0000 (---------------)  + I xn--holtlen-hxa
	0x0030ee8d, // n0x12de c0x0000 (---------------)  + I xn--hpmir-xqa
	0x0030f1cf, // n0x12df c0x0000 (---------------)  + I xn--hyanger-q1a
	0x0030f590, // n0x12e0 c0x0000 (---------------)  + I xn--hylandet-54a
	0x0030f98e, // n0x12e1 c0x0000 (---------------)  + I xn--indery-fya
	0x00310f8e, // n0x12e2 c0x0000 (---------------)  + I xn--jlster-bya
	0x00311b10, // n0x12e3 c0x0000 (---------------)  + I xn--jrpeland-54a
	0x00311f0d, // n0x12e4 c0x0000 (---------------)  + I xn--karmy-yua
	0x0031224e, // n0x12e5 c0x0000 (---------------)  + I xn--kfjord-iua
	0x003125cc, // n0x12e6 c0x0000 (---------------)  + I xn--klbu-woa
	0x003128d3, // n0x12e7 c0x0000 (---------------)  + I xn--koluokta-7ya57h
	0x003133ce, // n0x12e8 c0x0000 (---------------)  + I xn--krager-gya
	0x00313c50, // n0x12e9 c0x0000 (---------------)  + I xn--kranghke-b0a
	0x00314051, // n0x12ea c0x0000 (---------------)  + I xn--krdsherad-m8a
	0x0031448f, // n0x12eb c0x0000 (---------------)  + I xn--krehamn-dxa
	0x00314853, // n0x12ec c0x0000 (---------------)  + I xn--krjohka-hwab49j
	0x0031518d, // n0x12ed c0x0000 (---------------)  + I xn--ksnes-uua
	0x003154cf, // n0x12ee c0x0000 (---------------)  + I xn--kvfjord-nxa
	0x0031588e, // n0x12ef c0x0000 (---------------)  + I xn--kvitsy-fya
	0x00315e50, // n0x12f0 c0x0000 (---------------)  + I xn--kvnangen-k0a
	0x00316249, // n0x12f1 c0x0000 (---------------)  + I xn--l-1fa
	0x00316950, // n0x12f2 c0x0000 (---------------)  + I xn--laheadju-7ya
	0x00316f4f, // n0x12f3 c0x0000 (---------------)  + I xn--langevg-jxa
	0x003175cf, // n0x12f4 c0x0000 (---------------)  + I xn--ldingen-q1a
	0x00317992, // n0x12f5 c0x0000 (---------------)  + I xn--leagaviika-52b
	0x0031a5ce, // n0x12f6 c0x0000 (---------------)  + I xn--lesund-hua
	0x0031ae8d, // n0x12f7 c0x0000 (---------------)  + I xn--lgrd-poac
	0x0031b68d, // n0x12f8 c0x0000 (---------------)  + I xn--lhppi-xqa
	0x0031b9cd, // n0x12f9 c0x0000 (---------------)  + I xn--linds-pra
	0x0031ca0d, // n0x12fa c0x0000 (---------------)  + I xn--loabt-0qa
	0x0031cd4d, // n0x12fb c0x0000 (---------------)  + I xn--lrdal-sra
	0x0031d090, // n0x12fc c0x0000 (---------------)  + I xn--lrenskog-54a
	0x0031d48b, // n0x12fd c0x0000 (---------------)  + I xn--lt-liac
	0x0031d94c, // n0x12fe c0x0000 (---------------)  + I xn--lten-gra
	0x0031df0c, // n0x12ff c0x0000 (---------------)  + I xn--lury-ira
	0x0031e20c, // n0x1300 c0x0000 (---------------)  + I xn--mely-ira
	0x0031e50e, // n0x1301 c0x0000 (---------------)  + I xn--merker-kua
	0x003241d0, // n0x1302 c0x0000 (---------------)  + I xn--mjndalen-64a
	0x00324e52, // n0x1303 c0x0000 (---------------)  + I xn--mlatvuopmi-s4a
	0x003252cb, // n0x1304 c0x0000 (---------------)  + I xn--mli-tla
	0x0032574e, // n0x1305 c0x0000 (---------------)  + I xn--mlselv-iua
	0x00325ace, // n0x1306 c0x0000 (---------------)  + I xn--moreke-jua
	0x00325e4e, // n0x1307 c0x0000 (---------------)  + I xn--mosjen-eya
	0x003262cb, // n0x1308 c0x0000 (---------------)  + I xn--mot-tla
	0x3af26716, // n0x1309 c0x00eb (n0x137e-n0x1380)  o I xn--mre-og-romsdal-qqb
	0x0032750d, // n0x130a c0x0000 (---------------)  + I xn--msy-ula0h
	0x00328094, // n0x130b c0x0000 (---------------)  + I xn--mtta-vrjjat-k7af
	0x0032904d, // n0x130c c0x0000 (---------------)  + I xn--muost-0qa
	0x00329895, // n0x130d c0x0000 (---------------)  + I xn--nmesjevuemie-tcba
	0x0032a94d, // n0x130e c0x0000 (---------------)  + I xn--nry-yla5g
	0x0032ac8f, // n0x130f c0x0000 (---------------)  + I xn--nttery-byae
	0x0032b68f, // n0x1310 c0x0000 (---------------)  + I xn--nvuotna-hwa
	0x0032dc4f, // n0x1311 c0x0000 (---------------)  + I xn--oppegrd-ixa
	0x0032e00e, // n0x1312 c0x0000 (---------------)  + I xn--ostery-fya
	0x0032e58d, // n0x1313 c0x0000 (---------------)  + I xn--osyro-wua
	0x0032f7d1, // n0x1314 c0x0000 (---------------)  + I xn--porsgu-sta26f
	0x0032fe0c, // n0x1315 c0x0000 (---------------)  + I xn--rady-ira
	0x0033010c, // n0x1316 c0x0000 (---------------)  + I xn--rdal-poa
	0x0033040b, // n0x1317 c0x0000 (---------------)  + I xn--rde-ula
	0x003306cc, // n0x1318 c0x0000 (---------------)  + I xn--rdy-0nab
	0x00330d4f, // n0x1319 c0x0000 (---------------)  + I xn--rennesy-v1a
	0x00331112, // n0x131a c0x0000 (---------------)  + I xn--rhkkervju-01af
	0x0033170d, // n0x131b c0x0000 (---------------)  + I xn--rholt-mra
	0x0033218c, // n0x131c c0x0000 (---------------)  + I xn--risa-5na
	0x00332b4c, // n0x131d c0x0000 (---------------)  + I xn--risr-ira
	0x00332e4d, // n0x131e c0x0000 (---------------)  + I xn--rland-uua
	0x0033318f, // n0x131f c0x0000 (---------------)  + I xn--rlingen-mxa
	0x0033354e, // n0x1320 c0x0000 (---------------)  + I xn--rmskog-bya
	0x003338cc, // n0x1321 c0x0000 (---------------)  + I xn--rros-gra
	0x00333d4d, // n0x1322 c0x0000 (---------------)  + I xn--rskog-uua
	0x0033408b, // n0x1323 c0x0000 (---------------)  + I xn--rst-0na
	0x0033440c, // n0x1324 c0x0000 (---------------)  + I xn--rsta-fra
	0x0033498d, // n0x1325 c0x0000 (---------------)  + I xn--ryken-vua
	0x00334cce, // n0x1326 c0x0000 (---------------)  + I xn--ryrvik-bya
	0x00335049, // n0x1327 c0x0000 (---------------)  + I xn--s-1fa
	0x00336a53, // n0x1328 c0x0000 (---------------)  + I xn--sandnessjen-ogb
	0x0033754d, // n0x1329 c0x0000 (---------------)  + I xn--sandy-yua
	0x0033788d, // n0x132a c0x0000 (---------------)  + I xn--seral-lra
	0x00337bcc, // n0x132b c0x0000 (---------------)  + I xn--sgne-gra
	0x00337f0e, // n0x132c c0x0000 (---------------)  + I xn--skierv-uta
	0x0033870f, // n0x132d c0x0000 (---------------)  + I xn--skjervy-v1a
	0x00338acc, // n0x132e c0x0000 (---------------)  + I xn--skjk-soa
	0x00338dcd, // n0x132f c0x0000 (---------------)  + I xn--sknit-yqa
	0x0033910f, // n0x1330 c0x0000 (---------------)  + I xn--sknland-fxa
	0x003394cc, // n0x1331 c0x0000 (---------------)  + I xn--slat-5na
	0x0033994c, // n0x1332 c0x0000 (---------------)  + I xn--slt-elab
	0x00339d0c, // n0x1333 c0x0000 (---------------)  + I xn--smla-hra
	0x0033a00c, // n0x1334 c0x0000 (---------------)  + I xn--smna-gra
	0x0033a30d, // n0x1335 c0x0000 (---------------)  + I xn--snase-nra
	0x0033a652, // n0x1336 c0x0000 (---------------)  + I xn--sndre-land-0cb
	0x0033ab0c, // n0x1337 c0x0000 (---------------)  + I xn--snes-poa
	0x0033ae0c, // n0x1338 c0x0000 (---------------)  + I xn--snsa-roa
	0x0033b111, // n0x1339 c0x0000 (---------------)  + I xn--sr-aurdal-l8a
	0x0033b54f, // n0x133a c0x0000 (---------------)  + I xn--sr-fron-q1a
	0x0033b90f, // n0x133b c0x0000 (---------------)  + I xn--sr-odal-q1a
	0x0033bcd3, // n0x133c c0x0000 (---------------)  + I xn--sr-varanger-ggb
	0x0033c38e, // n0x133d c0x0000 (---------------)  + I xn--srfold-bya
	0x0033c70f, // n0x133e c0x0000 (---------------)  + I xn--srreisa-q1a
	0x0033cacc, // n0x133f c0x0000 (---------------)  + I xn--srum-gra
	0x3b33cdce, // n0x1340 c0x00ec (n0x1380-n0x1381)  o I xn--stfold-9xa
	0x0033d14f, // n0x1341 c0x0000 (---------------)  + I xn--stjrdal-s1a
	0x0033d516, // n0x1342 c0x0000 (---------------)  + I xn--stjrdalshalsen-sqb
	0x0033e192, // n0x1343 c0x0000 (---------------)  + I xn--stre-toten-zcb
	0x0034064c, // n0x1344 c0x0000 (---------------)  + I xn--tjme-hra
	0x003427cf, // n0x1345 c0x0000 (---------------)  + I xn--tnsberg-q1a
	0x00342b8d, // n0x1346 c0x0000 (---------------)  + I xn--trany-yua
	0x00342ecf, // n0x1347 c0x0000 (---------------)  + I xn--trgstad-r1a
	0x0034328c, // n0x1348 c0x0000 (---------------)  + I xn--trna-woa
	0x0034358d, // n0x1349 c0x0000 (---------------)  + I xn--troms-zua
	0x003438cd, // n0x134a c0x0000 (---------------)  + I xn--tysvr-vra
	0x0034438e, // n0x134b c0x0000 (---------------)  + I xn--unjrga-rta
	0x0034488c, // n0x134c c0x0000 (---------------)  + I xn--vads-jra
	0x00344b8c, // n0x134d c0x0000 (---------------)  + I xn--vard-jra
	0x00344e90, // n0x134e c0x0000 (---------------)  + I xn--vegrshei-c0a
	0x00345291, // n0x134f c0x0000 (---------------)  + I xn--vestvgy-ixa6o
	0x003456cb, // n0x1350 c0x0000 (---------------)  + I xn--vg-yiab
	0x003486cc, // n0x1351 c0x0000 (---------------)  + I xn--vgan-qoa
	0x003489ce, // n0x1352 c0x0000 (---------------)  + I xn--vgsy-qoa0j
	0x00349411, // n0x1353 c0x0000 (---------------)  + I xn--vre-eiker-k8a
	0x0034984e, // n0x1354 c0x0000 (---------------)  + I xn--vrggt-xqad
	0x00349bcd, // n0x1355 c0x0000 (---------------)  + I xn--vry-yla5g
	0x0034b30b, // n0x1356 c0x0000 (---------------)  + I xn--yer-zna
	0x0034bb8f, // n0x1357 c0x0000 (---------------)  + I xn--ygarden-p1a
	0x0034d254, // n0x1358 c0x0000 (---------------)  + I xn--ystre-slidre-ujb
	0x0023c7c2, // n0x1359 c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x135a c0x0000 (---------------)  + I gs
	0x0020f783, // n0x135b c0x0000 (---------------)  + I nes
	0x0023c7c2, // n0x135c c0x0000 (---------------)  + I gs
	0x0020f783, // n0x135d c0x0000 (---------------)  + I nes
	0x0023c7c2, // n0x135e c0x0000 (---------------)  + I gs
	0x00208982, // n0x135f c0x0000 (---------------)  + I os
	0x003315c5, // n0x1360 c0x0000 (---------------)  + I valer
	0x0034910c, // n0x1361 c0x0000 (---------------)  + I xn--vler-qoa
	0x0023c7c2, // n0x1362 c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x1363 c0x0000 (---------------)  + I gs
	0x00208982, // n0x1364 c0x0000 (---------------)  + I os
	0x0023c7c2, // n0x1365 c0x0000 (---------------)  + I gs
	0x0029aac5, // n0x1366 c0x0000 (---------------)  + I heroy
	0x002a1a45, // n0x1367 c0x0000 (---------------)  + I sande
	0x0023c7c2, // n0x1368 c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x1369 c0x0000 (---------------)  + I gs
	0x002033c2, // n0x136a c0x0000 (---------------)  + I bo
	0x0029aac5, // n0x136b c0x0000 (---------------)  + I heroy
	0x0034ed49, // n0x136c c0x0000 (---------------)  + I xn--b-5ga
	0x0030ce4c, // n0x136d c0x0000 (---------------)  + I xn--hery-ira
	0x0023c7c2, // n0x136e c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x136f c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x1370 c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x1371 c0x0000 (---------------)  + I gs
	0x003315c5, // n0x1372 c0x0000 (---------------)  + I valer
	0x0023c7c2, // n0x1373 c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x1374 c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x1375 c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x1376 c0x0000 (---------------)  + I gs
	0x002033c2, // n0x1377 c0x0000 (---------------)  + I bo
	0x0034ed49, // n0x1378 c0x0000 (---------------)  + I xn--b-5ga
	0x0023c7c2, // n0x1379 c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x137a c0x0000 (---------------)  + I gs
	0x0023c7c2, // n0x137b c0x0000 (---------------)  + I gs
	0x002a1a45, // n0x137c c0x0000 (---------------)  + I sande
	0x0023c7c2, // n0x137d c0x0000 (---------------)  + I gs
	0x002a1a45, // n0x137e c0x0000 (---------------)  + I sande
	0x0030ce4c, // n0x137f c0x0000 (---------------)  + I xn--hery-ira
	0x0034910c, // n0x1380 c0x0000 (---------------)  + I xn--vler-qoa
	0x0030c243, // n0x1381 c0x0000 (---------------)  + I biz
	0x0020d643, // n0x1382 c0x0000 (---------------)  + I com
	0x002df843, // n0x1383 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x1384 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x1385 c0x0000 (---------------)  + I info
	0x00214843, // n0x1386 c0x0000 (---------------)  + I net
	0x0023e983, // n0x1387 c0x0000 (---------------)  + I org
	0x000bb348, // n0x1388 c0x0000 (---------------)  +   merseine
	0x000f2544, // n0x1389 c0x0000 (---------------)  +   mine
	0x0011eb48, // n0x138a c0x0000 (---------------)  +   shacknet
	0x3c20d642, // n0x138b c0x00f0 (n0x138c-n0x138d)  o I co
	0x0003c708, // n0x138c c0x0000 (---------------)  +   blogspot
	0x0063dbca, // n0x138d c0x0001 (---------------)  ! I mediaphone
	0x0060d3c6, // n0x138e c0x0001 (---------------)  ! I nawras
	0x0060d3cd, // n0x138f c0x0001 (---------------)  ! I nawrastelecom
	0x0070320a, // n0x1390 c0x0001 (---------------)  ! I omanmobile
	0x00685648, // n0x1391 c0x0001 (---------------)  ! I omanpost
	0x006d0cc7, // n0x1392 c0x0001 (---------------)  ! I omantel
	0x0073f54c, // n0x1393 c0x0001 (---------------)  ! I rakpetroleum
	0x0066c647, // n0x1394 c0x0001 (---------------)  ! I siemens
	0x00653a08, // n0x1395 c0x0001 (---------------)  ! I songfest
	0x006b5dcc, // n0x1396 c0x0001 (---------------)  ! I statecouncil
	0x000138c2, // n0x1397 c0x0000 (---------------)  +   ae
	0x00005c07, // n0x1398 c0x0000 (---------------)  +   blogdns
	0x000c87c8, // n0x1399 c0x0000 (---------------)  +   blogsite
	0x0011f352, // n0x139a c0x0000 (---------------)  +   boldlygoingnowhere
	0x000357c8, // n0x139b c0x0000 (---------------)  +   dnsalias
	0x00062ac7, // n0x139c c0x0000 (---------------)  +   dnsdojo
	0x000a33cb, // n0x139d c0x0000 (---------------)  +   doesntexist
	0x00106f09, // n0x139e c0x0000 (---------------)  +   dontexist
	0x000356c7, // n0x139f c0x0000 (---------------)  +   doomdns
	0x00062a06, // n0x13a0 c0x0000 (---------------)  +   dvrdns
	0x0000e508, // n0x13a1 c0x0000 (---------------)  +   dynalias
	0x3cc04a46, // n0x13a2 c0x00f3 (n0x13cc-n0x13ce)  +   dyndns
	0x00092c4d, // n0x13a3 c0x0000 (---------------)  +   endofinternet
	0x0002a490, // n0x13a4 c0x0000 (---------------)  +   endoftheinternet
	0x0005a747, // n0x13a5 c0x0000 (---------------)  +   from-me
	0x0007bcc9, // n0x13a6 c0x0000 (---------------)  +   game-host
	0x00049846, // n0x13a7 c0x0000 (---------------)  +   gotdns
	0x0003ef4a, // n0x13a8 c0x0000 (---------------)  +   hobby-site
	0x00071247, // n0x13a9 c0x0000 (---------------)  +   homedns
	0x0000ee47, // n0x13aa c0x0000 (---------------)  +   homeftp
	0x0008fcc9, // n0x13ab c0x0000 (---------------)  +   homelinux
	0x00090148, // n0x13ac c0x0000 (---------------)  +   homeunix
	0x0003198e, // n0x13ad c0x0000 (---------------)  +   is-a-bruinsfan
	0x0002304e, // n0x13ae c0x0000 (---------------)  +   is-a-candidate
	0x0005428f, // n0x13af c0x0000 (---------------)  +   is-a-celticsfan
	0x00054949, // n0x13b0 c0x0000 (---------------)  +   is-a-chef
	0x0005c709, // n0x13b1 c0x0000 (---------------)  +   is-a-geek
	0x0006cecb, // n0x13b2 c0x0000 (---------------)  +   is-a-knight
	0x0008868f, // n0x13b3 c0x0000 (---------------)  +   is-a-linux-user
	0x0011c70c, // n0x13b4 c0x0000 (---------------)  +   is-a-patsfan
	0x000a5d8b, // n0x13b5 c0x0000 (---------------)  +   is-a-soxfan
	0x00142488, // n0x13b6 c0x0000 (---------------)  +   is-found
	0x000ddf47, // n0x13b7 c0x0000 (---------------)  +   is-lost
	0x000e76c8, // n0x13b8 c0x0000 (---------------)  +   is-saved
	0x001019cb, // n0x13b9 c0x0000 (---------------)  +   is-very-bad
	0x00107acc, // n0x13ba c0x0000 (---------------)  +   is-very-evil
	0x0010fdcc, // n0x13bb c0x0000 (---------------)  +   is-very-good
	0x0011038c, // n0x13bc c0x0000 (---------------)  +   is-very-nice
	0x0011be8d, // n0x13bd c0x0000 (---------------)  +   is-very-sweet
	0x0008e588, // n0x13be c0x0000 (---------------)  +   isa-geek
	0x00026bc9, // n0x13bf c0x0000 (---------------)  +   kicks-ass
	0x001295cb, // n0x13c0 c0x0000 (---------------)  +   misconfused
	0x000ce747, // n0x13c1 c0x0000 (---------------)  +   podzone
	0x000c864a, // n0x13c2 c0x0000 (---------------)  +   readmyblog
	0x00109ac6, // n0x13c3 c0x0000 (---------------)  +   selfip
	0x0012b04d, // n0x13c4 c0x0000 (---------------)  +   sellsyourhome
	0x000edb88, // n0x13c5 c0x0000 (---------------)  +   servebbs
	0x000f2688, // n0x13c6 c0x0000 (---------------)  +   serveftp
	0x000f8789, // n0x13c7 c0x0000 (---------------)  +   servegame
	0x000ea3cc, // n0x13c8 c0x0000 (---------------)  +   stuff-4-sale
	0x00001f42, // n0x13c9 c0x0000 (---------------)  +   us
	0x000141c6, // n0x13ca c0x0000 (---------------)  +   webhop
	0x00001142, // n0x13cb c0x0000 (---------------)  +   za
	0x00000482, // n0x13cc c0x0000 (---------------)  +   go
	0x0000ee44, // n0x13cd c0x0000 (---------------)  +   home
	0x00203383, // n0x13ce c0x0000 (---------------)  + I abo
	0x00206c42, // n0x13cf c0x0000 (---------------)  + I ac
	0x0020d643, // n0x13d0 c0x0000 (---------------)  + I com
	0x002df843, // n0x13d1 c0x0000 (---------------)  + I edu
	0x00265483, // n0x13d2 c0x0000 (---------------)  + I gob
	0x002027c3, // n0x13d3 c0x0000 (---------------)  + I ing
	0x0023dbc3, // n0x13d4 c0x0000 (---------------)  + I med
	0x00214843, // n0x13d5 c0x0000 (---------------)  + I net
	0x00216583, // n0x13d6 c0x0000 (---------------)  + I nom
	0x0023e983, // n0x13d7 c0x0000 (---------------)  + I org
	0x002e1643, // n0x13d8 c0x0000 (---------------)  + I sld
	0x0020d643, // n0x13d9 c0x0000 (---------------)  + I com
	0x002df843, // n0x13da c0x0000 (---------------)  + I edu
	0x00265483, // n0x13db c0x0000 (---------------)  + I gob
	0x0022f003, // n0x13dc c0x0000 (---------------)  + I mil
	0x00214843, // n0x13dd c0x0000 (---------------)  + I net
	0x00216583, // n0x13de c0x0000 (---------------)  + I nom
	0x0023e983, // n0x13df c0x0000 (---------------)  + I org
	0x0020d643, // n0x13e0 c0x0000 (---------------)  + I com
	0x002df843, // n0x13e1 c0x0000 (---------------)  + I edu
	0x0023e983, // n0x13e2 c0x0000 (---------------)  + I org
	0x0020d643, // n0x13e3 c0x0000 (---------------)  + I com
	0x002df843, // n0x13e4 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x13e5 c0x0000 (---------------)  + I gov
	0x00200781, // n0x13e6 c0x0000 (---------------)  + I i
	0x0022f003, // n0x13e7 c0x0000 (---------------)  + I mil
	0x00214843, // n0x13e8 c0x0000 (---------------)  + I net
	0x00200443, // n0x13e9 c0x0000 (---------------)  + I ngo
	0x0023e983, // n0x13ea c0x0000 (---------------)  + I org
	0x0030c243, // n0x13eb c0x0000 (---------------)  + I biz
	0x0020d643, // n0x13ec c0x0000 (---------------)  + I com
	0x002df843, // n0x13ed c0x0000 (---------------)  + I edu
	0x002724c3, // n0x13ee c0x0000 (---------------)  + I fam
	0x00265483, // n0x13ef c0x0000 (---------------)  + I gob
	0x002cd6c3, // n0x13f0 c0x0000 (---------------)  + I gok
	0x00260ac3, // n0x13f1 c0x0000 (---------------)  + I gon
	0x0020cf83, // n0x13f2 c0x0000 (---------------)  + I gop
	0x0021fc83, // n0x13f3 c0x0000 (---------------)  + I gos
	0x00218d43, // n0x13f4 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x13f5 c0x0000 (---------------)  + I info
	0x00214843, // n0x13f6 c0x0000 (---------------)  + I net
	0x0023e983, // n0x13f7 c0x0000 (---------------)  + I org
	0x00205e43, // n0x13f8 c0x0000 (---------------)  + I web
	0x0022ec45, // n0x13f9 c0x0000 (---------------)  + I 6bone
	0x002292c4, // n0x13fa c0x0000 (---------------)  + I agro
	0x00250443, // n0x13fb c0x0000 (---------------)  + I aid
	0x0020e343, // n0x13fc c0x0000 (---------------)  + I art
	0x00285403, // n0x13fd c0x0000 (---------------)  + I atm
	0x002c0b48, // n0x13fe c0x0000 (---------------)  + I augustow
	0x002bb8c4, // n0x13ff c0x0000 (---------------)  + I auto
	0x002512ca, // n0x1400 c0x0000 (---------------)  + I babia-gora
	0x00283b06, // n0x1401 c0x0000 (---------------)  + I bedzin
	0x00202187, // n0x1402 c0x0000 (---------------)  + I beskidy
	0x0021ce0a, // n0x1403 c0x0000 (---------------)  + I bialowieza
	0x00298ac9, // n0x1404 c0x0000 (---------------)  + I bialystok
	0x00205747, // n0x1405 c0x0000 (---------------)  + I bielawa
	0x0020690a, // n0x1406 c0x0000 (---------------)  + I bieszczady
	0x0030c243, // n0x1407 c0x0000 (---------------)  + I biz
	0x00345a8b, // n0x1408 c0x0000 (---------------)  + I boleslawiec
	0x002c9709, // n0x1409 c0x0000 (---------------)  + I bydgoszcz
	0x0025e445, // n0x140a c0x0000 (---------------)  + I bytom
	0x002c2347, // n0x140b c0x0000 (---------------)  + I cieszyn
	0x0000d642, // n0x140c c0x0000 (---------------)  +   co
	0x0020d643, // n0x140d c0x0000 (---------------)  + I com
	0x002ae147, // n0x140e c0x0000 (---------------)  + I czeladz
	0x00221a45, // n0x140f c0x0000 (---------------)  + I czest
	0x002e5c49, // n0x1410 c0x0000 (---------------)  + I dlugoleka
	0x002df843, // n0x1411 c0x0000 (---------------)  + I edu
	0x00222706, // n0x1412 c0x0000 (---------------)  + I elblag
	0x002e6843, // n0x1413 c0x0000 (---------------)  + I elk
	0x002e0b43, // n0x1414 c0x0000 (---------------)  + I gda
	0x002f3286, // n0x1415 c0x0000 (---------------)  + I gdansk
	0x00227e46, // n0x1416 c0x0000 (---------------)  + I gdynia
	0x00224087, // n0x1417 c0x0000 (---------------)  + I gliwice
	0x0022bcc6, // n0x1418 c0x0000 (---------------)  + I glogow
	0x00238a05, // n0x1419 c0x0000 (---------------)  + I gmina
	0x00229fc7, // n0x141a c0x0000 (---------------)  + I gniezno
	0x002f8f07, // n0x141b c0x0000 (---------------)  + I gorlice
	0x3ea18d43, // n0x141c c0x00fa (n0x14a4-n0x14ad)  + I gov
	0x002f7bc7, // n0x141d c0x0000 (---------------)  + I grajewo
	0x00250083, // n0x141e c0x0000 (---------------)  + I gsm
	0x00229705, // n0x141f c0x0000 (---------------)  + I ilawa
	0x00210e04, // n0x1420 c0x0000 (---------------)  + I info
	0x0026e543, // n0x1421 c0x0000 (---------------)  + I irc
	0x00313a48, // n0x1422 c0x0000 (---------------)  + I jaworzno
	0x0022c04c, // n0x1423 c0x0000 (---------------)  + I jelenia-gora
	0x00297a05, // n0x1424 c0x0000 (---------------)  + I jgora
	0x002a4586, // n0x1425 c0x0000 (---------------)  + I kalisz
	0x002ae007, // n0x1426 c0x0000 (---------------)  + I karpacz
	0x00240247, // n0x1427 c0x0000 (---------------)  + I kartuzy
	0x0025e307, // n0x1428 c0x0000 (---------------)  + I kaszuby
	0x002aa148, // n0x1429 c0x0000 (---------------)  + I katowice
	0x0033668f, // n0x142a c0x0000 (---------------)  + I kazimierz-dolny
	0x00237145, // n0x142b c0x0000 (---------------)  + I kepno
	0x003046c7, // n0x142c c0x0000 (---------------)  + I ketrzyn
	0x002e4787, // n0x142d c0x0000 (---------------)  + I klodzko
	0x0028fa4a, // n0x142e c0x0000 (---------------)  + I kobierzyce
	0x002a9389, // n0x142f c0x0000 (---------------)  + I kolobrzeg
	0x002f33c5, // n0x1430 c0x0000 (---------------)  + I konin
	0x002f450a, // n0x1431 c0x0000 (---------------)  + I konskowola
	0x002a03c6, // n0x1432 c0x0000 (---------------)  + I krakow
	0x002aa7c5, // n0x1433 c0x0000 (---------------)  + I kutno
	0x002b8b84, // n0x1434 c0x0000 (---------------)  + I lapy
	0x0023f286, // n0x1435 c0x0000 (---------------)  + I lebork
	0x0023e607, // n0x1436 c0x0000 (---------------)  + I legnica
	0x00228107, // n0x1437 c0x0000 (---------------)  + I lezajsk
	0x00226088, // n0x1438 c0x0000 (---------------)  + I limanowa
	0x002fa405, // n0x1439 c0x0000 (---------------)  + I lomza
	0x00221946, // n0x143a c0x0000 (---------------)  + I lowicz
	0x00262385, // n0x143b c0x0000 (---------------)  + I lubin
	0x002c0505, // n0x143c c0x0000 (---------------)  + I lukow
	0x00212a04, // n0x143d c0x0000 (---------------)  + I mail
	0x00223ac7, // n0x143e c0x0000 (---------------)  + I malbork
	0x0030b7ca, // n0x143f c0x0000 (---------------)  + I malopolska
	0x0021b988, // n0x1440 c0x0000 (---------------)  + I mazowsze
	0x002e5846, // n0x1441 c0x0000 (---------------)  + I mazury
	0x0022b805, // n0x1442 c0x0000 (---------------)  + I mbone
	0x0023dbc3, // n0x1443 c0x0000 (---------------)  + I med
	0x0023dbc5, // n0x1444 c0x0000 (---------------)  + I media
	0x002d4b06, // n0x1445 c0x0000 (---------------)  + I miasta
	0x00206706, // n0x1446 c0x0000 (---------------)  + I mielec
	0x00341546, // n0x1447 c0x0000 (---------------)  + I mielno
	0x0022f003, // n0x1448 c0x0000 (---------------)  + I mil
	0x00331987, // n0x1449 c0x0000 (---------------)  + I mragowo
	0x002e4705, // n0x144a c0x0000 (---------------)  + I naklo
	0x00214843, // n0x144b c0x0000 (---------------)  + I net
	0x00200443, // n0x144c c0x0000 (---------------)  + I ngo
	0x0020874d, // n0x144d c0x0000 (---------------)  + I nieruchomosci
	0x00216583, // n0x144e c0x0000 (---------------)  + I nom
	0x00226188, // n0x144f c0x0000 (---------------)  + I nowaruda
	0x002cd904, // n0x1450 c0x0000 (---------------)  + I nysa
	0x0026b105, // n0x1451 c0x0000 (---------------)  + I olawa
	0x0028f946, // n0x1452 c0x0000 (---------------)  + I olecko
	0x002bab06, // n0x1453 c0x0000 (---------------)  + I olkusz
	0x0020d887, // n0x1454 c0x0000 (---------------)  + I olsztyn
	0x002142c7, // n0x1455 c0x0000 (---------------)  + I opoczno
	0x00300545, // n0x1456 c0x0000 (---------------)  + I opole
	0x0023e983, // n0x1457 c0x0000 (---------------)  + I org
	0x00224707, // n0x1458 c0x0000 (---------------)  + I ostroda
	0x002619c9, // n0x1459 c0x0000 (---------------)  + I ostroleka
	0x00303a49, // n0x145a c0x0000 (---------------)  + I ostrowiec
	0x0030de0a, // n0x145b c0x0000 (---------------)  + I ostrowwlkp
	0x002dca02, // n0x145c c0x0000 (---------------)  + I pc
	0x002296c4, // n0x145d c0x0000 (---------------)  + I pila
	0x002cb584, // n0x145e c0x0000 (---------------)  + I pisz
	0x002ce007, // n0x145f c0x0000 (---------------)  + I podhale
	0x002ce448, // n0x1460 c0x0000 (---------------)  + I podlasie
	0x0033fb89, // n0x1461 c0x0000 (---------------)  + I polkowice
	0x00233b09, // n0x1462 c0x0000 (---------------)  + I pomorskie
	0x002cef47, // n0x1463 c0x0000 (---------------)  + I pomorze
	0x00204f86, // n0x1464 c0x0000 (---------------)  + I powiat
	0x002cfd06, // n0x1465 c0x0000 (---------------)  + I poznan
	0x002d1204, // n0x1466 c0x0000 (---------------)  + I priv
	0x002d138a, // n0x1467 c0x0000 (---------------)  + I prochowice
	0x002d2188, // n0x1468 c0x0000 (---------------)  + I pruszkow
	0x002d2389, // n0x1469 c0x0000 (---------------)  + I przeworsk
	0x0028ea46, // n0x146a c0x0000 (---------------)  + I pulawy
	0x0029c305, // n0x146b c0x0000 (---------------)  + I radom
	0x0021b848, // n0x146c c0x0000 (---------------)  + I rawa-maz
	0x002b5c8a, // n0x146d c0x0000 (---------------)  + I realestate
	0x00259c43, // n0x146e c0x0000 (---------------)  + I rel
	0x00252786, // n0x146f c0x0000 (---------------)  + I rybnik
	0x002cf047, // n0x1470 c0x0000 (---------------)  + I rzeszow
	0x003480c5, // n0x1471 c0x0000 (---------------)  + I sanok
	0x002cd7c5, // n0x1472 c0x0000 (---------------)  + I sejny
	0x003461c3, // n0x1473 c0x0000 (---------------)  + I sex
	0x003040c4, // n0x1474 c0x0000 (---------------)  + I shop
	0x002ce587, // n0x1475 c0x0000 (---------------)  + I siedlce
	0x00223f05, // n0x1476 c0x0000 (---------------)  + I sklep
	0x00270b07, // n0x1477 c0x0000 (---------------)  + I skoczow
	0x00267785, // n0x1478 c0x0000 (---------------)  + I slask
	0x002e17c6, // n0x1479 c0x0000 (---------------)  + I slupsk
	0x002e2705, // n0x147a c0x0000 (---------------)  + I sopot
	0x0028a083, // n0x147b c0x0000 (---------------)  + I sos
	0x0028a089, // n0x147c c0x0000 (---------------)  + I sosnowiec
	0x0026aecc, // n0x147d c0x0000 (---------------)  + I stalowa-wola
	0x0029f40c, // n0x147e c0x0000 (---------------)  + I starachowice
	0x00267e08, // n0x147f c0x0000 (---------------)  + I stargard
	0x002d6ec7, // n0x1480 c0x0000 (---------------)  + I suwalki
	0x002ec608, // n0x1481 c0x0000 (---------------)  + I swidnica
	0x002ec94a, // n0x1482 c0x0000 (---------------)  + I swiebodzin
	0x002ecd0b, // n0x1483 c0x0000 (---------------)  + I swinoujscie
	0x002c9848, // n0x1484 c0x0000 (---------------)  + I szczecin
	0x002a4688, // n0x1485 c0x0000 (---------------)  + I szczytno
	0x00224f06, // n0x1486 c0x0000 (---------------)  + I szkola
	0x002050c5, // n0x1487 c0x0000 (---------------)  + I targi
	0x0021194a, // n0x1488 c0x0000 (---------------)  + I tarnobrzeg
	0x00234245, // n0x1489 c0x0000 (---------------)  + I tgory
	0x0023a842, // n0x148a c0x0000 (---------------)  + I tm
	0x002b2c47, // n0x148b c0x0000 (---------------)  + I tourism
	0x002ddac6, // n0x148c c0x0000 (---------------)  + I travel
	0x0020b805, // n0x148d c0x0000 (---------------)  + I turek
	0x002e5589, // n0x148e c0x0000 (---------------)  + I turystyka
	0x002cda85, // n0x148f c0x0000 (---------------)  + I tychy
	0x0027d586, // n0x1490 c0x0000 (---------------)  + I usenet
	0x0029b445, // n0x1491 c0x0000 (---------------)  + I ustka
	0x0024d949, // n0x1492 c0x0000 (---------------)  + I walbrzych
	0x0022e186, // n0x1493 c0x0000 (---------------)  + I warmia
	0x002bfa48, // n0x1494 c0x0000 (---------------)  + I warszawa
	0x0028a603, // n0x1495 c0x0000 (---------------)  + I waw
	0x00231086, // n0x1496 c0x0000 (---------------)  + I wegrow
	0x00267286, // n0x1497 c0x0000 (---------------)  + I wielun
	0x002c0605, // n0x1498 c0x0000 (---------------)  + I wlocl
	0x002c0609, // n0x1499 c0x0000 (---------------)  + I wloclawek
	0x00268a89, // n0x149a c0x0000 (---------------)  + I wodzislaw
	0x002f7d07, // n0x149b c0x0000 (---------------)  + I wolomin
	0x002404c4, // n0x149c c0x0000 (---------------)  + I wroc
	0x002404c7, // n0x149d c0x0000 (---------------)  + I wroclaw
	0x00233a09, // n0x149e c0x0000 (---------------)  + I zachpomor
	0x0021d005, // n0x149f c0x0000 (---------------)  + I zagan
	0x0023d308, // n0x14a0 c0x0000 (---------------)  + I zakopane
	0x00201145, // n0x14a1 c0x0000 (---------------)  + I zarow
	0x002ae2c5, // n0x14a2 c0x0000 (---------------)  + I zgora
	0x00214909, // n0x14a3 c0x0000 (---------------)  + I zgorzelec
	0x0020d002, // n0x14a4 c0x0000 (---------------)  + I pa
	0x00200a42, // n0x14a5 c0x0000 (---------------)  + I po
	0x00200882, // n0x14a6 c0x0000 (---------------)  + I so
	0x002ba542, // n0x14a7 c0x0000 (---------------)  + I sr
	0x002688c9, // n0x14a8 c0x0000 (---------------)  + I starostwo
	0x00202b82, // n0x14a9 c0x0000 (---------------)  + I ug
	0x00209342, // n0x14aa c0x0000 (---------------)  + I um
	0x00204f44, // n0x14ab c0x0000 (---------------)  + I upow
	0x0023ed02, // n0x14ac c0x0000 (---------------)  + I uw
	0x0020d642, // n0x14ad c0x0000 (---------------)  + I co
	0x002df843, // n0x14ae c0x0000 (---------------)  + I edu
	0x00218d43, // n0x14af c0x0000 (---------------)  + I gov
	0x00214843, // n0x14b0 c0x0000 (---------------)  + I net
	0x0023e983, // n0x14b1 c0x0000 (---------------)  + I org
	0x00206c42, // n0x14b2 c0x0000 (---------------)  + I ac
	0x0030c243, // n0x14b3 c0x0000 (---------------)  + I biz
	0x0020d643, // n0x14b4 c0x0000 (---------------)  + I com
	0x002df843, // n0x14b5 c0x0000 (---------------)  + I edu
	0x00202043, // n0x14b6 c0x0000 (---------------)  + I est
	0x00218d43, // n0x14b7 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x14b8 c0x0000 (---------------)  + I info
	0x00268b84, // n0x14b9 c0x0000 (---------------)  + I isla
	0x00202f04, // n0x14ba c0x0000 (---------------)  + I name
	0x00214843, // n0x14bb c0x0000 (---------------)  + I net
	0x0023e983, // n0x14bc c0x0000 (---------------)  + I org
	0x002d1383, // n0x14bd c0x0000 (---------------)  + I pro
	0x002d1884, // n0x14be c0x0000 (---------------)  + I prof
	0x00290503, // n0x14bf c0x0000 (---------------)  + I aca
	0x00218003, // n0x14c0 c0x0000 (---------------)  + I bar
	0x002860c3, // n0x14c1 c0x0000 (---------------)  + I cpa
	0x00204883, // n0x14c2 c0x0000 (---------------)  + I eng
	0x00279843, // n0x14c3 c0x0000 (---------------)  + I jur
	0x00205803, // n0x14c4 c0x0000 (---------------)  + I law
	0x0023dbc3, // n0x14c5 c0x0000 (---------------)  + I med
	0x0020d643, // n0x14c6 c0x0000 (---------------)  + I com
	0x002df843, // n0x14c7 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x14c8 c0x0000 (---------------)  + I gov
	0x00214843, // n0x14c9 c0x0000 (---------------)  + I net
	0x0023e983, // n0x14ca c0x0000 (---------------)  + I org
	0x002cdd83, // n0x14cb c0x0000 (---------------)  + I plo
	0x002f1383, // n0x14cc c0x0000 (---------------)  + I sec
	0x0003c708, // n0x14cd c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x14ce c0x0000 (---------------)  + I com
	0x002df843, // n0x14cf c0x0000 (---------------)  + I edu
	0x00218d43, // n0x14d0 c0x0000 (---------------)  + I gov
	0x00217543, // n0x14d1 c0x0000 (---------------)  + I int
	0x00214843, // n0x14d2 c0x0000 (---------------)  + I net
	0x0025af84, // n0x14d3 c0x0000 (---------------)  + I nome
	0x0023e983, // n0x14d4 c0x0000 (---------------)  + I org
	0x0029ebc4, // n0x14d5 c0x0000 (---------------)  + I publ
	0x002c0a85, // n0x14d6 c0x0000 (---------------)  + I belau
	0x0020d642, // n0x14d7 c0x0000 (---------------)  + I co
	0x00207902, // n0x14d8 c0x0000 (---------------)  + I ed
	0x00200482, // n0x14d9 c0x0000 (---------------)  + I go
	0x00203e82, // n0x14da c0x0000 (---------------)  + I ne
	0x00200a82, // n0x14db c0x0000 (---------------)  + I or
	0x0020d643, // n0x14dc c0x0000 (---------------)  + I com
	0x0023ae84, // n0x14dd c0x0000 (---------------)  + I coop
	0x002df843, // n0x14de c0x0000 (---------------)  + I edu
	0x00218d43, // n0x14df c0x0000 (---------------)  + I gov
	0x0022f003, // n0x14e0 c0x0000 (---------------)  + I mil
	0x00214843, // n0x14e1 c0x0000 (---------------)  + I net
	0x0023e983, // n0x14e2 c0x0000 (---------------)  + I org
	0x0020d643, // n0x14e3 c0x0000 (---------------)  + I com
	0x002df843, // n0x14e4 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x14e5 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x14e6 c0x0000 (---------------)  + I mil
	0x00202f04, // n0x14e7 c0x0000 (---------------)  + I name
	0x00214843, // n0x14e8 c0x0000 (---------------)  + I net
	0x0023e983, // n0x14e9 c0x0000 (---------------)  + I org
	0x00201d83, // n0x14ea c0x0000 (---------------)  + I sch
	0x002072c4, // n0x14eb c0x0000 (---------------)  + I asso
	0x0003c708, // n0x14ec c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x14ed c0x0000 (---------------)  + I com
	0x00216583, // n0x14ee c0x0000 (---------------)  + I nom
	0x00230884, // n0x14ef c0x0000 (---------------)  + I arts
	0x0003c708, // n0x14f0 c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x14f1 c0x0000 (---------------)  + I com
	0x00243504, // n0x14f2 c0x0000 (---------------)  + I firm
	0x00210e04, // n0x14f3 c0x0000 (---------------)  + I info
	0x00216583, // n0x14f4 c0x0000 (---------------)  + I nom
	0x00200242, // n0x14f5 c0x0000 (---------------)  + I nt
	0x0023e983, // n0x14f6 c0x0000 (---------------)  + I org
	0x002c1d83, // n0x14f7 c0x0000 (---------------)  + I rec
	0x002e9c05, // n0x14f8 c0x0000 (---------------)  + I store
	0x0023a842, // n0x14f9 c0x0000 (---------------)  + I tm
	0x00240643, // n0x14fa c0x0000 (---------------)  + I www
	0x00206c42, // n0x14fb c0x0000 (---------------)  + I ac
	0x0020d642, // n0x14fc c0x0000 (---------------)  + I co
	0x002df843, // n0x14fd c0x0000 (---------------)  + I edu
	0x00218d43, // n0x14fe c0x0000 (---------------)  + I gov
	0x002027c2, // n0x14ff c0x0000 (---------------)  + I in
	0x0023e983, // n0x1500 c0x0000 (---------------)  + I org
	0x00206c42, // n0x1501 c0x0000 (---------------)  + I ac
	0x00206ac7, // n0x1502 c0x0000 (---------------)  + I adygeya
	0x002eb045, // n0x1503 c0x0000 (---------------)  + I altai
	0x00276304, // n0x1504 c0x0000 (---------------)  + I amur
	0x002c1906, // n0x1505 c0x0000 (---------------)  + I amursk
	0x0022660b, // n0x1506 c0x0000 (---------------)  + I arkhangelsk
	0x0024b489, // n0x1507 c0x0000 (---------------)  + I astrakhan
	0x002a44c6, // n0x1508 c0x0000 (---------------)  + I baikal
	0x0033c149, // n0x1509 c0x0000 (---------------)  + I bashkiria
	0x002a6e08, // n0x150a c0x0000 (---------------)  + I belgorod
	0x0020e243, // n0x150b c0x0000 (---------------)  + I bir
	0x00223dc7, // n0x150c c0x0000 (---------------)  + I bryansk
	0x00258948, // n0x150d c0x0000 (---------------)  + I buryatia
	0x0033aa43, // n0x150e c0x0000 (---------------)  + I cbg
	0x0023f584, // n0x150f c0x0000 (---------------)  + I chel
	0x0025354b, // n0x1510 c0x0000 (---------------)  + I chelyabinsk
	0x0028a285, // n0x1511 c0x0000 (---------------)  + I chita
	0x0033dd08, // n0x1512 c0x0000 (---------------)  + I chukotka
	0x0031d709, // n0x1513 c0x0000 (---------------)  + I chuvashia
	0x00231003, // n0x1514 c0x0000 (---------------)  + I cmw
	0x0020d643, // n0x1515 c0x0000 (---------------)  + I com
	0x002c0d88, // n0x1516 c0x0000 (---------------)  + I dagestan
	0x0024d687, // n0x1517 c0x0000 (---------------)  + I dudinka
	0x0022b906, // n0x1518 c0x0000 (---------------)  + I e-burg
	0x002df843, // n0x1519 c0x0000 (---------------)  + I edu
	0x00316407, // n0x151a c0x0000 (---------------)  + I fareast
	0x00218d43, // n0x151b c0x0000 (---------------)  + I gov
	0x0024ef06, // n0x151c c0x0000 (---------------)  + I grozny
	0x00217543, // n0x151d c0x0000 (---------------)  + I int
	0x00278847, // n0x151e c0x0000 (---------------)  + I irkutsk
	0x00264987, // n0x151f c0x0000 (---------------)  + I ivanovo
	0x002c40c7, // n0x1520 c0x0000 (---------------)  + I izhevsk
	0x00223a45, // n0x1521 c0x0000 (---------------)  + I jamal
	0x00210103, // n0x1522 c0x0000 (---------------)  + I jar
	0x002a54cb, // n0x1523 c0x0000 (---------------)  + I joshkar-ola
	0x00231508, // n0x1524 c0x0000 (---------------)  + I k-uralsk
	0x002af448, // n0x1525 c0x0000 (---------------)  + I kalmykia
	0x002e5e06, // n0x1526 c0x0000 (---------------)  + I kaluga
	0x002d8909, // n0x1527 c0x0000 (---------------)  + I kamchatka
	0x002b10c7, // n0x1528 c0x0000 (---------------)  + I karelia
	0x002f16c5, // n0x1529 c0x0000 (---------------)  + I kazan
	0x00248604, // n0x152a c0x0000 (---------------)  + I kchr
	0x002150c8, // n0x152b c0x0000 (---------------)  + I kemerovo
	0x0025ffca, // n0x152c c0x0000 (---------------)  + I khabarovsk
	0x00260209, // n0x152d c0x0000 (---------------)  + I khakassia
	0x00297803, // n0x152e c0x0000 (---------------)  + I khv
	0x0026d945, // n0x152f c0x0000 (---------------)  + I kirov
	0x002a07c3, // n0x1530 c0x0000 (---------------)  + I kms
	0x002dc586, // n0x1531 c0x0000 (---------------)  + I koenig
	0x002c28c4, // n0x1532 c0x0000 (---------------)  + I komi
	0x0029bc88, // n0x1533 c0x0000 (---------------)  + I kostroma
	0x002a054b, // n0x1534 c0x0000 (---------------)  + I krasnoyarsk
	0x00274545, // n0x1535 c0x0000 (---------------)  + I kuban
	0x002a6b86, // n0x1536 c0x0000 (---------------)  + I kurgan
	0x002a9285, // n0x1537 c0x0000 (---------------)  + I kursk
	0x002a9a08, // n0x1538 c0x0000 (---------------)  + I kustanai
	0x002aa907, // n0x1539 c0x0000 (---------------)  + I kuzbass
	0x00346ec7, // n0x153a c0x0000 (---------------)  + I lipetsk
	0x00341c87, // n0x153b c0x0000 (---------------)  + I magadan
	0x00236188, // n0x153c c0x0000 (---------------)  + I magnitka
	0x0021c304, // n0x153d c0x0000 (---------------)  + I mari
	0x0021c307, // n0x153e c0x0000 (---------------)  + I mari-el
	0x00323986, // n0x153f c0x0000 (---------------)  + I marine
	0x0022f003, // n0x1540 c0x0000 (---------------)  + I mil
	0x002b7408, // n0x1541 c0x0000 (---------------)  + I mordovia
	0x002ba4c6, // n0x1542 c0x0000 (---------------)  + I mosreg
	0x00276f83, // n0x1543 c0x0000 (---------------)  + I msk
	0x002c2708, // n0x1544 c0x0000 (---------------)  + I murmansk
	0x002c5285, // n0x1545 c0x0000 (---------------)  + I mytis
	0x002e22c8, // n0x1546 c0x0000 (---------------)  + I nakhodka
	0x002ef7c7, // n0x1547 c0x0000 (---------------)  + I nalchik
	0x00214843, // n0x1548 c0x0000 (---------------)  + I net
	0x00324103, // n0x1549 c0x0000 (---------------)  + I nkz
	0x00278084, // n0x154a c0x0000 (---------------)  + I nnov
	0x002ade87, // n0x154b c0x0000 (---------------)  + I norilsk
	0x00216003, // n0x154c c0x0000 (---------------)  + I nov
	0x00264a4b, // n0x154d c0x0000 (---------------)  + I novosibirsk
	0x00216b43, // n0x154e c0x0000 (---------------)  + I nsk
	0x00276f44, // n0x154f c0x0000 (---------------)  + I omsk
	0x002e9c88, // n0x1550 c0x0000 (---------------)  + I orenburg
	0x0023e983, // n0x1551 c0x0000 (---------------)  + I org
	0x00298385, // n0x1552 c0x0000 (---------------)  + I oryol
	0x0023e505, // n0x1553 c0x0000 (---------------)  + I oskol
	0x0020d006, // n0x1554 c0x0000 (---------------)  + I palana
	0x00264f85, // n0x1555 c0x0000 (---------------)  + I penza
	0x002c5644, // n0x1556 c0x0000 (---------------)  + I perm
	0x00203f02, // n0x1557 c0x0000 (---------------)  + I pp
	0x002e1885, // n0x1558 c0x0000 (---------------)  + I pskov
	0x002d2bc3, // n0x1559 c0x0000 (---------------)  + I ptz
	0x002b8c0a, // n0x155a c0x0000 (---------------)  + I pyatigorsk
	0x002186c3, // n0x155b c0x0000 (---------------)  + I rnd
	0x00289849, // n0x155c c0x0000 (---------------)  + I rubtsovsk
	0x0021c006, // n0x155d c0x0000 (---------------)  + I ryazan
	0x00336448, // n0x155e c0x0000 (---------------)  + I sakhalin
	0x00279fc6, // n0x155f c0x0000 (---------------)  + I samara
	0x002820c7, // n0x1560 c0x0000 (---------------)  + I saratov
	0x002e0c48, // n0x1561 c0x0000 (---------------)  + I simbirsk
	0x00216a08, // n0x1562 c0x0000 (---------------)  + I smolensk
	0x002e1b83, // n0x1563 c0x0000 (---------------)  + I snz
	0x002e59c3, // n0x1564 c0x0000 (---------------)  + I spb
	0x0033fa09, // n0x1565 c0x0000 (---------------)  + I stavropol
	0x002ee683, // n0x1566 c0x0000 (---------------)  + I stv
	0x002b3a86, // n0x1567 c0x0000 (---------------)  + I surgut
	0x00319b86, // n0x1568 c0x0000 (---------------)  + I syzran
	0x00346506, // n0x1569 c0x0000 (---------------)  + I tambov
	0x0021d3c9, // n0x156a c0x0000 (---------------)  + I tatarstan
	0x0023c544, // n0x156b c0x0000 (---------------)  + I test
	0x0024f543, // n0x156c c0x0000 (---------------)  + I tom
	0x002b3cc5, // n0x156d c0x0000 (---------------)  + I tomsk
	0x00230909, // n0x156e c0x0000 (---------------)  + I tsaritsyn
	0x00234d83, // n0x156f c0x0000 (---------------)  + I tsk
	0x002e2804, // n0x1570 c0x0000 (---------------)  + I tula
	0x002eaa44, // n0x1571 c0x0000 (---------------)  + I tuva
	0x002eac44, // n0x1572 c0x0000 (---------------)  + I tver
	0x00209d86, // n0x1573 c0x0000 (---------------)  + I tyumen
	0x0022b103, // n0x1574 c0x0000 (---------------)  + I udm
	0x0022b108, // n0x1575 c0x0000 (---------------)  + I udmurtia
	0x0024b0c8, // n0x1576 c0x0000 (---------------)  + I ulan-ude
	0x0025fe86, // n0x1577 c0x0000 (---------------)  + I vdonsk
	0x002f14cb, // n0x1578 c0x0000 (---------------)  + I vladikavkaz
	0x002f1808, // n0x1579 c0x0000 (---------------)  + I vladimir
	0x002f1e8b, // n0x157a c0x0000 (---------------)  + I vladivostok
	0x002f2a89, // n0x157b c0x0000 (---------------)  + I volgograd
	0x002f3187, // n0x157c c0x0000 (---------------)  + I vologda
	0x002f3b48, // n0x157d c0x0000 (---------------)  + I voronezh
	0x002f4183, // n0x157e c0x0000 (---------------)  + I vrn
	0x002f4246, // n0x157f c0x0000 (---------------)  + I vyatka
	0x0030cc87, // n0x1580 c0x0000 (---------------)  + I yakutia
	0x00281685, // n0x1581 c0x0000 (---------------)  + I yamal
	0x002f6cc9, // n0x1582 c0x0000 (---------------)  + I yaroslavl
	0x00227b4d, // n0x1583 c0x0000 (---------------)  + I yekaterinburg
	0x00336291, // n0x1584 c0x0000 (---------------)  + I yuzhno-sakhalinsk
	0x0022c385, // n0x1585 c0x0000 (---------------)  + I zgrad
	0x00206c42, // n0x1586 c0x0000 (---------------)  + I ac
	0x0020d642, // n0x1587 c0x0000 (---------------)  + I co
	0x0020d643, // n0x1588 c0x0000 (---------------)  + I com
	0x002df843, // n0x1589 c0x0000 (---------------)  + I edu
	0x00257384, // n0x158a c0x0000 (---------------)  + I gouv
	0x00218d43, // n0x158b c0x0000 (---------------)  + I gov
	0x00217543, // n0x158c c0x0000 (---------------)  + I int
	0x0022f003, // n0x158d c0x0000 (---------------)  + I mil
	0x00214843, // n0x158e c0x0000 (---------------)  + I net
	0x0020d643, // n0x158f c0x0000 (---------------)  + I com
	0x002df843, // n0x1590 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x1591 c0x0000 (---------------)  + I gov
	0x0023dbc3, // n0x1592 c0x0000 (---------------)  + I med
	0x00214843, // n0x1593 c0x0000 (---------------)  + I net
	0x0023e983, // n0x1594 c0x0000 (---------------)  + I org
	0x0029b083, // n0x1595 c0x0000 (---------------)  + I pub
	0x00201d83, // n0x1596 c0x0000 (---------------)  + I sch
	0x0020d643, // n0x1597 c0x0000 (---------------)  + I com
	0x002df843, // n0x1598 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x1599 c0x0000 (---------------)  + I gov
	0x00214843, // n0x159a c0x0000 (---------------)  + I net
	0x0023e983, // n0x159b c0x0000 (---------------)  + I org
	0x0020d643, // n0x159c c0x0000 (---------------)  + I com
	0x002df843, // n0x159d c0x0000 (---------------)  + I edu
	0x00218d43, // n0x159e c0x0000 (---------------)  + I gov
	0x00214843, // n0x159f c0x0000 (---------------)  + I net
	0x0023e983, // n0x15a0 c0x0000 (---------------)  + I org
	0x0020d643, // n0x15a1 c0x0000 (---------------)  + I com
	0x002df843, // n0x15a2 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x15a3 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x15a4 c0x0000 (---------------)  + I info
	0x0023dbc3, // n0x15a5 c0x0000 (---------------)  + I med
	0x00214843, // n0x15a6 c0x0000 (---------------)  + I net
	0x0023e983, // n0x15a7 c0x0000 (---------------)  + I org
	0x00281802, // n0x15a8 c0x0000 (---------------)  + I tv
	0x00200181, // n0x15a9 c0x0000 (---------------)  + I a
	0x00206c42, // n0x15aa c0x0000 (---------------)  + I ac
	0x00200001, // n0x15ab c0x0000 (---------------)  + I b
	0x002f4c82, // n0x15ac c0x0000 (---------------)  + I bd
	0x0003c708, // n0x15ad c0x0000 (---------------)  +   blogspot
	0x002192c5, // n0x15ae c0x0000 (---------------)  + I brand
	0x00200501, // n0x15af c0x0000 (---------------)  + I c
	0x00201481, // n0x15b0 c0x0000 (---------------)  + I d
	0x00200041, // n0x15b1 c0x0000 (---------------)  + I e
	0x00201281, // n0x15b2 c0x0000 (---------------)  + I f
	0x0032fbc2, // n0x15b3 c0x0000 (---------------)  + I fh
	0x0032fbc4, // n0x15b4 c0x0000 (---------------)  + I fhsk
	0x00331543, // n0x15b5 c0x0000 (---------------)  + I fhv
	0x00200481, // n0x15b6 c0x0000 (---------------)  + I g
	0x00200741, // n0x15b7 c0x0000 (---------------)  + I h
	0x00200781, // n0x15b8 c0x0000 (---------------)  + I i
	0x00200301, // n0x15b9 c0x0000 (---------------)  + I k
	0x002bae47, // n0x15ba c0x0000 (---------------)  + I komforb
	0x002c424f, // n0x15bb c0x0000 (---------------)  + I kommunalforbund
	0x002e0e06, // n0x15bc c0x0000 (---------------)  + I komvux
	0x00202541, // n0x15bd c0x0000 (---------------)  + I l
	0x002502c6, // n0x15be c0x0000 (---------------)  + I lanbib
	0x00201341, // n0x15bf c0x0000 (---------------)  + I m
	0x002000c1, // n0x15c0 c0x0000 (---------------)  + I n
	0x0020174e, // n0x15c1 c0x0000 (---------------)  + I naturbruksgymn
	0x002002c1, // n0x15c2 c0x0000 (---------------)  + I o
	0x0023e983, // n0x15c3 c0x0000 (---------------)  + I org
	0x00200701, // n0x15c4 c0x0000 (---------------)  + I p
	0x002c5b85, // n0x15c5 c0x0000 (---------------)  + I parti
	0x00203f02, // n0x15c6 c0x0000 (---------------)  + I pp
	0x003460c5, // n0x15c7 c0x0000 (---------------)  + I press
	0x00200081, // n0x15c8 c0x0000 (---------------)  + I r
	0x00200881, // n0x15c9 c0x0000 (---------------)  + I s
	0x0023dec4, // n0x15ca c0x0000 (---------------)  + I sshn
	0x00200141, // n0x15cb c0x0000 (---------------)  + I t
	0x0023a842, // n0x15cc c0x0000 (---------------)  + I tm
	0x00200f01, // n0x15cd c0x0000 (---------------)  + I u
	0x00201241, // n0x15ce c0x0000 (---------------)  + I w
	0x00202dc1, // n0x15cf c0x0000 (---------------)  + I x
	0x00200341, // n0x15d0 c0x0000 (---------------)  + I y
	0x00201141, // n0x15d1 c0x0000 (---------------)  + I z
	0x0003c708, // n0x15d2 c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x15d3 c0x0000 (---------------)  + I com
	0x002df843, // n0x15d4 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x15d5 c0x0000 (---------------)  + I gov
	0x00214843, // n0x15d6 c0x0000 (---------------)  + I net
	0x0023e983, // n0x15d7 c0x0000 (---------------)  + I org
	0x00210803, // n0x15d8 c0x0000 (---------------)  + I per
	0x0020d643, // n0x15d9 c0x0000 (---------------)  + I com
	0x00218d43, // n0x15da c0x0000 (---------------)  + I gov
	0x0022f003, // n0x15db c0x0000 (---------------)  + I mil
	0x00214843, // n0x15dc c0x0000 (---------------)  + I net
	0x0023e983, // n0x15dd c0x0000 (---------------)  + I org
	0x0003c708, // n0x15de c0x0000 (---------------)  +   blogspot
	0x0020d643, // n0x15df c0x0000 (---------------)  + I com
	0x002df843, // n0x15e0 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x15e1 c0x0000 (---------------)  + I gov
	0x00214843, // n0x15e2 c0x0000 (---------------)  + I net
	0x0023e983, // n0x15e3 c0x0000 (---------------)  + I org
	0x0020e343, // n0x15e4 c0x0000 (---------------)  + I art
	0x0020d643, // n0x15e5 c0x0000 (---------------)  + I com
	0x002df843, // n0x15e6 c0x0000 (---------------)  + I edu
	0x00257384, // n0x15e7 c0x0000 (---------------)  + I gouv
	0x0023e983, // n0x15e8 c0x0000 (---------------)  + I org
	0x0029a085, // n0x15e9 c0x0000 (---------------)  + I perso
	0x00209b84, // n0x15ea c0x0000 (---------------)  + I univ
	0x0020d643, // n0x15eb c0x0000 (---------------)  + I com
	0x00214843, // n0x15ec c0x0000 (---------------)  + I net
	0x0023e983, // n0x15ed c0x0000 (---------------)  + I org
	0x0020d642, // n0x15ee c0x0000 (---------------)  + I co
	0x0020d643, // n0x15ef c0x0000 (---------------)  + I com
	0x00235509, // n0x15f0 c0x0000 (---------------)  + I consulado
	0x002df843, // n0x15f1 c0x0000 (---------------)  + I edu
	0x0022d1c9, // n0x15f2 c0x0000 (---------------)  + I embaixada
	0x00218d43, // n0x15f3 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x15f4 c0x0000 (---------------)  + I mil
	0x00214843, // n0x15f5 c0x0000 (---------------)  + I net
	0x0023e983, // n0x15f6 c0x0000 (---------------)  + I org
	0x002d0388, // n0x15f7 c0x0000 (---------------)  + I principe
	0x00277d47, // n0x15f8 c0x0000 (---------------)  + I saotome
	0x002e9c05, // n0x15f9 c0x0000 (---------------)  + I store
	0x00218d43, // n0x15fa c0x0000 (---------------)  + I gov
	0x0020d643, // n0x15fb c0x0000 (---------------)  + I com
	0x002df843, // n0x15fc c0x0000 (---------------)  + I edu
	0x00218d43, // n0x15fd c0x0000 (---------------)  + I gov
	0x0022f003, // n0x15fe c0x0000 (---------------)  + I mil
	0x00214843, // n0x15ff c0x0000 (---------------)  + I net
	0x0023e983, // n0x1600 c0x0000 (---------------)  + I org
	0x00206c42, // n0x1601 c0x0000 (---------------)  + I ac
	0x0020d642, // n0x1602 c0x0000 (---------------)  + I co
	0x0023e983, // n0x1603 c0x0000 (---------------)  + I org
	0x0003c708, // n0x1604 c0x0000 (---------------)  +   blogspot
	0x00206c42, // n0x1605 c0x0000 (---------------)  + I ac
	0x0020d642, // n0x1606 c0x0000 (---------------)  + I co
	0x00200482, // n0x1607 c0x0000 (---------------)  + I go
	0x002027c2, // n0x1608 c0x0000 (---------------)  + I in
	0x00206702, // n0x1609 c0x0000 (---------------)  + I mi
	0x00214843, // n0x160a c0x0000 (---------------)  + I net
	0x00200a82, // n0x160b c0x0000 (---------------)  + I or
	0x00206c42, // n0x160c c0x0000 (---------------)  + I ac
	0x0030c243, // n0x160d c0x0000 (---------------)  + I biz
	0x0020d642, // n0x160e c0x0000 (---------------)  + I co
	0x0020d643, // n0x160f c0x0000 (---------------)  + I com
	0x002df843, // n0x1610 c0x0000 (---------------)  + I edu
	0x00200482, // n0x1611 c0x0000 (---------------)  + I go
	0x00218d43, // n0x1612 c0x0000 (---------------)  + I gov
	0x00217543, // n0x1613 c0x0000 (---------------)  + I int
	0x0022f003, // n0x1614 c0x0000 (---------------)  + I mil
	0x00202f04, // n0x1615 c0x0000 (---------------)  + I name
	0x00214843, // n0x1616 c0x0000 (---------------)  + I net
	0x00211783, // n0x1617 c0x0000 (---------------)  + I nic
	0x0023e983, // n0x1618 c0x0000 (---------------)  + I org
	0x0023c544, // n0x1619 c0x0000 (---------------)  + I test
	0x00205e43, // n0x161a c0x0000 (---------------)  + I web
	0x00218d43, // n0x161b c0x0000 (---------------)  + I gov
	0x0020d642, // n0x161c c0x0000 (---------------)  + I co
	0x0020d643, // n0x161d c0x0000 (---------------)  + I com
	0x002df843, // n0x161e c0x0000 (---------------)  + I edu
	0x00218d43, // n0x161f c0x0000 (---------------)  + I gov
	0x0022f003, // n0x1620 c0x0000 (---------------)  + I mil
	0x00214843, // n0x1621 c0x0000 (---------------)  + I net
	0x00216583, // n0x1622 c0x0000 (---------------)  + I nom
	0x0023e983, // n0x1623 c0x0000 (---------------)  + I org
	0x00230e47, // n0x1624 c0x0000 (---------------)  + I agrinet
	0x0020d643, // n0x1625 c0x0000 (---------------)  + I com
	0x0030a4c7, // n0x1626 c0x0000 (---------------)  + I defense
	0x002e7846, // n0x1627 c0x0000 (---------------)  + I edunet
	0x00209083, // n0x1628 c0x0000 (---------------)  + I ens
	0x00242a83, // n0x1629 c0x0000 (---------------)  + I fin
	0x00218d43, // n0x162a c0x0000 (---------------)  + I gov
	0x002051c3, // n0x162b c0x0000 (---------------)  + I ind
	0x00210e04, // n0x162c c0x0000 (---------------)  + I info
	0x00275104, // n0x162d c0x0000 (---------------)  + I intl
	0x002c5706, // n0x162e c0x0000 (---------------)  + I mincom
	0x00201743, // n0x162f c0x0000 (---------------)  + I nat
	0x00214843, // n0x1630 c0x0000 (---------------)  + I net
	0x0023e983, // n0x1631 c0x0000 (---------------)  + I org
	0x0029a085, // n0x1632 c0x0000 (---------------)  + I perso
	0x00200084, // n0x1633 c0x0000 (---------------)  + I rnrt
	0x00278c43, // n0x1634 c0x0000 (---------------)  + I rns
	0x002794c3, // n0x1635 c0x0000 (---------------)  + I rnu
	0x002b2c47, // n0x1636 c0x0000 (---------------)  + I tourism
	0x00244745, // n0x1637 c0x0000 (---------------)  + I turen
	0x0020d643, // n0x1638 c0x0000 (---------------)  + I com
	0x002df843, // n0x1639 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x163a c0x0000 (---------------)  + I gov
	0x0022f003, // n0x163b c0x0000 (---------------)  + I mil
	0x00214843, // n0x163c c0x0000 (---------------)  + I net
	0x0023e983, // n0x163d c0x0000 (---------------)  + I org
	0x47e08ac2, // n0x163e c0x011f (n0x1640-n0x1641)  o I nc
	0x00611783, // n0x163f c0x0001 (---------------)  ! I nic
	0x00218d43, // n0x1640 c0x0000 (---------------)  + I gov
	0x00228d84, // n0x1641 c0x0000 (---------------)  + I aero
	0x0030c243, // n0x1642 c0x0000 (---------------)  + I biz
	0x0020d642, // n0x1643 c0x0000 (---------------)  + I co
	0x0020d643, // n0x1644 c0x0000 (---------------)  + I com
	0x0023ae84, // n0x1645 c0x0000 (---------------)  + I coop
	0x002df843, // n0x1646 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x1647 c0x0000 (---------------)  + I gov
	0x00210e04, // n0x1648 c0x0000 (---------------)  + I info
	0x00217543, // n0x1649 c0x0000 (---------------)  + I int
	0x003422c4, // n0x164a c0x0000 (---------------)  + I jobs
	0x00303304, // n0x164b c0x0000 (---------------)  + I mobi
	0x002c4946, // n0x164c c0x0000 (---------------)  + I museum
	0x00202f04, // n0x164d c0x0000 (---------------)  + I name
	0x00214843, // n0x164e c0x0000 (---------------)  + I net
	0x0023e983, // n0x164f c0x0000 (---------------)  + I org
	0x002d1383, // n0x1650 c0x0000 (---------------)  + I pro
	0x002ddac6, // n0x1651 c0x0000 (---------------)  + I travel
	0x0004740b, // n0x1652 c0x0000 (---------------)  +   better-than
	0x00004a46, // n0x1653 c0x0000 (---------------)  +   dyndns
	0x0001400a, // n0x1654 c0x0000 (---------------)  +   on-the-web
	0x00131aca, // n0x1655 c0x0000 (---------------)  +   worse-than
	0x0003c708, // n0x1656 c0x0000 (---------------)  +   blogspot
	0x00262344, // n0x1657 c0x0000 (---------------)  + I club
	0x0020d643, // n0x1658 c0x0000 (---------------)  + I com
	0x0030c204, // n0x1659 c0x0000 (---------------)  + I ebiz
	0x002df843, // n0x165a c0x0000 (---------------)  + I edu
	0x0027bcc4, // n0x165b c0x0000 (---------------)  + I game
	0x00218d43, // n0x165c c0x0000 (---------------)  + I gov
	0x002629c3, // n0x165d c0x0000 (---------------)  + I idv
	0x0022f003, // n0x165e c0x0000 (---------------)  + I mil
	0x00214843, // n0x165f c0x0000 (---------------)  + I net
	0x0023e983, // n0x1660 c0x0000 (---------------)  + I org
	0x002fd38b, // n0x1661 c0x0000 (---------------)  + I xn--czrw28b
	0x00343c0a, // n0x1662 c0x0000 (---------------)  + I xn--uc0atv
	0x0034e24c, // n0x1663 c0x0000 (---------------)  + I xn--zf0ao64a
	0x00206c42, // n0x1664 c0x0000 (---------------)  + I ac
	0x0020d642, // n0x1665 c0x0000 (---------------)  + I co
	0x00200482, // n0x1666 c0x0000 (---------------)  + I go
	0x002937c5, // n0x1667 c0x0000 (---------------)  + I hotel
	0x00210e04, // n0x1668 c0x0000 (---------------)  + I info
	0x00202f82, // n0x1669 c0x0000 (---------------)  + I me
	0x0022f003, // n0x166a c0x0000 (---------------)  + I mil
	0x00303304, // n0x166b c0x0000 (---------------)  + I mobi
	0x00203e82, // n0x166c c0x0000 (---------------)  + I ne
	0x00200a82, // n0x166d c0x0000 (---------------)  + I or
	0x00201d82, // n0x166e c0x0000 (---------------)  + I sc
	0x00281802, // n0x166f c0x0000 (---------------)  + I tv
	0x002ab0c9, // n0x1670 c0x0000 (---------------)  + I cherkassy
	0x0025cdc8, // n0x1671 c0x0000 (---------------)  + I cherkasy
	0x00261489, // n0x1672 c0x0000 (---------------)  + I chernigov
	0x002647c9, // n0x1673 c0x0000 (---------------)  + I chernihiv
	0x0026c44a, // n0x1674 c0x0000 (---------------)  + I chernivtsi
	0x0028d18a, // n0x1675 c0x0000 (---------------)  + I chernovtsy
	0x00226c42, // n0x1676 c0x0000 (---------------)  + I ck
	0x00231842, // n0x1677 c0x0000 (---------------)  + I cn
	0x0020d642, // n0x1678 c0x0000 (---------------)  + I co
	0x0020d643, // n0x1679 c0x0000 (---------------)  + I com
	0x00234182, // n0x167a c0x0000 (---------------)  + I cr
	0x00240706, // n0x167b c0x0000 (---------------)  + I crimea
	0x00317442, // n0x167c c0x0000 (---------------)  + I cv
	0x00204b02, // n0x167d c0x0000 (---------------)  + I dn
	0x0030bb4e, // n0x167e c0x0000 (---------------)  + I dnepropetrovsk
	0x00318fce, // n0x167f c0x0000 (---------------)  + I dnipropetrovsk
	0x0026c2c7, // n0x1680 c0x0000 (---------------)  + I dominic
	0x002b4e47, // n0x1681 c0x0000 (---------------)  + I donetsk
	0x002cdd42, // n0x1682 c0x0000 (---------------)  + I dp
	0x002df843, // n0x1683 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x1684 c0x0000 (---------------)  + I gov
	0x00208442, // n0x1685 c0x0000 (---------------)  + I if
	0x002027c2, // n0x1686 c0x0000 (---------------)  + I in
	0x002907cf, // n0x1687 c0x0000 (---------------)  + I ivano-frankivsk
	0x00226682, // n0x1688 c0x0000 (---------------)  + I kh
	0x002789c7, // n0x1689 c0x0000 (---------------)  + I kharkiv
	0x0027aa47, // n0x168a c0x0000 (---------------)  + I kharkov
	0x0028e747, // n0x168b c0x0000 (---------------)  + I kherson
	0x00290f8c, // n0x168c c0x0000 (---------------)  + I khmelnitskiy
	0x002eb38c, // n0x168d c0x0000 (---------------)  + I khmelnytskyi
	0x0020ab04, // n0x168e c0x0000 (---------------)  + I kiev
	0x0026d94a, // n0x168f c0x0000 (---------------)  + I kirovograd
	0x002a07c2, // n0x1690 c0x0000 (---------------)  + I km
	0x002015c2, // n0x1691 c0x0000 (---------------)  + I kr
	0x002a2644, // n0x1692 c0x0000 (---------------)  + I krym
	0x00201942, // n0x1693 c0x0000 (---------------)  + I ks
	0x00228002, // n0x1694 c0x0000 (---------------)  + I kv
	0x002eb5c4, // n0x1695 c0x0000 (---------------)  + I kyiv
	0x00216382, // n0x1696 c0x0000 (---------------)  + I lg
	0x0020b7c2, // n0x1697 c0x0000 (---------------)  + I lt
	0x002e5e87, // n0x1698 c0x0000 (---------------)  + I lugansk
	0x00234d05, // n0x1699 c0x0000 (---------------)  + I lutsk
	0x002075c2, // n0x169a c0x0000 (---------------)  + I lv
	0x0023f484, // n0x169b c0x0000 (---------------)  + I lviv
	0x003246c2, // n0x169c c0x0000 (---------------)  + I mk
	0x00290648, // n0x169d c0x0000 (---------------)  + I mykolaiv
	0x00214843, // n0x169e c0x0000 (---------------)  + I net
	0x00213788, // n0x169f c0x0000 (---------------)  + I nikolaev
	0x00206d82, // n0x16a0 c0x0000 (---------------)  + I od
	0x002c3905, // n0x16a1 c0x0000 (---------------)  + I odesa
	0x0032a546, // n0x16a2 c0x0000 (---------------)  + I odessa
	0x0023e983, // n0x16a3 c0x0000 (---------------)  + I org
	0x0020c3c2, // n0x16a4 c0x0000 (---------------)  + I pl
	0x002ce907, // n0x16a5 c0x0000 (---------------)  + I poltava
	0x00203f02, // n0x16a6 c0x0000 (---------------)  + I pp
	0x002d1245, // n0x16a7 c0x0000 (---------------)  + I rivne
	0x00200ac5, // n0x16a8 c0x0000 (---------------)  + I rovno
	0x002214c2, // n0x16a9 c0x0000 (---------------)  + I rv
	0x0023c6c2, // n0x16aa c0x0000 (---------------)  + I sb
	0x002f9dca, // n0x16ab c0x0000 (---------------)  + I sebastopol
	0x003003ca, // n0x16ac c0x0000 (---------------)  + I sevastopol
	0x00216a02, // n0x16ad c0x0000 (---------------)  + I sm
	0x0029cdc4, // n0x16ae c0x0000 (---------------)  + I sumy
	0x002013c2, // n0x16af c0x0000 (---------------)  + I te
	0x00229588, // n0x16b0 c0x0000 (---------------)  + I ternopil
	0x0023c302, // n0x16b1 c0x0000 (---------------)  + I uz
	0x00269f48, // n0x16b2 c0x0000 (---------------)  + I uzhgorod
	0x002ef207, // n0x16b3 c0x0000 (---------------)  + I vinnica
	0x002f0509, // n0x16b4 c0x0000 (---------------)  + I vinnytsia
	0x00200b42, // n0x16b5 c0x0000 (---------------)  + I vn
	0x002f3905, // n0x16b6 c0x0000 (---------------)  + I volyn
	0x002eb005, // n0x16b7 c0x0000 (---------------)  + I yalta
	0x0025758b, // n0x16b8 c0x0000 (---------------)  + I zaporizhzhe
	0x002fa4cc, // n0x16b9 c0x0000 (---------------)  + I zaporizhzhia
	0x002f3cc8, // n0x16ba c0x0000 (---------------)  + I zhitomir
	0x00251fc8, // n0x16bb c0x0000 (---------------)  + I zhytomyr
	0x002d2c42, // n0x16bc c0x0000 (---------------)  + I zp
	0x0020d942, // n0x16bd c0x0000 (---------------)  + I zt
	0x00206c42, // n0x16be c0x0000 (---------------)  + I ac
	0x0020d642, // n0x16bf c0x0000 (---------------)  + I co
	0x0020d643, // n0x16c0 c0x0000 (---------------)  + I com
	0x00200482, // n0x16c1 c0x0000 (---------------)  + I go
	0x00203e82, // n0x16c2 c0x0000 (---------------)  + I ne
	0x00200a82, // n0x16c3 c0x0000 (---------------)  + I or
	0x0023e983, // n0x16c4 c0x0000 (---------------)  + I org
	0x00201d82, // n0x16c5 c0x0000 (---------------)  + I sc
	0x00605582, // n0x16c6 c0x0001 (---------------)  ! I bl
	0x0061bccf, // n0x16c7 c0x0001 (---------------)  ! I british-library
	0x49e0d642, // n0x16c8 c0x0127 (n0x16d1-n0x16d2)  o I co
	0x0068f283, // n0x16c9 c0x0001 (---------------)  ! I jet
	0x00649483, // n0x16ca c0x0001 (---------------)  ! I mod
	0x0061e759, // n0x16cb c0x0001 (---------------)  ! I national-library-scotland
	0x006226c3, // n0x16cc c0x0001 (---------------)  ! I nel
	0x00611783, // n0x16cd c0x0001 (---------------)  ! I nic
	0x0063ba43, // n0x16ce c0x0001 (---------------)  ! I nls
	0x006d2c8a, // n0x16cf c0x0001 (---------------)  ! I parliament
	0x01601d83, // n0x16d0 c0x0005 (---------------)* o I sch
	0x0003c708, // n0x16d1 c0x0000 (---------------)  +   blogspot
	0x4a601582, // n0x16d2 c0x0129 (n0x1711-n0x1714)  + I ak
	0x4aa03982, // n0x16d3 c0x012a (n0x1714-n0x1717)  + I al
	0x4ae00182, // n0x16d4 c0x012b (n0x1717-n0x171a)  + I ar
	0x4b202c02, // n0x16d5 c0x012c (n0x171a-n0x171d)  + I as
	0x4b616d42, // n0x16d6 c0x012d (n0x171d-n0x1720)  + I az
	0x4ba01002, // n0x16d7 c0x012e (n0x1720-n0x1723)  + I ca
	0x4be0d642, // n0x16d8 c0x012f (n0x1723-n0x1726)  + I co
	0x4c234a42, // n0x16d9 c0x0130 (n0x1726-n0x1729)  + I ct
	0x4c61e242, // n0x16da c0x0131 (n0x1729-n0x172c)  + I dc
	0x4ca02602, // n0x16db c0x0132 (n0x172c-n0x172f)  + I de
	0x002ec6c3, // n0x16dc c0x0000 (---------------)  + I dni
	0x0022bf83, // n0x16dd c0x0000 (---------------)  + I fed
	0x4ce45142, // n0x16de c0x0133 (n0x172f-n0x1732)  + I fl
	0x4d202bc2, // n0x16df c0x0134 (n0x1732-n0x1735)  + I ga
	0x4d609b42, // n0x16e0 c0x0135 (n0x1735-n0x1738)  + I gu
	0x4da00742, // n0x16e1 c0x0136 (n0x1738-n0x173a)  + I hi
	0x4de05042, // n0x16e2 c0x0137 (n0x173a-n0x173d)  + I ia
	0x4e202282, // n0x16e3 c0x0138 (n0x173d-n0x1740)  + I id
	0x4e602702, // n0x16e4 c0x0139 (n0x1740-n0x1743)  + I il
	0x4ea027c2, // n0x16e5 c0x013a (n0x1743-n0x1746)  + I in
	0x000c9445, // n0x16e6 c0x0000 (---------------)  +   is-by
	0x0022d543, // n0x16e7 c0x0000 (---------------)  + I isa
	0x00211f84, // n0x16e8 c0x0000 (---------------)  + I kids
	0x4ee01942, // n0x16e9 c0x013b (n0x1746-n0x1749)  + I ks
	0x4f200302, // n0x16ea c0x013c (n0x1749-n0x174c)  + I ky
	0x4f602542, // n0x16eb c0x013d (n0x174c-n0x174f)  + I la
	0x000a7c8b, // n0x16ec c0x0000 (---------------)  +   land-4-sale
	0x4fa02d02, // n0x16ed c0x013e (n0x174f-n0x1752)  + I ma
	0x50211042, // n0x16ee c0x0140 (n0x1755-n0x1758)  + I md
	0x50602f82, // n0x16ef c0x0141 (n0x1758-n0x175b)  + I me
	0x50a06702, // n0x16f0 c0x0142 (n0x175b-n0x175e)  + I mi
	0x50e01702, // n0x16f1 c0x0143 (n0x175e-n0x1761)  + I mn
	0x51203d42, // n0x16f2 c0x0144 (n0x1761-n0x1764)  + I mo
	0x51601342, // n0x16f3 c0x0145 (n0x1764-n0x1767)  + I ms
	0x51a5c502, // n0x16f4 c0x0146 (n0x1767-n0x176a)  + I mt
	0x51e08ac2, // n0x16f5 c0x0147 (n0x176a-n0x176d)  + I nc
	0x522025c2, // n0x16f6 c0x0148 (n0x176d-n0x1770)  + I nd
	0x52603e82, // n0x16f7 c0x0149 (n0x1770-n0x1773)  + I ne
	0x52a13682, // n0x16f8 c0x014a (n0x1773-n0x1776)  + I nh
	0x52e15442, // n0x16f9 c0x014b (n0x1776-n0x1779)  + I nj
	0x5320c202, // n0x16fa c0x014c (n0x1779-n0x177c)  + I nm
	0x00228bc3, // n0x16fb c0x0000 (---------------)  + I nsn
	0x5363ab42, // n0x16fc c0x014d (n0x177c-n0x177f)  + I nv
	0x53a11642, // n0x16fd c0x014e (n0x177f-n0x1782)  + I ny
	0x53e03b42, // n0x16fe c0x014f (n0x1782-n0x1785)  + I oh
	0x542002c2, // n0x16ff c0x0150 (n0x1785-n0x1788)  + I ok
	0x54600a82, // n0x1700 c0x0151 (n0x1788-n0x178b)  + I or
	0x54a0d002, // n0x1701 c0x0152 (n0x178b-n0x178e)  + I pa
	0x54e61ec2, // n0x1702 c0x0153 (n0x178e-n0x1791)  + I pr
	0x55201d02, // n0x1703 c0x0154 (n0x1791-n0x1794)  + I ri
	0x55601d82, // n0x1704 c0x0155 (n0x1794-n0x1797)  + I sc
	0x55a03902, // n0x1705 c0x0156 (n0x1797-n0x179a)  + I sd
	0x000ea3cc, // n0x1706 c0x0000 (---------------)  +   stuff-4-sale
	0x55e03602, // n0x1707 c0x0157 (n0x179a-n0x179d)  + I tn
	0x56264502, // n0x1708 c0x0158 (n0x179d-n0x17a0)  + I tx
	0x5660a6c2, // n0x1709 c0x0159 (n0x17a0-n0x17a3)  + I ut
	0x56a06f02, // n0x170a c0x015a (n0x17a3-n0x17a6)  + I va
	0x56e09542, // n0x170b c0x015b (n0x17a6-n0x17a9)  + I vi
	0x57237882, // n0x170c c0x015c (n0x17a9-n0x17ac)  + I vt
	0x57603102, // n0x170d c0x015d (n0x17ac-n0x17af)  + I wa
	0x57a05002, // n0x170e c0x015e (n0x17af-n0x17b2)  + I wi
	0x57e67602, // n0x170f c0x015f (n0x17b2-n0x17b5)  + I wv
	0x5823d502, // n0x1710 c0x0160 (n0x17b5-n0x17b8)  + I wy
	0x00206842, // n0x1711 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1712 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1713 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1714 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1715 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1716 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1717 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1718 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1719 c0x0000 (---------------)  + I lib
	0x00206842, // n0x171a c0x0000 (---------------)  + I cc
	0x002316c3, // n0x171b c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x171c c0x0000 (---------------)  + I lib
	0x00206842, // n0x171d c0x0000 (---------------)  + I cc
	0x002316c3, // n0x171e c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x171f c0x0000 (---------------)  + I lib
	0x00206842, // n0x1720 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1721 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1722 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1723 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1724 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1725 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1726 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1727 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1728 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1729 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x172a c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x172b c0x0000 (---------------)  + I lib
	0x00206842, // n0x172c c0x0000 (---------------)  + I cc
	0x002316c3, // n0x172d c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x172e c0x0000 (---------------)  + I lib
	0x00206842, // n0x172f c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1730 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1731 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1732 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1733 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1734 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1735 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1736 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1737 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1738 c0x0000 (---------------)  + I cc
	0x0021bec3, // n0x1739 c0x0000 (---------------)  + I lib
	0x00206842, // n0x173a c0x0000 (---------------)  + I cc
	0x002316c3, // n0x173b c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x173c c0x0000 (---------------)  + I lib
	0x00206842, // n0x173d c0x0000 (---------------)  + I cc
	0x002316c3, // n0x173e c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x173f c0x0000 (---------------)  + I lib
	0x00206842, // n0x1740 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1741 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1742 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1743 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1744 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1745 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1746 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1747 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1748 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1749 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x174a c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x174b c0x0000 (---------------)  + I lib
	0x00206842, // n0x174c c0x0000 (---------------)  + I cc
	0x002316c3, // n0x174d c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x174e c0x0000 (---------------)  + I lib
	0x00206842, // n0x174f c0x0000 (---------------)  + I cc
	0x4fe316c3, // n0x1750 c0x013f (n0x1752-n0x1755)  + I k12
	0x0021bec3, // n0x1751 c0x0000 (---------------)  + I lib
	0x0030a184, // n0x1752 c0x0000 (---------------)  + I chtr
	0x0032b3c6, // n0x1753 c0x0000 (---------------)  + I paroch
	0x002d36c3, // n0x1754 c0x0000 (---------------)  + I pvt
	0x00206842, // n0x1755 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1756 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1757 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1758 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1759 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x175a c0x0000 (---------------)  + I lib
	0x00206842, // n0x175b c0x0000 (---------------)  + I cc
	0x002316c3, // n0x175c c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x175d c0x0000 (---------------)  + I lib
	0x00206842, // n0x175e c0x0000 (---------------)  + I cc
	0x002316c3, // n0x175f c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1760 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1761 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1762 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1763 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1764 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1765 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1766 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1767 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1768 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1769 c0x0000 (---------------)  + I lib
	0x00206842, // n0x176a c0x0000 (---------------)  + I cc
	0x002316c3, // n0x176b c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x176c c0x0000 (---------------)  + I lib
	0x00206842, // n0x176d c0x0000 (---------------)  + I cc
	0x002316c3, // n0x176e c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x176f c0x0000 (---------------)  + I lib
	0x00206842, // n0x1770 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1771 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1772 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1773 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1774 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1775 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1776 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1777 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1778 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1779 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x177a c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x177b c0x0000 (---------------)  + I lib
	0x00206842, // n0x177c c0x0000 (---------------)  + I cc
	0x002316c3, // n0x177d c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x177e c0x0000 (---------------)  + I lib
	0x00206842, // n0x177f c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1780 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1781 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1782 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1783 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1784 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1785 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1786 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1787 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1788 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1789 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x178a c0x0000 (---------------)  + I lib
	0x00206842, // n0x178b c0x0000 (---------------)  + I cc
	0x002316c3, // n0x178c c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x178d c0x0000 (---------------)  + I lib
	0x00206842, // n0x178e c0x0000 (---------------)  + I cc
	0x002316c3, // n0x178f c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1790 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1791 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1792 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1793 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1794 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1795 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1796 c0x0000 (---------------)  + I lib
	0x00206842, // n0x1797 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x1798 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x1799 c0x0000 (---------------)  + I lib
	0x00206842, // n0x179a c0x0000 (---------------)  + I cc
	0x002316c3, // n0x179b c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x179c c0x0000 (---------------)  + I lib
	0x00206842, // n0x179d c0x0000 (---------------)  + I cc
	0x002316c3, // n0x179e c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x179f c0x0000 (---------------)  + I lib
	0x00206842, // n0x17a0 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x17a1 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x17a2 c0x0000 (---------------)  + I lib
	0x00206842, // n0x17a3 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x17a4 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x17a5 c0x0000 (---------------)  + I lib
	0x00206842, // n0x17a6 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x17a7 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x17a8 c0x0000 (---------------)  + I lib
	0x00206842, // n0x17a9 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x17aa c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x17ab c0x0000 (---------------)  + I lib
	0x00206842, // n0x17ac c0x0000 (---------------)  + I cc
	0x002316c3, // n0x17ad c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x17ae c0x0000 (---------------)  + I lib
	0x00206842, // n0x17af c0x0000 (---------------)  + I cc
	0x002316c3, // n0x17b0 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x17b1 c0x0000 (---------------)  + I lib
	0x00206842, // n0x17b2 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x17b3 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x17b4 c0x0000 (---------------)  + I lib
	0x00206842, // n0x17b5 c0x0000 (---------------)  + I cc
	0x002316c3, // n0x17b6 c0x0000 (---------------)  + I k12
	0x0021bec3, // n0x17b7 c0x0000 (---------------)  + I lib
	0x0020d643, // n0x17b8 c0x0000 (---------------)  + I com
	0x002df843, // n0x17b9 c0x0000 (---------------)  + I edu
	0x00236b83, // n0x17ba c0x0000 (---------------)  + I gub
	0x0022f003, // n0x17bb c0x0000 (---------------)  + I mil
	0x00214843, // n0x17bc c0x0000 (---------------)  + I net
	0x0023e983, // n0x17bd c0x0000 (---------------)  + I org
	0x0020d642, // n0x17be c0x0000 (---------------)  + I co
	0x0020d643, // n0x17bf c0x0000 (---------------)  + I com
	0x00214843, // n0x17c0 c0x0000 (---------------)  + I net
	0x0023e983, // n0x17c1 c0x0000 (---------------)  + I org
	0x0020d643, // n0x17c2 c0x0000 (---------------)  + I com
	0x002df843, // n0x17c3 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x17c4 c0x0000 (---------------)  + I gov
	0x0022f003, // n0x17c5 c0x0000 (---------------)  + I mil
	0x00214843, // n0x17c6 c0x0000 (---------------)  + I net
	0x0023e983, // n0x17c7 c0x0000 (---------------)  + I org
	0x0020d642, // n0x17c8 c0x0000 (---------------)  + I co
	0x0020d643, // n0x17c9 c0x0000 (---------------)  + I com
	0x002bd803, // n0x17ca c0x0000 (---------------)  + I e12
	0x002df843, // n0x17cb c0x0000 (---------------)  + I edu
	0x00218d43, // n0x17cc c0x0000 (---------------)  + I gov
	0x00210e04, // n0x17cd c0x0000 (---------------)  + I info
	0x0022f003, // n0x17ce c0x0000 (---------------)  + I mil
	0x00214843, // n0x17cf c0x0000 (---------------)  + I net
	0x0023e983, // n0x17d0 c0x0000 (---------------)  + I org
	0x00205e43, // n0x17d1 c0x0000 (---------------)  + I web
	0x0020d642, // n0x17d2 c0x0000 (---------------)  + I co
	0x0020d643, // n0x17d3 c0x0000 (---------------)  + I com
	0x002316c3, // n0x17d4 c0x0000 (---------------)  + I k12
	0x00214843, // n0x17d5 c0x0000 (---------------)  + I net
	0x0023e983, // n0x17d6 c0x0000 (---------------)  + I org
	0x00206c42, // n0x17d7 c0x0000 (---------------)  + I ac
	0x0030c243, // n0x17d8 c0x0000 (---------------)  + I biz
	0x0020d643, // n0x17d9 c0x0000 (---------------)  + I com
	0x002df843, // n0x17da c0x0000 (---------------)  + I edu
	0x00218d43, // n0x17db c0x0000 (---------------)  + I gov
	0x00246b06, // n0x17dc c0x0000 (---------------)  + I health
	0x00210e04, // n0x17dd c0x0000 (---------------)  + I info
	0x00217543, // n0x17de c0x0000 (---------------)  + I int
	0x00202f04, // n0x17df c0x0000 (---------------)  + I name
	0x00214843, // n0x17e0 c0x0000 (---------------)  + I net
	0x0023e983, // n0x17e1 c0x0000 (---------------)  + I org
	0x002d1383, // n0x17e2 c0x0000 (---------------)  + I pro
	0x0020d643, // n0x17e3 c0x0000 (---------------)  + I com
	0x00004a46, // n0x17e4 c0x0000 (---------------)  +   dyndns
	0x002df843, // n0x17e5 c0x0000 (---------------)  + I edu
	0x00218d43, // n0x17e6 c0x0000 (---------------)  + I gov
	0x0009ce46, // n0x17e7 c0x0000 (---------------)  +   mypets
	0x00214843, // n0x17e8 c0x0000 (---------------)  + I net
	0x0023e983, // n0x17e9 c0x0000 (---------------)  + I org
}

// children is the list of nodes' children, the parent's wildcard bit and the
// parent's node type. If a node has no children then their children index
// will be in the range [0, 6), depending on the wildcard bit and node type.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 1 bits] wildcard bit
//	[ 2 bits] node type
//	[14 bits] high nodes index (exclusive) of children
//	[14 bits] low nodes index (inclusive) of children
var children = [...]uint32{
	0x00000000, // c0x0000 (---------------)  +
	0x10000000, // c0x0001 (---------------)  !
	0x20000000, // c0x0002 (---------------)  o
	0x40000000, // c0x0003 (---------------)* +
	0x50000000, // c0x0004 (---------------)* !
	0x60000000, // c0x0005 (---------------)* o
	0x004f0136, // c0x0006 (n0x0136-n0x013c)  +
	0x004f413c, // c0x0007 (n0x013c-n0x013d)  +
	0x0051013d, // c0x0008 (n0x013d-n0x0144)  +
	0x00674144, // c0x0009 (n0x0144-n0x019d)  +
	0x0068819d, // c0x000a (n0x019d-n0x01a2)  +
	0x0069c1a2, // c0x000b (n0x01a2-n0x01a7)  +
	0x006ac1a7, // c0x000c (n0x01a7-n0x01ab)  +
	0x006c41ab, // c0x000d (n0x01ab-n0x01b1)  +
	0x006d41b1, // c0x000e (n0x01b1-n0x01b5)  +
	0x006ec1b5, // c0x000f (n0x01b5-n0x01bb)  +
	0x607141bb, // c0x0010 (n0x01bb-n0x01c5)* o
	0x207181c5, // c0x0011 (n0x01c5-n0x01c6)  o
	0x207301c6, // c0x0012 (n0x01c6-n0x01cc)  o
	0x007341cc, // c0x0013 (n0x01cc-n0x01cd)  +
	0x007501cd, // c0x0014 (n0x01cd-n0x01d4)  +
	0x007541d4, // c0x0015 (n0x01d4-n0x01d5)  +
	0x2079c1d5, // c0x0016 (n0x01d5-n0x01e7)  o
	0x007a01e7, // c0x0017 (n0x01e7-n0x01e8)  +
	0x007c01e8, // c0x0018 (n0x01e8-n0x01f0)  +
	0x007dc1f0, // c0x0019 (n0x01f0-n0x01f7)  +
	0x007e01f7, // c0x001a (n0x01f7-n0x01f8)  +
	0x008101f8, // c0x001b (n0x01f8-n0x0204)  +
	0x00838204, // c0x001c (n0x0204-n0x020e)  +
	0x0085820e, // c0x001d (n0x020e-n0x0216)  +
	0x00860216, // c0x001e (n0x0216-n0x0218)  +
	0x00864218, // c0x001f (n0x0218-n0x0219)  +
	0x008f4219, // c0x0020 (n0x0219-n0x023d)  +
	0x0090823d, // c0x0021 (n0x023d-n0x0242)  +
	0x0091c242, // c0x0022 (n0x0242-n0x0247)  +
	0x00938247, // c0x0023 (n0x0247-n0x024e)  +
	0x0094824e, // c0x0024 (n0x024e-n0x0252)  +
	0x0095c252, // c0x0025 (n0x0252-n0x0257)  +
	0x00980257, // c0x0026 (n0x0257-n0x0260)  +
	0x00a94260, // c0x0027 (n0x0260-n0x02a5)  +
	0x00a982a5, // c0x0028 (n0x02a5-n0x02a6)  +
	0x00aac2a6, // c0x0029 (n0x02a6-n0x02ab)  +
	0x00ac02ab, // c0x002a (n0x02ab-n0x02b0)  +
	0x00ac82b0, // c0x002b (n0x02b0-n0x02b2)  +
	0x00ad82b2, // c0x002c (n0x02b2-n0x02b6)  +
	0x00aec2b6, // c0x002d (n0x02b6-n0x02bb)  +
	0x00b302bb, // c0x002e (n0x02bb-n0x02cc)  +
	0x00b402cc, // c0x002f (n0x02cc-n0x02d0)  +
	0x00b442d0, // c0x0030 (n0x02d0-n0x02d1)  +
	0x00b482d1, // c0x0031 (n0x02d1-n0x02d2)  +
	0x00b4c2d2, // c0x0032 (n0x02d2-n0x02d3)  +
	0x00b882d3, // c0x0033 (n0x02d3-n0x02e2)  +
	0x60b8c2e2, // c0x0034 (n0x02e2-n0x02e3)* o
	0x00b9c2e3, // c0x0035 (n0x02e3-n0x02e7)  +
	0x00ba02e7, // c0x0036 (n0x02e7-n0x02e8)  +
	0x00c502e8, // c0x0037 (n0x02e8-n0x0314)  +
	0x00c84314, // c0x0038 (n0x0314-n0x0321)  +
	0x00f54321, // c0x0039 (n0x0321-n0x03d5)  +
	0x20fa43d5, // c0x003a (n0x03d5-n0x03e9)  o
	0x00fc03e9, // c0x003b (n0x03e9-n0x03f0)  +
	0x00fd83f0, // c0x003c (n0x03f0-n0x03f6)  +
	0x00fdc3f6, // c0x003d (n0x03f6-n0x03f7)  +
	0x00fec3f7, // c0x003e (n0x03f7-n0x03fb)  +
	0x00ff43fb, // c0x003f (n0x03fb-n0x03fd)  +
	0x00ff83fd, // c0x0040 (n0x03fd-n0x03fe)  +
	0x010183fe, // c0x0041 (n0x03fe-n0x0406)  +
	0x0101c406, // c0x0042 (n0x0406-n0x0407)  +
	0x01030407, // c0x0043 (n0x0407-n0x040c)  +
	0x0105840c, // c0x0044 (n0x040c-n0x0416)  +
	0x01078416, // c0x0045 (n0x0416-n0x041e)  +
	0x010a841e, // c0x0046 (n0x041e-n0x042a)  +
	0x010d042a, // c0x0047 (n0x042a-n0x0434)  +
	0x010f4434, // c0x0048 (n0x0434-n0x043d)  +
	0x0110843d, // c0x0049 (n0x043d-n0x0442)  +
	0x0110c442, // c0x004a (n0x0442-n0x0443)  +
	0x01118443, // c0x004b (n0x0443-n0x0446)  +
	0x01178446, // c0x004c (n0x0446-n0x045e)  +
	0x0119445e, // c0x004d (n0x045e-n0x0465)  +
	0x011a8465, // c0x004e (n0x0465-n0x046a)  +
	0x011bc46a, // c0x004f (n0x046a-n0x046f)  +
	0x011d446f, // c0x0050 (n0x046f-n0x0475)  +
	0x211ec475, // c0x0051 (n0x0475-n0x047b)  o
	0x0120447b, // c0x0052 (n0x047b-n0x0481)  +
	0x0121c481, // c0x0053 (n0x0481-n0x0487)  +
	0x01238487, // c0x0054 (n0x0487-n0x048e)  +
	0x0124448e, // c0x0055 (n0x048e-n0x0491)  +
	0x0129c491, // c0x0056 (n0x0491-n0x04a7)  +
	0x012b44a7, // c0x0057 (n0x04a7-n0x04ad)  +
	0x012c44ad, // c0x0058 (n0x04ad-n0x04b1)  +
	0x013084b1, // c0x0059 (n0x04b1-n0x04c2)  +
	0x013884c2, // c0x005a (n0x04c2-n0x04e2)  +
	0x013b04e2, // c0x005b (n0x04e2-n0x04ec)  +
	0x013b84ec, // c0x005c (n0x04ec-n0x04ee)  +
	0x613bc4ee, // c0x005d (n0x04ee-n0x04ef)* o
	0x213c04ef, // c0x005e (n0x04ef-n0x04f0)  o
	0x013d84f0, // c0x005f (n0x04f0-n0x04f6)  +
	0x013e04f6, // c0x0060 (n0x04f6-n0x04f8)  +
	0x014144f8, // c0x0061 (n0x04f8-n0x0505)  +
	0x0143c505, // c0x0062 (n0x0505-n0x050f)  +
	0x0144050f, // c0x0063 (n0x050f-n0x0510)  +
	0x01448510, // c0x0064 (n0x0510-n0x0512)  +
	0x01460512, // c0x0065 (n0x0512-n0x0518)  +
	0x01484518, // c0x0066 (n0x0518-n0x0521)  +
	0x0149c521, // c0x0067 (n0x0521-n0x0527)  +
	0x018f4527, // c0x0068 (n0x0527-n0x063d)  +
	0x0190863d, // c0x0069 (n0x063d-n0x0642)  +
	0x01928642, // c0x006a (n0x0642-n0x064a)  +
	0x01a2864a, // c0x006b (n0x064a-n0x068a)  +
	0x01afc68a, // c0x006c (n0x068a-n0x06bf)  +
	0x01b6c6bf, // c0x006d (n0x06bf-n0x06db)  +
	0x01bc46db, // c0x006e (n0x06db-n0x06f1)  +
	0x01cac6f1, // c0x006f (n0x06f1-n0x072b)  +
	0x01d0472b, // c0x0070 (n0x072b-n0x0741)  +
	0x01d40741, // c0x0071 (n0x0741-n0x0750)  +
	0x01e3c750, // c0x0072 (n0x0750-n0x078f)  +
	0x01f0878f, // c0x0073 (n0x078f-n0x07c2)  +
	0x01fa07c2, // c0x0074 (n0x07c2-n0x07e8)  +
	0x020307e8, // c0x0075 (n0x07e8-n0x080c)  +
	0x0209480c, // c0x0076 (n0x080c-n0x0825)  +
	0x022cc825, // c0x0077 (n0x0825-n0x08b3)  +
	0x023848b3, // c0x0078 (n0x08b3-n0x08e1)  +
	0x024508e1, // c0x0079 (n0x08e1-n0x0914)  +
	0x0249c914, // c0x007a (n0x0914-n0x0927)  +
	0x02528927, // c0x007b (n0x0927-n0x094a)  +
	0x0256494a, // c0x007c (n0x094a-n0x0959)  +
	0x025b4959, // c0x007d (n0x0959-n0x096d)  +
	0x0262c96d, // c0x007e (n0x096d-n0x098b)  +
	0x6263098b, // c0x007f (n0x098b-n0x098c)* o
	0x6263498c, // c0x0080 (n0x098c-n0x098d)* o
	0x6263898d, // c0x0081 (n0x098d-n0x098e)* o
	0x026b498e, // c0x0082 (n0x098e-n0x09ad)  +
	0x0271c9ad, // c0x0083 (n0x09ad-n0x09c7)  +
	0x027989c7, // c0x0084 (n0x09c7-n0x09e6)  +
	0x028109e6, // c0x0085 (n0x09e6-n0x0a04)  +
	0x02894a04, // c0x0086 (n0x0a04-n0x0a25)  +
	0x02900a25, // c0x0087 (n0x0a25-n0x0a40)  +
	0x02a2ca40, // c0x0088 (n0x0a40-n0x0a8b)  +
	0x02a84a8b, // c0x0089 (n0x0a8b-n0x0aa1)  +
	0x62a88aa1, // c0x008a (n0x0aa1-n0x0aa2)* o
	0x02b20aa2, // c0x008b (n0x0aa2-n0x0ac8)  +
	0x02ba8ac8, // c0x008c (n0x0ac8-n0x0aea)  +
	0x02bf4aea, // c0x008d (n0x0aea-n0x0afd)  +
	0x02c5cafd, // c0x008e (n0x0afd-n0x0b17)  +
	0x02d04b17, // c0x008f (n0x0b17-n0x0b41)  +
	0x02dccb41, // c0x0090 (n0x0b41-n0x0b73)  +
	0x02e34b73, // c0x0091 (n0x0b73-n0x0b8d)  +
	0x02f48b8d, // c0x0092 (n0x0b8d-n0x0bd2)  +
	0x62f4cbd2, // c0x0093 (n0x0bd2-n0x0bd3)* o
	0x62f50bd3, // c0x0094 (n0x0bd3-n0x0bd4)* o
	0x02facbd4, // c0x0095 (n0x0bd4-n0x0beb)  +
	0x03008beb, // c0x0096 (n0x0beb-n0x0c02)  +
	0x03098c02, // c0x0097 (n0x0c02-n0x0c26)  +
	0x03114c26, // c0x0098 (n0x0c26-n0x0c45)  +
	0x03158c45, // c0x0099 (n0x0c45-n0x0c56)  +
	0x0323cc56, // c0x009a (n0x0c56-n0x0c8f)  +
	0x03270c8f, // c0x009b (n0x0c8f-n0x0c9c)  +
	0x032d0c9c, // c0x009c (n0x0c9c-n0x0cb4)  +
	0x03344cb4, // c0x009d (n0x0cb4-n0x0cd1)  +
	0x033cccd1, // c0x009e (n0x0cd1-n0x0cf3)  +
	0x0340ccf3, // c0x009f (n0x0cf3-n0x0d03)  +
	0x0347cd03, // c0x00a0 (n0x0d03-n0x0d1f)  +
	0x63480d1f, // c0x00a1 (n0x0d1f-n0x0d20)* o
	0x03498d20, // c0x00a2 (n0x0d20-n0x0d26)  +
	0x034b4d26, // c0x00a3 (n0x0d26-n0x0d2d)  +
	0x034f8d2d, // c0x00a4 (n0x0d2d-n0x0d3e)  +
	0x03508d3e, // c0x00a5 (n0x0d3e-n0x0d42)  +
	0x23520d42, // c0x00a6 (n0x0d42-n0x0d48)  o
	0x03598d48, // c0x00a7 (n0x0d48-n0x0d66)  +
	0x035acd66, // c0x00a8 (n0x0d66-n0x0d6b)  +
	0x035c4d6b, // c0x00a9 (n0x0d6b-n0x0d71)  +
	0x035e8d71, // c0x00aa (n0x0d71-n0x0d7a)  +
	0x235fcd7a, // c0x00ab (n0x0d7a-n0x0d7f)  o
	0x03614d7f, // c0x00ac (n0x0d7f-n0x0d85)  +
	0x0364cd85, // c0x00ad (n0x0d85-n0x0d93)  +
	0x23660d93, // c0x00ae (n0x0d93-n0x0d98)  o
	0x03668d98, // c0x00af (n0x0d98-n0x0d9a)  +
	0x0366cd9a, // c0x00b0 (n0x0d9a-n0x0d9b)  +
	0x03690d9b, // c0x00b1 (n0x0d9b-n0x0da4)  +
	0x036b4da4, // c0x00b2 (n0x0da4-n0x0dad)  +
	0x036ccdad, // c0x00b3 (n0x0dad-n0x0db3)  +
	0x036d4db3, // c0x00b4 (n0x0db3-n0x0db5)  +
	0x036f4db5, // c0x00b5 (n0x0db5-n0x0dbd)  +
	0x03714dbd, // c0x00b6 (n0x0dbd-n0x0dc5)  +
	0x03730dc5, // c0x00b7 (n0x0dc5-n0x0dcc)  +
	0x0374cdcc, // c0x00b8 (n0x0dcc-n0x0dd3)  +
	0x0375cdd3, // c0x00b9 (n0x0dd3-n0x0dd7)  +
	0x03770dd7, // c0x00ba (n0x0dd7-n0x0ddc)  +
	0x03778ddc, // c0x00bb (n0x0ddc-n0x0dde)  +
	0x03794dde, // c0x00bc (n0x0dde-n0x0de5)  +
	0x04024de5, // c0x00bd (n0x0de5-n0x1009)  +
	0x0405d009, // c0x00be (n0x1009-n0x1017)  +
	0x04089017, // c0x00bf (n0x1017-n0x1022)  +
	0x040a1022, // c0x00c0 (n0x1022-n0x1028)  +
	0x040bd028, // c0x00c1 (n0x1028-n0x102f)  +
	0x640c102f, // c0x00c2 (n0x102f-n0x1030)* o
	0x04105030, // c0x00c3 (n0x1030-n0x1041)  +
	0x0410d041, // c0x00c4 (n0x1041-n0x1043)  +
	0x24111043, // c0x00c5 (n0x1043-n0x1044)  o
	0x24115044, // c0x00c6 (n0x1044-n0x1045)  o
	0x04119045, // c0x00c7 (n0x1045-n0x1046)  +
	0x041c1046, // c0x00c8 (n0x1046-n0x1070)  +
	0x041e9070, // c0x00c9 (n0x1070-n0x107a)  +
	0x2420107a, // c0x00ca (n0x107a-n0x1080)  o
	0x0420d080, // c0x00cb (n0x1080-n0x1083)  +
	0x04d65083, // c0x00cc (n0x1083-n0x1359)  +
	0x04d69359, // c0x00cd (n0x1359-n0x135a)  +
	0x04d6d35a, // c0x00ce (n0x135a-n0x135b)  +
	0x24d7135b, // c0x00cf (n0x135b-n0x135c)  o
	0x04d7535c, // c0x00d0 (n0x135c-n0x135d)  +
	0x24d7935d, // c0x00d1 (n0x135d-n0x135e)  o
	0x04d7d35e, // c0x00d2 (n0x135e-n0x135f)  +
	0x24d8935f, // c0x00d3 (n0x135f-n0x1362)  o
	0x04d8d362, // c0x00d4 (n0x1362-n0x1363)  +
	0x04d91363, // c0x00d5 (n0x1363-n0x1364)  +
	0x24d95364, // c0x00d6 (n0x1364-n0x1365)  o
	0x04d99365, // c0x00d7 (n0x1365-n0x1366)  +
	0x24da1366, // c0x00d8 (n0x1366-n0x1368)  o
	0x04da5368, // c0x00d9 (n0x1368-n0x1369)  +
	0x04da9369, // c0x00da (n0x1369-n0x136a)  +
	0x24db936a, // c0x00db (n0x136a-n0x136e)  o
	0x04dbd36e, // c0x00dc (n0x136e-n0x136f)  +
	0x04dc136f, // c0x00dd (n0x136f-n0x1370)  +
	0x04dc5370, // c0x00de (n0x1370-n0x1371)  +
	0x04dc9371, // c0x00df (n0x1371-n0x1372)  +
	0x24dcd372, // c0x00e0 (n0x1372-n0x1373)  o
	0x04dd1373, // c0x00e1 (n0x1373-n0x1374)  +
	0x04dd5374, // c0x00e2 (n0x1374-n0x1375)  +
	0x04dd9375, // c0x00e3 (n0x1375-n0x1376)  +
	0x04ddd376, // c0x00e4 (n0x1376-n0x1377)  +
	0x24de5377, // c0x00e5 (n0x1377-n0x1379)  o
	0x04de9379, // c0x00e6 (n0x1379-n0x137a)  +
	0x04ded37a, // c0x00e7 (n0x137a-n0x137b)  +
	0x04df137b, // c0x00e8 (n0x137b-n0x137c)  +
	0x24df537c, // c0x00e9 (n0x137c-n0x137d)  o
	0x04df937d, // c0x00ea (n0x137d-n0x137e)  +
	0x24e0137e, // c0x00eb (n0x137e-n0x1380)  o
	0x24e05380, // c0x00ec (n0x1380-n0x1381)  o
	0x04e21381, // c0x00ed (n0x1381-n0x1388)  +
	0x04e2d388, // c0x00ee (n0x1388-n0x138b)  +
	0x64e3138b, // c0x00ef (n0x138b-n0x138c)* o
	0x24e3538c, // c0x00f0 (n0x138c-n0x138d)  o
	0x64e5d38d, // c0x00f1 (n0x138d-n0x1397)* o
	0x04f31397, // c0x00f2 (n0x1397-n0x13cc)  +
	0x04f393cc, // c0x00f3 (n0x13cc-n0x13ce)  +
	0x04f653ce, // c0x00f4 (n0x13ce-n0x13d9)  +
	0x04f813d9, // c0x00f5 (n0x13d9-n0x13e0)  +
	0x04f8d3e0, // c0x00f6 (n0x13e0-n0x13e3)  +
	0x04fad3e3, // c0x00f7 (n0x13e3-n0x13eb)  +
	0x04fe53eb, // c0x00f8 (n0x13eb-n0x13f9)  +
	0x052913f9, // c0x00f9 (n0x13f9-n0x14a4)  +
	0x052b54a4, // c0x00fa (n0x14a4-n0x14ad)  +
	0x052c94ad, // c0x00fb (n0x14ad-n0x14b2)  +
	0x052fd4b2, // c0x00fc (n0x14b2-n0x14bf)  +
	0x053194bf, // c0x00fd (n0x14bf-n0x14c6)  +
	0x053354c6, // c0x00fe (n0x14c6-n0x14cd)  +
	0x053594cd, // c0x00ff (n0x14cd-n0x14d6)  +
	0x053714d6, // c0x0100 (n0x14d6-n0x14dc)  +
	0x0538d4dc, // c0x0101 (n0x14dc-n0x14e3)  +
	0x053ad4e3, // c0x0102 (n0x14e3-n0x14eb)  +
	0x053bd4eb, // c0x0103 (n0x14eb-n0x14ef)  +
	0x053ed4ef, // c0x0104 (n0x14ef-n0x14fb)  +
	0x054054fb, // c0x0105 (n0x14fb-n0x1501)  +
	0x05619501, // c0x0106 (n0x1501-n0x1586)  +
	0x0563d586, // c0x0107 (n0x1586-n0x158f)  +
	0x0565d58f, // c0x0108 (n0x158f-n0x1597)  +
	0x05671597, // c0x0109 (n0x1597-n0x159c)  +
	0x0568559c, // c0x010a (n0x159c-n0x15a1)  +
	0x056a55a1, // c0x010b (n0x15a1-n0x15a9)  +
	0x057495a9, // c0x010c (n0x15a9-n0x15d2)  +
	0x057655d2, // c0x010d (n0x15d2-n0x15d9)  +
	0x057795d9, // c0x010e (n0x15d9-n0x15de)  +
	0x0577d5de, // c0x010f (n0x15de-n0x15df)  +
	0x057915df, // c0x0110 (n0x15df-n0x15e4)  +
	0x057ad5e4, // c0x0111 (n0x15e4-n0x15eb)  +
	0x057b95eb, // c0x0112 (n0x15eb-n0x15ee)  +
	0x057e95ee, // c0x0113 (n0x15ee-n0x15fa)  +
	0x057ed5fa, // c0x0114 (n0x15fa-n0x15fb)  +
	0x058055fb, // c0x0115 (n0x15fb-n0x1601)  +
	0x05811601, // c0x0116 (n0x1601-n0x1604)  +
	0x05815604, // c0x0117 (n0x1604-n0x1605)  +
	0x05831605, // c0x0118 (n0x1605-n0x160c)  +
	0x0586d60c, // c0x0119 (n0x160c-n0x161b)  +
	0x0587161b, // c0x011a (n0x161b-n0x161c)  +
	0x0589161c, // c0x011b (n0x161c-n0x1624)  +
	0x058e1624, // c0x011c (n0x1624-n0x1638)  +
	0x058f9638, // c0x011d (n0x1638-n0x163e)  +
	0x6590163e, // c0x011e (n0x163e-n0x1640)* o
	0x25905640, // c0x011f (n0x1640-n0x1641)  o
	0x05949641, // c0x0120 (n0x1641-n0x1652)  +
	0x05959652, // c0x0121 (n0x1652-n0x1656)  +
	0x05991656, // c0x0122 (n0x1656-n0x1664)  +
	0x259c1664, // c0x0123 (n0x1664-n0x1670)  o
	0x05af9670, // c0x0124 (n0x1670-n0x16be)  +
	0x05b196be, // c0x0125 (n0x16be-n0x16c6)  +
	0x65b456c6, // c0x0126 (n0x16c6-n0x16d1)* o
	0x25b496d1, // c0x0127 (n0x16d1-n0x16d2)  o
	0x05c456d2, // c0x0128 (n0x16d2-n0x1711)  +
	0x05c51711, // c0x0129 (n0x1711-n0x1714)  +
	0x05c5d714, // c0x012a (n0x1714-n0x1717)  +
	0x05c69717, // c0x012b (n0x1717-n0x171a)  +
	0x05c7571a, // c0x012c (n0x171a-n0x171d)  +
	0x05c8171d, // c0x012d (n0x171d-n0x1720)  +
	0x05c8d720, // c0x012e (n0x1720-n0x1723)  +
	0x05c99723, // c0x012f (n0x1723-n0x1726)  +
	0x05ca5726, // c0x0130 (n0x1726-n0x1729)  +
	0x05cb1729, // c0x0131 (n0x1729-n0x172c)  +
	0x05cbd72c, // c0x0132 (n0x172c-n0x172f)  +
	0x05cc972f, // c0x0133 (n0x172f-n0x1732)  +
	0x05cd5732, // c0x0134 (n0x1732-n0x1735)  +
	0x05ce1735, // c0x0135 (n0x1735-n0x1738)  +
	0x05ce9738, // c0x0136 (n0x1738-n0x173a)  +
	0x05cf573a, // c0x0137 (n0x173a-n0x173d)  +
	0x05d0173d, // c0x0138 (n0x173d-n0x1740)  +
	0x05d0d740, // c0x0139 (n0x1740-n0x1743)  +
	0x05d19743, // c0x013a (n0x1743-n0x1746)  +
	0x05d25746, // c0x013b (n0x1746-n0x1749)  +
	0x05d31749, // c0x013c (n0x1749-n0x174c)  +
	0x05d3d74c, // c0x013d (n0x174c-n0x174f)  +
	0x05d4974f, // c0x013e (n0x174f-n0x1752)  +
	0x05d55752, // c0x013f (n0x1752-n0x1755)  +
	0x05d61755, // c0x0140 (n0x1755-n0x1758)  +
	0x05d6d758, // c0x0141 (n0x1758-n0x175b)  +
	0x05d7975b, // c0x0142 (n0x175b-n0x175e)  +
	0x05d8575e, // c0x0143 (n0x175e-n0x1761)  +
	0x05d91761, // c0x0144 (n0x1761-n0x1764)  +
	0x05d9d764, // c0x0145 (n0x1764-n0x1767)  +
	0x05da9767, // c0x0146 (n0x1767-n0x176a)  +
	0x05db576a, // c0x0147 (n0x176a-n0x176d)  +
	0x05dc176d, // c0x0148 (n0x176d-n0x1770)  +
	0x05dcd770, // c0x0149 (n0x1770-n0x1773)  +
	0x05dd9773, // c0x014a (n0x1773-n0x1776)  +
	0x05de5776, // c0x014b (n0x1776-n0x1779)  +
	0x05df1779, // c0x014c (n0x1779-n0x177c)  +
	0x05dfd77c, // c0x014d (n0x177c-n0x177f)  +
	0x05e0977f, // c0x014e (n0x177f-n0x1782)  +
	0x05e15782, // c0x014f (n0x1782-n0x1785)  +
	0x05e21785, // c0x0150 (n0x1785-n0x1788)  +
	0x05e2d788, // c0x0151 (n0x1788-n0x178b)  +
	0x05e3978b, // c0x0152 (n0x178b-n0x178e)  +
	0x05e4578e, // c0x0153 (n0x178e-n0x1791)  +
	0x05e51791, // c0x0154 (n0x1791-n0x1794)  +
	0x05e5d794, // c0x0155 (n0x1794-n0x1797)  +
	0x05e69797, // c0x0156 (n0x1797-n0x179a)  +
	0x05e7579a, // c0x0157 (n0x179a-n0x179d)  +
	0x05e8179d, // c0x0158 (n0x179d-n0x17a0)  +
	0x05e8d7a0, // c0x0159 (n0x17a0-n0x17a3)  +
	0x05e997a3, // c0x015a (n0x17a3-n0x17a6)  +
	0x05ea57a6, // c0x015b (n0x17a6-n0x17a9)  +
	0x05eb17a9, // c0x015c (n0x17a9-n0x17ac)  +
	0x05ebd7ac, // c0x015d (n0x17ac-n0x17af)  +
	0x05ec97af, // c0x015e (n0x17af-n0x17b2)  +
	0x05ed57b2, // c0x015f (n0x17b2-n0x17b5)  +
	0x05ee17b5, // c0x0160 (n0x17b5-n0x17b8)  +
	0x05ef97b8, // c0x0161 (n0x17b8-n0x17be)  +
	0x05f097be, // c0x0162 (n0x17be-n0x17c2)  +
	0x05f217c2, // c0x0163 (n0x17c2-n0x17c8)  +
	0x05f497c8, // c0x0164 (n0x17c8-n0x17d2)  +
	0x05f5d7d2, // c0x0165 (n0x17d2-n0x17d7)  +
	0x05f8d7d7, // c0x0166 (n0x17d7-n0x17e3)  +
	0x05fa97e3, // c0x0167 (n0x17e3-n0x17ea)  +
}
