page_title: Remote API Client Libraries
page_description: Various client libraries available to use with the Docker remote API
page_keywords: API, Docker, index, registry, REST, documentation, clients, Python, Ruby, JavaScript, Erlang, Go

# Docker Remote API Client Libraries

These libraries have not been tested by the Docker Maintainers for
compatibility. Please file issues with the library owners. If you find
more library implementations, please list them in Docker doc bugs and we
will add the libraries here.

<table border="1" class="docutils">
  <colgroup>
    <col width="24%">
    <col width="17%">
    <col width="48%">
    <col width="11%">
  </colgroup>
  <thead valign="bottom">
    <tr class="row-odd"><th class="head">Language/Framework</th>
      <th class="head">Name</th>
      <th class="head">Repository</th>
      <th class="head">Status</th>
    </tr>
  </thead>
  <tbody valign = "top">
    <tr class="row-even">
      <td>Python</td>
      <td>docker-py</td>
      <td><a class="reference external" href="https://github.com/dotcloud/docker-py">https://github.com/dotcloud/docker-py</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>Ruby</td>
      <td>docker-client</td>
      <td><a class="reference external" href="https://github.com/geku/docker-client">https://github.com/geku/docker-client</a></td>
      <td>Outdated</td>
    </tr>
    <tr class="row-even">
      <td>Ruby</td>
      <td>docker-api</td>
      <td><a class="reference external" href="https://github.com/swipely/docker-api">https://github.com/swipely/docker-api</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>JavaScript (NodeJS)</td>
      <td>dockerode</td>
      <td><a class="reference external" href="https://github.com/apocas/dockerode">https://github.com/apocas/dockerode</a>
  Install via NPM: <cite>npm install dockerode</cite></td>
      <td>Active</td>
    </tr>
    <tr class="row-even">
      <td>JavaScript (NodeJS)</td>
      <td>docker.io</td>
      <td><a class="reference external" href="https://github.com/appersonlabs/docker.io">https://github.com/appersonlabs/docker.io</a>
  Install via NPM: <cite>npm install docker.io</cite></td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>JavaScript</td>
      <td>docker-js</td>
      <td><a class="reference external" href="https://github.com/dgoujard/docker-js">https://github.com/dgoujard/docker-js</a></td>
      <td>Outdated</td>
    </tr>
    <tr class="row-even">
      <td>JavaScript (Angular) <strong>WebUI</strong></td>
      <td>docker-cp</td>
      <td><a class="reference external" href="https://github.com/13W/docker-cp">https://github.com/13W/docker-cp</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>JavaScript (Angular) <strong>WebUI</strong></td>
      <td>dockerui</td>
      <td><a class="reference external" href="https://github.com/crosbymichael/dockerui">https://github.com/crosbymichael/dockerui</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-even">
      <td>Java</td>
      <td>docker-java</td>
      <td><a class="reference external" href="https://github.com/kpelykh/docker-java">https://github.com/kpelykh/docker-java</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>Erlang</td>
      <td>erldocker</td>
      <td><a class="reference external" href="https://github.com/proger/erldocker">https://github.com/proger/erldocker</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-even">
      <td>Go</td>
      <td>go-dockerclient</td>
      <td><a class="reference external" href="https://github.com/fsouza/go-dockerclient">https://github.com/fsouza/go-dockerclient</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>Go</td>
      <td>dockerclient</td>
      <td><a class="reference external" href="https://github.com/samalba/dockerclient">https://github.com/samalba/dockerclient</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-even">
      <td>PHP</td>
      <td>Alvine</td>
      <td><a class="reference external" href="http://pear.alvine.io/">http://pear.alvine.io/</a> (alpha)</td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>PHP</td>
      <td>Docker-PHP</td>
      <td><a class="reference external" href="http://stage1.github.io/docker-php/">http://stage1.github.io/docker-php/</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-even">
      <td>Perl</td>
      <td>Net::Docker</td>
      <td><a class="reference external" href="https://metacpan.org/pod/Net::Docker">https://metacpan.org/pod/Net::Docker</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>Perl</td>
      <td>Eixo::Docker</td>
      <td><a class="reference external" href="https://github.com/alambike/eixo-docker">https://github.com/alambike/eixo-docker</a></td>
      <td>Active</td>
    </tr>
    <tr class="row-odd">
      <td>Scala</td>
      <td>reactive-docker</td>
      <td><a class="reference external" href="https://github.com/almoehi/reactive-docker">https://github.com/almoehi/reactive-docker</a></td>
      <td>Active</td>
    </tr>
  </tbody>
</table>
