// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/consumer.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Supported data type of the property values
type Property_PropertyType int32

const (
	// The type is unspecified, and will result in an error.
	Property_UNSPECIFIED Property_PropertyType = 0
	// The type is `int64`.
	Property_INT64 Property_PropertyType = 1
	// The type is `bool`.
	Property_BOOL Property_PropertyType = 2
	// The type is `string`.
	Property_STRING Property_PropertyType = 3
	// The type is 'double'.
	Property_DOUBLE Property_PropertyType = 4
)

var Property_PropertyType_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "INT64",
	2: "BOOL",
	3: "STRING",
	4: "DOUBLE",
}
var Property_PropertyType_value = map[string]int32{
	"UNSPECIFIED": 0,
	"INT64":       1,
	"BOOL":        2,
	"STRING":      3,
	"DOUBLE":      4,
}

func (x Property_PropertyType) String() string {
	return proto.EnumName(Property_PropertyType_name, int32(x))
}
func (Property_PropertyType) EnumDescriptor() ([]byte, []int) { return fileDescriptor4, []int{1, 0} }

// A descriptor for defining project properties for a service. One service may
// have many consumer projects, and the service may want to behave differently
// depending on some properties on the project. For example, a project may be
// associated with a school, or a business, or a government agency, a business
// type property on the project may affect how a service responds to the client.
// This descriptor defines which properties are allowed to be set on a project.
//
// Example:
//
//    project_properties:
//      properties:
//      - name: NO_WATERMARK
//        type: BOOL
//        description: Allows usage of the API without watermarks.
//      - name: EXTENDED_TILE_CACHE_PERIOD
//        type: INT64
type ProjectProperties struct {
	// List of per consumer project-specific properties.
	Properties []*Property `protobuf:"bytes,1,rep,name=properties" json:"properties,omitempty"`
}

func (m *ProjectProperties) Reset()                    { *m = ProjectProperties{} }
func (m *ProjectProperties) String() string            { return proto.CompactTextString(m) }
func (*ProjectProperties) ProtoMessage()               {}
func (*ProjectProperties) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{0} }

func (m *ProjectProperties) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Defines project properties.
//
// API services can define properties that can be assigned to consumer projects
// so that backends can perform response customization without having to make
// additional calls or maintain additional storage. For example, Maps API
// defines properties that controls map tile cache period, or whether to embed a
// watermark in a result.
//
// These values can be set via API producer console. Only API providers can
// define and set these properties.
type Property struct {
	// The name of the property (a.k.a key).
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The type of this property.
	Type Property_PropertyType `protobuf:"varint,2,opt,name=type,enum=google.api.Property_PropertyType" json:"type,omitempty"`
	// The description of the property
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
}

func (m *Property) Reset()                    { *m = Property{} }
func (m *Property) String() string            { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()               {}
func (*Property) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{1} }

func init() {
	proto.RegisterType((*ProjectProperties)(nil), "google.api.ProjectProperties")
	proto.RegisterType((*Property)(nil), "google.api.Property")
	proto.RegisterEnum("google.api.Property_PropertyType", Property_PropertyType_name, Property_PropertyType_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/consumer.proto", fileDescriptor4)
}

var fileDescriptor4 = []byte{
	// 287 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x6c, 0x90, 0xc1, 0x4e, 0xb3, 0x40,
	0x14, 0x85, 0x7f, 0x0a, 0x7f, 0xd3, 0x5e, 0xb4, 0xe2, 0xc4, 0x05, 0xcb, 0x96, 0x55, 0x57, 0x90,
	0xd4, 0xea, 0x03, 0xd0, 0x52, 0x43, 0x42, 0x80, 0x50, 0xfa, 0x00, 0x88, 0xd7, 0xc9, 0x98, 0xc2,
	0x4c, 0x06, 0x34, 0xe9, 0x03, 0xfa, 0x5e, 0x4e, 0x11, 0x2b, 0x0b, 0x37, 0xdc, 0xc3, 0xbd, 0xdf,
	0x39, 0x99, 0x1c, 0xd8, 0x51, 0xce, 0xe9, 0x11, 0x5d, 0xca, 0x8f, 0x45, 0x4d, 0x5d, 0x2e, 0xa9,
	0x47, 0xb1, 0x16, 0x92, 0xb7, 0xdc, 0xfb, 0x3e, 0x15, 0x82, 0x35, 0x9e, 0xfa, 0x78, 0x0d, 0xca,
	0x0f, 0x56, 0x62, 0xc9, 0xeb, 0x57, 0x46, 0x3d, 0x35, 0x9a, 0xf7, 0x0a, 0xa5, 0xdb, 0xb1, 0x04,
	0xfa, 0x1c, 0x05, 0x3a, 0x21, 0xdc, 0xa6, 0x92, 0xbf, 0x61, 0xd9, 0xaa, 0x21, 0x50, 0xb6, 0x0c,
	0x1b, 0xb2, 0x06, 0x10, 0x97, 0x3f, 0x5b, 0x9b, 0xeb, 0x4b, 0x73, 0x75, 0xe7, 0xfe, 0xba, 0xdc,
	0x9e, 0x3d, 0x65, 0x03, 0xce, 0xf9, 0xd4, 0x60, 0xf2, 0x73, 0x20, 0x04, 0x8c, 0xba, 0xa8, 0x50,
	0x99, 0xb5, 0xe5, 0x34, 0xeb, 0x34, 0x79, 0x00, 0xa3, 0x3d, 0x09, 0xb4, 0x47, 0x6a, 0x37, 0x5b,
	0x2d, 0xfe, 0x0a, 0xbc, 0x88, 0x5c, 0x81, 0x59, 0x87, 0x93, 0x39, 0x98, 0x2f, 0xd8, 0x94, 0x92,
	0x89, 0x96, 0xf1, 0xda, 0xd6, 0xbb, 0xc4, 0xe1, 0xca, 0x89, 0xe0, 0x6a, 0xe8, 0x23, 0x37, 0x60,
	0x1e, 0xe2, 0x7d, 0x1a, 0x6c, 0xc2, 0x5d, 0x18, 0x6c, 0xad, 0x7f, 0x64, 0x0a, 0xff, 0xc3, 0x38,
	0x7f, 0x5c, 0x5b, 0x1a, 0x99, 0x80, 0xe1, 0x27, 0x49, 0x64, 0x8d, 0x08, 0xc0, 0x78, 0x9f, 0x67,
	0x61, 0xfc, 0x64, 0xe9, 0x67, 0xbd, 0x4d, 0x0e, 0x7e, 0x14, 0x58, 0x86, 0xbf, 0x80, 0x59, 0xc9,
	0xab, 0xc1, 0xeb, 0xfc, 0xeb, 0x4d, 0x5f, 0x60, 0x7a, 0xee, 0x2f, 0xd5, 0x9e, 0xc7, 0x5d, 0x91,
	0xf7, 0x5f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x61, 0xba, 0x74, 0x16, 0x92, 0x01, 0x00, 0x00,
}
