% DOCKER(1) Docker User Manuals
% Docker Community
% JUNE 2014
# NAME
docker-build - Build a new image from the source code at PATH

# SYNOPSIS
**docker build**
[**--help**]
[**-f**|**--file**[=*Dockerfile*]]
[**--force-rm**[=*false*]]
[**--no-cache**[=*false*]]
[**--pull**[=*false*]]
[**-q**|**--quiet**[=*false*]]
[**--rm**[=*true*]]
[**-t**|**--tag**[=*TAG*]]
PATH | URL | -

# DESCRIPTION
This will read the Dockerfile from the directory specified in **PATH**.
It also sends any other files and directories found in the current
directory to the Docker daemon. The contents of this directory would
be used by **ADD** commands found within the Dockerfile.

Warning, this will send a lot of data to the Docker daemon depending
on the contents of the current directory. The build is run by the Docker 
daemon, not by the CLI, so the whole context must be transferred to the daemon. 
The Docker CLI reports "Sending build context to Docker daemon" when the context is sent to 
the daemon.

When a single Dockerfile is given as the URL, then no context is set.
When a Git repository is set as the **URL**, the repository is used
as context.

# OPTIONS
**-f**, **--file**=*Dockerfile*
   Path to the Dockerfile to use. If the path is a relative path then it must be relative to the current directory. The file must be within the build context. The default is *Dockerfile*.

**--force-rm**=*true*|*false*
   Always remove intermediate containers, even after unsuccessful builds. The default is *false*.

**--no-cache**=*true*|*false*
   Do not use cache when building the image. The default is *false*.

**--help**
  Print usage statement

**--pull**=*true*|*false*
   Always attempt to pull a newer version of the image. The default is *false*.

**-q**, **--quiet**=*true*|*false*
   Suppress the verbose output generated by the containers. The default is *false*.

**--rm**=*true*|*false*
   Remove intermediate containers after a successful build. The default is *true*.

**-t**, **--tag**=""
   Repository name (and optionally a tag) to be applied to the resulting image in case of success

# EXAMPLES

## Building an image using a Dockerfile located inside the current directory

Docker images can be built using the build command and a Dockerfile:

    docker build .

During the build process Docker creates intermediate images. In order to
keep them, you must explicitly set `--rm=false`.

    docker build --rm=false .

A good practice is to make a sub-directory with a related name and create
the Dockerfile in that directory. For example, a directory called mongo may
contain a Dockerfile to create a Docker MongoDB image. Likewise, another
directory called httpd may be used to store Dockerfiles for Apache web
server images.

It is also a good practice to add the files required for the image to the
sub-directory. These files will then be specified with the `COPY` or `ADD`
instructions in the `Dockerfile`.

Note: If you include a tar file (a good practice), then Docker will
automatically extract the contents of the tar file specified within the `ADD`
instruction into the specified target.

## Building an image and naming that image

A good practice is to give a name to the image you are building. There are
no hard rules here but it is best to give the names consideration. 

The **-t**/**--tag** flag is used to rename an image. Here are some examples:

Though it is not a good practice, image names can be arbitrary:

    docker build -t myimage .

A better approach is to provide a fully qualified and meaningful repository,
name, and tag (where the tag in this context means the qualifier after 
the ":"). In this example we build a JBoss image for the Fedora repository 
and give it the version 1.0:

    docker build -t fedora/jboss:1.0

The next example is for the "whenry" user repository and uses Fedora and
JBoss and gives it the version 2.1 :

    docker build -t whenry/fedora-jboss:V2.1

If you do not provide a version tag then Docker will assign `latest`:

    docker build -t whenry/fedora-jboss

When you list the images, the image above will have the tag `latest`.

So renaming an image is arbitrary but consideration should be given to 
a useful convention that makes sense for consumers and should also take
into account Docker community conventions.


## Building an image using a URL

This will clone the specified Github repository from the URL and use it
as context. The Dockerfile at the root of the repository is used as
Dockerfile. This only works if the Github repository is a dedicated
repository.

    docker build github.com/scollier/Fedora-Dockerfiles/tree/master/apache

Note: You can set an arbitrary Git repository via the `git://` schema.

# HISTORY
March 2014, Originally compiled by William Henry (whenry at redhat dot com)
based on docker.com source material and internal work.
June 2014, updated by Sven Dowideit <SvenDowideit@home.org.au>
