// Code generated by protoc-gen-gogo.
// source: dispatcher.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/docker/swarmkit/protobuf/plugin"
import docker_swarmkit_v11 "github.com/docker/swarmkit/api/duration"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftselector "github.com/docker/swarmkit/manager/raftselector"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"
import time "time"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type AssignmentChange_AssignmentAction int32

const (
	AssignmentChange_AssignmentActionUpdate AssignmentChange_AssignmentAction = 0
	AssignmentChange_AssignmentActionRemove AssignmentChange_AssignmentAction = 1
)

var AssignmentChange_AssignmentAction_name = map[int32]string{
	0: "UPDATE",
	1: "REMOVE",
}
var AssignmentChange_AssignmentAction_value = map[string]int32{
	"UPDATE": 0,
	"REMOVE": 1,
}

func (x AssignmentChange_AssignmentAction) String() string {
	return proto.EnumName(AssignmentChange_AssignmentAction_name, int32(x))
}
func (AssignmentChange_AssignmentAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{10, 0}
}

// AssignmentType specifies whether this assignment message carries
// the full state, or is an update to an existing state.
type AssignmentsMessage_Type int32

const (
	AssignmentsMessage_COMPLETE    AssignmentsMessage_Type = 0
	AssignmentsMessage_INCREMENTAL AssignmentsMessage_Type = 1
)

var AssignmentsMessage_Type_name = map[int32]string{
	0: "COMPLETE",
	1: "INCREMENTAL",
}
var AssignmentsMessage_Type_value = map[string]int32{
	"COMPLETE":    0,
	"INCREMENTAL": 1,
}

func (x AssignmentsMessage_Type) String() string {
	return proto.EnumName(AssignmentsMessage_Type_name, int32(x))
}
func (AssignmentsMessage_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{11, 0}
}

// SessionRequest starts a session.
type SessionRequest struct {
	Description *NodeDescription `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// SessionID can be provided to attempt resuming an exising session. If the
	// SessionID is empty or invalid, a new SessionID will be assigned.
	//
	// See SessionMessage.SessionID for details.
	SessionID string `protobuf:"bytes,2,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *SessionRequest) Reset()                    { *m = SessionRequest{} }
func (*SessionRequest) ProtoMessage()               {}
func (*SessionRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{0} }

// SessionMessage instructs an agent on various actions as part of the current
// session. An agent should act immediately on the contents.
type SessionMessage struct {
	// SessionID is allocated after a successful registration. It should be
	// used on all RPC calls after registration. A dispatcher may choose to
	// change the SessionID, at which time an agent must re-register and obtain
	// a new one.
	//
	// All Dispatcher calls after register should include the SessionID. If the
	// Dispatcher so chooses, it may reject the call with an InvalidArgument
	// error code, at which time the agent should call Register to start a new
	// session.
	//
	// As a rule, once an agent has a SessionID, it should never save it to
	// disk or try to otherwise reuse. If the agent loses its SessionID, it
	// must start a new session through a call to Register. A Dispatcher may
	// choose to reuse the SessionID, if it sees fit, but it is not advised.
	//
	// The actual implementation of the SessionID is Dispatcher specific and
	// should be treated as opaque by agents.
	//
	// From a Dispatcher perspective, there are many ways to use the SessionID
	// to ensure uniqueness of a set of client RPC calls. One method is to keep
	// the SessionID unique to every call to Register in a single Dispatcher
	// instance. This ensures that the SessionID represents the unique
	// session from a single Agent to Manager. If the Agent restarts, we
	// allocate a new session, since the restarted Agent is not aware of the
	// new SessionID.
	//
	// The most compelling use case is to support duplicate node detection. If
	// one clones a virtual machine, including certificate material, two nodes
	// may end up with the same identity. This can also happen if two identical
	// agent processes are coming from the same node. If the SessionID is
	// replicated through the cluster, we can immediately detect the condition
	// and address it.
	//
	// Extending from the case above, we can actually detect a compromised
	// identity. Coupled with provisions to rebuild node identity, we can ban
	// the compromised node identity and have the nodes re-authenticate and
	// build a new identity. At this time, an administrator can then
	// re-authorize the compromised nodes, if it was a mistake or ensure that a
	// misbehaved node can no longer connect to the cluster.
	//
	// We considered placing this field in a GRPC header. Because this is a
	// critical feature of the protocol, we thought it should be represented
	// directly in the RPC message set.
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// Node identifies the registering node.
	Node *Node `protobuf:"bytes,2,opt,name=node" json:"node,omitempty"`
	// Managers provides a weight list of alternative dispatchers
	Managers []*WeightedPeer `protobuf:"bytes,3,rep,name=managers" json:"managers,omitempty"`
	// Symmetric encryption key distributed by the lead manager. Used by agents
	// for securing network bootstrapping and communication.
	NetworkBootstrapKeys []*EncryptionKey `protobuf:"bytes,4,rep,name=network_bootstrap_keys,json=networkBootstrapKeys" json:"network_bootstrap_keys,omitempty"`
}

func (m *SessionMessage) Reset()                    { *m = SessionMessage{} }
func (*SessionMessage) ProtoMessage()               {}
func (*SessionMessage) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{1} }

// HeartbeatRequest provides identifying properties for a single heartbeat.
type HeartbeatRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *HeartbeatRequest) Reset()                    { *m = HeartbeatRequest{} }
func (*HeartbeatRequest) ProtoMessage()               {}
func (*HeartbeatRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{2} }

type HeartbeatResponse struct {
	// Period is the duration to wait before sending the next heartbeat.
	// Well-behaved agents should update this on every heartbeat round trip.
	Period docker_swarmkit_v11.Duration `protobuf:"bytes,1,opt,name=period" json:"period"`
}

func (m *HeartbeatResponse) Reset()                    { *m = HeartbeatResponse{} }
func (*HeartbeatResponse) ProtoMessage()               {}
func (*HeartbeatResponse) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{3} }

type UpdateTaskStatusRequest struct {
	// Tasks should contain all statuses for running tasks. Only the status
	// field must be set. The spec is not required.
	SessionID string                                      `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	Updates   []*UpdateTaskStatusRequest_TaskStatusUpdate `protobuf:"bytes,3,rep,name=updates" json:"updates,omitempty"`
}

func (m *UpdateTaskStatusRequest) Reset()      { *m = UpdateTaskStatusRequest{} }
func (*UpdateTaskStatusRequest) ProtoMessage() {}
func (*UpdateTaskStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{4}
}

type UpdateTaskStatusRequest_TaskStatusUpdate struct {
	TaskID string      `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	Status *TaskStatus `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Reset() {
	*m = UpdateTaskStatusRequest_TaskStatusUpdate{}
}
func (*UpdateTaskStatusRequest_TaskStatusUpdate) ProtoMessage() {}
func (*UpdateTaskStatusRequest_TaskStatusUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{4, 0}
}

type UpdateTaskStatusResponse struct {
}

func (m *UpdateTaskStatusResponse) Reset()      { *m = UpdateTaskStatusResponse{} }
func (*UpdateTaskStatusResponse) ProtoMessage() {}
func (*UpdateTaskStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{5}
}

type TasksRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *TasksRequest) Reset()                    { *m = TasksRequest{} }
func (*TasksRequest) ProtoMessage()               {}
func (*TasksRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{6} }

type TasksMessage struct {
	// Tasks is the set of tasks that should be running on the node.
	// Tasks outside of this set running on the node should be terminated.
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks" json:"tasks,omitempty"`
}

func (m *TasksMessage) Reset()                    { *m = TasksMessage{} }
func (*TasksMessage) ProtoMessage()               {}
func (*TasksMessage) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{7} }

type AssignmentsRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *AssignmentsRequest) Reset()                    { *m = AssignmentsRequest{} }
func (*AssignmentsRequest) ProtoMessage()               {}
func (*AssignmentsRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{8} }

type Assignment struct {
	// Types that are valid to be assigned to Item:
	//	*Assignment_Task
	//	*Assignment_Secret
	Item isAssignment_Item `protobuf_oneof:"item"`
}

func (m *Assignment) Reset()                    { *m = Assignment{} }
func (*Assignment) ProtoMessage()               {}
func (*Assignment) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{9} }

type isAssignment_Item interface {
	isAssignment_Item()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Assignment_Task struct {
	Task *Task `protobuf:"bytes,1,opt,name=task,oneof"`
}
type Assignment_Secret struct {
	Secret *Secret `protobuf:"bytes,2,opt,name=secret,oneof"`
}

func (*Assignment_Task) isAssignment_Item()   {}
func (*Assignment_Secret) isAssignment_Item() {}

func (m *Assignment) GetItem() isAssignment_Item {
	if m != nil {
		return m.Item
	}
	return nil
}

func (m *Assignment) GetTask() *Task {
	if x, ok := m.GetItem().(*Assignment_Task); ok {
		return x.Task
	}
	return nil
}

func (m *Assignment) GetSecret() *Secret {
	if x, ok := m.GetItem().(*Assignment_Secret); ok {
		return x.Secret
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Assignment) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Assignment_OneofMarshaler, _Assignment_OneofUnmarshaler, _Assignment_OneofSizer, []interface{}{
		(*Assignment_Task)(nil),
		(*Assignment_Secret)(nil),
	}
}

func _Assignment_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Assignment)
	// item
	switch x := m.Item.(type) {
	case *Assignment_Task:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Task); err != nil {
			return err
		}
	case *Assignment_Secret:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Secret); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Assignment.Item has unexpected type %T", x)
	}
	return nil
}

func _Assignment_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Assignment)
	switch tag {
	case 1: // item.task
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Task)
		err := b.DecodeMessage(msg)
		m.Item = &Assignment_Task{msg}
		return true, err
	case 2: // item.secret
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Secret)
		err := b.DecodeMessage(msg)
		m.Item = &Assignment_Secret{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Assignment_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Assignment)
	// item
	switch x := m.Item.(type) {
	case *Assignment_Task:
		s := proto.Size(x.Task)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Assignment_Secret:
		s := proto.Size(x.Secret)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type AssignmentChange struct {
	Assignment *Assignment                       `protobuf:"bytes,1,opt,name=assignment" json:"assignment,omitempty"`
	Action     AssignmentChange_AssignmentAction `protobuf:"varint,2,opt,name=action,proto3,enum=docker.swarmkit.v1.AssignmentChange_AssignmentAction" json:"action,omitempty"`
}

func (m *AssignmentChange) Reset()                    { *m = AssignmentChange{} }
func (*AssignmentChange) ProtoMessage()               {}
func (*AssignmentChange) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{10} }

type AssignmentsMessage struct {
	Type AssignmentsMessage_Type `protobuf:"varint,1,opt,name=type,proto3,enum=docker.swarmkit.v1.AssignmentsMessage_Type" json:"type,omitempty"`
	// AppliesTo references the previous ResultsIn value, to chain
	// incremental updates together. For the first update in a stream,
	// AppliesTo is empty.  If AppliesTo does not match the previously
	// received ResultsIn, the consumer of the stream should start a new
	// Assignments stream to re-sync.
	AppliesTo string `protobuf:"bytes,2,opt,name=applies_to,json=appliesTo,proto3" json:"applies_to,omitempty"`
	// ResultsIn identifies the result of this assignments message, to
	// match against the next message's AppliesTo value and protect
	// against missed messages.
	ResultsIn string `protobuf:"bytes,3,opt,name=results_in,json=resultsIn,proto3" json:"results_in,omitempty"`
	// AssignmentChange is a set of changes to apply on this node.
	Changes []*AssignmentChange `protobuf:"bytes,4,rep,name=changes" json:"changes,omitempty"`
}

func (m *AssignmentsMessage) Reset()                    { *m = AssignmentsMessage{} }
func (*AssignmentsMessage) ProtoMessage()               {}
func (*AssignmentsMessage) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{11} }

func init() {
	proto.RegisterType((*SessionRequest)(nil), "docker.swarmkit.v1.SessionRequest")
	proto.RegisterType((*SessionMessage)(nil), "docker.swarmkit.v1.SessionMessage")
	proto.RegisterType((*HeartbeatRequest)(nil), "docker.swarmkit.v1.HeartbeatRequest")
	proto.RegisterType((*HeartbeatResponse)(nil), "docker.swarmkit.v1.HeartbeatResponse")
	proto.RegisterType((*UpdateTaskStatusRequest)(nil), "docker.swarmkit.v1.UpdateTaskStatusRequest")
	proto.RegisterType((*UpdateTaskStatusRequest_TaskStatusUpdate)(nil), "docker.swarmkit.v1.UpdateTaskStatusRequest.TaskStatusUpdate")
	proto.RegisterType((*UpdateTaskStatusResponse)(nil), "docker.swarmkit.v1.UpdateTaskStatusResponse")
	proto.RegisterType((*TasksRequest)(nil), "docker.swarmkit.v1.TasksRequest")
	proto.RegisterType((*TasksMessage)(nil), "docker.swarmkit.v1.TasksMessage")
	proto.RegisterType((*AssignmentsRequest)(nil), "docker.swarmkit.v1.AssignmentsRequest")
	proto.RegisterType((*Assignment)(nil), "docker.swarmkit.v1.Assignment")
	proto.RegisterType((*AssignmentChange)(nil), "docker.swarmkit.v1.AssignmentChange")
	proto.RegisterType((*AssignmentsMessage)(nil), "docker.swarmkit.v1.AssignmentsMessage")
	proto.RegisterEnum("docker.swarmkit.v1.AssignmentChange_AssignmentAction", AssignmentChange_AssignmentAction_name, AssignmentChange_AssignmentAction_value)
	proto.RegisterEnum("docker.swarmkit.v1.AssignmentsMessage_Type", AssignmentsMessage_Type_name, AssignmentsMessage_Type_value)
}

type authenticatedWrapperDispatcherServer struct {
	local     DispatcherServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperDispatcherServer(local DispatcherServer, authorize func(context.Context, []string) error) DispatcherServer {
	return &authenticatedWrapperDispatcherServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperDispatcherServer) Session(r *SessionRequest, stream Dispatcher_SessionServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-worker", "swarm-manager"}); err != nil {
		return err
	}
	return p.local.Session(r, stream)
}

func (p *authenticatedWrapperDispatcherServer) Heartbeat(ctx context.Context, r *HeartbeatRequest) (*HeartbeatResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-worker", "swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.Heartbeat(ctx, r)
}

func (p *authenticatedWrapperDispatcherServer) UpdateTaskStatus(ctx context.Context, r *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-worker", "swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.UpdateTaskStatus(ctx, r)
}

func (p *authenticatedWrapperDispatcherServer) Tasks(r *TasksRequest, stream Dispatcher_TasksServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-worker", "swarm-manager"}); err != nil {
		return err
	}
	return p.local.Tasks(r, stream)
}

func (p *authenticatedWrapperDispatcherServer) Assignments(r *AssignmentsRequest, stream Dispatcher_AssignmentsServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-worker", "swarm-manager"}); err != nil {
		return err
	}
	return p.local.Assignments(r, stream)
}

func (m *SessionRequest) Copy() *SessionRequest {
	if m == nil {
		return nil
	}

	o := &SessionRequest{
		Description: m.Description.Copy(),
		SessionID:   m.SessionID,
	}

	return o
}

func (m *SessionMessage) Copy() *SessionMessage {
	if m == nil {
		return nil
	}

	o := &SessionMessage{
		SessionID: m.SessionID,
		Node:      m.Node.Copy(),
	}

	if m.Managers != nil {
		o.Managers = make([]*WeightedPeer, 0, len(m.Managers))
		for _, v := range m.Managers {
			o.Managers = append(o.Managers, v.Copy())
		}
	}

	if m.NetworkBootstrapKeys != nil {
		o.NetworkBootstrapKeys = make([]*EncryptionKey, 0, len(m.NetworkBootstrapKeys))
		for _, v := range m.NetworkBootstrapKeys {
			o.NetworkBootstrapKeys = append(o.NetworkBootstrapKeys, v.Copy())
		}
	}

	return o
}

func (m *HeartbeatRequest) Copy() *HeartbeatRequest {
	if m == nil {
		return nil
	}

	o := &HeartbeatRequest{
		SessionID: m.SessionID,
	}

	return o
}

func (m *HeartbeatResponse) Copy() *HeartbeatResponse {
	if m == nil {
		return nil
	}

	o := &HeartbeatResponse{
		Period: *m.Period.Copy(),
	}

	return o
}

func (m *UpdateTaskStatusRequest) Copy() *UpdateTaskStatusRequest {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusRequest{
		SessionID: m.SessionID,
	}

	if m.Updates != nil {
		o.Updates = make([]*UpdateTaskStatusRequest_TaskStatusUpdate, 0, len(m.Updates))
		for _, v := range m.Updates {
			o.Updates = append(o.Updates, v.Copy())
		}
	}

	return o
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Copy() *UpdateTaskStatusRequest_TaskStatusUpdate {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusRequest_TaskStatusUpdate{
		TaskID: m.TaskID,
		Status: m.Status.Copy(),
	}

	return o
}

func (m *UpdateTaskStatusResponse) Copy() *UpdateTaskStatusResponse {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusResponse{}

	return o
}

func (m *TasksRequest) Copy() *TasksRequest {
	if m == nil {
		return nil
	}

	o := &TasksRequest{
		SessionID: m.SessionID,
	}

	return o
}

func (m *TasksMessage) Copy() *TasksMessage {
	if m == nil {
		return nil
	}

	o := &TasksMessage{}

	if m.Tasks != nil {
		o.Tasks = make([]*Task, 0, len(m.Tasks))
		for _, v := range m.Tasks {
			o.Tasks = append(o.Tasks, v.Copy())
		}
	}

	return o
}

func (m *AssignmentsRequest) Copy() *AssignmentsRequest {
	if m == nil {
		return nil
	}

	o := &AssignmentsRequest{
		SessionID: m.SessionID,
	}

	return o
}

func (m *Assignment) Copy() *Assignment {
	if m == nil {
		return nil
	}

	o := &Assignment{}

	switch m.Item.(type) {
	case *Assignment_Task:
		i := &Assignment_Task{
			Task: m.GetTask().Copy(),
		}

		o.Item = i
	case *Assignment_Secret:
		i := &Assignment_Secret{
			Secret: m.GetSecret().Copy(),
		}

		o.Item = i
	}

	return o
}

func (m *AssignmentChange) Copy() *AssignmentChange {
	if m == nil {
		return nil
	}

	o := &AssignmentChange{
		Assignment: m.Assignment.Copy(),
		Action:     m.Action,
	}

	return o
}

func (m *AssignmentsMessage) Copy() *AssignmentsMessage {
	if m == nil {
		return nil
	}

	o := &AssignmentsMessage{
		Type:      m.Type,
		AppliesTo: m.AppliesTo,
		ResultsIn: m.ResultsIn,
	}

	if m.Changes != nil {
		o.Changes = make([]*AssignmentChange, 0, len(m.Changes))
		for _, v := range m.Changes {
			o.Changes = append(o.Changes, v.Copy())
		}
	}

	return o
}

func (this *SessionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.SessionRequest{")
	if this.Description != nil {
		s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	}
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SessionMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.SessionMessage{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	if this.Node != nil {
		s = append(s, "Node: "+fmt.Sprintf("%#v", this.Node)+",\n")
	}
	if this.Managers != nil {
		s = append(s, "Managers: "+fmt.Sprintf("%#v", this.Managers)+",\n")
	}
	if this.NetworkBootstrapKeys != nil {
		s = append(s, "NetworkBootstrapKeys: "+fmt.Sprintf("%#v", this.NetworkBootstrapKeys)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HeartbeatRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.HeartbeatRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HeartbeatResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.HeartbeatResponse{")
	s = append(s, "Period: "+strings.Replace(this.Period.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.UpdateTaskStatusRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	if this.Updates != nil {
		s = append(s, "Updates: "+fmt.Sprintf("%#v", this.Updates)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusRequest_TaskStatusUpdate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.UpdateTaskStatusRequest_TaskStatusUpdate{")
	s = append(s, "TaskID: "+fmt.Sprintf("%#v", this.TaskID)+",\n")
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.UpdateTaskStatusResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.TasksRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TasksMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.TasksMessage{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AssignmentsRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.AssignmentsRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Assignment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Assignment{")
	if this.Item != nil {
		s = append(s, "Item: "+fmt.Sprintf("%#v", this.Item)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Assignment_Task) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.Assignment_Task{` +
		`Task:` + fmt.Sprintf("%#v", this.Task) + `}`}, ", ")
	return s
}
func (this *Assignment_Secret) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.Assignment_Secret{` +
		`Secret:` + fmt.Sprintf("%#v", this.Secret) + `}`}, ", ")
	return s
}
func (this *AssignmentChange) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.AssignmentChange{")
	if this.Assignment != nil {
		s = append(s, "Assignment: "+fmt.Sprintf("%#v", this.Assignment)+",\n")
	}
	s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AssignmentsMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.AssignmentsMessage{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "AppliesTo: "+fmt.Sprintf("%#v", this.AppliesTo)+",\n")
	s = append(s, "ResultsIn: "+fmt.Sprintf("%#v", this.ResultsIn)+",\n")
	if this.Changes != nil {
		s = append(s, "Changes: "+fmt.Sprintf("%#v", this.Changes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringDispatcher(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringDispatcher(m github_com_gogo_protobuf_proto.Message) string {
	e := github_com_gogo_protobuf_proto.GetUnsafeExtensionsMap(m)
	if e == nil {
		return "nil"
	}
	s := "proto.NewUnsafeXXX_InternalExtensions(map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "})"
	return s
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion3

// Client API for Dispatcher service

type DispatcherClient interface {
	// Session starts an agent session with the dispatcher. The session is
	// started after the first SessionMessage is received.
	//
	// Once started, the agent is controlled with a stream of SessionMessage.
	// Agents should list on the stream at all times for instructions.
	Session(ctx context.Context, in *SessionRequest, opts ...grpc.CallOption) (Dispatcher_SessionClient, error)
	// Heartbeat is heartbeat method for nodes. It returns new TTL in response.
	// Node should send new heartbeat earlier than now + TTL, otherwise it will
	// be deregistered from dispatcher and its status will be updated to NodeStatus_DOWN
	Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error)
	// UpdateTaskStatus updates status of task. Node should send such updates
	// on every status change of its tasks.
	//
	// Whether receiving batch updates or single status updates, this method
	// should be accepting. Errors should only be returned if the entire update
	// should be retried, due to data loss or other problems.
	//
	// If a task is unknown the dispatcher, the status update should be
	// accepted regardless.
	UpdateTaskStatus(ctx context.Context, in *UpdateTaskStatusRequest, opts ...grpc.CallOption) (*UpdateTaskStatusResponse, error)
	// Tasks is a stream of tasks state for node. Each message contains full list
	// of tasks which should be run on node, if task is not present in that list,
	// it should be terminated.
	Tasks(ctx context.Context, in *TasksRequest, opts ...grpc.CallOption) (Dispatcher_TasksClient, error)
	// Assignments is a stream of assignments such as tasks and secrets for node.
	// The first message in the stream contains all of the tasks and secrets
	// that are relevant to the node. Future messages in the stream are updates to
	// the set of assignments.
	Assignments(ctx context.Context, in *AssignmentsRequest, opts ...grpc.CallOption) (Dispatcher_AssignmentsClient, error)
}

type dispatcherClient struct {
	cc *grpc.ClientConn
}

func NewDispatcherClient(cc *grpc.ClientConn) DispatcherClient {
	return &dispatcherClient{cc}
}

func (c *dispatcherClient) Session(ctx context.Context, in *SessionRequest, opts ...grpc.CallOption) (Dispatcher_SessionClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Dispatcher_serviceDesc.Streams[0], c.cc, "/docker.swarmkit.v1.Dispatcher/Session", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherSessionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_SessionClient interface {
	Recv() (*SessionMessage, error)
	grpc.ClientStream
}

type dispatcherSessionClient struct {
	grpc.ClientStream
}

func (x *dispatcherSessionClient) Recv() (*SessionMessage, error) {
	m := new(SessionMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *dispatcherClient) Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error) {
	out := new(HeartbeatResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.Dispatcher/Heartbeat", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) UpdateTaskStatus(ctx context.Context, in *UpdateTaskStatusRequest, opts ...grpc.CallOption) (*UpdateTaskStatusResponse, error) {
	out := new(UpdateTaskStatusResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.Dispatcher/UpdateTaskStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) Tasks(ctx context.Context, in *TasksRequest, opts ...grpc.CallOption) (Dispatcher_TasksClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Dispatcher_serviceDesc.Streams[1], c.cc, "/docker.swarmkit.v1.Dispatcher/Tasks", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherTasksClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_TasksClient interface {
	Recv() (*TasksMessage, error)
	grpc.ClientStream
}

type dispatcherTasksClient struct {
	grpc.ClientStream
}

func (x *dispatcherTasksClient) Recv() (*TasksMessage, error) {
	m := new(TasksMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *dispatcherClient) Assignments(ctx context.Context, in *AssignmentsRequest, opts ...grpc.CallOption) (Dispatcher_AssignmentsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Dispatcher_serviceDesc.Streams[2], c.cc, "/docker.swarmkit.v1.Dispatcher/Assignments", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherAssignmentsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_AssignmentsClient interface {
	Recv() (*AssignmentsMessage, error)
	grpc.ClientStream
}

type dispatcherAssignmentsClient struct {
	grpc.ClientStream
}

func (x *dispatcherAssignmentsClient) Recv() (*AssignmentsMessage, error) {
	m := new(AssignmentsMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Dispatcher service

type DispatcherServer interface {
	// Session starts an agent session with the dispatcher. The session is
	// started after the first SessionMessage is received.
	//
	// Once started, the agent is controlled with a stream of SessionMessage.
	// Agents should list on the stream at all times for instructions.
	Session(*SessionRequest, Dispatcher_SessionServer) error
	// Heartbeat is heartbeat method for nodes. It returns new TTL in response.
	// Node should send new heartbeat earlier than now + TTL, otherwise it will
	// be deregistered from dispatcher and its status will be updated to NodeStatus_DOWN
	Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error)
	// UpdateTaskStatus updates status of task. Node should send such updates
	// on every status change of its tasks.
	//
	// Whether receiving batch updates or single status updates, this method
	// should be accepting. Errors should only be returned if the entire update
	// should be retried, due to data loss or other problems.
	//
	// If a task is unknown the dispatcher, the status update should be
	// accepted regardless.
	UpdateTaskStatus(context.Context, *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error)
	// Tasks is a stream of tasks state for node. Each message contains full list
	// of tasks which should be run on node, if task is not present in that list,
	// it should be terminated.
	Tasks(*TasksRequest, Dispatcher_TasksServer) error
	// Assignments is a stream of assignments such as tasks and secrets for node.
	// The first message in the stream contains all of the tasks and secrets
	// that are relevant to the node. Future messages in the stream are updates to
	// the set of assignments.
	Assignments(*AssignmentsRequest, Dispatcher_AssignmentsServer) error
}

func RegisterDispatcherServer(s *grpc.Server, srv DispatcherServer) {
	s.RegisterService(&_Dispatcher_serviceDesc, srv)
}

func _Dispatcher_Session_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SessionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Session(m, &dispatcherSessionServer{stream})
}

type Dispatcher_SessionServer interface {
	Send(*SessionMessage) error
	grpc.ServerStream
}

type dispatcherSessionServer struct {
	grpc.ServerStream
}

func (x *dispatcherSessionServer) Send(m *SessionMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _Dispatcher_Heartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DispatcherServer).Heartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Dispatcher/Heartbeat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DispatcherServer).Heartbeat(ctx, req.(*HeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dispatcher_UpdateTaskStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DispatcherServer).UpdateTaskStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Dispatcher/UpdateTaskStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DispatcherServer).UpdateTaskStatus(ctx, req.(*UpdateTaskStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dispatcher_Tasks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TasksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Tasks(m, &dispatcherTasksServer{stream})
}

type Dispatcher_TasksServer interface {
	Send(*TasksMessage) error
	grpc.ServerStream
}

type dispatcherTasksServer struct {
	grpc.ServerStream
}

func (x *dispatcherTasksServer) Send(m *TasksMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _Dispatcher_Assignments_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(AssignmentsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Assignments(m, &dispatcherAssignmentsServer{stream})
}

type Dispatcher_AssignmentsServer interface {
	Send(*AssignmentsMessage) error
	grpc.ServerStream
}

type dispatcherAssignmentsServer struct {
	grpc.ServerStream
}

func (x *dispatcherAssignmentsServer) Send(m *AssignmentsMessage) error {
	return x.ServerStream.SendMsg(m)
}

var _Dispatcher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.Dispatcher",
	HandlerType: (*DispatcherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Heartbeat",
			Handler:    _Dispatcher_Heartbeat_Handler,
		},
		{
			MethodName: "UpdateTaskStatus",
			Handler:    _Dispatcher_UpdateTaskStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Session",
			Handler:       _Dispatcher_Session_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Tasks",
			Handler:       _Dispatcher_Tasks_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Assignments",
			Handler:       _Dispatcher_Assignments_Handler,
			ServerStreams: true,
		},
	},
	Metadata: fileDescriptorDispatcher,
}

func (m *SessionRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SessionRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Description != nil {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Description.Size()))
		n1, err := m.Description.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.SessionID) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *SessionMessage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SessionMessage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	if m.Node != nil {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Node.Size()))
		n2, err := m.Node.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.Managers) > 0 {
		for _, msg := range m.Managers {
			data[i] = 0x1a
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.NetworkBootstrapKeys) > 0 {
		for _, msg := range m.NetworkBootstrapKeys {
			data[i] = 0x22
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *HeartbeatRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HeartbeatRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *HeartbeatResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HeartbeatResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintDispatcher(data, i, uint64(m.Period.Size()))
	n3, err := m.Period.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func (m *UpdateTaskStatusRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	if len(m.Updates) > 0 {
		for _, msg := range m.Updates {
			data[i] = 0x1a
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TaskID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.TaskID)))
		i += copy(data[i:], m.TaskID)
	}
	if m.Status != nil {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Status.Size()))
		n4, err := m.Status.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *UpdateTaskStatusResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TasksRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TasksRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *TasksMessage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TasksMessage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, msg := range m.Tasks {
			data[i] = 0xa
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AssignmentsRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AssignmentsRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *Assignment) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Assignment) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Item != nil {
		nn5, err := m.Item.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn5
	}
	return i, nil
}

func (m *Assignment_Task) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Task != nil {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Task.Size()))
		n6, err := m.Task.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *Assignment_Secret) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Secret != nil {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Secret.Size()))
		n7, err := m.Secret.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *AssignmentChange) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AssignmentChange) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Assignment != nil {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Assignment.Size()))
		n8, err := m.Assignment.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Action != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Action))
	}
	return i, nil
}

func (m *AssignmentsMessage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AssignmentsMessage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Type))
	}
	if len(m.AppliesTo) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.AppliesTo)))
		i += copy(data[i:], m.AppliesTo)
	}
	if len(m.ResultsIn) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.ResultsIn)))
		i += copy(data[i:], m.ResultsIn)
	}
	if len(m.Changes) > 0 {
		for _, msg := range m.Changes {
			data[i] = 0x22
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Dispatcher(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Dispatcher(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintDispatcher(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

type raftProxyDispatcherServer struct {
	local        DispatcherServer
	connSelector raftselector.ConnProvider
	ctxMods      []func(context.Context) (context.Context, error)
}

func NewRaftProxyDispatcherServer(local DispatcherServer, connSelector raftselector.ConnProvider, ctxMod func(context.Context) (context.Context, error)) DispatcherServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	mods := []func(context.Context) (context.Context, error){redirectChecker}
	mods = append(mods, ctxMod)

	return &raftProxyDispatcherServer{
		local:        local,
		connSelector: connSelector,
		ctxMods:      mods,
	}
}
func (p *raftProxyDispatcherServer) runCtxMods(ctx context.Context) (context.Context, error) {
	var err error
	for _, mod := range p.ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyDispatcherServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := time.NewTicker(500 * time.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

func (p *raftProxyDispatcherServer) Session(r *SessionRequest, stream Dispatcher_SessionServer) error {

	ctx := stream.Context()
	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.Session(r, stream)
		}
		return err
	}
	ctx, err = p.runCtxMods(ctx)
	if err != nil {
		return err
	}
	clientStream, err := NewDispatcherClient(conn).Session(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (p *raftProxyDispatcherServer) Heartbeat(ctx context.Context, r *HeartbeatRequest) (*HeartbeatResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.Heartbeat(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := NewDispatcherClient(conn).Heartbeat(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.Heartbeat(ctx, r)
			}
			return nil, err
		}
		return NewDispatcherClient(conn).Heartbeat(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyDispatcherServer) UpdateTaskStatus(ctx context.Context, r *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.UpdateTaskStatus(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := NewDispatcherClient(conn).UpdateTaskStatus(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.UpdateTaskStatus(ctx, r)
			}
			return nil, err
		}
		return NewDispatcherClient(conn).UpdateTaskStatus(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyDispatcherServer) Tasks(r *TasksRequest, stream Dispatcher_TasksServer) error {

	ctx := stream.Context()
	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.Tasks(r, stream)
		}
		return err
	}
	ctx, err = p.runCtxMods(ctx)
	if err != nil {
		return err
	}
	clientStream, err := NewDispatcherClient(conn).Tasks(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (p *raftProxyDispatcherServer) Assignments(r *AssignmentsRequest, stream Dispatcher_AssignmentsServer) error {

	ctx := stream.Context()
	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.Assignments(r, stream)
		}
		return err
	}
	ctx, err = p.runCtxMods(ctx)
	if err != nil {
		return err
	}
	clientStream, err := NewDispatcherClient(conn).Assignments(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (m *SessionRequest) Size() (n int) {
	var l int
	_ = l
	if m.Description != nil {
		l = m.Description.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *SessionMessage) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Managers) > 0 {
		for _, e := range m.Managers {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	if len(m.NetworkBootstrapKeys) > 0 {
		for _, e := range m.NetworkBootstrapKeys {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *HeartbeatRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *HeartbeatResponse) Size() (n int) {
	var l int
	_ = l
	l = m.Period.Size()
	n += 1 + l + sovDispatcher(uint64(l))
	return n
}

func (m *UpdateTaskStatusRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Updates) > 0 {
		for _, e := range m.Updates {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Size() (n int) {
	var l int
	_ = l
	l = len(m.TaskID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *UpdateTaskStatusResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TasksRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *TasksMessage) Size() (n int) {
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *AssignmentsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *Assignment) Size() (n int) {
	var l int
	_ = l
	if m.Item != nil {
		n += m.Item.Size()
	}
	return n
}

func (m *Assignment_Task) Size() (n int) {
	var l int
	_ = l
	if m.Task != nil {
		l = m.Task.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}
func (m *Assignment_Secret) Size() (n int) {
	var l int
	_ = l
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}
func (m *AssignmentChange) Size() (n int) {
	var l int
	_ = l
	if m.Assignment != nil {
		l = m.Assignment.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Action != 0 {
		n += 1 + sovDispatcher(uint64(m.Action))
	}
	return n
}

func (m *AssignmentsMessage) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovDispatcher(uint64(m.Type))
	}
	l = len(m.AppliesTo)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	l = len(m.ResultsIn)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Changes) > 0 {
		for _, e := range m.Changes {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func sovDispatcher(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozDispatcher(x uint64) (n int) {
	return sovDispatcher(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *SessionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionRequest{`,
		`Description:` + strings.Replace(fmt.Sprintf("%v", this.Description), "NodeDescription", "NodeDescription", 1) + `,`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionMessage{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "Node", "Node", 1) + `,`,
		`Managers:` + strings.Replace(fmt.Sprintf("%v", this.Managers), "WeightedPeer", "WeightedPeer", 1) + `,`,
		`NetworkBootstrapKeys:` + strings.Replace(fmt.Sprintf("%v", this.NetworkBootstrapKeys), "EncryptionKey", "EncryptionKey", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeartbeatRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeartbeatRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeartbeatResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeartbeatResponse{`,
		`Period:` + strings.Replace(strings.Replace(this.Period.String(), "Duration", "docker_swarmkit_v11.Duration", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`Updates:` + strings.Replace(fmt.Sprintf("%v", this.Updates), "UpdateTaskStatusRequest_TaskStatusUpdate", "UpdateTaskStatusRequest_TaskStatusUpdate", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusRequest_TaskStatusUpdate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusRequest_TaskStatusUpdate{`,
		`TaskID:` + fmt.Sprintf("%v", this.TaskID) + `,`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "TaskStatus", "TaskStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusResponse{`,
		`}`,
	}, "")
	return s
}
func (this *TasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TasksRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TasksMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TasksMessage{`,
		`Tasks:` + strings.Replace(fmt.Sprintf("%v", this.Tasks), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AssignmentsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AssignmentsRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Assignment) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Assignment{`,
		`Item:` + fmt.Sprintf("%v", this.Item) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Assignment_Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Assignment_Task{`,
		`Task:` + strings.Replace(fmt.Sprintf("%v", this.Task), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Assignment_Secret) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Assignment_Secret{`,
		`Secret:` + strings.Replace(fmt.Sprintf("%v", this.Secret), "Secret", "Secret", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AssignmentChange) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AssignmentChange{`,
		`Assignment:` + strings.Replace(fmt.Sprintf("%v", this.Assignment), "Assignment", "Assignment", 1) + `,`,
		`Action:` + fmt.Sprintf("%v", this.Action) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AssignmentsMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AssignmentsMessage{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`AppliesTo:` + fmt.Sprintf("%v", this.AppliesTo) + `,`,
		`ResultsIn:` + fmt.Sprintf("%v", this.ResultsIn) + `,`,
		`Changes:` + strings.Replace(fmt.Sprintf("%v", this.Changes), "AssignmentChange", "AssignmentChange", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringDispatcher(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *SessionRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Description == nil {
				m.Description = &NodeDescription{}
			}
			if err := m.Description.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SessionMessage) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &Node{}
			}
			if err := m.Node.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Managers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Managers = append(m.Managers, &WeightedPeer{})
			if err := m.Managers[len(m.Managers)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkBootstrapKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkBootstrapKeys = append(m.NetworkBootstrapKeys, &EncryptionKey{})
			if err := m.NetworkBootstrapKeys[len(m.NetworkBootstrapKeys)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Period.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateTaskStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateTaskStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Updates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Updates = append(m.Updates, &UpdateTaskStatusRequest_TaskStatusUpdate{})
			if err := m.Updates[len(m.Updates)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskStatusUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskStatusUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &TaskStatus{}
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateTaskStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateTaskStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TasksRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TasksMessage) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TasksMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TasksMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssignmentsRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssignmentsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssignmentsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Assignment) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Assignment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Assignment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Task{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Item = &Assignment_Task{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Secret{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Item = &Assignment_Secret{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssignmentChange) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssignmentChange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssignmentChange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Assignment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Assignment == nil {
				m.Assignment = &Assignment{}
			}
			if err := m.Assignment.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Action |= (AssignmentChange_AssignmentAction(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssignmentsMessage) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssignmentsMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssignmentsMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Type |= (AssignmentsMessage_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppliesTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppliesTo = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResultsIn", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResultsIn = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Changes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Changes = append(m.Changes, &AssignmentChange{})
			if err := m.Changes[len(m.Changes)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDispatcher(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthDispatcher
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowDispatcher
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipDispatcher(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthDispatcher = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDispatcher   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("dispatcher.proto", fileDescriptorDispatcher) }

var fileDescriptorDispatcher = []byte{
	// 939 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x56, 0x4f, 0x6f, 0xdb, 0xc6,
	0x13, 0xd5, 0xca, 0x32, 0x1d, 0x8f, 0x6c, 0xff, 0xf4, 0xdb, 0x06, 0x89, 0x40, 0x24, 0xb2, 0x4a,
	0x37, 0x82, 0x81, 0xb8, 0x72, 0xaa, 0xfe, 0x39, 0x14, 0x86, 0x5b, 0xcb, 0x12, 0x60, 0x21, 0x91,
	0x6d, 0xac, 0x95, 0xe4, 0x28, 0x50, 0xe2, 0x40, 0x66, 0x65, 0x71, 0x59, 0xee, 0x2a, 0xa9, 0x0a,
	0x14, 0x28, 0xd0, 0x06, 0x28, 0x7a, 0x2a, 0x7a, 0xca, 0xa5, 0x5f, 0xa1, 0x9f, 0xc3, 0xe8, 0xa9,
	0xc7, 0x9e, 0x8c, 0x5a, 0x1f, 0xa0, 0xe8, 0xb9, 0xa7, 0x82, 0xe4, 0x52, 0x52, 0x15, 0xca, 0x91,
	0x7d, 0x12, 0x39, 0xf3, 0xde, 0xcc, 0xe3, 0xec, 0xf0, 0x51, 0x90, 0xb1, 0x6c, 0xe1, 0x9a, 0xb2,
	0x7d, 0x8a, 0x5e, 0xd1, 0xf5, 0xb8, 0xe4, 0x94, 0x5a, 0xbc, 0xdd, 0x45, 0xaf, 0x28, 0x5e, 0x9a,
	0x5e, 0xaf, 0x6b, 0xcb, 0xe2, 0x8b, 0x0f, 0xf4, 0xb4, 0x1c, 0xb8, 0x28, 0x42, 0x80, 0xbe, 0xca,
	0x5b, 0x5f, 0x60, 0x5b, 0x46, 0xb7, 0xb7, 0x3b, 0xbc, 0xc3, 0x83, 0xcb, 0x6d, 0xff, 0x4a, 0x45,
	0xdf, 0x71, 0xcf, 0xfa, 0x1d, 0xdb, 0xd9, 0x0e, 0x7f, 0x54, 0xf0, 0xae, 0xd5, 0xf7, 0x4c, 0x69,
	0x73, 0x67, 0x3b, 0xba, 0x08, 0x13, 0xc6, 0x2b, 0x02, 0x6b, 0x27, 0x28, 0x84, 0xcd, 0x1d, 0x86,
	0x5f, 0xf6, 0x51, 0x48, 0x5a, 0x85, 0xb4, 0x85, 0xa2, 0xed, 0xd9, 0xae, 0x8f, 0xcb, 0x92, 0x3c,
	0xd9, 0x4c, 0x97, 0x36, 0x8a, 0x6f, 0x8a, 0x2b, 0x1e, 0x72, 0x0b, 0x2b, 0x63, 0x28, 0x9b, 0xe4,
	0xd1, 0x2d, 0x00, 0x11, 0x16, 0x6e, 0xda, 0x56, 0x36, 0x99, 0x27, 0x9b, 0xcb, 0xe5, 0xd5, 0xe1,
	0xc5, 0xfa, 0xb2, 0x6a, 0x57, 0xab, 0xb0, 0x65, 0x05, 0xa8, 0x59, 0xc6, 0x77, 0xc9, 0x91, 0x8e,
	0x3a, 0x0a, 0x61, 0x76, 0x70, 0xaa, 0x00, 0xb9, 0xba, 0x00, 0xdd, 0x82, 0x94, 0xc3, 0x2d, 0x0c,
	0x1a, 0xa5, 0x4b, 0xd9, 0x59, 0x72, 0x59, 0x80, 0xa2, 0x3b, 0x70, 0xab, 0x67, 0x3a, 0x66, 0x07,
	0x3d, 0x91, 0x5d, 0xc8, 0x2f, 0x6c, 0xa6, 0x4b, 0xf9, 0x38, 0xc6, 0x73, 0xb4, 0x3b, 0xa7, 0x12,
	0xad, 0x63, 0x44, 0x8f, 0x8d, 0x18, 0xf4, 0x39, 0xdc, 0x71, 0x50, 0xbe, 0xe4, 0x5e, 0xb7, 0xd9,
	0xe2, 0x5c, 0x0a, 0xe9, 0x99, 0x6e, 0xb3, 0x8b, 0x03, 0x91, 0x4d, 0x05, 0xb5, 0xde, 0x8d, 0xab,
	0x55, 0x75, 0xda, 0xde, 0x20, 0x18, 0xcd, 0x63, 0x1c, 0xb0, 0xdb, 0xaa, 0x40, 0x39, 0xe2, 0x3f,
	0xc6, 0x81, 0x30, 0x3e, 0x87, 0xcc, 0x01, 0x9a, 0x9e, 0x6c, 0xa1, 0x29, 0xa3, 0xe3, 0xb8, 0xd6,
	0x18, 0x8c, 0x23, 0xf8, 0xff, 0x44, 0x05, 0xe1, 0x72, 0x47, 0x20, 0xfd, 0x14, 0x34, 0x17, 0x3d,
	0x9b, 0x5b, 0xea, 0x30, 0xef, 0xc5, 0xe9, 0xab, 0xa8, 0xc5, 0x28, 0xa7, 0xce, 0x2f, 0xd6, 0x13,
	0x4c, 0x31, 0x8c, 0x9f, 0x92, 0x70, 0xf7, 0xa9, 0x6b, 0x99, 0x12, 0x1b, 0xa6, 0xe8, 0x9e, 0x48,
	0x53, 0xf6, 0xc5, 0x8d, 0xa4, 0xd1, 0x67, 0xb0, 0xd4, 0x0f, 0x0a, 0x45, 0x23, 0xdf, 0x89, 0x93,
	0x31, 0xa3, 0x57, 0x71, 0x1c, 0x09, 0x11, 0x2c, 0x2a, 0xa6, 0x73, 0xc8, 0x4c, 0x27, 0xe9, 0x06,
	0x2c, 0x49, 0x53, 0x74, 0xc7, 0xb2, 0x60, 0x78, 0xb1, 0xae, 0xf9, 0xb0, 0x5a, 0x85, 0x69, 0x7e,
	0xaa, 0x66, 0xd1, 0x4f, 0x40, 0x13, 0x01, 0x49, 0x2d, 0x4d, 0x2e, 0x4e, 0xcf, 0x84, 0x12, 0x85,
	0x36, 0x74, 0xc8, 0xbe, 0xa9, 0x32, 0x1c, 0xb5, 0xb1, 0x03, 0x2b, 0x7e, 0xf4, 0x66, 0x23, 0x32,
	0x76, 0x15, 0x3b, 0x7a, 0x05, 0x8a, 0xb0, 0xe8, 0x6b, 0x15, 0x59, 0x12, 0x0c, 0x2c, 0x3b, 0x4b,
	0x20, 0x0b, 0x61, 0x46, 0x19, 0xe8, 0x9e, 0x10, 0x76, 0xc7, 0xe9, 0xa1, 0x23, 0x6f, 0xa8, 0xe1,
	0x6b, 0x80, 0x71, 0x0d, 0x5a, 0x84, 0x94, 0x5f, 0x5a, 0x2d, 0xce, 0x4c, 0x01, 0x07, 0x09, 0x16,
	0xe0, 0xe8, 0x47, 0xa0, 0x09, 0x6c, 0x7b, 0x28, 0xd5, 0x4c, 0xf5, 0x38, 0xc6, 0x49, 0x80, 0x38,
	0x48, 0x30, 0x85, 0x2d, 0x6b, 0x90, 0xb2, 0x25, 0xf6, 0x8c, 0x57, 0x49, 0xc8, 0x8c, 0x9b, 0xef,
	0x9f, 0x9a, 0x4e, 0x07, 0xe9, 0x2e, 0x80, 0x39, 0x8a, 0x29, 0x21, 0xb1, 0x47, 0x35, 0x66, 0xb2,
	0x09, 0x06, 0xad, 0x83, 0x66, 0xb6, 0x03, 0x2b, 0xf3, 0x25, 0xad, 0x95, 0x3e, 0xbe, 0x9a, 0x1b,
	0x76, 0x9d, 0x08, 0xec, 0x05, 0x64, 0xa6, 0x8a, 0x18, 0xad, 0x49, 0x89, 0x61, 0x8e, 0x16, 0x40,
	0x7b, 0x7a, 0x5c, 0xd9, 0x6b, 0x54, 0x33, 0x09, 0x5d, 0xff, 0xf1, 0x97, 0xfc, 0x9d, 0x69, 0x84,
	0x5a, 0xcb, 0x02, 0x68, 0xac, 0x5a, 0x3f, 0x7a, 0x56, 0xcd, 0x90, 0x78, 0x1c, 0xc3, 0x1e, 0x7f,
	0x81, 0xc6, 0x3f, 0xe4, 0x3f, 0x07, 0x19, 0xad, 0xc3, 0x67, 0x90, 0xf2, 0x3f, 0x07, 0xc1, 0x0c,
	0xd6, 0x4a, 0x0f, 0xaf, 0x7e, 0x8e, 0x88, 0x55, 0x6c, 0x0c, 0x5c, 0x64, 0x01, 0x91, 0xde, 0x07,
	0x30, 0x5d, 0xf7, 0xcc, 0x46, 0xd1, 0x94, 0x3c, 0xf4, 0x64, 0xb6, 0xac, 0x22, 0x0d, 0xee, 0xa7,
	0x3d, 0x14, 0xfd, 0x33, 0x29, 0x9a, 0xb6, 0x93, 0x5d, 0x08, 0xd3, 0x2a, 0x52, 0x73, 0xe8, 0x2e,
	0x2c, 0xb5, 0x83, 0xe1, 0x44, 0x3e, 0xf7, 0xde, 0x3c, 0x93, 0x64, 0x11, 0xc9, 0x78, 0x00, 0x29,
	0x5f, 0x0b, 0x5d, 0x81, 0x5b, 0xfb, 0x47, 0xf5, 0xe3, 0x27, 0x55, 0x7f, 0x5e, 0xf4, 0x7f, 0x90,
	0xae, 0x1d, 0xee, 0xb3, 0x6a, 0xbd, 0x7a, 0xd8, 0xd8, 0x7b, 0x92, 0x21, 0xa5, 0xd7, 0x8b, 0x00,
	0x95, 0xd1, 0xb7, 0x91, 0x7e, 0x05, 0x4b, 0x6a, 0x4f, 0xa9, 0x11, 0xbf, 0x4c, 0x93, 0x5f, 0x2f,
	0xfd, 0x2a, 0x8c, 0x9a, 0x88, 0xb1, 0xf1, 0xdb, 0xaf, 0x7f, 0xbd, 0x4e, 0xde, 0x87, 0x95, 0x00,
	0xf3, 0xbe, 0xef, 0xc3, 0xe8, 0xc1, 0x6a, 0x78, 0xa7, 0x5c, 0xfe, 0x11, 0xa1, 0xdf, 0xc0, 0xf2,
	0xc8, 0x4b, 0x69, 0xec, 0xb3, 0x4e, 0x9b, 0xb5, 0xfe, 0xe0, 0x2d, 0x28, 0xe5, 0x12, 0xf3, 0x08,
	0xa0, 0x3f, 0x13, 0xc8, 0x4c, 0xfb, 0x0c, 0x7d, 0x78, 0x0d, 0xcf, 0xd4, 0xb7, 0xe6, 0x03, 0x5f,
	0x47, 0x54, 0x1f, 0x16, 0x03, 0x87, 0xa2, 0xf9, 0x59, 0x56, 0x30, 0xea, 0x3e, 0x1b, 0x11, 0x9d,
	0x43, 0x61, 0x8e, 0x8e, 0x3f, 0x24, 0xc9, 0x23, 0x42, 0xbf, 0x27, 0x90, 0x9e, 0x58, 0x6d, 0x5a,
	0x78, 0xcb, 0xee, 0x47, 0x1a, 0x0a, 0xf3, 0xbd, 0x23, 0x73, 0x6e, 0x44, 0xf9, 0xde, 0xf9, 0x65,
	0x2e, 0xf1, 0xc7, 0x65, 0x2e, 0xf1, 0xf7, 0x65, 0x8e, 0x7c, 0x3b, 0xcc, 0x91, 0xf3, 0x61, 0x8e,
	0xfc, 0x3e, 0xcc, 0x91, 0x3f, 0x87, 0x39, 0xd2, 0xd2, 0x82, 0xbf, 0x54, 0x1f, 0xfe, 0x1b, 0x00,
	0x00, 0xff, 0xff, 0x1d, 0x6e, 0x3d, 0x14, 0xda, 0x09, 0x00, 0x00,
}
