// Code generated by protoc-gen-go.
// source: api.proto
// DO NOT EDIT!

/*
Package types is a generated protocol buffer package.

It is generated from these files:
	api.proto

It has these top-level messages:
	GetServerVersionRequest
	GetServerVersionResponse
	UpdateProcessRequest
	UpdateProcessResponse
	CreateContainerRequest
	CreateContainerResponse
	SignalRequest
	SignalResponse
	AddProcessRequest
	Rlimit
	User
	AddProcessResponse
	CreateCheckpointRequest
	CreateCheckpointResponse
	DeleteCheckpointRequest
	DeleteCheckpointResponse
	ListCheckpointRequest
	Checkpoint
	ListCheckpointResponse
	StateRequest
	ContainerState
	Process
	Container
	Machine
	StateResponse
	UpdateContainerRequest
	UpdateResource
	UpdateContainerResponse
	EventsRequest
	Event
	NetworkStats
	CpuUsage
	ThrottlingData
	CpuStats
	PidsStats
	MemoryData
	MemoryStats
	BlkioStatsEntry
	BlkioStats
	HugetlbStats
	CgroupStats
	StatsResponse
	StatsRequest
*/
package types

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.ProtoPackageIsVersion1

type GetServerVersionRequest struct {
}

func (m *GetServerVersionRequest) Reset()                    { *m = GetServerVersionRequest{} }
func (m *GetServerVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServerVersionRequest) ProtoMessage()               {}
func (*GetServerVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type GetServerVersionResponse struct {
	Major    uint32 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor    uint32 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Patch    uint32 `protobuf:"varint,3,opt,name=patch" json:"patch,omitempty"`
	Revision string `protobuf:"bytes,4,opt,name=revision" json:"revision,omitempty"`
}

func (m *GetServerVersionResponse) Reset()                    { *m = GetServerVersionResponse{} }
func (m *GetServerVersionResponse) String() string            { return proto.CompactTextString(m) }
func (*GetServerVersionResponse) ProtoMessage()               {}
func (*GetServerVersionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type UpdateProcessRequest struct {
	Id         string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid        string `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	CloseStdin bool   `protobuf:"varint,3,opt,name=closeStdin" json:"closeStdin,omitempty"`
	Width      uint32 `protobuf:"varint,4,opt,name=width" json:"width,omitempty"`
	Height     uint32 `protobuf:"varint,5,opt,name=height" json:"height,omitempty"`
}

func (m *UpdateProcessRequest) Reset()                    { *m = UpdateProcessRequest{} }
func (m *UpdateProcessRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProcessRequest) ProtoMessage()               {}
func (*UpdateProcessRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type UpdateProcessResponse struct {
}

func (m *UpdateProcessResponse) Reset()                    { *m = UpdateProcessResponse{} }
func (m *UpdateProcessResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateProcessResponse) ProtoMessage()               {}
func (*UpdateProcessResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type CreateContainerRequest struct {
	Id            string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BundlePath    string   `protobuf:"bytes,2,opt,name=bundlePath" json:"bundlePath,omitempty"`
	Checkpoint    string   `protobuf:"bytes,3,opt,name=checkpoint" json:"checkpoint,omitempty"`
	Stdin         string   `protobuf:"bytes,4,opt,name=stdin" json:"stdin,omitempty"`
	Stdout        string   `protobuf:"bytes,5,opt,name=stdout" json:"stdout,omitempty"`
	Stderr        string   `protobuf:"bytes,6,opt,name=stderr" json:"stderr,omitempty"`
	Labels        []string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty"`
	NoPivotRoot   bool     `protobuf:"varint,8,opt,name=noPivotRoot" json:"noPivotRoot,omitempty"`
	Runtime       string   `protobuf:"bytes,9,opt,name=runtime" json:"runtime,omitempty"`
	RuntimeArgs   []string `protobuf:"bytes,10,rep,name=runtimeArgs" json:"runtimeArgs,omitempty"`
	CheckpointDir string   `protobuf:"bytes,11,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *CreateContainerRequest) Reset()                    { *m = CreateContainerRequest{} }
func (m *CreateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerRequest) ProtoMessage()               {}
func (*CreateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type CreateContainerResponse struct {
	Container *Container `protobuf:"bytes,1,opt,name=container" json:"container,omitempty"`
}

func (m *CreateContainerResponse) Reset()                    { *m = CreateContainerResponse{} }
func (m *CreateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerResponse) ProtoMessage()               {}
func (*CreateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateContainerResponse) GetContainer() *Container {
	if m != nil {
		return m.Container
	}
	return nil
}

type SignalRequest struct {
	Id     string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid    string `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Signal uint32 `protobuf:"varint,3,opt,name=signal" json:"signal,omitempty"`
}

func (m *SignalRequest) Reset()                    { *m = SignalRequest{} }
func (m *SignalRequest) String() string            { return proto.CompactTextString(m) }
func (*SignalRequest) ProtoMessage()               {}
func (*SignalRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type SignalResponse struct {
}

func (m *SignalResponse) Reset()                    { *m = SignalResponse{} }
func (m *SignalResponse) String() string            { return proto.CompactTextString(m) }
func (*SignalResponse) ProtoMessage()               {}
func (*SignalResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type AddProcessRequest struct {
	Id              string    `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Terminal        bool      `protobuf:"varint,2,opt,name=terminal" json:"terminal,omitempty"`
	User            *User     `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Args            []string  `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	Env             []string  `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	Cwd             string    `protobuf:"bytes,6,opt,name=cwd" json:"cwd,omitempty"`
	Pid             string    `protobuf:"bytes,7,opt,name=pid" json:"pid,omitempty"`
	Stdin           string    `protobuf:"bytes,8,opt,name=stdin" json:"stdin,omitempty"`
	Stdout          string    `protobuf:"bytes,9,opt,name=stdout" json:"stdout,omitempty"`
	Stderr          string    `protobuf:"bytes,10,opt,name=stderr" json:"stderr,omitempty"`
	Capabilities    []string  `protobuf:"bytes,11,rep,name=capabilities" json:"capabilities,omitempty"`
	ApparmorProfile string    `protobuf:"bytes,12,opt,name=apparmorProfile" json:"apparmorProfile,omitempty"`
	SelinuxLabel    string    `protobuf:"bytes,13,opt,name=selinuxLabel" json:"selinuxLabel,omitempty"`
	NoNewPrivileges bool      `protobuf:"varint,14,opt,name=noNewPrivileges" json:"noNewPrivileges,omitempty"`
	Rlimits         []*Rlimit `protobuf:"bytes,15,rep,name=rlimits" json:"rlimits,omitempty"`
}

func (m *AddProcessRequest) Reset()                    { *m = AddProcessRequest{} }
func (m *AddProcessRequest) String() string            { return proto.CompactTextString(m) }
func (*AddProcessRequest) ProtoMessage()               {}
func (*AddProcessRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *AddProcessRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *AddProcessRequest) GetRlimits() []*Rlimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type Rlimit struct {
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Soft uint64 `protobuf:"varint,2,opt,name=soft" json:"soft,omitempty"`
	Hard uint64 `protobuf:"varint,3,opt,name=hard" json:"hard,omitempty"`
}

func (m *Rlimit) Reset()                    { *m = Rlimit{} }
func (m *Rlimit) String() string            { return proto.CompactTextString(m) }
func (*Rlimit) ProtoMessage()               {}
func (*Rlimit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type User struct {
	Uid            uint32   `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	Gid            uint32   `protobuf:"varint,2,opt,name=gid" json:"gid,omitempty"`
	AdditionalGids []uint32 `protobuf:"varint,3,rep,name=additionalGids" json:"additionalGids,omitempty"`
}

func (m *User) Reset()                    { *m = User{} }
func (m *User) String() string            { return proto.CompactTextString(m) }
func (*User) ProtoMessage()               {}
func (*User) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type AddProcessResponse struct {
}

func (m *AddProcessResponse) Reset()                    { *m = AddProcessResponse{} }
func (m *AddProcessResponse) String() string            { return proto.CompactTextString(m) }
func (*AddProcessResponse) ProtoMessage()               {}
func (*AddProcessResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type CreateCheckpointRequest struct {
	Id            string      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Checkpoint    *Checkpoint `protobuf:"bytes,2,opt,name=checkpoint" json:"checkpoint,omitempty"`
	CheckpointDir string      `protobuf:"bytes,3,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *CreateCheckpointRequest) Reset()                    { *m = CreateCheckpointRequest{} }
func (m *CreateCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateCheckpointRequest) ProtoMessage()               {}
func (*CreateCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *CreateCheckpointRequest) GetCheckpoint() *Checkpoint {
	if m != nil {
		return m.Checkpoint
	}
	return nil
}

type CreateCheckpointResponse struct {
}

func (m *CreateCheckpointResponse) Reset()                    { *m = CreateCheckpointResponse{} }
func (m *CreateCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateCheckpointResponse) ProtoMessage()               {}
func (*CreateCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type DeleteCheckpointRequest struct {
	Id            string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Name          string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	CheckpointDir string `protobuf:"bytes,3,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *DeleteCheckpointRequest) Reset()                    { *m = DeleteCheckpointRequest{} }
func (m *DeleteCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteCheckpointRequest) ProtoMessage()               {}
func (*DeleteCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

type DeleteCheckpointResponse struct {
}

func (m *DeleteCheckpointResponse) Reset()                    { *m = DeleteCheckpointResponse{} }
func (m *DeleteCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteCheckpointResponse) ProtoMessage()               {}
func (*DeleteCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type ListCheckpointRequest struct {
	Id            string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	CheckpointDir string `protobuf:"bytes,2,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *ListCheckpointRequest) Reset()                    { *m = ListCheckpointRequest{} }
func (m *ListCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*ListCheckpointRequest) ProtoMessage()               {}
func (*ListCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

type Checkpoint struct {
	Name        string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Exit        bool     `protobuf:"varint,2,opt,name=exit" json:"exit,omitempty"`
	Tcp         bool     `protobuf:"varint,3,opt,name=tcp" json:"tcp,omitempty"`
	UnixSockets bool     `protobuf:"varint,4,opt,name=unixSockets" json:"unixSockets,omitempty"`
	Shell       bool     `protobuf:"varint,5,opt,name=shell" json:"shell,omitempty"`
	EmptyNS     []string `protobuf:"bytes,6,rep,name=emptyNS" json:"emptyNS,omitempty"`
}

func (m *Checkpoint) Reset()                    { *m = Checkpoint{} }
func (m *Checkpoint) String() string            { return proto.CompactTextString(m) }
func (*Checkpoint) ProtoMessage()               {}
func (*Checkpoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

type ListCheckpointResponse struct {
	Checkpoints []*Checkpoint `protobuf:"bytes,1,rep,name=checkpoints" json:"checkpoints,omitempty"`
}

func (m *ListCheckpointResponse) Reset()                    { *m = ListCheckpointResponse{} }
func (m *ListCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*ListCheckpointResponse) ProtoMessage()               {}
func (*ListCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ListCheckpointResponse) GetCheckpoints() []*Checkpoint {
	if m != nil {
		return m.Checkpoints
	}
	return nil
}

type StateRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *StateRequest) Reset()                    { *m = StateRequest{} }
func (m *StateRequest) String() string            { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()               {}
func (*StateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

type ContainerState struct {
	Status string `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
}

func (m *ContainerState) Reset()                    { *m = ContainerState{} }
func (m *ContainerState) String() string            { return proto.CompactTextString(m) }
func (*ContainerState) ProtoMessage()               {}
func (*ContainerState) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

type Process struct {
	Pid             string    `protobuf:"bytes,1,opt,name=pid" json:"pid,omitempty"`
	Terminal        bool      `protobuf:"varint,2,opt,name=terminal" json:"terminal,omitempty"`
	User            *User     `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Args            []string  `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	Env             []string  `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	Cwd             string    `protobuf:"bytes,6,opt,name=cwd" json:"cwd,omitempty"`
	SystemPid       uint32    `protobuf:"varint,7,opt,name=systemPid" json:"systemPid,omitempty"`
	Stdin           string    `protobuf:"bytes,8,opt,name=stdin" json:"stdin,omitempty"`
	Stdout          string    `protobuf:"bytes,9,opt,name=stdout" json:"stdout,omitempty"`
	Stderr          string    `protobuf:"bytes,10,opt,name=stderr" json:"stderr,omitempty"`
	Capabilities    []string  `protobuf:"bytes,11,rep,name=capabilities" json:"capabilities,omitempty"`
	ApparmorProfile string    `protobuf:"bytes,12,opt,name=apparmorProfile" json:"apparmorProfile,omitempty"`
	SelinuxLabel    string    `protobuf:"bytes,13,opt,name=selinuxLabel" json:"selinuxLabel,omitempty"`
	NoNewPrivileges bool      `protobuf:"varint,14,opt,name=noNewPrivileges" json:"noNewPrivileges,omitempty"`
	Rlimits         []*Rlimit `protobuf:"bytes,15,rep,name=rlimits" json:"rlimits,omitempty"`
}

func (m *Process) Reset()                    { *m = Process{} }
func (m *Process) String() string            { return proto.CompactTextString(m) }
func (*Process) ProtoMessage()               {}
func (*Process) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *Process) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *Process) GetRlimits() []*Rlimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type Container struct {
	Id         string     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BundlePath string     `protobuf:"bytes,2,opt,name=bundlePath" json:"bundlePath,omitempty"`
	Processes  []*Process `protobuf:"bytes,3,rep,name=processes" json:"processes,omitempty"`
	Status     string     `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	Labels     []string   `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty"`
	Pids       []uint32   `protobuf:"varint,6,rep,name=pids" json:"pids,omitempty"`
	Runtime    string     `protobuf:"bytes,7,opt,name=runtime" json:"runtime,omitempty"`
}

func (m *Container) Reset()                    { *m = Container{} }
func (m *Container) String() string            { return proto.CompactTextString(m) }
func (*Container) ProtoMessage()               {}
func (*Container) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *Container) GetProcesses() []*Process {
	if m != nil {
		return m.Processes
	}
	return nil
}

// Machine is information about machine on which containerd is run
type Machine struct {
	Cpus   uint32 `protobuf:"varint,1,opt,name=cpus" json:"cpus,omitempty"`
	Memory uint64 `protobuf:"varint,2,opt,name=memory" json:"memory,omitempty"`
}

func (m *Machine) Reset()                    { *m = Machine{} }
func (m *Machine) String() string            { return proto.CompactTextString(m) }
func (*Machine) ProtoMessage()               {}
func (*Machine) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

// StateResponse is information about containerd daemon
type StateResponse struct {
	Containers []*Container `protobuf:"bytes,1,rep,name=containers" json:"containers,omitempty"`
	Machine    *Machine     `protobuf:"bytes,2,opt,name=machine" json:"machine,omitempty"`
}

func (m *StateResponse) Reset()                    { *m = StateResponse{} }
func (m *StateResponse) String() string            { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()               {}
func (*StateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *StateResponse) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *StateResponse) GetMachine() *Machine {
	if m != nil {
		return m.Machine
	}
	return nil
}

type UpdateContainerRequest struct {
	Id        string          `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid       string          `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Status    string          `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	Resources *UpdateResource `protobuf:"bytes,4,opt,name=resources" json:"resources,omitempty"`
}

func (m *UpdateContainerRequest) Reset()                    { *m = UpdateContainerRequest{} }
func (m *UpdateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateContainerRequest) ProtoMessage()               {}
func (*UpdateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *UpdateContainerRequest) GetResources() *UpdateResource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type UpdateResource struct {
	BlkioWeight          uint64 `protobuf:"varint,1,opt,name=blkioWeight" json:"blkioWeight,omitempty"`
	CpuShares            uint64 `protobuf:"varint,2,opt,name=cpuShares" json:"cpuShares,omitempty"`
	CpuPeriod            uint64 `protobuf:"varint,3,opt,name=cpuPeriod" json:"cpuPeriod,omitempty"`
	CpuQuota             uint64 `protobuf:"varint,4,opt,name=cpuQuota" json:"cpuQuota,omitempty"`
	CpusetCpus           string `protobuf:"bytes,5,opt,name=cpusetCpus" json:"cpusetCpus,omitempty"`
	CpusetMems           string `protobuf:"bytes,6,opt,name=cpusetMems" json:"cpusetMems,omitempty"`
	MemoryLimit          uint64 `protobuf:"varint,7,opt,name=memoryLimit" json:"memoryLimit,omitempty"`
	MemorySwap           uint64 `protobuf:"varint,8,opt,name=memorySwap" json:"memorySwap,omitempty"`
	MemoryReservation    uint64 `protobuf:"varint,9,opt,name=memoryReservation" json:"memoryReservation,omitempty"`
	KernelMemoryLimit    uint64 `protobuf:"varint,10,opt,name=kernelMemoryLimit" json:"kernelMemoryLimit,omitempty"`
	KernelTCPMemoryLimit uint64 `protobuf:"varint,11,opt,name=kernelTCPMemoryLimit" json:"kernelTCPMemoryLimit,omitempty"`
}

func (m *UpdateResource) Reset()                    { *m = UpdateResource{} }
func (m *UpdateResource) String() string            { return proto.CompactTextString(m) }
func (*UpdateResource) ProtoMessage()               {}
func (*UpdateResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

type UpdateContainerResponse struct {
}

func (m *UpdateContainerResponse) Reset()                    { *m = UpdateContainerResponse{} }
func (m *UpdateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateContainerResponse) ProtoMessage()               {}
func (*UpdateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

type EventsRequest struct {
	// Tag 1 is deprecated (old uint64 timestamp)
	Timestamp  *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
	StoredOnly bool                       `protobuf:"varint,3,opt,name=storedOnly" json:"storedOnly,omitempty"`
	Id         string                     `protobuf:"bytes,4,opt,name=id" json:"id,omitempty"`
}

func (m *EventsRequest) Reset()                    { *m = EventsRequest{} }
func (m *EventsRequest) String() string            { return proto.CompactTextString(m) }
func (*EventsRequest) ProtoMessage()               {}
func (*EventsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *EventsRequest) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type Event struct {
	Type   string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Id     string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	Status uint32 `protobuf:"varint,3,opt,name=status" json:"status,omitempty"`
	Pid    string `protobuf:"bytes,4,opt,name=pid" json:"pid,omitempty"`
	// Tag 5 is deprecated (old uint64 timestamp)
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *Event) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type NetworkStats struct {
	Name       string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	RxBytes    uint64 `protobuf:"varint,2,opt,name=rx_bytes,json=rxBytes" json:"rx_bytes,omitempty"`
	Rx_Packets uint64 `protobuf:"varint,3,opt,name=rx_Packets,json=rxPackets" json:"rx_Packets,omitempty"`
	RxErrors   uint64 `protobuf:"varint,4,opt,name=Rx_errors,json=rxErrors" json:"Rx_errors,omitempty"`
	RxDropped  uint64 `protobuf:"varint,5,opt,name=Rx_dropped,json=rxDropped" json:"Rx_dropped,omitempty"`
	TxBytes    uint64 `protobuf:"varint,6,opt,name=Tx_bytes,json=txBytes" json:"Tx_bytes,omitempty"`
	TxPackets  uint64 `protobuf:"varint,7,opt,name=Tx_packets,json=txPackets" json:"Tx_packets,omitempty"`
	TxErrors   uint64 `protobuf:"varint,8,opt,name=Tx_errors,json=txErrors" json:"Tx_errors,omitempty"`
	TxDropped  uint64 `protobuf:"varint,9,opt,name=Tx_dropped,json=txDropped" json:"Tx_dropped,omitempty"`
}

func (m *NetworkStats) Reset()                    { *m = NetworkStats{} }
func (m *NetworkStats) String() string            { return proto.CompactTextString(m) }
func (*NetworkStats) ProtoMessage()               {}
func (*NetworkStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type CpuUsage struct {
	TotalUsage        uint64   `protobuf:"varint,1,opt,name=total_usage,json=totalUsage" json:"total_usage,omitempty"`
	PercpuUsage       []uint64 `protobuf:"varint,2,rep,name=percpu_usage,json=percpuUsage" json:"percpu_usage,omitempty"`
	UsageInKernelmode uint64   `protobuf:"varint,3,opt,name=usage_in_kernelmode,json=usageInKernelmode" json:"usage_in_kernelmode,omitempty"`
	UsageInUsermode   uint64   `protobuf:"varint,4,opt,name=usage_in_usermode,json=usageInUsermode" json:"usage_in_usermode,omitempty"`
}

func (m *CpuUsage) Reset()                    { *m = CpuUsage{} }
func (m *CpuUsage) String() string            { return proto.CompactTextString(m) }
func (*CpuUsage) ProtoMessage()               {}
func (*CpuUsage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

type ThrottlingData struct {
	Periods          uint64 `protobuf:"varint,1,opt,name=periods" json:"periods,omitempty"`
	ThrottledPeriods uint64 `protobuf:"varint,2,opt,name=throttled_periods,json=throttledPeriods" json:"throttled_periods,omitempty"`
	ThrottledTime    uint64 `protobuf:"varint,3,opt,name=throttled_time,json=throttledTime" json:"throttled_time,omitempty"`
}

func (m *ThrottlingData) Reset()                    { *m = ThrottlingData{} }
func (m *ThrottlingData) String() string            { return proto.CompactTextString(m) }
func (*ThrottlingData) ProtoMessage()               {}
func (*ThrottlingData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

type CpuStats struct {
	CpuUsage       *CpuUsage       `protobuf:"bytes,1,opt,name=cpu_usage,json=cpuUsage" json:"cpu_usage,omitempty"`
	ThrottlingData *ThrottlingData `protobuf:"bytes,2,opt,name=throttling_data,json=throttlingData" json:"throttling_data,omitempty"`
	SystemUsage    uint64          `protobuf:"varint,3,opt,name=system_usage,json=systemUsage" json:"system_usage,omitempty"`
}

func (m *CpuStats) Reset()                    { *m = CpuStats{} }
func (m *CpuStats) String() string            { return proto.CompactTextString(m) }
func (*CpuStats) ProtoMessage()               {}
func (*CpuStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *CpuStats) GetCpuUsage() *CpuUsage {
	if m != nil {
		return m.CpuUsage
	}
	return nil
}

func (m *CpuStats) GetThrottlingData() *ThrottlingData {
	if m != nil {
		return m.ThrottlingData
	}
	return nil
}

type PidsStats struct {
	Current uint64 `protobuf:"varint,1,opt,name=current" json:"current,omitempty"`
	Limit   uint64 `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
}

func (m *PidsStats) Reset()                    { *m = PidsStats{} }
func (m *PidsStats) String() string            { return proto.CompactTextString(m) }
func (*PidsStats) ProtoMessage()               {}
func (*PidsStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

type MemoryData struct {
	Usage    uint64 `protobuf:"varint,1,opt,name=usage" json:"usage,omitempty"`
	MaxUsage uint64 `protobuf:"varint,2,opt,name=max_usage,json=maxUsage" json:"max_usage,omitempty"`
	Failcnt  uint64 `protobuf:"varint,3,opt,name=failcnt" json:"failcnt,omitempty"`
	Limit    uint64 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *MemoryData) Reset()                    { *m = MemoryData{} }
func (m *MemoryData) String() string            { return proto.CompactTextString(m) }
func (*MemoryData) ProtoMessage()               {}
func (*MemoryData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

type MemoryStats struct {
	Cache       uint64            `protobuf:"varint,1,opt,name=cache" json:"cache,omitempty"`
	Usage       *MemoryData       `protobuf:"bytes,2,opt,name=usage" json:"usage,omitempty"`
	SwapUsage   *MemoryData       `protobuf:"bytes,3,opt,name=swap_usage,json=swapUsage" json:"swap_usage,omitempty"`
	KernelUsage *MemoryData       `protobuf:"bytes,4,opt,name=kernel_usage,json=kernelUsage" json:"kernel_usage,omitempty"`
	Stats       map[string]uint64 `protobuf:"bytes,5,rep,name=stats" json:"stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
}

func (m *MemoryStats) Reset()                    { *m = MemoryStats{} }
func (m *MemoryStats) String() string            { return proto.CompactTextString(m) }
func (*MemoryStats) ProtoMessage()               {}
func (*MemoryStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *MemoryStats) GetUsage() *MemoryData {
	if m != nil {
		return m.Usage
	}
	return nil
}

func (m *MemoryStats) GetSwapUsage() *MemoryData {
	if m != nil {
		return m.SwapUsage
	}
	return nil
}

func (m *MemoryStats) GetKernelUsage() *MemoryData {
	if m != nil {
		return m.KernelUsage
	}
	return nil
}

func (m *MemoryStats) GetStats() map[string]uint64 {
	if m != nil {
		return m.Stats
	}
	return nil
}

type BlkioStatsEntry struct {
	Major uint64 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor uint64 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Op    string `protobuf:"bytes,3,opt,name=op" json:"op,omitempty"`
	Value uint64 `protobuf:"varint,4,opt,name=value" json:"value,omitempty"`
}

func (m *BlkioStatsEntry) Reset()                    { *m = BlkioStatsEntry{} }
func (m *BlkioStatsEntry) String() string            { return proto.CompactTextString(m) }
func (*BlkioStatsEntry) ProtoMessage()               {}
func (*BlkioStatsEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

type BlkioStats struct {
	IoServiceBytesRecursive []*BlkioStatsEntry `protobuf:"bytes,1,rep,name=io_service_bytes_recursive,json=ioServiceBytesRecursive" json:"io_service_bytes_recursive,omitempty"`
	IoServicedRecursive     []*BlkioStatsEntry `protobuf:"bytes,2,rep,name=io_serviced_recursive,json=ioServicedRecursive" json:"io_serviced_recursive,omitempty"`
	IoQueuedRecursive       []*BlkioStatsEntry `protobuf:"bytes,3,rep,name=io_queued_recursive,json=ioQueuedRecursive" json:"io_queued_recursive,omitempty"`
	IoServiceTimeRecursive  []*BlkioStatsEntry `protobuf:"bytes,4,rep,name=io_service_time_recursive,json=ioServiceTimeRecursive" json:"io_service_time_recursive,omitempty"`
	IoWaitTimeRecursive     []*BlkioStatsEntry `protobuf:"bytes,5,rep,name=io_wait_time_recursive,json=ioWaitTimeRecursive" json:"io_wait_time_recursive,omitempty"`
	IoMergedRecursive       []*BlkioStatsEntry `protobuf:"bytes,6,rep,name=io_merged_recursive,json=ioMergedRecursive" json:"io_merged_recursive,omitempty"`
	IoTimeRecursive         []*BlkioStatsEntry `protobuf:"bytes,7,rep,name=io_time_recursive,json=ioTimeRecursive" json:"io_time_recursive,omitempty"`
	SectorsRecursive        []*BlkioStatsEntry `protobuf:"bytes,8,rep,name=sectors_recursive,json=sectorsRecursive" json:"sectors_recursive,omitempty"`
}

func (m *BlkioStats) Reset()                    { *m = BlkioStats{} }
func (m *BlkioStats) String() string            { return proto.CompactTextString(m) }
func (*BlkioStats) ProtoMessage()               {}
func (*BlkioStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *BlkioStats) GetIoServiceBytesRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServiceBytesRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoServicedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServicedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoQueuedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoQueuedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoServiceTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServiceTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoWaitTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoWaitTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoMergedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoMergedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetSectorsRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.SectorsRecursive
	}
	return nil
}

type HugetlbStats struct {
	Usage    uint64 `protobuf:"varint,1,opt,name=usage" json:"usage,omitempty"`
	MaxUsage uint64 `protobuf:"varint,2,opt,name=max_usage,json=maxUsage" json:"max_usage,omitempty"`
	Failcnt  uint64 `protobuf:"varint,3,opt,name=failcnt" json:"failcnt,omitempty"`
	Limit    uint64 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *HugetlbStats) Reset()                    { *m = HugetlbStats{} }
func (m *HugetlbStats) String() string            { return proto.CompactTextString(m) }
func (*HugetlbStats) ProtoMessage()               {}
func (*HugetlbStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

type CgroupStats struct {
	CpuStats     *CpuStats                `protobuf:"bytes,1,opt,name=cpu_stats,json=cpuStats" json:"cpu_stats,omitempty"`
	MemoryStats  *MemoryStats             `protobuf:"bytes,2,opt,name=memory_stats,json=memoryStats" json:"memory_stats,omitempty"`
	BlkioStats   *BlkioStats              `protobuf:"bytes,3,opt,name=blkio_stats,json=blkioStats" json:"blkio_stats,omitempty"`
	HugetlbStats map[string]*HugetlbStats `protobuf:"bytes,4,rep,name=hugetlb_stats,json=hugetlbStats" json:"hugetlb_stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	PidsStats    *PidsStats               `protobuf:"bytes,5,opt,name=pids_stats,json=pidsStats" json:"pids_stats,omitempty"`
}

func (m *CgroupStats) Reset()                    { *m = CgroupStats{} }
func (m *CgroupStats) String() string            { return proto.CompactTextString(m) }
func (*CgroupStats) ProtoMessage()               {}
func (*CgroupStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *CgroupStats) GetCpuStats() *CpuStats {
	if m != nil {
		return m.CpuStats
	}
	return nil
}

func (m *CgroupStats) GetMemoryStats() *MemoryStats {
	if m != nil {
		return m.MemoryStats
	}
	return nil
}

func (m *CgroupStats) GetBlkioStats() *BlkioStats {
	if m != nil {
		return m.BlkioStats
	}
	return nil
}

func (m *CgroupStats) GetHugetlbStats() map[string]*HugetlbStats {
	if m != nil {
		return m.HugetlbStats
	}
	return nil
}

func (m *CgroupStats) GetPidsStats() *PidsStats {
	if m != nil {
		return m.PidsStats
	}
	return nil
}

type StatsResponse struct {
	NetworkStats []*NetworkStats `protobuf:"bytes,1,rep,name=network_stats,json=networkStats" json:"network_stats,omitempty"`
	CgroupStats  *CgroupStats    `protobuf:"bytes,2,opt,name=cgroup_stats,json=cgroupStats" json:"cgroup_stats,omitempty"`
	// Tag 3 is deprecated (old uint64 timestamp)
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *StatsResponse) Reset()                    { *m = StatsResponse{} }
func (m *StatsResponse) String() string            { return proto.CompactTextString(m) }
func (*StatsResponse) ProtoMessage()               {}
func (*StatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *StatsResponse) GetNetworkStats() []*NetworkStats {
	if m != nil {
		return m.NetworkStats
	}
	return nil
}

func (m *StatsResponse) GetCgroupStats() *CgroupStats {
	if m != nil {
		return m.CgroupStats
	}
	return nil
}

func (m *StatsResponse) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type StatsRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *StatsRequest) Reset()                    { *m = StatsRequest{} }
func (m *StatsRequest) String() string            { return proto.CompactTextString(m) }
func (*StatsRequest) ProtoMessage()               {}
func (*StatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func init() {
	proto.RegisterType((*GetServerVersionRequest)(nil), "types.GetServerVersionRequest")
	proto.RegisterType((*GetServerVersionResponse)(nil), "types.GetServerVersionResponse")
	proto.RegisterType((*UpdateProcessRequest)(nil), "types.UpdateProcessRequest")
	proto.RegisterType((*UpdateProcessResponse)(nil), "types.UpdateProcessResponse")
	proto.RegisterType((*CreateContainerRequest)(nil), "types.CreateContainerRequest")
	proto.RegisterType((*CreateContainerResponse)(nil), "types.CreateContainerResponse")
	proto.RegisterType((*SignalRequest)(nil), "types.SignalRequest")
	proto.RegisterType((*SignalResponse)(nil), "types.SignalResponse")
	proto.RegisterType((*AddProcessRequest)(nil), "types.AddProcessRequest")
	proto.RegisterType((*Rlimit)(nil), "types.Rlimit")
	proto.RegisterType((*User)(nil), "types.User")
	proto.RegisterType((*AddProcessResponse)(nil), "types.AddProcessResponse")
	proto.RegisterType((*CreateCheckpointRequest)(nil), "types.CreateCheckpointRequest")
	proto.RegisterType((*CreateCheckpointResponse)(nil), "types.CreateCheckpointResponse")
	proto.RegisterType((*DeleteCheckpointRequest)(nil), "types.DeleteCheckpointRequest")
	proto.RegisterType((*DeleteCheckpointResponse)(nil), "types.DeleteCheckpointResponse")
	proto.RegisterType((*ListCheckpointRequest)(nil), "types.ListCheckpointRequest")
	proto.RegisterType((*Checkpoint)(nil), "types.Checkpoint")
	proto.RegisterType((*ListCheckpointResponse)(nil), "types.ListCheckpointResponse")
	proto.RegisterType((*StateRequest)(nil), "types.StateRequest")
	proto.RegisterType((*ContainerState)(nil), "types.ContainerState")
	proto.RegisterType((*Process)(nil), "types.Process")
	proto.RegisterType((*Container)(nil), "types.Container")
	proto.RegisterType((*Machine)(nil), "types.Machine")
	proto.RegisterType((*StateResponse)(nil), "types.StateResponse")
	proto.RegisterType((*UpdateContainerRequest)(nil), "types.UpdateContainerRequest")
	proto.RegisterType((*UpdateResource)(nil), "types.UpdateResource")
	proto.RegisterType((*UpdateContainerResponse)(nil), "types.UpdateContainerResponse")
	proto.RegisterType((*EventsRequest)(nil), "types.EventsRequest")
	proto.RegisterType((*Event)(nil), "types.Event")
	proto.RegisterType((*NetworkStats)(nil), "types.NetworkStats")
	proto.RegisterType((*CpuUsage)(nil), "types.CpuUsage")
	proto.RegisterType((*ThrottlingData)(nil), "types.ThrottlingData")
	proto.RegisterType((*CpuStats)(nil), "types.CpuStats")
	proto.RegisterType((*PidsStats)(nil), "types.PidsStats")
	proto.RegisterType((*MemoryData)(nil), "types.MemoryData")
	proto.RegisterType((*MemoryStats)(nil), "types.MemoryStats")
	proto.RegisterType((*BlkioStatsEntry)(nil), "types.BlkioStatsEntry")
	proto.RegisterType((*BlkioStats)(nil), "types.BlkioStats")
	proto.RegisterType((*HugetlbStats)(nil), "types.HugetlbStats")
	proto.RegisterType((*CgroupStats)(nil), "types.CgroupStats")
	proto.RegisterType((*StatsResponse)(nil), "types.StatsResponse")
	proto.RegisterType((*StatsRequest)(nil), "types.StatsRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion2

// Client API for API service

type APIClient interface {
	GetServerVersion(ctx context.Context, in *GetServerVersionRequest, opts ...grpc.CallOption) (*GetServerVersionResponse, error)
	CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error)
	UpdateContainer(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error)
	Signal(ctx context.Context, in *SignalRequest, opts ...grpc.CallOption) (*SignalResponse, error)
	UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*UpdateProcessResponse, error)
	AddProcess(ctx context.Context, in *AddProcessRequest, opts ...grpc.CallOption) (*AddProcessResponse, error)
	CreateCheckpoint(ctx context.Context, in *CreateCheckpointRequest, opts ...grpc.CallOption) (*CreateCheckpointResponse, error)
	DeleteCheckpoint(ctx context.Context, in *DeleteCheckpointRequest, opts ...grpc.CallOption) (*DeleteCheckpointResponse, error)
	ListCheckpoint(ctx context.Context, in *ListCheckpointRequest, opts ...grpc.CallOption) (*ListCheckpointResponse, error)
	State(ctx context.Context, in *StateRequest, opts ...grpc.CallOption) (*StateResponse, error)
	Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (API_EventsClient, error)
	Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (*StatsResponse, error)
}

type aPIClient struct {
	cc *grpc.ClientConn
}

func NewAPIClient(cc *grpc.ClientConn) APIClient {
	return &aPIClient{cc}
}

func (c *aPIClient) GetServerVersion(ctx context.Context, in *GetServerVersionRequest, opts ...grpc.CallOption) (*GetServerVersionResponse, error) {
	out := new(GetServerVersionResponse)
	err := grpc.Invoke(ctx, "/types.API/GetServerVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error) {
	out := new(CreateContainerResponse)
	err := grpc.Invoke(ctx, "/types.API/CreateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) UpdateContainer(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error) {
	out := new(UpdateContainerResponse)
	err := grpc.Invoke(ctx, "/types.API/UpdateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) Signal(ctx context.Context, in *SignalRequest, opts ...grpc.CallOption) (*SignalResponse, error) {
	out := new(SignalResponse)
	err := grpc.Invoke(ctx, "/types.API/Signal", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*UpdateProcessResponse, error) {
	out := new(UpdateProcessResponse)
	err := grpc.Invoke(ctx, "/types.API/UpdateProcess", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) AddProcess(ctx context.Context, in *AddProcessRequest, opts ...grpc.CallOption) (*AddProcessResponse, error) {
	out := new(AddProcessResponse)
	err := grpc.Invoke(ctx, "/types.API/AddProcess", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) CreateCheckpoint(ctx context.Context, in *CreateCheckpointRequest, opts ...grpc.CallOption) (*CreateCheckpointResponse, error) {
	out := new(CreateCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/CreateCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) DeleteCheckpoint(ctx context.Context, in *DeleteCheckpointRequest, opts ...grpc.CallOption) (*DeleteCheckpointResponse, error) {
	out := new(DeleteCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/DeleteCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) ListCheckpoint(ctx context.Context, in *ListCheckpointRequest, opts ...grpc.CallOption) (*ListCheckpointResponse, error) {
	out := new(ListCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/ListCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) State(ctx context.Context, in *StateRequest, opts ...grpc.CallOption) (*StateResponse, error) {
	out := new(StateResponse)
	err := grpc.Invoke(ctx, "/types.API/State", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (API_EventsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_API_serviceDesc.Streams[0], c.cc, "/types.API/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &aPIEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type API_EventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type aPIEventsClient struct {
	grpc.ClientStream
}

func (x *aPIEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aPIClient) Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (*StatsResponse, error) {
	out := new(StatsResponse)
	err := grpc.Invoke(ctx, "/types.API/Stats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for API service

type APIServer interface {
	GetServerVersion(context.Context, *GetServerVersionRequest) (*GetServerVersionResponse, error)
	CreateContainer(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error)
	UpdateContainer(context.Context, *UpdateContainerRequest) (*UpdateContainerResponse, error)
	Signal(context.Context, *SignalRequest) (*SignalResponse, error)
	UpdateProcess(context.Context, *UpdateProcessRequest) (*UpdateProcessResponse, error)
	AddProcess(context.Context, *AddProcessRequest) (*AddProcessResponse, error)
	CreateCheckpoint(context.Context, *CreateCheckpointRequest) (*CreateCheckpointResponse, error)
	DeleteCheckpoint(context.Context, *DeleteCheckpointRequest) (*DeleteCheckpointResponse, error)
	ListCheckpoint(context.Context, *ListCheckpointRequest) (*ListCheckpointResponse, error)
	State(context.Context, *StateRequest) (*StateResponse, error)
	Events(*EventsRequest, API_EventsServer) error
	Stats(context.Context, *StatsRequest) (*StatsResponse, error)
}

func RegisterAPIServer(s *grpc.Server, srv APIServer) {
	s.RegisterService(&_API_serviceDesc, srv)
}

func _API_GetServerVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).GetServerVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/GetServerVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).GetServerVersion(ctx, req.(*GetServerVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_CreateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).CreateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/CreateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).CreateContainer(ctx, req.(*CreateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_UpdateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).UpdateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/UpdateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).UpdateContainer(ctx, req.(*UpdateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_Signal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).Signal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/Signal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).Signal(ctx, req.(*SignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_UpdateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).UpdateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/UpdateProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).UpdateProcess(ctx, req.(*UpdateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_AddProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).AddProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/AddProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).AddProcess(ctx, req.(*AddProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_CreateCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).CreateCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/CreateCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).CreateCheckpoint(ctx, req.(*CreateCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_DeleteCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).DeleteCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/DeleteCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).DeleteCheckpoint(ctx, req.(*DeleteCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_ListCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).ListCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/ListCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).ListCheckpoint(ctx, req.(*ListCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_State_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).State(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/State",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).State(ctx, req.(*StateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(APIServer).Events(m, &aPIEventsServer{stream})
}

type API_EventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type aPIEventsServer struct {
	grpc.ServerStream
}

func (x *aPIEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _API_Stats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).Stats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/Stats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).Stats(ctx, req.(*StatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _API_serviceDesc = grpc.ServiceDesc{
	ServiceName: "types.API",
	HandlerType: (*APIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetServerVersion",
			Handler:    _API_GetServerVersion_Handler,
		},
		{
			MethodName: "CreateContainer",
			Handler:    _API_CreateContainer_Handler,
		},
		{
			MethodName: "UpdateContainer",
			Handler:    _API_UpdateContainer_Handler,
		},
		{
			MethodName: "Signal",
			Handler:    _API_Signal_Handler,
		},
		{
			MethodName: "UpdateProcess",
			Handler:    _API_UpdateProcess_Handler,
		},
		{
			MethodName: "AddProcess",
			Handler:    _API_AddProcess_Handler,
		},
		{
			MethodName: "CreateCheckpoint",
			Handler:    _API_CreateCheckpoint_Handler,
		},
		{
			MethodName: "DeleteCheckpoint",
			Handler:    _API_DeleteCheckpoint_Handler,
		},
		{
			MethodName: "ListCheckpoint",
			Handler:    _API_ListCheckpoint_Handler,
		},
		{
			MethodName: "State",
			Handler:    _API_State_Handler,
		},
		{
			MethodName: "Stats",
			Handler:    _API_Stats_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Events",
			Handler:       _API_Events_Handler,
			ServerStreams: true,
		},
	},
}

var fileDescriptor0 = []byte{
	// 2414 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xec, 0x59, 0xcd, 0x73, 0x1b, 0x4b,
	0x11, 0x8f, 0xa4, 0xb5, 0x6c, 0xb5, 0x3e, 0x6c, 0x6f, 0xfc, 0xa1, 0xe8, 0xbd, 0x7c, 0xb0, 0xf5,
	0x80, 0x00, 0xaf, 0x94, 0xa0, 0xbc, 0x57, 0xa4, 0xa0, 0x8a, 0xaa, 0xc4, 0x0e, 0x8f, 0xf0, 0xe2,
	0x3c, 0x65, 0x6d, 0xf3, 0x8e, 0xaa, 0xb5, 0x76, 0x22, 0x2d, 0x5e, 0xed, 0x6e, 0x76, 0x47, 0xb6,
	0x7c, 0xe1, 0xc0, 0x01, 0x6e, 0x70, 0xa5, 0x0a, 0x6e, 0xdc, 0xb8, 0x73, 0x80, 0x7f, 0x80, 0x2a,
	0xfe, 0x10, 0x6e, 0xdc, 0x39, 0xd2, 0xf3, 0xb9, 0xb3, 0xfa, 0xb0, 0x93, 0x03, 0xc5, 0x85, 0x8b,
	0x6a, 0xfa, 0x37, 0x3d, 0xdd, 0x3d, 0x3d, 0xdd, 0x3d, 0xbd, 0x23, 0xa8, 0x79, 0x49, 0xd0, 0x4d,
	0xd2, 0x98, 0xc6, 0xf6, 0x1a, 0xbd, 0x4a, 0x48, 0xd6, 0xb9, 0x3f, 0x8a, 0xe3, 0x51, 0x48, 0x1e,
	0x71, 0xf0, 0x6c, 0xfa, 0xf6, 0x11, 0x0d, 0x26, 0x24, 0xa3, 0xde, 0x24, 0x11, 0x7c, 0xce, 0x1d,
	0xd8, 0xff, 0x82, 0xd0, 0x63, 0x92, 0x5e, 0x90, 0xf4, 0xe7, 0x24, 0xcd, 0x82, 0x38, 0x72, 0xc9,
	0xbb, 0x29, 0xf2, 0x38, 0x33, 0x68, 0x2f, 0x4e, 0x65, 0x49, 0x1c, 0x65, 0xc4, 0xde, 0x81, 0xb5,
	0x89, 0xf7, 0x8b, 0x38, 0x6d, 0x97, 0x1e, 0x94, 0x1e, 0x36, 0x5d, 0x41, 0x70, 0x34, 0x88, 0x10,
	0x2d, 0x4b, 0x94, 0x11, 0x0c, 0x4d, 0x3c, 0x3a, 0x1c, 0xb7, 0x2b, 0x02, 0xe5, 0x84, 0xdd, 0x81,
	0x8d, 0x94, 0x5c, 0x04, 0x4c, 0x6a, 0xdb, 0xc2, 0x89, 0x9a, 0xab, 0x69, 0xe7, 0xd7, 0x25, 0xd8,
	0x39, 0x4d, 0x7c, 0x8f, 0x92, 0x7e, 0x1a, 0x0f, 0x49, 0x96, 0x49, 0x93, 0xec, 0x16, 0x94, 0x03,
	0x9f, 0xeb, 0xac, 0xb9, 0x38, 0xb2, 0xb7, 0xa0, 0x92, 0x20, 0x50, 0xe6, 0x00, 0x1b, 0xda, 0xf7,
	0x00, 0x86, 0x61, 0x9c, 0x91, 0x63, 0xea, 0x07, 0x11, 0xd7, 0xb8, 0xe1, 0x1a, 0x08, 0x33, 0xe6,
	0x32, 0xf0, 0xe9, 0x98, 0xeb, 0x44, 0x63, 0x38, 0x61, 0xef, 0x41, 0x75, 0x4c, 0x82, 0xd1, 0x98,
	0xb6, 0xd7, 0x38, 0x2c, 0x29, 0x67, 0x1f, 0x76, 0xe7, 0xec, 0x10, 0xfb, 0x77, 0xfe, 0x51, 0x86,
	0xbd, 0x83, 0x94, 0xe0, 0xcc, 0x41, 0x1c, 0x51, 0x2f, 0x88, 0x48, 0xba, 0xca, 0x46, 0xb4, 0xe8,
	0x6c, 0x1a, 0xf9, 0x21, 0xe9, 0x7b, 0xa8, 0x56, 0x98, 0x6a, 0x20, 0xdc, 0xe2, 0x31, 0x19, 0x9e,
	0x27, 0x71, 0x10, 0x51, 0x6e, 0x31, 0xce, 0xe7, 0x08, 0xb3, 0x38, 0xe3, 0x9b, 0x11, 0x5e, 0x12,
	0x04, 0xb3, 0x18, 0x07, 0xf1, 0x54, 0x58, 0x5c, 0x73, 0x25, 0x25, 0x71, 0x92, 0xa6, 0xed, 0xaa,
	0xc6, 0x91, 0x62, 0x78, 0xe8, 0x9d, 0x91, 0x30, 0x6b, 0xaf, 0x3f, 0xa8, 0x30, 0x5c, 0x50, 0xf6,
	0x03, 0xa8, 0x47, 0x71, 0x3f, 0xb8, 0x88, 0xa9, 0x1b, 0xc7, 0xb4, 0xbd, 0xc1, 0x1d, 0x66, 0x42,
	0x76, 0x1b, 0xd6, 0xd3, 0x69, 0xc4, 0xe2, 0xa6, 0x5d, 0xe3, 0x22, 0x15, 0xc9, 0xd6, 0xca, 0xe1,
	0xb3, 0x74, 0x94, 0xb5, 0x81, 0x0b, 0x36, 0x21, 0xfb, 0x13, 0x68, 0xe6, 0x3b, 0x39, 0x0c, 0xd2,
	0x76, 0x9d, 0x4b, 0x28, 0x82, 0xce, 0x4b, 0xd8, 0x5f, 0xf0, 0xa5, 0x8c, 0xb3, 0x2e, 0xd4, 0x86,
	0x0a, 0xe4, 0x3e, 0xad, 0xf7, 0xb6, 0xba, 0x3c, 0xb4, 0xbb, 0x39, 0x73, 0xce, 0x82, 0xa2, 0x9a,
	0xc7, 0xc1, 0x28, 0xf2, 0xc2, 0xf7, 0x8f, 0x18, 0xe6, 0x31, 0xbe, 0x44, 0xc6, 0xa7, 0xa4, 0x9c,
	0x2d, 0x68, 0x29, 0x51, 0xf2, 0xd0, 0xff, 0x52, 0x81, 0xed, 0x67, 0xbe, 0x7f, 0x43, 0x4c, 0x62,
	0x60, 0x53, 0x92, 0x62, 0xe8, 0xa3, 0xc4, 0x32, 0x77, 0xa7, 0xa6, 0xed, 0xfb, 0x60, 0x4d, 0x33,
	0xdc, 0x49, 0x85, 0xef, 0xa4, 0x2e, 0x77, 0x72, 0x8a, 0x90, 0xcb, 0x27, 0x6c, 0x1b, 0x2c, 0x8f,
	0xf9, 0xd2, 0xe2, 0xbe, 0xe4, 0x63, 0x66, 0x32, 0x89, 0x2e, 0xf0, 0x9c, 0x19, 0xc4, 0x86, 0x0c,
	0x19, 0x5e, 0xfa, 0xf2, 0x84, 0xd9, 0x50, 0x6d, 0x6b, 0x3d, 0xdf, 0x96, 0x0e, 0x9b, 0x8d, 0xe5,
	0x61, 0x53, 0x5b, 0x11, 0x36, 0x50, 0x08, 0x1b, 0x07, 0x1a, 0x43, 0x2f, 0xf1, 0xce, 0x82, 0x30,
	0xa0, 0x01, 0xc9, 0xf0, 0xfc, 0x98, 0x11, 0x05, 0xcc, 0x7e, 0x08, 0x9b, 0x5e, 0x92, 0x78, 0xe9,
	0x24, 0x4e, 0xd1, 0x35, 0x6f, 0x83, 0x90, 0xb4, 0x1b, 0x5c, 0xc8, 0x3c, 0xcc, 0xa4, 0x65, 0x24,
	0x0c, 0xa2, 0xe9, 0xec, 0x15, 0x8b, 0xbe, 0x76, 0x93, 0xb3, 0x15, 0x30, 0x26, 0x2d, 0x8a, 0x5f,
	0x93, 0xcb, 0x7e, 0x1a, 0x5c, 0xe0, 0x9a, 0x11, 0x2a, 0x6d, 0x71, 0x2f, 0xce, 0xc3, 0xf6, 0xb7,
	0x31, 0x30, 0xc3, 0x60, 0x12, 0xd0, 0xac, 0xbd, 0x89, 0x66, 0xd5, 0x7b, 0x4d, 0xe9, 0x4f, 0x97,
	0xa3, 0xae, 0x9a, 0x75, 0x0e, 0xa1, 0x2a, 0x20, 0xe6, 0x5e, 0xc6, 0x22, 0x4f, 0x8b, 0x8f, 0x19,
	0x96, 0xc5, 0x6f, 0x29, 0x3f, 0x2b, 0xcb, 0xe5, 0x63, 0x86, 0x8d, 0xbd, 0xd4, 0xe7, 0xe7, 0x84,
	0x18, 0x1b, 0x3b, 0x2e, 0x58, 0xec, 0xa0, 0x98, 0xab, 0xa7, 0xf2, 0xc0, 0x9b, 0x2e, 0x1b, 0x32,
	0x64, 0x24, 0x63, 0x0a, 0x11, 0x1c, 0xda, 0xdf, 0x82, 0x96, 0xe7, 0xfb, 0xe8, 0x9e, 0x18, 0x4f,
	0xfd, 0x8b, 0xc0, 0xcf, 0x50, 0x52, 0x05, 0x27, 0xe7, 0x50, 0x67, 0x07, 0x6c, 0x33, 0xa0, 0x64,
	0x9c, 0xfd, 0xaa, 0xa4, 0x13, 0x42, 0xe7, 0xc9, 0xaa, 0x68, 0xfb, 0x7e, 0xa1, 0x7a, 0x94, 0x79,
	0x5c, 0x6d, 0xab, 0x0c, 0xc9, 0x57, 0x9b, 0x05, 0x65, 0x21, 0x29, 0x2b, 0xcb, 0x92, 0xb2, 0x03,
	0xed, 0x45, 0x1b, 0xa4, 0x81, 0x43, 0xd8, 0x3f, 0x24, 0x21, 0x79, 0x1f, 0xfb, 0xd0, 0x93, 0x91,
	0x87, 0xa5, 0x43, 0x24, 0x1c, 0x1f, 0xbf, 0xbf, 0x01, 0x8b, 0x4a, 0xa4, 0x01, 0x47, 0xb0, 0xfb,
	0x2a, 0xc8, 0xe8, 0xcd, 0xea, 0x17, 0x54, 0x95, 0x97, 0xa9, 0xfa, 0x7d, 0x09, 0x20, 0x97, 0xa5,
	0x6d, 0x2e, 0x19, 0x36, 0x23, 0x46, 0x66, 0x01, 0x95, 0x19, 0xcd, 0xc7, 0xec, 0xdc, 0xe9, 0x30,
	0x91, 0x97, 0x0c, 0x1b, 0xb2, 0x8a, 0x38, 0x8d, 0x82, 0xd9, 0x71, 0x3c, 0x3c, 0x27, 0x34, 0xe3,
	0x15, 0x1b, 0xab, 0xa9, 0x01, 0xf1, 0xb4, 0x1c, 0x93, 0x30, 0xe4, 0x65, 0x7b, 0xc3, 0x15, 0x04,
	0xab, 0xb1, 0x64, 0x92, 0xd0, 0xab, 0xd7, 0xc7, 0x98, 0xd4, 0x2c, 0xc3, 0x14, 0x89, 0x3b, 0xdd,
	0x9b, 0xdf, 0xa9, 0x2c, 0x8d, 0x4f, 0xa0, 0x9e, 0xef, 0x22, 0x43, 0x63, 0x2b, 0xcb, 0x8f, 0xde,
	0xe4, 0x72, 0xee, 0x41, 0xe3, 0x98, 0xe2, 0xa1, 0xae, 0xf0, 0x97, 0xf3, 0x10, 0x5a, 0xba, 0xae,
	0x72, 0x46, 0x51, 0x19, 0x3c, 0x3a, 0xcd, 0x24, 0x97, 0xa4, 0x9c, 0xbf, 0x56, 0x60, 0x5d, 0x06,
	0xae, 0xaa, 0x3e, 0xa5, 0xbc, 0xfa, 0xfc, 0x4f, 0x8a, 0xe0, 0xc7, 0x50, 0xcb, 0xae, 0x32, 0x4a,
	0x26, 0x7d, 0x59, 0x0a, 0x9b, 0x6e, 0x0e, 0xfc, 0xbf, 0x20, 0xe6, 0x05, 0xf1, 0xef, 0x25, 0xa8,
	0xe9, 0x63, 0xfe, 0xe0, 0x86, 0xe5, 0x53, 0xa8, 0x25, 0xe2, 0xe0, 0x89, 0xa8, 0x6b, 0xf5, 0x5e,
	0x4b, 0x2a, 0x52, 0x95, 0x2c, 0x67, 0x30, 0xe2, 0xc7, 0x32, 0xe3, 0xc7, 0x68, 0x48, 0xd6, 0x0a,
	0x0d, 0x09, 0x1e, 0x7e, 0xc2, 0x0a, 0x66, 0x95, 0x17, 0x4c, 0x3e, 0x36, 0x5b, 0x90, 0xf5, 0x42,
	0x0b, 0xe2, 0x7c, 0x0e, 0xeb, 0x47, 0xde, 0x70, 0x8c, 0xfb, 0x60, 0x0b, 0x87, 0x89, 0x0c, 0x53,
	0x5c, 0xc8, 0xc6, 0x4c, 0xc9, 0x84, 0xa0, 0xbf, 0xaf, 0x64, 0x75, 0x97, 0x94, 0x73, 0x8e, 0x6d,
	0x82, 0x48, 0x03, 0x99, 0x4c, 0x8f, 0xb1, 0x8c, 0x2a, 0x87, 0xa8, 0x5c, 0x5a, 0x6c, 0x34, 0x0c,
	0x1e, 0x3c, 0x96, 0xf5, 0x89, 0xd0, 0x2c, 0xab, 0xae, 0xf2, 0x81, 0xb4, 0xc7, 0x55, 0xd3, 0xce,
	0x6f, 0x4a, 0xb0, 0x27, 0xba, 0xc8, 0x1b, 0x7b, 0xc5, 0xe5, 0xdd, 0x89, 0x70, 0x5f, 0xa5, 0xe0,
	0xbe, 0x27, 0x50, 0x4b, 0x49, 0x16, 0x4f, 0x53, 0x74, 0x33, 0xf7, 0x6c, 0xbd, 0xb7, 0xab, 0x32,
	0x89, 0xeb, 0x72, 0xe5, 0xac, 0x9b, 0xf3, 0x39, 0x7f, 0xac, 0x40, 0xab, 0x38, 0xcb, 0x2a, 0xd6,
	0x59, 0x78, 0x1e, 0xc4, 0x5f, 0x8b, 0xf6, 0xb7, 0xc4, 0xdd, 0x64, 0x42, 0x2c, 0xab, 0xd0, 0x97,
	0xc7, 0x78, 0x07, 0xa2, 0x26, 0xe1, 0xc6, 0x1c, 0x90, 0xb3, 0x7d, 0x92, 0x06, 0xb1, 0xba, 0x2e,
	0x73, 0x80, 0x95, 0x01, 0x24, 0xde, 0x4c, 0x63, 0xea, 0x71, 0x23, 0x2d, 0x57, 0xd3, 0xbc, 0xef,
	0xc5, 0x33, 0x22, 0xf4, 0x80, 0x9d, 0xda, 0x9a, 0xec, 0x7b, 0x35, 0x92, 0xcf, 0x1f, 0x91, 0x49,
	0x26, 0xd3, 0xdc, 0x40, 0x98, 0xe5, 0xe2, 0x34, 0x5f, 0xb1, 0xa0, 0xe6, 0x81, 0x81, 0x96, 0x1b,
	0x10, 0x93, 0x20, 0xc8, 0xe3, 0x4b, 0x2f, 0xe1, 0x69, 0x6f, 0xb9, 0x06, 0x82, 0x81, 0xbc, 0x2d,
	0x28, 0xf4, 0x06, 0x7e, 0xe5, 0x78, 0xec, 0x62, 0xe6, 0x65, 0xc0, 0x72, 0x17, 0x27, 0x18, 0xf7,
	0x39, 0x49, 0x23, 0x12, 0x1e, 0x19, 0x5a, 0x41, 0x70, 0x2f, 0x4c, 0xd8, 0x3d, 0xd8, 0x11, 0xe0,
	0xc9, 0x41, 0xdf, 0x5c, 0x50, 0xe7, 0x0b, 0x96, 0xce, 0xb1, 0x6f, 0xb1, 0x85, 0x38, 0x91, 0x17,
	0xde, 0x15, 0x34, 0x5f, 0x5c, 0x10, 0xac, 0xe0, 0x2a, 0x72, 0x9e, 0x42, 0x4d, 0x7f, 0xca, 0xc9,
	0x00, 0xec, 0x74, 0xc5, 0xc7, 0x5e, 0x57, 0x7d, 0xec, 0x75, 0x4f, 0x14, 0x87, 0x9b, 0x33, 0x33,
	0xaf, 0x64, 0x34, 0x4e, 0x89, 0xff, 0x55, 0x14, 0x5e, 0xa9, 0x2f, 0xa4, 0x1c, 0x91, 0x31, 0x69,
	0xe9, 0x2b, 0xe1, 0x77, 0x25, 0x58, 0xe3, 0xba, 0x97, 0x76, 0x4f, 0x82, 0xbb, 0xac, 0x23, 0xb8,
	0x18, 0xaf, 0x4d, 0x1d, 0xaf, 0x32, 0xb2, 0xad, 0x3c, 0xb2, 0x0b, 0x3b, 0xa8, 0x7e, 0xc0, 0x0e,
	0x9c, 0xdf, 0x96, 0xa1, 0xf1, 0x9a, 0xd0, 0xcb, 0x38, 0x3d, 0x67, 0x59, 0x9c, 0x2d, 0xbd, 0xb0,
	0xef, 0xe0, 0xf7, 0xe5, 0x6c, 0x70, 0x76, 0x45, 0x75, 0xd4, 0xae, 0xa7, 0xb3, 0xe7, 0x8c, 0xb4,
	0xef, 0x02, 0xe0, 0x54, 0xdf, 0x13, 0x97, 0xb4, 0x0c, 0xda, 0x74, 0x26, 0x01, 0xfb, 0x23, 0xa8,
	0xb9, 0xb3, 0x01, 0x16, 0xfb, 0x38, 0xcd, 0x54, 0xd4, 0xa6, 0xb3, 0x17, 0x9c, 0x66, 0x6b, 0x71,
	0xd2, 0x4f, 0xe3, 0x24, 0x21, 0x3e, 0x8f, 0x5a, 0xbe, 0xf6, 0x50, 0x00, 0x4c, 0xeb, 0x89, 0xd2,
	0x5a, 0x15, 0x5a, 0x69, 0xae, 0x15, 0xa7, 0x12, 0xa9, 0x55, 0x84, 0x6b, 0x8d, 0x9a, 0x5a, 0x4f,
	0xb4, 0x56, 0x11, 0xab, 0x1b, 0xd4, 0xd0, 0x7a, 0x92, 0x6b, 0xad, 0xa9, 0xb5, 0x52, 0xab, 0xf3,
	0xe7, 0x12, 0x6c, 0x60, 0xce, 0x9c, 0x66, 0xde, 0x88, 0xe0, 0xf5, 0x5a, 0xa7, 0x98, 0x5f, 0xe1,
	0x60, 0xca, 0x48, 0x99, 0xd1, 0xc0, 0x21, 0xc1, 0xf0, 0x0d, 0x68, 0x24, 0x24, 0xc5, 0x4c, 0x92,
	0x1c, 0x65, 0xac, 0x76, 0x98, 0x39, 0x02, 0x13, 0x2c, 0x5d, 0xb8, 0xcd, 0xe7, 0x06, 0x41, 0x34,
	0x10, 0xa1, 0x3a, 0x89, 0x7d, 0x22, 0x5d, 0xb5, 0xcd, 0xa7, 0x5e, 0x46, 0x5f, 0xea, 0x09, 0xfb,
	0xbb, 0xb0, 0xad, 0xf9, 0xd9, 0x15, 0xce, 0xb9, 0x85, 0xeb, 0x36, 0x25, 0xf7, 0xa9, 0x84, 0x9d,
	0x5f, 0x42, 0xeb, 0x64, 0x8c, 0xe7, 0x4b, 0xf1, 0x8e, 0x1b, 0x1d, 0x7a, 0x58, 0x09, 0xb0, 0xbc,
	0x27, 0xbc, 0x5e, 0x64, 0xd2, 0x5a, 0x45, 0xda, 0xdf, 0x83, 0x6d, 0x2a, 0x78, 0x89, 0x3f, 0x50,
	0x3c, 0xe2, 0x34, 0xb7, 0xf4, 0x44, 0x5f, 0x32, 0x7f, 0x13, 0x5a, 0x39, 0x33, 0xbf, 0x2c, 0x84,
	0xbd, 0x4d, 0x8d, 0xb2, 0x68, 0x72, 0xfe, 0x20, 0x9c, 0x25, 0x22, 0xe7, 0x53, 0x5e, 0xbe, 0x0c,
	0x57, 0xd5, 0x7b, 0x9b, 0xaa, 0xec, 0x4b, 0x67, 0xf0, 0x92, 0x25, 0xdc, 0xf2, 0x63, 0xd8, 0xa4,
	0xda, 0xf4, 0x01, 0x66, 0xaa, 0x27, 0x53, 0x4f, 0x95, 0xde, 0xe2, 0xc6, 0xdc, 0x16, 0x2d, 0x6e,
	0x14, 0x3d, 0x2f, 0xfa, 0x11, 0xa9, 0x50, 0xd8, 0x57, 0x17, 0x18, 0x57, 0xe1, 0xfc, 0x08, 0x6a,
	0xd8, 0xac, 0x64, 0xc2, 0x3a, 0x74, 0xcc, 0x70, 0x9a, 0xa6, 0x98, 0x7b, 0xca, 0x31, 0x92, 0x64,
	0xcd, 0x0c, 0xbf, 0xcb, 0xa5, 0x33, 0x04, 0xe1, 0xc4, 0x00, 0xa2, 0x9e, 0x70, 0x6d, 0xc8, 0x63,
	0x86, 0x80, 0x20, 0x58, 0x9c, 0x4d, 0xbc, 0x99, 0x3e, 0x7a, 0x1e, 0x67, 0x08, 0x88, 0x0d, 0xa2,
	0xc2, 0xb7, 0x5e, 0x10, 0x0e, 0xe5, 0x43, 0x04, 0x2a, 0x94, 0x64, 0xae, 0xd0, 0x32, 0x15, 0xfe,
	0xa9, 0x0c, 0x75, 0xa1, 0x51, 0x18, 0x8c, 0x5c, 0x43, 0xbc, 0xf5, 0xb4, 0x4a, 0x4e, 0x60, 0x5f,
	0xb2, 0x96, 0xab, 0xcb, 0x7b, 0xd4, 0xdc, 0x54, 0x65, 0x1b, 0xde, 0xc2, 0x19, 0x16, 0x66, 0xc3,
	0x3b, 0x4b, 0xb9, 0x6b, 0x8c, 0x49, 0x18, 0xfc, 0x19, 0x34, 0x44, 0x7c, 0xca, 0x35, 0xd6, 0xaa,
	0x35, 0x75, 0xc1, 0x26, 0x56, 0x3d, 0x61, 0xad, 0x20, 0xda, 0xcb, 0x5b, 0x8f, 0x7a, 0xef, 0x6e,
	0x81, 0x9d, 0xef, 0xa4, 0xcb, 0x7f, 0x5f, 0x44, 0x14, 0xef, 0x00, 0xc1, 0xdb, 0x79, 0x0a, 0x90,
	0x83, 0xac, 0x9e, 0x9d, 0x93, 0x2b, 0xd5, 0xf2, 0xe2, 0x90, 0xed, 0xfd, 0xc2, 0x0b, 0xa7, 0xca,
	0xa9, 0x82, 0xf8, 0x61, 0xf9, 0x69, 0x09, 0x3f, 0x97, 0x36, 0x9f, 0xb3, 0x0b, 0xd5, 0x58, 0x5e,
	0x78, 0x3f, 0xb3, 0x96, 0xbe, 0x9f, 0x59, 0xea, 0xfd, 0x0c, 0x4b, 0x6c, 0x9c, 0xc8, 0xeb, 0x1f,
	0x47, 0xb9, 0x22, 0xcb, 0x50, 0xe4, 0xfc, 0xd3, 0x02, 0xc8, 0xb5, 0xd8, 0xc7, 0xd0, 0x09, 0xe2,
	0x01, 0xbb, 0xbd, 0x82, 0x21, 0x11, 0x05, 0x69, 0x90, 0x12, 0x0c, 0x9f, 0x2c, 0xb8, 0x20, 0xb2,
	0xc1, 0xd9, 0x93, 0xfb, 0x9e, 0x33, 0xce, 0xdd, 0x47, 0x4a, 0x2c, 0xe4, 0x95, 0xcb, 0x55, 0xcb,
	0xec, 0x9f, 0xc1, 0x6e, 0x2e, 0xd4, 0x37, 0xe4, 0x95, 0xaf, 0x95, 0x77, 0x5b, 0xcb, 0xf3, 0x73,
	0x59, 0x3f, 0x01, 0x84, 0x07, 0x78, 0x99, 0x4d, 0x0b, 0x92, 0x2a, 0xd7, 0x4a, 0xda, 0x0e, 0xe2,
	0x37, 0x7c, 0x45, 0x2e, 0xe7, 0x0d, 0xdc, 0x31, 0x36, 0xca, 0xd2, 0xde, 0x90, 0x66, 0x5d, 0x2b,
	0x6d, 0x4f, 0xdb, 0xc5, 0x0a, 0x43, 0x2e, 0xf2, 0x4b, 0xc0, 0x99, 0xc1, 0xa5, 0x17, 0xd0, 0x79,
	0x79, 0x6b, 0x37, 0xed, 0xf3, 0x6b, 0x5c, 0x54, 0x14, 0x26, 0xf6, 0x39, 0x21, 0xe9, 0xa8, 0xb0,
	0xcf, 0xea, 0x4d, 0xfb, 0x3c, 0xe2, 0x2b, 0x72, 0x39, 0xcf, 0x01, 0xc1, 0x79, 0x7b, 0xd6, 0xaf,
	0x95, 0xb2, 0x19, 0xc4, 0x45, 0x5b, 0x0e, 0x60, 0x3b, 0x23, 0x43, 0xbc, 0xea, 0xcd, 0x58, 0xd8,
	0xb8, 0x56, 0xc6, 0x96, 0x5c, 0xa0, 0x85, 0x38, 0xef, 0xa0, 0xf1, 0xd3, 0xe9, 0x88, 0xd0, 0xf0,
	0x4c, 0xe7, 0xfc, 0x7f, 0xbb, 0xcc, 0xfc, 0x1b, 0xcb, 0xcc, 0xc1, 0x28, 0x8d, 0xa7, 0x49, 0xa1,
	0x6a, 0x8b, 0x1c, 0x5e, 0xa8, 0xda, 0x9c, 0x87, 0x57, 0x6d, 0xc1, 0xfd, 0x39, 0x34, 0x44, 0x37,
	0x27, 0x17, 0x88, 0x2a, 0x64, 0x2f, 0x26, 0xbd, 0xea, 0x1e, 0xc5, 0xb2, 0x9e, 0xec, 0x8c, 0xe5,
	0xaa, 0x62, 0x35, 0xca, 0xdd, 0x84, 0x9f, 0x46, 0x79, 0xd6, 0xbd, 0x84, 0xe6, 0x58, 0xf8, 0x46,
	0xae, 0x12, 0x01, 0xf8, 0x89, 0x32, 0x2e, 0xdf, 0x43, 0xd7, 0xf4, 0xa1, 0x70, 0x75, 0x63, 0x6c,
	0xba, 0xf5, 0x11, 0x00, 0xfb, 0xf6, 0x19, 0xa8, 0x42, 0x65, 0x3e, 0x7d, 0xea, 0x1b, 0x02, 0x3f,
	0xb4, 0xd4, 0xb0, 0x73, 0x02, 0xdb, 0x0b, 0x32, 0x97, 0x94, 0xa9, 0xef, 0x98, 0x65, 0xaa, 0xde,
	0xbb, 0x2d, 0x45, 0x9a, 0x4b, 0xcd, 0xda, 0xf5, 0xb7, 0x92, 0xf8, 0x54, 0xd2, 0xaf, 0x53, 0xd8,
	0xb7, 0x35, 0x23, 0xd1, 0x7c, 0xe9, 0x03, 0xa8, 0x18, 0x82, 0xcc, 0xc6, 0xcc, 0x6d, 0x44, 0x66,
	0x9b, 0x86, 0x07, 0x31, 0xe4, 0x1e, 0x58, 0x7a, 0x10, 0x86, 0x73, 0xdc, 0xfa, 0xd0, 0x38, 0xed,
	0x42, 0xa3, 0x68, 0x7d, 0x48, 0xa3, 0x28, 0x5f, 0x3b, 0x56, 0x3d, 0xd5, 0xf6, 0xfe, 0x55, 0x85,
	0xca, 0xb3, 0xfe, 0x4b, 0xfb, 0x14, 0xb6, 0xe6, 0xff, 0xe9, 0xb0, 0xef, 0x49, 0xb3, 0x56, 0xfc,
	0x3b, 0xd2, 0xb9, 0xbf, 0x72, 0x5e, 0xb6, 0xec, 0xb7, 0x6c, 0x17, 0x36, 0xe7, 0xde, 0xb5, 0x6d,
	0x75, 0xd5, 0x2c, 0xff, 0xef, 0xa0, 0x73, 0x6f, 0xd5, 0xb4, 0x29, 0x73, 0xee, 0x1b, 0x41, 0xcb,
	0x5c, 0xfe, 0x8d, 0xa9, 0x65, 0xae, 0xfa, 0xb4, 0xb8, 0x65, 0xff, 0x00, 0xaa, 0xe2, 0xa5, 0xdb,
	0xde, 0x91, 0xbc, 0x85, 0x37, 0xf4, 0xce, 0xee, 0x1c, 0xaa, 0x17, 0xbe, 0x82, 0x66, 0xe1, 0xef,
	0x11, 0xfb, 0xa3, 0x82, 0xae, 0xe2, 0x43, 0x79, 0xe7, 0xe3, 0xe5, 0x93, 0x5a, 0xda, 0x01, 0x40,
	0xfe, 0x18, 0x6a, 0xb7, 0x25, 0xf7, 0xc2, 0x83, 0x7b, 0xe7, 0xce, 0x92, 0x19, 0x2d, 0x04, 0x8f,
	0x72, 0xfe, 0xd9, 0xd2, 0x9e, 0xf3, 0xea, 0xfc, 0xa3, 0xa1, 0x3e, 0xca, 0x95, 0xef, 0x9d, 0x5c,
	0xec, 0xfc, 0x63, 0xa4, 0x16, 0xbb, 0xe2, 0x29, 0x54, 0x8b, 0x5d, 0xf9, 0x8a, 0x79, 0xcb, 0xfe,
	0x0a, 0x5a, 0xc5, 0xd7, 0x3d, 0x5b, 0x39, 0x69, 0xe9, 0xf3, 0x66, 0xe7, 0xee, 0x8a, 0x59, 0x2d,
	0xf0, 0x33, 0x58, 0x13, 0xcf, 0x76, 0x2a, 0x1d, 0xcd, 0xd7, 0xbe, 0xce, 0x4e, 0x11, 0xd4, 0xab,
	0x1e, 0x43, 0x55, 0x7c, 0x5d, 0xea, 0x00, 0x28, 0x7c, 0x6c, 0x76, 0x1a, 0x26, 0xea, 0xdc, 0x7a,
	0x5c, 0x52, 0x7a, 0xb2, 0x82, 0x9e, 0x6c, 0x99, 0x1e, 0xe3, 0x70, 0xce, 0xaa, 0x3c, 0x5d, 0x9f,
	0xfc, 0x27, 0x00, 0x00, 0xff, 0xff, 0xc9, 0x06, 0x1e, 0xda, 0xa8, 0x1c, 0x00, 0x00,
}
