// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/logging/type/http_request.proto
// DO NOT EDIT!

/*
Package google_logging_type is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/logging/type/http_request.proto
	google.golang.org/genproto/googleapis/logging/type/log_severity.proto

It has these top-level messages:
	HttpRequest
*/
package google_logging_type // import "google.golang.org/genproto/googleapis/logging/type"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/duration"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A common proto for logging HTTP requests. Only contains semantics
// defined by the HTTP specification. Product-specific logging
// information MUST be defined in a separate message.
type HttpRequest struct {
	// The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`.
	RequestMethod string `protobuf:"bytes,1,opt,name=request_method,json=requestMethod" json:"request_method,omitempty"`
	// The scheme (http, https), the host name, the path and the query
	// portion of the URL that was requested.
	// Example: `"http://example.com/some/info?color=red"`.
	RequestUrl string `protobuf:"bytes,2,opt,name=request_url,json=requestUrl" json:"request_url,omitempty"`
	// The size of the HTTP request message in bytes, including the request
	// headers and the request body.
	RequestSize int64 `protobuf:"varint,3,opt,name=request_size,json=requestSize" json:"request_size,omitempty"`
	// The response code indicating the status of response.
	// Examples: 200, 404.
	Status int32 `protobuf:"varint,4,opt,name=status" json:"status,omitempty"`
	// The size of the HTTP response message sent back to the client, in bytes,
	// including the response headers and the response body.
	ResponseSize int64 `protobuf:"varint,5,opt,name=response_size,json=responseSize" json:"response_size,omitempty"`
	// The user agent sent by the client. Example:
	// `"Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
	UserAgent string `protobuf:"bytes,6,opt,name=user_agent,json=userAgent" json:"user_agent,omitempty"`
	// The IP address (IPv4 or IPv6) of the client that issued the HTTP
	// request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
	RemoteIp string `protobuf:"bytes,7,opt,name=remote_ip,json=remoteIp" json:"remote_ip,omitempty"`
	// The IP address (IPv4 or IPv6) of the origin server that the request was
	// sent to.
	ServerIp string `protobuf:"bytes,13,opt,name=server_ip,json=serverIp" json:"server_ip,omitempty"`
	// The referer URL of the request, as defined in
	// [HTTP/1.1 Header Field Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
	Referer string `protobuf:"bytes,8,opt,name=referer" json:"referer,omitempty"`
	// The request processing latency on the server, from the time the request was
	// received until the response was sent.
	Latency *google_protobuf1.Duration `protobuf:"bytes,14,opt,name=latency" json:"latency,omitempty"`
	// Whether or not a cache lookup was attempted.
	CacheLookup bool `protobuf:"varint,11,opt,name=cache_lookup,json=cacheLookup" json:"cache_lookup,omitempty"`
	// Whether or not an entity was served from cache
	// (with or without validation).
	CacheHit bool `protobuf:"varint,9,opt,name=cache_hit,json=cacheHit" json:"cache_hit,omitempty"`
	// Whether or not the response was validated with the origin server before
	// being served from cache. This field is only meaningful if `cache_hit` is
	// True.
	CacheValidatedWithOriginServer bool `protobuf:"varint,10,opt,name=cache_validated_with_origin_server,json=cacheValidatedWithOriginServer" json:"cache_validated_with_origin_server,omitempty"`
	// The number of HTTP response bytes inserted into cache. Set only when a
	// cache fill was attempted.
	CacheFillBytes int64 `protobuf:"varint,12,opt,name=cache_fill_bytes,json=cacheFillBytes" json:"cache_fill_bytes,omitempty"`
}

func (m *HttpRequest) Reset()                    { *m = HttpRequest{} }
func (m *HttpRequest) String() string            { return proto.CompactTextString(m) }
func (*HttpRequest) ProtoMessage()               {}
func (*HttpRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *HttpRequest) GetLatency() *google_protobuf1.Duration {
	if m != nil {
		return m.Latency
	}
	return nil
}

func init() {
	proto.RegisterType((*HttpRequest)(nil), "google.logging.type.HttpRequest")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/logging/type/http_request.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 477 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x92, 0x4f, 0x6f, 0x13, 0x31,
	0x10, 0xc5, 0x15, 0xda, 0xe6, 0x8f, 0x37, 0x8d, 0x2a, 0x23, 0x81, 0x29, 0xe2, 0x5f, 0x11, 0x52,
	0x2f, 0xac, 0x25, 0x7a, 0xe2, 0x48, 0x04, 0xa8, 0x45, 0x20, 0xaa, 0xad, 0x80, 0xe3, 0x6a, 0xb3,
	0x71, 0xbc, 0x16, 0xce, 0xda, 0xd8, 0xde, 0xa0, 0xf0, 0x35, 0xf8, 0xc2, 0x8c, 0xc7, 0xbb, 0x88,
	0x03, 0x87, 0x5e, 0xa2, 0xec, 0xef, 0xbd, 0x37, 0x1e, 0x8f, 0x87, 0xbc, 0x93, 0xc6, 0x48, 0x2d,
	0x72, 0x69, 0x74, 0xd5, 0xca, 0xdc, 0x38, 0xc9, 0xa5, 0x68, 0xad, 0x33, 0xc1, 0xf0, 0x24, 0x55,
	0x56, 0x79, 0xae, 0x8d, 0x94, 0xaa, 0x95, 0x3c, 0xec, 0xad, 0xe0, 0x4d, 0x08, 0xb6, 0x74, 0xe2,
	0x47, 0x27, 0x7c, 0xc8, 0xd1, 0x4a, 0xef, 0xf6, 0x65, 0x7a, 0x5f, 0x1e, 0x7d, 0xa7, 0x57, 0xb7,
	0xab, 0x0d, 0x3f, 0xdc, 0x0b, 0xb7, 0x53, 0xb5, 0xa8, 0x4d, 0xbb, 0x51, 0x92, 0x57, 0x6d, 0x6b,
	0x42, 0x15, 0x94, 0x69, 0x7d, 0xaa, 0x7f, 0xfa, 0x5a, 0xaa, 0xd0, 0x74, 0xab, 0xbc, 0x36, 0x5b,
	0x9e, 0xca, 0x71, 0x14, 0x56, 0xdd, 0x86, 0xdb, 0x78, 0x98, 0xe7, 0xeb, 0xce, 0x61, 0xe4, 0xef,
	0x9f, 0x14, 0x3d, 0xfb, 0x7d, 0x48, 0xb2, 0x4b, 0xe8, 0xb8, 0x48, 0x0d, 0xd3, 0x17, 0x64, 0xd1,
	0xf7, 0x5e, 0x6e, 0x45, 0x68, 0xcc, 0x9a, 0x8d, 0x9e, 0x8e, 0xce, 0x67, 0xc5, 0x71, 0x4f, 0x3f,
	0x21, 0xa4, 0x4f, 0x48, 0x36, 0xd8, 0x3a, 0xa7, 0xd9, 0x1d, 0xf4, 0x90, 0x1e, 0x7d, 0x71, 0x9a,
	0x3e, 0x23, 0xf3, 0xc1, 0xe0, 0xd5, 0x2f, 0xc1, 0x0e, 0xc0, 0x71, 0x50, 0x0c, 0xa1, 0x1b, 0x40,
	0xf4, 0x1e, 0x19, 0x7b, 0xb8, 0x47, 0xe7, 0xd9, 0x21, 0x88, 0x47, 0x45, 0xff, 0x45, 0x9f, 0x13,
	0x38, 0xcc, 0x5b, 0xb8, 0x9e, 0x48, 0xd9, 0x23, 0xcc, 0xce, 0x07, 0x88, 0xe1, 0x47, 0x84, 0x74,
	0x30, 0x96, 0xb2, 0x82, 0x99, 0x05, 0x36, 0xc6, 0xf3, 0x67, 0x91, 0xbc, 0x89, 0x80, 0x3e, 0x24,
	0x33, 0x27, 0xb6, 0x26, 0x88, 0x52, 0x59, 0x36, 0x41, 0x75, 0x9a, 0xc0, 0x95, 0x8d, 0x62, 0x9c,
	0x28, 0xa4, 0x41, 0x3c, 0x4e, 0x62, 0x02, 0x20, 0x32, 0x32, 0x71, 0x62, 0x23, 0x9c, 0x70, 0x6c,
	0x8a, 0xd2, 0xf0, 0x49, 0x2f, 0xc8, 0x44, 0x57, 0x41, 0xb4, 0xf5, 0x9e, 0x2d, 0x40, 0xc9, 0x5e,
	0x3d, 0xc8, 0xfb, 0x27, 0x1c, 0x86, 0x9d, 0xbf, 0xed, 0x87, 0x5b, 0x0c, 0xce, 0x38, 0x87, 0xba,
	0xaa, 0x1b, 0x51, 0x6a, 0x63, 0xbe, 0x77, 0x96, 0x65, 0x90, 0x9c, 0x16, 0x19, 0xb2, 0x8f, 0x88,
	0x62, 0x3b, 0xc9, 0xd2, 0xa8, 0xc0, 0x66, 0xa8, 0x4f, 0x11, 0x5c, 0xaa, 0x40, 0x3f, 0x90, 0xb3,
	0x24, 0xee, 0x2a, 0xad, 0xd6, 0x50, 0x74, 0x5d, 0xfe, 0x84, 0xc7, 0x2e, 0x8d, 0x53, 0xb0, 0x4a,
	0x65, 0x6a, 0x9b, 0x11, 0x4c, 0x3d, 0x46, 0xe7, 0xd7, 0xc1, 0xf8, 0x0d, 0x7c, 0x9f, 0xd1, 0x76,
	0x83, 0x2e, 0x7a, 0x4e, 0x4e, 0x52, 0xad, 0x8d, 0xd2, 0xba, 0x5c, 0xed, 0x83, 0xf0, 0x6c, 0x8e,
	0xb3, 0x5d, 0x20, 0x7f, 0x0f, 0x78, 0x19, 0xe9, 0xf2, 0x25, 0xb9, 0x0f, 0xbb, 0x94, 0xff, 0x67,
	0x6d, 0x97, 0x27, 0xff, 0x6c, 0xcb, 0x75, 0xbc, 0xf7, 0xf5, 0x68, 0x35, 0xc6, 0x01, 0x5c, 0xfc,
	0x09, 0x00, 0x00, 0xff, 0xff, 0x4b, 0x1c, 0x8f, 0x8c, 0x2f, 0x03, 0x00, 0x00,
}
