// Code generated by protoc-gen-gogo.
// source: specs.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import docker_swarmkit_v11 "github.com/docker/swarmkit/api/duration"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"
import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type NodeSpec_Membership int32

const (
	NodeMembershipPending  NodeSpec_Membership = 0
	NodeMembershipAccepted NodeSpec_Membership = 1
)

var NodeSpec_Membership_name = map[int32]string{
	0: "PENDING",
	1: "ACCEPTED",
}
var NodeSpec_Membership_value = map[string]int32{
	"PENDING":  0,
	"ACCEPTED": 1,
}

func (x NodeSpec_Membership) String() string {
	return proto.EnumName(NodeSpec_Membership_name, int32(x))
}
func (NodeSpec_Membership) EnumDescriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{0, 0} }

type NodeSpec_Availability int32

const (
	// Active nodes.
	NodeAvailabilityActive NodeSpec_Availability = 0
	// Paused nodes won't be considered by the scheduler, preventing any
	// further task to run on them.
	NodeAvailabilityPause NodeSpec_Availability = 1
	// Drained nodes are paused and any task already running on them will
	// be evicted.
	NodeAvailabilityDrain NodeSpec_Availability = 2
)

var NodeSpec_Availability_name = map[int32]string{
	0: "ACTIVE",
	1: "PAUSE",
	2: "DRAIN",
}
var NodeSpec_Availability_value = map[string]int32{
	"ACTIVE": 0,
	"PAUSE":  1,
	"DRAIN":  2,
}

func (x NodeSpec_Availability) String() string {
	return proto.EnumName(NodeSpec_Availability_name, int32(x))
}
func (NodeSpec_Availability) EnumDescriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{0, 1} }

// ResolutionMode specifies the mode of resolution to use for
// internal loadbalancing between tasks which are all within
// the cluster. This is sometimes calles east-west data path.
type EndpointSpec_ResolutionMode int32

const (
	// VIP resolution mode specifies that the
	// service resolves to a logical IP and the requests
	// are sent to that logical IP. Packets hitting that
	// logical IP are load balanced to a chosen backend.
	ResolutionModeVirtualIP EndpointSpec_ResolutionMode = 0
	// DNSRR resolution mode specifies that the
	// service directly gets resolved to one of the
	// backend IP and the client directly initiates a
	// request towards the actual backend. This requires
	// that the client does not cache the DNS responses
	// when the DNS response TTL is 0.
	ResolutionModeDNSRoundRobin EndpointSpec_ResolutionMode = 1
)

var EndpointSpec_ResolutionMode_name = map[int32]string{
	0: "VIP",
	1: "DNSRR",
}
var EndpointSpec_ResolutionMode_value = map[string]int32{
	"VIP":   0,
	"DNSRR": 1,
}

func (x EndpointSpec_ResolutionMode) String() string {
	return proto.EnumName(EndpointSpec_ResolutionMode_name, int32(x))
}
func (EndpointSpec_ResolutionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorSpecs, []int{7, 0}
}

type NodeSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// Role defines the role the node should have.
	Role NodeRole `protobuf:"varint,2,opt,name=role,proto3,enum=docker.swarmkit.v1.NodeRole" json:"role,omitempty"`
	// Membership controls the admission of the node into the cluster.
	Membership NodeSpec_Membership `protobuf:"varint,3,opt,name=membership,proto3,enum=docker.swarmkit.v1.NodeSpec_Membership" json:"membership,omitempty"`
	// Availability allows a user to control the current scheduling status of a
	// node.
	Availability NodeSpec_Availability `protobuf:"varint,4,opt,name=availability,proto3,enum=docker.swarmkit.v1.NodeSpec_Availability" json:"availability,omitempty"`
}

func (m *NodeSpec) Reset()                    { *m = NodeSpec{} }
func (*NodeSpec) ProtoMessage()               {}
func (*NodeSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{0} }

// ServiceSpec defines the properties of a service.
//
// A service instructs the cluster in orchestrating repeated instances of a
// template, implemented as tasks. Based on the number of instances, scheduling
// strategy and restart policy, a number of application-level behaviors can be
// defined.
type ServiceSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// Task defines the task template this service will spawn.
	Task TaskSpec `protobuf:"bytes,2,opt,name=task" json:"task"`
	// Types that are valid to be assigned to Mode:
	//	*ServiceSpec_Replicated
	//	*ServiceSpec_Global
	Mode isServiceSpec_Mode `protobuf_oneof:"mode"`
	// UpdateConfig controls the rate and policy of updates.
	Update   *UpdateConfig              `protobuf:"bytes,6,opt,name=update" json:"update,omitempty"`
	Networks []*NetworkAttachmentConfig `protobuf:"bytes,7,rep,name=networks" json:"networks,omitempty"`
	// Service endpoint specifies the user provided configuration
	// to properly discover and load balance a service.
	Endpoint *EndpointSpec `protobuf:"bytes,8,opt,name=endpoint" json:"endpoint,omitempty"`
}

func (m *ServiceSpec) Reset()                    { *m = ServiceSpec{} }
func (*ServiceSpec) ProtoMessage()               {}
func (*ServiceSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{1} }

type isServiceSpec_Mode interface {
	isServiceSpec_Mode()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ServiceSpec_Replicated struct {
	Replicated *ReplicatedService `protobuf:"bytes,3,opt,name=replicated,oneof"`
}
type ServiceSpec_Global struct {
	Global *GlobalService `protobuf:"bytes,4,opt,name=global,oneof"`
}

func (*ServiceSpec_Replicated) isServiceSpec_Mode() {}
func (*ServiceSpec_Global) isServiceSpec_Mode()     {}

func (m *ServiceSpec) GetMode() isServiceSpec_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (m *ServiceSpec) GetReplicated() *ReplicatedService {
	if x, ok := m.GetMode().(*ServiceSpec_Replicated); ok {
		return x.Replicated
	}
	return nil
}

func (m *ServiceSpec) GetGlobal() *GlobalService {
	if x, ok := m.GetMode().(*ServiceSpec_Global); ok {
		return x.Global
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ServiceSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ServiceSpec_OneofMarshaler, _ServiceSpec_OneofUnmarshaler, _ServiceSpec_OneofSizer, []interface{}{
		(*ServiceSpec_Replicated)(nil),
		(*ServiceSpec_Global)(nil),
	}
}

func _ServiceSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ServiceSpec)
	// mode
	switch x := m.Mode.(type) {
	case *ServiceSpec_Replicated:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Replicated); err != nil {
			return err
		}
	case *ServiceSpec_Global:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Global); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ServiceSpec.Mode has unexpected type %T", x)
	}
	return nil
}

func _ServiceSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ServiceSpec)
	switch tag {
	case 3: // mode.replicated
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReplicatedService)
		err := b.DecodeMessage(msg)
		m.Mode = &ServiceSpec_Replicated{msg}
		return true, err
	case 4: // mode.global
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GlobalService)
		err := b.DecodeMessage(msg)
		m.Mode = &ServiceSpec_Global{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ServiceSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ServiceSpec)
	// mode
	switch x := m.Mode.(type) {
	case *ServiceSpec_Replicated:
		s := proto.Size(x.Replicated)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ServiceSpec_Global:
		s := proto.Size(x.Global)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// ReplicatedService sets the reconciliation target to certain number of replicas.
type ReplicatedService struct {
	Replicas uint64 `protobuf:"varint,1,opt,name=replicas,proto3" json:"replicas,omitempty"`
}

func (m *ReplicatedService) Reset()                    { *m = ReplicatedService{} }
func (*ReplicatedService) ProtoMessage()               {}
func (*ReplicatedService) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{2} }

// GlobalService represents global service.
type GlobalService struct {
}

func (m *GlobalService) Reset()                    { *m = GlobalService{} }
func (*GlobalService) ProtoMessage()               {}
func (*GlobalService) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{3} }

type TaskSpec struct {
	// Types that are valid to be assigned to Runtime:
	//	*TaskSpec_Attachment
	//	*TaskSpec_Container
	Runtime isTaskSpec_Runtime `protobuf_oneof:"runtime"`
	// Resource requirements for the container.
	Resources *ResourceRequirements `protobuf:"bytes,2,opt,name=resources" json:"resources,omitempty"`
	// RestartPolicy specifies what to do when a task fails or finishes.
	Restart *RestartPolicy `protobuf:"bytes,4,opt,name=restart" json:"restart,omitempty"`
	// Placement specifies node selection constraints
	Placement *Placement `protobuf:"bytes,5,opt,name=placement" json:"placement,omitempty"`
	// LogDriver specifies the log driver to use for the task. Any runtime will
	// direct logs into the specified driver for the duration of the task.
	LogDriver *Driver `protobuf:"bytes,6,opt,name=log_driver,json=logDriver" json:"log_driver,omitempty"`
	// Networks specifies the list of network attachment
	// configurations (which specify the network and per-network
	// aliases) that this task spec is bound to.
	Networks []*NetworkAttachmentConfig `protobuf:"bytes,7,rep,name=networks" json:"networks,omitempty"`
	// ForceUpdate is a counter that triggers an update even if no relevant
	// parameters have been changed. We do this to allow forced restarts
	// using the same reconcilation-based mechanism that performs rolling
	// updates.
	ForceUpdate uint64 `protobuf:"varint,9,opt,name=force_update,json=forceUpdate,proto3" json:"force_update,omitempty"`
}

func (m *TaskSpec) Reset()                    { *m = TaskSpec{} }
func (*TaskSpec) ProtoMessage()               {}
func (*TaskSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{4} }

type isTaskSpec_Runtime interface {
	isTaskSpec_Runtime()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TaskSpec_Attachment struct {
	Attachment *NetworkAttachmentSpec `protobuf:"bytes,8,opt,name=attachment,oneof"`
}
type TaskSpec_Container struct {
	Container *ContainerSpec `protobuf:"bytes,1,opt,name=container,oneof"`
}

func (*TaskSpec_Attachment) isTaskSpec_Runtime() {}
func (*TaskSpec_Container) isTaskSpec_Runtime()  {}

func (m *TaskSpec) GetRuntime() isTaskSpec_Runtime {
	if m != nil {
		return m.Runtime
	}
	return nil
}

func (m *TaskSpec) GetAttachment() *NetworkAttachmentSpec {
	if x, ok := m.GetRuntime().(*TaskSpec_Attachment); ok {
		return x.Attachment
	}
	return nil
}

func (m *TaskSpec) GetContainer() *ContainerSpec {
	if x, ok := m.GetRuntime().(*TaskSpec_Container); ok {
		return x.Container
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TaskSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TaskSpec_OneofMarshaler, _TaskSpec_OneofUnmarshaler, _TaskSpec_OneofSizer, []interface{}{
		(*TaskSpec_Attachment)(nil),
		(*TaskSpec_Container)(nil),
	}
}

func _TaskSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TaskSpec)
	// runtime
	switch x := m.Runtime.(type) {
	case *TaskSpec_Attachment:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Attachment); err != nil {
			return err
		}
	case *TaskSpec_Container:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Container); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TaskSpec.Runtime has unexpected type %T", x)
	}
	return nil
}

func _TaskSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TaskSpec)
	switch tag {
	case 8: // runtime.attachment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NetworkAttachmentSpec)
		err := b.DecodeMessage(msg)
		m.Runtime = &TaskSpec_Attachment{msg}
		return true, err
	case 1: // runtime.container
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ContainerSpec)
		err := b.DecodeMessage(msg)
		m.Runtime = &TaskSpec_Container{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TaskSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TaskSpec)
	// runtime
	switch x := m.Runtime.(type) {
	case *TaskSpec_Attachment:
		s := proto.Size(x.Attachment)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TaskSpec_Container:
		s := proto.Size(x.Container)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// NetworkAttachmentSpec specifies runtime parameters required to attach
// a container to a network.
type NetworkAttachmentSpec struct {
	// ContainerID spcifies a unique ID of the container for which
	// this attachment is for.
	ContainerID string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
}

func (m *NetworkAttachmentSpec) Reset()                    { *m = NetworkAttachmentSpec{} }
func (*NetworkAttachmentSpec) ProtoMessage()               {}
func (*NetworkAttachmentSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{5} }

// Container specifies runtime parameters for a container.
type ContainerSpec struct {
	// image defines the image reference, as specified in the
	// distribution/reference package. This may include a registry host, name,
	// tag or digest.
	//
	// The field will be directly passed to the engine pulling. Well-behaved
	// service definitions will used immutable references, either through tags
	// that don't change or verifiable digests.
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Labels defines labels to be added to the container at creation time. If
	// collisions with system labels occur, these labels will be overridden.
	//
	// This field *must* remain compatible with the Labels field of
	// Annotations.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Command to run the the container. The first element is a path to the
	// executable and the following elements are treated as arguments.
	//
	// If command is empty, execution will fall back to the image's entrypoint.
	//
	// Command should only be used when overriding entrypoint.
	Command []string `protobuf:"bytes,3,rep,name=command" json:"command,omitempty"`
	// Args specifies arguments provided to the image's entrypoint.
	//
	// If Command and Args are provided, Args will be appended to Command.
	Args []string `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	// Hostname specifies the hostname that will be set on containers created by docker swarm.
	// All containers for a given service will have the same hostname
	Hostname string `protobuf:"bytes,14,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Env specifies the environment variables for the container in NAME=VALUE
	// format. These must be compliant with  [IEEE Std
	// 1003.1-2001](http://pubs.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap08.html).
	Env []string `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	// Dir defines the working directory to set for the container process.
	Dir string `protobuf:"bytes,6,opt,name=dir,proto3" json:"dir,omitempty"`
	// User specifies the user that should be employed to run the container.
	//
	// Note that the primary group may be specified by appending the group name
	// or id to the user name, separated by a `:`. This syntax is
	// `<user>:<group>`.
	User string `protobuf:"bytes,7,opt,name=user,proto3" json:"user,omitempty"`
	// Groups specifies supplementary groups available to the user.
	Groups []string `protobuf:"bytes,11,rep,name=groups" json:"groups,omitempty"`
	// TTY declares that a TTY should be attached to the standard streams,
	// including stdin if it is still open.
	TTY bool `protobuf:"varint,13,opt,name=tty,proto3" json:"tty,omitempty"`
	// OpenStdin declares that the standard input (stdin) should be open.
	OpenStdin bool    `protobuf:"varint,18,opt,name=open_stdin,json=openStdin,proto3" json:"open_stdin,omitempty"`
	Mounts    []Mount `protobuf:"bytes,8,rep,name=mounts" json:"mounts"`
	// StopGracePeriod the grace period for stopping the container before
	// forcefully killing the container.
	StopGracePeriod *docker_swarmkit_v11.Duration `protobuf:"bytes,9,opt,name=stop_grace_period,json=stopGracePeriod" json:"stop_grace_period,omitempty"`
	// PullOptions parameterize the behavior of image pulls.
	PullOptions *ContainerSpec_PullOptions `protobuf:"bytes,10,opt,name=pull_options,json=pullOptions" json:"pull_options,omitempty"`
	// SecretReference contains references to zero or more secrets that
	// will be exposed to the container.
	Secrets []*SecretReference `protobuf:"bytes,12,rep,name=secrets" json:"secrets,omitempty"`
	// Hosts allow additional entries to be specified in /etc/hosts
	// that associates IP addresses with hostnames.
	// Detailed documentation is available in:
	// http://man7.org/linux/man-pages/man5/hosts.5.html
	//   IP_address canonical_hostname [aliases...]
	//
	// The format of the Hosts in swarmkit follows the same as
	// above.
	// This is different from `docker run --add-host <hostname>:<ip>`
	// where format is `<hostname>:<ip>`
	Hosts []string `protobuf:"bytes,17,rep,name=hosts" json:"hosts,omitempty"`
	// DNSConfig allows one to specify DNS related configuration in resolv.conf
	DNSConfig *ContainerSpec_DNSConfig `protobuf:"bytes,15,opt,name=dns_config,json=dnsConfig" json:"dns_config,omitempty"`
	// Healthcheck describes how to check the container is healthy. If the
	// container is considered unhealthy, it will be destroyed, its creating
	// task will exit and a new task will be rescheduled elsewhere. A container
	// is considered unhealthy after `Retries` number of consecutive failures.
	Healthcheck *HealthConfig `protobuf:"bytes,16,opt,name=healthcheck" json:"healthcheck,omitempty"`
}

func (m *ContainerSpec) Reset()                    { *m = ContainerSpec{} }
func (*ContainerSpec) ProtoMessage()               {}
func (*ContainerSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{6} }

// PullOptions allows one to parameterize an image pull.
type ContainerSpec_PullOptions struct {
	// RegistryAuth is the registry auth token obtained from the client, required
	// to pull private images. This is the unmodified JSON used as part of
	// the `X-Registry-Auth` header.
	// TODO(nishanttotla): This field will later be deprecated
	RegistryAuth string `protobuf:"bytes,64,opt,name=registry_auth,json=registryAuth,proto3" json:"registry_auth,omitempty"`
}

func (m *ContainerSpec_PullOptions) Reset()      { *m = ContainerSpec_PullOptions{} }
func (*ContainerSpec_PullOptions) ProtoMessage() {}
func (*ContainerSpec_PullOptions) Descriptor() ([]byte, []int) {
	return fileDescriptorSpecs, []int{6, 1}
}

// DNSConfig specifies DNS related configurations in resolver configuration file (resolv.conf)
// Detailed documentation is available in:
// http://man7.org/linux/man-pages/man5/resolv.conf.5.html
// TODO: domain is not supported yet
type ContainerSpec_DNSConfig struct {
	// Nameservers specifies the IP addresses of the name servers
	Nameservers []string `protobuf:"bytes,1,rep,name=nameservers" json:"nameservers,omitempty"`
	// Search specifies the search list for host-name lookup
	Search []string `protobuf:"bytes,2,rep,name=search" json:"search,omitempty"`
	// Options allows certain internal resolver variables to be modified
	Options []string `protobuf:"bytes,3,rep,name=options" json:"options,omitempty"`
}

func (m *ContainerSpec_DNSConfig) Reset()                    { *m = ContainerSpec_DNSConfig{} }
func (*ContainerSpec_DNSConfig) ProtoMessage()               {}
func (*ContainerSpec_DNSConfig) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{6, 2} }

// EndpointSpec defines the properties that can be configured to
// access and loadbalance the service.
type EndpointSpec struct {
	Mode EndpointSpec_ResolutionMode `protobuf:"varint,1,opt,name=mode,proto3,enum=docker.swarmkit.v1.EndpointSpec_ResolutionMode" json:"mode,omitempty"`
	// List of exposed ports that this service is accessible from
	// external to the cluster.
	Ports []*PortConfig `protobuf:"bytes,2,rep,name=ports" json:"ports,omitempty"`
}

func (m *EndpointSpec) Reset()                    { *m = EndpointSpec{} }
func (*EndpointSpec) ProtoMessage()               {}
func (*EndpointSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{7} }

// NetworkSpec specifies user defined network parameters.
type NetworkSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// DriverConfig specific configuration consumed by the network driver.
	DriverConfig *Driver `protobuf:"bytes,2,opt,name=driver_config,json=driverConfig" json:"driver_config,omitempty"`
	// IPv6Enabled enables support for IPv6 on the network.
	Ipv6Enabled bool `protobuf:"varint,3,opt,name=ipv6_enabled,json=ipv6Enabled,proto3" json:"ipv6_enabled,omitempty"`
	// internal restricts external access to the network. This may be
	// accomplished by disabling the default gateway or through other means.
	Internal bool         `protobuf:"varint,4,opt,name=internal,proto3" json:"internal,omitempty"`
	IPAM     *IPAMOptions `protobuf:"bytes,5,opt,name=ipam" json:"ipam,omitempty"`
	// Attachable allows external(to swarm) entities to manually
	// attach to this network. With this flag enabled, external
	// entities such as containers running in an worker node in
	// the cluster can manually attach to this network and access
	// the services attached to this network. If this flag is not
	// enabled(default case) no manual attachment to this network
	// can happen.
	Attachable bool `protobuf:"varint,6,opt,name=attachable,proto3" json:"attachable,omitempty"`
}

func (m *NetworkSpec) Reset()                    { *m = NetworkSpec{} }
func (*NetworkSpec) ProtoMessage()               {}
func (*NetworkSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{8} }

// ClusterSpec specifies global cluster settings.
type ClusterSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// DEPRECATED: AcceptancePolicy defines the certificate issuance policy.
	// Acceptance policy is no longer customizable, and secrets have been
	// replaced with join tokens.
	AcceptancePolicy AcceptancePolicy `protobuf:"bytes,2,opt,name=acceptance_policy,json=acceptancePolicy" json:"acceptance_policy"`
	// Orchestration defines cluster-level orchestration settings.
	Orchestration OrchestrationConfig `protobuf:"bytes,3,opt,name=orchestration" json:"orchestration"`
	// Raft defines the cluster's raft settings.
	Raft RaftConfig `protobuf:"bytes,4,opt,name=raft" json:"raft"`
	// Dispatcher defines cluster-level dispatcher settings.
	Dispatcher DispatcherConfig `protobuf:"bytes,5,opt,name=dispatcher" json:"dispatcher"`
	// CAConfig defines cluster-level certificate authority settings.
	CAConfig CAConfig `protobuf:"bytes,6,opt,name=ca_config,json=caConfig" json:"ca_config"`
	// TaskDefaults specifies the default values to use for task creation.
	TaskDefaults TaskDefaults `protobuf:"bytes,7,opt,name=task_defaults,json=taskDefaults" json:"task_defaults"`
	// EncryptionConfig defines the cluster's encryption settings.
	EncryptionConfig EncryptionConfig `protobuf:"bytes,8,opt,name=encryption_config,json=encryptionConfig" json:"encryption_config"`
}

func (m *ClusterSpec) Reset()                    { *m = ClusterSpec{} }
func (*ClusterSpec) ProtoMessage()               {}
func (*ClusterSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{9} }

// SecretSpec specifies a user-provided secret.
type SecretSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// Data is the secret payload - the maximum size is 500KB (that is, 500*1024 bytes)
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *SecretSpec) Reset()                    { *m = SecretSpec{} }
func (*SecretSpec) ProtoMessage()               {}
func (*SecretSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{10} }

func init() {
	proto.RegisterType((*NodeSpec)(nil), "docker.swarmkit.v1.NodeSpec")
	proto.RegisterType((*ServiceSpec)(nil), "docker.swarmkit.v1.ServiceSpec")
	proto.RegisterType((*ReplicatedService)(nil), "docker.swarmkit.v1.ReplicatedService")
	proto.RegisterType((*GlobalService)(nil), "docker.swarmkit.v1.GlobalService")
	proto.RegisterType((*TaskSpec)(nil), "docker.swarmkit.v1.TaskSpec")
	proto.RegisterType((*NetworkAttachmentSpec)(nil), "docker.swarmkit.v1.NetworkAttachmentSpec")
	proto.RegisterType((*ContainerSpec)(nil), "docker.swarmkit.v1.ContainerSpec")
	proto.RegisterType((*ContainerSpec_PullOptions)(nil), "docker.swarmkit.v1.ContainerSpec.PullOptions")
	proto.RegisterType((*ContainerSpec_DNSConfig)(nil), "docker.swarmkit.v1.ContainerSpec.DNSConfig")
	proto.RegisterType((*EndpointSpec)(nil), "docker.swarmkit.v1.EndpointSpec")
	proto.RegisterType((*NetworkSpec)(nil), "docker.swarmkit.v1.NetworkSpec")
	proto.RegisterType((*ClusterSpec)(nil), "docker.swarmkit.v1.ClusterSpec")
	proto.RegisterType((*SecretSpec)(nil), "docker.swarmkit.v1.SecretSpec")
	proto.RegisterEnum("docker.swarmkit.v1.NodeSpec_Membership", NodeSpec_Membership_name, NodeSpec_Membership_value)
	proto.RegisterEnum("docker.swarmkit.v1.NodeSpec_Availability", NodeSpec_Availability_name, NodeSpec_Availability_value)
	proto.RegisterEnum("docker.swarmkit.v1.EndpointSpec_ResolutionMode", EndpointSpec_ResolutionMode_name, EndpointSpec_ResolutionMode_value)
}

func (m *NodeSpec) Copy() *NodeSpec {
	if m == nil {
		return nil
	}

	o := &NodeSpec{
		Annotations:  *m.Annotations.Copy(),
		Role:         m.Role,
		Membership:   m.Membership,
		Availability: m.Availability,
	}

	return o
}

func (m *ServiceSpec) Copy() *ServiceSpec {
	if m == nil {
		return nil
	}

	o := &ServiceSpec{
		Annotations: *m.Annotations.Copy(),
		Task:        *m.Task.Copy(),
		Update:      m.Update.Copy(),
		Endpoint:    m.Endpoint.Copy(),
	}

	if m.Networks != nil {
		o.Networks = make([]*NetworkAttachmentConfig, 0, len(m.Networks))
		for _, v := range m.Networks {
			o.Networks = append(o.Networks, v.Copy())
		}
	}

	switch m.Mode.(type) {
	case *ServiceSpec_Replicated:
		i := &ServiceSpec_Replicated{
			Replicated: m.GetReplicated().Copy(),
		}

		o.Mode = i
	case *ServiceSpec_Global:
		i := &ServiceSpec_Global{
			Global: m.GetGlobal().Copy(),
		}

		o.Mode = i
	}

	return o
}

func (m *ReplicatedService) Copy() *ReplicatedService {
	if m == nil {
		return nil
	}

	o := &ReplicatedService{
		Replicas: m.Replicas,
	}

	return o
}

func (m *GlobalService) Copy() *GlobalService {
	if m == nil {
		return nil
	}

	o := &GlobalService{}

	return o
}

func (m *TaskSpec) Copy() *TaskSpec {
	if m == nil {
		return nil
	}

	o := &TaskSpec{
		Resources:   m.Resources.Copy(),
		Restart:     m.Restart.Copy(),
		Placement:   m.Placement.Copy(),
		LogDriver:   m.LogDriver.Copy(),
		ForceUpdate: m.ForceUpdate,
	}

	if m.Networks != nil {
		o.Networks = make([]*NetworkAttachmentConfig, 0, len(m.Networks))
		for _, v := range m.Networks {
			o.Networks = append(o.Networks, v.Copy())
		}
	}

	switch m.Runtime.(type) {
	case *TaskSpec_Attachment:
		i := &TaskSpec_Attachment{
			Attachment: m.GetAttachment().Copy(),
		}

		o.Runtime = i
	case *TaskSpec_Container:
		i := &TaskSpec_Container{
			Container: m.GetContainer().Copy(),
		}

		o.Runtime = i
	}

	return o
}

func (m *NetworkAttachmentSpec) Copy() *NetworkAttachmentSpec {
	if m == nil {
		return nil
	}

	o := &NetworkAttachmentSpec{
		ContainerID: m.ContainerID,
	}

	return o
}

func (m *ContainerSpec) Copy() *ContainerSpec {
	if m == nil {
		return nil
	}

	o := &ContainerSpec{
		Image:           m.Image,
		Hostname:        m.Hostname,
		Dir:             m.Dir,
		User:            m.User,
		TTY:             m.TTY,
		OpenStdin:       m.OpenStdin,
		StopGracePeriod: m.StopGracePeriod.Copy(),
		PullOptions:     m.PullOptions.Copy(),
		DNSConfig:       m.DNSConfig.Copy(),
		Healthcheck:     m.Healthcheck.Copy(),
	}

	if m.Labels != nil {
		o.Labels = make(map[string]string)
		for k, v := range m.Labels {
			o.Labels[k] = v
		}
	}

	if m.Command != nil {
		o.Command = make([]string, 0, len(m.Command))
		o.Command = append(o.Command, m.Command...)
	}

	if m.Args != nil {
		o.Args = make([]string, 0, len(m.Args))
		o.Args = append(o.Args, m.Args...)
	}

	if m.Env != nil {
		o.Env = make([]string, 0, len(m.Env))
		o.Env = append(o.Env, m.Env...)
	}

	if m.Groups != nil {
		o.Groups = make([]string, 0, len(m.Groups))
		o.Groups = append(o.Groups, m.Groups...)
	}

	if m.Mounts != nil {
		o.Mounts = make([]Mount, 0, len(m.Mounts))
		for _, v := range m.Mounts {
			o.Mounts = append(o.Mounts, *v.Copy())
		}
	}

	if m.Secrets != nil {
		o.Secrets = make([]*SecretReference, 0, len(m.Secrets))
		for _, v := range m.Secrets {
			o.Secrets = append(o.Secrets, v.Copy())
		}
	}

	if m.Hosts != nil {
		o.Hosts = make([]string, 0, len(m.Hosts))
		o.Hosts = append(o.Hosts, m.Hosts...)
	}

	return o
}

func (m *ContainerSpec_PullOptions) Copy() *ContainerSpec_PullOptions {
	if m == nil {
		return nil
	}

	o := &ContainerSpec_PullOptions{
		RegistryAuth: m.RegistryAuth,
	}

	return o
}

func (m *ContainerSpec_DNSConfig) Copy() *ContainerSpec_DNSConfig {
	if m == nil {
		return nil
	}

	o := &ContainerSpec_DNSConfig{}

	if m.Nameservers != nil {
		o.Nameservers = make([]string, 0, len(m.Nameservers))
		o.Nameservers = append(o.Nameservers, m.Nameservers...)
	}

	if m.Search != nil {
		o.Search = make([]string, 0, len(m.Search))
		o.Search = append(o.Search, m.Search...)
	}

	if m.Options != nil {
		o.Options = make([]string, 0, len(m.Options))
		o.Options = append(o.Options, m.Options...)
	}

	return o
}

func (m *EndpointSpec) Copy() *EndpointSpec {
	if m == nil {
		return nil
	}

	o := &EndpointSpec{
		Mode: m.Mode,
	}

	if m.Ports != nil {
		o.Ports = make([]*PortConfig, 0, len(m.Ports))
		for _, v := range m.Ports {
			o.Ports = append(o.Ports, v.Copy())
		}
	}

	return o
}

func (m *NetworkSpec) Copy() *NetworkSpec {
	if m == nil {
		return nil
	}

	o := &NetworkSpec{
		Annotations:  *m.Annotations.Copy(),
		DriverConfig: m.DriverConfig.Copy(),
		Ipv6Enabled:  m.Ipv6Enabled,
		Internal:     m.Internal,
		IPAM:         m.IPAM.Copy(),
		Attachable:   m.Attachable,
	}

	return o
}

func (m *ClusterSpec) Copy() *ClusterSpec {
	if m == nil {
		return nil
	}

	o := &ClusterSpec{
		Annotations:      *m.Annotations.Copy(),
		AcceptancePolicy: *m.AcceptancePolicy.Copy(),
		Orchestration:    *m.Orchestration.Copy(),
		Raft:             *m.Raft.Copy(),
		Dispatcher:       *m.Dispatcher.Copy(),
		CAConfig:         *m.CAConfig.Copy(),
		TaskDefaults:     *m.TaskDefaults.Copy(),
		EncryptionConfig: *m.EncryptionConfig.Copy(),
	}

	return o
}

func (m *SecretSpec) Copy() *SecretSpec {
	if m == nil {
		return nil
	}

	o := &SecretSpec{
		Annotations: *m.Annotations.Copy(),
		Data:        m.Data,
	}

	return o
}

func (this *NodeSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.NodeSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "Membership: "+fmt.Sprintf("%#v", this.Membership)+",\n")
	s = append(s, "Availability: "+fmt.Sprintf("%#v", this.Availability)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&api.ServiceSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Task: "+strings.Replace(this.Task.GoString(), `&`, ``, 1)+",\n")
	if this.Mode != nil {
		s = append(s, "Mode: "+fmt.Sprintf("%#v", this.Mode)+",\n")
	}
	if this.Update != nil {
		s = append(s, "Update: "+fmt.Sprintf("%#v", this.Update)+",\n")
	}
	if this.Networks != nil {
		s = append(s, "Networks: "+fmt.Sprintf("%#v", this.Networks)+",\n")
	}
	if this.Endpoint != nil {
		s = append(s, "Endpoint: "+fmt.Sprintf("%#v", this.Endpoint)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceSpec_Replicated) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.ServiceSpec_Replicated{` +
		`Replicated:` + fmt.Sprintf("%#v", this.Replicated) + `}`}, ", ")
	return s
}
func (this *ServiceSpec_Global) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.ServiceSpec_Global{` +
		`Global:` + fmt.Sprintf("%#v", this.Global) + `}`}, ", ")
	return s
}
func (this *ReplicatedService) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ReplicatedService{")
	s = append(s, "Replicas: "+fmt.Sprintf("%#v", this.Replicas)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GlobalService) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.GlobalService{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&api.TaskSpec{")
	if this.Runtime != nil {
		s = append(s, "Runtime: "+fmt.Sprintf("%#v", this.Runtime)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Restart != nil {
		s = append(s, "Restart: "+fmt.Sprintf("%#v", this.Restart)+",\n")
	}
	if this.Placement != nil {
		s = append(s, "Placement: "+fmt.Sprintf("%#v", this.Placement)+",\n")
	}
	if this.LogDriver != nil {
		s = append(s, "LogDriver: "+fmt.Sprintf("%#v", this.LogDriver)+",\n")
	}
	if this.Networks != nil {
		s = append(s, "Networks: "+fmt.Sprintf("%#v", this.Networks)+",\n")
	}
	s = append(s, "ForceUpdate: "+fmt.Sprintf("%#v", this.ForceUpdate)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskSpec_Attachment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.TaskSpec_Attachment{` +
		`Attachment:` + fmt.Sprintf("%#v", this.Attachment) + `}`}, ", ")
	return s
}
func (this *TaskSpec_Container) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.TaskSpec_Container{` +
		`Container:` + fmt.Sprintf("%#v", this.Container) + `}`}, ", ")
	return s
}
func (this *NetworkAttachmentSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.NetworkAttachmentSpec{")
	s = append(s, "ContainerID: "+fmt.Sprintf("%#v", this.ContainerID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 22)
	s = append(s, "&api.ContainerSpec{")
	s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%#v: %#v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	if this.Labels != nil {
		s = append(s, "Labels: "+mapStringForLabels+",\n")
	}
	s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	s = append(s, "Args: "+fmt.Sprintf("%#v", this.Args)+",\n")
	s = append(s, "Hostname: "+fmt.Sprintf("%#v", this.Hostname)+",\n")
	s = append(s, "Env: "+fmt.Sprintf("%#v", this.Env)+",\n")
	s = append(s, "Dir: "+fmt.Sprintf("%#v", this.Dir)+",\n")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "Groups: "+fmt.Sprintf("%#v", this.Groups)+",\n")
	s = append(s, "TTY: "+fmt.Sprintf("%#v", this.TTY)+",\n")
	s = append(s, "OpenStdin: "+fmt.Sprintf("%#v", this.OpenStdin)+",\n")
	if this.Mounts != nil {
		s = append(s, "Mounts: "+fmt.Sprintf("%#v", this.Mounts)+",\n")
	}
	if this.StopGracePeriod != nil {
		s = append(s, "StopGracePeriod: "+fmt.Sprintf("%#v", this.StopGracePeriod)+",\n")
	}
	if this.PullOptions != nil {
		s = append(s, "PullOptions: "+fmt.Sprintf("%#v", this.PullOptions)+",\n")
	}
	if this.Secrets != nil {
		s = append(s, "Secrets: "+fmt.Sprintf("%#v", this.Secrets)+",\n")
	}
	s = append(s, "Hosts: "+fmt.Sprintf("%#v", this.Hosts)+",\n")
	if this.DNSConfig != nil {
		s = append(s, "DNSConfig: "+fmt.Sprintf("%#v", this.DNSConfig)+",\n")
	}
	if this.Healthcheck != nil {
		s = append(s, "Healthcheck: "+fmt.Sprintf("%#v", this.Healthcheck)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerSpec_PullOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ContainerSpec_PullOptions{")
	s = append(s, "RegistryAuth: "+fmt.Sprintf("%#v", this.RegistryAuth)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerSpec_DNSConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.ContainerSpec_DNSConfig{")
	s = append(s, "Nameservers: "+fmt.Sprintf("%#v", this.Nameservers)+",\n")
	s = append(s, "Search: "+fmt.Sprintf("%#v", this.Search)+",\n")
	s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EndpointSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.EndpointSpec{")
	s = append(s, "Mode: "+fmt.Sprintf("%#v", this.Mode)+",\n")
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&api.NetworkSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	if this.DriverConfig != nil {
		s = append(s, "DriverConfig: "+fmt.Sprintf("%#v", this.DriverConfig)+",\n")
	}
	s = append(s, "Ipv6Enabled: "+fmt.Sprintf("%#v", this.Ipv6Enabled)+",\n")
	s = append(s, "Internal: "+fmt.Sprintf("%#v", this.Internal)+",\n")
	if this.IPAM != nil {
		s = append(s, "IPAM: "+fmt.Sprintf("%#v", this.IPAM)+",\n")
	}
	s = append(s, "Attachable: "+fmt.Sprintf("%#v", this.Attachable)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ClusterSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&api.ClusterSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "AcceptancePolicy: "+strings.Replace(this.AcceptancePolicy.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Orchestration: "+strings.Replace(this.Orchestration.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Raft: "+strings.Replace(this.Raft.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Dispatcher: "+strings.Replace(this.Dispatcher.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "CAConfig: "+strings.Replace(this.CAConfig.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "TaskDefaults: "+strings.Replace(this.TaskDefaults.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "EncryptionConfig: "+strings.Replace(this.EncryptionConfig.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecretSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.SecretSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringSpecs(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringSpecs(m github_com_gogo_protobuf_proto.Message) string {
	e := github_com_gogo_protobuf_proto.GetUnsafeExtensionsMap(m)
	if e == nil {
		return "nil"
	}
	s := "proto.NewUnsafeXXX_InternalExtensions(map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "})"
	return s
}
func (m *NodeSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n1, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.Role != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Role))
	}
	if m.Membership != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Membership))
	}
	if m.Availability != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Availability))
	}
	return i, nil
}

func (m *ServiceSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ServiceSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n2, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	data[i] = 0x12
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Task.Size()))
	n3, err := m.Task.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.Mode != nil {
		nn4, err := m.Mode.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	if m.Update != nil {
		data[i] = 0x32
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Update.Size()))
		n5, err := m.Update.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.Networks) > 0 {
		for _, msg := range m.Networks {
			data[i] = 0x3a
			i++
			i = encodeVarintSpecs(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Endpoint != nil {
		data[i] = 0x42
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Endpoint.Size()))
		n6, err := m.Endpoint.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *ServiceSpec_Replicated) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Replicated != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Replicated.Size()))
		n7, err := m.Replicated.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *ServiceSpec_Global) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Global != nil {
		data[i] = 0x22
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Global.Size()))
		n8, err := m.Global.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *ReplicatedService) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ReplicatedService) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Replicas != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Replicas))
	}
	return i, nil
}

func (m *GlobalService) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GlobalService) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TaskSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Runtime != nil {
		nn9, err := m.Runtime.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn9
	}
	if m.Resources != nil {
		data[i] = 0x12
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Resources.Size()))
		n10, err := m.Resources.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Restart != nil {
		data[i] = 0x22
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Restart.Size()))
		n11, err := m.Restart.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.Placement != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Placement.Size()))
		n12, err := m.Placement.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.LogDriver != nil {
		data[i] = 0x32
		i++
		i = encodeVarintSpecs(data, i, uint64(m.LogDriver.Size()))
		n13, err := m.LogDriver.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if len(m.Networks) > 0 {
		for _, msg := range m.Networks {
			data[i] = 0x3a
			i++
			i = encodeVarintSpecs(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ForceUpdate != 0 {
		data[i] = 0x48
		i++
		i = encodeVarintSpecs(data, i, uint64(m.ForceUpdate))
	}
	return i, nil
}

func (m *TaskSpec_Container) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Container != nil {
		data[i] = 0xa
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Container.Size()))
		n14, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *TaskSpec_Attachment) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Attachment != nil {
		data[i] = 0x42
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Attachment.Size()))
		n15, err := m.Attachment.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *NetworkAttachmentSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NetworkAttachmentSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ContainerID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintSpecs(data, i, uint64(len(m.ContainerID)))
		i += copy(data[i:], m.ContainerID)
	}
	return i, nil
}

func (m *ContainerSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Image) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintSpecs(data, i, uint64(len(m.Image)))
		i += copy(data[i:], m.Image)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			data[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovSpecs(uint64(len(k))) + 1 + len(v) + sovSpecs(uint64(len(v)))
			i = encodeVarintSpecs(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintSpecs(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintSpecs(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			data[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			data[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			data[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Dir) > 0 {
		data[i] = 0x32
		i++
		i = encodeVarintSpecs(data, i, uint64(len(m.Dir)))
		i += copy(data[i:], m.Dir)
	}
	if len(m.User) > 0 {
		data[i] = 0x3a
		i++
		i = encodeVarintSpecs(data, i, uint64(len(m.User)))
		i += copy(data[i:], m.User)
	}
	if len(m.Mounts) > 0 {
		for _, msg := range m.Mounts {
			data[i] = 0x42
			i++
			i = encodeVarintSpecs(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StopGracePeriod != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintSpecs(data, i, uint64(m.StopGracePeriod.Size()))
		n16, err := m.StopGracePeriod.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.PullOptions != nil {
		data[i] = 0x52
		i++
		i = encodeVarintSpecs(data, i, uint64(m.PullOptions.Size()))
		n17, err := m.PullOptions.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.Groups) > 0 {
		for _, s := range m.Groups {
			data[i] = 0x5a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Secrets) > 0 {
		for _, msg := range m.Secrets {
			data[i] = 0x62
			i++
			i = encodeVarintSpecs(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.TTY {
		data[i] = 0x68
		i++
		if m.TTY {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.Hostname) > 0 {
		data[i] = 0x72
		i++
		i = encodeVarintSpecs(data, i, uint64(len(m.Hostname)))
		i += copy(data[i:], m.Hostname)
	}
	if m.DNSConfig != nil {
		data[i] = 0x7a
		i++
		i = encodeVarintSpecs(data, i, uint64(m.DNSConfig.Size()))
		n18, err := m.DNSConfig.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.Healthcheck != nil {
		data[i] = 0x82
		i++
		data[i] = 0x1
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Healthcheck.Size()))
		n19, err := m.Healthcheck.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			data[i] = 0x8a
			i++
			data[i] = 0x1
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.OpenStdin {
		data[i] = 0x90
		i++
		data[i] = 0x1
		i++
		if m.OpenStdin {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ContainerSpec_PullOptions) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerSpec_PullOptions) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RegistryAuth) > 0 {
		data[i] = 0x82
		i++
		data[i] = 0x4
		i++
		i = encodeVarintSpecs(data, i, uint64(len(m.RegistryAuth)))
		i += copy(data[i:], m.RegistryAuth)
	}
	return i, nil
}

func (m *ContainerSpec_DNSConfig) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerSpec_DNSConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Nameservers) > 0 {
		for _, s := range m.Nameservers {
			data[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Search) > 0 {
		for _, s := range m.Search {
			data[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			data[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	return i, nil
}

func (m *EndpointSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *EndpointSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Mode != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Mode))
	}
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			data[i] = 0x12
			i++
			i = encodeVarintSpecs(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *NetworkSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NetworkSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n20, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	if m.DriverConfig != nil {
		data[i] = 0x12
		i++
		i = encodeVarintSpecs(data, i, uint64(m.DriverConfig.Size()))
		n21, err := m.DriverConfig.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Ipv6Enabled {
		data[i] = 0x18
		i++
		if m.Ipv6Enabled {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Internal {
		data[i] = 0x20
		i++
		if m.Internal {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.IPAM != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintSpecs(data, i, uint64(m.IPAM.Size()))
		n22, err := m.IPAM.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.Attachable {
		data[i] = 0x30
		i++
		if m.Attachable {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ClusterSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ClusterSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n23, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	data[i] = 0x12
	i++
	i = encodeVarintSpecs(data, i, uint64(m.AcceptancePolicy.Size()))
	n24, err := m.AcceptancePolicy.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	data[i] = 0x1a
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Orchestration.Size()))
	n25, err := m.Orchestration.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	data[i] = 0x22
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Raft.Size()))
	n26, err := m.Raft.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	data[i] = 0x2a
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Dispatcher.Size()))
	n27, err := m.Dispatcher.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	data[i] = 0x32
	i++
	i = encodeVarintSpecs(data, i, uint64(m.CAConfig.Size()))
	n28, err := m.CAConfig.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n28
	data[i] = 0x3a
	i++
	i = encodeVarintSpecs(data, i, uint64(m.TaskDefaults.Size()))
	n29, err := m.TaskDefaults.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n29
	data[i] = 0x42
	i++
	i = encodeVarintSpecs(data, i, uint64(m.EncryptionConfig.Size()))
	n30, err := m.EncryptionConfig.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	return i, nil
}

func (m *SecretSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SecretSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n31, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	if len(m.Data) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintSpecs(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	return i, nil
}

func encodeFixed64Specs(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Specs(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintSpecs(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

func (m *NodeSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.Role != 0 {
		n += 1 + sovSpecs(uint64(m.Role))
	}
	if m.Membership != 0 {
		n += 1 + sovSpecs(uint64(m.Membership))
	}
	if m.Availability != 0 {
		n += 1 + sovSpecs(uint64(m.Availability))
	}
	return n
}

func (m *ServiceSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.Task.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.Mode != nil {
		n += m.Mode.Size()
	}
	if m.Update != nil {
		l = m.Update.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if m.Endpoint != nil {
		l = m.Endpoint.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *ServiceSpec_Replicated) Size() (n int) {
	var l int
	_ = l
	if m.Replicated != nil {
		l = m.Replicated.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *ServiceSpec_Global) Size() (n int) {
	var l int
	_ = l
	if m.Global != nil {
		l = m.Global.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *ReplicatedService) Size() (n int) {
	var l int
	_ = l
	if m.Replicas != 0 {
		n += 1 + sovSpecs(uint64(m.Replicas))
	}
	return n
}

func (m *GlobalService) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TaskSpec) Size() (n int) {
	var l int
	_ = l
	if m.Runtime != nil {
		n += m.Runtime.Size()
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Restart != nil {
		l = m.Restart.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Placement != nil {
		l = m.Placement.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.LogDriver != nil {
		l = m.LogDriver.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if m.ForceUpdate != 0 {
		n += 1 + sovSpecs(uint64(m.ForceUpdate))
	}
	return n
}

func (m *TaskSpec_Container) Size() (n int) {
	var l int
	_ = l
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *TaskSpec_Attachment) Size() (n int) {
	var l int
	_ = l
	if m.Attachment != nil {
		l = m.Attachment.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *NetworkAttachmentSpec) Size() (n int) {
	var l int
	_ = l
	l = len(m.ContainerID)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *ContainerSpec) Size() (n int) {
	var l int
	_ = l
	l = len(m.Image)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovSpecs(uint64(len(k))) + 1 + len(v) + sovSpecs(uint64(len(v)))
			n += mapEntrySize + 1 + sovSpecs(uint64(mapEntrySize))
		}
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	l = len(m.Dir)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Mounts) > 0 {
		for _, e := range m.Mounts {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if m.StopGracePeriod != nil {
		l = m.StopGracePeriod.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.PullOptions != nil {
		l = m.PullOptions.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Groups) > 0 {
		for _, s := range m.Groups {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Secrets) > 0 {
		for _, e := range m.Secrets {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if m.TTY {
		n += 2
	}
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.DNSConfig != nil {
		l = m.DNSConfig.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Healthcheck != nil {
		l = m.Healthcheck.Size()
		n += 2 + l + sovSpecs(uint64(l))
	}
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			l = len(s)
			n += 2 + l + sovSpecs(uint64(l))
		}
	}
	if m.OpenStdin {
		n += 3
	}
	return n
}

func (m *ContainerSpec_PullOptions) Size() (n int) {
	var l int
	_ = l
	l = len(m.RegistryAuth)
	if l > 0 {
		n += 2 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *ContainerSpec_DNSConfig) Size() (n int) {
	var l int
	_ = l
	if len(m.Nameservers) > 0 {
		for _, s := range m.Nameservers {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Search) > 0 {
		for _, s := range m.Search {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	return n
}

func (m *EndpointSpec) Size() (n int) {
	var l int
	_ = l
	if m.Mode != 0 {
		n += 1 + sovSpecs(uint64(m.Mode))
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovSpecs(uint64(l))
		}
	}
	return n
}

func (m *NetworkSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.DriverConfig != nil {
		l = m.DriverConfig.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Ipv6Enabled {
		n += 2
	}
	if m.Internal {
		n += 2
	}
	if m.IPAM != nil {
		l = m.IPAM.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Attachable {
		n += 2
	}
	return n
}

func (m *ClusterSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.AcceptancePolicy.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.Orchestration.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.Raft.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.Dispatcher.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.CAConfig.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.TaskDefaults.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = m.EncryptionConfig.Size()
	n += 1 + l + sovSpecs(uint64(l))
	return n
}

func (m *SecretSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func sovSpecs(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozSpecs(x uint64) (n int) {
	return sovSpecs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NodeSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`Membership:` + fmt.Sprintf("%v", this.Membership) + `,`,
		`Availability:` + fmt.Sprintf("%v", this.Availability) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Task:` + strings.Replace(strings.Replace(this.Task.String(), "TaskSpec", "TaskSpec", 1), `&`, ``, 1) + `,`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`Update:` + strings.Replace(fmt.Sprintf("%v", this.Update), "UpdateConfig", "UpdateConfig", 1) + `,`,
		`Networks:` + strings.Replace(fmt.Sprintf("%v", this.Networks), "NetworkAttachmentConfig", "NetworkAttachmentConfig", 1) + `,`,
		`Endpoint:` + strings.Replace(fmt.Sprintf("%v", this.Endpoint), "EndpointSpec", "EndpointSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec_Replicated) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec_Replicated{`,
		`Replicated:` + strings.Replace(fmt.Sprintf("%v", this.Replicated), "ReplicatedService", "ReplicatedService", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec_Global) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec_Global{`,
		`Global:` + strings.Replace(fmt.Sprintf("%v", this.Global), "GlobalService", "GlobalService", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicatedService) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicatedService{`,
		`Replicas:` + fmt.Sprintf("%v", this.Replicas) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GlobalService) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GlobalService{`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec{`,
		`Runtime:` + fmt.Sprintf("%v", this.Runtime) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "ResourceRequirements", "ResourceRequirements", 1) + `,`,
		`Restart:` + strings.Replace(fmt.Sprintf("%v", this.Restart), "RestartPolicy", "RestartPolicy", 1) + `,`,
		`Placement:` + strings.Replace(fmt.Sprintf("%v", this.Placement), "Placement", "Placement", 1) + `,`,
		`LogDriver:` + strings.Replace(fmt.Sprintf("%v", this.LogDriver), "Driver", "Driver", 1) + `,`,
		`Networks:` + strings.Replace(fmt.Sprintf("%v", this.Networks), "NetworkAttachmentConfig", "NetworkAttachmentConfig", 1) + `,`,
		`ForceUpdate:` + fmt.Sprintf("%v", this.ForceUpdate) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec_Container) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec_Container{`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "ContainerSpec", "ContainerSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec_Attachment) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec_Attachment{`,
		`Attachment:` + strings.Replace(fmt.Sprintf("%v", this.Attachment), "NetworkAttachmentSpec", "NetworkAttachmentSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkAttachmentSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkAttachmentSpec{`,
		`ContainerID:` + fmt.Sprintf("%v", this.ContainerID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerSpec) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	s := strings.Join([]string{`&ContainerSpec{`,
		`Image:` + fmt.Sprintf("%v", this.Image) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Command:` + fmt.Sprintf("%v", this.Command) + `,`,
		`Args:` + fmt.Sprintf("%v", this.Args) + `,`,
		`Env:` + fmt.Sprintf("%v", this.Env) + `,`,
		`Dir:` + fmt.Sprintf("%v", this.Dir) + `,`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`Mounts:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Mounts), "Mount", "Mount", 1), `&`, ``, 1) + `,`,
		`StopGracePeriod:` + strings.Replace(fmt.Sprintf("%v", this.StopGracePeriod), "Duration", "docker_swarmkit_v11.Duration", 1) + `,`,
		`PullOptions:` + strings.Replace(fmt.Sprintf("%v", this.PullOptions), "ContainerSpec_PullOptions", "ContainerSpec_PullOptions", 1) + `,`,
		`Groups:` + fmt.Sprintf("%v", this.Groups) + `,`,
		`Secrets:` + strings.Replace(fmt.Sprintf("%v", this.Secrets), "SecretReference", "SecretReference", 1) + `,`,
		`TTY:` + fmt.Sprintf("%v", this.TTY) + `,`,
		`Hostname:` + fmt.Sprintf("%v", this.Hostname) + `,`,
		`DNSConfig:` + strings.Replace(fmt.Sprintf("%v", this.DNSConfig), "ContainerSpec_DNSConfig", "ContainerSpec_DNSConfig", 1) + `,`,
		`Healthcheck:` + strings.Replace(fmt.Sprintf("%v", this.Healthcheck), "HealthConfig", "HealthConfig", 1) + `,`,
		`Hosts:` + fmt.Sprintf("%v", this.Hosts) + `,`,
		`OpenStdin:` + fmt.Sprintf("%v", this.OpenStdin) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerSpec_PullOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerSpec_PullOptions{`,
		`RegistryAuth:` + fmt.Sprintf("%v", this.RegistryAuth) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerSpec_DNSConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerSpec_DNSConfig{`,
		`Nameservers:` + fmt.Sprintf("%v", this.Nameservers) + `,`,
		`Search:` + fmt.Sprintf("%v", this.Search) + `,`,
		`Options:` + fmt.Sprintf("%v", this.Options) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EndpointSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EndpointSpec{`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`Ports:` + strings.Replace(fmt.Sprintf("%v", this.Ports), "PortConfig", "PortConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`DriverConfig:` + strings.Replace(fmt.Sprintf("%v", this.DriverConfig), "Driver", "Driver", 1) + `,`,
		`Ipv6Enabled:` + fmt.Sprintf("%v", this.Ipv6Enabled) + `,`,
		`Internal:` + fmt.Sprintf("%v", this.Internal) + `,`,
		`IPAM:` + strings.Replace(fmt.Sprintf("%v", this.IPAM), "IPAMOptions", "IPAMOptions", 1) + `,`,
		`Attachable:` + fmt.Sprintf("%v", this.Attachable) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ClusterSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ClusterSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`AcceptancePolicy:` + strings.Replace(strings.Replace(this.AcceptancePolicy.String(), "AcceptancePolicy", "AcceptancePolicy", 1), `&`, ``, 1) + `,`,
		`Orchestration:` + strings.Replace(strings.Replace(this.Orchestration.String(), "OrchestrationConfig", "OrchestrationConfig", 1), `&`, ``, 1) + `,`,
		`Raft:` + strings.Replace(strings.Replace(this.Raft.String(), "RaftConfig", "RaftConfig", 1), `&`, ``, 1) + `,`,
		`Dispatcher:` + strings.Replace(strings.Replace(this.Dispatcher.String(), "DispatcherConfig", "DispatcherConfig", 1), `&`, ``, 1) + `,`,
		`CAConfig:` + strings.Replace(strings.Replace(this.CAConfig.String(), "CAConfig", "CAConfig", 1), `&`, ``, 1) + `,`,
		`TaskDefaults:` + strings.Replace(strings.Replace(this.TaskDefaults.String(), "TaskDefaults", "TaskDefaults", 1), `&`, ``, 1) + `,`,
		`EncryptionConfig:` + strings.Replace(strings.Replace(this.EncryptionConfig.String(), "EncryptionConfig", "EncryptionConfig", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SecretSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SecretSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringSpecs(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NodeSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Role |= (NodeRole(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Membership", wireType)
			}
			m.Membership = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Membership |= (NodeSpec_Membership(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Availability", wireType)
			}
			m.Availability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Availability |= (NodeSpec_Availability(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Task.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReplicatedService{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Mode = &ServiceSpec_Replicated{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Global", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GlobalService{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Mode = &ServiceSpec_Global{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Update", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Update == nil {
				m.Update = &UpdateConfig{}
			}
			if err := m.Update.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, &NetworkAttachmentConfig{})
			if err := m.Networks[len(m.Networks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Endpoint == nil {
				m.Endpoint = &EndpointSpec{}
			}
			if err := m.Endpoint.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicatedService) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicatedService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicatedService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			m.Replicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Replicas |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GlobalService) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GlobalService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GlobalService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ContainerSpec{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Runtime = &TaskSpec_Container{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &ResourceRequirements{}
			}
			if err := m.Resources.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Restart == nil {
				m.Restart = &RestartPolicy{}
			}
			if err := m.Restart.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Placement", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Placement == nil {
				m.Placement = &Placement{}
			}
			if err := m.Placement.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogDriver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LogDriver == nil {
				m.LogDriver = &Driver{}
			}
			if err := m.LogDriver.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, &NetworkAttachmentConfig{})
			if err := m.Networks[len(m.Networks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attachment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NetworkAttachmentSpec{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Runtime = &TaskSpec_Attachment{v}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForceUpdate", wireType)
			}
			m.ForceUpdate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ForceUpdate |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkAttachmentSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkAttachmentSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkAttachmentSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Image = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthSpecs
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSpecs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var stringLenmapvalue uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSpecs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					stringLenmapvalue |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				intStringLenmapvalue := int(stringLenmapvalue)
				if intStringLenmapvalue < 0 {
					return ErrInvalidLengthSpecs
				}
				postStringIndexmapvalue := iNdEx + intStringLenmapvalue
				if postStringIndexmapvalue > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := string(data[iNdEx:postStringIndexmapvalue])
				iNdEx = postStringIndexmapvalue
				m.Labels[mapkey] = mapvalue
			} else {
				var mapvalue string
				m.Labels[mapkey] = mapvalue
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dir = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mounts = append(m.Mounts, Mount{})
			if err := m.Mounts[len(m.Mounts)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StopGracePeriod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StopGracePeriod == nil {
				m.StopGracePeriod = &docker_swarmkit_v11.Duration{}
			}
			if err := m.StopGracePeriod.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PullOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PullOptions == nil {
				m.PullOptions = &ContainerSpec_PullOptions{}
			}
			if err := m.PullOptions.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secrets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secrets = append(m.Secrets, &SecretReference{})
			if err := m.Secrets[len(m.Secrets)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTY", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TTY = bool(v != 0)
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DNSConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DNSConfig == nil {
				m.DNSConfig = &ContainerSpec_DNSConfig{}
			}
			if err := m.DNSConfig.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Healthcheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Healthcheck == nil {
				m.Healthcheck = &HealthConfig{}
			}
			if err := m.Healthcheck.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpenStdin", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OpenStdin = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerSpec_PullOptions) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PullOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PullOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 64:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegistryAuth", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegistryAuth = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerSpec_DNSConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nameservers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nameservers = append(m.Nameservers, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Search", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Search = append(m.Search, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Mode |= (EndpointSpec_ResolutionMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &PortConfig{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverConfig == nil {
				m.DriverConfig = &Driver{}
			}
			if err := m.DriverConfig.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv6Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ipv6Enabled = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Internal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Internal = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IPAM", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IPAM == nil {
				m.IPAM = &IPAMOptions{}
			}
			if err := m.IPAM.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attachable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Attachable = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptancePolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AcceptancePolicy.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Orchestration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Orchestration.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Raft", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Raft.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dispatcher", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Dispatcher.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CAConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.CAConfig.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskDefaults", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TaskDefaults.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EncryptionConfig.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecretSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecretSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecretSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], data[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSpecs(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthSpecs
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSpecs
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSpecs(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSpecs = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSpecs   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("specs.proto", fileDescriptorSpecs) }

var fileDescriptorSpecs = []byte{
	// 1640 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x57, 0xdd, 0x72, 0xdb, 0xc6,
	0x15, 0x26, 0x24, 0x8a, 0x3f, 0x07, 0x94, 0x4d, 0xed, 0xe4, 0x07, 0x66, 0x12, 0x8a, 0x66, 0xdc,
	0x54, 0x69, 0xa6, 0x72, 0xab, 0x76, 0x52, 0xa7, 0x6e, 0xa6, 0x25, 0x45, 0x56, 0x56, 0x55, 0x29,
	0x9c, 0x95, 0xe2, 0x8e, 0xaf, 0x38, 0x2b, 0x60, 0x45, 0x62, 0x04, 0x62, 0xd1, 0xdd, 0x05, 0x33,
	0xbc, 0xeb, 0x65, 0xc6, 0x17, 0x7d, 0x03, 0x5f, 0xf5, 0x19, 0xfa, 0x0e, 0xbe, 0xec, 0x65, 0x7b,
	0xa3, 0xa9, 0xf9, 0x04, 0x9d, 0xe9, 0x03, 0xb4, 0xb3, 0x8b, 0x05, 0x08, 0x26, 0x50, 0x9c, 0x99,
	0xf8, 0x6e, 0xf7, 0xe0, 0xfb, 0x0e, 0xce, 0x9e, 0xfd, 0x70, 0xce, 0x01, 0xd8, 0x22, 0xa2, 0xae,
	0xd8, 0x8f, 0x38, 0x93, 0x0c, 0x21, 0x8f, 0xb9, 0xd7, 0x94, 0xef, 0x8b, 0xaf, 0x08, 0x9f, 0x5d,
	0xfb, 0x72, 0x7f, 0xfe, 0xf3, 0x96, 0x2d, 0x17, 0x11, 0x35, 0x80, 0xd6, 0x5b, 0x13, 0x36, 0x61,
	0x7a, 0xf9, 0x50, 0xad, 0x8c, 0xf5, 0x5d, 0x2f, 0xe6, 0x44, 0xfa, 0x2c, 0x7c, 0x98, 0x2e, 0x92,
	0x07, 0xdd, 0xbf, 0x96, 0xa1, 0x76, 0xc6, 0x3c, 0x7a, 0x1e, 0x51, 0x17, 0x1d, 0x81, 0x4d, 0xc2,
	0x90, 0x49, 0x0d, 0x10, 0x8e, 0xd5, 0xb1, 0xf6, 0xec, 0x83, 0xdd, 0xfd, 0x6f, 0xbf, 0x72, 0xbf,
	0xb7, 0x82, 0xf5, 0xcb, 0x2f, 0x6f, 0x76, 0x4b, 0x38, 0xcf, 0x44, 0x3f, 0x83, 0x32, 0x67, 0x01,
	0x75, 0x36, 0x3a, 0xd6, 0xde, 0x9d, 0x83, 0xf7, 0x8b, 0x3c, 0xa8, 0x97, 0x62, 0x16, 0x50, 0xac,
	0x91, 0xe8, 0x08, 0x60, 0x46, 0x67, 0x97, 0x94, 0x8b, 0xa9, 0x1f, 0x39, 0x9b, 0x9a, 0xf7, 0xe3,
	0xdb, 0x78, 0x2a, 0xd8, 0xfd, 0xd3, 0x0c, 0x8e, 0x73, 0x54, 0x74, 0x0a, 0x0d, 0x32, 0x27, 0x7e,
	0x40, 0x2e, 0xfd, 0xc0, 0x97, 0x0b, 0xa7, 0xac, 0x5d, 0x7d, 0xfc, 0x9d, 0xae, 0x7a, 0x39, 0x02,
	0x5e, 0xa3, 0x77, 0x3d, 0x80, 0xd5, 0x8b, 0xd0, 0x47, 0x50, 0x1d, 0x0d, 0xcf, 0x06, 0xc7, 0x67,
	0x47, 0xcd, 0x52, 0xeb, 0xde, 0xf3, 0x17, 0x9d, 0xb7, 0x95, 0x8f, 0x15, 0x60, 0x44, 0x43, 0xcf,
	0x0f, 0x27, 0x68, 0x0f, 0x6a, 0xbd, 0xc3, 0xc3, 0xe1, 0xe8, 0x62, 0x38, 0x68, 0x5a, 0xad, 0xd6,
	0xf3, 0x17, 0x9d, 0x77, 0xd6, 0x81, 0x3d, 0xd7, 0xa5, 0x91, 0xa4, 0x5e, 0xab, 0xfc, 0xf5, 0xdf,
	0xda, 0xa5, 0xee, 0xd7, 0x16, 0x34, 0xf2, 0x41, 0xa0, 0x8f, 0xa0, 0xd2, 0x3b, 0xbc, 0x38, 0x7e,
	0x3a, 0x6c, 0x96, 0x56, 0xf4, 0x3c, 0xa2, 0xe7, 0x4a, 0x7f, 0x4e, 0xd1, 0x03, 0xd8, 0x1a, 0xf5,
	0xbe, 0x3c, 0x1f, 0x36, 0xad, 0x55, 0x38, 0x79, 0xd8, 0x88, 0xc4, 0x42, 0xa3, 0x06, 0xb8, 0x77,
	0x7c, 0xd6, 0xdc, 0x28, 0x46, 0x0d, 0x38, 0xf1, 0x43, 0x13, 0xca, 0xab, 0x4d, 0xb0, 0xcf, 0x29,
	0x9f, 0xfb, 0xee, 0x1b, 0xd6, 0xc4, 0xa7, 0x50, 0x96, 0x44, 0x5c, 0x6b, 0x4d, 0xd8, 0xc5, 0x9a,
	0xb8, 0x20, 0xe2, 0x5a, 0xbd, 0xd4, 0xd0, 0x35, 0x5e, 0x29, 0x83, 0xd3, 0x28, 0xf0, 0x5d, 0x22,
	0xa9, 0xa7, 0x95, 0x61, 0x1f, 0xfc, 0xa8, 0x88, 0x8d, 0x33, 0x94, 0x89, 0xff, 0x49, 0x09, 0xe7,
	0xa8, 0xe8, 0x31, 0x54, 0x26, 0x01, 0xbb, 0x24, 0x81, 0xd6, 0x84, 0x7d, 0x70, 0xbf, 0xc8, 0xc9,
	0x91, 0x46, 0xac, 0x1c, 0x18, 0x0a, 0x7a, 0x04, 0x95, 0x38, 0xf2, 0x88, 0xa4, 0x4e, 0x45, 0x93,
	0x3b, 0x45, 0xe4, 0x2f, 0x35, 0xe2, 0x90, 0x85, 0x57, 0xfe, 0x04, 0x1b, 0x3c, 0x3a, 0x81, 0x5a,
	0x48, 0xe5, 0x57, 0x8c, 0x5f, 0x0b, 0xa7, 0xda, 0xd9, 0xdc, 0xb3, 0x0f, 0x3e, 0x29, 0x14, 0x63,
	0x82, 0xe9, 0x49, 0x49, 0xdc, 0xe9, 0x8c, 0x86, 0x32, 0x71, 0xd3, 0xdf, 0x70, 0x2c, 0x9c, 0x39,
	0x40, 0xbf, 0x81, 0x1a, 0x0d, 0xbd, 0x88, 0xf9, 0xa1, 0x74, 0x6a, 0xb7, 0x07, 0x32, 0x34, 0x18,
	0x95, 0x4c, 0x9c, 0x31, 0xfa, 0x15, 0x28, 0xcf, 0x98, 0x47, 0xbb, 0x0f, 0x61, 0xe7, 0x5b, 0xc9,
	0x42, 0x2d, 0xa8, 0x99, 0x64, 0x25, 0xb7, 0x5c, 0xc6, 0xd9, 0xbe, 0x7b, 0x17, 0xb6, 0xd7, 0x12,
	0xa3, 0xcb, 0x46, 0x7a, 0x5b, 0xa8, 0x07, 0x75, 0x97, 0x85, 0x92, 0xf8, 0x21, 0xe5, 0x46, 0x20,
	0x85, 0xb9, 0x3d, 0x4c, 0x41, 0x8a, 0xf5, 0xa4, 0x84, 0x57, 0x2c, 0xf4, 0x7b, 0xa8, 0x73, 0x2a,
	0x58, 0xcc, 0x5d, 0x2a, 0x8c, 0x42, 0xf6, 0x8a, 0xef, 0x38, 0x01, 0x61, 0xfa, 0xe7, 0xd8, 0xe7,
	0x54, 0xe5, 0x49, 0xe0, 0x15, 0x15, 0x3d, 0x86, 0x2a, 0xa7, 0x42, 0x12, 0x2e, 0xbf, 0xeb, 0x92,
	0x71, 0x02, 0x19, 0xb1, 0xc0, 0x77, 0x17, 0x38, 0x65, 0xa0, 0xc7, 0x50, 0x8f, 0x02, 0xe2, 0x6a,
	0xaf, 0xce, 0x96, 0xa6, 0x7f, 0x50, 0x44, 0x1f, 0xa5, 0x20, 0xbc, 0xc2, 0xa3, 0xcf, 0x00, 0x02,
	0x36, 0x19, 0x7b, 0xdc, 0x9f, 0x53, 0x6e, 0x44, 0xd2, 0x2a, 0x62, 0x0f, 0x34, 0x02, 0xd7, 0x03,
	0x36, 0x49, 0x96, 0xe8, 0xe8, 0x07, 0x29, 0x24, 0xa7, 0x8e, 0x13, 0x00, 0x92, 0x3d, 0x35, 0xfa,
	0xf8, 0xf8, 0x7b, 0xb9, 0x32, 0x37, 0x92, 0xa3, 0xa3, 0xfb, 0xd0, 0xb8, 0x62, 0xdc, 0xa5, 0x63,
	0xa3, 0xfb, 0xba, 0xd6, 0x84, 0xad, 0x6d, 0x89, 0xd0, 0xfb, 0x75, 0xa8, 0xf2, 0x38, 0x94, 0xfe,
	0x8c, 0x76, 0x4f, 0xe0, 0xed, 0x42, 0xa7, 0xe8, 0x00, 0x1a, 0xd9, 0x35, 0x8f, 0x7d, 0x4f, 0xeb,
	0xa3, 0xde, 0xbf, 0xbb, 0xbc, 0xd9, 0xb5, 0x33, 0x3d, 0x1c, 0x0f, 0xb0, 0x9d, 0x81, 0x8e, 0xbd,
	0xee, 0xbf, 0xaa, 0xb0, 0xbd, 0x26, 0x16, 0xf4, 0x16, 0x6c, 0xf9, 0x33, 0x32, 0xa1, 0x09, 0x1d,
	0x27, 0x1b, 0x34, 0x84, 0x4a, 0x40, 0x2e, 0x69, 0xa0, 0x24, 0xa3, 0xd2, 0xf6, 0xd3, 0xd7, 0xaa,
	0x6e, 0xff, 0x8f, 0x1a, 0x3f, 0x0c, 0x25, 0x5f, 0x60, 0x43, 0x46, 0x0e, 0x54, 0x5d, 0x36, 0x9b,
	0x91, 0x50, 0x95, 0x97, 0xcd, 0xbd, 0x3a, 0x4e, 0xb7, 0x08, 0x41, 0x99, 0xf0, 0x89, 0x70, 0xca,
	0xda, 0xac, 0xd7, 0xa8, 0x09, 0x9b, 0x34, 0x9c, 0x3b, 0x5b, 0xda, 0xa4, 0x96, 0xca, 0xe2, 0xf9,
	0xc9, 0x9d, 0xd7, 0xb1, 0x5a, 0x2a, 0x5e, 0x2c, 0x28, 0x77, 0xaa, 0xda, 0xa4, 0xd7, 0xe8, 0x57,
	0x50, 0x99, 0xb1, 0x38, 0x94, 0xc2, 0xa9, 0xe9, 0x60, 0xef, 0x15, 0x05, 0x7b, 0xaa, 0x10, 0xa6,
	0xfc, 0x19, 0x38, 0x7a, 0x02, 0x3b, 0x42, 0xb2, 0x68, 0x3c, 0xe1, 0xc4, 0xa5, 0xe3, 0x88, 0x72,
	0x9f, 0x79, 0xfa, 0x36, 0x6e, 0xa9, 0xa2, 0x03, 0xd3, 0xe1, 0xf1, 0x5d, 0x45, 0x3b, 0x52, 0xac,
	0x91, 0x26, 0xa1, 0x11, 0x34, 0xa2, 0x38, 0x08, 0xc6, 0x2c, 0x4a, 0x8a, 0x39, 0x68, 0x27, 0xdf,
	0x23, 0x6b, 0xa3, 0x38, 0x08, 0xbe, 0x48, 0x48, 0xd8, 0x8e, 0x56, 0x1b, 0xf4, 0x0e, 0x54, 0x26,
	0x9c, 0xc5, 0x91, 0x70, 0x6c, 0x9d, 0x0f, 0xb3, 0x43, 0x9f, 0x43, 0x55, 0x50, 0x97, 0x53, 0x29,
	0x9c, 0x86, 0x3e, 0xed, 0x87, 0x45, 0x2f, 0x39, 0xd7, 0x10, 0x4c, 0xaf, 0x28, 0xa7, 0xa1, 0x4b,
	0x71, 0xca, 0x41, 0xf7, 0x60, 0x53, 0xca, 0x85, 0xb3, 0xdd, 0xb1, 0xf6, 0x6a, 0xfd, 0xea, 0xf2,
	0x66, 0x77, 0xf3, 0xe2, 0xe2, 0x19, 0x56, 0x36, 0x55, 0xa6, 0xa6, 0x4c, 0xc8, 0x90, 0xcc, 0xa8,
	0x73, 0x47, 0xa7, 0x37, 0xdb, 0xa3, 0x67, 0x00, 0x5e, 0x28, 0xc6, 0xae, 0xfe, 0x2e, 0x9c, 0xbb,
	0xfa, 0x74, 0x9f, 0xbc, 0xfe, 0x74, 0x83, 0xb3, 0x73, 0x53, 0x6c, 0xb7, 0x97, 0x37, 0xbb, 0xf5,
	0x6c, 0x8b, 0xeb, 0x5e, 0x28, 0x92, 0x25, 0xea, 0x83, 0x3d, 0xa5, 0x24, 0x90, 0x53, 0x77, 0x4a,
	0xdd, 0x6b, 0xa7, 0x79, 0x7b, 0xed, 0x7d, 0xa2, 0x61, 0xc6, 0x43, 0x9e, 0xa4, 0x44, 0xac, 0x42,
	0x15, 0xce, 0x8e, 0xce, 0x55, 0xb2, 0x41, 0x1f, 0x00, 0xb0, 0x88, 0x86, 0x63, 0x21, 0x3d, 0x3f,
	0x74, 0x90, 0x3a, 0x32, 0xae, 0x2b, 0xcb, 0xb9, 0x32, 0xb4, 0x3e, 0x03, 0x3b, 0xa7, 0x59, 0xa5,
	0xb5, 0x6b, 0xba, 0x30, 0x9f, 0x81, 0x5a, 0x2a, 0xaf, 0x73, 0x12, 0xc4, 0xc9, 0xb0, 0x55, 0xc7,
	0xc9, 0xe6, 0xd7, 0x1b, 0x8f, 0xac, 0xd6, 0x01, 0xd8, 0xb9, 0x8b, 0x43, 0x1f, 0xc2, 0x36, 0xa7,
	0x13, 0x5f, 0x48, 0xbe, 0x18, 0x93, 0x58, 0x4e, 0x9d, 0xdf, 0x69, 0x42, 0x23, 0x35, 0xf6, 0x62,
	0x39, 0x6d, 0x8d, 0x61, 0x75, 0x7e, 0xd4, 0x01, 0x5b, 0xe5, 0x55, 0x50, 0x3e, 0xa7, 0x5c, 0x75,
	0x05, 0x15, 0x76, 0xde, 0xa4, 0xee, 0x5f, 0x50, 0xc2, 0xdd, 0xa9, 0xfe, 0x02, 0xeb, 0xd8, 0xec,
	0xd4, 0x27, 0x95, 0x8a, 0xcc, 0x7c, 0x52, 0x66, 0xdb, 0xfd, 0xaf, 0x05, 0x8d, 0x7c, 0x7b, 0x42,
	0x87, 0x49, 0x53, 0xd2, 0x47, 0xba, 0x73, 0xf0, 0xf0, 0x75, 0xed, 0x4c, 0xb7, 0x80, 0x20, 0x56,
	0xce, 0x4e, 0xd5, 0x08, 0xa9, 0xc9, 0xe8, 0x97, 0xb0, 0x15, 0x31, 0x2e, 0xd3, 0x42, 0xd0, 0x2e,
	0x2c, 0xdb, 0x8c, 0xa7, 0x25, 0x33, 0x01, 0x77, 0xa7, 0x70, 0x67, 0xdd, 0x1b, 0x7a, 0x00, 0x9b,
	0x4f, 0x8f, 0x47, 0xcd, 0x52, 0xeb, 0xbd, 0xe7, 0x2f, 0x3a, 0xef, 0xae, 0x3f, 0x7c, 0xea, 0x73,
	0x19, 0x93, 0xe0, 0x78, 0x84, 0x7e, 0x02, 0x5b, 0x83, 0xb3, 0x73, 0x8c, 0x9b, 0x56, 0x6b, 0xf7,
	0xf9, 0x8b, 0xce, 0x7b, 0xeb, 0x38, 0xf5, 0x88, 0xc5, 0xa1, 0x87, 0xd9, 0x65, 0x36, 0x55, 0xfd,
	0x7d, 0x03, 0x6c, 0x53, 0x1f, 0xdf, 0xec, 0x54, 0xf5, 0x5b, 0xd8, 0x4e, 0x5a, 0x4e, 0xaa, 0xfa,
	0x8d, 0xd7, 0x76, 0x9e, 0x46, 0x42, 0x30, 0x77, 0x7c, 0x1f, 0x1a, 0x7e, 0x34, 0xff, 0x74, 0x4c,
	0x43, 0x72, 0x19, 0x98, 0x01, 0xab, 0x86, 0x6d, 0x65, 0x1b, 0x26, 0x26, 0xf5, 0xc9, 0xf9, 0xa1,
	0xa4, 0x3c, 0x34, 0xa3, 0x53, 0x0d, 0x67, 0x7b, 0xf4, 0x39, 0x94, 0xfd, 0x88, 0xcc, 0x4c, 0xbb,
	0x2c, 0x3c, 0xc1, 0xf1, 0xa8, 0x77, 0x6a, 0x34, 0xd8, 0xaf, 0x2d, 0x6f, 0x76, 0xcb, 0xca, 0x80,
	0x35, 0x0d, 0xb5, 0xd3, 0x8e, 0xa5, 0xde, 0xa4, 0x2b, 0x68, 0x0d, 0xe7, 0x2c, 0xdd, 0xff, 0x95,
	0xc1, 0x3e, 0x0c, 0x62, 0x21, 0x4d, 0x1f, 0x78, 0x63, 0x79, 0x7b, 0x06, 0x3b, 0x44, 0xcf, 0xe0,
	0x24, 0x54, 0x45, 0x55, 0x4f, 0x02, 0x26, 0x77, 0x0f, 0x0a, 0xdd, 0x65, 0xe0, 0x64, 0x6a, 0xe8,
	0x57, 0x94, 0x4f, 0xc7, 0xc2, 0x4d, 0xf2, 0x8d, 0x27, 0xe8, 0x1c, 0xb6, 0x19, 0x77, 0xa7, 0x54,
	0xc8, 0xa4, 0x0e, 0x9b, 0x99, 0xb5, 0xf0, 0x6f, 0xe6, 0x8b, 0x3c, 0xd0, 0x14, 0xa1, 0x24, 0xda,
	0x75, 0x1f, 0xe8, 0x11, 0x94, 0x39, 0xb9, 0x4a, 0xa7, 0x9a, 0x42, 0x7d, 0x63, 0x72, 0x25, 0xd7,
	0x5c, 0x68, 0x06, 0xfa, 0x03, 0x80, 0xe7, 0x8b, 0x88, 0x48, 0x77, 0x4a, 0xb9, 0xb9, 0xa7, 0xc2,
	0x23, 0x0e, 0x32, 0xd4, 0x9a, 0x97, 0x1c, 0x1b, 0x9d, 0x40, 0xdd, 0x25, 0xa9, 0xd2, 0x2a, 0xb7,
	0xb7, 0xa0, 0xc3, 0x9e, 0x71, 0xd1, 0x54, 0x2e, 0x96, 0x37, 0xbb, 0xb5, 0xd4, 0x82, 0x6b, 0x2e,
	0x31, 0xca, 0x3b, 0x81, 0x6d, 0x35, 0xe0, 0x8f, 0x3d, 0x7a, 0x45, 0xe2, 0x40, 0x0a, 0xdd, 0x2d,
	0x6f, 0x29, 0xaa, 0x6a, 0xd6, 0x1c, 0x18, 0x9c, 0x89, 0xab, 0x21, 0x73, 0x36, 0xf4, 0x27, 0xd8,
	0xa1, 0xa1, 0xcb, 0x17, 0x5a, 0x67, 0x69, 0x84, 0xb5, 0xdb, 0x0f, 0x3b, 0xcc, 0xc0, 0x6b, 0x87,
	0x6d, 0xd2, 0x6f, 0xd8, 0xbb, 0x3e, 0x40, 0xd2, 0xa6, 0xde, 0xac, 0xfe, 0x10, 0x94, 0x3d, 0x22,
	0x89, 0x96, 0x5c, 0x03, 0xeb, 0x75, 0xff, 0xfd, 0x97, 0xaf, 0xda, 0xa5, 0x7f, 0xbe, 0x6a, 0x97,
	0xfe, 0xf3, 0xaa, 0x6d, 0xfd, 0x65, 0xd9, 0xb6, 0x5e, 0x2e, 0xdb, 0xd6, 0x3f, 0x96, 0x6d, 0xeb,
	0xdf, 0xcb, 0xb6, 0x75, 0x59, 0xd1, 0x3f, 0xec, 0xbf, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xab, 0x02, 0x96, 0x72, 0x0f, 0x10, 0x00, 0x00,
}
