// Code generated by protoc-gen-go.
// source: api.proto
// DO NOT EDIT!

/*
Package types is a generated protocol buffer package.

It is generated from these files:
	api.proto

It has these top-level messages:
	GetServerVersionRequest
	GetServerVersionResponse
	UpdateProcessRequest
	UpdateProcessResponse
	CreateContainerRequest
	CreateContainerResponse
	SignalRequest
	SignalResponse
	AddProcessRequest
	Rlimit
	User
	AddProcessResponse
	CreateCheckpointRequest
	CreateCheckpointResponse
	DeleteCheckpointRequest
	DeleteCheckpointResponse
	ListCheckpointRequest
	Checkpoint
	ListCheckpointResponse
	StateRequest
	ContainerState
	Process
	Container
	Machine
	StateResponse
	UpdateContainerRequest
	UpdateResource
	UpdateContainerResponse
	EventsRequest
	Event
	NetworkStats
	CpuUsage
	ThrottlingData
	CpuStats
	PidsStats
	MemoryData
	MemoryStats
	BlkioStatsEntry
	BlkioStats
	HugetlbStats
	CgroupStats
	StatsResponse
	StatsRequest
*/
package types

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.ProtoPackageIsVersion1

type GetServerVersionRequest struct {
}

func (m *GetServerVersionRequest) Reset()                    { *m = GetServerVersionRequest{} }
func (m *GetServerVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServerVersionRequest) ProtoMessage()               {}
func (*GetServerVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type GetServerVersionResponse struct {
	Major    uint32 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor    uint32 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Patch    uint32 `protobuf:"varint,3,opt,name=patch" json:"patch,omitempty"`
	Revision string `protobuf:"bytes,4,opt,name=revision" json:"revision,omitempty"`
}

func (m *GetServerVersionResponse) Reset()                    { *m = GetServerVersionResponse{} }
func (m *GetServerVersionResponse) String() string            { return proto.CompactTextString(m) }
func (*GetServerVersionResponse) ProtoMessage()               {}
func (*GetServerVersionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type UpdateProcessRequest struct {
	Id         string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid        string `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	CloseStdin bool   `protobuf:"varint,3,opt,name=closeStdin" json:"closeStdin,omitempty"`
	Width      uint32 `protobuf:"varint,4,opt,name=width" json:"width,omitempty"`
	Height     uint32 `protobuf:"varint,5,opt,name=height" json:"height,omitempty"`
}

func (m *UpdateProcessRequest) Reset()                    { *m = UpdateProcessRequest{} }
func (m *UpdateProcessRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProcessRequest) ProtoMessage()               {}
func (*UpdateProcessRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type UpdateProcessResponse struct {
}

func (m *UpdateProcessResponse) Reset()                    { *m = UpdateProcessResponse{} }
func (m *UpdateProcessResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateProcessResponse) ProtoMessage()               {}
func (*UpdateProcessResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type CreateContainerRequest struct {
	Id            string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BundlePath    string   `protobuf:"bytes,2,opt,name=bundlePath" json:"bundlePath,omitempty"`
	Checkpoint    string   `protobuf:"bytes,3,opt,name=checkpoint" json:"checkpoint,omitempty"`
	Stdin         string   `protobuf:"bytes,4,opt,name=stdin" json:"stdin,omitempty"`
	Stdout        string   `protobuf:"bytes,5,opt,name=stdout" json:"stdout,omitempty"`
	Stderr        string   `protobuf:"bytes,6,opt,name=stderr" json:"stderr,omitempty"`
	Labels        []string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty"`
	NoPivotRoot   bool     `protobuf:"varint,8,opt,name=noPivotRoot" json:"noPivotRoot,omitempty"`
	Runtime       string   `protobuf:"bytes,9,opt,name=runtime" json:"runtime,omitempty"`
	RuntimeArgs   []string `protobuf:"bytes,10,rep,name=runtimeArgs" json:"runtimeArgs,omitempty"`
	CheckpointDir string   `protobuf:"bytes,11,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *CreateContainerRequest) Reset()                    { *m = CreateContainerRequest{} }
func (m *CreateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerRequest) ProtoMessage()               {}
func (*CreateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type CreateContainerResponse struct {
	Container *Container `protobuf:"bytes,1,opt,name=container" json:"container,omitempty"`
}

func (m *CreateContainerResponse) Reset()                    { *m = CreateContainerResponse{} }
func (m *CreateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerResponse) ProtoMessage()               {}
func (*CreateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateContainerResponse) GetContainer() *Container {
	if m != nil {
		return m.Container
	}
	return nil
}

type SignalRequest struct {
	Id     string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid    string `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Signal uint32 `protobuf:"varint,3,opt,name=signal" json:"signal,omitempty"`
}

func (m *SignalRequest) Reset()                    { *m = SignalRequest{} }
func (m *SignalRequest) String() string            { return proto.CompactTextString(m) }
func (*SignalRequest) ProtoMessage()               {}
func (*SignalRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type SignalResponse struct {
}

func (m *SignalResponse) Reset()                    { *m = SignalResponse{} }
func (m *SignalResponse) String() string            { return proto.CompactTextString(m) }
func (*SignalResponse) ProtoMessage()               {}
func (*SignalResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type AddProcessRequest struct {
	Id              string    `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Terminal        bool      `protobuf:"varint,2,opt,name=terminal" json:"terminal,omitempty"`
	User            *User     `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Args            []string  `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	Env             []string  `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	Cwd             string    `protobuf:"bytes,6,opt,name=cwd" json:"cwd,omitempty"`
	Pid             string    `protobuf:"bytes,7,opt,name=pid" json:"pid,omitempty"`
	Stdin           string    `protobuf:"bytes,8,opt,name=stdin" json:"stdin,omitempty"`
	Stdout          string    `protobuf:"bytes,9,opt,name=stdout" json:"stdout,omitempty"`
	Stderr          string    `protobuf:"bytes,10,opt,name=stderr" json:"stderr,omitempty"`
	Capabilities    []string  `protobuf:"bytes,11,rep,name=capabilities" json:"capabilities,omitempty"`
	ApparmorProfile string    `protobuf:"bytes,12,opt,name=apparmorProfile" json:"apparmorProfile,omitempty"`
	SelinuxLabel    string    `protobuf:"bytes,13,opt,name=selinuxLabel" json:"selinuxLabel,omitempty"`
	NoNewPrivileges bool      `protobuf:"varint,14,opt,name=noNewPrivileges" json:"noNewPrivileges,omitempty"`
	Rlimits         []*Rlimit `protobuf:"bytes,15,rep,name=rlimits" json:"rlimits,omitempty"`
}

func (m *AddProcessRequest) Reset()                    { *m = AddProcessRequest{} }
func (m *AddProcessRequest) String() string            { return proto.CompactTextString(m) }
func (*AddProcessRequest) ProtoMessage()               {}
func (*AddProcessRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *AddProcessRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *AddProcessRequest) GetRlimits() []*Rlimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type Rlimit struct {
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Soft uint64 `protobuf:"varint,2,opt,name=soft" json:"soft,omitempty"`
	Hard uint64 `protobuf:"varint,3,opt,name=hard" json:"hard,omitempty"`
}

func (m *Rlimit) Reset()                    { *m = Rlimit{} }
func (m *Rlimit) String() string            { return proto.CompactTextString(m) }
func (*Rlimit) ProtoMessage()               {}
func (*Rlimit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type User struct {
	Uid            uint32   `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	Gid            uint32   `protobuf:"varint,2,opt,name=gid" json:"gid,omitempty"`
	AdditionalGids []uint32 `protobuf:"varint,3,rep,name=additionalGids" json:"additionalGids,omitempty"`
}

func (m *User) Reset()                    { *m = User{} }
func (m *User) String() string            { return proto.CompactTextString(m) }
func (*User) ProtoMessage()               {}
func (*User) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type AddProcessResponse struct {
	SystemPid uint32 `protobuf:"varint,1,opt,name=systemPid" json:"systemPid,omitempty"`
}

func (m *AddProcessResponse) Reset()                    { *m = AddProcessResponse{} }
func (m *AddProcessResponse) String() string            { return proto.CompactTextString(m) }
func (*AddProcessResponse) ProtoMessage()               {}
func (*AddProcessResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type CreateCheckpointRequest struct {
	Id            string      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Checkpoint    *Checkpoint `protobuf:"bytes,2,opt,name=checkpoint" json:"checkpoint,omitempty"`
	CheckpointDir string      `protobuf:"bytes,3,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *CreateCheckpointRequest) Reset()                    { *m = CreateCheckpointRequest{} }
func (m *CreateCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateCheckpointRequest) ProtoMessage()               {}
func (*CreateCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *CreateCheckpointRequest) GetCheckpoint() *Checkpoint {
	if m != nil {
		return m.Checkpoint
	}
	return nil
}

type CreateCheckpointResponse struct {
}

func (m *CreateCheckpointResponse) Reset()                    { *m = CreateCheckpointResponse{} }
func (m *CreateCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateCheckpointResponse) ProtoMessage()               {}
func (*CreateCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type DeleteCheckpointRequest struct {
	Id            string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Name          string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	CheckpointDir string `protobuf:"bytes,3,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *DeleteCheckpointRequest) Reset()                    { *m = DeleteCheckpointRequest{} }
func (m *DeleteCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteCheckpointRequest) ProtoMessage()               {}
func (*DeleteCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

type DeleteCheckpointResponse struct {
}

func (m *DeleteCheckpointResponse) Reset()                    { *m = DeleteCheckpointResponse{} }
func (m *DeleteCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteCheckpointResponse) ProtoMessage()               {}
func (*DeleteCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type ListCheckpointRequest struct {
	Id            string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	CheckpointDir string `protobuf:"bytes,2,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *ListCheckpointRequest) Reset()                    { *m = ListCheckpointRequest{} }
func (m *ListCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*ListCheckpointRequest) ProtoMessage()               {}
func (*ListCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

type Checkpoint struct {
	Name        string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Exit        bool     `protobuf:"varint,2,opt,name=exit" json:"exit,omitempty"`
	Tcp         bool     `protobuf:"varint,3,opt,name=tcp" json:"tcp,omitempty"`
	UnixSockets bool     `protobuf:"varint,4,opt,name=unixSockets" json:"unixSockets,omitempty"`
	Shell       bool     `protobuf:"varint,5,opt,name=shell" json:"shell,omitempty"`
	EmptyNS     []string `protobuf:"bytes,6,rep,name=emptyNS" json:"emptyNS,omitempty"`
}

func (m *Checkpoint) Reset()                    { *m = Checkpoint{} }
func (m *Checkpoint) String() string            { return proto.CompactTextString(m) }
func (*Checkpoint) ProtoMessage()               {}
func (*Checkpoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

type ListCheckpointResponse struct {
	Checkpoints []*Checkpoint `protobuf:"bytes,1,rep,name=checkpoints" json:"checkpoints,omitempty"`
}

func (m *ListCheckpointResponse) Reset()                    { *m = ListCheckpointResponse{} }
func (m *ListCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*ListCheckpointResponse) ProtoMessage()               {}
func (*ListCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ListCheckpointResponse) GetCheckpoints() []*Checkpoint {
	if m != nil {
		return m.Checkpoints
	}
	return nil
}

type StateRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *StateRequest) Reset()                    { *m = StateRequest{} }
func (m *StateRequest) String() string            { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()               {}
func (*StateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

type ContainerState struct {
	Status string `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
}

func (m *ContainerState) Reset()                    { *m = ContainerState{} }
func (m *ContainerState) String() string            { return proto.CompactTextString(m) }
func (*ContainerState) ProtoMessage()               {}
func (*ContainerState) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

type Process struct {
	Pid             string    `protobuf:"bytes,1,opt,name=pid" json:"pid,omitempty"`
	Terminal        bool      `protobuf:"varint,2,opt,name=terminal" json:"terminal,omitempty"`
	User            *User     `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Args            []string  `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	Env             []string  `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	Cwd             string    `protobuf:"bytes,6,opt,name=cwd" json:"cwd,omitempty"`
	SystemPid       uint32    `protobuf:"varint,7,opt,name=systemPid" json:"systemPid,omitempty"`
	Stdin           string    `protobuf:"bytes,8,opt,name=stdin" json:"stdin,omitempty"`
	Stdout          string    `protobuf:"bytes,9,opt,name=stdout" json:"stdout,omitempty"`
	Stderr          string    `protobuf:"bytes,10,opt,name=stderr" json:"stderr,omitempty"`
	Capabilities    []string  `protobuf:"bytes,11,rep,name=capabilities" json:"capabilities,omitempty"`
	ApparmorProfile string    `protobuf:"bytes,12,opt,name=apparmorProfile" json:"apparmorProfile,omitempty"`
	SelinuxLabel    string    `protobuf:"bytes,13,opt,name=selinuxLabel" json:"selinuxLabel,omitempty"`
	NoNewPrivileges bool      `protobuf:"varint,14,opt,name=noNewPrivileges" json:"noNewPrivileges,omitempty"`
	Rlimits         []*Rlimit `protobuf:"bytes,15,rep,name=rlimits" json:"rlimits,omitempty"`
}

func (m *Process) Reset()                    { *m = Process{} }
func (m *Process) String() string            { return proto.CompactTextString(m) }
func (*Process) ProtoMessage()               {}
func (*Process) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *Process) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *Process) GetRlimits() []*Rlimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type Container struct {
	Id         string     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BundlePath string     `protobuf:"bytes,2,opt,name=bundlePath" json:"bundlePath,omitempty"`
	Processes  []*Process `protobuf:"bytes,3,rep,name=processes" json:"processes,omitempty"`
	Status     string     `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	Labels     []string   `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty"`
	Pids       []uint32   `protobuf:"varint,6,rep,name=pids" json:"pids,omitempty"`
	Runtime    string     `protobuf:"bytes,7,opt,name=runtime" json:"runtime,omitempty"`
}

func (m *Container) Reset()                    { *m = Container{} }
func (m *Container) String() string            { return proto.CompactTextString(m) }
func (*Container) ProtoMessage()               {}
func (*Container) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *Container) GetProcesses() []*Process {
	if m != nil {
		return m.Processes
	}
	return nil
}

// Machine is information about machine on which containerd is run
type Machine struct {
	Cpus   uint32 `protobuf:"varint,1,opt,name=cpus" json:"cpus,omitempty"`
	Memory uint64 `protobuf:"varint,2,opt,name=memory" json:"memory,omitempty"`
}

func (m *Machine) Reset()                    { *m = Machine{} }
func (m *Machine) String() string            { return proto.CompactTextString(m) }
func (*Machine) ProtoMessage()               {}
func (*Machine) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

// StateResponse is information about containerd daemon
type StateResponse struct {
	Containers []*Container `protobuf:"bytes,1,rep,name=containers" json:"containers,omitempty"`
	Machine    *Machine     `protobuf:"bytes,2,opt,name=machine" json:"machine,omitempty"`
}

func (m *StateResponse) Reset()                    { *m = StateResponse{} }
func (m *StateResponse) String() string            { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()               {}
func (*StateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *StateResponse) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *StateResponse) GetMachine() *Machine {
	if m != nil {
		return m.Machine
	}
	return nil
}

type UpdateContainerRequest struct {
	Id        string          `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid       string          `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Status    string          `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	Resources *UpdateResource `protobuf:"bytes,4,opt,name=resources" json:"resources,omitempty"`
}

func (m *UpdateContainerRequest) Reset()                    { *m = UpdateContainerRequest{} }
func (m *UpdateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateContainerRequest) ProtoMessage()               {}
func (*UpdateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *UpdateContainerRequest) GetResources() *UpdateResource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type UpdateResource struct {
	BlkioWeight          uint64 `protobuf:"varint,1,opt,name=blkioWeight" json:"blkioWeight,omitempty"`
	CpuShares            uint64 `protobuf:"varint,2,opt,name=cpuShares" json:"cpuShares,omitempty"`
	CpuPeriod            uint64 `protobuf:"varint,3,opt,name=cpuPeriod" json:"cpuPeriod,omitempty"`
	CpuQuota             uint64 `protobuf:"varint,4,opt,name=cpuQuota" json:"cpuQuota,omitempty"`
	CpusetCpus           string `protobuf:"bytes,5,opt,name=cpusetCpus" json:"cpusetCpus,omitempty"`
	CpusetMems           string `protobuf:"bytes,6,opt,name=cpusetMems" json:"cpusetMems,omitempty"`
	MemoryLimit          uint64 `protobuf:"varint,7,opt,name=memoryLimit" json:"memoryLimit,omitempty"`
	MemorySwap           uint64 `protobuf:"varint,8,opt,name=memorySwap" json:"memorySwap,omitempty"`
	MemoryReservation    uint64 `protobuf:"varint,9,opt,name=memoryReservation" json:"memoryReservation,omitempty"`
	KernelMemoryLimit    uint64 `protobuf:"varint,10,opt,name=kernelMemoryLimit" json:"kernelMemoryLimit,omitempty"`
	KernelTCPMemoryLimit uint64 `protobuf:"varint,11,opt,name=kernelTCPMemoryLimit" json:"kernelTCPMemoryLimit,omitempty"`
}

func (m *UpdateResource) Reset()                    { *m = UpdateResource{} }
func (m *UpdateResource) String() string            { return proto.CompactTextString(m) }
func (*UpdateResource) ProtoMessage()               {}
func (*UpdateResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

type UpdateContainerResponse struct {
}

func (m *UpdateContainerResponse) Reset()                    { *m = UpdateContainerResponse{} }
func (m *UpdateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateContainerResponse) ProtoMessage()               {}
func (*UpdateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

type EventsRequest struct {
	// Tag 1 is deprecated (old uint64 timestamp)
	Timestamp  *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
	StoredOnly bool                       `protobuf:"varint,3,opt,name=storedOnly" json:"storedOnly,omitempty"`
	Id         string                     `protobuf:"bytes,4,opt,name=id" json:"id,omitempty"`
}

func (m *EventsRequest) Reset()                    { *m = EventsRequest{} }
func (m *EventsRequest) String() string            { return proto.CompactTextString(m) }
func (*EventsRequest) ProtoMessage()               {}
func (*EventsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *EventsRequest) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type Event struct {
	Type   string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Id     string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	Status uint32 `protobuf:"varint,3,opt,name=status" json:"status,omitempty"`
	Pid    string `protobuf:"bytes,4,opt,name=pid" json:"pid,omitempty"`
	// Tag 5 is deprecated (old uint64 timestamp)
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *Event) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type NetworkStats struct {
	Name       string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	RxBytes    uint64 `protobuf:"varint,2,opt,name=rx_bytes,json=rxBytes" json:"rx_bytes,omitempty"`
	Rx_Packets uint64 `protobuf:"varint,3,opt,name=rx_Packets,json=rxPackets" json:"rx_Packets,omitempty"`
	RxErrors   uint64 `protobuf:"varint,4,opt,name=Rx_errors,json=rxErrors" json:"Rx_errors,omitempty"`
	RxDropped  uint64 `protobuf:"varint,5,opt,name=Rx_dropped,json=rxDropped" json:"Rx_dropped,omitempty"`
	TxBytes    uint64 `protobuf:"varint,6,opt,name=Tx_bytes,json=txBytes" json:"Tx_bytes,omitempty"`
	TxPackets  uint64 `protobuf:"varint,7,opt,name=Tx_packets,json=txPackets" json:"Tx_packets,omitempty"`
	TxErrors   uint64 `protobuf:"varint,8,opt,name=Tx_errors,json=txErrors" json:"Tx_errors,omitempty"`
	TxDropped  uint64 `protobuf:"varint,9,opt,name=Tx_dropped,json=txDropped" json:"Tx_dropped,omitempty"`
}

func (m *NetworkStats) Reset()                    { *m = NetworkStats{} }
func (m *NetworkStats) String() string            { return proto.CompactTextString(m) }
func (*NetworkStats) ProtoMessage()               {}
func (*NetworkStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type CpuUsage struct {
	TotalUsage        uint64   `protobuf:"varint,1,opt,name=total_usage,json=totalUsage" json:"total_usage,omitempty"`
	PercpuUsage       []uint64 `protobuf:"varint,2,rep,name=percpu_usage,json=percpuUsage" json:"percpu_usage,omitempty"`
	UsageInKernelmode uint64   `protobuf:"varint,3,opt,name=usage_in_kernelmode,json=usageInKernelmode" json:"usage_in_kernelmode,omitempty"`
	UsageInUsermode   uint64   `protobuf:"varint,4,opt,name=usage_in_usermode,json=usageInUsermode" json:"usage_in_usermode,omitempty"`
}

func (m *CpuUsage) Reset()                    { *m = CpuUsage{} }
func (m *CpuUsage) String() string            { return proto.CompactTextString(m) }
func (*CpuUsage) ProtoMessage()               {}
func (*CpuUsage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

type ThrottlingData struct {
	Periods          uint64 `protobuf:"varint,1,opt,name=periods" json:"periods,omitempty"`
	ThrottledPeriods uint64 `protobuf:"varint,2,opt,name=throttled_periods,json=throttledPeriods" json:"throttled_periods,omitempty"`
	ThrottledTime    uint64 `protobuf:"varint,3,opt,name=throttled_time,json=throttledTime" json:"throttled_time,omitempty"`
}

func (m *ThrottlingData) Reset()                    { *m = ThrottlingData{} }
func (m *ThrottlingData) String() string            { return proto.CompactTextString(m) }
func (*ThrottlingData) ProtoMessage()               {}
func (*ThrottlingData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

type CpuStats struct {
	CpuUsage       *CpuUsage       `protobuf:"bytes,1,opt,name=cpu_usage,json=cpuUsage" json:"cpu_usage,omitempty"`
	ThrottlingData *ThrottlingData `protobuf:"bytes,2,opt,name=throttling_data,json=throttlingData" json:"throttling_data,omitempty"`
	SystemUsage    uint64          `protobuf:"varint,3,opt,name=system_usage,json=systemUsage" json:"system_usage,omitempty"`
}

func (m *CpuStats) Reset()                    { *m = CpuStats{} }
func (m *CpuStats) String() string            { return proto.CompactTextString(m) }
func (*CpuStats) ProtoMessage()               {}
func (*CpuStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *CpuStats) GetCpuUsage() *CpuUsage {
	if m != nil {
		return m.CpuUsage
	}
	return nil
}

func (m *CpuStats) GetThrottlingData() *ThrottlingData {
	if m != nil {
		return m.ThrottlingData
	}
	return nil
}

type PidsStats struct {
	Current uint64 `protobuf:"varint,1,opt,name=current" json:"current,omitempty"`
	Limit   uint64 `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
}

func (m *PidsStats) Reset()                    { *m = PidsStats{} }
func (m *PidsStats) String() string            { return proto.CompactTextString(m) }
func (*PidsStats) ProtoMessage()               {}
func (*PidsStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

type MemoryData struct {
	Usage    uint64 `protobuf:"varint,1,opt,name=usage" json:"usage,omitempty"`
	MaxUsage uint64 `protobuf:"varint,2,opt,name=max_usage,json=maxUsage" json:"max_usage,omitempty"`
	Failcnt  uint64 `protobuf:"varint,3,opt,name=failcnt" json:"failcnt,omitempty"`
	Limit    uint64 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *MemoryData) Reset()                    { *m = MemoryData{} }
func (m *MemoryData) String() string            { return proto.CompactTextString(m) }
func (*MemoryData) ProtoMessage()               {}
func (*MemoryData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

type MemoryStats struct {
	Cache       uint64            `protobuf:"varint,1,opt,name=cache" json:"cache,omitempty"`
	Usage       *MemoryData       `protobuf:"bytes,2,opt,name=usage" json:"usage,omitempty"`
	SwapUsage   *MemoryData       `protobuf:"bytes,3,opt,name=swap_usage,json=swapUsage" json:"swap_usage,omitempty"`
	KernelUsage *MemoryData       `protobuf:"bytes,4,opt,name=kernel_usage,json=kernelUsage" json:"kernel_usage,omitempty"`
	Stats       map[string]uint64 `protobuf:"bytes,5,rep,name=stats" json:"stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
}

func (m *MemoryStats) Reset()                    { *m = MemoryStats{} }
func (m *MemoryStats) String() string            { return proto.CompactTextString(m) }
func (*MemoryStats) ProtoMessage()               {}
func (*MemoryStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *MemoryStats) GetUsage() *MemoryData {
	if m != nil {
		return m.Usage
	}
	return nil
}

func (m *MemoryStats) GetSwapUsage() *MemoryData {
	if m != nil {
		return m.SwapUsage
	}
	return nil
}

func (m *MemoryStats) GetKernelUsage() *MemoryData {
	if m != nil {
		return m.KernelUsage
	}
	return nil
}

func (m *MemoryStats) GetStats() map[string]uint64 {
	if m != nil {
		return m.Stats
	}
	return nil
}

type BlkioStatsEntry struct {
	Major uint64 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor uint64 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Op    string `protobuf:"bytes,3,opt,name=op" json:"op,omitempty"`
	Value uint64 `protobuf:"varint,4,opt,name=value" json:"value,omitempty"`
}

func (m *BlkioStatsEntry) Reset()                    { *m = BlkioStatsEntry{} }
func (m *BlkioStatsEntry) String() string            { return proto.CompactTextString(m) }
func (*BlkioStatsEntry) ProtoMessage()               {}
func (*BlkioStatsEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

type BlkioStats struct {
	IoServiceBytesRecursive []*BlkioStatsEntry `protobuf:"bytes,1,rep,name=io_service_bytes_recursive,json=ioServiceBytesRecursive" json:"io_service_bytes_recursive,omitempty"`
	IoServicedRecursive     []*BlkioStatsEntry `protobuf:"bytes,2,rep,name=io_serviced_recursive,json=ioServicedRecursive" json:"io_serviced_recursive,omitempty"`
	IoQueuedRecursive       []*BlkioStatsEntry `protobuf:"bytes,3,rep,name=io_queued_recursive,json=ioQueuedRecursive" json:"io_queued_recursive,omitempty"`
	IoServiceTimeRecursive  []*BlkioStatsEntry `protobuf:"bytes,4,rep,name=io_service_time_recursive,json=ioServiceTimeRecursive" json:"io_service_time_recursive,omitempty"`
	IoWaitTimeRecursive     []*BlkioStatsEntry `protobuf:"bytes,5,rep,name=io_wait_time_recursive,json=ioWaitTimeRecursive" json:"io_wait_time_recursive,omitempty"`
	IoMergedRecursive       []*BlkioStatsEntry `protobuf:"bytes,6,rep,name=io_merged_recursive,json=ioMergedRecursive" json:"io_merged_recursive,omitempty"`
	IoTimeRecursive         []*BlkioStatsEntry `protobuf:"bytes,7,rep,name=io_time_recursive,json=ioTimeRecursive" json:"io_time_recursive,omitempty"`
	SectorsRecursive        []*BlkioStatsEntry `protobuf:"bytes,8,rep,name=sectors_recursive,json=sectorsRecursive" json:"sectors_recursive,omitempty"`
}

func (m *BlkioStats) Reset()                    { *m = BlkioStats{} }
func (m *BlkioStats) String() string            { return proto.CompactTextString(m) }
func (*BlkioStats) ProtoMessage()               {}
func (*BlkioStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *BlkioStats) GetIoServiceBytesRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServiceBytesRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoServicedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServicedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoQueuedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoQueuedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoServiceTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServiceTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoWaitTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoWaitTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoMergedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoMergedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetSectorsRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.SectorsRecursive
	}
	return nil
}

type HugetlbStats struct {
	Usage    uint64 `protobuf:"varint,1,opt,name=usage" json:"usage,omitempty"`
	MaxUsage uint64 `protobuf:"varint,2,opt,name=max_usage,json=maxUsage" json:"max_usage,omitempty"`
	Failcnt  uint64 `protobuf:"varint,3,opt,name=failcnt" json:"failcnt,omitempty"`
	Limit    uint64 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *HugetlbStats) Reset()                    { *m = HugetlbStats{} }
func (m *HugetlbStats) String() string            { return proto.CompactTextString(m) }
func (*HugetlbStats) ProtoMessage()               {}
func (*HugetlbStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

type CgroupStats struct {
	CpuStats     *CpuStats                `protobuf:"bytes,1,opt,name=cpu_stats,json=cpuStats" json:"cpu_stats,omitempty"`
	MemoryStats  *MemoryStats             `protobuf:"bytes,2,opt,name=memory_stats,json=memoryStats" json:"memory_stats,omitempty"`
	BlkioStats   *BlkioStats              `protobuf:"bytes,3,opt,name=blkio_stats,json=blkioStats" json:"blkio_stats,omitempty"`
	HugetlbStats map[string]*HugetlbStats `protobuf:"bytes,4,rep,name=hugetlb_stats,json=hugetlbStats" json:"hugetlb_stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	PidsStats    *PidsStats               `protobuf:"bytes,5,opt,name=pids_stats,json=pidsStats" json:"pids_stats,omitempty"`
}

func (m *CgroupStats) Reset()                    { *m = CgroupStats{} }
func (m *CgroupStats) String() string            { return proto.CompactTextString(m) }
func (*CgroupStats) ProtoMessage()               {}
func (*CgroupStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *CgroupStats) GetCpuStats() *CpuStats {
	if m != nil {
		return m.CpuStats
	}
	return nil
}

func (m *CgroupStats) GetMemoryStats() *MemoryStats {
	if m != nil {
		return m.MemoryStats
	}
	return nil
}

func (m *CgroupStats) GetBlkioStats() *BlkioStats {
	if m != nil {
		return m.BlkioStats
	}
	return nil
}

func (m *CgroupStats) GetHugetlbStats() map[string]*HugetlbStats {
	if m != nil {
		return m.HugetlbStats
	}
	return nil
}

func (m *CgroupStats) GetPidsStats() *PidsStats {
	if m != nil {
		return m.PidsStats
	}
	return nil
}

type StatsResponse struct {
	NetworkStats []*NetworkStats `protobuf:"bytes,1,rep,name=network_stats,json=networkStats" json:"network_stats,omitempty"`
	CgroupStats  *CgroupStats    `protobuf:"bytes,2,opt,name=cgroup_stats,json=cgroupStats" json:"cgroup_stats,omitempty"`
	// Tag 3 is deprecated (old uint64 timestamp)
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *StatsResponse) Reset()                    { *m = StatsResponse{} }
func (m *StatsResponse) String() string            { return proto.CompactTextString(m) }
func (*StatsResponse) ProtoMessage()               {}
func (*StatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *StatsResponse) GetNetworkStats() []*NetworkStats {
	if m != nil {
		return m.NetworkStats
	}
	return nil
}

func (m *StatsResponse) GetCgroupStats() *CgroupStats {
	if m != nil {
		return m.CgroupStats
	}
	return nil
}

func (m *StatsResponse) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type StatsRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *StatsRequest) Reset()                    { *m = StatsRequest{} }
func (m *StatsRequest) String() string            { return proto.CompactTextString(m) }
func (*StatsRequest) ProtoMessage()               {}
func (*StatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func init() {
	proto.RegisterType((*GetServerVersionRequest)(nil), "types.GetServerVersionRequest")
	proto.RegisterType((*GetServerVersionResponse)(nil), "types.GetServerVersionResponse")
	proto.RegisterType((*UpdateProcessRequest)(nil), "types.UpdateProcessRequest")
	proto.RegisterType((*UpdateProcessResponse)(nil), "types.UpdateProcessResponse")
	proto.RegisterType((*CreateContainerRequest)(nil), "types.CreateContainerRequest")
	proto.RegisterType((*CreateContainerResponse)(nil), "types.CreateContainerResponse")
	proto.RegisterType((*SignalRequest)(nil), "types.SignalRequest")
	proto.RegisterType((*SignalResponse)(nil), "types.SignalResponse")
	proto.RegisterType((*AddProcessRequest)(nil), "types.AddProcessRequest")
	proto.RegisterType((*Rlimit)(nil), "types.Rlimit")
	proto.RegisterType((*User)(nil), "types.User")
	proto.RegisterType((*AddProcessResponse)(nil), "types.AddProcessResponse")
	proto.RegisterType((*CreateCheckpointRequest)(nil), "types.CreateCheckpointRequest")
	proto.RegisterType((*CreateCheckpointResponse)(nil), "types.CreateCheckpointResponse")
	proto.RegisterType((*DeleteCheckpointRequest)(nil), "types.DeleteCheckpointRequest")
	proto.RegisterType((*DeleteCheckpointResponse)(nil), "types.DeleteCheckpointResponse")
	proto.RegisterType((*ListCheckpointRequest)(nil), "types.ListCheckpointRequest")
	proto.RegisterType((*Checkpoint)(nil), "types.Checkpoint")
	proto.RegisterType((*ListCheckpointResponse)(nil), "types.ListCheckpointResponse")
	proto.RegisterType((*StateRequest)(nil), "types.StateRequest")
	proto.RegisterType((*ContainerState)(nil), "types.ContainerState")
	proto.RegisterType((*Process)(nil), "types.Process")
	proto.RegisterType((*Container)(nil), "types.Container")
	proto.RegisterType((*Machine)(nil), "types.Machine")
	proto.RegisterType((*StateResponse)(nil), "types.StateResponse")
	proto.RegisterType((*UpdateContainerRequest)(nil), "types.UpdateContainerRequest")
	proto.RegisterType((*UpdateResource)(nil), "types.UpdateResource")
	proto.RegisterType((*UpdateContainerResponse)(nil), "types.UpdateContainerResponse")
	proto.RegisterType((*EventsRequest)(nil), "types.EventsRequest")
	proto.RegisterType((*Event)(nil), "types.Event")
	proto.RegisterType((*NetworkStats)(nil), "types.NetworkStats")
	proto.RegisterType((*CpuUsage)(nil), "types.CpuUsage")
	proto.RegisterType((*ThrottlingData)(nil), "types.ThrottlingData")
	proto.RegisterType((*CpuStats)(nil), "types.CpuStats")
	proto.RegisterType((*PidsStats)(nil), "types.PidsStats")
	proto.RegisterType((*MemoryData)(nil), "types.MemoryData")
	proto.RegisterType((*MemoryStats)(nil), "types.MemoryStats")
	proto.RegisterType((*BlkioStatsEntry)(nil), "types.BlkioStatsEntry")
	proto.RegisterType((*BlkioStats)(nil), "types.BlkioStats")
	proto.RegisterType((*HugetlbStats)(nil), "types.HugetlbStats")
	proto.RegisterType((*CgroupStats)(nil), "types.CgroupStats")
	proto.RegisterType((*StatsResponse)(nil), "types.StatsResponse")
	proto.RegisterType((*StatsRequest)(nil), "types.StatsRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion2

// Client API for API service

type APIClient interface {
	GetServerVersion(ctx context.Context, in *GetServerVersionRequest, opts ...grpc.CallOption) (*GetServerVersionResponse, error)
	CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error)
	UpdateContainer(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error)
	Signal(ctx context.Context, in *SignalRequest, opts ...grpc.CallOption) (*SignalResponse, error)
	UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*UpdateProcessResponse, error)
	AddProcess(ctx context.Context, in *AddProcessRequest, opts ...grpc.CallOption) (*AddProcessResponse, error)
	CreateCheckpoint(ctx context.Context, in *CreateCheckpointRequest, opts ...grpc.CallOption) (*CreateCheckpointResponse, error)
	DeleteCheckpoint(ctx context.Context, in *DeleteCheckpointRequest, opts ...grpc.CallOption) (*DeleteCheckpointResponse, error)
	ListCheckpoint(ctx context.Context, in *ListCheckpointRequest, opts ...grpc.CallOption) (*ListCheckpointResponse, error)
	State(ctx context.Context, in *StateRequest, opts ...grpc.CallOption) (*StateResponse, error)
	Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (API_EventsClient, error)
	Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (*StatsResponse, error)
}

type aPIClient struct {
	cc *grpc.ClientConn
}

func NewAPIClient(cc *grpc.ClientConn) APIClient {
	return &aPIClient{cc}
}

func (c *aPIClient) GetServerVersion(ctx context.Context, in *GetServerVersionRequest, opts ...grpc.CallOption) (*GetServerVersionResponse, error) {
	out := new(GetServerVersionResponse)
	err := grpc.Invoke(ctx, "/types.API/GetServerVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error) {
	out := new(CreateContainerResponse)
	err := grpc.Invoke(ctx, "/types.API/CreateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) UpdateContainer(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error) {
	out := new(UpdateContainerResponse)
	err := grpc.Invoke(ctx, "/types.API/UpdateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) Signal(ctx context.Context, in *SignalRequest, opts ...grpc.CallOption) (*SignalResponse, error) {
	out := new(SignalResponse)
	err := grpc.Invoke(ctx, "/types.API/Signal", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*UpdateProcessResponse, error) {
	out := new(UpdateProcessResponse)
	err := grpc.Invoke(ctx, "/types.API/UpdateProcess", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) AddProcess(ctx context.Context, in *AddProcessRequest, opts ...grpc.CallOption) (*AddProcessResponse, error) {
	out := new(AddProcessResponse)
	err := grpc.Invoke(ctx, "/types.API/AddProcess", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) CreateCheckpoint(ctx context.Context, in *CreateCheckpointRequest, opts ...grpc.CallOption) (*CreateCheckpointResponse, error) {
	out := new(CreateCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/CreateCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) DeleteCheckpoint(ctx context.Context, in *DeleteCheckpointRequest, opts ...grpc.CallOption) (*DeleteCheckpointResponse, error) {
	out := new(DeleteCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/DeleteCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) ListCheckpoint(ctx context.Context, in *ListCheckpointRequest, opts ...grpc.CallOption) (*ListCheckpointResponse, error) {
	out := new(ListCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/ListCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) State(ctx context.Context, in *StateRequest, opts ...grpc.CallOption) (*StateResponse, error) {
	out := new(StateResponse)
	err := grpc.Invoke(ctx, "/types.API/State", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (API_EventsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_API_serviceDesc.Streams[0], c.cc, "/types.API/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &aPIEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type API_EventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type aPIEventsClient struct {
	grpc.ClientStream
}

func (x *aPIEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aPIClient) Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (*StatsResponse, error) {
	out := new(StatsResponse)
	err := grpc.Invoke(ctx, "/types.API/Stats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for API service

type APIServer interface {
	GetServerVersion(context.Context, *GetServerVersionRequest) (*GetServerVersionResponse, error)
	CreateContainer(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error)
	UpdateContainer(context.Context, *UpdateContainerRequest) (*UpdateContainerResponse, error)
	Signal(context.Context, *SignalRequest) (*SignalResponse, error)
	UpdateProcess(context.Context, *UpdateProcessRequest) (*UpdateProcessResponse, error)
	AddProcess(context.Context, *AddProcessRequest) (*AddProcessResponse, error)
	CreateCheckpoint(context.Context, *CreateCheckpointRequest) (*CreateCheckpointResponse, error)
	DeleteCheckpoint(context.Context, *DeleteCheckpointRequest) (*DeleteCheckpointResponse, error)
	ListCheckpoint(context.Context, *ListCheckpointRequest) (*ListCheckpointResponse, error)
	State(context.Context, *StateRequest) (*StateResponse, error)
	Events(*EventsRequest, API_EventsServer) error
	Stats(context.Context, *StatsRequest) (*StatsResponse, error)
}

func RegisterAPIServer(s *grpc.Server, srv APIServer) {
	s.RegisterService(&_API_serviceDesc, srv)
}

func _API_GetServerVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).GetServerVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/GetServerVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).GetServerVersion(ctx, req.(*GetServerVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_CreateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).CreateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/CreateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).CreateContainer(ctx, req.(*CreateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_UpdateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).UpdateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/UpdateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).UpdateContainer(ctx, req.(*UpdateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_Signal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).Signal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/Signal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).Signal(ctx, req.(*SignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_UpdateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).UpdateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/UpdateProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).UpdateProcess(ctx, req.(*UpdateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_AddProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).AddProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/AddProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).AddProcess(ctx, req.(*AddProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_CreateCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).CreateCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/CreateCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).CreateCheckpoint(ctx, req.(*CreateCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_DeleteCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).DeleteCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/DeleteCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).DeleteCheckpoint(ctx, req.(*DeleteCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_ListCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).ListCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/ListCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).ListCheckpoint(ctx, req.(*ListCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_State_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).State(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/State",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).State(ctx, req.(*StateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(APIServer).Events(m, &aPIEventsServer{stream})
}

type API_EventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type aPIEventsServer struct {
	grpc.ServerStream
}

func (x *aPIEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _API_Stats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).Stats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/Stats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).Stats(ctx, req.(*StatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _API_serviceDesc = grpc.ServiceDesc{
	ServiceName: "types.API",
	HandlerType: (*APIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetServerVersion",
			Handler:    _API_GetServerVersion_Handler,
		},
		{
			MethodName: "CreateContainer",
			Handler:    _API_CreateContainer_Handler,
		},
		{
			MethodName: "UpdateContainer",
			Handler:    _API_UpdateContainer_Handler,
		},
		{
			MethodName: "Signal",
			Handler:    _API_Signal_Handler,
		},
		{
			MethodName: "UpdateProcess",
			Handler:    _API_UpdateProcess_Handler,
		},
		{
			MethodName: "AddProcess",
			Handler:    _API_AddProcess_Handler,
		},
		{
			MethodName: "CreateCheckpoint",
			Handler:    _API_CreateCheckpoint_Handler,
		},
		{
			MethodName: "DeleteCheckpoint",
			Handler:    _API_DeleteCheckpoint_Handler,
		},
		{
			MethodName: "ListCheckpoint",
			Handler:    _API_ListCheckpoint_Handler,
		},
		{
			MethodName: "State",
			Handler:    _API_State_Handler,
		},
		{
			MethodName: "Stats",
			Handler:    _API_Stats_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Events",
			Handler:       _API_Events_Handler,
			ServerStreams: true,
		},
	},
}

var fileDescriptor0 = []byte{
	// 2418 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xec, 0x59, 0x4b, 0x93, 0x1b, 0x49,
	0x11, 0xb6, 0xa4, 0x1e, 0x69, 0x94, 0x7a, 0xcc, 0x4c, 0xaf, 0x3d, 0x96, 0xb5, 0xeb, 0x07, 0x1d,
	0x0b, 0x18, 0xd8, 0x90, 0x8d, 0xbc, 0x1b, 0x38, 0x20, 0x82, 0x08, 0x7b, 0x6c, 0x16, 0xb3, 0xb6,
	0x57, 0xee, 0x99, 0x61, 0x8f, 0x8a, 0x1e, 0xa9, 0x2c, 0x35, 0xd3, 0xea, 0xee, 0xed, 0x2e, 0xcd,
	0x68, 0x2e, 0x1c, 0x38, 0xc0, 0x0d, 0xae, 0x44, 0xc0, 0x8d, 0x1b, 0x77, 0x0e, 0xf0, 0x07, 0x88,
	0xe0, 0x87, 0x70, 0xe3, 0xce, 0x91, 0xac, 0x77, 0xb5, 0x1e, 0x33, 0xf6, 0x81, 0xe0, 0xc2, 0x45,
	0x51, 0xf9, 0x55, 0x56, 0x66, 0x56, 0x56, 0x66, 0x56, 0x76, 0x09, 0xea, 0x41, 0x1a, 0xf6, 0xd2,
	0x2c, 0xa1, 0x89, 0xbb, 0x45, 0x2f, 0x52, 0x92, 0x77, 0xef, 0x4e, 0x92, 0x64, 0x12, 0x91, 0x07,
	0x1c, 0x3c, 0x99, 0xbf, 0x7d, 0x40, 0xc3, 0x19, 0xc9, 0x69, 0x30, 0x4b, 0x05, 0x9f, 0x77, 0x0b,
	0x6e, 0x7e, 0x4e, 0xe8, 0x21, 0xc9, 0xce, 0x48, 0xf6, 0x73, 0x92, 0xe5, 0x61, 0x12, 0xfb, 0xe4,
	0xeb, 0x39, 0xf2, 0x78, 0x0b, 0xe8, 0xac, 0x4e, 0xe5, 0x69, 0x12, 0xe7, 0xc4, 0xbd, 0x0e, 0x5b,
	0xb3, 0xe0, 0x17, 0x49, 0xd6, 0x29, 0xdd, 0x2b, 0xdd, 0x6f, 0xf9, 0x82, 0xe0, 0x68, 0x18, 0x23,
	0x5a, 0x96, 0x28, 0x23, 0x18, 0x9a, 0x06, 0x74, 0x34, 0xed, 0x54, 0x04, 0xca, 0x09, 0xb7, 0x0b,
	0xdb, 0x19, 0x39, 0x0b, 0x99, 0xd4, 0x8e, 0x83, 0x13, 0x75, 0x5f, 0xd3, 0xde, 0xaf, 0x4b, 0x70,
	0xfd, 0x38, 0x1d, 0x07, 0x94, 0x0c, 0xb2, 0x64, 0x44, 0xf2, 0x5c, 0x9a, 0xe4, 0xb6, 0xa1, 0x1c,
	0x8e, 0xb9, 0xce, 0xba, 0x8f, 0x23, 0x77, 0x17, 0x2a, 0x29, 0x02, 0x65, 0x0e, 0xb0, 0xa1, 0x7b,
	0x07, 0x60, 0x14, 0x25, 0x39, 0x39, 0xa4, 0xe3, 0x30, 0xe6, 0x1a, 0xb7, 0x7d, 0x0b, 0x61, 0xc6,
	0x9c, 0x87, 0x63, 0x3a, 0xe5, 0x3a, 0xd1, 0x18, 0x4e, 0xb8, 0xfb, 0x50, 0x9d, 0x92, 0x70, 0x32,
	0xa5, 0x9d, 0x2d, 0x0e, 0x4b, 0xca, 0xbb, 0x09, 0x37, 0x96, 0xec, 0x10, 0xfb, 0xf7, 0xfe, 0x51,
	0x86, 0xfd, 0x83, 0x8c, 0xe0, 0xcc, 0x41, 0x12, 0xd3, 0x20, 0x8c, 0x49, 0xb6, 0xc9, 0x46, 0xb4,
	0xe8, 0x64, 0x1e, 0x8f, 0x23, 0x32, 0x08, 0x50, 0xad, 0x30, 0xd5, 0x42, 0xb8, 0xc5, 0x53, 0x32,
	0x3a, 0x4d, 0x93, 0x30, 0xa6, 0xdc, 0x62, 0x9c, 0x37, 0x08, 0xb3, 0x38, 0xe7, 0x9b, 0x11, 0x5e,
	0x12, 0x04, 0xb3, 0x18, 0x07, 0xc9, 0x5c, 0x58, 0x5c, 0xf7, 0x25, 0x25, 0x71, 0x92, 0x65, 0x9d,
	0xaa, 0xc6, 0x91, 0x62, 0x78, 0x14, 0x9c, 0x90, 0x28, 0xef, 0xd4, 0xee, 0x55, 0x18, 0x2e, 0x28,
	0xf7, 0x1e, 0x34, 0xe2, 0x64, 0x10, 0x9e, 0x25, 0xd4, 0x4f, 0x12, 0xda, 0xd9, 0xe6, 0x0e, 0xb3,
	0x21, 0xb7, 0x03, 0xb5, 0x6c, 0x1e, 0xb3, 0xb8, 0xe9, 0xd4, 0xb9, 0x48, 0x45, 0xb2, 0xb5, 0x72,
	0xf8, 0x24, 0x9b, 0xe4, 0x1d, 0xe0, 0x82, 0x6d, 0xc8, 0xfd, 0x18, 0x5a, 0x66, 0x27, 0xcf, 0xc2,
	0xac, 0xd3, 0xe0, 0x12, 0x8a, 0xa0, 0xf7, 0x02, 0x6e, 0xae, 0xf8, 0x52, 0xc6, 0x59, 0x0f, 0xea,
	0x23, 0x05, 0x72, 0x9f, 0x36, 0xfa, 0xbb, 0x3d, 0x1e, 0xda, 0x3d, 0xc3, 0x6c, 0x58, 0x50, 0x54,
	0xeb, 0x30, 0x9c, 0xc4, 0x41, 0xf4, 0xee, 0x11, 0xc3, 0x3c, 0xc6, 0x97, 0xc8, 0xf8, 0x94, 0x94,
	0xb7, 0x0b, 0x6d, 0x25, 0x4a, 0x1e, 0xfa, 0x5f, 0x2a, 0xb0, 0xf7, 0x64, 0x3c, 0xbe, 0x22, 0x26,
	0x31, 0xb0, 0x29, 0xc9, 0x30, 0xf4, 0x51, 0x62, 0x99, 0xbb, 0x53, 0xd3, 0xee, 0x5d, 0x70, 0xe6,
	0x39, 0xee, 0xa4, 0xc2, 0x77, 0xd2, 0x90, 0x3b, 0x39, 0x46, 0xc8, 0xe7, 0x13, 0xae, 0x0b, 0x4e,
	0xc0, 0x7c, 0xe9, 0x70, 0x5f, 0xf2, 0x31, 0x33, 0x99, 0xc4, 0x67, 0x78, 0xce, 0x0c, 0x62, 0x43,
	0x86, 0x8c, 0xce, 0xc7, 0xf2, 0x84, 0xd9, 0x50, 0x6d, 0xab, 0x66, 0xb6, 0xa5, 0xc3, 0x66, 0x7b,
	0x7d, 0xd8, 0xd4, 0x37, 0x84, 0x0d, 0x14, 0xc2, 0xc6, 0x83, 0xe6, 0x28, 0x48, 0x83, 0x93, 0x30,
	0x0a, 0x69, 0x48, 0x72, 0x3c, 0x3f, 0x66, 0x44, 0x01, 0x73, 0xef, 0xc3, 0x4e, 0x90, 0xa6, 0x41,
	0x36, 0x4b, 0x32, 0x74, 0xcd, 0xdb, 0x30, 0x22, 0x9d, 0x26, 0x17, 0xb2, 0x0c, 0x33, 0x69, 0x39,
	0x89, 0xc2, 0x78, 0xbe, 0x78, 0xc9, 0xa2, 0xaf, 0xd3, 0xe2, 0x6c, 0x05, 0x8c, 0x49, 0x8b, 0x93,
	0xd7, 0xe4, 0x7c, 0x90, 0x85, 0x67, 0xb8, 0x66, 0x82, 0x4a, 0xdb, 0xdc, 0x8b, 0xcb, 0xb0, 0xfb,
	0x6d, 0x0c, 0xcc, 0x28, 0x9c, 0x85, 0x34, 0xef, 0xec, 0xa0, 0x59, 0x8d, 0x7e, 0x4b, 0xfa, 0xd3,
	0xe7, 0xa8, 0xaf, 0x66, 0xbd, 0x67, 0x50, 0x15, 0x10, 0x73, 0x2f, 0x63, 0x91, 0xa7, 0xc5, 0xc7,
	0x0c, 0xcb, 0x93, 0xb7, 0x94, 0x9f, 0x95, 0xe3, 0xf3, 0x31, 0xc3, 0xa6, 0x41, 0x36, 0xe6, 0xe7,
	0x84, 0x18, 0x1b, 0x7b, 0x3e, 0x38, 0xec, 0xa0, 0x98, 0xab, 0xe7, 0xf2, 0xc0, 0x5b, 0x3e, 0x1b,
	0x32, 0x64, 0x22, 0x63, 0x0a, 0x11, 0x1c, 0xba, 0xdf, 0x82, 0x76, 0x30, 0x1e, 0xa3, 0x7b, 0x12,
	0x3c, 0xf5, 0xcf, 0xc3, 0x71, 0x8e, 0x92, 0x2a, 0x38, 0xb9, 0x84, 0x7a, 0x7d, 0x70, 0xed, 0x80,
	0x92, 0x41, 0xff, 0x11, 0xd4, 0xf3, 0x8b, 0x9c, 0x92, 0xd9, 0x40, 0xeb, 0x31, 0x80, 0xf7, 0xab,
	0x92, 0x4e, 0x17, 0x9d, 0x45, 0x9b, 0x62, 0xf1, 0xfb, 0x85, 0xda, 0x52, 0xe6, 0x51, 0xb7, 0xa7,
	0xf2, 0xc7, 0xac, 0xb6, 0xcb, 0xcd, 0x4a, 0xca, 0x56, 0xd6, 0xa5, 0x6c, 0x17, 0x3a, 0xab, 0x36,
	0xc8, 0x34, 0x19, 0xc1, 0xcd, 0x67, 0x24, 0x22, 0xef, 0x62, 0x1f, 0xfa, 0x39, 0x0e, 0xb0, 0xb0,
	0x88, 0x74, 0xe4, 0xe3, 0x77, 0x37, 0x60, 0x55, 0x89, 0x34, 0xe0, 0x15, 0xdc, 0x78, 0x19, 0xe6,
	0xf4, 0x6a, 0xf5, 0x2b, 0xaa, 0xca, 0xeb, 0x54, 0xfd, 0xbe, 0x04, 0x60, 0x64, 0x69, 0x9b, 0x4b,
	0x96, 0xcd, 0x88, 0x91, 0x45, 0x48, 0x65, 0xbe, 0xf3, 0x31, 0x8b, 0x0a, 0x3a, 0x4a, 0xe5, 0x15,
	0xc4, 0x86, 0xac, 0x5e, 0xce, 0xe3, 0x70, 0x71, 0x98, 0x8c, 0x4e, 0x09, 0xcd, 0x79, 0x3d, 0xc7,
	0x5a, 0x6b, 0x41, 0x3c, 0x69, 0xa7, 0x24, 0x8a, 0x78, 0x51, 0xdf, 0xf6, 0x05, 0xc1, 0x2a, 0x30,
	0x99, 0xa5, 0xf4, 0xe2, 0xf5, 0x21, 0xa6, 0x3c, 0xcb, 0x3f, 0x45, 0xe2, 0x4e, 0xf7, 0x97, 0x77,
	0x2a, 0x63, 0xe8, 0x11, 0x34, 0xcc, 0x2e, 0x72, 0x34, 0xb6, 0xb2, 0xfe, 0xe8, 0x6d, 0x2e, 0xef,
	0x0e, 0x34, 0x0f, 0x29, 0x1e, 0xea, 0x06, 0x7f, 0x79, 0xf7, 0xa1, 0xad, 0xab, 0x2e, 0x67, 0x14,
	0x75, 0x23, 0xa0, 0xf3, 0x5c, 0x72, 0x49, 0xca, 0xfb, 0x6b, 0x05, 0x6a, 0x32, 0xac, 0x55, 0x6d,
	0x2a, 0x99, 0xda, 0xf4, 0x3f, 0x29, 0x91, 0x85, 0xac, 0xaa, 0x2d, 0x65, 0xd5, 0xff, 0xcb, 0xa5,
	0x29, 0x97, 0x7f, 0x2f, 0x41, 0x5d, 0x1f, 0xf3, 0x7b, 0xb7, 0x33, 0x9f, 0x40, 0x3d, 0x15, 0x07,
	0x4f, 0x44, 0xd5, 0x6b, 0xf4, 0xdb, 0x52, 0x91, 0xaa, 0x73, 0x86, 0xc1, 0x8a, 0x1f, 0xc7, 0x8e,
	0x1f, 0xab, 0x5d, 0xd9, 0x2a, 0xb4, 0x2b, 0x78, 0xf8, 0x29, 0x2b, 0xa7, 0x55, 0x5e, 0x4e, 0xf9,
	0xd8, 0x6e, 0x50, 0x6a, 0x85, 0x06, 0xc5, 0xfb, 0x0c, 0x6a, 0xaf, 0x82, 0xd1, 0x14, 0xf7, 0xc1,
	0x16, 0x8e, 0x52, 0x19, 0xa6, 0xb8, 0x90, 0x8d, 0x99, 0x92, 0x19, 0x41, 0x7f, 0x5f, 0xc8, 0xda,
	0x2f, 0x29, 0xef, 0x14, 0x9b, 0x08, 0x91, 0x06, 0x32, 0x99, 0x1e, 0x62, 0x19, 0x55, 0x0e, 0x51,
	0xb9, 0xb4, 0xda, 0x86, 0x58, 0x3c, 0x78, 0x2c, 0xb5, 0x99, 0xd0, 0x2c, 0xab, 0xae, 0xf2, 0x81,
	0xb4, 0xc7, 0x57, 0xd3, 0xde, 0x6f, 0x4a, 0xb0, 0x2f, 0x7a, 0xcc, 0x2b, 0x3b, 0xc9, 0xf5, 0xbd,
	0x8b, 0x70, 0x5f, 0xa5, 0xe0, 0xbe, 0x47, 0x50, 0xcf, 0x48, 0x9e, 0xcc, 0x33, 0x74, 0x33, 0xf7,
	0x6c, 0xa3, 0x7f, 0x43, 0x65, 0x12, 0xd7, 0xe5, 0xcb, 0x59, 0xdf, 0xf0, 0x79, 0x7f, 0xac, 0x40,
	0xbb, 0x38, 0xcb, 0x2a, 0xd6, 0x49, 0x74, 0x1a, 0x26, 0x5f, 0x89, 0xe6, 0xb8, 0xc4, 0xdd, 0x64,
	0x43, 0x2c, 0xab, 0xd0, 0x97, 0x87, 0x78, 0x43, 0xa2, 0x26, 0xe1, 0x46, 0x03, 0xc8, 0xd9, 0x01,
	0xc9, 0xc2, 0x44, 0x5d, 0xa6, 0x06, 0x60, 0x65, 0x00, 0x89, 0x37, 0xf3, 0x84, 0x06, 0xdc, 0x48,
	0xc7, 0xd7, 0x34, 0xef, 0x8a, 0xf1, 0x8c, 0x08, 0x3d, 0x60, 0xa7, 0xb6, 0x25, 0xbb, 0x62, 0x8d,
	0x98, 0xf9, 0x57, 0x64, 0x96, 0xcb, 0x34, 0xb7, 0x10, 0x66, 0xb9, 0x38, 0xcd, 0x97, 0x2c, 0xa8,
	0x79, 0x60, 0xa0, 0xe5, 0x16, 0xc4, 0x24, 0x08, 0xf2, 0xf0, 0x3c, 0x48, 0x79, 0xda, 0x3b, 0xbe,
	0x85, 0x60, 0x20, 0xef, 0x09, 0x0a, 0xbd, 0x81, 0xdf, 0x40, 0x01, 0xbb, 0xb6, 0x79, 0x19, 0x70,
	0xfc, 0xd5, 0x09, 0xc6, 0x7d, 0x4a, 0xb2, 0x98, 0x44, 0xaf, 0x2c, 0xad, 0x20, 0xb8, 0x57, 0x26,
	0xdc, 0x3e, 0x5c, 0x17, 0xe0, 0xd1, 0xc1, 0xc0, 0x5e, 0xd0, 0xe0, 0x0b, 0xd6, 0xce, 0xb1, 0x2f,
	0xb5, 0x95, 0x38, 0x91, 0x17, 0xde, 0x05, 0xb4, 0x9e, 0x9f, 0x11, 0xac, 0xe0, 0x2a, 0x72, 0x1e,
	0x43, 0x5d, 0x7f, 0xe8, 0xc9, 0x00, 0xec, 0xf6, 0xc4, 0xa7, 0x60, 0x4f, 0x7d, 0x0a, 0xf6, 0x8e,
	0x14, 0x87, 0x6f, 0x98, 0x99, 0x57, 0x72, 0x9a, 0x64, 0x64, 0xfc, 0x65, 0x1c, 0x5d, 0xa8, 0xef,
	0x27, 0x83, 0xc8, 0x98, 0x74, 0xf4, 0x95, 0xf0, 0xbb, 0x12, 0x6c, 0x71, 0xdd, 0x6b, 0x7b, 0x2b,
	0xc1, 0x5d, 0xd6, 0x11, 0x5c, 0x8c, 0xd7, 0x96, 0x8e, 0x57, 0x19, 0xd9, 0x8e, 0x89, 0xec, 0xc2,
	0x0e, 0xaa, 0xef, 0xb1, 0x03, 0xef, 0xb7, 0x65, 0x68, 0xbe, 0x26, 0xf4, 0x3c, 0xc9, 0x4e, 0x59,
	0x16, 0xe7, 0x6b, 0x2f, 0xec, 0x5b, 0xf8, 0xf5, 0xb9, 0x18, 0x9e, 0x5c, 0x50, 0x1d, 0xb5, 0xb5,
	0x6c, 0xf1, 0x94, 0x91, 0xee, 0x6d, 0x00, 0x9c, 0x1a, 0x04, 0xe2, 0x92, 0x96, 0x41, 0x9b, 0x2d,
	0x24, 0xe0, 0x7e, 0x08, 0x75, 0x7f, 0x31, 0xc4, 0x62, 0x9f, 0x64, 0xb9, 0x8a, 0xda, 0x6c, 0xf1,
	0x9c, 0xd3, 0x6c, 0x2d, 0x4e, 0x8e, 0xb3, 0x24, 0x4d, 0xc9, 0x98, 0x47, 0x2d, 0x5f, 0xfb, 0x4c,
	0x00, 0x4c, 0xeb, 0x91, 0xd2, 0x5a, 0x15, 0x5a, 0xa9, 0xd1, 0x8a, 0x53, 0xa9, 0xd4, 0x2a, 0xc2,
	0xb5, 0x4e, 0x6d, 0xad, 0x47, 0x5a, 0xab, 0x88, 0xd5, 0x6d, 0x6a, 0x69, 0x3d, 0x32, 0x5a, 0xeb,
	0x6a, 0xad, 0xd4, 0xea, 0xfd, 0xb9, 0x04, 0xdb, 0x98, 0x33, 0xc7, 0x79, 0x30, 0x21, 0x78, 0xbd,
	0x36, 0x28, 0xe6, 0x57, 0x34, 0x9c, 0x33, 0x52, 0x66, 0x34, 0x70, 0x48, 0x30, 0x7c, 0x03, 0x9a,
	0x29, 0xc9, 0x30, 0x93, 0x24, 0x47, 0x19, 0xab, 0x1d, 0x66, 0x8e, 0xc0, 0x04, 0x4b, 0x0f, 0x3e,
	0xe0, 0x73, 0xc3, 0x30, 0x1e, 0x8a, 0x50, 0x9d, 0x25, 0x63, 0x22, 0x5d, 0xb5, 0xc7, 0xa7, 0x5e,
	0xc4, 0x5f, 0xe8, 0x09, 0xf7, 0xbb, 0xb0, 0xa7, 0xf9, 0xd9, 0x15, 0xce, 0xb9, 0x85, 0xeb, 0x76,
	0x24, 0xf7, 0xb1, 0x84, 0xbd, 0x5f, 0x42, 0xfb, 0x68, 0x8a, 0xe7, 0x4b, 0xf1, 0x8e, 0x9b, 0x3c,
	0x0b, 0xb0, 0x12, 0x60, 0x79, 0x4f, 0x79, 0xbd, 0xc8, 0xa5, 0xb5, 0x8a, 0x74, 0xbf, 0x07, 0x7b,
	0x54, 0xf0, 0x92, 0xf1, 0x50, 0xf1, 0x88, 0xd3, 0xdc, 0xd5, 0x13, 0x03, 0xc9, 0xfc, 0x4d, 0x68,
	0x1b, 0x66, 0x7e, 0x59, 0x08, 0x7b, 0x5b, 0x1a, 0x65, 0xd1, 0xe4, 0xfd, 0x41, 0x38, 0x4b, 0x44,
	0xce, 0x27, 0xbc, 0x7c, 0x59, 0xae, 0x6a, 0xf4, 0x77, 0x54, 0xd9, 0x97, 0xce, 0xe0, 0x25, 0x4b,
	0xb8, 0xe5, 0xc7, 0xb0, 0x43, 0xb5, 0xe9, 0x43, 0xcc, 0xd4, 0x40, 0xa6, 0x9e, 0x2a, 0xbd, 0xc5,
	0x8d, 0xf9, 0x6d, 0x5a, 0xdc, 0x28, 0x7a, 0x5e, 0xf4, 0x23, 0x52, 0xa1, 0xb0, 0xaf, 0x21, 0x30,
	0xae, 0xc2, 0xfb, 0x11, 0xd4, 0xb1, 0x59, 0xc9, 0x85, 0x75, 0xe8, 0x98, 0xd1, 0x3c, 0xcb, 0x30,
	0xf7, 0x94, 0x63, 0x24, 0xc9, 0x9a, 0x19, 0x7e, 0x97, 0x4b, 0x67, 0x08, 0xc2, 0x4b, 0x00, 0x44,
	0x3d, 0xe1, 0xda, 0x90, 0xc7, 0x0e, 0x01, 0x41, 0xb0, 0x38, 0x9b, 0x05, 0x0b, 0x7d, 0xf4, 0x3c,
	0xce, 0x10, 0x10, 0x1b, 0x44, 0x85, 0x6f, 0x83, 0x30, 0x1a, 0xc9, 0x67, 0x0a, 0x54, 0x28, 0x49,
	0xa3, 0xd0, 0xb1, 0x15, 0xfe, 0xa9, 0x0c, 0x0d, 0xa1, 0x51, 0x18, 0x8c, 0x5c, 0x23, 0xbc, 0xf5,
	0xb4, 0x4a, 0x4e, 0x60, 0x5f, 0xb2, 0x65, 0xd4, 0x99, 0x1e, 0xd5, 0x98, 0xaa, 0x6c, 0xc3, 0x5b,
	0x38, 0xc7, 0xc2, 0x6c, 0x79, 0x67, 0x2d, 0x77, 0x9d, 0x31, 0x09, 0x83, 0x3f, 0x85, 0xa6, 0x88,
	0x4f, 0xb9, 0xc6, 0xd9, 0xb4, 0xa6, 0x21, 0xd8, 0xc4, 0xaa, 0x47, 0xac, 0x15, 0x44, 0x7b, 0x79,
	0xeb, 0xd1, 0xe8, 0xdf, 0x2e, 0xb0, 0xf3, 0x9d, 0xf4, 0xf8, 0xef, 0xf3, 0x98, 0xe2, 0x1d, 0x20,
	0x78, 0xbb, 0x8f, 0x01, 0x0c, 0xc8, 0xea, 0xd9, 0x29, 0xb9, 0x50, 0x2d, 0x2f, 0x0e, 0xd9, 0xde,
	0xcf, 0x82, 0x68, 0xae, 0x9c, 0x2a, 0x88, 0x1f, 0x96, 0x1f, 0x97, 0xf0, 0x73, 0x69, 0xe7, 0x29,
	0xbb, 0x50, 0xad, 0xe5, 0x85, 0xd7, 0x35, 0x67, 0xed, 0xeb, 0x9a, 0xa3, 0x5e, 0xd7, 0xb0, 0xc4,
	0x26, 0xa9, 0xbc, 0xfe, 0x71, 0x64, 0x14, 0x39, 0x96, 0x22, 0xef, 0x9f, 0x0e, 0x80, 0xd1, 0xe2,
	0x1e, 0x42, 0x37, 0x4c, 0x86, 0xec, 0xf6, 0x0a, 0x47, 0x44, 0x14, 0xa4, 0x61, 0x46, 0x30, 0x7c,
	0xf2, 0xf0, 0x8c, 0xc8, 0x06, 0x67, 0x5f, 0xee, 0x7b, 0xc9, 0x38, 0xff, 0x26, 0x52, 0x62, 0x21,
	0xaf, 0x5c, 0xbe, 0x5a, 0xe6, 0xfe, 0x0c, 0x6e, 0x18, 0xa1, 0x63, 0x4b, 0x5e, 0xf9, 0x52, 0x79,
	0x1f, 0x68, 0x79, 0x63, 0x23, 0xeb, 0x27, 0x80, 0xf0, 0x10, 0x2f, 0xb3, 0x79, 0x41, 0x52, 0xe5,
	0x52, 0x49, 0x7b, 0x61, 0xf2, 0x86, 0xaf, 0x30, 0x72, 0xde, 0xc0, 0x2d, 0x6b, 0xa3, 0x2c, 0xed,
	0x2d, 0x69, 0xce, 0xa5, 0xd2, 0xf6, 0xb5, 0x5d, 0xac, 0x30, 0x18, 0x91, 0x5f, 0x00, 0xce, 0x0c,
	0xcf, 0x83, 0x90, 0x2e, 0xcb, 0xdb, 0xba, 0x6a, 0x9f, 0x5f, 0xe1, 0xa2, 0xa2, 0x30, 0xb1, 0xcf,
	0x19, 0xc9, 0x26, 0x85, 0x7d, 0x56, 0xaf, 0xda, 0xe7, 0x2b, 0xbe, 0xc2, 0xc8, 0x79, 0x0a, 0x08,
	0x2e, 0xdb, 0x53, 0xbb, 0x54, 0xca, 0x4e, 0x98, 0x14, 0x6d, 0x39, 0x80, 0xbd, 0x9c, 0x8c, 0xf0,
	0xaa, 0xb7, 0x63, 0x61, 0xfb, 0x52, 0x19, 0xbb, 0x72, 0x81, 0x16, 0xe2, 0x7d, 0x0d, 0xcd, 0x9f,
	0xce, 0x27, 0x84, 0x46, 0x27, 0x3a, 0xe7, 0xff, 0xdb, 0x65, 0xe6, 0xdf, 0x58, 0x66, 0x0e, 0x26,
	0x59, 0x32, 0x4f, 0x0b, 0x55, 0x5b, 0xe4, 0xf0, 0x4a, 0xd5, 0xe6, 0x3c, 0xbc, 0x6a, 0x0b, 0xee,
	0xcf, 0xa0, 0x29, 0xba, 0x39, 0xb9, 0x40, 0x54, 0x21, 0x77, 0x35, 0xe9, 0x55, 0xf7, 0x28, 0x96,
	0xf5, 0x65, 0x67, 0x2c, 0x57, 0x15, 0xab, 0x91, 0x71, 0x13, 0x7e, 0x1a, 0x99, 0xac, 0x7b, 0x01,
	0xad, 0xa9, 0xf0, 0x8d, 0x5c, 0x25, 0x02, 0xf0, 0x63, 0x65, 0x9c, 0xd9, 0x43, 0xcf, 0xf6, 0xa1,
	0x70, 0x75, 0x73, 0x6a, 0xbb, 0xf5, 0x01, 0x00, 0xfb, 0xf6, 0x19, 0xaa, 0x42, 0x65, 0x3f, 0x8c,
	0xea, 0x1b, 0x02, 0x3f, 0xb4, 0xd4, 0xb0, 0x7b, 0x04, 0x7b, 0x2b, 0x32, 0xd7, 0x94, 0xa9, 0xef,
	0xd8, 0x65, 0xaa, 0xd1, 0xff, 0x40, 0x8a, 0xb4, 0x97, 0xda, 0xb5, 0xeb, 0x6f, 0x25, 0xf1, 0xa9,
	0x64, 0xde, 0xae, 0x1e, 0x43, 0x2b, 0x16, 0xcd, 0x97, 0x3e, 0x80, 0x8a, 0x25, 0xc8, 0x6e, 0xcc,
	0xfc, 0x66, 0x6c, 0xb7, 0x69, 0x78, 0x10, 0x23, 0xee, 0x81, 0xb5, 0x07, 0x61, 0x39, 0xc7, 0x6f,
	0x8c, 0xac, 0xd3, 0x2e, 0x34, 0x8a, 0xce, 0xfb, 0x34, 0x8a, 0xf2, 0xb5, 0x63, 0xd3, 0x43, 0x6e,
	0xff, 0x5f, 0x55, 0xa8, 0x3c, 0x19, 0xbc, 0x70, 0x8f, 0x61, 0x77, 0xf9, 0x7f, 0x10, 0xf7, 0x8e,
	0x34, 0x6b, 0xc3, 0x7f, 0x27, 0xdd, 0xbb, 0x1b, 0xe7, 0x65, 0xcb, 0x7e, 0xcd, 0xf5, 0x61, 0x67,
	0xe9, 0xd5, 0xdb, 0x55, 0x57, 0xcd, 0xfa, 0x7f, 0x16, 0xba, 0x77, 0x36, 0x4d, 0xdb, 0x32, 0x97,
	0xbe, 0x11, 0xb4, 0xcc, 0xf5, 0xdf, 0x98, 0x5a, 0xe6, 0xa6, 0x4f, 0x8b, 0x6b, 0xee, 0x0f, 0xa0,
	0x2a, 0xde, 0xc1, 0xdd, 0xeb, 0x92, 0xb7, 0xf0, 0xc2, 0xde, 0xbd, 0xb1, 0x84, 0xea, 0x85, 0x2f,
	0xa1, 0x55, 0xf8, 0xf3, 0xc4, 0xfd, 0xb0, 0xa0, 0xab, 0xf8, 0x8c, 0xde, 0xfd, 0x68, 0xfd, 0xa4,
	0x96, 0x76, 0x00, 0x60, 0x9e, 0x4a, 0xdd, 0x8e, 0xe4, 0x5e, 0x79, 0x8e, 0xef, 0xde, 0x5a, 0x33,
	0xa3, 0x85, 0xe0, 0x51, 0x2e, 0x3f, 0x5b, 0xba, 0x4b, 0x5e, 0x5d, 0x7e, 0x34, 0xd4, 0x47, 0xb9,
	0xf1, 0xbd, 0x93, 0x8b, 0x5d, 0x7e, 0x8c, 0xd4, 0x62, 0x37, 0x3c, 0x85, 0x6a, 0xb1, 0x1b, 0x5f,
	0x31, 0xaf, 0xb9, 0x5f, 0x42, 0xbb, 0xf8, 0xba, 0xe7, 0x2a, 0x27, 0xad, 0x7d, 0xde, 0xec, 0xde,
	0xde, 0x30, 0xab, 0x05, 0x7e, 0x0a, 0x5b, 0xe2, 0xd9, 0x4e, 0xa5, 0xa3, 0xfd, 0xda, 0xd7, 0xbd,
	0x5e, 0x04, 0xf5, 0xaa, 0x87, 0x50, 0x15, 0x5f, 0x97, 0x3a, 0x00, 0x0a, 0x1f, 0x9b, 0xdd, 0xa6,
	0x8d, 0x7a, 0xd7, 0x1e, 0x96, 0x94, 0x9e, 0xbc, 0xa0, 0x27, 0x5f, 0xa7, 0xc7, 0x3a, 0x9c, 0x93,
	0x2a, 0x4f, 0xd7, 0x47, 0xff, 0x09, 0x00, 0x00, 0xff, 0xff, 0xe1, 0xb6, 0x90, 0xeb, 0xc6, 0x1c,
	0x00, 0x00,
}
