// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/endpoint.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// `Endpoint` describes a network endpoint that serves a set of APIs.
// A service may expose any number of endpoints, and all endpoints share the
// same service configuration, such as quota configuration and monitoring
// configuration.
//
// Example service configuration:
//
//     name: library-example.googleapis.com
//     endpoints:
//       # Below entry makes 'google.example.library.v1.Library'
//       # API be served from endpoint address library-example.googleapis.com.
//       # It also allows HTTP OPTIONS calls to be passed to the backend, for
//       # it to decide whether the subsequent cross-origin request is
//       # allowed to proceed.
//     - name: library-example.googleapis.com
//       apis: google.example.library.v1.Library
//       allow_cors: true
//       # Below entry makes 'google.example.library.v1.Library'
//       # API be served from endpoint address
//       # google.example.library-example.v1.LibraryManager.
//     - name: library-manager.googleapis.com
//       apis: google.example.library.v1.LibraryManager
//       # BNS address for a borg job. Can specify a task by appending
//       # "/taskId" (e.g. "/0") to the job spec.
//
// Example OpenAPI extension for endpoint with allow_cors set to true:
//
//     {
//       "swagger": "2.0",
//       "info": {
//         "description": "A simple..."
//       },
//       "host": "MY_PROJECT_ID.appspot.com",
//       "x-google-endpoints": [{
//         "name": "MY_PROJECT_ID.appspot.com",
//         "allow_cors": "true"
//       }]
//     }
type Endpoint struct {
	// The canonical name of this endpoint.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// DEPRECATED: This field is no longer supported. Instead of using aliases,
	// please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
	// alias.
	//
	// Additional names that this endpoint will be hosted on.
	Aliases []string `protobuf:"bytes,2,rep,name=aliases" json:"aliases,omitempty"`
	// The list of APIs served by this endpoint.
	Apis []string `protobuf:"bytes,3,rep,name=apis" json:"apis,omitempty"`
	// The list of features enabled on this endpoint.
	Features []string `protobuf:"bytes,4,rep,name=features" json:"features,omitempty"`
	// Allowing
	// [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
	// cross-domain traffic, would allow the backends served from this endpoint to
	// receive and respond to HTTP OPTIONS requests. The response will be used by
	// the browser to determine whether the subsequent cross-origin request is
	// allowed to proceed.
	AllowCors bool `protobuf:"varint,5,opt,name=allow_cors,json=allowCors" json:"allow_cors,omitempty"`
}

func (m *Endpoint) Reset()                    { *m = Endpoint{} }
func (m *Endpoint) String() string            { return proto.CompactTextString(m) }
func (*Endpoint) ProtoMessage()               {}
func (*Endpoint) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{0} }

func init() {
	proto.RegisterType((*Endpoint)(nil), "google.api.Endpoint")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/endpoint.proto", fileDescriptor8)
}

var fileDescriptor8 = []byte{
	// 234 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x8f, 0xc1, 0x4a, 0x03, 0x31,
	0x10, 0x86, 0xd9, 0x76, 0xd5, 0xed, 0x80, 0x1e, 0x72, 0x0a, 0x05, 0xa1, 0x78, 0xea, 0x69, 0x73,
	0xf0, 0x09, 0xac, 0xa8, 0xf4, 0xb6, 0xf4, 0x05, 0x64, 0x5c, 0xa7, 0x21, 0x90, 0xce, 0x2c, 0x49,
	0xd4, 0x47, 0xf0, 0x3d, 0x7c, 0x52, 0xb3, 0x69, 0x57, 0xef, 0xbd, 0x84, 0x99, 0x2f, 0x3f, 0xff,
	0xff, 0x0f, 0x3c, 0x5b, 0x11, 0xeb, 0xa9, 0xb5, 0xe2, 0x91, 0x6d, 0x2b, 0xc1, 0x1a, 0x4b, 0x3c,
	0x04, 0x49, 0x62, 0x8e, 0x5f, 0x38, 0xb8, 0x68, 0xf2, 0x63, 0x22, 0x85, 0x4f, 0xd7, 0x53, 0x2f,
	0xbc, 0x77, 0xd6, 0x10, 0xbf, 0x0f, 0xe2, 0x38, 0xb5, 0x45, 0xab, 0xe0, 0xe4, 0x93, 0x85, 0xcb,
	0xed, 0xb9, 0x9e, 0xc8, 0x2c, 0x09, 0x93, 0x13, 0x8e, 0x47, 0xdb, 0xbb, 0xef, 0x0a, 0x9a, 0xa7,
	0x53, 0x92, 0x52, 0x50, 0x33, 0x1e, 0x48, 0x57, 0xab, 0x6a, 0xbd, 0xd8, 0x95, 0x59, 0x69, 0xb8,
	0x42, 0xef, 0x30, 0x52, 0xd4, 0xb3, 0xd5, 0x3c, 0xe3, 0x69, 0x1d, 0xd5, 0x63, 0x8c, 0x9e, 0x17,
	0x5c, 0x66, 0xb5, 0x84, 0x66, 0x4f, 0x98, 0x3e, 0x42, 0x96, 0xd7, 0x85, 0xff, 0xed, 0xea, 0x16,
	0x00, 0xbd, 0x97, 0xaf, 0xd7, 0x5e, 0x42, 0xd4, 0x17, 0x39, 0xa3, 0xd9, 0x2d, 0x0a, 0x79, 0xcc,
	0x60, 0xb3, 0x86, 0x9b, 0x5e, 0x0e, 0xed, 0xff, 0x99, 0x9b, 0xeb, 0xa9, 0x58, 0x37, 0x56, 0xed,
	0xaa, 0x9f, 0x59, 0xfd, 0xf2, 0xd0, 0x6d, 0xdf, 0x2e, 0x4b, 0xf5, 0xfb, 0xdf, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x2f, 0xf3, 0xbc, 0x78, 0x5b, 0x01, 0x00, 0x00,
}
