<!--[metadata]>
+++
aliases = [
"/mac/last_page/",
"/windows/last_page/",
"/linux/last_page/",
]
title = "Learning more"
description = "Getting started with Docker"
keywords = ["beginner, getting started, Docker"]
[menu.main]
identifier = "getstart_learn_more"
parent = "tutorial_getstart_menu"
weight = 7
+++
<![end-metadata]-->

# Learning more

This getting started provided very basic essentials for using Docker on Mac, Windows, and Linux. If you want to learn more with regard to end-to-end development, start with the full install instructions and feature overviews, then follow up with more advanced tutorials and user guides.

Depending on your interest, the Docker documentation contains a wealth of information.  Here are some places to start:

<style type="text/css">
</style>
<table class="tutorial">
  <tr>
    <th class="tg-031e">If you are looking for</th>
    <th class="tg-031e">Where to find it</th>
  </tr>
  <tr>
    <td class="tg-031e">More about Docker for Mac, features, examples, FAQs, relationship to Docker Machine and Docker Toolbox, and how this fits in the Docker ecosystem</td>
    <td class="tg-031e">[Getting Started with Docker for Mac](https://docs.docker.com/docker-for-mac/)</td>
  </tr>
  <tr>
    <td class="tg-031e">More about Docker for Windows, features, examples, FAQs, relationship to Docker Machine and Docker Toolbox, and how this fits in the Docker ecosystem</td>
    <td class="tg-031e">[Getting Started with Docker for Windows](https://docs.docker.com/docker-for-windows/)</td>
  </tr>
  <tr>
    <td class="tg-031e">More about Docker Toolbox</td>
    <td class="tg-031e">[Docker Toolbox Overview](/toolbox/overview.md)</td>
  </tr>
  <tr>
    <td class="tg-031e">More about Docker for Linux distributions</td>
    <td class="tg-031e">[Install Docker Engine on Linux](/engine/installation/linux/index.md)</td>
  </tr>
  <tr>
    <td class="tg-031e">More advanced tutorials on running containers, building your own images, networking containers, managing data for containers, and storing images on Docker Hub</td>
    <td class="tg-031e"> [Learn by example](/engine/tutorials/index.md)</a></td>
  </tr>
  <tr>
    <td class="tg-031e">Information about the Docker product line</td>
    <td class="tg-031e"><a href="http://www.docker.com/products/">The product explainer is a good place to start.</a></td>
  </tr>

  <tr>
    <td class="tg-031e">How to set up an automated build on Docker Hub</td>
    <td class="tg-031e"><a href="https://docs.docker.com/docker-hub/">Docker Hub documentation</a></td>
  </tr>
  <tr>
    <td class="tg-031e">How to run a multi-container application with Compose</td>
    <td class="tg-031e"> [Docker Compose documentation](/compose/overview.md)
    </td>
  </tr>
</table>




&nbsp;
