<!--[metadata]>
+++
title = "Remote API client libraries"
description = "Various client libraries available to use with the Docker remote API"
keywords = ["API, Docker, index, registry, REST, documentation, clients, C#, Erlang, Go, Groovy, Java, JavaScript, Perl, PHP, Python, Ruby, Rust,  Scala"]
[menu.main]
parent="engine_remoteapi"
weight = 90
+++
<![end-metadata]-->

# Docker Remote API client libraries

These libraries make it easier to build applications on top of the Docker
Remote API with various programming languages. They have not been tested by the
Docker maintainers for compatibility, so if you run into any issues, file them
with the library maintainers.

<table border="1" class="docutils">
  <colgroup>
    <col width="29%">
    <col width="23%">
    <col width="48%">
  </colgroup>
  <thead valign="bottom">
    <tr>
      <th class="head">Language/Framework</th>
      <th class="head">Name</th>
      <th class="head">Repository</th>
    </tr>
  </thead>
  <tbody valign = "top">
    <tr>
      <td>C#</td>
      <td>Docker.DotNet</td>
      <td><a class="reference external" href="https://github.com/ahmetalpbalkan/Docker.DotNet">https://github.com/ahmetalpbalkan/Docker.DotNet</a></td>
    </tr>
    <tr>
      <td>C++</td>
      <td>lasote/docker_client</td>
      <td><a class="reference external" href="https://github.com/lasote/docker_client">https://github.com/lasote/docker_client</a></td>
    </tr>
    <tr>
      <td>Erlang</td>
      <td>erldocker</td>
      <td><a class="reference external" href="https://github.com/proger/erldocker">https://github.com/proger/erldocker</a></td>
    </tr>
    <tr>
      <td>Dart</td>
      <td>bwu_docker</td>
      <td><a class="reference external" href="https://github.com/bwu-dart/bwu_docker">https://github.com/bwu-dart/bwu_docker</a></td>
    </tr>
    <tr>
      <td>Go</td>
      <td>engine-api</td>
      <td><a class="reference external" href="https://github.com/docker/engine-api">https://github.com/docker/engine-api</a></td>
    </tr>
    <tr>
      <td>Gradle</td>
      <td>gradle-docker-plugin</td>
      <td><a class="reference external" href="https://github.com/gesellix/gradle-docker-plugin">https://github.com/gesellix/gradle-docker-plugin</a></td>
    </tr>
    <tr>
      <td>Groovy</td>
      <td>docker-client</td>
      <td><a class="reference external" href="https://github.com/gesellix/docker-client">https://github.com/gesellix/docker-client</a></td>
    </tr>
    <tr>
      <td>Haskell</td>
      <td>docker-hs</td>
      <td><a class="reference external" href="https://github.com/denibertovic/docker-hs">https://github.com/denibertovic/docker-hs</a></td>
    </tr>
    <tr>
      <td>HTML (Web Components)</td>
      <td>docker-elements</td>
      <td><a class="reference external" href="https://github.com/kapalhq/docker-elements">https://github.com/kapalhq/docker-elements</a></td>
    </tr>
    <tr>
      <td>Java</td>
      <td>docker-java</td>
      <td><a class="reference external" href="https://github.com/docker-java/docker-java">https://github.com/docker-java/docker-java</a></td>
    </tr>
    <tr>
      <td>Java</td>
      <td>docker-client</td>
      <td><a class="reference external" href="https://github.com/spotify/docker-client">https://github.com/spotify/docker-client</a></td>
    </tr>
    <tr>
      <td>NodeJS</td>
      <td>dockerode</td>
      <td><a class="reference external" href="https://github.com/apocas/dockerode">https://github.com/apocas/dockerode</a></td>
    </tr>
    <tr>
      <td>Perl</td>
      <td>Eixo::Docker</td>
      <td><a class="reference external" href="https://github.com/alambike/eixo-docker">https://github.com/alambike/eixo-docker</a></td>
    </tr>
    <tr>
      <td>PHP</td>
      <td>Docker-PHP</td>
      <td><a class="reference external" href="https://github.com/docker-php/docker-php">https://github.com/docker-php/docker-php</a></td>
    </tr>
    <tr>
      <td>Python</td>
      <td>docker-py</td>
      <td><a class="reference external" href="https://github.com/docker/docker-py">https://github.com/docker/docker-py</a></td>
    </tr>
    <tr>
      <td>Ruby</td>
      <td>docker-api</td>
      <td><a class="reference external" href="https://github.com/swipely/docker-api">https://github.com/swipely/docker-api</a></td>
    </tr>
    <tr>
      <td>Rust</td>
      <td>docker-rust</td>
      <td><a class="reference external" href="https://github.com/abh1nav/docker-rust">https://github.com/abh1nav/docker-rust</a></td>
    </tr>
    <tr>
      <td>Rust</td>
      <td>shiplift</td>
      <td><a class="reference external" href="https://github.com/softprops/shiplift">https://github.com/softprops/shiplift</a></td>
    </tr>
    <tr>
      <td>Scala</td>
      <td>tugboat</td>
      <td><a class="reference external" href="https://github.com/softprops/tugboat">https://github.com/softprops/tugboat</a></td>
    </tr>
    <tr>
      <td>Scala</td>
      <td>reactive-docker</td>
      <td><a class="reference external" href="https://github.com/almoehi/reactive-docker">https://github.com/almoehi/reactive-docker</a></td>
    </tr>
  </tbody>
</table>
