<!--[metadata]>
+++
aliases = ["/engine/reference/logging/splunk/"]
title = "Splunk logging driver"
description = "Describes how to use the Splunk logging driver."
keywords = ["splunk, docker, logging, driver"]
[menu.main]
parent = "smn_logging"
+++
<![end-metadata]-->

# Splunk logging driver

The `splunk` logging driver sends container logs to
[HTTP Event Collector](http://dev.splunk.com/view/event-collector/SP-CAAAE6M)
in Splunk Enterprise and Splunk Cloud.

## Usage

You can configure the default logging driver by passing the `--log-driver`
option to the Docker daemon:

    docker daemon --log-driver=splunk

You can set the logging driver for a specific container by using the
`--log-driver` option to `docker run`:

    docker run --log-driver=splunk ...

## Splunk options

You can use the `--log-opt NAME=VALUE` flag to specify these additional Splunk
logging driver options:

| Option                      | Required | Description                                                                                                                                                                                                        |
|-----------------------------|----------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `splunk-token`              | required | Splunk HTTP Event Collector token.                                                                                                                                                                                 |
| `splunk-url`                | required | Path to your Splunk Enterprise or Splunk Cloud instance (including port and scheme used by HTTP Event Collector) `https://your_splunk_instance:8088`.                                                              |
| `splunk-source`             | optional | Event source.                                                                                                                                                                                                      |
| `splunk-sourcetype`         | optional | Event source type.                                                                                                                                                                                                 |
| `splunk-index`              | optional | Event index.                                                                                                                                                                                                       |
| `splunk-capath`             | optional | Path to root certificate.                                                                                                                                                                                          |
| `splunk-caname`             | optional | Name to use for validating server certificate; by default the hostname of the `splunk-url` will be used.                                                                                                           |
| `splunk-insecureskipverify` | optional | Ignore server certificate validation.                                                                                                                                                                              |
| `tag`                       | optional | Specify tag for message, which interpret some markup. Default value is `{{.ID}}` (12 characters of the container ID). Refer to the [log tag option documentation](log_tags.md) for customizing the log tag format. |
| `labels`                    | optional | Comma-separated list of keys of labels, which should be included in message, if these labels are specified for container.                                                                                          |
| `env`                       | optional | Comma-separated list of keys of environment variables, which should be included in message, if these variables are specified for container.                                                                        |

If there is collision between `label` and `env` keys, the value of the `env` takes precedence.
Both options add additional fields to the attributes of a logging message.

Below is an example of the logging option specified for the Splunk Enterprise
instance. The instance is installed locally on the same machine on which the
Docker daemon is running. The path to the root certificate and Common Name is
specified using an HTTPS scheme. This is used for verification.
The `SplunkServerDefaultCert` is automatically generated by Splunk certificates.

    docker run --log-driver=splunk \
        --log-opt splunk-token=176FCEBF-4CF5-4EDF-91BC-703796522D20 \
        --log-opt splunk-url=https://splunkhost:8088 \
        --log-opt splunk-capath=/path/to/cert/cacert.pem \
        --log-opt splunk-caname=SplunkServerDefaultCert
        --log-opt tag="{{.Name}}/{{.FullID}}"
        --log-opt labels=location
        --log-opt env=TEST
        --env "TEST=false"
        --label location=west
        your/application
