// Code generated by protoc-gen-gogo.
// source: types.proto
// DO NOT EDIT!

/*
	Package api is a generated protocol buffer package.

	It is generated from these files:
		types.proto
		specs.proto
		objects.proto
		control.proto
		dispatcher.proto
		ca.proto
		snapshot.proto
		raft.proto
		health.proto

	It has these top-level messages:
		Version
		Annotations
		Resources
		ResourceRequirements
		Platform
		PluginDescription
		EngineDescription
		NodeDescription
		RaftMemberStatus
		NodeStatus
		Image
		Mount
		RestartPolicy
		UpdateConfig
		UpdateStatus
		ContainerStatus
		TaskStatus
		IPAMConfig
		PortConfig
		Driver
		IPAMOptions
		Peer
		WeightedPeer
		IssuanceStatus
		AcceptancePolicy
		ExternalCA
		CAConfig
		OrchestrationConfig
		TaskDefaults
		DispatcherConfig
		RaftConfig
		Placement
		JoinTokens
		RootCA
		Certificate
		EncryptionKey
		ManagerStatus
		NodeSpec
		ServiceSpec
		ReplicatedService
		GlobalService
		TaskSpec
		ContainerSpec
		EndpointSpec
		NetworkSpec
		ClusterSpec
		Meta
		Node
		Service
		Endpoint
		Task
		NetworkAttachment
		Network
		Cluster
		GetNodeRequest
		GetNodeResponse
		ListNodesRequest
		ListNodesResponse
		UpdateNodeRequest
		UpdateNodeResponse
		RemoveNodeRequest
		RemoveNodeResponse
		GetTaskRequest
		GetTaskResponse
		RemoveTaskRequest
		RemoveTaskResponse
		ListTasksRequest
		ListTasksResponse
		CreateServiceRequest
		CreateServiceResponse
		GetServiceRequest
		GetServiceResponse
		UpdateServiceRequest
		UpdateServiceResponse
		RemoveServiceRequest
		RemoveServiceResponse
		ListServicesRequest
		ListServicesResponse
		CreateNetworkRequest
		CreateNetworkResponse
		GetNetworkRequest
		GetNetworkResponse
		RemoveNetworkRequest
		RemoveNetworkResponse
		ListNetworksRequest
		ListNetworksResponse
		GetClusterRequest
		GetClusterResponse
		ListClustersRequest
		ListClustersResponse
		JoinTokenRotation
		UpdateClusterRequest
		UpdateClusterResponse
		SessionRequest
		SessionMessage
		HeartbeatRequest
		HeartbeatResponse
		UpdateTaskStatusRequest
		UpdateTaskStatusResponse
		TasksRequest
		TasksMessage
		NodeCertificateStatusRequest
		NodeCertificateStatusResponse
		IssueNodeCertificateRequest
		IssueNodeCertificateResponse
		GetRootCACertificateRequest
		GetRootCACertificateResponse
		StoreSnapshot
		ClusterSnapshot
		Snapshot
		RaftMember
		JoinRequest
		JoinResponse
		LeaveRequest
		LeaveResponse
		ProcessRaftMessageRequest
		ProcessRaftMessageResponse
		ResolveAddressRequest
		ResolveAddressResponse
		InternalRaftRequest
		StoreAction
		HealthCheckRequest
		HealthCheckResponse
*/
package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import docker_swarmkit_v1 "github.com/docker/swarmkit/api/timestamp"
import docker_swarmkit_v11 "github.com/docker/swarmkit/api/duration"
import _ "github.com/gogo/protobuf/gogoproto"

import os "os"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"
import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.GoGoProtoPackageIsVersion1

// TaskState enumerates the states that a task progresses through within an
// agent. States are designed to be monotonically increasing, such that if two
// states are seen by a task, the greater of the new represents the true state.
type TaskState int32

const (
	TaskStateNew       TaskState = 0
	TaskStateAllocated TaskState = 64
	TaskStatePending   TaskState = 128
	TaskStateAssigned  TaskState = 192
	TaskStateAccepted  TaskState = 256
	TaskStatePreparing TaskState = 320
	TaskStateReady     TaskState = 384
	TaskStateStarting  TaskState = 448
	TaskStateRunning   TaskState = 512
	TaskStateCompleted TaskState = 576
	TaskStateShutdown  TaskState = 640
	TaskStateFailed    TaskState = 704
	TaskStateRejected  TaskState = 768
)

var TaskState_name = map[int32]string{
	0:   "NEW",
	64:  "ALLOCATED",
	128: "PENDING",
	192: "ASSIGNED",
	256: "ACCEPTED",
	320: "PREPARING",
	384: "READY",
	448: "STARTING",
	512: "RUNNING",
	576: "COMPLETE",
	640: "SHUTDOWN",
	704: "FAILED",
	768: "REJECTED",
}
var TaskState_value = map[string]int32{
	"NEW":       0,
	"ALLOCATED": 64,
	"PENDING":   128,
	"ASSIGNED":  192,
	"ACCEPTED":  256,
	"PREPARING": 320,
	"READY":     384,
	"STARTING":  448,
	"RUNNING":   512,
	"COMPLETE":  576,
	"SHUTDOWN":  640,
	"FAILED":    704,
	"REJECTED":  768,
}

func (x TaskState) String() string {
	return proto.EnumName(TaskState_name, int32(x))
}
func (TaskState) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{0} }

type NodeRole int32

const (
	NodeRoleWorker  NodeRole = 0
	NodeRoleManager NodeRole = 1
)

var NodeRole_name = map[int32]string{
	0: "WORKER",
	1: "MANAGER",
}
var NodeRole_value = map[string]int32{
	"WORKER":  0,
	"MANAGER": 1,
}

func (x NodeRole) String() string {
	return proto.EnumName(NodeRole_name, int32(x))
}
func (NodeRole) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{1} }

type RaftMemberStatus_Reachability int32

const (
	// Unknown indicates that the manager state cannot be resolved
	RaftMemberStatus_UNKNOWN RaftMemberStatus_Reachability = 0
	// Unreachable indicates that the node cannot be contacted by other
	// raft cluster members.
	RaftMemberStatus_UNREACHABLE RaftMemberStatus_Reachability = 1
	// Reachable indicates that the node is healthy and reachable
	// by other members.
	RaftMemberStatus_REACHABLE RaftMemberStatus_Reachability = 2
)

var RaftMemberStatus_Reachability_name = map[int32]string{
	0: "UNKNOWN",
	1: "UNREACHABLE",
	2: "REACHABLE",
}
var RaftMemberStatus_Reachability_value = map[string]int32{
	"UNKNOWN":     0,
	"UNREACHABLE": 1,
	"REACHABLE":   2,
}

func (x RaftMemberStatus_Reachability) String() string {
	return proto.EnumName(RaftMemberStatus_Reachability_name, int32(x))
}
func (RaftMemberStatus_Reachability) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{8, 0}
}

// TODO(aluzzardi) These should be using `gogoproto.enumvalue_customname`.
type NodeStatus_State int32

const (
	// Unknown indicates the node state cannot be resolved.
	NodeStatus_UNKNOWN NodeStatus_State = 0
	// Down indicates the node is down.
	NodeStatus_DOWN NodeStatus_State = 1
	// Ready indicates the node is ready to accept tasks.
	NodeStatus_READY NodeStatus_State = 2
	// Disconnected indicates the node is currently trying to find new manager.
	NodeStatus_DISCONNECTED NodeStatus_State = 3
)

var NodeStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "DOWN",
	2: "READY",
	3: "DISCONNECTED",
}
var NodeStatus_State_value = map[string]int32{
	"UNKNOWN":      0,
	"DOWN":         1,
	"READY":        2,
	"DISCONNECTED": 3,
}

func (x NodeStatus_State) String() string {
	return proto.EnumName(NodeStatus_State_name, int32(x))
}
func (NodeStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{9, 0} }

type Mount_MountType int32

const (
	MountTypeBind   Mount_MountType = 0
	MountTypeVolume Mount_MountType = 1
	MountTypeTmpfs  Mount_MountType = 2
)

var Mount_MountType_name = map[int32]string{
	0: "BIND",
	1: "VOLUME",
	2: "TMPFS",
}
var Mount_MountType_value = map[string]int32{
	"BIND":   0,
	"VOLUME": 1,
	"TMPFS":  2,
}

func (x Mount_MountType) String() string {
	return proto.EnumName(Mount_MountType_name, int32(x))
}
func (Mount_MountType) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{11, 0} }

type Mount_BindOptions_MountPropagation int32

const (
	MountPropagationRPrivate Mount_BindOptions_MountPropagation = 0
	MountPropagationPrivate  Mount_BindOptions_MountPropagation = 1
	MountPropagationRShared  Mount_BindOptions_MountPropagation = 2
	MountPropagationShared   Mount_BindOptions_MountPropagation = 3
	MountPropagationRSlave   Mount_BindOptions_MountPropagation = 4
	MountPropagationSlave    Mount_BindOptions_MountPropagation = 5
)

var Mount_BindOptions_MountPropagation_name = map[int32]string{
	0: "RPRIVATE",
	1: "PRIVATE",
	2: "RSHARED",
	3: "SHARED",
	4: "RSLAVE",
	5: "SLAVE",
}
var Mount_BindOptions_MountPropagation_value = map[string]int32{
	"RPRIVATE": 0,
	"PRIVATE":  1,
	"RSHARED":  2,
	"SHARED":   3,
	"RSLAVE":   4,
	"SLAVE":    5,
}

func (x Mount_BindOptions_MountPropagation) String() string {
	return proto.EnumName(Mount_BindOptions_MountPropagation_name, int32(x))
}
func (Mount_BindOptions_MountPropagation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{11, 0, 0}
}

type RestartPolicy_RestartCondition int32

const (
	RestartOnNone    RestartPolicy_RestartCondition = 0
	RestartOnFailure RestartPolicy_RestartCondition = 1
	RestartOnAny     RestartPolicy_RestartCondition = 2
)

var RestartPolicy_RestartCondition_name = map[int32]string{
	0: "NONE",
	1: "ON_FAILURE",
	2: "ANY",
}
var RestartPolicy_RestartCondition_value = map[string]int32{
	"NONE":       0,
	"ON_FAILURE": 1,
	"ANY":        2,
}

func (x RestartPolicy_RestartCondition) String() string {
	return proto.EnumName(RestartPolicy_RestartCondition_name, int32(x))
}
func (RestartPolicy_RestartCondition) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{12, 0}
}

type UpdateConfig_FailureAction int32

const (
	UpdateConfig_PAUSE    UpdateConfig_FailureAction = 0
	UpdateConfig_CONTINUE UpdateConfig_FailureAction = 1
)

var UpdateConfig_FailureAction_name = map[int32]string{
	0: "PAUSE",
	1: "CONTINUE",
}
var UpdateConfig_FailureAction_value = map[string]int32{
	"PAUSE":    0,
	"CONTINUE": 1,
}

func (x UpdateConfig_FailureAction) String() string {
	return proto.EnumName(UpdateConfig_FailureAction_name, int32(x))
}
func (UpdateConfig_FailureAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{13, 0}
}

type UpdateStatus_UpdateState int32

const (
	UpdateStatus_UNKNOWN   UpdateStatus_UpdateState = 0
	UpdateStatus_UPDATING  UpdateStatus_UpdateState = 1
	UpdateStatus_PAUSED    UpdateStatus_UpdateState = 2
	UpdateStatus_COMPLETED UpdateStatus_UpdateState = 3
)

var UpdateStatus_UpdateState_name = map[int32]string{
	0: "UNKNOWN",
	1: "UPDATING",
	2: "PAUSED",
	3: "COMPLETED",
}
var UpdateStatus_UpdateState_value = map[string]int32{
	"UNKNOWN":   0,
	"UPDATING":  1,
	"PAUSED":    2,
	"COMPLETED": 3,
}

func (x UpdateStatus_UpdateState) String() string {
	return proto.EnumName(UpdateStatus_UpdateState_name, int32(x))
}
func (UpdateStatus_UpdateState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{14, 0}
}

// AddressFamily specifies the network address family that
// this IPAMConfig belongs to.
type IPAMConfig_AddressFamily int32

const (
	IPAMConfig_UNKNOWN IPAMConfig_AddressFamily = 0
	IPAMConfig_IPV4    IPAMConfig_AddressFamily = 4
	IPAMConfig_IPV6    IPAMConfig_AddressFamily = 6
)

var IPAMConfig_AddressFamily_name = map[int32]string{
	0: "UNKNOWN",
	4: "IPV4",
	6: "IPV6",
}
var IPAMConfig_AddressFamily_value = map[string]int32{
	"UNKNOWN": 0,
	"IPV4":    4,
	"IPV6":    6,
}

func (x IPAMConfig_AddressFamily) String() string {
	return proto.EnumName(IPAMConfig_AddressFamily_name, int32(x))
}
func (IPAMConfig_AddressFamily) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{17, 0}
}

type PortConfig_Protocol int32

const (
	ProtocolTCP PortConfig_Protocol = 0
	ProtocolUDP PortConfig_Protocol = 1
)

var PortConfig_Protocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
}
var PortConfig_Protocol_value = map[string]int32{
	"TCP": 0,
	"UDP": 1,
}

func (x PortConfig_Protocol) String() string {
	return proto.EnumName(PortConfig_Protocol_name, int32(x))
}
func (PortConfig_Protocol) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{18, 0} }

type IssuanceStatus_State int32

const (
	IssuanceStateUnknown IssuanceStatus_State = 0
	IssuanceStateRenew   IssuanceStatus_State = 1
	IssuanceStatePending IssuanceStatus_State = 2
	IssuanceStateIssued  IssuanceStatus_State = 3
	IssuanceStateFailed  IssuanceStatus_State = 4
)

var IssuanceStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "RENEW",
	2: "PENDING",
	3: "ISSUED",
	4: "FAILED",
}
var IssuanceStatus_State_value = map[string]int32{
	"UNKNOWN": 0,
	"RENEW":   1,
	"PENDING": 2,
	"ISSUED":  3,
	"FAILED":  4,
}

func (x IssuanceStatus_State) String() string {
	return proto.EnumName(IssuanceStatus_State_name, int32(x))
}
func (IssuanceStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{23, 0} }

type ExternalCA_CAProtocol int32

const (
	ExternalCA_CAProtocolCFSSL ExternalCA_CAProtocol = 0
)

var ExternalCA_CAProtocol_name = map[int32]string{
	0: "CFSSL",
}
var ExternalCA_CAProtocol_value = map[string]int32{
	"CFSSL": 0,
}

func (x ExternalCA_CAProtocol) String() string {
	return proto.EnumName(ExternalCA_CAProtocol_name, int32(x))
}
func (ExternalCA_CAProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{25, 0}
}

// Encryption algorithm that can implemented using this key
type EncryptionKey_Algorithm int32

const (
	AES_128_GCM EncryptionKey_Algorithm = 0
)

var EncryptionKey_Algorithm_name = map[int32]string{
	0: "AES_128_GCM",
}
var EncryptionKey_Algorithm_value = map[string]int32{
	"AES_128_GCM": 0,
}

func (x EncryptionKey_Algorithm) String() string {
	return proto.EnumName(EncryptionKey_Algorithm_name, int32(x))
}
func (EncryptionKey_Algorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{35, 0}
}

// Version tracks the last time an object in the store was updated.
type Version struct {
	Index uint64 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
}

func (m *Version) Reset()                    { *m = Version{} }
func (*Version) ProtoMessage()               {}
func (*Version) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{0} }

// Annotations provide useful information to identify API objects. They are
// common to all API specs.
type Annotations struct {
	Name   string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Annotations) Reset()                    { *m = Annotations{} }
func (*Annotations) ProtoMessage()               {}
func (*Annotations) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{1} }

type Resources struct {
	// Amount of CPUs (e.g. 2000000000 = 2 CPU cores)
	NanoCPUs int64 `protobuf:"varint,1,opt,name=nano_cpus,json=nanoCpus,proto3" json:"nano_cpus,omitempty"`
	// Amount of memory in bytes.
	MemoryBytes int64 `protobuf:"varint,2,opt,name=memory_bytes,json=memoryBytes,proto3" json:"memory_bytes,omitempty"`
}

func (m *Resources) Reset()                    { *m = Resources{} }
func (*Resources) ProtoMessage()               {}
func (*Resources) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{2} }

type ResourceRequirements struct {
	Limits       *Resources `protobuf:"bytes,1,opt,name=limits" json:"limits,omitempty"`
	Reservations *Resources `protobuf:"bytes,2,opt,name=reservations" json:"reservations,omitempty"`
}

func (m *ResourceRequirements) Reset()                    { *m = ResourceRequirements{} }
func (*ResourceRequirements) ProtoMessage()               {}
func (*ResourceRequirements) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{3} }

type Platform struct {
	// Architecture (e.g. x86_64)
	Architecture string `protobuf:"bytes,1,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Operating System (e.g. linux)
	OS string `protobuf:"bytes,2,opt,name=os,proto3" json:"os,omitempty"`
}

func (m *Platform) Reset()                    { *m = Platform{} }
func (*Platform) ProtoMessage()               {}
func (*Platform) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{4} }

// PluginDescription describes an engine plugin.
type PluginDescription struct {
	// Type of plugin. Canonical values for existing types are
	// Volume, Network, and Authorization. More types could be
	// supported in the future.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Name of the plugin
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *PluginDescription) Reset()                    { *m = PluginDescription{} }
func (*PluginDescription) ProtoMessage()               {}
func (*PluginDescription) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{5} }

type EngineDescription struct {
	// Docker daemon version running on the node.
	EngineVersion string `protobuf:"bytes,1,opt,name=engine_version,json=engineVersion,proto3" json:"engine_version,omitempty"`
	// Labels attached to the engine.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Volume, Network, and Auth plugins
	Plugins []PluginDescription `protobuf:"bytes,3,rep,name=plugins" json:"plugins"`
}

func (m *EngineDescription) Reset()                    { *m = EngineDescription{} }
func (*EngineDescription) ProtoMessage()               {}
func (*EngineDescription) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{6} }

type NodeDescription struct {
	// Hostname of the node as reported by the agent.
	// This is different from spec.meta.name which is user-defined.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Platform of the node.
	Platform *Platform `protobuf:"bytes,2,opt,name=platform" json:"platform,omitempty"`
	// Total resources on the node.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources" json:"resources,omitempty"`
	// Information about the Docker Engine on the node.
	Engine *EngineDescription `protobuf:"bytes,4,opt,name=engine" json:"engine,omitempty"`
}

func (m *NodeDescription) Reset()                    { *m = NodeDescription{} }
func (*NodeDescription) ProtoMessage()               {}
func (*NodeDescription) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{7} }

type RaftMemberStatus struct {
	Leader       bool                          `protobuf:"varint,1,opt,name=leader,proto3" json:"leader,omitempty"`
	Reachability RaftMemberStatus_Reachability `protobuf:"varint,2,opt,name=reachability,proto3,enum=docker.swarmkit.v1.RaftMemberStatus_Reachability" json:"reachability,omitempty"`
	Message      string                        `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *RaftMemberStatus) Reset()                    { *m = RaftMemberStatus{} }
func (*RaftMemberStatus) ProtoMessage()               {}
func (*RaftMemberStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{8} }

type NodeStatus struct {
	State   NodeStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=docker.swarmkit.v1.NodeStatus_State" json:"state,omitempty"`
	Message string           `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *NodeStatus) Reset()                    { *m = NodeStatus{} }
func (*NodeStatus) ProtoMessage()               {}
func (*NodeStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{9} }

type Image struct {
	// reference is a docker image reference. This can include a rpository, tag
	// or be fully qualified witha digest. The format is specified in the
	// distribution/reference package.
	Reference string `protobuf:"bytes,1,opt,name=reference,proto3" json:"reference,omitempty"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{10} }

// Mount describes volume mounts for a container.
//
// The Mount type follows the structure of the mount syscall, including a type,
// source, target. Top-level flags, such as writable, are common to all kinds
// of mounts, where we also provide options that are specific to a type of
// mount. This corresponds to flags and data, respectively, in the syscall.
type Mount struct {
	// Type defines the nature of the mount.
	Type Mount_MountType `protobuf:"varint,1,opt,name=type,proto3,enum=docker.swarmkit.v1.Mount_MountType" json:"type,omitempty"`
	// Source specifies the name of the mount. Depending on mount type, this
	// may be a volume name or a host path, or even ignored.
	Source string `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// Target path in container
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// ReadOnly should be set to true if the mount should not be writable.
	ReadOnly bool `protobuf:"varint,4,opt,name=readonly,proto3" json:"readonly,omitempty"`
	// BindOptions configures properties of a bind mount type.
	//
	// For mounts of type bind, the source must be an absolute host path.
	BindOptions *Mount_BindOptions `protobuf:"bytes,5,opt,name=bind_options,json=bindOptions" json:"bind_options,omitempty"`
	// VolumeOptions configures the properties specific to a volume mount type.
	//
	// For mounts of type volume, the source will be used as the volume name.
	VolumeOptions *Mount_VolumeOptions `protobuf:"bytes,6,opt,name=volume_options,json=volumeOptions" json:"volume_options,omitempty"`
	// TmpfsOptions allows one to set options for mounting a temporary
	// filesystem.
	//
	// The source field will be ignored when using mounts of type tmpfs.
	TmpfsOptions *Mount_TmpfsOptions `protobuf:"bytes,7,opt,name=tmpfs_options,json=tmpfsOptions" json:"tmpfs_options,omitempty"`
}

func (m *Mount) Reset()                    { *m = Mount{} }
func (*Mount) ProtoMessage()               {}
func (*Mount) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{11} }

// BindOptions specifies options that are specific to a bind mount.
type Mount_BindOptions struct {
	// Propagation mode of mount.
	Propagation Mount_BindOptions_MountPropagation `protobuf:"varint,1,opt,name=propagation,proto3,enum=docker.swarmkit.v1.Mount_BindOptions_MountPropagation" json:"propagation,omitempty"`
}

func (m *Mount_BindOptions) Reset()                    { *m = Mount_BindOptions{} }
func (*Mount_BindOptions) ProtoMessage()               {}
func (*Mount_BindOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{11, 0} }

// VolumeOptions contains parameters for mounting the volume.
type Mount_VolumeOptions struct {
	// nocopy prevents automatic copying of data to the volume with data from target
	NoCopy bool `protobuf:"varint,1,opt,name=nocopy,proto3" json:"nocopy,omitempty"`
	// labels to apply to the volume if creating
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// DriverConfig specifies the options that may be passed to the driver
	// if the volume is created.
	//
	// If this is empty, no volume will be created if the volume is missing.
	DriverConfig *Driver `protobuf:"bytes,3,opt,name=driver_config,json=driverConfig" json:"driver_config,omitempty"`
}

func (m *Mount_VolumeOptions) Reset()                    { *m = Mount_VolumeOptions{} }
func (*Mount_VolumeOptions) ProtoMessage()               {}
func (*Mount_VolumeOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{11, 1} }

type Mount_TmpfsOptions struct {
	// Size sets the size of the tmpfs, in bytes.
	//
	// This will be converted to an operating system specific value
	// depending on the host. For example, on linux, it will be convered to
	// use a 'k', 'm' or 'g' syntax. BSD, though not widely supported with
	// docker, uses a straight byte value.
	//
	// Percentages are not supported.
	SizeBytes int64 `protobuf:"varint,1,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Mode of the tmpfs upon creation
	Mode os.FileMode `protobuf:"varint,2,opt,name=mode,proto3,customtype=os.FileMode" json:"mode"`
}

func (m *Mount_TmpfsOptions) Reset()                    { *m = Mount_TmpfsOptions{} }
func (*Mount_TmpfsOptions) ProtoMessage()               {}
func (*Mount_TmpfsOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{11, 2} }

type RestartPolicy struct {
	Condition RestartPolicy_RestartCondition `protobuf:"varint,1,opt,name=condition,proto3,enum=docker.swarmkit.v1.RestartPolicy_RestartCondition" json:"condition,omitempty"`
	// Delay between restart attempts
	Delay *docker_swarmkit_v11.Duration `protobuf:"bytes,2,opt,name=delay" json:"delay,omitempty"`
	// MaxAttempts is the maximum number of restarts to attempt on an
	// instance before giving up. Ignored if 0.
	MaxAttempts uint64 `protobuf:"varint,3,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// Window is the time window used to evaluate the restart policy.
	// The time window is unbounded if this is 0.
	Window *docker_swarmkit_v11.Duration `protobuf:"bytes,4,opt,name=window" json:"window,omitempty"`
}

func (m *RestartPolicy) Reset()                    { *m = RestartPolicy{} }
func (*RestartPolicy) ProtoMessage()               {}
func (*RestartPolicy) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{12} }

// UpdateConfig specifies the rate and policy of updates.
// TODO(aluzzardi): Consider making this a oneof with RollingStrategy and LockstepStrategy.
type UpdateConfig struct {
	// Maximum number of tasks to be updated in one iteration.
	// 0 means unlimited parallelism.
	Parallelism uint64 `protobuf:"varint,1,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	// Amount of time between updates.
	Delay docker_swarmkit_v11.Duration `protobuf:"bytes,2,opt,name=delay" json:"delay"`
	// FailureAction is the action to take when an update failures.
	// Currently, a failure is defined as a single updated task failing to
	// reach the RUNNING state. In the future, there will be configuration
	// to define what is treated as a failure (see #486 for a proposal).
	FailureAction UpdateConfig_FailureAction `protobuf:"varint,3,opt,name=failure_action,json=failureAction,proto3,enum=docker.swarmkit.v1.UpdateConfig_FailureAction" json:"failure_action,omitempty"`
}

func (m *UpdateConfig) Reset()                    { *m = UpdateConfig{} }
func (*UpdateConfig) ProtoMessage()               {}
func (*UpdateConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{13} }

// UpdateStatus is the status of an update in progress.
type UpdateStatus struct {
	// State is the state of this update. It indicates whether the
	// update is in progress, completed, or is paused.
	State UpdateStatus_UpdateState `protobuf:"varint,1,opt,name=state,proto3,enum=docker.swarmkit.v1.UpdateStatus_UpdateState" json:"state,omitempty"`
	// StartedAt is the time at which the update was started.
	StartedAt *docker_swarmkit_v1.Timestamp `protobuf:"bytes,2,opt,name=started_at,json=startedAt" json:"started_at,omitempty"`
	// CompletedAt is the time at which the update completed.
	CompletedAt *docker_swarmkit_v1.Timestamp `protobuf:"bytes,3,opt,name=completed_at,json=completedAt" json:"completed_at,omitempty"`
	// Message explains how the update got into its current state. For
	// example, if the update is paused, it will explain what is preventing
	// the update from proceeding (typically the failure of a task to start up
	// when OnFailure is PAUSE).
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *UpdateStatus) Reset()                    { *m = UpdateStatus{} }
func (*UpdateStatus) ProtoMessage()               {}
func (*UpdateStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{14} }

// Container specific status.
type ContainerStatus struct {
	ContainerID string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	PID         int32  `protobuf:"varint,2,opt,name=pid,proto3" json:"pid,omitempty"`
	ExitCode    int32  `protobuf:"varint,3,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
}

func (m *ContainerStatus) Reset()                    { *m = ContainerStatus{} }
func (*ContainerStatus) ProtoMessage()               {}
func (*ContainerStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{15} }

type TaskStatus struct {
	Timestamp *docker_swarmkit_v1.Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp,omitempty"`
	// State expresses the current state of the task.
	State TaskState `protobuf:"varint,2,opt,name=state,proto3,enum=docker.swarmkit.v1.TaskState" json:"state,omitempty"`
	// Message reports a message for the task status. This should provide a
	// human readable message that can point to how the task actually arrived
	// at a current state.
	//
	// As a convention, we place the a small message here that led to the
	// current state. For example, if the task is in ready, because it was
	// prepared, we'd place "prepared" in this field. If we skipped preparation
	// because the task is prepared, we would put "already prepared" in this
	// field.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// Err is set if the task is in an error state.
	//
	// The following states should report a companion error:
	//
	// 	FAILED, REJECTED
	//
	// TODO(stevvooe) Integrate this field with the error interface.
	Err string `protobuf:"bytes,4,opt,name=err,proto3" json:"err,omitempty"`
	// Container status contains container specific status information.
	//
	// Types that are valid to be assigned to RuntimeStatus:
	//	*TaskStatus_Container
	RuntimeStatus isTaskStatus_RuntimeStatus `protobuf_oneof:"runtime_status"`
}

func (m *TaskStatus) Reset()                    { *m = TaskStatus{} }
func (*TaskStatus) ProtoMessage()               {}
func (*TaskStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16} }

type isTaskStatus_RuntimeStatus interface {
	isTaskStatus_RuntimeStatus()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TaskStatus_Container struct {
	Container *ContainerStatus `protobuf:"bytes,5,opt,name=container,oneof"`
}

func (*TaskStatus_Container) isTaskStatus_RuntimeStatus() {}

func (m *TaskStatus) GetRuntimeStatus() isTaskStatus_RuntimeStatus {
	if m != nil {
		return m.RuntimeStatus
	}
	return nil
}

func (m *TaskStatus) GetContainer() *ContainerStatus {
	if x, ok := m.GetRuntimeStatus().(*TaskStatus_Container); ok {
		return x.Container
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TaskStatus) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TaskStatus_OneofMarshaler, _TaskStatus_OneofUnmarshaler, _TaskStatus_OneofSizer, []interface{}{
		(*TaskStatus_Container)(nil),
	}
}

func _TaskStatus_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TaskStatus)
	// runtime_status
	switch x := m.RuntimeStatus.(type) {
	case *TaskStatus_Container:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Container); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TaskStatus.RuntimeStatus has unexpected type %T", x)
	}
	return nil
}

func _TaskStatus_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TaskStatus)
	switch tag {
	case 5: // runtime_status.container
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ContainerStatus)
		err := b.DecodeMessage(msg)
		m.RuntimeStatus = &TaskStatus_Container{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TaskStatus_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TaskStatus)
	// runtime_status
	switch x := m.RuntimeStatus.(type) {
	case *TaskStatus_Container:
		s := proto.Size(x.Container)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// IPAMConfig specifies parameters for IP Address Management.
type IPAMConfig struct {
	Family IPAMConfig_AddressFamily `protobuf:"varint,1,opt,name=family,proto3,enum=docker.swarmkit.v1.IPAMConfig_AddressFamily" json:"family,omitempty"`
	// Subnet defines a network as a CIDR address (ie network and mask
	// 192.168.0.1/24).
	Subnet string `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
	// Range defines the portion of the subnet to allocate to tasks. This is
	// defined as a subnet within the primary subnet.
	Range string `protobuf:"bytes,3,opt,name=range,proto3" json:"range,omitempty"`
	// Gateway address within the subnet.
	Gateway string `protobuf:"bytes,4,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Reserved is a list of address from the master pool that should *not* be
	// allocated. These addresses may have already been allocated or may be
	// reserved for another allocation manager.
	Reserved map[string]string `protobuf:"bytes,5,rep,name=reserved" json:"reserved,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *IPAMConfig) Reset()                    { *m = IPAMConfig{} }
func (*IPAMConfig) ProtoMessage()               {}
func (*IPAMConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{17} }

// PortConfig specifies an exposed port which can be
// addressed using the given name. This can be later queried
// using a service discovery api or a DNS SRV query. The node
// port specifies a port that can be used to address this
// service external to the cluster by sending a connection
// request to this port to any node on the cluster.
type PortConfig struct {
	// Name for the port. If provided the port information can
	// be queried using the name as in a DNS SRV query.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Protocol for the port which is exposed.
	Protocol PortConfig_Protocol `protobuf:"varint,2,opt,name=protocol,proto3,enum=docker.swarmkit.v1.PortConfig_Protocol" json:"protocol,omitempty"`
	// The port which the application is exposing and is bound to.
	TargetPort uint32 `protobuf:"varint,3,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	// PublishedPort specifies the port on which the service is
	// exposed. If specified, the port must be
	// within the available range. If not specified, an available
	// port is automatically assigned.
	PublishedPort uint32 `protobuf:"varint,4,opt,name=published_port,json=publishedPort,proto3" json:"published_port,omitempty"`
}

func (m *PortConfig) Reset()                    { *m = PortConfig{} }
func (*PortConfig) ProtoMessage()               {}
func (*PortConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{18} }

// Driver is a generic driver type to be used throughout the API. For now, a
// driver is simply a name and set of options. The field contents depend on the
// target use case and driver application. For example, a network driver may
// have different rules than a volume driver.
type Driver struct {
	Name    string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Options map[string]string `protobuf:"bytes,2,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Driver) Reset()                    { *m = Driver{} }
func (*Driver) ProtoMessage()               {}
func (*Driver) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{19} }

type IPAMOptions struct {
	Driver  *Driver       `protobuf:"bytes,1,opt,name=driver" json:"driver,omitempty"`
	Configs []*IPAMConfig `protobuf:"bytes,3,rep,name=configs" json:"configs,omitempty"`
}

func (m *IPAMOptions) Reset()                    { *m = IPAMOptions{} }
func (*IPAMOptions) ProtoMessage()               {}
func (*IPAMOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{20} }

// Peer should be used anywhere where we are describing a remote peer.
type Peer struct {
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	Addr   string `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *Peer) Reset()                    { *m = Peer{} }
func (*Peer) ProtoMessage()               {}
func (*Peer) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{21} }

// WeightedPeer should be used anywhere where we are describing a remote peer
// with a weight.
type WeightedPeer struct {
	Peer   *Peer `protobuf:"bytes,1,opt,name=peer" json:"peer,omitempty"`
	Weight int64 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (m *WeightedPeer) Reset()                    { *m = WeightedPeer{} }
func (*WeightedPeer) ProtoMessage()               {}
func (*WeightedPeer) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{22} }

type IssuanceStatus struct {
	State IssuanceStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=docker.swarmkit.v1.IssuanceStatus_State" json:"state,omitempty"`
	// Err is set if the Certificate Issuance is in an error state.
	// The following states should report a companion error:
	// 	FAILED
	Err string `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
}

func (m *IssuanceStatus) Reset()                    { *m = IssuanceStatus{} }
func (*IssuanceStatus) ProtoMessage()               {}
func (*IssuanceStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{23} }

type AcceptancePolicy struct {
	Policies []*AcceptancePolicy_RoleAdmissionPolicy `protobuf:"bytes,1,rep,name=policies" json:"policies,omitempty"`
}

func (m *AcceptancePolicy) Reset()                    { *m = AcceptancePolicy{} }
func (*AcceptancePolicy) ProtoMessage()               {}
func (*AcceptancePolicy) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{24} }

type AcceptancePolicy_RoleAdmissionPolicy struct {
	Role NodeRole `protobuf:"varint,1,opt,name=role,proto3,enum=docker.swarmkit.v1.NodeRole" json:"role,omitempty"`
	// Autoaccept controls which roles' certificates are automatically
	// issued without administrator intervention.
	Autoaccept bool `protobuf:"varint,2,opt,name=autoaccept,proto3" json:"autoaccept,omitempty"`
	// Secret represents a user-provided string that is necessary for new
	// nodes to join the cluster
	Secret *AcceptancePolicy_RoleAdmissionPolicy_Secret `protobuf:"bytes,3,opt,name=secret" json:"secret,omitempty"`
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) Reset()      { *m = AcceptancePolicy_RoleAdmissionPolicy{} }
func (*AcceptancePolicy_RoleAdmissionPolicy) ProtoMessage() {}
func (*AcceptancePolicy_RoleAdmissionPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{24, 0}
}

type AcceptancePolicy_RoleAdmissionPolicy_Secret struct {
	// The actual content (possibly hashed)
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// The type of hash we are using, or "plaintext"
	Alg string `protobuf:"bytes,2,opt,name=alg,proto3" json:"alg,omitempty"`
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Reset() {
	*m = AcceptancePolicy_RoleAdmissionPolicy_Secret{}
}
func (*AcceptancePolicy_RoleAdmissionPolicy_Secret) ProtoMessage() {}
func (*AcceptancePolicy_RoleAdmissionPolicy_Secret) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{24, 0, 0}
}

type ExternalCA struct {
	// Protocol is the protocol used by this external CA.
	Protocol ExternalCA_CAProtocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=docker.swarmkit.v1.ExternalCA_CAProtocol" json:"protocol,omitempty"`
	// URL is the URL where the external CA can be reached.
	URL string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Options is a set of additional key/value pairs whose interpretation
	// depends on the specified CA type.
	Options map[string]string `protobuf:"bytes,3,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *ExternalCA) Reset()                    { *m = ExternalCA{} }
func (*ExternalCA) ProtoMessage()               {}
func (*ExternalCA) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{25} }

type CAConfig struct {
	// NodeCertExpiry is the duration certificates should be issued for
	NodeCertExpiry *docker_swarmkit_v11.Duration `protobuf:"bytes,1,opt,name=node_cert_expiry,json=nodeCertExpiry" json:"node_cert_expiry,omitempty"`
	// ExternalCAs is a list of CAs to which a manager node will make
	// certificate signing requests for node certificates.
	ExternalCAs []*ExternalCA `protobuf:"bytes,2,rep,name=external_cas,json=externalCas" json:"external_cas,omitempty"`
}

func (m *CAConfig) Reset()                    { *m = CAConfig{} }
func (*CAConfig) ProtoMessage()               {}
func (*CAConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{26} }

// OrchestrationConfig defines cluster-level orchestration settings.
type OrchestrationConfig struct {
	// TaskHistoryRetentionLimit is the number of historic tasks to keep per instance or
	// node. If negative, never remove completed or failed tasks.
	TaskHistoryRetentionLimit int64 `protobuf:"varint,1,opt,name=task_history_retention_limit,json=taskHistoryRetentionLimit,proto3" json:"task_history_retention_limit,omitempty"`
}

func (m *OrchestrationConfig) Reset()                    { *m = OrchestrationConfig{} }
func (*OrchestrationConfig) ProtoMessage()               {}
func (*OrchestrationConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{27} }

// TaskDefaults specifies default values for task creation.
type TaskDefaults struct {
	// LogDriver specifies the log driver to use for the cluster if not
	// specified for each task.
	//
	// If this is changed, only new tasks will pick up the new log driver.
	// Existing tasks will continue to use the previous default until rescheduled.
	LogDriver *Driver `protobuf:"bytes,1,opt,name=log_driver,json=logDriver" json:"log_driver,omitempty"`
}

func (m *TaskDefaults) Reset()                    { *m = TaskDefaults{} }
func (*TaskDefaults) ProtoMessage()               {}
func (*TaskDefaults) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{28} }

// DispatcherConfig defines cluster-level dispatcher settings.
type DispatcherConfig struct {
	// HeartbeatPeriod defines how often agent should send heartbeats to
	// dispatcher.
	HeartbeatPeriod *docker_swarmkit_v11.Duration `protobuf:"bytes,1,opt,name=heartbeat_period,json=heartbeatPeriod" json:"heartbeat_period,omitempty"`
}

func (m *DispatcherConfig) Reset()                    { *m = DispatcherConfig{} }
func (*DispatcherConfig) ProtoMessage()               {}
func (*DispatcherConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{29} }

// RaftConfig defines raft settings for the cluster.
type RaftConfig struct {
	// SnapshotInterval is the number of log entries between snapshots.
	SnapshotInterval uint64 `protobuf:"varint,1,opt,name=snapshot_interval,json=snapshotInterval,proto3" json:"snapshot_interval,omitempty"`
	// KeepOldSnapshots is the number of snapshots to keep beyond the
	// current snapshot.
	KeepOldSnapshots uint64 `protobuf:"varint,2,opt,name=keep_old_snapshots,json=keepOldSnapshots,proto3" json:"keep_old_snapshots,omitempty"`
	// LogEntriesForSlowFollowers is the number of log entries to keep
	// around to sync up slow followers after a snapshot is created.
	LogEntriesForSlowFollowers uint64 `protobuf:"varint,3,opt,name=log_entries_for_slow_followers,json=logEntriesForSlowFollowers,proto3" json:"log_entries_for_slow_followers,omitempty"`
	// HeartbeatTick defines the amount of ticks (in seconds) between
	// each heartbeat message sent to other members for health-check.
	HeartbeatTick uint32 `protobuf:"varint,4,opt,name=heartbeat_tick,json=heartbeatTick,proto3" json:"heartbeat_tick,omitempty"`
	// ElectionTick defines the amount of ticks (in seconds) needed
	// without a leader to trigger a new election.
	ElectionTick uint32 `protobuf:"varint,5,opt,name=election_tick,json=electionTick,proto3" json:"election_tick,omitempty"`
}

func (m *RaftConfig) Reset()                    { *m = RaftConfig{} }
func (*RaftConfig) ProtoMessage()               {}
func (*RaftConfig) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{30} }

// Placement specifies task distribution constraints.
type Placement struct {
	// constraints specifies a set of requirements a node should meet for a task.
	Constraints []string `protobuf:"bytes,1,rep,name=constraints" json:"constraints,omitempty"`
}

func (m *Placement) Reset()                    { *m = Placement{} }
func (*Placement) ProtoMessage()               {}
func (*Placement) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{31} }

// JoinToken contains the join tokens for workers and managers.
type JoinTokens struct {
	// Worker is the join token workers may use to join the swarm.
	Worker string `protobuf:"bytes,1,opt,name=worker,proto3" json:"worker,omitempty"`
	// Manager is the join token workers may use to join the swarm.
	Manager string `protobuf:"bytes,2,opt,name=manager,proto3" json:"manager,omitempty"`
}

func (m *JoinTokens) Reset()                    { *m = JoinTokens{} }
func (*JoinTokens) ProtoMessage()               {}
func (*JoinTokens) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{32} }

type RootCA struct {
	// CAKey is the root CA private key.
	CAKey []byte `protobuf:"bytes,1,opt,name=ca_key,json=caKey,proto3" json:"ca_key,omitempty"`
	// CACert is the root CA certificate.
	CACert []byte `protobuf:"bytes,2,opt,name=ca_cert,json=caCert,proto3" json:"ca_cert,omitempty"`
	// CACertHash is the digest of the CA Certificate.
	CACertHash string `protobuf:"bytes,3,opt,name=ca_cert_hash,json=caCertHash,proto3" json:"ca_cert_hash,omitempty"`
	// JoinTokens contains the join tokens for workers and managers.
	JoinTokens JoinTokens `protobuf:"bytes,4,opt,name=join_tokens,json=joinTokens" json:"join_tokens"`
}

func (m *RootCA) Reset()                    { *m = RootCA{} }
func (*RootCA) ProtoMessage()               {}
func (*RootCA) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{33} }

type Certificate struct {
	Role        NodeRole       `protobuf:"varint,1,opt,name=role,proto3,enum=docker.swarmkit.v1.NodeRole" json:"role,omitempty"`
	CSR         []byte         `protobuf:"bytes,2,opt,name=csr,proto3" json:"csr,omitempty"`
	Status      IssuanceStatus `protobuf:"bytes,3,opt,name=status" json:"status"`
	Certificate []byte         `protobuf:"bytes,4,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// CN represents the node ID.
	CN string `protobuf:"bytes,5,opt,name=cn,proto3" json:"cn,omitempty"`
}

func (m *Certificate) Reset()                    { *m = Certificate{} }
func (*Certificate) ProtoMessage()               {}
func (*Certificate) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{34} }

// Symmetric keys to encrypt inter-agent communication.
type EncryptionKey struct {
	// Agent subsystem the key is intended for. Example:
	// networking:gossip
	Subsystem string                  `protobuf:"bytes,1,opt,name=subsystem,proto3" json:"subsystem,omitempty"`
	Algorithm EncryptionKey_Algorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=docker.swarmkit.v1.EncryptionKey_Algorithm" json:"algorithm,omitempty"`
	Key       []byte                  `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Time stamp from the lamport clock of the key allocator to
	// identify the relative age of the key.
	LamportTime uint64 `protobuf:"varint,4,opt,name=lamport_time,json=lamportTime,proto3" json:"lamport_time,omitempty"`
}

func (m *EncryptionKey) Reset()                    { *m = EncryptionKey{} }
func (*EncryptionKey) ProtoMessage()               {}
func (*EncryptionKey) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{35} }

// ManagerStatus provides informations about the state of a manager in the cluster.
type ManagerStatus struct {
	// RaftID specifies the internal ID used by the manager in a raft context, it can never be modified
	// and is used only for information purposes
	RaftID uint64 `protobuf:"varint,1,opt,name=raft_id,json=raftId,proto3" json:"raft_id,omitempty"`
	// Addr is the address advertised to raft.
	Addr string `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
	// Leader is set to true if this node is the raft leader.
	Leader bool `protobuf:"varint,3,opt,name=leader,proto3" json:"leader,omitempty"`
	// Reachability specifies whether this node is reachable.
	Reachability RaftMemberStatus_Reachability `protobuf:"varint,4,opt,name=reachability,proto3,enum=docker.swarmkit.v1.RaftMemberStatus_Reachability" json:"reachability,omitempty"`
}

func (m *ManagerStatus) Reset()                    { *m = ManagerStatus{} }
func (*ManagerStatus) ProtoMessage()               {}
func (*ManagerStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{36} }

func init() {
	proto.RegisterType((*Version)(nil), "docker.swarmkit.v1.Version")
	proto.RegisterType((*Annotations)(nil), "docker.swarmkit.v1.Annotations")
	proto.RegisterType((*Resources)(nil), "docker.swarmkit.v1.Resources")
	proto.RegisterType((*ResourceRequirements)(nil), "docker.swarmkit.v1.ResourceRequirements")
	proto.RegisterType((*Platform)(nil), "docker.swarmkit.v1.Platform")
	proto.RegisterType((*PluginDescription)(nil), "docker.swarmkit.v1.PluginDescription")
	proto.RegisterType((*EngineDescription)(nil), "docker.swarmkit.v1.EngineDescription")
	proto.RegisterType((*NodeDescription)(nil), "docker.swarmkit.v1.NodeDescription")
	proto.RegisterType((*RaftMemberStatus)(nil), "docker.swarmkit.v1.RaftMemberStatus")
	proto.RegisterType((*NodeStatus)(nil), "docker.swarmkit.v1.NodeStatus")
	proto.RegisterType((*Image)(nil), "docker.swarmkit.v1.Image")
	proto.RegisterType((*Mount)(nil), "docker.swarmkit.v1.Mount")
	proto.RegisterType((*Mount_BindOptions)(nil), "docker.swarmkit.v1.Mount.BindOptions")
	proto.RegisterType((*Mount_VolumeOptions)(nil), "docker.swarmkit.v1.Mount.VolumeOptions")
	proto.RegisterType((*Mount_TmpfsOptions)(nil), "docker.swarmkit.v1.Mount.TmpfsOptions")
	proto.RegisterType((*RestartPolicy)(nil), "docker.swarmkit.v1.RestartPolicy")
	proto.RegisterType((*UpdateConfig)(nil), "docker.swarmkit.v1.UpdateConfig")
	proto.RegisterType((*UpdateStatus)(nil), "docker.swarmkit.v1.UpdateStatus")
	proto.RegisterType((*ContainerStatus)(nil), "docker.swarmkit.v1.ContainerStatus")
	proto.RegisterType((*TaskStatus)(nil), "docker.swarmkit.v1.TaskStatus")
	proto.RegisterType((*IPAMConfig)(nil), "docker.swarmkit.v1.IPAMConfig")
	proto.RegisterType((*PortConfig)(nil), "docker.swarmkit.v1.PortConfig")
	proto.RegisterType((*Driver)(nil), "docker.swarmkit.v1.Driver")
	proto.RegisterType((*IPAMOptions)(nil), "docker.swarmkit.v1.IPAMOptions")
	proto.RegisterType((*Peer)(nil), "docker.swarmkit.v1.Peer")
	proto.RegisterType((*WeightedPeer)(nil), "docker.swarmkit.v1.WeightedPeer")
	proto.RegisterType((*IssuanceStatus)(nil), "docker.swarmkit.v1.IssuanceStatus")
	proto.RegisterType((*AcceptancePolicy)(nil), "docker.swarmkit.v1.AcceptancePolicy")
	proto.RegisterType((*AcceptancePolicy_RoleAdmissionPolicy)(nil), "docker.swarmkit.v1.AcceptancePolicy.RoleAdmissionPolicy")
	proto.RegisterType((*AcceptancePolicy_RoleAdmissionPolicy_Secret)(nil), "docker.swarmkit.v1.AcceptancePolicy.RoleAdmissionPolicy.Secret")
	proto.RegisterType((*ExternalCA)(nil), "docker.swarmkit.v1.ExternalCA")
	proto.RegisterType((*CAConfig)(nil), "docker.swarmkit.v1.CAConfig")
	proto.RegisterType((*OrchestrationConfig)(nil), "docker.swarmkit.v1.OrchestrationConfig")
	proto.RegisterType((*TaskDefaults)(nil), "docker.swarmkit.v1.TaskDefaults")
	proto.RegisterType((*DispatcherConfig)(nil), "docker.swarmkit.v1.DispatcherConfig")
	proto.RegisterType((*RaftConfig)(nil), "docker.swarmkit.v1.RaftConfig")
	proto.RegisterType((*Placement)(nil), "docker.swarmkit.v1.Placement")
	proto.RegisterType((*JoinTokens)(nil), "docker.swarmkit.v1.JoinTokens")
	proto.RegisterType((*RootCA)(nil), "docker.swarmkit.v1.RootCA")
	proto.RegisterType((*Certificate)(nil), "docker.swarmkit.v1.Certificate")
	proto.RegisterType((*EncryptionKey)(nil), "docker.swarmkit.v1.EncryptionKey")
	proto.RegisterType((*ManagerStatus)(nil), "docker.swarmkit.v1.ManagerStatus")
	proto.RegisterEnum("docker.swarmkit.v1.TaskState", TaskState_name, TaskState_value)
	proto.RegisterEnum("docker.swarmkit.v1.NodeRole", NodeRole_name, NodeRole_value)
	proto.RegisterEnum("docker.swarmkit.v1.RaftMemberStatus_Reachability", RaftMemberStatus_Reachability_name, RaftMemberStatus_Reachability_value)
	proto.RegisterEnum("docker.swarmkit.v1.NodeStatus_State", NodeStatus_State_name, NodeStatus_State_value)
	proto.RegisterEnum("docker.swarmkit.v1.Mount_MountType", Mount_MountType_name, Mount_MountType_value)
	proto.RegisterEnum("docker.swarmkit.v1.Mount_BindOptions_MountPropagation", Mount_BindOptions_MountPropagation_name, Mount_BindOptions_MountPropagation_value)
	proto.RegisterEnum("docker.swarmkit.v1.RestartPolicy_RestartCondition", RestartPolicy_RestartCondition_name, RestartPolicy_RestartCondition_value)
	proto.RegisterEnum("docker.swarmkit.v1.UpdateConfig_FailureAction", UpdateConfig_FailureAction_name, UpdateConfig_FailureAction_value)
	proto.RegisterEnum("docker.swarmkit.v1.UpdateStatus_UpdateState", UpdateStatus_UpdateState_name, UpdateStatus_UpdateState_value)
	proto.RegisterEnum("docker.swarmkit.v1.IPAMConfig_AddressFamily", IPAMConfig_AddressFamily_name, IPAMConfig_AddressFamily_value)
	proto.RegisterEnum("docker.swarmkit.v1.PortConfig_Protocol", PortConfig_Protocol_name, PortConfig_Protocol_value)
	proto.RegisterEnum("docker.swarmkit.v1.IssuanceStatus_State", IssuanceStatus_State_name, IssuanceStatus_State_value)
	proto.RegisterEnum("docker.swarmkit.v1.ExternalCA_CAProtocol", ExternalCA_CAProtocol_name, ExternalCA_CAProtocol_value)
	proto.RegisterEnum("docker.swarmkit.v1.EncryptionKey_Algorithm", EncryptionKey_Algorithm_name, EncryptionKey_Algorithm_value)
}

func (m *Version) Copy() *Version {
	if m == nil {
		return nil
	}

	o := &Version{
		Index: m.Index,
	}

	return o
}

func (m *Annotations) Copy() *Annotations {
	if m == nil {
		return nil
	}

	o := &Annotations{
		Name: m.Name,
	}

	if m.Labels != nil {
		o.Labels = make(map[string]string)
		for k, v := range m.Labels {
			o.Labels[k] = v
		}
	}

	return o
}

func (m *Resources) Copy() *Resources {
	if m == nil {
		return nil
	}

	o := &Resources{
		NanoCPUs:    m.NanoCPUs,
		MemoryBytes: m.MemoryBytes,
	}

	return o
}

func (m *ResourceRequirements) Copy() *ResourceRequirements {
	if m == nil {
		return nil
	}

	o := &ResourceRequirements{
		Limits:       m.Limits.Copy(),
		Reservations: m.Reservations.Copy(),
	}

	return o
}

func (m *Platform) Copy() *Platform {
	if m == nil {
		return nil
	}

	o := &Platform{
		Architecture: m.Architecture,
		OS:           m.OS,
	}

	return o
}

func (m *PluginDescription) Copy() *PluginDescription {
	if m == nil {
		return nil
	}

	o := &PluginDescription{
		Type: m.Type,
		Name: m.Name,
	}

	return o
}

func (m *EngineDescription) Copy() *EngineDescription {
	if m == nil {
		return nil
	}

	o := &EngineDescription{
		EngineVersion: m.EngineVersion,
	}

	if m.Labels != nil {
		o.Labels = make(map[string]string)
		for k, v := range m.Labels {
			o.Labels[k] = v
		}
	}

	if m.Plugins != nil {
		o.Plugins = make([]PluginDescription, 0, len(m.Plugins))
		for _, v := range m.Plugins {
			o.Plugins = append(o.Plugins, *v.Copy())
		}
	}

	return o
}

func (m *NodeDescription) Copy() *NodeDescription {
	if m == nil {
		return nil
	}

	o := &NodeDescription{
		Hostname:  m.Hostname,
		Platform:  m.Platform.Copy(),
		Resources: m.Resources.Copy(),
		Engine:    m.Engine.Copy(),
	}

	return o
}

func (m *RaftMemberStatus) Copy() *RaftMemberStatus {
	if m == nil {
		return nil
	}

	o := &RaftMemberStatus{
		Leader:       m.Leader,
		Reachability: m.Reachability,
		Message:      m.Message,
	}

	return o
}

func (m *NodeStatus) Copy() *NodeStatus {
	if m == nil {
		return nil
	}

	o := &NodeStatus{
		State:   m.State,
		Message: m.Message,
	}

	return o
}

func (m *Image) Copy() *Image {
	if m == nil {
		return nil
	}

	o := &Image{
		Reference: m.Reference,
	}

	return o
}

func (m *Mount) Copy() *Mount {
	if m == nil {
		return nil
	}

	o := &Mount{
		Type:          m.Type,
		Source:        m.Source,
		Target:        m.Target,
		ReadOnly:      m.ReadOnly,
		BindOptions:   m.BindOptions.Copy(),
		VolumeOptions: m.VolumeOptions.Copy(),
		TmpfsOptions:  m.TmpfsOptions.Copy(),
	}

	return o
}

func (m *Mount_BindOptions) Copy() *Mount_BindOptions {
	if m == nil {
		return nil
	}

	o := &Mount_BindOptions{
		Propagation: m.Propagation,
	}

	return o
}

func (m *Mount_VolumeOptions) Copy() *Mount_VolumeOptions {
	if m == nil {
		return nil
	}

	o := &Mount_VolumeOptions{
		NoCopy:       m.NoCopy,
		DriverConfig: m.DriverConfig.Copy(),
	}

	if m.Labels != nil {
		o.Labels = make(map[string]string)
		for k, v := range m.Labels {
			o.Labels[k] = v
		}
	}

	return o
}

func (m *Mount_TmpfsOptions) Copy() *Mount_TmpfsOptions {
	if m == nil {
		return nil
	}

	o := &Mount_TmpfsOptions{
		SizeBytes: m.SizeBytes,
		Mode:      m.Mode,
	}

	return o
}

func (m *RestartPolicy) Copy() *RestartPolicy {
	if m == nil {
		return nil
	}

	o := &RestartPolicy{
		Condition:   m.Condition,
		Delay:       m.Delay.Copy(),
		MaxAttempts: m.MaxAttempts,
		Window:      m.Window.Copy(),
	}

	return o
}

func (m *UpdateConfig) Copy() *UpdateConfig {
	if m == nil {
		return nil
	}

	o := &UpdateConfig{
		Parallelism:   m.Parallelism,
		Delay:         *m.Delay.Copy(),
		FailureAction: m.FailureAction,
	}

	return o
}

func (m *UpdateStatus) Copy() *UpdateStatus {
	if m == nil {
		return nil
	}

	o := &UpdateStatus{
		State:       m.State,
		StartedAt:   m.StartedAt.Copy(),
		CompletedAt: m.CompletedAt.Copy(),
		Message:     m.Message,
	}

	return o
}

func (m *ContainerStatus) Copy() *ContainerStatus {
	if m == nil {
		return nil
	}

	o := &ContainerStatus{
		ContainerID: m.ContainerID,
		PID:         m.PID,
		ExitCode:    m.ExitCode,
	}

	return o
}

func (m *TaskStatus) Copy() *TaskStatus {
	if m == nil {
		return nil
	}

	o := &TaskStatus{
		Timestamp: m.Timestamp.Copy(),
		State:     m.State,
		Message:   m.Message,
		Err:       m.Err,
	}

	switch m.RuntimeStatus.(type) {
	case *TaskStatus_Container:
		i := &TaskStatus_Container{
			Container: m.GetContainer().Copy(),
		}

		o.RuntimeStatus = i
	}

	return o
}

func (m *IPAMConfig) Copy() *IPAMConfig {
	if m == nil {
		return nil
	}

	o := &IPAMConfig{
		Family:  m.Family,
		Subnet:  m.Subnet,
		Range:   m.Range,
		Gateway: m.Gateway,
	}

	if m.Reserved != nil {
		o.Reserved = make(map[string]string)
		for k, v := range m.Reserved {
			o.Reserved[k] = v
		}
	}

	return o
}

func (m *PortConfig) Copy() *PortConfig {
	if m == nil {
		return nil
	}

	o := &PortConfig{
		Name:          m.Name,
		Protocol:      m.Protocol,
		TargetPort:    m.TargetPort,
		PublishedPort: m.PublishedPort,
	}

	return o
}

func (m *Driver) Copy() *Driver {
	if m == nil {
		return nil
	}

	o := &Driver{
		Name: m.Name,
	}

	if m.Options != nil {
		o.Options = make(map[string]string)
		for k, v := range m.Options {
			o.Options[k] = v
		}
	}

	return o
}

func (m *IPAMOptions) Copy() *IPAMOptions {
	if m == nil {
		return nil
	}

	o := &IPAMOptions{
		Driver: m.Driver.Copy(),
	}

	if m.Configs != nil {
		o.Configs = make([]*IPAMConfig, 0, len(m.Configs))
		for _, v := range m.Configs {
			o.Configs = append(o.Configs, v.Copy())
		}
	}

	return o
}

func (m *Peer) Copy() *Peer {
	if m == nil {
		return nil
	}

	o := &Peer{
		NodeID: m.NodeID,
		Addr:   m.Addr,
	}

	return o
}

func (m *WeightedPeer) Copy() *WeightedPeer {
	if m == nil {
		return nil
	}

	o := &WeightedPeer{
		Peer:   m.Peer.Copy(),
		Weight: m.Weight,
	}

	return o
}

func (m *IssuanceStatus) Copy() *IssuanceStatus {
	if m == nil {
		return nil
	}

	o := &IssuanceStatus{
		State: m.State,
		Err:   m.Err,
	}

	return o
}

func (m *AcceptancePolicy) Copy() *AcceptancePolicy {
	if m == nil {
		return nil
	}

	o := &AcceptancePolicy{}

	if m.Policies != nil {
		o.Policies = make([]*AcceptancePolicy_RoleAdmissionPolicy, 0, len(m.Policies))
		for _, v := range m.Policies {
			o.Policies = append(o.Policies, v.Copy())
		}
	}

	return o
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) Copy() *AcceptancePolicy_RoleAdmissionPolicy {
	if m == nil {
		return nil
	}

	o := &AcceptancePolicy_RoleAdmissionPolicy{
		Role:       m.Role,
		Autoaccept: m.Autoaccept,
		Secret:     m.Secret.Copy(),
	}

	return o
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Copy() *AcceptancePolicy_RoleAdmissionPolicy_Secret {
	if m == nil {
		return nil
	}

	o := &AcceptancePolicy_RoleAdmissionPolicy_Secret{
		Data: m.Data,
		Alg:  m.Alg,
	}

	return o
}

func (m *ExternalCA) Copy() *ExternalCA {
	if m == nil {
		return nil
	}

	o := &ExternalCA{
		Protocol: m.Protocol,
		URL:      m.URL,
	}

	if m.Options != nil {
		o.Options = make(map[string]string)
		for k, v := range m.Options {
			o.Options[k] = v
		}
	}

	return o
}

func (m *CAConfig) Copy() *CAConfig {
	if m == nil {
		return nil
	}

	o := &CAConfig{
		NodeCertExpiry: m.NodeCertExpiry.Copy(),
	}

	if m.ExternalCAs != nil {
		o.ExternalCAs = make([]*ExternalCA, 0, len(m.ExternalCAs))
		for _, v := range m.ExternalCAs {
			o.ExternalCAs = append(o.ExternalCAs, v.Copy())
		}
	}

	return o
}

func (m *OrchestrationConfig) Copy() *OrchestrationConfig {
	if m == nil {
		return nil
	}

	o := &OrchestrationConfig{
		TaskHistoryRetentionLimit: m.TaskHistoryRetentionLimit,
	}

	return o
}

func (m *TaskDefaults) Copy() *TaskDefaults {
	if m == nil {
		return nil
	}

	o := &TaskDefaults{
		LogDriver: m.LogDriver.Copy(),
	}

	return o
}

func (m *DispatcherConfig) Copy() *DispatcherConfig {
	if m == nil {
		return nil
	}

	o := &DispatcherConfig{
		HeartbeatPeriod: m.HeartbeatPeriod.Copy(),
	}

	return o
}

func (m *RaftConfig) Copy() *RaftConfig {
	if m == nil {
		return nil
	}

	o := &RaftConfig{
		SnapshotInterval:           m.SnapshotInterval,
		KeepOldSnapshots:           m.KeepOldSnapshots,
		LogEntriesForSlowFollowers: m.LogEntriesForSlowFollowers,
		HeartbeatTick:              m.HeartbeatTick,
		ElectionTick:               m.ElectionTick,
	}

	return o
}

func (m *Placement) Copy() *Placement {
	if m == nil {
		return nil
	}

	o := &Placement{}

	if m.Constraints != nil {
		o.Constraints = make([]string, 0, len(m.Constraints))
		for _, v := range m.Constraints {
			o.Constraints = append(o.Constraints, v)
		}
	}

	return o
}

func (m *JoinTokens) Copy() *JoinTokens {
	if m == nil {
		return nil
	}

	o := &JoinTokens{
		Worker:  m.Worker,
		Manager: m.Manager,
	}

	return o
}

func (m *RootCA) Copy() *RootCA {
	if m == nil {
		return nil
	}

	o := &RootCA{
		CAKey:      m.CAKey,
		CACert:     m.CACert,
		CACertHash: m.CACertHash,
		JoinTokens: *m.JoinTokens.Copy(),
	}

	return o
}

func (m *Certificate) Copy() *Certificate {
	if m == nil {
		return nil
	}

	o := &Certificate{
		Role:        m.Role,
		CSR:         m.CSR,
		Status:      *m.Status.Copy(),
		Certificate: m.Certificate,
		CN:          m.CN,
	}

	return o
}

func (m *EncryptionKey) Copy() *EncryptionKey {
	if m == nil {
		return nil
	}

	o := &EncryptionKey{
		Subsystem:   m.Subsystem,
		Algorithm:   m.Algorithm,
		Key:         m.Key,
		LamportTime: m.LamportTime,
	}

	return o
}

func (m *ManagerStatus) Copy() *ManagerStatus {
	if m == nil {
		return nil
	}

	o := &ManagerStatus{
		RaftID:       m.RaftID,
		Addr:         m.Addr,
		Leader:       m.Leader,
		Reachability: m.Reachability,
	}

	return o
}

func (this *Version) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.Version{")
	s = append(s, "Index: "+fmt.Sprintf("%#v", this.Index)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Annotations) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Annotations{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%#v: %#v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	if this.Labels != nil {
		s = append(s, "Labels: "+mapStringForLabels+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resources) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Resources{")
	s = append(s, "NanoCPUs: "+fmt.Sprintf("%#v", this.NanoCPUs)+",\n")
	s = append(s, "MemoryBytes: "+fmt.Sprintf("%#v", this.MemoryBytes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceRequirements) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.ResourceRequirements{")
	if this.Limits != nil {
		s = append(s, "Limits: "+fmt.Sprintf("%#v", this.Limits)+",\n")
	}
	if this.Reservations != nil {
		s = append(s, "Reservations: "+fmt.Sprintf("%#v", this.Reservations)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Platform) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Platform{")
	s = append(s, "Architecture: "+fmt.Sprintf("%#v", this.Architecture)+",\n")
	s = append(s, "OS: "+fmt.Sprintf("%#v", this.OS)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PluginDescription) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.PluginDescription{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EngineDescription) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.EngineDescription{")
	s = append(s, "EngineVersion: "+fmt.Sprintf("%#v", this.EngineVersion)+",\n")
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%#v: %#v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	if this.Labels != nil {
		s = append(s, "Labels: "+mapStringForLabels+",\n")
	}
	if this.Plugins != nil {
		s = append(s, "Plugins: "+fmt.Sprintf("%#v", this.Plugins)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeDescription) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.NodeDescription{")
	s = append(s, "Hostname: "+fmt.Sprintf("%#v", this.Hostname)+",\n")
	if this.Platform != nil {
		s = append(s, "Platform: "+fmt.Sprintf("%#v", this.Platform)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Engine != nil {
		s = append(s, "Engine: "+fmt.Sprintf("%#v", this.Engine)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RaftMemberStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.RaftMemberStatus{")
	s = append(s, "Leader: "+fmt.Sprintf("%#v", this.Leader)+",\n")
	s = append(s, "Reachability: "+fmt.Sprintf("%#v", this.Reachability)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.NodeStatus{")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Image) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.Image{")
	s = append(s, "Reference: "+fmt.Sprintf("%#v", this.Reference)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Mount) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&api.Mount{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	s = append(s, "Target: "+fmt.Sprintf("%#v", this.Target)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	if this.BindOptions != nil {
		s = append(s, "BindOptions: "+fmt.Sprintf("%#v", this.BindOptions)+",\n")
	}
	if this.VolumeOptions != nil {
		s = append(s, "VolumeOptions: "+fmt.Sprintf("%#v", this.VolumeOptions)+",\n")
	}
	if this.TmpfsOptions != nil {
		s = append(s, "TmpfsOptions: "+fmt.Sprintf("%#v", this.TmpfsOptions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Mount_BindOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.Mount_BindOptions{")
	s = append(s, "Propagation: "+fmt.Sprintf("%#v", this.Propagation)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Mount_VolumeOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.Mount_VolumeOptions{")
	s = append(s, "NoCopy: "+fmt.Sprintf("%#v", this.NoCopy)+",\n")
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%#v: %#v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	if this.Labels != nil {
		s = append(s, "Labels: "+mapStringForLabels+",\n")
	}
	if this.DriverConfig != nil {
		s = append(s, "DriverConfig: "+fmt.Sprintf("%#v", this.DriverConfig)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Mount_TmpfsOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Mount_TmpfsOptions{")
	s = append(s, "SizeBytes: "+fmt.Sprintf("%#v", this.SizeBytes)+",\n")
	s = append(s, "Mode: "+fmt.Sprintf("%#v", this.Mode)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RestartPolicy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.RestartPolicy{")
	s = append(s, "Condition: "+fmt.Sprintf("%#v", this.Condition)+",\n")
	if this.Delay != nil {
		s = append(s, "Delay: "+fmt.Sprintf("%#v", this.Delay)+",\n")
	}
	s = append(s, "MaxAttempts: "+fmt.Sprintf("%#v", this.MaxAttempts)+",\n")
	if this.Window != nil {
		s = append(s, "Window: "+fmt.Sprintf("%#v", this.Window)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.UpdateConfig{")
	s = append(s, "Parallelism: "+fmt.Sprintf("%#v", this.Parallelism)+",\n")
	s = append(s, "Delay: "+strings.Replace(this.Delay.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "FailureAction: "+fmt.Sprintf("%#v", this.FailureAction)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.UpdateStatus{")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	if this.StartedAt != nil {
		s = append(s, "StartedAt: "+fmt.Sprintf("%#v", this.StartedAt)+",\n")
	}
	if this.CompletedAt != nil {
		s = append(s, "CompletedAt: "+fmt.Sprintf("%#v", this.CompletedAt)+",\n")
	}
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.ContainerStatus{")
	s = append(s, "ContainerID: "+fmt.Sprintf("%#v", this.ContainerID)+",\n")
	s = append(s, "PID: "+fmt.Sprintf("%#v", this.PID)+",\n")
	s = append(s, "ExitCode: "+fmt.Sprintf("%#v", this.ExitCode)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.TaskStatus{")
	if this.Timestamp != nil {
		s = append(s, "Timestamp: "+fmt.Sprintf("%#v", this.Timestamp)+",\n")
	}
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "Err: "+fmt.Sprintf("%#v", this.Err)+",\n")
	if this.RuntimeStatus != nil {
		s = append(s, "RuntimeStatus: "+fmt.Sprintf("%#v", this.RuntimeStatus)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskStatus_Container) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.TaskStatus_Container{` +
		`Container:` + fmt.Sprintf("%#v", this.Container) + `}`}, ", ")
	return s
}
func (this *IPAMConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.IPAMConfig{")
	s = append(s, "Family: "+fmt.Sprintf("%#v", this.Family)+",\n")
	s = append(s, "Subnet: "+fmt.Sprintf("%#v", this.Subnet)+",\n")
	s = append(s, "Range: "+fmt.Sprintf("%#v", this.Range)+",\n")
	s = append(s, "Gateway: "+fmt.Sprintf("%#v", this.Gateway)+",\n")
	keysForReserved := make([]string, 0, len(this.Reserved))
	for k, _ := range this.Reserved {
		keysForReserved = append(keysForReserved, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForReserved)
	mapStringForReserved := "map[string]string{"
	for _, k := range keysForReserved {
		mapStringForReserved += fmt.Sprintf("%#v: %#v,", k, this.Reserved[k])
	}
	mapStringForReserved += "}"
	if this.Reserved != nil {
		s = append(s, "Reserved: "+mapStringForReserved+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PortConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.PortConfig{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "TargetPort: "+fmt.Sprintf("%#v", this.TargetPort)+",\n")
	s = append(s, "PublishedPort: "+fmt.Sprintf("%#v", this.PublishedPort)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Driver) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Driver{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%#v: %#v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	if this.Options != nil {
		s = append(s, "Options: "+mapStringForOptions+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IPAMOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.IPAMOptions{")
	if this.Driver != nil {
		s = append(s, "Driver: "+fmt.Sprintf("%#v", this.Driver)+",\n")
	}
	if this.Configs != nil {
		s = append(s, "Configs: "+fmt.Sprintf("%#v", this.Configs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Peer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Peer{")
	s = append(s, "NodeID: "+fmt.Sprintf("%#v", this.NodeID)+",\n")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WeightedPeer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.WeightedPeer{")
	if this.Peer != nil {
		s = append(s, "Peer: "+fmt.Sprintf("%#v", this.Peer)+",\n")
	}
	s = append(s, "Weight: "+fmt.Sprintf("%#v", this.Weight)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IssuanceStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.IssuanceStatus{")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Err: "+fmt.Sprintf("%#v", this.Err)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AcceptancePolicy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.AcceptancePolicy{")
	if this.Policies != nil {
		s = append(s, "Policies: "+fmt.Sprintf("%#v", this.Policies)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AcceptancePolicy_RoleAdmissionPolicy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.AcceptancePolicy_RoleAdmissionPolicy{")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "Autoaccept: "+fmt.Sprintf("%#v", this.Autoaccept)+",\n")
	if this.Secret != nil {
		s = append(s, "Secret: "+fmt.Sprintf("%#v", this.Secret)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AcceptancePolicy_RoleAdmissionPolicy_Secret) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.AcceptancePolicy_RoleAdmissionPolicy_Secret{")
	s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	s = append(s, "Alg: "+fmt.Sprintf("%#v", this.Alg)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ExternalCA) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.ExternalCA{")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "URL: "+fmt.Sprintf("%#v", this.URL)+",\n")
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%#v: %#v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	if this.Options != nil {
		s = append(s, "Options: "+mapStringForOptions+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CAConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.CAConfig{")
	if this.NodeCertExpiry != nil {
		s = append(s, "NodeCertExpiry: "+fmt.Sprintf("%#v", this.NodeCertExpiry)+",\n")
	}
	if this.ExternalCAs != nil {
		s = append(s, "ExternalCAs: "+fmt.Sprintf("%#v", this.ExternalCAs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OrchestrationConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.OrchestrationConfig{")
	s = append(s, "TaskHistoryRetentionLimit: "+fmt.Sprintf("%#v", this.TaskHistoryRetentionLimit)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskDefaults) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.TaskDefaults{")
	if this.LogDriver != nil {
		s = append(s, "LogDriver: "+fmt.Sprintf("%#v", this.LogDriver)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DispatcherConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.DispatcherConfig{")
	if this.HeartbeatPeriod != nil {
		s = append(s, "HeartbeatPeriod: "+fmt.Sprintf("%#v", this.HeartbeatPeriod)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RaftConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.RaftConfig{")
	s = append(s, "SnapshotInterval: "+fmt.Sprintf("%#v", this.SnapshotInterval)+",\n")
	s = append(s, "KeepOldSnapshots: "+fmt.Sprintf("%#v", this.KeepOldSnapshots)+",\n")
	s = append(s, "LogEntriesForSlowFollowers: "+fmt.Sprintf("%#v", this.LogEntriesForSlowFollowers)+",\n")
	s = append(s, "HeartbeatTick: "+fmt.Sprintf("%#v", this.HeartbeatTick)+",\n")
	s = append(s, "ElectionTick: "+fmt.Sprintf("%#v", this.ElectionTick)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Placement) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.Placement{")
	s = append(s, "Constraints: "+fmt.Sprintf("%#v", this.Constraints)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *JoinTokens) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.JoinTokens{")
	s = append(s, "Worker: "+fmt.Sprintf("%#v", this.Worker)+",\n")
	s = append(s, "Manager: "+fmt.Sprintf("%#v", this.Manager)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RootCA) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.RootCA{")
	s = append(s, "CAKey: "+fmt.Sprintf("%#v", this.CAKey)+",\n")
	s = append(s, "CACert: "+fmt.Sprintf("%#v", this.CACert)+",\n")
	s = append(s, "CACertHash: "+fmt.Sprintf("%#v", this.CACertHash)+",\n")
	s = append(s, "JoinTokens: "+strings.Replace(this.JoinTokens.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Certificate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.Certificate{")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "CSR: "+fmt.Sprintf("%#v", this.CSR)+",\n")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Certificate: "+fmt.Sprintf("%#v", this.Certificate)+",\n")
	s = append(s, "CN: "+fmt.Sprintf("%#v", this.CN)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EncryptionKey) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.EncryptionKey{")
	s = append(s, "Subsystem: "+fmt.Sprintf("%#v", this.Subsystem)+",\n")
	s = append(s, "Algorithm: "+fmt.Sprintf("%#v", this.Algorithm)+",\n")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "LamportTime: "+fmt.Sprintf("%#v", this.LamportTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ManagerStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.ManagerStatus{")
	s = append(s, "RaftID: "+fmt.Sprintf("%#v", this.RaftID)+",\n")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "Leader: "+fmt.Sprintf("%#v", this.Leader)+",\n")
	s = append(s, "Reachability: "+fmt.Sprintf("%#v", this.Reachability)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringTypes(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringTypes(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}
func (m *Version) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Version) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Index != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Index))
	}
	return i, nil
}

func (m *Annotations) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Annotations) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			data[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	return i, nil
}

func (m *Resources) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Resources) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NanoCPUs != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.NanoCPUs))
	}
	if m.MemoryBytes != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.MemoryBytes))
	}
	return i, nil
}

func (m *ResourceRequirements) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResourceRequirements) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Limits != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.Limits.Size()))
		n1, err := m.Limits.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Reservations != nil {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(m.Reservations.Size()))
		n2, err := m.Reservations.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *Platform) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Platform) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Architecture) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Architecture)))
		i += copy(data[i:], m.Architecture)
	}
	if len(m.OS) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.OS)))
		i += copy(data[i:], m.OS)
	}
	return i, nil
}

func (m *PluginDescription) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *PluginDescription) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Type) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Type)))
		i += copy(data[i:], m.Type)
	}
	if len(m.Name) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	return i, nil
}

func (m *EngineDescription) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *EngineDescription) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.EngineVersion) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.EngineVersion)))
		i += copy(data[i:], m.EngineVersion)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			data[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	if len(m.Plugins) > 0 {
		for _, msg := range m.Plugins {
			data[i] = 0x1a
			i++
			i = encodeVarintTypes(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *NodeDescription) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeDescription) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Hostname) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Hostname)))
		i += copy(data[i:], m.Hostname)
	}
	if m.Platform != nil {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(m.Platform.Size()))
		n3, err := m.Platform.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Resources != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(m.Resources.Size()))
		n4, err := m.Resources.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Engine != nil {
		data[i] = 0x22
		i++
		i = encodeVarintTypes(data, i, uint64(m.Engine.Size()))
		n5, err := m.Engine.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *RaftMemberStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RaftMemberStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Leader {
		data[i] = 0x8
		i++
		if m.Leader {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Reachability != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Reachability))
	}
	if len(m.Message) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Message)))
		i += copy(data[i:], m.Message)
	}
	return i, nil
}

func (m *NodeStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.State))
	}
	if len(m.Message) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Message)))
		i += copy(data[i:], m.Message)
	}
	return i, nil
}

func (m *Image) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Image) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Reference) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Reference)))
		i += copy(data[i:], m.Reference)
	}
	return i, nil
}

func (m *Mount) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Mount) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Type))
	}
	if len(m.Source) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Source)))
		i += copy(data[i:], m.Source)
	}
	if len(m.Target) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Target)))
		i += copy(data[i:], m.Target)
	}
	if m.ReadOnly {
		data[i] = 0x20
		i++
		if m.ReadOnly {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.BindOptions != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintTypes(data, i, uint64(m.BindOptions.Size()))
		n6, err := m.BindOptions.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.VolumeOptions != nil {
		data[i] = 0x32
		i++
		i = encodeVarintTypes(data, i, uint64(m.VolumeOptions.Size()))
		n7, err := m.VolumeOptions.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.TmpfsOptions != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintTypes(data, i, uint64(m.TmpfsOptions.Size()))
		n8, err := m.TmpfsOptions.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}

func (m *Mount_BindOptions) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Mount_BindOptions) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Propagation != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Propagation))
	}
	return i, nil
}

func (m *Mount_VolumeOptions) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Mount_VolumeOptions) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NoCopy {
		data[i] = 0x8
		i++
		if m.NoCopy {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			data[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	if m.DriverConfig != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(m.DriverConfig.Size()))
		n9, err := m.DriverConfig.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *Mount_TmpfsOptions) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Mount_TmpfsOptions) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SizeBytes != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.SizeBytes))
	}
	if m.Mode != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Mode))
	}
	return i, nil
}

func (m *RestartPolicy) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RestartPolicy) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Condition != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Condition))
	}
	if m.Delay != nil {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(m.Delay.Size()))
		n10, err := m.Delay.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.MaxAttempts != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintTypes(data, i, uint64(m.MaxAttempts))
	}
	if m.Window != nil {
		data[i] = 0x22
		i++
		i = encodeVarintTypes(data, i, uint64(m.Window.Size()))
		n11, err := m.Window.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *UpdateConfig) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Parallelism != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Parallelism))
	}
	data[i] = 0x12
	i++
	i = encodeVarintTypes(data, i, uint64(m.Delay.Size()))
	n12, err := m.Delay.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	if m.FailureAction != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintTypes(data, i, uint64(m.FailureAction))
	}
	return i, nil
}

func (m *UpdateStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.State))
	}
	if m.StartedAt != nil {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(m.StartedAt.Size()))
		n13, err := m.StartedAt.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.CompletedAt != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(m.CompletedAt.Size()))
		n14, err := m.CompletedAt.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if len(m.Message) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Message)))
		i += copy(data[i:], m.Message)
	}
	return i, nil
}

func (m *ContainerStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ContainerID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.ContainerID)))
		i += copy(data[i:], m.ContainerID)
	}
	if m.PID != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.PID))
	}
	if m.ExitCode != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintTypes(data, i, uint64(m.ExitCode))
	}
	return i, nil
}

func (m *TaskStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.Timestamp.Size()))
		n15, err := m.Timestamp.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.State != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.State))
	}
	if len(m.Message) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Message)))
		i += copy(data[i:], m.Message)
	}
	if len(m.Err) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Err)))
		i += copy(data[i:], m.Err)
	}
	if m.RuntimeStatus != nil {
		nn16, err := m.RuntimeStatus.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn16
	}
	return i, nil
}

func (m *TaskStatus_Container) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Container != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintTypes(data, i, uint64(m.Container.Size()))
		n17, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *IPAMConfig) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IPAMConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Family != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Family))
	}
	if len(m.Subnet) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Subnet)))
		i += copy(data[i:], m.Subnet)
	}
	if len(m.Range) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Range)))
		i += copy(data[i:], m.Range)
	}
	if len(m.Gateway) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Gateway)))
		i += copy(data[i:], m.Gateway)
	}
	if len(m.Reserved) > 0 {
		for k, _ := range m.Reserved {
			data[i] = 0x2a
			i++
			v := m.Reserved[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	return i, nil
}

func (m *PortConfig) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *PortConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if m.Protocol != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Protocol))
	}
	if m.TargetPort != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintTypes(data, i, uint64(m.TargetPort))
	}
	if m.PublishedPort != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintTypes(data, i, uint64(m.PublishedPort))
	}
	return i, nil
}

func (m *Driver) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Driver) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.Options) > 0 {
		for k, _ := range m.Options {
			data[i] = 0x12
			i++
			v := m.Options[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	return i, nil
}

func (m *IPAMOptions) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IPAMOptions) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Driver != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.Driver.Size()))
		n18, err := m.Driver.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if len(m.Configs) > 0 {
		for _, msg := range m.Configs {
			data[i] = 0x1a
			i++
			i = encodeVarintTypes(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Peer) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Peer) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	if len(m.Addr) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Addr)))
		i += copy(data[i:], m.Addr)
	}
	return i, nil
}

func (m *WeightedPeer) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *WeightedPeer) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Peer != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.Peer.Size()))
		n19, err := m.Peer.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.Weight != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Weight))
	}
	return i, nil
}

func (m *IssuanceStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IssuanceStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.State))
	}
	if len(m.Err) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Err)))
		i += copy(data[i:], m.Err)
	}
	return i, nil
}

func (m *AcceptancePolicy) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AcceptancePolicy) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Policies) > 0 {
		for _, msg := range m.Policies {
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Role))
	}
	if m.Autoaccept {
		data[i] = 0x10
		i++
		if m.Autoaccept {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Secret != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(m.Secret.Size()))
		n20, err := m.Secret.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	return i, nil
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if len(m.Alg) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Alg)))
		i += copy(data[i:], m.Alg)
	}
	return i, nil
}

func (m *ExternalCA) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ExternalCA) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Protocol != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Protocol))
	}
	if len(m.URL) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.URL)))
		i += copy(data[i:], m.URL)
	}
	if len(m.Options) > 0 {
		for k, _ := range m.Options {
			data[i] = 0x1a
			i++
			v := m.Options[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	return i, nil
}

func (m *CAConfig) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CAConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeCertExpiry != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.NodeCertExpiry.Size()))
		n21, err := m.NodeCertExpiry.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.ExternalCAs) > 0 {
		for _, msg := range m.ExternalCAs {
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *OrchestrationConfig) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *OrchestrationConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TaskHistoryRetentionLimit != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.TaskHistoryRetentionLimit))
	}
	return i, nil
}

func (m *TaskDefaults) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskDefaults) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LogDriver != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.LogDriver.Size()))
		n22, err := m.LogDriver.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	return i, nil
}

func (m *DispatcherConfig) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *DispatcherConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HeartbeatPeriod != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.HeartbeatPeriod.Size()))
		n23, err := m.HeartbeatPeriod.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	return i, nil
}

func (m *RaftConfig) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RaftConfig) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SnapshotInterval != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.SnapshotInterval))
	}
	if m.KeepOldSnapshots != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.KeepOldSnapshots))
	}
	if m.LogEntriesForSlowFollowers != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintTypes(data, i, uint64(m.LogEntriesForSlowFollowers))
	}
	if m.HeartbeatTick != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintTypes(data, i, uint64(m.HeartbeatTick))
	}
	if m.ElectionTick != 0 {
		data[i] = 0x28
		i++
		i = encodeVarintTypes(data, i, uint64(m.ElectionTick))
	}
	return i, nil
}

func (m *Placement) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Placement) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, s := range m.Constraints {
			data[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	return i, nil
}

func (m *JoinTokens) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *JoinTokens) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Worker) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Worker)))
		i += copy(data[i:], m.Worker)
	}
	if len(m.Manager) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Manager)))
		i += copy(data[i:], m.Manager)
	}
	return i, nil
}

func (m *RootCA) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RootCA) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.CAKey) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.CAKey)))
		i += copy(data[i:], m.CAKey)
	}
	if len(m.CACert) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.CACert)))
		i += copy(data[i:], m.CACert)
	}
	if len(m.CACertHash) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.CACertHash)))
		i += copy(data[i:], m.CACertHash)
	}
	data[i] = 0x22
	i++
	i = encodeVarintTypes(data, i, uint64(m.JoinTokens.Size()))
	n24, err := m.JoinTokens.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	return i, nil
}

func (m *Certificate) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Certificate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Role))
	}
	if len(m.CSR) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.CSR)))
		i += copy(data[i:], m.CSR)
	}
	data[i] = 0x1a
	i++
	i = encodeVarintTypes(data, i, uint64(m.Status.Size()))
	n25, err := m.Status.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	if len(m.Certificate) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Certificate)))
		i += copy(data[i:], m.Certificate)
	}
	if len(m.CN) > 0 {
		data[i] = 0x2a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.CN)))
		i += copy(data[i:], m.CN)
	}
	return i, nil
}

func (m *EncryptionKey) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *EncryptionKey) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Subsystem) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Subsystem)))
		i += copy(data[i:], m.Subsystem)
	}
	if m.Algorithm != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Algorithm))
	}
	if len(m.Key) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Key)))
		i += copy(data[i:], m.Key)
	}
	if m.LamportTime != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintTypes(data, i, uint64(m.LamportTime))
	}
	return i, nil
}

func (m *ManagerStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ManagerStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.RaftID))
	}
	if len(m.Addr) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Addr)))
		i += copy(data[i:], m.Addr)
	}
	if m.Leader {
		data[i] = 0x18
		i++
		if m.Leader {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Reachability != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintTypes(data, i, uint64(m.Reachability))
	}
	return i, nil
}

func encodeFixed64Types(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Types(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintTypes(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

func (m *Version) Size() (n int) {
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovTypes(uint64(m.Index))
	}
	return n
}

func (m *Annotations) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Resources) Size() (n int) {
	var l int
	_ = l
	if m.NanoCPUs != 0 {
		n += 1 + sovTypes(uint64(m.NanoCPUs))
	}
	if m.MemoryBytes != 0 {
		n += 1 + sovTypes(uint64(m.MemoryBytes))
	}
	return n
}

func (m *ResourceRequirements) Size() (n int) {
	var l int
	_ = l
	if m.Limits != nil {
		l = m.Limits.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Reservations != nil {
		l = m.Reservations.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Platform) Size() (n int) {
	var l int
	_ = l
	l = len(m.Architecture)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.OS)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *PluginDescription) Size() (n int) {
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *EngineDescription) Size() (n int) {
	var l int
	_ = l
	l = len(m.EngineVersion)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	if len(m.Plugins) > 0 {
		for _, e := range m.Plugins {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *NodeDescription) Size() (n int) {
	var l int
	_ = l
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Platform != nil {
		l = m.Platform.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Engine != nil {
		l = m.Engine.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RaftMemberStatus) Size() (n int) {
	var l int
	_ = l
	if m.Leader {
		n += 2
	}
	if m.Reachability != 0 {
		n += 1 + sovTypes(uint64(m.Reachability))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *NodeStatus) Size() (n int) {
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Image) Size() (n int) {
	var l int
	_ = l
	l = len(m.Reference)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Mount) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovTypes(uint64(m.Type))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Target)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.ReadOnly {
		n += 2
	}
	if m.BindOptions != nil {
		l = m.BindOptions.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.VolumeOptions != nil {
		l = m.VolumeOptions.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.TmpfsOptions != nil {
		l = m.TmpfsOptions.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Mount_BindOptions) Size() (n int) {
	var l int
	_ = l
	if m.Propagation != 0 {
		n += 1 + sovTypes(uint64(m.Propagation))
	}
	return n
}

func (m *Mount_VolumeOptions) Size() (n int) {
	var l int
	_ = l
	if m.NoCopy {
		n += 2
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	if m.DriverConfig != nil {
		l = m.DriverConfig.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Mount_TmpfsOptions) Size() (n int) {
	var l int
	_ = l
	if m.SizeBytes != 0 {
		n += 1 + sovTypes(uint64(m.SizeBytes))
	}
	if m.Mode != 0 {
		n += 1 + sovTypes(uint64(m.Mode))
	}
	return n
}

func (m *RestartPolicy) Size() (n int) {
	var l int
	_ = l
	if m.Condition != 0 {
		n += 1 + sovTypes(uint64(m.Condition))
	}
	if m.Delay != nil {
		l = m.Delay.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.MaxAttempts != 0 {
		n += 1 + sovTypes(uint64(m.MaxAttempts))
	}
	if m.Window != nil {
		l = m.Window.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *UpdateConfig) Size() (n int) {
	var l int
	_ = l
	if m.Parallelism != 0 {
		n += 1 + sovTypes(uint64(m.Parallelism))
	}
	l = m.Delay.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.FailureAction != 0 {
		n += 1 + sovTypes(uint64(m.FailureAction))
	}
	return n
}

func (m *UpdateStatus) Size() (n int) {
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	if m.StartedAt != nil {
		l = m.StartedAt.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.CompletedAt != nil {
		l = m.CompletedAt.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *ContainerStatus) Size() (n int) {
	var l int
	_ = l
	l = len(m.ContainerID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.PID != 0 {
		n += 1 + sovTypes(uint64(m.PID))
	}
	if m.ExitCode != 0 {
		n += 1 + sovTypes(uint64(m.ExitCode))
	}
	return n
}

func (m *TaskStatus) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Err)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.RuntimeStatus != nil {
		n += m.RuntimeStatus.Size()
	}
	return n
}

func (m *TaskStatus_Container) Size() (n int) {
	var l int
	_ = l
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *IPAMConfig) Size() (n int) {
	var l int
	_ = l
	if m.Family != 0 {
		n += 1 + sovTypes(uint64(m.Family))
	}
	l = len(m.Subnet)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Range)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Gateway)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Reserved) > 0 {
		for k, v := range m.Reserved {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *PortConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Protocol != 0 {
		n += 1 + sovTypes(uint64(m.Protocol))
	}
	if m.TargetPort != 0 {
		n += 1 + sovTypes(uint64(m.TargetPort))
	}
	if m.PublishedPort != 0 {
		n += 1 + sovTypes(uint64(m.PublishedPort))
	}
	return n
}

func (m *Driver) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Options) > 0 {
		for k, v := range m.Options {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *IPAMOptions) Size() (n int) {
	var l int
	_ = l
	if m.Driver != nil {
		l = m.Driver.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Configs) > 0 {
		for _, e := range m.Configs {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *Peer) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *WeightedPeer) Size() (n int) {
	var l int
	_ = l
	if m.Peer != nil {
		l = m.Peer.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Weight != 0 {
		n += 1 + sovTypes(uint64(m.Weight))
	}
	return n
}

func (m *IssuanceStatus) Size() (n int) {
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	l = len(m.Err)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *AcceptancePolicy) Size() (n int) {
	var l int
	_ = l
	if len(m.Policies) > 0 {
		for _, e := range m.Policies {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *AcceptancePolicy_RoleAdmissionPolicy) Size() (n int) {
	var l int
	_ = l
	if m.Role != 0 {
		n += 1 + sovTypes(uint64(m.Role))
	}
	if m.Autoaccept {
		n += 2
	}
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Size() (n int) {
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Alg)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *ExternalCA) Size() (n int) {
	var l int
	_ = l
	if m.Protocol != 0 {
		n += 1 + sovTypes(uint64(m.Protocol))
	}
	l = len(m.URL)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Options) > 0 {
		for k, v := range m.Options {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CAConfig) Size() (n int) {
	var l int
	_ = l
	if m.NodeCertExpiry != nil {
		l = m.NodeCertExpiry.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.ExternalCAs) > 0 {
		for _, e := range m.ExternalCAs {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *OrchestrationConfig) Size() (n int) {
	var l int
	_ = l
	if m.TaskHistoryRetentionLimit != 0 {
		n += 1 + sovTypes(uint64(m.TaskHistoryRetentionLimit))
	}
	return n
}

func (m *TaskDefaults) Size() (n int) {
	var l int
	_ = l
	if m.LogDriver != nil {
		l = m.LogDriver.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *DispatcherConfig) Size() (n int) {
	var l int
	_ = l
	if m.HeartbeatPeriod != nil {
		l = m.HeartbeatPeriod.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RaftConfig) Size() (n int) {
	var l int
	_ = l
	if m.SnapshotInterval != 0 {
		n += 1 + sovTypes(uint64(m.SnapshotInterval))
	}
	if m.KeepOldSnapshots != 0 {
		n += 1 + sovTypes(uint64(m.KeepOldSnapshots))
	}
	if m.LogEntriesForSlowFollowers != 0 {
		n += 1 + sovTypes(uint64(m.LogEntriesForSlowFollowers))
	}
	if m.HeartbeatTick != 0 {
		n += 1 + sovTypes(uint64(m.HeartbeatTick))
	}
	if m.ElectionTick != 0 {
		n += 1 + sovTypes(uint64(m.ElectionTick))
	}
	return n
}

func (m *Placement) Size() (n int) {
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, s := range m.Constraints {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *JoinTokens) Size() (n int) {
	var l int
	_ = l
	l = len(m.Worker)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Manager)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RootCA) Size() (n int) {
	var l int
	_ = l
	l = len(m.CAKey)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CACert)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CACertHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.JoinTokens.Size()
	n += 1 + l + sovTypes(uint64(l))
	return n
}

func (m *Certificate) Size() (n int) {
	var l int
	_ = l
	if m.Role != 0 {
		n += 1 + sovTypes(uint64(m.Role))
	}
	l = len(m.CSR)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Status.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.Certificate)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CN)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *EncryptionKey) Size() (n int) {
	var l int
	_ = l
	l = len(m.Subsystem)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Algorithm != 0 {
		n += 1 + sovTypes(uint64(m.Algorithm))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.LamportTime != 0 {
		n += 1 + sovTypes(uint64(m.LamportTime))
	}
	return n
}

func (m *ManagerStatus) Size() (n int) {
	var l int
	_ = l
	if m.RaftID != 0 {
		n += 1 + sovTypes(uint64(m.RaftID))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Leader {
		n += 2
	}
	if m.Reachability != 0 {
		n += 1 + sovTypes(uint64(m.Reachability))
	}
	return n
}

func sovTypes(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTypes(x uint64) (n int) {
	return sovTypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Version) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Version{`,
		`Index:` + fmt.Sprintf("%v", this.Index) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Annotations) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	s := strings.Join([]string{`&Annotations{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resources) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resources{`,
		`NanoCPUs:` + fmt.Sprintf("%v", this.NanoCPUs) + `,`,
		`MemoryBytes:` + fmt.Sprintf("%v", this.MemoryBytes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceRequirements) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceRequirements{`,
		`Limits:` + strings.Replace(fmt.Sprintf("%v", this.Limits), "Resources", "Resources", 1) + `,`,
		`Reservations:` + strings.Replace(fmt.Sprintf("%v", this.Reservations), "Resources", "Resources", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Platform) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Platform{`,
		`Architecture:` + fmt.Sprintf("%v", this.Architecture) + `,`,
		`OS:` + fmt.Sprintf("%v", this.OS) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PluginDescription) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PluginDescription{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EngineDescription) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	s := strings.Join([]string{`&EngineDescription{`,
		`EngineVersion:` + fmt.Sprintf("%v", this.EngineVersion) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Plugins:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Plugins), "PluginDescription", "PluginDescription", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeDescription) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeDescription{`,
		`Hostname:` + fmt.Sprintf("%v", this.Hostname) + `,`,
		`Platform:` + strings.Replace(fmt.Sprintf("%v", this.Platform), "Platform", "Platform", 1) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resources", "Resources", 1) + `,`,
		`Engine:` + strings.Replace(fmt.Sprintf("%v", this.Engine), "EngineDescription", "EngineDescription", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RaftMemberStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RaftMemberStatus{`,
		`Leader:` + fmt.Sprintf("%v", this.Leader) + `,`,
		`Reachability:` + fmt.Sprintf("%v", this.Reachability) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeStatus{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Image) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Image{`,
		`Reference:` + fmt.Sprintf("%v", this.Reference) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mount{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`Target:` + fmt.Sprintf("%v", this.Target) + `,`,
		`ReadOnly:` + fmt.Sprintf("%v", this.ReadOnly) + `,`,
		`BindOptions:` + strings.Replace(fmt.Sprintf("%v", this.BindOptions), "Mount_BindOptions", "Mount_BindOptions", 1) + `,`,
		`VolumeOptions:` + strings.Replace(fmt.Sprintf("%v", this.VolumeOptions), "Mount_VolumeOptions", "Mount_VolumeOptions", 1) + `,`,
		`TmpfsOptions:` + strings.Replace(fmt.Sprintf("%v", this.TmpfsOptions), "Mount_TmpfsOptions", "Mount_TmpfsOptions", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount_BindOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mount_BindOptions{`,
		`Propagation:` + fmt.Sprintf("%v", this.Propagation) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount_VolumeOptions) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	s := strings.Join([]string{`&Mount_VolumeOptions{`,
		`NoCopy:` + fmt.Sprintf("%v", this.NoCopy) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`DriverConfig:` + strings.Replace(fmt.Sprintf("%v", this.DriverConfig), "Driver", "Driver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount_TmpfsOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mount_TmpfsOptions{`,
		`SizeBytes:` + fmt.Sprintf("%v", this.SizeBytes) + `,`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RestartPolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RestartPolicy{`,
		`Condition:` + fmt.Sprintf("%v", this.Condition) + `,`,
		`Delay:` + strings.Replace(fmt.Sprintf("%v", this.Delay), "Duration", "docker_swarmkit_v11.Duration", 1) + `,`,
		`MaxAttempts:` + fmt.Sprintf("%v", this.MaxAttempts) + `,`,
		`Window:` + strings.Replace(fmt.Sprintf("%v", this.Window), "Duration", "docker_swarmkit_v11.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateConfig{`,
		`Parallelism:` + fmt.Sprintf("%v", this.Parallelism) + `,`,
		`Delay:` + strings.Replace(strings.Replace(this.Delay.String(), "Duration", "docker_swarmkit_v11.Duration", 1), `&`, ``, 1) + `,`,
		`FailureAction:` + fmt.Sprintf("%v", this.FailureAction) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateStatus{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`StartedAt:` + strings.Replace(fmt.Sprintf("%v", this.StartedAt), "Timestamp", "docker_swarmkit_v1.Timestamp", 1) + `,`,
		`CompletedAt:` + strings.Replace(fmt.Sprintf("%v", this.CompletedAt), "Timestamp", "docker_swarmkit_v1.Timestamp", 1) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerStatus{`,
		`ContainerID:` + fmt.Sprintf("%v", this.ContainerID) + `,`,
		`PID:` + fmt.Sprintf("%v", this.PID) + `,`,
		`ExitCode:` + fmt.Sprintf("%v", this.ExitCode) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskStatus{`,
		`Timestamp:` + strings.Replace(fmt.Sprintf("%v", this.Timestamp), "Timestamp", "docker_swarmkit_v1.Timestamp", 1) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`Err:` + fmt.Sprintf("%v", this.Err) + `,`,
		`RuntimeStatus:` + fmt.Sprintf("%v", this.RuntimeStatus) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskStatus_Container) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskStatus_Container{`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "ContainerStatus", "ContainerStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IPAMConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForReserved := make([]string, 0, len(this.Reserved))
	for k, _ := range this.Reserved {
		keysForReserved = append(keysForReserved, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForReserved)
	mapStringForReserved := "map[string]string{"
	for _, k := range keysForReserved {
		mapStringForReserved += fmt.Sprintf("%v: %v,", k, this.Reserved[k])
	}
	mapStringForReserved += "}"
	s := strings.Join([]string{`&IPAMConfig{`,
		`Family:` + fmt.Sprintf("%v", this.Family) + `,`,
		`Subnet:` + fmt.Sprintf("%v", this.Subnet) + `,`,
		`Range:` + fmt.Sprintf("%v", this.Range) + `,`,
		`Gateway:` + fmt.Sprintf("%v", this.Gateway) + `,`,
		`Reserved:` + mapStringForReserved + `,`,
		`}`,
	}, "")
	return s
}
func (this *PortConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PortConfig{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`TargetPort:` + fmt.Sprintf("%v", this.TargetPort) + `,`,
		`PublishedPort:` + fmt.Sprintf("%v", this.PublishedPort) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Driver) String() string {
	if this == nil {
		return "nil"
	}
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%v: %v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	s := strings.Join([]string{`&Driver{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Options:` + mapStringForOptions + `,`,
		`}`,
	}, "")
	return s
}
func (this *IPAMOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IPAMOptions{`,
		`Driver:` + strings.Replace(fmt.Sprintf("%v", this.Driver), "Driver", "Driver", 1) + `,`,
		`Configs:` + strings.Replace(fmt.Sprintf("%v", this.Configs), "IPAMConfig", "IPAMConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Peer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Peer{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WeightedPeer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WeightedPeer{`,
		`Peer:` + strings.Replace(fmt.Sprintf("%v", this.Peer), "Peer", "Peer", 1) + `,`,
		`Weight:` + fmt.Sprintf("%v", this.Weight) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IssuanceStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IssuanceStatus{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Err:` + fmt.Sprintf("%v", this.Err) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AcceptancePolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AcceptancePolicy{`,
		`Policies:` + strings.Replace(fmt.Sprintf("%v", this.Policies), "AcceptancePolicy_RoleAdmissionPolicy", "AcceptancePolicy_RoleAdmissionPolicy", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AcceptancePolicy_RoleAdmissionPolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AcceptancePolicy_RoleAdmissionPolicy{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`Autoaccept:` + fmt.Sprintf("%v", this.Autoaccept) + `,`,
		`Secret:` + strings.Replace(fmt.Sprintf("%v", this.Secret), "AcceptancePolicy_RoleAdmissionPolicy_Secret", "AcceptancePolicy_RoleAdmissionPolicy_Secret", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AcceptancePolicy_RoleAdmissionPolicy_Secret) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AcceptancePolicy_RoleAdmissionPolicy_Secret{`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Alg:` + fmt.Sprintf("%v", this.Alg) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExternalCA) String() string {
	if this == nil {
		return "nil"
	}
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%v: %v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	s := strings.Join([]string{`&ExternalCA{`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`URL:` + fmt.Sprintf("%v", this.URL) + `,`,
		`Options:` + mapStringForOptions + `,`,
		`}`,
	}, "")
	return s
}
func (this *CAConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CAConfig{`,
		`NodeCertExpiry:` + strings.Replace(fmt.Sprintf("%v", this.NodeCertExpiry), "Duration", "docker_swarmkit_v11.Duration", 1) + `,`,
		`ExternalCAs:` + strings.Replace(fmt.Sprintf("%v", this.ExternalCAs), "ExternalCA", "ExternalCA", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OrchestrationConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OrchestrationConfig{`,
		`TaskHistoryRetentionLimit:` + fmt.Sprintf("%v", this.TaskHistoryRetentionLimit) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskDefaults) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskDefaults{`,
		`LogDriver:` + strings.Replace(fmt.Sprintf("%v", this.LogDriver), "Driver", "Driver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DispatcherConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DispatcherConfig{`,
		`HeartbeatPeriod:` + strings.Replace(fmt.Sprintf("%v", this.HeartbeatPeriod), "Duration", "docker_swarmkit_v11.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RaftConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RaftConfig{`,
		`SnapshotInterval:` + fmt.Sprintf("%v", this.SnapshotInterval) + `,`,
		`KeepOldSnapshots:` + fmt.Sprintf("%v", this.KeepOldSnapshots) + `,`,
		`LogEntriesForSlowFollowers:` + fmt.Sprintf("%v", this.LogEntriesForSlowFollowers) + `,`,
		`HeartbeatTick:` + fmt.Sprintf("%v", this.HeartbeatTick) + `,`,
		`ElectionTick:` + fmt.Sprintf("%v", this.ElectionTick) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Placement) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Placement{`,
		`Constraints:` + fmt.Sprintf("%v", this.Constraints) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinTokens) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JoinTokens{`,
		`Worker:` + fmt.Sprintf("%v", this.Worker) + `,`,
		`Manager:` + fmt.Sprintf("%v", this.Manager) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RootCA) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RootCA{`,
		`CAKey:` + fmt.Sprintf("%v", this.CAKey) + `,`,
		`CACert:` + fmt.Sprintf("%v", this.CACert) + `,`,
		`CACertHash:` + fmt.Sprintf("%v", this.CACertHash) + `,`,
		`JoinTokens:` + strings.Replace(strings.Replace(this.JoinTokens.String(), "JoinTokens", "JoinTokens", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Certificate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Certificate{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`CSR:` + fmt.Sprintf("%v", this.CSR) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "IssuanceStatus", "IssuanceStatus", 1), `&`, ``, 1) + `,`,
		`Certificate:` + fmt.Sprintf("%v", this.Certificate) + `,`,
		`CN:` + fmt.Sprintf("%v", this.CN) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EncryptionKey) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EncryptionKey{`,
		`Subsystem:` + fmt.Sprintf("%v", this.Subsystem) + `,`,
		`Algorithm:` + fmt.Sprintf("%v", this.Algorithm) + `,`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`LamportTime:` + fmt.Sprintf("%v", this.LamportTime) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ManagerStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ManagerStatus{`,
		`RaftID:` + fmt.Sprintf("%v", this.RaftID) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`Leader:` + fmt.Sprintf("%v", this.Leader) + `,`,
		`Reachability:` + fmt.Sprintf("%v", this.Reachability) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTypes(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Version) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Version: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Version: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Index |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Annotations) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Annotations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Annotations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resources) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NanoCPUs", wireType)
			}
			m.NanoCPUs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.NanoCPUs |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryBytes", wireType)
			}
			m.MemoryBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.MemoryBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceRequirements) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceRequirements: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceRequirements: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limits == nil {
				m.Limits = &Resources{}
			}
			if err := m.Limits.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reservations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reservations == nil {
				m.Reservations = &Resources{}
			}
			if err := m.Reservations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Platform) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Platform: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Platform: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Architecture", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Architecture = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OS", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OS = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PluginDescription) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PluginDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PluginDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EngineDescription) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EngineDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EngineDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EngineVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EngineVersion = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Plugins", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Plugins = append(m.Plugins, PluginDescription{})
			if err := m.Plugins[len(m.Plugins)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeDescription) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Platform == nil {
				m.Platform = &Platform{}
			}
			if err := m.Platform.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &Resources{}
			}
			if err := m.Resources.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Engine", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Engine == nil {
				m.Engine = &EngineDescription{}
			}
			if err := m.Engine.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftMemberStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMemberStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMemberStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Leader = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reachability", wireType)
			}
			m.Reachability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Reachability |= (RaftMemberStatus_Reachability(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.State |= (NodeStatus_State(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Image) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Image: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Image: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reference", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reference = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mount: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mount: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Type |= (Mount_MountType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Target = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReadOnly = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BindOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BindOptions == nil {
				m.BindOptions = &Mount_BindOptions{}
			}
			if err := m.BindOptions.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VolumeOptions == nil {
				m.VolumeOptions = &Mount_VolumeOptions{}
			}
			if err := m.VolumeOptions.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TmpfsOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TmpfsOptions == nil {
				m.TmpfsOptions = &Mount_TmpfsOptions{}
			}
			if err := m.TmpfsOptions.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount_BindOptions) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BindOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BindOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Propagation", wireType)
			}
			m.Propagation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Propagation |= (Mount_BindOptions_MountPropagation(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount_VolumeOptions) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VolumeOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VolumeOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoCopy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoCopy = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverConfig == nil {
				m.DriverConfig = &Driver{}
			}
			if err := m.DriverConfig.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount_TmpfsOptions) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TmpfsOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TmpfsOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeBytes", wireType)
			}
			m.SizeBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.SizeBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Mode |= (os.FileMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RestartPolicy) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RestartPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RestartPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Condition", wireType)
			}
			m.Condition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Condition |= (RestartPolicy_RestartCondition(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Delay == nil {
				m.Delay = &docker_swarmkit_v11.Duration{}
			}
			if err := m.Delay.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAttempts", wireType)
			}
			m.MaxAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.MaxAttempts |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Window", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Window == nil {
				m.Window = &docker_swarmkit_v11.Duration{}
			}
			if err := m.Window.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parallelism", wireType)
			}
			m.Parallelism = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Parallelism |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Delay.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailureAction", wireType)
			}
			m.FailureAction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.FailureAction |= (UpdateConfig_FailureAction(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.State |= (UpdateStatus_UpdateState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedAt == nil {
				m.StartedAt = &docker_swarmkit_v1.Timestamp{}
			}
			if err := m.StartedAt.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletedAt == nil {
				m.CompletedAt = &docker_swarmkit_v1.Timestamp{}
			}
			if err := m.CompletedAt.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PID", wireType)
			}
			m.PID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.PID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExitCode", wireType)
			}
			m.ExitCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ExitCode |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &docker_swarmkit_v1.Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.State |= (TaskState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Err", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Err = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ContainerStatus{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.RuntimeStatus = &TaskStatus_Container{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPAMConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAMConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAMConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Family", wireType)
			}
			m.Family = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Family |= (IPAMConfig_AddressFamily(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subnet", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subnet = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Range", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Range = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateway", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateway = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reserved", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Reserved == nil {
				m.Reserved = make(map[string]string)
			}
			m.Reserved[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PortConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Protocol |= (PortConfig_Protocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetPort", wireType)
			}
			m.TargetPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.TargetPort |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublishedPort", wireType)
			}
			m.PublishedPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.PublishedPort |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Driver) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Driver: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Driver: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Options == nil {
				m.Options = make(map[string]string)
			}
			m.Options[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPAMOptions) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAMOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAMOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Driver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Driver == nil {
				m.Driver = &Driver{}
			}
			if err := m.Driver.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Configs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Configs = append(m.Configs, &IPAMConfig{})
			if err := m.Configs[len(m.Configs)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Peer) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Peer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Peer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WeightedPeer) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WeightedPeer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WeightedPeer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Peer == nil {
				m.Peer = &Peer{}
			}
			if err := m.Peer.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Weight |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IssuanceStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IssuanceStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IssuanceStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.State |= (IssuanceStatus_State(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Err", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Err = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AcceptancePolicy) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AcceptancePolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AcceptancePolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Policies = append(m.Policies, &AcceptancePolicy_RoleAdmissionPolicy{})
			if err := m.Policies[len(m.Policies)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AcceptancePolicy_RoleAdmissionPolicy) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleAdmissionPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleAdmissionPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Role |= (NodeRole(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Autoaccept", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Autoaccept = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Secret == nil {
				m.Secret = &AcceptancePolicy_RoleAdmissionPolicy_Secret{}
			}
			if err := m.Secret.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AcceptancePolicy_RoleAdmissionPolicy_Secret) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Secret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Secret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], data[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alg = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalCA) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalCA: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalCA: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Protocol |= (ExternalCA_CAProtocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URL = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Options == nil {
				m.Options = make(map[string]string)
			}
			m.Options[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CAConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CAConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CAConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCertExpiry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeCertExpiry == nil {
				m.NodeCertExpiry = &docker_swarmkit_v11.Duration{}
			}
			if err := m.NodeCertExpiry.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalCAs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExternalCAs = append(m.ExternalCAs, &ExternalCA{})
			if err := m.ExternalCAs[len(m.ExternalCAs)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrchestrationConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrchestrationConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrchestrationConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskHistoryRetentionLimit", wireType)
			}
			m.TaskHistoryRetentionLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.TaskHistoryRetentionLimit |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskDefaults) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskDefaults: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskDefaults: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogDriver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LogDriver == nil {
				m.LogDriver = &Driver{}
			}
			if err := m.LogDriver.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DispatcherConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DispatcherConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DispatcherConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatPeriod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatPeriod == nil {
				m.HeartbeatPeriod = &docker_swarmkit_v11.Duration{}
			}
			if err := m.HeartbeatPeriod.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftConfig) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotInterval", wireType)
			}
			m.SnapshotInterval = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.SnapshotInterval |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepOldSnapshots", wireType)
			}
			m.KeepOldSnapshots = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.KeepOldSnapshots |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogEntriesForSlowFollowers", wireType)
			}
			m.LogEntriesForSlowFollowers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.LogEntriesForSlowFollowers |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTick", wireType)
			}
			m.HeartbeatTick = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.HeartbeatTick |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ElectionTick", wireType)
			}
			m.ElectionTick = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ElectionTick |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Placement) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Placement: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Placement: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinTokens) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinTokens: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinTokens: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Worker", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Worker = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manager", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Manager = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RootCA) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RootCA: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RootCA: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CAKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CAKey = append(m.CAKey[:0], data[iNdEx:postIndex]...)
			if m.CAKey == nil {
				m.CAKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CACert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CACert = append(m.CACert[:0], data[iNdEx:postIndex]...)
			if m.CACert == nil {
				m.CACert = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CACertHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CACertHash = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JoinTokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.JoinTokens.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Certificate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Certificate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Certificate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Role |= (NodeRole(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CSR", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CSR = append(m.CSR[:0], data[iNdEx:postIndex]...)
			if m.CSR == nil {
				m.CSR = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificate", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Certificate = append(m.Certificate[:0], data[iNdEx:postIndex]...)
			if m.Certificate == nil {
				m.Certificate = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CN", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CN = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncryptionKey) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptionKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptionKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsystem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subsystem = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Algorithm", wireType)
			}
			m.Algorithm = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Algorithm |= (EncryptionKey_Algorithm(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], data[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LamportTime", wireType)
			}
			m.LamportTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.LamportTime |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManagerStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManagerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManagerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftID", wireType)
			}
			m.RaftID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.RaftID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Leader = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reachability", wireType)
			}
			m.Reachability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Reachability |= (RaftMemberStatus_Reachability(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTypes(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTypes = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorTypes = []byte{
	// 3349 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x59, 0x4d, 0x6c, 0x1b, 0xd7,
	0x11, 0x36, 0x7f, 0x45, 0x0e, 0x49, 0x99, 0x5e, 0x3b, 0x8e, 0xcc, 0x38, 0xb2, 0xb3, 0x89, 0x13,
	0xe7, 0xa7, 0x4c, 0xac, 0xa4, 0x85, 0x93, 0xb4, 0x71, 0x96, 0x3f, 0xb2, 0x19, 0x4b, 0x14, 0xf1,
	0x28, 0xca, 0x08, 0x0a, 0x94, 0x58, 0x91, 0x4f, 0xe2, 0x46, 0xcb, 0x5d, 0x76, 0x77, 0x29, 0x99,
	0x2d, 0x0a, 0xb8, 0xbd, 0xb4, 0xc8, 0xa9, 0xf7, 0x22, 0x08, 0x8a, 0x16, 0xbd, 0xf5, 0xd0, 0x53,
	0x81, 0x9e, 0x7c, 0xf4, 0x31, 0x45, 0x81, 0x22, 0x68, 0x81, 0xa0, 0x49, 0x8f, 0xbd, 0x04, 0xe8,
	0x21, 0x87, 0xf6, 0xd0, 0x79, 0x3f, 0xfb, 0x43, 0x7a, 0xad, 0x28, 0x4d, 0x0e, 0x82, 0xf6, 0xcd,
	0xfb, 0x66, 0xde, 0xdf, 0xbc, 0x99, 0x6f, 0x1e, 0xa1, 0xe0, 0xcd, 0x26, 0xd4, 0xad, 0x4e, 0x1c,
	0xdb, 0xb3, 0x15, 0x65, 0x68, 0x0f, 0x0e, 0xa8, 0x53, 0x75, 0x8f, 0x74, 0x67, 0x7c, 0x60, 0x78,
	0xd5, 0xc3, 0x6b, 0x95, 0x0b, 0x9e, 0x31, 0xa6, 0xae, 0xa7, 0x8f, 0x27, 0x2f, 0x07, 0x5f, 0x02,
	0x5e, 0x79, 0x7c, 0x38, 0x75, 0x74, 0xcf, 0xb0, 0xad, 0x97, 0xfd, 0x0f, 0xd9, 0x71, 0x6e, 0xdf,
	0xde, 0xb7, 0xf9, 0xe7, 0xcb, 0xec, 0x4b, 0x48, 0xd5, 0x4b, 0xb0, 0xb4, 0x43, 0x1d, 0x17, 0x61,
	0xca, 0x39, 0xc8, 0x18, 0xd6, 0x90, 0xde, 0x5d, 0x49, 0x5c, 0x4e, 0x5c, 0x4d, 0x13, 0xd1, 0x50,
	0x7f, 0x9d, 0x80, 0x82, 0x66, 0x59, 0xb6, 0xc7, 0x6d, 0xb9, 0x8a, 0x02, 0x69, 0x4b, 0x1f, 0x53,
	0x0e, 0xca, 0x13, 0xfe, 0xad, 0xd4, 0x21, 0x6b, 0xea, 0xbb, 0xd4, 0x74, 0x57, 0x92, 0x97, 0x53,
	0x57, 0x0b, 0x6b, 0x2f, 0x56, 0x1f, 0x9e, 0x73, 0x35, 0x62, 0xa4, 0xba, 0xc1, 0xd1, 0x4d, 0xcb,
	0x73, 0x66, 0x44, 0xaa, 0x56, 0x5e, 0x87, 0x42, 0x44, 0xac, 0x94, 0x21, 0x75, 0x40, 0x67, 0x72,
	0x18, 0xf6, 0xc9, 0xe6, 0x77, 0xa8, 0x9b, 0x53, 0x8a, 0x83, 0x30, 0x99, 0x68, 0xbc, 0x91, 0xbc,
	0x9e, 0x50, 0xdf, 0x85, 0x3c, 0xa1, 0xae, 0x3d, 0x75, 0x06, 0xd4, 0x55, 0x9e, 0x87, 0xbc, 0xa5,
	0x5b, 0x76, 0x7f, 0x30, 0x99, 0xba, 0x5c, 0x3d, 0x55, 0x2b, 0x7e, 0xf6, 0xc9, 0xa5, 0x5c, 0x1b,
	0x85, 0xf5, 0x4e, 0xcf, 0x25, 0x39, 0xd6, 0x5d, 0xc7, 0x5e, 0xe5, 0x29, 0x28, 0x8e, 0xe9, 0xd8,
	0x76, 0x66, 0xfd, 0xdd, 0x99, 0x47, 0x5d, 0x6e, 0x38, 0x45, 0x0a, 0x42, 0x56, 0x63, 0x22, 0xf5,
	0x97, 0x09, 0x38, 0xe7, 0xdb, 0x26, 0xf4, 0x87, 0x53, 0xc3, 0xa1, 0x63, 0x6a, 0x79, 0xae, 0xf2,
	0x6d, 0x5c, 0xb3, 0x31, 0x36, 0x3c, 0x31, 0x46, 0x61, 0xed, 0xc9, 0xb8, 0x35, 0x07, 0xb3, 0x22,
	0x12, 0xac, 0x68, 0x50, 0x74, 0xa8, 0x4b, 0x9d, 0x43, 0xb1, 0x13, 0x7c, 0xc8, 0x2f, 0x55, 0x9e,
	0x53, 0x51, 0xd7, 0x21, 0xd7, 0x31, 0x75, 0x6f, 0xcf, 0x76, 0xc6, 0x8a, 0x0a, 0x45, 0xdd, 0x19,
	0x8c, 0x0c, 0x8f, 0x0e, 0xbc, 0xa9, 0xe3, 0x9f, 0xca, 0x9c, 0x4c, 0x39, 0x0f, 0x49, 0x5b, 0x0c,
	0x94, 0xaf, 0x65, 0x71, 0x27, 0x92, 0x5b, 0x5d, 0x82, 0x12, 0xf5, 0x4d, 0x38, 0xd3, 0x31, 0xa7,
	0xfb, 0x86, 0xd5, 0xa0, 0xee, 0xc0, 0x31, 0x26, 0xcc, 0x3a, 0x3b, 0x5e, 0xe6, 0x7c, 0xfe, 0xf1,
	0xb2, 0xef, 0xe0, 0xc8, 0x93, 0xe1, 0x91, 0xab, 0x3f, 0x4f, 0xc2, 0x99, 0xa6, 0x85, 0xca, 0x34,
	0xaa, 0x7d, 0x05, 0x96, 0x29, 0x17, 0xf6, 0x0f, 0x85, 0x53, 0x49, 0x3b, 0x25, 0x21, 0xf5, 0x3d,
	0xad, 0xb5, 0xe0, 0x2f, 0xd7, 0xe2, 0x96, 0xff, 0x90, 0xf5, 0x38, 0xaf, 0x51, 0x9a, 0xb0, 0x34,
	0xe1, 0x8b, 0x70, 0x57, 0x52, 0xdc, 0xd6, 0x95, 0x38, 0x5b, 0x0f, 0xad, 0xb3, 0x96, 0x7e, 0xf0,
	0xc9, 0xa5, 0x53, 0xc4, 0xd7, 0xfd, 0x3a, 0xce, 0xf7, 0xcf, 0x04, 0x9c, 0x6e, 0xdb, 0xc3, 0xb9,
	0x7d, 0xa8, 0x40, 0x6e, 0x64, 0xbb, 0x5e, 0xe4, 0xa2, 0x04, 0x6d, 0xe5, 0x3a, 0xe4, 0x26, 0xf2,
	0xf8, 0xe4, 0xe9, 0x5f, 0x8c, 0x9f, 0xb2, 0xc0, 0x90, 0x00, 0xad, 0xbc, 0x09, 0x79, 0xc7, 0xf7,
	0x09, 0x5c, 0xed, 0x09, 0x1c, 0x27, 0xc4, 0x2b, 0xdf, 0x83, 0xac, 0x38, 0x84, 0x95, 0x34, 0xd7,
	0xbc, 0x72, 0xa2, 0x3d, 0x27, 0x52, 0x49, 0xfd, 0x38, 0x01, 0x65, 0xa2, 0xef, 0x79, 0x9b, 0x74,
	0xbc, 0x4b, 0x9d, 0x2e, 0x5e, 0x64, 0xbc, 0x3f, 0xe7, 0xf1, 0x1c, 0xa9, 0x3e, 0xa4, 0x0e, 0x5f,
	0x64, 0x8e, 0xc8, 0x96, 0xd2, 0x63, 0x4e, 0xae, 0x0f, 0x46, 0xfa, 0xae, 0x61, 0x1a, 0xde, 0x8c,
	0x2f, 0x73, 0x39, 0xfe, 0x94, 0x17, 0x6d, 0xe2, 0xe4, 0x43, 0x45, 0x32, 0x67, 0x46, 0x59, 0x81,
	0x25, 0x8c, 0x75, 0xae, 0xbe, 0x4f, 0xf9, 0xea, 0xf3, 0xc4, 0x6f, 0xa2, 0x2b, 0x17, 0xa3, 0x7a,
	0x4a, 0x01, 0x96, 0x7a, 0xed, 0xdb, 0xed, 0xad, 0x3b, 0xed, 0xf2, 0x29, 0xe5, 0x34, 0x14, 0x7a,
	0x6d, 0xd2, 0xd4, 0xea, 0xb7, 0xb4, 0xda, 0x46, 0xb3, 0x9c, 0x50, 0x4a, 0x18, 0x2e, 0x82, 0x66,
	0x52, 0xfd, 0x30, 0x01, 0xc0, 0x0e, 0x50, 0x2e, 0xea, 0x0d, 0xc8, 0x60, 0x3c, 0xf5, 0xc4, 0xc1,
	0x2d, 0xaf, 0x3d, 0x13, 0x37, 0xeb, 0x10, 0x5e, 0x65, 0xff, 0x28, 0x11, 0x2a, 0xd1, 0x19, 0x26,
	0x17, 0x67, 0x98, 0xe1, 0xc8, 0xf9, 0xa9, 0xe5, 0x20, 0xdd, 0x60, 0x5f, 0x09, 0x25, 0x0f, 0x19,
	0x9c, 0x53, 0xe3, 0xdd, 0x72, 0x12, 0x9d, 0xaf, 0xd8, 0x68, 0x75, 0xeb, 0x5b, 0xed, 0x76, 0xb3,
	0xbe, 0xdd, 0x6c, 0x94, 0x53, 0xea, 0x15, 0xc8, 0xb4, 0xc6, 0x68, 0x45, 0xb9, 0xc8, 0x3c, 0x60,
	0x8f, 0x3a, 0xd4, 0x1a, 0xf8, 0x8e, 0x15, 0x0a, 0xd4, 0x8f, 0xd0, 0xc8, 0xa6, 0x3d, 0xb5, 0x3c,
	0x65, 0x2d, 0x72, 0x8b, 0x97, 0xd7, 0x56, 0xe3, 0x96, 0xc0, 0x81, 0xd5, 0x6d, 0x44, 0xc9, 0x5b,
	0x8e, 0x87, 0x29, 0x7c, 0x45, 0x4e, 0x5d, 0xb6, 0x98, 0xdc, 0xd3, 0x9d, 0x7d, 0xea, 0xc9, 0x4d,
	0x97, 0x2d, 0xe5, 0x2a, 0xe4, 0xf0, 0x74, 0x86, 0xb6, 0x65, 0xce, 0xb8, 0x4b, 0xe5, 0x44, 0x98,
	0xc5, 0x73, 0x18, 0x6e, 0xa1, 0x8c, 0x04, 0xbd, 0xca, 0x2d, 0x28, 0xee, 0x62, 0x32, 0xe9, 0xdb,
	0x13, 0x11, 0xf3, 0x32, 0x8f, 0x76, 0x40, 0x31, 0xab, 0x1a, 0xa2, 0xb7, 0x04, 0x98, 0x14, 0x76,
	0xc3, 0x86, 0xd2, 0x86, 0xe5, 0x43, 0xdb, 0x9c, 0x8e, 0x69, 0x60, 0x2b, 0xcb, 0x6d, 0x3d, 0xf7,
	0x68, 0x5b, 0x3b, 0x1c, 0xef, 0x5b, 0x2b, 0x1d, 0x46, 0x9b, 0xca, 0x6d, 0x28, 0x79, 0xe3, 0xc9,
	0x9e, 0x1b, 0x98, 0x5b, 0xe2, 0xe6, 0x9e, 0x3d, 0x66, 0xc3, 0x18, 0xdc, 0xb7, 0x56, 0xf4, 0x22,
	0xad, 0xca, 0xcf, 0x52, 0x50, 0x88, 0xcc, 0x5c, 0xe9, 0x42, 0x01, 0x73, 0xec, 0x44, 0xdf, 0xe7,
	0x71, 0x5b, 0x9e, 0xc5, 0xb5, 0x13, 0xad, 0xba, 0xda, 0x09, 0x15, 0x49, 0xd4, 0x8a, 0xfa, 0x41,
	0x12, 0x0a, 0x91, 0x4e, 0xe5, 0x05, 0xc8, 0x91, 0x0e, 0x69, 0xed, 0x68, 0xdb, 0xcd, 0xf2, 0xa9,
	0xca, 0xc5, 0xf7, 0x3f, 0xb8, 0xbc, 0xc2, 0xad, 0x45, 0x0d, 0x74, 0x1c, 0xe3, 0x90, 0xb9, 0xde,
	0x55, 0x58, 0xf2, 0xa1, 0x89, 0xca, 0x13, 0x08, 0x7d, 0x7c, 0x11, 0x1a, 0x41, 0x92, 0xee, 0x2d,
	0x8d, 0xa0, 0xf7, 0x25, 0xe3, 0x91, 0xa4, 0x3b, 0xd2, 0x1d, 0x3a, 0x54, 0x9e, 0x85, 0xac, 0x04,
	0xa6, 0x2a, 0x15, 0x04, 0x9e, 0x5f, 0x04, 0x86, 0x38, 0xd2, 0xdd, 0xd0, 0x76, 0x9a, 0xe5, 0x74,
	0x3c, 0x8e, 0x74, 0x4d, 0xfd, 0x90, 0x2a, 0xcf, 0xe0, 0x3d, 0xe1, 0xb0, 0x4c, 0xe5, 0x02, 0xc2,
	0x1e, 0x7b, 0xc8, 0x1c, 0x43, 0x55, 0x56, 0x7e, 0xf1, 0x9b, 0xd5, 0x53, 0x7f, 0xfa, 0xed, 0x6a,
	0x79, 0xb1, 0xbb, 0xf2, 0xdf, 0x04, 0x94, 0xe6, 0x8e, 0x1c, 0x53, 0x64, 0xd6, 0xb2, 0x07, 0xf6,
	0x44, 0x84, 0xf3, 0x5c, 0x0d, 0xd0, 0x4b, 0xb3, 0x6d, 0xbb, 0x8e, 0x12, 0x22, 0x7b, 0xd0, 0x0f,
	0xe6, 0x13, 0xd2, 0xab, 0x27, 0xf4, 0xa7, 0xd8, 0x94, 0x74, 0x03, 0x4a, 0x43, 0xdc, 0x47, 0xea,
	0xf4, 0x07, 0xb6, 0xb5, 0x67, 0xec, 0xcb, 0x50, 0x5d, 0x89, 0xb3, 0xd9, 0xe0, 0x40, 0x52, 0x14,
	0x0a, 0x75, 0x8e, 0xff, 0x1a, 0xc9, 0xa8, 0xb2, 0x03, 0xc5, 0xa8, 0x87, 0x2a, 0x4f, 0x02, 0xb8,
	0xc6, 0x8f, 0xa8, 0xe4, 0x37, 0x9c, 0x0d, 0x91, 0x3c, 0x93, 0x70, 0x76, 0xa3, 0x3c, 0x07, 0xe9,
	0x31, 0x86, 0x32, 0x6e, 0x27, 0x53, 0x3b, 0xcb, 0x72, 0xe2, 0xdf, 0x3e, 0xb9, 0x54, 0xb0, 0xdd,
	0xea, 0xba, 0x61, 0xd2, 0x4d, 0xec, 0x22, 0x1c, 0xa0, 0x1e, 0x42, 0x9a, 0x85, 0x0a, 0xe5, 0x09,
	0x48, 0xd7, 0x5a, 0xed, 0x06, 0xba, 0xda, 0x19, 0x3c, 0x9d, 0x12, 0xdf, 0x12, 0xd6, 0xc1, 0x7c,
	0x57, 0xb9, 0x04, 0xd9, 0x9d, 0xad, 0x8d, 0xde, 0x26, 0x73, 0xaf, 0xb3, 0xd8, 0x7d, 0x3a, 0xe8,
	0x16, 0x9b, 0x86, 0xb3, 0xc9, 0x6c, 0x6f, 0x76, 0xd6, 0xbb, 0xe8, 0x54, 0x0a, 0xf6, 0x2f, 0x07,
	0xfd, 0x7c, 0xce, 0x95, 0x33, 0xf2, 0x54, 0xf3, 0x81, 0x5c, 0xfd, 0x4f, 0x12, 0x4a, 0x84, 0xf1,
	0x5b, 0xc7, 0xeb, 0xd8, 0xa6, 0x31, 0x98, 0x29, 0x1d, 0xc8, 0xe3, 0xb6, 0x0e, 0x8d, 0xc8, 0x9d,
	0x5a, 0x7b, 0x44, 0x12, 0x0c, 0xb5, 0xfc, 0x56, 0xdd, 0xd7, 0x24, 0xa1, 0x11, 0x0c, 0x96, 0x99,
	0x21, 0x35, 0xf5, 0xd9, 0x71, 0xd9, 0xb8, 0x21, 0xb9, 0x34, 0x11, 0x50, 0xce, 0x1c, 0xf5, 0xbb,
	0x7d, 0xdd, 0xf3, 0xe8, 0x78, 0xe2, 0x89, 0x6c, 0x9c, 0x46, 0xe6, 0xa8, 0xdf, 0xd5, 0xa4, 0x48,
	0x79, 0x0d, 0xb2, 0x47, 0xb8, 0x2b, 0xf6, 0x91, 0x4c, 0xb8, 0xc7, 0xdb, 0x95, 0x58, 0xf5, 0x7d,
	0x96, 0x67, 0x17, 0x26, 0xcb, 0x76, 0xbd, 0xbd, 0xd5, 0x6e, 0xfa, 0xbb, 0x2e, 0xfb, 0xb7, 0xac,
	0xb6, 0x6d, 0xb1, 0x1b, 0x03, 0x5b, 0xed, 0xfe, 0xba, 0xd6, 0xda, 0xe8, 0x11, 0xb6, 0xf3, 0xe7,
	0x10, 0x52, 0x0e, 0x20, 0xeb, 0xba, 0x61, 0x32, 0x12, 0x78, 0x01, 0x52, 0x5a, 0x1b, 0xb3, 0x4b,
	0xa5, 0x8c, 0xdd, 0xc5, 0xa0, 0x5b, 0xb3, 0x66, 0xe1, 0x65, 0x5a, 0x1c, 0x57, 0xfd, 0x57, 0x02,
	0x8a, 0xbd, 0xc9, 0x10, 0x23, 0x82, 0xf0, 0x4c, 0xe5, 0x32, 0x86, 0x34, 0xdd, 0xd1, 0x4d, 0x93,
	0x9a, 0x86, 0x3b, 0x96, 0x85, 0x42, 0x54, 0x84, 0xec, 0xe6, 0xe4, 0x9b, 0x29, 0x49, 0x98, 0xdc,
	0xd2, 0x1e, 0x2c, 0xef, 0x89, 0xc9, 0xf6, 0xf5, 0x01, 0x3f, 0xdd, 0x14, 0x3f, 0xdd, 0x6a, 0x9c,
	0x89, 0xe8, 0xac, 0xaa, 0x72, 0x8d, 0x1a, 0xd7, 0x22, 0xa5, 0xbd, 0x68, 0x53, 0xbd, 0x0a, 0xa5,
	0xb9, 0x7e, 0x96, 0x69, 0x3b, 0x5a, 0xaf, 0x8b, 0xbb, 0xa9, 0x14, 0x21, 0x87, 0x69, 0x76, 0xbb,
	0xd5, 0xee, 0xe1, 0xc6, 0xa9, 0x7f, 0x48, 0xfa, 0xab, 0x95, 0x4c, 0xa0, 0x36, 0xcf, 0x04, 0x5e,
	0x7a, 0xf4, 0x44, 0x24, 0x17, 0x08, 0x1b, 0x01, 0x23, 0xf8, 0x2e, 0x5e, 0x40, 0xb6, 0xa9, 0x74,
	0x88, 0xce, 0x72, 0x1c, 0xdb, 0xdf, 0xf6, 0xeb, 0x38, 0xbc, 0x9f, 0x42, 0x41, 0xf3, 0x94, 0xb7,
	0xa1, 0x38, 0xb0, 0xc7, 0x13, 0x93, 0x4a, 0xfd, 0xd4, 0x49, 0xf4, 0x0b, 0x81, 0x0a, 0x5a, 0x88,
	0x30, 0x92, 0xf4, 0x3c, 0x23, 0xa9, 0x23, 0x2d, 0x0a, 0xe7, 0x3b, 0xcf, 0x4b, 0x70, 0x63, 0x7a,
	0x9d, 0x86, 0x86, 0x3b, 0x73, 0x13, 0xb9, 0x09, 0x40, 0x96, 0xef, 0x18, 0x26, 0x03, 0xc6, 0x9d,
	0xea, 0x5b, 0x9b, 0x9d, 0x8d, 0xa6, 0x60, 0x26, 0x3f, 0x81, 0xd3, 0x78, 0x08, 0x9e, 0x8e, 0x14,
	0xd1, 0x27, 0x85, 0x6b, 0x6c, 0xce, 0x52, 0xd4, 0x37, 0x86, 0x22, 0x6e, 0xd5, 0x4e, 0x63, 0xd4,
	0x2d, 0x04, 0xd0, 0x56, 0x83, 0xcd, 0xd2, 0x6f, 0x0c, 0x99, 0x77, 0x4e, 0x10, 0x2a, 0xc2, 0xd0,
	0x12, 0x42, 0x53, 0x1d, 0x84, 0x30, 0x19, 0xfa, 0x7e, 0x9e, 0xde, 0x35, 0x3c, 0x8c, 0xa5, 0x43,
	0x41, 0xfb, 0x32, 0x24, 0xc7, 0x04, 0x75, 0x16, 0x96, 0x7e, 0x9a, 0x04, 0xd8, 0xd6, 0xdd, 0x03,
	0x39, 0x34, 0x12, 0xe4, 0xa0, 0x1c, 0x3e, 0xae, 0x2c, 0x8b, 0xec, 0x75, 0x80, 0x57, 0x5e, 0xf5,
	0x4f, 0x5b, 0xb0, 0xd5, 0x78, 0x45, 0x39, 0x56, 0x1c, 0xe1, 0x9b, 0xa7, 0xa4, 0x2c, 0x6a, 0x53,
	0xc7, 0x91, 0x9b, 0xce, 0x3e, 0xb1, 0x4a, 0xce, 0x07, 0x6b, 0x96, 0x1c, 0xe8, 0xe9, 0xb8, 0x41,
	0x16, 0x36, 0xf4, 0xd6, 0x29, 0x12, 0xea, 0xd5, 0xca, 0xb0, 0xec, 0x60, 0x70, 0xc4, 0x59, 0xf7,
	0x5d, 0xde, 0xad, 0xfe, 0x05, 0xf7, 0xa0, 0xd5, 0xd1, 0x36, 0xe5, 0x15, 0x6d, 0x40, 0x76, 0x4f,
	0x1f, 0x1b, 0xe6, 0xec, 0x38, 0xaf, 0x0d, 0xf1, 0x55, 0x6d, 0x38, 0xc4, 0x22, 0xc1, 0x5d, 0xe7,
	0x3a, 0x44, 0xea, 0x72, 0x32, 0x38, 0xdd, 0xb5, 0xa8, 0x17, 0x90, 0x41, 0xde, 0x62, 0x99, 0xc7,
	0xd1, 0xad, 0x60, 0xb5, 0xa2, 0xc1, 0x76, 0x01, 0xd3, 0x2f, 0x3d, 0xd2, 0x67, 0xbe, 0x93, 0xc9,
	0x26, 0x52, 0xbf, 0x9c, 0xa8, 0x5d, 0xe9, 0x10, 0x97, 0xcc, 0x52, 0xeb, 0x97, 0xcd, 0x87, 0x48,
	0xb8, 0xc8, 0xa9, 0x81, 0x76, 0xe5, 0x4d, 0x9e, 0x08, 0xc2, 0xae, 0xaf, 0x54, 0xa3, 0xbd, 0x02,
	0xa5, 0xb9, 0x75, 0x3e, 0xc4, 0xc2, 0x5b, 0x9d, 0x9d, 0xd7, 0xca, 0x69, 0xf9, 0xf5, 0x9d, 0x72,
	0x56, 0xfd, 0x37, 0x16, 0x05, 0x1d, 0x9b, 0x07, 0x43, 0xb6, 0xab, 0xf1, 0xaf, 0x1e, 0x39, 0xfe,
	0x86, 0x32, 0xb0, 0x4d, 0xe9, 0x33, 0xb1, 0x34, 0x34, 0xb4, 0xc2, 0x58, 0x1d, 0x87, 0x93, 0x40,
	0x11, 0x73, 0x66, 0x41, 0xf0, 0xe9, 0xfe, 0x04, 0x71, 0x7c, 0x5b, 0x4b, 0x04, 0x84, 0x88, 0x69,
	0xb2, 0x92, 0x7a, 0x32, 0xdd, 0xc5, 0xd8, 0x3a, 0xc2, 0x10, 0xc0, 0x31, 0x69, 0x8e, 0x29, 0x05,
	0x52, 0x06, 0x53, 0x1b, 0x90, 0xf3, 0xad, 0xe3, 0x71, 0xa4, 0xb6, 0xeb, 0x1d, 0xcc, 0x16, 0xa7,
	0x31, 0xd6, 0x17, 0x7c, 0x31, 0x8a, 0x58, 0x4f, 0xaf, 0xd1, 0xc1, 0x24, 0x31, 0xd7, 0x83, 0xa2,
	0x4a, 0x9a, 0x25, 0x01, 0xf5, 0x57, 0x09, 0xc8, 0x0a, 0x4a, 0x12, 0xbb, 0x62, 0x0d, 0x96, 0x7c,
	0xa2, 0x2c, 0x78, 0xd2, 0x73, 0x8f, 0xe6, 0x34, 0x55, 0x49, 0x41, 0xc4, 0x39, 0xfa, 0x7a, 0x95,
	0x37, 0xa0, 0x18, 0xed, 0xf8, 0x4a, 0xa7, 0xf8, 0x63, 0x28, 0x30, 0x47, 0xf1, 0xb9, 0xcd, 0x1a,
	0x64, 0x05, 0x6d, 0x92, 0x57, 0xfd, 0x38, 0x82, 0x25, 0x91, 0x98, 0x9e, 0x96, 0x04, 0x29, 0xf3,
	0x9f, 0x0b, 0x56, 0x8f, 0x77, 0x47, 0xe2, 0xc3, 0xd5, 0x1b, 0x90, 0xee, 0x50, 0xb4, 0xf0, 0x34,
	0x2c, 0x59, 0x18, 0x7a, 0xc2, 0xc8, 0x26, 0xf9, 0xe4, 0x90, 0x62, 0xc4, 0xca, 0xb2, 0x2e, 0x8c,
	0x67, 0xb8, 0x79, 0x3a, 0xfa, 0x9b, 0xff, 0x62, 0xc2, 0xbe, 0xd5, 0x6d, 0x28, 0xde, 0xa1, 0xc6,
	0xfe, 0x08, 0xe3, 0x32, 0x37, 0xf4, 0x12, 0xa4, 0x27, 0x34, 0x98, 0xfc, 0x4a, 0xac, 0xeb, 0x60,
	0x3f, 0xe1, 0x28, 0x76, 0x21, 0x8f, 0xb8, 0xb6, 0x7c, 0xa4, 0x92, 0x2d, 0xf5, 0xf7, 0x49, 0x58,
	0x6e, 0xb9, 0xee, 0x54, 0xc7, 0x02, 0x50, 0x46, 0xc1, 0xb7, 0xe6, 0xd3, 0xd6, 0xd5, 0xd8, 0x15,
	0xce, 0xa9, 0xcc, 0x17, 0xb1, 0x32, 0x72, 0x25, 0x83, 0xc8, 0xa5, 0x3e, 0x48, 0xf8, 0xd5, 0xeb,
	0x95, 0xc8, 0xbd, 0xa9, 0xac, 0xa0, 0x13, 0x9d, 0x8b, 0x5a, 0xa2, 0x3d, 0xeb, 0xc0, 0xb2, 0x8f,
	0x2c, 0xa4, 0x47, 0x58, 0xcd, 0xb6, 0x9b, 0x77, 0xd0, 0xd3, 0xce, 0x23, 0x48, 0x99, 0x03, 0x11,
	0x6a, 0xd1, 0x23, 0x66, 0xa9, 0xd3, 0x6c, 0x37, 0x58, 0x86, 0x49, 0xc6, 0x58, 0xea, 0x50, 0x24,
	0x21, 0xd6, 0x3e, 0x6e, 0x77, 0xb6, 0xd5, 0xed, 0xf6, 0x78, 0x7d, 0xf1, 0x38, 0xa2, 0xce, 0xce,
	0xa1, 0x58, 0x03, 0x8b, 0x0b, 0x04, 0x31, 0xfe, 0x83, 0xa0, 0x74, 0x0c, 0x88, 0xa5, 0x7f, 0x0c,
	0x20, 0xc2, 0xc3, 0xff, 0x9e, 0x84, 0xb2, 0x36, 0x18, 0xd0, 0x89, 0xc7, 0xfa, 0x25, 0xa7, 0xdc,
	0xc6, 0x9b, 0xcc, 0xbe, 0x0c, 0xce, 0x91, 0x99, 0x5b, 0x5c, 0x8f, 0x7d, 0xc1, 0x5c, 0xd0, 0xab,
	0x12, 0xdb, 0xa4, 0xda, 0x70, 0x6c, 0xb8, 0xec, 0x55, 0x4b, 0xc8, 0x48, 0x60, 0xa9, 0xf2, 0x79,
	0x02, 0xce, 0xc6, 0x20, 0x94, 0x57, 0x20, 0xed, 0xa0, 0x58, 0x1e, 0xcf, 0xc5, 0x47, 0xbd, 0x2f,
	0x30, 0x55, 0xc2, 0x91, 0xca, 0x2a, 0x80, 0x3e, 0xf5, 0x6c, 0x9d, 0x8f, 0xcf, 0x0f, 0x26, 0x47,
	0x22, 0x12, 0xe5, 0x0e, 0x46, 0x6b, 0x3a, 0x70, 0xa8, 0x4f, 0x10, 0x6e, 0xfc, 0xbf, 0xb3, 0xaf,
	0x76, 0xb9, 0x19, 0x22, 0xcd, 0x55, 0xaa, 0x58, 0xdd, 0xf1, 0x2f, 0xe6, 0xd1, 0xc8, 0x15, 0x74,
	0x3e, 0xe9, 0x22, 0xe1, 0xdf, 0xcc, 0x51, 0x74, 0x73, 0xdf, 0x77, 0x14, 0xfc, 0x54, 0x3f, 0xc4,
	0x5c, 0xd4, 0xbc, 0xeb, 0x51, 0xc7, 0xd2, 0xcd, 0xba, 0xa6, 0x34, 0x23, 0x11, 0x52, 0xac, 0xf6,
	0xf9, 0xd8, 0x57, 0xa7, 0x40, 0xa3, 0x5a, 0xd7, 0x62, 0x62, 0x24, 0xb2, 0x83, 0xa9, 0x63, 0xca,
	0x17, 0x4c, 0xce, 0x0e, 0x7a, 0x64, 0x83, 0x30, 0x19, 0x7b, 0xfe, 0xf3, 0x23, 0x52, 0xea, 0xd1,
	0x4f, 0xcf, 0x91, 0x01, 0xbe, 0xf9, 0xa8, 0xf4, 0x12, 0x40, 0x38, 0x6b, 0x3c, 0xaa, 0x4c, 0x7d,
	0xbd, 0xdb, 0xdd, 0xc0, 0xeb, 0xc1, 0x4b, 0xa0, 0xb0, 0x8b, 0x8b, 0xd5, 0xdf, 0x25, 0x90, 0x73,
	0x6a, 0x32, 0xab, 0xac, 0x43, 0x99, 0xc7, 0x92, 0x01, 0x75, 0xbc, 0x3e, 0xbd, 0x3b, 0x31, 0x9c,
	0x99, 0x0c, 0x07, 0xc7, 0x17, 0x0b, 0xcb, 0x4c, 0xab, 0x8e, 0x4a, 0x4d, 0xae, 0xa3, 0x10, 0x28,
	0x52, 0xb9, 0xc4, 0xfe, 0x40, 0xf7, 0x83, 0xf3, 0xea, 0xf1, 0x5b, 0x21, 0x28, 0x59, 0xd8, 0x76,
	0x49, 0xc1, 0x37, 0x52, 0xd7, 0x5d, 0x75, 0x07, 0xce, 0x6e, 0x39, 0x83, 0x11, 0x92, 0x23, 0x31,
	0xa8, 0x9c, 0xf2, 0x0d, 0xb8, 0xe8, 0x21, 0x09, 0xea, 0x8f, 0x0c, 0xd7, 0x63, 0x0f, 0xe7, 0xe8,
	0x1b, 0xd4, 0x62, 0xfd, 0x7d, 0xfe, 0xc0, 0x2d, 0x4b, 0xcc, 0x0b, 0x0c, 0x73, 0x4b, 0x40, 0x88,
	0x8f, 0xd8, 0x60, 0x00, 0xb5, 0x85, 0x15, 0x2a, 0x76, 0x36, 0xe8, 0x9e, 0x3e, 0x35, 0xb1, 0x4c,
	0x7a, 0x1d, 0xc0, 0xb4, 0xf7, 0xfb, 0x27, 0x8e, 0xe4, 0x79, 0x44, 0x8b, 0x4f, 0xf5, 0xfb, 0x50,
	0x6e, 0x18, 0xee, 0x44, 0xf7, 0x70, 0x9a, 0xb2, 0x76, 0x56, 0x6e, 0x42, 0x79, 0x44, 0x91, 0x3e,
	0xef, 0x52, 0x1d, 0x53, 0x2a, 0x75, 0x0c, 0x7b, 0x78, 0xa2, 0x2d, 0x3d, 0x1d, 0x68, 0x75, 0xb8,
	0x92, 0xfa, 0x05, 0x12, 0x00, 0xf6, 0x38, 0x29, 0xed, 0xbe, 0x08, 0x67, 0x5c, 0x4b, 0x9f, 0xb8,
	0x23, 0xdb, 0xeb, 0x1b, 0x96, 0xc7, 0x5e, 0xe3, 0x4d, 0x59, 0xff, 0x94, 0xfd, 0x8e, 0x96, 0x94,
	0x63, 0x68, 0x57, 0x0e, 0x28, 0x9d, 0xf4, 0x6d, 0x73, 0xd8, 0xf7, 0x3b, 0xc5, 0x0b, 0x3c, 0xa2,
	0x59, 0xcf, 0x96, 0x39, 0xec, 0xfa, 0x72, 0x2c, 0x33, 0x56, 0xd9, 0x0e, 0xe0, 0x26, 0x39, 0x18,
	0x36, 0xfa, 0x7b, 0xb6, 0xd3, 0x77, 0x4d, 0xfb, 0x08, 0x3f, 0x4c, 0xfc, 0x47, 0x1d, 0xbf, 0xba,
	0xac, 0x20, 0xaa, 0x29, 0x40, 0xeb, 0xb6, 0xd3, 0xc5, 0xbe, 0x75, 0x1f, 0xc1, 0x58, 0x42, 0xb8,
	0x6c, 0xcf, 0x18, 0x1c, 0xf8, 0x2c, 0x21, 0x90, 0x6e, 0xa3, 0x10, 0x03, 0x65, 0x89, 0x9a, 0x94,
	0xd7, 0x41, 0x02, 0x95, 0xe1, 0xa8, 0xa2, 0x2f, 0x64, 0x20, 0xf5, 0x5b, 0x90, 0xef, 0x98, 0xfa,
	0x80, 0xff, 0xce, 0xc1, 0x2a, 0x3e, 0xcc, 0x80, 0xcc, 0x09, 0x70, 0xd5, 0x22, 0x3a, 0xe6, 0x49,
	0x54, 0xa4, 0xbe, 0x05, 0xf0, 0x8e, 0x6d, 0x58, 0xdb, 0xf6, 0x01, 0xb5, 0xf8, 0x93, 0xf0, 0x91,
	0xed, 0x1c, 0xc8, 0xa3, 0x44, 0xe2, 0x28, 0x5a, 0x9c, 0x28, 0xeb, 0x16, 0x12, 0x63, 0x27, 0x78,
	0x19, 0x15, 0x4d, 0x96, 0x5c, 0xb2, 0xc4, 0xb6, 0x3d, 0x8c, 0x17, 0x97, 0x21, 0x3b, 0xd0, 0xfb,
	0xfe, 0xcd, 0x2b, 0xd6, 0xf2, 0xe8, 0xa1, 0x99, 0xba, 0x76, 0x9b, 0xce, 0x48, 0x66, 0xa0, 0xe3,
	0x3f, 0x96, 0x7d, 0x11, 0xc1, 0xee, 0x0b, 0x37, 0x53, 0x14, 0xd9, 0x17, 0x2f, 0x14, 0x4a, 0x08,
	0x2a, 0xb3, 0xff, 0x18, 0x60, 0x8b, 0x12, 0xd4, 0x1f, 0xe9, 0xee, 0x48, 0x70, 0xd5, 0xda, 0x32,
	0x22, 0x41, 0x20, 0x6f, 0xa1, 0x94, 0x80, 0x40, 0xb3, 0x6f, 0x0c, 0x23, 0x85, 0xf7, 0x70, 0x0d,
	0x7d, 0x8f, 0x2f, 0x42, 0x16, 0xec, 0xb1, 0xf7, 0x27, 0x5c, 0xaa, 0xac, 0x5e, 0xe1, 0xbd, 0x40,
	0xa2, 0xfe, 0x35, 0x01, 0x05, 0x66, 0xd3, 0xd8, 0x33, 0x06, 0x2c, 0x5b, 0x7e, 0xf5, 0x48, 0x8f,
	0xa1, 0x6e, 0xe0, 0x3a, 0x72, 0x6d, 0x3c, 0xd4, 0xd5, 0xbb, 0x84, 0x30, 0x19, 0xd6, 0x82, 0x59,
	0xc1, 0xf8, 0x65, 0x90, 0x57, 0xbf, 0x3c, 0xaf, 0xcb, 0x29, 0x4a, 0x3d, 0x7e, 0x96, 0xe1, 0xec,
	0xf8, 0x2a, 0x8b, 0x24, 0x2a, 0x62, 0x3f, 0x15, 0x0d, 0x2c, 0xee, 0x14, 0xf2, 0xa7, 0xa2, 0x7a,
	0x9b, 0xa0, 0x44, 0xfd, 0x73, 0x02, 0x4a, 0x4d, 0x6b, 0xe0, 0xcc, 0x78, 0x90, 0x64, 0x07, 0x71,
	0x11, 0xf2, 0x58, 0x12, 0xb8, 0x33, 0xd7, 0xa3, 0x63, 0xff, 0x25, 0x3a, 0x10, 0x28, 0x2d, 0xc8,
	0x63, 0x3a, 0xb0, 0x1d, 0xc3, 0x1b, 0x8d, 0x25, 0x37, 0x8e, 0x0f, 0xcc, 0x51, 0x9b, 0x55, 0xcd,
	0x57, 0x21, 0xa1, 0xb6, 0x1f, 0x8a, 0x53, 0x7c, 0xb2, 0x3c, 0x14, 0x3f, 0x05, 0x45, 0x13, 0x0b,
	0x36, 0x64, 0xbd, 0x7d, 0x56, 0x07, 0xf1, 0x75, 0xa4, 0x49, 0x41, 0xca, 0x58, 0x6d, 0xa7, 0xaa,
	0x90, 0x0f, 0x8c, 0xb1, 0xf7, 0x7f, 0xad, 0xd9, 0xed, 0x5f, 0x5b, 0xbb, 0xde, 0xbf, 0x59, 0xdf,
	0xc4, 0xc0, 0x2c, 0x98, 0xc0, 0x1f, 0x71, 0x4d, 0x9b, 0xc2, 0x07, 0x25, 0x71, 0x42, 0xe7, 0x72,
	0xf0, 0xc6, 0xfb, 0xd4, 0x2e, 0x2d, 0x9c, 0x8b, 0x05, 0x01, 0x46, 0xed, 0x58, 0x57, 0x3c, 0xb5,
	0x8b, 0xfc, 0x0e, 0x92, 0x3a, 0xf6, 0x77, 0x90, 0xf4, 0x37, 0xf2, 0x3b, 0xc8, 0x0b, 0x5f, 0xa4,
	0x20, 0x1f, 0x54, 0xa2, 0xcc, 0x65, 0x18, 0xd3, 0x3a, 0x25, 0x5e, 0x76, 0x02, 0x79, 0x9b, 0x73,
	0xac, 0xbc, 0xb6, 0xb1, 0xb1, 0x55, 0xd7, 0x58, 0xb1, 0xfe, 0xb6, 0xa0, 0x62, 0x01, 0x40, 0xc3,
	0xd8, 0xc1, 0x0e, 0x7d, 0xa8, 0xa8, 0x21, 0x15, 0xbb, 0x27, 0xdf, 0x8f, 0x02, 0x94, 0xcf, 0xc3,
	0x9e, 0x81, 0x9c, 0xd6, 0xed, 0xb6, 0x6e, 0xb6, 0xd1, 0xd2, 0xfd, 0x44, 0xe5, 0x31, 0x04, 0x9d,
	0x09, 0x4d, 0x21, 0x85, 0xd8, 0xb7, 0xd0, 0x12, 0x43, 0xd5, 0xeb, 0xcd, 0x0e, 0x1b, 0xef, 0x5e,
	0x72, 0x11, 0xc5, 0x09, 0x08, 0x7f, 0x0b, 0xce, 0x77, 0x48, 0xb3, 0xa3, 0x11, 0x36, 0xe2, 0xfd,
	0xe4, 0xc2, 0xbc, 0x3a, 0x0e, 0x9d, 0xe8, 0x0e, 0x1b, 0x73, 0xd5, 0xff, 0x4d, 0xe4, 0x5e, 0x4a,
	0xbc, 0x17, 0x86, 0xe5, 0x37, 0xee, 0xef, 0x8c, 0x8d, 0xd6, 0xdd, 0xd6, 0x08, 0x7f, 0xa5, 0xb8,
	0x9f, 0x5a, 0x18, 0xad, 0xcb, 0x1e, 0x51, 0x98, 0x15, 0x5c, 0x1d, 0xe9, 0xb5, 0xdb, 0x7c, 0x75,
	0xe9, 0x85, 0xd5, 0x91, 0xa9, 0x65, 0x31, 0xcc, 0x15, 0xf6, 0x10, 0x24, 0x5e, 0x35, 0xca, 0xf7,
	0xd3, 0x0b, 0x13, 0xaa, 0xfb, 0xcf, 0x29, 0x7c, 0xc0, 0x5b, 0xbd, 0x6d, 0xfe, 0x93, 0xcd, 0xbd,
	0xcc, 0xe2, 0x80, 0xa3, 0xa9, 0x37, 0x64, 0xe4, 0xf7, 0x72, 0xc0, 0x46, 0xef, 0x67, 0x04, 0x09,
	0x08, 0x30, 0x82, 0x8a, 0x32, 0x3b, 0xa4, 0xf9, 0x8e, 0xf8, 0x75, 0xe7, 0x5e, 0x76, 0xc1, 0x0e,
	0xa1, 0xef, 0x61, 0x30, 0x46, 0xc2, 0x1a, 0x3c, 0x87, 0x06, 0x5d, 0x2f, 0xfc, 0x00, 0x72, 0x7e,
	0xc0, 0xc0, 0xdd, 0xc9, 0xde, 0xd9, 0x22, 0xb7, 0x9b, 0x04, 0x8f, 0x9e, 0xef, 0x8e, 0xdf, 0x73,
	0x47, 0x44, 0xdc, 0xcb, 0xb0, 0xb4, 0xa9, 0xb5, 0xb5, 0x9b, 0x08, 0x90, 0xcf, 0xb1, 0x3e, 0x40,
	0x7a, 0x7d, 0xa5, 0x2c, 0x07, 0x08, 0x6c, 0xd6, 0x2e, 0x3e, 0xf8, 0x74, 0xf5, 0xd4, 0xc7, 0xf8,
	0xf7, 0xf9, 0xa7, 0xab, 0x89, 0x7b, 0x9f, 0xad, 0x26, 0x1e, 0xe0, 0xdf, 0x47, 0xf8, 0xf7, 0x0f,
	0xfc, 0xdb, 0xcd, 0x72, 0x46, 0xf6, 0xea, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x84, 0x8b, 0x50,
	0xe8, 0x9f, 0x20, 0x00, 0x00,
}
