// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/bigtable/internal/data_proto/bigtable_data.proto
// DO NOT EDIT!

/*
Package google_bigtable_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/cloud/bigtable/internal/data_proto/bigtable_data.proto

It has these top-level messages:
	Row
	Family
	Column
	Cell
	RowRange
	ColumnRange
	TimestampRange
	ValueRange
	RowFilter
	Mutation
	ReadModifyWriteRule
*/
package google_bigtable_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Specifies the complete (requested) contents of a single row of a table.
// Rows which exceed 256MiB in size cannot be read in full.
type Row struct {
	// The unique key which identifies this row within its table. This is the same
	// key that's used to identify the row in, for example, a MutateRowRequest.
	// May contain any non-empty byte string up to 4KiB in length.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// May be empty, but only if the entire row is empty.
	// The mutual ordering of column families is not specified.
	Families []*Family `protobuf:"bytes,2,rep,name=families" json:"families,omitempty"`
}

func (m *Row) Reset()         { *m = Row{} }
func (m *Row) String() string { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()    {}

func (m *Row) GetFamilies() []*Family {
	if m != nil {
		return m.Families
	}
	return nil
}

// Specifies (some of) the contents of a single row/column family of a table.
type Family struct {
	// The unique key which identifies this family within its row. This is the
	// same key that's used to identify the family in, for example, a RowFilter
	// which sets its "family_name_regex_filter" field.
	// Must match [-_.a-zA-Z0-9]+, except that AggregatingRowProcessors may
	// produce cells in a sentinel family with an empty name.
	// Must be no greater than 64 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Must not be empty. Sorted in order of increasing "qualifier".
	Columns []*Column `protobuf:"bytes,2,rep,name=columns" json:"columns,omitempty"`
}

func (m *Family) Reset()         { *m = Family{} }
func (m *Family) String() string { return proto.CompactTextString(m) }
func (*Family) ProtoMessage()    {}

func (m *Family) GetColumns() []*Column {
	if m != nil {
		return m.Columns
	}
	return nil
}

// Specifies (some of) the contents of a single row/column of a table.
type Column struct {
	// The unique key which identifies this column within its family. This is the
	// same key that's used to identify the column in, for example, a RowFilter
	// which sets its "column_qualifier_regex_filter" field.
	// May contain any byte string, including the empty string, up to 16kiB in
	// length.
	Qualifier []byte `protobuf:"bytes,1,opt,name=qualifier,proto3" json:"qualifier,omitempty"`
	// Must not be empty. Sorted in order of decreasing "timestamp_micros".
	Cells []*Cell `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
}

func (m *Column) Reset()         { *m = Column{} }
func (m *Column) String() string { return proto.CompactTextString(m) }
func (*Column) ProtoMessage()    {}

func (m *Column) GetCells() []*Cell {
	if m != nil {
		return m.Cells
	}
	return nil
}

// Specifies (some of) the contents of a single row/column/timestamp of a table.
type Cell struct {
	// The cell's stored timestamp, which also uniquely identifies it within
	// its column.
	// Values are always expressed in microseconds, but individual tables may set
	// a coarser "granularity" to further restrict the allowed values. For
	// example, a table which specifies millisecond granularity will only allow
	// values of "timestamp_micros" which are multiples of 1000.
	TimestampMicros int64 `protobuf:"varint,1,opt,name=timestamp_micros" json:"timestamp_micros,omitempty"`
	// The value stored in the cell.
	// May contain any byte string, including the empty string, up to 100MiB in
	// length.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Labels applied to the cell by a [RowFilter][google.bigtable.v1.RowFilter].
	Labels []string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty"`
}

func (m *Cell) Reset()         { *m = Cell{} }
func (m *Cell) String() string { return proto.CompactTextString(m) }
func (*Cell) ProtoMessage()    {}

// Specifies a contiguous range of rows.
type RowRange struct {
	// Inclusive lower bound. If left empty, interpreted as the empty string.
	StartKey []byte `protobuf:"bytes,2,opt,name=start_key,proto3" json:"start_key,omitempty"`
	// Exclusive upper bound. If left empty, interpreted as infinity.
	EndKey []byte `protobuf:"bytes,3,opt,name=end_key,proto3" json:"end_key,omitempty"`
}

func (m *RowRange) Reset()         { *m = RowRange{} }
func (m *RowRange) String() string { return proto.CompactTextString(m) }
func (*RowRange) ProtoMessage()    {}

// Specifies a contiguous range of columns within a single column family.
// The range spans from <column_family>:<start_qualifier> to
// <column_family>:<end_qualifier>, where both bounds can be either inclusive or
// exclusive.
type ColumnRange struct {
	// The name of the column family within which this range falls.
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
	// The column qualifier at which to start the range (within 'column_family').
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartQualifier:
	//	*ColumnRange_StartQualifierInclusive
	//	*ColumnRange_StartQualifierExclusive
	StartQualifier isColumnRange_StartQualifier `protobuf_oneof:"start_qualifier"`
	// The column qualifier at which to end the range (within 'column_family').
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndQualifier:
	//	*ColumnRange_EndQualifierInclusive
	//	*ColumnRange_EndQualifierExclusive
	EndQualifier isColumnRange_EndQualifier `protobuf_oneof:"end_qualifier"`
}

func (m *ColumnRange) Reset()         { *m = ColumnRange{} }
func (m *ColumnRange) String() string { return proto.CompactTextString(m) }
func (*ColumnRange) ProtoMessage()    {}

type isColumnRange_StartQualifier interface {
	isColumnRange_StartQualifier()
}
type isColumnRange_EndQualifier interface {
	isColumnRange_EndQualifier()
}

type ColumnRange_StartQualifierInclusive struct {
	StartQualifierInclusive []byte `protobuf:"bytes,2,opt,name=start_qualifier_inclusive,proto3,oneof"`
}
type ColumnRange_StartQualifierExclusive struct {
	StartQualifierExclusive []byte `protobuf:"bytes,3,opt,name=start_qualifier_exclusive,proto3,oneof"`
}
type ColumnRange_EndQualifierInclusive struct {
	EndQualifierInclusive []byte `protobuf:"bytes,4,opt,name=end_qualifier_inclusive,proto3,oneof"`
}
type ColumnRange_EndQualifierExclusive struct {
	EndQualifierExclusive []byte `protobuf:"bytes,5,opt,name=end_qualifier_exclusive,proto3,oneof"`
}

func (*ColumnRange_StartQualifierInclusive) isColumnRange_StartQualifier() {}
func (*ColumnRange_StartQualifierExclusive) isColumnRange_StartQualifier() {}
func (*ColumnRange_EndQualifierInclusive) isColumnRange_EndQualifier()     {}
func (*ColumnRange_EndQualifierExclusive) isColumnRange_EndQualifier()     {}

func (m *ColumnRange) GetStartQualifier() isColumnRange_StartQualifier {
	if m != nil {
		return m.StartQualifier
	}
	return nil
}
func (m *ColumnRange) GetEndQualifier() isColumnRange_EndQualifier {
	if m != nil {
		return m.EndQualifier
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierInclusive() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierInclusive); ok {
		return x.StartQualifierInclusive
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierExclusive() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierExclusive); ok {
		return x.StartQualifierExclusive
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierInclusive() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierInclusive); ok {
		return x.EndQualifierInclusive
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierExclusive() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierExclusive); ok {
		return x.EndQualifierExclusive
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ColumnRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _ColumnRange_OneofMarshaler, _ColumnRange_OneofUnmarshaler, []interface{}{
		(*ColumnRange_StartQualifierInclusive)(nil),
		(*ColumnRange_StartQualifierExclusive)(nil),
		(*ColumnRange_EndQualifierInclusive)(nil),
		(*ColumnRange_EndQualifierExclusive)(nil),
	}
}

func _ColumnRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ColumnRange)
	// start_qualifier
	switch x := m.StartQualifier.(type) {
	case *ColumnRange_StartQualifierInclusive:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartQualifierInclusive)
	case *ColumnRange_StartQualifierExclusive:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartQualifierExclusive)
	case nil:
	default:
		return fmt.Errorf("ColumnRange.StartQualifier has unexpected type %T", x)
	}
	// end_qualifier
	switch x := m.EndQualifier.(type) {
	case *ColumnRange_EndQualifierInclusive:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndQualifierInclusive)
	case *ColumnRange_EndQualifierExclusive:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndQualifierExclusive)
	case nil:
	default:
		return fmt.Errorf("ColumnRange.EndQualifier has unexpected type %T", x)
	}
	return nil
}

func _ColumnRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ColumnRange)
	switch tag {
	case 2: // start_qualifier.start_qualifier_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartQualifier = &ColumnRange_StartQualifierInclusive{x}
		return true, err
	case 3: // start_qualifier.start_qualifier_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartQualifier = &ColumnRange_StartQualifierExclusive{x}
		return true, err
	case 4: // end_qualifier.end_qualifier_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndQualifier = &ColumnRange_EndQualifierInclusive{x}
		return true, err
	case 5: // end_qualifier.end_qualifier_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndQualifier = &ColumnRange_EndQualifierExclusive{x}
		return true, err
	default:
		return false, nil
	}
}

// Specified a contiguous range of microsecond timestamps.
type TimestampRange struct {
	// Inclusive lower bound. If left empty, interpreted as 0.
	StartTimestampMicros int64 `protobuf:"varint,1,opt,name=start_timestamp_micros" json:"start_timestamp_micros,omitempty"`
	// Exclusive upper bound. If left empty, interpreted as infinity.
	EndTimestampMicros int64 `protobuf:"varint,2,opt,name=end_timestamp_micros" json:"end_timestamp_micros,omitempty"`
}

func (m *TimestampRange) Reset()         { *m = TimestampRange{} }
func (m *TimestampRange) String() string { return proto.CompactTextString(m) }
func (*TimestampRange) ProtoMessage()    {}

// Specifies a contiguous range of raw byte values.
type ValueRange struct {
	// The value at which to start the range.
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartValue:
	//	*ValueRange_StartValueInclusive
	//	*ValueRange_StartValueExclusive
	StartValue isValueRange_StartValue `protobuf_oneof:"start_value"`
	// The value at which to end the range.
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndValue:
	//	*ValueRange_EndValueInclusive
	//	*ValueRange_EndValueExclusive
	EndValue isValueRange_EndValue `protobuf_oneof:"end_value"`
}

func (m *ValueRange) Reset()         { *m = ValueRange{} }
func (m *ValueRange) String() string { return proto.CompactTextString(m) }
func (*ValueRange) ProtoMessage()    {}

type isValueRange_StartValue interface {
	isValueRange_StartValue()
}
type isValueRange_EndValue interface {
	isValueRange_EndValue()
}

type ValueRange_StartValueInclusive struct {
	StartValueInclusive []byte `protobuf:"bytes,1,opt,name=start_value_inclusive,proto3,oneof"`
}
type ValueRange_StartValueExclusive struct {
	StartValueExclusive []byte `protobuf:"bytes,2,opt,name=start_value_exclusive,proto3,oneof"`
}
type ValueRange_EndValueInclusive struct {
	EndValueInclusive []byte `protobuf:"bytes,3,opt,name=end_value_inclusive,proto3,oneof"`
}
type ValueRange_EndValueExclusive struct {
	EndValueExclusive []byte `protobuf:"bytes,4,opt,name=end_value_exclusive,proto3,oneof"`
}

func (*ValueRange_StartValueInclusive) isValueRange_StartValue() {}
func (*ValueRange_StartValueExclusive) isValueRange_StartValue() {}
func (*ValueRange_EndValueInclusive) isValueRange_EndValue()     {}
func (*ValueRange_EndValueExclusive) isValueRange_EndValue()     {}

func (m *ValueRange) GetStartValue() isValueRange_StartValue {
	if m != nil {
		return m.StartValue
	}
	return nil
}
func (m *ValueRange) GetEndValue() isValueRange_EndValue {
	if m != nil {
		return m.EndValue
	}
	return nil
}

func (m *ValueRange) GetStartValueInclusive() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueInclusive); ok {
		return x.StartValueInclusive
	}
	return nil
}

func (m *ValueRange) GetStartValueExclusive() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueExclusive); ok {
		return x.StartValueExclusive
	}
	return nil
}

func (m *ValueRange) GetEndValueInclusive() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueInclusive); ok {
		return x.EndValueInclusive
	}
	return nil
}

func (m *ValueRange) GetEndValueExclusive() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueExclusive); ok {
		return x.EndValueExclusive
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ValueRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _ValueRange_OneofMarshaler, _ValueRange_OneofUnmarshaler, []interface{}{
		(*ValueRange_StartValueInclusive)(nil),
		(*ValueRange_StartValueExclusive)(nil),
		(*ValueRange_EndValueInclusive)(nil),
		(*ValueRange_EndValueExclusive)(nil),
	}
}

func _ValueRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ValueRange)
	// start_value
	switch x := m.StartValue.(type) {
	case *ValueRange_StartValueInclusive:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartValueInclusive)
	case *ValueRange_StartValueExclusive:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartValueExclusive)
	case nil:
	default:
		return fmt.Errorf("ValueRange.StartValue has unexpected type %T", x)
	}
	// end_value
	switch x := m.EndValue.(type) {
	case *ValueRange_EndValueInclusive:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndValueInclusive)
	case *ValueRange_EndValueExclusive:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndValueExclusive)
	case nil:
	default:
		return fmt.Errorf("ValueRange.EndValue has unexpected type %T", x)
	}
	return nil
}

func _ValueRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ValueRange)
	switch tag {
	case 1: // start_value.start_value_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartValue = &ValueRange_StartValueInclusive{x}
		return true, err
	case 2: // start_value.start_value_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartValue = &ValueRange_StartValueExclusive{x}
		return true, err
	case 3: // end_value.end_value_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndValue = &ValueRange_EndValueInclusive{x}
		return true, err
	case 4: // end_value.end_value_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndValue = &ValueRange_EndValueExclusive{x}
		return true, err
	default:
		return false, nil
	}
}

// Takes a row as input and produces an alternate view of the row based on
// specified rules. For example, a RowFilter might trim down a row to include
// just the cells from columns matching a given regular expression, or might
// return all the cells of a row but not their values. More complicated filters
// can be composed out of these components to express requests such as, "within
// every column of a particular family, give just the two most recent cells
// which are older than timestamp X."
//
// There are two broad categories of RowFilters (true filters and transformers),
// as well as two ways to compose simple filters into more complex ones
// (chains and interleaves). They work as follows:
//
// * True filters alter the input row by excluding some of its cells wholesale
// from the output row. An example of a true filter is the "value_regex_filter",
// which excludes cells whose values don't match the specified pattern. All
// regex true filters use RE2 syntax (https://github.com/google/re2/wiki/Syntax)
// in raw byte mode (RE2::Latin1), and are evaluated as full matches. An
// important point to keep in mind is that RE2(.) is equivalent by default to
// RE2([^\n]), meaning that it does not match newlines. When attempting to match
// an arbitrary byte, you should therefore use the escape sequence '\C', which
// may need to be further escaped as '\\C' in your client language.
//
// * Transformers alter the input row by changing the values of some of its
// cells in the output, without excluding them completely. Currently, the only
// supported transformer is the "strip_value_transformer", which replaces every
// cell's value with the empty string.
//
// * Chains and interleaves are described in more detail in the
// RowFilter.Chain and RowFilter.Interleave documentation.
//
// The total serialized size of a RowFilter message must not
// exceed 4096 bytes, and RowFilters may not be nested within each other
// (in Chains or Interleaves) to a depth of more than 20.
type RowFilter struct {
	// Which of the possible RowFilter types to apply. If none are set, this
	// RowFilter returns all cells in the input row.
	//
	// Types that are valid to be assigned to Filter:
	//	*RowFilter_Chain_
	//	*RowFilter_Interleave_
	//	*RowFilter_Condition_
	//	*RowFilter_Sink
	//	*RowFilter_PassAllFilter
	//	*RowFilter_BlockAllFilter
	//	*RowFilter_RowKeyRegexFilter
	//	*RowFilter_RowSampleFilter
	//	*RowFilter_FamilyNameRegexFilter
	//	*RowFilter_ColumnQualifierRegexFilter
	//	*RowFilter_ColumnRangeFilter
	//	*RowFilter_TimestampRangeFilter
	//	*RowFilter_ValueRegexFilter
	//	*RowFilter_ValueRangeFilter
	//	*RowFilter_CellsPerRowOffsetFilter
	//	*RowFilter_CellsPerRowLimitFilter
	//	*RowFilter_CellsPerColumnLimitFilter
	//	*RowFilter_StripValueTransformer
	//	*RowFilter_ApplyLabelTransformer
	Filter isRowFilter_Filter `protobuf_oneof:"filter"`
}

func (m *RowFilter) Reset()         { *m = RowFilter{} }
func (m *RowFilter) String() string { return proto.CompactTextString(m) }
func (*RowFilter) ProtoMessage()    {}

type isRowFilter_Filter interface {
	isRowFilter_Filter()
}

type RowFilter_Chain_ struct {
	Chain *RowFilter_Chain `protobuf:"bytes,1,opt,name=chain,oneof"`
}
type RowFilter_Interleave_ struct {
	Interleave *RowFilter_Interleave `protobuf:"bytes,2,opt,name=interleave,oneof"`
}
type RowFilter_Condition_ struct {
	Condition *RowFilter_Condition `protobuf:"bytes,3,opt,name=condition,oneof"`
}
type RowFilter_Sink struct {
	Sink bool `protobuf:"varint,16,opt,name=sink,oneof"`
}
type RowFilter_PassAllFilter struct {
	PassAllFilter bool `protobuf:"varint,17,opt,name=pass_all_filter,oneof"`
}
type RowFilter_BlockAllFilter struct {
	BlockAllFilter bool `protobuf:"varint,18,opt,name=block_all_filter,oneof"`
}
type RowFilter_RowKeyRegexFilter struct {
	RowKeyRegexFilter []byte `protobuf:"bytes,4,opt,name=row_key_regex_filter,proto3,oneof"`
}
type RowFilter_RowSampleFilter struct {
	RowSampleFilter float64 `protobuf:"fixed64,14,opt,name=row_sample_filter,oneof"`
}
type RowFilter_FamilyNameRegexFilter struct {
	FamilyNameRegexFilter string `protobuf:"bytes,5,opt,name=family_name_regex_filter,oneof"`
}
type RowFilter_ColumnQualifierRegexFilter struct {
	ColumnQualifierRegexFilter []byte `protobuf:"bytes,6,opt,name=column_qualifier_regex_filter,proto3,oneof"`
}
type RowFilter_ColumnRangeFilter struct {
	ColumnRangeFilter *ColumnRange `protobuf:"bytes,7,opt,name=column_range_filter,oneof"`
}
type RowFilter_TimestampRangeFilter struct {
	TimestampRangeFilter *TimestampRange `protobuf:"bytes,8,opt,name=timestamp_range_filter,oneof"`
}
type RowFilter_ValueRegexFilter struct {
	ValueRegexFilter []byte `protobuf:"bytes,9,opt,name=value_regex_filter,proto3,oneof"`
}
type RowFilter_ValueRangeFilter struct {
	ValueRangeFilter *ValueRange `protobuf:"bytes,15,opt,name=value_range_filter,oneof"`
}
type RowFilter_CellsPerRowOffsetFilter struct {
	CellsPerRowOffsetFilter int32 `protobuf:"varint,10,opt,name=cells_per_row_offset_filter,oneof"`
}
type RowFilter_CellsPerRowLimitFilter struct {
	CellsPerRowLimitFilter int32 `protobuf:"varint,11,opt,name=cells_per_row_limit_filter,oneof"`
}
type RowFilter_CellsPerColumnLimitFilter struct {
	CellsPerColumnLimitFilter int32 `protobuf:"varint,12,opt,name=cells_per_column_limit_filter,oneof"`
}
type RowFilter_StripValueTransformer struct {
	StripValueTransformer bool `protobuf:"varint,13,opt,name=strip_value_transformer,oneof"`
}
type RowFilter_ApplyLabelTransformer struct {
	ApplyLabelTransformer string `protobuf:"bytes,19,opt,name=apply_label_transformer,oneof"`
}

func (*RowFilter_Chain_) isRowFilter_Filter()                     {}
func (*RowFilter_Interleave_) isRowFilter_Filter()                {}
func (*RowFilter_Condition_) isRowFilter_Filter()                 {}
func (*RowFilter_Sink) isRowFilter_Filter()                       {}
func (*RowFilter_PassAllFilter) isRowFilter_Filter()              {}
func (*RowFilter_BlockAllFilter) isRowFilter_Filter()             {}
func (*RowFilter_RowKeyRegexFilter) isRowFilter_Filter()          {}
func (*RowFilter_RowSampleFilter) isRowFilter_Filter()            {}
func (*RowFilter_FamilyNameRegexFilter) isRowFilter_Filter()      {}
func (*RowFilter_ColumnQualifierRegexFilter) isRowFilter_Filter() {}
func (*RowFilter_ColumnRangeFilter) isRowFilter_Filter()          {}
func (*RowFilter_TimestampRangeFilter) isRowFilter_Filter()       {}
func (*RowFilter_ValueRegexFilter) isRowFilter_Filter()           {}
func (*RowFilter_ValueRangeFilter) isRowFilter_Filter()           {}
func (*RowFilter_CellsPerRowOffsetFilter) isRowFilter_Filter()    {}
func (*RowFilter_CellsPerRowLimitFilter) isRowFilter_Filter()     {}
func (*RowFilter_CellsPerColumnLimitFilter) isRowFilter_Filter()  {}
func (*RowFilter_StripValueTransformer) isRowFilter_Filter()      {}
func (*RowFilter_ApplyLabelTransformer) isRowFilter_Filter()      {}

func (m *RowFilter) GetFilter() isRowFilter_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *RowFilter) GetChain() *RowFilter_Chain {
	if x, ok := m.GetFilter().(*RowFilter_Chain_); ok {
		return x.Chain
	}
	return nil
}

func (m *RowFilter) GetInterleave() *RowFilter_Interleave {
	if x, ok := m.GetFilter().(*RowFilter_Interleave_); ok {
		return x.Interleave
	}
	return nil
}

func (m *RowFilter) GetCondition() *RowFilter_Condition {
	if x, ok := m.GetFilter().(*RowFilter_Condition_); ok {
		return x.Condition
	}
	return nil
}

func (m *RowFilter) GetSink() bool {
	if x, ok := m.GetFilter().(*RowFilter_Sink); ok {
		return x.Sink
	}
	return false
}

func (m *RowFilter) GetPassAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_PassAllFilter); ok {
		return x.PassAllFilter
	}
	return false
}

func (m *RowFilter) GetBlockAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_BlockAllFilter); ok {
		return x.BlockAllFilter
	}
	return false
}

func (m *RowFilter) GetRowKeyRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_RowKeyRegexFilter); ok {
		return x.RowKeyRegexFilter
	}
	return nil
}

func (m *RowFilter) GetRowSampleFilter() float64 {
	if x, ok := m.GetFilter().(*RowFilter_RowSampleFilter); ok {
		return x.RowSampleFilter
	}
	return 0
}

func (m *RowFilter) GetFamilyNameRegexFilter() string {
	if x, ok := m.GetFilter().(*RowFilter_FamilyNameRegexFilter); ok {
		return x.FamilyNameRegexFilter
	}
	return ""
}

func (m *RowFilter) GetColumnQualifierRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ColumnQualifierRegexFilter); ok {
		return x.ColumnQualifierRegexFilter
	}
	return nil
}

func (m *RowFilter) GetColumnRangeFilter() *ColumnRange {
	if x, ok := m.GetFilter().(*RowFilter_ColumnRangeFilter); ok {
		return x.ColumnRangeFilter
	}
	return nil
}

func (m *RowFilter) GetTimestampRangeFilter() *TimestampRange {
	if x, ok := m.GetFilter().(*RowFilter_TimestampRangeFilter); ok {
		return x.TimestampRangeFilter
	}
	return nil
}

func (m *RowFilter) GetValueRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ValueRegexFilter); ok {
		return x.ValueRegexFilter
	}
	return nil
}

func (m *RowFilter) GetValueRangeFilter() *ValueRange {
	if x, ok := m.GetFilter().(*RowFilter_ValueRangeFilter); ok {
		return x.ValueRangeFilter
	}
	return nil
}

func (m *RowFilter) GetCellsPerRowOffsetFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowOffsetFilter); ok {
		return x.CellsPerRowOffsetFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerRowLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowLimitFilter); ok {
		return x.CellsPerRowLimitFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerColumnLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerColumnLimitFilter); ok {
		return x.CellsPerColumnLimitFilter
	}
	return 0
}

func (m *RowFilter) GetStripValueTransformer() bool {
	if x, ok := m.GetFilter().(*RowFilter_StripValueTransformer); ok {
		return x.StripValueTransformer
	}
	return false
}

func (m *RowFilter) GetApplyLabelTransformer() string {
	if x, ok := m.GetFilter().(*RowFilter_ApplyLabelTransformer); ok {
		return x.ApplyLabelTransformer
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RowFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _RowFilter_OneofMarshaler, _RowFilter_OneofUnmarshaler, []interface{}{
		(*RowFilter_Chain_)(nil),
		(*RowFilter_Interleave_)(nil),
		(*RowFilter_Condition_)(nil),
		(*RowFilter_Sink)(nil),
		(*RowFilter_PassAllFilter)(nil),
		(*RowFilter_BlockAllFilter)(nil),
		(*RowFilter_RowKeyRegexFilter)(nil),
		(*RowFilter_RowSampleFilter)(nil),
		(*RowFilter_FamilyNameRegexFilter)(nil),
		(*RowFilter_ColumnQualifierRegexFilter)(nil),
		(*RowFilter_ColumnRangeFilter)(nil),
		(*RowFilter_TimestampRangeFilter)(nil),
		(*RowFilter_ValueRegexFilter)(nil),
		(*RowFilter_ValueRangeFilter)(nil),
		(*RowFilter_CellsPerRowOffsetFilter)(nil),
		(*RowFilter_CellsPerRowLimitFilter)(nil),
		(*RowFilter_CellsPerColumnLimitFilter)(nil),
		(*RowFilter_StripValueTransformer)(nil),
		(*RowFilter_ApplyLabelTransformer)(nil),
	}
}

func _RowFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RowFilter)
	// filter
	switch x := m.Filter.(type) {
	case *RowFilter_Chain_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Chain); err != nil {
			return err
		}
	case *RowFilter_Interleave_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Interleave); err != nil {
			return err
		}
	case *RowFilter_Condition_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Condition); err != nil {
			return err
		}
	case *RowFilter_Sink:
		t := uint64(0)
		if x.Sink {
			t = 1
		}
		b.EncodeVarint(16<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_PassAllFilter:
		t := uint64(0)
		if x.PassAllFilter {
			t = 1
		}
		b.EncodeVarint(17<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_BlockAllFilter:
		t := uint64(0)
		if x.BlockAllFilter {
			t = 1
		}
		b.EncodeVarint(18<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_RowKeyRegexFilter:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.RowKeyRegexFilter)
	case *RowFilter_RowSampleFilter:
		b.EncodeVarint(14<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.RowSampleFilter))
	case *RowFilter_FamilyNameRegexFilter:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.FamilyNameRegexFilter)
	case *RowFilter_ColumnQualifierRegexFilter:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ColumnQualifierRegexFilter)
	case *RowFilter_ColumnRangeFilter:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ColumnRangeFilter); err != nil {
			return err
		}
	case *RowFilter_TimestampRangeFilter:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampRangeFilter); err != nil {
			return err
		}
	case *RowFilter_ValueRegexFilter:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ValueRegexFilter)
	case *RowFilter_ValueRangeFilter:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValueRangeFilter); err != nil {
			return err
		}
	case *RowFilter_CellsPerRowOffsetFilter:
		b.EncodeVarint(10<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerRowOffsetFilter))
	case *RowFilter_CellsPerRowLimitFilter:
		b.EncodeVarint(11<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerRowLimitFilter))
	case *RowFilter_CellsPerColumnLimitFilter:
		b.EncodeVarint(12<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerColumnLimitFilter))
	case *RowFilter_StripValueTransformer:
		t := uint64(0)
		if x.StripValueTransformer {
			t = 1
		}
		b.EncodeVarint(13<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_ApplyLabelTransformer:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ApplyLabelTransformer)
	case nil:
	default:
		return fmt.Errorf("RowFilter.Filter has unexpected type %T", x)
	}
	return nil
}

func _RowFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RowFilter)
	switch tag {
	case 1: // filter.chain
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Chain)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Chain_{msg}
		return true, err
	case 2: // filter.interleave
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Interleave)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Interleave_{msg}
		return true, err
	case 3: // filter.condition
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Condition)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Condition_{msg}
		return true, err
	case 16: // filter.sink
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_Sink{x != 0}
		return true, err
	case 17: // filter.pass_all_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_PassAllFilter{x != 0}
		return true, err
	case 18: // filter.block_all_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_BlockAllFilter{x != 0}
		return true, err
	case 4: // filter.row_key_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_RowKeyRegexFilter{x}
		return true, err
	case 14: // filter.row_sample_filter
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Filter = &RowFilter_RowSampleFilter{math.Float64frombits(x)}
		return true, err
	case 5: // filter.family_name_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Filter = &RowFilter_FamilyNameRegexFilter{x}
		return true, err
	case 6: // filter.column_qualifier_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_ColumnQualifierRegexFilter{x}
		return true, err
	case 7: // filter.column_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ColumnRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_ColumnRangeFilter{msg}
		return true, err
	case 8: // filter.timestamp_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TimestampRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_TimestampRangeFilter{msg}
		return true, err
	case 9: // filter.value_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_ValueRegexFilter{x}
		return true, err
	case 15: // filter.value_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ValueRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_ValueRangeFilter{msg}
		return true, err
	case 10: // filter.cells_per_row_offset_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerRowOffsetFilter{int32(x)}
		return true, err
	case 11: // filter.cells_per_row_limit_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerRowLimitFilter{int32(x)}
		return true, err
	case 12: // filter.cells_per_column_limit_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerColumnLimitFilter{int32(x)}
		return true, err
	case 13: // filter.strip_value_transformer
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_StripValueTransformer{x != 0}
		return true, err
	case 19: // filter.apply_label_transformer
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Filter = &RowFilter_ApplyLabelTransformer{x}
		return true, err
	default:
		return false, nil
	}
}

// A RowFilter which sends rows through several RowFilters in sequence.
type RowFilter_Chain struct {
	// The elements of "filters" are chained together to process the input row:
	// in row -> f(0) -> intermediate row -> f(1) -> ... -> f(N) -> out row
	// The full chain is executed atomically.
	Filters []*RowFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
}

func (m *RowFilter_Chain) Reset()         { *m = RowFilter_Chain{} }
func (m *RowFilter_Chain) String() string { return proto.CompactTextString(m) }
func (*RowFilter_Chain) ProtoMessage()    {}

func (m *RowFilter_Chain) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which sends each row to each of several component
// RowFilters and interleaves the results.
type RowFilter_Interleave struct {
	// The elements of "filters" all process a copy of the input row, and the
	// results are pooled, sorted, and combined into a single output row.
	// If multiple cells are produced with the same column and timestamp,
	// they will all appear in the output row in an unspecified mutual order.
	// Consider the following example, with three filters:
	//
	//                              input row
	//                                  |
	//        -----------------------------------------------------
	//        |                         |                         |
	//       f(0)                      f(1)                      f(2)
	//        |                         |                         |
	// 1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
	// 2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
	//        |                         |                         |
	//        -----------------------------------------------------
	//                                  |
	// 1:                        foo,bar,10,z     // could have switched with #2
	// 2:                        foo,bar,10,x     // could have switched with #1
	// 3:                        foo,blah,11,z
	// 4:                        far,bar,7,a
	// 5:                        far,blah,5,x     // identical to #6
	// 6:                        far,blah,5,x     // identical to #5
	// All interleaved filters are executed atomically.
	Filters []*RowFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
}

func (m *RowFilter_Interleave) Reset()         { *m = RowFilter_Interleave{} }
func (m *RowFilter_Interleave) String() string { return proto.CompactTextString(m) }
func (*RowFilter_Interleave) ProtoMessage()    {}

func (m *RowFilter_Interleave) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which evaluates one of two possible RowFilters, depending on
// whether or not a predicate RowFilter outputs any cells from the input row.
//
// IMPORTANT NOTE: The predicate filter does not execute atomically with the
// true and false filters, which may lead to inconsistent or unexpected
// results. Additionally, Condition filters have poor performance, especially
// when filters are set for the false condition.
type RowFilter_Condition struct {
	// If "predicate_filter" outputs any cells, then "true_filter" will be
	// evaluated on the input row. Otherwise, "false_filter" will be evaluated.
	PredicateFilter *RowFilter `protobuf:"bytes,1,opt,name=predicate_filter" json:"predicate_filter,omitempty"`
	// The filter to apply to the input row if "predicate_filter" returns any
	// results. If not provided, no results will be returned in the true case.
	TrueFilter *RowFilter `protobuf:"bytes,2,opt,name=true_filter" json:"true_filter,omitempty"`
	// The filter to apply to the input row if "predicate_filter" does not
	// return any results. If not provided, no results will be returned in the
	// false case.
	FalseFilter *RowFilter `protobuf:"bytes,3,opt,name=false_filter" json:"false_filter,omitempty"`
}

func (m *RowFilter_Condition) Reset()         { *m = RowFilter_Condition{} }
func (m *RowFilter_Condition) String() string { return proto.CompactTextString(m) }
func (*RowFilter_Condition) ProtoMessage()    {}

func (m *RowFilter_Condition) GetPredicateFilter() *RowFilter {
	if m != nil {
		return m.PredicateFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetTrueFilter() *RowFilter {
	if m != nil {
		return m.TrueFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetFalseFilter() *RowFilter {
	if m != nil {
		return m.FalseFilter
	}
	return nil
}

// Specifies a particular change to be made to the contents of a row.
type Mutation struct {
	// Which of the possible Mutation types to apply.
	//
	// Types that are valid to be assigned to Mutation:
	//	*Mutation_SetCell_
	//	*Mutation_DeleteFromColumn_
	//	*Mutation_DeleteFromFamily_
	//	*Mutation_DeleteFromRow_
	Mutation isMutation_Mutation `protobuf_oneof:"mutation"`
}

func (m *Mutation) Reset()         { *m = Mutation{} }
func (m *Mutation) String() string { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()    {}

type isMutation_Mutation interface {
	isMutation_Mutation()
}

type Mutation_SetCell_ struct {
	SetCell *Mutation_SetCell `protobuf:"bytes,1,opt,name=set_cell,oneof"`
}
type Mutation_DeleteFromColumn_ struct {
	DeleteFromColumn *Mutation_DeleteFromColumn `protobuf:"bytes,2,opt,name=delete_from_column,oneof"`
}
type Mutation_DeleteFromFamily_ struct {
	DeleteFromFamily *Mutation_DeleteFromFamily `protobuf:"bytes,3,opt,name=delete_from_family,oneof"`
}
type Mutation_DeleteFromRow_ struct {
	DeleteFromRow *Mutation_DeleteFromRow `protobuf:"bytes,4,opt,name=delete_from_row,oneof"`
}

func (*Mutation_SetCell_) isMutation_Mutation()          {}
func (*Mutation_DeleteFromColumn_) isMutation_Mutation() {}
func (*Mutation_DeleteFromFamily_) isMutation_Mutation() {}
func (*Mutation_DeleteFromRow_) isMutation_Mutation()    {}

func (m *Mutation) GetMutation() isMutation_Mutation {
	if m != nil {
		return m.Mutation
	}
	return nil
}

func (m *Mutation) GetSetCell() *Mutation_SetCell {
	if x, ok := m.GetMutation().(*Mutation_SetCell_); ok {
		return x.SetCell
	}
	return nil
}

func (m *Mutation) GetDeleteFromColumn() *Mutation_DeleteFromColumn {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromColumn_); ok {
		return x.DeleteFromColumn
	}
	return nil
}

func (m *Mutation) GetDeleteFromFamily() *Mutation_DeleteFromFamily {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromFamily_); ok {
		return x.DeleteFromFamily
	}
	return nil
}

func (m *Mutation) GetDeleteFromRow() *Mutation_DeleteFromRow {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromRow_); ok {
		return x.DeleteFromRow
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Mutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _Mutation_OneofMarshaler, _Mutation_OneofUnmarshaler, []interface{}{
		(*Mutation_SetCell_)(nil),
		(*Mutation_DeleteFromColumn_)(nil),
		(*Mutation_DeleteFromFamily_)(nil),
		(*Mutation_DeleteFromRow_)(nil),
	}
}

func _Mutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Mutation)
	// mutation
	switch x := m.Mutation.(type) {
	case *Mutation_SetCell_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SetCell); err != nil {
			return err
		}
	case *Mutation_DeleteFromColumn_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromColumn); err != nil {
			return err
		}
	case *Mutation_DeleteFromFamily_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromFamily); err != nil {
			return err
		}
	case *Mutation_DeleteFromRow_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromRow); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Mutation.Mutation has unexpected type %T", x)
	}
	return nil
}

func _Mutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Mutation)
	switch tag {
	case 1: // mutation.set_cell
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_SetCell)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_SetCell_{msg}
		return true, err
	case 2: // mutation.delete_from_column
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromColumn)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromColumn_{msg}
		return true, err
	case 3: // mutation.delete_from_family
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromFamily)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromFamily_{msg}
		return true, err
	case 4: // mutation.delete_from_row
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromRow)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromRow_{msg}
		return true, err
	default:
		return false, nil
	}
}

// A Mutation which sets the value of the specified cell.
type Mutation_SetCell struct {
	// The name of the family into which new data should be written.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
	// The qualifier of the column into which new data should be written.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,proto3" json:"column_qualifier,omitempty"`
	// The timestamp of the cell into which new data should be written.
	// Use -1 for current Bigtable server time.
	// Otherwise, the client should set this value itself, noting that the
	// default value is a timestamp of zero if the field is left unspecified.
	// Values must match the "granularity" of the table (e.g. micros, millis).
	TimestampMicros int64 `protobuf:"varint,3,opt,name=timestamp_micros" json:"timestamp_micros,omitempty"`
	// The value to be written into the specified cell.
	Value []byte `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Mutation_SetCell) Reset()         { *m = Mutation_SetCell{} }
func (m *Mutation_SetCell) String() string { return proto.CompactTextString(m) }
func (*Mutation_SetCell) ProtoMessage()    {}

// A Mutation which deletes cells from the specified column, optionally
// restricting the deletions to a given timestamp range.
type Mutation_DeleteFromColumn struct {
	// The name of the family from which cells should be deleted.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
	// The qualifier of the column from which cells should be deleted.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,proto3" json:"column_qualifier,omitempty"`
	// The range of timestamps within which cells should be deleted.
	TimeRange *TimestampRange `protobuf:"bytes,3,opt,name=time_range" json:"time_range,omitempty"`
}

func (m *Mutation_DeleteFromColumn) Reset()         { *m = Mutation_DeleteFromColumn{} }
func (m *Mutation_DeleteFromColumn) String() string { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromColumn) ProtoMessage()    {}

func (m *Mutation_DeleteFromColumn) GetTimeRange() *TimestampRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

// A Mutation which deletes all cells from the specified column family.
type Mutation_DeleteFromFamily struct {
	// The name of the family from which cells should be deleted.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
}

func (m *Mutation_DeleteFromFamily) Reset()         { *m = Mutation_DeleteFromFamily{} }
func (m *Mutation_DeleteFromFamily) String() string { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromFamily) ProtoMessage()    {}

// A Mutation which deletes all cells from the containing row.
type Mutation_DeleteFromRow struct {
}

func (m *Mutation_DeleteFromRow) Reset()         { *m = Mutation_DeleteFromRow{} }
func (m *Mutation_DeleteFromRow) String() string { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromRow) ProtoMessage()    {}

// Specifies an atomic read/modify/write operation on the latest value of the
// specified column.
type ReadModifyWriteRule struct {
	// The name of the family to which the read/modify/write should be applied.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name" json:"family_name,omitempty"`
	// The qualifier of the column to which the read/modify/write should be
	// applied.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,proto3" json:"column_qualifier,omitempty"`
	// The rule used to determine the column's new latest value from its current
	// latest value.
	//
	// Types that are valid to be assigned to Rule:
	//	*ReadModifyWriteRule_AppendValue
	//	*ReadModifyWriteRule_IncrementAmount
	Rule isReadModifyWriteRule_Rule `protobuf_oneof:"rule"`
}

func (m *ReadModifyWriteRule) Reset()         { *m = ReadModifyWriteRule{} }
func (m *ReadModifyWriteRule) String() string { return proto.CompactTextString(m) }
func (*ReadModifyWriteRule) ProtoMessage()    {}

type isReadModifyWriteRule_Rule interface {
	isReadModifyWriteRule_Rule()
}

type ReadModifyWriteRule_AppendValue struct {
	AppendValue []byte `protobuf:"bytes,3,opt,name=append_value,proto3,oneof"`
}
type ReadModifyWriteRule_IncrementAmount struct {
	IncrementAmount int64 `protobuf:"varint,4,opt,name=increment_amount,oneof"`
}

func (*ReadModifyWriteRule_AppendValue) isReadModifyWriteRule_Rule()     {}
func (*ReadModifyWriteRule_IncrementAmount) isReadModifyWriteRule_Rule() {}

func (m *ReadModifyWriteRule) GetRule() isReadModifyWriteRule_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *ReadModifyWriteRule) GetAppendValue() []byte {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_AppendValue); ok {
		return x.AppendValue
	}
	return nil
}

func (m *ReadModifyWriteRule) GetIncrementAmount() int64 {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_IncrementAmount); ok {
		return x.IncrementAmount
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadModifyWriteRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), []interface{}) {
	return _ReadModifyWriteRule_OneofMarshaler, _ReadModifyWriteRule_OneofUnmarshaler, []interface{}{
		(*ReadModifyWriteRule_AppendValue)(nil),
		(*ReadModifyWriteRule_IncrementAmount)(nil),
	}
}

func _ReadModifyWriteRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadModifyWriteRule)
	// rule
	switch x := m.Rule.(type) {
	case *ReadModifyWriteRule_AppendValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AppendValue)
	case *ReadModifyWriteRule_IncrementAmount:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IncrementAmount))
	case nil:
	default:
		return fmt.Errorf("ReadModifyWriteRule.Rule has unexpected type %T", x)
	}
	return nil
}

func _ReadModifyWriteRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadModifyWriteRule)
	switch tag {
	case 3: // rule.append_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Rule = &ReadModifyWriteRule_AppendValue{x}
		return true, err
	case 4: // rule.increment_amount
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Rule = &ReadModifyWriteRule_IncrementAmount{int64(x)}
		return true, err
	default:
		return false, nil
	}
}
