<!--[metadata]>
+++
title = "S3 storage driver"
description = "Explains how to use the S3 storage drivers"
keywords = ["registry, service, driver, images, storage,  S3"]
+++
<![end-metadata]-->


# S3 storage driver

An implementation of the `storagedriver.StorageDriver` interface which uses Amazon S3 for object storage.

## Parameters

`accesskey`: Your aws access key.

`secretkey`: Your aws secret key.

**Note** You can provide empty strings for your access and secret keys if you plan on running the driver on an ec2 instance and will handle authentication with the instance's credentials.

`region`: The name of the aws region in which you would like to store objects (for example `us-east-1`). For a list of regions, you can look at http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html

`bucket`: The name of your s3 bucket where you wish to store objects (needs to already be created prior to driver initialization).

`encrypt`: (optional) Whether you would like your data encrypted on the server side (defaults to false if not specified).

`secure`: (optional) Whether you would like to transfer data to the bucket over ssl or not. Defaults to true (meaning transferring over ssl) if not specified. Note that while setting this to false will improve performance, it is not recommended due to security concerns.

`v4auth`: (optional) Whether you would like to use aws signature version 4 with your requests. This defaults to true if not specified (note that the eu-central-1 region does not work with version 2 signatures, so the driver will error out if initialized with this region and v4auth set to false)

`chunksize`: (optional) The default part size for multipart uploads (performed by WriteStream) to s3. The default is 10 MB. Keep in mind that the minimum part size for s3 is 5MB. You might experience better performance for larger chunk sizes depending on the speed of your connection to s3.

`rootdirectory`: (optional) The root directory tree in which all registry files will be stored. Defaults to the empty string (bucket root).
