"#\n"
"# Below is a stripped down version of bib2xhtml used by doxygen.\n"
"# For the full version see http://www.spinellis.gr/sw/textproc/bib2xhtml/\n"
"#\n"
"# Convert from bibtex to XHTML.\n"
"#\n"
"# (C) Copyright 1995, 1996 David Hull.\n"
"# (David Hull / hull@cs.uiuc.edu / http://www.uiuc.edu/ph/www/dlhull)\n"
"#\n"
"# (C) Copyright 2002-2010 Diomidis Spinellis\n"
"# http://www.spinellis.gr\n"
"#\n"
"# This program is free software.  You can redistribute it and/or modify\n"
"# it under the terms of the GNU General Public License.  See the\n"
"# files README and COPYING for details.\n"
"#\n"
"# This source code contains UTF-8 characters.  You might want to use\n"
"# an appropriate editor, if you want to view/modify the LaTeX to Unicode\n"
"# substitution commands.\n"
"#\n"
"\n"
"use Getopt::Std;\n"
"use open IO => ':crlf';\n"
"$label_styles{'numbered'} = 	$LABEL_NUMBERED = 	2;\n"
"$list_start[$LABEL_NUMBERED] = 'dl class=\"citelist\"';\n"
"$list_end[$LABEL_NUMBERED] = \"/dl\";\n"
"@tmpfiles = ();\n"
"sub html_ent {\n"
"	s/\\\\i\\b/i/g;\n"
"	s/\\\\\\'(\\001\\d+)\\{([AEIOUaeiou])\\1\\}/&$2acute;/gs;\n"
"	s/\\\\\\'([AEIOUaeiou])/&$1acute;/g;\n"
"	s/\\\\\\`(\\001\\d+)\\{([AEIOUaeiou])\\1\\}/&$2grave;/gs;\n"
"	s/\\\\\\`([AEIOUaeiou])/&$1grave;/g;\n"
"	s/\\\\\\\"(\\001\\d+)\\{([AEIOUaeiouy])\\1\\}/&$2uml;/gs;\n"
"	s/\\\\\\\"([AEIOUaeiouy])/&$1uml;/g;\n"
"	s/\\\\\\~(\\001\\d+)\\{([ANOano])\\1\\}/&$2tilde;/gs;\n"
"	s/\\\\\\~([ANOano])/&$1tilde;/g;\n"
"	s/\\\\\\^(\\001\\d+)\\{([AEIOUaeiou])\\1\\}/&$2circ;/gs;\n"
"	s/\\\\\\^([AEIOUaeiou])/&$1circ;/g;\n"
"	s/\\\\c(\\001\\d+)\\{([Cc])\\1\\}/&$2cedil;/gs;\n"
"	s/\\\\u(\\001\\d+)\\{(.)\\1\\}/$2/gs;\n"
"	s/\\\\v(\\001\\d+)\\{(.)\\1\\}/$2/gs;\n"
"	s/\\\\([lL])\\b/$1/g;\n"
"	s/\\\\\\=(\\001\\d+)\\{(.)\\1\\}/$2/gs;\n"
"	s/\\\\\\=(.)/$1/g;\n"
"	s/\\\\\\.(\\001\\d+)\\{(.)\\1\\}/$2/gs;\n"
"	s/\\\\\\.(.)/$1/g;\n"
"	s/\\\\([Oo])\\b\\s*/&$1slash;/g;\n"
"	s/\\\\AA\\b\\s*/&Aring;/g;\n"
"	s/\\\\aa\\b\\s*/&aring;/g;\n"
"	s/\\\\AE\\b\\s*/&AElig;/g;\n"
"	s/\\\\ae\\b\\s*/&aelig;/g;\n"
"	s/\\\\ss\\b\\s*/&szlig;/g;\n"
"	s/\\\\S\\b\\s*/&sect;/g;\n"
"	s/\\\\P\\b\\s*/&para;/g;\n"
"	s/\\\\pounds\\b\\s*/&pound;/g;\n"
"	s/\\?\\`/&iquest;/g;\n"
"	s/\\!\\`/&iexcl;/g;\n"
"	s/\\-\\-\\-/&mdash;/g;\n"
"	s/([^\\!])\\-\\-([^\\>])/$1&ndash;$2/g;\n"
"	s/\\\\([aA]lpha)\\b/&$1;/g;\n"
"	s/\\\\([bB]eta)\\b/&$1;/g;\n"
"	s/\\\\([gG]amma)\\b/&$1;/g;\n"
"	s/\\\\([dD]elta)\\b/&$1;/g;\n"
"	s/\\\\varepsilon\\b/&epsilon;/g;\n"
"	s/\\\\([eE]psilon)\\b/&$1;/g;\n"
"	s/\\\\([zZ]eta)\\b/&$1;/g;\n"
"	s/\\\\([eE]ta)\\b/&$1;/g;\n"
"	s/\\\\([tT]heta)\\b/&$1;/g;\n"
"	s/\\\\vartheta\\b/&theta;/g;\n"
"	s/\\\\([iI]ota)\\b/&$1;/g;\n"
"	s/\\\\([kK]appa)\\b/&$1;/g;\n"
"	s/\\\\([lL]ambda)\\b/&$1;/g;\n"
"	s/\\\\([mM]u)\\b/&$1;/g;\n"
"	s/\\\\([nN]u)\\b/&$1;/g;\n"
"	s/\\\\([xX]i)\\b/&$1;/g;\n"
"	s/\\\\([oO]micron)\\b/&$1;/g;\n"
"	s/\\\\([pP]i)\\b/&$1;/g;\n"
"	s/\\\\varpi\\b/&pi;/g;\n"
"	s/\\\\([rR]ho)\\b/&$1;/g;\n"
"	s/\\\\varrho\\b/&rho;/g;\n"
"	s/\\\\([sS]igma)\\b/&$1;/g;\n"
"	s/\\\\varsigma\\b/&sigmaf;/g;\n"
"	s/\\\\([tT]au)\\b/&$1;/g;\n"
"	s/\\\\([uU]psilon)\\b/&$1;/g;\n"
"	s/\\\\([pP]hi)\\b/&$1;/g;\n"
"	s/\\\\varphi\\b/&phi;/g;\n"
"	s/\\\\([cC]hi)\\b/&$1;/g;\n"
"	s/\\\\([pP]si)\\b/&$1;/g;\n"
"	s/\\\\([oO]mega)\\b/&$1;/g;\n"
"}\n"
"foreach (@ARGV) {\n"
"  if (/\\.bib$/) {\n"
"    $bibfile = $_;\n"
"    $bibfile =~ s/\\.bib$//;\n"
"    push(@bibfiles,$bibfile);\n"
"  } else {\n"
"    $htmlfile = $_;\n"
"  }\n"
"}\n"
"exit(1) unless defined($htmlfile);\n"
"$bibdatacmd=\"\\\\bibdata{\".join(',',@bibfiles).\"}\";\n"
"$label_style = $LABEL_NUMBERED;\n"
"$bstfile = \"doxygen\";\n"
"umask(077);\n"
"open(HTMLFILE,\">$htmlfile$$\");\n"
"if (open(OHTMLFILE, \"$htmlfile\")) {\n"
"    $mode = (stat OHTMLFILE)[2] & 0xfff;\n"
"} else {\n"
"  print \"Error opening $htmlfile\\n\";\n"
"  exit(1);\n"
"}\n"
"$beginstring = \"<!-- BEGIN CITATIONS -->\";\n"
"$endstring = \"<!-- END CITATIONS -->\";\n"
"@citations = ();\n"
"loop:\n"
"while (<OHTMLFILE>) {\n"
"  print HTMLFILE;\n"
"  last loop if m/^$beginstring$/;\n"
"}\n"
"loop:\n"
"while (<OHTMLFILE>) {\n"
"  print HTMLFILE;\n"
"  last loop if m/^$endstring$/;\n"
"  push(@citations, $2) if m/^([^\\\\]*)?(.+\\})(.*)?$/;\n"
"}\n"
"push(@citations, $bibdatacmd);\n"
"$auxfile = \"bib$$\";\n"
"push(@tmpfiles, \"$auxfile.aux\");\n"
"open(AUXFILE, \">$auxfile\" . \".aux\");\n"
"print AUXFILE \"\\\\relax\\n\\\\bibstyle{$bstfile}\\n\";\n"
"foreach $citation (@citations) {\n"
"  print AUXFILE \"$citation\\n\";\n"
"}\n"
"close(AUXFILE);\n"
"push(@tmpfiles, \"$auxfile.blg\");\n"
"push(@tmpfiles, \"$auxfile.bbl\");\n"
"`bibtex $auxfile 2>&1`;\n"
"if ($?==-1)\n"
"{\n"
"  print \"bibtex command failed: $!\\n\";\n"
"}\n"
"$beginstring = \"<!-- BEGIN BIBLIOGRAPHY -->\";\n"
"$endstring = \"<!-- END BIBLIOGRAPHY -->\";\n"
"loop:\n"
"while (<OHTMLFILE>) {\n"
"  last loop if m/^$beginstring$/;\n"
"  print HTMLFILE;\n"
"}\n"
"loop:\n"
"while (<OHTMLFILE>) {\n"
"  last loop if m/^$endstring$/;\n"
"}\n"
"print HTMLFILE \"$beginstring\\n\";\n"
"$t = $auxfile . \".bbl\";\n"
"$/ = \"\";\n"
"open(BBLFILE, \"<$t\") || die \"error opening $t: $!\\n\";\n"
"$nentry = 0;\n"
"loop:\n"
"while (<BBLFILE>) {\n"
"    if (($nentry == 0) && (m/^#/)) {\n"
"	if ((m/#\\s*label-style:\\s*(\\S+)/) && (! defined $label_style)) {\n"
"	    $label_style = $label_styles{$1};\n"
"	    if (! defined $label_style) {\n"
"		print STDERR \"label style unknown: \\n\";\n"
"		next loop;\n"
"	    }\n"
"	}\n"
"	next loop;\n"
"    }\n"
"    $nentry++;\n"
"    ($bcite, $blabel) = m+<dt><a name=\\\"([^\\\"]*)\\\">\\[([^\\]]*)\\]</a></dt><dd>+;\n"
"    $blabel = \"$nentry\";\n"
"    $bibcite{$bcite} = $blabel;\n"
"}\n"
"close(BBLFILE);\n"
"$label_style = $LABEL_DEFAULT if (! defined $label_style);\n"
"$list_start = $list_start[$label_style];\n"
"$list_end = $list_end[$label_style];\n"
"print HTMLFILE \"<$list_start>\\n\\n\";\n"
"open(BBLFILE, \"<$t\") || die \"error opening $t: $!\\n\";\n"
"$nentry = 0;\n"
"loop:\n"
"while (<BBLFILE>) {\n"
"    next loop if (($nentry == 0) && (m/^#/));\n"
"    $nentry++;\n"
"    s/\\\\\\{/\\002/g;\n"
"    s/\\\\\\}/\\003/g;\n"
"    s/\\\\\\$/\\004/g;\n"
"    {\n"
"	local ($c, $l, $z) = (0, 0, ());\n"
"	s/([\\{\\}])/join(\"\",\"\\001\",($1 eq \"\\{\" ? $z[$l++]=$c++ : $z[--$l]),$1)/ge;\n"
"    }\n"
"    s/\\%\\n//g;\n"
"    s/(\\.(<\\/cite>|<\\/a>|\\')+)\\./$1/g;\n"
"    s:(<dt><a name=\\\"[^\\\"]*\\\">\\[)[^\\]]*(\\]</a></dt><dd>):$1$nentry$2:;\n"
"    while (m/(\\\\(cite(label)?)(\\001\\d+)\\{([^\\001]+)\\4\\})/) {\n"
"	$old = $1;\n"
"	$cmd = $2;\n"
"	$doxref = defined($3);\n"
"	$bcite = $5;\n"
"	if (! defined $bibcite{$bcite}) {\n"
"	    $blabel = \" [\" . $bcite . \"]\";\n"
"	} elsif ($doxref) {\n"
"	    $blabel = \" <a href=\\\"#$bcite\\\">[\" . $bibcite{$bcite} . \"]<\\/a>\";\n"
"	} else {\n"
"	    $blabel = \" [\" . $bibcite{$bcite} . \"]\";\n"
"	}\n"
"	$old =~ s/(\\W)/\\\\$1/g;\n"
"	s/\\s*$old/$blabel/g;\n"
"    }\n"
"    s/In (<a href=\\\"[^\\\"]*\\\">)([^\\[]+) \\[(\\2)/In $1\\[$2/;\n"
"    s/\\\\htmladdnormallink(foot)?(\\001\\d+)\\{([^\\001]+)\\2\\}(\\001\\d+)\\{([^\\001]+)\\4\\}/<a href=\"$5\">$3<\\/a>/gs;\n"
"    s/\\&amp;/\\005/g;\n"
"    s/\\\\?&/&amp;/g;\n"
"    s/\\005/&amp;/g;\n"
"    html_ent();\n"
"    while (m/\\\\char([\\'\\\"]?[0-9a-fA-F]+)/) {\n"
"	$o = $r = $1;\n"
"	if ($r =~ s/^\\'//) {\n"
"	    $r = oct($r);\n"
"	} elsif ($r =~ s/^\\\"//) {\n"
"	    $r = hex($r);\n"
"	}\n"
"	s/\\\\char$o\\s*/&#$r;/g;\n"
"    }\n"
"    s/{\\\\etalchar\\001(\\d+)\\{(.)}\\001\\1\\}/$2/g;\n"
"    s/\\\\par\\b/<p \\/>/g;\n"
"    s/\\\\url(\\001\\d+)\\{(.*)\\1\\}/<a href=\"$2\">$2<\\/a>/gs;\n"
"    s/\\\\href(\\001\\d+)\\{(.*)\\1\\}(\\001\\d+)\\{([^\\001]*)\\3\\}/<a href=\"$2\">$4<\\/a>/gs;\n"
"    s/\\\\href(\\001\\d+)\\{(.*)\\1\\}/<a href=\"$2\">$2<\\/a>/gs;\n"
"    s/(\\001\\d+)\\{\\\\rm\\s+(.*)\\1\\}/$2/gs;\n"
"    s/\\\\textrm(\\001\\d+)\\{(.*)\\1\\}/$2/gs;\n"
"    s/(\\001\\d+)\\{\\\\em\\s+(.*)\\1\\}/<em>$2<\\/em>/gs;\n"
"    s/(\\001\\d+)\\{\\\\it\\s+(.*)\\1\\}/<i>$2<\\/i>/gs;\n"
"    s/(\\001\\d+)\\{\\\\bf\\s+(.*)\\1\\}/<b>$2<\\/b>/gs;\n"
"    s/(\\001\\d+)\\{\\\\tt\\s+(.*)\\1\\}/<tt>$2<\\/tt>/gs;\n"
"    s/\\\\emph(\\001\\d+)\\{(.*)\\1\\}/<em>$2<\\/em>/gs;\n"
"    s/\\\\textit(\\001\\d+)\\{(.*)\\1\\}/<i>$2<\\/i>/gs;\n"
"    s/\\\\textbf(\\001\\d+)\\{(.*)\\1\\}/<b>$2<\\/b>/gs;\n"
"    s/\\\\texttt(\\001\\d+)\\{(.*)\\1\\}/<tt>$2<\\/tt>/gs;\n"
"    s/\\\\mathrm(\\001\\d+)\\{(.*)\\1\\}/$2/gs;\n"
"    s/\\\\mathnormal(\\001\\d+)\\{(.*)\\1\\}/$2/gs;\n"
"    s/\\\\mathsf(\\001\\d+)\\{(.*)\\1\\}/$2/gs;\n"
"    s/\\\\mathbf(\\001\\d+)\\{(.*)\\1\\}/<b>$2<\\/b>/gs;\n"
"    s/\\\\mathcal(\\001\\d+)\\{(.*)\\1\\}/<i>$2<\\/i>/gs;\n"
"    s/\\\\mathit(\\001\\d+)\\{(.*)\\1\\}/<i>$2<\\/i>/gs;\n"
"    s/\\\\mathtt(\\001\\d+)\\{(.*)\\1\\}/<tt>$2<\\/tt>/gs;\n"
"    s/\\\\bibxhtmlname(\\001\\d+)\\{(.*)\\1\\}/$2/ges;\n"
"    sub domath {\n"
"      local($t) = @_;\n"
"      $t =~ s/\\^(\\001\\d+)\\{\\\\circ\\1\\}/\\&\\#176;/gs;\n"
"      $t =~ s/\\^\\\\circ/\\&\\#176;/g;\n"
"      $t =~ s/\\^(\\001\\d+)\\{(.*)\\1\\}/<sup>$2<\\/sup>/gs;\n"
"      $t =~ s/\\^(\\w)/<sup>$1<\\/sup>/g;\n"
"      $t =~ s/\\_(\\001\\d+)\\{(.*)\\1\\}/<sub>$2<\\/sub>/gs;\n"
"      $t =~ s/\\_(\\w)/<sub>$1<\\/sub>/g;\n"
"      $t;\n"
"    }\n"
"    s/(\\$([^\\$]+)\\$)/&domath($2)/ge;\n"
"    s/(\\\\\\((([^\\\\]|\\\\[^\\(\\)])+)\\\\\\))/&domath($2)/ge;\n"
"    s/\\\\mbox(\\001\\d+)\\{(.*)\\1\\}/$2/gs;\n"
"    while (s/(\\<a href\\=\\\"[^\"]*?)\\~/$1\\005/g) { ; }\n"
"    s/([^\\\\])~/$1&nbsp;/g;\n"
"    s/\\\\\\,/&thinsp;/g;\n"
"    s/\\\\ldots\\b/&hellip;/g;\n"
"    s/\\\\dots\\b/&hellip;/g;\n"
"    s/\\005/\\~/g;\n"
"    s/\\\\ / /g;\n"
"    s/\\\\textasciitilde\\b\\s*/~/g;\n"
"    s/\\\\([\\#\\&\\%\\~\\_\\^\\|])/$1/g;\n"
"    s/\\\\\\W//g;\n"
"    s/\\001(\\d+)\\{\\\\[A-Za-z]+\\001(\\d+)\\{([^\\001]*)\\001\\2\\}\\001\\1\\}/$3/g;\n"
"    s/\\\\([A-Za-z]+)/ $1 /g;\n"
"    s+In <a href=\\\"[^\\\"]*\\\"></a>++;\n"
"    s/\\001\\d+[\\{\\}]//gs;\n"
"    tr/\\002\\003\\004/{}$/;\n"
"    print HTMLFILE $_;\n"
"}\n"
"close(BBLFILE);\n"
"print HTMLFILE \"<$list_end>\\n\\n$endstring\\n\";\n"
"while (<OHTMLFILE>) {\n"
"  print HTMLFILE;\n"
"}\n"
"close (OHTMLFILE);\n"
"close(HTMLFILE);\n"
"chmod($mode, \"$htmlfile$$\");\n"
"rename(\"$htmlfile$$\", $htmlfile);\n"
"unlink(@tmpfiles);\n"
"exit(0);\n"
