/*
 * Copyright (c) 2000 IBM Deutschland Entwicklung GmbH, IBM Coporation
 * Author: Ulrich Weigand <Ulrich.Weigand@de.ibm.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

[  0] = { 0,	0,		sys_setup,			"setup"			},
[  1] = { 1,	TP|SE,		sys_exit,			"exit"			},
[  2] = { 0,	TP,		sys_fork,			"fork"			},
[  3] = { 3,	TD,		sys_read,			"read"			},
[  4] = { 3,	TD,		sys_write,			"write"			},
[  5] = { 3,	TD|TF,		sys_open,			"open"			},
[  6] = { 1,	TD,		sys_close,			"close"			},
[  7] = { 0,	0,		sys_restart_syscall,		"restart_syscall"	},
[  8] = { 2,	TD|TF,		sys_creat,			"creat"			},
[  9] = { 2,	TF,		sys_link,			"link"			},
[ 10] = { 1,	TF,		sys_unlink,			"unlink"		},
[ 11] = { 3,	TF|TP|SE|SI,	sys_execve,			"execve"		},
[ 12] = { 1,	TF,		sys_chdir,			"chdir"			},
[ 13] = { },
[ 14] = { 3,	TF,		sys_mknod,			"mknod"			},
[ 15] = { 2,	TF,		sys_chmod,			"chmod"			},
[ 16] = { },
[ 17] = { },
[ 18] = { },
[ 19] = { 3,	TD,		sys_lseek,			"lseek"			},
[ 20] = { 0,	0,		sys_getpid,			"getpid"		},
[ 21] = { 5,	TF,		sys_mount,			"mount"			},
[ 22] = { 1,	TF,		sys_umount,			"umount"		},
[ 23] = { },
[ 24] = { },
[ 25] = { },
[ 26] = { 4,	0,		sys_ptrace,			"ptrace"		},
[ 27] = { 1,	0,		sys_alarm,			"alarm"			},
[ 28] = { },
[ 29] = { 0,	TS,		sys_pause,			"pause"			},
[ 30] = { 2,	TF,		sys_utime,			"utime"			},
[ 31] = { },
[ 32] = { },
[ 33] = { 2,	TF,		sys_access,			"access"		},
[ 34] = { 1,	0,		sys_nice,			"nice"			},
[ 35] = { },
[ 36] = { 0,	0,		sys_sync,			"sync"			},
[ 37] = { 2,	TS,		sys_kill,			"kill"			},
[ 38] = { 2,	TF,		sys_rename,			"rename"		},
[ 39] = { 2,	TF,		sys_mkdir,			"mkdir"			},
[ 40] = { 1,	TF,		sys_rmdir,			"rmdir"			},
[ 41] = { 1,	TD,		sys_dup,			"dup"			},
[ 42] = { 1,	TD,		sys_pipe,			"pipe"			},
[ 43] = { 1,	0,		sys_times,			"times"			},
[ 44] = { },
[ 45] = { 1,	TM|SI,		sys_brk,			"brk"			},
[ 46] = { },
[ 47] = { },
[ 48] = { 3,	TS,		sys_signal,			"signal"		},
[ 49] = { },
[ 50] = { },
[ 51] = { 1,	TF,		sys_acct,			"acct"			},
[ 52] = { 2,	TF,		sys_umount2,			"umount2"		},
[ 53] = { },
[ 54] = { 3,	TD,		sys_ioctl,			"ioctl"			},
[ 55] = { 3,	TD,		sys_fcntl,			"fcntl"			},
[ 56] = { },
[ 57] = { 2,	0,		sys_setpgid,			"setpgid"		},
[ 58] = { },
[ 59] = { },
[ 60] = { 1,	0,		sys_umask,			"umask"			},
[ 61] = { 1,	TF,		sys_chroot,			"chroot"		},
[ 62] = { 2,	0,		sys_ustat,			"ustat"			},
[ 63] = { 2,	TD,		sys_dup2,			"dup2"			},
[ 64] = { 0,	0,		sys_getppid,			"getppid"		},
[ 65] = { 0,	0,		sys_getpgrp,			"getpgrp"		},
[ 66] = { 0,	0,		sys_setsid,			"setsid"		},
[ 67] = { 3,	TS,		sys_sigaction,			"sigaction"		},
[ 68 ... 71] = { },
[ 72] = { 3,	TS,		sys_sigsuspend,			"sigsuspend"		},
[ 73] = { 1,	TS,		sys_sigpending,			"sigpending"		},
[ 74] = { 2,	0,		sys_sethostname,		"sethostname"		},
[ 75] = { 2,	0,		sys_setrlimit,			"setrlimit"		},
[ 76] = { },
[ 77] = { 2,	0,		sys_getrusage,			"getrusage"		},
[ 78] = { 2,	0,		sys_gettimeofday,		"gettimeofday"		},
[ 79] = { 2,	0,		sys_settimeofday,		"settimeofday"		},
[ 80 ... 82] = { },
[ 83] = { 2,	TF,		sys_symlink,			"symlink"		},
[ 84] = { },
[ 85] = { 3,	TF,		sys_readlink,			"readlink"		},
[ 86] = { 1,	TF,		sys_uselib,			"uselib"		},
[ 87] = { 2,	TF,		sys_swapon,			"swapon"		},
[ 88] = { 4,	0,		sys_reboot,			"reboot"		},
[ 89] = { 3,	TD,		sys_readdir,			"readdir"		},
[ 90] = { 1,	TD|TM|SI,	sys_old_mmap,			"mmap"			},
[ 91] = { 2,	TM|SI,		sys_munmap,			"munmap"		},
[ 92] = { 2,	TF,		sys_truncate,			"truncate"		},
[ 93] = { 2,	TD,		sys_ftruncate,			"ftruncate"		},
[ 94] = { 2,	TD,		sys_fchmod,			"fchmod"		},
[ 95] = { },
[ 96] = { 2,	0,		sys_getpriority,		"getpriority"		},
[ 97] = { 3,	0,		sys_setpriority,		"setpriority"		},
[ 98] = { },
[ 99] = { 2,	TF,		sys_statfs,			"statfs"		},
[100] = { 2,	TD,		sys_fstatfs,			"fstatfs"		},
[101] = { },
[102] = { 2,	TD,		sys_socketcall,			"socketcall"		},
[103] = { 3,	0,		sys_syslog,			"syslog"		},
[104] = { 3,	0,		sys_setitimer,			"setitimer"		},
[105] = { 2,	0,		sys_getitimer,			"getitimer"		},
[106] = { 2,	TF,		sys_stat,			"stat"			},
[107] = { 2,	TF,		sys_lstat,			"lstat"			},
[108] = { 2,	TD,		sys_fstat,			"fstat"			},
[109] = { },
[110] = { 3,	0,		sys_lookup_dcookie,		"lookup_dcookie"	},
[111] = { 0,	0,		sys_vhangup,			"vhangup"		},
[112] = { 0,	0,		sys_idle,			"idle"			},
[113] = { },
[114] = { 4,	TP,		sys_wait4,			"wait4"			},
[115] = { 1,	TF,		sys_swapoff,			"swapoff"		},
[116] = { 1,	0,		sys_sysinfo,			"sysinfo"		},
[117] = { 5,	TI,		sys_ipc,			"ipc"			},
[118] = { 1,	TD,		sys_fsync,			"fsync"			},
[119] = { 0,	TS,		sys_sigreturn,			"sigreturn"		},
[120] = { 5,	TP,		sys_clone,			"clone"			},
[121] = { 2,	0,		sys_setdomainname,		"setdomainname"		},
[122] = { 1,	0,		sys_uname,			"uname"			},
[123] = { },
[124] = { 1,	0,		sys_adjtimex,			"adjtimex"		},
[125] = { 3,	TM|SI,		sys_mprotect,			"mprotect"		},
[126] = { 3,	TS,		sys_sigprocmask,		"sigprocmask"		},
[127] = { 2,	0,		sys_create_module,		"create_module"		},
[128] = { 3,	0,		sys_init_module,		"init_module"		},
[129] = { 2,	0,		sys_delete_module,		"delete_module"		},
[130] = { 1,	0,		sys_get_kernel_syms,		"get_kernel_syms"	},
[131] = { 4,	TF,		sys_quotactl,			"quotactl"		},
[132] = { 1,	0,		sys_getpgid,			"getpgid"		},
[133] = { 1,	TD,		sys_fchdir,			"fchdir"		},
[134] = { 0,	0,		sys_bdflush,			"bdflush"		},
[135] = { 3,	0,		sys_sysfs,			"sysfs"			},
[136] = { 1,	0,		sys_personality,		"personality"		},
[137] = { 5,	0,		sys_afs_syscall,		"afs_syscall"		},
[138 ... 140] = { },
[141] = { 3,	TD,		sys_getdents,			"getdents"		},
[142] = { 5,	TD,		sys_select,			"select"		},
[143] = { 2,	TD,		sys_flock,			"flock"			},
[144] = { 3,	TM,		sys_msync,			"msync"			},
[145] = { 3,	TD,		sys_readv,			"readv"			},
[146] = { 3,	TD,		sys_writev,			"writev"		},
[147] = { 1,	0,		sys_getsid,			"getsid"		},
[148] = { 1,	TD,		sys_fdatasync,			"fdatasync"		},
[149] = { 1,	0,		sys_sysctl,			"_sysctl"		},
[150] = { 2,	TM,		sys_mlock,			"mlock"			},
[151] = { 2,	TM,		sys_munlock,			"munlock"		},
[152] = { 1,	TM,		sys_mlockall,			"mlockall"		},
[153] = { 0,	TM,		sys_munlockall,			"munlockall"		},
[154] = { 2,	0,		sys_sched_setparam,		"sched_setparam"	},
[155] = { 2,	0,		sys_sched_getparam,		"sched_getparam"	},
[156] = { 3,	0,		sys_sched_setscheduler,		"sched_setscheduler"	},
[157] = { 1,	0,		sys_sched_getscheduler,		"sched_getscheduler"	},
[158] = { 0,	0,		sys_sched_yield,		"sched_yield"		},
[159] = { 1,	0,		sys_sched_get_priority_max,	"sched_get_priority_max"},
[160] = { 1,	0,		sys_sched_get_priority_min,	"sched_get_priority_min"},
[161] = { 2,	0,		sys_sched_rr_get_interval,	"sched_rr_get_interval"	},
[162] = { 2,	0,		sys_nanosleep,			"nanosleep"		},
[163] = { 5,	TM|SI,		sys_mremap,			"mremap"		},
[164 ... 166] = { },
[167] = { 5,	0,		sys_query_module,		"query_module"		},
[168] = { 3,	TD,		sys_poll,			"poll"			},
[169] = { 3,	0,		sys_nfsservctl,			"nfsservctl"		},
[170 ... 171] = { },
[172] = { 5,	0,		sys_prctl,			"prctl"			},
[173] = { 0,	TS,		sys_sigreturn,			"rt_sigreturn"		},
[174] = { 4,	TS,		sys_rt_sigaction,		"rt_sigaction"		},
[175] = { 4,	TS,		sys_rt_sigprocmask,		"rt_sigprocmask"	},
[176] = { 2,	TS,		sys_rt_sigpending,		"rt_sigpending"		},
[177] = { 4,	TS,		sys_rt_sigtimedwait,		"rt_sigtimedwait"	},
[178] = { 3,	TS,		sys_rt_sigqueueinfo,		"rt_sigqueueinfo"	},
[179] = { 2,	TS,		sys_rt_sigsuspend,		"rt_sigsuspend"		},
[180] = { 4,	TD,		sys_pread,			"pread64"		},
[181] = { 4,	TD,		sys_pwrite,			"pwrite64"		},
[182] = { },
[183] = { 2,	TF,		sys_getcwd,			"getcwd"		},
[184] = { 2,	0,		sys_capget,			"capget"		},
[185] = { 2,	0,		sys_capset,			"capset"		},
[186] = { 2,	TS,		sys_sigaltstack,		"sigaltstack"		},
[187] = { 4,	TD|TN,		sys_sendfile,			"sendfile"		},
[188] = { 5,	0,		sys_getpmsg,			"getpmsg"		},
[189] = { 5,	0,		sys_putpmsg,			"putpmsg"		},
[190] = { 0,	TP,		sys_vfork,			"vfork"			},
[191] = { 2,	0,		sys_getrlimit,			"getrlimit"		},
[196 ... 197] = { },
[198] = { 3,	TF,		sys_chown,			"lchown"		},
[199] = { 0,	NF,		sys_getuid,			"getuid"		},
[200] = { 0,	NF,		sys_getgid,			"getgid"		},
[201] = { 0,	NF,		sys_geteuid,			"geteuid"		},
[202] = { 0,	NF,		sys_getegid,			"getegid"		},
[203] = { 2,	0,		sys_setreuid,			"setreuid"		},
[204] = { 2,	0,		sys_setregid,			"setregid"		},
[205] = { 2,	0,		sys_getgroups,			"getgroups"		},
[206] = { 2,	0,		sys_setgroups,			"setgroups"		},
[207] = { 3,	TD,		sys_fchown,			"fchown"		},
[208] = { 3,	0,		sys_setresuid,			"setresuid"		},
[209] = { 3,	0,		sys_getresuid,			"getresuid"		},
[210] = { 3,	0,		sys_setresgid,			"setresgid"		},
[211] = { 3,	0,		sys_getresgid,			"getresgid"		},
[212] = { 3,	TF,		sys_chown,			"chown"			},
[213] = { 1,	0,		sys_setuid,			"setuid"		},
[214] = { 1,	0,		sys_setgid,			"setgid"		},
[215] = { 1,	NF,		sys_setfsuid,			"setfsuid"		},
[216] = { 1,	NF,		sys_setfsgid,			"setfsgid"		},
[217] = { 2,	TF,		sys_pivotroot,			"pivot_root"		},
[218] = { 3,	TM,		sys_mincore,			"mincore"		},
[219] = { 3,	TM,		sys_madvise,			"madvise"		},
[220] = { 3,	TD,		sys_getdents64,			"getdents64"		},
[221] = { },
[222] = { 3,	TD,		sys_readahead,			"readahead"		},
[223] = { },
[224] = { 5,	TF,		sys_setxattr,			"setxattr"		},
[225] = { 5,	TF,		sys_setxattr,			"lsetxattr"		},
[226] = { 5,	TD,		sys_fsetxattr,			"fsetxattr"		},
[227] = { 4,	TF,		sys_getxattr,			"getxattr"		},
[228] = { 4,	TF,		sys_getxattr,			"lgetxattr"		},
[229] = { 4,	TD,		sys_fgetxattr,			"fgetxattr"		},
[230] = { 3,	TF,		sys_listxattr,			"listxattr"		},
[231] = { 3,	TF,		sys_listxattr,			"llistxattr"		},
[232] = { 3,	TD,		sys_flistxattr,			"flistxattr"		},
[233] = { 2,	TF,		sys_removexattr,		"removexattr"		},
[234] = { 2,	TF,		sys_removexattr,		"lremovexattr"		},
[235] = { 2,	TD,		sys_fremovexattr,		"fremovexattr"		},
[236] = { 0,	0,		sys_gettid,			"gettid"		},
[237] = { 2,	TS,		sys_kill,			"tkill"			},
[238] = { 6,	0,		sys_futex,			"futex"			},
[239] = { 3,	0,		sys_sched_setaffinity,		"sched_setaffinity"	},
[240] = { 3,	0,		sys_sched_getaffinity,		"sched_getaffinity"	},
[241] = { 3,	TS,		sys_tgkill,			"tgkill"		},
[242] = { },
[243] = { 2,	0,		sys_io_setup,			"io_setup"		},
[244] = { 1,	0,		sys_io_destroy,			"io_destroy"		},
[245] = { 5,	0,		sys_io_getevents,		"io_getevents"		},
[246] = { 3,	0,		sys_io_submit,			"io_submit"		},
[247] = { 3,	0,		sys_io_cancel,			"io_cancel"		},
[248] = { 1,	TP|SE,		sys_exit,			"exit_group"		},
[249] = { 1,	TD,		sys_epoll_create,		"epoll_create"		},
[250] = { 4,	TD,		sys_epoll_ctl,			"epoll_ctl"		},
[251] = { 4,	TD,		sys_epoll_wait,			"epoll_wait"		},
[252] = { 1,	0,		sys_set_tid_address,		"set_tid_address"	},
[253] = { 4,	TD,		sys_fadvise64,			"fadvise64"		},
[254] = { 3,	0,		sys_timer_create,		"timer_create"		},
[255] = { 4,	0,		sys_timer_settime,		"timer_settime"		},
[256] = { 2,	0,		sys_timer_gettime,		"timer_gettime"		},
[257] = { 1,	0,		sys_timer_getoverrun,		"timer_getoverrun"	},
[258] = { 1,	0,		sys_timer_delete,		"timer_delete"		},
[259] = { 2,	0,		sys_clock_settime,		"clock_settime"		},
[260] = { 2,	0,		sys_clock_gettime,		"clock_gettime"		},
[261] = { 2,	0,		sys_clock_getres,		"clock_getres"		},
[262] = { 4,	0,		sys_clock_nanosleep,		"clock_nanosleep"	},
[263] = { 5,	0,		sys_vserver,			"vserver"		},
[264] = { },
[265] = { 3,	TF,		sys_statfs64,			"statfs64"		},
[266] = { 3,	TD,		sys_fstatfs64,			"fstatfs64"		},
[267] = { 5,	TM|SI,		sys_remap_file_pages,		"remap_file_pages"	},
[268] = { 6,	TM,		sys_mbind,			"mbind"			},
[269] = { 5,	TM,		sys_get_mempolicy,		"get_mempolicy"		},
[270] = { 3,	TM,		sys_set_mempolicy,		"set_mempolicy"		},
[271] = { 4,	0,		sys_mq_open,			"mq_open"		},
[272] = { 1,	0,		sys_mq_unlink,			"mq_unlink"		},
[273] = { 5,	0,		sys_mq_timedsend,		"mq_timedsend"		},
[274] = { 5,	0,		sys_mq_timedreceive,		"mq_timedreceive"	},
[275] = { 2,	0,		sys_mq_notify,			"mq_notify"		},
[276] = { 3,	0,		sys_mq_getsetattr,		"mq_getsetattr"		},
[277] = { 4,	0,		sys_kexec_load,			"kexec_load"		},
[278] = { 5,	0,		sys_add_key,			"add_key"		},
[279] = { 4,	0,		sys_request_key,		"request_key"		},
[280] = { 5,	0,		sys_keyctl,			"keyctl"		},
[281] = { 5,	TP,		sys_waitid,			"waitid"		},
[282] = { 3,	0,		sys_ioprio_set,			"ioprio_set"		},
[283] = { 2,	0,		sys_ioprio_get,			"ioprio_get"		},
[284] = { 0,	TD,		sys_inotify_init,		"inotify_init"		},
[285] = { 3,	TD,		sys_inotify_add_watch,		"inotify_add_watch"	},
[286] = { 2,	TD,		sys_inotify_rm_watch,		"inotify_rm_watch"	},
[287] = { 4,	TM,		sys_migrate_pages,		"migrate_pages"		},
[288] = { 4,	TD|TF,		sys_openat,			"openat"		},
[289] = { 3,	TD|TF,		sys_mkdirat,			"mkdirat"		},
[290] = { 4,	TD|TF,		sys_mknodat,			"mknodat"		},
[291] = { 5,	TD|TF,		sys_fchownat,			"fchownat"		},
[292] = { 3,	TD|TF,		sys_futimesat,			"futimesat"		},
[293] = { 4,	TD|TF,		sys_newfstatat,			"newfstatat"		},
[294] = { 3,	TD|TF,		sys_unlinkat,			"unlinkat"		},
[295] = { 4,	TD|TF,		sys_renameat,			"renameat"		},
[296] = { 5,	TD|TF,		sys_linkat,			"linkat"		},
[297] = { 3,	TD|TF,		sys_symlinkat,			"symlinkat"		},
[298] = { 4,	TD|TF,		sys_readlinkat,			"readlinkat"		},
[299] = { 3,	TD|TF,		sys_fchmodat,			"fchmodat"		},
[300] = { 3,	TD|TF,		sys_faccessat,			"faccessat"		},
[301] = { 6,	TD,		sys_pselect6,			"pselect6"		},
[302] = { 5,	TD,		sys_ppoll,			"ppoll"			},
[303] = { 1,	TP,		sys_unshare,			"unshare"		},
[304] = { 2,	0,		sys_set_robust_list,		"set_robust_list"	},
[305] = { 3,	0,		sys_get_robust_list,		"get_robust_list"	},
[306] = { 6,	TD,		sys_splice,			"splice"		},
[307] = { 4,	TD,		sys_sync_file_range,		"sync_file_range"	},
[308] = { 4,	TD,		sys_tee,			"tee"			},
[309] = { 4,	TD,		sys_vmsplice,			"vmsplice"		},
[310] = { 6,	TM,		sys_move_pages,			"move_pages"		},
[311] = { 3,	0,		sys_getcpu,			"getcpu"		},
[312] = { 6,	TD,		sys_epoll_pwait,		"epoll_pwait"		},
[313] = { 2,	TF,		sys_utimes,			"utimes"		},
[314] = { 4,	TD,		sys_fallocate,			"fallocate"		},
[315] = { 4,	TD|TF,		sys_utimensat,			"utimensat"		},
[316] = { 3,	TD|TS,		sys_signalfd,			"signalfd"		},
[317] = { 4,	TD,		sys_timerfd,			"timerfd"		},
[318] = { 1,	TD,		sys_eventfd,			"eventfd"		},
[319] = { 2,	TD,		sys_timerfd_create,		"timerfd_create"	},
[320] = { 4,	TD,		sys_timerfd_settime,		"timerfd_settime"	},
[321] = { 2,	TD,		sys_timerfd_gettime,		"timerfd_gettime"	},
[322] = { 4,	TD|TS,		sys_signalfd4,			"signalfd4"		},
[323] = { 2,	TD,		sys_eventfd2,			"eventfd2"		},
[324] = { 1,	TD,		sys_inotify_init1,		"inotify_init1"		},
[325] = { 2,	TD,		sys_pipe2,			"pipe2"			},
[326] = { 3,	TD,		sys_dup3,			"dup3"			},
[327] = { 1,	TD,		sys_epoll_create1,		"epoll_create1"		},
[328] = { 4,	TD,		sys_preadv,			"preadv"		},
[329] = { 4,	TD,		sys_pwritev,			"pwritev"		},
[330] = { 4,	TP|TS,		sys_rt_tgsigqueueinfo,		"rt_tgsigqueueinfo"	},
[331] = { 5,	TD,		sys_perf_event_open,		"perf_event_open"	},
[332] = { 2,	TD,		sys_fanotify_init,		"fanotify_init"		},
[333] = { 5,	TD|TF,		sys_fanotify_mark,		"fanotify_mark"		},
[334] = { 4,	0,		sys_prlimit64,			"prlimit64"		},
[335] = { 5,	TD|TF,		sys_name_to_handle_at,		"name_to_handle_at"	},
[336] = { 3,	TD,		sys_open_by_handle_at,		"open_by_handle_at"	},
[337] = { 2,	0,		sys_clock_adjtime,		"clock_adjtime"		},
[338] = { 1,	TD,		sys_syncfs,			"syncfs"		},
[339] = { 2,	TD,		sys_setns,			"setns"			},
[340] = { 6,	0,		sys_process_vm_readv,		"process_vm_readv"	},
[341] = { 6,	0,		sys_process_vm_writev,		"process_vm_writev"	},
[342] = { 2,	0,		printargs,			"s390_runtime_instr"	},
[343] = { 5,	0,		sys_kcmp,			"kcmp"			},
[344] = { 3,	TD,		sys_finit_module,		"finit_module"		},
[345] = { 3,	0,		sys_sched_setattr,		"sched_setattr"		},
[346] = { 4,	0,		sys_sched_getattr,		"sched_getattr"		},
[347] = { 5,	TD|TF,		sys_renameat2,			"renameat2"		},
[348] = { 3,	0,		sys_seccomp,			"seccomp",		},
[349] = { 3,	0,		sys_getrandom,			"getrandom",		},
[350] = { 2,	TD,		sys_memfd_create,		"memfd_create",		},
[351] = { 3,	TD,		sys_bpf,			"bpf",			},
[352] = { 3,	0,		printargs,			"s390_pci_mmio_write",	},
[353] = { 3,	0,		printargs,			"s390_pci_mmio_read",	},
[354] = { 5,	TD|TF|TP|SE|SI,	sys_execveat,			"execveat",		},
[355 ... 399] = { },

#define SYS_socket_subcall	400
#include "subcall.h"
