#if defined LINUX_MIPSN64
/* For an N64 strace decode the N64 64-bit syscalls. */
[5000] = { 3,	TD,		sys_read,			"read"			}, /* start of Linux N64 */
[5001] = { 3,	TD,		sys_write,			"write"			},
[5002] = { 3,	TD|TF,		sys_open,			"open"			},
[5003] = { 1,	TD,		sys_close,			"close"			},
[5004] = { 2,	TF,		sys_stat,			"stat"			},
[5005] = { 2,	TD,		sys_fstat,			"fstat"			},
[5006] = { 2,	TF,		sys_lstat,			"lstat"			},
[5007] = { 3,	TD,		sys_poll,			"poll"			},
[5008] = { 3,	TD,		sys_lseek,			"lseek"			},
[5009] = { 6,	TD|TM|SI,	sys_mmap,			"mmap"			},
[5010] = { 3,	TM|SI,		sys_mprotect,			"mprotect"		},
[5011] = { 2,	TM|SI,		sys_munmap,			"munmap"		},
[5012] = { 1,	TM|SI,		sys_brk,			"brk"			},
[5013] = { 4,	TS,		sys_rt_sigaction,		"rt_sigaction"		},
[5014] = { 4,	TS,		sys_rt_sigprocmask,		"rt_sigprocmask"	},
[5015] = { 3,	TD,		sys_ioctl,			"ioctl"			},
[5016] = { 4,	TD,		sys_pread,			"pread64"		},
[5017] = { 4,	TD,		sys_pwrite,			"pwrite64"		},
[5018] = { 3,	TD,		sys_readv,			"readv"			},
[5019] = { 3,	TD,		sys_writev,			"writev"		},
[5020] = { 2,	TF,		sys_access,			"access"		},
[5021] = { 1,	TD,		sys_pipe,			"pipe"			},
[5022] = { 5,	TD,		sys_select,			"select"		},
[5023] = { 0,	0,		sys_sched_yield,		"sched_yield"		},
[5024] = { 5,	TM|SI,		sys_mremap,			"mremap"		},
[5025] = { 3,	TM,		sys_msync,			"msync"			},
[5026] = { 3,	TM,		sys_mincore,			"mincore"		},
[5027] = { 3,	TM,		sys_madvise,			"madvise"		},
[5028] = { 3,	TI,		sys_shmget,			"shmget"		},
[5029] = { 3,	TI|TM|SI,	sys_shmat,			"shmat"			},
[5030] = { 3,	TI,		sys_shmctl,			"shmctl"		},
[5031] = { 1,	TD,		sys_dup,			"dup"			},
[5032] = { 2,	TD,		sys_dup2,			"dup2"			},
[5033] = { 0,	TS,		sys_pause,			"pause"			},
[5034] = { 2,	0,		sys_nanosleep,			"nanosleep"		},
[5035] = { 2,	0,		sys_getitimer,			"getitimer"		},
[5036] = { 3,	0,		sys_setitimer,			"setitimer"		},
[5037] = { 1,	0,		sys_alarm,			"alarm"			},
[5038] = { 0,	0,		sys_getpid,			"getpid"		},
[5039] = { 4,	TD|TN,		sys_sendfile,			"sendfile"		},
[5040] = { 3,	TN,		sys_socket,			"socket"		},
[5041] = { 3,	TN,		sys_connect,			"connect"		},
[5042] = { 3,	TN,		sys_accept,			"accept"		},
[5043] = { 6,	TN,		sys_sendto,			"sendto"		},
[5044] = { 6,	TN,		sys_recvfrom,			"recvfrom"		},
[5045] = { 3,	TN,		sys_sendmsg,			"sendmsg"		},
[5046] = { 3,	TN,		sys_recvmsg,			"recvmsg"		},
[5047] = { 2,	TN,		sys_shutdown,			"shutdown"		},
[5048] = { 3,	TN,		sys_bind,			"bind"			},
[5049] = { 2,	TN,		sys_listen,			"listen"		},
[5050] = { 3,	TN,		sys_getsockname,		"getsockname"		},
[5051] = { 3,	TN,		sys_getpeername,		"getpeername"		},
[5052] = { 4,	TN,		sys_socketpair,			"socketpair"		},
[5053] = { 5,	TN,		sys_setsockopt,			"setsockopt"		},
[5054] = { 5,	TN,		sys_getsockopt,			"getsockopt"		},
[5055] = { 5,	TP,		sys_clone,			"clone"			},
[5056] = { 0,	TP,		sys_fork,			"fork"			},
[5057] = { 3,	TF|TP|SE|SI,	sys_execve,			"execve"		},
[5058] = { 1,	TP|SE,		sys_exit,			"exit"			},
[5059] = { 4,	TP,		sys_wait4,			"wait4"			},
[5060] = { 2,	TS,		sys_kill,			"kill"			},
[5061] = { 1,	0,		sys_uname,			"uname"			},
[5062] = { 3,	TI,		sys_semget,			"semget"		},
[5063] = { 3,	TI,		printargs,			"semop"			},
[5064] = { 4,	TI,		sys_semctl,			"semctl"		},
[5065] = { 1,	TI|TM|SI,	sys_shmdt,			"shmdt"			},
[5066] = { 2,	TI,		sys_msgget,			"msgget"		},
[5067] = { 4,	TI,		sys_msgsnd,			"msgsnd"		},
[5068] = { 5,	TI,		sys_msgrcv,			"msgrcv"		},
[5069] = { 3,	TI,		sys_msgctl,			"msgctl"		},
[5070] = { 3,	TD,		sys_fcntl,			"fcntl"			},
[5071] = { 2,	TD,		sys_flock,			"flock"			},
[5072] = { 1,	TD,		sys_fsync,			"fsync"			},
[5073] = { 1,	TD,		sys_fdatasync,			"fdatasync"		},
[5074] = { 2,	TF,		sys_truncate,			"truncate"		},
[5075] = { 2,	TD,		sys_ftruncate,			"ftruncate"		},
[5076] = { 3,	TD,		sys_getdents,			"getdents"		},
[5077] = { 2,	TF,		sys_getcwd,			"getcwd"		},
[5078] = { 1,	TF,		sys_chdir,			"chdir"			},
[5079] = { 1,	TD,		sys_fchdir,			"fchdir"		},
[5080] = { 2,	TF,		sys_rename,			"rename"		},
[5081] = { 2,	TF,		sys_mkdir,			"mkdir"			},
[5082] = { 1,	TF,		sys_rmdir,			"rmdir"			},
[5083] = { 2,	TD|TF,		sys_creat,			"creat"			},
[5084] = { 2,	TF,		sys_link,			"link"			},
[5085] = { 1,	TF,		sys_unlink,			"unlink"		},
[5086] = { 2,	TF,		sys_symlink,			"symlink"		},
[5087] = { 3,	TF,		sys_readlink,			"readlink"		},
[5088] = { 2,	TF,		sys_chmod,			"chmod"			},
[5089] = { 2,	TD,		sys_fchmod,			"fchmod"		},
[5090] = { 3,	TF,		sys_chown,			"chown"			},
[5091] = { 3,	TD,		sys_fchown,			"fchown"		},
[5092] = { 3,	TF,		sys_chown,			"lchown"		},
[5093] = { 1,	0,		sys_umask,			"umask"			},
[5094] = { 2,	0,		sys_gettimeofday,		"gettimeofday"		},
[5095] = { 2,	0,		sys_getrlimit,			"getrlimit"		},
[5096] = { 2,	0,		sys_getrusage,			"getrusage"		},
[5097] = { 1,	0,		sys_sysinfo,			"sysinfo"		},
[5098] = { 1,	0,		sys_times,			"times"			},
[5099] = { 4,	0,		sys_ptrace,			"ptrace"		},
[5100] = { 0,	NF,		sys_getuid,			"getuid"		},
[5101] = { 3,	0,		sys_syslog,			"syslog"		},
[5102] = { 0,	NF,		sys_getgid,			"getgid"		},
[5103] = { 1,	0,		sys_setuid,			"setuid"		},
[5104] = { 1,	0,		sys_setgid,			"setgid"		},
[5105] = { 0,	NF,		sys_geteuid,			"geteuid"		},
[5106] = { 0,	NF,		sys_getegid,			"getegid"		},
[5107] = { 2,	0,		sys_setpgid,			"setpgid"		},
[5108] = { 0,	0,		sys_getppid,			"getppid"		},
[5109] = { 0,	0,		sys_getpgrp,			"getpgrp"		},
[5110] = { 0,	0,		sys_setsid,			"setsid"		},
[5111] = { 2,	0,		sys_setreuid,			"setreuid"		},
[5112] = { 2,	0,		sys_setregid,			"setregid"		},
[5113] = { 2,	0,		sys_getgroups,			"getgroups"		},
[5114] = { 2,	0,		sys_setgroups,			"setgroups"		},
[5115] = { 3,	0,		sys_setresuid,			"setresuid"		},
[5116] = { 3,	0,		sys_getresuid,			"getresuid"		},
[5117] = { 3,	0,		sys_setresgid,			"setresgid"		},
[5118] = { 3,	0,		sys_getresgid,			"getresgid"		},
[5119] = { 0,	0,		sys_getpgid,			"getpgid"		},
[5120] = { 1,	NF,		sys_setfsuid,			"setfsuid"		},
[5121] = { 1,	NF,		sys_setfsgid,			"setfsgid"		},
[5122] = { 1,	0,		sys_getsid,			"getsid"		},
[5123] = { 2,	0,		sys_capget,			"capget"		},
[5124] = { 2,	0,		sys_capset,			"capset"		},
[5125] = { 2,	TS,		sys_rt_sigpending,		"rt_sigpending"		},
[5126] = { 4,	TS,		sys_rt_sigtimedwait,		"rt_sigtimedwait"	},
[5127] = { 3,	TS,		sys_rt_sigqueueinfo,		"rt_sigqueueinfo"	},
[5128] = { 2,	TS,		sys_rt_sigsuspend,		"rt_sigsuspend"		},
[5129] = { 2,	TS,		sys_sigaltstack,		"sigaltstack"		},
[5130] = { 2,	TF,		sys_utime,			"utime"			},
[5131] = { 3,	TF,		sys_mknod,			"mknod"			},
[5132] = { 1,	0,		sys_personality,		"personality"		},
[5133] = { 2,	0,		sys_ustat,			"ustat"			},
[5134] = { 3,	TF,		sys_statfs,			"statfs"		},
[5135] = { 3,	TD,		sys_fstatfs,			"fstatfs"		},
[5136] = { 5,	0,		sys_sysfs,			"sysfs"			},
[5137] = { 2,	0,		sys_getpriority,		"getpriority"		},
[5138] = { 3,	0,		sys_setpriority,		"setpriority"		},
[5139] = { 2,	0,		sys_sched_setparam,		"sched_setparam"	},
[5140] = { 2,	0,		sys_sched_getparam,		"sched_getparam"	},
[5141] = { 3,	0,		sys_sched_setscheduler,		"sched_setscheduler"	},
[5142] = { 1,	0,		sys_sched_getscheduler,		"sched_getscheduler"	},
[5143] = { 1,	0,		sys_sched_get_priority_max,	"sched_get_priority_max"},
[5144] = { 1,	0,		sys_sched_get_priority_min,	"sched_get_priority_min"},
[5145] = { 2,	0,		sys_sched_rr_get_interval,	"sched_rr_get_interval"	},
[5146] = { 2,	TM,		sys_mlock,			"mlock"			},
[5147] = { 2,	TM,		sys_munlock,			"munlock"		},
[5148] = { 1,	TM,		sys_mlockall,			"mlockall"		},
[5149] = { 0,	TM,		sys_munlockall,			"munlockall"		},
[5150] = { 0,	0,		sys_vhangup,			"vhangup"		},
[5151] = { 2,	TF,		sys_pivotroot,			"pivot_root"		},
[5152] = { 1,	0,		sys_sysctl,			"_sysctl"		},
[5153] = { 5,	0,		sys_prctl,			"prctl"			},
[5154] = { 1,	0,		sys_adjtimex,			"adjtimex"		},
[5155] = { 2,	0,		sys_setrlimit,			"setrlimit"		},
[5156] = { 1,	TF,		sys_chroot,			"chroot"		},
[5157] = { 0,	0,		sys_sync,			"sync"			},
[5158] = { 1,	TF,		sys_acct,			"acct"			},
[5159] = { 2,	0,		sys_settimeofday,		"settimeofday"		},
[5160] = { 5,	TF,		sys_mount,			"mount"			},
[5161] = { 2,	TF,		sys_umount2,			"umount2"		},
[5162] = { 2,	TF,		sys_swapon,			"swapon"		},
[5163] = { 1,	TF,		sys_swapoff,			"swapoff"		},
[5164] = { 4,	0,		sys_reboot,			"reboot"		},
[5165] = { 2,	0,		sys_sethostname,		"sethostname"		},
[5166] = { 2,	0,		sys_setdomainname,		"setdomainname"		},
[5167] = { 2,	0,		sys_create_module,		"create_module"		},
[5168] = { 4,	0,		sys_init_module,		"init_module"		},
[5169] = { 1,	0,		sys_delete_module,		"delete_module"		},
[5170] = { 1,	0,		sys_get_kernel_syms,		"get_kernel_syms"	},
[5171] = { 5,	0,		sys_query_module,		"query_module"		},
[5172] = { 4,	TF,		sys_quotactl,			"quotactl"		},
[5173] = { 3,	0,		sys_nfsservctl,			"nfsservctl"		},
[5174] = { 5,	TN,		printargs,			"getpmsg"		},
[5175] = { 5,	TN,		printargs,			"putpmsg"		},
[5176] = { 0,	0,		sys_afs_syscall,		"afs_syscall"		},
[5177] = { 0,	0,		printargs,			"reserved177"		},
[5178] = { 0,	0,		sys_gettid,			"gettid"		},
[5179] = { 3,	TD,		sys_readahead,			"readahead"		},
[5180] = { 5,	TF,		sys_setxattr,			"setxattr"		},
[5181] = { 5,	TF,		sys_setxattr,			"lsetxattr"		},
[5182] = { 5,	TD,		sys_fsetxattr,			"fsetxattr"		},
[5183] = { 4,	TF,		sys_getxattr,			"getxattr"		},
[5184] = { 4,	TF,		sys_getxattr,			"lgetxattr"		},
[5185] = { 4,	TD,		sys_fgetxattr,			"fgetxattr"		},
[5186] = { 3,	TF,		sys_listxattr,			"listxattr"		},
[5187] = { 3,	TF,		sys_listxattr,			"llistxattr"		},
[5188] = { 3,	TD,		sys_flistxattr,			"flistxattr"		},
[5189] = { 2,	TF,		sys_removexattr,		"removexattr"		},
[5190] = { 2,	TF,		sys_removexattr,		"lremovexattr"		},
[5191] = { 2,	TD,		sys_fremovexattr,		"fremovexattr"		},
[5192] = { 2,	TS,		sys_kill,			"tkill"			},
[5193] = { 1,	0,		sys_time,			"time"			},
[5194] = { 6,	0,		sys_futex,			"futex"			},
[5195] = { 3,	0,		sys_sched_setaffinity,		"sched_setaffinity"	},
[5196] = { 3,	0,		sys_sched_getaffinity,		"sched_getaffinity"	},
[5197] = { 3,	0,		printargs,			"cacheflush"		},
[5198] = { 3,	0,		printargs,			"cachectl"		},
[5199] = { 4,	0,		sys_sysmips,			"sysmips"		},
[5200] = { 2,	0,		sys_io_setup,			"io_setup"		},
[5201] = { 1,	0,		sys_io_destroy,			"io_destroy"		},
[5202] = { 5,	0,		sys_io_getevents,		"io_getevents"		},
[5203] = { 3,	0,		sys_io_submit,			"io_submit"		},
[5204] = { 3,	0,		sys_io_cancel,			"io_cancel"		},
[5205] = { 1,	TP|SE,		sys_exit,			"exit_group"		},
[5206] = { 3,	0,		sys_lookup_dcookie,		"lookup_dcookie"	},
[5207] = { 1,	TD,		sys_epoll_create,		"epoll_create"		},
[5208] = { 4,	TD,		sys_epoll_ctl,			"epoll_ctl"		},
[5209] = { 4,	TD,		sys_epoll_wait,			"epoll_wait"		},
[5210] = { 5,	TM|SI,		sys_remap_file_pages,		"remap_file_pages"	},
[5211] = { 0,	TS,		sys_rt_sigreturn,		"rt_sigreturn"		},
[5212] = { 1,	0,		sys_set_tid_address,		"set_tid_address"	},
[5213] = { 0,	0,		sys_restart_syscall,		"restart_syscall"	},
[5214] = { 4,	TI,		sys_semtimedop,			"semtimedop"		},
[5215] = { 4,	TD,		sys_fadvise64_64,		"fadvise64_64"		},
[5216] = { 3,	0,		sys_timer_create,		"timer_create"		},
[5217] = { 4,	0,		sys_timer_settime,		"timer_settime"		},
[5218] = { 2,	0,		sys_timer_gettime,		"timer_gettime"		},
[5219] = { 1,	0,		sys_timer_getoverrun,		"timer_getoverrun"	},
[5220] = { 1,	0,		sys_timer_delete,		"timer_delete"		},
[5221] = { 2,	0,		sys_clock_settime,		"clock_settime"		},
[5222] = { 2,	0,		sys_clock_gettime,		"clock_gettime"		},
[5223] = { 2,	0,		sys_clock_getres,		"clock_getres"		},
[5224] = { 4,	0,		sys_clock_nanosleep,		"clock_nanosleep"	},
[5225] = { 3,	TS,		sys_tgkill,			"tgkill"		},
[5226] = { 2,	TF,		sys_utimes,			"utimes"		},
[5227] = { 6,	TM,		sys_mbind,			"mbind"			},
[5228] = { 5,	TM,		sys_get_mempolicy,		"get_mempolicy"		},
[5229] = { 3,	TM,		sys_set_mempolicy,		"set_mempolicy"		},
[5230] = { 4,	0,		sys_mq_open,			"mq_open"		},
[5231] = { 1,	0,		sys_mq_unlink,			"mq_unlink"		},
[5232] = { 5,	0,		sys_mq_timedsend,		"mq_timedsend"		},
[5233] = { 5,	0,		sys_mq_timedreceive,		"mq_timedreceive"	},
[5234] = { 2,	0,		sys_mq_notify,			"mq_notify"		},
[5235] = { 3,	0,		sys_mq_getsetattr,		"mq_getsetattr"		},
[5236] = { 5,	0,		sys_vserver,			"vserver"		},
[5237] = { 5,	TP,		sys_waitid,			"waitid"		},
[5238] = { },
[5239] = { 5,	0,		sys_add_key,			"add_key"		},
[5240] = { 4,	0,		sys_request_key,		"request_key"		},
[5241] = { 5,	0,		sys_keyctl,			"keyctl"		},
[5242] = { 1,	0,		sys_set_thread_area,		"set_thread_area"	},
[5243] = { 0,	TD,		sys_inotify_init,		"inotify_init"		},
[5244] = { 3,	TD,		sys_inotify_add_watch,		"inotify_add_watch"	},
[5245] = { 2,	TD,		sys_inotify_rm_watch,		"inotify_rm_watch"	},
[5246] = { 4,	TM,		sys_migrate_pages,		"migrate_pages"		},
[5247] = { 4,	TD|TF,		sys_openat,			"openat"		},
[5248] = { 3,	TD|TF,		sys_mkdirat,			"mkdirat"		},
[5249] = { 4,	TD|TF,		sys_mknodat,			"mknodat"		},
[5250] = { 5,	TD|TF,		sys_fchownat,			"fchownat"		},
[5251] = { 3,	TD|TF,		sys_futimesat,			"futimesat"		},
[5252] = { 4,	TD|TF,		sys_newfstatat,			"newfstatat"		},
[5253] = { 3,	TD|TF,		sys_unlinkat,			"unlinkat"		},
[5254] = { 4,	TD|TF,		sys_renameat,			"renameat"		},
[5255] = { 5,	TD|TF,		sys_linkat,			"linkat"		},
[5256] = { 3,	TD|TF,		sys_symlinkat,			"symlinkat"		},
[5257] = { 4,	TD|TF,		sys_readlinkat,			"readlinkat"		},
[5258] = { 3,	TD|TF,		sys_fchmodat,			"fchmodat"		},
[5259] = { 3,	TD|TF,		sys_faccessat,			"faccessat"		},
[5260] = { 6,	TD,		sys_pselect6,			"pselect6"		},
[5261] = { 5,	TD,		sys_ppoll,			"ppoll"			},
[5262] = { 1,	TP,		sys_unshare,			"unshare"		},
[5263] = { 6,	TD,		sys_splice,			"splice"		},
[5264] = { 4,	TD,		sys_sync_file_range,		"sync_file_range"	},
[5265] = { 4,	TD,		sys_tee,			"tee"			},
[5266] = { 4,	TD,		sys_vmsplice,			"vmsplice"		},
[5267] = { 6,	TM,		sys_move_pages,			"move_pages"		},
[5268] = { 2,	0,		sys_set_robust_list,		"set_robust_list"	},
[5269] = { 3,	0,		sys_get_robust_list,		"get_robust_list"	},
[5270] = { 4,	0,		sys_kexec_load,			"kexec_load"		},
[5271] = { 3,	0,		sys_getcpu,			"getcpu"		},
[5272] = { 6,	TD,		sys_epoll_pwait,		"epoll_pwait"		},
[5273] = { 3,	0,		sys_ioprio_set,			"ioprio_set"		},
[5274] = { 2,	0,		sys_ioprio_get,			"ioprio_get"		},
[5275] = { 4,	TD|TF,		sys_utimensat,			"utimensat"		},
[5276] = { 3,	TD|TS,		sys_signalfd,			"signalfd"		},
[5277] = { 4,	TD,		sys_timerfd,			"timerfd"		},
[5278] = { 1,	TD,		sys_eventfd,			"eventfd"		},
[5279] = { 4,	TD,		sys_fallocate,			"fallocate"		},
[5280] = { 2,	TD,		sys_timerfd_create,		"timerfd_create"	},
[5281] = { 2,	TD,		sys_timerfd_gettime,		"timerfd_gettime"	},
[5282] = { 4,	TD,		sys_timerfd_settime,		"timerfd_settime"	},
[5283] = { 4,	TD|TS,		sys_signalfd4,			"signalfd4"		},
[5284] = { 2,	TD,		sys_eventfd2,			"eventfd2"		},
[5285] = { 1,	TD,		sys_epoll_create1,		"epoll_create1"		},
[5286] = { 3,	TD,		sys_dup3,			"dup3"			},
[5287] = { 2,	TD,		sys_pipe2,			"pipe2"			},
[5288] = { 1,	TD,		sys_inotify_init1,		"inotify_init1"		},
[5289] = { 4,	TD,		sys_preadv,			"preadv"		},
[5290] = { 4,	TD,		sys_pwritev,			"pwritev"		},
[5291] = { 4,	TP|TS,		sys_rt_tgsigqueueinfo,		"rt_tgsigqueueinfo"	},
[5292] = { 5,	TD,		sys_perf_event_open,		"perf_event_open"	},
[5293] = { 4,	TN,		sys_accept4,			"accept4"		},
[5294] = { 5,	TN,		sys_recvmmsg,			"recvmmsg"		},
[5295] = { 2,	TD,		sys_fanotify_init,		"fanotify_init"		},
[5296] = { 5,	TD|TF,		sys_fanotify_mark,		"fanotify_mark"		},
[5297] = { 4,	0,		sys_prlimit64,			"prlimit64"		},
[5298] = { 5,	TD|TF,		sys_name_to_handle_at,		"name_to_handle_at"	},
[5299] = { 3,	TD,		sys_open_by_handle_at,		"open_by_handle_at"	},
[5300] = { 2,	0,		sys_clock_adjtime,		"clock_adjtime"		},
[5301] = { 1,	TD,		sys_syncfs,			"syncfs"		},
[5302] = { 4,	TN,		sys_sendmmsg,			"sendmmsg"		},
[5303] = { 2,	TD,		sys_setns,			"setns"			},
[5304] = { 6,	0,		sys_process_vm_readv,		"process_vm_readv"	},
[5305] = { 6,	0,		sys_process_vm_writev,		"process_vm_writev"	},
[5306] = { 5,	0,		sys_kcmp,			"kcmp"			},
[5307] = { 3,	TD,		sys_finit_module,		"finit_module"		},
[5308] = { 3,	TD,		sys_getdents64,			"getdents64"		},
[5309] = { 3,	0,		sys_sched_setattr,		"sched_setattr"		},
[5310] = { 4,	0,		sys_sched_getattr,		"sched_getattr"		},
[5311] = { 5,	TD|TF,		sys_renameat2,			"renameat2"		},
[5312] = { 3,	0,		sys_seccomp,			"seccomp",		},
[5313] = { 3,	0,		sys_getrandom,			"getrandom",		},
[5314] = { 2,	TD,		sys_memfd_create,		"memfd_create",		},
[5315] = { 3,	TD,		sys_bpf,			"bpf",			},
[5316] = { 5,	TD|TF|TP|SE|SI,	sys_execveat,			"execveat",		},
[5317 ... 5399] = { },

# define SYS_socket_subcall      5400
# include "subcall.h"

/* end of Linux N64 */ [SYS_socket_subcall + SYS_socket_nsubcalls + SYS_ipc_nsubcalls ... 5999] = { },

#else

# include "syscallent-n64-stub.h"
/* end of Linux N64 */ [5400 ... 5999] = { },

#endif
