/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

class Modifiers
implements Comparable {
    public boolean isStatic = false;
    public boolean isFinal = false;
    public boolean isDeprecated = false;
    public String visibility = null;

    public int compareTo(Object o) {
        int comp;
        Modifiers oModifiers = (Modifiers)o;
        if (this.isStatic != oModifiers.isStatic) {
            return -1;
        }
        if (this.isFinal != oModifiers.isFinal) {
            return -1;
        }
        if (this.isDeprecated != oModifiers.isDeprecated) {
            return -1;
        }
        if (this.visibility != null && (comp = this.visibility.compareTo(oModifiers.visibility)) != 0) {
            return comp;
        }
        return 0;
    }

    public String diff(Modifiers newModifiers) {
        int comp;
        String res = "";
        boolean hasContent = false;
        if (this.isStatic != newModifiers.isStatic) {
            res = res + "Change from ";
            res = this.isStatic ? res + "static to non-static.<br>" : res + "non-static to static.<br>";
            hasContent = true;
        }
        if (this.isFinal != newModifiers.isFinal) {
            if (hasContent) {
                res = res + " ";
            }
            res = res + "Change from ";
            res = this.isFinal ? res + "final to non-final.<br>" : res + "non-final to final.<br>";
            hasContent = true;
        }
        if (this.isDeprecated != newModifiers.isDeprecated) {
            if (hasContent) {
                res = res + " ";
            }
            res = this.isDeprecated ? res + "Change from deprecated to undeprecated.<br>" : res + "<b>Now deprecated</b>.<br>";
            hasContent = true;
        }
        if (this.visibility != null && (comp = this.visibility.compareTo(newModifiers.visibility)) != 0) {
            if (hasContent) {
                res = res + " ";
            }
            res = res + "Change of visibility from " + this.visibility + " to " + newModifiers.visibility + ".<br>";
            hasContent = true;
        }
        if (res.compareTo("") == 0) {
            return null;
        }
        return res;
    }
}

