/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2014 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.hk2.testing.collections;

/**
 * This is the default implementation of TestCollectionElement
 * that will be used in tests if the getElement
 * method is not overridden
 *
 * @author Copyright 2011 Oracle
 */
public class DefaultTestCollectionElement implements TestCollectionElement,
    Comparable<TestCollectionElement> {
  private final String value;
  
  public DefaultTestCollectionElement(String paramValue) {
    value = paramValue;
  }

  /* (non-Javadoc)
   * @see com.oracle.weblogic.testing.collections.TestCollectionElement#testCollectionValue()
   */
  @Override
  public String testCollectionValue() {
    return value;
  }

  @Override
  public int compareTo(TestCollectionElement o) {
    if (o == null) return -1;
    return safeCompareTo(value, o.testCollectionValue());
  }
  
  public int hashCode() {
    return value.hashCode();
  }
  
  private final static int safeCompareTo(String a, String b) {
    if (a == b) return 0;
    if (a == null) return -1;
    if (b == null) return 1;
    return a.compareTo(b);
  }
  
  private final static boolean safeEquals(Object a, Object b) {
    if (a == b) return true;
    if (a == null) return false;
    if (b == null) return false;
    return a.equals(b);
  }
  
  public boolean equals(Object o) {
    if (o == null) return false;
    if (!(o instanceof DefaultTestCollectionElement)) return false;
    
    DefaultTestCollectionElement dtce = (DefaultTestCollectionElement) o;
    
    return safeEquals(value, dtce.value);
  }
  
  public String toString() {
    return "DefaultTestCollectionElement(" + value + "," + System.identityHashCode(this) + ")";
  }

}
