/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.ctm;

import java.lang.annotation.Annotation;
import org.glassfish.examples.ctm.Environment;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.BuilderHelper;

public class TenantLocatorGenerator {
    private static final ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
    public static final String ALICE = "Alice";
    public static final int ALICE_MIN = 1;
    public static final int ALICE_MAX = 2;
    public static final String BOB = "Bob";
    public static final int BOB_MIN = 10;
    public static final int BOB_MAX = 20;

    public ServiceLocator generateLocatorPerTenant(String tenantName) {
        if (tenantName == null) {
            throw new IllegalArgumentException();
        }
        EnvironmentImpl env = ALICE.equals(tenantName) ? new EnvironmentImpl(ALICE, 1, 2) : (BOB.equals(tenantName) ? new EnvironmentImpl(BOB, 10, 20) : new EnvironmentImpl(tenantName, 0, 100));
        ServiceLocator retVal = factory.create(tenantName);
        DynamicConfigurationService dcs = (DynamicConfigurationService)retVal.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor((ActiveDescriptor)BuilderHelper.createConstantDescriptor((Object)env));
        config.commit();
        return retVal;
    }

    private static class EnvironmentImpl
    implements Environment {
        private final String name;
        private final int min;
        private final int max;

        private EnvironmentImpl(String name, int min, int max) {
            this.name = name;
            this.min = min;
            this.max = max;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMinSize() {
            return this.min;
        }

        @Override
        public int getMaxSize() {
            return this.max;
        }
    }
}

