// Autogenerated AST node
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import java.util.Arrays;

public final class DictComp extends exprType {
    public exprType key;
    public exprType value;
    public comprehensionType[] generators;

    public DictComp(exprType key, exprType value, comprehensionType[] generators) {
        this.key = key;
        this.value = value;
        this.generators = generators;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((key == null) ? 0 : key.hashCode());
        result = prime * result + ((value == null) ? 0 : value.hashCode());
        result = prime * result + Arrays.hashCode(generators);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DictComp other = (DictComp) obj;
        if (key == null) {
            if (other.key != null)
                return false;
        } else if (!key.equals(other.key))
            return false;
        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        if (!Arrays.equals(generators, other.generators))
            return false;
        return true;
    }

    @Override
    public DictComp createCopy() {
        return createCopy(true);
    }

    @Override
    public DictComp createCopy(boolean copyComments) {
        comprehensionType[] new0;
        if (this.generators != null) {
            new0 = new comprehensionType[this.generators.length];
            for (int i = 0; i < this.generators.length; i++) {
                new0[i] = (comprehensionType) (this.generators[i] != null ? this.generators[i].createCopy(copyComments)
                        : null);
            }
        } else {
            new0 = this.generators;
        }
        DictComp temp = new DictComp(key != null ? (exprType) key.createCopy(copyComments) : null,
                value != null ? (exprType) value.createCopy(copyComments) : null, new0);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (o instanceof commentType) {
                    commentType commentType = (commentType) o;
                    temp.getSpecialsBefore().add(commentType.createCopy(copyComments));
                }
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (o instanceof commentType) {
                    commentType commentType = (commentType) o;
                    temp.getSpecialsAfter().add(commentType.createCopy(copyComments));
                }
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("DictComp[");
        sb.append("key=");
        sb.append(dumpThis(this.key));
        sb.append(", ");
        sb.append("value=");
        sb.append(dumpThis(this.value));
        sb.append(", ");
        sb.append("generators=");
        sb.append(dumpThis(this.generators));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitDictComp(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (key != null) {
            key.accept(visitor);
        }
        if (value != null) {
            value.accept(visitor);
        }
        if (generators != null) {
            for (int i = 0; i < generators.length; i++) {
                if (generators[i] != null) {
                    generators[i].accept(visitor);
                }
            }
        }
    }

}
