/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.combinations$PyExposer;
import org.python.modules.itertools.itertools;

@ExposedType(name="itertools.combinations", base=PyObject.class)
public class combinations
extends PyObject {
    public static final PyType TYPE;
    private PyIterator iter;
    public static PyString __doc__;

    public combinations() {
    }

    public combinations(PyType subType) {
        super(subType);
    }

    public combinations(PyObject iterable, int r) {
        this.combinations___init__(iterable, r);
    }

    @ExposedNew
    final void combinations___init__(PyObject[] args, String[] kwds) {
        if (args.length > 2) {
            throw Py.TypeError(String.format("combinations_with_replacement() takes at most 2 arguments (%d given)", args.length));
        }
        ArgParser ap = new ArgParser("combinations_with_replacement", args, kwds, "iterable", "r");
        PyObject iterable = ap.getPyObject(0);
        int r = ap.getInt(1);
        if (r < 0) {
            throw Py.ValueError("r must be non-negative");
        }
        this.combinations___init__(iterable, r);
    }

    private void combinations___init__(PyObject iterable, int r) {
        if (r < 0) {
            throw Py.ValueError("r must be non-negative");
        }
        PyTuple pool = PyTuple.fromIterable(iterable);
        int n = pool.__len__();
        int[] indices = new int[r];
        for (int i = 0; i < r; ++i) {
            indices[i] = i;
        }
        this.iter = new itertools.ItertoolsIterator(this, r, n, pool, indices){
            private boolean firstthru = true;
            private /* synthetic */ int val$r;
            private /* synthetic */ int val$n;
            private /* synthetic */ PyTuple val$pool;
            private /* synthetic */ int[] val$indices;
            private /* synthetic */ combinations this$0;
            {
                this.val$r = n;
                this.val$n = n2;
                this.val$pool = pyTuple;
                this.val$indices = nArray;
            }

            @Override
            public PyObject __iternext__() {
                int i;
                if (this.val$r > this.val$n) {
                    return null;
                }
                if (this.firstthru) {
                    this.firstthru = false;
                    return itertools.makeIndexedTuple(this.val$pool, this.val$indices);
                }
                for (i = this.val$r - 1; i >= 0 && this.val$indices[i] == i + this.val$n - this.val$r; --i) {
                }
                if (i < 0) {
                    return null;
                }
                int n = i;
                this.val$indices[n] = this.val$indices[n] + 1;
                for (int j = i + 1; j < this.val$r; ++j) {
                    this.val$indices[j] = this.val$indices[j - 1] + 1;
                }
                return itertools.makeIndexedTuple(this.val$pool, this.val$indices);
            }
        };
    }

    @Override
    public PyObject __iter__() {
        return this.iter;
    }

    public PyObject next() {
        return this.iter.next();
    }

    static {
        PyType.addBuilder(combinations.class, new combinations$PyExposer());
        TYPE = PyType.fromClass(combinations.class);
        __doc__ = new PyString("combinations(iterable, r) --> combinations object\n\nReturn successive r-length combinations of elements in the iterable.\n\ncombinations(range(4), 3) --> (0,1,2), (0,1,3), (0,2,3), (1,2,3)");
    }
}

