/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.util.concurrent.ListenableFuture;
import org.python.google.common.util.concurrent.ListeningExecutorService;
import org.python.google.common.util.concurrent.MoreExecutors$SameThreadExecutorService;

public class AsyncFunction
implements AsyncFunction<ListenableFuture<Object>, Object> {
    AsyncFunction() {
    }

    public static ListeningExecutorService sameThreadExecutor() {
        return new MoreExecutors$SameThreadExecutorService(0);
    }

    static <T> T invokeAnyImpl(ListeningExecutorService executorService, Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException ee;
        ArrayList<ListenableFuture<T>> futures;
        block15: {
            int ntasks = tasks.size();
            CharMatcher.LookupTable.checkArgument(ntasks > 0);
            int n = ntasks;
            CharMatcher.LookupTable.checkArgument(n >= 0);
            futures = new ArrayList<ListenableFuture<T>>(n);
            LinkedBlockingQueue<Future<T>> futureQueue = new LinkedBlockingQueue<Future<T>>();
            ee = null;
            long lastTime = timed ? System.nanoTime() : 0L;
            Iterator<Callable<T>> it = tasks.iterator();
            futures.add(AsyncFunction.submitAndAddQueueListener(executorService, it.next(), futureQueue));
            --ntasks;
            int active = 1;
            while (true) {
                Object v;
                Future f;
                if ((f = (Future)futureQueue.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(AsyncFunction.submitAndAddQueueListener(executorService, it.next(), futureQueue));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed) {
                            f = (Future)futureQueue.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now = System.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        } else {
                            f = (Future)futureQueue.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    v = f.get();
                }
                catch (ExecutionException executionException) {
                    ExecutionException eex = executionException;
                    ee = executionException;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                return (T)v;
                break;
            }
            if (ee != null) break block15;
            ee = new ExecutionException(null);
        }
        throw ee;
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    private static <T> ListenableFuture<T> submitAndAddQueueListener(ListeningExecutorService executorService, Callable<T> task, BlockingQueue<Future<T>> queue) {
        Future future = executorService.submit((Callable)task);
        future.addListener(new Runnable(queue, (ListenableFuture)future){
            private /* synthetic */ BlockingQueue val$queue;
            private /* synthetic */ ListenableFuture val$future;
            {
                this.val$queue = blockingQueue;
                this.val$future = listenableFuture;
            }

            public final void run() {
                this.val$queue.add(this.val$future);
            }
        }, AsyncFunction.sameThreadExecutor());
        return future;
    }
}

