/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.Codecs;
import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.grinder.common.GrinderException;
import net.grinder.plugin.http.HTTPPluginThreadState;
import net.grinder.plugin.http.HTTPUtilities;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressions;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressionsImplementation;
import net.grinder.plugininterface.PluginProcessContext;
import net.grinder.util.AttributeStringParser;
import net.grinder.util.AttributeStringParserImplementation;
import net.grinder.util.URIParser;
import net.grinder.util.URIParserImplementation;

class HTTPUtilitiesImplementation
implements HTTPUtilities {
    private final URIParser m_uriParser = new URIParserImplementation();
    private final RegularExpressions m_regularExpressions = new RegularExpressionsImplementation();
    private final AttributeStringParser m_attributeStringParser = new AttributeStringParserImplementation();
    private final ThreadLocal m_parsedBodyThreadLocal = new ThreadLocal();
    private final NameValue[] m_emptyNameValues = new NameValue[0];
    private final PluginProcessContext m_processContext;

    public HTTPUtilitiesImplementation(PluginProcessContext processContext) {
        this.m_processContext = processContext;
    }

    public NVPair basicAuthorizationHeader(String userID, String password) {
        return new NVPair("Authorization", "Basic " + Codecs.base64Encode(userID + ":" + password));
    }

    public HTTPResponse getLastResponse() throws GrinderException {
        HTTPPluginThreadState threadState = (HTTPPluginThreadState)this.m_processContext.getPluginThreadListener();
        return threadState.getLastResponse();
    }

    public String valueFromLocationURI(final String tokenName) throws GrinderException {
        String location;
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return "";
        }
        try {
            location = response.getHeader("Location");
        }
        catch (Exception e) {
            throw new AssertionError((Object)("HTTPResponse not initialised (" + e + ")"));
        }
        final String[] result = new String[]{""};
        if (location != null) {
            this.m_uriParser.parse(location, new URIParser.AbstractParseListener(){

                public boolean pathParameterNameValue(String name, String value) {
                    if (name.equals(tokenName)) {
                        result[0] = value;
                        return false;
                    }
                    return true;
                }

                public boolean queryStringNameValue(String name, String value) {
                    if (name.equals(tokenName)) {
                        result[0] = value;
                        return false;
                    }
                    return true;
                }
            });
        }
        return result[0];
    }

    public String valueFromHiddenInput(String tokenName) throws GrinderException {
        return this.valueFromHiddenInput(tokenName, null);
    }

    public String valueFromHiddenInput(String tokenName, String afterText) throws GrinderException {
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return "";
        }
        return this.getParsedBody(response).valueFromHiddenInput(tokenName, afterText);
    }

    public String valueFromBodyURI(String tokenName) throws GrinderException {
        return this.valueFromBodyURI(tokenName, null);
    }

    public String valueFromBodyURI(String tokenName, String afterText) throws GrinderException {
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return "";
        }
        return this.getParsedBody(response).valueFromBodyURI(tokenName, afterText);
    }

    private ParsedBody getParsedBody(HTTPResponse response) {
        ParsedBody original = (ParsedBody)this.m_parsedBodyThreadLocal.get();
        if (original != null && original.isValidForResponse(response)) {
            return original;
        }
        ParsedBody newParsedBody = new ParsedBody(response);
        this.m_parsedBodyThreadLocal.set(newParsedBody);
        return newParsedBody;
    }

    private final class BodyURIMatchList
    extends AbstractMatchList {
        public BodyURIMatchList(String body) {
            super(HTTPUtilitiesImplementation.this.m_regularExpressions.getHyperlinkURIPattern().matcher(body));
        }

        protected NameValue[] parseMatch() {
            ArrayList result = new ArrayList();
            String uri = this.getMatcher().group(1);
            HTTPUtilitiesImplementation.this.m_uriParser.parse(uri, new URIParser.AbstractParseListener(this, result){
                private final /* synthetic */ List val$result;
                private final /* synthetic */ BodyURIMatchList this$1;
                {
                    this.this$1 = this$1;
                    this.val$result = val$result;
                }

                public boolean pathParameterNameValue(String name, String value) {
                    this.val$result.add(new NameValue(name, value));
                    return true;
                }

                public boolean queryStringNameValue(String name, String value) {
                    this.val$result.add(new NameValue(name, value));
                    return true;
                }
            });
            return result.toArray(new NameValue[result.size()]);
        }
    }

    private final class HiddenInputMatchList
    extends AbstractMatchList {
        public HiddenInputMatchList(String body) {
            super(HTTPUtilitiesImplementation.this.m_regularExpressions.getHiddenInputPattern().matcher(body));
        }

        protected NameValue[] parseMatch() {
            AttributeStringParser.AttributeMap map = HTTPUtilitiesImplementation.this.m_attributeStringParser.parse(this.getMatcher().group());
            String name = map.get("name");
            String value = map.get("value");
            if (name != null && value != null) {
                return new NameValue[]{new NameValue(name, value)};
            }
            return HTTPUtilitiesImplementation.this.m_emptyNameValues;
        }
    }

    private static abstract class AbstractMatchList
    implements MatchList {
        private final Matcher m_matcher;
        private final CachedValueMap m_cache = new CachedValueMap();

        public AbstractMatchList(Matcher matcher) {
            this.m_matcher = matcher;
        }

        public final String getTokenValue(String tokenName, int startFrom) {
            CachedValueList cachedValueList = this.m_cache.get(tokenName);
            String existingValue = cachedValueList.getValue(startFrom);
            if (existingValue != null) {
                return existingValue;
            }
            while (this.m_matcher.find()) {
                NameValue[] nameValueArray = this.parseMatch();
                int matchPosition = this.m_matcher.start();
                String result = null;
                for (int i = 0; i < nameValueArray.length; ++i) {
                    String name = nameValueArray[i].getName();
                    String value = nameValueArray[i].getValue();
                    if (name.equals(tokenName)) {
                        cachedValueList.addValue(matchPosition, value);
                        if (result != null || matchPosition < startFrom) continue;
                        result = value;
                        continue;
                    }
                    this.m_cache.get(name).addValue(matchPosition, value);
                }
                if (result == null) continue;
                return result;
            }
            return "";
        }

        protected final Matcher getMatcher() {
            return this.m_matcher;
        }

        protected abstract NameValue[] parseMatch();
    }

    private static class CachedValueMap {
        private final Map m_map = new HashMap();

        private CachedValueMap() {
        }

        public CachedValueList get(String tokenName) {
            CachedValueList existing = (CachedValueList)this.m_map.get(tokenName);
            if (existing != null) {
                return existing;
            }
            CachedValueList newCachedValueList = new CachedValueList();
            this.m_map.put(tokenName, newCachedValueList);
            return newCachedValueList;
        }
    }

    private static interface MatchList {
        public String getTokenValue(String var1, int var2);
    }

    private static class CachedValueList {
        private final List m_valuesByPosition = new ArrayList();

        private CachedValueList() {
        }

        public void addValue(int position, String value) {
            this.m_valuesByPosition.add(new PositionAndValue(position, value));
        }

        public String getValue(int startFrom) {
            Iterator iterator = this.m_valuesByPosition.iterator();
            while (iterator.hasNext()) {
                PositionAndValue positionAndValue = (PositionAndValue)iterator.next();
                if (positionAndValue.getPosition() < startFrom) continue;
                return positionAndValue.getValue();
            }
            return null;
        }

        private static final class PositionAndValue {
            private final int m_position;
            private final String m_value;

            public PositionAndValue(int position, String value) {
                this.m_position = position;
                this.m_value = value;
            }

            public int getPosition() {
                return this.m_position;
            }

            public String getValue() {
                return this.m_value;
            }
        }
    }

    private static final class NameValue {
        private final String m_name;
        private final String m_value;

        public NameValue(String name, String value) {
            this.m_name = name;
            this.m_value = value;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }
    }

    private final class ParsedBody {
        private final HTTPResponse m_response;
        private final String m_body;
        private final MatchList m_hiddenInputMatchList;
        private final MatchList m_bodyURIMatchList;

        public ParsedBody(HTTPResponse response) {
            this.m_response = response;
            try {
                this.m_body = response.getText();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            this.m_hiddenInputMatchList = new HiddenInputMatchList(this.m_body);
            this.m_bodyURIMatchList = new BodyURIMatchList(this.m_body);
        }

        public boolean isValidForResponse(HTTPResponse response) {
            return this.m_response.equals(response);
        }

        public String valueFromHiddenInput(String tokenName, String afterText) {
            int startFrom = this.getStartFrom(afterText);
            if (startFrom == -1) {
                return "";
            }
            return this.m_hiddenInputMatchList.getTokenValue(tokenName, startFrom);
        }

        public String valueFromBodyURI(String tokenName, String afterText) {
            int startFrom = this.getStartFrom(afterText);
            if (startFrom == -1) {
                return "";
            }
            return this.m_bodyURIMatchList.getTokenValue(tokenName, startFrom);
        }

        private int getStartFrom(String text) {
            return text == null ? 0 : this.m_body.indexOf(text);
        }
    }
}

