/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NUrl;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public class Builtins {
    public static final String LIBRARY_URL = "http://docs.python.org/library/";
    public static final String TUTORIAL_URL = "http://docs.python.org/tutorial/";
    public static final String REFERENCE_URL = "http://docs.python.org/reference/";
    public static final String DATAMODEL_URL = "http://docs.python.org/reference/datamodel#";
    public NModuleType Builtin;
    public NClassType Object;
    public NClassType Type;
    public NClassType None;
    public NClassType BaseNum;
    public NClassType BaseComplex;
    public NClassType BaseBool;
    public NClassType BaseStr;
    public NClassType BaseList;
    public NClassType BaseArray;
    public NClassType BaseDict;
    public NClassType BaseTuple;
    public NClassType BaseModule;
    public NClassType BaseFile;
    public NClassType BaseException;
    public NClassType BaseStruct;
    public NClassType BaseFunction;
    public NClassType BaseClass;
    public NClassType Datetime_datetime;
    public NClassType Datetime_date;
    public NClassType Datetime_time;
    public NClassType Datetime_timedelta;
    public NClassType Datetime_tzinfo;
    public NClassType Time_struct_time;
    Scope globaltable;
    Scope moduleTable;
    String[] builtin_exception_types = new String[]{"ArithmeticError", "AssertionError", "AttributeError", "BaseException", "BytesWarning", "Exception", "DeprecationWarning", "EOFError", "EnvironmentError", "FloatingPointError", "FutureWarning", "GeneratorExit", "IOError", "ImportError", "ImportWarning", "IndentationError", "IndexError", "KeyError", "KeyboardInterrupt", "LookupError", "MemoryError", "NameError", "NotImplemented", "NotImplementedError", "OSError", "OverflowError", "PendingDeprecationWarning", "ReferenceError", "RuntimeError", "RuntimeWarning", "StandardError", "StopIteration", "SyntaxError", "SyntaxWarning", "SystemError", "SystemExit", "TabError", "TypeError", "UnboundLocalError", "UnicodeDecodeError", "UnicodeEncodeError", "UnicodeError", "UnicodeTranslateError", "UnicodeWarning", "UserWarning", "ValueError", "Warning", "ZeroDivisionError"};
    private Set<NType> nativeTypes = new HashSet<NType>();
    private Map<String, NativeModule> modules = new HashMap<String, NativeModule>();

    public static NUrl newLibUrl(String module, String name) {
        return Builtins.newLibUrl(module + ".html#" + name);
    }

    public static NUrl newLibUrl(String path) {
        if (!path.endsWith(".html")) {
            path = path + ".html";
        }
        return new NUrl(LIBRARY_URL + path);
    }

    public static NUrl newRefUrl(String path) {
        return new NUrl(REFERENCE_URL + path);
    }

    public static NUrl newDataModelUrl(String path) {
        return new NUrl(DATAMODEL_URL + path);
    }

    public static NUrl newTutUrl(String path) {
        return new NUrl(TUTORIAL_URL + path);
    }

    private NClassType newClass(String name, Scope table) {
        return this.newClass(name, table, null, new NClassType[0]);
    }

    final NClassType newClass(String name, Scope table, NClassType superClass, NClassType ... moreSupers) {
        NClassType t = new NClassType(name, table, superClass);
        NClassType[] arr$ = moreSupers;
        int len$ = moreSupers.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NClassType c = arr$[i$];
            t.addSuper(c);
        }
        this.nativeTypes.add(t);
        return t;
    }

    final NModuleType newModule(String name) {
        NModuleType mt = new NModuleType(name, null, this.globaltable);
        this.nativeTypes.add(mt);
        return mt;
    }

    final NUnknownType unknown() {
        NUnknownType t = new NUnknownType();
        this.nativeTypes.add(t);
        return t;
    }

    final NClassType newException(String name, Scope t) {
        return this.newClass(name, t, this.BaseException, new NClassType[0]);
    }

    final NFuncType newFunc() {
        NFuncType t = new NFuncType();
        this.nativeTypes.add(t);
        return t;
    }

    final NFuncType newFunc(NType type) {
        NFuncType t = new NFuncType(type);
        this.nativeTypes.add(t);
        return t;
    }

    final NListType newList() {
        return this.newList(this.unknown());
    }

    final NListType newList(NType type) {
        NListType t = new NListType(type);
        this.nativeTypes.add(t);
        return t;
    }

    final NDictType newDict(NType ktype, NType vtype) {
        NDictType t = new NDictType(ktype, vtype);
        this.nativeTypes.add(t);
        return t;
    }

    final NTupleType newTuple(NType ... types) {
        NTupleType t = new NTupleType(types);
        this.nativeTypes.add(t);
        return t;
    }

    final NUnionType newUnion(NType ... types) {
        NUnionType t = new NUnionType(types);
        this.nativeTypes.add(t);
        return t;
    }

    static String[] list(String ... names) {
        return names;
    }

    public Builtins(Scope globals, Scope modules) {
        this.globaltable = globals;
        this.moduleTable = modules;
        this.buildTypes();
    }

    private void buildTypes() {
        new BuiltinsModule(this);
        Scope bt = this.Builtin.getTable();
        this.Object = this.newClass("object", bt);
        this.None = this.newClass("None", bt);
        this.Type = this.newClass("type", bt, this.Object, new NClassType[0]);
        this.BaseTuple = this.newClass("tuple", bt, this.Object, new NClassType[0]);
        this.BaseList = this.newClass("list", bt, this.Object, new NClassType[0]);
        this.BaseArray = this.newClass("array", bt);
        this.BaseDict = this.newClass("dict", bt, this.Object, new NClassType[0]);
        this.BaseNum = this.newClass("float", bt, this.Object, new NClassType[0]);
        this.BaseComplex = this.newClass("complex", bt, this.Object, new NClassType[0]);
        this.BaseBool = this.newClass("bool", bt, this.BaseNum, new NClassType[0]);
        this.BaseStr = this.newClass("str", bt, this.Object, new NClassType[0]);
        this.BaseModule = this.newClass("module", bt);
        this.BaseFile = this.newClass("file", bt, this.Object, new NClassType[0]);
        this.BaseFunction = this.newClass("function", bt, this.Object, new NClassType[0]);
        this.BaseClass = this.newClass("classobj", bt, this.Object, new NClassType[0]);
    }

    final void init() {
        String string;
        int n;
        String string2;
        String string3;
        int n2;
        Builtins builtins = this;
        Object object = new String[]{"__delattr__", "__format__", "__getattribute__", "__hash__", "__init__", "__new__", "__reduce__", "__reduce_ex__", "__repr__", "__setattr__", "__sizeof__", "__str__", "__subclasshook__"};
        Object object2 = object;
        for (n2 = 0; n2 < 13; ++n2) {
            String string4 = object2[n2];
            builtins.Object.getTable().update(string4, Builtins.newLibUrl("stdtypes"), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        }
        builtins.Object.getTable().update("__doc__", Builtins.newLibUrl("stdtypes"), (NType)builtins.BaseStr, NBinding.Kind.CLASS);
        builtins.Object.getTable().update("__class__", Builtins.newLibUrl("stdtypes"), (NType)builtins.unknown(), NBinding.Kind.CLASS);
        builtins = this;
        object = builtins.BaseTuple.getTable();
        object2 = new String[]{"__add__", "__contains__", "__eq__", "__ge__", "__getnewargs__", "__gt__", "__iter__", "__le__", "__len__", "__lt__", "__mul__", "__ne__", "__new__", "__rmul__", "count", "index"};
        Object object3 = object2;
        for (int i = 0; i < 16; ++i) {
            string3 = object3[i];
            ((Scope)object).update(string3, Builtins.newLibUrl("stdtypes"), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        }
        object3 = ((Scope)object).update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        ((NBinding)object3).markDeprecated();
        ((Scope)object).update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        ((Scope)object).update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        builtins = this;
        object = new String[]{"append", "buffer_info", "byteswap", "extend", "fromfile", "fromlist", "fromstring", "fromunicode", "index", "insert", "pop", "read", "remove", "reverse", "tofile", "tolist", "typecode", "write"};
        object2 = object;
        for (n2 = 0; n2 < 18; ++n2) {
            String string5 = object2[n2];
            builtins.BaseArray.getTable().update(string5, Builtins.newLibUrl("array"), (NType)builtins.newFunc(builtins.None), NBinding.Kind.METHOD);
        }
        object2 = new String[]{"count", "itemsize"};
        object3 = object2;
        for (int i = 0; i < 2; ++i) {
            string3 = object3[i];
            builtins.BaseArray.getTable().update(string3, Builtins.newLibUrl("array"), (NType)builtins.newFunc(builtins.BaseNum), NBinding.Kind.METHOD);
        }
        object3 = new String[]{"tostring", "tounicode"};
        String[] stringArray = object3;
        for (int i = 0; i < 2; ++i) {
            string2 = stringArray[i];
            builtins.BaseArray.getTable().update(string2, Builtins.newLibUrl("array"), (NType)builtins.newFunc(builtins.BaseStr), NBinding.Kind.METHOD);
        }
        builtins = this;
        builtins.BaseList.getTable().update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)builtins.newFunc(builtins.BaseList), NBinding.Kind.METHOD);
        builtins.BaseList.getTable().update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)builtins.newFunc(builtins.BaseList), NBinding.Kind.METHOD);
        builtins.BaseList.getTable().update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)builtins.newFunc(builtins.BaseList), NBinding.Kind.METHOD);
        object = new String[]{"append", "extend", "index", "insert", "pop", "remove", "reverse", "sort"};
        object2 = object;
        for (int i = 0; i < 8; ++i) {
            String string6 = object2[i];
            builtins.BaseList.getTable().update(string6, Builtins.newLibUrl("stdtypes"), (NType)builtins.newFunc(builtins.None), NBinding.Kind.METHOD);
        }
        object2 = new String[]{"count"};
        object3 = object2;
        for (int i = 0; i <= 0; ++i) {
            String string7 = object3[0];
            builtins.BaseList.getTable().update(string7, Builtins.newLibUrl("stdtypes"), (NType)builtins.newFunc(builtins.BaseNum), NBinding.Kind.METHOD);
        }
        builtins = this;
        object = "datastructures.html#dictionaries";
        object2 = builtins.BaseDict.getTable();
        ((Scope)object2).update("__getitem__", Builtins.newTutUrl((String)object), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        ((Scope)object2).update("__iter__", Builtins.newTutUrl((String)object), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        ((Scope)object2).update("get", Builtins.newTutUrl((String)object), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        ((Scope)object2).update("items", Builtins.newTutUrl((String)object), (NType)builtins.newFunc(builtins.newList(builtins.newTuple(builtins.unknown(), builtins.unknown()))), NBinding.Kind.METHOD);
        ((Scope)object2).update("keys", Builtins.newTutUrl((String)object), (NType)builtins.newFunc(builtins.BaseList), NBinding.Kind.METHOD);
        ((Scope)object2).update("values", Builtins.newTutUrl((String)object), (NType)builtins.newFunc(builtins.BaseList), NBinding.Kind.METHOD);
        object3 = new String[]{"clear", "copy", "fromkeys", "get", "iteritems", "iterkeys", "itervalues", "pop", "popitem", "setdefault", "update"};
        String[] stringArray2 = object3;
        for (int i = 0; i < 11; ++i) {
            string2 = stringArray2[i];
            ((Scope)object2).update(string2, Builtins.newTutUrl((String)object), (NType)builtins.newFunc(), NBinding.Kind.METHOD);
        }
        stringArray2 = new String[]{"has_key"};
        String[] stringArray3 = stringArray2;
        for (n = 0; n <= 0; ++n) {
            string = stringArray3[0];
            ((Scope)object2).update(string, Builtins.newTutUrl((String)object), (NType)builtins.newFunc(builtins.BaseNum), NBinding.Kind.METHOD);
        }
        builtins = this;
        object = builtins.BaseNum.getTable();
        object2 = new String[]{"__abs__", "__add__", "__coerce__", "__div__", "__divmod__", "__eq__", "__float__", "__floordiv__", "__format__", "__ge__", "__getformat__", "__gt__", "__int__", "__le__", "__long__", "__lt__", "__mod__", "__mul__", "__ne__", "__neg__", "__new__", "__nonzero__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__setformat__", "__sub__", "__truediv__", "__trunc__", "as_integer_ratio", "fromhex", "is_integer"};
        object3 = object2;
        for (int i = 0; i < 40; ++i) {
            String string8 = object3[i];
            ((Scope)object).update(string8, Builtins.numUrl(), (NType)builtins.newFunc(builtins.BaseNum), NBinding.Kind.METHOD);
        }
        ((Scope)object).update("__getnewargs__", Builtins.numUrl(), (NType)builtins.newFunc(builtins.newTuple(builtins.BaseNum)), NBinding.Kind.METHOD);
        ((Scope)object).update("hex", Builtins.numUrl(), (NType)builtins.newFunc(builtins.BaseStr), NBinding.Kind.METHOD);
        ((Scope)object).update("conjugate", Builtins.numUrl(), (NType)builtins.newFunc(builtins.BaseComplex), NBinding.Kind.METHOD);
        object3 = builtins.BaseComplex.getTable();
        stringArray2 = new String[]{"__abs__", "__add__", "__div__", "__divmod__", "__float__", "__floordiv__", "__format__", "__getformat__", "__int__", "__long__", "__mod__", "__mul__", "__neg__", "__new__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__sub__", "__truediv__", "conjugate"};
        Object object4 = stringArray2;
        for (n = 0; n < 28; ++n) {
            string = object4[n];
            ((Scope)object3).update(string, Builtins.numUrl(), (NType)builtins.newFunc(builtins.BaseComplex), NBinding.Kind.METHOD);
        }
        object4 = new String[]{"__eq__", "__ge__", "__gt__", "__le__", "__lt__", "__ne__", "__nonzero__", "__coerce__"};
        Object object5 = object4;
        for (int i = 0; i < 8; ++i) {
            String string9 = object5[i];
            ((Scope)object3).update(string9, Builtins.numUrl(), (NType)builtins.newFunc(builtins.BaseNum), NBinding.Kind.METHOD);
        }
        ((Scope)object3).update("__getnewargs__", Builtins.numUrl(), (NType)builtins.newFunc(builtins.newTuple(builtins.BaseComplex)), NBinding.Kind.METHOD);
        ((Scope)object3).update("imag", Builtins.numUrl(), (NType)builtins.BaseNum, NBinding.Kind.ATTRIBUTE);
        ((Scope)object3).update("real", Builtins.numUrl(), (NType)builtins.BaseNum, NBinding.Kind.ATTRIBUTE);
        builtins = this;
        builtins.BaseStr.getTable().update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)builtins.newFunc(builtins.BaseStr), NBinding.Kind.METHOD);
        builtins.BaseStr.getTable().update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)builtins.newFunc(builtins.BaseStr), NBinding.Kind.METHOD);
        builtins.BaseStr.getTable().update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)builtins.newFunc(builtins.BaseStr), NBinding.Kind.METHOD);
        object = new String[]{"capitalize", "center", "decode", "encode", "expandtabs", "format", "index", "join", "ljust", "lower", "lstrip", "partition", "replace", "rfind", "rindex", "rjust", "rpartition", "rsplit", "rstrip", "strip", "swapcase", "title", "translate", "upper", "zfill"};
        object2 = object;
        for (int i = 0; i < 25; ++i) {
            object4 = object2[i];
            builtins.BaseStr.getTable().update((String)object4, Builtins.newLibUrl("stdtypes.html#str." + (String)object4), (NType)builtins.newFunc(builtins.BaseStr), NBinding.Kind.METHOD);
        }
        object2 = new String[]{"count", "isalnum", "isalpha", "isdigit", "islower", "isspace", "istitle", "isupper", "find", "startswith", "endswith"};
        object3 = object2;
        for (int i = 0; i < 11; ++i) {
            object5 = object3[i];
            builtins.BaseStr.getTable().update((String)object5, Builtins.newLibUrl("stdtypes.html#str." + (String)object5), (NType)builtins.newFunc(builtins.BaseNum), NBinding.Kind.METHOD);
        }
        object3 = new String[]{"split", "splitlines"};
        String[] stringArray4 = object3;
        for (int i = 0; i < 2; ++i) {
            String string10 = stringArray4[i];
            builtins.BaseStr.getTable().update(string10, Builtins.newLibUrl("stdtypes.html#str." + string10), (NType)builtins.newFunc(builtins.newList(builtins.BaseStr)), NBinding.Kind.METHOD);
        }
        builtins.BaseStr.getTable().update("partition", Builtins.newLibUrl("stdtypes"), (NType)builtins.newFunc(builtins.newTuple(builtins.BaseStr)), NBinding.Kind.METHOD);
        this.buildModuleType();
        this.buildFileType();
        this.buildFunctionType();
        this.buildClassType();
        this.modules.get("__builtin__").initBindings();
        new ArrayModule(this);
        new AudioopModule(this);
        new BinasciiModule(this);
        new Bz2Module(this);
        new CPickleModule(this);
        new CStringIOModule(this);
        new CMathModule(this);
        new CollectionsModule(this);
        new CryptModule(this);
        new CTypesModule(this);
        new DatetimeModule(this);
        new DbmModule(this);
        new ErrnoModule(this);
        new ExceptionsModule(this);
        new FcntlModule(this);
        new FpectlModule(this);
        new GcModule(this);
        new GdbmModule(this);
        new GrpModule(this);
        new ImpModule(this);
        new ItertoolsModule(this);
        new MarshalModule(this);
        new MathModule(this);
        new Md5Module(this);
        new MmapModule(this);
        new NisModule(this);
        new OperatorModule(this);
        new OsModule(this);
        new ParserModule(this);
        new PosixModule(this);
        new PwdModule(this);
        new PyexpatModule(this);
        new ReadlineModule(this);
        new ResourceModule(this);
        new SelectModule(this);
        new SignalModule(this);
        new ShaModule(this);
        new SpwdModule(this);
        new StropModule(this);
        new StructModule(this);
        new SysModule(this);
        new SyslogModule(this);
        new TermiosModule(this);
        new ThreadModule(this);
        new TimeModule(this);
        new UnicodedataModule(this);
        new ZipimportModule(this);
        new ZlibModule(this);
    }

    public NModuleType get(String name) {
        if (name.indexOf(".") == -1) {
            return this.getModule(name);
        }
        String[] mods = name.split("\\.");
        NType type = this.getModule(mods[0]);
        if (type == null) {
            return null;
        }
        for (int i = 1; i < mods.length; ++i) {
            if ((type = type.getTable().lookupType(mods[i])) instanceof NModuleType) continue;
            return null;
        }
        return type;
    }

    private NModuleType getModule(String name) {
        NativeModule wrap = this.modules.get(name);
        if (wrap == null) {
            return null;
        }
        return wrap.getModule();
    }

    public boolean isNative(NType type) {
        return this.nativeTypes.contains(type);
    }

    private void buildObjectType() {
        String[] obj_methods = new String[]{"__delattr__", "__format__", "__getattribute__", "__hash__", "__init__", "__new__", "__reduce__", "__reduce_ex__", "__repr__", "__setattr__", "__sizeof__", "__str__", "__subclasshook__"};
        String[] arr$ = obj_methods;
        for (int i$ = 0; i$ < 13; ++i$) {
            String m = arr$[i$];
            this.Object.getTable().update(m, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        this.Object.getTable().update("__doc__", Builtins.newLibUrl("stdtypes"), (NType)this.BaseStr, NBinding.Kind.CLASS);
        this.Object.getTable().update("__class__", Builtins.newLibUrl("stdtypes"), (NType)this.unknown(), NBinding.Kind.CLASS);
    }

    private void buildTupleType() {
        Scope bt = this.BaseTuple.getTable();
        String[] tuple_methods = new String[]{"__add__", "__contains__", "__eq__", "__ge__", "__getnewargs__", "__gt__", "__iter__", "__le__", "__len__", "__lt__", "__mul__", "__ne__", "__new__", "__rmul__", "count", "index"};
        String[] arr$ = tuple_methods;
        for (int i$ = 0; i$ < 16; ++i$) {
            String m = arr$[i$];
            bt.update(m, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        NBinding b = bt.update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        b.markDeprecated();
        bt.update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        bt.update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
    }

    private void buildArrayType() {
        String[] array_methods_none = new String[]{"append", "buffer_info", "byteswap", "extend", "fromfile", "fromlist", "fromstring", "fromunicode", "index", "insert", "pop", "read", "remove", "reverse", "tofile", "tolist", "typecode", "write"};
        String[] arr$ = array_methods_none;
        for (int i$ = 0; i$ < 18; ++i$) {
            String m = arr$[i$];
            this.BaseArray.getTable().update(m, Builtins.newLibUrl("array"), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        String[] array_methods_num = new String[]{"count", "itemsize"};
        String[] arr$2 = array_methods_num;
        for (int i$ = 0; i$ < 2; ++i$) {
            String m = arr$2[i$];
            this.BaseArray.getTable().update(m, Builtins.newLibUrl("array"), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        String[] array_methods_str = new String[]{"tostring", "tounicode"};
        String[] arr$3 = array_methods_str;
        for (int i$ = 0; i$ < 2; ++i$) {
            String m = arr$3[i$];
            this.BaseArray.getTable().update(m, Builtins.newLibUrl("array"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
    }

    private void buildListType() {
        this.BaseList.getTable().update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        this.BaseList.getTable().update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        this.BaseList.getTable().update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        String[] list_methods_none = new String[]{"append", "extend", "index", "insert", "pop", "remove", "reverse", "sort"};
        String[] arr$ = list_methods_none;
        for (int i$ = 0; i$ < 8; ++i$) {
            String m = arr$[i$];
            this.BaseList.getTable().update(m, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        String[] list_methods_num = new String[]{"count"};
        String[] arr$2 = list_methods_num;
        for (int i$ = 0; i$ <= 0; ++i$) {
            String m = arr$2[0];
            this.BaseList.getTable().update(m, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
    }

    private static NUrl numUrl() {
        return Builtins.newLibUrl("stdtypes", "typesnumeric");
    }

    private void buildNumTypes() {
        Scope bnt = this.BaseNum.getTable();
        String[] num_methods_num = new String[]{"__abs__", "__add__", "__coerce__", "__div__", "__divmod__", "__eq__", "__float__", "__floordiv__", "__format__", "__ge__", "__getformat__", "__gt__", "__int__", "__le__", "__long__", "__lt__", "__mod__", "__mul__", "__ne__", "__neg__", "__new__", "__nonzero__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__setformat__", "__sub__", "__truediv__", "__trunc__", "as_integer_ratio", "fromhex", "is_integer"};
        String[] arr$ = num_methods_num;
        for (int i$ = 0; i$ < 40; ++i$) {
            String m = arr$[i$];
            bnt.update(m, Builtins.numUrl(), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        bnt.update("__getnewargs__", Builtins.numUrl(), (NType)this.newFunc(this.newTuple(this.BaseNum)), NBinding.Kind.METHOD);
        bnt.update("hex", Builtins.numUrl(), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        bnt.update("conjugate", Builtins.numUrl(), (NType)this.newFunc(this.BaseComplex), NBinding.Kind.METHOD);
        Scope bct = this.BaseComplex.getTable();
        String[] complex_methods = new String[]{"__abs__", "__add__", "__div__", "__divmod__", "__float__", "__floordiv__", "__format__", "__getformat__", "__int__", "__long__", "__mod__", "__mul__", "__neg__", "__new__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__sub__", "__truediv__", "conjugate"};
        String[] arr$2 = complex_methods;
        for (int i$ = 0; i$ < 28; ++i$) {
            String c = arr$2[i$];
            bct.update(c, Builtins.numUrl(), (NType)this.newFunc(this.BaseComplex), NBinding.Kind.METHOD);
        }
        String[] complex_methods_num = new String[]{"__eq__", "__ge__", "__gt__", "__le__", "__lt__", "__ne__", "__nonzero__", "__coerce__"};
        String[] arr$3 = complex_methods_num;
        for (int i$ = 0; i$ < 8; ++i$) {
            String cn = arr$3[i$];
            bct.update(cn, Builtins.numUrl(), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        bct.update("__getnewargs__", Builtins.numUrl(), (NType)this.newFunc(this.newTuple(this.BaseComplex)), NBinding.Kind.METHOD);
        bct.update("imag", Builtins.numUrl(), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        bct.update("real", Builtins.numUrl(), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
    }

    private void buildStrType() {
        this.BaseStr.getTable().update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        this.BaseStr.getTable().update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        this.BaseStr.getTable().update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        String[] str_methods_str = new String[]{"capitalize", "center", "decode", "encode", "expandtabs", "format", "index", "join", "ljust", "lower", "lstrip", "partition", "replace", "rfind", "rindex", "rjust", "rpartition", "rsplit", "rstrip", "strip", "swapcase", "title", "translate", "upper", "zfill"};
        String[] arr$ = str_methods_str;
        for (int i$ = 0; i$ < 25; ++i$) {
            String m = arr$[i$];
            this.BaseStr.getTable().update(m, Builtins.newLibUrl("stdtypes.html#str." + m), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
        String[] str_methods_num = new String[]{"count", "isalnum", "isalpha", "isdigit", "islower", "isspace", "istitle", "isupper", "find", "startswith", "endswith"};
        String[] arr$2 = str_methods_num;
        for (int i$ = 0; i$ < 11; ++i$) {
            String m = arr$2[i$];
            this.BaseStr.getTable().update(m, Builtins.newLibUrl("stdtypes.html#str." + m), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        String[] str_methods_list = new String[]{"split", "splitlines"};
        String[] arr$3 = str_methods_list;
        for (int i$ = 0; i$ < 2; ++i$) {
            String m = arr$3[i$];
            this.BaseStr.getTable().update(m, Builtins.newLibUrl("stdtypes.html#str." + m), (NType)this.newFunc(this.newList(this.BaseStr)), NBinding.Kind.METHOD);
        }
        this.BaseStr.getTable().update("partition", Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.newTuple(this.BaseStr)), NBinding.Kind.METHOD);
    }

    private void buildModuleType() {
        String[] attrs = new String[]{"__doc__", "__file__", "__name__", "__package__"};
        String[] arr$ = attrs;
        for (int i$ = 0; i$ < 4; ++i$) {
            String m = arr$[i$];
            this.BaseModule.getTable().update(m, Builtins.newTutUrl("modules.html"), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        this.BaseModule.getTable().update("__dict__", Builtins.newLibUrl("stdtypes", "modules"), (NType)this.newDict(this.BaseStr, this.unknown()), NBinding.Kind.ATTRIBUTE);
    }

    private void buildDictType() {
        String url = "datastructures.html#dictionaries";
        Scope bt = this.BaseDict.getTable();
        bt.update("__getitem__", Builtins.newTutUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        bt.update("__iter__", Builtins.newTutUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        bt.update("get", Builtins.newTutUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        bt.update("items", Builtins.newTutUrl(url), (NType)this.newFunc(this.newList(this.newTuple(this.unknown(), this.unknown()))), NBinding.Kind.METHOD);
        bt.update("keys", Builtins.newTutUrl(url), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        bt.update("values", Builtins.newTutUrl(url), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        String[] dict_method_unknown = new String[]{"clear", "copy", "fromkeys", "get", "iteritems", "iterkeys", "itervalues", "pop", "popitem", "setdefault", "update"};
        String[] arr$ = dict_method_unknown;
        for (int i$ = 0; i$ < 11; ++i$) {
            String m = arr$[i$];
            bt.update(m, Builtins.newTutUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        String[] dict_method_num = new String[]{"has_key"};
        String[] arr$2 = dict_method_num;
        for (int i$ = 0; i$ <= 0; ++i$) {
            String m = arr$2[0];
            bt.update(m, Builtins.newTutUrl(url), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
    }

    private void buildFileType() {
        String url = "stdtypes.html#bltin-file-objects";
        Scope table = this.BaseFile.getTable();
        String[] methods_unknown = new String[]{"__enter__", "__exit__", "__iter__", "flush", "readinto", "truncate"};
        String[] arr$ = methods_unknown;
        for (int i$ = 0; i$ < 6; ++i$) {
            String m = arr$[i$];
            table.update(m, Builtins.newLibUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        String[] methods_str = new String[]{"next", "read", "readline"};
        String[] arr$2 = methods_str;
        for (int i$ = 0; i$ < 3; ++i$) {
            String m = arr$2[i$];
            table.update(m, Builtins.newLibUrl(url), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
        String[] num = new String[]{"fileno", "isatty", "tell"};
        String[] arr$3 = num;
        for (int i$ = 0; i$ < 3; ++i$) {
            String m = arr$3[i$];
            table.update(m, Builtins.newLibUrl(url), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        String[] methods_none = new String[]{"close", "seek", "write", "writelines"};
        String[] arr$4 = methods_none;
        for (int i$ = 0; i$ < 4; ++i$) {
            String m = arr$4[i$];
            table.update(m, Builtins.newLibUrl(url), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        table.update("readlines", Builtins.newLibUrl(url), (NType)this.newFunc(this.newList(this.BaseStr)), NBinding.Kind.METHOD);
        table.update("xreadlines", Builtins.newLibUrl(url), (NType)this.newFunc(this.BaseFile), NBinding.Kind.METHOD);
        table.update("closed", Builtins.newLibUrl(url), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        table.update("encoding", Builtins.newLibUrl(url), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        table.update("errors", Builtins.newLibUrl(url), (NType)this.unknown(), NBinding.Kind.ATTRIBUTE);
        table.update("mode", Builtins.newLibUrl(url), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        table.update("name", Builtins.newLibUrl(url), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        table.update("softspace", Builtins.newLibUrl(url), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        table.update("newlines", Builtins.newLibUrl(url), (NType)this.newUnion(this.BaseStr, this.newTuple(this.BaseStr)), NBinding.Kind.ATTRIBUTE);
    }

    private NBinding synthetic(Scope table, String n, NUrl url, NType type, NBinding.Kind k) {
        NBinding b = table.update(n, url, type, k);
        b.markSynthetic();
        return b;
    }

    private void buildFunctionType() {
        Scope t = this.BaseFunction.getTable();
        String[] stringArray = new String[]{"func_doc", "__doc__", "func_name", "__name__", "__module__"};
        String[] arr$ = stringArray;
        int len$ = stringArray.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s = arr$[i$];
            t.update(s, new NUrl(DATAMODEL_URL), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        NBinding b = this.synthetic(t, "func_closure", new NUrl(DATAMODEL_URL), this.newTuple(new NType[0]), NBinding.Kind.ATTRIBUTE);
        b.markReadOnly();
        this.synthetic(t, "func_code", new NUrl(DATAMODEL_URL), this.unknown(), NBinding.Kind.ATTRIBUTE);
        this.synthetic(t, "func_defaults", new NUrl(DATAMODEL_URL), this.newTuple(new NType[0]), NBinding.Kind.ATTRIBUTE);
        this.synthetic(t, "func_globals", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, new NUnknownType()), NBinding.Kind.ATTRIBUTE);
        this.synthetic(t, "func_dict", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, new NUnknownType()), NBinding.Kind.ATTRIBUTE);
        stringArray = new String[]{"__func__", "im_func"};
        String[] arr$2 = stringArray;
        int len$2 = stringArray.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            String s = arr$2[i$];
            this.synthetic(t, s, new NUrl(DATAMODEL_URL), new NFuncType(), NBinding.Kind.METHOD);
        }
    }

    private void buildClassType() {
        Scope t = this.BaseClass.getTable();
        String[] stringArray = new String[]{"__name__", "__doc__", "__module__"};
        String[] arr$ = stringArray;
        int len$ = stringArray.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s = arr$[i$];
            this.synthetic(t, s, new NUrl(DATAMODEL_URL), this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        this.synthetic(t, "__dict__", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, this.unknown()), NBinding.Kind.ATTRIBUTE);
    }

    class ZlibModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ZlibModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "zlib");
        }

        @Override
        public void initBindings() {
            NClassType Compress = this.this$0.newClass("Compress", this.table, this.this$0.Object, new NClassType[0]);
            for (String s : Builtins.list("compress", "flush")) {
                Compress.getTable().update(s, Builtins.newLibUrl("zlib"), (NType)this.this$0.BaseStr, NBinding.Kind.METHOD);
            }
            Compress.getTable().update("copy", Builtins.newLibUrl("zlib"), (NType)Compress, NBinding.Kind.METHOD);
            this.addClass("Compress", this.liburl(), Compress);
            NClassType Decompress = this.this$0.newClass("Decompress", this.table, this.this$0.Object, new NClassType[0]);
            for (String s : Builtins.list("unused_data", "unconsumed_tail")) {
                Decompress.getTable().update(s, Builtins.newLibUrl("zlib"), (NType)this.this$0.BaseStr, NBinding.Kind.ATTRIBUTE);
            }
            for (String s : Builtins.list("decompress", "flush")) {
                Decompress.getTable().update(s, Builtins.newLibUrl("zlib"), (NType)this.this$0.BaseStr, NBinding.Kind.METHOD);
            }
            Decompress.getTable().update("copy", Builtins.newLibUrl("zlib"), (NType)Decompress, NBinding.Kind.METHOD);
            this.addClass("Decompress", this.liburl(), Decompress);
            this.addFunction("adler32", this.liburl(), this.this$0.BaseNum);
            this.addFunction("compress", this.liburl(), this.this$0.BaseStr);
            this.addFunction("compressobj", this.liburl(), Compress);
            this.addFunction("crc32", this.liburl(), this.this$0.BaseNum);
            this.addFunction("decompress", this.liburl(), this.this$0.BaseStr);
            this.addFunction("decompressobj", this.liburl(), Decompress);
        }
    }

    class ZipimportModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ZipimportModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "zipimport");
        }

        @Override
        public void initBindings() {
            this.addClass("ZipImportError", this.liburl(), this.this$0.newException("ZipImportError", this.table));
            NClassType zipimporter2 = this.this$0.newClass("zipimporter", this.table, this.this$0.Object, new NClassType[0]);
            Scope t = zipimporter2.getTable();
            t.update("find_module", this.liburl(), (NType)zipimporter2, NBinding.Kind.METHOD);
            t.update("get_code", this.liburl(), (NType)this.this$0.unknown(), NBinding.Kind.METHOD);
            t.update("get_data", this.liburl(), (NType)this.this$0.unknown(), NBinding.Kind.METHOD);
            t.update("get_source", this.liburl(), (NType)this.this$0.BaseStr, NBinding.Kind.METHOD);
            t.update("is_package", this.liburl(), (NType)this.this$0.BaseNum, NBinding.Kind.METHOD);
            t.update("load_module", this.liburl(), (NType)this.this$0.newModule("<?>"), NBinding.Kind.METHOD);
            t.update("archive", this.liburl(), (NType)this.this$0.BaseStr, NBinding.Kind.ATTRIBUTE);
            t.update("prefix", this.liburl(), (NType)this.this$0.BaseStr, NBinding.Kind.ATTRIBUTE);
            this.addClass("zipimporter", this.liburl(), zipimporter2);
            this.addAttr("_zip_directory_cache", this.liburl(), this.this$0.newDict(this.this$0.BaseStr, this.this$0.unknown()));
        }
    }

    class UnicodedataModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public UnicodedataModule(Builtins builtins) {
            super(builtins, "unicodedata");
        }

        @Override
        public void initBindings() {
            this.addNumFuncs("decimal", "digit", "numeric", "combining", "east_asian_width", "mirrored");
            this.addStrFuncs("lookup", "name", "category", "bidirectional", "decomposition", "normalize");
            this.addNumAttrs("unidata_version");
            this.addUnknownAttrs("ucd_3_2_0");
        }
    }

    class TimeModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public TimeModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "time");
        }

        @Override
        public void initBindings() {
            NClassType struct_time = this.this$0.Time_struct_time = this.this$0.newClass("datetime", this.table, this.this$0.Object, new NClassType[0]);
            this.addAttr("struct_time", this.liburl(), struct_time);
            String[] struct_time_attrs = new String[]{"n_fields", "n_sequence_fields", "n_unnamed_fields", "tm_hour", "tm_isdst", "tm_mday", "tm_min", "tm_mon", "tm_wday", "tm_yday", "tm_year"};
            String[] arr$ = struct_time_attrs;
            for (int i$ = 0; i$ < 11; ++i$) {
                String s = arr$[i$];
                struct_time.getTable().update(s, this.liburl("struct_time"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addNumAttrs("accept2dyear", "altzone", "daylight", "timezone");
            this.addAttr("tzname", this.liburl(), this.this$0.newTuple(this.this$0.BaseStr, this.this$0.BaseStr));
            this.addNoneFuncs("sleep", "tzset");
            this.addNumFuncs("clock", "mktime", "time", "tzname");
            this.addStrFuncs("asctime", "ctime", "strftime");
            this.addFunctions_beCareful(struct_time, "gmtime", "localtime", "strptime");
        }
    }

    class ThreadModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ThreadModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "thread");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), this.this$0.newException("error", this.table));
            NClassType lock = this.this$0.newClass("lock", this.table, this.this$0.Object, new NClassType[0]);
            lock.getTable().update("acquire", this.liburl(), (NType)this.this$0.BaseNum, NBinding.Kind.METHOD);
            lock.getTable().update("locked", this.liburl(), (NType)this.this$0.BaseNum, NBinding.Kind.METHOD);
            lock.getTable().update("release", this.liburl(), (NType)this.this$0.None, NBinding.Kind.METHOD);
            this.addAttr("LockType", this.liburl(), this.this$0.Type);
            this.addNoneFuncs("interrupt_main", "exit", "exit_thread");
            this.addNumFuncs("start_new", "start_new_thread", "get_ident", "stack_size");
            this.addFunction("allocate", this.liburl(), lock);
            this.addFunction("allocate_lock", this.liburl(), lock);
            this.addAttr("_local", this.liburl(), this.this$0.Type);
        }
    }

    class TermiosModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public TermiosModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "termios");
        }

        @Override
        public void initBindings() {
            this.addFunction("tcgetattr", this.liburl(), this.this$0.newList());
            this.addUnknownFuncs("tcsetattr", "tcsendbreak", "tcdrain", "tcflush", "tcflow");
        }
    }

    class SyslogModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public SyslogModule(Builtins builtins) {
            super(builtins, "syslog");
        }

        @Override
        public void initBindings() {
            this.addNoneFuncs("syslog", "openlog", "closelog", "setlogmask");
            this.addNumAttrs("LOG_ALERT", "LOG_AUTH", "LOG_CONS", "LOG_CRIT", "LOG_CRON", "LOG_DAEMON", "LOG_DEBUG", "LOG_EMERG", "LOG_ERR", "LOG_INFO", "LOG_KERN", "LOG_LOCAL0", "LOG_LOCAL1", "LOG_LOCAL2", "LOG_LOCAL3", "LOG_LOCAL4", "LOG_LOCAL5", "LOG_LOCAL6", "LOG_LOCAL7", "LOG_LPR", "LOG_MAIL", "LOG_MASK", "LOG_NDELAY", "LOG_NEWS", "LOG_NOTICE", "LOG_NOWAIT", "LOG_PERROR", "LOG_PID", "LOG_SYSLOG", "LOG_UPTO", "LOG_USER", "LOG_UUCP", "LOG_WARNING");
        }
    }

    class SysModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public SysModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "sys");
        }

        @Override
        public void initBindings() {
            this.addUnknownFuncs("_clear_type_cache", "call_tracing", "callstats", "_current_frames", "_getframe", "displayhook", "dont_write_bytecode", "exitfunc", "exc_clear", "exc_info", "excepthook", "exit", "last_traceback", "last_type", "last_value", "modules", "path_hooks", "path_importer_cache", "getprofile", "gettrace", "setcheckinterval", "setprofile", "setrecursionlimit", "settrace");
            this.addAttr("exc_type", this.liburl(), this.this$0.None);
            this.addUnknownAttrs("__stderr__", "__stdin__", "__stdout__", "stderr", "stdin", "stdout", "version_info");
            this.addNumAttrs("api_version", "hexversion", "winver", "maxint", "maxsize", "maxunicode", "py3kwarning", "dllhandle");
            this.addStrAttrs("platform", "byteorder", "copyright", "prefix", "version", "exec_prefix", "executable");
            this.addNumFuncs("getrecursionlimit", "getwindowsversion", "getrefcount", "getsizeof", "getcheckinterval");
            this.addStrFuncs("getdefaultencoding", "getfilesystemencoding");
            for (String s : Builtins.list("argv", "builtin_module_names", "path", "meta_path", "subversion")) {
                this.addAttr(s, this.liburl(), this.this$0.newList(this.this$0.BaseStr));
            }
            for (String s : Builtins.list("flags", "warnoptions", "float_info")) {
                this.addAttr(s, this.liburl(), this.this$0.newDict(this.this$0.BaseStr, this.this$0.BaseNum));
            }
        }
    }

    class StructModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public StructModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "struct");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), this.this$0.newException("error", this.table));
            this.addStrFuncs("pack");
            this.addUnknownFuncs("pack_into");
            this.addNumFuncs("calcsize");
            this.addFunction("unpack", this.liburl(), this.this$0.newTuple(new NType[0]));
            this.addFunction("unpack_from", this.liburl(), this.this$0.newTuple(new NType[0]));
            this.this$0.BaseStruct = this.this$0.newClass("Struct", this.table, this.this$0.Object, new NClassType[0]);
            this.addClass("Struct", this.liburl("struct-objects"), this.this$0.BaseStruct);
            Scope t = this.this$0.BaseStruct.getTable();
            t.update("pack", this.liburl("struct-objects"), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            t.update("pack_into", this.liburl("struct-objects"), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            t.update("unpack", this.liburl("struct-objects"), (NType)this.this$0.newFunc(this.this$0.newTuple(new NType[0])), NBinding.Kind.METHOD);
            t.update("unpack_from", this.liburl("struct-objects"), (NType)this.this$0.newFunc(this.this$0.newTuple(new NType[0])), NBinding.Kind.METHOD);
            t.update("format", this.liburl("struct-objects"), (NType)this.this$0.BaseStr, NBinding.Kind.ATTRIBUTE);
            t.update("size", this.liburl("struct-objects"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
        }
    }

    class StropModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public StropModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "strop");
        }

        @Override
        public void initBindings() {
            this.table.merge(this.this$0.BaseStr.getTable());
        }
    }

    class SpwdModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public SpwdModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "spwd");
        }

        @Override
        public void initBindings() {
            NClassType struct_spwd = this.this$0.newClass("struct_spwd", this.table, this.this$0.Object, new NClassType[0]);
            for (String s : Builtins.list("sp_nam", "sp_pwd", "sp_lstchg", "sp_min", "sp_max", "sp_warn", "sp_inact", "sp_expire", "sp_flag")) {
                struct_spwd.getTable().update(s, this.liburl(), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addAttr("struct_spwd", this.liburl(), struct_spwd);
            this.addFunction("getspnam", this.liburl(), struct_spwd);
            this.addFunction("getspall", this.liburl(), this.this$0.newList(struct_spwd));
        }
    }

    class ShaModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ShaModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "sha");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("blocksize", "digest_size");
            NClassType sha = this.this$0.newClass("sha", this.table, this.this$0.Object, new NClassType[0]);
            sha.getTable().update("update", this.liburl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            sha.getTable().update("digest", this.liburl(), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            sha.getTable().update("hexdigest", this.liburl(), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            sha.getTable().update("copy", this.liburl(), (NType)this.this$0.newFunc(sha), NBinding.Kind.METHOD);
            this.addClass("sha", this.liburl(), sha);
            this.update("new", this.liburl(), this.this$0.newFunc(sha), NBinding.Kind.CONSTRUCTOR);
        }
    }

    class SignalModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public SignalModule(Builtins builtins) {
            super(builtins, "signal");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("NSIG", "SIGABRT", "SIGALRM", "SIGBUS", "SIGCHLD", "SIGCLD", "SIGCONT", "SIGFPE", "SIGHUP", "SIGILL", "SIGINT", "SIGIO", "SIGIOT", "SIGKILL", "SIGPIPE", "SIGPOLL", "SIGPROF", "SIGPWR", "SIGQUIT", "SIGRTMAX", "SIGRTMIN", "SIGSEGV", "SIGSTOP", "SIGSYS", "SIGTERM", "SIGTRAP", "SIGTSTP", "SIGTTIN", "SIGTTOU", "SIGURG", "SIGUSR1", "SIGUSR2", "SIGVTALRM", "SIGWINCH", "SIGXCPU", "SIGXFSZ", "SIG_DFL", "SIG_IGN");
            this.addUnknownFuncs("default_int_handler", "getsignal", "set_wakeup_fd", "signal");
        }
    }

    class SelectModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public SelectModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "select");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), this.this$0.newException("error", this.table));
            this.addFunction("select", this.liburl(), this.this$0.newTuple(this.this$0.newList(), this.this$0.newList(), this.this$0.newList()));
            String a = "edge-and-level-trigger-polling-epoll-objects";
            NClassType epoll = this.this$0.newClass("epoll", this.table, this.this$0.Object, new NClassType[0]);
            epoll.getTable().update("close", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.METHOD);
            epoll.getTable().update("fileno", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            epoll.getTable().update("fromfd", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(epoll), NBinding.Kind.METHOD);
            for (String s : Builtins.list("register", "modify", "unregister", "poll")) {
                epoll.getTable().update(s, Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            }
            this.addClass("epoll", this.liburl(a), epoll);
            for (String s : Builtins.list("EPOLLERR", "EPOLLET", "EPOLLHUP", "EPOLLIN", "EPOLLMSG", "EPOLLONESHOT", "EPOLLOUT", "EPOLLPRI", "EPOLLRDBAND", "EPOLLRDNORM", "EPOLLWRBAND", "EPOLLWRNORM")) {
                this.addAttr(s, this.liburl(a), this.this$0.BaseNum);
            }
            a = "polling-objects";
            NClassType poll = this.this$0.newClass("poll", this.table, this.this$0.Object, new NClassType[0]);
            poll.getTable().update("register", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            poll.getTable().update("modify", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            poll.getTable().update("unregister", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            poll.getTable().update("poll", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(this.this$0.newList(this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum))), NBinding.Kind.METHOD);
            this.addClass("poll", this.liburl(a), poll);
            for (String s : Builtins.list("POLLERR", "POLLHUP", "POLLIN", "POLLMSG", "POLLNVAL", "POLLOUT", "POLLPRI", "POLLRDBAND", "POLLRDNORM", "POLLWRBAND", "POLLWRNORM")) {
                this.addAttr(s, this.liburl(a), this.this$0.BaseNum);
            }
            a = "kqueue-objects";
            NClassType kqueue = this.this$0.newClass("kqueue", this.table, this.this$0.Object, new NClassType[0]);
            kqueue.getTable().update("close", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.METHOD);
            kqueue.getTable().update("fileno", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            kqueue.getTable().update("fromfd", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(kqueue), NBinding.Kind.METHOD);
            kqueue.getTable().update("control", Builtins.newLibUrl("select", a), (NType)this.this$0.newFunc(this.this$0.newList(this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum))), NBinding.Kind.METHOD);
            this.addClass("kqueue", this.liburl(a), kqueue);
            a = "kevent-objects";
            NClassType kevent = this.this$0.newClass("kevent", this.table, this.this$0.Object, new NClassType[0]);
            for (String s : Builtins.list("ident", "filter", "flags", "fflags", "data", "udata")) {
                kevent.getTable().update(s, Builtins.newLibUrl("select", a), (NType)this.this$0.unknown(), NBinding.Kind.ATTRIBUTE);
            }
            this.addClass("kevent", this.liburl(a), kevent);
        }
    }

    class ResourceModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ResourceModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "resource");
        }

        @Override
        public void initBindings() {
            this.addFunction("getrlimit", this.liburl(), this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum));
            this.addFunction("getrlimit", this.liburl(), this.this$0.unknown());
            String[] constants = new String[]{"RLIMIT_CORE", "RLIMIT_CPU", "RLIMIT_FSIZE", "RLIMIT_DATA", "RLIMIT_STACK", "RLIMIT_RSS", "RLIMIT_NPROC", "RLIMIT_NOFILE", "RLIMIT_OFILE", "RLIMIT_MEMLOCK", "RLIMIT_VMEM", "RLIMIT_AS"};
            String[] arr$ = constants;
            for (int i$ = 0; i$ < 12; ++i$) {
                String c = arr$[i$];
                this.addAttr(c, this.liburl("resource-limits"), this.this$0.BaseNum);
            }
            NClassType ru = this.this$0.newClass("struct_rusage", this.table, this.this$0.Object, new NClassType[0]);
            String[] ru_fields = new String[]{"ru_utime", "ru_stime", "ru_maxrss", "ru_ixrss", "ru_idrss", "ru_isrss", "ru_minflt", "ru_majflt", "ru_nswap", "ru_inblock", "ru_oublock", "ru_msgsnd", "ru_msgrcv", "ru_nsignals", "ru_nvcsw", "ru_nivcsw"};
            String[] arr$2 = ru_fields;
            for (int i$ = 0; i$ < 16; ++i$) {
                String ruf = arr$2[i$];
                ru.getTable().update(ruf, this.liburl("resource-usage"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addFunction("getrusage", this.liburl("resource-usage"), ru);
            this.addFunction("getpagesize", this.liburl("resource-usage"), this.this$0.BaseNum);
            for (String s : Builtins.list("RUSAGE_SELF", "RUSAGE_CHILDREN", "RUSAGE_BOTH")) {
                this.addAttr(s, this.liburl("resource-usage"), this.this$0.BaseNum);
            }
        }
    }

    class ReadlineModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ReadlineModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "readline");
        }

        @Override
        public void initBindings() {
            this.addNoneFuncs("parse_and_bind", "insert_text", "read_init_file", "read_history_file", "write_history_file", "clear_history", "set_history_length", "remove_history_item", "replace_history_item", "redisplay", "set_startup_hook", "set_pre_input_hook", "set_completer", "set_completer_delims", "set_completion_display_matches_hook", "add_history");
            this.addNumFuncs("get_history_length", "get_current_history_length", "get_begidx", "get_endidx");
            this.addStrFuncs("get_line_buffer", "get_history_item");
            this.addUnknownFuncs("get_completion_type");
            this.addFunction("get_completer", this.liburl(), this.this$0.newFunc());
            this.addFunction("get_completer_delims", this.liburl(), this.this$0.newList(this.this$0.BaseStr));
        }
    }

    class PyexpatModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public PyexpatModule(Builtins builtins) {
            super(builtins, "pyexpat");
        }

        @Override
        public void initBindings() {
        }
    }

    class PwdModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public PwdModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "pwd");
        }

        @Override
        public void initBindings() {
            NClassType struct_pwd = this.this$0.newClass("struct_pwd", this.table, this.this$0.Object, new NClassType[0]);
            for (String s : Builtins.list("pw_nam", "pw_passwd", "pw_uid", "pw_gid", "pw_gecos", "pw_dir", "pw_shell")) {
                struct_pwd.getTable().update(s, this.liburl(), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addAttr("struct_pwd", this.liburl(), struct_pwd);
            this.addFunction("getpwuid", this.liburl(), struct_pwd);
            this.addFunction("getpwnam", this.liburl(), struct_pwd);
            this.addFunction("getpwall", this.liburl(), this.this$0.newList(struct_pwd));
        }
    }

    class PosixModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public PosixModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "posix");
        }

        @Override
        public void initBindings() {
            this.addAttr("environ", this.liburl(), this.this$0.newDict(this.this$0.BaseStr, this.this$0.BaseStr));
        }
    }

    class ParserModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ParserModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "parser");
        }

        @Override
        public void initBindings() {
            NClassType st = this.this$0.newClass("st", this.table, this.this$0.Object, new NClassType[0]);
            st.getTable().update("compile", Builtins.newLibUrl("parser", "st-objects"), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            st.getTable().update("isexpr", Builtins.newLibUrl("parser", "st-objects"), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            st.getTable().update("issuite", Builtins.newLibUrl("parser", "st-objects"), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            st.getTable().update("tolist", Builtins.newLibUrl("parser", "st-objects"), (NType)this.this$0.newFunc(this.this$0.newList()), NBinding.Kind.METHOD);
            st.getTable().update("totuple", Builtins.newLibUrl("parser", "st-objects"), (NType)this.this$0.newFunc(this.this$0.newTuple(new NType[0])), NBinding.Kind.METHOD);
            this.addAttr("STType", this.liburl("st-objects"), this.this$0.Type);
            for (String s : Builtins.list("expr", "suite", "sequence2st", "tuple2st")) {
                this.addFunction(s, this.liburl("creating-st-objects"), st);
            }
            this.addFunction("st2list", this.liburl("converting-st-objects"), this.this$0.newList());
            this.addFunction("st2tuple", this.liburl("converting-st-objects"), this.this$0.newTuple(new NType[0]));
            this.addFunction("compilest", this.liburl("converting-st-objects"), this.this$0.unknown());
            this.addFunction("isexpr", this.liburl("queries-on-st-objects"), this.this$0.BaseBool);
            this.addFunction("issuite", this.liburl("queries-on-st-objects"), this.this$0.BaseBool);
            this.addClass("ParserError", this.liburl("exceptions-and-error-handling"), this.this$0.newException("ParserError", this.table));
        }
    }

    class OperatorModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public OperatorModule(Builtins builtins) {
            super(builtins, "operator");
        }

        @Override
        public void initBindings() {
            this.addNumFuncs("__abs__", "__add__", "__and__", "__concat__", "__contains__", "__div__", "__doc__", "__eq__", "__floordiv__", "__ge__", "__getitem__", "__getslice__", "__gt__", "__iadd__", "__iand__", "__iconcat__", "__idiv__", "__ifloordiv__", "__ilshift__", "__imod__", "__imul__", "__index__", "__inv__", "__invert__", "__ior__", "__ipow__", "__irepeat__", "__irshift__", "__isub__", "__itruediv__", "__ixor__", "__le__", "__lshift__", "__lt__", "__mod__", "__mul__", "__name__", "__ne__", "__neg__", "__not__", "__or__", "__package__", "__pos__", "__pow__", "__repeat__", "__rshift__", "__setitem__", "__setslice__", "__sub__", "__truediv__", "__xor__", "abs", "add", "and_", "concat", "contains", "countOf", "div", "eq", "floordiv", "ge", "getitem", "getslice", "gt", "iadd", "iand", "iconcat", "idiv", "ifloordiv", "ilshift", "imod", "imul", "index", "indexOf", "inv", "invert", "ior", "ipow", "irepeat", "irshift", "isCallable", "isMappingType", "isNumberType", "isSequenceType", "is_", "is_not", "isub", "itruediv", "ixor", "le", "lshift", "lt", "mod", "mul", "ne", "neg", "not_", "or_", "pos", "pow", "repeat", "rshift", "sequenceIncludes", "setitem", "setslice", "sub", "truediv", "truth", "xor");
            this.addUnknownFuncs("attrgetter", "itemgetter", "methodcaller");
            this.addNoneFuncs("__delitem__", "__delslice__", "delitem", "delclice");
        }
    }

    class OsModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public OsModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "os");
        }

        @Override
        public void initBindings() {
            this.addAttr("name", this.liburl(), this.this$0.BaseStr);
            this.addClass("error", this.liburl(), this.this$0.newException("error", this.table));
            this.initProcBindings();
            this.initProcMgmtBindings();
            this.initFileBindings();
            this.initFileAndDirBindings();
            this.initMiscSystemInfo();
            this.initOsPathModule();
            this.addAttr("errno", this.liburl(), this.this$0.newModule("errno"));
            this.addFunction("urandom", this.liburl("miscellaneous-functions"), this.this$0.BaseStr);
            this.addAttr("NGROUPS_MAX", this.liburl(), this.this$0.BaseNum);
            for (String s : Builtins.list("_Environ", "_copy_reg", "_execvpe", "_exists", "_get_exports_list", "_make_stat_result", "_make_statvfs_result", "_pickle_stat_result", "_pickle_statvfs_result", "_spawnvef")) {
                this.addFunction(s, this.liburl(), this.this$0.unknown());
            }
        }

        private void initProcBindings() {
            String a = "process-parameters";
            this.addAttr("environ", this.liburl(a), this.this$0.newDict(this.this$0.BaseStr, this.this$0.BaseStr));
            for (String s : Builtins.list("chdir", "fchdir", "putenv", "setegid", "seteuid", "setgid", "setgroups", "setpgrp", "setpgid", "setreuid", "setregid", "setuid", "unsetenv")) {
                this.addFunction(s, this.liburl(a), this.this$0.None);
            }
            for (String s : Builtins.list("getegid", "getgid", "getpgid", "getpgrp", "getppid", "getuid", "getsid", "umask")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseNum);
            }
            for (String s : Builtins.list("getcwd", "ctermid", "getlogin", "getenv", "strerror")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseStr);
            }
            this.addFunction("getgroups", this.liburl(a), this.this$0.newList(this.this$0.BaseStr));
            this.addFunction("uname", this.liburl(a), this.this$0.newTuple(this.this$0.BaseStr, this.this$0.BaseStr, this.this$0.BaseStr, this.this$0.BaseStr, this.this$0.BaseStr));
        }

        private void initProcMgmtBindings() {
            String a = "process-management";
            for (String s : Builtins.list("EX_CANTCREAT", "EX_CONFIG", "EX_DATAERR", "EX_IOERR", "EX_NOHOST", "EX_NOINPUT", "EX_NOPERM", "EX_NOUSER", "EX_OK", "EX_OSERR", "EX_OSFILE", "EX_PROTOCOL", "EX_SOFTWARE", "EX_TEMPFAIL", "EX_UNAVAILABLE", "EX_USAGE", "P_NOWAIT", "P_NOWAITO", "P_WAIT", "P_DETACH", "P_OVERLAY", "WCONTINUED", "WCOREDUMP", "WEXITSTATUS", "WIFCONTINUED", "WIFEXITED", "WIFSIGNALED", "WIFSTOPPED", "WNOHANG", "WSTOPSIG", "WTERMSIG", "WUNTRACED")) {
                this.addAttr(s, this.liburl(a), this.this$0.BaseNum);
            }
            for (String s : Builtins.list("abort", "execl", "execle", "execlp", "execlpe", "execv", "execve", "execvp", "execvpe", "_exit", "kill", "killpg", "plock", "startfile")) {
                this.addFunction(s, this.liburl(a), this.this$0.None);
            }
            for (String s : Builtins.list("nice", "spawnl", "spawnle", "spawnlp", "spawnlpe", "spawnv", "spawnve", "spawnvp", "spawnvpe", "system")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseNum);
            }
            this.addFunction("fork", this.liburl(a), this.this$0.newUnion(this.this$0.BaseFile, this.this$0.BaseNum));
            this.addFunction("times", this.liburl(a), this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum, this.this$0.BaseNum, this.this$0.BaseNum, this.this$0.BaseNum));
            for (String s : Builtins.list("forkpty", "wait", "waitpid")) {
                this.addFunction(s, this.liburl(a), this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum));
            }
            for (String s : Builtins.list("wait3", "wait4")) {
                this.addFunction(s, this.liburl(a), this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum, this.this$0.BaseNum));
            }
        }

        private void initFileBindings() {
            String a = "file-object-creation";
            for (String s : Builtins.list("fdopen", "popen", "tmpfile")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseFile);
            }
            this.addFunction("popen2", this.liburl(a), this.this$0.newTuple(this.this$0.BaseFile, this.this$0.BaseFile));
            this.addFunction("popen3", this.liburl(a), this.this$0.newTuple(this.this$0.BaseFile, this.this$0.BaseFile, this.this$0.BaseFile));
            this.addFunction("popen4", this.liburl(a), this.this$0.newTuple(this.this$0.BaseFile, this.this$0.BaseFile));
            a = "file-descriptor-operations";
            this.addFunction("open", this.liburl(a), this.this$0.BaseFile);
            for (String s : Builtins.list("close", "closerange", "dup2", "fchmod", "fchown", "fdatasync", "fsync", "ftruncate", "lseek", "tcsetpgrp", "write")) {
                this.addFunction(s, this.liburl(a), this.this$0.None);
            }
            for (String s : Builtins.list("dup2", "fpathconf", "fstat", "fstatvfs", "isatty", "tcgetpgrp")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseNum);
            }
            for (String s : Builtins.list("read", "ttyname")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseStr);
            }
            for (String s : Builtins.list("openpty", "pipe", "fstat", "fstatvfs", "isatty")) {
                this.addFunction(s, this.liburl(a), this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum));
            }
            for (String s : Builtins.list("O_APPEND", "O_CREAT", "O_DIRECT", "O_DIRECTORY", "O_DSYNC", "O_EXCL", "O_LARGEFILE", "O_NDELAY", "O_NOCTTY", "O_NOFOLLOW", "O_NONBLOCK", "O_RDONLY", "O_RDWR", "O_RSYNC", "O_SYNC", "O_TRUNC", "O_WRONLY", "SEEK_CUR", "SEEK_END", "SEEK_SET")) {
                this.addAttr(s, this.liburl(a), this.this$0.BaseNum);
            }
        }

        private void initFileAndDirBindings() {
            String a = "files-and-directories";
            for (String s : Builtins.list("F_OK", "R_OK", "W_OK", "X_OK")) {
                this.addAttr(s, this.liburl(a), this.this$0.BaseNum);
            }
            for (String s : Builtins.list("chflags", "chroot", "chmod", "chown", "lchflags", "lchmod", "lchown", "link", "mknod", "mkdir", "mkdirs", "remove", "removedirs", "rename", "renames", "rmdir", "symlink", "unlink", "utime")) {
                this.addAttr(s, this.liburl(a), this.this$0.None);
            }
            for (String s : Builtins.list("access", "lstat", "major", "minor", "makedev", "pathconf", "stat_float_times")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseNum);
            }
            for (String s : Builtins.list("getcwdu", "readlink", "tempnam", "tmpnam")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseStr);
            }
            for (String s : Builtins.list("listdir")) {
                this.addFunction(s, this.liburl(a), this.this$0.newList(this.this$0.BaseStr));
            }
            this.addFunction("mkfifo", this.liburl(a), this.this$0.BaseFile);
            this.addFunction("stat", this.liburl(a), this.this$0.newList(this.this$0.BaseNum));
            this.addFunction("statvfs", this.liburl(a), this.this$0.newList(this.this$0.BaseNum));
            this.addAttr("pathconf_names", this.liburl(a), this.this$0.newDict(this.this$0.BaseStr, this.this$0.BaseNum));
            this.addAttr("TMP_MAX", this.liburl(a), this.this$0.BaseNum);
            this.addFunction("walk", this.liburl(a), this.this$0.newList(this.this$0.newTuple(this.this$0.BaseStr, this.this$0.BaseStr, this.this$0.BaseStr)));
        }

        private void initMiscSystemInfo() {
            String a = "miscellaneous-system-information";
            this.addAttr("confstr_names", this.liburl(a), this.this$0.newDict(this.this$0.BaseStr, this.this$0.BaseNum));
            this.addAttr("sysconf_names", this.liburl(a), this.this$0.newDict(this.this$0.BaseStr, this.this$0.BaseNum));
            for (String s : Builtins.list("curdir", "pardir", "sep", "altsep", "extsep", "pathsep", "defpath", "linesep", "devnull")) {
                this.addAttr(s, this.liburl(a), this.this$0.BaseStr);
            }
            for (String s : Builtins.list("getloadavg", "sysconf")) {
                this.addFunction(s, this.liburl(a), this.this$0.BaseNum);
            }
            this.addFunction("confstr", this.liburl(a), this.this$0.BaseStr);
        }

        private void initOsPathModule() {
            NModuleType m = this.this$0.newModule("path");
            Scope ospath = m.getTable();
            ospath.setPath("os.path");
            this.update("path", Builtins.newLibUrl("os.path.html#module-os.path"), m, NBinding.Kind.MODULE);
            String[] str_funcs = new String[]{"_resolve_link", "abspath", "basename", "commonprefix", "dirname", "expanduser", "expandvars", "join", "normcase", "normpath", "realpath", "relpath"};
            String[] arr$ = str_funcs;
            for (int i$ = 0; i$ < 12; ++i$) {
                String s = arr$[i$];
                ospath.update(s, Builtins.newLibUrl("os.path", s), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.FUNCTION);
            }
            String[] num_funcs = new String[]{"exists", "lexists", "getatime", "getctime", "getmtime", "getsize", "isabs", "isdir", "isfile", "islink", "ismount", "samefile", "sameopenfile", "samestat", "supports_unicode_filenames"};
            String[] arr$2 = num_funcs;
            for (int i$ = 0; i$ < 15; ++i$) {
                String s = arr$2[i$];
                ospath.update(s, Builtins.newLibUrl("os.path", s), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.FUNCTION);
            }
            for (String s : Builtins.list("split", "splitdrive", "splitext", "splitunc")) {
                ospath.update(s, Builtins.newLibUrl("os.path", s), (NType)this.this$0.newFunc(this.this$0.newTuple(this.this$0.BaseStr, this.this$0.BaseStr)), NBinding.Kind.FUNCTION);
            }
            NBinding b = ospath.update("walk", Builtins.newLibUrl("os.path"), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.FUNCTION);
            b.markDeprecated();
            String[] str_attrs = new String[]{"altsep", "curdir", "devnull", "defpath", "pardir", "pathsep", "sep"};
            String[] arr$3 = str_attrs;
            for (int i$ = 0; i$ < 7; ++i$) {
                String s = arr$3[i$];
                ospath.update(s, Builtins.newLibUrl("os.path", s), (NType)this.this$0.BaseStr, NBinding.Kind.ATTRIBUTE);
            }
            ospath.update("os", this.liburl(), (NType)this.module, NBinding.Kind.ATTRIBUTE);
            ospath.update("stat", Builtins.newLibUrl("stat"), (NType)this.this$0.newModule("<stat-fixme>"), NBinding.Kind.ATTRIBUTE);
            ospath.update("_varprog", Builtins.newLibUrl("os.path"), (NType)this.this$0.unknown(), NBinding.Kind.ATTRIBUTE);
        }
    }

    class NisModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public NisModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "nis");
        }

        @Override
        public void initBindings() {
            this.addStrFuncs("match", "cat", "get_default_domain");
            this.addFunction("maps", this.liburl(), this.this$0.newList(this.this$0.BaseStr));
            this.addClass("error", this.liburl(), this.this$0.newException("error", this.table));
        }
    }

    class MmapModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public MmapModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "mmap");
        }

        @Override
        public void initBindings() {
            NClassType mmap = this.this$0.newClass("mmap", this.table, this.this$0.Object, new NClassType[0]);
            for (String s : Builtins.list("ACCESS_COPY", "ACCESS_READ", "ACCESS_WRITE", "ALLOCATIONGRANULARITY", "MAP_ANON", "MAP_ANONYMOUS", "MAP_DENYWRITE", "MAP_EXECUTABLE", "MAP_PRIVATE", "MAP_SHARED", "PAGESIZE", "PROT_EXEC", "PROT_READ", "PROT_WRITE")) {
                mmap.getTable().update(s, this.liburl(), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            for (String fstr : Builtins.list("read", "read_byte", "readline")) {
                mmap.getTable().update(fstr, this.liburl(), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            }
            for (String fnum : Builtins.list("find", "rfind", "tell")) {
                mmap.getTable().update(fnum, this.liburl(), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            }
            for (String fnone : Builtins.list("close", "flush", "move", "resize", "seek", "write", "write_byte")) {
                mmap.getTable().update(fnone, this.liburl(), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.METHOD);
            }
            this.addClass("mmap", this.liburl(), mmap);
        }
    }

    class Md5Module
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public Md5Module(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "md5");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("blocksize", "digest_size");
            NClassType md5 = this.this$0.newClass("md5", this.table, this.this$0.Object, new NClassType[0]);
            md5.getTable().update("update", this.liburl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            md5.getTable().update("digest", this.liburl(), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            md5.getTable().update("hexdigest", this.liburl(), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            md5.getTable().update("copy", this.liburl(), (NType)this.this$0.newFunc(md5), NBinding.Kind.METHOD);
            this.update("new", this.liburl(), this.this$0.newFunc(md5), NBinding.Kind.CONSTRUCTOR);
            this.update("md5", this.liburl(), this.this$0.newFunc(md5), NBinding.Kind.CONSTRUCTOR);
        }
    }

    class MathModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public MathModule(Builtins builtins) {
            super(builtins, "math");
        }

        @Override
        public void initBindings() {
            this.addNumFuncs("acos", "acosh", "asin", "asinh", "atan", "atan2", "atanh", "ceil", "copysign", "cos", "cosh", "degrees", "exp", "fabs", "factorial", "floor", "fmod", "frexp", "fsum", "hypot", "isinf", "isnan", "ldexp", "log", "log10", "log1p", "modf", "pow", "radians", "sin", "sinh", "sqrt", "tan", "tanh", "trunc");
            this.addNumAttrs("pi", "e");
        }
    }

    class MarshalModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public MarshalModule(Builtins builtins) {
            super(builtins, "marshal");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("version");
            this.addStrFuncs("dumps");
            this.addUnknownFuncs("dump", "load", "loads");
        }
    }

    class ItertoolsModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ItertoolsModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "itertools");
        }

        @Override
        public void initBindings() {
            NClassType iterator = this.this$0.newClass("iterator", this.table, this.this$0.Object, new NClassType[0]);
            iterator.getTable().update("from_iterable", this.liburl("itertool-functions"), (NType)this.this$0.newFunc(iterator), NBinding.Kind.METHOD);
            iterator.getTable().update("next", this.liburl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            for (String s : Builtins.list("chain", "combinations", "count", "cycle", "dropwhile", "groupby", "ifilter", "ifilterfalse", "imap", "islice", "izip", "izip_longest", "permutations", "product", "repeat", "starmap", "takewhile", "tee")) {
                this.addClass(s, this.liburl("itertool-functions"), iterator);
            }
        }
    }

    class ImpModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ImpModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "imp");
        }

        @Override
        public void initBindings() {
            this.addStrFuncs("get_magic");
            this.addFunction("get_suffixes", this.liburl(), this.this$0.newList(this.this$0.newTuple(this.this$0.BaseStr, this.this$0.BaseStr, this.this$0.BaseNum)));
            this.addFunction("find_module", this.liburl(), this.this$0.newTuple(this.this$0.BaseStr, this.this$0.BaseStr, this.this$0.BaseNum));
            String[] module_methods = new String[]{"load_module", "new_module", "init_builtin", "init_frozen", "load_compiled", "load_dynamic", "load_source"};
            String[] arr$ = module_methods;
            for (int i$ = 0; i$ < 7; ++i$) {
                String mm = arr$[i$];
                this.addFunction(mm, this.liburl(), this.this$0.newModule("<?>"));
            }
            this.addUnknownFuncs("acquire_lock", "release_lock");
            this.addNumAttrs("PY_SOURCE", "PY_COMPILED", "C_EXTENSION", "PKG_DIRECTORY", "C_BUILTIN", "PY_FROZEN", "SEARCH_ERROR");
            this.addNumFuncs("lock_held", "is_builtin", "is_frozen");
            NClassType impNullImporter = this.this$0.newClass("NullImporter", this.table, this.this$0.Object, new NClassType[0]);
            impNullImporter.getTable().update("find_module", this.liburl(), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.FUNCTION);
            this.addClass("NullImporter", this.liburl(), impNullImporter);
        }
    }

    class GrpModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public GrpModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "grp");
        }

        @Override
        public void initBindings() {
            this.this$0.get("struct");
            NClassType struct_group = this.this$0.newClass("struct_group", this.table, this.this$0.BaseStruct, new NClassType[0]);
            struct_group.getTable().update("gr_name", this.liburl(), (NType)this.this$0.BaseStr, NBinding.Kind.ATTRIBUTE);
            struct_group.getTable().update("gr_passwd", this.liburl(), (NType)this.this$0.BaseStr, NBinding.Kind.ATTRIBUTE);
            struct_group.getTable().update("gr_gid", this.liburl(), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            struct_group.getTable().update("gr_mem", this.liburl(), (NType)this.this$0.newList(this.this$0.BaseStr), NBinding.Kind.ATTRIBUTE);
            this.addClass("struct_group", this.liburl(), struct_group);
            for (String s : Builtins.list("getgrgid", "getgrnam")) {
                this.addFunction(s, this.liburl(), struct_group);
            }
            this.addFunction("getgrall", this.liburl(), new NListType(struct_group));
        }
    }

    class GdbmModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public GdbmModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "gdbm");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), this.this$0.newException("error", this.table));
            NClassType gdbm = new NClassType("gdbm", this.table, this.this$0.BaseDict);
            gdbm.getTable().update("firstkey", this.liburl(), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            gdbm.getTable().update("nextkey", this.liburl(), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            gdbm.getTable().update("reorganize", this.liburl(), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.METHOD);
            gdbm.getTable().update("sync", this.liburl(), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.METHOD);
            this.addFunction("open", this.liburl(), gdbm);
        }
    }

    class GcModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public GcModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "gc");
        }

        @Override
        public void initBindings() {
            this.addNoneFuncs("enable", "disable", "set_debug", "set_threshold");
            this.addNumFuncs("isenabled", "collect", "get_debug", "get_count", "get_threshold");
            for (String s : Builtins.list("get_objects", "get_referrers", "get_referents")) {
                this.addFunction(s, this.liburl(), this.this$0.newList());
            }
            this.addAttr("garbage", this.liburl(), this.this$0.newList());
            this.addNumAttrs("DEBUG_STATS", "DEBUG_COLLECTABLE", "DEBUG_UNCOLLECTABLE", "DEBUG_INSTANCES", "DEBUG_OBJECTS", "DEBUG_SAVEALL", "DEBUG_LEAK");
        }
    }

    class FpectlModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public FpectlModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "fpectl");
        }

        @Override
        public void initBindings() {
            this.addNoneFuncs("turnon_sigfpe", "turnoff_sigfpe");
            this.addClass("FloatingPointError", this.liburl(), this.this$0.newException("FloatingPointError", this.table));
        }
    }

    class FcntlModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public FcntlModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "fcntl");
        }

        @Override
        public void initBindings() {
            for (String s : Builtins.list("fcntl", "ioctl")) {
                this.addFunction(s, this.liburl(), this.this$0.newUnion(this.this$0.BaseNum, this.this$0.BaseStr));
            }
            this.addNumFuncs("flock");
            this.addUnknownFuncs("lockf");
            this.addNumAttrs("DN_ACCESS", "DN_ATTRIB", "DN_CREATE", "DN_DELETE", "DN_MODIFY", "DN_MULTISHOT", "DN_RENAME", "FASYNC", "FD_CLOEXEC", "F_DUPFD", "F_EXLCK", "F_GETFD", "F_GETFL", "F_GETLEASE", "F_GETLK", "F_GETLK64", "F_GETOWN", "F_GETSIG", "F_NOTIFY", "F_RDLCK", "F_SETFD", "F_SETFL", "F_SETLEASE", "F_SETLK", "F_SETLK64", "F_SETLKW", "F_SETLKW64", "F_SETOWN", "F_SETSIG", "F_SHLCK", "F_UNLCK", "F_WRLCK", "I_ATMARK", "I_CANPUT", "I_CKBAND", "I_FDINSERT", "I_FIND", "I_FLUSH", "I_FLUSHBAND", "I_GETBAND", "I_GETCLTIME", "I_GETSIG", "I_GRDOPT", "I_GWROPT", "I_LINK", "I_LIST", "I_LOOK", "I_NREAD", "I_PEEK", "I_PLINK", "I_POP", "I_PUNLINK", "I_PUSH", "I_RECVFD", "I_SENDFD", "I_SETCLTIME", "I_SETSIG", "I_SRDOPT", "I_STR", "I_SWROPT", "I_UNLINK", "LOCK_EX", "LOCK_MAND", "LOCK_NB", "LOCK_READ", "LOCK_RW", "LOCK_SH", "LOCK_UN", "LOCK_WRITE");
        }
    }

    class ExceptionsModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ExceptionsModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "exceptions");
        }

        @Override
        public void initBindings() {
            NModuleType builtins = this.this$0.get("__builtin__");
            String[] arr$ = this.this$0.builtin_exception_types;
            int len$ = this.this$0.builtin_exception_types.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String s = arr$[i$];
                NBinding b = builtins.getTable().lookup(s);
                this.table.update(b.getName(), b.getSignatureNode(), b.getType(), b.getKind());
            }
        }
    }

    class ErrnoModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ErrnoModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "errno");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("E2BIG", "EACCES", "EADDRINUSE", "EADDRNOTAVAIL", "EAFNOSUPPORT", "EAGAIN", "EALREADY", "EBADF", "EBUSY", "ECHILD", "ECONNABORTED", "ECONNREFUSED", "ECONNRESET", "EDEADLK", "EDEADLOCK", "EDESTADDRREQ", "EDOM", "EDQUOT", "EEXIST", "EFAULT", "EFBIG", "EHOSTDOWN", "EHOSTUNREACH", "EILSEQ", "EINPROGRESS", "EINTR", "EINVAL", "EIO", "EISCONN", "EISDIR", "ELOOP", "EMFILE", "EMLINK", "EMSGSIZE", "ENAMETOOLONG", "ENETDOWN", "ENETRESET", "ENETUNREACH", "ENFILE", "ENOBUFS", "ENODEV", "ENOENT", "ENOEXEC", "ENOLCK", "ENOMEM", "ENOPROTOOPT", "ENOSPC", "ENOSYS", "ENOTCONN", "ENOTDIR", "ENOTEMPTY", "ENOTSOCK", "ENOTTY", "ENXIO", "EOPNOTSUPP", "EPERM", "EPFNOSUPPORT", "EPIPE", "EPROTONOSUPPORT", "EPROTOTYPE", "ERANGE", "EREMOTE", "EROFS", "ESHUTDOWN", "ESOCKTNOSUPPORT", "ESPIPE", "ESRCH", "ESTALE", "ETIMEDOUT", "ETOOMANYREFS", "EUSERS", "EWOULDBLOCK", "EXDEV", "WSABASEERR", "WSAEACCES", "WSAEADDRINUSE", "WSAEADDRNOTAVAIL", "WSAEAFNOSUPPORT", "WSAEALREADY", "WSAEBADF", "WSAECONNABORTED", "WSAECONNREFUSED", "WSAECONNRESET", "WSAEDESTADDRREQ", "WSAEDISCON", "WSAEDQUOT", "WSAEFAULT", "WSAEHOSTDOWN", "WSAEHOSTUNREACH", "WSAEINPROGRESS", "WSAEINTR", "WSAEINVAL", "WSAEISCONN", "WSAELOOP", "WSAEMFILE", "WSAEMSGSIZE", "WSAENAMETOOLONG", "WSAENETDOWN", "WSAENETRESET", "WSAENETUNREACH", "WSAENOBUFS", "WSAENOPROTOOPT", "WSAENOTCONN", "WSAENOTEMPTY", "WSAENOTSOCK", "WSAEOPNOTSUPP", "WSAEPFNOSUPPORT", "WSAEPROCLIM", "WSAEPROTONOSUPPORT", "WSAEPROTOTYPE", "WSAEREMOTE", "WSAESHUTDOWN", "WSAESOCKTNOSUPPORT", "WSAESTALE", "WSAETIMEDOUT", "WSAETOOMANYREFS", "WSAEUSERS", "WSAEWOULDBLOCK", "WSANOTINITIALISED", "WSASYSNOTREADY", "WSAVERNOTSUPPORTED");
            this.addAttr("errorcode", this.liburl("errorcode"), this.this$0.newDict(this.this$0.BaseNum, this.this$0.BaseStr));
        }
    }

    class DbmModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public DbmModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "dbm");
        }

        @Override
        public void initBindings() {
            NClassType dbm = new NClassType("dbm", this.table, this.this$0.BaseDict);
            this.addClass("dbm", this.liburl(), dbm);
            this.addClass("error", this.liburl(), this.this$0.newException("error", this.table));
            this.addStrAttrs("library");
            this.addFunction("open", this.liburl(), dbm);
        }
    }

    class DatetimeModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public DatetimeModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "datetime");
        }

        private NUrl dtUrl(String anchor) {
            return this.liburl("datetime." + anchor);
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("MINYEAR", "MAXYEAR");
            NClassType timedelta = this.this$0.Datetime_timedelta = this.this$0.newClass("timedelta", this.table, this.this$0.Object, new NClassType[0]);
            this.addClass("timedelta", this.dtUrl("timedelta"), timedelta);
            Scope tdtable = this.this$0.Datetime_timedelta.getTable();
            tdtable.update("min", this.dtUrl("timedelta"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            tdtable.update("max", this.dtUrl("timedelta"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            tdtable.update("resolution", this.dtUrl("timedelta"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            tdtable.update("days", this.dtUrl("timedelta"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            tdtable.update("seconds", this.dtUrl("timedelta"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            tdtable.update("microseconds", this.dtUrl("timedelta"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            NClassType tzinfo = this.this$0.Datetime_tzinfo = this.this$0.newClass("tzinfo", this.table, this.this$0.Object, new NClassType[0]);
            this.addClass("tzinfo", this.dtUrl("tzinfo"), tzinfo);
            Scope tztable = this.this$0.Datetime_tzinfo.getTable();
            tztable.update("utcoffset", this.dtUrl("tzinfo"), (NType)this.this$0.newFunc(timedelta), NBinding.Kind.METHOD);
            tztable.update("dst", this.dtUrl("tzinfo"), (NType)this.this$0.newFunc(timedelta), NBinding.Kind.METHOD);
            tztable.update("tzname", this.dtUrl("tzinfo"), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            tztable.update("fromutc", this.dtUrl("tzinfo"), (NType)this.this$0.newFunc(tzinfo), NBinding.Kind.METHOD);
            NClassType date = this.this$0.Datetime_date = this.this$0.newClass("date", this.table, this.this$0.Object, new NClassType[0]);
            this.addClass("date", this.dtUrl("date"), date);
            Scope dtable = this.this$0.Datetime_date.getTable();
            dtable.update("min", this.dtUrl("date"), (NType)date, NBinding.Kind.ATTRIBUTE);
            dtable.update("max", this.dtUrl("date"), (NType)date, NBinding.Kind.ATTRIBUTE);
            dtable.update("resolution", this.dtUrl("date"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            dtable.update("today", this.dtUrl("date"), (NType)this.this$0.newFunc(date), NBinding.Kind.METHOD);
            dtable.update("fromtimestamp", this.dtUrl("date"), (NType)this.this$0.newFunc(date), NBinding.Kind.METHOD);
            dtable.update("fromordinal", this.dtUrl("date"), (NType)this.this$0.newFunc(date), NBinding.Kind.METHOD);
            dtable.update("year", this.dtUrl("date"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            dtable.update("month", this.dtUrl("date"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            dtable.update("day", this.dtUrl("date"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            dtable.update("replace", this.dtUrl("date"), (NType)this.this$0.newFunc(date), NBinding.Kind.METHOD);
            dtable.update("timetuple", this.dtUrl("date"), (NType)this.this$0.newFunc(this.this$0.Time_struct_time), NBinding.Kind.METHOD);
            for (String n : Builtins.list("toordinal", "weekday", "isoweekday")) {
                dtable.update(n, this.dtUrl("date"), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            }
            for (String r : Builtins.list("ctime", "strftime", "isoformat")) {
                dtable.update(r, this.dtUrl("date"), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            }
            dtable.update("isocalendar", this.dtUrl("date"), (NType)this.this$0.newFunc(this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum, this.this$0.BaseNum)), NBinding.Kind.METHOD);
            NClassType time = this.this$0.Datetime_time = this.this$0.newClass("time", this.table, this.this$0.Object, new NClassType[0]);
            this.addClass("time", this.dtUrl("time"), date);
            Scope ttable = this.this$0.Datetime_time.getTable();
            ttable.update("min", this.dtUrl("time"), (NType)time, NBinding.Kind.ATTRIBUTE);
            ttable.update("max", this.dtUrl("time"), (NType)time, NBinding.Kind.ATTRIBUTE);
            ttable.update("resolution", this.dtUrl("time"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            ttable.update("hour", this.dtUrl("time"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            ttable.update("minute", this.dtUrl("time"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            ttable.update("second", this.dtUrl("time"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            ttable.update("microsecond", this.dtUrl("time"), (NType)this.this$0.BaseNum, NBinding.Kind.ATTRIBUTE);
            ttable.update("tzinfo", this.dtUrl("time"), (NType)tzinfo, NBinding.Kind.ATTRIBUTE);
            ttable.update("replace", this.dtUrl("time"), (NType)this.this$0.newFunc(time), NBinding.Kind.METHOD);
            for (String l : Builtins.list("isoformat", "strftime", "tzname")) {
                ttable.update(l, this.dtUrl("time"), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            }
            for (String f : Builtins.list("utcoffset", "dst")) {
                ttable.update(f, this.dtUrl("time"), (NType)this.this$0.newFunc(timedelta), NBinding.Kind.METHOD);
            }
            NClassType datetime = this.this$0.Datetime_datetime = this.this$0.newClass("datetime", this.table, date, time);
            this.addClass("datetime", this.dtUrl("datetime"), datetime);
            Scope dttable = this.this$0.Datetime_datetime.getTable();
            for (String c : Builtins.list("combine", "fromordinal", "fromtimestamp", "now", "strptime", "today", "utcfromtimestamp", "utcnow")) {
                dttable.update(c, this.dtUrl("datetime"), (NType)this.this$0.newFunc(datetime), NBinding.Kind.METHOD);
            }
            dttable.update("min", this.dtUrl("datetime"), (NType)datetime, NBinding.Kind.ATTRIBUTE);
            dttable.update("max", this.dtUrl("datetime"), (NType)datetime, NBinding.Kind.ATTRIBUTE);
            dttable.update("resolution", this.dtUrl("datetime"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            dttable.update("date", this.dtUrl("datetime"), (NType)this.this$0.newFunc(date), NBinding.Kind.METHOD);
            for (String x : Builtins.list("time", "timetz")) {
                dttable.update(x, this.dtUrl("datetime"), (NType)this.this$0.newFunc(time), NBinding.Kind.METHOD);
            }
            for (String y : Builtins.list("replace", "astimezone")) {
                dttable.update(y, this.dtUrl("datetime"), (NType)this.this$0.newFunc(datetime), NBinding.Kind.METHOD);
            }
            dttable.update("utctimetuple", this.dtUrl("datetime"), (NType)this.this$0.newFunc(this.this$0.Time_struct_time), NBinding.Kind.METHOD);
        }
    }

    class CryptModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public CryptModule(Builtins builtins) {
            super(builtins, "crypt");
        }

        @Override
        public void initBindings() {
            this.addStrFuncs("crypt");
        }
    }

    class CTypesModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public CTypesModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "ctypes");
        }

        @Override
        public void initBindings() {
            String[] ctypes_attrs = new String[]{"ARRAY", "ArgumentError", "Array", "BigEndianStructure", "CDLL", "CFUNCTYPE", "DEFAULT_MODE", "DllCanUnloadNow", "DllGetClassObject", "FormatError", "GetLastError", "HRESULT", "LibraryLoader", "LittleEndianStructure", "OleDLL", "POINTER", "PYFUNCTYPE", "PyDLL", "RTLD_GLOBAL", "RTLD_LOCAL", "SetPointerType", "Structure", "Union", "WINFUNCTYPE", "WinDLL", "WinError", "_CFuncPtr", "_FUNCFLAG_CDECL", "_FUNCFLAG_PYTHONAPI", "_FUNCFLAG_STDCALL", "_FUNCFLAG_USE_ERRNO", "_FUNCFLAG_USE_LASTERROR", "_Pointer", "_SimpleCData", "_c_functype_cache", "_calcsize", "_cast", "_cast_addr", "_check_HRESULT", "_check_size", "_ctypes_version", "_dlopen", "_endian", "_memmove_addr", "_memset_addr", "_os", "_pointer_type_cache", "_string_at", "_string_at_addr", "_sys", "_win_functype_cache", "_wstring_at", "_wstring_at_addr", "addressof", "alignment", "byref", "c_bool", "c_buffer", "c_byte", "c_char", "c_char_p", "c_double", "c_float", "c_int", "c_int16", "c_int32", "c_int64", "c_int8", "c_long", "c_longdouble", "c_longlong", "c_short", "c_size_t", "c_ubyte", "c_uint", "c_uint16", "c_uint32", "c_uint64", "c_uint8", "c_ulong", "c_ulonglong", "c_ushort", "c_void_p", "c_voidp", "c_wchar", "c_wchar_p", "cast", "cdll", "create_string_buffer", "create_unicode_buffer", "get_errno", "get_last_error", "memmove", "memset", "oledll", "pointer", "py_object", "pydll", "pythonapi", "resize", "set_conversion_mode", "set_errno", "set_last_error", "sizeof", "string_at", "windll", "wstring_at"};
            String[] arr$ = ctypes_attrs;
            for (int i$ = 0; i$ < 107; ++i$) {
                String attr = arr$[i$];
                this.addAttr(attr, this.liburl(attr), this.this$0.unknown());
            }
        }
    }

    class CollectionsModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public CollectionsModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "collections");
        }

        private NUrl abcUrl() {
            return this.liburl("abcs-abstract-base-classes");
        }

        private NUrl dequeUrl() {
            return this.liburl("deque-objects");
        }

        @Override
        public void initBindings() {
            NClassType Callable2 = this.this$0.newClass("Callable", this.table, this.this$0.Object, new NClassType[0]);
            Callable2.getTable().update("__call__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Callable", this.abcUrl(), Callable2);
            NClassType Iterable2 = this.this$0.newClass("Iterable", this.table, this.this$0.Object, new NClassType[0]);
            Iterable2.getTable().update("__next__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            Iterable2.getTable().update("__iter__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Iterable", this.abcUrl(), Iterable2);
            NClassType Hashable = this.this$0.newClass("Hashable", this.table, this.this$0.Object, new NClassType[0]);
            Hashable.getTable().update("__hash__", this.abcUrl(), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Hashable", this.abcUrl(), Hashable);
            NClassType Sized = this.this$0.newClass("Sized", this.table, this.this$0.Object, new NClassType[0]);
            Sized.getTable().update("__len__", this.abcUrl(), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Sized", this.abcUrl(), Sized);
            NClassType Container2 = this.this$0.newClass("Container", this.table, this.this$0.Object, new NClassType[0]);
            Container2.getTable().update("__contains__", this.abcUrl(), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Container", this.abcUrl(), Container2);
            NClassType Iterator2 = this.this$0.newClass("Iterator", this.table, Iterable2, new NClassType[0]);
            this.addClass("Iterator", this.abcUrl(), Iterator2);
            NClassType Sequence = this.this$0.newClass("Sequence", this.table, Sized, Iterable2, Container2);
            Sequence.getTable().update("__getitem__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            Sequence.getTable().update("reversed", this.abcUrl(), (NType)this.this$0.newFunc(Sequence), NBinding.Kind.METHOD);
            Sequence.getTable().update("index", this.abcUrl(), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            Sequence.getTable().update("count", this.abcUrl(), (NType)this.this$0.newFunc(this.this$0.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Sequence", this.abcUrl(), Sequence);
            NClassType MutableSequence = this.this$0.newClass("MutableSequence", this.table, Sequence, new NClassType[0]);
            MutableSequence.getTable().update("__setitem__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            MutableSequence.getTable().update("__delitem__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableSequence", this.abcUrl(), MutableSequence);
            NClassType Set2 = this.this$0.newClass("Set", this.table, Sized, Iterable2, Container2);
            Set2.getTable().update("__getitem__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Set", this.abcUrl(), Set2);
            NClassType MutableSet = this.this$0.newClass("MutableSet", this.table, Set2, new NClassType[0]);
            MutableSet.getTable().update("add", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            MutableSet.getTable().update("discard", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableSet", this.abcUrl(), MutableSet);
            NClassType Mapping = this.this$0.newClass("Mapping", this.table, Sized, Iterable2, Container2);
            Mapping.getTable().update("__getitem__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Mapping", this.abcUrl(), Mapping);
            NClassType MutableMapping = this.this$0.newClass("MutableMapping", this.table, Mapping, new NClassType[0]);
            MutableMapping.getTable().update("__setitem__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            MutableMapping.getTable().update("__delitem__", this.abcUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableMapping", this.abcUrl(), MutableMapping);
            NClassType MappingView = this.this$0.newClass("MappingView", this.table, Sized, new NClassType[0]);
            this.addClass("MappingView", this.abcUrl(), MappingView);
            NClassType KeysView = this.this$0.newClass("KeysView", this.table, Sized, new NClassType[0]);
            this.addClass("KeysView", this.abcUrl(), KeysView);
            NClassType ItemsView = this.this$0.newClass("ItemsView", this.table, Sized, new NClassType[0]);
            this.addClass("ItemsView", this.abcUrl(), ItemsView);
            NClassType ValuesView2 = this.this$0.newClass("ValuesView", this.table, Sized, new NClassType[0]);
            this.addClass("ValuesView", this.abcUrl(), ValuesView2);
            NClassType deque = this.this$0.newClass("deque", this.table, this.this$0.Object, new NClassType[0]);
            for (String n : Builtins.list("append", "appendLeft", "clear", "extend", "extendLeft", "rotate")) {
                deque.getTable().update(n, this.dequeUrl(), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.METHOD);
            }
            for (String u : Builtins.list("__getitem__", "__iter__", "pop", "popleft", "remove")) {
                deque.getTable().update(u, this.dequeUrl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            }
            this.addClass("deque", this.dequeUrl(), deque);
            NClassType defaultdict = this.this$0.newClass("defaultdict", this.table, this.this$0.Object, new NClassType[0]);
            defaultdict.getTable().update("__missing__", this.liburl("defaultdict-objects"), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            defaultdict.getTable().update("default_factory", this.liburl("defaultdict-objects"), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("defaultdict", this.liburl("defaultdict-objects"), defaultdict);
            String argh = "namedtuple-factory-function-for-tuples-with-named-fields";
            NClassType namedtuple = this.this$0.newClass("(namedtuple)", this.table, this.this$0.BaseTuple, new NClassType[0]);
            namedtuple.getTable().update("_fields", this.liburl(argh), (NType)new NListType(this.this$0.BaseStr), NBinding.Kind.ATTRIBUTE);
            this.addFunction("namedtuple", this.liburl(argh), namedtuple);
        }
    }

    class CMathModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public CMathModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "cmath");
        }

        @Override
        public void initBindings() {
            this.addFunction("phase", this.liburl("conversions-to-and-from-polar-coordinates"), this.this$0.BaseNum);
            this.addFunction("polar", this.liburl("conversions-to-and-from-polar-coordinates"), this.this$0.newTuple(this.this$0.BaseNum, this.this$0.BaseNum));
            this.addFunction("rect", this.liburl("conversions-to-and-from-polar-coordinates"), this.this$0.BaseComplex);
            for (String plf : Builtins.list("exp", "log", "log10", "sqrt")) {
                this.addFunction(plf, this.liburl("power-and-logarithmic-functions"), this.this$0.BaseNum);
            }
            for (String tf : Builtins.list("acos", "asin", "atan", "cos", "sin", "tan")) {
                this.addFunction(tf, this.liburl("trigonometric-functions"), this.this$0.BaseNum);
            }
            for (String hf : Builtins.list("acosh", "asinh", "atanh", "cosh", "sinh", "tanh")) {
                this.addFunction(hf, this.liburl("hyperbolic-functions"), this.this$0.BaseComplex);
            }
            for (String cf : Builtins.list("isinf", "isnan")) {
                this.addFunction(cf, this.liburl("classification-functions"), this.this$0.BaseBool);
            }
            for (String c : Builtins.list("pi", "e")) {
                this.addAttr(c, this.liburl("constants"), this.this$0.BaseNum);
            }
        }
    }

    class CStringIOModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public CStringIOModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "cStringIO");
        }

        @Override
        protected NUrl liburl() {
            return Builtins.newLibUrl("stringio");
        }

        @Override
        protected NUrl liburl(String anchor) {
            return Builtins.newLibUrl("stringio", anchor);
        }

        @Override
        public void initBindings() {
            NClassType StringIO2 = this.this$0.newClass("StringIO", this.table, this.this$0.BaseFile, new NClassType[0]);
            this.addFunction("StringIO", this.liburl(), StringIO2);
            this.addAttr("InputType", this.liburl(), this.this$0.Type);
            this.addAttr("OutputType", this.liburl(), this.this$0.Type);
            this.addAttr("cStringIO_CAPI", this.liburl(), this.this$0.unknown());
        }
    }

    class CPickleModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public CPickleModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "cPickle");
        }

        @Override
        protected NUrl liburl() {
            return Builtins.newLibUrl("pickle", "module-cPickle");
        }

        @Override
        public void initBindings() {
            this.addUnknownFuncs("dump", "load", "dumps", "loads");
            this.addClass("PickleError", this.liburl(), this.this$0.newException("PickleError", this.table));
            NClassType picklingError = this.this$0.newException("PicklingError", this.table);
            this.addClass("PicklingError", this.liburl(), picklingError);
            this.update("UnpickleableError", this.liburl(), this.this$0.newClass("UnpickleableError", this.table, picklingError, new NClassType[0]), NBinding.Kind.CLASS);
            NClassType unpicklingError = this.this$0.newException("UnpicklingError", this.table);
            this.addClass("UnpicklingError", this.liburl(), unpicklingError);
            this.update("BadPickleGet", this.liburl(), this.this$0.newClass("BadPickleGet", this.table, unpicklingError, new NClassType[0]), NBinding.Kind.CLASS);
            NClassType pickler = this.this$0.newClass("Pickler", this.table, this.this$0.Object, new NClassType[0]);
            pickler.getTable().update("dump", this.liburl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            pickler.getTable().update("clear_memo", this.liburl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Pickler", this.liburl(), pickler);
            NClassType unpickler = this.this$0.newClass("Unpickler", this.table, this.this$0.Object, new NClassType[0]);
            unpickler.getTable().update("load", this.liburl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            unpickler.getTable().update("noload", this.liburl(), (NType)this.this$0.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Unpickler", this.liburl(), unpickler);
        }
    }

    class Bz2Module
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public Bz2Module(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "bz2");
        }

        @Override
        public void initBindings() {
            NClassType bz22 = this.this$0.newClass("BZ2File", this.table, this.this$0.BaseFile, new NClassType[0]);
            this.addClass("BZ2File", this.liburl(), bz22);
            NClassType bz2c = this.this$0.newClass("BZ2Compressor", this.table, this.this$0.Object, new NClassType[0]);
            bz2c.getTable().update("compress", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            bz2c.getTable().update("flush", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)this.this$0.newFunc(this.this$0.None), NBinding.Kind.METHOD);
            this.addClass("BZ2Compressor", Builtins.newLibUrl("bz2", "sequential-de-compression"), bz2c);
            NClassType bz2d = this.this$0.newClass("BZ2Decompressor", this.table, this.this$0.Object, new NClassType[0]);
            bz2d.getTable().update("decompress", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)this.this$0.newFunc(this.this$0.BaseStr), NBinding.Kind.METHOD);
            this.addClass("BZ2Decompressor", Builtins.newLibUrl("bz2", "sequential-de-compression"), bz2d);
            this.addFunction("compress", Builtins.newLibUrl("bz2", "one-shot-de-compression"), this.this$0.BaseStr);
            this.addFunction("decompress", Builtins.newLibUrl("bz2", "one-shot-de-compression"), this.this$0.BaseStr);
        }
    }

    class BinasciiModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public BinasciiModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "binascii");
        }

        @Override
        public void initBindings() {
            this.addStrFuncs("a2b_uu", "b2a_uu", "a2b_base64", "b2a_base64", "a2b_qp", "b2a_qp", "a2b_hqx", "rledecode_hqx", "rlecode_hqx", "b2a_hqx", "b2a_hex", "hexlify", "a2b_hex", "unhexlify");
            this.addNumFuncs("crc_hqx", "crc32");
            this.addClass("Error", this.liburl(), this.this$0.newException("Error", this.table));
            this.addClass("Incomplete", this.liburl(), this.this$0.newException("Incomplete", this.table));
        }
    }

    class AudioopModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public AudioopModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "audioop");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), this.this$0.newException("error", this.table));
            this.addStrFuncs("add", "adpcm2lin", "alaw2lin", "bias", "lin2alaw", "lin2lin", "lin2ulaw", "mul", "reverse", "tomono", "ulaw2lin");
            this.addNumFuncs("avg", "avgpp", "cross", "findfactor", "findmax", "getsample", "max", "maxpp", "rms");
            for (String s : Builtins.list("adpcm2lin", "findfit", "lin2adpcm", "minmax", "ratecv")) {
                this.addFunction(s, this.liburl(), this.this$0.newTuple(new NType[0]));
            }
        }
    }

    class ArrayModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public ArrayModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "array");
        }

        @Override
        public void initBindings() {
            this.addClass("array", Builtins.newLibUrl("array", "array"), this.this$0.BaseArray);
            this.addClass("ArrayType", Builtins.newLibUrl("array", "ArrayType"), this.this$0.BaseArray);
        }
    }

    class BuiltinsModule
    extends NativeModule {
        private /* synthetic */ Builtins this$0;

        public BuiltinsModule(Builtins builtins) {
            this.this$0 = builtins;
            super(builtins, "__builtin__");
            builtins.Builtin = this.module = builtins.newModule(this.name);
            this.table = this.module.getTable();
        }

        @Override
        public void initBindings() {
            String f3;
            int i$;
            this.this$0.moduleTable.put(this.name, this.liburl(), this.module, NBinding.Kind.MODULE);
            this.table.addSuper(this.this$0.BaseModule.getTable());
            this.addClass("None", Builtins.newLibUrl("constants"), this.this$0.None);
            this.addClass("bool", Builtins.newLibUrl("functions", "bool"), this.this$0.BaseBool);
            this.addClass("complex", Builtins.newLibUrl("functions", "complex"), this.this$0.BaseComplex);
            this.addClass("dict", Builtins.newLibUrl("stdtypes", "typesmapping"), this.this$0.BaseDict);
            this.addClass("file", Builtins.newLibUrl("functions", "file"), this.this$0.BaseFile);
            this.addClass("float", Builtins.newLibUrl("functions", "float"), this.this$0.BaseNum);
            this.addClass("int", Builtins.newLibUrl("functions", "int"), this.this$0.BaseNum);
            this.addClass("list", Builtins.newLibUrl("functions", "list"), this.this$0.BaseList);
            this.addClass("long", Builtins.newLibUrl("functions", "long"), this.this$0.BaseNum);
            this.addClass("object", Builtins.newLibUrl("functions", "object"), this.this$0.Object);
            this.addClass("str", Builtins.newLibUrl("functions", "str"), this.this$0.BaseStr);
            this.addClass("tuple", Builtins.newLibUrl("functions", "tuple"), this.this$0.BaseTuple);
            this.addClass("type", Builtins.newLibUrl("functions", "type"), this.this$0.Type);
            String[] builtin_func_unknown = new String[]{"apply", "basestring", "callable", "classmethod", "coerce", "compile", "copyright", "credits", "delattr", "enumerate", "eval", "execfile", "exit", "filter", "frozenset", "getattr", "help", "input", "int", "intern", "iter", "license", "long", "property", "quit", "raw_input", "reduce", "reload", "reversed", "set", "setattr", "slice", "sorted", "staticmethod", "super", "type", "unichr", "unicode"};
            String[] arr$ = builtin_func_unknown;
            for (int i$2 = 0; i$2 < 38; ++i$2) {
                String f2 = arr$[i$2];
                this.addFunction(f2, Builtins.newLibUrl("functions.html#" + f2), this.this$0.unknown());
            }
            String[] builtin_func_num = new String[]{"abs", "all", "any", "cmp", "coerce", "divmod", "hasattr", "hash", "id", "isinstance", "issubclass", "len", "max", "min", "ord", "pow", "round", "sum"};
            String[] arr$2 = builtin_func_num;
            for (i$ = 0; i$ < 18; ++i$) {
                f3 = arr$2[i$];
                this.addFunction(f3, Builtins.newLibUrl("functions.html#" + f3), this.this$0.BaseNum);
            }
            for (String f3 : Builtins.list("hex", "oct", "repr", "chr")) {
                this.addFunction(f3, Builtins.newLibUrl("functions.html#" + f3), this.this$0.BaseStr);
            }
            this.addFunction("dir", Builtins.newLibUrl("functions", "dir"), this.this$0.newList(this.this$0.BaseStr));
            this.addFunction("map", Builtins.newLibUrl("functions", "map"), this.this$0.newList(this.this$0.unknown()));
            this.addFunction("range", Builtins.newLibUrl("functions", "range"), this.this$0.newList(this.this$0.BaseNum));
            this.addFunction("xrange", Builtins.newLibUrl("functions", "range"), this.this$0.newList(this.this$0.BaseNum));
            this.addFunction("buffer", Builtins.newLibUrl("functions", "buffer"), this.this$0.newList(this.this$0.unknown()));
            this.addFunction("zip", Builtins.newLibUrl("functions", "zip"), this.this$0.newList(this.this$0.newTuple(this.this$0.unknown())));
            for (String f3 : Builtins.list("globals", "vars", "locals")) {
                this.addFunction(f3, Builtins.newLibUrl("functions.html#" + f3), this.this$0.newDict(this.this$0.BaseStr, this.this$0.unknown()));
            }
            arr$2 = this.this$0.builtin_exception_types;
            int len$ = this.this$0.builtin_exception_types.length;
            for (i$ = 0; i$ < len$; ++i$) {
                f3 = arr$2[i$];
                this.addClass(f3, Builtins.newDataModelUrl("types"), this.this$0.newClass(f3, this.this$0.globaltable, this.this$0.Object, new NClassType[0]));
            }
            this.this$0.BaseException = (NClassType)this.table.lookup("BaseException").getType();
            for (String f3 : Builtins.list("True", "False", "None", "Ellipsis")) {
                this.addAttr(f3, Builtins.newDataModelUrl("types"), this.this$0.unknown());
            }
            this.addFunction("open", Builtins.newTutUrl("inputoutput.html#reading-and-writing-files"), this.this$0.BaseFile);
            this.addFunction("__import__", Builtins.newLibUrl("functions"), this.this$0.newModule("<?>"));
            this.this$0.globaltable.put("__builtins__", this.liburl(), this.module, NBinding.Kind.ATTRIBUTE);
            this.this$0.globaltable.merge(this.table);
        }
    }

    abstract class NativeModule {
        protected String name;
        protected NModuleType module;
        protected Scope table;
        private /* synthetic */ Builtins this$0;

        NativeModule(Builtins builtins, String name) {
            this.this$0 = builtins;
            this.name = name;
            builtins.modules.put(name, this);
        }

        final NModuleType getModule() {
            if (this.module == null) {
                this.createModuleType();
                this.initBindings();
            }
            return this.module;
        }

        protected abstract void initBindings();

        protected void createModuleType() {
            if (this.module == null) {
                this.module = this.this$0.newModule(this.name);
                this.table = this.module.getTable();
                this.this$0.moduleTable.put(this.name, this.liburl(), this.module, NBinding.Kind.MODULE);
            }
        }

        protected NBinding update(String name, NUrl url, NType type, NBinding.Kind kind) {
            return this.table.update(name, url, type, kind);
        }

        protected NBinding addClass(String name, NUrl url, NType type) {
            return this.table.update(name, url, type, NBinding.Kind.CLASS);
        }

        protected NBinding addMethod(String name, NUrl url, NType type) {
            return this.table.update(name, url, type, NBinding.Kind.METHOD);
        }

        protected NBinding addFunction(String name, NUrl url, NType type) {
            return this.table.update(name, url, (NType)this.this$0.newFunc(type), NBinding.Kind.FUNCTION);
        }

        protected void addFunctions_beCareful(NType type, String ... names) {
            String[] arr$ = names;
            int len$ = names.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name = arr$[i$];
                this.addFunction(name, this.liburl(), type);
            }
        }

        protected void addNoneFuncs(String ... names) {
            this.addFunctions_beCareful(this.this$0.None, names);
        }

        protected void addNumFuncs(String ... names) {
            this.addFunctions_beCareful(this.this$0.BaseNum, names);
        }

        protected void addStrFuncs(String ... names) {
            this.addFunctions_beCareful(this.this$0.BaseStr, names);
        }

        protected void addUnknownFuncs(String ... names) {
            String[] arr$ = names;
            int len$ = names.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name = arr$[i$];
                this.addFunction(name, this.liburl(), this.this$0.unknown());
            }
        }

        protected NBinding addAttr(String name, NUrl url, NType type) {
            return this.table.update(name, url, type, NBinding.Kind.ATTRIBUTE);
        }

        protected void addAttributes_beCareful(NType type, String ... names) {
            String[] arr$ = names;
            int len$ = names.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name = arr$[i$];
                this.addAttr(name, this.liburl(), type);
            }
        }

        protected void addNumAttrs(String ... names) {
            this.addAttributes_beCareful(this.this$0.BaseNum, names);
        }

        protected void addStrAttrs(String ... names) {
            this.addAttributes_beCareful(this.this$0.BaseStr, names);
        }

        protected void addUnknownAttrs(String ... names) {
            String[] arr$ = names;
            int len$ = names.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name = arr$[i$];
                this.addAttr(name, this.liburl(), this.this$0.unknown());
            }
        }

        protected NUrl liburl() {
            return Builtins.newLibUrl(this.name);
        }

        protected NUrl liburl(String anchor) {
            return Builtins.newLibUrl(this.name, anchor);
        }

        public String toString() {
            if (this.module == null) {
                return "<Non-loaded builtin module '" + this.name + "'>";
            }
            return "<NativeModule:" + this.module + ">";
        }
    }
}

