/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import java.util.concurrent.TimeUnit;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Ticker;

public final class Stopwatch {
    private final Ticker ticker;
    private boolean isRunning;
    private long startTick;

    public Stopwatch() {
        this(Ticker.systemTicker());
    }

    private Stopwatch(Ticker ticker) {
        this.ticker = CharMatcher.LookupTable.checkNotNull(ticker);
    }

    public final Stopwatch start() {
        CharMatcher.LookupTable.checkState(!this.isRunning);
        this.isRunning = true;
        this.startTick = this.ticker.read();
        return this;
    }

    private long elapsedNanos() {
        if (this.isRunning) {
            return this.ticker.read() - this.startTick;
        }
        return 0L;
    }

    public final long elapsedTime(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public final String toString() {
        String string;
        int n = 4;
        Stopwatch stopwatch = this;
        long l = stopwatch.elapsedNanos();
        long l2 = l;
        TimeUnit timeUnit = TimeUnit.SECONDS.convert(l2, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.SECONDS : (TimeUnit.MILLISECONDS.convert(l2, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.MILLISECONDS : (TimeUnit.MICROSECONDS.convert(l2, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.MICROSECONDS : TimeUnit.NANOSECONDS));
        double d = (double)l / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        String string2 = "%." + 4 + "g %s";
        Object[] objectArray = new Object[2];
        objectArray[0] = d;
        TimeUnit timeUnit2 = timeUnit;
        switch (timeUnit2) {
            case NANOSECONDS: {
                string = "ns";
                break;
            }
            case MICROSECONDS: {
                string = "\u03bcs";
                break;
            }
            case MILLISECONDS: {
                string = "ms";
                break;
            }
            case SECONDS: {
                string = "s";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        objectArray[1] = string;
        return String.format(string2, objectArray);
    }
}

