/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NExceptHandler
extends NNode {
    private NNode name;
    private NNode exceptionType;
    private NBlock body;

    public NExceptHandler(NNode name, NNode exceptionType, NBlock body) {
        this(null, null, null, 0, 1);
    }

    public NExceptHandler(NNode name, NNode exceptionType, NBlock body, int start, int end) {
        super(start, end);
        this.name = name;
        this.exceptionType = exceptionType;
        this.body = body;
        this.addChildren(name, exceptionType, body);
    }

    @Override
    public final boolean bindsName() {
        return true;
    }

    @Override
    protected final void bindNames(Scope s) throws Exception {
        if (this.name != null) {
            NameBinder.make().bind(s, this.name, (NType)new NUnknownType());
        }
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NType typeval = new NUnknownType();
        if (this.exceptionType != null) {
            typeval = NExceptHandler.resolveExpr(this.exceptionType, s);
        }
        if (this.name != null) {
            NameBinder.make().bind(s, this.name, typeval);
        }
        if (this.body != null) {
            return this.setType(NExceptHandler.resolveExpr(this.body, s));
        }
        return this.setType(new NUnknownType());
    }

    public final String toString() {
        return "<ExceptHandler:" + this.start() + ":" + this.name + ":" + this.exceptionType + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NExceptHandler.visitNode(this.name, v);
            NExceptHandler.visitNode(this.exceptionType, v);
            NExceptHandler.visitNode(this.body, v);
        }
    }
}

